Here is a list (alpha sorted) of templates which are available for use with `dotnet new`

# C# Templates


| Name     | Quick Install |
|----------|:--------------|
| [.NET Boxed](https://github.com/Dotnet-Boxed/Templates) | `dotnet new -i "Boxed.Templates::*"`|
| [Auth0 Templates](https://github.com/auth0-community/auth0-dotnet-templates) | `dotnet new -i "Auth0.Templates::*"` |
| [AWS Lambda .NET Core Templates](https://github.com/aws/aws-lambda-dotnet/tree/master/Blueprints) | `dotnet new -i "Amazon.Lambda.Templates::*"`|
| [Avalonia UI Templates](https://github.com/AvaloniaUI/Avalonia) - Avalonia is a framework for creating cross platform UI | `dotnet new -i "Avalonia.Templates::*"`|
| [Blazor](http://blazor.net) - Full stack web development with C# and WebAssembly | `dotnet new -i "Microsoft.AspNetCore.Blazor.Templates::3.0.0-*"`|
| [Cake.Frosting](https://github.com/cake-build/cake) | `dotnet new -i "Cake.Frosting.Template::*"` |
| [Carter](https://github.com/CarterCommunity/Carter) - Carter is a library that allows Nancy-esque routing for use with ASP.Net Core. | `dotnet new -i "CarterTemplate::*"`|
| [cloudscribe](https://www.cloudscribe.com/docs/introduction) | `dotnet new -i "cloudscribe.templates::*"` |
| [DotVVM](https://github.com/riganti/dotvvm) - Open source MVVM framework for line of business web applications | `dotnet new -i "DotVVM.Templates::*"` |
| [Eto.Forms](https://github.com/picoe/Eto) | `dotnet new -i "Eto.Forms.Templates::*"` |
| [GCC.Build](https://github.com/roozbehid/dotnet-vcxproj) - C/C++/CPP/VCXPROJ Build Template using GCC/G++/EMCC or your favorate compiler | `dotnet new -i GCC.Build.Template` |
| [Geco](https://github.com/iQuarc/Geco) - C# 6 Interpolated strings based Code Generator | `dotnet new -i "iQuarc.Geco.CSharp::*"` |
| [GtkSharp](https://github.com/GtkSharp/GtkSharp) | `dotnet new -i "GtkSharp.Template.CSharp"` |
| [IdentityServer4.Templates](https://github.com/IdentityServer/IdentityServer4.Templates) | `dotnet new -i "identityserver4.templates::*"` |
| [Kentico Cloud Boilerplate](https://github.com/Kentico/cloud-boilerplate-net) | `dotnet new -i "KenticoCloud.CloudBoilerplateNet::*"` |
| [MonoGame (.NET Core)](https://github.com/MonoGame/MonoGame) | `dotnet new -i "MonoGame.Templates.CSharp"` |
| [MSBuild extension](https://github.com/tintoy/msbuild-extension-template) | `dotnet new -i "MSBuildExtensionTemplate::*"` |
| [MvxScaffolding Templates](https://github.com/Plac3hold3r/MvxScaffolding) - MvvmCross Xamarin native and Xamarin Forms templates. | `dotnet new -i "MvxScaffolding.Templates::*"` |
| [NancyFX Template](https://github.com/jchannon/NancyTemplate) | not on nuget.org |
| [NSpec Templates](https://github.com/nspec/DotNetNewNSpec) | `dotnet new -i "dotnet-new-nspec::*"` |
| [NUnit 3 Test Project Template](https://github.com/nunit/dotnet-new-nunit) | `dotnet new -i "NUnit3.DotNetNew.Template::*"` |
| [Paulovich.Caju](https://github.com/ivanpaulovich/dotnet-new-caju) - .NET applications with Event Sourcing, Hexagonal or Clean Architectures styles | `dotnet new -i "Paulovich.Caju::*"` |
| [Paulovich.Manga](https://github.com/ivanpaulovich/manga-clean-architecture) - Clean Architecture for .NET Applications! | `dotnet new -i "Paulovich.Manga::*"` |
| [Particular Templates](https://docs.particular.net/nservicebus/dotnet-templates) - Templates targeting NServiceBus and other tools and libraries from [Particular Software](https://particular.net/) | `dotnet new -i "ParticularTemplates::*"` |
| [Pioneer Console Boilerplate](https://github.com/PioneerCode/pioneer-console-boilerplate) - Boilerplated .NET Core console application that includes dependency injection, logging and configuration. | `dotnet new -i "Pioneer.Console.Boilerplate::*"` |
| [PowerShell Core](https://github.com/tintoy/ps-core-module-template) | `dotnet new -i "FiftyProtons.Templates.PSCore::*"` |
| [Prism Forms QuickStarts](https://github.com/dansiegel/Prism-Templates) - Empty &amp; QuickStart project Templates for Prism for Xamarin Forms. *Requires dotnet cli 2.0 pre3+* | `dotnet new -i "Prism.Forms.QuickstartTemplates::*"` |
| [Raspberry Pi 3](https://github.com/jeremylindsayni/RaspberryPiTemplate) - C# template for .NET Core 2 IoT applications. | `dotnet new -i "RaspberryPi.Template::*"` |
| [ServiceStack](https://github.com/NetCoreApps/templates) | `dotnet new -i "ServiceStack.Core.Templates::*"` |
| [SpecFlow.Templates.DotNet](https://github.com/SpecFlowOSS/SpecFlow) - A project template for creating executable specifications with SpecFlow. You can choose from different .NET frameworks and test frameworks. |`dotnet new -i "SpecFlow.Templates.DotNet::*"` |
| [Template templates](https://github.com/tintoy/dotnet-template-templates) - Templates to create new project and item templates. Requires `new3`. | `dotnet new -i "FiftyProtons.Templates.DotNetNew::*"` |
| [Zahasoft Templates](https://github.com/zahasoft/skele) | `dotnet new -i "Zahasoft.Skele::*"` |
| [ASP.NET Core Web API (extended)](https://github.com/popov1024/httpapi-template-sharp) | `dotnet new -i "Popov1024.HttpApi.Template.CSharp::*"` |
| [ASP.NET Core Web API for AKS](https://github.com/robbell/dotnet-aks-api-template) - A template for creating a fully-featured, 12 Factor, ASP.NET Core Web API for AKS | `dotnet new -i "RobBell.AksApi.Template::*"` |
| [HoNoSoFt.DotNet.Web.Spa.ProjectTemplates (VueJs + Picnic CSS)](https://github.com/Nordes/HoNoSoFt.DotNet.Web.Spa.ProjectTemplates) | `dotnet new -i "HoNoSoFt.DotNet.Web.Spa.ProjectTemplates::*"` |
| [xUnit Test Template](https://github.com/gatewayprogrammingschool/xUnit.Template) - Adds a xUnit test file to an existing test project. | `dotnet new -i GatewayProgrammingSchool.xUnit.CSharp`|
[RocketMod Plugin Templates](https://github.com/RocketMod/Rocket.Templates) RocketMod is a plugin framework for .NET based games. This template allows to quickly get started with a new RocketMod Plugin.| `dotnet new -i "Rocket.Templates::*"` |
| [EISK Web Api](https://github.com/eisk/eisk.webapi) - ASP.NET Core templates with simple use cases to build scalable web api with architectural best practices (DDD, Onion Architecture etc). | `dotnet new -i "eisk.webapi::*"` |
|[OpenMod Plugin Templates](https://github.com/openmod/openmod/tree/master/templates) - OpenMod is .NET plugin framework. These templates allow user to quickly get started with a new OpenMod Plugin.| `dotnet new -i "OpenMod.Templates::*"` |

# F# Templates

| Name     | Quick Install |
|----------|:--------------|
| [ASP.NET Core WebAPI F# Template](https://github.com/MNie/FSharpNetCoreWebApiTemplate) | `dotnet new -i "WebAPI.FSharp.Template::*"` |
| [Bolero: F# in WebAssembly](https://fsbolero.io/)| `dotnet new -i Bolero.Templates`|
| [Eto.Forms](https://github.com/picoe/Eto) | `dotnet new -i "Eto.Forms.Templates::*"` |
| [Expecto Template](https://github.com/MNie/Expecto.Template) | `dotnet new -i "Expecto.Template::*"`|
| [F# TypeProvider Template](https://github.com/fsprojects/FSharp.TypeProviders.SDK#the-f-type-provider-sdk)| `dotnet new -i FSharp.TypeProviders.Templates`|
| [Fable-elmish](https://github.com/fable-compiler/fable-elmish) | `dotnet new -i "Fable.Template.Elmish.React::*"` |
| [Fable, F# \|> Babel](http://fable.io) | `dotnet new -i "Fable.Template::*"` |
| [Fable Library](https://github.com/TheAngryByrd/Fable.Template.Library) - F# Template for creating and publishing Fable libraries | `dotnet new -i "Fable.Template.Library::*"` |
| [Fabulous for Xamarin.Forms](https://github.com/fsprojects/Fabulous/tree/master/Fabulous.XamarinForms)| `dotnet new -i Fabulous.XamarinForms.Templates`|
| [Freya](https://freya.io) | `dotnet new --install "Freya.Template::*"` |
| [Giraffe Template](https://github.com/giraffe-fsharp/giraffe-template) | `dotnet new -i "giraffe-template::*"` |
| [GtkSharp](https://github.com/GtkSharp/GtkSharp) | `dotnet new -i "GtkSharp.Template.FSharp"` |
| [Interstellar](https://github.com/fsprojects/Interstellar) | `dotnet new -i "Interstellar.Template"` |
| [MiniScaffold](https://github.com/TheAngryByrd/MiniScaffold) - F# Template for creating and publishing libraries targeting .NET Full (net45) and Core (netstandard1.6) | `dotnet new -i "MiniScaffold::*"` |
| [NancyFx](https://github.com/MNie/NancyFxCore)| `dotnet new -i "NancyFx.Core.Template::*"`|
| [SAFE Template](https://safe-stack.github.io/)| `dotnet new -i "SAFE.Template::*"`|
| [vbfox's F# Templates](https://github.com/vbfox/FSharpTemplates)| `dotnet new -i "BlackFox.DotnetNew.FSharpTemplates::*"`|
| [WebSharper](https://github.com/dotnet-websharper/core)| `dotnet new -i "WebSharper.Templates::*"`

# VBNet Templates

| Name     | Quick Install |
|----------|:--------------|
| [GtkSharp](https://github.com/GtkSharp/GtkSharp) | `dotnet new -i "GtkSharp.Template.VBNet"` |
| [InteXX Assorted Templates](https://github.com/InteXX/Templates) | `dotnet new -i "Intexx.Templates"` |
