/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2014-2021 Broadcom
 * All rights reserved.
 */

/* date: Fri Nov 12 19:33:52 2021 */

#ifndef ULP_TEMPLATE_DB_H_
#define ULP_TEMPLATE_DB_H_

#define BNXT_ULP_REGFILE_MAX_SZ 46
#define BNXT_ULP_MAX_NUM_DEVICES 4
#define BNXT_ULP_LOG2_MAX_NUM_DEV 2
#define BNXT_ULP_GEN_TBL_MAX_SZ 18
#define BNXT_ULP_CLASS_SIG_TBL_MAX_SZ 65536
#define BNXT_ULP_CLASS_MATCH_LIST_MAX_SZ 993
#define BNXT_ULP_CLASS_HID_LOW_PRIME 6701
#define BNXT_ULP_CLASS_HID_HIGH_PRIME 7907
#define BNXT_ULP_CLASS_HID_SHFTR 28
#define BNXT_ULP_CLASS_HID_SHFTL 28
#define BNXT_ULP_CLASS_HID_MASK 65535
#define BNXT_ULP_ACT_SIG_TBL_MAX_SZ 2048
#define BNXT_ULP_ACT_MATCH_LIST_MAX_SZ 94
#define BNXT_ULP_ACT_HID_LOW_PRIME 7919
#define BNXT_ULP_ACT_HID_HIGH_PRIME 3793
#define BNXT_ULP_ACT_HID_SHFTR 27
#define BNXT_ULP_ACT_HID_SHFTL 26
#define BNXT_ULP_ACT_HID_MASK 2047
#define BNXT_ULP_APP_RESOURCE_RESV_LIST_MAX_SZ 16
#define BNXT_ULP_GLB_RESOURCE_TBL_MAX_SZ 132
#define BNXT_ULP_APP_GLB_RESOURCE_TBL_MAX_SZ 144
#define BNXT_ULP_RESOURCE_RESV_LIST_MAX_SZ 409
#define BNXT_ULP_APP_CAP_TBL_MAX_SZ 12
#define BNXT_ULP_COND_GOTO_REJECT 1023
#define BNXT_ULP_COND_GOTO_RF 0x10000
#define BNXT_ULP_GLB_FIELD_TBL_SHIFT 7
#define BNXT_ULP_HDR_SIG_ID_SHIFT 4
#define BNXT_ULP_APP_ID_SHIFT 4
#define BNXT_ULP_GLB_FIELD_TBL_SIZE 7643
#define ULP_WH_PLUS_CLASS_TMPL_LIST_SIZE 6
#define ULP_WH_PLUS_CLASS_TBL_LIST_SIZE 89
#define ULP_WH_PLUS_CLASS_KEY_INFO_LIST_SIZE 600
#define ULP_WH_PLUS_CLASS_IDENT_LIST_SIZE 26
#define ULP_WH_PLUS_CLASS_RESULT_FIELD_LIST_SIZE 618
#define ULP_WH_PLUS_CLASS_COND_LIST_SIZE 49
#define ULP_THOR_CLASS_TMPL_LIST_SIZE 6
#define ULP_THOR_CLASS_TBL_LIST_SIZE 116
#define ULP_THOR_CLASS_KEY_INFO_LIST_SIZE 2323
#define ULP_THOR_CLASS_IDENT_LIST_SIZE 38
#define ULP_THOR_CLASS_RESULT_FIELD_LIST_SIZE 1313
#define ULP_THOR_CLASS_COND_LIST_SIZE 54
#define ULP_WH_PLUS_ACT_TMPL_LIST_SIZE 7
#define ULP_WH_PLUS_ACT_TBL_LIST_SIZE 37
#define ULP_WH_PLUS_ACT_KEY_INFO_LIST_SIZE 2
#define ULP_WH_PLUS_ACT_IDENT_LIST_SIZE 1
#define ULP_WH_PLUS_ACT_RESULT_FIELD_LIST_SIZE 536
#define ULP_WH_PLUS_ACT_COND_LIST_SIZE 41
#define ULP_THOR_ACT_TMPL_LIST_SIZE 7
#define ULP_THOR_ACT_TBL_LIST_SIZE 36
#define ULP_THOR_ACT_KEY_INFO_LIST_SIZE 16
#define ULP_THOR_ACT_IDENT_LIST_SIZE 3
#define ULP_THOR_ACT_RESULT_FIELD_LIST_SIZE 505
#define ULP_THOR_ACT_COND_LIST_SIZE 27

enum bnxt_ulp_act_bit {
	BNXT_ULP_ACT_BIT_MARK                = 0x0000000000000001,
	BNXT_ULP_ACT_BIT_DROP                = 0x0000000000000002,
	BNXT_ULP_ACT_BIT_COUNT               = 0x0000000000000004,
	BNXT_ULP_ACT_BIT_RSS                 = 0x0000000000000008,
	BNXT_ULP_ACT_BIT_METER               = 0x0000000000000010,
	BNXT_ULP_ACT_BIT_VXLAN_DECAP         = 0x0000000000000020,
	BNXT_ULP_ACT_BIT_POP_MPLS            = 0x0000000000000040,
	BNXT_ULP_ACT_BIT_PUSH_MPLS           = 0x0000000000000080,
	BNXT_ULP_ACT_BIT_MAC_SWAP            = 0x0000000000000100,
	BNXT_ULP_ACT_BIT_SET_MAC_SRC         = 0x0000000000000200,
	BNXT_ULP_ACT_BIT_SET_MAC_DST         = 0x0000000000000400,
	BNXT_ULP_ACT_BIT_POP_VLAN            = 0x0000000000000800,
	BNXT_ULP_ACT_BIT_PUSH_VLAN           = 0x0000000000001000,
	BNXT_ULP_ACT_BIT_SET_VLAN_PCP        = 0x0000000000002000,
	BNXT_ULP_ACT_BIT_SET_VLAN_VID        = 0x0000000000004000,
	BNXT_ULP_ACT_BIT_SET_IPV4_SRC        = 0x0000000000008000,
	BNXT_ULP_ACT_BIT_SET_IPV4_DST        = 0x0000000000010000,
	BNXT_ULP_ACT_BIT_SET_IPV6_SRC        = 0x0000000000020000,
	BNXT_ULP_ACT_BIT_SET_IPV6_DST        = 0x0000000000040000,
	BNXT_ULP_ACT_BIT_DEC_TTL             = 0x0000000000080000,
	BNXT_ULP_ACT_BIT_SET_TP_SRC          = 0x0000000000100000,
	BNXT_ULP_ACT_BIT_SET_TP_DST          = 0x0000000000200000,
	BNXT_ULP_ACT_BIT_VXLAN_ENCAP         = 0x0000000000400000,
	BNXT_ULP_ACT_BIT_JUMP                = 0x0000000000800000,
	BNXT_ULP_ACT_BIT_SHARED              = 0x0000000001000000,
	BNXT_ULP_ACT_BIT_SAMPLE              = 0x0000000002000000,
	BNXT_ULP_ACT_BIT_SHARED_SAMPLE       = 0x0000000004000000,
	BNXT_ULP_ACT_BIT_LAST                = 0x0000000008000000
};

enum bnxt_ulp_hdr_bit {
	BNXT_ULP_HDR_BIT_O_ETH               = 0x0000000000000001,
	BNXT_ULP_HDR_BIT_OO_VLAN             = 0x0000000000000002,
	BNXT_ULP_HDR_BIT_OI_VLAN             = 0x0000000000000004,
	BNXT_ULP_HDR_BIT_O_IPV4              = 0x0000000000000008,
	BNXT_ULP_HDR_BIT_O_IPV6              = 0x0000000000000010,
	BNXT_ULP_HDR_BIT_O_TCP               = 0x0000000000000020,
	BNXT_ULP_HDR_BIT_O_UDP               = 0x0000000000000040,
	BNXT_ULP_HDR_BIT_O_ICMP              = 0x0000000000000080,
	BNXT_ULP_HDR_BIT_T_VXLAN             = 0x0000000000000100,
	BNXT_ULP_HDR_BIT_T_GRE               = 0x0000000000000200,
	BNXT_ULP_HDR_BIT_I_ETH               = 0x0000000000000400,
	BNXT_ULP_HDR_BIT_IO_VLAN             = 0x0000000000000800,
	BNXT_ULP_HDR_BIT_II_VLAN             = 0x0000000000001000,
	BNXT_ULP_HDR_BIT_I_IPV4              = 0x0000000000002000,
	BNXT_ULP_HDR_BIT_I_IPV6              = 0x0000000000004000,
	BNXT_ULP_HDR_BIT_I_TCP               = 0x0000000000008000,
	BNXT_ULP_HDR_BIT_I_UDP               = 0x0000000000010000,
	BNXT_ULP_HDR_BIT_I_ICMP              = 0x0000000000020000,
	BNXT_ULP_HDR_BIT_F1                  = 0x0000000000040000,
	BNXT_ULP_HDR_BIT_F2                  = 0x0000000000080000,
	BNXT_ULP_HDR_BIT_SVIF_IGNORE         = 0x0000000000100000,
	BNXT_ULP_HDR_BIT_LAST                = 0x0000000000200000
};

enum bnxt_ulp_accept_opc {
	BNXT_ULP_ACCEPT_OPC_ALWAYS = 0,
	BNXT_ULP_ACCEPT_OPC_FLOW_SIG_ID_MATCH = 1,
	BNXT_ULP_ACCEPT_OPC_LAST = 2
};

enum bnxt_ulp_act_type {
	BNXT_ULP_ACT_TYPE_NOT_SUPPORTED = 0,
	BNXT_ULP_ACT_TYPE_SUPPORTED = 1,
	BNXT_ULP_ACT_TYPE_END = 2,
	BNXT_ULP_ACT_TYPE_LAST = 3
};

enum bnxt_ulp_byte_order {
	BNXT_ULP_BYTE_ORDER_BE = 0,
	BNXT_ULP_BYTE_ORDER_LE = 1,
	BNXT_ULP_BYTE_ORDER_LAST = 2
};

enum bnxt_ulp_cf_idx {
	BNXT_ULP_CF_IDX_NOT_USED = 0,
	BNXT_ULP_CF_IDX_MPLS_TAG_NUM = 1,
	BNXT_ULP_CF_IDX_O_VTAG_NUM = 2,
	BNXT_ULP_CF_IDX_O_NO_VTAG = 3,
	BNXT_ULP_CF_IDX_O_ONE_VTAG = 4,
	BNXT_ULP_CF_IDX_O_TWO_VTAGS = 5,
	BNXT_ULP_CF_IDX_I_VTAG_NUM = 6,
	BNXT_ULP_CF_IDX_I_NO_VTAG = 7,
	BNXT_ULP_CF_IDX_I_ONE_VTAG = 8,
	BNXT_ULP_CF_IDX_I_TWO_VTAGS = 9,
	BNXT_ULP_CF_IDX_INCOMING_IF = 10,
	BNXT_ULP_CF_IDX_DIRECTION = 11,
	BNXT_ULP_CF_IDX_SVIF_FLAG = 12,
	BNXT_ULP_CF_IDX_O_L3 = 13,
	BNXT_ULP_CF_IDX_I_L3 = 14,
	BNXT_ULP_CF_IDX_O_L4 = 15,
	BNXT_ULP_CF_IDX_I_L4 = 16,
	BNXT_ULP_CF_IDX_O_L4_SRC_PORT = 17,
	BNXT_ULP_CF_IDX_O_L4_DST_PORT = 18,
	BNXT_ULP_CF_IDX_I_L4_SRC_PORT = 19,
	BNXT_ULP_CF_IDX_I_L4_DST_PORT = 20,
	BNXT_ULP_CF_IDX_O_L4_SRC_PORT_MASK = 21,
	BNXT_ULP_CF_IDX_O_L4_DST_PORT_MASK = 22,
	BNXT_ULP_CF_IDX_I_L4_SRC_PORT_MASK = 23,
	BNXT_ULP_CF_IDX_I_L4_DST_PORT_MASK = 24,
	BNXT_ULP_CF_IDX_O_L4_FB_SRC_PORT = 25,
	BNXT_ULP_CF_IDX_O_L4_FB_DST_PORT = 26,
	BNXT_ULP_CF_IDX_I_L4_FB_SRC_PORT = 27,
	BNXT_ULP_CF_IDX_I_L4_FB_DST_PORT = 28,
	BNXT_ULP_CF_IDX_O_L3_FB_PROTO_ID = 29,
	BNXT_ULP_CF_IDX_I_L3_FB_PROTO_ID = 30,
	BNXT_ULP_CF_IDX_O_L3_PROTO_ID = 31,
	BNXT_ULP_CF_IDX_I_L3_PROTO_ID = 32,
	BNXT_ULP_CF_IDX_DEV_PORT_ID = 33,
	BNXT_ULP_CF_IDX_DRV_FUNC_SVIF = 34,
	BNXT_ULP_CF_IDX_DRV_FUNC_SPIF = 35,
	BNXT_ULP_CF_IDX_DRV_FUNC_PARIF = 36,
	BNXT_ULP_CF_IDX_DRV_FUNC_VNIC = 37,
	BNXT_ULP_CF_IDX_DRV_FUNC_PHY_PORT = 38,
	BNXT_ULP_CF_IDX_VF_FUNC_SVIF = 39,
	BNXT_ULP_CF_IDX_VF_FUNC_SPIF = 40,
	BNXT_ULP_CF_IDX_VF_FUNC_PARIF = 41,
	BNXT_ULP_CF_IDX_VF_FUNC_VNIC = 42,
	BNXT_ULP_CF_IDX_PHY_PORT_SVIF = 43,
	BNXT_ULP_CF_IDX_PHY_PORT_SPIF = 44,
	BNXT_ULP_CF_IDX_PHY_PORT_PARIF = 45,
	BNXT_ULP_CF_IDX_PHY_PORT_VPORT = 46,
	BNXT_ULP_CF_IDX_ACT_ENCAP_IPV4_FLAG = 47,
	BNXT_ULP_CF_IDX_ACT_ENCAP_IPV6_FLAG = 48,
	BNXT_ULP_CF_IDX_ACT_DEC_TTL = 49,
	BNXT_ULP_CF_IDX_ACT_T_DEC_TTL = 50,
	BNXT_ULP_CF_IDX_ACT_PORT_IS_SET = 51,
	BNXT_ULP_CF_IDX_ACT_PORT_TYPE = 52,
	BNXT_ULP_CF_IDX_MATCH_PORT_TYPE = 53,
	BNXT_ULP_CF_IDX_MATCH_PORT_IS_VFREP = 54,
	BNXT_ULP_CF_IDX_MATCH_PORT_IS_PF = 55,
	BNXT_ULP_CF_IDX_VF_TO_VF = 56,
	BNXT_ULP_CF_IDX_L3_HDR_CNT = 57,
	BNXT_ULP_CF_IDX_L4_HDR_CNT = 58,
	BNXT_ULP_CF_IDX_VFR_MODE = 59,
	BNXT_ULP_CF_IDX_L3_TUN = 60,
	BNXT_ULP_CF_IDX_L3_TUN_DECAP = 61,
	BNXT_ULP_CF_IDX_FID = 62,
	BNXT_ULP_CF_IDX_HDR_SIG_ID = 63,
	BNXT_ULP_CF_IDX_FLOW_SIG_ID = 64,
	BNXT_ULP_CF_IDX_WC_MATCH = 65,
	BNXT_ULP_CF_IDX_WC_IS_HA_HIGH_REG = 66,
	BNXT_ULP_CF_IDX_TUNNEL_ID = 67,
	BNXT_ULP_CF_IDX_TUN_OFF_DIP_ID = 68,
	BNXT_ULP_CF_IDX_TUN_OFF_DMAC_ID = 69,
	BNXT_ULP_CF_IDX_OO_VLAN_FB_VID = 70,
	BNXT_ULP_CF_IDX_OI_VLAN_FB_VID = 71,
	BNXT_ULP_CF_IDX_IO_VLAN_FB_VID = 72,
	BNXT_ULP_CF_IDX_II_VLAN_FB_VID = 73,
	BNXT_ULP_CF_IDX_SOCKET_DIRECT = 74,
	BNXT_ULP_CF_IDX_SOCKET_DIRECT_VPORT = 75,
	BNXT_ULP_CF_IDX_LAST = 76
};

enum bnxt_ulp_cond_list_opc {
	BNXT_ULP_COND_LIST_OPC_TRUE = 0,
	BNXT_ULP_COND_LIST_OPC_FALSE = 1,
	BNXT_ULP_COND_LIST_OPC_OR = 2,
	BNXT_ULP_COND_LIST_OPC_AND = 3,
	BNXT_ULP_COND_LIST_OPC_LAST = 4
};

enum bnxt_ulp_cond_opc {
	BNXT_ULP_COND_OPC_CF_IS_SET = 0,
	BNXT_ULP_COND_OPC_CF_NOT_SET = 1,
	BNXT_ULP_COND_OPC_ACT_BIT_IS_SET = 2,
	BNXT_ULP_COND_OPC_ACT_BIT_NOT_SET = 3,
	BNXT_ULP_COND_OPC_HDR_BIT_IS_SET = 4,
	BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET = 5,
	BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET = 6,
	BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET = 7,
	BNXT_ULP_COND_OPC_RF_IS_SET = 8,
	BNXT_ULP_COND_OPC_RF_NOT_SET = 9,
	BNXT_ULP_COND_OPC_FLOW_PAT_MATCH = 10,
	BNXT_ULP_COND_OPC_ACT_PAT_MATCH = 11,
	BNXT_ULP_COND_OPC_EXT_MEM_IS_SET = 12,
	BNXT_ULP_COND_OPC_EXT_MEM_NOT_SET = 13,
	BNXT_ULP_COND_OPC_ENC_HDR_BIT_IS_SET = 14,
	BNXT_ULP_COND_OPC_ENC_HDR_BIT_NOT_SET = 15,
	BNXT_ULP_COND_OPC_LAST = 16
};

enum bnxt_ulp_critical_resource {
	BNXT_ULP_CRITICAL_RESOURCE_NO = 0,
	BNXT_ULP_CRITICAL_RESOURCE_YES = 1,
	BNXT_ULP_CRITICAL_RESOURCE_LAST = 2
};

enum bnxt_ulp_device_id {
	BNXT_ULP_DEVICE_ID_WH_PLUS = 0,
	BNXT_ULP_DEVICE_ID_THOR = 1,
	BNXT_ULP_DEVICE_ID_STINGRAY = 2,
	BNXT_ULP_DEVICE_ID_STINGRAY2 = 3,
	BNXT_ULP_DEVICE_ID_LAST = 4
};

enum bnxt_ulp_df_param_type {
	BNXT_ULP_DF_PARAM_TYPE_DEV_PORT_ID = 0,
	BNXT_ULP_DF_PARAM_TYPE_LAST = 1
};

enum bnxt_ulp_direction {
	BNXT_ULP_DIRECTION_INGRESS = 0,
	BNXT_ULP_DIRECTION_EGRESS = 1,
	BNXT_ULP_DIRECTION_LAST = 2
};

enum bnxt_ulp_enc_field {
	BNXT_ULP_ENC_FIELD_ETH_DMAC = 0,
	BNXT_ULP_ENC_FIELD_ETH_SMAC = 1,
	BNXT_ULP_ENC_FIELD_ETH_TYPE = 2,
	BNXT_ULP_ENC_FIELD_O_VLAN_TCI = 3,
	BNXT_ULP_ENC_FIELD_O_VLAN_TYPE = 4,
	BNXT_ULP_ENC_FIELD_I_VLAN_TCI = 5,
	BNXT_ULP_ENC_FIELD_I_VLAN_TYPE = 6,
	BNXT_ULP_ENC_FIELD_IPV4_IHL = 7,
	BNXT_ULP_ENC_FIELD_IPV4_TOS = 8,
	BNXT_ULP_ENC_FIELD_IPV4_PKT_ID = 9,
	BNXT_ULP_ENC_FIELD_IPV4_FRAG = 10,
	BNXT_ULP_ENC_FIELD_IPV4_TTL = 11,
	BNXT_ULP_ENC_FIELD_IPV4_PROTO = 12,
	BNXT_ULP_ENC_FIELD_IPV4_SADDR = 13,
	BNXT_ULP_ENC_FIELD_IPV4_DADDR = 14,
	BNXT_ULP_ENC_FIELD_IPV6_VTC_FLOW = 15,
	BNXT_ULP_ENC_FIELD_IPV6_PROTO = 16,
	BNXT_ULP_ENC_FIELD_IPV6_TTL = 17,
	BNXT_ULP_ENC_FIELD_IPV6_SADDR = 18,
	BNXT_ULP_ENC_FIELD_IPV6_DADDR = 19,
	BNXT_ULP_ENC_FIELD_UDP_SPORT = 20,
	BNXT_ULP_ENC_FIELD_UDP_DPORT = 21,
	BNXT_ULP_ENC_FIELD_VXLAN_FLAGS = 22,
	BNXT_ULP_ENC_FIELD_VXLAN_RSVD0 = 23,
	BNXT_ULP_ENC_FIELD_VXLAN_VNI = 24,
	BNXT_ULP_ENC_FIELD_VXLAN_RSVD1 = 25,
	BNXT_ULP_ENC_FIELD_LAST = 26
};

enum bnxt_ulp_fdb_opc {
	BNXT_ULP_FDB_OPC_PUSH_FID = 0,
	BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE = 1,
	BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE = 2,
	BNXT_ULP_FDB_OPC_NOP = 3,
	BNXT_ULP_FDB_OPC_LAST = 4
};

enum bnxt_ulp_fdb_type {
	BNXT_ULP_FDB_TYPE_REGULAR = 0,
	BNXT_ULP_FDB_TYPE_DEFAULT = 1,
	BNXT_ULP_FDB_TYPE_RID = 2,
	BNXT_ULP_FDB_TYPE_LAST = 3
};

enum bnxt_ulp_field_opc {
	BNXT_ULP_FIELD_OPC_SRC1 = 0,
	BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3 = 1,
	BNXT_ULP_FIELD_OPC_SRC1_PLUS_SRC2 = 2,
	BNXT_ULP_FIELD_OPC_SRC1_MINUS_SRC2 = 3,
	BNXT_ULP_FIELD_OPC_SRC1_PLUS_SRC2_POST = 4,
	BNXT_ULP_FIELD_OPC_SRC1_MINUS_SRC2_POST = 5,
	BNXT_ULP_FIELD_OPC_SRC1_OR_SRC2 = 6,
	BNXT_ULP_FIELD_OPC_SRC1_OR_SRC2_OR_SRC3 = 7,
	BNXT_ULP_FIELD_OPC_SRC1_AND_SRC2 = 8,
	BNXT_ULP_FIELD_OPC_SRC1_AND_SRC2_OR_SRC3 = 9,
	BNXT_ULP_FIELD_OPC_SKIP = 10,
	BNXT_ULP_FIELD_OPC_LAST = 11
};

enum bnxt_ulp_field_src {
	BNXT_ULP_FIELD_SRC_ZERO = 0,
	BNXT_ULP_FIELD_SRC_ONES = 1,
	BNXT_ULP_FIELD_SRC_CONST = 2,
	BNXT_ULP_FIELD_SRC_CF = 3,
	BNXT_ULP_FIELD_SRC_RF = 4,
	BNXT_ULP_FIELD_SRC_ACT_PROP = 5,
	BNXT_ULP_FIELD_SRC_ACT_PROP_SZ = 6,
	BNXT_ULP_FIELD_SRC_GLB_RF = 7,
	BNXT_ULP_FIELD_SRC_HF = 8,
	BNXT_ULP_FIELD_SRC_SUB_HF = 9,
	BNXT_ULP_FIELD_SRC_HDR_BIT = 10,
	BNXT_ULP_FIELD_SRC_ACT_BIT = 11,
	BNXT_ULP_FIELD_SRC_FIELD_BIT = 12,
	BNXT_ULP_FIELD_SRC_SKIP = 13,
	BNXT_ULP_FIELD_SRC_REJECT = 14,
	BNXT_ULP_FIELD_SRC_PORT_TABLE = 15,
	BNXT_ULP_FIELD_SRC_ENC_HDR_BIT = 16,
	BNXT_ULP_FIELD_SRC_ENC_FIELD = 17,
	BNXT_ULP_FIELD_SRC_LAST = 18
};

enum bnxt_ulp_func_opc {
	BNXT_ULP_FUNC_OPC_NOP = 0,
	BNXT_ULP_FUNC_OPC_EQ = 1,
	BNXT_ULP_FUNC_OPC_NE = 2,
	BNXT_ULP_FUNC_OPC_GT = 3,
	BNXT_ULP_FUNC_OPC_GE = 4,
	BNXT_ULP_FUNC_OPC_LT = 5,
	BNXT_ULP_FUNC_OPC_LE = 6,
	BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF = 7,
	BNXT_ULP_FUNC_OPC_RSS_CONFIG = 8,
	BNXT_ULP_FUNC_OPC_GET_PARENT_MAC_ADDR = 9,
	BNXT_ULP_FUNC_OPC_ALLOC_L2_CTX_ID = 10,
	BNXT_ULP_FUNC_OPC_LAST = 11
};

enum bnxt_ulp_func_src {
	BNXT_ULP_FUNC_SRC_REGFILE = 0,
	BNXT_ULP_FUNC_SRC_GLB_REGFILE = 1,
	BNXT_ULP_FUNC_SRC_COMP_FIELD = 2,
	BNXT_ULP_FUNC_SRC_CONST = 3,
	BNXT_ULP_FUNC_SRC_LAST = 4
};

enum bnxt_ulp_generic_tbl_lkup_type {
	BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX = 0,
	BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH = 1,
	BNXT_ULP_GENERIC_TBL_LKUP_TYPE_LAST = 2
};

enum bnxt_ulp_generic_tbl_opc {
	BNXT_ULP_GENERIC_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_GENERIC_TBL_OPC_READ = 1,
	BNXT_ULP_GENERIC_TBL_OPC_WRITE = 2,
	BNXT_ULP_GENERIC_TBL_OPC_LAST = 3
};

enum bnxt_ulp_glb_rf_idx {
	BNXT_ULP_GLB_RF_IDX_NOT_USED = 0,
	BNXT_ULP_GLB_RF_IDX_GLB_PROF_FUNC_ID = 1,
	BNXT_ULP_GLB_RF_IDX_GLB_LB_AREC_PTR = 2,
	BNXT_ULP_GLB_RF_IDX_L2_PROF_FUNC_ID = 3,
	BNXT_ULP_GLB_RF_IDX_VXLAN_PROF_FUNC_ID = 4,
	BNXT_ULP_GLB_RF_IDX_ENCAP_MAC_PTR = 5,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_0 = 6,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_1 = 7,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_2 = 8,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_3 = 9,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_4 = 10,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_5 = 11,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_6 = 12,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_7 = 13,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_0 = 14,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_1 = 15,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_2 = 16,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_3 = 17,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_4 = 18,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_0 = 19,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_1 = 20,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_2 = 21,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_3 = 22,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_4 = 23,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_5 = 24,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_6 = 25,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_7 = 26,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_0 = 27,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_1 = 28,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_2 = 29,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_3 = 30,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_4 = 31,
	BNXT_ULP_GLB_RF_IDX_GLB_METADATA_PROF_0 = 32,
	BNXT_ULP_GLB_RF_IDX_GLB_METADATA_PROF_1 = 33,
	BNXT_ULP_GLB_RF_IDX_GLB_VFR_PROF_FUNC_0 = 34,
	BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_KEY_ID_0 = 35,
	BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_PROF_ID_0 = 36,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_0 = 37,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_1 = 38,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_2 = 39,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_3 = 40,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_L2_CNTXT_ID_0 = 41,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_L2_CNTXT_ID_1 = 42,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_EM_PROFILE_ID_0 = 43,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_EM_PROFILE_ID_1 = 44,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_0 = 45,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_1 = 46,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_2 = 47,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_3 = 48,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_4 = 49,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_5 = 50,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_6 = 51,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_7 = 52,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_8 = 53,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_9 = 54,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_10 = 55,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_EM_KEY_ID_0 = 56,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_EM_KEY_ID_1 = 57,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_0 = 58,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_1 = 59,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_2 = 60,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_3 = 61,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_4 = 62,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_AREC_PTR_0 = 63,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_AREC_PTR_1 = 64,
	BNXT_ULP_GLB_RF_IDX_GRE_PROF_FUNC_ID = 65,
	BNXT_ULP_GLB_RF_IDX_LAST = 66
};

enum bnxt_ulp_hdr_type {
	BNXT_ULP_HDR_TYPE_NOT_SUPPORTED = 0,
	BNXT_ULP_HDR_TYPE_SUPPORTED = 1,
	BNXT_ULP_HDR_TYPE_END = 2,
	BNXT_ULP_HDR_TYPE_LAST = 3
};

enum bnxt_ulp_if_tbl_opc {
	BNXT_ULP_IF_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD = 1,
	BNXT_ULP_IF_TBL_OPC_WR_REGFILE = 2,
	BNXT_ULP_IF_TBL_OPC_WR_CONST = 3,
	BNXT_ULP_IF_TBL_OPC_RD_COMP_FIELD = 4,
	BNXT_ULP_IF_TBL_OPC_LAST = 5
};

enum bnxt_ulp_index_tbl_opc {
	BNXT_ULP_INDEX_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_INDEX_TBL_OPC_ALLOC_REGFILE = 1,
	BNXT_ULP_INDEX_TBL_OPC_WR_REGFILE = 2,
	BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE = 3,
	BNXT_ULP_INDEX_TBL_OPC_RD_REGFILE = 4,
	BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_GLB_REGFILE = 5,
	BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE = 6,
	BNXT_ULP_INDEX_TBL_OPC_LAST = 7
};

enum bnxt_ulp_mark_db_opc {
	BNXT_ULP_MARK_DB_OPC_NOP = 0,
	BNXT_ULP_MARK_DB_OPC_PUSH_IF_MARK_ACTION = 1,
	BNXT_ULP_MARK_DB_OPC_PUSH_AND_SET_VFR_FLAG = 2,
	BNXT_ULP_MARK_DB_OPC_LAST = 3
};

enum bnxt_ulp_match_type {
	BNXT_ULP_MATCH_TYPE_EM = 0,
	BNXT_ULP_MATCH_TYPE_WM = 1,
	BNXT_ULP_MATCH_TYPE_LAST = 2
};

enum bnxt_ulp_port_table {
	BNXT_ULP_PORT_TABLE_DRV_FUNC_PARENT_MAC = 0,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_PARENT_VNIC = 1,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_SVIF = 2,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_SPIF = 3,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_PARIF = 4,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_VNIC = 5,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_PHY_PORT = 6,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_MAC = 7,
	BNXT_ULP_PORT_TABLE_VF_FUNC_SVIF = 8,
	BNXT_ULP_PORT_TABLE_VF_FUNC_SPIF = 9,
	BNXT_ULP_PORT_TABLE_VF_FUNC_PARIF = 10,
	BNXT_ULP_PORT_TABLE_VF_FUNC_VNIC = 11,
	BNXT_ULP_PORT_TABLE_VF_FUNC_MAC = 12,
	BNXT_ULP_PORT_TABLE_PHY_PORT_SVIF = 13,
	BNXT_ULP_PORT_TABLE_PHY_PORT_SPIF = 14,
	BNXT_ULP_PORT_TABLE_PHY_PORT_PARIF = 15,
	BNXT_ULP_PORT_TABLE_PHY_PORT_VPORT = 16,
	BNXT_ULP_PORT_TABLE_LAST = 17
};

enum bnxt_ulp_pri_opc {
	BNXT_ULP_PRI_OPC_NOT_USED = 0,
	BNXT_ULP_PRI_OPC_CONST = 1,
	BNXT_ULP_PRI_OPC_APP_PRI = 2,
	BNXT_ULP_PRI_OPC_LAST = 3
};

enum bnxt_ulp_rf_idx {
	BNXT_ULP_RF_IDX_NOT_USED = 0,
	BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 = 1,
	BNXT_ULP_RF_IDX_L2_CNTXT_ID_1 = 2,
	BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 = 3,
	BNXT_ULP_RF_IDX_PROF_FUNC_ID_1 = 4,
	BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 = 5,
	BNXT_ULP_RF_IDX_EM_PROFILE_ID_1 = 6,
	BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 = 7,
	BNXT_ULP_RF_IDX_WC_PROFILE_ID_1 = 8,
	BNXT_ULP_RF_IDX_MAIN_ACTION_PTR = 9,
	BNXT_ULP_RF_IDX_ACTION_PTR_0 = 10,
	BNXT_ULP_RF_IDX_ENCAP_PTR_0 = 11,
	BNXT_ULP_RF_IDX_ENCAP_PTR_1 = 12,
	BNXT_ULP_RF_IDX_CRITICAL_RESOURCE = 13,
	BNXT_ULP_RF_IDX_FLOW_CNTR_PTR_0 = 14,
	BNXT_ULP_RF_IDX_MAIN_SP_PTR = 15,
	BNXT_ULP_RF_IDX_MODIFY_IPV4_SRC_PTR_0 = 16,
	BNXT_ULP_RF_IDX_MODIFY_IPV4_DST_PTR_0 = 17,
	BNXT_ULP_RF_IDX_ACTION_REC_SIZE = 18,
	BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0 = 19,
	BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_1 = 20,
	BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0 = 21,
	BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_1 = 22,
	BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0 = 23,
	BNXT_ULP_RF_IDX_WC_TCAM_INDEX_1 = 24,
	BNXT_ULP_RF_IDX_SRC_PROPERTY_PTR = 25,
	BNXT_ULP_RF_IDX_GENERIC_TBL_MISS = 26,
	BNXT_ULP_RF_IDX_MIRROR_PTR_0 = 27,
	BNXT_ULP_RF_IDX_MIRROR_ID_0 = 28,
	BNXT_ULP_RF_IDX_HDR_SIG_ID = 29,
	BNXT_ULP_RF_IDX_FLOW_SIG_ID = 30,
	BNXT_ULP_RF_IDX_RID = 31,
	BNXT_ULP_RF_IDX_WC_KEY_ID_0 = 32,
	BNXT_ULP_RF_IDX_EM_KEY_ID_0 = 33,
	BNXT_ULP_RF_IDX_DRV_FUNC_MAC = 34,
	BNXT_ULP_RF_IDX_DRV_FUNC_PARENT_MAC = 35,
	BNXT_ULP_RF_IDX_DEFAULT_AREC_PTR = 36,
	BNXT_ULP_RF_IDX_CC = 37,
	BNXT_ULP_RF_IDX_CF_FLOW_SIG_ID = 38,
	BNXT_ULP_RF_IDX_PHY_PORT = 39,
	BNXT_ULP_RF_IDX_METADATA_PROF = 40,
	BNXT_ULP_RF_IDX_MODIFY_PTR = 41,
	BNXT_ULP_RF_IDX_SOCK_DIR_SVIF = 42,
	BNXT_ULP_RF_IDX_SOCK_DIR_PARIF = 43,
	BNXT_ULP_RF_IDX_SOCK_DIR_ACT_PTR = 44,
	BNXT_ULP_RF_IDX_SOCK_DIR_PARENT_MAC = 45,
	BNXT_ULP_RF_IDX_LAST = 46
};

enum bnxt_ulp_shared_session {
	BNXT_ULP_SHARED_SESSION_NO = 0,
	BNXT_ULP_SHARED_SESSION_YES = 1,
	BNXT_ULP_SHARED_SESSION_LAST = 2
};

enum bnxt_ulp_tcam_tbl_opc {
	BNXT_ULP_TCAM_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE = 1,
	BNXT_ULP_TCAM_TBL_OPC_SRCH_ALLOC_WR_REGFILE = 2,
	BNXT_ULP_TCAM_TBL_OPC_ALLOC_REGFILE = 3,
	BNXT_ULP_TCAM_TBL_OPC_WR_REGFILE = 4,
	BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT = 5,
	BNXT_ULP_TCAM_TBL_OPC_LAST = 6
};

enum bnxt_ulp_template_type {
	BNXT_ULP_TEMPLATE_TYPE_CLASS = 0,
	BNXT_ULP_TEMPLATE_TYPE_ACTION = 1,
	BNXT_ULP_TEMPLATE_TYPE_LAST = 2
};

enum bnxt_ulp_app_cap {
	BNXT_ULP_APP_CAP_SHARED_EN = 0x00000001,
	BNXT_ULP_APP_CAP_HOT_UPGRADE_EN = 0x00000002,
	BNXT_ULP_APP_CAP_UNICAST_ONLY = 0x00000004,
	BNXT_ULP_APP_CAP_SOCKET_DIRECT = 0x00000008
};

enum bnxt_ulp_fdb_resource_flags {
	BNXT_ULP_FDB_RESOURCE_FLAGS_DIR_INGR = 0x00,
	BNXT_ULP_FDB_RESOURCE_FLAGS_DIR_EGR = 0x01
};

enum bnxt_ulp_flow_dir_bitmask {
	BNXT_ULP_FLOW_DIR_BITMASK_ING = 0x0000000000000000,
	BNXT_ULP_FLOW_DIR_BITMASK_EGR = 0x8000000000000000
};

enum bnxt_ulp_resource_func {
	BNXT_ULP_RESOURCE_FUNC_INVALID = 0x00,
	BNXT_ULP_RESOURCE_FUNC_EM_TABLE = 0x20,
	BNXT_ULP_RESOURCE_FUNC_RSVD1 = 0x40,
	BNXT_ULP_RESOURCE_FUNC_RSVD2 = 0x60,
	BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE = 0x80,
	BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE = 0x81,
	BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE = 0x82,
	BNXT_ULP_RESOURCE_FUNC_IDENTIFIER = 0x83,
	BNXT_ULP_RESOURCE_FUNC_IF_TABLE = 0x84,
	BNXT_ULP_RESOURCE_FUNC_HW_FID = 0x85,
	BNXT_ULP_RESOURCE_FUNC_PARENT_FLOW = 0x86,
	BNXT_ULP_RESOURCE_FUNC_CHILD_FLOW = 0x87,
	BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE = 0x88
};

enum bnxt_ulp_resource_sub_type {
	BNXT_ULP_RESOURCE_SUB_TYPE_NOT_USED = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_VFR_CFA_ACTION = 1,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_INT_COUNT = 2,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_INT_COUNT_ACC = 3,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_EXT_COUNT = 4,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM = 1,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SHARED_MIRROR = 2,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MAC_ADDR_CACHE = 3,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE = 4,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_CACHE = 5,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SOURCE_PROPERTY_CACHE = 6,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_VXLAN_ENCAP_REC_CACHE = 7,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SOCKET_DIRECT_CACHE = 8
};

enum bnxt_ulp_act_prop_sz {
	BNXT_ULP_ACT_PROP_SZ_ENCAP_TUN_SZ = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_IP_SZ = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_VTAG_SZ = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_VTAG_TYPE = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_VTAG_NUM = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_L3_TYPE = 4,
	BNXT_ULP_ACT_PROP_SZ_MPLS_POP_NUM = 4,
	BNXT_ULP_ACT_PROP_SZ_MPLS_PUSH_NUM = 4,
	BNXT_ULP_ACT_PROP_SZ_PORT_ID = 4,
	BNXT_ULP_ACT_PROP_SZ_VNIC = 4,
	BNXT_ULP_ACT_PROP_SZ_VPORT = 4,
	BNXT_ULP_ACT_PROP_SZ_MARK = 4,
	BNXT_ULP_ACT_PROP_SZ_COUNT = 4,
	BNXT_ULP_ACT_PROP_SZ_METER = 4,
	BNXT_ULP_ACT_PROP_SZ_SET_MAC_SRC = 8,
	BNXT_ULP_ACT_PROP_SZ_SET_MAC_DST = 8,
	BNXT_ULP_ACT_PROP_SZ_PUSH_VLAN = 2,
	BNXT_ULP_ACT_PROP_SZ_SET_VLAN_PCP = 1,
	BNXT_ULP_ACT_PROP_SZ_SET_VLAN_VID = 2,
	BNXT_ULP_ACT_PROP_SZ_SET_IPV4_SRC = 4,
	BNXT_ULP_ACT_PROP_SZ_SET_IPV4_DST = 4,
	BNXT_ULP_ACT_PROP_SZ_SET_IPV6_SRC = 16,
	BNXT_ULP_ACT_PROP_SZ_SET_IPV6_DST = 16,
	BNXT_ULP_ACT_PROP_SZ_SET_TP_SRC = 2,
	BNXT_ULP_ACT_PROP_SZ_SET_TP_DST = 2,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_0 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_1 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_2 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_3 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_4 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_5 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_6 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_7 = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_L2_DMAC = 6,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_L2_SMAC = 6,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_VTAG = 8,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_IP = 32,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_IP_SRC = 16,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_UDP = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_TUN = 32,
	BNXT_ULP_ACT_PROP_SZ_JUMP = 4,
	BNXT_ULP_ACT_PROP_SZ_SHARED_HANDLE = 8,
	BNXT_ULP_ACT_PROP_SZ_RSS_TYPES = 8,
	BNXT_ULP_ACT_PROP_SZ_RSS_LEVEL = 4,
	BNXT_ULP_ACT_PROP_SZ_RSS_KEY_LEN = 4,
	BNXT_ULP_ACT_PROP_SZ_RSS_KEY = 40,
	BNXT_ULP_ACT_PROP_SZ_LAST = 4
};

enum bnxt_ulp_act_prop_idx {
	BNXT_ULP_ACT_PROP_IDX_ENCAP_TUN_SZ = 0,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_IP_SZ = 4,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_SZ = 8,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_TYPE = 12,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_NUM = 16,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_L3_TYPE = 20,
	BNXT_ULP_ACT_PROP_IDX_MPLS_POP_NUM = 24,
	BNXT_ULP_ACT_PROP_IDX_MPLS_PUSH_NUM = 28,
	BNXT_ULP_ACT_PROP_IDX_PORT_ID = 32,
	BNXT_ULP_ACT_PROP_IDX_VNIC = 36,
	BNXT_ULP_ACT_PROP_IDX_VPORT = 40,
	BNXT_ULP_ACT_PROP_IDX_MARK = 44,
	BNXT_ULP_ACT_PROP_IDX_COUNT = 48,
	BNXT_ULP_ACT_PROP_IDX_METER = 52,
	BNXT_ULP_ACT_PROP_IDX_SET_MAC_SRC = 56,
	BNXT_ULP_ACT_PROP_IDX_SET_MAC_DST = 64,
	BNXT_ULP_ACT_PROP_IDX_PUSH_VLAN = 72,
	BNXT_ULP_ACT_PROP_IDX_SET_VLAN_PCP = 74,
	BNXT_ULP_ACT_PROP_IDX_SET_VLAN_VID = 75,
	BNXT_ULP_ACT_PROP_IDX_SET_IPV4_SRC = 77,
	BNXT_ULP_ACT_PROP_IDX_SET_IPV4_DST = 81,
	BNXT_ULP_ACT_PROP_IDX_SET_IPV6_SRC = 85,
	BNXT_ULP_ACT_PROP_IDX_SET_IPV6_DST = 101,
	BNXT_ULP_ACT_PROP_IDX_SET_TP_SRC = 117,
	BNXT_ULP_ACT_PROP_IDX_SET_TP_DST = 119,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_0 = 121,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_1 = 125,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_2 = 129,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_3 = 133,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_4 = 137,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_5 = 141,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_6 = 145,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_7 = 149,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_L2_DMAC = 153,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_L2_SMAC = 159,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG = 165,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_IP = 173,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_IP_SRC = 205,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_UDP = 221,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_TUN = 225,
	BNXT_ULP_ACT_PROP_IDX_JUMP = 257,
	BNXT_ULP_ACT_PROP_IDX_SHARED_HANDLE = 261,
	BNXT_ULP_ACT_PROP_IDX_RSS_TYPES = 269,
	BNXT_ULP_ACT_PROP_IDX_RSS_LEVEL = 277,
	BNXT_ULP_ACT_PROP_IDX_RSS_KEY_LEN = 281,
	BNXT_ULP_ACT_PROP_IDX_RSS_KEY = 285,
	BNXT_ULP_ACT_PROP_IDX_LAST = 325
};

enum ulp_wp_sym {
	ULP_WP_SYM_METADATA_OP_NORMAL = 0,
	ULP_WP_SYM_METADATA_OP_L2_HASH = 0,
	ULP_WP_SYM_METADATA_OP_L4_HASH = 0,
	ULP_WP_SYM_FWD_OP_BYPASS_CFA = 0,
	ULP_WP_SYM_FWD_OP_BYPASS_CFA_ROCE = 0,
	ULP_WP_SYM_FWD_OP_BYPASS_LKUP = 0,
	ULP_WP_SYM_FWD_OP_NORMAL_FLOW = 0,
	ULP_WP_SYM_CTXT_OPCODE_BYPASS_CFA = 0,
	ULP_WP_SYM_CTXT_OPCODE_BYPASS_LKUP = 0,
	ULP_WP_SYM_CTXT_OPCODE_META_UPDATE = 0,
	ULP_WP_SYM_CTXT_OPCODE_NORMAL_FLOW = 0,
	ULP_WP_SYM_CTXT_OPCODE_DROP = 0,
	ULP_WP_SYM_PKT_TYPE_IGNORE = 0,
	ULP_WP_SYM_PKT_TYPE_L2 = 0,
	ULP_WP_SYM_PKT_TYPE_0_IGNORE = 0,
	ULP_WP_SYM_PKT_TYPE_0_L2 = 0,
	ULP_WP_SYM_PKT_TYPE_1_IGNORE = 0,
	ULP_WP_SYM_PKT_TYPE_1_L2 = 0,
	ULP_WP_SYM_RECYCLE_CNT_IGNORE = 0,
	ULP_WP_SYM_RECYCLE_CNT_ZERO = 0,
	ULP_WP_SYM_RECYCLE_CNT_ONE = 1,
	ULP_WP_SYM_RECYCLE_CNT_TWO = 2,
	ULP_WP_SYM_RECYCLE_CNT_THREE = 3,
	ULP_WP_SYM_AGG_ERROR_IGNORE = 0,
	ULP_WP_SYM_AGG_ERROR_NO = 0,
	ULP_WP_SYM_AGG_ERROR_YES = 1,
	ULP_WP_SYM_RESERVED_IGNORE = 0,
	ULP_WP_SYM_HREC_NEXT_IGNORE = 0,
	ULP_WP_SYM_HREC_NEXT_NO = 0,
	ULP_WP_SYM_HREC_NEXT_YES = 1,
	ULP_WP_SYM_TL2_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_TL2_HDR_VALID_NO = 0,
	ULP_WP_SYM_TL2_HDR_VALID_YES = 1,
	ULP_WP_SYM_TL2_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_TL2_HDR_TYPE_DIX = 0,
	ULP_WP_SYM_TL2_UC_MC_BC_IGNORE = 0,
	ULP_WP_SYM_TL2_UC_MC_BC_UC = 0,
	ULP_WP_SYM_TL2_UC_MC_BC_MC = 2,
	ULP_WP_SYM_TL2_UC_MC_BC_BC = 3,
	ULP_WP_SYM_TL2_VTAG_PRESENT_IGNORE = 0,
	ULP_WP_SYM_TL2_VTAG_PRESENT_NO = 0,
	ULP_WP_SYM_TL2_VTAG_PRESENT_YES = 1,
	ULP_WP_SYM_TL2_TWO_VTAGS_IGNORE = 0,
	ULP_WP_SYM_TL2_TWO_VTAGS_NO = 0,
	ULP_WP_SYM_TL2_TWO_VTAGS_YES = 1,
	ULP_WP_SYM_TL3_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_TL3_HDR_VALID_NO = 0,
	ULP_WP_SYM_TL3_HDR_VALID_YES = 1,
	ULP_WP_SYM_TL3_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_TL3_HDR_ERROR_NO = 0,
	ULP_WP_SYM_TL3_HDR_ERROR_YES = 1,
	ULP_WP_SYM_TL3_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_TL3_HDR_TYPE_IPV4 = 0,
	ULP_WP_SYM_TL3_HDR_TYPE_IPV6 = 1,
	ULP_WP_SYM_TL3_HDR_ISIP_IGNORE = 0,
	ULP_WP_SYM_TL3_HDR_ISIP_NO = 0,
	ULP_WP_SYM_TL3_HDR_ISIP_YES = 1,
	ULP_WP_SYM_TL3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_WP_SYM_TL3_IPV6_CMP_SRC_NO = 0,
	ULP_WP_SYM_TL3_IPV6_CMP_SRC_YES = 1,
	ULP_WP_SYM_TL3_IPV6_CMP_DST_IGNORE = 0,
	ULP_WP_SYM_TL3_IPV6_CMP_DST_NO = 0,
	ULP_WP_SYM_TL3_IPV6_CMP_DST_YES = 1,
	ULP_WP_SYM_TL4_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_TL4_HDR_VALID_NO = 0,
	ULP_WP_SYM_TL4_HDR_VALID_YES = 1,
	ULP_WP_SYM_TL4_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_TL4_HDR_ERROR_NO = 0,
	ULP_WP_SYM_TL4_HDR_ERROR_YES = 1,
	ULP_WP_SYM_TL4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_WP_SYM_TL4_HDR_IS_UDP_TCP_NO = 0,
	ULP_WP_SYM_TL4_HDR_IS_UDP_TCP_YES = 1,
	ULP_WP_SYM_TL4_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_TL4_HDR_TYPE_TCP = 0,
	ULP_WP_SYM_TL4_HDR_TYPE_UDP = 1,
	ULP_WP_SYM_TUN_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_TUN_HDR_VALID_NO = 0,
	ULP_WP_SYM_TUN_HDR_VALID_YES = 1,
	ULP_WP_SYM_TUN_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_TUN_HDR_ERROR_NO = 0,
	ULP_WP_SYM_TUN_HDR_ERROR_YES = 1,
	ULP_WP_SYM_TUN_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_VXLAN = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_GENEVE = 1,
	ULP_WP_SYM_TUN_HDR_TYPE_NVGRE = 2,
	ULP_WP_SYM_TUN_HDR_TYPE_GRE = 3,
	ULP_WP_SYM_TUN_HDR_TYPE_IPV4 = 4,
	ULP_WP_SYM_TUN_HDR_TYPE_IPV6 = 5,
	ULP_WP_SYM_TUN_HDR_TYPE_PPPOE = 6,
	ULP_WP_SYM_TUN_HDR_TYPE_MPLS = 7,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR1 = 8,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR2 = 9,
	ULP_WP_SYM_TUN_HDR_TYPE_NONE = 15,
	ULP_WP_SYM_TUN_HDR_FLAGS_IGNORE = 0,
	ULP_WP_SYM_L2_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_L2_HDR_VALID_NO = 0,
	ULP_WP_SYM_L2_HDR_VALID_YES = 1,
	ULP_WP_SYM_L2_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_L2_HDR_ERROR_NO = 0,
	ULP_WP_SYM_L2_HDR_ERROR_YES = 1,
	ULP_WP_SYM_L2_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_L2_HDR_TYPE_DIX = 0,
	ULP_WP_SYM_L2_HDR_TYPE_LLC_SNAP = 1,
	ULP_WP_SYM_L2_HDR_TYPE_LLC = 2,
	ULP_WP_SYM_L2_UC_MC_BC_IGNORE = 0,
	ULP_WP_SYM_L2_UC_MC_BC_UC = 0,
	ULP_WP_SYM_L2_UC_MC_BC_MC = 2,
	ULP_WP_SYM_L2_UC_MC_BC_BC = 3,
	ULP_WP_SYM_L2_VTAG_PRESENT_IGNORE = 0,
	ULP_WP_SYM_L2_VTAG_PRESENT_NO = 0,
	ULP_WP_SYM_L2_VTAG_PRESENT_YES = 1,
	ULP_WP_SYM_L2_TWO_VTAGS_IGNORE = 0,
	ULP_WP_SYM_L2_TWO_VTAGS_NO = 0,
	ULP_WP_SYM_L2_TWO_VTAGS_YES = 1,
	ULP_WP_SYM_L3_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_L3_HDR_VALID_NO = 0,
	ULP_WP_SYM_L3_HDR_VALID_YES = 1,
	ULP_WP_SYM_L3_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_L3_HDR_ERROR_NO = 0,
	ULP_WP_SYM_L3_HDR_ERROR_YES = 1,
	ULP_WP_SYM_L3_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_L3_HDR_TYPE_IPV4 = 0,
	ULP_WP_SYM_L3_HDR_TYPE_IPV6 = 1,
	ULP_WP_SYM_L3_HDR_TYPE_ARP = 2,
	ULP_WP_SYM_L3_HDR_TYPE_PTP = 3,
	ULP_WP_SYM_L3_HDR_TYPE_EAPOL = 4,
	ULP_WP_SYM_L3_HDR_TYPE_ROCE = 5,
	ULP_WP_SYM_L3_HDR_TYPE_FCOE = 6,
	ULP_WP_SYM_L3_HDR_TYPE_UPAR1 = 7,
	ULP_WP_SYM_L3_HDR_TYPE_UPAR2 = 8,
	ULP_WP_SYM_L3_HDR_ISIP_IGNORE = 0,
	ULP_WP_SYM_L3_HDR_ISIP_NO = 0,
	ULP_WP_SYM_L3_HDR_ISIP_YES = 1,
	ULP_WP_SYM_L3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_WP_SYM_L3_IPV6_CMP_SRC_NO = 0,
	ULP_WP_SYM_L3_IPV6_CMP_SRC_YES = 1,
	ULP_WP_SYM_L3_IPV6_CMP_DST_IGNORE = 0,
	ULP_WP_SYM_L3_IPV6_CMP_DST_NO = 0,
	ULP_WP_SYM_L3_IPV6_CMP_DST_YES = 1,
	ULP_WP_SYM_L4_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_L4_HDR_VALID_NO = 0,
	ULP_WP_SYM_L4_HDR_VALID_YES = 1,
	ULP_WP_SYM_L4_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_L4_HDR_ERROR_NO = 0,
	ULP_WP_SYM_L4_HDR_ERROR_YES = 1,
	ULP_WP_SYM_L4_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_L4_HDR_TYPE_TCP = 0,
	ULP_WP_SYM_L4_HDR_TYPE_UDP = 1,
	ULP_WP_SYM_L4_HDR_TYPE_ICMP = 2,
	ULP_WP_SYM_L4_HDR_TYPE_UPAR1 = 3,
	ULP_WP_SYM_L4_HDR_TYPE_UPAR2 = 4,
	ULP_WP_SYM_L4_HDR_TYPE_BTH_V1 = 5,
	ULP_WP_SYM_L4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_WP_SYM_L4_HDR_IS_UDP_TCP_NO = 0,
	ULP_WP_SYM_L4_HDR_IS_UDP_TCP_YES = 1,
	ULP_WP_SYM_POP_VLAN_NO = 0,
	ULP_WP_SYM_POP_VLAN_YES = 1,
	ULP_WP_SYM_VLAN_DEL_RPT_DISABLED = 0,
	ULP_WP_SYM_VLAN_DEL_RPT_STRIP_OUTER = 0,
	ULP_WP_SYM_VLAN_DEL_RPT_STRIP_BOTH = 0,
	ULP_WP_SYM_VLAN_DEL_RPT_DYN_STRIP = 0,
	ULP_WP_SYM_DECAP_FUNC_NONE = 0,
	ULP_WP_SYM_DECAP_FUNC_THRU_TL2 = 3,
	ULP_WP_SYM_DECAP_FUNC_THRU_TL3 = 8,
	ULP_WP_SYM_DECAP_FUNC_THRU_TL4 = 9,
	ULP_WP_SYM_DECAP_FUNC_THRU_TUN = 10,
	ULP_WP_SYM_DECAP_FUNC_THRU_L2 = 11,
	ULP_WP_SYM_DECAP_FUNC_THRU_L3 = 12,
	ULP_WP_SYM_DECAP_FUNC_THRU_L4 = 13,
	ULP_WP_SYM_ECV_VALID_NO = 0,
	ULP_WP_SYM_ECV_VALID_YES = 1,
	ULP_WP_SYM_ECV_CUSTOM_EN_NO = 0,
	ULP_WP_SYM_ECV_CUSTOM_EN_YES = 1,
	ULP_WP_SYM_ECV_L2_EN_NO = 0,
	ULP_WP_SYM_ECV_L2_EN_YES = 1,
	ULP_WP_SYM_ECV_VTAG_TYPE_NOP = 0,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_1_ENCAP_PRI = 1,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_1_IVLAN_PRI = 2,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_1_REMAP_DIFFSERV = 3,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_2_ENCAP_PRI = 4,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_2_REMAP_DIFFSERV = 5,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_ENCAP_PRI = 6,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_REMAP_DIFFSERV = 7,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_0 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_1 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_2 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_3 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_4 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_5 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_6 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_7 = 8,
	ULP_WP_SYM_ECV_L3_TYPE_NONE = 0,
	ULP_WP_SYM_ECV_L3_TYPE_IPV4 = 4,
	ULP_WP_SYM_ECV_L3_TYPE_IPV6 = 5,
	ULP_WP_SYM_ECV_L3_TYPE_MPLS_8847 = 6,
	ULP_WP_SYM_ECV_L3_TYPE_MPLS_8848 = 7,
	ULP_WP_SYM_ECV_L4_TYPE_NONE = 0,
	ULP_WP_SYM_ECV_L4_TYPE_UDP = 4,
	ULP_WP_SYM_ECV_L4_TYPE_UDP_CSUM = 5,
	ULP_WP_SYM_ECV_L4_TYPE_UDP_ENTROPY = 6,
	ULP_WP_SYM_ECV_L4_TYPE_UDP_ENTROPY_CSUM = 7,
	ULP_WP_SYM_ECV_TUN_TYPE_NONE = 0,
	ULP_WP_SYM_ECV_TUN_TYPE_GENERIC = 1,
	ULP_WP_SYM_ECV_TUN_TYPE_VXLAN = 2,
	ULP_WP_SYM_ECV_TUN_TYPE_NGE = 3,
	ULP_WP_SYM_ECV_TUN_TYPE_NVGRE = 4,
	ULP_WP_SYM_ECV_TUN_TYPE_GRE = 5,
	ULP_WP_SYM_EEM_ACT_REC_INT = 1,
	ULP_WP_SYM_EEM_EXT_FLOW_CNTR = 0,
	ULP_WP_SYM_UC_ACT_REC = 0,
	ULP_WP_SYM_MC_ACT_REC = 1,
	ULP_WP_SYM_ACT_REC_DROP_YES = 1,
	ULP_WP_SYM_ACT_REC_DROP_NO = 0,
	ULP_WP_SYM_ACT_REC_POP_VLAN_YES = 1,
	ULP_WP_SYM_ACT_REC_POP_VLAN_NO = 0,
	ULP_WP_SYM_ACT_REC_METER_EN_YES = 1,
	ULP_WP_SYM_ACT_REC_METER_EN_NO = 0,
	ULP_WP_SYM_LOOPBACK_PORT = 4,
	ULP_WP_SYM_LOOPBACK_PARIF = 15,
	ULP_WP_SYM_EXT_EM_MAX_KEY_SIZE = 448,
	ULP_WP_SYM_MATCH_TYPE_EM = 0,
	ULP_WP_SYM_MATCH_TYPE_WM = 1,
	ULP_WP_SYM_IP_PROTO_ICMP = 1,
	ULP_WP_SYM_IP_PROTO_IGMP = 2,
	ULP_WP_SYM_IP_PROTO_IP_IN_IP = 4,
	ULP_WP_SYM_IP_PROTO_TCP = 6,
	ULP_WP_SYM_IP_PROTO_UDP = 17,
	ULP_WP_SYM_VF_FUNC_PARIF = 15,
	ULP_WP_SYM_NO = 0,
	ULP_WP_SYM_YES = 1,
	ULP_WP_SYM_RECYCLE_DST = 0x800
};

enum ulp_thor_sym {
	ULP_THOR_SYM_METADATA_OP_NORMAL = 0,
	ULP_THOR_SYM_METADATA_OP_L2_HASH = 1,
	ULP_THOR_SYM_METADATA_OP_L4_HASH = 2,
	ULP_THOR_SYM_FWD_OP_BYPASS_CFA = 0,
	ULP_THOR_SYM_FWD_OP_BYPASS_CFA_ROCE = 1,
	ULP_THOR_SYM_FWD_OP_BYPASS_LKUP = 2,
	ULP_THOR_SYM_FWD_OP_NORMAL_FLOW = 3,
	ULP_THOR_SYM_CTXT_OPCODE_BYPASS_CFA = 0,
	ULP_THOR_SYM_CTXT_OPCODE_BYPASS_LKUP = 1,
	ULP_THOR_SYM_CTXT_OPCODE_META_UPDATE = 2,
	ULP_THOR_SYM_CTXT_OPCODE_NORMAL_FLOW = 3,
	ULP_THOR_SYM_CTXT_OPCODE_DROP = 4,
	ULP_THOR_SYM_PKT_TYPE_IGNORE = 0,
	ULP_THOR_SYM_PKT_TYPE_L2 = 0,
	ULP_THOR_SYM_PKT_TYPE_0_IGNORE = 0,
	ULP_THOR_SYM_PKT_TYPE_0_L2 = 0,
	ULP_THOR_SYM_PKT_TYPE_1_IGNORE = 0,
	ULP_THOR_SYM_PKT_TYPE_1_L2 = 0,
	ULP_THOR_SYM_RECYCLE_CNT_IGNORE = 0,
	ULP_THOR_SYM_RECYCLE_CNT_ZERO = 0,
	ULP_THOR_SYM_RECYCLE_CNT_ONE = 1,
	ULP_THOR_SYM_RECYCLE_CNT_TWO = 2,
	ULP_THOR_SYM_RECYCLE_CNT_THREE = 3,
	ULP_THOR_SYM_AGG_ERROR_IGNORE = 0,
	ULP_THOR_SYM_AGG_ERROR_NO = 0,
	ULP_THOR_SYM_AGG_ERROR_YES = 1,
	ULP_THOR_SYM_RESERVED_IGNORE = 0,
	ULP_THOR_SYM_HREC_NEXT_IGNORE = 0,
	ULP_THOR_SYM_HREC_NEXT_NO = 0,
	ULP_THOR_SYM_HREC_NEXT_YES = 1,
	ULP_THOR_SYM_TL2_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_TL2_HDR_VALID_NO = 0,
	ULP_THOR_SYM_TL2_HDR_VALID_YES = 1,
	ULP_THOR_SYM_TL2_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_TL2_HDR_TYPE_DIX = 0,
	ULP_THOR_SYM_TL2_UC_MC_BC_IGNORE = 0,
	ULP_THOR_SYM_TL2_UC_MC_BC_UC = 0,
	ULP_THOR_SYM_TL2_UC_MC_BC_MC = 2,
	ULP_THOR_SYM_TL2_UC_MC_BC_BC = 3,
	ULP_THOR_SYM_TL2_VTAG_PRESENT_IGNORE = 0,
	ULP_THOR_SYM_TL2_VTAG_PRESENT_NO = 0,
	ULP_THOR_SYM_TL2_VTAG_PRESENT_YES = 1,
	ULP_THOR_SYM_TL2_TWO_VTAGS_IGNORE = 0,
	ULP_THOR_SYM_TL2_TWO_VTAGS_NO = 0,
	ULP_THOR_SYM_TL2_TWO_VTAGS_YES = 1,
	ULP_THOR_SYM_TL3_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_TL3_HDR_VALID_NO = 0,
	ULP_THOR_SYM_TL3_HDR_VALID_YES = 1,
	ULP_THOR_SYM_TL3_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_TL3_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_TL3_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_TL3_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_TL3_HDR_TYPE_IPV4 = 0,
	ULP_THOR_SYM_TL3_HDR_TYPE_IPV6 = 1,
	ULP_THOR_SYM_TL3_HDR_ISIP_IGNORE = 0,
	ULP_THOR_SYM_TL3_HDR_ISIP_NO = 0,
	ULP_THOR_SYM_TL3_HDR_ISIP_YES = 1,
	ULP_THOR_SYM_TL3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_THOR_SYM_TL3_IPV6_CMP_SRC_NO = 0,
	ULP_THOR_SYM_TL3_IPV6_CMP_SRC_YES = 1,
	ULP_THOR_SYM_TL3_IPV6_CMP_DST_IGNORE = 0,
	ULP_THOR_SYM_TL3_IPV6_CMP_DST_NO = 0,
	ULP_THOR_SYM_TL3_IPV6_CMP_DST_YES = 1,
	ULP_THOR_SYM_TL4_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_TL4_HDR_VALID_NO = 0,
	ULP_THOR_SYM_TL4_HDR_VALID_YES = 1,
	ULP_THOR_SYM_TL4_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_TL4_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_TL4_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_NO = 0,
	ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_YES = 1,
	ULP_THOR_SYM_TL4_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_TL4_HDR_TYPE_TCP = 0,
	ULP_THOR_SYM_TL4_HDR_TYPE_UDP = 1,
	ULP_THOR_SYM_TUN_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_TUN_HDR_VALID_NO = 0,
	ULP_THOR_SYM_TUN_HDR_VALID_YES = 1,
	ULP_THOR_SYM_TUN_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_TUN_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_TUN_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_TUN_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_VXLAN = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_GENEVE = 1,
	ULP_THOR_SYM_TUN_HDR_TYPE_NVGRE = 2,
	ULP_THOR_SYM_TUN_HDR_TYPE_GRE = 3,
	ULP_THOR_SYM_TUN_HDR_TYPE_IPV4 = 4,
	ULP_THOR_SYM_TUN_HDR_TYPE_IPV6 = 5,
	ULP_THOR_SYM_TUN_HDR_TYPE_PPPOE = 6,
	ULP_THOR_SYM_TUN_HDR_TYPE_MPLS = 7,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR1 = 8,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR2 = 9,
	ULP_THOR_SYM_TUN_HDR_TYPE_NONE = 15,
	ULP_THOR_SYM_TUN_HDR_FLAGS_IGNORE = 0,
	ULP_THOR_SYM_L2_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_L2_HDR_VALID_NO = 0,
	ULP_THOR_SYM_L2_HDR_VALID_YES = 1,
	ULP_THOR_SYM_L2_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_L2_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_L2_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_L2_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_L2_HDR_TYPE_DIX = 0,
	ULP_THOR_SYM_L2_HDR_TYPE_LLC_SNAP = 1,
	ULP_THOR_SYM_L2_HDR_TYPE_LLC = 2,
	ULP_THOR_SYM_L2_UC_MC_BC_IGNORE = 0,
	ULP_THOR_SYM_L2_UC_MC_BC_UC = 0,
	ULP_THOR_SYM_L2_UC_MC_BC_MC = 2,
	ULP_THOR_SYM_L2_UC_MC_BC_BC = 3,
	ULP_THOR_SYM_L2_VTAG_PRESENT_IGNORE = 0,
	ULP_THOR_SYM_L2_VTAG_PRESENT_NO = 0,
	ULP_THOR_SYM_L2_VTAG_PRESENT_YES = 1,
	ULP_THOR_SYM_L2_TWO_VTAGS_IGNORE = 0,
	ULP_THOR_SYM_L2_TWO_VTAGS_NO = 0,
	ULP_THOR_SYM_L2_TWO_VTAGS_YES = 1,
	ULP_THOR_SYM_L3_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_L3_HDR_VALID_NO = 0,
	ULP_THOR_SYM_L3_HDR_VALID_YES = 1,
	ULP_THOR_SYM_L3_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_L3_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_L3_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_L3_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_L3_HDR_TYPE_IPV4 = 0,
	ULP_THOR_SYM_L3_HDR_TYPE_IPV6 = 1,
	ULP_THOR_SYM_L3_HDR_TYPE_ARP = 2,
	ULP_THOR_SYM_L3_HDR_TYPE_PTP = 3,
	ULP_THOR_SYM_L3_HDR_TYPE_EAPOL = 4,
	ULP_THOR_SYM_L3_HDR_TYPE_ROCE = 5,
	ULP_THOR_SYM_L3_HDR_TYPE_FCOE = 6,
	ULP_THOR_SYM_L3_HDR_TYPE_UPAR1 = 7,
	ULP_THOR_SYM_L3_HDR_TYPE_UPAR2 = 8,
	ULP_THOR_SYM_L3_HDR_ISIP_IGNORE = 0,
	ULP_THOR_SYM_L3_HDR_ISIP_NO = 0,
	ULP_THOR_SYM_L3_HDR_ISIP_YES = 1,
	ULP_THOR_SYM_L3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_THOR_SYM_L3_IPV6_CMP_SRC_NO = 0,
	ULP_THOR_SYM_L3_IPV6_CMP_SRC_YES = 1,
	ULP_THOR_SYM_L3_IPV6_CMP_DST_IGNORE = 0,
	ULP_THOR_SYM_L3_IPV6_CMP_DST_NO = 0,
	ULP_THOR_SYM_L3_IPV6_CMP_DST_YES = 1,
	ULP_THOR_SYM_L4_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_L4_HDR_VALID_NO = 0,
	ULP_THOR_SYM_L4_HDR_VALID_YES = 1,
	ULP_THOR_SYM_L4_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_L4_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_L4_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_L4_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_L4_HDR_TYPE_TCP = 0,
	ULP_THOR_SYM_L4_HDR_TYPE_UDP = 1,
	ULP_THOR_SYM_L4_HDR_TYPE_ICMP = 2,
	ULP_THOR_SYM_L4_HDR_TYPE_UPAR1 = 3,
	ULP_THOR_SYM_L4_HDR_TYPE_UPAR2 = 4,
	ULP_THOR_SYM_L4_HDR_TYPE_BTH_V1 = 5,
	ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_NO = 0,
	ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES = 1,
	ULP_THOR_SYM_POP_VLAN_NO = 0,
	ULP_THOR_SYM_POP_VLAN_YES = 1,
	ULP_THOR_SYM_VLAN_DEL_RPT_DISABLED = 0,
	ULP_THOR_SYM_VLAN_DEL_RPT_STRIP_OUTER = 1,
	ULP_THOR_SYM_VLAN_DEL_RPT_STRIP_BOTH = 2,
	ULP_THOR_SYM_VLAN_DEL_RPT_DYN_STRIP = 3,
	ULP_THOR_SYM_DECAP_FUNC_NONE = 0,
	ULP_THOR_SYM_DECAP_FUNC_THRU_TL2 = 3,
	ULP_THOR_SYM_DECAP_FUNC_THRU_TL3 = 8,
	ULP_THOR_SYM_DECAP_FUNC_THRU_TL4 = 9,
	ULP_THOR_SYM_DECAP_FUNC_THRU_TUN = 10,
	ULP_THOR_SYM_DECAP_FUNC_THRU_L2 = 11,
	ULP_THOR_SYM_DECAP_FUNC_THRU_L3 = 12,
	ULP_THOR_SYM_DECAP_FUNC_THRU_L4 = 13,
	ULP_THOR_SYM_ECV_VALID_NO = 0,
	ULP_THOR_SYM_ECV_VALID_YES = 1,
	ULP_THOR_SYM_ECV_CUSTOM_EN_NO = 0,
	ULP_THOR_SYM_ECV_CUSTOM_EN_YES = 1,
	ULP_THOR_SYM_ECV_L2_EN_NO = 0,
	ULP_THOR_SYM_ECV_L2_EN_YES = 1,
	ULP_THOR_SYM_ECV_VTAG_TYPE_NOP = 0,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_1_ENCAP_PRI = 1,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_1_IVLAN_PRI = 2,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_1_REMAP_DIFFSERV = 3,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_2_ENCAP_PRI = 4,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_2_REMAP_DIFFSERV = 5,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_ENCAP_PRI = 6,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_REMAP_DIFFSERV = 7,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_0 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_1 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_2 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_3 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_4 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_5 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_6 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_7 = 8,
	ULP_THOR_SYM_ECV_L3_TYPE_NONE = 0,
	ULP_THOR_SYM_ECV_L3_TYPE_IPV4 = 4,
	ULP_THOR_SYM_ECV_L3_TYPE_IPV6 = 5,
	ULP_THOR_SYM_ECV_L3_TYPE_MPLS_8847 = 6,
	ULP_THOR_SYM_ECV_L3_TYPE_MPLS_8848 = 7,
	ULP_THOR_SYM_ECV_L4_TYPE_NONE = 0,
	ULP_THOR_SYM_ECV_L4_TYPE_UDP = 4,
	ULP_THOR_SYM_ECV_L4_TYPE_UDP_CSUM = 5,
	ULP_THOR_SYM_ECV_L4_TYPE_UDP_ENTROPY = 6,
	ULP_THOR_SYM_ECV_L4_TYPE_UDP_ENTROPY_CSUM = 7,
	ULP_THOR_SYM_ECV_TUN_TYPE_NONE = 0,
	ULP_THOR_SYM_ECV_TUN_TYPE_GENERIC = 1,
	ULP_THOR_SYM_ECV_TUN_TYPE_VXLAN = 2,
	ULP_THOR_SYM_ECV_TUN_TYPE_NGE = 3,
	ULP_THOR_SYM_ECV_TUN_TYPE_NVGRE = 4,
	ULP_THOR_SYM_ECV_TUN_TYPE_GRE = 5,
	ULP_THOR_SYM_EEM_ACT_REC_INT = 0,
	ULP_THOR_SYM_EEM_EXT_FLOW_CNTR = 0,
	ULP_THOR_SYM_UC_ACT_REC = 0,
	ULP_THOR_SYM_MC_ACT_REC = 1,
	ULP_THOR_SYM_ACT_REC_DROP_YES = 1,
	ULP_THOR_SYM_ACT_REC_DROP_NO = 0,
	ULP_THOR_SYM_ACT_REC_POP_VLAN_YES = 1,
	ULP_THOR_SYM_ACT_REC_POP_VLAN_NO = 0,
	ULP_THOR_SYM_ACT_REC_METER_EN_YES = 1,
	ULP_THOR_SYM_ACT_REC_METER_EN_NO = 0,
	ULP_THOR_SYM_LOOPBACK_PORT = 16,
	ULP_THOR_SYM_LOOPBACK_PARIF = 15,
	ULP_THOR_SYM_EXT_EM_MAX_KEY_SIZE = 0,
	ULP_THOR_SYM_MATCH_TYPE_EM = 0,
	ULP_THOR_SYM_MATCH_TYPE_WM = 1,
	ULP_THOR_SYM_IP_PROTO_ICMP = 1,
	ULP_THOR_SYM_IP_PROTO_IGMP = 2,
	ULP_THOR_SYM_IP_PROTO_IP_IN_IP = 4,
	ULP_THOR_SYM_IP_PROTO_TCP = 6,
	ULP_THOR_SYM_IP_PROTO_UDP = 17,
	ULP_THOR_SYM_VF_FUNC_PARIF = 15,
	ULP_THOR_SYM_NO = 0,
	ULP_THOR_SYM_YES = 1,
	ULP_THOR_SYM_RECYCLE_DST = 0x800
};

enum bnxt_ulp_class_hid {
	BNXT_ULP_CLASS_HID_55dd = 0x55dd,
	BNXT_ULP_CLASS_HID_1df1 = 0x1df1,
	BNXT_ULP_CLASS_HID_3e55 = 0x3e55,
	BNXT_ULP_CLASS_HID_0649 = 0x0649,
	BNXT_ULP_CLASS_HID_1011 = 0x1011,
	BNXT_ULP_CLASS_HID_40e9 = 0x40e9,
	BNXT_ULP_CLASS_HID_3e99 = 0x3e99,
	BNXT_ULP_CLASS_HID_06ad = 0x06ad,
	BNXT_ULP_CLASS_HID_38c7 = 0x38c7,
	BNXT_ULP_CLASS_HID_00fb = 0x00fb,
	BNXT_ULP_CLASS_HID_24d3 = 0x24d3,
	BNXT_ULP_CLASS_HID_559b = 0x559b,
	BNXT_ULP_CLASS_HID_5003 = 0x5003,
	BNXT_ULP_CLASS_HID_1837 = 0x1837,
	BNXT_ULP_CLASS_HID_3bef = 0x3bef,
	BNXT_ULP_CLASS_HID_0403 = 0x0403,
	BNXT_ULP_CLASS_HID_3d3f = 0x3d3f,
	BNXT_ULP_CLASS_HID_0543 = 0x0543,
	BNXT_ULP_CLASS_HID_292b = 0x292b,
	BNXT_ULP_CLASS_HID_59e3 = 0x59e3,
	BNXT_ULP_CLASS_HID_5d3b = 0x5d3b,
	BNXT_ULP_CLASS_HID_254f = 0x254f,
	BNXT_ULP_CLASS_HID_4917 = 0x4917,
	BNXT_ULP_CLASS_HID_113b = 0x113b,
	BNXT_ULP_CLASS_HID_55fd = 0x55fd,
	BNXT_ULP_CLASS_HID_1dd1 = 0x1dd1,
	BNXT_ULP_CLASS_HID_3e75 = 0x3e75,
	BNXT_ULP_CLASS_HID_0669 = 0x0669,
	BNXT_ULP_CLASS_HID_1ba1 = 0x1ba1,
	BNXT_ULP_CLASS_HID_4c69 = 0x4c69,
	BNXT_ULP_CLASS_HID_0439 = 0x0439,
	BNXT_ULP_CLASS_HID_34e1 = 0x34e1,
	BNXT_ULP_CLASS_HID_0465 = 0x0465,
	BNXT_ULP_CLASS_HID_352d = 0x352d,
	BNXT_ULP_CLASS_HID_55b1 = 0x55b1,
	BNXT_ULP_CLASS_HID_1da5 = 0x1da5,
	BNXT_ULP_CLASS_HID_32fd = 0x32fd,
	BNXT_ULP_CLASS_HID_63a5 = 0x63a5,
	BNXT_ULP_CLASS_HID_1b75 = 0x1b75,
	BNXT_ULP_CLASS_HID_4c3d = 0x4c3d,
	BNXT_ULP_CLASS_HID_1031 = 0x1031,
	BNXT_ULP_CLASS_HID_40c9 = 0x40c9,
	BNXT_ULP_CLASS_HID_3eb9 = 0x3eb9,
	BNXT_ULP_CLASS_HID_068d = 0x068d,
	BNXT_ULP_CLASS_HID_5039 = 0x5039,
	BNXT_ULP_CLASS_HID_180d = 0x180d,
	BNXT_ULP_CLASS_HID_15fd = 0x15fd,
	BNXT_ULP_CLASS_HID_46b5 = 0x46b5,
	BNXT_ULP_CLASS_HID_303d = 0x303d,
	BNXT_ULP_CLASS_HID_60f5 = 0x60f5,
	BNXT_ULP_CLASS_HID_5ea5 = 0x5ea5,
	BNXT_ULP_CLASS_HID_2689 = 0x2689,
	BNXT_ULP_CLASS_HID_0771 = 0x0771,
	BNXT_ULP_CLASS_HID_3809 = 0x3809,
	BNXT_ULP_CLASS_HID_35f9 = 0x35f9,
	BNXT_ULP_CLASS_HID_66b1 = 0x66b1,
	BNXT_ULP_CLASS_HID_559d = 0x559d,
	BNXT_ULP_CLASS_HID_1db1 = 0x1db1,
	BNXT_ULP_CLASS_HID_3e15 = 0x3e15,
	BNXT_ULP_CLASS_HID_0609 = 0x0609,
	BNXT_ULP_CLASS_HID_1bc1 = 0x1bc1,
	BNXT_ULP_CLASS_HID_4c09 = 0x4c09,
	BNXT_ULP_CLASS_HID_0459 = 0x0459,
	BNXT_ULP_CLASS_HID_3481 = 0x3481,
	BNXT_ULP_CLASS_HID_0405 = 0x0405,
	BNXT_ULP_CLASS_HID_354d = 0x354d,
	BNXT_ULP_CLASS_HID_55d1 = 0x55d1,
	BNXT_ULP_CLASS_HID_1dc5 = 0x1dc5,
	BNXT_ULP_CLASS_HID_329d = 0x329d,
	BNXT_ULP_CLASS_HID_63c5 = 0x63c5,
	BNXT_ULP_CLASS_HID_1b15 = 0x1b15,
	BNXT_ULP_CLASS_HID_4c5d = 0x4c5d,
	BNXT_ULP_CLASS_HID_1051 = 0x1051,
	BNXT_ULP_CLASS_HID_40a9 = 0x40a9,
	BNXT_ULP_CLASS_HID_3ed9 = 0x3ed9,
	BNXT_ULP_CLASS_HID_06ed = 0x06ed,
	BNXT_ULP_CLASS_HID_5059 = 0x5059,
	BNXT_ULP_CLASS_HID_186d = 0x186d,
	BNXT_ULP_CLASS_HID_159d = 0x159d,
	BNXT_ULP_CLASS_HID_46d5 = 0x46d5,
	BNXT_ULP_CLASS_HID_305d = 0x305d,
	BNXT_ULP_CLASS_HID_6095 = 0x6095,
	BNXT_ULP_CLASS_HID_5ec5 = 0x5ec5,
	BNXT_ULP_CLASS_HID_26e9 = 0x26e9,
	BNXT_ULP_CLASS_HID_0711 = 0x0711,
	BNXT_ULP_CLASS_HID_3869 = 0x3869,
	BNXT_ULP_CLASS_HID_3599 = 0x3599,
	BNXT_ULP_CLASS_HID_66d1 = 0x66d1,
	BNXT_ULP_CLASS_HID_38e7 = 0x38e7,
	BNXT_ULP_CLASS_HID_00db = 0x00db,
	BNXT_ULP_CLASS_HID_24f3 = 0x24f3,
	BNXT_ULP_CLASS_HID_55bb = 0x55bb,
	BNXT_ULP_CLASS_HID_5023 = 0x5023,
	BNXT_ULP_CLASS_HID_1817 = 0x1817,
	BNXT_ULP_CLASS_HID_3bcf = 0x3bcf,
	BNXT_ULP_CLASS_HID_0423 = 0x0423,
	BNXT_ULP_CLASS_HID_58e3 = 0x58e3,
	BNXT_ULP_CLASS_HID_20d7 = 0x20d7,
	BNXT_ULP_CLASS_HID_448f = 0x448f,
	BNXT_ULP_CLASS_HID_0ce3 = 0x0ce3,
	BNXT_ULP_CLASS_HID_076b = 0x076b,
	BNXT_ULP_CLASS_HID_3813 = 0x3813,
	BNXT_ULP_CLASS_HID_5bcb = 0x5bcb,
	BNXT_ULP_CLASS_HID_243f = 0x243f,
	BNXT_ULP_CLASS_HID_144b = 0x144b,
	BNXT_ULP_CLASS_HID_4573 = 0x4573,
	BNXT_ULP_CLASS_HID_0057 = 0x0057,
	BNXT_ULP_CLASS_HID_311f = 0x311f,
	BNXT_ULP_CLASS_HID_2b87 = 0x2b87,
	BNXT_ULP_CLASS_HID_5c4f = 0x5c4f,
	BNXT_ULP_CLASS_HID_1793 = 0x1793,
	BNXT_ULP_CLASS_HID_485b = 0x485b,
	BNXT_ULP_CLASS_HID_3447 = 0x3447,
	BNXT_ULP_CLASS_HID_650f = 0x650f,
	BNXT_ULP_CLASS_HID_2053 = 0x2053,
	BNXT_ULP_CLASS_HID_511b = 0x511b,
	BNXT_ULP_CLASS_HID_4b83 = 0x4b83,
	BNXT_ULP_CLASS_HID_13f7 = 0x13f7,
	BNXT_ULP_CLASS_HID_37af = 0x37af,
	BNXT_ULP_CLASS_HID_6857 = 0x6857,
	BNXT_ULP_CLASS_HID_3d1f = 0x3d1f,
	BNXT_ULP_CLASS_HID_0563 = 0x0563,
	BNXT_ULP_CLASS_HID_290b = 0x290b,
	BNXT_ULP_CLASS_HID_59c3 = 0x59c3,
	BNXT_ULP_CLASS_HID_5d1b = 0x5d1b,
	BNXT_ULP_CLASS_HID_256f = 0x256f,
	BNXT_ULP_CLASS_HID_4937 = 0x4937,
	BNXT_ULP_CLASS_HID_111b = 0x111b,
	BNXT_ULP_CLASS_HID_5f4b = 0x5f4b,
	BNXT_ULP_CLASS_HID_275f = 0x275f,
	BNXT_ULP_CLASS_HID_4b67 = 0x4b67,
	BNXT_ULP_CLASS_HID_134b = 0x134b,
	BNXT_ULP_CLASS_HID_1683 = 0x1683,
	BNXT_ULP_CLASS_HID_475b = 0x475b,
	BNXT_ULP_CLASS_HID_02bf = 0x02bf,
	BNXT_ULP_CLASS_HID_3377 = 0x3377,
	BNXT_ULP_CLASS_HID_19db = 0x19db,
	BNXT_ULP_CLASS_HID_4a93 = 0x4a93,
	BNXT_ULP_CLASS_HID_05f7 = 0x05f7,
	BNXT_ULP_CLASS_HID_368f = 0x368f,
	BNXT_ULP_CLASS_HID_39c7 = 0x39c7,
	BNXT_ULP_CLASS_HID_022b = 0x022b,
	BNXT_ULP_CLASS_HID_25f3 = 0x25f3,
	BNXT_ULP_CLASS_HID_568b = 0x568b,
	BNXT_ULP_CLASS_HID_3c37 = 0x3c37,
	BNXT_ULP_CLASS_HID_041b = 0x041b,
	BNXT_ULP_CLASS_HID_2823 = 0x2823,
	BNXT_ULP_CLASS_HID_58fb = 0x58fb,
	BNXT_ULP_CLASS_HID_5c33 = 0x5c33,
	BNXT_ULP_CLASS_HID_2407 = 0x2407,
	BNXT_ULP_CLASS_HID_482f = 0x482f,
	BNXT_ULP_CLASS_HID_1033 = 0x1033,
	BNXT_ULP_CLASS_HID_3887 = 0x3887,
	BNXT_ULP_CLASS_HID_00bb = 0x00bb,
	BNXT_ULP_CLASS_HID_2493 = 0x2493,
	BNXT_ULP_CLASS_HID_55db = 0x55db,
	BNXT_ULP_CLASS_HID_5043 = 0x5043,
	BNXT_ULP_CLASS_HID_1877 = 0x1877,
	BNXT_ULP_CLASS_HID_3baf = 0x3baf,
	BNXT_ULP_CLASS_HID_0443 = 0x0443,
	BNXT_ULP_CLASS_HID_5883 = 0x5883,
	BNXT_ULP_CLASS_HID_20b7 = 0x20b7,
	BNXT_ULP_CLASS_HID_44ef = 0x44ef,
	BNXT_ULP_CLASS_HID_0c83 = 0x0c83,
	BNXT_ULP_CLASS_HID_070b = 0x070b,
	BNXT_ULP_CLASS_HID_3873 = 0x3873,
	BNXT_ULP_CLASS_HID_5bab = 0x5bab,
	BNXT_ULP_CLASS_HID_245f = 0x245f,
	BNXT_ULP_CLASS_HID_142b = 0x142b,
	BNXT_ULP_CLASS_HID_4513 = 0x4513,
	BNXT_ULP_CLASS_HID_0037 = 0x0037,
	BNXT_ULP_CLASS_HID_317f = 0x317f,
	BNXT_ULP_CLASS_HID_2be7 = 0x2be7,
	BNXT_ULP_CLASS_HID_5c2f = 0x5c2f,
	BNXT_ULP_CLASS_HID_17f3 = 0x17f3,
	BNXT_ULP_CLASS_HID_483b = 0x483b,
	BNXT_ULP_CLASS_HID_3427 = 0x3427,
	BNXT_ULP_CLASS_HID_656f = 0x656f,
	BNXT_ULP_CLASS_HID_2033 = 0x2033,
	BNXT_ULP_CLASS_HID_517b = 0x517b,
	BNXT_ULP_CLASS_HID_4be3 = 0x4be3,
	BNXT_ULP_CLASS_HID_1397 = 0x1397,
	BNXT_ULP_CLASS_HID_37cf = 0x37cf,
	BNXT_ULP_CLASS_HID_6837 = 0x6837,
	BNXT_ULP_CLASS_HID_3d7f = 0x3d7f,
	BNXT_ULP_CLASS_HID_0503 = 0x0503,
	BNXT_ULP_CLASS_HID_296b = 0x296b,
	BNXT_ULP_CLASS_HID_59a3 = 0x59a3,
	BNXT_ULP_CLASS_HID_5d7b = 0x5d7b,
	BNXT_ULP_CLASS_HID_250f = 0x250f,
	BNXT_ULP_CLASS_HID_4957 = 0x4957,
	BNXT_ULP_CLASS_HID_117b = 0x117b,
	BNXT_ULP_CLASS_HID_5f2b = 0x5f2b,
	BNXT_ULP_CLASS_HID_273f = 0x273f,
	BNXT_ULP_CLASS_HID_4b07 = 0x4b07,
	BNXT_ULP_CLASS_HID_132b = 0x132b,
	BNXT_ULP_CLASS_HID_16e3 = 0x16e3,
	BNXT_ULP_CLASS_HID_473b = 0x473b,
	BNXT_ULP_CLASS_HID_02df = 0x02df,
	BNXT_ULP_CLASS_HID_3317 = 0x3317,
	BNXT_ULP_CLASS_HID_19bb = 0x19bb,
	BNXT_ULP_CLASS_HID_4af3 = 0x4af3,
	BNXT_ULP_CLASS_HID_0597 = 0x0597,
	BNXT_ULP_CLASS_HID_36ef = 0x36ef,
	BNXT_ULP_CLASS_HID_39a7 = 0x39a7,
	BNXT_ULP_CLASS_HID_024b = 0x024b,
	BNXT_ULP_CLASS_HID_2593 = 0x2593,
	BNXT_ULP_CLASS_HID_56eb = 0x56eb,
	BNXT_ULP_CLASS_HID_3c57 = 0x3c57,
	BNXT_ULP_CLASS_HID_047b = 0x047b,
	BNXT_ULP_CLASS_HID_2843 = 0x2843,
	BNXT_ULP_CLASS_HID_589b = 0x589b,
	BNXT_ULP_CLASS_HID_5c53 = 0x5c53,
	BNXT_ULP_CLASS_HID_2467 = 0x2467,
	BNXT_ULP_CLASS_HID_484f = 0x484f,
	BNXT_ULP_CLASS_HID_1053 = 0x1053,
	BNXT_ULP_CLASS_HID_5ce1 = 0x5ce1,
	BNXT_ULP_CLASS_HID_4579 = 0x4579,
	BNXT_ULP_CLASS_HID_1735 = 0x1735,
	BNXT_ULP_CLASS_HID_45bd = 0x45bd,
	BNXT_ULP_CLASS_HID_3feb = 0x3feb,
	BNXT_ULP_CLASS_HID_2bf7 = 0x2bf7,
	BNXT_ULP_CLASS_HID_5727 = 0x5727,
	BNXT_ULP_CLASS_HID_4333 = 0x4333,
	BNXT_ULP_CLASS_HID_4453 = 0x4453,
	BNXT_ULP_CLASS_HID_304f = 0x304f,
	BNXT_ULP_CLASS_HID_645f = 0x645f,
	BNXT_ULP_CLASS_HID_504b = 0x504b,
	BNXT_ULP_CLASS_HID_5cc1 = 0x5cc1,
	BNXT_ULP_CLASS_HID_4559 = 0x4559,
	BNXT_ULP_CLASS_HID_2285 = 0x2285,
	BNXT_ULP_CLASS_HID_0b1d = 0x0b1d,
	BNXT_ULP_CLASS_HID_0b49 = 0x0b49,
	BNXT_ULP_CLASS_HID_5c95 = 0x5c95,
	BNXT_ULP_CLASS_HID_39c1 = 0x39c1,
	BNXT_ULP_CLASS_HID_2259 = 0x2259,
	BNXT_ULP_CLASS_HID_1715 = 0x1715,
	BNXT_ULP_CLASS_HID_459d = 0x459d,
	BNXT_ULP_CLASS_HID_571d = 0x571d,
	BNXT_ULP_CLASS_HID_1cd1 = 0x1cd1,
	BNXT_ULP_CLASS_HID_3711 = 0x3711,
	BNXT_ULP_CLASS_HID_6599 = 0x6599,
	BNXT_ULP_CLASS_HID_0e55 = 0x0e55,
	BNXT_ULP_CLASS_HID_3cdd = 0x3cdd,
	BNXT_ULP_CLASS_HID_5ca1 = 0x5ca1,
	BNXT_ULP_CLASS_HID_4539 = 0x4539,
	BNXT_ULP_CLASS_HID_22e5 = 0x22e5,
	BNXT_ULP_CLASS_HID_0b7d = 0x0b7d,
	BNXT_ULP_CLASS_HID_0b29 = 0x0b29,
	BNXT_ULP_CLASS_HID_5cf5 = 0x5cf5,
	BNXT_ULP_CLASS_HID_39a1 = 0x39a1,
	BNXT_ULP_CLASS_HID_2239 = 0x2239,
	BNXT_ULP_CLASS_HID_1775 = 0x1775,
	BNXT_ULP_CLASS_HID_45fd = 0x45fd,
	BNXT_ULP_CLASS_HID_577d = 0x577d,
	BNXT_ULP_CLASS_HID_1cb1 = 0x1cb1,
	BNXT_ULP_CLASS_HID_3771 = 0x3771,
	BNXT_ULP_CLASS_HID_65f9 = 0x65f9,
	BNXT_ULP_CLASS_HID_0e35 = 0x0e35,
	BNXT_ULP_CLASS_HID_3cbd = 0x3cbd,
	BNXT_ULP_CLASS_HID_3fcb = 0x3fcb,
	BNXT_ULP_CLASS_HID_2bd7 = 0x2bd7,
	BNXT_ULP_CLASS_HID_5707 = 0x5707,
	BNXT_ULP_CLASS_HID_4313 = 0x4313,
	BNXT_ULP_CLASS_HID_5fc7 = 0x5fc7,
	BNXT_ULP_CLASS_HID_4bd3 = 0x4bd3,
	BNXT_ULP_CLASS_HID_0e4f = 0x0e4f,
	BNXT_ULP_CLASS_HID_632f = 0x632f,
	BNXT_ULP_CLASS_HID_1baf = 0x1baf,
	BNXT_ULP_CLASS_HID_07bb = 0x07bb,
	BNXT_ULP_CLASS_HID_32eb = 0x32eb,
	BNXT_ULP_CLASS_HID_1ef7 = 0x1ef7,
	BNXT_ULP_CLASS_HID_3bab = 0x3bab,
	BNXT_ULP_CLASS_HID_27b7 = 0x27b7,
	BNXT_ULP_CLASS_HID_52e7 = 0x52e7,
	BNXT_ULP_CLASS_HID_3ef3 = 0x3ef3,
	BNXT_ULP_CLASS_HID_4473 = 0x4473,
	BNXT_ULP_CLASS_HID_306f = 0x306f,
	BNXT_ULP_CLASS_HID_647f = 0x647f,
	BNXT_ULP_CLASS_HID_506b = 0x506b,
	BNXT_ULP_CLASS_HID_66af = 0x66af,
	BNXT_ULP_CLASS_HID_525b = 0x525b,
	BNXT_ULP_CLASS_HID_1de7 = 0x1de7,
	BNXT_ULP_CLASS_HID_0993 = 0x0993,
	BNXT_ULP_CLASS_HID_213f = 0x213f,
	BNXT_ULP_CLASS_HID_0d2b = 0x0d2b,
	BNXT_ULP_CLASS_HID_413b = 0x413b,
	BNXT_ULP_CLASS_HID_2cd7 = 0x2cd7,
	BNXT_ULP_CLASS_HID_436b = 0x436b,
	BNXT_ULP_CLASS_HID_2f07 = 0x2f07,
	BNXT_ULP_CLASS_HID_6317 = 0x6317,
	BNXT_ULP_CLASS_HID_4f03 = 0x4f03,
	BNXT_ULP_CLASS_HID_3fab = 0x3fab,
	BNXT_ULP_CLASS_HID_2bb7 = 0x2bb7,
	BNXT_ULP_CLASS_HID_5767 = 0x5767,
	BNXT_ULP_CLASS_HID_4373 = 0x4373,
	BNXT_ULP_CLASS_HID_5fa7 = 0x5fa7,
	BNXT_ULP_CLASS_HID_4bb3 = 0x4bb3,
	BNXT_ULP_CLASS_HID_0e2f = 0x0e2f,
	BNXT_ULP_CLASS_HID_634f = 0x634f,
	BNXT_ULP_CLASS_HID_1bcf = 0x1bcf,
	BNXT_ULP_CLASS_HID_07db = 0x07db,
	BNXT_ULP_CLASS_HID_328b = 0x328b,
	BNXT_ULP_CLASS_HID_1e97 = 0x1e97,
	BNXT_ULP_CLASS_HID_3bcb = 0x3bcb,
	BNXT_ULP_CLASS_HID_27d7 = 0x27d7,
	BNXT_ULP_CLASS_HID_5287 = 0x5287,
	BNXT_ULP_CLASS_HID_3e93 = 0x3e93,
	BNXT_ULP_CLASS_HID_4413 = 0x4413,
	BNXT_ULP_CLASS_HID_300f = 0x300f,
	BNXT_ULP_CLASS_HID_641f = 0x641f,
	BNXT_ULP_CLASS_HID_500b = 0x500b,
	BNXT_ULP_CLASS_HID_66cf = 0x66cf,
	BNXT_ULP_CLASS_HID_523b = 0x523b,
	BNXT_ULP_CLASS_HID_1d87 = 0x1d87,
	BNXT_ULP_CLASS_HID_09f3 = 0x09f3,
	BNXT_ULP_CLASS_HID_215f = 0x215f,
	BNXT_ULP_CLASS_HID_0d4b = 0x0d4b,
	BNXT_ULP_CLASS_HID_415b = 0x415b,
	BNXT_ULP_CLASS_HID_2cb7 = 0x2cb7,
	BNXT_ULP_CLASS_HID_430b = 0x430b,
	BNXT_ULP_CLASS_HID_2f67 = 0x2f67,
	BNXT_ULP_CLASS_HID_6377 = 0x6377,
	BNXT_ULP_CLASS_HID_4f63 = 0x4f63,
	BNXT_ULP_CLASS_HID_29b5 = 0x29b5,
	BNXT_ULP_CLASS_HID_29ad = 0x29ad,
	BNXT_ULP_CLASS_HID_29b7 = 0x29b7,
	BNXT_ULP_CLASS_HID_1583 = 0x1583,
	BNXT_ULP_CLASS_HID_29af = 0x29af,
	BNXT_ULP_CLASS_HID_159b = 0x159b,
	BNXT_ULP_CLASS_HID_2995 = 0x2995,
	BNXT_ULP_CLASS_HID_298d = 0x298d,
	BNXT_ULP_CLASS_HID_29f5 = 0x29f5,
	BNXT_ULP_CLASS_HID_29ed = 0x29ed,
	BNXT_ULP_CLASS_HID_2997 = 0x2997,
	BNXT_ULP_CLASS_HID_15a3 = 0x15a3,
	BNXT_ULP_CLASS_HID_298f = 0x298f,
	BNXT_ULP_CLASS_HID_15bb = 0x15bb,
	BNXT_ULP_CLASS_HID_29f7 = 0x29f7,
	BNXT_ULP_CLASS_HID_15c3 = 0x15c3,
	BNXT_ULP_CLASS_HID_29ef = 0x29ef,
	BNXT_ULP_CLASS_HID_15db = 0x15db,
	BNXT_ULP_CLASS_HID_1151 = 0x1151,
	BNXT_ULP_CLASS_HID_315d = 0x315d,
	BNXT_ULP_CLASS_HID_3612 = 0x3612,
	BNXT_ULP_CLASS_HID_66da = 0x66da,
	BNXT_ULP_CLASS_HID_e082 = 0xe082,
	BNXT_ULP_CLASS_HID_ab46 = 0xab46,
	BNXT_ULP_CLASS_HID_c82a = 0xc82a,
	BNXT_ULP_CLASS_HID_f9a2 = 0xf9a2,
	BNXT_ULP_CLASS_HID_d8ce = 0xd8ce,
	BNXT_ULP_CLASS_HID_a2d2 = 0xa2d2,
	BNXT_ULP_CLASS_HID_c076 = 0xc076,
	BNXT_ULP_CLASS_HID_f1ee = 0xf1ee,
	BNXT_ULP_CLASS_HID_a96e = 0xa96e,
	BNXT_ULP_CLASS_HID_dae6 = 0xdae6,
	BNXT_ULP_CLASS_HID_c7aa = 0xc7aa,
	BNXT_ULP_CLASS_HID_c26e = 0xc26e,
	BNXT_ULP_CLASS_HID_a0fa = 0xa0fa,
	BNXT_ULP_CLASS_HID_d272 = 0xd272,
	BNXT_ULP_CLASS_HID_fff6 = 0xfff6,
	BNXT_ULP_CLASS_HID_e16e = 0xe16e,
	BNXT_ULP_CLASS_HID_e165 = 0xe165,
	BNXT_ULP_CLASS_HID_aaa1 = 0xaaa1,
	BNXT_ULP_CLASS_HID_c9cd = 0xc9cd,
	BNXT_ULP_CLASS_HID_f845 = 0xf845,
	BNXT_ULP_CLASS_HID_90f9 = 0x90f9,
	BNXT_ULP_CLASS_HID_c371 = 0xc371,
	BNXT_ULP_CLASS_HID_e19d = 0xe19d,
	BNXT_ULP_CLASS_HID_d015 = 0xd015,
	BNXT_ULP_CLASS_HID_8c09 = 0x8c09,
	BNXT_ULP_CLASS_HID_be89 = 0xbe89,
	BNXT_ULP_CLASS_HID_ddad = 0xddad,
	BNXT_ULP_CLASS_HID_cc2d = 0xcc2d,
	BNXT_ULP_CLASS_HID_a4d9 = 0xa4d9,
	BNXT_ULP_CLASS_HID_d759 = 0xd759,
	BNXT_ULP_CLASS_HID_f27d = 0xf27d,
	BNXT_ULP_CLASS_HID_e4fd = 0xe4fd,
	BNXT_ULP_CLASS_HID_ecf6 = 0xecf6,
	BNXT_ULP_CLASS_HID_a732 = 0xa732,
	BNXT_ULP_CLASS_HID_c45e = 0xc45e,
	BNXT_ULP_CLASS_HID_f5d6 = 0xf5d6,
	BNXT_ULP_CLASS_HID_d4ba = 0xd4ba,
	BNXT_ULP_CLASS_HID_aea6 = 0xaea6,
	BNXT_ULP_CLASS_HID_cc02 = 0xcc02,
	BNXT_ULP_CLASS_HID_fd9a = 0xfd9a,
	BNXT_ULP_CLASS_HID_a51a = 0xa51a,
	BNXT_ULP_CLASS_HID_d692 = 0xd692,
	BNXT_ULP_CLASS_HID_cbde = 0xcbde,
	BNXT_ULP_CLASS_HID_ce1a = 0xce1a,
	BNXT_ULP_CLASS_HID_ac8e = 0xac8e,
	BNXT_ULP_CLASS_HID_de06 = 0xde06,
	BNXT_ULP_CLASS_HID_f382 = 0xf382,
	BNXT_ULP_CLASS_HID_ed1a = 0xed1a,
	BNXT_ULP_CLASS_HID_9d6a = 0x9d6a,
	BNXT_ULP_CLASS_HID_cee2 = 0xcee2,
	BNXT_ULP_CLASS_HID_ec0e = 0xec0e,
	BNXT_ULP_CLASS_HID_dd86 = 0xdd86,
	BNXT_ULP_CLASS_HID_852e = 0x852e,
	BNXT_ULP_CLASS_HID_b6a6 = 0xb6a6,
	BNXT_ULP_CLASS_HID_eb82 = 0xeb82,
	BNXT_ULP_CLASS_HID_c50a = 0xc50a,
	BNXT_ULP_CLASS_HID_ccca = 0xccca,
	BNXT_ULP_CLASS_HID_8706 = 0x8706,
	BNXT_ULP_CLASS_HID_d38e = 0xd38e,
	BNXT_ULP_CLASS_HID_d5ca = 0xd5ca,
	BNXT_ULP_CLASS_HID_b48e = 0xb48e,
	BNXT_ULP_CLASS_HID_8e8a = 0x8e8a,
	BNXT_ULP_CLASS_HID_db02 = 0xdb02,
	BNXT_ULP_CLASS_HID_dd8e = 0xdd8e,
	BNXT_ULP_CLASS_HID_819a = 0x819a,
	BNXT_ULP_CLASS_HID_b31a = 0xb31a,
	BNXT_ULP_CLASS_HID_d03e = 0xd03e,
	BNXT_ULP_CLASS_HID_c1be = 0xc1be,
	BNXT_ULP_CLASS_HID_890e = 0x890e,
	BNXT_ULP_CLASS_HID_ba8e = 0xba8e,
	BNXT_ULP_CLASS_HID_dfaa = 0xdfaa,
	BNXT_ULP_CLASS_HID_c93a = 0xc93a,
	BNXT_ULP_CLASS_HID_b11a = 0xb11a,
	BNXT_ULP_CLASS_HID_8b4e = 0x8b4e,
	BNXT_ULP_CLASS_HID_c79e = 0xc79e,
	BNXT_ULP_CLASS_HID_d9da = 0xd9da,
	BNXT_ULP_CLASS_HID_b88e = 0xb88e,
	BNXT_ULP_CLASS_HID_ea0e = 0xea0e,
	BNXT_ULP_CLASS_HID_cf0a = 0xcf0a,
	BNXT_ULP_CLASS_HID_c18e = 0xc18e,
	BNXT_ULP_CLASS_HID_a94a = 0xa94a,
	BNXT_ULP_CLASS_HID_daca = 0xdaca,
	BNXT_ULP_CLASS_HID_ffee = 0xffee,
	BNXT_ULP_CLASS_HID_e96e = 0xe96e,
	BNXT_ULP_CLASS_HID_910e = 0x910e,
	BNXT_ULP_CLASS_HID_c28e = 0xc28e,
	BNXT_ULP_CLASS_HID_e7aa = 0xe7aa,
	BNXT_ULP_CLASS_HID_d12a = 0xd12a,
	BNXT_ULP_CLASS_HID_d8ca = 0xd8ca,
	BNXT_ULP_CLASS_HID_930e = 0x930e,
	BNXT_ULP_CLASS_HID_ef4e = 0xef4e,
	BNXT_ULP_CLASS_HID_e18a = 0xe18a,
	BNXT_ULP_CLASS_HID_c08e = 0xc08e,
	BNXT_ULP_CLASS_HID_9a8a = 0x9a8a,
	BNXT_ULP_CLASS_HID_d70a = 0xd70a,
	BNXT_ULP_CLASS_HID_e90e = 0xe90e,
	BNXT_ULP_CLASS_HID_edd9 = 0xedd9,
	BNXT_ULP_CLASS_HID_a61d = 0xa61d,
	BNXT_ULP_CLASS_HID_c571 = 0xc571,
	BNXT_ULP_CLASS_HID_f4f9 = 0xf4f9,
	BNXT_ULP_CLASS_HID_9c45 = 0x9c45,
	BNXT_ULP_CLASS_HID_cfcd = 0xcfcd,
	BNXT_ULP_CLASS_HID_ed21 = 0xed21,
	BNXT_ULP_CLASS_HID_dca9 = 0xdca9,
	BNXT_ULP_CLASS_HID_80b5 = 0x80b5,
	BNXT_ULP_CLASS_HID_b235 = 0xb235,
	BNXT_ULP_CLASS_HID_d111 = 0xd111,
	BNXT_ULP_CLASS_HID_c091 = 0xc091,
	BNXT_ULP_CLASS_HID_a865 = 0xa865,
	BNXT_ULP_CLASS_HID_dbe5 = 0xdbe5,
	BNXT_ULP_CLASS_HID_fec1 = 0xfec1,
	BNXT_ULP_CLASS_HID_e841 = 0xe841,
	BNXT_ULP_CLASS_HID_8e85 = 0x8e85,
	BNXT_ULP_CLASS_HID_b80d = 0xb80d,
	BNXT_ULP_CLASS_HID_df65 = 0xdf65,
	BNXT_ULP_CLASS_HID_ceed = 0xceed,
	BNXT_ULP_CLASS_HID_9645 = 0x9645,
	BNXT_ULP_CLASS_HID_c1cd = 0xc1cd,
	BNXT_ULP_CLASS_HID_e725 = 0xe725,
	BNXT_ULP_CLASS_HID_d6ad = 0xd6ad,
	BNXT_ULP_CLASS_HID_9aa5 = 0x9aa5,
	BNXT_ULP_CLASS_HID_b425 = 0xb425,
	BNXT_ULP_CLASS_HID_eb05 = 0xeb05,
	BNXT_ULP_CLASS_HID_da85 = 0xda85,
	BNXT_ULP_CLASS_HID_a265 = 0xa265,
	BNXT_ULP_CLASS_HID_dde5 = 0xdde5,
	BNXT_ULP_CLASS_HID_f0c5 = 0xf0c5,
	BNXT_ULP_CLASS_HID_e245 = 0xe245,
	BNXT_ULP_CLASS_HID_8b8f = 0x8b8f,
	BNXT_ULP_CLASS_HID_a517 = 0xa517,
	BNXT_ULP_CLASS_HID_d86b = 0xd86b,
	BNXT_ULP_CLASS_HID_cbf3 = 0xcbf3,
	BNXT_ULP_CLASS_HID_934f = 0x934f,
	BNXT_ULP_CLASS_HID_c2c7 = 0xc2c7,
	BNXT_ULP_CLASS_HID_e02b = 0xe02b,
	BNXT_ULP_CLASS_HID_d3a3 = 0xd3a3,
	BNXT_ULP_CLASS_HID_87a7 = 0x87a7,
	BNXT_ULP_CLASS_HID_b137 = 0xb137,
	BNXT_ULP_CLASS_HID_d403 = 0xd403,
	BNXT_ULP_CLASS_HID_c793 = 0xc793,
	BNXT_ULP_CLASS_HID_af67 = 0xaf67,
	BNXT_ULP_CLASS_HID_dee7 = 0xdee7,
	BNXT_ULP_CLASS_HID_fdc3 = 0xfdc3,
	BNXT_ULP_CLASS_HID_ef43 = 0xef43,
	BNXT_ULP_CLASS_HID_8dbf = 0x8dbf,
	BNXT_ULP_CLASS_HID_bf07 = 0xbf07,
	BNXT_ULP_CLASS_HID_d21f = 0xd21f,
	BNXT_ULP_CLASS_HID_cde7 = 0xcde7,
	BNXT_ULP_CLASS_HID_956f = 0x956f,
	BNXT_ULP_CLASS_HID_c4c7 = 0xc4c7,
	BNXT_ULP_CLASS_HID_fbcf = 0xfbcf,
	BNXT_ULP_CLASS_HID_d5a7 = 0xd5a7,
	BNXT_ULP_CLASS_HID_9957 = 0x9957,
	BNXT_ULP_CLASS_HID_cb27 = 0xcb27,
	BNXT_ULP_CLASS_HID_ee37 = 0xee37,
	BNXT_ULP_CLASS_HID_d987 = 0xd987,
	BNXT_ULP_CLASS_HID_a107 = 0xa107,
	BNXT_ULP_CLASS_HID_d0e7 = 0xd0e7,
	BNXT_ULP_CLASS_HID_f7e7 = 0xf7e7,
	BNXT_ULP_CLASS_HID_c827 = 0xc827,
	BNXT_ULP_CLASS_HID_f76a = 0xf76a,
	BNXT_ULP_CLASS_HID_bcae = 0xbcae,
	BNXT_ULP_CLASS_HID_dfc2 = 0xdfc2,
	BNXT_ULP_CLASS_HID_ee4a = 0xee4a,
	BNXT_ULP_CLASS_HID_cf26 = 0xcf26,
	BNXT_ULP_CLASS_HID_b53a = 0xb53a,
	BNXT_ULP_CLASS_HID_d79e = 0xd79e,
	BNXT_ULP_CLASS_HID_e606 = 0xe606,
	BNXT_ULP_CLASS_HID_be86 = 0xbe86,
	BNXT_ULP_CLASS_HID_cd0e = 0xcd0e,
	BNXT_ULP_CLASS_HID_d042 = 0xd042,
	BNXT_ULP_CLASS_HID_d586 = 0xd586,
	BNXT_ULP_CLASS_HID_b712 = 0xb712,
	BNXT_ULP_CLASS_HID_c59a = 0xc59a,
	BNXT_ULP_CLASS_HID_e81e = 0xe81e,
	BNXT_ULP_CLASS_HID_f686 = 0xf686,
	BNXT_ULP_CLASS_HID_86f6 = 0x86f6,
	BNXT_ULP_CLASS_HID_d57e = 0xd57e,
	BNXT_ULP_CLASS_HID_f792 = 0xf792,
	BNXT_ULP_CLASS_HID_c61a = 0xc61a,
	BNXT_ULP_CLASS_HID_9eb2 = 0x9eb2,
	BNXT_ULP_CLASS_HID_ad3a = 0xad3a,
	BNXT_ULP_CLASS_HID_f01e = 0xf01e,
	BNXT_ULP_CLASS_HID_de96 = 0xde96,
	BNXT_ULP_CLASS_HID_d756 = 0xd756,
	BNXT_ULP_CLASS_HID_9c9a = 0x9c9a,
	BNXT_ULP_CLASS_HID_c812 = 0xc812,
	BNXT_ULP_CLASS_HID_ce56 = 0xce56,
	BNXT_ULP_CLASS_HID_af12 = 0xaf12,
	BNXT_ULP_CLASS_HID_9516 = 0x9516,
	BNXT_ULP_CLASS_HID_c09e = 0xc09e,
	BNXT_ULP_CLASS_HID_c612 = 0xc612,
	BNXT_ULP_CLASS_HID_9a06 = 0x9a06,
	BNXT_ULP_CLASS_HID_a886 = 0xa886,
	BNXT_ULP_CLASS_HID_cba2 = 0xcba2,
	BNXT_ULP_CLASS_HID_da22 = 0xda22,
	BNXT_ULP_CLASS_HID_9292 = 0x9292,
	BNXT_ULP_CLASS_HID_a112 = 0xa112,
	BNXT_ULP_CLASS_HID_c436 = 0xc436,
	BNXT_ULP_CLASS_HID_d2a6 = 0xd2a6,
	BNXT_ULP_CLASS_HID_aa86 = 0xaa86,
	BNXT_ULP_CLASS_HID_90d2 = 0x90d2,
	BNXT_ULP_CLASS_HID_dc02 = 0xdc02,
	BNXT_ULP_CLASS_HID_c246 = 0xc246,
	BNXT_ULP_CLASS_HID_a312 = 0xa312,
	BNXT_ULP_CLASS_HID_f192 = 0xf192,
	BNXT_ULP_CLASS_HID_d496 = 0xd496,
	BNXT_ULP_CLASS_HID_da12 = 0xda12,
	BNXT_ULP_CLASS_HID_b2d6 = 0xb2d6,
	BNXT_ULP_CLASS_HID_c156 = 0xc156,
	BNXT_ULP_CLASS_HID_e472 = 0xe472,
	BNXT_ULP_CLASS_HID_f2f2 = 0xf2f2,
	BNXT_ULP_CLASS_HID_8a92 = 0x8a92,
	BNXT_ULP_CLASS_HID_d912 = 0xd912,
	BNXT_ULP_CLASS_HID_fc36 = 0xfc36,
	BNXT_ULP_CLASS_HID_cab6 = 0xcab6,
	BNXT_ULP_CLASS_HID_c356 = 0xc356,
	BNXT_ULP_CLASS_HID_8892 = 0x8892,
	BNXT_ULP_CLASS_HID_f4d2 = 0xf4d2,
	BNXT_ULP_CLASS_HID_fa16 = 0xfa16,
	BNXT_ULP_CLASS_HID_db12 = 0xdb12,
	BNXT_ULP_CLASS_HID_8116 = 0x8116,
	BNXT_ULP_CLASS_HID_cc96 = 0xcc96,
	BNXT_ULP_CLASS_HID_f292 = 0xf292,
	BNXT_ULP_CLASS_HID_e84d = 0xe84d,
	BNXT_ULP_CLASS_HID_a389 = 0xa389,
	BNXT_ULP_CLASS_HID_c0e5 = 0xc0e5,
	BNXT_ULP_CLASS_HID_f16d = 0xf16d,
	BNXT_ULP_CLASS_HID_99d1 = 0x99d1,
	BNXT_ULP_CLASS_HID_ca59 = 0xca59,
	BNXT_ULP_CLASS_HID_e8b5 = 0xe8b5,
	BNXT_ULP_CLASS_HID_d93d = 0xd93d,
	BNXT_ULP_CLASS_HID_8521 = 0x8521,
	BNXT_ULP_CLASS_HID_b7a1 = 0xb7a1,
	BNXT_ULP_CLASS_HID_d485 = 0xd485,
	BNXT_ULP_CLASS_HID_c505 = 0xc505,
	BNXT_ULP_CLASS_HID_adf1 = 0xadf1,
	BNXT_ULP_CLASS_HID_de71 = 0xde71,
	BNXT_ULP_CLASS_HID_fb55 = 0xfb55,
	BNXT_ULP_CLASS_HID_edd5 = 0xedd5,
	BNXT_ULP_CLASS_HID_8b11 = 0x8b11,
	BNXT_ULP_CLASS_HID_bd99 = 0xbd99,
	BNXT_ULP_CLASS_HID_daf1 = 0xdaf1,
	BNXT_ULP_CLASS_HID_cb79 = 0xcb79,
	BNXT_ULP_CLASS_HID_93d1 = 0x93d1,
	BNXT_ULP_CLASS_HID_c459 = 0xc459,
	BNXT_ULP_CLASS_HID_e2b1 = 0xe2b1,
	BNXT_ULP_CLASS_HID_d339 = 0xd339,
	BNXT_ULP_CLASS_HID_9f31 = 0x9f31,
	BNXT_ULP_CLASS_HID_b1b1 = 0xb1b1,
	BNXT_ULP_CLASS_HID_ee91 = 0xee91,
	BNXT_ULP_CLASS_HID_df11 = 0xdf11,
	BNXT_ULP_CLASS_HID_a7f1 = 0xa7f1,
	BNXT_ULP_CLASS_HID_d871 = 0xd871,
	BNXT_ULP_CLASS_HID_f551 = 0xf551,
	BNXT_ULP_CLASS_HID_e7d1 = 0xe7d1,
	BNXT_ULP_CLASS_HID_8e1b = 0x8e1b,
	BNXT_ULP_CLASS_HID_a083 = 0xa083,
	BNXT_ULP_CLASS_HID_ddff = 0xddff,
	BNXT_ULP_CLASS_HID_ce67 = 0xce67,
	BNXT_ULP_CLASS_HID_96db = 0x96db,
	BNXT_ULP_CLASS_HID_c753 = 0xc753,
	BNXT_ULP_CLASS_HID_e5bf = 0xe5bf,
	BNXT_ULP_CLASS_HID_d637 = 0xd637,
	BNXT_ULP_CLASS_HID_8233 = 0x8233,
	BNXT_ULP_CLASS_HID_b4a3 = 0xb4a3,
	BNXT_ULP_CLASS_HID_d197 = 0xd197,
	BNXT_ULP_CLASS_HID_c207 = 0xc207,
	BNXT_ULP_CLASS_HID_aaf3 = 0xaaf3,
	BNXT_ULP_CLASS_HID_db73 = 0xdb73,
	BNXT_ULP_CLASS_HID_f857 = 0xf857,
	BNXT_ULP_CLASS_HID_ead7 = 0xead7,
	BNXT_ULP_CLASS_HID_882b = 0x882b,
	BNXT_ULP_CLASS_HID_ba93 = 0xba93,
	BNXT_ULP_CLASS_HID_d78b = 0xd78b,
	BNXT_ULP_CLASS_HID_c873 = 0xc873,
	BNXT_ULP_CLASS_HID_90fb = 0x90fb,
	BNXT_ULP_CLASS_HID_c153 = 0xc153,
	BNXT_ULP_CLASS_HID_fe5b = 0xfe5b,
	BNXT_ULP_CLASS_HID_d033 = 0xd033,
	BNXT_ULP_CLASS_HID_9cc3 = 0x9cc3,
	BNXT_ULP_CLASS_HID_ceb3 = 0xceb3,
	BNXT_ULP_CLASS_HID_eba3 = 0xeba3,
	BNXT_ULP_CLASS_HID_dc13 = 0xdc13,
	BNXT_ULP_CLASS_HID_a493 = 0xa493,
	BNXT_ULP_CLASS_HID_d573 = 0xd573,
	BNXT_ULP_CLASS_HID_f273 = 0xf273,
	BNXT_ULP_CLASS_HID_cdb3 = 0xcdb3,
	BNXT_ULP_CLASS_HID_ff35 = 0xff35,
	BNXT_ULP_CLASS_HID_b4f1 = 0xb4f1,
	BNXT_ULP_CLASS_HID_d79d = 0xd79d,
	BNXT_ULP_CLASS_HID_e615 = 0xe615,
	BNXT_ULP_CLASS_HID_8ea9 = 0x8ea9,
	BNXT_ULP_CLASS_HID_dd21 = 0xdd21,
	BNXT_ULP_CLASS_HID_ffcd = 0xffcd,
	BNXT_ULP_CLASS_HID_ce45 = 0xce45,
	BNXT_ULP_CLASS_HID_9259 = 0x9259,
	BNXT_ULP_CLASS_HID_a0d9 = 0xa0d9,
	BNXT_ULP_CLASS_HID_c3fd = 0xc3fd,
	BNXT_ULP_CLASS_HID_d27d = 0xd27d,
	BNXT_ULP_CLASS_HID_ba89 = 0xba89,
	BNXT_ULP_CLASS_HID_c909 = 0xc909,
	BNXT_ULP_CLASS_HID_ec2d = 0xec2d,
	BNXT_ULP_CLASS_HID_faad = 0xfaad,
	BNXT_ULP_CLASS_HID_34c6 = 0x34c6,
	BNXT_ULP_CLASS_HID_0c22 = 0x0c22,
	BNXT_ULP_CLASS_HID_1cbe = 0x1cbe,
	BNXT_ULP_CLASS_HID_179a = 0x179a,
	BNXT_ULP_CLASS_HID_59be = 0x59be,
	BNXT_ULP_CLASS_HID_515a = 0x515a,
	BNXT_ULP_CLASS_HID_1c72 = 0x1c72,
	BNXT_ULP_CLASS_HID_171e = 0x171e,
	BNXT_ULP_CLASS_HID_19c8 = 0x19c8,
	BNXT_ULP_CLASS_HID_112c = 0x112c,
	BNXT_ULP_CLASS_HID_4d68 = 0x4d68,
	BNXT_ULP_CLASS_HID_444c = 0x444c,
	BNXT_ULP_CLASS_HID_0e8c = 0x0e8c,
	BNXT_ULP_CLASS_HID_09e0 = 0x09e0,
	BNXT_ULP_CLASS_HID_1af0 = 0x1af0,
	BNXT_ULP_CLASS_HID_15d4 = 0x15d4,
	BNXT_ULP_CLASS_HID_1dd0 = 0x1dd0,
	BNXT_ULP_CLASS_HID_14f4 = 0x14f4,
	BNXT_ULP_CLASS_HID_70b0 = 0x70b0,
	BNXT_ULP_CLASS_HID_4854 = 0x4854,
	BNXT_ULP_CLASS_HID_3dd4 = 0x3dd4,
	BNXT_ULP_CLASS_HID_34f8 = 0x34f8,
	BNXT_ULP_CLASS_HID_09e8 = 0x09e8,
	BNXT_ULP_CLASS_HID_008c = 0x008c,
	BNXT_ULP_CLASS_HID_34e6 = 0x34e6,
	BNXT_ULP_CLASS_HID_0c02 = 0x0c02,
	BNXT_ULP_CLASS_HID_1c9e = 0x1c9e,
	BNXT_ULP_CLASS_HID_17ba = 0x17ba,
	BNXT_ULP_CLASS_HID_429e = 0x429e,
	BNXT_ULP_CLASS_HID_5dba = 0x5dba,
	BNXT_ULP_CLASS_HID_2a16 = 0x2a16,
	BNXT_ULP_CLASS_HID_2532 = 0x2532,
	BNXT_ULP_CLASS_HID_2da2 = 0x2da2,
	BNXT_ULP_CLASS_HID_24fe = 0x24fe,
	BNXT_ULP_CLASS_HID_355a = 0x355a,
	BNXT_ULP_CLASS_HID_0c76 = 0x0c76,
	BNXT_ULP_CLASS_HID_13e6 = 0x13e6,
	BNXT_ULP_CLASS_HID_7276 = 0x7276,
	BNXT_ULP_CLASS_HID_42d2 = 0x42d2,
	BNXT_ULP_CLASS_HID_5dee = 0x5dee,
	BNXT_ULP_CLASS_HID_59de = 0x59de,
	BNXT_ULP_CLASS_HID_513a = 0x513a,
	BNXT_ULP_CLASS_HID_1c12 = 0x1c12,
	BNXT_ULP_CLASS_HID_177e = 0x177e,
	BNXT_ULP_CLASS_HID_0e92 = 0x0e92,
	BNXT_ULP_CLASS_HID_09fe = 0x09fe,
	BNXT_ULP_CLASS_HID_5c1a = 0x5c1a,
	BNXT_ULP_CLASS_HID_5746 = 0x5746,
	BNXT_ULP_CLASS_HID_79da = 0x79da,
	BNXT_ULP_CLASS_HID_7106 = 0x7106,
	BNXT_ULP_CLASS_HID_3c1e = 0x3c1e,
	BNXT_ULP_CLASS_HID_377a = 0x377a,
	BNXT_ULP_CLASS_HID_2e9e = 0x2e9e,
	BNXT_ULP_CLASS_HID_29fa = 0x29fa,
	BNXT_ULP_CLASS_HID_14d2 = 0x14d2,
	BNXT_ULP_CLASS_HID_7742 = 0x7742,
	BNXT_ULP_CLASS_HID_3706 = 0x3706,
	BNXT_ULP_CLASS_HID_0fe2 = 0x0fe2,
	BNXT_ULP_CLASS_HID_1f7e = 0x1f7e,
	BNXT_ULP_CLASS_HID_145a = 0x145a,
	BNXT_ULP_CLASS_HID_417e = 0x417e,
	BNXT_ULP_CLASS_HID_5e5a = 0x5e5a,
	BNXT_ULP_CLASS_HID_29f6 = 0x29f6,
	BNXT_ULP_CLASS_HID_26d2 = 0x26d2,
	BNXT_ULP_CLASS_HID_2e42 = 0x2e42,
	BNXT_ULP_CLASS_HID_271e = 0x271e,
	BNXT_ULP_CLASS_HID_36ba = 0x36ba,
	BNXT_ULP_CLASS_HID_0f96 = 0x0f96,
	BNXT_ULP_CLASS_HID_1006 = 0x1006,
	BNXT_ULP_CLASS_HID_7196 = 0x7196,
	BNXT_ULP_CLASS_HID_4132 = 0x4132,
	BNXT_ULP_CLASS_HID_5e0e = 0x5e0e,
	BNXT_ULP_CLASS_HID_59fe = 0x59fe,
	BNXT_ULP_CLASS_HID_511a = 0x511a,
	BNXT_ULP_CLASS_HID_1c32 = 0x1c32,
	BNXT_ULP_CLASS_HID_175e = 0x175e,
	BNXT_ULP_CLASS_HID_0eb2 = 0x0eb2,
	BNXT_ULP_CLASS_HID_09de = 0x09de,
	BNXT_ULP_CLASS_HID_5c3a = 0x5c3a,
	BNXT_ULP_CLASS_HID_5766 = 0x5766,
	BNXT_ULP_CLASS_HID_79fa = 0x79fa,
	BNXT_ULP_CLASS_HID_7126 = 0x7126,
	BNXT_ULP_CLASS_HID_3c3e = 0x3c3e,
	BNXT_ULP_CLASS_HID_375a = 0x375a,
	BNXT_ULP_CLASS_HID_2ebe = 0x2ebe,
	BNXT_ULP_CLASS_HID_29da = 0x29da,
	BNXT_ULP_CLASS_HID_14f2 = 0x14f2,
	BNXT_ULP_CLASS_HID_7762 = 0x7762,
	BNXT_ULP_CLASS_HID_19e8 = 0x19e8,
	BNXT_ULP_CLASS_HID_110c = 0x110c,
	BNXT_ULP_CLASS_HID_4d48 = 0x4d48,
	BNXT_ULP_CLASS_HID_446c = 0x446c,
	BNXT_ULP_CLASS_HID_0eac = 0x0eac,
	BNXT_ULP_CLASS_HID_09c0 = 0x09c0,
	BNXT_ULP_CLASS_HID_1ad0 = 0x1ad0,
	BNXT_ULP_CLASS_HID_15f4 = 0x15f4,
	BNXT_ULP_CLASS_HID_39ec = 0x39ec,
	BNXT_ULP_CLASS_HID_3100 = 0x3100,
	BNXT_ULP_CLASS_HID_0210 = 0x0210,
	BNXT_ULP_CLASS_HID_1d34 = 0x1d34,
	BNXT_ULP_CLASS_HID_2ea0 = 0x2ea0,
	BNXT_ULP_CLASS_HID_29c4 = 0x29c4,
	BNXT_ULP_CLASS_HID_3ad4 = 0x3ad4,
	BNXT_ULP_CLASS_HID_35e8 = 0x35e8,
	BNXT_ULP_CLASS_HID_5d80 = 0x5d80,
	BNXT_ULP_CLASS_HID_54a4 = 0x54a4,
	BNXT_ULP_CLASS_HID_29b4 = 0x29b4,
	BNXT_ULP_CLASS_HID_20c8 = 0x20c8,
	BNXT_ULP_CLASS_HID_7244 = 0x7244,
	BNXT_ULP_CLASS_HID_4d98 = 0x4d98,
	BNXT_ULP_CLASS_HID_5e68 = 0x5e68,
	BNXT_ULP_CLASS_HID_598c = 0x598c,
	BNXT_ULP_CLASS_HID_1248 = 0x1248,
	BNXT_ULP_CLASS_HID_74d8 = 0x74d8,
	BNXT_ULP_CLASS_HID_49a8 = 0x49a8,
	BNXT_ULP_CLASS_HID_40cc = 0x40cc,
	BNXT_ULP_CLASS_HID_0b0c = 0x0b0c,
	BNXT_ULP_CLASS_HID_0220 = 0x0220,
	BNXT_ULP_CLASS_HID_1730 = 0x1730,
	BNXT_ULP_CLASS_HID_7980 = 0x7980,
	BNXT_ULP_CLASS_HID_1db0 = 0x1db0,
	BNXT_ULP_CLASS_HID_1494 = 0x1494,
	BNXT_ULP_CLASS_HID_70d0 = 0x70d0,
	BNXT_ULP_CLASS_HID_4834 = 0x4834,
	BNXT_ULP_CLASS_HID_3db4 = 0x3db4,
	BNXT_ULP_CLASS_HID_3498 = 0x3498,
	BNXT_ULP_CLASS_HID_0988 = 0x0988,
	BNXT_ULP_CLASS_HID_00ec = 0x00ec,
	BNXT_ULP_CLASS_HID_3f44 = 0x3f44,
	BNXT_ULP_CLASS_HID_36a8 = 0x36a8,
	BNXT_ULP_CLASS_HID_0b58 = 0x0b58,
	BNXT_ULP_CLASS_HID_02bc = 0x02bc,
	BNXT_ULP_CLASS_HID_5f48 = 0x5f48,
	BNXT_ULP_CLASS_HID_56ac = 0x56ac,
	BNXT_ULP_CLASS_HID_2b5c = 0x2b5c,
	BNXT_ULP_CLASS_HID_2280 = 0x2280,
	BNXT_ULP_CLASS_HID_4000 = 0x4000,
	BNXT_ULP_CLASS_HID_5b64 = 0x5b64,
	BNXT_ULP_CLASS_HID_2c14 = 0x2c14,
	BNXT_ULP_CLASS_HID_2778 = 0x2778,
	BNXT_ULP_CLASS_HID_18f8 = 0x18f8,
	BNXT_ULP_CLASS_HID_13dc = 0x13dc,
	BNXT_ULP_CLASS_HID_4c18 = 0x4c18,
	BNXT_ULP_CLASS_HID_477c = 0x477c,
	BNXT_ULP_CLASS_HID_1a88 = 0x1a88,
	BNXT_ULP_CLASS_HID_15ec = 0x15ec,
	BNXT_ULP_CLASS_HID_4e28 = 0x4e28,
	BNXT_ULP_CLASS_HID_490c = 0x490c,
	BNXT_ULP_CLASS_HID_3a8c = 0x3a8c,
	BNXT_ULP_CLASS_HID_35f0 = 0x35f0,
	BNXT_ULP_CLASS_HID_06e0 = 0x06e0,
	BNXT_ULP_CLASS_HID_01c4 = 0x01c4,
	BNXT_ULP_CLASS_HID_1a08 = 0x1a08,
	BNXT_ULP_CLASS_HID_12ec = 0x12ec,
	BNXT_ULP_CLASS_HID_4ea8 = 0x4ea8,
	BNXT_ULP_CLASS_HID_478c = 0x478c,
	BNXT_ULP_CLASS_HID_0d4c = 0x0d4c,
	BNXT_ULP_CLASS_HID_0a20 = 0x0a20,
	BNXT_ULP_CLASS_HID_1930 = 0x1930,
	BNXT_ULP_CLASS_HID_1614 = 0x1614,
	BNXT_ULP_CLASS_HID_3a0c = 0x3a0c,
	BNXT_ULP_CLASS_HID_32e0 = 0x32e0,
	BNXT_ULP_CLASS_HID_01f0 = 0x01f0,
	BNXT_ULP_CLASS_HID_1ed4 = 0x1ed4,
	BNXT_ULP_CLASS_HID_2d40 = 0x2d40,
	BNXT_ULP_CLASS_HID_2a24 = 0x2a24,
	BNXT_ULP_CLASS_HID_3934 = 0x3934,
	BNXT_ULP_CLASS_HID_3608 = 0x3608,
	BNXT_ULP_CLASS_HID_5e60 = 0x5e60,
	BNXT_ULP_CLASS_HID_5744 = 0x5744,
	BNXT_ULP_CLASS_HID_2a54 = 0x2a54,
	BNXT_ULP_CLASS_HID_2328 = 0x2328,
	BNXT_ULP_CLASS_HID_71a4 = 0x71a4,
	BNXT_ULP_CLASS_HID_4e78 = 0x4e78,
	BNXT_ULP_CLASS_HID_5d88 = 0x5d88,
	BNXT_ULP_CLASS_HID_5a6c = 0x5a6c,
	BNXT_ULP_CLASS_HID_11a8 = 0x11a8,
	BNXT_ULP_CLASS_HID_7738 = 0x7738,
	BNXT_ULP_CLASS_HID_4a48 = 0x4a48,
	BNXT_ULP_CLASS_HID_432c = 0x432c,
	BNXT_ULP_CLASS_HID_08ec = 0x08ec,
	BNXT_ULP_CLASS_HID_01c0 = 0x01c0,
	BNXT_ULP_CLASS_HID_14d0 = 0x14d0,
	BNXT_ULP_CLASS_HID_7a60 = 0x7a60,
	BNXT_ULP_CLASS_HID_1d90 = 0x1d90,
	BNXT_ULP_CLASS_HID_14b4 = 0x14b4,
	BNXT_ULP_CLASS_HID_70f0 = 0x70f0,
	BNXT_ULP_CLASS_HID_4814 = 0x4814,
	BNXT_ULP_CLASS_HID_3d94 = 0x3d94,
	BNXT_ULP_CLASS_HID_34b8 = 0x34b8,
	BNXT_ULP_CLASS_HID_09a8 = 0x09a8,
	BNXT_ULP_CLASS_HID_00cc = 0x00cc,
	BNXT_ULP_CLASS_HID_3f64 = 0x3f64,
	BNXT_ULP_CLASS_HID_3688 = 0x3688,
	BNXT_ULP_CLASS_HID_0b78 = 0x0b78,
	BNXT_ULP_CLASS_HID_029c = 0x029c,
	BNXT_ULP_CLASS_HID_5f68 = 0x5f68,
	BNXT_ULP_CLASS_HID_568c = 0x568c,
	BNXT_ULP_CLASS_HID_2b7c = 0x2b7c,
	BNXT_ULP_CLASS_HID_22a0 = 0x22a0,
	BNXT_ULP_CLASS_HID_4020 = 0x4020,
	BNXT_ULP_CLASS_HID_5b44 = 0x5b44,
	BNXT_ULP_CLASS_HID_2c34 = 0x2c34,
	BNXT_ULP_CLASS_HID_2758 = 0x2758,
	BNXT_ULP_CLASS_HID_18d8 = 0x18d8,
	BNXT_ULP_CLASS_HID_13fc = 0x13fc,
	BNXT_ULP_CLASS_HID_4c38 = 0x4c38,
	BNXT_ULP_CLASS_HID_475c = 0x475c,
	BNXT_ULP_CLASS_HID_1aa8 = 0x1aa8,
	BNXT_ULP_CLASS_HID_15cc = 0x15cc,
	BNXT_ULP_CLASS_HID_4e08 = 0x4e08,
	BNXT_ULP_CLASS_HID_492c = 0x492c,
	BNXT_ULP_CLASS_HID_3aac = 0x3aac,
	BNXT_ULP_CLASS_HID_35d0 = 0x35d0,
	BNXT_ULP_CLASS_HID_06c0 = 0x06c0,
	BNXT_ULP_CLASS_HID_01e4 = 0x01e4,
	BNXT_ULP_CLASS_HID_4d32 = 0x4d32,
	BNXT_ULP_CLASS_HID_54aa = 0x54aa,
	BNXT_ULP_CLASS_HID_0686 = 0x0686,
	BNXT_ULP_CLASS_HID_540e = 0x540e,
	BNXT_ULP_CLASS_HID_2e3c = 0x2e3c,
	BNXT_ULP_CLASS_HID_3a20 = 0x3a20,
	BNXT_ULP_CLASS_HID_46f0 = 0x46f0,
	BNXT_ULP_CLASS_HID_52e4 = 0x52e4,
	BNXT_ULP_CLASS_HID_55e4 = 0x55e4,
	BNXT_ULP_CLASS_HID_21f8 = 0x21f8,
	BNXT_ULP_CLASS_HID_75e8 = 0x75e8,
	BNXT_ULP_CLASS_HID_41fc = 0x41fc,
	BNXT_ULP_CLASS_HID_4d12 = 0x4d12,
	BNXT_ULP_CLASS_HID_548a = 0x548a,
	BNXT_ULP_CLASS_HID_3356 = 0x3356,
	BNXT_ULP_CLASS_HID_1ace = 0x1ace,
	BNXT_ULP_CLASS_HID_1a9a = 0x1a9a,
	BNXT_ULP_CLASS_HID_4d46 = 0x4d46,
	BNXT_ULP_CLASS_HID_2812 = 0x2812,
	BNXT_ULP_CLASS_HID_338a = 0x338a,
	BNXT_ULP_CLASS_HID_06e6 = 0x06e6,
	BNXT_ULP_CLASS_HID_546e = 0x546e,
	BNXT_ULP_CLASS_HID_46ee = 0x46ee,
	BNXT_ULP_CLASS_HID_0d22 = 0x0d22,
	BNXT_ULP_CLASS_HID_26e2 = 0x26e2,
	BNXT_ULP_CLASS_HID_746a = 0x746a,
	BNXT_ULP_CLASS_HID_1fa6 = 0x1fa6,
	BNXT_ULP_CLASS_HID_2d2e = 0x2d2e,
	BNXT_ULP_CLASS_HID_4ef2 = 0x4ef2,
	BNXT_ULP_CLASS_HID_576a = 0x576a,
	BNXT_ULP_CLASS_HID_30b6 = 0x30b6,
	BNXT_ULP_CLASS_HID_192e = 0x192e,
	BNXT_ULP_CLASS_HID_197a = 0x197a,
	BNXT_ULP_CLASS_HID_4ea6 = 0x4ea6,
	BNXT_ULP_CLASS_HID_2bf2 = 0x2bf2,
	BNXT_ULP_CLASS_HID_306a = 0x306a,
	BNXT_ULP_CLASS_HID_06c6 = 0x06c6,
	BNXT_ULP_CLASS_HID_544e = 0x544e,
	BNXT_ULP_CLASS_HID_46ce = 0x46ce,
	BNXT_ULP_CLASS_HID_0d02 = 0x0d02,
	BNXT_ULP_CLASS_HID_26c2 = 0x26c2,
	BNXT_ULP_CLASS_HID_744a = 0x744a,
	BNXT_ULP_CLASS_HID_1f86 = 0x1f86,
	BNXT_ULP_CLASS_HID_2d0e = 0x2d0e,
	BNXT_ULP_CLASS_HID_2e1c = 0x2e1c,
	BNXT_ULP_CLASS_HID_3a00 = 0x3a00,
	BNXT_ULP_CLASS_HID_46d0 = 0x46d0,
	BNXT_ULP_CLASS_HID_52c4 = 0x52c4,
	BNXT_ULP_CLASS_HID_4e10 = 0x4e10,
	BNXT_ULP_CLASS_HID_5a04 = 0x5a04,
	BNXT_ULP_CLASS_HID_1f98 = 0x1f98,
	BNXT_ULP_CLASS_HID_72f8 = 0x72f8,
	BNXT_ULP_CLASS_HID_0a78 = 0x0a78,
	BNXT_ULP_CLASS_HID_166c = 0x166c,
	BNXT_ULP_CLASS_HID_233c = 0x233c,
	BNXT_ULP_CLASS_HID_0f20 = 0x0f20,
	BNXT_ULP_CLASS_HID_2a7c = 0x2a7c,
	BNXT_ULP_CLASS_HID_3660 = 0x3660,
	BNXT_ULP_CLASS_HID_4330 = 0x4330,
	BNXT_ULP_CLASS_HID_2f24 = 0x2f24,
	BNXT_ULP_CLASS_HID_5584 = 0x5584,
	BNXT_ULP_CLASS_HID_2198 = 0x2198,
	BNXT_ULP_CLASS_HID_7588 = 0x7588,
	BNXT_ULP_CLASS_HID_419c = 0x419c,
	BNXT_ULP_CLASS_HID_7758 = 0x7758,
	BNXT_ULP_CLASS_HID_43ac = 0x43ac,
	BNXT_ULP_CLASS_HID_0c10 = 0x0c10,
	BNXT_ULP_CLASS_HID_1864 = 0x1864,
	BNXT_ULP_CLASS_HID_30c8 = 0x30c8,
	BNXT_ULP_CLASS_HID_1cdc = 0x1cdc,
	BNXT_ULP_CLASS_HID_50cc = 0x50cc,
	BNXT_ULP_CLASS_HID_3d20 = 0x3d20,
	BNXT_ULP_CLASS_HID_529c = 0x529c,
	BNXT_ULP_CLASS_HID_3ef0 = 0x3ef0,
	BNXT_ULP_CLASS_HID_72e0 = 0x72e0,
	BNXT_ULP_CLASS_HID_5ef4 = 0x5ef4,
	BNXT_ULP_CLASS_HID_2dfc = 0x2dfc,
	BNXT_ULP_CLASS_HID_39e0 = 0x39e0,
	BNXT_ULP_CLASS_HID_4530 = 0x4530,
	BNXT_ULP_CLASS_HID_5124 = 0x5124,
	BNXT_ULP_CLASS_HID_4df0 = 0x4df0,
	BNXT_ULP_CLASS_HID_59e4 = 0x59e4,
	BNXT_ULP_CLASS_HID_1c78 = 0x1c78,
	BNXT_ULP_CLASS_HID_7118 = 0x7118,
	BNXT_ULP_CLASS_HID_0998 = 0x0998,
	BNXT_ULP_CLASS_HID_158c = 0x158c,
	BNXT_ULP_CLASS_HID_20dc = 0x20dc,
	BNXT_ULP_CLASS_HID_0cc0 = 0x0cc0,
	BNXT_ULP_CLASS_HID_299c = 0x299c,
	BNXT_ULP_CLASS_HID_3580 = 0x3580,
	BNXT_ULP_CLASS_HID_40d0 = 0x40d0,
	BNXT_ULP_CLASS_HID_2cc4 = 0x2cc4,
	BNXT_ULP_CLASS_HID_55a4 = 0x55a4,
	BNXT_ULP_CLASS_HID_21b8 = 0x21b8,
	BNXT_ULP_CLASS_HID_75a8 = 0x75a8,
	BNXT_ULP_CLASS_HID_41bc = 0x41bc,
	BNXT_ULP_CLASS_HID_7778 = 0x7778,
	BNXT_ULP_CLASS_HID_438c = 0x438c,
	BNXT_ULP_CLASS_HID_0c30 = 0x0c30,
	BNXT_ULP_CLASS_HID_1844 = 0x1844,
	BNXT_ULP_CLASS_HID_30e8 = 0x30e8,
	BNXT_ULP_CLASS_HID_1cfc = 0x1cfc,
	BNXT_ULP_CLASS_HID_50ec = 0x50ec,
	BNXT_ULP_CLASS_HID_3d00 = 0x3d00,
	BNXT_ULP_CLASS_HID_52bc = 0x52bc,
	BNXT_ULP_CLASS_HID_3ed0 = 0x3ed0,
	BNXT_ULP_CLASS_HID_72c0 = 0x72c0,
	BNXT_ULP_CLASS_HID_5ed4 = 0x5ed4,
	BNXT_ULP_CLASS_HID_3866 = 0x3866,
	BNXT_ULP_CLASS_HID_381e = 0x381e,
	BNXT_ULP_CLASS_HID_3860 = 0x3860,
	BNXT_ULP_CLASS_HID_0454 = 0x0454,
	BNXT_ULP_CLASS_HID_3818 = 0x3818,
	BNXT_ULP_CLASS_HID_042c = 0x042c,
	BNXT_ULP_CLASS_HID_3846 = 0x3846,
	BNXT_ULP_CLASS_HID_387e = 0x387e,
	BNXT_ULP_CLASS_HID_3ba6 = 0x3ba6,
	BNXT_ULP_CLASS_HID_385e = 0x385e,
	BNXT_ULP_CLASS_HID_3840 = 0x3840,
	BNXT_ULP_CLASS_HID_0474 = 0x0474,
	BNXT_ULP_CLASS_HID_3878 = 0x3878,
	BNXT_ULP_CLASS_HID_044c = 0x044c,
	BNXT_ULP_CLASS_HID_3ba0 = 0x3ba0,
	BNXT_ULP_CLASS_HID_0794 = 0x0794,
	BNXT_ULP_CLASS_HID_3858 = 0x3858,
	BNXT_ULP_CLASS_HID_046c = 0x046c
};

enum bnxt_ulp_act_hid {
	BNXT_ULP_ACT_HID_0000 = 0x0000,
	BNXT_ULP_ACT_HID_0001 = 0x0001,
	BNXT_ULP_ACT_HID_0400 = 0x0400,
	BNXT_ULP_ACT_HID_01ab = 0x01ab,
	BNXT_ULP_ACT_HID_0010 = 0x0010,
	BNXT_ULP_ACT_HID_05ab = 0x05ab,
	BNXT_ULP_ACT_HID_01bb = 0x01bb,
	BNXT_ULP_ACT_HID_0002 = 0x0002,
	BNXT_ULP_ACT_HID_0003 = 0x0003,
	BNXT_ULP_ACT_HID_0402 = 0x0402,
	BNXT_ULP_ACT_HID_01ad = 0x01ad,
	BNXT_ULP_ACT_HID_0012 = 0x0012,
	BNXT_ULP_ACT_HID_05ad = 0x05ad,
	BNXT_ULP_ACT_HID_01bd = 0x01bd,
	BNXT_ULP_ACT_HID_0613 = 0x0613,
	BNXT_ULP_ACT_HID_02a9 = 0x02a9,
	BNXT_ULP_ACT_HID_0054 = 0x0054,
	BNXT_ULP_ACT_HID_0622 = 0x0622,
	BNXT_ULP_ACT_HID_0454 = 0x0454,
	BNXT_ULP_ACT_HID_0064 = 0x0064,
	BNXT_ULP_ACT_HID_0614 = 0x0614,
	BNXT_ULP_ACT_HID_0615 = 0x0615,
	BNXT_ULP_ACT_HID_02ab = 0x02ab,
	BNXT_ULP_ACT_HID_0056 = 0x0056,
	BNXT_ULP_ACT_HID_0624 = 0x0624,
	BNXT_ULP_ACT_HID_0456 = 0x0456,
	BNXT_ULP_ACT_HID_0066 = 0x0066,
	BNXT_ULP_ACT_HID_048d = 0x048d,
	BNXT_ULP_ACT_HID_048f = 0x048f,
	BNXT_ULP_ACT_HID_04bc = 0x04bc,
	BNXT_ULP_ACT_HID_00a9 = 0x00a9,
	BNXT_ULP_ACT_HID_020f = 0x020f,
	BNXT_ULP_ACT_HID_0153 = 0x0153,
	BNXT_ULP_ACT_HID_04a9 = 0x04a9,
	BNXT_ULP_ACT_HID_01fc = 0x01fc,
	BNXT_ULP_ACT_HID_04be = 0x04be,
	BNXT_ULP_ACT_HID_00ab = 0x00ab,
	BNXT_ULP_ACT_HID_0211 = 0x0211,
	BNXT_ULP_ACT_HID_0155 = 0x0155,
	BNXT_ULP_ACT_HID_04ab = 0x04ab,
	BNXT_ULP_ACT_HID_01fe = 0x01fe,
	BNXT_ULP_ACT_HID_0667 = 0x0667,
	BNXT_ULP_ACT_HID_0254 = 0x0254,
	BNXT_ULP_ACT_HID_03ba = 0x03ba,
	BNXT_ULP_ACT_HID_02fe = 0x02fe,
	BNXT_ULP_ACT_HID_0654 = 0x0654,
	BNXT_ULP_ACT_HID_03a7 = 0x03a7,
	BNXT_ULP_ACT_HID_0669 = 0x0669,
	BNXT_ULP_ACT_HID_0256 = 0x0256,
	BNXT_ULP_ACT_HID_03bc = 0x03bc,
	BNXT_ULP_ACT_HID_0300 = 0x0300,
	BNXT_ULP_ACT_HID_0656 = 0x0656,
	BNXT_ULP_ACT_HID_03a9 = 0x03a9,
	BNXT_ULP_ACT_HID_021b = 0x021b,
	BNXT_ULP_ACT_HID_021c = 0x021c,
	BNXT_ULP_ACT_HID_021e = 0x021e,
	BNXT_ULP_ACT_HID_063f = 0x063f,
	BNXT_ULP_ACT_HID_0510 = 0x0510,
	BNXT_ULP_ACT_HID_03c6 = 0x03c6,
	BNXT_ULP_ACT_HID_0082 = 0x0082,
	BNXT_ULP_ACT_HID_06bb = 0x06bb,
	BNXT_ULP_ACT_HID_021d = 0x021d,
	BNXT_ULP_ACT_HID_0641 = 0x0641,
	BNXT_ULP_ACT_HID_0512 = 0x0512,
	BNXT_ULP_ACT_HID_03c8 = 0x03c8,
	BNXT_ULP_ACT_HID_0084 = 0x0084,
	BNXT_ULP_ACT_HID_06bd = 0x06bd,
	BNXT_ULP_ACT_HID_06d7 = 0x06d7,
	BNXT_ULP_ACT_HID_02c4 = 0x02c4,
	BNXT_ULP_ACT_HID_042a = 0x042a,
	BNXT_ULP_ACT_HID_036e = 0x036e,
	BNXT_ULP_ACT_HID_06c4 = 0x06c4,
	BNXT_ULP_ACT_HID_0417 = 0x0417,
	BNXT_ULP_ACT_HID_06d9 = 0x06d9,
	BNXT_ULP_ACT_HID_02c6 = 0x02c6,
	BNXT_ULP_ACT_HID_042c = 0x042c,
	BNXT_ULP_ACT_HID_0370 = 0x0370,
	BNXT_ULP_ACT_HID_06c6 = 0x06c6,
	BNXT_ULP_ACT_HID_0419 = 0x0419,
	BNXT_ULP_ACT_HID_0119 = 0x0119,
	BNXT_ULP_ACT_HID_046f = 0x046f,
	BNXT_ULP_ACT_HID_05d5 = 0x05d5,
	BNXT_ULP_ACT_HID_0519 = 0x0519,
	BNXT_ULP_ACT_HID_0106 = 0x0106,
	BNXT_ULP_ACT_HID_05c2 = 0x05c2,
	BNXT_ULP_ACT_HID_011b = 0x011b,
	BNXT_ULP_ACT_HID_0471 = 0x0471,
	BNXT_ULP_ACT_HID_05d7 = 0x05d7,
	BNXT_ULP_ACT_HID_051b = 0x051b,
	BNXT_ULP_ACT_HID_0108 = 0x0108,
	BNXT_ULP_ACT_HID_05c4 = 0x05c4,
	BNXT_ULP_ACT_HID_00a2 = 0x00a2,
	BNXT_ULP_ACT_HID_00a4 = 0x00a4
};

enum bnxt_ulp_df_tpl {
	BNXT_ULP_DF_TPL_DEFAULT_UPLINK_PORT = 4,
	BNXT_ULP_DF_TPL_DEFAULT_VFR = 5
};

#endif
