/*
 * Blackfin testcase for testing illegal/legal 32-bit opcodes from userspace
 * we track all instructions which cause some sort of exception when run from
 * userspace, this is normally EXCAUSE :
 *  - 0x21 : illegal instruction
 *  - 0x22 : illegal instruction combination
 *  - 0x2e : use of supervisor resource from userspace
 * and walk every instruction from 0x00000000 to 0xffffffff (and have 0xc000 set)
 */

# Don't want to enable for normal `make check` as it takes way too long in
# the sim -- executes over 3 billion insns, and even at 10 MIPS, that's 10+
# minutes.  Useful for directed testing, but that's about it.
# mach: none
# sim: --environment operating
# xfail: too many invalid insns are decoded as valid

#include "test.h"

#define SE_ALL_BITS 32
#include "se_allopcodes.h"
	.include "testutils.inc"

.macro se_all_load_insn
	R2 = [P5];
	R0 = R2 << 16;
	R1 = R2 >> 16;
	R0 = R0 | R1;
.endm

.macro se_all_next_insn
	/* increment, and go again. */
	R0 = R2;

	/* Is this the last insn we'll execute ? */
	imm32 R1, 0xfffff7ff;
	CC = R1 == R0;
	IF CC JUMP pass_lvl;

	/* cut across the opcode space in an efficient manner:
	 * increment the high 16bits first since the low 16bits encode
	 * the type of insn ... */
	imm32 R1, 0x10000;
	R0 = R1 + R0;
	CC = R1 < R0 (IU);
	IF CC jump 1f (bp);

	R0 += 1;
	/* skip any 16bit insn chunks */
	R1 = R0;
	R1.L = 0xC000;
	CC = R0 < R1 (IU);
	IF CC R0 = R1;
1:

	/* skip parallel insns */
	R1 = R0;
	R1.L = 0xe800;	/* allow linkage insns */
	CC = R0 == R1;
	IF CC jump 1f;
	CC = BITTST (R0, 11);
	IF !CC jump 1f (bp);
	R1 = 0x800;
	R0 = R0 + R1;
1:

.ifndef BFIN_JTAG
	/* Skip debug insns when running in the sim.  */
	R1.L = 0xff00;
	R1.H = 0x0000;
	R2 = R0 & R1;
	R1.L = 0xf000;
	CC = R1 == R2;
	IF !CC jump 1f (bp);
	R0.L = 0xf100;
	R0.H = 0x0000;
1:
.endif

	[P5] = R0;
.endm

.macro se_all_insn_init
	.dw 0xc000;
	.dw 0x0000;
.endm
.macro se_all_insn_table
	/* this table must be sorted, and end with zero */
	/* start		end			SEQSTAT */
	.dw 0x1a00, 0xc000,	0x1fff, 0xc000,		0x21, 0
	.dw 0x3a00, 0xc000,	0x3fff, 0xc000,		0x21, 0
	.dw 0x5a00, 0xc000,	0x5fff, 0xc000,		0x21, 0
	.dw 0x7a00, 0xc000,	0x7fff, 0xc000,		0x21, 0
	.dw 0x9a00, 0xc000,	0x9fff, 0xc000,		0x21, 0
	.dw 0xba00, 0xc000,	0xbfff, 0xc000,		0x21, 0
	.dw 0xda00, 0xc000,	0xdfff, 0xc000,		0x21, 0
	.dw 0xfa00, 0xc000,	0xffff, 0xc000,		0x21, 0
	.dw 0x1a00, 0xc001,	0x1fff, 0xc001,		0x21, 0
	.dw 0x3a00, 0xc001,	0x3fff, 0xc001,		0x21, 0
	.dw 0x5a00, 0xc001,	0x5fff, 0xc001,		0x21, 0
	.dw 0x7a00, 0xc001,	0x7fff, 0xc001,		0x21, 0
	.dw 0x9a00, 0xc001,	0x9fff, 0xc001,		0x21, 0
	.dw 0xba00, 0xc001,	0xbfff, 0xc001,		0x21, 0
	.dw 0xda00, 0xc001,	0xdfff, 0xc001,		0x21, 0
	.dw 0xfa00, 0xc001,	0xffff, 0xc001,		0x21, 0
	.dw 0x1a00, 0xc002,	0x1fff, 0xc002,		0x21, 0
	.dw 0x3a00, 0xc002,	0x3fff, 0xc002,		0x21, 0
	.dw 0x5a00, 0xc002,	0x5fff, 0xc002,		0x21, 0
	.dw 0x7a00, 0xc002,	0x7fff, 0xc002,		0x21, 0
	.dw 0x9a00, 0xc002,	0x9fff, 0xc002,		0x21, 0
	.dw 0xba00, 0xc002,	0xbfff, 0xc002,		0x21, 0
	.dw 0xda00, 0xc002,	0xdfff, 0xc002,		0x21, 0
	.dw 0xfa00, 0xc002,	0xffff, 0xc002,		0x21, 0
	.dw 0x1a00, 0xc003,	0x1fff, 0xc003,		0x21, 0
	.dw 0x3a00, 0xc003,	0xffff, 0xc003,		0x21, 0
	.dw 0x1a00, 0xc004,	0x1fff, 0xc004,		0x21, 0
	.dw 0x3a00, 0xc004,	0x3fff, 0xc004,		0x21, 0
	.dw 0x5a00, 0xc004,	0x5fff, 0xc004,		0x21, 0
	.dw 0x7a00, 0xc004,	0x7fff, 0xc004,		0x21, 0
	.dw 0x9a00, 0xc004,	0x9fff, 0xc004,		0x21, 0
	.dw 0xba00, 0xc004,	0xbfff, 0xc004,		0x21, 0
	.dw 0xda00, 0xc004,	0xdfff, 0xc004,		0x21, 0
	.dw 0xfa00, 0xc004,	0xffff, 0xc004,		0x21, 0
	.dw 0x1a00, 0xc005,	0x1fff, 0xc005,		0x21, 0
	.dw 0x3a00, 0xc005,	0x3fff, 0xc005,		0x21, 0
	.dw 0x5a00, 0xc005,	0x5fff, 0xc005,		0x21, 0
	.dw 0x7a00, 0xc005,	0x7fff, 0xc005,		0x21, 0
	.dw 0x9a00, 0xc005,	0x9fff, 0xc005,		0x21, 0
	.dw 0xba00, 0xc005,	0xbfff, 0xc005,		0x21, 0
	.dw 0xda00, 0xc005,	0xdfff, 0xc005,		0x21, 0
	.dw 0xfa00, 0xc005,	0xffff, 0xc005,		0x21, 0
	.dw 0x1a00, 0xc006,	0x1fff, 0xc006,		0x21, 0
	.dw 0x3a00, 0xc006,	0x3fff, 0xc006,		0x21, 0
	.dw 0x5a00, 0xc006,	0x5fff, 0xc006,		0x21, 0
	.dw 0x7a00, 0xc006,	0x7fff, 0xc006,		0x21, 0
	.dw 0x9a00, 0xc006,	0x9fff, 0xc006,		0x21, 0
	.dw 0xba00, 0xc006,	0xbfff, 0xc006,		0x21, 0
	.dw 0xda00, 0xc006,	0xdfff, 0xc006,		0x21, 0
	.dw 0xfa00, 0xc006,	0xffff, 0xc006,		0x21, 0
	.dw 0x1a00, 0xc007,	0x1fff, 0xc007,		0x21, 0
	.dw 0x3a00, 0xc007,	0x1fff, 0xc008,		0x21, 0
	.dw 0x2040, 0xc008,	0x207f, 0xc008,		0x21, 0
	.dw 0x20c0, 0xc008,	0x20ff, 0xc008,		0x21, 0
	.dw 0x2140, 0xc008,	0x217f, 0xc008,		0x21, 0
	.dw 0x21c0, 0xc008,	0x21ff, 0xc008,		0x21, 0
	.dw 0x2240, 0xc008,	0x227f, 0xc008,		0x21, 0
	.dw 0x22c0, 0xc008,	0x22ff, 0xc008,		0x21, 0
	.dw 0x2340, 0xc008,	0x237f, 0xc008,		0x21, 0
	.dw 0x23c0, 0xc008,	0x23ff, 0xc008,		0x21, 0
	.dw 0x2440, 0xc008,	0x247f, 0xc008,		0x21, 0
	.dw 0x24c0, 0xc008,	0x24ff, 0xc008,		0x21, 0
	.dw 0x2540, 0xc008,	0x257f, 0xc008,		0x21, 0
	.dw 0x25c0, 0xc008,	0x25ff, 0xc008,		0x21, 0
	.dw 0x2640, 0xc008,	0x267f, 0xc008,		0x21, 0
	.dw 0x26c0, 0xc008,	0x26ff, 0xc008,		0x21, 0
	.dw 0x2740, 0xc008,	0x277f, 0xc008,		0x21, 0
	.dw 0x27c0, 0xc008,	0x27ff, 0xc008,		0x21, 0
	.dw 0x2840, 0xc008,	0x287f, 0xc008,		0x21, 0
	.dw 0x28c0, 0xc008,	0x28ff, 0xc008,		0x21, 0
	.dw 0x2940, 0xc008,	0x297f, 0xc008,		0x21, 0
	.dw 0x29c0, 0xc008,	0x29ff, 0xc008,		0x21, 0
	.dw 0x2a40, 0xc008,	0x2a7f, 0xc008,		0x21, 0
	.dw 0x2ac0, 0xc008,	0x2aff, 0xc008,		0x21, 0
	.dw 0x2b40, 0xc008,	0x2b7f, 0xc008,		0x21, 0
	.dw 0x2bc0, 0xc008,	0x2bff, 0xc008,		0x21, 0
	.dw 0x2c40, 0xc008,	0x2c7f, 0xc008,		0x21, 0
	.dw 0x2cc0, 0xc008,	0x2cff, 0xc008,		0x21, 0
	.dw 0x2d40, 0xc008,	0x2d7f, 0xc008,		0x21, 0
	.dw 0x2dc0, 0xc008,	0x2dff, 0xc008,		0x21, 0
	.dw 0x2e40, 0xc008,	0x2e7f, 0xc008,		0x21, 0
	.dw 0x2ec0, 0xc008,	0x2eff, 0xc008,		0x21, 0
	.dw 0x2f40, 0xc008,	0x2f7f, 0xc008,		0x21, 0
	.dw 0x2fc0, 0xc008,	0x2fff, 0xc008,		0x21, 0
	.dw 0x3040, 0xc008,	0x307f, 0xc008,		0x21, 0
	.dw 0x30c0, 0xc008,	0x30ff, 0xc008,		0x21, 0
	.dw 0x3140, 0xc008,	0x317f, 0xc008,		0x21, 0
	.dw 0x31c0, 0xc008,	0x31ff, 0xc008,		0x21, 0
	.dw 0x3240, 0xc008,	0x327f, 0xc008,		0x21, 0
	.dw 0x32c0, 0xc008,	0x32ff, 0xc008,		0x21, 0
	.dw 0x3340, 0xc008,	0x337f, 0xc008,		0x21, 0
	.dw 0x33c0, 0xc008,	0x33ff, 0xc008,		0x21, 0
	.dw 0x3440, 0xc008,	0x347f, 0xc008,		0x21, 0
	.dw 0x34c0, 0xc008,	0x34ff, 0xc008,		0x21, 0
	.dw 0x3540, 0xc008,	0x357f, 0xc008,		0x21, 0
	.dw 0x35c0, 0xc008,	0x35ff, 0xc008,		0x21, 0
	.dw 0x3640, 0xc008,	0x367f, 0xc008,		0x21, 0
	.dw 0x36c0, 0xc008,	0x36ff, 0xc008,		0x21, 0
	.dw 0x3740, 0xc008,	0x377f, 0xc008,		0x21, 0
	.dw 0x37c0, 0xc008,	0x37ff, 0xc008,		0x21, 0
	.dw 0x3840, 0xc008,	0x387f, 0xc008,		0x21, 0
	.dw 0x38c0, 0xc008,	0x38ff, 0xc008,		0x21, 0
	.dw 0x3940, 0xc008,	0x397f, 0xc008,		0x21, 0
	.dw 0x39c0, 0xc008,	0x5fff, 0xc008,		0x21, 0
	.dw 0x6040, 0xc008,	0x607f, 0xc008,		0x21, 0
	.dw 0x60c0, 0xc008,	0x60ff, 0xc008,		0x21, 0
	.dw 0x6140, 0xc008,	0x617f, 0xc008,		0x21, 0
	.dw 0x61c0, 0xc008,	0x61ff, 0xc008,		0x21, 0
	.dw 0x6240, 0xc008,	0x627f, 0xc008,		0x21, 0
	.dw 0x62c0, 0xc008,	0x62ff, 0xc008,		0x21, 0
	.dw 0x6340, 0xc008,	0x637f, 0xc008,		0x21, 0
	.dw 0x63c0, 0xc008,	0x63ff, 0xc008,		0x21, 0
	.dw 0x6440, 0xc008,	0x647f, 0xc008,		0x21, 0
	.dw 0x64c0, 0xc008,	0x64ff, 0xc008,		0x21, 0
	.dw 0x6540, 0xc008,	0x657f, 0xc008,		0x21, 0
	.dw 0x65c0, 0xc008,	0x65ff, 0xc008,		0x21, 0
	.dw 0x6640, 0xc008,	0x667f, 0xc008,		0x21, 0
	.dw 0x66c0, 0xc008,	0x66ff, 0xc008,		0x21, 0
	.dw 0x6740, 0xc008,	0x677f, 0xc008,		0x21, 0
	.dw 0x67c0, 0xc008,	0x67ff, 0xc008,		0x21, 0
	.dw 0x6840, 0xc008,	0x687f, 0xc008,		0x21, 0
	.dw 0x68c0, 0xc008,	0x68ff, 0xc008,		0x21, 0
	.dw 0x6940, 0xc008,	0x697f, 0xc008,		0x21, 0
	.dw 0x69c0, 0xc008,	0x69ff, 0xc008,		0x21, 0
	.dw 0x6a40, 0xc008,	0x6a7f, 0xc008,		0x21, 0
	.dw 0x6ac0, 0xc008,	0x6aff, 0xc008,		0x21, 0
	.dw 0x6b40, 0xc008,	0x6b7f, 0xc008,		0x21, 0
	.dw 0x6bc0, 0xc008,	0x6bff, 0xc008,		0x21, 0
	.dw 0x6c40, 0xc008,	0x6c7f, 0xc008,		0x21, 0
	.dw 0x6cc0, 0xc008,	0x6cff, 0xc008,		0x21, 0
	.dw 0x6d40, 0xc008,	0x6d7f, 0xc008,		0x21, 0
	.dw 0x6dc0, 0xc008,	0x6dff, 0xc008,		0x21, 0
	.dw 0x6e40, 0xc008,	0x6e7f, 0xc008,		0x21, 0
	.dw 0x6ec0, 0xc008,	0x6eff, 0xc008,		0x21, 0
	.dw 0x6f40, 0xc008,	0x6f7f, 0xc008,		0x21, 0
	.dw 0x6fc0, 0xc008,	0x6fff, 0xc008,		0x21, 0
	.dw 0x7040, 0xc008,	0x707f, 0xc008,		0x21, 0
	.dw 0x70c0, 0xc008,	0x70ff, 0xc008,		0x21, 0
	.dw 0x7140, 0xc008,	0x717f, 0xc008,		0x21, 0
	.dw 0x71c0, 0xc008,	0x71ff, 0xc008,		0x21, 0
	.dw 0x7240, 0xc008,	0x727f, 0xc008,		0x21, 0
	.dw 0x72c0, 0xc008,	0x72ff, 0xc008,		0x21, 0
	.dw 0x7340, 0xc008,	0x737f, 0xc008,		0x21, 0
	.dw 0x73c0, 0xc008,	0x73ff, 0xc008,		0x21, 0
	.dw 0x7440, 0xc008,	0x747f, 0xc008,		0x21, 0
	.dw 0x74c0, 0xc008,	0x74ff, 0xc008,		0x21, 0
	.dw 0x7540, 0xc008,	0x757f, 0xc008,		0x21, 0
	.dw 0x75c0, 0xc008,	0x75ff, 0xc008,		0x21, 0
	.dw 0x7640, 0xc008,	0x767f, 0xc008,		0x21, 0
	.dw 0x76c0, 0xc008,	0x76ff, 0xc008,		0x21, 0
	.dw 0x7740, 0xc008,	0x777f, 0xc008,		0x21, 0
	.dw 0x77c0, 0xc008,	0x77ff, 0xc008,		0x21, 0
	.dw 0x7840, 0xc008,	0x787f, 0xc008,		0x21, 0
	.dw 0x78c0, 0xc008,	0x78ff, 0xc008,		0x21, 0
	.dw 0x7940, 0xc008,	0x797f, 0xc008,		0x21, 0
	.dw 0x79c0, 0xc008,	0x9fff, 0xc008,		0x21, 0
	.dw 0xa040, 0xc008,	0xa07f, 0xc008,		0x21, 0
	.dw 0xa0c0, 0xc008,	0xa0ff, 0xc008,		0x21, 0
	.dw 0xa140, 0xc008,	0xa17f, 0xc008,		0x21, 0
	.dw 0xa1c0, 0xc008,	0xa1ff, 0xc008,		0x21, 0
	.dw 0xa240, 0xc008,	0xa27f, 0xc008,		0x21, 0
	.dw 0xa2c0, 0xc008,	0xa2ff, 0xc008,		0x21, 0
	.dw 0xa340, 0xc008,	0xa37f, 0xc008,		0x21, 0
	.dw 0xa3c0, 0xc008,	0xa3ff, 0xc008,		0x21, 0
	.dw 0xa440, 0xc008,	0xa47f, 0xc008,		0x21, 0
	.dw 0xa4c0, 0xc008,	0xa4ff, 0xc008,		0x21, 0
	.dw 0xa540, 0xc008,	0xa57f, 0xc008,		0x21, 0
	.dw 0xa5c0, 0xc008,	0xa5ff, 0xc008,		0x21, 0
	.dw 0xa640, 0xc008,	0xa67f, 0xc008,		0x21, 0
	.dw 0xa6c0, 0xc008,	0xa6ff, 0xc008,		0x21, 0
	.dw 0xa740, 0xc008,	0xa77f, 0xc008,		0x21, 0
	.dw 0xa7c0, 0xc008,	0xa7ff, 0xc008,		0x21, 0
	.dw 0xa840, 0xc008,	0xa87f, 0xc008,		0x21, 0
	.dw 0xa8c0, 0xc008,	0xa8ff, 0xc008,		0x21, 0
	.dw 0xa940, 0xc008,	0xa97f, 0xc008,		0x21, 0
	.dw 0xa9c0, 0xc008,	0xa9ff, 0xc008,		0x21, 0
	.dw 0xaa40, 0xc008,	0xaa7f, 0xc008,		0x21, 0
	.dw 0xaac0, 0xc008,	0xaaff, 0xc008,		0x21, 0
	.dw 0xab40, 0xc008,	0xab7f, 0xc008,		0x21, 0
	.dw 0xabc0, 0xc008,	0xabff, 0xc008,		0x21, 0
	.dw 0xac40, 0xc008,	0xac7f, 0xc008,		0x21, 0
	.dw 0xacc0, 0xc008,	0xacff, 0xc008,		0x21, 0
	.dw 0xad40, 0xc008,	0xad7f, 0xc008,		0x21, 0
	.dw 0xadc0, 0xc008,	0xadff, 0xc008,		0x21, 0
	.dw 0xae40, 0xc008,	0xae7f, 0xc008,		0x21, 0
	.dw 0xaec0, 0xc008,	0xaeff, 0xc008,		0x21, 0
	.dw 0xaf40, 0xc008,	0xaf7f, 0xc008,		0x21, 0
	.dw 0xafc0, 0xc008,	0xafff, 0xc008,		0x21, 0
	.dw 0xb040, 0xc008,	0xb07f, 0xc008,		0x21, 0
	.dw 0xb0c0, 0xc008,	0xb0ff, 0xc008,		0x21, 0
	.dw 0xb140, 0xc008,	0xb17f, 0xc008,		0x21, 0
	.dw 0xb1c0, 0xc008,	0xb1ff, 0xc008,		0x21, 0
	.dw 0xb240, 0xc008,	0xb27f, 0xc008,		0x21, 0
	.dw 0xb2c0, 0xc008,	0xb2ff, 0xc008,		0x21, 0
	.dw 0xb340, 0xc008,	0xb37f, 0xc008,		0x21, 0
	.dw 0xb3c0, 0xc008,	0xb3ff, 0xc008,		0x21, 0
	.dw 0xb440, 0xc008,	0xb47f, 0xc008,		0x21, 0
	.dw 0xb4c0, 0xc008,	0xb4ff, 0xc008,		0x21, 0
	.dw 0xb540, 0xc008,	0xb57f, 0xc008,		0x21, 0
	.dw 0xb5c0, 0xc008,	0xb5ff, 0xc008,		0x21, 0
	.dw 0xb640, 0xc008,	0xb67f, 0xc008,		0x21, 0
	.dw 0xb6c0, 0xc008,	0xb6ff, 0xc008,		0x21, 0
	.dw 0xb740, 0xc008,	0xb77f, 0xc008,		0x21, 0
	.dw 0xb7c0, 0xc008,	0xb7ff, 0xc008,		0x21, 0
	.dw 0xb840, 0xc008,	0xb87f, 0xc008,		0x21, 0
	.dw 0xb8c0, 0xc008,	0xb8ff, 0xc008,		0x21, 0
	.dw 0xb940, 0xc008,	0xb97f, 0xc008,		0x21, 0
	.dw 0xb9c0, 0xc008,	0xdfff, 0xc008,		0x21, 0
	.dw 0xe040, 0xc008,	0xe07f, 0xc008,		0x21, 0
	.dw 0xe0c0, 0xc008,	0xe0ff, 0xc008,		0x21, 0
	.dw 0xe140, 0xc008,	0xe17f, 0xc008,		0x21, 0
	.dw 0xe1c0, 0xc008,	0xe1ff, 0xc008,		0x21, 0
	.dw 0xe240, 0xc008,	0xe27f, 0xc008,		0x21, 0
	.dw 0xe2c0, 0xc008,	0xe2ff, 0xc008,		0x21, 0
	.dw 0xe340, 0xc008,	0xe37f, 0xc008,		0x21, 0
	.dw 0xe3c0, 0xc008,	0xe3ff, 0xc008,		0x21, 0
	.dw 0xe440, 0xc008,	0xe47f, 0xc008,		0x21, 0
	.dw 0xe4c0, 0xc008,	0xe4ff, 0xc008,		0x21, 0
	.dw 0xe540, 0xc008,	0xe57f, 0xc008,		0x21, 0
	.dw 0xe5c0, 0xc008,	0xe5ff, 0xc008,		0x21, 0
	.dw 0xe640, 0xc008,	0xe67f, 0xc008,		0x21, 0
	.dw 0xe6c0, 0xc008,	0xe6ff, 0xc008,		0x21, 0
	.dw 0xe740, 0xc008,	0xe77f, 0xc008,		0x21, 0
	.dw 0xe7c0, 0xc008,	0xe7ff, 0xc008,		0x21, 0
	.dw 0xe840, 0xc008,	0xe87f, 0xc008,		0x21, 0
	.dw 0xe8c0, 0xc008,	0xe8ff, 0xc008,		0x21, 0
	.dw 0xe940, 0xc008,	0xe97f, 0xc008,		0x21, 0
	.dw 0xe9c0, 0xc008,	0xe9ff, 0xc008,		0x21, 0
	.dw 0xea40, 0xc008,	0xea7f, 0xc008,		0x21, 0
	.dw 0xeac0, 0xc008,	0xeaff, 0xc008,		0x21, 0
	.dw 0xeb40, 0xc008,	0xeb7f, 0xc008,		0x21, 0
	.dw 0xebc0, 0xc008,	0xebff, 0xc008,		0x21, 0
	.dw 0xec40, 0xc008,	0xec7f, 0xc008,		0x21, 0
	.dw 0xecc0, 0xc008,	0xecff, 0xc008,		0x21, 0
	.dw 0xed40, 0xc008,	0xed7f, 0xc008,		0x21, 0
	.dw 0xedc0, 0xc008,	0xedff, 0xc008,		0x21, 0
	.dw 0xee40, 0xc008,	0xee7f, 0xc008,		0x21, 0
	.dw 0xeec0, 0xc008,	0xeeff, 0xc008,		0x21, 0
	.dw 0xef40, 0xc008,	0xef7f, 0xc008,		0x21, 0
	.dw 0xefc0, 0xc008,	0xefff, 0xc008,		0x21, 0
	.dw 0xf040, 0xc008,	0xf07f, 0xc008,		0x21, 0
	.dw 0xf0c0, 0xc008,	0xf0ff, 0xc008,		0x21, 0
	.dw 0xf140, 0xc008,	0xf17f, 0xc008,		0x21, 0
	.dw 0xf1c0, 0xc008,	0xf1ff, 0xc008,		0x21, 0
	.dw 0xf240, 0xc008,	0xf27f, 0xc008,		0x21, 0
	.dw 0xf2c0, 0xc008,	0xf2ff, 0xc008,		0x21, 0
	.dw 0xf340, 0xc008,	0xf37f, 0xc008,		0x21, 0
	.dw 0xf3c0, 0xc008,	0xf3ff, 0xc008,		0x21, 0
	.dw 0xf440, 0xc008,	0xf47f, 0xc008,		0x21, 0
	.dw 0xf4c0, 0xc008,	0xf4ff, 0xc008,		0x21, 0
	.dw 0xf540, 0xc008,	0xf57f, 0xc008,		0x21, 0
	.dw 0xf5c0, 0xc008,	0xf5ff, 0xc008,		0x21, 0
	.dw 0xf640, 0xc008,	0xf67f, 0xc008,		0x21, 0
	.dw 0xf6c0, 0xc008,	0xf6ff, 0xc008,		0x21, 0
	.dw 0xf740, 0xc008,	0xf77f, 0xc008,		0x21, 0
	.dw 0xf7c0, 0xc008,	0xf7ff, 0xc008,		0x21, 0
	.dw 0xf840, 0xc008,	0xf87f, 0xc008,		0x21, 0
	.dw 0xf8c0, 0xc008,	0xf8ff, 0xc008,		0x21, 0
	.dw 0xf940, 0xc008,	0xf97f, 0xc008,		0x21, 0
	.dw 0xf9c0, 0xc008,	0x1fff, 0xc009,		0x21, 0
	.dw 0x2040, 0xc009,	0x207f, 0xc009,		0x21, 0
	.dw 0x20c0, 0xc009,	0x20ff, 0xc009,		0x21, 0
	.dw 0x2140, 0xc009,	0x217f, 0xc009,		0x21, 0
	.dw 0x21c0, 0xc009,	0x21ff, 0xc009,		0x21, 0
	.dw 0x2240, 0xc009,	0x227f, 0xc009,		0x21, 0
	.dw 0x22c0, 0xc009,	0x22ff, 0xc009,		0x21, 0
	.dw 0x2340, 0xc009,	0x237f, 0xc009,		0x21, 0
	.dw 0x23c0, 0xc009,	0x23ff, 0xc009,		0x21, 0
	.dw 0x2440, 0xc009,	0x247f, 0xc009,		0x21, 0
	.dw 0x24c0, 0xc009,	0x24ff, 0xc009,		0x21, 0
	.dw 0x2540, 0xc009,	0x257f, 0xc009,		0x21, 0
	.dw 0x25c0, 0xc009,	0x25ff, 0xc009,		0x21, 0
	.dw 0x2640, 0xc009,	0x267f, 0xc009,		0x21, 0
	.dw 0x26c0, 0xc009,	0x26ff, 0xc009,		0x21, 0
	.dw 0x2740, 0xc009,	0x277f, 0xc009,		0x21, 0
	.dw 0x27c0, 0xc009,	0x27ff, 0xc009,		0x21, 0
	.dw 0x2840, 0xc009,	0x287f, 0xc009,		0x21, 0
	.dw 0x28c0, 0xc009,	0x28ff, 0xc009,		0x21, 0
	.dw 0x2940, 0xc009,	0x297f, 0xc009,		0x21, 0
	.dw 0x29c0, 0xc009,	0x29ff, 0xc009,		0x21, 0
	.dw 0x2a40, 0xc009,	0x2a7f, 0xc009,		0x21, 0
	.dw 0x2ac0, 0xc009,	0x2aff, 0xc009,		0x21, 0
	.dw 0x2b40, 0xc009,	0x2b7f, 0xc009,		0x21, 0
	.dw 0x2bc0, 0xc009,	0x2bff, 0xc009,		0x21, 0
	.dw 0x2c40, 0xc009,	0x2c7f, 0xc009,		0x21, 0
	.dw 0x2cc0, 0xc009,	0x2cff, 0xc009,		0x21, 0
	.dw 0x2d40, 0xc009,	0x2d7f, 0xc009,		0x21, 0
	.dw 0x2dc0, 0xc009,	0x2dff, 0xc009,		0x21, 0
	.dw 0x2e40, 0xc009,	0x2e7f, 0xc009,		0x21, 0
	.dw 0x2ec0, 0xc009,	0x2eff, 0xc009,		0x21, 0
	.dw 0x2f40, 0xc009,	0x2f7f, 0xc009,		0x21, 0
	.dw 0x2fc0, 0xc009,	0x2fff, 0xc009,		0x21, 0
	.dw 0x3040, 0xc009,	0x307f, 0xc009,		0x21, 0
	.dw 0x30c0, 0xc009,	0x30ff, 0xc009,		0x21, 0
	.dw 0x3140, 0xc009,	0x317f, 0xc009,		0x21, 0
	.dw 0x31c0, 0xc009,	0x31ff, 0xc009,		0x21, 0
	.dw 0x3240, 0xc009,	0x327f, 0xc009,		0x21, 0
	.dw 0x32c0, 0xc009,	0x32ff, 0xc009,		0x21, 0
	.dw 0x3340, 0xc009,	0x337f, 0xc009,		0x21, 0
	.dw 0x33c0, 0xc009,	0x33ff, 0xc009,		0x21, 0
	.dw 0x3440, 0xc009,	0x347f, 0xc009,		0x21, 0
	.dw 0x34c0, 0xc009,	0x34ff, 0xc009,		0x21, 0
	.dw 0x3540, 0xc009,	0x357f, 0xc009,		0x21, 0
	.dw 0x35c0, 0xc009,	0x35ff, 0xc009,		0x21, 0
	.dw 0x3640, 0xc009,	0x367f, 0xc009,		0x21, 0
	.dw 0x36c0, 0xc009,	0x36ff, 0xc009,		0x21, 0
	.dw 0x3740, 0xc009,	0x377f, 0xc009,		0x21, 0
	.dw 0x37c0, 0xc009,	0x37ff, 0xc009,		0x21, 0
	.dw 0x3840, 0xc009,	0x387f, 0xc009,		0x21, 0
	.dw 0x38c0, 0xc009,	0x38ff, 0xc009,		0x21, 0
	.dw 0x3940, 0xc009,	0x397f, 0xc009,		0x21, 0
	.dw 0x39c0, 0xc009,	0x5fff, 0xc009,		0x21, 0
	.dw 0x6040, 0xc009,	0x607f, 0xc009,		0x21, 0
	.dw 0x60c0, 0xc009,	0x60ff, 0xc009,		0x21, 0
	.dw 0x6140, 0xc009,	0x617f, 0xc009,		0x21, 0
	.dw 0x61c0, 0xc009,	0x61ff, 0xc009,		0x21, 0
	.dw 0x6240, 0xc009,	0x627f, 0xc009,		0x21, 0
	.dw 0x62c0, 0xc009,	0x62ff, 0xc009,		0x21, 0
	.dw 0x6340, 0xc009,	0x637f, 0xc009,		0x21, 0
	.dw 0x63c0, 0xc009,	0x63ff, 0xc009,		0x21, 0
	.dw 0x6440, 0xc009,	0x647f, 0xc009,		0x21, 0
	.dw 0x64c0, 0xc009,	0x64ff, 0xc009,		0x21, 0
	.dw 0x6540, 0xc009,	0x657f, 0xc009,		0x21, 0
	.dw 0x65c0, 0xc009,	0x65ff, 0xc009,		0x21, 0
	.dw 0x6640, 0xc009,	0x667f, 0xc009,		0x21, 0
	.dw 0x66c0, 0xc009,	0x66ff, 0xc009,		0x21, 0
	.dw 0x6740, 0xc009,	0x677f, 0xc009,		0x21, 0
	.dw 0x67c0, 0xc009,	0x67ff, 0xc009,		0x21, 0
	.dw 0x6840, 0xc009,	0x687f, 0xc009,		0x21, 0
	.dw 0x68c0, 0xc009,	0x68ff, 0xc009,		0x21, 0
	.dw 0x6940, 0xc009,	0x697f, 0xc009,		0x21, 0
	.dw 0x69c0, 0xc009,	0x69ff, 0xc009,		0x21, 0
	.dw 0x6a40, 0xc009,	0x6a7f, 0xc009,		0x21, 0
	.dw 0x6ac0, 0xc009,	0x6aff, 0xc009,		0x21, 0
	.dw 0x6b40, 0xc009,	0x6b7f, 0xc009,		0x21, 0
	.dw 0x6bc0, 0xc009,	0x6bff, 0xc009,		0x21, 0
	.dw 0x6c40, 0xc009,	0x6c7f, 0xc009,		0x21, 0
	.dw 0x6cc0, 0xc009,	0x6cff, 0xc009,		0x21, 0
	.dw 0x6d40, 0xc009,	0x6d7f, 0xc009,		0x21, 0
	.dw 0x6dc0, 0xc009,	0x6dff, 0xc009,		0x21, 0
	.dw 0x6e40, 0xc009,	0x6e7f, 0xc009,		0x21, 0
	.dw 0x6ec0, 0xc009,	0x6eff, 0xc009,		0x21, 0
	.dw 0x6f40, 0xc009,	0x6f7f, 0xc009,		0x21, 0
	.dw 0x6fc0, 0xc009,	0x6fff, 0xc009,		0x21, 0
	.dw 0x7040, 0xc009,	0x707f, 0xc009,		0x21, 0
	.dw 0x70c0, 0xc009,	0x70ff, 0xc009,		0x21, 0
	.dw 0x7140, 0xc009,	0x717f, 0xc009,		0x21, 0
	.dw 0x71c0, 0xc009,	0x71ff, 0xc009,		0x21, 0
	.dw 0x7240, 0xc009,	0x727f, 0xc009,		0x21, 0
	.dw 0x72c0, 0xc009,	0x72ff, 0xc009,		0x21, 0
	.dw 0x7340, 0xc009,	0x737f, 0xc009,		0x21, 0
	.dw 0x73c0, 0xc009,	0x73ff, 0xc009,		0x21, 0
	.dw 0x7440, 0xc009,	0x747f, 0xc009,		0x21, 0
	.dw 0x74c0, 0xc009,	0x74ff, 0xc009,		0x21, 0
	.dw 0x7540, 0xc009,	0x757f, 0xc009,		0x21, 0
	.dw 0x75c0, 0xc009,	0x75ff, 0xc009,		0x21, 0
	.dw 0x7640, 0xc009,	0x767f, 0xc009,		0x21, 0
	.dw 0x76c0, 0xc009,	0x76ff, 0xc009,		0x21, 0
	.dw 0x7740, 0xc009,	0x777f, 0xc009,		0x21, 0
	.dw 0x77c0, 0xc009,	0x77ff, 0xc009,		0x21, 0
	.dw 0x7840, 0xc009,	0x787f, 0xc009,		0x21, 0
	.dw 0x78c0, 0xc009,	0x78ff, 0xc009,		0x21, 0
	.dw 0x7940, 0xc009,	0x797f, 0xc009,		0x21, 0
	.dw 0x79c0, 0xc009,	0x9fff, 0xc009,		0x21, 0
	.dw 0xa040, 0xc009,	0xa07f, 0xc009,		0x21, 0
	.dw 0xa0c0, 0xc009,	0xa0ff, 0xc009,		0x21, 0
	.dw 0xa140, 0xc009,	0xa17f, 0xc009,		0x21, 0
	.dw 0xa1c0, 0xc009,	0xa1ff, 0xc009,		0x21, 0
	.dw 0xa240, 0xc009,	0xa27f, 0xc009,		0x21, 0
	.dw 0xa2c0, 0xc009,	0xa2ff, 0xc009,		0x21, 0
	.dw 0xa340, 0xc009,	0xa37f, 0xc009,		0x21, 0
	.dw 0xa3c0, 0xc009,	0xa3ff, 0xc009,		0x21, 0
	.dw 0xa440, 0xc009,	0xa47f, 0xc009,		0x21, 0
	.dw 0xa4c0, 0xc009,	0xa4ff, 0xc009,		0x21, 0
	.dw 0xa540, 0xc009,	0xa57f, 0xc009,		0x21, 0
	.dw 0xa5c0, 0xc009,	0xa5ff, 0xc009,		0x21, 0
	.dw 0xa640, 0xc009,	0xa67f, 0xc009,		0x21, 0
	.dw 0xa6c0, 0xc009,	0xa6ff, 0xc009,		0x21, 0
	.dw 0xa740, 0xc009,	0xa77f, 0xc009,		0x21, 0
	.dw 0xa7c0, 0xc009,	0xa7ff, 0xc009,		0x21, 0
	.dw 0xa840, 0xc009,	0xa87f, 0xc009,		0x21, 0
	.dw 0xa8c0, 0xc009,	0xa8ff, 0xc009,		0x21, 0
	.dw 0xa940, 0xc009,	0xa97f, 0xc009,		0x21, 0
	.dw 0xa9c0, 0xc009,	0xa9ff, 0xc009,		0x21, 0
	.dw 0xaa40, 0xc009,	0xaa7f, 0xc009,		0x21, 0
	.dw 0xaac0, 0xc009,	0xaaff, 0xc009,		0x21, 0
	.dw 0xab40, 0xc009,	0xab7f, 0xc009,		0x21, 0
	.dw 0xabc0, 0xc009,	0xabff, 0xc009,		0x21, 0
	.dw 0xac40, 0xc009,	0xac7f, 0xc009,		0x21, 0
	.dw 0xacc0, 0xc009,	0xacff, 0xc009,		0x21, 0
	.dw 0xad40, 0xc009,	0xad7f, 0xc009,		0x21, 0
	.dw 0xadc0, 0xc009,	0xadff, 0xc009,		0x21, 0
	.dw 0xae40, 0xc009,	0xae7f, 0xc009,		0x21, 0
	.dw 0xaec0, 0xc009,	0xaeff, 0xc009,		0x21, 0
	.dw 0xaf40, 0xc009,	0xaf7f, 0xc009,		0x21, 0
	.dw 0xafc0, 0xc009,	0xafff, 0xc009,		0x21, 0
	.dw 0xb040, 0xc009,	0xb07f, 0xc009,		0x21, 0
	.dw 0xb0c0, 0xc009,	0xb0ff, 0xc009,		0x21, 0
	.dw 0xb140, 0xc009,	0xb17f, 0xc009,		0x21, 0
	.dw 0xb1c0, 0xc009,	0xb1ff, 0xc009,		0x21, 0
	.dw 0xb240, 0xc009,	0xb27f, 0xc009,		0x21, 0
	.dw 0xb2c0, 0xc009,	0xb2ff, 0xc009,		0x21, 0
	.dw 0xb340, 0xc009,	0xb37f, 0xc009,		0x21, 0
	.dw 0xb3c0, 0xc009,	0xb3ff, 0xc009,		0x21, 0
	.dw 0xb440, 0xc009,	0xb47f, 0xc009,		0x21, 0
	.dw 0xb4c0, 0xc009,	0xb4ff, 0xc009,		0x21, 0
	.dw 0xb540, 0xc009,	0xb57f, 0xc009,		0x21, 0
	.dw 0xb5c0, 0xc009,	0xb5ff, 0xc009,		0x21, 0
	.dw 0xb640, 0xc009,	0xb67f, 0xc009,		0x21, 0
	.dw 0xb6c0, 0xc009,	0xb6ff, 0xc009,		0x21, 0
	.dw 0xb740, 0xc009,	0xb77f, 0xc009,		0x21, 0
	.dw 0xb7c0, 0xc009,	0xb7ff, 0xc009,		0x21, 0
	.dw 0xb840, 0xc009,	0xb87f, 0xc009,		0x21, 0
	.dw 0xb8c0, 0xc009,	0xb8ff, 0xc009,		0x21, 0
	.dw 0xb940, 0xc009,	0xb97f, 0xc009,		0x21, 0
	.dw 0xb9c0, 0xc009,	0xdfff, 0xc009,		0x21, 0
	.dw 0xe040, 0xc009,	0xe07f, 0xc009,		0x21, 0
	.dw 0xe0c0, 0xc009,	0xe0ff, 0xc009,		0x21, 0
	.dw 0xe140, 0xc009,	0xe17f, 0xc009,		0x21, 0
	.dw 0xe1c0, 0xc009,	0xe1ff, 0xc009,		0x21, 0
	.dw 0xe240, 0xc009,	0xe27f, 0xc009,		0x21, 0
	.dw 0xe2c0, 0xc009,	0xe2ff, 0xc009,		0x21, 0
	.dw 0xe340, 0xc009,	0xe37f, 0xc009,		0x21, 0
	.dw 0xe3c0, 0xc009,	0xe3ff, 0xc009,		0x21, 0
	.dw 0xe440, 0xc009,	0xe47f, 0xc009,		0x21, 0
	.dw 0xe4c0, 0xc009,	0xe4ff, 0xc009,		0x21, 0
	.dw 0xe540, 0xc009,	0xe57f, 0xc009,		0x21, 0
	.dw 0xe5c0, 0xc009,	0xe5ff, 0xc009,		0x21, 0
	.dw 0xe640, 0xc009,	0xe67f, 0xc009,		0x21, 0
	.dw 0xe6c0, 0xc009,	0xe6ff, 0xc009,		0x21, 0
	.dw 0xe740, 0xc009,	0xe77f, 0xc009,		0x21, 0
	.dw 0xe7c0, 0xc009,	0xe7ff, 0xc009,		0x21, 0
	.dw 0xe840, 0xc009,	0xe87f, 0xc009,		0x21, 0
	.dw 0xe8c0, 0xc009,	0xe8ff, 0xc009,		0x21, 0
	.dw 0xe940, 0xc009,	0xe97f, 0xc009,		0x21, 0
	.dw 0xe9c0, 0xc009,	0xe9ff, 0xc009,		0x21, 0
	.dw 0xea40, 0xc009,	0xea7f, 0xc009,		0x21, 0
	.dw 0xeac0, 0xc009,	0xeaff, 0xc009,		0x21, 0
	.dw 0xeb40, 0xc009,	0xeb7f, 0xc009,		0x21, 0
	.dw 0xebc0, 0xc009,	0xebff, 0xc009,		0x21, 0
	.dw 0xec40, 0xc009,	0xec7f, 0xc009,		0x21, 0
	.dw 0xecc0, 0xc009,	0xecff, 0xc009,		0x21, 0
	.dw 0xed40, 0xc009,	0xed7f, 0xc009,		0x21, 0
	.dw 0xedc0, 0xc009,	0xedff, 0xc009,		0x21, 0
	.dw 0xee40, 0xc009,	0xee7f, 0xc009,		0x21, 0
	.dw 0xeec0, 0xc009,	0xeeff, 0xc009,		0x21, 0
	.dw 0xef40, 0xc009,	0xef7f, 0xc009,		0x21, 0
	.dw 0xefc0, 0xc009,	0xefff, 0xc009,		0x21, 0
	.dw 0xf040, 0xc009,	0xf07f, 0xc009,		0x21, 0
	.dw 0xf0c0, 0xc009,	0xf0ff, 0xc009,		0x21, 0
	.dw 0xf140, 0xc009,	0xf17f, 0xc009,		0x21, 0
	.dw 0xf1c0, 0xc009,	0xf1ff, 0xc009,		0x21, 0
	.dw 0xf240, 0xc009,	0xf27f, 0xc009,		0x21, 0
	.dw 0xf2c0, 0xc009,	0xf2ff, 0xc009,		0x21, 0
	.dw 0xf340, 0xc009,	0xf37f, 0xc009,		0x21, 0
	.dw 0xf3c0, 0xc009,	0xf3ff, 0xc009,		0x21, 0
	.dw 0xf440, 0xc009,	0xf47f, 0xc009,		0x21, 0
	.dw 0xf4c0, 0xc009,	0xf4ff, 0xc009,		0x21, 0
	.dw 0xf540, 0xc009,	0xf57f, 0xc009,		0x21, 0
	.dw 0xf5c0, 0xc009,	0xf5ff, 0xc009,		0x21, 0
	.dw 0xf640, 0xc009,	0xf67f, 0xc009,		0x21, 0
	.dw 0xf6c0, 0xc009,	0xf6ff, 0xc009,		0x21, 0
	.dw 0xf740, 0xc009,	0xf77f, 0xc009,		0x21, 0
	.dw 0xf7c0, 0xc009,	0xf7ff, 0xc009,		0x21, 0
	.dw 0xf840, 0xc009,	0xf87f, 0xc009,		0x21, 0
	.dw 0xf8c0, 0xc009,	0xf8ff, 0xc009,		0x21, 0
	.dw 0xf940, 0xc009,	0xf97f, 0xc009,		0x21, 0
	.dw 0xf9c0, 0xc009,	0x1fff, 0xc00a,		0x21, 0
	.dw 0x2040, 0xc00a,	0x207f, 0xc00a,		0x21, 0
	.dw 0x20c0, 0xc00a,	0x20ff, 0xc00a,		0x21, 0
	.dw 0x2140, 0xc00a,	0x217f, 0xc00a,		0x21, 0
	.dw 0x21c0, 0xc00a,	0x21ff, 0xc00a,		0x21, 0
	.dw 0x2240, 0xc00a,	0x227f, 0xc00a,		0x21, 0
	.dw 0x22c0, 0xc00a,	0x22ff, 0xc00a,		0x21, 0
	.dw 0x2340, 0xc00a,	0x237f, 0xc00a,		0x21, 0
	.dw 0x23c0, 0xc00a,	0x23ff, 0xc00a,		0x21, 0
	.dw 0x2440, 0xc00a,	0x247f, 0xc00a,		0x21, 0
	.dw 0x24c0, 0xc00a,	0x24ff, 0xc00a,		0x21, 0
	.dw 0x2540, 0xc00a,	0x257f, 0xc00a,		0x21, 0
	.dw 0x25c0, 0xc00a,	0x25ff, 0xc00a,		0x21, 0
	.dw 0x2640, 0xc00a,	0x267f, 0xc00a,		0x21, 0
	.dw 0x26c0, 0xc00a,	0x26ff, 0xc00a,		0x21, 0
	.dw 0x2740, 0xc00a,	0x277f, 0xc00a,		0x21, 0
	.dw 0x27c0, 0xc00a,	0x27ff, 0xc00a,		0x21, 0
	.dw 0x2840, 0xc00a,	0x287f, 0xc00a,		0x21, 0
	.dw 0x28c0, 0xc00a,	0x28ff, 0xc00a,		0x21, 0
	.dw 0x2940, 0xc00a,	0x297f, 0xc00a,		0x21, 0
	.dw 0x29c0, 0xc00a,	0x29ff, 0xc00a,		0x21, 0
	.dw 0x2a40, 0xc00a,	0x2a7f, 0xc00a,		0x21, 0
	.dw 0x2ac0, 0xc00a,	0x2aff, 0xc00a,		0x21, 0
	.dw 0x2b40, 0xc00a,	0x2b7f, 0xc00a,		0x21, 0
	.dw 0x2bc0, 0xc00a,	0x2bff, 0xc00a,		0x21, 0
	.dw 0x2c40, 0xc00a,	0x2c7f, 0xc00a,		0x21, 0
	.dw 0x2cc0, 0xc00a,	0x2cff, 0xc00a,		0x21, 0
	.dw 0x2d40, 0xc00a,	0x2d7f, 0xc00a,		0x21, 0
	.dw 0x2dc0, 0xc00a,	0x2dff, 0xc00a,		0x21, 0
	.dw 0x2e40, 0xc00a,	0x2e7f, 0xc00a,		0x21, 0
	.dw 0x2ec0, 0xc00a,	0x2eff, 0xc00a,		0x21, 0
	.dw 0x2f40, 0xc00a,	0x2f7f, 0xc00a,		0x21, 0
	.dw 0x2fc0, 0xc00a,	0x2fff, 0xc00a,		0x21, 0
	.dw 0x3040, 0xc00a,	0x307f, 0xc00a,		0x21, 0
	.dw 0x30c0, 0xc00a,	0x30ff, 0xc00a,		0x21, 0
	.dw 0x3140, 0xc00a,	0x317f, 0xc00a,		0x21, 0
	.dw 0x31c0, 0xc00a,	0x31ff, 0xc00a,		0x21, 0
	.dw 0x3240, 0xc00a,	0x327f, 0xc00a,		0x21, 0
	.dw 0x32c0, 0xc00a,	0x32ff, 0xc00a,		0x21, 0
	.dw 0x3340, 0xc00a,	0x337f, 0xc00a,		0x21, 0
	.dw 0x33c0, 0xc00a,	0x33ff, 0xc00a,		0x21, 0
	.dw 0x3440, 0xc00a,	0x347f, 0xc00a,		0x21, 0
	.dw 0x34c0, 0xc00a,	0x34ff, 0xc00a,		0x21, 0
	.dw 0x3540, 0xc00a,	0x357f, 0xc00a,		0x21, 0
	.dw 0x35c0, 0xc00a,	0x35ff, 0xc00a,		0x21, 0
	.dw 0x3640, 0xc00a,	0x367f, 0xc00a,		0x21, 0
	.dw 0x36c0, 0xc00a,	0x36ff, 0xc00a,		0x21, 0
	.dw 0x3740, 0xc00a,	0x377f, 0xc00a,		0x21, 0
	.dw 0x37c0, 0xc00a,	0x37ff, 0xc00a,		0x21, 0
	.dw 0x3840, 0xc00a,	0x387f, 0xc00a,		0x21, 0
	.dw 0x38c0, 0xc00a,	0x38ff, 0xc00a,		0x21, 0
	.dw 0x3940, 0xc00a,	0x397f, 0xc00a,		0x21, 0
	.dw 0x39c0, 0xc00a,	0x5fff, 0xc00a,		0x21, 0
	.dw 0x6040, 0xc00a,	0x607f, 0xc00a,		0x21, 0
	.dw 0x60c0, 0xc00a,	0x60ff, 0xc00a,		0x21, 0
	.dw 0x6140, 0xc00a,	0x617f, 0xc00a,		0x21, 0
	.dw 0x61c0, 0xc00a,	0x61ff, 0xc00a,		0x21, 0
	.dw 0x6240, 0xc00a,	0x627f, 0xc00a,		0x21, 0
	.dw 0x62c0, 0xc00a,	0x62ff, 0xc00a,		0x21, 0
	.dw 0x6340, 0xc00a,	0x637f, 0xc00a,		0x21, 0
	.dw 0x63c0, 0xc00a,	0x63ff, 0xc00a,		0x21, 0
	.dw 0x6440, 0xc00a,	0x647f, 0xc00a,		0x21, 0
	.dw 0x64c0, 0xc00a,	0x64ff, 0xc00a,		0x21, 0
	.dw 0x6540, 0xc00a,	0x657f, 0xc00a,		0x21, 0
	.dw 0x65c0, 0xc00a,	0x65ff, 0xc00a,		0x21, 0
	.dw 0x6640, 0xc00a,	0x667f, 0xc00a,		0x21, 0
	.dw 0x66c0, 0xc00a,	0x66ff, 0xc00a,		0x21, 0
	.dw 0x6740, 0xc00a,	0x677f, 0xc00a,		0x21, 0
	.dw 0x67c0, 0xc00a,	0x67ff, 0xc00a,		0x21, 0
	.dw 0x6840, 0xc00a,	0x687f, 0xc00a,		0x21, 0
	.dw 0x68c0, 0xc00a,	0x68ff, 0xc00a,		0x21, 0
	.dw 0x6940, 0xc00a,	0x697f, 0xc00a,		0x21, 0
	.dw 0x69c0, 0xc00a,	0x69ff, 0xc00a,		0x21, 0
	.dw 0x6a40, 0xc00a,	0x6a7f, 0xc00a,		0x21, 0
	.dw 0x6ac0, 0xc00a,	0x6aff, 0xc00a,		0x21, 0
	.dw 0x6b40, 0xc00a,	0x6b7f, 0xc00a,		0x21, 0
	.dw 0x6bc0, 0xc00a,	0x6bff, 0xc00a,		0x21, 0
	.dw 0x6c40, 0xc00a,	0x6c7f, 0xc00a,		0x21, 0
	.dw 0x6cc0, 0xc00a,	0x6cff, 0xc00a,		0x21, 0
	.dw 0x6d40, 0xc00a,	0x6d7f, 0xc00a,		0x21, 0
	.dw 0x6dc0, 0xc00a,	0x6dff, 0xc00a,		0x21, 0
	.dw 0x6e40, 0xc00a,	0x6e7f, 0xc00a,		0x21, 0
	.dw 0x6ec0, 0xc00a,	0x6eff, 0xc00a,		0x21, 0
	.dw 0x6f40, 0xc00a,	0x6f7f, 0xc00a,		0x21, 0
	.dw 0x6fc0, 0xc00a,	0x6fff, 0xc00a,		0x21, 0
	.dw 0x7040, 0xc00a,	0x707f, 0xc00a,		0x21, 0
	.dw 0x70c0, 0xc00a,	0x70ff, 0xc00a,		0x21, 0
	.dw 0x7140, 0xc00a,	0x717f, 0xc00a,		0x21, 0
	.dw 0x71c0, 0xc00a,	0x71ff, 0xc00a,		0x21, 0
	.dw 0x7240, 0xc00a,	0x727f, 0xc00a,		0x21, 0
	.dw 0x72c0, 0xc00a,	0x72ff, 0xc00a,		0x21, 0
	.dw 0x7340, 0xc00a,	0x737f, 0xc00a,		0x21, 0
	.dw 0x73c0, 0xc00a,	0x73ff, 0xc00a,		0x21, 0
	.dw 0x7440, 0xc00a,	0x747f, 0xc00a,		0x21, 0
	.dw 0x74c0, 0xc00a,	0x74ff, 0xc00a,		0x21, 0
	.dw 0x7540, 0xc00a,	0x757f, 0xc00a,		0x21, 0
	.dw 0x75c0, 0xc00a,	0x75ff, 0xc00a,		0x21, 0
	.dw 0x7640, 0xc00a,	0x767f, 0xc00a,		0x21, 0
	.dw 0x76c0, 0xc00a,	0x76ff, 0xc00a,		0x21, 0
	.dw 0x7740, 0xc00a,	0x777f, 0xc00a,		0x21, 0
	.dw 0x77c0, 0xc00a,	0x77ff, 0xc00a,		0x21, 0
	.dw 0x7840, 0xc00a,	0x787f, 0xc00a,		0x21, 0
	.dw 0x78c0, 0xc00a,	0x78ff, 0xc00a,		0x21, 0
	.dw 0x7940, 0xc00a,	0x797f, 0xc00a,		0x21, 0
	.dw 0x79c0, 0xc00a,	0x9fff, 0xc00a,		0x21, 0
	.dw 0xa040, 0xc00a,	0xa07f, 0xc00a,		0x21, 0
	.dw 0xa0c0, 0xc00a,	0xa0ff, 0xc00a,		0x21, 0
	.dw 0xa140, 0xc00a,	0xa17f, 0xc00a,		0x21, 0
	.dw 0xa1c0, 0xc00a,	0xa1ff, 0xc00a,		0x21, 0
	.dw 0xa240, 0xc00a,	0xa27f, 0xc00a,		0x21, 0
	.dw 0xa2c0, 0xc00a,	0xa2ff, 0xc00a,		0x21, 0
	.dw 0xa340, 0xc00a,	0xa37f, 0xc00a,		0x21, 0
	.dw 0xa3c0, 0xc00a,	0xa3ff, 0xc00a,		0x21, 0
	.dw 0xa440, 0xc00a,	0xa47f, 0xc00a,		0x21, 0
	.dw 0xa4c0, 0xc00a,	0xa4ff, 0xc00a,		0x21, 0
	.dw 0xa540, 0xc00a,	0xa57f, 0xc00a,		0x21, 0
	.dw 0xa5c0, 0xc00a,	0xa5ff, 0xc00a,		0x21, 0
	.dw 0xa640, 0xc00a,	0xa67f, 0xc00a,		0x21, 0
	.dw 0xa6c0, 0xc00a,	0xa6ff, 0xc00a,		0x21, 0
	.dw 0xa740, 0xc00a,	0xa77f, 0xc00a,		0x21, 0
	.dw 0xa7c0, 0xc00a,	0xa7ff, 0xc00a,		0x21, 0
	.dw 0xa840, 0xc00a,	0xa87f, 0xc00a,		0x21, 0
	.dw 0xa8c0, 0xc00a,	0xa8ff, 0xc00a,		0x21, 0
	.dw 0xa940, 0xc00a,	0xa97f, 0xc00a,		0x21, 0
	.dw 0xa9c0, 0xc00a,	0xa9ff, 0xc00a,		0x21, 0
	.dw 0xaa40, 0xc00a,	0xaa7f, 0xc00a,		0x21, 0
	.dw 0xaac0, 0xc00a,	0xaaff, 0xc00a,		0x21, 0
	.dw 0xab40, 0xc00a,	0xab7f, 0xc00a,		0x21, 0
	.dw 0xabc0, 0xc00a,	0xabff, 0xc00a,		0x21, 0
	.dw 0xac40, 0xc00a,	0xac7f, 0xc00a,		0x21, 0
	.dw 0xacc0, 0xc00a,	0xacff, 0xc00a,		0x21, 0
	.dw 0xad40, 0xc00a,	0xad7f, 0xc00a,		0x21, 0
	.dw 0xadc0, 0xc00a,	0xadff, 0xc00a,		0x21, 0
	.dw 0xae40, 0xc00a,	0xae7f, 0xc00a,		0x21, 0
	.dw 0xaec0, 0xc00a,	0xaeff, 0xc00a,		0x21, 0
	.dw 0xaf40, 0xc00a,	0xaf7f, 0xc00a,		0x21, 0
	.dw 0xafc0, 0xc00a,	0xafff, 0xc00a,		0x21, 0
	.dw 0xb040, 0xc00a,	0xb07f, 0xc00a,		0x21, 0
	.dw 0xb0c0, 0xc00a,	0xb0ff, 0xc00a,		0x21, 0
	.dw 0xb140, 0xc00a,	0xb17f, 0xc00a,		0x21, 0
	.dw 0xb1c0, 0xc00a,	0xb1ff, 0xc00a,		0x21, 0
	.dw 0xb240, 0xc00a,	0xb27f, 0xc00a,		0x21, 0
	.dw 0xb2c0, 0xc00a,	0xb2ff, 0xc00a,		0x21, 0
	.dw 0xb340, 0xc00a,	0xb37f, 0xc00a,		0x21, 0
	.dw 0xb3c0, 0xc00a,	0xb3ff, 0xc00a,		0x21, 0
	.dw 0xb440, 0xc00a,	0xb47f, 0xc00a,		0x21, 0
	.dw 0xb4c0, 0xc00a,	0xb4ff, 0xc00a,		0x21, 0
	.dw 0xb540, 0xc00a,	0xb57f, 0xc00a,		0x21, 0
	.dw 0xb5c0, 0xc00a,	0xb5ff, 0xc00a,		0x21, 0
	.dw 0xb640, 0xc00a,	0xb67f, 0xc00a,		0x21, 0
	.dw 0xb6c0, 0xc00a,	0xb6ff, 0xc00a,		0x21, 0
	.dw 0xb740, 0xc00a,	0xb77f, 0xc00a,		0x21, 0
	.dw 0xb7c0, 0xc00a,	0xb7ff, 0xc00a,		0x21, 0
	.dw 0xb840, 0xc00a,	0xb87f, 0xc00a,		0x21, 0
	.dw 0xb8c0, 0xc00a,	0xb8ff, 0xc00a,		0x21, 0
	.dw 0xb940, 0xc00a,	0xb97f, 0xc00a,		0x21, 0
	.dw 0xb9c0, 0xc00a,	0xdfff, 0xc00a,		0x21, 0
	.dw 0xe040, 0xc00a,	0xe07f, 0xc00a,		0x21, 0
	.dw 0xe0c0, 0xc00a,	0xe0ff, 0xc00a,		0x21, 0
	.dw 0xe140, 0xc00a,	0xe17f, 0xc00a,		0x21, 0
	.dw 0xe1c0, 0xc00a,	0xe1ff, 0xc00a,		0x21, 0
	.dw 0xe240, 0xc00a,	0xe27f, 0xc00a,		0x21, 0
	.dw 0xe2c0, 0xc00a,	0xe2ff, 0xc00a,		0x21, 0
	.dw 0xe340, 0xc00a,	0xe37f, 0xc00a,		0x21, 0
	.dw 0xe3c0, 0xc00a,	0xe3ff, 0xc00a,		0x21, 0
	.dw 0xe440, 0xc00a,	0xe47f, 0xc00a,		0x21, 0
	.dw 0xe4c0, 0xc00a,	0xe4ff, 0xc00a,		0x21, 0
	.dw 0xe540, 0xc00a,	0xe57f, 0xc00a,		0x21, 0
	.dw 0xe5c0, 0xc00a,	0xe5ff, 0xc00a,		0x21, 0
	.dw 0xe640, 0xc00a,	0xe67f, 0xc00a,		0x21, 0
	.dw 0xe6c0, 0xc00a,	0xe6ff, 0xc00a,		0x21, 0
	.dw 0xe740, 0xc00a,	0xe77f, 0xc00a,		0x21, 0
	.dw 0xe7c0, 0xc00a,	0xe7ff, 0xc00a,		0x21, 0
	.dw 0xe840, 0xc00a,	0xe87f, 0xc00a,		0x21, 0
	.dw 0xe8c0, 0xc00a,	0xe8ff, 0xc00a,		0x21, 0
	.dw 0xe940, 0xc00a,	0xe97f, 0xc00a,		0x21, 0
	.dw 0xe9c0, 0xc00a,	0xe9ff, 0xc00a,		0x21, 0
	.dw 0xea40, 0xc00a,	0xea7f, 0xc00a,		0x21, 0
	.dw 0xeac0, 0xc00a,	0xeaff, 0xc00a,		0x21, 0
	.dw 0xeb40, 0xc00a,	0xeb7f, 0xc00a,		0x21, 0
	.dw 0xebc0, 0xc00a,	0xebff, 0xc00a,		0x21, 0
	.dw 0xec40, 0xc00a,	0xec7f, 0xc00a,		0x21, 0
	.dw 0xecc0, 0xc00a,	0xecff, 0xc00a,		0x21, 0
	.dw 0xed40, 0xc00a,	0xed7f, 0xc00a,		0x21, 0
	.dw 0xedc0, 0xc00a,	0xedff, 0xc00a,		0x21, 0
	.dw 0xee40, 0xc00a,	0xee7f, 0xc00a,		0x21, 0
	.dw 0xeec0, 0xc00a,	0xeeff, 0xc00a,		0x21, 0
	.dw 0xef40, 0xc00a,	0xef7f, 0xc00a,		0x21, 0
	.dw 0xefc0, 0xc00a,	0xefff, 0xc00a,		0x21, 0
	.dw 0xf040, 0xc00a,	0xf07f, 0xc00a,		0x21, 0
	.dw 0xf0c0, 0xc00a,	0xf0ff, 0xc00a,		0x21, 0
	.dw 0xf140, 0xc00a,	0xf17f, 0xc00a,		0x21, 0
	.dw 0xf1c0, 0xc00a,	0xf1ff, 0xc00a,		0x21, 0
	.dw 0xf240, 0xc00a,	0xf27f, 0xc00a,		0x21, 0
	.dw 0xf2c0, 0xc00a,	0xf2ff, 0xc00a,		0x21, 0
	.dw 0xf340, 0xc00a,	0xf37f, 0xc00a,		0x21, 0
	.dw 0xf3c0, 0xc00a,	0xf3ff, 0xc00a,		0x21, 0
	.dw 0xf440, 0xc00a,	0xf47f, 0xc00a,		0x21, 0
	.dw 0xf4c0, 0xc00a,	0xf4ff, 0xc00a,		0x21, 0
	.dw 0xf540, 0xc00a,	0xf57f, 0xc00a,		0x21, 0
	.dw 0xf5c0, 0xc00a,	0xf5ff, 0xc00a,		0x21, 0
	.dw 0xf640, 0xc00a,	0xf67f, 0xc00a,		0x21, 0
	.dw 0xf6c0, 0xc00a,	0xf6ff, 0xc00a,		0x21, 0
	.dw 0xf740, 0xc00a,	0xf77f, 0xc00a,		0x21, 0
	.dw 0xf7c0, 0xc00a,	0xf7ff, 0xc00a,		0x21, 0
	.dw 0xf840, 0xc00a,	0xf87f, 0xc00a,		0x21, 0
	.dw 0xf8c0, 0xc00a,	0xf8ff, 0xc00a,		0x21, 0
	.dw 0xf940, 0xc00a,	0xf97f, 0xc00a,		0x21, 0
	.dw 0xf9c0, 0xc00a,	0x1fff, 0xc00b,		0x21, 0
	.dw 0x2040, 0xc00b,	0x207f, 0xc00b,		0x21, 0
	.dw 0x20c0, 0xc00b,	0x20ff, 0xc00b,		0x21, 0
	.dw 0x2140, 0xc00b,	0x217f, 0xc00b,		0x21, 0
	.dw 0x21c0, 0xc00b,	0x21ff, 0xc00b,		0x21, 0
	.dw 0x2240, 0xc00b,	0x227f, 0xc00b,		0x21, 0
	.dw 0x22c0, 0xc00b,	0x22ff, 0xc00b,		0x21, 0
	.dw 0x2340, 0xc00b,	0x237f, 0xc00b,		0x21, 0
	.dw 0x23c0, 0xc00b,	0x23ff, 0xc00b,		0x21, 0
	.dw 0x2440, 0xc00b,	0x247f, 0xc00b,		0x21, 0
	.dw 0x24c0, 0xc00b,	0x24ff, 0xc00b,		0x21, 0
	.dw 0x2540, 0xc00b,	0x257f, 0xc00b,		0x21, 0
	.dw 0x25c0, 0xc00b,	0x25ff, 0xc00b,		0x21, 0
	.dw 0x2640, 0xc00b,	0x267f, 0xc00b,		0x21, 0
	.dw 0x26c0, 0xc00b,	0x26ff, 0xc00b,		0x21, 0
	.dw 0x2740, 0xc00b,	0x277f, 0xc00b,		0x21, 0
	.dw 0x27c0, 0xc00b,	0x27ff, 0xc00b,		0x21, 0
	.dw 0x2840, 0xc00b,	0x287f, 0xc00b,		0x21, 0
	.dw 0x28c0, 0xc00b,	0x28ff, 0xc00b,		0x21, 0
	.dw 0x2940, 0xc00b,	0x297f, 0xc00b,		0x21, 0
	.dw 0x29c0, 0xc00b,	0x29ff, 0xc00b,		0x21, 0
	.dw 0x2a40, 0xc00b,	0x2a7f, 0xc00b,		0x21, 0
	.dw 0x2ac0, 0xc00b,	0x2aff, 0xc00b,		0x21, 0
	.dw 0x2b40, 0xc00b,	0x2b7f, 0xc00b,		0x21, 0
	.dw 0x2bc0, 0xc00b,	0x2bff, 0xc00b,		0x21, 0
	.dw 0x2c40, 0xc00b,	0x2c7f, 0xc00b,		0x21, 0
	.dw 0x2cc0, 0xc00b,	0x2cff, 0xc00b,		0x21, 0
	.dw 0x2d40, 0xc00b,	0x2d7f, 0xc00b,		0x21, 0
	.dw 0x2dc0, 0xc00b,	0x2dff, 0xc00b,		0x21, 0
	.dw 0x2e40, 0xc00b,	0x2e7f, 0xc00b,		0x21, 0
	.dw 0x2ec0, 0xc00b,	0x2eff, 0xc00b,		0x21, 0
	.dw 0x2f40, 0xc00b,	0x2f7f, 0xc00b,		0x21, 0
	.dw 0x2fc0, 0xc00b,	0x2fff, 0xc00b,		0x21, 0
	.dw 0x3040, 0xc00b,	0x307f, 0xc00b,		0x21, 0
	.dw 0x30c0, 0xc00b,	0x30ff, 0xc00b,		0x21, 0
	.dw 0x3140, 0xc00b,	0x317f, 0xc00b,		0x21, 0
	.dw 0x31c0, 0xc00b,	0x31ff, 0xc00b,		0x21, 0
	.dw 0x3240, 0xc00b,	0x327f, 0xc00b,		0x21, 0
	.dw 0x32c0, 0xc00b,	0x32ff, 0xc00b,		0x21, 0
	.dw 0x3340, 0xc00b,	0x337f, 0xc00b,		0x21, 0
	.dw 0x33c0, 0xc00b,	0x33ff, 0xc00b,		0x21, 0
	.dw 0x3440, 0xc00b,	0x347f, 0xc00b,		0x21, 0
	.dw 0x34c0, 0xc00b,	0x34ff, 0xc00b,		0x21, 0
	.dw 0x3540, 0xc00b,	0x357f, 0xc00b,		0x21, 0
	.dw 0x35c0, 0xc00b,	0x35ff, 0xc00b,		0x21, 0
	.dw 0x3640, 0xc00b,	0x367f, 0xc00b,		0x21, 0
	.dw 0x36c0, 0xc00b,	0x36ff, 0xc00b,		0x21, 0
	.dw 0x3740, 0xc00b,	0x377f, 0xc00b,		0x21, 0
	.dw 0x37c0, 0xc00b,	0x37ff, 0xc00b,		0x21, 0
	.dw 0x3840, 0xc00b,	0x387f, 0xc00b,		0x21, 0
	.dw 0x38c0, 0xc00b,	0x38ff, 0xc00b,		0x21, 0
	.dw 0x3940, 0xc00b,	0x397f, 0xc00b,		0x21, 0
	.dw 0x39c0, 0xc00b,	0xffff, 0xc00b,		0x21, 0
	.dw 0x0040, 0xc00c,	0x007f, 0xc00c,		0x21, 0
	.dw 0x00c0, 0xc00c,	0x00ff, 0xc00c,		0x21, 0
	.dw 0x0140, 0xc00c,	0x017f, 0xc00c,		0x21, 0
	.dw 0x01c0, 0xc00c,	0x01ff, 0xc00c,		0x21, 0
	.dw 0x0240, 0xc00c,	0x027f, 0xc00c,		0x21, 0
	.dw 0x02c0, 0xc00c,	0x02ff, 0xc00c,		0x21, 0
	.dw 0x0340, 0xc00c,	0x037f, 0xc00c,		0x21, 0
	.dw 0x03c0, 0xc00c,	0x03ff, 0xc00c,		0x21, 0
	.dw 0x0440, 0xc00c,	0x047f, 0xc00c,		0x21, 0
	.dw 0x04c0, 0xc00c,	0x04ff, 0xc00c,		0x21, 0
	.dw 0x0540, 0xc00c,	0x057f, 0xc00c,		0x21, 0
	.dw 0x05c0, 0xc00c,	0x05ff, 0xc00c,		0x21, 0
	.dw 0x0640, 0xc00c,	0x067f, 0xc00c,		0x21, 0
	.dw 0x06c0, 0xc00c,	0x06ff, 0xc00c,		0x21, 0
	.dw 0x0740, 0xc00c,	0x077f, 0xc00c,		0x21, 0
	.dw 0x07c0, 0xc00c,	0x07ff, 0xc00c,		0x21, 0
	.dw 0x0840, 0xc00c,	0x087f, 0xc00c,		0x21, 0
	.dw 0x08c0, 0xc00c,	0x08ff, 0xc00c,		0x21, 0
	.dw 0x0940, 0xc00c,	0x097f, 0xc00c,		0x21, 0
	.dw 0x09c0, 0xc00c,	0x09ff, 0xc00c,		0x21, 0
	.dw 0x0a40, 0xc00c,	0x0a7f, 0xc00c,		0x21, 0
	.dw 0x0ac0, 0xc00c,	0x0aff, 0xc00c,		0x21, 0
	.dw 0x0b40, 0xc00c,	0x0b7f, 0xc00c,		0x21, 0
	.dw 0x0bc0, 0xc00c,	0x0bff, 0xc00c,		0x21, 0
	.dw 0x0c40, 0xc00c,	0x0c7f, 0xc00c,		0x21, 0
	.dw 0x0cc0, 0xc00c,	0x0cff, 0xc00c,		0x21, 0
	.dw 0x0d40, 0xc00c,	0x0d7f, 0xc00c,		0x21, 0
	.dw 0x0dc0, 0xc00c,	0x0dff, 0xc00c,		0x21, 0
	.dw 0x0e40, 0xc00c,	0x0e7f, 0xc00c,		0x21, 0
	.dw 0x0ec0, 0xc00c,	0x0eff, 0xc00c,		0x21, 0
	.dw 0x0f40, 0xc00c,	0x0f7f, 0xc00c,		0x21, 0
	.dw 0x0fc0, 0xc00c,	0x0fff, 0xc00c,		0x21, 0
	.dw 0x1040, 0xc00c,	0x107f, 0xc00c,		0x21, 0
	.dw 0x10c0, 0xc00c,	0x10ff, 0xc00c,		0x21, 0
	.dw 0x1140, 0xc00c,	0x117f, 0xc00c,		0x21, 0
	.dw 0x11c0, 0xc00c,	0x11ff, 0xc00c,		0x21, 0
	.dw 0x1240, 0xc00c,	0x127f, 0xc00c,		0x21, 0
	.dw 0x12c0, 0xc00c,	0x12ff, 0xc00c,		0x21, 0
	.dw 0x1340, 0xc00c,	0x137f, 0xc00c,		0x21, 0
	.dw 0x13c0, 0xc00c,	0x13ff, 0xc00c,		0x21, 0
	.dw 0x1440, 0xc00c,	0x147f, 0xc00c,		0x21, 0
	.dw 0x14c0, 0xc00c,	0x14ff, 0xc00c,		0x21, 0
	.dw 0x1540, 0xc00c,	0x157f, 0xc00c,		0x21, 0
	.dw 0x15c0, 0xc00c,	0x15ff, 0xc00c,		0x21, 0
	.dw 0x1640, 0xc00c,	0x167f, 0xc00c,		0x21, 0
	.dw 0x16c0, 0xc00c,	0x16ff, 0xc00c,		0x21, 0
	.dw 0x1740, 0xc00c,	0x177f, 0xc00c,		0x21, 0
	.dw 0x17c0, 0xc00c,	0x17ff, 0xc00c,		0x21, 0
	.dw 0x1840, 0xc00c,	0x187f, 0xc00c,		0x21, 0
	.dw 0x18c0, 0xc00c,	0x18ff, 0xc00c,		0x21, 0
	.dw 0x1940, 0xc00c,	0x197f, 0xc00c,		0x21, 0
	.dw 0x19c0, 0xc00c,	0x1fff, 0xc00c,		0x21, 0
	.dw 0x2040, 0xc00c,	0x207f, 0xc00c,		0x21, 0
	.dw 0x20c0, 0xc00c,	0x20ff, 0xc00c,		0x21, 0
	.dw 0x2140, 0xc00c,	0x217f, 0xc00c,		0x21, 0
	.dw 0x21c0, 0xc00c,	0x21ff, 0xc00c,		0x21, 0
	.dw 0x2240, 0xc00c,	0x227f, 0xc00c,		0x21, 0
	.dw 0x22c0, 0xc00c,	0x22ff, 0xc00c,		0x21, 0
	.dw 0x2340, 0xc00c,	0x237f, 0xc00c,		0x21, 0
	.dw 0x23c0, 0xc00c,	0x23ff, 0xc00c,		0x21, 0
	.dw 0x2440, 0xc00c,	0x247f, 0xc00c,		0x21, 0
	.dw 0x24c0, 0xc00c,	0x24ff, 0xc00c,		0x21, 0
	.dw 0x2540, 0xc00c,	0x257f, 0xc00c,		0x21, 0
	.dw 0x25c0, 0xc00c,	0x25ff, 0xc00c,		0x21, 0
	.dw 0x2640, 0xc00c,	0x267f, 0xc00c,		0x21, 0
	.dw 0x26c0, 0xc00c,	0x26ff, 0xc00c,		0x21, 0
	.dw 0x2740, 0xc00c,	0x277f, 0xc00c,		0x21, 0
	.dw 0x27c0, 0xc00c,	0x27ff, 0xc00c,		0x21, 0
	.dw 0x2840, 0xc00c,	0x287f, 0xc00c,		0x21, 0
	.dw 0x28c0, 0xc00c,	0x28ff, 0xc00c,		0x21, 0
	.dw 0x2940, 0xc00c,	0x297f, 0xc00c,		0x21, 0
	.dw 0x29c0, 0xc00c,	0x29ff, 0xc00c,		0x21, 0
	.dw 0x2a40, 0xc00c,	0x2a7f, 0xc00c,		0x21, 0
	.dw 0x2ac0, 0xc00c,	0x2aff, 0xc00c,		0x21, 0
	.dw 0x2b40, 0xc00c,	0x2b7f, 0xc00c,		0x21, 0
	.dw 0x2bc0, 0xc00c,	0x2bff, 0xc00c,		0x21, 0
	.dw 0x2c40, 0xc00c,	0x2c7f, 0xc00c,		0x21, 0
	.dw 0x2cc0, 0xc00c,	0x2cff, 0xc00c,		0x21, 0
	.dw 0x2d40, 0xc00c,	0x2d7f, 0xc00c,		0x21, 0
	.dw 0x2dc0, 0xc00c,	0x2dff, 0xc00c,		0x21, 0
	.dw 0x2e40, 0xc00c,	0x2e7f, 0xc00c,		0x21, 0
	.dw 0x2ec0, 0xc00c,	0x2eff, 0xc00c,		0x21, 0
	.dw 0x2f40, 0xc00c,	0x2f7f, 0xc00c,		0x21, 0
	.dw 0x2fc0, 0xc00c,	0x2fff, 0xc00c,		0x21, 0
	.dw 0x3040, 0xc00c,	0x307f, 0xc00c,		0x21, 0
	.dw 0x30c0, 0xc00c,	0x30ff, 0xc00c,		0x21, 0
	.dw 0x3140, 0xc00c,	0x317f, 0xc00c,		0x21, 0
	.dw 0x31c0, 0xc00c,	0x31ff, 0xc00c,		0x21, 0
	.dw 0x3240, 0xc00c,	0x327f, 0xc00c,		0x21, 0
	.dw 0x32c0, 0xc00c,	0x32ff, 0xc00c,		0x21, 0
	.dw 0x3340, 0xc00c,	0x337f, 0xc00c,		0x21, 0
	.dw 0x33c0, 0xc00c,	0x33ff, 0xc00c,		0x21, 0
	.dw 0x3440, 0xc00c,	0x347f, 0xc00c,		0x21, 0
	.dw 0x34c0, 0xc00c,	0x34ff, 0xc00c,		0x21, 0
	.dw 0x3540, 0xc00c,	0x357f, 0xc00c,		0x21, 0
	.dw 0x35c0, 0xc00c,	0x35ff, 0xc00c,		0x21, 0
	.dw 0x3640, 0xc00c,	0x367f, 0xc00c,		0x21, 0
	.dw 0x36c0, 0xc00c,	0x36ff, 0xc00c,		0x21, 0
	.dw 0x3740, 0xc00c,	0x377f, 0xc00c,		0x21, 0
	.dw 0x37c0, 0xc00c,	0x37ff, 0xc00c,		0x21, 0
	.dw 0x3840, 0xc00c,	0x387f, 0xc00c,		0x21, 0
	.dw 0x38c0, 0xc00c,	0x38ff, 0xc00c,		0x21, 0
	.dw 0x3940, 0xc00c,	0x397f, 0xc00c,		0x21, 0
	.dw 0x39c0, 0xc00c,	0x3fff, 0xc00c,		0x21, 0
	.dw 0x4040, 0xc00c,	0x407f, 0xc00c,		0x21, 0
	.dw 0x40c0, 0xc00c,	0x40ff, 0xc00c,		0x21, 0
	.dw 0x4140, 0xc00c,	0x417f, 0xc00c,		0x21, 0
	.dw 0x41c0, 0xc00c,	0x41ff, 0xc00c,		0x21, 0
	.dw 0x4240, 0xc00c,	0x427f, 0xc00c,		0x21, 0
	.dw 0x42c0, 0xc00c,	0x42ff, 0xc00c,		0x21, 0
	.dw 0x4340, 0xc00c,	0x437f, 0xc00c,		0x21, 0
	.dw 0x43c0, 0xc00c,	0x43ff, 0xc00c,		0x21, 0
	.dw 0x4440, 0xc00c,	0x447f, 0xc00c,		0x21, 0
	.dw 0x44c0, 0xc00c,	0x44ff, 0xc00c,		0x21, 0
	.dw 0x4540, 0xc00c,	0x457f, 0xc00c,		0x21, 0
	.dw 0x45c0, 0xc00c,	0x45ff, 0xc00c,		0x21, 0
	.dw 0x4640, 0xc00c,	0x467f, 0xc00c,		0x21, 0
	.dw 0x46c0, 0xc00c,	0x46ff, 0xc00c,		0x21, 0
	.dw 0x4740, 0xc00c,	0x477f, 0xc00c,		0x21, 0
	.dw 0x47c0, 0xc00c,	0x47ff, 0xc00c,		0x21, 0
	.dw 0x4840, 0xc00c,	0x487f, 0xc00c,		0x21, 0
	.dw 0x48c0, 0xc00c,	0x48ff, 0xc00c,		0x21, 0
	.dw 0x4940, 0xc00c,	0x497f, 0xc00c,		0x21, 0
	.dw 0x49c0, 0xc00c,	0x49ff, 0xc00c,		0x21, 0
	.dw 0x4a40, 0xc00c,	0x4a7f, 0xc00c,		0x21, 0
	.dw 0x4ac0, 0xc00c,	0x4aff, 0xc00c,		0x21, 0
	.dw 0x4b40, 0xc00c,	0x4b7f, 0xc00c,		0x21, 0
	.dw 0x4bc0, 0xc00c,	0x4bff, 0xc00c,		0x21, 0
	.dw 0x4c40, 0xc00c,	0x4c7f, 0xc00c,		0x21, 0
	.dw 0x4cc0, 0xc00c,	0x4cff, 0xc00c,		0x21, 0
	.dw 0x4d40, 0xc00c,	0x4d7f, 0xc00c,		0x21, 0
	.dw 0x4dc0, 0xc00c,	0x4dff, 0xc00c,		0x21, 0
	.dw 0x4e40, 0xc00c,	0x4e7f, 0xc00c,		0x21, 0
	.dw 0x4ec0, 0xc00c,	0x4eff, 0xc00c,		0x21, 0
	.dw 0x4f40, 0xc00c,	0x4f7f, 0xc00c,		0x21, 0
	.dw 0x4fc0, 0xc00c,	0x4fff, 0xc00c,		0x21, 0
	.dw 0x5040, 0xc00c,	0x507f, 0xc00c,		0x21, 0
	.dw 0x50c0, 0xc00c,	0x50ff, 0xc00c,		0x21, 0
	.dw 0x5140, 0xc00c,	0x517f, 0xc00c,		0x21, 0
	.dw 0x51c0, 0xc00c,	0x51ff, 0xc00c,		0x21, 0
	.dw 0x5240, 0xc00c,	0x527f, 0xc00c,		0x21, 0
	.dw 0x52c0, 0xc00c,	0x52ff, 0xc00c,		0x21, 0
	.dw 0x5340, 0xc00c,	0x537f, 0xc00c,		0x21, 0
	.dw 0x53c0, 0xc00c,	0x53ff, 0xc00c,		0x21, 0
	.dw 0x5440, 0xc00c,	0x547f, 0xc00c,		0x21, 0
	.dw 0x54c0, 0xc00c,	0x54ff, 0xc00c,		0x21, 0
	.dw 0x5540, 0xc00c,	0x557f, 0xc00c,		0x21, 0
	.dw 0x55c0, 0xc00c,	0x55ff, 0xc00c,		0x21, 0
	.dw 0x5640, 0xc00c,	0x567f, 0xc00c,		0x21, 0
	.dw 0x56c0, 0xc00c,	0x56ff, 0xc00c,		0x21, 0
	.dw 0x5740, 0xc00c,	0x577f, 0xc00c,		0x21, 0
	.dw 0x57c0, 0xc00c,	0x57ff, 0xc00c,		0x21, 0
	.dw 0x5840, 0xc00c,	0x587f, 0xc00c,		0x21, 0
	.dw 0x58c0, 0xc00c,	0x58ff, 0xc00c,		0x21, 0
	.dw 0x5940, 0xc00c,	0x597f, 0xc00c,		0x21, 0
	.dw 0x59c0, 0xc00c,	0x5fff, 0xc00c,		0x21, 0
	.dw 0x6040, 0xc00c,	0x607f, 0xc00c,		0x21, 0
	.dw 0x60c0, 0xc00c,	0x60ff, 0xc00c,		0x21, 0
	.dw 0x6140, 0xc00c,	0x617f, 0xc00c,		0x21, 0
	.dw 0x61c0, 0xc00c,	0x61ff, 0xc00c,		0x21, 0
	.dw 0x6240, 0xc00c,	0x627f, 0xc00c,		0x21, 0
	.dw 0x62c0, 0xc00c,	0x62ff, 0xc00c,		0x21, 0
	.dw 0x6340, 0xc00c,	0x637f, 0xc00c,		0x21, 0
	.dw 0x63c0, 0xc00c,	0x63ff, 0xc00c,		0x21, 0
	.dw 0x6440, 0xc00c,	0x647f, 0xc00c,		0x21, 0
	.dw 0x64c0, 0xc00c,	0x64ff, 0xc00c,		0x21, 0
	.dw 0x6540, 0xc00c,	0x657f, 0xc00c,		0x21, 0
	.dw 0x65c0, 0xc00c,	0x65ff, 0xc00c,		0x21, 0
	.dw 0x6640, 0xc00c,	0x667f, 0xc00c,		0x21, 0
	.dw 0x66c0, 0xc00c,	0x66ff, 0xc00c,		0x21, 0
	.dw 0x6740, 0xc00c,	0x677f, 0xc00c,		0x21, 0
	.dw 0x67c0, 0xc00c,	0x67ff, 0xc00c,		0x21, 0
	.dw 0x6840, 0xc00c,	0x687f, 0xc00c,		0x21, 0
	.dw 0x68c0, 0xc00c,	0x68ff, 0xc00c,		0x21, 0
	.dw 0x6940, 0xc00c,	0x697f, 0xc00c,		0x21, 0
	.dw 0x69c0, 0xc00c,	0x69ff, 0xc00c,		0x21, 0
	.dw 0x6a40, 0xc00c,	0x6a7f, 0xc00c,		0x21, 0
	.dw 0x6ac0, 0xc00c,	0x6aff, 0xc00c,		0x21, 0
	.dw 0x6b40, 0xc00c,	0x6b7f, 0xc00c,		0x21, 0
	.dw 0x6bc0, 0xc00c,	0x6bff, 0xc00c,		0x21, 0
	.dw 0x6c40, 0xc00c,	0x6c7f, 0xc00c,		0x21, 0
	.dw 0x6cc0, 0xc00c,	0x6cff, 0xc00c,		0x21, 0
	.dw 0x6d40, 0xc00c,	0x6d7f, 0xc00c,		0x21, 0
	.dw 0x6dc0, 0xc00c,	0x6dff, 0xc00c,		0x21, 0
	.dw 0x6e40, 0xc00c,	0x6e7f, 0xc00c,		0x21, 0
	.dw 0x6ec0, 0xc00c,	0x6eff, 0xc00c,		0x21, 0
	.dw 0x6f40, 0xc00c,	0x6f7f, 0xc00c,		0x21, 0
	.dw 0x6fc0, 0xc00c,	0x6fff, 0xc00c,		0x21, 0
	.dw 0x7040, 0xc00c,	0x707f, 0xc00c,		0x21, 0
	.dw 0x70c0, 0xc00c,	0x70ff, 0xc00c,		0x21, 0
	.dw 0x7140, 0xc00c,	0x717f, 0xc00c,		0x21, 0
	.dw 0x71c0, 0xc00c,	0x71ff, 0xc00c,		0x21, 0
	.dw 0x7240, 0xc00c,	0x727f, 0xc00c,		0x21, 0
	.dw 0x72c0, 0xc00c,	0x72ff, 0xc00c,		0x21, 0
	.dw 0x7340, 0xc00c,	0x737f, 0xc00c,		0x21, 0
	.dw 0x73c0, 0xc00c,	0x73ff, 0xc00c,		0x21, 0
	.dw 0x7440, 0xc00c,	0x747f, 0xc00c,		0x21, 0
	.dw 0x74c0, 0xc00c,	0x74ff, 0xc00c,		0x21, 0
	.dw 0x7540, 0xc00c,	0x757f, 0xc00c,		0x21, 0
	.dw 0x75c0, 0xc00c,	0x75ff, 0xc00c,		0x21, 0
	.dw 0x7640, 0xc00c,	0x767f, 0xc00c,		0x21, 0
	.dw 0x76c0, 0xc00c,	0x76ff, 0xc00c,		0x21, 0
	.dw 0x7740, 0xc00c,	0x777f, 0xc00c,		0x21, 0
	.dw 0x77c0, 0xc00c,	0x77ff, 0xc00c,		0x21, 0
	.dw 0x7840, 0xc00c,	0x787f, 0xc00c,		0x21, 0
	.dw 0x78c0, 0xc00c,	0x78ff, 0xc00c,		0x21, 0
	.dw 0x7940, 0xc00c,	0x797f, 0xc00c,		0x21, 0
	.dw 0x79c0, 0xc00c,	0x7fff, 0xc00c,		0x21, 0
	.dw 0x8040, 0xc00c,	0x807f, 0xc00c,		0x21, 0
	.dw 0x80c0, 0xc00c,	0x80ff, 0xc00c,		0x21, 0
	.dw 0x8140, 0xc00c,	0x817f, 0xc00c,		0x21, 0
	.dw 0x81c0, 0xc00c,	0x81ff, 0xc00c,		0x21, 0
	.dw 0x8240, 0xc00c,	0x827f, 0xc00c,		0x21, 0
	.dw 0x82c0, 0xc00c,	0x82ff, 0xc00c,		0x21, 0
	.dw 0x8340, 0xc00c,	0x837f, 0xc00c,		0x21, 0
	.dw 0x83c0, 0xc00c,	0x83ff, 0xc00c,		0x21, 0
	.dw 0x8440, 0xc00c,	0x847f, 0xc00c,		0x21, 0
	.dw 0x84c0, 0xc00c,	0x84ff, 0xc00c,		0x21, 0
	.dw 0x8540, 0xc00c,	0x857f, 0xc00c,		0x21, 0
	.dw 0x85c0, 0xc00c,	0x85ff, 0xc00c,		0x21, 0
	.dw 0x8640, 0xc00c,	0x867f, 0xc00c,		0x21, 0
	.dw 0x86c0, 0xc00c,	0x86ff, 0xc00c,		0x21, 0
	.dw 0x8740, 0xc00c,	0x877f, 0xc00c,		0x21, 0
	.dw 0x87c0, 0xc00c,	0x87ff, 0xc00c,		0x21, 0
	.dw 0x8840, 0xc00c,	0x887f, 0xc00c,		0x21, 0
	.dw 0x88c0, 0xc00c,	0x88ff, 0xc00c,		0x21, 0
	.dw 0x8940, 0xc00c,	0x897f, 0xc00c,		0x21, 0
	.dw 0x89c0, 0xc00c,	0x89ff, 0xc00c,		0x21, 0
	.dw 0x8a40, 0xc00c,	0x8a7f, 0xc00c,		0x21, 0
	.dw 0x8ac0, 0xc00c,	0x8aff, 0xc00c,		0x21, 0
	.dw 0x8b40, 0xc00c,	0x8b7f, 0xc00c,		0x21, 0
	.dw 0x8bc0, 0xc00c,	0x8bff, 0xc00c,		0x21, 0
	.dw 0x8c40, 0xc00c,	0x8c7f, 0xc00c,		0x21, 0
	.dw 0x8cc0, 0xc00c,	0x8cff, 0xc00c,		0x21, 0
	.dw 0x8d40, 0xc00c,	0x8d7f, 0xc00c,		0x21, 0
	.dw 0x8dc0, 0xc00c,	0x8dff, 0xc00c,		0x21, 0
	.dw 0x8e40, 0xc00c,	0x8e7f, 0xc00c,		0x21, 0
	.dw 0x8ec0, 0xc00c,	0x8eff, 0xc00c,		0x21, 0
	.dw 0x8f40, 0xc00c,	0x8f7f, 0xc00c,		0x21, 0
	.dw 0x8fc0, 0xc00c,	0x8fff, 0xc00c,		0x21, 0
	.dw 0x9040, 0xc00c,	0x907f, 0xc00c,		0x21, 0
	.dw 0x90c0, 0xc00c,	0x90ff, 0xc00c,		0x21, 0
	.dw 0x9140, 0xc00c,	0x917f, 0xc00c,		0x21, 0
	.dw 0x91c0, 0xc00c,	0x91ff, 0xc00c,		0x21, 0
	.dw 0x9240, 0xc00c,	0x927f, 0xc00c,		0x21, 0
	.dw 0x92c0, 0xc00c,	0x92ff, 0xc00c,		0x21, 0
	.dw 0x9340, 0xc00c,	0x937f, 0xc00c,		0x21, 0
	.dw 0x93c0, 0xc00c,	0x93ff, 0xc00c,		0x21, 0
	.dw 0x9440, 0xc00c,	0x947f, 0xc00c,		0x21, 0
	.dw 0x94c0, 0xc00c,	0x94ff, 0xc00c,		0x21, 0
	.dw 0x9540, 0xc00c,	0x957f, 0xc00c,		0x21, 0
	.dw 0x95c0, 0xc00c,	0x95ff, 0xc00c,		0x21, 0
	.dw 0x9640, 0xc00c,	0x967f, 0xc00c,		0x21, 0
	.dw 0x96c0, 0xc00c,	0x96ff, 0xc00c,		0x21, 0
	.dw 0x9740, 0xc00c,	0x977f, 0xc00c,		0x21, 0
	.dw 0x97c0, 0xc00c,	0x97ff, 0xc00c,		0x21, 0
	.dw 0x9840, 0xc00c,	0x987f, 0xc00c,		0x21, 0
	.dw 0x98c0, 0xc00c,	0x98ff, 0xc00c,		0x21, 0
	.dw 0x9940, 0xc00c,	0x997f, 0xc00c,		0x21, 0
	.dw 0x99c0, 0xc00c,	0x9fff, 0xc00c,		0x21, 0
	.dw 0xa040, 0xc00c,	0xa07f, 0xc00c,		0x21, 0
	.dw 0xa0c0, 0xc00c,	0xa0ff, 0xc00c,		0x21, 0
	.dw 0xa140, 0xc00c,	0xa17f, 0xc00c,		0x21, 0
	.dw 0xa1c0, 0xc00c,	0xa1ff, 0xc00c,		0x21, 0
	.dw 0xa240, 0xc00c,	0xa27f, 0xc00c,		0x21, 0
	.dw 0xa2c0, 0xc00c,	0xa2ff, 0xc00c,		0x21, 0
	.dw 0xa340, 0xc00c,	0xa37f, 0xc00c,		0x21, 0
	.dw 0xa3c0, 0xc00c,	0xa3ff, 0xc00c,		0x21, 0
	.dw 0xa440, 0xc00c,	0xa47f, 0xc00c,		0x21, 0
	.dw 0xa4c0, 0xc00c,	0xa4ff, 0xc00c,		0x21, 0
	.dw 0xa540, 0xc00c,	0xa57f, 0xc00c,		0x21, 0
	.dw 0xa5c0, 0xc00c,	0xa5ff, 0xc00c,		0x21, 0
	.dw 0xa640, 0xc00c,	0xa67f, 0xc00c,		0x21, 0
	.dw 0xa6c0, 0xc00c,	0xa6ff, 0xc00c,		0x21, 0
	.dw 0xa740, 0xc00c,	0xa77f, 0xc00c,		0x21, 0
	.dw 0xa7c0, 0xc00c,	0xa7ff, 0xc00c,		0x21, 0
	.dw 0xa840, 0xc00c,	0xa87f, 0xc00c,		0x21, 0
	.dw 0xa8c0, 0xc00c,	0xa8ff, 0xc00c,		0x21, 0
	.dw 0xa940, 0xc00c,	0xa97f, 0xc00c,		0x21, 0
	.dw 0xa9c0, 0xc00c,	0xa9ff, 0xc00c,		0x21, 0
	.dw 0xaa40, 0xc00c,	0xaa7f, 0xc00c,		0x21, 0
	.dw 0xaac0, 0xc00c,	0xaaff, 0xc00c,		0x21, 0
	.dw 0xab40, 0xc00c,	0xab7f, 0xc00c,		0x21, 0
	.dw 0xabc0, 0xc00c,	0xabff, 0xc00c,		0x21, 0
	.dw 0xac40, 0xc00c,	0xac7f, 0xc00c,		0x21, 0
	.dw 0xacc0, 0xc00c,	0xacff, 0xc00c,		0x21, 0
	.dw 0xad40, 0xc00c,	0xad7f, 0xc00c,		0x21, 0
	.dw 0xadc0, 0xc00c,	0xadff, 0xc00c,		0x21, 0
	.dw 0xae40, 0xc00c,	0xae7f, 0xc00c,		0x21, 0
	.dw 0xaec0, 0xc00c,	0xaeff, 0xc00c,		0x21, 0
	.dw 0xaf40, 0xc00c,	0xaf7f, 0xc00c,		0x21, 0
	.dw 0xafc0, 0xc00c,	0xafff, 0xc00c,		0x21, 0
	.dw 0xb040, 0xc00c,	0xb07f, 0xc00c,		0x21, 0
	.dw 0xb0c0, 0xc00c,	0xb0ff, 0xc00c,		0x21, 0
	.dw 0xb140, 0xc00c,	0xb17f, 0xc00c,		0x21, 0
	.dw 0xb1c0, 0xc00c,	0xb1ff, 0xc00c,		0x21, 0
	.dw 0xb240, 0xc00c,	0xb27f, 0xc00c,		0x21, 0
	.dw 0xb2c0, 0xc00c,	0xb2ff, 0xc00c,		0x21, 0
	.dw 0xb340, 0xc00c,	0xb37f, 0xc00c,		0x21, 0
	.dw 0xb3c0, 0xc00c,	0xb3ff, 0xc00c,		0x21, 0
	.dw 0xb440, 0xc00c,	0xb47f, 0xc00c,		0x21, 0
	.dw 0xb4c0, 0xc00c,	0xb4ff, 0xc00c,		0x21, 0
	.dw 0xb540, 0xc00c,	0xb57f, 0xc00c,		0x21, 0
	.dw 0xb5c0, 0xc00c,	0xb5ff, 0xc00c,		0x21, 0
	.dw 0xb640, 0xc00c,	0xb67f, 0xc00c,		0x21, 0
	.dw 0xb6c0, 0xc00c,	0xb6ff, 0xc00c,		0x21, 0
	.dw 0xb740, 0xc00c,	0xb77f, 0xc00c,		0x21, 0
	.dw 0xb7c0, 0xc00c,	0xb7ff, 0xc00c,		0x21, 0
	.dw 0xb840, 0xc00c,	0xb87f, 0xc00c,		0x21, 0
	.dw 0xb8c0, 0xc00c,	0xb8ff, 0xc00c,		0x21, 0
	.dw 0xb940, 0xc00c,	0xb97f, 0xc00c,		0x21, 0
	.dw 0xb9c0, 0xc00c,	0xbfff, 0xc00c,		0x21, 0
	.dw 0xc040, 0xc00c,	0xc07f, 0xc00c,		0x21, 0
	.dw 0xc0c0, 0xc00c,	0xc0ff, 0xc00c,		0x21, 0
	.dw 0xc140, 0xc00c,	0xc17f, 0xc00c,		0x21, 0
	.dw 0xc1c0, 0xc00c,	0xc1ff, 0xc00c,		0x21, 0
	.dw 0xc240, 0xc00c,	0xc27f, 0xc00c,		0x21, 0
	.dw 0xc2c0, 0xc00c,	0xc2ff, 0xc00c,		0x21, 0
	.dw 0xc340, 0xc00c,	0xc37f, 0xc00c,		0x21, 0
	.dw 0xc3c0, 0xc00c,	0xc3ff, 0xc00c,		0x21, 0
	.dw 0xc440, 0xc00c,	0xc47f, 0xc00c,		0x21, 0
	.dw 0xc4c0, 0xc00c,	0xc4ff, 0xc00c,		0x21, 0
	.dw 0xc540, 0xc00c,	0xc57f, 0xc00c,		0x21, 0
	.dw 0xc5c0, 0xc00c,	0xc5ff, 0xc00c,		0x21, 0
	.dw 0xc640, 0xc00c,	0xc67f, 0xc00c,		0x21, 0
	.dw 0xc6c0, 0xc00c,	0xc6ff, 0xc00c,		0x21, 0
	.dw 0xc740, 0xc00c,	0xc77f, 0xc00c,		0x21, 0
	.dw 0xc7c0, 0xc00c,	0xc7ff, 0xc00c,		0x21, 0
	.dw 0xc840, 0xc00c,	0xc87f, 0xc00c,		0x21, 0
	.dw 0xc8c0, 0xc00c,	0xc8ff, 0xc00c,		0x21, 0
	.dw 0xc940, 0xc00c,	0xc97f, 0xc00c,		0x21, 0
	.dw 0xc9c0, 0xc00c,	0xc9ff, 0xc00c,		0x21, 0
	.dw 0xca40, 0xc00c,	0xca7f, 0xc00c,		0x21, 0
	.dw 0xcac0, 0xc00c,	0xcaff, 0xc00c,		0x21, 0
	.dw 0xcb40, 0xc00c,	0xcb7f, 0xc00c,		0x21, 0
	.dw 0xcbc0, 0xc00c,	0xcbff, 0xc00c,		0x21, 0
	.dw 0xcc40, 0xc00c,	0xcc7f, 0xc00c,		0x21, 0
	.dw 0xccc0, 0xc00c,	0xccff, 0xc00c,		0x21, 0
	.dw 0xcd40, 0xc00c,	0xcd7f, 0xc00c,		0x21, 0
	.dw 0xcdc0, 0xc00c,	0xcdff, 0xc00c,		0x21, 0
	.dw 0xce40, 0xc00c,	0xce7f, 0xc00c,		0x21, 0
	.dw 0xcec0, 0xc00c,	0xceff, 0xc00c,		0x21, 0
	.dw 0xcf40, 0xc00c,	0xcf7f, 0xc00c,		0x21, 0
	.dw 0xcfc0, 0xc00c,	0xcfff, 0xc00c,		0x21, 0
	.dw 0xd040, 0xc00c,	0xd07f, 0xc00c,		0x21, 0
	.dw 0xd0c0, 0xc00c,	0xd0ff, 0xc00c,		0x21, 0
	.dw 0xd140, 0xc00c,	0xd17f, 0xc00c,		0x21, 0
	.dw 0xd1c0, 0xc00c,	0xd1ff, 0xc00c,		0x21, 0
	.dw 0xd240, 0xc00c,	0xd27f, 0xc00c,		0x21, 0
	.dw 0xd2c0, 0xc00c,	0xd2ff, 0xc00c,		0x21, 0
	.dw 0xd340, 0xc00c,	0xd37f, 0xc00c,		0x21, 0
	.dw 0xd3c0, 0xc00c,	0xd3ff, 0xc00c,		0x21, 0
	.dw 0xd440, 0xc00c,	0xd47f, 0xc00c,		0x21, 0
	.dw 0xd4c0, 0xc00c,	0xd4ff, 0xc00c,		0x21, 0
	.dw 0xd540, 0xc00c,	0xd57f, 0xc00c,		0x21, 0
	.dw 0xd5c0, 0xc00c,	0xd5ff, 0xc00c,		0x21, 0
	.dw 0xd640, 0xc00c,	0xd67f, 0xc00c,		0x21, 0
	.dw 0xd6c0, 0xc00c,	0xd6ff, 0xc00c,		0x21, 0
	.dw 0xd740, 0xc00c,	0xd77f, 0xc00c,		0x21, 0
	.dw 0xd7c0, 0xc00c,	0xd7ff, 0xc00c,		0x21, 0
	.dw 0xd840, 0xc00c,	0xd87f, 0xc00c,		0x21, 0
	.dw 0xd8c0, 0xc00c,	0xd8ff, 0xc00c,		0x21, 0
	.dw 0xd940, 0xc00c,	0xd97f, 0xc00c,		0x21, 0
	.dw 0xd9c0, 0xc00c,	0xdfff, 0xc00c,		0x21, 0
	.dw 0xe040, 0xc00c,	0xe07f, 0xc00c,		0x21, 0
	.dw 0xe0c0, 0xc00c,	0xe0ff, 0xc00c,		0x21, 0
	.dw 0xe140, 0xc00c,	0xe17f, 0xc00c,		0x21, 0
	.dw 0xe1c0, 0xc00c,	0xe1ff, 0xc00c,		0x21, 0
	.dw 0xe240, 0xc00c,	0xe27f, 0xc00c,		0x21, 0
	.dw 0xe2c0, 0xc00c,	0xe2ff, 0xc00c,		0x21, 0
	.dw 0xe340, 0xc00c,	0xe37f, 0xc00c,		0x21, 0
	.dw 0xe3c0, 0xc00c,	0xe3ff, 0xc00c,		0x21, 0
	.dw 0xe440, 0xc00c,	0xe47f, 0xc00c,		0x21, 0
	.dw 0xe4c0, 0xc00c,	0xe4ff, 0xc00c,		0x21, 0
	.dw 0xe540, 0xc00c,	0xe57f, 0xc00c,		0x21, 0
	.dw 0xe5c0, 0xc00c,	0xe5ff, 0xc00c,		0x21, 0
	.dw 0xe640, 0xc00c,	0xe67f, 0xc00c,		0x21, 0
	.dw 0xe6c0, 0xc00c,	0xe6ff, 0xc00c,		0x21, 0
	.dw 0xe740, 0xc00c,	0xe77f, 0xc00c,		0x21, 0
	.dw 0xe7c0, 0xc00c,	0xe7ff, 0xc00c,		0x21, 0
	.dw 0xe840, 0xc00c,	0xe87f, 0xc00c,		0x21, 0
	.dw 0xe8c0, 0xc00c,	0xe8ff, 0xc00c,		0x21, 0
	.dw 0xe940, 0xc00c,	0xe97f, 0xc00c,		0x21, 0
	.dw 0xe9c0, 0xc00c,	0xe9ff, 0xc00c,		0x21, 0
	.dw 0xea40, 0xc00c,	0xea7f, 0xc00c,		0x21, 0
	.dw 0xeac0, 0xc00c,	0xeaff, 0xc00c,		0x21, 0
	.dw 0xeb40, 0xc00c,	0xeb7f, 0xc00c,		0x21, 0
	.dw 0xebc0, 0xc00c,	0xebff, 0xc00c,		0x21, 0
	.dw 0xec40, 0xc00c,	0xec7f, 0xc00c,		0x21, 0
	.dw 0xecc0, 0xc00c,	0xecff, 0xc00c,		0x21, 0
	.dw 0xed40, 0xc00c,	0xed7f, 0xc00c,		0x21, 0
	.dw 0xedc0, 0xc00c,	0xedff, 0xc00c,		0x21, 0
	.dw 0xee40, 0xc00c,	0xee7f, 0xc00c,		0x21, 0
	.dw 0xeec0, 0xc00c,	0xeeff, 0xc00c,		0x21, 0
	.dw 0xef40, 0xc00c,	0xef7f, 0xc00c,		0x21, 0
	.dw 0xefc0, 0xc00c,	0xefff, 0xc00c,		0x21, 0
	.dw 0xf040, 0xc00c,	0xf07f, 0xc00c,		0x21, 0
	.dw 0xf0c0, 0xc00c,	0xf0ff, 0xc00c,		0x21, 0
	.dw 0xf140, 0xc00c,	0xf17f, 0xc00c,		0x21, 0
	.dw 0xf1c0, 0xc00c,	0xf1ff, 0xc00c,		0x21, 0
	.dw 0xf240, 0xc00c,	0xf27f, 0xc00c,		0x21, 0
	.dw 0xf2c0, 0xc00c,	0xf2ff, 0xc00c,		0x21, 0
	.dw 0xf340, 0xc00c,	0xf37f, 0xc00c,		0x21, 0
	.dw 0xf3c0, 0xc00c,	0xf3ff, 0xc00c,		0x21, 0
	.dw 0xf440, 0xc00c,	0xf47f, 0xc00c,		0x21, 0
	.dw 0xf4c0, 0xc00c,	0xf4ff, 0xc00c,		0x21, 0
	.dw 0xf540, 0xc00c,	0xf57f, 0xc00c,		0x21, 0
	.dw 0xf5c0, 0xc00c,	0xf5ff, 0xc00c,		0x21, 0
	.dw 0xf640, 0xc00c,	0xf67f, 0xc00c,		0x21, 0
	.dw 0xf6c0, 0xc00c,	0xf6ff, 0xc00c,		0x21, 0
	.dw 0xf740, 0xc00c,	0xf77f, 0xc00c,		0x21, 0
	.dw 0xf7c0, 0xc00c,	0xf7ff, 0xc00c,		0x21, 0
	.dw 0xf840, 0xc00c,	0xf87f, 0xc00c,		0x21, 0
	.dw 0xf8c0, 0xc00c,	0xf8ff, 0xc00c,		0x21, 0
	.dw 0xf940, 0xc00c,	0xf97f, 0xc00c,		0x21, 0
	.dw 0xf9c0, 0xc00c,	0xffff, 0xc00c,		0x21, 0
	.dw 0x0040, 0xc00d,	0x007f, 0xc00d,		0x21, 0
	.dw 0x00c0, 0xc00d,	0x00ff, 0xc00d,		0x21, 0
	.dw 0x0140, 0xc00d,	0x017f, 0xc00d,		0x21, 0
	.dw 0x01c0, 0xc00d,	0x01ff, 0xc00d,		0x21, 0
	.dw 0x0240, 0xc00d,	0x027f, 0xc00d,		0x21, 0
	.dw 0x02c0, 0xc00d,	0x02ff, 0xc00d,		0x21, 0
	.dw 0x0340, 0xc00d,	0x037f, 0xc00d,		0x21, 0
	.dw 0x03c0, 0xc00d,	0x03ff, 0xc00d,		0x21, 0
	.dw 0x0440, 0xc00d,	0x047f, 0xc00d,		0x21, 0
	.dw 0x04c0, 0xc00d,	0x04ff, 0xc00d,		0x21, 0
	.dw 0x0540, 0xc00d,	0x057f, 0xc00d,		0x21, 0
	.dw 0x05c0, 0xc00d,	0x05ff, 0xc00d,		0x21, 0
	.dw 0x0640, 0xc00d,	0x067f, 0xc00d,		0x21, 0
	.dw 0x06c0, 0xc00d,	0x06ff, 0xc00d,		0x21, 0
	.dw 0x0740, 0xc00d,	0x077f, 0xc00d,		0x21, 0
	.dw 0x07c0, 0xc00d,	0x07ff, 0xc00d,		0x21, 0
	.dw 0x0840, 0xc00d,	0x087f, 0xc00d,		0x21, 0
	.dw 0x08c0, 0xc00d,	0x08ff, 0xc00d,		0x21, 0
	.dw 0x0940, 0xc00d,	0x097f, 0xc00d,		0x21, 0
	.dw 0x09c0, 0xc00d,	0x09ff, 0xc00d,		0x21, 0
	.dw 0x0a40, 0xc00d,	0x0a7f, 0xc00d,		0x21, 0
	.dw 0x0ac0, 0xc00d,	0x0aff, 0xc00d,		0x21, 0
	.dw 0x0b40, 0xc00d,	0x0b7f, 0xc00d,		0x21, 0
	.dw 0x0bc0, 0xc00d,	0x0bff, 0xc00d,		0x21, 0
	.dw 0x0c40, 0xc00d,	0x0c7f, 0xc00d,		0x21, 0
	.dw 0x0cc0, 0xc00d,	0x0cff, 0xc00d,		0x21, 0
	.dw 0x0d40, 0xc00d,	0x0d7f, 0xc00d,		0x21, 0
	.dw 0x0dc0, 0xc00d,	0x0dff, 0xc00d,		0x21, 0
	.dw 0x0e40, 0xc00d,	0x0e7f, 0xc00d,		0x21, 0
	.dw 0x0ec0, 0xc00d,	0x0eff, 0xc00d,		0x21, 0
	.dw 0x0f40, 0xc00d,	0x0f7f, 0xc00d,		0x21, 0
	.dw 0x0fc0, 0xc00d,	0x0fff, 0xc00d,		0x21, 0
	.dw 0x1040, 0xc00d,	0x107f, 0xc00d,		0x21, 0
	.dw 0x10c0, 0xc00d,	0x10ff, 0xc00d,		0x21, 0
	.dw 0x1140, 0xc00d,	0x117f, 0xc00d,		0x21, 0
	.dw 0x11c0, 0xc00d,	0x11ff, 0xc00d,		0x21, 0
	.dw 0x1240, 0xc00d,	0x127f, 0xc00d,		0x21, 0
	.dw 0x12c0, 0xc00d,	0x12ff, 0xc00d,		0x21, 0
	.dw 0x1340, 0xc00d,	0x137f, 0xc00d,		0x21, 0
	.dw 0x13c0, 0xc00d,	0x13ff, 0xc00d,		0x21, 0
	.dw 0x1440, 0xc00d,	0x147f, 0xc00d,		0x21, 0
	.dw 0x14c0, 0xc00d,	0x14ff, 0xc00d,		0x21, 0
	.dw 0x1540, 0xc00d,	0x157f, 0xc00d,		0x21, 0
	.dw 0x15c0, 0xc00d,	0x15ff, 0xc00d,		0x21, 0
	.dw 0x1640, 0xc00d,	0x167f, 0xc00d,		0x21, 0
	.dw 0x16c0, 0xc00d,	0x16ff, 0xc00d,		0x21, 0
	.dw 0x1740, 0xc00d,	0x177f, 0xc00d,		0x21, 0
	.dw 0x17c0, 0xc00d,	0x17ff, 0xc00d,		0x21, 0
	.dw 0x1840, 0xc00d,	0x187f, 0xc00d,		0x21, 0
	.dw 0x18c0, 0xc00d,	0x18ff, 0xc00d,		0x21, 0
	.dw 0x1940, 0xc00d,	0x197f, 0xc00d,		0x21, 0
	.dw 0x19c0, 0xc00d,	0x1fff, 0xc00d,		0x21, 0
	.dw 0x2040, 0xc00d,	0x207f, 0xc00d,		0x21, 0
	.dw 0x20c0, 0xc00d,	0x20ff, 0xc00d,		0x21, 0
	.dw 0x2140, 0xc00d,	0x217f, 0xc00d,		0x21, 0
	.dw 0x21c0, 0xc00d,	0x21ff, 0xc00d,		0x21, 0
	.dw 0x2240, 0xc00d,	0x227f, 0xc00d,		0x21, 0
	.dw 0x22c0, 0xc00d,	0x22ff, 0xc00d,		0x21, 0
	.dw 0x2340, 0xc00d,	0x237f, 0xc00d,		0x21, 0
	.dw 0x23c0, 0xc00d,	0x23ff, 0xc00d,		0x21, 0
	.dw 0x2440, 0xc00d,	0x247f, 0xc00d,		0x21, 0
	.dw 0x24c0, 0xc00d,	0x24ff, 0xc00d,		0x21, 0
	.dw 0x2540, 0xc00d,	0x257f, 0xc00d,		0x21, 0
	.dw 0x25c0, 0xc00d,	0x25ff, 0xc00d,		0x21, 0
	.dw 0x2640, 0xc00d,	0x267f, 0xc00d,		0x21, 0
	.dw 0x26c0, 0xc00d,	0x26ff, 0xc00d,		0x21, 0
	.dw 0x2740, 0xc00d,	0x277f, 0xc00d,		0x21, 0
	.dw 0x27c0, 0xc00d,	0x27ff, 0xc00d,		0x21, 0
	.dw 0x2840, 0xc00d,	0x287f, 0xc00d,		0x21, 0
	.dw 0x28c0, 0xc00d,	0x28ff, 0xc00d,		0x21, 0
	.dw 0x2940, 0xc00d,	0x297f, 0xc00d,		0x21, 0
	.dw 0x29c0, 0xc00d,	0x29ff, 0xc00d,		0x21, 0
	.dw 0x2a40, 0xc00d,	0x2a7f, 0xc00d,		0x21, 0
	.dw 0x2ac0, 0xc00d,	0x2aff, 0xc00d,		0x21, 0
	.dw 0x2b40, 0xc00d,	0x2b7f, 0xc00d,		0x21, 0
	.dw 0x2bc0, 0xc00d,	0x2bff, 0xc00d,		0x21, 0
	.dw 0x2c40, 0xc00d,	0x2c7f, 0xc00d,		0x21, 0
	.dw 0x2cc0, 0xc00d,	0x2cff, 0xc00d,		0x21, 0
	.dw 0x2d40, 0xc00d,	0x2d7f, 0xc00d,		0x21, 0
	.dw 0x2dc0, 0xc00d,	0x2dff, 0xc00d,		0x21, 0
	.dw 0x2e40, 0xc00d,	0x2e7f, 0xc00d,		0x21, 0
	.dw 0x2ec0, 0xc00d,	0x2eff, 0xc00d,		0x21, 0
	.dw 0x2f40, 0xc00d,	0x2f7f, 0xc00d,		0x21, 0
	.dw 0x2fc0, 0xc00d,	0x2fff, 0xc00d,		0x21, 0
	.dw 0x3040, 0xc00d,	0x307f, 0xc00d,		0x21, 0
	.dw 0x30c0, 0xc00d,	0x30ff, 0xc00d,		0x21, 0
	.dw 0x3140, 0xc00d,	0x317f, 0xc00d,		0x21, 0
	.dw 0x31c0, 0xc00d,	0x31ff, 0xc00d,		0x21, 0
	.dw 0x3240, 0xc00d,	0x327f, 0xc00d,		0x21, 0
	.dw 0x32c0, 0xc00d,	0x32ff, 0xc00d,		0x21, 0
	.dw 0x3340, 0xc00d,	0x337f, 0xc00d,		0x21, 0
	.dw 0x33c0, 0xc00d,	0x33ff, 0xc00d,		0x21, 0
	.dw 0x3440, 0xc00d,	0x347f, 0xc00d,		0x21, 0
	.dw 0x34c0, 0xc00d,	0x34ff, 0xc00d,		0x21, 0
	.dw 0x3540, 0xc00d,	0x357f, 0xc00d,		0x21, 0
	.dw 0x35c0, 0xc00d,	0x35ff, 0xc00d,		0x21, 0
	.dw 0x3640, 0xc00d,	0x367f, 0xc00d,		0x21, 0
	.dw 0x36c0, 0xc00d,	0x36ff, 0xc00d,		0x21, 0
	.dw 0x3740, 0xc00d,	0x377f, 0xc00d,		0x21, 0
	.dw 0x37c0, 0xc00d,	0x37ff, 0xc00d,		0x21, 0
	.dw 0x3840, 0xc00d,	0x387f, 0xc00d,		0x21, 0
	.dw 0x38c0, 0xc00d,	0x38ff, 0xc00d,		0x21, 0
	.dw 0x3940, 0xc00d,	0x397f, 0xc00d,		0x21, 0
	.dw 0x39c0, 0xc00d,	0x3fff, 0xc00d,		0x21, 0
	.dw 0x4040, 0xc00d,	0x407f, 0xc00d,		0x21, 0
	.dw 0x40c0, 0xc00d,	0x40ff, 0xc00d,		0x21, 0
	.dw 0x4140, 0xc00d,	0x417f, 0xc00d,		0x21, 0
	.dw 0x41c0, 0xc00d,	0x41ff, 0xc00d,		0x21, 0
	.dw 0x4240, 0xc00d,	0x427f, 0xc00d,		0x21, 0
	.dw 0x42c0, 0xc00d,	0x42ff, 0xc00d,		0x21, 0
	.dw 0x4340, 0xc00d,	0x437f, 0xc00d,		0x21, 0
	.dw 0x43c0, 0xc00d,	0x43ff, 0xc00d,		0x21, 0
	.dw 0x4440, 0xc00d,	0x447f, 0xc00d,		0x21, 0
	.dw 0x44c0, 0xc00d,	0x44ff, 0xc00d,		0x21, 0
	.dw 0x4540, 0xc00d,	0x457f, 0xc00d,		0x21, 0
	.dw 0x45c0, 0xc00d,	0x45ff, 0xc00d,		0x21, 0
	.dw 0x4640, 0xc00d,	0x467f, 0xc00d,		0x21, 0
	.dw 0x46c0, 0xc00d,	0x46ff, 0xc00d,		0x21, 0
	.dw 0x4740, 0xc00d,	0x477f, 0xc00d,		0x21, 0
	.dw 0x47c0, 0xc00d,	0x47ff, 0xc00d,		0x21, 0
	.dw 0x4840, 0xc00d,	0x487f, 0xc00d,		0x21, 0
	.dw 0x48c0, 0xc00d,	0x48ff, 0xc00d,		0x21, 0
	.dw 0x4940, 0xc00d,	0x497f, 0xc00d,		0x21, 0
	.dw 0x49c0, 0xc00d,	0x49ff, 0xc00d,		0x21, 0
	.dw 0x4a40, 0xc00d,	0x4a7f, 0xc00d,		0x21, 0
	.dw 0x4ac0, 0xc00d,	0x4aff, 0xc00d,		0x21, 0
	.dw 0x4b40, 0xc00d,	0x4b7f, 0xc00d,		0x21, 0
	.dw 0x4bc0, 0xc00d,	0x4bff, 0xc00d,		0x21, 0
	.dw 0x4c40, 0xc00d,	0x4c7f, 0xc00d,		0x21, 0
	.dw 0x4cc0, 0xc00d,	0x4cff, 0xc00d,		0x21, 0
	.dw 0x4d40, 0xc00d,	0x4d7f, 0xc00d,		0x21, 0
	.dw 0x4dc0, 0xc00d,	0x4dff, 0xc00d,		0x21, 0
	.dw 0x4e40, 0xc00d,	0x4e7f, 0xc00d,		0x21, 0
	.dw 0x4ec0, 0xc00d,	0x4eff, 0xc00d,		0x21, 0
	.dw 0x4f40, 0xc00d,	0x4f7f, 0xc00d,		0x21, 0
	.dw 0x4fc0, 0xc00d,	0x4fff, 0xc00d,		0x21, 0
	.dw 0x5040, 0xc00d,	0x507f, 0xc00d,		0x21, 0
	.dw 0x50c0, 0xc00d,	0x50ff, 0xc00d,		0x21, 0
	.dw 0x5140, 0xc00d,	0x517f, 0xc00d,		0x21, 0
	.dw 0x51c0, 0xc00d,	0x51ff, 0xc00d,		0x21, 0
	.dw 0x5240, 0xc00d,	0x527f, 0xc00d,		0x21, 0
	.dw 0x52c0, 0xc00d,	0x52ff, 0xc00d,		0x21, 0
	.dw 0x5340, 0xc00d,	0x537f, 0xc00d,		0x21, 0
	.dw 0x53c0, 0xc00d,	0x53ff, 0xc00d,		0x21, 0
	.dw 0x5440, 0xc00d,	0x547f, 0xc00d,		0x21, 0
	.dw 0x54c0, 0xc00d,	0x54ff, 0xc00d,		0x21, 0
	.dw 0x5540, 0xc00d,	0x557f, 0xc00d,		0x21, 0
	.dw 0x55c0, 0xc00d,	0x55ff, 0xc00d,		0x21, 0
	.dw 0x5640, 0xc00d,	0x567f, 0xc00d,		0x21, 0
	.dw 0x56c0, 0xc00d,	0x56ff, 0xc00d,		0x21, 0
	.dw 0x5740, 0xc00d,	0x577f, 0xc00d,		0x21, 0
	.dw 0x57c0, 0xc00d,	0x57ff, 0xc00d,		0x21, 0
	.dw 0x5840, 0xc00d,	0x587f, 0xc00d,		0x21, 0
	.dw 0x58c0, 0xc00d,	0x58ff, 0xc00d,		0x21, 0
	.dw 0x5940, 0xc00d,	0x597f, 0xc00d,		0x21, 0
	.dw 0x59c0, 0xc00d,	0x5fff, 0xc00d,		0x21, 0
	.dw 0x6040, 0xc00d,	0x607f, 0xc00d,		0x21, 0
	.dw 0x60c0, 0xc00d,	0x60ff, 0xc00d,		0x21, 0
	.dw 0x6140, 0xc00d,	0x617f, 0xc00d,		0x21, 0
	.dw 0x61c0, 0xc00d,	0x61ff, 0xc00d,		0x21, 0
	.dw 0x6240, 0xc00d,	0x627f, 0xc00d,		0x21, 0
	.dw 0x62c0, 0xc00d,	0x62ff, 0xc00d,		0x21, 0
	.dw 0x6340, 0xc00d,	0x637f, 0xc00d,		0x21, 0
	.dw 0x63c0, 0xc00d,	0x63ff, 0xc00d,		0x21, 0
	.dw 0x6440, 0xc00d,	0x647f, 0xc00d,		0x21, 0
	.dw 0x64c0, 0xc00d,	0x64ff, 0xc00d,		0x21, 0
	.dw 0x6540, 0xc00d,	0x657f, 0xc00d,		0x21, 0
	.dw 0x65c0, 0xc00d,	0x65ff, 0xc00d,		0x21, 0
	.dw 0x6640, 0xc00d,	0x667f, 0xc00d,		0x21, 0
	.dw 0x66c0, 0xc00d,	0x66ff, 0xc00d,		0x21, 0
	.dw 0x6740, 0xc00d,	0x677f, 0xc00d,		0x21, 0
	.dw 0x67c0, 0xc00d,	0x67ff, 0xc00d,		0x21, 0
	.dw 0x6840, 0xc00d,	0x687f, 0xc00d,		0x21, 0
	.dw 0x68c0, 0xc00d,	0x68ff, 0xc00d,		0x21, 0
	.dw 0x6940, 0xc00d,	0x697f, 0xc00d,		0x21, 0
	.dw 0x69c0, 0xc00d,	0x69ff, 0xc00d,		0x21, 0
	.dw 0x6a40, 0xc00d,	0x6a7f, 0xc00d,		0x21, 0
	.dw 0x6ac0, 0xc00d,	0x6aff, 0xc00d,		0x21, 0
	.dw 0x6b40, 0xc00d,	0x6b7f, 0xc00d,		0x21, 0
	.dw 0x6bc0, 0xc00d,	0x6bff, 0xc00d,		0x21, 0
	.dw 0x6c40, 0xc00d,	0x6c7f, 0xc00d,		0x21, 0
	.dw 0x6cc0, 0xc00d,	0x6cff, 0xc00d,		0x21, 0
	.dw 0x6d40, 0xc00d,	0x6d7f, 0xc00d,		0x21, 0
	.dw 0x6dc0, 0xc00d,	0x6dff, 0xc00d,		0x21, 0
	.dw 0x6e40, 0xc00d,	0x6e7f, 0xc00d,		0x21, 0
	.dw 0x6ec0, 0xc00d,	0x6eff, 0xc00d,		0x21, 0
	.dw 0x6f40, 0xc00d,	0x6f7f, 0xc00d,		0x21, 0
	.dw 0x6fc0, 0xc00d,	0x6fff, 0xc00d,		0x21, 0
	.dw 0x7040, 0xc00d,	0x707f, 0xc00d,		0x21, 0
	.dw 0x70c0, 0xc00d,	0x70ff, 0xc00d,		0x21, 0
	.dw 0x7140, 0xc00d,	0x717f, 0xc00d,		0x21, 0
	.dw 0x71c0, 0xc00d,	0x71ff, 0xc00d,		0x21, 0
	.dw 0x7240, 0xc00d,	0x727f, 0xc00d,		0x21, 0
	.dw 0x72c0, 0xc00d,	0x72ff, 0xc00d,		0x21, 0
	.dw 0x7340, 0xc00d,	0x737f, 0xc00d,		0x21, 0
	.dw 0x73c0, 0xc00d,	0x73ff, 0xc00d,		0x21, 0
	.dw 0x7440, 0xc00d,	0x747f, 0xc00d,		0x21, 0
	.dw 0x74c0, 0xc00d,	0x74ff, 0xc00d,		0x21, 0
	.dw 0x7540, 0xc00d,	0x757f, 0xc00d,		0x21, 0
	.dw 0x75c0, 0xc00d,	0x75ff, 0xc00d,		0x21, 0
	.dw 0x7640, 0xc00d,	0x767f, 0xc00d,		0x21, 0
	.dw 0x76c0, 0xc00d,	0x76ff, 0xc00d,		0x21, 0
	.dw 0x7740, 0xc00d,	0x777f, 0xc00d,		0x21, 0
	.dw 0x77c0, 0xc00d,	0x77ff, 0xc00d,		0x21, 0
	.dw 0x7840, 0xc00d,	0x787f, 0xc00d,		0x21, 0
	.dw 0x78c0, 0xc00d,	0x78ff, 0xc00d,		0x21, 0
	.dw 0x7940, 0xc00d,	0x797f, 0xc00d,		0x21, 0
	.dw 0x79c0, 0xc00d,	0x7fff, 0xc00d,		0x21, 0
	.dw 0x8040, 0xc00d,	0x807f, 0xc00d,		0x21, 0
	.dw 0x80c0, 0xc00d,	0x80ff, 0xc00d,		0x21, 0
	.dw 0x8140, 0xc00d,	0x817f, 0xc00d,		0x21, 0
	.dw 0x81c0, 0xc00d,	0x81ff, 0xc00d,		0x21, 0
	.dw 0x8240, 0xc00d,	0x827f, 0xc00d,		0x21, 0
	.dw 0x82c0, 0xc00d,	0x82ff, 0xc00d,		0x21, 0
	.dw 0x8340, 0xc00d,	0x837f, 0xc00d,		0x21, 0
	.dw 0x83c0, 0xc00d,	0x83ff, 0xc00d,		0x21, 0
	.dw 0x8440, 0xc00d,	0x847f, 0xc00d,		0x21, 0
	.dw 0x84c0, 0xc00d,	0x84ff, 0xc00d,		0x21, 0
	.dw 0x8540, 0xc00d,	0x857f, 0xc00d,		0x21, 0
	.dw 0x85c0, 0xc00d,	0x85ff, 0xc00d,		0x21, 0
	.dw 0x8640, 0xc00d,	0x867f, 0xc00d,		0x21, 0
	.dw 0x86c0, 0xc00d,	0x86ff, 0xc00d,		0x21, 0
	.dw 0x8740, 0xc00d,	0x877f, 0xc00d,		0x21, 0
	.dw 0x87c0, 0xc00d,	0x87ff, 0xc00d,		0x21, 0
	.dw 0x8840, 0xc00d,	0x887f, 0xc00d,		0x21, 0
	.dw 0x88c0, 0xc00d,	0x88ff, 0xc00d,		0x21, 0
	.dw 0x8940, 0xc00d,	0x897f, 0xc00d,		0x21, 0
	.dw 0x89c0, 0xc00d,	0x89ff, 0xc00d,		0x21, 0
	.dw 0x8a40, 0xc00d,	0x8a7f, 0xc00d,		0x21, 0
	.dw 0x8ac0, 0xc00d,	0x8aff, 0xc00d,		0x21, 0
	.dw 0x8b40, 0xc00d,	0x8b7f, 0xc00d,		0x21, 0
	.dw 0x8bc0, 0xc00d,	0x8bff, 0xc00d,		0x21, 0
	.dw 0x8c40, 0xc00d,	0x8c7f, 0xc00d,		0x21, 0
	.dw 0x8cc0, 0xc00d,	0x8cff, 0xc00d,		0x21, 0
	.dw 0x8d40, 0xc00d,	0x8d7f, 0xc00d,		0x21, 0
	.dw 0x8dc0, 0xc00d,	0x8dff, 0xc00d,		0x21, 0
	.dw 0x8e40, 0xc00d,	0x8e7f, 0xc00d,		0x21, 0
	.dw 0x8ec0, 0xc00d,	0x8eff, 0xc00d,		0x21, 0
	.dw 0x8f40, 0xc00d,	0x8f7f, 0xc00d,		0x21, 0
	.dw 0x8fc0, 0xc00d,	0x8fff, 0xc00d,		0x21, 0
	.dw 0x9040, 0xc00d,	0x907f, 0xc00d,		0x21, 0
	.dw 0x90c0, 0xc00d,	0x90ff, 0xc00d,		0x21, 0
	.dw 0x9140, 0xc00d,	0x917f, 0xc00d,		0x21, 0
	.dw 0x91c0, 0xc00d,	0x91ff, 0xc00d,		0x21, 0
	.dw 0x9240, 0xc00d,	0x927f, 0xc00d,		0x21, 0
	.dw 0x92c0, 0xc00d,	0x92ff, 0xc00d,		0x21, 0
	.dw 0x9340, 0xc00d,	0x937f, 0xc00d,		0x21, 0
	.dw 0x93c0, 0xc00d,	0x93ff, 0xc00d,		0x21, 0
	.dw 0x9440, 0xc00d,	0x947f, 0xc00d,		0x21, 0
	.dw 0x94c0, 0xc00d,	0x94ff, 0xc00d,		0x21, 0
	.dw 0x9540, 0xc00d,	0x957f, 0xc00d,		0x21, 0
	.dw 0x95c0, 0xc00d,	0x95ff, 0xc00d,		0x21, 0
	.dw 0x9640, 0xc00d,	0x967f, 0xc00d,		0x21, 0
	.dw 0x96c0, 0xc00d,	0x96ff, 0xc00d,		0x21, 0
	.dw 0x9740, 0xc00d,	0x977f, 0xc00d,		0x21, 0
	.dw 0x97c0, 0xc00d,	0x97ff, 0xc00d,		0x21, 0
	.dw 0x9840, 0xc00d,	0x987f, 0xc00d,		0x21, 0
	.dw 0x98c0, 0xc00d,	0x98ff, 0xc00d,		0x21, 0
	.dw 0x9940, 0xc00d,	0x997f, 0xc00d,		0x21, 0
	.dw 0x99c0, 0xc00d,	0x9fff, 0xc00d,		0x21, 0
	.dw 0xa040, 0xc00d,	0xa07f, 0xc00d,		0x21, 0
	.dw 0xa0c0, 0xc00d,	0xa0ff, 0xc00d,		0x21, 0
	.dw 0xa140, 0xc00d,	0xa17f, 0xc00d,		0x21, 0
	.dw 0xa1c0, 0xc00d,	0xa1ff, 0xc00d,		0x21, 0
	.dw 0xa240, 0xc00d,	0xa27f, 0xc00d,		0x21, 0
	.dw 0xa2c0, 0xc00d,	0xa2ff, 0xc00d,		0x21, 0
	.dw 0xa340, 0xc00d,	0xa37f, 0xc00d,		0x21, 0
	.dw 0xa3c0, 0xc00d,	0xa3ff, 0xc00d,		0x21, 0
	.dw 0xa440, 0xc00d,	0xa47f, 0xc00d,		0x21, 0
	.dw 0xa4c0, 0xc00d,	0xa4ff, 0xc00d,		0x21, 0
	.dw 0xa540, 0xc00d,	0xa57f, 0xc00d,		0x21, 0
	.dw 0xa5c0, 0xc00d,	0xa5ff, 0xc00d,		0x21, 0
	.dw 0xa640, 0xc00d,	0xa67f, 0xc00d,		0x21, 0
	.dw 0xa6c0, 0xc00d,	0xa6ff, 0xc00d,		0x21, 0
	.dw 0xa740, 0xc00d,	0xa77f, 0xc00d,		0x21, 0
	.dw 0xa7c0, 0xc00d,	0xa7ff, 0xc00d,		0x21, 0
	.dw 0xa840, 0xc00d,	0xa87f, 0xc00d,		0x21, 0
	.dw 0xa8c0, 0xc00d,	0xa8ff, 0xc00d,		0x21, 0
	.dw 0xa940, 0xc00d,	0xa97f, 0xc00d,		0x21, 0
	.dw 0xa9c0, 0xc00d,	0xa9ff, 0xc00d,		0x21, 0
	.dw 0xaa40, 0xc00d,	0xaa7f, 0xc00d,		0x21, 0
	.dw 0xaac0, 0xc00d,	0xaaff, 0xc00d,		0x21, 0
	.dw 0xab40, 0xc00d,	0xab7f, 0xc00d,		0x21, 0
	.dw 0xabc0, 0xc00d,	0xabff, 0xc00d,		0x21, 0
	.dw 0xac40, 0xc00d,	0xac7f, 0xc00d,		0x21, 0
	.dw 0xacc0, 0xc00d,	0xacff, 0xc00d,		0x21, 0
	.dw 0xad40, 0xc00d,	0xad7f, 0xc00d,		0x21, 0
	.dw 0xadc0, 0xc00d,	0xadff, 0xc00d,		0x21, 0
	.dw 0xae40, 0xc00d,	0xae7f, 0xc00d,		0x21, 0
	.dw 0xaec0, 0xc00d,	0xaeff, 0xc00d,		0x21, 0
	.dw 0xaf40, 0xc00d,	0xaf7f, 0xc00d,		0x21, 0
	.dw 0xafc0, 0xc00d,	0xafff, 0xc00d,		0x21, 0
	.dw 0xb040, 0xc00d,	0xb07f, 0xc00d,		0x21, 0
	.dw 0xb0c0, 0xc00d,	0xb0ff, 0xc00d,		0x21, 0
	.dw 0xb140, 0xc00d,	0xb17f, 0xc00d,		0x21, 0
	.dw 0xb1c0, 0xc00d,	0xb1ff, 0xc00d,		0x21, 0
	.dw 0xb240, 0xc00d,	0xb27f, 0xc00d,		0x21, 0
	.dw 0xb2c0, 0xc00d,	0xb2ff, 0xc00d,		0x21, 0
	.dw 0xb340, 0xc00d,	0xb37f, 0xc00d,		0x21, 0
	.dw 0xb3c0, 0xc00d,	0xb3ff, 0xc00d,		0x21, 0
	.dw 0xb440, 0xc00d,	0xb47f, 0xc00d,		0x21, 0
	.dw 0xb4c0, 0xc00d,	0xb4ff, 0xc00d,		0x21, 0
	.dw 0xb540, 0xc00d,	0xb57f, 0xc00d,		0x21, 0
	.dw 0xb5c0, 0xc00d,	0xb5ff, 0xc00d,		0x21, 0
	.dw 0xb640, 0xc00d,	0xb67f, 0xc00d,		0x21, 0
	.dw 0xb6c0, 0xc00d,	0xb6ff, 0xc00d,		0x21, 0
	.dw 0xb740, 0xc00d,	0xb77f, 0xc00d,		0x21, 0
	.dw 0xb7c0, 0xc00d,	0xb7ff, 0xc00d,		0x21, 0
	.dw 0xb840, 0xc00d,	0xb87f, 0xc00d,		0x21, 0
	.dw 0xb8c0, 0xc00d,	0xb8ff, 0xc00d,		0x21, 0
	.dw 0xb940, 0xc00d,	0xb97f, 0xc00d,		0x21, 0
	.dw 0xb9c0, 0xc00d,	0xbfff, 0xc00d,		0x21, 0
	.dw 0xc040, 0xc00d,	0xc07f, 0xc00d,		0x21, 0
	.dw 0xc0c0, 0xc00d,	0xc0ff, 0xc00d,		0x21, 0
	.dw 0xc140, 0xc00d,	0xc17f, 0xc00d,		0x21, 0
	.dw 0xc1c0, 0xc00d,	0xc1ff, 0xc00d,		0x21, 0
	.dw 0xc240, 0xc00d,	0xc27f, 0xc00d,		0x21, 0
	.dw 0xc2c0, 0xc00d,	0xc2ff, 0xc00d,		0x21, 0
	.dw 0xc340, 0xc00d,	0xc37f, 0xc00d,		0x21, 0
	.dw 0xc3c0, 0xc00d,	0xc3ff, 0xc00d,		0x21, 0
	.dw 0xc440, 0xc00d,	0xc47f, 0xc00d,		0x21, 0
	.dw 0xc4c0, 0xc00d,	0xc4ff, 0xc00d,		0x21, 0
	.dw 0xc540, 0xc00d,	0xc57f, 0xc00d,		0x21, 0
	.dw 0xc5c0, 0xc00d,	0xc5ff, 0xc00d,		0x21, 0
	.dw 0xc640, 0xc00d,	0xc67f, 0xc00d,		0x21, 0
	.dw 0xc6c0, 0xc00d,	0xc6ff, 0xc00d,		0x21, 0
	.dw 0xc740, 0xc00d,	0xc77f, 0xc00d,		0x21, 0
	.dw 0xc7c0, 0xc00d,	0xc7ff, 0xc00d,		0x21, 0
	.dw 0xc840, 0xc00d,	0xc87f, 0xc00d,		0x21, 0
	.dw 0xc8c0, 0xc00d,	0xc8ff, 0xc00d,		0x21, 0
	.dw 0xc940, 0xc00d,	0xc97f, 0xc00d,		0x21, 0
	.dw 0xc9c0, 0xc00d,	0xc9ff, 0xc00d,		0x21, 0
	.dw 0xca40, 0xc00d,	0xca7f, 0xc00d,		0x21, 0
	.dw 0xcac0, 0xc00d,	0xcaff, 0xc00d,		0x21, 0
	.dw 0xcb40, 0xc00d,	0xcb7f, 0xc00d,		0x21, 0
	.dw 0xcbc0, 0xc00d,	0xcbff, 0xc00d,		0x21, 0
	.dw 0xcc40, 0xc00d,	0xcc7f, 0xc00d,		0x21, 0
	.dw 0xccc0, 0xc00d,	0xccff, 0xc00d,		0x21, 0
	.dw 0xcd40, 0xc00d,	0xcd7f, 0xc00d,		0x21, 0
	.dw 0xcdc0, 0xc00d,	0xcdff, 0xc00d,		0x21, 0
	.dw 0xce40, 0xc00d,	0xce7f, 0xc00d,		0x21, 0
	.dw 0xcec0, 0xc00d,	0xceff, 0xc00d,		0x21, 0
	.dw 0xcf40, 0xc00d,	0xcf7f, 0xc00d,		0x21, 0
	.dw 0xcfc0, 0xc00d,	0xcfff, 0xc00d,		0x21, 0
	.dw 0xd040, 0xc00d,	0xd07f, 0xc00d,		0x21, 0
	.dw 0xd0c0, 0xc00d,	0xd0ff, 0xc00d,		0x21, 0
	.dw 0xd140, 0xc00d,	0xd17f, 0xc00d,		0x21, 0
	.dw 0xd1c0, 0xc00d,	0xd1ff, 0xc00d,		0x21, 0
	.dw 0xd240, 0xc00d,	0xd27f, 0xc00d,		0x21, 0
	.dw 0xd2c0, 0xc00d,	0xd2ff, 0xc00d,		0x21, 0
	.dw 0xd340, 0xc00d,	0xd37f, 0xc00d,		0x21, 0
	.dw 0xd3c0, 0xc00d,	0xd3ff, 0xc00d,		0x21, 0
	.dw 0xd440, 0xc00d,	0xd47f, 0xc00d,		0x21, 0
	.dw 0xd4c0, 0xc00d,	0xd4ff, 0xc00d,		0x21, 0
	.dw 0xd540, 0xc00d,	0xd57f, 0xc00d,		0x21, 0
	.dw 0xd5c0, 0xc00d,	0xd5ff, 0xc00d,		0x21, 0
	.dw 0xd640, 0xc00d,	0xd67f, 0xc00d,		0x21, 0
	.dw 0xd6c0, 0xc00d,	0xd6ff, 0xc00d,		0x21, 0
	.dw 0xd740, 0xc00d,	0xd77f, 0xc00d,		0x21, 0
	.dw 0xd7c0, 0xc00d,	0xd7ff, 0xc00d,		0x21, 0
	.dw 0xd840, 0xc00d,	0xd87f, 0xc00d,		0x21, 0
	.dw 0xd8c0, 0xc00d,	0xd8ff, 0xc00d,		0x21, 0
	.dw 0xd940, 0xc00d,	0xd97f, 0xc00d,		0x21, 0
	.dw 0xd9c0, 0xc00d,	0xdfff, 0xc00d,		0x21, 0
	.dw 0xe040, 0xc00d,	0xe07f, 0xc00d,		0x21, 0
	.dw 0xe0c0, 0xc00d,	0xe0ff, 0xc00d,		0x21, 0
	.dw 0xe140, 0xc00d,	0xe17f, 0xc00d,		0x21, 0
	.dw 0xe1c0, 0xc00d,	0xe1ff, 0xc00d,		0x21, 0
	.dw 0xe240, 0xc00d,	0xe27f, 0xc00d,		0x21, 0
	.dw 0xe2c0, 0xc00d,	0xe2ff, 0xc00d,		0x21, 0
	.dw 0xe340, 0xc00d,	0xe37f, 0xc00d,		0x21, 0
	.dw 0xe3c0, 0xc00d,	0xe3ff, 0xc00d,		0x21, 0
	.dw 0xe440, 0xc00d,	0xe47f, 0xc00d,		0x21, 0
	.dw 0xe4c0, 0xc00d,	0xe4ff, 0xc00d,		0x21, 0
	.dw 0xe540, 0xc00d,	0xe57f, 0xc00d,		0x21, 0
	.dw 0xe5c0, 0xc00d,	0xe5ff, 0xc00d,		0x21, 0
	.dw 0xe640, 0xc00d,	0xe67f, 0xc00d,		0x21, 0
	.dw 0xe6c0, 0xc00d,	0xe6ff, 0xc00d,		0x21, 0
	.dw 0xe740, 0xc00d,	0xe77f, 0xc00d,		0x21, 0
	.dw 0xe7c0, 0xc00d,	0xe7ff, 0xc00d,		0x21, 0
	.dw 0xe840, 0xc00d,	0xe87f, 0xc00d,		0x21, 0
	.dw 0xe8c0, 0xc00d,	0xe8ff, 0xc00d,		0x21, 0
	.dw 0xe940, 0xc00d,	0xe97f, 0xc00d,		0x21, 0
	.dw 0xe9c0, 0xc00d,	0xe9ff, 0xc00d,		0x21, 0
	.dw 0xea40, 0xc00d,	0xea7f, 0xc00d,		0x21, 0
	.dw 0xeac0, 0xc00d,	0xeaff, 0xc00d,		0x21, 0
	.dw 0xeb40, 0xc00d,	0xeb7f, 0xc00d,		0x21, 0
	.dw 0xebc0, 0xc00d,	0xebff, 0xc00d,		0x21, 0
	.dw 0xec40, 0xc00d,	0xec7f, 0xc00d,		0x21, 0
	.dw 0xecc0, 0xc00d,	0xecff, 0xc00d,		0x21, 0
	.dw 0xed40, 0xc00d,	0xed7f, 0xc00d,		0x21, 0
	.dw 0xedc0, 0xc00d,	0xedff, 0xc00d,		0x21, 0
	.dw 0xee40, 0xc00d,	0xee7f, 0xc00d,		0x21, 0
	.dw 0xeec0, 0xc00d,	0xeeff, 0xc00d,		0x21, 0
	.dw 0xef40, 0xc00d,	0xef7f, 0xc00d,		0x21, 0
	.dw 0xefc0, 0xc00d,	0xefff, 0xc00d,		0x21, 0
	.dw 0xf040, 0xc00d,	0xf07f, 0xc00d,		0x21, 0
	.dw 0xf0c0, 0xc00d,	0xf0ff, 0xc00d,		0x21, 0
	.dw 0xf140, 0xc00d,	0xf17f, 0xc00d,		0x21, 0
	.dw 0xf1c0, 0xc00d,	0xf1ff, 0xc00d,		0x21, 0
	.dw 0xf240, 0xc00d,	0xf27f, 0xc00d,		0x21, 0
	.dw 0xf2c0, 0xc00d,	0xf2ff, 0xc00d,		0x21, 0
	.dw 0xf340, 0xc00d,	0xf37f, 0xc00d,		0x21, 0
	.dw 0xf3c0, 0xc00d,	0xf3ff, 0xc00d,		0x21, 0
	.dw 0xf440, 0xc00d,	0xf47f, 0xc00d,		0x21, 0
	.dw 0xf4c0, 0xc00d,	0xf4ff, 0xc00d,		0x21, 0
	.dw 0xf540, 0xc00d,	0xf57f, 0xc00d,		0x21, 0
	.dw 0xf5c0, 0xc00d,	0xf5ff, 0xc00d,		0x21, 0
	.dw 0xf640, 0xc00d,	0xf67f, 0xc00d,		0x21, 0
	.dw 0xf6c0, 0xc00d,	0xf6ff, 0xc00d,		0x21, 0
	.dw 0xf740, 0xc00d,	0xf77f, 0xc00d,		0x21, 0
	.dw 0xf7c0, 0xc00d,	0xf7ff, 0xc00d,		0x21, 0
	.dw 0xf840, 0xc00d,	0xf87f, 0xc00d,		0x21, 0
	.dw 0xf8c0, 0xc00d,	0xf8ff, 0xc00d,		0x21, 0
	.dw 0xf940, 0xc00d,	0xf97f, 0xc00d,		0x21, 0
	.dw 0xf9c0, 0xc00d,	0xffff, 0xc00d,		0x21, 0
	.dw 0x0040, 0xc00e,	0x007f, 0xc00e,		0x21, 0
	.dw 0x00c0, 0xc00e,	0x00ff, 0xc00e,		0x21, 0
	.dw 0x0140, 0xc00e,	0x017f, 0xc00e,		0x21, 0
	.dw 0x01c0, 0xc00e,	0x01ff, 0xc00e,		0x21, 0
	.dw 0x0240, 0xc00e,	0x027f, 0xc00e,		0x21, 0
	.dw 0x02c0, 0xc00e,	0x02ff, 0xc00e,		0x21, 0
	.dw 0x0340, 0xc00e,	0x037f, 0xc00e,		0x21, 0
	.dw 0x03c0, 0xc00e,	0x03ff, 0xc00e,		0x21, 0
	.dw 0x0440, 0xc00e,	0x047f, 0xc00e,		0x21, 0
	.dw 0x04c0, 0xc00e,	0x04ff, 0xc00e,		0x21, 0
	.dw 0x0540, 0xc00e,	0x057f, 0xc00e,		0x21, 0
	.dw 0x05c0, 0xc00e,	0x05ff, 0xc00e,		0x21, 0
	.dw 0x0640, 0xc00e,	0x067f, 0xc00e,		0x21, 0
	.dw 0x06c0, 0xc00e,	0x06ff, 0xc00e,		0x21, 0
	.dw 0x0740, 0xc00e,	0x077f, 0xc00e,		0x21, 0
	.dw 0x07c0, 0xc00e,	0x07ff, 0xc00e,		0x21, 0
	.dw 0x0840, 0xc00e,	0x087f, 0xc00e,		0x21, 0
	.dw 0x08c0, 0xc00e,	0x08ff, 0xc00e,		0x21, 0
	.dw 0x0940, 0xc00e,	0x097f, 0xc00e,		0x21, 0
	.dw 0x09c0, 0xc00e,	0x09ff, 0xc00e,		0x21, 0
	.dw 0x0a40, 0xc00e,	0x0a7f, 0xc00e,		0x21, 0
	.dw 0x0ac0, 0xc00e,	0x0aff, 0xc00e,		0x21, 0
	.dw 0x0b40, 0xc00e,	0x0b7f, 0xc00e,		0x21, 0
	.dw 0x0bc0, 0xc00e,	0x0bff, 0xc00e,		0x21, 0
	.dw 0x0c40, 0xc00e,	0x0c7f, 0xc00e,		0x21, 0
	.dw 0x0cc0, 0xc00e,	0x0cff, 0xc00e,		0x21, 0
	.dw 0x0d40, 0xc00e,	0x0d7f, 0xc00e,		0x21, 0
	.dw 0x0dc0, 0xc00e,	0x0dff, 0xc00e,		0x21, 0
	.dw 0x0e40, 0xc00e,	0x0e7f, 0xc00e,		0x21, 0
	.dw 0x0ec0, 0xc00e,	0x0eff, 0xc00e,		0x21, 0
	.dw 0x0f40, 0xc00e,	0x0f7f, 0xc00e,		0x21, 0
	.dw 0x0fc0, 0xc00e,	0x0fff, 0xc00e,		0x21, 0
	.dw 0x1040, 0xc00e,	0x107f, 0xc00e,		0x21, 0
	.dw 0x10c0, 0xc00e,	0x10ff, 0xc00e,		0x21, 0
	.dw 0x1140, 0xc00e,	0x117f, 0xc00e,		0x21, 0
	.dw 0x11c0, 0xc00e,	0x11ff, 0xc00e,		0x21, 0
	.dw 0x1240, 0xc00e,	0x127f, 0xc00e,		0x21, 0
	.dw 0x12c0, 0xc00e,	0x12ff, 0xc00e,		0x21, 0
	.dw 0x1340, 0xc00e,	0x137f, 0xc00e,		0x21, 0
	.dw 0x13c0, 0xc00e,	0x13ff, 0xc00e,		0x21, 0
	.dw 0x1440, 0xc00e,	0x147f, 0xc00e,		0x21, 0
	.dw 0x14c0, 0xc00e,	0x14ff, 0xc00e,		0x21, 0
	.dw 0x1540, 0xc00e,	0x157f, 0xc00e,		0x21, 0
	.dw 0x15c0, 0xc00e,	0x15ff, 0xc00e,		0x21, 0
	.dw 0x1640, 0xc00e,	0x167f, 0xc00e,		0x21, 0
	.dw 0x16c0, 0xc00e,	0x16ff, 0xc00e,		0x21, 0
	.dw 0x1740, 0xc00e,	0x177f, 0xc00e,		0x21, 0
	.dw 0x17c0, 0xc00e,	0x17ff, 0xc00e,		0x21, 0
	.dw 0x1840, 0xc00e,	0x187f, 0xc00e,		0x21, 0
	.dw 0x18c0, 0xc00e,	0x18ff, 0xc00e,		0x21, 0
	.dw 0x1940, 0xc00e,	0x197f, 0xc00e,		0x21, 0
	.dw 0x19c0, 0xc00e,	0x1fff, 0xc00e,		0x21, 0
	.dw 0x2040, 0xc00e,	0x207f, 0xc00e,		0x21, 0
	.dw 0x20c0, 0xc00e,	0x20ff, 0xc00e,		0x21, 0
	.dw 0x2140, 0xc00e,	0x217f, 0xc00e,		0x21, 0
	.dw 0x21c0, 0xc00e,	0x21ff, 0xc00e,		0x21, 0
	.dw 0x2240, 0xc00e,	0x227f, 0xc00e,		0x21, 0
	.dw 0x22c0, 0xc00e,	0x22ff, 0xc00e,		0x21, 0
	.dw 0x2340, 0xc00e,	0x237f, 0xc00e,		0x21, 0
	.dw 0x23c0, 0xc00e,	0x23ff, 0xc00e,		0x21, 0
	.dw 0x2440, 0xc00e,	0x247f, 0xc00e,		0x21, 0
	.dw 0x24c0, 0xc00e,	0x24ff, 0xc00e,		0x21, 0
	.dw 0x2540, 0xc00e,	0x257f, 0xc00e,		0x21, 0
	.dw 0x25c0, 0xc00e,	0x25ff, 0xc00e,		0x21, 0
	.dw 0x2640, 0xc00e,	0x267f, 0xc00e,		0x21, 0
	.dw 0x26c0, 0xc00e,	0x26ff, 0xc00e,		0x21, 0
	.dw 0x2740, 0xc00e,	0x277f, 0xc00e,		0x21, 0
	.dw 0x27c0, 0xc00e,	0x27ff, 0xc00e,		0x21, 0
	.dw 0x2840, 0xc00e,	0x287f, 0xc00e,		0x21, 0
	.dw 0x28c0, 0xc00e,	0x28ff, 0xc00e,		0x21, 0
	.dw 0x2940, 0xc00e,	0x297f, 0xc00e,		0x21, 0
	.dw 0x29c0, 0xc00e,	0x29ff, 0xc00e,		0x21, 0
	.dw 0x2a40, 0xc00e,	0x2a7f, 0xc00e,		0x21, 0
	.dw 0x2ac0, 0xc00e,	0x2aff, 0xc00e,		0x21, 0
	.dw 0x2b40, 0xc00e,	0x2b7f, 0xc00e,		0x21, 0
	.dw 0x2bc0, 0xc00e,	0x2bff, 0xc00e,		0x21, 0
	.dw 0x2c40, 0xc00e,	0x2c7f, 0xc00e,		0x21, 0
	.dw 0x2cc0, 0xc00e,	0x2cff, 0xc00e,		0x21, 0
	.dw 0x2d40, 0xc00e,	0x2d7f, 0xc00e,		0x21, 0
	.dw 0x2dc0, 0xc00e,	0x2dff, 0xc00e,		0x21, 0
	.dw 0x2e40, 0xc00e,	0x2e7f, 0xc00e,		0x21, 0
	.dw 0x2ec0, 0xc00e,	0x2eff, 0xc00e,		0x21, 0
	.dw 0x2f40, 0xc00e,	0x2f7f, 0xc00e,		0x21, 0
	.dw 0x2fc0, 0xc00e,	0x2fff, 0xc00e,		0x21, 0
	.dw 0x3040, 0xc00e,	0x307f, 0xc00e,		0x21, 0
	.dw 0x30c0, 0xc00e,	0x30ff, 0xc00e,		0x21, 0
	.dw 0x3140, 0xc00e,	0x317f, 0xc00e,		0x21, 0
	.dw 0x31c0, 0xc00e,	0x31ff, 0xc00e,		0x21, 0
	.dw 0x3240, 0xc00e,	0x327f, 0xc00e,		0x21, 0
	.dw 0x32c0, 0xc00e,	0x32ff, 0xc00e,		0x21, 0
	.dw 0x3340, 0xc00e,	0x337f, 0xc00e,		0x21, 0
	.dw 0x33c0, 0xc00e,	0x33ff, 0xc00e,		0x21, 0
	.dw 0x3440, 0xc00e,	0x347f, 0xc00e,		0x21, 0
	.dw 0x34c0, 0xc00e,	0x34ff, 0xc00e,		0x21, 0
	.dw 0x3540, 0xc00e,	0x357f, 0xc00e,		0x21, 0
	.dw 0x35c0, 0xc00e,	0x35ff, 0xc00e,		0x21, 0
	.dw 0x3640, 0xc00e,	0x367f, 0xc00e,		0x21, 0
	.dw 0x36c0, 0xc00e,	0x36ff, 0xc00e,		0x21, 0
	.dw 0x3740, 0xc00e,	0x377f, 0xc00e,		0x21, 0
	.dw 0x37c0, 0xc00e,	0x37ff, 0xc00e,		0x21, 0
	.dw 0x3840, 0xc00e,	0x387f, 0xc00e,		0x21, 0
	.dw 0x38c0, 0xc00e,	0x38ff, 0xc00e,		0x21, 0
	.dw 0x3940, 0xc00e,	0x397f, 0xc00e,		0x21, 0
	.dw 0x39c0, 0xc00e,	0x3fff, 0xc00e,		0x21, 0
	.dw 0x4040, 0xc00e,	0x407f, 0xc00e,		0x21, 0
	.dw 0x40c0, 0xc00e,	0x40ff, 0xc00e,		0x21, 0
	.dw 0x4140, 0xc00e,	0x417f, 0xc00e,		0x21, 0
	.dw 0x41c0, 0xc00e,	0x41ff, 0xc00e,		0x21, 0
	.dw 0x4240, 0xc00e,	0x427f, 0xc00e,		0x21, 0
	.dw 0x42c0, 0xc00e,	0x42ff, 0xc00e,		0x21, 0
	.dw 0x4340, 0xc00e,	0x437f, 0xc00e,		0x21, 0
	.dw 0x43c0, 0xc00e,	0x43ff, 0xc00e,		0x21, 0
	.dw 0x4440, 0xc00e,	0x447f, 0xc00e,		0x21, 0
	.dw 0x44c0, 0xc00e,	0x44ff, 0xc00e,		0x21, 0
	.dw 0x4540, 0xc00e,	0x457f, 0xc00e,		0x21, 0
	.dw 0x45c0, 0xc00e,	0x45ff, 0xc00e,		0x21, 0
	.dw 0x4640, 0xc00e,	0x467f, 0xc00e,		0x21, 0
	.dw 0x46c0, 0xc00e,	0x46ff, 0xc00e,		0x21, 0
	.dw 0x4740, 0xc00e,	0x477f, 0xc00e,		0x21, 0
	.dw 0x47c0, 0xc00e,	0x47ff, 0xc00e,		0x21, 0
	.dw 0x4840, 0xc00e,	0x487f, 0xc00e,		0x21, 0
	.dw 0x48c0, 0xc00e,	0x48ff, 0xc00e,		0x21, 0
	.dw 0x4940, 0xc00e,	0x497f, 0xc00e,		0x21, 0
	.dw 0x49c0, 0xc00e,	0x49ff, 0xc00e,		0x21, 0
	.dw 0x4a40, 0xc00e,	0x4a7f, 0xc00e,		0x21, 0
	.dw 0x4ac0, 0xc00e,	0x4aff, 0xc00e,		0x21, 0
	.dw 0x4b40, 0xc00e,	0x4b7f, 0xc00e,		0x21, 0
	.dw 0x4bc0, 0xc00e,	0x4bff, 0xc00e,		0x21, 0
	.dw 0x4c40, 0xc00e,	0x4c7f, 0xc00e,		0x21, 0
	.dw 0x4cc0, 0xc00e,	0x4cff, 0xc00e,		0x21, 0
	.dw 0x4d40, 0xc00e,	0x4d7f, 0xc00e,		0x21, 0
	.dw 0x4dc0, 0xc00e,	0x4dff, 0xc00e,		0x21, 0
	.dw 0x4e40, 0xc00e,	0x4e7f, 0xc00e,		0x21, 0
	.dw 0x4ec0, 0xc00e,	0x4eff, 0xc00e,		0x21, 0
	.dw 0x4f40, 0xc00e,	0x4f7f, 0xc00e,		0x21, 0
	.dw 0x4fc0, 0xc00e,	0x4fff, 0xc00e,		0x21, 0
	.dw 0x5040, 0xc00e,	0x507f, 0xc00e,		0x21, 0
	.dw 0x50c0, 0xc00e,	0x50ff, 0xc00e,		0x21, 0
	.dw 0x5140, 0xc00e,	0x517f, 0xc00e,		0x21, 0
	.dw 0x51c0, 0xc00e,	0x51ff, 0xc00e,		0x21, 0
	.dw 0x5240, 0xc00e,	0x527f, 0xc00e,		0x21, 0
	.dw 0x52c0, 0xc00e,	0x52ff, 0xc00e,		0x21, 0
	.dw 0x5340, 0xc00e,	0x537f, 0xc00e,		0x21, 0
	.dw 0x53c0, 0xc00e,	0x53ff, 0xc00e,		0x21, 0
	.dw 0x5440, 0xc00e,	0x547f, 0xc00e,		0x21, 0
	.dw 0x54c0, 0xc00e,	0x54ff, 0xc00e,		0x21, 0
	.dw 0x5540, 0xc00e,	0x557f, 0xc00e,		0x21, 0
	.dw 0x55c0, 0xc00e,	0x55ff, 0xc00e,		0x21, 0
	.dw 0x5640, 0xc00e,	0x567f, 0xc00e,		0x21, 0
	.dw 0x56c0, 0xc00e,	0x56ff, 0xc00e,		0x21, 0
	.dw 0x5740, 0xc00e,	0x577f, 0xc00e,		0x21, 0
	.dw 0x57c0, 0xc00e,	0x57ff, 0xc00e,		0x21, 0
	.dw 0x5840, 0xc00e,	0x587f, 0xc00e,		0x21, 0
	.dw 0x58c0, 0xc00e,	0x58ff, 0xc00e,		0x21, 0
	.dw 0x5940, 0xc00e,	0x597f, 0xc00e,		0x21, 0
	.dw 0x59c0, 0xc00e,	0x5fff, 0xc00e,		0x21, 0
	.dw 0x6040, 0xc00e,	0x607f, 0xc00e,		0x21, 0
	.dw 0x60c0, 0xc00e,	0x60ff, 0xc00e,		0x21, 0
	.dw 0x6140, 0xc00e,	0x617f, 0xc00e,		0x21, 0
	.dw 0x61c0, 0xc00e,	0x61ff, 0xc00e,		0x21, 0
	.dw 0x6240, 0xc00e,	0x627f, 0xc00e,		0x21, 0
	.dw 0x62c0, 0xc00e,	0x62ff, 0xc00e,		0x21, 0
	.dw 0x6340, 0xc00e,	0x637f, 0xc00e,		0x21, 0
	.dw 0x63c0, 0xc00e,	0x63ff, 0xc00e,		0x21, 0
	.dw 0x6440, 0xc00e,	0x647f, 0xc00e,		0x21, 0
	.dw 0x64c0, 0xc00e,	0x64ff, 0xc00e,		0x21, 0
	.dw 0x6540, 0xc00e,	0x657f, 0xc00e,		0x21, 0
	.dw 0x65c0, 0xc00e,	0x65ff, 0xc00e,		0x21, 0
	.dw 0x6640, 0xc00e,	0x667f, 0xc00e,		0x21, 0
	.dw 0x66c0, 0xc00e,	0x66ff, 0xc00e,		0x21, 0
	.dw 0x6740, 0xc00e,	0x677f, 0xc00e,		0x21, 0
	.dw 0x67c0, 0xc00e,	0x67ff, 0xc00e,		0x21, 0
	.dw 0x6840, 0xc00e,	0x687f, 0xc00e,		0x21, 0
	.dw 0x68c0, 0xc00e,	0x68ff, 0xc00e,		0x21, 0
	.dw 0x6940, 0xc00e,	0x697f, 0xc00e,		0x21, 0
	.dw 0x69c0, 0xc00e,	0x69ff, 0xc00e,		0x21, 0
	.dw 0x6a40, 0xc00e,	0x6a7f, 0xc00e,		0x21, 0
	.dw 0x6ac0, 0xc00e,	0x6aff, 0xc00e,		0x21, 0
	.dw 0x6b40, 0xc00e,	0x6b7f, 0xc00e,		0x21, 0
	.dw 0x6bc0, 0xc00e,	0x6bff, 0xc00e,		0x21, 0
	.dw 0x6c40, 0xc00e,	0x6c7f, 0xc00e,		0x21, 0
	.dw 0x6cc0, 0xc00e,	0x6cff, 0xc00e,		0x21, 0
	.dw 0x6d40, 0xc00e,	0x6d7f, 0xc00e,		0x21, 0
	.dw 0x6dc0, 0xc00e,	0x6dff, 0xc00e,		0x21, 0
	.dw 0x6e40, 0xc00e,	0x6e7f, 0xc00e,		0x21, 0
	.dw 0x6ec0, 0xc00e,	0x6eff, 0xc00e,		0x21, 0
	.dw 0x6f40, 0xc00e,	0x6f7f, 0xc00e,		0x21, 0
	.dw 0x6fc0, 0xc00e,	0x6fff, 0xc00e,		0x21, 0
	.dw 0x7040, 0xc00e,	0x707f, 0xc00e,		0x21, 0
	.dw 0x70c0, 0xc00e,	0x70ff, 0xc00e,		0x21, 0
	.dw 0x7140, 0xc00e,	0x717f, 0xc00e,		0x21, 0
	.dw 0x71c0, 0xc00e,	0x71ff, 0xc00e,		0x21, 0
	.dw 0x7240, 0xc00e,	0x727f, 0xc00e,		0x21, 0
	.dw 0x72c0, 0xc00e,	0x72ff, 0xc00e,		0x21, 0
	.dw 0x7340, 0xc00e,	0x737f, 0xc00e,		0x21, 0
	.dw 0x73c0, 0xc00e,	0x73ff, 0xc00e,		0x21, 0
	.dw 0x7440, 0xc00e,	0x747f, 0xc00e,		0x21, 0
	.dw 0x74c0, 0xc00e,	0x74ff, 0xc00e,		0x21, 0
	.dw 0x7540, 0xc00e,	0x757f, 0xc00e,		0x21, 0
	.dw 0x75c0, 0xc00e,	0x75ff, 0xc00e,		0x21, 0
	.dw 0x7640, 0xc00e,	0x767f, 0xc00e,		0x21, 0
	.dw 0x76c0, 0xc00e,	0x76ff, 0xc00e,		0x21, 0
	.dw 0x7740, 0xc00e,	0x777f, 0xc00e,		0x21, 0
	.dw 0x77c0, 0xc00e,	0x77ff, 0xc00e,		0x21, 0
	.dw 0x7840, 0xc00e,	0x787f, 0xc00e,		0x21, 0
	.dw 0x78c0, 0xc00e,	0x78ff, 0xc00e,		0x21, 0
	.dw 0x7940, 0xc00e,	0x797f, 0xc00e,		0x21, 0
	.dw 0x79c0, 0xc00e,	0x7fff, 0xc00e,		0x21, 0
	.dw 0x8040, 0xc00e,	0x807f, 0xc00e,		0x21, 0
	.dw 0x80c0, 0xc00e,	0x80ff, 0xc00e,		0x21, 0
	.dw 0x8140, 0xc00e,	0x817f, 0xc00e,		0x21, 0
	.dw 0x81c0, 0xc00e,	0x81ff, 0xc00e,		0x21, 0
	.dw 0x8240, 0xc00e,	0x827f, 0xc00e,		0x21, 0
	.dw 0x82c0, 0xc00e,	0x82ff, 0xc00e,		0x21, 0
	.dw 0x8340, 0xc00e,	0x837f, 0xc00e,		0x21, 0
	.dw 0x83c0, 0xc00e,	0x83ff, 0xc00e,		0x21, 0
	.dw 0x8440, 0xc00e,	0x847f, 0xc00e,		0x21, 0
	.dw 0x84c0, 0xc00e,	0x84ff, 0xc00e,		0x21, 0
	.dw 0x8540, 0xc00e,	0x857f, 0xc00e,		0x21, 0
	.dw 0x85c0, 0xc00e,	0x85ff, 0xc00e,		0x21, 0
	.dw 0x8640, 0xc00e,	0x867f, 0xc00e,		0x21, 0
	.dw 0x86c0, 0xc00e,	0x86ff, 0xc00e,		0x21, 0
	.dw 0x8740, 0xc00e,	0x877f, 0xc00e,		0x21, 0
	.dw 0x87c0, 0xc00e,	0x87ff, 0xc00e,		0x21, 0
	.dw 0x8840, 0xc00e,	0x887f, 0xc00e,		0x21, 0
	.dw 0x88c0, 0xc00e,	0x88ff, 0xc00e,		0x21, 0
	.dw 0x8940, 0xc00e,	0x897f, 0xc00e,		0x21, 0
	.dw 0x89c0, 0xc00e,	0x89ff, 0xc00e,		0x21, 0
	.dw 0x8a40, 0xc00e,	0x8a7f, 0xc00e,		0x21, 0
	.dw 0x8ac0, 0xc00e,	0x8aff, 0xc00e,		0x21, 0
	.dw 0x8b40, 0xc00e,	0x8b7f, 0xc00e,		0x21, 0
	.dw 0x8bc0, 0xc00e,	0x8bff, 0xc00e,		0x21, 0
	.dw 0x8c40, 0xc00e,	0x8c7f, 0xc00e,		0x21, 0
	.dw 0x8cc0, 0xc00e,	0x8cff, 0xc00e,		0x21, 0
	.dw 0x8d40, 0xc00e,	0x8d7f, 0xc00e,		0x21, 0
	.dw 0x8dc0, 0xc00e,	0x8dff, 0xc00e,		0x21, 0
	.dw 0x8e40, 0xc00e,	0x8e7f, 0xc00e,		0x21, 0
	.dw 0x8ec0, 0xc00e,	0x8eff, 0xc00e,		0x21, 0
	.dw 0x8f40, 0xc00e,	0x8f7f, 0xc00e,		0x21, 0
	.dw 0x8fc0, 0xc00e,	0x8fff, 0xc00e,		0x21, 0
	.dw 0x9040, 0xc00e,	0x907f, 0xc00e,		0x21, 0
	.dw 0x90c0, 0xc00e,	0x90ff, 0xc00e,		0x21, 0
	.dw 0x9140, 0xc00e,	0x917f, 0xc00e,		0x21, 0
	.dw 0x91c0, 0xc00e,	0x91ff, 0xc00e,		0x21, 0
	.dw 0x9240, 0xc00e,	0x927f, 0xc00e,		0x21, 0
	.dw 0x92c0, 0xc00e,	0x92ff, 0xc00e,		0x21, 0
	.dw 0x9340, 0xc00e,	0x937f, 0xc00e,		0x21, 0
	.dw 0x93c0, 0xc00e,	0x93ff, 0xc00e,		0x21, 0
	.dw 0x9440, 0xc00e,	0x947f, 0xc00e,		0x21, 0
	.dw 0x94c0, 0xc00e,	0x94ff, 0xc00e,		0x21, 0
	.dw 0x9540, 0xc00e,	0x957f, 0xc00e,		0x21, 0
	.dw 0x95c0, 0xc00e,	0x95ff, 0xc00e,		0x21, 0
	.dw 0x9640, 0xc00e,	0x967f, 0xc00e,		0x21, 0
	.dw 0x96c0, 0xc00e,	0x96ff, 0xc00e,		0x21, 0
	.dw 0x9740, 0xc00e,	0x977f, 0xc00e,		0x21, 0
	.dw 0x97c0, 0xc00e,	0x97ff, 0xc00e,		0x21, 0
	.dw 0x9840, 0xc00e,	0x987f, 0xc00e,		0x21, 0
	.dw 0x98c0, 0xc00e,	0x98ff, 0xc00e,		0x21, 0
	.dw 0x9940, 0xc00e,	0x997f, 0xc00e,		0x21, 0
	.dw 0x99c0, 0xc00e,	0x9fff, 0xc00e,		0x21, 0
	.dw 0xa040, 0xc00e,	0xa07f, 0xc00e,		0x21, 0
	.dw 0xa0c0, 0xc00e,	0xa0ff, 0xc00e,		0x21, 0
	.dw 0xa140, 0xc00e,	0xa17f, 0xc00e,		0x21, 0
	.dw 0xa1c0, 0xc00e,	0xa1ff, 0xc00e,		0x21, 0
	.dw 0xa240, 0xc00e,	0xa27f, 0xc00e,		0x21, 0
	.dw 0xa2c0, 0xc00e,	0xa2ff, 0xc00e,		0x21, 0
	.dw 0xa340, 0xc00e,	0xa37f, 0xc00e,		0x21, 0
	.dw 0xa3c0, 0xc00e,	0xa3ff, 0xc00e,		0x21, 0
	.dw 0xa440, 0xc00e,	0xa47f, 0xc00e,		0x21, 0
	.dw 0xa4c0, 0xc00e,	0xa4ff, 0xc00e,		0x21, 0
	.dw 0xa540, 0xc00e,	0xa57f, 0xc00e,		0x21, 0
	.dw 0xa5c0, 0xc00e,	0xa5ff, 0xc00e,		0x21, 0
	.dw 0xa640, 0xc00e,	0xa67f, 0xc00e,		0x21, 0
	.dw 0xa6c0, 0xc00e,	0xa6ff, 0xc00e,		0x21, 0
	.dw 0xa740, 0xc00e,	0xa77f, 0xc00e,		0x21, 0
	.dw 0xa7c0, 0xc00e,	0xa7ff, 0xc00e,		0x21, 0
	.dw 0xa840, 0xc00e,	0xa87f, 0xc00e,		0x21, 0
	.dw 0xa8c0, 0xc00e,	0xa8ff, 0xc00e,		0x21, 0
	.dw 0xa940, 0xc00e,	0xa97f, 0xc00e,		0x21, 0
	.dw 0xa9c0, 0xc00e,	0xa9ff, 0xc00e,		0x21, 0
	.dw 0xaa40, 0xc00e,	0xaa7f, 0xc00e,		0x21, 0
	.dw 0xaac0, 0xc00e,	0xaaff, 0xc00e,		0x21, 0
	.dw 0xab40, 0xc00e,	0xab7f, 0xc00e,		0x21, 0
	.dw 0xabc0, 0xc00e,	0xabff, 0xc00e,		0x21, 0
	.dw 0xac40, 0xc00e,	0xac7f, 0xc00e,		0x21, 0
	.dw 0xacc0, 0xc00e,	0xacff, 0xc00e,		0x21, 0
	.dw 0xad40, 0xc00e,	0xad7f, 0xc00e,		0x21, 0
	.dw 0xadc0, 0xc00e,	0xadff, 0xc00e,		0x21, 0
	.dw 0xae40, 0xc00e,	0xae7f, 0xc00e,		0x21, 0
	.dw 0xaec0, 0xc00e,	0xaeff, 0xc00e,		0x21, 0
	.dw 0xaf40, 0xc00e,	0xaf7f, 0xc00e,		0x21, 0
	.dw 0xafc0, 0xc00e,	0xafff, 0xc00e,		0x21, 0
	.dw 0xb040, 0xc00e,	0xb07f, 0xc00e,		0x21, 0
	.dw 0xb0c0, 0xc00e,	0xb0ff, 0xc00e,		0x21, 0
	.dw 0xb140, 0xc00e,	0xb17f, 0xc00e,		0x21, 0
	.dw 0xb1c0, 0xc00e,	0xb1ff, 0xc00e,		0x21, 0
	.dw 0xb240, 0xc00e,	0xb27f, 0xc00e,		0x21, 0
	.dw 0xb2c0, 0xc00e,	0xb2ff, 0xc00e,		0x21, 0
	.dw 0xb340, 0xc00e,	0xb37f, 0xc00e,		0x21, 0
	.dw 0xb3c0, 0xc00e,	0xb3ff, 0xc00e,		0x21, 0
	.dw 0xb440, 0xc00e,	0xb47f, 0xc00e,		0x21, 0
	.dw 0xb4c0, 0xc00e,	0xb4ff, 0xc00e,		0x21, 0
	.dw 0xb540, 0xc00e,	0xb57f, 0xc00e,		0x21, 0
	.dw 0xb5c0, 0xc00e,	0xb5ff, 0xc00e,		0x21, 0
	.dw 0xb640, 0xc00e,	0xb67f, 0xc00e,		0x21, 0
	.dw 0xb6c0, 0xc00e,	0xb6ff, 0xc00e,		0x21, 0
	.dw 0xb740, 0xc00e,	0xb77f, 0xc00e,		0x21, 0
	.dw 0xb7c0, 0xc00e,	0xb7ff, 0xc00e,		0x21, 0
	.dw 0xb840, 0xc00e,	0xb87f, 0xc00e,		0x21, 0
	.dw 0xb8c0, 0xc00e,	0xb8ff, 0xc00e,		0x21, 0
	.dw 0xb940, 0xc00e,	0xb97f, 0xc00e,		0x21, 0
	.dw 0xb9c0, 0xc00e,	0xbfff, 0xc00e,		0x21, 0
	.dw 0xc040, 0xc00e,	0xc07f, 0xc00e,		0x21, 0
	.dw 0xc0c0, 0xc00e,	0xc0ff, 0xc00e,		0x21, 0
	.dw 0xc140, 0xc00e,	0xc17f, 0xc00e,		0x21, 0
	.dw 0xc1c0, 0xc00e,	0xc1ff, 0xc00e,		0x21, 0
	.dw 0xc240, 0xc00e,	0xc27f, 0xc00e,		0x21, 0
	.dw 0xc2c0, 0xc00e,	0xc2ff, 0xc00e,		0x21, 0
	.dw 0xc340, 0xc00e,	0xc37f, 0xc00e,		0x21, 0
	.dw 0xc3c0, 0xc00e,	0xc3ff, 0xc00e,		0x21, 0
	.dw 0xc440, 0xc00e,	0xc47f, 0xc00e,		0x21, 0
	.dw 0xc4c0, 0xc00e,	0xc4ff, 0xc00e,		0x21, 0
	.dw 0xc540, 0xc00e,	0xc57f, 0xc00e,		0x21, 0
	.dw 0xc5c0, 0xc00e,	0xc5ff, 0xc00e,		0x21, 0
	.dw 0xc640, 0xc00e,	0xc67f, 0xc00e,		0x21, 0
	.dw 0xc6c0, 0xc00e,	0xc6ff, 0xc00e,		0x21, 0
	.dw 0xc740, 0xc00e,	0xc77f, 0xc00e,		0x21, 0
	.dw 0xc7c0, 0xc00e,	0xc7ff, 0xc00e,		0x21, 0
	.dw 0xc840, 0xc00e,	0xc87f, 0xc00e,		0x21, 0
	.dw 0xc8c0, 0xc00e,	0xc8ff, 0xc00e,		0x21, 0
	.dw 0xc940, 0xc00e,	0xc97f, 0xc00e,		0x21, 0
	.dw 0xc9c0, 0xc00e,	0xc9ff, 0xc00e,		0x21, 0
	.dw 0xca40, 0xc00e,	0xca7f, 0xc00e,		0x21, 0
	.dw 0xcac0, 0xc00e,	0xcaff, 0xc00e,		0x21, 0
	.dw 0xcb40, 0xc00e,	0xcb7f, 0xc00e,		0x21, 0
	.dw 0xcbc0, 0xc00e,	0xcbff, 0xc00e,		0x21, 0
	.dw 0xcc40, 0xc00e,	0xcc7f, 0xc00e,		0x21, 0
	.dw 0xccc0, 0xc00e,	0xccff, 0xc00e,		0x21, 0
	.dw 0xcd40, 0xc00e,	0xcd7f, 0xc00e,		0x21, 0
	.dw 0xcdc0, 0xc00e,	0xcdff, 0xc00e,		0x21, 0
	.dw 0xce40, 0xc00e,	0xce7f, 0xc00e,		0x21, 0
	.dw 0xcec0, 0xc00e,	0xceff, 0xc00e,		0x21, 0
	.dw 0xcf40, 0xc00e,	0xcf7f, 0xc00e,		0x21, 0
	.dw 0xcfc0, 0xc00e,	0xcfff, 0xc00e,		0x21, 0
	.dw 0xd040, 0xc00e,	0xd07f, 0xc00e,		0x21, 0
	.dw 0xd0c0, 0xc00e,	0xd0ff, 0xc00e,		0x21, 0
	.dw 0xd140, 0xc00e,	0xd17f, 0xc00e,		0x21, 0
	.dw 0xd1c0, 0xc00e,	0xd1ff, 0xc00e,		0x21, 0
	.dw 0xd240, 0xc00e,	0xd27f, 0xc00e,		0x21, 0
	.dw 0xd2c0, 0xc00e,	0xd2ff, 0xc00e,		0x21, 0
	.dw 0xd340, 0xc00e,	0xd37f, 0xc00e,		0x21, 0
	.dw 0xd3c0, 0xc00e,	0xd3ff, 0xc00e,		0x21, 0
	.dw 0xd440, 0xc00e,	0xd47f, 0xc00e,		0x21, 0
	.dw 0xd4c0, 0xc00e,	0xd4ff, 0xc00e,		0x21, 0
	.dw 0xd540, 0xc00e,	0xd57f, 0xc00e,		0x21, 0
	.dw 0xd5c0, 0xc00e,	0xd5ff, 0xc00e,		0x21, 0
	.dw 0xd640, 0xc00e,	0xd67f, 0xc00e,		0x21, 0
	.dw 0xd6c0, 0xc00e,	0xd6ff, 0xc00e,		0x21, 0
	.dw 0xd740, 0xc00e,	0xd77f, 0xc00e,		0x21, 0
	.dw 0xd7c0, 0xc00e,	0xd7ff, 0xc00e,		0x21, 0
	.dw 0xd840, 0xc00e,	0xd87f, 0xc00e,		0x21, 0
	.dw 0xd8c0, 0xc00e,	0xd8ff, 0xc00e,		0x21, 0
	.dw 0xd940, 0xc00e,	0xd97f, 0xc00e,		0x21, 0
	.dw 0xd9c0, 0xc00e,	0xdfff, 0xc00e,		0x21, 0
	.dw 0xe040, 0xc00e,	0xe07f, 0xc00e,		0x21, 0
	.dw 0xe0c0, 0xc00e,	0xe0ff, 0xc00e,		0x21, 0
	.dw 0xe140, 0xc00e,	0xe17f, 0xc00e,		0x21, 0
	.dw 0xe1c0, 0xc00e,	0xe1ff, 0xc00e,		0x21, 0
	.dw 0xe240, 0xc00e,	0xe27f, 0xc00e,		0x21, 0
	.dw 0xe2c0, 0xc00e,	0xe2ff, 0xc00e,		0x21, 0
	.dw 0xe340, 0xc00e,	0xe37f, 0xc00e,		0x21, 0
	.dw 0xe3c0, 0xc00e,	0xe3ff, 0xc00e,		0x21, 0
	.dw 0xe440, 0xc00e,	0xe47f, 0xc00e,		0x21, 0
	.dw 0xe4c0, 0xc00e,	0xe4ff, 0xc00e,		0x21, 0
	.dw 0xe540, 0xc00e,	0xe57f, 0xc00e,		0x21, 0
	.dw 0xe5c0, 0xc00e,	0xe5ff, 0xc00e,		0x21, 0
	.dw 0xe640, 0xc00e,	0xe67f, 0xc00e,		0x21, 0
	.dw 0xe6c0, 0xc00e,	0xe6ff, 0xc00e,		0x21, 0
	.dw 0xe740, 0xc00e,	0xe77f, 0xc00e,		0x21, 0
	.dw 0xe7c0, 0xc00e,	0xe7ff, 0xc00e,		0x21, 0
	.dw 0xe840, 0xc00e,	0xe87f, 0xc00e,		0x21, 0
	.dw 0xe8c0, 0xc00e,	0xe8ff, 0xc00e,		0x21, 0
	.dw 0xe940, 0xc00e,	0xe97f, 0xc00e,		0x21, 0
	.dw 0xe9c0, 0xc00e,	0xe9ff, 0xc00e,		0x21, 0
	.dw 0xea40, 0xc00e,	0xea7f, 0xc00e,		0x21, 0
	.dw 0xeac0, 0xc00e,	0xeaff, 0xc00e,		0x21, 0
	.dw 0xeb40, 0xc00e,	0xeb7f, 0xc00e,		0x21, 0
	.dw 0xebc0, 0xc00e,	0xebff, 0xc00e,		0x21, 0
	.dw 0xec40, 0xc00e,	0xec7f, 0xc00e,		0x21, 0
	.dw 0xecc0, 0xc00e,	0xecff, 0xc00e,		0x21, 0
	.dw 0xed40, 0xc00e,	0xed7f, 0xc00e,		0x21, 0
	.dw 0xedc0, 0xc00e,	0xedff, 0xc00e,		0x21, 0
	.dw 0xee40, 0xc00e,	0xee7f, 0xc00e,		0x21, 0
	.dw 0xeec0, 0xc00e,	0xeeff, 0xc00e,		0x21, 0
	.dw 0xef40, 0xc00e,	0xef7f, 0xc00e,		0x21, 0
	.dw 0xefc0, 0xc00e,	0xefff, 0xc00e,		0x21, 0
	.dw 0xf040, 0xc00e,	0xf07f, 0xc00e,		0x21, 0
	.dw 0xf0c0, 0xc00e,	0xf0ff, 0xc00e,		0x21, 0
	.dw 0xf140, 0xc00e,	0xf17f, 0xc00e,		0x21, 0
	.dw 0xf1c0, 0xc00e,	0xf1ff, 0xc00e,		0x21, 0
	.dw 0xf240, 0xc00e,	0xf27f, 0xc00e,		0x21, 0
	.dw 0xf2c0, 0xc00e,	0xf2ff, 0xc00e,		0x21, 0
	.dw 0xf340, 0xc00e,	0xf37f, 0xc00e,		0x21, 0
	.dw 0xf3c0, 0xc00e,	0xf3ff, 0xc00e,		0x21, 0
	.dw 0xf440, 0xc00e,	0xf47f, 0xc00e,		0x21, 0
	.dw 0xf4c0, 0xc00e,	0xf4ff, 0xc00e,		0x21, 0
	.dw 0xf540, 0xc00e,	0xf57f, 0xc00e,		0x21, 0
	.dw 0xf5c0, 0xc00e,	0xf5ff, 0xc00e,		0x21, 0
	.dw 0xf640, 0xc00e,	0xf67f, 0xc00e,		0x21, 0
	.dw 0xf6c0, 0xc00e,	0xf6ff, 0xc00e,		0x21, 0
	.dw 0xf740, 0xc00e,	0xf77f, 0xc00e,		0x21, 0
	.dw 0xf7c0, 0xc00e,	0xf7ff, 0xc00e,		0x21, 0
	.dw 0xf840, 0xc00e,	0xf87f, 0xc00e,		0x21, 0
	.dw 0xf8c0, 0xc00e,	0xf8ff, 0xc00e,		0x21, 0
	.dw 0xf940, 0xc00e,	0xf97f, 0xc00e,		0x21, 0
	.dw 0xf9c0, 0xc00e,	0xffff, 0xc00e,		0x21, 0
	.dw 0x0040, 0xc00f,	0x007f, 0xc00f,		0x21, 0
	.dw 0x00c0, 0xc00f,	0x00ff, 0xc00f,		0x21, 0
	.dw 0x0140, 0xc00f,	0x017f, 0xc00f,		0x21, 0
	.dw 0x01c0, 0xc00f,	0x01ff, 0xc00f,		0x21, 0
	.dw 0x0240, 0xc00f,	0x027f, 0xc00f,		0x21, 0
	.dw 0x02c0, 0xc00f,	0x02ff, 0xc00f,		0x21, 0
	.dw 0x0340, 0xc00f,	0x037f, 0xc00f,		0x21, 0
	.dw 0x03c0, 0xc00f,	0x03ff, 0xc00f,		0x21, 0
	.dw 0x0440, 0xc00f,	0x047f, 0xc00f,		0x21, 0
	.dw 0x04c0, 0xc00f,	0x04ff, 0xc00f,		0x21, 0
	.dw 0x0540, 0xc00f,	0x057f, 0xc00f,		0x21, 0
	.dw 0x05c0, 0xc00f,	0x05ff, 0xc00f,		0x21, 0
	.dw 0x0640, 0xc00f,	0x067f, 0xc00f,		0x21, 0
	.dw 0x06c0, 0xc00f,	0x06ff, 0xc00f,		0x21, 0
	.dw 0x0740, 0xc00f,	0x077f, 0xc00f,		0x21, 0
	.dw 0x07c0, 0xc00f,	0x07ff, 0xc00f,		0x21, 0
	.dw 0x0840, 0xc00f,	0x087f, 0xc00f,		0x21, 0
	.dw 0x08c0, 0xc00f,	0x08ff, 0xc00f,		0x21, 0
	.dw 0x0940, 0xc00f,	0x097f, 0xc00f,		0x21, 0
	.dw 0x09c0, 0xc00f,	0x09ff, 0xc00f,		0x21, 0
	.dw 0x0a40, 0xc00f,	0x0a7f, 0xc00f,		0x21, 0
	.dw 0x0ac0, 0xc00f,	0x0aff, 0xc00f,		0x21, 0
	.dw 0x0b40, 0xc00f,	0x0b7f, 0xc00f,		0x21, 0
	.dw 0x0bc0, 0xc00f,	0x0bff, 0xc00f,		0x21, 0
	.dw 0x0c40, 0xc00f,	0x0c7f, 0xc00f,		0x21, 0
	.dw 0x0cc0, 0xc00f,	0x0cff, 0xc00f,		0x21, 0
	.dw 0x0d40, 0xc00f,	0x0d7f, 0xc00f,		0x21, 0
	.dw 0x0dc0, 0xc00f,	0x0dff, 0xc00f,		0x21, 0
	.dw 0x0e40, 0xc00f,	0x0e7f, 0xc00f,		0x21, 0
	.dw 0x0ec0, 0xc00f,	0x0eff, 0xc00f,		0x21, 0
	.dw 0x0f40, 0xc00f,	0x0f7f, 0xc00f,		0x21, 0
	.dw 0x0fc0, 0xc00f,	0x0fff, 0xc00f,		0x21, 0
	.dw 0x1040, 0xc00f,	0x107f, 0xc00f,		0x21, 0
	.dw 0x10c0, 0xc00f,	0x10ff, 0xc00f,		0x21, 0
	.dw 0x1140, 0xc00f,	0x117f, 0xc00f,		0x21, 0
	.dw 0x11c0, 0xc00f,	0x11ff, 0xc00f,		0x21, 0
	.dw 0x1240, 0xc00f,	0x127f, 0xc00f,		0x21, 0
	.dw 0x12c0, 0xc00f,	0x12ff, 0xc00f,		0x21, 0
	.dw 0x1340, 0xc00f,	0x137f, 0xc00f,		0x21, 0
	.dw 0x13c0, 0xc00f,	0x13ff, 0xc00f,		0x21, 0
	.dw 0x1440, 0xc00f,	0x147f, 0xc00f,		0x21, 0
	.dw 0x14c0, 0xc00f,	0x14ff, 0xc00f,		0x21, 0
	.dw 0x1540, 0xc00f,	0x157f, 0xc00f,		0x21, 0
	.dw 0x15c0, 0xc00f,	0x15ff, 0xc00f,		0x21, 0
	.dw 0x1640, 0xc00f,	0x167f, 0xc00f,		0x21, 0
	.dw 0x16c0, 0xc00f,	0x16ff, 0xc00f,		0x21, 0
	.dw 0x1740, 0xc00f,	0x177f, 0xc00f,		0x21, 0
	.dw 0x17c0, 0xc00f,	0x17ff, 0xc00f,		0x21, 0
	.dw 0x1840, 0xc00f,	0x187f, 0xc00f,		0x21, 0
	.dw 0x18c0, 0xc00f,	0x18ff, 0xc00f,		0x21, 0
	.dw 0x1940, 0xc00f,	0x197f, 0xc00f,		0x21, 0
	.dw 0x19c0, 0xc00f,	0x1fff, 0xc00f,		0x21, 0
	.dw 0x2040, 0xc00f,	0x207f, 0xc00f,		0x21, 0
	.dw 0x20c0, 0xc00f,	0x20ff, 0xc00f,		0x21, 0
	.dw 0x2140, 0xc00f,	0x217f, 0xc00f,		0x21, 0
	.dw 0x21c0, 0xc00f,	0x21ff, 0xc00f,		0x21, 0
	.dw 0x2240, 0xc00f,	0x227f, 0xc00f,		0x21, 0
	.dw 0x22c0, 0xc00f,	0x22ff, 0xc00f,		0x21, 0
	.dw 0x2340, 0xc00f,	0x237f, 0xc00f,		0x21, 0
	.dw 0x23c0, 0xc00f,	0x23ff, 0xc00f,		0x21, 0
	.dw 0x2440, 0xc00f,	0x247f, 0xc00f,		0x21, 0
	.dw 0x24c0, 0xc00f,	0x24ff, 0xc00f,		0x21, 0
	.dw 0x2540, 0xc00f,	0x257f, 0xc00f,		0x21, 0
	.dw 0x25c0, 0xc00f,	0x25ff, 0xc00f,		0x21, 0
	.dw 0x2640, 0xc00f,	0x267f, 0xc00f,		0x21, 0
	.dw 0x26c0, 0xc00f,	0x26ff, 0xc00f,		0x21, 0
	.dw 0x2740, 0xc00f,	0x277f, 0xc00f,		0x21, 0
	.dw 0x27c0, 0xc00f,	0x27ff, 0xc00f,		0x21, 0
	.dw 0x2840, 0xc00f,	0x287f, 0xc00f,		0x21, 0
	.dw 0x28c0, 0xc00f,	0x28ff, 0xc00f,		0x21, 0
	.dw 0x2940, 0xc00f,	0x297f, 0xc00f,		0x21, 0
	.dw 0x29c0, 0xc00f,	0x29ff, 0xc00f,		0x21, 0
	.dw 0x2a40, 0xc00f,	0x2a7f, 0xc00f,		0x21, 0
	.dw 0x2ac0, 0xc00f,	0x2aff, 0xc00f,		0x21, 0
	.dw 0x2b40, 0xc00f,	0x2b7f, 0xc00f,		0x21, 0
	.dw 0x2bc0, 0xc00f,	0x2bff, 0xc00f,		0x21, 0
	.dw 0x2c40, 0xc00f,	0x2c7f, 0xc00f,		0x21, 0
	.dw 0x2cc0, 0xc00f,	0x2cff, 0xc00f,		0x21, 0
	.dw 0x2d40, 0xc00f,	0x2d7f, 0xc00f,		0x21, 0
	.dw 0x2dc0, 0xc00f,	0x2dff, 0xc00f,		0x21, 0
	.dw 0x2e40, 0xc00f,	0x2e7f, 0xc00f,		0x21, 0
	.dw 0x2ec0, 0xc00f,	0x2eff, 0xc00f,		0x21, 0
	.dw 0x2f40, 0xc00f,	0x2f7f, 0xc00f,		0x21, 0
	.dw 0x2fc0, 0xc00f,	0x2fff, 0xc00f,		0x21, 0
	.dw 0x3040, 0xc00f,	0x307f, 0xc00f,		0x21, 0
	.dw 0x30c0, 0xc00f,	0x30ff, 0xc00f,		0x21, 0
	.dw 0x3140, 0xc00f,	0x317f, 0xc00f,		0x21, 0
	.dw 0x31c0, 0xc00f,	0x31ff, 0xc00f,		0x21, 0
	.dw 0x3240, 0xc00f,	0x327f, 0xc00f,		0x21, 0
	.dw 0x32c0, 0xc00f,	0x32ff, 0xc00f,		0x21, 0
	.dw 0x3340, 0xc00f,	0x337f, 0xc00f,		0x21, 0
	.dw 0x33c0, 0xc00f,	0x33ff, 0xc00f,		0x21, 0
	.dw 0x3440, 0xc00f,	0x347f, 0xc00f,		0x21, 0
	.dw 0x34c0, 0xc00f,	0x34ff, 0xc00f,		0x21, 0
	.dw 0x3540, 0xc00f,	0x357f, 0xc00f,		0x21, 0
	.dw 0x35c0, 0xc00f,	0x35ff, 0xc00f,		0x21, 0
	.dw 0x3640, 0xc00f,	0x367f, 0xc00f,		0x21, 0
	.dw 0x36c0, 0xc00f,	0x36ff, 0xc00f,		0x21, 0
	.dw 0x3740, 0xc00f,	0x377f, 0xc00f,		0x21, 0
	.dw 0x37c0, 0xc00f,	0x37ff, 0xc00f,		0x21, 0
	.dw 0x3840, 0xc00f,	0x387f, 0xc00f,		0x21, 0
	.dw 0x38c0, 0xc00f,	0x38ff, 0xc00f,		0x21, 0
	.dw 0x3940, 0xc00f,	0x397f, 0xc00f,		0x21, 0
	.dw 0x39c0, 0xc00f,	0xffff, 0xc00f,		0x21, 0
	.dw 0x1a00, 0xc010,	0x1fff, 0xc010,		0x21, 0
	.dw 0x3a00, 0xc010,	0x3fff, 0xc010,		0x21, 0
	.dw 0x5a00, 0xc010,	0x5fff, 0xc010,		0x21, 0
	.dw 0x7a00, 0xc010,	0x7fff, 0xc010,		0x21, 0
	.dw 0x9a00, 0xc010,	0x9fff, 0xc010,		0x21, 0
	.dw 0xba00, 0xc010,	0xbfff, 0xc010,		0x21, 0
	.dw 0xda00, 0xc010,	0xdfff, 0xc010,		0x21, 0
	.dw 0xfa00, 0xc010,	0xffff, 0xc010,		0x21, 0
	.dw 0x1a00, 0xc011,	0x1fff, 0xc011,		0x21, 0
	.dw 0x3a00, 0xc011,	0x3fff, 0xc011,		0x21, 0
	.dw 0x5a00, 0xc011,	0x5fff, 0xc011,		0x21, 0
	.dw 0x7a00, 0xc011,	0x7fff, 0xc011,		0x21, 0
	.dw 0x9a00, 0xc011,	0x9fff, 0xc011,		0x21, 0
	.dw 0xba00, 0xc011,	0xbfff, 0xc011,		0x21, 0
	.dw 0xda00, 0xc011,	0xdfff, 0xc011,		0x21, 0
	.dw 0xfa00, 0xc011,	0xffff, 0xc011,		0x21, 0
	.dw 0x1a00, 0xc012,	0x1fff, 0xc012,		0x21, 0
	.dw 0x3a00, 0xc012,	0x3fff, 0xc012,		0x21, 0
	.dw 0x5a00, 0xc012,	0x5fff, 0xc012,		0x21, 0
	.dw 0x7a00, 0xc012,	0x7fff, 0xc012,		0x21, 0
	.dw 0x9a00, 0xc012,	0x9fff, 0xc012,		0x21, 0
	.dw 0xba00, 0xc012,	0xbfff, 0xc012,		0x21, 0
	.dw 0xda00, 0xc012,	0xdfff, 0xc012,		0x21, 0
	.dw 0xfa00, 0xc012,	0xffff, 0xc013,		0x21, 0
	.dw 0x1a00, 0xc014,	0x1fff, 0xc014,		0x21, 0
	.dw 0x3a00, 0xc014,	0x3fff, 0xc014,		0x21, 0
	.dw 0x5a00, 0xc014,	0x5fff, 0xc014,		0x21, 0
	.dw 0x7a00, 0xc014,	0x7fff, 0xc014,		0x21, 0
	.dw 0x9a00, 0xc014,	0x9fff, 0xc014,		0x21, 0
	.dw 0xba00, 0xc014,	0xbfff, 0xc014,		0x21, 0
	.dw 0xda00, 0xc014,	0xdfff, 0xc014,		0x21, 0
	.dw 0xfa00, 0xc014,	0xffff, 0xc014,		0x21, 0
	.dw 0x1a00, 0xc015,	0x1fff, 0xc015,		0x21, 0
	.dw 0x3a00, 0xc015,	0x3fff, 0xc015,		0x21, 0
	.dw 0x5a00, 0xc015,	0x5fff, 0xc015,		0x21, 0
	.dw 0x7a00, 0xc015,	0x7fff, 0xc015,		0x21, 0
	.dw 0x9a00, 0xc015,	0x9fff, 0xc015,		0x21, 0
	.dw 0xba00, 0xc015,	0xbfff, 0xc015,		0x21, 0
	.dw 0xda00, 0xc015,	0xdfff, 0xc015,		0x21, 0
	.dw 0xfa00, 0xc015,	0xffff, 0xc015,		0x21, 0
	.dw 0x1a00, 0xc016,	0x1fff, 0xc016,		0x21, 0
	.dw 0x3a00, 0xc016,	0x3fff, 0xc016,		0x21, 0
	.dw 0x5a00, 0xc016,	0x5fff, 0xc016,		0x21, 0
	.dw 0x7a00, 0xc016,	0x7fff, 0xc016,		0x21, 0
	.dw 0x9a00, 0xc016,	0x9fff, 0xc016,		0x21, 0
	.dw 0xba00, 0xc016,	0xbfff, 0xc016,		0x21, 0
	.dw 0xda00, 0xc016,	0xdfff, 0xc016,		0x21, 0
	.dw 0xfa00, 0xc016,	0xffff, 0xc016,		0x21, 0
	.dw 0x1a00, 0xc017,	0x1fff, 0xc017,		0x21, 0
	.dw 0x3a00, 0xc017,	0x1fff, 0xc018,		0x21, 0
	.dw 0x2040, 0xc018,	0x207f, 0xc018,		0x21, 0
	.dw 0x20c0, 0xc018,	0x20ff, 0xc018,		0x21, 0
	.dw 0x2140, 0xc018,	0x217f, 0xc018,		0x21, 0
	.dw 0x21c0, 0xc018,	0x21ff, 0xc018,		0x21, 0
	.dw 0x2240, 0xc018,	0x227f, 0xc018,		0x21, 0
	.dw 0x22c0, 0xc018,	0x22ff, 0xc018,		0x21, 0
	.dw 0x2340, 0xc018,	0x237f, 0xc018,		0x21, 0
	.dw 0x23c0, 0xc018,	0x23ff, 0xc018,		0x21, 0
	.dw 0x2440, 0xc018,	0x247f, 0xc018,		0x21, 0
	.dw 0x24c0, 0xc018,	0x24ff, 0xc018,		0x21, 0
	.dw 0x2540, 0xc018,	0x257f, 0xc018,		0x21, 0
	.dw 0x25c0, 0xc018,	0x25ff, 0xc018,		0x21, 0
	.dw 0x2640, 0xc018,	0x267f, 0xc018,		0x21, 0
	.dw 0x26c0, 0xc018,	0x26ff, 0xc018,		0x21, 0
	.dw 0x2740, 0xc018,	0x277f, 0xc018,		0x21, 0
	.dw 0x27c0, 0xc018,	0x27ff, 0xc018,		0x21, 0
	.dw 0x2840, 0xc018,	0x287f, 0xc018,		0x21, 0
	.dw 0x28c0, 0xc018,	0x28ff, 0xc018,		0x21, 0
	.dw 0x2940, 0xc018,	0x297f, 0xc018,		0x21, 0
	.dw 0x29c0, 0xc018,	0x29ff, 0xc018,		0x21, 0
	.dw 0x2a40, 0xc018,	0x2a7f, 0xc018,		0x21, 0
	.dw 0x2ac0, 0xc018,	0x2aff, 0xc018,		0x21, 0
	.dw 0x2b40, 0xc018,	0x2b7f, 0xc018,		0x21, 0
	.dw 0x2bc0, 0xc018,	0x2bff, 0xc018,		0x21, 0
	.dw 0x2c40, 0xc018,	0x2c7f, 0xc018,		0x21, 0
	.dw 0x2cc0, 0xc018,	0x2cff, 0xc018,		0x21, 0
	.dw 0x2d40, 0xc018,	0x2d7f, 0xc018,		0x21, 0
	.dw 0x2dc0, 0xc018,	0x2dff, 0xc018,		0x21, 0
	.dw 0x2e40, 0xc018,	0x2e7f, 0xc018,		0x21, 0
	.dw 0x2ec0, 0xc018,	0x2eff, 0xc018,		0x21, 0
	.dw 0x2f40, 0xc018,	0x2f7f, 0xc018,		0x21, 0
	.dw 0x2fc0, 0xc018,	0x2fff, 0xc018,		0x21, 0
	.dw 0x3040, 0xc018,	0x307f, 0xc018,		0x21, 0
	.dw 0x30c0, 0xc018,	0x30ff, 0xc018,		0x21, 0
	.dw 0x3140, 0xc018,	0x317f, 0xc018,		0x21, 0
	.dw 0x31c0, 0xc018,	0x31ff, 0xc018,		0x21, 0
	.dw 0x3240, 0xc018,	0x327f, 0xc018,		0x21, 0
	.dw 0x32c0, 0xc018,	0x32ff, 0xc018,		0x21, 0
	.dw 0x3340, 0xc018,	0x337f, 0xc018,		0x21, 0
	.dw 0x33c0, 0xc018,	0x33ff, 0xc018,		0x21, 0
	.dw 0x3440, 0xc018,	0x347f, 0xc018,		0x21, 0
	.dw 0x34c0, 0xc018,	0x34ff, 0xc018,		0x21, 0
	.dw 0x3540, 0xc018,	0x357f, 0xc018,		0x21, 0
	.dw 0x35c0, 0xc018,	0x35ff, 0xc018,		0x21, 0
	.dw 0x3640, 0xc018,	0x367f, 0xc018,		0x21, 0
	.dw 0x36c0, 0xc018,	0x36ff, 0xc018,		0x21, 0
	.dw 0x3740, 0xc018,	0x377f, 0xc018,		0x21, 0
	.dw 0x37c0, 0xc018,	0x37ff, 0xc018,		0x21, 0
	.dw 0x3840, 0xc018,	0x387f, 0xc018,		0x21, 0
	.dw 0x38c0, 0xc018,	0x38ff, 0xc018,		0x21, 0
	.dw 0x3940, 0xc018,	0x397f, 0xc018,		0x21, 0
	.dw 0x39c0, 0xc018,	0x5fff, 0xc018,		0x21, 0
	.dw 0x6040, 0xc018,	0x607f, 0xc018,		0x21, 0
	.dw 0x60c0, 0xc018,	0x60ff, 0xc018,		0x21, 0
	.dw 0x6140, 0xc018,	0x617f, 0xc018,		0x21, 0
	.dw 0x61c0, 0xc018,	0x61ff, 0xc018,		0x21, 0
	.dw 0x6240, 0xc018,	0x627f, 0xc018,		0x21, 0
	.dw 0x62c0, 0xc018,	0x62ff, 0xc018,		0x21, 0
	.dw 0x6340, 0xc018,	0x637f, 0xc018,		0x21, 0
	.dw 0x63c0, 0xc018,	0x63ff, 0xc018,		0x21, 0
	.dw 0x6440, 0xc018,	0x647f, 0xc018,		0x21, 0
	.dw 0x64c0, 0xc018,	0x64ff, 0xc018,		0x21, 0
	.dw 0x6540, 0xc018,	0x657f, 0xc018,		0x21, 0
	.dw 0x65c0, 0xc018,	0x65ff, 0xc018,		0x21, 0
	.dw 0x6640, 0xc018,	0x667f, 0xc018,		0x21, 0
	.dw 0x66c0, 0xc018,	0x66ff, 0xc018,		0x21, 0
	.dw 0x6740, 0xc018,	0x677f, 0xc018,		0x21, 0
	.dw 0x67c0, 0xc018,	0x67ff, 0xc018,		0x21, 0
	.dw 0x6840, 0xc018,	0x687f, 0xc018,		0x21, 0
	.dw 0x68c0, 0xc018,	0x68ff, 0xc018,		0x21, 0
	.dw 0x6940, 0xc018,	0x697f, 0xc018,		0x21, 0
	.dw 0x69c0, 0xc018,	0x69ff, 0xc018,		0x21, 0
	.dw 0x6a40, 0xc018,	0x6a7f, 0xc018,		0x21, 0
	.dw 0x6ac0, 0xc018,	0x6aff, 0xc018,		0x21, 0
	.dw 0x6b40, 0xc018,	0x6b7f, 0xc018,		0x21, 0
	.dw 0x6bc0, 0xc018,	0x6bff, 0xc018,		0x21, 0
	.dw 0x6c40, 0xc018,	0x6c7f, 0xc018,		0x21, 0
	.dw 0x6cc0, 0xc018,	0x6cff, 0xc018,		0x21, 0
	.dw 0x6d40, 0xc018,	0x6d7f, 0xc018,		0x21, 0
	.dw 0x6dc0, 0xc018,	0x6dff, 0xc018,		0x21, 0
	.dw 0x6e40, 0xc018,	0x6e7f, 0xc018,		0x21, 0
	.dw 0x6ec0, 0xc018,	0x6eff, 0xc018,		0x21, 0
	.dw 0x6f40, 0xc018,	0x6f7f, 0xc018,		0x21, 0
	.dw 0x6fc0, 0xc018,	0x6fff, 0xc018,		0x21, 0
	.dw 0x7040, 0xc018,	0x707f, 0xc018,		0x21, 0
	.dw 0x70c0, 0xc018,	0x70ff, 0xc018,		0x21, 0
	.dw 0x7140, 0xc018,	0x717f, 0xc018,		0x21, 0
	.dw 0x71c0, 0xc018,	0x71ff, 0xc018,		0x21, 0
	.dw 0x7240, 0xc018,	0x727f, 0xc018,		0x21, 0
	.dw 0x72c0, 0xc018,	0x72ff, 0xc018,		0x21, 0
	.dw 0x7340, 0xc018,	0x737f, 0xc018,		0x21, 0
	.dw 0x73c0, 0xc018,	0x73ff, 0xc018,		0x21, 0
	.dw 0x7440, 0xc018,	0x747f, 0xc018,		0x21, 0
	.dw 0x74c0, 0xc018,	0x74ff, 0xc018,		0x21, 0
	.dw 0x7540, 0xc018,	0x757f, 0xc018,		0x21, 0
	.dw 0x75c0, 0xc018,	0x75ff, 0xc018,		0x21, 0
	.dw 0x7640, 0xc018,	0x767f, 0xc018,		0x21, 0
	.dw 0x76c0, 0xc018,	0x76ff, 0xc018,		0x21, 0
	.dw 0x7740, 0xc018,	0x777f, 0xc018,		0x21, 0
	.dw 0x77c0, 0xc018,	0x77ff, 0xc018,		0x21, 0
	.dw 0x7840, 0xc018,	0x787f, 0xc018,		0x21, 0
	.dw 0x78c0, 0xc018,	0x78ff, 0xc018,		0x21, 0
	.dw 0x7940, 0xc018,	0x797f, 0xc018,		0x21, 0
	.dw 0x79c0, 0xc018,	0x9fff, 0xc018,		0x21, 0
	.dw 0xa040, 0xc018,	0xa07f, 0xc018,		0x21, 0
	.dw 0xa0c0, 0xc018,	0xa0ff, 0xc018,		0x21, 0
	.dw 0xa140, 0xc018,	0xa17f, 0xc018,		0x21, 0
	.dw 0xa1c0, 0xc018,	0xa1ff, 0xc018,		0x21, 0
	.dw 0xa240, 0xc018,	0xa27f, 0xc018,		0x21, 0
	.dw 0xa2c0, 0xc018,	0xa2ff, 0xc018,		0x21, 0
	.dw 0xa340, 0xc018,	0xa37f, 0xc018,		0x21, 0
	.dw 0xa3c0, 0xc018,	0xa3ff, 0xc018,		0x21, 0
	.dw 0xa440, 0xc018,	0xa47f, 0xc018,		0x21, 0
	.dw 0xa4c0, 0xc018,	0xa4ff, 0xc018,		0x21, 0
	.dw 0xa540, 0xc018,	0xa57f, 0xc018,		0x21, 0
	.dw 0xa5c0, 0xc018,	0xa5ff, 0xc018,		0x21, 0
	.dw 0xa640, 0xc018,	0xa67f, 0xc018,		0x21, 0
	.dw 0xa6c0, 0xc018,	0xa6ff, 0xc018,		0x21, 0
	.dw 0xa740, 0xc018,	0xa77f, 0xc018,		0x21, 0
	.dw 0xa7c0, 0xc018,	0xa7ff, 0xc018,		0x21, 0
	.dw 0xa840, 0xc018,	0xa87f, 0xc018,		0x21, 0
	.dw 0xa8c0, 0xc018,	0xa8ff, 0xc018,		0x21, 0
	.dw 0xa940, 0xc018,	0xa97f, 0xc018,		0x21, 0
	.dw 0xa9c0, 0xc018,	0xa9ff, 0xc018,		0x21, 0
	.dw 0xaa40, 0xc018,	0xaa7f, 0xc018,		0x21, 0
	.dw 0xaac0, 0xc018,	0xaaff, 0xc018,		0x21, 0
	.dw 0xab40, 0xc018,	0xab7f, 0xc018,		0x21, 0
	.dw 0xabc0, 0xc018,	0xabff, 0xc018,		0x21, 0
	.dw 0xac40, 0xc018,	0xac7f, 0xc018,		0x21, 0
	.dw 0xacc0, 0xc018,	0xacff, 0xc018,		0x21, 0
	.dw 0xad40, 0xc018,	0xad7f, 0xc018,		0x21, 0
	.dw 0xadc0, 0xc018,	0xadff, 0xc018,		0x21, 0
	.dw 0xae40, 0xc018,	0xae7f, 0xc018,		0x21, 0
	.dw 0xaec0, 0xc018,	0xaeff, 0xc018,		0x21, 0
	.dw 0xaf40, 0xc018,	0xaf7f, 0xc018,		0x21, 0
	.dw 0xafc0, 0xc018,	0xafff, 0xc018,		0x21, 0
	.dw 0xb040, 0xc018,	0xb07f, 0xc018,		0x21, 0
	.dw 0xb0c0, 0xc018,	0xb0ff, 0xc018,		0x21, 0
	.dw 0xb140, 0xc018,	0xb17f, 0xc018,		0x21, 0
	.dw 0xb1c0, 0xc018,	0xb1ff, 0xc018,		0x21, 0
	.dw 0xb240, 0xc018,	0xb27f, 0xc018,		0x21, 0
	.dw 0xb2c0, 0xc018,	0xb2ff, 0xc018,		0x21, 0
	.dw 0xb340, 0xc018,	0xb37f, 0xc018,		0x21, 0
	.dw 0xb3c0, 0xc018,	0xb3ff, 0xc018,		0x21, 0
	.dw 0xb440, 0xc018,	0xb47f, 0xc018,		0x21, 0
	.dw 0xb4c0, 0xc018,	0xb4ff, 0xc018,		0x21, 0
	.dw 0xb540, 0xc018,	0xb57f, 0xc018,		0x21, 0
	.dw 0xb5c0, 0xc018,	0xb5ff, 0xc018,		0x21, 0
	.dw 0xb640, 0xc018,	0xb67f, 0xc018,		0x21, 0
	.dw 0xb6c0, 0xc018,	0xb6ff, 0xc018,		0x21, 0
	.dw 0xb740, 0xc018,	0xb77f, 0xc018,		0x21, 0
	.dw 0xb7c0, 0xc018,	0xb7ff, 0xc018,		0x21, 0
	.dw 0xb840, 0xc018,	0xb87f, 0xc018,		0x21, 0
	.dw 0xb8c0, 0xc018,	0xb8ff, 0xc018,		0x21, 0
	.dw 0xb940, 0xc018,	0xb97f, 0xc018,		0x21, 0
	.dw 0xb9c0, 0xc018,	0xdfff, 0xc018,		0x21, 0
	.dw 0xe040, 0xc018,	0xe07f, 0xc018,		0x21, 0
	.dw 0xe0c0, 0xc018,	0xe0ff, 0xc018,		0x21, 0
	.dw 0xe140, 0xc018,	0xe17f, 0xc018,		0x21, 0
	.dw 0xe1c0, 0xc018,	0xe1ff, 0xc018,		0x21, 0
	.dw 0xe240, 0xc018,	0xe27f, 0xc018,		0x21, 0
	.dw 0xe2c0, 0xc018,	0xe2ff, 0xc018,		0x21, 0
	.dw 0xe340, 0xc018,	0xe37f, 0xc018,		0x21, 0
	.dw 0xe3c0, 0xc018,	0xe3ff, 0xc018,		0x21, 0
	.dw 0xe440, 0xc018,	0xe47f, 0xc018,		0x21, 0
	.dw 0xe4c0, 0xc018,	0xe4ff, 0xc018,		0x21, 0
	.dw 0xe540, 0xc018,	0xe57f, 0xc018,		0x21, 0
	.dw 0xe5c0, 0xc018,	0xe5ff, 0xc018,		0x21, 0
	.dw 0xe640, 0xc018,	0xe67f, 0xc018,		0x21, 0
	.dw 0xe6c0, 0xc018,	0xe6ff, 0xc018,		0x21, 0
	.dw 0xe740, 0xc018,	0xe77f, 0xc018,		0x21, 0
	.dw 0xe7c0, 0xc018,	0xe7ff, 0xc018,		0x21, 0
	.dw 0xe840, 0xc018,	0xe87f, 0xc018,		0x21, 0
	.dw 0xe8c0, 0xc018,	0xe8ff, 0xc018,		0x21, 0
	.dw 0xe940, 0xc018,	0xe97f, 0xc018,		0x21, 0
	.dw 0xe9c0, 0xc018,	0xe9ff, 0xc018,		0x21, 0
	.dw 0xea40, 0xc018,	0xea7f, 0xc018,		0x21, 0
	.dw 0xeac0, 0xc018,	0xeaff, 0xc018,		0x21, 0
	.dw 0xeb40, 0xc018,	0xeb7f, 0xc018,		0x21, 0
	.dw 0xebc0, 0xc018,	0xebff, 0xc018,		0x21, 0
	.dw 0xec40, 0xc018,	0xec7f, 0xc018,		0x21, 0
	.dw 0xecc0, 0xc018,	0xecff, 0xc018,		0x21, 0
	.dw 0xed40, 0xc018,	0xed7f, 0xc018,		0x21, 0
	.dw 0xedc0, 0xc018,	0xedff, 0xc018,		0x21, 0
	.dw 0xee40, 0xc018,	0xee7f, 0xc018,		0x21, 0
	.dw 0xeec0, 0xc018,	0xeeff, 0xc018,		0x21, 0
	.dw 0xef40, 0xc018,	0xef7f, 0xc018,		0x21, 0
	.dw 0xefc0, 0xc018,	0xefff, 0xc018,		0x21, 0
	.dw 0xf040, 0xc018,	0xf07f, 0xc018,		0x21, 0
	.dw 0xf0c0, 0xc018,	0xf0ff, 0xc018,		0x21, 0
	.dw 0xf140, 0xc018,	0xf17f, 0xc018,		0x21, 0
	.dw 0xf1c0, 0xc018,	0xf1ff, 0xc018,		0x21, 0
	.dw 0xf240, 0xc018,	0xf27f, 0xc018,		0x21, 0
	.dw 0xf2c0, 0xc018,	0xf2ff, 0xc018,		0x21, 0
	.dw 0xf340, 0xc018,	0xf37f, 0xc018,		0x21, 0
	.dw 0xf3c0, 0xc018,	0xf3ff, 0xc018,		0x21, 0
	.dw 0xf440, 0xc018,	0xf47f, 0xc018,		0x21, 0
	.dw 0xf4c0, 0xc018,	0xf4ff, 0xc018,		0x21, 0
	.dw 0xf540, 0xc018,	0xf57f, 0xc018,		0x21, 0
	.dw 0xf5c0, 0xc018,	0xf5ff, 0xc018,		0x21, 0
	.dw 0xf640, 0xc018,	0xf67f, 0xc018,		0x21, 0
	.dw 0xf6c0, 0xc018,	0xf6ff, 0xc018,		0x21, 0
	.dw 0xf740, 0xc018,	0xf77f, 0xc018,		0x21, 0
	.dw 0xf7c0, 0xc018,	0xf7ff, 0xc018,		0x21, 0
	.dw 0xf840, 0xc018,	0xf87f, 0xc018,		0x21, 0
	.dw 0xf8c0, 0xc018,	0xf8ff, 0xc018,		0x21, 0
	.dw 0xf940, 0xc018,	0xf97f, 0xc018,		0x21, 0
	.dw 0xf9c0, 0xc018,	0x1fff, 0xc019,		0x21, 0
	.dw 0x2040, 0xc019,	0x207f, 0xc019,		0x21, 0
	.dw 0x20c0, 0xc019,	0x20ff, 0xc019,		0x21, 0
	.dw 0x2140, 0xc019,	0x217f, 0xc019,		0x21, 0
	.dw 0x21c0, 0xc019,	0x21ff, 0xc019,		0x21, 0
	.dw 0x2240, 0xc019,	0x227f, 0xc019,		0x21, 0
	.dw 0x22c0, 0xc019,	0x22ff, 0xc019,		0x21, 0
	.dw 0x2340, 0xc019,	0x237f, 0xc019,		0x21, 0
	.dw 0x23c0, 0xc019,	0x23ff, 0xc019,		0x21, 0
	.dw 0x2440, 0xc019,	0x247f, 0xc019,		0x21, 0
	.dw 0x24c0, 0xc019,	0x24ff, 0xc019,		0x21, 0
	.dw 0x2540, 0xc019,	0x257f, 0xc019,		0x21, 0
	.dw 0x25c0, 0xc019,	0x25ff, 0xc019,		0x21, 0
	.dw 0x2640, 0xc019,	0x267f, 0xc019,		0x21, 0
	.dw 0x26c0, 0xc019,	0x26ff, 0xc019,		0x21, 0
	.dw 0x2740, 0xc019,	0x277f, 0xc019,		0x21, 0
	.dw 0x27c0, 0xc019,	0x27ff, 0xc019,		0x21, 0
	.dw 0x2840, 0xc019,	0x287f, 0xc019,		0x21, 0
	.dw 0x28c0, 0xc019,	0x28ff, 0xc019,		0x21, 0
	.dw 0x2940, 0xc019,	0x297f, 0xc019,		0x21, 0
	.dw 0x29c0, 0xc019,	0x29ff, 0xc019,		0x21, 0
	.dw 0x2a40, 0xc019,	0x2a7f, 0xc019,		0x21, 0
	.dw 0x2ac0, 0xc019,	0x2aff, 0xc019,		0x21, 0
	.dw 0x2b40, 0xc019,	0x2b7f, 0xc019,		0x21, 0
	.dw 0x2bc0, 0xc019,	0x2bff, 0xc019,		0x21, 0
	.dw 0x2c40, 0xc019,	0x2c7f, 0xc019,		0x21, 0
	.dw 0x2cc0, 0xc019,	0x2cff, 0xc019,		0x21, 0
	.dw 0x2d40, 0xc019,	0x2d7f, 0xc019,		0x21, 0
	.dw 0x2dc0, 0xc019,	0x2dff, 0xc019,		0x21, 0
	.dw 0x2e40, 0xc019,	0x2e7f, 0xc019,		0x21, 0
	.dw 0x2ec0, 0xc019,	0x2eff, 0xc019,		0x21, 0
	.dw 0x2f40, 0xc019,	0x2f7f, 0xc019,		0x21, 0
	.dw 0x2fc0, 0xc019,	0x2fff, 0xc019,		0x21, 0
	.dw 0x3040, 0xc019,	0x307f, 0xc019,		0x21, 0
	.dw 0x30c0, 0xc019,	0x30ff, 0xc019,		0x21, 0
	.dw 0x3140, 0xc019,	0x317f, 0xc019,		0x21, 0
	.dw 0x31c0, 0xc019,	0x31ff, 0xc019,		0x21, 0
	.dw 0x3240, 0xc019,	0x327f, 0xc019,		0x21, 0
	.dw 0x32c0, 0xc019,	0x32ff, 0xc019,		0x21, 0
	.dw 0x3340, 0xc019,	0x337f, 0xc019,		0x21, 0
	.dw 0x33c0, 0xc019,	0x33ff, 0xc019,		0x21, 0
	.dw 0x3440, 0xc019,	0x347f, 0xc019,		0x21, 0
	.dw 0x34c0, 0xc019,	0x34ff, 0xc019,		0x21, 0
	.dw 0x3540, 0xc019,	0x357f, 0xc019,		0x21, 0
	.dw 0x35c0, 0xc019,	0x35ff, 0xc019,		0x21, 0
	.dw 0x3640, 0xc019,	0x367f, 0xc019,		0x21, 0
	.dw 0x36c0, 0xc019,	0x36ff, 0xc019,		0x21, 0
	.dw 0x3740, 0xc019,	0x377f, 0xc019,		0x21, 0
	.dw 0x37c0, 0xc019,	0x37ff, 0xc019,		0x21, 0
	.dw 0x3840, 0xc019,	0x387f, 0xc019,		0x21, 0
	.dw 0x38c0, 0xc019,	0x38ff, 0xc019,		0x21, 0
	.dw 0x3940, 0xc019,	0x397f, 0xc019,		0x21, 0
	.dw 0x39c0, 0xc019,	0x5fff, 0xc019,		0x21, 0
	.dw 0x6040, 0xc019,	0x607f, 0xc019,		0x21, 0
	.dw 0x60c0, 0xc019,	0x60ff, 0xc019,		0x21, 0
	.dw 0x6140, 0xc019,	0x617f, 0xc019,		0x21, 0
	.dw 0x61c0, 0xc019,	0x61ff, 0xc019,		0x21, 0
	.dw 0x6240, 0xc019,	0x627f, 0xc019,		0x21, 0
	.dw 0x62c0, 0xc019,	0x62ff, 0xc019,		0x21, 0
	.dw 0x6340, 0xc019,	0x637f, 0xc019,		0x21, 0
	.dw 0x63c0, 0xc019,	0x63ff, 0xc019,		0x21, 0
	.dw 0x6440, 0xc019,	0x647f, 0xc019,		0x21, 0
	.dw 0x64c0, 0xc019,	0x64ff, 0xc019,		0x21, 0
	.dw 0x6540, 0xc019,	0x657f, 0xc019,		0x21, 0
	.dw 0x65c0, 0xc019,	0x65ff, 0xc019,		0x21, 0
	.dw 0x6640, 0xc019,	0x667f, 0xc019,		0x21, 0
	.dw 0x66c0, 0xc019,	0x66ff, 0xc019,		0x21, 0
	.dw 0x6740, 0xc019,	0x677f, 0xc019,		0x21, 0
	.dw 0x67c0, 0xc019,	0x67ff, 0xc019,		0x21, 0
	.dw 0x6840, 0xc019,	0x687f, 0xc019,		0x21, 0
	.dw 0x68c0, 0xc019,	0x68ff, 0xc019,		0x21, 0
	.dw 0x6940, 0xc019,	0x697f, 0xc019,		0x21, 0
	.dw 0x69c0, 0xc019,	0x69ff, 0xc019,		0x21, 0
	.dw 0x6a40, 0xc019,	0x6a7f, 0xc019,		0x21, 0
	.dw 0x6ac0, 0xc019,	0x6aff, 0xc019,		0x21, 0
	.dw 0x6b40, 0xc019,	0x6b7f, 0xc019,		0x21, 0
	.dw 0x6bc0, 0xc019,	0x6bff, 0xc019,		0x21, 0
	.dw 0x6c40, 0xc019,	0x6c7f, 0xc019,		0x21, 0
	.dw 0x6cc0, 0xc019,	0x6cff, 0xc019,		0x21, 0
	.dw 0x6d40, 0xc019,	0x6d7f, 0xc019,		0x21, 0
	.dw 0x6dc0, 0xc019,	0x6dff, 0xc019,		0x21, 0
	.dw 0x6e40, 0xc019,	0x6e7f, 0xc019,		0x21, 0
	.dw 0x6ec0, 0xc019,	0x6eff, 0xc019,		0x21, 0
	.dw 0x6f40, 0xc019,	0x6f7f, 0xc019,		0x21, 0
	.dw 0x6fc0, 0xc019,	0x6fff, 0xc019,		0x21, 0
	.dw 0x7040, 0xc019,	0x707f, 0xc019,		0x21, 0
	.dw 0x70c0, 0xc019,	0x70ff, 0xc019,		0x21, 0
	.dw 0x7140, 0xc019,	0x717f, 0xc019,		0x21, 0
	.dw 0x71c0, 0xc019,	0x71ff, 0xc019,		0x21, 0
	.dw 0x7240, 0xc019,	0x727f, 0xc019,		0x21, 0
	.dw 0x72c0, 0xc019,	0x72ff, 0xc019,		0x21, 0
	.dw 0x7340, 0xc019,	0x737f, 0xc019,		0x21, 0
	.dw 0x73c0, 0xc019,	0x73ff, 0xc019,		0x21, 0
	.dw 0x7440, 0xc019,	0x747f, 0xc019,		0x21, 0
	.dw 0x74c0, 0xc019,	0x74ff, 0xc019,		0x21, 0
	.dw 0x7540, 0xc019,	0x757f, 0xc019,		0x21, 0
	.dw 0x75c0, 0xc019,	0x75ff, 0xc019,		0x21, 0
	.dw 0x7640, 0xc019,	0x767f, 0xc019,		0x21, 0
	.dw 0x76c0, 0xc019,	0x76ff, 0xc019,		0x21, 0
	.dw 0x7740, 0xc019,	0x777f, 0xc019,		0x21, 0
	.dw 0x77c0, 0xc019,	0x77ff, 0xc019,		0x21, 0
	.dw 0x7840, 0xc019,	0x787f, 0xc019,		0x21, 0
	.dw 0x78c0, 0xc019,	0x78ff, 0xc019,		0x21, 0
	.dw 0x7940, 0xc019,	0x797f, 0xc019,		0x21, 0
	.dw 0x79c0, 0xc019,	0x9fff, 0xc019,		0x21, 0
	.dw 0xa040, 0xc019,	0xa07f, 0xc019,		0x21, 0
	.dw 0xa0c0, 0xc019,	0xa0ff, 0xc019,		0x21, 0
	.dw 0xa140, 0xc019,	0xa17f, 0xc019,		0x21, 0
	.dw 0xa1c0, 0xc019,	0xa1ff, 0xc019,		0x21, 0
	.dw 0xa240, 0xc019,	0xa27f, 0xc019,		0x21, 0
	.dw 0xa2c0, 0xc019,	0xa2ff, 0xc019,		0x21, 0
	.dw 0xa340, 0xc019,	0xa37f, 0xc019,		0x21, 0
	.dw 0xa3c0, 0xc019,	0xa3ff, 0xc019,		0x21, 0
	.dw 0xa440, 0xc019,	0xa47f, 0xc019,		0x21, 0
	.dw 0xa4c0, 0xc019,	0xa4ff, 0xc019,		0x21, 0
	.dw 0xa540, 0xc019,	0xa57f, 0xc019,		0x21, 0
	.dw 0xa5c0, 0xc019,	0xa5ff, 0xc019,		0x21, 0
	.dw 0xa640, 0xc019,	0xa67f, 0xc019,		0x21, 0
	.dw 0xa6c0, 0xc019,	0xa6ff, 0xc019,		0x21, 0
	.dw 0xa740, 0xc019,	0xa77f, 0xc019,		0x21, 0
	.dw 0xa7c0, 0xc019,	0xa7ff, 0xc019,		0x21, 0
	.dw 0xa840, 0xc019,	0xa87f, 0xc019,		0x21, 0
	.dw 0xa8c0, 0xc019,	0xa8ff, 0xc019,		0x21, 0
	.dw 0xa940, 0xc019,	0xa97f, 0xc019,		0x21, 0
	.dw 0xa9c0, 0xc019,	0xa9ff, 0xc019,		0x21, 0
	.dw 0xaa40, 0xc019,	0xaa7f, 0xc019,		0x21, 0
	.dw 0xaac0, 0xc019,	0xaaff, 0xc019,		0x21, 0
	.dw 0xab40, 0xc019,	0xab7f, 0xc019,		0x21, 0
	.dw 0xabc0, 0xc019,	0xabff, 0xc019,		0x21, 0
	.dw 0xac40, 0xc019,	0xac7f, 0xc019,		0x21, 0
	.dw 0xacc0, 0xc019,	0xacff, 0xc019,		0x21, 0
	.dw 0xad40, 0xc019,	0xad7f, 0xc019,		0x21, 0
	.dw 0xadc0, 0xc019,	0xadff, 0xc019,		0x21, 0
	.dw 0xae40, 0xc019,	0xae7f, 0xc019,		0x21, 0
	.dw 0xaec0, 0xc019,	0xaeff, 0xc019,		0x21, 0
	.dw 0xaf40, 0xc019,	0xaf7f, 0xc019,		0x21, 0
	.dw 0xafc0, 0xc019,	0xafff, 0xc019,		0x21, 0
	.dw 0xb040, 0xc019,	0xb07f, 0xc019,		0x21, 0
	.dw 0xb0c0, 0xc019,	0xb0ff, 0xc019,		0x21, 0
	.dw 0xb140, 0xc019,	0xb17f, 0xc019,		0x21, 0
	.dw 0xb1c0, 0xc019,	0xb1ff, 0xc019,		0x21, 0
	.dw 0xb240, 0xc019,	0xb27f, 0xc019,		0x21, 0
	.dw 0xb2c0, 0xc019,	0xb2ff, 0xc019,		0x21, 0
	.dw 0xb340, 0xc019,	0xb37f, 0xc019,		0x21, 0
	.dw 0xb3c0, 0xc019,	0xb3ff, 0xc019,		0x21, 0
	.dw 0xb440, 0xc019,	0xb47f, 0xc019,		0x21, 0
	.dw 0xb4c0, 0xc019,	0xb4ff, 0xc019,		0x21, 0
	.dw 0xb540, 0xc019,	0xb57f, 0xc019,		0x21, 0
	.dw 0xb5c0, 0xc019,	0xb5ff, 0xc019,		0x21, 0
	.dw 0xb640, 0xc019,	0xb67f, 0xc019,		0x21, 0
	.dw 0xb6c0, 0xc019,	0xb6ff, 0xc019,		0x21, 0
	.dw 0xb740, 0xc019,	0xb77f, 0xc019,		0x21, 0
	.dw 0xb7c0, 0xc019,	0xb7ff, 0xc019,		0x21, 0
	.dw 0xb840, 0xc019,	0xb87f, 0xc019,		0x21, 0
	.dw 0xb8c0, 0xc019,	0xb8ff, 0xc019,		0x21, 0
	.dw 0xb940, 0xc019,	0xb97f, 0xc019,		0x21, 0
	.dw 0xb9c0, 0xc019,	0xdfff, 0xc019,		0x21, 0
	.dw 0xe040, 0xc019,	0xe07f, 0xc019,		0x21, 0
	.dw 0xe0c0, 0xc019,	0xe0ff, 0xc019,		0x21, 0
	.dw 0xe140, 0xc019,	0xe17f, 0xc019,		0x21, 0
	.dw 0xe1c0, 0xc019,	0xe1ff, 0xc019,		0x21, 0
	.dw 0xe240, 0xc019,	0xe27f, 0xc019,		0x21, 0
	.dw 0xe2c0, 0xc019,	0xe2ff, 0xc019,		0x21, 0
	.dw 0xe340, 0xc019,	0xe37f, 0xc019,		0x21, 0
	.dw 0xe3c0, 0xc019,	0xe3ff, 0xc019,		0x21, 0
	.dw 0xe440, 0xc019,	0xe47f, 0xc019,		0x21, 0
	.dw 0xe4c0, 0xc019,	0xe4ff, 0xc019,		0x21, 0
	.dw 0xe540, 0xc019,	0xe57f, 0xc019,		0x21, 0
	.dw 0xe5c0, 0xc019,	0xe5ff, 0xc019,		0x21, 0
	.dw 0xe640, 0xc019,	0xe67f, 0xc019,		0x21, 0
	.dw 0xe6c0, 0xc019,	0xe6ff, 0xc019,		0x21, 0
	.dw 0xe740, 0xc019,	0xe77f, 0xc019,		0x21, 0
	.dw 0xe7c0, 0xc019,	0xe7ff, 0xc019,		0x21, 0
	.dw 0xe840, 0xc019,	0xe87f, 0xc019,		0x21, 0
	.dw 0xe8c0, 0xc019,	0xe8ff, 0xc019,		0x21, 0
	.dw 0xe940, 0xc019,	0xe97f, 0xc019,		0x21, 0
	.dw 0xe9c0, 0xc019,	0xe9ff, 0xc019,		0x21, 0
	.dw 0xea40, 0xc019,	0xea7f, 0xc019,		0x21, 0
	.dw 0xeac0, 0xc019,	0xeaff, 0xc019,		0x21, 0
	.dw 0xeb40, 0xc019,	0xeb7f, 0xc019,		0x21, 0
	.dw 0xebc0, 0xc019,	0xebff, 0xc019,		0x21, 0
	.dw 0xec40, 0xc019,	0xec7f, 0xc019,		0x21, 0
	.dw 0xecc0, 0xc019,	0xecff, 0xc019,		0x21, 0
	.dw 0xed40, 0xc019,	0xed7f, 0xc019,		0x21, 0
	.dw 0xedc0, 0xc019,	0xedff, 0xc019,		0x21, 0
	.dw 0xee40, 0xc019,	0xee7f, 0xc019,		0x21, 0
	.dw 0xeec0, 0xc019,	0xeeff, 0xc019,		0x21, 0
	.dw 0xef40, 0xc019,	0xef7f, 0xc019,		0x21, 0
	.dw 0xefc0, 0xc019,	0xefff, 0xc019,		0x21, 0
	.dw 0xf040, 0xc019,	0xf07f, 0xc019,		0x21, 0
	.dw 0xf0c0, 0xc019,	0xf0ff, 0xc019,		0x21, 0
	.dw 0xf140, 0xc019,	0xf17f, 0xc019,		0x21, 0
	.dw 0xf1c0, 0xc019,	0xf1ff, 0xc019,		0x21, 0
	.dw 0xf240, 0xc019,	0xf27f, 0xc019,		0x21, 0
	.dw 0xf2c0, 0xc019,	0xf2ff, 0xc019,		0x21, 0
	.dw 0xf340, 0xc019,	0xf37f, 0xc019,		0x21, 0
	.dw 0xf3c0, 0xc019,	0xf3ff, 0xc019,		0x21, 0
	.dw 0xf440, 0xc019,	0xf47f, 0xc019,		0x21, 0
	.dw 0xf4c0, 0xc019,	0xf4ff, 0xc019,		0x21, 0
	.dw 0xf540, 0xc019,	0xf57f, 0xc019,		0x21, 0
	.dw 0xf5c0, 0xc019,	0xf5ff, 0xc019,		0x21, 0
	.dw 0xf640, 0xc019,	0xf67f, 0xc019,		0x21, 0
	.dw 0xf6c0, 0xc019,	0xf6ff, 0xc019,		0x21, 0
	.dw 0xf740, 0xc019,	0xf77f, 0xc019,		0x21, 0
	.dw 0xf7c0, 0xc019,	0xf7ff, 0xc019,		0x21, 0
	.dw 0xf840, 0xc019,	0xf87f, 0xc019,		0x21, 0
	.dw 0xf8c0, 0xc019,	0xf8ff, 0xc019,		0x21, 0
	.dw 0xf940, 0xc019,	0xf97f, 0xc019,		0x21, 0
	.dw 0xf9c0, 0xc019,	0x1fff, 0xc01a,		0x21, 0
	.dw 0x2040, 0xc01a,	0x207f, 0xc01a,		0x21, 0
	.dw 0x20c0, 0xc01a,	0x20ff, 0xc01a,		0x21, 0
	.dw 0x2140, 0xc01a,	0x217f, 0xc01a,		0x21, 0
	.dw 0x21c0, 0xc01a,	0x21ff, 0xc01a,		0x21, 0
	.dw 0x2240, 0xc01a,	0x227f, 0xc01a,		0x21, 0
	.dw 0x22c0, 0xc01a,	0x22ff, 0xc01a,		0x21, 0
	.dw 0x2340, 0xc01a,	0x237f, 0xc01a,		0x21, 0
	.dw 0x23c0, 0xc01a,	0x23ff, 0xc01a,		0x21, 0
	.dw 0x2440, 0xc01a,	0x247f, 0xc01a,		0x21, 0
	.dw 0x24c0, 0xc01a,	0x24ff, 0xc01a,		0x21, 0
	.dw 0x2540, 0xc01a,	0x257f, 0xc01a,		0x21, 0
	.dw 0x25c0, 0xc01a,	0x25ff, 0xc01a,		0x21, 0
	.dw 0x2640, 0xc01a,	0x267f, 0xc01a,		0x21, 0
	.dw 0x26c0, 0xc01a,	0x26ff, 0xc01a,		0x21, 0
	.dw 0x2740, 0xc01a,	0x277f, 0xc01a,		0x21, 0
	.dw 0x27c0, 0xc01a,	0x27ff, 0xc01a,		0x21, 0
	.dw 0x2840, 0xc01a,	0x287f, 0xc01a,		0x21, 0
	.dw 0x28c0, 0xc01a,	0x28ff, 0xc01a,		0x21, 0
	.dw 0x2940, 0xc01a,	0x297f, 0xc01a,		0x21, 0
	.dw 0x29c0, 0xc01a,	0x29ff, 0xc01a,		0x21, 0
	.dw 0x2a40, 0xc01a,	0x2a7f, 0xc01a,		0x21, 0
	.dw 0x2ac0, 0xc01a,	0x2aff, 0xc01a,		0x21, 0
	.dw 0x2b40, 0xc01a,	0x2b7f, 0xc01a,		0x21, 0
	.dw 0x2bc0, 0xc01a,	0x2bff, 0xc01a,		0x21, 0
	.dw 0x2c40, 0xc01a,	0x2c7f, 0xc01a,		0x21, 0
	.dw 0x2cc0, 0xc01a,	0x2cff, 0xc01a,		0x21, 0
	.dw 0x2d40, 0xc01a,	0x2d7f, 0xc01a,		0x21, 0
	.dw 0x2dc0, 0xc01a,	0x2dff, 0xc01a,		0x21, 0
	.dw 0x2e40, 0xc01a,	0x2e7f, 0xc01a,		0x21, 0
	.dw 0x2ec0, 0xc01a,	0x2eff, 0xc01a,		0x21, 0
	.dw 0x2f40, 0xc01a,	0x2f7f, 0xc01a,		0x21, 0
	.dw 0x2fc0, 0xc01a,	0x2fff, 0xc01a,		0x21, 0
	.dw 0x3040, 0xc01a,	0x307f, 0xc01a,		0x21, 0
	.dw 0x30c0, 0xc01a,	0x30ff, 0xc01a,		0x21, 0
	.dw 0x3140, 0xc01a,	0x317f, 0xc01a,		0x21, 0
	.dw 0x31c0, 0xc01a,	0x31ff, 0xc01a,		0x21, 0
	.dw 0x3240, 0xc01a,	0x327f, 0xc01a,		0x21, 0
	.dw 0x32c0, 0xc01a,	0x32ff, 0xc01a,		0x21, 0
	.dw 0x3340, 0xc01a,	0x337f, 0xc01a,		0x21, 0
	.dw 0x33c0, 0xc01a,	0x33ff, 0xc01a,		0x21, 0
	.dw 0x3440, 0xc01a,	0x347f, 0xc01a,		0x21, 0
	.dw 0x34c0, 0xc01a,	0x34ff, 0xc01a,		0x21, 0
	.dw 0x3540, 0xc01a,	0x357f, 0xc01a,		0x21, 0
	.dw 0x35c0, 0xc01a,	0x35ff, 0xc01a,		0x21, 0
	.dw 0x3640, 0xc01a,	0x367f, 0xc01a,		0x21, 0
	.dw 0x36c0, 0xc01a,	0x36ff, 0xc01a,		0x21, 0
	.dw 0x3740, 0xc01a,	0x377f, 0xc01a,		0x21, 0
	.dw 0x37c0, 0xc01a,	0x37ff, 0xc01a,		0x21, 0
	.dw 0x3840, 0xc01a,	0x387f, 0xc01a,		0x21, 0
	.dw 0x38c0, 0xc01a,	0x38ff, 0xc01a,		0x21, 0
	.dw 0x3940, 0xc01a,	0x397f, 0xc01a,		0x21, 0
	.dw 0x39c0, 0xc01a,	0x5fff, 0xc01a,		0x21, 0
	.dw 0x6040, 0xc01a,	0x607f, 0xc01a,		0x21, 0
	.dw 0x60c0, 0xc01a,	0x60ff, 0xc01a,		0x21, 0
	.dw 0x6140, 0xc01a,	0x617f, 0xc01a,		0x21, 0
	.dw 0x61c0, 0xc01a,	0x61ff, 0xc01a,		0x21, 0
	.dw 0x6240, 0xc01a,	0x627f, 0xc01a,		0x21, 0
	.dw 0x62c0, 0xc01a,	0x62ff, 0xc01a,		0x21, 0
	.dw 0x6340, 0xc01a,	0x637f, 0xc01a,		0x21, 0
	.dw 0x63c0, 0xc01a,	0x63ff, 0xc01a,		0x21, 0
	.dw 0x6440, 0xc01a,	0x647f, 0xc01a,		0x21, 0
	.dw 0x64c0, 0xc01a,	0x64ff, 0xc01a,		0x21, 0
	.dw 0x6540, 0xc01a,	0x657f, 0xc01a,		0x21, 0
	.dw 0x65c0, 0xc01a,	0x65ff, 0xc01a,		0x21, 0
	.dw 0x6640, 0xc01a,	0x667f, 0xc01a,		0x21, 0
	.dw 0x66c0, 0xc01a,	0x66ff, 0xc01a,		0x21, 0
	.dw 0x6740, 0xc01a,	0x677f, 0xc01a,		0x21, 0
	.dw 0x67c0, 0xc01a,	0x67ff, 0xc01a,		0x21, 0
	.dw 0x6840, 0xc01a,	0x687f, 0xc01a,		0x21, 0
	.dw 0x68c0, 0xc01a,	0x68ff, 0xc01a,		0x21, 0
	.dw 0x6940, 0xc01a,	0x697f, 0xc01a,		0x21, 0
	.dw 0x69c0, 0xc01a,	0x69ff, 0xc01a,		0x21, 0
	.dw 0x6a40, 0xc01a,	0x6a7f, 0xc01a,		0x21, 0
	.dw 0x6ac0, 0xc01a,	0x6aff, 0xc01a,		0x21, 0
	.dw 0x6b40, 0xc01a,	0x6b7f, 0xc01a,		0x21, 0
	.dw 0x6bc0, 0xc01a,	0x6bff, 0xc01a,		0x21, 0
	.dw 0x6c40, 0xc01a,	0x6c7f, 0xc01a,		0x21, 0
	.dw 0x6cc0, 0xc01a,	0x6cff, 0xc01a,		0x21, 0
	.dw 0x6d40, 0xc01a,	0x6d7f, 0xc01a,		0x21, 0
	.dw 0x6dc0, 0xc01a,	0x6dff, 0xc01a,		0x21, 0
	.dw 0x6e40, 0xc01a,	0x6e7f, 0xc01a,		0x21, 0
	.dw 0x6ec0, 0xc01a,	0x6eff, 0xc01a,		0x21, 0
	.dw 0x6f40, 0xc01a,	0x6f7f, 0xc01a,		0x21, 0
	.dw 0x6fc0, 0xc01a,	0x6fff, 0xc01a,		0x21, 0
	.dw 0x7040, 0xc01a,	0x707f, 0xc01a,		0x21, 0
	.dw 0x70c0, 0xc01a,	0x70ff, 0xc01a,		0x21, 0
	.dw 0x7140, 0xc01a,	0x717f, 0xc01a,		0x21, 0
	.dw 0x71c0, 0xc01a,	0x71ff, 0xc01a,		0x21, 0
	.dw 0x7240, 0xc01a,	0x727f, 0xc01a,		0x21, 0
	.dw 0x72c0, 0xc01a,	0x72ff, 0xc01a,		0x21, 0
	.dw 0x7340, 0xc01a,	0x737f, 0xc01a,		0x21, 0
	.dw 0x73c0, 0xc01a,	0x73ff, 0xc01a,		0x21, 0
	.dw 0x7440, 0xc01a,	0x747f, 0xc01a,		0x21, 0
	.dw 0x74c0, 0xc01a,	0x74ff, 0xc01a,		0x21, 0
	.dw 0x7540, 0xc01a,	0x757f, 0xc01a,		0x21, 0
	.dw 0x75c0, 0xc01a,	0x75ff, 0xc01a,		0x21, 0
	.dw 0x7640, 0xc01a,	0x767f, 0xc01a,		0x21, 0
	.dw 0x76c0, 0xc01a,	0x76ff, 0xc01a,		0x21, 0
	.dw 0x7740, 0xc01a,	0x777f, 0xc01a,		0x21, 0
	.dw 0x77c0, 0xc01a,	0x77ff, 0xc01a,		0x21, 0
	.dw 0x7840, 0xc01a,	0x787f, 0xc01a,		0x21, 0
	.dw 0x78c0, 0xc01a,	0x78ff, 0xc01a,		0x21, 0
	.dw 0x7940, 0xc01a,	0x797f, 0xc01a,		0x21, 0
	.dw 0x79c0, 0xc01a,	0x9fff, 0xc01a,		0x21, 0
	.dw 0xa040, 0xc01a,	0xa07f, 0xc01a,		0x21, 0
	.dw 0xa0c0, 0xc01a,	0xa0ff, 0xc01a,		0x21, 0
	.dw 0xa140, 0xc01a,	0xa17f, 0xc01a,		0x21, 0
	.dw 0xa1c0, 0xc01a,	0xa1ff, 0xc01a,		0x21, 0
	.dw 0xa240, 0xc01a,	0xa27f, 0xc01a,		0x21, 0
	.dw 0xa2c0, 0xc01a,	0xa2ff, 0xc01a,		0x21, 0
	.dw 0xa340, 0xc01a,	0xa37f, 0xc01a,		0x21, 0
	.dw 0xa3c0, 0xc01a,	0xa3ff, 0xc01a,		0x21, 0
	.dw 0xa440, 0xc01a,	0xa47f, 0xc01a,		0x21, 0
	.dw 0xa4c0, 0xc01a,	0xa4ff, 0xc01a,		0x21, 0
	.dw 0xa540, 0xc01a,	0xa57f, 0xc01a,		0x21, 0
	.dw 0xa5c0, 0xc01a,	0xa5ff, 0xc01a,		0x21, 0
	.dw 0xa640, 0xc01a,	0xa67f, 0xc01a,		0x21, 0
	.dw 0xa6c0, 0xc01a,	0xa6ff, 0xc01a,		0x21, 0
	.dw 0xa740, 0xc01a,	0xa77f, 0xc01a,		0x21, 0
	.dw 0xa7c0, 0xc01a,	0xa7ff, 0xc01a,		0x21, 0
	.dw 0xa840, 0xc01a,	0xa87f, 0xc01a,		0x21, 0
	.dw 0xa8c0, 0xc01a,	0xa8ff, 0xc01a,		0x21, 0
	.dw 0xa940, 0xc01a,	0xa97f, 0xc01a,		0x21, 0
	.dw 0xa9c0, 0xc01a,	0xa9ff, 0xc01a,		0x21, 0
	.dw 0xaa40, 0xc01a,	0xaa7f, 0xc01a,		0x21, 0
	.dw 0xaac0, 0xc01a,	0xaaff, 0xc01a,		0x21, 0
	.dw 0xab40, 0xc01a,	0xab7f, 0xc01a,		0x21, 0
	.dw 0xabc0, 0xc01a,	0xabff, 0xc01a,		0x21, 0
	.dw 0xac40, 0xc01a,	0xac7f, 0xc01a,		0x21, 0
	.dw 0xacc0, 0xc01a,	0xacff, 0xc01a,		0x21, 0
	.dw 0xad40, 0xc01a,	0xad7f, 0xc01a,		0x21, 0
	.dw 0xadc0, 0xc01a,	0xadff, 0xc01a,		0x21, 0
	.dw 0xae40, 0xc01a,	0xae7f, 0xc01a,		0x21, 0
	.dw 0xaec0, 0xc01a,	0xaeff, 0xc01a,		0x21, 0
	.dw 0xaf40, 0xc01a,	0xaf7f, 0xc01a,		0x21, 0
	.dw 0xafc0, 0xc01a,	0xafff, 0xc01a,		0x21, 0
	.dw 0xb040, 0xc01a,	0xb07f, 0xc01a,		0x21, 0
	.dw 0xb0c0, 0xc01a,	0xb0ff, 0xc01a,		0x21, 0
	.dw 0xb140, 0xc01a,	0xb17f, 0xc01a,		0x21, 0
	.dw 0xb1c0, 0xc01a,	0xb1ff, 0xc01a,		0x21, 0
	.dw 0xb240, 0xc01a,	0xb27f, 0xc01a,		0x21, 0
	.dw 0xb2c0, 0xc01a,	0xb2ff, 0xc01a,		0x21, 0
	.dw 0xb340, 0xc01a,	0xb37f, 0xc01a,		0x21, 0
	.dw 0xb3c0, 0xc01a,	0xb3ff, 0xc01a,		0x21, 0
	.dw 0xb440, 0xc01a,	0xb47f, 0xc01a,		0x21, 0
	.dw 0xb4c0, 0xc01a,	0xb4ff, 0xc01a,		0x21, 0
	.dw 0xb540, 0xc01a,	0xb57f, 0xc01a,		0x21, 0
	.dw 0xb5c0, 0xc01a,	0xb5ff, 0xc01a,		0x21, 0
	.dw 0xb640, 0xc01a,	0xb67f, 0xc01a,		0x21, 0
	.dw 0xb6c0, 0xc01a,	0xb6ff, 0xc01a,		0x21, 0
	.dw 0xb740, 0xc01a,	0xb77f, 0xc01a,		0x21, 0
	.dw 0xb7c0, 0xc01a,	0xb7ff, 0xc01a,		0x21, 0
	.dw 0xb840, 0xc01a,	0xb87f, 0xc01a,		0x21, 0
	.dw 0xb8c0, 0xc01a,	0xb8ff, 0xc01a,		0x21, 0
	.dw 0xb940, 0xc01a,	0xb97f, 0xc01a,		0x21, 0
	.dw 0xb9c0, 0xc01a,	0xdfff, 0xc01a,		0x21, 0
	.dw 0xe040, 0xc01a,	0xe07f, 0xc01a,		0x21, 0
	.dw 0xe0c0, 0xc01a,	0xe0ff, 0xc01a,		0x21, 0
	.dw 0xe140, 0xc01a,	0xe17f, 0xc01a,		0x21, 0
	.dw 0xe1c0, 0xc01a,	0xe1ff, 0xc01a,		0x21, 0
	.dw 0xe240, 0xc01a,	0xe27f, 0xc01a,		0x21, 0
	.dw 0xe2c0, 0xc01a,	0xe2ff, 0xc01a,		0x21, 0
	.dw 0xe340, 0xc01a,	0xe37f, 0xc01a,		0x21, 0
	.dw 0xe3c0, 0xc01a,	0xe3ff, 0xc01a,		0x21, 0
	.dw 0xe440, 0xc01a,	0xe47f, 0xc01a,		0x21, 0
	.dw 0xe4c0, 0xc01a,	0xe4ff, 0xc01a,		0x21, 0
	.dw 0xe540, 0xc01a,	0xe57f, 0xc01a,		0x21, 0
	.dw 0xe5c0, 0xc01a,	0xe5ff, 0xc01a,		0x21, 0
	.dw 0xe640, 0xc01a,	0xe67f, 0xc01a,		0x21, 0
	.dw 0xe6c0, 0xc01a,	0xe6ff, 0xc01a,		0x21, 0
	.dw 0xe740, 0xc01a,	0xe77f, 0xc01a,		0x21, 0
	.dw 0xe7c0, 0xc01a,	0xe7ff, 0xc01a,		0x21, 0
	.dw 0xe840, 0xc01a,	0xe87f, 0xc01a,		0x21, 0
	.dw 0xe8c0, 0xc01a,	0xe8ff, 0xc01a,		0x21, 0
	.dw 0xe940, 0xc01a,	0xe97f, 0xc01a,		0x21, 0
	.dw 0xe9c0, 0xc01a,	0xe9ff, 0xc01a,		0x21, 0
	.dw 0xea40, 0xc01a,	0xea7f, 0xc01a,		0x21, 0
	.dw 0xeac0, 0xc01a,	0xeaff, 0xc01a,		0x21, 0
	.dw 0xeb40, 0xc01a,	0xeb7f, 0xc01a,		0x21, 0
	.dw 0xebc0, 0xc01a,	0xebff, 0xc01a,		0x21, 0
	.dw 0xec40, 0xc01a,	0xec7f, 0xc01a,		0x21, 0
	.dw 0xecc0, 0xc01a,	0xecff, 0xc01a,		0x21, 0
	.dw 0xed40, 0xc01a,	0xed7f, 0xc01a,		0x21, 0
	.dw 0xedc0, 0xc01a,	0xedff, 0xc01a,		0x21, 0
	.dw 0xee40, 0xc01a,	0xee7f, 0xc01a,		0x21, 0
	.dw 0xeec0, 0xc01a,	0xeeff, 0xc01a,		0x21, 0
	.dw 0xef40, 0xc01a,	0xef7f, 0xc01a,		0x21, 0
	.dw 0xefc0, 0xc01a,	0xefff, 0xc01a,		0x21, 0
	.dw 0xf040, 0xc01a,	0xf07f, 0xc01a,		0x21, 0
	.dw 0xf0c0, 0xc01a,	0xf0ff, 0xc01a,		0x21, 0
	.dw 0xf140, 0xc01a,	0xf17f, 0xc01a,		0x21, 0
	.dw 0xf1c0, 0xc01a,	0xf1ff, 0xc01a,		0x21, 0
	.dw 0xf240, 0xc01a,	0xf27f, 0xc01a,		0x21, 0
	.dw 0xf2c0, 0xc01a,	0xf2ff, 0xc01a,		0x21, 0
	.dw 0xf340, 0xc01a,	0xf37f, 0xc01a,		0x21, 0
	.dw 0xf3c0, 0xc01a,	0xf3ff, 0xc01a,		0x21, 0
	.dw 0xf440, 0xc01a,	0xf47f, 0xc01a,		0x21, 0
	.dw 0xf4c0, 0xc01a,	0xf4ff, 0xc01a,		0x21, 0
	.dw 0xf540, 0xc01a,	0xf57f, 0xc01a,		0x21, 0
	.dw 0xf5c0, 0xc01a,	0xf5ff, 0xc01a,		0x21, 0
	.dw 0xf640, 0xc01a,	0xf67f, 0xc01a,		0x21, 0
	.dw 0xf6c0, 0xc01a,	0xf6ff, 0xc01a,		0x21, 0
	.dw 0xf740, 0xc01a,	0xf77f, 0xc01a,		0x21, 0
	.dw 0xf7c0, 0xc01a,	0xf7ff, 0xc01a,		0x21, 0
	.dw 0xf840, 0xc01a,	0xf87f, 0xc01a,		0x21, 0
	.dw 0xf8c0, 0xc01a,	0xf8ff, 0xc01a,		0x21, 0
	.dw 0xf940, 0xc01a,	0xf97f, 0xc01a,		0x21, 0
	.dw 0xf9c0, 0xc01a,	0xffff, 0xc01b,		0x21, 0
	.dw 0x0040, 0xc01c,	0x007f, 0xc01c,		0x21, 0
	.dw 0x00c0, 0xc01c,	0x00ff, 0xc01c,		0x21, 0
	.dw 0x0140, 0xc01c,	0x017f, 0xc01c,		0x21, 0
	.dw 0x01c0, 0xc01c,	0x01ff, 0xc01c,		0x21, 0
	.dw 0x0240, 0xc01c,	0x027f, 0xc01c,		0x21, 0
	.dw 0x02c0, 0xc01c,	0x02ff, 0xc01c,		0x21, 0
	.dw 0x0340, 0xc01c,	0x037f, 0xc01c,		0x21, 0
	.dw 0x03c0, 0xc01c,	0x03ff, 0xc01c,		0x21, 0
	.dw 0x0440, 0xc01c,	0x047f, 0xc01c,		0x21, 0
	.dw 0x04c0, 0xc01c,	0x04ff, 0xc01c,		0x21, 0
	.dw 0x0540, 0xc01c,	0x057f, 0xc01c,		0x21, 0
	.dw 0x05c0, 0xc01c,	0x05ff, 0xc01c,		0x21, 0
	.dw 0x0640, 0xc01c,	0x067f, 0xc01c,		0x21, 0
	.dw 0x06c0, 0xc01c,	0x06ff, 0xc01c,		0x21, 0
	.dw 0x0740, 0xc01c,	0x077f, 0xc01c,		0x21, 0
	.dw 0x07c0, 0xc01c,	0x07ff, 0xc01c,		0x21, 0
	.dw 0x0840, 0xc01c,	0x087f, 0xc01c,		0x21, 0
	.dw 0x08c0, 0xc01c,	0x08ff, 0xc01c,		0x21, 0
	.dw 0x0940, 0xc01c,	0x097f, 0xc01c,		0x21, 0
	.dw 0x09c0, 0xc01c,	0x09ff, 0xc01c,		0x21, 0
	.dw 0x0a40, 0xc01c,	0x0a7f, 0xc01c,		0x21, 0
	.dw 0x0ac0, 0xc01c,	0x0aff, 0xc01c,		0x21, 0
	.dw 0x0b40, 0xc01c,	0x0b7f, 0xc01c,		0x21, 0
	.dw 0x0bc0, 0xc01c,	0x0bff, 0xc01c,		0x21, 0
	.dw 0x0c40, 0xc01c,	0x0c7f, 0xc01c,		0x21, 0
	.dw 0x0cc0, 0xc01c,	0x0cff, 0xc01c,		0x21, 0
	.dw 0x0d40, 0xc01c,	0x0d7f, 0xc01c,		0x21, 0
	.dw 0x0dc0, 0xc01c,	0x0dff, 0xc01c,		0x21, 0
	.dw 0x0e40, 0xc01c,	0x0e7f, 0xc01c,		0x21, 0
	.dw 0x0ec0, 0xc01c,	0x0eff, 0xc01c,		0x21, 0
	.dw 0x0f40, 0xc01c,	0x0f7f, 0xc01c,		0x21, 0
	.dw 0x0fc0, 0xc01c,	0x0fff, 0xc01c,		0x21, 0
	.dw 0x1040, 0xc01c,	0x107f, 0xc01c,		0x21, 0
	.dw 0x10c0, 0xc01c,	0x10ff, 0xc01c,		0x21, 0
	.dw 0x1140, 0xc01c,	0x117f, 0xc01c,		0x21, 0
	.dw 0x11c0, 0xc01c,	0x11ff, 0xc01c,		0x21, 0
	.dw 0x1240, 0xc01c,	0x127f, 0xc01c,		0x21, 0
	.dw 0x12c0, 0xc01c,	0x12ff, 0xc01c,		0x21, 0
	.dw 0x1340, 0xc01c,	0x137f, 0xc01c,		0x21, 0
	.dw 0x13c0, 0xc01c,	0x13ff, 0xc01c,		0x21, 0
	.dw 0x1440, 0xc01c,	0x147f, 0xc01c,		0x21, 0
	.dw 0x14c0, 0xc01c,	0x14ff, 0xc01c,		0x21, 0
	.dw 0x1540, 0xc01c,	0x157f, 0xc01c,		0x21, 0
	.dw 0x15c0, 0xc01c,	0x15ff, 0xc01c,		0x21, 0
	.dw 0x1640, 0xc01c,	0x167f, 0xc01c,		0x21, 0
	.dw 0x16c0, 0xc01c,	0x16ff, 0xc01c,		0x21, 0
	.dw 0x1740, 0xc01c,	0x177f, 0xc01c,		0x21, 0
	.dw 0x17c0, 0xc01c,	0x17ff, 0xc01c,		0x21, 0
	.dw 0x1840, 0xc01c,	0x187f, 0xc01c,		0x21, 0
	.dw 0x18c0, 0xc01c,	0x18ff, 0xc01c,		0x21, 0
	.dw 0x1940, 0xc01c,	0x197f, 0xc01c,		0x21, 0
	.dw 0x19c0, 0xc01c,	0x1fff, 0xc01c,		0x21, 0
	.dw 0x2040, 0xc01c,	0x207f, 0xc01c,		0x21, 0
	.dw 0x20c0, 0xc01c,	0x20ff, 0xc01c,		0x21, 0
	.dw 0x2140, 0xc01c,	0x217f, 0xc01c,		0x21, 0
	.dw 0x21c0, 0xc01c,	0x21ff, 0xc01c,		0x21, 0
	.dw 0x2240, 0xc01c,	0x227f, 0xc01c,		0x21, 0
	.dw 0x22c0, 0xc01c,	0x22ff, 0xc01c,		0x21, 0
	.dw 0x2340, 0xc01c,	0x237f, 0xc01c,		0x21, 0
	.dw 0x23c0, 0xc01c,	0x23ff, 0xc01c,		0x21, 0
	.dw 0x2440, 0xc01c,	0x247f, 0xc01c,		0x21, 0
	.dw 0x24c0, 0xc01c,	0x24ff, 0xc01c,		0x21, 0
	.dw 0x2540, 0xc01c,	0x257f, 0xc01c,		0x21, 0
	.dw 0x25c0, 0xc01c,	0x25ff, 0xc01c,		0x21, 0
	.dw 0x2640, 0xc01c,	0x267f, 0xc01c,		0x21, 0
	.dw 0x26c0, 0xc01c,	0x26ff, 0xc01c,		0x21, 0
	.dw 0x2740, 0xc01c,	0x277f, 0xc01c,		0x21, 0
	.dw 0x27c0, 0xc01c,	0x27ff, 0xc01c,		0x21, 0
	.dw 0x2840, 0xc01c,	0x287f, 0xc01c,		0x21, 0
	.dw 0x28c0, 0xc01c,	0x28ff, 0xc01c,		0x21, 0
	.dw 0x2940, 0xc01c,	0x297f, 0xc01c,		0x21, 0
	.dw 0x29c0, 0xc01c,	0x29ff, 0xc01c,		0x21, 0
	.dw 0x2a40, 0xc01c,	0x2a7f, 0xc01c,		0x21, 0
	.dw 0x2ac0, 0xc01c,	0x2aff, 0xc01c,		0x21, 0
	.dw 0x2b40, 0xc01c,	0x2b7f, 0xc01c,		0x21, 0
	.dw 0x2bc0, 0xc01c,	0x2bff, 0xc01c,		0x21, 0
	.dw 0x2c40, 0xc01c,	0x2c7f, 0xc01c,		0x21, 0
	.dw 0x2cc0, 0xc01c,	0x2cff, 0xc01c,		0x21, 0
	.dw 0x2d40, 0xc01c,	0x2d7f, 0xc01c,		0x21, 0
	.dw 0x2dc0, 0xc01c,	0x2dff, 0xc01c,		0x21, 0
	.dw 0x2e40, 0xc01c,	0x2e7f, 0xc01c,		0x21, 0
	.dw 0x2ec0, 0xc01c,	0x2eff, 0xc01c,		0x21, 0
	.dw 0x2f40, 0xc01c,	0x2f7f, 0xc01c,		0x21, 0
	.dw 0x2fc0, 0xc01c,	0x2fff, 0xc01c,		0x21, 0
	.dw 0x3040, 0xc01c,	0x307f, 0xc01c,		0x21, 0
	.dw 0x30c0, 0xc01c,	0x30ff, 0xc01c,		0x21, 0
	.dw 0x3140, 0xc01c,	0x317f, 0xc01c,		0x21, 0
	.dw 0x31c0, 0xc01c,	0x31ff, 0xc01c,		0x21, 0
	.dw 0x3240, 0xc01c,	0x327f, 0xc01c,		0x21, 0
	.dw 0x32c0, 0xc01c,	0x32ff, 0xc01c,		0x21, 0
	.dw 0x3340, 0xc01c,	0x337f, 0xc01c,		0x21, 0
	.dw 0x33c0, 0xc01c,	0x33ff, 0xc01c,		0x21, 0
	.dw 0x3440, 0xc01c,	0x347f, 0xc01c,		0x21, 0
	.dw 0x34c0, 0xc01c,	0x34ff, 0xc01c,		0x21, 0
	.dw 0x3540, 0xc01c,	0x357f, 0xc01c,		0x21, 0
	.dw 0x35c0, 0xc01c,	0x35ff, 0xc01c,		0x21, 0
	.dw 0x3640, 0xc01c,	0x367f, 0xc01c,		0x21, 0
	.dw 0x36c0, 0xc01c,	0x36ff, 0xc01c,		0x21, 0
	.dw 0x3740, 0xc01c,	0x377f, 0xc01c,		0x21, 0
	.dw 0x37c0, 0xc01c,	0x37ff, 0xc01c,		0x21, 0
	.dw 0x3840, 0xc01c,	0x387f, 0xc01c,		0x21, 0
	.dw 0x38c0, 0xc01c,	0x38ff, 0xc01c,		0x21, 0
	.dw 0x3940, 0xc01c,	0x397f, 0xc01c,		0x21, 0
	.dw 0x39c0, 0xc01c,	0x3fff, 0xc01c,		0x21, 0
	.dw 0x4040, 0xc01c,	0x407f, 0xc01c,		0x21, 0
	.dw 0x40c0, 0xc01c,	0x40ff, 0xc01c,		0x21, 0
	.dw 0x4140, 0xc01c,	0x417f, 0xc01c,		0x21, 0
	.dw 0x41c0, 0xc01c,	0x41ff, 0xc01c,		0x21, 0
	.dw 0x4240, 0xc01c,	0x427f, 0xc01c,		0x21, 0
	.dw 0x42c0, 0xc01c,	0x42ff, 0xc01c,		0x21, 0
	.dw 0x4340, 0xc01c,	0x437f, 0xc01c,		0x21, 0
	.dw 0x43c0, 0xc01c,	0x43ff, 0xc01c,		0x21, 0
	.dw 0x4440, 0xc01c,	0x447f, 0xc01c,		0x21, 0
	.dw 0x44c0, 0xc01c,	0x44ff, 0xc01c,		0x21, 0
	.dw 0x4540, 0xc01c,	0x457f, 0xc01c,		0x21, 0
	.dw 0x45c0, 0xc01c,	0x45ff, 0xc01c,		0x21, 0
	.dw 0x4640, 0xc01c,	0x467f, 0xc01c,		0x21, 0
	.dw 0x46c0, 0xc01c,	0x46ff, 0xc01c,		0x21, 0
	.dw 0x4740, 0xc01c,	0x477f, 0xc01c,		0x21, 0
	.dw 0x47c0, 0xc01c,	0x47ff, 0xc01c,		0x21, 0
	.dw 0x4840, 0xc01c,	0x487f, 0xc01c,		0x21, 0
	.dw 0x48c0, 0xc01c,	0x48ff, 0xc01c,		0x21, 0
	.dw 0x4940, 0xc01c,	0x497f, 0xc01c,		0x21, 0
	.dw 0x49c0, 0xc01c,	0x49ff, 0xc01c,		0x21, 0
	.dw 0x4a40, 0xc01c,	0x4a7f, 0xc01c,		0x21, 0
	.dw 0x4ac0, 0xc01c,	0x4aff, 0xc01c,		0x21, 0
	.dw 0x4b40, 0xc01c,	0x4b7f, 0xc01c,		0x21, 0
	.dw 0x4bc0, 0xc01c,	0x4bff, 0xc01c,		0x21, 0
	.dw 0x4c40, 0xc01c,	0x4c7f, 0xc01c,		0x21, 0
	.dw 0x4cc0, 0xc01c,	0x4cff, 0xc01c,		0x21, 0
	.dw 0x4d40, 0xc01c,	0x4d7f, 0xc01c,		0x21, 0
	.dw 0x4dc0, 0xc01c,	0x4dff, 0xc01c,		0x21, 0
	.dw 0x4e40, 0xc01c,	0x4e7f, 0xc01c,		0x21, 0
	.dw 0x4ec0, 0xc01c,	0x4eff, 0xc01c,		0x21, 0
	.dw 0x4f40, 0xc01c,	0x4f7f, 0xc01c,		0x21, 0
	.dw 0x4fc0, 0xc01c,	0x4fff, 0xc01c,		0x21, 0
	.dw 0x5040, 0xc01c,	0x507f, 0xc01c,		0x21, 0
	.dw 0x50c0, 0xc01c,	0x50ff, 0xc01c,		0x21, 0
	.dw 0x5140, 0xc01c,	0x517f, 0xc01c,		0x21, 0
	.dw 0x51c0, 0xc01c,	0x51ff, 0xc01c,		0x21, 0
	.dw 0x5240, 0xc01c,	0x527f, 0xc01c,		0x21, 0
	.dw 0x52c0, 0xc01c,	0x52ff, 0xc01c,		0x21, 0
	.dw 0x5340, 0xc01c,	0x537f, 0xc01c,		0x21, 0
	.dw 0x53c0, 0xc01c,	0x53ff, 0xc01c,		0x21, 0
	.dw 0x5440, 0xc01c,	0x547f, 0xc01c,		0x21, 0
	.dw 0x54c0, 0xc01c,	0x54ff, 0xc01c,		0x21, 0
	.dw 0x5540, 0xc01c,	0x557f, 0xc01c,		0x21, 0
	.dw 0x55c0, 0xc01c,	0x55ff, 0xc01c,		0x21, 0
	.dw 0x5640, 0xc01c,	0x567f, 0xc01c,		0x21, 0
	.dw 0x56c0, 0xc01c,	0x56ff, 0xc01c,		0x21, 0
	.dw 0x5740, 0xc01c,	0x577f, 0xc01c,		0x21, 0
	.dw 0x57c0, 0xc01c,	0x57ff, 0xc01c,		0x21, 0
	.dw 0x5840, 0xc01c,	0x587f, 0xc01c,		0x21, 0
	.dw 0x58c0, 0xc01c,	0x58ff, 0xc01c,		0x21, 0
	.dw 0x5940, 0xc01c,	0x597f, 0xc01c,		0x21, 0
	.dw 0x59c0, 0xc01c,	0x5fff, 0xc01c,		0x21, 0
	.dw 0x6040, 0xc01c,	0x607f, 0xc01c,		0x21, 0
	.dw 0x60c0, 0xc01c,	0x60ff, 0xc01c,		0x21, 0
	.dw 0x6140, 0xc01c,	0x617f, 0xc01c,		0x21, 0
	.dw 0x61c0, 0xc01c,	0x61ff, 0xc01c,		0x21, 0
	.dw 0x6240, 0xc01c,	0x627f, 0xc01c,		0x21, 0
	.dw 0x62c0, 0xc01c,	0x62ff, 0xc01c,		0x21, 0
	.dw 0x6340, 0xc01c,	0x637f, 0xc01c,		0x21, 0
	.dw 0x63c0, 0xc01c,	0x63ff, 0xc01c,		0x21, 0
	.dw 0x6440, 0xc01c,	0x647f, 0xc01c,		0x21, 0
	.dw 0x64c0, 0xc01c,	0x64ff, 0xc01c,		0x21, 0
	.dw 0x6540, 0xc01c,	0x657f, 0xc01c,		0x21, 0
	.dw 0x65c0, 0xc01c,	0x65ff, 0xc01c,		0x21, 0
	.dw 0x6640, 0xc01c,	0x667f, 0xc01c,		0x21, 0
	.dw 0x66c0, 0xc01c,	0x66ff, 0xc01c,		0x21, 0
	.dw 0x6740, 0xc01c,	0x677f, 0xc01c,		0x21, 0
	.dw 0x67c0, 0xc01c,	0x67ff, 0xc01c,		0x21, 0
	.dw 0x6840, 0xc01c,	0x687f, 0xc01c,		0x21, 0
	.dw 0x68c0, 0xc01c,	0x68ff, 0xc01c,		0x21, 0
	.dw 0x6940, 0xc01c,	0x697f, 0xc01c,		0x21, 0
	.dw 0x69c0, 0xc01c,	0x69ff, 0xc01c,		0x21, 0
	.dw 0x6a40, 0xc01c,	0x6a7f, 0xc01c,		0x21, 0
	.dw 0x6ac0, 0xc01c,	0x6aff, 0xc01c,		0x21, 0
	.dw 0x6b40, 0xc01c,	0x6b7f, 0xc01c,		0x21, 0
	.dw 0x6bc0, 0xc01c,	0x6bff, 0xc01c,		0x21, 0
	.dw 0x6c40, 0xc01c,	0x6c7f, 0xc01c,		0x21, 0
	.dw 0x6cc0, 0xc01c,	0x6cff, 0xc01c,		0x21, 0
	.dw 0x6d40, 0xc01c,	0x6d7f, 0xc01c,		0x21, 0
	.dw 0x6dc0, 0xc01c,	0x6dff, 0xc01c,		0x21, 0
	.dw 0x6e40, 0xc01c,	0x6e7f, 0xc01c,		0x21, 0
	.dw 0x6ec0, 0xc01c,	0x6eff, 0xc01c,		0x21, 0
	.dw 0x6f40, 0xc01c,	0x6f7f, 0xc01c,		0x21, 0
	.dw 0x6fc0, 0xc01c,	0x6fff, 0xc01c,		0x21, 0
	.dw 0x7040, 0xc01c,	0x707f, 0xc01c,		0x21, 0
	.dw 0x70c0, 0xc01c,	0x70ff, 0xc01c,		0x21, 0
	.dw 0x7140, 0xc01c,	0x717f, 0xc01c,		0x21, 0
	.dw 0x71c0, 0xc01c,	0x71ff, 0xc01c,		0x21, 0
	.dw 0x7240, 0xc01c,	0x727f, 0xc01c,		0x21, 0
	.dw 0x72c0, 0xc01c,	0x72ff, 0xc01c,		0x21, 0
	.dw 0x7340, 0xc01c,	0x737f, 0xc01c,		0x21, 0
	.dw 0x73c0, 0xc01c,	0x73ff, 0xc01c,		0x21, 0
	.dw 0x7440, 0xc01c,	0x747f, 0xc01c,		0x21, 0
	.dw 0x74c0, 0xc01c,	0x74ff, 0xc01c,		0x21, 0
	.dw 0x7540, 0xc01c,	0x757f, 0xc01c,		0x21, 0
	.dw 0x75c0, 0xc01c,	0x75ff, 0xc01c,		0x21, 0
	.dw 0x7640, 0xc01c,	0x767f, 0xc01c,		0x21, 0
	.dw 0x76c0, 0xc01c,	0x76ff, 0xc01c,		0x21, 0
	.dw 0x7740, 0xc01c,	0x777f, 0xc01c,		0x21, 0
	.dw 0x77c0, 0xc01c,	0x77ff, 0xc01c,		0x21, 0
	.dw 0x7840, 0xc01c,	0x787f, 0xc01c,		0x21, 0
	.dw 0x78c0, 0xc01c,	0x78ff, 0xc01c,		0x21, 0
	.dw 0x7940, 0xc01c,	0x797f, 0xc01c,		0x21, 0
	.dw 0x79c0, 0xc01c,	0x7fff, 0xc01c,		0x21, 0
	.dw 0x8040, 0xc01c,	0x807f, 0xc01c,		0x21, 0
	.dw 0x80c0, 0xc01c,	0x80ff, 0xc01c,		0x21, 0
	.dw 0x8140, 0xc01c,	0x817f, 0xc01c,		0x21, 0
	.dw 0x81c0, 0xc01c,	0x81ff, 0xc01c,		0x21, 0
	.dw 0x8240, 0xc01c,	0x827f, 0xc01c,		0x21, 0
	.dw 0x82c0, 0xc01c,	0x82ff, 0xc01c,		0x21, 0
	.dw 0x8340, 0xc01c,	0x837f, 0xc01c,		0x21, 0
	.dw 0x83c0, 0xc01c,	0x83ff, 0xc01c,		0x21, 0
	.dw 0x8440, 0xc01c,	0x847f, 0xc01c,		0x21, 0
	.dw 0x84c0, 0xc01c,	0x84ff, 0xc01c,		0x21, 0
	.dw 0x8540, 0xc01c,	0x857f, 0xc01c,		0x21, 0
	.dw 0x85c0, 0xc01c,	0x85ff, 0xc01c,		0x21, 0
	.dw 0x8640, 0xc01c,	0x867f, 0xc01c,		0x21, 0
	.dw 0x86c0, 0xc01c,	0x86ff, 0xc01c,		0x21, 0
	.dw 0x8740, 0xc01c,	0x877f, 0xc01c,		0x21, 0
	.dw 0x87c0, 0xc01c,	0x87ff, 0xc01c,		0x21, 0
	.dw 0x8840, 0xc01c,	0x887f, 0xc01c,		0x21, 0
	.dw 0x88c0, 0xc01c,	0x88ff, 0xc01c,		0x21, 0
	.dw 0x8940, 0xc01c,	0x897f, 0xc01c,		0x21, 0
	.dw 0x89c0, 0xc01c,	0x89ff, 0xc01c,		0x21, 0
	.dw 0x8a40, 0xc01c,	0x8a7f, 0xc01c,		0x21, 0
	.dw 0x8ac0, 0xc01c,	0x8aff, 0xc01c,		0x21, 0
	.dw 0x8b40, 0xc01c,	0x8b7f, 0xc01c,		0x21, 0
	.dw 0x8bc0, 0xc01c,	0x8bff, 0xc01c,		0x21, 0
	.dw 0x8c40, 0xc01c,	0x8c7f, 0xc01c,		0x21, 0
	.dw 0x8cc0, 0xc01c,	0x8cff, 0xc01c,		0x21, 0
	.dw 0x8d40, 0xc01c,	0x8d7f, 0xc01c,		0x21, 0
	.dw 0x8dc0, 0xc01c,	0x8dff, 0xc01c,		0x21, 0
	.dw 0x8e40, 0xc01c,	0x8e7f, 0xc01c,		0x21, 0
	.dw 0x8ec0, 0xc01c,	0x8eff, 0xc01c,		0x21, 0
	.dw 0x8f40, 0xc01c,	0x8f7f, 0xc01c,		0x21, 0
	.dw 0x8fc0, 0xc01c,	0x8fff, 0xc01c,		0x21, 0
	.dw 0x9040, 0xc01c,	0x907f, 0xc01c,		0x21, 0
	.dw 0x90c0, 0xc01c,	0x90ff, 0xc01c,		0x21, 0
	.dw 0x9140, 0xc01c,	0x917f, 0xc01c,		0x21, 0
	.dw 0x91c0, 0xc01c,	0x91ff, 0xc01c,		0x21, 0
	.dw 0x9240, 0xc01c,	0x927f, 0xc01c,		0x21, 0
	.dw 0x92c0, 0xc01c,	0x92ff, 0xc01c,		0x21, 0
	.dw 0x9340, 0xc01c,	0x937f, 0xc01c,		0x21, 0
	.dw 0x93c0, 0xc01c,	0x93ff, 0xc01c,		0x21, 0
	.dw 0x9440, 0xc01c,	0x947f, 0xc01c,		0x21, 0
	.dw 0x94c0, 0xc01c,	0x94ff, 0xc01c,		0x21, 0
	.dw 0x9540, 0xc01c,	0x957f, 0xc01c,		0x21, 0
	.dw 0x95c0, 0xc01c,	0x95ff, 0xc01c,		0x21, 0
	.dw 0x9640, 0xc01c,	0x967f, 0xc01c,		0x21, 0
	.dw 0x96c0, 0xc01c,	0x96ff, 0xc01c,		0x21, 0
	.dw 0x9740, 0xc01c,	0x977f, 0xc01c,		0x21, 0
	.dw 0x97c0, 0xc01c,	0x97ff, 0xc01c,		0x21, 0
	.dw 0x9840, 0xc01c,	0x987f, 0xc01c,		0x21, 0
	.dw 0x98c0, 0xc01c,	0x98ff, 0xc01c,		0x21, 0
	.dw 0x9940, 0xc01c,	0x997f, 0xc01c,		0x21, 0
	.dw 0x99c0, 0xc01c,	0x9fff, 0xc01c,		0x21, 0
	.dw 0xa040, 0xc01c,	0xa07f, 0xc01c,		0x21, 0
	.dw 0xa0c0, 0xc01c,	0xa0ff, 0xc01c,		0x21, 0
	.dw 0xa140, 0xc01c,	0xa17f, 0xc01c,		0x21, 0
	.dw 0xa1c0, 0xc01c,	0xa1ff, 0xc01c,		0x21, 0
	.dw 0xa240, 0xc01c,	0xa27f, 0xc01c,		0x21, 0
	.dw 0xa2c0, 0xc01c,	0xa2ff, 0xc01c,		0x21, 0
	.dw 0xa340, 0xc01c,	0xa37f, 0xc01c,		0x21, 0
	.dw 0xa3c0, 0xc01c,	0xa3ff, 0xc01c,		0x21, 0
	.dw 0xa440, 0xc01c,	0xa47f, 0xc01c,		0x21, 0
	.dw 0xa4c0, 0xc01c,	0xa4ff, 0xc01c,		0x21, 0
	.dw 0xa540, 0xc01c,	0xa57f, 0xc01c,		0x21, 0
	.dw 0xa5c0, 0xc01c,	0xa5ff, 0xc01c,		0x21, 0
	.dw 0xa640, 0xc01c,	0xa67f, 0xc01c,		0x21, 0
	.dw 0xa6c0, 0xc01c,	0xa6ff, 0xc01c,		0x21, 0
	.dw 0xa740, 0xc01c,	0xa77f, 0xc01c,		0x21, 0
	.dw 0xa7c0, 0xc01c,	0xa7ff, 0xc01c,		0x21, 0
	.dw 0xa840, 0xc01c,	0xa87f, 0xc01c,		0x21, 0
	.dw 0xa8c0, 0xc01c,	0xa8ff, 0xc01c,		0x21, 0
	.dw 0xa940, 0xc01c,	0xa97f, 0xc01c,		0x21, 0
	.dw 0xa9c0, 0xc01c,	0xa9ff, 0xc01c,		0x21, 0
	.dw 0xaa40, 0xc01c,	0xaa7f, 0xc01c,		0x21, 0
	.dw 0xaac0, 0xc01c,	0xaaff, 0xc01c,		0x21, 0
	.dw 0xab40, 0xc01c,	0xab7f, 0xc01c,		0x21, 0
	.dw 0xabc0, 0xc01c,	0xabff, 0xc01c,		0x21, 0
	.dw 0xac40, 0xc01c,	0xac7f, 0xc01c,		0x21, 0
	.dw 0xacc0, 0xc01c,	0xacff, 0xc01c,		0x21, 0
	.dw 0xad40, 0xc01c,	0xad7f, 0xc01c,		0x21, 0
	.dw 0xadc0, 0xc01c,	0xadff, 0xc01c,		0x21, 0
	.dw 0xae40, 0xc01c,	0xae7f, 0xc01c,		0x21, 0
	.dw 0xaec0, 0xc01c,	0xaeff, 0xc01c,		0x21, 0
	.dw 0xaf40, 0xc01c,	0xaf7f, 0xc01c,		0x21, 0
	.dw 0xafc0, 0xc01c,	0xafff, 0xc01c,		0x21, 0
	.dw 0xb040, 0xc01c,	0xb07f, 0xc01c,		0x21, 0
	.dw 0xb0c0, 0xc01c,	0xb0ff, 0xc01c,		0x21, 0
	.dw 0xb140, 0xc01c,	0xb17f, 0xc01c,		0x21, 0
	.dw 0xb1c0, 0xc01c,	0xb1ff, 0xc01c,		0x21, 0
	.dw 0xb240, 0xc01c,	0xb27f, 0xc01c,		0x21, 0
	.dw 0xb2c0, 0xc01c,	0xb2ff, 0xc01c,		0x21, 0
	.dw 0xb340, 0xc01c,	0xb37f, 0xc01c,		0x21, 0
	.dw 0xb3c0, 0xc01c,	0xb3ff, 0xc01c,		0x21, 0
	.dw 0xb440, 0xc01c,	0xb47f, 0xc01c,		0x21, 0
	.dw 0xb4c0, 0xc01c,	0xb4ff, 0xc01c,		0x21, 0
	.dw 0xb540, 0xc01c,	0xb57f, 0xc01c,		0x21, 0
	.dw 0xb5c0, 0xc01c,	0xb5ff, 0xc01c,		0x21, 0
	.dw 0xb640, 0xc01c,	0xb67f, 0xc01c,		0x21, 0
	.dw 0xb6c0, 0xc01c,	0xb6ff, 0xc01c,		0x21, 0
	.dw 0xb740, 0xc01c,	0xb77f, 0xc01c,		0x21, 0
	.dw 0xb7c0, 0xc01c,	0xb7ff, 0xc01c,		0x21, 0
	.dw 0xb840, 0xc01c,	0xb87f, 0xc01c,		0x21, 0
	.dw 0xb8c0, 0xc01c,	0xb8ff, 0xc01c,		0x21, 0
	.dw 0xb940, 0xc01c,	0xb97f, 0xc01c,		0x21, 0
	.dw 0xb9c0, 0xc01c,	0xbfff, 0xc01c,		0x21, 0
	.dw 0xc040, 0xc01c,	0xc07f, 0xc01c,		0x21, 0
	.dw 0xc0c0, 0xc01c,	0xc0ff, 0xc01c,		0x21, 0
	.dw 0xc140, 0xc01c,	0xc17f, 0xc01c,		0x21, 0
	.dw 0xc1c0, 0xc01c,	0xc1ff, 0xc01c,		0x21, 0
	.dw 0xc240, 0xc01c,	0xc27f, 0xc01c,		0x21, 0
	.dw 0xc2c0, 0xc01c,	0xc2ff, 0xc01c,		0x21, 0
	.dw 0xc340, 0xc01c,	0xc37f, 0xc01c,		0x21, 0
	.dw 0xc3c0, 0xc01c,	0xc3ff, 0xc01c,		0x21, 0
	.dw 0xc440, 0xc01c,	0xc47f, 0xc01c,		0x21, 0
	.dw 0xc4c0, 0xc01c,	0xc4ff, 0xc01c,		0x21, 0
	.dw 0xc540, 0xc01c,	0xc57f, 0xc01c,		0x21, 0
	.dw 0xc5c0, 0xc01c,	0xc5ff, 0xc01c,		0x21, 0
	.dw 0xc640, 0xc01c,	0xc67f, 0xc01c,		0x21, 0
	.dw 0xc6c0, 0xc01c,	0xc6ff, 0xc01c,		0x21, 0
	.dw 0xc740, 0xc01c,	0xc77f, 0xc01c,		0x21, 0
	.dw 0xc7c0, 0xc01c,	0xc7ff, 0xc01c,		0x21, 0
	.dw 0xc840, 0xc01c,	0xc87f, 0xc01c,		0x21, 0
	.dw 0xc8c0, 0xc01c,	0xc8ff, 0xc01c,		0x21, 0
	.dw 0xc940, 0xc01c,	0xc97f, 0xc01c,		0x21, 0
	.dw 0xc9c0, 0xc01c,	0xc9ff, 0xc01c,		0x21, 0
	.dw 0xca40, 0xc01c,	0xca7f, 0xc01c,		0x21, 0
	.dw 0xcac0, 0xc01c,	0xcaff, 0xc01c,		0x21, 0
	.dw 0xcb40, 0xc01c,	0xcb7f, 0xc01c,		0x21, 0
	.dw 0xcbc0, 0xc01c,	0xcbff, 0xc01c,		0x21, 0
	.dw 0xcc40, 0xc01c,	0xcc7f, 0xc01c,		0x21, 0
	.dw 0xccc0, 0xc01c,	0xccff, 0xc01c,		0x21, 0
	.dw 0xcd40, 0xc01c,	0xcd7f, 0xc01c,		0x21, 0
	.dw 0xcdc0, 0xc01c,	0xcdff, 0xc01c,		0x21, 0
	.dw 0xce40, 0xc01c,	0xce7f, 0xc01c,		0x21, 0
	.dw 0xcec0, 0xc01c,	0xceff, 0xc01c,		0x21, 0
	.dw 0xcf40, 0xc01c,	0xcf7f, 0xc01c,		0x21, 0
	.dw 0xcfc0, 0xc01c,	0xcfff, 0xc01c,		0x21, 0
	.dw 0xd040, 0xc01c,	0xd07f, 0xc01c,		0x21, 0
	.dw 0xd0c0, 0xc01c,	0xd0ff, 0xc01c,		0x21, 0
	.dw 0xd140, 0xc01c,	0xd17f, 0xc01c,		0x21, 0
	.dw 0xd1c0, 0xc01c,	0xd1ff, 0xc01c,		0x21, 0
	.dw 0xd240, 0xc01c,	0xd27f, 0xc01c,		0x21, 0
	.dw 0xd2c0, 0xc01c,	0xd2ff, 0xc01c,		0x21, 0
	.dw 0xd340, 0xc01c,	0xd37f, 0xc01c,		0x21, 0
	.dw 0xd3c0, 0xc01c,	0xd3ff, 0xc01c,		0x21, 0
	.dw 0xd440, 0xc01c,	0xd47f, 0xc01c,		0x21, 0
	.dw 0xd4c0, 0xc01c,	0xd4ff, 0xc01c,		0x21, 0
	.dw 0xd540, 0xc01c,	0xd57f, 0xc01c,		0x21, 0
	.dw 0xd5c0, 0xc01c,	0xd5ff, 0xc01c,		0x21, 0
	.dw 0xd640, 0xc01c,	0xd67f, 0xc01c,		0x21, 0
	.dw 0xd6c0, 0xc01c,	0xd6ff, 0xc01c,		0x21, 0
	.dw 0xd740, 0xc01c,	0xd77f, 0xc01c,		0x21, 0
	.dw 0xd7c0, 0xc01c,	0xd7ff, 0xc01c,		0x21, 0
	.dw 0xd840, 0xc01c,	0xd87f, 0xc01c,		0x21, 0
	.dw 0xd8c0, 0xc01c,	0xd8ff, 0xc01c,		0x21, 0
	.dw 0xd940, 0xc01c,	0xd97f, 0xc01c,		0x21, 0
	.dw 0xd9c0, 0xc01c,	0xdfff, 0xc01c,		0x21, 0
	.dw 0xe040, 0xc01c,	0xe07f, 0xc01c,		0x21, 0
	.dw 0xe0c0, 0xc01c,	0xe0ff, 0xc01c,		0x21, 0
	.dw 0xe140, 0xc01c,	0xe17f, 0xc01c,		0x21, 0
	.dw 0xe1c0, 0xc01c,	0xe1ff, 0xc01c,		0x21, 0
	.dw 0xe240, 0xc01c,	0xe27f, 0xc01c,		0x21, 0
	.dw 0xe2c0, 0xc01c,	0xe2ff, 0xc01c,		0x21, 0
	.dw 0xe340, 0xc01c,	0xe37f, 0xc01c,		0x21, 0
	.dw 0xe3c0, 0xc01c,	0xe3ff, 0xc01c,		0x21, 0
	.dw 0xe440, 0xc01c,	0xe47f, 0xc01c,		0x21, 0
	.dw 0xe4c0, 0xc01c,	0xe4ff, 0xc01c,		0x21, 0
	.dw 0xe540, 0xc01c,	0xe57f, 0xc01c,		0x21, 0
	.dw 0xe5c0, 0xc01c,	0xe5ff, 0xc01c,		0x21, 0
	.dw 0xe640, 0xc01c,	0xe67f, 0xc01c,		0x21, 0
	.dw 0xe6c0, 0xc01c,	0xe6ff, 0xc01c,		0x21, 0
	.dw 0xe740, 0xc01c,	0xe77f, 0xc01c,		0x21, 0
	.dw 0xe7c0, 0xc01c,	0xe7ff, 0xc01c,		0x21, 0
	.dw 0xe840, 0xc01c,	0xe87f, 0xc01c,		0x21, 0
	.dw 0xe8c0, 0xc01c,	0xe8ff, 0xc01c,		0x21, 0
	.dw 0xe940, 0xc01c,	0xe97f, 0xc01c,		0x21, 0
	.dw 0xe9c0, 0xc01c,	0xe9ff, 0xc01c,		0x21, 0
	.dw 0xea40, 0xc01c,	0xea7f, 0xc01c,		0x21, 0
	.dw 0xeac0, 0xc01c,	0xeaff, 0xc01c,		0x21, 0
	.dw 0xeb40, 0xc01c,	0xeb7f, 0xc01c,		0x21, 0
	.dw 0xebc0, 0xc01c,	0xebff, 0xc01c,		0x21, 0
	.dw 0xec40, 0xc01c,	0xec7f, 0xc01c,		0x21, 0
	.dw 0xecc0, 0xc01c,	0xecff, 0xc01c,		0x21, 0
	.dw 0xed40, 0xc01c,	0xed7f, 0xc01c,		0x21, 0
	.dw 0xedc0, 0xc01c,	0xedff, 0xc01c,		0x21, 0
	.dw 0xee40, 0xc01c,	0xee7f, 0xc01c,		0x21, 0
	.dw 0xeec0, 0xc01c,	0xeeff, 0xc01c,		0x21, 0
	.dw 0xef40, 0xc01c,	0xef7f, 0xc01c,		0x21, 0
	.dw 0xefc0, 0xc01c,	0xefff, 0xc01c,		0x21, 0
	.dw 0xf040, 0xc01c,	0xf07f, 0xc01c,		0x21, 0
	.dw 0xf0c0, 0xc01c,	0xf0ff, 0xc01c,		0x21, 0
	.dw 0xf140, 0xc01c,	0xf17f, 0xc01c,		0x21, 0
	.dw 0xf1c0, 0xc01c,	0xf1ff, 0xc01c,		0x21, 0
	.dw 0xf240, 0xc01c,	0xf27f, 0xc01c,		0x21, 0
	.dw 0xf2c0, 0xc01c,	0xf2ff, 0xc01c,		0x21, 0
	.dw 0xf340, 0xc01c,	0xf37f, 0xc01c,		0x21, 0
	.dw 0xf3c0, 0xc01c,	0xf3ff, 0xc01c,		0x21, 0
	.dw 0xf440, 0xc01c,	0xf47f, 0xc01c,		0x21, 0
	.dw 0xf4c0, 0xc01c,	0xf4ff, 0xc01c,		0x21, 0
	.dw 0xf540, 0xc01c,	0xf57f, 0xc01c,		0x21, 0
	.dw 0xf5c0, 0xc01c,	0xf5ff, 0xc01c,		0x21, 0
	.dw 0xf640, 0xc01c,	0xf67f, 0xc01c,		0x21, 0
	.dw 0xf6c0, 0xc01c,	0xf6ff, 0xc01c,		0x21, 0
	.dw 0xf740, 0xc01c,	0xf77f, 0xc01c,		0x21, 0
	.dw 0xf7c0, 0xc01c,	0xf7ff, 0xc01c,		0x21, 0
	.dw 0xf840, 0xc01c,	0xf87f, 0xc01c,		0x21, 0
	.dw 0xf8c0, 0xc01c,	0xf8ff, 0xc01c,		0x21, 0
	.dw 0xf940, 0xc01c,	0xf97f, 0xc01c,		0x21, 0
	.dw 0xf9c0, 0xc01c,	0xffff, 0xc01c,		0x21, 0
	.dw 0x0040, 0xc01d,	0x007f, 0xc01d,		0x21, 0
	.dw 0x00c0, 0xc01d,	0x00ff, 0xc01d,		0x21, 0
	.dw 0x0140, 0xc01d,	0x017f, 0xc01d,		0x21, 0
	.dw 0x01c0, 0xc01d,	0x01ff, 0xc01d,		0x21, 0
	.dw 0x0240, 0xc01d,	0x027f, 0xc01d,		0x21, 0
	.dw 0x02c0, 0xc01d,	0x02ff, 0xc01d,		0x21, 0
	.dw 0x0340, 0xc01d,	0x037f, 0xc01d,		0x21, 0
	.dw 0x03c0, 0xc01d,	0x03ff, 0xc01d,		0x21, 0
	.dw 0x0440, 0xc01d,	0x047f, 0xc01d,		0x21, 0
	.dw 0x04c0, 0xc01d,	0x04ff, 0xc01d,		0x21, 0
	.dw 0x0540, 0xc01d,	0x057f, 0xc01d,		0x21, 0
	.dw 0x05c0, 0xc01d,	0x05ff, 0xc01d,		0x21, 0
	.dw 0x0640, 0xc01d,	0x067f, 0xc01d,		0x21, 0
	.dw 0x06c0, 0xc01d,	0x06ff, 0xc01d,		0x21, 0
	.dw 0x0740, 0xc01d,	0x077f, 0xc01d,		0x21, 0
	.dw 0x07c0, 0xc01d,	0x07ff, 0xc01d,		0x21, 0
	.dw 0x0840, 0xc01d,	0x087f, 0xc01d,		0x21, 0
	.dw 0x08c0, 0xc01d,	0x08ff, 0xc01d,		0x21, 0
	.dw 0x0940, 0xc01d,	0x097f, 0xc01d,		0x21, 0
	.dw 0x09c0, 0xc01d,	0x09ff, 0xc01d,		0x21, 0
	.dw 0x0a40, 0xc01d,	0x0a7f, 0xc01d,		0x21, 0
	.dw 0x0ac0, 0xc01d,	0x0aff, 0xc01d,		0x21, 0
	.dw 0x0b40, 0xc01d,	0x0b7f, 0xc01d,		0x21, 0
	.dw 0x0bc0, 0xc01d,	0x0bff, 0xc01d,		0x21, 0
	.dw 0x0c40, 0xc01d,	0x0c7f, 0xc01d,		0x21, 0
	.dw 0x0cc0, 0xc01d,	0x0cff, 0xc01d,		0x21, 0
	.dw 0x0d40, 0xc01d,	0x0d7f, 0xc01d,		0x21, 0
	.dw 0x0dc0, 0xc01d,	0x0dff, 0xc01d,		0x21, 0
	.dw 0x0e40, 0xc01d,	0x0e7f, 0xc01d,		0x21, 0
	.dw 0x0ec0, 0xc01d,	0x0eff, 0xc01d,		0x21, 0
	.dw 0x0f40, 0xc01d,	0x0f7f, 0xc01d,		0x21, 0
	.dw 0x0fc0, 0xc01d,	0x0fff, 0xc01d,		0x21, 0
	.dw 0x1040, 0xc01d,	0x107f, 0xc01d,		0x21, 0
	.dw 0x10c0, 0xc01d,	0x10ff, 0xc01d,		0x21, 0
	.dw 0x1140, 0xc01d,	0x117f, 0xc01d,		0x21, 0
	.dw 0x11c0, 0xc01d,	0x11ff, 0xc01d,		0x21, 0
	.dw 0x1240, 0xc01d,	0x127f, 0xc01d,		0x21, 0
	.dw 0x12c0, 0xc01d,	0x12ff, 0xc01d,		0x21, 0
	.dw 0x1340, 0xc01d,	0x137f, 0xc01d,		0x21, 0
	.dw 0x13c0, 0xc01d,	0x13ff, 0xc01d,		0x21, 0
	.dw 0x1440, 0xc01d,	0x147f, 0xc01d,		0x21, 0
	.dw 0x14c0, 0xc01d,	0x14ff, 0xc01d,		0x21, 0
	.dw 0x1540, 0xc01d,	0x157f, 0xc01d,		0x21, 0
	.dw 0x15c0, 0xc01d,	0x15ff, 0xc01d,		0x21, 0
	.dw 0x1640, 0xc01d,	0x167f, 0xc01d,		0x21, 0
	.dw 0x16c0, 0xc01d,	0x16ff, 0xc01d,		0x21, 0
	.dw 0x1740, 0xc01d,	0x177f, 0xc01d,		0x21, 0
	.dw 0x17c0, 0xc01d,	0x17ff, 0xc01d,		0x21, 0
	.dw 0x1840, 0xc01d,	0x187f, 0xc01d,		0x21, 0
	.dw 0x18c0, 0xc01d,	0x18ff, 0xc01d,		0x21, 0
	.dw 0x1940, 0xc01d,	0x197f, 0xc01d,		0x21, 0
	.dw 0x19c0, 0xc01d,	0x1fff, 0xc01d,		0x21, 0
	.dw 0x2040, 0xc01d,	0x207f, 0xc01d,		0x21, 0
	.dw 0x20c0, 0xc01d,	0x20ff, 0xc01d,		0x21, 0
	.dw 0x2140, 0xc01d,	0x217f, 0xc01d,		0x21, 0
	.dw 0x21c0, 0xc01d,	0x21ff, 0xc01d,		0x21, 0
	.dw 0x2240, 0xc01d,	0x227f, 0xc01d,		0x21, 0
	.dw 0x22c0, 0xc01d,	0x22ff, 0xc01d,		0x21, 0
	.dw 0x2340, 0xc01d,	0x237f, 0xc01d,		0x21, 0
	.dw 0x23c0, 0xc01d,	0x23ff, 0xc01d,		0x21, 0
	.dw 0x2440, 0xc01d,	0x247f, 0xc01d,		0x21, 0
	.dw 0x24c0, 0xc01d,	0x24ff, 0xc01d,		0x21, 0
	.dw 0x2540, 0xc01d,	0x257f, 0xc01d,		0x21, 0
	.dw 0x25c0, 0xc01d,	0x25ff, 0xc01d,		0x21, 0
	.dw 0x2640, 0xc01d,	0x267f, 0xc01d,		0x21, 0
	.dw 0x26c0, 0xc01d,	0x26ff, 0xc01d,		0x21, 0
	.dw 0x2740, 0xc01d,	0x277f, 0xc01d,		0x21, 0
	.dw 0x27c0, 0xc01d,	0x27ff, 0xc01d,		0x21, 0
	.dw 0x2840, 0xc01d,	0x287f, 0xc01d,		0x21, 0
	.dw 0x28c0, 0xc01d,	0x28ff, 0xc01d,		0x21, 0
	.dw 0x2940, 0xc01d,	0x297f, 0xc01d,		0x21, 0
	.dw 0x29c0, 0xc01d,	0x29ff, 0xc01d,		0x21, 0
	.dw 0x2a40, 0xc01d,	0x2a7f, 0xc01d,		0x21, 0
	.dw 0x2ac0, 0xc01d,	0x2aff, 0xc01d,		0x21, 0
	.dw 0x2b40, 0xc01d,	0x2b7f, 0xc01d,		0x21, 0
	.dw 0x2bc0, 0xc01d,	0x2bff, 0xc01d,		0x21, 0
	.dw 0x2c40, 0xc01d,	0x2c7f, 0xc01d,		0x21, 0
	.dw 0x2cc0, 0xc01d,	0x2cff, 0xc01d,		0x21, 0
	.dw 0x2d40, 0xc01d,	0x2d7f, 0xc01d,		0x21, 0
	.dw 0x2dc0, 0xc01d,	0x2dff, 0xc01d,		0x21, 0
	.dw 0x2e40, 0xc01d,	0x2e7f, 0xc01d,		0x21, 0
	.dw 0x2ec0, 0xc01d,	0x2eff, 0xc01d,		0x21, 0
	.dw 0x2f40, 0xc01d,	0x2f7f, 0xc01d,		0x21, 0
	.dw 0x2fc0, 0xc01d,	0x2fff, 0xc01d,		0x21, 0
	.dw 0x3040, 0xc01d,	0x307f, 0xc01d,		0x21, 0
	.dw 0x30c0, 0xc01d,	0x30ff, 0xc01d,		0x21, 0
	.dw 0x3140, 0xc01d,	0x317f, 0xc01d,		0x21, 0
	.dw 0x31c0, 0xc01d,	0x31ff, 0xc01d,		0x21, 0
	.dw 0x3240, 0xc01d,	0x327f, 0xc01d,		0x21, 0
	.dw 0x32c0, 0xc01d,	0x32ff, 0xc01d,		0x21, 0
	.dw 0x3340, 0xc01d,	0x337f, 0xc01d,		0x21, 0
	.dw 0x33c0, 0xc01d,	0x33ff, 0xc01d,		0x21, 0
	.dw 0x3440, 0xc01d,	0x347f, 0xc01d,		0x21, 0
	.dw 0x34c0, 0xc01d,	0x34ff, 0xc01d,		0x21, 0
	.dw 0x3540, 0xc01d,	0x357f, 0xc01d,		0x21, 0
	.dw 0x35c0, 0xc01d,	0x35ff, 0xc01d,		0x21, 0
	.dw 0x3640, 0xc01d,	0x367f, 0xc01d,		0x21, 0
	.dw 0x36c0, 0xc01d,	0x36ff, 0xc01d,		0x21, 0
	.dw 0x3740, 0xc01d,	0x377f, 0xc01d,		0x21, 0
	.dw 0x37c0, 0xc01d,	0x37ff, 0xc01d,		0x21, 0
	.dw 0x3840, 0xc01d,	0x387f, 0xc01d,		0x21, 0
	.dw 0x38c0, 0xc01d,	0x38ff, 0xc01d,		0x21, 0
	.dw 0x3940, 0xc01d,	0x397f, 0xc01d,		0x21, 0
	.dw 0x39c0, 0xc01d,	0x3fff, 0xc01d,		0x21, 0
	.dw 0x4040, 0xc01d,	0x407f, 0xc01d,		0x21, 0
	.dw 0x40c0, 0xc01d,	0x40ff, 0xc01d,		0x21, 0
	.dw 0x4140, 0xc01d,	0x417f, 0xc01d,		0x21, 0
	.dw 0x41c0, 0xc01d,	0x41ff, 0xc01d,		0x21, 0
	.dw 0x4240, 0xc01d,	0x427f, 0xc01d,		0x21, 0
	.dw 0x42c0, 0xc01d,	0x42ff, 0xc01d,		0x21, 0
	.dw 0x4340, 0xc01d,	0x437f, 0xc01d,		0x21, 0
	.dw 0x43c0, 0xc01d,	0x43ff, 0xc01d,		0x21, 0
	.dw 0x4440, 0xc01d,	0x447f, 0xc01d,		0x21, 0
	.dw 0x44c0, 0xc01d,	0x44ff, 0xc01d,		0x21, 0
	.dw 0x4540, 0xc01d,	0x457f, 0xc01d,		0x21, 0
	.dw 0x45c0, 0xc01d,	0x45ff, 0xc01d,		0x21, 0
	.dw 0x4640, 0xc01d,	0x467f, 0xc01d,		0x21, 0
	.dw 0x46c0, 0xc01d,	0x46ff, 0xc01d,		0x21, 0
	.dw 0x4740, 0xc01d,	0x477f, 0xc01d,		0x21, 0
	.dw 0x47c0, 0xc01d,	0x47ff, 0xc01d,		0x21, 0
	.dw 0x4840, 0xc01d,	0x487f, 0xc01d,		0x21, 0
	.dw 0x48c0, 0xc01d,	0x48ff, 0xc01d,		0x21, 0
	.dw 0x4940, 0xc01d,	0x497f, 0xc01d,		0x21, 0
	.dw 0x49c0, 0xc01d,	0x49ff, 0xc01d,		0x21, 0
	.dw 0x4a40, 0xc01d,	0x4a7f, 0xc01d,		0x21, 0
	.dw 0x4ac0, 0xc01d,	0x4aff, 0xc01d,		0x21, 0
	.dw 0x4b40, 0xc01d,	0x4b7f, 0xc01d,		0x21, 0
	.dw 0x4bc0, 0xc01d,	0x4bff, 0xc01d,		0x21, 0
	.dw 0x4c40, 0xc01d,	0x4c7f, 0xc01d,		0x21, 0
	.dw 0x4cc0, 0xc01d,	0x4cff, 0xc01d,		0x21, 0
	.dw 0x4d40, 0xc01d,	0x4d7f, 0xc01d,		0x21, 0
	.dw 0x4dc0, 0xc01d,	0x4dff, 0xc01d,		0x21, 0
	.dw 0x4e40, 0xc01d,	0x4e7f, 0xc01d,		0x21, 0
	.dw 0x4ec0, 0xc01d,	0x4eff, 0xc01d,		0x21, 0
	.dw 0x4f40, 0xc01d,	0x4f7f, 0xc01d,		0x21, 0
	.dw 0x4fc0, 0xc01d,	0x4fff, 0xc01d,		0x21, 0
	.dw 0x5040, 0xc01d,	0x507f, 0xc01d,		0x21, 0
	.dw 0x50c0, 0xc01d,	0x50ff, 0xc01d,		0x21, 0
	.dw 0x5140, 0xc01d,	0x517f, 0xc01d,		0x21, 0
	.dw 0x51c0, 0xc01d,	0x51ff, 0xc01d,		0x21, 0
	.dw 0x5240, 0xc01d,	0x527f, 0xc01d,		0x21, 0
	.dw 0x52c0, 0xc01d,	0x52ff, 0xc01d,		0x21, 0
	.dw 0x5340, 0xc01d,	0x537f, 0xc01d,		0x21, 0
	.dw 0x53c0, 0xc01d,	0x53ff, 0xc01d,		0x21, 0
	.dw 0x5440, 0xc01d,	0x547f, 0xc01d,		0x21, 0
	.dw 0x54c0, 0xc01d,	0x54ff, 0xc01d,		0x21, 0
	.dw 0x5540, 0xc01d,	0x557f, 0xc01d,		0x21, 0
	.dw 0x55c0, 0xc01d,	0x55ff, 0xc01d,		0x21, 0
	.dw 0x5640, 0xc01d,	0x567f, 0xc01d,		0x21, 0
	.dw 0x56c0, 0xc01d,	0x56ff, 0xc01d,		0x21, 0
	.dw 0x5740, 0xc01d,	0x577f, 0xc01d,		0x21, 0
	.dw 0x57c0, 0xc01d,	0x57ff, 0xc01d,		0x21, 0
	.dw 0x5840, 0xc01d,	0x587f, 0xc01d,		0x21, 0
	.dw 0x58c0, 0xc01d,	0x58ff, 0xc01d,		0x21, 0
	.dw 0x5940, 0xc01d,	0x597f, 0xc01d,		0x21, 0
	.dw 0x59c0, 0xc01d,	0x5fff, 0xc01d,		0x21, 0
	.dw 0x6040, 0xc01d,	0x607f, 0xc01d,		0x21, 0
	.dw 0x60c0, 0xc01d,	0x60ff, 0xc01d,		0x21, 0
	.dw 0x6140, 0xc01d,	0x617f, 0xc01d,		0x21, 0
	.dw 0x61c0, 0xc01d,	0x61ff, 0xc01d,		0x21, 0
	.dw 0x6240, 0xc01d,	0x627f, 0xc01d,		0x21, 0
	.dw 0x62c0, 0xc01d,	0x62ff, 0xc01d,		0x21, 0
	.dw 0x6340, 0xc01d,	0x637f, 0xc01d,		0x21, 0
	.dw 0x63c0, 0xc01d,	0x63ff, 0xc01d,		0x21, 0
	.dw 0x6440, 0xc01d,	0x647f, 0xc01d,		0x21, 0
	.dw 0x64c0, 0xc01d,	0x64ff, 0xc01d,		0x21, 0
	.dw 0x6540, 0xc01d,	0x657f, 0xc01d,		0x21, 0
	.dw 0x65c0, 0xc01d,	0x65ff, 0xc01d,		0x21, 0
	.dw 0x6640, 0xc01d,	0x667f, 0xc01d,		0x21, 0
	.dw 0x66c0, 0xc01d,	0x66ff, 0xc01d,		0x21, 0
	.dw 0x6740, 0xc01d,	0x677f, 0xc01d,		0x21, 0
	.dw 0x67c0, 0xc01d,	0x67ff, 0xc01d,		0x21, 0
	.dw 0x6840, 0xc01d,	0x687f, 0xc01d,		0x21, 0
	.dw 0x68c0, 0xc01d,	0x68ff, 0xc01d,		0x21, 0
	.dw 0x6940, 0xc01d,	0x697f, 0xc01d,		0x21, 0
	.dw 0x69c0, 0xc01d,	0x69ff, 0xc01d,		0x21, 0
	.dw 0x6a40, 0xc01d,	0x6a7f, 0xc01d,		0x21, 0
	.dw 0x6ac0, 0xc01d,	0x6aff, 0xc01d,		0x21, 0
	.dw 0x6b40, 0xc01d,	0x6b7f, 0xc01d,		0x21, 0
	.dw 0x6bc0, 0xc01d,	0x6bff, 0xc01d,		0x21, 0
	.dw 0x6c40, 0xc01d,	0x6c7f, 0xc01d,		0x21, 0
	.dw 0x6cc0, 0xc01d,	0x6cff, 0xc01d,		0x21, 0
	.dw 0x6d40, 0xc01d,	0x6d7f, 0xc01d,		0x21, 0
	.dw 0x6dc0, 0xc01d,	0x6dff, 0xc01d,		0x21, 0
	.dw 0x6e40, 0xc01d,	0x6e7f, 0xc01d,		0x21, 0
	.dw 0x6ec0, 0xc01d,	0x6eff, 0xc01d,		0x21, 0
	.dw 0x6f40, 0xc01d,	0x6f7f, 0xc01d,		0x21, 0
	.dw 0x6fc0, 0xc01d,	0x6fff, 0xc01d,		0x21, 0
	.dw 0x7040, 0xc01d,	0x707f, 0xc01d,		0x21, 0
	.dw 0x70c0, 0xc01d,	0x70ff, 0xc01d,		0x21, 0
	.dw 0x7140, 0xc01d,	0x717f, 0xc01d,		0x21, 0
	.dw 0x71c0, 0xc01d,	0x71ff, 0xc01d,		0x21, 0
	.dw 0x7240, 0xc01d,	0x727f, 0xc01d,		0x21, 0
	.dw 0x72c0, 0xc01d,	0x72ff, 0xc01d,		0x21, 0
	.dw 0x7340, 0xc01d,	0x737f, 0xc01d,		0x21, 0
	.dw 0x73c0, 0xc01d,	0x73ff, 0xc01d,		0x21, 0
	.dw 0x7440, 0xc01d,	0x747f, 0xc01d,		0x21, 0
	.dw 0x74c0, 0xc01d,	0x74ff, 0xc01d,		0x21, 0
	.dw 0x7540, 0xc01d,	0x757f, 0xc01d,		0x21, 0
	.dw 0x75c0, 0xc01d,	0x75ff, 0xc01d,		0x21, 0
	.dw 0x7640, 0xc01d,	0x767f, 0xc01d,		0x21, 0
	.dw 0x76c0, 0xc01d,	0x76ff, 0xc01d,		0x21, 0
	.dw 0x7740, 0xc01d,	0x777f, 0xc01d,		0x21, 0
	.dw 0x77c0, 0xc01d,	0x77ff, 0xc01d,		0x21, 0
	.dw 0x7840, 0xc01d,	0x787f, 0xc01d,		0x21, 0
	.dw 0x78c0, 0xc01d,	0x78ff, 0xc01d,		0x21, 0
	.dw 0x7940, 0xc01d,	0x797f, 0xc01d,		0x21, 0
	.dw 0x79c0, 0xc01d,	0x7fff, 0xc01d,		0x21, 0
	.dw 0x8040, 0xc01d,	0x807f, 0xc01d,		0x21, 0
	.dw 0x80c0, 0xc01d,	0x80ff, 0xc01d,		0x21, 0
	.dw 0x8140, 0xc01d,	0x817f, 0xc01d,		0x21, 0
	.dw 0x81c0, 0xc01d,	0x81ff, 0xc01d,		0x21, 0
	.dw 0x8240, 0xc01d,	0x827f, 0xc01d,		0x21, 0
	.dw 0x82c0, 0xc01d,	0x82ff, 0xc01d,		0x21, 0
	.dw 0x8340, 0xc01d,	0x837f, 0xc01d,		0x21, 0
	.dw 0x83c0, 0xc01d,	0x83ff, 0xc01d,		0x21, 0
	.dw 0x8440, 0xc01d,	0x847f, 0xc01d,		0x21, 0
	.dw 0x84c0, 0xc01d,	0x84ff, 0xc01d,		0x21, 0
	.dw 0x8540, 0xc01d,	0x857f, 0xc01d,		0x21, 0
	.dw 0x85c0, 0xc01d,	0x85ff, 0xc01d,		0x21, 0
	.dw 0x8640, 0xc01d,	0x867f, 0xc01d,		0x21, 0
	.dw 0x86c0, 0xc01d,	0x86ff, 0xc01d,		0x21, 0
	.dw 0x8740, 0xc01d,	0x877f, 0xc01d,		0x21, 0
	.dw 0x87c0, 0xc01d,	0x87ff, 0xc01d,		0x21, 0
	.dw 0x8840, 0xc01d,	0x887f, 0xc01d,		0x21, 0
	.dw 0x88c0, 0xc01d,	0x88ff, 0xc01d,		0x21, 0
	.dw 0x8940, 0xc01d,	0x897f, 0xc01d,		0x21, 0
	.dw 0x89c0, 0xc01d,	0x89ff, 0xc01d,		0x21, 0
	.dw 0x8a40, 0xc01d,	0x8a7f, 0xc01d,		0x21, 0
	.dw 0x8ac0, 0xc01d,	0x8aff, 0xc01d,		0x21, 0
	.dw 0x8b40, 0xc01d,	0x8b7f, 0xc01d,		0x21, 0
	.dw 0x8bc0, 0xc01d,	0x8bff, 0xc01d,		0x21, 0
	.dw 0x8c40, 0xc01d,	0x8c7f, 0xc01d,		0x21, 0
	.dw 0x8cc0, 0xc01d,	0x8cff, 0xc01d,		0x21, 0
	.dw 0x8d40, 0xc01d,	0x8d7f, 0xc01d,		0x21, 0
	.dw 0x8dc0, 0xc01d,	0x8dff, 0xc01d,		0x21, 0
	.dw 0x8e40, 0xc01d,	0x8e7f, 0xc01d,		0x21, 0
	.dw 0x8ec0, 0xc01d,	0x8eff, 0xc01d,		0x21, 0
	.dw 0x8f40, 0xc01d,	0x8f7f, 0xc01d,		0x21, 0
	.dw 0x8fc0, 0xc01d,	0x8fff, 0xc01d,		0x21, 0
	.dw 0x9040, 0xc01d,	0x907f, 0xc01d,		0x21, 0
	.dw 0x90c0, 0xc01d,	0x90ff, 0xc01d,		0x21, 0
	.dw 0x9140, 0xc01d,	0x917f, 0xc01d,		0x21, 0
	.dw 0x91c0, 0xc01d,	0x91ff, 0xc01d,		0x21, 0
	.dw 0x9240, 0xc01d,	0x927f, 0xc01d,		0x21, 0
	.dw 0x92c0, 0xc01d,	0x92ff, 0xc01d,		0x21, 0
	.dw 0x9340, 0xc01d,	0x937f, 0xc01d,		0x21, 0
	.dw 0x93c0, 0xc01d,	0x93ff, 0xc01d,		0x21, 0
	.dw 0x9440, 0xc01d,	0x947f, 0xc01d,		0x21, 0
	.dw 0x94c0, 0xc01d,	0x94ff, 0xc01d,		0x21, 0
	.dw 0x9540, 0xc01d,	0x957f, 0xc01d,		0x21, 0
	.dw 0x95c0, 0xc01d,	0x95ff, 0xc01d,		0x21, 0
	.dw 0x9640, 0xc01d,	0x967f, 0xc01d,		0x21, 0
	.dw 0x96c0, 0xc01d,	0x96ff, 0xc01d,		0x21, 0
	.dw 0x9740, 0xc01d,	0x977f, 0xc01d,		0x21, 0
	.dw 0x97c0, 0xc01d,	0x97ff, 0xc01d,		0x21, 0
	.dw 0x9840, 0xc01d,	0x987f, 0xc01d,		0x21, 0
	.dw 0x98c0, 0xc01d,	0x98ff, 0xc01d,		0x21, 0
	.dw 0x9940, 0xc01d,	0x997f, 0xc01d,		0x21, 0
	.dw 0x99c0, 0xc01d,	0x9fff, 0xc01d,		0x21, 0
	.dw 0xa040, 0xc01d,	0xa07f, 0xc01d,		0x21, 0
	.dw 0xa0c0, 0xc01d,	0xa0ff, 0xc01d,		0x21, 0
	.dw 0xa140, 0xc01d,	0xa17f, 0xc01d,		0x21, 0
	.dw 0xa1c0, 0xc01d,	0xa1ff, 0xc01d,		0x21, 0
	.dw 0xa240, 0xc01d,	0xa27f, 0xc01d,		0x21, 0
	.dw 0xa2c0, 0xc01d,	0xa2ff, 0xc01d,		0x21, 0
	.dw 0xa340, 0xc01d,	0xa37f, 0xc01d,		0x21, 0
	.dw 0xa3c0, 0xc01d,	0xa3ff, 0xc01d,		0x21, 0
	.dw 0xa440, 0xc01d,	0xa47f, 0xc01d,		0x21, 0
	.dw 0xa4c0, 0xc01d,	0xa4ff, 0xc01d,		0x21, 0
	.dw 0xa540, 0xc01d,	0xa57f, 0xc01d,		0x21, 0
	.dw 0xa5c0, 0xc01d,	0xa5ff, 0xc01d,		0x21, 0
	.dw 0xa640, 0xc01d,	0xa67f, 0xc01d,		0x21, 0
	.dw 0xa6c0, 0xc01d,	0xa6ff, 0xc01d,		0x21, 0
	.dw 0xa740, 0xc01d,	0xa77f, 0xc01d,		0x21, 0
	.dw 0xa7c0, 0xc01d,	0xa7ff, 0xc01d,		0x21, 0
	.dw 0xa840, 0xc01d,	0xa87f, 0xc01d,		0x21, 0
	.dw 0xa8c0, 0xc01d,	0xa8ff, 0xc01d,		0x21, 0
	.dw 0xa940, 0xc01d,	0xa97f, 0xc01d,		0x21, 0
	.dw 0xa9c0, 0xc01d,	0xa9ff, 0xc01d,		0x21, 0
	.dw 0xaa40, 0xc01d,	0xaa7f, 0xc01d,		0x21, 0
	.dw 0xaac0, 0xc01d,	0xaaff, 0xc01d,		0x21, 0
	.dw 0xab40, 0xc01d,	0xab7f, 0xc01d,		0x21, 0
	.dw 0xabc0, 0xc01d,	0xabff, 0xc01d,		0x21, 0
	.dw 0xac40, 0xc01d,	0xac7f, 0xc01d,		0x21, 0
	.dw 0xacc0, 0xc01d,	0xacff, 0xc01d,		0x21, 0
	.dw 0xad40, 0xc01d,	0xad7f, 0xc01d,		0x21, 0
	.dw 0xadc0, 0xc01d,	0xadff, 0xc01d,		0x21, 0
	.dw 0xae40, 0xc01d,	0xae7f, 0xc01d,		0x21, 0
	.dw 0xaec0, 0xc01d,	0xaeff, 0xc01d,		0x21, 0
	.dw 0xaf40, 0xc01d,	0xaf7f, 0xc01d,		0x21, 0
	.dw 0xafc0, 0xc01d,	0xafff, 0xc01d,		0x21, 0
	.dw 0xb040, 0xc01d,	0xb07f, 0xc01d,		0x21, 0
	.dw 0xb0c0, 0xc01d,	0xb0ff, 0xc01d,		0x21, 0
	.dw 0xb140, 0xc01d,	0xb17f, 0xc01d,		0x21, 0
	.dw 0xb1c0, 0xc01d,	0xb1ff, 0xc01d,		0x21, 0
	.dw 0xb240, 0xc01d,	0xb27f, 0xc01d,		0x21, 0
	.dw 0xb2c0, 0xc01d,	0xb2ff, 0xc01d,		0x21, 0
	.dw 0xb340, 0xc01d,	0xb37f, 0xc01d,		0x21, 0
	.dw 0xb3c0, 0xc01d,	0xb3ff, 0xc01d,		0x21, 0
	.dw 0xb440, 0xc01d,	0xb47f, 0xc01d,		0x21, 0
	.dw 0xb4c0, 0xc01d,	0xb4ff, 0xc01d,		0x21, 0
	.dw 0xb540, 0xc01d,	0xb57f, 0xc01d,		0x21, 0
	.dw 0xb5c0, 0xc01d,	0xb5ff, 0xc01d,		0x21, 0
	.dw 0xb640, 0xc01d,	0xb67f, 0xc01d,		0x21, 0
	.dw 0xb6c0, 0xc01d,	0xb6ff, 0xc01d,		0x21, 0
	.dw 0xb740, 0xc01d,	0xb77f, 0xc01d,		0x21, 0
	.dw 0xb7c0, 0xc01d,	0xb7ff, 0xc01d,		0x21, 0
	.dw 0xb840, 0xc01d,	0xb87f, 0xc01d,		0x21, 0
	.dw 0xb8c0, 0xc01d,	0xb8ff, 0xc01d,		0x21, 0
	.dw 0xb940, 0xc01d,	0xb97f, 0xc01d,		0x21, 0
	.dw 0xb9c0, 0xc01d,	0xbfff, 0xc01d,		0x21, 0
	.dw 0xc040, 0xc01d,	0xc07f, 0xc01d,		0x21, 0
	.dw 0xc0c0, 0xc01d,	0xc0ff, 0xc01d,		0x21, 0
	.dw 0xc140, 0xc01d,	0xc17f, 0xc01d,		0x21, 0
	.dw 0xc1c0, 0xc01d,	0xc1ff, 0xc01d,		0x21, 0
	.dw 0xc240, 0xc01d,	0xc27f, 0xc01d,		0x21, 0
	.dw 0xc2c0, 0xc01d,	0xc2ff, 0xc01d,		0x21, 0
	.dw 0xc340, 0xc01d,	0xc37f, 0xc01d,		0x21, 0
	.dw 0xc3c0, 0xc01d,	0xc3ff, 0xc01d,		0x21, 0
	.dw 0xc440, 0xc01d,	0xc47f, 0xc01d,		0x21, 0
	.dw 0xc4c0, 0xc01d,	0xc4ff, 0xc01d,		0x21, 0
	.dw 0xc540, 0xc01d,	0xc57f, 0xc01d,		0x21, 0
	.dw 0xc5c0, 0xc01d,	0xc5ff, 0xc01d,		0x21, 0
	.dw 0xc640, 0xc01d,	0xc67f, 0xc01d,		0x21, 0
	.dw 0xc6c0, 0xc01d,	0xc6ff, 0xc01d,		0x21, 0
	.dw 0xc740, 0xc01d,	0xc77f, 0xc01d,		0x21, 0
	.dw 0xc7c0, 0xc01d,	0xc7ff, 0xc01d,		0x21, 0
	.dw 0xc840, 0xc01d,	0xc87f, 0xc01d,		0x21, 0
	.dw 0xc8c0, 0xc01d,	0xc8ff, 0xc01d,		0x21, 0
	.dw 0xc940, 0xc01d,	0xc97f, 0xc01d,		0x21, 0
	.dw 0xc9c0, 0xc01d,	0xc9ff, 0xc01d,		0x21, 0
	.dw 0xca40, 0xc01d,	0xca7f, 0xc01d,		0x21, 0
	.dw 0xcac0, 0xc01d,	0xcaff, 0xc01d,		0x21, 0
	.dw 0xcb40, 0xc01d,	0xcb7f, 0xc01d,		0x21, 0
	.dw 0xcbc0, 0xc01d,	0xcbff, 0xc01d,		0x21, 0
	.dw 0xcc40, 0xc01d,	0xcc7f, 0xc01d,		0x21, 0
	.dw 0xccc0, 0xc01d,	0xccff, 0xc01d,		0x21, 0
	.dw 0xcd40, 0xc01d,	0xcd7f, 0xc01d,		0x21, 0
	.dw 0xcdc0, 0xc01d,	0xcdff, 0xc01d,		0x21, 0
	.dw 0xce40, 0xc01d,	0xce7f, 0xc01d,		0x21, 0
	.dw 0xcec0, 0xc01d,	0xceff, 0xc01d,		0x21, 0
	.dw 0xcf40, 0xc01d,	0xcf7f, 0xc01d,		0x21, 0
	.dw 0xcfc0, 0xc01d,	0xcfff, 0xc01d,		0x21, 0
	.dw 0xd040, 0xc01d,	0xd07f, 0xc01d,		0x21, 0
	.dw 0xd0c0, 0xc01d,	0xd0ff, 0xc01d,		0x21, 0
	.dw 0xd140, 0xc01d,	0xd17f, 0xc01d,		0x21, 0
	.dw 0xd1c0, 0xc01d,	0xd1ff, 0xc01d,		0x21, 0
	.dw 0xd240, 0xc01d,	0xd27f, 0xc01d,		0x21, 0
	.dw 0xd2c0, 0xc01d,	0xd2ff, 0xc01d,		0x21, 0
	.dw 0xd340, 0xc01d,	0xd37f, 0xc01d,		0x21, 0
	.dw 0xd3c0, 0xc01d,	0xd3ff, 0xc01d,		0x21, 0
	.dw 0xd440, 0xc01d,	0xd47f, 0xc01d,		0x21, 0
	.dw 0xd4c0, 0xc01d,	0xd4ff, 0xc01d,		0x21, 0
	.dw 0xd540, 0xc01d,	0xd57f, 0xc01d,		0x21, 0
	.dw 0xd5c0, 0xc01d,	0xd5ff, 0xc01d,		0x21, 0
	.dw 0xd640, 0xc01d,	0xd67f, 0xc01d,		0x21, 0
	.dw 0xd6c0, 0xc01d,	0xd6ff, 0xc01d,		0x21, 0
	.dw 0xd740, 0xc01d,	0xd77f, 0xc01d,		0x21, 0
	.dw 0xd7c0, 0xc01d,	0xd7ff, 0xc01d,		0x21, 0
	.dw 0xd840, 0xc01d,	0xd87f, 0xc01d,		0x21, 0
	.dw 0xd8c0, 0xc01d,	0xd8ff, 0xc01d,		0x21, 0
	.dw 0xd940, 0xc01d,	0xd97f, 0xc01d,		0x21, 0
	.dw 0xd9c0, 0xc01d,	0xdfff, 0xc01d,		0x21, 0
	.dw 0xe040, 0xc01d,	0xe07f, 0xc01d,		0x21, 0
	.dw 0xe0c0, 0xc01d,	0xe0ff, 0xc01d,		0x21, 0
	.dw 0xe140, 0xc01d,	0xe17f, 0xc01d,		0x21, 0
	.dw 0xe1c0, 0xc01d,	0xe1ff, 0xc01d,		0x21, 0
	.dw 0xe240, 0xc01d,	0xe27f, 0xc01d,		0x21, 0
	.dw 0xe2c0, 0xc01d,	0xe2ff, 0xc01d,		0x21, 0
	.dw 0xe340, 0xc01d,	0xe37f, 0xc01d,		0x21, 0
	.dw 0xe3c0, 0xc01d,	0xe3ff, 0xc01d,		0x21, 0
	.dw 0xe440, 0xc01d,	0xe47f, 0xc01d,		0x21, 0
	.dw 0xe4c0, 0xc01d,	0xe4ff, 0xc01d,		0x21, 0
	.dw 0xe540, 0xc01d,	0xe57f, 0xc01d,		0x21, 0
	.dw 0xe5c0, 0xc01d,	0xe5ff, 0xc01d,		0x21, 0
	.dw 0xe640, 0xc01d,	0xe67f, 0xc01d,		0x21, 0
	.dw 0xe6c0, 0xc01d,	0xe6ff, 0xc01d,		0x21, 0
	.dw 0xe740, 0xc01d,	0xe77f, 0xc01d,		0x21, 0
	.dw 0xe7c0, 0xc01d,	0xe7ff, 0xc01d,		0x21, 0
	.dw 0xe840, 0xc01d,	0xe87f, 0xc01d,		0x21, 0
	.dw 0xe8c0, 0xc01d,	0xe8ff, 0xc01d,		0x21, 0
	.dw 0xe940, 0xc01d,	0xe97f, 0xc01d,		0x21, 0
	.dw 0xe9c0, 0xc01d,	0xe9ff, 0xc01d,		0x21, 0
	.dw 0xea40, 0xc01d,	0xea7f, 0xc01d,		0x21, 0
	.dw 0xeac0, 0xc01d,	0xeaff, 0xc01d,		0x21, 0
	.dw 0xeb40, 0xc01d,	0xeb7f, 0xc01d,		0x21, 0
	.dw 0xebc0, 0xc01d,	0xebff, 0xc01d,		0x21, 0
	.dw 0xec40, 0xc01d,	0xec7f, 0xc01d,		0x21, 0
	.dw 0xecc0, 0xc01d,	0xecff, 0xc01d,		0x21, 0
	.dw 0xed40, 0xc01d,	0xed7f, 0xc01d,		0x21, 0
	.dw 0xedc0, 0xc01d,	0xedff, 0xc01d,		0x21, 0
	.dw 0xee40, 0xc01d,	0xee7f, 0xc01d,		0x21, 0
	.dw 0xeec0, 0xc01d,	0xeeff, 0xc01d,		0x21, 0
	.dw 0xef40, 0xc01d,	0xef7f, 0xc01d,		0x21, 0
	.dw 0xefc0, 0xc01d,	0xefff, 0xc01d,		0x21, 0
	.dw 0xf040, 0xc01d,	0xf07f, 0xc01d,		0x21, 0
	.dw 0xf0c0, 0xc01d,	0xf0ff, 0xc01d,		0x21, 0
	.dw 0xf140, 0xc01d,	0xf17f, 0xc01d,		0x21, 0
	.dw 0xf1c0, 0xc01d,	0xf1ff, 0xc01d,		0x21, 0
	.dw 0xf240, 0xc01d,	0xf27f, 0xc01d,		0x21, 0
	.dw 0xf2c0, 0xc01d,	0xf2ff, 0xc01d,		0x21, 0
	.dw 0xf340, 0xc01d,	0xf37f, 0xc01d,		0x21, 0
	.dw 0xf3c0, 0xc01d,	0xf3ff, 0xc01d,		0x21, 0
	.dw 0xf440, 0xc01d,	0xf47f, 0xc01d,		0x21, 0
	.dw 0xf4c0, 0xc01d,	0xf4ff, 0xc01d,		0x21, 0
	.dw 0xf540, 0xc01d,	0xf57f, 0xc01d,		0x21, 0
	.dw 0xf5c0, 0xc01d,	0xf5ff, 0xc01d,		0x21, 0
	.dw 0xf640, 0xc01d,	0xf67f, 0xc01d,		0x21, 0
	.dw 0xf6c0, 0xc01d,	0xf6ff, 0xc01d,		0x21, 0
	.dw 0xf740, 0xc01d,	0xf77f, 0xc01d,		0x21, 0
	.dw 0xf7c0, 0xc01d,	0xf7ff, 0xc01d,		0x21, 0
	.dw 0xf840, 0xc01d,	0xf87f, 0xc01d,		0x21, 0
	.dw 0xf8c0, 0xc01d,	0xf8ff, 0xc01d,		0x21, 0
	.dw 0xf940, 0xc01d,	0xf97f, 0xc01d,		0x21, 0
	.dw 0xf9c0, 0xc01d,	0xffff, 0xc01d,		0x21, 0
	.dw 0x0040, 0xc01e,	0x007f, 0xc01e,		0x21, 0
	.dw 0x00c0, 0xc01e,	0x00ff, 0xc01e,		0x21, 0
	.dw 0x0140, 0xc01e,	0x017f, 0xc01e,		0x21, 0
	.dw 0x01c0, 0xc01e,	0x01ff, 0xc01e,		0x21, 0
	.dw 0x0240, 0xc01e,	0x027f, 0xc01e,		0x21, 0
	.dw 0x02c0, 0xc01e,	0x02ff, 0xc01e,		0x21, 0
	.dw 0x0340, 0xc01e,	0x037f, 0xc01e,		0x21, 0
	.dw 0x03c0, 0xc01e,	0x03ff, 0xc01e,		0x21, 0
	.dw 0x0440, 0xc01e,	0x047f, 0xc01e,		0x21, 0
	.dw 0x04c0, 0xc01e,	0x04ff, 0xc01e,		0x21, 0
	.dw 0x0540, 0xc01e,	0x057f, 0xc01e,		0x21, 0
	.dw 0x05c0, 0xc01e,	0x05ff, 0xc01e,		0x21, 0
	.dw 0x0640, 0xc01e,	0x067f, 0xc01e,		0x21, 0
	.dw 0x06c0, 0xc01e,	0x06ff, 0xc01e,		0x21, 0
	.dw 0x0740, 0xc01e,	0x077f, 0xc01e,		0x21, 0
	.dw 0x07c0, 0xc01e,	0x07ff, 0xc01e,		0x21, 0
	.dw 0x0840, 0xc01e,	0x087f, 0xc01e,		0x21, 0
	.dw 0x08c0, 0xc01e,	0x08ff, 0xc01e,		0x21, 0
	.dw 0x0940, 0xc01e,	0x097f, 0xc01e,		0x21, 0
	.dw 0x09c0, 0xc01e,	0x09ff, 0xc01e,		0x21, 0
	.dw 0x0a40, 0xc01e,	0x0a7f, 0xc01e,		0x21, 0
	.dw 0x0ac0, 0xc01e,	0x0aff, 0xc01e,		0x21, 0
	.dw 0x0b40, 0xc01e,	0x0b7f, 0xc01e,		0x21, 0
	.dw 0x0bc0, 0xc01e,	0x0bff, 0xc01e,		0x21, 0
	.dw 0x0c40, 0xc01e,	0x0c7f, 0xc01e,		0x21, 0
	.dw 0x0cc0, 0xc01e,	0x0cff, 0xc01e,		0x21, 0
	.dw 0x0d40, 0xc01e,	0x0d7f, 0xc01e,		0x21, 0
	.dw 0x0dc0, 0xc01e,	0x0dff, 0xc01e,		0x21, 0
	.dw 0x0e40, 0xc01e,	0x0e7f, 0xc01e,		0x21, 0
	.dw 0x0ec0, 0xc01e,	0x0eff, 0xc01e,		0x21, 0
	.dw 0x0f40, 0xc01e,	0x0f7f, 0xc01e,		0x21, 0
	.dw 0x0fc0, 0xc01e,	0x0fff, 0xc01e,		0x21, 0
	.dw 0x1040, 0xc01e,	0x107f, 0xc01e,		0x21, 0
	.dw 0x10c0, 0xc01e,	0x10ff, 0xc01e,		0x21, 0
	.dw 0x1140, 0xc01e,	0x117f, 0xc01e,		0x21, 0
	.dw 0x11c0, 0xc01e,	0x11ff, 0xc01e,		0x21, 0
	.dw 0x1240, 0xc01e,	0x127f, 0xc01e,		0x21, 0
	.dw 0x12c0, 0xc01e,	0x12ff, 0xc01e,		0x21, 0
	.dw 0x1340, 0xc01e,	0x137f, 0xc01e,		0x21, 0
	.dw 0x13c0, 0xc01e,	0x13ff, 0xc01e,		0x21, 0
	.dw 0x1440, 0xc01e,	0x147f, 0xc01e,		0x21, 0
	.dw 0x14c0, 0xc01e,	0x14ff, 0xc01e,		0x21, 0
	.dw 0x1540, 0xc01e,	0x157f, 0xc01e,		0x21, 0
	.dw 0x15c0, 0xc01e,	0x15ff, 0xc01e,		0x21, 0
	.dw 0x1640, 0xc01e,	0x167f, 0xc01e,		0x21, 0
	.dw 0x16c0, 0xc01e,	0x16ff, 0xc01e,		0x21, 0
	.dw 0x1740, 0xc01e,	0x177f, 0xc01e,		0x21, 0
	.dw 0x17c0, 0xc01e,	0x17ff, 0xc01e,		0x21, 0
	.dw 0x1840, 0xc01e,	0x187f, 0xc01e,		0x21, 0
	.dw 0x18c0, 0xc01e,	0x18ff, 0xc01e,		0x21, 0
	.dw 0x1940, 0xc01e,	0x197f, 0xc01e,		0x21, 0
	.dw 0x19c0, 0xc01e,	0x1fff, 0xc01e,		0x21, 0
	.dw 0x2040, 0xc01e,	0x207f, 0xc01e,		0x21, 0
	.dw 0x20c0, 0xc01e,	0x20ff, 0xc01e,		0x21, 0
	.dw 0x2140, 0xc01e,	0x217f, 0xc01e,		0x21, 0
	.dw 0x21c0, 0xc01e,	0x21ff, 0xc01e,		0x21, 0
	.dw 0x2240, 0xc01e,	0x227f, 0xc01e,		0x21, 0
	.dw 0x22c0, 0xc01e,	0x22ff, 0xc01e,		0x21, 0
	.dw 0x2340, 0xc01e,	0x237f, 0xc01e,		0x21, 0
	.dw 0x23c0, 0xc01e,	0x23ff, 0xc01e,		0x21, 0
	.dw 0x2440, 0xc01e,	0x247f, 0xc01e,		0x21, 0
	.dw 0x24c0, 0xc01e,	0x24ff, 0xc01e,		0x21, 0
	.dw 0x2540, 0xc01e,	0x257f, 0xc01e,		0x21, 0
	.dw 0x25c0, 0xc01e,	0x25ff, 0xc01e,		0x21, 0
	.dw 0x2640, 0xc01e,	0x267f, 0xc01e,		0x21, 0
	.dw 0x26c0, 0xc01e,	0x26ff, 0xc01e,		0x21, 0
	.dw 0x2740, 0xc01e,	0x277f, 0xc01e,		0x21, 0
	.dw 0x27c0, 0xc01e,	0x27ff, 0xc01e,		0x21, 0
	.dw 0x2840, 0xc01e,	0x287f, 0xc01e,		0x21, 0
	.dw 0x28c0, 0xc01e,	0x28ff, 0xc01e,		0x21, 0
	.dw 0x2940, 0xc01e,	0x297f, 0xc01e,		0x21, 0
	.dw 0x29c0, 0xc01e,	0x29ff, 0xc01e,		0x21, 0
	.dw 0x2a40, 0xc01e,	0x2a7f, 0xc01e,		0x21, 0
	.dw 0x2ac0, 0xc01e,	0x2aff, 0xc01e,		0x21, 0
	.dw 0x2b40, 0xc01e,	0x2b7f, 0xc01e,		0x21, 0
	.dw 0x2bc0, 0xc01e,	0x2bff, 0xc01e,		0x21, 0
	.dw 0x2c40, 0xc01e,	0x2c7f, 0xc01e,		0x21, 0
	.dw 0x2cc0, 0xc01e,	0x2cff, 0xc01e,		0x21, 0
	.dw 0x2d40, 0xc01e,	0x2d7f, 0xc01e,		0x21, 0
	.dw 0x2dc0, 0xc01e,	0x2dff, 0xc01e,		0x21, 0
	.dw 0x2e40, 0xc01e,	0x2e7f, 0xc01e,		0x21, 0
	.dw 0x2ec0, 0xc01e,	0x2eff, 0xc01e,		0x21, 0
	.dw 0x2f40, 0xc01e,	0x2f7f, 0xc01e,		0x21, 0
	.dw 0x2fc0, 0xc01e,	0x2fff, 0xc01e,		0x21, 0
	.dw 0x3040, 0xc01e,	0x307f, 0xc01e,		0x21, 0
	.dw 0x30c0, 0xc01e,	0x30ff, 0xc01e,		0x21, 0
	.dw 0x3140, 0xc01e,	0x317f, 0xc01e,		0x21, 0
	.dw 0x31c0, 0xc01e,	0x31ff, 0xc01e,		0x21, 0
	.dw 0x3240, 0xc01e,	0x327f, 0xc01e,		0x21, 0
	.dw 0x32c0, 0xc01e,	0x32ff, 0xc01e,		0x21, 0
	.dw 0x3340, 0xc01e,	0x337f, 0xc01e,		0x21, 0
	.dw 0x33c0, 0xc01e,	0x33ff, 0xc01e,		0x21, 0
	.dw 0x3440, 0xc01e,	0x347f, 0xc01e,		0x21, 0
	.dw 0x34c0, 0xc01e,	0x34ff, 0xc01e,		0x21, 0
	.dw 0x3540, 0xc01e,	0x357f, 0xc01e,		0x21, 0
	.dw 0x35c0, 0xc01e,	0x35ff, 0xc01e,		0x21, 0
	.dw 0x3640, 0xc01e,	0x367f, 0xc01e,		0x21, 0
	.dw 0x36c0, 0xc01e,	0x36ff, 0xc01e,		0x21, 0
	.dw 0x3740, 0xc01e,	0x377f, 0xc01e,		0x21, 0
	.dw 0x37c0, 0xc01e,	0x37ff, 0xc01e,		0x21, 0
	.dw 0x3840, 0xc01e,	0x387f, 0xc01e,		0x21, 0
	.dw 0x38c0, 0xc01e,	0x38ff, 0xc01e,		0x21, 0
	.dw 0x3940, 0xc01e,	0x397f, 0xc01e,		0x21, 0
	.dw 0x39c0, 0xc01e,	0x3fff, 0xc01e,		0x21, 0
	.dw 0x4040, 0xc01e,	0x407f, 0xc01e,		0x21, 0
	.dw 0x40c0, 0xc01e,	0x40ff, 0xc01e,		0x21, 0
	.dw 0x4140, 0xc01e,	0x417f, 0xc01e,		0x21, 0
	.dw 0x41c0, 0xc01e,	0x41ff, 0xc01e,		0x21, 0
	.dw 0x4240, 0xc01e,	0x427f, 0xc01e,		0x21, 0
	.dw 0x42c0, 0xc01e,	0x42ff, 0xc01e,		0x21, 0
	.dw 0x4340, 0xc01e,	0x437f, 0xc01e,		0x21, 0
	.dw 0x43c0, 0xc01e,	0x43ff, 0xc01e,		0x21, 0
	.dw 0x4440, 0xc01e,	0x447f, 0xc01e,		0x21, 0
	.dw 0x44c0, 0xc01e,	0x44ff, 0xc01e,		0x21, 0
	.dw 0x4540, 0xc01e,	0x457f, 0xc01e,		0x21, 0
	.dw 0x45c0, 0xc01e,	0x45ff, 0xc01e,		0x21, 0
	.dw 0x4640, 0xc01e,	0x467f, 0xc01e,		0x21, 0
	.dw 0x46c0, 0xc01e,	0x46ff, 0xc01e,		0x21, 0
	.dw 0x4740, 0xc01e,	0x477f, 0xc01e,		0x21, 0
	.dw 0x47c0, 0xc01e,	0x47ff, 0xc01e,		0x21, 0
	.dw 0x4840, 0xc01e,	0x487f, 0xc01e,		0x21, 0
	.dw 0x48c0, 0xc01e,	0x48ff, 0xc01e,		0x21, 0
	.dw 0x4940, 0xc01e,	0x497f, 0xc01e,		0x21, 0
	.dw 0x49c0, 0xc01e,	0x49ff, 0xc01e,		0x21, 0
	.dw 0x4a40, 0xc01e,	0x4a7f, 0xc01e,		0x21, 0
	.dw 0x4ac0, 0xc01e,	0x4aff, 0xc01e,		0x21, 0
	.dw 0x4b40, 0xc01e,	0x4b7f, 0xc01e,		0x21, 0
	.dw 0x4bc0, 0xc01e,	0x4bff, 0xc01e,		0x21, 0
	.dw 0x4c40, 0xc01e,	0x4c7f, 0xc01e,		0x21, 0
	.dw 0x4cc0, 0xc01e,	0x4cff, 0xc01e,		0x21, 0
	.dw 0x4d40, 0xc01e,	0x4d7f, 0xc01e,		0x21, 0
	.dw 0x4dc0, 0xc01e,	0x4dff, 0xc01e,		0x21, 0
	.dw 0x4e40, 0xc01e,	0x4e7f, 0xc01e,		0x21, 0
	.dw 0x4ec0, 0xc01e,	0x4eff, 0xc01e,		0x21, 0
	.dw 0x4f40, 0xc01e,	0x4f7f, 0xc01e,		0x21, 0
	.dw 0x4fc0, 0xc01e,	0x4fff, 0xc01e,		0x21, 0
	.dw 0x5040, 0xc01e,	0x507f, 0xc01e,		0x21, 0
	.dw 0x50c0, 0xc01e,	0x50ff, 0xc01e,		0x21, 0
	.dw 0x5140, 0xc01e,	0x517f, 0xc01e,		0x21, 0
	.dw 0x51c0, 0xc01e,	0x51ff, 0xc01e,		0x21, 0
	.dw 0x5240, 0xc01e,	0x527f, 0xc01e,		0x21, 0
	.dw 0x52c0, 0xc01e,	0x52ff, 0xc01e,		0x21, 0
	.dw 0x5340, 0xc01e,	0x537f, 0xc01e,		0x21, 0
	.dw 0x53c0, 0xc01e,	0x53ff, 0xc01e,		0x21, 0
	.dw 0x5440, 0xc01e,	0x547f, 0xc01e,		0x21, 0
	.dw 0x54c0, 0xc01e,	0x54ff, 0xc01e,		0x21, 0
	.dw 0x5540, 0xc01e,	0x557f, 0xc01e,		0x21, 0
	.dw 0x55c0, 0xc01e,	0x55ff, 0xc01e,		0x21, 0
	.dw 0x5640, 0xc01e,	0x567f, 0xc01e,		0x21, 0
	.dw 0x56c0, 0xc01e,	0x56ff, 0xc01e,		0x21, 0
	.dw 0x5740, 0xc01e,	0x577f, 0xc01e,		0x21, 0
	.dw 0x57c0, 0xc01e,	0x57ff, 0xc01e,		0x21, 0
	.dw 0x5840, 0xc01e,	0x587f, 0xc01e,		0x21, 0
	.dw 0x58c0, 0xc01e,	0x58ff, 0xc01e,		0x21, 0
	.dw 0x5940, 0xc01e,	0x597f, 0xc01e,		0x21, 0
	.dw 0x59c0, 0xc01e,	0x5fff, 0xc01e,		0x21, 0
	.dw 0x6040, 0xc01e,	0x607f, 0xc01e,		0x21, 0
	.dw 0x60c0, 0xc01e,	0x60ff, 0xc01e,		0x21, 0
	.dw 0x6140, 0xc01e,	0x617f, 0xc01e,		0x21, 0
	.dw 0x61c0, 0xc01e,	0x61ff, 0xc01e,		0x21, 0
	.dw 0x6240, 0xc01e,	0x627f, 0xc01e,		0x21, 0
	.dw 0x62c0, 0xc01e,	0x62ff, 0xc01e,		0x21, 0
	.dw 0x6340, 0xc01e,	0x637f, 0xc01e,		0x21, 0
	.dw 0x63c0, 0xc01e,	0x63ff, 0xc01e,		0x21, 0
	.dw 0x6440, 0xc01e,	0x647f, 0xc01e,		0x21, 0
	.dw 0x64c0, 0xc01e,	0x64ff, 0xc01e,		0x21, 0
	.dw 0x6540, 0xc01e,	0x657f, 0xc01e,		0x21, 0
	.dw 0x65c0, 0xc01e,	0x65ff, 0xc01e,		0x21, 0
	.dw 0x6640, 0xc01e,	0x667f, 0xc01e,		0x21, 0
	.dw 0x66c0, 0xc01e,	0x66ff, 0xc01e,		0x21, 0
	.dw 0x6740, 0xc01e,	0x677f, 0xc01e,		0x21, 0
	.dw 0x67c0, 0xc01e,	0x67ff, 0xc01e,		0x21, 0
	.dw 0x6840, 0xc01e,	0x687f, 0xc01e,		0x21, 0
	.dw 0x68c0, 0xc01e,	0x68ff, 0xc01e,		0x21, 0
	.dw 0x6940, 0xc01e,	0x697f, 0xc01e,		0x21, 0
	.dw 0x69c0, 0xc01e,	0x69ff, 0xc01e,		0x21, 0
	.dw 0x6a40, 0xc01e,	0x6a7f, 0xc01e,		0x21, 0
	.dw 0x6ac0, 0xc01e,	0x6aff, 0xc01e,		0x21, 0
	.dw 0x6b40, 0xc01e,	0x6b7f, 0xc01e,		0x21, 0
	.dw 0x6bc0, 0xc01e,	0x6bff, 0xc01e,		0x21, 0
	.dw 0x6c40, 0xc01e,	0x6c7f, 0xc01e,		0x21, 0
	.dw 0x6cc0, 0xc01e,	0x6cff, 0xc01e,		0x21, 0
	.dw 0x6d40, 0xc01e,	0x6d7f, 0xc01e,		0x21, 0
	.dw 0x6dc0, 0xc01e,	0x6dff, 0xc01e,		0x21, 0
	.dw 0x6e40, 0xc01e,	0x6e7f, 0xc01e,		0x21, 0
	.dw 0x6ec0, 0xc01e,	0x6eff, 0xc01e,		0x21, 0
	.dw 0x6f40, 0xc01e,	0x6f7f, 0xc01e,		0x21, 0
	.dw 0x6fc0, 0xc01e,	0x6fff, 0xc01e,		0x21, 0
	.dw 0x7040, 0xc01e,	0x707f, 0xc01e,		0x21, 0
	.dw 0x70c0, 0xc01e,	0x70ff, 0xc01e,		0x21, 0
	.dw 0x7140, 0xc01e,	0x717f, 0xc01e,		0x21, 0
	.dw 0x71c0, 0xc01e,	0x71ff, 0xc01e,		0x21, 0
	.dw 0x7240, 0xc01e,	0x727f, 0xc01e,		0x21, 0
	.dw 0x72c0, 0xc01e,	0x72ff, 0xc01e,		0x21, 0
	.dw 0x7340, 0xc01e,	0x737f, 0xc01e,		0x21, 0
	.dw 0x73c0, 0xc01e,	0x73ff, 0xc01e,		0x21, 0
	.dw 0x7440, 0xc01e,	0x747f, 0xc01e,		0x21, 0
	.dw 0x74c0, 0xc01e,	0x74ff, 0xc01e,		0x21, 0
	.dw 0x7540, 0xc01e,	0x757f, 0xc01e,		0x21, 0
	.dw 0x75c0, 0xc01e,	0x75ff, 0xc01e,		0x21, 0
	.dw 0x7640, 0xc01e,	0x767f, 0xc01e,		0x21, 0
	.dw 0x76c0, 0xc01e,	0x76ff, 0xc01e,		0x21, 0
	.dw 0x7740, 0xc01e,	0x777f, 0xc01e,		0x21, 0
	.dw 0x77c0, 0xc01e,	0x77ff, 0xc01e,		0x21, 0
	.dw 0x7840, 0xc01e,	0x787f, 0xc01e,		0x21, 0
	.dw 0x78c0, 0xc01e,	0x78ff, 0xc01e,		0x21, 0
	.dw 0x7940, 0xc01e,	0x797f, 0xc01e,		0x21, 0
	.dw 0x79c0, 0xc01e,	0x7fff, 0xc01e,		0x21, 0
	.dw 0x8040, 0xc01e,	0x807f, 0xc01e,		0x21, 0
	.dw 0x80c0, 0xc01e,	0x80ff, 0xc01e,		0x21, 0
	.dw 0x8140, 0xc01e,	0x817f, 0xc01e,		0x21, 0
	.dw 0x81c0, 0xc01e,	0x81ff, 0xc01e,		0x21, 0
	.dw 0x8240, 0xc01e,	0x827f, 0xc01e,		0x21, 0
	.dw 0x82c0, 0xc01e,	0x82ff, 0xc01e,		0x21, 0
	.dw 0x8340, 0xc01e,	0x837f, 0xc01e,		0x21, 0
	.dw 0x83c0, 0xc01e,	0x83ff, 0xc01e,		0x21, 0
	.dw 0x8440, 0xc01e,	0x847f, 0xc01e,		0x21, 0
	.dw 0x84c0, 0xc01e,	0x84ff, 0xc01e,		0x21, 0
	.dw 0x8540, 0xc01e,	0x857f, 0xc01e,		0x21, 0
	.dw 0x85c0, 0xc01e,	0x85ff, 0xc01e,		0x21, 0
	.dw 0x8640, 0xc01e,	0x867f, 0xc01e,		0x21, 0
	.dw 0x86c0, 0xc01e,	0x86ff, 0xc01e,		0x21, 0
	.dw 0x8740, 0xc01e,	0x877f, 0xc01e,		0x21, 0
	.dw 0x87c0, 0xc01e,	0x87ff, 0xc01e,		0x21, 0
	.dw 0x8840, 0xc01e,	0x887f, 0xc01e,		0x21, 0
	.dw 0x88c0, 0xc01e,	0x88ff, 0xc01e,		0x21, 0
	.dw 0x8940, 0xc01e,	0x897f, 0xc01e,		0x21, 0
	.dw 0x89c0, 0xc01e,	0x89ff, 0xc01e,		0x21, 0
	.dw 0x8a40, 0xc01e,	0x8a7f, 0xc01e,		0x21, 0
	.dw 0x8ac0, 0xc01e,	0x8aff, 0xc01e,		0x21, 0
	.dw 0x8b40, 0xc01e,	0x8b7f, 0xc01e,		0x21, 0
	.dw 0x8bc0, 0xc01e,	0x8bff, 0xc01e,		0x21, 0
	.dw 0x8c40, 0xc01e,	0x8c7f, 0xc01e,		0x21, 0
	.dw 0x8cc0, 0xc01e,	0x8cff, 0xc01e,		0x21, 0
	.dw 0x8d40, 0xc01e,	0x8d7f, 0xc01e,		0x21, 0
	.dw 0x8dc0, 0xc01e,	0x8dff, 0xc01e,		0x21, 0
	.dw 0x8e40, 0xc01e,	0x8e7f, 0xc01e,		0x21, 0
	.dw 0x8ec0, 0xc01e,	0x8eff, 0xc01e,		0x21, 0
	.dw 0x8f40, 0xc01e,	0x8f7f, 0xc01e,		0x21, 0
	.dw 0x8fc0, 0xc01e,	0x8fff, 0xc01e,		0x21, 0
	.dw 0x9040, 0xc01e,	0x907f, 0xc01e,		0x21, 0
	.dw 0x90c0, 0xc01e,	0x90ff, 0xc01e,		0x21, 0
	.dw 0x9140, 0xc01e,	0x917f, 0xc01e,		0x21, 0
	.dw 0x91c0, 0xc01e,	0x91ff, 0xc01e,		0x21, 0
	.dw 0x9240, 0xc01e,	0x927f, 0xc01e,		0x21, 0
	.dw 0x92c0, 0xc01e,	0x92ff, 0xc01e,		0x21, 0
	.dw 0x9340, 0xc01e,	0x937f, 0xc01e,		0x21, 0
	.dw 0x93c0, 0xc01e,	0x93ff, 0xc01e,		0x21, 0
	.dw 0x9440, 0xc01e,	0x947f, 0xc01e,		0x21, 0
	.dw 0x94c0, 0xc01e,	0x94ff, 0xc01e,		0x21, 0
	.dw 0x9540, 0xc01e,	0x957f, 0xc01e,		0x21, 0
	.dw 0x95c0, 0xc01e,	0x95ff, 0xc01e,		0x21, 0
	.dw 0x9640, 0xc01e,	0x967f, 0xc01e,		0x21, 0
	.dw 0x96c0, 0xc01e,	0x96ff, 0xc01e,		0x21, 0
	.dw 0x9740, 0xc01e,	0x977f, 0xc01e,		0x21, 0
	.dw 0x97c0, 0xc01e,	0x97ff, 0xc01e,		0x21, 0
	.dw 0x9840, 0xc01e,	0x987f, 0xc01e,		0x21, 0
	.dw 0x98c0, 0xc01e,	0x98ff, 0xc01e,		0x21, 0
	.dw 0x9940, 0xc01e,	0x997f, 0xc01e,		0x21, 0
	.dw 0x99c0, 0xc01e,	0x9fff, 0xc01e,		0x21, 0
	.dw 0xa040, 0xc01e,	0xa07f, 0xc01e,		0x21, 0
	.dw 0xa0c0, 0xc01e,	0xa0ff, 0xc01e,		0x21, 0
	.dw 0xa140, 0xc01e,	0xa17f, 0xc01e,		0x21, 0
	.dw 0xa1c0, 0xc01e,	0xa1ff, 0xc01e,		0x21, 0
	.dw 0xa240, 0xc01e,	0xa27f, 0xc01e,		0x21, 0
	.dw 0xa2c0, 0xc01e,	0xa2ff, 0xc01e,		0x21, 0
	.dw 0xa340, 0xc01e,	0xa37f, 0xc01e,		0x21, 0
	.dw 0xa3c0, 0xc01e,	0xa3ff, 0xc01e,		0x21, 0
	.dw 0xa440, 0xc01e,	0xa47f, 0xc01e,		0x21, 0
	.dw 0xa4c0, 0xc01e,	0xa4ff, 0xc01e,		0x21, 0
	.dw 0xa540, 0xc01e,	0xa57f, 0xc01e,		0x21, 0
	.dw 0xa5c0, 0xc01e,	0xa5ff, 0xc01e,		0x21, 0
	.dw 0xa640, 0xc01e,	0xa67f, 0xc01e,		0x21, 0
	.dw 0xa6c0, 0xc01e,	0xa6ff, 0xc01e,		0x21, 0
	.dw 0xa740, 0xc01e,	0xa77f, 0xc01e,		0x21, 0
	.dw 0xa7c0, 0xc01e,	0xa7ff, 0xc01e,		0x21, 0
	.dw 0xa840, 0xc01e,	0xa87f, 0xc01e,		0x21, 0
	.dw 0xa8c0, 0xc01e,	0xa8ff, 0xc01e,		0x21, 0
	.dw 0xa940, 0xc01e,	0xa97f, 0xc01e,		0x21, 0
	.dw 0xa9c0, 0xc01e,	0xa9ff, 0xc01e,		0x21, 0
	.dw 0xaa40, 0xc01e,	0xaa7f, 0xc01e,		0x21, 0
	.dw 0xaac0, 0xc01e,	0xaaff, 0xc01e,		0x21, 0
	.dw 0xab40, 0xc01e,	0xab7f, 0xc01e,		0x21, 0
	.dw 0xabc0, 0xc01e,	0xabff, 0xc01e,		0x21, 0
	.dw 0xac40, 0xc01e,	0xac7f, 0xc01e,		0x21, 0
	.dw 0xacc0, 0xc01e,	0xacff, 0xc01e,		0x21, 0
	.dw 0xad40, 0xc01e,	0xad7f, 0xc01e,		0x21, 0
	.dw 0xadc0, 0xc01e,	0xadff, 0xc01e,		0x21, 0
	.dw 0xae40, 0xc01e,	0xae7f, 0xc01e,		0x21, 0
	.dw 0xaec0, 0xc01e,	0xaeff, 0xc01e,		0x21, 0
	.dw 0xaf40, 0xc01e,	0xaf7f, 0xc01e,		0x21, 0
	.dw 0xafc0, 0xc01e,	0xafff, 0xc01e,		0x21, 0
	.dw 0xb040, 0xc01e,	0xb07f, 0xc01e,		0x21, 0
	.dw 0xb0c0, 0xc01e,	0xb0ff, 0xc01e,		0x21, 0
	.dw 0xb140, 0xc01e,	0xb17f, 0xc01e,		0x21, 0
	.dw 0xb1c0, 0xc01e,	0xb1ff, 0xc01e,		0x21, 0
	.dw 0xb240, 0xc01e,	0xb27f, 0xc01e,		0x21, 0
	.dw 0xb2c0, 0xc01e,	0xb2ff, 0xc01e,		0x21, 0
	.dw 0xb340, 0xc01e,	0xb37f, 0xc01e,		0x21, 0
	.dw 0xb3c0, 0xc01e,	0xb3ff, 0xc01e,		0x21, 0
	.dw 0xb440, 0xc01e,	0xb47f, 0xc01e,		0x21, 0
	.dw 0xb4c0, 0xc01e,	0xb4ff, 0xc01e,		0x21, 0
	.dw 0xb540, 0xc01e,	0xb57f, 0xc01e,		0x21, 0
	.dw 0xb5c0, 0xc01e,	0xb5ff, 0xc01e,		0x21, 0
	.dw 0xb640, 0xc01e,	0xb67f, 0xc01e,		0x21, 0
	.dw 0xb6c0, 0xc01e,	0xb6ff, 0xc01e,		0x21, 0
	.dw 0xb740, 0xc01e,	0xb77f, 0xc01e,		0x21, 0
	.dw 0xb7c0, 0xc01e,	0xb7ff, 0xc01e,		0x21, 0
	.dw 0xb840, 0xc01e,	0xb87f, 0xc01e,		0x21, 0
	.dw 0xb8c0, 0xc01e,	0xb8ff, 0xc01e,		0x21, 0
	.dw 0xb940, 0xc01e,	0xb97f, 0xc01e,		0x21, 0
	.dw 0xb9c0, 0xc01e,	0xbfff, 0xc01e,		0x21, 0
	.dw 0xc040, 0xc01e,	0xc07f, 0xc01e,		0x21, 0
	.dw 0xc0c0, 0xc01e,	0xc0ff, 0xc01e,		0x21, 0
	.dw 0xc140, 0xc01e,	0xc17f, 0xc01e,		0x21, 0
	.dw 0xc1c0, 0xc01e,	0xc1ff, 0xc01e,		0x21, 0
	.dw 0xc240, 0xc01e,	0xc27f, 0xc01e,		0x21, 0
	.dw 0xc2c0, 0xc01e,	0xc2ff, 0xc01e,		0x21, 0
	.dw 0xc340, 0xc01e,	0xc37f, 0xc01e,		0x21, 0
	.dw 0xc3c0, 0xc01e,	0xc3ff, 0xc01e,		0x21, 0
	.dw 0xc440, 0xc01e,	0xc47f, 0xc01e,		0x21, 0
	.dw 0xc4c0, 0xc01e,	0xc4ff, 0xc01e,		0x21, 0
	.dw 0xc540, 0xc01e,	0xc57f, 0xc01e,		0x21, 0
	.dw 0xc5c0, 0xc01e,	0xc5ff, 0xc01e,		0x21, 0
	.dw 0xc640, 0xc01e,	0xc67f, 0xc01e,		0x21, 0
	.dw 0xc6c0, 0xc01e,	0xc6ff, 0xc01e,		0x21, 0
	.dw 0xc740, 0xc01e,	0xc77f, 0xc01e,		0x21, 0
	.dw 0xc7c0, 0xc01e,	0xc7ff, 0xc01e,		0x21, 0
	.dw 0xc840, 0xc01e,	0xc87f, 0xc01e,		0x21, 0
	.dw 0xc8c0, 0xc01e,	0xc8ff, 0xc01e,		0x21, 0
	.dw 0xc940, 0xc01e,	0xc97f, 0xc01e,		0x21, 0
	.dw 0xc9c0, 0xc01e,	0xc9ff, 0xc01e,		0x21, 0
	.dw 0xca40, 0xc01e,	0xca7f, 0xc01e,		0x21, 0
	.dw 0xcac0, 0xc01e,	0xcaff, 0xc01e,		0x21, 0
	.dw 0xcb40, 0xc01e,	0xcb7f, 0xc01e,		0x21, 0
	.dw 0xcbc0, 0xc01e,	0xcbff, 0xc01e,		0x21, 0
	.dw 0xcc40, 0xc01e,	0xcc7f, 0xc01e,		0x21, 0
	.dw 0xccc0, 0xc01e,	0xccff, 0xc01e,		0x21, 0
	.dw 0xcd40, 0xc01e,	0xcd7f, 0xc01e,		0x21, 0
	.dw 0xcdc0, 0xc01e,	0xcdff, 0xc01e,		0x21, 0
	.dw 0xce40, 0xc01e,	0xce7f, 0xc01e,		0x21, 0
	.dw 0xcec0, 0xc01e,	0xceff, 0xc01e,		0x21, 0
	.dw 0xcf40, 0xc01e,	0xcf7f, 0xc01e,		0x21, 0
	.dw 0xcfc0, 0xc01e,	0xcfff, 0xc01e,		0x21, 0
	.dw 0xd040, 0xc01e,	0xd07f, 0xc01e,		0x21, 0
	.dw 0xd0c0, 0xc01e,	0xd0ff, 0xc01e,		0x21, 0
	.dw 0xd140, 0xc01e,	0xd17f, 0xc01e,		0x21, 0
	.dw 0xd1c0, 0xc01e,	0xd1ff, 0xc01e,		0x21, 0
	.dw 0xd240, 0xc01e,	0xd27f, 0xc01e,		0x21, 0
	.dw 0xd2c0, 0xc01e,	0xd2ff, 0xc01e,		0x21, 0
	.dw 0xd340, 0xc01e,	0xd37f, 0xc01e,		0x21, 0
	.dw 0xd3c0, 0xc01e,	0xd3ff, 0xc01e,		0x21, 0
	.dw 0xd440, 0xc01e,	0xd47f, 0xc01e,		0x21, 0
	.dw 0xd4c0, 0xc01e,	0xd4ff, 0xc01e,		0x21, 0
	.dw 0xd540, 0xc01e,	0xd57f, 0xc01e,		0x21, 0
	.dw 0xd5c0, 0xc01e,	0xd5ff, 0xc01e,		0x21, 0
	.dw 0xd640, 0xc01e,	0xd67f, 0xc01e,		0x21, 0
	.dw 0xd6c0, 0xc01e,	0xd6ff, 0xc01e,		0x21, 0
	.dw 0xd740, 0xc01e,	0xd77f, 0xc01e,		0x21, 0
	.dw 0xd7c0, 0xc01e,	0xd7ff, 0xc01e,		0x21, 0
	.dw 0xd840, 0xc01e,	0xd87f, 0xc01e,		0x21, 0
	.dw 0xd8c0, 0xc01e,	0xd8ff, 0xc01e,		0x21, 0
	.dw 0xd940, 0xc01e,	0xd97f, 0xc01e,		0x21, 0
	.dw 0xd9c0, 0xc01e,	0xdfff, 0xc01e,		0x21, 0
	.dw 0xe040, 0xc01e,	0xe07f, 0xc01e,		0x21, 0
	.dw 0xe0c0, 0xc01e,	0xe0ff, 0xc01e,		0x21, 0
	.dw 0xe140, 0xc01e,	0xe17f, 0xc01e,		0x21, 0
	.dw 0xe1c0, 0xc01e,	0xe1ff, 0xc01e,		0x21, 0
	.dw 0xe240, 0xc01e,	0xe27f, 0xc01e,		0x21, 0
	.dw 0xe2c0, 0xc01e,	0xe2ff, 0xc01e,		0x21, 0
	.dw 0xe340, 0xc01e,	0xe37f, 0xc01e,		0x21, 0
	.dw 0xe3c0, 0xc01e,	0xe3ff, 0xc01e,		0x21, 0
	.dw 0xe440, 0xc01e,	0xe47f, 0xc01e,		0x21, 0
	.dw 0xe4c0, 0xc01e,	0xe4ff, 0xc01e,		0x21, 0
	.dw 0xe540, 0xc01e,	0xe57f, 0xc01e,		0x21, 0
	.dw 0xe5c0, 0xc01e,	0xe5ff, 0xc01e,		0x21, 0
	.dw 0xe640, 0xc01e,	0xe67f, 0xc01e,		0x21, 0
	.dw 0xe6c0, 0xc01e,	0xe6ff, 0xc01e,		0x21, 0
	.dw 0xe740, 0xc01e,	0xe77f, 0xc01e,		0x21, 0
	.dw 0xe7c0, 0xc01e,	0xe7ff, 0xc01e,		0x21, 0
	.dw 0xe840, 0xc01e,	0xe87f, 0xc01e,		0x21, 0
	.dw 0xe8c0, 0xc01e,	0xe8ff, 0xc01e,		0x21, 0
	.dw 0xe940, 0xc01e,	0xe97f, 0xc01e,		0x21, 0
	.dw 0xe9c0, 0xc01e,	0xe9ff, 0xc01e,		0x21, 0
	.dw 0xea40, 0xc01e,	0xea7f, 0xc01e,		0x21, 0
	.dw 0xeac0, 0xc01e,	0xeaff, 0xc01e,		0x21, 0
	.dw 0xeb40, 0xc01e,	0xeb7f, 0xc01e,		0x21, 0
	.dw 0xebc0, 0xc01e,	0xebff, 0xc01e,		0x21, 0
	.dw 0xec40, 0xc01e,	0xec7f, 0xc01e,		0x21, 0
	.dw 0xecc0, 0xc01e,	0xecff, 0xc01e,		0x21, 0
	.dw 0xed40, 0xc01e,	0xed7f, 0xc01e,		0x21, 0
	.dw 0xedc0, 0xc01e,	0xedff, 0xc01e,		0x21, 0
	.dw 0xee40, 0xc01e,	0xee7f, 0xc01e,		0x21, 0
	.dw 0xeec0, 0xc01e,	0xeeff, 0xc01e,		0x21, 0
	.dw 0xef40, 0xc01e,	0xef7f, 0xc01e,		0x21, 0
	.dw 0xefc0, 0xc01e,	0xefff, 0xc01e,		0x21, 0
	.dw 0xf040, 0xc01e,	0xf07f, 0xc01e,		0x21, 0
	.dw 0xf0c0, 0xc01e,	0xf0ff, 0xc01e,		0x21, 0
	.dw 0xf140, 0xc01e,	0xf17f, 0xc01e,		0x21, 0
	.dw 0xf1c0, 0xc01e,	0xf1ff, 0xc01e,		0x21, 0
	.dw 0xf240, 0xc01e,	0xf27f, 0xc01e,		0x21, 0
	.dw 0xf2c0, 0xc01e,	0xf2ff, 0xc01e,		0x21, 0
	.dw 0xf340, 0xc01e,	0xf37f, 0xc01e,		0x21, 0
	.dw 0xf3c0, 0xc01e,	0xf3ff, 0xc01e,		0x21, 0
	.dw 0xf440, 0xc01e,	0xf47f, 0xc01e,		0x21, 0
	.dw 0xf4c0, 0xc01e,	0xf4ff, 0xc01e,		0x21, 0
	.dw 0xf540, 0xc01e,	0xf57f, 0xc01e,		0x21, 0
	.dw 0xf5c0, 0xc01e,	0xf5ff, 0xc01e,		0x21, 0
	.dw 0xf640, 0xc01e,	0xf67f, 0xc01e,		0x21, 0
	.dw 0xf6c0, 0xc01e,	0xf6ff, 0xc01e,		0x21, 0
	.dw 0xf740, 0xc01e,	0xf77f, 0xc01e,		0x21, 0
	.dw 0xf7c0, 0xc01e,	0xf7ff, 0xc01e,		0x21, 0
	.dw 0xf840, 0xc01e,	0xf87f, 0xc01e,		0x21, 0
	.dw 0xf8c0, 0xc01e,	0xf8ff, 0xc01e,		0x21, 0
	.dw 0xf940, 0xc01e,	0xf97f, 0xc01e,		0x21, 0
	.dw 0xf9c0, 0xc01e,	0xffff, 0xc01e,		0x21, 0
	.dw 0x0040, 0xc01f,	0x007f, 0xc01f,		0x21, 0
	.dw 0x00c0, 0xc01f,	0x00ff, 0xc01f,		0x21, 0
	.dw 0x0140, 0xc01f,	0x017f, 0xc01f,		0x21, 0
	.dw 0x01c0, 0xc01f,	0x01ff, 0xc01f,		0x21, 0
	.dw 0x0240, 0xc01f,	0x027f, 0xc01f,		0x21, 0
	.dw 0x02c0, 0xc01f,	0x02ff, 0xc01f,		0x21, 0
	.dw 0x0340, 0xc01f,	0x037f, 0xc01f,		0x21, 0
	.dw 0x03c0, 0xc01f,	0x03ff, 0xc01f,		0x21, 0
	.dw 0x0440, 0xc01f,	0x047f, 0xc01f,		0x21, 0
	.dw 0x04c0, 0xc01f,	0x04ff, 0xc01f,		0x21, 0
	.dw 0x0540, 0xc01f,	0x057f, 0xc01f,		0x21, 0
	.dw 0x05c0, 0xc01f,	0x05ff, 0xc01f,		0x21, 0
	.dw 0x0640, 0xc01f,	0x067f, 0xc01f,		0x21, 0
	.dw 0x06c0, 0xc01f,	0x06ff, 0xc01f,		0x21, 0
	.dw 0x0740, 0xc01f,	0x077f, 0xc01f,		0x21, 0
	.dw 0x07c0, 0xc01f,	0x07ff, 0xc01f,		0x21, 0
	.dw 0x0840, 0xc01f,	0x087f, 0xc01f,		0x21, 0
	.dw 0x08c0, 0xc01f,	0x08ff, 0xc01f,		0x21, 0
	.dw 0x0940, 0xc01f,	0x097f, 0xc01f,		0x21, 0
	.dw 0x09c0, 0xc01f,	0x09ff, 0xc01f,		0x21, 0
	.dw 0x0a40, 0xc01f,	0x0a7f, 0xc01f,		0x21, 0
	.dw 0x0ac0, 0xc01f,	0x0aff, 0xc01f,		0x21, 0
	.dw 0x0b40, 0xc01f,	0x0b7f, 0xc01f,		0x21, 0
	.dw 0x0bc0, 0xc01f,	0x0bff, 0xc01f,		0x21, 0
	.dw 0x0c40, 0xc01f,	0x0c7f, 0xc01f,		0x21, 0
	.dw 0x0cc0, 0xc01f,	0x0cff, 0xc01f,		0x21, 0
	.dw 0x0d40, 0xc01f,	0x0d7f, 0xc01f,		0x21, 0
	.dw 0x0dc0, 0xc01f,	0x0dff, 0xc01f,		0x21, 0
	.dw 0x0e40, 0xc01f,	0x0e7f, 0xc01f,		0x21, 0
	.dw 0x0ec0, 0xc01f,	0x0eff, 0xc01f,		0x21, 0
	.dw 0x0f40, 0xc01f,	0x0f7f, 0xc01f,		0x21, 0
	.dw 0x0fc0, 0xc01f,	0x0fff, 0xc01f,		0x21, 0
	.dw 0x1040, 0xc01f,	0x107f, 0xc01f,		0x21, 0
	.dw 0x10c0, 0xc01f,	0x10ff, 0xc01f,		0x21, 0
	.dw 0x1140, 0xc01f,	0x117f, 0xc01f,		0x21, 0
	.dw 0x11c0, 0xc01f,	0x11ff, 0xc01f,		0x21, 0
	.dw 0x1240, 0xc01f,	0x127f, 0xc01f,		0x21, 0
	.dw 0x12c0, 0xc01f,	0x12ff, 0xc01f,		0x21, 0
	.dw 0x1340, 0xc01f,	0x137f, 0xc01f,		0x21, 0
	.dw 0x13c0, 0xc01f,	0x13ff, 0xc01f,		0x21, 0
	.dw 0x1440, 0xc01f,	0x147f, 0xc01f,		0x21, 0
	.dw 0x14c0, 0xc01f,	0x14ff, 0xc01f,		0x21, 0
	.dw 0x1540, 0xc01f,	0x157f, 0xc01f,		0x21, 0
	.dw 0x15c0, 0xc01f,	0x15ff, 0xc01f,		0x21, 0
	.dw 0x1640, 0xc01f,	0x167f, 0xc01f,		0x21, 0
	.dw 0x16c0, 0xc01f,	0x16ff, 0xc01f,		0x21, 0
	.dw 0x1740, 0xc01f,	0x177f, 0xc01f,		0x21, 0
	.dw 0x17c0, 0xc01f,	0x17ff, 0xc01f,		0x21, 0
	.dw 0x1840, 0xc01f,	0x187f, 0xc01f,		0x21, 0
	.dw 0x18c0, 0xc01f,	0x18ff, 0xc01f,		0x21, 0
	.dw 0x1940, 0xc01f,	0x197f, 0xc01f,		0x21, 0
	.dw 0x19c0, 0xc01f,	0x1fff, 0xc01f,		0x21, 0
	.dw 0x2040, 0xc01f,	0x207f, 0xc01f,		0x21, 0
	.dw 0x20c0, 0xc01f,	0x20ff, 0xc01f,		0x21, 0
	.dw 0x2140, 0xc01f,	0x217f, 0xc01f,		0x21, 0
	.dw 0x21c0, 0xc01f,	0x21ff, 0xc01f,		0x21, 0
	.dw 0x2240, 0xc01f,	0x227f, 0xc01f,		0x21, 0
	.dw 0x22c0, 0xc01f,	0x22ff, 0xc01f,		0x21, 0
	.dw 0x2340, 0xc01f,	0x237f, 0xc01f,		0x21, 0
	.dw 0x23c0, 0xc01f,	0x23ff, 0xc01f,		0x21, 0
	.dw 0x2440, 0xc01f,	0x247f, 0xc01f,		0x21, 0
	.dw 0x24c0, 0xc01f,	0x24ff, 0xc01f,		0x21, 0
	.dw 0x2540, 0xc01f,	0x257f, 0xc01f,		0x21, 0
	.dw 0x25c0, 0xc01f,	0x25ff, 0xc01f,		0x21, 0
	.dw 0x2640, 0xc01f,	0x267f, 0xc01f,		0x21, 0
	.dw 0x26c0, 0xc01f,	0x26ff, 0xc01f,		0x21, 0
	.dw 0x2740, 0xc01f,	0x277f, 0xc01f,		0x21, 0
	.dw 0x27c0, 0xc01f,	0x27ff, 0xc01f,		0x21, 0
	.dw 0x2840, 0xc01f,	0x287f, 0xc01f,		0x21, 0
	.dw 0x28c0, 0xc01f,	0x28ff, 0xc01f,		0x21, 0
	.dw 0x2940, 0xc01f,	0x297f, 0xc01f,		0x21, 0
	.dw 0x29c0, 0xc01f,	0x29ff, 0xc01f,		0x21, 0
	.dw 0x2a40, 0xc01f,	0x2a7f, 0xc01f,		0x21, 0
	.dw 0x2ac0, 0xc01f,	0x2aff, 0xc01f,		0x21, 0
	.dw 0x2b40, 0xc01f,	0x2b7f, 0xc01f,		0x21, 0
	.dw 0x2bc0, 0xc01f,	0x2bff, 0xc01f,		0x21, 0
	.dw 0x2c40, 0xc01f,	0x2c7f, 0xc01f,		0x21, 0
	.dw 0x2cc0, 0xc01f,	0x2cff, 0xc01f,		0x21, 0
	.dw 0x2d40, 0xc01f,	0x2d7f, 0xc01f,		0x21, 0
	.dw 0x2dc0, 0xc01f,	0x2dff, 0xc01f,		0x21, 0
	.dw 0x2e40, 0xc01f,	0x2e7f, 0xc01f,		0x21, 0
	.dw 0x2ec0, 0xc01f,	0x2eff, 0xc01f,		0x21, 0
	.dw 0x2f40, 0xc01f,	0x2f7f, 0xc01f,		0x21, 0
	.dw 0x2fc0, 0xc01f,	0x2fff, 0xc01f,		0x21, 0
	.dw 0x3040, 0xc01f,	0x307f, 0xc01f,		0x21, 0
	.dw 0x30c0, 0xc01f,	0x30ff, 0xc01f,		0x21, 0
	.dw 0x3140, 0xc01f,	0x317f, 0xc01f,		0x21, 0
	.dw 0x31c0, 0xc01f,	0x31ff, 0xc01f,		0x21, 0
	.dw 0x3240, 0xc01f,	0x327f, 0xc01f,		0x21, 0
	.dw 0x32c0, 0xc01f,	0x32ff, 0xc01f,		0x21, 0
	.dw 0x3340, 0xc01f,	0x337f, 0xc01f,		0x21, 0
	.dw 0x33c0, 0xc01f,	0x33ff, 0xc01f,		0x21, 0
	.dw 0x3440, 0xc01f,	0x347f, 0xc01f,		0x21, 0
	.dw 0x34c0, 0xc01f,	0x34ff, 0xc01f,		0x21, 0
	.dw 0x3540, 0xc01f,	0x357f, 0xc01f,		0x21, 0
	.dw 0x35c0, 0xc01f,	0x35ff, 0xc01f,		0x21, 0
	.dw 0x3640, 0xc01f,	0x367f, 0xc01f,		0x21, 0
	.dw 0x36c0, 0xc01f,	0x36ff, 0xc01f,		0x21, 0
	.dw 0x3740, 0xc01f,	0x377f, 0xc01f,		0x21, 0
	.dw 0x37c0, 0xc01f,	0x37ff, 0xc01f,		0x21, 0
	.dw 0x3840, 0xc01f,	0x387f, 0xc01f,		0x21, 0
	.dw 0x38c0, 0xc01f,	0x38ff, 0xc01f,		0x21, 0
	.dw 0x3940, 0xc01f,	0x397f, 0xc01f,		0x21, 0
	.dw 0x39c0, 0xc01f,	0x1fff, 0xc020,		0x21, 0
	.dw 0x3a00, 0xc020,	0x5fff, 0xc020,		0x21, 0
	.dw 0x7a00, 0xc020,	0x9fff, 0xc020,		0x21, 0
	.dw 0xba00, 0xc020,	0xdfff, 0xc020,		0x21, 0
	.dw 0xfa00, 0xc020,	0x1fff, 0xc021,		0x21, 0
	.dw 0x3a00, 0xc021,	0x5fff, 0xc021,		0x21, 0
	.dw 0x7a00, 0xc021,	0x9fff, 0xc021,		0x21, 0
	.dw 0xba00, 0xc021,	0xdfff, 0xc021,		0x21, 0
	.dw 0xfa00, 0xc021,	0x1fff, 0xc022,		0x21, 0
	.dw 0x3a00, 0xc022,	0x5fff, 0xc022,		0x21, 0
	.dw 0x7a00, 0xc022,	0x9fff, 0xc022,		0x21, 0
	.dw 0xba00, 0xc022,	0xdfff, 0xc022,		0x21, 0
	.dw 0xfa00, 0xc022,	0x1fff, 0xc023,		0x21, 0
	.dw 0x3a00, 0xc023,	0xffff, 0xc023,		0x21, 0
	.dw 0x1a00, 0xc024,	0x1fff, 0xc024,		0x21, 0
	.dw 0x3a00, 0xc024,	0x3fff, 0xc024,		0x21, 0
	.dw 0x5a00, 0xc024,	0x5fff, 0xc024,		0x21, 0
	.dw 0x7a00, 0xc024,	0x7fff, 0xc024,		0x21, 0
	.dw 0x9a00, 0xc024,	0x9fff, 0xc024,		0x21, 0
	.dw 0xba00, 0xc024,	0xbfff, 0xc024,		0x21, 0
	.dw 0xda00, 0xc024,	0xdfff, 0xc024,		0x21, 0
	.dw 0xfa00, 0xc024,	0xffff, 0xc024,		0x21, 0
	.dw 0x1a00, 0xc025,	0x1fff, 0xc025,		0x21, 0
	.dw 0x3a00, 0xc025,	0x3fff, 0xc025,		0x21, 0
	.dw 0x5a00, 0xc025,	0x5fff, 0xc025,		0x21, 0
	.dw 0x7a00, 0xc025,	0x7fff, 0xc025,		0x21, 0
	.dw 0x9a00, 0xc025,	0x9fff, 0xc025,		0x21, 0
	.dw 0xba00, 0xc025,	0xbfff, 0xc025,		0x21, 0
	.dw 0xda00, 0xc025,	0xdfff, 0xc025,		0x21, 0
	.dw 0xfa00, 0xc025,	0xffff, 0xc025,		0x21, 0
	.dw 0x1a00, 0xc026,	0x1fff, 0xc026,		0x21, 0
	.dw 0x3a00, 0xc026,	0x3fff, 0xc026,		0x21, 0
	.dw 0x5a00, 0xc026,	0x5fff, 0xc026,		0x21, 0
	.dw 0x7a00, 0xc026,	0x7fff, 0xc026,		0x21, 0
	.dw 0x9a00, 0xc026,	0x9fff, 0xc026,		0x21, 0
	.dw 0xba00, 0xc026,	0xbfff, 0xc026,		0x21, 0
	.dw 0xda00, 0xc026,	0xdfff, 0xc026,		0x21, 0
	.dw 0xfa00, 0xc026,	0xffff, 0xc026,		0x21, 0
	.dw 0x1a00, 0xc027,	0x1fff, 0xc027,		0x21, 0
	.dw 0x3a00, 0xc027,	0x1fff, 0xc028,		0x21, 0
	.dw 0x2040, 0xc028,	0x207f, 0xc028,		0x21, 0
	.dw 0x20c0, 0xc028,	0x20ff, 0xc028,		0x21, 0
	.dw 0x2140, 0xc028,	0x217f, 0xc028,		0x21, 0
	.dw 0x21c0, 0xc028,	0x21ff, 0xc028,		0x21, 0
	.dw 0x2240, 0xc028,	0x227f, 0xc028,		0x21, 0
	.dw 0x22c0, 0xc028,	0x22ff, 0xc028,		0x21, 0
	.dw 0x2340, 0xc028,	0x237f, 0xc028,		0x21, 0
	.dw 0x23c0, 0xc028,	0x23ff, 0xc028,		0x21, 0
	.dw 0x2440, 0xc028,	0x247f, 0xc028,		0x21, 0
	.dw 0x24c0, 0xc028,	0x24ff, 0xc028,		0x21, 0
	.dw 0x2540, 0xc028,	0x257f, 0xc028,		0x21, 0
	.dw 0x25c0, 0xc028,	0x25ff, 0xc028,		0x21, 0
	.dw 0x2640, 0xc028,	0x267f, 0xc028,		0x21, 0
	.dw 0x26c0, 0xc028,	0x26ff, 0xc028,		0x21, 0
	.dw 0x2740, 0xc028,	0x277f, 0xc028,		0x21, 0
	.dw 0x27c0, 0xc028,	0x27ff, 0xc028,		0x21, 0
	.dw 0x2840, 0xc028,	0x287f, 0xc028,		0x21, 0
	.dw 0x28c0, 0xc028,	0x28ff, 0xc028,		0x21, 0
	.dw 0x2940, 0xc028,	0x297f, 0xc028,		0x21, 0
	.dw 0x29c0, 0xc028,	0x29ff, 0xc028,		0x21, 0
	.dw 0x2a40, 0xc028,	0x2a7f, 0xc028,		0x21, 0
	.dw 0x2ac0, 0xc028,	0x2aff, 0xc028,		0x21, 0
	.dw 0x2b40, 0xc028,	0x2b7f, 0xc028,		0x21, 0
	.dw 0x2bc0, 0xc028,	0x2bff, 0xc028,		0x21, 0
	.dw 0x2c40, 0xc028,	0x2c7f, 0xc028,		0x21, 0
	.dw 0x2cc0, 0xc028,	0x2cff, 0xc028,		0x21, 0
	.dw 0x2d40, 0xc028,	0x2d7f, 0xc028,		0x21, 0
	.dw 0x2dc0, 0xc028,	0x2dff, 0xc028,		0x21, 0
	.dw 0x2e40, 0xc028,	0x2e7f, 0xc028,		0x21, 0
	.dw 0x2ec0, 0xc028,	0x2eff, 0xc028,		0x21, 0
	.dw 0x2f40, 0xc028,	0x2f7f, 0xc028,		0x21, 0
	.dw 0x2fc0, 0xc028,	0x2fff, 0xc028,		0x21, 0
	.dw 0x3040, 0xc028,	0x307f, 0xc028,		0x21, 0
	.dw 0x30c0, 0xc028,	0x30ff, 0xc028,		0x21, 0
	.dw 0x3140, 0xc028,	0x317f, 0xc028,		0x21, 0
	.dw 0x31c0, 0xc028,	0x31ff, 0xc028,		0x21, 0
	.dw 0x3240, 0xc028,	0x327f, 0xc028,		0x21, 0
	.dw 0x32c0, 0xc028,	0x32ff, 0xc028,		0x21, 0
	.dw 0x3340, 0xc028,	0x337f, 0xc028,		0x21, 0
	.dw 0x33c0, 0xc028,	0x33ff, 0xc028,		0x21, 0
	.dw 0x3440, 0xc028,	0x347f, 0xc028,		0x21, 0
	.dw 0x34c0, 0xc028,	0x34ff, 0xc028,		0x21, 0
	.dw 0x3540, 0xc028,	0x357f, 0xc028,		0x21, 0
	.dw 0x35c0, 0xc028,	0x35ff, 0xc028,		0x21, 0
	.dw 0x3640, 0xc028,	0x367f, 0xc028,		0x21, 0
	.dw 0x36c0, 0xc028,	0x36ff, 0xc028,		0x21, 0
	.dw 0x3740, 0xc028,	0x377f, 0xc028,		0x21, 0
	.dw 0x37c0, 0xc028,	0x37ff, 0xc028,		0x21, 0
	.dw 0x3840, 0xc028,	0x387f, 0xc028,		0x21, 0
	.dw 0x38c0, 0xc028,	0x38ff, 0xc028,		0x21, 0
	.dw 0x3940, 0xc028,	0x397f, 0xc028,		0x21, 0
	.dw 0x39c0, 0xc028,	0x5fff, 0xc028,		0x21, 0
	.dw 0x6040, 0xc028,	0x607f, 0xc028,		0x21, 0
	.dw 0x60c0, 0xc028,	0x60ff, 0xc028,		0x21, 0
	.dw 0x6140, 0xc028,	0x617f, 0xc028,		0x21, 0
	.dw 0x61c0, 0xc028,	0x61ff, 0xc028,		0x21, 0
	.dw 0x6240, 0xc028,	0x627f, 0xc028,		0x21, 0
	.dw 0x62c0, 0xc028,	0x62ff, 0xc028,		0x21, 0
	.dw 0x6340, 0xc028,	0x637f, 0xc028,		0x21, 0
	.dw 0x63c0, 0xc028,	0x63ff, 0xc028,		0x21, 0
	.dw 0x6440, 0xc028,	0x647f, 0xc028,		0x21, 0
	.dw 0x64c0, 0xc028,	0x64ff, 0xc028,		0x21, 0
	.dw 0x6540, 0xc028,	0x657f, 0xc028,		0x21, 0
	.dw 0x65c0, 0xc028,	0x65ff, 0xc028,		0x21, 0
	.dw 0x6640, 0xc028,	0x667f, 0xc028,		0x21, 0
	.dw 0x66c0, 0xc028,	0x66ff, 0xc028,		0x21, 0
	.dw 0x6740, 0xc028,	0x677f, 0xc028,		0x21, 0
	.dw 0x67c0, 0xc028,	0x67ff, 0xc028,		0x21, 0
	.dw 0x6840, 0xc028,	0x687f, 0xc028,		0x21, 0
	.dw 0x68c0, 0xc028,	0x68ff, 0xc028,		0x21, 0
	.dw 0x6940, 0xc028,	0x697f, 0xc028,		0x21, 0
	.dw 0x69c0, 0xc028,	0x69ff, 0xc028,		0x21, 0
	.dw 0x6a40, 0xc028,	0x6a7f, 0xc028,		0x21, 0
	.dw 0x6ac0, 0xc028,	0x6aff, 0xc028,		0x21, 0
	.dw 0x6b40, 0xc028,	0x6b7f, 0xc028,		0x21, 0
	.dw 0x6bc0, 0xc028,	0x6bff, 0xc028,		0x21, 0
	.dw 0x6c40, 0xc028,	0x6c7f, 0xc028,		0x21, 0
	.dw 0x6cc0, 0xc028,	0x6cff, 0xc028,		0x21, 0
	.dw 0x6d40, 0xc028,	0x6d7f, 0xc028,		0x21, 0
	.dw 0x6dc0, 0xc028,	0x6dff, 0xc028,		0x21, 0
	.dw 0x6e40, 0xc028,	0x6e7f, 0xc028,		0x21, 0
	.dw 0x6ec0, 0xc028,	0x6eff, 0xc028,		0x21, 0
	.dw 0x6f40, 0xc028,	0x6f7f, 0xc028,		0x21, 0
	.dw 0x6fc0, 0xc028,	0x6fff, 0xc028,		0x21, 0
	.dw 0x7040, 0xc028,	0x707f, 0xc028,		0x21, 0
	.dw 0x70c0, 0xc028,	0x70ff, 0xc028,		0x21, 0
	.dw 0x7140, 0xc028,	0x717f, 0xc028,		0x21, 0
	.dw 0x71c0, 0xc028,	0x71ff, 0xc028,		0x21, 0
	.dw 0x7240, 0xc028,	0x727f, 0xc028,		0x21, 0
	.dw 0x72c0, 0xc028,	0x72ff, 0xc028,		0x21, 0
	.dw 0x7340, 0xc028,	0x737f, 0xc028,		0x21, 0
	.dw 0x73c0, 0xc028,	0x73ff, 0xc028,		0x21, 0
	.dw 0x7440, 0xc028,	0x747f, 0xc028,		0x21, 0
	.dw 0x74c0, 0xc028,	0x74ff, 0xc028,		0x21, 0
	.dw 0x7540, 0xc028,	0x757f, 0xc028,		0x21, 0
	.dw 0x75c0, 0xc028,	0x75ff, 0xc028,		0x21, 0
	.dw 0x7640, 0xc028,	0x767f, 0xc028,		0x21, 0
	.dw 0x76c0, 0xc028,	0x76ff, 0xc028,		0x21, 0
	.dw 0x7740, 0xc028,	0x777f, 0xc028,		0x21, 0
	.dw 0x77c0, 0xc028,	0x77ff, 0xc028,		0x21, 0
	.dw 0x7840, 0xc028,	0x787f, 0xc028,		0x21, 0
	.dw 0x78c0, 0xc028,	0x78ff, 0xc028,		0x21, 0
	.dw 0x7940, 0xc028,	0x797f, 0xc028,		0x21, 0
	.dw 0x79c0, 0xc028,	0x9fff, 0xc028,		0x21, 0
	.dw 0xa040, 0xc028,	0xa07f, 0xc028,		0x21, 0
	.dw 0xa0c0, 0xc028,	0xa0ff, 0xc028,		0x21, 0
	.dw 0xa140, 0xc028,	0xa17f, 0xc028,		0x21, 0
	.dw 0xa1c0, 0xc028,	0xa1ff, 0xc028,		0x21, 0
	.dw 0xa240, 0xc028,	0xa27f, 0xc028,		0x21, 0
	.dw 0xa2c0, 0xc028,	0xa2ff, 0xc028,		0x21, 0
	.dw 0xa340, 0xc028,	0xa37f, 0xc028,		0x21, 0
	.dw 0xa3c0, 0xc028,	0xa3ff, 0xc028,		0x21, 0
	.dw 0xa440, 0xc028,	0xa47f, 0xc028,		0x21, 0
	.dw 0xa4c0, 0xc028,	0xa4ff, 0xc028,		0x21, 0
	.dw 0xa540, 0xc028,	0xa57f, 0xc028,		0x21, 0
	.dw 0xa5c0, 0xc028,	0xa5ff, 0xc028,		0x21, 0
	.dw 0xa640, 0xc028,	0xa67f, 0xc028,		0x21, 0
	.dw 0xa6c0, 0xc028,	0xa6ff, 0xc028,		0x21, 0
	.dw 0xa740, 0xc028,	0xa77f, 0xc028,		0x21, 0
	.dw 0xa7c0, 0xc028,	0xa7ff, 0xc028,		0x21, 0
	.dw 0xa840, 0xc028,	0xa87f, 0xc028,		0x21, 0
	.dw 0xa8c0, 0xc028,	0xa8ff, 0xc028,		0x21, 0
	.dw 0xa940, 0xc028,	0xa97f, 0xc028,		0x21, 0
	.dw 0xa9c0, 0xc028,	0xa9ff, 0xc028,		0x21, 0
	.dw 0xaa40, 0xc028,	0xaa7f, 0xc028,		0x21, 0
	.dw 0xaac0, 0xc028,	0xaaff, 0xc028,		0x21, 0
	.dw 0xab40, 0xc028,	0xab7f, 0xc028,		0x21, 0
	.dw 0xabc0, 0xc028,	0xabff, 0xc028,		0x21, 0
	.dw 0xac40, 0xc028,	0xac7f, 0xc028,		0x21, 0
	.dw 0xacc0, 0xc028,	0xacff, 0xc028,		0x21, 0
	.dw 0xad40, 0xc028,	0xad7f, 0xc028,		0x21, 0
	.dw 0xadc0, 0xc028,	0xadff, 0xc028,		0x21, 0
	.dw 0xae40, 0xc028,	0xae7f, 0xc028,		0x21, 0
	.dw 0xaec0, 0xc028,	0xaeff, 0xc028,		0x21, 0
	.dw 0xaf40, 0xc028,	0xaf7f, 0xc028,		0x21, 0
	.dw 0xafc0, 0xc028,	0xafff, 0xc028,		0x21, 0
	.dw 0xb040, 0xc028,	0xb07f, 0xc028,		0x21, 0
	.dw 0xb0c0, 0xc028,	0xb0ff, 0xc028,		0x21, 0
	.dw 0xb140, 0xc028,	0xb17f, 0xc028,		0x21, 0
	.dw 0xb1c0, 0xc028,	0xb1ff, 0xc028,		0x21, 0
	.dw 0xb240, 0xc028,	0xb27f, 0xc028,		0x21, 0
	.dw 0xb2c0, 0xc028,	0xb2ff, 0xc028,		0x21, 0
	.dw 0xb340, 0xc028,	0xb37f, 0xc028,		0x21, 0
	.dw 0xb3c0, 0xc028,	0xb3ff, 0xc028,		0x21, 0
	.dw 0xb440, 0xc028,	0xb47f, 0xc028,		0x21, 0
	.dw 0xb4c0, 0xc028,	0xb4ff, 0xc028,		0x21, 0
	.dw 0xb540, 0xc028,	0xb57f, 0xc028,		0x21, 0
	.dw 0xb5c0, 0xc028,	0xb5ff, 0xc028,		0x21, 0
	.dw 0xb640, 0xc028,	0xb67f, 0xc028,		0x21, 0
	.dw 0xb6c0, 0xc028,	0xb6ff, 0xc028,		0x21, 0
	.dw 0xb740, 0xc028,	0xb77f, 0xc028,		0x21, 0
	.dw 0xb7c0, 0xc028,	0xb7ff, 0xc028,		0x21, 0
	.dw 0xb840, 0xc028,	0xb87f, 0xc028,		0x21, 0
	.dw 0xb8c0, 0xc028,	0xb8ff, 0xc028,		0x21, 0
	.dw 0xb940, 0xc028,	0xb97f, 0xc028,		0x21, 0
	.dw 0xb9c0, 0xc028,	0xdfff, 0xc028,		0x21, 0
	.dw 0xe040, 0xc028,	0xe07f, 0xc028,		0x21, 0
	.dw 0xe0c0, 0xc028,	0xe0ff, 0xc028,		0x21, 0
	.dw 0xe140, 0xc028,	0xe17f, 0xc028,		0x21, 0
	.dw 0xe1c0, 0xc028,	0xe1ff, 0xc028,		0x21, 0
	.dw 0xe240, 0xc028,	0xe27f, 0xc028,		0x21, 0
	.dw 0xe2c0, 0xc028,	0xe2ff, 0xc028,		0x21, 0
	.dw 0xe340, 0xc028,	0xe37f, 0xc028,		0x21, 0
	.dw 0xe3c0, 0xc028,	0xe3ff, 0xc028,		0x21, 0
	.dw 0xe440, 0xc028,	0xe47f, 0xc028,		0x21, 0
	.dw 0xe4c0, 0xc028,	0xe4ff, 0xc028,		0x21, 0
	.dw 0xe540, 0xc028,	0xe57f, 0xc028,		0x21, 0
	.dw 0xe5c0, 0xc028,	0xe5ff, 0xc028,		0x21, 0
	.dw 0xe640, 0xc028,	0xe67f, 0xc028,		0x21, 0
	.dw 0xe6c0, 0xc028,	0xe6ff, 0xc028,		0x21, 0
	.dw 0xe740, 0xc028,	0xe77f, 0xc028,		0x21, 0
	.dw 0xe7c0, 0xc028,	0xe7ff, 0xc028,		0x21, 0
	.dw 0xe840, 0xc028,	0xe87f, 0xc028,		0x21, 0
	.dw 0xe8c0, 0xc028,	0xe8ff, 0xc028,		0x21, 0
	.dw 0xe940, 0xc028,	0xe97f, 0xc028,		0x21, 0
	.dw 0xe9c0, 0xc028,	0xe9ff, 0xc028,		0x21, 0
	.dw 0xea40, 0xc028,	0xea7f, 0xc028,		0x21, 0
	.dw 0xeac0, 0xc028,	0xeaff, 0xc028,		0x21, 0
	.dw 0xeb40, 0xc028,	0xeb7f, 0xc028,		0x21, 0
	.dw 0xebc0, 0xc028,	0xebff, 0xc028,		0x21, 0
	.dw 0xec40, 0xc028,	0xec7f, 0xc028,		0x21, 0
	.dw 0xecc0, 0xc028,	0xecff, 0xc028,		0x21, 0
	.dw 0xed40, 0xc028,	0xed7f, 0xc028,		0x21, 0
	.dw 0xedc0, 0xc028,	0xedff, 0xc028,		0x21, 0
	.dw 0xee40, 0xc028,	0xee7f, 0xc028,		0x21, 0
	.dw 0xeec0, 0xc028,	0xeeff, 0xc028,		0x21, 0
	.dw 0xef40, 0xc028,	0xef7f, 0xc028,		0x21, 0
	.dw 0xefc0, 0xc028,	0xefff, 0xc028,		0x21, 0
	.dw 0xf040, 0xc028,	0xf07f, 0xc028,		0x21, 0
	.dw 0xf0c0, 0xc028,	0xf0ff, 0xc028,		0x21, 0
	.dw 0xf140, 0xc028,	0xf17f, 0xc028,		0x21, 0
	.dw 0xf1c0, 0xc028,	0xf1ff, 0xc028,		0x21, 0
	.dw 0xf240, 0xc028,	0xf27f, 0xc028,		0x21, 0
	.dw 0xf2c0, 0xc028,	0xf2ff, 0xc028,		0x21, 0
	.dw 0xf340, 0xc028,	0xf37f, 0xc028,		0x21, 0
	.dw 0xf3c0, 0xc028,	0xf3ff, 0xc028,		0x21, 0
	.dw 0xf440, 0xc028,	0xf47f, 0xc028,		0x21, 0
	.dw 0xf4c0, 0xc028,	0xf4ff, 0xc028,		0x21, 0
	.dw 0xf540, 0xc028,	0xf57f, 0xc028,		0x21, 0
	.dw 0xf5c0, 0xc028,	0xf5ff, 0xc028,		0x21, 0
	.dw 0xf640, 0xc028,	0xf67f, 0xc028,		0x21, 0
	.dw 0xf6c0, 0xc028,	0xf6ff, 0xc028,		0x21, 0
	.dw 0xf740, 0xc028,	0xf77f, 0xc028,		0x21, 0
	.dw 0xf7c0, 0xc028,	0xf7ff, 0xc028,		0x21, 0
	.dw 0xf840, 0xc028,	0xf87f, 0xc028,		0x21, 0
	.dw 0xf8c0, 0xc028,	0xf8ff, 0xc028,		0x21, 0
	.dw 0xf940, 0xc028,	0xf97f, 0xc028,		0x21, 0
	.dw 0xf9c0, 0xc028,	0x1fff, 0xc029,		0x21, 0
	.dw 0x2040, 0xc029,	0x207f, 0xc029,		0x21, 0
	.dw 0x20c0, 0xc029,	0x20ff, 0xc029,		0x21, 0
	.dw 0x2140, 0xc029,	0x217f, 0xc029,		0x21, 0
	.dw 0x21c0, 0xc029,	0x21ff, 0xc029,		0x21, 0
	.dw 0x2240, 0xc029,	0x227f, 0xc029,		0x21, 0
	.dw 0x22c0, 0xc029,	0x22ff, 0xc029,		0x21, 0
	.dw 0x2340, 0xc029,	0x237f, 0xc029,		0x21, 0
	.dw 0x23c0, 0xc029,	0x23ff, 0xc029,		0x21, 0
	.dw 0x2440, 0xc029,	0x247f, 0xc029,		0x21, 0
	.dw 0x24c0, 0xc029,	0x24ff, 0xc029,		0x21, 0
	.dw 0x2540, 0xc029,	0x257f, 0xc029,		0x21, 0
	.dw 0x25c0, 0xc029,	0x25ff, 0xc029,		0x21, 0
	.dw 0x2640, 0xc029,	0x267f, 0xc029,		0x21, 0
	.dw 0x26c0, 0xc029,	0x26ff, 0xc029,		0x21, 0
	.dw 0x2740, 0xc029,	0x277f, 0xc029,		0x21, 0
	.dw 0x27c0, 0xc029,	0x27ff, 0xc029,		0x21, 0
	.dw 0x2840, 0xc029,	0x287f, 0xc029,		0x21, 0
	.dw 0x28c0, 0xc029,	0x28ff, 0xc029,		0x21, 0
	.dw 0x2940, 0xc029,	0x297f, 0xc029,		0x21, 0
	.dw 0x29c0, 0xc029,	0x29ff, 0xc029,		0x21, 0
	.dw 0x2a40, 0xc029,	0x2a7f, 0xc029,		0x21, 0
	.dw 0x2ac0, 0xc029,	0x2aff, 0xc029,		0x21, 0
	.dw 0x2b40, 0xc029,	0x2b7f, 0xc029,		0x21, 0
	.dw 0x2bc0, 0xc029,	0x2bff, 0xc029,		0x21, 0
	.dw 0x2c40, 0xc029,	0x2c7f, 0xc029,		0x21, 0
	.dw 0x2cc0, 0xc029,	0x2cff, 0xc029,		0x21, 0
	.dw 0x2d40, 0xc029,	0x2d7f, 0xc029,		0x21, 0
	.dw 0x2dc0, 0xc029,	0x2dff, 0xc029,		0x21, 0
	.dw 0x2e40, 0xc029,	0x2e7f, 0xc029,		0x21, 0
	.dw 0x2ec0, 0xc029,	0x2eff, 0xc029,		0x21, 0
	.dw 0x2f40, 0xc029,	0x2f7f, 0xc029,		0x21, 0
	.dw 0x2fc0, 0xc029,	0x2fff, 0xc029,		0x21, 0
	.dw 0x3040, 0xc029,	0x307f, 0xc029,		0x21, 0
	.dw 0x30c0, 0xc029,	0x30ff, 0xc029,		0x21, 0
	.dw 0x3140, 0xc029,	0x317f, 0xc029,		0x21, 0
	.dw 0x31c0, 0xc029,	0x31ff, 0xc029,		0x21, 0
	.dw 0x3240, 0xc029,	0x327f, 0xc029,		0x21, 0
	.dw 0x32c0, 0xc029,	0x32ff, 0xc029,		0x21, 0
	.dw 0x3340, 0xc029,	0x337f, 0xc029,		0x21, 0
	.dw 0x33c0, 0xc029,	0x33ff, 0xc029,		0x21, 0
	.dw 0x3440, 0xc029,	0x347f, 0xc029,		0x21, 0
	.dw 0x34c0, 0xc029,	0x34ff, 0xc029,		0x21, 0
	.dw 0x3540, 0xc029,	0x357f, 0xc029,		0x21, 0
	.dw 0x35c0, 0xc029,	0x35ff, 0xc029,		0x21, 0
	.dw 0x3640, 0xc029,	0x367f, 0xc029,		0x21, 0
	.dw 0x36c0, 0xc029,	0x36ff, 0xc029,		0x21, 0
	.dw 0x3740, 0xc029,	0x377f, 0xc029,		0x21, 0
	.dw 0x37c0, 0xc029,	0x37ff, 0xc029,		0x21, 0
	.dw 0x3840, 0xc029,	0x387f, 0xc029,		0x21, 0
	.dw 0x38c0, 0xc029,	0x38ff, 0xc029,		0x21, 0
	.dw 0x3940, 0xc029,	0x397f, 0xc029,		0x21, 0
	.dw 0x39c0, 0xc029,	0x5fff, 0xc029,		0x21, 0
	.dw 0x6040, 0xc029,	0x607f, 0xc029,		0x21, 0
	.dw 0x60c0, 0xc029,	0x60ff, 0xc029,		0x21, 0
	.dw 0x6140, 0xc029,	0x617f, 0xc029,		0x21, 0
	.dw 0x61c0, 0xc029,	0x61ff, 0xc029,		0x21, 0
	.dw 0x6240, 0xc029,	0x627f, 0xc029,		0x21, 0
	.dw 0x62c0, 0xc029,	0x62ff, 0xc029,		0x21, 0
	.dw 0x6340, 0xc029,	0x637f, 0xc029,		0x21, 0
	.dw 0x63c0, 0xc029,	0x63ff, 0xc029,		0x21, 0
	.dw 0x6440, 0xc029,	0x647f, 0xc029,		0x21, 0
	.dw 0x64c0, 0xc029,	0x64ff, 0xc029,		0x21, 0
	.dw 0x6540, 0xc029,	0x657f, 0xc029,		0x21, 0
	.dw 0x65c0, 0xc029,	0x65ff, 0xc029,		0x21, 0
	.dw 0x6640, 0xc029,	0x667f, 0xc029,		0x21, 0
	.dw 0x66c0, 0xc029,	0x66ff, 0xc029,		0x21, 0
	.dw 0x6740, 0xc029,	0x677f, 0xc029,		0x21, 0
	.dw 0x67c0, 0xc029,	0x67ff, 0xc029,		0x21, 0
	.dw 0x6840, 0xc029,	0x687f, 0xc029,		0x21, 0
	.dw 0x68c0, 0xc029,	0x68ff, 0xc029,		0x21, 0
	.dw 0x6940, 0xc029,	0x697f, 0xc029,		0x21, 0
	.dw 0x69c0, 0xc029,	0x69ff, 0xc029,		0x21, 0
	.dw 0x6a40, 0xc029,	0x6a7f, 0xc029,		0x21, 0
	.dw 0x6ac0, 0xc029,	0x6aff, 0xc029,		0x21, 0
	.dw 0x6b40, 0xc029,	0x6b7f, 0xc029,		0x21, 0
	.dw 0x6bc0, 0xc029,	0x6bff, 0xc029,		0x21, 0
	.dw 0x6c40, 0xc029,	0x6c7f, 0xc029,		0x21, 0
	.dw 0x6cc0, 0xc029,	0x6cff, 0xc029,		0x21, 0
	.dw 0x6d40, 0xc029,	0x6d7f, 0xc029,		0x21, 0
	.dw 0x6dc0, 0xc029,	0x6dff, 0xc029,		0x21, 0
	.dw 0x6e40, 0xc029,	0x6e7f, 0xc029,		0x21, 0
	.dw 0x6ec0, 0xc029,	0x6eff, 0xc029,		0x21, 0
	.dw 0x6f40, 0xc029,	0x6f7f, 0xc029,		0x21, 0
	.dw 0x6fc0, 0xc029,	0x6fff, 0xc029,		0x21, 0
	.dw 0x7040, 0xc029,	0x707f, 0xc029,		0x21, 0
	.dw 0x70c0, 0xc029,	0x70ff, 0xc029,		0x21, 0
	.dw 0x7140, 0xc029,	0x717f, 0xc029,		0x21, 0
	.dw 0x71c0, 0xc029,	0x71ff, 0xc029,		0x21, 0
	.dw 0x7240, 0xc029,	0x727f, 0xc029,		0x21, 0
	.dw 0x72c0, 0xc029,	0x72ff, 0xc029,		0x21, 0
	.dw 0x7340, 0xc029,	0x737f, 0xc029,		0x21, 0
	.dw 0x73c0, 0xc029,	0x73ff, 0xc029,		0x21, 0
	.dw 0x7440, 0xc029,	0x747f, 0xc029,		0x21, 0
	.dw 0x74c0, 0xc029,	0x74ff, 0xc029,		0x21, 0
	.dw 0x7540, 0xc029,	0x757f, 0xc029,		0x21, 0
	.dw 0x75c0, 0xc029,	0x75ff, 0xc029,		0x21, 0
	.dw 0x7640, 0xc029,	0x767f, 0xc029,		0x21, 0
	.dw 0x76c0, 0xc029,	0x76ff, 0xc029,		0x21, 0
	.dw 0x7740, 0xc029,	0x777f, 0xc029,		0x21, 0
	.dw 0x77c0, 0xc029,	0x77ff, 0xc029,		0x21, 0
	.dw 0x7840, 0xc029,	0x787f, 0xc029,		0x21, 0
	.dw 0x78c0, 0xc029,	0x78ff, 0xc029,		0x21, 0
	.dw 0x7940, 0xc029,	0x797f, 0xc029,		0x21, 0
	.dw 0x79c0, 0xc029,	0x9fff, 0xc029,		0x21, 0
	.dw 0xa040, 0xc029,	0xa07f, 0xc029,		0x21, 0
	.dw 0xa0c0, 0xc029,	0xa0ff, 0xc029,		0x21, 0
	.dw 0xa140, 0xc029,	0xa17f, 0xc029,		0x21, 0
	.dw 0xa1c0, 0xc029,	0xa1ff, 0xc029,		0x21, 0
	.dw 0xa240, 0xc029,	0xa27f, 0xc029,		0x21, 0
	.dw 0xa2c0, 0xc029,	0xa2ff, 0xc029,		0x21, 0
	.dw 0xa340, 0xc029,	0xa37f, 0xc029,		0x21, 0
	.dw 0xa3c0, 0xc029,	0xa3ff, 0xc029,		0x21, 0
	.dw 0xa440, 0xc029,	0xa47f, 0xc029,		0x21, 0
	.dw 0xa4c0, 0xc029,	0xa4ff, 0xc029,		0x21, 0
	.dw 0xa540, 0xc029,	0xa57f, 0xc029,		0x21, 0
	.dw 0xa5c0, 0xc029,	0xa5ff, 0xc029,		0x21, 0
	.dw 0xa640, 0xc029,	0xa67f, 0xc029,		0x21, 0
	.dw 0xa6c0, 0xc029,	0xa6ff, 0xc029,		0x21, 0
	.dw 0xa740, 0xc029,	0xa77f, 0xc029,		0x21, 0
	.dw 0xa7c0, 0xc029,	0xa7ff, 0xc029,		0x21, 0
	.dw 0xa840, 0xc029,	0xa87f, 0xc029,		0x21, 0
	.dw 0xa8c0, 0xc029,	0xa8ff, 0xc029,		0x21, 0
	.dw 0xa940, 0xc029,	0xa97f, 0xc029,		0x21, 0
	.dw 0xa9c0, 0xc029,	0xa9ff, 0xc029,		0x21, 0
	.dw 0xaa40, 0xc029,	0xaa7f, 0xc029,		0x21, 0
	.dw 0xaac0, 0xc029,	0xaaff, 0xc029,		0x21, 0
	.dw 0xab40, 0xc029,	0xab7f, 0xc029,		0x21, 0
	.dw 0xabc0, 0xc029,	0xabff, 0xc029,		0x21, 0
	.dw 0xac40, 0xc029,	0xac7f, 0xc029,		0x21, 0
	.dw 0xacc0, 0xc029,	0xacff, 0xc029,		0x21, 0
	.dw 0xad40, 0xc029,	0xad7f, 0xc029,		0x21, 0
	.dw 0xadc0, 0xc029,	0xadff, 0xc029,		0x21, 0
	.dw 0xae40, 0xc029,	0xae7f, 0xc029,		0x21, 0
	.dw 0xaec0, 0xc029,	0xaeff, 0xc029,		0x21, 0
	.dw 0xaf40, 0xc029,	0xaf7f, 0xc029,		0x21, 0
	.dw 0xafc0, 0xc029,	0xafff, 0xc029,		0x21, 0
	.dw 0xb040, 0xc029,	0xb07f, 0xc029,		0x21, 0
	.dw 0xb0c0, 0xc029,	0xb0ff, 0xc029,		0x21, 0
	.dw 0xb140, 0xc029,	0xb17f, 0xc029,		0x21, 0
	.dw 0xb1c0, 0xc029,	0xb1ff, 0xc029,		0x21, 0
	.dw 0xb240, 0xc029,	0xb27f, 0xc029,		0x21, 0
	.dw 0xb2c0, 0xc029,	0xb2ff, 0xc029,		0x21, 0
	.dw 0xb340, 0xc029,	0xb37f, 0xc029,		0x21, 0
	.dw 0xb3c0, 0xc029,	0xb3ff, 0xc029,		0x21, 0
	.dw 0xb440, 0xc029,	0xb47f, 0xc029,		0x21, 0
	.dw 0xb4c0, 0xc029,	0xb4ff, 0xc029,		0x21, 0
	.dw 0xb540, 0xc029,	0xb57f, 0xc029,		0x21, 0
	.dw 0xb5c0, 0xc029,	0xb5ff, 0xc029,		0x21, 0
	.dw 0xb640, 0xc029,	0xb67f, 0xc029,		0x21, 0
	.dw 0xb6c0, 0xc029,	0xb6ff, 0xc029,		0x21, 0
	.dw 0xb740, 0xc029,	0xb77f, 0xc029,		0x21, 0
	.dw 0xb7c0, 0xc029,	0xb7ff, 0xc029,		0x21, 0
	.dw 0xb840, 0xc029,	0xb87f, 0xc029,		0x21, 0
	.dw 0xb8c0, 0xc029,	0xb8ff, 0xc029,		0x21, 0
	.dw 0xb940, 0xc029,	0xb97f, 0xc029,		0x21, 0
	.dw 0xb9c0, 0xc029,	0xdfff, 0xc029,		0x21, 0
	.dw 0xe040, 0xc029,	0xe07f, 0xc029,		0x21, 0
	.dw 0xe0c0, 0xc029,	0xe0ff, 0xc029,		0x21, 0
	.dw 0xe140, 0xc029,	0xe17f, 0xc029,		0x21, 0
	.dw 0xe1c0, 0xc029,	0xe1ff, 0xc029,		0x21, 0
	.dw 0xe240, 0xc029,	0xe27f, 0xc029,		0x21, 0
	.dw 0xe2c0, 0xc029,	0xe2ff, 0xc029,		0x21, 0
	.dw 0xe340, 0xc029,	0xe37f, 0xc029,		0x21, 0
	.dw 0xe3c0, 0xc029,	0xe3ff, 0xc029,		0x21, 0
	.dw 0xe440, 0xc029,	0xe47f, 0xc029,		0x21, 0
	.dw 0xe4c0, 0xc029,	0xe4ff, 0xc029,		0x21, 0
	.dw 0xe540, 0xc029,	0xe57f, 0xc029,		0x21, 0
	.dw 0xe5c0, 0xc029,	0xe5ff, 0xc029,		0x21, 0
	.dw 0xe640, 0xc029,	0xe67f, 0xc029,		0x21, 0
	.dw 0xe6c0, 0xc029,	0xe6ff, 0xc029,		0x21, 0
	.dw 0xe740, 0xc029,	0xe77f, 0xc029,		0x21, 0
	.dw 0xe7c0, 0xc029,	0xe7ff, 0xc029,		0x21, 0
	.dw 0xe840, 0xc029,	0xe87f, 0xc029,		0x21, 0
	.dw 0xe8c0, 0xc029,	0xe8ff, 0xc029,		0x21, 0
	.dw 0xe940, 0xc029,	0xe97f, 0xc029,		0x21, 0
	.dw 0xe9c0, 0xc029,	0xe9ff, 0xc029,		0x21, 0
	.dw 0xea40, 0xc029,	0xea7f, 0xc029,		0x21, 0
	.dw 0xeac0, 0xc029,	0xeaff, 0xc029,		0x21, 0
	.dw 0xeb40, 0xc029,	0xeb7f, 0xc029,		0x21, 0
	.dw 0xebc0, 0xc029,	0xebff, 0xc029,		0x21, 0
	.dw 0xec40, 0xc029,	0xec7f, 0xc029,		0x21, 0
	.dw 0xecc0, 0xc029,	0xecff, 0xc029,		0x21, 0
	.dw 0xed40, 0xc029,	0xed7f, 0xc029,		0x21, 0
	.dw 0xedc0, 0xc029,	0xedff, 0xc029,		0x21, 0
	.dw 0xee40, 0xc029,	0xee7f, 0xc029,		0x21, 0
	.dw 0xeec0, 0xc029,	0xeeff, 0xc029,		0x21, 0
	.dw 0xef40, 0xc029,	0xef7f, 0xc029,		0x21, 0
	.dw 0xefc0, 0xc029,	0xefff, 0xc029,		0x21, 0
	.dw 0xf040, 0xc029,	0xf07f, 0xc029,		0x21, 0
	.dw 0xf0c0, 0xc029,	0xf0ff, 0xc029,		0x21, 0
	.dw 0xf140, 0xc029,	0xf17f, 0xc029,		0x21, 0
	.dw 0xf1c0, 0xc029,	0xf1ff, 0xc029,		0x21, 0
	.dw 0xf240, 0xc029,	0xf27f, 0xc029,		0x21, 0
	.dw 0xf2c0, 0xc029,	0xf2ff, 0xc029,		0x21, 0
	.dw 0xf340, 0xc029,	0xf37f, 0xc029,		0x21, 0
	.dw 0xf3c0, 0xc029,	0xf3ff, 0xc029,		0x21, 0
	.dw 0xf440, 0xc029,	0xf47f, 0xc029,		0x21, 0
	.dw 0xf4c0, 0xc029,	0xf4ff, 0xc029,		0x21, 0
	.dw 0xf540, 0xc029,	0xf57f, 0xc029,		0x21, 0
	.dw 0xf5c0, 0xc029,	0xf5ff, 0xc029,		0x21, 0
	.dw 0xf640, 0xc029,	0xf67f, 0xc029,		0x21, 0
	.dw 0xf6c0, 0xc029,	0xf6ff, 0xc029,		0x21, 0
	.dw 0xf740, 0xc029,	0xf77f, 0xc029,		0x21, 0
	.dw 0xf7c0, 0xc029,	0xf7ff, 0xc029,		0x21, 0
	.dw 0xf840, 0xc029,	0xf87f, 0xc029,		0x21, 0
	.dw 0xf8c0, 0xc029,	0xf8ff, 0xc029,		0x21, 0
	.dw 0xf940, 0xc029,	0xf97f, 0xc029,		0x21, 0
	.dw 0xf9c0, 0xc029,	0x1fff, 0xc02a,		0x21, 0
	.dw 0x2040, 0xc02a,	0x207f, 0xc02a,		0x21, 0
	.dw 0x20c0, 0xc02a,	0x20ff, 0xc02a,		0x21, 0
	.dw 0x2140, 0xc02a,	0x217f, 0xc02a,		0x21, 0
	.dw 0x21c0, 0xc02a,	0x21ff, 0xc02a,		0x21, 0
	.dw 0x2240, 0xc02a,	0x227f, 0xc02a,		0x21, 0
	.dw 0x22c0, 0xc02a,	0x22ff, 0xc02a,		0x21, 0
	.dw 0x2340, 0xc02a,	0x237f, 0xc02a,		0x21, 0
	.dw 0x23c0, 0xc02a,	0x23ff, 0xc02a,		0x21, 0
	.dw 0x2440, 0xc02a,	0x247f, 0xc02a,		0x21, 0
	.dw 0x24c0, 0xc02a,	0x24ff, 0xc02a,		0x21, 0
	.dw 0x2540, 0xc02a,	0x257f, 0xc02a,		0x21, 0
	.dw 0x25c0, 0xc02a,	0x25ff, 0xc02a,		0x21, 0
	.dw 0x2640, 0xc02a,	0x267f, 0xc02a,		0x21, 0
	.dw 0x26c0, 0xc02a,	0x26ff, 0xc02a,		0x21, 0
	.dw 0x2740, 0xc02a,	0x277f, 0xc02a,		0x21, 0
	.dw 0x27c0, 0xc02a,	0x27ff, 0xc02a,		0x21, 0
	.dw 0x2840, 0xc02a,	0x287f, 0xc02a,		0x21, 0
	.dw 0x28c0, 0xc02a,	0x28ff, 0xc02a,		0x21, 0
	.dw 0x2940, 0xc02a,	0x297f, 0xc02a,		0x21, 0
	.dw 0x29c0, 0xc02a,	0x29ff, 0xc02a,		0x21, 0
	.dw 0x2a40, 0xc02a,	0x2a7f, 0xc02a,		0x21, 0
	.dw 0x2ac0, 0xc02a,	0x2aff, 0xc02a,		0x21, 0
	.dw 0x2b40, 0xc02a,	0x2b7f, 0xc02a,		0x21, 0
	.dw 0x2bc0, 0xc02a,	0x2bff, 0xc02a,		0x21, 0
	.dw 0x2c40, 0xc02a,	0x2c7f, 0xc02a,		0x21, 0
	.dw 0x2cc0, 0xc02a,	0x2cff, 0xc02a,		0x21, 0
	.dw 0x2d40, 0xc02a,	0x2d7f, 0xc02a,		0x21, 0
	.dw 0x2dc0, 0xc02a,	0x2dff, 0xc02a,		0x21, 0
	.dw 0x2e40, 0xc02a,	0x2e7f, 0xc02a,		0x21, 0
	.dw 0x2ec0, 0xc02a,	0x2eff, 0xc02a,		0x21, 0
	.dw 0x2f40, 0xc02a,	0x2f7f, 0xc02a,		0x21, 0
	.dw 0x2fc0, 0xc02a,	0x2fff, 0xc02a,		0x21, 0
	.dw 0x3040, 0xc02a,	0x307f, 0xc02a,		0x21, 0
	.dw 0x30c0, 0xc02a,	0x30ff, 0xc02a,		0x21, 0
	.dw 0x3140, 0xc02a,	0x317f, 0xc02a,		0x21, 0
	.dw 0x31c0, 0xc02a,	0x31ff, 0xc02a,		0x21, 0
	.dw 0x3240, 0xc02a,	0x327f, 0xc02a,		0x21, 0
	.dw 0x32c0, 0xc02a,	0x32ff, 0xc02a,		0x21, 0
	.dw 0x3340, 0xc02a,	0x337f, 0xc02a,		0x21, 0
	.dw 0x33c0, 0xc02a,	0x33ff, 0xc02a,		0x21, 0
	.dw 0x3440, 0xc02a,	0x347f, 0xc02a,		0x21, 0
	.dw 0x34c0, 0xc02a,	0x34ff, 0xc02a,		0x21, 0
	.dw 0x3540, 0xc02a,	0x357f, 0xc02a,		0x21, 0
	.dw 0x35c0, 0xc02a,	0x35ff, 0xc02a,		0x21, 0
	.dw 0x3640, 0xc02a,	0x367f, 0xc02a,		0x21, 0
	.dw 0x36c0, 0xc02a,	0x36ff, 0xc02a,		0x21, 0
	.dw 0x3740, 0xc02a,	0x377f, 0xc02a,		0x21, 0
	.dw 0x37c0, 0xc02a,	0x37ff, 0xc02a,		0x21, 0
	.dw 0x3840, 0xc02a,	0x387f, 0xc02a,		0x21, 0
	.dw 0x38c0, 0xc02a,	0x38ff, 0xc02a,		0x21, 0
	.dw 0x3940, 0xc02a,	0x397f, 0xc02a,		0x21, 0
	.dw 0x39c0, 0xc02a,	0x5fff, 0xc02a,		0x21, 0
	.dw 0x6040, 0xc02a,	0x607f, 0xc02a,		0x21, 0
	.dw 0x60c0, 0xc02a,	0x60ff, 0xc02a,		0x21, 0
	.dw 0x6140, 0xc02a,	0x617f, 0xc02a,		0x21, 0
	.dw 0x61c0, 0xc02a,	0x61ff, 0xc02a,		0x21, 0
	.dw 0x6240, 0xc02a,	0x627f, 0xc02a,		0x21, 0
	.dw 0x62c0, 0xc02a,	0x62ff, 0xc02a,		0x21, 0
	.dw 0x6340, 0xc02a,	0x637f, 0xc02a,		0x21, 0
	.dw 0x63c0, 0xc02a,	0x63ff, 0xc02a,		0x21, 0
	.dw 0x6440, 0xc02a,	0x647f, 0xc02a,		0x21, 0
	.dw 0x64c0, 0xc02a,	0x64ff, 0xc02a,		0x21, 0
	.dw 0x6540, 0xc02a,	0x657f, 0xc02a,		0x21, 0
	.dw 0x65c0, 0xc02a,	0x65ff, 0xc02a,		0x21, 0
	.dw 0x6640, 0xc02a,	0x667f, 0xc02a,		0x21, 0
	.dw 0x66c0, 0xc02a,	0x66ff, 0xc02a,		0x21, 0
	.dw 0x6740, 0xc02a,	0x677f, 0xc02a,		0x21, 0
	.dw 0x67c0, 0xc02a,	0x67ff, 0xc02a,		0x21, 0
	.dw 0x6840, 0xc02a,	0x687f, 0xc02a,		0x21, 0
	.dw 0x68c0, 0xc02a,	0x68ff, 0xc02a,		0x21, 0
	.dw 0x6940, 0xc02a,	0x697f, 0xc02a,		0x21, 0
	.dw 0x69c0, 0xc02a,	0x69ff, 0xc02a,		0x21, 0
	.dw 0x6a40, 0xc02a,	0x6a7f, 0xc02a,		0x21, 0
	.dw 0x6ac0, 0xc02a,	0x6aff, 0xc02a,		0x21, 0
	.dw 0x6b40, 0xc02a,	0x6b7f, 0xc02a,		0x21, 0
	.dw 0x6bc0, 0xc02a,	0x6bff, 0xc02a,		0x21, 0
	.dw 0x6c40, 0xc02a,	0x6c7f, 0xc02a,		0x21, 0
	.dw 0x6cc0, 0xc02a,	0x6cff, 0xc02a,		0x21, 0
	.dw 0x6d40, 0xc02a,	0x6d7f, 0xc02a,		0x21, 0
	.dw 0x6dc0, 0xc02a,	0x6dff, 0xc02a,		0x21, 0
	.dw 0x6e40, 0xc02a,	0x6e7f, 0xc02a,		0x21, 0
	.dw 0x6ec0, 0xc02a,	0x6eff, 0xc02a,		0x21, 0
	.dw 0x6f40, 0xc02a,	0x6f7f, 0xc02a,		0x21, 0
	.dw 0x6fc0, 0xc02a,	0x6fff, 0xc02a,		0x21, 0
	.dw 0x7040, 0xc02a,	0x707f, 0xc02a,		0x21, 0
	.dw 0x70c0, 0xc02a,	0x70ff, 0xc02a,		0x21, 0
	.dw 0x7140, 0xc02a,	0x717f, 0xc02a,		0x21, 0
	.dw 0x71c0, 0xc02a,	0x71ff, 0xc02a,		0x21, 0
	.dw 0x7240, 0xc02a,	0x727f, 0xc02a,		0x21, 0
	.dw 0x72c0, 0xc02a,	0x72ff, 0xc02a,		0x21, 0
	.dw 0x7340, 0xc02a,	0x737f, 0xc02a,		0x21, 0
	.dw 0x73c0, 0xc02a,	0x73ff, 0xc02a,		0x21, 0
	.dw 0x7440, 0xc02a,	0x747f, 0xc02a,		0x21, 0
	.dw 0x74c0, 0xc02a,	0x74ff, 0xc02a,		0x21, 0
	.dw 0x7540, 0xc02a,	0x757f, 0xc02a,		0x21, 0
	.dw 0x75c0, 0xc02a,	0x75ff, 0xc02a,		0x21, 0
	.dw 0x7640, 0xc02a,	0x767f, 0xc02a,		0x21, 0
	.dw 0x76c0, 0xc02a,	0x76ff, 0xc02a,		0x21, 0
	.dw 0x7740, 0xc02a,	0x777f, 0xc02a,		0x21, 0
	.dw 0x77c0, 0xc02a,	0x77ff, 0xc02a,		0x21, 0
	.dw 0x7840, 0xc02a,	0x787f, 0xc02a,		0x21, 0
	.dw 0x78c0, 0xc02a,	0x78ff, 0xc02a,		0x21, 0
	.dw 0x7940, 0xc02a,	0x797f, 0xc02a,		0x21, 0
	.dw 0x79c0, 0xc02a,	0x9fff, 0xc02a,		0x21, 0
	.dw 0xa040, 0xc02a,	0xa07f, 0xc02a,		0x21, 0
	.dw 0xa0c0, 0xc02a,	0xa0ff, 0xc02a,		0x21, 0
	.dw 0xa140, 0xc02a,	0xa17f, 0xc02a,		0x21, 0
	.dw 0xa1c0, 0xc02a,	0xa1ff, 0xc02a,		0x21, 0
	.dw 0xa240, 0xc02a,	0xa27f, 0xc02a,		0x21, 0
	.dw 0xa2c0, 0xc02a,	0xa2ff, 0xc02a,		0x21, 0
	.dw 0xa340, 0xc02a,	0xa37f, 0xc02a,		0x21, 0
	.dw 0xa3c0, 0xc02a,	0xa3ff, 0xc02a,		0x21, 0
	.dw 0xa440, 0xc02a,	0xa47f, 0xc02a,		0x21, 0
	.dw 0xa4c0, 0xc02a,	0xa4ff, 0xc02a,		0x21, 0
	.dw 0xa540, 0xc02a,	0xa57f, 0xc02a,		0x21, 0
	.dw 0xa5c0, 0xc02a,	0xa5ff, 0xc02a,		0x21, 0
	.dw 0xa640, 0xc02a,	0xa67f, 0xc02a,		0x21, 0
	.dw 0xa6c0, 0xc02a,	0xa6ff, 0xc02a,		0x21, 0
	.dw 0xa740, 0xc02a,	0xa77f, 0xc02a,		0x21, 0
	.dw 0xa7c0, 0xc02a,	0xa7ff, 0xc02a,		0x21, 0
	.dw 0xa840, 0xc02a,	0xa87f, 0xc02a,		0x21, 0
	.dw 0xa8c0, 0xc02a,	0xa8ff, 0xc02a,		0x21, 0
	.dw 0xa940, 0xc02a,	0xa97f, 0xc02a,		0x21, 0
	.dw 0xa9c0, 0xc02a,	0xa9ff, 0xc02a,		0x21, 0
	.dw 0xaa40, 0xc02a,	0xaa7f, 0xc02a,		0x21, 0
	.dw 0xaac0, 0xc02a,	0xaaff, 0xc02a,		0x21, 0
	.dw 0xab40, 0xc02a,	0xab7f, 0xc02a,		0x21, 0
	.dw 0xabc0, 0xc02a,	0xabff, 0xc02a,		0x21, 0
	.dw 0xac40, 0xc02a,	0xac7f, 0xc02a,		0x21, 0
	.dw 0xacc0, 0xc02a,	0xacff, 0xc02a,		0x21, 0
	.dw 0xad40, 0xc02a,	0xad7f, 0xc02a,		0x21, 0
	.dw 0xadc0, 0xc02a,	0xadff, 0xc02a,		0x21, 0
	.dw 0xae40, 0xc02a,	0xae7f, 0xc02a,		0x21, 0
	.dw 0xaec0, 0xc02a,	0xaeff, 0xc02a,		0x21, 0
	.dw 0xaf40, 0xc02a,	0xaf7f, 0xc02a,		0x21, 0
	.dw 0xafc0, 0xc02a,	0xafff, 0xc02a,		0x21, 0
	.dw 0xb040, 0xc02a,	0xb07f, 0xc02a,		0x21, 0
	.dw 0xb0c0, 0xc02a,	0xb0ff, 0xc02a,		0x21, 0
	.dw 0xb140, 0xc02a,	0xb17f, 0xc02a,		0x21, 0
	.dw 0xb1c0, 0xc02a,	0xb1ff, 0xc02a,		0x21, 0
	.dw 0xb240, 0xc02a,	0xb27f, 0xc02a,		0x21, 0
	.dw 0xb2c0, 0xc02a,	0xb2ff, 0xc02a,		0x21, 0
	.dw 0xb340, 0xc02a,	0xb37f, 0xc02a,		0x21, 0
	.dw 0xb3c0, 0xc02a,	0xb3ff, 0xc02a,		0x21, 0
	.dw 0xb440, 0xc02a,	0xb47f, 0xc02a,		0x21, 0
	.dw 0xb4c0, 0xc02a,	0xb4ff, 0xc02a,		0x21, 0
	.dw 0xb540, 0xc02a,	0xb57f, 0xc02a,		0x21, 0
	.dw 0xb5c0, 0xc02a,	0xb5ff, 0xc02a,		0x21, 0
	.dw 0xb640, 0xc02a,	0xb67f, 0xc02a,		0x21, 0
	.dw 0xb6c0, 0xc02a,	0xb6ff, 0xc02a,		0x21, 0
	.dw 0xb740, 0xc02a,	0xb77f, 0xc02a,		0x21, 0
	.dw 0xb7c0, 0xc02a,	0xb7ff, 0xc02a,		0x21, 0
	.dw 0xb840, 0xc02a,	0xb87f, 0xc02a,		0x21, 0
	.dw 0xb8c0, 0xc02a,	0xb8ff, 0xc02a,		0x21, 0
	.dw 0xb940, 0xc02a,	0xb97f, 0xc02a,		0x21, 0
	.dw 0xb9c0, 0xc02a,	0xdfff, 0xc02a,		0x21, 0
	.dw 0xe040, 0xc02a,	0xe07f, 0xc02a,		0x21, 0
	.dw 0xe0c0, 0xc02a,	0xe0ff, 0xc02a,		0x21, 0
	.dw 0xe140, 0xc02a,	0xe17f, 0xc02a,		0x21, 0
	.dw 0xe1c0, 0xc02a,	0xe1ff, 0xc02a,		0x21, 0
	.dw 0xe240, 0xc02a,	0xe27f, 0xc02a,		0x21, 0
	.dw 0xe2c0, 0xc02a,	0xe2ff, 0xc02a,		0x21, 0
	.dw 0xe340, 0xc02a,	0xe37f, 0xc02a,		0x21, 0
	.dw 0xe3c0, 0xc02a,	0xe3ff, 0xc02a,		0x21, 0
	.dw 0xe440, 0xc02a,	0xe47f, 0xc02a,		0x21, 0
	.dw 0xe4c0, 0xc02a,	0xe4ff, 0xc02a,		0x21, 0
	.dw 0xe540, 0xc02a,	0xe57f, 0xc02a,		0x21, 0
	.dw 0xe5c0, 0xc02a,	0xe5ff, 0xc02a,		0x21, 0
	.dw 0xe640, 0xc02a,	0xe67f, 0xc02a,		0x21, 0
	.dw 0xe6c0, 0xc02a,	0xe6ff, 0xc02a,		0x21, 0
	.dw 0xe740, 0xc02a,	0xe77f, 0xc02a,		0x21, 0
	.dw 0xe7c0, 0xc02a,	0xe7ff, 0xc02a,		0x21, 0
	.dw 0xe840, 0xc02a,	0xe87f, 0xc02a,		0x21, 0
	.dw 0xe8c0, 0xc02a,	0xe8ff, 0xc02a,		0x21, 0
	.dw 0xe940, 0xc02a,	0xe97f, 0xc02a,		0x21, 0
	.dw 0xe9c0, 0xc02a,	0xe9ff, 0xc02a,		0x21, 0
	.dw 0xea40, 0xc02a,	0xea7f, 0xc02a,		0x21, 0
	.dw 0xeac0, 0xc02a,	0xeaff, 0xc02a,		0x21, 0
	.dw 0xeb40, 0xc02a,	0xeb7f, 0xc02a,		0x21, 0
	.dw 0xebc0, 0xc02a,	0xebff, 0xc02a,		0x21, 0
	.dw 0xec40, 0xc02a,	0xec7f, 0xc02a,		0x21, 0
	.dw 0xecc0, 0xc02a,	0xecff, 0xc02a,		0x21, 0
	.dw 0xed40, 0xc02a,	0xed7f, 0xc02a,		0x21, 0
	.dw 0xedc0, 0xc02a,	0xedff, 0xc02a,		0x21, 0
	.dw 0xee40, 0xc02a,	0xee7f, 0xc02a,		0x21, 0
	.dw 0xeec0, 0xc02a,	0xeeff, 0xc02a,		0x21, 0
	.dw 0xef40, 0xc02a,	0xef7f, 0xc02a,		0x21, 0
	.dw 0xefc0, 0xc02a,	0xefff, 0xc02a,		0x21, 0
	.dw 0xf040, 0xc02a,	0xf07f, 0xc02a,		0x21, 0
	.dw 0xf0c0, 0xc02a,	0xf0ff, 0xc02a,		0x21, 0
	.dw 0xf140, 0xc02a,	0xf17f, 0xc02a,		0x21, 0
	.dw 0xf1c0, 0xc02a,	0xf1ff, 0xc02a,		0x21, 0
	.dw 0xf240, 0xc02a,	0xf27f, 0xc02a,		0x21, 0
	.dw 0xf2c0, 0xc02a,	0xf2ff, 0xc02a,		0x21, 0
	.dw 0xf340, 0xc02a,	0xf37f, 0xc02a,		0x21, 0
	.dw 0xf3c0, 0xc02a,	0xf3ff, 0xc02a,		0x21, 0
	.dw 0xf440, 0xc02a,	0xf47f, 0xc02a,		0x21, 0
	.dw 0xf4c0, 0xc02a,	0xf4ff, 0xc02a,		0x21, 0
	.dw 0xf540, 0xc02a,	0xf57f, 0xc02a,		0x21, 0
	.dw 0xf5c0, 0xc02a,	0xf5ff, 0xc02a,		0x21, 0
	.dw 0xf640, 0xc02a,	0xf67f, 0xc02a,		0x21, 0
	.dw 0xf6c0, 0xc02a,	0xf6ff, 0xc02a,		0x21, 0
	.dw 0xf740, 0xc02a,	0xf77f, 0xc02a,		0x21, 0
	.dw 0xf7c0, 0xc02a,	0xf7ff, 0xc02a,		0x21, 0
	.dw 0xf840, 0xc02a,	0xf87f, 0xc02a,		0x21, 0
	.dw 0xf8c0, 0xc02a,	0xf8ff, 0xc02a,		0x21, 0
	.dw 0xf940, 0xc02a,	0xf97f, 0xc02a,		0x21, 0
	.dw 0xf9c0, 0xc02a,	0x1fff, 0xc02b,		0x21, 0
	.dw 0x2040, 0xc02b,	0x207f, 0xc02b,		0x21, 0
	.dw 0x20c0, 0xc02b,	0x20ff, 0xc02b,		0x21, 0
	.dw 0x2140, 0xc02b,	0x217f, 0xc02b,		0x21, 0
	.dw 0x21c0, 0xc02b,	0x21ff, 0xc02b,		0x21, 0
	.dw 0x2240, 0xc02b,	0x227f, 0xc02b,		0x21, 0
	.dw 0x22c0, 0xc02b,	0x22ff, 0xc02b,		0x21, 0
	.dw 0x2340, 0xc02b,	0x237f, 0xc02b,		0x21, 0
	.dw 0x23c0, 0xc02b,	0x23ff, 0xc02b,		0x21, 0
	.dw 0x2440, 0xc02b,	0x247f, 0xc02b,		0x21, 0
	.dw 0x24c0, 0xc02b,	0x24ff, 0xc02b,		0x21, 0
	.dw 0x2540, 0xc02b,	0x257f, 0xc02b,		0x21, 0
	.dw 0x25c0, 0xc02b,	0x25ff, 0xc02b,		0x21, 0
	.dw 0x2640, 0xc02b,	0x267f, 0xc02b,		0x21, 0
	.dw 0x26c0, 0xc02b,	0x26ff, 0xc02b,		0x21, 0
	.dw 0x2740, 0xc02b,	0x277f, 0xc02b,		0x21, 0
	.dw 0x27c0, 0xc02b,	0x27ff, 0xc02b,		0x21, 0
	.dw 0x2840, 0xc02b,	0x287f, 0xc02b,		0x21, 0
	.dw 0x28c0, 0xc02b,	0x28ff, 0xc02b,		0x21, 0
	.dw 0x2940, 0xc02b,	0x297f, 0xc02b,		0x21, 0
	.dw 0x29c0, 0xc02b,	0x29ff, 0xc02b,		0x21, 0
	.dw 0x2a40, 0xc02b,	0x2a7f, 0xc02b,		0x21, 0
	.dw 0x2ac0, 0xc02b,	0x2aff, 0xc02b,		0x21, 0
	.dw 0x2b40, 0xc02b,	0x2b7f, 0xc02b,		0x21, 0
	.dw 0x2bc0, 0xc02b,	0x2bff, 0xc02b,		0x21, 0
	.dw 0x2c40, 0xc02b,	0x2c7f, 0xc02b,		0x21, 0
	.dw 0x2cc0, 0xc02b,	0x2cff, 0xc02b,		0x21, 0
	.dw 0x2d40, 0xc02b,	0x2d7f, 0xc02b,		0x21, 0
	.dw 0x2dc0, 0xc02b,	0x2dff, 0xc02b,		0x21, 0
	.dw 0x2e40, 0xc02b,	0x2e7f, 0xc02b,		0x21, 0
	.dw 0x2ec0, 0xc02b,	0x2eff, 0xc02b,		0x21, 0
	.dw 0x2f40, 0xc02b,	0x2f7f, 0xc02b,		0x21, 0
	.dw 0x2fc0, 0xc02b,	0x2fff, 0xc02b,		0x21, 0
	.dw 0x3040, 0xc02b,	0x307f, 0xc02b,		0x21, 0
	.dw 0x30c0, 0xc02b,	0x30ff, 0xc02b,		0x21, 0
	.dw 0x3140, 0xc02b,	0x317f, 0xc02b,		0x21, 0
	.dw 0x31c0, 0xc02b,	0x31ff, 0xc02b,		0x21, 0
	.dw 0x3240, 0xc02b,	0x327f, 0xc02b,		0x21, 0
	.dw 0x32c0, 0xc02b,	0x32ff, 0xc02b,		0x21, 0
	.dw 0x3340, 0xc02b,	0x337f, 0xc02b,		0x21, 0
	.dw 0x33c0, 0xc02b,	0x33ff, 0xc02b,		0x21, 0
	.dw 0x3440, 0xc02b,	0x347f, 0xc02b,		0x21, 0
	.dw 0x34c0, 0xc02b,	0x34ff, 0xc02b,		0x21, 0
	.dw 0x3540, 0xc02b,	0x357f, 0xc02b,		0x21, 0
	.dw 0x35c0, 0xc02b,	0x35ff, 0xc02b,		0x21, 0
	.dw 0x3640, 0xc02b,	0x367f, 0xc02b,		0x21, 0
	.dw 0x36c0, 0xc02b,	0x36ff, 0xc02b,		0x21, 0
	.dw 0x3740, 0xc02b,	0x377f, 0xc02b,		0x21, 0
	.dw 0x37c0, 0xc02b,	0x37ff, 0xc02b,		0x21, 0
	.dw 0x3840, 0xc02b,	0x387f, 0xc02b,		0x21, 0
	.dw 0x38c0, 0xc02b,	0x38ff, 0xc02b,		0x21, 0
	.dw 0x3940, 0xc02b,	0x397f, 0xc02b,		0x21, 0
	.dw 0x39c0, 0xc02b,	0xffff, 0xc02b,		0x21, 0
	.dw 0x0040, 0xc02c,	0x007f, 0xc02c,		0x21, 0
	.dw 0x00c0, 0xc02c,	0x00ff, 0xc02c,		0x21, 0
	.dw 0x0140, 0xc02c,	0x017f, 0xc02c,		0x21, 0
	.dw 0x01c0, 0xc02c,	0x01ff, 0xc02c,		0x21, 0
	.dw 0x0240, 0xc02c,	0x027f, 0xc02c,		0x21, 0
	.dw 0x02c0, 0xc02c,	0x02ff, 0xc02c,		0x21, 0
	.dw 0x0340, 0xc02c,	0x037f, 0xc02c,		0x21, 0
	.dw 0x03c0, 0xc02c,	0x03ff, 0xc02c,		0x21, 0
	.dw 0x0440, 0xc02c,	0x047f, 0xc02c,		0x21, 0
	.dw 0x04c0, 0xc02c,	0x04ff, 0xc02c,		0x21, 0
	.dw 0x0540, 0xc02c,	0x057f, 0xc02c,		0x21, 0
	.dw 0x05c0, 0xc02c,	0x05ff, 0xc02c,		0x21, 0
	.dw 0x0640, 0xc02c,	0x067f, 0xc02c,		0x21, 0
	.dw 0x06c0, 0xc02c,	0x06ff, 0xc02c,		0x21, 0
	.dw 0x0740, 0xc02c,	0x077f, 0xc02c,		0x21, 0
	.dw 0x07c0, 0xc02c,	0x07ff, 0xc02c,		0x21, 0
	.dw 0x0840, 0xc02c,	0x087f, 0xc02c,		0x21, 0
	.dw 0x08c0, 0xc02c,	0x08ff, 0xc02c,		0x21, 0
	.dw 0x0940, 0xc02c,	0x097f, 0xc02c,		0x21, 0
	.dw 0x09c0, 0xc02c,	0x09ff, 0xc02c,		0x21, 0
	.dw 0x0a40, 0xc02c,	0x0a7f, 0xc02c,		0x21, 0
	.dw 0x0ac0, 0xc02c,	0x0aff, 0xc02c,		0x21, 0
	.dw 0x0b40, 0xc02c,	0x0b7f, 0xc02c,		0x21, 0
	.dw 0x0bc0, 0xc02c,	0x0bff, 0xc02c,		0x21, 0
	.dw 0x0c40, 0xc02c,	0x0c7f, 0xc02c,		0x21, 0
	.dw 0x0cc0, 0xc02c,	0x0cff, 0xc02c,		0x21, 0
	.dw 0x0d40, 0xc02c,	0x0d7f, 0xc02c,		0x21, 0
	.dw 0x0dc0, 0xc02c,	0x0dff, 0xc02c,		0x21, 0
	.dw 0x0e40, 0xc02c,	0x0e7f, 0xc02c,		0x21, 0
	.dw 0x0ec0, 0xc02c,	0x0eff, 0xc02c,		0x21, 0
	.dw 0x0f40, 0xc02c,	0x0f7f, 0xc02c,		0x21, 0
	.dw 0x0fc0, 0xc02c,	0x0fff, 0xc02c,		0x21, 0
	.dw 0x1040, 0xc02c,	0x107f, 0xc02c,		0x21, 0
	.dw 0x10c0, 0xc02c,	0x10ff, 0xc02c,		0x21, 0
	.dw 0x1140, 0xc02c,	0x117f, 0xc02c,		0x21, 0
	.dw 0x11c0, 0xc02c,	0x11ff, 0xc02c,		0x21, 0
	.dw 0x1240, 0xc02c,	0x127f, 0xc02c,		0x21, 0
	.dw 0x12c0, 0xc02c,	0x12ff, 0xc02c,		0x21, 0
	.dw 0x1340, 0xc02c,	0x137f, 0xc02c,		0x21, 0
	.dw 0x13c0, 0xc02c,	0x13ff, 0xc02c,		0x21, 0
	.dw 0x1440, 0xc02c,	0x147f, 0xc02c,		0x21, 0
	.dw 0x14c0, 0xc02c,	0x14ff, 0xc02c,		0x21, 0
	.dw 0x1540, 0xc02c,	0x157f, 0xc02c,		0x21, 0
	.dw 0x15c0, 0xc02c,	0x15ff, 0xc02c,		0x21, 0
	.dw 0x1640, 0xc02c,	0x167f, 0xc02c,		0x21, 0
	.dw 0x16c0, 0xc02c,	0x16ff, 0xc02c,		0x21, 0
	.dw 0x1740, 0xc02c,	0x177f, 0xc02c,		0x21, 0
	.dw 0x17c0, 0xc02c,	0x17ff, 0xc02c,		0x21, 0
	.dw 0x1840, 0xc02c,	0x187f, 0xc02c,		0x21, 0
	.dw 0x18c0, 0xc02c,	0x18ff, 0xc02c,		0x21, 0
	.dw 0x1940, 0xc02c,	0x197f, 0xc02c,		0x21, 0
	.dw 0x19c0, 0xc02c,	0x1fff, 0xc02c,		0x21, 0
	.dw 0x2040, 0xc02c,	0x207f, 0xc02c,		0x21, 0
	.dw 0x20c0, 0xc02c,	0x20ff, 0xc02c,		0x21, 0
	.dw 0x2140, 0xc02c,	0x217f, 0xc02c,		0x21, 0
	.dw 0x21c0, 0xc02c,	0x21ff, 0xc02c,		0x21, 0
	.dw 0x2240, 0xc02c,	0x227f, 0xc02c,		0x21, 0
	.dw 0x22c0, 0xc02c,	0x22ff, 0xc02c,		0x21, 0
	.dw 0x2340, 0xc02c,	0x237f, 0xc02c,		0x21, 0
	.dw 0x23c0, 0xc02c,	0x23ff, 0xc02c,		0x21, 0
	.dw 0x2440, 0xc02c,	0x247f, 0xc02c,		0x21, 0
	.dw 0x24c0, 0xc02c,	0x24ff, 0xc02c,		0x21, 0
	.dw 0x2540, 0xc02c,	0x257f, 0xc02c,		0x21, 0
	.dw 0x25c0, 0xc02c,	0x25ff, 0xc02c,		0x21, 0
	.dw 0x2640, 0xc02c,	0x267f, 0xc02c,		0x21, 0
	.dw 0x26c0, 0xc02c,	0x26ff, 0xc02c,		0x21, 0
	.dw 0x2740, 0xc02c,	0x277f, 0xc02c,		0x21, 0
	.dw 0x27c0, 0xc02c,	0x27ff, 0xc02c,		0x21, 0
	.dw 0x2840, 0xc02c,	0x287f, 0xc02c,		0x21, 0
	.dw 0x28c0, 0xc02c,	0x28ff, 0xc02c,		0x21, 0
	.dw 0x2940, 0xc02c,	0x297f, 0xc02c,		0x21, 0
	.dw 0x29c0, 0xc02c,	0x29ff, 0xc02c,		0x21, 0
	.dw 0x2a40, 0xc02c,	0x2a7f, 0xc02c,		0x21, 0
	.dw 0x2ac0, 0xc02c,	0x2aff, 0xc02c,		0x21, 0
	.dw 0x2b40, 0xc02c,	0x2b7f, 0xc02c,		0x21, 0
	.dw 0x2bc0, 0xc02c,	0x2bff, 0xc02c,		0x21, 0
	.dw 0x2c40, 0xc02c,	0x2c7f, 0xc02c,		0x21, 0
	.dw 0x2cc0, 0xc02c,	0x2cff, 0xc02c,		0x21, 0
	.dw 0x2d40, 0xc02c,	0x2d7f, 0xc02c,		0x21, 0
	.dw 0x2dc0, 0xc02c,	0x2dff, 0xc02c,		0x21, 0
	.dw 0x2e40, 0xc02c,	0x2e7f, 0xc02c,		0x21, 0
	.dw 0x2ec0, 0xc02c,	0x2eff, 0xc02c,		0x21, 0
	.dw 0x2f40, 0xc02c,	0x2f7f, 0xc02c,		0x21, 0
	.dw 0x2fc0, 0xc02c,	0x2fff, 0xc02c,		0x21, 0
	.dw 0x3040, 0xc02c,	0x307f, 0xc02c,		0x21, 0
	.dw 0x30c0, 0xc02c,	0x30ff, 0xc02c,		0x21, 0
	.dw 0x3140, 0xc02c,	0x317f, 0xc02c,		0x21, 0
	.dw 0x31c0, 0xc02c,	0x31ff, 0xc02c,		0x21, 0
	.dw 0x3240, 0xc02c,	0x327f, 0xc02c,		0x21, 0
	.dw 0x32c0, 0xc02c,	0x32ff, 0xc02c,		0x21, 0
	.dw 0x3340, 0xc02c,	0x337f, 0xc02c,		0x21, 0
	.dw 0x33c0, 0xc02c,	0x33ff, 0xc02c,		0x21, 0
	.dw 0x3440, 0xc02c,	0x347f, 0xc02c,		0x21, 0
	.dw 0x34c0, 0xc02c,	0x34ff, 0xc02c,		0x21, 0
	.dw 0x3540, 0xc02c,	0x357f, 0xc02c,		0x21, 0
	.dw 0x35c0, 0xc02c,	0x35ff, 0xc02c,		0x21, 0
	.dw 0x3640, 0xc02c,	0x367f, 0xc02c,		0x21, 0
	.dw 0x36c0, 0xc02c,	0x36ff, 0xc02c,		0x21, 0
	.dw 0x3740, 0xc02c,	0x377f, 0xc02c,		0x21, 0
	.dw 0x37c0, 0xc02c,	0x37ff, 0xc02c,		0x21, 0
	.dw 0x3840, 0xc02c,	0x387f, 0xc02c,		0x21, 0
	.dw 0x38c0, 0xc02c,	0x38ff, 0xc02c,		0x21, 0
	.dw 0x3940, 0xc02c,	0x397f, 0xc02c,		0x21, 0
	.dw 0x39c0, 0xc02c,	0x3fff, 0xc02c,		0x21, 0
	.dw 0x4040, 0xc02c,	0x407f, 0xc02c,		0x21, 0
	.dw 0x40c0, 0xc02c,	0x40ff, 0xc02c,		0x21, 0
	.dw 0x4140, 0xc02c,	0x417f, 0xc02c,		0x21, 0
	.dw 0x41c0, 0xc02c,	0x41ff, 0xc02c,		0x21, 0
	.dw 0x4240, 0xc02c,	0x427f, 0xc02c,		0x21, 0
	.dw 0x42c0, 0xc02c,	0x42ff, 0xc02c,		0x21, 0
	.dw 0x4340, 0xc02c,	0x437f, 0xc02c,		0x21, 0
	.dw 0x43c0, 0xc02c,	0x43ff, 0xc02c,		0x21, 0
	.dw 0x4440, 0xc02c,	0x447f, 0xc02c,		0x21, 0
	.dw 0x44c0, 0xc02c,	0x44ff, 0xc02c,		0x21, 0
	.dw 0x4540, 0xc02c,	0x457f, 0xc02c,		0x21, 0
	.dw 0x45c0, 0xc02c,	0x45ff, 0xc02c,		0x21, 0
	.dw 0x4640, 0xc02c,	0x467f, 0xc02c,		0x21, 0
	.dw 0x46c0, 0xc02c,	0x46ff, 0xc02c,		0x21, 0
	.dw 0x4740, 0xc02c,	0x477f, 0xc02c,		0x21, 0
	.dw 0x47c0, 0xc02c,	0x47ff, 0xc02c,		0x21, 0
	.dw 0x4840, 0xc02c,	0x487f, 0xc02c,		0x21, 0
	.dw 0x48c0, 0xc02c,	0x48ff, 0xc02c,		0x21, 0
	.dw 0x4940, 0xc02c,	0x497f, 0xc02c,		0x21, 0
	.dw 0x49c0, 0xc02c,	0x49ff, 0xc02c,		0x21, 0
	.dw 0x4a40, 0xc02c,	0x4a7f, 0xc02c,		0x21, 0
	.dw 0x4ac0, 0xc02c,	0x4aff, 0xc02c,		0x21, 0
	.dw 0x4b40, 0xc02c,	0x4b7f, 0xc02c,		0x21, 0
	.dw 0x4bc0, 0xc02c,	0x4bff, 0xc02c,		0x21, 0
	.dw 0x4c40, 0xc02c,	0x4c7f, 0xc02c,		0x21, 0
	.dw 0x4cc0, 0xc02c,	0x4cff, 0xc02c,		0x21, 0
	.dw 0x4d40, 0xc02c,	0x4d7f, 0xc02c,		0x21, 0
	.dw 0x4dc0, 0xc02c,	0x4dff, 0xc02c,		0x21, 0
	.dw 0x4e40, 0xc02c,	0x4e7f, 0xc02c,		0x21, 0
	.dw 0x4ec0, 0xc02c,	0x4eff, 0xc02c,		0x21, 0
	.dw 0x4f40, 0xc02c,	0x4f7f, 0xc02c,		0x21, 0
	.dw 0x4fc0, 0xc02c,	0x4fff, 0xc02c,		0x21, 0
	.dw 0x5040, 0xc02c,	0x507f, 0xc02c,		0x21, 0
	.dw 0x50c0, 0xc02c,	0x50ff, 0xc02c,		0x21, 0
	.dw 0x5140, 0xc02c,	0x517f, 0xc02c,		0x21, 0
	.dw 0x51c0, 0xc02c,	0x51ff, 0xc02c,		0x21, 0
	.dw 0x5240, 0xc02c,	0x527f, 0xc02c,		0x21, 0
	.dw 0x52c0, 0xc02c,	0x52ff, 0xc02c,		0x21, 0
	.dw 0x5340, 0xc02c,	0x537f, 0xc02c,		0x21, 0
	.dw 0x53c0, 0xc02c,	0x53ff, 0xc02c,		0x21, 0
	.dw 0x5440, 0xc02c,	0x547f, 0xc02c,		0x21, 0
	.dw 0x54c0, 0xc02c,	0x54ff, 0xc02c,		0x21, 0
	.dw 0x5540, 0xc02c,	0x557f, 0xc02c,		0x21, 0
	.dw 0x55c0, 0xc02c,	0x55ff, 0xc02c,		0x21, 0
	.dw 0x5640, 0xc02c,	0x567f, 0xc02c,		0x21, 0
	.dw 0x56c0, 0xc02c,	0x56ff, 0xc02c,		0x21, 0
	.dw 0x5740, 0xc02c,	0x577f, 0xc02c,		0x21, 0
	.dw 0x57c0, 0xc02c,	0x57ff, 0xc02c,		0x21, 0
	.dw 0x5840, 0xc02c,	0x587f, 0xc02c,		0x21, 0
	.dw 0x58c0, 0xc02c,	0x58ff, 0xc02c,		0x21, 0
	.dw 0x5940, 0xc02c,	0x597f, 0xc02c,		0x21, 0
	.dw 0x59c0, 0xc02c,	0x5fff, 0xc02c,		0x21, 0
	.dw 0x6040, 0xc02c,	0x607f, 0xc02c,		0x21, 0
	.dw 0x60c0, 0xc02c,	0x60ff, 0xc02c,		0x21, 0
	.dw 0x6140, 0xc02c,	0x617f, 0xc02c,		0x21, 0
	.dw 0x61c0, 0xc02c,	0x61ff, 0xc02c,		0x21, 0
	.dw 0x6240, 0xc02c,	0x627f, 0xc02c,		0x21, 0
	.dw 0x62c0, 0xc02c,	0x62ff, 0xc02c,		0x21, 0
	.dw 0x6340, 0xc02c,	0x637f, 0xc02c,		0x21, 0
	.dw 0x63c0, 0xc02c,	0x63ff, 0xc02c,		0x21, 0
	.dw 0x6440, 0xc02c,	0x647f, 0xc02c,		0x21, 0
	.dw 0x64c0, 0xc02c,	0x64ff, 0xc02c,		0x21, 0
	.dw 0x6540, 0xc02c,	0x657f, 0xc02c,		0x21, 0
	.dw 0x65c0, 0xc02c,	0x65ff, 0xc02c,		0x21, 0
	.dw 0x6640, 0xc02c,	0x667f, 0xc02c,		0x21, 0
	.dw 0x66c0, 0xc02c,	0x66ff, 0xc02c,		0x21, 0
	.dw 0x6740, 0xc02c,	0x677f, 0xc02c,		0x21, 0
	.dw 0x67c0, 0xc02c,	0x67ff, 0xc02c,		0x21, 0
	.dw 0x6840, 0xc02c,	0x687f, 0xc02c,		0x21, 0
	.dw 0x68c0, 0xc02c,	0x68ff, 0xc02c,		0x21, 0
	.dw 0x6940, 0xc02c,	0x697f, 0xc02c,		0x21, 0
	.dw 0x69c0, 0xc02c,	0x69ff, 0xc02c,		0x21, 0
	.dw 0x6a40, 0xc02c,	0x6a7f, 0xc02c,		0x21, 0
	.dw 0x6ac0, 0xc02c,	0x6aff, 0xc02c,		0x21, 0
	.dw 0x6b40, 0xc02c,	0x6b7f, 0xc02c,		0x21, 0
	.dw 0x6bc0, 0xc02c,	0x6bff, 0xc02c,		0x21, 0
	.dw 0x6c40, 0xc02c,	0x6c7f, 0xc02c,		0x21, 0
	.dw 0x6cc0, 0xc02c,	0x6cff, 0xc02c,		0x21, 0
	.dw 0x6d40, 0xc02c,	0x6d7f, 0xc02c,		0x21, 0
	.dw 0x6dc0, 0xc02c,	0x6dff, 0xc02c,		0x21, 0
	.dw 0x6e40, 0xc02c,	0x6e7f, 0xc02c,		0x21, 0
	.dw 0x6ec0, 0xc02c,	0x6eff, 0xc02c,		0x21, 0
	.dw 0x6f40, 0xc02c,	0x6f7f, 0xc02c,		0x21, 0
	.dw 0x6fc0, 0xc02c,	0x6fff, 0xc02c,		0x21, 0
	.dw 0x7040, 0xc02c,	0x707f, 0xc02c,		0x21, 0
	.dw 0x70c0, 0xc02c,	0x70ff, 0xc02c,		0x21, 0
	.dw 0x7140, 0xc02c,	0x717f, 0xc02c,		0x21, 0
	.dw 0x71c0, 0xc02c,	0x71ff, 0xc02c,		0x21, 0
	.dw 0x7240, 0xc02c,	0x727f, 0xc02c,		0x21, 0
	.dw 0x72c0, 0xc02c,	0x72ff, 0xc02c,		0x21, 0
	.dw 0x7340, 0xc02c,	0x737f, 0xc02c,		0x21, 0
	.dw 0x73c0, 0xc02c,	0x73ff, 0xc02c,		0x21, 0
	.dw 0x7440, 0xc02c,	0x747f, 0xc02c,		0x21, 0
	.dw 0x74c0, 0xc02c,	0x74ff, 0xc02c,		0x21, 0
	.dw 0x7540, 0xc02c,	0x757f, 0xc02c,		0x21, 0
	.dw 0x75c0, 0xc02c,	0x75ff, 0xc02c,		0x21, 0
	.dw 0x7640, 0xc02c,	0x767f, 0xc02c,		0x21, 0
	.dw 0x76c0, 0xc02c,	0x76ff, 0xc02c,		0x21, 0
	.dw 0x7740, 0xc02c,	0x777f, 0xc02c,		0x21, 0
	.dw 0x77c0, 0xc02c,	0x77ff, 0xc02c,		0x21, 0
	.dw 0x7840, 0xc02c,	0x787f, 0xc02c,		0x21, 0
	.dw 0x78c0, 0xc02c,	0x78ff, 0xc02c,		0x21, 0
	.dw 0x7940, 0xc02c,	0x797f, 0xc02c,		0x21, 0
	.dw 0x79c0, 0xc02c,	0x7fff, 0xc02c,		0x21, 0
	.dw 0x8040, 0xc02c,	0x807f, 0xc02c,		0x21, 0
	.dw 0x80c0, 0xc02c,	0x80ff, 0xc02c,		0x21, 0
	.dw 0x8140, 0xc02c,	0x817f, 0xc02c,		0x21, 0
	.dw 0x81c0, 0xc02c,	0x81ff, 0xc02c,		0x21, 0
	.dw 0x8240, 0xc02c,	0x827f, 0xc02c,		0x21, 0
	.dw 0x82c0, 0xc02c,	0x82ff, 0xc02c,		0x21, 0
	.dw 0x8340, 0xc02c,	0x837f, 0xc02c,		0x21, 0
	.dw 0x83c0, 0xc02c,	0x83ff, 0xc02c,		0x21, 0
	.dw 0x8440, 0xc02c,	0x847f, 0xc02c,		0x21, 0
	.dw 0x84c0, 0xc02c,	0x84ff, 0xc02c,		0x21, 0
	.dw 0x8540, 0xc02c,	0x857f, 0xc02c,		0x21, 0
	.dw 0x85c0, 0xc02c,	0x85ff, 0xc02c,		0x21, 0
	.dw 0x8640, 0xc02c,	0x867f, 0xc02c,		0x21, 0
	.dw 0x86c0, 0xc02c,	0x86ff, 0xc02c,		0x21, 0
	.dw 0x8740, 0xc02c,	0x877f, 0xc02c,		0x21, 0
	.dw 0x87c0, 0xc02c,	0x87ff, 0xc02c,		0x21, 0
	.dw 0x8840, 0xc02c,	0x887f, 0xc02c,		0x21, 0
	.dw 0x88c0, 0xc02c,	0x88ff, 0xc02c,		0x21, 0
	.dw 0x8940, 0xc02c,	0x897f, 0xc02c,		0x21, 0
	.dw 0x89c0, 0xc02c,	0x89ff, 0xc02c,		0x21, 0
	.dw 0x8a40, 0xc02c,	0x8a7f, 0xc02c,		0x21, 0
	.dw 0x8ac0, 0xc02c,	0x8aff, 0xc02c,		0x21, 0
	.dw 0x8b40, 0xc02c,	0x8b7f, 0xc02c,		0x21, 0
	.dw 0x8bc0, 0xc02c,	0x8bff, 0xc02c,		0x21, 0
	.dw 0x8c40, 0xc02c,	0x8c7f, 0xc02c,		0x21, 0
	.dw 0x8cc0, 0xc02c,	0x8cff, 0xc02c,		0x21, 0
	.dw 0x8d40, 0xc02c,	0x8d7f, 0xc02c,		0x21, 0
	.dw 0x8dc0, 0xc02c,	0x8dff, 0xc02c,		0x21, 0
	.dw 0x8e40, 0xc02c,	0x8e7f, 0xc02c,		0x21, 0
	.dw 0x8ec0, 0xc02c,	0x8eff, 0xc02c,		0x21, 0
	.dw 0x8f40, 0xc02c,	0x8f7f, 0xc02c,		0x21, 0
	.dw 0x8fc0, 0xc02c,	0x8fff, 0xc02c,		0x21, 0
	.dw 0x9040, 0xc02c,	0x907f, 0xc02c,		0x21, 0
	.dw 0x90c0, 0xc02c,	0x90ff, 0xc02c,		0x21, 0
	.dw 0x9140, 0xc02c,	0x917f, 0xc02c,		0x21, 0
	.dw 0x91c0, 0xc02c,	0x91ff, 0xc02c,		0x21, 0
	.dw 0x9240, 0xc02c,	0x927f, 0xc02c,		0x21, 0
	.dw 0x92c0, 0xc02c,	0x92ff, 0xc02c,		0x21, 0
	.dw 0x9340, 0xc02c,	0x937f, 0xc02c,		0x21, 0
	.dw 0x93c0, 0xc02c,	0x93ff, 0xc02c,		0x21, 0
	.dw 0x9440, 0xc02c,	0x947f, 0xc02c,		0x21, 0
	.dw 0x94c0, 0xc02c,	0x94ff, 0xc02c,		0x21, 0
	.dw 0x9540, 0xc02c,	0x957f, 0xc02c,		0x21, 0
	.dw 0x95c0, 0xc02c,	0x95ff, 0xc02c,		0x21, 0
	.dw 0x9640, 0xc02c,	0x967f, 0xc02c,		0x21, 0
	.dw 0x96c0, 0xc02c,	0x96ff, 0xc02c,		0x21, 0
	.dw 0x9740, 0xc02c,	0x977f, 0xc02c,		0x21, 0
	.dw 0x97c0, 0xc02c,	0x97ff, 0xc02c,		0x21, 0
	.dw 0x9840, 0xc02c,	0x987f, 0xc02c,		0x21, 0
	.dw 0x98c0, 0xc02c,	0x98ff, 0xc02c,		0x21, 0
	.dw 0x9940, 0xc02c,	0x997f, 0xc02c,		0x21, 0
	.dw 0x99c0, 0xc02c,	0x9fff, 0xc02c,		0x21, 0
	.dw 0xa040, 0xc02c,	0xa07f, 0xc02c,		0x21, 0
	.dw 0xa0c0, 0xc02c,	0xa0ff, 0xc02c,		0x21, 0
	.dw 0xa140, 0xc02c,	0xa17f, 0xc02c,		0x21, 0
	.dw 0xa1c0, 0xc02c,	0xa1ff, 0xc02c,		0x21, 0
	.dw 0xa240, 0xc02c,	0xa27f, 0xc02c,		0x21, 0
	.dw 0xa2c0, 0xc02c,	0xa2ff, 0xc02c,		0x21, 0
	.dw 0xa340, 0xc02c,	0xa37f, 0xc02c,		0x21, 0
	.dw 0xa3c0, 0xc02c,	0xa3ff, 0xc02c,		0x21, 0
	.dw 0xa440, 0xc02c,	0xa47f, 0xc02c,		0x21, 0
	.dw 0xa4c0, 0xc02c,	0xa4ff, 0xc02c,		0x21, 0
	.dw 0xa540, 0xc02c,	0xa57f, 0xc02c,		0x21, 0
	.dw 0xa5c0, 0xc02c,	0xa5ff, 0xc02c,		0x21, 0
	.dw 0xa640, 0xc02c,	0xa67f, 0xc02c,		0x21, 0
	.dw 0xa6c0, 0xc02c,	0xa6ff, 0xc02c,		0x21, 0
	.dw 0xa740, 0xc02c,	0xa77f, 0xc02c,		0x21, 0
	.dw 0xa7c0, 0xc02c,	0xa7ff, 0xc02c,		0x21, 0
	.dw 0xa840, 0xc02c,	0xa87f, 0xc02c,		0x21, 0
	.dw 0xa8c0, 0xc02c,	0xa8ff, 0xc02c,		0x21, 0
	.dw 0xa940, 0xc02c,	0xa97f, 0xc02c,		0x21, 0
	.dw 0xa9c0, 0xc02c,	0xa9ff, 0xc02c,		0x21, 0
	.dw 0xaa40, 0xc02c,	0xaa7f, 0xc02c,		0x21, 0
	.dw 0xaac0, 0xc02c,	0xaaff, 0xc02c,		0x21, 0
	.dw 0xab40, 0xc02c,	0xab7f, 0xc02c,		0x21, 0
	.dw 0xabc0, 0xc02c,	0xabff, 0xc02c,		0x21, 0
	.dw 0xac40, 0xc02c,	0xac7f, 0xc02c,		0x21, 0
	.dw 0xacc0, 0xc02c,	0xacff, 0xc02c,		0x21, 0
	.dw 0xad40, 0xc02c,	0xad7f, 0xc02c,		0x21, 0
	.dw 0xadc0, 0xc02c,	0xadff, 0xc02c,		0x21, 0
	.dw 0xae40, 0xc02c,	0xae7f, 0xc02c,		0x21, 0
	.dw 0xaec0, 0xc02c,	0xaeff, 0xc02c,		0x21, 0
	.dw 0xaf40, 0xc02c,	0xaf7f, 0xc02c,		0x21, 0
	.dw 0xafc0, 0xc02c,	0xafff, 0xc02c,		0x21, 0
	.dw 0xb040, 0xc02c,	0xb07f, 0xc02c,		0x21, 0
	.dw 0xb0c0, 0xc02c,	0xb0ff, 0xc02c,		0x21, 0
	.dw 0xb140, 0xc02c,	0xb17f, 0xc02c,		0x21, 0
	.dw 0xb1c0, 0xc02c,	0xb1ff, 0xc02c,		0x21, 0
	.dw 0xb240, 0xc02c,	0xb27f, 0xc02c,		0x21, 0
	.dw 0xb2c0, 0xc02c,	0xb2ff, 0xc02c,		0x21, 0
	.dw 0xb340, 0xc02c,	0xb37f, 0xc02c,		0x21, 0
	.dw 0xb3c0, 0xc02c,	0xb3ff, 0xc02c,		0x21, 0
	.dw 0xb440, 0xc02c,	0xb47f, 0xc02c,		0x21, 0
	.dw 0xb4c0, 0xc02c,	0xb4ff, 0xc02c,		0x21, 0
	.dw 0xb540, 0xc02c,	0xb57f, 0xc02c,		0x21, 0
	.dw 0xb5c0, 0xc02c,	0xb5ff, 0xc02c,		0x21, 0
	.dw 0xb640, 0xc02c,	0xb67f, 0xc02c,		0x21, 0
	.dw 0xb6c0, 0xc02c,	0xb6ff, 0xc02c,		0x21, 0
	.dw 0xb740, 0xc02c,	0xb77f, 0xc02c,		0x21, 0
	.dw 0xb7c0, 0xc02c,	0xb7ff, 0xc02c,		0x21, 0
	.dw 0xb840, 0xc02c,	0xb87f, 0xc02c,		0x21, 0
	.dw 0xb8c0, 0xc02c,	0xb8ff, 0xc02c,		0x21, 0
	.dw 0xb940, 0xc02c,	0xb97f, 0xc02c,		0x21, 0
	.dw 0xb9c0, 0xc02c,	0xbfff, 0xc02c,		0x21, 0
	.dw 0xc040, 0xc02c,	0xc07f, 0xc02c,		0x21, 0
	.dw 0xc0c0, 0xc02c,	0xc0ff, 0xc02c,		0x21, 0
	.dw 0xc140, 0xc02c,	0xc17f, 0xc02c,		0x21, 0
	.dw 0xc1c0, 0xc02c,	0xc1ff, 0xc02c,		0x21, 0
	.dw 0xc240, 0xc02c,	0xc27f, 0xc02c,		0x21, 0
	.dw 0xc2c0, 0xc02c,	0xc2ff, 0xc02c,		0x21, 0
	.dw 0xc340, 0xc02c,	0xc37f, 0xc02c,		0x21, 0
	.dw 0xc3c0, 0xc02c,	0xc3ff, 0xc02c,		0x21, 0
	.dw 0xc440, 0xc02c,	0xc47f, 0xc02c,		0x21, 0
	.dw 0xc4c0, 0xc02c,	0xc4ff, 0xc02c,		0x21, 0
	.dw 0xc540, 0xc02c,	0xc57f, 0xc02c,		0x21, 0
	.dw 0xc5c0, 0xc02c,	0xc5ff, 0xc02c,		0x21, 0
	.dw 0xc640, 0xc02c,	0xc67f, 0xc02c,		0x21, 0
	.dw 0xc6c0, 0xc02c,	0xc6ff, 0xc02c,		0x21, 0
	.dw 0xc740, 0xc02c,	0xc77f, 0xc02c,		0x21, 0
	.dw 0xc7c0, 0xc02c,	0xc7ff, 0xc02c,		0x21, 0
	.dw 0xc840, 0xc02c,	0xc87f, 0xc02c,		0x21, 0
	.dw 0xc8c0, 0xc02c,	0xc8ff, 0xc02c,		0x21, 0
	.dw 0xc940, 0xc02c,	0xc97f, 0xc02c,		0x21, 0
	.dw 0xc9c0, 0xc02c,	0xc9ff, 0xc02c,		0x21, 0
	.dw 0xca40, 0xc02c,	0xca7f, 0xc02c,		0x21, 0
	.dw 0xcac0, 0xc02c,	0xcaff, 0xc02c,		0x21, 0
	.dw 0xcb40, 0xc02c,	0xcb7f, 0xc02c,		0x21, 0
	.dw 0xcbc0, 0xc02c,	0xcbff, 0xc02c,		0x21, 0
	.dw 0xcc40, 0xc02c,	0xcc7f, 0xc02c,		0x21, 0
	.dw 0xccc0, 0xc02c,	0xccff, 0xc02c,		0x21, 0
	.dw 0xcd40, 0xc02c,	0xcd7f, 0xc02c,		0x21, 0
	.dw 0xcdc0, 0xc02c,	0xcdff, 0xc02c,		0x21, 0
	.dw 0xce40, 0xc02c,	0xce7f, 0xc02c,		0x21, 0
	.dw 0xcec0, 0xc02c,	0xceff, 0xc02c,		0x21, 0
	.dw 0xcf40, 0xc02c,	0xcf7f, 0xc02c,		0x21, 0
	.dw 0xcfc0, 0xc02c,	0xcfff, 0xc02c,		0x21, 0
	.dw 0xd040, 0xc02c,	0xd07f, 0xc02c,		0x21, 0
	.dw 0xd0c0, 0xc02c,	0xd0ff, 0xc02c,		0x21, 0
	.dw 0xd140, 0xc02c,	0xd17f, 0xc02c,		0x21, 0
	.dw 0xd1c0, 0xc02c,	0xd1ff, 0xc02c,		0x21, 0
	.dw 0xd240, 0xc02c,	0xd27f, 0xc02c,		0x21, 0
	.dw 0xd2c0, 0xc02c,	0xd2ff, 0xc02c,		0x21, 0
	.dw 0xd340, 0xc02c,	0xd37f, 0xc02c,		0x21, 0
	.dw 0xd3c0, 0xc02c,	0xd3ff, 0xc02c,		0x21, 0
	.dw 0xd440, 0xc02c,	0xd47f, 0xc02c,		0x21, 0
	.dw 0xd4c0, 0xc02c,	0xd4ff, 0xc02c,		0x21, 0
	.dw 0xd540, 0xc02c,	0xd57f, 0xc02c,		0x21, 0
	.dw 0xd5c0, 0xc02c,	0xd5ff, 0xc02c,		0x21, 0
	.dw 0xd640, 0xc02c,	0xd67f, 0xc02c,		0x21, 0
	.dw 0xd6c0, 0xc02c,	0xd6ff, 0xc02c,		0x21, 0
	.dw 0xd740, 0xc02c,	0xd77f, 0xc02c,		0x21, 0
	.dw 0xd7c0, 0xc02c,	0xd7ff, 0xc02c,		0x21, 0
	.dw 0xd840, 0xc02c,	0xd87f, 0xc02c,		0x21, 0
	.dw 0xd8c0, 0xc02c,	0xd8ff, 0xc02c,		0x21, 0
	.dw 0xd940, 0xc02c,	0xd97f, 0xc02c,		0x21, 0
	.dw 0xd9c0, 0xc02c,	0xdfff, 0xc02c,		0x21, 0
	.dw 0xe040, 0xc02c,	0xe07f, 0xc02c,		0x21, 0
	.dw 0xe0c0, 0xc02c,	0xe0ff, 0xc02c,		0x21, 0
	.dw 0xe140, 0xc02c,	0xe17f, 0xc02c,		0x21, 0
	.dw 0xe1c0, 0xc02c,	0xe1ff, 0xc02c,		0x21, 0
	.dw 0xe240, 0xc02c,	0xe27f, 0xc02c,		0x21, 0
	.dw 0xe2c0, 0xc02c,	0xe2ff, 0xc02c,		0x21, 0
	.dw 0xe340, 0xc02c,	0xe37f, 0xc02c,		0x21, 0
	.dw 0xe3c0, 0xc02c,	0xe3ff, 0xc02c,		0x21, 0
	.dw 0xe440, 0xc02c,	0xe47f, 0xc02c,		0x21, 0
	.dw 0xe4c0, 0xc02c,	0xe4ff, 0xc02c,		0x21, 0
	.dw 0xe540, 0xc02c,	0xe57f, 0xc02c,		0x21, 0
	.dw 0xe5c0, 0xc02c,	0xe5ff, 0xc02c,		0x21, 0
	.dw 0xe640, 0xc02c,	0xe67f, 0xc02c,		0x21, 0
	.dw 0xe6c0, 0xc02c,	0xe6ff, 0xc02c,		0x21, 0
	.dw 0xe740, 0xc02c,	0xe77f, 0xc02c,		0x21, 0
	.dw 0xe7c0, 0xc02c,	0xe7ff, 0xc02c,		0x21, 0
	.dw 0xe840, 0xc02c,	0xe87f, 0xc02c,		0x21, 0
	.dw 0xe8c0, 0xc02c,	0xe8ff, 0xc02c,		0x21, 0
	.dw 0xe940, 0xc02c,	0xe97f, 0xc02c,		0x21, 0
	.dw 0xe9c0, 0xc02c,	0xe9ff, 0xc02c,		0x21, 0
	.dw 0xea40, 0xc02c,	0xea7f, 0xc02c,		0x21, 0
	.dw 0xeac0, 0xc02c,	0xeaff, 0xc02c,		0x21, 0
	.dw 0xeb40, 0xc02c,	0xeb7f, 0xc02c,		0x21, 0
	.dw 0xebc0, 0xc02c,	0xebff, 0xc02c,		0x21, 0
	.dw 0xec40, 0xc02c,	0xec7f, 0xc02c,		0x21, 0
	.dw 0xecc0, 0xc02c,	0xecff, 0xc02c,		0x21, 0
	.dw 0xed40, 0xc02c,	0xed7f, 0xc02c,		0x21, 0
	.dw 0xedc0, 0xc02c,	0xedff, 0xc02c,		0x21, 0
	.dw 0xee40, 0xc02c,	0xee7f, 0xc02c,		0x21, 0
	.dw 0xeec0, 0xc02c,	0xeeff, 0xc02c,		0x21, 0
	.dw 0xef40, 0xc02c,	0xef7f, 0xc02c,		0x21, 0
	.dw 0xefc0, 0xc02c,	0xefff, 0xc02c,		0x21, 0
	.dw 0xf040, 0xc02c,	0xf07f, 0xc02c,		0x21, 0
	.dw 0xf0c0, 0xc02c,	0xf0ff, 0xc02c,		0x21, 0
	.dw 0xf140, 0xc02c,	0xf17f, 0xc02c,		0x21, 0
	.dw 0xf1c0, 0xc02c,	0xf1ff, 0xc02c,		0x21, 0
	.dw 0xf240, 0xc02c,	0xf27f, 0xc02c,		0x21, 0
	.dw 0xf2c0, 0xc02c,	0xf2ff, 0xc02c,		0x21, 0
	.dw 0xf340, 0xc02c,	0xf37f, 0xc02c,		0x21, 0
	.dw 0xf3c0, 0xc02c,	0xf3ff, 0xc02c,		0x21, 0
	.dw 0xf440, 0xc02c,	0xf47f, 0xc02c,		0x21, 0
	.dw 0xf4c0, 0xc02c,	0xf4ff, 0xc02c,		0x21, 0
	.dw 0xf540, 0xc02c,	0xf57f, 0xc02c,		0x21, 0
	.dw 0xf5c0, 0xc02c,	0xf5ff, 0xc02c,		0x21, 0
	.dw 0xf640, 0xc02c,	0xf67f, 0xc02c,		0x21, 0
	.dw 0xf6c0, 0xc02c,	0xf6ff, 0xc02c,		0x21, 0
	.dw 0xf740, 0xc02c,	0xf77f, 0xc02c,		0x21, 0
	.dw 0xf7c0, 0xc02c,	0xf7ff, 0xc02c,		0x21, 0
	.dw 0xf840, 0xc02c,	0xf87f, 0xc02c,		0x21, 0
	.dw 0xf8c0, 0xc02c,	0xf8ff, 0xc02c,		0x21, 0
	.dw 0xf940, 0xc02c,	0xf97f, 0xc02c,		0x21, 0
	.dw 0xf9c0, 0xc02c,	0xffff, 0xc02c,		0x21, 0
	.dw 0x0040, 0xc02d,	0x007f, 0xc02d,		0x21, 0
	.dw 0x00c0, 0xc02d,	0x00ff, 0xc02d,		0x21, 0
	.dw 0x0140, 0xc02d,	0x017f, 0xc02d,		0x21, 0
	.dw 0x01c0, 0xc02d,	0x01ff, 0xc02d,		0x21, 0
	.dw 0x0240, 0xc02d,	0x027f, 0xc02d,		0x21, 0
	.dw 0x02c0, 0xc02d,	0x02ff, 0xc02d,		0x21, 0
	.dw 0x0340, 0xc02d,	0x037f, 0xc02d,		0x21, 0
	.dw 0x03c0, 0xc02d,	0x03ff, 0xc02d,		0x21, 0
	.dw 0x0440, 0xc02d,	0x047f, 0xc02d,		0x21, 0
	.dw 0x04c0, 0xc02d,	0x04ff, 0xc02d,		0x21, 0
	.dw 0x0540, 0xc02d,	0x057f, 0xc02d,		0x21, 0
	.dw 0x05c0, 0xc02d,	0x05ff, 0xc02d,		0x21, 0
	.dw 0x0640, 0xc02d,	0x067f, 0xc02d,		0x21, 0
	.dw 0x06c0, 0xc02d,	0x06ff, 0xc02d,		0x21, 0
	.dw 0x0740, 0xc02d,	0x077f, 0xc02d,		0x21, 0
	.dw 0x07c0, 0xc02d,	0x07ff, 0xc02d,		0x21, 0
	.dw 0x0840, 0xc02d,	0x087f, 0xc02d,		0x21, 0
	.dw 0x08c0, 0xc02d,	0x08ff, 0xc02d,		0x21, 0
	.dw 0x0940, 0xc02d,	0x097f, 0xc02d,		0x21, 0
	.dw 0x09c0, 0xc02d,	0x09ff, 0xc02d,		0x21, 0
	.dw 0x0a40, 0xc02d,	0x0a7f, 0xc02d,		0x21, 0
	.dw 0x0ac0, 0xc02d,	0x0aff, 0xc02d,		0x21, 0
	.dw 0x0b40, 0xc02d,	0x0b7f, 0xc02d,		0x21, 0
	.dw 0x0bc0, 0xc02d,	0x0bff, 0xc02d,		0x21, 0
	.dw 0x0c40, 0xc02d,	0x0c7f, 0xc02d,		0x21, 0
	.dw 0x0cc0, 0xc02d,	0x0cff, 0xc02d,		0x21, 0
	.dw 0x0d40, 0xc02d,	0x0d7f, 0xc02d,		0x21, 0
	.dw 0x0dc0, 0xc02d,	0x0dff, 0xc02d,		0x21, 0
	.dw 0x0e40, 0xc02d,	0x0e7f, 0xc02d,		0x21, 0
	.dw 0x0ec0, 0xc02d,	0x0eff, 0xc02d,		0x21, 0
	.dw 0x0f40, 0xc02d,	0x0f7f, 0xc02d,		0x21, 0
	.dw 0x0fc0, 0xc02d,	0x0fff, 0xc02d,		0x21, 0
	.dw 0x1040, 0xc02d,	0x107f, 0xc02d,		0x21, 0
	.dw 0x10c0, 0xc02d,	0x10ff, 0xc02d,		0x21, 0
	.dw 0x1140, 0xc02d,	0x117f, 0xc02d,		0x21, 0
	.dw 0x11c0, 0xc02d,	0x11ff, 0xc02d,		0x21, 0
	.dw 0x1240, 0xc02d,	0x127f, 0xc02d,		0x21, 0
	.dw 0x12c0, 0xc02d,	0x12ff, 0xc02d,		0x21, 0
	.dw 0x1340, 0xc02d,	0x137f, 0xc02d,		0x21, 0
	.dw 0x13c0, 0xc02d,	0x13ff, 0xc02d,		0x21, 0
	.dw 0x1440, 0xc02d,	0x147f, 0xc02d,		0x21, 0
	.dw 0x14c0, 0xc02d,	0x14ff, 0xc02d,		0x21, 0
	.dw 0x1540, 0xc02d,	0x157f, 0xc02d,		0x21, 0
	.dw 0x15c0, 0xc02d,	0x15ff, 0xc02d,		0x21, 0
	.dw 0x1640, 0xc02d,	0x167f, 0xc02d,		0x21, 0
	.dw 0x16c0, 0xc02d,	0x16ff, 0xc02d,		0x21, 0
	.dw 0x1740, 0xc02d,	0x177f, 0xc02d,		0x21, 0
	.dw 0x17c0, 0xc02d,	0x17ff, 0xc02d,		0x21, 0
	.dw 0x1840, 0xc02d,	0x187f, 0xc02d,		0x21, 0
	.dw 0x18c0, 0xc02d,	0x18ff, 0xc02d,		0x21, 0
	.dw 0x1940, 0xc02d,	0x197f, 0xc02d,		0x21, 0
	.dw 0x19c0, 0xc02d,	0x1fff, 0xc02d,		0x21, 0
	.dw 0x2040, 0xc02d,	0x207f, 0xc02d,		0x21, 0
	.dw 0x20c0, 0xc02d,	0x20ff, 0xc02d,		0x21, 0
	.dw 0x2140, 0xc02d,	0x217f, 0xc02d,		0x21, 0
	.dw 0x21c0, 0xc02d,	0x21ff, 0xc02d,		0x21, 0
	.dw 0x2240, 0xc02d,	0x227f, 0xc02d,		0x21, 0
	.dw 0x22c0, 0xc02d,	0x22ff, 0xc02d,		0x21, 0
	.dw 0x2340, 0xc02d,	0x237f, 0xc02d,		0x21, 0
	.dw 0x23c0, 0xc02d,	0x23ff, 0xc02d,		0x21, 0
	.dw 0x2440, 0xc02d,	0x247f, 0xc02d,		0x21, 0
	.dw 0x24c0, 0xc02d,	0x24ff, 0xc02d,		0x21, 0
	.dw 0x2540, 0xc02d,	0x257f, 0xc02d,		0x21, 0
	.dw 0x25c0, 0xc02d,	0x25ff, 0xc02d,		0x21, 0
	.dw 0x2640, 0xc02d,	0x267f, 0xc02d,		0x21, 0
	.dw 0x26c0, 0xc02d,	0x26ff, 0xc02d,		0x21, 0
	.dw 0x2740, 0xc02d,	0x277f, 0xc02d,		0x21, 0
	.dw 0x27c0, 0xc02d,	0x27ff, 0xc02d,		0x21, 0
	.dw 0x2840, 0xc02d,	0x287f, 0xc02d,		0x21, 0
	.dw 0x28c0, 0xc02d,	0x28ff, 0xc02d,		0x21, 0
	.dw 0x2940, 0xc02d,	0x297f, 0xc02d,		0x21, 0
	.dw 0x29c0, 0xc02d,	0x29ff, 0xc02d,		0x21, 0
	.dw 0x2a40, 0xc02d,	0x2a7f, 0xc02d,		0x21, 0
	.dw 0x2ac0, 0xc02d,	0x2aff, 0xc02d,		0x21, 0
	.dw 0x2b40, 0xc02d,	0x2b7f, 0xc02d,		0x21, 0
	.dw 0x2bc0, 0xc02d,	0x2bff, 0xc02d,		0x21, 0
	.dw 0x2c40, 0xc02d,	0x2c7f, 0xc02d,		0x21, 0
	.dw 0x2cc0, 0xc02d,	0x2cff, 0xc02d,		0x21, 0
	.dw 0x2d40, 0xc02d,	0x2d7f, 0xc02d,		0x21, 0
	.dw 0x2dc0, 0xc02d,	0x2dff, 0xc02d,		0x21, 0
	.dw 0x2e40, 0xc02d,	0x2e7f, 0xc02d,		0x21, 0
	.dw 0x2ec0, 0xc02d,	0x2eff, 0xc02d,		0x21, 0
	.dw 0x2f40, 0xc02d,	0x2f7f, 0xc02d,		0x21, 0
	.dw 0x2fc0, 0xc02d,	0x2fff, 0xc02d,		0x21, 0
	.dw 0x3040, 0xc02d,	0x307f, 0xc02d,		0x21, 0
	.dw 0x30c0, 0xc02d,	0x30ff, 0xc02d,		0x21, 0
	.dw 0x3140, 0xc02d,	0x317f, 0xc02d,		0x21, 0
	.dw 0x31c0, 0xc02d,	0x31ff, 0xc02d,		0x21, 0
	.dw 0x3240, 0xc02d,	0x327f, 0xc02d,		0x21, 0
	.dw 0x32c0, 0xc02d,	0x32ff, 0xc02d,		0x21, 0
	.dw 0x3340, 0xc02d,	0x337f, 0xc02d,		0x21, 0
	.dw 0x33c0, 0xc02d,	0x33ff, 0xc02d,		0x21, 0
	.dw 0x3440, 0xc02d,	0x347f, 0xc02d,		0x21, 0
	.dw 0x34c0, 0xc02d,	0x34ff, 0xc02d,		0x21, 0
	.dw 0x3540, 0xc02d,	0x357f, 0xc02d,		0x21, 0
	.dw 0x35c0, 0xc02d,	0x35ff, 0xc02d,		0x21, 0
	.dw 0x3640, 0xc02d,	0x367f, 0xc02d,		0x21, 0
	.dw 0x36c0, 0xc02d,	0x36ff, 0xc02d,		0x21, 0
	.dw 0x3740, 0xc02d,	0x377f, 0xc02d,		0x21, 0
	.dw 0x37c0, 0xc02d,	0x37ff, 0xc02d,		0x21, 0
	.dw 0x3840, 0xc02d,	0x387f, 0xc02d,		0x21, 0
	.dw 0x38c0, 0xc02d,	0x38ff, 0xc02d,		0x21, 0
	.dw 0x3940, 0xc02d,	0x397f, 0xc02d,		0x21, 0
	.dw 0x39c0, 0xc02d,	0x3fff, 0xc02d,		0x21, 0
	.dw 0x4040, 0xc02d,	0x407f, 0xc02d,		0x21, 0
	.dw 0x40c0, 0xc02d,	0x40ff, 0xc02d,		0x21, 0
	.dw 0x4140, 0xc02d,	0x417f, 0xc02d,		0x21, 0
	.dw 0x41c0, 0xc02d,	0x41ff, 0xc02d,		0x21, 0
	.dw 0x4240, 0xc02d,	0x427f, 0xc02d,		0x21, 0
	.dw 0x42c0, 0xc02d,	0x42ff, 0xc02d,		0x21, 0
	.dw 0x4340, 0xc02d,	0x437f, 0xc02d,		0x21, 0
	.dw 0x43c0, 0xc02d,	0x43ff, 0xc02d,		0x21, 0
	.dw 0x4440, 0xc02d,	0x447f, 0xc02d,		0x21, 0
	.dw 0x44c0, 0xc02d,	0x44ff, 0xc02d,		0x21, 0
	.dw 0x4540, 0xc02d,	0x457f, 0xc02d,		0x21, 0
	.dw 0x45c0, 0xc02d,	0x45ff, 0xc02d,		0x21, 0
	.dw 0x4640, 0xc02d,	0x467f, 0xc02d,		0x21, 0
	.dw 0x46c0, 0xc02d,	0x46ff, 0xc02d,		0x21, 0
	.dw 0x4740, 0xc02d,	0x477f, 0xc02d,		0x21, 0
	.dw 0x47c0, 0xc02d,	0x47ff, 0xc02d,		0x21, 0
	.dw 0x4840, 0xc02d,	0x487f, 0xc02d,		0x21, 0
	.dw 0x48c0, 0xc02d,	0x48ff, 0xc02d,		0x21, 0
	.dw 0x4940, 0xc02d,	0x497f, 0xc02d,		0x21, 0
	.dw 0x49c0, 0xc02d,	0x49ff, 0xc02d,		0x21, 0
	.dw 0x4a40, 0xc02d,	0x4a7f, 0xc02d,		0x21, 0
	.dw 0x4ac0, 0xc02d,	0x4aff, 0xc02d,		0x21, 0
	.dw 0x4b40, 0xc02d,	0x4b7f, 0xc02d,		0x21, 0
	.dw 0x4bc0, 0xc02d,	0x4bff, 0xc02d,		0x21, 0
	.dw 0x4c40, 0xc02d,	0x4c7f, 0xc02d,		0x21, 0
	.dw 0x4cc0, 0xc02d,	0x4cff, 0xc02d,		0x21, 0
	.dw 0x4d40, 0xc02d,	0x4d7f, 0xc02d,		0x21, 0
	.dw 0x4dc0, 0xc02d,	0x4dff, 0xc02d,		0x21, 0
	.dw 0x4e40, 0xc02d,	0x4e7f, 0xc02d,		0x21, 0
	.dw 0x4ec0, 0xc02d,	0x4eff, 0xc02d,		0x21, 0
	.dw 0x4f40, 0xc02d,	0x4f7f, 0xc02d,		0x21, 0
	.dw 0x4fc0, 0xc02d,	0x4fff, 0xc02d,		0x21, 0
	.dw 0x5040, 0xc02d,	0x507f, 0xc02d,		0x21, 0
	.dw 0x50c0, 0xc02d,	0x50ff, 0xc02d,		0x21, 0
	.dw 0x5140, 0xc02d,	0x517f, 0xc02d,		0x21, 0
	.dw 0x51c0, 0xc02d,	0x51ff, 0xc02d,		0x21, 0
	.dw 0x5240, 0xc02d,	0x527f, 0xc02d,		0x21, 0
	.dw 0x52c0, 0xc02d,	0x52ff, 0xc02d,		0x21, 0
	.dw 0x5340, 0xc02d,	0x537f, 0xc02d,		0x21, 0
	.dw 0x53c0, 0xc02d,	0x53ff, 0xc02d,		0x21, 0
	.dw 0x5440, 0xc02d,	0x547f, 0xc02d,		0x21, 0
	.dw 0x54c0, 0xc02d,	0x54ff, 0xc02d,		0x21, 0
	.dw 0x5540, 0xc02d,	0x557f, 0xc02d,		0x21, 0
	.dw 0x55c0, 0xc02d,	0x55ff, 0xc02d,		0x21, 0
	.dw 0x5640, 0xc02d,	0x567f, 0xc02d,		0x21, 0
	.dw 0x56c0, 0xc02d,	0x56ff, 0xc02d,		0x21, 0
	.dw 0x5740, 0xc02d,	0x577f, 0xc02d,		0x21, 0
	.dw 0x57c0, 0xc02d,	0x57ff, 0xc02d,		0x21, 0
	.dw 0x5840, 0xc02d,	0x587f, 0xc02d,		0x21, 0
	.dw 0x58c0, 0xc02d,	0x58ff, 0xc02d,		0x21, 0
	.dw 0x5940, 0xc02d,	0x597f, 0xc02d,		0x21, 0
	.dw 0x59c0, 0xc02d,	0x5fff, 0xc02d,		0x21, 0
	.dw 0x6040, 0xc02d,	0x607f, 0xc02d,		0x21, 0
	.dw 0x60c0, 0xc02d,	0x60ff, 0xc02d,		0x21, 0
	.dw 0x6140, 0xc02d,	0x617f, 0xc02d,		0x21, 0
	.dw 0x61c0, 0xc02d,	0x61ff, 0xc02d,		0x21, 0
	.dw 0x6240, 0xc02d,	0x627f, 0xc02d,		0x21, 0
	.dw 0x62c0, 0xc02d,	0x62ff, 0xc02d,		0x21, 0
	.dw 0x6340, 0xc02d,	0x637f, 0xc02d,		0x21, 0
	.dw 0x63c0, 0xc02d,	0x63ff, 0xc02d,		0x21, 0
	.dw 0x6440, 0xc02d,	0x647f, 0xc02d,		0x21, 0
	.dw 0x64c0, 0xc02d,	0x64ff, 0xc02d,		0x21, 0
	.dw 0x6540, 0xc02d,	0x657f, 0xc02d,		0x21, 0
	.dw 0x65c0, 0xc02d,	0x65ff, 0xc02d,		0x21, 0
	.dw 0x6640, 0xc02d,	0x667f, 0xc02d,		0x21, 0
	.dw 0x66c0, 0xc02d,	0x66ff, 0xc02d,		0x21, 0
	.dw 0x6740, 0xc02d,	0x677f, 0xc02d,		0x21, 0
	.dw 0x67c0, 0xc02d,	0x67ff, 0xc02d,		0x21, 0
	.dw 0x6840, 0xc02d,	0x687f, 0xc02d,		0x21, 0
	.dw 0x68c0, 0xc02d,	0x68ff, 0xc02d,		0x21, 0
	.dw 0x6940, 0xc02d,	0x697f, 0xc02d,		0x21, 0
	.dw 0x69c0, 0xc02d,	0x69ff, 0xc02d,		0x21, 0
	.dw 0x6a40, 0xc02d,	0x6a7f, 0xc02d,		0x21, 0
	.dw 0x6ac0, 0xc02d,	0x6aff, 0xc02d,		0x21, 0
	.dw 0x6b40, 0xc02d,	0x6b7f, 0xc02d,		0x21, 0
	.dw 0x6bc0, 0xc02d,	0x6bff, 0xc02d,		0x21, 0
	.dw 0x6c40, 0xc02d,	0x6c7f, 0xc02d,		0x21, 0
	.dw 0x6cc0, 0xc02d,	0x6cff, 0xc02d,		0x21, 0
	.dw 0x6d40, 0xc02d,	0x6d7f, 0xc02d,		0x21, 0
	.dw 0x6dc0, 0xc02d,	0x6dff, 0xc02d,		0x21, 0
	.dw 0x6e40, 0xc02d,	0x6e7f, 0xc02d,		0x21, 0
	.dw 0x6ec0, 0xc02d,	0x6eff, 0xc02d,		0x21, 0
	.dw 0x6f40, 0xc02d,	0x6f7f, 0xc02d,		0x21, 0
	.dw 0x6fc0, 0xc02d,	0x6fff, 0xc02d,		0x21, 0
	.dw 0x7040, 0xc02d,	0x707f, 0xc02d,		0x21, 0
	.dw 0x70c0, 0xc02d,	0x70ff, 0xc02d,		0x21, 0
	.dw 0x7140, 0xc02d,	0x717f, 0xc02d,		0x21, 0
	.dw 0x71c0, 0xc02d,	0x71ff, 0xc02d,		0x21, 0
	.dw 0x7240, 0xc02d,	0x727f, 0xc02d,		0x21, 0
	.dw 0x72c0, 0xc02d,	0x72ff, 0xc02d,		0x21, 0
	.dw 0x7340, 0xc02d,	0x737f, 0xc02d,		0x21, 0
	.dw 0x73c0, 0xc02d,	0x73ff, 0xc02d,		0x21, 0
	.dw 0x7440, 0xc02d,	0x747f, 0xc02d,		0x21, 0
	.dw 0x74c0, 0xc02d,	0x74ff, 0xc02d,		0x21, 0
	.dw 0x7540, 0xc02d,	0x757f, 0xc02d,		0x21, 0
	.dw 0x75c0, 0xc02d,	0x75ff, 0xc02d,		0x21, 0
	.dw 0x7640, 0xc02d,	0x767f, 0xc02d,		0x21, 0
	.dw 0x76c0, 0xc02d,	0x76ff, 0xc02d,		0x21, 0
	.dw 0x7740, 0xc02d,	0x777f, 0xc02d,		0x21, 0
	.dw 0x77c0, 0xc02d,	0x77ff, 0xc02d,		0x21, 0
	.dw 0x7840, 0xc02d,	0x787f, 0xc02d,		0x21, 0
	.dw 0x78c0, 0xc02d,	0x78ff, 0xc02d,		0x21, 0
	.dw 0x7940, 0xc02d,	0x797f, 0xc02d,		0x21, 0
	.dw 0x79c0, 0xc02d,	0x7fff, 0xc02d,		0x21, 0
	.dw 0x8040, 0xc02d,	0x807f, 0xc02d,		0x21, 0
	.dw 0x80c0, 0xc02d,	0x80ff, 0xc02d,		0x21, 0
	.dw 0x8140, 0xc02d,	0x817f, 0xc02d,		0x21, 0
	.dw 0x81c0, 0xc02d,	0x81ff, 0xc02d,		0x21, 0
	.dw 0x8240, 0xc02d,	0x827f, 0xc02d,		0x21, 0
	.dw 0x82c0, 0xc02d,	0x82ff, 0xc02d,		0x21, 0
	.dw 0x8340, 0xc02d,	0x837f, 0xc02d,		0x21, 0
	.dw 0x83c0, 0xc02d,	0x83ff, 0xc02d,		0x21, 0
	.dw 0x8440, 0xc02d,	0x847f, 0xc02d,		0x21, 0
	.dw 0x84c0, 0xc02d,	0x84ff, 0xc02d,		0x21, 0
	.dw 0x8540, 0xc02d,	0x857f, 0xc02d,		0x21, 0
	.dw 0x85c0, 0xc02d,	0x85ff, 0xc02d,		0x21, 0
	.dw 0x8640, 0xc02d,	0x867f, 0xc02d,		0x21, 0
	.dw 0x86c0, 0xc02d,	0x86ff, 0xc02d,		0x21, 0
	.dw 0x8740, 0xc02d,	0x877f, 0xc02d,		0x21, 0
	.dw 0x87c0, 0xc02d,	0x87ff, 0xc02d,		0x21, 0
	.dw 0x8840, 0xc02d,	0x887f, 0xc02d,		0x21, 0
	.dw 0x88c0, 0xc02d,	0x88ff, 0xc02d,		0x21, 0
	.dw 0x8940, 0xc02d,	0x897f, 0xc02d,		0x21, 0
	.dw 0x89c0, 0xc02d,	0x89ff, 0xc02d,		0x21, 0
	.dw 0x8a40, 0xc02d,	0x8a7f, 0xc02d,		0x21, 0
	.dw 0x8ac0, 0xc02d,	0x8aff, 0xc02d,		0x21, 0
	.dw 0x8b40, 0xc02d,	0x8b7f, 0xc02d,		0x21, 0
	.dw 0x8bc0, 0xc02d,	0x8bff, 0xc02d,		0x21, 0
	.dw 0x8c40, 0xc02d,	0x8c7f, 0xc02d,		0x21, 0
	.dw 0x8cc0, 0xc02d,	0x8cff, 0xc02d,		0x21, 0
	.dw 0x8d40, 0xc02d,	0x8d7f, 0xc02d,		0x21, 0
	.dw 0x8dc0, 0xc02d,	0x8dff, 0xc02d,		0x21, 0
	.dw 0x8e40, 0xc02d,	0x8e7f, 0xc02d,		0x21, 0
	.dw 0x8ec0, 0xc02d,	0x8eff, 0xc02d,		0x21, 0
	.dw 0x8f40, 0xc02d,	0x8f7f, 0xc02d,		0x21, 0
	.dw 0x8fc0, 0xc02d,	0x8fff, 0xc02d,		0x21, 0
	.dw 0x9040, 0xc02d,	0x907f, 0xc02d,		0x21, 0
	.dw 0x90c0, 0xc02d,	0x90ff, 0xc02d,		0x21, 0
	.dw 0x9140, 0xc02d,	0x917f, 0xc02d,		0x21, 0
	.dw 0x91c0, 0xc02d,	0x91ff, 0xc02d,		0x21, 0
	.dw 0x9240, 0xc02d,	0x927f, 0xc02d,		0x21, 0
	.dw 0x92c0, 0xc02d,	0x92ff, 0xc02d,		0x21, 0
	.dw 0x9340, 0xc02d,	0x937f, 0xc02d,		0x21, 0
	.dw 0x93c0, 0xc02d,	0x93ff, 0xc02d,		0x21, 0
	.dw 0x9440, 0xc02d,	0x947f, 0xc02d,		0x21, 0
	.dw 0x94c0, 0xc02d,	0x94ff, 0xc02d,		0x21, 0
	.dw 0x9540, 0xc02d,	0x957f, 0xc02d,		0x21, 0
	.dw 0x95c0, 0xc02d,	0x95ff, 0xc02d,		0x21, 0
	.dw 0x9640, 0xc02d,	0x967f, 0xc02d,		0x21, 0
	.dw 0x96c0, 0xc02d,	0x96ff, 0xc02d,		0x21, 0
	.dw 0x9740, 0xc02d,	0x977f, 0xc02d,		0x21, 0
	.dw 0x97c0, 0xc02d,	0x97ff, 0xc02d,		0x21, 0
	.dw 0x9840, 0xc02d,	0x987f, 0xc02d,		0x21, 0
	.dw 0x98c0, 0xc02d,	0x98ff, 0xc02d,		0x21, 0
	.dw 0x9940, 0xc02d,	0x997f, 0xc02d,		0x21, 0
	.dw 0x99c0, 0xc02d,	0x9fff, 0xc02d,		0x21, 0
	.dw 0xa040, 0xc02d,	0xa07f, 0xc02d,		0x21, 0
	.dw 0xa0c0, 0xc02d,	0xa0ff, 0xc02d,		0x21, 0
	.dw 0xa140, 0xc02d,	0xa17f, 0xc02d,		0x21, 0
	.dw 0xa1c0, 0xc02d,	0xa1ff, 0xc02d,		0x21, 0
	.dw 0xa240, 0xc02d,	0xa27f, 0xc02d,		0x21, 0
	.dw 0xa2c0, 0xc02d,	0xa2ff, 0xc02d,		0x21, 0
	.dw 0xa340, 0xc02d,	0xa37f, 0xc02d,		0x21, 0
	.dw 0xa3c0, 0xc02d,	0xa3ff, 0xc02d,		0x21, 0
	.dw 0xa440, 0xc02d,	0xa47f, 0xc02d,		0x21, 0
	.dw 0xa4c0, 0xc02d,	0xa4ff, 0xc02d,		0x21, 0
	.dw 0xa540, 0xc02d,	0xa57f, 0xc02d,		0x21, 0
	.dw 0xa5c0, 0xc02d,	0xa5ff, 0xc02d,		0x21, 0
	.dw 0xa640, 0xc02d,	0xa67f, 0xc02d,		0x21, 0
	.dw 0xa6c0, 0xc02d,	0xa6ff, 0xc02d,		0x21, 0
	.dw 0xa740, 0xc02d,	0xa77f, 0xc02d,		0x21, 0
	.dw 0xa7c0, 0xc02d,	0xa7ff, 0xc02d,		0x21, 0
	.dw 0xa840, 0xc02d,	0xa87f, 0xc02d,		0x21, 0
	.dw 0xa8c0, 0xc02d,	0xa8ff, 0xc02d,		0x21, 0
	.dw 0xa940, 0xc02d,	0xa97f, 0xc02d,		0x21, 0
	.dw 0xa9c0, 0xc02d,	0xa9ff, 0xc02d,		0x21, 0
	.dw 0xaa40, 0xc02d,	0xaa7f, 0xc02d,		0x21, 0
	.dw 0xaac0, 0xc02d,	0xaaff, 0xc02d,		0x21, 0
	.dw 0xab40, 0xc02d,	0xab7f, 0xc02d,		0x21, 0
	.dw 0xabc0, 0xc02d,	0xabff, 0xc02d,		0x21, 0
	.dw 0xac40, 0xc02d,	0xac7f, 0xc02d,		0x21, 0
	.dw 0xacc0, 0xc02d,	0xacff, 0xc02d,		0x21, 0
	.dw 0xad40, 0xc02d,	0xad7f, 0xc02d,		0x21, 0
	.dw 0xadc0, 0xc02d,	0xadff, 0xc02d,		0x21, 0
	.dw 0xae40, 0xc02d,	0xae7f, 0xc02d,		0x21, 0
	.dw 0xaec0, 0xc02d,	0xaeff, 0xc02d,		0x21, 0
	.dw 0xaf40, 0xc02d,	0xaf7f, 0xc02d,		0x21, 0
	.dw 0xafc0, 0xc02d,	0xafff, 0xc02d,		0x21, 0
	.dw 0xb040, 0xc02d,	0xb07f, 0xc02d,		0x21, 0
	.dw 0xb0c0, 0xc02d,	0xb0ff, 0xc02d,		0x21, 0
	.dw 0xb140, 0xc02d,	0xb17f, 0xc02d,		0x21, 0
	.dw 0xb1c0, 0xc02d,	0xb1ff, 0xc02d,		0x21, 0
	.dw 0xb240, 0xc02d,	0xb27f, 0xc02d,		0x21, 0
	.dw 0xb2c0, 0xc02d,	0xb2ff, 0xc02d,		0x21, 0
	.dw 0xb340, 0xc02d,	0xb37f, 0xc02d,		0x21, 0
	.dw 0xb3c0, 0xc02d,	0xb3ff, 0xc02d,		0x21, 0
	.dw 0xb440, 0xc02d,	0xb47f, 0xc02d,		0x21, 0
	.dw 0xb4c0, 0xc02d,	0xb4ff, 0xc02d,		0x21, 0
	.dw 0xb540, 0xc02d,	0xb57f, 0xc02d,		0x21, 0
	.dw 0xb5c0, 0xc02d,	0xb5ff, 0xc02d,		0x21, 0
	.dw 0xb640, 0xc02d,	0xb67f, 0xc02d,		0x21, 0
	.dw 0xb6c0, 0xc02d,	0xb6ff, 0xc02d,		0x21, 0
	.dw 0xb740, 0xc02d,	0xb77f, 0xc02d,		0x21, 0
	.dw 0xb7c0, 0xc02d,	0xb7ff, 0xc02d,		0x21, 0
	.dw 0xb840, 0xc02d,	0xb87f, 0xc02d,		0x21, 0
	.dw 0xb8c0, 0xc02d,	0xb8ff, 0xc02d,		0x21, 0
	.dw 0xb940, 0xc02d,	0xb97f, 0xc02d,		0x21, 0
	.dw 0xb9c0, 0xc02d,	0xbfff, 0xc02d,		0x21, 0
	.dw 0xc040, 0xc02d,	0xc07f, 0xc02d,		0x21, 0
	.dw 0xc0c0, 0xc02d,	0xc0ff, 0xc02d,		0x21, 0
	.dw 0xc140, 0xc02d,	0xc17f, 0xc02d,		0x21, 0
	.dw 0xc1c0, 0xc02d,	0xc1ff, 0xc02d,		0x21, 0
	.dw 0xc240, 0xc02d,	0xc27f, 0xc02d,		0x21, 0
	.dw 0xc2c0, 0xc02d,	0xc2ff, 0xc02d,		0x21, 0
	.dw 0xc340, 0xc02d,	0xc37f, 0xc02d,		0x21, 0
	.dw 0xc3c0, 0xc02d,	0xc3ff, 0xc02d,		0x21, 0
	.dw 0xc440, 0xc02d,	0xc47f, 0xc02d,		0x21, 0
	.dw 0xc4c0, 0xc02d,	0xc4ff, 0xc02d,		0x21, 0
	.dw 0xc540, 0xc02d,	0xc57f, 0xc02d,		0x21, 0
	.dw 0xc5c0, 0xc02d,	0xc5ff, 0xc02d,		0x21, 0
	.dw 0xc640, 0xc02d,	0xc67f, 0xc02d,		0x21, 0
	.dw 0xc6c0, 0xc02d,	0xc6ff, 0xc02d,		0x21, 0
	.dw 0xc740, 0xc02d,	0xc77f, 0xc02d,		0x21, 0
	.dw 0xc7c0, 0xc02d,	0xc7ff, 0xc02d,		0x21, 0
	.dw 0xc840, 0xc02d,	0xc87f, 0xc02d,		0x21, 0
	.dw 0xc8c0, 0xc02d,	0xc8ff, 0xc02d,		0x21, 0
	.dw 0xc940, 0xc02d,	0xc97f, 0xc02d,		0x21, 0
	.dw 0xc9c0, 0xc02d,	0xc9ff, 0xc02d,		0x21, 0
	.dw 0xca40, 0xc02d,	0xca7f, 0xc02d,		0x21, 0
	.dw 0xcac0, 0xc02d,	0xcaff, 0xc02d,		0x21, 0
	.dw 0xcb40, 0xc02d,	0xcb7f, 0xc02d,		0x21, 0
	.dw 0xcbc0, 0xc02d,	0xcbff, 0xc02d,		0x21, 0
	.dw 0xcc40, 0xc02d,	0xcc7f, 0xc02d,		0x21, 0
	.dw 0xccc0, 0xc02d,	0xccff, 0xc02d,		0x21, 0
	.dw 0xcd40, 0xc02d,	0xcd7f, 0xc02d,		0x21, 0
	.dw 0xcdc0, 0xc02d,	0xcdff, 0xc02d,		0x21, 0
	.dw 0xce40, 0xc02d,	0xce7f, 0xc02d,		0x21, 0
	.dw 0xcec0, 0xc02d,	0xceff, 0xc02d,		0x21, 0
	.dw 0xcf40, 0xc02d,	0xcf7f, 0xc02d,		0x21, 0
	.dw 0xcfc0, 0xc02d,	0xcfff, 0xc02d,		0x21, 0
	.dw 0xd040, 0xc02d,	0xd07f, 0xc02d,		0x21, 0
	.dw 0xd0c0, 0xc02d,	0xd0ff, 0xc02d,		0x21, 0
	.dw 0xd140, 0xc02d,	0xd17f, 0xc02d,		0x21, 0
	.dw 0xd1c0, 0xc02d,	0xd1ff, 0xc02d,		0x21, 0
	.dw 0xd240, 0xc02d,	0xd27f, 0xc02d,		0x21, 0
	.dw 0xd2c0, 0xc02d,	0xd2ff, 0xc02d,		0x21, 0
	.dw 0xd340, 0xc02d,	0xd37f, 0xc02d,		0x21, 0
	.dw 0xd3c0, 0xc02d,	0xd3ff, 0xc02d,		0x21, 0
	.dw 0xd440, 0xc02d,	0xd47f, 0xc02d,		0x21, 0
	.dw 0xd4c0, 0xc02d,	0xd4ff, 0xc02d,		0x21, 0
	.dw 0xd540, 0xc02d,	0xd57f, 0xc02d,		0x21, 0
	.dw 0xd5c0, 0xc02d,	0xd5ff, 0xc02d,		0x21, 0
	.dw 0xd640, 0xc02d,	0xd67f, 0xc02d,		0x21, 0
	.dw 0xd6c0, 0xc02d,	0xd6ff, 0xc02d,		0x21, 0
	.dw 0xd740, 0xc02d,	0xd77f, 0xc02d,		0x21, 0
	.dw 0xd7c0, 0xc02d,	0xd7ff, 0xc02d,		0x21, 0
	.dw 0xd840, 0xc02d,	0xd87f, 0xc02d,		0x21, 0
	.dw 0xd8c0, 0xc02d,	0xd8ff, 0xc02d,		0x21, 0
	.dw 0xd940, 0xc02d,	0xd97f, 0xc02d,		0x21, 0
	.dw 0xd9c0, 0xc02d,	0xdfff, 0xc02d,		0x21, 0
	.dw 0xe040, 0xc02d,	0xe07f, 0xc02d,		0x21, 0
	.dw 0xe0c0, 0xc02d,	0xe0ff, 0xc02d,		0x21, 0
	.dw 0xe140, 0xc02d,	0xe17f, 0xc02d,		0x21, 0
	.dw 0xe1c0, 0xc02d,	0xe1ff, 0xc02d,		0x21, 0
	.dw 0xe240, 0xc02d,	0xe27f, 0xc02d,		0x21, 0
	.dw 0xe2c0, 0xc02d,	0xe2ff, 0xc02d,		0x21, 0
	.dw 0xe340, 0xc02d,	0xe37f, 0xc02d,		0x21, 0
	.dw 0xe3c0, 0xc02d,	0xe3ff, 0xc02d,		0x21, 0
	.dw 0xe440, 0xc02d,	0xe47f, 0xc02d,		0x21, 0
	.dw 0xe4c0, 0xc02d,	0xe4ff, 0xc02d,		0x21, 0
	.dw 0xe540, 0xc02d,	0xe57f, 0xc02d,		0x21, 0
	.dw 0xe5c0, 0xc02d,	0xe5ff, 0xc02d,		0x21, 0
	.dw 0xe640, 0xc02d,	0xe67f, 0xc02d,		0x21, 0
	.dw 0xe6c0, 0xc02d,	0xe6ff, 0xc02d,		0x21, 0
	.dw 0xe740, 0xc02d,	0xe77f, 0xc02d,		0x21, 0
	.dw 0xe7c0, 0xc02d,	0xe7ff, 0xc02d,		0x21, 0
	.dw 0xe840, 0xc02d,	0xe87f, 0xc02d,		0x21, 0
	.dw 0xe8c0, 0xc02d,	0xe8ff, 0xc02d,		0x21, 0
	.dw 0xe940, 0xc02d,	0xe97f, 0xc02d,		0x21, 0
	.dw 0xe9c0, 0xc02d,	0xe9ff, 0xc02d,		0x21, 0
	.dw 0xea40, 0xc02d,	0xea7f, 0xc02d,		0x21, 0
	.dw 0xeac0, 0xc02d,	0xeaff, 0xc02d,		0x21, 0
	.dw 0xeb40, 0xc02d,	0xeb7f, 0xc02d,		0x21, 0
	.dw 0xebc0, 0xc02d,	0xebff, 0xc02d,		0x21, 0
	.dw 0xec40, 0xc02d,	0xec7f, 0xc02d,		0x21, 0
	.dw 0xecc0, 0xc02d,	0xecff, 0xc02d,		0x21, 0
	.dw 0xed40, 0xc02d,	0xed7f, 0xc02d,		0x21, 0
	.dw 0xedc0, 0xc02d,	0xedff, 0xc02d,		0x21, 0
	.dw 0xee40, 0xc02d,	0xee7f, 0xc02d,		0x21, 0
	.dw 0xeec0, 0xc02d,	0xeeff, 0xc02d,		0x21, 0
	.dw 0xef40, 0xc02d,	0xef7f, 0xc02d,		0x21, 0
	.dw 0xefc0, 0xc02d,	0xefff, 0xc02d,		0x21, 0
	.dw 0xf040, 0xc02d,	0xf07f, 0xc02d,		0x21, 0
	.dw 0xf0c0, 0xc02d,	0xf0ff, 0xc02d,		0x21, 0
	.dw 0xf140, 0xc02d,	0xf17f, 0xc02d,		0x21, 0
	.dw 0xf1c0, 0xc02d,	0xf1ff, 0xc02d,		0x21, 0
	.dw 0xf240, 0xc02d,	0xf27f, 0xc02d,		0x21, 0
	.dw 0xf2c0, 0xc02d,	0xf2ff, 0xc02d,		0x21, 0
	.dw 0xf340, 0xc02d,	0xf37f, 0xc02d,		0x21, 0
	.dw 0xf3c0, 0xc02d,	0xf3ff, 0xc02d,		0x21, 0
	.dw 0xf440, 0xc02d,	0xf47f, 0xc02d,		0x21, 0
	.dw 0xf4c0, 0xc02d,	0xf4ff, 0xc02d,		0x21, 0
	.dw 0xf540, 0xc02d,	0xf57f, 0xc02d,		0x21, 0
	.dw 0xf5c0, 0xc02d,	0xf5ff, 0xc02d,		0x21, 0
	.dw 0xf640, 0xc02d,	0xf67f, 0xc02d,		0x21, 0
	.dw 0xf6c0, 0xc02d,	0xf6ff, 0xc02d,		0x21, 0
	.dw 0xf740, 0xc02d,	0xf77f, 0xc02d,		0x21, 0
	.dw 0xf7c0, 0xc02d,	0xf7ff, 0xc02d,		0x21, 0
	.dw 0xf840, 0xc02d,	0xf87f, 0xc02d,		0x21, 0
	.dw 0xf8c0, 0xc02d,	0xf8ff, 0xc02d,		0x21, 0
	.dw 0xf940, 0xc02d,	0xf97f, 0xc02d,		0x21, 0
	.dw 0xf9c0, 0xc02d,	0xffff, 0xc02d,		0x21, 0
	.dw 0x0040, 0xc02e,	0x007f, 0xc02e,		0x21, 0
	.dw 0x00c0, 0xc02e,	0x00ff, 0xc02e,		0x21, 0
	.dw 0x0140, 0xc02e,	0x017f, 0xc02e,		0x21, 0
	.dw 0x01c0, 0xc02e,	0x01ff, 0xc02e,		0x21, 0
	.dw 0x0240, 0xc02e,	0x027f, 0xc02e,		0x21, 0
	.dw 0x02c0, 0xc02e,	0x02ff, 0xc02e,		0x21, 0
	.dw 0x0340, 0xc02e,	0x037f, 0xc02e,		0x21, 0
	.dw 0x03c0, 0xc02e,	0x03ff, 0xc02e,		0x21, 0
	.dw 0x0440, 0xc02e,	0x047f, 0xc02e,		0x21, 0
	.dw 0x04c0, 0xc02e,	0x04ff, 0xc02e,		0x21, 0
	.dw 0x0540, 0xc02e,	0x057f, 0xc02e,		0x21, 0
	.dw 0x05c0, 0xc02e,	0x05ff, 0xc02e,		0x21, 0
	.dw 0x0640, 0xc02e,	0x067f, 0xc02e,		0x21, 0
	.dw 0x06c0, 0xc02e,	0x06ff, 0xc02e,		0x21, 0
	.dw 0x0740, 0xc02e,	0x077f, 0xc02e,		0x21, 0
	.dw 0x07c0, 0xc02e,	0x07ff, 0xc02e,		0x21, 0
	.dw 0x0840, 0xc02e,	0x087f, 0xc02e,		0x21, 0
	.dw 0x08c0, 0xc02e,	0x08ff, 0xc02e,		0x21, 0
	.dw 0x0940, 0xc02e,	0x097f, 0xc02e,		0x21, 0
	.dw 0x09c0, 0xc02e,	0x09ff, 0xc02e,		0x21, 0
	.dw 0x0a40, 0xc02e,	0x0a7f, 0xc02e,		0x21, 0
	.dw 0x0ac0, 0xc02e,	0x0aff, 0xc02e,		0x21, 0
	.dw 0x0b40, 0xc02e,	0x0b7f, 0xc02e,		0x21, 0
	.dw 0x0bc0, 0xc02e,	0x0bff, 0xc02e,		0x21, 0
	.dw 0x0c40, 0xc02e,	0x0c7f, 0xc02e,		0x21, 0
	.dw 0x0cc0, 0xc02e,	0x0cff, 0xc02e,		0x21, 0
	.dw 0x0d40, 0xc02e,	0x0d7f, 0xc02e,		0x21, 0
	.dw 0x0dc0, 0xc02e,	0x0dff, 0xc02e,		0x21, 0
	.dw 0x0e40, 0xc02e,	0x0e7f, 0xc02e,		0x21, 0
	.dw 0x0ec0, 0xc02e,	0x0eff, 0xc02e,		0x21, 0
	.dw 0x0f40, 0xc02e,	0x0f7f, 0xc02e,		0x21, 0
	.dw 0x0fc0, 0xc02e,	0x0fff, 0xc02e,		0x21, 0
	.dw 0x1040, 0xc02e,	0x107f, 0xc02e,		0x21, 0
	.dw 0x10c0, 0xc02e,	0x10ff, 0xc02e,		0x21, 0
	.dw 0x1140, 0xc02e,	0x117f, 0xc02e,		0x21, 0
	.dw 0x11c0, 0xc02e,	0x11ff, 0xc02e,		0x21, 0
	.dw 0x1240, 0xc02e,	0x127f, 0xc02e,		0x21, 0
	.dw 0x12c0, 0xc02e,	0x12ff, 0xc02e,		0x21, 0
	.dw 0x1340, 0xc02e,	0x137f, 0xc02e,		0x21, 0
	.dw 0x13c0, 0xc02e,	0x13ff, 0xc02e,		0x21, 0
	.dw 0x1440, 0xc02e,	0x147f, 0xc02e,		0x21, 0
	.dw 0x14c0, 0xc02e,	0x14ff, 0xc02e,		0x21, 0
	.dw 0x1540, 0xc02e,	0x157f, 0xc02e,		0x21, 0
	.dw 0x15c0, 0xc02e,	0x15ff, 0xc02e,		0x21, 0
	.dw 0x1640, 0xc02e,	0x167f, 0xc02e,		0x21, 0
	.dw 0x16c0, 0xc02e,	0x16ff, 0xc02e,		0x21, 0
	.dw 0x1740, 0xc02e,	0x177f, 0xc02e,		0x21, 0
	.dw 0x17c0, 0xc02e,	0x17ff, 0xc02e,		0x21, 0
	.dw 0x1840, 0xc02e,	0x187f, 0xc02e,		0x21, 0
	.dw 0x18c0, 0xc02e,	0x18ff, 0xc02e,		0x21, 0
	.dw 0x1940, 0xc02e,	0x197f, 0xc02e,		0x21, 0
	.dw 0x19c0, 0xc02e,	0x1fff, 0xc02e,		0x21, 0
	.dw 0x2040, 0xc02e,	0x207f, 0xc02e,		0x21, 0
	.dw 0x20c0, 0xc02e,	0x20ff, 0xc02e,		0x21, 0
	.dw 0x2140, 0xc02e,	0x217f, 0xc02e,		0x21, 0
	.dw 0x21c0, 0xc02e,	0x21ff, 0xc02e,		0x21, 0
	.dw 0x2240, 0xc02e,	0x227f, 0xc02e,		0x21, 0
	.dw 0x22c0, 0xc02e,	0x22ff, 0xc02e,		0x21, 0
	.dw 0x2340, 0xc02e,	0x237f, 0xc02e,		0x21, 0
	.dw 0x23c0, 0xc02e,	0x23ff, 0xc02e,		0x21, 0
	.dw 0x2440, 0xc02e,	0x247f, 0xc02e,		0x21, 0
	.dw 0x24c0, 0xc02e,	0x24ff, 0xc02e,		0x21, 0
	.dw 0x2540, 0xc02e,	0x257f, 0xc02e,		0x21, 0
	.dw 0x25c0, 0xc02e,	0x25ff, 0xc02e,		0x21, 0
	.dw 0x2640, 0xc02e,	0x267f, 0xc02e,		0x21, 0
	.dw 0x26c0, 0xc02e,	0x26ff, 0xc02e,		0x21, 0
	.dw 0x2740, 0xc02e,	0x277f, 0xc02e,		0x21, 0
	.dw 0x27c0, 0xc02e,	0x27ff, 0xc02e,		0x21, 0
	.dw 0x2840, 0xc02e,	0x287f, 0xc02e,		0x21, 0
	.dw 0x28c0, 0xc02e,	0x28ff, 0xc02e,		0x21, 0
	.dw 0x2940, 0xc02e,	0x297f, 0xc02e,		0x21, 0
	.dw 0x29c0, 0xc02e,	0x29ff, 0xc02e,		0x21, 0
	.dw 0x2a40, 0xc02e,	0x2a7f, 0xc02e,		0x21, 0
	.dw 0x2ac0, 0xc02e,	0x2aff, 0xc02e,		0x21, 0
	.dw 0x2b40, 0xc02e,	0x2b7f, 0xc02e,		0x21, 0
	.dw 0x2bc0, 0xc02e,	0x2bff, 0xc02e,		0x21, 0
	.dw 0x2c40, 0xc02e,	0x2c7f, 0xc02e,		0x21, 0
	.dw 0x2cc0, 0xc02e,	0x2cff, 0xc02e,		0x21, 0
	.dw 0x2d40, 0xc02e,	0x2d7f, 0xc02e,		0x21, 0
	.dw 0x2dc0, 0xc02e,	0x2dff, 0xc02e,		0x21, 0
	.dw 0x2e40, 0xc02e,	0x2e7f, 0xc02e,		0x21, 0
	.dw 0x2ec0, 0xc02e,	0x2eff, 0xc02e,		0x21, 0
	.dw 0x2f40, 0xc02e,	0x2f7f, 0xc02e,		0x21, 0
	.dw 0x2fc0, 0xc02e,	0x2fff, 0xc02e,		0x21, 0
	.dw 0x3040, 0xc02e,	0x307f, 0xc02e,		0x21, 0
	.dw 0x30c0, 0xc02e,	0x30ff, 0xc02e,		0x21, 0
	.dw 0x3140, 0xc02e,	0x317f, 0xc02e,		0x21, 0
	.dw 0x31c0, 0xc02e,	0x31ff, 0xc02e,		0x21, 0
	.dw 0x3240, 0xc02e,	0x327f, 0xc02e,		0x21, 0
	.dw 0x32c0, 0xc02e,	0x32ff, 0xc02e,		0x21, 0
	.dw 0x3340, 0xc02e,	0x337f, 0xc02e,		0x21, 0
	.dw 0x33c0, 0xc02e,	0x33ff, 0xc02e,		0x21, 0
	.dw 0x3440, 0xc02e,	0x347f, 0xc02e,		0x21, 0
	.dw 0x34c0, 0xc02e,	0x34ff, 0xc02e,		0x21, 0
	.dw 0x3540, 0xc02e,	0x357f, 0xc02e,		0x21, 0
	.dw 0x35c0, 0xc02e,	0x35ff, 0xc02e,		0x21, 0
	.dw 0x3640, 0xc02e,	0x367f, 0xc02e,		0x21, 0
	.dw 0x36c0, 0xc02e,	0x36ff, 0xc02e,		0x21, 0
	.dw 0x3740, 0xc02e,	0x377f, 0xc02e,		0x21, 0
	.dw 0x37c0, 0xc02e,	0x37ff, 0xc02e,		0x21, 0
	.dw 0x3840, 0xc02e,	0x387f, 0xc02e,		0x21, 0
	.dw 0x38c0, 0xc02e,	0x38ff, 0xc02e,		0x21, 0
	.dw 0x3940, 0xc02e,	0x397f, 0xc02e,		0x21, 0
	.dw 0x39c0, 0xc02e,	0x3fff, 0xc02e,		0x21, 0
	.dw 0x4040, 0xc02e,	0x407f, 0xc02e,		0x21, 0
	.dw 0x40c0, 0xc02e,	0x40ff, 0xc02e,		0x21, 0
	.dw 0x4140, 0xc02e,	0x417f, 0xc02e,		0x21, 0
	.dw 0x41c0, 0xc02e,	0x41ff, 0xc02e,		0x21, 0
	.dw 0x4240, 0xc02e,	0x427f, 0xc02e,		0x21, 0
	.dw 0x42c0, 0xc02e,	0x42ff, 0xc02e,		0x21, 0
	.dw 0x4340, 0xc02e,	0x437f, 0xc02e,		0x21, 0
	.dw 0x43c0, 0xc02e,	0x43ff, 0xc02e,		0x21, 0
	.dw 0x4440, 0xc02e,	0x447f, 0xc02e,		0x21, 0
	.dw 0x44c0, 0xc02e,	0x44ff, 0xc02e,		0x21, 0
	.dw 0x4540, 0xc02e,	0x457f, 0xc02e,		0x21, 0
	.dw 0x45c0, 0xc02e,	0x45ff, 0xc02e,		0x21, 0
	.dw 0x4640, 0xc02e,	0x467f, 0xc02e,		0x21, 0
	.dw 0x46c0, 0xc02e,	0x46ff, 0xc02e,		0x21, 0
	.dw 0x4740, 0xc02e,	0x477f, 0xc02e,		0x21, 0
	.dw 0x47c0, 0xc02e,	0x47ff, 0xc02e,		0x21, 0
	.dw 0x4840, 0xc02e,	0x487f, 0xc02e,		0x21, 0
	.dw 0x48c0, 0xc02e,	0x48ff, 0xc02e,		0x21, 0
	.dw 0x4940, 0xc02e,	0x497f, 0xc02e,		0x21, 0
	.dw 0x49c0, 0xc02e,	0x49ff, 0xc02e,		0x21, 0
	.dw 0x4a40, 0xc02e,	0x4a7f, 0xc02e,		0x21, 0
	.dw 0x4ac0, 0xc02e,	0x4aff, 0xc02e,		0x21, 0
	.dw 0x4b40, 0xc02e,	0x4b7f, 0xc02e,		0x21, 0
	.dw 0x4bc0, 0xc02e,	0x4bff, 0xc02e,		0x21, 0
	.dw 0x4c40, 0xc02e,	0x4c7f, 0xc02e,		0x21, 0
	.dw 0x4cc0, 0xc02e,	0x4cff, 0xc02e,		0x21, 0
	.dw 0x4d40, 0xc02e,	0x4d7f, 0xc02e,		0x21, 0
	.dw 0x4dc0, 0xc02e,	0x4dff, 0xc02e,		0x21, 0
	.dw 0x4e40, 0xc02e,	0x4e7f, 0xc02e,		0x21, 0
	.dw 0x4ec0, 0xc02e,	0x4eff, 0xc02e,		0x21, 0
	.dw 0x4f40, 0xc02e,	0x4f7f, 0xc02e,		0x21, 0
	.dw 0x4fc0, 0xc02e,	0x4fff, 0xc02e,		0x21, 0
	.dw 0x5040, 0xc02e,	0x507f, 0xc02e,		0x21, 0
	.dw 0x50c0, 0xc02e,	0x50ff, 0xc02e,		0x21, 0
	.dw 0x5140, 0xc02e,	0x517f, 0xc02e,		0x21, 0
	.dw 0x51c0, 0xc02e,	0x51ff, 0xc02e,		0x21, 0
	.dw 0x5240, 0xc02e,	0x527f, 0xc02e,		0x21, 0
	.dw 0x52c0, 0xc02e,	0x52ff, 0xc02e,		0x21, 0
	.dw 0x5340, 0xc02e,	0x537f, 0xc02e,		0x21, 0
	.dw 0x53c0, 0xc02e,	0x53ff, 0xc02e,		0x21, 0
	.dw 0x5440, 0xc02e,	0x547f, 0xc02e,		0x21, 0
	.dw 0x54c0, 0xc02e,	0x54ff, 0xc02e,		0x21, 0
	.dw 0x5540, 0xc02e,	0x557f, 0xc02e,		0x21, 0
	.dw 0x55c0, 0xc02e,	0x55ff, 0xc02e,		0x21, 0
	.dw 0x5640, 0xc02e,	0x567f, 0xc02e,		0x21, 0
	.dw 0x56c0, 0xc02e,	0x56ff, 0xc02e,		0x21, 0
	.dw 0x5740, 0xc02e,	0x577f, 0xc02e,		0x21, 0
	.dw 0x57c0, 0xc02e,	0x57ff, 0xc02e,		0x21, 0
	.dw 0x5840, 0xc02e,	0x587f, 0xc02e,		0x21, 0
	.dw 0x58c0, 0xc02e,	0x58ff, 0xc02e,		0x21, 0
	.dw 0x5940, 0xc02e,	0x597f, 0xc02e,		0x21, 0
	.dw 0x59c0, 0xc02e,	0x5fff, 0xc02e,		0x21, 0
	.dw 0x6040, 0xc02e,	0x607f, 0xc02e,		0x21, 0
	.dw 0x60c0, 0xc02e,	0x60ff, 0xc02e,		0x21, 0
	.dw 0x6140, 0xc02e,	0x617f, 0xc02e,		0x21, 0
	.dw 0x61c0, 0xc02e,	0x61ff, 0xc02e,		0x21, 0
	.dw 0x6240, 0xc02e,	0x627f, 0xc02e,		0x21, 0
	.dw 0x62c0, 0xc02e,	0x62ff, 0xc02e,		0x21, 0
	.dw 0x6340, 0xc02e,	0x637f, 0xc02e,		0x21, 0
	.dw 0x63c0, 0xc02e,	0x63ff, 0xc02e,		0x21, 0
	.dw 0x6440, 0xc02e,	0x647f, 0xc02e,		0x21, 0
	.dw 0x64c0, 0xc02e,	0x64ff, 0xc02e,		0x21, 0
	.dw 0x6540, 0xc02e,	0x657f, 0xc02e,		0x21, 0
	.dw 0x65c0, 0xc02e,	0x65ff, 0xc02e,		0x21, 0
	.dw 0x6640, 0xc02e,	0x667f, 0xc02e,		0x21, 0
	.dw 0x66c0, 0xc02e,	0x66ff, 0xc02e,		0x21, 0
	.dw 0x6740, 0xc02e,	0x677f, 0xc02e,		0x21, 0
	.dw 0x67c0, 0xc02e,	0x67ff, 0xc02e,		0x21, 0
	.dw 0x6840, 0xc02e,	0x687f, 0xc02e,		0x21, 0
	.dw 0x68c0, 0xc02e,	0x68ff, 0xc02e,		0x21, 0
	.dw 0x6940, 0xc02e,	0x697f, 0xc02e,		0x21, 0
	.dw 0x69c0, 0xc02e,	0x69ff, 0xc02e,		0x21, 0
	.dw 0x6a40, 0xc02e,	0x6a7f, 0xc02e,		0x21, 0
	.dw 0x6ac0, 0xc02e,	0x6aff, 0xc02e,		0x21, 0
	.dw 0x6b40, 0xc02e,	0x6b7f, 0xc02e,		0x21, 0
	.dw 0x6bc0, 0xc02e,	0x6bff, 0xc02e,		0x21, 0
	.dw 0x6c40, 0xc02e,	0x6c7f, 0xc02e,		0x21, 0
	.dw 0x6cc0, 0xc02e,	0x6cff, 0xc02e,		0x21, 0
	.dw 0x6d40, 0xc02e,	0x6d7f, 0xc02e,		0x21, 0
	.dw 0x6dc0, 0xc02e,	0x6dff, 0xc02e,		0x21, 0
	.dw 0x6e40, 0xc02e,	0x6e7f, 0xc02e,		0x21, 0
	.dw 0x6ec0, 0xc02e,	0x6eff, 0xc02e,		0x21, 0
	.dw 0x6f40, 0xc02e,	0x6f7f, 0xc02e,		0x21, 0
	.dw 0x6fc0, 0xc02e,	0x6fff, 0xc02e,		0x21, 0
	.dw 0x7040, 0xc02e,	0x707f, 0xc02e,		0x21, 0
	.dw 0x70c0, 0xc02e,	0x70ff, 0xc02e,		0x21, 0
	.dw 0x7140, 0xc02e,	0x717f, 0xc02e,		0x21, 0
	.dw 0x71c0, 0xc02e,	0x71ff, 0xc02e,		0x21, 0
	.dw 0x7240, 0xc02e,	0x727f, 0xc02e,		0x21, 0
	.dw 0x72c0, 0xc02e,	0x72ff, 0xc02e,		0x21, 0
	.dw 0x7340, 0xc02e,	0x737f, 0xc02e,		0x21, 0
	.dw 0x73c0, 0xc02e,	0x73ff, 0xc02e,		0x21, 0
	.dw 0x7440, 0xc02e,	0x747f, 0xc02e,		0x21, 0
	.dw 0x74c0, 0xc02e,	0x74ff, 0xc02e,		0x21, 0
	.dw 0x7540, 0xc02e,	0x757f, 0xc02e,		0x21, 0
	.dw 0x75c0, 0xc02e,	0x75ff, 0xc02e,		0x21, 0
	.dw 0x7640, 0xc02e,	0x767f, 0xc02e,		0x21, 0
	.dw 0x76c0, 0xc02e,	0x76ff, 0xc02e,		0x21, 0
	.dw 0x7740, 0xc02e,	0x777f, 0xc02e,		0x21, 0
	.dw 0x77c0, 0xc02e,	0x77ff, 0xc02e,		0x21, 0
	.dw 0x7840, 0xc02e,	0x787f, 0xc02e,		0x21, 0
	.dw 0x78c0, 0xc02e,	0x78ff, 0xc02e,		0x21, 0
	.dw 0x7940, 0xc02e,	0x797f, 0xc02e,		0x21, 0
	.dw 0x79c0, 0xc02e,	0x7fff, 0xc02e,		0x21, 0
	.dw 0x8040, 0xc02e,	0x807f, 0xc02e,		0x21, 0
	.dw 0x80c0, 0xc02e,	0x80ff, 0xc02e,		0x21, 0
	.dw 0x8140, 0xc02e,	0x817f, 0xc02e,		0x21, 0
	.dw 0x81c0, 0xc02e,	0x81ff, 0xc02e,		0x21, 0
	.dw 0x8240, 0xc02e,	0x827f, 0xc02e,		0x21, 0
	.dw 0x82c0, 0xc02e,	0x82ff, 0xc02e,		0x21, 0
	.dw 0x8340, 0xc02e,	0x837f, 0xc02e,		0x21, 0
	.dw 0x83c0, 0xc02e,	0x83ff, 0xc02e,		0x21, 0
	.dw 0x8440, 0xc02e,	0x847f, 0xc02e,		0x21, 0
	.dw 0x84c0, 0xc02e,	0x84ff, 0xc02e,		0x21, 0
	.dw 0x8540, 0xc02e,	0x857f, 0xc02e,		0x21, 0
	.dw 0x85c0, 0xc02e,	0x85ff, 0xc02e,		0x21, 0
	.dw 0x8640, 0xc02e,	0x867f, 0xc02e,		0x21, 0
	.dw 0x86c0, 0xc02e,	0x86ff, 0xc02e,		0x21, 0
	.dw 0x8740, 0xc02e,	0x877f, 0xc02e,		0x21, 0
	.dw 0x87c0, 0xc02e,	0x87ff, 0xc02e,		0x21, 0
	.dw 0x8840, 0xc02e,	0x887f, 0xc02e,		0x21, 0
	.dw 0x88c0, 0xc02e,	0x88ff, 0xc02e,		0x21, 0
	.dw 0x8940, 0xc02e,	0x897f, 0xc02e,		0x21, 0
	.dw 0x89c0, 0xc02e,	0x89ff, 0xc02e,		0x21, 0
	.dw 0x8a40, 0xc02e,	0x8a7f, 0xc02e,		0x21, 0
	.dw 0x8ac0, 0xc02e,	0x8aff, 0xc02e,		0x21, 0
	.dw 0x8b40, 0xc02e,	0x8b7f, 0xc02e,		0x21, 0
	.dw 0x8bc0, 0xc02e,	0x8bff, 0xc02e,		0x21, 0
	.dw 0x8c40, 0xc02e,	0x8c7f, 0xc02e,		0x21, 0
	.dw 0x8cc0, 0xc02e,	0x8cff, 0xc02e,		0x21, 0
	.dw 0x8d40, 0xc02e,	0x8d7f, 0xc02e,		0x21, 0
	.dw 0x8dc0, 0xc02e,	0x8dff, 0xc02e,		0x21, 0
	.dw 0x8e40, 0xc02e,	0x8e7f, 0xc02e,		0x21, 0
	.dw 0x8ec0, 0xc02e,	0x8eff, 0xc02e,		0x21, 0
	.dw 0x8f40, 0xc02e,	0x8f7f, 0xc02e,		0x21, 0
	.dw 0x8fc0, 0xc02e,	0x8fff, 0xc02e,		0x21, 0
	.dw 0x9040, 0xc02e,	0x907f, 0xc02e,		0x21, 0
	.dw 0x90c0, 0xc02e,	0x90ff, 0xc02e,		0x21, 0
	.dw 0x9140, 0xc02e,	0x917f, 0xc02e,		0x21, 0
	.dw 0x91c0, 0xc02e,	0x91ff, 0xc02e,		0x21, 0
	.dw 0x9240, 0xc02e,	0x927f, 0xc02e,		0x21, 0
	.dw 0x92c0, 0xc02e,	0x92ff, 0xc02e,		0x21, 0
	.dw 0x9340, 0xc02e,	0x937f, 0xc02e,		0x21, 0
	.dw 0x93c0, 0xc02e,	0x93ff, 0xc02e,		0x21, 0
	.dw 0x9440, 0xc02e,	0x947f, 0xc02e,		0x21, 0
	.dw 0x94c0, 0xc02e,	0x94ff, 0xc02e,		0x21, 0
	.dw 0x9540, 0xc02e,	0x957f, 0xc02e,		0x21, 0
	.dw 0x95c0, 0xc02e,	0x95ff, 0xc02e,		0x21, 0
	.dw 0x9640, 0xc02e,	0x967f, 0xc02e,		0x21, 0
	.dw 0x96c0, 0xc02e,	0x96ff, 0xc02e,		0x21, 0
	.dw 0x9740, 0xc02e,	0x977f, 0xc02e,		0x21, 0
	.dw 0x97c0, 0xc02e,	0x97ff, 0xc02e,		0x21, 0
	.dw 0x9840, 0xc02e,	0x987f, 0xc02e,		0x21, 0
	.dw 0x98c0, 0xc02e,	0x98ff, 0xc02e,		0x21, 0
	.dw 0x9940, 0xc02e,	0x997f, 0xc02e,		0x21, 0
	.dw 0x99c0, 0xc02e,	0x9fff, 0xc02e,		0x21, 0
	.dw 0xa040, 0xc02e,	0xa07f, 0xc02e,		0x21, 0
	.dw 0xa0c0, 0xc02e,	0xa0ff, 0xc02e,		0x21, 0
	.dw 0xa140, 0xc02e,	0xa17f, 0xc02e,		0x21, 0
	.dw 0xa1c0, 0xc02e,	0xa1ff, 0xc02e,		0x21, 0
	.dw 0xa240, 0xc02e,	0xa27f, 0xc02e,		0x21, 0
	.dw 0xa2c0, 0xc02e,	0xa2ff, 0xc02e,		0x21, 0
	.dw 0xa340, 0xc02e,	0xa37f, 0xc02e,		0x21, 0
	.dw 0xa3c0, 0xc02e,	0xa3ff, 0xc02e,		0x21, 0
	.dw 0xa440, 0xc02e,	0xa47f, 0xc02e,		0x21, 0
	.dw 0xa4c0, 0xc02e,	0xa4ff, 0xc02e,		0x21, 0
	.dw 0xa540, 0xc02e,	0xa57f, 0xc02e,		0x21, 0
	.dw 0xa5c0, 0xc02e,	0xa5ff, 0xc02e,		0x21, 0
	.dw 0xa640, 0xc02e,	0xa67f, 0xc02e,		0x21, 0
	.dw 0xa6c0, 0xc02e,	0xa6ff, 0xc02e,		0x21, 0
	.dw 0xa740, 0xc02e,	0xa77f, 0xc02e,		0x21, 0
	.dw 0xa7c0, 0xc02e,	0xa7ff, 0xc02e,		0x21, 0
	.dw 0xa840, 0xc02e,	0xa87f, 0xc02e,		0x21, 0
	.dw 0xa8c0, 0xc02e,	0xa8ff, 0xc02e,		0x21, 0
	.dw 0xa940, 0xc02e,	0xa97f, 0xc02e,		0x21, 0
	.dw 0xa9c0, 0xc02e,	0xa9ff, 0xc02e,		0x21, 0
	.dw 0xaa40, 0xc02e,	0xaa7f, 0xc02e,		0x21, 0
	.dw 0xaac0, 0xc02e,	0xaaff, 0xc02e,		0x21, 0
	.dw 0xab40, 0xc02e,	0xab7f, 0xc02e,		0x21, 0
	.dw 0xabc0, 0xc02e,	0xabff, 0xc02e,		0x21, 0
	.dw 0xac40, 0xc02e,	0xac7f, 0xc02e,		0x21, 0
	.dw 0xacc0, 0xc02e,	0xacff, 0xc02e,		0x21, 0
	.dw 0xad40, 0xc02e,	0xad7f, 0xc02e,		0x21, 0
	.dw 0xadc0, 0xc02e,	0xadff, 0xc02e,		0x21, 0
	.dw 0xae40, 0xc02e,	0xae7f, 0xc02e,		0x21, 0
	.dw 0xaec0, 0xc02e,	0xaeff, 0xc02e,		0x21, 0
	.dw 0xaf40, 0xc02e,	0xaf7f, 0xc02e,		0x21, 0
	.dw 0xafc0, 0xc02e,	0xafff, 0xc02e,		0x21, 0
	.dw 0xb040, 0xc02e,	0xb07f, 0xc02e,		0x21, 0
	.dw 0xb0c0, 0xc02e,	0xb0ff, 0xc02e,		0x21, 0
	.dw 0xb140, 0xc02e,	0xb17f, 0xc02e,		0x21, 0
	.dw 0xb1c0, 0xc02e,	0xb1ff, 0xc02e,		0x21, 0
	.dw 0xb240, 0xc02e,	0xb27f, 0xc02e,		0x21, 0
	.dw 0xb2c0, 0xc02e,	0xb2ff, 0xc02e,		0x21, 0
	.dw 0xb340, 0xc02e,	0xb37f, 0xc02e,		0x21, 0
	.dw 0xb3c0, 0xc02e,	0xb3ff, 0xc02e,		0x21, 0
	.dw 0xb440, 0xc02e,	0xb47f, 0xc02e,		0x21, 0
	.dw 0xb4c0, 0xc02e,	0xb4ff, 0xc02e,		0x21, 0
	.dw 0xb540, 0xc02e,	0xb57f, 0xc02e,		0x21, 0
	.dw 0xb5c0, 0xc02e,	0xb5ff, 0xc02e,		0x21, 0
	.dw 0xb640, 0xc02e,	0xb67f, 0xc02e,		0x21, 0
	.dw 0xb6c0, 0xc02e,	0xb6ff, 0xc02e,		0x21, 0
	.dw 0xb740, 0xc02e,	0xb77f, 0xc02e,		0x21, 0
	.dw 0xb7c0, 0xc02e,	0xb7ff, 0xc02e,		0x21, 0
	.dw 0xb840, 0xc02e,	0xb87f, 0xc02e,		0x21, 0
	.dw 0xb8c0, 0xc02e,	0xb8ff, 0xc02e,		0x21, 0
	.dw 0xb940, 0xc02e,	0xb97f, 0xc02e,		0x21, 0
	.dw 0xb9c0, 0xc02e,	0xbfff, 0xc02e,		0x21, 0
	.dw 0xc040, 0xc02e,	0xc07f, 0xc02e,		0x21, 0
	.dw 0xc0c0, 0xc02e,	0xc0ff, 0xc02e,		0x21, 0
	.dw 0xc140, 0xc02e,	0xc17f, 0xc02e,		0x21, 0
	.dw 0xc1c0, 0xc02e,	0xc1ff, 0xc02e,		0x21, 0
	.dw 0xc240, 0xc02e,	0xc27f, 0xc02e,		0x21, 0
	.dw 0xc2c0, 0xc02e,	0xc2ff, 0xc02e,		0x21, 0
	.dw 0xc340, 0xc02e,	0xc37f, 0xc02e,		0x21, 0
	.dw 0xc3c0, 0xc02e,	0xc3ff, 0xc02e,		0x21, 0
	.dw 0xc440, 0xc02e,	0xc47f, 0xc02e,		0x21, 0
	.dw 0xc4c0, 0xc02e,	0xc4ff, 0xc02e,		0x21, 0
	.dw 0xc540, 0xc02e,	0xc57f, 0xc02e,		0x21, 0
	.dw 0xc5c0, 0xc02e,	0xc5ff, 0xc02e,		0x21, 0
	.dw 0xc640, 0xc02e,	0xc67f, 0xc02e,		0x21, 0
	.dw 0xc6c0, 0xc02e,	0xc6ff, 0xc02e,		0x21, 0
	.dw 0xc740, 0xc02e,	0xc77f, 0xc02e,		0x21, 0
	.dw 0xc7c0, 0xc02e,	0xc7ff, 0xc02e,		0x21, 0
	.dw 0xc840, 0xc02e,	0xc87f, 0xc02e,		0x21, 0
	.dw 0xc8c0, 0xc02e,	0xc8ff, 0xc02e,		0x21, 0
	.dw 0xc940, 0xc02e,	0xc97f, 0xc02e,		0x21, 0
	.dw 0xc9c0, 0xc02e,	0xc9ff, 0xc02e,		0x21, 0
	.dw 0xca40, 0xc02e,	0xca7f, 0xc02e,		0x21, 0
	.dw 0xcac0, 0xc02e,	0xcaff, 0xc02e,		0x21, 0
	.dw 0xcb40, 0xc02e,	0xcb7f, 0xc02e,		0x21, 0
	.dw 0xcbc0, 0xc02e,	0xcbff, 0xc02e,		0x21, 0
	.dw 0xcc40, 0xc02e,	0xcc7f, 0xc02e,		0x21, 0
	.dw 0xccc0, 0xc02e,	0xccff, 0xc02e,		0x21, 0
	.dw 0xcd40, 0xc02e,	0xcd7f, 0xc02e,		0x21, 0
	.dw 0xcdc0, 0xc02e,	0xcdff, 0xc02e,		0x21, 0
	.dw 0xce40, 0xc02e,	0xce7f, 0xc02e,		0x21, 0
	.dw 0xcec0, 0xc02e,	0xceff, 0xc02e,		0x21, 0
	.dw 0xcf40, 0xc02e,	0xcf7f, 0xc02e,		0x21, 0
	.dw 0xcfc0, 0xc02e,	0xcfff, 0xc02e,		0x21, 0
	.dw 0xd040, 0xc02e,	0xd07f, 0xc02e,		0x21, 0
	.dw 0xd0c0, 0xc02e,	0xd0ff, 0xc02e,		0x21, 0
	.dw 0xd140, 0xc02e,	0xd17f, 0xc02e,		0x21, 0
	.dw 0xd1c0, 0xc02e,	0xd1ff, 0xc02e,		0x21, 0
	.dw 0xd240, 0xc02e,	0xd27f, 0xc02e,		0x21, 0
	.dw 0xd2c0, 0xc02e,	0xd2ff, 0xc02e,		0x21, 0
	.dw 0xd340, 0xc02e,	0xd37f, 0xc02e,		0x21, 0
	.dw 0xd3c0, 0xc02e,	0xd3ff, 0xc02e,		0x21, 0
	.dw 0xd440, 0xc02e,	0xd47f, 0xc02e,		0x21, 0
	.dw 0xd4c0, 0xc02e,	0xd4ff, 0xc02e,		0x21, 0
	.dw 0xd540, 0xc02e,	0xd57f, 0xc02e,		0x21, 0
	.dw 0xd5c0, 0xc02e,	0xd5ff, 0xc02e,		0x21, 0
	.dw 0xd640, 0xc02e,	0xd67f, 0xc02e,		0x21, 0
	.dw 0xd6c0, 0xc02e,	0xd6ff, 0xc02e,		0x21, 0
	.dw 0xd740, 0xc02e,	0xd77f, 0xc02e,		0x21, 0
	.dw 0xd7c0, 0xc02e,	0xd7ff, 0xc02e,		0x21, 0
	.dw 0xd840, 0xc02e,	0xd87f, 0xc02e,		0x21, 0
	.dw 0xd8c0, 0xc02e,	0xd8ff, 0xc02e,		0x21, 0
	.dw 0xd940, 0xc02e,	0xd97f, 0xc02e,		0x21, 0
	.dw 0xd9c0, 0xc02e,	0xdfff, 0xc02e,		0x21, 0
	.dw 0xe040, 0xc02e,	0xe07f, 0xc02e,		0x21, 0
	.dw 0xe0c0, 0xc02e,	0xe0ff, 0xc02e,		0x21, 0
	.dw 0xe140, 0xc02e,	0xe17f, 0xc02e,		0x21, 0
	.dw 0xe1c0, 0xc02e,	0xe1ff, 0xc02e,		0x21, 0
	.dw 0xe240, 0xc02e,	0xe27f, 0xc02e,		0x21, 0
	.dw 0xe2c0, 0xc02e,	0xe2ff, 0xc02e,		0x21, 0
	.dw 0xe340, 0xc02e,	0xe37f, 0xc02e,		0x21, 0
	.dw 0xe3c0, 0xc02e,	0xe3ff, 0xc02e,		0x21, 0
	.dw 0xe440, 0xc02e,	0xe47f, 0xc02e,		0x21, 0
	.dw 0xe4c0, 0xc02e,	0xe4ff, 0xc02e,		0x21, 0
	.dw 0xe540, 0xc02e,	0xe57f, 0xc02e,		0x21, 0
	.dw 0xe5c0, 0xc02e,	0xe5ff, 0xc02e,		0x21, 0
	.dw 0xe640, 0xc02e,	0xe67f, 0xc02e,		0x21, 0
	.dw 0xe6c0, 0xc02e,	0xe6ff, 0xc02e,		0x21, 0
	.dw 0xe740, 0xc02e,	0xe77f, 0xc02e,		0x21, 0
	.dw 0xe7c0, 0xc02e,	0xe7ff, 0xc02e,		0x21, 0
	.dw 0xe840, 0xc02e,	0xe87f, 0xc02e,		0x21, 0
	.dw 0xe8c0, 0xc02e,	0xe8ff, 0xc02e,		0x21, 0
	.dw 0xe940, 0xc02e,	0xe97f, 0xc02e,		0x21, 0
	.dw 0xe9c0, 0xc02e,	0xe9ff, 0xc02e,		0x21, 0
	.dw 0xea40, 0xc02e,	0xea7f, 0xc02e,		0x21, 0
	.dw 0xeac0, 0xc02e,	0xeaff, 0xc02e,		0x21, 0
	.dw 0xeb40, 0xc02e,	0xeb7f, 0xc02e,		0x21, 0
	.dw 0xebc0, 0xc02e,	0xebff, 0xc02e,		0x21, 0
	.dw 0xec40, 0xc02e,	0xec7f, 0xc02e,		0x21, 0
	.dw 0xecc0, 0xc02e,	0xecff, 0xc02e,		0x21, 0
	.dw 0xed40, 0xc02e,	0xed7f, 0xc02e,		0x21, 0
	.dw 0xedc0, 0xc02e,	0xedff, 0xc02e,		0x21, 0
	.dw 0xee40, 0xc02e,	0xee7f, 0xc02e,		0x21, 0
	.dw 0xeec0, 0xc02e,	0xeeff, 0xc02e,		0x21, 0
	.dw 0xef40, 0xc02e,	0xef7f, 0xc02e,		0x21, 0
	.dw 0xefc0, 0xc02e,	0xefff, 0xc02e,		0x21, 0
	.dw 0xf040, 0xc02e,	0xf07f, 0xc02e,		0x21, 0
	.dw 0xf0c0, 0xc02e,	0xf0ff, 0xc02e,		0x21, 0
	.dw 0xf140, 0xc02e,	0xf17f, 0xc02e,		0x21, 0
	.dw 0xf1c0, 0xc02e,	0xf1ff, 0xc02e,		0x21, 0
	.dw 0xf240, 0xc02e,	0xf27f, 0xc02e,		0x21, 0
	.dw 0xf2c0, 0xc02e,	0xf2ff, 0xc02e,		0x21, 0
	.dw 0xf340, 0xc02e,	0xf37f, 0xc02e,		0x21, 0
	.dw 0xf3c0, 0xc02e,	0xf3ff, 0xc02e,		0x21, 0
	.dw 0xf440, 0xc02e,	0xf47f, 0xc02e,		0x21, 0
	.dw 0xf4c0, 0xc02e,	0xf4ff, 0xc02e,		0x21, 0
	.dw 0xf540, 0xc02e,	0xf57f, 0xc02e,		0x21, 0
	.dw 0xf5c0, 0xc02e,	0xf5ff, 0xc02e,		0x21, 0
	.dw 0xf640, 0xc02e,	0xf67f, 0xc02e,		0x21, 0
	.dw 0xf6c0, 0xc02e,	0xf6ff, 0xc02e,		0x21, 0
	.dw 0xf740, 0xc02e,	0xf77f, 0xc02e,		0x21, 0
	.dw 0xf7c0, 0xc02e,	0xf7ff, 0xc02e,		0x21, 0
	.dw 0xf840, 0xc02e,	0xf87f, 0xc02e,		0x21, 0
	.dw 0xf8c0, 0xc02e,	0xf8ff, 0xc02e,		0x21, 0
	.dw 0xf940, 0xc02e,	0xf97f, 0xc02e,		0x21, 0
	.dw 0xf9c0, 0xc02e,	0xffff, 0xc02e,		0x21, 0
	.dw 0x0040, 0xc02f,	0x007f, 0xc02f,		0x21, 0
	.dw 0x00c0, 0xc02f,	0x00ff, 0xc02f,		0x21, 0
	.dw 0x0140, 0xc02f,	0x017f, 0xc02f,		0x21, 0
	.dw 0x01c0, 0xc02f,	0x01ff, 0xc02f,		0x21, 0
	.dw 0x0240, 0xc02f,	0x027f, 0xc02f,		0x21, 0
	.dw 0x02c0, 0xc02f,	0x02ff, 0xc02f,		0x21, 0
	.dw 0x0340, 0xc02f,	0x037f, 0xc02f,		0x21, 0
	.dw 0x03c0, 0xc02f,	0x03ff, 0xc02f,		0x21, 0
	.dw 0x0440, 0xc02f,	0x047f, 0xc02f,		0x21, 0
	.dw 0x04c0, 0xc02f,	0x04ff, 0xc02f,		0x21, 0
	.dw 0x0540, 0xc02f,	0x057f, 0xc02f,		0x21, 0
	.dw 0x05c0, 0xc02f,	0x05ff, 0xc02f,		0x21, 0
	.dw 0x0640, 0xc02f,	0x067f, 0xc02f,		0x21, 0
	.dw 0x06c0, 0xc02f,	0x06ff, 0xc02f,		0x21, 0
	.dw 0x0740, 0xc02f,	0x077f, 0xc02f,		0x21, 0
	.dw 0x07c0, 0xc02f,	0x07ff, 0xc02f,		0x21, 0
	.dw 0x0840, 0xc02f,	0x087f, 0xc02f,		0x21, 0
	.dw 0x08c0, 0xc02f,	0x08ff, 0xc02f,		0x21, 0
	.dw 0x0940, 0xc02f,	0x097f, 0xc02f,		0x21, 0
	.dw 0x09c0, 0xc02f,	0x09ff, 0xc02f,		0x21, 0
	.dw 0x0a40, 0xc02f,	0x0a7f, 0xc02f,		0x21, 0
	.dw 0x0ac0, 0xc02f,	0x0aff, 0xc02f,		0x21, 0
	.dw 0x0b40, 0xc02f,	0x0b7f, 0xc02f,		0x21, 0
	.dw 0x0bc0, 0xc02f,	0x0bff, 0xc02f,		0x21, 0
	.dw 0x0c40, 0xc02f,	0x0c7f, 0xc02f,		0x21, 0
	.dw 0x0cc0, 0xc02f,	0x0cff, 0xc02f,		0x21, 0
	.dw 0x0d40, 0xc02f,	0x0d7f, 0xc02f,		0x21, 0
	.dw 0x0dc0, 0xc02f,	0x0dff, 0xc02f,		0x21, 0
	.dw 0x0e40, 0xc02f,	0x0e7f, 0xc02f,		0x21, 0
	.dw 0x0ec0, 0xc02f,	0x0eff, 0xc02f,		0x21, 0
	.dw 0x0f40, 0xc02f,	0x0f7f, 0xc02f,		0x21, 0
	.dw 0x0fc0, 0xc02f,	0x0fff, 0xc02f,		0x21, 0
	.dw 0x1040, 0xc02f,	0x107f, 0xc02f,		0x21, 0
	.dw 0x10c0, 0xc02f,	0x10ff, 0xc02f,		0x21, 0
	.dw 0x1140, 0xc02f,	0x117f, 0xc02f,		0x21, 0
	.dw 0x11c0, 0xc02f,	0x11ff, 0xc02f,		0x21, 0
	.dw 0x1240, 0xc02f,	0x127f, 0xc02f,		0x21, 0
	.dw 0x12c0, 0xc02f,	0x12ff, 0xc02f,		0x21, 0
	.dw 0x1340, 0xc02f,	0x137f, 0xc02f,		0x21, 0
	.dw 0x13c0, 0xc02f,	0x13ff, 0xc02f,		0x21, 0
	.dw 0x1440, 0xc02f,	0x147f, 0xc02f,		0x21, 0
	.dw 0x14c0, 0xc02f,	0x14ff, 0xc02f,		0x21, 0
	.dw 0x1540, 0xc02f,	0x157f, 0xc02f,		0x21, 0
	.dw 0x15c0, 0xc02f,	0x15ff, 0xc02f,		0x21, 0
	.dw 0x1640, 0xc02f,	0x167f, 0xc02f,		0x21, 0
	.dw 0x16c0, 0xc02f,	0x16ff, 0xc02f,		0x21, 0
	.dw 0x1740, 0xc02f,	0x177f, 0xc02f,		0x21, 0
	.dw 0x17c0, 0xc02f,	0x17ff, 0xc02f,		0x21, 0
	.dw 0x1840, 0xc02f,	0x187f, 0xc02f,		0x21, 0
	.dw 0x18c0, 0xc02f,	0x18ff, 0xc02f,		0x21, 0
	.dw 0x1940, 0xc02f,	0x197f, 0xc02f,		0x21, 0
	.dw 0x19c0, 0xc02f,	0x1fff, 0xc02f,		0x21, 0
	.dw 0x2040, 0xc02f,	0x207f, 0xc02f,		0x21, 0
	.dw 0x20c0, 0xc02f,	0x20ff, 0xc02f,		0x21, 0
	.dw 0x2140, 0xc02f,	0x217f, 0xc02f,		0x21, 0
	.dw 0x21c0, 0xc02f,	0x21ff, 0xc02f,		0x21, 0
	.dw 0x2240, 0xc02f,	0x227f, 0xc02f,		0x21, 0
	.dw 0x22c0, 0xc02f,	0x22ff, 0xc02f,		0x21, 0
	.dw 0x2340, 0xc02f,	0x237f, 0xc02f,		0x21, 0
	.dw 0x23c0, 0xc02f,	0x23ff, 0xc02f,		0x21, 0
	.dw 0x2440, 0xc02f,	0x247f, 0xc02f,		0x21, 0
	.dw 0x24c0, 0xc02f,	0x24ff, 0xc02f,		0x21, 0
	.dw 0x2540, 0xc02f,	0x257f, 0xc02f,		0x21, 0
	.dw 0x25c0, 0xc02f,	0x25ff, 0xc02f,		0x21, 0
	.dw 0x2640, 0xc02f,	0x267f, 0xc02f,		0x21, 0
	.dw 0x26c0, 0xc02f,	0x26ff, 0xc02f,		0x21, 0
	.dw 0x2740, 0xc02f,	0x277f, 0xc02f,		0x21, 0
	.dw 0x27c0, 0xc02f,	0x27ff, 0xc02f,		0x21, 0
	.dw 0x2840, 0xc02f,	0x287f, 0xc02f,		0x21, 0
	.dw 0x28c0, 0xc02f,	0x28ff, 0xc02f,		0x21, 0
	.dw 0x2940, 0xc02f,	0x297f, 0xc02f,		0x21, 0
	.dw 0x29c0, 0xc02f,	0x29ff, 0xc02f,		0x21, 0
	.dw 0x2a40, 0xc02f,	0x2a7f, 0xc02f,		0x21, 0
	.dw 0x2ac0, 0xc02f,	0x2aff, 0xc02f,		0x21, 0
	.dw 0x2b40, 0xc02f,	0x2b7f, 0xc02f,		0x21, 0
	.dw 0x2bc0, 0xc02f,	0x2bff, 0xc02f,		0x21, 0
	.dw 0x2c40, 0xc02f,	0x2c7f, 0xc02f,		0x21, 0
	.dw 0x2cc0, 0xc02f,	0x2cff, 0xc02f,		0x21, 0
	.dw 0x2d40, 0xc02f,	0x2d7f, 0xc02f,		0x21, 0
	.dw 0x2dc0, 0xc02f,	0x2dff, 0xc02f,		0x21, 0
	.dw 0x2e40, 0xc02f,	0x2e7f, 0xc02f,		0x21, 0
	.dw 0x2ec0, 0xc02f,	0x2eff, 0xc02f,		0x21, 0
	.dw 0x2f40, 0xc02f,	0x2f7f, 0xc02f,		0x21, 0
	.dw 0x2fc0, 0xc02f,	0x2fff, 0xc02f,		0x21, 0
	.dw 0x3040, 0xc02f,	0x307f, 0xc02f,		0x21, 0
	.dw 0x30c0, 0xc02f,	0x30ff, 0xc02f,		0x21, 0
	.dw 0x3140, 0xc02f,	0x317f, 0xc02f,		0x21, 0
	.dw 0x31c0, 0xc02f,	0x31ff, 0xc02f,		0x21, 0
	.dw 0x3240, 0xc02f,	0x327f, 0xc02f,		0x21, 0
	.dw 0x32c0, 0xc02f,	0x32ff, 0xc02f,		0x21, 0
	.dw 0x3340, 0xc02f,	0x337f, 0xc02f,		0x21, 0
	.dw 0x33c0, 0xc02f,	0x33ff, 0xc02f,		0x21, 0
	.dw 0x3440, 0xc02f,	0x347f, 0xc02f,		0x21, 0
	.dw 0x34c0, 0xc02f,	0x34ff, 0xc02f,		0x21, 0
	.dw 0x3540, 0xc02f,	0x357f, 0xc02f,		0x21, 0
	.dw 0x35c0, 0xc02f,	0x35ff, 0xc02f,		0x21, 0
	.dw 0x3640, 0xc02f,	0x367f, 0xc02f,		0x21, 0
	.dw 0x36c0, 0xc02f,	0x36ff, 0xc02f,		0x21, 0
	.dw 0x3740, 0xc02f,	0x377f, 0xc02f,		0x21, 0
	.dw 0x37c0, 0xc02f,	0x37ff, 0xc02f,		0x21, 0
	.dw 0x3840, 0xc02f,	0x387f, 0xc02f,		0x21, 0
	.dw 0x38c0, 0xc02f,	0x38ff, 0xc02f,		0x21, 0
	.dw 0x3940, 0xc02f,	0x397f, 0xc02f,		0x21, 0
	.dw 0x39c0, 0xc02f,	0x1fff, 0xc030,		0x21, 0
	.dw 0x3a00, 0xc030,	0x5fff, 0xc030,		0x21, 0
	.dw 0x7a00, 0xc030,	0x9fff, 0xc030,		0x21, 0
	.dw 0xba00, 0xc030,	0xdfff, 0xc030,		0x21, 0
	.dw 0xfa00, 0xc030,	0x1fff, 0xc031,		0x21, 0
	.dw 0x3a00, 0xc031,	0x5fff, 0xc031,		0x21, 0
	.dw 0x7a00, 0xc031,	0x9fff, 0xc031,		0x21, 0
	.dw 0xba00, 0xc031,	0xdfff, 0xc031,		0x21, 0
	.dw 0xfa00, 0xc031,	0x1fff, 0xc032,		0x21, 0
	.dw 0x3a00, 0xc032,	0x5fff, 0xc032,		0x21, 0
	.dw 0x7a00, 0xc032,	0x9fff, 0xc032,		0x21, 0
	.dw 0xba00, 0xc032,	0xdfff, 0xc032,		0x21, 0
	.dw 0xfa00, 0xc032,	0xffff, 0xc033,		0x21, 0
	.dw 0x1a00, 0xc034,	0x1fff, 0xc034,		0x21, 0
	.dw 0x3a00, 0xc034,	0x3fff, 0xc034,		0x21, 0
	.dw 0x5a00, 0xc034,	0x5fff, 0xc034,		0x21, 0
	.dw 0x7a00, 0xc034,	0x7fff, 0xc034,		0x21, 0
	.dw 0x9a00, 0xc034,	0x9fff, 0xc034,		0x21, 0
	.dw 0xba00, 0xc034,	0xbfff, 0xc034,		0x21, 0
	.dw 0xda00, 0xc034,	0xdfff, 0xc034,		0x21, 0
	.dw 0xfa00, 0xc034,	0xffff, 0xc034,		0x21, 0
	.dw 0x1a00, 0xc035,	0x1fff, 0xc035,		0x21, 0
	.dw 0x3a00, 0xc035,	0x3fff, 0xc035,		0x21, 0
	.dw 0x5a00, 0xc035,	0x5fff, 0xc035,		0x21, 0
	.dw 0x7a00, 0xc035,	0x7fff, 0xc035,		0x21, 0
	.dw 0x9a00, 0xc035,	0x9fff, 0xc035,		0x21, 0
	.dw 0xba00, 0xc035,	0xbfff, 0xc035,		0x21, 0
	.dw 0xda00, 0xc035,	0xdfff, 0xc035,		0x21, 0
	.dw 0xfa00, 0xc035,	0xffff, 0xc035,		0x21, 0
	.dw 0x1a00, 0xc036,	0x1fff, 0xc036,		0x21, 0
	.dw 0x3a00, 0xc036,	0x3fff, 0xc036,		0x21, 0
	.dw 0x5a00, 0xc036,	0x5fff, 0xc036,		0x21, 0
	.dw 0x7a00, 0xc036,	0x7fff, 0xc036,		0x21, 0
	.dw 0x9a00, 0xc036,	0x9fff, 0xc036,		0x21, 0
	.dw 0xba00, 0xc036,	0xbfff, 0xc036,		0x21, 0
	.dw 0xda00, 0xc036,	0xdfff, 0xc036,		0x21, 0
	.dw 0xfa00, 0xc036,	0xffff, 0xc036,		0x21, 0
	.dw 0x1a00, 0xc037,	0x1fff, 0xc037,		0x21, 0
	.dw 0x3a00, 0xc037,	0x1fff, 0xc038,		0x21, 0
	.dw 0x2040, 0xc038,	0x207f, 0xc038,		0x21, 0
	.dw 0x20c0, 0xc038,	0x20ff, 0xc038,		0x21, 0
	.dw 0x2140, 0xc038,	0x217f, 0xc038,		0x21, 0
	.dw 0x21c0, 0xc038,	0x21ff, 0xc038,		0x21, 0
	.dw 0x2240, 0xc038,	0x227f, 0xc038,		0x21, 0
	.dw 0x22c0, 0xc038,	0x22ff, 0xc038,		0x21, 0
	.dw 0x2340, 0xc038,	0x237f, 0xc038,		0x21, 0
	.dw 0x23c0, 0xc038,	0x23ff, 0xc038,		0x21, 0
	.dw 0x2440, 0xc038,	0x247f, 0xc038,		0x21, 0
	.dw 0x24c0, 0xc038,	0x24ff, 0xc038,		0x21, 0
	.dw 0x2540, 0xc038,	0x257f, 0xc038,		0x21, 0
	.dw 0x25c0, 0xc038,	0x25ff, 0xc038,		0x21, 0
	.dw 0x2640, 0xc038,	0x267f, 0xc038,		0x21, 0
	.dw 0x26c0, 0xc038,	0x26ff, 0xc038,		0x21, 0
	.dw 0x2740, 0xc038,	0x277f, 0xc038,		0x21, 0
	.dw 0x27c0, 0xc038,	0x27ff, 0xc038,		0x21, 0
	.dw 0x2840, 0xc038,	0x287f, 0xc038,		0x21, 0
	.dw 0x28c0, 0xc038,	0x28ff, 0xc038,		0x21, 0
	.dw 0x2940, 0xc038,	0x297f, 0xc038,		0x21, 0
	.dw 0x29c0, 0xc038,	0x29ff, 0xc038,		0x21, 0
	.dw 0x2a40, 0xc038,	0x2a7f, 0xc038,		0x21, 0
	.dw 0x2ac0, 0xc038,	0x2aff, 0xc038,		0x21, 0
	.dw 0x2b40, 0xc038,	0x2b7f, 0xc038,		0x21, 0
	.dw 0x2bc0, 0xc038,	0x2bff, 0xc038,		0x21, 0
	.dw 0x2c40, 0xc038,	0x2c7f, 0xc038,		0x21, 0
	.dw 0x2cc0, 0xc038,	0x2cff, 0xc038,		0x21, 0
	.dw 0x2d40, 0xc038,	0x2d7f, 0xc038,		0x21, 0
	.dw 0x2dc0, 0xc038,	0x2dff, 0xc038,		0x21, 0
	.dw 0x2e40, 0xc038,	0x2e7f, 0xc038,		0x21, 0
	.dw 0x2ec0, 0xc038,	0x2eff, 0xc038,		0x21, 0
	.dw 0x2f40, 0xc038,	0x2f7f, 0xc038,		0x21, 0
	.dw 0x2fc0, 0xc038,	0x2fff, 0xc038,		0x21, 0
	.dw 0x3040, 0xc038,	0x307f, 0xc038,		0x21, 0
	.dw 0x30c0, 0xc038,	0x30ff, 0xc038,		0x21, 0
	.dw 0x3140, 0xc038,	0x317f, 0xc038,		0x21, 0
	.dw 0x31c0, 0xc038,	0x31ff, 0xc038,		0x21, 0
	.dw 0x3240, 0xc038,	0x327f, 0xc038,		0x21, 0
	.dw 0x32c0, 0xc038,	0x32ff, 0xc038,		0x21, 0
	.dw 0x3340, 0xc038,	0x337f, 0xc038,		0x21, 0
	.dw 0x33c0, 0xc038,	0x33ff, 0xc038,		0x21, 0
	.dw 0x3440, 0xc038,	0x347f, 0xc038,		0x21, 0
	.dw 0x34c0, 0xc038,	0x34ff, 0xc038,		0x21, 0
	.dw 0x3540, 0xc038,	0x357f, 0xc038,		0x21, 0
	.dw 0x35c0, 0xc038,	0x35ff, 0xc038,		0x21, 0
	.dw 0x3640, 0xc038,	0x367f, 0xc038,		0x21, 0
	.dw 0x36c0, 0xc038,	0x36ff, 0xc038,		0x21, 0
	.dw 0x3740, 0xc038,	0x377f, 0xc038,		0x21, 0
	.dw 0x37c0, 0xc038,	0x37ff, 0xc038,		0x21, 0
	.dw 0x3840, 0xc038,	0x387f, 0xc038,		0x21, 0
	.dw 0x38c0, 0xc038,	0x38ff, 0xc038,		0x21, 0
	.dw 0x3940, 0xc038,	0x397f, 0xc038,		0x21, 0
	.dw 0x39c0, 0xc038,	0x5fff, 0xc038,		0x21, 0
	.dw 0x6040, 0xc038,	0x607f, 0xc038,		0x21, 0
	.dw 0x60c0, 0xc038,	0x60ff, 0xc038,		0x21, 0
	.dw 0x6140, 0xc038,	0x617f, 0xc038,		0x21, 0
	.dw 0x61c0, 0xc038,	0x61ff, 0xc038,		0x21, 0
	.dw 0x6240, 0xc038,	0x627f, 0xc038,		0x21, 0
	.dw 0x62c0, 0xc038,	0x62ff, 0xc038,		0x21, 0
	.dw 0x6340, 0xc038,	0x637f, 0xc038,		0x21, 0
	.dw 0x63c0, 0xc038,	0x63ff, 0xc038,		0x21, 0
	.dw 0x6440, 0xc038,	0x647f, 0xc038,		0x21, 0
	.dw 0x64c0, 0xc038,	0x64ff, 0xc038,		0x21, 0
	.dw 0x6540, 0xc038,	0x657f, 0xc038,		0x21, 0
	.dw 0x65c0, 0xc038,	0x65ff, 0xc038,		0x21, 0
	.dw 0x6640, 0xc038,	0x667f, 0xc038,		0x21, 0
	.dw 0x66c0, 0xc038,	0x66ff, 0xc038,		0x21, 0
	.dw 0x6740, 0xc038,	0x677f, 0xc038,		0x21, 0
	.dw 0x67c0, 0xc038,	0x67ff, 0xc038,		0x21, 0
	.dw 0x6840, 0xc038,	0x687f, 0xc038,		0x21, 0
	.dw 0x68c0, 0xc038,	0x68ff, 0xc038,		0x21, 0
	.dw 0x6940, 0xc038,	0x697f, 0xc038,		0x21, 0
	.dw 0x69c0, 0xc038,	0x69ff, 0xc038,		0x21, 0
	.dw 0x6a40, 0xc038,	0x6a7f, 0xc038,		0x21, 0
	.dw 0x6ac0, 0xc038,	0x6aff, 0xc038,		0x21, 0
	.dw 0x6b40, 0xc038,	0x6b7f, 0xc038,		0x21, 0
	.dw 0x6bc0, 0xc038,	0x6bff, 0xc038,		0x21, 0
	.dw 0x6c40, 0xc038,	0x6c7f, 0xc038,		0x21, 0
	.dw 0x6cc0, 0xc038,	0x6cff, 0xc038,		0x21, 0
	.dw 0x6d40, 0xc038,	0x6d7f, 0xc038,		0x21, 0
	.dw 0x6dc0, 0xc038,	0x6dff, 0xc038,		0x21, 0
	.dw 0x6e40, 0xc038,	0x6e7f, 0xc038,		0x21, 0
	.dw 0x6ec0, 0xc038,	0x6eff, 0xc038,		0x21, 0
	.dw 0x6f40, 0xc038,	0x6f7f, 0xc038,		0x21, 0
	.dw 0x6fc0, 0xc038,	0x6fff, 0xc038,		0x21, 0
	.dw 0x7040, 0xc038,	0x707f, 0xc038,		0x21, 0
	.dw 0x70c0, 0xc038,	0x70ff, 0xc038,		0x21, 0
	.dw 0x7140, 0xc038,	0x717f, 0xc038,		0x21, 0
	.dw 0x71c0, 0xc038,	0x71ff, 0xc038,		0x21, 0
	.dw 0x7240, 0xc038,	0x727f, 0xc038,		0x21, 0
	.dw 0x72c0, 0xc038,	0x72ff, 0xc038,		0x21, 0
	.dw 0x7340, 0xc038,	0x737f, 0xc038,		0x21, 0
	.dw 0x73c0, 0xc038,	0x73ff, 0xc038,		0x21, 0
	.dw 0x7440, 0xc038,	0x747f, 0xc038,		0x21, 0
	.dw 0x74c0, 0xc038,	0x74ff, 0xc038,		0x21, 0
	.dw 0x7540, 0xc038,	0x757f, 0xc038,		0x21, 0
	.dw 0x75c0, 0xc038,	0x75ff, 0xc038,		0x21, 0
	.dw 0x7640, 0xc038,	0x767f, 0xc038,		0x21, 0
	.dw 0x76c0, 0xc038,	0x76ff, 0xc038,		0x21, 0
	.dw 0x7740, 0xc038,	0x777f, 0xc038,		0x21, 0
	.dw 0x77c0, 0xc038,	0x77ff, 0xc038,		0x21, 0
	.dw 0x7840, 0xc038,	0x787f, 0xc038,		0x21, 0
	.dw 0x78c0, 0xc038,	0x78ff, 0xc038,		0x21, 0
	.dw 0x7940, 0xc038,	0x797f, 0xc038,		0x21, 0
	.dw 0x79c0, 0xc038,	0x9fff, 0xc038,		0x21, 0
	.dw 0xa040, 0xc038,	0xa07f, 0xc038,		0x21, 0
	.dw 0xa0c0, 0xc038,	0xa0ff, 0xc038,		0x21, 0
	.dw 0xa140, 0xc038,	0xa17f, 0xc038,		0x21, 0
	.dw 0xa1c0, 0xc038,	0xa1ff, 0xc038,		0x21, 0
	.dw 0xa240, 0xc038,	0xa27f, 0xc038,		0x21, 0
	.dw 0xa2c0, 0xc038,	0xa2ff, 0xc038,		0x21, 0
	.dw 0xa340, 0xc038,	0xa37f, 0xc038,		0x21, 0
	.dw 0xa3c0, 0xc038,	0xa3ff, 0xc038,		0x21, 0
	.dw 0xa440, 0xc038,	0xa47f, 0xc038,		0x21, 0
	.dw 0xa4c0, 0xc038,	0xa4ff, 0xc038,		0x21, 0
	.dw 0xa540, 0xc038,	0xa57f, 0xc038,		0x21, 0
	.dw 0xa5c0, 0xc038,	0xa5ff, 0xc038,		0x21, 0
	.dw 0xa640, 0xc038,	0xa67f, 0xc038,		0x21, 0
	.dw 0xa6c0, 0xc038,	0xa6ff, 0xc038,		0x21, 0
	.dw 0xa740, 0xc038,	0xa77f, 0xc038,		0x21, 0
	.dw 0xa7c0, 0xc038,	0xa7ff, 0xc038,		0x21, 0
	.dw 0xa840, 0xc038,	0xa87f, 0xc038,		0x21, 0
	.dw 0xa8c0, 0xc038,	0xa8ff, 0xc038,		0x21, 0
	.dw 0xa940, 0xc038,	0xa97f, 0xc038,		0x21, 0
	.dw 0xa9c0, 0xc038,	0xa9ff, 0xc038,		0x21, 0
	.dw 0xaa40, 0xc038,	0xaa7f, 0xc038,		0x21, 0
	.dw 0xaac0, 0xc038,	0xaaff, 0xc038,		0x21, 0
	.dw 0xab40, 0xc038,	0xab7f, 0xc038,		0x21, 0
	.dw 0xabc0, 0xc038,	0xabff, 0xc038,		0x21, 0
	.dw 0xac40, 0xc038,	0xac7f, 0xc038,		0x21, 0
	.dw 0xacc0, 0xc038,	0xacff, 0xc038,		0x21, 0
	.dw 0xad40, 0xc038,	0xad7f, 0xc038,		0x21, 0
	.dw 0xadc0, 0xc038,	0xadff, 0xc038,		0x21, 0
	.dw 0xae40, 0xc038,	0xae7f, 0xc038,		0x21, 0
	.dw 0xaec0, 0xc038,	0xaeff, 0xc038,		0x21, 0
	.dw 0xaf40, 0xc038,	0xaf7f, 0xc038,		0x21, 0
	.dw 0xafc0, 0xc038,	0xafff, 0xc038,		0x21, 0
	.dw 0xb040, 0xc038,	0xb07f, 0xc038,		0x21, 0
	.dw 0xb0c0, 0xc038,	0xb0ff, 0xc038,		0x21, 0
	.dw 0xb140, 0xc038,	0xb17f, 0xc038,		0x21, 0
	.dw 0xb1c0, 0xc038,	0xb1ff, 0xc038,		0x21, 0
	.dw 0xb240, 0xc038,	0xb27f, 0xc038,		0x21, 0
	.dw 0xb2c0, 0xc038,	0xb2ff, 0xc038,		0x21, 0
	.dw 0xb340, 0xc038,	0xb37f, 0xc038,		0x21, 0
	.dw 0xb3c0, 0xc038,	0xb3ff, 0xc038,		0x21, 0
	.dw 0xb440, 0xc038,	0xb47f, 0xc038,		0x21, 0
	.dw 0xb4c0, 0xc038,	0xb4ff, 0xc038,		0x21, 0
	.dw 0xb540, 0xc038,	0xb57f, 0xc038,		0x21, 0
	.dw 0xb5c0, 0xc038,	0xb5ff, 0xc038,		0x21, 0
	.dw 0xb640, 0xc038,	0xb67f, 0xc038,		0x21, 0
	.dw 0xb6c0, 0xc038,	0xb6ff, 0xc038,		0x21, 0
	.dw 0xb740, 0xc038,	0xb77f, 0xc038,		0x21, 0
	.dw 0xb7c0, 0xc038,	0xb7ff, 0xc038,		0x21, 0
	.dw 0xb840, 0xc038,	0xb87f, 0xc038,		0x21, 0
	.dw 0xb8c0, 0xc038,	0xb8ff, 0xc038,		0x21, 0
	.dw 0xb940, 0xc038,	0xb97f, 0xc038,		0x21, 0
	.dw 0xb9c0, 0xc038,	0xdfff, 0xc038,		0x21, 0
	.dw 0xe040, 0xc038,	0xe07f, 0xc038,		0x21, 0
	.dw 0xe0c0, 0xc038,	0xe0ff, 0xc038,		0x21, 0
	.dw 0xe140, 0xc038,	0xe17f, 0xc038,		0x21, 0
	.dw 0xe1c0, 0xc038,	0xe1ff, 0xc038,		0x21, 0
	.dw 0xe240, 0xc038,	0xe27f, 0xc038,		0x21, 0
	.dw 0xe2c0, 0xc038,	0xe2ff, 0xc038,		0x21, 0
	.dw 0xe340, 0xc038,	0xe37f, 0xc038,		0x21, 0
	.dw 0xe3c0, 0xc038,	0xe3ff, 0xc038,		0x21, 0
	.dw 0xe440, 0xc038,	0xe47f, 0xc038,		0x21, 0
	.dw 0xe4c0, 0xc038,	0xe4ff, 0xc038,		0x21, 0
	.dw 0xe540, 0xc038,	0xe57f, 0xc038,		0x21, 0
	.dw 0xe5c0, 0xc038,	0xe5ff, 0xc038,		0x21, 0
	.dw 0xe640, 0xc038,	0xe67f, 0xc038,		0x21, 0
	.dw 0xe6c0, 0xc038,	0xe6ff, 0xc038,		0x21, 0
	.dw 0xe740, 0xc038,	0xe77f, 0xc038,		0x21, 0
	.dw 0xe7c0, 0xc038,	0xe7ff, 0xc038,		0x21, 0
	.dw 0xe840, 0xc038,	0xe87f, 0xc038,		0x21, 0
	.dw 0xe8c0, 0xc038,	0xe8ff, 0xc038,		0x21, 0
	.dw 0xe940, 0xc038,	0xe97f, 0xc038,		0x21, 0
	.dw 0xe9c0, 0xc038,	0xe9ff, 0xc038,		0x21, 0
	.dw 0xea40, 0xc038,	0xea7f, 0xc038,		0x21, 0
	.dw 0xeac0, 0xc038,	0xeaff, 0xc038,		0x21, 0
	.dw 0xeb40, 0xc038,	0xeb7f, 0xc038,		0x21, 0
	.dw 0xebc0, 0xc038,	0xebff, 0xc038,		0x21, 0
	.dw 0xec40, 0xc038,	0xec7f, 0xc038,		0x21, 0
	.dw 0xecc0, 0xc038,	0xecff, 0xc038,		0x21, 0
	.dw 0xed40, 0xc038,	0xed7f, 0xc038,		0x21, 0
	.dw 0xedc0, 0xc038,	0xedff, 0xc038,		0x21, 0
	.dw 0xee40, 0xc038,	0xee7f, 0xc038,		0x21, 0
	.dw 0xeec0, 0xc038,	0xeeff, 0xc038,		0x21, 0
	.dw 0xef40, 0xc038,	0xef7f, 0xc038,		0x21, 0
	.dw 0xefc0, 0xc038,	0xefff, 0xc038,		0x21, 0
	.dw 0xf040, 0xc038,	0xf07f, 0xc038,		0x21, 0
	.dw 0xf0c0, 0xc038,	0xf0ff, 0xc038,		0x21, 0
	.dw 0xf140, 0xc038,	0xf17f, 0xc038,		0x21, 0
	.dw 0xf1c0, 0xc038,	0xf1ff, 0xc038,		0x21, 0
	.dw 0xf240, 0xc038,	0xf27f, 0xc038,		0x21, 0
	.dw 0xf2c0, 0xc038,	0xf2ff, 0xc038,		0x21, 0
	.dw 0xf340, 0xc038,	0xf37f, 0xc038,		0x21, 0
	.dw 0xf3c0, 0xc038,	0xf3ff, 0xc038,		0x21, 0
	.dw 0xf440, 0xc038,	0xf47f, 0xc038,		0x21, 0
	.dw 0xf4c0, 0xc038,	0xf4ff, 0xc038,		0x21, 0
	.dw 0xf540, 0xc038,	0xf57f, 0xc038,		0x21, 0
	.dw 0xf5c0, 0xc038,	0xf5ff, 0xc038,		0x21, 0
	.dw 0xf640, 0xc038,	0xf67f, 0xc038,		0x21, 0
	.dw 0xf6c0, 0xc038,	0xf6ff, 0xc038,		0x21, 0
	.dw 0xf740, 0xc038,	0xf77f, 0xc038,		0x21, 0
	.dw 0xf7c0, 0xc038,	0xf7ff, 0xc038,		0x21, 0
	.dw 0xf840, 0xc038,	0xf87f, 0xc038,		0x21, 0
	.dw 0xf8c0, 0xc038,	0xf8ff, 0xc038,		0x21, 0
	.dw 0xf940, 0xc038,	0xf97f, 0xc038,		0x21, 0
	.dw 0xf9c0, 0xc038,	0x1fff, 0xc039,		0x21, 0
	.dw 0x2040, 0xc039,	0x207f, 0xc039,		0x21, 0
	.dw 0x20c0, 0xc039,	0x20ff, 0xc039,		0x21, 0
	.dw 0x2140, 0xc039,	0x217f, 0xc039,		0x21, 0
	.dw 0x21c0, 0xc039,	0x21ff, 0xc039,		0x21, 0
	.dw 0x2240, 0xc039,	0x227f, 0xc039,		0x21, 0
	.dw 0x22c0, 0xc039,	0x22ff, 0xc039,		0x21, 0
	.dw 0x2340, 0xc039,	0x237f, 0xc039,		0x21, 0
	.dw 0x23c0, 0xc039,	0x23ff, 0xc039,		0x21, 0
	.dw 0x2440, 0xc039,	0x247f, 0xc039,		0x21, 0
	.dw 0x24c0, 0xc039,	0x24ff, 0xc039,		0x21, 0
	.dw 0x2540, 0xc039,	0x257f, 0xc039,		0x21, 0
	.dw 0x25c0, 0xc039,	0x25ff, 0xc039,		0x21, 0
	.dw 0x2640, 0xc039,	0x267f, 0xc039,		0x21, 0
	.dw 0x26c0, 0xc039,	0x26ff, 0xc039,		0x21, 0
	.dw 0x2740, 0xc039,	0x277f, 0xc039,		0x21, 0
	.dw 0x27c0, 0xc039,	0x27ff, 0xc039,		0x21, 0
	.dw 0x2840, 0xc039,	0x287f, 0xc039,		0x21, 0
	.dw 0x28c0, 0xc039,	0x28ff, 0xc039,		0x21, 0
	.dw 0x2940, 0xc039,	0x297f, 0xc039,		0x21, 0
	.dw 0x29c0, 0xc039,	0x29ff, 0xc039,		0x21, 0
	.dw 0x2a40, 0xc039,	0x2a7f, 0xc039,		0x21, 0
	.dw 0x2ac0, 0xc039,	0x2aff, 0xc039,		0x21, 0
	.dw 0x2b40, 0xc039,	0x2b7f, 0xc039,		0x21, 0
	.dw 0x2bc0, 0xc039,	0x2bff, 0xc039,		0x21, 0
	.dw 0x2c40, 0xc039,	0x2c7f, 0xc039,		0x21, 0
	.dw 0x2cc0, 0xc039,	0x2cff, 0xc039,		0x21, 0
	.dw 0x2d40, 0xc039,	0x2d7f, 0xc039,		0x21, 0
	.dw 0x2dc0, 0xc039,	0x2dff, 0xc039,		0x21, 0
	.dw 0x2e40, 0xc039,	0x2e7f, 0xc039,		0x21, 0
	.dw 0x2ec0, 0xc039,	0x2eff, 0xc039,		0x21, 0
	.dw 0x2f40, 0xc039,	0x2f7f, 0xc039,		0x21, 0
	.dw 0x2fc0, 0xc039,	0x2fff, 0xc039,		0x21, 0
	.dw 0x3040, 0xc039,	0x307f, 0xc039,		0x21, 0
	.dw 0x30c0, 0xc039,	0x30ff, 0xc039,		0x21, 0
	.dw 0x3140, 0xc039,	0x317f, 0xc039,		0x21, 0
	.dw 0x31c0, 0xc039,	0x31ff, 0xc039,		0x21, 0
	.dw 0x3240, 0xc039,	0x327f, 0xc039,		0x21, 0
	.dw 0x32c0, 0xc039,	0x32ff, 0xc039,		0x21, 0
	.dw 0x3340, 0xc039,	0x337f, 0xc039,		0x21, 0
	.dw 0x33c0, 0xc039,	0x33ff, 0xc039,		0x21, 0
	.dw 0x3440, 0xc039,	0x347f, 0xc039,		0x21, 0
	.dw 0x34c0, 0xc039,	0x34ff, 0xc039,		0x21, 0
	.dw 0x3540, 0xc039,	0x357f, 0xc039,		0x21, 0
	.dw 0x35c0, 0xc039,	0x35ff, 0xc039,		0x21, 0
	.dw 0x3640, 0xc039,	0x367f, 0xc039,		0x21, 0
	.dw 0x36c0, 0xc039,	0x36ff, 0xc039,		0x21, 0
	.dw 0x3740, 0xc039,	0x377f, 0xc039,		0x21, 0
	.dw 0x37c0, 0xc039,	0x37ff, 0xc039,		0x21, 0
	.dw 0x3840, 0xc039,	0x387f, 0xc039,		0x21, 0
	.dw 0x38c0, 0xc039,	0x38ff, 0xc039,		0x21, 0
	.dw 0x3940, 0xc039,	0x397f, 0xc039,		0x21, 0
	.dw 0x39c0, 0xc039,	0x5fff, 0xc039,		0x21, 0
	.dw 0x6040, 0xc039,	0x607f, 0xc039,		0x21, 0
	.dw 0x60c0, 0xc039,	0x60ff, 0xc039,		0x21, 0
	.dw 0x6140, 0xc039,	0x617f, 0xc039,		0x21, 0
	.dw 0x61c0, 0xc039,	0x61ff, 0xc039,		0x21, 0
	.dw 0x6240, 0xc039,	0x627f, 0xc039,		0x21, 0
	.dw 0x62c0, 0xc039,	0x62ff, 0xc039,		0x21, 0
	.dw 0x6340, 0xc039,	0x637f, 0xc039,		0x21, 0
	.dw 0x63c0, 0xc039,	0x63ff, 0xc039,		0x21, 0
	.dw 0x6440, 0xc039,	0x647f, 0xc039,		0x21, 0
	.dw 0x64c0, 0xc039,	0x64ff, 0xc039,		0x21, 0
	.dw 0x6540, 0xc039,	0x657f, 0xc039,		0x21, 0
	.dw 0x65c0, 0xc039,	0x65ff, 0xc039,		0x21, 0
	.dw 0x6640, 0xc039,	0x667f, 0xc039,		0x21, 0
	.dw 0x66c0, 0xc039,	0x66ff, 0xc039,		0x21, 0
	.dw 0x6740, 0xc039,	0x677f, 0xc039,		0x21, 0
	.dw 0x67c0, 0xc039,	0x67ff, 0xc039,		0x21, 0
	.dw 0x6840, 0xc039,	0x687f, 0xc039,		0x21, 0
	.dw 0x68c0, 0xc039,	0x68ff, 0xc039,		0x21, 0
	.dw 0x6940, 0xc039,	0x697f, 0xc039,		0x21, 0
	.dw 0x69c0, 0xc039,	0x69ff, 0xc039,		0x21, 0
	.dw 0x6a40, 0xc039,	0x6a7f, 0xc039,		0x21, 0
	.dw 0x6ac0, 0xc039,	0x6aff, 0xc039,		0x21, 0
	.dw 0x6b40, 0xc039,	0x6b7f, 0xc039,		0x21, 0
	.dw 0x6bc0, 0xc039,	0x6bff, 0xc039,		0x21, 0
	.dw 0x6c40, 0xc039,	0x6c7f, 0xc039,		0x21, 0
	.dw 0x6cc0, 0xc039,	0x6cff, 0xc039,		0x21, 0
	.dw 0x6d40, 0xc039,	0x6d7f, 0xc039,		0x21, 0
	.dw 0x6dc0, 0xc039,	0x6dff, 0xc039,		0x21, 0
	.dw 0x6e40, 0xc039,	0x6e7f, 0xc039,		0x21, 0
	.dw 0x6ec0, 0xc039,	0x6eff, 0xc039,		0x21, 0
	.dw 0x6f40, 0xc039,	0x6f7f, 0xc039,		0x21, 0
	.dw 0x6fc0, 0xc039,	0x6fff, 0xc039,		0x21, 0
	.dw 0x7040, 0xc039,	0x707f, 0xc039,		0x21, 0
	.dw 0x70c0, 0xc039,	0x70ff, 0xc039,		0x21, 0
	.dw 0x7140, 0xc039,	0x717f, 0xc039,		0x21, 0
	.dw 0x71c0, 0xc039,	0x71ff, 0xc039,		0x21, 0
	.dw 0x7240, 0xc039,	0x727f, 0xc039,		0x21, 0
	.dw 0x72c0, 0xc039,	0x72ff, 0xc039,		0x21, 0
	.dw 0x7340, 0xc039,	0x737f, 0xc039,		0x21, 0
	.dw 0x73c0, 0xc039,	0x73ff, 0xc039,		0x21, 0
	.dw 0x7440, 0xc039,	0x747f, 0xc039,		0x21, 0
	.dw 0x74c0, 0xc039,	0x74ff, 0xc039,		0x21, 0
	.dw 0x7540, 0xc039,	0x757f, 0xc039,		0x21, 0
	.dw 0x75c0, 0xc039,	0x75ff, 0xc039,		0x21, 0
	.dw 0x7640, 0xc039,	0x767f, 0xc039,		0x21, 0
	.dw 0x76c0, 0xc039,	0x76ff, 0xc039,		0x21, 0
	.dw 0x7740, 0xc039,	0x777f, 0xc039,		0x21, 0
	.dw 0x77c0, 0xc039,	0x77ff, 0xc039,		0x21, 0
	.dw 0x7840, 0xc039,	0x787f, 0xc039,		0x21, 0
	.dw 0x78c0, 0xc039,	0x78ff, 0xc039,		0x21, 0
	.dw 0x7940, 0xc039,	0x797f, 0xc039,		0x21, 0
	.dw 0x79c0, 0xc039,	0x9fff, 0xc039,		0x21, 0
	.dw 0xa040, 0xc039,	0xa07f, 0xc039,		0x21, 0
	.dw 0xa0c0, 0xc039,	0xa0ff, 0xc039,		0x21, 0
	.dw 0xa140, 0xc039,	0xa17f, 0xc039,		0x21, 0
	.dw 0xa1c0, 0xc039,	0xa1ff, 0xc039,		0x21, 0
	.dw 0xa240, 0xc039,	0xa27f, 0xc039,		0x21, 0
	.dw 0xa2c0, 0xc039,	0xa2ff, 0xc039,		0x21, 0
	.dw 0xa340, 0xc039,	0xa37f, 0xc039,		0x21, 0
	.dw 0xa3c0, 0xc039,	0xa3ff, 0xc039,		0x21, 0
	.dw 0xa440, 0xc039,	0xa47f, 0xc039,		0x21, 0
	.dw 0xa4c0, 0xc039,	0xa4ff, 0xc039,		0x21, 0
	.dw 0xa540, 0xc039,	0xa57f, 0xc039,		0x21, 0
	.dw 0xa5c0, 0xc039,	0xa5ff, 0xc039,		0x21, 0
	.dw 0xa640, 0xc039,	0xa67f, 0xc039,		0x21, 0
	.dw 0xa6c0, 0xc039,	0xa6ff, 0xc039,		0x21, 0
	.dw 0xa740, 0xc039,	0xa77f, 0xc039,		0x21, 0
	.dw 0xa7c0, 0xc039,	0xa7ff, 0xc039,		0x21, 0
	.dw 0xa840, 0xc039,	0xa87f, 0xc039,		0x21, 0
	.dw 0xa8c0, 0xc039,	0xa8ff, 0xc039,		0x21, 0
	.dw 0xa940, 0xc039,	0xa97f, 0xc039,		0x21, 0
	.dw 0xa9c0, 0xc039,	0xa9ff, 0xc039,		0x21, 0
	.dw 0xaa40, 0xc039,	0xaa7f, 0xc039,		0x21, 0
	.dw 0xaac0, 0xc039,	0xaaff, 0xc039,		0x21, 0
	.dw 0xab40, 0xc039,	0xab7f, 0xc039,		0x21, 0
	.dw 0xabc0, 0xc039,	0xabff, 0xc039,		0x21, 0
	.dw 0xac40, 0xc039,	0xac7f, 0xc039,		0x21, 0
	.dw 0xacc0, 0xc039,	0xacff, 0xc039,		0x21, 0
	.dw 0xad40, 0xc039,	0xad7f, 0xc039,		0x21, 0
	.dw 0xadc0, 0xc039,	0xadff, 0xc039,		0x21, 0
	.dw 0xae40, 0xc039,	0xae7f, 0xc039,		0x21, 0
	.dw 0xaec0, 0xc039,	0xaeff, 0xc039,		0x21, 0
	.dw 0xaf40, 0xc039,	0xaf7f, 0xc039,		0x21, 0
	.dw 0xafc0, 0xc039,	0xafff, 0xc039,		0x21, 0
	.dw 0xb040, 0xc039,	0xb07f, 0xc039,		0x21, 0
	.dw 0xb0c0, 0xc039,	0xb0ff, 0xc039,		0x21, 0
	.dw 0xb140, 0xc039,	0xb17f, 0xc039,		0x21, 0
	.dw 0xb1c0, 0xc039,	0xb1ff, 0xc039,		0x21, 0
	.dw 0xb240, 0xc039,	0xb27f, 0xc039,		0x21, 0
	.dw 0xb2c0, 0xc039,	0xb2ff, 0xc039,		0x21, 0
	.dw 0xb340, 0xc039,	0xb37f, 0xc039,		0x21, 0
	.dw 0xb3c0, 0xc039,	0xb3ff, 0xc039,		0x21, 0
	.dw 0xb440, 0xc039,	0xb47f, 0xc039,		0x21, 0
	.dw 0xb4c0, 0xc039,	0xb4ff, 0xc039,		0x21, 0
	.dw 0xb540, 0xc039,	0xb57f, 0xc039,		0x21, 0
	.dw 0xb5c0, 0xc039,	0xb5ff, 0xc039,		0x21, 0
	.dw 0xb640, 0xc039,	0xb67f, 0xc039,		0x21, 0
	.dw 0xb6c0, 0xc039,	0xb6ff, 0xc039,		0x21, 0
	.dw 0xb740, 0xc039,	0xb77f, 0xc039,		0x21, 0
	.dw 0xb7c0, 0xc039,	0xb7ff, 0xc039,		0x21, 0
	.dw 0xb840, 0xc039,	0xb87f, 0xc039,		0x21, 0
	.dw 0xb8c0, 0xc039,	0xb8ff, 0xc039,		0x21, 0
	.dw 0xb940, 0xc039,	0xb97f, 0xc039,		0x21, 0
	.dw 0xb9c0, 0xc039,	0xdfff, 0xc039,		0x21, 0
	.dw 0xe040, 0xc039,	0xe07f, 0xc039,		0x21, 0
	.dw 0xe0c0, 0xc039,	0xe0ff, 0xc039,		0x21, 0
	.dw 0xe140, 0xc039,	0xe17f, 0xc039,		0x21, 0
	.dw 0xe1c0, 0xc039,	0xe1ff, 0xc039,		0x21, 0
	.dw 0xe240, 0xc039,	0xe27f, 0xc039,		0x21, 0
	.dw 0xe2c0, 0xc039,	0xe2ff, 0xc039,		0x21, 0
	.dw 0xe340, 0xc039,	0xe37f, 0xc039,		0x21, 0
	.dw 0xe3c0, 0xc039,	0xe3ff, 0xc039,		0x21, 0
	.dw 0xe440, 0xc039,	0xe47f, 0xc039,		0x21, 0
	.dw 0xe4c0, 0xc039,	0xe4ff, 0xc039,		0x21, 0
	.dw 0xe540, 0xc039,	0xe57f, 0xc039,		0x21, 0
	.dw 0xe5c0, 0xc039,	0xe5ff, 0xc039,		0x21, 0
	.dw 0xe640, 0xc039,	0xe67f, 0xc039,		0x21, 0
	.dw 0xe6c0, 0xc039,	0xe6ff, 0xc039,		0x21, 0
	.dw 0xe740, 0xc039,	0xe77f, 0xc039,		0x21, 0
	.dw 0xe7c0, 0xc039,	0xe7ff, 0xc039,		0x21, 0
	.dw 0xe840, 0xc039,	0xe87f, 0xc039,		0x21, 0
	.dw 0xe8c0, 0xc039,	0xe8ff, 0xc039,		0x21, 0
	.dw 0xe940, 0xc039,	0xe97f, 0xc039,		0x21, 0
	.dw 0xe9c0, 0xc039,	0xe9ff, 0xc039,		0x21, 0
	.dw 0xea40, 0xc039,	0xea7f, 0xc039,		0x21, 0
	.dw 0xeac0, 0xc039,	0xeaff, 0xc039,		0x21, 0
	.dw 0xeb40, 0xc039,	0xeb7f, 0xc039,		0x21, 0
	.dw 0xebc0, 0xc039,	0xebff, 0xc039,		0x21, 0
	.dw 0xec40, 0xc039,	0xec7f, 0xc039,		0x21, 0
	.dw 0xecc0, 0xc039,	0xecff, 0xc039,		0x21, 0
	.dw 0xed40, 0xc039,	0xed7f, 0xc039,		0x21, 0
	.dw 0xedc0, 0xc039,	0xedff, 0xc039,		0x21, 0
	.dw 0xee40, 0xc039,	0xee7f, 0xc039,		0x21, 0
	.dw 0xeec0, 0xc039,	0xeeff, 0xc039,		0x21, 0
	.dw 0xef40, 0xc039,	0xef7f, 0xc039,		0x21, 0
	.dw 0xefc0, 0xc039,	0xefff, 0xc039,		0x21, 0
	.dw 0xf040, 0xc039,	0xf07f, 0xc039,		0x21, 0
	.dw 0xf0c0, 0xc039,	0xf0ff, 0xc039,		0x21, 0
	.dw 0xf140, 0xc039,	0xf17f, 0xc039,		0x21, 0
	.dw 0xf1c0, 0xc039,	0xf1ff, 0xc039,		0x21, 0
	.dw 0xf240, 0xc039,	0xf27f, 0xc039,		0x21, 0
	.dw 0xf2c0, 0xc039,	0xf2ff, 0xc039,		0x21, 0
	.dw 0xf340, 0xc039,	0xf37f, 0xc039,		0x21, 0
	.dw 0xf3c0, 0xc039,	0xf3ff, 0xc039,		0x21, 0
	.dw 0xf440, 0xc039,	0xf47f, 0xc039,		0x21, 0
	.dw 0xf4c0, 0xc039,	0xf4ff, 0xc039,		0x21, 0
	.dw 0xf540, 0xc039,	0xf57f, 0xc039,		0x21, 0
	.dw 0xf5c0, 0xc039,	0xf5ff, 0xc039,		0x21, 0
	.dw 0xf640, 0xc039,	0xf67f, 0xc039,		0x21, 0
	.dw 0xf6c0, 0xc039,	0xf6ff, 0xc039,		0x21, 0
	.dw 0xf740, 0xc039,	0xf77f, 0xc039,		0x21, 0
	.dw 0xf7c0, 0xc039,	0xf7ff, 0xc039,		0x21, 0
	.dw 0xf840, 0xc039,	0xf87f, 0xc039,		0x21, 0
	.dw 0xf8c0, 0xc039,	0xf8ff, 0xc039,		0x21, 0
	.dw 0xf940, 0xc039,	0xf97f, 0xc039,		0x21, 0
	.dw 0xf9c0, 0xc039,	0x1fff, 0xc03a,		0x21, 0
	.dw 0x2040, 0xc03a,	0x207f, 0xc03a,		0x21, 0
	.dw 0x20c0, 0xc03a,	0x20ff, 0xc03a,		0x21, 0
	.dw 0x2140, 0xc03a,	0x217f, 0xc03a,		0x21, 0
	.dw 0x21c0, 0xc03a,	0x21ff, 0xc03a,		0x21, 0
	.dw 0x2240, 0xc03a,	0x227f, 0xc03a,		0x21, 0
	.dw 0x22c0, 0xc03a,	0x22ff, 0xc03a,		0x21, 0
	.dw 0x2340, 0xc03a,	0x237f, 0xc03a,		0x21, 0
	.dw 0x23c0, 0xc03a,	0x23ff, 0xc03a,		0x21, 0
	.dw 0x2440, 0xc03a,	0x247f, 0xc03a,		0x21, 0
	.dw 0x24c0, 0xc03a,	0x24ff, 0xc03a,		0x21, 0
	.dw 0x2540, 0xc03a,	0x257f, 0xc03a,		0x21, 0
	.dw 0x25c0, 0xc03a,	0x25ff, 0xc03a,		0x21, 0
	.dw 0x2640, 0xc03a,	0x267f, 0xc03a,		0x21, 0
	.dw 0x26c0, 0xc03a,	0x26ff, 0xc03a,		0x21, 0
	.dw 0x2740, 0xc03a,	0x277f, 0xc03a,		0x21, 0
	.dw 0x27c0, 0xc03a,	0x27ff, 0xc03a,		0x21, 0
	.dw 0x2840, 0xc03a,	0x287f, 0xc03a,		0x21, 0
	.dw 0x28c0, 0xc03a,	0x28ff, 0xc03a,		0x21, 0
	.dw 0x2940, 0xc03a,	0x297f, 0xc03a,		0x21, 0
	.dw 0x29c0, 0xc03a,	0x29ff, 0xc03a,		0x21, 0
	.dw 0x2a40, 0xc03a,	0x2a7f, 0xc03a,		0x21, 0
	.dw 0x2ac0, 0xc03a,	0x2aff, 0xc03a,		0x21, 0
	.dw 0x2b40, 0xc03a,	0x2b7f, 0xc03a,		0x21, 0
	.dw 0x2bc0, 0xc03a,	0x2bff, 0xc03a,		0x21, 0
	.dw 0x2c40, 0xc03a,	0x2c7f, 0xc03a,		0x21, 0
	.dw 0x2cc0, 0xc03a,	0x2cff, 0xc03a,		0x21, 0
	.dw 0x2d40, 0xc03a,	0x2d7f, 0xc03a,		0x21, 0
	.dw 0x2dc0, 0xc03a,	0x2dff, 0xc03a,		0x21, 0
	.dw 0x2e40, 0xc03a,	0x2e7f, 0xc03a,		0x21, 0
	.dw 0x2ec0, 0xc03a,	0x2eff, 0xc03a,		0x21, 0
	.dw 0x2f40, 0xc03a,	0x2f7f, 0xc03a,		0x21, 0
	.dw 0x2fc0, 0xc03a,	0x2fff, 0xc03a,		0x21, 0
	.dw 0x3040, 0xc03a,	0x307f, 0xc03a,		0x21, 0
	.dw 0x30c0, 0xc03a,	0x30ff, 0xc03a,		0x21, 0
	.dw 0x3140, 0xc03a,	0x317f, 0xc03a,		0x21, 0
	.dw 0x31c0, 0xc03a,	0x31ff, 0xc03a,		0x21, 0
	.dw 0x3240, 0xc03a,	0x327f, 0xc03a,		0x21, 0
	.dw 0x32c0, 0xc03a,	0x32ff, 0xc03a,		0x21, 0
	.dw 0x3340, 0xc03a,	0x337f, 0xc03a,		0x21, 0
	.dw 0x33c0, 0xc03a,	0x33ff, 0xc03a,		0x21, 0
	.dw 0x3440, 0xc03a,	0x347f, 0xc03a,		0x21, 0
	.dw 0x34c0, 0xc03a,	0x34ff, 0xc03a,		0x21, 0
	.dw 0x3540, 0xc03a,	0x357f, 0xc03a,		0x21, 0
	.dw 0x35c0, 0xc03a,	0x35ff, 0xc03a,		0x21, 0
	.dw 0x3640, 0xc03a,	0x367f, 0xc03a,		0x21, 0
	.dw 0x36c0, 0xc03a,	0x36ff, 0xc03a,		0x21, 0
	.dw 0x3740, 0xc03a,	0x377f, 0xc03a,		0x21, 0
	.dw 0x37c0, 0xc03a,	0x37ff, 0xc03a,		0x21, 0
	.dw 0x3840, 0xc03a,	0x387f, 0xc03a,		0x21, 0
	.dw 0x38c0, 0xc03a,	0x38ff, 0xc03a,		0x21, 0
	.dw 0x3940, 0xc03a,	0x397f, 0xc03a,		0x21, 0
	.dw 0x39c0, 0xc03a,	0x5fff, 0xc03a,		0x21, 0
	.dw 0x6040, 0xc03a,	0x607f, 0xc03a,		0x21, 0
	.dw 0x60c0, 0xc03a,	0x60ff, 0xc03a,		0x21, 0
	.dw 0x6140, 0xc03a,	0x617f, 0xc03a,		0x21, 0
	.dw 0x61c0, 0xc03a,	0x61ff, 0xc03a,		0x21, 0
	.dw 0x6240, 0xc03a,	0x627f, 0xc03a,		0x21, 0
	.dw 0x62c0, 0xc03a,	0x62ff, 0xc03a,		0x21, 0
	.dw 0x6340, 0xc03a,	0x637f, 0xc03a,		0x21, 0
	.dw 0x63c0, 0xc03a,	0x63ff, 0xc03a,		0x21, 0
	.dw 0x6440, 0xc03a,	0x647f, 0xc03a,		0x21, 0
	.dw 0x64c0, 0xc03a,	0x64ff, 0xc03a,		0x21, 0
	.dw 0x6540, 0xc03a,	0x657f, 0xc03a,		0x21, 0
	.dw 0x65c0, 0xc03a,	0x65ff, 0xc03a,		0x21, 0
	.dw 0x6640, 0xc03a,	0x667f, 0xc03a,		0x21, 0
	.dw 0x66c0, 0xc03a,	0x66ff, 0xc03a,		0x21, 0
	.dw 0x6740, 0xc03a,	0x677f, 0xc03a,		0x21, 0
	.dw 0x67c0, 0xc03a,	0x67ff, 0xc03a,		0x21, 0
	.dw 0x6840, 0xc03a,	0x687f, 0xc03a,		0x21, 0
	.dw 0x68c0, 0xc03a,	0x68ff, 0xc03a,		0x21, 0
	.dw 0x6940, 0xc03a,	0x697f, 0xc03a,		0x21, 0
	.dw 0x69c0, 0xc03a,	0x69ff, 0xc03a,		0x21, 0
	.dw 0x6a40, 0xc03a,	0x6a7f, 0xc03a,		0x21, 0
	.dw 0x6ac0, 0xc03a,	0x6aff, 0xc03a,		0x21, 0
	.dw 0x6b40, 0xc03a,	0x6b7f, 0xc03a,		0x21, 0
	.dw 0x6bc0, 0xc03a,	0x6bff, 0xc03a,		0x21, 0
	.dw 0x6c40, 0xc03a,	0x6c7f, 0xc03a,		0x21, 0
	.dw 0x6cc0, 0xc03a,	0x6cff, 0xc03a,		0x21, 0
	.dw 0x6d40, 0xc03a,	0x6d7f, 0xc03a,		0x21, 0
	.dw 0x6dc0, 0xc03a,	0x6dff, 0xc03a,		0x21, 0
	.dw 0x6e40, 0xc03a,	0x6e7f, 0xc03a,		0x21, 0
	.dw 0x6ec0, 0xc03a,	0x6eff, 0xc03a,		0x21, 0
	.dw 0x6f40, 0xc03a,	0x6f7f, 0xc03a,		0x21, 0
	.dw 0x6fc0, 0xc03a,	0x6fff, 0xc03a,		0x21, 0
	.dw 0x7040, 0xc03a,	0x707f, 0xc03a,		0x21, 0
	.dw 0x70c0, 0xc03a,	0x70ff, 0xc03a,		0x21, 0
	.dw 0x7140, 0xc03a,	0x717f, 0xc03a,		0x21, 0
	.dw 0x71c0, 0xc03a,	0x71ff, 0xc03a,		0x21, 0
	.dw 0x7240, 0xc03a,	0x727f, 0xc03a,		0x21, 0
	.dw 0x72c0, 0xc03a,	0x72ff, 0xc03a,		0x21, 0
	.dw 0x7340, 0xc03a,	0x737f, 0xc03a,		0x21, 0
	.dw 0x73c0, 0xc03a,	0x73ff, 0xc03a,		0x21, 0
	.dw 0x7440, 0xc03a,	0x747f, 0xc03a,		0x21, 0
	.dw 0x74c0, 0xc03a,	0x74ff, 0xc03a,		0x21, 0
	.dw 0x7540, 0xc03a,	0x757f, 0xc03a,		0x21, 0
	.dw 0x75c0, 0xc03a,	0x75ff, 0xc03a,		0x21, 0
	.dw 0x7640, 0xc03a,	0x767f, 0xc03a,		0x21, 0
	.dw 0x76c0, 0xc03a,	0x76ff, 0xc03a,		0x21, 0
	.dw 0x7740, 0xc03a,	0x777f, 0xc03a,		0x21, 0
	.dw 0x77c0, 0xc03a,	0x77ff, 0xc03a,		0x21, 0
	.dw 0x7840, 0xc03a,	0x787f, 0xc03a,		0x21, 0
	.dw 0x78c0, 0xc03a,	0x78ff, 0xc03a,		0x21, 0
	.dw 0x7940, 0xc03a,	0x797f, 0xc03a,		0x21, 0
	.dw 0x79c0, 0xc03a,	0x9fff, 0xc03a,		0x21, 0
	.dw 0xa040, 0xc03a,	0xa07f, 0xc03a,		0x21, 0
	.dw 0xa0c0, 0xc03a,	0xa0ff, 0xc03a,		0x21, 0
	.dw 0xa140, 0xc03a,	0xa17f, 0xc03a,		0x21, 0
	.dw 0xa1c0, 0xc03a,	0xa1ff, 0xc03a,		0x21, 0
	.dw 0xa240, 0xc03a,	0xa27f, 0xc03a,		0x21, 0
	.dw 0xa2c0, 0xc03a,	0xa2ff, 0xc03a,		0x21, 0
	.dw 0xa340, 0xc03a,	0xa37f, 0xc03a,		0x21, 0
	.dw 0xa3c0, 0xc03a,	0xa3ff, 0xc03a,		0x21, 0
	.dw 0xa440, 0xc03a,	0xa47f, 0xc03a,		0x21, 0
	.dw 0xa4c0, 0xc03a,	0xa4ff, 0xc03a,		0x21, 0
	.dw 0xa540, 0xc03a,	0xa57f, 0xc03a,		0x21, 0
	.dw 0xa5c0, 0xc03a,	0xa5ff, 0xc03a,		0x21, 0
	.dw 0xa640, 0xc03a,	0xa67f, 0xc03a,		0x21, 0
	.dw 0xa6c0, 0xc03a,	0xa6ff, 0xc03a,		0x21, 0
	.dw 0xa740, 0xc03a,	0xa77f, 0xc03a,		0x21, 0
	.dw 0xa7c0, 0xc03a,	0xa7ff, 0xc03a,		0x21, 0
	.dw 0xa840, 0xc03a,	0xa87f, 0xc03a,		0x21, 0
	.dw 0xa8c0, 0xc03a,	0xa8ff, 0xc03a,		0x21, 0
	.dw 0xa940, 0xc03a,	0xa97f, 0xc03a,		0x21, 0
	.dw 0xa9c0, 0xc03a,	0xa9ff, 0xc03a,		0x21, 0
	.dw 0xaa40, 0xc03a,	0xaa7f, 0xc03a,		0x21, 0
	.dw 0xaac0, 0xc03a,	0xaaff, 0xc03a,		0x21, 0
	.dw 0xab40, 0xc03a,	0xab7f, 0xc03a,		0x21, 0
	.dw 0xabc0, 0xc03a,	0xabff, 0xc03a,		0x21, 0
	.dw 0xac40, 0xc03a,	0xac7f, 0xc03a,		0x21, 0
	.dw 0xacc0, 0xc03a,	0xacff, 0xc03a,		0x21, 0
	.dw 0xad40, 0xc03a,	0xad7f, 0xc03a,		0x21, 0
	.dw 0xadc0, 0xc03a,	0xadff, 0xc03a,		0x21, 0
	.dw 0xae40, 0xc03a,	0xae7f, 0xc03a,		0x21, 0
	.dw 0xaec0, 0xc03a,	0xaeff, 0xc03a,		0x21, 0
	.dw 0xaf40, 0xc03a,	0xaf7f, 0xc03a,		0x21, 0
	.dw 0xafc0, 0xc03a,	0xafff, 0xc03a,		0x21, 0
	.dw 0xb040, 0xc03a,	0xb07f, 0xc03a,		0x21, 0
	.dw 0xb0c0, 0xc03a,	0xb0ff, 0xc03a,		0x21, 0
	.dw 0xb140, 0xc03a,	0xb17f, 0xc03a,		0x21, 0
	.dw 0xb1c0, 0xc03a,	0xb1ff, 0xc03a,		0x21, 0
	.dw 0xb240, 0xc03a,	0xb27f, 0xc03a,		0x21, 0
	.dw 0xb2c0, 0xc03a,	0xb2ff, 0xc03a,		0x21, 0
	.dw 0xb340, 0xc03a,	0xb37f, 0xc03a,		0x21, 0
	.dw 0xb3c0, 0xc03a,	0xb3ff, 0xc03a,		0x21, 0
	.dw 0xb440, 0xc03a,	0xb47f, 0xc03a,		0x21, 0
	.dw 0xb4c0, 0xc03a,	0xb4ff, 0xc03a,		0x21, 0
	.dw 0xb540, 0xc03a,	0xb57f, 0xc03a,		0x21, 0
	.dw 0xb5c0, 0xc03a,	0xb5ff, 0xc03a,		0x21, 0
	.dw 0xb640, 0xc03a,	0xb67f, 0xc03a,		0x21, 0
	.dw 0xb6c0, 0xc03a,	0xb6ff, 0xc03a,		0x21, 0
	.dw 0xb740, 0xc03a,	0xb77f, 0xc03a,		0x21, 0
	.dw 0xb7c0, 0xc03a,	0xb7ff, 0xc03a,		0x21, 0
	.dw 0xb840, 0xc03a,	0xb87f, 0xc03a,		0x21, 0
	.dw 0xb8c0, 0xc03a,	0xb8ff, 0xc03a,		0x21, 0
	.dw 0xb940, 0xc03a,	0xb97f, 0xc03a,		0x21, 0
	.dw 0xb9c0, 0xc03a,	0xdfff, 0xc03a,		0x21, 0
	.dw 0xe040, 0xc03a,	0xe07f, 0xc03a,		0x21, 0
	.dw 0xe0c0, 0xc03a,	0xe0ff, 0xc03a,		0x21, 0
	.dw 0xe140, 0xc03a,	0xe17f, 0xc03a,		0x21, 0
	.dw 0xe1c0, 0xc03a,	0xe1ff, 0xc03a,		0x21, 0
	.dw 0xe240, 0xc03a,	0xe27f, 0xc03a,		0x21, 0
	.dw 0xe2c0, 0xc03a,	0xe2ff, 0xc03a,		0x21, 0
	.dw 0xe340, 0xc03a,	0xe37f, 0xc03a,		0x21, 0
	.dw 0xe3c0, 0xc03a,	0xe3ff, 0xc03a,		0x21, 0
	.dw 0xe440, 0xc03a,	0xe47f, 0xc03a,		0x21, 0
	.dw 0xe4c0, 0xc03a,	0xe4ff, 0xc03a,		0x21, 0
	.dw 0xe540, 0xc03a,	0xe57f, 0xc03a,		0x21, 0
	.dw 0xe5c0, 0xc03a,	0xe5ff, 0xc03a,		0x21, 0
	.dw 0xe640, 0xc03a,	0xe67f, 0xc03a,		0x21, 0
	.dw 0xe6c0, 0xc03a,	0xe6ff, 0xc03a,		0x21, 0
	.dw 0xe740, 0xc03a,	0xe77f, 0xc03a,		0x21, 0
	.dw 0xe7c0, 0xc03a,	0xe7ff, 0xc03a,		0x21, 0
	.dw 0xe840, 0xc03a,	0xe87f, 0xc03a,		0x21, 0
	.dw 0xe8c0, 0xc03a,	0xe8ff, 0xc03a,		0x21, 0
	.dw 0xe940, 0xc03a,	0xe97f, 0xc03a,		0x21, 0
	.dw 0xe9c0, 0xc03a,	0xe9ff, 0xc03a,		0x21, 0
	.dw 0xea40, 0xc03a,	0xea7f, 0xc03a,		0x21, 0
	.dw 0xeac0, 0xc03a,	0xeaff, 0xc03a,		0x21, 0
	.dw 0xeb40, 0xc03a,	0xeb7f, 0xc03a,		0x21, 0
	.dw 0xebc0, 0xc03a,	0xebff, 0xc03a,		0x21, 0
	.dw 0xec40, 0xc03a,	0xec7f, 0xc03a,		0x21, 0
	.dw 0xecc0, 0xc03a,	0xecff, 0xc03a,		0x21, 0
	.dw 0xed40, 0xc03a,	0xed7f, 0xc03a,		0x21, 0
	.dw 0xedc0, 0xc03a,	0xedff, 0xc03a,		0x21, 0
	.dw 0xee40, 0xc03a,	0xee7f, 0xc03a,		0x21, 0
	.dw 0xeec0, 0xc03a,	0xeeff, 0xc03a,		0x21, 0
	.dw 0xef40, 0xc03a,	0xef7f, 0xc03a,		0x21, 0
	.dw 0xefc0, 0xc03a,	0xefff, 0xc03a,		0x21, 0
	.dw 0xf040, 0xc03a,	0xf07f, 0xc03a,		0x21, 0
	.dw 0xf0c0, 0xc03a,	0xf0ff, 0xc03a,		0x21, 0
	.dw 0xf140, 0xc03a,	0xf17f, 0xc03a,		0x21, 0
	.dw 0xf1c0, 0xc03a,	0xf1ff, 0xc03a,		0x21, 0
	.dw 0xf240, 0xc03a,	0xf27f, 0xc03a,		0x21, 0
	.dw 0xf2c0, 0xc03a,	0xf2ff, 0xc03a,		0x21, 0
	.dw 0xf340, 0xc03a,	0xf37f, 0xc03a,		0x21, 0
	.dw 0xf3c0, 0xc03a,	0xf3ff, 0xc03a,		0x21, 0
	.dw 0xf440, 0xc03a,	0xf47f, 0xc03a,		0x21, 0
	.dw 0xf4c0, 0xc03a,	0xf4ff, 0xc03a,		0x21, 0
	.dw 0xf540, 0xc03a,	0xf57f, 0xc03a,		0x21, 0
	.dw 0xf5c0, 0xc03a,	0xf5ff, 0xc03a,		0x21, 0
	.dw 0xf640, 0xc03a,	0xf67f, 0xc03a,		0x21, 0
	.dw 0xf6c0, 0xc03a,	0xf6ff, 0xc03a,		0x21, 0
	.dw 0xf740, 0xc03a,	0xf77f, 0xc03a,		0x21, 0
	.dw 0xf7c0, 0xc03a,	0xf7ff, 0xc03a,		0x21, 0
	.dw 0xf840, 0xc03a,	0xf87f, 0xc03a,		0x21, 0
	.dw 0xf8c0, 0xc03a,	0xf8ff, 0xc03a,		0x21, 0
	.dw 0xf940, 0xc03a,	0xf97f, 0xc03a,		0x21, 0
	.dw 0xf9c0, 0xc03a,	0xffff, 0xc03b,		0x21, 0
	.dw 0x0040, 0xc03c,	0x007f, 0xc03c,		0x21, 0
	.dw 0x00c0, 0xc03c,	0x00ff, 0xc03c,		0x21, 0
	.dw 0x0140, 0xc03c,	0x017f, 0xc03c,		0x21, 0
	.dw 0x01c0, 0xc03c,	0x01ff, 0xc03c,		0x21, 0
	.dw 0x0240, 0xc03c,	0x027f, 0xc03c,		0x21, 0
	.dw 0x02c0, 0xc03c,	0x02ff, 0xc03c,		0x21, 0
	.dw 0x0340, 0xc03c,	0x037f, 0xc03c,		0x21, 0
	.dw 0x03c0, 0xc03c,	0x03ff, 0xc03c,		0x21, 0
	.dw 0x0440, 0xc03c,	0x047f, 0xc03c,		0x21, 0
	.dw 0x04c0, 0xc03c,	0x04ff, 0xc03c,		0x21, 0
	.dw 0x0540, 0xc03c,	0x057f, 0xc03c,		0x21, 0
	.dw 0x05c0, 0xc03c,	0x05ff, 0xc03c,		0x21, 0
	.dw 0x0640, 0xc03c,	0x067f, 0xc03c,		0x21, 0
	.dw 0x06c0, 0xc03c,	0x06ff, 0xc03c,		0x21, 0
	.dw 0x0740, 0xc03c,	0x077f, 0xc03c,		0x21, 0
	.dw 0x07c0, 0xc03c,	0x07ff, 0xc03c,		0x21, 0
	.dw 0x0840, 0xc03c,	0x087f, 0xc03c,		0x21, 0
	.dw 0x08c0, 0xc03c,	0x08ff, 0xc03c,		0x21, 0
	.dw 0x0940, 0xc03c,	0x097f, 0xc03c,		0x21, 0
	.dw 0x09c0, 0xc03c,	0x09ff, 0xc03c,		0x21, 0
	.dw 0x0a40, 0xc03c,	0x0a7f, 0xc03c,		0x21, 0
	.dw 0x0ac0, 0xc03c,	0x0aff, 0xc03c,		0x21, 0
	.dw 0x0b40, 0xc03c,	0x0b7f, 0xc03c,		0x21, 0
	.dw 0x0bc0, 0xc03c,	0x0bff, 0xc03c,		0x21, 0
	.dw 0x0c40, 0xc03c,	0x0c7f, 0xc03c,		0x21, 0
	.dw 0x0cc0, 0xc03c,	0x0cff, 0xc03c,		0x21, 0
	.dw 0x0d40, 0xc03c,	0x0d7f, 0xc03c,		0x21, 0
	.dw 0x0dc0, 0xc03c,	0x0dff, 0xc03c,		0x21, 0
	.dw 0x0e40, 0xc03c,	0x0e7f, 0xc03c,		0x21, 0
	.dw 0x0ec0, 0xc03c,	0x0eff, 0xc03c,		0x21, 0
	.dw 0x0f40, 0xc03c,	0x0f7f, 0xc03c,		0x21, 0
	.dw 0x0fc0, 0xc03c,	0x0fff, 0xc03c,		0x21, 0
	.dw 0x1040, 0xc03c,	0x107f, 0xc03c,		0x21, 0
	.dw 0x10c0, 0xc03c,	0x10ff, 0xc03c,		0x21, 0
	.dw 0x1140, 0xc03c,	0x117f, 0xc03c,		0x21, 0
	.dw 0x11c0, 0xc03c,	0x11ff, 0xc03c,		0x21, 0
	.dw 0x1240, 0xc03c,	0x127f, 0xc03c,		0x21, 0
	.dw 0x12c0, 0xc03c,	0x12ff, 0xc03c,		0x21, 0
	.dw 0x1340, 0xc03c,	0x137f, 0xc03c,		0x21, 0
	.dw 0x13c0, 0xc03c,	0x13ff, 0xc03c,		0x21, 0
	.dw 0x1440, 0xc03c,	0x147f, 0xc03c,		0x21, 0
	.dw 0x14c0, 0xc03c,	0x14ff, 0xc03c,		0x21, 0
	.dw 0x1540, 0xc03c,	0x157f, 0xc03c,		0x21, 0
	.dw 0x15c0, 0xc03c,	0x15ff, 0xc03c,		0x21, 0
	.dw 0x1640, 0xc03c,	0x167f, 0xc03c,		0x21, 0
	.dw 0x16c0, 0xc03c,	0x16ff, 0xc03c,		0x21, 0
	.dw 0x1740, 0xc03c,	0x177f, 0xc03c,		0x21, 0
	.dw 0x17c0, 0xc03c,	0x17ff, 0xc03c,		0x21, 0
	.dw 0x1840, 0xc03c,	0x187f, 0xc03c,		0x21, 0
	.dw 0x18c0, 0xc03c,	0x18ff, 0xc03c,		0x21, 0
	.dw 0x1940, 0xc03c,	0x197f, 0xc03c,		0x21, 0
	.dw 0x19c0, 0xc03c,	0x1fff, 0xc03c,		0x21, 0
	.dw 0x2040, 0xc03c,	0x207f, 0xc03c,		0x21, 0
	.dw 0x20c0, 0xc03c,	0x20ff, 0xc03c,		0x21, 0
	.dw 0x2140, 0xc03c,	0x217f, 0xc03c,		0x21, 0
	.dw 0x21c0, 0xc03c,	0x21ff, 0xc03c,		0x21, 0
	.dw 0x2240, 0xc03c,	0x227f, 0xc03c,		0x21, 0
	.dw 0x22c0, 0xc03c,	0x22ff, 0xc03c,		0x21, 0
	.dw 0x2340, 0xc03c,	0x237f, 0xc03c,		0x21, 0
	.dw 0x23c0, 0xc03c,	0x23ff, 0xc03c,		0x21, 0
	.dw 0x2440, 0xc03c,	0x247f, 0xc03c,		0x21, 0
	.dw 0x24c0, 0xc03c,	0x24ff, 0xc03c,		0x21, 0
	.dw 0x2540, 0xc03c,	0x257f, 0xc03c,		0x21, 0
	.dw 0x25c0, 0xc03c,	0x25ff, 0xc03c,		0x21, 0
	.dw 0x2640, 0xc03c,	0x267f, 0xc03c,		0x21, 0
	.dw 0x26c0, 0xc03c,	0x26ff, 0xc03c,		0x21, 0
	.dw 0x2740, 0xc03c,	0x277f, 0xc03c,		0x21, 0
	.dw 0x27c0, 0xc03c,	0x27ff, 0xc03c,		0x21, 0
	.dw 0x2840, 0xc03c,	0x287f, 0xc03c,		0x21, 0
	.dw 0x28c0, 0xc03c,	0x28ff, 0xc03c,		0x21, 0
	.dw 0x2940, 0xc03c,	0x297f, 0xc03c,		0x21, 0
	.dw 0x29c0, 0xc03c,	0x29ff, 0xc03c,		0x21, 0
	.dw 0x2a40, 0xc03c,	0x2a7f, 0xc03c,		0x21, 0
	.dw 0x2ac0, 0xc03c,	0x2aff, 0xc03c,		0x21, 0
	.dw 0x2b40, 0xc03c,	0x2b7f, 0xc03c,		0x21, 0
	.dw 0x2bc0, 0xc03c,	0x2bff, 0xc03c,		0x21, 0
	.dw 0x2c40, 0xc03c,	0x2c7f, 0xc03c,		0x21, 0
	.dw 0x2cc0, 0xc03c,	0x2cff, 0xc03c,		0x21, 0
	.dw 0x2d40, 0xc03c,	0x2d7f, 0xc03c,		0x21, 0
	.dw 0x2dc0, 0xc03c,	0x2dff, 0xc03c,		0x21, 0
	.dw 0x2e40, 0xc03c,	0x2e7f, 0xc03c,		0x21, 0
	.dw 0x2ec0, 0xc03c,	0x2eff, 0xc03c,		0x21, 0
	.dw 0x2f40, 0xc03c,	0x2f7f, 0xc03c,		0x21, 0
	.dw 0x2fc0, 0xc03c,	0x2fff, 0xc03c,		0x21, 0
	.dw 0x3040, 0xc03c,	0x307f, 0xc03c,		0x21, 0
	.dw 0x30c0, 0xc03c,	0x30ff, 0xc03c,		0x21, 0
	.dw 0x3140, 0xc03c,	0x317f, 0xc03c,		0x21, 0
	.dw 0x31c0, 0xc03c,	0x31ff, 0xc03c,		0x21, 0
	.dw 0x3240, 0xc03c,	0x327f, 0xc03c,		0x21, 0
	.dw 0x32c0, 0xc03c,	0x32ff, 0xc03c,		0x21, 0
	.dw 0x3340, 0xc03c,	0x337f, 0xc03c,		0x21, 0
	.dw 0x33c0, 0xc03c,	0x33ff, 0xc03c,		0x21, 0
	.dw 0x3440, 0xc03c,	0x347f, 0xc03c,		0x21, 0
	.dw 0x34c0, 0xc03c,	0x34ff, 0xc03c,		0x21, 0
	.dw 0x3540, 0xc03c,	0x357f, 0xc03c,		0x21, 0
	.dw 0x35c0, 0xc03c,	0x35ff, 0xc03c,		0x21, 0
	.dw 0x3640, 0xc03c,	0x367f, 0xc03c,		0x21, 0
	.dw 0x36c0, 0xc03c,	0x36ff, 0xc03c,		0x21, 0
	.dw 0x3740, 0xc03c,	0x377f, 0xc03c,		0x21, 0
	.dw 0x37c0, 0xc03c,	0x37ff, 0xc03c,		0x21, 0
	.dw 0x3840, 0xc03c,	0x387f, 0xc03c,		0x21, 0
	.dw 0x38c0, 0xc03c,	0x38ff, 0xc03c,		0x21, 0
	.dw 0x3940, 0xc03c,	0x397f, 0xc03c,		0x21, 0
	.dw 0x39c0, 0xc03c,	0x3fff, 0xc03c,		0x21, 0
	.dw 0x4040, 0xc03c,	0x407f, 0xc03c,		0x21, 0
	.dw 0x40c0, 0xc03c,	0x40ff, 0xc03c,		0x21, 0
	.dw 0x4140, 0xc03c,	0x417f, 0xc03c,		0x21, 0
	.dw 0x41c0, 0xc03c,	0x41ff, 0xc03c,		0x21, 0
	.dw 0x4240, 0xc03c,	0x427f, 0xc03c,		0x21, 0
	.dw 0x42c0, 0xc03c,	0x42ff, 0xc03c,		0x21, 0
	.dw 0x4340, 0xc03c,	0x437f, 0xc03c,		0x21, 0
	.dw 0x43c0, 0xc03c,	0x43ff, 0xc03c,		0x21, 0
	.dw 0x4440, 0xc03c,	0x447f, 0xc03c,		0x21, 0
	.dw 0x44c0, 0xc03c,	0x44ff, 0xc03c,		0x21, 0
	.dw 0x4540, 0xc03c,	0x457f, 0xc03c,		0x21, 0
	.dw 0x45c0, 0xc03c,	0x45ff, 0xc03c,		0x21, 0
	.dw 0x4640, 0xc03c,	0x467f, 0xc03c,		0x21, 0
	.dw 0x46c0, 0xc03c,	0x46ff, 0xc03c,		0x21, 0
	.dw 0x4740, 0xc03c,	0x477f, 0xc03c,		0x21, 0
	.dw 0x47c0, 0xc03c,	0x47ff, 0xc03c,		0x21, 0
	.dw 0x4840, 0xc03c,	0x487f, 0xc03c,		0x21, 0
	.dw 0x48c0, 0xc03c,	0x48ff, 0xc03c,		0x21, 0
	.dw 0x4940, 0xc03c,	0x497f, 0xc03c,		0x21, 0
	.dw 0x49c0, 0xc03c,	0x49ff, 0xc03c,		0x21, 0
	.dw 0x4a40, 0xc03c,	0x4a7f, 0xc03c,		0x21, 0
	.dw 0x4ac0, 0xc03c,	0x4aff, 0xc03c,		0x21, 0
	.dw 0x4b40, 0xc03c,	0x4b7f, 0xc03c,		0x21, 0
	.dw 0x4bc0, 0xc03c,	0x4bff, 0xc03c,		0x21, 0
	.dw 0x4c40, 0xc03c,	0x4c7f, 0xc03c,		0x21, 0
	.dw 0x4cc0, 0xc03c,	0x4cff, 0xc03c,		0x21, 0
	.dw 0x4d40, 0xc03c,	0x4d7f, 0xc03c,		0x21, 0
	.dw 0x4dc0, 0xc03c,	0x4dff, 0xc03c,		0x21, 0
	.dw 0x4e40, 0xc03c,	0x4e7f, 0xc03c,		0x21, 0
	.dw 0x4ec0, 0xc03c,	0x4eff, 0xc03c,		0x21, 0
	.dw 0x4f40, 0xc03c,	0x4f7f, 0xc03c,		0x21, 0
	.dw 0x4fc0, 0xc03c,	0x4fff, 0xc03c,		0x21, 0
	.dw 0x5040, 0xc03c,	0x507f, 0xc03c,		0x21, 0
	.dw 0x50c0, 0xc03c,	0x50ff, 0xc03c,		0x21, 0
	.dw 0x5140, 0xc03c,	0x517f, 0xc03c,		0x21, 0
	.dw 0x51c0, 0xc03c,	0x51ff, 0xc03c,		0x21, 0
	.dw 0x5240, 0xc03c,	0x527f, 0xc03c,		0x21, 0
	.dw 0x52c0, 0xc03c,	0x52ff, 0xc03c,		0x21, 0
	.dw 0x5340, 0xc03c,	0x537f, 0xc03c,		0x21, 0
	.dw 0x53c0, 0xc03c,	0x53ff, 0xc03c,		0x21, 0
	.dw 0x5440, 0xc03c,	0x547f, 0xc03c,		0x21, 0
	.dw 0x54c0, 0xc03c,	0x54ff, 0xc03c,		0x21, 0
	.dw 0x5540, 0xc03c,	0x557f, 0xc03c,		0x21, 0
	.dw 0x55c0, 0xc03c,	0x55ff, 0xc03c,		0x21, 0
	.dw 0x5640, 0xc03c,	0x567f, 0xc03c,		0x21, 0
	.dw 0x56c0, 0xc03c,	0x56ff, 0xc03c,		0x21, 0
	.dw 0x5740, 0xc03c,	0x577f, 0xc03c,		0x21, 0
	.dw 0x57c0, 0xc03c,	0x57ff, 0xc03c,		0x21, 0
	.dw 0x5840, 0xc03c,	0x587f, 0xc03c,		0x21, 0
	.dw 0x58c0, 0xc03c,	0x58ff, 0xc03c,		0x21, 0
	.dw 0x5940, 0xc03c,	0x597f, 0xc03c,		0x21, 0
	.dw 0x59c0, 0xc03c,	0x5fff, 0xc03c,		0x21, 0
	.dw 0x6040, 0xc03c,	0x607f, 0xc03c,		0x21, 0
	.dw 0x60c0, 0xc03c,	0x60ff, 0xc03c,		0x21, 0
	.dw 0x6140, 0xc03c,	0x617f, 0xc03c,		0x21, 0
	.dw 0x61c0, 0xc03c,	0x61ff, 0xc03c,		0x21, 0
	.dw 0x6240, 0xc03c,	0x627f, 0xc03c,		0x21, 0
	.dw 0x62c0, 0xc03c,	0x62ff, 0xc03c,		0x21, 0
	.dw 0x6340, 0xc03c,	0x637f, 0xc03c,		0x21, 0
	.dw 0x63c0, 0xc03c,	0x63ff, 0xc03c,		0x21, 0
	.dw 0x6440, 0xc03c,	0x647f, 0xc03c,		0x21, 0
	.dw 0x64c0, 0xc03c,	0x64ff, 0xc03c,		0x21, 0
	.dw 0x6540, 0xc03c,	0x657f, 0xc03c,		0x21, 0
	.dw 0x65c0, 0xc03c,	0x65ff, 0xc03c,		0x21, 0
	.dw 0x6640, 0xc03c,	0x667f, 0xc03c,		0x21, 0
	.dw 0x66c0, 0xc03c,	0x66ff, 0xc03c,		0x21, 0
	.dw 0x6740, 0xc03c,	0x677f, 0xc03c,		0x21, 0
	.dw 0x67c0, 0xc03c,	0x67ff, 0xc03c,		0x21, 0
	.dw 0x6840, 0xc03c,	0x687f, 0xc03c,		0x21, 0
	.dw 0x68c0, 0xc03c,	0x68ff, 0xc03c,		0x21, 0
	.dw 0x6940, 0xc03c,	0x697f, 0xc03c,		0x21, 0
	.dw 0x69c0, 0xc03c,	0x69ff, 0xc03c,		0x21, 0
	.dw 0x6a40, 0xc03c,	0x6a7f, 0xc03c,		0x21, 0
	.dw 0x6ac0, 0xc03c,	0x6aff, 0xc03c,		0x21, 0
	.dw 0x6b40, 0xc03c,	0x6b7f, 0xc03c,		0x21, 0
	.dw 0x6bc0, 0xc03c,	0x6bff, 0xc03c,		0x21, 0
	.dw 0x6c40, 0xc03c,	0x6c7f, 0xc03c,		0x21, 0
	.dw 0x6cc0, 0xc03c,	0x6cff, 0xc03c,		0x21, 0
	.dw 0x6d40, 0xc03c,	0x6d7f, 0xc03c,		0x21, 0
	.dw 0x6dc0, 0xc03c,	0x6dff, 0xc03c,		0x21, 0
	.dw 0x6e40, 0xc03c,	0x6e7f, 0xc03c,		0x21, 0
	.dw 0x6ec0, 0xc03c,	0x6eff, 0xc03c,		0x21, 0
	.dw 0x6f40, 0xc03c,	0x6f7f, 0xc03c,		0x21, 0
	.dw 0x6fc0, 0xc03c,	0x6fff, 0xc03c,		0x21, 0
	.dw 0x7040, 0xc03c,	0x707f, 0xc03c,		0x21, 0
	.dw 0x70c0, 0xc03c,	0x70ff, 0xc03c,		0x21, 0
	.dw 0x7140, 0xc03c,	0x717f, 0xc03c,		0x21, 0
	.dw 0x71c0, 0xc03c,	0x71ff, 0xc03c,		0x21, 0
	.dw 0x7240, 0xc03c,	0x727f, 0xc03c,		0x21, 0
	.dw 0x72c0, 0xc03c,	0x72ff, 0xc03c,		0x21, 0
	.dw 0x7340, 0xc03c,	0x737f, 0xc03c,		0x21, 0
	.dw 0x73c0, 0xc03c,	0x73ff, 0xc03c,		0x21, 0
	.dw 0x7440, 0xc03c,	0x747f, 0xc03c,		0x21, 0
	.dw 0x74c0, 0xc03c,	0x74ff, 0xc03c,		0x21, 0
	.dw 0x7540, 0xc03c,	0x757f, 0xc03c,		0x21, 0
	.dw 0x75c0, 0xc03c,	0x75ff, 0xc03c,		0x21, 0
	.dw 0x7640, 0xc03c,	0x767f, 0xc03c,		0x21, 0
	.dw 0x76c0, 0xc03c,	0x76ff, 0xc03c,		0x21, 0
	.dw 0x7740, 0xc03c,	0x777f, 0xc03c,		0x21, 0
	.dw 0x77c0, 0xc03c,	0x77ff, 0xc03c,		0x21, 0
	.dw 0x7840, 0xc03c,	0x787f, 0xc03c,		0x21, 0
	.dw 0x78c0, 0xc03c,	0x78ff, 0xc03c,		0x21, 0
	.dw 0x7940, 0xc03c,	0x797f, 0xc03c,		0x21, 0
	.dw 0x79c0, 0xc03c,	0x7fff, 0xc03c,		0x21, 0
	.dw 0x8040, 0xc03c,	0x807f, 0xc03c,		0x21, 0
	.dw 0x80c0, 0xc03c,	0x80ff, 0xc03c,		0x21, 0
	.dw 0x8140, 0xc03c,	0x817f, 0xc03c,		0x21, 0
	.dw 0x81c0, 0xc03c,	0x81ff, 0xc03c,		0x21, 0
	.dw 0x8240, 0xc03c,	0x827f, 0xc03c,		0x21, 0
	.dw 0x82c0, 0xc03c,	0x82ff, 0xc03c,		0x21, 0
	.dw 0x8340, 0xc03c,	0x837f, 0xc03c,		0x21, 0
	.dw 0x83c0, 0xc03c,	0x83ff, 0xc03c,		0x21, 0
	.dw 0x8440, 0xc03c,	0x847f, 0xc03c,		0x21, 0
	.dw 0x84c0, 0xc03c,	0x84ff, 0xc03c,		0x21, 0
	.dw 0x8540, 0xc03c,	0x857f, 0xc03c,		0x21, 0
	.dw 0x85c0, 0xc03c,	0x85ff, 0xc03c,		0x21, 0
	.dw 0x8640, 0xc03c,	0x867f, 0xc03c,		0x21, 0
	.dw 0x86c0, 0xc03c,	0x86ff, 0xc03c,		0x21, 0
	.dw 0x8740, 0xc03c,	0x877f, 0xc03c,		0x21, 0
	.dw 0x87c0, 0xc03c,	0x87ff, 0xc03c,		0x21, 0
	.dw 0x8840, 0xc03c,	0x887f, 0xc03c,		0x21, 0
	.dw 0x88c0, 0xc03c,	0x88ff, 0xc03c,		0x21, 0
	.dw 0x8940, 0xc03c,	0x897f, 0xc03c,		0x21, 0
	.dw 0x89c0, 0xc03c,	0x89ff, 0xc03c,		0x21, 0
	.dw 0x8a40, 0xc03c,	0x8a7f, 0xc03c,		0x21, 0
	.dw 0x8ac0, 0xc03c,	0x8aff, 0xc03c,		0x21, 0
	.dw 0x8b40, 0xc03c,	0x8b7f, 0xc03c,		0x21, 0
	.dw 0x8bc0, 0xc03c,	0x8bff, 0xc03c,		0x21, 0
	.dw 0x8c40, 0xc03c,	0x8c7f, 0xc03c,		0x21, 0
	.dw 0x8cc0, 0xc03c,	0x8cff, 0xc03c,		0x21, 0
	.dw 0x8d40, 0xc03c,	0x8d7f, 0xc03c,		0x21, 0
	.dw 0x8dc0, 0xc03c,	0x8dff, 0xc03c,		0x21, 0
	.dw 0x8e40, 0xc03c,	0x8e7f, 0xc03c,		0x21, 0
	.dw 0x8ec0, 0xc03c,	0x8eff, 0xc03c,		0x21, 0
	.dw 0x8f40, 0xc03c,	0x8f7f, 0xc03c,		0x21, 0
	.dw 0x8fc0, 0xc03c,	0x8fff, 0xc03c,		0x21, 0
	.dw 0x9040, 0xc03c,	0x907f, 0xc03c,		0x21, 0
	.dw 0x90c0, 0xc03c,	0x90ff, 0xc03c,		0x21, 0
	.dw 0x9140, 0xc03c,	0x917f, 0xc03c,		0x21, 0
	.dw 0x91c0, 0xc03c,	0x91ff, 0xc03c,		0x21, 0
	.dw 0x9240, 0xc03c,	0x927f, 0xc03c,		0x21, 0
	.dw 0x92c0, 0xc03c,	0x92ff, 0xc03c,		0x21, 0
	.dw 0x9340, 0xc03c,	0x937f, 0xc03c,		0x21, 0
	.dw 0x93c0, 0xc03c,	0x93ff, 0xc03c,		0x21, 0
	.dw 0x9440, 0xc03c,	0x947f, 0xc03c,		0x21, 0
	.dw 0x94c0, 0xc03c,	0x94ff, 0xc03c,		0x21, 0
	.dw 0x9540, 0xc03c,	0x957f, 0xc03c,		0x21, 0
	.dw 0x95c0, 0xc03c,	0x95ff, 0xc03c,		0x21, 0
	.dw 0x9640, 0xc03c,	0x967f, 0xc03c,		0x21, 0
	.dw 0x96c0, 0xc03c,	0x96ff, 0xc03c,		0x21, 0
	.dw 0x9740, 0xc03c,	0x977f, 0xc03c,		0x21, 0
	.dw 0x97c0, 0xc03c,	0x97ff, 0xc03c,		0x21, 0
	.dw 0x9840, 0xc03c,	0x987f, 0xc03c,		0x21, 0
	.dw 0x98c0, 0xc03c,	0x98ff, 0xc03c,		0x21, 0
	.dw 0x9940, 0xc03c,	0x997f, 0xc03c,		0x21, 0
	.dw 0x99c0, 0xc03c,	0x9fff, 0xc03c,		0x21, 0
	.dw 0xa040, 0xc03c,	0xa07f, 0xc03c,		0x21, 0
	.dw 0xa0c0, 0xc03c,	0xa0ff, 0xc03c,		0x21, 0
	.dw 0xa140, 0xc03c,	0xa17f, 0xc03c,		0x21, 0
	.dw 0xa1c0, 0xc03c,	0xa1ff, 0xc03c,		0x21, 0
	.dw 0xa240, 0xc03c,	0xa27f, 0xc03c,		0x21, 0
	.dw 0xa2c0, 0xc03c,	0xa2ff, 0xc03c,		0x21, 0
	.dw 0xa340, 0xc03c,	0xa37f, 0xc03c,		0x21, 0
	.dw 0xa3c0, 0xc03c,	0xa3ff, 0xc03c,		0x21, 0
	.dw 0xa440, 0xc03c,	0xa47f, 0xc03c,		0x21, 0
	.dw 0xa4c0, 0xc03c,	0xa4ff, 0xc03c,		0x21, 0
	.dw 0xa540, 0xc03c,	0xa57f, 0xc03c,		0x21, 0
	.dw 0xa5c0, 0xc03c,	0xa5ff, 0xc03c,		0x21, 0
	.dw 0xa640, 0xc03c,	0xa67f, 0xc03c,		0x21, 0
	.dw 0xa6c0, 0xc03c,	0xa6ff, 0xc03c,		0x21, 0
	.dw 0xa740, 0xc03c,	0xa77f, 0xc03c,		0x21, 0
	.dw 0xa7c0, 0xc03c,	0xa7ff, 0xc03c,		0x21, 0
	.dw 0xa840, 0xc03c,	0xa87f, 0xc03c,		0x21, 0
	.dw 0xa8c0, 0xc03c,	0xa8ff, 0xc03c,		0x21, 0
	.dw 0xa940, 0xc03c,	0xa97f, 0xc03c,		0x21, 0
	.dw 0xa9c0, 0xc03c,	0xa9ff, 0xc03c,		0x21, 0
	.dw 0xaa40, 0xc03c,	0xaa7f, 0xc03c,		0x21, 0
	.dw 0xaac0, 0xc03c,	0xaaff, 0xc03c,		0x21, 0
	.dw 0xab40, 0xc03c,	0xab7f, 0xc03c,		0x21, 0
	.dw 0xabc0, 0xc03c,	0xabff, 0xc03c,		0x21, 0
	.dw 0xac40, 0xc03c,	0xac7f, 0xc03c,		0x21, 0
	.dw 0xacc0, 0xc03c,	0xacff, 0xc03c,		0x21, 0
	.dw 0xad40, 0xc03c,	0xad7f, 0xc03c,		0x21, 0
	.dw 0xadc0, 0xc03c,	0xadff, 0xc03c,		0x21, 0
	.dw 0xae40, 0xc03c,	0xae7f, 0xc03c,		0x21, 0
	.dw 0xaec0, 0xc03c,	0xaeff, 0xc03c,		0x21, 0
	.dw 0xaf40, 0xc03c,	0xaf7f, 0xc03c,		0x21, 0
	.dw 0xafc0, 0xc03c,	0xafff, 0xc03c,		0x21, 0
	.dw 0xb040, 0xc03c,	0xb07f, 0xc03c,		0x21, 0
	.dw 0xb0c0, 0xc03c,	0xb0ff, 0xc03c,		0x21, 0
	.dw 0xb140, 0xc03c,	0xb17f, 0xc03c,		0x21, 0
	.dw 0xb1c0, 0xc03c,	0xb1ff, 0xc03c,		0x21, 0
	.dw 0xb240, 0xc03c,	0xb27f, 0xc03c,		0x21, 0
	.dw 0xb2c0, 0xc03c,	0xb2ff, 0xc03c,		0x21, 0
	.dw 0xb340, 0xc03c,	0xb37f, 0xc03c,		0x21, 0
	.dw 0xb3c0, 0xc03c,	0xb3ff, 0xc03c,		0x21, 0
	.dw 0xb440, 0xc03c,	0xb47f, 0xc03c,		0x21, 0
	.dw 0xb4c0, 0xc03c,	0xb4ff, 0xc03c,		0x21, 0
	.dw 0xb540, 0xc03c,	0xb57f, 0xc03c,		0x21, 0
	.dw 0xb5c0, 0xc03c,	0xb5ff, 0xc03c,		0x21, 0
	.dw 0xb640, 0xc03c,	0xb67f, 0xc03c,		0x21, 0
	.dw 0xb6c0, 0xc03c,	0xb6ff, 0xc03c,		0x21, 0
	.dw 0xb740, 0xc03c,	0xb77f, 0xc03c,		0x21, 0
	.dw 0xb7c0, 0xc03c,	0xb7ff, 0xc03c,		0x21, 0
	.dw 0xb840, 0xc03c,	0xb87f, 0xc03c,		0x21, 0
	.dw 0xb8c0, 0xc03c,	0xb8ff, 0xc03c,		0x21, 0
	.dw 0xb940, 0xc03c,	0xb97f, 0xc03c,		0x21, 0
	.dw 0xb9c0, 0xc03c,	0xbfff, 0xc03c,		0x21, 0
	.dw 0xc040, 0xc03c,	0xc07f, 0xc03c,		0x21, 0
	.dw 0xc0c0, 0xc03c,	0xc0ff, 0xc03c,		0x21, 0
	.dw 0xc140, 0xc03c,	0xc17f, 0xc03c,		0x21, 0
	.dw 0xc1c0, 0xc03c,	0xc1ff, 0xc03c,		0x21, 0
	.dw 0xc240, 0xc03c,	0xc27f, 0xc03c,		0x21, 0
	.dw 0xc2c0, 0xc03c,	0xc2ff, 0xc03c,		0x21, 0
	.dw 0xc340, 0xc03c,	0xc37f, 0xc03c,		0x21, 0
	.dw 0xc3c0, 0xc03c,	0xc3ff, 0xc03c,		0x21, 0
	.dw 0xc440, 0xc03c,	0xc47f, 0xc03c,		0x21, 0
	.dw 0xc4c0, 0xc03c,	0xc4ff, 0xc03c,		0x21, 0
	.dw 0xc540, 0xc03c,	0xc57f, 0xc03c,		0x21, 0
	.dw 0xc5c0, 0xc03c,	0xc5ff, 0xc03c,		0x21, 0
	.dw 0xc640, 0xc03c,	0xc67f, 0xc03c,		0x21, 0
	.dw 0xc6c0, 0xc03c,	0xc6ff, 0xc03c,		0x21, 0
	.dw 0xc740, 0xc03c,	0xc77f, 0xc03c,		0x21, 0
	.dw 0xc7c0, 0xc03c,	0xc7ff, 0xc03c,		0x21, 0
	.dw 0xc840, 0xc03c,	0xc87f, 0xc03c,		0x21, 0
	.dw 0xc8c0, 0xc03c,	0xc8ff, 0xc03c,		0x21, 0
	.dw 0xc940, 0xc03c,	0xc97f, 0xc03c,		0x21, 0
	.dw 0xc9c0, 0xc03c,	0xc9ff, 0xc03c,		0x21, 0
	.dw 0xca40, 0xc03c,	0xca7f, 0xc03c,		0x21, 0
	.dw 0xcac0, 0xc03c,	0xcaff, 0xc03c,		0x21, 0
	.dw 0xcb40, 0xc03c,	0xcb7f, 0xc03c,		0x21, 0
	.dw 0xcbc0, 0xc03c,	0xcbff, 0xc03c,		0x21, 0
	.dw 0xcc40, 0xc03c,	0xcc7f, 0xc03c,		0x21, 0
	.dw 0xccc0, 0xc03c,	0xccff, 0xc03c,		0x21, 0
	.dw 0xcd40, 0xc03c,	0xcd7f, 0xc03c,		0x21, 0
	.dw 0xcdc0, 0xc03c,	0xcdff, 0xc03c,		0x21, 0
	.dw 0xce40, 0xc03c,	0xce7f, 0xc03c,		0x21, 0
	.dw 0xcec0, 0xc03c,	0xceff, 0xc03c,		0x21, 0
	.dw 0xcf40, 0xc03c,	0xcf7f, 0xc03c,		0x21, 0
	.dw 0xcfc0, 0xc03c,	0xcfff, 0xc03c,		0x21, 0
	.dw 0xd040, 0xc03c,	0xd07f, 0xc03c,		0x21, 0
	.dw 0xd0c0, 0xc03c,	0xd0ff, 0xc03c,		0x21, 0
	.dw 0xd140, 0xc03c,	0xd17f, 0xc03c,		0x21, 0
	.dw 0xd1c0, 0xc03c,	0xd1ff, 0xc03c,		0x21, 0
	.dw 0xd240, 0xc03c,	0xd27f, 0xc03c,		0x21, 0
	.dw 0xd2c0, 0xc03c,	0xd2ff, 0xc03c,		0x21, 0
	.dw 0xd340, 0xc03c,	0xd37f, 0xc03c,		0x21, 0
	.dw 0xd3c0, 0xc03c,	0xd3ff, 0xc03c,		0x21, 0
	.dw 0xd440, 0xc03c,	0xd47f, 0xc03c,		0x21, 0
	.dw 0xd4c0, 0xc03c,	0xd4ff, 0xc03c,		0x21, 0
	.dw 0xd540, 0xc03c,	0xd57f, 0xc03c,		0x21, 0
	.dw 0xd5c0, 0xc03c,	0xd5ff, 0xc03c,		0x21, 0
	.dw 0xd640, 0xc03c,	0xd67f, 0xc03c,		0x21, 0
	.dw 0xd6c0, 0xc03c,	0xd6ff, 0xc03c,		0x21, 0
	.dw 0xd740, 0xc03c,	0xd77f, 0xc03c,		0x21, 0
	.dw 0xd7c0, 0xc03c,	0xd7ff, 0xc03c,		0x21, 0
	.dw 0xd840, 0xc03c,	0xd87f, 0xc03c,		0x21, 0
	.dw 0xd8c0, 0xc03c,	0xd8ff, 0xc03c,		0x21, 0
	.dw 0xd940, 0xc03c,	0xd97f, 0xc03c,		0x21, 0
	.dw 0xd9c0, 0xc03c,	0xdfff, 0xc03c,		0x21, 0
	.dw 0xe040, 0xc03c,	0xe07f, 0xc03c,		0x21, 0
	.dw 0xe0c0, 0xc03c,	0xe0ff, 0xc03c,		0x21, 0
	.dw 0xe140, 0xc03c,	0xe17f, 0xc03c,		0x21, 0
	.dw 0xe1c0, 0xc03c,	0xe1ff, 0xc03c,		0x21, 0
	.dw 0xe240, 0xc03c,	0xe27f, 0xc03c,		0x21, 0
	.dw 0xe2c0, 0xc03c,	0xe2ff, 0xc03c,		0x21, 0
	.dw 0xe340, 0xc03c,	0xe37f, 0xc03c,		0x21, 0
	.dw 0xe3c0, 0xc03c,	0xe3ff, 0xc03c,		0x21, 0
	.dw 0xe440, 0xc03c,	0xe47f, 0xc03c,		0x21, 0
	.dw 0xe4c0, 0xc03c,	0xe4ff, 0xc03c,		0x21, 0
	.dw 0xe540, 0xc03c,	0xe57f, 0xc03c,		0x21, 0
	.dw 0xe5c0, 0xc03c,	0xe5ff, 0xc03c,		0x21, 0
	.dw 0xe640, 0xc03c,	0xe67f, 0xc03c,		0x21, 0
	.dw 0xe6c0, 0xc03c,	0xe6ff, 0xc03c,		0x21, 0
	.dw 0xe740, 0xc03c,	0xe77f, 0xc03c,		0x21, 0
	.dw 0xe7c0, 0xc03c,	0xe7ff, 0xc03c,		0x21, 0
	.dw 0xe840, 0xc03c,	0xe87f, 0xc03c,		0x21, 0
	.dw 0xe8c0, 0xc03c,	0xe8ff, 0xc03c,		0x21, 0
	.dw 0xe940, 0xc03c,	0xe97f, 0xc03c,		0x21, 0
	.dw 0xe9c0, 0xc03c,	0xe9ff, 0xc03c,		0x21, 0
	.dw 0xea40, 0xc03c,	0xea7f, 0xc03c,		0x21, 0
	.dw 0xeac0, 0xc03c,	0xeaff, 0xc03c,		0x21, 0
	.dw 0xeb40, 0xc03c,	0xeb7f, 0xc03c,		0x21, 0
	.dw 0xebc0, 0xc03c,	0xebff, 0xc03c,		0x21, 0
	.dw 0xec40, 0xc03c,	0xec7f, 0xc03c,		0x21, 0
	.dw 0xecc0, 0xc03c,	0xecff, 0xc03c,		0x21, 0
	.dw 0xed40, 0xc03c,	0xed7f, 0xc03c,		0x21, 0
	.dw 0xedc0, 0xc03c,	0xedff, 0xc03c,		0x21, 0
	.dw 0xee40, 0xc03c,	0xee7f, 0xc03c,		0x21, 0
	.dw 0xeec0, 0xc03c,	0xeeff, 0xc03c,		0x21, 0
	.dw 0xef40, 0xc03c,	0xef7f, 0xc03c,		0x21, 0
	.dw 0xefc0, 0xc03c,	0xefff, 0xc03c,		0x21, 0
	.dw 0xf040, 0xc03c,	0xf07f, 0xc03c,		0x21, 0
	.dw 0xf0c0, 0xc03c,	0xf0ff, 0xc03c,		0x21, 0
	.dw 0xf140, 0xc03c,	0xf17f, 0xc03c,		0x21, 0
	.dw 0xf1c0, 0xc03c,	0xf1ff, 0xc03c,		0x21, 0
	.dw 0xf240, 0xc03c,	0xf27f, 0xc03c,		0x21, 0
	.dw 0xf2c0, 0xc03c,	0xf2ff, 0xc03c,		0x21, 0
	.dw 0xf340, 0xc03c,	0xf37f, 0xc03c,		0x21, 0
	.dw 0xf3c0, 0xc03c,	0xf3ff, 0xc03c,		0x21, 0
	.dw 0xf440, 0xc03c,	0xf47f, 0xc03c,		0x21, 0
	.dw 0xf4c0, 0xc03c,	0xf4ff, 0xc03c,		0x21, 0
	.dw 0xf540, 0xc03c,	0xf57f, 0xc03c,		0x21, 0
	.dw 0xf5c0, 0xc03c,	0xf5ff, 0xc03c,		0x21, 0
	.dw 0xf640, 0xc03c,	0xf67f, 0xc03c,		0x21, 0
	.dw 0xf6c0, 0xc03c,	0xf6ff, 0xc03c,		0x21, 0
	.dw 0xf740, 0xc03c,	0xf77f, 0xc03c,		0x21, 0
	.dw 0xf7c0, 0xc03c,	0xf7ff, 0xc03c,		0x21, 0
	.dw 0xf840, 0xc03c,	0xf87f, 0xc03c,		0x21, 0
	.dw 0xf8c0, 0xc03c,	0xf8ff, 0xc03c,		0x21, 0
	.dw 0xf940, 0xc03c,	0xf97f, 0xc03c,		0x21, 0
	.dw 0xf9c0, 0xc03c,	0xffff, 0xc03c,		0x21, 0
	.dw 0x0040, 0xc03d,	0x007f, 0xc03d,		0x21, 0
	.dw 0x00c0, 0xc03d,	0x00ff, 0xc03d,		0x21, 0
	.dw 0x0140, 0xc03d,	0x017f, 0xc03d,		0x21, 0
	.dw 0x01c0, 0xc03d,	0x01ff, 0xc03d,		0x21, 0
	.dw 0x0240, 0xc03d,	0x027f, 0xc03d,		0x21, 0
	.dw 0x02c0, 0xc03d,	0x02ff, 0xc03d,		0x21, 0
	.dw 0x0340, 0xc03d,	0x037f, 0xc03d,		0x21, 0
	.dw 0x03c0, 0xc03d,	0x03ff, 0xc03d,		0x21, 0
	.dw 0x0440, 0xc03d,	0x047f, 0xc03d,		0x21, 0
	.dw 0x04c0, 0xc03d,	0x04ff, 0xc03d,		0x21, 0
	.dw 0x0540, 0xc03d,	0x057f, 0xc03d,		0x21, 0
	.dw 0x05c0, 0xc03d,	0x05ff, 0xc03d,		0x21, 0
	.dw 0x0640, 0xc03d,	0x067f, 0xc03d,		0x21, 0
	.dw 0x06c0, 0xc03d,	0x06ff, 0xc03d,		0x21, 0
	.dw 0x0740, 0xc03d,	0x077f, 0xc03d,		0x21, 0
	.dw 0x07c0, 0xc03d,	0x07ff, 0xc03d,		0x21, 0
	.dw 0x0840, 0xc03d,	0x087f, 0xc03d,		0x21, 0
	.dw 0x08c0, 0xc03d,	0x08ff, 0xc03d,		0x21, 0
	.dw 0x0940, 0xc03d,	0x097f, 0xc03d,		0x21, 0
	.dw 0x09c0, 0xc03d,	0x09ff, 0xc03d,		0x21, 0
	.dw 0x0a40, 0xc03d,	0x0a7f, 0xc03d,		0x21, 0
	.dw 0x0ac0, 0xc03d,	0x0aff, 0xc03d,		0x21, 0
	.dw 0x0b40, 0xc03d,	0x0b7f, 0xc03d,		0x21, 0
	.dw 0x0bc0, 0xc03d,	0x0bff, 0xc03d,		0x21, 0
	.dw 0x0c40, 0xc03d,	0x0c7f, 0xc03d,		0x21, 0
	.dw 0x0cc0, 0xc03d,	0x0cff, 0xc03d,		0x21, 0
	.dw 0x0d40, 0xc03d,	0x0d7f, 0xc03d,		0x21, 0
	.dw 0x0dc0, 0xc03d,	0x0dff, 0xc03d,		0x21, 0
	.dw 0x0e40, 0xc03d,	0x0e7f, 0xc03d,		0x21, 0
	.dw 0x0ec0, 0xc03d,	0x0eff, 0xc03d,		0x21, 0
	.dw 0x0f40, 0xc03d,	0x0f7f, 0xc03d,		0x21, 0
	.dw 0x0fc0, 0xc03d,	0x0fff, 0xc03d,		0x21, 0
	.dw 0x1040, 0xc03d,	0x107f, 0xc03d,		0x21, 0
	.dw 0x10c0, 0xc03d,	0x10ff, 0xc03d,		0x21, 0
	.dw 0x1140, 0xc03d,	0x117f, 0xc03d,		0x21, 0
	.dw 0x11c0, 0xc03d,	0x11ff, 0xc03d,		0x21, 0
	.dw 0x1240, 0xc03d,	0x127f, 0xc03d,		0x21, 0
	.dw 0x12c0, 0xc03d,	0x12ff, 0xc03d,		0x21, 0
	.dw 0x1340, 0xc03d,	0x137f, 0xc03d,		0x21, 0
	.dw 0x13c0, 0xc03d,	0x13ff, 0xc03d,		0x21, 0
	.dw 0x1440, 0xc03d,	0x147f, 0xc03d,		0x21, 0
	.dw 0x14c0, 0xc03d,	0x14ff, 0xc03d,		0x21, 0
	.dw 0x1540, 0xc03d,	0x157f, 0xc03d,		0x21, 0
	.dw 0x15c0, 0xc03d,	0x15ff, 0xc03d,		0x21, 0
	.dw 0x1640, 0xc03d,	0x167f, 0xc03d,		0x21, 0
	.dw 0x16c0, 0xc03d,	0x16ff, 0xc03d,		0x21, 0
	.dw 0x1740, 0xc03d,	0x177f, 0xc03d,		0x21, 0
	.dw 0x17c0, 0xc03d,	0x17ff, 0xc03d,		0x21, 0
	.dw 0x1840, 0xc03d,	0x187f, 0xc03d,		0x21, 0
	.dw 0x18c0, 0xc03d,	0x18ff, 0xc03d,		0x21, 0
	.dw 0x1940, 0xc03d,	0x197f, 0xc03d,		0x21, 0
	.dw 0x19c0, 0xc03d,	0x1fff, 0xc03d,		0x21, 0
	.dw 0x2040, 0xc03d,	0x207f, 0xc03d,		0x21, 0
	.dw 0x20c0, 0xc03d,	0x20ff, 0xc03d,		0x21, 0
	.dw 0x2140, 0xc03d,	0x217f, 0xc03d,		0x21, 0
	.dw 0x21c0, 0xc03d,	0x21ff, 0xc03d,		0x21, 0
	.dw 0x2240, 0xc03d,	0x227f, 0xc03d,		0x21, 0
	.dw 0x22c0, 0xc03d,	0x22ff, 0xc03d,		0x21, 0
	.dw 0x2340, 0xc03d,	0x237f, 0xc03d,		0x21, 0
	.dw 0x23c0, 0xc03d,	0x23ff, 0xc03d,		0x21, 0
	.dw 0x2440, 0xc03d,	0x247f, 0xc03d,		0x21, 0
	.dw 0x24c0, 0xc03d,	0x24ff, 0xc03d,		0x21, 0
	.dw 0x2540, 0xc03d,	0x257f, 0xc03d,		0x21, 0
	.dw 0x25c0, 0xc03d,	0x25ff, 0xc03d,		0x21, 0
	.dw 0x2640, 0xc03d,	0x267f, 0xc03d,		0x21, 0
	.dw 0x26c0, 0xc03d,	0x26ff, 0xc03d,		0x21, 0
	.dw 0x2740, 0xc03d,	0x277f, 0xc03d,		0x21, 0
	.dw 0x27c0, 0xc03d,	0x27ff, 0xc03d,		0x21, 0
	.dw 0x2840, 0xc03d,	0x287f, 0xc03d,		0x21, 0
	.dw 0x28c0, 0xc03d,	0x28ff, 0xc03d,		0x21, 0
	.dw 0x2940, 0xc03d,	0x297f, 0xc03d,		0x21, 0
	.dw 0x29c0, 0xc03d,	0x29ff, 0xc03d,		0x21, 0
	.dw 0x2a40, 0xc03d,	0x2a7f, 0xc03d,		0x21, 0
	.dw 0x2ac0, 0xc03d,	0x2aff, 0xc03d,		0x21, 0
	.dw 0x2b40, 0xc03d,	0x2b7f, 0xc03d,		0x21, 0
	.dw 0x2bc0, 0xc03d,	0x2bff, 0xc03d,		0x21, 0
	.dw 0x2c40, 0xc03d,	0x2c7f, 0xc03d,		0x21, 0
	.dw 0x2cc0, 0xc03d,	0x2cff, 0xc03d,		0x21, 0
	.dw 0x2d40, 0xc03d,	0x2d7f, 0xc03d,		0x21, 0
	.dw 0x2dc0, 0xc03d,	0x2dff, 0xc03d,		0x21, 0
	.dw 0x2e40, 0xc03d,	0x2e7f, 0xc03d,		0x21, 0
	.dw 0x2ec0, 0xc03d,	0x2eff, 0xc03d,		0x21, 0
	.dw 0x2f40, 0xc03d,	0x2f7f, 0xc03d,		0x21, 0
	.dw 0x2fc0, 0xc03d,	0x2fff, 0xc03d,		0x21, 0
	.dw 0x3040, 0xc03d,	0x307f, 0xc03d,		0x21, 0
	.dw 0x30c0, 0xc03d,	0x30ff, 0xc03d,		0x21, 0
	.dw 0x3140, 0xc03d,	0x317f, 0xc03d,		0x21, 0
	.dw 0x31c0, 0xc03d,	0x31ff, 0xc03d,		0x21, 0
	.dw 0x3240, 0xc03d,	0x327f, 0xc03d,		0x21, 0
	.dw 0x32c0, 0xc03d,	0x32ff, 0xc03d,		0x21, 0
	.dw 0x3340, 0xc03d,	0x337f, 0xc03d,		0x21, 0
	.dw 0x33c0, 0xc03d,	0x33ff, 0xc03d,		0x21, 0
	.dw 0x3440, 0xc03d,	0x347f, 0xc03d,		0x21, 0
	.dw 0x34c0, 0xc03d,	0x34ff, 0xc03d,		0x21, 0
	.dw 0x3540, 0xc03d,	0x357f, 0xc03d,		0x21, 0
	.dw 0x35c0, 0xc03d,	0x35ff, 0xc03d,		0x21, 0
	.dw 0x3640, 0xc03d,	0x367f, 0xc03d,		0x21, 0
	.dw 0x36c0, 0xc03d,	0x36ff, 0xc03d,		0x21, 0
	.dw 0x3740, 0xc03d,	0x377f, 0xc03d,		0x21, 0
	.dw 0x37c0, 0xc03d,	0x37ff, 0xc03d,		0x21, 0
	.dw 0x3840, 0xc03d,	0x387f, 0xc03d,		0x21, 0
	.dw 0x38c0, 0xc03d,	0x38ff, 0xc03d,		0x21, 0
	.dw 0x3940, 0xc03d,	0x397f, 0xc03d,		0x21, 0
	.dw 0x39c0, 0xc03d,	0x3fff, 0xc03d,		0x21, 0
	.dw 0x4040, 0xc03d,	0x407f, 0xc03d,		0x21, 0
	.dw 0x40c0, 0xc03d,	0x40ff, 0xc03d,		0x21, 0
	.dw 0x4140, 0xc03d,	0x417f, 0xc03d,		0x21, 0
	.dw 0x41c0, 0xc03d,	0x41ff, 0xc03d,		0x21, 0
	.dw 0x4240, 0xc03d,	0x427f, 0xc03d,		0x21, 0
	.dw 0x42c0, 0xc03d,	0x42ff, 0xc03d,		0x21, 0
	.dw 0x4340, 0xc03d,	0x437f, 0xc03d,		0x21, 0
	.dw 0x43c0, 0xc03d,	0x43ff, 0xc03d,		0x21, 0
	.dw 0x4440, 0xc03d,	0x447f, 0xc03d,		0x21, 0
	.dw 0x44c0, 0xc03d,	0x44ff, 0xc03d,		0x21, 0
	.dw 0x4540, 0xc03d,	0x457f, 0xc03d,		0x21, 0
	.dw 0x45c0, 0xc03d,	0x45ff, 0xc03d,		0x21, 0
	.dw 0x4640, 0xc03d,	0x467f, 0xc03d,		0x21, 0
	.dw 0x46c0, 0xc03d,	0x46ff, 0xc03d,		0x21, 0
	.dw 0x4740, 0xc03d,	0x477f, 0xc03d,		0x21, 0
	.dw 0x47c0, 0xc03d,	0x47ff, 0xc03d,		0x21, 0
	.dw 0x4840, 0xc03d,	0x487f, 0xc03d,		0x21, 0
	.dw 0x48c0, 0xc03d,	0x48ff, 0xc03d,		0x21, 0
	.dw 0x4940, 0xc03d,	0x497f, 0xc03d,		0x21, 0
	.dw 0x49c0, 0xc03d,	0x49ff, 0xc03d,		0x21, 0
	.dw 0x4a40, 0xc03d,	0x4a7f, 0xc03d,		0x21, 0
	.dw 0x4ac0, 0xc03d,	0x4aff, 0xc03d,		0x21, 0
	.dw 0x4b40, 0xc03d,	0x4b7f, 0xc03d,		0x21, 0
	.dw 0x4bc0, 0xc03d,	0x4bff, 0xc03d,		0x21, 0
	.dw 0x4c40, 0xc03d,	0x4c7f, 0xc03d,		0x21, 0
	.dw 0x4cc0, 0xc03d,	0x4cff, 0xc03d,		0x21, 0
	.dw 0x4d40, 0xc03d,	0x4d7f, 0xc03d,		0x21, 0
	.dw 0x4dc0, 0xc03d,	0x4dff, 0xc03d,		0x21, 0
	.dw 0x4e40, 0xc03d,	0x4e7f, 0xc03d,		0x21, 0
	.dw 0x4ec0, 0xc03d,	0x4eff, 0xc03d,		0x21, 0
	.dw 0x4f40, 0xc03d,	0x4f7f, 0xc03d,		0x21, 0
	.dw 0x4fc0, 0xc03d,	0x4fff, 0xc03d,		0x21, 0
	.dw 0x5040, 0xc03d,	0x507f, 0xc03d,		0x21, 0
	.dw 0x50c0, 0xc03d,	0x50ff, 0xc03d,		0x21, 0
	.dw 0x5140, 0xc03d,	0x517f, 0xc03d,		0x21, 0
	.dw 0x51c0, 0xc03d,	0x51ff, 0xc03d,		0x21, 0
	.dw 0x5240, 0xc03d,	0x527f, 0xc03d,		0x21, 0
	.dw 0x52c0, 0xc03d,	0x52ff, 0xc03d,		0x21, 0
	.dw 0x5340, 0xc03d,	0x537f, 0xc03d,		0x21, 0
	.dw 0x53c0, 0xc03d,	0x53ff, 0xc03d,		0x21, 0
	.dw 0x5440, 0xc03d,	0x547f, 0xc03d,		0x21, 0
	.dw 0x54c0, 0xc03d,	0x54ff, 0xc03d,		0x21, 0
	.dw 0x5540, 0xc03d,	0x557f, 0xc03d,		0x21, 0
	.dw 0x55c0, 0xc03d,	0x55ff, 0xc03d,		0x21, 0
	.dw 0x5640, 0xc03d,	0x567f, 0xc03d,		0x21, 0
	.dw 0x56c0, 0xc03d,	0x56ff, 0xc03d,		0x21, 0
	.dw 0x5740, 0xc03d,	0x577f, 0xc03d,		0x21, 0
	.dw 0x57c0, 0xc03d,	0x57ff, 0xc03d,		0x21, 0
	.dw 0x5840, 0xc03d,	0x587f, 0xc03d,		0x21, 0
	.dw 0x58c0, 0xc03d,	0x58ff, 0xc03d,		0x21, 0
	.dw 0x5940, 0xc03d,	0x597f, 0xc03d,		0x21, 0
	.dw 0x59c0, 0xc03d,	0x5fff, 0xc03d,		0x21, 0
	.dw 0x6040, 0xc03d,	0x607f, 0xc03d,		0x21, 0
	.dw 0x60c0, 0xc03d,	0x60ff, 0xc03d,		0x21, 0
	.dw 0x6140, 0xc03d,	0x617f, 0xc03d,		0x21, 0
	.dw 0x61c0, 0xc03d,	0x61ff, 0xc03d,		0x21, 0
	.dw 0x6240, 0xc03d,	0x627f, 0xc03d,		0x21, 0
	.dw 0x62c0, 0xc03d,	0x62ff, 0xc03d,		0x21, 0
	.dw 0x6340, 0xc03d,	0x637f, 0xc03d,		0x21, 0
	.dw 0x63c0, 0xc03d,	0x63ff, 0xc03d,		0x21, 0
	.dw 0x6440, 0xc03d,	0x647f, 0xc03d,		0x21, 0
	.dw 0x64c0, 0xc03d,	0x64ff, 0xc03d,		0x21, 0
	.dw 0x6540, 0xc03d,	0x657f, 0xc03d,		0x21, 0
	.dw 0x65c0, 0xc03d,	0x65ff, 0xc03d,		0x21, 0
	.dw 0x6640, 0xc03d,	0x667f, 0xc03d,		0x21, 0
	.dw 0x66c0, 0xc03d,	0x66ff, 0xc03d,		0x21, 0
	.dw 0x6740, 0xc03d,	0x677f, 0xc03d,		0x21, 0
	.dw 0x67c0, 0xc03d,	0x67ff, 0xc03d,		0x21, 0
	.dw 0x6840, 0xc03d,	0x687f, 0xc03d,		0x21, 0
	.dw 0x68c0, 0xc03d,	0x68ff, 0xc03d,		0x21, 0
	.dw 0x6940, 0xc03d,	0x697f, 0xc03d,		0x21, 0
	.dw 0x69c0, 0xc03d,	0x69ff, 0xc03d,		0x21, 0
	.dw 0x6a40, 0xc03d,	0x6a7f, 0xc03d,		0x21, 0
	.dw 0x6ac0, 0xc03d,	0x6aff, 0xc03d,		0x21, 0
	.dw 0x6b40, 0xc03d,	0x6b7f, 0xc03d,		0x21, 0
	.dw 0x6bc0, 0xc03d,	0x6bff, 0xc03d,		0x21, 0
	.dw 0x6c40, 0xc03d,	0x6c7f, 0xc03d,		0x21, 0
	.dw 0x6cc0, 0xc03d,	0x6cff, 0xc03d,		0x21, 0
	.dw 0x6d40, 0xc03d,	0x6d7f, 0xc03d,		0x21, 0
	.dw 0x6dc0, 0xc03d,	0x6dff, 0xc03d,		0x21, 0
	.dw 0x6e40, 0xc03d,	0x6e7f, 0xc03d,		0x21, 0
	.dw 0x6ec0, 0xc03d,	0x6eff, 0xc03d,		0x21, 0
	.dw 0x6f40, 0xc03d,	0x6f7f, 0xc03d,		0x21, 0
	.dw 0x6fc0, 0xc03d,	0x6fff, 0xc03d,		0x21, 0
	.dw 0x7040, 0xc03d,	0x707f, 0xc03d,		0x21, 0
	.dw 0x70c0, 0xc03d,	0x70ff, 0xc03d,		0x21, 0
	.dw 0x7140, 0xc03d,	0x717f, 0xc03d,		0x21, 0
	.dw 0x71c0, 0xc03d,	0x71ff, 0xc03d,		0x21, 0
	.dw 0x7240, 0xc03d,	0x727f, 0xc03d,		0x21, 0
	.dw 0x72c0, 0xc03d,	0x72ff, 0xc03d,		0x21, 0
	.dw 0x7340, 0xc03d,	0x737f, 0xc03d,		0x21, 0
	.dw 0x73c0, 0xc03d,	0x73ff, 0xc03d,		0x21, 0
	.dw 0x7440, 0xc03d,	0x747f, 0xc03d,		0x21, 0
	.dw 0x74c0, 0xc03d,	0x74ff, 0xc03d,		0x21, 0
	.dw 0x7540, 0xc03d,	0x757f, 0xc03d,		0x21, 0
	.dw 0x75c0, 0xc03d,	0x75ff, 0xc03d,		0x21, 0
	.dw 0x7640, 0xc03d,	0x767f, 0xc03d,		0x21, 0
	.dw 0x76c0, 0xc03d,	0x76ff, 0xc03d,		0x21, 0
	.dw 0x7740, 0xc03d,	0x777f, 0xc03d,		0x21, 0
	.dw 0x77c0, 0xc03d,	0x77ff, 0xc03d,		0x21, 0
	.dw 0x7840, 0xc03d,	0x787f, 0xc03d,		0x21, 0
	.dw 0x78c0, 0xc03d,	0x78ff, 0xc03d,		0x21, 0
	.dw 0x7940, 0xc03d,	0x797f, 0xc03d,		0x21, 0
	.dw 0x79c0, 0xc03d,	0x7fff, 0xc03d,		0x21, 0
	.dw 0x8040, 0xc03d,	0x807f, 0xc03d,		0x21, 0
	.dw 0x80c0, 0xc03d,	0x80ff, 0xc03d,		0x21, 0
	.dw 0x8140, 0xc03d,	0x817f, 0xc03d,		0x21, 0
	.dw 0x81c0, 0xc03d,	0x81ff, 0xc03d,		0x21, 0
	.dw 0x8240, 0xc03d,	0x827f, 0xc03d,		0x21, 0
	.dw 0x82c0, 0xc03d,	0x82ff, 0xc03d,		0x21, 0
	.dw 0x8340, 0xc03d,	0x837f, 0xc03d,		0x21, 0
	.dw 0x83c0, 0xc03d,	0x83ff, 0xc03d,		0x21, 0
	.dw 0x8440, 0xc03d,	0x847f, 0xc03d,		0x21, 0
	.dw 0x84c0, 0xc03d,	0x84ff, 0xc03d,		0x21, 0
	.dw 0x8540, 0xc03d,	0x857f, 0xc03d,		0x21, 0
	.dw 0x85c0, 0xc03d,	0x85ff, 0xc03d,		0x21, 0
	.dw 0x8640, 0xc03d,	0x867f, 0xc03d,		0x21, 0
	.dw 0x86c0, 0xc03d,	0x86ff, 0xc03d,		0x21, 0
	.dw 0x8740, 0xc03d,	0x877f, 0xc03d,		0x21, 0
	.dw 0x87c0, 0xc03d,	0x87ff, 0xc03d,		0x21, 0
	.dw 0x8840, 0xc03d,	0x887f, 0xc03d,		0x21, 0
	.dw 0x88c0, 0xc03d,	0x88ff, 0xc03d,		0x21, 0
	.dw 0x8940, 0xc03d,	0x897f, 0xc03d,		0x21, 0
	.dw 0x89c0, 0xc03d,	0x89ff, 0xc03d,		0x21, 0
	.dw 0x8a40, 0xc03d,	0x8a7f, 0xc03d,		0x21, 0
	.dw 0x8ac0, 0xc03d,	0x8aff, 0xc03d,		0x21, 0
	.dw 0x8b40, 0xc03d,	0x8b7f, 0xc03d,		0x21, 0
	.dw 0x8bc0, 0xc03d,	0x8bff, 0xc03d,		0x21, 0
	.dw 0x8c40, 0xc03d,	0x8c7f, 0xc03d,		0x21, 0
	.dw 0x8cc0, 0xc03d,	0x8cff, 0xc03d,		0x21, 0
	.dw 0x8d40, 0xc03d,	0x8d7f, 0xc03d,		0x21, 0
	.dw 0x8dc0, 0xc03d,	0x8dff, 0xc03d,		0x21, 0
	.dw 0x8e40, 0xc03d,	0x8e7f, 0xc03d,		0x21, 0
	.dw 0x8ec0, 0xc03d,	0x8eff, 0xc03d,		0x21, 0
	.dw 0x8f40, 0xc03d,	0x8f7f, 0xc03d,		0x21, 0
	.dw 0x8fc0, 0xc03d,	0x8fff, 0xc03d,		0x21, 0
	.dw 0x9040, 0xc03d,	0x907f, 0xc03d,		0x21, 0
	.dw 0x90c0, 0xc03d,	0x90ff, 0xc03d,		0x21, 0
	.dw 0x9140, 0xc03d,	0x917f, 0xc03d,		0x21, 0
	.dw 0x91c0, 0xc03d,	0x91ff, 0xc03d,		0x21, 0
	.dw 0x9240, 0xc03d,	0x927f, 0xc03d,		0x21, 0
	.dw 0x92c0, 0xc03d,	0x92ff, 0xc03d,		0x21, 0
	.dw 0x9340, 0xc03d,	0x937f, 0xc03d,		0x21, 0
	.dw 0x93c0, 0xc03d,	0x93ff, 0xc03d,		0x21, 0
	.dw 0x9440, 0xc03d,	0x947f, 0xc03d,		0x21, 0
	.dw 0x94c0, 0xc03d,	0x94ff, 0xc03d,		0x21, 0
	.dw 0x9540, 0xc03d,	0x957f, 0xc03d,		0x21, 0
	.dw 0x95c0, 0xc03d,	0x95ff, 0xc03d,		0x21, 0
	.dw 0x9640, 0xc03d,	0x967f, 0xc03d,		0x21, 0
	.dw 0x96c0, 0xc03d,	0x96ff, 0xc03d,		0x21, 0
	.dw 0x9740, 0xc03d,	0x977f, 0xc03d,		0x21, 0
	.dw 0x97c0, 0xc03d,	0x97ff, 0xc03d,		0x21, 0
	.dw 0x9840, 0xc03d,	0x987f, 0xc03d,		0x21, 0
	.dw 0x98c0, 0xc03d,	0x98ff, 0xc03d,		0x21, 0
	.dw 0x9940, 0xc03d,	0x997f, 0xc03d,		0x21, 0
	.dw 0x99c0, 0xc03d,	0x9fff, 0xc03d,		0x21, 0
	.dw 0xa040, 0xc03d,	0xa07f, 0xc03d,		0x21, 0
	.dw 0xa0c0, 0xc03d,	0xa0ff, 0xc03d,		0x21, 0
	.dw 0xa140, 0xc03d,	0xa17f, 0xc03d,		0x21, 0
	.dw 0xa1c0, 0xc03d,	0xa1ff, 0xc03d,		0x21, 0
	.dw 0xa240, 0xc03d,	0xa27f, 0xc03d,		0x21, 0
	.dw 0xa2c0, 0xc03d,	0xa2ff, 0xc03d,		0x21, 0
	.dw 0xa340, 0xc03d,	0xa37f, 0xc03d,		0x21, 0
	.dw 0xa3c0, 0xc03d,	0xa3ff, 0xc03d,		0x21, 0
	.dw 0xa440, 0xc03d,	0xa47f, 0xc03d,		0x21, 0
	.dw 0xa4c0, 0xc03d,	0xa4ff, 0xc03d,		0x21, 0
	.dw 0xa540, 0xc03d,	0xa57f, 0xc03d,		0x21, 0
	.dw 0xa5c0, 0xc03d,	0xa5ff, 0xc03d,		0x21, 0
	.dw 0xa640, 0xc03d,	0xa67f, 0xc03d,		0x21, 0
	.dw 0xa6c0, 0xc03d,	0xa6ff, 0xc03d,		0x21, 0
	.dw 0xa740, 0xc03d,	0xa77f, 0xc03d,		0x21, 0
	.dw 0xa7c0, 0xc03d,	0xa7ff, 0xc03d,		0x21, 0
	.dw 0xa840, 0xc03d,	0xa87f, 0xc03d,		0x21, 0
	.dw 0xa8c0, 0xc03d,	0xa8ff, 0xc03d,		0x21, 0
	.dw 0xa940, 0xc03d,	0xa97f, 0xc03d,		0x21, 0
	.dw 0xa9c0, 0xc03d,	0xa9ff, 0xc03d,		0x21, 0
	.dw 0xaa40, 0xc03d,	0xaa7f, 0xc03d,		0x21, 0
	.dw 0xaac0, 0xc03d,	0xaaff, 0xc03d,		0x21, 0
	.dw 0xab40, 0xc03d,	0xab7f, 0xc03d,		0x21, 0
	.dw 0xabc0, 0xc03d,	0xabff, 0xc03d,		0x21, 0
	.dw 0xac40, 0xc03d,	0xac7f, 0xc03d,		0x21, 0
	.dw 0xacc0, 0xc03d,	0xacff, 0xc03d,		0x21, 0
	.dw 0xad40, 0xc03d,	0xad7f, 0xc03d,		0x21, 0
	.dw 0xadc0, 0xc03d,	0xadff, 0xc03d,		0x21, 0
	.dw 0xae40, 0xc03d,	0xae7f, 0xc03d,		0x21, 0
	.dw 0xaec0, 0xc03d,	0xaeff, 0xc03d,		0x21, 0
	.dw 0xaf40, 0xc03d,	0xaf7f, 0xc03d,		0x21, 0
	.dw 0xafc0, 0xc03d,	0xafff, 0xc03d,		0x21, 0
	.dw 0xb040, 0xc03d,	0xb07f, 0xc03d,		0x21, 0
	.dw 0xb0c0, 0xc03d,	0xb0ff, 0xc03d,		0x21, 0
	.dw 0xb140, 0xc03d,	0xb17f, 0xc03d,		0x21, 0
	.dw 0xb1c0, 0xc03d,	0xb1ff, 0xc03d,		0x21, 0
	.dw 0xb240, 0xc03d,	0xb27f, 0xc03d,		0x21, 0
	.dw 0xb2c0, 0xc03d,	0xb2ff, 0xc03d,		0x21, 0
	.dw 0xb340, 0xc03d,	0xb37f, 0xc03d,		0x21, 0
	.dw 0xb3c0, 0xc03d,	0xb3ff, 0xc03d,		0x21, 0
	.dw 0xb440, 0xc03d,	0xb47f, 0xc03d,		0x21, 0
	.dw 0xb4c0, 0xc03d,	0xb4ff, 0xc03d,		0x21, 0
	.dw 0xb540, 0xc03d,	0xb57f, 0xc03d,		0x21, 0
	.dw 0xb5c0, 0xc03d,	0xb5ff, 0xc03d,		0x21, 0
	.dw 0xb640, 0xc03d,	0xb67f, 0xc03d,		0x21, 0
	.dw 0xb6c0, 0xc03d,	0xb6ff, 0xc03d,		0x21, 0
	.dw 0xb740, 0xc03d,	0xb77f, 0xc03d,		0x21, 0
	.dw 0xb7c0, 0xc03d,	0xb7ff, 0xc03d,		0x21, 0
	.dw 0xb840, 0xc03d,	0xb87f, 0xc03d,		0x21, 0
	.dw 0xb8c0, 0xc03d,	0xb8ff, 0xc03d,		0x21, 0
	.dw 0xb940, 0xc03d,	0xb97f, 0xc03d,		0x21, 0
	.dw 0xb9c0, 0xc03d,	0xbfff, 0xc03d,		0x21, 0
	.dw 0xc040, 0xc03d,	0xc07f, 0xc03d,		0x21, 0
	.dw 0xc0c0, 0xc03d,	0xc0ff, 0xc03d,		0x21, 0
	.dw 0xc140, 0xc03d,	0xc17f, 0xc03d,		0x21, 0
	.dw 0xc1c0, 0xc03d,	0xc1ff, 0xc03d,		0x21, 0
	.dw 0xc240, 0xc03d,	0xc27f, 0xc03d,		0x21, 0
	.dw 0xc2c0, 0xc03d,	0xc2ff, 0xc03d,		0x21, 0
	.dw 0xc340, 0xc03d,	0xc37f, 0xc03d,		0x21, 0
	.dw 0xc3c0, 0xc03d,	0xc3ff, 0xc03d,		0x21, 0
	.dw 0xc440, 0xc03d,	0xc47f, 0xc03d,		0x21, 0
	.dw 0xc4c0, 0xc03d,	0xc4ff, 0xc03d,		0x21, 0
	.dw 0xc540, 0xc03d,	0xc57f, 0xc03d,		0x21, 0
	.dw 0xc5c0, 0xc03d,	0xc5ff, 0xc03d,		0x21, 0
	.dw 0xc640, 0xc03d,	0xc67f, 0xc03d,		0x21, 0
	.dw 0xc6c0, 0xc03d,	0xc6ff, 0xc03d,		0x21, 0
	.dw 0xc740, 0xc03d,	0xc77f, 0xc03d,		0x21, 0
	.dw 0xc7c0, 0xc03d,	0xc7ff, 0xc03d,		0x21, 0
	.dw 0xc840, 0xc03d,	0xc87f, 0xc03d,		0x21, 0
	.dw 0xc8c0, 0xc03d,	0xc8ff, 0xc03d,		0x21, 0
	.dw 0xc940, 0xc03d,	0xc97f, 0xc03d,		0x21, 0
	.dw 0xc9c0, 0xc03d,	0xc9ff, 0xc03d,		0x21, 0
	.dw 0xca40, 0xc03d,	0xca7f, 0xc03d,		0x21, 0
	.dw 0xcac0, 0xc03d,	0xcaff, 0xc03d,		0x21, 0
	.dw 0xcb40, 0xc03d,	0xcb7f, 0xc03d,		0x21, 0
	.dw 0xcbc0, 0xc03d,	0xcbff, 0xc03d,		0x21, 0
	.dw 0xcc40, 0xc03d,	0xcc7f, 0xc03d,		0x21, 0
	.dw 0xccc0, 0xc03d,	0xccff, 0xc03d,		0x21, 0
	.dw 0xcd40, 0xc03d,	0xcd7f, 0xc03d,		0x21, 0
	.dw 0xcdc0, 0xc03d,	0xcdff, 0xc03d,		0x21, 0
	.dw 0xce40, 0xc03d,	0xce7f, 0xc03d,		0x21, 0
	.dw 0xcec0, 0xc03d,	0xceff, 0xc03d,		0x21, 0
	.dw 0xcf40, 0xc03d,	0xcf7f, 0xc03d,		0x21, 0
	.dw 0xcfc0, 0xc03d,	0xcfff, 0xc03d,		0x21, 0
	.dw 0xd040, 0xc03d,	0xd07f, 0xc03d,		0x21, 0
	.dw 0xd0c0, 0xc03d,	0xd0ff, 0xc03d,		0x21, 0
	.dw 0xd140, 0xc03d,	0xd17f, 0xc03d,		0x21, 0
	.dw 0xd1c0, 0xc03d,	0xd1ff, 0xc03d,		0x21, 0
	.dw 0xd240, 0xc03d,	0xd27f, 0xc03d,		0x21, 0
	.dw 0xd2c0, 0xc03d,	0xd2ff, 0xc03d,		0x21, 0
	.dw 0xd340, 0xc03d,	0xd37f, 0xc03d,		0x21, 0
	.dw 0xd3c0, 0xc03d,	0xd3ff, 0xc03d,		0x21, 0
	.dw 0xd440, 0xc03d,	0xd47f, 0xc03d,		0x21, 0
	.dw 0xd4c0, 0xc03d,	0xd4ff, 0xc03d,		0x21, 0
	.dw 0xd540, 0xc03d,	0xd57f, 0xc03d,		0x21, 0
	.dw 0xd5c0, 0xc03d,	0xd5ff, 0xc03d,		0x21, 0
	.dw 0xd640, 0xc03d,	0xd67f, 0xc03d,		0x21, 0
	.dw 0xd6c0, 0xc03d,	0xd6ff, 0xc03d,		0x21, 0
	.dw 0xd740, 0xc03d,	0xd77f, 0xc03d,		0x21, 0
	.dw 0xd7c0, 0xc03d,	0xd7ff, 0xc03d,		0x21, 0
	.dw 0xd840, 0xc03d,	0xd87f, 0xc03d,		0x21, 0
	.dw 0xd8c0, 0xc03d,	0xd8ff, 0xc03d,		0x21, 0
	.dw 0xd940, 0xc03d,	0xd97f, 0xc03d,		0x21, 0
	.dw 0xd9c0, 0xc03d,	0xdfff, 0xc03d,		0x21, 0
	.dw 0xe040, 0xc03d,	0xe07f, 0xc03d,		0x21, 0
	.dw 0xe0c0, 0xc03d,	0xe0ff, 0xc03d,		0x21, 0
	.dw 0xe140, 0xc03d,	0xe17f, 0xc03d,		0x21, 0
	.dw 0xe1c0, 0xc03d,	0xe1ff, 0xc03d,		0x21, 0
	.dw 0xe240, 0xc03d,	0xe27f, 0xc03d,		0x21, 0
	.dw 0xe2c0, 0xc03d,	0xe2ff, 0xc03d,		0x21, 0
	.dw 0xe340, 0xc03d,	0xe37f, 0xc03d,		0x21, 0
	.dw 0xe3c0, 0xc03d,	0xe3ff, 0xc03d,		0x21, 0
	.dw 0xe440, 0xc03d,	0xe47f, 0xc03d,		0x21, 0
	.dw 0xe4c0, 0xc03d,	0xe4ff, 0xc03d,		0x21, 0
	.dw 0xe540, 0xc03d,	0xe57f, 0xc03d,		0x21, 0
	.dw 0xe5c0, 0xc03d,	0xe5ff, 0xc03d,		0x21, 0
	.dw 0xe640, 0xc03d,	0xe67f, 0xc03d,		0x21, 0
	.dw 0xe6c0, 0xc03d,	0xe6ff, 0xc03d,		0x21, 0
	.dw 0xe740, 0xc03d,	0xe77f, 0xc03d,		0x21, 0
	.dw 0xe7c0, 0xc03d,	0xe7ff, 0xc03d,		0x21, 0
	.dw 0xe840, 0xc03d,	0xe87f, 0xc03d,		0x21, 0
	.dw 0xe8c0, 0xc03d,	0xe8ff, 0xc03d,		0x21, 0
	.dw 0xe940, 0xc03d,	0xe97f, 0xc03d,		0x21, 0
	.dw 0xe9c0, 0xc03d,	0xe9ff, 0xc03d,		0x21, 0
	.dw 0xea40, 0xc03d,	0xea7f, 0xc03d,		0x21, 0
	.dw 0xeac0, 0xc03d,	0xeaff, 0xc03d,		0x21, 0
	.dw 0xeb40, 0xc03d,	0xeb7f, 0xc03d,		0x21, 0
	.dw 0xebc0, 0xc03d,	0xebff, 0xc03d,		0x21, 0
	.dw 0xec40, 0xc03d,	0xec7f, 0xc03d,		0x21, 0
	.dw 0xecc0, 0xc03d,	0xecff, 0xc03d,		0x21, 0
	.dw 0xed40, 0xc03d,	0xed7f, 0xc03d,		0x21, 0
	.dw 0xedc0, 0xc03d,	0xedff, 0xc03d,		0x21, 0
	.dw 0xee40, 0xc03d,	0xee7f, 0xc03d,		0x21, 0
	.dw 0xeec0, 0xc03d,	0xeeff, 0xc03d,		0x21, 0
	.dw 0xef40, 0xc03d,	0xef7f, 0xc03d,		0x21, 0
	.dw 0xefc0, 0xc03d,	0xefff, 0xc03d,		0x21, 0
	.dw 0xf040, 0xc03d,	0xf07f, 0xc03d,		0x21, 0
	.dw 0xf0c0, 0xc03d,	0xf0ff, 0xc03d,		0x21, 0
	.dw 0xf140, 0xc03d,	0xf17f, 0xc03d,		0x21, 0
	.dw 0xf1c0, 0xc03d,	0xf1ff, 0xc03d,		0x21, 0
	.dw 0xf240, 0xc03d,	0xf27f, 0xc03d,		0x21, 0
	.dw 0xf2c0, 0xc03d,	0xf2ff, 0xc03d,		0x21, 0
	.dw 0xf340, 0xc03d,	0xf37f, 0xc03d,		0x21, 0
	.dw 0xf3c0, 0xc03d,	0xf3ff, 0xc03d,		0x21, 0
	.dw 0xf440, 0xc03d,	0xf47f, 0xc03d,		0x21, 0
	.dw 0xf4c0, 0xc03d,	0xf4ff, 0xc03d,		0x21, 0
	.dw 0xf540, 0xc03d,	0xf57f, 0xc03d,		0x21, 0
	.dw 0xf5c0, 0xc03d,	0xf5ff, 0xc03d,		0x21, 0
	.dw 0xf640, 0xc03d,	0xf67f, 0xc03d,		0x21, 0
	.dw 0xf6c0, 0xc03d,	0xf6ff, 0xc03d,		0x21, 0
	.dw 0xf740, 0xc03d,	0xf77f, 0xc03d,		0x21, 0
	.dw 0xf7c0, 0xc03d,	0xf7ff, 0xc03d,		0x21, 0
	.dw 0xf840, 0xc03d,	0xf87f, 0xc03d,		0x21, 0
	.dw 0xf8c0, 0xc03d,	0xf8ff, 0xc03d,		0x21, 0
	.dw 0xf940, 0xc03d,	0xf97f, 0xc03d,		0x21, 0
	.dw 0xf9c0, 0xc03d,	0xffff, 0xc03d,		0x21, 0
	.dw 0x0040, 0xc03e,	0x007f, 0xc03e,		0x21, 0
	.dw 0x00c0, 0xc03e,	0x00ff, 0xc03e,		0x21, 0
	.dw 0x0140, 0xc03e,	0x017f, 0xc03e,		0x21, 0
	.dw 0x01c0, 0xc03e,	0x01ff, 0xc03e,		0x21, 0
	.dw 0x0240, 0xc03e,	0x027f, 0xc03e,		0x21, 0
	.dw 0x02c0, 0xc03e,	0x02ff, 0xc03e,		0x21, 0
	.dw 0x0340, 0xc03e,	0x037f, 0xc03e,		0x21, 0
	.dw 0x03c0, 0xc03e,	0x03ff, 0xc03e,		0x21, 0
	.dw 0x0440, 0xc03e,	0x047f, 0xc03e,		0x21, 0
	.dw 0x04c0, 0xc03e,	0x04ff, 0xc03e,		0x21, 0
	.dw 0x0540, 0xc03e,	0x057f, 0xc03e,		0x21, 0
	.dw 0x05c0, 0xc03e,	0x05ff, 0xc03e,		0x21, 0
	.dw 0x0640, 0xc03e,	0x067f, 0xc03e,		0x21, 0
	.dw 0x06c0, 0xc03e,	0x06ff, 0xc03e,		0x21, 0
	.dw 0x0740, 0xc03e,	0x077f, 0xc03e,		0x21, 0
	.dw 0x07c0, 0xc03e,	0x07ff, 0xc03e,		0x21, 0
	.dw 0x0840, 0xc03e,	0x087f, 0xc03e,		0x21, 0
	.dw 0x08c0, 0xc03e,	0x08ff, 0xc03e,		0x21, 0
	.dw 0x0940, 0xc03e,	0x097f, 0xc03e,		0x21, 0
	.dw 0x09c0, 0xc03e,	0x09ff, 0xc03e,		0x21, 0
	.dw 0x0a40, 0xc03e,	0x0a7f, 0xc03e,		0x21, 0
	.dw 0x0ac0, 0xc03e,	0x0aff, 0xc03e,		0x21, 0
	.dw 0x0b40, 0xc03e,	0x0b7f, 0xc03e,		0x21, 0
	.dw 0x0bc0, 0xc03e,	0x0bff, 0xc03e,		0x21, 0
	.dw 0x0c40, 0xc03e,	0x0c7f, 0xc03e,		0x21, 0
	.dw 0x0cc0, 0xc03e,	0x0cff, 0xc03e,		0x21, 0
	.dw 0x0d40, 0xc03e,	0x0d7f, 0xc03e,		0x21, 0
	.dw 0x0dc0, 0xc03e,	0x0dff, 0xc03e,		0x21, 0
	.dw 0x0e40, 0xc03e,	0x0e7f, 0xc03e,		0x21, 0
	.dw 0x0ec0, 0xc03e,	0x0eff, 0xc03e,		0x21, 0
	.dw 0x0f40, 0xc03e,	0x0f7f, 0xc03e,		0x21, 0
	.dw 0x0fc0, 0xc03e,	0x0fff, 0xc03e,		0x21, 0
	.dw 0x1040, 0xc03e,	0x107f, 0xc03e,		0x21, 0
	.dw 0x10c0, 0xc03e,	0x10ff, 0xc03e,		0x21, 0
	.dw 0x1140, 0xc03e,	0x117f, 0xc03e,		0x21, 0
	.dw 0x11c0, 0xc03e,	0x11ff, 0xc03e,		0x21, 0
	.dw 0x1240, 0xc03e,	0x127f, 0xc03e,		0x21, 0
	.dw 0x12c0, 0xc03e,	0x12ff, 0xc03e,		0x21, 0
	.dw 0x1340, 0xc03e,	0x137f, 0xc03e,		0x21, 0
	.dw 0x13c0, 0xc03e,	0x13ff, 0xc03e,		0x21, 0
	.dw 0x1440, 0xc03e,	0x147f, 0xc03e,		0x21, 0
	.dw 0x14c0, 0xc03e,	0x14ff, 0xc03e,		0x21, 0
	.dw 0x1540, 0xc03e,	0x157f, 0xc03e,		0x21, 0
	.dw 0x15c0, 0xc03e,	0x15ff, 0xc03e,		0x21, 0
	.dw 0x1640, 0xc03e,	0x167f, 0xc03e,		0x21, 0
	.dw 0x16c0, 0xc03e,	0x16ff, 0xc03e,		0x21, 0
	.dw 0x1740, 0xc03e,	0x177f, 0xc03e,		0x21, 0
	.dw 0x17c0, 0xc03e,	0x17ff, 0xc03e,		0x21, 0
	.dw 0x1840, 0xc03e,	0x187f, 0xc03e,		0x21, 0
	.dw 0x18c0, 0xc03e,	0x18ff, 0xc03e,		0x21, 0
	.dw 0x1940, 0xc03e,	0x197f, 0xc03e,		0x21, 0
	.dw 0x19c0, 0xc03e,	0x1fff, 0xc03e,		0x21, 0
	.dw 0x2040, 0xc03e,	0x207f, 0xc03e,		0x21, 0
	.dw 0x20c0, 0xc03e,	0x20ff, 0xc03e,		0x21, 0
	.dw 0x2140, 0xc03e,	0x217f, 0xc03e,		0x21, 0
	.dw 0x21c0, 0xc03e,	0x21ff, 0xc03e,		0x21, 0
	.dw 0x2240, 0xc03e,	0x227f, 0xc03e,		0x21, 0
	.dw 0x22c0, 0xc03e,	0x22ff, 0xc03e,		0x21, 0
	.dw 0x2340, 0xc03e,	0x237f, 0xc03e,		0x21, 0
	.dw 0x23c0, 0xc03e,	0x23ff, 0xc03e,		0x21, 0
	.dw 0x2440, 0xc03e,	0x247f, 0xc03e,		0x21, 0
	.dw 0x24c0, 0xc03e,	0x24ff, 0xc03e,		0x21, 0
	.dw 0x2540, 0xc03e,	0x257f, 0xc03e,		0x21, 0
	.dw 0x25c0, 0xc03e,	0x25ff, 0xc03e,		0x21, 0
	.dw 0x2640, 0xc03e,	0x267f, 0xc03e,		0x21, 0
	.dw 0x26c0, 0xc03e,	0x26ff, 0xc03e,		0x21, 0
	.dw 0x2740, 0xc03e,	0x277f, 0xc03e,		0x21, 0
	.dw 0x27c0, 0xc03e,	0x27ff, 0xc03e,		0x21, 0
	.dw 0x2840, 0xc03e,	0x287f, 0xc03e,		0x21, 0
	.dw 0x28c0, 0xc03e,	0x28ff, 0xc03e,		0x21, 0
	.dw 0x2940, 0xc03e,	0x297f, 0xc03e,		0x21, 0
	.dw 0x29c0, 0xc03e,	0x29ff, 0xc03e,		0x21, 0
	.dw 0x2a40, 0xc03e,	0x2a7f, 0xc03e,		0x21, 0
	.dw 0x2ac0, 0xc03e,	0x2aff, 0xc03e,		0x21, 0
	.dw 0x2b40, 0xc03e,	0x2b7f, 0xc03e,		0x21, 0
	.dw 0x2bc0, 0xc03e,	0x2bff, 0xc03e,		0x21, 0
	.dw 0x2c40, 0xc03e,	0x2c7f, 0xc03e,		0x21, 0
	.dw 0x2cc0, 0xc03e,	0x2cff, 0xc03e,		0x21, 0
	.dw 0x2d40, 0xc03e,	0x2d7f, 0xc03e,		0x21, 0
	.dw 0x2dc0, 0xc03e,	0x2dff, 0xc03e,		0x21, 0
	.dw 0x2e40, 0xc03e,	0x2e7f, 0xc03e,		0x21, 0
	.dw 0x2ec0, 0xc03e,	0x2eff, 0xc03e,		0x21, 0
	.dw 0x2f40, 0xc03e,	0x2f7f, 0xc03e,		0x21, 0
	.dw 0x2fc0, 0xc03e,	0x2fff, 0xc03e,		0x21, 0
	.dw 0x3040, 0xc03e,	0x307f, 0xc03e,		0x21, 0
	.dw 0x30c0, 0xc03e,	0x30ff, 0xc03e,		0x21, 0
	.dw 0x3140, 0xc03e,	0x317f, 0xc03e,		0x21, 0
	.dw 0x31c0, 0xc03e,	0x31ff, 0xc03e,		0x21, 0
	.dw 0x3240, 0xc03e,	0x327f, 0xc03e,		0x21, 0
	.dw 0x32c0, 0xc03e,	0x32ff, 0xc03e,		0x21, 0
	.dw 0x3340, 0xc03e,	0x337f, 0xc03e,		0x21, 0
	.dw 0x33c0, 0xc03e,	0x33ff, 0xc03e,		0x21, 0
	.dw 0x3440, 0xc03e,	0x347f, 0xc03e,		0x21, 0
	.dw 0x34c0, 0xc03e,	0x34ff, 0xc03e,		0x21, 0
	.dw 0x3540, 0xc03e,	0x357f, 0xc03e,		0x21, 0
	.dw 0x35c0, 0xc03e,	0x35ff, 0xc03e,		0x21, 0
	.dw 0x3640, 0xc03e,	0x367f, 0xc03e,		0x21, 0
	.dw 0x36c0, 0xc03e,	0x36ff, 0xc03e,		0x21, 0
	.dw 0x3740, 0xc03e,	0x377f, 0xc03e,		0x21, 0
	.dw 0x37c0, 0xc03e,	0x37ff, 0xc03e,		0x21, 0
	.dw 0x3840, 0xc03e,	0x387f, 0xc03e,		0x21, 0
	.dw 0x38c0, 0xc03e,	0x38ff, 0xc03e,		0x21, 0
	.dw 0x3940, 0xc03e,	0x397f, 0xc03e,		0x21, 0
	.dw 0x39c0, 0xc03e,	0x3fff, 0xc03e,		0x21, 0
	.dw 0x4040, 0xc03e,	0x407f, 0xc03e,		0x21, 0
	.dw 0x40c0, 0xc03e,	0x40ff, 0xc03e,		0x21, 0
	.dw 0x4140, 0xc03e,	0x417f, 0xc03e,		0x21, 0
	.dw 0x41c0, 0xc03e,	0x41ff, 0xc03e,		0x21, 0
	.dw 0x4240, 0xc03e,	0x427f, 0xc03e,		0x21, 0
	.dw 0x42c0, 0xc03e,	0x42ff, 0xc03e,		0x21, 0
	.dw 0x4340, 0xc03e,	0x437f, 0xc03e,		0x21, 0
	.dw 0x43c0, 0xc03e,	0x43ff, 0xc03e,		0x21, 0
	.dw 0x4440, 0xc03e,	0x447f, 0xc03e,		0x21, 0
	.dw 0x44c0, 0xc03e,	0x44ff, 0xc03e,		0x21, 0
	.dw 0x4540, 0xc03e,	0x457f, 0xc03e,		0x21, 0
	.dw 0x45c0, 0xc03e,	0x45ff, 0xc03e,		0x21, 0
	.dw 0x4640, 0xc03e,	0x467f, 0xc03e,		0x21, 0
	.dw 0x46c0, 0xc03e,	0x46ff, 0xc03e,		0x21, 0
	.dw 0x4740, 0xc03e,	0x477f, 0xc03e,		0x21, 0
	.dw 0x47c0, 0xc03e,	0x47ff, 0xc03e,		0x21, 0
	.dw 0x4840, 0xc03e,	0x487f, 0xc03e,		0x21, 0
	.dw 0x48c0, 0xc03e,	0x48ff, 0xc03e,		0x21, 0
	.dw 0x4940, 0xc03e,	0x497f, 0xc03e,		0x21, 0
	.dw 0x49c0, 0xc03e,	0x49ff, 0xc03e,		0x21, 0
	.dw 0x4a40, 0xc03e,	0x4a7f, 0xc03e,		0x21, 0
	.dw 0x4ac0, 0xc03e,	0x4aff, 0xc03e,		0x21, 0
	.dw 0x4b40, 0xc03e,	0x4b7f, 0xc03e,		0x21, 0
	.dw 0x4bc0, 0xc03e,	0x4bff, 0xc03e,		0x21, 0
	.dw 0x4c40, 0xc03e,	0x4c7f, 0xc03e,		0x21, 0
	.dw 0x4cc0, 0xc03e,	0x4cff, 0xc03e,		0x21, 0
	.dw 0x4d40, 0xc03e,	0x4d7f, 0xc03e,		0x21, 0
	.dw 0x4dc0, 0xc03e,	0x4dff, 0xc03e,		0x21, 0
	.dw 0x4e40, 0xc03e,	0x4e7f, 0xc03e,		0x21, 0
	.dw 0x4ec0, 0xc03e,	0x4eff, 0xc03e,		0x21, 0
	.dw 0x4f40, 0xc03e,	0x4f7f, 0xc03e,		0x21, 0
	.dw 0x4fc0, 0xc03e,	0x4fff, 0xc03e,		0x21, 0
	.dw 0x5040, 0xc03e,	0x507f, 0xc03e,		0x21, 0
	.dw 0x50c0, 0xc03e,	0x50ff, 0xc03e,		0x21, 0
	.dw 0x5140, 0xc03e,	0x517f, 0xc03e,		0x21, 0
	.dw 0x51c0, 0xc03e,	0x51ff, 0xc03e,		0x21, 0
	.dw 0x5240, 0xc03e,	0x527f, 0xc03e,		0x21, 0
	.dw 0x52c0, 0xc03e,	0x52ff, 0xc03e,		0x21, 0
	.dw 0x5340, 0xc03e,	0x537f, 0xc03e,		0x21, 0
	.dw 0x53c0, 0xc03e,	0x53ff, 0xc03e,		0x21, 0
	.dw 0x5440, 0xc03e,	0x547f, 0xc03e,		0x21, 0
	.dw 0x54c0, 0xc03e,	0x54ff, 0xc03e,		0x21, 0
	.dw 0x5540, 0xc03e,	0x557f, 0xc03e,		0x21, 0
	.dw 0x55c0, 0xc03e,	0x55ff, 0xc03e,		0x21, 0
	.dw 0x5640, 0xc03e,	0x567f, 0xc03e,		0x21, 0
	.dw 0x56c0, 0xc03e,	0x56ff, 0xc03e,		0x21, 0
	.dw 0x5740, 0xc03e,	0x577f, 0xc03e,		0x21, 0
	.dw 0x57c0, 0xc03e,	0x57ff, 0xc03e,		0x21, 0
	.dw 0x5840, 0xc03e,	0x587f, 0xc03e,		0x21, 0
	.dw 0x58c0, 0xc03e,	0x58ff, 0xc03e,		0x21, 0
	.dw 0x5940, 0xc03e,	0x597f, 0xc03e,		0x21, 0
	.dw 0x59c0, 0xc03e,	0x5fff, 0xc03e,		0x21, 0
	.dw 0x6040, 0xc03e,	0x607f, 0xc03e,		0x21, 0
	.dw 0x60c0, 0xc03e,	0x60ff, 0xc03e,		0x21, 0
	.dw 0x6140, 0xc03e,	0x617f, 0xc03e,		0x21, 0
	.dw 0x61c0, 0xc03e,	0x61ff, 0xc03e,		0x21, 0
	.dw 0x6240, 0xc03e,	0x627f, 0xc03e,		0x21, 0
	.dw 0x62c0, 0xc03e,	0x62ff, 0xc03e,		0x21, 0
	.dw 0x6340, 0xc03e,	0x637f, 0xc03e,		0x21, 0
	.dw 0x63c0, 0xc03e,	0x63ff, 0xc03e,		0x21, 0
	.dw 0x6440, 0xc03e,	0x647f, 0xc03e,		0x21, 0
	.dw 0x64c0, 0xc03e,	0x64ff, 0xc03e,		0x21, 0
	.dw 0x6540, 0xc03e,	0x657f, 0xc03e,		0x21, 0
	.dw 0x65c0, 0xc03e,	0x65ff, 0xc03e,		0x21, 0
	.dw 0x6640, 0xc03e,	0x667f, 0xc03e,		0x21, 0
	.dw 0x66c0, 0xc03e,	0x66ff, 0xc03e,		0x21, 0
	.dw 0x6740, 0xc03e,	0x677f, 0xc03e,		0x21, 0
	.dw 0x67c0, 0xc03e,	0x67ff, 0xc03e,		0x21, 0
	.dw 0x6840, 0xc03e,	0x687f, 0xc03e,		0x21, 0
	.dw 0x68c0, 0xc03e,	0x68ff, 0xc03e,		0x21, 0
	.dw 0x6940, 0xc03e,	0x697f, 0xc03e,		0x21, 0
	.dw 0x69c0, 0xc03e,	0x69ff, 0xc03e,		0x21, 0
	.dw 0x6a40, 0xc03e,	0x6a7f, 0xc03e,		0x21, 0
	.dw 0x6ac0, 0xc03e,	0x6aff, 0xc03e,		0x21, 0
	.dw 0x6b40, 0xc03e,	0x6b7f, 0xc03e,		0x21, 0
	.dw 0x6bc0, 0xc03e,	0x6bff, 0xc03e,		0x21, 0
	.dw 0x6c40, 0xc03e,	0x6c7f, 0xc03e,		0x21, 0
	.dw 0x6cc0, 0xc03e,	0x6cff, 0xc03e,		0x21, 0
	.dw 0x6d40, 0xc03e,	0x6d7f, 0xc03e,		0x21, 0
	.dw 0x6dc0, 0xc03e,	0x6dff, 0xc03e,		0x21, 0
	.dw 0x6e40, 0xc03e,	0x6e7f, 0xc03e,		0x21, 0
	.dw 0x6ec0, 0xc03e,	0x6eff, 0xc03e,		0x21, 0
	.dw 0x6f40, 0xc03e,	0x6f7f, 0xc03e,		0x21, 0
	.dw 0x6fc0, 0xc03e,	0x6fff, 0xc03e,		0x21, 0
	.dw 0x7040, 0xc03e,	0x707f, 0xc03e,		0x21, 0
	.dw 0x70c0, 0xc03e,	0x70ff, 0xc03e,		0x21, 0
	.dw 0x7140, 0xc03e,	0x717f, 0xc03e,		0x21, 0
	.dw 0x71c0, 0xc03e,	0x71ff, 0xc03e,		0x21, 0
	.dw 0x7240, 0xc03e,	0x727f, 0xc03e,		0x21, 0
	.dw 0x72c0, 0xc03e,	0x72ff, 0xc03e,		0x21, 0
	.dw 0x7340, 0xc03e,	0x737f, 0xc03e,		0x21, 0
	.dw 0x73c0, 0xc03e,	0x73ff, 0xc03e,		0x21, 0
	.dw 0x7440, 0xc03e,	0x747f, 0xc03e,		0x21, 0
	.dw 0x74c0, 0xc03e,	0x74ff, 0xc03e,		0x21, 0
	.dw 0x7540, 0xc03e,	0x757f, 0xc03e,		0x21, 0
	.dw 0x75c0, 0xc03e,	0x75ff, 0xc03e,		0x21, 0
	.dw 0x7640, 0xc03e,	0x767f, 0xc03e,		0x21, 0
	.dw 0x76c0, 0xc03e,	0x76ff, 0xc03e,		0x21, 0
	.dw 0x7740, 0xc03e,	0x777f, 0xc03e,		0x21, 0
	.dw 0x77c0, 0xc03e,	0x77ff, 0xc03e,		0x21, 0
	.dw 0x7840, 0xc03e,	0x787f, 0xc03e,		0x21, 0
	.dw 0x78c0, 0xc03e,	0x78ff, 0xc03e,		0x21, 0
	.dw 0x7940, 0xc03e,	0x797f, 0xc03e,		0x21, 0
	.dw 0x79c0, 0xc03e,	0x7fff, 0xc03e,		0x21, 0
	.dw 0x8040, 0xc03e,	0x807f, 0xc03e,		0x21, 0
	.dw 0x80c0, 0xc03e,	0x80ff, 0xc03e,		0x21, 0
	.dw 0x8140, 0xc03e,	0x817f, 0xc03e,		0x21, 0
	.dw 0x81c0, 0xc03e,	0x81ff, 0xc03e,		0x21, 0
	.dw 0x8240, 0xc03e,	0x827f, 0xc03e,		0x21, 0
	.dw 0x82c0, 0xc03e,	0x82ff, 0xc03e,		0x21, 0
	.dw 0x8340, 0xc03e,	0x837f, 0xc03e,		0x21, 0
	.dw 0x83c0, 0xc03e,	0x83ff, 0xc03e,		0x21, 0
	.dw 0x8440, 0xc03e,	0x847f, 0xc03e,		0x21, 0
	.dw 0x84c0, 0xc03e,	0x84ff, 0xc03e,		0x21, 0
	.dw 0x8540, 0xc03e,	0x857f, 0xc03e,		0x21, 0
	.dw 0x85c0, 0xc03e,	0x85ff, 0xc03e,		0x21, 0
	.dw 0x8640, 0xc03e,	0x867f, 0xc03e,		0x21, 0
	.dw 0x86c0, 0xc03e,	0x86ff, 0xc03e,		0x21, 0
	.dw 0x8740, 0xc03e,	0x877f, 0xc03e,		0x21, 0
	.dw 0x87c0, 0xc03e,	0x87ff, 0xc03e,		0x21, 0
	.dw 0x8840, 0xc03e,	0x887f, 0xc03e,		0x21, 0
	.dw 0x88c0, 0xc03e,	0x88ff, 0xc03e,		0x21, 0
	.dw 0x8940, 0xc03e,	0x897f, 0xc03e,		0x21, 0
	.dw 0x89c0, 0xc03e,	0x89ff, 0xc03e,		0x21, 0
	.dw 0x8a40, 0xc03e,	0x8a7f, 0xc03e,		0x21, 0
	.dw 0x8ac0, 0xc03e,	0x8aff, 0xc03e,		0x21, 0
	.dw 0x8b40, 0xc03e,	0x8b7f, 0xc03e,		0x21, 0
	.dw 0x8bc0, 0xc03e,	0x8bff, 0xc03e,		0x21, 0
	.dw 0x8c40, 0xc03e,	0x8c7f, 0xc03e,		0x21, 0
	.dw 0x8cc0, 0xc03e,	0x8cff, 0xc03e,		0x21, 0
	.dw 0x8d40, 0xc03e,	0x8d7f, 0xc03e,		0x21, 0
	.dw 0x8dc0, 0xc03e,	0x8dff, 0xc03e,		0x21, 0
	.dw 0x8e40, 0xc03e,	0x8e7f, 0xc03e,		0x21, 0
	.dw 0x8ec0, 0xc03e,	0x8eff, 0xc03e,		0x21, 0
	.dw 0x8f40, 0xc03e,	0x8f7f, 0xc03e,		0x21, 0
	.dw 0x8fc0, 0xc03e,	0x8fff, 0xc03e,		0x21, 0
	.dw 0x9040, 0xc03e,	0x907f, 0xc03e,		0x21, 0
	.dw 0x90c0, 0xc03e,	0x90ff, 0xc03e,		0x21, 0
	.dw 0x9140, 0xc03e,	0x917f, 0xc03e,		0x21, 0
	.dw 0x91c0, 0xc03e,	0x91ff, 0xc03e,		0x21, 0
	.dw 0x9240, 0xc03e,	0x927f, 0xc03e,		0x21, 0
	.dw 0x92c0, 0xc03e,	0x92ff, 0xc03e,		0x21, 0
	.dw 0x9340, 0xc03e,	0x937f, 0xc03e,		0x21, 0
	.dw 0x93c0, 0xc03e,	0x93ff, 0xc03e,		0x21, 0
	.dw 0x9440, 0xc03e,	0x947f, 0xc03e,		0x21, 0
	.dw 0x94c0, 0xc03e,	0x94ff, 0xc03e,		0x21, 0
	.dw 0x9540, 0xc03e,	0x957f, 0xc03e,		0x21, 0
	.dw 0x95c0, 0xc03e,	0x95ff, 0xc03e,		0x21, 0
	.dw 0x9640, 0xc03e,	0x967f, 0xc03e,		0x21, 0
	.dw 0x96c0, 0xc03e,	0x96ff, 0xc03e,		0x21, 0
	.dw 0x9740, 0xc03e,	0x977f, 0xc03e,		0x21, 0
	.dw 0x97c0, 0xc03e,	0x97ff, 0xc03e,		0x21, 0
	.dw 0x9840, 0xc03e,	0x987f, 0xc03e,		0x21, 0
	.dw 0x98c0, 0xc03e,	0x98ff, 0xc03e,		0x21, 0
	.dw 0x9940, 0xc03e,	0x997f, 0xc03e,		0x21, 0
	.dw 0x99c0, 0xc03e,	0x9fff, 0xc03e,		0x21, 0
	.dw 0xa040, 0xc03e,	0xa07f, 0xc03e,		0x21, 0
	.dw 0xa0c0, 0xc03e,	0xa0ff, 0xc03e,		0x21, 0
	.dw 0xa140, 0xc03e,	0xa17f, 0xc03e,		0x21, 0
	.dw 0xa1c0, 0xc03e,	0xa1ff, 0xc03e,		0x21, 0
	.dw 0xa240, 0xc03e,	0xa27f, 0xc03e,		0x21, 0
	.dw 0xa2c0, 0xc03e,	0xa2ff, 0xc03e,		0x21, 0
	.dw 0xa340, 0xc03e,	0xa37f, 0xc03e,		0x21, 0
	.dw 0xa3c0, 0xc03e,	0xa3ff, 0xc03e,		0x21, 0
	.dw 0xa440, 0xc03e,	0xa47f, 0xc03e,		0x21, 0
	.dw 0xa4c0, 0xc03e,	0xa4ff, 0xc03e,		0x21, 0
	.dw 0xa540, 0xc03e,	0xa57f, 0xc03e,		0x21, 0
	.dw 0xa5c0, 0xc03e,	0xa5ff, 0xc03e,		0x21, 0
	.dw 0xa640, 0xc03e,	0xa67f, 0xc03e,		0x21, 0
	.dw 0xa6c0, 0xc03e,	0xa6ff, 0xc03e,		0x21, 0
	.dw 0xa740, 0xc03e,	0xa77f, 0xc03e,		0x21, 0
	.dw 0xa7c0, 0xc03e,	0xa7ff, 0xc03e,		0x21, 0
	.dw 0xa840, 0xc03e,	0xa87f, 0xc03e,		0x21, 0
	.dw 0xa8c0, 0xc03e,	0xa8ff, 0xc03e,		0x21, 0
	.dw 0xa940, 0xc03e,	0xa97f, 0xc03e,		0x21, 0
	.dw 0xa9c0, 0xc03e,	0xa9ff, 0xc03e,		0x21, 0
	.dw 0xaa40, 0xc03e,	0xaa7f, 0xc03e,		0x21, 0
	.dw 0xaac0, 0xc03e,	0xaaff, 0xc03e,		0x21, 0
	.dw 0xab40, 0xc03e,	0xab7f, 0xc03e,		0x21, 0
	.dw 0xabc0, 0xc03e,	0xabff, 0xc03e,		0x21, 0
	.dw 0xac40, 0xc03e,	0xac7f, 0xc03e,		0x21, 0
	.dw 0xacc0, 0xc03e,	0xacff, 0xc03e,		0x21, 0
	.dw 0xad40, 0xc03e,	0xad7f, 0xc03e,		0x21, 0
	.dw 0xadc0, 0xc03e,	0xadff, 0xc03e,		0x21, 0
	.dw 0xae40, 0xc03e,	0xae7f, 0xc03e,		0x21, 0
	.dw 0xaec0, 0xc03e,	0xaeff, 0xc03e,		0x21, 0
	.dw 0xaf40, 0xc03e,	0xaf7f, 0xc03e,		0x21, 0
	.dw 0xafc0, 0xc03e,	0xafff, 0xc03e,		0x21, 0
	.dw 0xb040, 0xc03e,	0xb07f, 0xc03e,		0x21, 0
	.dw 0xb0c0, 0xc03e,	0xb0ff, 0xc03e,		0x21, 0
	.dw 0xb140, 0xc03e,	0xb17f, 0xc03e,		0x21, 0
	.dw 0xb1c0, 0xc03e,	0xb1ff, 0xc03e,		0x21, 0
	.dw 0xb240, 0xc03e,	0xb27f, 0xc03e,		0x21, 0
	.dw 0xb2c0, 0xc03e,	0xb2ff, 0xc03e,		0x21, 0
	.dw 0xb340, 0xc03e,	0xb37f, 0xc03e,		0x21, 0
	.dw 0xb3c0, 0xc03e,	0xb3ff, 0xc03e,		0x21, 0
	.dw 0xb440, 0xc03e,	0xb47f, 0xc03e,		0x21, 0
	.dw 0xb4c0, 0xc03e,	0xb4ff, 0xc03e,		0x21, 0
	.dw 0xb540, 0xc03e,	0xb57f, 0xc03e,		0x21, 0
	.dw 0xb5c0, 0xc03e,	0xb5ff, 0xc03e,		0x21, 0
	.dw 0xb640, 0xc03e,	0xb67f, 0xc03e,		0x21, 0
	.dw 0xb6c0, 0xc03e,	0xb6ff, 0xc03e,		0x21, 0
	.dw 0xb740, 0xc03e,	0xb77f, 0xc03e,		0x21, 0
	.dw 0xb7c0, 0xc03e,	0xb7ff, 0xc03e,		0x21, 0
	.dw 0xb840, 0xc03e,	0xb87f, 0xc03e,		0x21, 0
	.dw 0xb8c0, 0xc03e,	0xb8ff, 0xc03e,		0x21, 0
	.dw 0xb940, 0xc03e,	0xb97f, 0xc03e,		0x21, 0
	.dw 0xb9c0, 0xc03e,	0xbfff, 0xc03e,		0x21, 0
	.dw 0xc040, 0xc03e,	0xc07f, 0xc03e,		0x21, 0
	.dw 0xc0c0, 0xc03e,	0xc0ff, 0xc03e,		0x21, 0
	.dw 0xc140, 0xc03e,	0xc17f, 0xc03e,		0x21, 0
	.dw 0xc1c0, 0xc03e,	0xc1ff, 0xc03e,		0x21, 0
	.dw 0xc240, 0xc03e,	0xc27f, 0xc03e,		0x21, 0
	.dw 0xc2c0, 0xc03e,	0xc2ff, 0xc03e,		0x21, 0
	.dw 0xc340, 0xc03e,	0xc37f, 0xc03e,		0x21, 0
	.dw 0xc3c0, 0xc03e,	0xc3ff, 0xc03e,		0x21, 0
	.dw 0xc440, 0xc03e,	0xc47f, 0xc03e,		0x21, 0
	.dw 0xc4c0, 0xc03e,	0xc4ff, 0xc03e,		0x21, 0
	.dw 0xc540, 0xc03e,	0xc57f, 0xc03e,		0x21, 0
	.dw 0xc5c0, 0xc03e,	0xc5ff, 0xc03e,		0x21, 0
	.dw 0xc640, 0xc03e,	0xc67f, 0xc03e,		0x21, 0
	.dw 0xc6c0, 0xc03e,	0xc6ff, 0xc03e,		0x21, 0
	.dw 0xc740, 0xc03e,	0xc77f, 0xc03e,		0x21, 0
	.dw 0xc7c0, 0xc03e,	0xc7ff, 0xc03e,		0x21, 0
	.dw 0xc840, 0xc03e,	0xc87f, 0xc03e,		0x21, 0
	.dw 0xc8c0, 0xc03e,	0xc8ff, 0xc03e,		0x21, 0
	.dw 0xc940, 0xc03e,	0xc97f, 0xc03e,		0x21, 0
	.dw 0xc9c0, 0xc03e,	0xc9ff, 0xc03e,		0x21, 0
	.dw 0xca40, 0xc03e,	0xca7f, 0xc03e,		0x21, 0
	.dw 0xcac0, 0xc03e,	0xcaff, 0xc03e,		0x21, 0
	.dw 0xcb40, 0xc03e,	0xcb7f, 0xc03e,		0x21, 0
	.dw 0xcbc0, 0xc03e,	0xcbff, 0xc03e,		0x21, 0
	.dw 0xcc40, 0xc03e,	0xcc7f, 0xc03e,		0x21, 0
	.dw 0xccc0, 0xc03e,	0xccff, 0xc03e,		0x21, 0
	.dw 0xcd40, 0xc03e,	0xcd7f, 0xc03e,		0x21, 0
	.dw 0xcdc0, 0xc03e,	0xcdff, 0xc03e,		0x21, 0
	.dw 0xce40, 0xc03e,	0xce7f, 0xc03e,		0x21, 0
	.dw 0xcec0, 0xc03e,	0xceff, 0xc03e,		0x21, 0
	.dw 0xcf40, 0xc03e,	0xcf7f, 0xc03e,		0x21, 0
	.dw 0xcfc0, 0xc03e,	0xcfff, 0xc03e,		0x21, 0
	.dw 0xd040, 0xc03e,	0xd07f, 0xc03e,		0x21, 0
	.dw 0xd0c0, 0xc03e,	0xd0ff, 0xc03e,		0x21, 0
	.dw 0xd140, 0xc03e,	0xd17f, 0xc03e,		0x21, 0
	.dw 0xd1c0, 0xc03e,	0xd1ff, 0xc03e,		0x21, 0
	.dw 0xd240, 0xc03e,	0xd27f, 0xc03e,		0x21, 0
	.dw 0xd2c0, 0xc03e,	0xd2ff, 0xc03e,		0x21, 0
	.dw 0xd340, 0xc03e,	0xd37f, 0xc03e,		0x21, 0
	.dw 0xd3c0, 0xc03e,	0xd3ff, 0xc03e,		0x21, 0
	.dw 0xd440, 0xc03e,	0xd47f, 0xc03e,		0x21, 0
	.dw 0xd4c0, 0xc03e,	0xd4ff, 0xc03e,		0x21, 0
	.dw 0xd540, 0xc03e,	0xd57f, 0xc03e,		0x21, 0
	.dw 0xd5c0, 0xc03e,	0xd5ff, 0xc03e,		0x21, 0
	.dw 0xd640, 0xc03e,	0xd67f, 0xc03e,		0x21, 0
	.dw 0xd6c0, 0xc03e,	0xd6ff, 0xc03e,		0x21, 0
	.dw 0xd740, 0xc03e,	0xd77f, 0xc03e,		0x21, 0
	.dw 0xd7c0, 0xc03e,	0xd7ff, 0xc03e,		0x21, 0
	.dw 0xd840, 0xc03e,	0xd87f, 0xc03e,		0x21, 0
	.dw 0xd8c0, 0xc03e,	0xd8ff, 0xc03e,		0x21, 0
	.dw 0xd940, 0xc03e,	0xd97f, 0xc03e,		0x21, 0
	.dw 0xd9c0, 0xc03e,	0xdfff, 0xc03e,		0x21, 0
	.dw 0xe040, 0xc03e,	0xe07f, 0xc03e,		0x21, 0
	.dw 0xe0c0, 0xc03e,	0xe0ff, 0xc03e,		0x21, 0
	.dw 0xe140, 0xc03e,	0xe17f, 0xc03e,		0x21, 0
	.dw 0xe1c0, 0xc03e,	0xe1ff, 0xc03e,		0x21, 0
	.dw 0xe240, 0xc03e,	0xe27f, 0xc03e,		0x21, 0
	.dw 0xe2c0, 0xc03e,	0xe2ff, 0xc03e,		0x21, 0
	.dw 0xe340, 0xc03e,	0xe37f, 0xc03e,		0x21, 0
	.dw 0xe3c0, 0xc03e,	0xe3ff, 0xc03e,		0x21, 0
	.dw 0xe440, 0xc03e,	0xe47f, 0xc03e,		0x21, 0
	.dw 0xe4c0, 0xc03e,	0xe4ff, 0xc03e,		0x21, 0
	.dw 0xe540, 0xc03e,	0xe57f, 0xc03e,		0x21, 0
	.dw 0xe5c0, 0xc03e,	0xe5ff, 0xc03e,		0x21, 0
	.dw 0xe640, 0xc03e,	0xe67f, 0xc03e,		0x21, 0
	.dw 0xe6c0, 0xc03e,	0xe6ff, 0xc03e,		0x21, 0
	.dw 0xe740, 0xc03e,	0xe77f, 0xc03e,		0x21, 0
	.dw 0xe7c0, 0xc03e,	0xe7ff, 0xc03e,		0x21, 0
	.dw 0xe840, 0xc03e,	0xe87f, 0xc03e,		0x21, 0
	.dw 0xe8c0, 0xc03e,	0xe8ff, 0xc03e,		0x21, 0
	.dw 0xe940, 0xc03e,	0xe97f, 0xc03e,		0x21, 0
	.dw 0xe9c0, 0xc03e,	0xe9ff, 0xc03e,		0x21, 0
	.dw 0xea40, 0xc03e,	0xea7f, 0xc03e,		0x21, 0
	.dw 0xeac0, 0xc03e,	0xeaff, 0xc03e,		0x21, 0
	.dw 0xeb40, 0xc03e,	0xeb7f, 0xc03e,		0x21, 0
	.dw 0xebc0, 0xc03e,	0xebff, 0xc03e,		0x21, 0
	.dw 0xec40, 0xc03e,	0xec7f, 0xc03e,		0x21, 0
	.dw 0xecc0, 0xc03e,	0xecff, 0xc03e,		0x21, 0
	.dw 0xed40, 0xc03e,	0xed7f, 0xc03e,		0x21, 0
	.dw 0xedc0, 0xc03e,	0xedff, 0xc03e,		0x21, 0
	.dw 0xee40, 0xc03e,	0xee7f, 0xc03e,		0x21, 0
	.dw 0xeec0, 0xc03e,	0xeeff, 0xc03e,		0x21, 0
	.dw 0xef40, 0xc03e,	0xef7f, 0xc03e,		0x21, 0
	.dw 0xefc0, 0xc03e,	0xefff, 0xc03e,		0x21, 0
	.dw 0xf040, 0xc03e,	0xf07f, 0xc03e,		0x21, 0
	.dw 0xf0c0, 0xc03e,	0xf0ff, 0xc03e,		0x21, 0
	.dw 0xf140, 0xc03e,	0xf17f, 0xc03e,		0x21, 0
	.dw 0xf1c0, 0xc03e,	0xf1ff, 0xc03e,		0x21, 0
	.dw 0xf240, 0xc03e,	0xf27f, 0xc03e,		0x21, 0
	.dw 0xf2c0, 0xc03e,	0xf2ff, 0xc03e,		0x21, 0
	.dw 0xf340, 0xc03e,	0xf37f, 0xc03e,		0x21, 0
	.dw 0xf3c0, 0xc03e,	0xf3ff, 0xc03e,		0x21, 0
	.dw 0xf440, 0xc03e,	0xf47f, 0xc03e,		0x21, 0
	.dw 0xf4c0, 0xc03e,	0xf4ff, 0xc03e,		0x21, 0
	.dw 0xf540, 0xc03e,	0xf57f, 0xc03e,		0x21, 0
	.dw 0xf5c0, 0xc03e,	0xf5ff, 0xc03e,		0x21, 0
	.dw 0xf640, 0xc03e,	0xf67f, 0xc03e,		0x21, 0
	.dw 0xf6c0, 0xc03e,	0xf6ff, 0xc03e,		0x21, 0
	.dw 0xf740, 0xc03e,	0xf77f, 0xc03e,		0x21, 0
	.dw 0xf7c0, 0xc03e,	0xf7ff, 0xc03e,		0x21, 0
	.dw 0xf840, 0xc03e,	0xf87f, 0xc03e,		0x21, 0
	.dw 0xf8c0, 0xc03e,	0xf8ff, 0xc03e,		0x21, 0
	.dw 0xf940, 0xc03e,	0xf97f, 0xc03e,		0x21, 0
	.dw 0xf9c0, 0xc03e,	0xffff, 0xc03e,		0x21, 0
	.dw 0x0040, 0xc03f,	0x007f, 0xc03f,		0x21, 0
	.dw 0x00c0, 0xc03f,	0x00ff, 0xc03f,		0x21, 0
	.dw 0x0140, 0xc03f,	0x017f, 0xc03f,		0x21, 0
	.dw 0x01c0, 0xc03f,	0x01ff, 0xc03f,		0x21, 0
	.dw 0x0240, 0xc03f,	0x027f, 0xc03f,		0x21, 0
	.dw 0x02c0, 0xc03f,	0x02ff, 0xc03f,		0x21, 0
	.dw 0x0340, 0xc03f,	0x037f, 0xc03f,		0x21, 0
	.dw 0x03c0, 0xc03f,	0x03ff, 0xc03f,		0x21, 0
	.dw 0x0440, 0xc03f,	0x047f, 0xc03f,		0x21, 0
	.dw 0x04c0, 0xc03f,	0x04ff, 0xc03f,		0x21, 0
	.dw 0x0540, 0xc03f,	0x057f, 0xc03f,		0x21, 0
	.dw 0x05c0, 0xc03f,	0x05ff, 0xc03f,		0x21, 0
	.dw 0x0640, 0xc03f,	0x067f, 0xc03f,		0x21, 0
	.dw 0x06c0, 0xc03f,	0x06ff, 0xc03f,		0x21, 0
	.dw 0x0740, 0xc03f,	0x077f, 0xc03f,		0x21, 0
	.dw 0x07c0, 0xc03f,	0x07ff, 0xc03f,		0x21, 0
	.dw 0x0840, 0xc03f,	0x087f, 0xc03f,		0x21, 0
	.dw 0x08c0, 0xc03f,	0x08ff, 0xc03f,		0x21, 0
	.dw 0x0940, 0xc03f,	0x097f, 0xc03f,		0x21, 0
	.dw 0x09c0, 0xc03f,	0x09ff, 0xc03f,		0x21, 0
	.dw 0x0a40, 0xc03f,	0x0a7f, 0xc03f,		0x21, 0
	.dw 0x0ac0, 0xc03f,	0x0aff, 0xc03f,		0x21, 0
	.dw 0x0b40, 0xc03f,	0x0b7f, 0xc03f,		0x21, 0
	.dw 0x0bc0, 0xc03f,	0x0bff, 0xc03f,		0x21, 0
	.dw 0x0c40, 0xc03f,	0x0c7f, 0xc03f,		0x21, 0
	.dw 0x0cc0, 0xc03f,	0x0cff, 0xc03f,		0x21, 0
	.dw 0x0d40, 0xc03f,	0x0d7f, 0xc03f,		0x21, 0
	.dw 0x0dc0, 0xc03f,	0x0dff, 0xc03f,		0x21, 0
	.dw 0x0e40, 0xc03f,	0x0e7f, 0xc03f,		0x21, 0
	.dw 0x0ec0, 0xc03f,	0x0eff, 0xc03f,		0x21, 0
	.dw 0x0f40, 0xc03f,	0x0f7f, 0xc03f,		0x21, 0
	.dw 0x0fc0, 0xc03f,	0x0fff, 0xc03f,		0x21, 0
	.dw 0x1040, 0xc03f,	0x107f, 0xc03f,		0x21, 0
	.dw 0x10c0, 0xc03f,	0x10ff, 0xc03f,		0x21, 0
	.dw 0x1140, 0xc03f,	0x117f, 0xc03f,		0x21, 0
	.dw 0x11c0, 0xc03f,	0x11ff, 0xc03f,		0x21, 0
	.dw 0x1240, 0xc03f,	0x127f, 0xc03f,		0x21, 0
	.dw 0x12c0, 0xc03f,	0x12ff, 0xc03f,		0x21, 0
	.dw 0x1340, 0xc03f,	0x137f, 0xc03f,		0x21, 0
	.dw 0x13c0, 0xc03f,	0x13ff, 0xc03f,		0x21, 0
	.dw 0x1440, 0xc03f,	0x147f, 0xc03f,		0x21, 0
	.dw 0x14c0, 0xc03f,	0x14ff, 0xc03f,		0x21, 0
	.dw 0x1540, 0xc03f,	0x157f, 0xc03f,		0x21, 0
	.dw 0x15c0, 0xc03f,	0x15ff, 0xc03f,		0x21, 0
	.dw 0x1640, 0xc03f,	0x167f, 0xc03f,		0x21, 0
	.dw 0x16c0, 0xc03f,	0x16ff, 0xc03f,		0x21, 0
	.dw 0x1740, 0xc03f,	0x177f, 0xc03f,		0x21, 0
	.dw 0x17c0, 0xc03f,	0x17ff, 0xc03f,		0x21, 0
	.dw 0x1840, 0xc03f,	0x187f, 0xc03f,		0x21, 0
	.dw 0x18c0, 0xc03f,	0x18ff, 0xc03f,		0x21, 0
	.dw 0x1940, 0xc03f,	0x197f, 0xc03f,		0x21, 0
	.dw 0x19c0, 0xc03f,	0x1fff, 0xc03f,		0x21, 0
	.dw 0x2040, 0xc03f,	0x207f, 0xc03f,		0x21, 0
	.dw 0x20c0, 0xc03f,	0x20ff, 0xc03f,		0x21, 0
	.dw 0x2140, 0xc03f,	0x217f, 0xc03f,		0x21, 0
	.dw 0x21c0, 0xc03f,	0x21ff, 0xc03f,		0x21, 0
	.dw 0x2240, 0xc03f,	0x227f, 0xc03f,		0x21, 0
	.dw 0x22c0, 0xc03f,	0x22ff, 0xc03f,		0x21, 0
	.dw 0x2340, 0xc03f,	0x237f, 0xc03f,		0x21, 0
	.dw 0x23c0, 0xc03f,	0x23ff, 0xc03f,		0x21, 0
	.dw 0x2440, 0xc03f,	0x247f, 0xc03f,		0x21, 0
	.dw 0x24c0, 0xc03f,	0x24ff, 0xc03f,		0x21, 0
	.dw 0x2540, 0xc03f,	0x257f, 0xc03f,		0x21, 0
	.dw 0x25c0, 0xc03f,	0x25ff, 0xc03f,		0x21, 0
	.dw 0x2640, 0xc03f,	0x267f, 0xc03f,		0x21, 0
	.dw 0x26c0, 0xc03f,	0x26ff, 0xc03f,		0x21, 0
	.dw 0x2740, 0xc03f,	0x277f, 0xc03f,		0x21, 0
	.dw 0x27c0, 0xc03f,	0x27ff, 0xc03f,		0x21, 0
	.dw 0x2840, 0xc03f,	0x287f, 0xc03f,		0x21, 0
	.dw 0x28c0, 0xc03f,	0x28ff, 0xc03f,		0x21, 0
	.dw 0x2940, 0xc03f,	0x297f, 0xc03f,		0x21, 0
	.dw 0x29c0, 0xc03f,	0x29ff, 0xc03f,		0x21, 0
	.dw 0x2a40, 0xc03f,	0x2a7f, 0xc03f,		0x21, 0
	.dw 0x2ac0, 0xc03f,	0x2aff, 0xc03f,		0x21, 0
	.dw 0x2b40, 0xc03f,	0x2b7f, 0xc03f,		0x21, 0
	.dw 0x2bc0, 0xc03f,	0x2bff, 0xc03f,		0x21, 0
	.dw 0x2c40, 0xc03f,	0x2c7f, 0xc03f,		0x21, 0
	.dw 0x2cc0, 0xc03f,	0x2cff, 0xc03f,		0x21, 0
	.dw 0x2d40, 0xc03f,	0x2d7f, 0xc03f,		0x21, 0
	.dw 0x2dc0, 0xc03f,	0x2dff, 0xc03f,		0x21, 0
	.dw 0x2e40, 0xc03f,	0x2e7f, 0xc03f,		0x21, 0
	.dw 0x2ec0, 0xc03f,	0x2eff, 0xc03f,		0x21, 0
	.dw 0x2f40, 0xc03f,	0x2f7f, 0xc03f,		0x21, 0
	.dw 0x2fc0, 0xc03f,	0x2fff, 0xc03f,		0x21, 0
	.dw 0x3040, 0xc03f,	0x307f, 0xc03f,		0x21, 0
	.dw 0x30c0, 0xc03f,	0x30ff, 0xc03f,		0x21, 0
	.dw 0x3140, 0xc03f,	0x317f, 0xc03f,		0x21, 0
	.dw 0x31c0, 0xc03f,	0x31ff, 0xc03f,		0x21, 0
	.dw 0x3240, 0xc03f,	0x327f, 0xc03f,		0x21, 0
	.dw 0x32c0, 0xc03f,	0x32ff, 0xc03f,		0x21, 0
	.dw 0x3340, 0xc03f,	0x337f, 0xc03f,		0x21, 0
	.dw 0x33c0, 0xc03f,	0x33ff, 0xc03f,		0x21, 0
	.dw 0x3440, 0xc03f,	0x347f, 0xc03f,		0x21, 0
	.dw 0x34c0, 0xc03f,	0x34ff, 0xc03f,		0x21, 0
	.dw 0x3540, 0xc03f,	0x357f, 0xc03f,		0x21, 0
	.dw 0x35c0, 0xc03f,	0x35ff, 0xc03f,		0x21, 0
	.dw 0x3640, 0xc03f,	0x367f, 0xc03f,		0x21, 0
	.dw 0x36c0, 0xc03f,	0x36ff, 0xc03f,		0x21, 0
	.dw 0x3740, 0xc03f,	0x377f, 0xc03f,		0x21, 0
	.dw 0x37c0, 0xc03f,	0x37ff, 0xc03f,		0x21, 0
	.dw 0x3840, 0xc03f,	0x387f, 0xc03f,		0x21, 0
	.dw 0x38c0, 0xc03f,	0x38ff, 0xc03f,		0x21, 0
	.dw 0x3940, 0xc03f,	0x397f, 0xc03f,		0x21, 0
	.dw 0x39c0, 0xc03f,	0x1fff, 0xc040,		0x21, 0
	.dw 0x3a00, 0xc040,	0x5fff, 0xc040,		0x21, 0
	.dw 0x7a00, 0xc040,	0x9fff, 0xc040,		0x21, 0
	.dw 0xba00, 0xc040,	0xdfff, 0xc040,		0x21, 0
	.dw 0xfa00, 0xc040,	0x1fff, 0xc041,		0x21, 0
	.dw 0x3a00, 0xc041,	0x5fff, 0xc041,		0x21, 0
	.dw 0x7a00, 0xc041,	0x9fff, 0xc041,		0x21, 0
	.dw 0xba00, 0xc041,	0xdfff, 0xc041,		0x21, 0
	.dw 0xfa00, 0xc041,	0x1fff, 0xc042,		0x21, 0
	.dw 0x3a00, 0xc042,	0x5fff, 0xc042,		0x21, 0
	.dw 0x7a00, 0xc042,	0x9fff, 0xc042,		0x21, 0
	.dw 0xba00, 0xc042,	0xdfff, 0xc042,		0x21, 0
	.dw 0xfa00, 0xc042,	0x1fff, 0xc043,		0x21, 0
	.dw 0x3a00, 0xc043,	0xffff, 0xc043,		0x21, 0
	.dw 0x1a00, 0xc044,	0x1fff, 0xc044,		0x21, 0
	.dw 0x3a00, 0xc044,	0x3fff, 0xc044,		0x21, 0
	.dw 0x5a00, 0xc044,	0x5fff, 0xc044,		0x21, 0
	.dw 0x7a00, 0xc044,	0x7fff, 0xc044,		0x21, 0
	.dw 0x9a00, 0xc044,	0x9fff, 0xc044,		0x21, 0
	.dw 0xba00, 0xc044,	0xbfff, 0xc044,		0x21, 0
	.dw 0xda00, 0xc044,	0xdfff, 0xc044,		0x21, 0
	.dw 0xfa00, 0xc044,	0xffff, 0xc044,		0x21, 0
	.dw 0x1a00, 0xc045,	0x1fff, 0xc045,		0x21, 0
	.dw 0x3a00, 0xc045,	0x3fff, 0xc045,		0x21, 0
	.dw 0x5a00, 0xc045,	0x5fff, 0xc045,		0x21, 0
	.dw 0x7a00, 0xc045,	0x7fff, 0xc045,		0x21, 0
	.dw 0x9a00, 0xc045,	0x9fff, 0xc045,		0x21, 0
	.dw 0xba00, 0xc045,	0xbfff, 0xc045,		0x21, 0
	.dw 0xda00, 0xc045,	0xdfff, 0xc045,		0x21, 0
	.dw 0xfa00, 0xc045,	0xffff, 0xc045,		0x21, 0
	.dw 0x1a00, 0xc046,	0x1fff, 0xc046,		0x21, 0
	.dw 0x3a00, 0xc046,	0x3fff, 0xc046,		0x21, 0
	.dw 0x5a00, 0xc046,	0x5fff, 0xc046,		0x21, 0
	.dw 0x7a00, 0xc046,	0x7fff, 0xc046,		0x21, 0
	.dw 0x9a00, 0xc046,	0x9fff, 0xc046,		0x21, 0
	.dw 0xba00, 0xc046,	0xbfff, 0xc046,		0x21, 0
	.dw 0xda00, 0xc046,	0xdfff, 0xc046,		0x21, 0
	.dw 0xfa00, 0xc046,	0xffff, 0xc046,		0x21, 0
	.dw 0x1a00, 0xc047,	0x1fff, 0xc047,		0x21, 0
	.dw 0x3a00, 0xc047,	0x1fff, 0xc050,		0x21, 0
	.dw 0x3a00, 0xc050,	0x5fff, 0xc050,		0x21, 0
	.dw 0x7a00, 0xc050,	0x9fff, 0xc050,		0x21, 0
	.dw 0xba00, 0xc050,	0xdfff, 0xc050,		0x21, 0
	.dw 0xfa00, 0xc050,	0x1fff, 0xc051,		0x21, 0
	.dw 0x3a00, 0xc051,	0x5fff, 0xc051,		0x21, 0
	.dw 0x7a00, 0xc051,	0x9fff, 0xc051,		0x21, 0
	.dw 0xba00, 0xc051,	0xdfff, 0xc051,		0x21, 0
	.dw 0xfa00, 0xc051,	0x1fff, 0xc052,		0x21, 0
	.dw 0x3a00, 0xc052,	0x5fff, 0xc052,		0x21, 0
	.dw 0x7a00, 0xc052,	0x9fff, 0xc052,		0x21, 0
	.dw 0xba00, 0xc052,	0xdfff, 0xc052,		0x21, 0
	.dw 0xfa00, 0xc052,	0xffff, 0xc053,		0x21, 0
	.dw 0x1a00, 0xc054,	0x1fff, 0xc054,		0x21, 0
	.dw 0x3a00, 0xc054,	0x3fff, 0xc054,		0x21, 0
	.dw 0x5a00, 0xc054,	0x5fff, 0xc054,		0x21, 0
	.dw 0x7a00, 0xc054,	0x7fff, 0xc054,		0x21, 0
	.dw 0x9a00, 0xc054,	0x9fff, 0xc054,		0x21, 0
	.dw 0xba00, 0xc054,	0xbfff, 0xc054,		0x21, 0
	.dw 0xda00, 0xc054,	0xdfff, 0xc054,		0x21, 0
	.dw 0xfa00, 0xc054,	0xffff, 0xc054,		0x21, 0
	.dw 0x1a00, 0xc055,	0x1fff, 0xc055,		0x21, 0
	.dw 0x3a00, 0xc055,	0x3fff, 0xc055,		0x21, 0
	.dw 0x5a00, 0xc055,	0x5fff, 0xc055,		0x21, 0
	.dw 0x7a00, 0xc055,	0x7fff, 0xc055,		0x21, 0
	.dw 0x9a00, 0xc055,	0x9fff, 0xc055,		0x21, 0
	.dw 0xba00, 0xc055,	0xbfff, 0xc055,		0x21, 0
	.dw 0xda00, 0xc055,	0xdfff, 0xc055,		0x21, 0
	.dw 0xfa00, 0xc055,	0xffff, 0xc055,		0x21, 0
	.dw 0x1a00, 0xc056,	0x1fff, 0xc056,		0x21, 0
	.dw 0x3a00, 0xc056,	0x3fff, 0xc056,		0x21, 0
	.dw 0x5a00, 0xc056,	0x5fff, 0xc056,		0x21, 0
	.dw 0x7a00, 0xc056,	0x7fff, 0xc056,		0x21, 0
	.dw 0x9a00, 0xc056,	0x9fff, 0xc056,		0x21, 0
	.dw 0xba00, 0xc056,	0xbfff, 0xc056,		0x21, 0
	.dw 0xda00, 0xc056,	0xdfff, 0xc056,		0x21, 0
	.dw 0xfa00, 0xc056,	0xffff, 0xc056,		0x21, 0
	.dw 0x1a00, 0xc057,	0x1fff, 0xc057,		0x21, 0
	.dw 0x3a00, 0xc057,	0xffff, 0xc05f,		0x21, 0
	.dw 0x1a00, 0xc060,	0x3fff, 0xc060,		0x21, 0
	.dw 0x5a00, 0xc060,	0x7fff, 0xc060,		0x21, 0
	.dw 0x9a00, 0xc060,	0xbfff, 0xc060,		0x21, 0
	.dw 0xda00, 0xc060,	0xffff, 0xc060,		0x21, 0
	.dw 0x1a00, 0xc061,	0x3fff, 0xc061,		0x21, 0
	.dw 0x5a00, 0xc061,	0x7fff, 0xc061,		0x21, 0
	.dw 0x9a00, 0xc061,	0xbfff, 0xc061,		0x21, 0
	.dw 0xda00, 0xc061,	0xffff, 0xc061,		0x21, 0
	.dw 0x1a00, 0xc062,	0x3fff, 0xc062,		0x21, 0
	.dw 0x5a00, 0xc062,	0x7fff, 0xc062,		0x21, 0
	.dw 0x9a00, 0xc062,	0xbfff, 0xc062,		0x21, 0
	.dw 0xda00, 0xc062,	0xffff, 0xc062,		0x21, 0
	.dw 0x1a00, 0xc063,	0xffff, 0xc06f,		0x21, 0
	.dw 0x1a00, 0xc070,	0x3fff, 0xc070,		0x21, 0
	.dw 0x5a00, 0xc070,	0x7fff, 0xc070,		0x21, 0
	.dw 0x9a00, 0xc070,	0xbfff, 0xc070,		0x21, 0
	.dw 0xda00, 0xc070,	0xffff, 0xc070,		0x21, 0
	.dw 0x1a00, 0xc071,	0x3fff, 0xc071,		0x21, 0
	.dw 0x5a00, 0xc071,	0x7fff, 0xc071,		0x21, 0
	.dw 0x9a00, 0xc071,	0xbfff, 0xc071,		0x21, 0
	.dw 0xda00, 0xc071,	0xffff, 0xc071,		0x21, 0
	.dw 0x1a00, 0xc072,	0x3fff, 0xc072,		0x21, 0
	.dw 0x5a00, 0xc072,	0x7fff, 0xc072,		0x21, 0
	.dw 0x9a00, 0xc072,	0xbfff, 0xc072,		0x21, 0
	.dw 0xda00, 0xc072,	0xffff, 0xc07f,		0x21, 0
	.dw 0x1a00, 0xc080,	0x1fff, 0xc080,		0x21, 0
	.dw 0x3a00, 0xc080,	0x3fff, 0xc080,		0x21, 0
	.dw 0x5a00, 0xc080,	0x5fff, 0xc080,		0x21, 0
	.dw 0x7a00, 0xc080,	0x7fff, 0xc080,		0x21, 0
	.dw 0x9a00, 0xc080,	0x9fff, 0xc080,		0x21, 0
	.dw 0xba00, 0xc080,	0xbfff, 0xc080,		0x21, 0
	.dw 0xda00, 0xc080,	0xdfff, 0xc080,		0x21, 0
	.dw 0xfa00, 0xc080,	0xffff, 0xc080,		0x21, 0
	.dw 0x1a00, 0xc081,	0x1fff, 0xc081,		0x21, 0
	.dw 0x3a00, 0xc081,	0x3fff, 0xc081,		0x21, 0
	.dw 0x5a00, 0xc081,	0x5fff, 0xc081,		0x21, 0
	.dw 0x7a00, 0xc081,	0x7fff, 0xc081,		0x21, 0
	.dw 0x9a00, 0xc081,	0x9fff, 0xc081,		0x21, 0
	.dw 0xba00, 0xc081,	0xbfff, 0xc081,		0x21, 0
	.dw 0xda00, 0xc081,	0xdfff, 0xc081,		0x21, 0
	.dw 0xfa00, 0xc081,	0xffff, 0xc081,		0x21, 0
	.dw 0x1a00, 0xc082,	0x1fff, 0xc082,		0x21, 0
	.dw 0x3a00, 0xc082,	0x3fff, 0xc082,		0x21, 0
	.dw 0x5a00, 0xc082,	0x5fff, 0xc082,		0x21, 0
	.dw 0x7a00, 0xc082,	0x7fff, 0xc082,		0x21, 0
	.dw 0x9a00, 0xc082,	0x9fff, 0xc082,		0x21, 0
	.dw 0xba00, 0xc082,	0xbfff, 0xc082,		0x21, 0
	.dw 0xda00, 0xc082,	0xdfff, 0xc082,		0x21, 0
	.dw 0xfa00, 0xc082,	0xffff, 0xc082,		0x21, 0
	.dw 0x1a00, 0xc083,	0x1fff, 0xc083,		0x21, 0
	.dw 0x3a00, 0xc083,	0xffff, 0xc083,		0x21, 0
	.dw 0x1a00, 0xc084,	0x1fff, 0xc084,		0x21, 0
	.dw 0x3a00, 0xc084,	0x3fff, 0xc084,		0x21, 0
	.dw 0x5a00, 0xc084,	0x5fff, 0xc084,		0x21, 0
	.dw 0x7a00, 0xc084,	0x7fff, 0xc084,		0x21, 0
	.dw 0x9a00, 0xc084,	0x9fff, 0xc084,		0x21, 0
	.dw 0xba00, 0xc084,	0xbfff, 0xc084,		0x21, 0
	.dw 0xda00, 0xc084,	0xdfff, 0xc084,		0x21, 0
	.dw 0xfa00, 0xc084,	0xffff, 0xc084,		0x21, 0
	.dw 0x1a00, 0xc085,	0x1fff, 0xc085,		0x21, 0
	.dw 0x3a00, 0xc085,	0x3fff, 0xc085,		0x21, 0
	.dw 0x5a00, 0xc085,	0x5fff, 0xc085,		0x21, 0
	.dw 0x7a00, 0xc085,	0x7fff, 0xc085,		0x21, 0
	.dw 0x9a00, 0xc085,	0x9fff, 0xc085,		0x21, 0
	.dw 0xba00, 0xc085,	0xbfff, 0xc085,		0x21, 0
	.dw 0xda00, 0xc085,	0xdfff, 0xc085,		0x21, 0
	.dw 0xfa00, 0xc085,	0xffff, 0xc085,		0x21, 0
	.dw 0x1a00, 0xc086,	0x1fff, 0xc086,		0x21, 0
	.dw 0x3a00, 0xc086,	0x3fff, 0xc086,		0x21, 0
	.dw 0x5a00, 0xc086,	0x5fff, 0xc086,		0x21, 0
	.dw 0x7a00, 0xc086,	0x7fff, 0xc086,		0x21, 0
	.dw 0x9a00, 0xc086,	0x9fff, 0xc086,		0x21, 0
	.dw 0xba00, 0xc086,	0xbfff, 0xc086,		0x21, 0
	.dw 0xda00, 0xc086,	0xdfff, 0xc086,		0x21, 0
	.dw 0xfa00, 0xc086,	0xffff, 0xc086,		0x21, 0
	.dw 0x1a00, 0xc087,	0x1fff, 0xc087,		0x21, 0
	.dw 0x3a00, 0xc087,	0x1fff, 0xc088,		0x21, 0
	.dw 0x2040, 0xc088,	0x207f, 0xc088,		0x21, 0
	.dw 0x20c0, 0xc088,	0x20ff, 0xc088,		0x21, 0
	.dw 0x2140, 0xc088,	0x217f, 0xc088,		0x21, 0
	.dw 0x21c0, 0xc088,	0x21ff, 0xc088,		0x21, 0
	.dw 0x2240, 0xc088,	0x227f, 0xc088,		0x21, 0
	.dw 0x22c0, 0xc088,	0x22ff, 0xc088,		0x21, 0
	.dw 0x2340, 0xc088,	0x237f, 0xc088,		0x21, 0
	.dw 0x23c0, 0xc088,	0x23ff, 0xc088,		0x21, 0
	.dw 0x2440, 0xc088,	0x247f, 0xc088,		0x21, 0
	.dw 0x24c0, 0xc088,	0x24ff, 0xc088,		0x21, 0
	.dw 0x2540, 0xc088,	0x257f, 0xc088,		0x21, 0
	.dw 0x25c0, 0xc088,	0x25ff, 0xc088,		0x21, 0
	.dw 0x2640, 0xc088,	0x267f, 0xc088,		0x21, 0
	.dw 0x26c0, 0xc088,	0x26ff, 0xc088,		0x21, 0
	.dw 0x2740, 0xc088,	0x277f, 0xc088,		0x21, 0
	.dw 0x27c0, 0xc088,	0x27ff, 0xc088,		0x21, 0
	.dw 0x2840, 0xc088,	0x287f, 0xc088,		0x21, 0
	.dw 0x28c0, 0xc088,	0x28ff, 0xc088,		0x21, 0
	.dw 0x2940, 0xc088,	0x297f, 0xc088,		0x21, 0
	.dw 0x29c0, 0xc088,	0x29ff, 0xc088,		0x21, 0
	.dw 0x2a40, 0xc088,	0x2a7f, 0xc088,		0x21, 0
	.dw 0x2ac0, 0xc088,	0x2aff, 0xc088,		0x21, 0
	.dw 0x2b40, 0xc088,	0x2b7f, 0xc088,		0x21, 0
	.dw 0x2bc0, 0xc088,	0x2bff, 0xc088,		0x21, 0
	.dw 0x2c40, 0xc088,	0x2c7f, 0xc088,		0x21, 0
	.dw 0x2cc0, 0xc088,	0x2cff, 0xc088,		0x21, 0
	.dw 0x2d40, 0xc088,	0x2d7f, 0xc088,		0x21, 0
	.dw 0x2dc0, 0xc088,	0x2dff, 0xc088,		0x21, 0
	.dw 0x2e40, 0xc088,	0x2e7f, 0xc088,		0x21, 0
	.dw 0x2ec0, 0xc088,	0x2eff, 0xc088,		0x21, 0
	.dw 0x2f40, 0xc088,	0x2f7f, 0xc088,		0x21, 0
	.dw 0x2fc0, 0xc088,	0x2fff, 0xc088,		0x21, 0
	.dw 0x3040, 0xc088,	0x307f, 0xc088,		0x21, 0
	.dw 0x30c0, 0xc088,	0x30ff, 0xc088,		0x21, 0
	.dw 0x3140, 0xc088,	0x317f, 0xc088,		0x21, 0
	.dw 0x31c0, 0xc088,	0x31ff, 0xc088,		0x21, 0
	.dw 0x3240, 0xc088,	0x327f, 0xc088,		0x21, 0
	.dw 0x32c0, 0xc088,	0x32ff, 0xc088,		0x21, 0
	.dw 0x3340, 0xc088,	0x337f, 0xc088,		0x21, 0
	.dw 0x33c0, 0xc088,	0x33ff, 0xc088,		0x21, 0
	.dw 0x3440, 0xc088,	0x347f, 0xc088,		0x21, 0
	.dw 0x34c0, 0xc088,	0x34ff, 0xc088,		0x21, 0
	.dw 0x3540, 0xc088,	0x357f, 0xc088,		0x21, 0
	.dw 0x35c0, 0xc088,	0x35ff, 0xc088,		0x21, 0
	.dw 0x3640, 0xc088,	0x367f, 0xc088,		0x21, 0
	.dw 0x36c0, 0xc088,	0x36ff, 0xc088,		0x21, 0
	.dw 0x3740, 0xc088,	0x377f, 0xc088,		0x21, 0
	.dw 0x37c0, 0xc088,	0x37ff, 0xc088,		0x21, 0
	.dw 0x3840, 0xc088,	0x387f, 0xc088,		0x21, 0
	.dw 0x38c0, 0xc088,	0x38ff, 0xc088,		0x21, 0
	.dw 0x3940, 0xc088,	0x397f, 0xc088,		0x21, 0
	.dw 0x39c0, 0xc088,	0x5fff, 0xc088,		0x21, 0
	.dw 0x6040, 0xc088,	0x607f, 0xc088,		0x21, 0
	.dw 0x60c0, 0xc088,	0x60ff, 0xc088,		0x21, 0
	.dw 0x6140, 0xc088,	0x617f, 0xc088,		0x21, 0
	.dw 0x61c0, 0xc088,	0x61ff, 0xc088,		0x21, 0
	.dw 0x6240, 0xc088,	0x627f, 0xc088,		0x21, 0
	.dw 0x62c0, 0xc088,	0x62ff, 0xc088,		0x21, 0
	.dw 0x6340, 0xc088,	0x637f, 0xc088,		0x21, 0
	.dw 0x63c0, 0xc088,	0x63ff, 0xc088,		0x21, 0
	.dw 0x6440, 0xc088,	0x647f, 0xc088,		0x21, 0
	.dw 0x64c0, 0xc088,	0x64ff, 0xc088,		0x21, 0
	.dw 0x6540, 0xc088,	0x657f, 0xc088,		0x21, 0
	.dw 0x65c0, 0xc088,	0x65ff, 0xc088,		0x21, 0
	.dw 0x6640, 0xc088,	0x667f, 0xc088,		0x21, 0
	.dw 0x66c0, 0xc088,	0x66ff, 0xc088,		0x21, 0
	.dw 0x6740, 0xc088,	0x677f, 0xc088,		0x21, 0
	.dw 0x67c0, 0xc088,	0x67ff, 0xc088,		0x21, 0
	.dw 0x6840, 0xc088,	0x687f, 0xc088,		0x21, 0
	.dw 0x68c0, 0xc088,	0x68ff, 0xc088,		0x21, 0
	.dw 0x6940, 0xc088,	0x697f, 0xc088,		0x21, 0
	.dw 0x69c0, 0xc088,	0x69ff, 0xc088,		0x21, 0
	.dw 0x6a40, 0xc088,	0x6a7f, 0xc088,		0x21, 0
	.dw 0x6ac0, 0xc088,	0x6aff, 0xc088,		0x21, 0
	.dw 0x6b40, 0xc088,	0x6b7f, 0xc088,		0x21, 0
	.dw 0x6bc0, 0xc088,	0x6bff, 0xc088,		0x21, 0
	.dw 0x6c40, 0xc088,	0x6c7f, 0xc088,		0x21, 0
	.dw 0x6cc0, 0xc088,	0x6cff, 0xc088,		0x21, 0
	.dw 0x6d40, 0xc088,	0x6d7f, 0xc088,		0x21, 0
	.dw 0x6dc0, 0xc088,	0x6dff, 0xc088,		0x21, 0
	.dw 0x6e40, 0xc088,	0x6e7f, 0xc088,		0x21, 0
	.dw 0x6ec0, 0xc088,	0x6eff, 0xc088,		0x21, 0
	.dw 0x6f40, 0xc088,	0x6f7f, 0xc088,		0x21, 0
	.dw 0x6fc0, 0xc088,	0x6fff, 0xc088,		0x21, 0
	.dw 0x7040, 0xc088,	0x707f, 0xc088,		0x21, 0
	.dw 0x70c0, 0xc088,	0x70ff, 0xc088,		0x21, 0
	.dw 0x7140, 0xc088,	0x717f, 0xc088,		0x21, 0
	.dw 0x71c0, 0xc088,	0x71ff, 0xc088,		0x21, 0
	.dw 0x7240, 0xc088,	0x727f, 0xc088,		0x21, 0
	.dw 0x72c0, 0xc088,	0x72ff, 0xc088,		0x21, 0
	.dw 0x7340, 0xc088,	0x737f, 0xc088,		0x21, 0
	.dw 0x73c0, 0xc088,	0x73ff, 0xc088,		0x21, 0
	.dw 0x7440, 0xc088,	0x747f, 0xc088,		0x21, 0
	.dw 0x74c0, 0xc088,	0x74ff, 0xc088,		0x21, 0
	.dw 0x7540, 0xc088,	0x757f, 0xc088,		0x21, 0
	.dw 0x75c0, 0xc088,	0x75ff, 0xc088,		0x21, 0
	.dw 0x7640, 0xc088,	0x767f, 0xc088,		0x21, 0
	.dw 0x76c0, 0xc088,	0x76ff, 0xc088,		0x21, 0
	.dw 0x7740, 0xc088,	0x777f, 0xc088,		0x21, 0
	.dw 0x77c0, 0xc088,	0x77ff, 0xc088,		0x21, 0
	.dw 0x7840, 0xc088,	0x787f, 0xc088,		0x21, 0
	.dw 0x78c0, 0xc088,	0x78ff, 0xc088,		0x21, 0
	.dw 0x7940, 0xc088,	0x797f, 0xc088,		0x21, 0
	.dw 0x79c0, 0xc088,	0x9fff, 0xc088,		0x21, 0
	.dw 0xa040, 0xc088,	0xa07f, 0xc088,		0x21, 0
	.dw 0xa0c0, 0xc088,	0xa0ff, 0xc088,		0x21, 0
	.dw 0xa140, 0xc088,	0xa17f, 0xc088,		0x21, 0
	.dw 0xa1c0, 0xc088,	0xa1ff, 0xc088,		0x21, 0
	.dw 0xa240, 0xc088,	0xa27f, 0xc088,		0x21, 0
	.dw 0xa2c0, 0xc088,	0xa2ff, 0xc088,		0x21, 0
	.dw 0xa340, 0xc088,	0xa37f, 0xc088,		0x21, 0
	.dw 0xa3c0, 0xc088,	0xa3ff, 0xc088,		0x21, 0
	.dw 0xa440, 0xc088,	0xa47f, 0xc088,		0x21, 0
	.dw 0xa4c0, 0xc088,	0xa4ff, 0xc088,		0x21, 0
	.dw 0xa540, 0xc088,	0xa57f, 0xc088,		0x21, 0
	.dw 0xa5c0, 0xc088,	0xa5ff, 0xc088,		0x21, 0
	.dw 0xa640, 0xc088,	0xa67f, 0xc088,		0x21, 0
	.dw 0xa6c0, 0xc088,	0xa6ff, 0xc088,		0x21, 0
	.dw 0xa740, 0xc088,	0xa77f, 0xc088,		0x21, 0
	.dw 0xa7c0, 0xc088,	0xa7ff, 0xc088,		0x21, 0
	.dw 0xa840, 0xc088,	0xa87f, 0xc088,		0x21, 0
	.dw 0xa8c0, 0xc088,	0xa8ff, 0xc088,		0x21, 0
	.dw 0xa940, 0xc088,	0xa97f, 0xc088,		0x21, 0
	.dw 0xa9c0, 0xc088,	0xa9ff, 0xc088,		0x21, 0
	.dw 0xaa40, 0xc088,	0xaa7f, 0xc088,		0x21, 0
	.dw 0xaac0, 0xc088,	0xaaff, 0xc088,		0x21, 0
	.dw 0xab40, 0xc088,	0xab7f, 0xc088,		0x21, 0
	.dw 0xabc0, 0xc088,	0xabff, 0xc088,		0x21, 0
	.dw 0xac40, 0xc088,	0xac7f, 0xc088,		0x21, 0
	.dw 0xacc0, 0xc088,	0xacff, 0xc088,		0x21, 0
	.dw 0xad40, 0xc088,	0xad7f, 0xc088,		0x21, 0
	.dw 0xadc0, 0xc088,	0xadff, 0xc088,		0x21, 0
	.dw 0xae40, 0xc088,	0xae7f, 0xc088,		0x21, 0
	.dw 0xaec0, 0xc088,	0xaeff, 0xc088,		0x21, 0
	.dw 0xaf40, 0xc088,	0xaf7f, 0xc088,		0x21, 0
	.dw 0xafc0, 0xc088,	0xafff, 0xc088,		0x21, 0
	.dw 0xb040, 0xc088,	0xb07f, 0xc088,		0x21, 0
	.dw 0xb0c0, 0xc088,	0xb0ff, 0xc088,		0x21, 0
	.dw 0xb140, 0xc088,	0xb17f, 0xc088,		0x21, 0
	.dw 0xb1c0, 0xc088,	0xb1ff, 0xc088,		0x21, 0
	.dw 0xb240, 0xc088,	0xb27f, 0xc088,		0x21, 0
	.dw 0xb2c0, 0xc088,	0xb2ff, 0xc088,		0x21, 0
	.dw 0xb340, 0xc088,	0xb37f, 0xc088,		0x21, 0
	.dw 0xb3c0, 0xc088,	0xb3ff, 0xc088,		0x21, 0
	.dw 0xb440, 0xc088,	0xb47f, 0xc088,		0x21, 0
	.dw 0xb4c0, 0xc088,	0xb4ff, 0xc088,		0x21, 0
	.dw 0xb540, 0xc088,	0xb57f, 0xc088,		0x21, 0
	.dw 0xb5c0, 0xc088,	0xb5ff, 0xc088,		0x21, 0
	.dw 0xb640, 0xc088,	0xb67f, 0xc088,		0x21, 0
	.dw 0xb6c0, 0xc088,	0xb6ff, 0xc088,		0x21, 0
	.dw 0xb740, 0xc088,	0xb77f, 0xc088,		0x21, 0
	.dw 0xb7c0, 0xc088,	0xb7ff, 0xc088,		0x21, 0
	.dw 0xb840, 0xc088,	0xb87f, 0xc088,		0x21, 0
	.dw 0xb8c0, 0xc088,	0xb8ff, 0xc088,		0x21, 0
	.dw 0xb940, 0xc088,	0xb97f, 0xc088,		0x21, 0
	.dw 0xb9c0, 0xc088,	0xdfff, 0xc088,		0x21, 0
	.dw 0xe040, 0xc088,	0xe07f, 0xc088,		0x21, 0
	.dw 0xe0c0, 0xc088,	0xe0ff, 0xc088,		0x21, 0
	.dw 0xe140, 0xc088,	0xe17f, 0xc088,		0x21, 0
	.dw 0xe1c0, 0xc088,	0xe1ff, 0xc088,		0x21, 0
	.dw 0xe240, 0xc088,	0xe27f, 0xc088,		0x21, 0
	.dw 0xe2c0, 0xc088,	0xe2ff, 0xc088,		0x21, 0
	.dw 0xe340, 0xc088,	0xe37f, 0xc088,		0x21, 0
	.dw 0xe3c0, 0xc088,	0xe3ff, 0xc088,		0x21, 0
	.dw 0xe440, 0xc088,	0xe47f, 0xc088,		0x21, 0
	.dw 0xe4c0, 0xc088,	0xe4ff, 0xc088,		0x21, 0
	.dw 0xe540, 0xc088,	0xe57f, 0xc088,		0x21, 0
	.dw 0xe5c0, 0xc088,	0xe5ff, 0xc088,		0x21, 0
	.dw 0xe640, 0xc088,	0xe67f, 0xc088,		0x21, 0
	.dw 0xe6c0, 0xc088,	0xe6ff, 0xc088,		0x21, 0
	.dw 0xe740, 0xc088,	0xe77f, 0xc088,		0x21, 0
	.dw 0xe7c0, 0xc088,	0xe7ff, 0xc088,		0x21, 0
	.dw 0xe840, 0xc088,	0xe87f, 0xc088,		0x21, 0
	.dw 0xe8c0, 0xc088,	0xe8ff, 0xc088,		0x21, 0
	.dw 0xe940, 0xc088,	0xe97f, 0xc088,		0x21, 0
	.dw 0xe9c0, 0xc088,	0xe9ff, 0xc088,		0x21, 0
	.dw 0xea40, 0xc088,	0xea7f, 0xc088,		0x21, 0
	.dw 0xeac0, 0xc088,	0xeaff, 0xc088,		0x21, 0
	.dw 0xeb40, 0xc088,	0xeb7f, 0xc088,		0x21, 0
	.dw 0xebc0, 0xc088,	0xebff, 0xc088,		0x21, 0
	.dw 0xec40, 0xc088,	0xec7f, 0xc088,		0x21, 0
	.dw 0xecc0, 0xc088,	0xecff, 0xc088,		0x21, 0
	.dw 0xed40, 0xc088,	0xed7f, 0xc088,		0x21, 0
	.dw 0xedc0, 0xc088,	0xedff, 0xc088,		0x21, 0
	.dw 0xee40, 0xc088,	0xee7f, 0xc088,		0x21, 0
	.dw 0xeec0, 0xc088,	0xeeff, 0xc088,		0x21, 0
	.dw 0xef40, 0xc088,	0xef7f, 0xc088,		0x21, 0
	.dw 0xefc0, 0xc088,	0xefff, 0xc088,		0x21, 0
	.dw 0xf040, 0xc088,	0xf07f, 0xc088,		0x21, 0
	.dw 0xf0c0, 0xc088,	0xf0ff, 0xc088,		0x21, 0
	.dw 0xf140, 0xc088,	0xf17f, 0xc088,		0x21, 0
	.dw 0xf1c0, 0xc088,	0xf1ff, 0xc088,		0x21, 0
	.dw 0xf240, 0xc088,	0xf27f, 0xc088,		0x21, 0
	.dw 0xf2c0, 0xc088,	0xf2ff, 0xc088,		0x21, 0
	.dw 0xf340, 0xc088,	0xf37f, 0xc088,		0x21, 0
	.dw 0xf3c0, 0xc088,	0xf3ff, 0xc088,		0x21, 0
	.dw 0xf440, 0xc088,	0xf47f, 0xc088,		0x21, 0
	.dw 0xf4c0, 0xc088,	0xf4ff, 0xc088,		0x21, 0
	.dw 0xf540, 0xc088,	0xf57f, 0xc088,		0x21, 0
	.dw 0xf5c0, 0xc088,	0xf5ff, 0xc088,		0x21, 0
	.dw 0xf640, 0xc088,	0xf67f, 0xc088,		0x21, 0
	.dw 0xf6c0, 0xc088,	0xf6ff, 0xc088,		0x21, 0
	.dw 0xf740, 0xc088,	0xf77f, 0xc088,		0x21, 0
	.dw 0xf7c0, 0xc088,	0xf7ff, 0xc088,		0x21, 0
	.dw 0xf840, 0xc088,	0xf87f, 0xc088,		0x21, 0
	.dw 0xf8c0, 0xc088,	0xf8ff, 0xc088,		0x21, 0
	.dw 0xf940, 0xc088,	0xf97f, 0xc088,		0x21, 0
	.dw 0xf9c0, 0xc088,	0x1fff, 0xc089,		0x21, 0
	.dw 0x2040, 0xc089,	0x207f, 0xc089,		0x21, 0
	.dw 0x20c0, 0xc089,	0x20ff, 0xc089,		0x21, 0
	.dw 0x2140, 0xc089,	0x217f, 0xc089,		0x21, 0
	.dw 0x21c0, 0xc089,	0x21ff, 0xc089,		0x21, 0
	.dw 0x2240, 0xc089,	0x227f, 0xc089,		0x21, 0
	.dw 0x22c0, 0xc089,	0x22ff, 0xc089,		0x21, 0
	.dw 0x2340, 0xc089,	0x237f, 0xc089,		0x21, 0
	.dw 0x23c0, 0xc089,	0x23ff, 0xc089,		0x21, 0
	.dw 0x2440, 0xc089,	0x247f, 0xc089,		0x21, 0
	.dw 0x24c0, 0xc089,	0x24ff, 0xc089,		0x21, 0
	.dw 0x2540, 0xc089,	0x257f, 0xc089,		0x21, 0
	.dw 0x25c0, 0xc089,	0x25ff, 0xc089,		0x21, 0
	.dw 0x2640, 0xc089,	0x267f, 0xc089,		0x21, 0
	.dw 0x26c0, 0xc089,	0x26ff, 0xc089,		0x21, 0
	.dw 0x2740, 0xc089,	0x277f, 0xc089,		0x21, 0
	.dw 0x27c0, 0xc089,	0x27ff, 0xc089,		0x21, 0
	.dw 0x2840, 0xc089,	0x287f, 0xc089,		0x21, 0
	.dw 0x28c0, 0xc089,	0x28ff, 0xc089,		0x21, 0
	.dw 0x2940, 0xc089,	0x297f, 0xc089,		0x21, 0
	.dw 0x29c0, 0xc089,	0x29ff, 0xc089,		0x21, 0
	.dw 0x2a40, 0xc089,	0x2a7f, 0xc089,		0x21, 0
	.dw 0x2ac0, 0xc089,	0x2aff, 0xc089,		0x21, 0
	.dw 0x2b40, 0xc089,	0x2b7f, 0xc089,		0x21, 0
	.dw 0x2bc0, 0xc089,	0x2bff, 0xc089,		0x21, 0
	.dw 0x2c40, 0xc089,	0x2c7f, 0xc089,		0x21, 0
	.dw 0x2cc0, 0xc089,	0x2cff, 0xc089,		0x21, 0
	.dw 0x2d40, 0xc089,	0x2d7f, 0xc089,		0x21, 0
	.dw 0x2dc0, 0xc089,	0x2dff, 0xc089,		0x21, 0
	.dw 0x2e40, 0xc089,	0x2e7f, 0xc089,		0x21, 0
	.dw 0x2ec0, 0xc089,	0x2eff, 0xc089,		0x21, 0
	.dw 0x2f40, 0xc089,	0x2f7f, 0xc089,		0x21, 0
	.dw 0x2fc0, 0xc089,	0x2fff, 0xc089,		0x21, 0
	.dw 0x3040, 0xc089,	0x307f, 0xc089,		0x21, 0
	.dw 0x30c0, 0xc089,	0x30ff, 0xc089,		0x21, 0
	.dw 0x3140, 0xc089,	0x317f, 0xc089,		0x21, 0
	.dw 0x31c0, 0xc089,	0x31ff, 0xc089,		0x21, 0
	.dw 0x3240, 0xc089,	0x327f, 0xc089,		0x21, 0
	.dw 0x32c0, 0xc089,	0x32ff, 0xc089,		0x21, 0
	.dw 0x3340, 0xc089,	0x337f, 0xc089,		0x21, 0
	.dw 0x33c0, 0xc089,	0x33ff, 0xc089,		0x21, 0
	.dw 0x3440, 0xc089,	0x347f, 0xc089,		0x21, 0
	.dw 0x34c0, 0xc089,	0x34ff, 0xc089,		0x21, 0
	.dw 0x3540, 0xc089,	0x357f, 0xc089,		0x21, 0
	.dw 0x35c0, 0xc089,	0x35ff, 0xc089,		0x21, 0
	.dw 0x3640, 0xc089,	0x367f, 0xc089,		0x21, 0
	.dw 0x36c0, 0xc089,	0x36ff, 0xc089,		0x21, 0
	.dw 0x3740, 0xc089,	0x377f, 0xc089,		0x21, 0
	.dw 0x37c0, 0xc089,	0x37ff, 0xc089,		0x21, 0
	.dw 0x3840, 0xc089,	0x387f, 0xc089,		0x21, 0
	.dw 0x38c0, 0xc089,	0x38ff, 0xc089,		0x21, 0
	.dw 0x3940, 0xc089,	0x397f, 0xc089,		0x21, 0
	.dw 0x39c0, 0xc089,	0x5fff, 0xc089,		0x21, 0
	.dw 0x6040, 0xc089,	0x607f, 0xc089,		0x21, 0
	.dw 0x60c0, 0xc089,	0x60ff, 0xc089,		0x21, 0
	.dw 0x6140, 0xc089,	0x617f, 0xc089,		0x21, 0
	.dw 0x61c0, 0xc089,	0x61ff, 0xc089,		0x21, 0
	.dw 0x6240, 0xc089,	0x627f, 0xc089,		0x21, 0
	.dw 0x62c0, 0xc089,	0x62ff, 0xc089,		0x21, 0
	.dw 0x6340, 0xc089,	0x637f, 0xc089,		0x21, 0
	.dw 0x63c0, 0xc089,	0x63ff, 0xc089,		0x21, 0
	.dw 0x6440, 0xc089,	0x647f, 0xc089,		0x21, 0
	.dw 0x64c0, 0xc089,	0x64ff, 0xc089,		0x21, 0
	.dw 0x6540, 0xc089,	0x657f, 0xc089,		0x21, 0
	.dw 0x65c0, 0xc089,	0x65ff, 0xc089,		0x21, 0
	.dw 0x6640, 0xc089,	0x667f, 0xc089,		0x21, 0
	.dw 0x66c0, 0xc089,	0x66ff, 0xc089,		0x21, 0
	.dw 0x6740, 0xc089,	0x677f, 0xc089,		0x21, 0
	.dw 0x67c0, 0xc089,	0x67ff, 0xc089,		0x21, 0
	.dw 0x6840, 0xc089,	0x687f, 0xc089,		0x21, 0
	.dw 0x68c0, 0xc089,	0x68ff, 0xc089,		0x21, 0
	.dw 0x6940, 0xc089,	0x697f, 0xc089,		0x21, 0
	.dw 0x69c0, 0xc089,	0x69ff, 0xc089,		0x21, 0
	.dw 0x6a40, 0xc089,	0x6a7f, 0xc089,		0x21, 0
	.dw 0x6ac0, 0xc089,	0x6aff, 0xc089,		0x21, 0
	.dw 0x6b40, 0xc089,	0x6b7f, 0xc089,		0x21, 0
	.dw 0x6bc0, 0xc089,	0x6bff, 0xc089,		0x21, 0
	.dw 0x6c40, 0xc089,	0x6c7f, 0xc089,		0x21, 0
	.dw 0x6cc0, 0xc089,	0x6cff, 0xc089,		0x21, 0
	.dw 0x6d40, 0xc089,	0x6d7f, 0xc089,		0x21, 0
	.dw 0x6dc0, 0xc089,	0x6dff, 0xc089,		0x21, 0
	.dw 0x6e40, 0xc089,	0x6e7f, 0xc089,		0x21, 0
	.dw 0x6ec0, 0xc089,	0x6eff, 0xc089,		0x21, 0
	.dw 0x6f40, 0xc089,	0x6f7f, 0xc089,		0x21, 0
	.dw 0x6fc0, 0xc089,	0x6fff, 0xc089,		0x21, 0
	.dw 0x7040, 0xc089,	0x707f, 0xc089,		0x21, 0
	.dw 0x70c0, 0xc089,	0x70ff, 0xc089,		0x21, 0
	.dw 0x7140, 0xc089,	0x717f, 0xc089,		0x21, 0
	.dw 0x71c0, 0xc089,	0x71ff, 0xc089,		0x21, 0
	.dw 0x7240, 0xc089,	0x727f, 0xc089,		0x21, 0
	.dw 0x72c0, 0xc089,	0x72ff, 0xc089,		0x21, 0
	.dw 0x7340, 0xc089,	0x737f, 0xc089,		0x21, 0
	.dw 0x73c0, 0xc089,	0x73ff, 0xc089,		0x21, 0
	.dw 0x7440, 0xc089,	0x747f, 0xc089,		0x21, 0
	.dw 0x74c0, 0xc089,	0x74ff, 0xc089,		0x21, 0
	.dw 0x7540, 0xc089,	0x757f, 0xc089,		0x21, 0
	.dw 0x75c0, 0xc089,	0x75ff, 0xc089,		0x21, 0
	.dw 0x7640, 0xc089,	0x767f, 0xc089,		0x21, 0
	.dw 0x76c0, 0xc089,	0x76ff, 0xc089,		0x21, 0
	.dw 0x7740, 0xc089,	0x777f, 0xc089,		0x21, 0
	.dw 0x77c0, 0xc089,	0x77ff, 0xc089,		0x21, 0
	.dw 0x7840, 0xc089,	0x787f, 0xc089,		0x21, 0
	.dw 0x78c0, 0xc089,	0x78ff, 0xc089,		0x21, 0
	.dw 0x7940, 0xc089,	0x797f, 0xc089,		0x21, 0
	.dw 0x79c0, 0xc089,	0x9fff, 0xc089,		0x21, 0
	.dw 0xa040, 0xc089,	0xa07f, 0xc089,		0x21, 0
	.dw 0xa0c0, 0xc089,	0xa0ff, 0xc089,		0x21, 0
	.dw 0xa140, 0xc089,	0xa17f, 0xc089,		0x21, 0
	.dw 0xa1c0, 0xc089,	0xa1ff, 0xc089,		0x21, 0
	.dw 0xa240, 0xc089,	0xa27f, 0xc089,		0x21, 0
	.dw 0xa2c0, 0xc089,	0xa2ff, 0xc089,		0x21, 0
	.dw 0xa340, 0xc089,	0xa37f, 0xc089,		0x21, 0
	.dw 0xa3c0, 0xc089,	0xa3ff, 0xc089,		0x21, 0
	.dw 0xa440, 0xc089,	0xa47f, 0xc089,		0x21, 0
	.dw 0xa4c0, 0xc089,	0xa4ff, 0xc089,		0x21, 0
	.dw 0xa540, 0xc089,	0xa57f, 0xc089,		0x21, 0
	.dw 0xa5c0, 0xc089,	0xa5ff, 0xc089,		0x21, 0
	.dw 0xa640, 0xc089,	0xa67f, 0xc089,		0x21, 0
	.dw 0xa6c0, 0xc089,	0xa6ff, 0xc089,		0x21, 0
	.dw 0xa740, 0xc089,	0xa77f, 0xc089,		0x21, 0
	.dw 0xa7c0, 0xc089,	0xa7ff, 0xc089,		0x21, 0
	.dw 0xa840, 0xc089,	0xa87f, 0xc089,		0x21, 0
	.dw 0xa8c0, 0xc089,	0xa8ff, 0xc089,		0x21, 0
	.dw 0xa940, 0xc089,	0xa97f, 0xc089,		0x21, 0
	.dw 0xa9c0, 0xc089,	0xa9ff, 0xc089,		0x21, 0
	.dw 0xaa40, 0xc089,	0xaa7f, 0xc089,		0x21, 0
	.dw 0xaac0, 0xc089,	0xaaff, 0xc089,		0x21, 0
	.dw 0xab40, 0xc089,	0xab7f, 0xc089,		0x21, 0
	.dw 0xabc0, 0xc089,	0xabff, 0xc089,		0x21, 0
	.dw 0xac40, 0xc089,	0xac7f, 0xc089,		0x21, 0
	.dw 0xacc0, 0xc089,	0xacff, 0xc089,		0x21, 0
	.dw 0xad40, 0xc089,	0xad7f, 0xc089,		0x21, 0
	.dw 0xadc0, 0xc089,	0xadff, 0xc089,		0x21, 0
	.dw 0xae40, 0xc089,	0xae7f, 0xc089,		0x21, 0
	.dw 0xaec0, 0xc089,	0xaeff, 0xc089,		0x21, 0
	.dw 0xaf40, 0xc089,	0xaf7f, 0xc089,		0x21, 0
	.dw 0xafc0, 0xc089,	0xafff, 0xc089,		0x21, 0
	.dw 0xb040, 0xc089,	0xb07f, 0xc089,		0x21, 0
	.dw 0xb0c0, 0xc089,	0xb0ff, 0xc089,		0x21, 0
	.dw 0xb140, 0xc089,	0xb17f, 0xc089,		0x21, 0
	.dw 0xb1c0, 0xc089,	0xb1ff, 0xc089,		0x21, 0
	.dw 0xb240, 0xc089,	0xb27f, 0xc089,		0x21, 0
	.dw 0xb2c0, 0xc089,	0xb2ff, 0xc089,		0x21, 0
	.dw 0xb340, 0xc089,	0xb37f, 0xc089,		0x21, 0
	.dw 0xb3c0, 0xc089,	0xb3ff, 0xc089,		0x21, 0
	.dw 0xb440, 0xc089,	0xb47f, 0xc089,		0x21, 0
	.dw 0xb4c0, 0xc089,	0xb4ff, 0xc089,		0x21, 0
	.dw 0xb540, 0xc089,	0xb57f, 0xc089,		0x21, 0
	.dw 0xb5c0, 0xc089,	0xb5ff, 0xc089,		0x21, 0
	.dw 0xb640, 0xc089,	0xb67f, 0xc089,		0x21, 0
	.dw 0xb6c0, 0xc089,	0xb6ff, 0xc089,		0x21, 0
	.dw 0xb740, 0xc089,	0xb77f, 0xc089,		0x21, 0
	.dw 0xb7c0, 0xc089,	0xb7ff, 0xc089,		0x21, 0
	.dw 0xb840, 0xc089,	0xb87f, 0xc089,		0x21, 0
	.dw 0xb8c0, 0xc089,	0xb8ff, 0xc089,		0x21, 0
	.dw 0xb940, 0xc089,	0xb97f, 0xc089,		0x21, 0
	.dw 0xb9c0, 0xc089,	0xdfff, 0xc089,		0x21, 0
	.dw 0xe040, 0xc089,	0xe07f, 0xc089,		0x21, 0
	.dw 0xe0c0, 0xc089,	0xe0ff, 0xc089,		0x21, 0
	.dw 0xe140, 0xc089,	0xe17f, 0xc089,		0x21, 0
	.dw 0xe1c0, 0xc089,	0xe1ff, 0xc089,		0x21, 0
	.dw 0xe240, 0xc089,	0xe27f, 0xc089,		0x21, 0
	.dw 0xe2c0, 0xc089,	0xe2ff, 0xc089,		0x21, 0
	.dw 0xe340, 0xc089,	0xe37f, 0xc089,		0x21, 0
	.dw 0xe3c0, 0xc089,	0xe3ff, 0xc089,		0x21, 0
	.dw 0xe440, 0xc089,	0xe47f, 0xc089,		0x21, 0
	.dw 0xe4c0, 0xc089,	0xe4ff, 0xc089,		0x21, 0
	.dw 0xe540, 0xc089,	0xe57f, 0xc089,		0x21, 0
	.dw 0xe5c0, 0xc089,	0xe5ff, 0xc089,		0x21, 0
	.dw 0xe640, 0xc089,	0xe67f, 0xc089,		0x21, 0
	.dw 0xe6c0, 0xc089,	0xe6ff, 0xc089,		0x21, 0
	.dw 0xe740, 0xc089,	0xe77f, 0xc089,		0x21, 0
	.dw 0xe7c0, 0xc089,	0xe7ff, 0xc089,		0x21, 0
	.dw 0xe840, 0xc089,	0xe87f, 0xc089,		0x21, 0
	.dw 0xe8c0, 0xc089,	0xe8ff, 0xc089,		0x21, 0
	.dw 0xe940, 0xc089,	0xe97f, 0xc089,		0x21, 0
	.dw 0xe9c0, 0xc089,	0xe9ff, 0xc089,		0x21, 0
	.dw 0xea40, 0xc089,	0xea7f, 0xc089,		0x21, 0
	.dw 0xeac0, 0xc089,	0xeaff, 0xc089,		0x21, 0
	.dw 0xeb40, 0xc089,	0xeb7f, 0xc089,		0x21, 0
	.dw 0xebc0, 0xc089,	0xebff, 0xc089,		0x21, 0
	.dw 0xec40, 0xc089,	0xec7f, 0xc089,		0x21, 0
	.dw 0xecc0, 0xc089,	0xecff, 0xc089,		0x21, 0
	.dw 0xed40, 0xc089,	0xed7f, 0xc089,		0x21, 0
	.dw 0xedc0, 0xc089,	0xedff, 0xc089,		0x21, 0
	.dw 0xee40, 0xc089,	0xee7f, 0xc089,		0x21, 0
	.dw 0xeec0, 0xc089,	0xeeff, 0xc089,		0x21, 0
	.dw 0xef40, 0xc089,	0xef7f, 0xc089,		0x21, 0
	.dw 0xefc0, 0xc089,	0xefff, 0xc089,		0x21, 0
	.dw 0xf040, 0xc089,	0xf07f, 0xc089,		0x21, 0
	.dw 0xf0c0, 0xc089,	0xf0ff, 0xc089,		0x21, 0
	.dw 0xf140, 0xc089,	0xf17f, 0xc089,		0x21, 0
	.dw 0xf1c0, 0xc089,	0xf1ff, 0xc089,		0x21, 0
	.dw 0xf240, 0xc089,	0xf27f, 0xc089,		0x21, 0
	.dw 0xf2c0, 0xc089,	0xf2ff, 0xc089,		0x21, 0
	.dw 0xf340, 0xc089,	0xf37f, 0xc089,		0x21, 0
	.dw 0xf3c0, 0xc089,	0xf3ff, 0xc089,		0x21, 0
	.dw 0xf440, 0xc089,	0xf47f, 0xc089,		0x21, 0
	.dw 0xf4c0, 0xc089,	0xf4ff, 0xc089,		0x21, 0
	.dw 0xf540, 0xc089,	0xf57f, 0xc089,		0x21, 0
	.dw 0xf5c0, 0xc089,	0xf5ff, 0xc089,		0x21, 0
	.dw 0xf640, 0xc089,	0xf67f, 0xc089,		0x21, 0
	.dw 0xf6c0, 0xc089,	0xf6ff, 0xc089,		0x21, 0
	.dw 0xf740, 0xc089,	0xf77f, 0xc089,		0x21, 0
	.dw 0xf7c0, 0xc089,	0xf7ff, 0xc089,		0x21, 0
	.dw 0xf840, 0xc089,	0xf87f, 0xc089,		0x21, 0
	.dw 0xf8c0, 0xc089,	0xf8ff, 0xc089,		0x21, 0
	.dw 0xf940, 0xc089,	0xf97f, 0xc089,		0x21, 0
	.dw 0xf9c0, 0xc089,	0x1fff, 0xc08a,		0x21, 0
	.dw 0x2040, 0xc08a,	0x207f, 0xc08a,		0x21, 0
	.dw 0x20c0, 0xc08a,	0x20ff, 0xc08a,		0x21, 0
	.dw 0x2140, 0xc08a,	0x217f, 0xc08a,		0x21, 0
	.dw 0x21c0, 0xc08a,	0x21ff, 0xc08a,		0x21, 0
	.dw 0x2240, 0xc08a,	0x227f, 0xc08a,		0x21, 0
	.dw 0x22c0, 0xc08a,	0x22ff, 0xc08a,		0x21, 0
	.dw 0x2340, 0xc08a,	0x237f, 0xc08a,		0x21, 0
	.dw 0x23c0, 0xc08a,	0x23ff, 0xc08a,		0x21, 0
	.dw 0x2440, 0xc08a,	0x247f, 0xc08a,		0x21, 0
	.dw 0x24c0, 0xc08a,	0x24ff, 0xc08a,		0x21, 0
	.dw 0x2540, 0xc08a,	0x257f, 0xc08a,		0x21, 0
	.dw 0x25c0, 0xc08a,	0x25ff, 0xc08a,		0x21, 0
	.dw 0x2640, 0xc08a,	0x267f, 0xc08a,		0x21, 0
	.dw 0x26c0, 0xc08a,	0x26ff, 0xc08a,		0x21, 0
	.dw 0x2740, 0xc08a,	0x277f, 0xc08a,		0x21, 0
	.dw 0x27c0, 0xc08a,	0x27ff, 0xc08a,		0x21, 0
	.dw 0x2840, 0xc08a,	0x287f, 0xc08a,		0x21, 0
	.dw 0x28c0, 0xc08a,	0x28ff, 0xc08a,		0x21, 0
	.dw 0x2940, 0xc08a,	0x297f, 0xc08a,		0x21, 0
	.dw 0x29c0, 0xc08a,	0x29ff, 0xc08a,		0x21, 0
	.dw 0x2a40, 0xc08a,	0x2a7f, 0xc08a,		0x21, 0
	.dw 0x2ac0, 0xc08a,	0x2aff, 0xc08a,		0x21, 0
	.dw 0x2b40, 0xc08a,	0x2b7f, 0xc08a,		0x21, 0
	.dw 0x2bc0, 0xc08a,	0x2bff, 0xc08a,		0x21, 0
	.dw 0x2c40, 0xc08a,	0x2c7f, 0xc08a,		0x21, 0
	.dw 0x2cc0, 0xc08a,	0x2cff, 0xc08a,		0x21, 0
	.dw 0x2d40, 0xc08a,	0x2d7f, 0xc08a,		0x21, 0
	.dw 0x2dc0, 0xc08a,	0x2dff, 0xc08a,		0x21, 0
	.dw 0x2e40, 0xc08a,	0x2e7f, 0xc08a,		0x21, 0
	.dw 0x2ec0, 0xc08a,	0x2eff, 0xc08a,		0x21, 0
	.dw 0x2f40, 0xc08a,	0x2f7f, 0xc08a,		0x21, 0
	.dw 0x2fc0, 0xc08a,	0x2fff, 0xc08a,		0x21, 0
	.dw 0x3040, 0xc08a,	0x307f, 0xc08a,		0x21, 0
	.dw 0x30c0, 0xc08a,	0x30ff, 0xc08a,		0x21, 0
	.dw 0x3140, 0xc08a,	0x317f, 0xc08a,		0x21, 0
	.dw 0x31c0, 0xc08a,	0x31ff, 0xc08a,		0x21, 0
	.dw 0x3240, 0xc08a,	0x327f, 0xc08a,		0x21, 0
	.dw 0x32c0, 0xc08a,	0x32ff, 0xc08a,		0x21, 0
	.dw 0x3340, 0xc08a,	0x337f, 0xc08a,		0x21, 0
	.dw 0x33c0, 0xc08a,	0x33ff, 0xc08a,		0x21, 0
	.dw 0x3440, 0xc08a,	0x347f, 0xc08a,		0x21, 0
	.dw 0x34c0, 0xc08a,	0x34ff, 0xc08a,		0x21, 0
	.dw 0x3540, 0xc08a,	0x357f, 0xc08a,		0x21, 0
	.dw 0x35c0, 0xc08a,	0x35ff, 0xc08a,		0x21, 0
	.dw 0x3640, 0xc08a,	0x367f, 0xc08a,		0x21, 0
	.dw 0x36c0, 0xc08a,	0x36ff, 0xc08a,		0x21, 0
	.dw 0x3740, 0xc08a,	0x377f, 0xc08a,		0x21, 0
	.dw 0x37c0, 0xc08a,	0x37ff, 0xc08a,		0x21, 0
	.dw 0x3840, 0xc08a,	0x387f, 0xc08a,		0x21, 0
	.dw 0x38c0, 0xc08a,	0x38ff, 0xc08a,		0x21, 0
	.dw 0x3940, 0xc08a,	0x397f, 0xc08a,		0x21, 0
	.dw 0x39c0, 0xc08a,	0x5fff, 0xc08a,		0x21, 0
	.dw 0x6040, 0xc08a,	0x607f, 0xc08a,		0x21, 0
	.dw 0x60c0, 0xc08a,	0x60ff, 0xc08a,		0x21, 0
	.dw 0x6140, 0xc08a,	0x617f, 0xc08a,		0x21, 0
	.dw 0x61c0, 0xc08a,	0x61ff, 0xc08a,		0x21, 0
	.dw 0x6240, 0xc08a,	0x627f, 0xc08a,		0x21, 0
	.dw 0x62c0, 0xc08a,	0x62ff, 0xc08a,		0x21, 0
	.dw 0x6340, 0xc08a,	0x637f, 0xc08a,		0x21, 0
	.dw 0x63c0, 0xc08a,	0x63ff, 0xc08a,		0x21, 0
	.dw 0x6440, 0xc08a,	0x647f, 0xc08a,		0x21, 0
	.dw 0x64c0, 0xc08a,	0x64ff, 0xc08a,		0x21, 0
	.dw 0x6540, 0xc08a,	0x657f, 0xc08a,		0x21, 0
	.dw 0x65c0, 0xc08a,	0x65ff, 0xc08a,		0x21, 0
	.dw 0x6640, 0xc08a,	0x667f, 0xc08a,		0x21, 0
	.dw 0x66c0, 0xc08a,	0x66ff, 0xc08a,		0x21, 0
	.dw 0x6740, 0xc08a,	0x677f, 0xc08a,		0x21, 0
	.dw 0x67c0, 0xc08a,	0x67ff, 0xc08a,		0x21, 0
	.dw 0x6840, 0xc08a,	0x687f, 0xc08a,		0x21, 0
	.dw 0x68c0, 0xc08a,	0x68ff, 0xc08a,		0x21, 0
	.dw 0x6940, 0xc08a,	0x697f, 0xc08a,		0x21, 0
	.dw 0x69c0, 0xc08a,	0x69ff, 0xc08a,		0x21, 0
	.dw 0x6a40, 0xc08a,	0x6a7f, 0xc08a,		0x21, 0
	.dw 0x6ac0, 0xc08a,	0x6aff, 0xc08a,		0x21, 0
	.dw 0x6b40, 0xc08a,	0x6b7f, 0xc08a,		0x21, 0
	.dw 0x6bc0, 0xc08a,	0x6bff, 0xc08a,		0x21, 0
	.dw 0x6c40, 0xc08a,	0x6c7f, 0xc08a,		0x21, 0
	.dw 0x6cc0, 0xc08a,	0x6cff, 0xc08a,		0x21, 0
	.dw 0x6d40, 0xc08a,	0x6d7f, 0xc08a,		0x21, 0
	.dw 0x6dc0, 0xc08a,	0x6dff, 0xc08a,		0x21, 0
	.dw 0x6e40, 0xc08a,	0x6e7f, 0xc08a,		0x21, 0
	.dw 0x6ec0, 0xc08a,	0x6eff, 0xc08a,		0x21, 0
	.dw 0x6f40, 0xc08a,	0x6f7f, 0xc08a,		0x21, 0
	.dw 0x6fc0, 0xc08a,	0x6fff, 0xc08a,		0x21, 0
	.dw 0x7040, 0xc08a,	0x707f, 0xc08a,		0x21, 0
	.dw 0x70c0, 0xc08a,	0x70ff, 0xc08a,		0x21, 0
	.dw 0x7140, 0xc08a,	0x717f, 0xc08a,		0x21, 0
	.dw 0x71c0, 0xc08a,	0x71ff, 0xc08a,		0x21, 0
	.dw 0x7240, 0xc08a,	0x727f, 0xc08a,		0x21, 0
	.dw 0x72c0, 0xc08a,	0x72ff, 0xc08a,		0x21, 0
	.dw 0x7340, 0xc08a,	0x737f, 0xc08a,		0x21, 0
	.dw 0x73c0, 0xc08a,	0x73ff, 0xc08a,		0x21, 0
	.dw 0x7440, 0xc08a,	0x747f, 0xc08a,		0x21, 0
	.dw 0x74c0, 0xc08a,	0x74ff, 0xc08a,		0x21, 0
	.dw 0x7540, 0xc08a,	0x757f, 0xc08a,		0x21, 0
	.dw 0x75c0, 0xc08a,	0x75ff, 0xc08a,		0x21, 0
	.dw 0x7640, 0xc08a,	0x767f, 0xc08a,		0x21, 0
	.dw 0x76c0, 0xc08a,	0x76ff, 0xc08a,		0x21, 0
	.dw 0x7740, 0xc08a,	0x777f, 0xc08a,		0x21, 0
	.dw 0x77c0, 0xc08a,	0x77ff, 0xc08a,		0x21, 0
	.dw 0x7840, 0xc08a,	0x787f, 0xc08a,		0x21, 0
	.dw 0x78c0, 0xc08a,	0x78ff, 0xc08a,		0x21, 0
	.dw 0x7940, 0xc08a,	0x797f, 0xc08a,		0x21, 0
	.dw 0x79c0, 0xc08a,	0x9fff, 0xc08a,		0x21, 0
	.dw 0xa040, 0xc08a,	0xa07f, 0xc08a,		0x21, 0
	.dw 0xa0c0, 0xc08a,	0xa0ff, 0xc08a,		0x21, 0
	.dw 0xa140, 0xc08a,	0xa17f, 0xc08a,		0x21, 0
	.dw 0xa1c0, 0xc08a,	0xa1ff, 0xc08a,		0x21, 0
	.dw 0xa240, 0xc08a,	0xa27f, 0xc08a,		0x21, 0
	.dw 0xa2c0, 0xc08a,	0xa2ff, 0xc08a,		0x21, 0
	.dw 0xa340, 0xc08a,	0xa37f, 0xc08a,		0x21, 0
	.dw 0xa3c0, 0xc08a,	0xa3ff, 0xc08a,		0x21, 0
	.dw 0xa440, 0xc08a,	0xa47f, 0xc08a,		0x21, 0
	.dw 0xa4c0, 0xc08a,	0xa4ff, 0xc08a,		0x21, 0
	.dw 0xa540, 0xc08a,	0xa57f, 0xc08a,		0x21, 0
	.dw 0xa5c0, 0xc08a,	0xa5ff, 0xc08a,		0x21, 0
	.dw 0xa640, 0xc08a,	0xa67f, 0xc08a,		0x21, 0
	.dw 0xa6c0, 0xc08a,	0xa6ff, 0xc08a,		0x21, 0
	.dw 0xa740, 0xc08a,	0xa77f, 0xc08a,		0x21, 0
	.dw 0xa7c0, 0xc08a,	0xa7ff, 0xc08a,		0x21, 0
	.dw 0xa840, 0xc08a,	0xa87f, 0xc08a,		0x21, 0
	.dw 0xa8c0, 0xc08a,	0xa8ff, 0xc08a,		0x21, 0
	.dw 0xa940, 0xc08a,	0xa97f, 0xc08a,		0x21, 0
	.dw 0xa9c0, 0xc08a,	0xa9ff, 0xc08a,		0x21, 0
	.dw 0xaa40, 0xc08a,	0xaa7f, 0xc08a,		0x21, 0
	.dw 0xaac0, 0xc08a,	0xaaff, 0xc08a,		0x21, 0
	.dw 0xab40, 0xc08a,	0xab7f, 0xc08a,		0x21, 0
	.dw 0xabc0, 0xc08a,	0xabff, 0xc08a,		0x21, 0
	.dw 0xac40, 0xc08a,	0xac7f, 0xc08a,		0x21, 0
	.dw 0xacc0, 0xc08a,	0xacff, 0xc08a,		0x21, 0
	.dw 0xad40, 0xc08a,	0xad7f, 0xc08a,		0x21, 0
	.dw 0xadc0, 0xc08a,	0xadff, 0xc08a,		0x21, 0
	.dw 0xae40, 0xc08a,	0xae7f, 0xc08a,		0x21, 0
	.dw 0xaec0, 0xc08a,	0xaeff, 0xc08a,		0x21, 0
	.dw 0xaf40, 0xc08a,	0xaf7f, 0xc08a,		0x21, 0
	.dw 0xafc0, 0xc08a,	0xafff, 0xc08a,		0x21, 0
	.dw 0xb040, 0xc08a,	0xb07f, 0xc08a,		0x21, 0
	.dw 0xb0c0, 0xc08a,	0xb0ff, 0xc08a,		0x21, 0
	.dw 0xb140, 0xc08a,	0xb17f, 0xc08a,		0x21, 0
	.dw 0xb1c0, 0xc08a,	0xb1ff, 0xc08a,		0x21, 0
	.dw 0xb240, 0xc08a,	0xb27f, 0xc08a,		0x21, 0
	.dw 0xb2c0, 0xc08a,	0xb2ff, 0xc08a,		0x21, 0
	.dw 0xb340, 0xc08a,	0xb37f, 0xc08a,		0x21, 0
	.dw 0xb3c0, 0xc08a,	0xb3ff, 0xc08a,		0x21, 0
	.dw 0xb440, 0xc08a,	0xb47f, 0xc08a,		0x21, 0
	.dw 0xb4c0, 0xc08a,	0xb4ff, 0xc08a,		0x21, 0
	.dw 0xb540, 0xc08a,	0xb57f, 0xc08a,		0x21, 0
	.dw 0xb5c0, 0xc08a,	0xb5ff, 0xc08a,		0x21, 0
	.dw 0xb640, 0xc08a,	0xb67f, 0xc08a,		0x21, 0
	.dw 0xb6c0, 0xc08a,	0xb6ff, 0xc08a,		0x21, 0
	.dw 0xb740, 0xc08a,	0xb77f, 0xc08a,		0x21, 0
	.dw 0xb7c0, 0xc08a,	0xb7ff, 0xc08a,		0x21, 0
	.dw 0xb840, 0xc08a,	0xb87f, 0xc08a,		0x21, 0
	.dw 0xb8c0, 0xc08a,	0xb8ff, 0xc08a,		0x21, 0
	.dw 0xb940, 0xc08a,	0xb97f, 0xc08a,		0x21, 0
	.dw 0xb9c0, 0xc08a,	0xdfff, 0xc08a,		0x21, 0
	.dw 0xe040, 0xc08a,	0xe07f, 0xc08a,		0x21, 0
	.dw 0xe0c0, 0xc08a,	0xe0ff, 0xc08a,		0x21, 0
	.dw 0xe140, 0xc08a,	0xe17f, 0xc08a,		0x21, 0
	.dw 0xe1c0, 0xc08a,	0xe1ff, 0xc08a,		0x21, 0
	.dw 0xe240, 0xc08a,	0xe27f, 0xc08a,		0x21, 0
	.dw 0xe2c0, 0xc08a,	0xe2ff, 0xc08a,		0x21, 0
	.dw 0xe340, 0xc08a,	0xe37f, 0xc08a,		0x21, 0
	.dw 0xe3c0, 0xc08a,	0xe3ff, 0xc08a,		0x21, 0
	.dw 0xe440, 0xc08a,	0xe47f, 0xc08a,		0x21, 0
	.dw 0xe4c0, 0xc08a,	0xe4ff, 0xc08a,		0x21, 0
	.dw 0xe540, 0xc08a,	0xe57f, 0xc08a,		0x21, 0
	.dw 0xe5c0, 0xc08a,	0xe5ff, 0xc08a,		0x21, 0
	.dw 0xe640, 0xc08a,	0xe67f, 0xc08a,		0x21, 0
	.dw 0xe6c0, 0xc08a,	0xe6ff, 0xc08a,		0x21, 0
	.dw 0xe740, 0xc08a,	0xe77f, 0xc08a,		0x21, 0
	.dw 0xe7c0, 0xc08a,	0xe7ff, 0xc08a,		0x21, 0
	.dw 0xe840, 0xc08a,	0xe87f, 0xc08a,		0x21, 0
	.dw 0xe8c0, 0xc08a,	0xe8ff, 0xc08a,		0x21, 0
	.dw 0xe940, 0xc08a,	0xe97f, 0xc08a,		0x21, 0
	.dw 0xe9c0, 0xc08a,	0xe9ff, 0xc08a,		0x21, 0
	.dw 0xea40, 0xc08a,	0xea7f, 0xc08a,		0x21, 0
	.dw 0xeac0, 0xc08a,	0xeaff, 0xc08a,		0x21, 0
	.dw 0xeb40, 0xc08a,	0xeb7f, 0xc08a,		0x21, 0
	.dw 0xebc0, 0xc08a,	0xebff, 0xc08a,		0x21, 0
	.dw 0xec40, 0xc08a,	0xec7f, 0xc08a,		0x21, 0
	.dw 0xecc0, 0xc08a,	0xecff, 0xc08a,		0x21, 0
	.dw 0xed40, 0xc08a,	0xed7f, 0xc08a,		0x21, 0
	.dw 0xedc0, 0xc08a,	0xedff, 0xc08a,		0x21, 0
	.dw 0xee40, 0xc08a,	0xee7f, 0xc08a,		0x21, 0
	.dw 0xeec0, 0xc08a,	0xeeff, 0xc08a,		0x21, 0
	.dw 0xef40, 0xc08a,	0xef7f, 0xc08a,		0x21, 0
	.dw 0xefc0, 0xc08a,	0xefff, 0xc08a,		0x21, 0
	.dw 0xf040, 0xc08a,	0xf07f, 0xc08a,		0x21, 0
	.dw 0xf0c0, 0xc08a,	0xf0ff, 0xc08a,		0x21, 0
	.dw 0xf140, 0xc08a,	0xf17f, 0xc08a,		0x21, 0
	.dw 0xf1c0, 0xc08a,	0xf1ff, 0xc08a,		0x21, 0
	.dw 0xf240, 0xc08a,	0xf27f, 0xc08a,		0x21, 0
	.dw 0xf2c0, 0xc08a,	0xf2ff, 0xc08a,		0x21, 0
	.dw 0xf340, 0xc08a,	0xf37f, 0xc08a,		0x21, 0
	.dw 0xf3c0, 0xc08a,	0xf3ff, 0xc08a,		0x21, 0
	.dw 0xf440, 0xc08a,	0xf47f, 0xc08a,		0x21, 0
	.dw 0xf4c0, 0xc08a,	0xf4ff, 0xc08a,		0x21, 0
	.dw 0xf540, 0xc08a,	0xf57f, 0xc08a,		0x21, 0
	.dw 0xf5c0, 0xc08a,	0xf5ff, 0xc08a,		0x21, 0
	.dw 0xf640, 0xc08a,	0xf67f, 0xc08a,		0x21, 0
	.dw 0xf6c0, 0xc08a,	0xf6ff, 0xc08a,		0x21, 0
	.dw 0xf740, 0xc08a,	0xf77f, 0xc08a,		0x21, 0
	.dw 0xf7c0, 0xc08a,	0xf7ff, 0xc08a,		0x21, 0
	.dw 0xf840, 0xc08a,	0xf87f, 0xc08a,		0x21, 0
	.dw 0xf8c0, 0xc08a,	0xf8ff, 0xc08a,		0x21, 0
	.dw 0xf940, 0xc08a,	0xf97f, 0xc08a,		0x21, 0
	.dw 0xf9c0, 0xc08a,	0x1fff, 0xc08b,		0x21, 0
	.dw 0x2040, 0xc08b,	0x207f, 0xc08b,		0x21, 0
	.dw 0x20c0, 0xc08b,	0x20ff, 0xc08b,		0x21, 0
	.dw 0x2140, 0xc08b,	0x217f, 0xc08b,		0x21, 0
	.dw 0x21c0, 0xc08b,	0x21ff, 0xc08b,		0x21, 0
	.dw 0x2240, 0xc08b,	0x227f, 0xc08b,		0x21, 0
	.dw 0x22c0, 0xc08b,	0x22ff, 0xc08b,		0x21, 0
	.dw 0x2340, 0xc08b,	0x237f, 0xc08b,		0x21, 0
	.dw 0x23c0, 0xc08b,	0x23ff, 0xc08b,		0x21, 0
	.dw 0x2440, 0xc08b,	0x247f, 0xc08b,		0x21, 0
	.dw 0x24c0, 0xc08b,	0x24ff, 0xc08b,		0x21, 0
	.dw 0x2540, 0xc08b,	0x257f, 0xc08b,		0x21, 0
	.dw 0x25c0, 0xc08b,	0x25ff, 0xc08b,		0x21, 0
	.dw 0x2640, 0xc08b,	0x267f, 0xc08b,		0x21, 0
	.dw 0x26c0, 0xc08b,	0x26ff, 0xc08b,		0x21, 0
	.dw 0x2740, 0xc08b,	0x277f, 0xc08b,		0x21, 0
	.dw 0x27c0, 0xc08b,	0x27ff, 0xc08b,		0x21, 0
	.dw 0x2840, 0xc08b,	0x287f, 0xc08b,		0x21, 0
	.dw 0x28c0, 0xc08b,	0x28ff, 0xc08b,		0x21, 0
	.dw 0x2940, 0xc08b,	0x297f, 0xc08b,		0x21, 0
	.dw 0x29c0, 0xc08b,	0x29ff, 0xc08b,		0x21, 0
	.dw 0x2a40, 0xc08b,	0x2a7f, 0xc08b,		0x21, 0
	.dw 0x2ac0, 0xc08b,	0x2aff, 0xc08b,		0x21, 0
	.dw 0x2b40, 0xc08b,	0x2b7f, 0xc08b,		0x21, 0
	.dw 0x2bc0, 0xc08b,	0x2bff, 0xc08b,		0x21, 0
	.dw 0x2c40, 0xc08b,	0x2c7f, 0xc08b,		0x21, 0
	.dw 0x2cc0, 0xc08b,	0x2cff, 0xc08b,		0x21, 0
	.dw 0x2d40, 0xc08b,	0x2d7f, 0xc08b,		0x21, 0
	.dw 0x2dc0, 0xc08b,	0x2dff, 0xc08b,		0x21, 0
	.dw 0x2e40, 0xc08b,	0x2e7f, 0xc08b,		0x21, 0
	.dw 0x2ec0, 0xc08b,	0x2eff, 0xc08b,		0x21, 0
	.dw 0x2f40, 0xc08b,	0x2f7f, 0xc08b,		0x21, 0
	.dw 0x2fc0, 0xc08b,	0x2fff, 0xc08b,		0x21, 0
	.dw 0x3040, 0xc08b,	0x307f, 0xc08b,		0x21, 0
	.dw 0x30c0, 0xc08b,	0x30ff, 0xc08b,		0x21, 0
	.dw 0x3140, 0xc08b,	0x317f, 0xc08b,		0x21, 0
	.dw 0x31c0, 0xc08b,	0x31ff, 0xc08b,		0x21, 0
	.dw 0x3240, 0xc08b,	0x327f, 0xc08b,		0x21, 0
	.dw 0x32c0, 0xc08b,	0x32ff, 0xc08b,		0x21, 0
	.dw 0x3340, 0xc08b,	0x337f, 0xc08b,		0x21, 0
	.dw 0x33c0, 0xc08b,	0x33ff, 0xc08b,		0x21, 0
	.dw 0x3440, 0xc08b,	0x347f, 0xc08b,		0x21, 0
	.dw 0x34c0, 0xc08b,	0x34ff, 0xc08b,		0x21, 0
	.dw 0x3540, 0xc08b,	0x357f, 0xc08b,		0x21, 0
	.dw 0x35c0, 0xc08b,	0x35ff, 0xc08b,		0x21, 0
	.dw 0x3640, 0xc08b,	0x367f, 0xc08b,		0x21, 0
	.dw 0x36c0, 0xc08b,	0x36ff, 0xc08b,		0x21, 0
	.dw 0x3740, 0xc08b,	0x377f, 0xc08b,		0x21, 0
	.dw 0x37c0, 0xc08b,	0x37ff, 0xc08b,		0x21, 0
	.dw 0x3840, 0xc08b,	0x387f, 0xc08b,		0x21, 0
	.dw 0x38c0, 0xc08b,	0x38ff, 0xc08b,		0x21, 0
	.dw 0x3940, 0xc08b,	0x397f, 0xc08b,		0x21, 0
	.dw 0x39c0, 0xc08b,	0xffff, 0xc08b,		0x21, 0
	.dw 0x0040, 0xc08c,	0x007f, 0xc08c,		0x21, 0
	.dw 0x00c0, 0xc08c,	0x00ff, 0xc08c,		0x21, 0
	.dw 0x0140, 0xc08c,	0x017f, 0xc08c,		0x21, 0
	.dw 0x01c0, 0xc08c,	0x01ff, 0xc08c,		0x21, 0
	.dw 0x0240, 0xc08c,	0x027f, 0xc08c,		0x21, 0
	.dw 0x02c0, 0xc08c,	0x02ff, 0xc08c,		0x21, 0
	.dw 0x0340, 0xc08c,	0x037f, 0xc08c,		0x21, 0
	.dw 0x03c0, 0xc08c,	0x03ff, 0xc08c,		0x21, 0
	.dw 0x0440, 0xc08c,	0x047f, 0xc08c,		0x21, 0
	.dw 0x04c0, 0xc08c,	0x04ff, 0xc08c,		0x21, 0
	.dw 0x0540, 0xc08c,	0x057f, 0xc08c,		0x21, 0
	.dw 0x05c0, 0xc08c,	0x05ff, 0xc08c,		0x21, 0
	.dw 0x0640, 0xc08c,	0x067f, 0xc08c,		0x21, 0
	.dw 0x06c0, 0xc08c,	0x06ff, 0xc08c,		0x21, 0
	.dw 0x0740, 0xc08c,	0x077f, 0xc08c,		0x21, 0
	.dw 0x07c0, 0xc08c,	0x07ff, 0xc08c,		0x21, 0
	.dw 0x0840, 0xc08c,	0x087f, 0xc08c,		0x21, 0
	.dw 0x08c0, 0xc08c,	0x08ff, 0xc08c,		0x21, 0
	.dw 0x0940, 0xc08c,	0x097f, 0xc08c,		0x21, 0
	.dw 0x09c0, 0xc08c,	0x09ff, 0xc08c,		0x21, 0
	.dw 0x0a40, 0xc08c,	0x0a7f, 0xc08c,		0x21, 0
	.dw 0x0ac0, 0xc08c,	0x0aff, 0xc08c,		0x21, 0
	.dw 0x0b40, 0xc08c,	0x0b7f, 0xc08c,		0x21, 0
	.dw 0x0bc0, 0xc08c,	0x0bff, 0xc08c,		0x21, 0
	.dw 0x0c40, 0xc08c,	0x0c7f, 0xc08c,		0x21, 0
	.dw 0x0cc0, 0xc08c,	0x0cff, 0xc08c,		0x21, 0
	.dw 0x0d40, 0xc08c,	0x0d7f, 0xc08c,		0x21, 0
	.dw 0x0dc0, 0xc08c,	0x0dff, 0xc08c,		0x21, 0
	.dw 0x0e40, 0xc08c,	0x0e7f, 0xc08c,		0x21, 0
	.dw 0x0ec0, 0xc08c,	0x0eff, 0xc08c,		0x21, 0
	.dw 0x0f40, 0xc08c,	0x0f7f, 0xc08c,		0x21, 0
	.dw 0x0fc0, 0xc08c,	0x0fff, 0xc08c,		0x21, 0
	.dw 0x1040, 0xc08c,	0x107f, 0xc08c,		0x21, 0
	.dw 0x10c0, 0xc08c,	0x10ff, 0xc08c,		0x21, 0
	.dw 0x1140, 0xc08c,	0x117f, 0xc08c,		0x21, 0
	.dw 0x11c0, 0xc08c,	0x11ff, 0xc08c,		0x21, 0
	.dw 0x1240, 0xc08c,	0x127f, 0xc08c,		0x21, 0
	.dw 0x12c0, 0xc08c,	0x12ff, 0xc08c,		0x21, 0
	.dw 0x1340, 0xc08c,	0x137f, 0xc08c,		0x21, 0
	.dw 0x13c0, 0xc08c,	0x13ff, 0xc08c,		0x21, 0
	.dw 0x1440, 0xc08c,	0x147f, 0xc08c,		0x21, 0
	.dw 0x14c0, 0xc08c,	0x14ff, 0xc08c,		0x21, 0
	.dw 0x1540, 0xc08c,	0x157f, 0xc08c,		0x21, 0
	.dw 0x15c0, 0xc08c,	0x15ff, 0xc08c,		0x21, 0
	.dw 0x1640, 0xc08c,	0x167f, 0xc08c,		0x21, 0
	.dw 0x16c0, 0xc08c,	0x16ff, 0xc08c,		0x21, 0
	.dw 0x1740, 0xc08c,	0x177f, 0xc08c,		0x21, 0
	.dw 0x17c0, 0xc08c,	0x17ff, 0xc08c,		0x21, 0
	.dw 0x1840, 0xc08c,	0x187f, 0xc08c,		0x21, 0
	.dw 0x18c0, 0xc08c,	0x18ff, 0xc08c,		0x21, 0
	.dw 0x1940, 0xc08c,	0x197f, 0xc08c,		0x21, 0
	.dw 0x19c0, 0xc08c,	0x1fff, 0xc08c,		0x21, 0
	.dw 0x2040, 0xc08c,	0x207f, 0xc08c,		0x21, 0
	.dw 0x20c0, 0xc08c,	0x20ff, 0xc08c,		0x21, 0
	.dw 0x2140, 0xc08c,	0x217f, 0xc08c,		0x21, 0
	.dw 0x21c0, 0xc08c,	0x21ff, 0xc08c,		0x21, 0
	.dw 0x2240, 0xc08c,	0x227f, 0xc08c,		0x21, 0
	.dw 0x22c0, 0xc08c,	0x22ff, 0xc08c,		0x21, 0
	.dw 0x2340, 0xc08c,	0x237f, 0xc08c,		0x21, 0
	.dw 0x23c0, 0xc08c,	0x23ff, 0xc08c,		0x21, 0
	.dw 0x2440, 0xc08c,	0x247f, 0xc08c,		0x21, 0
	.dw 0x24c0, 0xc08c,	0x24ff, 0xc08c,		0x21, 0
	.dw 0x2540, 0xc08c,	0x257f, 0xc08c,		0x21, 0
	.dw 0x25c0, 0xc08c,	0x25ff, 0xc08c,		0x21, 0
	.dw 0x2640, 0xc08c,	0x267f, 0xc08c,		0x21, 0
	.dw 0x26c0, 0xc08c,	0x26ff, 0xc08c,		0x21, 0
	.dw 0x2740, 0xc08c,	0x277f, 0xc08c,		0x21, 0
	.dw 0x27c0, 0xc08c,	0x27ff, 0xc08c,		0x21, 0
	.dw 0x2840, 0xc08c,	0x287f, 0xc08c,		0x21, 0
	.dw 0x28c0, 0xc08c,	0x28ff, 0xc08c,		0x21, 0
	.dw 0x2940, 0xc08c,	0x297f, 0xc08c,		0x21, 0
	.dw 0x29c0, 0xc08c,	0x29ff, 0xc08c,		0x21, 0
	.dw 0x2a40, 0xc08c,	0x2a7f, 0xc08c,		0x21, 0
	.dw 0x2ac0, 0xc08c,	0x2aff, 0xc08c,		0x21, 0
	.dw 0x2b40, 0xc08c,	0x2b7f, 0xc08c,		0x21, 0
	.dw 0x2bc0, 0xc08c,	0x2bff, 0xc08c,		0x21, 0
	.dw 0x2c40, 0xc08c,	0x2c7f, 0xc08c,		0x21, 0
	.dw 0x2cc0, 0xc08c,	0x2cff, 0xc08c,		0x21, 0
	.dw 0x2d40, 0xc08c,	0x2d7f, 0xc08c,		0x21, 0
	.dw 0x2dc0, 0xc08c,	0x2dff, 0xc08c,		0x21, 0
	.dw 0x2e40, 0xc08c,	0x2e7f, 0xc08c,		0x21, 0
	.dw 0x2ec0, 0xc08c,	0x2eff, 0xc08c,		0x21, 0
	.dw 0x2f40, 0xc08c,	0x2f7f, 0xc08c,		0x21, 0
	.dw 0x2fc0, 0xc08c,	0x2fff, 0xc08c,		0x21, 0
	.dw 0x3040, 0xc08c,	0x307f, 0xc08c,		0x21, 0
	.dw 0x30c0, 0xc08c,	0x30ff, 0xc08c,		0x21, 0
	.dw 0x3140, 0xc08c,	0x317f, 0xc08c,		0x21, 0
	.dw 0x31c0, 0xc08c,	0x31ff, 0xc08c,		0x21, 0
	.dw 0x3240, 0xc08c,	0x327f, 0xc08c,		0x21, 0
	.dw 0x32c0, 0xc08c,	0x32ff, 0xc08c,		0x21, 0
	.dw 0x3340, 0xc08c,	0x337f, 0xc08c,		0x21, 0
	.dw 0x33c0, 0xc08c,	0x33ff, 0xc08c,		0x21, 0
	.dw 0x3440, 0xc08c,	0x347f, 0xc08c,		0x21, 0
	.dw 0x34c0, 0xc08c,	0x34ff, 0xc08c,		0x21, 0
	.dw 0x3540, 0xc08c,	0x357f, 0xc08c,		0x21, 0
	.dw 0x35c0, 0xc08c,	0x35ff, 0xc08c,		0x21, 0
	.dw 0x3640, 0xc08c,	0x367f, 0xc08c,		0x21, 0
	.dw 0x36c0, 0xc08c,	0x36ff, 0xc08c,		0x21, 0
	.dw 0x3740, 0xc08c,	0x377f, 0xc08c,		0x21, 0
	.dw 0x37c0, 0xc08c,	0x37ff, 0xc08c,		0x21, 0
	.dw 0x3840, 0xc08c,	0x387f, 0xc08c,		0x21, 0
	.dw 0x38c0, 0xc08c,	0x38ff, 0xc08c,		0x21, 0
	.dw 0x3940, 0xc08c,	0x397f, 0xc08c,		0x21, 0
	.dw 0x39c0, 0xc08c,	0x3fff, 0xc08c,		0x21, 0
	.dw 0x4040, 0xc08c,	0x407f, 0xc08c,		0x21, 0
	.dw 0x40c0, 0xc08c,	0x40ff, 0xc08c,		0x21, 0
	.dw 0x4140, 0xc08c,	0x417f, 0xc08c,		0x21, 0
	.dw 0x41c0, 0xc08c,	0x41ff, 0xc08c,		0x21, 0
	.dw 0x4240, 0xc08c,	0x427f, 0xc08c,		0x21, 0
	.dw 0x42c0, 0xc08c,	0x42ff, 0xc08c,		0x21, 0
	.dw 0x4340, 0xc08c,	0x437f, 0xc08c,		0x21, 0
	.dw 0x43c0, 0xc08c,	0x43ff, 0xc08c,		0x21, 0
	.dw 0x4440, 0xc08c,	0x447f, 0xc08c,		0x21, 0
	.dw 0x44c0, 0xc08c,	0x44ff, 0xc08c,		0x21, 0
	.dw 0x4540, 0xc08c,	0x457f, 0xc08c,		0x21, 0
	.dw 0x45c0, 0xc08c,	0x45ff, 0xc08c,		0x21, 0
	.dw 0x4640, 0xc08c,	0x467f, 0xc08c,		0x21, 0
	.dw 0x46c0, 0xc08c,	0x46ff, 0xc08c,		0x21, 0
	.dw 0x4740, 0xc08c,	0x477f, 0xc08c,		0x21, 0
	.dw 0x47c0, 0xc08c,	0x47ff, 0xc08c,		0x21, 0
	.dw 0x4840, 0xc08c,	0x487f, 0xc08c,		0x21, 0
	.dw 0x48c0, 0xc08c,	0x48ff, 0xc08c,		0x21, 0
	.dw 0x4940, 0xc08c,	0x497f, 0xc08c,		0x21, 0
	.dw 0x49c0, 0xc08c,	0x49ff, 0xc08c,		0x21, 0
	.dw 0x4a40, 0xc08c,	0x4a7f, 0xc08c,		0x21, 0
	.dw 0x4ac0, 0xc08c,	0x4aff, 0xc08c,		0x21, 0
	.dw 0x4b40, 0xc08c,	0x4b7f, 0xc08c,		0x21, 0
	.dw 0x4bc0, 0xc08c,	0x4bff, 0xc08c,		0x21, 0
	.dw 0x4c40, 0xc08c,	0x4c7f, 0xc08c,		0x21, 0
	.dw 0x4cc0, 0xc08c,	0x4cff, 0xc08c,		0x21, 0
	.dw 0x4d40, 0xc08c,	0x4d7f, 0xc08c,		0x21, 0
	.dw 0x4dc0, 0xc08c,	0x4dff, 0xc08c,		0x21, 0
	.dw 0x4e40, 0xc08c,	0x4e7f, 0xc08c,		0x21, 0
	.dw 0x4ec0, 0xc08c,	0x4eff, 0xc08c,		0x21, 0
	.dw 0x4f40, 0xc08c,	0x4f7f, 0xc08c,		0x21, 0
	.dw 0x4fc0, 0xc08c,	0x4fff, 0xc08c,		0x21, 0
	.dw 0x5040, 0xc08c,	0x507f, 0xc08c,		0x21, 0
	.dw 0x50c0, 0xc08c,	0x50ff, 0xc08c,		0x21, 0
	.dw 0x5140, 0xc08c,	0x517f, 0xc08c,		0x21, 0
	.dw 0x51c0, 0xc08c,	0x51ff, 0xc08c,		0x21, 0
	.dw 0x5240, 0xc08c,	0x527f, 0xc08c,		0x21, 0
	.dw 0x52c0, 0xc08c,	0x52ff, 0xc08c,		0x21, 0
	.dw 0x5340, 0xc08c,	0x537f, 0xc08c,		0x21, 0
	.dw 0x53c0, 0xc08c,	0x53ff, 0xc08c,		0x21, 0
	.dw 0x5440, 0xc08c,	0x547f, 0xc08c,		0x21, 0
	.dw 0x54c0, 0xc08c,	0x54ff, 0xc08c,		0x21, 0
	.dw 0x5540, 0xc08c,	0x557f, 0xc08c,		0x21, 0
	.dw 0x55c0, 0xc08c,	0x55ff, 0xc08c,		0x21, 0
	.dw 0x5640, 0xc08c,	0x567f, 0xc08c,		0x21, 0
	.dw 0x56c0, 0xc08c,	0x56ff, 0xc08c,		0x21, 0
	.dw 0x5740, 0xc08c,	0x577f, 0xc08c,		0x21, 0
	.dw 0x57c0, 0xc08c,	0x57ff, 0xc08c,		0x21, 0
	.dw 0x5840, 0xc08c,	0x587f, 0xc08c,		0x21, 0
	.dw 0x58c0, 0xc08c,	0x58ff, 0xc08c,		0x21, 0
	.dw 0x5940, 0xc08c,	0x597f, 0xc08c,		0x21, 0
	.dw 0x59c0, 0xc08c,	0x5fff, 0xc08c,		0x21, 0
	.dw 0x6040, 0xc08c,	0x607f, 0xc08c,		0x21, 0
	.dw 0x60c0, 0xc08c,	0x60ff, 0xc08c,		0x21, 0
	.dw 0x6140, 0xc08c,	0x617f, 0xc08c,		0x21, 0
	.dw 0x61c0, 0xc08c,	0x61ff, 0xc08c,		0x21, 0
	.dw 0x6240, 0xc08c,	0x627f, 0xc08c,		0x21, 0
	.dw 0x62c0, 0xc08c,	0x62ff, 0xc08c,		0x21, 0
	.dw 0x6340, 0xc08c,	0x637f, 0xc08c,		0x21, 0
	.dw 0x63c0, 0xc08c,	0x63ff, 0xc08c,		0x21, 0
	.dw 0x6440, 0xc08c,	0x647f, 0xc08c,		0x21, 0
	.dw 0x64c0, 0xc08c,	0x64ff, 0xc08c,		0x21, 0
	.dw 0x6540, 0xc08c,	0x657f, 0xc08c,		0x21, 0
	.dw 0x65c0, 0xc08c,	0x65ff, 0xc08c,		0x21, 0
	.dw 0x6640, 0xc08c,	0x667f, 0xc08c,		0x21, 0
	.dw 0x66c0, 0xc08c,	0x66ff, 0xc08c,		0x21, 0
	.dw 0x6740, 0xc08c,	0x677f, 0xc08c,		0x21, 0
	.dw 0x67c0, 0xc08c,	0x67ff, 0xc08c,		0x21, 0
	.dw 0x6840, 0xc08c,	0x687f, 0xc08c,		0x21, 0
	.dw 0x68c0, 0xc08c,	0x68ff, 0xc08c,		0x21, 0
	.dw 0x6940, 0xc08c,	0x697f, 0xc08c,		0x21, 0
	.dw 0x69c0, 0xc08c,	0x69ff, 0xc08c,		0x21, 0
	.dw 0x6a40, 0xc08c,	0x6a7f, 0xc08c,		0x21, 0
	.dw 0x6ac0, 0xc08c,	0x6aff, 0xc08c,		0x21, 0
	.dw 0x6b40, 0xc08c,	0x6b7f, 0xc08c,		0x21, 0
	.dw 0x6bc0, 0xc08c,	0x6bff, 0xc08c,		0x21, 0
	.dw 0x6c40, 0xc08c,	0x6c7f, 0xc08c,		0x21, 0
	.dw 0x6cc0, 0xc08c,	0x6cff, 0xc08c,		0x21, 0
	.dw 0x6d40, 0xc08c,	0x6d7f, 0xc08c,		0x21, 0
	.dw 0x6dc0, 0xc08c,	0x6dff, 0xc08c,		0x21, 0
	.dw 0x6e40, 0xc08c,	0x6e7f, 0xc08c,		0x21, 0
	.dw 0x6ec0, 0xc08c,	0x6eff, 0xc08c,		0x21, 0
	.dw 0x6f40, 0xc08c,	0x6f7f, 0xc08c,		0x21, 0
	.dw 0x6fc0, 0xc08c,	0x6fff, 0xc08c,		0x21, 0
	.dw 0x7040, 0xc08c,	0x707f, 0xc08c,		0x21, 0
	.dw 0x70c0, 0xc08c,	0x70ff, 0xc08c,		0x21, 0
	.dw 0x7140, 0xc08c,	0x717f, 0xc08c,		0x21, 0
	.dw 0x71c0, 0xc08c,	0x71ff, 0xc08c,		0x21, 0
	.dw 0x7240, 0xc08c,	0x727f, 0xc08c,		0x21, 0
	.dw 0x72c0, 0xc08c,	0x72ff, 0xc08c,		0x21, 0
	.dw 0x7340, 0xc08c,	0x737f, 0xc08c,		0x21, 0
	.dw 0x73c0, 0xc08c,	0x73ff, 0xc08c,		0x21, 0
	.dw 0x7440, 0xc08c,	0x747f, 0xc08c,		0x21, 0
	.dw 0x74c0, 0xc08c,	0x74ff, 0xc08c,		0x21, 0
	.dw 0x7540, 0xc08c,	0x757f, 0xc08c,		0x21, 0
	.dw 0x75c0, 0xc08c,	0x75ff, 0xc08c,		0x21, 0
	.dw 0x7640, 0xc08c,	0x767f, 0xc08c,		0x21, 0
	.dw 0x76c0, 0xc08c,	0x76ff, 0xc08c,		0x21, 0
	.dw 0x7740, 0xc08c,	0x777f, 0xc08c,		0x21, 0
	.dw 0x77c0, 0xc08c,	0x77ff, 0xc08c,		0x21, 0
	.dw 0x7840, 0xc08c,	0x787f, 0xc08c,		0x21, 0
	.dw 0x78c0, 0xc08c,	0x78ff, 0xc08c,		0x21, 0
	.dw 0x7940, 0xc08c,	0x797f, 0xc08c,		0x21, 0
	.dw 0x79c0, 0xc08c,	0x7fff, 0xc08c,		0x21, 0
	.dw 0x8040, 0xc08c,	0x807f, 0xc08c,		0x21, 0
	.dw 0x80c0, 0xc08c,	0x80ff, 0xc08c,		0x21, 0
	.dw 0x8140, 0xc08c,	0x817f, 0xc08c,		0x21, 0
	.dw 0x81c0, 0xc08c,	0x81ff, 0xc08c,		0x21, 0
	.dw 0x8240, 0xc08c,	0x827f, 0xc08c,		0x21, 0
	.dw 0x82c0, 0xc08c,	0x82ff, 0xc08c,		0x21, 0
	.dw 0x8340, 0xc08c,	0x837f, 0xc08c,		0x21, 0
	.dw 0x83c0, 0xc08c,	0x83ff, 0xc08c,		0x21, 0
	.dw 0x8440, 0xc08c,	0x847f, 0xc08c,		0x21, 0
	.dw 0x84c0, 0xc08c,	0x84ff, 0xc08c,		0x21, 0
	.dw 0x8540, 0xc08c,	0x857f, 0xc08c,		0x21, 0
	.dw 0x85c0, 0xc08c,	0x85ff, 0xc08c,		0x21, 0
	.dw 0x8640, 0xc08c,	0x867f, 0xc08c,		0x21, 0
	.dw 0x86c0, 0xc08c,	0x86ff, 0xc08c,		0x21, 0
	.dw 0x8740, 0xc08c,	0x877f, 0xc08c,		0x21, 0
	.dw 0x87c0, 0xc08c,	0x87ff, 0xc08c,		0x21, 0
	.dw 0x8840, 0xc08c,	0x887f, 0xc08c,		0x21, 0
	.dw 0x88c0, 0xc08c,	0x88ff, 0xc08c,		0x21, 0
	.dw 0x8940, 0xc08c,	0x897f, 0xc08c,		0x21, 0
	.dw 0x89c0, 0xc08c,	0x89ff, 0xc08c,		0x21, 0
	.dw 0x8a40, 0xc08c,	0x8a7f, 0xc08c,		0x21, 0
	.dw 0x8ac0, 0xc08c,	0x8aff, 0xc08c,		0x21, 0
	.dw 0x8b40, 0xc08c,	0x8b7f, 0xc08c,		0x21, 0
	.dw 0x8bc0, 0xc08c,	0x8bff, 0xc08c,		0x21, 0
	.dw 0x8c40, 0xc08c,	0x8c7f, 0xc08c,		0x21, 0
	.dw 0x8cc0, 0xc08c,	0x8cff, 0xc08c,		0x21, 0
	.dw 0x8d40, 0xc08c,	0x8d7f, 0xc08c,		0x21, 0
	.dw 0x8dc0, 0xc08c,	0x8dff, 0xc08c,		0x21, 0
	.dw 0x8e40, 0xc08c,	0x8e7f, 0xc08c,		0x21, 0
	.dw 0x8ec0, 0xc08c,	0x8eff, 0xc08c,		0x21, 0
	.dw 0x8f40, 0xc08c,	0x8f7f, 0xc08c,		0x21, 0
	.dw 0x8fc0, 0xc08c,	0x8fff, 0xc08c,		0x21, 0
	.dw 0x9040, 0xc08c,	0x907f, 0xc08c,		0x21, 0
	.dw 0x90c0, 0xc08c,	0x90ff, 0xc08c,		0x21, 0
	.dw 0x9140, 0xc08c,	0x917f, 0xc08c,		0x21, 0
	.dw 0x91c0, 0xc08c,	0x91ff, 0xc08c,		0x21, 0
	.dw 0x9240, 0xc08c,	0x927f, 0xc08c,		0x21, 0
	.dw 0x92c0, 0xc08c,	0x92ff, 0xc08c,		0x21, 0
	.dw 0x9340, 0xc08c,	0x937f, 0xc08c,		0x21, 0
	.dw 0x93c0, 0xc08c,	0x93ff, 0xc08c,		0x21, 0
	.dw 0x9440, 0xc08c,	0x947f, 0xc08c,		0x21, 0
	.dw 0x94c0, 0xc08c,	0x94ff, 0xc08c,		0x21, 0
	.dw 0x9540, 0xc08c,	0x957f, 0xc08c,		0x21, 0
	.dw 0x95c0, 0xc08c,	0x95ff, 0xc08c,		0x21, 0
	.dw 0x9640, 0xc08c,	0x967f, 0xc08c,		0x21, 0
	.dw 0x96c0, 0xc08c,	0x96ff, 0xc08c,		0x21, 0
	.dw 0x9740, 0xc08c,	0x977f, 0xc08c,		0x21, 0
	.dw 0x97c0, 0xc08c,	0x97ff, 0xc08c,		0x21, 0
	.dw 0x9840, 0xc08c,	0x987f, 0xc08c,		0x21, 0
	.dw 0x98c0, 0xc08c,	0x98ff, 0xc08c,		0x21, 0
	.dw 0x9940, 0xc08c,	0x997f, 0xc08c,		0x21, 0
	.dw 0x99c0, 0xc08c,	0x9fff, 0xc08c,		0x21, 0
	.dw 0xa040, 0xc08c,	0xa07f, 0xc08c,		0x21, 0
	.dw 0xa0c0, 0xc08c,	0xa0ff, 0xc08c,		0x21, 0
	.dw 0xa140, 0xc08c,	0xa17f, 0xc08c,		0x21, 0
	.dw 0xa1c0, 0xc08c,	0xa1ff, 0xc08c,		0x21, 0
	.dw 0xa240, 0xc08c,	0xa27f, 0xc08c,		0x21, 0
	.dw 0xa2c0, 0xc08c,	0xa2ff, 0xc08c,		0x21, 0
	.dw 0xa340, 0xc08c,	0xa37f, 0xc08c,		0x21, 0
	.dw 0xa3c0, 0xc08c,	0xa3ff, 0xc08c,		0x21, 0
	.dw 0xa440, 0xc08c,	0xa47f, 0xc08c,		0x21, 0
	.dw 0xa4c0, 0xc08c,	0xa4ff, 0xc08c,		0x21, 0
	.dw 0xa540, 0xc08c,	0xa57f, 0xc08c,		0x21, 0
	.dw 0xa5c0, 0xc08c,	0xa5ff, 0xc08c,		0x21, 0
	.dw 0xa640, 0xc08c,	0xa67f, 0xc08c,		0x21, 0
	.dw 0xa6c0, 0xc08c,	0xa6ff, 0xc08c,		0x21, 0
	.dw 0xa740, 0xc08c,	0xa77f, 0xc08c,		0x21, 0
	.dw 0xa7c0, 0xc08c,	0xa7ff, 0xc08c,		0x21, 0
	.dw 0xa840, 0xc08c,	0xa87f, 0xc08c,		0x21, 0
	.dw 0xa8c0, 0xc08c,	0xa8ff, 0xc08c,		0x21, 0
	.dw 0xa940, 0xc08c,	0xa97f, 0xc08c,		0x21, 0
	.dw 0xa9c0, 0xc08c,	0xa9ff, 0xc08c,		0x21, 0
	.dw 0xaa40, 0xc08c,	0xaa7f, 0xc08c,		0x21, 0
	.dw 0xaac0, 0xc08c,	0xaaff, 0xc08c,		0x21, 0
	.dw 0xab40, 0xc08c,	0xab7f, 0xc08c,		0x21, 0
	.dw 0xabc0, 0xc08c,	0xabff, 0xc08c,		0x21, 0
	.dw 0xac40, 0xc08c,	0xac7f, 0xc08c,		0x21, 0
	.dw 0xacc0, 0xc08c,	0xacff, 0xc08c,		0x21, 0
	.dw 0xad40, 0xc08c,	0xad7f, 0xc08c,		0x21, 0
	.dw 0xadc0, 0xc08c,	0xadff, 0xc08c,		0x21, 0
	.dw 0xae40, 0xc08c,	0xae7f, 0xc08c,		0x21, 0
	.dw 0xaec0, 0xc08c,	0xaeff, 0xc08c,		0x21, 0
	.dw 0xaf40, 0xc08c,	0xaf7f, 0xc08c,		0x21, 0
	.dw 0xafc0, 0xc08c,	0xafff, 0xc08c,		0x21, 0
	.dw 0xb040, 0xc08c,	0xb07f, 0xc08c,		0x21, 0
	.dw 0xb0c0, 0xc08c,	0xb0ff, 0xc08c,		0x21, 0
	.dw 0xb140, 0xc08c,	0xb17f, 0xc08c,		0x21, 0
	.dw 0xb1c0, 0xc08c,	0xb1ff, 0xc08c,		0x21, 0
	.dw 0xb240, 0xc08c,	0xb27f, 0xc08c,		0x21, 0
	.dw 0xb2c0, 0xc08c,	0xb2ff, 0xc08c,		0x21, 0
	.dw 0xb340, 0xc08c,	0xb37f, 0xc08c,		0x21, 0
	.dw 0xb3c0, 0xc08c,	0xb3ff, 0xc08c,		0x21, 0
	.dw 0xb440, 0xc08c,	0xb47f, 0xc08c,		0x21, 0
	.dw 0xb4c0, 0xc08c,	0xb4ff, 0xc08c,		0x21, 0
	.dw 0xb540, 0xc08c,	0xb57f, 0xc08c,		0x21, 0
	.dw 0xb5c0, 0xc08c,	0xb5ff, 0xc08c,		0x21, 0
	.dw 0xb640, 0xc08c,	0xb67f, 0xc08c,		0x21, 0
	.dw 0xb6c0, 0xc08c,	0xb6ff, 0xc08c,		0x21, 0
	.dw 0xb740, 0xc08c,	0xb77f, 0xc08c,		0x21, 0
	.dw 0xb7c0, 0xc08c,	0xb7ff, 0xc08c,		0x21, 0
	.dw 0xb840, 0xc08c,	0xb87f, 0xc08c,		0x21, 0
	.dw 0xb8c0, 0xc08c,	0xb8ff, 0xc08c,		0x21, 0
	.dw 0xb940, 0xc08c,	0xb97f, 0xc08c,		0x21, 0
	.dw 0xb9c0, 0xc08c,	0xbfff, 0xc08c,		0x21, 0
	.dw 0xc040, 0xc08c,	0xc07f, 0xc08c,		0x21, 0
	.dw 0xc0c0, 0xc08c,	0xc0ff, 0xc08c,		0x21, 0
	.dw 0xc140, 0xc08c,	0xc17f, 0xc08c,		0x21, 0
	.dw 0xc1c0, 0xc08c,	0xc1ff, 0xc08c,		0x21, 0
	.dw 0xc240, 0xc08c,	0xc27f, 0xc08c,		0x21, 0
	.dw 0xc2c0, 0xc08c,	0xc2ff, 0xc08c,		0x21, 0
	.dw 0xc340, 0xc08c,	0xc37f, 0xc08c,		0x21, 0
	.dw 0xc3c0, 0xc08c,	0xc3ff, 0xc08c,		0x21, 0
	.dw 0xc440, 0xc08c,	0xc47f, 0xc08c,		0x21, 0
	.dw 0xc4c0, 0xc08c,	0xc4ff, 0xc08c,		0x21, 0
	.dw 0xc540, 0xc08c,	0xc57f, 0xc08c,		0x21, 0
	.dw 0xc5c0, 0xc08c,	0xc5ff, 0xc08c,		0x21, 0
	.dw 0xc640, 0xc08c,	0xc67f, 0xc08c,		0x21, 0
	.dw 0xc6c0, 0xc08c,	0xc6ff, 0xc08c,		0x21, 0
	.dw 0xc740, 0xc08c,	0xc77f, 0xc08c,		0x21, 0
	.dw 0xc7c0, 0xc08c,	0xc7ff, 0xc08c,		0x21, 0
	.dw 0xc840, 0xc08c,	0xc87f, 0xc08c,		0x21, 0
	.dw 0xc8c0, 0xc08c,	0xc8ff, 0xc08c,		0x21, 0
	.dw 0xc940, 0xc08c,	0xc97f, 0xc08c,		0x21, 0
	.dw 0xc9c0, 0xc08c,	0xc9ff, 0xc08c,		0x21, 0
	.dw 0xca40, 0xc08c,	0xca7f, 0xc08c,		0x21, 0
	.dw 0xcac0, 0xc08c,	0xcaff, 0xc08c,		0x21, 0
	.dw 0xcb40, 0xc08c,	0xcb7f, 0xc08c,		0x21, 0
	.dw 0xcbc0, 0xc08c,	0xcbff, 0xc08c,		0x21, 0
	.dw 0xcc40, 0xc08c,	0xcc7f, 0xc08c,		0x21, 0
	.dw 0xccc0, 0xc08c,	0xccff, 0xc08c,		0x21, 0
	.dw 0xcd40, 0xc08c,	0xcd7f, 0xc08c,		0x21, 0
	.dw 0xcdc0, 0xc08c,	0xcdff, 0xc08c,		0x21, 0
	.dw 0xce40, 0xc08c,	0xce7f, 0xc08c,		0x21, 0
	.dw 0xcec0, 0xc08c,	0xceff, 0xc08c,		0x21, 0
	.dw 0xcf40, 0xc08c,	0xcf7f, 0xc08c,		0x21, 0
	.dw 0xcfc0, 0xc08c,	0xcfff, 0xc08c,		0x21, 0
	.dw 0xd040, 0xc08c,	0xd07f, 0xc08c,		0x21, 0
	.dw 0xd0c0, 0xc08c,	0xd0ff, 0xc08c,		0x21, 0
	.dw 0xd140, 0xc08c,	0xd17f, 0xc08c,		0x21, 0
	.dw 0xd1c0, 0xc08c,	0xd1ff, 0xc08c,		0x21, 0
	.dw 0xd240, 0xc08c,	0xd27f, 0xc08c,		0x21, 0
	.dw 0xd2c0, 0xc08c,	0xd2ff, 0xc08c,		0x21, 0
	.dw 0xd340, 0xc08c,	0xd37f, 0xc08c,		0x21, 0
	.dw 0xd3c0, 0xc08c,	0xd3ff, 0xc08c,		0x21, 0
	.dw 0xd440, 0xc08c,	0xd47f, 0xc08c,		0x21, 0
	.dw 0xd4c0, 0xc08c,	0xd4ff, 0xc08c,		0x21, 0
	.dw 0xd540, 0xc08c,	0xd57f, 0xc08c,		0x21, 0
	.dw 0xd5c0, 0xc08c,	0xd5ff, 0xc08c,		0x21, 0
	.dw 0xd640, 0xc08c,	0xd67f, 0xc08c,		0x21, 0
	.dw 0xd6c0, 0xc08c,	0xd6ff, 0xc08c,		0x21, 0
	.dw 0xd740, 0xc08c,	0xd77f, 0xc08c,		0x21, 0
	.dw 0xd7c0, 0xc08c,	0xd7ff, 0xc08c,		0x21, 0
	.dw 0xd840, 0xc08c,	0xd87f, 0xc08c,		0x21, 0
	.dw 0xd8c0, 0xc08c,	0xd8ff, 0xc08c,		0x21, 0
	.dw 0xd940, 0xc08c,	0xd97f, 0xc08c,		0x21, 0
	.dw 0xd9c0, 0xc08c,	0xdfff, 0xc08c,		0x21, 0
	.dw 0xe040, 0xc08c,	0xe07f, 0xc08c,		0x21, 0
	.dw 0xe0c0, 0xc08c,	0xe0ff, 0xc08c,		0x21, 0
	.dw 0xe140, 0xc08c,	0xe17f, 0xc08c,		0x21, 0
	.dw 0xe1c0, 0xc08c,	0xe1ff, 0xc08c,		0x21, 0
	.dw 0xe240, 0xc08c,	0xe27f, 0xc08c,		0x21, 0
	.dw 0xe2c0, 0xc08c,	0xe2ff, 0xc08c,		0x21, 0
	.dw 0xe340, 0xc08c,	0xe37f, 0xc08c,		0x21, 0
	.dw 0xe3c0, 0xc08c,	0xe3ff, 0xc08c,		0x21, 0
	.dw 0xe440, 0xc08c,	0xe47f, 0xc08c,		0x21, 0
	.dw 0xe4c0, 0xc08c,	0xe4ff, 0xc08c,		0x21, 0
	.dw 0xe540, 0xc08c,	0xe57f, 0xc08c,		0x21, 0
	.dw 0xe5c0, 0xc08c,	0xe5ff, 0xc08c,		0x21, 0
	.dw 0xe640, 0xc08c,	0xe67f, 0xc08c,		0x21, 0
	.dw 0xe6c0, 0xc08c,	0xe6ff, 0xc08c,		0x21, 0
	.dw 0xe740, 0xc08c,	0xe77f, 0xc08c,		0x21, 0
	.dw 0xe7c0, 0xc08c,	0xe7ff, 0xc08c,		0x21, 0
	.dw 0xe840, 0xc08c,	0xe87f, 0xc08c,		0x21, 0
	.dw 0xe8c0, 0xc08c,	0xe8ff, 0xc08c,		0x21, 0
	.dw 0xe940, 0xc08c,	0xe97f, 0xc08c,		0x21, 0
	.dw 0xe9c0, 0xc08c,	0xe9ff, 0xc08c,		0x21, 0
	.dw 0xea40, 0xc08c,	0xea7f, 0xc08c,		0x21, 0
	.dw 0xeac0, 0xc08c,	0xeaff, 0xc08c,		0x21, 0
	.dw 0xeb40, 0xc08c,	0xeb7f, 0xc08c,		0x21, 0
	.dw 0xebc0, 0xc08c,	0xebff, 0xc08c,		0x21, 0
	.dw 0xec40, 0xc08c,	0xec7f, 0xc08c,		0x21, 0
	.dw 0xecc0, 0xc08c,	0xecff, 0xc08c,		0x21, 0
	.dw 0xed40, 0xc08c,	0xed7f, 0xc08c,		0x21, 0
	.dw 0xedc0, 0xc08c,	0xedff, 0xc08c,		0x21, 0
	.dw 0xee40, 0xc08c,	0xee7f, 0xc08c,		0x21, 0
	.dw 0xeec0, 0xc08c,	0xeeff, 0xc08c,		0x21, 0
	.dw 0xef40, 0xc08c,	0xef7f, 0xc08c,		0x21, 0
	.dw 0xefc0, 0xc08c,	0xefff, 0xc08c,		0x21, 0
	.dw 0xf040, 0xc08c,	0xf07f, 0xc08c,		0x21, 0
	.dw 0xf0c0, 0xc08c,	0xf0ff, 0xc08c,		0x21, 0
	.dw 0xf140, 0xc08c,	0xf17f, 0xc08c,		0x21, 0
	.dw 0xf1c0, 0xc08c,	0xf1ff, 0xc08c,		0x21, 0
	.dw 0xf240, 0xc08c,	0xf27f, 0xc08c,		0x21, 0
	.dw 0xf2c0, 0xc08c,	0xf2ff, 0xc08c,		0x21, 0
	.dw 0xf340, 0xc08c,	0xf37f, 0xc08c,		0x21, 0
	.dw 0xf3c0, 0xc08c,	0xf3ff, 0xc08c,		0x21, 0
	.dw 0xf440, 0xc08c,	0xf47f, 0xc08c,		0x21, 0
	.dw 0xf4c0, 0xc08c,	0xf4ff, 0xc08c,		0x21, 0
	.dw 0xf540, 0xc08c,	0xf57f, 0xc08c,		0x21, 0
	.dw 0xf5c0, 0xc08c,	0xf5ff, 0xc08c,		0x21, 0
	.dw 0xf640, 0xc08c,	0xf67f, 0xc08c,		0x21, 0
	.dw 0xf6c0, 0xc08c,	0xf6ff, 0xc08c,		0x21, 0
	.dw 0xf740, 0xc08c,	0xf77f, 0xc08c,		0x21, 0
	.dw 0xf7c0, 0xc08c,	0xf7ff, 0xc08c,		0x21, 0
	.dw 0xf840, 0xc08c,	0xf87f, 0xc08c,		0x21, 0
	.dw 0xf8c0, 0xc08c,	0xf8ff, 0xc08c,		0x21, 0
	.dw 0xf940, 0xc08c,	0xf97f, 0xc08c,		0x21, 0
	.dw 0xf9c0, 0xc08c,	0xffff, 0xc08c,		0x21, 0
	.dw 0x0040, 0xc08d,	0x007f, 0xc08d,		0x21, 0
	.dw 0x00c0, 0xc08d,	0x00ff, 0xc08d,		0x21, 0
	.dw 0x0140, 0xc08d,	0x017f, 0xc08d,		0x21, 0
	.dw 0x01c0, 0xc08d,	0x01ff, 0xc08d,		0x21, 0
	.dw 0x0240, 0xc08d,	0x027f, 0xc08d,		0x21, 0
	.dw 0x02c0, 0xc08d,	0x02ff, 0xc08d,		0x21, 0
	.dw 0x0340, 0xc08d,	0x037f, 0xc08d,		0x21, 0
	.dw 0x03c0, 0xc08d,	0x03ff, 0xc08d,		0x21, 0
	.dw 0x0440, 0xc08d,	0x047f, 0xc08d,		0x21, 0
	.dw 0x04c0, 0xc08d,	0x04ff, 0xc08d,		0x21, 0
	.dw 0x0540, 0xc08d,	0x057f, 0xc08d,		0x21, 0
	.dw 0x05c0, 0xc08d,	0x05ff, 0xc08d,		0x21, 0
	.dw 0x0640, 0xc08d,	0x067f, 0xc08d,		0x21, 0
	.dw 0x06c0, 0xc08d,	0x06ff, 0xc08d,		0x21, 0
	.dw 0x0740, 0xc08d,	0x077f, 0xc08d,		0x21, 0
	.dw 0x07c0, 0xc08d,	0x07ff, 0xc08d,		0x21, 0
	.dw 0x0840, 0xc08d,	0x087f, 0xc08d,		0x21, 0
	.dw 0x08c0, 0xc08d,	0x08ff, 0xc08d,		0x21, 0
	.dw 0x0940, 0xc08d,	0x097f, 0xc08d,		0x21, 0
	.dw 0x09c0, 0xc08d,	0x09ff, 0xc08d,		0x21, 0
	.dw 0x0a40, 0xc08d,	0x0a7f, 0xc08d,		0x21, 0
	.dw 0x0ac0, 0xc08d,	0x0aff, 0xc08d,		0x21, 0
	.dw 0x0b40, 0xc08d,	0x0b7f, 0xc08d,		0x21, 0
	.dw 0x0bc0, 0xc08d,	0x0bff, 0xc08d,		0x21, 0
	.dw 0x0c40, 0xc08d,	0x0c7f, 0xc08d,		0x21, 0
	.dw 0x0cc0, 0xc08d,	0x0cff, 0xc08d,		0x21, 0
	.dw 0x0d40, 0xc08d,	0x0d7f, 0xc08d,		0x21, 0
	.dw 0x0dc0, 0xc08d,	0x0dff, 0xc08d,		0x21, 0
	.dw 0x0e40, 0xc08d,	0x0e7f, 0xc08d,		0x21, 0
	.dw 0x0ec0, 0xc08d,	0x0eff, 0xc08d,		0x21, 0
	.dw 0x0f40, 0xc08d,	0x0f7f, 0xc08d,		0x21, 0
	.dw 0x0fc0, 0xc08d,	0x0fff, 0xc08d,		0x21, 0
	.dw 0x1040, 0xc08d,	0x107f, 0xc08d,		0x21, 0
	.dw 0x10c0, 0xc08d,	0x10ff, 0xc08d,		0x21, 0
	.dw 0x1140, 0xc08d,	0x117f, 0xc08d,		0x21, 0
	.dw 0x11c0, 0xc08d,	0x11ff, 0xc08d,		0x21, 0
	.dw 0x1240, 0xc08d,	0x127f, 0xc08d,		0x21, 0
	.dw 0x12c0, 0xc08d,	0x12ff, 0xc08d,		0x21, 0
	.dw 0x1340, 0xc08d,	0x137f, 0xc08d,		0x21, 0
	.dw 0x13c0, 0xc08d,	0x13ff, 0xc08d,		0x21, 0
	.dw 0x1440, 0xc08d,	0x147f, 0xc08d,		0x21, 0
	.dw 0x14c0, 0xc08d,	0x14ff, 0xc08d,		0x21, 0
	.dw 0x1540, 0xc08d,	0x157f, 0xc08d,		0x21, 0
	.dw 0x15c0, 0xc08d,	0x15ff, 0xc08d,		0x21, 0
	.dw 0x1640, 0xc08d,	0x167f, 0xc08d,		0x21, 0
	.dw 0x16c0, 0xc08d,	0x16ff, 0xc08d,		0x21, 0
	.dw 0x1740, 0xc08d,	0x177f, 0xc08d,		0x21, 0
	.dw 0x17c0, 0xc08d,	0x17ff, 0xc08d,		0x21, 0
	.dw 0x1840, 0xc08d,	0x187f, 0xc08d,		0x21, 0
	.dw 0x18c0, 0xc08d,	0x18ff, 0xc08d,		0x21, 0
	.dw 0x1940, 0xc08d,	0x197f, 0xc08d,		0x21, 0
	.dw 0x19c0, 0xc08d,	0x1fff, 0xc08d,		0x21, 0
	.dw 0x2040, 0xc08d,	0x207f, 0xc08d,		0x21, 0
	.dw 0x20c0, 0xc08d,	0x20ff, 0xc08d,		0x21, 0
	.dw 0x2140, 0xc08d,	0x217f, 0xc08d,		0x21, 0
	.dw 0x21c0, 0xc08d,	0x21ff, 0xc08d,		0x21, 0
	.dw 0x2240, 0xc08d,	0x227f, 0xc08d,		0x21, 0
	.dw 0x22c0, 0xc08d,	0x22ff, 0xc08d,		0x21, 0
	.dw 0x2340, 0xc08d,	0x237f, 0xc08d,		0x21, 0
	.dw 0x23c0, 0xc08d,	0x23ff, 0xc08d,		0x21, 0
	.dw 0x2440, 0xc08d,	0x247f, 0xc08d,		0x21, 0
	.dw 0x24c0, 0xc08d,	0x24ff, 0xc08d,		0x21, 0
	.dw 0x2540, 0xc08d,	0x257f, 0xc08d,		0x21, 0
	.dw 0x25c0, 0xc08d,	0x25ff, 0xc08d,		0x21, 0
	.dw 0x2640, 0xc08d,	0x267f, 0xc08d,		0x21, 0
	.dw 0x26c0, 0xc08d,	0x26ff, 0xc08d,		0x21, 0
	.dw 0x2740, 0xc08d,	0x277f, 0xc08d,		0x21, 0
	.dw 0x27c0, 0xc08d,	0x27ff, 0xc08d,		0x21, 0
	.dw 0x2840, 0xc08d,	0x287f, 0xc08d,		0x21, 0
	.dw 0x28c0, 0xc08d,	0x28ff, 0xc08d,		0x21, 0
	.dw 0x2940, 0xc08d,	0x297f, 0xc08d,		0x21, 0
	.dw 0x29c0, 0xc08d,	0x29ff, 0xc08d,		0x21, 0
	.dw 0x2a40, 0xc08d,	0x2a7f, 0xc08d,		0x21, 0
	.dw 0x2ac0, 0xc08d,	0x2aff, 0xc08d,		0x21, 0
	.dw 0x2b40, 0xc08d,	0x2b7f, 0xc08d,		0x21, 0
	.dw 0x2bc0, 0xc08d,	0x2bff, 0xc08d,		0x21, 0
	.dw 0x2c40, 0xc08d,	0x2c7f, 0xc08d,		0x21, 0
	.dw 0x2cc0, 0xc08d,	0x2cff, 0xc08d,		0x21, 0
	.dw 0x2d40, 0xc08d,	0x2d7f, 0xc08d,		0x21, 0
	.dw 0x2dc0, 0xc08d,	0x2dff, 0xc08d,		0x21, 0
	.dw 0x2e40, 0xc08d,	0x2e7f, 0xc08d,		0x21, 0
	.dw 0x2ec0, 0xc08d,	0x2eff, 0xc08d,		0x21, 0
	.dw 0x2f40, 0xc08d,	0x2f7f, 0xc08d,		0x21, 0
	.dw 0x2fc0, 0xc08d,	0x2fff, 0xc08d,		0x21, 0
	.dw 0x3040, 0xc08d,	0x307f, 0xc08d,		0x21, 0
	.dw 0x30c0, 0xc08d,	0x30ff, 0xc08d,		0x21, 0
	.dw 0x3140, 0xc08d,	0x317f, 0xc08d,		0x21, 0
	.dw 0x31c0, 0xc08d,	0x31ff, 0xc08d,		0x21, 0
	.dw 0x3240, 0xc08d,	0x327f, 0xc08d,		0x21, 0
	.dw 0x32c0, 0xc08d,	0x32ff, 0xc08d,		0x21, 0
	.dw 0x3340, 0xc08d,	0x337f, 0xc08d,		0x21, 0
	.dw 0x33c0, 0xc08d,	0x33ff, 0xc08d,		0x21, 0
	.dw 0x3440, 0xc08d,	0x347f, 0xc08d,		0x21, 0
	.dw 0x34c0, 0xc08d,	0x34ff, 0xc08d,		0x21, 0
	.dw 0x3540, 0xc08d,	0x357f, 0xc08d,		0x21, 0
	.dw 0x35c0, 0xc08d,	0x35ff, 0xc08d,		0x21, 0
	.dw 0x3640, 0xc08d,	0x367f, 0xc08d,		0x21, 0
	.dw 0x36c0, 0xc08d,	0x36ff, 0xc08d,		0x21, 0
	.dw 0x3740, 0xc08d,	0x377f, 0xc08d,		0x21, 0
	.dw 0x37c0, 0xc08d,	0x37ff, 0xc08d,		0x21, 0
	.dw 0x3840, 0xc08d,	0x387f, 0xc08d,		0x21, 0
	.dw 0x38c0, 0xc08d,	0x38ff, 0xc08d,		0x21, 0
	.dw 0x3940, 0xc08d,	0x397f, 0xc08d,		0x21, 0
	.dw 0x39c0, 0xc08d,	0x3fff, 0xc08d,		0x21, 0
	.dw 0x4040, 0xc08d,	0x407f, 0xc08d,		0x21, 0
	.dw 0x40c0, 0xc08d,	0x40ff, 0xc08d,		0x21, 0
	.dw 0x4140, 0xc08d,	0x417f, 0xc08d,		0x21, 0
	.dw 0x41c0, 0xc08d,	0x41ff, 0xc08d,		0x21, 0
	.dw 0x4240, 0xc08d,	0x427f, 0xc08d,		0x21, 0
	.dw 0x42c0, 0xc08d,	0x42ff, 0xc08d,		0x21, 0
	.dw 0x4340, 0xc08d,	0x437f, 0xc08d,		0x21, 0
	.dw 0x43c0, 0xc08d,	0x43ff, 0xc08d,		0x21, 0
	.dw 0x4440, 0xc08d,	0x447f, 0xc08d,		0x21, 0
	.dw 0x44c0, 0xc08d,	0x44ff, 0xc08d,		0x21, 0
	.dw 0x4540, 0xc08d,	0x457f, 0xc08d,		0x21, 0
	.dw 0x45c0, 0xc08d,	0x45ff, 0xc08d,		0x21, 0
	.dw 0x4640, 0xc08d,	0x467f, 0xc08d,		0x21, 0
	.dw 0x46c0, 0xc08d,	0x46ff, 0xc08d,		0x21, 0
	.dw 0x4740, 0xc08d,	0x477f, 0xc08d,		0x21, 0
	.dw 0x47c0, 0xc08d,	0x47ff, 0xc08d,		0x21, 0
	.dw 0x4840, 0xc08d,	0x487f, 0xc08d,		0x21, 0
	.dw 0x48c0, 0xc08d,	0x48ff, 0xc08d,		0x21, 0
	.dw 0x4940, 0xc08d,	0x497f, 0xc08d,		0x21, 0
	.dw 0x49c0, 0xc08d,	0x49ff, 0xc08d,		0x21, 0
	.dw 0x4a40, 0xc08d,	0x4a7f, 0xc08d,		0x21, 0
	.dw 0x4ac0, 0xc08d,	0x4aff, 0xc08d,		0x21, 0
	.dw 0x4b40, 0xc08d,	0x4b7f, 0xc08d,		0x21, 0
	.dw 0x4bc0, 0xc08d,	0x4bff, 0xc08d,		0x21, 0
	.dw 0x4c40, 0xc08d,	0x4c7f, 0xc08d,		0x21, 0
	.dw 0x4cc0, 0xc08d,	0x4cff, 0xc08d,		0x21, 0
	.dw 0x4d40, 0xc08d,	0x4d7f, 0xc08d,		0x21, 0
	.dw 0x4dc0, 0xc08d,	0x4dff, 0xc08d,		0x21, 0
	.dw 0x4e40, 0xc08d,	0x4e7f, 0xc08d,		0x21, 0
	.dw 0x4ec0, 0xc08d,	0x4eff, 0xc08d,		0x21, 0
	.dw 0x4f40, 0xc08d,	0x4f7f, 0xc08d,		0x21, 0
	.dw 0x4fc0, 0xc08d,	0x4fff, 0xc08d,		0x21, 0
	.dw 0x5040, 0xc08d,	0x507f, 0xc08d,		0x21, 0
	.dw 0x50c0, 0xc08d,	0x50ff, 0xc08d,		0x21, 0
	.dw 0x5140, 0xc08d,	0x517f, 0xc08d,		0x21, 0
	.dw 0x51c0, 0xc08d,	0x51ff, 0xc08d,		0x21, 0
	.dw 0x5240, 0xc08d,	0x527f, 0xc08d,		0x21, 0
	.dw 0x52c0, 0xc08d,	0x52ff, 0xc08d,		0x21, 0
	.dw 0x5340, 0xc08d,	0x537f, 0xc08d,		0x21, 0
	.dw 0x53c0, 0xc08d,	0x53ff, 0xc08d,		0x21, 0
	.dw 0x5440, 0xc08d,	0x547f, 0xc08d,		0x21, 0
	.dw 0x54c0, 0xc08d,	0x54ff, 0xc08d,		0x21, 0
	.dw 0x5540, 0xc08d,	0x557f, 0xc08d,		0x21, 0
	.dw 0x55c0, 0xc08d,	0x55ff, 0xc08d,		0x21, 0
	.dw 0x5640, 0xc08d,	0x567f, 0xc08d,		0x21, 0
	.dw 0x56c0, 0xc08d,	0x56ff, 0xc08d,		0x21, 0
	.dw 0x5740, 0xc08d,	0x577f, 0xc08d,		0x21, 0
	.dw 0x57c0, 0xc08d,	0x57ff, 0xc08d,		0x21, 0
	.dw 0x5840, 0xc08d,	0x587f, 0xc08d,		0x21, 0
	.dw 0x58c0, 0xc08d,	0x58ff, 0xc08d,		0x21, 0
	.dw 0x5940, 0xc08d,	0x597f, 0xc08d,		0x21, 0
	.dw 0x59c0, 0xc08d,	0x5fff, 0xc08d,		0x21, 0
	.dw 0x6040, 0xc08d,	0x607f, 0xc08d,		0x21, 0
	.dw 0x60c0, 0xc08d,	0x60ff, 0xc08d,		0x21, 0
	.dw 0x6140, 0xc08d,	0x617f, 0xc08d,		0x21, 0
	.dw 0x61c0, 0xc08d,	0x61ff, 0xc08d,		0x21, 0
	.dw 0x6240, 0xc08d,	0x627f, 0xc08d,		0x21, 0
	.dw 0x62c0, 0xc08d,	0x62ff, 0xc08d,		0x21, 0
	.dw 0x6340, 0xc08d,	0x637f, 0xc08d,		0x21, 0
	.dw 0x63c0, 0xc08d,	0x63ff, 0xc08d,		0x21, 0
	.dw 0x6440, 0xc08d,	0x647f, 0xc08d,		0x21, 0
	.dw 0x64c0, 0xc08d,	0x64ff, 0xc08d,		0x21, 0
	.dw 0x6540, 0xc08d,	0x657f, 0xc08d,		0x21, 0
	.dw 0x65c0, 0xc08d,	0x65ff, 0xc08d,		0x21, 0
	.dw 0x6640, 0xc08d,	0x667f, 0xc08d,		0x21, 0
	.dw 0x66c0, 0xc08d,	0x66ff, 0xc08d,		0x21, 0
	.dw 0x6740, 0xc08d,	0x677f, 0xc08d,		0x21, 0
	.dw 0x67c0, 0xc08d,	0x67ff, 0xc08d,		0x21, 0
	.dw 0x6840, 0xc08d,	0x687f, 0xc08d,		0x21, 0
	.dw 0x68c0, 0xc08d,	0x68ff, 0xc08d,		0x21, 0
	.dw 0x6940, 0xc08d,	0x697f, 0xc08d,		0x21, 0
	.dw 0x69c0, 0xc08d,	0x69ff, 0xc08d,		0x21, 0
	.dw 0x6a40, 0xc08d,	0x6a7f, 0xc08d,		0x21, 0
	.dw 0x6ac0, 0xc08d,	0x6aff, 0xc08d,		0x21, 0
	.dw 0x6b40, 0xc08d,	0x6b7f, 0xc08d,		0x21, 0
	.dw 0x6bc0, 0xc08d,	0x6bff, 0xc08d,		0x21, 0
	.dw 0x6c40, 0xc08d,	0x6c7f, 0xc08d,		0x21, 0
	.dw 0x6cc0, 0xc08d,	0x6cff, 0xc08d,		0x21, 0
	.dw 0x6d40, 0xc08d,	0x6d7f, 0xc08d,		0x21, 0
	.dw 0x6dc0, 0xc08d,	0x6dff, 0xc08d,		0x21, 0
	.dw 0x6e40, 0xc08d,	0x6e7f, 0xc08d,		0x21, 0
	.dw 0x6ec0, 0xc08d,	0x6eff, 0xc08d,		0x21, 0
	.dw 0x6f40, 0xc08d,	0x6f7f, 0xc08d,		0x21, 0
	.dw 0x6fc0, 0xc08d,	0x6fff, 0xc08d,		0x21, 0
	.dw 0x7040, 0xc08d,	0x707f, 0xc08d,		0x21, 0
	.dw 0x70c0, 0xc08d,	0x70ff, 0xc08d,		0x21, 0
	.dw 0x7140, 0xc08d,	0x717f, 0xc08d,		0x21, 0
	.dw 0x71c0, 0xc08d,	0x71ff, 0xc08d,		0x21, 0
	.dw 0x7240, 0xc08d,	0x727f, 0xc08d,		0x21, 0
	.dw 0x72c0, 0xc08d,	0x72ff, 0xc08d,		0x21, 0
	.dw 0x7340, 0xc08d,	0x737f, 0xc08d,		0x21, 0
	.dw 0x73c0, 0xc08d,	0x73ff, 0xc08d,		0x21, 0
	.dw 0x7440, 0xc08d,	0x747f, 0xc08d,		0x21, 0
	.dw 0x74c0, 0xc08d,	0x74ff, 0xc08d,		0x21, 0
	.dw 0x7540, 0xc08d,	0x757f, 0xc08d,		0x21, 0
	.dw 0x75c0, 0xc08d,	0x75ff, 0xc08d,		0x21, 0
	.dw 0x7640, 0xc08d,	0x767f, 0xc08d,		0x21, 0
	.dw 0x76c0, 0xc08d,	0x76ff, 0xc08d,		0x21, 0
	.dw 0x7740, 0xc08d,	0x777f, 0xc08d,		0x21, 0
	.dw 0x77c0, 0xc08d,	0x77ff, 0xc08d,		0x21, 0
	.dw 0x7840, 0xc08d,	0x787f, 0xc08d,		0x21, 0
	.dw 0x78c0, 0xc08d,	0x78ff, 0xc08d,		0x21, 0
	.dw 0x7940, 0xc08d,	0x797f, 0xc08d,		0x21, 0
	.dw 0x79c0, 0xc08d,	0x7fff, 0xc08d,		0x21, 0
	.dw 0x8040, 0xc08d,	0x807f, 0xc08d,		0x21, 0
	.dw 0x80c0, 0xc08d,	0x80ff, 0xc08d,		0x21, 0
	.dw 0x8140, 0xc08d,	0x817f, 0xc08d,		0x21, 0
	.dw 0x81c0, 0xc08d,	0x81ff, 0xc08d,		0x21, 0
	.dw 0x8240, 0xc08d,	0x827f, 0xc08d,		0x21, 0
	.dw 0x82c0, 0xc08d,	0x82ff, 0xc08d,		0x21, 0
	.dw 0x8340, 0xc08d,	0x837f, 0xc08d,		0x21, 0
	.dw 0x83c0, 0xc08d,	0x83ff, 0xc08d,		0x21, 0
	.dw 0x8440, 0xc08d,	0x847f, 0xc08d,		0x21, 0
	.dw 0x84c0, 0xc08d,	0x84ff, 0xc08d,		0x21, 0
	.dw 0x8540, 0xc08d,	0x857f, 0xc08d,		0x21, 0
	.dw 0x85c0, 0xc08d,	0x85ff, 0xc08d,		0x21, 0
	.dw 0x8640, 0xc08d,	0x867f, 0xc08d,		0x21, 0
	.dw 0x86c0, 0xc08d,	0x86ff, 0xc08d,		0x21, 0
	.dw 0x8740, 0xc08d,	0x877f, 0xc08d,		0x21, 0
	.dw 0x87c0, 0xc08d,	0x87ff, 0xc08d,		0x21, 0
	.dw 0x8840, 0xc08d,	0x887f, 0xc08d,		0x21, 0
	.dw 0x88c0, 0xc08d,	0x88ff, 0xc08d,		0x21, 0
	.dw 0x8940, 0xc08d,	0x897f, 0xc08d,		0x21, 0
	.dw 0x89c0, 0xc08d,	0x89ff, 0xc08d,		0x21, 0
	.dw 0x8a40, 0xc08d,	0x8a7f, 0xc08d,		0x21, 0
	.dw 0x8ac0, 0xc08d,	0x8aff, 0xc08d,		0x21, 0
	.dw 0x8b40, 0xc08d,	0x8b7f, 0xc08d,		0x21, 0
	.dw 0x8bc0, 0xc08d,	0x8bff, 0xc08d,		0x21, 0
	.dw 0x8c40, 0xc08d,	0x8c7f, 0xc08d,		0x21, 0
	.dw 0x8cc0, 0xc08d,	0x8cff, 0xc08d,		0x21, 0
	.dw 0x8d40, 0xc08d,	0x8d7f, 0xc08d,		0x21, 0
	.dw 0x8dc0, 0xc08d,	0x8dff, 0xc08d,		0x21, 0
	.dw 0x8e40, 0xc08d,	0x8e7f, 0xc08d,		0x21, 0
	.dw 0x8ec0, 0xc08d,	0x8eff, 0xc08d,		0x21, 0
	.dw 0x8f40, 0xc08d,	0x8f7f, 0xc08d,		0x21, 0
	.dw 0x8fc0, 0xc08d,	0x8fff, 0xc08d,		0x21, 0
	.dw 0x9040, 0xc08d,	0x907f, 0xc08d,		0x21, 0
	.dw 0x90c0, 0xc08d,	0x90ff, 0xc08d,		0x21, 0
	.dw 0x9140, 0xc08d,	0x917f, 0xc08d,		0x21, 0
	.dw 0x91c0, 0xc08d,	0x91ff, 0xc08d,		0x21, 0
	.dw 0x9240, 0xc08d,	0x927f, 0xc08d,		0x21, 0
	.dw 0x92c0, 0xc08d,	0x92ff, 0xc08d,		0x21, 0
	.dw 0x9340, 0xc08d,	0x937f, 0xc08d,		0x21, 0
	.dw 0x93c0, 0xc08d,	0x93ff, 0xc08d,		0x21, 0
	.dw 0x9440, 0xc08d,	0x947f, 0xc08d,		0x21, 0
	.dw 0x94c0, 0xc08d,	0x94ff, 0xc08d,		0x21, 0
	.dw 0x9540, 0xc08d,	0x957f, 0xc08d,		0x21, 0
	.dw 0x95c0, 0xc08d,	0x95ff, 0xc08d,		0x21, 0
	.dw 0x9640, 0xc08d,	0x967f, 0xc08d,		0x21, 0
	.dw 0x96c0, 0xc08d,	0x96ff, 0xc08d,		0x21, 0
	.dw 0x9740, 0xc08d,	0x977f, 0xc08d,		0x21, 0
	.dw 0x97c0, 0xc08d,	0x97ff, 0xc08d,		0x21, 0
	.dw 0x9840, 0xc08d,	0x987f, 0xc08d,		0x21, 0
	.dw 0x98c0, 0xc08d,	0x98ff, 0xc08d,		0x21, 0
	.dw 0x9940, 0xc08d,	0x997f, 0xc08d,		0x21, 0
	.dw 0x99c0, 0xc08d,	0x9fff, 0xc08d,		0x21, 0
	.dw 0xa040, 0xc08d,	0xa07f, 0xc08d,		0x21, 0
	.dw 0xa0c0, 0xc08d,	0xa0ff, 0xc08d,		0x21, 0
	.dw 0xa140, 0xc08d,	0xa17f, 0xc08d,		0x21, 0
	.dw 0xa1c0, 0xc08d,	0xa1ff, 0xc08d,		0x21, 0
	.dw 0xa240, 0xc08d,	0xa27f, 0xc08d,		0x21, 0
	.dw 0xa2c0, 0xc08d,	0xa2ff, 0xc08d,		0x21, 0
	.dw 0xa340, 0xc08d,	0xa37f, 0xc08d,		0x21, 0
	.dw 0xa3c0, 0xc08d,	0xa3ff, 0xc08d,		0x21, 0
	.dw 0xa440, 0xc08d,	0xa47f, 0xc08d,		0x21, 0
	.dw 0xa4c0, 0xc08d,	0xa4ff, 0xc08d,		0x21, 0
	.dw 0xa540, 0xc08d,	0xa57f, 0xc08d,		0x21, 0
	.dw 0xa5c0, 0xc08d,	0xa5ff, 0xc08d,		0x21, 0
	.dw 0xa640, 0xc08d,	0xa67f, 0xc08d,		0x21, 0
	.dw 0xa6c0, 0xc08d,	0xa6ff, 0xc08d,		0x21, 0
	.dw 0xa740, 0xc08d,	0xa77f, 0xc08d,		0x21, 0
	.dw 0xa7c0, 0xc08d,	0xa7ff, 0xc08d,		0x21, 0
	.dw 0xa840, 0xc08d,	0xa87f, 0xc08d,		0x21, 0
	.dw 0xa8c0, 0xc08d,	0xa8ff, 0xc08d,		0x21, 0
	.dw 0xa940, 0xc08d,	0xa97f, 0xc08d,		0x21, 0
	.dw 0xa9c0, 0xc08d,	0xa9ff, 0xc08d,		0x21, 0
	.dw 0xaa40, 0xc08d,	0xaa7f, 0xc08d,		0x21, 0
	.dw 0xaac0, 0xc08d,	0xaaff, 0xc08d,		0x21, 0
	.dw 0xab40, 0xc08d,	0xab7f, 0xc08d,		0x21, 0
	.dw 0xabc0, 0xc08d,	0xabff, 0xc08d,		0x21, 0
	.dw 0xac40, 0xc08d,	0xac7f, 0xc08d,		0x21, 0
	.dw 0xacc0, 0xc08d,	0xacff, 0xc08d,		0x21, 0
	.dw 0xad40, 0xc08d,	0xad7f, 0xc08d,		0x21, 0
	.dw 0xadc0, 0xc08d,	0xadff, 0xc08d,		0x21, 0
	.dw 0xae40, 0xc08d,	0xae7f, 0xc08d,		0x21, 0
	.dw 0xaec0, 0xc08d,	0xaeff, 0xc08d,		0x21, 0
	.dw 0xaf40, 0xc08d,	0xaf7f, 0xc08d,		0x21, 0
	.dw 0xafc0, 0xc08d,	0xafff, 0xc08d,		0x21, 0
	.dw 0xb040, 0xc08d,	0xb07f, 0xc08d,		0x21, 0
	.dw 0xb0c0, 0xc08d,	0xb0ff, 0xc08d,		0x21, 0
	.dw 0xb140, 0xc08d,	0xb17f, 0xc08d,		0x21, 0
	.dw 0xb1c0, 0xc08d,	0xb1ff, 0xc08d,		0x21, 0
	.dw 0xb240, 0xc08d,	0xb27f, 0xc08d,		0x21, 0
	.dw 0xb2c0, 0xc08d,	0xb2ff, 0xc08d,		0x21, 0
	.dw 0xb340, 0xc08d,	0xb37f, 0xc08d,		0x21, 0
	.dw 0xb3c0, 0xc08d,	0xb3ff, 0xc08d,		0x21, 0
	.dw 0xb440, 0xc08d,	0xb47f, 0xc08d,		0x21, 0
	.dw 0xb4c0, 0xc08d,	0xb4ff, 0xc08d,		0x21, 0
	.dw 0xb540, 0xc08d,	0xb57f, 0xc08d,		0x21, 0
	.dw 0xb5c0, 0xc08d,	0xb5ff, 0xc08d,		0x21, 0
	.dw 0xb640, 0xc08d,	0xb67f, 0xc08d,		0x21, 0
	.dw 0xb6c0, 0xc08d,	0xb6ff, 0xc08d,		0x21, 0
	.dw 0xb740, 0xc08d,	0xb77f, 0xc08d,		0x21, 0
	.dw 0xb7c0, 0xc08d,	0xb7ff, 0xc08d,		0x21, 0
	.dw 0xb840, 0xc08d,	0xb87f, 0xc08d,		0x21, 0
	.dw 0xb8c0, 0xc08d,	0xb8ff, 0xc08d,		0x21, 0
	.dw 0xb940, 0xc08d,	0xb97f, 0xc08d,		0x21, 0
	.dw 0xb9c0, 0xc08d,	0xbfff, 0xc08d,		0x21, 0
	.dw 0xc040, 0xc08d,	0xc07f, 0xc08d,		0x21, 0
	.dw 0xc0c0, 0xc08d,	0xc0ff, 0xc08d,		0x21, 0
	.dw 0xc140, 0xc08d,	0xc17f, 0xc08d,		0x21, 0
	.dw 0xc1c0, 0xc08d,	0xc1ff, 0xc08d,		0x21, 0
	.dw 0xc240, 0xc08d,	0xc27f, 0xc08d,		0x21, 0
	.dw 0xc2c0, 0xc08d,	0xc2ff, 0xc08d,		0x21, 0
	.dw 0xc340, 0xc08d,	0xc37f, 0xc08d,		0x21, 0
	.dw 0xc3c0, 0xc08d,	0xc3ff, 0xc08d,		0x21, 0
	.dw 0xc440, 0xc08d,	0xc47f, 0xc08d,		0x21, 0
	.dw 0xc4c0, 0xc08d,	0xc4ff, 0xc08d,		0x21, 0
	.dw 0xc540, 0xc08d,	0xc57f, 0xc08d,		0x21, 0
	.dw 0xc5c0, 0xc08d,	0xc5ff, 0xc08d,		0x21, 0
	.dw 0xc640, 0xc08d,	0xc67f, 0xc08d,		0x21, 0
	.dw 0xc6c0, 0xc08d,	0xc6ff, 0xc08d,		0x21, 0
	.dw 0xc740, 0xc08d,	0xc77f, 0xc08d,		0x21, 0
	.dw 0xc7c0, 0xc08d,	0xc7ff, 0xc08d,		0x21, 0
	.dw 0xc840, 0xc08d,	0xc87f, 0xc08d,		0x21, 0
	.dw 0xc8c0, 0xc08d,	0xc8ff, 0xc08d,		0x21, 0
	.dw 0xc940, 0xc08d,	0xc97f, 0xc08d,		0x21, 0
	.dw 0xc9c0, 0xc08d,	0xc9ff, 0xc08d,		0x21, 0
	.dw 0xca40, 0xc08d,	0xca7f, 0xc08d,		0x21, 0
	.dw 0xcac0, 0xc08d,	0xcaff, 0xc08d,		0x21, 0
	.dw 0xcb40, 0xc08d,	0xcb7f, 0xc08d,		0x21, 0
	.dw 0xcbc0, 0xc08d,	0xcbff, 0xc08d,		0x21, 0
	.dw 0xcc40, 0xc08d,	0xcc7f, 0xc08d,		0x21, 0
	.dw 0xccc0, 0xc08d,	0xccff, 0xc08d,		0x21, 0
	.dw 0xcd40, 0xc08d,	0xcd7f, 0xc08d,		0x21, 0
	.dw 0xcdc0, 0xc08d,	0xcdff, 0xc08d,		0x21, 0
	.dw 0xce40, 0xc08d,	0xce7f, 0xc08d,		0x21, 0
	.dw 0xcec0, 0xc08d,	0xceff, 0xc08d,		0x21, 0
	.dw 0xcf40, 0xc08d,	0xcf7f, 0xc08d,		0x21, 0
	.dw 0xcfc0, 0xc08d,	0xcfff, 0xc08d,		0x21, 0
	.dw 0xd040, 0xc08d,	0xd07f, 0xc08d,		0x21, 0
	.dw 0xd0c0, 0xc08d,	0xd0ff, 0xc08d,		0x21, 0
	.dw 0xd140, 0xc08d,	0xd17f, 0xc08d,		0x21, 0
	.dw 0xd1c0, 0xc08d,	0xd1ff, 0xc08d,		0x21, 0
	.dw 0xd240, 0xc08d,	0xd27f, 0xc08d,		0x21, 0
	.dw 0xd2c0, 0xc08d,	0xd2ff, 0xc08d,		0x21, 0
	.dw 0xd340, 0xc08d,	0xd37f, 0xc08d,		0x21, 0
	.dw 0xd3c0, 0xc08d,	0xd3ff, 0xc08d,		0x21, 0
	.dw 0xd440, 0xc08d,	0xd47f, 0xc08d,		0x21, 0
	.dw 0xd4c0, 0xc08d,	0xd4ff, 0xc08d,		0x21, 0
	.dw 0xd540, 0xc08d,	0xd57f, 0xc08d,		0x21, 0
	.dw 0xd5c0, 0xc08d,	0xd5ff, 0xc08d,		0x21, 0
	.dw 0xd640, 0xc08d,	0xd67f, 0xc08d,		0x21, 0
	.dw 0xd6c0, 0xc08d,	0xd6ff, 0xc08d,		0x21, 0
	.dw 0xd740, 0xc08d,	0xd77f, 0xc08d,		0x21, 0
	.dw 0xd7c0, 0xc08d,	0xd7ff, 0xc08d,		0x21, 0
	.dw 0xd840, 0xc08d,	0xd87f, 0xc08d,		0x21, 0
	.dw 0xd8c0, 0xc08d,	0xd8ff, 0xc08d,		0x21, 0
	.dw 0xd940, 0xc08d,	0xd97f, 0xc08d,		0x21, 0
	.dw 0xd9c0, 0xc08d,	0xdfff, 0xc08d,		0x21, 0
	.dw 0xe040, 0xc08d,	0xe07f, 0xc08d,		0x21, 0
	.dw 0xe0c0, 0xc08d,	0xe0ff, 0xc08d,		0x21, 0
	.dw 0xe140, 0xc08d,	0xe17f, 0xc08d,		0x21, 0
	.dw 0xe1c0, 0xc08d,	0xe1ff, 0xc08d,		0x21, 0
	.dw 0xe240, 0xc08d,	0xe27f, 0xc08d,		0x21, 0
	.dw 0xe2c0, 0xc08d,	0xe2ff, 0xc08d,		0x21, 0
	.dw 0xe340, 0xc08d,	0xe37f, 0xc08d,		0x21, 0
	.dw 0xe3c0, 0xc08d,	0xe3ff, 0xc08d,		0x21, 0
	.dw 0xe440, 0xc08d,	0xe47f, 0xc08d,		0x21, 0
	.dw 0xe4c0, 0xc08d,	0xe4ff, 0xc08d,		0x21, 0
	.dw 0xe540, 0xc08d,	0xe57f, 0xc08d,		0x21, 0
	.dw 0xe5c0, 0xc08d,	0xe5ff, 0xc08d,		0x21, 0
	.dw 0xe640, 0xc08d,	0xe67f, 0xc08d,		0x21, 0
	.dw 0xe6c0, 0xc08d,	0xe6ff, 0xc08d,		0x21, 0
	.dw 0xe740, 0xc08d,	0xe77f, 0xc08d,		0x21, 0
	.dw 0xe7c0, 0xc08d,	0xe7ff, 0xc08d,		0x21, 0
	.dw 0xe840, 0xc08d,	0xe87f, 0xc08d,		0x21, 0
	.dw 0xe8c0, 0xc08d,	0xe8ff, 0xc08d,		0x21, 0
	.dw 0xe940, 0xc08d,	0xe97f, 0xc08d,		0x21, 0
	.dw 0xe9c0, 0xc08d,	0xe9ff, 0xc08d,		0x21, 0
	.dw 0xea40, 0xc08d,	0xea7f, 0xc08d,		0x21, 0
	.dw 0xeac0, 0xc08d,	0xeaff, 0xc08d,		0x21, 0
	.dw 0xeb40, 0xc08d,	0xeb7f, 0xc08d,		0x21, 0
	.dw 0xebc0, 0xc08d,	0xebff, 0xc08d,		0x21, 0
	.dw 0xec40, 0xc08d,	0xec7f, 0xc08d,		0x21, 0
	.dw 0xecc0, 0xc08d,	0xecff, 0xc08d,		0x21, 0
	.dw 0xed40, 0xc08d,	0xed7f, 0xc08d,		0x21, 0
	.dw 0xedc0, 0xc08d,	0xedff, 0xc08d,		0x21, 0
	.dw 0xee40, 0xc08d,	0xee7f, 0xc08d,		0x21, 0
	.dw 0xeec0, 0xc08d,	0xeeff, 0xc08d,		0x21, 0
	.dw 0xef40, 0xc08d,	0xef7f, 0xc08d,		0x21, 0
	.dw 0xefc0, 0xc08d,	0xefff, 0xc08d,		0x21, 0
	.dw 0xf040, 0xc08d,	0xf07f, 0xc08d,		0x21, 0
	.dw 0xf0c0, 0xc08d,	0xf0ff, 0xc08d,		0x21, 0
	.dw 0xf140, 0xc08d,	0xf17f, 0xc08d,		0x21, 0
	.dw 0xf1c0, 0xc08d,	0xf1ff, 0xc08d,		0x21, 0
	.dw 0xf240, 0xc08d,	0xf27f, 0xc08d,		0x21, 0
	.dw 0xf2c0, 0xc08d,	0xf2ff, 0xc08d,		0x21, 0
	.dw 0xf340, 0xc08d,	0xf37f, 0xc08d,		0x21, 0
	.dw 0xf3c0, 0xc08d,	0xf3ff, 0xc08d,		0x21, 0
	.dw 0xf440, 0xc08d,	0xf47f, 0xc08d,		0x21, 0
	.dw 0xf4c0, 0xc08d,	0xf4ff, 0xc08d,		0x21, 0
	.dw 0xf540, 0xc08d,	0xf57f, 0xc08d,		0x21, 0
	.dw 0xf5c0, 0xc08d,	0xf5ff, 0xc08d,		0x21, 0
	.dw 0xf640, 0xc08d,	0xf67f, 0xc08d,		0x21, 0
	.dw 0xf6c0, 0xc08d,	0xf6ff, 0xc08d,		0x21, 0
	.dw 0xf740, 0xc08d,	0xf77f, 0xc08d,		0x21, 0
	.dw 0xf7c0, 0xc08d,	0xf7ff, 0xc08d,		0x21, 0
	.dw 0xf840, 0xc08d,	0xf87f, 0xc08d,		0x21, 0
	.dw 0xf8c0, 0xc08d,	0xf8ff, 0xc08d,		0x21, 0
	.dw 0xf940, 0xc08d,	0xf97f, 0xc08d,		0x21, 0
	.dw 0xf9c0, 0xc08d,	0xffff, 0xc08d,		0x21, 0
	.dw 0x0040, 0xc08e,	0x007f, 0xc08e,		0x21, 0
	.dw 0x00c0, 0xc08e,	0x00ff, 0xc08e,		0x21, 0
	.dw 0x0140, 0xc08e,	0x017f, 0xc08e,		0x21, 0
	.dw 0x01c0, 0xc08e,	0x01ff, 0xc08e,		0x21, 0
	.dw 0x0240, 0xc08e,	0x027f, 0xc08e,		0x21, 0
	.dw 0x02c0, 0xc08e,	0x02ff, 0xc08e,		0x21, 0
	.dw 0x0340, 0xc08e,	0x037f, 0xc08e,		0x21, 0
	.dw 0x03c0, 0xc08e,	0x03ff, 0xc08e,		0x21, 0
	.dw 0x0440, 0xc08e,	0x047f, 0xc08e,		0x21, 0
	.dw 0x04c0, 0xc08e,	0x04ff, 0xc08e,		0x21, 0
	.dw 0x0540, 0xc08e,	0x057f, 0xc08e,		0x21, 0
	.dw 0x05c0, 0xc08e,	0x05ff, 0xc08e,		0x21, 0
	.dw 0x0640, 0xc08e,	0x067f, 0xc08e,		0x21, 0
	.dw 0x06c0, 0xc08e,	0x06ff, 0xc08e,		0x21, 0
	.dw 0x0740, 0xc08e,	0x077f, 0xc08e,		0x21, 0
	.dw 0x07c0, 0xc08e,	0x07ff, 0xc08e,		0x21, 0
	.dw 0x0840, 0xc08e,	0x087f, 0xc08e,		0x21, 0
	.dw 0x08c0, 0xc08e,	0x08ff, 0xc08e,		0x21, 0
	.dw 0x0940, 0xc08e,	0x097f, 0xc08e,		0x21, 0
	.dw 0x09c0, 0xc08e,	0x09ff, 0xc08e,		0x21, 0
	.dw 0x0a40, 0xc08e,	0x0a7f, 0xc08e,		0x21, 0
	.dw 0x0ac0, 0xc08e,	0x0aff, 0xc08e,		0x21, 0
	.dw 0x0b40, 0xc08e,	0x0b7f, 0xc08e,		0x21, 0
	.dw 0x0bc0, 0xc08e,	0x0bff, 0xc08e,		0x21, 0
	.dw 0x0c40, 0xc08e,	0x0c7f, 0xc08e,		0x21, 0
	.dw 0x0cc0, 0xc08e,	0x0cff, 0xc08e,		0x21, 0
	.dw 0x0d40, 0xc08e,	0x0d7f, 0xc08e,		0x21, 0
	.dw 0x0dc0, 0xc08e,	0x0dff, 0xc08e,		0x21, 0
	.dw 0x0e40, 0xc08e,	0x0e7f, 0xc08e,		0x21, 0
	.dw 0x0ec0, 0xc08e,	0x0eff, 0xc08e,		0x21, 0
	.dw 0x0f40, 0xc08e,	0x0f7f, 0xc08e,		0x21, 0
	.dw 0x0fc0, 0xc08e,	0x0fff, 0xc08e,		0x21, 0
	.dw 0x1040, 0xc08e,	0x107f, 0xc08e,		0x21, 0
	.dw 0x10c0, 0xc08e,	0x10ff, 0xc08e,		0x21, 0
	.dw 0x1140, 0xc08e,	0x117f, 0xc08e,		0x21, 0
	.dw 0x11c0, 0xc08e,	0x11ff, 0xc08e,		0x21, 0
	.dw 0x1240, 0xc08e,	0x127f, 0xc08e,		0x21, 0
	.dw 0x12c0, 0xc08e,	0x12ff, 0xc08e,		0x21, 0
	.dw 0x1340, 0xc08e,	0x137f, 0xc08e,		0x21, 0
	.dw 0x13c0, 0xc08e,	0x13ff, 0xc08e,		0x21, 0
	.dw 0x1440, 0xc08e,	0x147f, 0xc08e,		0x21, 0
	.dw 0x14c0, 0xc08e,	0x14ff, 0xc08e,		0x21, 0
	.dw 0x1540, 0xc08e,	0x157f, 0xc08e,		0x21, 0
	.dw 0x15c0, 0xc08e,	0x15ff, 0xc08e,		0x21, 0
	.dw 0x1640, 0xc08e,	0x167f, 0xc08e,		0x21, 0
	.dw 0x16c0, 0xc08e,	0x16ff, 0xc08e,		0x21, 0
	.dw 0x1740, 0xc08e,	0x177f, 0xc08e,		0x21, 0
	.dw 0x17c0, 0xc08e,	0x17ff, 0xc08e,		0x21, 0
	.dw 0x1840, 0xc08e,	0x187f, 0xc08e,		0x21, 0
	.dw 0x18c0, 0xc08e,	0x18ff, 0xc08e,		0x21, 0
	.dw 0x1940, 0xc08e,	0x197f, 0xc08e,		0x21, 0
	.dw 0x19c0, 0xc08e,	0x1fff, 0xc08e,		0x21, 0
	.dw 0x2040, 0xc08e,	0x207f, 0xc08e,		0x21, 0
	.dw 0x20c0, 0xc08e,	0x20ff, 0xc08e,		0x21, 0
	.dw 0x2140, 0xc08e,	0x217f, 0xc08e,		0x21, 0
	.dw 0x21c0, 0xc08e,	0x21ff, 0xc08e,		0x21, 0
	.dw 0x2240, 0xc08e,	0x227f, 0xc08e,		0x21, 0
	.dw 0x22c0, 0xc08e,	0x22ff, 0xc08e,		0x21, 0
	.dw 0x2340, 0xc08e,	0x237f, 0xc08e,		0x21, 0
	.dw 0x23c0, 0xc08e,	0x23ff, 0xc08e,		0x21, 0
	.dw 0x2440, 0xc08e,	0x247f, 0xc08e,		0x21, 0
	.dw 0x24c0, 0xc08e,	0x24ff, 0xc08e,		0x21, 0
	.dw 0x2540, 0xc08e,	0x257f, 0xc08e,		0x21, 0
	.dw 0x25c0, 0xc08e,	0x25ff, 0xc08e,		0x21, 0
	.dw 0x2640, 0xc08e,	0x267f, 0xc08e,		0x21, 0
	.dw 0x26c0, 0xc08e,	0x26ff, 0xc08e,		0x21, 0
	.dw 0x2740, 0xc08e,	0x277f, 0xc08e,		0x21, 0
	.dw 0x27c0, 0xc08e,	0x27ff, 0xc08e,		0x21, 0
	.dw 0x2840, 0xc08e,	0x287f, 0xc08e,		0x21, 0
	.dw 0x28c0, 0xc08e,	0x28ff, 0xc08e,		0x21, 0
	.dw 0x2940, 0xc08e,	0x297f, 0xc08e,		0x21, 0
	.dw 0x29c0, 0xc08e,	0x29ff, 0xc08e,		0x21, 0
	.dw 0x2a40, 0xc08e,	0x2a7f, 0xc08e,		0x21, 0
	.dw 0x2ac0, 0xc08e,	0x2aff, 0xc08e,		0x21, 0
	.dw 0x2b40, 0xc08e,	0x2b7f, 0xc08e,		0x21, 0
	.dw 0x2bc0, 0xc08e,	0x2bff, 0xc08e,		0x21, 0
	.dw 0x2c40, 0xc08e,	0x2c7f, 0xc08e,		0x21, 0
	.dw 0x2cc0, 0xc08e,	0x2cff, 0xc08e,		0x21, 0
	.dw 0x2d40, 0xc08e,	0x2d7f, 0xc08e,		0x21, 0
	.dw 0x2dc0, 0xc08e,	0x2dff, 0xc08e,		0x21, 0
	.dw 0x2e40, 0xc08e,	0x2e7f, 0xc08e,		0x21, 0
	.dw 0x2ec0, 0xc08e,	0x2eff, 0xc08e,		0x21, 0
	.dw 0x2f40, 0xc08e,	0x2f7f, 0xc08e,		0x21, 0
	.dw 0x2fc0, 0xc08e,	0x2fff, 0xc08e,		0x21, 0
	.dw 0x3040, 0xc08e,	0x307f, 0xc08e,		0x21, 0
	.dw 0x30c0, 0xc08e,	0x30ff, 0xc08e,		0x21, 0
	.dw 0x3140, 0xc08e,	0x317f, 0xc08e,		0x21, 0
	.dw 0x31c0, 0xc08e,	0x31ff, 0xc08e,		0x21, 0
	.dw 0x3240, 0xc08e,	0x327f, 0xc08e,		0x21, 0
	.dw 0x32c0, 0xc08e,	0x32ff, 0xc08e,		0x21, 0
	.dw 0x3340, 0xc08e,	0x337f, 0xc08e,		0x21, 0
	.dw 0x33c0, 0xc08e,	0x33ff, 0xc08e,		0x21, 0
	.dw 0x3440, 0xc08e,	0x347f, 0xc08e,		0x21, 0
	.dw 0x34c0, 0xc08e,	0x34ff, 0xc08e,		0x21, 0
	.dw 0x3540, 0xc08e,	0x357f, 0xc08e,		0x21, 0
	.dw 0x35c0, 0xc08e,	0x35ff, 0xc08e,		0x21, 0
	.dw 0x3640, 0xc08e,	0x367f, 0xc08e,		0x21, 0
	.dw 0x36c0, 0xc08e,	0x36ff, 0xc08e,		0x21, 0
	.dw 0x3740, 0xc08e,	0x377f, 0xc08e,		0x21, 0
	.dw 0x37c0, 0xc08e,	0x37ff, 0xc08e,		0x21, 0
	.dw 0x3840, 0xc08e,	0x387f, 0xc08e,		0x21, 0
	.dw 0x38c0, 0xc08e,	0x38ff, 0xc08e,		0x21, 0
	.dw 0x3940, 0xc08e,	0x397f, 0xc08e,		0x21, 0
	.dw 0x39c0, 0xc08e,	0x3fff, 0xc08e,		0x21, 0
	.dw 0x4040, 0xc08e,	0x407f, 0xc08e,		0x21, 0
	.dw 0x40c0, 0xc08e,	0x40ff, 0xc08e,		0x21, 0
	.dw 0x4140, 0xc08e,	0x417f, 0xc08e,		0x21, 0
	.dw 0x41c0, 0xc08e,	0x41ff, 0xc08e,		0x21, 0
	.dw 0x4240, 0xc08e,	0x427f, 0xc08e,		0x21, 0
	.dw 0x42c0, 0xc08e,	0x42ff, 0xc08e,		0x21, 0
	.dw 0x4340, 0xc08e,	0x437f, 0xc08e,		0x21, 0
	.dw 0x43c0, 0xc08e,	0x43ff, 0xc08e,		0x21, 0
	.dw 0x4440, 0xc08e,	0x447f, 0xc08e,		0x21, 0
	.dw 0x44c0, 0xc08e,	0x44ff, 0xc08e,		0x21, 0
	.dw 0x4540, 0xc08e,	0x457f, 0xc08e,		0x21, 0
	.dw 0x45c0, 0xc08e,	0x45ff, 0xc08e,		0x21, 0
	.dw 0x4640, 0xc08e,	0x467f, 0xc08e,		0x21, 0
	.dw 0x46c0, 0xc08e,	0x46ff, 0xc08e,		0x21, 0
	.dw 0x4740, 0xc08e,	0x477f, 0xc08e,		0x21, 0
	.dw 0x47c0, 0xc08e,	0x47ff, 0xc08e,		0x21, 0
	.dw 0x4840, 0xc08e,	0x487f, 0xc08e,		0x21, 0
	.dw 0x48c0, 0xc08e,	0x48ff, 0xc08e,		0x21, 0
	.dw 0x4940, 0xc08e,	0x497f, 0xc08e,		0x21, 0
	.dw 0x49c0, 0xc08e,	0x49ff, 0xc08e,		0x21, 0
	.dw 0x4a40, 0xc08e,	0x4a7f, 0xc08e,		0x21, 0
	.dw 0x4ac0, 0xc08e,	0x4aff, 0xc08e,		0x21, 0
	.dw 0x4b40, 0xc08e,	0x4b7f, 0xc08e,		0x21, 0
	.dw 0x4bc0, 0xc08e,	0x4bff, 0xc08e,		0x21, 0
	.dw 0x4c40, 0xc08e,	0x4c7f, 0xc08e,		0x21, 0
	.dw 0x4cc0, 0xc08e,	0x4cff, 0xc08e,		0x21, 0
	.dw 0x4d40, 0xc08e,	0x4d7f, 0xc08e,		0x21, 0
	.dw 0x4dc0, 0xc08e,	0x4dff, 0xc08e,		0x21, 0
	.dw 0x4e40, 0xc08e,	0x4e7f, 0xc08e,		0x21, 0
	.dw 0x4ec0, 0xc08e,	0x4eff, 0xc08e,		0x21, 0
	.dw 0x4f40, 0xc08e,	0x4f7f, 0xc08e,		0x21, 0
	.dw 0x4fc0, 0xc08e,	0x4fff, 0xc08e,		0x21, 0
	.dw 0x5040, 0xc08e,	0x507f, 0xc08e,		0x21, 0
	.dw 0x50c0, 0xc08e,	0x50ff, 0xc08e,		0x21, 0
	.dw 0x5140, 0xc08e,	0x517f, 0xc08e,		0x21, 0
	.dw 0x51c0, 0xc08e,	0x51ff, 0xc08e,		0x21, 0
	.dw 0x5240, 0xc08e,	0x527f, 0xc08e,		0x21, 0
	.dw 0x52c0, 0xc08e,	0x52ff, 0xc08e,		0x21, 0
	.dw 0x5340, 0xc08e,	0x537f, 0xc08e,		0x21, 0
	.dw 0x53c0, 0xc08e,	0x53ff, 0xc08e,		0x21, 0
	.dw 0x5440, 0xc08e,	0x547f, 0xc08e,		0x21, 0
	.dw 0x54c0, 0xc08e,	0x54ff, 0xc08e,		0x21, 0
	.dw 0x5540, 0xc08e,	0x557f, 0xc08e,		0x21, 0
	.dw 0x55c0, 0xc08e,	0x55ff, 0xc08e,		0x21, 0
	.dw 0x5640, 0xc08e,	0x567f, 0xc08e,		0x21, 0
	.dw 0x56c0, 0xc08e,	0x56ff, 0xc08e,		0x21, 0
	.dw 0x5740, 0xc08e,	0x577f, 0xc08e,		0x21, 0
	.dw 0x57c0, 0xc08e,	0x57ff, 0xc08e,		0x21, 0
	.dw 0x5840, 0xc08e,	0x587f, 0xc08e,		0x21, 0
	.dw 0x58c0, 0xc08e,	0x58ff, 0xc08e,		0x21, 0
	.dw 0x5940, 0xc08e,	0x597f, 0xc08e,		0x21, 0
	.dw 0x59c0, 0xc08e,	0x5fff, 0xc08e,		0x21, 0
	.dw 0x6040, 0xc08e,	0x607f, 0xc08e,		0x21, 0
	.dw 0x60c0, 0xc08e,	0x60ff, 0xc08e,		0x21, 0
	.dw 0x6140, 0xc08e,	0x617f, 0xc08e,		0x21, 0
	.dw 0x61c0, 0xc08e,	0x61ff, 0xc08e,		0x21, 0
	.dw 0x6240, 0xc08e,	0x627f, 0xc08e,		0x21, 0
	.dw 0x62c0, 0xc08e,	0x62ff, 0xc08e,		0x21, 0
	.dw 0x6340, 0xc08e,	0x637f, 0xc08e,		0x21, 0
	.dw 0x63c0, 0xc08e,	0x63ff, 0xc08e,		0x21, 0
	.dw 0x6440, 0xc08e,	0x647f, 0xc08e,		0x21, 0
	.dw 0x64c0, 0xc08e,	0x64ff, 0xc08e,		0x21, 0
	.dw 0x6540, 0xc08e,	0x657f, 0xc08e,		0x21, 0
	.dw 0x65c0, 0xc08e,	0x65ff, 0xc08e,		0x21, 0
	.dw 0x6640, 0xc08e,	0x667f, 0xc08e,		0x21, 0
	.dw 0x66c0, 0xc08e,	0x66ff, 0xc08e,		0x21, 0
	.dw 0x6740, 0xc08e,	0x677f, 0xc08e,		0x21, 0
	.dw 0x67c0, 0xc08e,	0x67ff, 0xc08e,		0x21, 0
	.dw 0x6840, 0xc08e,	0x687f, 0xc08e,		0x21, 0
	.dw 0x68c0, 0xc08e,	0x68ff, 0xc08e,		0x21, 0
	.dw 0x6940, 0xc08e,	0x697f, 0xc08e,		0x21, 0
	.dw 0x69c0, 0xc08e,	0x69ff, 0xc08e,		0x21, 0
	.dw 0x6a40, 0xc08e,	0x6a7f, 0xc08e,		0x21, 0
	.dw 0x6ac0, 0xc08e,	0x6aff, 0xc08e,		0x21, 0
	.dw 0x6b40, 0xc08e,	0x6b7f, 0xc08e,		0x21, 0
	.dw 0x6bc0, 0xc08e,	0x6bff, 0xc08e,		0x21, 0
	.dw 0x6c40, 0xc08e,	0x6c7f, 0xc08e,		0x21, 0
	.dw 0x6cc0, 0xc08e,	0x6cff, 0xc08e,		0x21, 0
	.dw 0x6d40, 0xc08e,	0x6d7f, 0xc08e,		0x21, 0
	.dw 0x6dc0, 0xc08e,	0x6dff, 0xc08e,		0x21, 0
	.dw 0x6e40, 0xc08e,	0x6e7f, 0xc08e,		0x21, 0
	.dw 0x6ec0, 0xc08e,	0x6eff, 0xc08e,		0x21, 0
	.dw 0x6f40, 0xc08e,	0x6f7f, 0xc08e,		0x21, 0
	.dw 0x6fc0, 0xc08e,	0x6fff, 0xc08e,		0x21, 0
	.dw 0x7040, 0xc08e,	0x707f, 0xc08e,		0x21, 0
	.dw 0x70c0, 0xc08e,	0x70ff, 0xc08e,		0x21, 0
	.dw 0x7140, 0xc08e,	0x717f, 0xc08e,		0x21, 0
	.dw 0x71c0, 0xc08e,	0x71ff, 0xc08e,		0x21, 0
	.dw 0x7240, 0xc08e,	0x727f, 0xc08e,		0x21, 0
	.dw 0x72c0, 0xc08e,	0x72ff, 0xc08e,		0x21, 0
	.dw 0x7340, 0xc08e,	0x737f, 0xc08e,		0x21, 0
	.dw 0x73c0, 0xc08e,	0x73ff, 0xc08e,		0x21, 0
	.dw 0x7440, 0xc08e,	0x747f, 0xc08e,		0x21, 0
	.dw 0x74c0, 0xc08e,	0x74ff, 0xc08e,		0x21, 0
	.dw 0x7540, 0xc08e,	0x757f, 0xc08e,		0x21, 0
	.dw 0x75c0, 0xc08e,	0x75ff, 0xc08e,		0x21, 0
	.dw 0x7640, 0xc08e,	0x767f, 0xc08e,		0x21, 0
	.dw 0x76c0, 0xc08e,	0x76ff, 0xc08e,		0x21, 0
	.dw 0x7740, 0xc08e,	0x777f, 0xc08e,		0x21, 0
	.dw 0x77c0, 0xc08e,	0x77ff, 0xc08e,		0x21, 0
	.dw 0x7840, 0xc08e,	0x787f, 0xc08e,		0x21, 0
	.dw 0x78c0, 0xc08e,	0x78ff, 0xc08e,		0x21, 0
	.dw 0x7940, 0xc08e,	0x797f, 0xc08e,		0x21, 0
	.dw 0x79c0, 0xc08e,	0x7fff, 0xc08e,		0x21, 0
	.dw 0x8040, 0xc08e,	0x807f, 0xc08e,		0x21, 0
	.dw 0x80c0, 0xc08e,	0x80ff, 0xc08e,		0x21, 0
	.dw 0x8140, 0xc08e,	0x817f, 0xc08e,		0x21, 0
	.dw 0x81c0, 0xc08e,	0x81ff, 0xc08e,		0x21, 0
	.dw 0x8240, 0xc08e,	0x827f, 0xc08e,		0x21, 0
	.dw 0x82c0, 0xc08e,	0x82ff, 0xc08e,		0x21, 0
	.dw 0x8340, 0xc08e,	0x837f, 0xc08e,		0x21, 0
	.dw 0x83c0, 0xc08e,	0x83ff, 0xc08e,		0x21, 0
	.dw 0x8440, 0xc08e,	0x847f, 0xc08e,		0x21, 0
	.dw 0x84c0, 0xc08e,	0x84ff, 0xc08e,		0x21, 0
	.dw 0x8540, 0xc08e,	0x857f, 0xc08e,		0x21, 0
	.dw 0x85c0, 0xc08e,	0x85ff, 0xc08e,		0x21, 0
	.dw 0x8640, 0xc08e,	0x867f, 0xc08e,		0x21, 0
	.dw 0x86c0, 0xc08e,	0x86ff, 0xc08e,		0x21, 0
	.dw 0x8740, 0xc08e,	0x877f, 0xc08e,		0x21, 0
	.dw 0x87c0, 0xc08e,	0x87ff, 0xc08e,		0x21, 0
	.dw 0x8840, 0xc08e,	0x887f, 0xc08e,		0x21, 0
	.dw 0x88c0, 0xc08e,	0x88ff, 0xc08e,		0x21, 0
	.dw 0x8940, 0xc08e,	0x897f, 0xc08e,		0x21, 0
	.dw 0x89c0, 0xc08e,	0x89ff, 0xc08e,		0x21, 0
	.dw 0x8a40, 0xc08e,	0x8a7f, 0xc08e,		0x21, 0
	.dw 0x8ac0, 0xc08e,	0x8aff, 0xc08e,		0x21, 0
	.dw 0x8b40, 0xc08e,	0x8b7f, 0xc08e,		0x21, 0
	.dw 0x8bc0, 0xc08e,	0x8bff, 0xc08e,		0x21, 0
	.dw 0x8c40, 0xc08e,	0x8c7f, 0xc08e,		0x21, 0
	.dw 0x8cc0, 0xc08e,	0x8cff, 0xc08e,		0x21, 0
	.dw 0x8d40, 0xc08e,	0x8d7f, 0xc08e,		0x21, 0
	.dw 0x8dc0, 0xc08e,	0x8dff, 0xc08e,		0x21, 0
	.dw 0x8e40, 0xc08e,	0x8e7f, 0xc08e,		0x21, 0
	.dw 0x8ec0, 0xc08e,	0x8eff, 0xc08e,		0x21, 0
	.dw 0x8f40, 0xc08e,	0x8f7f, 0xc08e,		0x21, 0
	.dw 0x8fc0, 0xc08e,	0x8fff, 0xc08e,		0x21, 0
	.dw 0x9040, 0xc08e,	0x907f, 0xc08e,		0x21, 0
	.dw 0x90c0, 0xc08e,	0x90ff, 0xc08e,		0x21, 0
	.dw 0x9140, 0xc08e,	0x917f, 0xc08e,		0x21, 0
	.dw 0x91c0, 0xc08e,	0x91ff, 0xc08e,		0x21, 0
	.dw 0x9240, 0xc08e,	0x927f, 0xc08e,		0x21, 0
	.dw 0x92c0, 0xc08e,	0x92ff, 0xc08e,		0x21, 0
	.dw 0x9340, 0xc08e,	0x937f, 0xc08e,		0x21, 0
	.dw 0x93c0, 0xc08e,	0x93ff, 0xc08e,		0x21, 0
	.dw 0x9440, 0xc08e,	0x947f, 0xc08e,		0x21, 0
	.dw 0x94c0, 0xc08e,	0x94ff, 0xc08e,		0x21, 0
	.dw 0x9540, 0xc08e,	0x957f, 0xc08e,		0x21, 0
	.dw 0x95c0, 0xc08e,	0x95ff, 0xc08e,		0x21, 0
	.dw 0x9640, 0xc08e,	0x967f, 0xc08e,		0x21, 0
	.dw 0x96c0, 0xc08e,	0x96ff, 0xc08e,		0x21, 0
	.dw 0x9740, 0xc08e,	0x977f, 0xc08e,		0x21, 0
	.dw 0x97c0, 0xc08e,	0x97ff, 0xc08e,		0x21, 0
	.dw 0x9840, 0xc08e,	0x987f, 0xc08e,		0x21, 0
	.dw 0x98c0, 0xc08e,	0x98ff, 0xc08e,		0x21, 0
	.dw 0x9940, 0xc08e,	0x997f, 0xc08e,		0x21, 0
	.dw 0x99c0, 0xc08e,	0x9fff, 0xc08e,		0x21, 0
	.dw 0xa040, 0xc08e,	0xa07f, 0xc08e,		0x21, 0
	.dw 0xa0c0, 0xc08e,	0xa0ff, 0xc08e,		0x21, 0
	.dw 0xa140, 0xc08e,	0xa17f, 0xc08e,		0x21, 0
	.dw 0xa1c0, 0xc08e,	0xa1ff, 0xc08e,		0x21, 0
	.dw 0xa240, 0xc08e,	0xa27f, 0xc08e,		0x21, 0
	.dw 0xa2c0, 0xc08e,	0xa2ff, 0xc08e,		0x21, 0
	.dw 0xa340, 0xc08e,	0xa37f, 0xc08e,		0x21, 0
	.dw 0xa3c0, 0xc08e,	0xa3ff, 0xc08e,		0x21, 0
	.dw 0xa440, 0xc08e,	0xa47f, 0xc08e,		0x21, 0
	.dw 0xa4c0, 0xc08e,	0xa4ff, 0xc08e,		0x21, 0
	.dw 0xa540, 0xc08e,	0xa57f, 0xc08e,		0x21, 0
	.dw 0xa5c0, 0xc08e,	0xa5ff, 0xc08e,		0x21, 0
	.dw 0xa640, 0xc08e,	0xa67f, 0xc08e,		0x21, 0
	.dw 0xa6c0, 0xc08e,	0xa6ff, 0xc08e,		0x21, 0
	.dw 0xa740, 0xc08e,	0xa77f, 0xc08e,		0x21, 0
	.dw 0xa7c0, 0xc08e,	0xa7ff, 0xc08e,		0x21, 0
	.dw 0xa840, 0xc08e,	0xa87f, 0xc08e,		0x21, 0
	.dw 0xa8c0, 0xc08e,	0xa8ff, 0xc08e,		0x21, 0
	.dw 0xa940, 0xc08e,	0xa97f, 0xc08e,		0x21, 0
	.dw 0xa9c0, 0xc08e,	0xa9ff, 0xc08e,		0x21, 0
	.dw 0xaa40, 0xc08e,	0xaa7f, 0xc08e,		0x21, 0
	.dw 0xaac0, 0xc08e,	0xaaff, 0xc08e,		0x21, 0
	.dw 0xab40, 0xc08e,	0xab7f, 0xc08e,		0x21, 0
	.dw 0xabc0, 0xc08e,	0xabff, 0xc08e,		0x21, 0
	.dw 0xac40, 0xc08e,	0xac7f, 0xc08e,		0x21, 0
	.dw 0xacc0, 0xc08e,	0xacff, 0xc08e,		0x21, 0
	.dw 0xad40, 0xc08e,	0xad7f, 0xc08e,		0x21, 0
	.dw 0xadc0, 0xc08e,	0xadff, 0xc08e,		0x21, 0
	.dw 0xae40, 0xc08e,	0xae7f, 0xc08e,		0x21, 0
	.dw 0xaec0, 0xc08e,	0xaeff, 0xc08e,		0x21, 0
	.dw 0xaf40, 0xc08e,	0xaf7f, 0xc08e,		0x21, 0
	.dw 0xafc0, 0xc08e,	0xafff, 0xc08e,		0x21, 0
	.dw 0xb040, 0xc08e,	0xb07f, 0xc08e,		0x21, 0
	.dw 0xb0c0, 0xc08e,	0xb0ff, 0xc08e,		0x21, 0
	.dw 0xb140, 0xc08e,	0xb17f, 0xc08e,		0x21, 0
	.dw 0xb1c0, 0xc08e,	0xb1ff, 0xc08e,		0x21, 0
	.dw 0xb240, 0xc08e,	0xb27f, 0xc08e,		0x21, 0
	.dw 0xb2c0, 0xc08e,	0xb2ff, 0xc08e,		0x21, 0
	.dw 0xb340, 0xc08e,	0xb37f, 0xc08e,		0x21, 0
	.dw 0xb3c0, 0xc08e,	0xb3ff, 0xc08e,		0x21, 0
	.dw 0xb440, 0xc08e,	0xb47f, 0xc08e,		0x21, 0
	.dw 0xb4c0, 0xc08e,	0xb4ff, 0xc08e,		0x21, 0
	.dw 0xb540, 0xc08e,	0xb57f, 0xc08e,		0x21, 0
	.dw 0xb5c0, 0xc08e,	0xb5ff, 0xc08e,		0x21, 0
	.dw 0xb640, 0xc08e,	0xb67f, 0xc08e,		0x21, 0
	.dw 0xb6c0, 0xc08e,	0xb6ff, 0xc08e,		0x21, 0
	.dw 0xb740, 0xc08e,	0xb77f, 0xc08e,		0x21, 0
	.dw 0xb7c0, 0xc08e,	0xb7ff, 0xc08e,		0x21, 0
	.dw 0xb840, 0xc08e,	0xb87f, 0xc08e,		0x21, 0
	.dw 0xb8c0, 0xc08e,	0xb8ff, 0xc08e,		0x21, 0
	.dw 0xb940, 0xc08e,	0xb97f, 0xc08e,		0x21, 0
	.dw 0xb9c0, 0xc08e,	0xbfff, 0xc08e,		0x21, 0
	.dw 0xc040, 0xc08e,	0xc07f, 0xc08e,		0x21, 0
	.dw 0xc0c0, 0xc08e,	0xc0ff, 0xc08e,		0x21, 0
	.dw 0xc140, 0xc08e,	0xc17f, 0xc08e,		0x21, 0
	.dw 0xc1c0, 0xc08e,	0xc1ff, 0xc08e,		0x21, 0
	.dw 0xc240, 0xc08e,	0xc27f, 0xc08e,		0x21, 0
	.dw 0xc2c0, 0xc08e,	0xc2ff, 0xc08e,		0x21, 0
	.dw 0xc340, 0xc08e,	0xc37f, 0xc08e,		0x21, 0
	.dw 0xc3c0, 0xc08e,	0xc3ff, 0xc08e,		0x21, 0
	.dw 0xc440, 0xc08e,	0xc47f, 0xc08e,		0x21, 0
	.dw 0xc4c0, 0xc08e,	0xc4ff, 0xc08e,		0x21, 0
	.dw 0xc540, 0xc08e,	0xc57f, 0xc08e,		0x21, 0
	.dw 0xc5c0, 0xc08e,	0xc5ff, 0xc08e,		0x21, 0
	.dw 0xc640, 0xc08e,	0xc67f, 0xc08e,		0x21, 0
	.dw 0xc6c0, 0xc08e,	0xc6ff, 0xc08e,		0x21, 0
	.dw 0xc740, 0xc08e,	0xc77f, 0xc08e,		0x21, 0
	.dw 0xc7c0, 0xc08e,	0xc7ff, 0xc08e,		0x21, 0
	.dw 0xc840, 0xc08e,	0xc87f, 0xc08e,		0x21, 0
	.dw 0xc8c0, 0xc08e,	0xc8ff, 0xc08e,		0x21, 0
	.dw 0xc940, 0xc08e,	0xc97f, 0xc08e,		0x21, 0
	.dw 0xc9c0, 0xc08e,	0xc9ff, 0xc08e,		0x21, 0
	.dw 0xca40, 0xc08e,	0xca7f, 0xc08e,		0x21, 0
	.dw 0xcac0, 0xc08e,	0xcaff, 0xc08e,		0x21, 0
	.dw 0xcb40, 0xc08e,	0xcb7f, 0xc08e,		0x21, 0
	.dw 0xcbc0, 0xc08e,	0xcbff, 0xc08e,		0x21, 0
	.dw 0xcc40, 0xc08e,	0xcc7f, 0xc08e,		0x21, 0
	.dw 0xccc0, 0xc08e,	0xccff, 0xc08e,		0x21, 0
	.dw 0xcd40, 0xc08e,	0xcd7f, 0xc08e,		0x21, 0
	.dw 0xcdc0, 0xc08e,	0xcdff, 0xc08e,		0x21, 0
	.dw 0xce40, 0xc08e,	0xce7f, 0xc08e,		0x21, 0
	.dw 0xcec0, 0xc08e,	0xceff, 0xc08e,		0x21, 0
	.dw 0xcf40, 0xc08e,	0xcf7f, 0xc08e,		0x21, 0
	.dw 0xcfc0, 0xc08e,	0xcfff, 0xc08e,		0x21, 0
	.dw 0xd040, 0xc08e,	0xd07f, 0xc08e,		0x21, 0
	.dw 0xd0c0, 0xc08e,	0xd0ff, 0xc08e,		0x21, 0
	.dw 0xd140, 0xc08e,	0xd17f, 0xc08e,		0x21, 0
	.dw 0xd1c0, 0xc08e,	0xd1ff, 0xc08e,		0x21, 0
	.dw 0xd240, 0xc08e,	0xd27f, 0xc08e,		0x21, 0
	.dw 0xd2c0, 0xc08e,	0xd2ff, 0xc08e,		0x21, 0
	.dw 0xd340, 0xc08e,	0xd37f, 0xc08e,		0x21, 0
	.dw 0xd3c0, 0xc08e,	0xd3ff, 0xc08e,		0x21, 0
	.dw 0xd440, 0xc08e,	0xd47f, 0xc08e,		0x21, 0
	.dw 0xd4c0, 0xc08e,	0xd4ff, 0xc08e,		0x21, 0
	.dw 0xd540, 0xc08e,	0xd57f, 0xc08e,		0x21, 0
	.dw 0xd5c0, 0xc08e,	0xd5ff, 0xc08e,		0x21, 0
	.dw 0xd640, 0xc08e,	0xd67f, 0xc08e,		0x21, 0
	.dw 0xd6c0, 0xc08e,	0xd6ff, 0xc08e,		0x21, 0
	.dw 0xd740, 0xc08e,	0xd77f, 0xc08e,		0x21, 0
	.dw 0xd7c0, 0xc08e,	0xd7ff, 0xc08e,		0x21, 0
	.dw 0xd840, 0xc08e,	0xd87f, 0xc08e,		0x21, 0
	.dw 0xd8c0, 0xc08e,	0xd8ff, 0xc08e,		0x21, 0
	.dw 0xd940, 0xc08e,	0xd97f, 0xc08e,		0x21, 0
	.dw 0xd9c0, 0xc08e,	0xdfff, 0xc08e,		0x21, 0
	.dw 0xe040, 0xc08e,	0xe07f, 0xc08e,		0x21, 0
	.dw 0xe0c0, 0xc08e,	0xe0ff, 0xc08e,		0x21, 0
	.dw 0xe140, 0xc08e,	0xe17f, 0xc08e,		0x21, 0
	.dw 0xe1c0, 0xc08e,	0xe1ff, 0xc08e,		0x21, 0
	.dw 0xe240, 0xc08e,	0xe27f, 0xc08e,		0x21, 0
	.dw 0xe2c0, 0xc08e,	0xe2ff, 0xc08e,		0x21, 0
	.dw 0xe340, 0xc08e,	0xe37f, 0xc08e,		0x21, 0
	.dw 0xe3c0, 0xc08e,	0xe3ff, 0xc08e,		0x21, 0
	.dw 0xe440, 0xc08e,	0xe47f, 0xc08e,		0x21, 0
	.dw 0xe4c0, 0xc08e,	0xe4ff, 0xc08e,		0x21, 0
	.dw 0xe540, 0xc08e,	0xe57f, 0xc08e,		0x21, 0
	.dw 0xe5c0, 0xc08e,	0xe5ff, 0xc08e,		0x21, 0
	.dw 0xe640, 0xc08e,	0xe67f, 0xc08e,		0x21, 0
	.dw 0xe6c0, 0xc08e,	0xe6ff, 0xc08e,		0x21, 0
	.dw 0xe740, 0xc08e,	0xe77f, 0xc08e,		0x21, 0
	.dw 0xe7c0, 0xc08e,	0xe7ff, 0xc08e,		0x21, 0
	.dw 0xe840, 0xc08e,	0xe87f, 0xc08e,		0x21, 0
	.dw 0xe8c0, 0xc08e,	0xe8ff, 0xc08e,		0x21, 0
	.dw 0xe940, 0xc08e,	0xe97f, 0xc08e,		0x21, 0
	.dw 0xe9c0, 0xc08e,	0xe9ff, 0xc08e,		0x21, 0
	.dw 0xea40, 0xc08e,	0xea7f, 0xc08e,		0x21, 0
	.dw 0xeac0, 0xc08e,	0xeaff, 0xc08e,		0x21, 0
	.dw 0xeb40, 0xc08e,	0xeb7f, 0xc08e,		0x21, 0
	.dw 0xebc0, 0xc08e,	0xebff, 0xc08e,		0x21, 0
	.dw 0xec40, 0xc08e,	0xec7f, 0xc08e,		0x21, 0
	.dw 0xecc0, 0xc08e,	0xecff, 0xc08e,		0x21, 0
	.dw 0xed40, 0xc08e,	0xed7f, 0xc08e,		0x21, 0
	.dw 0xedc0, 0xc08e,	0xedff, 0xc08e,		0x21, 0
	.dw 0xee40, 0xc08e,	0xee7f, 0xc08e,		0x21, 0
	.dw 0xeec0, 0xc08e,	0xeeff, 0xc08e,		0x21, 0
	.dw 0xef40, 0xc08e,	0xef7f, 0xc08e,		0x21, 0
	.dw 0xefc0, 0xc08e,	0xefff, 0xc08e,		0x21, 0
	.dw 0xf040, 0xc08e,	0xf07f, 0xc08e,		0x21, 0
	.dw 0xf0c0, 0xc08e,	0xf0ff, 0xc08e,		0x21, 0
	.dw 0xf140, 0xc08e,	0xf17f, 0xc08e,		0x21, 0
	.dw 0xf1c0, 0xc08e,	0xf1ff, 0xc08e,		0x21, 0
	.dw 0xf240, 0xc08e,	0xf27f, 0xc08e,		0x21, 0
	.dw 0xf2c0, 0xc08e,	0xf2ff, 0xc08e,		0x21, 0
	.dw 0xf340, 0xc08e,	0xf37f, 0xc08e,		0x21, 0
	.dw 0xf3c0, 0xc08e,	0xf3ff, 0xc08e,		0x21, 0
	.dw 0xf440, 0xc08e,	0xf47f, 0xc08e,		0x21, 0
	.dw 0xf4c0, 0xc08e,	0xf4ff, 0xc08e,		0x21, 0
	.dw 0xf540, 0xc08e,	0xf57f, 0xc08e,		0x21, 0
	.dw 0xf5c0, 0xc08e,	0xf5ff, 0xc08e,		0x21, 0
	.dw 0xf640, 0xc08e,	0xf67f, 0xc08e,		0x21, 0
	.dw 0xf6c0, 0xc08e,	0xf6ff, 0xc08e,		0x21, 0
	.dw 0xf740, 0xc08e,	0xf77f, 0xc08e,		0x21, 0
	.dw 0xf7c0, 0xc08e,	0xf7ff, 0xc08e,		0x21, 0
	.dw 0xf840, 0xc08e,	0xf87f, 0xc08e,		0x21, 0
	.dw 0xf8c0, 0xc08e,	0xf8ff, 0xc08e,		0x21, 0
	.dw 0xf940, 0xc08e,	0xf97f, 0xc08e,		0x21, 0
	.dw 0xf9c0, 0xc08e,	0xffff, 0xc08e,		0x21, 0
	.dw 0x0040, 0xc08f,	0x007f, 0xc08f,		0x21, 0
	.dw 0x00c0, 0xc08f,	0x00ff, 0xc08f,		0x21, 0
	.dw 0x0140, 0xc08f,	0x017f, 0xc08f,		0x21, 0
	.dw 0x01c0, 0xc08f,	0x01ff, 0xc08f,		0x21, 0
	.dw 0x0240, 0xc08f,	0x027f, 0xc08f,		0x21, 0
	.dw 0x02c0, 0xc08f,	0x02ff, 0xc08f,		0x21, 0
	.dw 0x0340, 0xc08f,	0x037f, 0xc08f,		0x21, 0
	.dw 0x03c0, 0xc08f,	0x03ff, 0xc08f,		0x21, 0
	.dw 0x0440, 0xc08f,	0x047f, 0xc08f,		0x21, 0
	.dw 0x04c0, 0xc08f,	0x04ff, 0xc08f,		0x21, 0
	.dw 0x0540, 0xc08f,	0x057f, 0xc08f,		0x21, 0
	.dw 0x05c0, 0xc08f,	0x05ff, 0xc08f,		0x21, 0
	.dw 0x0640, 0xc08f,	0x067f, 0xc08f,		0x21, 0
	.dw 0x06c0, 0xc08f,	0x06ff, 0xc08f,		0x21, 0
	.dw 0x0740, 0xc08f,	0x077f, 0xc08f,		0x21, 0
	.dw 0x07c0, 0xc08f,	0x07ff, 0xc08f,		0x21, 0
	.dw 0x0840, 0xc08f,	0x087f, 0xc08f,		0x21, 0
	.dw 0x08c0, 0xc08f,	0x08ff, 0xc08f,		0x21, 0
	.dw 0x0940, 0xc08f,	0x097f, 0xc08f,		0x21, 0
	.dw 0x09c0, 0xc08f,	0x09ff, 0xc08f,		0x21, 0
	.dw 0x0a40, 0xc08f,	0x0a7f, 0xc08f,		0x21, 0
	.dw 0x0ac0, 0xc08f,	0x0aff, 0xc08f,		0x21, 0
	.dw 0x0b40, 0xc08f,	0x0b7f, 0xc08f,		0x21, 0
	.dw 0x0bc0, 0xc08f,	0x0bff, 0xc08f,		0x21, 0
	.dw 0x0c40, 0xc08f,	0x0c7f, 0xc08f,		0x21, 0
	.dw 0x0cc0, 0xc08f,	0x0cff, 0xc08f,		0x21, 0
	.dw 0x0d40, 0xc08f,	0x0d7f, 0xc08f,		0x21, 0
	.dw 0x0dc0, 0xc08f,	0x0dff, 0xc08f,		0x21, 0
	.dw 0x0e40, 0xc08f,	0x0e7f, 0xc08f,		0x21, 0
	.dw 0x0ec0, 0xc08f,	0x0eff, 0xc08f,		0x21, 0
	.dw 0x0f40, 0xc08f,	0x0f7f, 0xc08f,		0x21, 0
	.dw 0x0fc0, 0xc08f,	0x0fff, 0xc08f,		0x21, 0
	.dw 0x1040, 0xc08f,	0x107f, 0xc08f,		0x21, 0
	.dw 0x10c0, 0xc08f,	0x10ff, 0xc08f,		0x21, 0
	.dw 0x1140, 0xc08f,	0x117f, 0xc08f,		0x21, 0
	.dw 0x11c0, 0xc08f,	0x11ff, 0xc08f,		0x21, 0
	.dw 0x1240, 0xc08f,	0x127f, 0xc08f,		0x21, 0
	.dw 0x12c0, 0xc08f,	0x12ff, 0xc08f,		0x21, 0
	.dw 0x1340, 0xc08f,	0x137f, 0xc08f,		0x21, 0
	.dw 0x13c0, 0xc08f,	0x13ff, 0xc08f,		0x21, 0
	.dw 0x1440, 0xc08f,	0x147f, 0xc08f,		0x21, 0
	.dw 0x14c0, 0xc08f,	0x14ff, 0xc08f,		0x21, 0
	.dw 0x1540, 0xc08f,	0x157f, 0xc08f,		0x21, 0
	.dw 0x15c0, 0xc08f,	0x15ff, 0xc08f,		0x21, 0
	.dw 0x1640, 0xc08f,	0x167f, 0xc08f,		0x21, 0
	.dw 0x16c0, 0xc08f,	0x16ff, 0xc08f,		0x21, 0
	.dw 0x1740, 0xc08f,	0x177f, 0xc08f,		0x21, 0
	.dw 0x17c0, 0xc08f,	0x17ff, 0xc08f,		0x21, 0
	.dw 0x1840, 0xc08f,	0x187f, 0xc08f,		0x21, 0
	.dw 0x18c0, 0xc08f,	0x18ff, 0xc08f,		0x21, 0
	.dw 0x1940, 0xc08f,	0x197f, 0xc08f,		0x21, 0
	.dw 0x19c0, 0xc08f,	0x1fff, 0xc08f,		0x21, 0
	.dw 0x2040, 0xc08f,	0x207f, 0xc08f,		0x21, 0
	.dw 0x20c0, 0xc08f,	0x20ff, 0xc08f,		0x21, 0
	.dw 0x2140, 0xc08f,	0x217f, 0xc08f,		0x21, 0
	.dw 0x21c0, 0xc08f,	0x21ff, 0xc08f,		0x21, 0
	.dw 0x2240, 0xc08f,	0x227f, 0xc08f,		0x21, 0
	.dw 0x22c0, 0xc08f,	0x22ff, 0xc08f,		0x21, 0
	.dw 0x2340, 0xc08f,	0x237f, 0xc08f,		0x21, 0
	.dw 0x23c0, 0xc08f,	0x23ff, 0xc08f,		0x21, 0
	.dw 0x2440, 0xc08f,	0x247f, 0xc08f,		0x21, 0
	.dw 0x24c0, 0xc08f,	0x24ff, 0xc08f,		0x21, 0
	.dw 0x2540, 0xc08f,	0x257f, 0xc08f,		0x21, 0
	.dw 0x25c0, 0xc08f,	0x25ff, 0xc08f,		0x21, 0
	.dw 0x2640, 0xc08f,	0x267f, 0xc08f,		0x21, 0
	.dw 0x26c0, 0xc08f,	0x26ff, 0xc08f,		0x21, 0
	.dw 0x2740, 0xc08f,	0x277f, 0xc08f,		0x21, 0
	.dw 0x27c0, 0xc08f,	0x27ff, 0xc08f,		0x21, 0
	.dw 0x2840, 0xc08f,	0x287f, 0xc08f,		0x21, 0
	.dw 0x28c0, 0xc08f,	0x28ff, 0xc08f,		0x21, 0
	.dw 0x2940, 0xc08f,	0x297f, 0xc08f,		0x21, 0
	.dw 0x29c0, 0xc08f,	0x29ff, 0xc08f,		0x21, 0
	.dw 0x2a40, 0xc08f,	0x2a7f, 0xc08f,		0x21, 0
	.dw 0x2ac0, 0xc08f,	0x2aff, 0xc08f,		0x21, 0
	.dw 0x2b40, 0xc08f,	0x2b7f, 0xc08f,		0x21, 0
	.dw 0x2bc0, 0xc08f,	0x2bff, 0xc08f,		0x21, 0
	.dw 0x2c40, 0xc08f,	0x2c7f, 0xc08f,		0x21, 0
	.dw 0x2cc0, 0xc08f,	0x2cff, 0xc08f,		0x21, 0
	.dw 0x2d40, 0xc08f,	0x2d7f, 0xc08f,		0x21, 0
	.dw 0x2dc0, 0xc08f,	0x2dff, 0xc08f,		0x21, 0
	.dw 0x2e40, 0xc08f,	0x2e7f, 0xc08f,		0x21, 0
	.dw 0x2ec0, 0xc08f,	0x2eff, 0xc08f,		0x21, 0
	.dw 0x2f40, 0xc08f,	0x2f7f, 0xc08f,		0x21, 0
	.dw 0x2fc0, 0xc08f,	0x2fff, 0xc08f,		0x21, 0
	.dw 0x3040, 0xc08f,	0x307f, 0xc08f,		0x21, 0
	.dw 0x30c0, 0xc08f,	0x30ff, 0xc08f,		0x21, 0
	.dw 0x3140, 0xc08f,	0x317f, 0xc08f,		0x21, 0
	.dw 0x31c0, 0xc08f,	0x31ff, 0xc08f,		0x21, 0
	.dw 0x3240, 0xc08f,	0x327f, 0xc08f,		0x21, 0
	.dw 0x32c0, 0xc08f,	0x32ff, 0xc08f,		0x21, 0
	.dw 0x3340, 0xc08f,	0x337f, 0xc08f,		0x21, 0
	.dw 0x33c0, 0xc08f,	0x33ff, 0xc08f,		0x21, 0
	.dw 0x3440, 0xc08f,	0x347f, 0xc08f,		0x21, 0
	.dw 0x34c0, 0xc08f,	0x34ff, 0xc08f,		0x21, 0
	.dw 0x3540, 0xc08f,	0x357f, 0xc08f,		0x21, 0
	.dw 0x35c0, 0xc08f,	0x35ff, 0xc08f,		0x21, 0
	.dw 0x3640, 0xc08f,	0x367f, 0xc08f,		0x21, 0
	.dw 0x36c0, 0xc08f,	0x36ff, 0xc08f,		0x21, 0
	.dw 0x3740, 0xc08f,	0x377f, 0xc08f,		0x21, 0
	.dw 0x37c0, 0xc08f,	0x37ff, 0xc08f,		0x21, 0
	.dw 0x3840, 0xc08f,	0x387f, 0xc08f,		0x21, 0
	.dw 0x38c0, 0xc08f,	0x38ff, 0xc08f,		0x21, 0
	.dw 0x3940, 0xc08f,	0x397f, 0xc08f,		0x21, 0
	.dw 0x39c0, 0xc08f,	0xffff, 0xc08f,		0x21, 0
	.dw 0x1a00, 0xc090,	0x1fff, 0xc090,		0x21, 0
	.dw 0x3a00, 0xc090,	0x3fff, 0xc090,		0x21, 0
	.dw 0x5a00, 0xc090,	0x5fff, 0xc090,		0x21, 0
	.dw 0x7a00, 0xc090,	0x7fff, 0xc090,		0x21, 0
	.dw 0x9a00, 0xc090,	0x9fff, 0xc090,		0x21, 0
	.dw 0xba00, 0xc090,	0xbfff, 0xc090,		0x21, 0
	.dw 0xda00, 0xc090,	0xdfff, 0xc090,		0x21, 0
	.dw 0xfa00, 0xc090,	0xffff, 0xc090,		0x21, 0
	.dw 0x1a00, 0xc091,	0x1fff, 0xc091,		0x21, 0
	.dw 0x3a00, 0xc091,	0x3fff, 0xc091,		0x21, 0
	.dw 0x5a00, 0xc091,	0x5fff, 0xc091,		0x21, 0
	.dw 0x7a00, 0xc091,	0x7fff, 0xc091,		0x21, 0
	.dw 0x9a00, 0xc091,	0x9fff, 0xc091,		0x21, 0
	.dw 0xba00, 0xc091,	0xbfff, 0xc091,		0x21, 0
	.dw 0xda00, 0xc091,	0xdfff, 0xc091,		0x21, 0
	.dw 0xfa00, 0xc091,	0xffff, 0xc091,		0x21, 0
	.dw 0x1a00, 0xc092,	0x1fff, 0xc092,		0x21, 0
	.dw 0x3a00, 0xc092,	0x3fff, 0xc092,		0x21, 0
	.dw 0x5a00, 0xc092,	0x5fff, 0xc092,		0x21, 0
	.dw 0x7a00, 0xc092,	0x7fff, 0xc092,		0x21, 0
	.dw 0x9a00, 0xc092,	0x9fff, 0xc092,		0x21, 0
	.dw 0xba00, 0xc092,	0xbfff, 0xc092,		0x21, 0
	.dw 0xda00, 0xc092,	0xdfff, 0xc092,		0x21, 0
	.dw 0xfa00, 0xc092,	0xffff, 0xc093,		0x21, 0
	.dw 0x1a00, 0xc094,	0x1fff, 0xc094,		0x21, 0
	.dw 0x3a00, 0xc094,	0x3fff, 0xc094,		0x21, 0
	.dw 0x5a00, 0xc094,	0x5fff, 0xc094,		0x21, 0
	.dw 0x7a00, 0xc094,	0x7fff, 0xc094,		0x21, 0
	.dw 0x9a00, 0xc094,	0x9fff, 0xc094,		0x21, 0
	.dw 0xba00, 0xc094,	0xbfff, 0xc094,		0x21, 0
	.dw 0xda00, 0xc094,	0xdfff, 0xc094,		0x21, 0
	.dw 0xfa00, 0xc094,	0xffff, 0xc094,		0x21, 0
	.dw 0x1a00, 0xc095,	0x1fff, 0xc095,		0x21, 0
	.dw 0x3a00, 0xc095,	0x3fff, 0xc095,		0x21, 0
	.dw 0x5a00, 0xc095,	0x5fff, 0xc095,		0x21, 0
	.dw 0x7a00, 0xc095,	0x7fff, 0xc095,		0x21, 0
	.dw 0x9a00, 0xc095,	0x9fff, 0xc095,		0x21, 0
	.dw 0xba00, 0xc095,	0xbfff, 0xc095,		0x21, 0
	.dw 0xda00, 0xc095,	0xdfff, 0xc095,		0x21, 0
	.dw 0xfa00, 0xc095,	0xffff, 0xc095,		0x21, 0
	.dw 0x1a00, 0xc096,	0x1fff, 0xc096,		0x21, 0
	.dw 0x3a00, 0xc096,	0x3fff, 0xc096,		0x21, 0
	.dw 0x5a00, 0xc096,	0x5fff, 0xc096,		0x21, 0
	.dw 0x7a00, 0xc096,	0x7fff, 0xc096,		0x21, 0
	.dw 0x9a00, 0xc096,	0x9fff, 0xc096,		0x21, 0
	.dw 0xba00, 0xc096,	0xbfff, 0xc096,		0x21, 0
	.dw 0xda00, 0xc096,	0xdfff, 0xc096,		0x21, 0
	.dw 0xfa00, 0xc096,	0xffff, 0xc096,		0x21, 0
	.dw 0x1a00, 0xc097,	0x1fff, 0xc097,		0x21, 0
	.dw 0x3a00, 0xc097,	0x1fff, 0xc098,		0x21, 0
	.dw 0x2040, 0xc098,	0x207f, 0xc098,		0x21, 0
	.dw 0x20c0, 0xc098,	0x20ff, 0xc098,		0x21, 0
	.dw 0x2140, 0xc098,	0x217f, 0xc098,		0x21, 0
	.dw 0x21c0, 0xc098,	0x21ff, 0xc098,		0x21, 0
	.dw 0x2240, 0xc098,	0x227f, 0xc098,		0x21, 0
	.dw 0x22c0, 0xc098,	0x22ff, 0xc098,		0x21, 0
	.dw 0x2340, 0xc098,	0x237f, 0xc098,		0x21, 0
	.dw 0x23c0, 0xc098,	0x23ff, 0xc098,		0x21, 0
	.dw 0x2440, 0xc098,	0x247f, 0xc098,		0x21, 0
	.dw 0x24c0, 0xc098,	0x24ff, 0xc098,		0x21, 0
	.dw 0x2540, 0xc098,	0x257f, 0xc098,		0x21, 0
	.dw 0x25c0, 0xc098,	0x25ff, 0xc098,		0x21, 0
	.dw 0x2640, 0xc098,	0x267f, 0xc098,		0x21, 0
	.dw 0x26c0, 0xc098,	0x26ff, 0xc098,		0x21, 0
	.dw 0x2740, 0xc098,	0x277f, 0xc098,		0x21, 0
	.dw 0x27c0, 0xc098,	0x27ff, 0xc098,		0x21, 0
	.dw 0x2840, 0xc098,	0x287f, 0xc098,		0x21, 0
	.dw 0x28c0, 0xc098,	0x28ff, 0xc098,		0x21, 0
	.dw 0x2940, 0xc098,	0x297f, 0xc098,		0x21, 0
	.dw 0x29c0, 0xc098,	0x29ff, 0xc098,		0x21, 0
	.dw 0x2a40, 0xc098,	0x2a7f, 0xc098,		0x21, 0
	.dw 0x2ac0, 0xc098,	0x2aff, 0xc098,		0x21, 0
	.dw 0x2b40, 0xc098,	0x2b7f, 0xc098,		0x21, 0
	.dw 0x2bc0, 0xc098,	0x2bff, 0xc098,		0x21, 0
	.dw 0x2c40, 0xc098,	0x2c7f, 0xc098,		0x21, 0
	.dw 0x2cc0, 0xc098,	0x2cff, 0xc098,		0x21, 0
	.dw 0x2d40, 0xc098,	0x2d7f, 0xc098,		0x21, 0
	.dw 0x2dc0, 0xc098,	0x2dff, 0xc098,		0x21, 0
	.dw 0x2e40, 0xc098,	0x2e7f, 0xc098,		0x21, 0
	.dw 0x2ec0, 0xc098,	0x2eff, 0xc098,		0x21, 0
	.dw 0x2f40, 0xc098,	0x2f7f, 0xc098,		0x21, 0
	.dw 0x2fc0, 0xc098,	0x2fff, 0xc098,		0x21, 0
	.dw 0x3040, 0xc098,	0x307f, 0xc098,		0x21, 0
	.dw 0x30c0, 0xc098,	0x30ff, 0xc098,		0x21, 0
	.dw 0x3140, 0xc098,	0x317f, 0xc098,		0x21, 0
	.dw 0x31c0, 0xc098,	0x31ff, 0xc098,		0x21, 0
	.dw 0x3240, 0xc098,	0x327f, 0xc098,		0x21, 0
	.dw 0x32c0, 0xc098,	0x32ff, 0xc098,		0x21, 0
	.dw 0x3340, 0xc098,	0x337f, 0xc098,		0x21, 0
	.dw 0x33c0, 0xc098,	0x33ff, 0xc098,		0x21, 0
	.dw 0x3440, 0xc098,	0x347f, 0xc098,		0x21, 0
	.dw 0x34c0, 0xc098,	0x34ff, 0xc098,		0x21, 0
	.dw 0x3540, 0xc098,	0x357f, 0xc098,		0x21, 0
	.dw 0x35c0, 0xc098,	0x35ff, 0xc098,		0x21, 0
	.dw 0x3640, 0xc098,	0x367f, 0xc098,		0x21, 0
	.dw 0x36c0, 0xc098,	0x36ff, 0xc098,		0x21, 0
	.dw 0x3740, 0xc098,	0x377f, 0xc098,		0x21, 0
	.dw 0x37c0, 0xc098,	0x37ff, 0xc098,		0x21, 0
	.dw 0x3840, 0xc098,	0x387f, 0xc098,		0x21, 0
	.dw 0x38c0, 0xc098,	0x38ff, 0xc098,		0x21, 0
	.dw 0x3940, 0xc098,	0x397f, 0xc098,		0x21, 0
	.dw 0x39c0, 0xc098,	0x5fff, 0xc098,		0x21, 0
	.dw 0x6040, 0xc098,	0x607f, 0xc098,		0x21, 0
	.dw 0x60c0, 0xc098,	0x60ff, 0xc098,		0x21, 0
	.dw 0x6140, 0xc098,	0x617f, 0xc098,		0x21, 0
	.dw 0x61c0, 0xc098,	0x61ff, 0xc098,		0x21, 0
	.dw 0x6240, 0xc098,	0x627f, 0xc098,		0x21, 0
	.dw 0x62c0, 0xc098,	0x62ff, 0xc098,		0x21, 0
	.dw 0x6340, 0xc098,	0x637f, 0xc098,		0x21, 0
	.dw 0x63c0, 0xc098,	0x63ff, 0xc098,		0x21, 0
	.dw 0x6440, 0xc098,	0x647f, 0xc098,		0x21, 0
	.dw 0x64c0, 0xc098,	0x64ff, 0xc098,		0x21, 0
	.dw 0x6540, 0xc098,	0x657f, 0xc098,		0x21, 0
	.dw 0x65c0, 0xc098,	0x65ff, 0xc098,		0x21, 0
	.dw 0x6640, 0xc098,	0x667f, 0xc098,		0x21, 0
	.dw 0x66c0, 0xc098,	0x66ff, 0xc098,		0x21, 0
	.dw 0x6740, 0xc098,	0x677f, 0xc098,		0x21, 0
	.dw 0x67c0, 0xc098,	0x67ff, 0xc098,		0x21, 0
	.dw 0x6840, 0xc098,	0x687f, 0xc098,		0x21, 0
	.dw 0x68c0, 0xc098,	0x68ff, 0xc098,		0x21, 0
	.dw 0x6940, 0xc098,	0x697f, 0xc098,		0x21, 0
	.dw 0x69c0, 0xc098,	0x69ff, 0xc098,		0x21, 0
	.dw 0x6a40, 0xc098,	0x6a7f, 0xc098,		0x21, 0
	.dw 0x6ac0, 0xc098,	0x6aff, 0xc098,		0x21, 0
	.dw 0x6b40, 0xc098,	0x6b7f, 0xc098,		0x21, 0
	.dw 0x6bc0, 0xc098,	0x6bff, 0xc098,		0x21, 0
	.dw 0x6c40, 0xc098,	0x6c7f, 0xc098,		0x21, 0
	.dw 0x6cc0, 0xc098,	0x6cff, 0xc098,		0x21, 0
	.dw 0x6d40, 0xc098,	0x6d7f, 0xc098,		0x21, 0
	.dw 0x6dc0, 0xc098,	0x6dff, 0xc098,		0x21, 0
	.dw 0x6e40, 0xc098,	0x6e7f, 0xc098,		0x21, 0
	.dw 0x6ec0, 0xc098,	0x6eff, 0xc098,		0x21, 0
	.dw 0x6f40, 0xc098,	0x6f7f, 0xc098,		0x21, 0
	.dw 0x6fc0, 0xc098,	0x6fff, 0xc098,		0x21, 0
	.dw 0x7040, 0xc098,	0x707f, 0xc098,		0x21, 0
	.dw 0x70c0, 0xc098,	0x70ff, 0xc098,		0x21, 0
	.dw 0x7140, 0xc098,	0x717f, 0xc098,		0x21, 0
	.dw 0x71c0, 0xc098,	0x71ff, 0xc098,		0x21, 0
	.dw 0x7240, 0xc098,	0x727f, 0xc098,		0x21, 0
	.dw 0x72c0, 0xc098,	0x72ff, 0xc098,		0x21, 0
	.dw 0x7340, 0xc098,	0x737f, 0xc098,		0x21, 0
	.dw 0x73c0, 0xc098,	0x73ff, 0xc098,		0x21, 0
	.dw 0x7440, 0xc098,	0x747f, 0xc098,		0x21, 0
	.dw 0x74c0, 0xc098,	0x74ff, 0xc098,		0x21, 0
	.dw 0x7540, 0xc098,	0x757f, 0xc098,		0x21, 0
	.dw 0x75c0, 0xc098,	0x75ff, 0xc098,		0x21, 0
	.dw 0x7640, 0xc098,	0x767f, 0xc098,		0x21, 0
	.dw 0x76c0, 0xc098,	0x76ff, 0xc098,		0x21, 0
	.dw 0x7740, 0xc098,	0x777f, 0xc098,		0x21, 0
	.dw 0x77c0, 0xc098,	0x77ff, 0xc098,		0x21, 0
	.dw 0x7840, 0xc098,	0x787f, 0xc098,		0x21, 0
	.dw 0x78c0, 0xc098,	0x78ff, 0xc098,		0x21, 0
	.dw 0x7940, 0xc098,	0x797f, 0xc098,		0x21, 0
	.dw 0x79c0, 0xc098,	0x9fff, 0xc098,		0x21, 0
	.dw 0xa040, 0xc098,	0xa07f, 0xc098,		0x21, 0
	.dw 0xa0c0, 0xc098,	0xa0ff, 0xc098,		0x21, 0
	.dw 0xa140, 0xc098,	0xa17f, 0xc098,		0x21, 0
	.dw 0xa1c0, 0xc098,	0xa1ff, 0xc098,		0x21, 0
	.dw 0xa240, 0xc098,	0xa27f, 0xc098,		0x21, 0
	.dw 0xa2c0, 0xc098,	0xa2ff, 0xc098,		0x21, 0
	.dw 0xa340, 0xc098,	0xa37f, 0xc098,		0x21, 0
	.dw 0xa3c0, 0xc098,	0xa3ff, 0xc098,		0x21, 0
	.dw 0xa440, 0xc098,	0xa47f, 0xc098,		0x21, 0
	.dw 0xa4c0, 0xc098,	0xa4ff, 0xc098,		0x21, 0
	.dw 0xa540, 0xc098,	0xa57f, 0xc098,		0x21, 0
	.dw 0xa5c0, 0xc098,	0xa5ff, 0xc098,		0x21, 0
	.dw 0xa640, 0xc098,	0xa67f, 0xc098,		0x21, 0
	.dw 0xa6c0, 0xc098,	0xa6ff, 0xc098,		0x21, 0
	.dw 0xa740, 0xc098,	0xa77f, 0xc098,		0x21, 0
	.dw 0xa7c0, 0xc098,	0xa7ff, 0xc098,		0x21, 0
	.dw 0xa840, 0xc098,	0xa87f, 0xc098,		0x21, 0
	.dw 0xa8c0, 0xc098,	0xa8ff, 0xc098,		0x21, 0
	.dw 0xa940, 0xc098,	0xa97f, 0xc098,		0x21, 0
	.dw 0xa9c0, 0xc098,	0xa9ff, 0xc098,		0x21, 0
	.dw 0xaa40, 0xc098,	0xaa7f, 0xc098,		0x21, 0
	.dw 0xaac0, 0xc098,	0xaaff, 0xc098,		0x21, 0
	.dw 0xab40, 0xc098,	0xab7f, 0xc098,		0x21, 0
	.dw 0xabc0, 0xc098,	0xabff, 0xc098,		0x21, 0
	.dw 0xac40, 0xc098,	0xac7f, 0xc098,		0x21, 0
	.dw 0xacc0, 0xc098,	0xacff, 0xc098,		0x21, 0
	.dw 0xad40, 0xc098,	0xad7f, 0xc098,		0x21, 0
	.dw 0xadc0, 0xc098,	0xadff, 0xc098,		0x21, 0
	.dw 0xae40, 0xc098,	0xae7f, 0xc098,		0x21, 0
	.dw 0xaec0, 0xc098,	0xaeff, 0xc098,		0x21, 0
	.dw 0xaf40, 0xc098,	0xaf7f, 0xc098,		0x21, 0
	.dw 0xafc0, 0xc098,	0xafff, 0xc098,		0x21, 0
	.dw 0xb040, 0xc098,	0xb07f, 0xc098,		0x21, 0
	.dw 0xb0c0, 0xc098,	0xb0ff, 0xc098,		0x21, 0
	.dw 0xb140, 0xc098,	0xb17f, 0xc098,		0x21, 0
	.dw 0xb1c0, 0xc098,	0xb1ff, 0xc098,		0x21, 0
	.dw 0xb240, 0xc098,	0xb27f, 0xc098,		0x21, 0
	.dw 0xb2c0, 0xc098,	0xb2ff, 0xc098,		0x21, 0
	.dw 0xb340, 0xc098,	0xb37f, 0xc098,		0x21, 0
	.dw 0xb3c0, 0xc098,	0xb3ff, 0xc098,		0x21, 0
	.dw 0xb440, 0xc098,	0xb47f, 0xc098,		0x21, 0
	.dw 0xb4c0, 0xc098,	0xb4ff, 0xc098,		0x21, 0
	.dw 0xb540, 0xc098,	0xb57f, 0xc098,		0x21, 0
	.dw 0xb5c0, 0xc098,	0xb5ff, 0xc098,		0x21, 0
	.dw 0xb640, 0xc098,	0xb67f, 0xc098,		0x21, 0
	.dw 0xb6c0, 0xc098,	0xb6ff, 0xc098,		0x21, 0
	.dw 0xb740, 0xc098,	0xb77f, 0xc098,		0x21, 0
	.dw 0xb7c0, 0xc098,	0xb7ff, 0xc098,		0x21, 0
	.dw 0xb840, 0xc098,	0xb87f, 0xc098,		0x21, 0
	.dw 0xb8c0, 0xc098,	0xb8ff, 0xc098,		0x21, 0
	.dw 0xb940, 0xc098,	0xb97f, 0xc098,		0x21, 0
	.dw 0xb9c0, 0xc098,	0xdfff, 0xc098,		0x21, 0
	.dw 0xe040, 0xc098,	0xe07f, 0xc098,		0x21, 0
	.dw 0xe0c0, 0xc098,	0xe0ff, 0xc098,		0x21, 0
	.dw 0xe140, 0xc098,	0xe17f, 0xc098,		0x21, 0
	.dw 0xe1c0, 0xc098,	0xe1ff, 0xc098,		0x21, 0
	.dw 0xe240, 0xc098,	0xe27f, 0xc098,		0x21, 0
	.dw 0xe2c0, 0xc098,	0xe2ff, 0xc098,		0x21, 0
	.dw 0xe340, 0xc098,	0xe37f, 0xc098,		0x21, 0
	.dw 0xe3c0, 0xc098,	0xe3ff, 0xc098,		0x21, 0
	.dw 0xe440, 0xc098,	0xe47f, 0xc098,		0x21, 0
	.dw 0xe4c0, 0xc098,	0xe4ff, 0xc098,		0x21, 0
	.dw 0xe540, 0xc098,	0xe57f, 0xc098,		0x21, 0
	.dw 0xe5c0, 0xc098,	0xe5ff, 0xc098,		0x21, 0
	.dw 0xe640, 0xc098,	0xe67f, 0xc098,		0x21, 0
	.dw 0xe6c0, 0xc098,	0xe6ff, 0xc098,		0x21, 0
	.dw 0xe740, 0xc098,	0xe77f, 0xc098,		0x21, 0
	.dw 0xe7c0, 0xc098,	0xe7ff, 0xc098,		0x21, 0
	.dw 0xe840, 0xc098,	0xe87f, 0xc098,		0x21, 0
	.dw 0xe8c0, 0xc098,	0xe8ff, 0xc098,		0x21, 0
	.dw 0xe940, 0xc098,	0xe97f, 0xc098,		0x21, 0
	.dw 0xe9c0, 0xc098,	0xe9ff, 0xc098,		0x21, 0
	.dw 0xea40, 0xc098,	0xea7f, 0xc098,		0x21, 0
	.dw 0xeac0, 0xc098,	0xeaff, 0xc098,		0x21, 0
	.dw 0xeb40, 0xc098,	0xeb7f, 0xc098,		0x21, 0
	.dw 0xebc0, 0xc098,	0xebff, 0xc098,		0x21, 0
	.dw 0xec40, 0xc098,	0xec7f, 0xc098,		0x21, 0
	.dw 0xecc0, 0xc098,	0xecff, 0xc098,		0x21, 0
	.dw 0xed40, 0xc098,	0xed7f, 0xc098,		0x21, 0
	.dw 0xedc0, 0xc098,	0xedff, 0xc098,		0x21, 0
	.dw 0xee40, 0xc098,	0xee7f, 0xc098,		0x21, 0
	.dw 0xeec0, 0xc098,	0xeeff, 0xc098,		0x21, 0
	.dw 0xef40, 0xc098,	0xef7f, 0xc098,		0x21, 0
	.dw 0xefc0, 0xc098,	0xefff, 0xc098,		0x21, 0
	.dw 0xf040, 0xc098,	0xf07f, 0xc098,		0x21, 0
	.dw 0xf0c0, 0xc098,	0xf0ff, 0xc098,		0x21, 0
	.dw 0xf140, 0xc098,	0xf17f, 0xc098,		0x21, 0
	.dw 0xf1c0, 0xc098,	0xf1ff, 0xc098,		0x21, 0
	.dw 0xf240, 0xc098,	0xf27f, 0xc098,		0x21, 0
	.dw 0xf2c0, 0xc098,	0xf2ff, 0xc098,		0x21, 0
	.dw 0xf340, 0xc098,	0xf37f, 0xc098,		0x21, 0
	.dw 0xf3c0, 0xc098,	0xf3ff, 0xc098,		0x21, 0
	.dw 0xf440, 0xc098,	0xf47f, 0xc098,		0x21, 0
	.dw 0xf4c0, 0xc098,	0xf4ff, 0xc098,		0x21, 0
	.dw 0xf540, 0xc098,	0xf57f, 0xc098,		0x21, 0
	.dw 0xf5c0, 0xc098,	0xf5ff, 0xc098,		0x21, 0
	.dw 0xf640, 0xc098,	0xf67f, 0xc098,		0x21, 0
	.dw 0xf6c0, 0xc098,	0xf6ff, 0xc098,		0x21, 0
	.dw 0xf740, 0xc098,	0xf77f, 0xc098,		0x21, 0
	.dw 0xf7c0, 0xc098,	0xf7ff, 0xc098,		0x21, 0
	.dw 0xf840, 0xc098,	0xf87f, 0xc098,		0x21, 0
	.dw 0xf8c0, 0xc098,	0xf8ff, 0xc098,		0x21, 0
	.dw 0xf940, 0xc098,	0xf97f, 0xc098,		0x21, 0
	.dw 0xf9c0, 0xc098,	0x1fff, 0xc099,		0x21, 0
	.dw 0x2040, 0xc099,	0x207f, 0xc099,		0x21, 0
	.dw 0x20c0, 0xc099,	0x20ff, 0xc099,		0x21, 0
	.dw 0x2140, 0xc099,	0x217f, 0xc099,		0x21, 0
	.dw 0x21c0, 0xc099,	0x21ff, 0xc099,		0x21, 0
	.dw 0x2240, 0xc099,	0x227f, 0xc099,		0x21, 0
	.dw 0x22c0, 0xc099,	0x22ff, 0xc099,		0x21, 0
	.dw 0x2340, 0xc099,	0x237f, 0xc099,		0x21, 0
	.dw 0x23c0, 0xc099,	0x23ff, 0xc099,		0x21, 0
	.dw 0x2440, 0xc099,	0x247f, 0xc099,		0x21, 0
	.dw 0x24c0, 0xc099,	0x24ff, 0xc099,		0x21, 0
	.dw 0x2540, 0xc099,	0x257f, 0xc099,		0x21, 0
	.dw 0x25c0, 0xc099,	0x25ff, 0xc099,		0x21, 0
	.dw 0x2640, 0xc099,	0x267f, 0xc099,		0x21, 0
	.dw 0x26c0, 0xc099,	0x26ff, 0xc099,		0x21, 0
	.dw 0x2740, 0xc099,	0x277f, 0xc099,		0x21, 0
	.dw 0x27c0, 0xc099,	0x27ff, 0xc099,		0x21, 0
	.dw 0x2840, 0xc099,	0x287f, 0xc099,		0x21, 0
	.dw 0x28c0, 0xc099,	0x28ff, 0xc099,		0x21, 0
	.dw 0x2940, 0xc099,	0x297f, 0xc099,		0x21, 0
	.dw 0x29c0, 0xc099,	0x29ff, 0xc099,		0x21, 0
	.dw 0x2a40, 0xc099,	0x2a7f, 0xc099,		0x21, 0
	.dw 0x2ac0, 0xc099,	0x2aff, 0xc099,		0x21, 0
	.dw 0x2b40, 0xc099,	0x2b7f, 0xc099,		0x21, 0
	.dw 0x2bc0, 0xc099,	0x2bff, 0xc099,		0x21, 0
	.dw 0x2c40, 0xc099,	0x2c7f, 0xc099,		0x21, 0
	.dw 0x2cc0, 0xc099,	0x2cff, 0xc099,		0x21, 0
	.dw 0x2d40, 0xc099,	0x2d7f, 0xc099,		0x21, 0
	.dw 0x2dc0, 0xc099,	0x2dff, 0xc099,		0x21, 0
	.dw 0x2e40, 0xc099,	0x2e7f, 0xc099,		0x21, 0
	.dw 0x2ec0, 0xc099,	0x2eff, 0xc099,		0x21, 0
	.dw 0x2f40, 0xc099,	0x2f7f, 0xc099,		0x21, 0
	.dw 0x2fc0, 0xc099,	0x2fff, 0xc099,		0x21, 0
	.dw 0x3040, 0xc099,	0x307f, 0xc099,		0x21, 0
	.dw 0x30c0, 0xc099,	0x30ff, 0xc099,		0x21, 0
	.dw 0x3140, 0xc099,	0x317f, 0xc099,		0x21, 0
	.dw 0x31c0, 0xc099,	0x31ff, 0xc099,		0x21, 0
	.dw 0x3240, 0xc099,	0x327f, 0xc099,		0x21, 0
	.dw 0x32c0, 0xc099,	0x32ff, 0xc099,		0x21, 0
	.dw 0x3340, 0xc099,	0x337f, 0xc099,		0x21, 0
	.dw 0x33c0, 0xc099,	0x33ff, 0xc099,		0x21, 0
	.dw 0x3440, 0xc099,	0x347f, 0xc099,		0x21, 0
	.dw 0x34c0, 0xc099,	0x34ff, 0xc099,		0x21, 0
	.dw 0x3540, 0xc099,	0x357f, 0xc099,		0x21, 0
	.dw 0x35c0, 0xc099,	0x35ff, 0xc099,		0x21, 0
	.dw 0x3640, 0xc099,	0x367f, 0xc099,		0x21, 0
	.dw 0x36c0, 0xc099,	0x36ff, 0xc099,		0x21, 0
	.dw 0x3740, 0xc099,	0x377f, 0xc099,		0x21, 0
	.dw 0x37c0, 0xc099,	0x37ff, 0xc099,		0x21, 0
	.dw 0x3840, 0xc099,	0x387f, 0xc099,		0x21, 0
	.dw 0x38c0, 0xc099,	0x38ff, 0xc099,		0x21, 0
	.dw 0x3940, 0xc099,	0x397f, 0xc099,		0x21, 0
	.dw 0x39c0, 0xc099,	0x5fff, 0xc099,		0x21, 0
	.dw 0x6040, 0xc099,	0x607f, 0xc099,		0x21, 0
	.dw 0x60c0, 0xc099,	0x60ff, 0xc099,		0x21, 0
	.dw 0x6140, 0xc099,	0x617f, 0xc099,		0x21, 0
	.dw 0x61c0, 0xc099,	0x61ff, 0xc099,		0x21, 0
	.dw 0x6240, 0xc099,	0x627f, 0xc099,		0x21, 0
	.dw 0x62c0, 0xc099,	0x62ff, 0xc099,		0x21, 0
	.dw 0x6340, 0xc099,	0x637f, 0xc099,		0x21, 0
	.dw 0x63c0, 0xc099,	0x63ff, 0xc099,		0x21, 0
	.dw 0x6440, 0xc099,	0x647f, 0xc099,		0x21, 0
	.dw 0x64c0, 0xc099,	0x64ff, 0xc099,		0x21, 0
	.dw 0x6540, 0xc099,	0x657f, 0xc099,		0x21, 0
	.dw 0x65c0, 0xc099,	0x65ff, 0xc099,		0x21, 0
	.dw 0x6640, 0xc099,	0x667f, 0xc099,		0x21, 0
	.dw 0x66c0, 0xc099,	0x66ff, 0xc099,		0x21, 0
	.dw 0x6740, 0xc099,	0x677f, 0xc099,		0x21, 0
	.dw 0x67c0, 0xc099,	0x67ff, 0xc099,		0x21, 0
	.dw 0x6840, 0xc099,	0x687f, 0xc099,		0x21, 0
	.dw 0x68c0, 0xc099,	0x68ff, 0xc099,		0x21, 0
	.dw 0x6940, 0xc099,	0x697f, 0xc099,		0x21, 0
	.dw 0x69c0, 0xc099,	0x69ff, 0xc099,		0x21, 0
	.dw 0x6a40, 0xc099,	0x6a7f, 0xc099,		0x21, 0
	.dw 0x6ac0, 0xc099,	0x6aff, 0xc099,		0x21, 0
	.dw 0x6b40, 0xc099,	0x6b7f, 0xc099,		0x21, 0
	.dw 0x6bc0, 0xc099,	0x6bff, 0xc099,		0x21, 0
	.dw 0x6c40, 0xc099,	0x6c7f, 0xc099,		0x21, 0
	.dw 0x6cc0, 0xc099,	0x6cff, 0xc099,		0x21, 0
	.dw 0x6d40, 0xc099,	0x6d7f, 0xc099,		0x21, 0
	.dw 0x6dc0, 0xc099,	0x6dff, 0xc099,		0x21, 0
	.dw 0x6e40, 0xc099,	0x6e7f, 0xc099,		0x21, 0
	.dw 0x6ec0, 0xc099,	0x6eff, 0xc099,		0x21, 0
	.dw 0x6f40, 0xc099,	0x6f7f, 0xc099,		0x21, 0
	.dw 0x6fc0, 0xc099,	0x6fff, 0xc099,		0x21, 0
	.dw 0x7040, 0xc099,	0x707f, 0xc099,		0x21, 0
	.dw 0x70c0, 0xc099,	0x70ff, 0xc099,		0x21, 0
	.dw 0x7140, 0xc099,	0x717f, 0xc099,		0x21, 0
	.dw 0x71c0, 0xc099,	0x71ff, 0xc099,		0x21, 0
	.dw 0x7240, 0xc099,	0x727f, 0xc099,		0x21, 0
	.dw 0x72c0, 0xc099,	0x72ff, 0xc099,		0x21, 0
	.dw 0x7340, 0xc099,	0x737f, 0xc099,		0x21, 0
	.dw 0x73c0, 0xc099,	0x73ff, 0xc099,		0x21, 0
	.dw 0x7440, 0xc099,	0x747f, 0xc099,		0x21, 0
	.dw 0x74c0, 0xc099,	0x74ff, 0xc099,		0x21, 0
	.dw 0x7540, 0xc099,	0x757f, 0xc099,		0x21, 0
	.dw 0x75c0, 0xc099,	0x75ff, 0xc099,		0x21, 0
	.dw 0x7640, 0xc099,	0x767f, 0xc099,		0x21, 0
	.dw 0x76c0, 0xc099,	0x76ff, 0xc099,		0x21, 0
	.dw 0x7740, 0xc099,	0x777f, 0xc099,		0x21, 0
	.dw 0x77c0, 0xc099,	0x77ff, 0xc099,		0x21, 0
	.dw 0x7840, 0xc099,	0x787f, 0xc099,		0x21, 0
	.dw 0x78c0, 0xc099,	0x78ff, 0xc099,		0x21, 0
	.dw 0x7940, 0xc099,	0x797f, 0xc099,		0x21, 0
	.dw 0x79c0, 0xc099,	0x9fff, 0xc099,		0x21, 0
	.dw 0xa040, 0xc099,	0xa07f, 0xc099,		0x21, 0
	.dw 0xa0c0, 0xc099,	0xa0ff, 0xc099,		0x21, 0
	.dw 0xa140, 0xc099,	0xa17f, 0xc099,		0x21, 0
	.dw 0xa1c0, 0xc099,	0xa1ff, 0xc099,		0x21, 0
	.dw 0xa240, 0xc099,	0xa27f, 0xc099,		0x21, 0
	.dw 0xa2c0, 0xc099,	0xa2ff, 0xc099,		0x21, 0
	.dw 0xa340, 0xc099,	0xa37f, 0xc099,		0x21, 0
	.dw 0xa3c0, 0xc099,	0xa3ff, 0xc099,		0x21, 0
	.dw 0xa440, 0xc099,	0xa47f, 0xc099,		0x21, 0
	.dw 0xa4c0, 0xc099,	0xa4ff, 0xc099,		0x21, 0
	.dw 0xa540, 0xc099,	0xa57f, 0xc099,		0x21, 0
	.dw 0xa5c0, 0xc099,	0xa5ff, 0xc099,		0x21, 0
	.dw 0xa640, 0xc099,	0xa67f, 0xc099,		0x21, 0
	.dw 0xa6c0, 0xc099,	0xa6ff, 0xc099,		0x21, 0
	.dw 0xa740, 0xc099,	0xa77f, 0xc099,		0x21, 0
	.dw 0xa7c0, 0xc099,	0xa7ff, 0xc099,		0x21, 0
	.dw 0xa840, 0xc099,	0xa87f, 0xc099,		0x21, 0
	.dw 0xa8c0, 0xc099,	0xa8ff, 0xc099,		0x21, 0
	.dw 0xa940, 0xc099,	0xa97f, 0xc099,		0x21, 0
	.dw 0xa9c0, 0xc099,	0xa9ff, 0xc099,		0x21, 0
	.dw 0xaa40, 0xc099,	0xaa7f, 0xc099,		0x21, 0
	.dw 0xaac0, 0xc099,	0xaaff, 0xc099,		0x21, 0
	.dw 0xab40, 0xc099,	0xab7f, 0xc099,		0x21, 0
	.dw 0xabc0, 0xc099,	0xabff, 0xc099,		0x21, 0
	.dw 0xac40, 0xc099,	0xac7f, 0xc099,		0x21, 0
	.dw 0xacc0, 0xc099,	0xacff, 0xc099,		0x21, 0
	.dw 0xad40, 0xc099,	0xad7f, 0xc099,		0x21, 0
	.dw 0xadc0, 0xc099,	0xadff, 0xc099,		0x21, 0
	.dw 0xae40, 0xc099,	0xae7f, 0xc099,		0x21, 0
	.dw 0xaec0, 0xc099,	0xaeff, 0xc099,		0x21, 0
	.dw 0xaf40, 0xc099,	0xaf7f, 0xc099,		0x21, 0
	.dw 0xafc0, 0xc099,	0xafff, 0xc099,		0x21, 0
	.dw 0xb040, 0xc099,	0xb07f, 0xc099,		0x21, 0
	.dw 0xb0c0, 0xc099,	0xb0ff, 0xc099,		0x21, 0
	.dw 0xb140, 0xc099,	0xb17f, 0xc099,		0x21, 0
	.dw 0xb1c0, 0xc099,	0xb1ff, 0xc099,		0x21, 0
	.dw 0xb240, 0xc099,	0xb27f, 0xc099,		0x21, 0
	.dw 0xb2c0, 0xc099,	0xb2ff, 0xc099,		0x21, 0
	.dw 0xb340, 0xc099,	0xb37f, 0xc099,		0x21, 0
	.dw 0xb3c0, 0xc099,	0xb3ff, 0xc099,		0x21, 0
	.dw 0xb440, 0xc099,	0xb47f, 0xc099,		0x21, 0
	.dw 0xb4c0, 0xc099,	0xb4ff, 0xc099,		0x21, 0
	.dw 0xb540, 0xc099,	0xb57f, 0xc099,		0x21, 0
	.dw 0xb5c0, 0xc099,	0xb5ff, 0xc099,		0x21, 0
	.dw 0xb640, 0xc099,	0xb67f, 0xc099,		0x21, 0
	.dw 0xb6c0, 0xc099,	0xb6ff, 0xc099,		0x21, 0
	.dw 0xb740, 0xc099,	0xb77f, 0xc099,		0x21, 0
	.dw 0xb7c0, 0xc099,	0xb7ff, 0xc099,		0x21, 0
	.dw 0xb840, 0xc099,	0xb87f, 0xc099,		0x21, 0
	.dw 0xb8c0, 0xc099,	0xb8ff, 0xc099,		0x21, 0
	.dw 0xb940, 0xc099,	0xb97f, 0xc099,		0x21, 0
	.dw 0xb9c0, 0xc099,	0xdfff, 0xc099,		0x21, 0
	.dw 0xe040, 0xc099,	0xe07f, 0xc099,		0x21, 0
	.dw 0xe0c0, 0xc099,	0xe0ff, 0xc099,		0x21, 0
	.dw 0xe140, 0xc099,	0xe17f, 0xc099,		0x21, 0
	.dw 0xe1c0, 0xc099,	0xe1ff, 0xc099,		0x21, 0
	.dw 0xe240, 0xc099,	0xe27f, 0xc099,		0x21, 0
	.dw 0xe2c0, 0xc099,	0xe2ff, 0xc099,		0x21, 0
	.dw 0xe340, 0xc099,	0xe37f, 0xc099,		0x21, 0
	.dw 0xe3c0, 0xc099,	0xe3ff, 0xc099,		0x21, 0
	.dw 0xe440, 0xc099,	0xe47f, 0xc099,		0x21, 0
	.dw 0xe4c0, 0xc099,	0xe4ff, 0xc099,		0x21, 0
	.dw 0xe540, 0xc099,	0xe57f, 0xc099,		0x21, 0
	.dw 0xe5c0, 0xc099,	0xe5ff, 0xc099,		0x21, 0
	.dw 0xe640, 0xc099,	0xe67f, 0xc099,		0x21, 0
	.dw 0xe6c0, 0xc099,	0xe6ff, 0xc099,		0x21, 0
	.dw 0xe740, 0xc099,	0xe77f, 0xc099,		0x21, 0
	.dw 0xe7c0, 0xc099,	0xe7ff, 0xc099,		0x21, 0
	.dw 0xe840, 0xc099,	0xe87f, 0xc099,		0x21, 0
	.dw 0xe8c0, 0xc099,	0xe8ff, 0xc099,		0x21, 0
	.dw 0xe940, 0xc099,	0xe97f, 0xc099,		0x21, 0
	.dw 0xe9c0, 0xc099,	0xe9ff, 0xc099,		0x21, 0
	.dw 0xea40, 0xc099,	0xea7f, 0xc099,		0x21, 0
	.dw 0xeac0, 0xc099,	0xeaff, 0xc099,		0x21, 0
	.dw 0xeb40, 0xc099,	0xeb7f, 0xc099,		0x21, 0
	.dw 0xebc0, 0xc099,	0xebff, 0xc099,		0x21, 0
	.dw 0xec40, 0xc099,	0xec7f, 0xc099,		0x21, 0
	.dw 0xecc0, 0xc099,	0xecff, 0xc099,		0x21, 0
	.dw 0xed40, 0xc099,	0xed7f, 0xc099,		0x21, 0
	.dw 0xedc0, 0xc099,	0xedff, 0xc099,		0x21, 0
	.dw 0xee40, 0xc099,	0xee7f, 0xc099,		0x21, 0
	.dw 0xeec0, 0xc099,	0xeeff, 0xc099,		0x21, 0
	.dw 0xef40, 0xc099,	0xef7f, 0xc099,		0x21, 0
	.dw 0xefc0, 0xc099,	0xefff, 0xc099,		0x21, 0
	.dw 0xf040, 0xc099,	0xf07f, 0xc099,		0x21, 0
	.dw 0xf0c0, 0xc099,	0xf0ff, 0xc099,		0x21, 0
	.dw 0xf140, 0xc099,	0xf17f, 0xc099,		0x21, 0
	.dw 0xf1c0, 0xc099,	0xf1ff, 0xc099,		0x21, 0
	.dw 0xf240, 0xc099,	0xf27f, 0xc099,		0x21, 0
	.dw 0xf2c0, 0xc099,	0xf2ff, 0xc099,		0x21, 0
	.dw 0xf340, 0xc099,	0xf37f, 0xc099,		0x21, 0
	.dw 0xf3c0, 0xc099,	0xf3ff, 0xc099,		0x21, 0
	.dw 0xf440, 0xc099,	0xf47f, 0xc099,		0x21, 0
	.dw 0xf4c0, 0xc099,	0xf4ff, 0xc099,		0x21, 0
	.dw 0xf540, 0xc099,	0xf57f, 0xc099,		0x21, 0
	.dw 0xf5c0, 0xc099,	0xf5ff, 0xc099,		0x21, 0
	.dw 0xf640, 0xc099,	0xf67f, 0xc099,		0x21, 0
	.dw 0xf6c0, 0xc099,	0xf6ff, 0xc099,		0x21, 0
	.dw 0xf740, 0xc099,	0xf77f, 0xc099,		0x21, 0
	.dw 0xf7c0, 0xc099,	0xf7ff, 0xc099,		0x21, 0
	.dw 0xf840, 0xc099,	0xf87f, 0xc099,		0x21, 0
	.dw 0xf8c0, 0xc099,	0xf8ff, 0xc099,		0x21, 0
	.dw 0xf940, 0xc099,	0xf97f, 0xc099,		0x21, 0
	.dw 0xf9c0, 0xc099,	0x1fff, 0xc09a,		0x21, 0
	.dw 0x2040, 0xc09a,	0x207f, 0xc09a,		0x21, 0
	.dw 0x20c0, 0xc09a,	0x20ff, 0xc09a,		0x21, 0
	.dw 0x2140, 0xc09a,	0x217f, 0xc09a,		0x21, 0
	.dw 0x21c0, 0xc09a,	0x21ff, 0xc09a,		0x21, 0
	.dw 0x2240, 0xc09a,	0x227f, 0xc09a,		0x21, 0
	.dw 0x22c0, 0xc09a,	0x22ff, 0xc09a,		0x21, 0
	.dw 0x2340, 0xc09a,	0x237f, 0xc09a,		0x21, 0
	.dw 0x23c0, 0xc09a,	0x23ff, 0xc09a,		0x21, 0
	.dw 0x2440, 0xc09a,	0x247f, 0xc09a,		0x21, 0
	.dw 0x24c0, 0xc09a,	0x24ff, 0xc09a,		0x21, 0
	.dw 0x2540, 0xc09a,	0x257f, 0xc09a,		0x21, 0
	.dw 0x25c0, 0xc09a,	0x25ff, 0xc09a,		0x21, 0
	.dw 0x2640, 0xc09a,	0x267f, 0xc09a,		0x21, 0
	.dw 0x26c0, 0xc09a,	0x26ff, 0xc09a,		0x21, 0
	.dw 0x2740, 0xc09a,	0x277f, 0xc09a,		0x21, 0
	.dw 0x27c0, 0xc09a,	0x27ff, 0xc09a,		0x21, 0
	.dw 0x2840, 0xc09a,	0x287f, 0xc09a,		0x21, 0
	.dw 0x28c0, 0xc09a,	0x28ff, 0xc09a,		0x21, 0
	.dw 0x2940, 0xc09a,	0x297f, 0xc09a,		0x21, 0
	.dw 0x29c0, 0xc09a,	0x29ff, 0xc09a,		0x21, 0
	.dw 0x2a40, 0xc09a,	0x2a7f, 0xc09a,		0x21, 0
	.dw 0x2ac0, 0xc09a,	0x2aff, 0xc09a,		0x21, 0
	.dw 0x2b40, 0xc09a,	0x2b7f, 0xc09a,		0x21, 0
	.dw 0x2bc0, 0xc09a,	0x2bff, 0xc09a,		0x21, 0
	.dw 0x2c40, 0xc09a,	0x2c7f, 0xc09a,		0x21, 0
	.dw 0x2cc0, 0xc09a,	0x2cff, 0xc09a,		0x21, 0
	.dw 0x2d40, 0xc09a,	0x2d7f, 0xc09a,		0x21, 0
	.dw 0x2dc0, 0xc09a,	0x2dff, 0xc09a,		0x21, 0
	.dw 0x2e40, 0xc09a,	0x2e7f, 0xc09a,		0x21, 0
	.dw 0x2ec0, 0xc09a,	0x2eff, 0xc09a,		0x21, 0
	.dw 0x2f40, 0xc09a,	0x2f7f, 0xc09a,		0x21, 0
	.dw 0x2fc0, 0xc09a,	0x2fff, 0xc09a,		0x21, 0
	.dw 0x3040, 0xc09a,	0x307f, 0xc09a,		0x21, 0
	.dw 0x30c0, 0xc09a,	0x30ff, 0xc09a,		0x21, 0
	.dw 0x3140, 0xc09a,	0x317f, 0xc09a,		0x21, 0
	.dw 0x31c0, 0xc09a,	0x31ff, 0xc09a,		0x21, 0
	.dw 0x3240, 0xc09a,	0x327f, 0xc09a,		0x21, 0
	.dw 0x32c0, 0xc09a,	0x32ff, 0xc09a,		0x21, 0
	.dw 0x3340, 0xc09a,	0x337f, 0xc09a,		0x21, 0
	.dw 0x33c0, 0xc09a,	0x33ff, 0xc09a,		0x21, 0
	.dw 0x3440, 0xc09a,	0x347f, 0xc09a,		0x21, 0
	.dw 0x34c0, 0xc09a,	0x34ff, 0xc09a,		0x21, 0
	.dw 0x3540, 0xc09a,	0x357f, 0xc09a,		0x21, 0
	.dw 0x35c0, 0xc09a,	0x35ff, 0xc09a,		0x21, 0
	.dw 0x3640, 0xc09a,	0x367f, 0xc09a,		0x21, 0
	.dw 0x36c0, 0xc09a,	0x36ff, 0xc09a,		0x21, 0
	.dw 0x3740, 0xc09a,	0x377f, 0xc09a,		0x21, 0
	.dw 0x37c0, 0xc09a,	0x37ff, 0xc09a,		0x21, 0
	.dw 0x3840, 0xc09a,	0x387f, 0xc09a,		0x21, 0
	.dw 0x38c0, 0xc09a,	0x38ff, 0xc09a,		0x21, 0
	.dw 0x3940, 0xc09a,	0x397f, 0xc09a,		0x21, 0
	.dw 0x39c0, 0xc09a,	0x5fff, 0xc09a,		0x21, 0
	.dw 0x6040, 0xc09a,	0x607f, 0xc09a,		0x21, 0
	.dw 0x60c0, 0xc09a,	0x60ff, 0xc09a,		0x21, 0
	.dw 0x6140, 0xc09a,	0x617f, 0xc09a,		0x21, 0
	.dw 0x61c0, 0xc09a,	0x61ff, 0xc09a,		0x21, 0
	.dw 0x6240, 0xc09a,	0x627f, 0xc09a,		0x21, 0
	.dw 0x62c0, 0xc09a,	0x62ff, 0xc09a,		0x21, 0
	.dw 0x6340, 0xc09a,	0x637f, 0xc09a,		0x21, 0
	.dw 0x63c0, 0xc09a,	0x63ff, 0xc09a,		0x21, 0
	.dw 0x6440, 0xc09a,	0x647f, 0xc09a,		0x21, 0
	.dw 0x64c0, 0xc09a,	0x64ff, 0xc09a,		0x21, 0
	.dw 0x6540, 0xc09a,	0x657f, 0xc09a,		0x21, 0
	.dw 0x65c0, 0xc09a,	0x65ff, 0xc09a,		0x21, 0
	.dw 0x6640, 0xc09a,	0x667f, 0xc09a,		0x21, 0
	.dw 0x66c0, 0xc09a,	0x66ff, 0xc09a,		0x21, 0
	.dw 0x6740, 0xc09a,	0x677f, 0xc09a,		0x21, 0
	.dw 0x67c0, 0xc09a,	0x67ff, 0xc09a,		0x21, 0
	.dw 0x6840, 0xc09a,	0x687f, 0xc09a,		0x21, 0
	.dw 0x68c0, 0xc09a,	0x68ff, 0xc09a,		0x21, 0
	.dw 0x6940, 0xc09a,	0x697f, 0xc09a,		0x21, 0
	.dw 0x69c0, 0xc09a,	0x69ff, 0xc09a,		0x21, 0
	.dw 0x6a40, 0xc09a,	0x6a7f, 0xc09a,		0x21, 0
	.dw 0x6ac0, 0xc09a,	0x6aff, 0xc09a,		0x21, 0
	.dw 0x6b40, 0xc09a,	0x6b7f, 0xc09a,		0x21, 0
	.dw 0x6bc0, 0xc09a,	0x6bff, 0xc09a,		0x21, 0
	.dw 0x6c40, 0xc09a,	0x6c7f, 0xc09a,		0x21, 0
	.dw 0x6cc0, 0xc09a,	0x6cff, 0xc09a,		0x21, 0
	.dw 0x6d40, 0xc09a,	0x6d7f, 0xc09a,		0x21, 0
	.dw 0x6dc0, 0xc09a,	0x6dff, 0xc09a,		0x21, 0
	.dw 0x6e40, 0xc09a,	0x6e7f, 0xc09a,		0x21, 0
	.dw 0x6ec0, 0xc09a,	0x6eff, 0xc09a,		0x21, 0
	.dw 0x6f40, 0xc09a,	0x6f7f, 0xc09a,		0x21, 0
	.dw 0x6fc0, 0xc09a,	0x6fff, 0xc09a,		0x21, 0
	.dw 0x7040, 0xc09a,	0x707f, 0xc09a,		0x21, 0
	.dw 0x70c0, 0xc09a,	0x70ff, 0xc09a,		0x21, 0
	.dw 0x7140, 0xc09a,	0x717f, 0xc09a,		0x21, 0
	.dw 0x71c0, 0xc09a,	0x71ff, 0xc09a,		0x21, 0
	.dw 0x7240, 0xc09a,	0x727f, 0xc09a,		0x21, 0
	.dw 0x72c0, 0xc09a,	0x72ff, 0xc09a,		0x21, 0
	.dw 0x7340, 0xc09a,	0x737f, 0xc09a,		0x21, 0
	.dw 0x73c0, 0xc09a,	0x73ff, 0xc09a,		0x21, 0
	.dw 0x7440, 0xc09a,	0x747f, 0xc09a,		0x21, 0
	.dw 0x74c0, 0xc09a,	0x74ff, 0xc09a,		0x21, 0
	.dw 0x7540, 0xc09a,	0x757f, 0xc09a,		0x21, 0
	.dw 0x75c0, 0xc09a,	0x75ff, 0xc09a,		0x21, 0
	.dw 0x7640, 0xc09a,	0x767f, 0xc09a,		0x21, 0
	.dw 0x76c0, 0xc09a,	0x76ff, 0xc09a,		0x21, 0
	.dw 0x7740, 0xc09a,	0x777f, 0xc09a,		0x21, 0
	.dw 0x77c0, 0xc09a,	0x77ff, 0xc09a,		0x21, 0
	.dw 0x7840, 0xc09a,	0x787f, 0xc09a,		0x21, 0
	.dw 0x78c0, 0xc09a,	0x78ff, 0xc09a,		0x21, 0
	.dw 0x7940, 0xc09a,	0x797f, 0xc09a,		0x21, 0
	.dw 0x79c0, 0xc09a,	0x9fff, 0xc09a,		0x21, 0
	.dw 0xa040, 0xc09a,	0xa07f, 0xc09a,		0x21, 0
	.dw 0xa0c0, 0xc09a,	0xa0ff, 0xc09a,		0x21, 0
	.dw 0xa140, 0xc09a,	0xa17f, 0xc09a,		0x21, 0
	.dw 0xa1c0, 0xc09a,	0xa1ff, 0xc09a,		0x21, 0
	.dw 0xa240, 0xc09a,	0xa27f, 0xc09a,		0x21, 0
	.dw 0xa2c0, 0xc09a,	0xa2ff, 0xc09a,		0x21, 0
	.dw 0xa340, 0xc09a,	0xa37f, 0xc09a,		0x21, 0
	.dw 0xa3c0, 0xc09a,	0xa3ff, 0xc09a,		0x21, 0
	.dw 0xa440, 0xc09a,	0xa47f, 0xc09a,		0x21, 0
	.dw 0xa4c0, 0xc09a,	0xa4ff, 0xc09a,		0x21, 0
	.dw 0xa540, 0xc09a,	0xa57f, 0xc09a,		0x21, 0
	.dw 0xa5c0, 0xc09a,	0xa5ff, 0xc09a,		0x21, 0
	.dw 0xa640, 0xc09a,	0xa67f, 0xc09a,		0x21, 0
	.dw 0xa6c0, 0xc09a,	0xa6ff, 0xc09a,		0x21, 0
	.dw 0xa740, 0xc09a,	0xa77f, 0xc09a,		0x21, 0
	.dw 0xa7c0, 0xc09a,	0xa7ff, 0xc09a,		0x21, 0
	.dw 0xa840, 0xc09a,	0xa87f, 0xc09a,		0x21, 0
	.dw 0xa8c0, 0xc09a,	0xa8ff, 0xc09a,		0x21, 0
	.dw 0xa940, 0xc09a,	0xa97f, 0xc09a,		0x21, 0
	.dw 0xa9c0, 0xc09a,	0xa9ff, 0xc09a,		0x21, 0
	.dw 0xaa40, 0xc09a,	0xaa7f, 0xc09a,		0x21, 0
	.dw 0xaac0, 0xc09a,	0xaaff, 0xc09a,		0x21, 0
	.dw 0xab40, 0xc09a,	0xab7f, 0xc09a,		0x21, 0
	.dw 0xabc0, 0xc09a,	0xabff, 0xc09a,		0x21, 0
	.dw 0xac40, 0xc09a,	0xac7f, 0xc09a,		0x21, 0
	.dw 0xacc0, 0xc09a,	0xacff, 0xc09a,		0x21, 0
	.dw 0xad40, 0xc09a,	0xad7f, 0xc09a,		0x21, 0
	.dw 0xadc0, 0xc09a,	0xadff, 0xc09a,		0x21, 0
	.dw 0xae40, 0xc09a,	0xae7f, 0xc09a,		0x21, 0
	.dw 0xaec0, 0xc09a,	0xaeff, 0xc09a,		0x21, 0
	.dw 0xaf40, 0xc09a,	0xaf7f, 0xc09a,		0x21, 0
	.dw 0xafc0, 0xc09a,	0xafff, 0xc09a,		0x21, 0
	.dw 0xb040, 0xc09a,	0xb07f, 0xc09a,		0x21, 0
	.dw 0xb0c0, 0xc09a,	0xb0ff, 0xc09a,		0x21, 0
	.dw 0xb140, 0xc09a,	0xb17f, 0xc09a,		0x21, 0
	.dw 0xb1c0, 0xc09a,	0xb1ff, 0xc09a,		0x21, 0
	.dw 0xb240, 0xc09a,	0xb27f, 0xc09a,		0x21, 0
	.dw 0xb2c0, 0xc09a,	0xb2ff, 0xc09a,		0x21, 0
	.dw 0xb340, 0xc09a,	0xb37f, 0xc09a,		0x21, 0
	.dw 0xb3c0, 0xc09a,	0xb3ff, 0xc09a,		0x21, 0
	.dw 0xb440, 0xc09a,	0xb47f, 0xc09a,		0x21, 0
	.dw 0xb4c0, 0xc09a,	0xb4ff, 0xc09a,		0x21, 0
	.dw 0xb540, 0xc09a,	0xb57f, 0xc09a,		0x21, 0
	.dw 0xb5c0, 0xc09a,	0xb5ff, 0xc09a,		0x21, 0
	.dw 0xb640, 0xc09a,	0xb67f, 0xc09a,		0x21, 0
	.dw 0xb6c0, 0xc09a,	0xb6ff, 0xc09a,		0x21, 0
	.dw 0xb740, 0xc09a,	0xb77f, 0xc09a,		0x21, 0
	.dw 0xb7c0, 0xc09a,	0xb7ff, 0xc09a,		0x21, 0
	.dw 0xb840, 0xc09a,	0xb87f, 0xc09a,		0x21, 0
	.dw 0xb8c0, 0xc09a,	0xb8ff, 0xc09a,		0x21, 0
	.dw 0xb940, 0xc09a,	0xb97f, 0xc09a,		0x21, 0
	.dw 0xb9c0, 0xc09a,	0xdfff, 0xc09a,		0x21, 0
	.dw 0xe040, 0xc09a,	0xe07f, 0xc09a,		0x21, 0
	.dw 0xe0c0, 0xc09a,	0xe0ff, 0xc09a,		0x21, 0
	.dw 0xe140, 0xc09a,	0xe17f, 0xc09a,		0x21, 0
	.dw 0xe1c0, 0xc09a,	0xe1ff, 0xc09a,		0x21, 0
	.dw 0xe240, 0xc09a,	0xe27f, 0xc09a,		0x21, 0
	.dw 0xe2c0, 0xc09a,	0xe2ff, 0xc09a,		0x21, 0
	.dw 0xe340, 0xc09a,	0xe37f, 0xc09a,		0x21, 0
	.dw 0xe3c0, 0xc09a,	0xe3ff, 0xc09a,		0x21, 0
	.dw 0xe440, 0xc09a,	0xe47f, 0xc09a,		0x21, 0
	.dw 0xe4c0, 0xc09a,	0xe4ff, 0xc09a,		0x21, 0
	.dw 0xe540, 0xc09a,	0xe57f, 0xc09a,		0x21, 0
	.dw 0xe5c0, 0xc09a,	0xe5ff, 0xc09a,		0x21, 0
	.dw 0xe640, 0xc09a,	0xe67f, 0xc09a,		0x21, 0
	.dw 0xe6c0, 0xc09a,	0xe6ff, 0xc09a,		0x21, 0
	.dw 0xe740, 0xc09a,	0xe77f, 0xc09a,		0x21, 0
	.dw 0xe7c0, 0xc09a,	0xe7ff, 0xc09a,		0x21, 0
	.dw 0xe840, 0xc09a,	0xe87f, 0xc09a,		0x21, 0
	.dw 0xe8c0, 0xc09a,	0xe8ff, 0xc09a,		0x21, 0
	.dw 0xe940, 0xc09a,	0xe97f, 0xc09a,		0x21, 0
	.dw 0xe9c0, 0xc09a,	0xe9ff, 0xc09a,		0x21, 0
	.dw 0xea40, 0xc09a,	0xea7f, 0xc09a,		0x21, 0
	.dw 0xeac0, 0xc09a,	0xeaff, 0xc09a,		0x21, 0
	.dw 0xeb40, 0xc09a,	0xeb7f, 0xc09a,		0x21, 0
	.dw 0xebc0, 0xc09a,	0xebff, 0xc09a,		0x21, 0
	.dw 0xec40, 0xc09a,	0xec7f, 0xc09a,		0x21, 0
	.dw 0xecc0, 0xc09a,	0xecff, 0xc09a,		0x21, 0
	.dw 0xed40, 0xc09a,	0xed7f, 0xc09a,		0x21, 0
	.dw 0xedc0, 0xc09a,	0xedff, 0xc09a,		0x21, 0
	.dw 0xee40, 0xc09a,	0xee7f, 0xc09a,		0x21, 0
	.dw 0xeec0, 0xc09a,	0xeeff, 0xc09a,		0x21, 0
	.dw 0xef40, 0xc09a,	0xef7f, 0xc09a,		0x21, 0
	.dw 0xefc0, 0xc09a,	0xefff, 0xc09a,		0x21, 0
	.dw 0xf040, 0xc09a,	0xf07f, 0xc09a,		0x21, 0
	.dw 0xf0c0, 0xc09a,	0xf0ff, 0xc09a,		0x21, 0
	.dw 0xf140, 0xc09a,	0xf17f, 0xc09a,		0x21, 0
	.dw 0xf1c0, 0xc09a,	0xf1ff, 0xc09a,		0x21, 0
	.dw 0xf240, 0xc09a,	0xf27f, 0xc09a,		0x21, 0
	.dw 0xf2c0, 0xc09a,	0xf2ff, 0xc09a,		0x21, 0
	.dw 0xf340, 0xc09a,	0xf37f, 0xc09a,		0x21, 0
	.dw 0xf3c0, 0xc09a,	0xf3ff, 0xc09a,		0x21, 0
	.dw 0xf440, 0xc09a,	0xf47f, 0xc09a,		0x21, 0
	.dw 0xf4c0, 0xc09a,	0xf4ff, 0xc09a,		0x21, 0
	.dw 0xf540, 0xc09a,	0xf57f, 0xc09a,		0x21, 0
	.dw 0xf5c0, 0xc09a,	0xf5ff, 0xc09a,		0x21, 0
	.dw 0xf640, 0xc09a,	0xf67f, 0xc09a,		0x21, 0
	.dw 0xf6c0, 0xc09a,	0xf6ff, 0xc09a,		0x21, 0
	.dw 0xf740, 0xc09a,	0xf77f, 0xc09a,		0x21, 0
	.dw 0xf7c0, 0xc09a,	0xf7ff, 0xc09a,		0x21, 0
	.dw 0xf840, 0xc09a,	0xf87f, 0xc09a,		0x21, 0
	.dw 0xf8c0, 0xc09a,	0xf8ff, 0xc09a,		0x21, 0
	.dw 0xf940, 0xc09a,	0xf97f, 0xc09a,		0x21, 0
	.dw 0xf9c0, 0xc09a,	0xffff, 0xc09b,		0x21, 0
	.dw 0x0040, 0xc09c,	0x007f, 0xc09c,		0x21, 0
	.dw 0x00c0, 0xc09c,	0x00ff, 0xc09c,		0x21, 0
	.dw 0x0140, 0xc09c,	0x017f, 0xc09c,		0x21, 0
	.dw 0x01c0, 0xc09c,	0x01ff, 0xc09c,		0x21, 0
	.dw 0x0240, 0xc09c,	0x027f, 0xc09c,		0x21, 0
	.dw 0x02c0, 0xc09c,	0x02ff, 0xc09c,		0x21, 0
	.dw 0x0340, 0xc09c,	0x037f, 0xc09c,		0x21, 0
	.dw 0x03c0, 0xc09c,	0x03ff, 0xc09c,		0x21, 0
	.dw 0x0440, 0xc09c,	0x047f, 0xc09c,		0x21, 0
	.dw 0x04c0, 0xc09c,	0x04ff, 0xc09c,		0x21, 0
	.dw 0x0540, 0xc09c,	0x057f, 0xc09c,		0x21, 0
	.dw 0x05c0, 0xc09c,	0x05ff, 0xc09c,		0x21, 0
	.dw 0x0640, 0xc09c,	0x067f, 0xc09c,		0x21, 0
	.dw 0x06c0, 0xc09c,	0x06ff, 0xc09c,		0x21, 0
	.dw 0x0740, 0xc09c,	0x077f, 0xc09c,		0x21, 0
	.dw 0x07c0, 0xc09c,	0x07ff, 0xc09c,		0x21, 0
	.dw 0x0840, 0xc09c,	0x087f, 0xc09c,		0x21, 0
	.dw 0x08c0, 0xc09c,	0x08ff, 0xc09c,		0x21, 0
	.dw 0x0940, 0xc09c,	0x097f, 0xc09c,		0x21, 0
	.dw 0x09c0, 0xc09c,	0x09ff, 0xc09c,		0x21, 0
	.dw 0x0a40, 0xc09c,	0x0a7f, 0xc09c,		0x21, 0
	.dw 0x0ac0, 0xc09c,	0x0aff, 0xc09c,		0x21, 0
	.dw 0x0b40, 0xc09c,	0x0b7f, 0xc09c,		0x21, 0
	.dw 0x0bc0, 0xc09c,	0x0bff, 0xc09c,		0x21, 0
	.dw 0x0c40, 0xc09c,	0x0c7f, 0xc09c,		0x21, 0
	.dw 0x0cc0, 0xc09c,	0x0cff, 0xc09c,		0x21, 0
	.dw 0x0d40, 0xc09c,	0x0d7f, 0xc09c,		0x21, 0
	.dw 0x0dc0, 0xc09c,	0x0dff, 0xc09c,		0x21, 0
	.dw 0x0e40, 0xc09c,	0x0e7f, 0xc09c,		0x21, 0
	.dw 0x0ec0, 0xc09c,	0x0eff, 0xc09c,		0x21, 0
	.dw 0x0f40, 0xc09c,	0x0f7f, 0xc09c,		0x21, 0
	.dw 0x0fc0, 0xc09c,	0x0fff, 0xc09c,		0x21, 0
	.dw 0x1040, 0xc09c,	0x107f, 0xc09c,		0x21, 0
	.dw 0x10c0, 0xc09c,	0x10ff, 0xc09c,		0x21, 0
	.dw 0x1140, 0xc09c,	0x117f, 0xc09c,		0x21, 0
	.dw 0x11c0, 0xc09c,	0x11ff, 0xc09c,		0x21, 0
	.dw 0x1240, 0xc09c,	0x127f, 0xc09c,		0x21, 0
	.dw 0x12c0, 0xc09c,	0x12ff, 0xc09c,		0x21, 0
	.dw 0x1340, 0xc09c,	0x137f, 0xc09c,		0x21, 0
	.dw 0x13c0, 0xc09c,	0x13ff, 0xc09c,		0x21, 0
	.dw 0x1440, 0xc09c,	0x147f, 0xc09c,		0x21, 0
	.dw 0x14c0, 0xc09c,	0x14ff, 0xc09c,		0x21, 0
	.dw 0x1540, 0xc09c,	0x157f, 0xc09c,		0x21, 0
	.dw 0x15c0, 0xc09c,	0x15ff, 0xc09c,		0x21, 0
	.dw 0x1640, 0xc09c,	0x167f, 0xc09c,		0x21, 0
	.dw 0x16c0, 0xc09c,	0x16ff, 0xc09c,		0x21, 0
	.dw 0x1740, 0xc09c,	0x177f, 0xc09c,		0x21, 0
	.dw 0x17c0, 0xc09c,	0x17ff, 0xc09c,		0x21, 0
	.dw 0x1840, 0xc09c,	0x187f, 0xc09c,		0x21, 0
	.dw 0x18c0, 0xc09c,	0x18ff, 0xc09c,		0x21, 0
	.dw 0x1940, 0xc09c,	0x197f, 0xc09c,		0x21, 0
	.dw 0x19c0, 0xc09c,	0x1fff, 0xc09c,		0x21, 0
	.dw 0x2040, 0xc09c,	0x207f, 0xc09c,		0x21, 0
	.dw 0x20c0, 0xc09c,	0x20ff, 0xc09c,		0x21, 0
	.dw 0x2140, 0xc09c,	0x217f, 0xc09c,		0x21, 0
	.dw 0x21c0, 0xc09c,	0x21ff, 0xc09c,		0x21, 0
	.dw 0x2240, 0xc09c,	0x227f, 0xc09c,		0x21, 0
	.dw 0x22c0, 0xc09c,	0x22ff, 0xc09c,		0x21, 0
	.dw 0x2340, 0xc09c,	0x237f, 0xc09c,		0x21, 0
	.dw 0x23c0, 0xc09c,	0x23ff, 0xc09c,		0x21, 0
	.dw 0x2440, 0xc09c,	0x247f, 0xc09c,		0x21, 0
	.dw 0x24c0, 0xc09c,	0x24ff, 0xc09c,		0x21, 0
	.dw 0x2540, 0xc09c,	0x257f, 0xc09c,		0x21, 0
	.dw 0x25c0, 0xc09c,	0x25ff, 0xc09c,		0x21, 0
	.dw 0x2640, 0xc09c,	0x267f, 0xc09c,		0x21, 0
	.dw 0x26c0, 0xc09c,	0x26ff, 0xc09c,		0x21, 0
	.dw 0x2740, 0xc09c,	0x277f, 0xc09c,		0x21, 0
	.dw 0x27c0, 0xc09c,	0x27ff, 0xc09c,		0x21, 0
	.dw 0x2840, 0xc09c,	0x287f, 0xc09c,		0x21, 0
	.dw 0x28c0, 0xc09c,	0x28ff, 0xc09c,		0x21, 0
	.dw 0x2940, 0xc09c,	0x297f, 0xc09c,		0x21, 0
	.dw 0x29c0, 0xc09c,	0x29ff, 0xc09c,		0x21, 0
	.dw 0x2a40, 0xc09c,	0x2a7f, 0xc09c,		0x21, 0
	.dw 0x2ac0, 0xc09c,	0x2aff, 0xc09c,		0x21, 0
	.dw 0x2b40, 0xc09c,	0x2b7f, 0xc09c,		0x21, 0
	.dw 0x2bc0, 0xc09c,	0x2bff, 0xc09c,		0x21, 0
	.dw 0x2c40, 0xc09c,	0x2c7f, 0xc09c,		0x21, 0
	.dw 0x2cc0, 0xc09c,	0x2cff, 0xc09c,		0x21, 0
	.dw 0x2d40, 0xc09c,	0x2d7f, 0xc09c,		0x21, 0
	.dw 0x2dc0, 0xc09c,	0x2dff, 0xc09c,		0x21, 0
	.dw 0x2e40, 0xc09c,	0x2e7f, 0xc09c,		0x21, 0
	.dw 0x2ec0, 0xc09c,	0x2eff, 0xc09c,		0x21, 0
	.dw 0x2f40, 0xc09c,	0x2f7f, 0xc09c,		0x21, 0
	.dw 0x2fc0, 0xc09c,	0x2fff, 0xc09c,		0x21, 0
	.dw 0x3040, 0xc09c,	0x307f, 0xc09c,		0x21, 0
	.dw 0x30c0, 0xc09c,	0x30ff, 0xc09c,		0x21, 0
	.dw 0x3140, 0xc09c,	0x317f, 0xc09c,		0x21, 0
	.dw 0x31c0, 0xc09c,	0x31ff, 0xc09c,		0x21, 0
	.dw 0x3240, 0xc09c,	0x327f, 0xc09c,		0x21, 0
	.dw 0x32c0, 0xc09c,	0x32ff, 0xc09c,		0x21, 0
	.dw 0x3340, 0xc09c,	0x337f, 0xc09c,		0x21, 0
	.dw 0x33c0, 0xc09c,	0x33ff, 0xc09c,		0x21, 0
	.dw 0x3440, 0xc09c,	0x347f, 0xc09c,		0x21, 0
	.dw 0x34c0, 0xc09c,	0x34ff, 0xc09c,		0x21, 0
	.dw 0x3540, 0xc09c,	0x357f, 0xc09c,		0x21, 0
	.dw 0x35c0, 0xc09c,	0x35ff, 0xc09c,		0x21, 0
	.dw 0x3640, 0xc09c,	0x367f, 0xc09c,		0x21, 0
	.dw 0x36c0, 0xc09c,	0x36ff, 0xc09c,		0x21, 0
	.dw 0x3740, 0xc09c,	0x377f, 0xc09c,		0x21, 0
	.dw 0x37c0, 0xc09c,	0x37ff, 0xc09c,		0x21, 0
	.dw 0x3840, 0xc09c,	0x387f, 0xc09c,		0x21, 0
	.dw 0x38c0, 0xc09c,	0x38ff, 0xc09c,		0x21, 0
	.dw 0x3940, 0xc09c,	0x397f, 0xc09c,		0x21, 0
	.dw 0x39c0, 0xc09c,	0x3fff, 0xc09c,		0x21, 0
	.dw 0x4040, 0xc09c,	0x407f, 0xc09c,		0x21, 0
	.dw 0x40c0, 0xc09c,	0x40ff, 0xc09c,		0x21, 0
	.dw 0x4140, 0xc09c,	0x417f, 0xc09c,		0x21, 0
	.dw 0x41c0, 0xc09c,	0x41ff, 0xc09c,		0x21, 0
	.dw 0x4240, 0xc09c,	0x427f, 0xc09c,		0x21, 0
	.dw 0x42c0, 0xc09c,	0x42ff, 0xc09c,		0x21, 0
	.dw 0x4340, 0xc09c,	0x437f, 0xc09c,		0x21, 0
	.dw 0x43c0, 0xc09c,	0x43ff, 0xc09c,		0x21, 0
	.dw 0x4440, 0xc09c,	0x447f, 0xc09c,		0x21, 0
	.dw 0x44c0, 0xc09c,	0x44ff, 0xc09c,		0x21, 0
	.dw 0x4540, 0xc09c,	0x457f, 0xc09c,		0x21, 0
	.dw 0x45c0, 0xc09c,	0x45ff, 0xc09c,		0x21, 0
	.dw 0x4640, 0xc09c,	0x467f, 0xc09c,		0x21, 0
	.dw 0x46c0, 0xc09c,	0x46ff, 0xc09c,		0x21, 0
	.dw 0x4740, 0xc09c,	0x477f, 0xc09c,		0x21, 0
	.dw 0x47c0, 0xc09c,	0x47ff, 0xc09c,		0x21, 0
	.dw 0x4840, 0xc09c,	0x487f, 0xc09c,		0x21, 0
	.dw 0x48c0, 0xc09c,	0x48ff, 0xc09c,		0x21, 0
	.dw 0x4940, 0xc09c,	0x497f, 0xc09c,		0x21, 0
	.dw 0x49c0, 0xc09c,	0x49ff, 0xc09c,		0x21, 0
	.dw 0x4a40, 0xc09c,	0x4a7f, 0xc09c,		0x21, 0
	.dw 0x4ac0, 0xc09c,	0x4aff, 0xc09c,		0x21, 0
	.dw 0x4b40, 0xc09c,	0x4b7f, 0xc09c,		0x21, 0
	.dw 0x4bc0, 0xc09c,	0x4bff, 0xc09c,		0x21, 0
	.dw 0x4c40, 0xc09c,	0x4c7f, 0xc09c,		0x21, 0
	.dw 0x4cc0, 0xc09c,	0x4cff, 0xc09c,		0x21, 0
	.dw 0x4d40, 0xc09c,	0x4d7f, 0xc09c,		0x21, 0
	.dw 0x4dc0, 0xc09c,	0x4dff, 0xc09c,		0x21, 0
	.dw 0x4e40, 0xc09c,	0x4e7f, 0xc09c,		0x21, 0
	.dw 0x4ec0, 0xc09c,	0x4eff, 0xc09c,		0x21, 0
	.dw 0x4f40, 0xc09c,	0x4f7f, 0xc09c,		0x21, 0
	.dw 0x4fc0, 0xc09c,	0x4fff, 0xc09c,		0x21, 0
	.dw 0x5040, 0xc09c,	0x507f, 0xc09c,		0x21, 0
	.dw 0x50c0, 0xc09c,	0x50ff, 0xc09c,		0x21, 0
	.dw 0x5140, 0xc09c,	0x517f, 0xc09c,		0x21, 0
	.dw 0x51c0, 0xc09c,	0x51ff, 0xc09c,		0x21, 0
	.dw 0x5240, 0xc09c,	0x527f, 0xc09c,		0x21, 0
	.dw 0x52c0, 0xc09c,	0x52ff, 0xc09c,		0x21, 0
	.dw 0x5340, 0xc09c,	0x537f, 0xc09c,		0x21, 0
	.dw 0x53c0, 0xc09c,	0x53ff, 0xc09c,		0x21, 0
	.dw 0x5440, 0xc09c,	0x547f, 0xc09c,		0x21, 0
	.dw 0x54c0, 0xc09c,	0x54ff, 0xc09c,		0x21, 0
	.dw 0x5540, 0xc09c,	0x557f, 0xc09c,		0x21, 0
	.dw 0x55c0, 0xc09c,	0x55ff, 0xc09c,		0x21, 0
	.dw 0x5640, 0xc09c,	0x567f, 0xc09c,		0x21, 0
	.dw 0x56c0, 0xc09c,	0x56ff, 0xc09c,		0x21, 0
	.dw 0x5740, 0xc09c,	0x577f, 0xc09c,		0x21, 0
	.dw 0x57c0, 0xc09c,	0x57ff, 0xc09c,		0x21, 0
	.dw 0x5840, 0xc09c,	0x587f, 0xc09c,		0x21, 0
	.dw 0x58c0, 0xc09c,	0x58ff, 0xc09c,		0x21, 0
	.dw 0x5940, 0xc09c,	0x597f, 0xc09c,		0x21, 0
	.dw 0x59c0, 0xc09c,	0x5fff, 0xc09c,		0x21, 0
	.dw 0x6040, 0xc09c,	0x607f, 0xc09c,		0x21, 0
	.dw 0x60c0, 0xc09c,	0x60ff, 0xc09c,		0x21, 0
	.dw 0x6140, 0xc09c,	0x617f, 0xc09c,		0x21, 0
	.dw 0x61c0, 0xc09c,	0x61ff, 0xc09c,		0x21, 0
	.dw 0x6240, 0xc09c,	0x627f, 0xc09c,		0x21, 0
	.dw 0x62c0, 0xc09c,	0x62ff, 0xc09c,		0x21, 0
	.dw 0x6340, 0xc09c,	0x637f, 0xc09c,		0x21, 0
	.dw 0x63c0, 0xc09c,	0x63ff, 0xc09c,		0x21, 0
	.dw 0x6440, 0xc09c,	0x647f, 0xc09c,		0x21, 0
	.dw 0x64c0, 0xc09c,	0x64ff, 0xc09c,		0x21, 0
	.dw 0x6540, 0xc09c,	0x657f, 0xc09c,		0x21, 0
	.dw 0x65c0, 0xc09c,	0x65ff, 0xc09c,		0x21, 0
	.dw 0x6640, 0xc09c,	0x667f, 0xc09c,		0x21, 0
	.dw 0x66c0, 0xc09c,	0x66ff, 0xc09c,		0x21, 0
	.dw 0x6740, 0xc09c,	0x677f, 0xc09c,		0x21, 0
	.dw 0x67c0, 0xc09c,	0x67ff, 0xc09c,		0x21, 0
	.dw 0x6840, 0xc09c,	0x687f, 0xc09c,		0x21, 0
	.dw 0x68c0, 0xc09c,	0x68ff, 0xc09c,		0x21, 0
	.dw 0x6940, 0xc09c,	0x697f, 0xc09c,		0x21, 0
	.dw 0x69c0, 0xc09c,	0x69ff, 0xc09c,		0x21, 0
	.dw 0x6a40, 0xc09c,	0x6a7f, 0xc09c,		0x21, 0
	.dw 0x6ac0, 0xc09c,	0x6aff, 0xc09c,		0x21, 0
	.dw 0x6b40, 0xc09c,	0x6b7f, 0xc09c,		0x21, 0
	.dw 0x6bc0, 0xc09c,	0x6bff, 0xc09c,		0x21, 0
	.dw 0x6c40, 0xc09c,	0x6c7f, 0xc09c,		0x21, 0
	.dw 0x6cc0, 0xc09c,	0x6cff, 0xc09c,		0x21, 0
	.dw 0x6d40, 0xc09c,	0x6d7f, 0xc09c,		0x21, 0
	.dw 0x6dc0, 0xc09c,	0x6dff, 0xc09c,		0x21, 0
	.dw 0x6e40, 0xc09c,	0x6e7f, 0xc09c,		0x21, 0
	.dw 0x6ec0, 0xc09c,	0x6eff, 0xc09c,		0x21, 0
	.dw 0x6f40, 0xc09c,	0x6f7f, 0xc09c,		0x21, 0
	.dw 0x6fc0, 0xc09c,	0x6fff, 0xc09c,		0x21, 0
	.dw 0x7040, 0xc09c,	0x707f, 0xc09c,		0x21, 0
	.dw 0x70c0, 0xc09c,	0x70ff, 0xc09c,		0x21, 0
	.dw 0x7140, 0xc09c,	0x717f, 0xc09c,		0x21, 0
	.dw 0x71c0, 0xc09c,	0x71ff, 0xc09c,		0x21, 0
	.dw 0x7240, 0xc09c,	0x727f, 0xc09c,		0x21, 0
	.dw 0x72c0, 0xc09c,	0x72ff, 0xc09c,		0x21, 0
	.dw 0x7340, 0xc09c,	0x737f, 0xc09c,		0x21, 0
	.dw 0x73c0, 0xc09c,	0x73ff, 0xc09c,		0x21, 0
	.dw 0x7440, 0xc09c,	0x747f, 0xc09c,		0x21, 0
	.dw 0x74c0, 0xc09c,	0x74ff, 0xc09c,		0x21, 0
	.dw 0x7540, 0xc09c,	0x757f, 0xc09c,		0x21, 0
	.dw 0x75c0, 0xc09c,	0x75ff, 0xc09c,		0x21, 0
	.dw 0x7640, 0xc09c,	0x767f, 0xc09c,		0x21, 0
	.dw 0x76c0, 0xc09c,	0x76ff, 0xc09c,		0x21, 0
	.dw 0x7740, 0xc09c,	0x777f, 0xc09c,		0x21, 0
	.dw 0x77c0, 0xc09c,	0x77ff, 0xc09c,		0x21, 0
	.dw 0x7840, 0xc09c,	0x787f, 0xc09c,		0x21, 0
	.dw 0x78c0, 0xc09c,	0x78ff, 0xc09c,		0x21, 0
	.dw 0x7940, 0xc09c,	0x797f, 0xc09c,		0x21, 0
	.dw 0x79c0, 0xc09c,	0x7fff, 0xc09c,		0x21, 0
	.dw 0x8040, 0xc09c,	0x807f, 0xc09c,		0x21, 0
	.dw 0x80c0, 0xc09c,	0x80ff, 0xc09c,		0x21, 0
	.dw 0x8140, 0xc09c,	0x817f, 0xc09c,		0x21, 0
	.dw 0x81c0, 0xc09c,	0x81ff, 0xc09c,		0x21, 0
	.dw 0x8240, 0xc09c,	0x827f, 0xc09c,		0x21, 0
	.dw 0x82c0, 0xc09c,	0x82ff, 0xc09c,		0x21, 0
	.dw 0x8340, 0xc09c,	0x837f, 0xc09c,		0x21, 0
	.dw 0x83c0, 0xc09c,	0x83ff, 0xc09c,		0x21, 0
	.dw 0x8440, 0xc09c,	0x847f, 0xc09c,		0x21, 0
	.dw 0x84c0, 0xc09c,	0x84ff, 0xc09c,		0x21, 0
	.dw 0x8540, 0xc09c,	0x857f, 0xc09c,		0x21, 0
	.dw 0x85c0, 0xc09c,	0x85ff, 0xc09c,		0x21, 0
	.dw 0x8640, 0xc09c,	0x867f, 0xc09c,		0x21, 0
	.dw 0x86c0, 0xc09c,	0x86ff, 0xc09c,		0x21, 0
	.dw 0x8740, 0xc09c,	0x877f, 0xc09c,		0x21, 0
	.dw 0x87c0, 0xc09c,	0x87ff, 0xc09c,		0x21, 0
	.dw 0x8840, 0xc09c,	0x887f, 0xc09c,		0x21, 0
	.dw 0x88c0, 0xc09c,	0x88ff, 0xc09c,		0x21, 0
	.dw 0x8940, 0xc09c,	0x897f, 0xc09c,		0x21, 0
	.dw 0x89c0, 0xc09c,	0x89ff, 0xc09c,		0x21, 0
	.dw 0x8a40, 0xc09c,	0x8a7f, 0xc09c,		0x21, 0
	.dw 0x8ac0, 0xc09c,	0x8aff, 0xc09c,		0x21, 0
	.dw 0x8b40, 0xc09c,	0x8b7f, 0xc09c,		0x21, 0
	.dw 0x8bc0, 0xc09c,	0x8bff, 0xc09c,		0x21, 0
	.dw 0x8c40, 0xc09c,	0x8c7f, 0xc09c,		0x21, 0
	.dw 0x8cc0, 0xc09c,	0x8cff, 0xc09c,		0x21, 0
	.dw 0x8d40, 0xc09c,	0x8d7f, 0xc09c,		0x21, 0
	.dw 0x8dc0, 0xc09c,	0x8dff, 0xc09c,		0x21, 0
	.dw 0x8e40, 0xc09c,	0x8e7f, 0xc09c,		0x21, 0
	.dw 0x8ec0, 0xc09c,	0x8eff, 0xc09c,		0x21, 0
	.dw 0x8f40, 0xc09c,	0x8f7f, 0xc09c,		0x21, 0
	.dw 0x8fc0, 0xc09c,	0x8fff, 0xc09c,		0x21, 0
	.dw 0x9040, 0xc09c,	0x907f, 0xc09c,		0x21, 0
	.dw 0x90c0, 0xc09c,	0x90ff, 0xc09c,		0x21, 0
	.dw 0x9140, 0xc09c,	0x917f, 0xc09c,		0x21, 0
	.dw 0x91c0, 0xc09c,	0x91ff, 0xc09c,		0x21, 0
	.dw 0x9240, 0xc09c,	0x927f, 0xc09c,		0x21, 0
	.dw 0x92c0, 0xc09c,	0x92ff, 0xc09c,		0x21, 0
	.dw 0x9340, 0xc09c,	0x937f, 0xc09c,		0x21, 0
	.dw 0x93c0, 0xc09c,	0x93ff, 0xc09c,		0x21, 0
	.dw 0x9440, 0xc09c,	0x947f, 0xc09c,		0x21, 0
	.dw 0x94c0, 0xc09c,	0x94ff, 0xc09c,		0x21, 0
	.dw 0x9540, 0xc09c,	0x957f, 0xc09c,		0x21, 0
	.dw 0x95c0, 0xc09c,	0x95ff, 0xc09c,		0x21, 0
	.dw 0x9640, 0xc09c,	0x967f, 0xc09c,		0x21, 0
	.dw 0x96c0, 0xc09c,	0x96ff, 0xc09c,		0x21, 0
	.dw 0x9740, 0xc09c,	0x977f, 0xc09c,		0x21, 0
	.dw 0x97c0, 0xc09c,	0x97ff, 0xc09c,		0x21, 0
	.dw 0x9840, 0xc09c,	0x987f, 0xc09c,		0x21, 0
	.dw 0x98c0, 0xc09c,	0x98ff, 0xc09c,		0x21, 0
	.dw 0x9940, 0xc09c,	0x997f, 0xc09c,		0x21, 0
	.dw 0x99c0, 0xc09c,	0x9fff, 0xc09c,		0x21, 0
	.dw 0xa040, 0xc09c,	0xa07f, 0xc09c,		0x21, 0
	.dw 0xa0c0, 0xc09c,	0xa0ff, 0xc09c,		0x21, 0
	.dw 0xa140, 0xc09c,	0xa17f, 0xc09c,		0x21, 0
	.dw 0xa1c0, 0xc09c,	0xa1ff, 0xc09c,		0x21, 0
	.dw 0xa240, 0xc09c,	0xa27f, 0xc09c,		0x21, 0
	.dw 0xa2c0, 0xc09c,	0xa2ff, 0xc09c,		0x21, 0
	.dw 0xa340, 0xc09c,	0xa37f, 0xc09c,		0x21, 0
	.dw 0xa3c0, 0xc09c,	0xa3ff, 0xc09c,		0x21, 0
	.dw 0xa440, 0xc09c,	0xa47f, 0xc09c,		0x21, 0
	.dw 0xa4c0, 0xc09c,	0xa4ff, 0xc09c,		0x21, 0
	.dw 0xa540, 0xc09c,	0xa57f, 0xc09c,		0x21, 0
	.dw 0xa5c0, 0xc09c,	0xa5ff, 0xc09c,		0x21, 0
	.dw 0xa640, 0xc09c,	0xa67f, 0xc09c,		0x21, 0
	.dw 0xa6c0, 0xc09c,	0xa6ff, 0xc09c,		0x21, 0
	.dw 0xa740, 0xc09c,	0xa77f, 0xc09c,		0x21, 0
	.dw 0xa7c0, 0xc09c,	0xa7ff, 0xc09c,		0x21, 0
	.dw 0xa840, 0xc09c,	0xa87f, 0xc09c,		0x21, 0
	.dw 0xa8c0, 0xc09c,	0xa8ff, 0xc09c,		0x21, 0
	.dw 0xa940, 0xc09c,	0xa97f, 0xc09c,		0x21, 0
	.dw 0xa9c0, 0xc09c,	0xa9ff, 0xc09c,		0x21, 0
	.dw 0xaa40, 0xc09c,	0xaa7f, 0xc09c,		0x21, 0
	.dw 0xaac0, 0xc09c,	0xaaff, 0xc09c,		0x21, 0
	.dw 0xab40, 0xc09c,	0xab7f, 0xc09c,		0x21, 0
	.dw 0xabc0, 0xc09c,	0xabff, 0xc09c,		0x21, 0
	.dw 0xac40, 0xc09c,	0xac7f, 0xc09c,		0x21, 0
	.dw 0xacc0, 0xc09c,	0xacff, 0xc09c,		0x21, 0
	.dw 0xad40, 0xc09c,	0xad7f, 0xc09c,		0x21, 0
	.dw 0xadc0, 0xc09c,	0xadff, 0xc09c,		0x21, 0
	.dw 0xae40, 0xc09c,	0xae7f, 0xc09c,		0x21, 0
	.dw 0xaec0, 0xc09c,	0xaeff, 0xc09c,		0x21, 0
	.dw 0xaf40, 0xc09c,	0xaf7f, 0xc09c,		0x21, 0
	.dw 0xafc0, 0xc09c,	0xafff, 0xc09c,		0x21, 0
	.dw 0xb040, 0xc09c,	0xb07f, 0xc09c,		0x21, 0
	.dw 0xb0c0, 0xc09c,	0xb0ff, 0xc09c,		0x21, 0
	.dw 0xb140, 0xc09c,	0xb17f, 0xc09c,		0x21, 0
	.dw 0xb1c0, 0xc09c,	0xb1ff, 0xc09c,		0x21, 0
	.dw 0xb240, 0xc09c,	0xb27f, 0xc09c,		0x21, 0
	.dw 0xb2c0, 0xc09c,	0xb2ff, 0xc09c,		0x21, 0
	.dw 0xb340, 0xc09c,	0xb37f, 0xc09c,		0x21, 0
	.dw 0xb3c0, 0xc09c,	0xb3ff, 0xc09c,		0x21, 0
	.dw 0xb440, 0xc09c,	0xb47f, 0xc09c,		0x21, 0
	.dw 0xb4c0, 0xc09c,	0xb4ff, 0xc09c,		0x21, 0
	.dw 0xb540, 0xc09c,	0xb57f, 0xc09c,		0x21, 0
	.dw 0xb5c0, 0xc09c,	0xb5ff, 0xc09c,		0x21, 0
	.dw 0xb640, 0xc09c,	0xb67f, 0xc09c,		0x21, 0
	.dw 0xb6c0, 0xc09c,	0xb6ff, 0xc09c,		0x21, 0
	.dw 0xb740, 0xc09c,	0xb77f, 0xc09c,		0x21, 0
	.dw 0xb7c0, 0xc09c,	0xb7ff, 0xc09c,		0x21, 0
	.dw 0xb840, 0xc09c,	0xb87f, 0xc09c,		0x21, 0
	.dw 0xb8c0, 0xc09c,	0xb8ff, 0xc09c,		0x21, 0
	.dw 0xb940, 0xc09c,	0xb97f, 0xc09c,		0x21, 0
	.dw 0xb9c0, 0xc09c,	0xbfff, 0xc09c,		0x21, 0
	.dw 0xc040, 0xc09c,	0xc07f, 0xc09c,		0x21, 0
	.dw 0xc0c0, 0xc09c,	0xc0ff, 0xc09c,		0x21, 0
	.dw 0xc140, 0xc09c,	0xc17f, 0xc09c,		0x21, 0
	.dw 0xc1c0, 0xc09c,	0xc1ff, 0xc09c,		0x21, 0
	.dw 0xc240, 0xc09c,	0xc27f, 0xc09c,		0x21, 0
	.dw 0xc2c0, 0xc09c,	0xc2ff, 0xc09c,		0x21, 0
	.dw 0xc340, 0xc09c,	0xc37f, 0xc09c,		0x21, 0
	.dw 0xc3c0, 0xc09c,	0xc3ff, 0xc09c,		0x21, 0
	.dw 0xc440, 0xc09c,	0xc47f, 0xc09c,		0x21, 0
	.dw 0xc4c0, 0xc09c,	0xc4ff, 0xc09c,		0x21, 0
	.dw 0xc540, 0xc09c,	0xc57f, 0xc09c,		0x21, 0
	.dw 0xc5c0, 0xc09c,	0xc5ff, 0xc09c,		0x21, 0
	.dw 0xc640, 0xc09c,	0xc67f, 0xc09c,		0x21, 0
	.dw 0xc6c0, 0xc09c,	0xc6ff, 0xc09c,		0x21, 0
	.dw 0xc740, 0xc09c,	0xc77f, 0xc09c,		0x21, 0
	.dw 0xc7c0, 0xc09c,	0xc7ff, 0xc09c,		0x21, 0
	.dw 0xc840, 0xc09c,	0xc87f, 0xc09c,		0x21, 0
	.dw 0xc8c0, 0xc09c,	0xc8ff, 0xc09c,		0x21, 0
	.dw 0xc940, 0xc09c,	0xc97f, 0xc09c,		0x21, 0
	.dw 0xc9c0, 0xc09c,	0xc9ff, 0xc09c,		0x21, 0
	.dw 0xca40, 0xc09c,	0xca7f, 0xc09c,		0x21, 0
	.dw 0xcac0, 0xc09c,	0xcaff, 0xc09c,		0x21, 0
	.dw 0xcb40, 0xc09c,	0xcb7f, 0xc09c,		0x21, 0
	.dw 0xcbc0, 0xc09c,	0xcbff, 0xc09c,		0x21, 0
	.dw 0xcc40, 0xc09c,	0xcc7f, 0xc09c,		0x21, 0
	.dw 0xccc0, 0xc09c,	0xccff, 0xc09c,		0x21, 0
	.dw 0xcd40, 0xc09c,	0xcd7f, 0xc09c,		0x21, 0
	.dw 0xcdc0, 0xc09c,	0xcdff, 0xc09c,		0x21, 0
	.dw 0xce40, 0xc09c,	0xce7f, 0xc09c,		0x21, 0
	.dw 0xcec0, 0xc09c,	0xceff, 0xc09c,		0x21, 0
	.dw 0xcf40, 0xc09c,	0xcf7f, 0xc09c,		0x21, 0
	.dw 0xcfc0, 0xc09c,	0xcfff, 0xc09c,		0x21, 0
	.dw 0xd040, 0xc09c,	0xd07f, 0xc09c,		0x21, 0
	.dw 0xd0c0, 0xc09c,	0xd0ff, 0xc09c,		0x21, 0
	.dw 0xd140, 0xc09c,	0xd17f, 0xc09c,		0x21, 0
	.dw 0xd1c0, 0xc09c,	0xd1ff, 0xc09c,		0x21, 0
	.dw 0xd240, 0xc09c,	0xd27f, 0xc09c,		0x21, 0
	.dw 0xd2c0, 0xc09c,	0xd2ff, 0xc09c,		0x21, 0
	.dw 0xd340, 0xc09c,	0xd37f, 0xc09c,		0x21, 0
	.dw 0xd3c0, 0xc09c,	0xd3ff, 0xc09c,		0x21, 0
	.dw 0xd440, 0xc09c,	0xd47f, 0xc09c,		0x21, 0
	.dw 0xd4c0, 0xc09c,	0xd4ff, 0xc09c,		0x21, 0
	.dw 0xd540, 0xc09c,	0xd57f, 0xc09c,		0x21, 0
	.dw 0xd5c0, 0xc09c,	0xd5ff, 0xc09c,		0x21, 0
	.dw 0xd640, 0xc09c,	0xd67f, 0xc09c,		0x21, 0
	.dw 0xd6c0, 0xc09c,	0xd6ff, 0xc09c,		0x21, 0
	.dw 0xd740, 0xc09c,	0xd77f, 0xc09c,		0x21, 0
	.dw 0xd7c0, 0xc09c,	0xd7ff, 0xc09c,		0x21, 0
	.dw 0xd840, 0xc09c,	0xd87f, 0xc09c,		0x21, 0
	.dw 0xd8c0, 0xc09c,	0xd8ff, 0xc09c,		0x21, 0
	.dw 0xd940, 0xc09c,	0xd97f, 0xc09c,		0x21, 0
	.dw 0xd9c0, 0xc09c,	0xdfff, 0xc09c,		0x21, 0
	.dw 0xe040, 0xc09c,	0xe07f, 0xc09c,		0x21, 0
	.dw 0xe0c0, 0xc09c,	0xe0ff, 0xc09c,		0x21, 0
	.dw 0xe140, 0xc09c,	0xe17f, 0xc09c,		0x21, 0
	.dw 0xe1c0, 0xc09c,	0xe1ff, 0xc09c,		0x21, 0
	.dw 0xe240, 0xc09c,	0xe27f, 0xc09c,		0x21, 0
	.dw 0xe2c0, 0xc09c,	0xe2ff, 0xc09c,		0x21, 0
	.dw 0xe340, 0xc09c,	0xe37f, 0xc09c,		0x21, 0
	.dw 0xe3c0, 0xc09c,	0xe3ff, 0xc09c,		0x21, 0
	.dw 0xe440, 0xc09c,	0xe47f, 0xc09c,		0x21, 0
	.dw 0xe4c0, 0xc09c,	0xe4ff, 0xc09c,		0x21, 0
	.dw 0xe540, 0xc09c,	0xe57f, 0xc09c,		0x21, 0
	.dw 0xe5c0, 0xc09c,	0xe5ff, 0xc09c,		0x21, 0
	.dw 0xe640, 0xc09c,	0xe67f, 0xc09c,		0x21, 0
	.dw 0xe6c0, 0xc09c,	0xe6ff, 0xc09c,		0x21, 0
	.dw 0xe740, 0xc09c,	0xe77f, 0xc09c,		0x21, 0
	.dw 0xe7c0, 0xc09c,	0xe7ff, 0xc09c,		0x21, 0
	.dw 0xe840, 0xc09c,	0xe87f, 0xc09c,		0x21, 0
	.dw 0xe8c0, 0xc09c,	0xe8ff, 0xc09c,		0x21, 0
	.dw 0xe940, 0xc09c,	0xe97f, 0xc09c,		0x21, 0
	.dw 0xe9c0, 0xc09c,	0xe9ff, 0xc09c,		0x21, 0
	.dw 0xea40, 0xc09c,	0xea7f, 0xc09c,		0x21, 0
	.dw 0xeac0, 0xc09c,	0xeaff, 0xc09c,		0x21, 0
	.dw 0xeb40, 0xc09c,	0xeb7f, 0xc09c,		0x21, 0
	.dw 0xebc0, 0xc09c,	0xebff, 0xc09c,		0x21, 0
	.dw 0xec40, 0xc09c,	0xec7f, 0xc09c,		0x21, 0
	.dw 0xecc0, 0xc09c,	0xecff, 0xc09c,		0x21, 0
	.dw 0xed40, 0xc09c,	0xed7f, 0xc09c,		0x21, 0
	.dw 0xedc0, 0xc09c,	0xedff, 0xc09c,		0x21, 0
	.dw 0xee40, 0xc09c,	0xee7f, 0xc09c,		0x21, 0
	.dw 0xeec0, 0xc09c,	0xeeff, 0xc09c,		0x21, 0
	.dw 0xef40, 0xc09c,	0xef7f, 0xc09c,		0x21, 0
	.dw 0xefc0, 0xc09c,	0xefff, 0xc09c,		0x21, 0
	.dw 0xf040, 0xc09c,	0xf07f, 0xc09c,		0x21, 0
	.dw 0xf0c0, 0xc09c,	0xf0ff, 0xc09c,		0x21, 0
	.dw 0xf140, 0xc09c,	0xf17f, 0xc09c,		0x21, 0
	.dw 0xf1c0, 0xc09c,	0xf1ff, 0xc09c,		0x21, 0
	.dw 0xf240, 0xc09c,	0xf27f, 0xc09c,		0x21, 0
	.dw 0xf2c0, 0xc09c,	0xf2ff, 0xc09c,		0x21, 0
	.dw 0xf340, 0xc09c,	0xf37f, 0xc09c,		0x21, 0
	.dw 0xf3c0, 0xc09c,	0xf3ff, 0xc09c,		0x21, 0
	.dw 0xf440, 0xc09c,	0xf47f, 0xc09c,		0x21, 0
	.dw 0xf4c0, 0xc09c,	0xf4ff, 0xc09c,		0x21, 0
	.dw 0xf540, 0xc09c,	0xf57f, 0xc09c,		0x21, 0
	.dw 0xf5c0, 0xc09c,	0xf5ff, 0xc09c,		0x21, 0
	.dw 0xf640, 0xc09c,	0xf67f, 0xc09c,		0x21, 0
	.dw 0xf6c0, 0xc09c,	0xf6ff, 0xc09c,		0x21, 0
	.dw 0xf740, 0xc09c,	0xf77f, 0xc09c,		0x21, 0
	.dw 0xf7c0, 0xc09c,	0xf7ff, 0xc09c,		0x21, 0
	.dw 0xf840, 0xc09c,	0xf87f, 0xc09c,		0x21, 0
	.dw 0xf8c0, 0xc09c,	0xf8ff, 0xc09c,		0x21, 0
	.dw 0xf940, 0xc09c,	0xf97f, 0xc09c,		0x21, 0
	.dw 0xf9c0, 0xc09c,	0xffff, 0xc09c,		0x21, 0
	.dw 0x0040, 0xc09d,	0x007f, 0xc09d,		0x21, 0
	.dw 0x00c0, 0xc09d,	0x00ff, 0xc09d,		0x21, 0
	.dw 0x0140, 0xc09d,	0x017f, 0xc09d,		0x21, 0
	.dw 0x01c0, 0xc09d,	0x01ff, 0xc09d,		0x21, 0
	.dw 0x0240, 0xc09d,	0x027f, 0xc09d,		0x21, 0
	.dw 0x02c0, 0xc09d,	0x02ff, 0xc09d,		0x21, 0
	.dw 0x0340, 0xc09d,	0x037f, 0xc09d,		0x21, 0
	.dw 0x03c0, 0xc09d,	0x03ff, 0xc09d,		0x21, 0
	.dw 0x0440, 0xc09d,	0x047f, 0xc09d,		0x21, 0
	.dw 0x04c0, 0xc09d,	0x04ff, 0xc09d,		0x21, 0
	.dw 0x0540, 0xc09d,	0x057f, 0xc09d,		0x21, 0
	.dw 0x05c0, 0xc09d,	0x05ff, 0xc09d,		0x21, 0
	.dw 0x0640, 0xc09d,	0x067f, 0xc09d,		0x21, 0
	.dw 0x06c0, 0xc09d,	0x06ff, 0xc09d,		0x21, 0
	.dw 0x0740, 0xc09d,	0x077f, 0xc09d,		0x21, 0
	.dw 0x07c0, 0xc09d,	0x07ff, 0xc09d,		0x21, 0
	.dw 0x0840, 0xc09d,	0x087f, 0xc09d,		0x21, 0
	.dw 0x08c0, 0xc09d,	0x08ff, 0xc09d,		0x21, 0
	.dw 0x0940, 0xc09d,	0x097f, 0xc09d,		0x21, 0
	.dw 0x09c0, 0xc09d,	0x09ff, 0xc09d,		0x21, 0
	.dw 0x0a40, 0xc09d,	0x0a7f, 0xc09d,		0x21, 0
	.dw 0x0ac0, 0xc09d,	0x0aff, 0xc09d,		0x21, 0
	.dw 0x0b40, 0xc09d,	0x0b7f, 0xc09d,		0x21, 0
	.dw 0x0bc0, 0xc09d,	0x0bff, 0xc09d,		0x21, 0
	.dw 0x0c40, 0xc09d,	0x0c7f, 0xc09d,		0x21, 0
	.dw 0x0cc0, 0xc09d,	0x0cff, 0xc09d,		0x21, 0
	.dw 0x0d40, 0xc09d,	0x0d7f, 0xc09d,		0x21, 0
	.dw 0x0dc0, 0xc09d,	0x0dff, 0xc09d,		0x21, 0
	.dw 0x0e40, 0xc09d,	0x0e7f, 0xc09d,		0x21, 0
	.dw 0x0ec0, 0xc09d,	0x0eff, 0xc09d,		0x21, 0
	.dw 0x0f40, 0xc09d,	0x0f7f, 0xc09d,		0x21, 0
	.dw 0x0fc0, 0xc09d,	0x0fff, 0xc09d,		0x21, 0
	.dw 0x1040, 0xc09d,	0x107f, 0xc09d,		0x21, 0
	.dw 0x10c0, 0xc09d,	0x10ff, 0xc09d,		0x21, 0
	.dw 0x1140, 0xc09d,	0x117f, 0xc09d,		0x21, 0
	.dw 0x11c0, 0xc09d,	0x11ff, 0xc09d,		0x21, 0
	.dw 0x1240, 0xc09d,	0x127f, 0xc09d,		0x21, 0
	.dw 0x12c0, 0xc09d,	0x12ff, 0xc09d,		0x21, 0
	.dw 0x1340, 0xc09d,	0x137f, 0xc09d,		0x21, 0
	.dw 0x13c0, 0xc09d,	0x13ff, 0xc09d,		0x21, 0
	.dw 0x1440, 0xc09d,	0x147f, 0xc09d,		0x21, 0
	.dw 0x14c0, 0xc09d,	0x14ff, 0xc09d,		0x21, 0
	.dw 0x1540, 0xc09d,	0x157f, 0xc09d,		0x21, 0
	.dw 0x15c0, 0xc09d,	0x15ff, 0xc09d,		0x21, 0
	.dw 0x1640, 0xc09d,	0x167f, 0xc09d,		0x21, 0
	.dw 0x16c0, 0xc09d,	0x16ff, 0xc09d,		0x21, 0
	.dw 0x1740, 0xc09d,	0x177f, 0xc09d,		0x21, 0
	.dw 0x17c0, 0xc09d,	0x17ff, 0xc09d,		0x21, 0
	.dw 0x1840, 0xc09d,	0x187f, 0xc09d,		0x21, 0
	.dw 0x18c0, 0xc09d,	0x18ff, 0xc09d,		0x21, 0
	.dw 0x1940, 0xc09d,	0x197f, 0xc09d,		0x21, 0
	.dw 0x19c0, 0xc09d,	0x1fff, 0xc09d,		0x21, 0
	.dw 0x2040, 0xc09d,	0x207f, 0xc09d,		0x21, 0
	.dw 0x20c0, 0xc09d,	0x20ff, 0xc09d,		0x21, 0
	.dw 0x2140, 0xc09d,	0x217f, 0xc09d,		0x21, 0
	.dw 0x21c0, 0xc09d,	0x21ff, 0xc09d,		0x21, 0
	.dw 0x2240, 0xc09d,	0x227f, 0xc09d,		0x21, 0
	.dw 0x22c0, 0xc09d,	0x22ff, 0xc09d,		0x21, 0
	.dw 0x2340, 0xc09d,	0x237f, 0xc09d,		0x21, 0
	.dw 0x23c0, 0xc09d,	0x23ff, 0xc09d,		0x21, 0
	.dw 0x2440, 0xc09d,	0x247f, 0xc09d,		0x21, 0
	.dw 0x24c0, 0xc09d,	0x24ff, 0xc09d,		0x21, 0
	.dw 0x2540, 0xc09d,	0x257f, 0xc09d,		0x21, 0
	.dw 0x25c0, 0xc09d,	0x25ff, 0xc09d,		0x21, 0
	.dw 0x2640, 0xc09d,	0x267f, 0xc09d,		0x21, 0
	.dw 0x26c0, 0xc09d,	0x26ff, 0xc09d,		0x21, 0
	.dw 0x2740, 0xc09d,	0x277f, 0xc09d,		0x21, 0
	.dw 0x27c0, 0xc09d,	0x27ff, 0xc09d,		0x21, 0
	.dw 0x2840, 0xc09d,	0x287f, 0xc09d,		0x21, 0
	.dw 0x28c0, 0xc09d,	0x28ff, 0xc09d,		0x21, 0
	.dw 0x2940, 0xc09d,	0x297f, 0xc09d,		0x21, 0
	.dw 0x29c0, 0xc09d,	0x29ff, 0xc09d,		0x21, 0
	.dw 0x2a40, 0xc09d,	0x2a7f, 0xc09d,		0x21, 0
	.dw 0x2ac0, 0xc09d,	0x2aff, 0xc09d,		0x21, 0
	.dw 0x2b40, 0xc09d,	0x2b7f, 0xc09d,		0x21, 0
	.dw 0x2bc0, 0xc09d,	0x2bff, 0xc09d,		0x21, 0
	.dw 0x2c40, 0xc09d,	0x2c7f, 0xc09d,		0x21, 0
	.dw 0x2cc0, 0xc09d,	0x2cff, 0xc09d,		0x21, 0
	.dw 0x2d40, 0xc09d,	0x2d7f, 0xc09d,		0x21, 0
	.dw 0x2dc0, 0xc09d,	0x2dff, 0xc09d,		0x21, 0
	.dw 0x2e40, 0xc09d,	0x2e7f, 0xc09d,		0x21, 0
	.dw 0x2ec0, 0xc09d,	0x2eff, 0xc09d,		0x21, 0
	.dw 0x2f40, 0xc09d,	0x2f7f, 0xc09d,		0x21, 0
	.dw 0x2fc0, 0xc09d,	0x2fff, 0xc09d,		0x21, 0
	.dw 0x3040, 0xc09d,	0x307f, 0xc09d,		0x21, 0
	.dw 0x30c0, 0xc09d,	0x30ff, 0xc09d,		0x21, 0
	.dw 0x3140, 0xc09d,	0x317f, 0xc09d,		0x21, 0
	.dw 0x31c0, 0xc09d,	0x31ff, 0xc09d,		0x21, 0
	.dw 0x3240, 0xc09d,	0x327f, 0xc09d,		0x21, 0
	.dw 0x32c0, 0xc09d,	0x32ff, 0xc09d,		0x21, 0
	.dw 0x3340, 0xc09d,	0x337f, 0xc09d,		0x21, 0
	.dw 0x33c0, 0xc09d,	0x33ff, 0xc09d,		0x21, 0
	.dw 0x3440, 0xc09d,	0x347f, 0xc09d,		0x21, 0
	.dw 0x34c0, 0xc09d,	0x34ff, 0xc09d,		0x21, 0
	.dw 0x3540, 0xc09d,	0x357f, 0xc09d,		0x21, 0
	.dw 0x35c0, 0xc09d,	0x35ff, 0xc09d,		0x21, 0
	.dw 0x3640, 0xc09d,	0x367f, 0xc09d,		0x21, 0
	.dw 0x36c0, 0xc09d,	0x36ff, 0xc09d,		0x21, 0
	.dw 0x3740, 0xc09d,	0x377f, 0xc09d,		0x21, 0
	.dw 0x37c0, 0xc09d,	0x37ff, 0xc09d,		0x21, 0
	.dw 0x3840, 0xc09d,	0x387f, 0xc09d,		0x21, 0
	.dw 0x38c0, 0xc09d,	0x38ff, 0xc09d,		0x21, 0
	.dw 0x3940, 0xc09d,	0x397f, 0xc09d,		0x21, 0
	.dw 0x39c0, 0xc09d,	0x3fff, 0xc09d,		0x21, 0
	.dw 0x4040, 0xc09d,	0x407f, 0xc09d,		0x21, 0
	.dw 0x40c0, 0xc09d,	0x40ff, 0xc09d,		0x21, 0
	.dw 0x4140, 0xc09d,	0x417f, 0xc09d,		0x21, 0
	.dw 0x41c0, 0xc09d,	0x41ff, 0xc09d,		0x21, 0
	.dw 0x4240, 0xc09d,	0x427f, 0xc09d,		0x21, 0
	.dw 0x42c0, 0xc09d,	0x42ff, 0xc09d,		0x21, 0
	.dw 0x4340, 0xc09d,	0x437f, 0xc09d,		0x21, 0
	.dw 0x43c0, 0xc09d,	0x43ff, 0xc09d,		0x21, 0
	.dw 0x4440, 0xc09d,	0x447f, 0xc09d,		0x21, 0
	.dw 0x44c0, 0xc09d,	0x44ff, 0xc09d,		0x21, 0
	.dw 0x4540, 0xc09d,	0x457f, 0xc09d,		0x21, 0
	.dw 0x45c0, 0xc09d,	0x45ff, 0xc09d,		0x21, 0
	.dw 0x4640, 0xc09d,	0x467f, 0xc09d,		0x21, 0
	.dw 0x46c0, 0xc09d,	0x46ff, 0xc09d,		0x21, 0
	.dw 0x4740, 0xc09d,	0x477f, 0xc09d,		0x21, 0
	.dw 0x47c0, 0xc09d,	0x47ff, 0xc09d,		0x21, 0
	.dw 0x4840, 0xc09d,	0x487f, 0xc09d,		0x21, 0
	.dw 0x48c0, 0xc09d,	0x48ff, 0xc09d,		0x21, 0
	.dw 0x4940, 0xc09d,	0x497f, 0xc09d,		0x21, 0
	.dw 0x49c0, 0xc09d,	0x49ff, 0xc09d,		0x21, 0
	.dw 0x4a40, 0xc09d,	0x4a7f, 0xc09d,		0x21, 0
	.dw 0x4ac0, 0xc09d,	0x4aff, 0xc09d,		0x21, 0
	.dw 0x4b40, 0xc09d,	0x4b7f, 0xc09d,		0x21, 0
	.dw 0x4bc0, 0xc09d,	0x4bff, 0xc09d,		0x21, 0
	.dw 0x4c40, 0xc09d,	0x4c7f, 0xc09d,		0x21, 0
	.dw 0x4cc0, 0xc09d,	0x4cff, 0xc09d,		0x21, 0
	.dw 0x4d40, 0xc09d,	0x4d7f, 0xc09d,		0x21, 0
	.dw 0x4dc0, 0xc09d,	0x4dff, 0xc09d,		0x21, 0
	.dw 0x4e40, 0xc09d,	0x4e7f, 0xc09d,		0x21, 0
	.dw 0x4ec0, 0xc09d,	0x4eff, 0xc09d,		0x21, 0
	.dw 0x4f40, 0xc09d,	0x4f7f, 0xc09d,		0x21, 0
	.dw 0x4fc0, 0xc09d,	0x4fff, 0xc09d,		0x21, 0
	.dw 0x5040, 0xc09d,	0x507f, 0xc09d,		0x21, 0
	.dw 0x50c0, 0xc09d,	0x50ff, 0xc09d,		0x21, 0
	.dw 0x5140, 0xc09d,	0x517f, 0xc09d,		0x21, 0
	.dw 0x51c0, 0xc09d,	0x51ff, 0xc09d,		0x21, 0
	.dw 0x5240, 0xc09d,	0x527f, 0xc09d,		0x21, 0
	.dw 0x52c0, 0xc09d,	0x52ff, 0xc09d,		0x21, 0
	.dw 0x5340, 0xc09d,	0x537f, 0xc09d,		0x21, 0
	.dw 0x53c0, 0xc09d,	0x53ff, 0xc09d,		0x21, 0
	.dw 0x5440, 0xc09d,	0x547f, 0xc09d,		0x21, 0
	.dw 0x54c0, 0xc09d,	0x54ff, 0xc09d,		0x21, 0
	.dw 0x5540, 0xc09d,	0x557f, 0xc09d,		0x21, 0
	.dw 0x55c0, 0xc09d,	0x55ff, 0xc09d,		0x21, 0
	.dw 0x5640, 0xc09d,	0x567f, 0xc09d,		0x21, 0
	.dw 0x56c0, 0xc09d,	0x56ff, 0xc09d,		0x21, 0
	.dw 0x5740, 0xc09d,	0x577f, 0xc09d,		0x21, 0
	.dw 0x57c0, 0xc09d,	0x57ff, 0xc09d,		0x21, 0
	.dw 0x5840, 0xc09d,	0x587f, 0xc09d,		0x21, 0
	.dw 0x58c0, 0xc09d,	0x58ff, 0xc09d,		0x21, 0
	.dw 0x5940, 0xc09d,	0x597f, 0xc09d,		0x21, 0
	.dw 0x59c0, 0xc09d,	0x5fff, 0xc09d,		0x21, 0
	.dw 0x6040, 0xc09d,	0x607f, 0xc09d,		0x21, 0
	.dw 0x60c0, 0xc09d,	0x60ff, 0xc09d,		0x21, 0
	.dw 0x6140, 0xc09d,	0x617f, 0xc09d,		0x21, 0
	.dw 0x61c0, 0xc09d,	0x61ff, 0xc09d,		0x21, 0
	.dw 0x6240, 0xc09d,	0x627f, 0xc09d,		0x21, 0
	.dw 0x62c0, 0xc09d,	0x62ff, 0xc09d,		0x21, 0
	.dw 0x6340, 0xc09d,	0x637f, 0xc09d,		0x21, 0
	.dw 0x63c0, 0xc09d,	0x63ff, 0xc09d,		0x21, 0
	.dw 0x6440, 0xc09d,	0x647f, 0xc09d,		0x21, 0
	.dw 0x64c0, 0xc09d,	0x64ff, 0xc09d,		0x21, 0
	.dw 0x6540, 0xc09d,	0x657f, 0xc09d,		0x21, 0
	.dw 0x65c0, 0xc09d,	0x65ff, 0xc09d,		0x21, 0
	.dw 0x6640, 0xc09d,	0x667f, 0xc09d,		0x21, 0
	.dw 0x66c0, 0xc09d,	0x66ff, 0xc09d,		0x21, 0
	.dw 0x6740, 0xc09d,	0x677f, 0xc09d,		0x21, 0
	.dw 0x67c0, 0xc09d,	0x67ff, 0xc09d,		0x21, 0
	.dw 0x6840, 0xc09d,	0x687f, 0xc09d,		0x21, 0
	.dw 0x68c0, 0xc09d,	0x68ff, 0xc09d,		0x21, 0
	.dw 0x6940, 0xc09d,	0x697f, 0xc09d,		0x21, 0
	.dw 0x69c0, 0xc09d,	0x69ff, 0xc09d,		0x21, 0
	.dw 0x6a40, 0xc09d,	0x6a7f, 0xc09d,		0x21, 0
	.dw 0x6ac0, 0xc09d,	0x6aff, 0xc09d,		0x21, 0
	.dw 0x6b40, 0xc09d,	0x6b7f, 0xc09d,		0x21, 0
	.dw 0x6bc0, 0xc09d,	0x6bff, 0xc09d,		0x21, 0
	.dw 0x6c40, 0xc09d,	0x6c7f, 0xc09d,		0x21, 0
	.dw 0x6cc0, 0xc09d,	0x6cff, 0xc09d,		0x21, 0
	.dw 0x6d40, 0xc09d,	0x6d7f, 0xc09d,		0x21, 0
	.dw 0x6dc0, 0xc09d,	0x6dff, 0xc09d,		0x21, 0
	.dw 0x6e40, 0xc09d,	0x6e7f, 0xc09d,		0x21, 0
	.dw 0x6ec0, 0xc09d,	0x6eff, 0xc09d,		0x21, 0
	.dw 0x6f40, 0xc09d,	0x6f7f, 0xc09d,		0x21, 0
	.dw 0x6fc0, 0xc09d,	0x6fff, 0xc09d,		0x21, 0
	.dw 0x7040, 0xc09d,	0x707f, 0xc09d,		0x21, 0
	.dw 0x70c0, 0xc09d,	0x70ff, 0xc09d,		0x21, 0
	.dw 0x7140, 0xc09d,	0x717f, 0xc09d,		0x21, 0
	.dw 0x71c0, 0xc09d,	0x71ff, 0xc09d,		0x21, 0
	.dw 0x7240, 0xc09d,	0x727f, 0xc09d,		0x21, 0
	.dw 0x72c0, 0xc09d,	0x72ff, 0xc09d,		0x21, 0
	.dw 0x7340, 0xc09d,	0x737f, 0xc09d,		0x21, 0
	.dw 0x73c0, 0xc09d,	0x73ff, 0xc09d,		0x21, 0
	.dw 0x7440, 0xc09d,	0x747f, 0xc09d,		0x21, 0
	.dw 0x74c0, 0xc09d,	0x74ff, 0xc09d,		0x21, 0
	.dw 0x7540, 0xc09d,	0x757f, 0xc09d,		0x21, 0
	.dw 0x75c0, 0xc09d,	0x75ff, 0xc09d,		0x21, 0
	.dw 0x7640, 0xc09d,	0x767f, 0xc09d,		0x21, 0
	.dw 0x76c0, 0xc09d,	0x76ff, 0xc09d,		0x21, 0
	.dw 0x7740, 0xc09d,	0x777f, 0xc09d,		0x21, 0
	.dw 0x77c0, 0xc09d,	0x77ff, 0xc09d,		0x21, 0
	.dw 0x7840, 0xc09d,	0x787f, 0xc09d,		0x21, 0
	.dw 0x78c0, 0xc09d,	0x78ff, 0xc09d,		0x21, 0
	.dw 0x7940, 0xc09d,	0x797f, 0xc09d,		0x21, 0
	.dw 0x79c0, 0xc09d,	0x7fff, 0xc09d,		0x21, 0
	.dw 0x8040, 0xc09d,	0x807f, 0xc09d,		0x21, 0
	.dw 0x80c0, 0xc09d,	0x80ff, 0xc09d,		0x21, 0
	.dw 0x8140, 0xc09d,	0x817f, 0xc09d,		0x21, 0
	.dw 0x81c0, 0xc09d,	0x81ff, 0xc09d,		0x21, 0
	.dw 0x8240, 0xc09d,	0x827f, 0xc09d,		0x21, 0
	.dw 0x82c0, 0xc09d,	0x82ff, 0xc09d,		0x21, 0
	.dw 0x8340, 0xc09d,	0x837f, 0xc09d,		0x21, 0
	.dw 0x83c0, 0xc09d,	0x83ff, 0xc09d,		0x21, 0
	.dw 0x8440, 0xc09d,	0x847f, 0xc09d,		0x21, 0
	.dw 0x84c0, 0xc09d,	0x84ff, 0xc09d,		0x21, 0
	.dw 0x8540, 0xc09d,	0x857f, 0xc09d,		0x21, 0
	.dw 0x85c0, 0xc09d,	0x85ff, 0xc09d,		0x21, 0
	.dw 0x8640, 0xc09d,	0x867f, 0xc09d,		0x21, 0
	.dw 0x86c0, 0xc09d,	0x86ff, 0xc09d,		0x21, 0
	.dw 0x8740, 0xc09d,	0x877f, 0xc09d,		0x21, 0
	.dw 0x87c0, 0xc09d,	0x87ff, 0xc09d,		0x21, 0
	.dw 0x8840, 0xc09d,	0x887f, 0xc09d,		0x21, 0
	.dw 0x88c0, 0xc09d,	0x88ff, 0xc09d,		0x21, 0
	.dw 0x8940, 0xc09d,	0x897f, 0xc09d,		0x21, 0
	.dw 0x89c0, 0xc09d,	0x89ff, 0xc09d,		0x21, 0
	.dw 0x8a40, 0xc09d,	0x8a7f, 0xc09d,		0x21, 0
	.dw 0x8ac0, 0xc09d,	0x8aff, 0xc09d,		0x21, 0
	.dw 0x8b40, 0xc09d,	0x8b7f, 0xc09d,		0x21, 0
	.dw 0x8bc0, 0xc09d,	0x8bff, 0xc09d,		0x21, 0
	.dw 0x8c40, 0xc09d,	0x8c7f, 0xc09d,		0x21, 0
	.dw 0x8cc0, 0xc09d,	0x8cff, 0xc09d,		0x21, 0
	.dw 0x8d40, 0xc09d,	0x8d7f, 0xc09d,		0x21, 0
	.dw 0x8dc0, 0xc09d,	0x8dff, 0xc09d,		0x21, 0
	.dw 0x8e40, 0xc09d,	0x8e7f, 0xc09d,		0x21, 0
	.dw 0x8ec0, 0xc09d,	0x8eff, 0xc09d,		0x21, 0
	.dw 0x8f40, 0xc09d,	0x8f7f, 0xc09d,		0x21, 0
	.dw 0x8fc0, 0xc09d,	0x8fff, 0xc09d,		0x21, 0
	.dw 0x9040, 0xc09d,	0x907f, 0xc09d,		0x21, 0
	.dw 0x90c0, 0xc09d,	0x90ff, 0xc09d,		0x21, 0
	.dw 0x9140, 0xc09d,	0x917f, 0xc09d,		0x21, 0
	.dw 0x91c0, 0xc09d,	0x91ff, 0xc09d,		0x21, 0
	.dw 0x9240, 0xc09d,	0x927f, 0xc09d,		0x21, 0
	.dw 0x92c0, 0xc09d,	0x92ff, 0xc09d,		0x21, 0
	.dw 0x9340, 0xc09d,	0x937f, 0xc09d,		0x21, 0
	.dw 0x93c0, 0xc09d,	0x93ff, 0xc09d,		0x21, 0
	.dw 0x9440, 0xc09d,	0x947f, 0xc09d,		0x21, 0
	.dw 0x94c0, 0xc09d,	0x94ff, 0xc09d,		0x21, 0
	.dw 0x9540, 0xc09d,	0x957f, 0xc09d,		0x21, 0
	.dw 0x95c0, 0xc09d,	0x95ff, 0xc09d,		0x21, 0
	.dw 0x9640, 0xc09d,	0x967f, 0xc09d,		0x21, 0
	.dw 0x96c0, 0xc09d,	0x96ff, 0xc09d,		0x21, 0
	.dw 0x9740, 0xc09d,	0x977f, 0xc09d,		0x21, 0
	.dw 0x97c0, 0xc09d,	0x97ff, 0xc09d,		0x21, 0
	.dw 0x9840, 0xc09d,	0x987f, 0xc09d,		0x21, 0
	.dw 0x98c0, 0xc09d,	0x98ff, 0xc09d,		0x21, 0
	.dw 0x9940, 0xc09d,	0x997f, 0xc09d,		0x21, 0
	.dw 0x99c0, 0xc09d,	0x9fff, 0xc09d,		0x21, 0
	.dw 0xa040, 0xc09d,	0xa07f, 0xc09d,		0x21, 0
	.dw 0xa0c0, 0xc09d,	0xa0ff, 0xc09d,		0x21, 0
	.dw 0xa140, 0xc09d,	0xa17f, 0xc09d,		0x21, 0
	.dw 0xa1c0, 0xc09d,	0xa1ff, 0xc09d,		0x21, 0
	.dw 0xa240, 0xc09d,	0xa27f, 0xc09d,		0x21, 0
	.dw 0xa2c0, 0xc09d,	0xa2ff, 0xc09d,		0x21, 0
	.dw 0xa340, 0xc09d,	0xa37f, 0xc09d,		0x21, 0
	.dw 0xa3c0, 0xc09d,	0xa3ff, 0xc09d,		0x21, 0
	.dw 0xa440, 0xc09d,	0xa47f, 0xc09d,		0x21, 0
	.dw 0xa4c0, 0xc09d,	0xa4ff, 0xc09d,		0x21, 0
	.dw 0xa540, 0xc09d,	0xa57f, 0xc09d,		0x21, 0
	.dw 0xa5c0, 0xc09d,	0xa5ff, 0xc09d,		0x21, 0
	.dw 0xa640, 0xc09d,	0xa67f, 0xc09d,		0x21, 0
	.dw 0xa6c0, 0xc09d,	0xa6ff, 0xc09d,		0x21, 0
	.dw 0xa740, 0xc09d,	0xa77f, 0xc09d,		0x21, 0
	.dw 0xa7c0, 0xc09d,	0xa7ff, 0xc09d,		0x21, 0
	.dw 0xa840, 0xc09d,	0xa87f, 0xc09d,		0x21, 0
	.dw 0xa8c0, 0xc09d,	0xa8ff, 0xc09d,		0x21, 0
	.dw 0xa940, 0xc09d,	0xa97f, 0xc09d,		0x21, 0
	.dw 0xa9c0, 0xc09d,	0xa9ff, 0xc09d,		0x21, 0
	.dw 0xaa40, 0xc09d,	0xaa7f, 0xc09d,		0x21, 0
	.dw 0xaac0, 0xc09d,	0xaaff, 0xc09d,		0x21, 0
	.dw 0xab40, 0xc09d,	0xab7f, 0xc09d,		0x21, 0
	.dw 0xabc0, 0xc09d,	0xabff, 0xc09d,		0x21, 0
	.dw 0xac40, 0xc09d,	0xac7f, 0xc09d,		0x21, 0
	.dw 0xacc0, 0xc09d,	0xacff, 0xc09d,		0x21, 0
	.dw 0xad40, 0xc09d,	0xad7f, 0xc09d,		0x21, 0
	.dw 0xadc0, 0xc09d,	0xadff, 0xc09d,		0x21, 0
	.dw 0xae40, 0xc09d,	0xae7f, 0xc09d,		0x21, 0
	.dw 0xaec0, 0xc09d,	0xaeff, 0xc09d,		0x21, 0
	.dw 0xaf40, 0xc09d,	0xaf7f, 0xc09d,		0x21, 0
	.dw 0xafc0, 0xc09d,	0xafff, 0xc09d,		0x21, 0
	.dw 0xb040, 0xc09d,	0xb07f, 0xc09d,		0x21, 0
	.dw 0xb0c0, 0xc09d,	0xb0ff, 0xc09d,		0x21, 0
	.dw 0xb140, 0xc09d,	0xb17f, 0xc09d,		0x21, 0
	.dw 0xb1c0, 0xc09d,	0xb1ff, 0xc09d,		0x21, 0
	.dw 0xb240, 0xc09d,	0xb27f, 0xc09d,		0x21, 0
	.dw 0xb2c0, 0xc09d,	0xb2ff, 0xc09d,		0x21, 0
	.dw 0xb340, 0xc09d,	0xb37f, 0xc09d,		0x21, 0
	.dw 0xb3c0, 0xc09d,	0xb3ff, 0xc09d,		0x21, 0
	.dw 0xb440, 0xc09d,	0xb47f, 0xc09d,		0x21, 0
	.dw 0xb4c0, 0xc09d,	0xb4ff, 0xc09d,		0x21, 0
	.dw 0xb540, 0xc09d,	0xb57f, 0xc09d,		0x21, 0
	.dw 0xb5c0, 0xc09d,	0xb5ff, 0xc09d,		0x21, 0
	.dw 0xb640, 0xc09d,	0xb67f, 0xc09d,		0x21, 0
	.dw 0xb6c0, 0xc09d,	0xb6ff, 0xc09d,		0x21, 0
	.dw 0xb740, 0xc09d,	0xb77f, 0xc09d,		0x21, 0
	.dw 0xb7c0, 0xc09d,	0xb7ff, 0xc09d,		0x21, 0
	.dw 0xb840, 0xc09d,	0xb87f, 0xc09d,		0x21, 0
	.dw 0xb8c0, 0xc09d,	0xb8ff, 0xc09d,		0x21, 0
	.dw 0xb940, 0xc09d,	0xb97f, 0xc09d,		0x21, 0
	.dw 0xb9c0, 0xc09d,	0xbfff, 0xc09d,		0x21, 0
	.dw 0xc040, 0xc09d,	0xc07f, 0xc09d,		0x21, 0
	.dw 0xc0c0, 0xc09d,	0xc0ff, 0xc09d,		0x21, 0
	.dw 0xc140, 0xc09d,	0xc17f, 0xc09d,		0x21, 0
	.dw 0xc1c0, 0xc09d,	0xc1ff, 0xc09d,		0x21, 0
	.dw 0xc240, 0xc09d,	0xc27f, 0xc09d,		0x21, 0
	.dw 0xc2c0, 0xc09d,	0xc2ff, 0xc09d,		0x21, 0
	.dw 0xc340, 0xc09d,	0xc37f, 0xc09d,		0x21, 0
	.dw 0xc3c0, 0xc09d,	0xc3ff, 0xc09d,		0x21, 0
	.dw 0xc440, 0xc09d,	0xc47f, 0xc09d,		0x21, 0
	.dw 0xc4c0, 0xc09d,	0xc4ff, 0xc09d,		0x21, 0
	.dw 0xc540, 0xc09d,	0xc57f, 0xc09d,		0x21, 0
	.dw 0xc5c0, 0xc09d,	0xc5ff, 0xc09d,		0x21, 0
	.dw 0xc640, 0xc09d,	0xc67f, 0xc09d,		0x21, 0
	.dw 0xc6c0, 0xc09d,	0xc6ff, 0xc09d,		0x21, 0
	.dw 0xc740, 0xc09d,	0xc77f, 0xc09d,		0x21, 0
	.dw 0xc7c0, 0xc09d,	0xc7ff, 0xc09d,		0x21, 0
	.dw 0xc840, 0xc09d,	0xc87f, 0xc09d,		0x21, 0
	.dw 0xc8c0, 0xc09d,	0xc8ff, 0xc09d,		0x21, 0
	.dw 0xc940, 0xc09d,	0xc97f, 0xc09d,		0x21, 0
	.dw 0xc9c0, 0xc09d,	0xc9ff, 0xc09d,		0x21, 0
	.dw 0xca40, 0xc09d,	0xca7f, 0xc09d,		0x21, 0
	.dw 0xcac0, 0xc09d,	0xcaff, 0xc09d,		0x21, 0
	.dw 0xcb40, 0xc09d,	0xcb7f, 0xc09d,		0x21, 0
	.dw 0xcbc0, 0xc09d,	0xcbff, 0xc09d,		0x21, 0
	.dw 0xcc40, 0xc09d,	0xcc7f, 0xc09d,		0x21, 0
	.dw 0xccc0, 0xc09d,	0xccff, 0xc09d,		0x21, 0
	.dw 0xcd40, 0xc09d,	0xcd7f, 0xc09d,		0x21, 0
	.dw 0xcdc0, 0xc09d,	0xcdff, 0xc09d,		0x21, 0
	.dw 0xce40, 0xc09d,	0xce7f, 0xc09d,		0x21, 0
	.dw 0xcec0, 0xc09d,	0xceff, 0xc09d,		0x21, 0
	.dw 0xcf40, 0xc09d,	0xcf7f, 0xc09d,		0x21, 0
	.dw 0xcfc0, 0xc09d,	0xcfff, 0xc09d,		0x21, 0
	.dw 0xd040, 0xc09d,	0xd07f, 0xc09d,		0x21, 0
	.dw 0xd0c0, 0xc09d,	0xd0ff, 0xc09d,		0x21, 0
	.dw 0xd140, 0xc09d,	0xd17f, 0xc09d,		0x21, 0
	.dw 0xd1c0, 0xc09d,	0xd1ff, 0xc09d,		0x21, 0
	.dw 0xd240, 0xc09d,	0xd27f, 0xc09d,		0x21, 0
	.dw 0xd2c0, 0xc09d,	0xd2ff, 0xc09d,		0x21, 0
	.dw 0xd340, 0xc09d,	0xd37f, 0xc09d,		0x21, 0
	.dw 0xd3c0, 0xc09d,	0xd3ff, 0xc09d,		0x21, 0
	.dw 0xd440, 0xc09d,	0xd47f, 0xc09d,		0x21, 0
	.dw 0xd4c0, 0xc09d,	0xd4ff, 0xc09d,		0x21, 0
	.dw 0xd540, 0xc09d,	0xd57f, 0xc09d,		0x21, 0
	.dw 0xd5c0, 0xc09d,	0xd5ff, 0xc09d,		0x21, 0
	.dw 0xd640, 0xc09d,	0xd67f, 0xc09d,		0x21, 0
	.dw 0xd6c0, 0xc09d,	0xd6ff, 0xc09d,		0x21, 0
	.dw 0xd740, 0xc09d,	0xd77f, 0xc09d,		0x21, 0
	.dw 0xd7c0, 0xc09d,	0xd7ff, 0xc09d,		0x21, 0
	.dw 0xd840, 0xc09d,	0xd87f, 0xc09d,		0x21, 0
	.dw 0xd8c0, 0xc09d,	0xd8ff, 0xc09d,		0x21, 0
	.dw 0xd940, 0xc09d,	0xd97f, 0xc09d,		0x21, 0
	.dw 0xd9c0, 0xc09d,	0xdfff, 0xc09d,		0x21, 0
	.dw 0xe040, 0xc09d,	0xe07f, 0xc09d,		0x21, 0
	.dw 0xe0c0, 0xc09d,	0xe0ff, 0xc09d,		0x21, 0
	.dw 0xe140, 0xc09d,	0xe17f, 0xc09d,		0x21, 0
	.dw 0xe1c0, 0xc09d,	0xe1ff, 0xc09d,		0x21, 0
	.dw 0xe240, 0xc09d,	0xe27f, 0xc09d,		0x21, 0
	.dw 0xe2c0, 0xc09d,	0xe2ff, 0xc09d,		0x21, 0
	.dw 0xe340, 0xc09d,	0xe37f, 0xc09d,		0x21, 0
	.dw 0xe3c0, 0xc09d,	0xe3ff, 0xc09d,		0x21, 0
	.dw 0xe440, 0xc09d,	0xe47f, 0xc09d,		0x21, 0
	.dw 0xe4c0, 0xc09d,	0xe4ff, 0xc09d,		0x21, 0
	.dw 0xe540, 0xc09d,	0xe57f, 0xc09d,		0x21, 0
	.dw 0xe5c0, 0xc09d,	0xe5ff, 0xc09d,		0x21, 0
	.dw 0xe640, 0xc09d,	0xe67f, 0xc09d,		0x21, 0
	.dw 0xe6c0, 0xc09d,	0xe6ff, 0xc09d,		0x21, 0
	.dw 0xe740, 0xc09d,	0xe77f, 0xc09d,		0x21, 0
	.dw 0xe7c0, 0xc09d,	0xe7ff, 0xc09d,		0x21, 0
	.dw 0xe840, 0xc09d,	0xe87f, 0xc09d,		0x21, 0
	.dw 0xe8c0, 0xc09d,	0xe8ff, 0xc09d,		0x21, 0
	.dw 0xe940, 0xc09d,	0xe97f, 0xc09d,		0x21, 0
	.dw 0xe9c0, 0xc09d,	0xe9ff, 0xc09d,		0x21, 0
	.dw 0xea40, 0xc09d,	0xea7f, 0xc09d,		0x21, 0
	.dw 0xeac0, 0xc09d,	0xeaff, 0xc09d,		0x21, 0
	.dw 0xeb40, 0xc09d,	0xeb7f, 0xc09d,		0x21, 0
	.dw 0xebc0, 0xc09d,	0xebff, 0xc09d,		0x21, 0
	.dw 0xec40, 0xc09d,	0xec7f, 0xc09d,		0x21, 0
	.dw 0xecc0, 0xc09d,	0xecff, 0xc09d,		0x21, 0
	.dw 0xed40, 0xc09d,	0xed7f, 0xc09d,		0x21, 0
	.dw 0xedc0, 0xc09d,	0xedff, 0xc09d,		0x21, 0
	.dw 0xee40, 0xc09d,	0xee7f, 0xc09d,		0x21, 0
	.dw 0xeec0, 0xc09d,	0xeeff, 0xc09d,		0x21, 0
	.dw 0xef40, 0xc09d,	0xef7f, 0xc09d,		0x21, 0
	.dw 0xefc0, 0xc09d,	0xefff, 0xc09d,		0x21, 0
	.dw 0xf040, 0xc09d,	0xf07f, 0xc09d,		0x21, 0
	.dw 0xf0c0, 0xc09d,	0xf0ff, 0xc09d,		0x21, 0
	.dw 0xf140, 0xc09d,	0xf17f, 0xc09d,		0x21, 0
	.dw 0xf1c0, 0xc09d,	0xf1ff, 0xc09d,		0x21, 0
	.dw 0xf240, 0xc09d,	0xf27f, 0xc09d,		0x21, 0
	.dw 0xf2c0, 0xc09d,	0xf2ff, 0xc09d,		0x21, 0
	.dw 0xf340, 0xc09d,	0xf37f, 0xc09d,		0x21, 0
	.dw 0xf3c0, 0xc09d,	0xf3ff, 0xc09d,		0x21, 0
	.dw 0xf440, 0xc09d,	0xf47f, 0xc09d,		0x21, 0
	.dw 0xf4c0, 0xc09d,	0xf4ff, 0xc09d,		0x21, 0
	.dw 0xf540, 0xc09d,	0xf57f, 0xc09d,		0x21, 0
	.dw 0xf5c0, 0xc09d,	0xf5ff, 0xc09d,		0x21, 0
	.dw 0xf640, 0xc09d,	0xf67f, 0xc09d,		0x21, 0
	.dw 0xf6c0, 0xc09d,	0xf6ff, 0xc09d,		0x21, 0
	.dw 0xf740, 0xc09d,	0xf77f, 0xc09d,		0x21, 0
	.dw 0xf7c0, 0xc09d,	0xf7ff, 0xc09d,		0x21, 0
	.dw 0xf840, 0xc09d,	0xf87f, 0xc09d,		0x21, 0
	.dw 0xf8c0, 0xc09d,	0xf8ff, 0xc09d,		0x21, 0
	.dw 0xf940, 0xc09d,	0xf97f, 0xc09d,		0x21, 0
	.dw 0xf9c0, 0xc09d,	0xffff, 0xc09d,		0x21, 0
	.dw 0x0040, 0xc09e,	0x007f, 0xc09e,		0x21, 0
	.dw 0x00c0, 0xc09e,	0x00ff, 0xc09e,		0x21, 0
	.dw 0x0140, 0xc09e,	0x017f, 0xc09e,		0x21, 0
	.dw 0x01c0, 0xc09e,	0x01ff, 0xc09e,		0x21, 0
	.dw 0x0240, 0xc09e,	0x027f, 0xc09e,		0x21, 0
	.dw 0x02c0, 0xc09e,	0x02ff, 0xc09e,		0x21, 0
	.dw 0x0340, 0xc09e,	0x037f, 0xc09e,		0x21, 0
	.dw 0x03c0, 0xc09e,	0x03ff, 0xc09e,		0x21, 0
	.dw 0x0440, 0xc09e,	0x047f, 0xc09e,		0x21, 0
	.dw 0x04c0, 0xc09e,	0x04ff, 0xc09e,		0x21, 0
	.dw 0x0540, 0xc09e,	0x057f, 0xc09e,		0x21, 0
	.dw 0x05c0, 0xc09e,	0x05ff, 0xc09e,		0x21, 0
	.dw 0x0640, 0xc09e,	0x067f, 0xc09e,		0x21, 0
	.dw 0x06c0, 0xc09e,	0x06ff, 0xc09e,		0x21, 0
	.dw 0x0740, 0xc09e,	0x077f, 0xc09e,		0x21, 0
	.dw 0x07c0, 0xc09e,	0x07ff, 0xc09e,		0x21, 0
	.dw 0x0840, 0xc09e,	0x087f, 0xc09e,		0x21, 0
	.dw 0x08c0, 0xc09e,	0x08ff, 0xc09e,		0x21, 0
	.dw 0x0940, 0xc09e,	0x097f, 0xc09e,		0x21, 0
	.dw 0x09c0, 0xc09e,	0x09ff, 0xc09e,		0x21, 0
	.dw 0x0a40, 0xc09e,	0x0a7f, 0xc09e,		0x21, 0
	.dw 0x0ac0, 0xc09e,	0x0aff, 0xc09e,		0x21, 0
	.dw 0x0b40, 0xc09e,	0x0b7f, 0xc09e,		0x21, 0
	.dw 0x0bc0, 0xc09e,	0x0bff, 0xc09e,		0x21, 0
	.dw 0x0c40, 0xc09e,	0x0c7f, 0xc09e,		0x21, 0
	.dw 0x0cc0, 0xc09e,	0x0cff, 0xc09e,		0x21, 0
	.dw 0x0d40, 0xc09e,	0x0d7f, 0xc09e,		0x21, 0
	.dw 0x0dc0, 0xc09e,	0x0dff, 0xc09e,		0x21, 0
	.dw 0x0e40, 0xc09e,	0x0e7f, 0xc09e,		0x21, 0
	.dw 0x0ec0, 0xc09e,	0x0eff, 0xc09e,		0x21, 0
	.dw 0x0f40, 0xc09e,	0x0f7f, 0xc09e,		0x21, 0
	.dw 0x0fc0, 0xc09e,	0x0fff, 0xc09e,		0x21, 0
	.dw 0x1040, 0xc09e,	0x107f, 0xc09e,		0x21, 0
	.dw 0x10c0, 0xc09e,	0x10ff, 0xc09e,		0x21, 0
	.dw 0x1140, 0xc09e,	0x117f, 0xc09e,		0x21, 0
	.dw 0x11c0, 0xc09e,	0x11ff, 0xc09e,		0x21, 0
	.dw 0x1240, 0xc09e,	0x127f, 0xc09e,		0x21, 0
	.dw 0x12c0, 0xc09e,	0x12ff, 0xc09e,		0x21, 0
	.dw 0x1340, 0xc09e,	0x137f, 0xc09e,		0x21, 0
	.dw 0x13c0, 0xc09e,	0x13ff, 0xc09e,		0x21, 0
	.dw 0x1440, 0xc09e,	0x147f, 0xc09e,		0x21, 0
	.dw 0x14c0, 0xc09e,	0x14ff, 0xc09e,		0x21, 0
	.dw 0x1540, 0xc09e,	0x157f, 0xc09e,		0x21, 0
	.dw 0x15c0, 0xc09e,	0x15ff, 0xc09e,		0x21, 0
	.dw 0x1640, 0xc09e,	0x167f, 0xc09e,		0x21, 0
	.dw 0x16c0, 0xc09e,	0x16ff, 0xc09e,		0x21, 0
	.dw 0x1740, 0xc09e,	0x177f, 0xc09e,		0x21, 0
	.dw 0x17c0, 0xc09e,	0x17ff, 0xc09e,		0x21, 0
	.dw 0x1840, 0xc09e,	0x187f, 0xc09e,		0x21, 0
	.dw 0x18c0, 0xc09e,	0x18ff, 0xc09e,		0x21, 0
	.dw 0x1940, 0xc09e,	0x197f, 0xc09e,		0x21, 0
	.dw 0x19c0, 0xc09e,	0x1fff, 0xc09e,		0x21, 0
	.dw 0x2040, 0xc09e,	0x207f, 0xc09e,		0x21, 0
	.dw 0x20c0, 0xc09e,	0x20ff, 0xc09e,		0x21, 0
	.dw 0x2140, 0xc09e,	0x217f, 0xc09e,		0x21, 0
	.dw 0x21c0, 0xc09e,	0x21ff, 0xc09e,		0x21, 0
	.dw 0x2240, 0xc09e,	0x227f, 0xc09e,		0x21, 0
	.dw 0x22c0, 0xc09e,	0x22ff, 0xc09e,		0x21, 0
	.dw 0x2340, 0xc09e,	0x237f, 0xc09e,		0x21, 0
	.dw 0x23c0, 0xc09e,	0x23ff, 0xc09e,		0x21, 0
	.dw 0x2440, 0xc09e,	0x247f, 0xc09e,		0x21, 0
	.dw 0x24c0, 0xc09e,	0x24ff, 0xc09e,		0x21, 0
	.dw 0x2540, 0xc09e,	0x257f, 0xc09e,		0x21, 0
	.dw 0x25c0, 0xc09e,	0x25ff, 0xc09e,		0x21, 0
	.dw 0x2640, 0xc09e,	0x267f, 0xc09e,		0x21, 0
	.dw 0x26c0, 0xc09e,	0x26ff, 0xc09e,		0x21, 0
	.dw 0x2740, 0xc09e,	0x277f, 0xc09e,		0x21, 0
	.dw 0x27c0, 0xc09e,	0x27ff, 0xc09e,		0x21, 0
	.dw 0x2840, 0xc09e,	0x287f, 0xc09e,		0x21, 0
	.dw 0x28c0, 0xc09e,	0x28ff, 0xc09e,		0x21, 0
	.dw 0x2940, 0xc09e,	0x297f, 0xc09e,		0x21, 0
	.dw 0x29c0, 0xc09e,	0x29ff, 0xc09e,		0x21, 0
	.dw 0x2a40, 0xc09e,	0x2a7f, 0xc09e,		0x21, 0
	.dw 0x2ac0, 0xc09e,	0x2aff, 0xc09e,		0x21, 0
	.dw 0x2b40, 0xc09e,	0x2b7f, 0xc09e,		0x21, 0
	.dw 0x2bc0, 0xc09e,	0x2bff, 0xc09e,		0x21, 0
	.dw 0x2c40, 0xc09e,	0x2c7f, 0xc09e,		0x21, 0
	.dw 0x2cc0, 0xc09e,	0x2cff, 0xc09e,		0x21, 0
	.dw 0x2d40, 0xc09e,	0x2d7f, 0xc09e,		0x21, 0
	.dw 0x2dc0, 0xc09e,	0x2dff, 0xc09e,		0x21, 0
	.dw 0x2e40, 0xc09e,	0x2e7f, 0xc09e,		0x21, 0
	.dw 0x2ec0, 0xc09e,	0x2eff, 0xc09e,		0x21, 0
	.dw 0x2f40, 0xc09e,	0x2f7f, 0xc09e,		0x21, 0
	.dw 0x2fc0, 0xc09e,	0x2fff, 0xc09e,		0x21, 0
	.dw 0x3040, 0xc09e,	0x307f, 0xc09e,		0x21, 0
	.dw 0x30c0, 0xc09e,	0x30ff, 0xc09e,		0x21, 0
	.dw 0x3140, 0xc09e,	0x317f, 0xc09e,		0x21, 0
	.dw 0x31c0, 0xc09e,	0x31ff, 0xc09e,		0x21, 0
	.dw 0x3240, 0xc09e,	0x327f, 0xc09e,		0x21, 0
	.dw 0x32c0, 0xc09e,	0x32ff, 0xc09e,		0x21, 0
	.dw 0x3340, 0xc09e,	0x337f, 0xc09e,		0x21, 0
	.dw 0x33c0, 0xc09e,	0x33ff, 0xc09e,		0x21, 0
	.dw 0x3440, 0xc09e,	0x347f, 0xc09e,		0x21, 0
	.dw 0x34c0, 0xc09e,	0x34ff, 0xc09e,		0x21, 0
	.dw 0x3540, 0xc09e,	0x357f, 0xc09e,		0x21, 0
	.dw 0x35c0, 0xc09e,	0x35ff, 0xc09e,		0x21, 0
	.dw 0x3640, 0xc09e,	0x367f, 0xc09e,		0x21, 0
	.dw 0x36c0, 0xc09e,	0x36ff, 0xc09e,		0x21, 0
	.dw 0x3740, 0xc09e,	0x377f, 0xc09e,		0x21, 0
	.dw 0x37c0, 0xc09e,	0x37ff, 0xc09e,		0x21, 0
	.dw 0x3840, 0xc09e,	0x387f, 0xc09e,		0x21, 0
	.dw 0x38c0, 0xc09e,	0x38ff, 0xc09e,		0x21, 0
	.dw 0x3940, 0xc09e,	0x397f, 0xc09e,		0x21, 0
	.dw 0x39c0, 0xc09e,	0x3fff, 0xc09e,		0x21, 0
	.dw 0x4040, 0xc09e,	0x407f, 0xc09e,		0x21, 0
	.dw 0x40c0, 0xc09e,	0x40ff, 0xc09e,		0x21, 0
	.dw 0x4140, 0xc09e,	0x417f, 0xc09e,		0x21, 0
	.dw 0x41c0, 0xc09e,	0x41ff, 0xc09e,		0x21, 0
	.dw 0x4240, 0xc09e,	0x427f, 0xc09e,		0x21, 0
	.dw 0x42c0, 0xc09e,	0x42ff, 0xc09e,		0x21, 0
	.dw 0x4340, 0xc09e,	0x437f, 0xc09e,		0x21, 0
	.dw 0x43c0, 0xc09e,	0x43ff, 0xc09e,		0x21, 0
	.dw 0x4440, 0xc09e,	0x447f, 0xc09e,		0x21, 0
	.dw 0x44c0, 0xc09e,	0x44ff, 0xc09e,		0x21, 0
	.dw 0x4540, 0xc09e,	0x457f, 0xc09e,		0x21, 0
	.dw 0x45c0, 0xc09e,	0x45ff, 0xc09e,		0x21, 0
	.dw 0x4640, 0xc09e,	0x467f, 0xc09e,		0x21, 0
	.dw 0x46c0, 0xc09e,	0x46ff, 0xc09e,		0x21, 0
	.dw 0x4740, 0xc09e,	0x477f, 0xc09e,		0x21, 0
	.dw 0x47c0, 0xc09e,	0x47ff, 0xc09e,		0x21, 0
	.dw 0x4840, 0xc09e,	0x487f, 0xc09e,		0x21, 0
	.dw 0x48c0, 0xc09e,	0x48ff, 0xc09e,		0x21, 0
	.dw 0x4940, 0xc09e,	0x497f, 0xc09e,		0x21, 0
	.dw 0x49c0, 0xc09e,	0x49ff, 0xc09e,		0x21, 0
	.dw 0x4a40, 0xc09e,	0x4a7f, 0xc09e,		0x21, 0
	.dw 0x4ac0, 0xc09e,	0x4aff, 0xc09e,		0x21, 0
	.dw 0x4b40, 0xc09e,	0x4b7f, 0xc09e,		0x21, 0
	.dw 0x4bc0, 0xc09e,	0x4bff, 0xc09e,		0x21, 0
	.dw 0x4c40, 0xc09e,	0x4c7f, 0xc09e,		0x21, 0
	.dw 0x4cc0, 0xc09e,	0x4cff, 0xc09e,		0x21, 0
	.dw 0x4d40, 0xc09e,	0x4d7f, 0xc09e,		0x21, 0
	.dw 0x4dc0, 0xc09e,	0x4dff, 0xc09e,		0x21, 0
	.dw 0x4e40, 0xc09e,	0x4e7f, 0xc09e,		0x21, 0
	.dw 0x4ec0, 0xc09e,	0x4eff, 0xc09e,		0x21, 0
	.dw 0x4f40, 0xc09e,	0x4f7f, 0xc09e,		0x21, 0
	.dw 0x4fc0, 0xc09e,	0x4fff, 0xc09e,		0x21, 0
	.dw 0x5040, 0xc09e,	0x507f, 0xc09e,		0x21, 0
	.dw 0x50c0, 0xc09e,	0x50ff, 0xc09e,		0x21, 0
	.dw 0x5140, 0xc09e,	0x517f, 0xc09e,		0x21, 0
	.dw 0x51c0, 0xc09e,	0x51ff, 0xc09e,		0x21, 0
	.dw 0x5240, 0xc09e,	0x527f, 0xc09e,		0x21, 0
	.dw 0x52c0, 0xc09e,	0x52ff, 0xc09e,		0x21, 0
	.dw 0x5340, 0xc09e,	0x537f, 0xc09e,		0x21, 0
	.dw 0x53c0, 0xc09e,	0x53ff, 0xc09e,		0x21, 0
	.dw 0x5440, 0xc09e,	0x547f, 0xc09e,		0x21, 0
	.dw 0x54c0, 0xc09e,	0x54ff, 0xc09e,		0x21, 0
	.dw 0x5540, 0xc09e,	0x557f, 0xc09e,		0x21, 0
	.dw 0x55c0, 0xc09e,	0x55ff, 0xc09e,		0x21, 0
	.dw 0x5640, 0xc09e,	0x567f, 0xc09e,		0x21, 0
	.dw 0x56c0, 0xc09e,	0x56ff, 0xc09e,		0x21, 0
	.dw 0x5740, 0xc09e,	0x577f, 0xc09e,		0x21, 0
	.dw 0x57c0, 0xc09e,	0x57ff, 0xc09e,		0x21, 0
	.dw 0x5840, 0xc09e,	0x587f, 0xc09e,		0x21, 0
	.dw 0x58c0, 0xc09e,	0x58ff, 0xc09e,		0x21, 0
	.dw 0x5940, 0xc09e,	0x597f, 0xc09e,		0x21, 0
	.dw 0x59c0, 0xc09e,	0x5fff, 0xc09e,		0x21, 0
	.dw 0x6040, 0xc09e,	0x607f, 0xc09e,		0x21, 0
	.dw 0x60c0, 0xc09e,	0x60ff, 0xc09e,		0x21, 0
	.dw 0x6140, 0xc09e,	0x617f, 0xc09e,		0x21, 0
	.dw 0x61c0, 0xc09e,	0x61ff, 0xc09e,		0x21, 0
	.dw 0x6240, 0xc09e,	0x627f, 0xc09e,		0x21, 0
	.dw 0x62c0, 0xc09e,	0x62ff, 0xc09e,		0x21, 0
	.dw 0x6340, 0xc09e,	0x637f, 0xc09e,		0x21, 0
	.dw 0x63c0, 0xc09e,	0x63ff, 0xc09e,		0x21, 0
	.dw 0x6440, 0xc09e,	0x647f, 0xc09e,		0x21, 0
	.dw 0x64c0, 0xc09e,	0x64ff, 0xc09e,		0x21, 0
	.dw 0x6540, 0xc09e,	0x657f, 0xc09e,		0x21, 0
	.dw 0x65c0, 0xc09e,	0x65ff, 0xc09e,		0x21, 0
	.dw 0x6640, 0xc09e,	0x667f, 0xc09e,		0x21, 0
	.dw 0x66c0, 0xc09e,	0x66ff, 0xc09e,		0x21, 0
	.dw 0x6740, 0xc09e,	0x677f, 0xc09e,		0x21, 0
	.dw 0x67c0, 0xc09e,	0x67ff, 0xc09e,		0x21, 0
	.dw 0x6840, 0xc09e,	0x687f, 0xc09e,		0x21, 0
	.dw 0x68c0, 0xc09e,	0x68ff, 0xc09e,		0x21, 0
	.dw 0x6940, 0xc09e,	0x697f, 0xc09e,		0x21, 0
	.dw 0x69c0, 0xc09e,	0x69ff, 0xc09e,		0x21, 0
	.dw 0x6a40, 0xc09e,	0x6a7f, 0xc09e,		0x21, 0
	.dw 0x6ac0, 0xc09e,	0x6aff, 0xc09e,		0x21, 0
	.dw 0x6b40, 0xc09e,	0x6b7f, 0xc09e,		0x21, 0
	.dw 0x6bc0, 0xc09e,	0x6bff, 0xc09e,		0x21, 0
	.dw 0x6c40, 0xc09e,	0x6c7f, 0xc09e,		0x21, 0
	.dw 0x6cc0, 0xc09e,	0x6cff, 0xc09e,		0x21, 0
	.dw 0x6d40, 0xc09e,	0x6d7f, 0xc09e,		0x21, 0
	.dw 0x6dc0, 0xc09e,	0x6dff, 0xc09e,		0x21, 0
	.dw 0x6e40, 0xc09e,	0x6e7f, 0xc09e,		0x21, 0
	.dw 0x6ec0, 0xc09e,	0x6eff, 0xc09e,		0x21, 0
	.dw 0x6f40, 0xc09e,	0x6f7f, 0xc09e,		0x21, 0
	.dw 0x6fc0, 0xc09e,	0x6fff, 0xc09e,		0x21, 0
	.dw 0x7040, 0xc09e,	0x707f, 0xc09e,		0x21, 0
	.dw 0x70c0, 0xc09e,	0x70ff, 0xc09e,		0x21, 0
	.dw 0x7140, 0xc09e,	0x717f, 0xc09e,		0x21, 0
	.dw 0x71c0, 0xc09e,	0x71ff, 0xc09e,		0x21, 0
	.dw 0x7240, 0xc09e,	0x727f, 0xc09e,		0x21, 0
	.dw 0x72c0, 0xc09e,	0x72ff, 0xc09e,		0x21, 0
	.dw 0x7340, 0xc09e,	0x737f, 0xc09e,		0x21, 0
	.dw 0x73c0, 0xc09e,	0x73ff, 0xc09e,		0x21, 0
	.dw 0x7440, 0xc09e,	0x747f, 0xc09e,		0x21, 0
	.dw 0x74c0, 0xc09e,	0x74ff, 0xc09e,		0x21, 0
	.dw 0x7540, 0xc09e,	0x757f, 0xc09e,		0x21, 0
	.dw 0x75c0, 0xc09e,	0x75ff, 0xc09e,		0x21, 0
	.dw 0x7640, 0xc09e,	0x767f, 0xc09e,		0x21, 0
	.dw 0x76c0, 0xc09e,	0x76ff, 0xc09e,		0x21, 0
	.dw 0x7740, 0xc09e,	0x777f, 0xc09e,		0x21, 0
	.dw 0x77c0, 0xc09e,	0x77ff, 0xc09e,		0x21, 0
	.dw 0x7840, 0xc09e,	0x787f, 0xc09e,		0x21, 0
	.dw 0x78c0, 0xc09e,	0x78ff, 0xc09e,		0x21, 0
	.dw 0x7940, 0xc09e,	0x797f, 0xc09e,		0x21, 0
	.dw 0x79c0, 0xc09e,	0x7fff, 0xc09e,		0x21, 0
	.dw 0x8040, 0xc09e,	0x807f, 0xc09e,		0x21, 0
	.dw 0x80c0, 0xc09e,	0x80ff, 0xc09e,		0x21, 0
	.dw 0x8140, 0xc09e,	0x817f, 0xc09e,		0x21, 0
	.dw 0x81c0, 0xc09e,	0x81ff, 0xc09e,		0x21, 0
	.dw 0x8240, 0xc09e,	0x827f, 0xc09e,		0x21, 0
	.dw 0x82c0, 0xc09e,	0x82ff, 0xc09e,		0x21, 0
	.dw 0x8340, 0xc09e,	0x837f, 0xc09e,		0x21, 0
	.dw 0x83c0, 0xc09e,	0x83ff, 0xc09e,		0x21, 0
	.dw 0x8440, 0xc09e,	0x847f, 0xc09e,		0x21, 0
	.dw 0x84c0, 0xc09e,	0x84ff, 0xc09e,		0x21, 0
	.dw 0x8540, 0xc09e,	0x857f, 0xc09e,		0x21, 0
	.dw 0x85c0, 0xc09e,	0x85ff, 0xc09e,		0x21, 0
	.dw 0x8640, 0xc09e,	0x867f, 0xc09e,		0x21, 0
	.dw 0x86c0, 0xc09e,	0x86ff, 0xc09e,		0x21, 0
	.dw 0x8740, 0xc09e,	0x877f, 0xc09e,		0x21, 0
	.dw 0x87c0, 0xc09e,	0x87ff, 0xc09e,		0x21, 0
	.dw 0x8840, 0xc09e,	0x887f, 0xc09e,		0x21, 0
	.dw 0x88c0, 0xc09e,	0x88ff, 0xc09e,		0x21, 0
	.dw 0x8940, 0xc09e,	0x897f, 0xc09e,		0x21, 0
	.dw 0x89c0, 0xc09e,	0x89ff, 0xc09e,		0x21, 0
	.dw 0x8a40, 0xc09e,	0x8a7f, 0xc09e,		0x21, 0
	.dw 0x8ac0, 0xc09e,	0x8aff, 0xc09e,		0x21, 0
	.dw 0x8b40, 0xc09e,	0x8b7f, 0xc09e,		0x21, 0
	.dw 0x8bc0, 0xc09e,	0x8bff, 0xc09e,		0x21, 0
	.dw 0x8c40, 0xc09e,	0x8c7f, 0xc09e,		0x21, 0
	.dw 0x8cc0, 0xc09e,	0x8cff, 0xc09e,		0x21, 0
	.dw 0x8d40, 0xc09e,	0x8d7f, 0xc09e,		0x21, 0
	.dw 0x8dc0, 0xc09e,	0x8dff, 0xc09e,		0x21, 0
	.dw 0x8e40, 0xc09e,	0x8e7f, 0xc09e,		0x21, 0
	.dw 0x8ec0, 0xc09e,	0x8eff, 0xc09e,		0x21, 0
	.dw 0x8f40, 0xc09e,	0x8f7f, 0xc09e,		0x21, 0
	.dw 0x8fc0, 0xc09e,	0x8fff, 0xc09e,		0x21, 0
	.dw 0x9040, 0xc09e,	0x907f, 0xc09e,		0x21, 0
	.dw 0x90c0, 0xc09e,	0x90ff, 0xc09e,		0x21, 0
	.dw 0x9140, 0xc09e,	0x917f, 0xc09e,		0x21, 0
	.dw 0x91c0, 0xc09e,	0x91ff, 0xc09e,		0x21, 0
	.dw 0x9240, 0xc09e,	0x927f, 0xc09e,		0x21, 0
	.dw 0x92c0, 0xc09e,	0x92ff, 0xc09e,		0x21, 0
	.dw 0x9340, 0xc09e,	0x937f, 0xc09e,		0x21, 0
	.dw 0x93c0, 0xc09e,	0x93ff, 0xc09e,		0x21, 0
	.dw 0x9440, 0xc09e,	0x947f, 0xc09e,		0x21, 0
	.dw 0x94c0, 0xc09e,	0x94ff, 0xc09e,		0x21, 0
	.dw 0x9540, 0xc09e,	0x957f, 0xc09e,		0x21, 0
	.dw 0x95c0, 0xc09e,	0x95ff, 0xc09e,		0x21, 0
	.dw 0x9640, 0xc09e,	0x967f, 0xc09e,		0x21, 0
	.dw 0x96c0, 0xc09e,	0x96ff, 0xc09e,		0x21, 0
	.dw 0x9740, 0xc09e,	0x977f, 0xc09e,		0x21, 0
	.dw 0x97c0, 0xc09e,	0x97ff, 0xc09e,		0x21, 0
	.dw 0x9840, 0xc09e,	0x987f, 0xc09e,		0x21, 0
	.dw 0x98c0, 0xc09e,	0x98ff, 0xc09e,		0x21, 0
	.dw 0x9940, 0xc09e,	0x997f, 0xc09e,		0x21, 0
	.dw 0x99c0, 0xc09e,	0x9fff, 0xc09e,		0x21, 0
	.dw 0xa040, 0xc09e,	0xa07f, 0xc09e,		0x21, 0
	.dw 0xa0c0, 0xc09e,	0xa0ff, 0xc09e,		0x21, 0
	.dw 0xa140, 0xc09e,	0xa17f, 0xc09e,		0x21, 0
	.dw 0xa1c0, 0xc09e,	0xa1ff, 0xc09e,		0x21, 0
	.dw 0xa240, 0xc09e,	0xa27f, 0xc09e,		0x21, 0
	.dw 0xa2c0, 0xc09e,	0xa2ff, 0xc09e,		0x21, 0
	.dw 0xa340, 0xc09e,	0xa37f, 0xc09e,		0x21, 0
	.dw 0xa3c0, 0xc09e,	0xa3ff, 0xc09e,		0x21, 0
	.dw 0xa440, 0xc09e,	0xa47f, 0xc09e,		0x21, 0
	.dw 0xa4c0, 0xc09e,	0xa4ff, 0xc09e,		0x21, 0
	.dw 0xa540, 0xc09e,	0xa57f, 0xc09e,		0x21, 0
	.dw 0xa5c0, 0xc09e,	0xa5ff, 0xc09e,		0x21, 0
	.dw 0xa640, 0xc09e,	0xa67f, 0xc09e,		0x21, 0
	.dw 0xa6c0, 0xc09e,	0xa6ff, 0xc09e,		0x21, 0
	.dw 0xa740, 0xc09e,	0xa77f, 0xc09e,		0x21, 0
	.dw 0xa7c0, 0xc09e,	0xa7ff, 0xc09e,		0x21, 0
	.dw 0xa840, 0xc09e,	0xa87f, 0xc09e,		0x21, 0
	.dw 0xa8c0, 0xc09e,	0xa8ff, 0xc09e,		0x21, 0
	.dw 0xa940, 0xc09e,	0xa97f, 0xc09e,		0x21, 0
	.dw 0xa9c0, 0xc09e,	0xa9ff, 0xc09e,		0x21, 0
	.dw 0xaa40, 0xc09e,	0xaa7f, 0xc09e,		0x21, 0
	.dw 0xaac0, 0xc09e,	0xaaff, 0xc09e,		0x21, 0
	.dw 0xab40, 0xc09e,	0xab7f, 0xc09e,		0x21, 0
	.dw 0xabc0, 0xc09e,	0xabff, 0xc09e,		0x21, 0
	.dw 0xac40, 0xc09e,	0xac7f, 0xc09e,		0x21, 0
	.dw 0xacc0, 0xc09e,	0xacff, 0xc09e,		0x21, 0
	.dw 0xad40, 0xc09e,	0xad7f, 0xc09e,		0x21, 0
	.dw 0xadc0, 0xc09e,	0xadff, 0xc09e,		0x21, 0
	.dw 0xae40, 0xc09e,	0xae7f, 0xc09e,		0x21, 0
	.dw 0xaec0, 0xc09e,	0xaeff, 0xc09e,		0x21, 0
	.dw 0xaf40, 0xc09e,	0xaf7f, 0xc09e,		0x21, 0
	.dw 0xafc0, 0xc09e,	0xafff, 0xc09e,		0x21, 0
	.dw 0xb040, 0xc09e,	0xb07f, 0xc09e,		0x21, 0
	.dw 0xb0c0, 0xc09e,	0xb0ff, 0xc09e,		0x21, 0
	.dw 0xb140, 0xc09e,	0xb17f, 0xc09e,		0x21, 0
	.dw 0xb1c0, 0xc09e,	0xb1ff, 0xc09e,		0x21, 0
	.dw 0xb240, 0xc09e,	0xb27f, 0xc09e,		0x21, 0
	.dw 0xb2c0, 0xc09e,	0xb2ff, 0xc09e,		0x21, 0
	.dw 0xb340, 0xc09e,	0xb37f, 0xc09e,		0x21, 0
	.dw 0xb3c0, 0xc09e,	0xb3ff, 0xc09e,		0x21, 0
	.dw 0xb440, 0xc09e,	0xb47f, 0xc09e,		0x21, 0
	.dw 0xb4c0, 0xc09e,	0xb4ff, 0xc09e,		0x21, 0
	.dw 0xb540, 0xc09e,	0xb57f, 0xc09e,		0x21, 0
	.dw 0xb5c0, 0xc09e,	0xb5ff, 0xc09e,		0x21, 0
	.dw 0xb640, 0xc09e,	0xb67f, 0xc09e,		0x21, 0
	.dw 0xb6c0, 0xc09e,	0xb6ff, 0xc09e,		0x21, 0
	.dw 0xb740, 0xc09e,	0xb77f, 0xc09e,		0x21, 0
	.dw 0xb7c0, 0xc09e,	0xb7ff, 0xc09e,		0x21, 0
	.dw 0xb840, 0xc09e,	0xb87f, 0xc09e,		0x21, 0
	.dw 0xb8c0, 0xc09e,	0xb8ff, 0xc09e,		0x21, 0
	.dw 0xb940, 0xc09e,	0xb97f, 0xc09e,		0x21, 0
	.dw 0xb9c0, 0xc09e,	0xbfff, 0xc09e,		0x21, 0
	.dw 0xc040, 0xc09e,	0xc07f, 0xc09e,		0x21, 0
	.dw 0xc0c0, 0xc09e,	0xc0ff, 0xc09e,		0x21, 0
	.dw 0xc140, 0xc09e,	0xc17f, 0xc09e,		0x21, 0
	.dw 0xc1c0, 0xc09e,	0xc1ff, 0xc09e,		0x21, 0
	.dw 0xc240, 0xc09e,	0xc27f, 0xc09e,		0x21, 0
	.dw 0xc2c0, 0xc09e,	0xc2ff, 0xc09e,		0x21, 0
	.dw 0xc340, 0xc09e,	0xc37f, 0xc09e,		0x21, 0
	.dw 0xc3c0, 0xc09e,	0xc3ff, 0xc09e,		0x21, 0
	.dw 0xc440, 0xc09e,	0xc47f, 0xc09e,		0x21, 0
	.dw 0xc4c0, 0xc09e,	0xc4ff, 0xc09e,		0x21, 0
	.dw 0xc540, 0xc09e,	0xc57f, 0xc09e,		0x21, 0
	.dw 0xc5c0, 0xc09e,	0xc5ff, 0xc09e,		0x21, 0
	.dw 0xc640, 0xc09e,	0xc67f, 0xc09e,		0x21, 0
	.dw 0xc6c0, 0xc09e,	0xc6ff, 0xc09e,		0x21, 0
	.dw 0xc740, 0xc09e,	0xc77f, 0xc09e,		0x21, 0
	.dw 0xc7c0, 0xc09e,	0xc7ff, 0xc09e,		0x21, 0
	.dw 0xc840, 0xc09e,	0xc87f, 0xc09e,		0x21, 0
	.dw 0xc8c0, 0xc09e,	0xc8ff, 0xc09e,		0x21, 0
	.dw 0xc940, 0xc09e,	0xc97f, 0xc09e,		0x21, 0
	.dw 0xc9c0, 0xc09e,	0xc9ff, 0xc09e,		0x21, 0
	.dw 0xca40, 0xc09e,	0xca7f, 0xc09e,		0x21, 0
	.dw 0xcac0, 0xc09e,	0xcaff, 0xc09e,		0x21, 0
	.dw 0xcb40, 0xc09e,	0xcb7f, 0xc09e,		0x21, 0
	.dw 0xcbc0, 0xc09e,	0xcbff, 0xc09e,		0x21, 0
	.dw 0xcc40, 0xc09e,	0xcc7f, 0xc09e,		0x21, 0
	.dw 0xccc0, 0xc09e,	0xccff, 0xc09e,		0x21, 0
	.dw 0xcd40, 0xc09e,	0xcd7f, 0xc09e,		0x21, 0
	.dw 0xcdc0, 0xc09e,	0xcdff, 0xc09e,		0x21, 0
	.dw 0xce40, 0xc09e,	0xce7f, 0xc09e,		0x21, 0
	.dw 0xcec0, 0xc09e,	0xceff, 0xc09e,		0x21, 0
	.dw 0xcf40, 0xc09e,	0xcf7f, 0xc09e,		0x21, 0
	.dw 0xcfc0, 0xc09e,	0xcfff, 0xc09e,		0x21, 0
	.dw 0xd040, 0xc09e,	0xd07f, 0xc09e,		0x21, 0
	.dw 0xd0c0, 0xc09e,	0xd0ff, 0xc09e,		0x21, 0
	.dw 0xd140, 0xc09e,	0xd17f, 0xc09e,		0x21, 0
	.dw 0xd1c0, 0xc09e,	0xd1ff, 0xc09e,		0x21, 0
	.dw 0xd240, 0xc09e,	0xd27f, 0xc09e,		0x21, 0
	.dw 0xd2c0, 0xc09e,	0xd2ff, 0xc09e,		0x21, 0
	.dw 0xd340, 0xc09e,	0xd37f, 0xc09e,		0x21, 0
	.dw 0xd3c0, 0xc09e,	0xd3ff, 0xc09e,		0x21, 0
	.dw 0xd440, 0xc09e,	0xd47f, 0xc09e,		0x21, 0
	.dw 0xd4c0, 0xc09e,	0xd4ff, 0xc09e,		0x21, 0
	.dw 0xd540, 0xc09e,	0xd57f, 0xc09e,		0x21, 0
	.dw 0xd5c0, 0xc09e,	0xd5ff, 0xc09e,		0x21, 0
	.dw 0xd640, 0xc09e,	0xd67f, 0xc09e,		0x21, 0
	.dw 0xd6c0, 0xc09e,	0xd6ff, 0xc09e,		0x21, 0
	.dw 0xd740, 0xc09e,	0xd77f, 0xc09e,		0x21, 0
	.dw 0xd7c0, 0xc09e,	0xd7ff, 0xc09e,		0x21, 0
	.dw 0xd840, 0xc09e,	0xd87f, 0xc09e,		0x21, 0
	.dw 0xd8c0, 0xc09e,	0xd8ff, 0xc09e,		0x21, 0
	.dw 0xd940, 0xc09e,	0xd97f, 0xc09e,		0x21, 0
	.dw 0xd9c0, 0xc09e,	0xdfff, 0xc09e,		0x21, 0
	.dw 0xe040, 0xc09e,	0xe07f, 0xc09e,		0x21, 0
	.dw 0xe0c0, 0xc09e,	0xe0ff, 0xc09e,		0x21, 0
	.dw 0xe140, 0xc09e,	0xe17f, 0xc09e,		0x21, 0
	.dw 0xe1c0, 0xc09e,	0xe1ff, 0xc09e,		0x21, 0
	.dw 0xe240, 0xc09e,	0xe27f, 0xc09e,		0x21, 0
	.dw 0xe2c0, 0xc09e,	0xe2ff, 0xc09e,		0x21, 0
	.dw 0xe340, 0xc09e,	0xe37f, 0xc09e,		0x21, 0
	.dw 0xe3c0, 0xc09e,	0xe3ff, 0xc09e,		0x21, 0
	.dw 0xe440, 0xc09e,	0xe47f, 0xc09e,		0x21, 0
	.dw 0xe4c0, 0xc09e,	0xe4ff, 0xc09e,		0x21, 0
	.dw 0xe540, 0xc09e,	0xe57f, 0xc09e,		0x21, 0
	.dw 0xe5c0, 0xc09e,	0xe5ff, 0xc09e,		0x21, 0
	.dw 0xe640, 0xc09e,	0xe67f, 0xc09e,		0x21, 0
	.dw 0xe6c0, 0xc09e,	0xe6ff, 0xc09e,		0x21, 0
	.dw 0xe740, 0xc09e,	0xe77f, 0xc09e,		0x21, 0
	.dw 0xe7c0, 0xc09e,	0xe7ff, 0xc09e,		0x21, 0
	.dw 0xe840, 0xc09e,	0xe87f, 0xc09e,		0x21, 0
	.dw 0xe8c0, 0xc09e,	0xe8ff, 0xc09e,		0x21, 0
	.dw 0xe940, 0xc09e,	0xe97f, 0xc09e,		0x21, 0
	.dw 0xe9c0, 0xc09e,	0xe9ff, 0xc09e,		0x21, 0
	.dw 0xea40, 0xc09e,	0xea7f, 0xc09e,		0x21, 0
	.dw 0xeac0, 0xc09e,	0xeaff, 0xc09e,		0x21, 0
	.dw 0xeb40, 0xc09e,	0xeb7f, 0xc09e,		0x21, 0
	.dw 0xebc0, 0xc09e,	0xebff, 0xc09e,		0x21, 0
	.dw 0xec40, 0xc09e,	0xec7f, 0xc09e,		0x21, 0
	.dw 0xecc0, 0xc09e,	0xecff, 0xc09e,		0x21, 0
	.dw 0xed40, 0xc09e,	0xed7f, 0xc09e,		0x21, 0
	.dw 0xedc0, 0xc09e,	0xedff, 0xc09e,		0x21, 0
	.dw 0xee40, 0xc09e,	0xee7f, 0xc09e,		0x21, 0
	.dw 0xeec0, 0xc09e,	0xeeff, 0xc09e,		0x21, 0
	.dw 0xef40, 0xc09e,	0xef7f, 0xc09e,		0x21, 0
	.dw 0xefc0, 0xc09e,	0xefff, 0xc09e,		0x21, 0
	.dw 0xf040, 0xc09e,	0xf07f, 0xc09e,		0x21, 0
	.dw 0xf0c0, 0xc09e,	0xf0ff, 0xc09e,		0x21, 0
	.dw 0xf140, 0xc09e,	0xf17f, 0xc09e,		0x21, 0
	.dw 0xf1c0, 0xc09e,	0xf1ff, 0xc09e,		0x21, 0
	.dw 0xf240, 0xc09e,	0xf27f, 0xc09e,		0x21, 0
	.dw 0xf2c0, 0xc09e,	0xf2ff, 0xc09e,		0x21, 0
	.dw 0xf340, 0xc09e,	0xf37f, 0xc09e,		0x21, 0
	.dw 0xf3c0, 0xc09e,	0xf3ff, 0xc09e,		0x21, 0
	.dw 0xf440, 0xc09e,	0xf47f, 0xc09e,		0x21, 0
	.dw 0xf4c0, 0xc09e,	0xf4ff, 0xc09e,		0x21, 0
	.dw 0xf540, 0xc09e,	0xf57f, 0xc09e,		0x21, 0
	.dw 0xf5c0, 0xc09e,	0xf5ff, 0xc09e,		0x21, 0
	.dw 0xf640, 0xc09e,	0xf67f, 0xc09e,		0x21, 0
	.dw 0xf6c0, 0xc09e,	0xf6ff, 0xc09e,		0x21, 0
	.dw 0xf740, 0xc09e,	0xf77f, 0xc09e,		0x21, 0
	.dw 0xf7c0, 0xc09e,	0xf7ff, 0xc09e,		0x21, 0
	.dw 0xf840, 0xc09e,	0xf87f, 0xc09e,		0x21, 0
	.dw 0xf8c0, 0xc09e,	0xf8ff, 0xc09e,		0x21, 0
	.dw 0xf940, 0xc09e,	0xf97f, 0xc09e,		0x21, 0
	.dw 0xf9c0, 0xc09e,	0xffff, 0xc09e,		0x21, 0
	.dw 0x0040, 0xc09f,	0x007f, 0xc09f,		0x21, 0
	.dw 0x00c0, 0xc09f,	0x00ff, 0xc09f,		0x21, 0
	.dw 0x0140, 0xc09f,	0x017f, 0xc09f,		0x21, 0
	.dw 0x01c0, 0xc09f,	0x01ff, 0xc09f,		0x21, 0
	.dw 0x0240, 0xc09f,	0x027f, 0xc09f,		0x21, 0
	.dw 0x02c0, 0xc09f,	0x02ff, 0xc09f,		0x21, 0
	.dw 0x0340, 0xc09f,	0x037f, 0xc09f,		0x21, 0
	.dw 0x03c0, 0xc09f,	0x03ff, 0xc09f,		0x21, 0
	.dw 0x0440, 0xc09f,	0x047f, 0xc09f,		0x21, 0
	.dw 0x04c0, 0xc09f,	0x04ff, 0xc09f,		0x21, 0
	.dw 0x0540, 0xc09f,	0x057f, 0xc09f,		0x21, 0
	.dw 0x05c0, 0xc09f,	0x05ff, 0xc09f,		0x21, 0
	.dw 0x0640, 0xc09f,	0x067f, 0xc09f,		0x21, 0
	.dw 0x06c0, 0xc09f,	0x06ff, 0xc09f,		0x21, 0
	.dw 0x0740, 0xc09f,	0x077f, 0xc09f,		0x21, 0
	.dw 0x07c0, 0xc09f,	0x07ff, 0xc09f,		0x21, 0
	.dw 0x0840, 0xc09f,	0x087f, 0xc09f,		0x21, 0
	.dw 0x08c0, 0xc09f,	0x08ff, 0xc09f,		0x21, 0
	.dw 0x0940, 0xc09f,	0x097f, 0xc09f,		0x21, 0
	.dw 0x09c0, 0xc09f,	0x09ff, 0xc09f,		0x21, 0
	.dw 0x0a40, 0xc09f,	0x0a7f, 0xc09f,		0x21, 0
	.dw 0x0ac0, 0xc09f,	0x0aff, 0xc09f,		0x21, 0
	.dw 0x0b40, 0xc09f,	0x0b7f, 0xc09f,		0x21, 0
	.dw 0x0bc0, 0xc09f,	0x0bff, 0xc09f,		0x21, 0
	.dw 0x0c40, 0xc09f,	0x0c7f, 0xc09f,		0x21, 0
	.dw 0x0cc0, 0xc09f,	0x0cff, 0xc09f,		0x21, 0
	.dw 0x0d40, 0xc09f,	0x0d7f, 0xc09f,		0x21, 0
	.dw 0x0dc0, 0xc09f,	0x0dff, 0xc09f,		0x21, 0
	.dw 0x0e40, 0xc09f,	0x0e7f, 0xc09f,		0x21, 0
	.dw 0x0ec0, 0xc09f,	0x0eff, 0xc09f,		0x21, 0
	.dw 0x0f40, 0xc09f,	0x0f7f, 0xc09f,		0x21, 0
	.dw 0x0fc0, 0xc09f,	0x0fff, 0xc09f,		0x21, 0
	.dw 0x1040, 0xc09f,	0x107f, 0xc09f,		0x21, 0
	.dw 0x10c0, 0xc09f,	0x10ff, 0xc09f,		0x21, 0
	.dw 0x1140, 0xc09f,	0x117f, 0xc09f,		0x21, 0
	.dw 0x11c0, 0xc09f,	0x11ff, 0xc09f,		0x21, 0
	.dw 0x1240, 0xc09f,	0x127f, 0xc09f,		0x21, 0
	.dw 0x12c0, 0xc09f,	0x12ff, 0xc09f,		0x21, 0
	.dw 0x1340, 0xc09f,	0x137f, 0xc09f,		0x21, 0
	.dw 0x13c0, 0xc09f,	0x13ff, 0xc09f,		0x21, 0
	.dw 0x1440, 0xc09f,	0x147f, 0xc09f,		0x21, 0
	.dw 0x14c0, 0xc09f,	0x14ff, 0xc09f,		0x21, 0
	.dw 0x1540, 0xc09f,	0x157f, 0xc09f,		0x21, 0
	.dw 0x15c0, 0xc09f,	0x15ff, 0xc09f,		0x21, 0
	.dw 0x1640, 0xc09f,	0x167f, 0xc09f,		0x21, 0
	.dw 0x16c0, 0xc09f,	0x16ff, 0xc09f,		0x21, 0
	.dw 0x1740, 0xc09f,	0x177f, 0xc09f,		0x21, 0
	.dw 0x17c0, 0xc09f,	0x17ff, 0xc09f,		0x21, 0
	.dw 0x1840, 0xc09f,	0x187f, 0xc09f,		0x21, 0
	.dw 0x18c0, 0xc09f,	0x18ff, 0xc09f,		0x21, 0
	.dw 0x1940, 0xc09f,	0x197f, 0xc09f,		0x21, 0
	.dw 0x19c0, 0xc09f,	0x1fff, 0xc09f,		0x21, 0
	.dw 0x2040, 0xc09f,	0x207f, 0xc09f,		0x21, 0
	.dw 0x20c0, 0xc09f,	0x20ff, 0xc09f,		0x21, 0
	.dw 0x2140, 0xc09f,	0x217f, 0xc09f,		0x21, 0
	.dw 0x21c0, 0xc09f,	0x21ff, 0xc09f,		0x21, 0
	.dw 0x2240, 0xc09f,	0x227f, 0xc09f,		0x21, 0
	.dw 0x22c0, 0xc09f,	0x22ff, 0xc09f,		0x21, 0
	.dw 0x2340, 0xc09f,	0x237f, 0xc09f,		0x21, 0
	.dw 0x23c0, 0xc09f,	0x23ff, 0xc09f,		0x21, 0
	.dw 0x2440, 0xc09f,	0x247f, 0xc09f,		0x21, 0
	.dw 0x24c0, 0xc09f,	0x24ff, 0xc09f,		0x21, 0
	.dw 0x2540, 0xc09f,	0x257f, 0xc09f,		0x21, 0
	.dw 0x25c0, 0xc09f,	0x25ff, 0xc09f,		0x21, 0
	.dw 0x2640, 0xc09f,	0x267f, 0xc09f,		0x21, 0
	.dw 0x26c0, 0xc09f,	0x26ff, 0xc09f,		0x21, 0
	.dw 0x2740, 0xc09f,	0x277f, 0xc09f,		0x21, 0
	.dw 0x27c0, 0xc09f,	0x27ff, 0xc09f,		0x21, 0
	.dw 0x2840, 0xc09f,	0x287f, 0xc09f,		0x21, 0
	.dw 0x28c0, 0xc09f,	0x28ff, 0xc09f,		0x21, 0
	.dw 0x2940, 0xc09f,	0x297f, 0xc09f,		0x21, 0
	.dw 0x29c0, 0xc09f,	0x29ff, 0xc09f,		0x21, 0
	.dw 0x2a40, 0xc09f,	0x2a7f, 0xc09f,		0x21, 0
	.dw 0x2ac0, 0xc09f,	0x2aff, 0xc09f,		0x21, 0
	.dw 0x2b40, 0xc09f,	0x2b7f, 0xc09f,		0x21, 0
	.dw 0x2bc0, 0xc09f,	0x2bff, 0xc09f,		0x21, 0
	.dw 0x2c40, 0xc09f,	0x2c7f, 0xc09f,		0x21, 0
	.dw 0x2cc0, 0xc09f,	0x2cff, 0xc09f,		0x21, 0
	.dw 0x2d40, 0xc09f,	0x2d7f, 0xc09f,		0x21, 0
	.dw 0x2dc0, 0xc09f,	0x2dff, 0xc09f,		0x21, 0
	.dw 0x2e40, 0xc09f,	0x2e7f, 0xc09f,		0x21, 0
	.dw 0x2ec0, 0xc09f,	0x2eff, 0xc09f,		0x21, 0
	.dw 0x2f40, 0xc09f,	0x2f7f, 0xc09f,		0x21, 0
	.dw 0x2fc0, 0xc09f,	0x2fff, 0xc09f,		0x21, 0
	.dw 0x3040, 0xc09f,	0x307f, 0xc09f,		0x21, 0
	.dw 0x30c0, 0xc09f,	0x30ff, 0xc09f,		0x21, 0
	.dw 0x3140, 0xc09f,	0x317f, 0xc09f,		0x21, 0
	.dw 0x31c0, 0xc09f,	0x31ff, 0xc09f,		0x21, 0
	.dw 0x3240, 0xc09f,	0x327f, 0xc09f,		0x21, 0
	.dw 0x32c0, 0xc09f,	0x32ff, 0xc09f,		0x21, 0
	.dw 0x3340, 0xc09f,	0x337f, 0xc09f,		0x21, 0
	.dw 0x33c0, 0xc09f,	0x33ff, 0xc09f,		0x21, 0
	.dw 0x3440, 0xc09f,	0x347f, 0xc09f,		0x21, 0
	.dw 0x34c0, 0xc09f,	0x34ff, 0xc09f,		0x21, 0
	.dw 0x3540, 0xc09f,	0x357f, 0xc09f,		0x21, 0
	.dw 0x35c0, 0xc09f,	0x35ff, 0xc09f,		0x21, 0
	.dw 0x3640, 0xc09f,	0x367f, 0xc09f,		0x21, 0
	.dw 0x36c0, 0xc09f,	0x36ff, 0xc09f,		0x21, 0
	.dw 0x3740, 0xc09f,	0x377f, 0xc09f,		0x21, 0
	.dw 0x37c0, 0xc09f,	0x37ff, 0xc09f,		0x21, 0
	.dw 0x3840, 0xc09f,	0x387f, 0xc09f,		0x21, 0
	.dw 0x38c0, 0xc09f,	0x38ff, 0xc09f,		0x21, 0
	.dw 0x3940, 0xc09f,	0x397f, 0xc09f,		0x21, 0
	.dw 0x39c0, 0xc09f,	0x1fff, 0xc0c0,		0x21, 0
	.dw 0x3a00, 0xc0c0,	0x5fff, 0xc0c0,		0x21, 0
	.dw 0x7a00, 0xc0c0,	0x9fff, 0xc0c0,		0x21, 0
	.dw 0xba00, 0xc0c0,	0xdfff, 0xc0c0,		0x21, 0
	.dw 0xfa00, 0xc0c0,	0x1fff, 0xc0c1,		0x21, 0
	.dw 0x3a00, 0xc0c1,	0x5fff, 0xc0c1,		0x21, 0
	.dw 0x7a00, 0xc0c1,	0x9fff, 0xc0c1,		0x21, 0
	.dw 0xba00, 0xc0c1,	0xdfff, 0xc0c1,		0x21, 0
	.dw 0xfa00, 0xc0c1,	0x1fff, 0xc0c2,		0x21, 0
	.dw 0x3a00, 0xc0c2,	0x5fff, 0xc0c2,		0x21, 0
	.dw 0x7a00, 0xc0c2,	0x9fff, 0xc0c2,		0x21, 0
	.dw 0xba00, 0xc0c2,	0xdfff, 0xc0c2,		0x21, 0
	.dw 0xfa00, 0xc0c2,	0x1fff, 0xc0c3,		0x21, 0
	.dw 0x3a00, 0xc0c3,	0xffff, 0xc0c3,		0x21, 0
	.dw 0x1a00, 0xc0c4,	0x1fff, 0xc0c4,		0x21, 0
	.dw 0x3a00, 0xc0c4,	0x3fff, 0xc0c4,		0x21, 0
	.dw 0x5a00, 0xc0c4,	0x5fff, 0xc0c4,		0x21, 0
	.dw 0x7a00, 0xc0c4,	0x7fff, 0xc0c4,		0x21, 0
	.dw 0x9a00, 0xc0c4,	0x9fff, 0xc0c4,		0x21, 0
	.dw 0xba00, 0xc0c4,	0xbfff, 0xc0c4,		0x21, 0
	.dw 0xda00, 0xc0c4,	0xdfff, 0xc0c4,		0x21, 0
	.dw 0xfa00, 0xc0c4,	0xffff, 0xc0c4,		0x21, 0
	.dw 0x1a00, 0xc0c5,	0x1fff, 0xc0c5,		0x21, 0
	.dw 0x3a00, 0xc0c5,	0x3fff, 0xc0c5,		0x21, 0
	.dw 0x5a00, 0xc0c5,	0x5fff, 0xc0c5,		0x21, 0
	.dw 0x7a00, 0xc0c5,	0x7fff, 0xc0c5,		0x21, 0
	.dw 0x9a00, 0xc0c5,	0x9fff, 0xc0c5,		0x21, 0
	.dw 0xba00, 0xc0c5,	0xbfff, 0xc0c5,		0x21, 0
	.dw 0xda00, 0xc0c5,	0xdfff, 0xc0c5,		0x21, 0
	.dw 0xfa00, 0xc0c5,	0xffff, 0xc0c5,		0x21, 0
	.dw 0x1a00, 0xc0c6,	0x1fff, 0xc0c6,		0x21, 0
	.dw 0x3a00, 0xc0c6,	0x3fff, 0xc0c6,		0x21, 0
	.dw 0x5a00, 0xc0c6,	0x5fff, 0xc0c6,		0x21, 0
	.dw 0x7a00, 0xc0c6,	0x7fff, 0xc0c6,		0x21, 0
	.dw 0x9a00, 0xc0c6,	0x9fff, 0xc0c6,		0x21, 0
	.dw 0xba00, 0xc0c6,	0xbfff, 0xc0c6,		0x21, 0
	.dw 0xda00, 0xc0c6,	0xdfff, 0xc0c6,		0x21, 0
	.dw 0xfa00, 0xc0c6,	0xffff, 0xc0c6,		0x21, 0
	.dw 0x1a00, 0xc0c7,	0x1fff, 0xc0c7,		0x21, 0
	.dw 0x3a00, 0xc0c7,	0x1fff, 0xc0d0,		0x21, 0
	.dw 0x3a00, 0xc0d0,	0x5fff, 0xc0d0,		0x21, 0
	.dw 0x7a00, 0xc0d0,	0x9fff, 0xc0d0,		0x21, 0
	.dw 0xba00, 0xc0d0,	0xdfff, 0xc0d0,		0x21, 0
	.dw 0xfa00, 0xc0d0,	0x1fff, 0xc0d1,		0x21, 0
	.dw 0x3a00, 0xc0d1,	0x5fff, 0xc0d1,		0x21, 0
	.dw 0x7a00, 0xc0d1,	0x9fff, 0xc0d1,		0x21, 0
	.dw 0xba00, 0xc0d1,	0xdfff, 0xc0d1,		0x21, 0
	.dw 0xfa00, 0xc0d1,	0x1fff, 0xc0d2,		0x21, 0
	.dw 0x3a00, 0xc0d2,	0x5fff, 0xc0d2,		0x21, 0
	.dw 0x7a00, 0xc0d2,	0x9fff, 0xc0d2,		0x21, 0
	.dw 0xba00, 0xc0d2,	0xdfff, 0xc0d2,		0x21, 0
	.dw 0xfa00, 0xc0d2,	0xffff, 0xc0d3,		0x21, 0
	.dw 0x1a00, 0xc0d4,	0x1fff, 0xc0d4,		0x21, 0
	.dw 0x3a00, 0xc0d4,	0x3fff, 0xc0d4,		0x21, 0
	.dw 0x5a00, 0xc0d4,	0x5fff, 0xc0d4,		0x21, 0
	.dw 0x7a00, 0xc0d4,	0x7fff, 0xc0d4,		0x21, 0
	.dw 0x9a00, 0xc0d4,	0x9fff, 0xc0d4,		0x21, 0
	.dw 0xba00, 0xc0d4,	0xbfff, 0xc0d4,		0x21, 0
	.dw 0xda00, 0xc0d4,	0xdfff, 0xc0d4,		0x21, 0
	.dw 0xfa00, 0xc0d4,	0xffff, 0xc0d4,		0x21, 0
	.dw 0x1a00, 0xc0d5,	0x1fff, 0xc0d5,		0x21, 0
	.dw 0x3a00, 0xc0d5,	0x3fff, 0xc0d5,		0x21, 0
	.dw 0x5a00, 0xc0d5,	0x5fff, 0xc0d5,		0x21, 0
	.dw 0x7a00, 0xc0d5,	0x7fff, 0xc0d5,		0x21, 0
	.dw 0x9a00, 0xc0d5,	0x9fff, 0xc0d5,		0x21, 0
	.dw 0xba00, 0xc0d5,	0xbfff, 0xc0d5,		0x21, 0
	.dw 0xda00, 0xc0d5,	0xdfff, 0xc0d5,		0x21, 0
	.dw 0xfa00, 0xc0d5,	0xffff, 0xc0d5,		0x21, 0
	.dw 0x1a00, 0xc0d6,	0x1fff, 0xc0d6,		0x21, 0
	.dw 0x3a00, 0xc0d6,	0x3fff, 0xc0d6,		0x21, 0
	.dw 0x5a00, 0xc0d6,	0x5fff, 0xc0d6,		0x21, 0
	.dw 0x7a00, 0xc0d6,	0x7fff, 0xc0d6,		0x21, 0
	.dw 0x9a00, 0xc0d6,	0x9fff, 0xc0d6,		0x21, 0
	.dw 0xba00, 0xc0d6,	0xbfff, 0xc0d6,		0x21, 0
	.dw 0xda00, 0xc0d6,	0xdfff, 0xc0d6,		0x21, 0
	.dw 0xfa00, 0xc0d6,	0xffff, 0xc0d6,		0x21, 0
	.dw 0x1a00, 0xc0d7,	0x1fff, 0xc0d7,		0x21, 0
	.dw 0x3a00, 0xc0d7,	0xffff, 0xc0ff,		0x21, 0
	.dw 0x1a00, 0xc100,	0x1fff, 0xc100,		0x21, 0
	.dw 0x3a00, 0xc100,	0x3fff, 0xc100,		0x21, 0
	.dw 0x5a00, 0xc100,	0x5fff, 0xc100,		0x21, 0
	.dw 0x7a00, 0xc100,	0x7fff, 0xc100,		0x21, 0
	.dw 0x9a00, 0xc100,	0x9fff, 0xc100,		0x21, 0
	.dw 0xba00, 0xc100,	0xbfff, 0xc100,		0x21, 0
	.dw 0xda00, 0xc100,	0xdfff, 0xc100,		0x21, 0
	.dw 0xfa00, 0xc100,	0xffff, 0xc100,		0x21, 0
	.dw 0x1a00, 0xc101,	0x1fff, 0xc101,		0x21, 0
	.dw 0x3a00, 0xc101,	0x3fff, 0xc101,		0x21, 0
	.dw 0x5a00, 0xc101,	0x5fff, 0xc101,		0x21, 0
	.dw 0x7a00, 0xc101,	0x7fff, 0xc101,		0x21, 0
	.dw 0x9a00, 0xc101,	0x9fff, 0xc101,		0x21, 0
	.dw 0xba00, 0xc101,	0xbfff, 0xc101,		0x21, 0
	.dw 0xda00, 0xc101,	0xdfff, 0xc101,		0x21, 0
	.dw 0xfa00, 0xc101,	0xffff, 0xc101,		0x21, 0
	.dw 0x1a00, 0xc102,	0x1fff, 0xc102,		0x21, 0
	.dw 0x3a00, 0xc102,	0x3fff, 0xc102,		0x21, 0
	.dw 0x5a00, 0xc102,	0x5fff, 0xc102,		0x21, 0
	.dw 0x7a00, 0xc102,	0x7fff, 0xc102,		0x21, 0
	.dw 0x9a00, 0xc102,	0x9fff, 0xc102,		0x21, 0
	.dw 0xba00, 0xc102,	0xbfff, 0xc102,		0x21, 0
	.dw 0xda00, 0xc102,	0xdfff, 0xc102,		0x21, 0
	.dw 0xfa00, 0xc102,	0xffff, 0xc102,		0x21, 0
	.dw 0x1a00, 0xc103,	0x1fff, 0xc103,		0x21, 0
	.dw 0x3a00, 0xc103,	0xffff, 0xc103,		0x21, 0
	.dw 0x1a00, 0xc104,	0x1fff, 0xc104,		0x21, 0
	.dw 0x3a00, 0xc104,	0x3fff, 0xc104,		0x21, 0
	.dw 0x5a00, 0xc104,	0x5fff, 0xc104,		0x21, 0
	.dw 0x7a00, 0xc104,	0x7fff, 0xc104,		0x21, 0
	.dw 0x9a00, 0xc104,	0x9fff, 0xc104,		0x21, 0
	.dw 0xba00, 0xc104,	0xbfff, 0xc104,		0x21, 0
	.dw 0xda00, 0xc104,	0xdfff, 0xc104,		0x21, 0
	.dw 0xfa00, 0xc104,	0xffff, 0xc104,		0x21, 0
	.dw 0x1a00, 0xc105,	0x1fff, 0xc105,		0x21, 0
	.dw 0x3a00, 0xc105,	0x3fff, 0xc105,		0x21, 0
	.dw 0x5a00, 0xc105,	0x5fff, 0xc105,		0x21, 0
	.dw 0x7a00, 0xc105,	0x7fff, 0xc105,		0x21, 0
	.dw 0x9a00, 0xc105,	0x9fff, 0xc105,		0x21, 0
	.dw 0xba00, 0xc105,	0xbfff, 0xc105,		0x21, 0
	.dw 0xda00, 0xc105,	0xdfff, 0xc105,		0x21, 0
	.dw 0xfa00, 0xc105,	0xffff, 0xc105,		0x21, 0
	.dw 0x1a00, 0xc106,	0x1fff, 0xc106,		0x21, 0
	.dw 0x3a00, 0xc106,	0x3fff, 0xc106,		0x21, 0
	.dw 0x5a00, 0xc106,	0x5fff, 0xc106,		0x21, 0
	.dw 0x7a00, 0xc106,	0x7fff, 0xc106,		0x21, 0
	.dw 0x9a00, 0xc106,	0x9fff, 0xc106,		0x21, 0
	.dw 0xba00, 0xc106,	0xbfff, 0xc106,		0x21, 0
	.dw 0xda00, 0xc106,	0xdfff, 0xc106,		0x21, 0
	.dw 0xfa00, 0xc106,	0xffff, 0xc106,		0x21, 0
	.dw 0x1a00, 0xc107,	0x1fff, 0xc107,		0x21, 0
	.dw 0x3a00, 0xc107,	0x1fff, 0xc108,		0x21, 0
	.dw 0x2040, 0xc108,	0x207f, 0xc108,		0x21, 0
	.dw 0x20c0, 0xc108,	0x20ff, 0xc108,		0x21, 0
	.dw 0x2140, 0xc108,	0x217f, 0xc108,		0x21, 0
	.dw 0x21c0, 0xc108,	0x21ff, 0xc108,		0x21, 0
	.dw 0x2240, 0xc108,	0x227f, 0xc108,		0x21, 0
	.dw 0x22c0, 0xc108,	0x22ff, 0xc108,		0x21, 0
	.dw 0x2340, 0xc108,	0x237f, 0xc108,		0x21, 0
	.dw 0x23c0, 0xc108,	0x23ff, 0xc108,		0x21, 0
	.dw 0x2440, 0xc108,	0x247f, 0xc108,		0x21, 0
	.dw 0x24c0, 0xc108,	0x24ff, 0xc108,		0x21, 0
	.dw 0x2540, 0xc108,	0x257f, 0xc108,		0x21, 0
	.dw 0x25c0, 0xc108,	0x25ff, 0xc108,		0x21, 0
	.dw 0x2640, 0xc108,	0x267f, 0xc108,		0x21, 0
	.dw 0x26c0, 0xc108,	0x26ff, 0xc108,		0x21, 0
	.dw 0x2740, 0xc108,	0x277f, 0xc108,		0x21, 0
	.dw 0x27c0, 0xc108,	0x27ff, 0xc108,		0x21, 0
	.dw 0x2840, 0xc108,	0x287f, 0xc108,		0x21, 0
	.dw 0x28c0, 0xc108,	0x28ff, 0xc108,		0x21, 0
	.dw 0x2940, 0xc108,	0x297f, 0xc108,		0x21, 0
	.dw 0x29c0, 0xc108,	0x29ff, 0xc108,		0x21, 0
	.dw 0x2a40, 0xc108,	0x2a7f, 0xc108,		0x21, 0
	.dw 0x2ac0, 0xc108,	0x2aff, 0xc108,		0x21, 0
	.dw 0x2b40, 0xc108,	0x2b7f, 0xc108,		0x21, 0
	.dw 0x2bc0, 0xc108,	0x2bff, 0xc108,		0x21, 0
	.dw 0x2c40, 0xc108,	0x2c7f, 0xc108,		0x21, 0
	.dw 0x2cc0, 0xc108,	0x2cff, 0xc108,		0x21, 0
	.dw 0x2d40, 0xc108,	0x2d7f, 0xc108,		0x21, 0
	.dw 0x2dc0, 0xc108,	0x2dff, 0xc108,		0x21, 0
	.dw 0x2e40, 0xc108,	0x2e7f, 0xc108,		0x21, 0
	.dw 0x2ec0, 0xc108,	0x2eff, 0xc108,		0x21, 0
	.dw 0x2f40, 0xc108,	0x2f7f, 0xc108,		0x21, 0
	.dw 0x2fc0, 0xc108,	0x2fff, 0xc108,		0x21, 0
	.dw 0x3040, 0xc108,	0x307f, 0xc108,		0x21, 0
	.dw 0x30c0, 0xc108,	0x30ff, 0xc108,		0x21, 0
	.dw 0x3140, 0xc108,	0x317f, 0xc108,		0x21, 0
	.dw 0x31c0, 0xc108,	0x31ff, 0xc108,		0x21, 0
	.dw 0x3240, 0xc108,	0x327f, 0xc108,		0x21, 0
	.dw 0x32c0, 0xc108,	0x32ff, 0xc108,		0x21, 0
	.dw 0x3340, 0xc108,	0x337f, 0xc108,		0x21, 0
	.dw 0x33c0, 0xc108,	0x33ff, 0xc108,		0x21, 0
	.dw 0x3440, 0xc108,	0x347f, 0xc108,		0x21, 0
	.dw 0x34c0, 0xc108,	0x34ff, 0xc108,		0x21, 0
	.dw 0x3540, 0xc108,	0x357f, 0xc108,		0x21, 0
	.dw 0x35c0, 0xc108,	0x35ff, 0xc108,		0x21, 0
	.dw 0x3640, 0xc108,	0x367f, 0xc108,		0x21, 0
	.dw 0x36c0, 0xc108,	0x36ff, 0xc108,		0x21, 0
	.dw 0x3740, 0xc108,	0x377f, 0xc108,		0x21, 0
	.dw 0x37c0, 0xc108,	0x37ff, 0xc108,		0x21, 0
	.dw 0x3840, 0xc108,	0x387f, 0xc108,		0x21, 0
	.dw 0x38c0, 0xc108,	0x38ff, 0xc108,		0x21, 0
	.dw 0x3940, 0xc108,	0x397f, 0xc108,		0x21, 0
	.dw 0x39c0, 0xc108,	0x5fff, 0xc108,		0x21, 0
	.dw 0x6040, 0xc108,	0x607f, 0xc108,		0x21, 0
	.dw 0x60c0, 0xc108,	0x60ff, 0xc108,		0x21, 0
	.dw 0x6140, 0xc108,	0x617f, 0xc108,		0x21, 0
	.dw 0x61c0, 0xc108,	0x61ff, 0xc108,		0x21, 0
	.dw 0x6240, 0xc108,	0x627f, 0xc108,		0x21, 0
	.dw 0x62c0, 0xc108,	0x62ff, 0xc108,		0x21, 0
	.dw 0x6340, 0xc108,	0x637f, 0xc108,		0x21, 0
	.dw 0x63c0, 0xc108,	0x63ff, 0xc108,		0x21, 0
	.dw 0x6440, 0xc108,	0x647f, 0xc108,		0x21, 0
	.dw 0x64c0, 0xc108,	0x64ff, 0xc108,		0x21, 0
	.dw 0x6540, 0xc108,	0x657f, 0xc108,		0x21, 0
	.dw 0x65c0, 0xc108,	0x65ff, 0xc108,		0x21, 0
	.dw 0x6640, 0xc108,	0x667f, 0xc108,		0x21, 0
	.dw 0x66c0, 0xc108,	0x66ff, 0xc108,		0x21, 0
	.dw 0x6740, 0xc108,	0x677f, 0xc108,		0x21, 0
	.dw 0x67c0, 0xc108,	0x67ff, 0xc108,		0x21, 0
	.dw 0x6840, 0xc108,	0x687f, 0xc108,		0x21, 0
	.dw 0x68c0, 0xc108,	0x68ff, 0xc108,		0x21, 0
	.dw 0x6940, 0xc108,	0x697f, 0xc108,		0x21, 0
	.dw 0x69c0, 0xc108,	0x69ff, 0xc108,		0x21, 0
	.dw 0x6a40, 0xc108,	0x6a7f, 0xc108,		0x21, 0
	.dw 0x6ac0, 0xc108,	0x6aff, 0xc108,		0x21, 0
	.dw 0x6b40, 0xc108,	0x6b7f, 0xc108,		0x21, 0
	.dw 0x6bc0, 0xc108,	0x6bff, 0xc108,		0x21, 0
	.dw 0x6c40, 0xc108,	0x6c7f, 0xc108,		0x21, 0
	.dw 0x6cc0, 0xc108,	0x6cff, 0xc108,		0x21, 0
	.dw 0x6d40, 0xc108,	0x6d7f, 0xc108,		0x21, 0
	.dw 0x6dc0, 0xc108,	0x6dff, 0xc108,		0x21, 0
	.dw 0x6e40, 0xc108,	0x6e7f, 0xc108,		0x21, 0
	.dw 0x6ec0, 0xc108,	0x6eff, 0xc108,		0x21, 0
	.dw 0x6f40, 0xc108,	0x6f7f, 0xc108,		0x21, 0
	.dw 0x6fc0, 0xc108,	0x6fff, 0xc108,		0x21, 0
	.dw 0x7040, 0xc108,	0x707f, 0xc108,		0x21, 0
	.dw 0x70c0, 0xc108,	0x70ff, 0xc108,		0x21, 0
	.dw 0x7140, 0xc108,	0x717f, 0xc108,		0x21, 0
	.dw 0x71c0, 0xc108,	0x71ff, 0xc108,		0x21, 0
	.dw 0x7240, 0xc108,	0x727f, 0xc108,		0x21, 0
	.dw 0x72c0, 0xc108,	0x72ff, 0xc108,		0x21, 0
	.dw 0x7340, 0xc108,	0x737f, 0xc108,		0x21, 0
	.dw 0x73c0, 0xc108,	0x73ff, 0xc108,		0x21, 0
	.dw 0x7440, 0xc108,	0x747f, 0xc108,		0x21, 0
	.dw 0x74c0, 0xc108,	0x74ff, 0xc108,		0x21, 0
	.dw 0x7540, 0xc108,	0x757f, 0xc108,		0x21, 0
	.dw 0x75c0, 0xc108,	0x75ff, 0xc108,		0x21, 0
	.dw 0x7640, 0xc108,	0x767f, 0xc108,		0x21, 0
	.dw 0x76c0, 0xc108,	0x76ff, 0xc108,		0x21, 0
	.dw 0x7740, 0xc108,	0x777f, 0xc108,		0x21, 0
	.dw 0x77c0, 0xc108,	0x77ff, 0xc108,		0x21, 0
	.dw 0x7840, 0xc108,	0x787f, 0xc108,		0x21, 0
	.dw 0x78c0, 0xc108,	0x78ff, 0xc108,		0x21, 0
	.dw 0x7940, 0xc108,	0x797f, 0xc108,		0x21, 0
	.dw 0x79c0, 0xc108,	0x9fff, 0xc108,		0x21, 0
	.dw 0xa040, 0xc108,	0xa07f, 0xc108,		0x21, 0
	.dw 0xa0c0, 0xc108,	0xa0ff, 0xc108,		0x21, 0
	.dw 0xa140, 0xc108,	0xa17f, 0xc108,		0x21, 0
	.dw 0xa1c0, 0xc108,	0xa1ff, 0xc108,		0x21, 0
	.dw 0xa240, 0xc108,	0xa27f, 0xc108,		0x21, 0
	.dw 0xa2c0, 0xc108,	0xa2ff, 0xc108,		0x21, 0
	.dw 0xa340, 0xc108,	0xa37f, 0xc108,		0x21, 0
	.dw 0xa3c0, 0xc108,	0xa3ff, 0xc108,		0x21, 0
	.dw 0xa440, 0xc108,	0xa47f, 0xc108,		0x21, 0
	.dw 0xa4c0, 0xc108,	0xa4ff, 0xc108,		0x21, 0
	.dw 0xa540, 0xc108,	0xa57f, 0xc108,		0x21, 0
	.dw 0xa5c0, 0xc108,	0xa5ff, 0xc108,		0x21, 0
	.dw 0xa640, 0xc108,	0xa67f, 0xc108,		0x21, 0
	.dw 0xa6c0, 0xc108,	0xa6ff, 0xc108,		0x21, 0
	.dw 0xa740, 0xc108,	0xa77f, 0xc108,		0x21, 0
	.dw 0xa7c0, 0xc108,	0xa7ff, 0xc108,		0x21, 0
	.dw 0xa840, 0xc108,	0xa87f, 0xc108,		0x21, 0
	.dw 0xa8c0, 0xc108,	0xa8ff, 0xc108,		0x21, 0
	.dw 0xa940, 0xc108,	0xa97f, 0xc108,		0x21, 0
	.dw 0xa9c0, 0xc108,	0xa9ff, 0xc108,		0x21, 0
	.dw 0xaa40, 0xc108,	0xaa7f, 0xc108,		0x21, 0
	.dw 0xaac0, 0xc108,	0xaaff, 0xc108,		0x21, 0
	.dw 0xab40, 0xc108,	0xab7f, 0xc108,		0x21, 0
	.dw 0xabc0, 0xc108,	0xabff, 0xc108,		0x21, 0
	.dw 0xac40, 0xc108,	0xac7f, 0xc108,		0x21, 0
	.dw 0xacc0, 0xc108,	0xacff, 0xc108,		0x21, 0
	.dw 0xad40, 0xc108,	0xad7f, 0xc108,		0x21, 0
	.dw 0xadc0, 0xc108,	0xadff, 0xc108,		0x21, 0
	.dw 0xae40, 0xc108,	0xae7f, 0xc108,		0x21, 0
	.dw 0xaec0, 0xc108,	0xaeff, 0xc108,		0x21, 0
	.dw 0xaf40, 0xc108,	0xaf7f, 0xc108,		0x21, 0
	.dw 0xafc0, 0xc108,	0xafff, 0xc108,		0x21, 0
	.dw 0xb040, 0xc108,	0xb07f, 0xc108,		0x21, 0
	.dw 0xb0c0, 0xc108,	0xb0ff, 0xc108,		0x21, 0
	.dw 0xb140, 0xc108,	0xb17f, 0xc108,		0x21, 0
	.dw 0xb1c0, 0xc108,	0xb1ff, 0xc108,		0x21, 0
	.dw 0xb240, 0xc108,	0xb27f, 0xc108,		0x21, 0
	.dw 0xb2c0, 0xc108,	0xb2ff, 0xc108,		0x21, 0
	.dw 0xb340, 0xc108,	0xb37f, 0xc108,		0x21, 0
	.dw 0xb3c0, 0xc108,	0xb3ff, 0xc108,		0x21, 0
	.dw 0xb440, 0xc108,	0xb47f, 0xc108,		0x21, 0
	.dw 0xb4c0, 0xc108,	0xb4ff, 0xc108,		0x21, 0
	.dw 0xb540, 0xc108,	0xb57f, 0xc108,		0x21, 0
	.dw 0xb5c0, 0xc108,	0xb5ff, 0xc108,		0x21, 0
	.dw 0xb640, 0xc108,	0xb67f, 0xc108,		0x21, 0
	.dw 0xb6c0, 0xc108,	0xb6ff, 0xc108,		0x21, 0
	.dw 0xb740, 0xc108,	0xb77f, 0xc108,		0x21, 0
	.dw 0xb7c0, 0xc108,	0xb7ff, 0xc108,		0x21, 0
	.dw 0xb840, 0xc108,	0xb87f, 0xc108,		0x21, 0
	.dw 0xb8c0, 0xc108,	0xb8ff, 0xc108,		0x21, 0
	.dw 0xb940, 0xc108,	0xb97f, 0xc108,		0x21, 0
	.dw 0xb9c0, 0xc108,	0xdfff, 0xc108,		0x21, 0
	.dw 0xe040, 0xc108,	0xe07f, 0xc108,		0x21, 0
	.dw 0xe0c0, 0xc108,	0xe0ff, 0xc108,		0x21, 0
	.dw 0xe140, 0xc108,	0xe17f, 0xc108,		0x21, 0
	.dw 0xe1c0, 0xc108,	0xe1ff, 0xc108,		0x21, 0
	.dw 0xe240, 0xc108,	0xe27f, 0xc108,		0x21, 0
	.dw 0xe2c0, 0xc108,	0xe2ff, 0xc108,		0x21, 0
	.dw 0xe340, 0xc108,	0xe37f, 0xc108,		0x21, 0
	.dw 0xe3c0, 0xc108,	0xe3ff, 0xc108,		0x21, 0
	.dw 0xe440, 0xc108,	0xe47f, 0xc108,		0x21, 0
	.dw 0xe4c0, 0xc108,	0xe4ff, 0xc108,		0x21, 0
	.dw 0xe540, 0xc108,	0xe57f, 0xc108,		0x21, 0
	.dw 0xe5c0, 0xc108,	0xe5ff, 0xc108,		0x21, 0
	.dw 0xe640, 0xc108,	0xe67f, 0xc108,		0x21, 0
	.dw 0xe6c0, 0xc108,	0xe6ff, 0xc108,		0x21, 0
	.dw 0xe740, 0xc108,	0xe77f, 0xc108,		0x21, 0
	.dw 0xe7c0, 0xc108,	0xe7ff, 0xc108,		0x21, 0
	.dw 0xe840, 0xc108,	0xe87f, 0xc108,		0x21, 0
	.dw 0xe8c0, 0xc108,	0xe8ff, 0xc108,		0x21, 0
	.dw 0xe940, 0xc108,	0xe97f, 0xc108,		0x21, 0
	.dw 0xe9c0, 0xc108,	0xe9ff, 0xc108,		0x21, 0
	.dw 0xea40, 0xc108,	0xea7f, 0xc108,		0x21, 0
	.dw 0xeac0, 0xc108,	0xeaff, 0xc108,		0x21, 0
	.dw 0xeb40, 0xc108,	0xeb7f, 0xc108,		0x21, 0
	.dw 0xebc0, 0xc108,	0xebff, 0xc108,		0x21, 0
	.dw 0xec40, 0xc108,	0xec7f, 0xc108,		0x21, 0
	.dw 0xecc0, 0xc108,	0xecff, 0xc108,		0x21, 0
	.dw 0xed40, 0xc108,	0xed7f, 0xc108,		0x21, 0
	.dw 0xedc0, 0xc108,	0xedff, 0xc108,		0x21, 0
	.dw 0xee40, 0xc108,	0xee7f, 0xc108,		0x21, 0
	.dw 0xeec0, 0xc108,	0xeeff, 0xc108,		0x21, 0
	.dw 0xef40, 0xc108,	0xef7f, 0xc108,		0x21, 0
	.dw 0xefc0, 0xc108,	0xefff, 0xc108,		0x21, 0
	.dw 0xf040, 0xc108,	0xf07f, 0xc108,		0x21, 0
	.dw 0xf0c0, 0xc108,	0xf0ff, 0xc108,		0x21, 0
	.dw 0xf140, 0xc108,	0xf17f, 0xc108,		0x21, 0
	.dw 0xf1c0, 0xc108,	0xf1ff, 0xc108,		0x21, 0
	.dw 0xf240, 0xc108,	0xf27f, 0xc108,		0x21, 0
	.dw 0xf2c0, 0xc108,	0xf2ff, 0xc108,		0x21, 0
	.dw 0xf340, 0xc108,	0xf37f, 0xc108,		0x21, 0
	.dw 0xf3c0, 0xc108,	0xf3ff, 0xc108,		0x21, 0
	.dw 0xf440, 0xc108,	0xf47f, 0xc108,		0x21, 0
	.dw 0xf4c0, 0xc108,	0xf4ff, 0xc108,		0x21, 0
	.dw 0xf540, 0xc108,	0xf57f, 0xc108,		0x21, 0
	.dw 0xf5c0, 0xc108,	0xf5ff, 0xc108,		0x21, 0
	.dw 0xf640, 0xc108,	0xf67f, 0xc108,		0x21, 0
	.dw 0xf6c0, 0xc108,	0xf6ff, 0xc108,		0x21, 0
	.dw 0xf740, 0xc108,	0xf77f, 0xc108,		0x21, 0
	.dw 0xf7c0, 0xc108,	0xf7ff, 0xc108,		0x21, 0
	.dw 0xf840, 0xc108,	0xf87f, 0xc108,		0x21, 0
	.dw 0xf8c0, 0xc108,	0xf8ff, 0xc108,		0x21, 0
	.dw 0xf940, 0xc108,	0xf97f, 0xc108,		0x21, 0
	.dw 0xf9c0, 0xc108,	0x1fff, 0xc109,		0x21, 0
	.dw 0x2040, 0xc109,	0x207f, 0xc109,		0x21, 0
	.dw 0x20c0, 0xc109,	0x20ff, 0xc109,		0x21, 0
	.dw 0x2140, 0xc109,	0x217f, 0xc109,		0x21, 0
	.dw 0x21c0, 0xc109,	0x21ff, 0xc109,		0x21, 0
	.dw 0x2240, 0xc109,	0x227f, 0xc109,		0x21, 0
	.dw 0x22c0, 0xc109,	0x22ff, 0xc109,		0x21, 0
	.dw 0x2340, 0xc109,	0x237f, 0xc109,		0x21, 0
	.dw 0x23c0, 0xc109,	0x23ff, 0xc109,		0x21, 0
	.dw 0x2440, 0xc109,	0x247f, 0xc109,		0x21, 0
	.dw 0x24c0, 0xc109,	0x24ff, 0xc109,		0x21, 0
	.dw 0x2540, 0xc109,	0x257f, 0xc109,		0x21, 0
	.dw 0x25c0, 0xc109,	0x25ff, 0xc109,		0x21, 0
	.dw 0x2640, 0xc109,	0x267f, 0xc109,		0x21, 0
	.dw 0x26c0, 0xc109,	0x26ff, 0xc109,		0x21, 0
	.dw 0x2740, 0xc109,	0x277f, 0xc109,		0x21, 0
	.dw 0x27c0, 0xc109,	0x27ff, 0xc109,		0x21, 0
	.dw 0x2840, 0xc109,	0x287f, 0xc109,		0x21, 0
	.dw 0x28c0, 0xc109,	0x28ff, 0xc109,		0x21, 0
	.dw 0x2940, 0xc109,	0x297f, 0xc109,		0x21, 0
	.dw 0x29c0, 0xc109,	0x29ff, 0xc109,		0x21, 0
	.dw 0x2a40, 0xc109,	0x2a7f, 0xc109,		0x21, 0
	.dw 0x2ac0, 0xc109,	0x2aff, 0xc109,		0x21, 0
	.dw 0x2b40, 0xc109,	0x2b7f, 0xc109,		0x21, 0
	.dw 0x2bc0, 0xc109,	0x2bff, 0xc109,		0x21, 0
	.dw 0x2c40, 0xc109,	0x2c7f, 0xc109,		0x21, 0
	.dw 0x2cc0, 0xc109,	0x2cff, 0xc109,		0x21, 0
	.dw 0x2d40, 0xc109,	0x2d7f, 0xc109,		0x21, 0
	.dw 0x2dc0, 0xc109,	0x2dff, 0xc109,		0x21, 0
	.dw 0x2e40, 0xc109,	0x2e7f, 0xc109,		0x21, 0
	.dw 0x2ec0, 0xc109,	0x2eff, 0xc109,		0x21, 0
	.dw 0x2f40, 0xc109,	0x2f7f, 0xc109,		0x21, 0
	.dw 0x2fc0, 0xc109,	0x2fff, 0xc109,		0x21, 0
	.dw 0x3040, 0xc109,	0x307f, 0xc109,		0x21, 0
	.dw 0x30c0, 0xc109,	0x30ff, 0xc109,		0x21, 0
	.dw 0x3140, 0xc109,	0x317f, 0xc109,		0x21, 0
	.dw 0x31c0, 0xc109,	0x31ff, 0xc109,		0x21, 0
	.dw 0x3240, 0xc109,	0x327f, 0xc109,		0x21, 0
	.dw 0x32c0, 0xc109,	0x32ff, 0xc109,		0x21, 0
	.dw 0x3340, 0xc109,	0x337f, 0xc109,		0x21, 0
	.dw 0x33c0, 0xc109,	0x33ff, 0xc109,		0x21, 0
	.dw 0x3440, 0xc109,	0x347f, 0xc109,		0x21, 0
	.dw 0x34c0, 0xc109,	0x34ff, 0xc109,		0x21, 0
	.dw 0x3540, 0xc109,	0x357f, 0xc109,		0x21, 0
	.dw 0x35c0, 0xc109,	0x35ff, 0xc109,		0x21, 0
	.dw 0x3640, 0xc109,	0x367f, 0xc109,		0x21, 0
	.dw 0x36c0, 0xc109,	0x36ff, 0xc109,		0x21, 0
	.dw 0x3740, 0xc109,	0x377f, 0xc109,		0x21, 0
	.dw 0x37c0, 0xc109,	0x37ff, 0xc109,		0x21, 0
	.dw 0x3840, 0xc109,	0x387f, 0xc109,		0x21, 0
	.dw 0x38c0, 0xc109,	0x38ff, 0xc109,		0x21, 0
	.dw 0x3940, 0xc109,	0x397f, 0xc109,		0x21, 0
	.dw 0x39c0, 0xc109,	0x5fff, 0xc109,		0x21, 0
	.dw 0x6040, 0xc109,	0x607f, 0xc109,		0x21, 0
	.dw 0x60c0, 0xc109,	0x60ff, 0xc109,		0x21, 0
	.dw 0x6140, 0xc109,	0x617f, 0xc109,		0x21, 0
	.dw 0x61c0, 0xc109,	0x61ff, 0xc109,		0x21, 0
	.dw 0x6240, 0xc109,	0x627f, 0xc109,		0x21, 0
	.dw 0x62c0, 0xc109,	0x62ff, 0xc109,		0x21, 0
	.dw 0x6340, 0xc109,	0x637f, 0xc109,		0x21, 0
	.dw 0x63c0, 0xc109,	0x63ff, 0xc109,		0x21, 0
	.dw 0x6440, 0xc109,	0x647f, 0xc109,		0x21, 0
	.dw 0x64c0, 0xc109,	0x64ff, 0xc109,		0x21, 0
	.dw 0x6540, 0xc109,	0x657f, 0xc109,		0x21, 0
	.dw 0x65c0, 0xc109,	0x65ff, 0xc109,		0x21, 0
	.dw 0x6640, 0xc109,	0x667f, 0xc109,		0x21, 0
	.dw 0x66c0, 0xc109,	0x66ff, 0xc109,		0x21, 0
	.dw 0x6740, 0xc109,	0x677f, 0xc109,		0x21, 0
	.dw 0x67c0, 0xc109,	0x67ff, 0xc109,		0x21, 0
	.dw 0x6840, 0xc109,	0x687f, 0xc109,		0x21, 0
	.dw 0x68c0, 0xc109,	0x68ff, 0xc109,		0x21, 0
	.dw 0x6940, 0xc109,	0x697f, 0xc109,		0x21, 0
	.dw 0x69c0, 0xc109,	0x69ff, 0xc109,		0x21, 0
	.dw 0x6a40, 0xc109,	0x6a7f, 0xc109,		0x21, 0
	.dw 0x6ac0, 0xc109,	0x6aff, 0xc109,		0x21, 0
	.dw 0x6b40, 0xc109,	0x6b7f, 0xc109,		0x21, 0
	.dw 0x6bc0, 0xc109,	0x6bff, 0xc109,		0x21, 0
	.dw 0x6c40, 0xc109,	0x6c7f, 0xc109,		0x21, 0
	.dw 0x6cc0, 0xc109,	0x6cff, 0xc109,		0x21, 0
	.dw 0x6d40, 0xc109,	0x6d7f, 0xc109,		0x21, 0
	.dw 0x6dc0, 0xc109,	0x6dff, 0xc109,		0x21, 0
	.dw 0x6e40, 0xc109,	0x6e7f, 0xc109,		0x21, 0
	.dw 0x6ec0, 0xc109,	0x6eff, 0xc109,		0x21, 0
	.dw 0x6f40, 0xc109,	0x6f7f, 0xc109,		0x21, 0
	.dw 0x6fc0, 0xc109,	0x6fff, 0xc109,		0x21, 0
	.dw 0x7040, 0xc109,	0x707f, 0xc109,		0x21, 0
	.dw 0x70c0, 0xc109,	0x70ff, 0xc109,		0x21, 0
	.dw 0x7140, 0xc109,	0x717f, 0xc109,		0x21, 0
	.dw 0x71c0, 0xc109,	0x71ff, 0xc109,		0x21, 0
	.dw 0x7240, 0xc109,	0x727f, 0xc109,		0x21, 0
	.dw 0x72c0, 0xc109,	0x72ff, 0xc109,		0x21, 0
	.dw 0x7340, 0xc109,	0x737f, 0xc109,		0x21, 0
	.dw 0x73c0, 0xc109,	0x73ff, 0xc109,		0x21, 0
	.dw 0x7440, 0xc109,	0x747f, 0xc109,		0x21, 0
	.dw 0x74c0, 0xc109,	0x74ff, 0xc109,		0x21, 0
	.dw 0x7540, 0xc109,	0x757f, 0xc109,		0x21, 0
	.dw 0x75c0, 0xc109,	0x75ff, 0xc109,		0x21, 0
	.dw 0x7640, 0xc109,	0x767f, 0xc109,		0x21, 0
	.dw 0x76c0, 0xc109,	0x76ff, 0xc109,		0x21, 0
	.dw 0x7740, 0xc109,	0x777f, 0xc109,		0x21, 0
	.dw 0x77c0, 0xc109,	0x77ff, 0xc109,		0x21, 0
	.dw 0x7840, 0xc109,	0x787f, 0xc109,		0x21, 0
	.dw 0x78c0, 0xc109,	0x78ff, 0xc109,		0x21, 0
	.dw 0x7940, 0xc109,	0x797f, 0xc109,		0x21, 0
	.dw 0x79c0, 0xc109,	0x9fff, 0xc109,		0x21, 0
	.dw 0xa040, 0xc109,	0xa07f, 0xc109,		0x21, 0
	.dw 0xa0c0, 0xc109,	0xa0ff, 0xc109,		0x21, 0
	.dw 0xa140, 0xc109,	0xa17f, 0xc109,		0x21, 0
	.dw 0xa1c0, 0xc109,	0xa1ff, 0xc109,		0x21, 0
	.dw 0xa240, 0xc109,	0xa27f, 0xc109,		0x21, 0
	.dw 0xa2c0, 0xc109,	0xa2ff, 0xc109,		0x21, 0
	.dw 0xa340, 0xc109,	0xa37f, 0xc109,		0x21, 0
	.dw 0xa3c0, 0xc109,	0xa3ff, 0xc109,		0x21, 0
	.dw 0xa440, 0xc109,	0xa47f, 0xc109,		0x21, 0
	.dw 0xa4c0, 0xc109,	0xa4ff, 0xc109,		0x21, 0
	.dw 0xa540, 0xc109,	0xa57f, 0xc109,		0x21, 0
	.dw 0xa5c0, 0xc109,	0xa5ff, 0xc109,		0x21, 0
	.dw 0xa640, 0xc109,	0xa67f, 0xc109,		0x21, 0
	.dw 0xa6c0, 0xc109,	0xa6ff, 0xc109,		0x21, 0
	.dw 0xa740, 0xc109,	0xa77f, 0xc109,		0x21, 0
	.dw 0xa7c0, 0xc109,	0xa7ff, 0xc109,		0x21, 0
	.dw 0xa840, 0xc109,	0xa87f, 0xc109,		0x21, 0
	.dw 0xa8c0, 0xc109,	0xa8ff, 0xc109,		0x21, 0
	.dw 0xa940, 0xc109,	0xa97f, 0xc109,		0x21, 0
	.dw 0xa9c0, 0xc109,	0xa9ff, 0xc109,		0x21, 0
	.dw 0xaa40, 0xc109,	0xaa7f, 0xc109,		0x21, 0
	.dw 0xaac0, 0xc109,	0xaaff, 0xc109,		0x21, 0
	.dw 0xab40, 0xc109,	0xab7f, 0xc109,		0x21, 0
	.dw 0xabc0, 0xc109,	0xabff, 0xc109,		0x21, 0
	.dw 0xac40, 0xc109,	0xac7f, 0xc109,		0x21, 0
	.dw 0xacc0, 0xc109,	0xacff, 0xc109,		0x21, 0
	.dw 0xad40, 0xc109,	0xad7f, 0xc109,		0x21, 0
	.dw 0xadc0, 0xc109,	0xadff, 0xc109,		0x21, 0
	.dw 0xae40, 0xc109,	0xae7f, 0xc109,		0x21, 0
	.dw 0xaec0, 0xc109,	0xaeff, 0xc109,		0x21, 0
	.dw 0xaf40, 0xc109,	0xaf7f, 0xc109,		0x21, 0
	.dw 0xafc0, 0xc109,	0xafff, 0xc109,		0x21, 0
	.dw 0xb040, 0xc109,	0xb07f, 0xc109,		0x21, 0
	.dw 0xb0c0, 0xc109,	0xb0ff, 0xc109,		0x21, 0
	.dw 0xb140, 0xc109,	0xb17f, 0xc109,		0x21, 0
	.dw 0xb1c0, 0xc109,	0xb1ff, 0xc109,		0x21, 0
	.dw 0xb240, 0xc109,	0xb27f, 0xc109,		0x21, 0
	.dw 0xb2c0, 0xc109,	0xb2ff, 0xc109,		0x21, 0
	.dw 0xb340, 0xc109,	0xb37f, 0xc109,		0x21, 0
	.dw 0xb3c0, 0xc109,	0xb3ff, 0xc109,		0x21, 0
	.dw 0xb440, 0xc109,	0xb47f, 0xc109,		0x21, 0
	.dw 0xb4c0, 0xc109,	0xb4ff, 0xc109,		0x21, 0
	.dw 0xb540, 0xc109,	0xb57f, 0xc109,		0x21, 0
	.dw 0xb5c0, 0xc109,	0xb5ff, 0xc109,		0x21, 0
	.dw 0xb640, 0xc109,	0xb67f, 0xc109,		0x21, 0
	.dw 0xb6c0, 0xc109,	0xb6ff, 0xc109,		0x21, 0
	.dw 0xb740, 0xc109,	0xb77f, 0xc109,		0x21, 0
	.dw 0xb7c0, 0xc109,	0xb7ff, 0xc109,		0x21, 0
	.dw 0xb840, 0xc109,	0xb87f, 0xc109,		0x21, 0
	.dw 0xb8c0, 0xc109,	0xb8ff, 0xc109,		0x21, 0
	.dw 0xb940, 0xc109,	0xb97f, 0xc109,		0x21, 0
	.dw 0xb9c0, 0xc109,	0xdfff, 0xc109,		0x21, 0
	.dw 0xe040, 0xc109,	0xe07f, 0xc109,		0x21, 0
	.dw 0xe0c0, 0xc109,	0xe0ff, 0xc109,		0x21, 0
	.dw 0xe140, 0xc109,	0xe17f, 0xc109,		0x21, 0
	.dw 0xe1c0, 0xc109,	0xe1ff, 0xc109,		0x21, 0
	.dw 0xe240, 0xc109,	0xe27f, 0xc109,		0x21, 0
	.dw 0xe2c0, 0xc109,	0xe2ff, 0xc109,		0x21, 0
	.dw 0xe340, 0xc109,	0xe37f, 0xc109,		0x21, 0
	.dw 0xe3c0, 0xc109,	0xe3ff, 0xc109,		0x21, 0
	.dw 0xe440, 0xc109,	0xe47f, 0xc109,		0x21, 0
	.dw 0xe4c0, 0xc109,	0xe4ff, 0xc109,		0x21, 0
	.dw 0xe540, 0xc109,	0xe57f, 0xc109,		0x21, 0
	.dw 0xe5c0, 0xc109,	0xe5ff, 0xc109,		0x21, 0
	.dw 0xe640, 0xc109,	0xe67f, 0xc109,		0x21, 0
	.dw 0xe6c0, 0xc109,	0xe6ff, 0xc109,		0x21, 0
	.dw 0xe740, 0xc109,	0xe77f, 0xc109,		0x21, 0
	.dw 0xe7c0, 0xc109,	0xe7ff, 0xc109,		0x21, 0
	.dw 0xe840, 0xc109,	0xe87f, 0xc109,		0x21, 0
	.dw 0xe8c0, 0xc109,	0xe8ff, 0xc109,		0x21, 0
	.dw 0xe940, 0xc109,	0xe97f, 0xc109,		0x21, 0
	.dw 0xe9c0, 0xc109,	0xe9ff, 0xc109,		0x21, 0
	.dw 0xea40, 0xc109,	0xea7f, 0xc109,		0x21, 0
	.dw 0xeac0, 0xc109,	0xeaff, 0xc109,		0x21, 0
	.dw 0xeb40, 0xc109,	0xeb7f, 0xc109,		0x21, 0
	.dw 0xebc0, 0xc109,	0xebff, 0xc109,		0x21, 0
	.dw 0xec40, 0xc109,	0xec7f, 0xc109,		0x21, 0
	.dw 0xecc0, 0xc109,	0xecff, 0xc109,		0x21, 0
	.dw 0xed40, 0xc109,	0xed7f, 0xc109,		0x21, 0
	.dw 0xedc0, 0xc109,	0xedff, 0xc109,		0x21, 0
	.dw 0xee40, 0xc109,	0xee7f, 0xc109,		0x21, 0
	.dw 0xeec0, 0xc109,	0xeeff, 0xc109,		0x21, 0
	.dw 0xef40, 0xc109,	0xef7f, 0xc109,		0x21, 0
	.dw 0xefc0, 0xc109,	0xefff, 0xc109,		0x21, 0
	.dw 0xf040, 0xc109,	0xf07f, 0xc109,		0x21, 0
	.dw 0xf0c0, 0xc109,	0xf0ff, 0xc109,		0x21, 0
	.dw 0xf140, 0xc109,	0xf17f, 0xc109,		0x21, 0
	.dw 0xf1c0, 0xc109,	0xf1ff, 0xc109,		0x21, 0
	.dw 0xf240, 0xc109,	0xf27f, 0xc109,		0x21, 0
	.dw 0xf2c0, 0xc109,	0xf2ff, 0xc109,		0x21, 0
	.dw 0xf340, 0xc109,	0xf37f, 0xc109,		0x21, 0
	.dw 0xf3c0, 0xc109,	0xf3ff, 0xc109,		0x21, 0
	.dw 0xf440, 0xc109,	0xf47f, 0xc109,		0x21, 0
	.dw 0xf4c0, 0xc109,	0xf4ff, 0xc109,		0x21, 0
	.dw 0xf540, 0xc109,	0xf57f, 0xc109,		0x21, 0
	.dw 0xf5c0, 0xc109,	0xf5ff, 0xc109,		0x21, 0
	.dw 0xf640, 0xc109,	0xf67f, 0xc109,		0x21, 0
	.dw 0xf6c0, 0xc109,	0xf6ff, 0xc109,		0x21, 0
	.dw 0xf740, 0xc109,	0xf77f, 0xc109,		0x21, 0
	.dw 0xf7c0, 0xc109,	0xf7ff, 0xc109,		0x21, 0
	.dw 0xf840, 0xc109,	0xf87f, 0xc109,		0x21, 0
	.dw 0xf8c0, 0xc109,	0xf8ff, 0xc109,		0x21, 0
	.dw 0xf940, 0xc109,	0xf97f, 0xc109,		0x21, 0
	.dw 0xf9c0, 0xc109,	0x1fff, 0xc10a,		0x21, 0
	.dw 0x2040, 0xc10a,	0x207f, 0xc10a,		0x21, 0
	.dw 0x20c0, 0xc10a,	0x20ff, 0xc10a,		0x21, 0
	.dw 0x2140, 0xc10a,	0x217f, 0xc10a,		0x21, 0
	.dw 0x21c0, 0xc10a,	0x21ff, 0xc10a,		0x21, 0
	.dw 0x2240, 0xc10a,	0x227f, 0xc10a,		0x21, 0
	.dw 0x22c0, 0xc10a,	0x22ff, 0xc10a,		0x21, 0
	.dw 0x2340, 0xc10a,	0x237f, 0xc10a,		0x21, 0
	.dw 0x23c0, 0xc10a,	0x23ff, 0xc10a,		0x21, 0
	.dw 0x2440, 0xc10a,	0x247f, 0xc10a,		0x21, 0
	.dw 0x24c0, 0xc10a,	0x24ff, 0xc10a,		0x21, 0
	.dw 0x2540, 0xc10a,	0x257f, 0xc10a,		0x21, 0
	.dw 0x25c0, 0xc10a,	0x25ff, 0xc10a,		0x21, 0
	.dw 0x2640, 0xc10a,	0x267f, 0xc10a,		0x21, 0
	.dw 0x26c0, 0xc10a,	0x26ff, 0xc10a,		0x21, 0
	.dw 0x2740, 0xc10a,	0x277f, 0xc10a,		0x21, 0
	.dw 0x27c0, 0xc10a,	0x27ff, 0xc10a,		0x21, 0
	.dw 0x2840, 0xc10a,	0x287f, 0xc10a,		0x21, 0
	.dw 0x28c0, 0xc10a,	0x28ff, 0xc10a,		0x21, 0
	.dw 0x2940, 0xc10a,	0x297f, 0xc10a,		0x21, 0
	.dw 0x29c0, 0xc10a,	0x29ff, 0xc10a,		0x21, 0
	.dw 0x2a40, 0xc10a,	0x2a7f, 0xc10a,		0x21, 0
	.dw 0x2ac0, 0xc10a,	0x2aff, 0xc10a,		0x21, 0
	.dw 0x2b40, 0xc10a,	0x2b7f, 0xc10a,		0x21, 0
	.dw 0x2bc0, 0xc10a,	0x2bff, 0xc10a,		0x21, 0
	.dw 0x2c40, 0xc10a,	0x2c7f, 0xc10a,		0x21, 0
	.dw 0x2cc0, 0xc10a,	0x2cff, 0xc10a,		0x21, 0
	.dw 0x2d40, 0xc10a,	0x2d7f, 0xc10a,		0x21, 0
	.dw 0x2dc0, 0xc10a,	0x2dff, 0xc10a,		0x21, 0
	.dw 0x2e40, 0xc10a,	0x2e7f, 0xc10a,		0x21, 0
	.dw 0x2ec0, 0xc10a,	0x2eff, 0xc10a,		0x21, 0
	.dw 0x2f40, 0xc10a,	0x2f7f, 0xc10a,		0x21, 0
	.dw 0x2fc0, 0xc10a,	0x2fff, 0xc10a,		0x21, 0
	.dw 0x3040, 0xc10a,	0x307f, 0xc10a,		0x21, 0
	.dw 0x30c0, 0xc10a,	0x30ff, 0xc10a,		0x21, 0
	.dw 0x3140, 0xc10a,	0x317f, 0xc10a,		0x21, 0
	.dw 0x31c0, 0xc10a,	0x31ff, 0xc10a,		0x21, 0
	.dw 0x3240, 0xc10a,	0x327f, 0xc10a,		0x21, 0
	.dw 0x32c0, 0xc10a,	0x32ff, 0xc10a,		0x21, 0
	.dw 0x3340, 0xc10a,	0x337f, 0xc10a,		0x21, 0
	.dw 0x33c0, 0xc10a,	0x33ff, 0xc10a,		0x21, 0
	.dw 0x3440, 0xc10a,	0x347f, 0xc10a,		0x21, 0
	.dw 0x34c0, 0xc10a,	0x34ff, 0xc10a,		0x21, 0
	.dw 0x3540, 0xc10a,	0x357f, 0xc10a,		0x21, 0
	.dw 0x35c0, 0xc10a,	0x35ff, 0xc10a,		0x21, 0
	.dw 0x3640, 0xc10a,	0x367f, 0xc10a,		0x21, 0
	.dw 0x36c0, 0xc10a,	0x36ff, 0xc10a,		0x21, 0
	.dw 0x3740, 0xc10a,	0x377f, 0xc10a,		0x21, 0
	.dw 0x37c0, 0xc10a,	0x37ff, 0xc10a,		0x21, 0
	.dw 0x3840, 0xc10a,	0x387f, 0xc10a,		0x21, 0
	.dw 0x38c0, 0xc10a,	0x38ff, 0xc10a,		0x21, 0
	.dw 0x3940, 0xc10a,	0x397f, 0xc10a,		0x21, 0
	.dw 0x39c0, 0xc10a,	0x5fff, 0xc10a,		0x21, 0
	.dw 0x6040, 0xc10a,	0x607f, 0xc10a,		0x21, 0
	.dw 0x60c0, 0xc10a,	0x60ff, 0xc10a,		0x21, 0
	.dw 0x6140, 0xc10a,	0x617f, 0xc10a,		0x21, 0
	.dw 0x61c0, 0xc10a,	0x61ff, 0xc10a,		0x21, 0
	.dw 0x6240, 0xc10a,	0x627f, 0xc10a,		0x21, 0
	.dw 0x62c0, 0xc10a,	0x62ff, 0xc10a,		0x21, 0
	.dw 0x6340, 0xc10a,	0x637f, 0xc10a,		0x21, 0
	.dw 0x63c0, 0xc10a,	0x63ff, 0xc10a,		0x21, 0
	.dw 0x6440, 0xc10a,	0x647f, 0xc10a,		0x21, 0
	.dw 0x64c0, 0xc10a,	0x64ff, 0xc10a,		0x21, 0
	.dw 0x6540, 0xc10a,	0x657f, 0xc10a,		0x21, 0
	.dw 0x65c0, 0xc10a,	0x65ff, 0xc10a,		0x21, 0
	.dw 0x6640, 0xc10a,	0x667f, 0xc10a,		0x21, 0
	.dw 0x66c0, 0xc10a,	0x66ff, 0xc10a,		0x21, 0
	.dw 0x6740, 0xc10a,	0x677f, 0xc10a,		0x21, 0
	.dw 0x67c0, 0xc10a,	0x67ff, 0xc10a,		0x21, 0
	.dw 0x6840, 0xc10a,	0x687f, 0xc10a,		0x21, 0
	.dw 0x68c0, 0xc10a,	0x68ff, 0xc10a,		0x21, 0
	.dw 0x6940, 0xc10a,	0x697f, 0xc10a,		0x21, 0
	.dw 0x69c0, 0xc10a,	0x69ff, 0xc10a,		0x21, 0
	.dw 0x6a40, 0xc10a,	0x6a7f, 0xc10a,		0x21, 0
	.dw 0x6ac0, 0xc10a,	0x6aff, 0xc10a,		0x21, 0
	.dw 0x6b40, 0xc10a,	0x6b7f, 0xc10a,		0x21, 0
	.dw 0x6bc0, 0xc10a,	0x6bff, 0xc10a,		0x21, 0
	.dw 0x6c40, 0xc10a,	0x6c7f, 0xc10a,		0x21, 0
	.dw 0x6cc0, 0xc10a,	0x6cff, 0xc10a,		0x21, 0
	.dw 0x6d40, 0xc10a,	0x6d7f, 0xc10a,		0x21, 0
	.dw 0x6dc0, 0xc10a,	0x6dff, 0xc10a,		0x21, 0
	.dw 0x6e40, 0xc10a,	0x6e7f, 0xc10a,		0x21, 0
	.dw 0x6ec0, 0xc10a,	0x6eff, 0xc10a,		0x21, 0
	.dw 0x6f40, 0xc10a,	0x6f7f, 0xc10a,		0x21, 0
	.dw 0x6fc0, 0xc10a,	0x6fff, 0xc10a,		0x21, 0
	.dw 0x7040, 0xc10a,	0x707f, 0xc10a,		0x21, 0
	.dw 0x70c0, 0xc10a,	0x70ff, 0xc10a,		0x21, 0
	.dw 0x7140, 0xc10a,	0x717f, 0xc10a,		0x21, 0
	.dw 0x71c0, 0xc10a,	0x71ff, 0xc10a,		0x21, 0
	.dw 0x7240, 0xc10a,	0x727f, 0xc10a,		0x21, 0
	.dw 0x72c0, 0xc10a,	0x72ff, 0xc10a,		0x21, 0
	.dw 0x7340, 0xc10a,	0x737f, 0xc10a,		0x21, 0
	.dw 0x73c0, 0xc10a,	0x73ff, 0xc10a,		0x21, 0
	.dw 0x7440, 0xc10a,	0x747f, 0xc10a,		0x21, 0
	.dw 0x74c0, 0xc10a,	0x74ff, 0xc10a,		0x21, 0
	.dw 0x7540, 0xc10a,	0x757f, 0xc10a,		0x21, 0
	.dw 0x75c0, 0xc10a,	0x75ff, 0xc10a,		0x21, 0
	.dw 0x7640, 0xc10a,	0x767f, 0xc10a,		0x21, 0
	.dw 0x76c0, 0xc10a,	0x76ff, 0xc10a,		0x21, 0
	.dw 0x7740, 0xc10a,	0x777f, 0xc10a,		0x21, 0
	.dw 0x77c0, 0xc10a,	0x77ff, 0xc10a,		0x21, 0
	.dw 0x7840, 0xc10a,	0x787f, 0xc10a,		0x21, 0
	.dw 0x78c0, 0xc10a,	0x78ff, 0xc10a,		0x21, 0
	.dw 0x7940, 0xc10a,	0x797f, 0xc10a,		0x21, 0
	.dw 0x79c0, 0xc10a,	0x9fff, 0xc10a,		0x21, 0
	.dw 0xa040, 0xc10a,	0xa07f, 0xc10a,		0x21, 0
	.dw 0xa0c0, 0xc10a,	0xa0ff, 0xc10a,		0x21, 0
	.dw 0xa140, 0xc10a,	0xa17f, 0xc10a,		0x21, 0
	.dw 0xa1c0, 0xc10a,	0xa1ff, 0xc10a,		0x21, 0
	.dw 0xa240, 0xc10a,	0xa27f, 0xc10a,		0x21, 0
	.dw 0xa2c0, 0xc10a,	0xa2ff, 0xc10a,		0x21, 0
	.dw 0xa340, 0xc10a,	0xa37f, 0xc10a,		0x21, 0
	.dw 0xa3c0, 0xc10a,	0xa3ff, 0xc10a,		0x21, 0
	.dw 0xa440, 0xc10a,	0xa47f, 0xc10a,		0x21, 0
	.dw 0xa4c0, 0xc10a,	0xa4ff, 0xc10a,		0x21, 0
	.dw 0xa540, 0xc10a,	0xa57f, 0xc10a,		0x21, 0
	.dw 0xa5c0, 0xc10a,	0xa5ff, 0xc10a,		0x21, 0
	.dw 0xa640, 0xc10a,	0xa67f, 0xc10a,		0x21, 0
	.dw 0xa6c0, 0xc10a,	0xa6ff, 0xc10a,		0x21, 0
	.dw 0xa740, 0xc10a,	0xa77f, 0xc10a,		0x21, 0
	.dw 0xa7c0, 0xc10a,	0xa7ff, 0xc10a,		0x21, 0
	.dw 0xa840, 0xc10a,	0xa87f, 0xc10a,		0x21, 0
	.dw 0xa8c0, 0xc10a,	0xa8ff, 0xc10a,		0x21, 0
	.dw 0xa940, 0xc10a,	0xa97f, 0xc10a,		0x21, 0
	.dw 0xa9c0, 0xc10a,	0xa9ff, 0xc10a,		0x21, 0
	.dw 0xaa40, 0xc10a,	0xaa7f, 0xc10a,		0x21, 0
	.dw 0xaac0, 0xc10a,	0xaaff, 0xc10a,		0x21, 0
	.dw 0xab40, 0xc10a,	0xab7f, 0xc10a,		0x21, 0
	.dw 0xabc0, 0xc10a,	0xabff, 0xc10a,		0x21, 0
	.dw 0xac40, 0xc10a,	0xac7f, 0xc10a,		0x21, 0
	.dw 0xacc0, 0xc10a,	0xacff, 0xc10a,		0x21, 0
	.dw 0xad40, 0xc10a,	0xad7f, 0xc10a,		0x21, 0
	.dw 0xadc0, 0xc10a,	0xadff, 0xc10a,		0x21, 0
	.dw 0xae40, 0xc10a,	0xae7f, 0xc10a,		0x21, 0
	.dw 0xaec0, 0xc10a,	0xaeff, 0xc10a,		0x21, 0
	.dw 0xaf40, 0xc10a,	0xaf7f, 0xc10a,		0x21, 0
	.dw 0xafc0, 0xc10a,	0xafff, 0xc10a,		0x21, 0
	.dw 0xb040, 0xc10a,	0xb07f, 0xc10a,		0x21, 0
	.dw 0xb0c0, 0xc10a,	0xb0ff, 0xc10a,		0x21, 0
	.dw 0xb140, 0xc10a,	0xb17f, 0xc10a,		0x21, 0
	.dw 0xb1c0, 0xc10a,	0xb1ff, 0xc10a,		0x21, 0
	.dw 0xb240, 0xc10a,	0xb27f, 0xc10a,		0x21, 0
	.dw 0xb2c0, 0xc10a,	0xb2ff, 0xc10a,		0x21, 0
	.dw 0xb340, 0xc10a,	0xb37f, 0xc10a,		0x21, 0
	.dw 0xb3c0, 0xc10a,	0xb3ff, 0xc10a,		0x21, 0
	.dw 0xb440, 0xc10a,	0xb47f, 0xc10a,		0x21, 0
	.dw 0xb4c0, 0xc10a,	0xb4ff, 0xc10a,		0x21, 0
	.dw 0xb540, 0xc10a,	0xb57f, 0xc10a,		0x21, 0
	.dw 0xb5c0, 0xc10a,	0xb5ff, 0xc10a,		0x21, 0
	.dw 0xb640, 0xc10a,	0xb67f, 0xc10a,		0x21, 0
	.dw 0xb6c0, 0xc10a,	0xb6ff, 0xc10a,		0x21, 0
	.dw 0xb740, 0xc10a,	0xb77f, 0xc10a,		0x21, 0
	.dw 0xb7c0, 0xc10a,	0xb7ff, 0xc10a,		0x21, 0
	.dw 0xb840, 0xc10a,	0xb87f, 0xc10a,		0x21, 0
	.dw 0xb8c0, 0xc10a,	0xb8ff, 0xc10a,		0x21, 0
	.dw 0xb940, 0xc10a,	0xb97f, 0xc10a,		0x21, 0
	.dw 0xb9c0, 0xc10a,	0xdfff, 0xc10a,		0x21, 0
	.dw 0xe040, 0xc10a,	0xe07f, 0xc10a,		0x21, 0
	.dw 0xe0c0, 0xc10a,	0xe0ff, 0xc10a,		0x21, 0
	.dw 0xe140, 0xc10a,	0xe17f, 0xc10a,		0x21, 0
	.dw 0xe1c0, 0xc10a,	0xe1ff, 0xc10a,		0x21, 0
	.dw 0xe240, 0xc10a,	0xe27f, 0xc10a,		0x21, 0
	.dw 0xe2c0, 0xc10a,	0xe2ff, 0xc10a,		0x21, 0
	.dw 0xe340, 0xc10a,	0xe37f, 0xc10a,		0x21, 0
	.dw 0xe3c0, 0xc10a,	0xe3ff, 0xc10a,		0x21, 0
	.dw 0xe440, 0xc10a,	0xe47f, 0xc10a,		0x21, 0
	.dw 0xe4c0, 0xc10a,	0xe4ff, 0xc10a,		0x21, 0
	.dw 0xe540, 0xc10a,	0xe57f, 0xc10a,		0x21, 0
	.dw 0xe5c0, 0xc10a,	0xe5ff, 0xc10a,		0x21, 0
	.dw 0xe640, 0xc10a,	0xe67f, 0xc10a,		0x21, 0
	.dw 0xe6c0, 0xc10a,	0xe6ff, 0xc10a,		0x21, 0
	.dw 0xe740, 0xc10a,	0xe77f, 0xc10a,		0x21, 0
	.dw 0xe7c0, 0xc10a,	0xe7ff, 0xc10a,		0x21, 0
	.dw 0xe840, 0xc10a,	0xe87f, 0xc10a,		0x21, 0
	.dw 0xe8c0, 0xc10a,	0xe8ff, 0xc10a,		0x21, 0
	.dw 0xe940, 0xc10a,	0xe97f, 0xc10a,		0x21, 0
	.dw 0xe9c0, 0xc10a,	0xe9ff, 0xc10a,		0x21, 0
	.dw 0xea40, 0xc10a,	0xea7f, 0xc10a,		0x21, 0
	.dw 0xeac0, 0xc10a,	0xeaff, 0xc10a,		0x21, 0
	.dw 0xeb40, 0xc10a,	0xeb7f, 0xc10a,		0x21, 0
	.dw 0xebc0, 0xc10a,	0xebff, 0xc10a,		0x21, 0
	.dw 0xec40, 0xc10a,	0xec7f, 0xc10a,		0x21, 0
	.dw 0xecc0, 0xc10a,	0xecff, 0xc10a,		0x21, 0
	.dw 0xed40, 0xc10a,	0xed7f, 0xc10a,		0x21, 0
	.dw 0xedc0, 0xc10a,	0xedff, 0xc10a,		0x21, 0
	.dw 0xee40, 0xc10a,	0xee7f, 0xc10a,		0x21, 0
	.dw 0xeec0, 0xc10a,	0xeeff, 0xc10a,		0x21, 0
	.dw 0xef40, 0xc10a,	0xef7f, 0xc10a,		0x21, 0
	.dw 0xefc0, 0xc10a,	0xefff, 0xc10a,		0x21, 0
	.dw 0xf040, 0xc10a,	0xf07f, 0xc10a,		0x21, 0
	.dw 0xf0c0, 0xc10a,	0xf0ff, 0xc10a,		0x21, 0
	.dw 0xf140, 0xc10a,	0xf17f, 0xc10a,		0x21, 0
	.dw 0xf1c0, 0xc10a,	0xf1ff, 0xc10a,		0x21, 0
	.dw 0xf240, 0xc10a,	0xf27f, 0xc10a,		0x21, 0
	.dw 0xf2c0, 0xc10a,	0xf2ff, 0xc10a,		0x21, 0
	.dw 0xf340, 0xc10a,	0xf37f, 0xc10a,		0x21, 0
	.dw 0xf3c0, 0xc10a,	0xf3ff, 0xc10a,		0x21, 0
	.dw 0xf440, 0xc10a,	0xf47f, 0xc10a,		0x21, 0
	.dw 0xf4c0, 0xc10a,	0xf4ff, 0xc10a,		0x21, 0
	.dw 0xf540, 0xc10a,	0xf57f, 0xc10a,		0x21, 0
	.dw 0xf5c0, 0xc10a,	0xf5ff, 0xc10a,		0x21, 0
	.dw 0xf640, 0xc10a,	0xf67f, 0xc10a,		0x21, 0
	.dw 0xf6c0, 0xc10a,	0xf6ff, 0xc10a,		0x21, 0
	.dw 0xf740, 0xc10a,	0xf77f, 0xc10a,		0x21, 0
	.dw 0xf7c0, 0xc10a,	0xf7ff, 0xc10a,		0x21, 0
	.dw 0xf840, 0xc10a,	0xf87f, 0xc10a,		0x21, 0
	.dw 0xf8c0, 0xc10a,	0xf8ff, 0xc10a,		0x21, 0
	.dw 0xf940, 0xc10a,	0xf97f, 0xc10a,		0x21, 0
	.dw 0xf9c0, 0xc10a,	0x1fff, 0xc10b,		0x21, 0
	.dw 0x2040, 0xc10b,	0x207f, 0xc10b,		0x21, 0
	.dw 0x20c0, 0xc10b,	0x20ff, 0xc10b,		0x21, 0
	.dw 0x2140, 0xc10b,	0x217f, 0xc10b,		0x21, 0
	.dw 0x21c0, 0xc10b,	0x21ff, 0xc10b,		0x21, 0
	.dw 0x2240, 0xc10b,	0x227f, 0xc10b,		0x21, 0
	.dw 0x22c0, 0xc10b,	0x22ff, 0xc10b,		0x21, 0
	.dw 0x2340, 0xc10b,	0x237f, 0xc10b,		0x21, 0
	.dw 0x23c0, 0xc10b,	0x23ff, 0xc10b,		0x21, 0
	.dw 0x2440, 0xc10b,	0x247f, 0xc10b,		0x21, 0
	.dw 0x24c0, 0xc10b,	0x24ff, 0xc10b,		0x21, 0
	.dw 0x2540, 0xc10b,	0x257f, 0xc10b,		0x21, 0
	.dw 0x25c0, 0xc10b,	0x25ff, 0xc10b,		0x21, 0
	.dw 0x2640, 0xc10b,	0x267f, 0xc10b,		0x21, 0
	.dw 0x26c0, 0xc10b,	0x26ff, 0xc10b,		0x21, 0
	.dw 0x2740, 0xc10b,	0x277f, 0xc10b,		0x21, 0
	.dw 0x27c0, 0xc10b,	0x27ff, 0xc10b,		0x21, 0
	.dw 0x2840, 0xc10b,	0x287f, 0xc10b,		0x21, 0
	.dw 0x28c0, 0xc10b,	0x28ff, 0xc10b,		0x21, 0
	.dw 0x2940, 0xc10b,	0x297f, 0xc10b,		0x21, 0
	.dw 0x29c0, 0xc10b,	0x29ff, 0xc10b,		0x21, 0
	.dw 0x2a40, 0xc10b,	0x2a7f, 0xc10b,		0x21, 0
	.dw 0x2ac0, 0xc10b,	0x2aff, 0xc10b,		0x21, 0
	.dw 0x2b40, 0xc10b,	0x2b7f, 0xc10b,		0x21, 0
	.dw 0x2bc0, 0xc10b,	0x2bff, 0xc10b,		0x21, 0
	.dw 0x2c40, 0xc10b,	0x2c7f, 0xc10b,		0x21, 0
	.dw 0x2cc0, 0xc10b,	0x2cff, 0xc10b,		0x21, 0
	.dw 0x2d40, 0xc10b,	0x2d7f, 0xc10b,		0x21, 0
	.dw 0x2dc0, 0xc10b,	0x2dff, 0xc10b,		0x21, 0
	.dw 0x2e40, 0xc10b,	0x2e7f, 0xc10b,		0x21, 0
	.dw 0x2ec0, 0xc10b,	0x2eff, 0xc10b,		0x21, 0
	.dw 0x2f40, 0xc10b,	0x2f7f, 0xc10b,		0x21, 0
	.dw 0x2fc0, 0xc10b,	0x2fff, 0xc10b,		0x21, 0
	.dw 0x3040, 0xc10b,	0x307f, 0xc10b,		0x21, 0
	.dw 0x30c0, 0xc10b,	0x30ff, 0xc10b,		0x21, 0
	.dw 0x3140, 0xc10b,	0x317f, 0xc10b,		0x21, 0
	.dw 0x31c0, 0xc10b,	0x31ff, 0xc10b,		0x21, 0
	.dw 0x3240, 0xc10b,	0x327f, 0xc10b,		0x21, 0
	.dw 0x32c0, 0xc10b,	0x32ff, 0xc10b,		0x21, 0
	.dw 0x3340, 0xc10b,	0x337f, 0xc10b,		0x21, 0
	.dw 0x33c0, 0xc10b,	0x33ff, 0xc10b,		0x21, 0
	.dw 0x3440, 0xc10b,	0x347f, 0xc10b,		0x21, 0
	.dw 0x34c0, 0xc10b,	0x34ff, 0xc10b,		0x21, 0
	.dw 0x3540, 0xc10b,	0x357f, 0xc10b,		0x21, 0
	.dw 0x35c0, 0xc10b,	0x35ff, 0xc10b,		0x21, 0
	.dw 0x3640, 0xc10b,	0x367f, 0xc10b,		0x21, 0
	.dw 0x36c0, 0xc10b,	0x36ff, 0xc10b,		0x21, 0
	.dw 0x3740, 0xc10b,	0x377f, 0xc10b,		0x21, 0
	.dw 0x37c0, 0xc10b,	0x37ff, 0xc10b,		0x21, 0
	.dw 0x3840, 0xc10b,	0x387f, 0xc10b,		0x21, 0
	.dw 0x38c0, 0xc10b,	0x38ff, 0xc10b,		0x21, 0
	.dw 0x3940, 0xc10b,	0x397f, 0xc10b,		0x21, 0
	.dw 0x39c0, 0xc10b,	0xffff, 0xc10b,		0x21, 0
	.dw 0x0040, 0xc10c,	0x007f, 0xc10c,		0x21, 0
	.dw 0x00c0, 0xc10c,	0x00ff, 0xc10c,		0x21, 0
	.dw 0x0140, 0xc10c,	0x017f, 0xc10c,		0x21, 0
	.dw 0x01c0, 0xc10c,	0x01ff, 0xc10c,		0x21, 0
	.dw 0x0240, 0xc10c,	0x027f, 0xc10c,		0x21, 0
	.dw 0x02c0, 0xc10c,	0x02ff, 0xc10c,		0x21, 0
	.dw 0x0340, 0xc10c,	0x037f, 0xc10c,		0x21, 0
	.dw 0x03c0, 0xc10c,	0x03ff, 0xc10c,		0x21, 0
	.dw 0x0440, 0xc10c,	0x047f, 0xc10c,		0x21, 0
	.dw 0x04c0, 0xc10c,	0x04ff, 0xc10c,		0x21, 0
	.dw 0x0540, 0xc10c,	0x057f, 0xc10c,		0x21, 0
	.dw 0x05c0, 0xc10c,	0x05ff, 0xc10c,		0x21, 0
	.dw 0x0640, 0xc10c,	0x067f, 0xc10c,		0x21, 0
	.dw 0x06c0, 0xc10c,	0x06ff, 0xc10c,		0x21, 0
	.dw 0x0740, 0xc10c,	0x077f, 0xc10c,		0x21, 0
	.dw 0x07c0, 0xc10c,	0x07ff, 0xc10c,		0x21, 0
	.dw 0x0840, 0xc10c,	0x087f, 0xc10c,		0x21, 0
	.dw 0x08c0, 0xc10c,	0x08ff, 0xc10c,		0x21, 0
	.dw 0x0940, 0xc10c,	0x097f, 0xc10c,		0x21, 0
	.dw 0x09c0, 0xc10c,	0x09ff, 0xc10c,		0x21, 0
	.dw 0x0a40, 0xc10c,	0x0a7f, 0xc10c,		0x21, 0
	.dw 0x0ac0, 0xc10c,	0x0aff, 0xc10c,		0x21, 0
	.dw 0x0b40, 0xc10c,	0x0b7f, 0xc10c,		0x21, 0
	.dw 0x0bc0, 0xc10c,	0x0bff, 0xc10c,		0x21, 0
	.dw 0x0c40, 0xc10c,	0x0c7f, 0xc10c,		0x21, 0
	.dw 0x0cc0, 0xc10c,	0x0cff, 0xc10c,		0x21, 0
	.dw 0x0d40, 0xc10c,	0x0d7f, 0xc10c,		0x21, 0
	.dw 0x0dc0, 0xc10c,	0x0dff, 0xc10c,		0x21, 0
	.dw 0x0e40, 0xc10c,	0x0e7f, 0xc10c,		0x21, 0
	.dw 0x0ec0, 0xc10c,	0x0eff, 0xc10c,		0x21, 0
	.dw 0x0f40, 0xc10c,	0x0f7f, 0xc10c,		0x21, 0
	.dw 0x0fc0, 0xc10c,	0x0fff, 0xc10c,		0x21, 0
	.dw 0x1040, 0xc10c,	0x107f, 0xc10c,		0x21, 0
	.dw 0x10c0, 0xc10c,	0x10ff, 0xc10c,		0x21, 0
	.dw 0x1140, 0xc10c,	0x117f, 0xc10c,		0x21, 0
	.dw 0x11c0, 0xc10c,	0x11ff, 0xc10c,		0x21, 0
	.dw 0x1240, 0xc10c,	0x127f, 0xc10c,		0x21, 0
	.dw 0x12c0, 0xc10c,	0x12ff, 0xc10c,		0x21, 0
	.dw 0x1340, 0xc10c,	0x137f, 0xc10c,		0x21, 0
	.dw 0x13c0, 0xc10c,	0x13ff, 0xc10c,		0x21, 0
	.dw 0x1440, 0xc10c,	0x147f, 0xc10c,		0x21, 0
	.dw 0x14c0, 0xc10c,	0x14ff, 0xc10c,		0x21, 0
	.dw 0x1540, 0xc10c,	0x157f, 0xc10c,		0x21, 0
	.dw 0x15c0, 0xc10c,	0x15ff, 0xc10c,		0x21, 0
	.dw 0x1640, 0xc10c,	0x167f, 0xc10c,		0x21, 0
	.dw 0x16c0, 0xc10c,	0x16ff, 0xc10c,		0x21, 0
	.dw 0x1740, 0xc10c,	0x177f, 0xc10c,		0x21, 0
	.dw 0x17c0, 0xc10c,	0x17ff, 0xc10c,		0x21, 0
	.dw 0x1840, 0xc10c,	0x187f, 0xc10c,		0x21, 0
	.dw 0x18c0, 0xc10c,	0x18ff, 0xc10c,		0x21, 0
	.dw 0x1940, 0xc10c,	0x197f, 0xc10c,		0x21, 0
	.dw 0x19c0, 0xc10c,	0x1fff, 0xc10c,		0x21, 0
	.dw 0x2040, 0xc10c,	0x207f, 0xc10c,		0x21, 0
	.dw 0x20c0, 0xc10c,	0x20ff, 0xc10c,		0x21, 0
	.dw 0x2140, 0xc10c,	0x217f, 0xc10c,		0x21, 0
	.dw 0x21c0, 0xc10c,	0x21ff, 0xc10c,		0x21, 0
	.dw 0x2240, 0xc10c,	0x227f, 0xc10c,		0x21, 0
	.dw 0x22c0, 0xc10c,	0x22ff, 0xc10c,		0x21, 0
	.dw 0x2340, 0xc10c,	0x237f, 0xc10c,		0x21, 0
	.dw 0x23c0, 0xc10c,	0x23ff, 0xc10c,		0x21, 0
	.dw 0x2440, 0xc10c,	0x247f, 0xc10c,		0x21, 0
	.dw 0x24c0, 0xc10c,	0x24ff, 0xc10c,		0x21, 0
	.dw 0x2540, 0xc10c,	0x257f, 0xc10c,		0x21, 0
	.dw 0x25c0, 0xc10c,	0x25ff, 0xc10c,		0x21, 0
	.dw 0x2640, 0xc10c,	0x267f, 0xc10c,		0x21, 0
	.dw 0x26c0, 0xc10c,	0x26ff, 0xc10c,		0x21, 0
	.dw 0x2740, 0xc10c,	0x277f, 0xc10c,		0x21, 0
	.dw 0x27c0, 0xc10c,	0x27ff, 0xc10c,		0x21, 0
	.dw 0x2840, 0xc10c,	0x287f, 0xc10c,		0x21, 0
	.dw 0x28c0, 0xc10c,	0x28ff, 0xc10c,		0x21, 0
	.dw 0x2940, 0xc10c,	0x297f, 0xc10c,		0x21, 0
	.dw 0x29c0, 0xc10c,	0x29ff, 0xc10c,		0x21, 0
	.dw 0x2a40, 0xc10c,	0x2a7f, 0xc10c,		0x21, 0
	.dw 0x2ac0, 0xc10c,	0x2aff, 0xc10c,		0x21, 0
	.dw 0x2b40, 0xc10c,	0x2b7f, 0xc10c,		0x21, 0
	.dw 0x2bc0, 0xc10c,	0x2bff, 0xc10c,		0x21, 0
	.dw 0x2c40, 0xc10c,	0x2c7f, 0xc10c,		0x21, 0
	.dw 0x2cc0, 0xc10c,	0x2cff, 0xc10c,		0x21, 0
	.dw 0x2d40, 0xc10c,	0x2d7f, 0xc10c,		0x21, 0
	.dw 0x2dc0, 0xc10c,	0x2dff, 0xc10c,		0x21, 0
	.dw 0x2e40, 0xc10c,	0x2e7f, 0xc10c,		0x21, 0
	.dw 0x2ec0, 0xc10c,	0x2eff, 0xc10c,		0x21, 0
	.dw 0x2f40, 0xc10c,	0x2f7f, 0xc10c,		0x21, 0
	.dw 0x2fc0, 0xc10c,	0x2fff, 0xc10c,		0x21, 0
	.dw 0x3040, 0xc10c,	0x307f, 0xc10c,		0x21, 0
	.dw 0x30c0, 0xc10c,	0x30ff, 0xc10c,		0x21, 0
	.dw 0x3140, 0xc10c,	0x317f, 0xc10c,		0x21, 0
	.dw 0x31c0, 0xc10c,	0x31ff, 0xc10c,		0x21, 0
	.dw 0x3240, 0xc10c,	0x327f, 0xc10c,		0x21, 0
	.dw 0x32c0, 0xc10c,	0x32ff, 0xc10c,		0x21, 0
	.dw 0x3340, 0xc10c,	0x337f, 0xc10c,		0x21, 0
	.dw 0x33c0, 0xc10c,	0x33ff, 0xc10c,		0x21, 0
	.dw 0x3440, 0xc10c,	0x347f, 0xc10c,		0x21, 0
	.dw 0x34c0, 0xc10c,	0x34ff, 0xc10c,		0x21, 0
	.dw 0x3540, 0xc10c,	0x357f, 0xc10c,		0x21, 0
	.dw 0x35c0, 0xc10c,	0x35ff, 0xc10c,		0x21, 0
	.dw 0x3640, 0xc10c,	0x367f, 0xc10c,		0x21, 0
	.dw 0x36c0, 0xc10c,	0x36ff, 0xc10c,		0x21, 0
	.dw 0x3740, 0xc10c,	0x377f, 0xc10c,		0x21, 0
	.dw 0x37c0, 0xc10c,	0x37ff, 0xc10c,		0x21, 0
	.dw 0x3840, 0xc10c,	0x387f, 0xc10c,		0x21, 0
	.dw 0x38c0, 0xc10c,	0x38ff, 0xc10c,		0x21, 0
	.dw 0x3940, 0xc10c,	0x397f, 0xc10c,		0x21, 0
	.dw 0x39c0, 0xc10c,	0x3fff, 0xc10c,		0x21, 0
	.dw 0x4040, 0xc10c,	0x407f, 0xc10c,		0x21, 0
	.dw 0x40c0, 0xc10c,	0x40ff, 0xc10c,		0x21, 0
	.dw 0x4140, 0xc10c,	0x417f, 0xc10c,		0x21, 0
	.dw 0x41c0, 0xc10c,	0x41ff, 0xc10c,		0x21, 0
	.dw 0x4240, 0xc10c,	0x427f, 0xc10c,		0x21, 0
	.dw 0x42c0, 0xc10c,	0x42ff, 0xc10c,		0x21, 0
	.dw 0x4340, 0xc10c,	0x437f, 0xc10c,		0x21, 0
	.dw 0x43c0, 0xc10c,	0x43ff, 0xc10c,		0x21, 0
	.dw 0x4440, 0xc10c,	0x447f, 0xc10c,		0x21, 0
	.dw 0x44c0, 0xc10c,	0x44ff, 0xc10c,		0x21, 0
	.dw 0x4540, 0xc10c,	0x457f, 0xc10c,		0x21, 0
	.dw 0x45c0, 0xc10c,	0x45ff, 0xc10c,		0x21, 0
	.dw 0x4640, 0xc10c,	0x467f, 0xc10c,		0x21, 0
	.dw 0x46c0, 0xc10c,	0x46ff, 0xc10c,		0x21, 0
	.dw 0x4740, 0xc10c,	0x477f, 0xc10c,		0x21, 0
	.dw 0x47c0, 0xc10c,	0x47ff, 0xc10c,		0x21, 0
	.dw 0x4840, 0xc10c,	0x487f, 0xc10c,		0x21, 0
	.dw 0x48c0, 0xc10c,	0x48ff, 0xc10c,		0x21, 0
	.dw 0x4940, 0xc10c,	0x497f, 0xc10c,		0x21, 0
	.dw 0x49c0, 0xc10c,	0x49ff, 0xc10c,		0x21, 0
	.dw 0x4a40, 0xc10c,	0x4a7f, 0xc10c,		0x21, 0
	.dw 0x4ac0, 0xc10c,	0x4aff, 0xc10c,		0x21, 0
	.dw 0x4b40, 0xc10c,	0x4b7f, 0xc10c,		0x21, 0
	.dw 0x4bc0, 0xc10c,	0x4bff, 0xc10c,		0x21, 0
	.dw 0x4c40, 0xc10c,	0x4c7f, 0xc10c,		0x21, 0
	.dw 0x4cc0, 0xc10c,	0x4cff, 0xc10c,		0x21, 0
	.dw 0x4d40, 0xc10c,	0x4d7f, 0xc10c,		0x21, 0
	.dw 0x4dc0, 0xc10c,	0x4dff, 0xc10c,		0x21, 0
	.dw 0x4e40, 0xc10c,	0x4e7f, 0xc10c,		0x21, 0
	.dw 0x4ec0, 0xc10c,	0x4eff, 0xc10c,		0x21, 0
	.dw 0x4f40, 0xc10c,	0x4f7f, 0xc10c,		0x21, 0
	.dw 0x4fc0, 0xc10c,	0x4fff, 0xc10c,		0x21, 0
	.dw 0x5040, 0xc10c,	0x507f, 0xc10c,		0x21, 0
	.dw 0x50c0, 0xc10c,	0x50ff, 0xc10c,		0x21, 0
	.dw 0x5140, 0xc10c,	0x517f, 0xc10c,		0x21, 0
	.dw 0x51c0, 0xc10c,	0x51ff, 0xc10c,		0x21, 0
	.dw 0x5240, 0xc10c,	0x527f, 0xc10c,		0x21, 0
	.dw 0x52c0, 0xc10c,	0x52ff, 0xc10c,		0x21, 0
	.dw 0x5340, 0xc10c,	0x537f, 0xc10c,		0x21, 0
	.dw 0x53c0, 0xc10c,	0x53ff, 0xc10c,		0x21, 0
	.dw 0x5440, 0xc10c,	0x547f, 0xc10c,		0x21, 0
	.dw 0x54c0, 0xc10c,	0x54ff, 0xc10c,		0x21, 0
	.dw 0x5540, 0xc10c,	0x557f, 0xc10c,		0x21, 0
	.dw 0x55c0, 0xc10c,	0x55ff, 0xc10c,		0x21, 0
	.dw 0x5640, 0xc10c,	0x567f, 0xc10c,		0x21, 0
	.dw 0x56c0, 0xc10c,	0x56ff, 0xc10c,		0x21, 0
	.dw 0x5740, 0xc10c,	0x577f, 0xc10c,		0x21, 0
	.dw 0x57c0, 0xc10c,	0x57ff, 0xc10c,		0x21, 0
	.dw 0x5840, 0xc10c,	0x587f, 0xc10c,		0x21, 0
	.dw 0x58c0, 0xc10c,	0x58ff, 0xc10c,		0x21, 0
	.dw 0x5940, 0xc10c,	0x597f, 0xc10c,		0x21, 0
	.dw 0x59c0, 0xc10c,	0x5fff, 0xc10c,		0x21, 0
	.dw 0x6040, 0xc10c,	0x607f, 0xc10c,		0x21, 0
	.dw 0x60c0, 0xc10c,	0x60ff, 0xc10c,		0x21, 0
	.dw 0x6140, 0xc10c,	0x617f, 0xc10c,		0x21, 0
	.dw 0x61c0, 0xc10c,	0x61ff, 0xc10c,		0x21, 0
	.dw 0x6240, 0xc10c,	0x627f, 0xc10c,		0x21, 0
	.dw 0x62c0, 0xc10c,	0x62ff, 0xc10c,		0x21, 0
	.dw 0x6340, 0xc10c,	0x637f, 0xc10c,		0x21, 0
	.dw 0x63c0, 0xc10c,	0x63ff, 0xc10c,		0x21, 0
	.dw 0x6440, 0xc10c,	0x647f, 0xc10c,		0x21, 0
	.dw 0x64c0, 0xc10c,	0x64ff, 0xc10c,		0x21, 0
	.dw 0x6540, 0xc10c,	0x657f, 0xc10c,		0x21, 0
	.dw 0x65c0, 0xc10c,	0x65ff, 0xc10c,		0x21, 0
	.dw 0x6640, 0xc10c,	0x667f, 0xc10c,		0x21, 0
	.dw 0x66c0, 0xc10c,	0x66ff, 0xc10c,		0x21, 0
	.dw 0x6740, 0xc10c,	0x677f, 0xc10c,		0x21, 0
	.dw 0x67c0, 0xc10c,	0x67ff, 0xc10c,		0x21, 0
	.dw 0x6840, 0xc10c,	0x687f, 0xc10c,		0x21, 0
	.dw 0x68c0, 0xc10c,	0x68ff, 0xc10c,		0x21, 0
	.dw 0x6940, 0xc10c,	0x697f, 0xc10c,		0x21, 0
	.dw 0x69c0, 0xc10c,	0x69ff, 0xc10c,		0x21, 0
	.dw 0x6a40, 0xc10c,	0x6a7f, 0xc10c,		0x21, 0
	.dw 0x6ac0, 0xc10c,	0x6aff, 0xc10c,		0x21, 0
	.dw 0x6b40, 0xc10c,	0x6b7f, 0xc10c,		0x21, 0
	.dw 0x6bc0, 0xc10c,	0x6bff, 0xc10c,		0x21, 0
	.dw 0x6c40, 0xc10c,	0x6c7f, 0xc10c,		0x21, 0
	.dw 0x6cc0, 0xc10c,	0x6cff, 0xc10c,		0x21, 0
	.dw 0x6d40, 0xc10c,	0x6d7f, 0xc10c,		0x21, 0
	.dw 0x6dc0, 0xc10c,	0x6dff, 0xc10c,		0x21, 0
	.dw 0x6e40, 0xc10c,	0x6e7f, 0xc10c,		0x21, 0
	.dw 0x6ec0, 0xc10c,	0x6eff, 0xc10c,		0x21, 0
	.dw 0x6f40, 0xc10c,	0x6f7f, 0xc10c,		0x21, 0
	.dw 0x6fc0, 0xc10c,	0x6fff, 0xc10c,		0x21, 0
	.dw 0x7040, 0xc10c,	0x707f, 0xc10c,		0x21, 0
	.dw 0x70c0, 0xc10c,	0x70ff, 0xc10c,		0x21, 0
	.dw 0x7140, 0xc10c,	0x717f, 0xc10c,		0x21, 0
	.dw 0x71c0, 0xc10c,	0x71ff, 0xc10c,		0x21, 0
	.dw 0x7240, 0xc10c,	0x727f, 0xc10c,		0x21, 0
	.dw 0x72c0, 0xc10c,	0x72ff, 0xc10c,		0x21, 0
	.dw 0x7340, 0xc10c,	0x737f, 0xc10c,		0x21, 0
	.dw 0x73c0, 0xc10c,	0x73ff, 0xc10c,		0x21, 0
	.dw 0x7440, 0xc10c,	0x747f, 0xc10c,		0x21, 0
	.dw 0x74c0, 0xc10c,	0x74ff, 0xc10c,		0x21, 0
	.dw 0x7540, 0xc10c,	0x757f, 0xc10c,		0x21, 0
	.dw 0x75c0, 0xc10c,	0x75ff, 0xc10c,		0x21, 0
	.dw 0x7640, 0xc10c,	0x767f, 0xc10c,		0x21, 0
	.dw 0x76c0, 0xc10c,	0x76ff, 0xc10c,		0x21, 0
	.dw 0x7740, 0xc10c,	0x777f, 0xc10c,		0x21, 0
	.dw 0x77c0, 0xc10c,	0x77ff, 0xc10c,		0x21, 0
	.dw 0x7840, 0xc10c,	0x787f, 0xc10c,		0x21, 0
	.dw 0x78c0, 0xc10c,	0x78ff, 0xc10c,		0x21, 0
	.dw 0x7940, 0xc10c,	0x797f, 0xc10c,		0x21, 0
	.dw 0x79c0, 0xc10c,	0x7fff, 0xc10c,		0x21, 0
	.dw 0x8040, 0xc10c,	0x807f, 0xc10c,		0x21, 0
	.dw 0x80c0, 0xc10c,	0x80ff, 0xc10c,		0x21, 0
	.dw 0x8140, 0xc10c,	0x817f, 0xc10c,		0x21, 0
	.dw 0x81c0, 0xc10c,	0x81ff, 0xc10c,		0x21, 0
	.dw 0x8240, 0xc10c,	0x827f, 0xc10c,		0x21, 0
	.dw 0x82c0, 0xc10c,	0x82ff, 0xc10c,		0x21, 0
	.dw 0x8340, 0xc10c,	0x837f, 0xc10c,		0x21, 0
	.dw 0x83c0, 0xc10c,	0x83ff, 0xc10c,		0x21, 0
	.dw 0x8440, 0xc10c,	0x847f, 0xc10c,		0x21, 0
	.dw 0x84c0, 0xc10c,	0x84ff, 0xc10c,		0x21, 0
	.dw 0x8540, 0xc10c,	0x857f, 0xc10c,		0x21, 0
	.dw 0x85c0, 0xc10c,	0x85ff, 0xc10c,		0x21, 0
	.dw 0x8640, 0xc10c,	0x867f, 0xc10c,		0x21, 0
	.dw 0x86c0, 0xc10c,	0x86ff, 0xc10c,		0x21, 0
	.dw 0x8740, 0xc10c,	0x877f, 0xc10c,		0x21, 0
	.dw 0x87c0, 0xc10c,	0x87ff, 0xc10c,		0x21, 0
	.dw 0x8840, 0xc10c,	0x887f, 0xc10c,		0x21, 0
	.dw 0x88c0, 0xc10c,	0x88ff, 0xc10c,		0x21, 0
	.dw 0x8940, 0xc10c,	0x897f, 0xc10c,		0x21, 0
	.dw 0x89c0, 0xc10c,	0x89ff, 0xc10c,		0x21, 0
	.dw 0x8a40, 0xc10c,	0x8a7f, 0xc10c,		0x21, 0
	.dw 0x8ac0, 0xc10c,	0x8aff, 0xc10c,		0x21, 0
	.dw 0x8b40, 0xc10c,	0x8b7f, 0xc10c,		0x21, 0
	.dw 0x8bc0, 0xc10c,	0x8bff, 0xc10c,		0x21, 0
	.dw 0x8c40, 0xc10c,	0x8c7f, 0xc10c,		0x21, 0
	.dw 0x8cc0, 0xc10c,	0x8cff, 0xc10c,		0x21, 0
	.dw 0x8d40, 0xc10c,	0x8d7f, 0xc10c,		0x21, 0
	.dw 0x8dc0, 0xc10c,	0x8dff, 0xc10c,		0x21, 0
	.dw 0x8e40, 0xc10c,	0x8e7f, 0xc10c,		0x21, 0
	.dw 0x8ec0, 0xc10c,	0x8eff, 0xc10c,		0x21, 0
	.dw 0x8f40, 0xc10c,	0x8f7f, 0xc10c,		0x21, 0
	.dw 0x8fc0, 0xc10c,	0x8fff, 0xc10c,		0x21, 0
	.dw 0x9040, 0xc10c,	0x907f, 0xc10c,		0x21, 0
	.dw 0x90c0, 0xc10c,	0x90ff, 0xc10c,		0x21, 0
	.dw 0x9140, 0xc10c,	0x917f, 0xc10c,		0x21, 0
	.dw 0x91c0, 0xc10c,	0x91ff, 0xc10c,		0x21, 0
	.dw 0x9240, 0xc10c,	0x927f, 0xc10c,		0x21, 0
	.dw 0x92c0, 0xc10c,	0x92ff, 0xc10c,		0x21, 0
	.dw 0x9340, 0xc10c,	0x937f, 0xc10c,		0x21, 0
	.dw 0x93c0, 0xc10c,	0x93ff, 0xc10c,		0x21, 0
	.dw 0x9440, 0xc10c,	0x947f, 0xc10c,		0x21, 0
	.dw 0x94c0, 0xc10c,	0x94ff, 0xc10c,		0x21, 0
	.dw 0x9540, 0xc10c,	0x957f, 0xc10c,		0x21, 0
	.dw 0x95c0, 0xc10c,	0x95ff, 0xc10c,		0x21, 0
	.dw 0x9640, 0xc10c,	0x967f, 0xc10c,		0x21, 0
	.dw 0x96c0, 0xc10c,	0x96ff, 0xc10c,		0x21, 0
	.dw 0x9740, 0xc10c,	0x977f, 0xc10c,		0x21, 0
	.dw 0x97c0, 0xc10c,	0x97ff, 0xc10c,		0x21, 0
	.dw 0x9840, 0xc10c,	0x987f, 0xc10c,		0x21, 0
	.dw 0x98c0, 0xc10c,	0x98ff, 0xc10c,		0x21, 0
	.dw 0x9940, 0xc10c,	0x997f, 0xc10c,		0x21, 0
	.dw 0x99c0, 0xc10c,	0x9fff, 0xc10c,		0x21, 0
	.dw 0xa040, 0xc10c,	0xa07f, 0xc10c,		0x21, 0
	.dw 0xa0c0, 0xc10c,	0xa0ff, 0xc10c,		0x21, 0
	.dw 0xa140, 0xc10c,	0xa17f, 0xc10c,		0x21, 0
	.dw 0xa1c0, 0xc10c,	0xa1ff, 0xc10c,		0x21, 0
	.dw 0xa240, 0xc10c,	0xa27f, 0xc10c,		0x21, 0
	.dw 0xa2c0, 0xc10c,	0xa2ff, 0xc10c,		0x21, 0
	.dw 0xa340, 0xc10c,	0xa37f, 0xc10c,		0x21, 0
	.dw 0xa3c0, 0xc10c,	0xa3ff, 0xc10c,		0x21, 0
	.dw 0xa440, 0xc10c,	0xa47f, 0xc10c,		0x21, 0
	.dw 0xa4c0, 0xc10c,	0xa4ff, 0xc10c,		0x21, 0
	.dw 0xa540, 0xc10c,	0xa57f, 0xc10c,		0x21, 0
	.dw 0xa5c0, 0xc10c,	0xa5ff, 0xc10c,		0x21, 0
	.dw 0xa640, 0xc10c,	0xa67f, 0xc10c,		0x21, 0
	.dw 0xa6c0, 0xc10c,	0xa6ff, 0xc10c,		0x21, 0
	.dw 0xa740, 0xc10c,	0xa77f, 0xc10c,		0x21, 0
	.dw 0xa7c0, 0xc10c,	0xa7ff, 0xc10c,		0x21, 0
	.dw 0xa840, 0xc10c,	0xa87f, 0xc10c,		0x21, 0
	.dw 0xa8c0, 0xc10c,	0xa8ff, 0xc10c,		0x21, 0
	.dw 0xa940, 0xc10c,	0xa97f, 0xc10c,		0x21, 0
	.dw 0xa9c0, 0xc10c,	0xa9ff, 0xc10c,		0x21, 0
	.dw 0xaa40, 0xc10c,	0xaa7f, 0xc10c,		0x21, 0
	.dw 0xaac0, 0xc10c,	0xaaff, 0xc10c,		0x21, 0
	.dw 0xab40, 0xc10c,	0xab7f, 0xc10c,		0x21, 0
	.dw 0xabc0, 0xc10c,	0xabff, 0xc10c,		0x21, 0
	.dw 0xac40, 0xc10c,	0xac7f, 0xc10c,		0x21, 0
	.dw 0xacc0, 0xc10c,	0xacff, 0xc10c,		0x21, 0
	.dw 0xad40, 0xc10c,	0xad7f, 0xc10c,		0x21, 0
	.dw 0xadc0, 0xc10c,	0xadff, 0xc10c,		0x21, 0
	.dw 0xae40, 0xc10c,	0xae7f, 0xc10c,		0x21, 0
	.dw 0xaec0, 0xc10c,	0xaeff, 0xc10c,		0x21, 0
	.dw 0xaf40, 0xc10c,	0xaf7f, 0xc10c,		0x21, 0
	.dw 0xafc0, 0xc10c,	0xafff, 0xc10c,		0x21, 0
	.dw 0xb040, 0xc10c,	0xb07f, 0xc10c,		0x21, 0
	.dw 0xb0c0, 0xc10c,	0xb0ff, 0xc10c,		0x21, 0
	.dw 0xb140, 0xc10c,	0xb17f, 0xc10c,		0x21, 0
	.dw 0xb1c0, 0xc10c,	0xb1ff, 0xc10c,		0x21, 0
	.dw 0xb240, 0xc10c,	0xb27f, 0xc10c,		0x21, 0
	.dw 0xb2c0, 0xc10c,	0xb2ff, 0xc10c,		0x21, 0
	.dw 0xb340, 0xc10c,	0xb37f, 0xc10c,		0x21, 0
	.dw 0xb3c0, 0xc10c,	0xb3ff, 0xc10c,		0x21, 0
	.dw 0xb440, 0xc10c,	0xb47f, 0xc10c,		0x21, 0
	.dw 0xb4c0, 0xc10c,	0xb4ff, 0xc10c,		0x21, 0
	.dw 0xb540, 0xc10c,	0xb57f, 0xc10c,		0x21, 0
	.dw 0xb5c0, 0xc10c,	0xb5ff, 0xc10c,		0x21, 0
	.dw 0xb640, 0xc10c,	0xb67f, 0xc10c,		0x21, 0
	.dw 0xb6c0, 0xc10c,	0xb6ff, 0xc10c,		0x21, 0
	.dw 0xb740, 0xc10c,	0xb77f, 0xc10c,		0x21, 0
	.dw 0xb7c0, 0xc10c,	0xb7ff, 0xc10c,		0x21, 0
	.dw 0xb840, 0xc10c,	0xb87f, 0xc10c,		0x21, 0
	.dw 0xb8c0, 0xc10c,	0xb8ff, 0xc10c,		0x21, 0
	.dw 0xb940, 0xc10c,	0xb97f, 0xc10c,		0x21, 0
	.dw 0xb9c0, 0xc10c,	0xbfff, 0xc10c,		0x21, 0
	.dw 0xc040, 0xc10c,	0xc07f, 0xc10c,		0x21, 0
	.dw 0xc0c0, 0xc10c,	0xc0ff, 0xc10c,		0x21, 0
	.dw 0xc140, 0xc10c,	0xc17f, 0xc10c,		0x21, 0
	.dw 0xc1c0, 0xc10c,	0xc1ff, 0xc10c,		0x21, 0
	.dw 0xc240, 0xc10c,	0xc27f, 0xc10c,		0x21, 0
	.dw 0xc2c0, 0xc10c,	0xc2ff, 0xc10c,		0x21, 0
	.dw 0xc340, 0xc10c,	0xc37f, 0xc10c,		0x21, 0
	.dw 0xc3c0, 0xc10c,	0xc3ff, 0xc10c,		0x21, 0
	.dw 0xc440, 0xc10c,	0xc47f, 0xc10c,		0x21, 0
	.dw 0xc4c0, 0xc10c,	0xc4ff, 0xc10c,		0x21, 0
	.dw 0xc540, 0xc10c,	0xc57f, 0xc10c,		0x21, 0
	.dw 0xc5c0, 0xc10c,	0xc5ff, 0xc10c,		0x21, 0
	.dw 0xc640, 0xc10c,	0xc67f, 0xc10c,		0x21, 0
	.dw 0xc6c0, 0xc10c,	0xc6ff, 0xc10c,		0x21, 0
	.dw 0xc740, 0xc10c,	0xc77f, 0xc10c,		0x21, 0
	.dw 0xc7c0, 0xc10c,	0xc7ff, 0xc10c,		0x21, 0
	.dw 0xc840, 0xc10c,	0xc87f, 0xc10c,		0x21, 0
	.dw 0xc8c0, 0xc10c,	0xc8ff, 0xc10c,		0x21, 0
	.dw 0xc940, 0xc10c,	0xc97f, 0xc10c,		0x21, 0
	.dw 0xc9c0, 0xc10c,	0xc9ff, 0xc10c,		0x21, 0
	.dw 0xca40, 0xc10c,	0xca7f, 0xc10c,		0x21, 0
	.dw 0xcac0, 0xc10c,	0xcaff, 0xc10c,		0x21, 0
	.dw 0xcb40, 0xc10c,	0xcb7f, 0xc10c,		0x21, 0
	.dw 0xcbc0, 0xc10c,	0xcbff, 0xc10c,		0x21, 0
	.dw 0xcc40, 0xc10c,	0xcc7f, 0xc10c,		0x21, 0
	.dw 0xccc0, 0xc10c,	0xccff, 0xc10c,		0x21, 0
	.dw 0xcd40, 0xc10c,	0xcd7f, 0xc10c,		0x21, 0
	.dw 0xcdc0, 0xc10c,	0xcdff, 0xc10c,		0x21, 0
	.dw 0xce40, 0xc10c,	0xce7f, 0xc10c,		0x21, 0
	.dw 0xcec0, 0xc10c,	0xceff, 0xc10c,		0x21, 0
	.dw 0xcf40, 0xc10c,	0xcf7f, 0xc10c,		0x21, 0
	.dw 0xcfc0, 0xc10c,	0xcfff, 0xc10c,		0x21, 0
	.dw 0xd040, 0xc10c,	0xd07f, 0xc10c,		0x21, 0
	.dw 0xd0c0, 0xc10c,	0xd0ff, 0xc10c,		0x21, 0
	.dw 0xd140, 0xc10c,	0xd17f, 0xc10c,		0x21, 0
	.dw 0xd1c0, 0xc10c,	0xd1ff, 0xc10c,		0x21, 0
	.dw 0xd240, 0xc10c,	0xd27f, 0xc10c,		0x21, 0
	.dw 0xd2c0, 0xc10c,	0xd2ff, 0xc10c,		0x21, 0
	.dw 0xd340, 0xc10c,	0xd37f, 0xc10c,		0x21, 0
	.dw 0xd3c0, 0xc10c,	0xd3ff, 0xc10c,		0x21, 0
	.dw 0xd440, 0xc10c,	0xd47f, 0xc10c,		0x21, 0
	.dw 0xd4c0, 0xc10c,	0xd4ff, 0xc10c,		0x21, 0
	.dw 0xd540, 0xc10c,	0xd57f, 0xc10c,		0x21, 0
	.dw 0xd5c0, 0xc10c,	0xd5ff, 0xc10c,		0x21, 0
	.dw 0xd640, 0xc10c,	0xd67f, 0xc10c,		0x21, 0
	.dw 0xd6c0, 0xc10c,	0xd6ff, 0xc10c,		0x21, 0
	.dw 0xd740, 0xc10c,	0xd77f, 0xc10c,		0x21, 0
	.dw 0xd7c0, 0xc10c,	0xd7ff, 0xc10c,		0x21, 0
	.dw 0xd840, 0xc10c,	0xd87f, 0xc10c,		0x21, 0
	.dw 0xd8c0, 0xc10c,	0xd8ff, 0xc10c,		0x21, 0
	.dw 0xd940, 0xc10c,	0xd97f, 0xc10c,		0x21, 0
	.dw 0xd9c0, 0xc10c,	0xdfff, 0xc10c,		0x21, 0
	.dw 0xe040, 0xc10c,	0xe07f, 0xc10c,		0x21, 0
	.dw 0xe0c0, 0xc10c,	0xe0ff, 0xc10c,		0x21, 0
	.dw 0xe140, 0xc10c,	0xe17f, 0xc10c,		0x21, 0
	.dw 0xe1c0, 0xc10c,	0xe1ff, 0xc10c,		0x21, 0
	.dw 0xe240, 0xc10c,	0xe27f, 0xc10c,		0x21, 0
	.dw 0xe2c0, 0xc10c,	0xe2ff, 0xc10c,		0x21, 0
	.dw 0xe340, 0xc10c,	0xe37f, 0xc10c,		0x21, 0
	.dw 0xe3c0, 0xc10c,	0xe3ff, 0xc10c,		0x21, 0
	.dw 0xe440, 0xc10c,	0xe47f, 0xc10c,		0x21, 0
	.dw 0xe4c0, 0xc10c,	0xe4ff, 0xc10c,		0x21, 0
	.dw 0xe540, 0xc10c,	0xe57f, 0xc10c,		0x21, 0
	.dw 0xe5c0, 0xc10c,	0xe5ff, 0xc10c,		0x21, 0
	.dw 0xe640, 0xc10c,	0xe67f, 0xc10c,		0x21, 0
	.dw 0xe6c0, 0xc10c,	0xe6ff, 0xc10c,		0x21, 0
	.dw 0xe740, 0xc10c,	0xe77f, 0xc10c,		0x21, 0
	.dw 0xe7c0, 0xc10c,	0xe7ff, 0xc10c,		0x21, 0
	.dw 0xe840, 0xc10c,	0xe87f, 0xc10c,		0x21, 0
	.dw 0xe8c0, 0xc10c,	0xe8ff, 0xc10c,		0x21, 0
	.dw 0xe940, 0xc10c,	0xe97f, 0xc10c,		0x21, 0
	.dw 0xe9c0, 0xc10c,	0xe9ff, 0xc10c,		0x21, 0
	.dw 0xea40, 0xc10c,	0xea7f, 0xc10c,		0x21, 0
	.dw 0xeac0, 0xc10c,	0xeaff, 0xc10c,		0x21, 0
	.dw 0xeb40, 0xc10c,	0xeb7f, 0xc10c,		0x21, 0
	.dw 0xebc0, 0xc10c,	0xebff, 0xc10c,		0x21, 0
	.dw 0xec40, 0xc10c,	0xec7f, 0xc10c,		0x21, 0
	.dw 0xecc0, 0xc10c,	0xecff, 0xc10c,		0x21, 0
	.dw 0xed40, 0xc10c,	0xed7f, 0xc10c,		0x21, 0
	.dw 0xedc0, 0xc10c,	0xedff, 0xc10c,		0x21, 0
	.dw 0xee40, 0xc10c,	0xee7f, 0xc10c,		0x21, 0
	.dw 0xeec0, 0xc10c,	0xeeff, 0xc10c,		0x21, 0
	.dw 0xef40, 0xc10c,	0xef7f, 0xc10c,		0x21, 0
	.dw 0xefc0, 0xc10c,	0xefff, 0xc10c,		0x21, 0
	.dw 0xf040, 0xc10c,	0xf07f, 0xc10c,		0x21, 0
	.dw 0xf0c0, 0xc10c,	0xf0ff, 0xc10c,		0x21, 0
	.dw 0xf140, 0xc10c,	0xf17f, 0xc10c,		0x21, 0
	.dw 0xf1c0, 0xc10c,	0xf1ff, 0xc10c,		0x21, 0
	.dw 0xf240, 0xc10c,	0xf27f, 0xc10c,		0x21, 0
	.dw 0xf2c0, 0xc10c,	0xf2ff, 0xc10c,		0x21, 0
	.dw 0xf340, 0xc10c,	0xf37f, 0xc10c,		0x21, 0
	.dw 0xf3c0, 0xc10c,	0xf3ff, 0xc10c,		0x21, 0
	.dw 0xf440, 0xc10c,	0xf47f, 0xc10c,		0x21, 0
	.dw 0xf4c0, 0xc10c,	0xf4ff, 0xc10c,		0x21, 0
	.dw 0xf540, 0xc10c,	0xf57f, 0xc10c,		0x21, 0
	.dw 0xf5c0, 0xc10c,	0xf5ff, 0xc10c,		0x21, 0
	.dw 0xf640, 0xc10c,	0xf67f, 0xc10c,		0x21, 0
	.dw 0xf6c0, 0xc10c,	0xf6ff, 0xc10c,		0x21, 0
	.dw 0xf740, 0xc10c,	0xf77f, 0xc10c,		0x21, 0
	.dw 0xf7c0, 0xc10c,	0xf7ff, 0xc10c,		0x21, 0
	.dw 0xf840, 0xc10c,	0xf87f, 0xc10c,		0x21, 0
	.dw 0xf8c0, 0xc10c,	0xf8ff, 0xc10c,		0x21, 0
	.dw 0xf940, 0xc10c,	0xf97f, 0xc10c,		0x21, 0
	.dw 0xf9c0, 0xc10c,	0xffff, 0xc10c,		0x21, 0
	.dw 0x0040, 0xc10d,	0x007f, 0xc10d,		0x21, 0
	.dw 0x00c0, 0xc10d,	0x00ff, 0xc10d,		0x21, 0
	.dw 0x0140, 0xc10d,	0x017f, 0xc10d,		0x21, 0
	.dw 0x01c0, 0xc10d,	0x01ff, 0xc10d,		0x21, 0
	.dw 0x0240, 0xc10d,	0x027f, 0xc10d,		0x21, 0
	.dw 0x02c0, 0xc10d,	0x02ff, 0xc10d,		0x21, 0
	.dw 0x0340, 0xc10d,	0x037f, 0xc10d,		0x21, 0
	.dw 0x03c0, 0xc10d,	0x03ff, 0xc10d,		0x21, 0
	.dw 0x0440, 0xc10d,	0x047f, 0xc10d,		0x21, 0
	.dw 0x04c0, 0xc10d,	0x04ff, 0xc10d,		0x21, 0
	.dw 0x0540, 0xc10d,	0x057f, 0xc10d,		0x21, 0
	.dw 0x05c0, 0xc10d,	0x05ff, 0xc10d,		0x21, 0
	.dw 0x0640, 0xc10d,	0x067f, 0xc10d,		0x21, 0
	.dw 0x06c0, 0xc10d,	0x06ff, 0xc10d,		0x21, 0
	.dw 0x0740, 0xc10d,	0x077f, 0xc10d,		0x21, 0
	.dw 0x07c0, 0xc10d,	0x07ff, 0xc10d,		0x21, 0
	.dw 0x0840, 0xc10d,	0x087f, 0xc10d,		0x21, 0
	.dw 0x08c0, 0xc10d,	0x08ff, 0xc10d,		0x21, 0
	.dw 0x0940, 0xc10d,	0x097f, 0xc10d,		0x21, 0
	.dw 0x09c0, 0xc10d,	0x09ff, 0xc10d,		0x21, 0
	.dw 0x0a40, 0xc10d,	0x0a7f, 0xc10d,		0x21, 0
	.dw 0x0ac0, 0xc10d,	0x0aff, 0xc10d,		0x21, 0
	.dw 0x0b40, 0xc10d,	0x0b7f, 0xc10d,		0x21, 0
	.dw 0x0bc0, 0xc10d,	0x0bff, 0xc10d,		0x21, 0
	.dw 0x0c40, 0xc10d,	0x0c7f, 0xc10d,		0x21, 0
	.dw 0x0cc0, 0xc10d,	0x0cff, 0xc10d,		0x21, 0
	.dw 0x0d40, 0xc10d,	0x0d7f, 0xc10d,		0x21, 0
	.dw 0x0dc0, 0xc10d,	0x0dff, 0xc10d,		0x21, 0
	.dw 0x0e40, 0xc10d,	0x0e7f, 0xc10d,		0x21, 0
	.dw 0x0ec0, 0xc10d,	0x0eff, 0xc10d,		0x21, 0
	.dw 0x0f40, 0xc10d,	0x0f7f, 0xc10d,		0x21, 0
	.dw 0x0fc0, 0xc10d,	0x0fff, 0xc10d,		0x21, 0
	.dw 0x1040, 0xc10d,	0x107f, 0xc10d,		0x21, 0
	.dw 0x10c0, 0xc10d,	0x10ff, 0xc10d,		0x21, 0
	.dw 0x1140, 0xc10d,	0x117f, 0xc10d,		0x21, 0
	.dw 0x11c0, 0xc10d,	0x11ff, 0xc10d,		0x21, 0
	.dw 0x1240, 0xc10d,	0x127f, 0xc10d,		0x21, 0
	.dw 0x12c0, 0xc10d,	0x12ff, 0xc10d,		0x21, 0
	.dw 0x1340, 0xc10d,	0x137f, 0xc10d,		0x21, 0
	.dw 0x13c0, 0xc10d,	0x13ff, 0xc10d,		0x21, 0
	.dw 0x1440, 0xc10d,	0x147f, 0xc10d,		0x21, 0
	.dw 0x14c0, 0xc10d,	0x14ff, 0xc10d,		0x21, 0
	.dw 0x1540, 0xc10d,	0x157f, 0xc10d,		0x21, 0
	.dw 0x15c0, 0xc10d,	0x15ff, 0xc10d,		0x21, 0
	.dw 0x1640, 0xc10d,	0x167f, 0xc10d,		0x21, 0
	.dw 0x16c0, 0xc10d,	0x16ff, 0xc10d,		0x21, 0
	.dw 0x1740, 0xc10d,	0x177f, 0xc10d,		0x21, 0
	.dw 0x17c0, 0xc10d,	0x17ff, 0xc10d,		0x21, 0
	.dw 0x1840, 0xc10d,	0x187f, 0xc10d,		0x21, 0
	.dw 0x18c0, 0xc10d,	0x18ff, 0xc10d,		0x21, 0
	.dw 0x1940, 0xc10d,	0x197f, 0xc10d,		0x21, 0
	.dw 0x19c0, 0xc10d,	0x1fff, 0xc10d,		0x21, 0
	.dw 0x2040, 0xc10d,	0x207f, 0xc10d,		0x21, 0
	.dw 0x20c0, 0xc10d,	0x20ff, 0xc10d,		0x21, 0
	.dw 0x2140, 0xc10d,	0x217f, 0xc10d,		0x21, 0
	.dw 0x21c0, 0xc10d,	0x21ff, 0xc10d,		0x21, 0
	.dw 0x2240, 0xc10d,	0x227f, 0xc10d,		0x21, 0
	.dw 0x22c0, 0xc10d,	0x22ff, 0xc10d,		0x21, 0
	.dw 0x2340, 0xc10d,	0x237f, 0xc10d,		0x21, 0
	.dw 0x23c0, 0xc10d,	0x23ff, 0xc10d,		0x21, 0
	.dw 0x2440, 0xc10d,	0x247f, 0xc10d,		0x21, 0
	.dw 0x24c0, 0xc10d,	0x24ff, 0xc10d,		0x21, 0
	.dw 0x2540, 0xc10d,	0x257f, 0xc10d,		0x21, 0
	.dw 0x25c0, 0xc10d,	0x25ff, 0xc10d,		0x21, 0
	.dw 0x2640, 0xc10d,	0x267f, 0xc10d,		0x21, 0
	.dw 0x26c0, 0xc10d,	0x26ff, 0xc10d,		0x21, 0
	.dw 0x2740, 0xc10d,	0x277f, 0xc10d,		0x21, 0
	.dw 0x27c0, 0xc10d,	0x27ff, 0xc10d,		0x21, 0
	.dw 0x2840, 0xc10d,	0x287f, 0xc10d,		0x21, 0
	.dw 0x28c0, 0xc10d,	0x28ff, 0xc10d,		0x21, 0
	.dw 0x2940, 0xc10d,	0x297f, 0xc10d,		0x21, 0
	.dw 0x29c0, 0xc10d,	0x29ff, 0xc10d,		0x21, 0
	.dw 0x2a40, 0xc10d,	0x2a7f, 0xc10d,		0x21, 0
	.dw 0x2ac0, 0xc10d,	0x2aff, 0xc10d,		0x21, 0
	.dw 0x2b40, 0xc10d,	0x2b7f, 0xc10d,		0x21, 0
	.dw 0x2bc0, 0xc10d,	0x2bff, 0xc10d,		0x21, 0
	.dw 0x2c40, 0xc10d,	0x2c7f, 0xc10d,		0x21, 0
	.dw 0x2cc0, 0xc10d,	0x2cff, 0xc10d,		0x21, 0
	.dw 0x2d40, 0xc10d,	0x2d7f, 0xc10d,		0x21, 0
	.dw 0x2dc0, 0xc10d,	0x2dff, 0xc10d,		0x21, 0
	.dw 0x2e40, 0xc10d,	0x2e7f, 0xc10d,		0x21, 0
	.dw 0x2ec0, 0xc10d,	0x2eff, 0xc10d,		0x21, 0
	.dw 0x2f40, 0xc10d,	0x2f7f, 0xc10d,		0x21, 0
	.dw 0x2fc0, 0xc10d,	0x2fff, 0xc10d,		0x21, 0
	.dw 0x3040, 0xc10d,	0x307f, 0xc10d,		0x21, 0
	.dw 0x30c0, 0xc10d,	0x30ff, 0xc10d,		0x21, 0
	.dw 0x3140, 0xc10d,	0x317f, 0xc10d,		0x21, 0
	.dw 0x31c0, 0xc10d,	0x31ff, 0xc10d,		0x21, 0
	.dw 0x3240, 0xc10d,	0x327f, 0xc10d,		0x21, 0
	.dw 0x32c0, 0xc10d,	0x32ff, 0xc10d,		0x21, 0
	.dw 0x3340, 0xc10d,	0x337f, 0xc10d,		0x21, 0
	.dw 0x33c0, 0xc10d,	0x33ff, 0xc10d,		0x21, 0
	.dw 0x3440, 0xc10d,	0x347f, 0xc10d,		0x21, 0
	.dw 0x34c0, 0xc10d,	0x34ff, 0xc10d,		0x21, 0
	.dw 0x3540, 0xc10d,	0x357f, 0xc10d,		0x21, 0
	.dw 0x35c0, 0xc10d,	0x35ff, 0xc10d,		0x21, 0
	.dw 0x3640, 0xc10d,	0x367f, 0xc10d,		0x21, 0
	.dw 0x36c0, 0xc10d,	0x36ff, 0xc10d,		0x21, 0
	.dw 0x3740, 0xc10d,	0x377f, 0xc10d,		0x21, 0
	.dw 0x37c0, 0xc10d,	0x37ff, 0xc10d,		0x21, 0
	.dw 0x3840, 0xc10d,	0x387f, 0xc10d,		0x21, 0
	.dw 0x38c0, 0xc10d,	0x38ff, 0xc10d,		0x21, 0
	.dw 0x3940, 0xc10d,	0x397f, 0xc10d,		0x21, 0
	.dw 0x39c0, 0xc10d,	0x3fff, 0xc10d,		0x21, 0
	.dw 0x4040, 0xc10d,	0x407f, 0xc10d,		0x21, 0
	.dw 0x40c0, 0xc10d,	0x40ff, 0xc10d,		0x21, 0
	.dw 0x4140, 0xc10d,	0x417f, 0xc10d,		0x21, 0
	.dw 0x41c0, 0xc10d,	0x41ff, 0xc10d,		0x21, 0
	.dw 0x4240, 0xc10d,	0x427f, 0xc10d,		0x21, 0
	.dw 0x42c0, 0xc10d,	0x42ff, 0xc10d,		0x21, 0
	.dw 0x4340, 0xc10d,	0x437f, 0xc10d,		0x21, 0
	.dw 0x43c0, 0xc10d,	0x43ff, 0xc10d,		0x21, 0
	.dw 0x4440, 0xc10d,	0x447f, 0xc10d,		0x21, 0
	.dw 0x44c0, 0xc10d,	0x44ff, 0xc10d,		0x21, 0
	.dw 0x4540, 0xc10d,	0x457f, 0xc10d,		0x21, 0
	.dw 0x45c0, 0xc10d,	0x45ff, 0xc10d,		0x21, 0
	.dw 0x4640, 0xc10d,	0x467f, 0xc10d,		0x21, 0
	.dw 0x46c0, 0xc10d,	0x46ff, 0xc10d,		0x21, 0
	.dw 0x4740, 0xc10d,	0x477f, 0xc10d,		0x21, 0
	.dw 0x47c0, 0xc10d,	0x47ff, 0xc10d,		0x21, 0
	.dw 0x4840, 0xc10d,	0x487f, 0xc10d,		0x21, 0
	.dw 0x48c0, 0xc10d,	0x48ff, 0xc10d,		0x21, 0
	.dw 0x4940, 0xc10d,	0x497f, 0xc10d,		0x21, 0
	.dw 0x49c0, 0xc10d,	0x49ff, 0xc10d,		0x21, 0
	.dw 0x4a40, 0xc10d,	0x4a7f, 0xc10d,		0x21, 0
	.dw 0x4ac0, 0xc10d,	0x4aff, 0xc10d,		0x21, 0
	.dw 0x4b40, 0xc10d,	0x4b7f, 0xc10d,		0x21, 0
	.dw 0x4bc0, 0xc10d,	0x4bff, 0xc10d,		0x21, 0
	.dw 0x4c40, 0xc10d,	0x4c7f, 0xc10d,		0x21, 0
	.dw 0x4cc0, 0xc10d,	0x4cff, 0xc10d,		0x21, 0
	.dw 0x4d40, 0xc10d,	0x4d7f, 0xc10d,		0x21, 0
	.dw 0x4dc0, 0xc10d,	0x4dff, 0xc10d,		0x21, 0
	.dw 0x4e40, 0xc10d,	0x4e7f, 0xc10d,		0x21, 0
	.dw 0x4ec0, 0xc10d,	0x4eff, 0xc10d,		0x21, 0
	.dw 0x4f40, 0xc10d,	0x4f7f, 0xc10d,		0x21, 0
	.dw 0x4fc0, 0xc10d,	0x4fff, 0xc10d,		0x21, 0
	.dw 0x5040, 0xc10d,	0x507f, 0xc10d,		0x21, 0
	.dw 0x50c0, 0xc10d,	0x50ff, 0xc10d,		0x21, 0
	.dw 0x5140, 0xc10d,	0x517f, 0xc10d,		0x21, 0
	.dw 0x51c0, 0xc10d,	0x51ff, 0xc10d,		0x21, 0
	.dw 0x5240, 0xc10d,	0x527f, 0xc10d,		0x21, 0
	.dw 0x52c0, 0xc10d,	0x52ff, 0xc10d,		0x21, 0
	.dw 0x5340, 0xc10d,	0x537f, 0xc10d,		0x21, 0
	.dw 0x53c0, 0xc10d,	0x53ff, 0xc10d,		0x21, 0
	.dw 0x5440, 0xc10d,	0x547f, 0xc10d,		0x21, 0
	.dw 0x54c0, 0xc10d,	0x54ff, 0xc10d,		0x21, 0
	.dw 0x5540, 0xc10d,	0x557f, 0xc10d,		0x21, 0
	.dw 0x55c0, 0xc10d,	0x55ff, 0xc10d,		0x21, 0
	.dw 0x5640, 0xc10d,	0x567f, 0xc10d,		0x21, 0
	.dw 0x56c0, 0xc10d,	0x56ff, 0xc10d,		0x21, 0
	.dw 0x5740, 0xc10d,	0x577f, 0xc10d,		0x21, 0
	.dw 0x57c0, 0xc10d,	0x57ff, 0xc10d,		0x21, 0
	.dw 0x5840, 0xc10d,	0x587f, 0xc10d,		0x21, 0
	.dw 0x58c0, 0xc10d,	0x58ff, 0xc10d,		0x21, 0
	.dw 0x5940, 0xc10d,	0x597f, 0xc10d,		0x21, 0
	.dw 0x59c0, 0xc10d,	0x5fff, 0xc10d,		0x21, 0
	.dw 0x6040, 0xc10d,	0x607f, 0xc10d,		0x21, 0
	.dw 0x60c0, 0xc10d,	0x60ff, 0xc10d,		0x21, 0
	.dw 0x6140, 0xc10d,	0x617f, 0xc10d,		0x21, 0
	.dw 0x61c0, 0xc10d,	0x61ff, 0xc10d,		0x21, 0
	.dw 0x6240, 0xc10d,	0x627f, 0xc10d,		0x21, 0
	.dw 0x62c0, 0xc10d,	0x62ff, 0xc10d,		0x21, 0
	.dw 0x6340, 0xc10d,	0x637f, 0xc10d,		0x21, 0
	.dw 0x63c0, 0xc10d,	0x63ff, 0xc10d,		0x21, 0
	.dw 0x6440, 0xc10d,	0x647f, 0xc10d,		0x21, 0
	.dw 0x64c0, 0xc10d,	0x64ff, 0xc10d,		0x21, 0
	.dw 0x6540, 0xc10d,	0x657f, 0xc10d,		0x21, 0
	.dw 0x65c0, 0xc10d,	0x65ff, 0xc10d,		0x21, 0
	.dw 0x6640, 0xc10d,	0x667f, 0xc10d,		0x21, 0
	.dw 0x66c0, 0xc10d,	0x66ff, 0xc10d,		0x21, 0
	.dw 0x6740, 0xc10d,	0x677f, 0xc10d,		0x21, 0
	.dw 0x67c0, 0xc10d,	0x67ff, 0xc10d,		0x21, 0
	.dw 0x6840, 0xc10d,	0x687f, 0xc10d,		0x21, 0
	.dw 0x68c0, 0xc10d,	0x68ff, 0xc10d,		0x21, 0
	.dw 0x6940, 0xc10d,	0x697f, 0xc10d,		0x21, 0
	.dw 0x69c0, 0xc10d,	0x69ff, 0xc10d,		0x21, 0
	.dw 0x6a40, 0xc10d,	0x6a7f, 0xc10d,		0x21, 0
	.dw 0x6ac0, 0xc10d,	0x6aff, 0xc10d,		0x21, 0
	.dw 0x6b40, 0xc10d,	0x6b7f, 0xc10d,		0x21, 0
	.dw 0x6bc0, 0xc10d,	0x6bff, 0xc10d,		0x21, 0
	.dw 0x6c40, 0xc10d,	0x6c7f, 0xc10d,		0x21, 0
	.dw 0x6cc0, 0xc10d,	0x6cff, 0xc10d,		0x21, 0
	.dw 0x6d40, 0xc10d,	0x6d7f, 0xc10d,		0x21, 0
	.dw 0x6dc0, 0xc10d,	0x6dff, 0xc10d,		0x21, 0
	.dw 0x6e40, 0xc10d,	0x6e7f, 0xc10d,		0x21, 0
	.dw 0x6ec0, 0xc10d,	0x6eff, 0xc10d,		0x21, 0
	.dw 0x6f40, 0xc10d,	0x6f7f, 0xc10d,		0x21, 0
	.dw 0x6fc0, 0xc10d,	0x6fff, 0xc10d,		0x21, 0
	.dw 0x7040, 0xc10d,	0x707f, 0xc10d,		0x21, 0
	.dw 0x70c0, 0xc10d,	0x70ff, 0xc10d,		0x21, 0
	.dw 0x7140, 0xc10d,	0x717f, 0xc10d,		0x21, 0
	.dw 0x71c0, 0xc10d,	0x71ff, 0xc10d,		0x21, 0
	.dw 0x7240, 0xc10d,	0x727f, 0xc10d,		0x21, 0
	.dw 0x72c0, 0xc10d,	0x72ff, 0xc10d,		0x21, 0
	.dw 0x7340, 0xc10d,	0x737f, 0xc10d,		0x21, 0
	.dw 0x73c0, 0xc10d,	0x73ff, 0xc10d,		0x21, 0
	.dw 0x7440, 0xc10d,	0x747f, 0xc10d,		0x21, 0
	.dw 0x74c0, 0xc10d,	0x74ff, 0xc10d,		0x21, 0
	.dw 0x7540, 0xc10d,	0x757f, 0xc10d,		0x21, 0
	.dw 0x75c0, 0xc10d,	0x75ff, 0xc10d,		0x21, 0
	.dw 0x7640, 0xc10d,	0x767f, 0xc10d,		0x21, 0
	.dw 0x76c0, 0xc10d,	0x76ff, 0xc10d,		0x21, 0
	.dw 0x7740, 0xc10d,	0x777f, 0xc10d,		0x21, 0
	.dw 0x77c0, 0xc10d,	0x77ff, 0xc10d,		0x21, 0
	.dw 0x7840, 0xc10d,	0x787f, 0xc10d,		0x21, 0
	.dw 0x78c0, 0xc10d,	0x78ff, 0xc10d,		0x21, 0
	.dw 0x7940, 0xc10d,	0x797f, 0xc10d,		0x21, 0
	.dw 0x79c0, 0xc10d,	0x7fff, 0xc10d,		0x21, 0
	.dw 0x8040, 0xc10d,	0x807f, 0xc10d,		0x21, 0
	.dw 0x80c0, 0xc10d,	0x80ff, 0xc10d,		0x21, 0
	.dw 0x8140, 0xc10d,	0x817f, 0xc10d,		0x21, 0
	.dw 0x81c0, 0xc10d,	0x81ff, 0xc10d,		0x21, 0
	.dw 0x8240, 0xc10d,	0x827f, 0xc10d,		0x21, 0
	.dw 0x82c0, 0xc10d,	0x82ff, 0xc10d,		0x21, 0
	.dw 0x8340, 0xc10d,	0x837f, 0xc10d,		0x21, 0
	.dw 0x83c0, 0xc10d,	0x83ff, 0xc10d,		0x21, 0
	.dw 0x8440, 0xc10d,	0x847f, 0xc10d,		0x21, 0
	.dw 0x84c0, 0xc10d,	0x84ff, 0xc10d,		0x21, 0
	.dw 0x8540, 0xc10d,	0x857f, 0xc10d,		0x21, 0
	.dw 0x85c0, 0xc10d,	0x85ff, 0xc10d,		0x21, 0
	.dw 0x8640, 0xc10d,	0x867f, 0xc10d,		0x21, 0
	.dw 0x86c0, 0xc10d,	0x86ff, 0xc10d,		0x21, 0
	.dw 0x8740, 0xc10d,	0x877f, 0xc10d,		0x21, 0
	.dw 0x87c0, 0xc10d,	0x87ff, 0xc10d,		0x21, 0
	.dw 0x8840, 0xc10d,	0x887f, 0xc10d,		0x21, 0
	.dw 0x88c0, 0xc10d,	0x88ff, 0xc10d,		0x21, 0
	.dw 0x8940, 0xc10d,	0x897f, 0xc10d,		0x21, 0
	.dw 0x89c0, 0xc10d,	0x89ff, 0xc10d,		0x21, 0
	.dw 0x8a40, 0xc10d,	0x8a7f, 0xc10d,		0x21, 0
	.dw 0x8ac0, 0xc10d,	0x8aff, 0xc10d,		0x21, 0
	.dw 0x8b40, 0xc10d,	0x8b7f, 0xc10d,		0x21, 0
	.dw 0x8bc0, 0xc10d,	0x8bff, 0xc10d,		0x21, 0
	.dw 0x8c40, 0xc10d,	0x8c7f, 0xc10d,		0x21, 0
	.dw 0x8cc0, 0xc10d,	0x8cff, 0xc10d,		0x21, 0
	.dw 0x8d40, 0xc10d,	0x8d7f, 0xc10d,		0x21, 0
	.dw 0x8dc0, 0xc10d,	0x8dff, 0xc10d,		0x21, 0
	.dw 0x8e40, 0xc10d,	0x8e7f, 0xc10d,		0x21, 0
	.dw 0x8ec0, 0xc10d,	0x8eff, 0xc10d,		0x21, 0
	.dw 0x8f40, 0xc10d,	0x8f7f, 0xc10d,		0x21, 0
	.dw 0x8fc0, 0xc10d,	0x8fff, 0xc10d,		0x21, 0
	.dw 0x9040, 0xc10d,	0x907f, 0xc10d,		0x21, 0
	.dw 0x90c0, 0xc10d,	0x90ff, 0xc10d,		0x21, 0
	.dw 0x9140, 0xc10d,	0x917f, 0xc10d,		0x21, 0
	.dw 0x91c0, 0xc10d,	0x91ff, 0xc10d,		0x21, 0
	.dw 0x9240, 0xc10d,	0x927f, 0xc10d,		0x21, 0
	.dw 0x92c0, 0xc10d,	0x92ff, 0xc10d,		0x21, 0
	.dw 0x9340, 0xc10d,	0x937f, 0xc10d,		0x21, 0
	.dw 0x93c0, 0xc10d,	0x93ff, 0xc10d,		0x21, 0
	.dw 0x9440, 0xc10d,	0x947f, 0xc10d,		0x21, 0
	.dw 0x94c0, 0xc10d,	0x94ff, 0xc10d,		0x21, 0
	.dw 0x9540, 0xc10d,	0x957f, 0xc10d,		0x21, 0
	.dw 0x95c0, 0xc10d,	0x95ff, 0xc10d,		0x21, 0
	.dw 0x9640, 0xc10d,	0x967f, 0xc10d,		0x21, 0
	.dw 0x96c0, 0xc10d,	0x96ff, 0xc10d,		0x21, 0
	.dw 0x9740, 0xc10d,	0x977f, 0xc10d,		0x21, 0
	.dw 0x97c0, 0xc10d,	0x97ff, 0xc10d,		0x21, 0
	.dw 0x9840, 0xc10d,	0x987f, 0xc10d,		0x21, 0
	.dw 0x98c0, 0xc10d,	0x98ff, 0xc10d,		0x21, 0
	.dw 0x9940, 0xc10d,	0x997f, 0xc10d,		0x21, 0
	.dw 0x99c0, 0xc10d,	0x9fff, 0xc10d,		0x21, 0
	.dw 0xa040, 0xc10d,	0xa07f, 0xc10d,		0x21, 0
	.dw 0xa0c0, 0xc10d,	0xa0ff, 0xc10d,		0x21, 0
	.dw 0xa140, 0xc10d,	0xa17f, 0xc10d,		0x21, 0
	.dw 0xa1c0, 0xc10d,	0xa1ff, 0xc10d,		0x21, 0
	.dw 0xa240, 0xc10d,	0xa27f, 0xc10d,		0x21, 0
	.dw 0xa2c0, 0xc10d,	0xa2ff, 0xc10d,		0x21, 0
	.dw 0xa340, 0xc10d,	0xa37f, 0xc10d,		0x21, 0
	.dw 0xa3c0, 0xc10d,	0xa3ff, 0xc10d,		0x21, 0
	.dw 0xa440, 0xc10d,	0xa47f, 0xc10d,		0x21, 0
	.dw 0xa4c0, 0xc10d,	0xa4ff, 0xc10d,		0x21, 0
	.dw 0xa540, 0xc10d,	0xa57f, 0xc10d,		0x21, 0
	.dw 0xa5c0, 0xc10d,	0xa5ff, 0xc10d,		0x21, 0
	.dw 0xa640, 0xc10d,	0xa67f, 0xc10d,		0x21, 0
	.dw 0xa6c0, 0xc10d,	0xa6ff, 0xc10d,		0x21, 0
	.dw 0xa740, 0xc10d,	0xa77f, 0xc10d,		0x21, 0
	.dw 0xa7c0, 0xc10d,	0xa7ff, 0xc10d,		0x21, 0
	.dw 0xa840, 0xc10d,	0xa87f, 0xc10d,		0x21, 0
	.dw 0xa8c0, 0xc10d,	0xa8ff, 0xc10d,		0x21, 0
	.dw 0xa940, 0xc10d,	0xa97f, 0xc10d,		0x21, 0
	.dw 0xa9c0, 0xc10d,	0xa9ff, 0xc10d,		0x21, 0
	.dw 0xaa40, 0xc10d,	0xaa7f, 0xc10d,		0x21, 0
	.dw 0xaac0, 0xc10d,	0xaaff, 0xc10d,		0x21, 0
	.dw 0xab40, 0xc10d,	0xab7f, 0xc10d,		0x21, 0
	.dw 0xabc0, 0xc10d,	0xabff, 0xc10d,		0x21, 0
	.dw 0xac40, 0xc10d,	0xac7f, 0xc10d,		0x21, 0
	.dw 0xacc0, 0xc10d,	0xacff, 0xc10d,		0x21, 0
	.dw 0xad40, 0xc10d,	0xad7f, 0xc10d,		0x21, 0
	.dw 0xadc0, 0xc10d,	0xadff, 0xc10d,		0x21, 0
	.dw 0xae40, 0xc10d,	0xae7f, 0xc10d,		0x21, 0
	.dw 0xaec0, 0xc10d,	0xaeff, 0xc10d,		0x21, 0
	.dw 0xaf40, 0xc10d,	0xaf7f, 0xc10d,		0x21, 0
	.dw 0xafc0, 0xc10d,	0xafff, 0xc10d,		0x21, 0
	.dw 0xb040, 0xc10d,	0xb07f, 0xc10d,		0x21, 0
	.dw 0xb0c0, 0xc10d,	0xb0ff, 0xc10d,		0x21, 0
	.dw 0xb140, 0xc10d,	0xb17f, 0xc10d,		0x21, 0
	.dw 0xb1c0, 0xc10d,	0xb1ff, 0xc10d,		0x21, 0
	.dw 0xb240, 0xc10d,	0xb27f, 0xc10d,		0x21, 0
	.dw 0xb2c0, 0xc10d,	0xb2ff, 0xc10d,		0x21, 0
	.dw 0xb340, 0xc10d,	0xb37f, 0xc10d,		0x21, 0
	.dw 0xb3c0, 0xc10d,	0xb3ff, 0xc10d,		0x21, 0
	.dw 0xb440, 0xc10d,	0xb47f, 0xc10d,		0x21, 0
	.dw 0xb4c0, 0xc10d,	0xb4ff, 0xc10d,		0x21, 0
	.dw 0xb540, 0xc10d,	0xb57f, 0xc10d,		0x21, 0
	.dw 0xb5c0, 0xc10d,	0xb5ff, 0xc10d,		0x21, 0
	.dw 0xb640, 0xc10d,	0xb67f, 0xc10d,		0x21, 0
	.dw 0xb6c0, 0xc10d,	0xb6ff, 0xc10d,		0x21, 0
	.dw 0xb740, 0xc10d,	0xb77f, 0xc10d,		0x21, 0
	.dw 0xb7c0, 0xc10d,	0xb7ff, 0xc10d,		0x21, 0
	.dw 0xb840, 0xc10d,	0xb87f, 0xc10d,		0x21, 0
	.dw 0xb8c0, 0xc10d,	0xb8ff, 0xc10d,		0x21, 0
	.dw 0xb940, 0xc10d,	0xb97f, 0xc10d,		0x21, 0
	.dw 0xb9c0, 0xc10d,	0xbfff, 0xc10d,		0x21, 0
	.dw 0xc040, 0xc10d,	0xc07f, 0xc10d,		0x21, 0
	.dw 0xc0c0, 0xc10d,	0xc0ff, 0xc10d,		0x21, 0
	.dw 0xc140, 0xc10d,	0xc17f, 0xc10d,		0x21, 0
	.dw 0xc1c0, 0xc10d,	0xc1ff, 0xc10d,		0x21, 0
	.dw 0xc240, 0xc10d,	0xc27f, 0xc10d,		0x21, 0
	.dw 0xc2c0, 0xc10d,	0xc2ff, 0xc10d,		0x21, 0
	.dw 0xc340, 0xc10d,	0xc37f, 0xc10d,		0x21, 0
	.dw 0xc3c0, 0xc10d,	0xc3ff, 0xc10d,		0x21, 0
	.dw 0xc440, 0xc10d,	0xc47f, 0xc10d,		0x21, 0
	.dw 0xc4c0, 0xc10d,	0xc4ff, 0xc10d,		0x21, 0
	.dw 0xc540, 0xc10d,	0xc57f, 0xc10d,		0x21, 0
	.dw 0xc5c0, 0xc10d,	0xc5ff, 0xc10d,		0x21, 0
	.dw 0xc640, 0xc10d,	0xc67f, 0xc10d,		0x21, 0
	.dw 0xc6c0, 0xc10d,	0xc6ff, 0xc10d,		0x21, 0
	.dw 0xc740, 0xc10d,	0xc77f, 0xc10d,		0x21, 0
	.dw 0xc7c0, 0xc10d,	0xc7ff, 0xc10d,		0x21, 0
	.dw 0xc840, 0xc10d,	0xc87f, 0xc10d,		0x21, 0
	.dw 0xc8c0, 0xc10d,	0xc8ff, 0xc10d,		0x21, 0
	.dw 0xc940, 0xc10d,	0xc97f, 0xc10d,		0x21, 0
	.dw 0xc9c0, 0xc10d,	0xc9ff, 0xc10d,		0x21, 0
	.dw 0xca40, 0xc10d,	0xca7f, 0xc10d,		0x21, 0
	.dw 0xcac0, 0xc10d,	0xcaff, 0xc10d,		0x21, 0
	.dw 0xcb40, 0xc10d,	0xcb7f, 0xc10d,		0x21, 0
	.dw 0xcbc0, 0xc10d,	0xcbff, 0xc10d,		0x21, 0
	.dw 0xcc40, 0xc10d,	0xcc7f, 0xc10d,		0x21, 0
	.dw 0xccc0, 0xc10d,	0xccff, 0xc10d,		0x21, 0
	.dw 0xcd40, 0xc10d,	0xcd7f, 0xc10d,		0x21, 0
	.dw 0xcdc0, 0xc10d,	0xcdff, 0xc10d,		0x21, 0
	.dw 0xce40, 0xc10d,	0xce7f, 0xc10d,		0x21, 0
	.dw 0xcec0, 0xc10d,	0xceff, 0xc10d,		0x21, 0
	.dw 0xcf40, 0xc10d,	0xcf7f, 0xc10d,		0x21, 0
	.dw 0xcfc0, 0xc10d,	0xcfff, 0xc10d,		0x21, 0
	.dw 0xd040, 0xc10d,	0xd07f, 0xc10d,		0x21, 0
	.dw 0xd0c0, 0xc10d,	0xd0ff, 0xc10d,		0x21, 0
	.dw 0xd140, 0xc10d,	0xd17f, 0xc10d,		0x21, 0
	.dw 0xd1c0, 0xc10d,	0xd1ff, 0xc10d,		0x21, 0
	.dw 0xd240, 0xc10d,	0xd27f, 0xc10d,		0x21, 0
	.dw 0xd2c0, 0xc10d,	0xd2ff, 0xc10d,		0x21, 0
	.dw 0xd340, 0xc10d,	0xd37f, 0xc10d,		0x21, 0
	.dw 0xd3c0, 0xc10d,	0xd3ff, 0xc10d,		0x21, 0
	.dw 0xd440, 0xc10d,	0xd47f, 0xc10d,		0x21, 0
	.dw 0xd4c0, 0xc10d,	0xd4ff, 0xc10d,		0x21, 0
	.dw 0xd540, 0xc10d,	0xd57f, 0xc10d,		0x21, 0
	.dw 0xd5c0, 0xc10d,	0xd5ff, 0xc10d,		0x21, 0
	.dw 0xd640, 0xc10d,	0xd67f, 0xc10d,		0x21, 0
	.dw 0xd6c0, 0xc10d,	0xd6ff, 0xc10d,		0x21, 0
	.dw 0xd740, 0xc10d,	0xd77f, 0xc10d,		0x21, 0
	.dw 0xd7c0, 0xc10d,	0xd7ff, 0xc10d,		0x21, 0
	.dw 0xd840, 0xc10d,	0xd87f, 0xc10d,		0x21, 0
	.dw 0xd8c0, 0xc10d,	0xd8ff, 0xc10d,		0x21, 0
	.dw 0xd940, 0xc10d,	0xd97f, 0xc10d,		0x21, 0
	.dw 0xd9c0, 0xc10d,	0xdfff, 0xc10d,		0x21, 0
	.dw 0xe040, 0xc10d,	0xe07f, 0xc10d,		0x21, 0
	.dw 0xe0c0, 0xc10d,	0xe0ff, 0xc10d,		0x21, 0
	.dw 0xe140, 0xc10d,	0xe17f, 0xc10d,		0x21, 0
	.dw 0xe1c0, 0xc10d,	0xe1ff, 0xc10d,		0x21, 0
	.dw 0xe240, 0xc10d,	0xe27f, 0xc10d,		0x21, 0
	.dw 0xe2c0, 0xc10d,	0xe2ff, 0xc10d,		0x21, 0
	.dw 0xe340, 0xc10d,	0xe37f, 0xc10d,		0x21, 0
	.dw 0xe3c0, 0xc10d,	0xe3ff, 0xc10d,		0x21, 0
	.dw 0xe440, 0xc10d,	0xe47f, 0xc10d,		0x21, 0
	.dw 0xe4c0, 0xc10d,	0xe4ff, 0xc10d,		0x21, 0
	.dw 0xe540, 0xc10d,	0xe57f, 0xc10d,		0x21, 0
	.dw 0xe5c0, 0xc10d,	0xe5ff, 0xc10d,		0x21, 0
	.dw 0xe640, 0xc10d,	0xe67f, 0xc10d,		0x21, 0
	.dw 0xe6c0, 0xc10d,	0xe6ff, 0xc10d,		0x21, 0
	.dw 0xe740, 0xc10d,	0xe77f, 0xc10d,		0x21, 0
	.dw 0xe7c0, 0xc10d,	0xe7ff, 0xc10d,		0x21, 0
	.dw 0xe840, 0xc10d,	0xe87f, 0xc10d,		0x21, 0
	.dw 0xe8c0, 0xc10d,	0xe8ff, 0xc10d,		0x21, 0
	.dw 0xe940, 0xc10d,	0xe97f, 0xc10d,		0x21, 0
	.dw 0xe9c0, 0xc10d,	0xe9ff, 0xc10d,		0x21, 0
	.dw 0xea40, 0xc10d,	0xea7f, 0xc10d,		0x21, 0
	.dw 0xeac0, 0xc10d,	0xeaff, 0xc10d,		0x21, 0
	.dw 0xeb40, 0xc10d,	0xeb7f, 0xc10d,		0x21, 0
	.dw 0xebc0, 0xc10d,	0xebff, 0xc10d,		0x21, 0
	.dw 0xec40, 0xc10d,	0xec7f, 0xc10d,		0x21, 0
	.dw 0xecc0, 0xc10d,	0xecff, 0xc10d,		0x21, 0
	.dw 0xed40, 0xc10d,	0xed7f, 0xc10d,		0x21, 0
	.dw 0xedc0, 0xc10d,	0xedff, 0xc10d,		0x21, 0
	.dw 0xee40, 0xc10d,	0xee7f, 0xc10d,		0x21, 0
	.dw 0xeec0, 0xc10d,	0xeeff, 0xc10d,		0x21, 0
	.dw 0xef40, 0xc10d,	0xef7f, 0xc10d,		0x21, 0
	.dw 0xefc0, 0xc10d,	0xefff, 0xc10d,		0x21, 0
	.dw 0xf040, 0xc10d,	0xf07f, 0xc10d,		0x21, 0
	.dw 0xf0c0, 0xc10d,	0xf0ff, 0xc10d,		0x21, 0
	.dw 0xf140, 0xc10d,	0xf17f, 0xc10d,		0x21, 0
	.dw 0xf1c0, 0xc10d,	0xf1ff, 0xc10d,		0x21, 0
	.dw 0xf240, 0xc10d,	0xf27f, 0xc10d,		0x21, 0
	.dw 0xf2c0, 0xc10d,	0xf2ff, 0xc10d,		0x21, 0
	.dw 0xf340, 0xc10d,	0xf37f, 0xc10d,		0x21, 0
	.dw 0xf3c0, 0xc10d,	0xf3ff, 0xc10d,		0x21, 0
	.dw 0xf440, 0xc10d,	0xf47f, 0xc10d,		0x21, 0
	.dw 0xf4c0, 0xc10d,	0xf4ff, 0xc10d,		0x21, 0
	.dw 0xf540, 0xc10d,	0xf57f, 0xc10d,		0x21, 0
	.dw 0xf5c0, 0xc10d,	0xf5ff, 0xc10d,		0x21, 0
	.dw 0xf640, 0xc10d,	0xf67f, 0xc10d,		0x21, 0
	.dw 0xf6c0, 0xc10d,	0xf6ff, 0xc10d,		0x21, 0
	.dw 0xf740, 0xc10d,	0xf77f, 0xc10d,		0x21, 0
	.dw 0xf7c0, 0xc10d,	0xf7ff, 0xc10d,		0x21, 0
	.dw 0xf840, 0xc10d,	0xf87f, 0xc10d,		0x21, 0
	.dw 0xf8c0, 0xc10d,	0xf8ff, 0xc10d,		0x21, 0
	.dw 0xf940, 0xc10d,	0xf97f, 0xc10d,		0x21, 0
	.dw 0xf9c0, 0xc10d,	0xffff, 0xc10d,		0x21, 0
	.dw 0x0040, 0xc10e,	0x007f, 0xc10e,		0x21, 0
	.dw 0x00c0, 0xc10e,	0x00ff, 0xc10e,		0x21, 0
	.dw 0x0140, 0xc10e,	0x017f, 0xc10e,		0x21, 0
	.dw 0x01c0, 0xc10e,	0x01ff, 0xc10e,		0x21, 0
	.dw 0x0240, 0xc10e,	0x027f, 0xc10e,		0x21, 0
	.dw 0x02c0, 0xc10e,	0x02ff, 0xc10e,		0x21, 0
	.dw 0x0340, 0xc10e,	0x037f, 0xc10e,		0x21, 0
	.dw 0x03c0, 0xc10e,	0x03ff, 0xc10e,		0x21, 0
	.dw 0x0440, 0xc10e,	0x047f, 0xc10e,		0x21, 0
	.dw 0x04c0, 0xc10e,	0x04ff, 0xc10e,		0x21, 0
	.dw 0x0540, 0xc10e,	0x057f, 0xc10e,		0x21, 0
	.dw 0x05c0, 0xc10e,	0x05ff, 0xc10e,		0x21, 0
	.dw 0x0640, 0xc10e,	0x067f, 0xc10e,		0x21, 0
	.dw 0x06c0, 0xc10e,	0x06ff, 0xc10e,		0x21, 0
	.dw 0x0740, 0xc10e,	0x077f, 0xc10e,		0x21, 0
	.dw 0x07c0, 0xc10e,	0x07ff, 0xc10e,		0x21, 0
	.dw 0x0840, 0xc10e,	0x087f, 0xc10e,		0x21, 0
	.dw 0x08c0, 0xc10e,	0x08ff, 0xc10e,		0x21, 0
	.dw 0x0940, 0xc10e,	0x097f, 0xc10e,		0x21, 0
	.dw 0x09c0, 0xc10e,	0x09ff, 0xc10e,		0x21, 0
	.dw 0x0a40, 0xc10e,	0x0a7f, 0xc10e,		0x21, 0
	.dw 0x0ac0, 0xc10e,	0x0aff, 0xc10e,		0x21, 0
	.dw 0x0b40, 0xc10e,	0x0b7f, 0xc10e,		0x21, 0
	.dw 0x0bc0, 0xc10e,	0x0bff, 0xc10e,		0x21, 0
	.dw 0x0c40, 0xc10e,	0x0c7f, 0xc10e,		0x21, 0
	.dw 0x0cc0, 0xc10e,	0x0cff, 0xc10e,		0x21, 0
	.dw 0x0d40, 0xc10e,	0x0d7f, 0xc10e,		0x21, 0
	.dw 0x0dc0, 0xc10e,	0x0dff, 0xc10e,		0x21, 0
	.dw 0x0e40, 0xc10e,	0x0e7f, 0xc10e,		0x21, 0
	.dw 0x0ec0, 0xc10e,	0x0eff, 0xc10e,		0x21, 0
	.dw 0x0f40, 0xc10e,	0x0f7f, 0xc10e,		0x21, 0
	.dw 0x0fc0, 0xc10e,	0x0fff, 0xc10e,		0x21, 0
	.dw 0x1040, 0xc10e,	0x107f, 0xc10e,		0x21, 0
	.dw 0x10c0, 0xc10e,	0x10ff, 0xc10e,		0x21, 0
	.dw 0x1140, 0xc10e,	0x117f, 0xc10e,		0x21, 0
	.dw 0x11c0, 0xc10e,	0x11ff, 0xc10e,		0x21, 0
	.dw 0x1240, 0xc10e,	0x127f, 0xc10e,		0x21, 0
	.dw 0x12c0, 0xc10e,	0x12ff, 0xc10e,		0x21, 0
	.dw 0x1340, 0xc10e,	0x137f, 0xc10e,		0x21, 0
	.dw 0x13c0, 0xc10e,	0x13ff, 0xc10e,		0x21, 0
	.dw 0x1440, 0xc10e,	0x147f, 0xc10e,		0x21, 0
	.dw 0x14c0, 0xc10e,	0x14ff, 0xc10e,		0x21, 0
	.dw 0x1540, 0xc10e,	0x157f, 0xc10e,		0x21, 0
	.dw 0x15c0, 0xc10e,	0x15ff, 0xc10e,		0x21, 0
	.dw 0x1640, 0xc10e,	0x167f, 0xc10e,		0x21, 0
	.dw 0x16c0, 0xc10e,	0x16ff, 0xc10e,		0x21, 0
	.dw 0x1740, 0xc10e,	0x177f, 0xc10e,		0x21, 0
	.dw 0x17c0, 0xc10e,	0x17ff, 0xc10e,		0x21, 0
	.dw 0x1840, 0xc10e,	0x187f, 0xc10e,		0x21, 0
	.dw 0x18c0, 0xc10e,	0x18ff, 0xc10e,		0x21, 0
	.dw 0x1940, 0xc10e,	0x197f, 0xc10e,		0x21, 0
	.dw 0x19c0, 0xc10e,	0x1fff, 0xc10e,		0x21, 0
	.dw 0x2040, 0xc10e,	0x207f, 0xc10e,		0x21, 0
	.dw 0x20c0, 0xc10e,	0x20ff, 0xc10e,		0x21, 0
	.dw 0x2140, 0xc10e,	0x217f, 0xc10e,		0x21, 0
	.dw 0x21c0, 0xc10e,	0x21ff, 0xc10e,		0x21, 0
	.dw 0x2240, 0xc10e,	0x227f, 0xc10e,		0x21, 0
	.dw 0x22c0, 0xc10e,	0x22ff, 0xc10e,		0x21, 0
	.dw 0x2340, 0xc10e,	0x237f, 0xc10e,		0x21, 0
	.dw 0x23c0, 0xc10e,	0x23ff, 0xc10e,		0x21, 0
	.dw 0x2440, 0xc10e,	0x247f, 0xc10e,		0x21, 0
	.dw 0x24c0, 0xc10e,	0x24ff, 0xc10e,		0x21, 0
	.dw 0x2540, 0xc10e,	0x257f, 0xc10e,		0x21, 0
	.dw 0x25c0, 0xc10e,	0x25ff, 0xc10e,		0x21, 0
	.dw 0x2640, 0xc10e,	0x267f, 0xc10e,		0x21, 0
	.dw 0x26c0, 0xc10e,	0x26ff, 0xc10e,		0x21, 0
	.dw 0x2740, 0xc10e,	0x277f, 0xc10e,		0x21, 0
	.dw 0x27c0, 0xc10e,	0x27ff, 0xc10e,		0x21, 0
	.dw 0x2840, 0xc10e,	0x287f, 0xc10e,		0x21, 0
	.dw 0x28c0, 0xc10e,	0x28ff, 0xc10e,		0x21, 0
	.dw 0x2940, 0xc10e,	0x297f, 0xc10e,		0x21, 0
	.dw 0x29c0, 0xc10e,	0x29ff, 0xc10e,		0x21, 0
	.dw 0x2a40, 0xc10e,	0x2a7f, 0xc10e,		0x21, 0
	.dw 0x2ac0, 0xc10e,	0x2aff, 0xc10e,		0x21, 0
	.dw 0x2b40, 0xc10e,	0x2b7f, 0xc10e,		0x21, 0
	.dw 0x2bc0, 0xc10e,	0x2bff, 0xc10e,		0x21, 0
	.dw 0x2c40, 0xc10e,	0x2c7f, 0xc10e,		0x21, 0
	.dw 0x2cc0, 0xc10e,	0x2cff, 0xc10e,		0x21, 0
	.dw 0x2d40, 0xc10e,	0x2d7f, 0xc10e,		0x21, 0
	.dw 0x2dc0, 0xc10e,	0x2dff, 0xc10e,		0x21, 0
	.dw 0x2e40, 0xc10e,	0x2e7f, 0xc10e,		0x21, 0
	.dw 0x2ec0, 0xc10e,	0x2eff, 0xc10e,		0x21, 0
	.dw 0x2f40, 0xc10e,	0x2f7f, 0xc10e,		0x21, 0
	.dw 0x2fc0, 0xc10e,	0x2fff, 0xc10e,		0x21, 0
	.dw 0x3040, 0xc10e,	0x307f, 0xc10e,		0x21, 0
	.dw 0x30c0, 0xc10e,	0x30ff, 0xc10e,		0x21, 0
	.dw 0x3140, 0xc10e,	0x317f, 0xc10e,		0x21, 0
	.dw 0x31c0, 0xc10e,	0x31ff, 0xc10e,		0x21, 0
	.dw 0x3240, 0xc10e,	0x327f, 0xc10e,		0x21, 0
	.dw 0x32c0, 0xc10e,	0x32ff, 0xc10e,		0x21, 0
	.dw 0x3340, 0xc10e,	0x337f, 0xc10e,		0x21, 0
	.dw 0x33c0, 0xc10e,	0x33ff, 0xc10e,		0x21, 0
	.dw 0x3440, 0xc10e,	0x347f, 0xc10e,		0x21, 0
	.dw 0x34c0, 0xc10e,	0x34ff, 0xc10e,		0x21, 0
	.dw 0x3540, 0xc10e,	0x357f, 0xc10e,		0x21, 0
	.dw 0x35c0, 0xc10e,	0x35ff, 0xc10e,		0x21, 0
	.dw 0x3640, 0xc10e,	0x367f, 0xc10e,		0x21, 0
	.dw 0x36c0, 0xc10e,	0x36ff, 0xc10e,		0x21, 0
	.dw 0x3740, 0xc10e,	0x377f, 0xc10e,		0x21, 0
	.dw 0x37c0, 0xc10e,	0x37ff, 0xc10e,		0x21, 0
	.dw 0x3840, 0xc10e,	0x387f, 0xc10e,		0x21, 0
	.dw 0x38c0, 0xc10e,	0x38ff, 0xc10e,		0x21, 0
	.dw 0x3940, 0xc10e,	0x397f, 0xc10e,		0x21, 0
	.dw 0x39c0, 0xc10e,	0x3fff, 0xc10e,		0x21, 0
	.dw 0x4040, 0xc10e,	0x407f, 0xc10e,		0x21, 0
	.dw 0x40c0, 0xc10e,	0x40ff, 0xc10e,		0x21, 0
	.dw 0x4140, 0xc10e,	0x417f, 0xc10e,		0x21, 0
	.dw 0x41c0, 0xc10e,	0x41ff, 0xc10e,		0x21, 0
	.dw 0x4240, 0xc10e,	0x427f, 0xc10e,		0x21, 0
	.dw 0x42c0, 0xc10e,	0x42ff, 0xc10e,		0x21, 0
	.dw 0x4340, 0xc10e,	0x437f, 0xc10e,		0x21, 0
	.dw 0x43c0, 0xc10e,	0x43ff, 0xc10e,		0x21, 0
	.dw 0x4440, 0xc10e,	0x447f, 0xc10e,		0x21, 0
	.dw 0x44c0, 0xc10e,	0x44ff, 0xc10e,		0x21, 0
	.dw 0x4540, 0xc10e,	0x457f, 0xc10e,		0x21, 0
	.dw 0x45c0, 0xc10e,	0x45ff, 0xc10e,		0x21, 0
	.dw 0x4640, 0xc10e,	0x467f, 0xc10e,		0x21, 0
	.dw 0x46c0, 0xc10e,	0x46ff, 0xc10e,		0x21, 0
	.dw 0x4740, 0xc10e,	0x477f, 0xc10e,		0x21, 0
	.dw 0x47c0, 0xc10e,	0x47ff, 0xc10e,		0x21, 0
	.dw 0x4840, 0xc10e,	0x487f, 0xc10e,		0x21, 0
	.dw 0x48c0, 0xc10e,	0x48ff, 0xc10e,		0x21, 0
	.dw 0x4940, 0xc10e,	0x497f, 0xc10e,		0x21, 0
	.dw 0x49c0, 0xc10e,	0x49ff, 0xc10e,		0x21, 0
	.dw 0x4a40, 0xc10e,	0x4a7f, 0xc10e,		0x21, 0
	.dw 0x4ac0, 0xc10e,	0x4aff, 0xc10e,		0x21, 0
	.dw 0x4b40, 0xc10e,	0x4b7f, 0xc10e,		0x21, 0
	.dw 0x4bc0, 0xc10e,	0x4bff, 0xc10e,		0x21, 0
	.dw 0x4c40, 0xc10e,	0x4c7f, 0xc10e,		0x21, 0
	.dw 0x4cc0, 0xc10e,	0x4cff, 0xc10e,		0x21, 0
	.dw 0x4d40, 0xc10e,	0x4d7f, 0xc10e,		0x21, 0
	.dw 0x4dc0, 0xc10e,	0x4dff, 0xc10e,		0x21, 0
	.dw 0x4e40, 0xc10e,	0x4e7f, 0xc10e,		0x21, 0
	.dw 0x4ec0, 0xc10e,	0x4eff, 0xc10e,		0x21, 0
	.dw 0x4f40, 0xc10e,	0x4f7f, 0xc10e,		0x21, 0
	.dw 0x4fc0, 0xc10e,	0x4fff, 0xc10e,		0x21, 0
	.dw 0x5040, 0xc10e,	0x507f, 0xc10e,		0x21, 0
	.dw 0x50c0, 0xc10e,	0x50ff, 0xc10e,		0x21, 0
	.dw 0x5140, 0xc10e,	0x517f, 0xc10e,		0x21, 0
	.dw 0x51c0, 0xc10e,	0x51ff, 0xc10e,		0x21, 0
	.dw 0x5240, 0xc10e,	0x527f, 0xc10e,		0x21, 0
	.dw 0x52c0, 0xc10e,	0x52ff, 0xc10e,		0x21, 0
	.dw 0x5340, 0xc10e,	0x537f, 0xc10e,		0x21, 0
	.dw 0x53c0, 0xc10e,	0x53ff, 0xc10e,		0x21, 0
	.dw 0x5440, 0xc10e,	0x547f, 0xc10e,		0x21, 0
	.dw 0x54c0, 0xc10e,	0x54ff, 0xc10e,		0x21, 0
	.dw 0x5540, 0xc10e,	0x557f, 0xc10e,		0x21, 0
	.dw 0x55c0, 0xc10e,	0x55ff, 0xc10e,		0x21, 0
	.dw 0x5640, 0xc10e,	0x567f, 0xc10e,		0x21, 0
	.dw 0x56c0, 0xc10e,	0x56ff, 0xc10e,		0x21, 0
	.dw 0x5740, 0xc10e,	0x577f, 0xc10e,		0x21, 0
	.dw 0x57c0, 0xc10e,	0x57ff, 0xc10e,		0x21, 0
	.dw 0x5840, 0xc10e,	0x587f, 0xc10e,		0x21, 0
	.dw 0x58c0, 0xc10e,	0x58ff, 0xc10e,		0x21, 0
	.dw 0x5940, 0xc10e,	0x597f, 0xc10e,		0x21, 0
	.dw 0x59c0, 0xc10e,	0x5fff, 0xc10e,		0x21, 0
	.dw 0x6040, 0xc10e,	0x607f, 0xc10e,		0x21, 0
	.dw 0x60c0, 0xc10e,	0x60ff, 0xc10e,		0x21, 0
	.dw 0x6140, 0xc10e,	0x617f, 0xc10e,		0x21, 0
	.dw 0x61c0, 0xc10e,	0x61ff, 0xc10e,		0x21, 0
	.dw 0x6240, 0xc10e,	0x627f, 0xc10e,		0x21, 0
	.dw 0x62c0, 0xc10e,	0x62ff, 0xc10e,		0x21, 0
	.dw 0x6340, 0xc10e,	0x637f, 0xc10e,		0x21, 0
	.dw 0x63c0, 0xc10e,	0x63ff, 0xc10e,		0x21, 0
	.dw 0x6440, 0xc10e,	0x647f, 0xc10e,		0x21, 0
	.dw 0x64c0, 0xc10e,	0x64ff, 0xc10e,		0x21, 0
	.dw 0x6540, 0xc10e,	0x657f, 0xc10e,		0x21, 0
	.dw 0x65c0, 0xc10e,	0x65ff, 0xc10e,		0x21, 0
	.dw 0x6640, 0xc10e,	0x667f, 0xc10e,		0x21, 0
	.dw 0x66c0, 0xc10e,	0x66ff, 0xc10e,		0x21, 0
	.dw 0x6740, 0xc10e,	0x677f, 0xc10e,		0x21, 0
	.dw 0x67c0, 0xc10e,	0x67ff, 0xc10e,		0x21, 0
	.dw 0x6840, 0xc10e,	0x687f, 0xc10e,		0x21, 0
	.dw 0x68c0, 0xc10e,	0x68ff, 0xc10e,		0x21, 0
	.dw 0x6940, 0xc10e,	0x697f, 0xc10e,		0x21, 0
	.dw 0x69c0, 0xc10e,	0x69ff, 0xc10e,		0x21, 0
	.dw 0x6a40, 0xc10e,	0x6a7f, 0xc10e,		0x21, 0
	.dw 0x6ac0, 0xc10e,	0x6aff, 0xc10e,		0x21, 0
	.dw 0x6b40, 0xc10e,	0x6b7f, 0xc10e,		0x21, 0
	.dw 0x6bc0, 0xc10e,	0x6bff, 0xc10e,		0x21, 0
	.dw 0x6c40, 0xc10e,	0x6c7f, 0xc10e,		0x21, 0
	.dw 0x6cc0, 0xc10e,	0x6cff, 0xc10e,		0x21, 0
	.dw 0x6d40, 0xc10e,	0x6d7f, 0xc10e,		0x21, 0
	.dw 0x6dc0, 0xc10e,	0x6dff, 0xc10e,		0x21, 0
	.dw 0x6e40, 0xc10e,	0x6e7f, 0xc10e,		0x21, 0
	.dw 0x6ec0, 0xc10e,	0x6eff, 0xc10e,		0x21, 0
	.dw 0x6f40, 0xc10e,	0x6f7f, 0xc10e,		0x21, 0
	.dw 0x6fc0, 0xc10e,	0x6fff, 0xc10e,		0x21, 0
	.dw 0x7040, 0xc10e,	0x707f, 0xc10e,		0x21, 0
	.dw 0x70c0, 0xc10e,	0x70ff, 0xc10e,		0x21, 0
	.dw 0x7140, 0xc10e,	0x717f, 0xc10e,		0x21, 0
	.dw 0x71c0, 0xc10e,	0x71ff, 0xc10e,		0x21, 0
	.dw 0x7240, 0xc10e,	0x727f, 0xc10e,		0x21, 0
	.dw 0x72c0, 0xc10e,	0x72ff, 0xc10e,		0x21, 0
	.dw 0x7340, 0xc10e,	0x737f, 0xc10e,		0x21, 0
	.dw 0x73c0, 0xc10e,	0x73ff, 0xc10e,		0x21, 0
	.dw 0x7440, 0xc10e,	0x747f, 0xc10e,		0x21, 0
	.dw 0x74c0, 0xc10e,	0x74ff, 0xc10e,		0x21, 0
	.dw 0x7540, 0xc10e,	0x757f, 0xc10e,		0x21, 0
	.dw 0x75c0, 0xc10e,	0x75ff, 0xc10e,		0x21, 0
	.dw 0x7640, 0xc10e,	0x767f, 0xc10e,		0x21, 0
	.dw 0x76c0, 0xc10e,	0x76ff, 0xc10e,		0x21, 0
	.dw 0x7740, 0xc10e,	0x777f, 0xc10e,		0x21, 0
	.dw 0x77c0, 0xc10e,	0x77ff, 0xc10e,		0x21, 0
	.dw 0x7840, 0xc10e,	0x787f, 0xc10e,		0x21, 0
	.dw 0x78c0, 0xc10e,	0x78ff, 0xc10e,		0x21, 0
	.dw 0x7940, 0xc10e,	0x797f, 0xc10e,		0x21, 0
	.dw 0x79c0, 0xc10e,	0x7fff, 0xc10e,		0x21, 0
	.dw 0x8040, 0xc10e,	0x807f, 0xc10e,		0x21, 0
	.dw 0x80c0, 0xc10e,	0x80ff, 0xc10e,		0x21, 0
	.dw 0x8140, 0xc10e,	0x817f, 0xc10e,		0x21, 0
	.dw 0x81c0, 0xc10e,	0x81ff, 0xc10e,		0x21, 0
	.dw 0x8240, 0xc10e,	0x827f, 0xc10e,		0x21, 0
	.dw 0x82c0, 0xc10e,	0x82ff, 0xc10e,		0x21, 0
	.dw 0x8340, 0xc10e,	0x837f, 0xc10e,		0x21, 0
	.dw 0x83c0, 0xc10e,	0x83ff, 0xc10e,		0x21, 0
	.dw 0x8440, 0xc10e,	0x847f, 0xc10e,		0x21, 0
	.dw 0x84c0, 0xc10e,	0x84ff, 0xc10e,		0x21, 0
	.dw 0x8540, 0xc10e,	0x857f, 0xc10e,		0x21, 0
	.dw 0x85c0, 0xc10e,	0x85ff, 0xc10e,		0x21, 0
	.dw 0x8640, 0xc10e,	0x867f, 0xc10e,		0x21, 0
	.dw 0x86c0, 0xc10e,	0x86ff, 0xc10e,		0x21, 0
	.dw 0x8740, 0xc10e,	0x877f, 0xc10e,		0x21, 0
	.dw 0x87c0, 0xc10e,	0x87ff, 0xc10e,		0x21, 0
	.dw 0x8840, 0xc10e,	0x887f, 0xc10e,		0x21, 0
	.dw 0x88c0, 0xc10e,	0x88ff, 0xc10e,		0x21, 0
	.dw 0x8940, 0xc10e,	0x897f, 0xc10e,		0x21, 0
	.dw 0x89c0, 0xc10e,	0x89ff, 0xc10e,		0x21, 0
	.dw 0x8a40, 0xc10e,	0x8a7f, 0xc10e,		0x21, 0
	.dw 0x8ac0, 0xc10e,	0x8aff, 0xc10e,		0x21, 0
	.dw 0x8b40, 0xc10e,	0x8b7f, 0xc10e,		0x21, 0
	.dw 0x8bc0, 0xc10e,	0x8bff, 0xc10e,		0x21, 0
	.dw 0x8c40, 0xc10e,	0x8c7f, 0xc10e,		0x21, 0
	.dw 0x8cc0, 0xc10e,	0x8cff, 0xc10e,		0x21, 0
	.dw 0x8d40, 0xc10e,	0x8d7f, 0xc10e,		0x21, 0
	.dw 0x8dc0, 0xc10e,	0x8dff, 0xc10e,		0x21, 0
	.dw 0x8e40, 0xc10e,	0x8e7f, 0xc10e,		0x21, 0
	.dw 0x8ec0, 0xc10e,	0x8eff, 0xc10e,		0x21, 0
	.dw 0x8f40, 0xc10e,	0x8f7f, 0xc10e,		0x21, 0
	.dw 0x8fc0, 0xc10e,	0x8fff, 0xc10e,		0x21, 0
	.dw 0x9040, 0xc10e,	0x907f, 0xc10e,		0x21, 0
	.dw 0x90c0, 0xc10e,	0x90ff, 0xc10e,		0x21, 0
	.dw 0x9140, 0xc10e,	0x917f, 0xc10e,		0x21, 0
	.dw 0x91c0, 0xc10e,	0x91ff, 0xc10e,		0x21, 0
	.dw 0x9240, 0xc10e,	0x927f, 0xc10e,		0x21, 0
	.dw 0x92c0, 0xc10e,	0x92ff, 0xc10e,		0x21, 0
	.dw 0x9340, 0xc10e,	0x937f, 0xc10e,		0x21, 0
	.dw 0x93c0, 0xc10e,	0x93ff, 0xc10e,		0x21, 0
	.dw 0x9440, 0xc10e,	0x947f, 0xc10e,		0x21, 0
	.dw 0x94c0, 0xc10e,	0x94ff, 0xc10e,		0x21, 0
	.dw 0x9540, 0xc10e,	0x957f, 0xc10e,		0x21, 0
	.dw 0x95c0, 0xc10e,	0x95ff, 0xc10e,		0x21, 0
	.dw 0x9640, 0xc10e,	0x967f, 0xc10e,		0x21, 0
	.dw 0x96c0, 0xc10e,	0x96ff, 0xc10e,		0x21, 0
	.dw 0x9740, 0xc10e,	0x977f, 0xc10e,		0x21, 0
	.dw 0x97c0, 0xc10e,	0x97ff, 0xc10e,		0x21, 0
	.dw 0x9840, 0xc10e,	0x987f, 0xc10e,		0x21, 0
	.dw 0x98c0, 0xc10e,	0x98ff, 0xc10e,		0x21, 0
	.dw 0x9940, 0xc10e,	0x997f, 0xc10e,		0x21, 0
	.dw 0x99c0, 0xc10e,	0x9fff, 0xc10e,		0x21, 0
	.dw 0xa040, 0xc10e,	0xa07f, 0xc10e,		0x21, 0
	.dw 0xa0c0, 0xc10e,	0xa0ff, 0xc10e,		0x21, 0
	.dw 0xa140, 0xc10e,	0xa17f, 0xc10e,		0x21, 0
	.dw 0xa1c0, 0xc10e,	0xa1ff, 0xc10e,		0x21, 0
	.dw 0xa240, 0xc10e,	0xa27f, 0xc10e,		0x21, 0
	.dw 0xa2c0, 0xc10e,	0xa2ff, 0xc10e,		0x21, 0
	.dw 0xa340, 0xc10e,	0xa37f, 0xc10e,		0x21, 0
	.dw 0xa3c0, 0xc10e,	0xa3ff, 0xc10e,		0x21, 0
	.dw 0xa440, 0xc10e,	0xa47f, 0xc10e,		0x21, 0
	.dw 0xa4c0, 0xc10e,	0xa4ff, 0xc10e,		0x21, 0
	.dw 0xa540, 0xc10e,	0xa57f, 0xc10e,		0x21, 0
	.dw 0xa5c0, 0xc10e,	0xa5ff, 0xc10e,		0x21, 0
	.dw 0xa640, 0xc10e,	0xa67f, 0xc10e,		0x21, 0
	.dw 0xa6c0, 0xc10e,	0xa6ff, 0xc10e,		0x21, 0
	.dw 0xa740, 0xc10e,	0xa77f, 0xc10e,		0x21, 0
	.dw 0xa7c0, 0xc10e,	0xa7ff, 0xc10e,		0x21, 0
	.dw 0xa840, 0xc10e,	0xa87f, 0xc10e,		0x21, 0
	.dw 0xa8c0, 0xc10e,	0xa8ff, 0xc10e,		0x21, 0
	.dw 0xa940, 0xc10e,	0xa97f, 0xc10e,		0x21, 0
	.dw 0xa9c0, 0xc10e,	0xa9ff, 0xc10e,		0x21, 0
	.dw 0xaa40, 0xc10e,	0xaa7f, 0xc10e,		0x21, 0
	.dw 0xaac0, 0xc10e,	0xaaff, 0xc10e,		0x21, 0
	.dw 0xab40, 0xc10e,	0xab7f, 0xc10e,		0x21, 0
	.dw 0xabc0, 0xc10e,	0xabff, 0xc10e,		0x21, 0
	.dw 0xac40, 0xc10e,	0xac7f, 0xc10e,		0x21, 0
	.dw 0xacc0, 0xc10e,	0xacff, 0xc10e,		0x21, 0
	.dw 0xad40, 0xc10e,	0xad7f, 0xc10e,		0x21, 0
	.dw 0xadc0, 0xc10e,	0xadff, 0xc10e,		0x21, 0
	.dw 0xae40, 0xc10e,	0xae7f, 0xc10e,		0x21, 0
	.dw 0xaec0, 0xc10e,	0xaeff, 0xc10e,		0x21, 0
	.dw 0xaf40, 0xc10e,	0xaf7f, 0xc10e,		0x21, 0
	.dw 0xafc0, 0xc10e,	0xafff, 0xc10e,		0x21, 0
	.dw 0xb040, 0xc10e,	0xb07f, 0xc10e,		0x21, 0
	.dw 0xb0c0, 0xc10e,	0xb0ff, 0xc10e,		0x21, 0
	.dw 0xb140, 0xc10e,	0xb17f, 0xc10e,		0x21, 0
	.dw 0xb1c0, 0xc10e,	0xb1ff, 0xc10e,		0x21, 0
	.dw 0xb240, 0xc10e,	0xb27f, 0xc10e,		0x21, 0
	.dw 0xb2c0, 0xc10e,	0xb2ff, 0xc10e,		0x21, 0
	.dw 0xb340, 0xc10e,	0xb37f, 0xc10e,		0x21, 0
	.dw 0xb3c0, 0xc10e,	0xb3ff, 0xc10e,		0x21, 0
	.dw 0xb440, 0xc10e,	0xb47f, 0xc10e,		0x21, 0
	.dw 0xb4c0, 0xc10e,	0xb4ff, 0xc10e,		0x21, 0
	.dw 0xb540, 0xc10e,	0xb57f, 0xc10e,		0x21, 0
	.dw 0xb5c0, 0xc10e,	0xb5ff, 0xc10e,		0x21, 0
	.dw 0xb640, 0xc10e,	0xb67f, 0xc10e,		0x21, 0
	.dw 0xb6c0, 0xc10e,	0xb6ff, 0xc10e,		0x21, 0
	.dw 0xb740, 0xc10e,	0xb77f, 0xc10e,		0x21, 0
	.dw 0xb7c0, 0xc10e,	0xb7ff, 0xc10e,		0x21, 0
	.dw 0xb840, 0xc10e,	0xb87f, 0xc10e,		0x21, 0
	.dw 0xb8c0, 0xc10e,	0xb8ff, 0xc10e,		0x21, 0
	.dw 0xb940, 0xc10e,	0xb97f, 0xc10e,		0x21, 0
	.dw 0xb9c0, 0xc10e,	0xbfff, 0xc10e,		0x21, 0
	.dw 0xc040, 0xc10e,	0xc07f, 0xc10e,		0x21, 0
	.dw 0xc0c0, 0xc10e,	0xc0ff, 0xc10e,		0x21, 0
	.dw 0xc140, 0xc10e,	0xc17f, 0xc10e,		0x21, 0
	.dw 0xc1c0, 0xc10e,	0xc1ff, 0xc10e,		0x21, 0
	.dw 0xc240, 0xc10e,	0xc27f, 0xc10e,		0x21, 0
	.dw 0xc2c0, 0xc10e,	0xc2ff, 0xc10e,		0x21, 0
	.dw 0xc340, 0xc10e,	0xc37f, 0xc10e,		0x21, 0
	.dw 0xc3c0, 0xc10e,	0xc3ff, 0xc10e,		0x21, 0
	.dw 0xc440, 0xc10e,	0xc47f, 0xc10e,		0x21, 0
	.dw 0xc4c0, 0xc10e,	0xc4ff, 0xc10e,		0x21, 0
	.dw 0xc540, 0xc10e,	0xc57f, 0xc10e,		0x21, 0
	.dw 0xc5c0, 0xc10e,	0xc5ff, 0xc10e,		0x21, 0
	.dw 0xc640, 0xc10e,	0xc67f, 0xc10e,		0x21, 0
	.dw 0xc6c0, 0xc10e,	0xc6ff, 0xc10e,		0x21, 0
	.dw 0xc740, 0xc10e,	0xc77f, 0xc10e,		0x21, 0
	.dw 0xc7c0, 0xc10e,	0xc7ff, 0xc10e,		0x21, 0
	.dw 0xc840, 0xc10e,	0xc87f, 0xc10e,		0x21, 0
	.dw 0xc8c0, 0xc10e,	0xc8ff, 0xc10e,		0x21, 0
	.dw 0xc940, 0xc10e,	0xc97f, 0xc10e,		0x21, 0
	.dw 0xc9c0, 0xc10e,	0xc9ff, 0xc10e,		0x21, 0
	.dw 0xca40, 0xc10e,	0xca7f, 0xc10e,		0x21, 0
	.dw 0xcac0, 0xc10e,	0xcaff, 0xc10e,		0x21, 0
	.dw 0xcb40, 0xc10e,	0xcb7f, 0xc10e,		0x21, 0
	.dw 0xcbc0, 0xc10e,	0xcbff, 0xc10e,		0x21, 0
	.dw 0xcc40, 0xc10e,	0xcc7f, 0xc10e,		0x21, 0
	.dw 0xccc0, 0xc10e,	0xccff, 0xc10e,		0x21, 0
	.dw 0xcd40, 0xc10e,	0xcd7f, 0xc10e,		0x21, 0
	.dw 0xcdc0, 0xc10e,	0xcdff, 0xc10e,		0x21, 0
	.dw 0xce40, 0xc10e,	0xce7f, 0xc10e,		0x21, 0
	.dw 0xcec0, 0xc10e,	0xceff, 0xc10e,		0x21, 0
	.dw 0xcf40, 0xc10e,	0xcf7f, 0xc10e,		0x21, 0
	.dw 0xcfc0, 0xc10e,	0xcfff, 0xc10e,		0x21, 0
	.dw 0xd040, 0xc10e,	0xd07f, 0xc10e,		0x21, 0
	.dw 0xd0c0, 0xc10e,	0xd0ff, 0xc10e,		0x21, 0
	.dw 0xd140, 0xc10e,	0xd17f, 0xc10e,		0x21, 0
	.dw 0xd1c0, 0xc10e,	0xd1ff, 0xc10e,		0x21, 0
	.dw 0xd240, 0xc10e,	0xd27f, 0xc10e,		0x21, 0
	.dw 0xd2c0, 0xc10e,	0xd2ff, 0xc10e,		0x21, 0
	.dw 0xd340, 0xc10e,	0xd37f, 0xc10e,		0x21, 0
	.dw 0xd3c0, 0xc10e,	0xd3ff, 0xc10e,		0x21, 0
	.dw 0xd440, 0xc10e,	0xd47f, 0xc10e,		0x21, 0
	.dw 0xd4c0, 0xc10e,	0xd4ff, 0xc10e,		0x21, 0
	.dw 0xd540, 0xc10e,	0xd57f, 0xc10e,		0x21, 0
	.dw 0xd5c0, 0xc10e,	0xd5ff, 0xc10e,		0x21, 0
	.dw 0xd640, 0xc10e,	0xd67f, 0xc10e,		0x21, 0
	.dw 0xd6c0, 0xc10e,	0xd6ff, 0xc10e,		0x21, 0
	.dw 0xd740, 0xc10e,	0xd77f, 0xc10e,		0x21, 0
	.dw 0xd7c0, 0xc10e,	0xd7ff, 0xc10e,		0x21, 0
	.dw 0xd840, 0xc10e,	0xd87f, 0xc10e,		0x21, 0
	.dw 0xd8c0, 0xc10e,	0xd8ff, 0xc10e,		0x21, 0
	.dw 0xd940, 0xc10e,	0xd97f, 0xc10e,		0x21, 0
	.dw 0xd9c0, 0xc10e,	0xdfff, 0xc10e,		0x21, 0
	.dw 0xe040, 0xc10e,	0xe07f, 0xc10e,		0x21, 0
	.dw 0xe0c0, 0xc10e,	0xe0ff, 0xc10e,		0x21, 0
	.dw 0xe140, 0xc10e,	0xe17f, 0xc10e,		0x21, 0
	.dw 0xe1c0, 0xc10e,	0xe1ff, 0xc10e,		0x21, 0
	.dw 0xe240, 0xc10e,	0xe27f, 0xc10e,		0x21, 0
	.dw 0xe2c0, 0xc10e,	0xe2ff, 0xc10e,		0x21, 0
	.dw 0xe340, 0xc10e,	0xe37f, 0xc10e,		0x21, 0
	.dw 0xe3c0, 0xc10e,	0xe3ff, 0xc10e,		0x21, 0
	.dw 0xe440, 0xc10e,	0xe47f, 0xc10e,		0x21, 0
	.dw 0xe4c0, 0xc10e,	0xe4ff, 0xc10e,		0x21, 0
	.dw 0xe540, 0xc10e,	0xe57f, 0xc10e,		0x21, 0
	.dw 0xe5c0, 0xc10e,	0xe5ff, 0xc10e,		0x21, 0
	.dw 0xe640, 0xc10e,	0xe67f, 0xc10e,		0x21, 0
	.dw 0xe6c0, 0xc10e,	0xe6ff, 0xc10e,		0x21, 0
	.dw 0xe740, 0xc10e,	0xe77f, 0xc10e,		0x21, 0
	.dw 0xe7c0, 0xc10e,	0xe7ff, 0xc10e,		0x21, 0
	.dw 0xe840, 0xc10e,	0xe87f, 0xc10e,		0x21, 0
	.dw 0xe8c0, 0xc10e,	0xe8ff, 0xc10e,		0x21, 0
	.dw 0xe940, 0xc10e,	0xe97f, 0xc10e,		0x21, 0
	.dw 0xe9c0, 0xc10e,	0xe9ff, 0xc10e,		0x21, 0
	.dw 0xea40, 0xc10e,	0xea7f, 0xc10e,		0x21, 0
	.dw 0xeac0, 0xc10e,	0xeaff, 0xc10e,		0x21, 0
	.dw 0xeb40, 0xc10e,	0xeb7f, 0xc10e,		0x21, 0
	.dw 0xebc0, 0xc10e,	0xebff, 0xc10e,		0x21, 0
	.dw 0xec40, 0xc10e,	0xec7f, 0xc10e,		0x21, 0
	.dw 0xecc0, 0xc10e,	0xecff, 0xc10e,		0x21, 0
	.dw 0xed40, 0xc10e,	0xed7f, 0xc10e,		0x21, 0
	.dw 0xedc0, 0xc10e,	0xedff, 0xc10e,		0x21, 0
	.dw 0xee40, 0xc10e,	0xee7f, 0xc10e,		0x21, 0
	.dw 0xeec0, 0xc10e,	0xeeff, 0xc10e,		0x21, 0
	.dw 0xef40, 0xc10e,	0xef7f, 0xc10e,		0x21, 0
	.dw 0xefc0, 0xc10e,	0xefff, 0xc10e,		0x21, 0
	.dw 0xf040, 0xc10e,	0xf07f, 0xc10e,		0x21, 0
	.dw 0xf0c0, 0xc10e,	0xf0ff, 0xc10e,		0x21, 0
	.dw 0xf140, 0xc10e,	0xf17f, 0xc10e,		0x21, 0
	.dw 0xf1c0, 0xc10e,	0xf1ff, 0xc10e,		0x21, 0
	.dw 0xf240, 0xc10e,	0xf27f, 0xc10e,		0x21, 0
	.dw 0xf2c0, 0xc10e,	0xf2ff, 0xc10e,		0x21, 0
	.dw 0xf340, 0xc10e,	0xf37f, 0xc10e,		0x21, 0
	.dw 0xf3c0, 0xc10e,	0xf3ff, 0xc10e,		0x21, 0
	.dw 0xf440, 0xc10e,	0xf47f, 0xc10e,		0x21, 0
	.dw 0xf4c0, 0xc10e,	0xf4ff, 0xc10e,		0x21, 0
	.dw 0xf540, 0xc10e,	0xf57f, 0xc10e,		0x21, 0
	.dw 0xf5c0, 0xc10e,	0xf5ff, 0xc10e,		0x21, 0
	.dw 0xf640, 0xc10e,	0xf67f, 0xc10e,		0x21, 0
	.dw 0xf6c0, 0xc10e,	0xf6ff, 0xc10e,		0x21, 0
	.dw 0xf740, 0xc10e,	0xf77f, 0xc10e,		0x21, 0
	.dw 0xf7c0, 0xc10e,	0xf7ff, 0xc10e,		0x21, 0
	.dw 0xf840, 0xc10e,	0xf87f, 0xc10e,		0x21, 0
	.dw 0xf8c0, 0xc10e,	0xf8ff, 0xc10e,		0x21, 0
	.dw 0xf940, 0xc10e,	0xf97f, 0xc10e,		0x21, 0
	.dw 0xf9c0, 0xc10e,	0xffff, 0xc10e,		0x21, 0
	.dw 0x0040, 0xc10f,	0x007f, 0xc10f,		0x21, 0
	.dw 0x00c0, 0xc10f,	0x00ff, 0xc10f,		0x21, 0
	.dw 0x0140, 0xc10f,	0x017f, 0xc10f,		0x21, 0
	.dw 0x01c0, 0xc10f,	0x01ff, 0xc10f,		0x21, 0
	.dw 0x0240, 0xc10f,	0x027f, 0xc10f,		0x21, 0
	.dw 0x02c0, 0xc10f,	0x02ff, 0xc10f,		0x21, 0
	.dw 0x0340, 0xc10f,	0x037f, 0xc10f,		0x21, 0
	.dw 0x03c0, 0xc10f,	0x03ff, 0xc10f,		0x21, 0
	.dw 0x0440, 0xc10f,	0x047f, 0xc10f,		0x21, 0
	.dw 0x04c0, 0xc10f,	0x04ff, 0xc10f,		0x21, 0
	.dw 0x0540, 0xc10f,	0x057f, 0xc10f,		0x21, 0
	.dw 0x05c0, 0xc10f,	0x05ff, 0xc10f,		0x21, 0
	.dw 0x0640, 0xc10f,	0x067f, 0xc10f,		0x21, 0
	.dw 0x06c0, 0xc10f,	0x06ff, 0xc10f,		0x21, 0
	.dw 0x0740, 0xc10f,	0x077f, 0xc10f,		0x21, 0
	.dw 0x07c0, 0xc10f,	0x07ff, 0xc10f,		0x21, 0
	.dw 0x0840, 0xc10f,	0x087f, 0xc10f,		0x21, 0
	.dw 0x08c0, 0xc10f,	0x08ff, 0xc10f,		0x21, 0
	.dw 0x0940, 0xc10f,	0x097f, 0xc10f,		0x21, 0
	.dw 0x09c0, 0xc10f,	0x09ff, 0xc10f,		0x21, 0
	.dw 0x0a40, 0xc10f,	0x0a7f, 0xc10f,		0x21, 0
	.dw 0x0ac0, 0xc10f,	0x0aff, 0xc10f,		0x21, 0
	.dw 0x0b40, 0xc10f,	0x0b7f, 0xc10f,		0x21, 0
	.dw 0x0bc0, 0xc10f,	0x0bff, 0xc10f,		0x21, 0
	.dw 0x0c40, 0xc10f,	0x0c7f, 0xc10f,		0x21, 0
	.dw 0x0cc0, 0xc10f,	0x0cff, 0xc10f,		0x21, 0
	.dw 0x0d40, 0xc10f,	0x0d7f, 0xc10f,		0x21, 0
	.dw 0x0dc0, 0xc10f,	0x0dff, 0xc10f,		0x21, 0
	.dw 0x0e40, 0xc10f,	0x0e7f, 0xc10f,		0x21, 0
	.dw 0x0ec0, 0xc10f,	0x0eff, 0xc10f,		0x21, 0
	.dw 0x0f40, 0xc10f,	0x0f7f, 0xc10f,		0x21, 0
	.dw 0x0fc0, 0xc10f,	0x0fff, 0xc10f,		0x21, 0
	.dw 0x1040, 0xc10f,	0x107f, 0xc10f,		0x21, 0
	.dw 0x10c0, 0xc10f,	0x10ff, 0xc10f,		0x21, 0
	.dw 0x1140, 0xc10f,	0x117f, 0xc10f,		0x21, 0
	.dw 0x11c0, 0xc10f,	0x11ff, 0xc10f,		0x21, 0
	.dw 0x1240, 0xc10f,	0x127f, 0xc10f,		0x21, 0
	.dw 0x12c0, 0xc10f,	0x12ff, 0xc10f,		0x21, 0
	.dw 0x1340, 0xc10f,	0x137f, 0xc10f,		0x21, 0
	.dw 0x13c0, 0xc10f,	0x13ff, 0xc10f,		0x21, 0
	.dw 0x1440, 0xc10f,	0x147f, 0xc10f,		0x21, 0
	.dw 0x14c0, 0xc10f,	0x14ff, 0xc10f,		0x21, 0
	.dw 0x1540, 0xc10f,	0x157f, 0xc10f,		0x21, 0
	.dw 0x15c0, 0xc10f,	0x15ff, 0xc10f,		0x21, 0
	.dw 0x1640, 0xc10f,	0x167f, 0xc10f,		0x21, 0
	.dw 0x16c0, 0xc10f,	0x16ff, 0xc10f,		0x21, 0
	.dw 0x1740, 0xc10f,	0x177f, 0xc10f,		0x21, 0
	.dw 0x17c0, 0xc10f,	0x17ff, 0xc10f,		0x21, 0
	.dw 0x1840, 0xc10f,	0x187f, 0xc10f,		0x21, 0
	.dw 0x18c0, 0xc10f,	0x18ff, 0xc10f,		0x21, 0
	.dw 0x1940, 0xc10f,	0x197f, 0xc10f,		0x21, 0
	.dw 0x19c0, 0xc10f,	0x1fff, 0xc10f,		0x21, 0
	.dw 0x2040, 0xc10f,	0x207f, 0xc10f,		0x21, 0
	.dw 0x20c0, 0xc10f,	0x20ff, 0xc10f,		0x21, 0
	.dw 0x2140, 0xc10f,	0x217f, 0xc10f,		0x21, 0
	.dw 0x21c0, 0xc10f,	0x21ff, 0xc10f,		0x21, 0
	.dw 0x2240, 0xc10f,	0x227f, 0xc10f,		0x21, 0
	.dw 0x22c0, 0xc10f,	0x22ff, 0xc10f,		0x21, 0
	.dw 0x2340, 0xc10f,	0x237f, 0xc10f,		0x21, 0
	.dw 0x23c0, 0xc10f,	0x23ff, 0xc10f,		0x21, 0
	.dw 0x2440, 0xc10f,	0x247f, 0xc10f,		0x21, 0
	.dw 0x24c0, 0xc10f,	0x24ff, 0xc10f,		0x21, 0
	.dw 0x2540, 0xc10f,	0x257f, 0xc10f,		0x21, 0
	.dw 0x25c0, 0xc10f,	0x25ff, 0xc10f,		0x21, 0
	.dw 0x2640, 0xc10f,	0x267f, 0xc10f,		0x21, 0
	.dw 0x26c0, 0xc10f,	0x26ff, 0xc10f,		0x21, 0
	.dw 0x2740, 0xc10f,	0x277f, 0xc10f,		0x21, 0
	.dw 0x27c0, 0xc10f,	0x27ff, 0xc10f,		0x21, 0
	.dw 0x2840, 0xc10f,	0x287f, 0xc10f,		0x21, 0
	.dw 0x28c0, 0xc10f,	0x28ff, 0xc10f,		0x21, 0
	.dw 0x2940, 0xc10f,	0x297f, 0xc10f,		0x21, 0
	.dw 0x29c0, 0xc10f,	0x29ff, 0xc10f,		0x21, 0
	.dw 0x2a40, 0xc10f,	0x2a7f, 0xc10f,		0x21, 0
	.dw 0x2ac0, 0xc10f,	0x2aff, 0xc10f,		0x21, 0
	.dw 0x2b40, 0xc10f,	0x2b7f, 0xc10f,		0x21, 0
	.dw 0x2bc0, 0xc10f,	0x2bff, 0xc10f,		0x21, 0
	.dw 0x2c40, 0xc10f,	0x2c7f, 0xc10f,		0x21, 0
	.dw 0x2cc0, 0xc10f,	0x2cff, 0xc10f,		0x21, 0
	.dw 0x2d40, 0xc10f,	0x2d7f, 0xc10f,		0x21, 0
	.dw 0x2dc0, 0xc10f,	0x2dff, 0xc10f,		0x21, 0
	.dw 0x2e40, 0xc10f,	0x2e7f, 0xc10f,		0x21, 0
	.dw 0x2ec0, 0xc10f,	0x2eff, 0xc10f,		0x21, 0
	.dw 0x2f40, 0xc10f,	0x2f7f, 0xc10f,		0x21, 0
	.dw 0x2fc0, 0xc10f,	0x2fff, 0xc10f,		0x21, 0
	.dw 0x3040, 0xc10f,	0x307f, 0xc10f,		0x21, 0
	.dw 0x30c0, 0xc10f,	0x30ff, 0xc10f,		0x21, 0
	.dw 0x3140, 0xc10f,	0x317f, 0xc10f,		0x21, 0
	.dw 0x31c0, 0xc10f,	0x31ff, 0xc10f,		0x21, 0
	.dw 0x3240, 0xc10f,	0x327f, 0xc10f,		0x21, 0
	.dw 0x32c0, 0xc10f,	0x32ff, 0xc10f,		0x21, 0
	.dw 0x3340, 0xc10f,	0x337f, 0xc10f,		0x21, 0
	.dw 0x33c0, 0xc10f,	0x33ff, 0xc10f,		0x21, 0
	.dw 0x3440, 0xc10f,	0x347f, 0xc10f,		0x21, 0
	.dw 0x34c0, 0xc10f,	0x34ff, 0xc10f,		0x21, 0
	.dw 0x3540, 0xc10f,	0x357f, 0xc10f,		0x21, 0
	.dw 0x35c0, 0xc10f,	0x35ff, 0xc10f,		0x21, 0
	.dw 0x3640, 0xc10f,	0x367f, 0xc10f,		0x21, 0
	.dw 0x36c0, 0xc10f,	0x36ff, 0xc10f,		0x21, 0
	.dw 0x3740, 0xc10f,	0x377f, 0xc10f,		0x21, 0
	.dw 0x37c0, 0xc10f,	0x37ff, 0xc10f,		0x21, 0
	.dw 0x3840, 0xc10f,	0x387f, 0xc10f,		0x21, 0
	.dw 0x38c0, 0xc10f,	0x38ff, 0xc10f,		0x21, 0
	.dw 0x3940, 0xc10f,	0x397f, 0xc10f,		0x21, 0
	.dw 0x39c0, 0xc10f,	0xffff, 0xc10f,		0x21, 0
	.dw 0x1a00, 0xc110,	0x1fff, 0xc110,		0x21, 0
	.dw 0x3a00, 0xc110,	0x3fff, 0xc110,		0x21, 0
	.dw 0x5a00, 0xc110,	0x5fff, 0xc110,		0x21, 0
	.dw 0x7a00, 0xc110,	0x7fff, 0xc110,		0x21, 0
	.dw 0x9a00, 0xc110,	0x9fff, 0xc110,		0x21, 0
	.dw 0xba00, 0xc110,	0xbfff, 0xc110,		0x21, 0
	.dw 0xda00, 0xc110,	0xdfff, 0xc110,		0x21, 0
	.dw 0xfa00, 0xc110,	0xffff, 0xc110,		0x21, 0
	.dw 0x1a00, 0xc111,	0x1fff, 0xc111,		0x21, 0
	.dw 0x3a00, 0xc111,	0x3fff, 0xc111,		0x21, 0
	.dw 0x5a00, 0xc111,	0x5fff, 0xc111,		0x21, 0
	.dw 0x7a00, 0xc111,	0x7fff, 0xc111,		0x21, 0
	.dw 0x9a00, 0xc111,	0x9fff, 0xc111,		0x21, 0
	.dw 0xba00, 0xc111,	0xbfff, 0xc111,		0x21, 0
	.dw 0xda00, 0xc111,	0xdfff, 0xc111,		0x21, 0
	.dw 0xfa00, 0xc111,	0xffff, 0xc111,		0x21, 0
	.dw 0x1a00, 0xc112,	0x1fff, 0xc112,		0x21, 0
	.dw 0x3a00, 0xc112,	0x3fff, 0xc112,		0x21, 0
	.dw 0x5a00, 0xc112,	0x5fff, 0xc112,		0x21, 0
	.dw 0x7a00, 0xc112,	0x7fff, 0xc112,		0x21, 0
	.dw 0x9a00, 0xc112,	0x9fff, 0xc112,		0x21, 0
	.dw 0xba00, 0xc112,	0xbfff, 0xc112,		0x21, 0
	.dw 0xda00, 0xc112,	0xdfff, 0xc112,		0x21, 0
	.dw 0xfa00, 0xc112,	0xffff, 0xc113,		0x21, 0
	.dw 0x1a00, 0xc114,	0x1fff, 0xc114,		0x21, 0
	.dw 0x3a00, 0xc114,	0x3fff, 0xc114,		0x21, 0
	.dw 0x5a00, 0xc114,	0x5fff, 0xc114,		0x21, 0
	.dw 0x7a00, 0xc114,	0x7fff, 0xc114,		0x21, 0
	.dw 0x9a00, 0xc114,	0x9fff, 0xc114,		0x21, 0
	.dw 0xba00, 0xc114,	0xbfff, 0xc114,		0x21, 0
	.dw 0xda00, 0xc114,	0xdfff, 0xc114,		0x21, 0
	.dw 0xfa00, 0xc114,	0xffff, 0xc114,		0x21, 0
	.dw 0x1a00, 0xc115,	0x1fff, 0xc115,		0x21, 0
	.dw 0x3a00, 0xc115,	0x3fff, 0xc115,		0x21, 0
	.dw 0x5a00, 0xc115,	0x5fff, 0xc115,		0x21, 0
	.dw 0x7a00, 0xc115,	0x7fff, 0xc115,		0x21, 0
	.dw 0x9a00, 0xc115,	0x9fff, 0xc115,		0x21, 0
	.dw 0xba00, 0xc115,	0xbfff, 0xc115,		0x21, 0
	.dw 0xda00, 0xc115,	0xdfff, 0xc115,		0x21, 0
	.dw 0xfa00, 0xc115,	0xffff, 0xc115,		0x21, 0
	.dw 0x1a00, 0xc116,	0x1fff, 0xc116,		0x21, 0
	.dw 0x3a00, 0xc116,	0x3fff, 0xc116,		0x21, 0
	.dw 0x5a00, 0xc116,	0x5fff, 0xc116,		0x21, 0
	.dw 0x7a00, 0xc116,	0x7fff, 0xc116,		0x21, 0
	.dw 0x9a00, 0xc116,	0x9fff, 0xc116,		0x21, 0
	.dw 0xba00, 0xc116,	0xbfff, 0xc116,		0x21, 0
	.dw 0xda00, 0xc116,	0xdfff, 0xc116,		0x21, 0
	.dw 0xfa00, 0xc116,	0xffff, 0xc116,		0x21, 0
	.dw 0x1a00, 0xc117,	0x1fff, 0xc117,		0x21, 0
	.dw 0x3a00, 0xc117,	0x1fff, 0xc118,		0x21, 0
	.dw 0x2040, 0xc118,	0x207f, 0xc118,		0x21, 0
	.dw 0x20c0, 0xc118,	0x20ff, 0xc118,		0x21, 0
	.dw 0x2140, 0xc118,	0x217f, 0xc118,		0x21, 0
	.dw 0x21c0, 0xc118,	0x21ff, 0xc118,		0x21, 0
	.dw 0x2240, 0xc118,	0x227f, 0xc118,		0x21, 0
	.dw 0x22c0, 0xc118,	0x22ff, 0xc118,		0x21, 0
	.dw 0x2340, 0xc118,	0x237f, 0xc118,		0x21, 0
	.dw 0x23c0, 0xc118,	0x23ff, 0xc118,		0x21, 0
	.dw 0x2440, 0xc118,	0x247f, 0xc118,		0x21, 0
	.dw 0x24c0, 0xc118,	0x24ff, 0xc118,		0x21, 0
	.dw 0x2540, 0xc118,	0x257f, 0xc118,		0x21, 0
	.dw 0x25c0, 0xc118,	0x25ff, 0xc118,		0x21, 0
	.dw 0x2640, 0xc118,	0x267f, 0xc118,		0x21, 0
	.dw 0x26c0, 0xc118,	0x26ff, 0xc118,		0x21, 0
	.dw 0x2740, 0xc118,	0x277f, 0xc118,		0x21, 0
	.dw 0x27c0, 0xc118,	0x27ff, 0xc118,		0x21, 0
	.dw 0x2840, 0xc118,	0x287f, 0xc118,		0x21, 0
	.dw 0x28c0, 0xc118,	0x28ff, 0xc118,		0x21, 0
	.dw 0x2940, 0xc118,	0x297f, 0xc118,		0x21, 0
	.dw 0x29c0, 0xc118,	0x29ff, 0xc118,		0x21, 0
	.dw 0x2a40, 0xc118,	0x2a7f, 0xc118,		0x21, 0
	.dw 0x2ac0, 0xc118,	0x2aff, 0xc118,		0x21, 0
	.dw 0x2b40, 0xc118,	0x2b7f, 0xc118,		0x21, 0
	.dw 0x2bc0, 0xc118,	0x2bff, 0xc118,		0x21, 0
	.dw 0x2c40, 0xc118,	0x2c7f, 0xc118,		0x21, 0
	.dw 0x2cc0, 0xc118,	0x2cff, 0xc118,		0x21, 0
	.dw 0x2d40, 0xc118,	0x2d7f, 0xc118,		0x21, 0
	.dw 0x2dc0, 0xc118,	0x2dff, 0xc118,		0x21, 0
	.dw 0x2e40, 0xc118,	0x2e7f, 0xc118,		0x21, 0
	.dw 0x2ec0, 0xc118,	0x2eff, 0xc118,		0x21, 0
	.dw 0x2f40, 0xc118,	0x2f7f, 0xc118,		0x21, 0
	.dw 0x2fc0, 0xc118,	0x2fff, 0xc118,		0x21, 0
	.dw 0x3040, 0xc118,	0x307f, 0xc118,		0x21, 0
	.dw 0x30c0, 0xc118,	0x30ff, 0xc118,		0x21, 0
	.dw 0x3140, 0xc118,	0x317f, 0xc118,		0x21, 0
	.dw 0x31c0, 0xc118,	0x31ff, 0xc118,		0x21, 0
	.dw 0x3240, 0xc118,	0x327f, 0xc118,		0x21, 0
	.dw 0x32c0, 0xc118,	0x32ff, 0xc118,		0x21, 0
	.dw 0x3340, 0xc118,	0x337f, 0xc118,		0x21, 0
	.dw 0x33c0, 0xc118,	0x33ff, 0xc118,		0x21, 0
	.dw 0x3440, 0xc118,	0x347f, 0xc118,		0x21, 0
	.dw 0x34c0, 0xc118,	0x34ff, 0xc118,		0x21, 0
	.dw 0x3540, 0xc118,	0x357f, 0xc118,		0x21, 0
	.dw 0x35c0, 0xc118,	0x35ff, 0xc118,		0x21, 0
	.dw 0x3640, 0xc118,	0x367f, 0xc118,		0x21, 0
	.dw 0x36c0, 0xc118,	0x36ff, 0xc118,		0x21, 0
	.dw 0x3740, 0xc118,	0x377f, 0xc118,		0x21, 0
	.dw 0x37c0, 0xc118,	0x37ff, 0xc118,		0x21, 0
	.dw 0x3840, 0xc118,	0x387f, 0xc118,		0x21, 0
	.dw 0x38c0, 0xc118,	0x38ff, 0xc118,		0x21, 0
	.dw 0x3940, 0xc118,	0x397f, 0xc118,		0x21, 0
	.dw 0x39c0, 0xc118,	0x5fff, 0xc118,		0x21, 0
	.dw 0x6040, 0xc118,	0x607f, 0xc118,		0x21, 0
	.dw 0x60c0, 0xc118,	0x60ff, 0xc118,		0x21, 0
	.dw 0x6140, 0xc118,	0x617f, 0xc118,		0x21, 0
	.dw 0x61c0, 0xc118,	0x61ff, 0xc118,		0x21, 0
	.dw 0x6240, 0xc118,	0x627f, 0xc118,		0x21, 0
	.dw 0x62c0, 0xc118,	0x62ff, 0xc118,		0x21, 0
	.dw 0x6340, 0xc118,	0x637f, 0xc118,		0x21, 0
	.dw 0x63c0, 0xc118,	0x63ff, 0xc118,		0x21, 0
	.dw 0x6440, 0xc118,	0x647f, 0xc118,		0x21, 0
	.dw 0x64c0, 0xc118,	0x64ff, 0xc118,		0x21, 0
	.dw 0x6540, 0xc118,	0x657f, 0xc118,		0x21, 0
	.dw 0x65c0, 0xc118,	0x65ff, 0xc118,		0x21, 0
	.dw 0x6640, 0xc118,	0x667f, 0xc118,		0x21, 0
	.dw 0x66c0, 0xc118,	0x66ff, 0xc118,		0x21, 0
	.dw 0x6740, 0xc118,	0x677f, 0xc118,		0x21, 0
	.dw 0x67c0, 0xc118,	0x67ff, 0xc118,		0x21, 0
	.dw 0x6840, 0xc118,	0x687f, 0xc118,		0x21, 0
	.dw 0x68c0, 0xc118,	0x68ff, 0xc118,		0x21, 0
	.dw 0x6940, 0xc118,	0x697f, 0xc118,		0x21, 0
	.dw 0x69c0, 0xc118,	0x69ff, 0xc118,		0x21, 0
	.dw 0x6a40, 0xc118,	0x6a7f, 0xc118,		0x21, 0
	.dw 0x6ac0, 0xc118,	0x6aff, 0xc118,		0x21, 0
	.dw 0x6b40, 0xc118,	0x6b7f, 0xc118,		0x21, 0
	.dw 0x6bc0, 0xc118,	0x6bff, 0xc118,		0x21, 0
	.dw 0x6c40, 0xc118,	0x6c7f, 0xc118,		0x21, 0
	.dw 0x6cc0, 0xc118,	0x6cff, 0xc118,		0x21, 0
	.dw 0x6d40, 0xc118,	0x6d7f, 0xc118,		0x21, 0
	.dw 0x6dc0, 0xc118,	0x6dff, 0xc118,		0x21, 0
	.dw 0x6e40, 0xc118,	0x6e7f, 0xc118,		0x21, 0
	.dw 0x6ec0, 0xc118,	0x6eff, 0xc118,		0x21, 0
	.dw 0x6f40, 0xc118,	0x6f7f, 0xc118,		0x21, 0
	.dw 0x6fc0, 0xc118,	0x6fff, 0xc118,		0x21, 0
	.dw 0x7040, 0xc118,	0x707f, 0xc118,		0x21, 0
	.dw 0x70c0, 0xc118,	0x70ff, 0xc118,		0x21, 0
	.dw 0x7140, 0xc118,	0x717f, 0xc118,		0x21, 0
	.dw 0x71c0, 0xc118,	0x71ff, 0xc118,		0x21, 0
	.dw 0x7240, 0xc118,	0x727f, 0xc118,		0x21, 0
	.dw 0x72c0, 0xc118,	0x72ff, 0xc118,		0x21, 0
	.dw 0x7340, 0xc118,	0x737f, 0xc118,		0x21, 0
	.dw 0x73c0, 0xc118,	0x73ff, 0xc118,		0x21, 0
	.dw 0x7440, 0xc118,	0x747f, 0xc118,		0x21, 0
	.dw 0x74c0, 0xc118,	0x74ff, 0xc118,		0x21, 0
	.dw 0x7540, 0xc118,	0x757f, 0xc118,		0x21, 0
	.dw 0x75c0, 0xc118,	0x75ff, 0xc118,		0x21, 0
	.dw 0x7640, 0xc118,	0x767f, 0xc118,		0x21, 0
	.dw 0x76c0, 0xc118,	0x76ff, 0xc118,		0x21, 0
	.dw 0x7740, 0xc118,	0x777f, 0xc118,		0x21, 0
	.dw 0x77c0, 0xc118,	0x77ff, 0xc118,		0x21, 0
	.dw 0x7840, 0xc118,	0x787f, 0xc118,		0x21, 0
	.dw 0x78c0, 0xc118,	0x78ff, 0xc118,		0x21, 0
	.dw 0x7940, 0xc118,	0x797f, 0xc118,		0x21, 0
	.dw 0x79c0, 0xc118,	0x9fff, 0xc118,		0x21, 0
	.dw 0xa040, 0xc118,	0xa07f, 0xc118,		0x21, 0
	.dw 0xa0c0, 0xc118,	0xa0ff, 0xc118,		0x21, 0
	.dw 0xa140, 0xc118,	0xa17f, 0xc118,		0x21, 0
	.dw 0xa1c0, 0xc118,	0xa1ff, 0xc118,		0x21, 0
	.dw 0xa240, 0xc118,	0xa27f, 0xc118,		0x21, 0
	.dw 0xa2c0, 0xc118,	0xa2ff, 0xc118,		0x21, 0
	.dw 0xa340, 0xc118,	0xa37f, 0xc118,		0x21, 0
	.dw 0xa3c0, 0xc118,	0xa3ff, 0xc118,		0x21, 0
	.dw 0xa440, 0xc118,	0xa47f, 0xc118,		0x21, 0
	.dw 0xa4c0, 0xc118,	0xa4ff, 0xc118,		0x21, 0
	.dw 0xa540, 0xc118,	0xa57f, 0xc118,		0x21, 0
	.dw 0xa5c0, 0xc118,	0xa5ff, 0xc118,		0x21, 0
	.dw 0xa640, 0xc118,	0xa67f, 0xc118,		0x21, 0
	.dw 0xa6c0, 0xc118,	0xa6ff, 0xc118,		0x21, 0
	.dw 0xa740, 0xc118,	0xa77f, 0xc118,		0x21, 0
	.dw 0xa7c0, 0xc118,	0xa7ff, 0xc118,		0x21, 0
	.dw 0xa840, 0xc118,	0xa87f, 0xc118,		0x21, 0
	.dw 0xa8c0, 0xc118,	0xa8ff, 0xc118,		0x21, 0
	.dw 0xa940, 0xc118,	0xa97f, 0xc118,		0x21, 0
	.dw 0xa9c0, 0xc118,	0xa9ff, 0xc118,		0x21, 0
	.dw 0xaa40, 0xc118,	0xaa7f, 0xc118,		0x21, 0
	.dw 0xaac0, 0xc118,	0xaaff, 0xc118,		0x21, 0
	.dw 0xab40, 0xc118,	0xab7f, 0xc118,		0x21, 0
	.dw 0xabc0, 0xc118,	0xabff, 0xc118,		0x21, 0
	.dw 0xac40, 0xc118,	0xac7f, 0xc118,		0x21, 0
	.dw 0xacc0, 0xc118,	0xacff, 0xc118,		0x21, 0
	.dw 0xad40, 0xc118,	0xad7f, 0xc118,		0x21, 0
	.dw 0xadc0, 0xc118,	0xadff, 0xc118,		0x21, 0
	.dw 0xae40, 0xc118,	0xae7f, 0xc118,		0x21, 0
	.dw 0xaec0, 0xc118,	0xaeff, 0xc118,		0x21, 0
	.dw 0xaf40, 0xc118,	0xaf7f, 0xc118,		0x21, 0
	.dw 0xafc0, 0xc118,	0xafff, 0xc118,		0x21, 0
	.dw 0xb040, 0xc118,	0xb07f, 0xc118,		0x21, 0
	.dw 0xb0c0, 0xc118,	0xb0ff, 0xc118,		0x21, 0
	.dw 0xb140, 0xc118,	0xb17f, 0xc118,		0x21, 0
	.dw 0xb1c0, 0xc118,	0xb1ff, 0xc118,		0x21, 0
	.dw 0xb240, 0xc118,	0xb27f, 0xc118,		0x21, 0
	.dw 0xb2c0, 0xc118,	0xb2ff, 0xc118,		0x21, 0
	.dw 0xb340, 0xc118,	0xb37f, 0xc118,		0x21, 0
	.dw 0xb3c0, 0xc118,	0xb3ff, 0xc118,		0x21, 0
	.dw 0xb440, 0xc118,	0xb47f, 0xc118,		0x21, 0
	.dw 0xb4c0, 0xc118,	0xb4ff, 0xc118,		0x21, 0
	.dw 0xb540, 0xc118,	0xb57f, 0xc118,		0x21, 0
	.dw 0xb5c0, 0xc118,	0xb5ff, 0xc118,		0x21, 0
	.dw 0xb640, 0xc118,	0xb67f, 0xc118,		0x21, 0
	.dw 0xb6c0, 0xc118,	0xb6ff, 0xc118,		0x21, 0
	.dw 0xb740, 0xc118,	0xb77f, 0xc118,		0x21, 0
	.dw 0xb7c0, 0xc118,	0xb7ff, 0xc118,		0x21, 0
	.dw 0xb840, 0xc118,	0xb87f, 0xc118,		0x21, 0
	.dw 0xb8c0, 0xc118,	0xb8ff, 0xc118,		0x21, 0
	.dw 0xb940, 0xc118,	0xb97f, 0xc118,		0x21, 0
	.dw 0xb9c0, 0xc118,	0xdfff, 0xc118,		0x21, 0
	.dw 0xe040, 0xc118,	0xe07f, 0xc118,		0x21, 0
	.dw 0xe0c0, 0xc118,	0xe0ff, 0xc118,		0x21, 0
	.dw 0xe140, 0xc118,	0xe17f, 0xc118,		0x21, 0
	.dw 0xe1c0, 0xc118,	0xe1ff, 0xc118,		0x21, 0
	.dw 0xe240, 0xc118,	0xe27f, 0xc118,		0x21, 0
	.dw 0xe2c0, 0xc118,	0xe2ff, 0xc118,		0x21, 0
	.dw 0xe340, 0xc118,	0xe37f, 0xc118,		0x21, 0
	.dw 0xe3c0, 0xc118,	0xe3ff, 0xc118,		0x21, 0
	.dw 0xe440, 0xc118,	0xe47f, 0xc118,		0x21, 0
	.dw 0xe4c0, 0xc118,	0xe4ff, 0xc118,		0x21, 0
	.dw 0xe540, 0xc118,	0xe57f, 0xc118,		0x21, 0
	.dw 0xe5c0, 0xc118,	0xe5ff, 0xc118,		0x21, 0
	.dw 0xe640, 0xc118,	0xe67f, 0xc118,		0x21, 0
	.dw 0xe6c0, 0xc118,	0xe6ff, 0xc118,		0x21, 0
	.dw 0xe740, 0xc118,	0xe77f, 0xc118,		0x21, 0
	.dw 0xe7c0, 0xc118,	0xe7ff, 0xc118,		0x21, 0
	.dw 0xe840, 0xc118,	0xe87f, 0xc118,		0x21, 0
	.dw 0xe8c0, 0xc118,	0xe8ff, 0xc118,		0x21, 0
	.dw 0xe940, 0xc118,	0xe97f, 0xc118,		0x21, 0
	.dw 0xe9c0, 0xc118,	0xe9ff, 0xc118,		0x21, 0
	.dw 0xea40, 0xc118,	0xea7f, 0xc118,		0x21, 0
	.dw 0xeac0, 0xc118,	0xeaff, 0xc118,		0x21, 0
	.dw 0xeb40, 0xc118,	0xeb7f, 0xc118,		0x21, 0
	.dw 0xebc0, 0xc118,	0xebff, 0xc118,		0x21, 0
	.dw 0xec40, 0xc118,	0xec7f, 0xc118,		0x21, 0
	.dw 0xecc0, 0xc118,	0xecff, 0xc118,		0x21, 0
	.dw 0xed40, 0xc118,	0xed7f, 0xc118,		0x21, 0
	.dw 0xedc0, 0xc118,	0xedff, 0xc118,		0x21, 0
	.dw 0xee40, 0xc118,	0xee7f, 0xc118,		0x21, 0
	.dw 0xeec0, 0xc118,	0xeeff, 0xc118,		0x21, 0
	.dw 0xef40, 0xc118,	0xef7f, 0xc118,		0x21, 0
	.dw 0xefc0, 0xc118,	0xefff, 0xc118,		0x21, 0
	.dw 0xf040, 0xc118,	0xf07f, 0xc118,		0x21, 0
	.dw 0xf0c0, 0xc118,	0xf0ff, 0xc118,		0x21, 0
	.dw 0xf140, 0xc118,	0xf17f, 0xc118,		0x21, 0
	.dw 0xf1c0, 0xc118,	0xf1ff, 0xc118,		0x21, 0
	.dw 0xf240, 0xc118,	0xf27f, 0xc118,		0x21, 0
	.dw 0xf2c0, 0xc118,	0xf2ff, 0xc118,		0x21, 0
	.dw 0xf340, 0xc118,	0xf37f, 0xc118,		0x21, 0
	.dw 0xf3c0, 0xc118,	0xf3ff, 0xc118,		0x21, 0
	.dw 0xf440, 0xc118,	0xf47f, 0xc118,		0x21, 0
	.dw 0xf4c0, 0xc118,	0xf4ff, 0xc118,		0x21, 0
	.dw 0xf540, 0xc118,	0xf57f, 0xc118,		0x21, 0
	.dw 0xf5c0, 0xc118,	0xf5ff, 0xc118,		0x21, 0
	.dw 0xf640, 0xc118,	0xf67f, 0xc118,		0x21, 0
	.dw 0xf6c0, 0xc118,	0xf6ff, 0xc118,		0x21, 0
	.dw 0xf740, 0xc118,	0xf77f, 0xc118,		0x21, 0
	.dw 0xf7c0, 0xc118,	0xf7ff, 0xc118,		0x21, 0
	.dw 0xf840, 0xc118,	0xf87f, 0xc118,		0x21, 0
	.dw 0xf8c0, 0xc118,	0xf8ff, 0xc118,		0x21, 0
	.dw 0xf940, 0xc118,	0xf97f, 0xc118,		0x21, 0
	.dw 0xf9c0, 0xc118,	0x1fff, 0xc119,		0x21, 0
	.dw 0x2040, 0xc119,	0x207f, 0xc119,		0x21, 0
	.dw 0x20c0, 0xc119,	0x20ff, 0xc119,		0x21, 0
	.dw 0x2140, 0xc119,	0x217f, 0xc119,		0x21, 0
	.dw 0x21c0, 0xc119,	0x21ff, 0xc119,		0x21, 0
	.dw 0x2240, 0xc119,	0x227f, 0xc119,		0x21, 0
	.dw 0x22c0, 0xc119,	0x22ff, 0xc119,		0x21, 0
	.dw 0x2340, 0xc119,	0x237f, 0xc119,		0x21, 0
	.dw 0x23c0, 0xc119,	0x23ff, 0xc119,		0x21, 0
	.dw 0x2440, 0xc119,	0x247f, 0xc119,		0x21, 0
	.dw 0x24c0, 0xc119,	0x24ff, 0xc119,		0x21, 0
	.dw 0x2540, 0xc119,	0x257f, 0xc119,		0x21, 0
	.dw 0x25c0, 0xc119,	0x25ff, 0xc119,		0x21, 0
	.dw 0x2640, 0xc119,	0x267f, 0xc119,		0x21, 0
	.dw 0x26c0, 0xc119,	0x26ff, 0xc119,		0x21, 0
	.dw 0x2740, 0xc119,	0x277f, 0xc119,		0x21, 0
	.dw 0x27c0, 0xc119,	0x27ff, 0xc119,		0x21, 0
	.dw 0x2840, 0xc119,	0x287f, 0xc119,		0x21, 0
	.dw 0x28c0, 0xc119,	0x28ff, 0xc119,		0x21, 0
	.dw 0x2940, 0xc119,	0x297f, 0xc119,		0x21, 0
	.dw 0x29c0, 0xc119,	0x29ff, 0xc119,		0x21, 0
	.dw 0x2a40, 0xc119,	0x2a7f, 0xc119,		0x21, 0
	.dw 0x2ac0, 0xc119,	0x2aff, 0xc119,		0x21, 0
	.dw 0x2b40, 0xc119,	0x2b7f, 0xc119,		0x21, 0
	.dw 0x2bc0, 0xc119,	0x2bff, 0xc119,		0x21, 0
	.dw 0x2c40, 0xc119,	0x2c7f, 0xc119,		0x21, 0
	.dw 0x2cc0, 0xc119,	0x2cff, 0xc119,		0x21, 0
	.dw 0x2d40, 0xc119,	0x2d7f, 0xc119,		0x21, 0
	.dw 0x2dc0, 0xc119,	0x2dff, 0xc119,		0x21, 0
	.dw 0x2e40, 0xc119,	0x2e7f, 0xc119,		0x21, 0
	.dw 0x2ec0, 0xc119,	0x2eff, 0xc119,		0x21, 0
	.dw 0x2f40, 0xc119,	0x2f7f, 0xc119,		0x21, 0
	.dw 0x2fc0, 0xc119,	0x2fff, 0xc119,		0x21, 0
	.dw 0x3040, 0xc119,	0x307f, 0xc119,		0x21, 0
	.dw 0x30c0, 0xc119,	0x30ff, 0xc119,		0x21, 0
	.dw 0x3140, 0xc119,	0x317f, 0xc119,		0x21, 0
	.dw 0x31c0, 0xc119,	0x31ff, 0xc119,		0x21, 0
	.dw 0x3240, 0xc119,	0x327f, 0xc119,		0x21, 0
	.dw 0x32c0, 0xc119,	0x32ff, 0xc119,		0x21, 0
	.dw 0x3340, 0xc119,	0x337f, 0xc119,		0x21, 0
	.dw 0x33c0, 0xc119,	0x33ff, 0xc119,		0x21, 0
	.dw 0x3440, 0xc119,	0x347f, 0xc119,		0x21, 0
	.dw 0x34c0, 0xc119,	0x34ff, 0xc119,		0x21, 0
	.dw 0x3540, 0xc119,	0x357f, 0xc119,		0x21, 0
	.dw 0x35c0, 0xc119,	0x35ff, 0xc119,		0x21, 0
	.dw 0x3640, 0xc119,	0x367f, 0xc119,		0x21, 0
	.dw 0x36c0, 0xc119,	0x36ff, 0xc119,		0x21, 0
	.dw 0x3740, 0xc119,	0x377f, 0xc119,		0x21, 0
	.dw 0x37c0, 0xc119,	0x37ff, 0xc119,		0x21, 0
	.dw 0x3840, 0xc119,	0x387f, 0xc119,		0x21, 0
	.dw 0x38c0, 0xc119,	0x38ff, 0xc119,		0x21, 0
	.dw 0x3940, 0xc119,	0x397f, 0xc119,		0x21, 0
	.dw 0x39c0, 0xc119,	0x5fff, 0xc119,		0x21, 0
	.dw 0x6040, 0xc119,	0x607f, 0xc119,		0x21, 0
	.dw 0x60c0, 0xc119,	0x60ff, 0xc119,		0x21, 0
	.dw 0x6140, 0xc119,	0x617f, 0xc119,		0x21, 0
	.dw 0x61c0, 0xc119,	0x61ff, 0xc119,		0x21, 0
	.dw 0x6240, 0xc119,	0x627f, 0xc119,		0x21, 0
	.dw 0x62c0, 0xc119,	0x62ff, 0xc119,		0x21, 0
	.dw 0x6340, 0xc119,	0x637f, 0xc119,		0x21, 0
	.dw 0x63c0, 0xc119,	0x63ff, 0xc119,		0x21, 0
	.dw 0x6440, 0xc119,	0x647f, 0xc119,		0x21, 0
	.dw 0x64c0, 0xc119,	0x64ff, 0xc119,		0x21, 0
	.dw 0x6540, 0xc119,	0x657f, 0xc119,		0x21, 0
	.dw 0x65c0, 0xc119,	0x65ff, 0xc119,		0x21, 0
	.dw 0x6640, 0xc119,	0x667f, 0xc119,		0x21, 0
	.dw 0x66c0, 0xc119,	0x66ff, 0xc119,		0x21, 0
	.dw 0x6740, 0xc119,	0x677f, 0xc119,		0x21, 0
	.dw 0x67c0, 0xc119,	0x67ff, 0xc119,		0x21, 0
	.dw 0x6840, 0xc119,	0x687f, 0xc119,		0x21, 0
	.dw 0x68c0, 0xc119,	0x68ff, 0xc119,		0x21, 0
	.dw 0x6940, 0xc119,	0x697f, 0xc119,		0x21, 0
	.dw 0x69c0, 0xc119,	0x69ff, 0xc119,		0x21, 0
	.dw 0x6a40, 0xc119,	0x6a7f, 0xc119,		0x21, 0
	.dw 0x6ac0, 0xc119,	0x6aff, 0xc119,		0x21, 0
	.dw 0x6b40, 0xc119,	0x6b7f, 0xc119,		0x21, 0
	.dw 0x6bc0, 0xc119,	0x6bff, 0xc119,		0x21, 0
	.dw 0x6c40, 0xc119,	0x6c7f, 0xc119,		0x21, 0
	.dw 0x6cc0, 0xc119,	0x6cff, 0xc119,		0x21, 0
	.dw 0x6d40, 0xc119,	0x6d7f, 0xc119,		0x21, 0
	.dw 0x6dc0, 0xc119,	0x6dff, 0xc119,		0x21, 0
	.dw 0x6e40, 0xc119,	0x6e7f, 0xc119,		0x21, 0
	.dw 0x6ec0, 0xc119,	0x6eff, 0xc119,		0x21, 0
	.dw 0x6f40, 0xc119,	0x6f7f, 0xc119,		0x21, 0
	.dw 0x6fc0, 0xc119,	0x6fff, 0xc119,		0x21, 0
	.dw 0x7040, 0xc119,	0x707f, 0xc119,		0x21, 0
	.dw 0x70c0, 0xc119,	0x70ff, 0xc119,		0x21, 0
	.dw 0x7140, 0xc119,	0x717f, 0xc119,		0x21, 0
	.dw 0x71c0, 0xc119,	0x71ff, 0xc119,		0x21, 0
	.dw 0x7240, 0xc119,	0x727f, 0xc119,		0x21, 0
	.dw 0x72c0, 0xc119,	0x72ff, 0xc119,		0x21, 0
	.dw 0x7340, 0xc119,	0x737f, 0xc119,		0x21, 0
	.dw 0x73c0, 0xc119,	0x73ff, 0xc119,		0x21, 0
	.dw 0x7440, 0xc119,	0x747f, 0xc119,		0x21, 0
	.dw 0x74c0, 0xc119,	0x74ff, 0xc119,		0x21, 0
	.dw 0x7540, 0xc119,	0x757f, 0xc119,		0x21, 0
	.dw 0x75c0, 0xc119,	0x75ff, 0xc119,		0x21, 0
	.dw 0x7640, 0xc119,	0x767f, 0xc119,		0x21, 0
	.dw 0x76c0, 0xc119,	0x76ff, 0xc119,		0x21, 0
	.dw 0x7740, 0xc119,	0x777f, 0xc119,		0x21, 0
	.dw 0x77c0, 0xc119,	0x77ff, 0xc119,		0x21, 0
	.dw 0x7840, 0xc119,	0x787f, 0xc119,		0x21, 0
	.dw 0x78c0, 0xc119,	0x78ff, 0xc119,		0x21, 0
	.dw 0x7940, 0xc119,	0x797f, 0xc119,		0x21, 0
	.dw 0x79c0, 0xc119,	0x9fff, 0xc119,		0x21, 0
	.dw 0xa040, 0xc119,	0xa07f, 0xc119,		0x21, 0
	.dw 0xa0c0, 0xc119,	0xa0ff, 0xc119,		0x21, 0
	.dw 0xa140, 0xc119,	0xa17f, 0xc119,		0x21, 0
	.dw 0xa1c0, 0xc119,	0xa1ff, 0xc119,		0x21, 0
	.dw 0xa240, 0xc119,	0xa27f, 0xc119,		0x21, 0
	.dw 0xa2c0, 0xc119,	0xa2ff, 0xc119,		0x21, 0
	.dw 0xa340, 0xc119,	0xa37f, 0xc119,		0x21, 0
	.dw 0xa3c0, 0xc119,	0xa3ff, 0xc119,		0x21, 0
	.dw 0xa440, 0xc119,	0xa47f, 0xc119,		0x21, 0
	.dw 0xa4c0, 0xc119,	0xa4ff, 0xc119,		0x21, 0
	.dw 0xa540, 0xc119,	0xa57f, 0xc119,		0x21, 0
	.dw 0xa5c0, 0xc119,	0xa5ff, 0xc119,		0x21, 0
	.dw 0xa640, 0xc119,	0xa67f, 0xc119,		0x21, 0
	.dw 0xa6c0, 0xc119,	0xa6ff, 0xc119,		0x21, 0
	.dw 0xa740, 0xc119,	0xa77f, 0xc119,		0x21, 0
	.dw 0xa7c0, 0xc119,	0xa7ff, 0xc119,		0x21, 0
	.dw 0xa840, 0xc119,	0xa87f, 0xc119,		0x21, 0
	.dw 0xa8c0, 0xc119,	0xa8ff, 0xc119,		0x21, 0
	.dw 0xa940, 0xc119,	0xa97f, 0xc119,		0x21, 0
	.dw 0xa9c0, 0xc119,	0xa9ff, 0xc119,		0x21, 0
	.dw 0xaa40, 0xc119,	0xaa7f, 0xc119,		0x21, 0
	.dw 0xaac0, 0xc119,	0xaaff, 0xc119,		0x21, 0
	.dw 0xab40, 0xc119,	0xab7f, 0xc119,		0x21, 0
	.dw 0xabc0, 0xc119,	0xabff, 0xc119,		0x21, 0
	.dw 0xac40, 0xc119,	0xac7f, 0xc119,		0x21, 0
	.dw 0xacc0, 0xc119,	0xacff, 0xc119,		0x21, 0
	.dw 0xad40, 0xc119,	0xad7f, 0xc119,		0x21, 0
	.dw 0xadc0, 0xc119,	0xadff, 0xc119,		0x21, 0
	.dw 0xae40, 0xc119,	0xae7f, 0xc119,		0x21, 0
	.dw 0xaec0, 0xc119,	0xaeff, 0xc119,		0x21, 0
	.dw 0xaf40, 0xc119,	0xaf7f, 0xc119,		0x21, 0
	.dw 0xafc0, 0xc119,	0xafff, 0xc119,		0x21, 0
	.dw 0xb040, 0xc119,	0xb07f, 0xc119,		0x21, 0
	.dw 0xb0c0, 0xc119,	0xb0ff, 0xc119,		0x21, 0
	.dw 0xb140, 0xc119,	0xb17f, 0xc119,		0x21, 0
	.dw 0xb1c0, 0xc119,	0xb1ff, 0xc119,		0x21, 0
	.dw 0xb240, 0xc119,	0xb27f, 0xc119,		0x21, 0
	.dw 0xb2c0, 0xc119,	0xb2ff, 0xc119,		0x21, 0
	.dw 0xb340, 0xc119,	0xb37f, 0xc119,		0x21, 0
	.dw 0xb3c0, 0xc119,	0xb3ff, 0xc119,		0x21, 0
	.dw 0xb440, 0xc119,	0xb47f, 0xc119,		0x21, 0
	.dw 0xb4c0, 0xc119,	0xb4ff, 0xc119,		0x21, 0
	.dw 0xb540, 0xc119,	0xb57f, 0xc119,		0x21, 0
	.dw 0xb5c0, 0xc119,	0xb5ff, 0xc119,		0x21, 0
	.dw 0xb640, 0xc119,	0xb67f, 0xc119,		0x21, 0
	.dw 0xb6c0, 0xc119,	0xb6ff, 0xc119,		0x21, 0
	.dw 0xb740, 0xc119,	0xb77f, 0xc119,		0x21, 0
	.dw 0xb7c0, 0xc119,	0xb7ff, 0xc119,		0x21, 0
	.dw 0xb840, 0xc119,	0xb87f, 0xc119,		0x21, 0
	.dw 0xb8c0, 0xc119,	0xb8ff, 0xc119,		0x21, 0
	.dw 0xb940, 0xc119,	0xb97f, 0xc119,		0x21, 0
	.dw 0xb9c0, 0xc119,	0xdfff, 0xc119,		0x21, 0
	.dw 0xe040, 0xc119,	0xe07f, 0xc119,		0x21, 0
	.dw 0xe0c0, 0xc119,	0xe0ff, 0xc119,		0x21, 0
	.dw 0xe140, 0xc119,	0xe17f, 0xc119,		0x21, 0
	.dw 0xe1c0, 0xc119,	0xe1ff, 0xc119,		0x21, 0
	.dw 0xe240, 0xc119,	0xe27f, 0xc119,		0x21, 0
	.dw 0xe2c0, 0xc119,	0xe2ff, 0xc119,		0x21, 0
	.dw 0xe340, 0xc119,	0xe37f, 0xc119,		0x21, 0
	.dw 0xe3c0, 0xc119,	0xe3ff, 0xc119,		0x21, 0
	.dw 0xe440, 0xc119,	0xe47f, 0xc119,		0x21, 0
	.dw 0xe4c0, 0xc119,	0xe4ff, 0xc119,		0x21, 0
	.dw 0xe540, 0xc119,	0xe57f, 0xc119,		0x21, 0
	.dw 0xe5c0, 0xc119,	0xe5ff, 0xc119,		0x21, 0
	.dw 0xe640, 0xc119,	0xe67f, 0xc119,		0x21, 0
	.dw 0xe6c0, 0xc119,	0xe6ff, 0xc119,		0x21, 0
	.dw 0xe740, 0xc119,	0xe77f, 0xc119,		0x21, 0
	.dw 0xe7c0, 0xc119,	0xe7ff, 0xc119,		0x21, 0
	.dw 0xe840, 0xc119,	0xe87f, 0xc119,		0x21, 0
	.dw 0xe8c0, 0xc119,	0xe8ff, 0xc119,		0x21, 0
	.dw 0xe940, 0xc119,	0xe97f, 0xc119,		0x21, 0
	.dw 0xe9c0, 0xc119,	0xe9ff, 0xc119,		0x21, 0
	.dw 0xea40, 0xc119,	0xea7f, 0xc119,		0x21, 0
	.dw 0xeac0, 0xc119,	0xeaff, 0xc119,		0x21, 0
	.dw 0xeb40, 0xc119,	0xeb7f, 0xc119,		0x21, 0
	.dw 0xebc0, 0xc119,	0xebff, 0xc119,		0x21, 0
	.dw 0xec40, 0xc119,	0xec7f, 0xc119,		0x21, 0
	.dw 0xecc0, 0xc119,	0xecff, 0xc119,		0x21, 0
	.dw 0xed40, 0xc119,	0xed7f, 0xc119,		0x21, 0
	.dw 0xedc0, 0xc119,	0xedff, 0xc119,		0x21, 0
	.dw 0xee40, 0xc119,	0xee7f, 0xc119,		0x21, 0
	.dw 0xeec0, 0xc119,	0xeeff, 0xc119,		0x21, 0
	.dw 0xef40, 0xc119,	0xef7f, 0xc119,		0x21, 0
	.dw 0xefc0, 0xc119,	0xefff, 0xc119,		0x21, 0
	.dw 0xf040, 0xc119,	0xf07f, 0xc119,		0x21, 0
	.dw 0xf0c0, 0xc119,	0xf0ff, 0xc119,		0x21, 0
	.dw 0xf140, 0xc119,	0xf17f, 0xc119,		0x21, 0
	.dw 0xf1c0, 0xc119,	0xf1ff, 0xc119,		0x21, 0
	.dw 0xf240, 0xc119,	0xf27f, 0xc119,		0x21, 0
	.dw 0xf2c0, 0xc119,	0xf2ff, 0xc119,		0x21, 0
	.dw 0xf340, 0xc119,	0xf37f, 0xc119,		0x21, 0
	.dw 0xf3c0, 0xc119,	0xf3ff, 0xc119,		0x21, 0
	.dw 0xf440, 0xc119,	0xf47f, 0xc119,		0x21, 0
	.dw 0xf4c0, 0xc119,	0xf4ff, 0xc119,		0x21, 0
	.dw 0xf540, 0xc119,	0xf57f, 0xc119,		0x21, 0
	.dw 0xf5c0, 0xc119,	0xf5ff, 0xc119,		0x21, 0
	.dw 0xf640, 0xc119,	0xf67f, 0xc119,		0x21, 0
	.dw 0xf6c0, 0xc119,	0xf6ff, 0xc119,		0x21, 0
	.dw 0xf740, 0xc119,	0xf77f, 0xc119,		0x21, 0
	.dw 0xf7c0, 0xc119,	0xf7ff, 0xc119,		0x21, 0
	.dw 0xf840, 0xc119,	0xf87f, 0xc119,		0x21, 0
	.dw 0xf8c0, 0xc119,	0xf8ff, 0xc119,		0x21, 0
	.dw 0xf940, 0xc119,	0xf97f, 0xc119,		0x21, 0
	.dw 0xf9c0, 0xc119,	0x1fff, 0xc11a,		0x21, 0
	.dw 0x2040, 0xc11a,	0x207f, 0xc11a,		0x21, 0
	.dw 0x20c0, 0xc11a,	0x20ff, 0xc11a,		0x21, 0
	.dw 0x2140, 0xc11a,	0x217f, 0xc11a,		0x21, 0
	.dw 0x21c0, 0xc11a,	0x21ff, 0xc11a,		0x21, 0
	.dw 0x2240, 0xc11a,	0x227f, 0xc11a,		0x21, 0
	.dw 0x22c0, 0xc11a,	0x22ff, 0xc11a,		0x21, 0
	.dw 0x2340, 0xc11a,	0x237f, 0xc11a,		0x21, 0
	.dw 0x23c0, 0xc11a,	0x23ff, 0xc11a,		0x21, 0
	.dw 0x2440, 0xc11a,	0x247f, 0xc11a,		0x21, 0
	.dw 0x24c0, 0xc11a,	0x24ff, 0xc11a,		0x21, 0
	.dw 0x2540, 0xc11a,	0x257f, 0xc11a,		0x21, 0
	.dw 0x25c0, 0xc11a,	0x25ff, 0xc11a,		0x21, 0
	.dw 0x2640, 0xc11a,	0x267f, 0xc11a,		0x21, 0
	.dw 0x26c0, 0xc11a,	0x26ff, 0xc11a,		0x21, 0
	.dw 0x2740, 0xc11a,	0x277f, 0xc11a,		0x21, 0
	.dw 0x27c0, 0xc11a,	0x27ff, 0xc11a,		0x21, 0
	.dw 0x2840, 0xc11a,	0x287f, 0xc11a,		0x21, 0
	.dw 0x28c0, 0xc11a,	0x28ff, 0xc11a,		0x21, 0
	.dw 0x2940, 0xc11a,	0x297f, 0xc11a,		0x21, 0
	.dw 0x29c0, 0xc11a,	0x29ff, 0xc11a,		0x21, 0
	.dw 0x2a40, 0xc11a,	0x2a7f, 0xc11a,		0x21, 0
	.dw 0x2ac0, 0xc11a,	0x2aff, 0xc11a,		0x21, 0
	.dw 0x2b40, 0xc11a,	0x2b7f, 0xc11a,		0x21, 0
	.dw 0x2bc0, 0xc11a,	0x2bff, 0xc11a,		0x21, 0
	.dw 0x2c40, 0xc11a,	0x2c7f, 0xc11a,		0x21, 0
	.dw 0x2cc0, 0xc11a,	0x2cff, 0xc11a,		0x21, 0
	.dw 0x2d40, 0xc11a,	0x2d7f, 0xc11a,		0x21, 0
	.dw 0x2dc0, 0xc11a,	0x2dff, 0xc11a,		0x21, 0
	.dw 0x2e40, 0xc11a,	0x2e7f, 0xc11a,		0x21, 0
	.dw 0x2ec0, 0xc11a,	0x2eff, 0xc11a,		0x21, 0
	.dw 0x2f40, 0xc11a,	0x2f7f, 0xc11a,		0x21, 0
	.dw 0x2fc0, 0xc11a,	0x2fff, 0xc11a,		0x21, 0
	.dw 0x3040, 0xc11a,	0x307f, 0xc11a,		0x21, 0
	.dw 0x30c0, 0xc11a,	0x30ff, 0xc11a,		0x21, 0
	.dw 0x3140, 0xc11a,	0x317f, 0xc11a,		0x21, 0
	.dw 0x31c0, 0xc11a,	0x31ff, 0xc11a,		0x21, 0
	.dw 0x3240, 0xc11a,	0x327f, 0xc11a,		0x21, 0
	.dw 0x32c0, 0xc11a,	0x32ff, 0xc11a,		0x21, 0
	.dw 0x3340, 0xc11a,	0x337f, 0xc11a,		0x21, 0
	.dw 0x33c0, 0xc11a,	0x33ff, 0xc11a,		0x21, 0
	.dw 0x3440, 0xc11a,	0x347f, 0xc11a,		0x21, 0
	.dw 0x34c0, 0xc11a,	0x34ff, 0xc11a,		0x21, 0
	.dw 0x3540, 0xc11a,	0x357f, 0xc11a,		0x21, 0
	.dw 0x35c0, 0xc11a,	0x35ff, 0xc11a,		0x21, 0
	.dw 0x3640, 0xc11a,	0x367f, 0xc11a,		0x21, 0
	.dw 0x36c0, 0xc11a,	0x36ff, 0xc11a,		0x21, 0
	.dw 0x3740, 0xc11a,	0x377f, 0xc11a,		0x21, 0
	.dw 0x37c0, 0xc11a,	0x37ff, 0xc11a,		0x21, 0
	.dw 0x3840, 0xc11a,	0x387f, 0xc11a,		0x21, 0
	.dw 0x38c0, 0xc11a,	0x38ff, 0xc11a,		0x21, 0
	.dw 0x3940, 0xc11a,	0x397f, 0xc11a,		0x21, 0
	.dw 0x39c0, 0xc11a,	0x5fff, 0xc11a,		0x21, 0
	.dw 0x6040, 0xc11a,	0x607f, 0xc11a,		0x21, 0
	.dw 0x60c0, 0xc11a,	0x60ff, 0xc11a,		0x21, 0
	.dw 0x6140, 0xc11a,	0x617f, 0xc11a,		0x21, 0
	.dw 0x61c0, 0xc11a,	0x61ff, 0xc11a,		0x21, 0
	.dw 0x6240, 0xc11a,	0x627f, 0xc11a,		0x21, 0
	.dw 0x62c0, 0xc11a,	0x62ff, 0xc11a,		0x21, 0
	.dw 0x6340, 0xc11a,	0x637f, 0xc11a,		0x21, 0
	.dw 0x63c0, 0xc11a,	0x63ff, 0xc11a,		0x21, 0
	.dw 0x6440, 0xc11a,	0x647f, 0xc11a,		0x21, 0
	.dw 0x64c0, 0xc11a,	0x64ff, 0xc11a,		0x21, 0
	.dw 0x6540, 0xc11a,	0x657f, 0xc11a,		0x21, 0
	.dw 0x65c0, 0xc11a,	0x65ff, 0xc11a,		0x21, 0
	.dw 0x6640, 0xc11a,	0x667f, 0xc11a,		0x21, 0
	.dw 0x66c0, 0xc11a,	0x66ff, 0xc11a,		0x21, 0
	.dw 0x6740, 0xc11a,	0x677f, 0xc11a,		0x21, 0
	.dw 0x67c0, 0xc11a,	0x67ff, 0xc11a,		0x21, 0
	.dw 0x6840, 0xc11a,	0x687f, 0xc11a,		0x21, 0
	.dw 0x68c0, 0xc11a,	0x68ff, 0xc11a,		0x21, 0
	.dw 0x6940, 0xc11a,	0x697f, 0xc11a,		0x21, 0
	.dw 0x69c0, 0xc11a,	0x69ff, 0xc11a,		0x21, 0
	.dw 0x6a40, 0xc11a,	0x6a7f, 0xc11a,		0x21, 0
	.dw 0x6ac0, 0xc11a,	0x6aff, 0xc11a,		0x21, 0
	.dw 0x6b40, 0xc11a,	0x6b7f, 0xc11a,		0x21, 0
	.dw 0x6bc0, 0xc11a,	0x6bff, 0xc11a,		0x21, 0
	.dw 0x6c40, 0xc11a,	0x6c7f, 0xc11a,		0x21, 0
	.dw 0x6cc0, 0xc11a,	0x6cff, 0xc11a,		0x21, 0
	.dw 0x6d40, 0xc11a,	0x6d7f, 0xc11a,		0x21, 0
	.dw 0x6dc0, 0xc11a,	0x6dff, 0xc11a,		0x21, 0
	.dw 0x6e40, 0xc11a,	0x6e7f, 0xc11a,		0x21, 0
	.dw 0x6ec0, 0xc11a,	0x6eff, 0xc11a,		0x21, 0
	.dw 0x6f40, 0xc11a,	0x6f7f, 0xc11a,		0x21, 0
	.dw 0x6fc0, 0xc11a,	0x6fff, 0xc11a,		0x21, 0
	.dw 0x7040, 0xc11a,	0x707f, 0xc11a,		0x21, 0
	.dw 0x70c0, 0xc11a,	0x70ff, 0xc11a,		0x21, 0
	.dw 0x7140, 0xc11a,	0x717f, 0xc11a,		0x21, 0
	.dw 0x71c0, 0xc11a,	0x71ff, 0xc11a,		0x21, 0
	.dw 0x7240, 0xc11a,	0x727f, 0xc11a,		0x21, 0
	.dw 0x72c0, 0xc11a,	0x72ff, 0xc11a,		0x21, 0
	.dw 0x7340, 0xc11a,	0x737f, 0xc11a,		0x21, 0
	.dw 0x73c0, 0xc11a,	0x73ff, 0xc11a,		0x21, 0
	.dw 0x7440, 0xc11a,	0x747f, 0xc11a,		0x21, 0
	.dw 0x74c0, 0xc11a,	0x74ff, 0xc11a,		0x21, 0
	.dw 0x7540, 0xc11a,	0x757f, 0xc11a,		0x21, 0
	.dw 0x75c0, 0xc11a,	0x75ff, 0xc11a,		0x21, 0
	.dw 0x7640, 0xc11a,	0x767f, 0xc11a,		0x21, 0
	.dw 0x76c0, 0xc11a,	0x76ff, 0xc11a,		0x21, 0
	.dw 0x7740, 0xc11a,	0x777f, 0xc11a,		0x21, 0
	.dw 0x77c0, 0xc11a,	0x77ff, 0xc11a,		0x21, 0
	.dw 0x7840, 0xc11a,	0x787f, 0xc11a,		0x21, 0
	.dw 0x78c0, 0xc11a,	0x78ff, 0xc11a,		0x21, 0
	.dw 0x7940, 0xc11a,	0x797f, 0xc11a,		0x21, 0
	.dw 0x79c0, 0xc11a,	0x9fff, 0xc11a,		0x21, 0
	.dw 0xa040, 0xc11a,	0xa07f, 0xc11a,		0x21, 0
	.dw 0xa0c0, 0xc11a,	0xa0ff, 0xc11a,		0x21, 0
	.dw 0xa140, 0xc11a,	0xa17f, 0xc11a,		0x21, 0
	.dw 0xa1c0, 0xc11a,	0xa1ff, 0xc11a,		0x21, 0
	.dw 0xa240, 0xc11a,	0xa27f, 0xc11a,		0x21, 0
	.dw 0xa2c0, 0xc11a,	0xa2ff, 0xc11a,		0x21, 0
	.dw 0xa340, 0xc11a,	0xa37f, 0xc11a,		0x21, 0
	.dw 0xa3c0, 0xc11a,	0xa3ff, 0xc11a,		0x21, 0
	.dw 0xa440, 0xc11a,	0xa47f, 0xc11a,		0x21, 0
	.dw 0xa4c0, 0xc11a,	0xa4ff, 0xc11a,		0x21, 0
	.dw 0xa540, 0xc11a,	0xa57f, 0xc11a,		0x21, 0
	.dw 0xa5c0, 0xc11a,	0xa5ff, 0xc11a,		0x21, 0
	.dw 0xa640, 0xc11a,	0xa67f, 0xc11a,		0x21, 0
	.dw 0xa6c0, 0xc11a,	0xa6ff, 0xc11a,		0x21, 0
	.dw 0xa740, 0xc11a,	0xa77f, 0xc11a,		0x21, 0
	.dw 0xa7c0, 0xc11a,	0xa7ff, 0xc11a,		0x21, 0
	.dw 0xa840, 0xc11a,	0xa87f, 0xc11a,		0x21, 0
	.dw 0xa8c0, 0xc11a,	0xa8ff, 0xc11a,		0x21, 0
	.dw 0xa940, 0xc11a,	0xa97f, 0xc11a,		0x21, 0
	.dw 0xa9c0, 0xc11a,	0xa9ff, 0xc11a,		0x21, 0
	.dw 0xaa40, 0xc11a,	0xaa7f, 0xc11a,		0x21, 0
	.dw 0xaac0, 0xc11a,	0xaaff, 0xc11a,		0x21, 0
	.dw 0xab40, 0xc11a,	0xab7f, 0xc11a,		0x21, 0
	.dw 0xabc0, 0xc11a,	0xabff, 0xc11a,		0x21, 0
	.dw 0xac40, 0xc11a,	0xac7f, 0xc11a,		0x21, 0
	.dw 0xacc0, 0xc11a,	0xacff, 0xc11a,		0x21, 0
	.dw 0xad40, 0xc11a,	0xad7f, 0xc11a,		0x21, 0
	.dw 0xadc0, 0xc11a,	0xadff, 0xc11a,		0x21, 0
	.dw 0xae40, 0xc11a,	0xae7f, 0xc11a,		0x21, 0
	.dw 0xaec0, 0xc11a,	0xaeff, 0xc11a,		0x21, 0
	.dw 0xaf40, 0xc11a,	0xaf7f, 0xc11a,		0x21, 0
	.dw 0xafc0, 0xc11a,	0xafff, 0xc11a,		0x21, 0
	.dw 0xb040, 0xc11a,	0xb07f, 0xc11a,		0x21, 0
	.dw 0xb0c0, 0xc11a,	0xb0ff, 0xc11a,		0x21, 0
	.dw 0xb140, 0xc11a,	0xb17f, 0xc11a,		0x21, 0
	.dw 0xb1c0, 0xc11a,	0xb1ff, 0xc11a,		0x21, 0
	.dw 0xb240, 0xc11a,	0xb27f, 0xc11a,		0x21, 0
	.dw 0xb2c0, 0xc11a,	0xb2ff, 0xc11a,		0x21, 0
	.dw 0xb340, 0xc11a,	0xb37f, 0xc11a,		0x21, 0
	.dw 0xb3c0, 0xc11a,	0xb3ff, 0xc11a,		0x21, 0
	.dw 0xb440, 0xc11a,	0xb47f, 0xc11a,		0x21, 0
	.dw 0xb4c0, 0xc11a,	0xb4ff, 0xc11a,		0x21, 0
	.dw 0xb540, 0xc11a,	0xb57f, 0xc11a,		0x21, 0
	.dw 0xb5c0, 0xc11a,	0xb5ff, 0xc11a,		0x21, 0
	.dw 0xb640, 0xc11a,	0xb67f, 0xc11a,		0x21, 0
	.dw 0xb6c0, 0xc11a,	0xb6ff, 0xc11a,		0x21, 0
	.dw 0xb740, 0xc11a,	0xb77f, 0xc11a,		0x21, 0
	.dw 0xb7c0, 0xc11a,	0xb7ff, 0xc11a,		0x21, 0
	.dw 0xb840, 0xc11a,	0xb87f, 0xc11a,		0x21, 0
	.dw 0xb8c0, 0xc11a,	0xb8ff, 0xc11a,		0x21, 0
	.dw 0xb940, 0xc11a,	0xb97f, 0xc11a,		0x21, 0
	.dw 0xb9c0, 0xc11a,	0xdfff, 0xc11a,		0x21, 0
	.dw 0xe040, 0xc11a,	0xe07f, 0xc11a,		0x21, 0
	.dw 0xe0c0, 0xc11a,	0xe0ff, 0xc11a,		0x21, 0
	.dw 0xe140, 0xc11a,	0xe17f, 0xc11a,		0x21, 0
	.dw 0xe1c0, 0xc11a,	0xe1ff, 0xc11a,		0x21, 0
	.dw 0xe240, 0xc11a,	0xe27f, 0xc11a,		0x21, 0
	.dw 0xe2c0, 0xc11a,	0xe2ff, 0xc11a,		0x21, 0
	.dw 0xe340, 0xc11a,	0xe37f, 0xc11a,		0x21, 0
	.dw 0xe3c0, 0xc11a,	0xe3ff, 0xc11a,		0x21, 0
	.dw 0xe440, 0xc11a,	0xe47f, 0xc11a,		0x21, 0
	.dw 0xe4c0, 0xc11a,	0xe4ff, 0xc11a,		0x21, 0
	.dw 0xe540, 0xc11a,	0xe57f, 0xc11a,		0x21, 0
	.dw 0xe5c0, 0xc11a,	0xe5ff, 0xc11a,		0x21, 0
	.dw 0xe640, 0xc11a,	0xe67f, 0xc11a,		0x21, 0
	.dw 0xe6c0, 0xc11a,	0xe6ff, 0xc11a,		0x21, 0
	.dw 0xe740, 0xc11a,	0xe77f, 0xc11a,		0x21, 0
	.dw 0xe7c0, 0xc11a,	0xe7ff, 0xc11a,		0x21, 0
	.dw 0xe840, 0xc11a,	0xe87f, 0xc11a,		0x21, 0
	.dw 0xe8c0, 0xc11a,	0xe8ff, 0xc11a,		0x21, 0
	.dw 0xe940, 0xc11a,	0xe97f, 0xc11a,		0x21, 0
	.dw 0xe9c0, 0xc11a,	0xe9ff, 0xc11a,		0x21, 0
	.dw 0xea40, 0xc11a,	0xea7f, 0xc11a,		0x21, 0
	.dw 0xeac0, 0xc11a,	0xeaff, 0xc11a,		0x21, 0
	.dw 0xeb40, 0xc11a,	0xeb7f, 0xc11a,		0x21, 0
	.dw 0xebc0, 0xc11a,	0xebff, 0xc11a,		0x21, 0
	.dw 0xec40, 0xc11a,	0xec7f, 0xc11a,		0x21, 0
	.dw 0xecc0, 0xc11a,	0xecff, 0xc11a,		0x21, 0
	.dw 0xed40, 0xc11a,	0xed7f, 0xc11a,		0x21, 0
	.dw 0xedc0, 0xc11a,	0xedff, 0xc11a,		0x21, 0
	.dw 0xee40, 0xc11a,	0xee7f, 0xc11a,		0x21, 0
	.dw 0xeec0, 0xc11a,	0xeeff, 0xc11a,		0x21, 0
	.dw 0xef40, 0xc11a,	0xef7f, 0xc11a,		0x21, 0
	.dw 0xefc0, 0xc11a,	0xefff, 0xc11a,		0x21, 0
	.dw 0xf040, 0xc11a,	0xf07f, 0xc11a,		0x21, 0
	.dw 0xf0c0, 0xc11a,	0xf0ff, 0xc11a,		0x21, 0
	.dw 0xf140, 0xc11a,	0xf17f, 0xc11a,		0x21, 0
	.dw 0xf1c0, 0xc11a,	0xf1ff, 0xc11a,		0x21, 0
	.dw 0xf240, 0xc11a,	0xf27f, 0xc11a,		0x21, 0
	.dw 0xf2c0, 0xc11a,	0xf2ff, 0xc11a,		0x21, 0
	.dw 0xf340, 0xc11a,	0xf37f, 0xc11a,		0x21, 0
	.dw 0xf3c0, 0xc11a,	0xf3ff, 0xc11a,		0x21, 0
	.dw 0xf440, 0xc11a,	0xf47f, 0xc11a,		0x21, 0
	.dw 0xf4c0, 0xc11a,	0xf4ff, 0xc11a,		0x21, 0
	.dw 0xf540, 0xc11a,	0xf57f, 0xc11a,		0x21, 0
	.dw 0xf5c0, 0xc11a,	0xf5ff, 0xc11a,		0x21, 0
	.dw 0xf640, 0xc11a,	0xf67f, 0xc11a,		0x21, 0
	.dw 0xf6c0, 0xc11a,	0xf6ff, 0xc11a,		0x21, 0
	.dw 0xf740, 0xc11a,	0xf77f, 0xc11a,		0x21, 0
	.dw 0xf7c0, 0xc11a,	0xf7ff, 0xc11a,		0x21, 0
	.dw 0xf840, 0xc11a,	0xf87f, 0xc11a,		0x21, 0
	.dw 0xf8c0, 0xc11a,	0xf8ff, 0xc11a,		0x21, 0
	.dw 0xf940, 0xc11a,	0xf97f, 0xc11a,		0x21, 0
	.dw 0xf9c0, 0xc11a,	0xffff, 0xc11b,		0x21, 0
	.dw 0x0040, 0xc11c,	0x007f, 0xc11c,		0x21, 0
	.dw 0x00c0, 0xc11c,	0x00ff, 0xc11c,		0x21, 0
	.dw 0x0140, 0xc11c,	0x017f, 0xc11c,		0x21, 0
	.dw 0x01c0, 0xc11c,	0x01ff, 0xc11c,		0x21, 0
	.dw 0x0240, 0xc11c,	0x027f, 0xc11c,		0x21, 0
	.dw 0x02c0, 0xc11c,	0x02ff, 0xc11c,		0x21, 0
	.dw 0x0340, 0xc11c,	0x037f, 0xc11c,		0x21, 0
	.dw 0x03c0, 0xc11c,	0x03ff, 0xc11c,		0x21, 0
	.dw 0x0440, 0xc11c,	0x047f, 0xc11c,		0x21, 0
	.dw 0x04c0, 0xc11c,	0x04ff, 0xc11c,		0x21, 0
	.dw 0x0540, 0xc11c,	0x057f, 0xc11c,		0x21, 0
	.dw 0x05c0, 0xc11c,	0x05ff, 0xc11c,		0x21, 0
	.dw 0x0640, 0xc11c,	0x067f, 0xc11c,		0x21, 0
	.dw 0x06c0, 0xc11c,	0x06ff, 0xc11c,		0x21, 0
	.dw 0x0740, 0xc11c,	0x077f, 0xc11c,		0x21, 0
	.dw 0x07c0, 0xc11c,	0x07ff, 0xc11c,		0x21, 0
	.dw 0x0840, 0xc11c,	0x087f, 0xc11c,		0x21, 0
	.dw 0x08c0, 0xc11c,	0x08ff, 0xc11c,		0x21, 0
	.dw 0x0940, 0xc11c,	0x097f, 0xc11c,		0x21, 0
	.dw 0x09c0, 0xc11c,	0x09ff, 0xc11c,		0x21, 0
	.dw 0x0a40, 0xc11c,	0x0a7f, 0xc11c,		0x21, 0
	.dw 0x0ac0, 0xc11c,	0x0aff, 0xc11c,		0x21, 0
	.dw 0x0b40, 0xc11c,	0x0b7f, 0xc11c,		0x21, 0
	.dw 0x0bc0, 0xc11c,	0x0bff, 0xc11c,		0x21, 0
	.dw 0x0c40, 0xc11c,	0x0c7f, 0xc11c,		0x21, 0
	.dw 0x0cc0, 0xc11c,	0x0cff, 0xc11c,		0x21, 0
	.dw 0x0d40, 0xc11c,	0x0d7f, 0xc11c,		0x21, 0
	.dw 0x0dc0, 0xc11c,	0x0dff, 0xc11c,		0x21, 0
	.dw 0x0e40, 0xc11c,	0x0e7f, 0xc11c,		0x21, 0
	.dw 0x0ec0, 0xc11c,	0x0eff, 0xc11c,		0x21, 0
	.dw 0x0f40, 0xc11c,	0x0f7f, 0xc11c,		0x21, 0
	.dw 0x0fc0, 0xc11c,	0x0fff, 0xc11c,		0x21, 0
	.dw 0x1040, 0xc11c,	0x107f, 0xc11c,		0x21, 0
	.dw 0x10c0, 0xc11c,	0x10ff, 0xc11c,		0x21, 0
	.dw 0x1140, 0xc11c,	0x117f, 0xc11c,		0x21, 0
	.dw 0x11c0, 0xc11c,	0x11ff, 0xc11c,		0x21, 0
	.dw 0x1240, 0xc11c,	0x127f, 0xc11c,		0x21, 0
	.dw 0x12c0, 0xc11c,	0x12ff, 0xc11c,		0x21, 0
	.dw 0x1340, 0xc11c,	0x137f, 0xc11c,		0x21, 0
	.dw 0x13c0, 0xc11c,	0x13ff, 0xc11c,		0x21, 0
	.dw 0x1440, 0xc11c,	0x147f, 0xc11c,		0x21, 0
	.dw 0x14c0, 0xc11c,	0x14ff, 0xc11c,		0x21, 0
	.dw 0x1540, 0xc11c,	0x157f, 0xc11c,		0x21, 0
	.dw 0x15c0, 0xc11c,	0x15ff, 0xc11c,		0x21, 0
	.dw 0x1640, 0xc11c,	0x167f, 0xc11c,		0x21, 0
	.dw 0x16c0, 0xc11c,	0x16ff, 0xc11c,		0x21, 0
	.dw 0x1740, 0xc11c,	0x177f, 0xc11c,		0x21, 0
	.dw 0x17c0, 0xc11c,	0x17ff, 0xc11c,		0x21, 0
	.dw 0x1840, 0xc11c,	0x187f, 0xc11c,		0x21, 0
	.dw 0x18c0, 0xc11c,	0x18ff, 0xc11c,		0x21, 0
	.dw 0x1940, 0xc11c,	0x197f, 0xc11c,		0x21, 0
	.dw 0x19c0, 0xc11c,	0x1fff, 0xc11c,		0x21, 0
	.dw 0x2040, 0xc11c,	0x207f, 0xc11c,		0x21, 0
	.dw 0x20c0, 0xc11c,	0x20ff, 0xc11c,		0x21, 0
	.dw 0x2140, 0xc11c,	0x217f, 0xc11c,		0x21, 0
	.dw 0x21c0, 0xc11c,	0x21ff, 0xc11c,		0x21, 0
	.dw 0x2240, 0xc11c,	0x227f, 0xc11c,		0x21, 0
	.dw 0x22c0, 0xc11c,	0x22ff, 0xc11c,		0x21, 0
	.dw 0x2340, 0xc11c,	0x237f, 0xc11c,		0x21, 0
	.dw 0x23c0, 0xc11c,	0x23ff, 0xc11c,		0x21, 0
	.dw 0x2440, 0xc11c,	0x247f, 0xc11c,		0x21, 0
	.dw 0x24c0, 0xc11c,	0x24ff, 0xc11c,		0x21, 0
	.dw 0x2540, 0xc11c,	0x257f, 0xc11c,		0x21, 0
	.dw 0x25c0, 0xc11c,	0x25ff, 0xc11c,		0x21, 0
	.dw 0x2640, 0xc11c,	0x267f, 0xc11c,		0x21, 0
	.dw 0x26c0, 0xc11c,	0x26ff, 0xc11c,		0x21, 0
	.dw 0x2740, 0xc11c,	0x277f, 0xc11c,		0x21, 0
	.dw 0x27c0, 0xc11c,	0x27ff, 0xc11c,		0x21, 0
	.dw 0x2840, 0xc11c,	0x287f, 0xc11c,		0x21, 0
	.dw 0x28c0, 0xc11c,	0x28ff, 0xc11c,		0x21, 0
	.dw 0x2940, 0xc11c,	0x297f, 0xc11c,		0x21, 0
	.dw 0x29c0, 0xc11c,	0x29ff, 0xc11c,		0x21, 0
	.dw 0x2a40, 0xc11c,	0x2a7f, 0xc11c,		0x21, 0
	.dw 0x2ac0, 0xc11c,	0x2aff, 0xc11c,		0x21, 0
	.dw 0x2b40, 0xc11c,	0x2b7f, 0xc11c,		0x21, 0
	.dw 0x2bc0, 0xc11c,	0x2bff, 0xc11c,		0x21, 0
	.dw 0x2c40, 0xc11c,	0x2c7f, 0xc11c,		0x21, 0
	.dw 0x2cc0, 0xc11c,	0x2cff, 0xc11c,		0x21, 0
	.dw 0x2d40, 0xc11c,	0x2d7f, 0xc11c,		0x21, 0
	.dw 0x2dc0, 0xc11c,	0x2dff, 0xc11c,		0x21, 0
	.dw 0x2e40, 0xc11c,	0x2e7f, 0xc11c,		0x21, 0
	.dw 0x2ec0, 0xc11c,	0x2eff, 0xc11c,		0x21, 0
	.dw 0x2f40, 0xc11c,	0x2f7f, 0xc11c,		0x21, 0
	.dw 0x2fc0, 0xc11c,	0x2fff, 0xc11c,		0x21, 0
	.dw 0x3040, 0xc11c,	0x307f, 0xc11c,		0x21, 0
	.dw 0x30c0, 0xc11c,	0x30ff, 0xc11c,		0x21, 0
	.dw 0x3140, 0xc11c,	0x317f, 0xc11c,		0x21, 0
	.dw 0x31c0, 0xc11c,	0x31ff, 0xc11c,		0x21, 0
	.dw 0x3240, 0xc11c,	0x327f, 0xc11c,		0x21, 0
	.dw 0x32c0, 0xc11c,	0x32ff, 0xc11c,		0x21, 0
	.dw 0x3340, 0xc11c,	0x337f, 0xc11c,		0x21, 0
	.dw 0x33c0, 0xc11c,	0x33ff, 0xc11c,		0x21, 0
	.dw 0x3440, 0xc11c,	0x347f, 0xc11c,		0x21, 0
	.dw 0x34c0, 0xc11c,	0x34ff, 0xc11c,		0x21, 0
	.dw 0x3540, 0xc11c,	0x357f, 0xc11c,		0x21, 0
	.dw 0x35c0, 0xc11c,	0x35ff, 0xc11c,		0x21, 0
	.dw 0x3640, 0xc11c,	0x367f, 0xc11c,		0x21, 0
	.dw 0x36c0, 0xc11c,	0x36ff, 0xc11c,		0x21, 0
	.dw 0x3740, 0xc11c,	0x377f, 0xc11c,		0x21, 0
	.dw 0x37c0, 0xc11c,	0x37ff, 0xc11c,		0x21, 0
	.dw 0x3840, 0xc11c,	0x387f, 0xc11c,		0x21, 0
	.dw 0x38c0, 0xc11c,	0x38ff, 0xc11c,		0x21, 0
	.dw 0x3940, 0xc11c,	0x397f, 0xc11c,		0x21, 0
	.dw 0x39c0, 0xc11c,	0x3fff, 0xc11c,		0x21, 0
	.dw 0x4040, 0xc11c,	0x407f, 0xc11c,		0x21, 0
	.dw 0x40c0, 0xc11c,	0x40ff, 0xc11c,		0x21, 0
	.dw 0x4140, 0xc11c,	0x417f, 0xc11c,		0x21, 0
	.dw 0x41c0, 0xc11c,	0x41ff, 0xc11c,		0x21, 0
	.dw 0x4240, 0xc11c,	0x427f, 0xc11c,		0x21, 0
	.dw 0x42c0, 0xc11c,	0x42ff, 0xc11c,		0x21, 0
	.dw 0x4340, 0xc11c,	0x437f, 0xc11c,		0x21, 0
	.dw 0x43c0, 0xc11c,	0x43ff, 0xc11c,		0x21, 0
	.dw 0x4440, 0xc11c,	0x447f, 0xc11c,		0x21, 0
	.dw 0x44c0, 0xc11c,	0x44ff, 0xc11c,		0x21, 0
	.dw 0x4540, 0xc11c,	0x457f, 0xc11c,		0x21, 0
	.dw 0x45c0, 0xc11c,	0x45ff, 0xc11c,		0x21, 0
	.dw 0x4640, 0xc11c,	0x467f, 0xc11c,		0x21, 0
	.dw 0x46c0, 0xc11c,	0x46ff, 0xc11c,		0x21, 0
	.dw 0x4740, 0xc11c,	0x477f, 0xc11c,		0x21, 0
	.dw 0x47c0, 0xc11c,	0x47ff, 0xc11c,		0x21, 0
	.dw 0x4840, 0xc11c,	0x487f, 0xc11c,		0x21, 0
	.dw 0x48c0, 0xc11c,	0x48ff, 0xc11c,		0x21, 0
	.dw 0x4940, 0xc11c,	0x497f, 0xc11c,		0x21, 0
	.dw 0x49c0, 0xc11c,	0x49ff, 0xc11c,		0x21, 0
	.dw 0x4a40, 0xc11c,	0x4a7f, 0xc11c,		0x21, 0
	.dw 0x4ac0, 0xc11c,	0x4aff, 0xc11c,		0x21, 0
	.dw 0x4b40, 0xc11c,	0x4b7f, 0xc11c,		0x21, 0
	.dw 0x4bc0, 0xc11c,	0x4bff, 0xc11c,		0x21, 0
	.dw 0x4c40, 0xc11c,	0x4c7f, 0xc11c,		0x21, 0
	.dw 0x4cc0, 0xc11c,	0x4cff, 0xc11c,		0x21, 0
	.dw 0x4d40, 0xc11c,	0x4d7f, 0xc11c,		0x21, 0
	.dw 0x4dc0, 0xc11c,	0x4dff, 0xc11c,		0x21, 0
	.dw 0x4e40, 0xc11c,	0x4e7f, 0xc11c,		0x21, 0
	.dw 0x4ec0, 0xc11c,	0x4eff, 0xc11c,		0x21, 0
	.dw 0x4f40, 0xc11c,	0x4f7f, 0xc11c,		0x21, 0
	.dw 0x4fc0, 0xc11c,	0x4fff, 0xc11c,		0x21, 0
	.dw 0x5040, 0xc11c,	0x507f, 0xc11c,		0x21, 0
	.dw 0x50c0, 0xc11c,	0x50ff, 0xc11c,		0x21, 0
	.dw 0x5140, 0xc11c,	0x517f, 0xc11c,		0x21, 0
	.dw 0x51c0, 0xc11c,	0x51ff, 0xc11c,		0x21, 0
	.dw 0x5240, 0xc11c,	0x527f, 0xc11c,		0x21, 0
	.dw 0x52c0, 0xc11c,	0x52ff, 0xc11c,		0x21, 0
	.dw 0x5340, 0xc11c,	0x537f, 0xc11c,		0x21, 0
	.dw 0x53c0, 0xc11c,	0x53ff, 0xc11c,		0x21, 0
	.dw 0x5440, 0xc11c,	0x547f, 0xc11c,		0x21, 0
	.dw 0x54c0, 0xc11c,	0x54ff, 0xc11c,		0x21, 0
	.dw 0x5540, 0xc11c,	0x557f, 0xc11c,		0x21, 0
	.dw 0x55c0, 0xc11c,	0x55ff, 0xc11c,		0x21, 0
	.dw 0x5640, 0xc11c,	0x567f, 0xc11c,		0x21, 0
	.dw 0x56c0, 0xc11c,	0x56ff, 0xc11c,		0x21, 0
	.dw 0x5740, 0xc11c,	0x577f, 0xc11c,		0x21, 0
	.dw 0x57c0, 0xc11c,	0x57ff, 0xc11c,		0x21, 0
	.dw 0x5840, 0xc11c,	0x587f, 0xc11c,		0x21, 0
	.dw 0x58c0, 0xc11c,	0x58ff, 0xc11c,		0x21, 0
	.dw 0x5940, 0xc11c,	0x597f, 0xc11c,		0x21, 0
	.dw 0x59c0, 0xc11c,	0x5fff, 0xc11c,		0x21, 0
	.dw 0x6040, 0xc11c,	0x607f, 0xc11c,		0x21, 0
	.dw 0x60c0, 0xc11c,	0x60ff, 0xc11c,		0x21, 0
	.dw 0x6140, 0xc11c,	0x617f, 0xc11c,		0x21, 0
	.dw 0x61c0, 0xc11c,	0x61ff, 0xc11c,		0x21, 0
	.dw 0x6240, 0xc11c,	0x627f, 0xc11c,		0x21, 0
	.dw 0x62c0, 0xc11c,	0x62ff, 0xc11c,		0x21, 0
	.dw 0x6340, 0xc11c,	0x637f, 0xc11c,		0x21, 0
	.dw 0x63c0, 0xc11c,	0x63ff, 0xc11c,		0x21, 0
	.dw 0x6440, 0xc11c,	0x647f, 0xc11c,		0x21, 0
	.dw 0x64c0, 0xc11c,	0x64ff, 0xc11c,		0x21, 0
	.dw 0x6540, 0xc11c,	0x657f, 0xc11c,		0x21, 0
	.dw 0x65c0, 0xc11c,	0x65ff, 0xc11c,		0x21, 0
	.dw 0x6640, 0xc11c,	0x667f, 0xc11c,		0x21, 0
	.dw 0x66c0, 0xc11c,	0x66ff, 0xc11c,		0x21, 0
	.dw 0x6740, 0xc11c,	0x677f, 0xc11c,		0x21, 0
	.dw 0x67c0, 0xc11c,	0x67ff, 0xc11c,		0x21, 0
	.dw 0x6840, 0xc11c,	0x687f, 0xc11c,		0x21, 0
	.dw 0x68c0, 0xc11c,	0x68ff, 0xc11c,		0x21, 0
	.dw 0x6940, 0xc11c,	0x697f, 0xc11c,		0x21, 0
	.dw 0x69c0, 0xc11c,	0x69ff, 0xc11c,		0x21, 0
	.dw 0x6a40, 0xc11c,	0x6a7f, 0xc11c,		0x21, 0
	.dw 0x6ac0, 0xc11c,	0x6aff, 0xc11c,		0x21, 0
	.dw 0x6b40, 0xc11c,	0x6b7f, 0xc11c,		0x21, 0
	.dw 0x6bc0, 0xc11c,	0x6bff, 0xc11c,		0x21, 0
	.dw 0x6c40, 0xc11c,	0x6c7f, 0xc11c,		0x21, 0
	.dw 0x6cc0, 0xc11c,	0x6cff, 0xc11c,		0x21, 0
	.dw 0x6d40, 0xc11c,	0x6d7f, 0xc11c,		0x21, 0
	.dw 0x6dc0, 0xc11c,	0x6dff, 0xc11c,		0x21, 0
	.dw 0x6e40, 0xc11c,	0x6e7f, 0xc11c,		0x21, 0
	.dw 0x6ec0, 0xc11c,	0x6eff, 0xc11c,		0x21, 0
	.dw 0x6f40, 0xc11c,	0x6f7f, 0xc11c,		0x21, 0
	.dw 0x6fc0, 0xc11c,	0x6fff, 0xc11c,		0x21, 0
	.dw 0x7040, 0xc11c,	0x707f, 0xc11c,		0x21, 0
	.dw 0x70c0, 0xc11c,	0x70ff, 0xc11c,		0x21, 0
	.dw 0x7140, 0xc11c,	0x717f, 0xc11c,		0x21, 0
	.dw 0x71c0, 0xc11c,	0x71ff, 0xc11c,		0x21, 0
	.dw 0x7240, 0xc11c,	0x727f, 0xc11c,		0x21, 0
	.dw 0x72c0, 0xc11c,	0x72ff, 0xc11c,		0x21, 0
	.dw 0x7340, 0xc11c,	0x737f, 0xc11c,		0x21, 0
	.dw 0x73c0, 0xc11c,	0x73ff, 0xc11c,		0x21, 0
	.dw 0x7440, 0xc11c,	0x747f, 0xc11c,		0x21, 0
	.dw 0x74c0, 0xc11c,	0x74ff, 0xc11c,		0x21, 0
	.dw 0x7540, 0xc11c,	0x757f, 0xc11c,		0x21, 0
	.dw 0x75c0, 0xc11c,	0x75ff, 0xc11c,		0x21, 0
	.dw 0x7640, 0xc11c,	0x767f, 0xc11c,		0x21, 0
	.dw 0x76c0, 0xc11c,	0x76ff, 0xc11c,		0x21, 0
	.dw 0x7740, 0xc11c,	0x777f, 0xc11c,		0x21, 0
	.dw 0x77c0, 0xc11c,	0x77ff, 0xc11c,		0x21, 0
	.dw 0x7840, 0xc11c,	0x787f, 0xc11c,		0x21, 0
	.dw 0x78c0, 0xc11c,	0x78ff, 0xc11c,		0x21, 0
	.dw 0x7940, 0xc11c,	0x797f, 0xc11c,		0x21, 0
	.dw 0x79c0, 0xc11c,	0x7fff, 0xc11c,		0x21, 0
	.dw 0x8040, 0xc11c,	0x807f, 0xc11c,		0x21, 0
	.dw 0x80c0, 0xc11c,	0x80ff, 0xc11c,		0x21, 0
	.dw 0x8140, 0xc11c,	0x817f, 0xc11c,		0x21, 0
	.dw 0x81c0, 0xc11c,	0x81ff, 0xc11c,		0x21, 0
	.dw 0x8240, 0xc11c,	0x827f, 0xc11c,		0x21, 0
	.dw 0x82c0, 0xc11c,	0x82ff, 0xc11c,		0x21, 0
	.dw 0x8340, 0xc11c,	0x837f, 0xc11c,		0x21, 0
	.dw 0x83c0, 0xc11c,	0x83ff, 0xc11c,		0x21, 0
	.dw 0x8440, 0xc11c,	0x847f, 0xc11c,		0x21, 0
	.dw 0x84c0, 0xc11c,	0x84ff, 0xc11c,		0x21, 0
	.dw 0x8540, 0xc11c,	0x857f, 0xc11c,		0x21, 0
	.dw 0x85c0, 0xc11c,	0x85ff, 0xc11c,		0x21, 0
	.dw 0x8640, 0xc11c,	0x867f, 0xc11c,		0x21, 0
	.dw 0x86c0, 0xc11c,	0x86ff, 0xc11c,		0x21, 0
	.dw 0x8740, 0xc11c,	0x877f, 0xc11c,		0x21, 0
	.dw 0x87c0, 0xc11c,	0x87ff, 0xc11c,		0x21, 0
	.dw 0x8840, 0xc11c,	0x887f, 0xc11c,		0x21, 0
	.dw 0x88c0, 0xc11c,	0x88ff, 0xc11c,		0x21, 0
	.dw 0x8940, 0xc11c,	0x897f, 0xc11c,		0x21, 0
	.dw 0x89c0, 0xc11c,	0x89ff, 0xc11c,		0x21, 0
	.dw 0x8a40, 0xc11c,	0x8a7f, 0xc11c,		0x21, 0
	.dw 0x8ac0, 0xc11c,	0x8aff, 0xc11c,		0x21, 0
	.dw 0x8b40, 0xc11c,	0x8b7f, 0xc11c,		0x21, 0
	.dw 0x8bc0, 0xc11c,	0x8bff, 0xc11c,		0x21, 0
	.dw 0x8c40, 0xc11c,	0x8c7f, 0xc11c,		0x21, 0
	.dw 0x8cc0, 0xc11c,	0x8cff, 0xc11c,		0x21, 0
	.dw 0x8d40, 0xc11c,	0x8d7f, 0xc11c,		0x21, 0
	.dw 0x8dc0, 0xc11c,	0x8dff, 0xc11c,		0x21, 0
	.dw 0x8e40, 0xc11c,	0x8e7f, 0xc11c,		0x21, 0
	.dw 0x8ec0, 0xc11c,	0x8eff, 0xc11c,		0x21, 0
	.dw 0x8f40, 0xc11c,	0x8f7f, 0xc11c,		0x21, 0
	.dw 0x8fc0, 0xc11c,	0x8fff, 0xc11c,		0x21, 0
	.dw 0x9040, 0xc11c,	0x907f, 0xc11c,		0x21, 0
	.dw 0x90c0, 0xc11c,	0x90ff, 0xc11c,		0x21, 0
	.dw 0x9140, 0xc11c,	0x917f, 0xc11c,		0x21, 0
	.dw 0x91c0, 0xc11c,	0x91ff, 0xc11c,		0x21, 0
	.dw 0x9240, 0xc11c,	0x927f, 0xc11c,		0x21, 0
	.dw 0x92c0, 0xc11c,	0x92ff, 0xc11c,		0x21, 0
	.dw 0x9340, 0xc11c,	0x937f, 0xc11c,		0x21, 0
	.dw 0x93c0, 0xc11c,	0x93ff, 0xc11c,		0x21, 0
	.dw 0x9440, 0xc11c,	0x947f, 0xc11c,		0x21, 0
	.dw 0x94c0, 0xc11c,	0x94ff, 0xc11c,		0x21, 0
	.dw 0x9540, 0xc11c,	0x957f, 0xc11c,		0x21, 0
	.dw 0x95c0, 0xc11c,	0x95ff, 0xc11c,		0x21, 0
	.dw 0x9640, 0xc11c,	0x967f, 0xc11c,		0x21, 0
	.dw 0x96c0, 0xc11c,	0x96ff, 0xc11c,		0x21, 0
	.dw 0x9740, 0xc11c,	0x977f, 0xc11c,		0x21, 0
	.dw 0x97c0, 0xc11c,	0x97ff, 0xc11c,		0x21, 0
	.dw 0x9840, 0xc11c,	0x987f, 0xc11c,		0x21, 0
	.dw 0x98c0, 0xc11c,	0x98ff, 0xc11c,		0x21, 0
	.dw 0x9940, 0xc11c,	0x997f, 0xc11c,		0x21, 0
	.dw 0x99c0, 0xc11c,	0x9fff, 0xc11c,		0x21, 0
	.dw 0xa040, 0xc11c,	0xa07f, 0xc11c,		0x21, 0
	.dw 0xa0c0, 0xc11c,	0xa0ff, 0xc11c,		0x21, 0
	.dw 0xa140, 0xc11c,	0xa17f, 0xc11c,		0x21, 0
	.dw 0xa1c0, 0xc11c,	0xa1ff, 0xc11c,		0x21, 0
	.dw 0xa240, 0xc11c,	0xa27f, 0xc11c,		0x21, 0
	.dw 0xa2c0, 0xc11c,	0xa2ff, 0xc11c,		0x21, 0
	.dw 0xa340, 0xc11c,	0xa37f, 0xc11c,		0x21, 0
	.dw 0xa3c0, 0xc11c,	0xa3ff, 0xc11c,		0x21, 0
	.dw 0xa440, 0xc11c,	0xa47f, 0xc11c,		0x21, 0
	.dw 0xa4c0, 0xc11c,	0xa4ff, 0xc11c,		0x21, 0
	.dw 0xa540, 0xc11c,	0xa57f, 0xc11c,		0x21, 0
	.dw 0xa5c0, 0xc11c,	0xa5ff, 0xc11c,		0x21, 0
	.dw 0xa640, 0xc11c,	0xa67f, 0xc11c,		0x21, 0
	.dw 0xa6c0, 0xc11c,	0xa6ff, 0xc11c,		0x21, 0
	.dw 0xa740, 0xc11c,	0xa77f, 0xc11c,		0x21, 0
	.dw 0xa7c0, 0xc11c,	0xa7ff, 0xc11c,		0x21, 0
	.dw 0xa840, 0xc11c,	0xa87f, 0xc11c,		0x21, 0
	.dw 0xa8c0, 0xc11c,	0xa8ff, 0xc11c,		0x21, 0
	.dw 0xa940, 0xc11c,	0xa97f, 0xc11c,		0x21, 0
	.dw 0xa9c0, 0xc11c,	0xa9ff, 0xc11c,		0x21, 0
	.dw 0xaa40, 0xc11c,	0xaa7f, 0xc11c,		0x21, 0
	.dw 0xaac0, 0xc11c,	0xaaff, 0xc11c,		0x21, 0
	.dw 0xab40, 0xc11c,	0xab7f, 0xc11c,		0x21, 0
	.dw 0xabc0, 0xc11c,	0xabff, 0xc11c,		0x21, 0
	.dw 0xac40, 0xc11c,	0xac7f, 0xc11c,		0x21, 0
	.dw 0xacc0, 0xc11c,	0xacff, 0xc11c,		0x21, 0
	.dw 0xad40, 0xc11c,	0xad7f, 0xc11c,		0x21, 0
	.dw 0xadc0, 0xc11c,	0xadff, 0xc11c,		0x21, 0
	.dw 0xae40, 0xc11c,	0xae7f, 0xc11c,		0x21, 0
	.dw 0xaec0, 0xc11c,	0xaeff, 0xc11c,		0x21, 0
	.dw 0xaf40, 0xc11c,	0xaf7f, 0xc11c,		0x21, 0
	.dw 0xafc0, 0xc11c,	0xafff, 0xc11c,		0x21, 0
	.dw 0xb040, 0xc11c,	0xb07f, 0xc11c,		0x21, 0
	.dw 0xb0c0, 0xc11c,	0xb0ff, 0xc11c,		0x21, 0
	.dw 0xb140, 0xc11c,	0xb17f, 0xc11c,		0x21, 0
	.dw 0xb1c0, 0xc11c,	0xb1ff, 0xc11c,		0x21, 0
	.dw 0xb240, 0xc11c,	0xb27f, 0xc11c,		0x21, 0
	.dw 0xb2c0, 0xc11c,	0xb2ff, 0xc11c,		0x21, 0
	.dw 0xb340, 0xc11c,	0xb37f, 0xc11c,		0x21, 0
	.dw 0xb3c0, 0xc11c,	0xb3ff, 0xc11c,		0x21, 0
	.dw 0xb440, 0xc11c,	0xb47f, 0xc11c,		0x21, 0
	.dw 0xb4c0, 0xc11c,	0xb4ff, 0xc11c,		0x21, 0
	.dw 0xb540, 0xc11c,	0xb57f, 0xc11c,		0x21, 0
	.dw 0xb5c0, 0xc11c,	0xb5ff, 0xc11c,		0x21, 0
	.dw 0xb640, 0xc11c,	0xb67f, 0xc11c,		0x21, 0
	.dw 0xb6c0, 0xc11c,	0xb6ff, 0xc11c,		0x21, 0
	.dw 0xb740, 0xc11c,	0xb77f, 0xc11c,		0x21, 0
	.dw 0xb7c0, 0xc11c,	0xb7ff, 0xc11c,		0x21, 0
	.dw 0xb840, 0xc11c,	0xb87f, 0xc11c,		0x21, 0
	.dw 0xb8c0, 0xc11c,	0xb8ff, 0xc11c,		0x21, 0
	.dw 0xb940, 0xc11c,	0xb97f, 0xc11c,		0x21, 0
	.dw 0xb9c0, 0xc11c,	0xbfff, 0xc11c,		0x21, 0
	.dw 0xc040, 0xc11c,	0xc07f, 0xc11c,		0x21, 0
	.dw 0xc0c0, 0xc11c,	0xc0ff, 0xc11c,		0x21, 0
	.dw 0xc140, 0xc11c,	0xc17f, 0xc11c,		0x21, 0
	.dw 0xc1c0, 0xc11c,	0xc1ff, 0xc11c,		0x21, 0
	.dw 0xc240, 0xc11c,	0xc27f, 0xc11c,		0x21, 0
	.dw 0xc2c0, 0xc11c,	0xc2ff, 0xc11c,		0x21, 0
	.dw 0xc340, 0xc11c,	0xc37f, 0xc11c,		0x21, 0
	.dw 0xc3c0, 0xc11c,	0xc3ff, 0xc11c,		0x21, 0
	.dw 0xc440, 0xc11c,	0xc47f, 0xc11c,		0x21, 0
	.dw 0xc4c0, 0xc11c,	0xc4ff, 0xc11c,		0x21, 0
	.dw 0xc540, 0xc11c,	0xc57f, 0xc11c,		0x21, 0
	.dw 0xc5c0, 0xc11c,	0xc5ff, 0xc11c,		0x21, 0
	.dw 0xc640, 0xc11c,	0xc67f, 0xc11c,		0x21, 0
	.dw 0xc6c0, 0xc11c,	0xc6ff, 0xc11c,		0x21, 0
	.dw 0xc740, 0xc11c,	0xc77f, 0xc11c,		0x21, 0
	.dw 0xc7c0, 0xc11c,	0xc7ff, 0xc11c,		0x21, 0
	.dw 0xc840, 0xc11c,	0xc87f, 0xc11c,		0x21, 0
	.dw 0xc8c0, 0xc11c,	0xc8ff, 0xc11c,		0x21, 0
	.dw 0xc940, 0xc11c,	0xc97f, 0xc11c,		0x21, 0
	.dw 0xc9c0, 0xc11c,	0xc9ff, 0xc11c,		0x21, 0
	.dw 0xca40, 0xc11c,	0xca7f, 0xc11c,		0x21, 0
	.dw 0xcac0, 0xc11c,	0xcaff, 0xc11c,		0x21, 0
	.dw 0xcb40, 0xc11c,	0xcb7f, 0xc11c,		0x21, 0
	.dw 0xcbc0, 0xc11c,	0xcbff, 0xc11c,		0x21, 0
	.dw 0xcc40, 0xc11c,	0xcc7f, 0xc11c,		0x21, 0
	.dw 0xccc0, 0xc11c,	0xccff, 0xc11c,		0x21, 0
	.dw 0xcd40, 0xc11c,	0xcd7f, 0xc11c,		0x21, 0
	.dw 0xcdc0, 0xc11c,	0xcdff, 0xc11c,		0x21, 0
	.dw 0xce40, 0xc11c,	0xce7f, 0xc11c,		0x21, 0
	.dw 0xcec0, 0xc11c,	0xceff, 0xc11c,		0x21, 0
	.dw 0xcf40, 0xc11c,	0xcf7f, 0xc11c,		0x21, 0
	.dw 0xcfc0, 0xc11c,	0xcfff, 0xc11c,		0x21, 0
	.dw 0xd040, 0xc11c,	0xd07f, 0xc11c,		0x21, 0
	.dw 0xd0c0, 0xc11c,	0xd0ff, 0xc11c,		0x21, 0
	.dw 0xd140, 0xc11c,	0xd17f, 0xc11c,		0x21, 0
	.dw 0xd1c0, 0xc11c,	0xd1ff, 0xc11c,		0x21, 0
	.dw 0xd240, 0xc11c,	0xd27f, 0xc11c,		0x21, 0
	.dw 0xd2c0, 0xc11c,	0xd2ff, 0xc11c,		0x21, 0
	.dw 0xd340, 0xc11c,	0xd37f, 0xc11c,		0x21, 0
	.dw 0xd3c0, 0xc11c,	0xd3ff, 0xc11c,		0x21, 0
	.dw 0xd440, 0xc11c,	0xd47f, 0xc11c,		0x21, 0
	.dw 0xd4c0, 0xc11c,	0xd4ff, 0xc11c,		0x21, 0
	.dw 0xd540, 0xc11c,	0xd57f, 0xc11c,		0x21, 0
	.dw 0xd5c0, 0xc11c,	0xd5ff, 0xc11c,		0x21, 0
	.dw 0xd640, 0xc11c,	0xd67f, 0xc11c,		0x21, 0
	.dw 0xd6c0, 0xc11c,	0xd6ff, 0xc11c,		0x21, 0
	.dw 0xd740, 0xc11c,	0xd77f, 0xc11c,		0x21, 0
	.dw 0xd7c0, 0xc11c,	0xd7ff, 0xc11c,		0x21, 0
	.dw 0xd840, 0xc11c,	0xd87f, 0xc11c,		0x21, 0
	.dw 0xd8c0, 0xc11c,	0xd8ff, 0xc11c,		0x21, 0
	.dw 0xd940, 0xc11c,	0xd97f, 0xc11c,		0x21, 0
	.dw 0xd9c0, 0xc11c,	0xdfff, 0xc11c,		0x21, 0
	.dw 0xe040, 0xc11c,	0xe07f, 0xc11c,		0x21, 0
	.dw 0xe0c0, 0xc11c,	0xe0ff, 0xc11c,		0x21, 0
	.dw 0xe140, 0xc11c,	0xe17f, 0xc11c,		0x21, 0
	.dw 0xe1c0, 0xc11c,	0xe1ff, 0xc11c,		0x21, 0
	.dw 0xe240, 0xc11c,	0xe27f, 0xc11c,		0x21, 0
	.dw 0xe2c0, 0xc11c,	0xe2ff, 0xc11c,		0x21, 0
	.dw 0xe340, 0xc11c,	0xe37f, 0xc11c,		0x21, 0
	.dw 0xe3c0, 0xc11c,	0xe3ff, 0xc11c,		0x21, 0
	.dw 0xe440, 0xc11c,	0xe47f, 0xc11c,		0x21, 0
	.dw 0xe4c0, 0xc11c,	0xe4ff, 0xc11c,		0x21, 0
	.dw 0xe540, 0xc11c,	0xe57f, 0xc11c,		0x21, 0
	.dw 0xe5c0, 0xc11c,	0xe5ff, 0xc11c,		0x21, 0
	.dw 0xe640, 0xc11c,	0xe67f, 0xc11c,		0x21, 0
	.dw 0xe6c0, 0xc11c,	0xe6ff, 0xc11c,		0x21, 0
	.dw 0xe740, 0xc11c,	0xe77f, 0xc11c,		0x21, 0
	.dw 0xe7c0, 0xc11c,	0xe7ff, 0xc11c,		0x21, 0
	.dw 0xe840, 0xc11c,	0xe87f, 0xc11c,		0x21, 0
	.dw 0xe8c0, 0xc11c,	0xe8ff, 0xc11c,		0x21, 0
	.dw 0xe940, 0xc11c,	0xe97f, 0xc11c,		0x21, 0
	.dw 0xe9c0, 0xc11c,	0xe9ff, 0xc11c,		0x21, 0
	.dw 0xea40, 0xc11c,	0xea7f, 0xc11c,		0x21, 0
	.dw 0xeac0, 0xc11c,	0xeaff, 0xc11c,		0x21, 0
	.dw 0xeb40, 0xc11c,	0xeb7f, 0xc11c,		0x21, 0
	.dw 0xebc0, 0xc11c,	0xebff, 0xc11c,		0x21, 0
	.dw 0xec40, 0xc11c,	0xec7f, 0xc11c,		0x21, 0
	.dw 0xecc0, 0xc11c,	0xecff, 0xc11c,		0x21, 0
	.dw 0xed40, 0xc11c,	0xed7f, 0xc11c,		0x21, 0
	.dw 0xedc0, 0xc11c,	0xedff, 0xc11c,		0x21, 0
	.dw 0xee40, 0xc11c,	0xee7f, 0xc11c,		0x21, 0
	.dw 0xeec0, 0xc11c,	0xeeff, 0xc11c,		0x21, 0
	.dw 0xef40, 0xc11c,	0xef7f, 0xc11c,		0x21, 0
	.dw 0xefc0, 0xc11c,	0xefff, 0xc11c,		0x21, 0
	.dw 0xf040, 0xc11c,	0xf07f, 0xc11c,		0x21, 0
	.dw 0xf0c0, 0xc11c,	0xf0ff, 0xc11c,		0x21, 0
	.dw 0xf140, 0xc11c,	0xf17f, 0xc11c,		0x21, 0
	.dw 0xf1c0, 0xc11c,	0xf1ff, 0xc11c,		0x21, 0
	.dw 0xf240, 0xc11c,	0xf27f, 0xc11c,		0x21, 0
	.dw 0xf2c0, 0xc11c,	0xf2ff, 0xc11c,		0x21, 0
	.dw 0xf340, 0xc11c,	0xf37f, 0xc11c,		0x21, 0
	.dw 0xf3c0, 0xc11c,	0xf3ff, 0xc11c,		0x21, 0
	.dw 0xf440, 0xc11c,	0xf47f, 0xc11c,		0x21, 0
	.dw 0xf4c0, 0xc11c,	0xf4ff, 0xc11c,		0x21, 0
	.dw 0xf540, 0xc11c,	0xf57f, 0xc11c,		0x21, 0
	.dw 0xf5c0, 0xc11c,	0xf5ff, 0xc11c,		0x21, 0
	.dw 0xf640, 0xc11c,	0xf67f, 0xc11c,		0x21, 0
	.dw 0xf6c0, 0xc11c,	0xf6ff, 0xc11c,		0x21, 0
	.dw 0xf740, 0xc11c,	0xf77f, 0xc11c,		0x21, 0
	.dw 0xf7c0, 0xc11c,	0xf7ff, 0xc11c,		0x21, 0
	.dw 0xf840, 0xc11c,	0xf87f, 0xc11c,		0x21, 0
	.dw 0xf8c0, 0xc11c,	0xf8ff, 0xc11c,		0x21, 0
	.dw 0xf940, 0xc11c,	0xf97f, 0xc11c,		0x21, 0
	.dw 0xf9c0, 0xc11c,	0xffff, 0xc11c,		0x21, 0
	.dw 0x0040, 0xc11d,	0x007f, 0xc11d,		0x21, 0
	.dw 0x00c0, 0xc11d,	0x00ff, 0xc11d,		0x21, 0
	.dw 0x0140, 0xc11d,	0x017f, 0xc11d,		0x21, 0
	.dw 0x01c0, 0xc11d,	0x01ff, 0xc11d,		0x21, 0
	.dw 0x0240, 0xc11d,	0x027f, 0xc11d,		0x21, 0
	.dw 0x02c0, 0xc11d,	0x02ff, 0xc11d,		0x21, 0
	.dw 0x0340, 0xc11d,	0x037f, 0xc11d,		0x21, 0
	.dw 0x03c0, 0xc11d,	0x03ff, 0xc11d,		0x21, 0
	.dw 0x0440, 0xc11d,	0x047f, 0xc11d,		0x21, 0
	.dw 0x04c0, 0xc11d,	0x04ff, 0xc11d,		0x21, 0
	.dw 0x0540, 0xc11d,	0x057f, 0xc11d,		0x21, 0
	.dw 0x05c0, 0xc11d,	0x05ff, 0xc11d,		0x21, 0
	.dw 0x0640, 0xc11d,	0x067f, 0xc11d,		0x21, 0
	.dw 0x06c0, 0xc11d,	0x06ff, 0xc11d,		0x21, 0
	.dw 0x0740, 0xc11d,	0x077f, 0xc11d,		0x21, 0
	.dw 0x07c0, 0xc11d,	0x07ff, 0xc11d,		0x21, 0
	.dw 0x0840, 0xc11d,	0x087f, 0xc11d,		0x21, 0
	.dw 0x08c0, 0xc11d,	0x08ff, 0xc11d,		0x21, 0
	.dw 0x0940, 0xc11d,	0x097f, 0xc11d,		0x21, 0
	.dw 0x09c0, 0xc11d,	0x09ff, 0xc11d,		0x21, 0
	.dw 0x0a40, 0xc11d,	0x0a7f, 0xc11d,		0x21, 0
	.dw 0x0ac0, 0xc11d,	0x0aff, 0xc11d,		0x21, 0
	.dw 0x0b40, 0xc11d,	0x0b7f, 0xc11d,		0x21, 0
	.dw 0x0bc0, 0xc11d,	0x0bff, 0xc11d,		0x21, 0
	.dw 0x0c40, 0xc11d,	0x0c7f, 0xc11d,		0x21, 0
	.dw 0x0cc0, 0xc11d,	0x0cff, 0xc11d,		0x21, 0
	.dw 0x0d40, 0xc11d,	0x0d7f, 0xc11d,		0x21, 0
	.dw 0x0dc0, 0xc11d,	0x0dff, 0xc11d,		0x21, 0
	.dw 0x0e40, 0xc11d,	0x0e7f, 0xc11d,		0x21, 0
	.dw 0x0ec0, 0xc11d,	0x0eff, 0xc11d,		0x21, 0
	.dw 0x0f40, 0xc11d,	0x0f7f, 0xc11d,		0x21, 0
	.dw 0x0fc0, 0xc11d,	0x0fff, 0xc11d,		0x21, 0
	.dw 0x1040, 0xc11d,	0x107f, 0xc11d,		0x21, 0
	.dw 0x10c0, 0xc11d,	0x10ff, 0xc11d,		0x21, 0
	.dw 0x1140, 0xc11d,	0x117f, 0xc11d,		0x21, 0
	.dw 0x11c0, 0xc11d,	0x11ff, 0xc11d,		0x21, 0
	.dw 0x1240, 0xc11d,	0x127f, 0xc11d,		0x21, 0
	.dw 0x12c0, 0xc11d,	0x12ff, 0xc11d,		0x21, 0
	.dw 0x1340, 0xc11d,	0x137f, 0xc11d,		0x21, 0
	.dw 0x13c0, 0xc11d,	0x13ff, 0xc11d,		0x21, 0
	.dw 0x1440, 0xc11d,	0x147f, 0xc11d,		0x21, 0
	.dw 0x14c0, 0xc11d,	0x14ff, 0xc11d,		0x21, 0
	.dw 0x1540, 0xc11d,	0x157f, 0xc11d,		0x21, 0
	.dw 0x15c0, 0xc11d,	0x15ff, 0xc11d,		0x21, 0
	.dw 0x1640, 0xc11d,	0x167f, 0xc11d,		0x21, 0
	.dw 0x16c0, 0xc11d,	0x16ff, 0xc11d,		0x21, 0
	.dw 0x1740, 0xc11d,	0x177f, 0xc11d,		0x21, 0
	.dw 0x17c0, 0xc11d,	0x17ff, 0xc11d,		0x21, 0
	.dw 0x1840, 0xc11d,	0x187f, 0xc11d,		0x21, 0
	.dw 0x18c0, 0xc11d,	0x18ff, 0xc11d,		0x21, 0
	.dw 0x1940, 0xc11d,	0x197f, 0xc11d,		0x21, 0
	.dw 0x19c0, 0xc11d,	0x1fff, 0xc11d,		0x21, 0
	.dw 0x2040, 0xc11d,	0x207f, 0xc11d,		0x21, 0
	.dw 0x20c0, 0xc11d,	0x20ff, 0xc11d,		0x21, 0
	.dw 0x2140, 0xc11d,	0x217f, 0xc11d,		0x21, 0
	.dw 0x21c0, 0xc11d,	0x21ff, 0xc11d,		0x21, 0
	.dw 0x2240, 0xc11d,	0x227f, 0xc11d,		0x21, 0
	.dw 0x22c0, 0xc11d,	0x22ff, 0xc11d,		0x21, 0
	.dw 0x2340, 0xc11d,	0x237f, 0xc11d,		0x21, 0
	.dw 0x23c0, 0xc11d,	0x23ff, 0xc11d,		0x21, 0
	.dw 0x2440, 0xc11d,	0x247f, 0xc11d,		0x21, 0
	.dw 0x24c0, 0xc11d,	0x24ff, 0xc11d,		0x21, 0
	.dw 0x2540, 0xc11d,	0x257f, 0xc11d,		0x21, 0
	.dw 0x25c0, 0xc11d,	0x25ff, 0xc11d,		0x21, 0
	.dw 0x2640, 0xc11d,	0x267f, 0xc11d,		0x21, 0
	.dw 0x26c0, 0xc11d,	0x26ff, 0xc11d,		0x21, 0
	.dw 0x2740, 0xc11d,	0x277f, 0xc11d,		0x21, 0
	.dw 0x27c0, 0xc11d,	0x27ff, 0xc11d,		0x21, 0
	.dw 0x2840, 0xc11d,	0x287f, 0xc11d,		0x21, 0
	.dw 0x28c0, 0xc11d,	0x28ff, 0xc11d,		0x21, 0
	.dw 0x2940, 0xc11d,	0x297f, 0xc11d,		0x21, 0
	.dw 0x29c0, 0xc11d,	0x29ff, 0xc11d,		0x21, 0
	.dw 0x2a40, 0xc11d,	0x2a7f, 0xc11d,		0x21, 0
	.dw 0x2ac0, 0xc11d,	0x2aff, 0xc11d,		0x21, 0
	.dw 0x2b40, 0xc11d,	0x2b7f, 0xc11d,		0x21, 0
	.dw 0x2bc0, 0xc11d,	0x2bff, 0xc11d,		0x21, 0
	.dw 0x2c40, 0xc11d,	0x2c7f, 0xc11d,		0x21, 0
	.dw 0x2cc0, 0xc11d,	0x2cff, 0xc11d,		0x21, 0
	.dw 0x2d40, 0xc11d,	0x2d7f, 0xc11d,		0x21, 0
	.dw 0x2dc0, 0xc11d,	0x2dff, 0xc11d,		0x21, 0
	.dw 0x2e40, 0xc11d,	0x2e7f, 0xc11d,		0x21, 0
	.dw 0x2ec0, 0xc11d,	0x2eff, 0xc11d,		0x21, 0
	.dw 0x2f40, 0xc11d,	0x2f7f, 0xc11d,		0x21, 0
	.dw 0x2fc0, 0xc11d,	0x2fff, 0xc11d,		0x21, 0
	.dw 0x3040, 0xc11d,	0x307f, 0xc11d,		0x21, 0
	.dw 0x30c0, 0xc11d,	0x30ff, 0xc11d,		0x21, 0
	.dw 0x3140, 0xc11d,	0x317f, 0xc11d,		0x21, 0
	.dw 0x31c0, 0xc11d,	0x31ff, 0xc11d,		0x21, 0
	.dw 0x3240, 0xc11d,	0x327f, 0xc11d,		0x21, 0
	.dw 0x32c0, 0xc11d,	0x32ff, 0xc11d,		0x21, 0
	.dw 0x3340, 0xc11d,	0x337f, 0xc11d,		0x21, 0
	.dw 0x33c0, 0xc11d,	0x33ff, 0xc11d,		0x21, 0
	.dw 0x3440, 0xc11d,	0x347f, 0xc11d,		0x21, 0
	.dw 0x34c0, 0xc11d,	0x34ff, 0xc11d,		0x21, 0
	.dw 0x3540, 0xc11d,	0x357f, 0xc11d,		0x21, 0
	.dw 0x35c0, 0xc11d,	0x35ff, 0xc11d,		0x21, 0
	.dw 0x3640, 0xc11d,	0x367f, 0xc11d,		0x21, 0
	.dw 0x36c0, 0xc11d,	0x36ff, 0xc11d,		0x21, 0
	.dw 0x3740, 0xc11d,	0x377f, 0xc11d,		0x21, 0
	.dw 0x37c0, 0xc11d,	0x37ff, 0xc11d,		0x21, 0
	.dw 0x3840, 0xc11d,	0x387f, 0xc11d,		0x21, 0
	.dw 0x38c0, 0xc11d,	0x38ff, 0xc11d,		0x21, 0
	.dw 0x3940, 0xc11d,	0x397f, 0xc11d,		0x21, 0
	.dw 0x39c0, 0xc11d,	0x3fff, 0xc11d,		0x21, 0
	.dw 0x4040, 0xc11d,	0x407f, 0xc11d,		0x21, 0
	.dw 0x40c0, 0xc11d,	0x40ff, 0xc11d,		0x21, 0
	.dw 0x4140, 0xc11d,	0x417f, 0xc11d,		0x21, 0
	.dw 0x41c0, 0xc11d,	0x41ff, 0xc11d,		0x21, 0
	.dw 0x4240, 0xc11d,	0x427f, 0xc11d,		0x21, 0
	.dw 0x42c0, 0xc11d,	0x42ff, 0xc11d,		0x21, 0
	.dw 0x4340, 0xc11d,	0x437f, 0xc11d,		0x21, 0
	.dw 0x43c0, 0xc11d,	0x43ff, 0xc11d,		0x21, 0
	.dw 0x4440, 0xc11d,	0x447f, 0xc11d,		0x21, 0
	.dw 0x44c0, 0xc11d,	0x44ff, 0xc11d,		0x21, 0
	.dw 0x4540, 0xc11d,	0x457f, 0xc11d,		0x21, 0
	.dw 0x45c0, 0xc11d,	0x45ff, 0xc11d,		0x21, 0
	.dw 0x4640, 0xc11d,	0x467f, 0xc11d,		0x21, 0
	.dw 0x46c0, 0xc11d,	0x46ff, 0xc11d,		0x21, 0
	.dw 0x4740, 0xc11d,	0x477f, 0xc11d,		0x21, 0
	.dw 0x47c0, 0xc11d,	0x47ff, 0xc11d,		0x21, 0
	.dw 0x4840, 0xc11d,	0x487f, 0xc11d,		0x21, 0
	.dw 0x48c0, 0xc11d,	0x48ff, 0xc11d,		0x21, 0
	.dw 0x4940, 0xc11d,	0x497f, 0xc11d,		0x21, 0
	.dw 0x49c0, 0xc11d,	0x49ff, 0xc11d,		0x21, 0
	.dw 0x4a40, 0xc11d,	0x4a7f, 0xc11d,		0x21, 0
	.dw 0x4ac0, 0xc11d,	0x4aff, 0xc11d,		0x21, 0
	.dw 0x4b40, 0xc11d,	0x4b7f, 0xc11d,		0x21, 0
	.dw 0x4bc0, 0xc11d,	0x4bff, 0xc11d,		0x21, 0
	.dw 0x4c40, 0xc11d,	0x4c7f, 0xc11d,		0x21, 0
	.dw 0x4cc0, 0xc11d,	0x4cff, 0xc11d,		0x21, 0
	.dw 0x4d40, 0xc11d,	0x4d7f, 0xc11d,		0x21, 0
	.dw 0x4dc0, 0xc11d,	0x4dff, 0xc11d,		0x21, 0
	.dw 0x4e40, 0xc11d,	0x4e7f, 0xc11d,		0x21, 0
	.dw 0x4ec0, 0xc11d,	0x4eff, 0xc11d,		0x21, 0
	.dw 0x4f40, 0xc11d,	0x4f7f, 0xc11d,		0x21, 0
	.dw 0x4fc0, 0xc11d,	0x4fff, 0xc11d,		0x21, 0
	.dw 0x5040, 0xc11d,	0x507f, 0xc11d,		0x21, 0
	.dw 0x50c0, 0xc11d,	0x50ff, 0xc11d,		0x21, 0
	.dw 0x5140, 0xc11d,	0x517f, 0xc11d,		0x21, 0
	.dw 0x51c0, 0xc11d,	0x51ff, 0xc11d,		0x21, 0
	.dw 0x5240, 0xc11d,	0x527f, 0xc11d,		0x21, 0
	.dw 0x52c0, 0xc11d,	0x52ff, 0xc11d,		0x21, 0
	.dw 0x5340, 0xc11d,	0x537f, 0xc11d,		0x21, 0
	.dw 0x53c0, 0xc11d,	0x53ff, 0xc11d,		0x21, 0
	.dw 0x5440, 0xc11d,	0x547f, 0xc11d,		0x21, 0
	.dw 0x54c0, 0xc11d,	0x54ff, 0xc11d,		0x21, 0
	.dw 0x5540, 0xc11d,	0x557f, 0xc11d,		0x21, 0
	.dw 0x55c0, 0xc11d,	0x55ff, 0xc11d,		0x21, 0
	.dw 0x5640, 0xc11d,	0x567f, 0xc11d,		0x21, 0
	.dw 0x56c0, 0xc11d,	0x56ff, 0xc11d,		0x21, 0
	.dw 0x5740, 0xc11d,	0x577f, 0xc11d,		0x21, 0
	.dw 0x57c0, 0xc11d,	0x57ff, 0xc11d,		0x21, 0
	.dw 0x5840, 0xc11d,	0x587f, 0xc11d,		0x21, 0
	.dw 0x58c0, 0xc11d,	0x58ff, 0xc11d,		0x21, 0
	.dw 0x5940, 0xc11d,	0x597f, 0xc11d,		0x21, 0
	.dw 0x59c0, 0xc11d,	0x5fff, 0xc11d,		0x21, 0
	.dw 0x6040, 0xc11d,	0x607f, 0xc11d,		0x21, 0
	.dw 0x60c0, 0xc11d,	0x60ff, 0xc11d,		0x21, 0
	.dw 0x6140, 0xc11d,	0x617f, 0xc11d,		0x21, 0
	.dw 0x61c0, 0xc11d,	0x61ff, 0xc11d,		0x21, 0
	.dw 0x6240, 0xc11d,	0x627f, 0xc11d,		0x21, 0
	.dw 0x62c0, 0xc11d,	0x62ff, 0xc11d,		0x21, 0
	.dw 0x6340, 0xc11d,	0x637f, 0xc11d,		0x21, 0
	.dw 0x63c0, 0xc11d,	0x63ff, 0xc11d,		0x21, 0
	.dw 0x6440, 0xc11d,	0x647f, 0xc11d,		0x21, 0
	.dw 0x64c0, 0xc11d,	0x64ff, 0xc11d,		0x21, 0
	.dw 0x6540, 0xc11d,	0x657f, 0xc11d,		0x21, 0
	.dw 0x65c0, 0xc11d,	0x65ff, 0xc11d,		0x21, 0
	.dw 0x6640, 0xc11d,	0x667f, 0xc11d,		0x21, 0
	.dw 0x66c0, 0xc11d,	0x66ff, 0xc11d,		0x21, 0
	.dw 0x6740, 0xc11d,	0x677f, 0xc11d,		0x21, 0
	.dw 0x67c0, 0xc11d,	0x67ff, 0xc11d,		0x21, 0
	.dw 0x6840, 0xc11d,	0x687f, 0xc11d,		0x21, 0
	.dw 0x68c0, 0xc11d,	0x68ff, 0xc11d,		0x21, 0
	.dw 0x6940, 0xc11d,	0x697f, 0xc11d,		0x21, 0
	.dw 0x69c0, 0xc11d,	0x69ff, 0xc11d,		0x21, 0
	.dw 0x6a40, 0xc11d,	0x6a7f, 0xc11d,		0x21, 0
	.dw 0x6ac0, 0xc11d,	0x6aff, 0xc11d,		0x21, 0
	.dw 0x6b40, 0xc11d,	0x6b7f, 0xc11d,		0x21, 0
	.dw 0x6bc0, 0xc11d,	0x6bff, 0xc11d,		0x21, 0
	.dw 0x6c40, 0xc11d,	0x6c7f, 0xc11d,		0x21, 0
	.dw 0x6cc0, 0xc11d,	0x6cff, 0xc11d,		0x21, 0
	.dw 0x6d40, 0xc11d,	0x6d7f, 0xc11d,		0x21, 0
	.dw 0x6dc0, 0xc11d,	0x6dff, 0xc11d,		0x21, 0
	.dw 0x6e40, 0xc11d,	0x6e7f, 0xc11d,		0x21, 0
	.dw 0x6ec0, 0xc11d,	0x6eff, 0xc11d,		0x21, 0
	.dw 0x6f40, 0xc11d,	0x6f7f, 0xc11d,		0x21, 0
	.dw 0x6fc0, 0xc11d,	0x6fff, 0xc11d,		0x21, 0
	.dw 0x7040, 0xc11d,	0x707f, 0xc11d,		0x21, 0
	.dw 0x70c0, 0xc11d,	0x70ff, 0xc11d,		0x21, 0
	.dw 0x7140, 0xc11d,	0x717f, 0xc11d,		0x21, 0
	.dw 0x71c0, 0xc11d,	0x71ff, 0xc11d,		0x21, 0
	.dw 0x7240, 0xc11d,	0x727f, 0xc11d,		0x21, 0
	.dw 0x72c0, 0xc11d,	0x72ff, 0xc11d,		0x21, 0
	.dw 0x7340, 0xc11d,	0x737f, 0xc11d,		0x21, 0
	.dw 0x73c0, 0xc11d,	0x73ff, 0xc11d,		0x21, 0
	.dw 0x7440, 0xc11d,	0x747f, 0xc11d,		0x21, 0
	.dw 0x74c0, 0xc11d,	0x74ff, 0xc11d,		0x21, 0
	.dw 0x7540, 0xc11d,	0x757f, 0xc11d,		0x21, 0
	.dw 0x75c0, 0xc11d,	0x75ff, 0xc11d,		0x21, 0
	.dw 0x7640, 0xc11d,	0x767f, 0xc11d,		0x21, 0
	.dw 0x76c0, 0xc11d,	0x76ff, 0xc11d,		0x21, 0
	.dw 0x7740, 0xc11d,	0x777f, 0xc11d,		0x21, 0
	.dw 0x77c0, 0xc11d,	0x77ff, 0xc11d,		0x21, 0
	.dw 0x7840, 0xc11d,	0x787f, 0xc11d,		0x21, 0
	.dw 0x78c0, 0xc11d,	0x78ff, 0xc11d,		0x21, 0
	.dw 0x7940, 0xc11d,	0x797f, 0xc11d,		0x21, 0
	.dw 0x79c0, 0xc11d,	0x7fff, 0xc11d,		0x21, 0
	.dw 0x8040, 0xc11d,	0x807f, 0xc11d,		0x21, 0
	.dw 0x80c0, 0xc11d,	0x80ff, 0xc11d,		0x21, 0
	.dw 0x8140, 0xc11d,	0x817f, 0xc11d,		0x21, 0
	.dw 0x81c0, 0xc11d,	0x81ff, 0xc11d,		0x21, 0
	.dw 0x8240, 0xc11d,	0x827f, 0xc11d,		0x21, 0
	.dw 0x82c0, 0xc11d,	0x82ff, 0xc11d,		0x21, 0
	.dw 0x8340, 0xc11d,	0x837f, 0xc11d,		0x21, 0
	.dw 0x83c0, 0xc11d,	0x83ff, 0xc11d,		0x21, 0
	.dw 0x8440, 0xc11d,	0x847f, 0xc11d,		0x21, 0
	.dw 0x84c0, 0xc11d,	0x84ff, 0xc11d,		0x21, 0
	.dw 0x8540, 0xc11d,	0x857f, 0xc11d,		0x21, 0
	.dw 0x85c0, 0xc11d,	0x85ff, 0xc11d,		0x21, 0
	.dw 0x8640, 0xc11d,	0x867f, 0xc11d,		0x21, 0
	.dw 0x86c0, 0xc11d,	0x86ff, 0xc11d,		0x21, 0
	.dw 0x8740, 0xc11d,	0x877f, 0xc11d,		0x21, 0
	.dw 0x87c0, 0xc11d,	0x87ff, 0xc11d,		0x21, 0
	.dw 0x8840, 0xc11d,	0x887f, 0xc11d,		0x21, 0
	.dw 0x88c0, 0xc11d,	0x88ff, 0xc11d,		0x21, 0
	.dw 0x8940, 0xc11d,	0x897f, 0xc11d,		0x21, 0
	.dw 0x89c0, 0xc11d,	0x89ff, 0xc11d,		0x21, 0
	.dw 0x8a40, 0xc11d,	0x8a7f, 0xc11d,		0x21, 0
	.dw 0x8ac0, 0xc11d,	0x8aff, 0xc11d,		0x21, 0
	.dw 0x8b40, 0xc11d,	0x8b7f, 0xc11d,		0x21, 0
	.dw 0x8bc0, 0xc11d,	0x8bff, 0xc11d,		0x21, 0
	.dw 0x8c40, 0xc11d,	0x8c7f, 0xc11d,		0x21, 0
	.dw 0x8cc0, 0xc11d,	0x8cff, 0xc11d,		0x21, 0
	.dw 0x8d40, 0xc11d,	0x8d7f, 0xc11d,		0x21, 0
	.dw 0x8dc0, 0xc11d,	0x8dff, 0xc11d,		0x21, 0
	.dw 0x8e40, 0xc11d,	0x8e7f, 0xc11d,		0x21, 0
	.dw 0x8ec0, 0xc11d,	0x8eff, 0xc11d,		0x21, 0
	.dw 0x8f40, 0xc11d,	0x8f7f, 0xc11d,		0x21, 0
	.dw 0x8fc0, 0xc11d,	0x8fff, 0xc11d,		0x21, 0
	.dw 0x9040, 0xc11d,	0x907f, 0xc11d,		0x21, 0
	.dw 0x90c0, 0xc11d,	0x90ff, 0xc11d,		0x21, 0
	.dw 0x9140, 0xc11d,	0x917f, 0xc11d,		0x21, 0
	.dw 0x91c0, 0xc11d,	0x91ff, 0xc11d,		0x21, 0
	.dw 0x9240, 0xc11d,	0x927f, 0xc11d,		0x21, 0
	.dw 0x92c0, 0xc11d,	0x92ff, 0xc11d,		0x21, 0
	.dw 0x9340, 0xc11d,	0x937f, 0xc11d,		0x21, 0
	.dw 0x93c0, 0xc11d,	0x93ff, 0xc11d,		0x21, 0
	.dw 0x9440, 0xc11d,	0x947f, 0xc11d,		0x21, 0
	.dw 0x94c0, 0xc11d,	0x94ff, 0xc11d,		0x21, 0
	.dw 0x9540, 0xc11d,	0x957f, 0xc11d,		0x21, 0
	.dw 0x95c0, 0xc11d,	0x95ff, 0xc11d,		0x21, 0
	.dw 0x9640, 0xc11d,	0x967f, 0xc11d,		0x21, 0
	.dw 0x96c0, 0xc11d,	0x96ff, 0xc11d,		0x21, 0
	.dw 0x9740, 0xc11d,	0x977f, 0xc11d,		0x21, 0
	.dw 0x97c0, 0xc11d,	0x97ff, 0xc11d,		0x21, 0
	.dw 0x9840, 0xc11d,	0x987f, 0xc11d,		0x21, 0
	.dw 0x98c0, 0xc11d,	0x98ff, 0xc11d,		0x21, 0
	.dw 0x9940, 0xc11d,	0x997f, 0xc11d,		0x21, 0
	.dw 0x99c0, 0xc11d,	0x9fff, 0xc11d,		0x21, 0
	.dw 0xa040, 0xc11d,	0xa07f, 0xc11d,		0x21, 0
	.dw 0xa0c0, 0xc11d,	0xa0ff, 0xc11d,		0x21, 0
	.dw 0xa140, 0xc11d,	0xa17f, 0xc11d,		0x21, 0
	.dw 0xa1c0, 0xc11d,	0xa1ff, 0xc11d,		0x21, 0
	.dw 0xa240, 0xc11d,	0xa27f, 0xc11d,		0x21, 0
	.dw 0xa2c0, 0xc11d,	0xa2ff, 0xc11d,		0x21, 0
	.dw 0xa340, 0xc11d,	0xa37f, 0xc11d,		0x21, 0
	.dw 0xa3c0, 0xc11d,	0xa3ff, 0xc11d,		0x21, 0
	.dw 0xa440, 0xc11d,	0xa47f, 0xc11d,		0x21, 0
	.dw 0xa4c0, 0xc11d,	0xa4ff, 0xc11d,		0x21, 0
	.dw 0xa540, 0xc11d,	0xa57f, 0xc11d,		0x21, 0
	.dw 0xa5c0, 0xc11d,	0xa5ff, 0xc11d,		0x21, 0
	.dw 0xa640, 0xc11d,	0xa67f, 0xc11d,		0x21, 0
	.dw 0xa6c0, 0xc11d,	0xa6ff, 0xc11d,		0x21, 0
	.dw 0xa740, 0xc11d,	0xa77f, 0xc11d,		0x21, 0
	.dw 0xa7c0, 0xc11d,	0xa7ff, 0xc11d,		0x21, 0
	.dw 0xa840, 0xc11d,	0xa87f, 0xc11d,		0x21, 0
	.dw 0xa8c0, 0xc11d,	0xa8ff, 0xc11d,		0x21, 0
	.dw 0xa940, 0xc11d,	0xa97f, 0xc11d,		0x21, 0
	.dw 0xa9c0, 0xc11d,	0xa9ff, 0xc11d,		0x21, 0
	.dw 0xaa40, 0xc11d,	0xaa7f, 0xc11d,		0x21, 0
	.dw 0xaac0, 0xc11d,	0xaaff, 0xc11d,		0x21, 0
	.dw 0xab40, 0xc11d,	0xab7f, 0xc11d,		0x21, 0
	.dw 0xabc0, 0xc11d,	0xabff, 0xc11d,		0x21, 0
	.dw 0xac40, 0xc11d,	0xac7f, 0xc11d,		0x21, 0
	.dw 0xacc0, 0xc11d,	0xacff, 0xc11d,		0x21, 0
	.dw 0xad40, 0xc11d,	0xad7f, 0xc11d,		0x21, 0
	.dw 0xadc0, 0xc11d,	0xadff, 0xc11d,		0x21, 0
	.dw 0xae40, 0xc11d,	0xae7f, 0xc11d,		0x21, 0
	.dw 0xaec0, 0xc11d,	0xaeff, 0xc11d,		0x21, 0
	.dw 0xaf40, 0xc11d,	0xaf7f, 0xc11d,		0x21, 0
	.dw 0xafc0, 0xc11d,	0xafff, 0xc11d,		0x21, 0
	.dw 0xb040, 0xc11d,	0xb07f, 0xc11d,		0x21, 0
	.dw 0xb0c0, 0xc11d,	0xb0ff, 0xc11d,		0x21, 0
	.dw 0xb140, 0xc11d,	0xb17f, 0xc11d,		0x21, 0
	.dw 0xb1c0, 0xc11d,	0xb1ff, 0xc11d,		0x21, 0
	.dw 0xb240, 0xc11d,	0xb27f, 0xc11d,		0x21, 0
	.dw 0xb2c0, 0xc11d,	0xb2ff, 0xc11d,		0x21, 0
	.dw 0xb340, 0xc11d,	0xb37f, 0xc11d,		0x21, 0
	.dw 0xb3c0, 0xc11d,	0xb3ff, 0xc11d,		0x21, 0
	.dw 0xb440, 0xc11d,	0xb47f, 0xc11d,		0x21, 0
	.dw 0xb4c0, 0xc11d,	0xb4ff, 0xc11d,		0x21, 0
	.dw 0xb540, 0xc11d,	0xb57f, 0xc11d,		0x21, 0
	.dw 0xb5c0, 0xc11d,	0xb5ff, 0xc11d,		0x21, 0
	.dw 0xb640, 0xc11d,	0xb67f, 0xc11d,		0x21, 0
	.dw 0xb6c0, 0xc11d,	0xb6ff, 0xc11d,		0x21, 0
	.dw 0xb740, 0xc11d,	0xb77f, 0xc11d,		0x21, 0
	.dw 0xb7c0, 0xc11d,	0xb7ff, 0xc11d,		0x21, 0
	.dw 0xb840, 0xc11d,	0xb87f, 0xc11d,		0x21, 0
	.dw 0xb8c0, 0xc11d,	0xb8ff, 0xc11d,		0x21, 0
	.dw 0xb940, 0xc11d,	0xb97f, 0xc11d,		0x21, 0
	.dw 0xb9c0, 0xc11d,	0xbfff, 0xc11d,		0x21, 0
	.dw 0xc040, 0xc11d,	0xc07f, 0xc11d,		0x21, 0
	.dw 0xc0c0, 0xc11d,	0xc0ff, 0xc11d,		0x21, 0
	.dw 0xc140, 0xc11d,	0xc17f, 0xc11d,		0x21, 0
	.dw 0xc1c0, 0xc11d,	0xc1ff, 0xc11d,		0x21, 0
	.dw 0xc240, 0xc11d,	0xc27f, 0xc11d,		0x21, 0
	.dw 0xc2c0, 0xc11d,	0xc2ff, 0xc11d,		0x21, 0
	.dw 0xc340, 0xc11d,	0xc37f, 0xc11d,		0x21, 0
	.dw 0xc3c0, 0xc11d,	0xc3ff, 0xc11d,		0x21, 0
	.dw 0xc440, 0xc11d,	0xc47f, 0xc11d,		0x21, 0
	.dw 0xc4c0, 0xc11d,	0xc4ff, 0xc11d,		0x21, 0
	.dw 0xc540, 0xc11d,	0xc57f, 0xc11d,		0x21, 0
	.dw 0xc5c0, 0xc11d,	0xc5ff, 0xc11d,		0x21, 0
	.dw 0xc640, 0xc11d,	0xc67f, 0xc11d,		0x21, 0
	.dw 0xc6c0, 0xc11d,	0xc6ff, 0xc11d,		0x21, 0
	.dw 0xc740, 0xc11d,	0xc77f, 0xc11d,		0x21, 0
	.dw 0xc7c0, 0xc11d,	0xc7ff, 0xc11d,		0x21, 0
	.dw 0xc840, 0xc11d,	0xc87f, 0xc11d,		0x21, 0
	.dw 0xc8c0, 0xc11d,	0xc8ff, 0xc11d,		0x21, 0
	.dw 0xc940, 0xc11d,	0xc97f, 0xc11d,		0x21, 0
	.dw 0xc9c0, 0xc11d,	0xc9ff, 0xc11d,		0x21, 0
	.dw 0xca40, 0xc11d,	0xca7f, 0xc11d,		0x21, 0
	.dw 0xcac0, 0xc11d,	0xcaff, 0xc11d,		0x21, 0
	.dw 0xcb40, 0xc11d,	0xcb7f, 0xc11d,		0x21, 0
	.dw 0xcbc0, 0xc11d,	0xcbff, 0xc11d,		0x21, 0
	.dw 0xcc40, 0xc11d,	0xcc7f, 0xc11d,		0x21, 0
	.dw 0xccc0, 0xc11d,	0xccff, 0xc11d,		0x21, 0
	.dw 0xcd40, 0xc11d,	0xcd7f, 0xc11d,		0x21, 0
	.dw 0xcdc0, 0xc11d,	0xcdff, 0xc11d,		0x21, 0
	.dw 0xce40, 0xc11d,	0xce7f, 0xc11d,		0x21, 0
	.dw 0xcec0, 0xc11d,	0xceff, 0xc11d,		0x21, 0
	.dw 0xcf40, 0xc11d,	0xcf7f, 0xc11d,		0x21, 0
	.dw 0xcfc0, 0xc11d,	0xcfff, 0xc11d,		0x21, 0
	.dw 0xd040, 0xc11d,	0xd07f, 0xc11d,		0x21, 0
	.dw 0xd0c0, 0xc11d,	0xd0ff, 0xc11d,		0x21, 0
	.dw 0xd140, 0xc11d,	0xd17f, 0xc11d,		0x21, 0
	.dw 0xd1c0, 0xc11d,	0xd1ff, 0xc11d,		0x21, 0
	.dw 0xd240, 0xc11d,	0xd27f, 0xc11d,		0x21, 0
	.dw 0xd2c0, 0xc11d,	0xd2ff, 0xc11d,		0x21, 0
	.dw 0xd340, 0xc11d,	0xd37f, 0xc11d,		0x21, 0
	.dw 0xd3c0, 0xc11d,	0xd3ff, 0xc11d,		0x21, 0
	.dw 0xd440, 0xc11d,	0xd47f, 0xc11d,		0x21, 0
	.dw 0xd4c0, 0xc11d,	0xd4ff, 0xc11d,		0x21, 0
	.dw 0xd540, 0xc11d,	0xd57f, 0xc11d,		0x21, 0
	.dw 0xd5c0, 0xc11d,	0xd5ff, 0xc11d,		0x21, 0
	.dw 0xd640, 0xc11d,	0xd67f, 0xc11d,		0x21, 0
	.dw 0xd6c0, 0xc11d,	0xd6ff, 0xc11d,		0x21, 0
	.dw 0xd740, 0xc11d,	0xd77f, 0xc11d,		0x21, 0
	.dw 0xd7c0, 0xc11d,	0xd7ff, 0xc11d,		0x21, 0
	.dw 0xd840, 0xc11d,	0xd87f, 0xc11d,		0x21, 0
	.dw 0xd8c0, 0xc11d,	0xd8ff, 0xc11d,		0x21, 0
	.dw 0xd940, 0xc11d,	0xd97f, 0xc11d,		0x21, 0
	.dw 0xd9c0, 0xc11d,	0xdfff, 0xc11d,		0x21, 0
	.dw 0xe040, 0xc11d,	0xe07f, 0xc11d,		0x21, 0
	.dw 0xe0c0, 0xc11d,	0xe0ff, 0xc11d,		0x21, 0
	.dw 0xe140, 0xc11d,	0xe17f, 0xc11d,		0x21, 0
	.dw 0xe1c0, 0xc11d,	0xe1ff, 0xc11d,		0x21, 0
	.dw 0xe240, 0xc11d,	0xe27f, 0xc11d,		0x21, 0
	.dw 0xe2c0, 0xc11d,	0xe2ff, 0xc11d,		0x21, 0
	.dw 0xe340, 0xc11d,	0xe37f, 0xc11d,		0x21, 0
	.dw 0xe3c0, 0xc11d,	0xe3ff, 0xc11d,		0x21, 0
	.dw 0xe440, 0xc11d,	0xe47f, 0xc11d,		0x21, 0
	.dw 0xe4c0, 0xc11d,	0xe4ff, 0xc11d,		0x21, 0
	.dw 0xe540, 0xc11d,	0xe57f, 0xc11d,		0x21, 0
	.dw 0xe5c0, 0xc11d,	0xe5ff, 0xc11d,		0x21, 0
	.dw 0xe640, 0xc11d,	0xe67f, 0xc11d,		0x21, 0
	.dw 0xe6c0, 0xc11d,	0xe6ff, 0xc11d,		0x21, 0
	.dw 0xe740, 0xc11d,	0xe77f, 0xc11d,		0x21, 0
	.dw 0xe7c0, 0xc11d,	0xe7ff, 0xc11d,		0x21, 0
	.dw 0xe840, 0xc11d,	0xe87f, 0xc11d,		0x21, 0
	.dw 0xe8c0, 0xc11d,	0xe8ff, 0xc11d,		0x21, 0
	.dw 0xe940, 0xc11d,	0xe97f, 0xc11d,		0x21, 0
	.dw 0xe9c0, 0xc11d,	0xe9ff, 0xc11d,		0x21, 0
	.dw 0xea40, 0xc11d,	0xea7f, 0xc11d,		0x21, 0
	.dw 0xeac0, 0xc11d,	0xeaff, 0xc11d,		0x21, 0
	.dw 0xeb40, 0xc11d,	0xeb7f, 0xc11d,		0x21, 0
	.dw 0xebc0, 0xc11d,	0xebff, 0xc11d,		0x21, 0
	.dw 0xec40, 0xc11d,	0xec7f, 0xc11d,		0x21, 0
	.dw 0xecc0, 0xc11d,	0xecff, 0xc11d,		0x21, 0
	.dw 0xed40, 0xc11d,	0xed7f, 0xc11d,		0x21, 0
	.dw 0xedc0, 0xc11d,	0xedff, 0xc11d,		0x21, 0
	.dw 0xee40, 0xc11d,	0xee7f, 0xc11d,		0x21, 0
	.dw 0xeec0, 0xc11d,	0xeeff, 0xc11d,		0x21, 0
	.dw 0xef40, 0xc11d,	0xef7f, 0xc11d,		0x21, 0
	.dw 0xefc0, 0xc11d,	0xefff, 0xc11d,		0x21, 0
	.dw 0xf040, 0xc11d,	0xf07f, 0xc11d,		0x21, 0
	.dw 0xf0c0, 0xc11d,	0xf0ff, 0xc11d,		0x21, 0
	.dw 0xf140, 0xc11d,	0xf17f, 0xc11d,		0x21, 0
	.dw 0xf1c0, 0xc11d,	0xf1ff, 0xc11d,		0x21, 0
	.dw 0xf240, 0xc11d,	0xf27f, 0xc11d,		0x21, 0
	.dw 0xf2c0, 0xc11d,	0xf2ff, 0xc11d,		0x21, 0
	.dw 0xf340, 0xc11d,	0xf37f, 0xc11d,		0x21, 0
	.dw 0xf3c0, 0xc11d,	0xf3ff, 0xc11d,		0x21, 0
	.dw 0xf440, 0xc11d,	0xf47f, 0xc11d,		0x21, 0
	.dw 0xf4c0, 0xc11d,	0xf4ff, 0xc11d,		0x21, 0
	.dw 0xf540, 0xc11d,	0xf57f, 0xc11d,		0x21, 0
	.dw 0xf5c0, 0xc11d,	0xf5ff, 0xc11d,		0x21, 0
	.dw 0xf640, 0xc11d,	0xf67f, 0xc11d,		0x21, 0
	.dw 0xf6c0, 0xc11d,	0xf6ff, 0xc11d,		0x21, 0
	.dw 0xf740, 0xc11d,	0xf77f, 0xc11d,		0x21, 0
	.dw 0xf7c0, 0xc11d,	0xf7ff, 0xc11d,		0x21, 0
	.dw 0xf840, 0xc11d,	0xf87f, 0xc11d,		0x21, 0
	.dw 0xf8c0, 0xc11d,	0xf8ff, 0xc11d,		0x21, 0
	.dw 0xf940, 0xc11d,	0xf97f, 0xc11d,		0x21, 0
	.dw 0xf9c0, 0xc11d,	0xffff, 0xc11d,		0x21, 0
	.dw 0x0040, 0xc11e,	0x007f, 0xc11e,		0x21, 0
	.dw 0x00c0, 0xc11e,	0x00ff, 0xc11e,		0x21, 0
	.dw 0x0140, 0xc11e,	0x017f, 0xc11e,		0x21, 0
	.dw 0x01c0, 0xc11e,	0x01ff, 0xc11e,		0x21, 0
	.dw 0x0240, 0xc11e,	0x027f, 0xc11e,		0x21, 0
	.dw 0x02c0, 0xc11e,	0x02ff, 0xc11e,		0x21, 0
	.dw 0x0340, 0xc11e,	0x037f, 0xc11e,		0x21, 0
	.dw 0x03c0, 0xc11e,	0x03ff, 0xc11e,		0x21, 0
	.dw 0x0440, 0xc11e,	0x047f, 0xc11e,		0x21, 0
	.dw 0x04c0, 0xc11e,	0x04ff, 0xc11e,		0x21, 0
	.dw 0x0540, 0xc11e,	0x057f, 0xc11e,		0x21, 0
	.dw 0x05c0, 0xc11e,	0x05ff, 0xc11e,		0x21, 0
	.dw 0x0640, 0xc11e,	0x067f, 0xc11e,		0x21, 0
	.dw 0x06c0, 0xc11e,	0x06ff, 0xc11e,		0x21, 0
	.dw 0x0740, 0xc11e,	0x077f, 0xc11e,		0x21, 0
	.dw 0x07c0, 0xc11e,	0x07ff, 0xc11e,		0x21, 0
	.dw 0x0840, 0xc11e,	0x087f, 0xc11e,		0x21, 0
	.dw 0x08c0, 0xc11e,	0x08ff, 0xc11e,		0x21, 0
	.dw 0x0940, 0xc11e,	0x097f, 0xc11e,		0x21, 0
	.dw 0x09c0, 0xc11e,	0x09ff, 0xc11e,		0x21, 0
	.dw 0x0a40, 0xc11e,	0x0a7f, 0xc11e,		0x21, 0
	.dw 0x0ac0, 0xc11e,	0x0aff, 0xc11e,		0x21, 0
	.dw 0x0b40, 0xc11e,	0x0b7f, 0xc11e,		0x21, 0
	.dw 0x0bc0, 0xc11e,	0x0bff, 0xc11e,		0x21, 0
	.dw 0x0c40, 0xc11e,	0x0c7f, 0xc11e,		0x21, 0
	.dw 0x0cc0, 0xc11e,	0x0cff, 0xc11e,		0x21, 0
	.dw 0x0d40, 0xc11e,	0x0d7f, 0xc11e,		0x21, 0
	.dw 0x0dc0, 0xc11e,	0x0dff, 0xc11e,		0x21, 0
	.dw 0x0e40, 0xc11e,	0x0e7f, 0xc11e,		0x21, 0
	.dw 0x0ec0, 0xc11e,	0x0eff, 0xc11e,		0x21, 0
	.dw 0x0f40, 0xc11e,	0x0f7f, 0xc11e,		0x21, 0
	.dw 0x0fc0, 0xc11e,	0x0fff, 0xc11e,		0x21, 0
	.dw 0x1040, 0xc11e,	0x107f, 0xc11e,		0x21, 0
	.dw 0x10c0, 0xc11e,	0x10ff, 0xc11e,		0x21, 0
	.dw 0x1140, 0xc11e,	0x117f, 0xc11e,		0x21, 0
	.dw 0x11c0, 0xc11e,	0x11ff, 0xc11e,		0x21, 0
	.dw 0x1240, 0xc11e,	0x127f, 0xc11e,		0x21, 0
	.dw 0x12c0, 0xc11e,	0x12ff, 0xc11e,		0x21, 0
	.dw 0x1340, 0xc11e,	0x137f, 0xc11e,		0x21, 0
	.dw 0x13c0, 0xc11e,	0x13ff, 0xc11e,		0x21, 0
	.dw 0x1440, 0xc11e,	0x147f, 0xc11e,		0x21, 0
	.dw 0x14c0, 0xc11e,	0x14ff, 0xc11e,		0x21, 0
	.dw 0x1540, 0xc11e,	0x157f, 0xc11e,		0x21, 0
	.dw 0x15c0, 0xc11e,	0x15ff, 0xc11e,		0x21, 0
	.dw 0x1640, 0xc11e,	0x167f, 0xc11e,		0x21, 0
	.dw 0x16c0, 0xc11e,	0x16ff, 0xc11e,		0x21, 0
	.dw 0x1740, 0xc11e,	0x177f, 0xc11e,		0x21, 0
	.dw 0x17c0, 0xc11e,	0x17ff, 0xc11e,		0x21, 0
	.dw 0x1840, 0xc11e,	0x187f, 0xc11e,		0x21, 0
	.dw 0x18c0, 0xc11e,	0x18ff, 0xc11e,		0x21, 0
	.dw 0x1940, 0xc11e,	0x197f, 0xc11e,		0x21, 0
	.dw 0x19c0, 0xc11e,	0x1fff, 0xc11e,		0x21, 0
	.dw 0x2040, 0xc11e,	0x207f, 0xc11e,		0x21, 0
	.dw 0x20c0, 0xc11e,	0x20ff, 0xc11e,		0x21, 0
	.dw 0x2140, 0xc11e,	0x217f, 0xc11e,		0x21, 0
	.dw 0x21c0, 0xc11e,	0x21ff, 0xc11e,		0x21, 0
	.dw 0x2240, 0xc11e,	0x227f, 0xc11e,		0x21, 0
	.dw 0x22c0, 0xc11e,	0x22ff, 0xc11e,		0x21, 0
	.dw 0x2340, 0xc11e,	0x237f, 0xc11e,		0x21, 0
	.dw 0x23c0, 0xc11e,	0x23ff, 0xc11e,		0x21, 0
	.dw 0x2440, 0xc11e,	0x247f, 0xc11e,		0x21, 0
	.dw 0x24c0, 0xc11e,	0x24ff, 0xc11e,		0x21, 0
	.dw 0x2540, 0xc11e,	0x257f, 0xc11e,		0x21, 0
	.dw 0x25c0, 0xc11e,	0x25ff, 0xc11e,		0x21, 0
	.dw 0x2640, 0xc11e,	0x267f, 0xc11e,		0x21, 0
	.dw 0x26c0, 0xc11e,	0x26ff, 0xc11e,		0x21, 0
	.dw 0x2740, 0xc11e,	0x277f, 0xc11e,		0x21, 0
	.dw 0x27c0, 0xc11e,	0x27ff, 0xc11e,		0x21, 0
	.dw 0x2840, 0xc11e,	0x287f, 0xc11e,		0x21, 0
	.dw 0x28c0, 0xc11e,	0x28ff, 0xc11e,		0x21, 0
	.dw 0x2940, 0xc11e,	0x297f, 0xc11e,		0x21, 0
	.dw 0x29c0, 0xc11e,	0x29ff, 0xc11e,		0x21, 0
	.dw 0x2a40, 0xc11e,	0x2a7f, 0xc11e,		0x21, 0
	.dw 0x2ac0, 0xc11e,	0x2aff, 0xc11e,		0x21, 0
	.dw 0x2b40, 0xc11e,	0x2b7f, 0xc11e,		0x21, 0
	.dw 0x2bc0, 0xc11e,	0x2bff, 0xc11e,		0x21, 0
	.dw 0x2c40, 0xc11e,	0x2c7f, 0xc11e,		0x21, 0
	.dw 0x2cc0, 0xc11e,	0x2cff, 0xc11e,		0x21, 0
	.dw 0x2d40, 0xc11e,	0x2d7f, 0xc11e,		0x21, 0
	.dw 0x2dc0, 0xc11e,	0x2dff, 0xc11e,		0x21, 0
	.dw 0x2e40, 0xc11e,	0x2e7f, 0xc11e,		0x21, 0
	.dw 0x2ec0, 0xc11e,	0x2eff, 0xc11e,		0x21, 0
	.dw 0x2f40, 0xc11e,	0x2f7f, 0xc11e,		0x21, 0
	.dw 0x2fc0, 0xc11e,	0x2fff, 0xc11e,		0x21, 0
	.dw 0x3040, 0xc11e,	0x307f, 0xc11e,		0x21, 0
	.dw 0x30c0, 0xc11e,	0x30ff, 0xc11e,		0x21, 0
	.dw 0x3140, 0xc11e,	0x317f, 0xc11e,		0x21, 0
	.dw 0x31c0, 0xc11e,	0x31ff, 0xc11e,		0x21, 0
	.dw 0x3240, 0xc11e,	0x327f, 0xc11e,		0x21, 0
	.dw 0x32c0, 0xc11e,	0x32ff, 0xc11e,		0x21, 0
	.dw 0x3340, 0xc11e,	0x337f, 0xc11e,		0x21, 0
	.dw 0x33c0, 0xc11e,	0x33ff, 0xc11e,		0x21, 0
	.dw 0x3440, 0xc11e,	0x347f, 0xc11e,		0x21, 0
	.dw 0x34c0, 0xc11e,	0x34ff, 0xc11e,		0x21, 0
	.dw 0x3540, 0xc11e,	0x357f, 0xc11e,		0x21, 0
	.dw 0x35c0, 0xc11e,	0x35ff, 0xc11e,		0x21, 0
	.dw 0x3640, 0xc11e,	0x367f, 0xc11e,		0x21, 0
	.dw 0x36c0, 0xc11e,	0x36ff, 0xc11e,		0x21, 0
	.dw 0x3740, 0xc11e,	0x377f, 0xc11e,		0x21, 0
	.dw 0x37c0, 0xc11e,	0x37ff, 0xc11e,		0x21, 0
	.dw 0x3840, 0xc11e,	0x387f, 0xc11e,		0x21, 0
	.dw 0x38c0, 0xc11e,	0x38ff, 0xc11e,		0x21, 0
	.dw 0x3940, 0xc11e,	0x397f, 0xc11e,		0x21, 0
	.dw 0x39c0, 0xc11e,	0x3fff, 0xc11e,		0x21, 0
	.dw 0x4040, 0xc11e,	0x407f, 0xc11e,		0x21, 0
	.dw 0x40c0, 0xc11e,	0x40ff, 0xc11e,		0x21, 0
	.dw 0x4140, 0xc11e,	0x417f, 0xc11e,		0x21, 0
	.dw 0x41c0, 0xc11e,	0x41ff, 0xc11e,		0x21, 0
	.dw 0x4240, 0xc11e,	0x427f, 0xc11e,		0x21, 0
	.dw 0x42c0, 0xc11e,	0x42ff, 0xc11e,		0x21, 0
	.dw 0x4340, 0xc11e,	0x437f, 0xc11e,		0x21, 0
	.dw 0x43c0, 0xc11e,	0x43ff, 0xc11e,		0x21, 0
	.dw 0x4440, 0xc11e,	0x447f, 0xc11e,		0x21, 0
	.dw 0x44c0, 0xc11e,	0x44ff, 0xc11e,		0x21, 0
	.dw 0x4540, 0xc11e,	0x457f, 0xc11e,		0x21, 0
	.dw 0x45c0, 0xc11e,	0x45ff, 0xc11e,		0x21, 0
	.dw 0x4640, 0xc11e,	0x467f, 0xc11e,		0x21, 0
	.dw 0x46c0, 0xc11e,	0x46ff, 0xc11e,		0x21, 0
	.dw 0x4740, 0xc11e,	0x477f, 0xc11e,		0x21, 0
	.dw 0x47c0, 0xc11e,	0x47ff, 0xc11e,		0x21, 0
	.dw 0x4840, 0xc11e,	0x487f, 0xc11e,		0x21, 0
	.dw 0x48c0, 0xc11e,	0x48ff, 0xc11e,		0x21, 0
	.dw 0x4940, 0xc11e,	0x497f, 0xc11e,		0x21, 0
	.dw 0x49c0, 0xc11e,	0x49ff, 0xc11e,		0x21, 0
	.dw 0x4a40, 0xc11e,	0x4a7f, 0xc11e,		0x21, 0
	.dw 0x4ac0, 0xc11e,	0x4aff, 0xc11e,		0x21, 0
	.dw 0x4b40, 0xc11e,	0x4b7f, 0xc11e,		0x21, 0
	.dw 0x4bc0, 0xc11e,	0x4bff, 0xc11e,		0x21, 0
	.dw 0x4c40, 0xc11e,	0x4c7f, 0xc11e,		0x21, 0
	.dw 0x4cc0, 0xc11e,	0x4cff, 0xc11e,		0x21, 0
	.dw 0x4d40, 0xc11e,	0x4d7f, 0xc11e,		0x21, 0
	.dw 0x4dc0, 0xc11e,	0x4dff, 0xc11e,		0x21, 0
	.dw 0x4e40, 0xc11e,	0x4e7f, 0xc11e,		0x21, 0
	.dw 0x4ec0, 0xc11e,	0x4eff, 0xc11e,		0x21, 0
	.dw 0x4f40, 0xc11e,	0x4f7f, 0xc11e,		0x21, 0
	.dw 0x4fc0, 0xc11e,	0x4fff, 0xc11e,		0x21, 0
	.dw 0x5040, 0xc11e,	0x507f, 0xc11e,		0x21, 0
	.dw 0x50c0, 0xc11e,	0x50ff, 0xc11e,		0x21, 0
	.dw 0x5140, 0xc11e,	0x517f, 0xc11e,		0x21, 0
	.dw 0x51c0, 0xc11e,	0x51ff, 0xc11e,		0x21, 0
	.dw 0x5240, 0xc11e,	0x527f, 0xc11e,		0x21, 0
	.dw 0x52c0, 0xc11e,	0x52ff, 0xc11e,		0x21, 0
	.dw 0x5340, 0xc11e,	0x537f, 0xc11e,		0x21, 0
	.dw 0x53c0, 0xc11e,	0x53ff, 0xc11e,		0x21, 0
	.dw 0x5440, 0xc11e,	0x547f, 0xc11e,		0x21, 0
	.dw 0x54c0, 0xc11e,	0x54ff, 0xc11e,		0x21, 0
	.dw 0x5540, 0xc11e,	0x557f, 0xc11e,		0x21, 0
	.dw 0x55c0, 0xc11e,	0x55ff, 0xc11e,		0x21, 0
	.dw 0x5640, 0xc11e,	0x567f, 0xc11e,		0x21, 0
	.dw 0x56c0, 0xc11e,	0x56ff, 0xc11e,		0x21, 0
	.dw 0x5740, 0xc11e,	0x577f, 0xc11e,		0x21, 0
	.dw 0x57c0, 0xc11e,	0x57ff, 0xc11e,		0x21, 0
	.dw 0x5840, 0xc11e,	0x587f, 0xc11e,		0x21, 0
	.dw 0x58c0, 0xc11e,	0x58ff, 0xc11e,		0x21, 0
	.dw 0x5940, 0xc11e,	0x597f, 0xc11e,		0x21, 0
	.dw 0x59c0, 0xc11e,	0x5fff, 0xc11e,		0x21, 0
	.dw 0x6040, 0xc11e,	0x607f, 0xc11e,		0x21, 0
	.dw 0x60c0, 0xc11e,	0x60ff, 0xc11e,		0x21, 0
	.dw 0x6140, 0xc11e,	0x617f, 0xc11e,		0x21, 0
	.dw 0x61c0, 0xc11e,	0x61ff, 0xc11e,		0x21, 0
	.dw 0x6240, 0xc11e,	0x627f, 0xc11e,		0x21, 0
	.dw 0x62c0, 0xc11e,	0x62ff, 0xc11e,		0x21, 0
	.dw 0x6340, 0xc11e,	0x637f, 0xc11e,		0x21, 0
	.dw 0x63c0, 0xc11e,	0x63ff, 0xc11e,		0x21, 0
	.dw 0x6440, 0xc11e,	0x647f, 0xc11e,		0x21, 0
	.dw 0x64c0, 0xc11e,	0x64ff, 0xc11e,		0x21, 0
	.dw 0x6540, 0xc11e,	0x657f, 0xc11e,		0x21, 0
	.dw 0x65c0, 0xc11e,	0x65ff, 0xc11e,		0x21, 0
	.dw 0x6640, 0xc11e,	0x667f, 0xc11e,		0x21, 0
	.dw 0x66c0, 0xc11e,	0x66ff, 0xc11e,		0x21, 0
	.dw 0x6740, 0xc11e,	0x677f, 0xc11e,		0x21, 0
	.dw 0x67c0, 0xc11e,	0x67ff, 0xc11e,		0x21, 0
	.dw 0x6840, 0xc11e,	0x687f, 0xc11e,		0x21, 0
	.dw 0x68c0, 0xc11e,	0x68ff, 0xc11e,		0x21, 0
	.dw 0x6940, 0xc11e,	0x697f, 0xc11e,		0x21, 0
	.dw 0x69c0, 0xc11e,	0x69ff, 0xc11e,		0x21, 0
	.dw 0x6a40, 0xc11e,	0x6a7f, 0xc11e,		0x21, 0
	.dw 0x6ac0, 0xc11e,	0x6aff, 0xc11e,		0x21, 0
	.dw 0x6b40, 0xc11e,	0x6b7f, 0xc11e,		0x21, 0
	.dw 0x6bc0, 0xc11e,	0x6bff, 0xc11e,		0x21, 0
	.dw 0x6c40, 0xc11e,	0x6c7f, 0xc11e,		0x21, 0
	.dw 0x6cc0, 0xc11e,	0x6cff, 0xc11e,		0x21, 0
	.dw 0x6d40, 0xc11e,	0x6d7f, 0xc11e,		0x21, 0
	.dw 0x6dc0, 0xc11e,	0x6dff, 0xc11e,		0x21, 0
	.dw 0x6e40, 0xc11e,	0x6e7f, 0xc11e,		0x21, 0
	.dw 0x6ec0, 0xc11e,	0x6eff, 0xc11e,		0x21, 0
	.dw 0x6f40, 0xc11e,	0x6f7f, 0xc11e,		0x21, 0
	.dw 0x6fc0, 0xc11e,	0x6fff, 0xc11e,		0x21, 0
	.dw 0x7040, 0xc11e,	0x707f, 0xc11e,		0x21, 0
	.dw 0x70c0, 0xc11e,	0x70ff, 0xc11e,		0x21, 0
	.dw 0x7140, 0xc11e,	0x717f, 0xc11e,		0x21, 0
	.dw 0x71c0, 0xc11e,	0x71ff, 0xc11e,		0x21, 0
	.dw 0x7240, 0xc11e,	0x727f, 0xc11e,		0x21, 0
	.dw 0x72c0, 0xc11e,	0x72ff, 0xc11e,		0x21, 0
	.dw 0x7340, 0xc11e,	0x737f, 0xc11e,		0x21, 0
	.dw 0x73c0, 0xc11e,	0x73ff, 0xc11e,		0x21, 0
	.dw 0x7440, 0xc11e,	0x747f, 0xc11e,		0x21, 0
	.dw 0x74c0, 0xc11e,	0x74ff, 0xc11e,		0x21, 0
	.dw 0x7540, 0xc11e,	0x757f, 0xc11e,		0x21, 0
	.dw 0x75c0, 0xc11e,	0x75ff, 0xc11e,		0x21, 0
	.dw 0x7640, 0xc11e,	0x767f, 0xc11e,		0x21, 0
	.dw 0x76c0, 0xc11e,	0x76ff, 0xc11e,		0x21, 0
	.dw 0x7740, 0xc11e,	0x777f, 0xc11e,		0x21, 0
	.dw 0x77c0, 0xc11e,	0x77ff, 0xc11e,		0x21, 0
	.dw 0x7840, 0xc11e,	0x787f, 0xc11e,		0x21, 0
	.dw 0x78c0, 0xc11e,	0x78ff, 0xc11e,		0x21, 0
	.dw 0x7940, 0xc11e,	0x797f, 0xc11e,		0x21, 0
	.dw 0x79c0, 0xc11e,	0x7fff, 0xc11e,		0x21, 0
	.dw 0x8040, 0xc11e,	0x807f, 0xc11e,		0x21, 0
	.dw 0x80c0, 0xc11e,	0x80ff, 0xc11e,		0x21, 0
	.dw 0x8140, 0xc11e,	0x817f, 0xc11e,		0x21, 0
	.dw 0x81c0, 0xc11e,	0x81ff, 0xc11e,		0x21, 0
	.dw 0x8240, 0xc11e,	0x827f, 0xc11e,		0x21, 0
	.dw 0x82c0, 0xc11e,	0x82ff, 0xc11e,		0x21, 0
	.dw 0x8340, 0xc11e,	0x837f, 0xc11e,		0x21, 0
	.dw 0x83c0, 0xc11e,	0x83ff, 0xc11e,		0x21, 0
	.dw 0x8440, 0xc11e,	0x847f, 0xc11e,		0x21, 0
	.dw 0x84c0, 0xc11e,	0x84ff, 0xc11e,		0x21, 0
	.dw 0x8540, 0xc11e,	0x857f, 0xc11e,		0x21, 0
	.dw 0x85c0, 0xc11e,	0x85ff, 0xc11e,		0x21, 0
	.dw 0x8640, 0xc11e,	0x867f, 0xc11e,		0x21, 0
	.dw 0x86c0, 0xc11e,	0x86ff, 0xc11e,		0x21, 0
	.dw 0x8740, 0xc11e,	0x877f, 0xc11e,		0x21, 0
	.dw 0x87c0, 0xc11e,	0x87ff, 0xc11e,		0x21, 0
	.dw 0x8840, 0xc11e,	0x887f, 0xc11e,		0x21, 0
	.dw 0x88c0, 0xc11e,	0x88ff, 0xc11e,		0x21, 0
	.dw 0x8940, 0xc11e,	0x897f, 0xc11e,		0x21, 0
	.dw 0x89c0, 0xc11e,	0x89ff, 0xc11e,		0x21, 0
	.dw 0x8a40, 0xc11e,	0x8a7f, 0xc11e,		0x21, 0
	.dw 0x8ac0, 0xc11e,	0x8aff, 0xc11e,		0x21, 0
	.dw 0x8b40, 0xc11e,	0x8b7f, 0xc11e,		0x21, 0
	.dw 0x8bc0, 0xc11e,	0x8bff, 0xc11e,		0x21, 0
	.dw 0x8c40, 0xc11e,	0x8c7f, 0xc11e,		0x21, 0
	.dw 0x8cc0, 0xc11e,	0x8cff, 0xc11e,		0x21, 0
	.dw 0x8d40, 0xc11e,	0x8d7f, 0xc11e,		0x21, 0
	.dw 0x8dc0, 0xc11e,	0x8dff, 0xc11e,		0x21, 0
	.dw 0x8e40, 0xc11e,	0x8e7f, 0xc11e,		0x21, 0
	.dw 0x8ec0, 0xc11e,	0x8eff, 0xc11e,		0x21, 0
	.dw 0x8f40, 0xc11e,	0x8f7f, 0xc11e,		0x21, 0
	.dw 0x8fc0, 0xc11e,	0x8fff, 0xc11e,		0x21, 0
	.dw 0x9040, 0xc11e,	0x907f, 0xc11e,		0x21, 0
	.dw 0x90c0, 0xc11e,	0x90ff, 0xc11e,		0x21, 0
	.dw 0x9140, 0xc11e,	0x917f, 0xc11e,		0x21, 0
	.dw 0x91c0, 0xc11e,	0x91ff, 0xc11e,		0x21, 0
	.dw 0x9240, 0xc11e,	0x927f, 0xc11e,		0x21, 0
	.dw 0x92c0, 0xc11e,	0x92ff, 0xc11e,		0x21, 0
	.dw 0x9340, 0xc11e,	0x937f, 0xc11e,		0x21, 0
	.dw 0x93c0, 0xc11e,	0x93ff, 0xc11e,		0x21, 0
	.dw 0x9440, 0xc11e,	0x947f, 0xc11e,		0x21, 0
	.dw 0x94c0, 0xc11e,	0x94ff, 0xc11e,		0x21, 0
	.dw 0x9540, 0xc11e,	0x957f, 0xc11e,		0x21, 0
	.dw 0x95c0, 0xc11e,	0x95ff, 0xc11e,		0x21, 0
	.dw 0x9640, 0xc11e,	0x967f, 0xc11e,		0x21, 0
	.dw 0x96c0, 0xc11e,	0x96ff, 0xc11e,		0x21, 0
	.dw 0x9740, 0xc11e,	0x977f, 0xc11e,		0x21, 0
	.dw 0x97c0, 0xc11e,	0x97ff, 0xc11e,		0x21, 0
	.dw 0x9840, 0xc11e,	0x987f, 0xc11e,		0x21, 0
	.dw 0x98c0, 0xc11e,	0x98ff, 0xc11e,		0x21, 0
	.dw 0x9940, 0xc11e,	0x997f, 0xc11e,		0x21, 0
	.dw 0x99c0, 0xc11e,	0x9fff, 0xc11e,		0x21, 0
	.dw 0xa040, 0xc11e,	0xa07f, 0xc11e,		0x21, 0
	.dw 0xa0c0, 0xc11e,	0xa0ff, 0xc11e,		0x21, 0
	.dw 0xa140, 0xc11e,	0xa17f, 0xc11e,		0x21, 0
	.dw 0xa1c0, 0xc11e,	0xa1ff, 0xc11e,		0x21, 0
	.dw 0xa240, 0xc11e,	0xa27f, 0xc11e,		0x21, 0
	.dw 0xa2c0, 0xc11e,	0xa2ff, 0xc11e,		0x21, 0
	.dw 0xa340, 0xc11e,	0xa37f, 0xc11e,		0x21, 0
	.dw 0xa3c0, 0xc11e,	0xa3ff, 0xc11e,		0x21, 0
	.dw 0xa440, 0xc11e,	0xa47f, 0xc11e,		0x21, 0
	.dw 0xa4c0, 0xc11e,	0xa4ff, 0xc11e,		0x21, 0
	.dw 0xa540, 0xc11e,	0xa57f, 0xc11e,		0x21, 0
	.dw 0xa5c0, 0xc11e,	0xa5ff, 0xc11e,		0x21, 0
	.dw 0xa640, 0xc11e,	0xa67f, 0xc11e,		0x21, 0
	.dw 0xa6c0, 0xc11e,	0xa6ff, 0xc11e,		0x21, 0
	.dw 0xa740, 0xc11e,	0xa77f, 0xc11e,		0x21, 0
	.dw 0xa7c0, 0xc11e,	0xa7ff, 0xc11e,		0x21, 0
	.dw 0xa840, 0xc11e,	0xa87f, 0xc11e,		0x21, 0
	.dw 0xa8c0, 0xc11e,	0xa8ff, 0xc11e,		0x21, 0
	.dw 0xa940, 0xc11e,	0xa97f, 0xc11e,		0x21, 0
	.dw 0xa9c0, 0xc11e,	0xa9ff, 0xc11e,		0x21, 0
	.dw 0xaa40, 0xc11e,	0xaa7f, 0xc11e,		0x21, 0
	.dw 0xaac0, 0xc11e,	0xaaff, 0xc11e,		0x21, 0
	.dw 0xab40, 0xc11e,	0xab7f, 0xc11e,		0x21, 0
	.dw 0xabc0, 0xc11e,	0xabff, 0xc11e,		0x21, 0
	.dw 0xac40, 0xc11e,	0xac7f, 0xc11e,		0x21, 0
	.dw 0xacc0, 0xc11e,	0xacff, 0xc11e,		0x21, 0
	.dw 0xad40, 0xc11e,	0xad7f, 0xc11e,		0x21, 0
	.dw 0xadc0, 0xc11e,	0xadff, 0xc11e,		0x21, 0
	.dw 0xae40, 0xc11e,	0xae7f, 0xc11e,		0x21, 0
	.dw 0xaec0, 0xc11e,	0xaeff, 0xc11e,		0x21, 0
	.dw 0xaf40, 0xc11e,	0xaf7f, 0xc11e,		0x21, 0
	.dw 0xafc0, 0xc11e,	0xafff, 0xc11e,		0x21, 0
	.dw 0xb040, 0xc11e,	0xb07f, 0xc11e,		0x21, 0
	.dw 0xb0c0, 0xc11e,	0xb0ff, 0xc11e,		0x21, 0
	.dw 0xb140, 0xc11e,	0xb17f, 0xc11e,		0x21, 0
	.dw 0xb1c0, 0xc11e,	0xb1ff, 0xc11e,		0x21, 0
	.dw 0xb240, 0xc11e,	0xb27f, 0xc11e,		0x21, 0
	.dw 0xb2c0, 0xc11e,	0xb2ff, 0xc11e,		0x21, 0
	.dw 0xb340, 0xc11e,	0xb37f, 0xc11e,		0x21, 0
	.dw 0xb3c0, 0xc11e,	0xb3ff, 0xc11e,		0x21, 0
	.dw 0xb440, 0xc11e,	0xb47f, 0xc11e,		0x21, 0
	.dw 0xb4c0, 0xc11e,	0xb4ff, 0xc11e,		0x21, 0
	.dw 0xb540, 0xc11e,	0xb57f, 0xc11e,		0x21, 0
	.dw 0xb5c0, 0xc11e,	0xb5ff, 0xc11e,		0x21, 0
	.dw 0xb640, 0xc11e,	0xb67f, 0xc11e,		0x21, 0
	.dw 0xb6c0, 0xc11e,	0xb6ff, 0xc11e,		0x21, 0
	.dw 0xb740, 0xc11e,	0xb77f, 0xc11e,		0x21, 0
	.dw 0xb7c0, 0xc11e,	0xb7ff, 0xc11e,		0x21, 0
	.dw 0xb840, 0xc11e,	0xb87f, 0xc11e,		0x21, 0
	.dw 0xb8c0, 0xc11e,	0xb8ff, 0xc11e,		0x21, 0
	.dw 0xb940, 0xc11e,	0xb97f, 0xc11e,		0x21, 0
	.dw 0xb9c0, 0xc11e,	0xbfff, 0xc11e,		0x21, 0
	.dw 0xc040, 0xc11e,	0xc07f, 0xc11e,		0x21, 0
	.dw 0xc0c0, 0xc11e,	0xc0ff, 0xc11e,		0x21, 0
	.dw 0xc140, 0xc11e,	0xc17f, 0xc11e,		0x21, 0
	.dw 0xc1c0, 0xc11e,	0xc1ff, 0xc11e,		0x21, 0
	.dw 0xc240, 0xc11e,	0xc27f, 0xc11e,		0x21, 0
	.dw 0xc2c0, 0xc11e,	0xc2ff, 0xc11e,		0x21, 0
	.dw 0xc340, 0xc11e,	0xc37f, 0xc11e,		0x21, 0
	.dw 0xc3c0, 0xc11e,	0xc3ff, 0xc11e,		0x21, 0
	.dw 0xc440, 0xc11e,	0xc47f, 0xc11e,		0x21, 0
	.dw 0xc4c0, 0xc11e,	0xc4ff, 0xc11e,		0x21, 0
	.dw 0xc540, 0xc11e,	0xc57f, 0xc11e,		0x21, 0
	.dw 0xc5c0, 0xc11e,	0xc5ff, 0xc11e,		0x21, 0
	.dw 0xc640, 0xc11e,	0xc67f, 0xc11e,		0x21, 0
	.dw 0xc6c0, 0xc11e,	0xc6ff, 0xc11e,		0x21, 0
	.dw 0xc740, 0xc11e,	0xc77f, 0xc11e,		0x21, 0
	.dw 0xc7c0, 0xc11e,	0xc7ff, 0xc11e,		0x21, 0
	.dw 0xc840, 0xc11e,	0xc87f, 0xc11e,		0x21, 0
	.dw 0xc8c0, 0xc11e,	0xc8ff, 0xc11e,		0x21, 0
	.dw 0xc940, 0xc11e,	0xc97f, 0xc11e,		0x21, 0
	.dw 0xc9c0, 0xc11e,	0xc9ff, 0xc11e,		0x21, 0
	.dw 0xca40, 0xc11e,	0xca7f, 0xc11e,		0x21, 0
	.dw 0xcac0, 0xc11e,	0xcaff, 0xc11e,		0x21, 0
	.dw 0xcb40, 0xc11e,	0xcb7f, 0xc11e,		0x21, 0
	.dw 0xcbc0, 0xc11e,	0xcbff, 0xc11e,		0x21, 0
	.dw 0xcc40, 0xc11e,	0xcc7f, 0xc11e,		0x21, 0
	.dw 0xccc0, 0xc11e,	0xccff, 0xc11e,		0x21, 0
	.dw 0xcd40, 0xc11e,	0xcd7f, 0xc11e,		0x21, 0
	.dw 0xcdc0, 0xc11e,	0xcdff, 0xc11e,		0x21, 0
	.dw 0xce40, 0xc11e,	0xce7f, 0xc11e,		0x21, 0
	.dw 0xcec0, 0xc11e,	0xceff, 0xc11e,		0x21, 0
	.dw 0xcf40, 0xc11e,	0xcf7f, 0xc11e,		0x21, 0
	.dw 0xcfc0, 0xc11e,	0xcfff, 0xc11e,		0x21, 0
	.dw 0xd040, 0xc11e,	0xd07f, 0xc11e,		0x21, 0
	.dw 0xd0c0, 0xc11e,	0xd0ff, 0xc11e,		0x21, 0
	.dw 0xd140, 0xc11e,	0xd17f, 0xc11e,		0x21, 0
	.dw 0xd1c0, 0xc11e,	0xd1ff, 0xc11e,		0x21, 0
	.dw 0xd240, 0xc11e,	0xd27f, 0xc11e,		0x21, 0
	.dw 0xd2c0, 0xc11e,	0xd2ff, 0xc11e,		0x21, 0
	.dw 0xd340, 0xc11e,	0xd37f, 0xc11e,		0x21, 0
	.dw 0xd3c0, 0xc11e,	0xd3ff, 0xc11e,		0x21, 0
	.dw 0xd440, 0xc11e,	0xd47f, 0xc11e,		0x21, 0
	.dw 0xd4c0, 0xc11e,	0xd4ff, 0xc11e,		0x21, 0
	.dw 0xd540, 0xc11e,	0xd57f, 0xc11e,		0x21, 0
	.dw 0xd5c0, 0xc11e,	0xd5ff, 0xc11e,		0x21, 0
	.dw 0xd640, 0xc11e,	0xd67f, 0xc11e,		0x21, 0
	.dw 0xd6c0, 0xc11e,	0xd6ff, 0xc11e,		0x21, 0
	.dw 0xd740, 0xc11e,	0xd77f, 0xc11e,		0x21, 0
	.dw 0xd7c0, 0xc11e,	0xd7ff, 0xc11e,		0x21, 0
	.dw 0xd840, 0xc11e,	0xd87f, 0xc11e,		0x21, 0
	.dw 0xd8c0, 0xc11e,	0xd8ff, 0xc11e,		0x21, 0
	.dw 0xd940, 0xc11e,	0xd97f, 0xc11e,		0x21, 0
	.dw 0xd9c0, 0xc11e,	0xdfff, 0xc11e,		0x21, 0
	.dw 0xe040, 0xc11e,	0xe07f, 0xc11e,		0x21, 0
	.dw 0xe0c0, 0xc11e,	0xe0ff, 0xc11e,		0x21, 0
	.dw 0xe140, 0xc11e,	0xe17f, 0xc11e,		0x21, 0
	.dw 0xe1c0, 0xc11e,	0xe1ff, 0xc11e,		0x21, 0
	.dw 0xe240, 0xc11e,	0xe27f, 0xc11e,		0x21, 0
	.dw 0xe2c0, 0xc11e,	0xe2ff, 0xc11e,		0x21, 0
	.dw 0xe340, 0xc11e,	0xe37f, 0xc11e,		0x21, 0
	.dw 0xe3c0, 0xc11e,	0xe3ff, 0xc11e,		0x21, 0
	.dw 0xe440, 0xc11e,	0xe47f, 0xc11e,		0x21, 0
	.dw 0xe4c0, 0xc11e,	0xe4ff, 0xc11e,		0x21, 0
	.dw 0xe540, 0xc11e,	0xe57f, 0xc11e,		0x21, 0
	.dw 0xe5c0, 0xc11e,	0xe5ff, 0xc11e,		0x21, 0
	.dw 0xe640, 0xc11e,	0xe67f, 0xc11e,		0x21, 0
	.dw 0xe6c0, 0xc11e,	0xe6ff, 0xc11e,		0x21, 0
	.dw 0xe740, 0xc11e,	0xe77f, 0xc11e,		0x21, 0
	.dw 0xe7c0, 0xc11e,	0xe7ff, 0xc11e,		0x21, 0
	.dw 0xe840, 0xc11e,	0xe87f, 0xc11e,		0x21, 0
	.dw 0xe8c0, 0xc11e,	0xe8ff, 0xc11e,		0x21, 0
	.dw 0xe940, 0xc11e,	0xe97f, 0xc11e,		0x21, 0
	.dw 0xe9c0, 0xc11e,	0xe9ff, 0xc11e,		0x21, 0
	.dw 0xea40, 0xc11e,	0xea7f, 0xc11e,		0x21, 0
	.dw 0xeac0, 0xc11e,	0xeaff, 0xc11e,		0x21, 0
	.dw 0xeb40, 0xc11e,	0xeb7f, 0xc11e,		0x21, 0
	.dw 0xebc0, 0xc11e,	0xebff, 0xc11e,		0x21, 0
	.dw 0xec40, 0xc11e,	0xec7f, 0xc11e,		0x21, 0
	.dw 0xecc0, 0xc11e,	0xecff, 0xc11e,		0x21, 0
	.dw 0xed40, 0xc11e,	0xed7f, 0xc11e,		0x21, 0
	.dw 0xedc0, 0xc11e,	0xedff, 0xc11e,		0x21, 0
	.dw 0xee40, 0xc11e,	0xee7f, 0xc11e,		0x21, 0
	.dw 0xeec0, 0xc11e,	0xeeff, 0xc11e,		0x21, 0
	.dw 0xef40, 0xc11e,	0xef7f, 0xc11e,		0x21, 0
	.dw 0xefc0, 0xc11e,	0xefff, 0xc11e,		0x21, 0
	.dw 0xf040, 0xc11e,	0xf07f, 0xc11e,		0x21, 0
	.dw 0xf0c0, 0xc11e,	0xf0ff, 0xc11e,		0x21, 0
	.dw 0xf140, 0xc11e,	0xf17f, 0xc11e,		0x21, 0
	.dw 0xf1c0, 0xc11e,	0xf1ff, 0xc11e,		0x21, 0
	.dw 0xf240, 0xc11e,	0xf27f, 0xc11e,		0x21, 0
	.dw 0xf2c0, 0xc11e,	0xf2ff, 0xc11e,		0x21, 0
	.dw 0xf340, 0xc11e,	0xf37f, 0xc11e,		0x21, 0
	.dw 0xf3c0, 0xc11e,	0xf3ff, 0xc11e,		0x21, 0
	.dw 0xf440, 0xc11e,	0xf47f, 0xc11e,		0x21, 0
	.dw 0xf4c0, 0xc11e,	0xf4ff, 0xc11e,		0x21, 0
	.dw 0xf540, 0xc11e,	0xf57f, 0xc11e,		0x21, 0
	.dw 0xf5c0, 0xc11e,	0xf5ff, 0xc11e,		0x21, 0
	.dw 0xf640, 0xc11e,	0xf67f, 0xc11e,		0x21, 0
	.dw 0xf6c0, 0xc11e,	0xf6ff, 0xc11e,		0x21, 0
	.dw 0xf740, 0xc11e,	0xf77f, 0xc11e,		0x21, 0
	.dw 0xf7c0, 0xc11e,	0xf7ff, 0xc11e,		0x21, 0
	.dw 0xf840, 0xc11e,	0xf87f, 0xc11e,		0x21, 0
	.dw 0xf8c0, 0xc11e,	0xf8ff, 0xc11e,		0x21, 0
	.dw 0xf940, 0xc11e,	0xf97f, 0xc11e,		0x21, 0
	.dw 0xf9c0, 0xc11e,	0xffff, 0xc11e,		0x21, 0
	.dw 0x0040, 0xc11f,	0x007f, 0xc11f,		0x21, 0
	.dw 0x00c0, 0xc11f,	0x00ff, 0xc11f,		0x21, 0
	.dw 0x0140, 0xc11f,	0x017f, 0xc11f,		0x21, 0
	.dw 0x01c0, 0xc11f,	0x01ff, 0xc11f,		0x21, 0
	.dw 0x0240, 0xc11f,	0x027f, 0xc11f,		0x21, 0
	.dw 0x02c0, 0xc11f,	0x02ff, 0xc11f,		0x21, 0
	.dw 0x0340, 0xc11f,	0x037f, 0xc11f,		0x21, 0
	.dw 0x03c0, 0xc11f,	0x03ff, 0xc11f,		0x21, 0
	.dw 0x0440, 0xc11f,	0x047f, 0xc11f,		0x21, 0
	.dw 0x04c0, 0xc11f,	0x04ff, 0xc11f,		0x21, 0
	.dw 0x0540, 0xc11f,	0x057f, 0xc11f,		0x21, 0
	.dw 0x05c0, 0xc11f,	0x05ff, 0xc11f,		0x21, 0
	.dw 0x0640, 0xc11f,	0x067f, 0xc11f,		0x21, 0
	.dw 0x06c0, 0xc11f,	0x06ff, 0xc11f,		0x21, 0
	.dw 0x0740, 0xc11f,	0x077f, 0xc11f,		0x21, 0
	.dw 0x07c0, 0xc11f,	0x07ff, 0xc11f,		0x21, 0
	.dw 0x0840, 0xc11f,	0x087f, 0xc11f,		0x21, 0
	.dw 0x08c0, 0xc11f,	0x08ff, 0xc11f,		0x21, 0
	.dw 0x0940, 0xc11f,	0x097f, 0xc11f,		0x21, 0
	.dw 0x09c0, 0xc11f,	0x09ff, 0xc11f,		0x21, 0
	.dw 0x0a40, 0xc11f,	0x0a7f, 0xc11f,		0x21, 0
	.dw 0x0ac0, 0xc11f,	0x0aff, 0xc11f,		0x21, 0
	.dw 0x0b40, 0xc11f,	0x0b7f, 0xc11f,		0x21, 0
	.dw 0x0bc0, 0xc11f,	0x0bff, 0xc11f,		0x21, 0
	.dw 0x0c40, 0xc11f,	0x0c7f, 0xc11f,		0x21, 0
	.dw 0x0cc0, 0xc11f,	0x0cff, 0xc11f,		0x21, 0
	.dw 0x0d40, 0xc11f,	0x0d7f, 0xc11f,		0x21, 0
	.dw 0x0dc0, 0xc11f,	0x0dff, 0xc11f,		0x21, 0
	.dw 0x0e40, 0xc11f,	0x0e7f, 0xc11f,		0x21, 0
	.dw 0x0ec0, 0xc11f,	0x0eff, 0xc11f,		0x21, 0
	.dw 0x0f40, 0xc11f,	0x0f7f, 0xc11f,		0x21, 0
	.dw 0x0fc0, 0xc11f,	0x0fff, 0xc11f,		0x21, 0
	.dw 0x1040, 0xc11f,	0x107f, 0xc11f,		0x21, 0
	.dw 0x10c0, 0xc11f,	0x10ff, 0xc11f,		0x21, 0
	.dw 0x1140, 0xc11f,	0x117f, 0xc11f,		0x21, 0
	.dw 0x11c0, 0xc11f,	0x11ff, 0xc11f,		0x21, 0
	.dw 0x1240, 0xc11f,	0x127f, 0xc11f,		0x21, 0
	.dw 0x12c0, 0xc11f,	0x12ff, 0xc11f,		0x21, 0
	.dw 0x1340, 0xc11f,	0x137f, 0xc11f,		0x21, 0
	.dw 0x13c0, 0xc11f,	0x13ff, 0xc11f,		0x21, 0
	.dw 0x1440, 0xc11f,	0x147f, 0xc11f,		0x21, 0
	.dw 0x14c0, 0xc11f,	0x14ff, 0xc11f,		0x21, 0
	.dw 0x1540, 0xc11f,	0x157f, 0xc11f,		0x21, 0
	.dw 0x15c0, 0xc11f,	0x15ff, 0xc11f,		0x21, 0
	.dw 0x1640, 0xc11f,	0x167f, 0xc11f,		0x21, 0
	.dw 0x16c0, 0xc11f,	0x16ff, 0xc11f,		0x21, 0
	.dw 0x1740, 0xc11f,	0x177f, 0xc11f,		0x21, 0
	.dw 0x17c0, 0xc11f,	0x17ff, 0xc11f,		0x21, 0
	.dw 0x1840, 0xc11f,	0x187f, 0xc11f,		0x21, 0
	.dw 0x18c0, 0xc11f,	0x18ff, 0xc11f,		0x21, 0
	.dw 0x1940, 0xc11f,	0x197f, 0xc11f,		0x21, 0
	.dw 0x19c0, 0xc11f,	0x1fff, 0xc11f,		0x21, 0
	.dw 0x2040, 0xc11f,	0x207f, 0xc11f,		0x21, 0
	.dw 0x20c0, 0xc11f,	0x20ff, 0xc11f,		0x21, 0
	.dw 0x2140, 0xc11f,	0x217f, 0xc11f,		0x21, 0
	.dw 0x21c0, 0xc11f,	0x21ff, 0xc11f,		0x21, 0
	.dw 0x2240, 0xc11f,	0x227f, 0xc11f,		0x21, 0
	.dw 0x22c0, 0xc11f,	0x22ff, 0xc11f,		0x21, 0
	.dw 0x2340, 0xc11f,	0x237f, 0xc11f,		0x21, 0
	.dw 0x23c0, 0xc11f,	0x23ff, 0xc11f,		0x21, 0
	.dw 0x2440, 0xc11f,	0x247f, 0xc11f,		0x21, 0
	.dw 0x24c0, 0xc11f,	0x24ff, 0xc11f,		0x21, 0
	.dw 0x2540, 0xc11f,	0x257f, 0xc11f,		0x21, 0
	.dw 0x25c0, 0xc11f,	0x25ff, 0xc11f,		0x21, 0
	.dw 0x2640, 0xc11f,	0x267f, 0xc11f,		0x21, 0
	.dw 0x26c0, 0xc11f,	0x26ff, 0xc11f,		0x21, 0
	.dw 0x2740, 0xc11f,	0x277f, 0xc11f,		0x21, 0
	.dw 0x27c0, 0xc11f,	0x27ff, 0xc11f,		0x21, 0
	.dw 0x2840, 0xc11f,	0x287f, 0xc11f,		0x21, 0
	.dw 0x28c0, 0xc11f,	0x28ff, 0xc11f,		0x21, 0
	.dw 0x2940, 0xc11f,	0x297f, 0xc11f,		0x21, 0
	.dw 0x29c0, 0xc11f,	0x29ff, 0xc11f,		0x21, 0
	.dw 0x2a40, 0xc11f,	0x2a7f, 0xc11f,		0x21, 0
	.dw 0x2ac0, 0xc11f,	0x2aff, 0xc11f,		0x21, 0
	.dw 0x2b40, 0xc11f,	0x2b7f, 0xc11f,		0x21, 0
	.dw 0x2bc0, 0xc11f,	0x2bff, 0xc11f,		0x21, 0
	.dw 0x2c40, 0xc11f,	0x2c7f, 0xc11f,		0x21, 0
	.dw 0x2cc0, 0xc11f,	0x2cff, 0xc11f,		0x21, 0
	.dw 0x2d40, 0xc11f,	0x2d7f, 0xc11f,		0x21, 0
	.dw 0x2dc0, 0xc11f,	0x2dff, 0xc11f,		0x21, 0
	.dw 0x2e40, 0xc11f,	0x2e7f, 0xc11f,		0x21, 0
	.dw 0x2ec0, 0xc11f,	0x2eff, 0xc11f,		0x21, 0
	.dw 0x2f40, 0xc11f,	0x2f7f, 0xc11f,		0x21, 0
	.dw 0x2fc0, 0xc11f,	0x2fff, 0xc11f,		0x21, 0
	.dw 0x3040, 0xc11f,	0x307f, 0xc11f,		0x21, 0
	.dw 0x30c0, 0xc11f,	0x30ff, 0xc11f,		0x21, 0
	.dw 0x3140, 0xc11f,	0x317f, 0xc11f,		0x21, 0
	.dw 0x31c0, 0xc11f,	0x31ff, 0xc11f,		0x21, 0
	.dw 0x3240, 0xc11f,	0x327f, 0xc11f,		0x21, 0
	.dw 0x32c0, 0xc11f,	0x32ff, 0xc11f,		0x21, 0
	.dw 0x3340, 0xc11f,	0x337f, 0xc11f,		0x21, 0
	.dw 0x33c0, 0xc11f,	0x33ff, 0xc11f,		0x21, 0
	.dw 0x3440, 0xc11f,	0x347f, 0xc11f,		0x21, 0
	.dw 0x34c0, 0xc11f,	0x34ff, 0xc11f,		0x21, 0
	.dw 0x3540, 0xc11f,	0x357f, 0xc11f,		0x21, 0
	.dw 0x35c0, 0xc11f,	0x35ff, 0xc11f,		0x21, 0
	.dw 0x3640, 0xc11f,	0x367f, 0xc11f,		0x21, 0
	.dw 0x36c0, 0xc11f,	0x36ff, 0xc11f,		0x21, 0
	.dw 0x3740, 0xc11f,	0x377f, 0xc11f,		0x21, 0
	.dw 0x37c0, 0xc11f,	0x37ff, 0xc11f,		0x21, 0
	.dw 0x3840, 0xc11f,	0x387f, 0xc11f,		0x21, 0
	.dw 0x38c0, 0xc11f,	0x38ff, 0xc11f,		0x21, 0
	.dw 0x3940, 0xc11f,	0x397f, 0xc11f,		0x21, 0
	.dw 0x39c0, 0xc11f,	0x1fff, 0xc120,		0x21, 0
	.dw 0x3a00, 0xc120,	0x5fff, 0xc120,		0x21, 0
	.dw 0x7a00, 0xc120,	0x9fff, 0xc120,		0x21, 0
	.dw 0xba00, 0xc120,	0xdfff, 0xc120,		0x21, 0
	.dw 0xfa00, 0xc120,	0x1fff, 0xc121,		0x21, 0
	.dw 0x3a00, 0xc121,	0x5fff, 0xc121,		0x21, 0
	.dw 0x7a00, 0xc121,	0x9fff, 0xc121,		0x21, 0
	.dw 0xba00, 0xc121,	0xdfff, 0xc121,		0x21, 0
	.dw 0xfa00, 0xc121,	0x1fff, 0xc122,		0x21, 0
	.dw 0x3a00, 0xc122,	0x5fff, 0xc122,		0x21, 0
	.dw 0x7a00, 0xc122,	0x9fff, 0xc122,		0x21, 0
	.dw 0xba00, 0xc122,	0xdfff, 0xc122,		0x21, 0
	.dw 0xfa00, 0xc122,	0x1fff, 0xc123,		0x21, 0
	.dw 0x3a00, 0xc123,	0xffff, 0xc123,		0x21, 0
	.dw 0x1a00, 0xc124,	0x1fff, 0xc124,		0x21, 0
	.dw 0x3a00, 0xc124,	0x3fff, 0xc124,		0x21, 0
	.dw 0x5a00, 0xc124,	0x5fff, 0xc124,		0x21, 0
	.dw 0x7a00, 0xc124,	0x7fff, 0xc124,		0x21, 0
	.dw 0x9a00, 0xc124,	0x9fff, 0xc124,		0x21, 0
	.dw 0xba00, 0xc124,	0xbfff, 0xc124,		0x21, 0
	.dw 0xda00, 0xc124,	0xdfff, 0xc124,		0x21, 0
	.dw 0xfa00, 0xc124,	0xffff, 0xc124,		0x21, 0
	.dw 0x1a00, 0xc125,	0x1fff, 0xc125,		0x21, 0
	.dw 0x3a00, 0xc125,	0x3fff, 0xc125,		0x21, 0
	.dw 0x5a00, 0xc125,	0x5fff, 0xc125,		0x21, 0
	.dw 0x7a00, 0xc125,	0x7fff, 0xc125,		0x21, 0
	.dw 0x9a00, 0xc125,	0x9fff, 0xc125,		0x21, 0
	.dw 0xba00, 0xc125,	0xbfff, 0xc125,		0x21, 0
	.dw 0xda00, 0xc125,	0xdfff, 0xc125,		0x21, 0
	.dw 0xfa00, 0xc125,	0xffff, 0xc125,		0x21, 0
	.dw 0x1a00, 0xc126,	0x1fff, 0xc126,		0x21, 0
	.dw 0x3a00, 0xc126,	0x3fff, 0xc126,		0x21, 0
	.dw 0x5a00, 0xc126,	0x5fff, 0xc126,		0x21, 0
	.dw 0x7a00, 0xc126,	0x7fff, 0xc126,		0x21, 0
	.dw 0x9a00, 0xc126,	0x9fff, 0xc126,		0x21, 0
	.dw 0xba00, 0xc126,	0xbfff, 0xc126,		0x21, 0
	.dw 0xda00, 0xc126,	0xdfff, 0xc126,		0x21, 0
	.dw 0xfa00, 0xc126,	0xffff, 0xc126,		0x21, 0
	.dw 0x1a00, 0xc127,	0x1fff, 0xc127,		0x21, 0
	.dw 0x3a00, 0xc127,	0x1fff, 0xc128,		0x21, 0
	.dw 0x2040, 0xc128,	0x207f, 0xc128,		0x21, 0
	.dw 0x20c0, 0xc128,	0x20ff, 0xc128,		0x21, 0
	.dw 0x2140, 0xc128,	0x217f, 0xc128,		0x21, 0
	.dw 0x21c0, 0xc128,	0x21ff, 0xc128,		0x21, 0
	.dw 0x2240, 0xc128,	0x227f, 0xc128,		0x21, 0
	.dw 0x22c0, 0xc128,	0x22ff, 0xc128,		0x21, 0
	.dw 0x2340, 0xc128,	0x237f, 0xc128,		0x21, 0
	.dw 0x23c0, 0xc128,	0x23ff, 0xc128,		0x21, 0
	.dw 0x2440, 0xc128,	0x247f, 0xc128,		0x21, 0
	.dw 0x24c0, 0xc128,	0x24ff, 0xc128,		0x21, 0
	.dw 0x2540, 0xc128,	0x257f, 0xc128,		0x21, 0
	.dw 0x25c0, 0xc128,	0x25ff, 0xc128,		0x21, 0
	.dw 0x2640, 0xc128,	0x267f, 0xc128,		0x21, 0
	.dw 0x26c0, 0xc128,	0x26ff, 0xc128,		0x21, 0
	.dw 0x2740, 0xc128,	0x277f, 0xc128,		0x21, 0
	.dw 0x27c0, 0xc128,	0x27ff, 0xc128,		0x21, 0
	.dw 0x2840, 0xc128,	0x287f, 0xc128,		0x21, 0
	.dw 0x28c0, 0xc128,	0x28ff, 0xc128,		0x21, 0
	.dw 0x2940, 0xc128,	0x297f, 0xc128,		0x21, 0
	.dw 0x29c0, 0xc128,	0x29ff, 0xc128,		0x21, 0
	.dw 0x2a40, 0xc128,	0x2a7f, 0xc128,		0x21, 0
	.dw 0x2ac0, 0xc128,	0x2aff, 0xc128,		0x21, 0
	.dw 0x2b40, 0xc128,	0x2b7f, 0xc128,		0x21, 0
	.dw 0x2bc0, 0xc128,	0x2bff, 0xc128,		0x21, 0
	.dw 0x2c40, 0xc128,	0x2c7f, 0xc128,		0x21, 0
	.dw 0x2cc0, 0xc128,	0x2cff, 0xc128,		0x21, 0
	.dw 0x2d40, 0xc128,	0x2d7f, 0xc128,		0x21, 0
	.dw 0x2dc0, 0xc128,	0x2dff, 0xc128,		0x21, 0
	.dw 0x2e40, 0xc128,	0x2e7f, 0xc128,		0x21, 0
	.dw 0x2ec0, 0xc128,	0x2eff, 0xc128,		0x21, 0
	.dw 0x2f40, 0xc128,	0x2f7f, 0xc128,		0x21, 0
	.dw 0x2fc0, 0xc128,	0x2fff, 0xc128,		0x21, 0
	.dw 0x3040, 0xc128,	0x307f, 0xc128,		0x21, 0
	.dw 0x30c0, 0xc128,	0x30ff, 0xc128,		0x21, 0
	.dw 0x3140, 0xc128,	0x317f, 0xc128,		0x21, 0
	.dw 0x31c0, 0xc128,	0x31ff, 0xc128,		0x21, 0
	.dw 0x3240, 0xc128,	0x327f, 0xc128,		0x21, 0
	.dw 0x32c0, 0xc128,	0x32ff, 0xc128,		0x21, 0
	.dw 0x3340, 0xc128,	0x337f, 0xc128,		0x21, 0
	.dw 0x33c0, 0xc128,	0x33ff, 0xc128,		0x21, 0
	.dw 0x3440, 0xc128,	0x347f, 0xc128,		0x21, 0
	.dw 0x34c0, 0xc128,	0x34ff, 0xc128,		0x21, 0
	.dw 0x3540, 0xc128,	0x357f, 0xc128,		0x21, 0
	.dw 0x35c0, 0xc128,	0x35ff, 0xc128,		0x21, 0
	.dw 0x3640, 0xc128,	0x367f, 0xc128,		0x21, 0
	.dw 0x36c0, 0xc128,	0x36ff, 0xc128,		0x21, 0
	.dw 0x3740, 0xc128,	0x377f, 0xc128,		0x21, 0
	.dw 0x37c0, 0xc128,	0x37ff, 0xc128,		0x21, 0
	.dw 0x3840, 0xc128,	0x387f, 0xc128,		0x21, 0
	.dw 0x38c0, 0xc128,	0x38ff, 0xc128,		0x21, 0
	.dw 0x3940, 0xc128,	0x397f, 0xc128,		0x21, 0
	.dw 0x39c0, 0xc128,	0x5fff, 0xc128,		0x21, 0
	.dw 0x6040, 0xc128,	0x607f, 0xc128,		0x21, 0
	.dw 0x60c0, 0xc128,	0x60ff, 0xc128,		0x21, 0
	.dw 0x6140, 0xc128,	0x617f, 0xc128,		0x21, 0
	.dw 0x61c0, 0xc128,	0x61ff, 0xc128,		0x21, 0
	.dw 0x6240, 0xc128,	0x627f, 0xc128,		0x21, 0
	.dw 0x62c0, 0xc128,	0x62ff, 0xc128,		0x21, 0
	.dw 0x6340, 0xc128,	0x637f, 0xc128,		0x21, 0
	.dw 0x63c0, 0xc128,	0x63ff, 0xc128,		0x21, 0
	.dw 0x6440, 0xc128,	0x647f, 0xc128,		0x21, 0
	.dw 0x64c0, 0xc128,	0x64ff, 0xc128,		0x21, 0
	.dw 0x6540, 0xc128,	0x657f, 0xc128,		0x21, 0
	.dw 0x65c0, 0xc128,	0x65ff, 0xc128,		0x21, 0
	.dw 0x6640, 0xc128,	0x667f, 0xc128,		0x21, 0
	.dw 0x66c0, 0xc128,	0x66ff, 0xc128,		0x21, 0
	.dw 0x6740, 0xc128,	0x677f, 0xc128,		0x21, 0
	.dw 0x67c0, 0xc128,	0x67ff, 0xc128,		0x21, 0
	.dw 0x6840, 0xc128,	0x687f, 0xc128,		0x21, 0
	.dw 0x68c0, 0xc128,	0x68ff, 0xc128,		0x21, 0
	.dw 0x6940, 0xc128,	0x697f, 0xc128,		0x21, 0
	.dw 0x69c0, 0xc128,	0x69ff, 0xc128,		0x21, 0
	.dw 0x6a40, 0xc128,	0x6a7f, 0xc128,		0x21, 0
	.dw 0x6ac0, 0xc128,	0x6aff, 0xc128,		0x21, 0
	.dw 0x6b40, 0xc128,	0x6b7f, 0xc128,		0x21, 0
	.dw 0x6bc0, 0xc128,	0x6bff, 0xc128,		0x21, 0
	.dw 0x6c40, 0xc128,	0x6c7f, 0xc128,		0x21, 0
	.dw 0x6cc0, 0xc128,	0x6cff, 0xc128,		0x21, 0
	.dw 0x6d40, 0xc128,	0x6d7f, 0xc128,		0x21, 0
	.dw 0x6dc0, 0xc128,	0x6dff, 0xc128,		0x21, 0
	.dw 0x6e40, 0xc128,	0x6e7f, 0xc128,		0x21, 0
	.dw 0x6ec0, 0xc128,	0x6eff, 0xc128,		0x21, 0
	.dw 0x6f40, 0xc128,	0x6f7f, 0xc128,		0x21, 0
	.dw 0x6fc0, 0xc128,	0x6fff, 0xc128,		0x21, 0
	.dw 0x7040, 0xc128,	0x707f, 0xc128,		0x21, 0
	.dw 0x70c0, 0xc128,	0x70ff, 0xc128,		0x21, 0
	.dw 0x7140, 0xc128,	0x717f, 0xc128,		0x21, 0
	.dw 0x71c0, 0xc128,	0x71ff, 0xc128,		0x21, 0
	.dw 0x7240, 0xc128,	0x727f, 0xc128,		0x21, 0
	.dw 0x72c0, 0xc128,	0x72ff, 0xc128,		0x21, 0
	.dw 0x7340, 0xc128,	0x737f, 0xc128,		0x21, 0
	.dw 0x73c0, 0xc128,	0x73ff, 0xc128,		0x21, 0
	.dw 0x7440, 0xc128,	0x747f, 0xc128,		0x21, 0
	.dw 0x74c0, 0xc128,	0x74ff, 0xc128,		0x21, 0
	.dw 0x7540, 0xc128,	0x757f, 0xc128,		0x21, 0
	.dw 0x75c0, 0xc128,	0x75ff, 0xc128,		0x21, 0
	.dw 0x7640, 0xc128,	0x767f, 0xc128,		0x21, 0
	.dw 0x76c0, 0xc128,	0x76ff, 0xc128,		0x21, 0
	.dw 0x7740, 0xc128,	0x777f, 0xc128,		0x21, 0
	.dw 0x77c0, 0xc128,	0x77ff, 0xc128,		0x21, 0
	.dw 0x7840, 0xc128,	0x787f, 0xc128,		0x21, 0
	.dw 0x78c0, 0xc128,	0x78ff, 0xc128,		0x21, 0
	.dw 0x7940, 0xc128,	0x797f, 0xc128,		0x21, 0
	.dw 0x79c0, 0xc128,	0x9fff, 0xc128,		0x21, 0
	.dw 0xa040, 0xc128,	0xa07f, 0xc128,		0x21, 0
	.dw 0xa0c0, 0xc128,	0xa0ff, 0xc128,		0x21, 0
	.dw 0xa140, 0xc128,	0xa17f, 0xc128,		0x21, 0
	.dw 0xa1c0, 0xc128,	0xa1ff, 0xc128,		0x21, 0
	.dw 0xa240, 0xc128,	0xa27f, 0xc128,		0x21, 0
	.dw 0xa2c0, 0xc128,	0xa2ff, 0xc128,		0x21, 0
	.dw 0xa340, 0xc128,	0xa37f, 0xc128,		0x21, 0
	.dw 0xa3c0, 0xc128,	0xa3ff, 0xc128,		0x21, 0
	.dw 0xa440, 0xc128,	0xa47f, 0xc128,		0x21, 0
	.dw 0xa4c0, 0xc128,	0xa4ff, 0xc128,		0x21, 0
	.dw 0xa540, 0xc128,	0xa57f, 0xc128,		0x21, 0
	.dw 0xa5c0, 0xc128,	0xa5ff, 0xc128,		0x21, 0
	.dw 0xa640, 0xc128,	0xa67f, 0xc128,		0x21, 0
	.dw 0xa6c0, 0xc128,	0xa6ff, 0xc128,		0x21, 0
	.dw 0xa740, 0xc128,	0xa77f, 0xc128,		0x21, 0
	.dw 0xa7c0, 0xc128,	0xa7ff, 0xc128,		0x21, 0
	.dw 0xa840, 0xc128,	0xa87f, 0xc128,		0x21, 0
	.dw 0xa8c0, 0xc128,	0xa8ff, 0xc128,		0x21, 0
	.dw 0xa940, 0xc128,	0xa97f, 0xc128,		0x21, 0
	.dw 0xa9c0, 0xc128,	0xa9ff, 0xc128,		0x21, 0
	.dw 0xaa40, 0xc128,	0xaa7f, 0xc128,		0x21, 0
	.dw 0xaac0, 0xc128,	0xaaff, 0xc128,		0x21, 0
	.dw 0xab40, 0xc128,	0xab7f, 0xc128,		0x21, 0
	.dw 0xabc0, 0xc128,	0xabff, 0xc128,		0x21, 0
	.dw 0xac40, 0xc128,	0xac7f, 0xc128,		0x21, 0
	.dw 0xacc0, 0xc128,	0xacff, 0xc128,		0x21, 0
	.dw 0xad40, 0xc128,	0xad7f, 0xc128,		0x21, 0
	.dw 0xadc0, 0xc128,	0xadff, 0xc128,		0x21, 0
	.dw 0xae40, 0xc128,	0xae7f, 0xc128,		0x21, 0
	.dw 0xaec0, 0xc128,	0xaeff, 0xc128,		0x21, 0
	.dw 0xaf40, 0xc128,	0xaf7f, 0xc128,		0x21, 0
	.dw 0xafc0, 0xc128,	0xafff, 0xc128,		0x21, 0
	.dw 0xb040, 0xc128,	0xb07f, 0xc128,		0x21, 0
	.dw 0xb0c0, 0xc128,	0xb0ff, 0xc128,		0x21, 0
	.dw 0xb140, 0xc128,	0xb17f, 0xc128,		0x21, 0
	.dw 0xb1c0, 0xc128,	0xb1ff, 0xc128,		0x21, 0
	.dw 0xb240, 0xc128,	0xb27f, 0xc128,		0x21, 0
	.dw 0xb2c0, 0xc128,	0xb2ff, 0xc128,		0x21, 0
	.dw 0xb340, 0xc128,	0xb37f, 0xc128,		0x21, 0
	.dw 0xb3c0, 0xc128,	0xb3ff, 0xc128,		0x21, 0
	.dw 0xb440, 0xc128,	0xb47f, 0xc128,		0x21, 0
	.dw 0xb4c0, 0xc128,	0xb4ff, 0xc128,		0x21, 0
	.dw 0xb540, 0xc128,	0xb57f, 0xc128,		0x21, 0
	.dw 0xb5c0, 0xc128,	0xb5ff, 0xc128,		0x21, 0
	.dw 0xb640, 0xc128,	0xb67f, 0xc128,		0x21, 0
	.dw 0xb6c0, 0xc128,	0xb6ff, 0xc128,		0x21, 0
	.dw 0xb740, 0xc128,	0xb77f, 0xc128,		0x21, 0
	.dw 0xb7c0, 0xc128,	0xb7ff, 0xc128,		0x21, 0
	.dw 0xb840, 0xc128,	0xb87f, 0xc128,		0x21, 0
	.dw 0xb8c0, 0xc128,	0xb8ff, 0xc128,		0x21, 0
	.dw 0xb940, 0xc128,	0xb97f, 0xc128,		0x21, 0
	.dw 0xb9c0, 0xc128,	0xdfff, 0xc128,		0x21, 0
	.dw 0xe040, 0xc128,	0xe07f, 0xc128,		0x21, 0
	.dw 0xe0c0, 0xc128,	0xe0ff, 0xc128,		0x21, 0
	.dw 0xe140, 0xc128,	0xe17f, 0xc128,		0x21, 0
	.dw 0xe1c0, 0xc128,	0xe1ff, 0xc128,		0x21, 0
	.dw 0xe240, 0xc128,	0xe27f, 0xc128,		0x21, 0
	.dw 0xe2c0, 0xc128,	0xe2ff, 0xc128,		0x21, 0
	.dw 0xe340, 0xc128,	0xe37f, 0xc128,		0x21, 0
	.dw 0xe3c0, 0xc128,	0xe3ff, 0xc128,		0x21, 0
	.dw 0xe440, 0xc128,	0xe47f, 0xc128,		0x21, 0
	.dw 0xe4c0, 0xc128,	0xe4ff, 0xc128,		0x21, 0
	.dw 0xe540, 0xc128,	0xe57f, 0xc128,		0x21, 0
	.dw 0xe5c0, 0xc128,	0xe5ff, 0xc128,		0x21, 0
	.dw 0xe640, 0xc128,	0xe67f, 0xc128,		0x21, 0
	.dw 0xe6c0, 0xc128,	0xe6ff, 0xc128,		0x21, 0
	.dw 0xe740, 0xc128,	0xe77f, 0xc128,		0x21, 0
	.dw 0xe7c0, 0xc128,	0xe7ff, 0xc128,		0x21, 0
	.dw 0xe840, 0xc128,	0xe87f, 0xc128,		0x21, 0
	.dw 0xe8c0, 0xc128,	0xe8ff, 0xc128,		0x21, 0
	.dw 0xe940, 0xc128,	0xe97f, 0xc128,		0x21, 0
	.dw 0xe9c0, 0xc128,	0xe9ff, 0xc128,		0x21, 0
	.dw 0xea40, 0xc128,	0xea7f, 0xc128,		0x21, 0
	.dw 0xeac0, 0xc128,	0xeaff, 0xc128,		0x21, 0
	.dw 0xeb40, 0xc128,	0xeb7f, 0xc128,		0x21, 0
	.dw 0xebc0, 0xc128,	0xebff, 0xc128,		0x21, 0
	.dw 0xec40, 0xc128,	0xec7f, 0xc128,		0x21, 0
	.dw 0xecc0, 0xc128,	0xecff, 0xc128,		0x21, 0
	.dw 0xed40, 0xc128,	0xed7f, 0xc128,		0x21, 0
	.dw 0xedc0, 0xc128,	0xedff, 0xc128,		0x21, 0
	.dw 0xee40, 0xc128,	0xee7f, 0xc128,		0x21, 0
	.dw 0xeec0, 0xc128,	0xeeff, 0xc128,		0x21, 0
	.dw 0xef40, 0xc128,	0xef7f, 0xc128,		0x21, 0
	.dw 0xefc0, 0xc128,	0xefff, 0xc128,		0x21, 0
	.dw 0xf040, 0xc128,	0xf07f, 0xc128,		0x21, 0
	.dw 0xf0c0, 0xc128,	0xf0ff, 0xc128,		0x21, 0
	.dw 0xf140, 0xc128,	0xf17f, 0xc128,		0x21, 0
	.dw 0xf1c0, 0xc128,	0xf1ff, 0xc128,		0x21, 0
	.dw 0xf240, 0xc128,	0xf27f, 0xc128,		0x21, 0
	.dw 0xf2c0, 0xc128,	0xf2ff, 0xc128,		0x21, 0
	.dw 0xf340, 0xc128,	0xf37f, 0xc128,		0x21, 0
	.dw 0xf3c0, 0xc128,	0xf3ff, 0xc128,		0x21, 0
	.dw 0xf440, 0xc128,	0xf47f, 0xc128,		0x21, 0
	.dw 0xf4c0, 0xc128,	0xf4ff, 0xc128,		0x21, 0
	.dw 0xf540, 0xc128,	0xf57f, 0xc128,		0x21, 0
	.dw 0xf5c0, 0xc128,	0xf5ff, 0xc128,		0x21, 0
	.dw 0xf640, 0xc128,	0xf67f, 0xc128,		0x21, 0
	.dw 0xf6c0, 0xc128,	0xf6ff, 0xc128,		0x21, 0
	.dw 0xf740, 0xc128,	0xf77f, 0xc128,		0x21, 0
	.dw 0xf7c0, 0xc128,	0xf7ff, 0xc128,		0x21, 0
	.dw 0xf840, 0xc128,	0xf87f, 0xc128,		0x21, 0
	.dw 0xf8c0, 0xc128,	0xf8ff, 0xc128,		0x21, 0
	.dw 0xf940, 0xc128,	0xf97f, 0xc128,		0x21, 0
	.dw 0xf9c0, 0xc128,	0x1fff, 0xc129,		0x21, 0
	.dw 0x2040, 0xc129,	0x207f, 0xc129,		0x21, 0
	.dw 0x20c0, 0xc129,	0x20ff, 0xc129,		0x21, 0
	.dw 0x2140, 0xc129,	0x217f, 0xc129,		0x21, 0
	.dw 0x21c0, 0xc129,	0x21ff, 0xc129,		0x21, 0
	.dw 0x2240, 0xc129,	0x227f, 0xc129,		0x21, 0
	.dw 0x22c0, 0xc129,	0x22ff, 0xc129,		0x21, 0
	.dw 0x2340, 0xc129,	0x237f, 0xc129,		0x21, 0
	.dw 0x23c0, 0xc129,	0x23ff, 0xc129,		0x21, 0
	.dw 0x2440, 0xc129,	0x247f, 0xc129,		0x21, 0
	.dw 0x24c0, 0xc129,	0x24ff, 0xc129,		0x21, 0
	.dw 0x2540, 0xc129,	0x257f, 0xc129,		0x21, 0
	.dw 0x25c0, 0xc129,	0x25ff, 0xc129,		0x21, 0
	.dw 0x2640, 0xc129,	0x267f, 0xc129,		0x21, 0
	.dw 0x26c0, 0xc129,	0x26ff, 0xc129,		0x21, 0
	.dw 0x2740, 0xc129,	0x277f, 0xc129,		0x21, 0
	.dw 0x27c0, 0xc129,	0x27ff, 0xc129,		0x21, 0
	.dw 0x2840, 0xc129,	0x287f, 0xc129,		0x21, 0
	.dw 0x28c0, 0xc129,	0x28ff, 0xc129,		0x21, 0
	.dw 0x2940, 0xc129,	0x297f, 0xc129,		0x21, 0
	.dw 0x29c0, 0xc129,	0x29ff, 0xc129,		0x21, 0
	.dw 0x2a40, 0xc129,	0x2a7f, 0xc129,		0x21, 0
	.dw 0x2ac0, 0xc129,	0x2aff, 0xc129,		0x21, 0
	.dw 0x2b40, 0xc129,	0x2b7f, 0xc129,		0x21, 0
	.dw 0x2bc0, 0xc129,	0x2bff, 0xc129,		0x21, 0
	.dw 0x2c40, 0xc129,	0x2c7f, 0xc129,		0x21, 0
	.dw 0x2cc0, 0xc129,	0x2cff, 0xc129,		0x21, 0
	.dw 0x2d40, 0xc129,	0x2d7f, 0xc129,		0x21, 0
	.dw 0x2dc0, 0xc129,	0x2dff, 0xc129,		0x21, 0
	.dw 0x2e40, 0xc129,	0x2e7f, 0xc129,		0x21, 0
	.dw 0x2ec0, 0xc129,	0x2eff, 0xc129,		0x21, 0
	.dw 0x2f40, 0xc129,	0x2f7f, 0xc129,		0x21, 0
	.dw 0x2fc0, 0xc129,	0x2fff, 0xc129,		0x21, 0
	.dw 0x3040, 0xc129,	0x307f, 0xc129,		0x21, 0
	.dw 0x30c0, 0xc129,	0x30ff, 0xc129,		0x21, 0
	.dw 0x3140, 0xc129,	0x317f, 0xc129,		0x21, 0
	.dw 0x31c0, 0xc129,	0x31ff, 0xc129,		0x21, 0
	.dw 0x3240, 0xc129,	0x327f, 0xc129,		0x21, 0
	.dw 0x32c0, 0xc129,	0x32ff, 0xc129,		0x21, 0
	.dw 0x3340, 0xc129,	0x337f, 0xc129,		0x21, 0
	.dw 0x33c0, 0xc129,	0x33ff, 0xc129,		0x21, 0
	.dw 0x3440, 0xc129,	0x347f, 0xc129,		0x21, 0
	.dw 0x34c0, 0xc129,	0x34ff, 0xc129,		0x21, 0
	.dw 0x3540, 0xc129,	0x357f, 0xc129,		0x21, 0
	.dw 0x35c0, 0xc129,	0x35ff, 0xc129,		0x21, 0
	.dw 0x3640, 0xc129,	0x367f, 0xc129,		0x21, 0
	.dw 0x36c0, 0xc129,	0x36ff, 0xc129,		0x21, 0
	.dw 0x3740, 0xc129,	0x377f, 0xc129,		0x21, 0
	.dw 0x37c0, 0xc129,	0x37ff, 0xc129,		0x21, 0
	.dw 0x3840, 0xc129,	0x387f, 0xc129,		0x21, 0
	.dw 0x38c0, 0xc129,	0x38ff, 0xc129,		0x21, 0
	.dw 0x3940, 0xc129,	0x397f, 0xc129,		0x21, 0
	.dw 0x39c0, 0xc129,	0x5fff, 0xc129,		0x21, 0
	.dw 0x6040, 0xc129,	0x607f, 0xc129,		0x21, 0
	.dw 0x60c0, 0xc129,	0x60ff, 0xc129,		0x21, 0
	.dw 0x6140, 0xc129,	0x617f, 0xc129,		0x21, 0
	.dw 0x61c0, 0xc129,	0x61ff, 0xc129,		0x21, 0
	.dw 0x6240, 0xc129,	0x627f, 0xc129,		0x21, 0
	.dw 0x62c0, 0xc129,	0x62ff, 0xc129,		0x21, 0
	.dw 0x6340, 0xc129,	0x637f, 0xc129,		0x21, 0
	.dw 0x63c0, 0xc129,	0x63ff, 0xc129,		0x21, 0
	.dw 0x6440, 0xc129,	0x647f, 0xc129,		0x21, 0
	.dw 0x64c0, 0xc129,	0x64ff, 0xc129,		0x21, 0
	.dw 0x6540, 0xc129,	0x657f, 0xc129,		0x21, 0
	.dw 0x65c0, 0xc129,	0x65ff, 0xc129,		0x21, 0
	.dw 0x6640, 0xc129,	0x667f, 0xc129,		0x21, 0
	.dw 0x66c0, 0xc129,	0x66ff, 0xc129,		0x21, 0
	.dw 0x6740, 0xc129,	0x677f, 0xc129,		0x21, 0
	.dw 0x67c0, 0xc129,	0x67ff, 0xc129,		0x21, 0
	.dw 0x6840, 0xc129,	0x687f, 0xc129,		0x21, 0
	.dw 0x68c0, 0xc129,	0x68ff, 0xc129,		0x21, 0
	.dw 0x6940, 0xc129,	0x697f, 0xc129,		0x21, 0
	.dw 0x69c0, 0xc129,	0x69ff, 0xc129,		0x21, 0
	.dw 0x6a40, 0xc129,	0x6a7f, 0xc129,		0x21, 0
	.dw 0x6ac0, 0xc129,	0x6aff, 0xc129,		0x21, 0
	.dw 0x6b40, 0xc129,	0x6b7f, 0xc129,		0x21, 0
	.dw 0x6bc0, 0xc129,	0x6bff, 0xc129,		0x21, 0
	.dw 0x6c40, 0xc129,	0x6c7f, 0xc129,		0x21, 0
	.dw 0x6cc0, 0xc129,	0x6cff, 0xc129,		0x21, 0
	.dw 0x6d40, 0xc129,	0x6d7f, 0xc129,		0x21, 0
	.dw 0x6dc0, 0xc129,	0x6dff, 0xc129,		0x21, 0
	.dw 0x6e40, 0xc129,	0x6e7f, 0xc129,		0x21, 0
	.dw 0x6ec0, 0xc129,	0x6eff, 0xc129,		0x21, 0
	.dw 0x6f40, 0xc129,	0x6f7f, 0xc129,		0x21, 0
	.dw 0x6fc0, 0xc129,	0x6fff, 0xc129,		0x21, 0
	.dw 0x7040, 0xc129,	0x707f, 0xc129,		0x21, 0
	.dw 0x70c0, 0xc129,	0x70ff, 0xc129,		0x21, 0
	.dw 0x7140, 0xc129,	0x717f, 0xc129,		0x21, 0
	.dw 0x71c0, 0xc129,	0x71ff, 0xc129,		0x21, 0
	.dw 0x7240, 0xc129,	0x727f, 0xc129,		0x21, 0
	.dw 0x72c0, 0xc129,	0x72ff, 0xc129,		0x21, 0
	.dw 0x7340, 0xc129,	0x737f, 0xc129,		0x21, 0
	.dw 0x73c0, 0xc129,	0x73ff, 0xc129,		0x21, 0
	.dw 0x7440, 0xc129,	0x747f, 0xc129,		0x21, 0
	.dw 0x74c0, 0xc129,	0x74ff, 0xc129,		0x21, 0
	.dw 0x7540, 0xc129,	0x757f, 0xc129,		0x21, 0
	.dw 0x75c0, 0xc129,	0x75ff, 0xc129,		0x21, 0
	.dw 0x7640, 0xc129,	0x767f, 0xc129,		0x21, 0
	.dw 0x76c0, 0xc129,	0x76ff, 0xc129,		0x21, 0
	.dw 0x7740, 0xc129,	0x777f, 0xc129,		0x21, 0
	.dw 0x77c0, 0xc129,	0x77ff, 0xc129,		0x21, 0
	.dw 0x7840, 0xc129,	0x787f, 0xc129,		0x21, 0
	.dw 0x78c0, 0xc129,	0x78ff, 0xc129,		0x21, 0
	.dw 0x7940, 0xc129,	0x797f, 0xc129,		0x21, 0
	.dw 0x79c0, 0xc129,	0x9fff, 0xc129,		0x21, 0
	.dw 0xa040, 0xc129,	0xa07f, 0xc129,		0x21, 0
	.dw 0xa0c0, 0xc129,	0xa0ff, 0xc129,		0x21, 0
	.dw 0xa140, 0xc129,	0xa17f, 0xc129,		0x21, 0
	.dw 0xa1c0, 0xc129,	0xa1ff, 0xc129,		0x21, 0
	.dw 0xa240, 0xc129,	0xa27f, 0xc129,		0x21, 0
	.dw 0xa2c0, 0xc129,	0xa2ff, 0xc129,		0x21, 0
	.dw 0xa340, 0xc129,	0xa37f, 0xc129,		0x21, 0
	.dw 0xa3c0, 0xc129,	0xa3ff, 0xc129,		0x21, 0
	.dw 0xa440, 0xc129,	0xa47f, 0xc129,		0x21, 0
	.dw 0xa4c0, 0xc129,	0xa4ff, 0xc129,		0x21, 0
	.dw 0xa540, 0xc129,	0xa57f, 0xc129,		0x21, 0
	.dw 0xa5c0, 0xc129,	0xa5ff, 0xc129,		0x21, 0
	.dw 0xa640, 0xc129,	0xa67f, 0xc129,		0x21, 0
	.dw 0xa6c0, 0xc129,	0xa6ff, 0xc129,		0x21, 0
	.dw 0xa740, 0xc129,	0xa77f, 0xc129,		0x21, 0
	.dw 0xa7c0, 0xc129,	0xa7ff, 0xc129,		0x21, 0
	.dw 0xa840, 0xc129,	0xa87f, 0xc129,		0x21, 0
	.dw 0xa8c0, 0xc129,	0xa8ff, 0xc129,		0x21, 0
	.dw 0xa940, 0xc129,	0xa97f, 0xc129,		0x21, 0
	.dw 0xa9c0, 0xc129,	0xa9ff, 0xc129,		0x21, 0
	.dw 0xaa40, 0xc129,	0xaa7f, 0xc129,		0x21, 0
	.dw 0xaac0, 0xc129,	0xaaff, 0xc129,		0x21, 0
	.dw 0xab40, 0xc129,	0xab7f, 0xc129,		0x21, 0
	.dw 0xabc0, 0xc129,	0xabff, 0xc129,		0x21, 0
	.dw 0xac40, 0xc129,	0xac7f, 0xc129,		0x21, 0
	.dw 0xacc0, 0xc129,	0xacff, 0xc129,		0x21, 0
	.dw 0xad40, 0xc129,	0xad7f, 0xc129,		0x21, 0
	.dw 0xadc0, 0xc129,	0xadff, 0xc129,		0x21, 0
	.dw 0xae40, 0xc129,	0xae7f, 0xc129,		0x21, 0
	.dw 0xaec0, 0xc129,	0xaeff, 0xc129,		0x21, 0
	.dw 0xaf40, 0xc129,	0xaf7f, 0xc129,		0x21, 0
	.dw 0xafc0, 0xc129,	0xafff, 0xc129,		0x21, 0
	.dw 0xb040, 0xc129,	0xb07f, 0xc129,		0x21, 0
	.dw 0xb0c0, 0xc129,	0xb0ff, 0xc129,		0x21, 0
	.dw 0xb140, 0xc129,	0xb17f, 0xc129,		0x21, 0
	.dw 0xb1c0, 0xc129,	0xb1ff, 0xc129,		0x21, 0
	.dw 0xb240, 0xc129,	0xb27f, 0xc129,		0x21, 0
	.dw 0xb2c0, 0xc129,	0xb2ff, 0xc129,		0x21, 0
	.dw 0xb340, 0xc129,	0xb37f, 0xc129,		0x21, 0
	.dw 0xb3c0, 0xc129,	0xb3ff, 0xc129,		0x21, 0
	.dw 0xb440, 0xc129,	0xb47f, 0xc129,		0x21, 0
	.dw 0xb4c0, 0xc129,	0xb4ff, 0xc129,		0x21, 0
	.dw 0xb540, 0xc129,	0xb57f, 0xc129,		0x21, 0
	.dw 0xb5c0, 0xc129,	0xb5ff, 0xc129,		0x21, 0
	.dw 0xb640, 0xc129,	0xb67f, 0xc129,		0x21, 0
	.dw 0xb6c0, 0xc129,	0xb6ff, 0xc129,		0x21, 0
	.dw 0xb740, 0xc129,	0xb77f, 0xc129,		0x21, 0
	.dw 0xb7c0, 0xc129,	0xb7ff, 0xc129,		0x21, 0
	.dw 0xb840, 0xc129,	0xb87f, 0xc129,		0x21, 0
	.dw 0xb8c0, 0xc129,	0xb8ff, 0xc129,		0x21, 0
	.dw 0xb940, 0xc129,	0xb97f, 0xc129,		0x21, 0
	.dw 0xb9c0, 0xc129,	0xdfff, 0xc129,		0x21, 0
	.dw 0xe040, 0xc129,	0xe07f, 0xc129,		0x21, 0
	.dw 0xe0c0, 0xc129,	0xe0ff, 0xc129,		0x21, 0
	.dw 0xe140, 0xc129,	0xe17f, 0xc129,		0x21, 0
	.dw 0xe1c0, 0xc129,	0xe1ff, 0xc129,		0x21, 0
	.dw 0xe240, 0xc129,	0xe27f, 0xc129,		0x21, 0
	.dw 0xe2c0, 0xc129,	0xe2ff, 0xc129,		0x21, 0
	.dw 0xe340, 0xc129,	0xe37f, 0xc129,		0x21, 0
	.dw 0xe3c0, 0xc129,	0xe3ff, 0xc129,		0x21, 0
	.dw 0xe440, 0xc129,	0xe47f, 0xc129,		0x21, 0
	.dw 0xe4c0, 0xc129,	0xe4ff, 0xc129,		0x21, 0
	.dw 0xe540, 0xc129,	0xe57f, 0xc129,		0x21, 0
	.dw 0xe5c0, 0xc129,	0xe5ff, 0xc129,		0x21, 0
	.dw 0xe640, 0xc129,	0xe67f, 0xc129,		0x21, 0
	.dw 0xe6c0, 0xc129,	0xe6ff, 0xc129,		0x21, 0
	.dw 0xe740, 0xc129,	0xe77f, 0xc129,		0x21, 0
	.dw 0xe7c0, 0xc129,	0xe7ff, 0xc129,		0x21, 0
	.dw 0xe840, 0xc129,	0xe87f, 0xc129,		0x21, 0
	.dw 0xe8c0, 0xc129,	0xe8ff, 0xc129,		0x21, 0
	.dw 0xe940, 0xc129,	0xe97f, 0xc129,		0x21, 0
	.dw 0xe9c0, 0xc129,	0xe9ff, 0xc129,		0x21, 0
	.dw 0xea40, 0xc129,	0xea7f, 0xc129,		0x21, 0
	.dw 0xeac0, 0xc129,	0xeaff, 0xc129,		0x21, 0
	.dw 0xeb40, 0xc129,	0xeb7f, 0xc129,		0x21, 0
	.dw 0xebc0, 0xc129,	0xebff, 0xc129,		0x21, 0
	.dw 0xec40, 0xc129,	0xec7f, 0xc129,		0x21, 0
	.dw 0xecc0, 0xc129,	0xecff, 0xc129,		0x21, 0
	.dw 0xed40, 0xc129,	0xed7f, 0xc129,		0x21, 0
	.dw 0xedc0, 0xc129,	0xedff, 0xc129,		0x21, 0
	.dw 0xee40, 0xc129,	0xee7f, 0xc129,		0x21, 0
	.dw 0xeec0, 0xc129,	0xeeff, 0xc129,		0x21, 0
	.dw 0xef40, 0xc129,	0xef7f, 0xc129,		0x21, 0
	.dw 0xefc0, 0xc129,	0xefff, 0xc129,		0x21, 0
	.dw 0xf040, 0xc129,	0xf07f, 0xc129,		0x21, 0
	.dw 0xf0c0, 0xc129,	0xf0ff, 0xc129,		0x21, 0
	.dw 0xf140, 0xc129,	0xf17f, 0xc129,		0x21, 0
	.dw 0xf1c0, 0xc129,	0xf1ff, 0xc129,		0x21, 0
	.dw 0xf240, 0xc129,	0xf27f, 0xc129,		0x21, 0
	.dw 0xf2c0, 0xc129,	0xf2ff, 0xc129,		0x21, 0
	.dw 0xf340, 0xc129,	0xf37f, 0xc129,		0x21, 0
	.dw 0xf3c0, 0xc129,	0xf3ff, 0xc129,		0x21, 0
	.dw 0xf440, 0xc129,	0xf47f, 0xc129,		0x21, 0
	.dw 0xf4c0, 0xc129,	0xf4ff, 0xc129,		0x21, 0
	.dw 0xf540, 0xc129,	0xf57f, 0xc129,		0x21, 0
	.dw 0xf5c0, 0xc129,	0xf5ff, 0xc129,		0x21, 0
	.dw 0xf640, 0xc129,	0xf67f, 0xc129,		0x21, 0
	.dw 0xf6c0, 0xc129,	0xf6ff, 0xc129,		0x21, 0
	.dw 0xf740, 0xc129,	0xf77f, 0xc129,		0x21, 0
	.dw 0xf7c0, 0xc129,	0xf7ff, 0xc129,		0x21, 0
	.dw 0xf840, 0xc129,	0xf87f, 0xc129,		0x21, 0
	.dw 0xf8c0, 0xc129,	0xf8ff, 0xc129,		0x21, 0
	.dw 0xf940, 0xc129,	0xf97f, 0xc129,		0x21, 0
	.dw 0xf9c0, 0xc129,	0x1fff, 0xc12a,		0x21, 0
	.dw 0x2040, 0xc12a,	0x207f, 0xc12a,		0x21, 0
	.dw 0x20c0, 0xc12a,	0x20ff, 0xc12a,		0x21, 0
	.dw 0x2140, 0xc12a,	0x217f, 0xc12a,		0x21, 0
	.dw 0x21c0, 0xc12a,	0x21ff, 0xc12a,		0x21, 0
	.dw 0x2240, 0xc12a,	0x227f, 0xc12a,		0x21, 0
	.dw 0x22c0, 0xc12a,	0x22ff, 0xc12a,		0x21, 0
	.dw 0x2340, 0xc12a,	0x237f, 0xc12a,		0x21, 0
	.dw 0x23c0, 0xc12a,	0x23ff, 0xc12a,		0x21, 0
	.dw 0x2440, 0xc12a,	0x247f, 0xc12a,		0x21, 0
	.dw 0x24c0, 0xc12a,	0x24ff, 0xc12a,		0x21, 0
	.dw 0x2540, 0xc12a,	0x257f, 0xc12a,		0x21, 0
	.dw 0x25c0, 0xc12a,	0x25ff, 0xc12a,		0x21, 0
	.dw 0x2640, 0xc12a,	0x267f, 0xc12a,		0x21, 0
	.dw 0x26c0, 0xc12a,	0x26ff, 0xc12a,		0x21, 0
	.dw 0x2740, 0xc12a,	0x277f, 0xc12a,		0x21, 0
	.dw 0x27c0, 0xc12a,	0x27ff, 0xc12a,		0x21, 0
	.dw 0x2840, 0xc12a,	0x287f, 0xc12a,		0x21, 0
	.dw 0x28c0, 0xc12a,	0x28ff, 0xc12a,		0x21, 0
	.dw 0x2940, 0xc12a,	0x297f, 0xc12a,		0x21, 0
	.dw 0x29c0, 0xc12a,	0x29ff, 0xc12a,		0x21, 0
	.dw 0x2a40, 0xc12a,	0x2a7f, 0xc12a,		0x21, 0
	.dw 0x2ac0, 0xc12a,	0x2aff, 0xc12a,		0x21, 0
	.dw 0x2b40, 0xc12a,	0x2b7f, 0xc12a,		0x21, 0
	.dw 0x2bc0, 0xc12a,	0x2bff, 0xc12a,		0x21, 0
	.dw 0x2c40, 0xc12a,	0x2c7f, 0xc12a,		0x21, 0
	.dw 0x2cc0, 0xc12a,	0x2cff, 0xc12a,		0x21, 0
	.dw 0x2d40, 0xc12a,	0x2d7f, 0xc12a,		0x21, 0
	.dw 0x2dc0, 0xc12a,	0x2dff, 0xc12a,		0x21, 0
	.dw 0x2e40, 0xc12a,	0x2e7f, 0xc12a,		0x21, 0
	.dw 0x2ec0, 0xc12a,	0x2eff, 0xc12a,		0x21, 0
	.dw 0x2f40, 0xc12a,	0x2f7f, 0xc12a,		0x21, 0
	.dw 0x2fc0, 0xc12a,	0x2fff, 0xc12a,		0x21, 0
	.dw 0x3040, 0xc12a,	0x307f, 0xc12a,		0x21, 0
	.dw 0x30c0, 0xc12a,	0x30ff, 0xc12a,		0x21, 0
	.dw 0x3140, 0xc12a,	0x317f, 0xc12a,		0x21, 0
	.dw 0x31c0, 0xc12a,	0x31ff, 0xc12a,		0x21, 0
	.dw 0x3240, 0xc12a,	0x327f, 0xc12a,		0x21, 0
	.dw 0x32c0, 0xc12a,	0x32ff, 0xc12a,		0x21, 0
	.dw 0x3340, 0xc12a,	0x337f, 0xc12a,		0x21, 0
	.dw 0x33c0, 0xc12a,	0x33ff, 0xc12a,		0x21, 0
	.dw 0x3440, 0xc12a,	0x347f, 0xc12a,		0x21, 0
	.dw 0x34c0, 0xc12a,	0x34ff, 0xc12a,		0x21, 0
	.dw 0x3540, 0xc12a,	0x357f, 0xc12a,		0x21, 0
	.dw 0x35c0, 0xc12a,	0x35ff, 0xc12a,		0x21, 0
	.dw 0x3640, 0xc12a,	0x367f, 0xc12a,		0x21, 0
	.dw 0x36c0, 0xc12a,	0x36ff, 0xc12a,		0x21, 0
	.dw 0x3740, 0xc12a,	0x377f, 0xc12a,		0x21, 0
	.dw 0x37c0, 0xc12a,	0x37ff, 0xc12a,		0x21, 0
	.dw 0x3840, 0xc12a,	0x387f, 0xc12a,		0x21, 0
	.dw 0x38c0, 0xc12a,	0x38ff, 0xc12a,		0x21, 0
	.dw 0x3940, 0xc12a,	0x397f, 0xc12a,		0x21, 0
	.dw 0x39c0, 0xc12a,	0x5fff, 0xc12a,		0x21, 0
	.dw 0x6040, 0xc12a,	0x607f, 0xc12a,		0x21, 0
	.dw 0x60c0, 0xc12a,	0x60ff, 0xc12a,		0x21, 0
	.dw 0x6140, 0xc12a,	0x617f, 0xc12a,		0x21, 0
	.dw 0x61c0, 0xc12a,	0x61ff, 0xc12a,		0x21, 0
	.dw 0x6240, 0xc12a,	0x627f, 0xc12a,		0x21, 0
	.dw 0x62c0, 0xc12a,	0x62ff, 0xc12a,		0x21, 0
	.dw 0x6340, 0xc12a,	0x637f, 0xc12a,		0x21, 0
	.dw 0x63c0, 0xc12a,	0x63ff, 0xc12a,		0x21, 0
	.dw 0x6440, 0xc12a,	0x647f, 0xc12a,		0x21, 0
	.dw 0x64c0, 0xc12a,	0x64ff, 0xc12a,		0x21, 0
	.dw 0x6540, 0xc12a,	0x657f, 0xc12a,		0x21, 0
	.dw 0x65c0, 0xc12a,	0x65ff, 0xc12a,		0x21, 0
	.dw 0x6640, 0xc12a,	0x667f, 0xc12a,		0x21, 0
	.dw 0x66c0, 0xc12a,	0x66ff, 0xc12a,		0x21, 0
	.dw 0x6740, 0xc12a,	0x677f, 0xc12a,		0x21, 0
	.dw 0x67c0, 0xc12a,	0x67ff, 0xc12a,		0x21, 0
	.dw 0x6840, 0xc12a,	0x687f, 0xc12a,		0x21, 0
	.dw 0x68c0, 0xc12a,	0x68ff, 0xc12a,		0x21, 0
	.dw 0x6940, 0xc12a,	0x697f, 0xc12a,		0x21, 0
	.dw 0x69c0, 0xc12a,	0x69ff, 0xc12a,		0x21, 0
	.dw 0x6a40, 0xc12a,	0x6a7f, 0xc12a,		0x21, 0
	.dw 0x6ac0, 0xc12a,	0x6aff, 0xc12a,		0x21, 0
	.dw 0x6b40, 0xc12a,	0x6b7f, 0xc12a,		0x21, 0
	.dw 0x6bc0, 0xc12a,	0x6bff, 0xc12a,		0x21, 0
	.dw 0x6c40, 0xc12a,	0x6c7f, 0xc12a,		0x21, 0
	.dw 0x6cc0, 0xc12a,	0x6cff, 0xc12a,		0x21, 0
	.dw 0x6d40, 0xc12a,	0x6d7f, 0xc12a,		0x21, 0
	.dw 0x6dc0, 0xc12a,	0x6dff, 0xc12a,		0x21, 0
	.dw 0x6e40, 0xc12a,	0x6e7f, 0xc12a,		0x21, 0
	.dw 0x6ec0, 0xc12a,	0x6eff, 0xc12a,		0x21, 0
	.dw 0x6f40, 0xc12a,	0x6f7f, 0xc12a,		0x21, 0
	.dw 0x6fc0, 0xc12a,	0x6fff, 0xc12a,		0x21, 0
	.dw 0x7040, 0xc12a,	0x707f, 0xc12a,		0x21, 0
	.dw 0x70c0, 0xc12a,	0x70ff, 0xc12a,		0x21, 0
	.dw 0x7140, 0xc12a,	0x717f, 0xc12a,		0x21, 0
	.dw 0x71c0, 0xc12a,	0x71ff, 0xc12a,		0x21, 0
	.dw 0x7240, 0xc12a,	0x727f, 0xc12a,		0x21, 0
	.dw 0x72c0, 0xc12a,	0x72ff, 0xc12a,		0x21, 0
	.dw 0x7340, 0xc12a,	0x737f, 0xc12a,		0x21, 0
	.dw 0x73c0, 0xc12a,	0x73ff, 0xc12a,		0x21, 0
	.dw 0x7440, 0xc12a,	0x747f, 0xc12a,		0x21, 0
	.dw 0x74c0, 0xc12a,	0x74ff, 0xc12a,		0x21, 0
	.dw 0x7540, 0xc12a,	0x757f, 0xc12a,		0x21, 0
	.dw 0x75c0, 0xc12a,	0x75ff, 0xc12a,		0x21, 0
	.dw 0x7640, 0xc12a,	0x767f, 0xc12a,		0x21, 0
	.dw 0x76c0, 0xc12a,	0x76ff, 0xc12a,		0x21, 0
	.dw 0x7740, 0xc12a,	0x777f, 0xc12a,		0x21, 0
	.dw 0x77c0, 0xc12a,	0x77ff, 0xc12a,		0x21, 0
	.dw 0x7840, 0xc12a,	0x787f, 0xc12a,		0x21, 0
	.dw 0x78c0, 0xc12a,	0x78ff, 0xc12a,		0x21, 0
	.dw 0x7940, 0xc12a,	0x797f, 0xc12a,		0x21, 0
	.dw 0x79c0, 0xc12a,	0x9fff, 0xc12a,		0x21, 0
	.dw 0xa040, 0xc12a,	0xa07f, 0xc12a,		0x21, 0
	.dw 0xa0c0, 0xc12a,	0xa0ff, 0xc12a,		0x21, 0
	.dw 0xa140, 0xc12a,	0xa17f, 0xc12a,		0x21, 0
	.dw 0xa1c0, 0xc12a,	0xa1ff, 0xc12a,		0x21, 0
	.dw 0xa240, 0xc12a,	0xa27f, 0xc12a,		0x21, 0
	.dw 0xa2c0, 0xc12a,	0xa2ff, 0xc12a,		0x21, 0
	.dw 0xa340, 0xc12a,	0xa37f, 0xc12a,		0x21, 0
	.dw 0xa3c0, 0xc12a,	0xa3ff, 0xc12a,		0x21, 0
	.dw 0xa440, 0xc12a,	0xa47f, 0xc12a,		0x21, 0
	.dw 0xa4c0, 0xc12a,	0xa4ff, 0xc12a,		0x21, 0
	.dw 0xa540, 0xc12a,	0xa57f, 0xc12a,		0x21, 0
	.dw 0xa5c0, 0xc12a,	0xa5ff, 0xc12a,		0x21, 0
	.dw 0xa640, 0xc12a,	0xa67f, 0xc12a,		0x21, 0
	.dw 0xa6c0, 0xc12a,	0xa6ff, 0xc12a,		0x21, 0
	.dw 0xa740, 0xc12a,	0xa77f, 0xc12a,		0x21, 0
	.dw 0xa7c0, 0xc12a,	0xa7ff, 0xc12a,		0x21, 0
	.dw 0xa840, 0xc12a,	0xa87f, 0xc12a,		0x21, 0
	.dw 0xa8c0, 0xc12a,	0xa8ff, 0xc12a,		0x21, 0
	.dw 0xa940, 0xc12a,	0xa97f, 0xc12a,		0x21, 0
	.dw 0xa9c0, 0xc12a,	0xa9ff, 0xc12a,		0x21, 0
	.dw 0xaa40, 0xc12a,	0xaa7f, 0xc12a,		0x21, 0
	.dw 0xaac0, 0xc12a,	0xaaff, 0xc12a,		0x21, 0
	.dw 0xab40, 0xc12a,	0xab7f, 0xc12a,		0x21, 0
	.dw 0xabc0, 0xc12a,	0xabff, 0xc12a,		0x21, 0
	.dw 0xac40, 0xc12a,	0xac7f, 0xc12a,		0x21, 0
	.dw 0xacc0, 0xc12a,	0xacff, 0xc12a,		0x21, 0
	.dw 0xad40, 0xc12a,	0xad7f, 0xc12a,		0x21, 0
	.dw 0xadc0, 0xc12a,	0xadff, 0xc12a,		0x21, 0
	.dw 0xae40, 0xc12a,	0xae7f, 0xc12a,		0x21, 0
	.dw 0xaec0, 0xc12a,	0xaeff, 0xc12a,		0x21, 0
	.dw 0xaf40, 0xc12a,	0xaf7f, 0xc12a,		0x21, 0
	.dw 0xafc0, 0xc12a,	0xafff, 0xc12a,		0x21, 0
	.dw 0xb040, 0xc12a,	0xb07f, 0xc12a,		0x21, 0
	.dw 0xb0c0, 0xc12a,	0xb0ff, 0xc12a,		0x21, 0
	.dw 0xb140, 0xc12a,	0xb17f, 0xc12a,		0x21, 0
	.dw 0xb1c0, 0xc12a,	0xb1ff, 0xc12a,		0x21, 0
	.dw 0xb240, 0xc12a,	0xb27f, 0xc12a,		0x21, 0
	.dw 0xb2c0, 0xc12a,	0xb2ff, 0xc12a,		0x21, 0
	.dw 0xb340, 0xc12a,	0xb37f, 0xc12a,		0x21, 0
	.dw 0xb3c0, 0xc12a,	0xb3ff, 0xc12a,		0x21, 0
	.dw 0xb440, 0xc12a,	0xb47f, 0xc12a,		0x21, 0
	.dw 0xb4c0, 0xc12a,	0xb4ff, 0xc12a,		0x21, 0
	.dw 0xb540, 0xc12a,	0xb57f, 0xc12a,		0x21, 0
	.dw 0xb5c0, 0xc12a,	0xb5ff, 0xc12a,		0x21, 0
	.dw 0xb640, 0xc12a,	0xb67f, 0xc12a,		0x21, 0
	.dw 0xb6c0, 0xc12a,	0xb6ff, 0xc12a,		0x21, 0
	.dw 0xb740, 0xc12a,	0xb77f, 0xc12a,		0x21, 0
	.dw 0xb7c0, 0xc12a,	0xb7ff, 0xc12a,		0x21, 0
	.dw 0xb840, 0xc12a,	0xb87f, 0xc12a,		0x21, 0
	.dw 0xb8c0, 0xc12a,	0xb8ff, 0xc12a,		0x21, 0
	.dw 0xb940, 0xc12a,	0xb97f, 0xc12a,		0x21, 0
	.dw 0xb9c0, 0xc12a,	0xdfff, 0xc12a,		0x21, 0
	.dw 0xe040, 0xc12a,	0xe07f, 0xc12a,		0x21, 0
	.dw 0xe0c0, 0xc12a,	0xe0ff, 0xc12a,		0x21, 0
	.dw 0xe140, 0xc12a,	0xe17f, 0xc12a,		0x21, 0
	.dw 0xe1c0, 0xc12a,	0xe1ff, 0xc12a,		0x21, 0
	.dw 0xe240, 0xc12a,	0xe27f, 0xc12a,		0x21, 0
	.dw 0xe2c0, 0xc12a,	0xe2ff, 0xc12a,		0x21, 0
	.dw 0xe340, 0xc12a,	0xe37f, 0xc12a,		0x21, 0
	.dw 0xe3c0, 0xc12a,	0xe3ff, 0xc12a,		0x21, 0
	.dw 0xe440, 0xc12a,	0xe47f, 0xc12a,		0x21, 0
	.dw 0xe4c0, 0xc12a,	0xe4ff, 0xc12a,		0x21, 0
	.dw 0xe540, 0xc12a,	0xe57f, 0xc12a,		0x21, 0
	.dw 0xe5c0, 0xc12a,	0xe5ff, 0xc12a,		0x21, 0
	.dw 0xe640, 0xc12a,	0xe67f, 0xc12a,		0x21, 0
	.dw 0xe6c0, 0xc12a,	0xe6ff, 0xc12a,		0x21, 0
	.dw 0xe740, 0xc12a,	0xe77f, 0xc12a,		0x21, 0
	.dw 0xe7c0, 0xc12a,	0xe7ff, 0xc12a,		0x21, 0
	.dw 0xe840, 0xc12a,	0xe87f, 0xc12a,		0x21, 0
	.dw 0xe8c0, 0xc12a,	0xe8ff, 0xc12a,		0x21, 0
	.dw 0xe940, 0xc12a,	0xe97f, 0xc12a,		0x21, 0
	.dw 0xe9c0, 0xc12a,	0xe9ff, 0xc12a,		0x21, 0
	.dw 0xea40, 0xc12a,	0xea7f, 0xc12a,		0x21, 0
	.dw 0xeac0, 0xc12a,	0xeaff, 0xc12a,		0x21, 0
	.dw 0xeb40, 0xc12a,	0xeb7f, 0xc12a,		0x21, 0
	.dw 0xebc0, 0xc12a,	0xebff, 0xc12a,		0x21, 0
	.dw 0xec40, 0xc12a,	0xec7f, 0xc12a,		0x21, 0
	.dw 0xecc0, 0xc12a,	0xecff, 0xc12a,		0x21, 0
	.dw 0xed40, 0xc12a,	0xed7f, 0xc12a,		0x21, 0
	.dw 0xedc0, 0xc12a,	0xedff, 0xc12a,		0x21, 0
	.dw 0xee40, 0xc12a,	0xee7f, 0xc12a,		0x21, 0
	.dw 0xeec0, 0xc12a,	0xeeff, 0xc12a,		0x21, 0
	.dw 0xef40, 0xc12a,	0xef7f, 0xc12a,		0x21, 0
	.dw 0xefc0, 0xc12a,	0xefff, 0xc12a,		0x21, 0
	.dw 0xf040, 0xc12a,	0xf07f, 0xc12a,		0x21, 0
	.dw 0xf0c0, 0xc12a,	0xf0ff, 0xc12a,		0x21, 0
	.dw 0xf140, 0xc12a,	0xf17f, 0xc12a,		0x21, 0
	.dw 0xf1c0, 0xc12a,	0xf1ff, 0xc12a,		0x21, 0
	.dw 0xf240, 0xc12a,	0xf27f, 0xc12a,		0x21, 0
	.dw 0xf2c0, 0xc12a,	0xf2ff, 0xc12a,		0x21, 0
	.dw 0xf340, 0xc12a,	0xf37f, 0xc12a,		0x21, 0
	.dw 0xf3c0, 0xc12a,	0xf3ff, 0xc12a,		0x21, 0
	.dw 0xf440, 0xc12a,	0xf47f, 0xc12a,		0x21, 0
	.dw 0xf4c0, 0xc12a,	0xf4ff, 0xc12a,		0x21, 0
	.dw 0xf540, 0xc12a,	0xf57f, 0xc12a,		0x21, 0
	.dw 0xf5c0, 0xc12a,	0xf5ff, 0xc12a,		0x21, 0
	.dw 0xf640, 0xc12a,	0xf67f, 0xc12a,		0x21, 0
	.dw 0xf6c0, 0xc12a,	0xf6ff, 0xc12a,		0x21, 0
	.dw 0xf740, 0xc12a,	0xf77f, 0xc12a,		0x21, 0
	.dw 0xf7c0, 0xc12a,	0xf7ff, 0xc12a,		0x21, 0
	.dw 0xf840, 0xc12a,	0xf87f, 0xc12a,		0x21, 0
	.dw 0xf8c0, 0xc12a,	0xf8ff, 0xc12a,		0x21, 0
	.dw 0xf940, 0xc12a,	0xf97f, 0xc12a,		0x21, 0
	.dw 0xf9c0, 0xc12a,	0x1fff, 0xc12b,		0x21, 0
	.dw 0x2040, 0xc12b,	0x207f, 0xc12b,		0x21, 0
	.dw 0x20c0, 0xc12b,	0x20ff, 0xc12b,		0x21, 0
	.dw 0x2140, 0xc12b,	0x217f, 0xc12b,		0x21, 0
	.dw 0x21c0, 0xc12b,	0x21ff, 0xc12b,		0x21, 0
	.dw 0x2240, 0xc12b,	0x227f, 0xc12b,		0x21, 0
	.dw 0x22c0, 0xc12b,	0x22ff, 0xc12b,		0x21, 0
	.dw 0x2340, 0xc12b,	0x237f, 0xc12b,		0x21, 0
	.dw 0x23c0, 0xc12b,	0x23ff, 0xc12b,		0x21, 0
	.dw 0x2440, 0xc12b,	0x247f, 0xc12b,		0x21, 0
	.dw 0x24c0, 0xc12b,	0x24ff, 0xc12b,		0x21, 0
	.dw 0x2540, 0xc12b,	0x257f, 0xc12b,		0x21, 0
	.dw 0x25c0, 0xc12b,	0x25ff, 0xc12b,		0x21, 0
	.dw 0x2640, 0xc12b,	0x267f, 0xc12b,		0x21, 0
	.dw 0x26c0, 0xc12b,	0x26ff, 0xc12b,		0x21, 0
	.dw 0x2740, 0xc12b,	0x277f, 0xc12b,		0x21, 0
	.dw 0x27c0, 0xc12b,	0x27ff, 0xc12b,		0x21, 0
	.dw 0x2840, 0xc12b,	0x287f, 0xc12b,		0x21, 0
	.dw 0x28c0, 0xc12b,	0x28ff, 0xc12b,		0x21, 0
	.dw 0x2940, 0xc12b,	0x297f, 0xc12b,		0x21, 0
	.dw 0x29c0, 0xc12b,	0x29ff, 0xc12b,		0x21, 0
	.dw 0x2a40, 0xc12b,	0x2a7f, 0xc12b,		0x21, 0
	.dw 0x2ac0, 0xc12b,	0x2aff, 0xc12b,		0x21, 0
	.dw 0x2b40, 0xc12b,	0x2b7f, 0xc12b,		0x21, 0
	.dw 0x2bc0, 0xc12b,	0x2bff, 0xc12b,		0x21, 0
	.dw 0x2c40, 0xc12b,	0x2c7f, 0xc12b,		0x21, 0
	.dw 0x2cc0, 0xc12b,	0x2cff, 0xc12b,		0x21, 0
	.dw 0x2d40, 0xc12b,	0x2d7f, 0xc12b,		0x21, 0
	.dw 0x2dc0, 0xc12b,	0x2dff, 0xc12b,		0x21, 0
	.dw 0x2e40, 0xc12b,	0x2e7f, 0xc12b,		0x21, 0
	.dw 0x2ec0, 0xc12b,	0x2eff, 0xc12b,		0x21, 0
	.dw 0x2f40, 0xc12b,	0x2f7f, 0xc12b,		0x21, 0
	.dw 0x2fc0, 0xc12b,	0x2fff, 0xc12b,		0x21, 0
	.dw 0x3040, 0xc12b,	0x307f, 0xc12b,		0x21, 0
	.dw 0x30c0, 0xc12b,	0x30ff, 0xc12b,		0x21, 0
	.dw 0x3140, 0xc12b,	0x317f, 0xc12b,		0x21, 0
	.dw 0x31c0, 0xc12b,	0x31ff, 0xc12b,		0x21, 0
	.dw 0x3240, 0xc12b,	0x327f, 0xc12b,		0x21, 0
	.dw 0x32c0, 0xc12b,	0x32ff, 0xc12b,		0x21, 0
	.dw 0x3340, 0xc12b,	0x337f, 0xc12b,		0x21, 0
	.dw 0x33c0, 0xc12b,	0x33ff, 0xc12b,		0x21, 0
	.dw 0x3440, 0xc12b,	0x347f, 0xc12b,		0x21, 0
	.dw 0x34c0, 0xc12b,	0x34ff, 0xc12b,		0x21, 0
	.dw 0x3540, 0xc12b,	0x357f, 0xc12b,		0x21, 0
	.dw 0x35c0, 0xc12b,	0x35ff, 0xc12b,		0x21, 0
	.dw 0x3640, 0xc12b,	0x367f, 0xc12b,		0x21, 0
	.dw 0x36c0, 0xc12b,	0x36ff, 0xc12b,		0x21, 0
	.dw 0x3740, 0xc12b,	0x377f, 0xc12b,		0x21, 0
	.dw 0x37c0, 0xc12b,	0x37ff, 0xc12b,		0x21, 0
	.dw 0x3840, 0xc12b,	0x387f, 0xc12b,		0x21, 0
	.dw 0x38c0, 0xc12b,	0x38ff, 0xc12b,		0x21, 0
	.dw 0x3940, 0xc12b,	0x397f, 0xc12b,		0x21, 0
	.dw 0x39c0, 0xc12b,	0xffff, 0xc12b,		0x21, 0
	.dw 0x0040, 0xc12c,	0x007f, 0xc12c,		0x21, 0
	.dw 0x00c0, 0xc12c,	0x00ff, 0xc12c,		0x21, 0
	.dw 0x0140, 0xc12c,	0x017f, 0xc12c,		0x21, 0
	.dw 0x01c0, 0xc12c,	0x01ff, 0xc12c,		0x21, 0
	.dw 0x0240, 0xc12c,	0x027f, 0xc12c,		0x21, 0
	.dw 0x02c0, 0xc12c,	0x02ff, 0xc12c,		0x21, 0
	.dw 0x0340, 0xc12c,	0x037f, 0xc12c,		0x21, 0
	.dw 0x03c0, 0xc12c,	0x03ff, 0xc12c,		0x21, 0
	.dw 0x0440, 0xc12c,	0x047f, 0xc12c,		0x21, 0
	.dw 0x04c0, 0xc12c,	0x04ff, 0xc12c,		0x21, 0
	.dw 0x0540, 0xc12c,	0x057f, 0xc12c,		0x21, 0
	.dw 0x05c0, 0xc12c,	0x05ff, 0xc12c,		0x21, 0
	.dw 0x0640, 0xc12c,	0x067f, 0xc12c,		0x21, 0
	.dw 0x06c0, 0xc12c,	0x06ff, 0xc12c,		0x21, 0
	.dw 0x0740, 0xc12c,	0x077f, 0xc12c,		0x21, 0
	.dw 0x07c0, 0xc12c,	0x07ff, 0xc12c,		0x21, 0
	.dw 0x0840, 0xc12c,	0x087f, 0xc12c,		0x21, 0
	.dw 0x08c0, 0xc12c,	0x08ff, 0xc12c,		0x21, 0
	.dw 0x0940, 0xc12c,	0x097f, 0xc12c,		0x21, 0
	.dw 0x09c0, 0xc12c,	0x09ff, 0xc12c,		0x21, 0
	.dw 0x0a40, 0xc12c,	0x0a7f, 0xc12c,		0x21, 0
	.dw 0x0ac0, 0xc12c,	0x0aff, 0xc12c,		0x21, 0
	.dw 0x0b40, 0xc12c,	0x0b7f, 0xc12c,		0x21, 0
	.dw 0x0bc0, 0xc12c,	0x0bff, 0xc12c,		0x21, 0
	.dw 0x0c40, 0xc12c,	0x0c7f, 0xc12c,		0x21, 0
	.dw 0x0cc0, 0xc12c,	0x0cff, 0xc12c,		0x21, 0
	.dw 0x0d40, 0xc12c,	0x0d7f, 0xc12c,		0x21, 0
	.dw 0x0dc0, 0xc12c,	0x0dff, 0xc12c,		0x21, 0
	.dw 0x0e40, 0xc12c,	0x0e7f, 0xc12c,		0x21, 0
	.dw 0x0ec0, 0xc12c,	0x0eff, 0xc12c,		0x21, 0
	.dw 0x0f40, 0xc12c,	0x0f7f, 0xc12c,		0x21, 0
	.dw 0x0fc0, 0xc12c,	0x0fff, 0xc12c,		0x21, 0
	.dw 0x1040, 0xc12c,	0x107f, 0xc12c,		0x21, 0
	.dw 0x10c0, 0xc12c,	0x10ff, 0xc12c,		0x21, 0
	.dw 0x1140, 0xc12c,	0x117f, 0xc12c,		0x21, 0
	.dw 0x11c0, 0xc12c,	0x11ff, 0xc12c,		0x21, 0
	.dw 0x1240, 0xc12c,	0x127f, 0xc12c,		0x21, 0
	.dw 0x12c0, 0xc12c,	0x12ff, 0xc12c,		0x21, 0
	.dw 0x1340, 0xc12c,	0x137f, 0xc12c,		0x21, 0
	.dw 0x13c0, 0xc12c,	0x13ff, 0xc12c,		0x21, 0
	.dw 0x1440, 0xc12c,	0x147f, 0xc12c,		0x21, 0
	.dw 0x14c0, 0xc12c,	0x14ff, 0xc12c,		0x21, 0
	.dw 0x1540, 0xc12c,	0x157f, 0xc12c,		0x21, 0
	.dw 0x15c0, 0xc12c,	0x15ff, 0xc12c,		0x21, 0
	.dw 0x1640, 0xc12c,	0x167f, 0xc12c,		0x21, 0
	.dw 0x16c0, 0xc12c,	0x16ff, 0xc12c,		0x21, 0
	.dw 0x1740, 0xc12c,	0x177f, 0xc12c,		0x21, 0
	.dw 0x17c0, 0xc12c,	0x17ff, 0xc12c,		0x21, 0
	.dw 0x1840, 0xc12c,	0x187f, 0xc12c,		0x21, 0
	.dw 0x18c0, 0xc12c,	0x18ff, 0xc12c,		0x21, 0
	.dw 0x1940, 0xc12c,	0x197f, 0xc12c,		0x21, 0
	.dw 0x19c0, 0xc12c,	0x1fff, 0xc12c,		0x21, 0
	.dw 0x2040, 0xc12c,	0x207f, 0xc12c,		0x21, 0
	.dw 0x20c0, 0xc12c,	0x20ff, 0xc12c,		0x21, 0
	.dw 0x2140, 0xc12c,	0x217f, 0xc12c,		0x21, 0
	.dw 0x21c0, 0xc12c,	0x21ff, 0xc12c,		0x21, 0
	.dw 0x2240, 0xc12c,	0x227f, 0xc12c,		0x21, 0
	.dw 0x22c0, 0xc12c,	0x22ff, 0xc12c,		0x21, 0
	.dw 0x2340, 0xc12c,	0x237f, 0xc12c,		0x21, 0
	.dw 0x23c0, 0xc12c,	0x23ff, 0xc12c,		0x21, 0
	.dw 0x2440, 0xc12c,	0x247f, 0xc12c,		0x21, 0
	.dw 0x24c0, 0xc12c,	0x24ff, 0xc12c,		0x21, 0
	.dw 0x2540, 0xc12c,	0x257f, 0xc12c,		0x21, 0
	.dw 0x25c0, 0xc12c,	0x25ff, 0xc12c,		0x21, 0
	.dw 0x2640, 0xc12c,	0x267f, 0xc12c,		0x21, 0
	.dw 0x26c0, 0xc12c,	0x26ff, 0xc12c,		0x21, 0
	.dw 0x2740, 0xc12c,	0x277f, 0xc12c,		0x21, 0
	.dw 0x27c0, 0xc12c,	0x27ff, 0xc12c,		0x21, 0
	.dw 0x2840, 0xc12c,	0x287f, 0xc12c,		0x21, 0
	.dw 0x28c0, 0xc12c,	0x28ff, 0xc12c,		0x21, 0
	.dw 0x2940, 0xc12c,	0x297f, 0xc12c,		0x21, 0
	.dw 0x29c0, 0xc12c,	0x29ff, 0xc12c,		0x21, 0
	.dw 0x2a40, 0xc12c,	0x2a7f, 0xc12c,		0x21, 0
	.dw 0x2ac0, 0xc12c,	0x2aff, 0xc12c,		0x21, 0
	.dw 0x2b40, 0xc12c,	0x2b7f, 0xc12c,		0x21, 0
	.dw 0x2bc0, 0xc12c,	0x2bff, 0xc12c,		0x21, 0
	.dw 0x2c40, 0xc12c,	0x2c7f, 0xc12c,		0x21, 0
	.dw 0x2cc0, 0xc12c,	0x2cff, 0xc12c,		0x21, 0
	.dw 0x2d40, 0xc12c,	0x2d7f, 0xc12c,		0x21, 0
	.dw 0x2dc0, 0xc12c,	0x2dff, 0xc12c,		0x21, 0
	.dw 0x2e40, 0xc12c,	0x2e7f, 0xc12c,		0x21, 0
	.dw 0x2ec0, 0xc12c,	0x2eff, 0xc12c,		0x21, 0
	.dw 0x2f40, 0xc12c,	0x2f7f, 0xc12c,		0x21, 0
	.dw 0x2fc0, 0xc12c,	0x2fff, 0xc12c,		0x21, 0
	.dw 0x3040, 0xc12c,	0x307f, 0xc12c,		0x21, 0
	.dw 0x30c0, 0xc12c,	0x30ff, 0xc12c,		0x21, 0
	.dw 0x3140, 0xc12c,	0x317f, 0xc12c,		0x21, 0
	.dw 0x31c0, 0xc12c,	0x31ff, 0xc12c,		0x21, 0
	.dw 0x3240, 0xc12c,	0x327f, 0xc12c,		0x21, 0
	.dw 0x32c0, 0xc12c,	0x32ff, 0xc12c,		0x21, 0
	.dw 0x3340, 0xc12c,	0x337f, 0xc12c,		0x21, 0
	.dw 0x33c0, 0xc12c,	0x33ff, 0xc12c,		0x21, 0
	.dw 0x3440, 0xc12c,	0x347f, 0xc12c,		0x21, 0
	.dw 0x34c0, 0xc12c,	0x34ff, 0xc12c,		0x21, 0
	.dw 0x3540, 0xc12c,	0x357f, 0xc12c,		0x21, 0
	.dw 0x35c0, 0xc12c,	0x35ff, 0xc12c,		0x21, 0
	.dw 0x3640, 0xc12c,	0x367f, 0xc12c,		0x21, 0
	.dw 0x36c0, 0xc12c,	0x36ff, 0xc12c,		0x21, 0
	.dw 0x3740, 0xc12c,	0x377f, 0xc12c,		0x21, 0
	.dw 0x37c0, 0xc12c,	0x37ff, 0xc12c,		0x21, 0
	.dw 0x3840, 0xc12c,	0x387f, 0xc12c,		0x21, 0
	.dw 0x38c0, 0xc12c,	0x38ff, 0xc12c,		0x21, 0
	.dw 0x3940, 0xc12c,	0x397f, 0xc12c,		0x21, 0
	.dw 0x39c0, 0xc12c,	0x3fff, 0xc12c,		0x21, 0
	.dw 0x4040, 0xc12c,	0x407f, 0xc12c,		0x21, 0
	.dw 0x40c0, 0xc12c,	0x40ff, 0xc12c,		0x21, 0
	.dw 0x4140, 0xc12c,	0x417f, 0xc12c,		0x21, 0
	.dw 0x41c0, 0xc12c,	0x41ff, 0xc12c,		0x21, 0
	.dw 0x4240, 0xc12c,	0x427f, 0xc12c,		0x21, 0
	.dw 0x42c0, 0xc12c,	0x42ff, 0xc12c,		0x21, 0
	.dw 0x4340, 0xc12c,	0x437f, 0xc12c,		0x21, 0
	.dw 0x43c0, 0xc12c,	0x43ff, 0xc12c,		0x21, 0
	.dw 0x4440, 0xc12c,	0x447f, 0xc12c,		0x21, 0
	.dw 0x44c0, 0xc12c,	0x44ff, 0xc12c,		0x21, 0
	.dw 0x4540, 0xc12c,	0x457f, 0xc12c,		0x21, 0
	.dw 0x45c0, 0xc12c,	0x45ff, 0xc12c,		0x21, 0
	.dw 0x4640, 0xc12c,	0x467f, 0xc12c,		0x21, 0
	.dw 0x46c0, 0xc12c,	0x46ff, 0xc12c,		0x21, 0
	.dw 0x4740, 0xc12c,	0x477f, 0xc12c,		0x21, 0
	.dw 0x47c0, 0xc12c,	0x47ff, 0xc12c,		0x21, 0
	.dw 0x4840, 0xc12c,	0x487f, 0xc12c,		0x21, 0
	.dw 0x48c0, 0xc12c,	0x48ff, 0xc12c,		0x21, 0
	.dw 0x4940, 0xc12c,	0x497f, 0xc12c,		0x21, 0
	.dw 0x49c0, 0xc12c,	0x49ff, 0xc12c,		0x21, 0
	.dw 0x4a40, 0xc12c,	0x4a7f, 0xc12c,		0x21, 0
	.dw 0x4ac0, 0xc12c,	0x4aff, 0xc12c,		0x21, 0
	.dw 0x4b40, 0xc12c,	0x4b7f, 0xc12c,		0x21, 0
	.dw 0x4bc0, 0xc12c,	0x4bff, 0xc12c,		0x21, 0
	.dw 0x4c40, 0xc12c,	0x4c7f, 0xc12c,		0x21, 0
	.dw 0x4cc0, 0xc12c,	0x4cff, 0xc12c,		0x21, 0
	.dw 0x4d40, 0xc12c,	0x4d7f, 0xc12c,		0x21, 0
	.dw 0x4dc0, 0xc12c,	0x4dff, 0xc12c,		0x21, 0
	.dw 0x4e40, 0xc12c,	0x4e7f, 0xc12c,		0x21, 0
	.dw 0x4ec0, 0xc12c,	0x4eff, 0xc12c,		0x21, 0
	.dw 0x4f40, 0xc12c,	0x4f7f, 0xc12c,		0x21, 0
	.dw 0x4fc0, 0xc12c,	0x4fff, 0xc12c,		0x21, 0
	.dw 0x5040, 0xc12c,	0x507f, 0xc12c,		0x21, 0
	.dw 0x50c0, 0xc12c,	0x50ff, 0xc12c,		0x21, 0
	.dw 0x5140, 0xc12c,	0x517f, 0xc12c,		0x21, 0
	.dw 0x51c0, 0xc12c,	0x51ff, 0xc12c,		0x21, 0
	.dw 0x5240, 0xc12c,	0x527f, 0xc12c,		0x21, 0
	.dw 0x52c0, 0xc12c,	0x52ff, 0xc12c,		0x21, 0
	.dw 0x5340, 0xc12c,	0x537f, 0xc12c,		0x21, 0
	.dw 0x53c0, 0xc12c,	0x53ff, 0xc12c,		0x21, 0
	.dw 0x5440, 0xc12c,	0x547f, 0xc12c,		0x21, 0
	.dw 0x54c0, 0xc12c,	0x54ff, 0xc12c,		0x21, 0
	.dw 0x5540, 0xc12c,	0x557f, 0xc12c,		0x21, 0
	.dw 0x55c0, 0xc12c,	0x55ff, 0xc12c,		0x21, 0
	.dw 0x5640, 0xc12c,	0x567f, 0xc12c,		0x21, 0
	.dw 0x56c0, 0xc12c,	0x56ff, 0xc12c,		0x21, 0
	.dw 0x5740, 0xc12c,	0x577f, 0xc12c,		0x21, 0
	.dw 0x57c0, 0xc12c,	0x57ff, 0xc12c,		0x21, 0
	.dw 0x5840, 0xc12c,	0x587f, 0xc12c,		0x21, 0
	.dw 0x58c0, 0xc12c,	0x58ff, 0xc12c,		0x21, 0
	.dw 0x5940, 0xc12c,	0x597f, 0xc12c,		0x21, 0
	.dw 0x59c0, 0xc12c,	0x5fff, 0xc12c,		0x21, 0
	.dw 0x6040, 0xc12c,	0x607f, 0xc12c,		0x21, 0
	.dw 0x60c0, 0xc12c,	0x60ff, 0xc12c,		0x21, 0
	.dw 0x6140, 0xc12c,	0x617f, 0xc12c,		0x21, 0
	.dw 0x61c0, 0xc12c,	0x61ff, 0xc12c,		0x21, 0
	.dw 0x6240, 0xc12c,	0x627f, 0xc12c,		0x21, 0
	.dw 0x62c0, 0xc12c,	0x62ff, 0xc12c,		0x21, 0
	.dw 0x6340, 0xc12c,	0x637f, 0xc12c,		0x21, 0
	.dw 0x63c0, 0xc12c,	0x63ff, 0xc12c,		0x21, 0
	.dw 0x6440, 0xc12c,	0x647f, 0xc12c,		0x21, 0
	.dw 0x64c0, 0xc12c,	0x64ff, 0xc12c,		0x21, 0
	.dw 0x6540, 0xc12c,	0x657f, 0xc12c,		0x21, 0
	.dw 0x65c0, 0xc12c,	0x65ff, 0xc12c,		0x21, 0
	.dw 0x6640, 0xc12c,	0x667f, 0xc12c,		0x21, 0
	.dw 0x66c0, 0xc12c,	0x66ff, 0xc12c,		0x21, 0
	.dw 0x6740, 0xc12c,	0x677f, 0xc12c,		0x21, 0
	.dw 0x67c0, 0xc12c,	0x67ff, 0xc12c,		0x21, 0
	.dw 0x6840, 0xc12c,	0x687f, 0xc12c,		0x21, 0
	.dw 0x68c0, 0xc12c,	0x68ff, 0xc12c,		0x21, 0
	.dw 0x6940, 0xc12c,	0x697f, 0xc12c,		0x21, 0
	.dw 0x69c0, 0xc12c,	0x69ff, 0xc12c,		0x21, 0
	.dw 0x6a40, 0xc12c,	0x6a7f, 0xc12c,		0x21, 0
	.dw 0x6ac0, 0xc12c,	0x6aff, 0xc12c,		0x21, 0
	.dw 0x6b40, 0xc12c,	0x6b7f, 0xc12c,		0x21, 0
	.dw 0x6bc0, 0xc12c,	0x6bff, 0xc12c,		0x21, 0
	.dw 0x6c40, 0xc12c,	0x6c7f, 0xc12c,		0x21, 0
	.dw 0x6cc0, 0xc12c,	0x6cff, 0xc12c,		0x21, 0
	.dw 0x6d40, 0xc12c,	0x6d7f, 0xc12c,		0x21, 0
	.dw 0x6dc0, 0xc12c,	0x6dff, 0xc12c,		0x21, 0
	.dw 0x6e40, 0xc12c,	0x6e7f, 0xc12c,		0x21, 0
	.dw 0x6ec0, 0xc12c,	0x6eff, 0xc12c,		0x21, 0
	.dw 0x6f40, 0xc12c,	0x6f7f, 0xc12c,		0x21, 0
	.dw 0x6fc0, 0xc12c,	0x6fff, 0xc12c,		0x21, 0
	.dw 0x7040, 0xc12c,	0x707f, 0xc12c,		0x21, 0
	.dw 0x70c0, 0xc12c,	0x70ff, 0xc12c,		0x21, 0
	.dw 0x7140, 0xc12c,	0x717f, 0xc12c,		0x21, 0
	.dw 0x71c0, 0xc12c,	0x71ff, 0xc12c,		0x21, 0
	.dw 0x7240, 0xc12c,	0x727f, 0xc12c,		0x21, 0
	.dw 0x72c0, 0xc12c,	0x72ff, 0xc12c,		0x21, 0
	.dw 0x7340, 0xc12c,	0x737f, 0xc12c,		0x21, 0
	.dw 0x73c0, 0xc12c,	0x73ff, 0xc12c,		0x21, 0
	.dw 0x7440, 0xc12c,	0x747f, 0xc12c,		0x21, 0
	.dw 0x74c0, 0xc12c,	0x74ff, 0xc12c,		0x21, 0
	.dw 0x7540, 0xc12c,	0x757f, 0xc12c,		0x21, 0
	.dw 0x75c0, 0xc12c,	0x75ff, 0xc12c,		0x21, 0
	.dw 0x7640, 0xc12c,	0x767f, 0xc12c,		0x21, 0
	.dw 0x76c0, 0xc12c,	0x76ff, 0xc12c,		0x21, 0
	.dw 0x7740, 0xc12c,	0x777f, 0xc12c,		0x21, 0
	.dw 0x77c0, 0xc12c,	0x77ff, 0xc12c,		0x21, 0
	.dw 0x7840, 0xc12c,	0x787f, 0xc12c,		0x21, 0
	.dw 0x78c0, 0xc12c,	0x78ff, 0xc12c,		0x21, 0
	.dw 0x7940, 0xc12c,	0x797f, 0xc12c,		0x21, 0
	.dw 0x79c0, 0xc12c,	0x7fff, 0xc12c,		0x21, 0
	.dw 0x8040, 0xc12c,	0x807f, 0xc12c,		0x21, 0
	.dw 0x80c0, 0xc12c,	0x80ff, 0xc12c,		0x21, 0
	.dw 0x8140, 0xc12c,	0x817f, 0xc12c,		0x21, 0
	.dw 0x81c0, 0xc12c,	0x81ff, 0xc12c,		0x21, 0
	.dw 0x8240, 0xc12c,	0x827f, 0xc12c,		0x21, 0
	.dw 0x82c0, 0xc12c,	0x82ff, 0xc12c,		0x21, 0
	.dw 0x8340, 0xc12c,	0x837f, 0xc12c,		0x21, 0
	.dw 0x83c0, 0xc12c,	0x83ff, 0xc12c,		0x21, 0
	.dw 0x8440, 0xc12c,	0x847f, 0xc12c,		0x21, 0
	.dw 0x84c0, 0xc12c,	0x84ff, 0xc12c,		0x21, 0
	.dw 0x8540, 0xc12c,	0x857f, 0xc12c,		0x21, 0
	.dw 0x85c0, 0xc12c,	0x85ff, 0xc12c,		0x21, 0
	.dw 0x8640, 0xc12c,	0x867f, 0xc12c,		0x21, 0
	.dw 0x86c0, 0xc12c,	0x86ff, 0xc12c,		0x21, 0
	.dw 0x8740, 0xc12c,	0x877f, 0xc12c,		0x21, 0
	.dw 0x87c0, 0xc12c,	0x87ff, 0xc12c,		0x21, 0
	.dw 0x8840, 0xc12c,	0x887f, 0xc12c,		0x21, 0
	.dw 0x88c0, 0xc12c,	0x88ff, 0xc12c,		0x21, 0
	.dw 0x8940, 0xc12c,	0x897f, 0xc12c,		0x21, 0
	.dw 0x89c0, 0xc12c,	0x89ff, 0xc12c,		0x21, 0
	.dw 0x8a40, 0xc12c,	0x8a7f, 0xc12c,		0x21, 0
	.dw 0x8ac0, 0xc12c,	0x8aff, 0xc12c,		0x21, 0
	.dw 0x8b40, 0xc12c,	0x8b7f, 0xc12c,		0x21, 0
	.dw 0x8bc0, 0xc12c,	0x8bff, 0xc12c,		0x21, 0
	.dw 0x8c40, 0xc12c,	0x8c7f, 0xc12c,		0x21, 0
	.dw 0x8cc0, 0xc12c,	0x8cff, 0xc12c,		0x21, 0
	.dw 0x8d40, 0xc12c,	0x8d7f, 0xc12c,		0x21, 0
	.dw 0x8dc0, 0xc12c,	0x8dff, 0xc12c,		0x21, 0
	.dw 0x8e40, 0xc12c,	0x8e7f, 0xc12c,		0x21, 0
	.dw 0x8ec0, 0xc12c,	0x8eff, 0xc12c,		0x21, 0
	.dw 0x8f40, 0xc12c,	0x8f7f, 0xc12c,		0x21, 0
	.dw 0x8fc0, 0xc12c,	0x8fff, 0xc12c,		0x21, 0
	.dw 0x9040, 0xc12c,	0x907f, 0xc12c,		0x21, 0
	.dw 0x90c0, 0xc12c,	0x90ff, 0xc12c,		0x21, 0
	.dw 0x9140, 0xc12c,	0x917f, 0xc12c,		0x21, 0
	.dw 0x91c0, 0xc12c,	0x91ff, 0xc12c,		0x21, 0
	.dw 0x9240, 0xc12c,	0x927f, 0xc12c,		0x21, 0
	.dw 0x92c0, 0xc12c,	0x92ff, 0xc12c,		0x21, 0
	.dw 0x9340, 0xc12c,	0x937f, 0xc12c,		0x21, 0
	.dw 0x93c0, 0xc12c,	0x93ff, 0xc12c,		0x21, 0
	.dw 0x9440, 0xc12c,	0x947f, 0xc12c,		0x21, 0
	.dw 0x94c0, 0xc12c,	0x94ff, 0xc12c,		0x21, 0
	.dw 0x9540, 0xc12c,	0x957f, 0xc12c,		0x21, 0
	.dw 0x95c0, 0xc12c,	0x95ff, 0xc12c,		0x21, 0
	.dw 0x9640, 0xc12c,	0x967f, 0xc12c,		0x21, 0
	.dw 0x96c0, 0xc12c,	0x96ff, 0xc12c,		0x21, 0
	.dw 0x9740, 0xc12c,	0x977f, 0xc12c,		0x21, 0
	.dw 0x97c0, 0xc12c,	0x97ff, 0xc12c,		0x21, 0
	.dw 0x9840, 0xc12c,	0x987f, 0xc12c,		0x21, 0
	.dw 0x98c0, 0xc12c,	0x98ff, 0xc12c,		0x21, 0
	.dw 0x9940, 0xc12c,	0x997f, 0xc12c,		0x21, 0
	.dw 0x99c0, 0xc12c,	0x9fff, 0xc12c,		0x21, 0
	.dw 0xa040, 0xc12c,	0xa07f, 0xc12c,		0x21, 0
	.dw 0xa0c0, 0xc12c,	0xa0ff, 0xc12c,		0x21, 0
	.dw 0xa140, 0xc12c,	0xa17f, 0xc12c,		0x21, 0
	.dw 0xa1c0, 0xc12c,	0xa1ff, 0xc12c,		0x21, 0
	.dw 0xa240, 0xc12c,	0xa27f, 0xc12c,		0x21, 0
	.dw 0xa2c0, 0xc12c,	0xa2ff, 0xc12c,		0x21, 0
	.dw 0xa340, 0xc12c,	0xa37f, 0xc12c,		0x21, 0
	.dw 0xa3c0, 0xc12c,	0xa3ff, 0xc12c,		0x21, 0
	.dw 0xa440, 0xc12c,	0xa47f, 0xc12c,		0x21, 0
	.dw 0xa4c0, 0xc12c,	0xa4ff, 0xc12c,		0x21, 0
	.dw 0xa540, 0xc12c,	0xa57f, 0xc12c,		0x21, 0
	.dw 0xa5c0, 0xc12c,	0xa5ff, 0xc12c,		0x21, 0
	.dw 0xa640, 0xc12c,	0xa67f, 0xc12c,		0x21, 0
	.dw 0xa6c0, 0xc12c,	0xa6ff, 0xc12c,		0x21, 0
	.dw 0xa740, 0xc12c,	0xa77f, 0xc12c,		0x21, 0
	.dw 0xa7c0, 0xc12c,	0xa7ff, 0xc12c,		0x21, 0
	.dw 0xa840, 0xc12c,	0xa87f, 0xc12c,		0x21, 0
	.dw 0xa8c0, 0xc12c,	0xa8ff, 0xc12c,		0x21, 0
	.dw 0xa940, 0xc12c,	0xa97f, 0xc12c,		0x21, 0
	.dw 0xa9c0, 0xc12c,	0xa9ff, 0xc12c,		0x21, 0
	.dw 0xaa40, 0xc12c,	0xaa7f, 0xc12c,		0x21, 0
	.dw 0xaac0, 0xc12c,	0xaaff, 0xc12c,		0x21, 0
	.dw 0xab40, 0xc12c,	0xab7f, 0xc12c,		0x21, 0
	.dw 0xabc0, 0xc12c,	0xabff, 0xc12c,		0x21, 0
	.dw 0xac40, 0xc12c,	0xac7f, 0xc12c,		0x21, 0
	.dw 0xacc0, 0xc12c,	0xacff, 0xc12c,		0x21, 0
	.dw 0xad40, 0xc12c,	0xad7f, 0xc12c,		0x21, 0
	.dw 0xadc0, 0xc12c,	0xadff, 0xc12c,		0x21, 0
	.dw 0xae40, 0xc12c,	0xae7f, 0xc12c,		0x21, 0
	.dw 0xaec0, 0xc12c,	0xaeff, 0xc12c,		0x21, 0
	.dw 0xaf40, 0xc12c,	0xaf7f, 0xc12c,		0x21, 0
	.dw 0xafc0, 0xc12c,	0xafff, 0xc12c,		0x21, 0
	.dw 0xb040, 0xc12c,	0xb07f, 0xc12c,		0x21, 0
	.dw 0xb0c0, 0xc12c,	0xb0ff, 0xc12c,		0x21, 0
	.dw 0xb140, 0xc12c,	0xb17f, 0xc12c,		0x21, 0
	.dw 0xb1c0, 0xc12c,	0xb1ff, 0xc12c,		0x21, 0
	.dw 0xb240, 0xc12c,	0xb27f, 0xc12c,		0x21, 0
	.dw 0xb2c0, 0xc12c,	0xb2ff, 0xc12c,		0x21, 0
	.dw 0xb340, 0xc12c,	0xb37f, 0xc12c,		0x21, 0
	.dw 0xb3c0, 0xc12c,	0xb3ff, 0xc12c,		0x21, 0
	.dw 0xb440, 0xc12c,	0xb47f, 0xc12c,		0x21, 0
	.dw 0xb4c0, 0xc12c,	0xb4ff, 0xc12c,		0x21, 0
	.dw 0xb540, 0xc12c,	0xb57f, 0xc12c,		0x21, 0
	.dw 0xb5c0, 0xc12c,	0xb5ff, 0xc12c,		0x21, 0
	.dw 0xb640, 0xc12c,	0xb67f, 0xc12c,		0x21, 0
	.dw 0xb6c0, 0xc12c,	0xb6ff, 0xc12c,		0x21, 0
	.dw 0xb740, 0xc12c,	0xb77f, 0xc12c,		0x21, 0
	.dw 0xb7c0, 0xc12c,	0xb7ff, 0xc12c,		0x21, 0
	.dw 0xb840, 0xc12c,	0xb87f, 0xc12c,		0x21, 0
	.dw 0xb8c0, 0xc12c,	0xb8ff, 0xc12c,		0x21, 0
	.dw 0xb940, 0xc12c,	0xb97f, 0xc12c,		0x21, 0
	.dw 0xb9c0, 0xc12c,	0xbfff, 0xc12c,		0x21, 0
	.dw 0xc040, 0xc12c,	0xc07f, 0xc12c,		0x21, 0
	.dw 0xc0c0, 0xc12c,	0xc0ff, 0xc12c,		0x21, 0
	.dw 0xc140, 0xc12c,	0xc17f, 0xc12c,		0x21, 0
	.dw 0xc1c0, 0xc12c,	0xc1ff, 0xc12c,		0x21, 0
	.dw 0xc240, 0xc12c,	0xc27f, 0xc12c,		0x21, 0
	.dw 0xc2c0, 0xc12c,	0xc2ff, 0xc12c,		0x21, 0
	.dw 0xc340, 0xc12c,	0xc37f, 0xc12c,		0x21, 0
	.dw 0xc3c0, 0xc12c,	0xc3ff, 0xc12c,		0x21, 0
	.dw 0xc440, 0xc12c,	0xc47f, 0xc12c,		0x21, 0
	.dw 0xc4c0, 0xc12c,	0xc4ff, 0xc12c,		0x21, 0
	.dw 0xc540, 0xc12c,	0xc57f, 0xc12c,		0x21, 0
	.dw 0xc5c0, 0xc12c,	0xc5ff, 0xc12c,		0x21, 0
	.dw 0xc640, 0xc12c,	0xc67f, 0xc12c,		0x21, 0
	.dw 0xc6c0, 0xc12c,	0xc6ff, 0xc12c,		0x21, 0
	.dw 0xc740, 0xc12c,	0xc77f, 0xc12c,		0x21, 0
	.dw 0xc7c0, 0xc12c,	0xc7ff, 0xc12c,		0x21, 0
	.dw 0xc840, 0xc12c,	0xc87f, 0xc12c,		0x21, 0
	.dw 0xc8c0, 0xc12c,	0xc8ff, 0xc12c,		0x21, 0
	.dw 0xc940, 0xc12c,	0xc97f, 0xc12c,		0x21, 0
	.dw 0xc9c0, 0xc12c,	0xc9ff, 0xc12c,		0x21, 0
	.dw 0xca40, 0xc12c,	0xca7f, 0xc12c,		0x21, 0
	.dw 0xcac0, 0xc12c,	0xcaff, 0xc12c,		0x21, 0
	.dw 0xcb40, 0xc12c,	0xcb7f, 0xc12c,		0x21, 0
	.dw 0xcbc0, 0xc12c,	0xcbff, 0xc12c,		0x21, 0
	.dw 0xcc40, 0xc12c,	0xcc7f, 0xc12c,		0x21, 0
	.dw 0xccc0, 0xc12c,	0xccff, 0xc12c,		0x21, 0
	.dw 0xcd40, 0xc12c,	0xcd7f, 0xc12c,		0x21, 0
	.dw 0xcdc0, 0xc12c,	0xcdff, 0xc12c,		0x21, 0
	.dw 0xce40, 0xc12c,	0xce7f, 0xc12c,		0x21, 0
	.dw 0xcec0, 0xc12c,	0xceff, 0xc12c,		0x21, 0
	.dw 0xcf40, 0xc12c,	0xcf7f, 0xc12c,		0x21, 0
	.dw 0xcfc0, 0xc12c,	0xcfff, 0xc12c,		0x21, 0
	.dw 0xd040, 0xc12c,	0xd07f, 0xc12c,		0x21, 0
	.dw 0xd0c0, 0xc12c,	0xd0ff, 0xc12c,		0x21, 0
	.dw 0xd140, 0xc12c,	0xd17f, 0xc12c,		0x21, 0
	.dw 0xd1c0, 0xc12c,	0xd1ff, 0xc12c,		0x21, 0
	.dw 0xd240, 0xc12c,	0xd27f, 0xc12c,		0x21, 0
	.dw 0xd2c0, 0xc12c,	0xd2ff, 0xc12c,		0x21, 0
	.dw 0xd340, 0xc12c,	0xd37f, 0xc12c,		0x21, 0
	.dw 0xd3c0, 0xc12c,	0xd3ff, 0xc12c,		0x21, 0
	.dw 0xd440, 0xc12c,	0xd47f, 0xc12c,		0x21, 0
	.dw 0xd4c0, 0xc12c,	0xd4ff, 0xc12c,		0x21, 0
	.dw 0xd540, 0xc12c,	0xd57f, 0xc12c,		0x21, 0
	.dw 0xd5c0, 0xc12c,	0xd5ff, 0xc12c,		0x21, 0
	.dw 0xd640, 0xc12c,	0xd67f, 0xc12c,		0x21, 0
	.dw 0xd6c0, 0xc12c,	0xd6ff, 0xc12c,		0x21, 0
	.dw 0xd740, 0xc12c,	0xd77f, 0xc12c,		0x21, 0
	.dw 0xd7c0, 0xc12c,	0xd7ff, 0xc12c,		0x21, 0
	.dw 0xd840, 0xc12c,	0xd87f, 0xc12c,		0x21, 0
	.dw 0xd8c0, 0xc12c,	0xd8ff, 0xc12c,		0x21, 0
	.dw 0xd940, 0xc12c,	0xd97f, 0xc12c,		0x21, 0
	.dw 0xd9c0, 0xc12c,	0xdfff, 0xc12c,		0x21, 0
	.dw 0xe040, 0xc12c,	0xe07f, 0xc12c,		0x21, 0
	.dw 0xe0c0, 0xc12c,	0xe0ff, 0xc12c,		0x21, 0
	.dw 0xe140, 0xc12c,	0xe17f, 0xc12c,		0x21, 0
	.dw 0xe1c0, 0xc12c,	0xe1ff, 0xc12c,		0x21, 0
	.dw 0xe240, 0xc12c,	0xe27f, 0xc12c,		0x21, 0
	.dw 0xe2c0, 0xc12c,	0xe2ff, 0xc12c,		0x21, 0
	.dw 0xe340, 0xc12c,	0xe37f, 0xc12c,		0x21, 0
	.dw 0xe3c0, 0xc12c,	0xe3ff, 0xc12c,		0x21, 0
	.dw 0xe440, 0xc12c,	0xe47f, 0xc12c,		0x21, 0
	.dw 0xe4c0, 0xc12c,	0xe4ff, 0xc12c,		0x21, 0
	.dw 0xe540, 0xc12c,	0xe57f, 0xc12c,		0x21, 0
	.dw 0xe5c0, 0xc12c,	0xe5ff, 0xc12c,		0x21, 0
	.dw 0xe640, 0xc12c,	0xe67f, 0xc12c,		0x21, 0
	.dw 0xe6c0, 0xc12c,	0xe6ff, 0xc12c,		0x21, 0
	.dw 0xe740, 0xc12c,	0xe77f, 0xc12c,		0x21, 0
	.dw 0xe7c0, 0xc12c,	0xe7ff, 0xc12c,		0x21, 0
	.dw 0xe840, 0xc12c,	0xe87f, 0xc12c,		0x21, 0
	.dw 0xe8c0, 0xc12c,	0xe8ff, 0xc12c,		0x21, 0
	.dw 0xe940, 0xc12c,	0xe97f, 0xc12c,		0x21, 0
	.dw 0xe9c0, 0xc12c,	0xe9ff, 0xc12c,		0x21, 0
	.dw 0xea40, 0xc12c,	0xea7f, 0xc12c,		0x21, 0
	.dw 0xeac0, 0xc12c,	0xeaff, 0xc12c,		0x21, 0
	.dw 0xeb40, 0xc12c,	0xeb7f, 0xc12c,		0x21, 0
	.dw 0xebc0, 0xc12c,	0xebff, 0xc12c,		0x21, 0
	.dw 0xec40, 0xc12c,	0xec7f, 0xc12c,		0x21, 0
	.dw 0xecc0, 0xc12c,	0xecff, 0xc12c,		0x21, 0
	.dw 0xed40, 0xc12c,	0xed7f, 0xc12c,		0x21, 0
	.dw 0xedc0, 0xc12c,	0xedff, 0xc12c,		0x21, 0
	.dw 0xee40, 0xc12c,	0xee7f, 0xc12c,		0x21, 0
	.dw 0xeec0, 0xc12c,	0xeeff, 0xc12c,		0x21, 0
	.dw 0xef40, 0xc12c,	0xef7f, 0xc12c,		0x21, 0
	.dw 0xefc0, 0xc12c,	0xefff, 0xc12c,		0x21, 0
	.dw 0xf040, 0xc12c,	0xf07f, 0xc12c,		0x21, 0
	.dw 0xf0c0, 0xc12c,	0xf0ff, 0xc12c,		0x21, 0
	.dw 0xf140, 0xc12c,	0xf17f, 0xc12c,		0x21, 0
	.dw 0xf1c0, 0xc12c,	0xf1ff, 0xc12c,		0x21, 0
	.dw 0xf240, 0xc12c,	0xf27f, 0xc12c,		0x21, 0
	.dw 0xf2c0, 0xc12c,	0xf2ff, 0xc12c,		0x21, 0
	.dw 0xf340, 0xc12c,	0xf37f, 0xc12c,		0x21, 0
	.dw 0xf3c0, 0xc12c,	0xf3ff, 0xc12c,		0x21, 0
	.dw 0xf440, 0xc12c,	0xf47f, 0xc12c,		0x21, 0
	.dw 0xf4c0, 0xc12c,	0xf4ff, 0xc12c,		0x21, 0
	.dw 0xf540, 0xc12c,	0xf57f, 0xc12c,		0x21, 0
	.dw 0xf5c0, 0xc12c,	0xf5ff, 0xc12c,		0x21, 0
	.dw 0xf640, 0xc12c,	0xf67f, 0xc12c,		0x21, 0
	.dw 0xf6c0, 0xc12c,	0xf6ff, 0xc12c,		0x21, 0
	.dw 0xf740, 0xc12c,	0xf77f, 0xc12c,		0x21, 0
	.dw 0xf7c0, 0xc12c,	0xf7ff, 0xc12c,		0x21, 0
	.dw 0xf840, 0xc12c,	0xf87f, 0xc12c,		0x21, 0
	.dw 0xf8c0, 0xc12c,	0xf8ff, 0xc12c,		0x21, 0
	.dw 0xf940, 0xc12c,	0xf97f, 0xc12c,		0x21, 0
	.dw 0xf9c0, 0xc12c,	0xffff, 0xc12c,		0x21, 0
	.dw 0x0040, 0xc12d,	0x007f, 0xc12d,		0x21, 0
	.dw 0x00c0, 0xc12d,	0x00ff, 0xc12d,		0x21, 0
	.dw 0x0140, 0xc12d,	0x017f, 0xc12d,		0x21, 0
	.dw 0x01c0, 0xc12d,	0x01ff, 0xc12d,		0x21, 0
	.dw 0x0240, 0xc12d,	0x027f, 0xc12d,		0x21, 0
	.dw 0x02c0, 0xc12d,	0x02ff, 0xc12d,		0x21, 0
	.dw 0x0340, 0xc12d,	0x037f, 0xc12d,		0x21, 0
	.dw 0x03c0, 0xc12d,	0x03ff, 0xc12d,		0x21, 0
	.dw 0x0440, 0xc12d,	0x047f, 0xc12d,		0x21, 0
	.dw 0x04c0, 0xc12d,	0x04ff, 0xc12d,		0x21, 0
	.dw 0x0540, 0xc12d,	0x057f, 0xc12d,		0x21, 0
	.dw 0x05c0, 0xc12d,	0x05ff, 0xc12d,		0x21, 0
	.dw 0x0640, 0xc12d,	0x067f, 0xc12d,		0x21, 0
	.dw 0x06c0, 0xc12d,	0x06ff, 0xc12d,		0x21, 0
	.dw 0x0740, 0xc12d,	0x077f, 0xc12d,		0x21, 0
	.dw 0x07c0, 0xc12d,	0x07ff, 0xc12d,		0x21, 0
	.dw 0x0840, 0xc12d,	0x087f, 0xc12d,		0x21, 0
	.dw 0x08c0, 0xc12d,	0x08ff, 0xc12d,		0x21, 0
	.dw 0x0940, 0xc12d,	0x097f, 0xc12d,		0x21, 0
	.dw 0x09c0, 0xc12d,	0x09ff, 0xc12d,		0x21, 0
	.dw 0x0a40, 0xc12d,	0x0a7f, 0xc12d,		0x21, 0
	.dw 0x0ac0, 0xc12d,	0x0aff, 0xc12d,		0x21, 0
	.dw 0x0b40, 0xc12d,	0x0b7f, 0xc12d,		0x21, 0
	.dw 0x0bc0, 0xc12d,	0x0bff, 0xc12d,		0x21, 0
	.dw 0x0c40, 0xc12d,	0x0c7f, 0xc12d,		0x21, 0
	.dw 0x0cc0, 0xc12d,	0x0cff, 0xc12d,		0x21, 0
	.dw 0x0d40, 0xc12d,	0x0d7f, 0xc12d,		0x21, 0
	.dw 0x0dc0, 0xc12d,	0x0dff, 0xc12d,		0x21, 0
	.dw 0x0e40, 0xc12d,	0x0e7f, 0xc12d,		0x21, 0
	.dw 0x0ec0, 0xc12d,	0x0eff, 0xc12d,		0x21, 0
	.dw 0x0f40, 0xc12d,	0x0f7f, 0xc12d,		0x21, 0
	.dw 0x0fc0, 0xc12d,	0x0fff, 0xc12d,		0x21, 0
	.dw 0x1040, 0xc12d,	0x107f, 0xc12d,		0x21, 0
	.dw 0x10c0, 0xc12d,	0x10ff, 0xc12d,		0x21, 0
	.dw 0x1140, 0xc12d,	0x117f, 0xc12d,		0x21, 0
	.dw 0x11c0, 0xc12d,	0x11ff, 0xc12d,		0x21, 0
	.dw 0x1240, 0xc12d,	0x127f, 0xc12d,		0x21, 0
	.dw 0x12c0, 0xc12d,	0x12ff, 0xc12d,		0x21, 0
	.dw 0x1340, 0xc12d,	0x137f, 0xc12d,		0x21, 0
	.dw 0x13c0, 0xc12d,	0x13ff, 0xc12d,		0x21, 0
	.dw 0x1440, 0xc12d,	0x147f, 0xc12d,		0x21, 0
	.dw 0x14c0, 0xc12d,	0x14ff, 0xc12d,		0x21, 0
	.dw 0x1540, 0xc12d,	0x157f, 0xc12d,		0x21, 0
	.dw 0x15c0, 0xc12d,	0x15ff, 0xc12d,		0x21, 0
	.dw 0x1640, 0xc12d,	0x167f, 0xc12d,		0x21, 0
	.dw 0x16c0, 0xc12d,	0x16ff, 0xc12d,		0x21, 0
	.dw 0x1740, 0xc12d,	0x177f, 0xc12d,		0x21, 0
	.dw 0x17c0, 0xc12d,	0x17ff, 0xc12d,		0x21, 0
	.dw 0x1840, 0xc12d,	0x187f, 0xc12d,		0x21, 0
	.dw 0x18c0, 0xc12d,	0x18ff, 0xc12d,		0x21, 0
	.dw 0x1940, 0xc12d,	0x197f, 0xc12d,		0x21, 0
	.dw 0x19c0, 0xc12d,	0x1fff, 0xc12d,		0x21, 0
	.dw 0x2040, 0xc12d,	0x207f, 0xc12d,		0x21, 0
	.dw 0x20c0, 0xc12d,	0x20ff, 0xc12d,		0x21, 0
	.dw 0x2140, 0xc12d,	0x217f, 0xc12d,		0x21, 0
	.dw 0x21c0, 0xc12d,	0x21ff, 0xc12d,		0x21, 0
	.dw 0x2240, 0xc12d,	0x227f, 0xc12d,		0x21, 0
	.dw 0x22c0, 0xc12d,	0x22ff, 0xc12d,		0x21, 0
	.dw 0x2340, 0xc12d,	0x237f, 0xc12d,		0x21, 0
	.dw 0x23c0, 0xc12d,	0x23ff, 0xc12d,		0x21, 0
	.dw 0x2440, 0xc12d,	0x247f, 0xc12d,		0x21, 0
	.dw 0x24c0, 0xc12d,	0x24ff, 0xc12d,		0x21, 0
	.dw 0x2540, 0xc12d,	0x257f, 0xc12d,		0x21, 0
	.dw 0x25c0, 0xc12d,	0x25ff, 0xc12d,		0x21, 0
	.dw 0x2640, 0xc12d,	0x267f, 0xc12d,		0x21, 0
	.dw 0x26c0, 0xc12d,	0x26ff, 0xc12d,		0x21, 0
	.dw 0x2740, 0xc12d,	0x277f, 0xc12d,		0x21, 0
	.dw 0x27c0, 0xc12d,	0x27ff, 0xc12d,		0x21, 0
	.dw 0x2840, 0xc12d,	0x287f, 0xc12d,		0x21, 0
	.dw 0x28c0, 0xc12d,	0x28ff, 0xc12d,		0x21, 0
	.dw 0x2940, 0xc12d,	0x297f, 0xc12d,		0x21, 0
	.dw 0x29c0, 0xc12d,	0x29ff, 0xc12d,		0x21, 0
	.dw 0x2a40, 0xc12d,	0x2a7f, 0xc12d,		0x21, 0
	.dw 0x2ac0, 0xc12d,	0x2aff, 0xc12d,		0x21, 0
	.dw 0x2b40, 0xc12d,	0x2b7f, 0xc12d,		0x21, 0
	.dw 0x2bc0, 0xc12d,	0x2bff, 0xc12d,		0x21, 0
	.dw 0x2c40, 0xc12d,	0x2c7f, 0xc12d,		0x21, 0
	.dw 0x2cc0, 0xc12d,	0x2cff, 0xc12d,		0x21, 0
	.dw 0x2d40, 0xc12d,	0x2d7f, 0xc12d,		0x21, 0
	.dw 0x2dc0, 0xc12d,	0x2dff, 0xc12d,		0x21, 0
	.dw 0x2e40, 0xc12d,	0x2e7f, 0xc12d,		0x21, 0
	.dw 0x2ec0, 0xc12d,	0x2eff, 0xc12d,		0x21, 0
	.dw 0x2f40, 0xc12d,	0x2f7f, 0xc12d,		0x21, 0
	.dw 0x2fc0, 0xc12d,	0x2fff, 0xc12d,		0x21, 0
	.dw 0x3040, 0xc12d,	0x307f, 0xc12d,		0x21, 0
	.dw 0x30c0, 0xc12d,	0x30ff, 0xc12d,		0x21, 0
	.dw 0x3140, 0xc12d,	0x317f, 0xc12d,		0x21, 0
	.dw 0x31c0, 0xc12d,	0x31ff, 0xc12d,		0x21, 0
	.dw 0x3240, 0xc12d,	0x327f, 0xc12d,		0x21, 0
	.dw 0x32c0, 0xc12d,	0x32ff, 0xc12d,		0x21, 0
	.dw 0x3340, 0xc12d,	0x337f, 0xc12d,		0x21, 0
	.dw 0x33c0, 0xc12d,	0x33ff, 0xc12d,		0x21, 0
	.dw 0x3440, 0xc12d,	0x347f, 0xc12d,		0x21, 0
	.dw 0x34c0, 0xc12d,	0x34ff, 0xc12d,		0x21, 0
	.dw 0x3540, 0xc12d,	0x357f, 0xc12d,		0x21, 0
	.dw 0x35c0, 0xc12d,	0x35ff, 0xc12d,		0x21, 0
	.dw 0x3640, 0xc12d,	0x367f, 0xc12d,		0x21, 0
	.dw 0x36c0, 0xc12d,	0x36ff, 0xc12d,		0x21, 0
	.dw 0x3740, 0xc12d,	0x377f, 0xc12d,		0x21, 0
	.dw 0x37c0, 0xc12d,	0x37ff, 0xc12d,		0x21, 0
	.dw 0x3840, 0xc12d,	0x387f, 0xc12d,		0x21, 0
	.dw 0x38c0, 0xc12d,	0x38ff, 0xc12d,		0x21, 0
	.dw 0x3940, 0xc12d,	0x397f, 0xc12d,		0x21, 0
	.dw 0x39c0, 0xc12d,	0x3fff, 0xc12d,		0x21, 0
	.dw 0x4040, 0xc12d,	0x407f, 0xc12d,		0x21, 0
	.dw 0x40c0, 0xc12d,	0x40ff, 0xc12d,		0x21, 0
	.dw 0x4140, 0xc12d,	0x417f, 0xc12d,		0x21, 0
	.dw 0x41c0, 0xc12d,	0x41ff, 0xc12d,		0x21, 0
	.dw 0x4240, 0xc12d,	0x427f, 0xc12d,		0x21, 0
	.dw 0x42c0, 0xc12d,	0x42ff, 0xc12d,		0x21, 0
	.dw 0x4340, 0xc12d,	0x437f, 0xc12d,		0x21, 0
	.dw 0x43c0, 0xc12d,	0x43ff, 0xc12d,		0x21, 0
	.dw 0x4440, 0xc12d,	0x447f, 0xc12d,		0x21, 0
	.dw 0x44c0, 0xc12d,	0x44ff, 0xc12d,		0x21, 0
	.dw 0x4540, 0xc12d,	0x457f, 0xc12d,		0x21, 0
	.dw 0x45c0, 0xc12d,	0x45ff, 0xc12d,		0x21, 0
	.dw 0x4640, 0xc12d,	0x467f, 0xc12d,		0x21, 0
	.dw 0x46c0, 0xc12d,	0x46ff, 0xc12d,		0x21, 0
	.dw 0x4740, 0xc12d,	0x477f, 0xc12d,		0x21, 0
	.dw 0x47c0, 0xc12d,	0x47ff, 0xc12d,		0x21, 0
	.dw 0x4840, 0xc12d,	0x487f, 0xc12d,		0x21, 0
	.dw 0x48c0, 0xc12d,	0x48ff, 0xc12d,		0x21, 0
	.dw 0x4940, 0xc12d,	0x497f, 0xc12d,		0x21, 0
	.dw 0x49c0, 0xc12d,	0x49ff, 0xc12d,		0x21, 0
	.dw 0x4a40, 0xc12d,	0x4a7f, 0xc12d,		0x21, 0
	.dw 0x4ac0, 0xc12d,	0x4aff, 0xc12d,		0x21, 0
	.dw 0x4b40, 0xc12d,	0x4b7f, 0xc12d,		0x21, 0
	.dw 0x4bc0, 0xc12d,	0x4bff, 0xc12d,		0x21, 0
	.dw 0x4c40, 0xc12d,	0x4c7f, 0xc12d,		0x21, 0
	.dw 0x4cc0, 0xc12d,	0x4cff, 0xc12d,		0x21, 0
	.dw 0x4d40, 0xc12d,	0x4d7f, 0xc12d,		0x21, 0
	.dw 0x4dc0, 0xc12d,	0x4dff, 0xc12d,		0x21, 0
	.dw 0x4e40, 0xc12d,	0x4e7f, 0xc12d,		0x21, 0
	.dw 0x4ec0, 0xc12d,	0x4eff, 0xc12d,		0x21, 0
	.dw 0x4f40, 0xc12d,	0x4f7f, 0xc12d,		0x21, 0
	.dw 0x4fc0, 0xc12d,	0x4fff, 0xc12d,		0x21, 0
	.dw 0x5040, 0xc12d,	0x507f, 0xc12d,		0x21, 0
	.dw 0x50c0, 0xc12d,	0x50ff, 0xc12d,		0x21, 0
	.dw 0x5140, 0xc12d,	0x517f, 0xc12d,		0x21, 0
	.dw 0x51c0, 0xc12d,	0x51ff, 0xc12d,		0x21, 0
	.dw 0x5240, 0xc12d,	0x527f, 0xc12d,		0x21, 0
	.dw 0x52c0, 0xc12d,	0x52ff, 0xc12d,		0x21, 0
	.dw 0x5340, 0xc12d,	0x537f, 0xc12d,		0x21, 0
	.dw 0x53c0, 0xc12d,	0x53ff, 0xc12d,		0x21, 0
	.dw 0x5440, 0xc12d,	0x547f, 0xc12d,		0x21, 0
	.dw 0x54c0, 0xc12d,	0x54ff, 0xc12d,		0x21, 0
	.dw 0x5540, 0xc12d,	0x557f, 0xc12d,		0x21, 0
	.dw 0x55c0, 0xc12d,	0x55ff, 0xc12d,		0x21, 0
	.dw 0x5640, 0xc12d,	0x567f, 0xc12d,		0x21, 0
	.dw 0x56c0, 0xc12d,	0x56ff, 0xc12d,		0x21, 0
	.dw 0x5740, 0xc12d,	0x577f, 0xc12d,		0x21, 0
	.dw 0x57c0, 0xc12d,	0x57ff, 0xc12d,		0x21, 0
	.dw 0x5840, 0xc12d,	0x587f, 0xc12d,		0x21, 0
	.dw 0x58c0, 0xc12d,	0x58ff, 0xc12d,		0x21, 0
	.dw 0x5940, 0xc12d,	0x597f, 0xc12d,		0x21, 0
	.dw 0x59c0, 0xc12d,	0x5fff, 0xc12d,		0x21, 0
	.dw 0x6040, 0xc12d,	0x607f, 0xc12d,		0x21, 0
	.dw 0x60c0, 0xc12d,	0x60ff, 0xc12d,		0x21, 0
	.dw 0x6140, 0xc12d,	0x617f, 0xc12d,		0x21, 0
	.dw 0x61c0, 0xc12d,	0x61ff, 0xc12d,		0x21, 0
	.dw 0x6240, 0xc12d,	0x627f, 0xc12d,		0x21, 0
	.dw 0x62c0, 0xc12d,	0x62ff, 0xc12d,		0x21, 0
	.dw 0x6340, 0xc12d,	0x637f, 0xc12d,		0x21, 0
	.dw 0x63c0, 0xc12d,	0x63ff, 0xc12d,		0x21, 0
	.dw 0x6440, 0xc12d,	0x647f, 0xc12d,		0x21, 0
	.dw 0x64c0, 0xc12d,	0x64ff, 0xc12d,		0x21, 0
	.dw 0x6540, 0xc12d,	0x657f, 0xc12d,		0x21, 0
	.dw 0x65c0, 0xc12d,	0x65ff, 0xc12d,		0x21, 0
	.dw 0x6640, 0xc12d,	0x667f, 0xc12d,		0x21, 0
	.dw 0x66c0, 0xc12d,	0x66ff, 0xc12d,		0x21, 0
	.dw 0x6740, 0xc12d,	0x677f, 0xc12d,		0x21, 0
	.dw 0x67c0, 0xc12d,	0x67ff, 0xc12d,		0x21, 0
	.dw 0x6840, 0xc12d,	0x687f, 0xc12d,		0x21, 0
	.dw 0x68c0, 0xc12d,	0x68ff, 0xc12d,		0x21, 0
	.dw 0x6940, 0xc12d,	0x697f, 0xc12d,		0x21, 0
	.dw 0x69c0, 0xc12d,	0x69ff, 0xc12d,		0x21, 0
	.dw 0x6a40, 0xc12d,	0x6a7f, 0xc12d,		0x21, 0
	.dw 0x6ac0, 0xc12d,	0x6aff, 0xc12d,		0x21, 0
	.dw 0x6b40, 0xc12d,	0x6b7f, 0xc12d,		0x21, 0
	.dw 0x6bc0, 0xc12d,	0x6bff, 0xc12d,		0x21, 0
	.dw 0x6c40, 0xc12d,	0x6c7f, 0xc12d,		0x21, 0
	.dw 0x6cc0, 0xc12d,	0x6cff, 0xc12d,		0x21, 0
	.dw 0x6d40, 0xc12d,	0x6d7f, 0xc12d,		0x21, 0
	.dw 0x6dc0, 0xc12d,	0x6dff, 0xc12d,		0x21, 0
	.dw 0x6e40, 0xc12d,	0x6e7f, 0xc12d,		0x21, 0
	.dw 0x6ec0, 0xc12d,	0x6eff, 0xc12d,		0x21, 0
	.dw 0x6f40, 0xc12d,	0x6f7f, 0xc12d,		0x21, 0
	.dw 0x6fc0, 0xc12d,	0x6fff, 0xc12d,		0x21, 0
	.dw 0x7040, 0xc12d,	0x707f, 0xc12d,		0x21, 0
	.dw 0x70c0, 0xc12d,	0x70ff, 0xc12d,		0x21, 0
	.dw 0x7140, 0xc12d,	0x717f, 0xc12d,		0x21, 0
	.dw 0x71c0, 0xc12d,	0x71ff, 0xc12d,		0x21, 0
	.dw 0x7240, 0xc12d,	0x727f, 0xc12d,		0x21, 0
	.dw 0x72c0, 0xc12d,	0x72ff, 0xc12d,		0x21, 0
	.dw 0x7340, 0xc12d,	0x737f, 0xc12d,		0x21, 0
	.dw 0x73c0, 0xc12d,	0x73ff, 0xc12d,		0x21, 0
	.dw 0x7440, 0xc12d,	0x747f, 0xc12d,		0x21, 0
	.dw 0x74c0, 0xc12d,	0x74ff, 0xc12d,		0x21, 0
	.dw 0x7540, 0xc12d,	0x757f, 0xc12d,		0x21, 0
	.dw 0x75c0, 0xc12d,	0x75ff, 0xc12d,		0x21, 0
	.dw 0x7640, 0xc12d,	0x767f, 0xc12d,		0x21, 0
	.dw 0x76c0, 0xc12d,	0x76ff, 0xc12d,		0x21, 0
	.dw 0x7740, 0xc12d,	0x777f, 0xc12d,		0x21, 0
	.dw 0x77c0, 0xc12d,	0x77ff, 0xc12d,		0x21, 0
	.dw 0x7840, 0xc12d,	0x787f, 0xc12d,		0x21, 0
	.dw 0x78c0, 0xc12d,	0x78ff, 0xc12d,		0x21, 0
	.dw 0x7940, 0xc12d,	0x797f, 0xc12d,		0x21, 0
	.dw 0x79c0, 0xc12d,	0x7fff, 0xc12d,		0x21, 0
	.dw 0x8040, 0xc12d,	0x807f, 0xc12d,		0x21, 0
	.dw 0x80c0, 0xc12d,	0x80ff, 0xc12d,		0x21, 0
	.dw 0x8140, 0xc12d,	0x817f, 0xc12d,		0x21, 0
	.dw 0x81c0, 0xc12d,	0x81ff, 0xc12d,		0x21, 0
	.dw 0x8240, 0xc12d,	0x827f, 0xc12d,		0x21, 0
	.dw 0x82c0, 0xc12d,	0x82ff, 0xc12d,		0x21, 0
	.dw 0x8340, 0xc12d,	0x837f, 0xc12d,		0x21, 0
	.dw 0x83c0, 0xc12d,	0x83ff, 0xc12d,		0x21, 0
	.dw 0x8440, 0xc12d,	0x847f, 0xc12d,		0x21, 0
	.dw 0x84c0, 0xc12d,	0x84ff, 0xc12d,		0x21, 0
	.dw 0x8540, 0xc12d,	0x857f, 0xc12d,		0x21, 0
	.dw 0x85c0, 0xc12d,	0x85ff, 0xc12d,		0x21, 0
	.dw 0x8640, 0xc12d,	0x867f, 0xc12d,		0x21, 0
	.dw 0x86c0, 0xc12d,	0x86ff, 0xc12d,		0x21, 0
	.dw 0x8740, 0xc12d,	0x877f, 0xc12d,		0x21, 0
	.dw 0x87c0, 0xc12d,	0x87ff, 0xc12d,		0x21, 0
	.dw 0x8840, 0xc12d,	0x887f, 0xc12d,		0x21, 0
	.dw 0x88c0, 0xc12d,	0x88ff, 0xc12d,		0x21, 0
	.dw 0x8940, 0xc12d,	0x897f, 0xc12d,		0x21, 0
	.dw 0x89c0, 0xc12d,	0x89ff, 0xc12d,		0x21, 0
	.dw 0x8a40, 0xc12d,	0x8a7f, 0xc12d,		0x21, 0
	.dw 0x8ac0, 0xc12d,	0x8aff, 0xc12d,		0x21, 0
	.dw 0x8b40, 0xc12d,	0x8b7f, 0xc12d,		0x21, 0
	.dw 0x8bc0, 0xc12d,	0x8bff, 0xc12d,		0x21, 0
	.dw 0x8c40, 0xc12d,	0x8c7f, 0xc12d,		0x21, 0
	.dw 0x8cc0, 0xc12d,	0x8cff, 0xc12d,		0x21, 0
	.dw 0x8d40, 0xc12d,	0x8d7f, 0xc12d,		0x21, 0
	.dw 0x8dc0, 0xc12d,	0x8dff, 0xc12d,		0x21, 0
	.dw 0x8e40, 0xc12d,	0x8e7f, 0xc12d,		0x21, 0
	.dw 0x8ec0, 0xc12d,	0x8eff, 0xc12d,		0x21, 0
	.dw 0x8f40, 0xc12d,	0x8f7f, 0xc12d,		0x21, 0
	.dw 0x8fc0, 0xc12d,	0x8fff, 0xc12d,		0x21, 0
	.dw 0x9040, 0xc12d,	0x907f, 0xc12d,		0x21, 0
	.dw 0x90c0, 0xc12d,	0x90ff, 0xc12d,		0x21, 0
	.dw 0x9140, 0xc12d,	0x917f, 0xc12d,		0x21, 0
	.dw 0x91c0, 0xc12d,	0x91ff, 0xc12d,		0x21, 0
	.dw 0x9240, 0xc12d,	0x927f, 0xc12d,		0x21, 0
	.dw 0x92c0, 0xc12d,	0x92ff, 0xc12d,		0x21, 0
	.dw 0x9340, 0xc12d,	0x937f, 0xc12d,		0x21, 0
	.dw 0x93c0, 0xc12d,	0x93ff, 0xc12d,		0x21, 0
	.dw 0x9440, 0xc12d,	0x947f, 0xc12d,		0x21, 0
	.dw 0x94c0, 0xc12d,	0x94ff, 0xc12d,		0x21, 0
	.dw 0x9540, 0xc12d,	0x957f, 0xc12d,		0x21, 0
	.dw 0x95c0, 0xc12d,	0x95ff, 0xc12d,		0x21, 0
	.dw 0x9640, 0xc12d,	0x967f, 0xc12d,		0x21, 0
	.dw 0x96c0, 0xc12d,	0x96ff, 0xc12d,		0x21, 0
	.dw 0x9740, 0xc12d,	0x977f, 0xc12d,		0x21, 0
	.dw 0x97c0, 0xc12d,	0x97ff, 0xc12d,		0x21, 0
	.dw 0x9840, 0xc12d,	0x987f, 0xc12d,		0x21, 0
	.dw 0x98c0, 0xc12d,	0x98ff, 0xc12d,		0x21, 0
	.dw 0x9940, 0xc12d,	0x997f, 0xc12d,		0x21, 0
	.dw 0x99c0, 0xc12d,	0x9fff, 0xc12d,		0x21, 0
	.dw 0xa040, 0xc12d,	0xa07f, 0xc12d,		0x21, 0
	.dw 0xa0c0, 0xc12d,	0xa0ff, 0xc12d,		0x21, 0
	.dw 0xa140, 0xc12d,	0xa17f, 0xc12d,		0x21, 0
	.dw 0xa1c0, 0xc12d,	0xa1ff, 0xc12d,		0x21, 0
	.dw 0xa240, 0xc12d,	0xa27f, 0xc12d,		0x21, 0
	.dw 0xa2c0, 0xc12d,	0xa2ff, 0xc12d,		0x21, 0
	.dw 0xa340, 0xc12d,	0xa37f, 0xc12d,		0x21, 0
	.dw 0xa3c0, 0xc12d,	0xa3ff, 0xc12d,		0x21, 0
	.dw 0xa440, 0xc12d,	0xa47f, 0xc12d,		0x21, 0
	.dw 0xa4c0, 0xc12d,	0xa4ff, 0xc12d,		0x21, 0
	.dw 0xa540, 0xc12d,	0xa57f, 0xc12d,		0x21, 0
	.dw 0xa5c0, 0xc12d,	0xa5ff, 0xc12d,		0x21, 0
	.dw 0xa640, 0xc12d,	0xa67f, 0xc12d,		0x21, 0
	.dw 0xa6c0, 0xc12d,	0xa6ff, 0xc12d,		0x21, 0
	.dw 0xa740, 0xc12d,	0xa77f, 0xc12d,		0x21, 0
	.dw 0xa7c0, 0xc12d,	0xa7ff, 0xc12d,		0x21, 0
	.dw 0xa840, 0xc12d,	0xa87f, 0xc12d,		0x21, 0
	.dw 0xa8c0, 0xc12d,	0xa8ff, 0xc12d,		0x21, 0
	.dw 0xa940, 0xc12d,	0xa97f, 0xc12d,		0x21, 0
	.dw 0xa9c0, 0xc12d,	0xa9ff, 0xc12d,		0x21, 0
	.dw 0xaa40, 0xc12d,	0xaa7f, 0xc12d,		0x21, 0
	.dw 0xaac0, 0xc12d,	0xaaff, 0xc12d,		0x21, 0
	.dw 0xab40, 0xc12d,	0xab7f, 0xc12d,		0x21, 0
	.dw 0xabc0, 0xc12d,	0xabff, 0xc12d,		0x21, 0
	.dw 0xac40, 0xc12d,	0xac7f, 0xc12d,		0x21, 0
	.dw 0xacc0, 0xc12d,	0xacff, 0xc12d,		0x21, 0
	.dw 0xad40, 0xc12d,	0xad7f, 0xc12d,		0x21, 0
	.dw 0xadc0, 0xc12d,	0xadff, 0xc12d,		0x21, 0
	.dw 0xae40, 0xc12d,	0xae7f, 0xc12d,		0x21, 0
	.dw 0xaec0, 0xc12d,	0xaeff, 0xc12d,		0x21, 0
	.dw 0xaf40, 0xc12d,	0xaf7f, 0xc12d,		0x21, 0
	.dw 0xafc0, 0xc12d,	0xafff, 0xc12d,		0x21, 0
	.dw 0xb040, 0xc12d,	0xb07f, 0xc12d,		0x21, 0
	.dw 0xb0c0, 0xc12d,	0xb0ff, 0xc12d,		0x21, 0
	.dw 0xb140, 0xc12d,	0xb17f, 0xc12d,		0x21, 0
	.dw 0xb1c0, 0xc12d,	0xb1ff, 0xc12d,		0x21, 0
	.dw 0xb240, 0xc12d,	0xb27f, 0xc12d,		0x21, 0
	.dw 0xb2c0, 0xc12d,	0xb2ff, 0xc12d,		0x21, 0
	.dw 0xb340, 0xc12d,	0xb37f, 0xc12d,		0x21, 0
	.dw 0xb3c0, 0xc12d,	0xb3ff, 0xc12d,		0x21, 0
	.dw 0xb440, 0xc12d,	0xb47f, 0xc12d,		0x21, 0
	.dw 0xb4c0, 0xc12d,	0xb4ff, 0xc12d,		0x21, 0
	.dw 0xb540, 0xc12d,	0xb57f, 0xc12d,		0x21, 0
	.dw 0xb5c0, 0xc12d,	0xb5ff, 0xc12d,		0x21, 0
	.dw 0xb640, 0xc12d,	0xb67f, 0xc12d,		0x21, 0
	.dw 0xb6c0, 0xc12d,	0xb6ff, 0xc12d,		0x21, 0
	.dw 0xb740, 0xc12d,	0xb77f, 0xc12d,		0x21, 0
	.dw 0xb7c0, 0xc12d,	0xb7ff, 0xc12d,		0x21, 0
	.dw 0xb840, 0xc12d,	0xb87f, 0xc12d,		0x21, 0
	.dw 0xb8c0, 0xc12d,	0xb8ff, 0xc12d,		0x21, 0
	.dw 0xb940, 0xc12d,	0xb97f, 0xc12d,		0x21, 0
	.dw 0xb9c0, 0xc12d,	0xbfff, 0xc12d,		0x21, 0
	.dw 0xc040, 0xc12d,	0xc07f, 0xc12d,		0x21, 0
	.dw 0xc0c0, 0xc12d,	0xc0ff, 0xc12d,		0x21, 0
	.dw 0xc140, 0xc12d,	0xc17f, 0xc12d,		0x21, 0
	.dw 0xc1c0, 0xc12d,	0xc1ff, 0xc12d,		0x21, 0
	.dw 0xc240, 0xc12d,	0xc27f, 0xc12d,		0x21, 0
	.dw 0xc2c0, 0xc12d,	0xc2ff, 0xc12d,		0x21, 0
	.dw 0xc340, 0xc12d,	0xc37f, 0xc12d,		0x21, 0
	.dw 0xc3c0, 0xc12d,	0xc3ff, 0xc12d,		0x21, 0
	.dw 0xc440, 0xc12d,	0xc47f, 0xc12d,		0x21, 0
	.dw 0xc4c0, 0xc12d,	0xc4ff, 0xc12d,		0x21, 0
	.dw 0xc540, 0xc12d,	0xc57f, 0xc12d,		0x21, 0
	.dw 0xc5c0, 0xc12d,	0xc5ff, 0xc12d,		0x21, 0
	.dw 0xc640, 0xc12d,	0xc67f, 0xc12d,		0x21, 0
	.dw 0xc6c0, 0xc12d,	0xc6ff, 0xc12d,		0x21, 0
	.dw 0xc740, 0xc12d,	0xc77f, 0xc12d,		0x21, 0
	.dw 0xc7c0, 0xc12d,	0xc7ff, 0xc12d,		0x21, 0
	.dw 0xc840, 0xc12d,	0xc87f, 0xc12d,		0x21, 0
	.dw 0xc8c0, 0xc12d,	0xc8ff, 0xc12d,		0x21, 0
	.dw 0xc940, 0xc12d,	0xc97f, 0xc12d,		0x21, 0
	.dw 0xc9c0, 0xc12d,	0xc9ff, 0xc12d,		0x21, 0
	.dw 0xca40, 0xc12d,	0xca7f, 0xc12d,		0x21, 0
	.dw 0xcac0, 0xc12d,	0xcaff, 0xc12d,		0x21, 0
	.dw 0xcb40, 0xc12d,	0xcb7f, 0xc12d,		0x21, 0
	.dw 0xcbc0, 0xc12d,	0xcbff, 0xc12d,		0x21, 0
	.dw 0xcc40, 0xc12d,	0xcc7f, 0xc12d,		0x21, 0
	.dw 0xccc0, 0xc12d,	0xccff, 0xc12d,		0x21, 0
	.dw 0xcd40, 0xc12d,	0xcd7f, 0xc12d,		0x21, 0
	.dw 0xcdc0, 0xc12d,	0xcdff, 0xc12d,		0x21, 0
	.dw 0xce40, 0xc12d,	0xce7f, 0xc12d,		0x21, 0
	.dw 0xcec0, 0xc12d,	0xceff, 0xc12d,		0x21, 0
	.dw 0xcf40, 0xc12d,	0xcf7f, 0xc12d,		0x21, 0
	.dw 0xcfc0, 0xc12d,	0xcfff, 0xc12d,		0x21, 0
	.dw 0xd040, 0xc12d,	0xd07f, 0xc12d,		0x21, 0
	.dw 0xd0c0, 0xc12d,	0xd0ff, 0xc12d,		0x21, 0
	.dw 0xd140, 0xc12d,	0xd17f, 0xc12d,		0x21, 0
	.dw 0xd1c0, 0xc12d,	0xd1ff, 0xc12d,		0x21, 0
	.dw 0xd240, 0xc12d,	0xd27f, 0xc12d,		0x21, 0
	.dw 0xd2c0, 0xc12d,	0xd2ff, 0xc12d,		0x21, 0
	.dw 0xd340, 0xc12d,	0xd37f, 0xc12d,		0x21, 0
	.dw 0xd3c0, 0xc12d,	0xd3ff, 0xc12d,		0x21, 0
	.dw 0xd440, 0xc12d,	0xd47f, 0xc12d,		0x21, 0
	.dw 0xd4c0, 0xc12d,	0xd4ff, 0xc12d,		0x21, 0
	.dw 0xd540, 0xc12d,	0xd57f, 0xc12d,		0x21, 0
	.dw 0xd5c0, 0xc12d,	0xd5ff, 0xc12d,		0x21, 0
	.dw 0xd640, 0xc12d,	0xd67f, 0xc12d,		0x21, 0
	.dw 0xd6c0, 0xc12d,	0xd6ff, 0xc12d,		0x21, 0
	.dw 0xd740, 0xc12d,	0xd77f, 0xc12d,		0x21, 0
	.dw 0xd7c0, 0xc12d,	0xd7ff, 0xc12d,		0x21, 0
	.dw 0xd840, 0xc12d,	0xd87f, 0xc12d,		0x21, 0
	.dw 0xd8c0, 0xc12d,	0xd8ff, 0xc12d,		0x21, 0
	.dw 0xd940, 0xc12d,	0xd97f, 0xc12d,		0x21, 0
	.dw 0xd9c0, 0xc12d,	0xdfff, 0xc12d,		0x21, 0
	.dw 0xe040, 0xc12d,	0xe07f, 0xc12d,		0x21, 0
	.dw 0xe0c0, 0xc12d,	0xe0ff, 0xc12d,		0x21, 0
	.dw 0xe140, 0xc12d,	0xe17f, 0xc12d,		0x21, 0
	.dw 0xe1c0, 0xc12d,	0xe1ff, 0xc12d,		0x21, 0
	.dw 0xe240, 0xc12d,	0xe27f, 0xc12d,		0x21, 0
	.dw 0xe2c0, 0xc12d,	0xe2ff, 0xc12d,		0x21, 0
	.dw 0xe340, 0xc12d,	0xe37f, 0xc12d,		0x21, 0
	.dw 0xe3c0, 0xc12d,	0xe3ff, 0xc12d,		0x21, 0
	.dw 0xe440, 0xc12d,	0xe47f, 0xc12d,		0x21, 0
	.dw 0xe4c0, 0xc12d,	0xe4ff, 0xc12d,		0x21, 0
	.dw 0xe540, 0xc12d,	0xe57f, 0xc12d,		0x21, 0
	.dw 0xe5c0, 0xc12d,	0xe5ff, 0xc12d,		0x21, 0
	.dw 0xe640, 0xc12d,	0xe67f, 0xc12d,		0x21, 0
	.dw 0xe6c0, 0xc12d,	0xe6ff, 0xc12d,		0x21, 0
	.dw 0xe740, 0xc12d,	0xe77f, 0xc12d,		0x21, 0
	.dw 0xe7c0, 0xc12d,	0xe7ff, 0xc12d,		0x21, 0
	.dw 0xe840, 0xc12d,	0xe87f, 0xc12d,		0x21, 0
	.dw 0xe8c0, 0xc12d,	0xe8ff, 0xc12d,		0x21, 0
	.dw 0xe940, 0xc12d,	0xe97f, 0xc12d,		0x21, 0
	.dw 0xe9c0, 0xc12d,	0xe9ff, 0xc12d,		0x21, 0
	.dw 0xea40, 0xc12d,	0xea7f, 0xc12d,		0x21, 0
	.dw 0xeac0, 0xc12d,	0xeaff, 0xc12d,		0x21, 0
	.dw 0xeb40, 0xc12d,	0xeb7f, 0xc12d,		0x21, 0
	.dw 0xebc0, 0xc12d,	0xebff, 0xc12d,		0x21, 0
	.dw 0xec40, 0xc12d,	0xec7f, 0xc12d,		0x21, 0
	.dw 0xecc0, 0xc12d,	0xecff, 0xc12d,		0x21, 0
	.dw 0xed40, 0xc12d,	0xed7f, 0xc12d,		0x21, 0
	.dw 0xedc0, 0xc12d,	0xedff, 0xc12d,		0x21, 0
	.dw 0xee40, 0xc12d,	0xee7f, 0xc12d,		0x21, 0
	.dw 0xeec0, 0xc12d,	0xeeff, 0xc12d,		0x21, 0
	.dw 0xef40, 0xc12d,	0xef7f, 0xc12d,		0x21, 0
	.dw 0xefc0, 0xc12d,	0xefff, 0xc12d,		0x21, 0
	.dw 0xf040, 0xc12d,	0xf07f, 0xc12d,		0x21, 0
	.dw 0xf0c0, 0xc12d,	0xf0ff, 0xc12d,		0x21, 0
	.dw 0xf140, 0xc12d,	0xf17f, 0xc12d,		0x21, 0
	.dw 0xf1c0, 0xc12d,	0xf1ff, 0xc12d,		0x21, 0
	.dw 0xf240, 0xc12d,	0xf27f, 0xc12d,		0x21, 0
	.dw 0xf2c0, 0xc12d,	0xf2ff, 0xc12d,		0x21, 0
	.dw 0xf340, 0xc12d,	0xf37f, 0xc12d,		0x21, 0
	.dw 0xf3c0, 0xc12d,	0xf3ff, 0xc12d,		0x21, 0
	.dw 0xf440, 0xc12d,	0xf47f, 0xc12d,		0x21, 0
	.dw 0xf4c0, 0xc12d,	0xf4ff, 0xc12d,		0x21, 0
	.dw 0xf540, 0xc12d,	0xf57f, 0xc12d,		0x21, 0
	.dw 0xf5c0, 0xc12d,	0xf5ff, 0xc12d,		0x21, 0
	.dw 0xf640, 0xc12d,	0xf67f, 0xc12d,		0x21, 0
	.dw 0xf6c0, 0xc12d,	0xf6ff, 0xc12d,		0x21, 0
	.dw 0xf740, 0xc12d,	0xf77f, 0xc12d,		0x21, 0
	.dw 0xf7c0, 0xc12d,	0xf7ff, 0xc12d,		0x21, 0
	.dw 0xf840, 0xc12d,	0xf87f, 0xc12d,		0x21, 0
	.dw 0xf8c0, 0xc12d,	0xf8ff, 0xc12d,		0x21, 0
	.dw 0xf940, 0xc12d,	0xf97f, 0xc12d,		0x21, 0
	.dw 0xf9c0, 0xc12d,	0xffff, 0xc12d,		0x21, 0
	.dw 0x0040, 0xc12e,	0x007f, 0xc12e,		0x21, 0
	.dw 0x00c0, 0xc12e,	0x00ff, 0xc12e,		0x21, 0
	.dw 0x0140, 0xc12e,	0x017f, 0xc12e,		0x21, 0
	.dw 0x01c0, 0xc12e,	0x01ff, 0xc12e,		0x21, 0
	.dw 0x0240, 0xc12e,	0x027f, 0xc12e,		0x21, 0
	.dw 0x02c0, 0xc12e,	0x02ff, 0xc12e,		0x21, 0
	.dw 0x0340, 0xc12e,	0x037f, 0xc12e,		0x21, 0
	.dw 0x03c0, 0xc12e,	0x03ff, 0xc12e,		0x21, 0
	.dw 0x0440, 0xc12e,	0x047f, 0xc12e,		0x21, 0
	.dw 0x04c0, 0xc12e,	0x04ff, 0xc12e,		0x21, 0
	.dw 0x0540, 0xc12e,	0x057f, 0xc12e,		0x21, 0
	.dw 0x05c0, 0xc12e,	0x05ff, 0xc12e,		0x21, 0
	.dw 0x0640, 0xc12e,	0x067f, 0xc12e,		0x21, 0
	.dw 0x06c0, 0xc12e,	0x06ff, 0xc12e,		0x21, 0
	.dw 0x0740, 0xc12e,	0x077f, 0xc12e,		0x21, 0
	.dw 0x07c0, 0xc12e,	0x07ff, 0xc12e,		0x21, 0
	.dw 0x0840, 0xc12e,	0x087f, 0xc12e,		0x21, 0
	.dw 0x08c0, 0xc12e,	0x08ff, 0xc12e,		0x21, 0
	.dw 0x0940, 0xc12e,	0x097f, 0xc12e,		0x21, 0
	.dw 0x09c0, 0xc12e,	0x09ff, 0xc12e,		0x21, 0
	.dw 0x0a40, 0xc12e,	0x0a7f, 0xc12e,		0x21, 0
	.dw 0x0ac0, 0xc12e,	0x0aff, 0xc12e,		0x21, 0
	.dw 0x0b40, 0xc12e,	0x0b7f, 0xc12e,		0x21, 0
	.dw 0x0bc0, 0xc12e,	0x0bff, 0xc12e,		0x21, 0
	.dw 0x0c40, 0xc12e,	0x0c7f, 0xc12e,		0x21, 0
	.dw 0x0cc0, 0xc12e,	0x0cff, 0xc12e,		0x21, 0
	.dw 0x0d40, 0xc12e,	0x0d7f, 0xc12e,		0x21, 0
	.dw 0x0dc0, 0xc12e,	0x0dff, 0xc12e,		0x21, 0
	.dw 0x0e40, 0xc12e,	0x0e7f, 0xc12e,		0x21, 0
	.dw 0x0ec0, 0xc12e,	0x0eff, 0xc12e,		0x21, 0
	.dw 0x0f40, 0xc12e,	0x0f7f, 0xc12e,		0x21, 0
	.dw 0x0fc0, 0xc12e,	0x0fff, 0xc12e,		0x21, 0
	.dw 0x1040, 0xc12e,	0x107f, 0xc12e,		0x21, 0
	.dw 0x10c0, 0xc12e,	0x10ff, 0xc12e,		0x21, 0
	.dw 0x1140, 0xc12e,	0x117f, 0xc12e,		0x21, 0
	.dw 0x11c0, 0xc12e,	0x11ff, 0xc12e,		0x21, 0
	.dw 0x1240, 0xc12e,	0x127f, 0xc12e,		0x21, 0
	.dw 0x12c0, 0xc12e,	0x12ff, 0xc12e,		0x21, 0
	.dw 0x1340, 0xc12e,	0x137f, 0xc12e,		0x21, 0
	.dw 0x13c0, 0xc12e,	0x13ff, 0xc12e,		0x21, 0
	.dw 0x1440, 0xc12e,	0x147f, 0xc12e,		0x21, 0
	.dw 0x14c0, 0xc12e,	0x14ff, 0xc12e,		0x21, 0
	.dw 0x1540, 0xc12e,	0x157f, 0xc12e,		0x21, 0
	.dw 0x15c0, 0xc12e,	0x15ff, 0xc12e,		0x21, 0
	.dw 0x1640, 0xc12e,	0x167f, 0xc12e,		0x21, 0
	.dw 0x16c0, 0xc12e,	0x16ff, 0xc12e,		0x21, 0
	.dw 0x1740, 0xc12e,	0x177f, 0xc12e,		0x21, 0
	.dw 0x17c0, 0xc12e,	0x17ff, 0xc12e,		0x21, 0
	.dw 0x1840, 0xc12e,	0x187f, 0xc12e,		0x21, 0
	.dw 0x18c0, 0xc12e,	0x18ff, 0xc12e,		0x21, 0
	.dw 0x1940, 0xc12e,	0x197f, 0xc12e,		0x21, 0
	.dw 0x19c0, 0xc12e,	0x1fff, 0xc12e,		0x21, 0
	.dw 0x2040, 0xc12e,	0x207f, 0xc12e,		0x21, 0
	.dw 0x20c0, 0xc12e,	0x20ff, 0xc12e,		0x21, 0
	.dw 0x2140, 0xc12e,	0x217f, 0xc12e,		0x21, 0
	.dw 0x21c0, 0xc12e,	0x21ff, 0xc12e,		0x21, 0
	.dw 0x2240, 0xc12e,	0x227f, 0xc12e,		0x21, 0
	.dw 0x22c0, 0xc12e,	0x22ff, 0xc12e,		0x21, 0
	.dw 0x2340, 0xc12e,	0x237f, 0xc12e,		0x21, 0
	.dw 0x23c0, 0xc12e,	0x23ff, 0xc12e,		0x21, 0
	.dw 0x2440, 0xc12e,	0x247f, 0xc12e,		0x21, 0
	.dw 0x24c0, 0xc12e,	0x24ff, 0xc12e,		0x21, 0
	.dw 0x2540, 0xc12e,	0x257f, 0xc12e,		0x21, 0
	.dw 0x25c0, 0xc12e,	0x25ff, 0xc12e,		0x21, 0
	.dw 0x2640, 0xc12e,	0x267f, 0xc12e,		0x21, 0
	.dw 0x26c0, 0xc12e,	0x26ff, 0xc12e,		0x21, 0
	.dw 0x2740, 0xc12e,	0x277f, 0xc12e,		0x21, 0
	.dw 0x27c0, 0xc12e,	0x27ff, 0xc12e,		0x21, 0
	.dw 0x2840, 0xc12e,	0x287f, 0xc12e,		0x21, 0
	.dw 0x28c0, 0xc12e,	0x28ff, 0xc12e,		0x21, 0
	.dw 0x2940, 0xc12e,	0x297f, 0xc12e,		0x21, 0
	.dw 0x29c0, 0xc12e,	0x29ff, 0xc12e,		0x21, 0
	.dw 0x2a40, 0xc12e,	0x2a7f, 0xc12e,		0x21, 0
	.dw 0x2ac0, 0xc12e,	0x2aff, 0xc12e,		0x21, 0
	.dw 0x2b40, 0xc12e,	0x2b7f, 0xc12e,		0x21, 0
	.dw 0x2bc0, 0xc12e,	0x2bff, 0xc12e,		0x21, 0
	.dw 0x2c40, 0xc12e,	0x2c7f, 0xc12e,		0x21, 0
	.dw 0x2cc0, 0xc12e,	0x2cff, 0xc12e,		0x21, 0
	.dw 0x2d40, 0xc12e,	0x2d7f, 0xc12e,		0x21, 0
	.dw 0x2dc0, 0xc12e,	0x2dff, 0xc12e,		0x21, 0
	.dw 0x2e40, 0xc12e,	0x2e7f, 0xc12e,		0x21, 0
	.dw 0x2ec0, 0xc12e,	0x2eff, 0xc12e,		0x21, 0
	.dw 0x2f40, 0xc12e,	0x2f7f, 0xc12e,		0x21, 0
	.dw 0x2fc0, 0xc12e,	0x2fff, 0xc12e,		0x21, 0
	.dw 0x3040, 0xc12e,	0x307f, 0xc12e,		0x21, 0
	.dw 0x30c0, 0xc12e,	0x30ff, 0xc12e,		0x21, 0
	.dw 0x3140, 0xc12e,	0x317f, 0xc12e,		0x21, 0
	.dw 0x31c0, 0xc12e,	0x31ff, 0xc12e,		0x21, 0
	.dw 0x3240, 0xc12e,	0x327f, 0xc12e,		0x21, 0
	.dw 0x32c0, 0xc12e,	0x32ff, 0xc12e,		0x21, 0
	.dw 0x3340, 0xc12e,	0x337f, 0xc12e,		0x21, 0
	.dw 0x33c0, 0xc12e,	0x33ff, 0xc12e,		0x21, 0
	.dw 0x3440, 0xc12e,	0x347f, 0xc12e,		0x21, 0
	.dw 0x34c0, 0xc12e,	0x34ff, 0xc12e,		0x21, 0
	.dw 0x3540, 0xc12e,	0x357f, 0xc12e,		0x21, 0
	.dw 0x35c0, 0xc12e,	0x35ff, 0xc12e,		0x21, 0
	.dw 0x3640, 0xc12e,	0x367f, 0xc12e,		0x21, 0
	.dw 0x36c0, 0xc12e,	0x36ff, 0xc12e,		0x21, 0
	.dw 0x3740, 0xc12e,	0x377f, 0xc12e,		0x21, 0
	.dw 0x37c0, 0xc12e,	0x37ff, 0xc12e,		0x21, 0
	.dw 0x3840, 0xc12e,	0x387f, 0xc12e,		0x21, 0
	.dw 0x38c0, 0xc12e,	0x38ff, 0xc12e,		0x21, 0
	.dw 0x3940, 0xc12e,	0x397f, 0xc12e,		0x21, 0
	.dw 0x39c0, 0xc12e,	0x3fff, 0xc12e,		0x21, 0
	.dw 0x4040, 0xc12e,	0x407f, 0xc12e,		0x21, 0
	.dw 0x40c0, 0xc12e,	0x40ff, 0xc12e,		0x21, 0
	.dw 0x4140, 0xc12e,	0x417f, 0xc12e,		0x21, 0
	.dw 0x41c0, 0xc12e,	0x41ff, 0xc12e,		0x21, 0
	.dw 0x4240, 0xc12e,	0x427f, 0xc12e,		0x21, 0
	.dw 0x42c0, 0xc12e,	0x42ff, 0xc12e,		0x21, 0
	.dw 0x4340, 0xc12e,	0x437f, 0xc12e,		0x21, 0
	.dw 0x43c0, 0xc12e,	0x43ff, 0xc12e,		0x21, 0
	.dw 0x4440, 0xc12e,	0x447f, 0xc12e,		0x21, 0
	.dw 0x44c0, 0xc12e,	0x44ff, 0xc12e,		0x21, 0
	.dw 0x4540, 0xc12e,	0x457f, 0xc12e,		0x21, 0
	.dw 0x45c0, 0xc12e,	0x45ff, 0xc12e,		0x21, 0
	.dw 0x4640, 0xc12e,	0x467f, 0xc12e,		0x21, 0
	.dw 0x46c0, 0xc12e,	0x46ff, 0xc12e,		0x21, 0
	.dw 0x4740, 0xc12e,	0x477f, 0xc12e,		0x21, 0
	.dw 0x47c0, 0xc12e,	0x47ff, 0xc12e,		0x21, 0
	.dw 0x4840, 0xc12e,	0x487f, 0xc12e,		0x21, 0
	.dw 0x48c0, 0xc12e,	0x48ff, 0xc12e,		0x21, 0
	.dw 0x4940, 0xc12e,	0x497f, 0xc12e,		0x21, 0
	.dw 0x49c0, 0xc12e,	0x49ff, 0xc12e,		0x21, 0
	.dw 0x4a40, 0xc12e,	0x4a7f, 0xc12e,		0x21, 0
	.dw 0x4ac0, 0xc12e,	0x4aff, 0xc12e,		0x21, 0
	.dw 0x4b40, 0xc12e,	0x4b7f, 0xc12e,		0x21, 0
	.dw 0x4bc0, 0xc12e,	0x4bff, 0xc12e,		0x21, 0
	.dw 0x4c40, 0xc12e,	0x4c7f, 0xc12e,		0x21, 0
	.dw 0x4cc0, 0xc12e,	0x4cff, 0xc12e,		0x21, 0
	.dw 0x4d40, 0xc12e,	0x4d7f, 0xc12e,		0x21, 0
	.dw 0x4dc0, 0xc12e,	0x4dff, 0xc12e,		0x21, 0
	.dw 0x4e40, 0xc12e,	0x4e7f, 0xc12e,		0x21, 0
	.dw 0x4ec0, 0xc12e,	0x4eff, 0xc12e,		0x21, 0
	.dw 0x4f40, 0xc12e,	0x4f7f, 0xc12e,		0x21, 0
	.dw 0x4fc0, 0xc12e,	0x4fff, 0xc12e,		0x21, 0
	.dw 0x5040, 0xc12e,	0x507f, 0xc12e,		0x21, 0
	.dw 0x50c0, 0xc12e,	0x50ff, 0xc12e,		0x21, 0
	.dw 0x5140, 0xc12e,	0x517f, 0xc12e,		0x21, 0
	.dw 0x51c0, 0xc12e,	0x51ff, 0xc12e,		0x21, 0
	.dw 0x5240, 0xc12e,	0x527f, 0xc12e,		0x21, 0
	.dw 0x52c0, 0xc12e,	0x52ff, 0xc12e,		0x21, 0
	.dw 0x5340, 0xc12e,	0x537f, 0xc12e,		0x21, 0
	.dw 0x53c0, 0xc12e,	0x53ff, 0xc12e,		0x21, 0
	.dw 0x5440, 0xc12e,	0x547f, 0xc12e,		0x21, 0
	.dw 0x54c0, 0xc12e,	0x54ff, 0xc12e,		0x21, 0
	.dw 0x5540, 0xc12e,	0x557f, 0xc12e,		0x21, 0
	.dw 0x55c0, 0xc12e,	0x55ff, 0xc12e,		0x21, 0
	.dw 0x5640, 0xc12e,	0x567f, 0xc12e,		0x21, 0
	.dw 0x56c0, 0xc12e,	0x56ff, 0xc12e,		0x21, 0
	.dw 0x5740, 0xc12e,	0x577f, 0xc12e,		0x21, 0
	.dw 0x57c0, 0xc12e,	0x57ff, 0xc12e,		0x21, 0
	.dw 0x5840, 0xc12e,	0x587f, 0xc12e,		0x21, 0
	.dw 0x58c0, 0xc12e,	0x58ff, 0xc12e,		0x21, 0
	.dw 0x5940, 0xc12e,	0x597f, 0xc12e,		0x21, 0
	.dw 0x59c0, 0xc12e,	0x5fff, 0xc12e,		0x21, 0
	.dw 0x6040, 0xc12e,	0x607f, 0xc12e,		0x21, 0
	.dw 0x60c0, 0xc12e,	0x60ff, 0xc12e,		0x21, 0
	.dw 0x6140, 0xc12e,	0x617f, 0xc12e,		0x21, 0
	.dw 0x61c0, 0xc12e,	0x61ff, 0xc12e,		0x21, 0
	.dw 0x6240, 0xc12e,	0x627f, 0xc12e,		0x21, 0
	.dw 0x62c0, 0xc12e,	0x62ff, 0xc12e,		0x21, 0
	.dw 0x6340, 0xc12e,	0x637f, 0xc12e,		0x21, 0
	.dw 0x63c0, 0xc12e,	0x63ff, 0xc12e,		0x21, 0
	.dw 0x6440, 0xc12e,	0x647f, 0xc12e,		0x21, 0
	.dw 0x64c0, 0xc12e,	0x64ff, 0xc12e,		0x21, 0
	.dw 0x6540, 0xc12e,	0x657f, 0xc12e,		0x21, 0
	.dw 0x65c0, 0xc12e,	0x65ff, 0xc12e,		0x21, 0
	.dw 0x6640, 0xc12e,	0x667f, 0xc12e,		0x21, 0
	.dw 0x66c0, 0xc12e,	0x66ff, 0xc12e,		0x21, 0
	.dw 0x6740, 0xc12e,	0x677f, 0xc12e,		0x21, 0
	.dw 0x67c0, 0xc12e,	0x67ff, 0xc12e,		0x21, 0
	.dw 0x6840, 0xc12e,	0x687f, 0xc12e,		0x21, 0
	.dw 0x68c0, 0xc12e,	0x68ff, 0xc12e,		0x21, 0
	.dw 0x6940, 0xc12e,	0x697f, 0xc12e,		0x21, 0
	.dw 0x69c0, 0xc12e,	0x69ff, 0xc12e,		0x21, 0
	.dw 0x6a40, 0xc12e,	0x6a7f, 0xc12e,		0x21, 0
	.dw 0x6ac0, 0xc12e,	0x6aff, 0xc12e,		0x21, 0
	.dw 0x6b40, 0xc12e,	0x6b7f, 0xc12e,		0x21, 0
	.dw 0x6bc0, 0xc12e,	0x6bff, 0xc12e,		0x21, 0
	.dw 0x6c40, 0xc12e,	0x6c7f, 0xc12e,		0x21, 0
	.dw 0x6cc0, 0xc12e,	0x6cff, 0xc12e,		0x21, 0
	.dw 0x6d40, 0xc12e,	0x6d7f, 0xc12e,		0x21, 0
	.dw 0x6dc0, 0xc12e,	0x6dff, 0xc12e,		0x21, 0
	.dw 0x6e40, 0xc12e,	0x6e7f, 0xc12e,		0x21, 0
	.dw 0x6ec0, 0xc12e,	0x6eff, 0xc12e,		0x21, 0
	.dw 0x6f40, 0xc12e,	0x6f7f, 0xc12e,		0x21, 0
	.dw 0x6fc0, 0xc12e,	0x6fff, 0xc12e,		0x21, 0
	.dw 0x7040, 0xc12e,	0x707f, 0xc12e,		0x21, 0
	.dw 0x70c0, 0xc12e,	0x70ff, 0xc12e,		0x21, 0
	.dw 0x7140, 0xc12e,	0x717f, 0xc12e,		0x21, 0
	.dw 0x71c0, 0xc12e,	0x71ff, 0xc12e,		0x21, 0
	.dw 0x7240, 0xc12e,	0x727f, 0xc12e,		0x21, 0
	.dw 0x72c0, 0xc12e,	0x72ff, 0xc12e,		0x21, 0
	.dw 0x7340, 0xc12e,	0x737f, 0xc12e,		0x21, 0
	.dw 0x73c0, 0xc12e,	0x73ff, 0xc12e,		0x21, 0
	.dw 0x7440, 0xc12e,	0x747f, 0xc12e,		0x21, 0
	.dw 0x74c0, 0xc12e,	0x74ff, 0xc12e,		0x21, 0
	.dw 0x7540, 0xc12e,	0x757f, 0xc12e,		0x21, 0
	.dw 0x75c0, 0xc12e,	0x75ff, 0xc12e,		0x21, 0
	.dw 0x7640, 0xc12e,	0x767f, 0xc12e,		0x21, 0
	.dw 0x76c0, 0xc12e,	0x76ff, 0xc12e,		0x21, 0
	.dw 0x7740, 0xc12e,	0x777f, 0xc12e,		0x21, 0
	.dw 0x77c0, 0xc12e,	0x77ff, 0xc12e,		0x21, 0
	.dw 0x7840, 0xc12e,	0x787f, 0xc12e,		0x21, 0
	.dw 0x78c0, 0xc12e,	0x78ff, 0xc12e,		0x21, 0
	.dw 0x7940, 0xc12e,	0x797f, 0xc12e,		0x21, 0
	.dw 0x79c0, 0xc12e,	0x7fff, 0xc12e,		0x21, 0
	.dw 0x8040, 0xc12e,	0x807f, 0xc12e,		0x21, 0
	.dw 0x80c0, 0xc12e,	0x80ff, 0xc12e,		0x21, 0
	.dw 0x8140, 0xc12e,	0x817f, 0xc12e,		0x21, 0
	.dw 0x81c0, 0xc12e,	0x81ff, 0xc12e,		0x21, 0
	.dw 0x8240, 0xc12e,	0x827f, 0xc12e,		0x21, 0
	.dw 0x82c0, 0xc12e,	0x82ff, 0xc12e,		0x21, 0
	.dw 0x8340, 0xc12e,	0x837f, 0xc12e,		0x21, 0
	.dw 0x83c0, 0xc12e,	0x83ff, 0xc12e,		0x21, 0
	.dw 0x8440, 0xc12e,	0x847f, 0xc12e,		0x21, 0
	.dw 0x84c0, 0xc12e,	0x84ff, 0xc12e,		0x21, 0
	.dw 0x8540, 0xc12e,	0x857f, 0xc12e,		0x21, 0
	.dw 0x85c0, 0xc12e,	0x85ff, 0xc12e,		0x21, 0
	.dw 0x8640, 0xc12e,	0x867f, 0xc12e,		0x21, 0
	.dw 0x86c0, 0xc12e,	0x86ff, 0xc12e,		0x21, 0
	.dw 0x8740, 0xc12e,	0x877f, 0xc12e,		0x21, 0
	.dw 0x87c0, 0xc12e,	0x87ff, 0xc12e,		0x21, 0
	.dw 0x8840, 0xc12e,	0x887f, 0xc12e,		0x21, 0
	.dw 0x88c0, 0xc12e,	0x88ff, 0xc12e,		0x21, 0
	.dw 0x8940, 0xc12e,	0x897f, 0xc12e,		0x21, 0
	.dw 0x89c0, 0xc12e,	0x89ff, 0xc12e,		0x21, 0
	.dw 0x8a40, 0xc12e,	0x8a7f, 0xc12e,		0x21, 0
	.dw 0x8ac0, 0xc12e,	0x8aff, 0xc12e,		0x21, 0
	.dw 0x8b40, 0xc12e,	0x8b7f, 0xc12e,		0x21, 0
	.dw 0x8bc0, 0xc12e,	0x8bff, 0xc12e,		0x21, 0
	.dw 0x8c40, 0xc12e,	0x8c7f, 0xc12e,		0x21, 0
	.dw 0x8cc0, 0xc12e,	0x8cff, 0xc12e,		0x21, 0
	.dw 0x8d40, 0xc12e,	0x8d7f, 0xc12e,		0x21, 0
	.dw 0x8dc0, 0xc12e,	0x8dff, 0xc12e,		0x21, 0
	.dw 0x8e40, 0xc12e,	0x8e7f, 0xc12e,		0x21, 0
	.dw 0x8ec0, 0xc12e,	0x8eff, 0xc12e,		0x21, 0
	.dw 0x8f40, 0xc12e,	0x8f7f, 0xc12e,		0x21, 0
	.dw 0x8fc0, 0xc12e,	0x8fff, 0xc12e,		0x21, 0
	.dw 0x9040, 0xc12e,	0x907f, 0xc12e,		0x21, 0
	.dw 0x90c0, 0xc12e,	0x90ff, 0xc12e,		0x21, 0
	.dw 0x9140, 0xc12e,	0x917f, 0xc12e,		0x21, 0
	.dw 0x91c0, 0xc12e,	0x91ff, 0xc12e,		0x21, 0
	.dw 0x9240, 0xc12e,	0x927f, 0xc12e,		0x21, 0
	.dw 0x92c0, 0xc12e,	0x92ff, 0xc12e,		0x21, 0
	.dw 0x9340, 0xc12e,	0x937f, 0xc12e,		0x21, 0
	.dw 0x93c0, 0xc12e,	0x93ff, 0xc12e,		0x21, 0
	.dw 0x9440, 0xc12e,	0x947f, 0xc12e,		0x21, 0
	.dw 0x94c0, 0xc12e,	0x94ff, 0xc12e,		0x21, 0
	.dw 0x9540, 0xc12e,	0x957f, 0xc12e,		0x21, 0
	.dw 0x95c0, 0xc12e,	0x95ff, 0xc12e,		0x21, 0
	.dw 0x9640, 0xc12e,	0x967f, 0xc12e,		0x21, 0
	.dw 0x96c0, 0xc12e,	0x96ff, 0xc12e,		0x21, 0
	.dw 0x9740, 0xc12e,	0x977f, 0xc12e,		0x21, 0
	.dw 0x97c0, 0xc12e,	0x97ff, 0xc12e,		0x21, 0
	.dw 0x9840, 0xc12e,	0x987f, 0xc12e,		0x21, 0
	.dw 0x98c0, 0xc12e,	0x98ff, 0xc12e,		0x21, 0
	.dw 0x9940, 0xc12e,	0x997f, 0xc12e,		0x21, 0
	.dw 0x99c0, 0xc12e,	0x9fff, 0xc12e,		0x21, 0
	.dw 0xa040, 0xc12e,	0xa07f, 0xc12e,		0x21, 0
	.dw 0xa0c0, 0xc12e,	0xa0ff, 0xc12e,		0x21, 0
	.dw 0xa140, 0xc12e,	0xa17f, 0xc12e,		0x21, 0
	.dw 0xa1c0, 0xc12e,	0xa1ff, 0xc12e,		0x21, 0
	.dw 0xa240, 0xc12e,	0xa27f, 0xc12e,		0x21, 0
	.dw 0xa2c0, 0xc12e,	0xa2ff, 0xc12e,		0x21, 0
	.dw 0xa340, 0xc12e,	0xa37f, 0xc12e,		0x21, 0
	.dw 0xa3c0, 0xc12e,	0xa3ff, 0xc12e,		0x21, 0
	.dw 0xa440, 0xc12e,	0xa47f, 0xc12e,		0x21, 0
	.dw 0xa4c0, 0xc12e,	0xa4ff, 0xc12e,		0x21, 0
	.dw 0xa540, 0xc12e,	0xa57f, 0xc12e,		0x21, 0
	.dw 0xa5c0, 0xc12e,	0xa5ff, 0xc12e,		0x21, 0
	.dw 0xa640, 0xc12e,	0xa67f, 0xc12e,		0x21, 0
	.dw 0xa6c0, 0xc12e,	0xa6ff, 0xc12e,		0x21, 0
	.dw 0xa740, 0xc12e,	0xa77f, 0xc12e,		0x21, 0
	.dw 0xa7c0, 0xc12e,	0xa7ff, 0xc12e,		0x21, 0
	.dw 0xa840, 0xc12e,	0xa87f, 0xc12e,		0x21, 0
	.dw 0xa8c0, 0xc12e,	0xa8ff, 0xc12e,		0x21, 0
	.dw 0xa940, 0xc12e,	0xa97f, 0xc12e,		0x21, 0
	.dw 0xa9c0, 0xc12e,	0xa9ff, 0xc12e,		0x21, 0
	.dw 0xaa40, 0xc12e,	0xaa7f, 0xc12e,		0x21, 0
	.dw 0xaac0, 0xc12e,	0xaaff, 0xc12e,		0x21, 0
	.dw 0xab40, 0xc12e,	0xab7f, 0xc12e,		0x21, 0
	.dw 0xabc0, 0xc12e,	0xabff, 0xc12e,		0x21, 0
	.dw 0xac40, 0xc12e,	0xac7f, 0xc12e,		0x21, 0
	.dw 0xacc0, 0xc12e,	0xacff, 0xc12e,		0x21, 0
	.dw 0xad40, 0xc12e,	0xad7f, 0xc12e,		0x21, 0
	.dw 0xadc0, 0xc12e,	0xadff, 0xc12e,		0x21, 0
	.dw 0xae40, 0xc12e,	0xae7f, 0xc12e,		0x21, 0
	.dw 0xaec0, 0xc12e,	0xaeff, 0xc12e,		0x21, 0
	.dw 0xaf40, 0xc12e,	0xaf7f, 0xc12e,		0x21, 0
	.dw 0xafc0, 0xc12e,	0xafff, 0xc12e,		0x21, 0
	.dw 0xb040, 0xc12e,	0xb07f, 0xc12e,		0x21, 0
	.dw 0xb0c0, 0xc12e,	0xb0ff, 0xc12e,		0x21, 0
	.dw 0xb140, 0xc12e,	0xb17f, 0xc12e,		0x21, 0
	.dw 0xb1c0, 0xc12e,	0xb1ff, 0xc12e,		0x21, 0
	.dw 0xb240, 0xc12e,	0xb27f, 0xc12e,		0x21, 0
	.dw 0xb2c0, 0xc12e,	0xb2ff, 0xc12e,		0x21, 0
	.dw 0xb340, 0xc12e,	0xb37f, 0xc12e,		0x21, 0
	.dw 0xb3c0, 0xc12e,	0xb3ff, 0xc12e,		0x21, 0
	.dw 0xb440, 0xc12e,	0xb47f, 0xc12e,		0x21, 0
	.dw 0xb4c0, 0xc12e,	0xb4ff, 0xc12e,		0x21, 0
	.dw 0xb540, 0xc12e,	0xb57f, 0xc12e,		0x21, 0
	.dw 0xb5c0, 0xc12e,	0xb5ff, 0xc12e,		0x21, 0
	.dw 0xb640, 0xc12e,	0xb67f, 0xc12e,		0x21, 0
	.dw 0xb6c0, 0xc12e,	0xb6ff, 0xc12e,		0x21, 0
	.dw 0xb740, 0xc12e,	0xb77f, 0xc12e,		0x21, 0
	.dw 0xb7c0, 0xc12e,	0xb7ff, 0xc12e,		0x21, 0
	.dw 0xb840, 0xc12e,	0xb87f, 0xc12e,		0x21, 0
	.dw 0xb8c0, 0xc12e,	0xb8ff, 0xc12e,		0x21, 0
	.dw 0xb940, 0xc12e,	0xb97f, 0xc12e,		0x21, 0
	.dw 0xb9c0, 0xc12e,	0xbfff, 0xc12e,		0x21, 0
	.dw 0xc040, 0xc12e,	0xc07f, 0xc12e,		0x21, 0
	.dw 0xc0c0, 0xc12e,	0xc0ff, 0xc12e,		0x21, 0
	.dw 0xc140, 0xc12e,	0xc17f, 0xc12e,		0x21, 0
	.dw 0xc1c0, 0xc12e,	0xc1ff, 0xc12e,		0x21, 0
	.dw 0xc240, 0xc12e,	0xc27f, 0xc12e,		0x21, 0
	.dw 0xc2c0, 0xc12e,	0xc2ff, 0xc12e,		0x21, 0
	.dw 0xc340, 0xc12e,	0xc37f, 0xc12e,		0x21, 0
	.dw 0xc3c0, 0xc12e,	0xc3ff, 0xc12e,		0x21, 0
	.dw 0xc440, 0xc12e,	0xc47f, 0xc12e,		0x21, 0
	.dw 0xc4c0, 0xc12e,	0xc4ff, 0xc12e,		0x21, 0
	.dw 0xc540, 0xc12e,	0xc57f, 0xc12e,		0x21, 0
	.dw 0xc5c0, 0xc12e,	0xc5ff, 0xc12e,		0x21, 0
	.dw 0xc640, 0xc12e,	0xc67f, 0xc12e,		0x21, 0
	.dw 0xc6c0, 0xc12e,	0xc6ff, 0xc12e,		0x21, 0
	.dw 0xc740, 0xc12e,	0xc77f, 0xc12e,		0x21, 0
	.dw 0xc7c0, 0xc12e,	0xc7ff, 0xc12e,		0x21, 0
	.dw 0xc840, 0xc12e,	0xc87f, 0xc12e,		0x21, 0
	.dw 0xc8c0, 0xc12e,	0xc8ff, 0xc12e,		0x21, 0
	.dw 0xc940, 0xc12e,	0xc97f, 0xc12e,		0x21, 0
	.dw 0xc9c0, 0xc12e,	0xc9ff, 0xc12e,		0x21, 0
	.dw 0xca40, 0xc12e,	0xca7f, 0xc12e,		0x21, 0
	.dw 0xcac0, 0xc12e,	0xcaff, 0xc12e,		0x21, 0
	.dw 0xcb40, 0xc12e,	0xcb7f, 0xc12e,		0x21, 0
	.dw 0xcbc0, 0xc12e,	0xcbff, 0xc12e,		0x21, 0
	.dw 0xcc40, 0xc12e,	0xcc7f, 0xc12e,		0x21, 0
	.dw 0xccc0, 0xc12e,	0xccff, 0xc12e,		0x21, 0
	.dw 0xcd40, 0xc12e,	0xcd7f, 0xc12e,		0x21, 0
	.dw 0xcdc0, 0xc12e,	0xcdff, 0xc12e,		0x21, 0
	.dw 0xce40, 0xc12e,	0xce7f, 0xc12e,		0x21, 0
	.dw 0xcec0, 0xc12e,	0xceff, 0xc12e,		0x21, 0
	.dw 0xcf40, 0xc12e,	0xcf7f, 0xc12e,		0x21, 0
	.dw 0xcfc0, 0xc12e,	0xcfff, 0xc12e,		0x21, 0
	.dw 0xd040, 0xc12e,	0xd07f, 0xc12e,		0x21, 0
	.dw 0xd0c0, 0xc12e,	0xd0ff, 0xc12e,		0x21, 0
	.dw 0xd140, 0xc12e,	0xd17f, 0xc12e,		0x21, 0
	.dw 0xd1c0, 0xc12e,	0xd1ff, 0xc12e,		0x21, 0
	.dw 0xd240, 0xc12e,	0xd27f, 0xc12e,		0x21, 0
	.dw 0xd2c0, 0xc12e,	0xd2ff, 0xc12e,		0x21, 0
	.dw 0xd340, 0xc12e,	0xd37f, 0xc12e,		0x21, 0
	.dw 0xd3c0, 0xc12e,	0xd3ff, 0xc12e,		0x21, 0
	.dw 0xd440, 0xc12e,	0xd47f, 0xc12e,		0x21, 0
	.dw 0xd4c0, 0xc12e,	0xd4ff, 0xc12e,		0x21, 0
	.dw 0xd540, 0xc12e,	0xd57f, 0xc12e,		0x21, 0
	.dw 0xd5c0, 0xc12e,	0xd5ff, 0xc12e,		0x21, 0
	.dw 0xd640, 0xc12e,	0xd67f, 0xc12e,		0x21, 0
	.dw 0xd6c0, 0xc12e,	0xd6ff, 0xc12e,		0x21, 0
	.dw 0xd740, 0xc12e,	0xd77f, 0xc12e,		0x21, 0
	.dw 0xd7c0, 0xc12e,	0xd7ff, 0xc12e,		0x21, 0
	.dw 0xd840, 0xc12e,	0xd87f, 0xc12e,		0x21, 0
	.dw 0xd8c0, 0xc12e,	0xd8ff, 0xc12e,		0x21, 0
	.dw 0xd940, 0xc12e,	0xd97f, 0xc12e,		0x21, 0
	.dw 0xd9c0, 0xc12e,	0xdfff, 0xc12e,		0x21, 0
	.dw 0xe040, 0xc12e,	0xe07f, 0xc12e,		0x21, 0
	.dw 0xe0c0, 0xc12e,	0xe0ff, 0xc12e,		0x21, 0
	.dw 0xe140, 0xc12e,	0xe17f, 0xc12e,		0x21, 0
	.dw 0xe1c0, 0xc12e,	0xe1ff, 0xc12e,		0x21, 0
	.dw 0xe240, 0xc12e,	0xe27f, 0xc12e,		0x21, 0
	.dw 0xe2c0, 0xc12e,	0xe2ff, 0xc12e,		0x21, 0
	.dw 0xe340, 0xc12e,	0xe37f, 0xc12e,		0x21, 0
	.dw 0xe3c0, 0xc12e,	0xe3ff, 0xc12e,		0x21, 0
	.dw 0xe440, 0xc12e,	0xe47f, 0xc12e,		0x21, 0
	.dw 0xe4c0, 0xc12e,	0xe4ff, 0xc12e,		0x21, 0
	.dw 0xe540, 0xc12e,	0xe57f, 0xc12e,		0x21, 0
	.dw 0xe5c0, 0xc12e,	0xe5ff, 0xc12e,		0x21, 0
	.dw 0xe640, 0xc12e,	0xe67f, 0xc12e,		0x21, 0
	.dw 0xe6c0, 0xc12e,	0xe6ff, 0xc12e,		0x21, 0
	.dw 0xe740, 0xc12e,	0xe77f, 0xc12e,		0x21, 0
	.dw 0xe7c0, 0xc12e,	0xe7ff, 0xc12e,		0x21, 0
	.dw 0xe840, 0xc12e,	0xe87f, 0xc12e,		0x21, 0
	.dw 0xe8c0, 0xc12e,	0xe8ff, 0xc12e,		0x21, 0
	.dw 0xe940, 0xc12e,	0xe97f, 0xc12e,		0x21, 0
	.dw 0xe9c0, 0xc12e,	0xe9ff, 0xc12e,		0x21, 0
	.dw 0xea40, 0xc12e,	0xea7f, 0xc12e,		0x21, 0
	.dw 0xeac0, 0xc12e,	0xeaff, 0xc12e,		0x21, 0
	.dw 0xeb40, 0xc12e,	0xeb7f, 0xc12e,		0x21, 0
	.dw 0xebc0, 0xc12e,	0xebff, 0xc12e,		0x21, 0
	.dw 0xec40, 0xc12e,	0xec7f, 0xc12e,		0x21, 0
	.dw 0xecc0, 0xc12e,	0xecff, 0xc12e,		0x21, 0
	.dw 0xed40, 0xc12e,	0xed7f, 0xc12e,		0x21, 0
	.dw 0xedc0, 0xc12e,	0xedff, 0xc12e,		0x21, 0
	.dw 0xee40, 0xc12e,	0xee7f, 0xc12e,		0x21, 0
	.dw 0xeec0, 0xc12e,	0xeeff, 0xc12e,		0x21, 0
	.dw 0xef40, 0xc12e,	0xef7f, 0xc12e,		0x21, 0
	.dw 0xefc0, 0xc12e,	0xefff, 0xc12e,		0x21, 0
	.dw 0xf040, 0xc12e,	0xf07f, 0xc12e,		0x21, 0
	.dw 0xf0c0, 0xc12e,	0xf0ff, 0xc12e,		0x21, 0
	.dw 0xf140, 0xc12e,	0xf17f, 0xc12e,		0x21, 0
	.dw 0xf1c0, 0xc12e,	0xf1ff, 0xc12e,		0x21, 0
	.dw 0xf240, 0xc12e,	0xf27f, 0xc12e,		0x21, 0
	.dw 0xf2c0, 0xc12e,	0xf2ff, 0xc12e,		0x21, 0
	.dw 0xf340, 0xc12e,	0xf37f, 0xc12e,		0x21, 0
	.dw 0xf3c0, 0xc12e,	0xf3ff, 0xc12e,		0x21, 0
	.dw 0xf440, 0xc12e,	0xf47f, 0xc12e,		0x21, 0
	.dw 0xf4c0, 0xc12e,	0xf4ff, 0xc12e,		0x21, 0
	.dw 0xf540, 0xc12e,	0xf57f, 0xc12e,		0x21, 0
	.dw 0xf5c0, 0xc12e,	0xf5ff, 0xc12e,		0x21, 0
	.dw 0xf640, 0xc12e,	0xf67f, 0xc12e,		0x21, 0
	.dw 0xf6c0, 0xc12e,	0xf6ff, 0xc12e,		0x21, 0
	.dw 0xf740, 0xc12e,	0xf77f, 0xc12e,		0x21, 0
	.dw 0xf7c0, 0xc12e,	0xf7ff, 0xc12e,		0x21, 0
	.dw 0xf840, 0xc12e,	0xf87f, 0xc12e,		0x21, 0
	.dw 0xf8c0, 0xc12e,	0xf8ff, 0xc12e,		0x21, 0
	.dw 0xf940, 0xc12e,	0xf97f, 0xc12e,		0x21, 0
	.dw 0xf9c0, 0xc12e,	0xffff, 0xc12e,		0x21, 0
	.dw 0x0040, 0xc12f,	0x007f, 0xc12f,		0x21, 0
	.dw 0x00c0, 0xc12f,	0x00ff, 0xc12f,		0x21, 0
	.dw 0x0140, 0xc12f,	0x017f, 0xc12f,		0x21, 0
	.dw 0x01c0, 0xc12f,	0x01ff, 0xc12f,		0x21, 0
	.dw 0x0240, 0xc12f,	0x027f, 0xc12f,		0x21, 0
	.dw 0x02c0, 0xc12f,	0x02ff, 0xc12f,		0x21, 0
	.dw 0x0340, 0xc12f,	0x037f, 0xc12f,		0x21, 0
	.dw 0x03c0, 0xc12f,	0x03ff, 0xc12f,		0x21, 0
	.dw 0x0440, 0xc12f,	0x047f, 0xc12f,		0x21, 0
	.dw 0x04c0, 0xc12f,	0x04ff, 0xc12f,		0x21, 0
	.dw 0x0540, 0xc12f,	0x057f, 0xc12f,		0x21, 0
	.dw 0x05c0, 0xc12f,	0x05ff, 0xc12f,		0x21, 0
	.dw 0x0640, 0xc12f,	0x067f, 0xc12f,		0x21, 0
	.dw 0x06c0, 0xc12f,	0x06ff, 0xc12f,		0x21, 0
	.dw 0x0740, 0xc12f,	0x077f, 0xc12f,		0x21, 0
	.dw 0x07c0, 0xc12f,	0x07ff, 0xc12f,		0x21, 0
	.dw 0x0840, 0xc12f,	0x087f, 0xc12f,		0x21, 0
	.dw 0x08c0, 0xc12f,	0x08ff, 0xc12f,		0x21, 0
	.dw 0x0940, 0xc12f,	0x097f, 0xc12f,		0x21, 0
	.dw 0x09c0, 0xc12f,	0x09ff, 0xc12f,		0x21, 0
	.dw 0x0a40, 0xc12f,	0x0a7f, 0xc12f,		0x21, 0
	.dw 0x0ac0, 0xc12f,	0x0aff, 0xc12f,		0x21, 0
	.dw 0x0b40, 0xc12f,	0x0b7f, 0xc12f,		0x21, 0
	.dw 0x0bc0, 0xc12f,	0x0bff, 0xc12f,		0x21, 0
	.dw 0x0c40, 0xc12f,	0x0c7f, 0xc12f,		0x21, 0
	.dw 0x0cc0, 0xc12f,	0x0cff, 0xc12f,		0x21, 0
	.dw 0x0d40, 0xc12f,	0x0d7f, 0xc12f,		0x21, 0
	.dw 0x0dc0, 0xc12f,	0x0dff, 0xc12f,		0x21, 0
	.dw 0x0e40, 0xc12f,	0x0e7f, 0xc12f,		0x21, 0
	.dw 0x0ec0, 0xc12f,	0x0eff, 0xc12f,		0x21, 0
	.dw 0x0f40, 0xc12f,	0x0f7f, 0xc12f,		0x21, 0
	.dw 0x0fc0, 0xc12f,	0x0fff, 0xc12f,		0x21, 0
	.dw 0x1040, 0xc12f,	0x107f, 0xc12f,		0x21, 0
	.dw 0x10c0, 0xc12f,	0x10ff, 0xc12f,		0x21, 0
	.dw 0x1140, 0xc12f,	0x117f, 0xc12f,		0x21, 0
	.dw 0x11c0, 0xc12f,	0x11ff, 0xc12f,		0x21, 0
	.dw 0x1240, 0xc12f,	0x127f, 0xc12f,		0x21, 0
	.dw 0x12c0, 0xc12f,	0x12ff, 0xc12f,		0x21, 0
	.dw 0x1340, 0xc12f,	0x137f, 0xc12f,		0x21, 0
	.dw 0x13c0, 0xc12f,	0x13ff, 0xc12f,		0x21, 0
	.dw 0x1440, 0xc12f,	0x147f, 0xc12f,		0x21, 0
	.dw 0x14c0, 0xc12f,	0x14ff, 0xc12f,		0x21, 0
	.dw 0x1540, 0xc12f,	0x157f, 0xc12f,		0x21, 0
	.dw 0x15c0, 0xc12f,	0x15ff, 0xc12f,		0x21, 0
	.dw 0x1640, 0xc12f,	0x167f, 0xc12f,		0x21, 0
	.dw 0x16c0, 0xc12f,	0x16ff, 0xc12f,		0x21, 0
	.dw 0x1740, 0xc12f,	0x177f, 0xc12f,		0x21, 0
	.dw 0x17c0, 0xc12f,	0x17ff, 0xc12f,		0x21, 0
	.dw 0x1840, 0xc12f,	0x187f, 0xc12f,		0x21, 0
	.dw 0x18c0, 0xc12f,	0x18ff, 0xc12f,		0x21, 0
	.dw 0x1940, 0xc12f,	0x197f, 0xc12f,		0x21, 0
	.dw 0x19c0, 0xc12f,	0x1fff, 0xc12f,		0x21, 0
	.dw 0x2040, 0xc12f,	0x207f, 0xc12f,		0x21, 0
	.dw 0x20c0, 0xc12f,	0x20ff, 0xc12f,		0x21, 0
	.dw 0x2140, 0xc12f,	0x217f, 0xc12f,		0x21, 0
	.dw 0x21c0, 0xc12f,	0x21ff, 0xc12f,		0x21, 0
	.dw 0x2240, 0xc12f,	0x227f, 0xc12f,		0x21, 0
	.dw 0x22c0, 0xc12f,	0x22ff, 0xc12f,		0x21, 0
	.dw 0x2340, 0xc12f,	0x237f, 0xc12f,		0x21, 0
	.dw 0x23c0, 0xc12f,	0x23ff, 0xc12f,		0x21, 0
	.dw 0x2440, 0xc12f,	0x247f, 0xc12f,		0x21, 0
	.dw 0x24c0, 0xc12f,	0x24ff, 0xc12f,		0x21, 0
	.dw 0x2540, 0xc12f,	0x257f, 0xc12f,		0x21, 0
	.dw 0x25c0, 0xc12f,	0x25ff, 0xc12f,		0x21, 0
	.dw 0x2640, 0xc12f,	0x267f, 0xc12f,		0x21, 0
	.dw 0x26c0, 0xc12f,	0x26ff, 0xc12f,		0x21, 0
	.dw 0x2740, 0xc12f,	0x277f, 0xc12f,		0x21, 0
	.dw 0x27c0, 0xc12f,	0x27ff, 0xc12f,		0x21, 0
	.dw 0x2840, 0xc12f,	0x287f, 0xc12f,		0x21, 0
	.dw 0x28c0, 0xc12f,	0x28ff, 0xc12f,		0x21, 0
	.dw 0x2940, 0xc12f,	0x297f, 0xc12f,		0x21, 0
	.dw 0x29c0, 0xc12f,	0x29ff, 0xc12f,		0x21, 0
	.dw 0x2a40, 0xc12f,	0x2a7f, 0xc12f,		0x21, 0
	.dw 0x2ac0, 0xc12f,	0x2aff, 0xc12f,		0x21, 0
	.dw 0x2b40, 0xc12f,	0x2b7f, 0xc12f,		0x21, 0
	.dw 0x2bc0, 0xc12f,	0x2bff, 0xc12f,		0x21, 0
	.dw 0x2c40, 0xc12f,	0x2c7f, 0xc12f,		0x21, 0
	.dw 0x2cc0, 0xc12f,	0x2cff, 0xc12f,		0x21, 0
	.dw 0x2d40, 0xc12f,	0x2d7f, 0xc12f,		0x21, 0
	.dw 0x2dc0, 0xc12f,	0x2dff, 0xc12f,		0x21, 0
	.dw 0x2e40, 0xc12f,	0x2e7f, 0xc12f,		0x21, 0
	.dw 0x2ec0, 0xc12f,	0x2eff, 0xc12f,		0x21, 0
	.dw 0x2f40, 0xc12f,	0x2f7f, 0xc12f,		0x21, 0
	.dw 0x2fc0, 0xc12f,	0x2fff, 0xc12f,		0x21, 0
	.dw 0x3040, 0xc12f,	0x307f, 0xc12f,		0x21, 0
	.dw 0x30c0, 0xc12f,	0x30ff, 0xc12f,		0x21, 0
	.dw 0x3140, 0xc12f,	0x317f, 0xc12f,		0x21, 0
	.dw 0x31c0, 0xc12f,	0x31ff, 0xc12f,		0x21, 0
	.dw 0x3240, 0xc12f,	0x327f, 0xc12f,		0x21, 0
	.dw 0x32c0, 0xc12f,	0x32ff, 0xc12f,		0x21, 0
	.dw 0x3340, 0xc12f,	0x337f, 0xc12f,		0x21, 0
	.dw 0x33c0, 0xc12f,	0x33ff, 0xc12f,		0x21, 0
	.dw 0x3440, 0xc12f,	0x347f, 0xc12f,		0x21, 0
	.dw 0x34c0, 0xc12f,	0x34ff, 0xc12f,		0x21, 0
	.dw 0x3540, 0xc12f,	0x357f, 0xc12f,		0x21, 0
	.dw 0x35c0, 0xc12f,	0x35ff, 0xc12f,		0x21, 0
	.dw 0x3640, 0xc12f,	0x367f, 0xc12f,		0x21, 0
	.dw 0x36c0, 0xc12f,	0x36ff, 0xc12f,		0x21, 0
	.dw 0x3740, 0xc12f,	0x377f, 0xc12f,		0x21, 0
	.dw 0x37c0, 0xc12f,	0x37ff, 0xc12f,		0x21, 0
	.dw 0x3840, 0xc12f,	0x387f, 0xc12f,		0x21, 0
	.dw 0x38c0, 0xc12f,	0x38ff, 0xc12f,		0x21, 0
	.dw 0x3940, 0xc12f,	0x397f, 0xc12f,		0x21, 0
	.dw 0x39c0, 0xc12f,	0x1fff, 0xc130,		0x21, 0
	.dw 0x3a00, 0xc130,	0x5fff, 0xc130,		0x21, 0
	.dw 0x7a00, 0xc130,	0x9fff, 0xc130,		0x21, 0
	.dw 0xba00, 0xc130,	0xdfff, 0xc130,		0x21, 0
	.dw 0xfa00, 0xc130,	0x1fff, 0xc131,		0x21, 0
	.dw 0x3a00, 0xc131,	0x5fff, 0xc131,		0x21, 0
	.dw 0x7a00, 0xc131,	0x9fff, 0xc131,		0x21, 0
	.dw 0xba00, 0xc131,	0xdfff, 0xc131,		0x21, 0
	.dw 0xfa00, 0xc131,	0x1fff, 0xc132,		0x21, 0
	.dw 0x3a00, 0xc132,	0x5fff, 0xc132,		0x21, 0
	.dw 0x7a00, 0xc132,	0x9fff, 0xc132,		0x21, 0
	.dw 0xba00, 0xc132,	0xdfff, 0xc132,		0x21, 0
	.dw 0xfa00, 0xc132,	0xffff, 0xc133,		0x21, 0
	.dw 0x1a00, 0xc134,	0x1fff, 0xc134,		0x21, 0
	.dw 0x3a00, 0xc134,	0x3fff, 0xc134,		0x21, 0
	.dw 0x5a00, 0xc134,	0x5fff, 0xc134,		0x21, 0
	.dw 0x7a00, 0xc134,	0x7fff, 0xc134,		0x21, 0
	.dw 0x9a00, 0xc134,	0x9fff, 0xc134,		0x21, 0
	.dw 0xba00, 0xc134,	0xbfff, 0xc134,		0x21, 0
	.dw 0xda00, 0xc134,	0xdfff, 0xc134,		0x21, 0
	.dw 0xfa00, 0xc134,	0xffff, 0xc134,		0x21, 0
	.dw 0x1a00, 0xc135,	0x1fff, 0xc135,		0x21, 0
	.dw 0x3a00, 0xc135,	0x3fff, 0xc135,		0x21, 0
	.dw 0x5a00, 0xc135,	0x5fff, 0xc135,		0x21, 0
	.dw 0x7a00, 0xc135,	0x7fff, 0xc135,		0x21, 0
	.dw 0x9a00, 0xc135,	0x9fff, 0xc135,		0x21, 0
	.dw 0xba00, 0xc135,	0xbfff, 0xc135,		0x21, 0
	.dw 0xda00, 0xc135,	0xdfff, 0xc135,		0x21, 0
	.dw 0xfa00, 0xc135,	0xffff, 0xc135,		0x21, 0
	.dw 0x1a00, 0xc136,	0x1fff, 0xc136,		0x21, 0
	.dw 0x3a00, 0xc136,	0x3fff, 0xc136,		0x21, 0
	.dw 0x5a00, 0xc136,	0x5fff, 0xc136,		0x21, 0
	.dw 0x7a00, 0xc136,	0x7fff, 0xc136,		0x21, 0
	.dw 0x9a00, 0xc136,	0x9fff, 0xc136,		0x21, 0
	.dw 0xba00, 0xc136,	0xbfff, 0xc136,		0x21, 0
	.dw 0xda00, 0xc136,	0xdfff, 0xc136,		0x21, 0
	.dw 0xfa00, 0xc136,	0xffff, 0xc136,		0x21, 0
	.dw 0x1a00, 0xc137,	0x1fff, 0xc137,		0x21, 0
	.dw 0x3a00, 0xc137,	0x1fff, 0xc138,		0x21, 0
	.dw 0x2040, 0xc138,	0x207f, 0xc138,		0x21, 0
	.dw 0x20c0, 0xc138,	0x20ff, 0xc138,		0x21, 0
	.dw 0x2140, 0xc138,	0x217f, 0xc138,		0x21, 0
	.dw 0x21c0, 0xc138,	0x21ff, 0xc138,		0x21, 0
	.dw 0x2240, 0xc138,	0x227f, 0xc138,		0x21, 0
	.dw 0x22c0, 0xc138,	0x22ff, 0xc138,		0x21, 0
	.dw 0x2340, 0xc138,	0x237f, 0xc138,		0x21, 0
	.dw 0x23c0, 0xc138,	0x23ff, 0xc138,		0x21, 0
	.dw 0x2440, 0xc138,	0x247f, 0xc138,		0x21, 0
	.dw 0x24c0, 0xc138,	0x24ff, 0xc138,		0x21, 0
	.dw 0x2540, 0xc138,	0x257f, 0xc138,		0x21, 0
	.dw 0x25c0, 0xc138,	0x25ff, 0xc138,		0x21, 0
	.dw 0x2640, 0xc138,	0x267f, 0xc138,		0x21, 0
	.dw 0x26c0, 0xc138,	0x26ff, 0xc138,		0x21, 0
	.dw 0x2740, 0xc138,	0x277f, 0xc138,		0x21, 0
	.dw 0x27c0, 0xc138,	0x27ff, 0xc138,		0x21, 0
	.dw 0x2840, 0xc138,	0x287f, 0xc138,		0x21, 0
	.dw 0x28c0, 0xc138,	0x28ff, 0xc138,		0x21, 0
	.dw 0x2940, 0xc138,	0x297f, 0xc138,		0x21, 0
	.dw 0x29c0, 0xc138,	0x29ff, 0xc138,		0x21, 0
	.dw 0x2a40, 0xc138,	0x2a7f, 0xc138,		0x21, 0
	.dw 0x2ac0, 0xc138,	0x2aff, 0xc138,		0x21, 0
	.dw 0x2b40, 0xc138,	0x2b7f, 0xc138,		0x21, 0
	.dw 0x2bc0, 0xc138,	0x2bff, 0xc138,		0x21, 0
	.dw 0x2c40, 0xc138,	0x2c7f, 0xc138,		0x21, 0
	.dw 0x2cc0, 0xc138,	0x2cff, 0xc138,		0x21, 0
	.dw 0x2d40, 0xc138,	0x2d7f, 0xc138,		0x21, 0
	.dw 0x2dc0, 0xc138,	0x2dff, 0xc138,		0x21, 0
	.dw 0x2e40, 0xc138,	0x2e7f, 0xc138,		0x21, 0
	.dw 0x2ec0, 0xc138,	0x2eff, 0xc138,		0x21, 0
	.dw 0x2f40, 0xc138,	0x2f7f, 0xc138,		0x21, 0
	.dw 0x2fc0, 0xc138,	0x2fff, 0xc138,		0x21, 0
	.dw 0x3040, 0xc138,	0x307f, 0xc138,		0x21, 0
	.dw 0x30c0, 0xc138,	0x30ff, 0xc138,		0x21, 0
	.dw 0x3140, 0xc138,	0x317f, 0xc138,		0x21, 0
	.dw 0x31c0, 0xc138,	0x31ff, 0xc138,		0x21, 0
	.dw 0x3240, 0xc138,	0x327f, 0xc138,		0x21, 0
	.dw 0x32c0, 0xc138,	0x32ff, 0xc138,		0x21, 0
	.dw 0x3340, 0xc138,	0x337f, 0xc138,		0x21, 0
	.dw 0x33c0, 0xc138,	0x33ff, 0xc138,		0x21, 0
	.dw 0x3440, 0xc138,	0x347f, 0xc138,		0x21, 0
	.dw 0x34c0, 0xc138,	0x34ff, 0xc138,		0x21, 0
	.dw 0x3540, 0xc138,	0x357f, 0xc138,		0x21, 0
	.dw 0x35c0, 0xc138,	0x35ff, 0xc138,		0x21, 0
	.dw 0x3640, 0xc138,	0x367f, 0xc138,		0x21, 0
	.dw 0x36c0, 0xc138,	0x36ff, 0xc138,		0x21, 0
	.dw 0x3740, 0xc138,	0x377f, 0xc138,		0x21, 0
	.dw 0x37c0, 0xc138,	0x37ff, 0xc138,		0x21, 0
	.dw 0x3840, 0xc138,	0x387f, 0xc138,		0x21, 0
	.dw 0x38c0, 0xc138,	0x38ff, 0xc138,		0x21, 0
	.dw 0x3940, 0xc138,	0x397f, 0xc138,		0x21, 0
	.dw 0x39c0, 0xc138,	0x5fff, 0xc138,		0x21, 0
	.dw 0x6040, 0xc138,	0x607f, 0xc138,		0x21, 0
	.dw 0x60c0, 0xc138,	0x60ff, 0xc138,		0x21, 0
	.dw 0x6140, 0xc138,	0x617f, 0xc138,		0x21, 0
	.dw 0x61c0, 0xc138,	0x61ff, 0xc138,		0x21, 0
	.dw 0x6240, 0xc138,	0x627f, 0xc138,		0x21, 0
	.dw 0x62c0, 0xc138,	0x62ff, 0xc138,		0x21, 0
	.dw 0x6340, 0xc138,	0x637f, 0xc138,		0x21, 0
	.dw 0x63c0, 0xc138,	0x63ff, 0xc138,		0x21, 0
	.dw 0x6440, 0xc138,	0x647f, 0xc138,		0x21, 0
	.dw 0x64c0, 0xc138,	0x64ff, 0xc138,		0x21, 0
	.dw 0x6540, 0xc138,	0x657f, 0xc138,		0x21, 0
	.dw 0x65c0, 0xc138,	0x65ff, 0xc138,		0x21, 0
	.dw 0x6640, 0xc138,	0x667f, 0xc138,		0x21, 0
	.dw 0x66c0, 0xc138,	0x66ff, 0xc138,		0x21, 0
	.dw 0x6740, 0xc138,	0x677f, 0xc138,		0x21, 0
	.dw 0x67c0, 0xc138,	0x67ff, 0xc138,		0x21, 0
	.dw 0x6840, 0xc138,	0x687f, 0xc138,		0x21, 0
	.dw 0x68c0, 0xc138,	0x68ff, 0xc138,		0x21, 0
	.dw 0x6940, 0xc138,	0x697f, 0xc138,		0x21, 0
	.dw 0x69c0, 0xc138,	0x69ff, 0xc138,		0x21, 0
	.dw 0x6a40, 0xc138,	0x6a7f, 0xc138,		0x21, 0
	.dw 0x6ac0, 0xc138,	0x6aff, 0xc138,		0x21, 0
	.dw 0x6b40, 0xc138,	0x6b7f, 0xc138,		0x21, 0
	.dw 0x6bc0, 0xc138,	0x6bff, 0xc138,		0x21, 0
	.dw 0x6c40, 0xc138,	0x6c7f, 0xc138,		0x21, 0
	.dw 0x6cc0, 0xc138,	0x6cff, 0xc138,		0x21, 0
	.dw 0x6d40, 0xc138,	0x6d7f, 0xc138,		0x21, 0
	.dw 0x6dc0, 0xc138,	0x6dff, 0xc138,		0x21, 0
	.dw 0x6e40, 0xc138,	0x6e7f, 0xc138,		0x21, 0
	.dw 0x6ec0, 0xc138,	0x6eff, 0xc138,		0x21, 0
	.dw 0x6f40, 0xc138,	0x6f7f, 0xc138,		0x21, 0
	.dw 0x6fc0, 0xc138,	0x6fff, 0xc138,		0x21, 0
	.dw 0x7040, 0xc138,	0x707f, 0xc138,		0x21, 0
	.dw 0x70c0, 0xc138,	0x70ff, 0xc138,		0x21, 0
	.dw 0x7140, 0xc138,	0x717f, 0xc138,		0x21, 0
	.dw 0x71c0, 0xc138,	0x71ff, 0xc138,		0x21, 0
	.dw 0x7240, 0xc138,	0x727f, 0xc138,		0x21, 0
	.dw 0x72c0, 0xc138,	0x72ff, 0xc138,		0x21, 0
	.dw 0x7340, 0xc138,	0x737f, 0xc138,		0x21, 0
	.dw 0x73c0, 0xc138,	0x73ff, 0xc138,		0x21, 0
	.dw 0x7440, 0xc138,	0x747f, 0xc138,		0x21, 0
	.dw 0x74c0, 0xc138,	0x74ff, 0xc138,		0x21, 0
	.dw 0x7540, 0xc138,	0x757f, 0xc138,		0x21, 0
	.dw 0x75c0, 0xc138,	0x75ff, 0xc138,		0x21, 0
	.dw 0x7640, 0xc138,	0x767f, 0xc138,		0x21, 0
	.dw 0x76c0, 0xc138,	0x76ff, 0xc138,		0x21, 0
	.dw 0x7740, 0xc138,	0x777f, 0xc138,		0x21, 0
	.dw 0x77c0, 0xc138,	0x77ff, 0xc138,		0x21, 0
	.dw 0x7840, 0xc138,	0x787f, 0xc138,		0x21, 0
	.dw 0x78c0, 0xc138,	0x78ff, 0xc138,		0x21, 0
	.dw 0x7940, 0xc138,	0x797f, 0xc138,		0x21, 0
	.dw 0x79c0, 0xc138,	0x9fff, 0xc138,		0x21, 0
	.dw 0xa040, 0xc138,	0xa07f, 0xc138,		0x21, 0
	.dw 0xa0c0, 0xc138,	0xa0ff, 0xc138,		0x21, 0
	.dw 0xa140, 0xc138,	0xa17f, 0xc138,		0x21, 0
	.dw 0xa1c0, 0xc138,	0xa1ff, 0xc138,		0x21, 0
	.dw 0xa240, 0xc138,	0xa27f, 0xc138,		0x21, 0
	.dw 0xa2c0, 0xc138,	0xa2ff, 0xc138,		0x21, 0
	.dw 0xa340, 0xc138,	0xa37f, 0xc138,		0x21, 0
	.dw 0xa3c0, 0xc138,	0xa3ff, 0xc138,		0x21, 0
	.dw 0xa440, 0xc138,	0xa47f, 0xc138,		0x21, 0
	.dw 0xa4c0, 0xc138,	0xa4ff, 0xc138,		0x21, 0
	.dw 0xa540, 0xc138,	0xa57f, 0xc138,		0x21, 0
	.dw 0xa5c0, 0xc138,	0xa5ff, 0xc138,		0x21, 0
	.dw 0xa640, 0xc138,	0xa67f, 0xc138,		0x21, 0
	.dw 0xa6c0, 0xc138,	0xa6ff, 0xc138,		0x21, 0
	.dw 0xa740, 0xc138,	0xa77f, 0xc138,		0x21, 0
	.dw 0xa7c0, 0xc138,	0xa7ff, 0xc138,		0x21, 0
	.dw 0xa840, 0xc138,	0xa87f, 0xc138,		0x21, 0
	.dw 0xa8c0, 0xc138,	0xa8ff, 0xc138,		0x21, 0
	.dw 0xa940, 0xc138,	0xa97f, 0xc138,		0x21, 0
	.dw 0xa9c0, 0xc138,	0xa9ff, 0xc138,		0x21, 0
	.dw 0xaa40, 0xc138,	0xaa7f, 0xc138,		0x21, 0
	.dw 0xaac0, 0xc138,	0xaaff, 0xc138,		0x21, 0
	.dw 0xab40, 0xc138,	0xab7f, 0xc138,		0x21, 0
	.dw 0xabc0, 0xc138,	0xabff, 0xc138,		0x21, 0
	.dw 0xac40, 0xc138,	0xac7f, 0xc138,		0x21, 0
	.dw 0xacc0, 0xc138,	0xacff, 0xc138,		0x21, 0
	.dw 0xad40, 0xc138,	0xad7f, 0xc138,		0x21, 0
	.dw 0xadc0, 0xc138,	0xadff, 0xc138,		0x21, 0
	.dw 0xae40, 0xc138,	0xae7f, 0xc138,		0x21, 0
	.dw 0xaec0, 0xc138,	0xaeff, 0xc138,		0x21, 0
	.dw 0xaf40, 0xc138,	0xaf7f, 0xc138,		0x21, 0
	.dw 0xafc0, 0xc138,	0xafff, 0xc138,		0x21, 0
	.dw 0xb040, 0xc138,	0xb07f, 0xc138,		0x21, 0
	.dw 0xb0c0, 0xc138,	0xb0ff, 0xc138,		0x21, 0
	.dw 0xb140, 0xc138,	0xb17f, 0xc138,		0x21, 0
	.dw 0xb1c0, 0xc138,	0xb1ff, 0xc138,		0x21, 0
	.dw 0xb240, 0xc138,	0xb27f, 0xc138,		0x21, 0
	.dw 0xb2c0, 0xc138,	0xb2ff, 0xc138,		0x21, 0
	.dw 0xb340, 0xc138,	0xb37f, 0xc138,		0x21, 0
	.dw 0xb3c0, 0xc138,	0xb3ff, 0xc138,		0x21, 0
	.dw 0xb440, 0xc138,	0xb47f, 0xc138,		0x21, 0
	.dw 0xb4c0, 0xc138,	0xb4ff, 0xc138,		0x21, 0
	.dw 0xb540, 0xc138,	0xb57f, 0xc138,		0x21, 0
	.dw 0xb5c0, 0xc138,	0xb5ff, 0xc138,		0x21, 0
	.dw 0xb640, 0xc138,	0xb67f, 0xc138,		0x21, 0
	.dw 0xb6c0, 0xc138,	0xb6ff, 0xc138,		0x21, 0
	.dw 0xb740, 0xc138,	0xb77f, 0xc138,		0x21, 0
	.dw 0xb7c0, 0xc138,	0xb7ff, 0xc138,		0x21, 0
	.dw 0xb840, 0xc138,	0xb87f, 0xc138,		0x21, 0
	.dw 0xb8c0, 0xc138,	0xb8ff, 0xc138,		0x21, 0
	.dw 0xb940, 0xc138,	0xb97f, 0xc138,		0x21, 0
	.dw 0xb9c0, 0xc138,	0xdfff, 0xc138,		0x21, 0
	.dw 0xe040, 0xc138,	0xe07f, 0xc138,		0x21, 0
	.dw 0xe0c0, 0xc138,	0xe0ff, 0xc138,		0x21, 0
	.dw 0xe140, 0xc138,	0xe17f, 0xc138,		0x21, 0
	.dw 0xe1c0, 0xc138,	0xe1ff, 0xc138,		0x21, 0
	.dw 0xe240, 0xc138,	0xe27f, 0xc138,		0x21, 0
	.dw 0xe2c0, 0xc138,	0xe2ff, 0xc138,		0x21, 0
	.dw 0xe340, 0xc138,	0xe37f, 0xc138,		0x21, 0
	.dw 0xe3c0, 0xc138,	0xe3ff, 0xc138,		0x21, 0
	.dw 0xe440, 0xc138,	0xe47f, 0xc138,		0x21, 0
	.dw 0xe4c0, 0xc138,	0xe4ff, 0xc138,		0x21, 0
	.dw 0xe540, 0xc138,	0xe57f, 0xc138,		0x21, 0
	.dw 0xe5c0, 0xc138,	0xe5ff, 0xc138,		0x21, 0
	.dw 0xe640, 0xc138,	0xe67f, 0xc138,		0x21, 0
	.dw 0xe6c0, 0xc138,	0xe6ff, 0xc138,		0x21, 0
	.dw 0xe740, 0xc138,	0xe77f, 0xc138,		0x21, 0
	.dw 0xe7c0, 0xc138,	0xe7ff, 0xc138,		0x21, 0
	.dw 0xe840, 0xc138,	0xe87f, 0xc138,		0x21, 0
	.dw 0xe8c0, 0xc138,	0xe8ff, 0xc138,		0x21, 0
	.dw 0xe940, 0xc138,	0xe97f, 0xc138,		0x21, 0
	.dw 0xe9c0, 0xc138,	0xe9ff, 0xc138,		0x21, 0
	.dw 0xea40, 0xc138,	0xea7f, 0xc138,		0x21, 0
	.dw 0xeac0, 0xc138,	0xeaff, 0xc138,		0x21, 0
	.dw 0xeb40, 0xc138,	0xeb7f, 0xc138,		0x21, 0
	.dw 0xebc0, 0xc138,	0xebff, 0xc138,		0x21, 0
	.dw 0xec40, 0xc138,	0xec7f, 0xc138,		0x21, 0
	.dw 0xecc0, 0xc138,	0xecff, 0xc138,		0x21, 0
	.dw 0xed40, 0xc138,	0xed7f, 0xc138,		0x21, 0
	.dw 0xedc0, 0xc138,	0xedff, 0xc138,		0x21, 0
	.dw 0xee40, 0xc138,	0xee7f, 0xc138,		0x21, 0
	.dw 0xeec0, 0xc138,	0xeeff, 0xc138,		0x21, 0
	.dw 0xef40, 0xc138,	0xef7f, 0xc138,		0x21, 0
	.dw 0xefc0, 0xc138,	0xefff, 0xc138,		0x21, 0
	.dw 0xf040, 0xc138,	0xf07f, 0xc138,		0x21, 0
	.dw 0xf0c0, 0xc138,	0xf0ff, 0xc138,		0x21, 0
	.dw 0xf140, 0xc138,	0xf17f, 0xc138,		0x21, 0
	.dw 0xf1c0, 0xc138,	0xf1ff, 0xc138,		0x21, 0
	.dw 0xf240, 0xc138,	0xf27f, 0xc138,		0x21, 0
	.dw 0xf2c0, 0xc138,	0xf2ff, 0xc138,		0x21, 0
	.dw 0xf340, 0xc138,	0xf37f, 0xc138,		0x21, 0
	.dw 0xf3c0, 0xc138,	0xf3ff, 0xc138,		0x21, 0
	.dw 0xf440, 0xc138,	0xf47f, 0xc138,		0x21, 0
	.dw 0xf4c0, 0xc138,	0xf4ff, 0xc138,		0x21, 0
	.dw 0xf540, 0xc138,	0xf57f, 0xc138,		0x21, 0
	.dw 0xf5c0, 0xc138,	0xf5ff, 0xc138,		0x21, 0
	.dw 0xf640, 0xc138,	0xf67f, 0xc138,		0x21, 0
	.dw 0xf6c0, 0xc138,	0xf6ff, 0xc138,		0x21, 0
	.dw 0xf740, 0xc138,	0xf77f, 0xc138,		0x21, 0
	.dw 0xf7c0, 0xc138,	0xf7ff, 0xc138,		0x21, 0
	.dw 0xf840, 0xc138,	0xf87f, 0xc138,		0x21, 0
	.dw 0xf8c0, 0xc138,	0xf8ff, 0xc138,		0x21, 0
	.dw 0xf940, 0xc138,	0xf97f, 0xc138,		0x21, 0
	.dw 0xf9c0, 0xc138,	0x1fff, 0xc139,		0x21, 0
	.dw 0x2040, 0xc139,	0x207f, 0xc139,		0x21, 0
	.dw 0x20c0, 0xc139,	0x20ff, 0xc139,		0x21, 0
	.dw 0x2140, 0xc139,	0x217f, 0xc139,		0x21, 0
	.dw 0x21c0, 0xc139,	0x21ff, 0xc139,		0x21, 0
	.dw 0x2240, 0xc139,	0x227f, 0xc139,		0x21, 0
	.dw 0x22c0, 0xc139,	0x22ff, 0xc139,		0x21, 0
	.dw 0x2340, 0xc139,	0x237f, 0xc139,		0x21, 0
	.dw 0x23c0, 0xc139,	0x23ff, 0xc139,		0x21, 0
	.dw 0x2440, 0xc139,	0x247f, 0xc139,		0x21, 0
	.dw 0x24c0, 0xc139,	0x24ff, 0xc139,		0x21, 0
	.dw 0x2540, 0xc139,	0x257f, 0xc139,		0x21, 0
	.dw 0x25c0, 0xc139,	0x25ff, 0xc139,		0x21, 0
	.dw 0x2640, 0xc139,	0x267f, 0xc139,		0x21, 0
	.dw 0x26c0, 0xc139,	0x26ff, 0xc139,		0x21, 0
	.dw 0x2740, 0xc139,	0x277f, 0xc139,		0x21, 0
	.dw 0x27c0, 0xc139,	0x27ff, 0xc139,		0x21, 0
	.dw 0x2840, 0xc139,	0x287f, 0xc139,		0x21, 0
	.dw 0x28c0, 0xc139,	0x28ff, 0xc139,		0x21, 0
	.dw 0x2940, 0xc139,	0x297f, 0xc139,		0x21, 0
	.dw 0x29c0, 0xc139,	0x29ff, 0xc139,		0x21, 0
	.dw 0x2a40, 0xc139,	0x2a7f, 0xc139,		0x21, 0
	.dw 0x2ac0, 0xc139,	0x2aff, 0xc139,		0x21, 0
	.dw 0x2b40, 0xc139,	0x2b7f, 0xc139,		0x21, 0
	.dw 0x2bc0, 0xc139,	0x2bff, 0xc139,		0x21, 0
	.dw 0x2c40, 0xc139,	0x2c7f, 0xc139,		0x21, 0
	.dw 0x2cc0, 0xc139,	0x2cff, 0xc139,		0x21, 0
	.dw 0x2d40, 0xc139,	0x2d7f, 0xc139,		0x21, 0
	.dw 0x2dc0, 0xc139,	0x2dff, 0xc139,		0x21, 0
	.dw 0x2e40, 0xc139,	0x2e7f, 0xc139,		0x21, 0
	.dw 0x2ec0, 0xc139,	0x2eff, 0xc139,		0x21, 0
	.dw 0x2f40, 0xc139,	0x2f7f, 0xc139,		0x21, 0
	.dw 0x2fc0, 0xc139,	0x2fff, 0xc139,		0x21, 0
	.dw 0x3040, 0xc139,	0x307f, 0xc139,		0x21, 0
	.dw 0x30c0, 0xc139,	0x30ff, 0xc139,		0x21, 0
	.dw 0x3140, 0xc139,	0x317f, 0xc139,		0x21, 0
	.dw 0x31c0, 0xc139,	0x31ff, 0xc139,		0x21, 0
	.dw 0x3240, 0xc139,	0x327f, 0xc139,		0x21, 0
	.dw 0x32c0, 0xc139,	0x32ff, 0xc139,		0x21, 0
	.dw 0x3340, 0xc139,	0x337f, 0xc139,		0x21, 0
	.dw 0x33c0, 0xc139,	0x33ff, 0xc139,		0x21, 0
	.dw 0x3440, 0xc139,	0x347f, 0xc139,		0x21, 0
	.dw 0x34c0, 0xc139,	0x34ff, 0xc139,		0x21, 0
	.dw 0x3540, 0xc139,	0x357f, 0xc139,		0x21, 0
	.dw 0x35c0, 0xc139,	0x35ff, 0xc139,		0x21, 0
	.dw 0x3640, 0xc139,	0x367f, 0xc139,		0x21, 0
	.dw 0x36c0, 0xc139,	0x36ff, 0xc139,		0x21, 0
	.dw 0x3740, 0xc139,	0x377f, 0xc139,		0x21, 0
	.dw 0x37c0, 0xc139,	0x37ff, 0xc139,		0x21, 0
	.dw 0x3840, 0xc139,	0x387f, 0xc139,		0x21, 0
	.dw 0x38c0, 0xc139,	0x38ff, 0xc139,		0x21, 0
	.dw 0x3940, 0xc139,	0x397f, 0xc139,		0x21, 0
	.dw 0x39c0, 0xc139,	0x5fff, 0xc139,		0x21, 0
	.dw 0x6040, 0xc139,	0x607f, 0xc139,		0x21, 0
	.dw 0x60c0, 0xc139,	0x60ff, 0xc139,		0x21, 0
	.dw 0x6140, 0xc139,	0x617f, 0xc139,		0x21, 0
	.dw 0x61c0, 0xc139,	0x61ff, 0xc139,		0x21, 0
	.dw 0x6240, 0xc139,	0x627f, 0xc139,		0x21, 0
	.dw 0x62c0, 0xc139,	0x62ff, 0xc139,		0x21, 0
	.dw 0x6340, 0xc139,	0x637f, 0xc139,		0x21, 0
	.dw 0x63c0, 0xc139,	0x63ff, 0xc139,		0x21, 0
	.dw 0x6440, 0xc139,	0x647f, 0xc139,		0x21, 0
	.dw 0x64c0, 0xc139,	0x64ff, 0xc139,		0x21, 0
	.dw 0x6540, 0xc139,	0x657f, 0xc139,		0x21, 0
	.dw 0x65c0, 0xc139,	0x65ff, 0xc139,		0x21, 0
	.dw 0x6640, 0xc139,	0x667f, 0xc139,		0x21, 0
	.dw 0x66c0, 0xc139,	0x66ff, 0xc139,		0x21, 0
	.dw 0x6740, 0xc139,	0x677f, 0xc139,		0x21, 0
	.dw 0x67c0, 0xc139,	0x67ff, 0xc139,		0x21, 0
	.dw 0x6840, 0xc139,	0x687f, 0xc139,		0x21, 0
	.dw 0x68c0, 0xc139,	0x68ff, 0xc139,		0x21, 0
	.dw 0x6940, 0xc139,	0x697f, 0xc139,		0x21, 0
	.dw 0x69c0, 0xc139,	0x69ff, 0xc139,		0x21, 0
	.dw 0x6a40, 0xc139,	0x6a7f, 0xc139,		0x21, 0
	.dw 0x6ac0, 0xc139,	0x6aff, 0xc139,		0x21, 0
	.dw 0x6b40, 0xc139,	0x6b7f, 0xc139,		0x21, 0
	.dw 0x6bc0, 0xc139,	0x6bff, 0xc139,		0x21, 0
	.dw 0x6c40, 0xc139,	0x6c7f, 0xc139,		0x21, 0
	.dw 0x6cc0, 0xc139,	0x6cff, 0xc139,		0x21, 0
	.dw 0x6d40, 0xc139,	0x6d7f, 0xc139,		0x21, 0
	.dw 0x6dc0, 0xc139,	0x6dff, 0xc139,		0x21, 0
	.dw 0x6e40, 0xc139,	0x6e7f, 0xc139,		0x21, 0
	.dw 0x6ec0, 0xc139,	0x6eff, 0xc139,		0x21, 0
	.dw 0x6f40, 0xc139,	0x6f7f, 0xc139,		0x21, 0
	.dw 0x6fc0, 0xc139,	0x6fff, 0xc139,		0x21, 0
	.dw 0x7040, 0xc139,	0x707f, 0xc139,		0x21, 0
	.dw 0x70c0, 0xc139,	0x70ff, 0xc139,		0x21, 0
	.dw 0x7140, 0xc139,	0x717f, 0xc139,		0x21, 0
	.dw 0x71c0, 0xc139,	0x71ff, 0xc139,		0x21, 0
	.dw 0x7240, 0xc139,	0x727f, 0xc139,		0x21, 0
	.dw 0x72c0, 0xc139,	0x72ff, 0xc139,		0x21, 0
	.dw 0x7340, 0xc139,	0x737f, 0xc139,		0x21, 0
	.dw 0x73c0, 0xc139,	0x73ff, 0xc139,		0x21, 0
	.dw 0x7440, 0xc139,	0x747f, 0xc139,		0x21, 0
	.dw 0x74c0, 0xc139,	0x74ff, 0xc139,		0x21, 0
	.dw 0x7540, 0xc139,	0x757f, 0xc139,		0x21, 0
	.dw 0x75c0, 0xc139,	0x75ff, 0xc139,		0x21, 0
	.dw 0x7640, 0xc139,	0x767f, 0xc139,		0x21, 0
	.dw 0x76c0, 0xc139,	0x76ff, 0xc139,		0x21, 0
	.dw 0x7740, 0xc139,	0x777f, 0xc139,		0x21, 0
	.dw 0x77c0, 0xc139,	0x77ff, 0xc139,		0x21, 0
	.dw 0x7840, 0xc139,	0x787f, 0xc139,		0x21, 0
	.dw 0x78c0, 0xc139,	0x78ff, 0xc139,		0x21, 0
	.dw 0x7940, 0xc139,	0x797f, 0xc139,		0x21, 0
	.dw 0x79c0, 0xc139,	0x9fff, 0xc139,		0x21, 0
	.dw 0xa040, 0xc139,	0xa07f, 0xc139,		0x21, 0
	.dw 0xa0c0, 0xc139,	0xa0ff, 0xc139,		0x21, 0
	.dw 0xa140, 0xc139,	0xa17f, 0xc139,		0x21, 0
	.dw 0xa1c0, 0xc139,	0xa1ff, 0xc139,		0x21, 0
	.dw 0xa240, 0xc139,	0xa27f, 0xc139,		0x21, 0
	.dw 0xa2c0, 0xc139,	0xa2ff, 0xc139,		0x21, 0
	.dw 0xa340, 0xc139,	0xa37f, 0xc139,		0x21, 0
	.dw 0xa3c0, 0xc139,	0xa3ff, 0xc139,		0x21, 0
	.dw 0xa440, 0xc139,	0xa47f, 0xc139,		0x21, 0
	.dw 0xa4c0, 0xc139,	0xa4ff, 0xc139,		0x21, 0
	.dw 0xa540, 0xc139,	0xa57f, 0xc139,		0x21, 0
	.dw 0xa5c0, 0xc139,	0xa5ff, 0xc139,		0x21, 0
	.dw 0xa640, 0xc139,	0xa67f, 0xc139,		0x21, 0
	.dw 0xa6c0, 0xc139,	0xa6ff, 0xc139,		0x21, 0
	.dw 0xa740, 0xc139,	0xa77f, 0xc139,		0x21, 0
	.dw 0xa7c0, 0xc139,	0xa7ff, 0xc139,		0x21, 0
	.dw 0xa840, 0xc139,	0xa87f, 0xc139,		0x21, 0
	.dw 0xa8c0, 0xc139,	0xa8ff, 0xc139,		0x21, 0
	.dw 0xa940, 0xc139,	0xa97f, 0xc139,		0x21, 0
	.dw 0xa9c0, 0xc139,	0xa9ff, 0xc139,		0x21, 0
	.dw 0xaa40, 0xc139,	0xaa7f, 0xc139,		0x21, 0
	.dw 0xaac0, 0xc139,	0xaaff, 0xc139,		0x21, 0
	.dw 0xab40, 0xc139,	0xab7f, 0xc139,		0x21, 0
	.dw 0xabc0, 0xc139,	0xabff, 0xc139,		0x21, 0
	.dw 0xac40, 0xc139,	0xac7f, 0xc139,		0x21, 0
	.dw 0xacc0, 0xc139,	0xacff, 0xc139,		0x21, 0
	.dw 0xad40, 0xc139,	0xad7f, 0xc139,		0x21, 0
	.dw 0xadc0, 0xc139,	0xadff, 0xc139,		0x21, 0
	.dw 0xae40, 0xc139,	0xae7f, 0xc139,		0x21, 0
	.dw 0xaec0, 0xc139,	0xaeff, 0xc139,		0x21, 0
	.dw 0xaf40, 0xc139,	0xaf7f, 0xc139,		0x21, 0
	.dw 0xafc0, 0xc139,	0xafff, 0xc139,		0x21, 0
	.dw 0xb040, 0xc139,	0xb07f, 0xc139,		0x21, 0
	.dw 0xb0c0, 0xc139,	0xb0ff, 0xc139,		0x21, 0
	.dw 0xb140, 0xc139,	0xb17f, 0xc139,		0x21, 0
	.dw 0xb1c0, 0xc139,	0xb1ff, 0xc139,		0x21, 0
	.dw 0xb240, 0xc139,	0xb27f, 0xc139,		0x21, 0
	.dw 0xb2c0, 0xc139,	0xb2ff, 0xc139,		0x21, 0
	.dw 0xb340, 0xc139,	0xb37f, 0xc139,		0x21, 0
	.dw 0xb3c0, 0xc139,	0xb3ff, 0xc139,		0x21, 0
	.dw 0xb440, 0xc139,	0xb47f, 0xc139,		0x21, 0
	.dw 0xb4c0, 0xc139,	0xb4ff, 0xc139,		0x21, 0
	.dw 0xb540, 0xc139,	0xb57f, 0xc139,		0x21, 0
	.dw 0xb5c0, 0xc139,	0xb5ff, 0xc139,		0x21, 0
	.dw 0xb640, 0xc139,	0xb67f, 0xc139,		0x21, 0
	.dw 0xb6c0, 0xc139,	0xb6ff, 0xc139,		0x21, 0
	.dw 0xb740, 0xc139,	0xb77f, 0xc139,		0x21, 0
	.dw 0xb7c0, 0xc139,	0xb7ff, 0xc139,		0x21, 0
	.dw 0xb840, 0xc139,	0xb87f, 0xc139,		0x21, 0
	.dw 0xb8c0, 0xc139,	0xb8ff, 0xc139,		0x21, 0
	.dw 0xb940, 0xc139,	0xb97f, 0xc139,		0x21, 0
	.dw 0xb9c0, 0xc139,	0xdfff, 0xc139,		0x21, 0
	.dw 0xe040, 0xc139,	0xe07f, 0xc139,		0x21, 0
	.dw 0xe0c0, 0xc139,	0xe0ff, 0xc139,		0x21, 0
	.dw 0xe140, 0xc139,	0xe17f, 0xc139,		0x21, 0
	.dw 0xe1c0, 0xc139,	0xe1ff, 0xc139,		0x21, 0
	.dw 0xe240, 0xc139,	0xe27f, 0xc139,		0x21, 0
	.dw 0xe2c0, 0xc139,	0xe2ff, 0xc139,		0x21, 0
	.dw 0xe340, 0xc139,	0xe37f, 0xc139,		0x21, 0
	.dw 0xe3c0, 0xc139,	0xe3ff, 0xc139,		0x21, 0
	.dw 0xe440, 0xc139,	0xe47f, 0xc139,		0x21, 0
	.dw 0xe4c0, 0xc139,	0xe4ff, 0xc139,		0x21, 0
	.dw 0xe540, 0xc139,	0xe57f, 0xc139,		0x21, 0
	.dw 0xe5c0, 0xc139,	0xe5ff, 0xc139,		0x21, 0
	.dw 0xe640, 0xc139,	0xe67f, 0xc139,		0x21, 0
	.dw 0xe6c0, 0xc139,	0xe6ff, 0xc139,		0x21, 0
	.dw 0xe740, 0xc139,	0xe77f, 0xc139,		0x21, 0
	.dw 0xe7c0, 0xc139,	0xe7ff, 0xc139,		0x21, 0
	.dw 0xe840, 0xc139,	0xe87f, 0xc139,		0x21, 0
	.dw 0xe8c0, 0xc139,	0xe8ff, 0xc139,		0x21, 0
	.dw 0xe940, 0xc139,	0xe97f, 0xc139,		0x21, 0
	.dw 0xe9c0, 0xc139,	0xe9ff, 0xc139,		0x21, 0
	.dw 0xea40, 0xc139,	0xea7f, 0xc139,		0x21, 0
	.dw 0xeac0, 0xc139,	0xeaff, 0xc139,		0x21, 0
	.dw 0xeb40, 0xc139,	0xeb7f, 0xc139,		0x21, 0
	.dw 0xebc0, 0xc139,	0xebff, 0xc139,		0x21, 0
	.dw 0xec40, 0xc139,	0xec7f, 0xc139,		0x21, 0
	.dw 0xecc0, 0xc139,	0xecff, 0xc139,		0x21, 0
	.dw 0xed40, 0xc139,	0xed7f, 0xc139,		0x21, 0
	.dw 0xedc0, 0xc139,	0xedff, 0xc139,		0x21, 0
	.dw 0xee40, 0xc139,	0xee7f, 0xc139,		0x21, 0
	.dw 0xeec0, 0xc139,	0xeeff, 0xc139,		0x21, 0
	.dw 0xef40, 0xc139,	0xef7f, 0xc139,		0x21, 0
	.dw 0xefc0, 0xc139,	0xefff, 0xc139,		0x21, 0
	.dw 0xf040, 0xc139,	0xf07f, 0xc139,		0x21, 0
	.dw 0xf0c0, 0xc139,	0xf0ff, 0xc139,		0x21, 0
	.dw 0xf140, 0xc139,	0xf17f, 0xc139,		0x21, 0
	.dw 0xf1c0, 0xc139,	0xf1ff, 0xc139,		0x21, 0
	.dw 0xf240, 0xc139,	0xf27f, 0xc139,		0x21, 0
	.dw 0xf2c0, 0xc139,	0xf2ff, 0xc139,		0x21, 0
	.dw 0xf340, 0xc139,	0xf37f, 0xc139,		0x21, 0
	.dw 0xf3c0, 0xc139,	0xf3ff, 0xc139,		0x21, 0
	.dw 0xf440, 0xc139,	0xf47f, 0xc139,		0x21, 0
	.dw 0xf4c0, 0xc139,	0xf4ff, 0xc139,		0x21, 0
	.dw 0xf540, 0xc139,	0xf57f, 0xc139,		0x21, 0
	.dw 0xf5c0, 0xc139,	0xf5ff, 0xc139,		0x21, 0
	.dw 0xf640, 0xc139,	0xf67f, 0xc139,		0x21, 0
	.dw 0xf6c0, 0xc139,	0xf6ff, 0xc139,		0x21, 0
	.dw 0xf740, 0xc139,	0xf77f, 0xc139,		0x21, 0
	.dw 0xf7c0, 0xc139,	0xf7ff, 0xc139,		0x21, 0
	.dw 0xf840, 0xc139,	0xf87f, 0xc139,		0x21, 0
	.dw 0xf8c0, 0xc139,	0xf8ff, 0xc139,		0x21, 0
	.dw 0xf940, 0xc139,	0xf97f, 0xc139,		0x21, 0
	.dw 0xf9c0, 0xc139,	0x1fff, 0xc13a,		0x21, 0
	.dw 0x2040, 0xc13a,	0x207f, 0xc13a,		0x21, 0
	.dw 0x20c0, 0xc13a,	0x20ff, 0xc13a,		0x21, 0
	.dw 0x2140, 0xc13a,	0x217f, 0xc13a,		0x21, 0
	.dw 0x21c0, 0xc13a,	0x21ff, 0xc13a,		0x21, 0
	.dw 0x2240, 0xc13a,	0x227f, 0xc13a,		0x21, 0
	.dw 0x22c0, 0xc13a,	0x22ff, 0xc13a,		0x21, 0
	.dw 0x2340, 0xc13a,	0x237f, 0xc13a,		0x21, 0
	.dw 0x23c0, 0xc13a,	0x23ff, 0xc13a,		0x21, 0
	.dw 0x2440, 0xc13a,	0x247f, 0xc13a,		0x21, 0
	.dw 0x24c0, 0xc13a,	0x24ff, 0xc13a,		0x21, 0
	.dw 0x2540, 0xc13a,	0x257f, 0xc13a,		0x21, 0
	.dw 0x25c0, 0xc13a,	0x25ff, 0xc13a,		0x21, 0
	.dw 0x2640, 0xc13a,	0x267f, 0xc13a,		0x21, 0
	.dw 0x26c0, 0xc13a,	0x26ff, 0xc13a,		0x21, 0
	.dw 0x2740, 0xc13a,	0x277f, 0xc13a,		0x21, 0
	.dw 0x27c0, 0xc13a,	0x27ff, 0xc13a,		0x21, 0
	.dw 0x2840, 0xc13a,	0x287f, 0xc13a,		0x21, 0
	.dw 0x28c0, 0xc13a,	0x28ff, 0xc13a,		0x21, 0
	.dw 0x2940, 0xc13a,	0x297f, 0xc13a,		0x21, 0
	.dw 0x29c0, 0xc13a,	0x29ff, 0xc13a,		0x21, 0
	.dw 0x2a40, 0xc13a,	0x2a7f, 0xc13a,		0x21, 0
	.dw 0x2ac0, 0xc13a,	0x2aff, 0xc13a,		0x21, 0
	.dw 0x2b40, 0xc13a,	0x2b7f, 0xc13a,		0x21, 0
	.dw 0x2bc0, 0xc13a,	0x2bff, 0xc13a,		0x21, 0
	.dw 0x2c40, 0xc13a,	0x2c7f, 0xc13a,		0x21, 0
	.dw 0x2cc0, 0xc13a,	0x2cff, 0xc13a,		0x21, 0
	.dw 0x2d40, 0xc13a,	0x2d7f, 0xc13a,		0x21, 0
	.dw 0x2dc0, 0xc13a,	0x2dff, 0xc13a,		0x21, 0
	.dw 0x2e40, 0xc13a,	0x2e7f, 0xc13a,		0x21, 0
	.dw 0x2ec0, 0xc13a,	0x2eff, 0xc13a,		0x21, 0
	.dw 0x2f40, 0xc13a,	0x2f7f, 0xc13a,		0x21, 0
	.dw 0x2fc0, 0xc13a,	0x2fff, 0xc13a,		0x21, 0
	.dw 0x3040, 0xc13a,	0x307f, 0xc13a,		0x21, 0
	.dw 0x30c0, 0xc13a,	0x30ff, 0xc13a,		0x21, 0
	.dw 0x3140, 0xc13a,	0x317f, 0xc13a,		0x21, 0
	.dw 0x31c0, 0xc13a,	0x31ff, 0xc13a,		0x21, 0
	.dw 0x3240, 0xc13a,	0x327f, 0xc13a,		0x21, 0
	.dw 0x32c0, 0xc13a,	0x32ff, 0xc13a,		0x21, 0
	.dw 0x3340, 0xc13a,	0x337f, 0xc13a,		0x21, 0
	.dw 0x33c0, 0xc13a,	0x33ff, 0xc13a,		0x21, 0
	.dw 0x3440, 0xc13a,	0x347f, 0xc13a,		0x21, 0
	.dw 0x34c0, 0xc13a,	0x34ff, 0xc13a,		0x21, 0
	.dw 0x3540, 0xc13a,	0x357f, 0xc13a,		0x21, 0
	.dw 0x35c0, 0xc13a,	0x35ff, 0xc13a,		0x21, 0
	.dw 0x3640, 0xc13a,	0x367f, 0xc13a,		0x21, 0
	.dw 0x36c0, 0xc13a,	0x36ff, 0xc13a,		0x21, 0
	.dw 0x3740, 0xc13a,	0x377f, 0xc13a,		0x21, 0
	.dw 0x37c0, 0xc13a,	0x37ff, 0xc13a,		0x21, 0
	.dw 0x3840, 0xc13a,	0x387f, 0xc13a,		0x21, 0
	.dw 0x38c0, 0xc13a,	0x38ff, 0xc13a,		0x21, 0
	.dw 0x3940, 0xc13a,	0x397f, 0xc13a,		0x21, 0
	.dw 0x39c0, 0xc13a,	0x5fff, 0xc13a,		0x21, 0
	.dw 0x6040, 0xc13a,	0x607f, 0xc13a,		0x21, 0
	.dw 0x60c0, 0xc13a,	0x60ff, 0xc13a,		0x21, 0
	.dw 0x6140, 0xc13a,	0x617f, 0xc13a,		0x21, 0
	.dw 0x61c0, 0xc13a,	0x61ff, 0xc13a,		0x21, 0
	.dw 0x6240, 0xc13a,	0x627f, 0xc13a,		0x21, 0
	.dw 0x62c0, 0xc13a,	0x62ff, 0xc13a,		0x21, 0
	.dw 0x6340, 0xc13a,	0x637f, 0xc13a,		0x21, 0
	.dw 0x63c0, 0xc13a,	0x63ff, 0xc13a,		0x21, 0
	.dw 0x6440, 0xc13a,	0x647f, 0xc13a,		0x21, 0
	.dw 0x64c0, 0xc13a,	0x64ff, 0xc13a,		0x21, 0
	.dw 0x6540, 0xc13a,	0x657f, 0xc13a,		0x21, 0
	.dw 0x65c0, 0xc13a,	0x65ff, 0xc13a,		0x21, 0
	.dw 0x6640, 0xc13a,	0x667f, 0xc13a,		0x21, 0
	.dw 0x66c0, 0xc13a,	0x66ff, 0xc13a,		0x21, 0
	.dw 0x6740, 0xc13a,	0x677f, 0xc13a,		0x21, 0
	.dw 0x67c0, 0xc13a,	0x67ff, 0xc13a,		0x21, 0
	.dw 0x6840, 0xc13a,	0x687f, 0xc13a,		0x21, 0
	.dw 0x68c0, 0xc13a,	0x68ff, 0xc13a,		0x21, 0
	.dw 0x6940, 0xc13a,	0x697f, 0xc13a,		0x21, 0
	.dw 0x69c0, 0xc13a,	0x69ff, 0xc13a,		0x21, 0
	.dw 0x6a40, 0xc13a,	0x6a7f, 0xc13a,		0x21, 0
	.dw 0x6ac0, 0xc13a,	0x6aff, 0xc13a,		0x21, 0
	.dw 0x6b40, 0xc13a,	0x6b7f, 0xc13a,		0x21, 0
	.dw 0x6bc0, 0xc13a,	0x6bff, 0xc13a,		0x21, 0
	.dw 0x6c40, 0xc13a,	0x6c7f, 0xc13a,		0x21, 0
	.dw 0x6cc0, 0xc13a,	0x6cff, 0xc13a,		0x21, 0
	.dw 0x6d40, 0xc13a,	0x6d7f, 0xc13a,		0x21, 0
	.dw 0x6dc0, 0xc13a,	0x6dff, 0xc13a,		0x21, 0
	.dw 0x6e40, 0xc13a,	0x6e7f, 0xc13a,		0x21, 0
	.dw 0x6ec0, 0xc13a,	0x6eff, 0xc13a,		0x21, 0
	.dw 0x6f40, 0xc13a,	0x6f7f, 0xc13a,		0x21, 0
	.dw 0x6fc0, 0xc13a,	0x6fff, 0xc13a,		0x21, 0
	.dw 0x7040, 0xc13a,	0x707f, 0xc13a,		0x21, 0
	.dw 0x70c0, 0xc13a,	0x70ff, 0xc13a,		0x21, 0
	.dw 0x7140, 0xc13a,	0x717f, 0xc13a,		0x21, 0
	.dw 0x71c0, 0xc13a,	0x71ff, 0xc13a,		0x21, 0
	.dw 0x7240, 0xc13a,	0x727f, 0xc13a,		0x21, 0
	.dw 0x72c0, 0xc13a,	0x72ff, 0xc13a,		0x21, 0
	.dw 0x7340, 0xc13a,	0x737f, 0xc13a,		0x21, 0
	.dw 0x73c0, 0xc13a,	0x73ff, 0xc13a,		0x21, 0
	.dw 0x7440, 0xc13a,	0x747f, 0xc13a,		0x21, 0
	.dw 0x74c0, 0xc13a,	0x74ff, 0xc13a,		0x21, 0
	.dw 0x7540, 0xc13a,	0x757f, 0xc13a,		0x21, 0
	.dw 0x75c0, 0xc13a,	0x75ff, 0xc13a,		0x21, 0
	.dw 0x7640, 0xc13a,	0x767f, 0xc13a,		0x21, 0
	.dw 0x76c0, 0xc13a,	0x76ff, 0xc13a,		0x21, 0
	.dw 0x7740, 0xc13a,	0x777f, 0xc13a,		0x21, 0
	.dw 0x77c0, 0xc13a,	0x77ff, 0xc13a,		0x21, 0
	.dw 0x7840, 0xc13a,	0x787f, 0xc13a,		0x21, 0
	.dw 0x78c0, 0xc13a,	0x78ff, 0xc13a,		0x21, 0
	.dw 0x7940, 0xc13a,	0x797f, 0xc13a,		0x21, 0
	.dw 0x79c0, 0xc13a,	0x9fff, 0xc13a,		0x21, 0
	.dw 0xa040, 0xc13a,	0xa07f, 0xc13a,		0x21, 0
	.dw 0xa0c0, 0xc13a,	0xa0ff, 0xc13a,		0x21, 0
	.dw 0xa140, 0xc13a,	0xa17f, 0xc13a,		0x21, 0
	.dw 0xa1c0, 0xc13a,	0xa1ff, 0xc13a,		0x21, 0
	.dw 0xa240, 0xc13a,	0xa27f, 0xc13a,		0x21, 0
	.dw 0xa2c0, 0xc13a,	0xa2ff, 0xc13a,		0x21, 0
	.dw 0xa340, 0xc13a,	0xa37f, 0xc13a,		0x21, 0
	.dw 0xa3c0, 0xc13a,	0xa3ff, 0xc13a,		0x21, 0
	.dw 0xa440, 0xc13a,	0xa47f, 0xc13a,		0x21, 0
	.dw 0xa4c0, 0xc13a,	0xa4ff, 0xc13a,		0x21, 0
	.dw 0xa540, 0xc13a,	0xa57f, 0xc13a,		0x21, 0
	.dw 0xa5c0, 0xc13a,	0xa5ff, 0xc13a,		0x21, 0
	.dw 0xa640, 0xc13a,	0xa67f, 0xc13a,		0x21, 0
	.dw 0xa6c0, 0xc13a,	0xa6ff, 0xc13a,		0x21, 0
	.dw 0xa740, 0xc13a,	0xa77f, 0xc13a,		0x21, 0
	.dw 0xa7c0, 0xc13a,	0xa7ff, 0xc13a,		0x21, 0
	.dw 0xa840, 0xc13a,	0xa87f, 0xc13a,		0x21, 0
	.dw 0xa8c0, 0xc13a,	0xa8ff, 0xc13a,		0x21, 0
	.dw 0xa940, 0xc13a,	0xa97f, 0xc13a,		0x21, 0
	.dw 0xa9c0, 0xc13a,	0xa9ff, 0xc13a,		0x21, 0
	.dw 0xaa40, 0xc13a,	0xaa7f, 0xc13a,		0x21, 0
	.dw 0xaac0, 0xc13a,	0xaaff, 0xc13a,		0x21, 0
	.dw 0xab40, 0xc13a,	0xab7f, 0xc13a,		0x21, 0
	.dw 0xabc0, 0xc13a,	0xabff, 0xc13a,		0x21, 0
	.dw 0xac40, 0xc13a,	0xac7f, 0xc13a,		0x21, 0
	.dw 0xacc0, 0xc13a,	0xacff, 0xc13a,		0x21, 0
	.dw 0xad40, 0xc13a,	0xad7f, 0xc13a,		0x21, 0
	.dw 0xadc0, 0xc13a,	0xadff, 0xc13a,		0x21, 0
	.dw 0xae40, 0xc13a,	0xae7f, 0xc13a,		0x21, 0
	.dw 0xaec0, 0xc13a,	0xaeff, 0xc13a,		0x21, 0
	.dw 0xaf40, 0xc13a,	0xaf7f, 0xc13a,		0x21, 0
	.dw 0xafc0, 0xc13a,	0xafff, 0xc13a,		0x21, 0
	.dw 0xb040, 0xc13a,	0xb07f, 0xc13a,		0x21, 0
	.dw 0xb0c0, 0xc13a,	0xb0ff, 0xc13a,		0x21, 0
	.dw 0xb140, 0xc13a,	0xb17f, 0xc13a,		0x21, 0
	.dw 0xb1c0, 0xc13a,	0xb1ff, 0xc13a,		0x21, 0
	.dw 0xb240, 0xc13a,	0xb27f, 0xc13a,		0x21, 0
	.dw 0xb2c0, 0xc13a,	0xb2ff, 0xc13a,		0x21, 0
	.dw 0xb340, 0xc13a,	0xb37f, 0xc13a,		0x21, 0
	.dw 0xb3c0, 0xc13a,	0xb3ff, 0xc13a,		0x21, 0
	.dw 0xb440, 0xc13a,	0xb47f, 0xc13a,		0x21, 0
	.dw 0xb4c0, 0xc13a,	0xb4ff, 0xc13a,		0x21, 0
	.dw 0xb540, 0xc13a,	0xb57f, 0xc13a,		0x21, 0
	.dw 0xb5c0, 0xc13a,	0xb5ff, 0xc13a,		0x21, 0
	.dw 0xb640, 0xc13a,	0xb67f, 0xc13a,		0x21, 0
	.dw 0xb6c0, 0xc13a,	0xb6ff, 0xc13a,		0x21, 0
	.dw 0xb740, 0xc13a,	0xb77f, 0xc13a,		0x21, 0
	.dw 0xb7c0, 0xc13a,	0xb7ff, 0xc13a,		0x21, 0
	.dw 0xb840, 0xc13a,	0xb87f, 0xc13a,		0x21, 0
	.dw 0xb8c0, 0xc13a,	0xb8ff, 0xc13a,		0x21, 0
	.dw 0xb940, 0xc13a,	0xb97f, 0xc13a,		0x21, 0
	.dw 0xb9c0, 0xc13a,	0xdfff, 0xc13a,		0x21, 0
	.dw 0xe040, 0xc13a,	0xe07f, 0xc13a,		0x21, 0
	.dw 0xe0c0, 0xc13a,	0xe0ff, 0xc13a,		0x21, 0
	.dw 0xe140, 0xc13a,	0xe17f, 0xc13a,		0x21, 0
	.dw 0xe1c0, 0xc13a,	0xe1ff, 0xc13a,		0x21, 0
	.dw 0xe240, 0xc13a,	0xe27f, 0xc13a,		0x21, 0
	.dw 0xe2c0, 0xc13a,	0xe2ff, 0xc13a,		0x21, 0
	.dw 0xe340, 0xc13a,	0xe37f, 0xc13a,		0x21, 0
	.dw 0xe3c0, 0xc13a,	0xe3ff, 0xc13a,		0x21, 0
	.dw 0xe440, 0xc13a,	0xe47f, 0xc13a,		0x21, 0
	.dw 0xe4c0, 0xc13a,	0xe4ff, 0xc13a,		0x21, 0
	.dw 0xe540, 0xc13a,	0xe57f, 0xc13a,		0x21, 0
	.dw 0xe5c0, 0xc13a,	0xe5ff, 0xc13a,		0x21, 0
	.dw 0xe640, 0xc13a,	0xe67f, 0xc13a,		0x21, 0
	.dw 0xe6c0, 0xc13a,	0xe6ff, 0xc13a,		0x21, 0
	.dw 0xe740, 0xc13a,	0xe77f, 0xc13a,		0x21, 0
	.dw 0xe7c0, 0xc13a,	0xe7ff, 0xc13a,		0x21, 0
	.dw 0xe840, 0xc13a,	0xe87f, 0xc13a,		0x21, 0
	.dw 0xe8c0, 0xc13a,	0xe8ff, 0xc13a,		0x21, 0
	.dw 0xe940, 0xc13a,	0xe97f, 0xc13a,		0x21, 0
	.dw 0xe9c0, 0xc13a,	0xe9ff, 0xc13a,		0x21, 0
	.dw 0xea40, 0xc13a,	0xea7f, 0xc13a,		0x21, 0
	.dw 0xeac0, 0xc13a,	0xeaff, 0xc13a,		0x21, 0
	.dw 0xeb40, 0xc13a,	0xeb7f, 0xc13a,		0x21, 0
	.dw 0xebc0, 0xc13a,	0xebff, 0xc13a,		0x21, 0
	.dw 0xec40, 0xc13a,	0xec7f, 0xc13a,		0x21, 0
	.dw 0xecc0, 0xc13a,	0xecff, 0xc13a,		0x21, 0
	.dw 0xed40, 0xc13a,	0xed7f, 0xc13a,		0x21, 0
	.dw 0xedc0, 0xc13a,	0xedff, 0xc13a,		0x21, 0
	.dw 0xee40, 0xc13a,	0xee7f, 0xc13a,		0x21, 0
	.dw 0xeec0, 0xc13a,	0xeeff, 0xc13a,		0x21, 0
	.dw 0xef40, 0xc13a,	0xef7f, 0xc13a,		0x21, 0
	.dw 0xefc0, 0xc13a,	0xefff, 0xc13a,		0x21, 0
	.dw 0xf040, 0xc13a,	0xf07f, 0xc13a,		0x21, 0
	.dw 0xf0c0, 0xc13a,	0xf0ff, 0xc13a,		0x21, 0
	.dw 0xf140, 0xc13a,	0xf17f, 0xc13a,		0x21, 0
	.dw 0xf1c0, 0xc13a,	0xf1ff, 0xc13a,		0x21, 0
	.dw 0xf240, 0xc13a,	0xf27f, 0xc13a,		0x21, 0
	.dw 0xf2c0, 0xc13a,	0xf2ff, 0xc13a,		0x21, 0
	.dw 0xf340, 0xc13a,	0xf37f, 0xc13a,		0x21, 0
	.dw 0xf3c0, 0xc13a,	0xf3ff, 0xc13a,		0x21, 0
	.dw 0xf440, 0xc13a,	0xf47f, 0xc13a,		0x21, 0
	.dw 0xf4c0, 0xc13a,	0xf4ff, 0xc13a,		0x21, 0
	.dw 0xf540, 0xc13a,	0xf57f, 0xc13a,		0x21, 0
	.dw 0xf5c0, 0xc13a,	0xf5ff, 0xc13a,		0x21, 0
	.dw 0xf640, 0xc13a,	0xf67f, 0xc13a,		0x21, 0
	.dw 0xf6c0, 0xc13a,	0xf6ff, 0xc13a,		0x21, 0
	.dw 0xf740, 0xc13a,	0xf77f, 0xc13a,		0x21, 0
	.dw 0xf7c0, 0xc13a,	0xf7ff, 0xc13a,		0x21, 0
	.dw 0xf840, 0xc13a,	0xf87f, 0xc13a,		0x21, 0
	.dw 0xf8c0, 0xc13a,	0xf8ff, 0xc13a,		0x21, 0
	.dw 0xf940, 0xc13a,	0xf97f, 0xc13a,		0x21, 0
	.dw 0xf9c0, 0xc13a,	0xffff, 0xc13b,		0x21, 0
	.dw 0x0040, 0xc13c,	0x007f, 0xc13c,		0x21, 0
	.dw 0x00c0, 0xc13c,	0x00ff, 0xc13c,		0x21, 0
	.dw 0x0140, 0xc13c,	0x017f, 0xc13c,		0x21, 0
	.dw 0x01c0, 0xc13c,	0x01ff, 0xc13c,		0x21, 0
	.dw 0x0240, 0xc13c,	0x027f, 0xc13c,		0x21, 0
	.dw 0x02c0, 0xc13c,	0x02ff, 0xc13c,		0x21, 0
	.dw 0x0340, 0xc13c,	0x037f, 0xc13c,		0x21, 0
	.dw 0x03c0, 0xc13c,	0x03ff, 0xc13c,		0x21, 0
	.dw 0x0440, 0xc13c,	0x047f, 0xc13c,		0x21, 0
	.dw 0x04c0, 0xc13c,	0x04ff, 0xc13c,		0x21, 0
	.dw 0x0540, 0xc13c,	0x057f, 0xc13c,		0x21, 0
	.dw 0x05c0, 0xc13c,	0x05ff, 0xc13c,		0x21, 0
	.dw 0x0640, 0xc13c,	0x067f, 0xc13c,		0x21, 0
	.dw 0x06c0, 0xc13c,	0x06ff, 0xc13c,		0x21, 0
	.dw 0x0740, 0xc13c,	0x077f, 0xc13c,		0x21, 0
	.dw 0x07c0, 0xc13c,	0x07ff, 0xc13c,		0x21, 0
	.dw 0x0840, 0xc13c,	0x087f, 0xc13c,		0x21, 0
	.dw 0x08c0, 0xc13c,	0x08ff, 0xc13c,		0x21, 0
	.dw 0x0940, 0xc13c,	0x097f, 0xc13c,		0x21, 0
	.dw 0x09c0, 0xc13c,	0x09ff, 0xc13c,		0x21, 0
	.dw 0x0a40, 0xc13c,	0x0a7f, 0xc13c,		0x21, 0
	.dw 0x0ac0, 0xc13c,	0x0aff, 0xc13c,		0x21, 0
	.dw 0x0b40, 0xc13c,	0x0b7f, 0xc13c,		0x21, 0
	.dw 0x0bc0, 0xc13c,	0x0bff, 0xc13c,		0x21, 0
	.dw 0x0c40, 0xc13c,	0x0c7f, 0xc13c,		0x21, 0
	.dw 0x0cc0, 0xc13c,	0x0cff, 0xc13c,		0x21, 0
	.dw 0x0d40, 0xc13c,	0x0d7f, 0xc13c,		0x21, 0
	.dw 0x0dc0, 0xc13c,	0x0dff, 0xc13c,		0x21, 0
	.dw 0x0e40, 0xc13c,	0x0e7f, 0xc13c,		0x21, 0
	.dw 0x0ec0, 0xc13c,	0x0eff, 0xc13c,		0x21, 0
	.dw 0x0f40, 0xc13c,	0x0f7f, 0xc13c,		0x21, 0
	.dw 0x0fc0, 0xc13c,	0x0fff, 0xc13c,		0x21, 0
	.dw 0x1040, 0xc13c,	0x107f, 0xc13c,		0x21, 0
	.dw 0x10c0, 0xc13c,	0x10ff, 0xc13c,		0x21, 0
	.dw 0x1140, 0xc13c,	0x117f, 0xc13c,		0x21, 0
	.dw 0x11c0, 0xc13c,	0x11ff, 0xc13c,		0x21, 0
	.dw 0x1240, 0xc13c,	0x127f, 0xc13c,		0x21, 0
	.dw 0x12c0, 0xc13c,	0x12ff, 0xc13c,		0x21, 0
	.dw 0x1340, 0xc13c,	0x137f, 0xc13c,		0x21, 0
	.dw 0x13c0, 0xc13c,	0x13ff, 0xc13c,		0x21, 0
	.dw 0x1440, 0xc13c,	0x147f, 0xc13c,		0x21, 0
	.dw 0x14c0, 0xc13c,	0x14ff, 0xc13c,		0x21, 0
	.dw 0x1540, 0xc13c,	0x157f, 0xc13c,		0x21, 0
	.dw 0x15c0, 0xc13c,	0x15ff, 0xc13c,		0x21, 0
	.dw 0x1640, 0xc13c,	0x167f, 0xc13c,		0x21, 0
	.dw 0x16c0, 0xc13c,	0x16ff, 0xc13c,		0x21, 0
	.dw 0x1740, 0xc13c,	0x177f, 0xc13c,		0x21, 0
	.dw 0x17c0, 0xc13c,	0x17ff, 0xc13c,		0x21, 0
	.dw 0x1840, 0xc13c,	0x187f, 0xc13c,		0x21, 0
	.dw 0x18c0, 0xc13c,	0x18ff, 0xc13c,		0x21, 0
	.dw 0x1940, 0xc13c,	0x197f, 0xc13c,		0x21, 0
	.dw 0x19c0, 0xc13c,	0x1fff, 0xc13c,		0x21, 0
	.dw 0x2040, 0xc13c,	0x207f, 0xc13c,		0x21, 0
	.dw 0x20c0, 0xc13c,	0x20ff, 0xc13c,		0x21, 0
	.dw 0x2140, 0xc13c,	0x217f, 0xc13c,		0x21, 0
	.dw 0x21c0, 0xc13c,	0x21ff, 0xc13c,		0x21, 0
	.dw 0x2240, 0xc13c,	0x227f, 0xc13c,		0x21, 0
	.dw 0x22c0, 0xc13c,	0x22ff, 0xc13c,		0x21, 0
	.dw 0x2340, 0xc13c,	0x237f, 0xc13c,		0x21, 0
	.dw 0x23c0, 0xc13c,	0x23ff, 0xc13c,		0x21, 0
	.dw 0x2440, 0xc13c,	0x247f, 0xc13c,		0x21, 0
	.dw 0x24c0, 0xc13c,	0x24ff, 0xc13c,		0x21, 0
	.dw 0x2540, 0xc13c,	0x257f, 0xc13c,		0x21, 0
	.dw 0x25c0, 0xc13c,	0x25ff, 0xc13c,		0x21, 0
	.dw 0x2640, 0xc13c,	0x267f, 0xc13c,		0x21, 0
	.dw 0x26c0, 0xc13c,	0x26ff, 0xc13c,		0x21, 0
	.dw 0x2740, 0xc13c,	0x277f, 0xc13c,		0x21, 0
	.dw 0x27c0, 0xc13c,	0x27ff, 0xc13c,		0x21, 0
	.dw 0x2840, 0xc13c,	0x287f, 0xc13c,		0x21, 0
	.dw 0x28c0, 0xc13c,	0x28ff, 0xc13c,		0x21, 0
	.dw 0x2940, 0xc13c,	0x297f, 0xc13c,		0x21, 0
	.dw 0x29c0, 0xc13c,	0x29ff, 0xc13c,		0x21, 0
	.dw 0x2a40, 0xc13c,	0x2a7f, 0xc13c,		0x21, 0
	.dw 0x2ac0, 0xc13c,	0x2aff, 0xc13c,		0x21, 0
	.dw 0x2b40, 0xc13c,	0x2b7f, 0xc13c,		0x21, 0
	.dw 0x2bc0, 0xc13c,	0x2bff, 0xc13c,		0x21, 0
	.dw 0x2c40, 0xc13c,	0x2c7f, 0xc13c,		0x21, 0
	.dw 0x2cc0, 0xc13c,	0x2cff, 0xc13c,		0x21, 0
	.dw 0x2d40, 0xc13c,	0x2d7f, 0xc13c,		0x21, 0
	.dw 0x2dc0, 0xc13c,	0x2dff, 0xc13c,		0x21, 0
	.dw 0x2e40, 0xc13c,	0x2e7f, 0xc13c,		0x21, 0
	.dw 0x2ec0, 0xc13c,	0x2eff, 0xc13c,		0x21, 0
	.dw 0x2f40, 0xc13c,	0x2f7f, 0xc13c,		0x21, 0
	.dw 0x2fc0, 0xc13c,	0x2fff, 0xc13c,		0x21, 0
	.dw 0x3040, 0xc13c,	0x307f, 0xc13c,		0x21, 0
	.dw 0x30c0, 0xc13c,	0x30ff, 0xc13c,		0x21, 0
	.dw 0x3140, 0xc13c,	0x317f, 0xc13c,		0x21, 0
	.dw 0x31c0, 0xc13c,	0x31ff, 0xc13c,		0x21, 0
	.dw 0x3240, 0xc13c,	0x327f, 0xc13c,		0x21, 0
	.dw 0x32c0, 0xc13c,	0x32ff, 0xc13c,		0x21, 0
	.dw 0x3340, 0xc13c,	0x337f, 0xc13c,		0x21, 0
	.dw 0x33c0, 0xc13c,	0x33ff, 0xc13c,		0x21, 0
	.dw 0x3440, 0xc13c,	0x347f, 0xc13c,		0x21, 0
	.dw 0x34c0, 0xc13c,	0x34ff, 0xc13c,		0x21, 0
	.dw 0x3540, 0xc13c,	0x357f, 0xc13c,		0x21, 0
	.dw 0x35c0, 0xc13c,	0x35ff, 0xc13c,		0x21, 0
	.dw 0x3640, 0xc13c,	0x367f, 0xc13c,		0x21, 0
	.dw 0x36c0, 0xc13c,	0x36ff, 0xc13c,		0x21, 0
	.dw 0x3740, 0xc13c,	0x377f, 0xc13c,		0x21, 0
	.dw 0x37c0, 0xc13c,	0x37ff, 0xc13c,		0x21, 0
	.dw 0x3840, 0xc13c,	0x387f, 0xc13c,		0x21, 0
	.dw 0x38c0, 0xc13c,	0x38ff, 0xc13c,		0x21, 0
	.dw 0x3940, 0xc13c,	0x397f, 0xc13c,		0x21, 0
	.dw 0x39c0, 0xc13c,	0x3fff, 0xc13c,		0x21, 0
	.dw 0x4040, 0xc13c,	0x407f, 0xc13c,		0x21, 0
	.dw 0x40c0, 0xc13c,	0x40ff, 0xc13c,		0x21, 0
	.dw 0x4140, 0xc13c,	0x417f, 0xc13c,		0x21, 0
	.dw 0x41c0, 0xc13c,	0x41ff, 0xc13c,		0x21, 0
	.dw 0x4240, 0xc13c,	0x427f, 0xc13c,		0x21, 0
	.dw 0x42c0, 0xc13c,	0x42ff, 0xc13c,		0x21, 0
	.dw 0x4340, 0xc13c,	0x437f, 0xc13c,		0x21, 0
	.dw 0x43c0, 0xc13c,	0x43ff, 0xc13c,		0x21, 0
	.dw 0x4440, 0xc13c,	0x447f, 0xc13c,		0x21, 0
	.dw 0x44c0, 0xc13c,	0x44ff, 0xc13c,		0x21, 0
	.dw 0x4540, 0xc13c,	0x457f, 0xc13c,		0x21, 0
	.dw 0x45c0, 0xc13c,	0x45ff, 0xc13c,		0x21, 0
	.dw 0x4640, 0xc13c,	0x467f, 0xc13c,		0x21, 0
	.dw 0x46c0, 0xc13c,	0x46ff, 0xc13c,		0x21, 0
	.dw 0x4740, 0xc13c,	0x477f, 0xc13c,		0x21, 0
	.dw 0x47c0, 0xc13c,	0x47ff, 0xc13c,		0x21, 0
	.dw 0x4840, 0xc13c,	0x487f, 0xc13c,		0x21, 0
	.dw 0x48c0, 0xc13c,	0x48ff, 0xc13c,		0x21, 0
	.dw 0x4940, 0xc13c,	0x497f, 0xc13c,		0x21, 0
	.dw 0x49c0, 0xc13c,	0x49ff, 0xc13c,		0x21, 0
	.dw 0x4a40, 0xc13c,	0x4a7f, 0xc13c,		0x21, 0
	.dw 0x4ac0, 0xc13c,	0x4aff, 0xc13c,		0x21, 0
	.dw 0x4b40, 0xc13c,	0x4b7f, 0xc13c,		0x21, 0
	.dw 0x4bc0, 0xc13c,	0x4bff, 0xc13c,		0x21, 0
	.dw 0x4c40, 0xc13c,	0x4c7f, 0xc13c,		0x21, 0
	.dw 0x4cc0, 0xc13c,	0x4cff, 0xc13c,		0x21, 0
	.dw 0x4d40, 0xc13c,	0x4d7f, 0xc13c,		0x21, 0
	.dw 0x4dc0, 0xc13c,	0x4dff, 0xc13c,		0x21, 0
	.dw 0x4e40, 0xc13c,	0x4e7f, 0xc13c,		0x21, 0
	.dw 0x4ec0, 0xc13c,	0x4eff, 0xc13c,		0x21, 0
	.dw 0x4f40, 0xc13c,	0x4f7f, 0xc13c,		0x21, 0
	.dw 0x4fc0, 0xc13c,	0x4fff, 0xc13c,		0x21, 0
	.dw 0x5040, 0xc13c,	0x507f, 0xc13c,		0x21, 0
	.dw 0x50c0, 0xc13c,	0x50ff, 0xc13c,		0x21, 0
	.dw 0x5140, 0xc13c,	0x517f, 0xc13c,		0x21, 0
	.dw 0x51c0, 0xc13c,	0x51ff, 0xc13c,		0x21, 0
	.dw 0x5240, 0xc13c,	0x527f, 0xc13c,		0x21, 0
	.dw 0x52c0, 0xc13c,	0x52ff, 0xc13c,		0x21, 0
	.dw 0x5340, 0xc13c,	0x537f, 0xc13c,		0x21, 0
	.dw 0x53c0, 0xc13c,	0x53ff, 0xc13c,		0x21, 0
	.dw 0x5440, 0xc13c,	0x547f, 0xc13c,		0x21, 0
	.dw 0x54c0, 0xc13c,	0x54ff, 0xc13c,		0x21, 0
	.dw 0x5540, 0xc13c,	0x557f, 0xc13c,		0x21, 0
	.dw 0x55c0, 0xc13c,	0x55ff, 0xc13c,		0x21, 0
	.dw 0x5640, 0xc13c,	0x567f, 0xc13c,		0x21, 0
	.dw 0x56c0, 0xc13c,	0x56ff, 0xc13c,		0x21, 0
	.dw 0x5740, 0xc13c,	0x577f, 0xc13c,		0x21, 0
	.dw 0x57c0, 0xc13c,	0x57ff, 0xc13c,		0x21, 0
	.dw 0x5840, 0xc13c,	0x587f, 0xc13c,		0x21, 0
	.dw 0x58c0, 0xc13c,	0x58ff, 0xc13c,		0x21, 0
	.dw 0x5940, 0xc13c,	0x597f, 0xc13c,		0x21, 0
	.dw 0x59c0, 0xc13c,	0x5fff, 0xc13c,		0x21, 0
	.dw 0x6040, 0xc13c,	0x607f, 0xc13c,		0x21, 0
	.dw 0x60c0, 0xc13c,	0x60ff, 0xc13c,		0x21, 0
	.dw 0x6140, 0xc13c,	0x617f, 0xc13c,		0x21, 0
	.dw 0x61c0, 0xc13c,	0x61ff, 0xc13c,		0x21, 0
	.dw 0x6240, 0xc13c,	0x627f, 0xc13c,		0x21, 0
	.dw 0x62c0, 0xc13c,	0x62ff, 0xc13c,		0x21, 0
	.dw 0x6340, 0xc13c,	0x637f, 0xc13c,		0x21, 0
	.dw 0x63c0, 0xc13c,	0x63ff, 0xc13c,		0x21, 0
	.dw 0x6440, 0xc13c,	0x647f, 0xc13c,		0x21, 0
	.dw 0x64c0, 0xc13c,	0x64ff, 0xc13c,		0x21, 0
	.dw 0x6540, 0xc13c,	0x657f, 0xc13c,		0x21, 0
	.dw 0x65c0, 0xc13c,	0x65ff, 0xc13c,		0x21, 0
	.dw 0x6640, 0xc13c,	0x667f, 0xc13c,		0x21, 0
	.dw 0x66c0, 0xc13c,	0x66ff, 0xc13c,		0x21, 0
	.dw 0x6740, 0xc13c,	0x677f, 0xc13c,		0x21, 0
	.dw 0x67c0, 0xc13c,	0x67ff, 0xc13c,		0x21, 0
	.dw 0x6840, 0xc13c,	0x687f, 0xc13c,		0x21, 0
	.dw 0x68c0, 0xc13c,	0x68ff, 0xc13c,		0x21, 0
	.dw 0x6940, 0xc13c,	0x697f, 0xc13c,		0x21, 0
	.dw 0x69c0, 0xc13c,	0x69ff, 0xc13c,		0x21, 0
	.dw 0x6a40, 0xc13c,	0x6a7f, 0xc13c,		0x21, 0
	.dw 0x6ac0, 0xc13c,	0x6aff, 0xc13c,		0x21, 0
	.dw 0x6b40, 0xc13c,	0x6b7f, 0xc13c,		0x21, 0
	.dw 0x6bc0, 0xc13c,	0x6bff, 0xc13c,		0x21, 0
	.dw 0x6c40, 0xc13c,	0x6c7f, 0xc13c,		0x21, 0
	.dw 0x6cc0, 0xc13c,	0x6cff, 0xc13c,		0x21, 0
	.dw 0x6d40, 0xc13c,	0x6d7f, 0xc13c,		0x21, 0
	.dw 0x6dc0, 0xc13c,	0x6dff, 0xc13c,		0x21, 0
	.dw 0x6e40, 0xc13c,	0x6e7f, 0xc13c,		0x21, 0
	.dw 0x6ec0, 0xc13c,	0x6eff, 0xc13c,		0x21, 0
	.dw 0x6f40, 0xc13c,	0x6f7f, 0xc13c,		0x21, 0
	.dw 0x6fc0, 0xc13c,	0x6fff, 0xc13c,		0x21, 0
	.dw 0x7040, 0xc13c,	0x707f, 0xc13c,		0x21, 0
	.dw 0x70c0, 0xc13c,	0x70ff, 0xc13c,		0x21, 0
	.dw 0x7140, 0xc13c,	0x717f, 0xc13c,		0x21, 0
	.dw 0x71c0, 0xc13c,	0x71ff, 0xc13c,		0x21, 0
	.dw 0x7240, 0xc13c,	0x727f, 0xc13c,		0x21, 0
	.dw 0x72c0, 0xc13c,	0x72ff, 0xc13c,		0x21, 0
	.dw 0x7340, 0xc13c,	0x737f, 0xc13c,		0x21, 0
	.dw 0x73c0, 0xc13c,	0x73ff, 0xc13c,		0x21, 0
	.dw 0x7440, 0xc13c,	0x747f, 0xc13c,		0x21, 0
	.dw 0x74c0, 0xc13c,	0x74ff, 0xc13c,		0x21, 0
	.dw 0x7540, 0xc13c,	0x757f, 0xc13c,		0x21, 0
	.dw 0x75c0, 0xc13c,	0x75ff, 0xc13c,		0x21, 0
	.dw 0x7640, 0xc13c,	0x767f, 0xc13c,		0x21, 0
	.dw 0x76c0, 0xc13c,	0x76ff, 0xc13c,		0x21, 0
	.dw 0x7740, 0xc13c,	0x777f, 0xc13c,		0x21, 0
	.dw 0x77c0, 0xc13c,	0x77ff, 0xc13c,		0x21, 0
	.dw 0x7840, 0xc13c,	0x787f, 0xc13c,		0x21, 0
	.dw 0x78c0, 0xc13c,	0x78ff, 0xc13c,		0x21, 0
	.dw 0x7940, 0xc13c,	0x797f, 0xc13c,		0x21, 0
	.dw 0x79c0, 0xc13c,	0x7fff, 0xc13c,		0x21, 0
	.dw 0x8040, 0xc13c,	0x807f, 0xc13c,		0x21, 0
	.dw 0x80c0, 0xc13c,	0x80ff, 0xc13c,		0x21, 0
	.dw 0x8140, 0xc13c,	0x817f, 0xc13c,		0x21, 0
	.dw 0x81c0, 0xc13c,	0x81ff, 0xc13c,		0x21, 0
	.dw 0x8240, 0xc13c,	0x827f, 0xc13c,		0x21, 0
	.dw 0x82c0, 0xc13c,	0x82ff, 0xc13c,		0x21, 0
	.dw 0x8340, 0xc13c,	0x837f, 0xc13c,		0x21, 0
	.dw 0x83c0, 0xc13c,	0x83ff, 0xc13c,		0x21, 0
	.dw 0x8440, 0xc13c,	0x847f, 0xc13c,		0x21, 0
	.dw 0x84c0, 0xc13c,	0x84ff, 0xc13c,		0x21, 0
	.dw 0x8540, 0xc13c,	0x857f, 0xc13c,		0x21, 0
	.dw 0x85c0, 0xc13c,	0x85ff, 0xc13c,		0x21, 0
	.dw 0x8640, 0xc13c,	0x867f, 0xc13c,		0x21, 0
	.dw 0x86c0, 0xc13c,	0x86ff, 0xc13c,		0x21, 0
	.dw 0x8740, 0xc13c,	0x877f, 0xc13c,		0x21, 0
	.dw 0x87c0, 0xc13c,	0x87ff, 0xc13c,		0x21, 0
	.dw 0x8840, 0xc13c,	0x887f, 0xc13c,		0x21, 0
	.dw 0x88c0, 0xc13c,	0x88ff, 0xc13c,		0x21, 0
	.dw 0x8940, 0xc13c,	0x897f, 0xc13c,		0x21, 0
	.dw 0x89c0, 0xc13c,	0x89ff, 0xc13c,		0x21, 0
	.dw 0x8a40, 0xc13c,	0x8a7f, 0xc13c,		0x21, 0
	.dw 0x8ac0, 0xc13c,	0x8aff, 0xc13c,		0x21, 0
	.dw 0x8b40, 0xc13c,	0x8b7f, 0xc13c,		0x21, 0
	.dw 0x8bc0, 0xc13c,	0x8bff, 0xc13c,		0x21, 0
	.dw 0x8c40, 0xc13c,	0x8c7f, 0xc13c,		0x21, 0
	.dw 0x8cc0, 0xc13c,	0x8cff, 0xc13c,		0x21, 0
	.dw 0x8d40, 0xc13c,	0x8d7f, 0xc13c,		0x21, 0
	.dw 0x8dc0, 0xc13c,	0x8dff, 0xc13c,		0x21, 0
	.dw 0x8e40, 0xc13c,	0x8e7f, 0xc13c,		0x21, 0
	.dw 0x8ec0, 0xc13c,	0x8eff, 0xc13c,		0x21, 0
	.dw 0x8f40, 0xc13c,	0x8f7f, 0xc13c,		0x21, 0
	.dw 0x8fc0, 0xc13c,	0x8fff, 0xc13c,		0x21, 0
	.dw 0x9040, 0xc13c,	0x907f, 0xc13c,		0x21, 0
	.dw 0x90c0, 0xc13c,	0x90ff, 0xc13c,		0x21, 0
	.dw 0x9140, 0xc13c,	0x917f, 0xc13c,		0x21, 0
	.dw 0x91c0, 0xc13c,	0x91ff, 0xc13c,		0x21, 0
	.dw 0x9240, 0xc13c,	0x927f, 0xc13c,		0x21, 0
	.dw 0x92c0, 0xc13c,	0x92ff, 0xc13c,		0x21, 0
	.dw 0x9340, 0xc13c,	0x937f, 0xc13c,		0x21, 0
	.dw 0x93c0, 0xc13c,	0x93ff, 0xc13c,		0x21, 0
	.dw 0x9440, 0xc13c,	0x947f, 0xc13c,		0x21, 0
	.dw 0x94c0, 0xc13c,	0x94ff, 0xc13c,		0x21, 0
	.dw 0x9540, 0xc13c,	0x957f, 0xc13c,		0x21, 0
	.dw 0x95c0, 0xc13c,	0x95ff, 0xc13c,		0x21, 0
	.dw 0x9640, 0xc13c,	0x967f, 0xc13c,		0x21, 0
	.dw 0x96c0, 0xc13c,	0x96ff, 0xc13c,		0x21, 0
	.dw 0x9740, 0xc13c,	0x977f, 0xc13c,		0x21, 0
	.dw 0x97c0, 0xc13c,	0x97ff, 0xc13c,		0x21, 0
	.dw 0x9840, 0xc13c,	0x987f, 0xc13c,		0x21, 0
	.dw 0x98c0, 0xc13c,	0x98ff, 0xc13c,		0x21, 0
	.dw 0x9940, 0xc13c,	0x997f, 0xc13c,		0x21, 0
	.dw 0x99c0, 0xc13c,	0x9fff, 0xc13c,		0x21, 0
	.dw 0xa040, 0xc13c,	0xa07f, 0xc13c,		0x21, 0
	.dw 0xa0c0, 0xc13c,	0xa0ff, 0xc13c,		0x21, 0
	.dw 0xa140, 0xc13c,	0xa17f, 0xc13c,		0x21, 0
	.dw 0xa1c0, 0xc13c,	0xa1ff, 0xc13c,		0x21, 0
	.dw 0xa240, 0xc13c,	0xa27f, 0xc13c,		0x21, 0
	.dw 0xa2c0, 0xc13c,	0xa2ff, 0xc13c,		0x21, 0
	.dw 0xa340, 0xc13c,	0xa37f, 0xc13c,		0x21, 0
	.dw 0xa3c0, 0xc13c,	0xa3ff, 0xc13c,		0x21, 0
	.dw 0xa440, 0xc13c,	0xa47f, 0xc13c,		0x21, 0
	.dw 0xa4c0, 0xc13c,	0xa4ff, 0xc13c,		0x21, 0
	.dw 0xa540, 0xc13c,	0xa57f, 0xc13c,		0x21, 0
	.dw 0xa5c0, 0xc13c,	0xa5ff, 0xc13c,		0x21, 0
	.dw 0xa640, 0xc13c,	0xa67f, 0xc13c,		0x21, 0
	.dw 0xa6c0, 0xc13c,	0xa6ff, 0xc13c,		0x21, 0
	.dw 0xa740, 0xc13c,	0xa77f, 0xc13c,		0x21, 0
	.dw 0xa7c0, 0xc13c,	0xa7ff, 0xc13c,		0x21, 0
	.dw 0xa840, 0xc13c,	0xa87f, 0xc13c,		0x21, 0
	.dw 0xa8c0, 0xc13c,	0xa8ff, 0xc13c,		0x21, 0
	.dw 0xa940, 0xc13c,	0xa97f, 0xc13c,		0x21, 0
	.dw 0xa9c0, 0xc13c,	0xa9ff, 0xc13c,		0x21, 0
	.dw 0xaa40, 0xc13c,	0xaa7f, 0xc13c,		0x21, 0
	.dw 0xaac0, 0xc13c,	0xaaff, 0xc13c,		0x21, 0
	.dw 0xab40, 0xc13c,	0xab7f, 0xc13c,		0x21, 0
	.dw 0xabc0, 0xc13c,	0xabff, 0xc13c,		0x21, 0
	.dw 0xac40, 0xc13c,	0xac7f, 0xc13c,		0x21, 0
	.dw 0xacc0, 0xc13c,	0xacff, 0xc13c,		0x21, 0
	.dw 0xad40, 0xc13c,	0xad7f, 0xc13c,		0x21, 0
	.dw 0xadc0, 0xc13c,	0xadff, 0xc13c,		0x21, 0
	.dw 0xae40, 0xc13c,	0xae7f, 0xc13c,		0x21, 0
	.dw 0xaec0, 0xc13c,	0xaeff, 0xc13c,		0x21, 0
	.dw 0xaf40, 0xc13c,	0xaf7f, 0xc13c,		0x21, 0
	.dw 0xafc0, 0xc13c,	0xafff, 0xc13c,		0x21, 0
	.dw 0xb040, 0xc13c,	0xb07f, 0xc13c,		0x21, 0
	.dw 0xb0c0, 0xc13c,	0xb0ff, 0xc13c,		0x21, 0
	.dw 0xb140, 0xc13c,	0xb17f, 0xc13c,		0x21, 0
	.dw 0xb1c0, 0xc13c,	0xb1ff, 0xc13c,		0x21, 0
	.dw 0xb240, 0xc13c,	0xb27f, 0xc13c,		0x21, 0
	.dw 0xb2c0, 0xc13c,	0xb2ff, 0xc13c,		0x21, 0
	.dw 0xb340, 0xc13c,	0xb37f, 0xc13c,		0x21, 0
	.dw 0xb3c0, 0xc13c,	0xb3ff, 0xc13c,		0x21, 0
	.dw 0xb440, 0xc13c,	0xb47f, 0xc13c,		0x21, 0
	.dw 0xb4c0, 0xc13c,	0xb4ff, 0xc13c,		0x21, 0
	.dw 0xb540, 0xc13c,	0xb57f, 0xc13c,		0x21, 0
	.dw 0xb5c0, 0xc13c,	0xb5ff, 0xc13c,		0x21, 0
	.dw 0xb640, 0xc13c,	0xb67f, 0xc13c,		0x21, 0
	.dw 0xb6c0, 0xc13c,	0xb6ff, 0xc13c,		0x21, 0
	.dw 0xb740, 0xc13c,	0xb77f, 0xc13c,		0x21, 0
	.dw 0xb7c0, 0xc13c,	0xb7ff, 0xc13c,		0x21, 0
	.dw 0xb840, 0xc13c,	0xb87f, 0xc13c,		0x21, 0
	.dw 0xb8c0, 0xc13c,	0xb8ff, 0xc13c,		0x21, 0
	.dw 0xb940, 0xc13c,	0xb97f, 0xc13c,		0x21, 0
	.dw 0xb9c0, 0xc13c,	0xbfff, 0xc13c,		0x21, 0
	.dw 0xc040, 0xc13c,	0xc07f, 0xc13c,		0x21, 0
	.dw 0xc0c0, 0xc13c,	0xc0ff, 0xc13c,		0x21, 0
	.dw 0xc140, 0xc13c,	0xc17f, 0xc13c,		0x21, 0
	.dw 0xc1c0, 0xc13c,	0xc1ff, 0xc13c,		0x21, 0
	.dw 0xc240, 0xc13c,	0xc27f, 0xc13c,		0x21, 0
	.dw 0xc2c0, 0xc13c,	0xc2ff, 0xc13c,		0x21, 0
	.dw 0xc340, 0xc13c,	0xc37f, 0xc13c,		0x21, 0
	.dw 0xc3c0, 0xc13c,	0xc3ff, 0xc13c,		0x21, 0
	.dw 0xc440, 0xc13c,	0xc47f, 0xc13c,		0x21, 0
	.dw 0xc4c0, 0xc13c,	0xc4ff, 0xc13c,		0x21, 0
	.dw 0xc540, 0xc13c,	0xc57f, 0xc13c,		0x21, 0
	.dw 0xc5c0, 0xc13c,	0xc5ff, 0xc13c,		0x21, 0
	.dw 0xc640, 0xc13c,	0xc67f, 0xc13c,		0x21, 0
	.dw 0xc6c0, 0xc13c,	0xc6ff, 0xc13c,		0x21, 0
	.dw 0xc740, 0xc13c,	0xc77f, 0xc13c,		0x21, 0
	.dw 0xc7c0, 0xc13c,	0xc7ff, 0xc13c,		0x21, 0
	.dw 0xc840, 0xc13c,	0xc87f, 0xc13c,		0x21, 0
	.dw 0xc8c0, 0xc13c,	0xc8ff, 0xc13c,		0x21, 0
	.dw 0xc940, 0xc13c,	0xc97f, 0xc13c,		0x21, 0
	.dw 0xc9c0, 0xc13c,	0xc9ff, 0xc13c,		0x21, 0
	.dw 0xca40, 0xc13c,	0xca7f, 0xc13c,		0x21, 0
	.dw 0xcac0, 0xc13c,	0xcaff, 0xc13c,		0x21, 0
	.dw 0xcb40, 0xc13c,	0xcb7f, 0xc13c,		0x21, 0
	.dw 0xcbc0, 0xc13c,	0xcbff, 0xc13c,		0x21, 0
	.dw 0xcc40, 0xc13c,	0xcc7f, 0xc13c,		0x21, 0
	.dw 0xccc0, 0xc13c,	0xccff, 0xc13c,		0x21, 0
	.dw 0xcd40, 0xc13c,	0xcd7f, 0xc13c,		0x21, 0
	.dw 0xcdc0, 0xc13c,	0xcdff, 0xc13c,		0x21, 0
	.dw 0xce40, 0xc13c,	0xce7f, 0xc13c,		0x21, 0
	.dw 0xcec0, 0xc13c,	0xceff, 0xc13c,		0x21, 0
	.dw 0xcf40, 0xc13c,	0xcf7f, 0xc13c,		0x21, 0
	.dw 0xcfc0, 0xc13c,	0xcfff, 0xc13c,		0x21, 0
	.dw 0xd040, 0xc13c,	0xd07f, 0xc13c,		0x21, 0
	.dw 0xd0c0, 0xc13c,	0xd0ff, 0xc13c,		0x21, 0
	.dw 0xd140, 0xc13c,	0xd17f, 0xc13c,		0x21, 0
	.dw 0xd1c0, 0xc13c,	0xd1ff, 0xc13c,		0x21, 0
	.dw 0xd240, 0xc13c,	0xd27f, 0xc13c,		0x21, 0
	.dw 0xd2c0, 0xc13c,	0xd2ff, 0xc13c,		0x21, 0
	.dw 0xd340, 0xc13c,	0xd37f, 0xc13c,		0x21, 0
	.dw 0xd3c0, 0xc13c,	0xd3ff, 0xc13c,		0x21, 0
	.dw 0xd440, 0xc13c,	0xd47f, 0xc13c,		0x21, 0
	.dw 0xd4c0, 0xc13c,	0xd4ff, 0xc13c,		0x21, 0
	.dw 0xd540, 0xc13c,	0xd57f, 0xc13c,		0x21, 0
	.dw 0xd5c0, 0xc13c,	0xd5ff, 0xc13c,		0x21, 0
	.dw 0xd640, 0xc13c,	0xd67f, 0xc13c,		0x21, 0
	.dw 0xd6c0, 0xc13c,	0xd6ff, 0xc13c,		0x21, 0
	.dw 0xd740, 0xc13c,	0xd77f, 0xc13c,		0x21, 0
	.dw 0xd7c0, 0xc13c,	0xd7ff, 0xc13c,		0x21, 0
	.dw 0xd840, 0xc13c,	0xd87f, 0xc13c,		0x21, 0
	.dw 0xd8c0, 0xc13c,	0xd8ff, 0xc13c,		0x21, 0
	.dw 0xd940, 0xc13c,	0xd97f, 0xc13c,		0x21, 0
	.dw 0xd9c0, 0xc13c,	0xdfff, 0xc13c,		0x21, 0
	.dw 0xe040, 0xc13c,	0xe07f, 0xc13c,		0x21, 0
	.dw 0xe0c0, 0xc13c,	0xe0ff, 0xc13c,		0x21, 0
	.dw 0xe140, 0xc13c,	0xe17f, 0xc13c,		0x21, 0
	.dw 0xe1c0, 0xc13c,	0xe1ff, 0xc13c,		0x21, 0
	.dw 0xe240, 0xc13c,	0xe27f, 0xc13c,		0x21, 0
	.dw 0xe2c0, 0xc13c,	0xe2ff, 0xc13c,		0x21, 0
	.dw 0xe340, 0xc13c,	0xe37f, 0xc13c,		0x21, 0
	.dw 0xe3c0, 0xc13c,	0xe3ff, 0xc13c,		0x21, 0
	.dw 0xe440, 0xc13c,	0xe47f, 0xc13c,		0x21, 0
	.dw 0xe4c0, 0xc13c,	0xe4ff, 0xc13c,		0x21, 0
	.dw 0xe540, 0xc13c,	0xe57f, 0xc13c,		0x21, 0
	.dw 0xe5c0, 0xc13c,	0xe5ff, 0xc13c,		0x21, 0
	.dw 0xe640, 0xc13c,	0xe67f, 0xc13c,		0x21, 0
	.dw 0xe6c0, 0xc13c,	0xe6ff, 0xc13c,		0x21, 0
	.dw 0xe740, 0xc13c,	0xe77f, 0xc13c,		0x21, 0
	.dw 0xe7c0, 0xc13c,	0xe7ff, 0xc13c,		0x21, 0
	.dw 0xe840, 0xc13c,	0xe87f, 0xc13c,		0x21, 0
	.dw 0xe8c0, 0xc13c,	0xe8ff, 0xc13c,		0x21, 0
	.dw 0xe940, 0xc13c,	0xe97f, 0xc13c,		0x21, 0
	.dw 0xe9c0, 0xc13c,	0xe9ff, 0xc13c,		0x21, 0
	.dw 0xea40, 0xc13c,	0xea7f, 0xc13c,		0x21, 0
	.dw 0xeac0, 0xc13c,	0xeaff, 0xc13c,		0x21, 0
	.dw 0xeb40, 0xc13c,	0xeb7f, 0xc13c,		0x21, 0
	.dw 0xebc0, 0xc13c,	0xebff, 0xc13c,		0x21, 0
	.dw 0xec40, 0xc13c,	0xec7f, 0xc13c,		0x21, 0
	.dw 0xecc0, 0xc13c,	0xecff, 0xc13c,		0x21, 0
	.dw 0xed40, 0xc13c,	0xed7f, 0xc13c,		0x21, 0
	.dw 0xedc0, 0xc13c,	0xedff, 0xc13c,		0x21, 0
	.dw 0xee40, 0xc13c,	0xee7f, 0xc13c,		0x21, 0
	.dw 0xeec0, 0xc13c,	0xeeff, 0xc13c,		0x21, 0
	.dw 0xef40, 0xc13c,	0xef7f, 0xc13c,		0x21, 0
	.dw 0xefc0, 0xc13c,	0xefff, 0xc13c,		0x21, 0
	.dw 0xf040, 0xc13c,	0xf07f, 0xc13c,		0x21, 0
	.dw 0xf0c0, 0xc13c,	0xf0ff, 0xc13c,		0x21, 0
	.dw 0xf140, 0xc13c,	0xf17f, 0xc13c,		0x21, 0
	.dw 0xf1c0, 0xc13c,	0xf1ff, 0xc13c,		0x21, 0
	.dw 0xf240, 0xc13c,	0xf27f, 0xc13c,		0x21, 0
	.dw 0xf2c0, 0xc13c,	0xf2ff, 0xc13c,		0x21, 0
	.dw 0xf340, 0xc13c,	0xf37f, 0xc13c,		0x21, 0
	.dw 0xf3c0, 0xc13c,	0xf3ff, 0xc13c,		0x21, 0
	.dw 0xf440, 0xc13c,	0xf47f, 0xc13c,		0x21, 0
	.dw 0xf4c0, 0xc13c,	0xf4ff, 0xc13c,		0x21, 0
	.dw 0xf540, 0xc13c,	0xf57f, 0xc13c,		0x21, 0
	.dw 0xf5c0, 0xc13c,	0xf5ff, 0xc13c,		0x21, 0
	.dw 0xf640, 0xc13c,	0xf67f, 0xc13c,		0x21, 0
	.dw 0xf6c0, 0xc13c,	0xf6ff, 0xc13c,		0x21, 0
	.dw 0xf740, 0xc13c,	0xf77f, 0xc13c,		0x21, 0
	.dw 0xf7c0, 0xc13c,	0xf7ff, 0xc13c,		0x21, 0
	.dw 0xf840, 0xc13c,	0xf87f, 0xc13c,		0x21, 0
	.dw 0xf8c0, 0xc13c,	0xf8ff, 0xc13c,		0x21, 0
	.dw 0xf940, 0xc13c,	0xf97f, 0xc13c,		0x21, 0
	.dw 0xf9c0, 0xc13c,	0xffff, 0xc13c,		0x21, 0
	.dw 0x0040, 0xc13d,	0x007f, 0xc13d,		0x21, 0
	.dw 0x00c0, 0xc13d,	0x00ff, 0xc13d,		0x21, 0
	.dw 0x0140, 0xc13d,	0x017f, 0xc13d,		0x21, 0
	.dw 0x01c0, 0xc13d,	0x01ff, 0xc13d,		0x21, 0
	.dw 0x0240, 0xc13d,	0x027f, 0xc13d,		0x21, 0
	.dw 0x02c0, 0xc13d,	0x02ff, 0xc13d,		0x21, 0
	.dw 0x0340, 0xc13d,	0x037f, 0xc13d,		0x21, 0
	.dw 0x03c0, 0xc13d,	0x03ff, 0xc13d,		0x21, 0
	.dw 0x0440, 0xc13d,	0x047f, 0xc13d,		0x21, 0
	.dw 0x04c0, 0xc13d,	0x04ff, 0xc13d,		0x21, 0
	.dw 0x0540, 0xc13d,	0x057f, 0xc13d,		0x21, 0
	.dw 0x05c0, 0xc13d,	0x05ff, 0xc13d,		0x21, 0
	.dw 0x0640, 0xc13d,	0x067f, 0xc13d,		0x21, 0
	.dw 0x06c0, 0xc13d,	0x06ff, 0xc13d,		0x21, 0
	.dw 0x0740, 0xc13d,	0x077f, 0xc13d,		0x21, 0
	.dw 0x07c0, 0xc13d,	0x07ff, 0xc13d,		0x21, 0
	.dw 0x0840, 0xc13d,	0x087f, 0xc13d,		0x21, 0
	.dw 0x08c0, 0xc13d,	0x08ff, 0xc13d,		0x21, 0
	.dw 0x0940, 0xc13d,	0x097f, 0xc13d,		0x21, 0
	.dw 0x09c0, 0xc13d,	0x09ff, 0xc13d,		0x21, 0
	.dw 0x0a40, 0xc13d,	0x0a7f, 0xc13d,		0x21, 0
	.dw 0x0ac0, 0xc13d,	0x0aff, 0xc13d,		0x21, 0
	.dw 0x0b40, 0xc13d,	0x0b7f, 0xc13d,		0x21, 0
	.dw 0x0bc0, 0xc13d,	0x0bff, 0xc13d,		0x21, 0
	.dw 0x0c40, 0xc13d,	0x0c7f, 0xc13d,		0x21, 0
	.dw 0x0cc0, 0xc13d,	0x0cff, 0xc13d,		0x21, 0
	.dw 0x0d40, 0xc13d,	0x0d7f, 0xc13d,		0x21, 0
	.dw 0x0dc0, 0xc13d,	0x0dff, 0xc13d,		0x21, 0
	.dw 0x0e40, 0xc13d,	0x0e7f, 0xc13d,		0x21, 0
	.dw 0x0ec0, 0xc13d,	0x0eff, 0xc13d,		0x21, 0
	.dw 0x0f40, 0xc13d,	0x0f7f, 0xc13d,		0x21, 0
	.dw 0x0fc0, 0xc13d,	0x0fff, 0xc13d,		0x21, 0
	.dw 0x1040, 0xc13d,	0x107f, 0xc13d,		0x21, 0
	.dw 0x10c0, 0xc13d,	0x10ff, 0xc13d,		0x21, 0
	.dw 0x1140, 0xc13d,	0x117f, 0xc13d,		0x21, 0
	.dw 0x11c0, 0xc13d,	0x11ff, 0xc13d,		0x21, 0
	.dw 0x1240, 0xc13d,	0x127f, 0xc13d,		0x21, 0
	.dw 0x12c0, 0xc13d,	0x12ff, 0xc13d,		0x21, 0
	.dw 0x1340, 0xc13d,	0x137f, 0xc13d,		0x21, 0
	.dw 0x13c0, 0xc13d,	0x13ff, 0xc13d,		0x21, 0
	.dw 0x1440, 0xc13d,	0x147f, 0xc13d,		0x21, 0
	.dw 0x14c0, 0xc13d,	0x14ff, 0xc13d,		0x21, 0
	.dw 0x1540, 0xc13d,	0x157f, 0xc13d,		0x21, 0
	.dw 0x15c0, 0xc13d,	0x15ff, 0xc13d,		0x21, 0
	.dw 0x1640, 0xc13d,	0x167f, 0xc13d,		0x21, 0
	.dw 0x16c0, 0xc13d,	0x16ff, 0xc13d,		0x21, 0
	.dw 0x1740, 0xc13d,	0x177f, 0xc13d,		0x21, 0
	.dw 0x17c0, 0xc13d,	0x17ff, 0xc13d,		0x21, 0
	.dw 0x1840, 0xc13d,	0x187f, 0xc13d,		0x21, 0
	.dw 0x18c0, 0xc13d,	0x18ff, 0xc13d,		0x21, 0
	.dw 0x1940, 0xc13d,	0x197f, 0xc13d,		0x21, 0
	.dw 0x19c0, 0xc13d,	0x1fff, 0xc13d,		0x21, 0
	.dw 0x2040, 0xc13d,	0x207f, 0xc13d,		0x21, 0
	.dw 0x20c0, 0xc13d,	0x20ff, 0xc13d,		0x21, 0
	.dw 0x2140, 0xc13d,	0x217f, 0xc13d,		0x21, 0
	.dw 0x21c0, 0xc13d,	0x21ff, 0xc13d,		0x21, 0
	.dw 0x2240, 0xc13d,	0x227f, 0xc13d,		0x21, 0
	.dw 0x22c0, 0xc13d,	0x22ff, 0xc13d,		0x21, 0
	.dw 0x2340, 0xc13d,	0x237f, 0xc13d,		0x21, 0
	.dw 0x23c0, 0xc13d,	0x23ff, 0xc13d,		0x21, 0
	.dw 0x2440, 0xc13d,	0x247f, 0xc13d,		0x21, 0
	.dw 0x24c0, 0xc13d,	0x24ff, 0xc13d,		0x21, 0
	.dw 0x2540, 0xc13d,	0x257f, 0xc13d,		0x21, 0
	.dw 0x25c0, 0xc13d,	0x25ff, 0xc13d,		0x21, 0
	.dw 0x2640, 0xc13d,	0x267f, 0xc13d,		0x21, 0
	.dw 0x26c0, 0xc13d,	0x26ff, 0xc13d,		0x21, 0
	.dw 0x2740, 0xc13d,	0x277f, 0xc13d,		0x21, 0
	.dw 0x27c0, 0xc13d,	0x27ff, 0xc13d,		0x21, 0
	.dw 0x2840, 0xc13d,	0x287f, 0xc13d,		0x21, 0
	.dw 0x28c0, 0xc13d,	0x28ff, 0xc13d,		0x21, 0
	.dw 0x2940, 0xc13d,	0x297f, 0xc13d,		0x21, 0
	.dw 0x29c0, 0xc13d,	0x29ff, 0xc13d,		0x21, 0
	.dw 0x2a40, 0xc13d,	0x2a7f, 0xc13d,		0x21, 0
	.dw 0x2ac0, 0xc13d,	0x2aff, 0xc13d,		0x21, 0
	.dw 0x2b40, 0xc13d,	0x2b7f, 0xc13d,		0x21, 0
	.dw 0x2bc0, 0xc13d,	0x2bff, 0xc13d,		0x21, 0
	.dw 0x2c40, 0xc13d,	0x2c7f, 0xc13d,		0x21, 0
	.dw 0x2cc0, 0xc13d,	0x2cff, 0xc13d,		0x21, 0
	.dw 0x2d40, 0xc13d,	0x2d7f, 0xc13d,		0x21, 0
	.dw 0x2dc0, 0xc13d,	0x2dff, 0xc13d,		0x21, 0
	.dw 0x2e40, 0xc13d,	0x2e7f, 0xc13d,		0x21, 0
	.dw 0x2ec0, 0xc13d,	0x2eff, 0xc13d,		0x21, 0
	.dw 0x2f40, 0xc13d,	0x2f7f, 0xc13d,		0x21, 0
	.dw 0x2fc0, 0xc13d,	0x2fff, 0xc13d,		0x21, 0
	.dw 0x3040, 0xc13d,	0x307f, 0xc13d,		0x21, 0
	.dw 0x30c0, 0xc13d,	0x30ff, 0xc13d,		0x21, 0
	.dw 0x3140, 0xc13d,	0x317f, 0xc13d,		0x21, 0
	.dw 0x31c0, 0xc13d,	0x31ff, 0xc13d,		0x21, 0
	.dw 0x3240, 0xc13d,	0x327f, 0xc13d,		0x21, 0
	.dw 0x32c0, 0xc13d,	0x32ff, 0xc13d,		0x21, 0
	.dw 0x3340, 0xc13d,	0x337f, 0xc13d,		0x21, 0
	.dw 0x33c0, 0xc13d,	0x33ff, 0xc13d,		0x21, 0
	.dw 0x3440, 0xc13d,	0x347f, 0xc13d,		0x21, 0
	.dw 0x34c0, 0xc13d,	0x34ff, 0xc13d,		0x21, 0
	.dw 0x3540, 0xc13d,	0x357f, 0xc13d,		0x21, 0
	.dw 0x35c0, 0xc13d,	0x35ff, 0xc13d,		0x21, 0
	.dw 0x3640, 0xc13d,	0x367f, 0xc13d,		0x21, 0
	.dw 0x36c0, 0xc13d,	0x36ff, 0xc13d,		0x21, 0
	.dw 0x3740, 0xc13d,	0x377f, 0xc13d,		0x21, 0
	.dw 0x37c0, 0xc13d,	0x37ff, 0xc13d,		0x21, 0
	.dw 0x3840, 0xc13d,	0x387f, 0xc13d,		0x21, 0
	.dw 0x38c0, 0xc13d,	0x38ff, 0xc13d,		0x21, 0
	.dw 0x3940, 0xc13d,	0x397f, 0xc13d,		0x21, 0
	.dw 0x39c0, 0xc13d,	0x3fff, 0xc13d,		0x21, 0
	.dw 0x4040, 0xc13d,	0x407f, 0xc13d,		0x21, 0
	.dw 0x40c0, 0xc13d,	0x40ff, 0xc13d,		0x21, 0
	.dw 0x4140, 0xc13d,	0x417f, 0xc13d,		0x21, 0
	.dw 0x41c0, 0xc13d,	0x41ff, 0xc13d,		0x21, 0
	.dw 0x4240, 0xc13d,	0x427f, 0xc13d,		0x21, 0
	.dw 0x42c0, 0xc13d,	0x42ff, 0xc13d,		0x21, 0
	.dw 0x4340, 0xc13d,	0x437f, 0xc13d,		0x21, 0
	.dw 0x43c0, 0xc13d,	0x43ff, 0xc13d,		0x21, 0
	.dw 0x4440, 0xc13d,	0x447f, 0xc13d,		0x21, 0
	.dw 0x44c0, 0xc13d,	0x44ff, 0xc13d,		0x21, 0
	.dw 0x4540, 0xc13d,	0x457f, 0xc13d,		0x21, 0
	.dw 0x45c0, 0xc13d,	0x45ff, 0xc13d,		0x21, 0
	.dw 0x4640, 0xc13d,	0x467f, 0xc13d,		0x21, 0
	.dw 0x46c0, 0xc13d,	0x46ff, 0xc13d,		0x21, 0
	.dw 0x4740, 0xc13d,	0x477f, 0xc13d,		0x21, 0
	.dw 0x47c0, 0xc13d,	0x47ff, 0xc13d,		0x21, 0
	.dw 0x4840, 0xc13d,	0x487f, 0xc13d,		0x21, 0
	.dw 0x48c0, 0xc13d,	0x48ff, 0xc13d,		0x21, 0
	.dw 0x4940, 0xc13d,	0x497f, 0xc13d,		0x21, 0
	.dw 0x49c0, 0xc13d,	0x49ff, 0xc13d,		0x21, 0
	.dw 0x4a40, 0xc13d,	0x4a7f, 0xc13d,		0x21, 0
	.dw 0x4ac0, 0xc13d,	0x4aff, 0xc13d,		0x21, 0
	.dw 0x4b40, 0xc13d,	0x4b7f, 0xc13d,		0x21, 0
	.dw 0x4bc0, 0xc13d,	0x4bff, 0xc13d,		0x21, 0
	.dw 0x4c40, 0xc13d,	0x4c7f, 0xc13d,		0x21, 0
	.dw 0x4cc0, 0xc13d,	0x4cff, 0xc13d,		0x21, 0
	.dw 0x4d40, 0xc13d,	0x4d7f, 0xc13d,		0x21, 0
	.dw 0x4dc0, 0xc13d,	0x4dff, 0xc13d,		0x21, 0
	.dw 0x4e40, 0xc13d,	0x4e7f, 0xc13d,		0x21, 0
	.dw 0x4ec0, 0xc13d,	0x4eff, 0xc13d,		0x21, 0
	.dw 0x4f40, 0xc13d,	0x4f7f, 0xc13d,		0x21, 0
	.dw 0x4fc0, 0xc13d,	0x4fff, 0xc13d,		0x21, 0
	.dw 0x5040, 0xc13d,	0x507f, 0xc13d,		0x21, 0
	.dw 0x50c0, 0xc13d,	0x50ff, 0xc13d,		0x21, 0
	.dw 0x5140, 0xc13d,	0x517f, 0xc13d,		0x21, 0
	.dw 0x51c0, 0xc13d,	0x51ff, 0xc13d,		0x21, 0
	.dw 0x5240, 0xc13d,	0x527f, 0xc13d,		0x21, 0
	.dw 0x52c0, 0xc13d,	0x52ff, 0xc13d,		0x21, 0
	.dw 0x5340, 0xc13d,	0x537f, 0xc13d,		0x21, 0
	.dw 0x53c0, 0xc13d,	0x53ff, 0xc13d,		0x21, 0
	.dw 0x5440, 0xc13d,	0x547f, 0xc13d,		0x21, 0
	.dw 0x54c0, 0xc13d,	0x54ff, 0xc13d,		0x21, 0
	.dw 0x5540, 0xc13d,	0x557f, 0xc13d,		0x21, 0
	.dw 0x55c0, 0xc13d,	0x55ff, 0xc13d,		0x21, 0
	.dw 0x5640, 0xc13d,	0x567f, 0xc13d,		0x21, 0
	.dw 0x56c0, 0xc13d,	0x56ff, 0xc13d,		0x21, 0
	.dw 0x5740, 0xc13d,	0x577f, 0xc13d,		0x21, 0
	.dw 0x57c0, 0xc13d,	0x57ff, 0xc13d,		0x21, 0
	.dw 0x5840, 0xc13d,	0x587f, 0xc13d,		0x21, 0
	.dw 0x58c0, 0xc13d,	0x58ff, 0xc13d,		0x21, 0
	.dw 0x5940, 0xc13d,	0x597f, 0xc13d,		0x21, 0
	.dw 0x59c0, 0xc13d,	0x5fff, 0xc13d,		0x21, 0
	.dw 0x6040, 0xc13d,	0x607f, 0xc13d,		0x21, 0
	.dw 0x60c0, 0xc13d,	0x60ff, 0xc13d,		0x21, 0
	.dw 0x6140, 0xc13d,	0x617f, 0xc13d,		0x21, 0
	.dw 0x61c0, 0xc13d,	0x61ff, 0xc13d,		0x21, 0
	.dw 0x6240, 0xc13d,	0x627f, 0xc13d,		0x21, 0
	.dw 0x62c0, 0xc13d,	0x62ff, 0xc13d,		0x21, 0
	.dw 0x6340, 0xc13d,	0x637f, 0xc13d,		0x21, 0
	.dw 0x63c0, 0xc13d,	0x63ff, 0xc13d,		0x21, 0
	.dw 0x6440, 0xc13d,	0x647f, 0xc13d,		0x21, 0
	.dw 0x64c0, 0xc13d,	0x64ff, 0xc13d,		0x21, 0
	.dw 0x6540, 0xc13d,	0x657f, 0xc13d,		0x21, 0
	.dw 0x65c0, 0xc13d,	0x65ff, 0xc13d,		0x21, 0
	.dw 0x6640, 0xc13d,	0x667f, 0xc13d,		0x21, 0
	.dw 0x66c0, 0xc13d,	0x66ff, 0xc13d,		0x21, 0
	.dw 0x6740, 0xc13d,	0x677f, 0xc13d,		0x21, 0
	.dw 0x67c0, 0xc13d,	0x67ff, 0xc13d,		0x21, 0
	.dw 0x6840, 0xc13d,	0x687f, 0xc13d,		0x21, 0
	.dw 0x68c0, 0xc13d,	0x68ff, 0xc13d,		0x21, 0
	.dw 0x6940, 0xc13d,	0x697f, 0xc13d,		0x21, 0
	.dw 0x69c0, 0xc13d,	0x69ff, 0xc13d,		0x21, 0
	.dw 0x6a40, 0xc13d,	0x6a7f, 0xc13d,		0x21, 0
	.dw 0x6ac0, 0xc13d,	0x6aff, 0xc13d,		0x21, 0
	.dw 0x6b40, 0xc13d,	0x6b7f, 0xc13d,		0x21, 0
	.dw 0x6bc0, 0xc13d,	0x6bff, 0xc13d,		0x21, 0
	.dw 0x6c40, 0xc13d,	0x6c7f, 0xc13d,		0x21, 0
	.dw 0x6cc0, 0xc13d,	0x6cff, 0xc13d,		0x21, 0
	.dw 0x6d40, 0xc13d,	0x6d7f, 0xc13d,		0x21, 0
	.dw 0x6dc0, 0xc13d,	0x6dff, 0xc13d,		0x21, 0
	.dw 0x6e40, 0xc13d,	0x6e7f, 0xc13d,		0x21, 0
	.dw 0x6ec0, 0xc13d,	0x6eff, 0xc13d,		0x21, 0
	.dw 0x6f40, 0xc13d,	0x6f7f, 0xc13d,		0x21, 0
	.dw 0x6fc0, 0xc13d,	0x6fff, 0xc13d,		0x21, 0
	.dw 0x7040, 0xc13d,	0x707f, 0xc13d,		0x21, 0
	.dw 0x70c0, 0xc13d,	0x70ff, 0xc13d,		0x21, 0
	.dw 0x7140, 0xc13d,	0x717f, 0xc13d,		0x21, 0
	.dw 0x71c0, 0xc13d,	0x71ff, 0xc13d,		0x21, 0
	.dw 0x7240, 0xc13d,	0x727f, 0xc13d,		0x21, 0
	.dw 0x72c0, 0xc13d,	0x72ff, 0xc13d,		0x21, 0
	.dw 0x7340, 0xc13d,	0x737f, 0xc13d,		0x21, 0
	.dw 0x73c0, 0xc13d,	0x73ff, 0xc13d,		0x21, 0
	.dw 0x7440, 0xc13d,	0x747f, 0xc13d,		0x21, 0
	.dw 0x74c0, 0xc13d,	0x74ff, 0xc13d,		0x21, 0
	.dw 0x7540, 0xc13d,	0x757f, 0xc13d,		0x21, 0
	.dw 0x75c0, 0xc13d,	0x75ff, 0xc13d,		0x21, 0
	.dw 0x7640, 0xc13d,	0x767f, 0xc13d,		0x21, 0
	.dw 0x76c0, 0xc13d,	0x76ff, 0xc13d,		0x21, 0
	.dw 0x7740, 0xc13d,	0x777f, 0xc13d,		0x21, 0
	.dw 0x77c0, 0xc13d,	0x77ff, 0xc13d,		0x21, 0
	.dw 0x7840, 0xc13d,	0x787f, 0xc13d,		0x21, 0
	.dw 0x78c0, 0xc13d,	0x78ff, 0xc13d,		0x21, 0
	.dw 0x7940, 0xc13d,	0x797f, 0xc13d,		0x21, 0
	.dw 0x79c0, 0xc13d,	0x7fff, 0xc13d,		0x21, 0
	.dw 0x8040, 0xc13d,	0x807f, 0xc13d,		0x21, 0
	.dw 0x80c0, 0xc13d,	0x80ff, 0xc13d,		0x21, 0
	.dw 0x8140, 0xc13d,	0x817f, 0xc13d,		0x21, 0
	.dw 0x81c0, 0xc13d,	0x81ff, 0xc13d,		0x21, 0
	.dw 0x8240, 0xc13d,	0x827f, 0xc13d,		0x21, 0
	.dw 0x82c0, 0xc13d,	0x82ff, 0xc13d,		0x21, 0
	.dw 0x8340, 0xc13d,	0x837f, 0xc13d,		0x21, 0
	.dw 0x83c0, 0xc13d,	0x83ff, 0xc13d,		0x21, 0
	.dw 0x8440, 0xc13d,	0x847f, 0xc13d,		0x21, 0
	.dw 0x84c0, 0xc13d,	0x84ff, 0xc13d,		0x21, 0
	.dw 0x8540, 0xc13d,	0x857f, 0xc13d,		0x21, 0
	.dw 0x85c0, 0xc13d,	0x85ff, 0xc13d,		0x21, 0
	.dw 0x8640, 0xc13d,	0x867f, 0xc13d,		0x21, 0
	.dw 0x86c0, 0xc13d,	0x86ff, 0xc13d,		0x21, 0
	.dw 0x8740, 0xc13d,	0x877f, 0xc13d,		0x21, 0
	.dw 0x87c0, 0xc13d,	0x87ff, 0xc13d,		0x21, 0
	.dw 0x8840, 0xc13d,	0x887f, 0xc13d,		0x21, 0
	.dw 0x88c0, 0xc13d,	0x88ff, 0xc13d,		0x21, 0
	.dw 0x8940, 0xc13d,	0x897f, 0xc13d,		0x21, 0
	.dw 0x89c0, 0xc13d,	0x89ff, 0xc13d,		0x21, 0
	.dw 0x8a40, 0xc13d,	0x8a7f, 0xc13d,		0x21, 0
	.dw 0x8ac0, 0xc13d,	0x8aff, 0xc13d,		0x21, 0
	.dw 0x8b40, 0xc13d,	0x8b7f, 0xc13d,		0x21, 0
	.dw 0x8bc0, 0xc13d,	0x8bff, 0xc13d,		0x21, 0
	.dw 0x8c40, 0xc13d,	0x8c7f, 0xc13d,		0x21, 0
	.dw 0x8cc0, 0xc13d,	0x8cff, 0xc13d,		0x21, 0
	.dw 0x8d40, 0xc13d,	0x8d7f, 0xc13d,		0x21, 0
	.dw 0x8dc0, 0xc13d,	0x8dff, 0xc13d,		0x21, 0
	.dw 0x8e40, 0xc13d,	0x8e7f, 0xc13d,		0x21, 0
	.dw 0x8ec0, 0xc13d,	0x8eff, 0xc13d,		0x21, 0
	.dw 0x8f40, 0xc13d,	0x8f7f, 0xc13d,		0x21, 0
	.dw 0x8fc0, 0xc13d,	0x8fff, 0xc13d,		0x21, 0
	.dw 0x9040, 0xc13d,	0x907f, 0xc13d,		0x21, 0
	.dw 0x90c0, 0xc13d,	0x90ff, 0xc13d,		0x21, 0
	.dw 0x9140, 0xc13d,	0x917f, 0xc13d,		0x21, 0
	.dw 0x91c0, 0xc13d,	0x91ff, 0xc13d,		0x21, 0
	.dw 0x9240, 0xc13d,	0x927f, 0xc13d,		0x21, 0
	.dw 0x92c0, 0xc13d,	0x92ff, 0xc13d,		0x21, 0
	.dw 0x9340, 0xc13d,	0x937f, 0xc13d,		0x21, 0
	.dw 0x93c0, 0xc13d,	0x93ff, 0xc13d,		0x21, 0
	.dw 0x9440, 0xc13d,	0x947f, 0xc13d,		0x21, 0
	.dw 0x94c0, 0xc13d,	0x94ff, 0xc13d,		0x21, 0
	.dw 0x9540, 0xc13d,	0x957f, 0xc13d,		0x21, 0
	.dw 0x95c0, 0xc13d,	0x95ff, 0xc13d,		0x21, 0
	.dw 0x9640, 0xc13d,	0x967f, 0xc13d,		0x21, 0
	.dw 0x96c0, 0xc13d,	0x96ff, 0xc13d,		0x21, 0
	.dw 0x9740, 0xc13d,	0x977f, 0xc13d,		0x21, 0
	.dw 0x97c0, 0xc13d,	0x97ff, 0xc13d,		0x21, 0
	.dw 0x9840, 0xc13d,	0x987f, 0xc13d,		0x21, 0
	.dw 0x98c0, 0xc13d,	0x98ff, 0xc13d,		0x21, 0
	.dw 0x9940, 0xc13d,	0x997f, 0xc13d,		0x21, 0
	.dw 0x99c0, 0xc13d,	0x9fff, 0xc13d,		0x21, 0
	.dw 0xa040, 0xc13d,	0xa07f, 0xc13d,		0x21, 0
	.dw 0xa0c0, 0xc13d,	0xa0ff, 0xc13d,		0x21, 0
	.dw 0xa140, 0xc13d,	0xa17f, 0xc13d,		0x21, 0
	.dw 0xa1c0, 0xc13d,	0xa1ff, 0xc13d,		0x21, 0
	.dw 0xa240, 0xc13d,	0xa27f, 0xc13d,		0x21, 0
	.dw 0xa2c0, 0xc13d,	0xa2ff, 0xc13d,		0x21, 0
	.dw 0xa340, 0xc13d,	0xa37f, 0xc13d,		0x21, 0
	.dw 0xa3c0, 0xc13d,	0xa3ff, 0xc13d,		0x21, 0
	.dw 0xa440, 0xc13d,	0xa47f, 0xc13d,		0x21, 0
	.dw 0xa4c0, 0xc13d,	0xa4ff, 0xc13d,		0x21, 0
	.dw 0xa540, 0xc13d,	0xa57f, 0xc13d,		0x21, 0
	.dw 0xa5c0, 0xc13d,	0xa5ff, 0xc13d,		0x21, 0
	.dw 0xa640, 0xc13d,	0xa67f, 0xc13d,		0x21, 0
	.dw 0xa6c0, 0xc13d,	0xa6ff, 0xc13d,		0x21, 0
	.dw 0xa740, 0xc13d,	0xa77f, 0xc13d,		0x21, 0
	.dw 0xa7c0, 0xc13d,	0xa7ff, 0xc13d,		0x21, 0
	.dw 0xa840, 0xc13d,	0xa87f, 0xc13d,		0x21, 0
	.dw 0xa8c0, 0xc13d,	0xa8ff, 0xc13d,		0x21, 0
	.dw 0xa940, 0xc13d,	0xa97f, 0xc13d,		0x21, 0
	.dw 0xa9c0, 0xc13d,	0xa9ff, 0xc13d,		0x21, 0
	.dw 0xaa40, 0xc13d,	0xaa7f, 0xc13d,		0x21, 0
	.dw 0xaac0, 0xc13d,	0xaaff, 0xc13d,		0x21, 0
	.dw 0xab40, 0xc13d,	0xab7f, 0xc13d,		0x21, 0
	.dw 0xabc0, 0xc13d,	0xabff, 0xc13d,		0x21, 0
	.dw 0xac40, 0xc13d,	0xac7f, 0xc13d,		0x21, 0
	.dw 0xacc0, 0xc13d,	0xacff, 0xc13d,		0x21, 0
	.dw 0xad40, 0xc13d,	0xad7f, 0xc13d,		0x21, 0
	.dw 0xadc0, 0xc13d,	0xadff, 0xc13d,		0x21, 0
	.dw 0xae40, 0xc13d,	0xae7f, 0xc13d,		0x21, 0
	.dw 0xaec0, 0xc13d,	0xaeff, 0xc13d,		0x21, 0
	.dw 0xaf40, 0xc13d,	0xaf7f, 0xc13d,		0x21, 0
	.dw 0xafc0, 0xc13d,	0xafff, 0xc13d,		0x21, 0
	.dw 0xb040, 0xc13d,	0xb07f, 0xc13d,		0x21, 0
	.dw 0xb0c0, 0xc13d,	0xb0ff, 0xc13d,		0x21, 0
	.dw 0xb140, 0xc13d,	0xb17f, 0xc13d,		0x21, 0
	.dw 0xb1c0, 0xc13d,	0xb1ff, 0xc13d,		0x21, 0
	.dw 0xb240, 0xc13d,	0xb27f, 0xc13d,		0x21, 0
	.dw 0xb2c0, 0xc13d,	0xb2ff, 0xc13d,		0x21, 0
	.dw 0xb340, 0xc13d,	0xb37f, 0xc13d,		0x21, 0
	.dw 0xb3c0, 0xc13d,	0xb3ff, 0xc13d,		0x21, 0
	.dw 0xb440, 0xc13d,	0xb47f, 0xc13d,		0x21, 0
	.dw 0xb4c0, 0xc13d,	0xb4ff, 0xc13d,		0x21, 0
	.dw 0xb540, 0xc13d,	0xb57f, 0xc13d,		0x21, 0
	.dw 0xb5c0, 0xc13d,	0xb5ff, 0xc13d,		0x21, 0
	.dw 0xb640, 0xc13d,	0xb67f, 0xc13d,		0x21, 0
	.dw 0xb6c0, 0xc13d,	0xb6ff, 0xc13d,		0x21, 0
	.dw 0xb740, 0xc13d,	0xb77f, 0xc13d,		0x21, 0
	.dw 0xb7c0, 0xc13d,	0xb7ff, 0xc13d,		0x21, 0
	.dw 0xb840, 0xc13d,	0xb87f, 0xc13d,		0x21, 0
	.dw 0xb8c0, 0xc13d,	0xb8ff, 0xc13d,		0x21, 0
	.dw 0xb940, 0xc13d,	0xb97f, 0xc13d,		0x21, 0
	.dw 0xb9c0, 0xc13d,	0xbfff, 0xc13d,		0x21, 0
	.dw 0xc040, 0xc13d,	0xc07f, 0xc13d,		0x21, 0
	.dw 0xc0c0, 0xc13d,	0xc0ff, 0xc13d,		0x21, 0
	.dw 0xc140, 0xc13d,	0xc17f, 0xc13d,		0x21, 0
	.dw 0xc1c0, 0xc13d,	0xc1ff, 0xc13d,		0x21, 0
	.dw 0xc240, 0xc13d,	0xc27f, 0xc13d,		0x21, 0
	.dw 0xc2c0, 0xc13d,	0xc2ff, 0xc13d,		0x21, 0
	.dw 0xc340, 0xc13d,	0xc37f, 0xc13d,		0x21, 0
	.dw 0xc3c0, 0xc13d,	0xc3ff, 0xc13d,		0x21, 0
	.dw 0xc440, 0xc13d,	0xc47f, 0xc13d,		0x21, 0
	.dw 0xc4c0, 0xc13d,	0xc4ff, 0xc13d,		0x21, 0
	.dw 0xc540, 0xc13d,	0xc57f, 0xc13d,		0x21, 0
	.dw 0xc5c0, 0xc13d,	0xc5ff, 0xc13d,		0x21, 0
	.dw 0xc640, 0xc13d,	0xc67f, 0xc13d,		0x21, 0
	.dw 0xc6c0, 0xc13d,	0xc6ff, 0xc13d,		0x21, 0
	.dw 0xc740, 0xc13d,	0xc77f, 0xc13d,		0x21, 0
	.dw 0xc7c0, 0xc13d,	0xc7ff, 0xc13d,		0x21, 0
	.dw 0xc840, 0xc13d,	0xc87f, 0xc13d,		0x21, 0
	.dw 0xc8c0, 0xc13d,	0xc8ff, 0xc13d,		0x21, 0
	.dw 0xc940, 0xc13d,	0xc97f, 0xc13d,		0x21, 0
	.dw 0xc9c0, 0xc13d,	0xc9ff, 0xc13d,		0x21, 0
	.dw 0xca40, 0xc13d,	0xca7f, 0xc13d,		0x21, 0
	.dw 0xcac0, 0xc13d,	0xcaff, 0xc13d,		0x21, 0
	.dw 0xcb40, 0xc13d,	0xcb7f, 0xc13d,		0x21, 0
	.dw 0xcbc0, 0xc13d,	0xcbff, 0xc13d,		0x21, 0
	.dw 0xcc40, 0xc13d,	0xcc7f, 0xc13d,		0x21, 0
	.dw 0xccc0, 0xc13d,	0xccff, 0xc13d,		0x21, 0
	.dw 0xcd40, 0xc13d,	0xcd7f, 0xc13d,		0x21, 0
	.dw 0xcdc0, 0xc13d,	0xcdff, 0xc13d,		0x21, 0
	.dw 0xce40, 0xc13d,	0xce7f, 0xc13d,		0x21, 0
	.dw 0xcec0, 0xc13d,	0xceff, 0xc13d,		0x21, 0
	.dw 0xcf40, 0xc13d,	0xcf7f, 0xc13d,		0x21, 0
	.dw 0xcfc0, 0xc13d,	0xcfff, 0xc13d,		0x21, 0
	.dw 0xd040, 0xc13d,	0xd07f, 0xc13d,		0x21, 0
	.dw 0xd0c0, 0xc13d,	0xd0ff, 0xc13d,		0x21, 0
	.dw 0xd140, 0xc13d,	0xd17f, 0xc13d,		0x21, 0
	.dw 0xd1c0, 0xc13d,	0xd1ff, 0xc13d,		0x21, 0
	.dw 0xd240, 0xc13d,	0xd27f, 0xc13d,		0x21, 0
	.dw 0xd2c0, 0xc13d,	0xd2ff, 0xc13d,		0x21, 0
	.dw 0xd340, 0xc13d,	0xd37f, 0xc13d,		0x21, 0
	.dw 0xd3c0, 0xc13d,	0xd3ff, 0xc13d,		0x21, 0
	.dw 0xd440, 0xc13d,	0xd47f, 0xc13d,		0x21, 0
	.dw 0xd4c0, 0xc13d,	0xd4ff, 0xc13d,		0x21, 0
	.dw 0xd540, 0xc13d,	0xd57f, 0xc13d,		0x21, 0
	.dw 0xd5c0, 0xc13d,	0xd5ff, 0xc13d,		0x21, 0
	.dw 0xd640, 0xc13d,	0xd67f, 0xc13d,		0x21, 0
	.dw 0xd6c0, 0xc13d,	0xd6ff, 0xc13d,		0x21, 0
	.dw 0xd740, 0xc13d,	0xd77f, 0xc13d,		0x21, 0
	.dw 0xd7c0, 0xc13d,	0xd7ff, 0xc13d,		0x21, 0
	.dw 0xd840, 0xc13d,	0xd87f, 0xc13d,		0x21, 0
	.dw 0xd8c0, 0xc13d,	0xd8ff, 0xc13d,		0x21, 0
	.dw 0xd940, 0xc13d,	0xd97f, 0xc13d,		0x21, 0
	.dw 0xd9c0, 0xc13d,	0xdfff, 0xc13d,		0x21, 0
	.dw 0xe040, 0xc13d,	0xe07f, 0xc13d,		0x21, 0
	.dw 0xe0c0, 0xc13d,	0xe0ff, 0xc13d,		0x21, 0
	.dw 0xe140, 0xc13d,	0xe17f, 0xc13d,		0x21, 0
	.dw 0xe1c0, 0xc13d,	0xe1ff, 0xc13d,		0x21, 0
	.dw 0xe240, 0xc13d,	0xe27f, 0xc13d,		0x21, 0
	.dw 0xe2c0, 0xc13d,	0xe2ff, 0xc13d,		0x21, 0
	.dw 0xe340, 0xc13d,	0xe37f, 0xc13d,		0x21, 0
	.dw 0xe3c0, 0xc13d,	0xe3ff, 0xc13d,		0x21, 0
	.dw 0xe440, 0xc13d,	0xe47f, 0xc13d,		0x21, 0
	.dw 0xe4c0, 0xc13d,	0xe4ff, 0xc13d,		0x21, 0
	.dw 0xe540, 0xc13d,	0xe57f, 0xc13d,		0x21, 0
	.dw 0xe5c0, 0xc13d,	0xe5ff, 0xc13d,		0x21, 0
	.dw 0xe640, 0xc13d,	0xe67f, 0xc13d,		0x21, 0
	.dw 0xe6c0, 0xc13d,	0xe6ff, 0xc13d,		0x21, 0
	.dw 0xe740, 0xc13d,	0xe77f, 0xc13d,		0x21, 0
	.dw 0xe7c0, 0xc13d,	0xe7ff, 0xc13d,		0x21, 0
	.dw 0xe840, 0xc13d,	0xe87f, 0xc13d,		0x21, 0
	.dw 0xe8c0, 0xc13d,	0xe8ff, 0xc13d,		0x21, 0
	.dw 0xe940, 0xc13d,	0xe97f, 0xc13d,		0x21, 0
	.dw 0xe9c0, 0xc13d,	0xe9ff, 0xc13d,		0x21, 0
	.dw 0xea40, 0xc13d,	0xea7f, 0xc13d,		0x21, 0
	.dw 0xeac0, 0xc13d,	0xeaff, 0xc13d,		0x21, 0
	.dw 0xeb40, 0xc13d,	0xeb7f, 0xc13d,		0x21, 0
	.dw 0xebc0, 0xc13d,	0xebff, 0xc13d,		0x21, 0
	.dw 0xec40, 0xc13d,	0xec7f, 0xc13d,		0x21, 0
	.dw 0xecc0, 0xc13d,	0xecff, 0xc13d,		0x21, 0
	.dw 0xed40, 0xc13d,	0xed7f, 0xc13d,		0x21, 0
	.dw 0xedc0, 0xc13d,	0xedff, 0xc13d,		0x21, 0
	.dw 0xee40, 0xc13d,	0xee7f, 0xc13d,		0x21, 0
	.dw 0xeec0, 0xc13d,	0xeeff, 0xc13d,		0x21, 0
	.dw 0xef40, 0xc13d,	0xef7f, 0xc13d,		0x21, 0
	.dw 0xefc0, 0xc13d,	0xefff, 0xc13d,		0x21, 0
	.dw 0xf040, 0xc13d,	0xf07f, 0xc13d,		0x21, 0
	.dw 0xf0c0, 0xc13d,	0xf0ff, 0xc13d,		0x21, 0
	.dw 0xf140, 0xc13d,	0xf17f, 0xc13d,		0x21, 0
	.dw 0xf1c0, 0xc13d,	0xf1ff, 0xc13d,		0x21, 0
	.dw 0xf240, 0xc13d,	0xf27f, 0xc13d,		0x21, 0
	.dw 0xf2c0, 0xc13d,	0xf2ff, 0xc13d,		0x21, 0
	.dw 0xf340, 0xc13d,	0xf37f, 0xc13d,		0x21, 0
	.dw 0xf3c0, 0xc13d,	0xf3ff, 0xc13d,		0x21, 0
	.dw 0xf440, 0xc13d,	0xf47f, 0xc13d,		0x21, 0
	.dw 0xf4c0, 0xc13d,	0xf4ff, 0xc13d,		0x21, 0
	.dw 0xf540, 0xc13d,	0xf57f, 0xc13d,		0x21, 0
	.dw 0xf5c0, 0xc13d,	0xf5ff, 0xc13d,		0x21, 0
	.dw 0xf640, 0xc13d,	0xf67f, 0xc13d,		0x21, 0
	.dw 0xf6c0, 0xc13d,	0xf6ff, 0xc13d,		0x21, 0
	.dw 0xf740, 0xc13d,	0xf77f, 0xc13d,		0x21, 0
	.dw 0xf7c0, 0xc13d,	0xf7ff, 0xc13d,		0x21, 0
	.dw 0xf840, 0xc13d,	0xf87f, 0xc13d,		0x21, 0
	.dw 0xf8c0, 0xc13d,	0xf8ff, 0xc13d,		0x21, 0
	.dw 0xf940, 0xc13d,	0xf97f, 0xc13d,		0x21, 0
	.dw 0xf9c0, 0xc13d,	0xffff, 0xc13d,		0x21, 0
	.dw 0x0040, 0xc13e,	0x007f, 0xc13e,		0x21, 0
	.dw 0x00c0, 0xc13e,	0x00ff, 0xc13e,		0x21, 0
	.dw 0x0140, 0xc13e,	0x017f, 0xc13e,		0x21, 0
	.dw 0x01c0, 0xc13e,	0x01ff, 0xc13e,		0x21, 0
	.dw 0x0240, 0xc13e,	0x027f, 0xc13e,		0x21, 0
	.dw 0x02c0, 0xc13e,	0x02ff, 0xc13e,		0x21, 0
	.dw 0x0340, 0xc13e,	0x037f, 0xc13e,		0x21, 0
	.dw 0x03c0, 0xc13e,	0x03ff, 0xc13e,		0x21, 0
	.dw 0x0440, 0xc13e,	0x047f, 0xc13e,		0x21, 0
	.dw 0x04c0, 0xc13e,	0x04ff, 0xc13e,		0x21, 0
	.dw 0x0540, 0xc13e,	0x057f, 0xc13e,		0x21, 0
	.dw 0x05c0, 0xc13e,	0x05ff, 0xc13e,		0x21, 0
	.dw 0x0640, 0xc13e,	0x067f, 0xc13e,		0x21, 0
	.dw 0x06c0, 0xc13e,	0x06ff, 0xc13e,		0x21, 0
	.dw 0x0740, 0xc13e,	0x077f, 0xc13e,		0x21, 0
	.dw 0x07c0, 0xc13e,	0x07ff, 0xc13e,		0x21, 0
	.dw 0x0840, 0xc13e,	0x087f, 0xc13e,		0x21, 0
	.dw 0x08c0, 0xc13e,	0x08ff, 0xc13e,		0x21, 0
	.dw 0x0940, 0xc13e,	0x097f, 0xc13e,		0x21, 0
	.dw 0x09c0, 0xc13e,	0x09ff, 0xc13e,		0x21, 0
	.dw 0x0a40, 0xc13e,	0x0a7f, 0xc13e,		0x21, 0
	.dw 0x0ac0, 0xc13e,	0x0aff, 0xc13e,		0x21, 0
	.dw 0x0b40, 0xc13e,	0x0b7f, 0xc13e,		0x21, 0
	.dw 0x0bc0, 0xc13e,	0x0bff, 0xc13e,		0x21, 0
	.dw 0x0c40, 0xc13e,	0x0c7f, 0xc13e,		0x21, 0
	.dw 0x0cc0, 0xc13e,	0x0cff, 0xc13e,		0x21, 0
	.dw 0x0d40, 0xc13e,	0x0d7f, 0xc13e,		0x21, 0
	.dw 0x0dc0, 0xc13e,	0x0dff, 0xc13e,		0x21, 0
	.dw 0x0e40, 0xc13e,	0x0e7f, 0xc13e,		0x21, 0
	.dw 0x0ec0, 0xc13e,	0x0eff, 0xc13e,		0x21, 0
	.dw 0x0f40, 0xc13e,	0x0f7f, 0xc13e,		0x21, 0
	.dw 0x0fc0, 0xc13e,	0x0fff, 0xc13e,		0x21, 0
	.dw 0x1040, 0xc13e,	0x107f, 0xc13e,		0x21, 0
	.dw 0x10c0, 0xc13e,	0x10ff, 0xc13e,		0x21, 0
	.dw 0x1140, 0xc13e,	0x117f, 0xc13e,		0x21, 0
	.dw 0x11c0, 0xc13e,	0x11ff, 0xc13e,		0x21, 0
	.dw 0x1240, 0xc13e,	0x127f, 0xc13e,		0x21, 0
	.dw 0x12c0, 0xc13e,	0x12ff, 0xc13e,		0x21, 0
	.dw 0x1340, 0xc13e,	0x137f, 0xc13e,		0x21, 0
	.dw 0x13c0, 0xc13e,	0x13ff, 0xc13e,		0x21, 0
	.dw 0x1440, 0xc13e,	0x147f, 0xc13e,		0x21, 0
	.dw 0x14c0, 0xc13e,	0x14ff, 0xc13e,		0x21, 0
	.dw 0x1540, 0xc13e,	0x157f, 0xc13e,		0x21, 0
	.dw 0x15c0, 0xc13e,	0x15ff, 0xc13e,		0x21, 0
	.dw 0x1640, 0xc13e,	0x167f, 0xc13e,		0x21, 0
	.dw 0x16c0, 0xc13e,	0x16ff, 0xc13e,		0x21, 0
	.dw 0x1740, 0xc13e,	0x177f, 0xc13e,		0x21, 0
	.dw 0x17c0, 0xc13e,	0x17ff, 0xc13e,		0x21, 0
	.dw 0x1840, 0xc13e,	0x187f, 0xc13e,		0x21, 0
	.dw 0x18c0, 0xc13e,	0x18ff, 0xc13e,		0x21, 0
	.dw 0x1940, 0xc13e,	0x197f, 0xc13e,		0x21, 0
	.dw 0x19c0, 0xc13e,	0x1fff, 0xc13e,		0x21, 0
	.dw 0x2040, 0xc13e,	0x207f, 0xc13e,		0x21, 0
	.dw 0x20c0, 0xc13e,	0x20ff, 0xc13e,		0x21, 0
	.dw 0x2140, 0xc13e,	0x217f, 0xc13e,		0x21, 0
	.dw 0x21c0, 0xc13e,	0x21ff, 0xc13e,		0x21, 0
	.dw 0x2240, 0xc13e,	0x227f, 0xc13e,		0x21, 0
	.dw 0x22c0, 0xc13e,	0x22ff, 0xc13e,		0x21, 0
	.dw 0x2340, 0xc13e,	0x237f, 0xc13e,		0x21, 0
	.dw 0x23c0, 0xc13e,	0x23ff, 0xc13e,		0x21, 0
	.dw 0x2440, 0xc13e,	0x247f, 0xc13e,		0x21, 0
	.dw 0x24c0, 0xc13e,	0x24ff, 0xc13e,		0x21, 0
	.dw 0x2540, 0xc13e,	0x257f, 0xc13e,		0x21, 0
	.dw 0x25c0, 0xc13e,	0x25ff, 0xc13e,		0x21, 0
	.dw 0x2640, 0xc13e,	0x267f, 0xc13e,		0x21, 0
	.dw 0x26c0, 0xc13e,	0x26ff, 0xc13e,		0x21, 0
	.dw 0x2740, 0xc13e,	0x277f, 0xc13e,		0x21, 0
	.dw 0x27c0, 0xc13e,	0x27ff, 0xc13e,		0x21, 0
	.dw 0x2840, 0xc13e,	0x287f, 0xc13e,		0x21, 0
	.dw 0x28c0, 0xc13e,	0x28ff, 0xc13e,		0x21, 0
	.dw 0x2940, 0xc13e,	0x297f, 0xc13e,		0x21, 0
	.dw 0x29c0, 0xc13e,	0x29ff, 0xc13e,		0x21, 0
	.dw 0x2a40, 0xc13e,	0x2a7f, 0xc13e,		0x21, 0
	.dw 0x2ac0, 0xc13e,	0x2aff, 0xc13e,		0x21, 0
	.dw 0x2b40, 0xc13e,	0x2b7f, 0xc13e,		0x21, 0
	.dw 0x2bc0, 0xc13e,	0x2bff, 0xc13e,		0x21, 0
	.dw 0x2c40, 0xc13e,	0x2c7f, 0xc13e,		0x21, 0
	.dw 0x2cc0, 0xc13e,	0x2cff, 0xc13e,		0x21, 0
	.dw 0x2d40, 0xc13e,	0x2d7f, 0xc13e,		0x21, 0
	.dw 0x2dc0, 0xc13e,	0x2dff, 0xc13e,		0x21, 0
	.dw 0x2e40, 0xc13e,	0x2e7f, 0xc13e,		0x21, 0
	.dw 0x2ec0, 0xc13e,	0x2eff, 0xc13e,		0x21, 0
	.dw 0x2f40, 0xc13e,	0x2f7f, 0xc13e,		0x21, 0
	.dw 0x2fc0, 0xc13e,	0x2fff, 0xc13e,		0x21, 0
	.dw 0x3040, 0xc13e,	0x307f, 0xc13e,		0x21, 0
	.dw 0x30c0, 0xc13e,	0x30ff, 0xc13e,		0x21, 0
	.dw 0x3140, 0xc13e,	0x317f, 0xc13e,		0x21, 0
	.dw 0x31c0, 0xc13e,	0x31ff, 0xc13e,		0x21, 0
	.dw 0x3240, 0xc13e,	0x327f, 0xc13e,		0x21, 0
	.dw 0x32c0, 0xc13e,	0x32ff, 0xc13e,		0x21, 0
	.dw 0x3340, 0xc13e,	0x337f, 0xc13e,		0x21, 0
	.dw 0x33c0, 0xc13e,	0x33ff, 0xc13e,		0x21, 0
	.dw 0x3440, 0xc13e,	0x347f, 0xc13e,		0x21, 0
	.dw 0x34c0, 0xc13e,	0x34ff, 0xc13e,		0x21, 0
	.dw 0x3540, 0xc13e,	0x357f, 0xc13e,		0x21, 0
	.dw 0x35c0, 0xc13e,	0x35ff, 0xc13e,		0x21, 0
	.dw 0x3640, 0xc13e,	0x367f, 0xc13e,		0x21, 0
	.dw 0x36c0, 0xc13e,	0x36ff, 0xc13e,		0x21, 0
	.dw 0x3740, 0xc13e,	0x377f, 0xc13e,		0x21, 0
	.dw 0x37c0, 0xc13e,	0x37ff, 0xc13e,		0x21, 0
	.dw 0x3840, 0xc13e,	0x387f, 0xc13e,		0x21, 0
	.dw 0x38c0, 0xc13e,	0x38ff, 0xc13e,		0x21, 0
	.dw 0x3940, 0xc13e,	0x397f, 0xc13e,		0x21, 0
	.dw 0x39c0, 0xc13e,	0x3fff, 0xc13e,		0x21, 0
	.dw 0x4040, 0xc13e,	0x407f, 0xc13e,		0x21, 0
	.dw 0x40c0, 0xc13e,	0x40ff, 0xc13e,		0x21, 0
	.dw 0x4140, 0xc13e,	0x417f, 0xc13e,		0x21, 0
	.dw 0x41c0, 0xc13e,	0x41ff, 0xc13e,		0x21, 0
	.dw 0x4240, 0xc13e,	0x427f, 0xc13e,		0x21, 0
	.dw 0x42c0, 0xc13e,	0x42ff, 0xc13e,		0x21, 0
	.dw 0x4340, 0xc13e,	0x437f, 0xc13e,		0x21, 0
	.dw 0x43c0, 0xc13e,	0x43ff, 0xc13e,		0x21, 0
	.dw 0x4440, 0xc13e,	0x447f, 0xc13e,		0x21, 0
	.dw 0x44c0, 0xc13e,	0x44ff, 0xc13e,		0x21, 0
	.dw 0x4540, 0xc13e,	0x457f, 0xc13e,		0x21, 0
	.dw 0x45c0, 0xc13e,	0x45ff, 0xc13e,		0x21, 0
	.dw 0x4640, 0xc13e,	0x467f, 0xc13e,		0x21, 0
	.dw 0x46c0, 0xc13e,	0x46ff, 0xc13e,		0x21, 0
	.dw 0x4740, 0xc13e,	0x477f, 0xc13e,		0x21, 0
	.dw 0x47c0, 0xc13e,	0x47ff, 0xc13e,		0x21, 0
	.dw 0x4840, 0xc13e,	0x487f, 0xc13e,		0x21, 0
	.dw 0x48c0, 0xc13e,	0x48ff, 0xc13e,		0x21, 0
	.dw 0x4940, 0xc13e,	0x497f, 0xc13e,		0x21, 0
	.dw 0x49c0, 0xc13e,	0x49ff, 0xc13e,		0x21, 0
	.dw 0x4a40, 0xc13e,	0x4a7f, 0xc13e,		0x21, 0
	.dw 0x4ac0, 0xc13e,	0x4aff, 0xc13e,		0x21, 0
	.dw 0x4b40, 0xc13e,	0x4b7f, 0xc13e,		0x21, 0
	.dw 0x4bc0, 0xc13e,	0x4bff, 0xc13e,		0x21, 0
	.dw 0x4c40, 0xc13e,	0x4c7f, 0xc13e,		0x21, 0
	.dw 0x4cc0, 0xc13e,	0x4cff, 0xc13e,		0x21, 0
	.dw 0x4d40, 0xc13e,	0x4d7f, 0xc13e,		0x21, 0
	.dw 0x4dc0, 0xc13e,	0x4dff, 0xc13e,		0x21, 0
	.dw 0x4e40, 0xc13e,	0x4e7f, 0xc13e,		0x21, 0
	.dw 0x4ec0, 0xc13e,	0x4eff, 0xc13e,		0x21, 0
	.dw 0x4f40, 0xc13e,	0x4f7f, 0xc13e,		0x21, 0
	.dw 0x4fc0, 0xc13e,	0x4fff, 0xc13e,		0x21, 0
	.dw 0x5040, 0xc13e,	0x507f, 0xc13e,		0x21, 0
	.dw 0x50c0, 0xc13e,	0x50ff, 0xc13e,		0x21, 0
	.dw 0x5140, 0xc13e,	0x517f, 0xc13e,		0x21, 0
	.dw 0x51c0, 0xc13e,	0x51ff, 0xc13e,		0x21, 0
	.dw 0x5240, 0xc13e,	0x527f, 0xc13e,		0x21, 0
	.dw 0x52c0, 0xc13e,	0x52ff, 0xc13e,		0x21, 0
	.dw 0x5340, 0xc13e,	0x537f, 0xc13e,		0x21, 0
	.dw 0x53c0, 0xc13e,	0x53ff, 0xc13e,		0x21, 0
	.dw 0x5440, 0xc13e,	0x547f, 0xc13e,		0x21, 0
	.dw 0x54c0, 0xc13e,	0x54ff, 0xc13e,		0x21, 0
	.dw 0x5540, 0xc13e,	0x557f, 0xc13e,		0x21, 0
	.dw 0x55c0, 0xc13e,	0x55ff, 0xc13e,		0x21, 0
	.dw 0x5640, 0xc13e,	0x567f, 0xc13e,		0x21, 0
	.dw 0x56c0, 0xc13e,	0x56ff, 0xc13e,		0x21, 0
	.dw 0x5740, 0xc13e,	0x577f, 0xc13e,		0x21, 0
	.dw 0x57c0, 0xc13e,	0x57ff, 0xc13e,		0x21, 0
	.dw 0x5840, 0xc13e,	0x587f, 0xc13e,		0x21, 0
	.dw 0x58c0, 0xc13e,	0x58ff, 0xc13e,		0x21, 0
	.dw 0x5940, 0xc13e,	0x597f, 0xc13e,		0x21, 0
	.dw 0x59c0, 0xc13e,	0x5fff, 0xc13e,		0x21, 0
	.dw 0x6040, 0xc13e,	0x607f, 0xc13e,		0x21, 0
	.dw 0x60c0, 0xc13e,	0x60ff, 0xc13e,		0x21, 0
	.dw 0x6140, 0xc13e,	0x617f, 0xc13e,		0x21, 0
	.dw 0x61c0, 0xc13e,	0x61ff, 0xc13e,		0x21, 0
	.dw 0x6240, 0xc13e,	0x627f, 0xc13e,		0x21, 0
	.dw 0x62c0, 0xc13e,	0x62ff, 0xc13e,		0x21, 0
	.dw 0x6340, 0xc13e,	0x637f, 0xc13e,		0x21, 0
	.dw 0x63c0, 0xc13e,	0x63ff, 0xc13e,		0x21, 0
	.dw 0x6440, 0xc13e,	0x647f, 0xc13e,		0x21, 0
	.dw 0x64c0, 0xc13e,	0x64ff, 0xc13e,		0x21, 0
	.dw 0x6540, 0xc13e,	0x657f, 0xc13e,		0x21, 0
	.dw 0x65c0, 0xc13e,	0x65ff, 0xc13e,		0x21, 0
	.dw 0x6640, 0xc13e,	0x667f, 0xc13e,		0x21, 0
	.dw 0x66c0, 0xc13e,	0x66ff, 0xc13e,		0x21, 0
	.dw 0x6740, 0xc13e,	0x677f, 0xc13e,		0x21, 0
	.dw 0x67c0, 0xc13e,	0x67ff, 0xc13e,		0x21, 0
	.dw 0x6840, 0xc13e,	0x687f, 0xc13e,		0x21, 0
	.dw 0x68c0, 0xc13e,	0x68ff, 0xc13e,		0x21, 0
	.dw 0x6940, 0xc13e,	0x697f, 0xc13e,		0x21, 0
	.dw 0x69c0, 0xc13e,	0x69ff, 0xc13e,		0x21, 0
	.dw 0x6a40, 0xc13e,	0x6a7f, 0xc13e,		0x21, 0
	.dw 0x6ac0, 0xc13e,	0x6aff, 0xc13e,		0x21, 0
	.dw 0x6b40, 0xc13e,	0x6b7f, 0xc13e,		0x21, 0
	.dw 0x6bc0, 0xc13e,	0x6bff, 0xc13e,		0x21, 0
	.dw 0x6c40, 0xc13e,	0x6c7f, 0xc13e,		0x21, 0
	.dw 0x6cc0, 0xc13e,	0x6cff, 0xc13e,		0x21, 0
	.dw 0x6d40, 0xc13e,	0x6d7f, 0xc13e,		0x21, 0
	.dw 0x6dc0, 0xc13e,	0x6dff, 0xc13e,		0x21, 0
	.dw 0x6e40, 0xc13e,	0x6e7f, 0xc13e,		0x21, 0
	.dw 0x6ec0, 0xc13e,	0x6eff, 0xc13e,		0x21, 0
	.dw 0x6f40, 0xc13e,	0x6f7f, 0xc13e,		0x21, 0
	.dw 0x6fc0, 0xc13e,	0x6fff, 0xc13e,		0x21, 0
	.dw 0x7040, 0xc13e,	0x707f, 0xc13e,		0x21, 0
	.dw 0x70c0, 0xc13e,	0x70ff, 0xc13e,		0x21, 0
	.dw 0x7140, 0xc13e,	0x717f, 0xc13e,		0x21, 0
	.dw 0x71c0, 0xc13e,	0x71ff, 0xc13e,		0x21, 0
	.dw 0x7240, 0xc13e,	0x727f, 0xc13e,		0x21, 0
	.dw 0x72c0, 0xc13e,	0x72ff, 0xc13e,		0x21, 0
	.dw 0x7340, 0xc13e,	0x737f, 0xc13e,		0x21, 0
	.dw 0x73c0, 0xc13e,	0x73ff, 0xc13e,		0x21, 0
	.dw 0x7440, 0xc13e,	0x747f, 0xc13e,		0x21, 0
	.dw 0x74c0, 0xc13e,	0x74ff, 0xc13e,		0x21, 0
	.dw 0x7540, 0xc13e,	0x757f, 0xc13e,		0x21, 0
	.dw 0x75c0, 0xc13e,	0x75ff, 0xc13e,		0x21, 0
	.dw 0x7640, 0xc13e,	0x767f, 0xc13e,		0x21, 0
	.dw 0x76c0, 0xc13e,	0x76ff, 0xc13e,		0x21, 0
	.dw 0x7740, 0xc13e,	0x777f, 0xc13e,		0x21, 0
	.dw 0x77c0, 0xc13e,	0x77ff, 0xc13e,		0x21, 0
	.dw 0x7840, 0xc13e,	0x787f, 0xc13e,		0x21, 0
	.dw 0x78c0, 0xc13e,	0x78ff, 0xc13e,		0x21, 0
	.dw 0x7940, 0xc13e,	0x797f, 0xc13e,		0x21, 0
	.dw 0x79c0, 0xc13e,	0x7fff, 0xc13e,		0x21, 0
	.dw 0x8040, 0xc13e,	0x807f, 0xc13e,		0x21, 0
	.dw 0x80c0, 0xc13e,	0x80ff, 0xc13e,		0x21, 0
	.dw 0x8140, 0xc13e,	0x817f, 0xc13e,		0x21, 0
	.dw 0x81c0, 0xc13e,	0x81ff, 0xc13e,		0x21, 0
	.dw 0x8240, 0xc13e,	0x827f, 0xc13e,		0x21, 0
	.dw 0x82c0, 0xc13e,	0x82ff, 0xc13e,		0x21, 0
	.dw 0x8340, 0xc13e,	0x837f, 0xc13e,		0x21, 0
	.dw 0x83c0, 0xc13e,	0x83ff, 0xc13e,		0x21, 0
	.dw 0x8440, 0xc13e,	0x847f, 0xc13e,		0x21, 0
	.dw 0x84c0, 0xc13e,	0x84ff, 0xc13e,		0x21, 0
	.dw 0x8540, 0xc13e,	0x857f, 0xc13e,		0x21, 0
	.dw 0x85c0, 0xc13e,	0x85ff, 0xc13e,		0x21, 0
	.dw 0x8640, 0xc13e,	0x867f, 0xc13e,		0x21, 0
	.dw 0x86c0, 0xc13e,	0x86ff, 0xc13e,		0x21, 0
	.dw 0x8740, 0xc13e,	0x877f, 0xc13e,		0x21, 0
	.dw 0x87c0, 0xc13e,	0x87ff, 0xc13e,		0x21, 0
	.dw 0x8840, 0xc13e,	0x887f, 0xc13e,		0x21, 0
	.dw 0x88c0, 0xc13e,	0x88ff, 0xc13e,		0x21, 0
	.dw 0x8940, 0xc13e,	0x897f, 0xc13e,		0x21, 0
	.dw 0x89c0, 0xc13e,	0x89ff, 0xc13e,		0x21, 0
	.dw 0x8a40, 0xc13e,	0x8a7f, 0xc13e,		0x21, 0
	.dw 0x8ac0, 0xc13e,	0x8aff, 0xc13e,		0x21, 0
	.dw 0x8b40, 0xc13e,	0x8b7f, 0xc13e,		0x21, 0
	.dw 0x8bc0, 0xc13e,	0x8bff, 0xc13e,		0x21, 0
	.dw 0x8c40, 0xc13e,	0x8c7f, 0xc13e,		0x21, 0
	.dw 0x8cc0, 0xc13e,	0x8cff, 0xc13e,		0x21, 0
	.dw 0x8d40, 0xc13e,	0x8d7f, 0xc13e,		0x21, 0
	.dw 0x8dc0, 0xc13e,	0x8dff, 0xc13e,		0x21, 0
	.dw 0x8e40, 0xc13e,	0x8e7f, 0xc13e,		0x21, 0
	.dw 0x8ec0, 0xc13e,	0x8eff, 0xc13e,		0x21, 0
	.dw 0x8f40, 0xc13e,	0x8f7f, 0xc13e,		0x21, 0
	.dw 0x8fc0, 0xc13e,	0x8fff, 0xc13e,		0x21, 0
	.dw 0x9040, 0xc13e,	0x907f, 0xc13e,		0x21, 0
	.dw 0x90c0, 0xc13e,	0x90ff, 0xc13e,		0x21, 0
	.dw 0x9140, 0xc13e,	0x917f, 0xc13e,		0x21, 0
	.dw 0x91c0, 0xc13e,	0x91ff, 0xc13e,		0x21, 0
	.dw 0x9240, 0xc13e,	0x927f, 0xc13e,		0x21, 0
	.dw 0x92c0, 0xc13e,	0x92ff, 0xc13e,		0x21, 0
	.dw 0x9340, 0xc13e,	0x937f, 0xc13e,		0x21, 0
	.dw 0x93c0, 0xc13e,	0x93ff, 0xc13e,		0x21, 0
	.dw 0x9440, 0xc13e,	0x947f, 0xc13e,		0x21, 0
	.dw 0x94c0, 0xc13e,	0x94ff, 0xc13e,		0x21, 0
	.dw 0x9540, 0xc13e,	0x957f, 0xc13e,		0x21, 0
	.dw 0x95c0, 0xc13e,	0x95ff, 0xc13e,		0x21, 0
	.dw 0x9640, 0xc13e,	0x967f, 0xc13e,		0x21, 0
	.dw 0x96c0, 0xc13e,	0x96ff, 0xc13e,		0x21, 0
	.dw 0x9740, 0xc13e,	0x977f, 0xc13e,		0x21, 0
	.dw 0x97c0, 0xc13e,	0x97ff, 0xc13e,		0x21, 0
	.dw 0x9840, 0xc13e,	0x987f, 0xc13e,		0x21, 0
	.dw 0x98c0, 0xc13e,	0x98ff, 0xc13e,		0x21, 0
	.dw 0x9940, 0xc13e,	0x997f, 0xc13e,		0x21, 0
	.dw 0x99c0, 0xc13e,	0x9fff, 0xc13e,		0x21, 0
	.dw 0xa040, 0xc13e,	0xa07f, 0xc13e,		0x21, 0
	.dw 0xa0c0, 0xc13e,	0xa0ff, 0xc13e,		0x21, 0
	.dw 0xa140, 0xc13e,	0xa17f, 0xc13e,		0x21, 0
	.dw 0xa1c0, 0xc13e,	0xa1ff, 0xc13e,		0x21, 0
	.dw 0xa240, 0xc13e,	0xa27f, 0xc13e,		0x21, 0
	.dw 0xa2c0, 0xc13e,	0xa2ff, 0xc13e,		0x21, 0
	.dw 0xa340, 0xc13e,	0xa37f, 0xc13e,		0x21, 0
	.dw 0xa3c0, 0xc13e,	0xa3ff, 0xc13e,		0x21, 0
	.dw 0xa440, 0xc13e,	0xa47f, 0xc13e,		0x21, 0
	.dw 0xa4c0, 0xc13e,	0xa4ff, 0xc13e,		0x21, 0
	.dw 0xa540, 0xc13e,	0xa57f, 0xc13e,		0x21, 0
	.dw 0xa5c0, 0xc13e,	0xa5ff, 0xc13e,		0x21, 0
	.dw 0xa640, 0xc13e,	0xa67f, 0xc13e,		0x21, 0
	.dw 0xa6c0, 0xc13e,	0xa6ff, 0xc13e,		0x21, 0
	.dw 0xa740, 0xc13e,	0xa77f, 0xc13e,		0x21, 0
	.dw 0xa7c0, 0xc13e,	0xa7ff, 0xc13e,		0x21, 0
	.dw 0xa840, 0xc13e,	0xa87f, 0xc13e,		0x21, 0
	.dw 0xa8c0, 0xc13e,	0xa8ff, 0xc13e,		0x21, 0
	.dw 0xa940, 0xc13e,	0xa97f, 0xc13e,		0x21, 0
	.dw 0xa9c0, 0xc13e,	0xa9ff, 0xc13e,		0x21, 0
	.dw 0xaa40, 0xc13e,	0xaa7f, 0xc13e,		0x21, 0
	.dw 0xaac0, 0xc13e,	0xaaff, 0xc13e,		0x21, 0
	.dw 0xab40, 0xc13e,	0xab7f, 0xc13e,		0x21, 0
	.dw 0xabc0, 0xc13e,	0xabff, 0xc13e,		0x21, 0
	.dw 0xac40, 0xc13e,	0xac7f, 0xc13e,		0x21, 0
	.dw 0xacc0, 0xc13e,	0xacff, 0xc13e,		0x21, 0
	.dw 0xad40, 0xc13e,	0xad7f, 0xc13e,		0x21, 0
	.dw 0xadc0, 0xc13e,	0xadff, 0xc13e,		0x21, 0
	.dw 0xae40, 0xc13e,	0xae7f, 0xc13e,		0x21, 0
	.dw 0xaec0, 0xc13e,	0xaeff, 0xc13e,		0x21, 0
	.dw 0xaf40, 0xc13e,	0xaf7f, 0xc13e,		0x21, 0
	.dw 0xafc0, 0xc13e,	0xafff, 0xc13e,		0x21, 0
	.dw 0xb040, 0xc13e,	0xb07f, 0xc13e,		0x21, 0
	.dw 0xb0c0, 0xc13e,	0xb0ff, 0xc13e,		0x21, 0
	.dw 0xb140, 0xc13e,	0xb17f, 0xc13e,		0x21, 0
	.dw 0xb1c0, 0xc13e,	0xb1ff, 0xc13e,		0x21, 0
	.dw 0xb240, 0xc13e,	0xb27f, 0xc13e,		0x21, 0
	.dw 0xb2c0, 0xc13e,	0xb2ff, 0xc13e,		0x21, 0
	.dw 0xb340, 0xc13e,	0xb37f, 0xc13e,		0x21, 0
	.dw 0xb3c0, 0xc13e,	0xb3ff, 0xc13e,		0x21, 0
	.dw 0xb440, 0xc13e,	0xb47f, 0xc13e,		0x21, 0
	.dw 0xb4c0, 0xc13e,	0xb4ff, 0xc13e,		0x21, 0
	.dw 0xb540, 0xc13e,	0xb57f, 0xc13e,		0x21, 0
	.dw 0xb5c0, 0xc13e,	0xb5ff, 0xc13e,		0x21, 0
	.dw 0xb640, 0xc13e,	0xb67f, 0xc13e,		0x21, 0
	.dw 0xb6c0, 0xc13e,	0xb6ff, 0xc13e,		0x21, 0
	.dw 0xb740, 0xc13e,	0xb77f, 0xc13e,		0x21, 0
	.dw 0xb7c0, 0xc13e,	0xb7ff, 0xc13e,		0x21, 0
	.dw 0xb840, 0xc13e,	0xb87f, 0xc13e,		0x21, 0
	.dw 0xb8c0, 0xc13e,	0xb8ff, 0xc13e,		0x21, 0
	.dw 0xb940, 0xc13e,	0xb97f, 0xc13e,		0x21, 0
	.dw 0xb9c0, 0xc13e,	0xbfff, 0xc13e,		0x21, 0
	.dw 0xc040, 0xc13e,	0xc07f, 0xc13e,		0x21, 0
	.dw 0xc0c0, 0xc13e,	0xc0ff, 0xc13e,		0x21, 0
	.dw 0xc140, 0xc13e,	0xc17f, 0xc13e,		0x21, 0
	.dw 0xc1c0, 0xc13e,	0xc1ff, 0xc13e,		0x21, 0
	.dw 0xc240, 0xc13e,	0xc27f, 0xc13e,		0x21, 0
	.dw 0xc2c0, 0xc13e,	0xc2ff, 0xc13e,		0x21, 0
	.dw 0xc340, 0xc13e,	0xc37f, 0xc13e,		0x21, 0
	.dw 0xc3c0, 0xc13e,	0xc3ff, 0xc13e,		0x21, 0
	.dw 0xc440, 0xc13e,	0xc47f, 0xc13e,		0x21, 0
	.dw 0xc4c0, 0xc13e,	0xc4ff, 0xc13e,		0x21, 0
	.dw 0xc540, 0xc13e,	0xc57f, 0xc13e,		0x21, 0
	.dw 0xc5c0, 0xc13e,	0xc5ff, 0xc13e,		0x21, 0
	.dw 0xc640, 0xc13e,	0xc67f, 0xc13e,		0x21, 0
	.dw 0xc6c0, 0xc13e,	0xc6ff, 0xc13e,		0x21, 0
	.dw 0xc740, 0xc13e,	0xc77f, 0xc13e,		0x21, 0
	.dw 0xc7c0, 0xc13e,	0xc7ff, 0xc13e,		0x21, 0
	.dw 0xc840, 0xc13e,	0xc87f, 0xc13e,		0x21, 0
	.dw 0xc8c0, 0xc13e,	0xc8ff, 0xc13e,		0x21, 0
	.dw 0xc940, 0xc13e,	0xc97f, 0xc13e,		0x21, 0
	.dw 0xc9c0, 0xc13e,	0xc9ff, 0xc13e,		0x21, 0
	.dw 0xca40, 0xc13e,	0xca7f, 0xc13e,		0x21, 0
	.dw 0xcac0, 0xc13e,	0xcaff, 0xc13e,		0x21, 0
	.dw 0xcb40, 0xc13e,	0xcb7f, 0xc13e,		0x21, 0
	.dw 0xcbc0, 0xc13e,	0xcbff, 0xc13e,		0x21, 0
	.dw 0xcc40, 0xc13e,	0xcc7f, 0xc13e,		0x21, 0
	.dw 0xccc0, 0xc13e,	0xccff, 0xc13e,		0x21, 0
	.dw 0xcd40, 0xc13e,	0xcd7f, 0xc13e,		0x21, 0
	.dw 0xcdc0, 0xc13e,	0xcdff, 0xc13e,		0x21, 0
	.dw 0xce40, 0xc13e,	0xce7f, 0xc13e,		0x21, 0
	.dw 0xcec0, 0xc13e,	0xceff, 0xc13e,		0x21, 0
	.dw 0xcf40, 0xc13e,	0xcf7f, 0xc13e,		0x21, 0
	.dw 0xcfc0, 0xc13e,	0xcfff, 0xc13e,		0x21, 0
	.dw 0xd040, 0xc13e,	0xd07f, 0xc13e,		0x21, 0
	.dw 0xd0c0, 0xc13e,	0xd0ff, 0xc13e,		0x21, 0
	.dw 0xd140, 0xc13e,	0xd17f, 0xc13e,		0x21, 0
	.dw 0xd1c0, 0xc13e,	0xd1ff, 0xc13e,		0x21, 0
	.dw 0xd240, 0xc13e,	0xd27f, 0xc13e,		0x21, 0
	.dw 0xd2c0, 0xc13e,	0xd2ff, 0xc13e,		0x21, 0
	.dw 0xd340, 0xc13e,	0xd37f, 0xc13e,		0x21, 0
	.dw 0xd3c0, 0xc13e,	0xd3ff, 0xc13e,		0x21, 0
	.dw 0xd440, 0xc13e,	0xd47f, 0xc13e,		0x21, 0
	.dw 0xd4c0, 0xc13e,	0xd4ff, 0xc13e,		0x21, 0
	.dw 0xd540, 0xc13e,	0xd57f, 0xc13e,		0x21, 0
	.dw 0xd5c0, 0xc13e,	0xd5ff, 0xc13e,		0x21, 0
	.dw 0xd640, 0xc13e,	0xd67f, 0xc13e,		0x21, 0
	.dw 0xd6c0, 0xc13e,	0xd6ff, 0xc13e,		0x21, 0
	.dw 0xd740, 0xc13e,	0xd77f, 0xc13e,		0x21, 0
	.dw 0xd7c0, 0xc13e,	0xd7ff, 0xc13e,		0x21, 0
	.dw 0xd840, 0xc13e,	0xd87f, 0xc13e,		0x21, 0
	.dw 0xd8c0, 0xc13e,	0xd8ff, 0xc13e,		0x21, 0
	.dw 0xd940, 0xc13e,	0xd97f, 0xc13e,		0x21, 0
	.dw 0xd9c0, 0xc13e,	0xdfff, 0xc13e,		0x21, 0
	.dw 0xe040, 0xc13e,	0xe07f, 0xc13e,		0x21, 0
	.dw 0xe0c0, 0xc13e,	0xe0ff, 0xc13e,		0x21, 0
	.dw 0xe140, 0xc13e,	0xe17f, 0xc13e,		0x21, 0
	.dw 0xe1c0, 0xc13e,	0xe1ff, 0xc13e,		0x21, 0
	.dw 0xe240, 0xc13e,	0xe27f, 0xc13e,		0x21, 0
	.dw 0xe2c0, 0xc13e,	0xe2ff, 0xc13e,		0x21, 0
	.dw 0xe340, 0xc13e,	0xe37f, 0xc13e,		0x21, 0
	.dw 0xe3c0, 0xc13e,	0xe3ff, 0xc13e,		0x21, 0
	.dw 0xe440, 0xc13e,	0xe47f, 0xc13e,		0x21, 0
	.dw 0xe4c0, 0xc13e,	0xe4ff, 0xc13e,		0x21, 0
	.dw 0xe540, 0xc13e,	0xe57f, 0xc13e,		0x21, 0
	.dw 0xe5c0, 0xc13e,	0xe5ff, 0xc13e,		0x21, 0
	.dw 0xe640, 0xc13e,	0xe67f, 0xc13e,		0x21, 0
	.dw 0xe6c0, 0xc13e,	0xe6ff, 0xc13e,		0x21, 0
	.dw 0xe740, 0xc13e,	0xe77f, 0xc13e,		0x21, 0
	.dw 0xe7c0, 0xc13e,	0xe7ff, 0xc13e,		0x21, 0
	.dw 0xe840, 0xc13e,	0xe87f, 0xc13e,		0x21, 0
	.dw 0xe8c0, 0xc13e,	0xe8ff, 0xc13e,		0x21, 0
	.dw 0xe940, 0xc13e,	0xe97f, 0xc13e,		0x21, 0
	.dw 0xe9c0, 0xc13e,	0xe9ff, 0xc13e,		0x21, 0
	.dw 0xea40, 0xc13e,	0xea7f, 0xc13e,		0x21, 0
	.dw 0xeac0, 0xc13e,	0xeaff, 0xc13e,		0x21, 0
	.dw 0xeb40, 0xc13e,	0xeb7f, 0xc13e,		0x21, 0
	.dw 0xebc0, 0xc13e,	0xebff, 0xc13e,		0x21, 0
	.dw 0xec40, 0xc13e,	0xec7f, 0xc13e,		0x21, 0
	.dw 0xecc0, 0xc13e,	0xecff, 0xc13e,		0x21, 0
	.dw 0xed40, 0xc13e,	0xed7f, 0xc13e,		0x21, 0
	.dw 0xedc0, 0xc13e,	0xedff, 0xc13e,		0x21, 0
	.dw 0xee40, 0xc13e,	0xee7f, 0xc13e,		0x21, 0
	.dw 0xeec0, 0xc13e,	0xeeff, 0xc13e,		0x21, 0
	.dw 0xef40, 0xc13e,	0xef7f, 0xc13e,		0x21, 0
	.dw 0xefc0, 0xc13e,	0xefff, 0xc13e,		0x21, 0
	.dw 0xf040, 0xc13e,	0xf07f, 0xc13e,		0x21, 0
	.dw 0xf0c0, 0xc13e,	0xf0ff, 0xc13e,		0x21, 0
	.dw 0xf140, 0xc13e,	0xf17f, 0xc13e,		0x21, 0
	.dw 0xf1c0, 0xc13e,	0xf1ff, 0xc13e,		0x21, 0
	.dw 0xf240, 0xc13e,	0xf27f, 0xc13e,		0x21, 0
	.dw 0xf2c0, 0xc13e,	0xf2ff, 0xc13e,		0x21, 0
	.dw 0xf340, 0xc13e,	0xf37f, 0xc13e,		0x21, 0
	.dw 0xf3c0, 0xc13e,	0xf3ff, 0xc13e,		0x21, 0
	.dw 0xf440, 0xc13e,	0xf47f, 0xc13e,		0x21, 0
	.dw 0xf4c0, 0xc13e,	0xf4ff, 0xc13e,		0x21, 0
	.dw 0xf540, 0xc13e,	0xf57f, 0xc13e,		0x21, 0
	.dw 0xf5c0, 0xc13e,	0xf5ff, 0xc13e,		0x21, 0
	.dw 0xf640, 0xc13e,	0xf67f, 0xc13e,		0x21, 0
	.dw 0xf6c0, 0xc13e,	0xf6ff, 0xc13e,		0x21, 0
	.dw 0xf740, 0xc13e,	0xf77f, 0xc13e,		0x21, 0
	.dw 0xf7c0, 0xc13e,	0xf7ff, 0xc13e,		0x21, 0
	.dw 0xf840, 0xc13e,	0xf87f, 0xc13e,		0x21, 0
	.dw 0xf8c0, 0xc13e,	0xf8ff, 0xc13e,		0x21, 0
	.dw 0xf940, 0xc13e,	0xf97f, 0xc13e,		0x21, 0
	.dw 0xf9c0, 0xc13e,	0xffff, 0xc13e,		0x21, 0
	.dw 0x0040, 0xc13f,	0x007f, 0xc13f,		0x21, 0
	.dw 0x00c0, 0xc13f,	0x00ff, 0xc13f,		0x21, 0
	.dw 0x0140, 0xc13f,	0x017f, 0xc13f,		0x21, 0
	.dw 0x01c0, 0xc13f,	0x01ff, 0xc13f,		0x21, 0
	.dw 0x0240, 0xc13f,	0x027f, 0xc13f,		0x21, 0
	.dw 0x02c0, 0xc13f,	0x02ff, 0xc13f,		0x21, 0
	.dw 0x0340, 0xc13f,	0x037f, 0xc13f,		0x21, 0
	.dw 0x03c0, 0xc13f,	0x03ff, 0xc13f,		0x21, 0
	.dw 0x0440, 0xc13f,	0x047f, 0xc13f,		0x21, 0
	.dw 0x04c0, 0xc13f,	0x04ff, 0xc13f,		0x21, 0
	.dw 0x0540, 0xc13f,	0x057f, 0xc13f,		0x21, 0
	.dw 0x05c0, 0xc13f,	0x05ff, 0xc13f,		0x21, 0
	.dw 0x0640, 0xc13f,	0x067f, 0xc13f,		0x21, 0
	.dw 0x06c0, 0xc13f,	0x06ff, 0xc13f,		0x21, 0
	.dw 0x0740, 0xc13f,	0x077f, 0xc13f,		0x21, 0
	.dw 0x07c0, 0xc13f,	0x07ff, 0xc13f,		0x21, 0
	.dw 0x0840, 0xc13f,	0x087f, 0xc13f,		0x21, 0
	.dw 0x08c0, 0xc13f,	0x08ff, 0xc13f,		0x21, 0
	.dw 0x0940, 0xc13f,	0x097f, 0xc13f,		0x21, 0
	.dw 0x09c0, 0xc13f,	0x09ff, 0xc13f,		0x21, 0
	.dw 0x0a40, 0xc13f,	0x0a7f, 0xc13f,		0x21, 0
	.dw 0x0ac0, 0xc13f,	0x0aff, 0xc13f,		0x21, 0
	.dw 0x0b40, 0xc13f,	0x0b7f, 0xc13f,		0x21, 0
	.dw 0x0bc0, 0xc13f,	0x0bff, 0xc13f,		0x21, 0
	.dw 0x0c40, 0xc13f,	0x0c7f, 0xc13f,		0x21, 0
	.dw 0x0cc0, 0xc13f,	0x0cff, 0xc13f,		0x21, 0
	.dw 0x0d40, 0xc13f,	0x0d7f, 0xc13f,		0x21, 0
	.dw 0x0dc0, 0xc13f,	0x0dff, 0xc13f,		0x21, 0
	.dw 0x0e40, 0xc13f,	0x0e7f, 0xc13f,		0x21, 0
	.dw 0x0ec0, 0xc13f,	0x0eff, 0xc13f,		0x21, 0
	.dw 0x0f40, 0xc13f,	0x0f7f, 0xc13f,		0x21, 0
	.dw 0x0fc0, 0xc13f,	0x0fff, 0xc13f,		0x21, 0
	.dw 0x1040, 0xc13f,	0x107f, 0xc13f,		0x21, 0
	.dw 0x10c0, 0xc13f,	0x10ff, 0xc13f,		0x21, 0
	.dw 0x1140, 0xc13f,	0x117f, 0xc13f,		0x21, 0
	.dw 0x11c0, 0xc13f,	0x11ff, 0xc13f,		0x21, 0
	.dw 0x1240, 0xc13f,	0x127f, 0xc13f,		0x21, 0
	.dw 0x12c0, 0xc13f,	0x12ff, 0xc13f,		0x21, 0
	.dw 0x1340, 0xc13f,	0x137f, 0xc13f,		0x21, 0
	.dw 0x13c0, 0xc13f,	0x13ff, 0xc13f,		0x21, 0
	.dw 0x1440, 0xc13f,	0x147f, 0xc13f,		0x21, 0
	.dw 0x14c0, 0xc13f,	0x14ff, 0xc13f,		0x21, 0
	.dw 0x1540, 0xc13f,	0x157f, 0xc13f,		0x21, 0
	.dw 0x15c0, 0xc13f,	0x15ff, 0xc13f,		0x21, 0
	.dw 0x1640, 0xc13f,	0x167f, 0xc13f,		0x21, 0
	.dw 0x16c0, 0xc13f,	0x16ff, 0xc13f,		0x21, 0
	.dw 0x1740, 0xc13f,	0x177f, 0xc13f,		0x21, 0
	.dw 0x17c0, 0xc13f,	0x17ff, 0xc13f,		0x21, 0
	.dw 0x1840, 0xc13f,	0x187f, 0xc13f,		0x21, 0
	.dw 0x18c0, 0xc13f,	0x18ff, 0xc13f,		0x21, 0
	.dw 0x1940, 0xc13f,	0x197f, 0xc13f,		0x21, 0
	.dw 0x19c0, 0xc13f,	0x1fff, 0xc13f,		0x21, 0
	.dw 0x2040, 0xc13f,	0x207f, 0xc13f,		0x21, 0
	.dw 0x20c0, 0xc13f,	0x20ff, 0xc13f,		0x21, 0
	.dw 0x2140, 0xc13f,	0x217f, 0xc13f,		0x21, 0
	.dw 0x21c0, 0xc13f,	0x21ff, 0xc13f,		0x21, 0
	.dw 0x2240, 0xc13f,	0x227f, 0xc13f,		0x21, 0
	.dw 0x22c0, 0xc13f,	0x22ff, 0xc13f,		0x21, 0
	.dw 0x2340, 0xc13f,	0x237f, 0xc13f,		0x21, 0
	.dw 0x23c0, 0xc13f,	0x23ff, 0xc13f,		0x21, 0
	.dw 0x2440, 0xc13f,	0x247f, 0xc13f,		0x21, 0
	.dw 0x24c0, 0xc13f,	0x24ff, 0xc13f,		0x21, 0
	.dw 0x2540, 0xc13f,	0x257f, 0xc13f,		0x21, 0
	.dw 0x25c0, 0xc13f,	0x25ff, 0xc13f,		0x21, 0
	.dw 0x2640, 0xc13f,	0x267f, 0xc13f,		0x21, 0
	.dw 0x26c0, 0xc13f,	0x26ff, 0xc13f,		0x21, 0
	.dw 0x2740, 0xc13f,	0x277f, 0xc13f,		0x21, 0
	.dw 0x27c0, 0xc13f,	0x27ff, 0xc13f,		0x21, 0
	.dw 0x2840, 0xc13f,	0x287f, 0xc13f,		0x21, 0
	.dw 0x28c0, 0xc13f,	0x28ff, 0xc13f,		0x21, 0
	.dw 0x2940, 0xc13f,	0x297f, 0xc13f,		0x21, 0
	.dw 0x29c0, 0xc13f,	0x29ff, 0xc13f,		0x21, 0
	.dw 0x2a40, 0xc13f,	0x2a7f, 0xc13f,		0x21, 0
	.dw 0x2ac0, 0xc13f,	0x2aff, 0xc13f,		0x21, 0
	.dw 0x2b40, 0xc13f,	0x2b7f, 0xc13f,		0x21, 0
	.dw 0x2bc0, 0xc13f,	0x2bff, 0xc13f,		0x21, 0
	.dw 0x2c40, 0xc13f,	0x2c7f, 0xc13f,		0x21, 0
	.dw 0x2cc0, 0xc13f,	0x2cff, 0xc13f,		0x21, 0
	.dw 0x2d40, 0xc13f,	0x2d7f, 0xc13f,		0x21, 0
	.dw 0x2dc0, 0xc13f,	0x2dff, 0xc13f,		0x21, 0
	.dw 0x2e40, 0xc13f,	0x2e7f, 0xc13f,		0x21, 0
	.dw 0x2ec0, 0xc13f,	0x2eff, 0xc13f,		0x21, 0
	.dw 0x2f40, 0xc13f,	0x2f7f, 0xc13f,		0x21, 0
	.dw 0x2fc0, 0xc13f,	0x2fff, 0xc13f,		0x21, 0
	.dw 0x3040, 0xc13f,	0x307f, 0xc13f,		0x21, 0
	.dw 0x30c0, 0xc13f,	0x30ff, 0xc13f,		0x21, 0
	.dw 0x3140, 0xc13f,	0x317f, 0xc13f,		0x21, 0
	.dw 0x31c0, 0xc13f,	0x31ff, 0xc13f,		0x21, 0
	.dw 0x3240, 0xc13f,	0x327f, 0xc13f,		0x21, 0
	.dw 0x32c0, 0xc13f,	0x32ff, 0xc13f,		0x21, 0
	.dw 0x3340, 0xc13f,	0x337f, 0xc13f,		0x21, 0
	.dw 0x33c0, 0xc13f,	0x33ff, 0xc13f,		0x21, 0
	.dw 0x3440, 0xc13f,	0x347f, 0xc13f,		0x21, 0
	.dw 0x34c0, 0xc13f,	0x34ff, 0xc13f,		0x21, 0
	.dw 0x3540, 0xc13f,	0x357f, 0xc13f,		0x21, 0
	.dw 0x35c0, 0xc13f,	0x35ff, 0xc13f,		0x21, 0
	.dw 0x3640, 0xc13f,	0x367f, 0xc13f,		0x21, 0
	.dw 0x36c0, 0xc13f,	0x36ff, 0xc13f,		0x21, 0
	.dw 0x3740, 0xc13f,	0x377f, 0xc13f,		0x21, 0
	.dw 0x37c0, 0xc13f,	0x37ff, 0xc13f,		0x21, 0
	.dw 0x3840, 0xc13f,	0x387f, 0xc13f,		0x21, 0
	.dw 0x38c0, 0xc13f,	0x38ff, 0xc13f,		0x21, 0
	.dw 0x3940, 0xc13f,	0x397f, 0xc13f,		0x21, 0
	.dw 0x39c0, 0xc13f,	0x1fff, 0xc160,		0x21, 0
	.dw 0x3a00, 0xc160,	0x5fff, 0xc160,		0x21, 0
	.dw 0x7a00, 0xc160,	0x9fff, 0xc160,		0x21, 0
	.dw 0xba00, 0xc160,	0xdfff, 0xc160,		0x21, 0
	.dw 0xfa00, 0xc160,	0x1fff, 0xc161,		0x21, 0
	.dw 0x3a00, 0xc161,	0x5fff, 0xc161,		0x21, 0
	.dw 0x7a00, 0xc161,	0x9fff, 0xc161,		0x21, 0
	.dw 0xba00, 0xc161,	0xdfff, 0xc161,		0x21, 0
	.dw 0xfa00, 0xc161,	0x1fff, 0xc162,		0x21, 0
	.dw 0x3a00, 0xc162,	0x5fff, 0xc162,		0x21, 0
	.dw 0x7a00, 0xc162,	0x9fff, 0xc162,		0x21, 0
	.dw 0xba00, 0xc162,	0xdfff, 0xc162,		0x21, 0
	.dw 0xfa00, 0xc162,	0x1fff, 0xc163,		0x21, 0
	.dw 0x3a00, 0xc163,	0xffff, 0xc163,		0x21, 0
	.dw 0x1a00, 0xc164,	0x1fff, 0xc164,		0x21, 0
	.dw 0x3a00, 0xc164,	0x3fff, 0xc164,		0x21, 0
	.dw 0x5a00, 0xc164,	0x5fff, 0xc164,		0x21, 0
	.dw 0x7a00, 0xc164,	0x7fff, 0xc164,		0x21, 0
	.dw 0x9a00, 0xc164,	0x9fff, 0xc164,		0x21, 0
	.dw 0xba00, 0xc164,	0xbfff, 0xc164,		0x21, 0
	.dw 0xda00, 0xc164,	0xdfff, 0xc164,		0x21, 0
	.dw 0xfa00, 0xc164,	0xffff, 0xc164,		0x21, 0
	.dw 0x1a00, 0xc165,	0x1fff, 0xc165,		0x21, 0
	.dw 0x3a00, 0xc165,	0x3fff, 0xc165,		0x21, 0
	.dw 0x5a00, 0xc165,	0x5fff, 0xc165,		0x21, 0
	.dw 0x7a00, 0xc165,	0x7fff, 0xc165,		0x21, 0
	.dw 0x9a00, 0xc165,	0x9fff, 0xc165,		0x21, 0
	.dw 0xba00, 0xc165,	0xbfff, 0xc165,		0x21, 0
	.dw 0xda00, 0xc165,	0xdfff, 0xc165,		0x21, 0
	.dw 0xfa00, 0xc165,	0xffff, 0xc165,		0x21, 0
	.dw 0x1a00, 0xc166,	0x1fff, 0xc166,		0x21, 0
	.dw 0x3a00, 0xc166,	0x3fff, 0xc166,		0x21, 0
	.dw 0x5a00, 0xc166,	0x5fff, 0xc166,		0x21, 0
	.dw 0x7a00, 0xc166,	0x7fff, 0xc166,		0x21, 0
	.dw 0x9a00, 0xc166,	0x9fff, 0xc166,		0x21, 0
	.dw 0xba00, 0xc166,	0xbfff, 0xc166,		0x21, 0
	.dw 0xda00, 0xc166,	0xdfff, 0xc166,		0x21, 0
	.dw 0xfa00, 0xc166,	0xffff, 0xc166,		0x21, 0
	.dw 0x1a00, 0xc167,	0x1fff, 0xc167,		0x21, 0
	.dw 0x3a00, 0xc167,	0x1fff, 0xc170,		0x21, 0
	.dw 0x3a00, 0xc170,	0x5fff, 0xc170,		0x21, 0
	.dw 0x7a00, 0xc170,	0x9fff, 0xc170,		0x21, 0
	.dw 0xba00, 0xc170,	0xdfff, 0xc170,		0x21, 0
	.dw 0xfa00, 0xc170,	0x1fff, 0xc171,		0x21, 0
	.dw 0x3a00, 0xc171,	0x5fff, 0xc171,		0x21, 0
	.dw 0x7a00, 0xc171,	0x9fff, 0xc171,		0x21, 0
	.dw 0xba00, 0xc171,	0xdfff, 0xc171,		0x21, 0
	.dw 0xfa00, 0xc171,	0x1fff, 0xc172,		0x21, 0
	.dw 0x3a00, 0xc172,	0x5fff, 0xc172,		0x21, 0
	.dw 0x7a00, 0xc172,	0x9fff, 0xc172,		0x21, 0
	.dw 0xba00, 0xc172,	0xdfff, 0xc172,		0x21, 0
	.dw 0xfa00, 0xc172,	0xffff, 0xc173,		0x21, 0
	.dw 0x1a00, 0xc174,	0x1fff, 0xc174,		0x21, 0
	.dw 0x3a00, 0xc174,	0x3fff, 0xc174,		0x21, 0
	.dw 0x5a00, 0xc174,	0x5fff, 0xc174,		0x21, 0
	.dw 0x7a00, 0xc174,	0x7fff, 0xc174,		0x21, 0
	.dw 0x9a00, 0xc174,	0x9fff, 0xc174,		0x21, 0
	.dw 0xba00, 0xc174,	0xbfff, 0xc174,		0x21, 0
	.dw 0xda00, 0xc174,	0xdfff, 0xc174,		0x21, 0
	.dw 0xfa00, 0xc174,	0xffff, 0xc174,		0x21, 0
	.dw 0x1a00, 0xc175,	0x1fff, 0xc175,		0x21, 0
	.dw 0x3a00, 0xc175,	0x3fff, 0xc175,		0x21, 0
	.dw 0x5a00, 0xc175,	0x5fff, 0xc175,		0x21, 0
	.dw 0x7a00, 0xc175,	0x7fff, 0xc175,		0x21, 0
	.dw 0x9a00, 0xc175,	0x9fff, 0xc175,		0x21, 0
	.dw 0xba00, 0xc175,	0xbfff, 0xc175,		0x21, 0
	.dw 0xda00, 0xc175,	0xdfff, 0xc175,		0x21, 0
	.dw 0xfa00, 0xc175,	0xffff, 0xc175,		0x21, 0
	.dw 0x1a00, 0xc176,	0x1fff, 0xc176,		0x21, 0
	.dw 0x3a00, 0xc176,	0x3fff, 0xc176,		0x21, 0
	.dw 0x5a00, 0xc176,	0x5fff, 0xc176,		0x21, 0
	.dw 0x7a00, 0xc176,	0x7fff, 0xc176,		0x21, 0
	.dw 0x9a00, 0xc176,	0x9fff, 0xc176,		0x21, 0
	.dw 0xba00, 0xc176,	0xbfff, 0xc176,		0x21, 0
	.dw 0xda00, 0xc176,	0xdfff, 0xc176,		0x21, 0
	.dw 0xfa00, 0xc176,	0xffff, 0xc176,		0x21, 0
	.dw 0x1a00, 0xc177,	0x1fff, 0xc177,		0x21, 0
	.dw 0x3a00, 0xc177,	0x1fff, 0xc180,		0x21, 0
	.dw 0x3a00, 0xc180,	0x5fff, 0xc180,		0x21, 0
	.dw 0x7a00, 0xc180,	0x9fff, 0xc180,		0x21, 0
	.dw 0xba00, 0xc180,	0xdfff, 0xc180,		0x21, 0
	.dw 0xfa00, 0xc180,	0x1fff, 0xc181,		0x21, 0
	.dw 0x3a00, 0xc181,	0x5fff, 0xc181,		0x21, 0
	.dw 0x7a00, 0xc181,	0x9fff, 0xc181,		0x21, 0
	.dw 0xba00, 0xc181,	0xdfff, 0xc181,		0x21, 0
	.dw 0xfa00, 0xc181,	0x1fff, 0xc182,		0x21, 0
	.dw 0x3a00, 0xc182,	0x5fff, 0xc182,		0x21, 0
	.dw 0x7a00, 0xc182,	0x9fff, 0xc182,		0x21, 0
	.dw 0xba00, 0xc182,	0xdfff, 0xc182,		0x21, 0
	.dw 0xfa00, 0xc182,	0x1fff, 0xc183,		0x21, 0
	.dw 0x3a00, 0xc183,	0xffff, 0xc183,		0x21, 0
	.dw 0x1a00, 0xc184,	0x1fff, 0xc184,		0x21, 0
	.dw 0x3a00, 0xc184,	0x3fff, 0xc184,		0x21, 0
	.dw 0x5a00, 0xc184,	0x5fff, 0xc184,		0x21, 0
	.dw 0x7a00, 0xc184,	0x7fff, 0xc184,		0x21, 0
	.dw 0x9a00, 0xc184,	0x9fff, 0xc184,		0x21, 0
	.dw 0xba00, 0xc184,	0xbfff, 0xc184,		0x21, 0
	.dw 0xda00, 0xc184,	0xdfff, 0xc184,		0x21, 0
	.dw 0xfa00, 0xc184,	0xffff, 0xc184,		0x21, 0
	.dw 0x1a00, 0xc185,	0x1fff, 0xc185,		0x21, 0
	.dw 0x3a00, 0xc185,	0x3fff, 0xc185,		0x21, 0
	.dw 0x5a00, 0xc185,	0x5fff, 0xc185,		0x21, 0
	.dw 0x7a00, 0xc185,	0x7fff, 0xc185,		0x21, 0
	.dw 0x9a00, 0xc185,	0x9fff, 0xc185,		0x21, 0
	.dw 0xba00, 0xc185,	0xbfff, 0xc185,		0x21, 0
	.dw 0xda00, 0xc185,	0xdfff, 0xc185,		0x21, 0
	.dw 0xfa00, 0xc185,	0xffff, 0xc185,		0x21, 0
	.dw 0x1a00, 0xc186,	0x1fff, 0xc186,		0x21, 0
	.dw 0x3a00, 0xc186,	0x3fff, 0xc186,		0x21, 0
	.dw 0x5a00, 0xc186,	0x5fff, 0xc186,		0x21, 0
	.dw 0x7a00, 0xc186,	0x7fff, 0xc186,		0x21, 0
	.dw 0x9a00, 0xc186,	0x9fff, 0xc186,		0x21, 0
	.dw 0xba00, 0xc186,	0xbfff, 0xc186,		0x21, 0
	.dw 0xda00, 0xc186,	0xdfff, 0xc186,		0x21, 0
	.dw 0xfa00, 0xc186,	0xffff, 0xc186,		0x21, 0
	.dw 0x1a00, 0xc187,	0x1fff, 0xc187,		0x21, 0
	.dw 0x3a00, 0xc187,	0x1fff, 0xc188,		0x21, 0
	.dw 0x2040, 0xc188,	0x207f, 0xc188,		0x21, 0
	.dw 0x20c0, 0xc188,	0x20ff, 0xc188,		0x21, 0
	.dw 0x2140, 0xc188,	0x217f, 0xc188,		0x21, 0
	.dw 0x21c0, 0xc188,	0x21ff, 0xc188,		0x21, 0
	.dw 0x2240, 0xc188,	0x227f, 0xc188,		0x21, 0
	.dw 0x22c0, 0xc188,	0x22ff, 0xc188,		0x21, 0
	.dw 0x2340, 0xc188,	0x237f, 0xc188,		0x21, 0
	.dw 0x23c0, 0xc188,	0x23ff, 0xc188,		0x21, 0
	.dw 0x2440, 0xc188,	0x247f, 0xc188,		0x21, 0
	.dw 0x24c0, 0xc188,	0x24ff, 0xc188,		0x21, 0
	.dw 0x2540, 0xc188,	0x257f, 0xc188,		0x21, 0
	.dw 0x25c0, 0xc188,	0x25ff, 0xc188,		0x21, 0
	.dw 0x2640, 0xc188,	0x267f, 0xc188,		0x21, 0
	.dw 0x26c0, 0xc188,	0x26ff, 0xc188,		0x21, 0
	.dw 0x2740, 0xc188,	0x277f, 0xc188,		0x21, 0
	.dw 0x27c0, 0xc188,	0x27ff, 0xc188,		0x21, 0
	.dw 0x2840, 0xc188,	0x287f, 0xc188,		0x21, 0
	.dw 0x28c0, 0xc188,	0x28ff, 0xc188,		0x21, 0
	.dw 0x2940, 0xc188,	0x297f, 0xc188,		0x21, 0
	.dw 0x29c0, 0xc188,	0x29ff, 0xc188,		0x21, 0
	.dw 0x2a40, 0xc188,	0x2a7f, 0xc188,		0x21, 0
	.dw 0x2ac0, 0xc188,	0x2aff, 0xc188,		0x21, 0
	.dw 0x2b40, 0xc188,	0x2b7f, 0xc188,		0x21, 0
	.dw 0x2bc0, 0xc188,	0x2bff, 0xc188,		0x21, 0
	.dw 0x2c40, 0xc188,	0x2c7f, 0xc188,		0x21, 0
	.dw 0x2cc0, 0xc188,	0x2cff, 0xc188,		0x21, 0
	.dw 0x2d40, 0xc188,	0x2d7f, 0xc188,		0x21, 0
	.dw 0x2dc0, 0xc188,	0x2dff, 0xc188,		0x21, 0
	.dw 0x2e40, 0xc188,	0x2e7f, 0xc188,		0x21, 0
	.dw 0x2ec0, 0xc188,	0x2eff, 0xc188,		0x21, 0
	.dw 0x2f40, 0xc188,	0x2f7f, 0xc188,		0x21, 0
	.dw 0x2fc0, 0xc188,	0x2fff, 0xc188,		0x21, 0
	.dw 0x3040, 0xc188,	0x307f, 0xc188,		0x21, 0
	.dw 0x30c0, 0xc188,	0x30ff, 0xc188,		0x21, 0
	.dw 0x3140, 0xc188,	0x317f, 0xc188,		0x21, 0
	.dw 0x31c0, 0xc188,	0x31ff, 0xc188,		0x21, 0
	.dw 0x3240, 0xc188,	0x327f, 0xc188,		0x21, 0
	.dw 0x32c0, 0xc188,	0x32ff, 0xc188,		0x21, 0
	.dw 0x3340, 0xc188,	0x337f, 0xc188,		0x21, 0
	.dw 0x33c0, 0xc188,	0x33ff, 0xc188,		0x21, 0
	.dw 0x3440, 0xc188,	0x347f, 0xc188,		0x21, 0
	.dw 0x34c0, 0xc188,	0x34ff, 0xc188,		0x21, 0
	.dw 0x3540, 0xc188,	0x357f, 0xc188,		0x21, 0
	.dw 0x35c0, 0xc188,	0x35ff, 0xc188,		0x21, 0
	.dw 0x3640, 0xc188,	0x367f, 0xc188,		0x21, 0
	.dw 0x36c0, 0xc188,	0x36ff, 0xc188,		0x21, 0
	.dw 0x3740, 0xc188,	0x377f, 0xc188,		0x21, 0
	.dw 0x37c0, 0xc188,	0x37ff, 0xc188,		0x21, 0
	.dw 0x3840, 0xc188,	0x387f, 0xc188,		0x21, 0
	.dw 0x38c0, 0xc188,	0x38ff, 0xc188,		0x21, 0
	.dw 0x3940, 0xc188,	0x397f, 0xc188,		0x21, 0
	.dw 0x39c0, 0xc188,	0x5fff, 0xc188,		0x21, 0
	.dw 0x6040, 0xc188,	0x607f, 0xc188,		0x21, 0
	.dw 0x60c0, 0xc188,	0x60ff, 0xc188,		0x21, 0
	.dw 0x6140, 0xc188,	0x617f, 0xc188,		0x21, 0
	.dw 0x61c0, 0xc188,	0x61ff, 0xc188,		0x21, 0
	.dw 0x6240, 0xc188,	0x627f, 0xc188,		0x21, 0
	.dw 0x62c0, 0xc188,	0x62ff, 0xc188,		0x21, 0
	.dw 0x6340, 0xc188,	0x637f, 0xc188,		0x21, 0
	.dw 0x63c0, 0xc188,	0x63ff, 0xc188,		0x21, 0
	.dw 0x6440, 0xc188,	0x647f, 0xc188,		0x21, 0
	.dw 0x64c0, 0xc188,	0x64ff, 0xc188,		0x21, 0
	.dw 0x6540, 0xc188,	0x657f, 0xc188,		0x21, 0
	.dw 0x65c0, 0xc188,	0x65ff, 0xc188,		0x21, 0
	.dw 0x6640, 0xc188,	0x667f, 0xc188,		0x21, 0
	.dw 0x66c0, 0xc188,	0x66ff, 0xc188,		0x21, 0
	.dw 0x6740, 0xc188,	0x677f, 0xc188,		0x21, 0
	.dw 0x67c0, 0xc188,	0x67ff, 0xc188,		0x21, 0
	.dw 0x6840, 0xc188,	0x687f, 0xc188,		0x21, 0
	.dw 0x68c0, 0xc188,	0x68ff, 0xc188,		0x21, 0
	.dw 0x6940, 0xc188,	0x697f, 0xc188,		0x21, 0
	.dw 0x69c0, 0xc188,	0x69ff, 0xc188,		0x21, 0
	.dw 0x6a40, 0xc188,	0x6a7f, 0xc188,		0x21, 0
	.dw 0x6ac0, 0xc188,	0x6aff, 0xc188,		0x21, 0
	.dw 0x6b40, 0xc188,	0x6b7f, 0xc188,		0x21, 0
	.dw 0x6bc0, 0xc188,	0x6bff, 0xc188,		0x21, 0
	.dw 0x6c40, 0xc188,	0x6c7f, 0xc188,		0x21, 0
	.dw 0x6cc0, 0xc188,	0x6cff, 0xc188,		0x21, 0
	.dw 0x6d40, 0xc188,	0x6d7f, 0xc188,		0x21, 0
	.dw 0x6dc0, 0xc188,	0x6dff, 0xc188,		0x21, 0
	.dw 0x6e40, 0xc188,	0x6e7f, 0xc188,		0x21, 0
	.dw 0x6ec0, 0xc188,	0x6eff, 0xc188,		0x21, 0
	.dw 0x6f40, 0xc188,	0x6f7f, 0xc188,		0x21, 0
	.dw 0x6fc0, 0xc188,	0x6fff, 0xc188,		0x21, 0
	.dw 0x7040, 0xc188,	0x707f, 0xc188,		0x21, 0
	.dw 0x70c0, 0xc188,	0x70ff, 0xc188,		0x21, 0
	.dw 0x7140, 0xc188,	0x717f, 0xc188,		0x21, 0
	.dw 0x71c0, 0xc188,	0x71ff, 0xc188,		0x21, 0
	.dw 0x7240, 0xc188,	0x727f, 0xc188,		0x21, 0
	.dw 0x72c0, 0xc188,	0x72ff, 0xc188,		0x21, 0
	.dw 0x7340, 0xc188,	0x737f, 0xc188,		0x21, 0
	.dw 0x73c0, 0xc188,	0x73ff, 0xc188,		0x21, 0
	.dw 0x7440, 0xc188,	0x747f, 0xc188,		0x21, 0
	.dw 0x74c0, 0xc188,	0x74ff, 0xc188,		0x21, 0
	.dw 0x7540, 0xc188,	0x757f, 0xc188,		0x21, 0
	.dw 0x75c0, 0xc188,	0x75ff, 0xc188,		0x21, 0
	.dw 0x7640, 0xc188,	0x767f, 0xc188,		0x21, 0
	.dw 0x76c0, 0xc188,	0x76ff, 0xc188,		0x21, 0
	.dw 0x7740, 0xc188,	0x777f, 0xc188,		0x21, 0
	.dw 0x77c0, 0xc188,	0x77ff, 0xc188,		0x21, 0
	.dw 0x7840, 0xc188,	0x787f, 0xc188,		0x21, 0
	.dw 0x78c0, 0xc188,	0x78ff, 0xc188,		0x21, 0
	.dw 0x7940, 0xc188,	0x797f, 0xc188,		0x21, 0
	.dw 0x79c0, 0xc188,	0x9fff, 0xc188,		0x21, 0
	.dw 0xa040, 0xc188,	0xa07f, 0xc188,		0x21, 0
	.dw 0xa0c0, 0xc188,	0xa0ff, 0xc188,		0x21, 0
	.dw 0xa140, 0xc188,	0xa17f, 0xc188,		0x21, 0
	.dw 0xa1c0, 0xc188,	0xa1ff, 0xc188,		0x21, 0
	.dw 0xa240, 0xc188,	0xa27f, 0xc188,		0x21, 0
	.dw 0xa2c0, 0xc188,	0xa2ff, 0xc188,		0x21, 0
	.dw 0xa340, 0xc188,	0xa37f, 0xc188,		0x21, 0
	.dw 0xa3c0, 0xc188,	0xa3ff, 0xc188,		0x21, 0
	.dw 0xa440, 0xc188,	0xa47f, 0xc188,		0x21, 0
	.dw 0xa4c0, 0xc188,	0xa4ff, 0xc188,		0x21, 0
	.dw 0xa540, 0xc188,	0xa57f, 0xc188,		0x21, 0
	.dw 0xa5c0, 0xc188,	0xa5ff, 0xc188,		0x21, 0
	.dw 0xa640, 0xc188,	0xa67f, 0xc188,		0x21, 0
	.dw 0xa6c0, 0xc188,	0xa6ff, 0xc188,		0x21, 0
	.dw 0xa740, 0xc188,	0xa77f, 0xc188,		0x21, 0
	.dw 0xa7c0, 0xc188,	0xa7ff, 0xc188,		0x21, 0
	.dw 0xa840, 0xc188,	0xa87f, 0xc188,		0x21, 0
	.dw 0xa8c0, 0xc188,	0xa8ff, 0xc188,		0x21, 0
	.dw 0xa940, 0xc188,	0xa97f, 0xc188,		0x21, 0
	.dw 0xa9c0, 0xc188,	0xa9ff, 0xc188,		0x21, 0
	.dw 0xaa40, 0xc188,	0xaa7f, 0xc188,		0x21, 0
	.dw 0xaac0, 0xc188,	0xaaff, 0xc188,		0x21, 0
	.dw 0xab40, 0xc188,	0xab7f, 0xc188,		0x21, 0
	.dw 0xabc0, 0xc188,	0xabff, 0xc188,		0x21, 0
	.dw 0xac40, 0xc188,	0xac7f, 0xc188,		0x21, 0
	.dw 0xacc0, 0xc188,	0xacff, 0xc188,		0x21, 0
	.dw 0xad40, 0xc188,	0xad7f, 0xc188,		0x21, 0
	.dw 0xadc0, 0xc188,	0xadff, 0xc188,		0x21, 0
	.dw 0xae40, 0xc188,	0xae7f, 0xc188,		0x21, 0
	.dw 0xaec0, 0xc188,	0xaeff, 0xc188,		0x21, 0
	.dw 0xaf40, 0xc188,	0xaf7f, 0xc188,		0x21, 0
	.dw 0xafc0, 0xc188,	0xafff, 0xc188,		0x21, 0
	.dw 0xb040, 0xc188,	0xb07f, 0xc188,		0x21, 0
	.dw 0xb0c0, 0xc188,	0xb0ff, 0xc188,		0x21, 0
	.dw 0xb140, 0xc188,	0xb17f, 0xc188,		0x21, 0
	.dw 0xb1c0, 0xc188,	0xb1ff, 0xc188,		0x21, 0
	.dw 0xb240, 0xc188,	0xb27f, 0xc188,		0x21, 0
	.dw 0xb2c0, 0xc188,	0xb2ff, 0xc188,		0x21, 0
	.dw 0xb340, 0xc188,	0xb37f, 0xc188,		0x21, 0
	.dw 0xb3c0, 0xc188,	0xb3ff, 0xc188,		0x21, 0
	.dw 0xb440, 0xc188,	0xb47f, 0xc188,		0x21, 0
	.dw 0xb4c0, 0xc188,	0xb4ff, 0xc188,		0x21, 0
	.dw 0xb540, 0xc188,	0xb57f, 0xc188,		0x21, 0
	.dw 0xb5c0, 0xc188,	0xb5ff, 0xc188,		0x21, 0
	.dw 0xb640, 0xc188,	0xb67f, 0xc188,		0x21, 0
	.dw 0xb6c0, 0xc188,	0xb6ff, 0xc188,		0x21, 0
	.dw 0xb740, 0xc188,	0xb77f, 0xc188,		0x21, 0
	.dw 0xb7c0, 0xc188,	0xb7ff, 0xc188,		0x21, 0
	.dw 0xb840, 0xc188,	0xb87f, 0xc188,		0x21, 0
	.dw 0xb8c0, 0xc188,	0xb8ff, 0xc188,		0x21, 0
	.dw 0xb940, 0xc188,	0xb97f, 0xc188,		0x21, 0
	.dw 0xb9c0, 0xc188,	0xdfff, 0xc188,		0x21, 0
	.dw 0xe040, 0xc188,	0xe07f, 0xc188,		0x21, 0
	.dw 0xe0c0, 0xc188,	0xe0ff, 0xc188,		0x21, 0
	.dw 0xe140, 0xc188,	0xe17f, 0xc188,		0x21, 0
	.dw 0xe1c0, 0xc188,	0xe1ff, 0xc188,		0x21, 0
	.dw 0xe240, 0xc188,	0xe27f, 0xc188,		0x21, 0
	.dw 0xe2c0, 0xc188,	0xe2ff, 0xc188,		0x21, 0
	.dw 0xe340, 0xc188,	0xe37f, 0xc188,		0x21, 0
	.dw 0xe3c0, 0xc188,	0xe3ff, 0xc188,		0x21, 0
	.dw 0xe440, 0xc188,	0xe47f, 0xc188,		0x21, 0
	.dw 0xe4c0, 0xc188,	0xe4ff, 0xc188,		0x21, 0
	.dw 0xe540, 0xc188,	0xe57f, 0xc188,		0x21, 0
	.dw 0xe5c0, 0xc188,	0xe5ff, 0xc188,		0x21, 0
	.dw 0xe640, 0xc188,	0xe67f, 0xc188,		0x21, 0
	.dw 0xe6c0, 0xc188,	0xe6ff, 0xc188,		0x21, 0
	.dw 0xe740, 0xc188,	0xe77f, 0xc188,		0x21, 0
	.dw 0xe7c0, 0xc188,	0xe7ff, 0xc188,		0x21, 0
	.dw 0xe840, 0xc188,	0xe87f, 0xc188,		0x21, 0
	.dw 0xe8c0, 0xc188,	0xe8ff, 0xc188,		0x21, 0
	.dw 0xe940, 0xc188,	0xe97f, 0xc188,		0x21, 0
	.dw 0xe9c0, 0xc188,	0xe9ff, 0xc188,		0x21, 0
	.dw 0xea40, 0xc188,	0xea7f, 0xc188,		0x21, 0
	.dw 0xeac0, 0xc188,	0xeaff, 0xc188,		0x21, 0
	.dw 0xeb40, 0xc188,	0xeb7f, 0xc188,		0x21, 0
	.dw 0xebc0, 0xc188,	0xebff, 0xc188,		0x21, 0
	.dw 0xec40, 0xc188,	0xec7f, 0xc188,		0x21, 0
	.dw 0xecc0, 0xc188,	0xecff, 0xc188,		0x21, 0
	.dw 0xed40, 0xc188,	0xed7f, 0xc188,		0x21, 0
	.dw 0xedc0, 0xc188,	0xedff, 0xc188,		0x21, 0
	.dw 0xee40, 0xc188,	0xee7f, 0xc188,		0x21, 0
	.dw 0xeec0, 0xc188,	0xeeff, 0xc188,		0x21, 0
	.dw 0xef40, 0xc188,	0xef7f, 0xc188,		0x21, 0
	.dw 0xefc0, 0xc188,	0xefff, 0xc188,		0x21, 0
	.dw 0xf040, 0xc188,	0xf07f, 0xc188,		0x21, 0
	.dw 0xf0c0, 0xc188,	0xf0ff, 0xc188,		0x21, 0
	.dw 0xf140, 0xc188,	0xf17f, 0xc188,		0x21, 0
	.dw 0xf1c0, 0xc188,	0xf1ff, 0xc188,		0x21, 0
	.dw 0xf240, 0xc188,	0xf27f, 0xc188,		0x21, 0
	.dw 0xf2c0, 0xc188,	0xf2ff, 0xc188,		0x21, 0
	.dw 0xf340, 0xc188,	0xf37f, 0xc188,		0x21, 0
	.dw 0xf3c0, 0xc188,	0xf3ff, 0xc188,		0x21, 0
	.dw 0xf440, 0xc188,	0xf47f, 0xc188,		0x21, 0
	.dw 0xf4c0, 0xc188,	0xf4ff, 0xc188,		0x21, 0
	.dw 0xf540, 0xc188,	0xf57f, 0xc188,		0x21, 0
	.dw 0xf5c0, 0xc188,	0xf5ff, 0xc188,		0x21, 0
	.dw 0xf640, 0xc188,	0xf67f, 0xc188,		0x21, 0
	.dw 0xf6c0, 0xc188,	0xf6ff, 0xc188,		0x21, 0
	.dw 0xf740, 0xc188,	0xf77f, 0xc188,		0x21, 0
	.dw 0xf7c0, 0xc188,	0xf7ff, 0xc188,		0x21, 0
	.dw 0xf840, 0xc188,	0xf87f, 0xc188,		0x21, 0
	.dw 0xf8c0, 0xc188,	0xf8ff, 0xc188,		0x21, 0
	.dw 0xf940, 0xc188,	0xf97f, 0xc188,		0x21, 0
	.dw 0xf9c0, 0xc188,	0x1fff, 0xc189,		0x21, 0
	.dw 0x2040, 0xc189,	0x207f, 0xc189,		0x21, 0
	.dw 0x20c0, 0xc189,	0x20ff, 0xc189,		0x21, 0
	.dw 0x2140, 0xc189,	0x217f, 0xc189,		0x21, 0
	.dw 0x21c0, 0xc189,	0x21ff, 0xc189,		0x21, 0
	.dw 0x2240, 0xc189,	0x227f, 0xc189,		0x21, 0
	.dw 0x22c0, 0xc189,	0x22ff, 0xc189,		0x21, 0
	.dw 0x2340, 0xc189,	0x237f, 0xc189,		0x21, 0
	.dw 0x23c0, 0xc189,	0x23ff, 0xc189,		0x21, 0
	.dw 0x2440, 0xc189,	0x247f, 0xc189,		0x21, 0
	.dw 0x24c0, 0xc189,	0x24ff, 0xc189,		0x21, 0
	.dw 0x2540, 0xc189,	0x257f, 0xc189,		0x21, 0
	.dw 0x25c0, 0xc189,	0x25ff, 0xc189,		0x21, 0
	.dw 0x2640, 0xc189,	0x267f, 0xc189,		0x21, 0
	.dw 0x26c0, 0xc189,	0x26ff, 0xc189,		0x21, 0
	.dw 0x2740, 0xc189,	0x277f, 0xc189,		0x21, 0
	.dw 0x27c0, 0xc189,	0x27ff, 0xc189,		0x21, 0
	.dw 0x2840, 0xc189,	0x287f, 0xc189,		0x21, 0
	.dw 0x28c0, 0xc189,	0x28ff, 0xc189,		0x21, 0
	.dw 0x2940, 0xc189,	0x297f, 0xc189,		0x21, 0
	.dw 0x29c0, 0xc189,	0x29ff, 0xc189,		0x21, 0
	.dw 0x2a40, 0xc189,	0x2a7f, 0xc189,		0x21, 0
	.dw 0x2ac0, 0xc189,	0x2aff, 0xc189,		0x21, 0
	.dw 0x2b40, 0xc189,	0x2b7f, 0xc189,		0x21, 0
	.dw 0x2bc0, 0xc189,	0x2bff, 0xc189,		0x21, 0
	.dw 0x2c40, 0xc189,	0x2c7f, 0xc189,		0x21, 0
	.dw 0x2cc0, 0xc189,	0x2cff, 0xc189,		0x21, 0
	.dw 0x2d40, 0xc189,	0x2d7f, 0xc189,		0x21, 0
	.dw 0x2dc0, 0xc189,	0x2dff, 0xc189,		0x21, 0
	.dw 0x2e40, 0xc189,	0x2e7f, 0xc189,		0x21, 0
	.dw 0x2ec0, 0xc189,	0x2eff, 0xc189,		0x21, 0
	.dw 0x2f40, 0xc189,	0x2f7f, 0xc189,		0x21, 0
	.dw 0x2fc0, 0xc189,	0x2fff, 0xc189,		0x21, 0
	.dw 0x3040, 0xc189,	0x307f, 0xc189,		0x21, 0
	.dw 0x30c0, 0xc189,	0x30ff, 0xc189,		0x21, 0
	.dw 0x3140, 0xc189,	0x317f, 0xc189,		0x21, 0
	.dw 0x31c0, 0xc189,	0x31ff, 0xc189,		0x21, 0
	.dw 0x3240, 0xc189,	0x327f, 0xc189,		0x21, 0
	.dw 0x32c0, 0xc189,	0x32ff, 0xc189,		0x21, 0
	.dw 0x3340, 0xc189,	0x337f, 0xc189,		0x21, 0
	.dw 0x33c0, 0xc189,	0x33ff, 0xc189,		0x21, 0
	.dw 0x3440, 0xc189,	0x347f, 0xc189,		0x21, 0
	.dw 0x34c0, 0xc189,	0x34ff, 0xc189,		0x21, 0
	.dw 0x3540, 0xc189,	0x357f, 0xc189,		0x21, 0
	.dw 0x35c0, 0xc189,	0x35ff, 0xc189,		0x21, 0
	.dw 0x3640, 0xc189,	0x367f, 0xc189,		0x21, 0
	.dw 0x36c0, 0xc189,	0x36ff, 0xc189,		0x21, 0
	.dw 0x3740, 0xc189,	0x377f, 0xc189,		0x21, 0
	.dw 0x37c0, 0xc189,	0x37ff, 0xc189,		0x21, 0
	.dw 0x3840, 0xc189,	0x387f, 0xc189,		0x21, 0
	.dw 0x38c0, 0xc189,	0x38ff, 0xc189,		0x21, 0
	.dw 0x3940, 0xc189,	0x397f, 0xc189,		0x21, 0
	.dw 0x39c0, 0xc189,	0x5fff, 0xc189,		0x21, 0
	.dw 0x6040, 0xc189,	0x607f, 0xc189,		0x21, 0
	.dw 0x60c0, 0xc189,	0x60ff, 0xc189,		0x21, 0
	.dw 0x6140, 0xc189,	0x617f, 0xc189,		0x21, 0
	.dw 0x61c0, 0xc189,	0x61ff, 0xc189,		0x21, 0
	.dw 0x6240, 0xc189,	0x627f, 0xc189,		0x21, 0
	.dw 0x62c0, 0xc189,	0x62ff, 0xc189,		0x21, 0
	.dw 0x6340, 0xc189,	0x637f, 0xc189,		0x21, 0
	.dw 0x63c0, 0xc189,	0x63ff, 0xc189,		0x21, 0
	.dw 0x6440, 0xc189,	0x647f, 0xc189,		0x21, 0
	.dw 0x64c0, 0xc189,	0x64ff, 0xc189,		0x21, 0
	.dw 0x6540, 0xc189,	0x657f, 0xc189,		0x21, 0
	.dw 0x65c0, 0xc189,	0x65ff, 0xc189,		0x21, 0
	.dw 0x6640, 0xc189,	0x667f, 0xc189,		0x21, 0
	.dw 0x66c0, 0xc189,	0x66ff, 0xc189,		0x21, 0
	.dw 0x6740, 0xc189,	0x677f, 0xc189,		0x21, 0
	.dw 0x67c0, 0xc189,	0x67ff, 0xc189,		0x21, 0
	.dw 0x6840, 0xc189,	0x687f, 0xc189,		0x21, 0
	.dw 0x68c0, 0xc189,	0x68ff, 0xc189,		0x21, 0
	.dw 0x6940, 0xc189,	0x697f, 0xc189,		0x21, 0
	.dw 0x69c0, 0xc189,	0x69ff, 0xc189,		0x21, 0
	.dw 0x6a40, 0xc189,	0x6a7f, 0xc189,		0x21, 0
	.dw 0x6ac0, 0xc189,	0x6aff, 0xc189,		0x21, 0
	.dw 0x6b40, 0xc189,	0x6b7f, 0xc189,		0x21, 0
	.dw 0x6bc0, 0xc189,	0x6bff, 0xc189,		0x21, 0
	.dw 0x6c40, 0xc189,	0x6c7f, 0xc189,		0x21, 0
	.dw 0x6cc0, 0xc189,	0x6cff, 0xc189,		0x21, 0
	.dw 0x6d40, 0xc189,	0x6d7f, 0xc189,		0x21, 0
	.dw 0x6dc0, 0xc189,	0x6dff, 0xc189,		0x21, 0
	.dw 0x6e40, 0xc189,	0x6e7f, 0xc189,		0x21, 0
	.dw 0x6ec0, 0xc189,	0x6eff, 0xc189,		0x21, 0
	.dw 0x6f40, 0xc189,	0x6f7f, 0xc189,		0x21, 0
	.dw 0x6fc0, 0xc189,	0x6fff, 0xc189,		0x21, 0
	.dw 0x7040, 0xc189,	0x707f, 0xc189,		0x21, 0
	.dw 0x70c0, 0xc189,	0x70ff, 0xc189,		0x21, 0
	.dw 0x7140, 0xc189,	0x717f, 0xc189,		0x21, 0
	.dw 0x71c0, 0xc189,	0x71ff, 0xc189,		0x21, 0
	.dw 0x7240, 0xc189,	0x727f, 0xc189,		0x21, 0
	.dw 0x72c0, 0xc189,	0x72ff, 0xc189,		0x21, 0
	.dw 0x7340, 0xc189,	0x737f, 0xc189,		0x21, 0
	.dw 0x73c0, 0xc189,	0x73ff, 0xc189,		0x21, 0
	.dw 0x7440, 0xc189,	0x747f, 0xc189,		0x21, 0
	.dw 0x74c0, 0xc189,	0x74ff, 0xc189,		0x21, 0
	.dw 0x7540, 0xc189,	0x757f, 0xc189,		0x21, 0
	.dw 0x75c0, 0xc189,	0x75ff, 0xc189,		0x21, 0
	.dw 0x7640, 0xc189,	0x767f, 0xc189,		0x21, 0
	.dw 0x76c0, 0xc189,	0x76ff, 0xc189,		0x21, 0
	.dw 0x7740, 0xc189,	0x777f, 0xc189,		0x21, 0
	.dw 0x77c0, 0xc189,	0x77ff, 0xc189,		0x21, 0
	.dw 0x7840, 0xc189,	0x787f, 0xc189,		0x21, 0
	.dw 0x78c0, 0xc189,	0x78ff, 0xc189,		0x21, 0
	.dw 0x7940, 0xc189,	0x797f, 0xc189,		0x21, 0
	.dw 0x79c0, 0xc189,	0x9fff, 0xc189,		0x21, 0
	.dw 0xa040, 0xc189,	0xa07f, 0xc189,		0x21, 0
	.dw 0xa0c0, 0xc189,	0xa0ff, 0xc189,		0x21, 0
	.dw 0xa140, 0xc189,	0xa17f, 0xc189,		0x21, 0
	.dw 0xa1c0, 0xc189,	0xa1ff, 0xc189,		0x21, 0
	.dw 0xa240, 0xc189,	0xa27f, 0xc189,		0x21, 0
	.dw 0xa2c0, 0xc189,	0xa2ff, 0xc189,		0x21, 0
	.dw 0xa340, 0xc189,	0xa37f, 0xc189,		0x21, 0
	.dw 0xa3c0, 0xc189,	0xa3ff, 0xc189,		0x21, 0
	.dw 0xa440, 0xc189,	0xa47f, 0xc189,		0x21, 0
	.dw 0xa4c0, 0xc189,	0xa4ff, 0xc189,		0x21, 0
	.dw 0xa540, 0xc189,	0xa57f, 0xc189,		0x21, 0
	.dw 0xa5c0, 0xc189,	0xa5ff, 0xc189,		0x21, 0
	.dw 0xa640, 0xc189,	0xa67f, 0xc189,		0x21, 0
	.dw 0xa6c0, 0xc189,	0xa6ff, 0xc189,		0x21, 0
	.dw 0xa740, 0xc189,	0xa77f, 0xc189,		0x21, 0
	.dw 0xa7c0, 0xc189,	0xa7ff, 0xc189,		0x21, 0
	.dw 0xa840, 0xc189,	0xa87f, 0xc189,		0x21, 0
	.dw 0xa8c0, 0xc189,	0xa8ff, 0xc189,		0x21, 0
	.dw 0xa940, 0xc189,	0xa97f, 0xc189,		0x21, 0
	.dw 0xa9c0, 0xc189,	0xa9ff, 0xc189,		0x21, 0
	.dw 0xaa40, 0xc189,	0xaa7f, 0xc189,		0x21, 0
	.dw 0xaac0, 0xc189,	0xaaff, 0xc189,		0x21, 0
	.dw 0xab40, 0xc189,	0xab7f, 0xc189,		0x21, 0
	.dw 0xabc0, 0xc189,	0xabff, 0xc189,		0x21, 0
	.dw 0xac40, 0xc189,	0xac7f, 0xc189,		0x21, 0
	.dw 0xacc0, 0xc189,	0xacff, 0xc189,		0x21, 0
	.dw 0xad40, 0xc189,	0xad7f, 0xc189,		0x21, 0
	.dw 0xadc0, 0xc189,	0xadff, 0xc189,		0x21, 0
	.dw 0xae40, 0xc189,	0xae7f, 0xc189,		0x21, 0
	.dw 0xaec0, 0xc189,	0xaeff, 0xc189,		0x21, 0
	.dw 0xaf40, 0xc189,	0xaf7f, 0xc189,		0x21, 0
	.dw 0xafc0, 0xc189,	0xafff, 0xc189,		0x21, 0
	.dw 0xb040, 0xc189,	0xb07f, 0xc189,		0x21, 0
	.dw 0xb0c0, 0xc189,	0xb0ff, 0xc189,		0x21, 0
	.dw 0xb140, 0xc189,	0xb17f, 0xc189,		0x21, 0
	.dw 0xb1c0, 0xc189,	0xb1ff, 0xc189,		0x21, 0
	.dw 0xb240, 0xc189,	0xb27f, 0xc189,		0x21, 0
	.dw 0xb2c0, 0xc189,	0xb2ff, 0xc189,		0x21, 0
	.dw 0xb340, 0xc189,	0xb37f, 0xc189,		0x21, 0
	.dw 0xb3c0, 0xc189,	0xb3ff, 0xc189,		0x21, 0
	.dw 0xb440, 0xc189,	0xb47f, 0xc189,		0x21, 0
	.dw 0xb4c0, 0xc189,	0xb4ff, 0xc189,		0x21, 0
	.dw 0xb540, 0xc189,	0xb57f, 0xc189,		0x21, 0
	.dw 0xb5c0, 0xc189,	0xb5ff, 0xc189,		0x21, 0
	.dw 0xb640, 0xc189,	0xb67f, 0xc189,		0x21, 0
	.dw 0xb6c0, 0xc189,	0xb6ff, 0xc189,		0x21, 0
	.dw 0xb740, 0xc189,	0xb77f, 0xc189,		0x21, 0
	.dw 0xb7c0, 0xc189,	0xb7ff, 0xc189,		0x21, 0
	.dw 0xb840, 0xc189,	0xb87f, 0xc189,		0x21, 0
	.dw 0xb8c0, 0xc189,	0xb8ff, 0xc189,		0x21, 0
	.dw 0xb940, 0xc189,	0xb97f, 0xc189,		0x21, 0
	.dw 0xb9c0, 0xc189,	0xdfff, 0xc189,		0x21, 0
	.dw 0xe040, 0xc189,	0xe07f, 0xc189,		0x21, 0
	.dw 0xe0c0, 0xc189,	0xe0ff, 0xc189,		0x21, 0
	.dw 0xe140, 0xc189,	0xe17f, 0xc189,		0x21, 0
	.dw 0xe1c0, 0xc189,	0xe1ff, 0xc189,		0x21, 0
	.dw 0xe240, 0xc189,	0xe27f, 0xc189,		0x21, 0
	.dw 0xe2c0, 0xc189,	0xe2ff, 0xc189,		0x21, 0
	.dw 0xe340, 0xc189,	0xe37f, 0xc189,		0x21, 0
	.dw 0xe3c0, 0xc189,	0xe3ff, 0xc189,		0x21, 0
	.dw 0xe440, 0xc189,	0xe47f, 0xc189,		0x21, 0
	.dw 0xe4c0, 0xc189,	0xe4ff, 0xc189,		0x21, 0
	.dw 0xe540, 0xc189,	0xe57f, 0xc189,		0x21, 0
	.dw 0xe5c0, 0xc189,	0xe5ff, 0xc189,		0x21, 0
	.dw 0xe640, 0xc189,	0xe67f, 0xc189,		0x21, 0
	.dw 0xe6c0, 0xc189,	0xe6ff, 0xc189,		0x21, 0
	.dw 0xe740, 0xc189,	0xe77f, 0xc189,		0x21, 0
	.dw 0xe7c0, 0xc189,	0xe7ff, 0xc189,		0x21, 0
	.dw 0xe840, 0xc189,	0xe87f, 0xc189,		0x21, 0
	.dw 0xe8c0, 0xc189,	0xe8ff, 0xc189,		0x21, 0
	.dw 0xe940, 0xc189,	0xe97f, 0xc189,		0x21, 0
	.dw 0xe9c0, 0xc189,	0xe9ff, 0xc189,		0x21, 0
	.dw 0xea40, 0xc189,	0xea7f, 0xc189,		0x21, 0
	.dw 0xeac0, 0xc189,	0xeaff, 0xc189,		0x21, 0
	.dw 0xeb40, 0xc189,	0xeb7f, 0xc189,		0x21, 0
	.dw 0xebc0, 0xc189,	0xebff, 0xc189,		0x21, 0
	.dw 0xec40, 0xc189,	0xec7f, 0xc189,		0x21, 0
	.dw 0xecc0, 0xc189,	0xecff, 0xc189,		0x21, 0
	.dw 0xed40, 0xc189,	0xed7f, 0xc189,		0x21, 0
	.dw 0xedc0, 0xc189,	0xedff, 0xc189,		0x21, 0
	.dw 0xee40, 0xc189,	0xee7f, 0xc189,		0x21, 0
	.dw 0xeec0, 0xc189,	0xeeff, 0xc189,		0x21, 0
	.dw 0xef40, 0xc189,	0xef7f, 0xc189,		0x21, 0
	.dw 0xefc0, 0xc189,	0xefff, 0xc189,		0x21, 0
	.dw 0xf040, 0xc189,	0xf07f, 0xc189,		0x21, 0
	.dw 0xf0c0, 0xc189,	0xf0ff, 0xc189,		0x21, 0
	.dw 0xf140, 0xc189,	0xf17f, 0xc189,		0x21, 0
	.dw 0xf1c0, 0xc189,	0xf1ff, 0xc189,		0x21, 0
	.dw 0xf240, 0xc189,	0xf27f, 0xc189,		0x21, 0
	.dw 0xf2c0, 0xc189,	0xf2ff, 0xc189,		0x21, 0
	.dw 0xf340, 0xc189,	0xf37f, 0xc189,		0x21, 0
	.dw 0xf3c0, 0xc189,	0xf3ff, 0xc189,		0x21, 0
	.dw 0xf440, 0xc189,	0xf47f, 0xc189,		0x21, 0
	.dw 0xf4c0, 0xc189,	0xf4ff, 0xc189,		0x21, 0
	.dw 0xf540, 0xc189,	0xf57f, 0xc189,		0x21, 0
	.dw 0xf5c0, 0xc189,	0xf5ff, 0xc189,		0x21, 0
	.dw 0xf640, 0xc189,	0xf67f, 0xc189,		0x21, 0
	.dw 0xf6c0, 0xc189,	0xf6ff, 0xc189,		0x21, 0
	.dw 0xf740, 0xc189,	0xf77f, 0xc189,		0x21, 0
	.dw 0xf7c0, 0xc189,	0xf7ff, 0xc189,		0x21, 0
	.dw 0xf840, 0xc189,	0xf87f, 0xc189,		0x21, 0
	.dw 0xf8c0, 0xc189,	0xf8ff, 0xc189,		0x21, 0
	.dw 0xf940, 0xc189,	0xf97f, 0xc189,		0x21, 0
	.dw 0xf9c0, 0xc189,	0x1fff, 0xc18a,		0x21, 0
	.dw 0x2040, 0xc18a,	0x207f, 0xc18a,		0x21, 0
	.dw 0x20c0, 0xc18a,	0x20ff, 0xc18a,		0x21, 0
	.dw 0x2140, 0xc18a,	0x217f, 0xc18a,		0x21, 0
	.dw 0x21c0, 0xc18a,	0x21ff, 0xc18a,		0x21, 0
	.dw 0x2240, 0xc18a,	0x227f, 0xc18a,		0x21, 0
	.dw 0x22c0, 0xc18a,	0x22ff, 0xc18a,		0x21, 0
	.dw 0x2340, 0xc18a,	0x237f, 0xc18a,		0x21, 0
	.dw 0x23c0, 0xc18a,	0x23ff, 0xc18a,		0x21, 0
	.dw 0x2440, 0xc18a,	0x247f, 0xc18a,		0x21, 0
	.dw 0x24c0, 0xc18a,	0x24ff, 0xc18a,		0x21, 0
	.dw 0x2540, 0xc18a,	0x257f, 0xc18a,		0x21, 0
	.dw 0x25c0, 0xc18a,	0x25ff, 0xc18a,		0x21, 0
	.dw 0x2640, 0xc18a,	0x267f, 0xc18a,		0x21, 0
	.dw 0x26c0, 0xc18a,	0x26ff, 0xc18a,		0x21, 0
	.dw 0x2740, 0xc18a,	0x277f, 0xc18a,		0x21, 0
	.dw 0x27c0, 0xc18a,	0x27ff, 0xc18a,		0x21, 0
	.dw 0x2840, 0xc18a,	0x287f, 0xc18a,		0x21, 0
	.dw 0x28c0, 0xc18a,	0x28ff, 0xc18a,		0x21, 0
	.dw 0x2940, 0xc18a,	0x297f, 0xc18a,		0x21, 0
	.dw 0x29c0, 0xc18a,	0x29ff, 0xc18a,		0x21, 0
	.dw 0x2a40, 0xc18a,	0x2a7f, 0xc18a,		0x21, 0
	.dw 0x2ac0, 0xc18a,	0x2aff, 0xc18a,		0x21, 0
	.dw 0x2b40, 0xc18a,	0x2b7f, 0xc18a,		0x21, 0
	.dw 0x2bc0, 0xc18a,	0x2bff, 0xc18a,		0x21, 0
	.dw 0x2c40, 0xc18a,	0x2c7f, 0xc18a,		0x21, 0
	.dw 0x2cc0, 0xc18a,	0x2cff, 0xc18a,		0x21, 0
	.dw 0x2d40, 0xc18a,	0x2d7f, 0xc18a,		0x21, 0
	.dw 0x2dc0, 0xc18a,	0x2dff, 0xc18a,		0x21, 0
	.dw 0x2e40, 0xc18a,	0x2e7f, 0xc18a,		0x21, 0
	.dw 0x2ec0, 0xc18a,	0x2eff, 0xc18a,		0x21, 0
	.dw 0x2f40, 0xc18a,	0x2f7f, 0xc18a,		0x21, 0
	.dw 0x2fc0, 0xc18a,	0x2fff, 0xc18a,		0x21, 0
	.dw 0x3040, 0xc18a,	0x307f, 0xc18a,		0x21, 0
	.dw 0x30c0, 0xc18a,	0x30ff, 0xc18a,		0x21, 0
	.dw 0x3140, 0xc18a,	0x317f, 0xc18a,		0x21, 0
	.dw 0x31c0, 0xc18a,	0x31ff, 0xc18a,		0x21, 0
	.dw 0x3240, 0xc18a,	0x327f, 0xc18a,		0x21, 0
	.dw 0x32c0, 0xc18a,	0x32ff, 0xc18a,		0x21, 0
	.dw 0x3340, 0xc18a,	0x337f, 0xc18a,		0x21, 0
	.dw 0x33c0, 0xc18a,	0x33ff, 0xc18a,		0x21, 0
	.dw 0x3440, 0xc18a,	0x347f, 0xc18a,		0x21, 0
	.dw 0x34c0, 0xc18a,	0x34ff, 0xc18a,		0x21, 0
	.dw 0x3540, 0xc18a,	0x357f, 0xc18a,		0x21, 0
	.dw 0x35c0, 0xc18a,	0x35ff, 0xc18a,		0x21, 0
	.dw 0x3640, 0xc18a,	0x367f, 0xc18a,		0x21, 0
	.dw 0x36c0, 0xc18a,	0x36ff, 0xc18a,		0x21, 0
	.dw 0x3740, 0xc18a,	0x377f, 0xc18a,		0x21, 0
	.dw 0x37c0, 0xc18a,	0x37ff, 0xc18a,		0x21, 0
	.dw 0x3840, 0xc18a,	0x387f, 0xc18a,		0x21, 0
	.dw 0x38c0, 0xc18a,	0x38ff, 0xc18a,		0x21, 0
	.dw 0x3940, 0xc18a,	0x397f, 0xc18a,		0x21, 0
	.dw 0x39c0, 0xc18a,	0x5fff, 0xc18a,		0x21, 0
	.dw 0x6040, 0xc18a,	0x607f, 0xc18a,		0x21, 0
	.dw 0x60c0, 0xc18a,	0x60ff, 0xc18a,		0x21, 0
	.dw 0x6140, 0xc18a,	0x617f, 0xc18a,		0x21, 0
	.dw 0x61c0, 0xc18a,	0x61ff, 0xc18a,		0x21, 0
	.dw 0x6240, 0xc18a,	0x627f, 0xc18a,		0x21, 0
	.dw 0x62c0, 0xc18a,	0x62ff, 0xc18a,		0x21, 0
	.dw 0x6340, 0xc18a,	0x637f, 0xc18a,		0x21, 0
	.dw 0x63c0, 0xc18a,	0x63ff, 0xc18a,		0x21, 0
	.dw 0x6440, 0xc18a,	0x647f, 0xc18a,		0x21, 0
	.dw 0x64c0, 0xc18a,	0x64ff, 0xc18a,		0x21, 0
	.dw 0x6540, 0xc18a,	0x657f, 0xc18a,		0x21, 0
	.dw 0x65c0, 0xc18a,	0x65ff, 0xc18a,		0x21, 0
	.dw 0x6640, 0xc18a,	0x667f, 0xc18a,		0x21, 0
	.dw 0x66c0, 0xc18a,	0x66ff, 0xc18a,		0x21, 0
	.dw 0x6740, 0xc18a,	0x677f, 0xc18a,		0x21, 0
	.dw 0x67c0, 0xc18a,	0x67ff, 0xc18a,		0x21, 0
	.dw 0x6840, 0xc18a,	0x687f, 0xc18a,		0x21, 0
	.dw 0x68c0, 0xc18a,	0x68ff, 0xc18a,		0x21, 0
	.dw 0x6940, 0xc18a,	0x697f, 0xc18a,		0x21, 0
	.dw 0x69c0, 0xc18a,	0x69ff, 0xc18a,		0x21, 0
	.dw 0x6a40, 0xc18a,	0x6a7f, 0xc18a,		0x21, 0
	.dw 0x6ac0, 0xc18a,	0x6aff, 0xc18a,		0x21, 0
	.dw 0x6b40, 0xc18a,	0x6b7f, 0xc18a,		0x21, 0
	.dw 0x6bc0, 0xc18a,	0x6bff, 0xc18a,		0x21, 0
	.dw 0x6c40, 0xc18a,	0x6c7f, 0xc18a,		0x21, 0
	.dw 0x6cc0, 0xc18a,	0x6cff, 0xc18a,		0x21, 0
	.dw 0x6d40, 0xc18a,	0x6d7f, 0xc18a,		0x21, 0
	.dw 0x6dc0, 0xc18a,	0x6dff, 0xc18a,		0x21, 0
	.dw 0x6e40, 0xc18a,	0x6e7f, 0xc18a,		0x21, 0
	.dw 0x6ec0, 0xc18a,	0x6eff, 0xc18a,		0x21, 0
	.dw 0x6f40, 0xc18a,	0x6f7f, 0xc18a,		0x21, 0
	.dw 0x6fc0, 0xc18a,	0x6fff, 0xc18a,		0x21, 0
	.dw 0x7040, 0xc18a,	0x707f, 0xc18a,		0x21, 0
	.dw 0x70c0, 0xc18a,	0x70ff, 0xc18a,		0x21, 0
	.dw 0x7140, 0xc18a,	0x717f, 0xc18a,		0x21, 0
	.dw 0x71c0, 0xc18a,	0x71ff, 0xc18a,		0x21, 0
	.dw 0x7240, 0xc18a,	0x727f, 0xc18a,		0x21, 0
	.dw 0x72c0, 0xc18a,	0x72ff, 0xc18a,		0x21, 0
	.dw 0x7340, 0xc18a,	0x737f, 0xc18a,		0x21, 0
	.dw 0x73c0, 0xc18a,	0x73ff, 0xc18a,		0x21, 0
	.dw 0x7440, 0xc18a,	0x747f, 0xc18a,		0x21, 0
	.dw 0x74c0, 0xc18a,	0x74ff, 0xc18a,		0x21, 0
	.dw 0x7540, 0xc18a,	0x757f, 0xc18a,		0x21, 0
	.dw 0x75c0, 0xc18a,	0x75ff, 0xc18a,		0x21, 0
	.dw 0x7640, 0xc18a,	0x767f, 0xc18a,		0x21, 0
	.dw 0x76c0, 0xc18a,	0x76ff, 0xc18a,		0x21, 0
	.dw 0x7740, 0xc18a,	0x777f, 0xc18a,		0x21, 0
	.dw 0x77c0, 0xc18a,	0x77ff, 0xc18a,		0x21, 0
	.dw 0x7840, 0xc18a,	0x787f, 0xc18a,		0x21, 0
	.dw 0x78c0, 0xc18a,	0x78ff, 0xc18a,		0x21, 0
	.dw 0x7940, 0xc18a,	0x797f, 0xc18a,		0x21, 0
	.dw 0x79c0, 0xc18a,	0x9fff, 0xc18a,		0x21, 0
	.dw 0xa040, 0xc18a,	0xa07f, 0xc18a,		0x21, 0
	.dw 0xa0c0, 0xc18a,	0xa0ff, 0xc18a,		0x21, 0
	.dw 0xa140, 0xc18a,	0xa17f, 0xc18a,		0x21, 0
	.dw 0xa1c0, 0xc18a,	0xa1ff, 0xc18a,		0x21, 0
	.dw 0xa240, 0xc18a,	0xa27f, 0xc18a,		0x21, 0
	.dw 0xa2c0, 0xc18a,	0xa2ff, 0xc18a,		0x21, 0
	.dw 0xa340, 0xc18a,	0xa37f, 0xc18a,		0x21, 0
	.dw 0xa3c0, 0xc18a,	0xa3ff, 0xc18a,		0x21, 0
	.dw 0xa440, 0xc18a,	0xa47f, 0xc18a,		0x21, 0
	.dw 0xa4c0, 0xc18a,	0xa4ff, 0xc18a,		0x21, 0
	.dw 0xa540, 0xc18a,	0xa57f, 0xc18a,		0x21, 0
	.dw 0xa5c0, 0xc18a,	0xa5ff, 0xc18a,		0x21, 0
	.dw 0xa640, 0xc18a,	0xa67f, 0xc18a,		0x21, 0
	.dw 0xa6c0, 0xc18a,	0xa6ff, 0xc18a,		0x21, 0
	.dw 0xa740, 0xc18a,	0xa77f, 0xc18a,		0x21, 0
	.dw 0xa7c0, 0xc18a,	0xa7ff, 0xc18a,		0x21, 0
	.dw 0xa840, 0xc18a,	0xa87f, 0xc18a,		0x21, 0
	.dw 0xa8c0, 0xc18a,	0xa8ff, 0xc18a,		0x21, 0
	.dw 0xa940, 0xc18a,	0xa97f, 0xc18a,		0x21, 0
	.dw 0xa9c0, 0xc18a,	0xa9ff, 0xc18a,		0x21, 0
	.dw 0xaa40, 0xc18a,	0xaa7f, 0xc18a,		0x21, 0
	.dw 0xaac0, 0xc18a,	0xaaff, 0xc18a,		0x21, 0
	.dw 0xab40, 0xc18a,	0xab7f, 0xc18a,		0x21, 0
	.dw 0xabc0, 0xc18a,	0xabff, 0xc18a,		0x21, 0
	.dw 0xac40, 0xc18a,	0xac7f, 0xc18a,		0x21, 0
	.dw 0xacc0, 0xc18a,	0xacff, 0xc18a,		0x21, 0
	.dw 0xad40, 0xc18a,	0xad7f, 0xc18a,		0x21, 0
	.dw 0xadc0, 0xc18a,	0xadff, 0xc18a,		0x21, 0
	.dw 0xae40, 0xc18a,	0xae7f, 0xc18a,		0x21, 0
	.dw 0xaec0, 0xc18a,	0xaeff, 0xc18a,		0x21, 0
	.dw 0xaf40, 0xc18a,	0xaf7f, 0xc18a,		0x21, 0
	.dw 0xafc0, 0xc18a,	0xafff, 0xc18a,		0x21, 0
	.dw 0xb040, 0xc18a,	0xb07f, 0xc18a,		0x21, 0
	.dw 0xb0c0, 0xc18a,	0xb0ff, 0xc18a,		0x21, 0
	.dw 0xb140, 0xc18a,	0xb17f, 0xc18a,		0x21, 0
	.dw 0xb1c0, 0xc18a,	0xb1ff, 0xc18a,		0x21, 0
	.dw 0xb240, 0xc18a,	0xb27f, 0xc18a,		0x21, 0
	.dw 0xb2c0, 0xc18a,	0xb2ff, 0xc18a,		0x21, 0
	.dw 0xb340, 0xc18a,	0xb37f, 0xc18a,		0x21, 0
	.dw 0xb3c0, 0xc18a,	0xb3ff, 0xc18a,		0x21, 0
	.dw 0xb440, 0xc18a,	0xb47f, 0xc18a,		0x21, 0
	.dw 0xb4c0, 0xc18a,	0xb4ff, 0xc18a,		0x21, 0
	.dw 0xb540, 0xc18a,	0xb57f, 0xc18a,		0x21, 0
	.dw 0xb5c0, 0xc18a,	0xb5ff, 0xc18a,		0x21, 0
	.dw 0xb640, 0xc18a,	0xb67f, 0xc18a,		0x21, 0
	.dw 0xb6c0, 0xc18a,	0xb6ff, 0xc18a,		0x21, 0
	.dw 0xb740, 0xc18a,	0xb77f, 0xc18a,		0x21, 0
	.dw 0xb7c0, 0xc18a,	0xb7ff, 0xc18a,		0x21, 0
	.dw 0xb840, 0xc18a,	0xb87f, 0xc18a,		0x21, 0
	.dw 0xb8c0, 0xc18a,	0xb8ff, 0xc18a,		0x21, 0
	.dw 0xb940, 0xc18a,	0xb97f, 0xc18a,		0x21, 0
	.dw 0xb9c0, 0xc18a,	0xdfff, 0xc18a,		0x21, 0
	.dw 0xe040, 0xc18a,	0xe07f, 0xc18a,		0x21, 0
	.dw 0xe0c0, 0xc18a,	0xe0ff, 0xc18a,		0x21, 0
	.dw 0xe140, 0xc18a,	0xe17f, 0xc18a,		0x21, 0
	.dw 0xe1c0, 0xc18a,	0xe1ff, 0xc18a,		0x21, 0
	.dw 0xe240, 0xc18a,	0xe27f, 0xc18a,		0x21, 0
	.dw 0xe2c0, 0xc18a,	0xe2ff, 0xc18a,		0x21, 0
	.dw 0xe340, 0xc18a,	0xe37f, 0xc18a,		0x21, 0
	.dw 0xe3c0, 0xc18a,	0xe3ff, 0xc18a,		0x21, 0
	.dw 0xe440, 0xc18a,	0xe47f, 0xc18a,		0x21, 0
	.dw 0xe4c0, 0xc18a,	0xe4ff, 0xc18a,		0x21, 0
	.dw 0xe540, 0xc18a,	0xe57f, 0xc18a,		0x21, 0
	.dw 0xe5c0, 0xc18a,	0xe5ff, 0xc18a,		0x21, 0
	.dw 0xe640, 0xc18a,	0xe67f, 0xc18a,		0x21, 0
	.dw 0xe6c0, 0xc18a,	0xe6ff, 0xc18a,		0x21, 0
	.dw 0xe740, 0xc18a,	0xe77f, 0xc18a,		0x21, 0
	.dw 0xe7c0, 0xc18a,	0xe7ff, 0xc18a,		0x21, 0
	.dw 0xe840, 0xc18a,	0xe87f, 0xc18a,		0x21, 0
	.dw 0xe8c0, 0xc18a,	0xe8ff, 0xc18a,		0x21, 0
	.dw 0xe940, 0xc18a,	0xe97f, 0xc18a,		0x21, 0
	.dw 0xe9c0, 0xc18a,	0xe9ff, 0xc18a,		0x21, 0
	.dw 0xea40, 0xc18a,	0xea7f, 0xc18a,		0x21, 0
	.dw 0xeac0, 0xc18a,	0xeaff, 0xc18a,		0x21, 0
	.dw 0xeb40, 0xc18a,	0xeb7f, 0xc18a,		0x21, 0
	.dw 0xebc0, 0xc18a,	0xebff, 0xc18a,		0x21, 0
	.dw 0xec40, 0xc18a,	0xec7f, 0xc18a,		0x21, 0
	.dw 0xecc0, 0xc18a,	0xecff, 0xc18a,		0x21, 0
	.dw 0xed40, 0xc18a,	0xed7f, 0xc18a,		0x21, 0
	.dw 0xedc0, 0xc18a,	0xedff, 0xc18a,		0x21, 0
	.dw 0xee40, 0xc18a,	0xee7f, 0xc18a,		0x21, 0
	.dw 0xeec0, 0xc18a,	0xeeff, 0xc18a,		0x21, 0
	.dw 0xef40, 0xc18a,	0xef7f, 0xc18a,		0x21, 0
	.dw 0xefc0, 0xc18a,	0xefff, 0xc18a,		0x21, 0
	.dw 0xf040, 0xc18a,	0xf07f, 0xc18a,		0x21, 0
	.dw 0xf0c0, 0xc18a,	0xf0ff, 0xc18a,		0x21, 0
	.dw 0xf140, 0xc18a,	0xf17f, 0xc18a,		0x21, 0
	.dw 0xf1c0, 0xc18a,	0xf1ff, 0xc18a,		0x21, 0
	.dw 0xf240, 0xc18a,	0xf27f, 0xc18a,		0x21, 0
	.dw 0xf2c0, 0xc18a,	0xf2ff, 0xc18a,		0x21, 0
	.dw 0xf340, 0xc18a,	0xf37f, 0xc18a,		0x21, 0
	.dw 0xf3c0, 0xc18a,	0xf3ff, 0xc18a,		0x21, 0
	.dw 0xf440, 0xc18a,	0xf47f, 0xc18a,		0x21, 0
	.dw 0xf4c0, 0xc18a,	0xf4ff, 0xc18a,		0x21, 0
	.dw 0xf540, 0xc18a,	0xf57f, 0xc18a,		0x21, 0
	.dw 0xf5c0, 0xc18a,	0xf5ff, 0xc18a,		0x21, 0
	.dw 0xf640, 0xc18a,	0xf67f, 0xc18a,		0x21, 0
	.dw 0xf6c0, 0xc18a,	0xf6ff, 0xc18a,		0x21, 0
	.dw 0xf740, 0xc18a,	0xf77f, 0xc18a,		0x21, 0
	.dw 0xf7c0, 0xc18a,	0xf7ff, 0xc18a,		0x21, 0
	.dw 0xf840, 0xc18a,	0xf87f, 0xc18a,		0x21, 0
	.dw 0xf8c0, 0xc18a,	0xf8ff, 0xc18a,		0x21, 0
	.dw 0xf940, 0xc18a,	0xf97f, 0xc18a,		0x21, 0
	.dw 0xf9c0, 0xc18a,	0x1fff, 0xc18b,		0x21, 0
	.dw 0x2040, 0xc18b,	0x207f, 0xc18b,		0x21, 0
	.dw 0x20c0, 0xc18b,	0x20ff, 0xc18b,		0x21, 0
	.dw 0x2140, 0xc18b,	0x217f, 0xc18b,		0x21, 0
	.dw 0x21c0, 0xc18b,	0x21ff, 0xc18b,		0x21, 0
	.dw 0x2240, 0xc18b,	0x227f, 0xc18b,		0x21, 0
	.dw 0x22c0, 0xc18b,	0x22ff, 0xc18b,		0x21, 0
	.dw 0x2340, 0xc18b,	0x237f, 0xc18b,		0x21, 0
	.dw 0x23c0, 0xc18b,	0x23ff, 0xc18b,		0x21, 0
	.dw 0x2440, 0xc18b,	0x247f, 0xc18b,		0x21, 0
	.dw 0x24c0, 0xc18b,	0x24ff, 0xc18b,		0x21, 0
	.dw 0x2540, 0xc18b,	0x257f, 0xc18b,		0x21, 0
	.dw 0x25c0, 0xc18b,	0x25ff, 0xc18b,		0x21, 0
	.dw 0x2640, 0xc18b,	0x267f, 0xc18b,		0x21, 0
	.dw 0x26c0, 0xc18b,	0x26ff, 0xc18b,		0x21, 0
	.dw 0x2740, 0xc18b,	0x277f, 0xc18b,		0x21, 0
	.dw 0x27c0, 0xc18b,	0x27ff, 0xc18b,		0x21, 0
	.dw 0x2840, 0xc18b,	0x287f, 0xc18b,		0x21, 0
	.dw 0x28c0, 0xc18b,	0x28ff, 0xc18b,		0x21, 0
	.dw 0x2940, 0xc18b,	0x297f, 0xc18b,		0x21, 0
	.dw 0x29c0, 0xc18b,	0x29ff, 0xc18b,		0x21, 0
	.dw 0x2a40, 0xc18b,	0x2a7f, 0xc18b,		0x21, 0
	.dw 0x2ac0, 0xc18b,	0x2aff, 0xc18b,		0x21, 0
	.dw 0x2b40, 0xc18b,	0x2b7f, 0xc18b,		0x21, 0
	.dw 0x2bc0, 0xc18b,	0x2bff, 0xc18b,		0x21, 0
	.dw 0x2c40, 0xc18b,	0x2c7f, 0xc18b,		0x21, 0
	.dw 0x2cc0, 0xc18b,	0x2cff, 0xc18b,		0x21, 0
	.dw 0x2d40, 0xc18b,	0x2d7f, 0xc18b,		0x21, 0
	.dw 0x2dc0, 0xc18b,	0x2dff, 0xc18b,		0x21, 0
	.dw 0x2e40, 0xc18b,	0x2e7f, 0xc18b,		0x21, 0
	.dw 0x2ec0, 0xc18b,	0x2eff, 0xc18b,		0x21, 0
	.dw 0x2f40, 0xc18b,	0x2f7f, 0xc18b,		0x21, 0
	.dw 0x2fc0, 0xc18b,	0x2fff, 0xc18b,		0x21, 0
	.dw 0x3040, 0xc18b,	0x307f, 0xc18b,		0x21, 0
	.dw 0x30c0, 0xc18b,	0x30ff, 0xc18b,		0x21, 0
	.dw 0x3140, 0xc18b,	0x317f, 0xc18b,		0x21, 0
	.dw 0x31c0, 0xc18b,	0x31ff, 0xc18b,		0x21, 0
	.dw 0x3240, 0xc18b,	0x327f, 0xc18b,		0x21, 0
	.dw 0x32c0, 0xc18b,	0x32ff, 0xc18b,		0x21, 0
	.dw 0x3340, 0xc18b,	0x337f, 0xc18b,		0x21, 0
	.dw 0x33c0, 0xc18b,	0x33ff, 0xc18b,		0x21, 0
	.dw 0x3440, 0xc18b,	0x347f, 0xc18b,		0x21, 0
	.dw 0x34c0, 0xc18b,	0x34ff, 0xc18b,		0x21, 0
	.dw 0x3540, 0xc18b,	0x357f, 0xc18b,		0x21, 0
	.dw 0x35c0, 0xc18b,	0x35ff, 0xc18b,		0x21, 0
	.dw 0x3640, 0xc18b,	0x367f, 0xc18b,		0x21, 0
	.dw 0x36c0, 0xc18b,	0x36ff, 0xc18b,		0x21, 0
	.dw 0x3740, 0xc18b,	0x377f, 0xc18b,		0x21, 0
	.dw 0x37c0, 0xc18b,	0x37ff, 0xc18b,		0x21, 0
	.dw 0x3840, 0xc18b,	0x387f, 0xc18b,		0x21, 0
	.dw 0x38c0, 0xc18b,	0x38ff, 0xc18b,		0x21, 0
	.dw 0x3940, 0xc18b,	0x397f, 0xc18b,		0x21, 0
	.dw 0x39c0, 0xc18b,	0xffff, 0xc18b,		0x21, 0
	.dw 0x0040, 0xc18c,	0x007f, 0xc18c,		0x21, 0
	.dw 0x00c0, 0xc18c,	0x00ff, 0xc18c,		0x21, 0
	.dw 0x0140, 0xc18c,	0x017f, 0xc18c,		0x21, 0
	.dw 0x01c0, 0xc18c,	0x01ff, 0xc18c,		0x21, 0
	.dw 0x0240, 0xc18c,	0x027f, 0xc18c,		0x21, 0
	.dw 0x02c0, 0xc18c,	0x02ff, 0xc18c,		0x21, 0
	.dw 0x0340, 0xc18c,	0x037f, 0xc18c,		0x21, 0
	.dw 0x03c0, 0xc18c,	0x03ff, 0xc18c,		0x21, 0
	.dw 0x0440, 0xc18c,	0x047f, 0xc18c,		0x21, 0
	.dw 0x04c0, 0xc18c,	0x04ff, 0xc18c,		0x21, 0
	.dw 0x0540, 0xc18c,	0x057f, 0xc18c,		0x21, 0
	.dw 0x05c0, 0xc18c,	0x05ff, 0xc18c,		0x21, 0
	.dw 0x0640, 0xc18c,	0x067f, 0xc18c,		0x21, 0
	.dw 0x06c0, 0xc18c,	0x06ff, 0xc18c,		0x21, 0
	.dw 0x0740, 0xc18c,	0x077f, 0xc18c,		0x21, 0
	.dw 0x07c0, 0xc18c,	0x07ff, 0xc18c,		0x21, 0
	.dw 0x0840, 0xc18c,	0x087f, 0xc18c,		0x21, 0
	.dw 0x08c0, 0xc18c,	0x08ff, 0xc18c,		0x21, 0
	.dw 0x0940, 0xc18c,	0x097f, 0xc18c,		0x21, 0
	.dw 0x09c0, 0xc18c,	0x09ff, 0xc18c,		0x21, 0
	.dw 0x0a40, 0xc18c,	0x0a7f, 0xc18c,		0x21, 0
	.dw 0x0ac0, 0xc18c,	0x0aff, 0xc18c,		0x21, 0
	.dw 0x0b40, 0xc18c,	0x0b7f, 0xc18c,		0x21, 0
	.dw 0x0bc0, 0xc18c,	0x0bff, 0xc18c,		0x21, 0
	.dw 0x0c40, 0xc18c,	0x0c7f, 0xc18c,		0x21, 0
	.dw 0x0cc0, 0xc18c,	0x0cff, 0xc18c,		0x21, 0
	.dw 0x0d40, 0xc18c,	0x0d7f, 0xc18c,		0x21, 0
	.dw 0x0dc0, 0xc18c,	0x0dff, 0xc18c,		0x21, 0
	.dw 0x0e40, 0xc18c,	0x0e7f, 0xc18c,		0x21, 0
	.dw 0x0ec0, 0xc18c,	0x0eff, 0xc18c,		0x21, 0
	.dw 0x0f40, 0xc18c,	0x0f7f, 0xc18c,		0x21, 0
	.dw 0x0fc0, 0xc18c,	0x0fff, 0xc18c,		0x21, 0
	.dw 0x1040, 0xc18c,	0x107f, 0xc18c,		0x21, 0
	.dw 0x10c0, 0xc18c,	0x10ff, 0xc18c,		0x21, 0
	.dw 0x1140, 0xc18c,	0x117f, 0xc18c,		0x21, 0
	.dw 0x11c0, 0xc18c,	0x11ff, 0xc18c,		0x21, 0
	.dw 0x1240, 0xc18c,	0x127f, 0xc18c,		0x21, 0
	.dw 0x12c0, 0xc18c,	0x12ff, 0xc18c,		0x21, 0
	.dw 0x1340, 0xc18c,	0x137f, 0xc18c,		0x21, 0
	.dw 0x13c0, 0xc18c,	0x13ff, 0xc18c,		0x21, 0
	.dw 0x1440, 0xc18c,	0x147f, 0xc18c,		0x21, 0
	.dw 0x14c0, 0xc18c,	0x14ff, 0xc18c,		0x21, 0
	.dw 0x1540, 0xc18c,	0x157f, 0xc18c,		0x21, 0
	.dw 0x15c0, 0xc18c,	0x15ff, 0xc18c,		0x21, 0
	.dw 0x1640, 0xc18c,	0x167f, 0xc18c,		0x21, 0
	.dw 0x16c0, 0xc18c,	0x16ff, 0xc18c,		0x21, 0
	.dw 0x1740, 0xc18c,	0x177f, 0xc18c,		0x21, 0
	.dw 0x17c0, 0xc18c,	0x17ff, 0xc18c,		0x21, 0
	.dw 0x1840, 0xc18c,	0x187f, 0xc18c,		0x21, 0
	.dw 0x18c0, 0xc18c,	0x18ff, 0xc18c,		0x21, 0
	.dw 0x1940, 0xc18c,	0x197f, 0xc18c,		0x21, 0
	.dw 0x19c0, 0xc18c,	0x1fff, 0xc18c,		0x21, 0
	.dw 0x2040, 0xc18c,	0x207f, 0xc18c,		0x21, 0
	.dw 0x20c0, 0xc18c,	0x20ff, 0xc18c,		0x21, 0
	.dw 0x2140, 0xc18c,	0x217f, 0xc18c,		0x21, 0
	.dw 0x21c0, 0xc18c,	0x21ff, 0xc18c,		0x21, 0
	.dw 0x2240, 0xc18c,	0x227f, 0xc18c,		0x21, 0
	.dw 0x22c0, 0xc18c,	0x22ff, 0xc18c,		0x21, 0
	.dw 0x2340, 0xc18c,	0x237f, 0xc18c,		0x21, 0
	.dw 0x23c0, 0xc18c,	0x23ff, 0xc18c,		0x21, 0
	.dw 0x2440, 0xc18c,	0x247f, 0xc18c,		0x21, 0
	.dw 0x24c0, 0xc18c,	0x24ff, 0xc18c,		0x21, 0
	.dw 0x2540, 0xc18c,	0x257f, 0xc18c,		0x21, 0
	.dw 0x25c0, 0xc18c,	0x25ff, 0xc18c,		0x21, 0
	.dw 0x2640, 0xc18c,	0x267f, 0xc18c,		0x21, 0
	.dw 0x26c0, 0xc18c,	0x26ff, 0xc18c,		0x21, 0
	.dw 0x2740, 0xc18c,	0x277f, 0xc18c,		0x21, 0
	.dw 0x27c0, 0xc18c,	0x27ff, 0xc18c,		0x21, 0
	.dw 0x2840, 0xc18c,	0x287f, 0xc18c,		0x21, 0
	.dw 0x28c0, 0xc18c,	0x28ff, 0xc18c,		0x21, 0
	.dw 0x2940, 0xc18c,	0x297f, 0xc18c,		0x21, 0
	.dw 0x29c0, 0xc18c,	0x29ff, 0xc18c,		0x21, 0
	.dw 0x2a40, 0xc18c,	0x2a7f, 0xc18c,		0x21, 0
	.dw 0x2ac0, 0xc18c,	0x2aff, 0xc18c,		0x21, 0
	.dw 0x2b40, 0xc18c,	0x2b7f, 0xc18c,		0x21, 0
	.dw 0x2bc0, 0xc18c,	0x2bff, 0xc18c,		0x21, 0
	.dw 0x2c40, 0xc18c,	0x2c7f, 0xc18c,		0x21, 0
	.dw 0x2cc0, 0xc18c,	0x2cff, 0xc18c,		0x21, 0
	.dw 0x2d40, 0xc18c,	0x2d7f, 0xc18c,		0x21, 0
	.dw 0x2dc0, 0xc18c,	0x2dff, 0xc18c,		0x21, 0
	.dw 0x2e40, 0xc18c,	0x2e7f, 0xc18c,		0x21, 0
	.dw 0x2ec0, 0xc18c,	0x2eff, 0xc18c,		0x21, 0
	.dw 0x2f40, 0xc18c,	0x2f7f, 0xc18c,		0x21, 0
	.dw 0x2fc0, 0xc18c,	0x2fff, 0xc18c,		0x21, 0
	.dw 0x3040, 0xc18c,	0x307f, 0xc18c,		0x21, 0
	.dw 0x30c0, 0xc18c,	0x30ff, 0xc18c,		0x21, 0
	.dw 0x3140, 0xc18c,	0x317f, 0xc18c,		0x21, 0
	.dw 0x31c0, 0xc18c,	0x31ff, 0xc18c,		0x21, 0
	.dw 0x3240, 0xc18c,	0x327f, 0xc18c,		0x21, 0
	.dw 0x32c0, 0xc18c,	0x32ff, 0xc18c,		0x21, 0
	.dw 0x3340, 0xc18c,	0x337f, 0xc18c,		0x21, 0
	.dw 0x33c0, 0xc18c,	0x33ff, 0xc18c,		0x21, 0
	.dw 0x3440, 0xc18c,	0x347f, 0xc18c,		0x21, 0
	.dw 0x34c0, 0xc18c,	0x34ff, 0xc18c,		0x21, 0
	.dw 0x3540, 0xc18c,	0x357f, 0xc18c,		0x21, 0
	.dw 0x35c0, 0xc18c,	0x35ff, 0xc18c,		0x21, 0
	.dw 0x3640, 0xc18c,	0x367f, 0xc18c,		0x21, 0
	.dw 0x36c0, 0xc18c,	0x36ff, 0xc18c,		0x21, 0
	.dw 0x3740, 0xc18c,	0x377f, 0xc18c,		0x21, 0
	.dw 0x37c0, 0xc18c,	0x37ff, 0xc18c,		0x21, 0
	.dw 0x3840, 0xc18c,	0x387f, 0xc18c,		0x21, 0
	.dw 0x38c0, 0xc18c,	0x38ff, 0xc18c,		0x21, 0
	.dw 0x3940, 0xc18c,	0x397f, 0xc18c,		0x21, 0
	.dw 0x39c0, 0xc18c,	0x3fff, 0xc18c,		0x21, 0
	.dw 0x4040, 0xc18c,	0x407f, 0xc18c,		0x21, 0
	.dw 0x40c0, 0xc18c,	0x40ff, 0xc18c,		0x21, 0
	.dw 0x4140, 0xc18c,	0x417f, 0xc18c,		0x21, 0
	.dw 0x41c0, 0xc18c,	0x41ff, 0xc18c,		0x21, 0
	.dw 0x4240, 0xc18c,	0x427f, 0xc18c,		0x21, 0
	.dw 0x42c0, 0xc18c,	0x42ff, 0xc18c,		0x21, 0
	.dw 0x4340, 0xc18c,	0x437f, 0xc18c,		0x21, 0
	.dw 0x43c0, 0xc18c,	0x43ff, 0xc18c,		0x21, 0
	.dw 0x4440, 0xc18c,	0x447f, 0xc18c,		0x21, 0
	.dw 0x44c0, 0xc18c,	0x44ff, 0xc18c,		0x21, 0
	.dw 0x4540, 0xc18c,	0x457f, 0xc18c,		0x21, 0
	.dw 0x45c0, 0xc18c,	0x45ff, 0xc18c,		0x21, 0
	.dw 0x4640, 0xc18c,	0x467f, 0xc18c,		0x21, 0
	.dw 0x46c0, 0xc18c,	0x46ff, 0xc18c,		0x21, 0
	.dw 0x4740, 0xc18c,	0x477f, 0xc18c,		0x21, 0
	.dw 0x47c0, 0xc18c,	0x47ff, 0xc18c,		0x21, 0
	.dw 0x4840, 0xc18c,	0x487f, 0xc18c,		0x21, 0
	.dw 0x48c0, 0xc18c,	0x48ff, 0xc18c,		0x21, 0
	.dw 0x4940, 0xc18c,	0x497f, 0xc18c,		0x21, 0
	.dw 0x49c0, 0xc18c,	0x49ff, 0xc18c,		0x21, 0
	.dw 0x4a40, 0xc18c,	0x4a7f, 0xc18c,		0x21, 0
	.dw 0x4ac0, 0xc18c,	0x4aff, 0xc18c,		0x21, 0
	.dw 0x4b40, 0xc18c,	0x4b7f, 0xc18c,		0x21, 0
	.dw 0x4bc0, 0xc18c,	0x4bff, 0xc18c,		0x21, 0
	.dw 0x4c40, 0xc18c,	0x4c7f, 0xc18c,		0x21, 0
	.dw 0x4cc0, 0xc18c,	0x4cff, 0xc18c,		0x21, 0
	.dw 0x4d40, 0xc18c,	0x4d7f, 0xc18c,		0x21, 0
	.dw 0x4dc0, 0xc18c,	0x4dff, 0xc18c,		0x21, 0
	.dw 0x4e40, 0xc18c,	0x4e7f, 0xc18c,		0x21, 0
	.dw 0x4ec0, 0xc18c,	0x4eff, 0xc18c,		0x21, 0
	.dw 0x4f40, 0xc18c,	0x4f7f, 0xc18c,		0x21, 0
	.dw 0x4fc0, 0xc18c,	0x4fff, 0xc18c,		0x21, 0
	.dw 0x5040, 0xc18c,	0x507f, 0xc18c,		0x21, 0
	.dw 0x50c0, 0xc18c,	0x50ff, 0xc18c,		0x21, 0
	.dw 0x5140, 0xc18c,	0x517f, 0xc18c,		0x21, 0
	.dw 0x51c0, 0xc18c,	0x51ff, 0xc18c,		0x21, 0
	.dw 0x5240, 0xc18c,	0x527f, 0xc18c,		0x21, 0
	.dw 0x52c0, 0xc18c,	0x52ff, 0xc18c,		0x21, 0
	.dw 0x5340, 0xc18c,	0x537f, 0xc18c,		0x21, 0
	.dw 0x53c0, 0xc18c,	0x53ff, 0xc18c,		0x21, 0
	.dw 0x5440, 0xc18c,	0x547f, 0xc18c,		0x21, 0
	.dw 0x54c0, 0xc18c,	0x54ff, 0xc18c,		0x21, 0
	.dw 0x5540, 0xc18c,	0x557f, 0xc18c,		0x21, 0
	.dw 0x55c0, 0xc18c,	0x55ff, 0xc18c,		0x21, 0
	.dw 0x5640, 0xc18c,	0x567f, 0xc18c,		0x21, 0
	.dw 0x56c0, 0xc18c,	0x56ff, 0xc18c,		0x21, 0
	.dw 0x5740, 0xc18c,	0x577f, 0xc18c,		0x21, 0
	.dw 0x57c0, 0xc18c,	0x57ff, 0xc18c,		0x21, 0
	.dw 0x5840, 0xc18c,	0x587f, 0xc18c,		0x21, 0
	.dw 0x58c0, 0xc18c,	0x58ff, 0xc18c,		0x21, 0
	.dw 0x5940, 0xc18c,	0x597f, 0xc18c,		0x21, 0
	.dw 0x59c0, 0xc18c,	0x5fff, 0xc18c,		0x21, 0
	.dw 0x6040, 0xc18c,	0x607f, 0xc18c,		0x21, 0
	.dw 0x60c0, 0xc18c,	0x60ff, 0xc18c,		0x21, 0
	.dw 0x6140, 0xc18c,	0x617f, 0xc18c,		0x21, 0
	.dw 0x61c0, 0xc18c,	0x61ff, 0xc18c,		0x21, 0
	.dw 0x6240, 0xc18c,	0x627f, 0xc18c,		0x21, 0
	.dw 0x62c0, 0xc18c,	0x62ff, 0xc18c,		0x21, 0
	.dw 0x6340, 0xc18c,	0x637f, 0xc18c,		0x21, 0
	.dw 0x63c0, 0xc18c,	0x63ff, 0xc18c,		0x21, 0
	.dw 0x6440, 0xc18c,	0x647f, 0xc18c,		0x21, 0
	.dw 0x64c0, 0xc18c,	0x64ff, 0xc18c,		0x21, 0
	.dw 0x6540, 0xc18c,	0x657f, 0xc18c,		0x21, 0
	.dw 0x65c0, 0xc18c,	0x65ff, 0xc18c,		0x21, 0
	.dw 0x6640, 0xc18c,	0x667f, 0xc18c,		0x21, 0
	.dw 0x66c0, 0xc18c,	0x66ff, 0xc18c,		0x21, 0
	.dw 0x6740, 0xc18c,	0x677f, 0xc18c,		0x21, 0
	.dw 0x67c0, 0xc18c,	0x67ff, 0xc18c,		0x21, 0
	.dw 0x6840, 0xc18c,	0x687f, 0xc18c,		0x21, 0
	.dw 0x68c0, 0xc18c,	0x68ff, 0xc18c,		0x21, 0
	.dw 0x6940, 0xc18c,	0x697f, 0xc18c,		0x21, 0
	.dw 0x69c0, 0xc18c,	0x69ff, 0xc18c,		0x21, 0
	.dw 0x6a40, 0xc18c,	0x6a7f, 0xc18c,		0x21, 0
	.dw 0x6ac0, 0xc18c,	0x6aff, 0xc18c,		0x21, 0
	.dw 0x6b40, 0xc18c,	0x6b7f, 0xc18c,		0x21, 0
	.dw 0x6bc0, 0xc18c,	0x6bff, 0xc18c,		0x21, 0
	.dw 0x6c40, 0xc18c,	0x6c7f, 0xc18c,		0x21, 0
	.dw 0x6cc0, 0xc18c,	0x6cff, 0xc18c,		0x21, 0
	.dw 0x6d40, 0xc18c,	0x6d7f, 0xc18c,		0x21, 0
	.dw 0x6dc0, 0xc18c,	0x6dff, 0xc18c,		0x21, 0
	.dw 0x6e40, 0xc18c,	0x6e7f, 0xc18c,		0x21, 0
	.dw 0x6ec0, 0xc18c,	0x6eff, 0xc18c,		0x21, 0
	.dw 0x6f40, 0xc18c,	0x6f7f, 0xc18c,		0x21, 0
	.dw 0x6fc0, 0xc18c,	0x6fff, 0xc18c,		0x21, 0
	.dw 0x7040, 0xc18c,	0x707f, 0xc18c,		0x21, 0
	.dw 0x70c0, 0xc18c,	0x70ff, 0xc18c,		0x21, 0
	.dw 0x7140, 0xc18c,	0x717f, 0xc18c,		0x21, 0
	.dw 0x71c0, 0xc18c,	0x71ff, 0xc18c,		0x21, 0
	.dw 0x7240, 0xc18c,	0x727f, 0xc18c,		0x21, 0
	.dw 0x72c0, 0xc18c,	0x72ff, 0xc18c,		0x21, 0
	.dw 0x7340, 0xc18c,	0x737f, 0xc18c,		0x21, 0
	.dw 0x73c0, 0xc18c,	0x73ff, 0xc18c,		0x21, 0
	.dw 0x7440, 0xc18c,	0x747f, 0xc18c,		0x21, 0
	.dw 0x74c0, 0xc18c,	0x74ff, 0xc18c,		0x21, 0
	.dw 0x7540, 0xc18c,	0x757f, 0xc18c,		0x21, 0
	.dw 0x75c0, 0xc18c,	0x75ff, 0xc18c,		0x21, 0
	.dw 0x7640, 0xc18c,	0x767f, 0xc18c,		0x21, 0
	.dw 0x76c0, 0xc18c,	0x76ff, 0xc18c,		0x21, 0
	.dw 0x7740, 0xc18c,	0x777f, 0xc18c,		0x21, 0
	.dw 0x77c0, 0xc18c,	0x77ff, 0xc18c,		0x21, 0
	.dw 0x7840, 0xc18c,	0x787f, 0xc18c,		0x21, 0
	.dw 0x78c0, 0xc18c,	0x78ff, 0xc18c,		0x21, 0
	.dw 0x7940, 0xc18c,	0x797f, 0xc18c,		0x21, 0
	.dw 0x79c0, 0xc18c,	0x7fff, 0xc18c,		0x21, 0
	.dw 0x8040, 0xc18c,	0x807f, 0xc18c,		0x21, 0
	.dw 0x80c0, 0xc18c,	0x80ff, 0xc18c,		0x21, 0
	.dw 0x8140, 0xc18c,	0x817f, 0xc18c,		0x21, 0
	.dw 0x81c0, 0xc18c,	0x81ff, 0xc18c,		0x21, 0
	.dw 0x8240, 0xc18c,	0x827f, 0xc18c,		0x21, 0
	.dw 0x82c0, 0xc18c,	0x82ff, 0xc18c,		0x21, 0
	.dw 0x8340, 0xc18c,	0x837f, 0xc18c,		0x21, 0
	.dw 0x83c0, 0xc18c,	0x83ff, 0xc18c,		0x21, 0
	.dw 0x8440, 0xc18c,	0x847f, 0xc18c,		0x21, 0
	.dw 0x84c0, 0xc18c,	0x84ff, 0xc18c,		0x21, 0
	.dw 0x8540, 0xc18c,	0x857f, 0xc18c,		0x21, 0
	.dw 0x85c0, 0xc18c,	0x85ff, 0xc18c,		0x21, 0
	.dw 0x8640, 0xc18c,	0x867f, 0xc18c,		0x21, 0
	.dw 0x86c0, 0xc18c,	0x86ff, 0xc18c,		0x21, 0
	.dw 0x8740, 0xc18c,	0x877f, 0xc18c,		0x21, 0
	.dw 0x87c0, 0xc18c,	0x87ff, 0xc18c,		0x21, 0
	.dw 0x8840, 0xc18c,	0x887f, 0xc18c,		0x21, 0
	.dw 0x88c0, 0xc18c,	0x88ff, 0xc18c,		0x21, 0
	.dw 0x8940, 0xc18c,	0x897f, 0xc18c,		0x21, 0
	.dw 0x89c0, 0xc18c,	0x89ff, 0xc18c,		0x21, 0
	.dw 0x8a40, 0xc18c,	0x8a7f, 0xc18c,		0x21, 0
	.dw 0x8ac0, 0xc18c,	0x8aff, 0xc18c,		0x21, 0
	.dw 0x8b40, 0xc18c,	0x8b7f, 0xc18c,		0x21, 0
	.dw 0x8bc0, 0xc18c,	0x8bff, 0xc18c,		0x21, 0
	.dw 0x8c40, 0xc18c,	0x8c7f, 0xc18c,		0x21, 0
	.dw 0x8cc0, 0xc18c,	0x8cff, 0xc18c,		0x21, 0
	.dw 0x8d40, 0xc18c,	0x8d7f, 0xc18c,		0x21, 0
	.dw 0x8dc0, 0xc18c,	0x8dff, 0xc18c,		0x21, 0
	.dw 0x8e40, 0xc18c,	0x8e7f, 0xc18c,		0x21, 0
	.dw 0x8ec0, 0xc18c,	0x8eff, 0xc18c,		0x21, 0
	.dw 0x8f40, 0xc18c,	0x8f7f, 0xc18c,		0x21, 0
	.dw 0x8fc0, 0xc18c,	0x8fff, 0xc18c,		0x21, 0
	.dw 0x9040, 0xc18c,	0x907f, 0xc18c,		0x21, 0
	.dw 0x90c0, 0xc18c,	0x90ff, 0xc18c,		0x21, 0
	.dw 0x9140, 0xc18c,	0x917f, 0xc18c,		0x21, 0
	.dw 0x91c0, 0xc18c,	0x91ff, 0xc18c,		0x21, 0
	.dw 0x9240, 0xc18c,	0x92