.ig
This file is part of groff, the GNU roff type-setting system.

Copyright (C) 2002, 2003, 2005, 2008, 2009, 2011, 2012, 2013
  Free Software Foundation, Inc.
written by Werner Lemberg <wl@gnu.org>
revised 2012 by Peter Schaffter <peter@schaffter.ca>

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or
any later version published by the Free Software Foundation; with the
Invariant Sections being this .ig-section and AUTHORS, with no
Front-Cover Texts, and with no Back-Cover Texts.

A copy of the Free Documentation License is included as a file called
FDL in the main directory of the groff source package.
..
.
.do nr groff_mom_C \n[.C]
.cp 0
.
.de TQ
.br
.ns
.TP \\$1
..
.
.TH GROFF_MOM @MAN7EXT@ "@MDATE@" "Groff Version @VERSION@"
.
.
.SH NAME
.
groff_mom \- groff `mom' macros
.
.
.SH SYNOPSIS
.
.SY pdfmom
.OP \-Tps "\fR[pdfroff options]"
[groff options]
.I files .\|.\|.
.YS
.
.SY groff
.OP \-mom
.I files .\|.\|.
.YS
.
.SY groff
.OP "\-m mom"
.I files .\|.\|.
.YS
.
.SH DESCRIPTION
.
.B mom
is a macro set for groff, designed primarily to format documents for
PDF and PostScript output.
.P
.B mom
provides two categories of macros: macros for typesetting, and
macros for document processing.
The typesetting macros provide access to groff's typesetting
capabilities in ways that are simpler to master than groff's
primitives.
The document processing macros provide highly customizable markup
tags that allow the user to design and output professional-looking
documents with a minimum of typesetting intervention.
.P
Files processed with
.B pdfmom
(man(@MAN1EXT@)
.BR pdfmom\c
), with or without the
.RI -T ps
option, produce PDF documents.
The documents include a PDF outline that appears in the
\[oq]Contents\[cq] panel of document viewers, and may contain
clickable internal and external links.
.P
When
.RI -T ps
is absent,
.B groff's
native PDF driver,
.B gropdf\c
, is used to generate the output.
When given, the output is still PDF, but processing is passed over to
.B pdfroff\c
, which uses
.B groff's
PostScript driver,
.B grops\c
\&.
Not all PDF features are available when
.RI -T ps
is given; its primary use is to allow processing of files with
embedded PostScript images.
.P
Files processed with
.B groff -mom
(or
.BI "-m " mom
) produce PostScript output by default.
.P
mom comes with her own very complete documentation in HTML format.
A separate PDF manual,
.I Producing PDFs with groff and mom\c
, covers full mom/PDF usage.
.
.SH FILES
.TP
.B om.tmac
\[en] the main macro file
.TQ
.B mom.tmac
\[en] a wrapper file that calls om.tmac directly.
.
.TP
.UR \%@HTMLDOCDIR@/\:mom/\:toc.html
.UE
\[en] entry point to the HTML documentation
.
.TP
.BR \%@PDFDOCDIR@/\:mom-pdf.pdf
\[en] the PDF manual,
.I Producing PDFs with groff and mom
.
.TP
.B @EXAMPLEDIR@/mom/*.mom
\[en] example files using mom
.
.
.SH AUTHOR
.
.B mom
was written by
.MT peter@schaffter.ca
Peter Schaffter
.ME .
.br
PDF support was provided by
.MT deri@chuzzlewit.demon.co.uk
Deri James
.ME .
.sp
Please send bug reports to the
.MT bug-groff@gnu.org
groff-bug mailing list
.ME
or directly to the authors.
.
.cp \n[groff_mom_C]
.
.\" Local Variables:
.\" mode: nroff
.\" End:
