/*****************************************************************************\
  dj4100_cmap.cpp : Implimentation for the DJ4100 color maps

  Copyright (c) 1996 - 2006, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  \***************************************************************************/


#ifdef APDK_DJ3600

#include "config.h"

#include "global_types.h"

APDK_BEGIN_NAMESPACE

// 600x600x1, KCMY - Plain Normal

unsigned char ucMapDJ4100_KCMY_6x6x1[] =
{
  195,    37,    28,    16,   151,   131,    67,     9,   110,   219,   103,     2,    94,   238,   102,     0,    76,   243,    93,     0,    60,   245,    90,     0,    49,   246,    89,     0, 
   42,   247,    86,     0,    35,   248,    84,     0,    30,   249,    81,     0,    25,   250,    79,     0,    21,   250,    78,     0,    17,   251,    77,     0,    12,   252,    74,     0, 
    8,   253,    72,     0,     4,   254,    71,     0,     0,   255,    70,     0,   148,   130,    14,   114,    99,   232,    30,     0,   102,   236,   109,     0,    87,   240,   103,     0, 
   68,   244,   102,     0,    55,   246,    97,     0,    47,   246,    95,     0,    40,   247,    91,     0,    34,   248,    87,     0,    29,   249,    84,     0,    25,   250,    81,     0, 
   21,   250,    80,     0,    17,   251,    78,     0,    13,   252,    76,     0,     9,   253,    73,     0,     5,   254,    71,     0,     0,   254,    69,     0,   101,   222,     1,   210, 
   98,   220,     1,   117,    83,   237,    30,     0,    77,   241,    68,     0,    63,   244,    90,     0,    53,   246,    96,     0,    44,   247,    96,     0,    38,   248,    93,     0, 
   32,   248,    89,     0,    28,   249,    86,     0,    24,   250,    84,     0,    20,   250,    81,     0,    17,   251,    80,     0,    13,   252,    77,     0,     9,   253,    74,     0, 
    5,   253,    71,     0,     0,   253,    68,     0,    85,   224,     0,   211,    81,   227,     0,   145,    76,   233,     0,    54,    67,   239,    22,     0,    56,   243,    52,     0, 
   45,   246,    68,     0,    38,   247,    78,     0,    33,   248,    82,     0,    29,   249,    83,     0,    25,   250,    84,     0,    22,   250,    84,     0,    18,   251,    82,     0, 
   15,   252,    79,     0,    11,   252,    76,     0,     8,   253,    72,     0,     4,   254,    70,     0,     0,   253,    66,     0,    66,   224,     1,   218,    64,   227,     0,   178, 
   61,   233,     0,   114,    59,   237,     0,    40,    52,   243,    16,     0,    41,   246,    35,     0,    33,   248,    49,     0,    28,   249,    58,     0,    24,   250,    64,     0, 
   21,   250,    68,     0,    18,   251,    72,     0,    16,   251,    72,     0,    12,   252,    71,     0,     9,   253,    69,     0,     6,   253,    67,     0,     3,   254,    65,     0, 
    0,   250,    62,     0,    49,   226,     0,   228,    49,   226,     1,   200,    45,   233,     0,   152,    43,   237,     0,    88,    43,   242,     0,    30,    38,   246,    11,     0, 
   30,   248,    24,     0,    25,   249,    35,     0,    20,   250,    45,     0,    17,   251,    52,     0,    15,   252,    57,     0,    12,   252,    59,     0,    10,   253,    60,     0, 
    7,   253,    60,     0,     4,   253,    60,     0,     1,   251,    59,     0,     0,   240,    56,     0,    36,   227,     0,   237,    36,   225,     1,   217,    33,   232,     0,   183, 
   32,   236,     0,   129,    31,   241,     0,    71,    31,   245,     0,    26,    28,   248,     7,     0,    23,   249,    16,     0,    19,   250,    25,     0,    15,   251,    34,     0, 
   12,   252,    42,     0,     9,   252,    47,     0,     6,   252,    50,     0,     4,   249,    51,     0,     2,   245,    52,     0,     0,   238,    53,     2,     0,   225,    50,     0, 
   26,   226,     1,   246,    27,   227,     0,   234,    26,   228,     0,   208,    24,   234,     0,   164,    23,   239,     0,   108,    23,   244,     0,    60,    23,   247,     0,    22, 
   21,   250,     3,     0,    17,   251,    11,     0,    14,   252,    19,     0,    10,   252,    27,     0,     6,   250,    37,     3,     1,   242,    46,     8,     0,   233,    48,     7, 
    0,   224,    47,     5,     0,   217,    46,     2,     0,   209,    44,     0,    17,   220,     4,   249,    18,   227,     2,   246,    19,   227,     1,   228,    17,   233,     0,   194, 
   16,   237,     0,   144,    16,   241,     0,    93,    16,   245,     0,    51,    16,   249,     0,    21,    15,   251,     1,     0,    12,   252,     7,     0,     9,   251,    16,     2, 
    4,   247,    27,     7,     0,   234,    36,    10,     0,   223,    38,     7,     0,   213,    39,     4,     0,   204,    39,     2,     0,   196,    38,     0,    10,   214,     7,   249, 
   10,   220,     5,   249,    12,   228,     2,   241,    12,   230,     1,   214,    10,   234,     1,   177,     9,   237,     3,   127,    10,   242,     3,    81,    11,   247,     0,    45, 
   11,   250,     0,    20,    11,   252,     0,     0,     6,   247,    11,     6,     1,   242,    20,    10,     0,   230,    25,     9,     0,   220,    28,     6,     0,   210,    30,     4, 
    0,   199,    32,     2,     0,   188,    32,     0,     5,   212,     9,   250,     5,   216,     7,   250,     7,   224,     4,   247,     9,   228,     1,   227,     8,   233,     0,   199, 
    7,   235,     2,   158,     7,   239,     3,   112,     8,   245,     1,    71,     9,   249,     0,    40,     9,   251,     0,    18,     9,   253,     0,     0,     1,   243,    14,    10, 
    0,   230,    17,     8,     0,   219,    20,     5,     0,   209,    23,     3,     0,   198,    25,     2,     0,   186,    26,     0,     2,   212,    10,   250,     3,   215,     8,   250, 
    4,   221,     5,   249,     7,   228,     1,   241,     7,   231,     0,   216,     7,   234,     0,   184,     6,   237,     2,   142,     6,   242,     2,    98,     7,   247,     0,    63, 
    7,   250,     0,    36,     8,   251,     0,    17,     8,   253,     0,     0,     0,   240,    13,    10,     0,   224,    14,     6,     0,   211,    16,     3,     0,   199,    19,     1, 
    0,   186,    21,     0,     1,   213,     9,   250,     1,   215,     7,   250,     3,   219,     5,   250,     5,   226,     1,   248,     6,   229,     0,   230,     5,   233,     0,   205, 
    5,   234,     0,   167,     6,   238,     0,   123,     6,   244,     0,    85,     6,   248,     0,    56,     6,   250,     0,    34,     6,   252,     0,    16,     6,   253,     0,     0, 
    0,   237,    11,     7,     0,   218,    12,     3,     0,   202,    14,     1,     0,   189,    16,     0,     1,   215,     6,   250,     2,   217,     5,   250,     2,   219,     3,   250, 
    4,   224,     0,   249,     4,   229,     0,   242,     4,   231,     0,   218,     4,   233,     0,   189,     4,   236,     0,   149,     4,   240,     0,   109,     4,   245,     0,    77, 
    4,   249,     0,    51,     4,   251,     0,    31,     4,   252,     0,    15,     5,   254,     0,     0,     0,   233,     9,     5,     0,   212,    10,     2,     0,   194,    12,     0, 
    1,   217,     3,   250,     2,   218,     2,   250,     2,   220,     1,   250,     3,   223,     0,   250,     2,   228,     0,   247,     3,   229,     0,   227,     2,   231,     0,   204, 
    3,   233,     0,   172,     3,   237,     0,   133,     3,   242,     0,    99,     3,   247,     0,    70,     3,   249,     0,    47,     3,   251,     0,    29,     3,   253,     0,    14, 
    3,   254,     0,     0,     0,   228,     7,     2,     0,   204,     8,     0,     1,   220,     0,   250,     2,   220,     0,   250,     2,   220,     0,   250,     1,   222,     0,   250, 
    1,   225,     0,   247,     1,   226,     0,   232,     1,   228,     0,   213,     1,   230,     0,   188,     1,   234,     0,   156,     1,   239,     0,   120,     1,   243,     0,    90, 
    1,   247,     0,    65,     1,   250,     0,    44,     1,   252,     0,    28,     1,   253,     0,    14,     2,   255,     0,     0,     0,   224,     5,     0,     0,   221,     0,   250, 
    0,   221,     0,   250,     0,   221,     0,   250,     0,   221,     0,   250,     0,   221,     0,   244,     0,   222,     0,   234,     0,   224,     0,   219,     0,   227,     0,   200, 
    0,   230,     0,   175,     0,   235,     0,   142,     0,   240,     0,   110,     0,   243,     0,    83,     0,   247,     0,    60,     0,   249,     0,    42,     0,   251,     0,    27, 
    0,   254,     0,    14,     0,   255,     0,     0,   170,    27,    82,    59,   147,    60,   128,     8,   114,   177,   177,     2,    92,   230,   175,     2,    76,   237,   152,     2, 
   59,   243,   141,     1,    49,   248,   135,     0,    40,   249,   128,     0,    32,   250,   124,     0,    28,   250,   115,     0,    24,   250,   106,     0,    19,   251,    99,     0, 
   15,   252,    93,     0,    11,   252,    86,     0,     7,   253,    80,     0,     3,   253,    76,     0,     0,   249,    72,     0,   149,    27,    14,   130,   146,    49,    33,    18, 
   93,   238,   108,     0,    79,   239,   118,     1,    68,   245,   117,     0,    61,   246,   114,     0,    52,   247,   107,     0,    43,   247,   101,     0,    35,   248,    95,     0, 
   29,   249,    88,     0,    24,   250,    84,     0,    19,   251,    81,     0,    15,   252,    78,     0,    11,   252,    74,     0,     7,   253,    72,     0,     3,   253,    70,     0, 
    0,   241,    66,     0,   105,   173,     2,   232,   100,   224,     0,   209,    91,   185,    11,    13,    73,   235,    69,     1,    62,   244,    91,     0,    54,   246,    96,     0, 
   46,   247,    94,     0,    39,   247,    90,     0,    32,   248,    85,     0,    27,   249,    81,     0,    23,   250,    78,     0,    18,   251,    76,     0,    14,   252,    74,     0, 
   10,   253,    72,     0,     6,   253,    70,     0,     3,   253,    69,     0,     0,   243,    67,     0,    81,   210,     2,   240,    80,   219,     2,   196,    74,   224,     2,    95, 
   72,   219,     5,     8,    56,   238,    42,     2,    46,   245,    64,     0,    38,   247,    73,     0,    32,   248,    78,     0,    27,   249,    79,     0,    23,   250,    78,     0, 
   20,   251,    77,     0,    16,   251,    75,     0,    12,   252,    73,     0,     9,   253,    71,     0,     5,   254,    70,     0,     2,   253,    68,     0,     0,   242,    65,     0, 
   60,   221,     2,   243,    62,   223,     1,   217,    58,   231,     0,   155,    56,   228,     3,    74,    55,   222,     5,    14,    43,   241,    25,     1,    33,   247,    43,     0, 
   28,   249,    54,     0,    24,   250,    60,     0,    20,   250,    64,     0,    16,   251,    67,     0,    13,   252,    68,     0,    10,   253,    67,     0,     7,   253,    66,     0, 
    4,   254,    66,     0,     1,   252,    64,     0,     0,   238,    61,     0,    44,   225,     1,   242,    46,   225,     1,   229,    44,   229,     0,   188,    41,   235,     0,   124, 
   40,   236,     1,    57,    39,   241,     1,    13,    33,   247,    13,     0,    26,   249,    28,     0,    20,   250,    40,     0,    17,   251,    47,     0,    13,   252,    52,     0, 
   11,   252,    55,     0,     8,   253,    56,     0,     5,   254,    58,     0,     2,   253,    58,     0,     0,   247,    57,     0,     0,   229,    55,     0,    32,   226,     1,   246, 
   33,   227,     1,   238,    34,   226,     1,   211,    31,   234,     0,   163,    29,   239,     0,   100,    29,   243,     0,    47,    29,   246,     0,    14,    26,   248,     5,     0, 
   20,   250,    18,     0,    15,   251,    29,     0,    11,   252,    37,     0,     8,   253,    43,     0,     5,   254,    46,     0,     2,   253,    49,     0,     1,   249,    50,     0, 
    0,   235,    50,     0,     0,   217,    50,     0,    24,   221,     3,   249,    24,   227,     1,   246,    26,   227,     1,   229,    23,   232,     0,   193,    22,   237,     0,   139, 
   22,   242,     0,    84,    21,   246,     0,    42,    21,   248,     0,    16,    21,   249,     1,     1,    15,   250,    12,     0,    10,   252,    22,     1,     6,   252,    30,     0, 
    3,   249,    36,     0,     1,   243,    40,     0,     0,   231,    42,     1,     0,   218,    42,     0,     0,   206,    44,     0,    16,   214,     7,   249,    17,   222,     4,   249, 
   17,   228,     1,   242,    18,   228,     1,   217,    16,   234,     0,   176,    15,   240,     0,   120,    15,   244,     0,    72,    15,   247,     0,    37,    14,   249,     0,    18, 
   13,   248,     2,     6,     9,   249,    11,     4,     5,   249,    19,     4,     1,   241,    28,     5,     0,   229,    32,     3,     0,   216,    34,     1,     0,   205,    35,     0, 
    0,   193,    38,     0,     7,   207,    11,   250,     9,   215,     7,   250,    10,   224,     3,   248,    12,   228,     1,   229,    10,   233,     0,   199,     9,   237,     0,   153, 
    9,   242,     0,   103,     9,   246,     1,    63,     8,   247,     2,    36,     8,   249,     2,    19,     6,   244,     7,    13,     1,   241,    16,    13,     0,   236,    20,     9, 
    0,   225,    23,     4,     0,   212,    25,     1,     0,   198,    28,     0,     0,   181,    32,     0,     4,   205,    10,   250,     2,   209,    10,   250,     3,   217,     7,   250, 
    7,   228,     0,   243,     6,   231,     0,   217,     5,   235,     0,   183,     5,   239,     0,   134,     5,   241,     0,    87,     4,   243,     2,    55,     3,   243,     4,    34, 
    3,   244,     4,    19,     0,   236,    11,    17,     0,   229,    13,    10,     0,   220,    15,     5,     0,   211,    18,     1,     0,   197,    22,     0,     0,   179,    26,     0, 
    2,   204,    10,   250,     0,   207,     8,   250,     0,   213,     6,   250,     3,   224,     0,   249,     3,   229,     0,   233,     2,   233,     0,   205,     2,   233,     0,   161, 
    3,   233,     0,   110,     2,   236,     2,    74,     1,   237,     4,    50,     1,   238,     5,    31,     1,   239,     5,    19,     0,   228,     7,    12,     0,   217,     9,     6, 
    0,   208,    12,     2,     0,   197,    16,     0,     0,   180,    21,     0,     0,   205,    10,   250,     0,   207,     4,   250,     0,   212,     3,   250,     1,   219,     0,   248, 
    1,   223,     0,   236,     1,   225,     0,   211,     1,   225,     0,   177,     0,   227,     1,   132,     0,   229,     2,    94,     0,   231,     3,    65,     0,   231,     4,    42, 
    0,   234,     3,    27,     0,   235,     3,    15,     0,   221,     5,     8,     0,   208,     7,     4,     0,   197,    10,     1,     0,   182,    16,     0,     0,   206,     7,   250, 
    0,   207,     2,   249,     0,   209,     1,   246,     0,   211,     1,   241,     0,   214,     0,   230,     0,   214,     1,   209,     0,   214,     1,   183,     0,   218,     1,   145, 
    0,   221,     1,   107,     0,   225,     1,    78,     0,   227,     2,    55,     0,   228,     2,    36,     0,   231,     1,    22,     0,   230,     1,    11,     0,   215,     4,     5, 
    0,   200,     6,     2,     0,   186,    11,     0,     0,   209,     5,   250,     0,   203,     1,   242,     0,   203,     0,   237,     0,   204,     0,   232,     0,   206,     0,   224, 
    0,   205,     0,   208,     0,   206,     0,   186,     0,   210,     0,   155,     0,   214,     0,   121,     0,   218,     0,    92,     0,   222,     0,    67,     0,   224,     1,    47, 
    0,   226,     0,    31,     0,   228,     0,    18,     0,   226,     1,     8,     0,   209,     4,     3,     0,   194,     8,     0,     0,   211,     2,   250,     0,   201,     0,   237, 
    0,   199,     0,   231,     0,   200,     0,   227,     0,   201,     0,   220,     0,   200,     0,   207,     0,   201,     0,   189,     0,   204,     0,   164,     0,   209,     0,   134, 
    0,   213,     0,   105,     0,   218,     0,    80,     0,   221,     0,    60,     0,   223,     0,    41,     0,   226,     0,    27,     0,   228,     0,    15,     0,   225,     1,     5, 
    0,   208,     6,     0,     0,   214,     0,   250,     0,   207,     0,   229,     0,   207,     0,   228,     0,   207,     0,   225,     0,   207,     0,   220,     0,   207,     0,   210, 
    0,   207,     0,   195,     0,   209,     0,   175,     0,   214,     0,   149,     0,   218,     0,   121,     0,   224,     0,    95,     0,   229,     0,    72,     0,   231,     0,    54, 
    0,   234,     0,    36,     0,   236,     0,    23,     0,   237,     0,    12,     0,   239,     0,     0,   145,    17,   135,   102,   131,    12,   166,    60,   101,    79,   222,     0, 
   89,   147,   211,     0,    71,   193,   198,     1,    53,   222,   192,     2,    42,   242,   185,     3,    37,   243,   168,     2,    29,   249,   155,     1,    25,   251,   145,     0, 
   22,   251,   130,     0,    18,   251,   117,     0,    14,   252,   106,     0,     9,   253,    97,     0,     5,   253,    88,     0,     2,   250,    81,     0,     0,   240,    74,     0, 
  132,    13,    84,   167,   118,    26,   128,    92,    92,   123,   164,     6,    71,   196,   178,     5,    59,   236,   179,     3,    53,   241,   169,     2,    44,   246,   155,     1, 
   36,   250,   140,     0,    30,   250,   127,     0,    25,   250,   117,     0,    20,   251,   108,     0,    16,   251,   100,     0,    12,   252,    92,     0,     8,   253,    85,     0, 
    4,   254,    80,     0,     1,   251,    76,     0,     0,   232,    69,     0,   104,    14,     1,   239,   101,    24,    12,   186,    83,    65,    40,    24,    65,   189,    84,    11, 
   51,   238,   105,     3,    44,   246,   107,     1,    38,   248,   103,     0,    32,   249,    97,     0,    27,   249,    91,     0,    22,   250,    86,     0,    18,   251,    83,     0, 
   14,   252,    79,     0,    10,   253,    76,     0,     6,   253,    73,     0,     3,   253,    71,     0,     1,   249,    69,     0,     0,   227,    62,     0,    79,   114,     7,   248, 
   76,   143,     8,   228,    70,   157,    19,   120,    69,   145,    24,    26,    50,   211,    57,    11,    39,   243,    71,     2,    32,   248,    78,     0,    27,   249,    78,     0, 
   23,   250,    77,     0,    19,   251,    76,     0,    15,   251,    74,     0,    12,   252,    72,     0,     8,   253,    70,     0,     5,   254,    69,     0,     2,   253,    68,     0, 
    0,   245,    66,     0,     0,   225,    62,     0,    57,   166,    10,   248,    57,   197,     6,   242,    56,   209,     6,   194,    52,   191,    14,    95,    51,   168,    21,    28, 
   40,   219,    37,    10,    29,   245,    48,     1,    24,   249,    58,     0,    19,   251,    64,     0,    15,   251,    68,     0,    11,   252,    69,     0,     8,   253,    69,     0, 
    5,   254,    68,     0,     3,   253,    68,     0,     1,   249,    66,     0,     0,   237,    63,     0,     0,   220,    59,     0,    41,   197,     8,   248,    42,   213,     4,   245, 
   43,   223,     2,   224,    39,   227,     3,   155,    38,   209,    13,    75,    39,   207,    11,    23,    31,   240,    16,     2,    23,   247,    30,     1,    18,   250,    42,     0, 
   13,   251,    50,     0,    10,   253,    54,     0,     7,   253,    57,     0,     4,   253,    59,     0,     1,   251,    60,     0,     0,   243,    58,     0,     0,   231,    56,     0, 
    0,   214,    55,     0,    29,   209,     7,   248,    30,   218,     4,   247,    31,   225,     1,   237,    29,   231,     0,   191,    28,   234,     1,   120,    28,   235,     2,    57, 
   27,   240,     2,    20,    25,   245,     6,     2,    18,   248,    20,     1,    12,   250,    31,     2,     8,   251,    40,     2,     5,   252,    44,     0,     2,   252,    48,     0, 
    0,   247,    50,     0,     0,   234,    50,     0,     0,   220,    49,     0,     0,   207,    50,     0,    21,   209,     8,   249,    22,   216,     5,   249,    23,   226,     1,   245, 
   24,   227,     1,   214,    21,   235,     0,   161,    20,   239,     0,    96,    20,   242,     1,    49,    20,   244,     1,    21,    18,   243,     4,     5,    13,   245,    15,     3, 
    6,   246,    28,     7,     2,   243,    36,     7,     0,   239,    40,     5,     0,   233,    41,     1,     0,   220,    41,     0,     0,   210,    42,     0,     0,   200,    44,     0, 
   13,   204,    11,   249,    14,   212,     8,   249,    16,   223,     3,   248,    17,   227,     1,   230,    15,   233,     0,   193,    14,   237,     0,   135,    14,   239,     1,    80, 
   14,   241,     2,    43,    13,   241,     3,    23,    10,   239,     9,    13,     4,   238,    18,    13,     0,   238,    27,    12,     0,   229,    29,     6,     0,   219,    31,     2, 
    0,   209,    33,     0,     0,   200,    35,     0,     0,   187,    38,     0,     5,   201,    15,   250,     6,   207,    12,   250,     8,   217,     7,   249,    10,   228,     2,   240, 
   10,   231,     0,   211,     8,   235,     1,   168,     7,   238,     4,   114,     6,   239,     7,    73,     6,   238,     8,    44,     5,   239,     9,    27,     3,   234,    12,    18, 
    1,   231,    17,    14,     0,   227,    20,     8,     0,   217,    22,     3,     0,   205,    25,     0,     0,   191,    28,     0,     0,   172,    31,     0,     1,   198,    14,   250, 
    3,   203,    10,   250,     1,   211,    10,   250,     5,   225,     1,   248,     6,   229,     0,   226,     4,   233,     0,   193,     4,   233,     1,   140,     1,   233,     7,    97, 
    0,   234,    10,    65,     0,   233,    10,    42,     0,   235,     9,    27,     0,   228,    11,    18,     0,   221,    12,    10,     0,   215,    14,     4,     0,   205,    17,     1, 
    0,   189,    21,     0,     0,   168,    25,     0,     0,   196,    13,   250,     0,   200,     8,   250,     0,   209,     5,   250,     2,   220,     0,   249,     1,   228,     0,   239, 
    1,   229,     0,   209,     1,   225,     1,   161,     0,   224,     3,   112,     0,   225,     4,    77,     0,   226,     5,    52,     0,   227,     5,    33,     0,   229,     4,    20, 
    0,   219,     6,    12,     0,   211,     8,     6,     0,   202,    11,     2,     0,   190,    15,     0,     0,   170,    20,     0,     0,   196,    11,   250,     0,   199,     4,   250, 
    0,   206,     1,   248,     0,   210,     0,   239,     0,   212,     0,   225,     0,   211,     0,   202,     0,   211,     0,   168,     0,   214,     0,   126,     0,   217,     1,    91, 
    0,   219,     1,    63,     0,   218,     2,    41,     0,   222,     2,    26,     0,   222,     1,    15,     0,   211,     4,     8,     0,   200,     5,     3,     0,   190,     9,     1, 
    0,   174,    15,     0,     0,   197,     8,   250,     0,   197,     1,   248,     0,   195,     0,   236,     0,   196,     0,   225,     0,   197,     0,   212,     0,   195,     0,   193, 
    0,   196,     0,   167,     0,   200,     0,   133,     0,   204,     0,   101,     0,   209,     0,    74,     0,   211,     0,    53,     0,   213,     0,    34,     0,   215,     0,    22, 
    0,   214,     0,    11,     0,   202,     2,     5,     0,   191,     5,     2,     0,   178,    11,     0,     0,   200,     5,   250,     0,   192,     0,   241,     0,   182,     0,   224, 
    0,   182,     0,   213,     0,   182,     0,   203,     0,   182,     0,   187,     0,   183,     0,   165,     0,   188,     0,   136,     0,   192,     0,   108,     0,   197,     0,    84, 
    0,   202,     0,    62,     0,   204,     0,    43,     0,   207,     0,    29,     0,   209,     0,    18,     0,   207,     0,     9,     0,   195,     2,     3,     0,   184,     8,     0, 
    0,   202,     2,   250,     0,   188,     0,   234,     0,   175,     0,   212,     0,   173,     0,   201,     0,   173,     0,   193,     0,   173,     0,   181,     0,   175,     0,   162, 
    0,   180,     0,   138,     0,   185,     0,   114,     0,   190,     0,    92,     0,   196,     0,    71,     0,   199,     0,    53,     0,   202,     0,    36,     0,   204,     0,    25, 
    0,   206,     0,    14,     0,   204,     1,     5,     0,   195,     6,     0,     0,   205,     0,   251,     0,   199,     0,   230,     0,   190,     0,   208,     0,   190,     0,   204, 
    0,   190,     0,   197,     0,   189,     0,   188,     0,   189,     0,   173,     0,   192,     0,   152,     0,   197,     0,   128,     0,   202,     0,   105,     0,   208,     0,    84, 
    0,   213,     0,    65,     0,   215,     0,    49,     0,   218,     0,    33,     0,   221,     0,    21,     0,   222,     0,    10,     0,   224,     0,     0,   100,     0,   225,   205, 
  100,     1,   225,   135,    93,     1,   235,    24,    80,    51,   233,     0,    62,   117,   223,     0,    45,   162,   215,     0,    35,   190,   210,     0,    28,   213,   201,     2, 
   20,   232,   194,     4,    14,   247,   188,     5,    13,   249,   168,     3,    10,   250,   149,     3,     7,   250,   131,     3,     5,   250,   114,     1,     3,   246,   101,     0, 
    0,   239,    89,     2,     0,   229,    78,     0,   100,     5,   137,   225,    91,    19,   169,   155,    86,    24,   165,    41,    70,    75,   215,     3,    50,   164,   213,     0, 
   41,   205,   203,     1,    33,   228,   197,     1,    23,   246,   193,     4,    21,   246,   176,     3,    16,   252,   159,     0,    13,   252,   142,     0,    10,   253,   127,     0, 
    7,   253,   112,     0,     4,   253,   101,     0,     1,   250,    91,     0,     0,   240,    81,     0,     0,   222,    73,     0,    88,    13,    48,   221,    85,    26,    70,   173, 
   76,    53,    77,    76,    64,    86,   115,    22,    38,   183,   169,    13,    25,   229,   179,    10,    22,   243,   176,     4,    18,   249,   163,     2,    15,   251,   147,     1, 
   13,   252,   133,     0,    10,   252,   119,     1,     7,   252,   108,     1,     4,   252,    98,     0,     1,   251,    90,     0,     0,   243,    81,     0,     0,   232,    74,     0, 
    0,   215,    68,     0,    71,    37,    21,   250,    71,    42,    24,   223,    63,    74,    41,   115,    61,    74,    45,    37,    42,   161,    78,    27,    28,   226,    94,    13, 
   23,   244,    94,     2,    19,   247,    92,     1,    16,   249,    88,     1,    12,   250,    85,     2,     9,   251,    81,     2,     6,   251,    77,     2,     4,   251,    73,     0, 
    1,   250,    71,     0,     0,   240,    68,     0,     0,   227,    63,     0,     0,   211,    58,     0,    50,   104,    25,   249,    52,   120,    21,   245,    49,   135,    24,   196, 
   48,   134,    30,   107,    48,   124,    35,    40,    33,   185,    57,    25,    24,   227,    62,     7,    18,   244,    70,     1,    12,   250,    72,     2,     9,   252,    70,     0, 
    7,   253,    69,     0,     4,   254,    69,     0,     2,   251,    68,     0,     0,   244,    65,     0,     0,   232,    62,     0,     0,   219,    59,     0,     0,   205,    57,     0, 
   35,   147,    23,   249,    38,   167,    16,   249,    39,   185,    11,   241,    37,   195,    12,   182,    33,   172,    27,    95,    34,   153,    32,    41,    27,   196,    39,    19, 
   19,   228,    45,     6,    13,   239,    51,     2,     6,   247,    60,     6,     5,   250,    59,     0,     2,   250,    62,     0,     0,   242,    62,     0,     0,   230,    60,     0, 
    0,   220,    57,     0,     0,   210,    55,     0,     0,   199,    54,     0,    25,   173,    19,   249,    28,   189,    13,   249,    28,   202,     9,   247,    29,   220,     4,   226, 
   24,   216,    12,   147,    25,   190,    20,    73,    24,   190,    22,    34,    19,   220,    23,    13,    13,   232,    32,     7,     7,   235,    42,     8,     0,   239,    53,    13, 
    0,   240,    51,     5,     0,   236,    51,     1,     0,   224,    51,     0,     0,   213,    50,     0,     0,   204,    50,     0,     0,   193,    50,     0,    17,   188,    17,   249, 
   19,   197,    13,   249,    20,   207,     9,   249,    21,   225,     2,   241,    19,   228,     3,   189,    19,   220,     6,   110,    19,   216,     8,    56,    17,   221,    11,    28, 
   11,   228,    19,    16,     7,   231,    27,    12,     2,   229,    36,    12,     0,   225,    40,     9,     0,   222,    41,     3,     0,   215,    41,     0,     0,   207,    43,     0, 
    0,   199,    44,     0,     0,   187,    45,     0,     9,   191,    18,   250,    11,   198,    15,   250,    12,   206,    10,   249,    14,   223,     4,   246,    14,   228,     2,   211, 
   13,   225,     3,   147,    11,   223,     8,    92,     9,   224,    13,    55,     8,   227,    15,    33,     4,   227,    21,    23,     2,   226,    25,    16,     0,   222,    28,    11, 
    0,   214,    30,     5,     0,   207,    32,     1,     0,   199,    34,     0,     0,   190,    36,     0,     0,   177,    39,     0,     2,   189,    20,   250,     3,   195,    18,   250, 
    5,   204,    13,   250,     7,   219,     6,   247,     9,   226,     3,   223,     5,   225,     8,   179,     6,   221,     8,   119,     5,   222,    10,    77,     3,   224,    15,    52, 
    2,   225,    15,    33,     0,   222,    19,    24,     0,   218,    19,    14,     0,   214,    20,     7,     0,   206,    22,     2,     0,   194,    26,     0,     0,   181,    29,     0, 
    0,   163,    31,     0,     0,   187,    16,   250,     0,   192,    15,   250,     2,   201,    10,   250,     1,   214,     7,   249,     4,   226,     0,   237,     2,   224,     5,   199, 
    0,   219,    10,   145,     0,   219,    11,   100,     0,   220,    12,    68,     0,   220,    12,    44,     0,   221,    11,    28,     0,   215,    11,    18,     0,   209,    13,    10, 
    0,   204,    15,     4,     0,   195,    17,     0,     0,   178,    22,     0,     0,   155,    25,     0,     0,   186,    13,   250,     0,   188,     9,   250,     0,   198,     6,   250, 
    0,   210,     3,   248,     0,   220,     0,   240,     0,   219,     1,   208,     0,   211,     3,   159,     0,   210,     4,   112,     0,   212,     5,    79,     0,   213,     6,    53, 
    0,   214,     6,    33,     0,   216,     5,    21,     0,   208,     6,    13,     0,   200,     8,     7,     0,   194,    10,     2,     0,   179,    15,     0,     0,   157,    20,     0, 
    0,   185,    10,   250,     0,   186,     5,   251,     0,   194,     1,   248,     0,   197,     0,   235,     0,   199,     0,   219,     0,   198,     0,   196,     0,   196,     0,   163, 
    0,   199,     0,   123,     0,   202,     1,    90,     0,   204,     1,    63,     0,   205,     2,    41,     0,   208,     1,    26,     0,   209,     1,    16,     0,   199,     3,     9, 
    0,   191,     5,     3,     0,   181,     8,     0,     0,   162,    15,     0,     0,   185,     8,   251,     0,   183,     2,   249,     0,   180,     0,   237,     0,   175,     0,   218, 
    0,   175,     0,   201,     0,   175,     0,   182,     0,   177,     0,   156,     0,   182,     0,   125,     0,   186,     0,    96,     0,   190,     0,    71,     0,   194,     0,    51, 
    0,   197,     0,    33,     0,   199,     0,    21,     0,   198,     0,    12,     0,   190,     1,     5,     0,   181,     3,     1,     0,   167,    10,     0,     0,   187,     6,   251, 
    0,   179,     1,   244,     0,   168,     0,   224,     0,   158,     0,   199,     0,   157,     0,   183,     0,   159,     0,   166,     0,   162,     0,   144,     0,   166,     0,   122, 
    0,   171,     0,    99,     0,   176,     0,    78,     0,   181,     0,    59,     0,   185,     0,    41,     0,   188,     0,    28,     0,   190,     0,    18,     0,   189,     0,     9, 
    0,   181,     1,     3,     0,   173,     7,     0,     0,   191,     3,   251,     0,   176,     0,   237,     0,   161,     0,   211,     0,   149,     0,   185,     0,   148,     0,   170, 
    0,   150,     0,   156,     0,   153,     0,   139,     0,   156,     0,   121,     0,   161,     0,   102,     0,   166,     0,    83,     0,   172,     0,    65,     0,   177,     0,    49, 
    0,   181,     0,    34,     0,   184,     0,    24,     0,   186,     0,    14,     0,   185,     1,     6,     0,   182,     6,     0,     0,   195,     0,   251,     0,   187,     0,   232, 
    0,   179,     0,   211,     0,   169,     0,   185,     0,   169,     0,   177,     0,   170,     0,   166,     0,   172,     0,   152,     0,   175,     0,   133,     0,   179,     0,   113, 
    0,   184,     0,    95,     0,   190,     0,    76,     0,   196,     0,    59,     0,   200,     0,    44,     0,   203,     0,    30,     0,   206,     0,    19,     0,   207,     0,     8, 
    0,   208,     0,     0,    87,     1,   225,   206,    85,     1,   227,   162,    78,     0,   236,    91,    73,     0,   243,     9,    61,    35,   239,     0,    42,    89,   230,     0, 
   29,   125,   224,     0,    21,   159,   217,     0,    14,   187,   208,     3,     8,   212,   198,     8,     3,   226,   185,    14,     0,   228,   171,    14,     0,   227,   149,    11, 
    0,   226,   129,     8,     0,   223,   112,     5,     0,   219,    97,     2,     0,   213,    84,     0,    80,     4,   182,   240,    77,     6,   209,   219,    71,    11,   204,   126, 
   65,     7,   225,    18,    45,    77,   229,     2,    32,   129,   222,     0,    24,   170,   216,     0,    17,   198,   210,     0,    11,   220,   203,     1,     6,   236,   196,     3, 
    4,   245,   182,     0,     2,   246,   163,     0,     1,   242,   136,     0,     0,   236,   117,     1,     0,   230,   100,     0,     0,   221,    87,     0,     0,   208,    80,     0, 
   72,    12,   101,   249,    74,    16,   112,   223,    70,    46,    97,   111,    59,    41,   134,    50,    38,    92,   190,    17,    24,   145,   207,     7,    15,   187,   208,     2, 
    8,   214,   203,     4,     3,   233,   193,     4,     2,   244,   183,     0,     1,   242,   160,     0,     0,   239,   137,     1,     0,   234,   116,     0,     0,   228,   101,     0, 
    0,   221,    88,     0,     0,   213,    79,     0,     0,   200,    74,     0,    57,    34,    61,   229,    64,    29,    58,   225,    61,    51,    65,   140,    51,    66,    75,    75, 
   39,    93,   104,    37,    15,   166,   151,    40,     2,   209,   163,    35,     0,   223,   161,    21,     0,   228,   147,     9,     0,   234,   135,     3,     0,   232,   118,     2, 
    0,   230,   103,     1,     0,   224,    91,     1,     0,   218,    82,     0,     0,   212,    76,     0,     0,   205,    70,     0,     0,   193,    66,     0,    40,    60,    45,   250, 
   43,    72,    39,   242,    41,    80,    47,   183,    41,    81,    49,   101,    38,    85,    52,    52,    20,   153,    86,    54,    13,   196,    90,    28,     5,   224,    97,    21, 
    4,   234,    87,    11,     2,   243,    82,     5,     2,   244,    74,     0,     1,   242,    71,     0,     0,   232,    67,     0,     0,   220,    63,     0,     0,   210,    60,     0, 
    0,   201,    58,     0,     0,   189,    54,     0,    25,   108,    42,   250,    31,   115,    35,   249,    32,   119,    34,   239,    31,   126,    36,   179,    26,   134,    47,   113, 
   26,   131,    51,    64,    15,   171,    68,    47,     5,   208,    76,    35,     0,   222,    79,    26,     1,   226,    71,    13,     0,   231,    65,     6,     0,   230,    61,     1, 
    0,   220,    59,     0,     0,   211,    56,     0,     0,   202,    55,     0,     0,   194,    54,     0,     0,   182,    53,     0,    16,   137,    37,   250,    22,   149,    29,   249, 
   23,   160,    25,   249,    24,   176,    20,   234,    19,   179,    30,   166,    16,   165,    42,   102,    13,   158,    51,    67,     6,   190,    59,    48,     3,   210,    58,    28, 
    0,   215,    59,    20,     0,   217,    55,    11,     0,   216,    53,     3,     0,   210,    52,     0,     0,   201,    52,     0,     0,   192,    51,     0,     0,   184,    51,     0, 
    0,   172,    50,     0,    10,   159,    32,   250,    14,   169,    26,   250,    15,   178,    21,   249,    16,   195,    15,   246,    13,   204,    18,   205,    13,   192,    23,   130, 
    7,   181,    40,    90,     4,   189,    45,    63,     1,   209,    45,    41,     0,   213,    44,    26,     0,   210,    44,    15,     0,   208,    43,     7,     0,   205,    43,     2, 
    0,   198,    43,     0,     0,   189,    44,     0,     0,   179,    44,     0,     0,   166,    44,     0,     3,   168,    30,   250,     6,   178,    26,   250,     7,   186,    21,   250, 
    8,   198,    15,   248,     8,   212,    14,   227,     6,   207,    20,   169,     4,   202,    26,   113,     0,   204,    34,    78,     0,   209,    33,    51,     1,   210,    30,    29, 
    0,   210,    31,    18,     0,   204,    32,    10,     0,   198,    33,     5,     0,   193,    34,     1,     0,   183,    36,     0,     0,   171,    37,     0,     0,   159,    38,     0, 
    0,   172,    25,   250,     1,   179,    22,   250,     2,   187,    20,   250,     2,   199,    16,   249,     3,   214,    11,   235,     2,   209,    16,   191,     0,   205,    20,   137, 
    0,   205,    22,    92,     0,   206,    23,    60,     0,   209,    22,    38,     0,   206,    21,    24,     0,   203,    21,    14,     0,   198,    22,     6,     0,   191,    24,     1, 
    0,   178,    27,     0,     0,   163,    29,     0,     0,   149,    31,     0,     0,   170,    16,   251,     0,   175,    16,   250,     0,   184,    15,   250,     0,   197,    11,   250, 
    0,   211,     7,   244,     0,   207,    10,   202,     0,   201,    12,   150,     0,   200,    13,   104,     0,   201,    13,    70,     0,   203,    14,    46,     0,   204,    13,    29, 
    0,   199,    14,    18,     0,   195,    14,    10,     0,   191,    16,     4,     0,   180,    18,     0,     0,   160,    22,     0,     0,   140,    25,     0,     0,   170,    12,   251, 
    0,   171,    10,   251,     0,   180,     8,   251,     0,   194,     5,   250,     0,   205,     1,   242,     0,   200,     3,   205,     0,   193,     5,   159,     0,   191,     6,   114, 
    0,   193,     7,    80,     0,   196,     7,    55,     0,   198,     8,    34,     0,   199,     7,    22,     0,   192,     8,    13,     0,   187,     9,     7,     0,   182,    11,     2, 
    0,   164,    15,     0,     0,   141,    20,     0,     0,   170,     9,   251,     0,   168,     5,   251,     0,   175,     2,   250,     0,   181,     1,   240,     0,   183,     0,   222, 
    0,   182,     0,   195,     0,   180,     1,   161,     0,   181,     2,   122,     0,   184,     2,    90,     0,   187,     2,    64,     0,   188,     3,    42,     0,   192,     2,    27, 
    0,   194,     2,    16,     0,   185,     4,     9,     0,   178,     5,     4,     0,   167,     8,     0,     0,   146,    14,     0,     0,   170,     7,   251,     0,   166,     2,   251, 
    0,   166,     0,   242,     0,   160,     0,   221,     0,   155,     0,   195,     0,   156,     0,   171,     0,   159,     0,   146,     0,   162,     0,   119,     0,   166,     0,    93, 
    0,   171,     0,    69,     0,   176,     0,    50,     0,   179,     0,    33,     0,   182,     0,    21,     0,   182,     0,    12,     0,   175,     1,     6,     0,   166,     3,     1, 
    0,   153,    10,     0,     0,   171,     5,   251,     0,   163,     1,   247,     0,   154,     0,   228,     0,   143,     0,   200,     0,   137,     0,   171,     0,   138,     0,   149, 
    0,   140,     0,   131,     0,   142,     0,   113,     0,   147,     0,    94,     0,   152,     0,    74,     0,   158,     0,    58,     0,   162,     0,    40,     0,   166,     0,    28, 
    0,   168,     0,    18,     0,   168,     0,    10,     0,   163,     1,     3,     0,   159,     7,     0,     0,   174,     3,   251,     0,   161,     0,   240,     0,   148,     0,   213, 
    0,   135,     0,   185,     0,   129,     0,   155,     0,   129,     0,   137,     0,   131,     0,   123,     0,   133,     0,   108,     0,   136,     0,    94,     0,   141,     0,    79, 
    0,   147,     0,    63,     0,   152,     0,    48,     0,   156,     0,    34,     0,   160,     0,    24,     0,   162,     0,    15,     0,   162,     0,     7,     0,   167,     5,     0, 
    0,   180,     0,   251,     0,   173,     0,   235,     0,   165,     0,   215,     0,   156,     0,   191,     0,   150,     0,   160,     0,   152,     0,   147,     0,   154,     0,   134, 
    0,   156,     0,   119,     0,   160,     0,   104,     0,   164,     0,    89,     0,   171,     0,    71,     0,   177,     0,    56,     0,   183,     0,    40,     0,   186,     0,    28, 
    0,   190,     0,    18,     0,   192,     0,     7,     0,   193,     0,     0,    71,     1,   225,   219,    69,     1,   226,   190,    62,     0,   235,   140,    58,     0,   242,    55, 
   54,     3,   246,     0,    43,    27,   243,     0,    27,    67,   236,     0,    17,   101,   228,     1,    12,   131,   213,     3,     7,   163,   200,     8,     3,   184,   189,    12, 
    0,   196,   177,    13,     0,   197,   155,     9,     0,   199,   138,     7,     0,   201,   122,     4,     0,   198,   107,     2,     0,   194,    93,     0,    63,     5,   195,   244, 
   64,     3,   219,   236,    59,     3,   222,   178,    52,     3,   235,    74,    44,    23,   240,     1,    30,    63,   236,     0,    19,   102,   229,     0,    11,   141,   222,     1, 
    5,   172,   215,     0,     2,   192,   203,     0,     0,   203,   184,     2,     0,   206,   162,     1,     0,   206,   140,     1,     0,   205,   123,     1,     0,   202,   108,     0, 
    0,   197,    95,     0,     0,   187,    87,     0,    51,    18,   135,   249,    74,     7,   142,   248,    51,    23,   163,   198,    45,    29,   171,   103,    42,    31,   191,    14, 
   26,    70,   215,     6,    15,   112,   215,     3,     3,   160,   209,     9,     1,   182,   202,     1,     0,   194,   184,     0,     0,   199,   160,     0,     0,   202,   139,     0, 
    0,   201,   123,     0,     0,   199,   108,     0,     0,   195,    96,     0,     0,   190,    86,     0,     0,   180,    80,     0,    40,    40,    93,   228,    55,    22,   104,   249, 
   41,    41,   106,   204,    38,    57,   103,   115,    35,    56,   125,    63,    26,    73,   159,    29,     7,   134,   180,    29,     0,   168,   179,    21,     0,   179,   164,     6, 
    0,   188,   145,     0,     0,   192,   130,     0,     0,   193,   114,     0,     0,   191,   102,     0,     0,   188,    92,     0,     0,   185,    83,     0,     0,   181,    76,     0, 
    0,   170,    73,     0,    28,    55,    71,   243,    36,    48,    65,   247,    32,    57,    75,   211,    32,    67,    74,   128,    24,    88,    88,    99,    18,    98,   106,    65, 
    0,   154,   134,    57,     0,   170,   128,    27,     0,   181,   119,    12,     0,   188,   109,     3,     0,   190,    98,     1,     0,   188,    88,     0,     0,   185,    81,     0, 
    0,   181,    75,     0,     0,   178,    70,     0,     0,   172,    66,     0,     0,   161,    62,     0,    10,    82,    67,   250,    22,    77,    57,   250,    23,    78,    56,   241, 
   24,    78,    55,   158,    25,    84,    53,   103,     7,   126,    87,   100,     0,   153,    97,    79,     0,   175,    90,    42,     0,   190,    82,    23,     0,   198,    74,    11, 
    0,   203,    66,     3,     0,   201,    62,     0,     0,   196,    59,     0,     0,   189,    57,     0,     0,   181,    55,     0,     0,   172,    53,     0,     0,   162,    49,     0, 
    1,   110,    60,   250,    12,   116,    50,   250,    14,   118,    47,   248,    15,   124,    46,   226,     6,   137,    60,   178,     3,   146,    68,   132,     1,   148,    75,    97, 
    0,   160,    75,    62,     0,   177,    67,    31,     0,   186,    62,    17,     0,   190,    58,     7,     0,   193,    54,     1,     0,   188,    52,     0,     0,   180,    51,     0, 
    0,   171,    50,     0,     0,   161,    49,     0,     0,   150,    47,     0,     0,   125,    48,   250,     3,   139,    46,   250,     6,   145,    40,   250,     6,   155,    37,   247, 
    5,   166,    40,   216,     2,   169,    47,   159,     0,   155,    55,   109,     0,   148,    59,    77,     0,   162,    55,    47,     0,   179,    50,    24,     0,   184,    48,    13, 
    0,   185,    46,     6,     0,   182,    45,     1,     0,   172,    45,     0,     0,   160,    45,     0,     0,   151,    44,     0,     0,   143,    44,     0,     0,   135,    38,   250, 
    0,   151,    37,   250,     0,   157,    35,   250,     2,   166,    30,   249,     0,   180,    31,   234,     0,   179,    34,   181,     0,   172,    36,   124,     0,   159,    42,    84, 
    0,   162,    41,    56,     0,   182,    38,    33,     0,   185,    36,    19,     0,   180,    35,    10,     0,   178,    35,     4,     0,   170,    36,     0,     0,   157,    36,     0, 
    0,   146,    37,     0,     0,   138,    38,     0,     0,   146,    26,   251,     0,   154,    25,   251,     0,   161,    24,   250,     0,   172,    23,   250,     0,   186,    20,   243, 
    0,   183,    21,   197,     0,   176,    22,   139,     0,   175,    24,    95,     0,   179,    26,    64,     0,   185,    26,    42,     0,   185,    25,    24,     0,   182,    25,    14, 
    0,   178,    25,     6,     0,   168,    26,     1,     0,   152,    28,     0,     0,   141,    29,     0,     0,   133,    32,     0,     0,   147,    17,   251,     0,   153,    17,   251, 
    0,   160,    16,   251,     0,   172,    14,   251,     0,   187,    11,   246,     0,   179,    12,   205,     0,   173,    14,   151,     0,   173,    15,   106,     0,   177,    16,    73, 
    0,   181,    17,    49,     0,   183,    17,    31,     0,   180,    16,    19,     0,   177,    17,    10,     0,   171,    18,     3,     0,   156,    20,     0,     0,   138,    23,     0, 
    0,   127,    26,     0,     0,   148,    11,   251,     0,   150,    10,   251,     0,   158,     9,   251,     0,   169,     7,   251,     0,   179,     4,   242,     0,   172,     5,   205, 
    0,   167,     7,   157,     0,   166,     8,   114,     0,   170,     9,    82,     0,   175,    10,    57,     0,   177,    10,    37,     0,   180,     9,    23,     0,   173,     9,    14, 
    0,   168,    10,     7,     0,   161,    12,     2,     0,   142,    16,     0,     0,   126,    20,     0,     0,   151,     8,   251,     0,   149,     5,   252,     0,   154,     3,   251, 
    0,   162,     1,   247,     0,   165,     1,   229,     0,   160,     1,   195,     0,   158,     2,   155,     0,   158,     3,   119,     0,   161,     3,    90,     0,   165,     4,    65, 
    0,   168,     4,    43,     0,   173,     4,    28,     0,   175,     3,    18,     0,   165,     5,    10,     0,   158,     6,     4,     0,   147,     9,     1,     0,   130,    15,     0, 
    0,   154,     6,   251,     0,   148,     2,   251,     0,   147,     0,   245,     0,   145,     0,   226,     0,   140,     0,   200,     0,   138,     0,   169,     0,   140,     0,   140, 
    0,   142,     0,   115,     0,   146,     0,    93,     0,   151,     0,    69,     0,   156,     0,    51,     0,   160,     0,    34,     0,   163,     0,    22,     0,   162,     0,    13, 
    0,   155,     2,     7,     0,   147,     3,     2,     0,   136,    10,     0,     0,   156,     4,   251,     0,   145,     0,   247,     0,   138,     0,   229,     0,   130,     0,   204, 
    0,   124,     0,   175,     0,   121,     0,   142,     0,   122,     0,   121,     0,   124,     0,   105,     0,   127,     0,    90,     0,   132,     0,    72,     0,   136,     0,    57, 
    0,   140,     0,    41,     0,   144,     0,    28,     0,   146,     0,    19,     0,   146,     0,    11,     0,   142,     1,     4,     0,   142,     6,     0,     0,   158,     2,   251, 
    0,   144,     0,   239,     0,   132,     0,   215,     0,   123,     0,   189,     0,   117,     0,   157,     0,   112,     0,   126,     0,   112,     0,   109,     0,   114,     0,    98, 
    0,   117,     0,    88,     0,   121,     0,    74,     0,   125,     0,    61,     0,   129,     0,    47,     0,   133,     0,    34,     0,   136,     0,    24,     0,   138,     0,    15, 
    0,   139,     0,     8,     0,   150,     4,     0,     0,   162,     0,   251,     0,   155,     0,   235,     0,   149,     0,   217,     0,   142,     0,   196,     0,   136,     0,   168, 
    0,   133,     0,   134,     0,   134,     0,   120,     0,   136,     0,   108,     0,   138,     0,    97,     0,   142,     0,    86,     0,   148,     0,    71,     0,   155,     0,    56, 
    0,   162,     0,    41,     0,   167,     0,    28,     0,   172,     0,    17,     0,   174,     0,     7,     0,   175,     0,     0,    55,     0,   226,   234,    54,     1,   225,   206, 
   49,     0,   233,   171,    44,     0,   240,    99,    41,     0,   246,    28,    35,     6,   248,     0,    28,    23,   246,     0,    15,    56,   238,     1,     7,    88,   222,     7, 
    5,   113,   206,    10,     2,   137,   195,    12,     0,   153,   182,    12,     0,   158,   162,     8,     0,   167,   145,     5,     0,   173,   130,     3,     0,   174,   117,     2, 
    0,   172,   104,     0,    49,     6,   202,   246,    49,     4,   216,   241,    48,     2,   223,   210,    41,     1,   236,   132,    37,     2,   244,    20,    27,    25,   243,     1, 
   17,    53,   240,     0,     7,    86,   234,     1,     2,   116,   225,     0,     0,   139,   207,     2,     0,   152,   188,     1,     0,   160,   166,     1,     0,   168,   144,     1, 
    0,   173,   128,     0,     0,   175,   116,     0,     0,   173,   106,     0,     0,   166,    98,     0,    42,    16,   163,   249,    43,    12,   179,   248,    41,     6,   208,   248, 
   35,    13,   211,   161,    33,    14,   213,    43,    26,    31,   217,     8,    15,    60,   220,     4,     0,   104,   215,    14,     0,   122,   209,     2,     0,   137,   190,     0, 
    0,   148,   168,     0,     0,   157,   145,     0,     0,   166,   128,     0,     0,   169,   115,     0,     0,   170,   105,     0,     0,   166,    95,     0,     0,   157,    89,     0, 
   37,    30,   119,   249,    39,    25,   130,   249,    32,    24,   149,   249,    28,    43,   145,   171,    24,    49,   160,   104,    24,    42,   166,    41,     7,    85,   187,    32, 
    0,   111,   188,    22,     0,   122,   177,     7,     0,   133,   160,     1,     0,   143,   140,     0,     0,   152,   121,     0,     0,   159,   110,     0,     0,   161,   100,     0, 
    0,   160,    91,     0,     0,   157,    83,     0,     0,   147,    80,     0,    20,    53,    95,   241,    28,    46,    90,   250,    26,    44,   100,   250,    22,    58,   101,   181, 
   17,    80,   105,   130,    10,    86,   129,    93,     1,   106,   149,    59,     0,   114,   147,    29,     0,   122,   138,    12,     0,   132,   125,     2,     0,   140,   109,     0, 
    0,   146,   100,     0,     0,   149,    91,     0,     0,   150,    84,     0,     0,   149,    77,     0,     0,   147,    72,     0,     0,   138,    69,     0,     3,    72,    83,   249, 
   15,    66,    73,   250,    16,    65,    75,   245,    15,    70,    79,   195,     4,    95,    94,   159,     0,   114,   104,   125,     0,   112,   107,    82,     0,   115,   104,    41, 
    0,   124,    95,    18,     0,   135,    90,     8,     0,   143,    84,     1,     0,   146,    78,     0,     0,   146,    73,     0,     0,   145,    68,     0,     0,   142,    63,     0, 
    0,   139,    60,     0,     0,   132,    57,     0,     0,    80,    65,   250,     2,    99,    68,   250,     5,    98,    66,   250,     1,   101,    71,   239,     8,    87,    60,   157, 
    1,   111,    76,   128,     0,   107,    74,    87,     0,   116,    74,    58,     0,   134,    70,    31,     0,   148,    65,    16,     0,   158,    59,     6,     0,   163,    55,     1, 
    0,   159,    53,     0,     0,   153,    51,     0,     0,   145,    49,     0,     0,   139,    47,     0,     0,   134,    44,     0,     0,    93,    49,   251,     0,   109,    53,   250, 
    0,   114,    53,   250,     0,   117,    52,   247,     0,   117,    53,   208,     0,   121,    57,   152,     0,   117,    58,   106,     0,   115,    60,    75,     0,   122,    57,    46, 
    0,   137,    52,    24,     0,   145,    50,    11,     0,   149,    47,     4,     0,   148,    45,     0,     0,   143,    45,     0,     0,   136,    44,     0,     0,   130,    43,     0, 
    0,   124,    42,     0,     0,   103,    38,   251,     0,   116,    38,   251,     0,   122,    38,   251,     0,   128,    37,   250,     0,   137,    36,   239,     0,   136,    39,   180, 
    0,   129,    39,   123,     0,   121,    43,    84,     0,   115,    46,    59,     0,   128,    43,    35,     0,   141,    39,    18,     0,   143,    38,     9,     0,   144,    37,     3, 
    0,   139,    37,     0,     0,   130,    38,     0,     0,   124,    39,     0,     0,   119,    39,     0,     0,   113,    28,   251,     0,   118,    27,   251,     0,   124,    26,   251, 
    0,   134,    25,   251,     0,   148,    23,   246,     0,   142,    24,   196,     0,   133,    25,   137,     0,   134,    28,    94,     0,   127,    33,    64,     0,   130,    33,    43, 
    0,   142,    29,    24,     0,   145,    27,    13,     0,   142,    27,     6,     0,   138,    28,     1,     0,   129,    30,     0,     0,   121,    31,     0,     0,   116,    33,     0, 
    0,   117,    18,   252,     0,   120,    18,   252,     0,   127,    18,   251,     0,   139,    16,   251,     0,   152,    14,   246,     0,   144,    15,   203,     0,   135,    16,   148, 
    0,   136,    18,   104,     0,   138,    19,    72,     0,   140,    20,    49,     0,   145,    19,    31,     0,   146,    18,    18,     0,   145,    19,     9,     0,   140,    20,     3, 
    0,   130,    22,     0,     0,   118,    25,     0,     0,   113,    27,     0,     0,   120,    12,   252,     0,   122,    11,   252,     0,   129,    10,   252,     0,   140,     9,   251, 
    0,   148,     7,   241,     0,   141,     8,   203,     0,   135,     9,   154,     0,   134,    10,   112,     0,   138,    11,    82,     0,   142,    11,    57,     0,   146,    12,    38, 
    0,   149,    11,    24,     0,   144,    11,    14,     0,   141,    12,     6,     0,   136,    13,     1,     0,   121,    17,     0,     0,   110,    22,     0,     0,   126,     8,   252, 
    0,   124,     6,   252,     0,   129,     4,   252,     0,   136,     3,   249,     0,   140,     2,   232,     0,   135,     3,   196,     0,   132,     3,   153,     0,   131,     4,   115, 
    0,   134,     5,    89,     0,   138,     5,    65,     0,   141,     5,    44,     0,   146,     6,    30,     0,   149,     5,    19,     0,   140,     6,    10,     0,   135,     7,     4, 
    0,   126,    10,     0,     0,   113,    16,     0,     0,   132,     6,   252,     0,   127,     2,   252,     0,   128,     1,   248,     0,   127,     0,   232,     0,   125,     0,   208, 
    0,   123,     0,   178,     0,   122,     0,   140,     0,   124,     0,   112,     0,   127,     1,    91,     0,   130,     1,    70,     0,   134,     1,    52,     0,   137,     1,    35, 
    0,   141,     1,    23,     0,   142,     1,    14,     0,   134,     2,     7,     0,   129,     3,     1,     0,   118,    11,     0,     0,   138,     4,   252,     0,   127,     0,   248, 
    0,   121,     0,   231,     0,   115,     0,   208,     0,   111,     0,   181,     0,   108,     0,   149,     0,   106,     0,   118,     0,   108,     0,   100,     0,   111,     0,    86, 
    0,   114,     0,    70,     0,   117,     0,    56,     0,   121,     0,    40,     0,   124,     0,    28,     0,   126,     0,    19,     0,   126,     0,    11,     0,   124,     1,     4, 
    0,   124,     7,     0,     0,   141,     2,   252,     0,   127,     0,   239,     0,   117,     0,   216,     0,   110,     0,   192,     0,   105,     0,   163,     0,   100,     0,   130, 
    0,    97,     0,   103,     0,    99,     0,    90,     0,   101,     0,    81,     0,   103,     0,    70,     0,   106,     0,    59,     0,   109,     0,    46,     0,   112,     0,    33, 
    0,   115,     0,    24,     0,   117,     0,    15,     0,   118,     0,     8,     0,   130,     4,     0,     0,   145,     0,   252,     0,   137,     0,   235,     0,   131,     0,   217, 
    0,   126,     0,   199,     0,   123,     0,   175,     0,   120,     0,   141,     0,   117,     0,   110,     0,   119,     0,    98,     0,   121,     0,    90,     0,   123,     0,    82, 
    0,   127,     0,    71,     0,   133,     0,    56,     0,   139,     0,    41,     0,   145,     0,    29,     0,   150,     0,    17,     0,   152,     0,     7,     0,   155,     0,     0, 
   42,     0,   227,   242,    41,     1,   225,   218,    37,     0,   232,   190,    33,     0,   237,   138,    30,     0,   244,    64,    28,     0,   249,    15,    24,     8,   250,     0, 
   18,    21,   248,     0,     6,    51,   238,     4,     0,    80,   218,    13,     0,    96,   201,    12,     0,   109,   187,     9,     0,   119,   170,     7,     0,   130,   155,     4, 
    0,   138,   142,     3,     0,   143,   127,     1,     0,   147,   113,     0,    38,     7,   202,   248,    38,     5,   211,   244,    36,     2,   223,   226,    31,     0,   234,   171, 
   27,     0,   244,    58,    26,     2,   248,     3,    16,    27,   245,     1,     7,    49,   241,     2,     1,    71,   232,     0,     0,    90,   210,     1,     0,   104,   192,     1, 
    0,   117,   172,     1,     0,   127,   153,     1,     0,   134,   138,     0,     0,   139,   124,     0,     0,   141,   111,     0,     0,   138,   105,     0,    32,    16,   176,   249, 
   33,    14,   180,   249,    31,     7,   204,   249,    28,     6,   223,   196,    24,     7,   225,    81,    22,    15,   220,    21,    13,    36,   223,     9,     3,    62,   220,    12, 
    0,    76,   215,     2,     0,    92,   196,     0,     0,   105,   174,     0,     0,   117,   155,     0,     0,   127,   139,     0,     0,   133,   123,     0,     0,   135,   110,     0, 
    0,   136,   101,     0,     0,   130,    97,     0,    24,    32,   138,   249,    25,    29,   144,   249,    24,    23,   163,   249,    21,    21,   186,   223,    17,    31,   189,   142, 
   18,    28,   184,    63,     8,    54,   193,    33,     0,    73,   195,    24,     0,    80,   188,     8,     0,    93,   172,     1,     0,   105,   151,     0,     0,   115,   134,     0, 
    0,   123,   119,     0,     0,   128,   106,     0,     0,   130,    95,     0,     0,   131,    88,     0,     0,   122,    86,     0,    17,    48,   111,   250,    20,    46,   109,   250, 
   17,    44,   120,   250,    13,    44,   139,   229,     6,    69,   146,   176,     5,    70,   152,   113,     4,    68,   160,    55,     0,    76,   161,    34,     0,    84,   152,    14, 
    0,    94,   140,     3,     0,   103,   125,     0,     0,   111,   111,     0,     0,   116,    98,     0,     0,   121,    88,     0,     0,   124,    82,     0,     0,   125,    77,     0, 
    0,   118,    75,     0,     0,    66,    94,   250,     9,    65,    91,   250,     8,    64,    95,   250,     7,    60,   104,   249,     0,    80,   111,   189,     0,    87,   108,   129, 
    0,    81,   114,    87,     0,    75,   119,    48,     0,    87,   113,    23,     0,    95,   105,     9,     0,   101,    96,     1,     0,   106,    86,     0,     0,   110,    80,     0, 
    0,   115,    74,     0,     0,   117,    70,     0,     0,   117,    65,     0,     0,   112,    63,     0,     0,    62,    66,   251,     0,    72,    75,   250,     0,    73,    77,   250, 
    3,    69,    76,   238,     0,    73,    79,   187,     0,    85,    81,   127,     0,    82,    80,    90,     0,    82,    83,    61,     0,    89,    78,    30,     0,    96,    74,    13, 
    0,   105,    72,     4,     0,   111,    68,     0,     0,   112,    64,     0,     0,   113,    60,     0,     0,   112,    56,     0,     0,   111,    54,     0,     0,   107,    52,     0, 
    0,    65,    51,   251,     0,    72,    57,   251,     0,    75,    57,   251,     0,    75,    57,   246,     6,    63,    46,   186,     0,    84,    61,   136,     0,    87,    61,   100, 
    0,    87,    60,    72,     0,    91,    59,    44,     0,   103,    56,    23,     0,   115,    52,    10,     0,   123,    49,     3,     0,   123,    47,     0,     0,   120,    45,     0, 
    0,   116,    44,     0,     0,   112,    42,     0,     0,   109,    39,     0,     0,    75,    40,   252,     0,    86,    40,   251,     0,    89,    39,   251,     0,    92,    39,   251, 
    0,    92,    38,   236,     0,    94,    44,   163,     0,    93,    45,   114,     0,    90,    45,    80,     0,    90,    47,    57,     0,    96,    46,    35,     0,   109,    43,    18, 
    0,   115,    41,     7,     0,   117,    40,     1,     0,   113,    39,     0,     0,   109,    39,     0,     0,   106,    38,     0,     0,   102,    37,     0,     0,    84,    29,   252, 
    0,    92,    28,   252,     0,    95,    27,   252,     0,   100,    27,   252,     0,   105,    25,   245,     0,   105,    28,   193,     0,   100,    30,   135,     0,    99,    30,    92, 
    0,    96,    35,    64,     0,    92,    37,    45,     0,   102,    35,    28,     0,   114,    32,    12,     0,   115,    31,     5,     0,   113,    31,     1,     0,   107,    32,     0, 
    0,   102,    33,     0,     0,    99,    33,     0,     0,    91,    20,   252,     0,    96,    19,   252,     0,    99,    19,   252,     0,   106,    18,   251,     0,   112,    17,   244, 
    0,   110,    18,   201,     0,   104,    18,   149,     0,   104,    20,   102,     0,   107,    22,    72,     0,   100,    25,    51,     0,   102,    25,    34,     0,   116,    22,    18, 
    0,   118,    22,     8,     0,   115,    23,     2,     0,   108,    24,     0,     0,   101,    26,     0,     0,    98,    28,     0,     0,    96,    12,   252,     0,    99,    12,   252, 
    0,   104,    12,   252,     0,   110,    11,   251,     0,   115,    10,   239,     0,   111,    11,   203,     0,   108,    11,   157,     0,   106,    11,   110,     0,   111,    13,    81, 
    0,   113,    14,    56,     0,   115,    14,    39,     0,   119,    14,    24,     0,   118,    13,    13,     0,   117,    14,     5,     0,   112,    16,     1,     0,   101,    19,     0, 
    0,    97,    23,     0,     0,   102,     8,   252,     0,   102,     6,   252,     0,   106,     6,   252,     0,   111,     5,   250,     0,   114,     5,   232,     0,   111,     5,   199, 
    0,   109,     5,   157,     0,   105,     6,   113,     0,   109,     7,    87,     0,   113,     7,    64,     0,   116,     7,    45,     0,   119,     7,    30,     0,   121,     7,    19, 
    0,   116,     7,     9,     0,   115,     8,     3,     0,   106,    12,     0,     0,    98,    17,     0,     0,   110,     6,   252,     0,   106,     3,   252,     0,   108,     1,   250, 
    0,   109,     1,   239,     0,   108,     1,   217,     0,   107,     1,   188,     0,   106,     1,   150,     0,   103,     1,   111,     0,   106,     2,    88,     0,   109,     2,    69, 
    0,   112,     2,    52,     0,   115,     2,    35,     0,   118,     2,    24,     0,   120,     2,    14,     0,   115,     3,     6,     0,   111,     4,     1,     0,   102,    12,     0, 
    0,   117,     4,   252,     0,   109,     1,   249,     0,   105,     0,   235,     0,   100,     0,   213,     0,    97,     0,   189,     0,    96,     0,   159,     0,    95,     0,   126, 
    0,    93,     0,    98,     0,    96,     0,    82,     0,    98,     0,    69,     0,   101,     0,    56,     0,   104,     0,    40,     0,   106,     0,    29,     0,   108,     0,    19, 
    0,   108,     0,    11,     0,   107,     1,     4,     0,   106,     7,     0,     0,   122,     2,   252,     0,   111,     0,   240,     0,   103,     0,   218,     0,    97,     0,   195, 
    0,    92,     0,   168,     0,    90,     0,   137,     0,    87,     0,   107,     0,    85,     0,    86,     0,    87,     0,    74,     0,    88,     0,    67,     0,    91,     0,    58, 
    0,    93,     0,    45,     0,    96,     0,    33,     0,    98,     0,    24,     0,   100,     0,    15,     0,   101,     0,     8,     0,   112,     5,     0,     0,   127,     0,   252, 
    0,   121,     0,   237,     0,   115,     0,   219,     0,   111,     0,   201,     0,   108,     0,   181,     0,   107,     0,   150,     0,   104,     0,   116,     0,   103,     0,    91, 
    0,   105,     0,    82,     0,   106,     0,    76,     0,   108,     0,    69,     0,   112,     0,    56,     0,   118,     0,    41,     0,   123,     0,    29,     0,   128,     0,    18, 
    0,   130,     0,     7,     0,   133,     0,     0,    31,     1,   226,   247,    30,     1,   227,   230,    29,     1,   229,   205,    25,     0,   235,   167,    22,     0,   242,   103, 
   20,     0,   248,    41,    20,     0,   251,     7,    16,    10,   250,     0,    12,    19,   249,     0,     4,    42,   238,     1,     0,    64,   216,     7,     0,    78,   198,     7, 
    0,    91,   184,     6,     0,   101,   168,     4,     0,   110,   154,     2,     0,   118,   140,     1,     0,   124,   127,     0,    28,     9,   199,   249,    27,     7,   209,   247, 
   27,     3,   224,   239,    25,     0,   232,   196,    21,     0,   242,    98,    19,     1,   248,    30,    17,     8,   250,     1,     8,    28,   246,     2,     2,    43,   241,     0, 
    0,    58,   218,     1,     0,    72,   196,     1,     0,    85,   180,     1,     0,    95,   162,     0,     0,   104,   147,     0,     0,   111,   135,     0,     0,   117,   125,     0, 
    0,   117,   119,     0,    24,    18,   177,   249,    24,    18,   180,   249,    23,     9,   205,   249,    23,     4,   222,   216,    18,     3,   230,   114,    17,     7,   227,    45, 
   13,    17,   231,    10,     3,    41,   227,    12,     0,    48,   226,     3,     0,    61,   203,     0,     0,    74,   182,     0,     0,    87,   163,     0,     0,    96,   146,     0, 
    0,   104,   133,     0,     0,   109,   121,     0,     0,   112,   112,     0,     0,   110,   108,     0,    17,    31,   152,   250,    18,    30,   154,   249,    16,    25,   170,   249, 
   16,    14,   202,   240,    11,    23,   202,   171,    11,    23,   198,    95,     6,    37,   200,    43,     0,    51,   200,    27,     0,    53,   196,    10,     0,    63,   183,     1, 
    0,    75,   162,     0,     0,    86,   142,     0,     0,    95,   128,     0,     0,   101,   116,     0,     0,   105,   105,     0,     0,   106,    95,     0,     0,   103,    94,     0, 
    7,    50,   125,   250,    11,    46,   127,   250,     9,    42,   138,   250,     7,    36,   155,   250,     0,    50,   160,   201,     0,    53,   162,   132,     0,    54,   167,    69, 
    0,    54,   168,    36,     0,    57,   164,    17,     0,    65,   154,     4,     0,    74,   135,     0,     0,    84,   119,     0,     0,    91,   107,     0,     0,    96,    95,     0, 
    0,   100,    86,     0,     0,   104,    80,     0,     0,   101,    79,     0,     0,    55,   100,   250,     4,    61,   103,   250,     2,    60,   112,   250,     2,    52,   122,   250, 
    0,    51,   120,   202,     0,    60,   110,   134,     0,    61,   116,    92,     0,    55,   123,    53,     0,    60,   122,    25,     0,    66,   116,    10,     0,    73,   107,     1, 
    0,    80,    95,     0,     0,    88,    86,     0,     0,    94,    80,     0,     0,    98,    74,     0,     0,   100,    70,     0,     0,    99,    68,     0,     0,    51,    72,   251, 
    0,    60,    80,   251,     0,    61,    83,   251,     0,    56,    85,   246,     0,    53,    84,   201,     0,    63,    81,   126,     0,    69,    80,    94,     0,    63,    88,    65, 
    0,    64,    89,    33,     0,    69,    87,    17,     0,    74,    83,     5,     0,    82,    77,     0,     0,    88,    71,     0,     0,    92,    66,     0,     0,    94,    62,     0, 
    0,    95,    59,     0,     0,    93,    57,     0,     0,    49,    51,   252,     0,    55,    57,   251,     0,    56,    59,   251,     1,    54,    58,   243,     1,    50,    58,   202, 
    0,    63,    63,   137,     0,    66,    63,    95,     0,    66,    65,    70,     0,    68,    66,    44,     0,    72,    65,    22,     0,    79,    61,     9,     0,    87,    60,     1, 
    0,    90,    56,     0,     0,    91,    53,     0,     0,    91,    51,     0,     0,    91,    49,     0,     0,    89,    47,     0,     0,    51,    41,   252,     0,    59,    40,   252, 
    0,    62,    40,   252,     0,    62,    40,   251,     0,    57,    39,   227,     0,    70,    47,   158,     0,    68,    48,   103,     0,    69,    48,    78,     0,    72,    50,    59, 
    0,    73,    47,    33,     0,    84,    45,    16,     0,    93,    44,     6,     0,    97,    41,     1,     0,    96,    40,     0,     0,    94,    39,     0,     0,    92,    37,     0, 
    0,    90,    34,     0,     0,    61,    30,   252,     0,    66,    29,   252,     0,    67,    28,   252,     0,    69,    27,   252,     0,    70,    28,   240,     0,    75,    32,   189, 
    0,    73,    36,   125,     0,    73,    36,    88,     0,    74,    36,    64,     0,    74,    38,    44,     0,    80,    37,    27,     0,    89,    35,    12,     0,    93,    34,     4, 
    0,    93,    34,     0,     0,    89,    34,     0,     0,    86,    33,     0,     0,    84,    32,     0,     0,    68,    21,   253,     0,    72,    20,   253,     0,    73,    19,   253, 
    0,    77,    19,   252,     0,    81,    19,   242,     0,    81,    21,   199,     0,    82,    24,   149,     0,    81,    24,   103,     0,    81,    24,    71,     0,    78,    27,    50, 
    0,    75,    29,    35,     0,    85,    28,    20,     0,    93,    26,     7,     0,    94,    26,     1,     0,    90,    26,     0,     0,    85,    27,     0,     0,    83,    28,     0, 
    0,    72,    14,   253,     0,    76,    13,   253,     0,    80,    13,   253,     0,    84,    12,   252,     0,    88,    12,   238,     0,    86,    13,   201,     0,    85,    15,   159, 
    0,    85,    15,   114,     0,    84,    14,    79,     0,    86,    16,    56,     0,    82,    20,    41,     0,    84,    19,    26,     0,    94,    17,    12,     0,    97,    17,     4, 
    0,    93,    19,     0,     0,    85,    21,     0,     0,    83,    23,     0,     0,    79,     8,   253,     0,    81,     7,   253,     0,    85,     7,   253,     0,    89,     6,   251, 
    0,    90,     6,   231,     0,    89,     7,   198,     0,    88,     8,   160,     0,    86,     8,   117,     0,    86,     8,    84,     0,    89,     9,    62,     0,    92,    10,    45, 
    0,    93,    10,    31,     0,    96,    10,    18,     0,    97,     9,     8,     0,    97,    10,     2,     0,    88,    14,     0,     0,    83,    18,     0,     0,    88,     5,   253, 
    0,    87,     3,   253,     0,    88,     2,   252,     0,    90,     2,   243,     0,    89,     2,   219,     0,    88,     2,   191,     0,    87,     3,   155,     0,    86,     3,   116, 
    0,    86,     3,    87,     0,    90,     3,    68,     0,    93,     3,    52,     0,    96,     4,    36,     0,    98,     4,    24,     0,   100,     3,    14,     0,    97,     3,     5, 
    0,    93,     6,     1,     0,    87,    13,     0,     0,    97,     3,   253,     0,    92,     1,   251,     0,    89,     0,   240,     0,    86,     0,   221,     0,    85,     0,   198, 
    0,    83,     0,   170,     0,    82,     0,   137,     0,    82,     0,   105,     0,    81,     0,    82,     0,    84,     0,    67,     0,    87,     0,    56,     0,    90,     0,    41, 
    0,    92,     0,    29,     0,    94,     0,    19,     0,    94,     0,    11,     0,    93,     1,     3,     0,    92,     8,     0,     0,   104,     2,   253,     0,    95,     0,   242, 
    0,    89,     0,   223,     0,    85,     0,   201,     0,    81,     0,   176,     0,    78,     0,   144,     0,    77,     0,   114,     0,    74,     0,    90,     0,    73,     0,    72, 
    0,    75,     0,    63,     0,    76,     0,    56,     0,    79,     0,    45,     0,    82,     0,    33,     0,    84,     0,    24,     0,    85,     0,    15,     0,    87,     0,     7, 
    0,    97,     5,     0,     0,   111,     0,   253,     0,   105,     0,   238,     0,   100,     0,   222,     0,    96,     0,   206,     0,    94,     0,   186,     0,    92,     0,   157, 
    0,    91,     0,   124,     0,    89,     0,    96,     0,    89,     0,    76,     0,    91,     0,    69,     0,    92,     0,    65,     0,    95,     0,    55,     0,    99,     0,    41, 
    0,   104,     0,    29,     0,   107,     0,    18,     0,   110,     0,     7,     0,   113,     0,     0,    22,     3,   222,   249,    22,     1,   227,   240,    23,     1,   227,   218, 
   19,     0,   234,   190,    17,     0,   239,   138,    15,     0,   246,    72,    15,     0,   250,    26,    16,     0,   252,     2,    12,     9,   251,     0,     9,    17,   250,     0, 
    3,    36,   239,     0,     0,    55,   217,     4,     0,    67,   198,     4,     0,    78,   184,     3,     0,    88,   169,     2,     0,    97,   154,     1,     0,   104,   140,     0, 
   20,    11,   202,   249,    20,     9,   207,   249,    20,     4,   221,   245,    20,     1,   228,   215,    15,     0,   239,   128,    12,     2,   245,    62,    14,     1,   250,    14, 
    9,    12,   250,     1,     3,    26,   246,     0,     0,    37,   227,     2,     0,    48,   206,     0,     0,    61,   187,     0,     0,    71,   172,     0,     0,    81,   157,     0, 
    0,    89,   144,     0,     0,    96,   134,     0,     0,    99,   130,     0,    15,    20,   180,   249,    16,    18,   185,   249,    17,    11,   203,   249,    16,     4,   223,   231, 
   12,     4,   229,   140,    11,     6,   228,    75,    10,     9,   234,    24,     4,    23,   236,    11,     0,    31,   232,     3,     0,    37,   211,     0,     0,    51,   190,     0, 
    0,    63,   172,     0,     0,    72,   155,     0,     0,    80,   140,     0,     0,    87,   128,     0,     0,    92,   119,     0,     0,    93,   118,     0,     3,    40,   152,   250, 
    9,    32,   159,   250,     8,    26,   174,   250,    11,    11,   206,   250,     5,    24,   205,   193,     0,    34,   202,   135,     0,    33,   203,    74,     0,    33,   205,    41, 
    0,    35,   202,    12,     0,    39,   192,     1,     0,    52,   173,     0,     0,    64,   152,     0,     0,    72,   135,     0,     0,    79,   122,     0,     0,    84,   111,     0, 
    0,    88,   102,     0,     0,    87,   103,     0,     0,    45,   127,   250,     1,    48,   138,   250,     4,    41,   143,   250,     1,    30,   160,   250,     0,    34,   163,   200, 
    0,    34,   162,   146,     0,    35,   167,    87,     0,    37,   171,    51,     0,    40,   169,    20,     0,    43,   164,     6,     0,    54,   148,     0,     0,    64,   128,     0, 
    0,    70,   113,     0,     0,    75,   102,     0,     0,    80,    93,     0,     0,    84,    87,     0,     0,    83,    88,     0,     0,    44,   102,   251,     0,    49,   109,   251, 
    0,    44,   113,   251,     0,    39,   123,   251,     0,    37,   125,   205,     0,    38,   118,   138,     0,    40,   121,   101,     0,    41,   126,    60,     0,    43,   129,    27, 
    0,    46,   128,    12,     0,    54,   120,     2,     0,    62,   105,     0,     0,    68,    93,     0,     0,    73,    86,     0,     0,    79,    80,     0,     0,    83,    75,     0, 
    0,    84,    74,     0,     0,    42,    77,   252,     0,    45,    82,   251,     0,    44,    86,   251,     0,    40,    89,   244,     0,    41,    88,   198,     0,    41,    87,   138, 
    0,    50,    84,    96,     0,    49,    92,    69,     0,    46,    97,    36,     0,    49,    98,    19,     0,    54,    93,     6,     0,    61,    86,     1,     0,    68,    78,     0, 
    0,    73,    73,     0,     0,    77,    67,     0,     0,    81,    62,     0,     0,    83,    61,     0,     0,    41,    56,   252,     0,    43,    60,   252,     0,    43,    62,   251, 
    0,    41,    64,   243,     0,    43,    65,   201,     0,    44,    65,   146,     0,    49,    65,    93,     0,    52,    67,    73,     0,    50,    71,    49,     0,    48,    76,    28, 
    0,    57,    72,    11,     0,    63,    69,     2,     0,    68,    64,     0,     0,    72,    59,     0,     0,    75,    55,     0,     0,    77,    53,     0,     0,    79,    51,     0, 
    0,    40,    40,   252,     0,    44,    40,   252,     0,    44,    41,   252,     1,    40,    42,   243,     1,    42,    44,   206,     0,    47,    49,   160,     0,    49,    50,   104, 
    0,    53,    52,    76,     0,    52,    54,    56,     0,    52,    55,    35,     0,    60,    53,    16,     0,    66,    51,     5,     0,    70,    50,     0,     0,    72,    47,     0, 
    0,    73,    45,     0,     0,    73,    43,     0,     0,    75,    40,     0,     0,    40,    32,   253,     0,    46,    30,   253,     0,    46,    29,   253,     0,    42,    31,   251, 
    1,    41,    30,   227,     0,    52,    36,   184,     0,    50,    38,   120,     0,    52,    39,    80,     0,    54,    39,    63,     0,    57,    40,    48,     0,    61,    39,    25, 
    0,    70,    38,    11,     0,    75,    36,     3,     0,    76,    35,     0,     0,    75,    33,     0,     0,    73,    32,     0,     0,    73,    29,     0,     0,    48,    22,   253, 
    0,    51,    21,   253,     0,    51,    20,   253,     0,    52,    20,   251,     0,    53,    20,   233,     0,    59,    24,   196,     0,    59,    26,   147,     0,    59,    28,    96, 
    0,    58,    28,    69,     0,    59,    29,    50,     0,    60,    30,    34,     0,    66,    30,    19,     0,    73,    28,     7,     0,    76,    27,     1,     0,    72,    28,     0, 
    0,    70,    28,     0,     0,    69,    27,     0,     0,    52,    15,   253,     0,    56,    14,   253,     0,    57,    14,   253,     0,    59,    13,   251,     0,    61,    14,   230, 
    0,    64,    16,   198,     0,    65,    17,   158,     0,    65,    18,   114,     0,    64,    18,    80,     0,    60,    20,    54,     0,    59,    23,    40,     0,    61,    23,    26, 
    0,    69,    22,    14,     0,    77,    20,     3,     0,    74,    21,     0,     0,    70,    23,     0,     0,    69,    24,     0,     0,    56,     9,   253,     0,    60,     8,   253, 
    0,    63,     8,   253,     0,    66,     8,   250,     0,    68,     9,   226,     0,    68,     9,   196,     0,    69,    10,   160,     0,    68,    10,   119,     0,    67,    11,    85, 
    0,    64,    13,    58,     0,    65,    14,    45,     0,    67,    15,    32,     0,    70,    14,    19,     0,    79,    12,     8,     0,    80,    13,     1,     0,    72,    16,     0, 
    0,    69,    19,     0,     0,    65,     5,   253,     0,    66,     4,   253,     0,    68,     3,   252,     0,    70,     3,   244,     0,    69,     4,   218,     0,    70,     4,   192, 
    0,    69,     5,   158,     0,    69,     5,   121,     0,    69,     5,    91,     0,    70,     5,    66,     0,    73,     5,    51,     0,    77,     5,    37,     0,    79,     6,    24, 
    0,    81,     5,    13,     0,    80,     5,     4,     0,    76,     8,     0,     0,    72,    14,     0,     0,    76,     3,   253,     0,    74,     1,   252,     0,    73,     0,   246, 
    0,    72,     0,   229,     0,    70,     0,   208,     0,    69,     1,   182,     0,    68,     1,   149,     0,    69,     0,   117,     0,    69,     0,    88,     0,    69,     0,    68, 
    0,    72,     0,    55,     0,    76,     0,    42,     0,    78,     0,    29,     0,    80,     0,    19,     0,    81,     0,     9,     0,    79,     1,     2,     0,    77,     9,     0, 
    0,    85,     2,   253,     0,    80,     0,   245,     0,    76,     0,   228,     0,    72,     0,   208,     0,    69,     0,   186,     0,    66,     0,   152,     0,    65,     0,   122, 
    0,    65,     0,    96,     0,    63,     0,    74,     0,    63,     0,    61,     0,    65,     0,    53,     0,    67,     0,    44,     0,    69,     0,    33,     0,    71,     0,    24, 
    0,    72,     0,    15,     0,    73,     0,     7,     0,    82,     5,     0,     0,    93,     0,   253,     0,    90,     0,   241,     0,    86,     0,   227,     0,    83,     0,   211, 
    0,    81,     0,   192,     0,    79,     0,   165,     0,    78,     0,   132,     0,    77,     0,   103,     0,    76,     0,    80,     0,    76,     0,    64,     0,    78,     0,    59, 
    0,    79,     0,    53,     0,    83,     0,    42,     0,    87,     0,    30,     0,    90,     0,    19,     0,    94,     0,     8,     0,    95,     0,     0,    15,     6,   217,   249, 
   15,     3,   225,   247,    16,     1,   227,   227,    13,     0,   233,   203,    12,     0,   237,   163,    10,     0,   243,   103,    11,     0,   249,    47,    12,     0,   252,    16, 
   13,     0,   253,     0,     9,     9,   252,     0,     7,    15,   251,     0,     2,    32,   240,     0,     0,    47,   217,     2,     0,    58,   198,     2,     0,    68,   183,     1, 
    0,    77,   168,     0,     0,    86,   153,     0,    13,    10,   206,   249,    13,    11,   205,   249,    13,     7,   217,   247,    14,     2,   226,   226,     9,     1,   237,   154, 
    7,     2,   242,    91,     6,     5,   245,    39,     7,     5,   248,     8,     4,    14,   243,     1,     0,    25,   232,     2,     0,    31,   214,     1,     0,    41,   199,     0, 
    0,    52,   183,     0,     0,    62,   169,     0,     0,    70,   157,     0,     0,    77,   145,     0,     0,    81,   142,     0,     8,    18,   191,   250,     9,    19,   189,   250, 
   10,    13,   201,   250,    10,     7,   222,   240,     5,    10,   226,   167,     3,    13,   223,   104,     4,    14,   225,    51,     2,    17,   230,    20,     0,    23,   225,     9, 
    0,    25,   214,     1,     0,    32,   199,     0,     0,    43,   180,     0,     0,    54,   164,     0,     0,    63,   150,     0,     0,    69,   136,     0,     0,    73,   127,     0, 
    0,    75,   128,     0,     0,    32,   159,   250,     2,    30,   163,   250,     2,    26,   178,   250,     4,    14,   203,   250,     2,    20,   203,   203,     0,    23,   199,   147, 
    0,    23,   200,    89,     0,    23,   204,    49,     0,    24,   203,    15,     0,    26,   199,     2,     0,    33,   183,     0,     0,    45,   162,     0,     0,    55,   143,     0, 
    0,    63,   129,     0,     0,    67,   118,     0,     0,    71,   110,     0,     0,    71,   113,     0,     0,    33,   127,   251,     0,    36,   135,   251,     0,    33,   145,   250, 
    0,    23,   166,   250,     0,    25,   162,   201,     0,    24,   157,   151,     0,    24,   169,    94,     0,    26,   172,    57,     0,    27,   175,    21,     0,    29,   172,     7, 
    0,    35,   160,     1,     0,    46,   138,     0,     0,    56,   122,     0,     0,    61,   110,     0,     0,    65,   100,     0,     0,    68,    93,     0,     0,    68,    97,     0, 
    0,    33,   101,   251,     0,    35,   107,   251,     0,    33,   113,   251,     0,    26,   122,   251,     0,    26,   120,   203,     0,    26,   125,   147,     0,    29,   119,   105, 
    0,    29,   127,    65,     0,    30,   133,    31,     0,    32,   135,    14,     0,    36,   132,     3,     0,    46,   116,     0,     0,    54,   102,     0,     0,    59,    92,     0, 
    0,    63,    85,     0,     0,    67,    81,     0,     0,    67,    83,     0,     0,    34,    79,   252,     0,    35,    83,   252,     0,    33,    86,   252,     0,    28,    90,   247, 
    0,    29,    90,   201,     0,    29,    91,   144,     0,    32,    91,   102,     0,    34,    99,    74,     0,    34,   104,    41,     0,    34,   105,    21,     0,    37,   104,     8, 
    0,    45,    95,     1,     0,    52,    85,     0,     0,    58,    78,     0,     0,    63,    72,     0,     0,    67,    68,     0,     0,    68,    68,     0,     0,    33,    59,   252, 
    0,    34,    62,   252,     0,    32,    63,   251,     0,    29,    65,   236,     0,    31,    66,   197,     0,    34,    69,   144,     0,    34,    70,   102,     0,    40,    69,    74, 
    0,    39,    75,    53,     0,    34,    80,    32,     0,    39,    80,    13,     0,    45,    77,     3,     0,    52,    70,     0,     0,    58,    64,     0,     0,    62,    59,     0, 
    0,    66,    56,     0,     0,    69,    55,     0,     0,    33,    44,   253,     0,    34,    43,   253,     0,    33,    44,   251,     0,    29,    46,   234,     0,    35,    51,   191, 
    0,    35,    51,   144,     0,    36,    52,   103,     0,    41,    53,    72,     0,    43,    54,    57,     0,    39,    58,    39,     0,    43,    60,    18,     0,    47,    60,     6, 
    0,    52,    57,     1,     0,    57,    52,     0,     0,    61,    49,     0,     0,    63,    46,     0,     0,    66,    44,     0,     0,    31,    31,   253,     0,    34,    31,   253, 
    0,    33,    30,   253,     1,    30,    32,   243,     1,    35,    36,   208,     0,    35,    38,   172,     0,    36,    39,   120,     0,    40,    40,    80,     0,    42,    41,    60, 
    0,    41,    43,    46,     0,    44,    44,    25,     0,    50,    44,    11,     0,    55,    42,     2,     0,    58,    40,     0,     0,    59,    38,     0,     0,    60,    36,     0, 
    0,    62,    34,     0,     0,    31,    23,   253,     0,    35,    22,   253,     0,    35,    21,   253,     0,    35,    21,   251,     0,    37,    22,   226,     0,    41,    25,   190, 
    0,    39,    26,   142,     0,    42,    29,    93,     0,    43,    30,    64,     0,    43,    31,    50,     0,    42,    30,    37,     0,    51,    32,    18,     0,    58,    30,     6, 
    0,    61,    29,     0,     0,    60,    28,     0,     0,    59,    27,     0,     0,    59,    24,     0,     0,    37,    16,   253,     0,    40,    15,   253,     0,    41,    15,   253, 
    0,    42,    15,   252,     0,    42,    15,   231,     0,    48,    18,   200,     0,    47,    19,   159,     0,    48,    20,   114,     0,    48,    22,    76,     0,    45,    23,    54, 
    0,    46,    23,    39,     0,    50,    24,    25,     0,    55,    24,    12,     0,    61,    22,     3,     0,    60,    22,     0,     0,    57,    23,     0,     0,    56,    23,     0, 
    0,    41,    10,   254,     0,    44,     9,   254,     0,    47,     9,   254,     0,    48,     9,   250,     0,    51,    10,   227,     0,    52,    10,   199,     0,    53,    12,   163, 
    0,    53,    11,   121,     0,    53,    13,    87,     0,    50,    16,    59,     0,    48,    17,    43,     0,    50,    17,    31,     0,    52,    17,    19,     0,    58,    17,     9, 
    0,    62,    16,     1,     0,    58,    17,     0,     0,    57,    19,     0,     0,    47,     6,   254,     0,    50,     5,   254,     0,    52,     4,   253,     0,    54,     5,   242, 
    0,    55,     5,   219,     0,    56,     5,   194,     0,    56,     6,   161,     0,    56,     6,   124,     0,    57,     6,    93,     0,    56,     7,    68,     0,    54,     9,    48, 
    0,    55,     9,    37,     0,    57,    10,    25,     0,    58,     9,    14,     0,    65,     8,     4,     0,    61,    10,     0,     0,    59,    14,     0,     0,    56,     4,   254, 
    0,    57,     1,   253,     0,    57,     1,   250,     0,    58,     1,   232,     0,    57,     1,   211,     0,    58,     1,   186,     0,    57,     1,   154,     0,    57,     1,   122, 
    0,    58,     1,    94,     0,    58,     1,    70,     0,    59,     2,    54,     0,    61,     2,    42,     0,    63,     2,    29,     0,    65,     2,    19,     0,    67,     1,     8, 
    0,    65,     2,     1,     0,    63,     9,     0,     0,    65,     2,   253,     0,    63,     0,   246,     0,    61,     0,   230,     0,    60,     0,   209,     0,    59,     0,   188, 
    0,    57,     0,   158,     0,    56,     0,   127,     0,    56,     0,   101,     0,    55,     0,    79,     0,    54,     0,    63,     0,    55,     0,    51,     0,    56,     0,    42, 
    0,    58,     0,    33,     0,    59,     0,    23,     0,    60,     0,    15,     0,    62,     0,     7,     0,    68,     5,     0,     0,    75,     0,   253,     0,    72,     0,   245, 
    0,    70,     0,   233,     0,    69,     0,   219,     0,    67,     0,   201,     0,    66,     0,   175,     0,    64,     0,   139,     0,    64,     0,   109,     0,    64,     0,    85, 
    0,    63,     0,    67,     0,    64,     0,    54,     0,    65,     0,    49,     0,    67,     0,    42,     0,    71,     0,    30,     0,    74,     0,    20,     0,    78,     0,     9, 
    0,    80,     0,     0,     7,     9,   211,   250,     7,     6,   219,   248,     9,     2,   227,   233,     8,     0,   232,   211,     8,     0,   236,   181,     7,     0,   241,   130, 
    8,     0,   247,    72,     9,     0,   250,    32,    10,     0,   252,    11,    10,     1,   253,     0,     7,     9,   252,     0,     6,    13,   251,     0,     1,    28,   238,     0, 
    0,    40,   216,     1,     0,    50,   196,     0,     0,    60,   182,     0,     0,    70,   167,     0,     5,    12,   205,   250,     6,    13,   203,   250,     6,     9,   213,   249, 
    8,     4,   226,   235,     6,     0,   236,   175,     4,     0,   239,   111,     3,     3,   239,    62,     3,     4,   243,    24,     1,    13,   238,    11,     0,    17,   234,     4, 
    0,    21,   222,     1,     0,    26,   209,     1,     0,    35,   195,     0,     0,    45,   180,     0,     0,    54,   168,     0,     0,    62,   158,     0,     0,    66,   156,     0, 
    2,    19,   193,   250,     3,    20,   190,   250,     4,    14,   202,   250,     4,    10,   219,   241,     2,     8,   224,   180,     0,    13,   220,   122,     0,    13,   220,    73, 
    0,    13,   225,    34,     0,    14,   220,    14,     0,    16,   215,     3,     0,    21,   205,     0,     0,    28,   192,     0,     0,    36,   175,     0,     0,    47,   160,     0, 
    0,    56,   147,     0,     0,    60,   138,     0,     0,    63,   142,     0,     0,    23,   166,   250,     0,    24,   167,   250,     1,    20,   181,   250,     1,    13,   197,   247, 
    0,    15,   200,   209,     0,    14,   197,   158,     0,    14,   201,   101,     0,    14,   203,    57,     0,    15,   204,    19,     0,    17,   201,     4,     0,    23,   190,     0, 
    0,    29,   173,     0,     0,    39,   153,     0,     0,    48,   137,     0,     0,    54,   127,     0,     0,    59,   119,     0,     0,    60,   126,     0,     0,    23,   131,   251, 
    0,    25,   135,   251,     0,    21,   146,   251,     0,    15,   162,   251,     0,    15,   157,   201,     0,    15,   157,   155,     0,    15,   177,   102,     0,    16,   181,    63, 
    0,    17,   181,    25,     0,    19,   180,     8,     0,    23,   169,     1,     0,    31,   150,     0,     0,    40,   131,     0,     0,    47,   118,     0,     0,    52,   108,     0, 
    0,    56,   101,     0,     0,    57,   109,     0,     0,    24,   101,   252,     0,    25,   106,   252,     0,    22,   112,   252,     0,    18,   122,   252,     0,    19,   117,   200, 
    0,    14,   128,   156,     0,    20,   121,   109,     0,    20,   131,    73,     0,    21,   139,    35,     0,    21,   140,    15,     0,    24,   139,     4,     0,    31,   127,     0, 
    0,    39,   111,     0,     0,    45,   100,     0,     0,    51,    92,     0,     0,    55,    86,     0,     0,    55,    92,     0,     0,    25,    80,   252,     0,    25,    83,   252, 
    0,    22,    85,   252,     0,    20,    89,   246,     0,    21,    91,   197,     0,    18,    92,   150,     0,    22,    91,   103,     0,    23,   100,    78,     0,    24,   107,    44, 
    0,    24,   109,    23,     0,    25,   109,     9,     0,    30,   105,     1,     0,    37,    94,     0,     0,    44,    84,     0,     0,    50,    77,     0,     0,    54,    73,     0, 
    0,    54,    77,     0,     0,    25,    62,   253,     0,    24,    63,   253,     0,    22,    65,   253,     0,    21,    66,   233,     0,    24,    67,   194,     0,    25,    71,   146, 
    0,    25,    72,   104,     0,    24,    74,    79,     0,    25,    80,    55,     0,    25,    84,    36,     0,    26,    85,    15,     0,    29,    86,     4,     0,    36,    78,     0, 
    0,    43,    70,     0,     0,    49,    64,     0,     0,    53,    60,     0,     0,    54,    63,     0,     0,    25,    47,   253,     0,    24,    48,   253,     0,    23,    48,   249, 
    0,    25,    50,   222,     0,    27,    53,   192,     0,    26,    53,   143,     0,    26,    54,   104,     0,    28,    58,    77,     0,    31,    54,    55,     0,    30,    60,    42, 
    0,    29,    65,    21,     0,    31,    66,     9,     0,    36,    63,     1,     0,    43,    57,     0,     0,    48,    53,     0,     0,    52,    50,     0,     0,    55,    50,     0, 
    0,    25,    34,   253,     0,    23,    35,   253,     0,    23,    35,   250,     0,    23,    36,   230,     0,    29,    40,   197,     0,    26,    39,   166,     0,    27,    41,   112, 
    0,    28,    37,    77,     0,    31,    42,    57,     0,    32,    44,    46,     0,    30,    48,    31,     0,    32,    49,    19,     0,    39,    47,     8,     0,    43,    46,     1, 
    0,    47,    42,     0,     0,    50,    39,     0,     0,    53,    38,     0,     0,    23,    23,   253,     0,    25,    22,   254,     0,    25,    22,   253,     0,    27,    23,   244, 
    0,    31,    26,   215,     0,    27,    28,   179,     0,    26,    30,   131,     0,    28,    32,    93,     0,    30,    31,    61,     0,    32,    34,    47,     0,    32,    36,    36, 
    0,    34,    37,    22,     0,    41,    34,    10,     0,    45,    33,     1,     0,    46,    32,     0,     0,    47,    30,     0,     0,    49,    29,     0,     0,    23,    17,   254, 
    0,    26,    16,   254,     0,    27,    16,   254,     0,    28,    16,   251,     0,    30,    17,   228,     0,    30,    20,   199,     0,    27,    20,   157,     0,    29,    21,   110, 
    0,    31,    22,    71,     0,    31,    23,    50,     0,    33,    24,    39,     0,    35,    24,    30,     0,    42,    24,    12,     0,    47,    24,     2,     0,    48,    23,     0, 
    0,    47,    22,     0,     0,    46,    20,     0,     0,    27,    11,   254,     0,    30,    11,   254,     0,    32,    10,   254,     0,    34,    10,   251,     0,    37,    12,   229, 
    0,    37,    12,   201,     0,    36,    12,   164,     0,    36,    13,   122,     0,    38,    15,    89,     0,    38,    16,    59,     0,    37,    18,    43,     0,    38,    18,    30, 
    0,    41,    18,    17,     0,    45,    18,     7,     0,    48,    17,     1,     0,    46,    18,     0,     0,    46,    18,     0,     0,    34,     7,   254,     0,    35,     6,   254, 
    0,    37,     6,   253,     0,    39,     6,   245,     0,    41,     7,   222,     0,    43,     7,   198,     0,    42,     7,   166,     0,    42,     7,   127,     0,    43,     8,    96, 
    0,    44,     8,    70,     0,    42,    11,    49,     0,    40,    12,    34,     0,    42,    12,    23,     0,    42,    12,    13,     0,    47,    12,     5,     0,    47,    12,     0, 
    0,    47,    14,     0,     0,    41,     4,   254,     0,    42,     2,   253,     0,    42,     2,   250,     0,    44,     2,   232,     0,    45,     2,   211,     0,    46,     2,   190, 
    0,    45,     2,   157,     0,    46,     2,   124,     0,    47,     2,    96,     0,    47,     2,    72,     0,    47,     3,    55,     0,    45,     5,    39,     0,    46,     5,    29, 
    0,    47,     5,    18,     0,    47,     5,     8,     0,    50,     5,     1,     0,    50,    10,     0,     0,    49,     2,   254,     0,    49,     0,   245,     0,    49,     0,   231, 
    0,    48,     0,   209,     0,    48,     0,   187,     0,    47,     0,   161,     0,    46,     0,   129,     0,    46,     0,   104,     0,    46,     0,    83,     0,    46,     0,    66, 
    0,    46,     0,    52,     0,    46,     0,    40,     0,    48,     1,    32,     0,    49,     1,    23,     0,    49,     1,    14,     0,    50,     1,     5,     0,    55,     5,     0, 
    0,    58,     0,   254,     0,    57,     0,   246,     0,    56,     0,   236,     0,    56,     0,   223,     0,    55,     0,   205,     0,    55,     0,   179,     0,    54,     0,   143, 
    0,    53,     0,   113,     0,    53,     0,    89,     0,    53,     0,    69,     0,    53,     0,    56,     0,    53,     0,    45,     0,    55,     0,    40,     0,    57,     0,    31, 
    0,    60,     0,    20,     0,    62,     0,     9,     0,    65,     0,     0,     2,    10,   207,   250,     1,     9,   214,   249,     6,     0,   228,   241,     6,     0,   231,   219, 
    5,     0,   235,   194,     5,     0,   239,   154,     5,     0,   244,   100,     6,     0,   249,    53,     7,     0,   251,    25,     8,     0,   253,     9,     8,     0,   254,     0, 
    6,     7,   253,     0,     4,    11,   252,     0,     1,    25,   237,     0,     0,    35,   214,     0,     0,    45,   195,     0,     0,    55,   181,     0,     2,    10,   201,   250, 
    1,    10,   208,   250,     4,     1,   224,   247,     3,     0,   230,   225,     2,     0,   234,   189,     2,     0,   234,   131,     2,     0,   234,    83,     1,     3,   236,    44, 
    0,     8,   235,    22,     0,    12,   232,     9,     0,    13,   227,     2,     0,    17,   217,     1,     0,    22,   208,     1,     0,    30,   195,     0,     0,    38,   180,     0, 
    0,    47,   170,     0,     0,    52,   170,     0,     0,    14,   191,   250,     1,    12,   197,   250,     0,     8,   212,   248,     3,     0,   222,   227,     1,     3,   222,   189, 
    0,     5,   217,   134,     0,     6,   216,    84,     0,     6,   218,    46,     0,     7,   219,    21,     0,     9,   215,     7,     0,    13,   210,     1,     0,    19,   200,     0, 
    0,    24,   189,     0,     0,    32,   173,     0,     0,    41,   158,     0,     0,    47,   150,     0,     0,    49,   156,     0,     0,    15,   165,   251,     0,    15,   173,   251, 
    0,    12,   189,   250,     0,     8,   197,   246,     0,     7,   197,   212,     0,     7,   195,   166,     0,     7,   201,    93,     0,     7,   203,    53,     0,     8,   204,    24, 
    0,     9,   203,     7,     0,    14,   195,     0,     0,    20,   181,     0,     0,    26,   165,     0,     0,    34,   148,     0,     0,    40,   137,     0,     0,    46,   130,     0, 
    0,    47,   139,     0,     0,    16,   133,   251,     0,    16,   139,   251,     0,    13,   150,   251,     0,     9,   158,   247,     0,     7,   152,   203,     0,     8,   159,   159, 
    0,     8,   180,    95,     0,     9,   183,    59,     0,     9,   183,    28,     0,    10,   184,    10,     0,    14,   177,     1,     0,    21,   157,     0,     0,    27,   141,     0, 
    0,    33,   128,     0,     0,    39,   118,     0,     0,    45,   111,     0,     0,    46,   121,     0,     0,    17,   104,   252,     0,    18,   106,   252,     0,    15,   112,   252, 
    0,    11,   122,   251,     0,    11,   116,   200,     0,     8,   126,   156,     0,    12,   127,   111,     0,    12,   132,    77,     0,    13,   140,    40,     0,    13,   144,    19, 
    0,    15,   144,     6,     0,    20,   135,     1,     0,    26,   122,     0,     0,    32,   109,     0,     0,    38,    99,     0,     0,    43,    93,     0,     0,    43,   103,     0, 
    0,    18,    80,   252,     0,    18,    82,   252,     0,    16,    84,   252,     0,    14,    89,   240,     0,    14,    90,   193,     0,    11,    92,   153,     0,    13,    92,   106, 
    0,    15,   100,    80,     0,    15,   108,    48,     0,    15,   111,    27,     0,    15,   113,    11,     0,    19,   113,     2,     0,    25,   103,     0,     0,    31,    92,     0, 
    0,    37,    84,     0,     0,    42,    79,     0,     0,    42,    87,     0,     0,    19,    63,   253,     0,    17,    63,   253,     0,    16,    65,   253,     0,    16,    65,   226, 
    0,    16,    68,   190,     0,    16,    72,   147,     0,    17,    74,   105,     0,    15,    75,    81,     0,    16,    81,    60,     0,    16,    87,    39,     0,    17,    89,    17, 
    0,    18,    92,     5,     0,    23,    87,     0,     0,    30,    77,     0,     0,    36,    69,     0,     0,    41,    65,     0,     0,    40,    72,     0,     0,    19,    48,   253, 
    0,    18,    49,   253,     0,    17,    49,   248,     0,    20,    51,   217,     0,    21,    54,   188,     0,    18,    55,   144,     0,    19,    56,   107,     0,    20,    60,    79, 
    0,    20,    61,    58,     0,    19,    66,    44,     0,    19,    70,    23,     0,    19,    72,     9,     0,    23,    71,     2,     0,    30,    63,     0,     0,    36,    57,     0, 
    0,    39,    54,     0,     0,    40,    58,     0,     0,    19,    35,   253,     0,    18,    36,   252,     0,    17,    37,   242,     0,    20,    39,   218,     0,    21,    41,   190, 
    0,    19,    40,   148,     0,    20,    44,   109,     0,    21,    44,    78,     0,    22,    47,    59,     0,    25,    47,    47,     0,    23,    50,    34,     0,    22,    52,    22, 
    0,    26,    52,    10,     0,    31,    51,     1,     0,    35,    47,     0,     0,    38,    44,     0,     0,    40,    45,     0,     0,    18,    25,   254,     0,    19,    24,   254, 
    0,    19,    24,   251,     0,    22,    26,   232,     0,    23,    28,   204,     0,    20,    31,   168,     0,    21,    31,   108,     0,    21,    30,    79,     0,    22,    33,    58, 
    0,    25,    37,    45,     0,    26,    38,    34,     0,    25,    39,    25,     0,    28,    39,    14,     0,    31,    39,     4,     0,    34,    36,     0,     0,    37,    33,     0, 
    0,    40,    33,     0,     0,    17,    17,   254,     0,    19,    17,   254,     0,    20,    17,   253,     0,    22,    18,   243,     0,    26,    20,   217,     0,    20,    22,   182, 
    0,    19,    23,   146,     0,    21,    24,   101,     0,    22,    24,    70,     0,    24,    26,    49,     0,    26,    28,    37,     0,    25,    29,    29,     0,    29,    27,    15, 
    0,    32,    27,     5,     0,    35,    26,     0,     0,    36,    24,     0,     0,    38,    24,     0,     0,    17,    13,   254,     0,    20,    12,   254,     0,    21,    11,   254, 
    0,    23,    11,   251,     0,    26,    13,   227,     0,    25,    13,   198,     0,    23,    13,   162,     0,    22,    14,   119,     0,    23,    15,    86,     0,    25,    17,    57, 
    0,    26,    18,    40,     0,    26,    19,    30,     0,    27,    19,    23,     0,    33,    18,     7,     0,    36,    18,     1,     0,    36,    17,     0,     0,    35,    16,     0, 
    0,    22,     8,   254,     0,    24,     7,   254,     0,    25,     6,   254,     0,    26,     6,   251,     0,    30,     8,   227,     0,    29,     8,   202,     0,    28,     8,   170, 
    0,    27,     8,   129,     0,    29,     9,    97,     0,    30,    10,    71,     0,    30,    11,    49,     0,    29,    13,    34,     0,    31,    13,    23,     0,    33,    12,    11, 
    0,    36,    13,     3,     0,    36,    13,     0,     0,    36,    13,     0,     0,    28,     5,   254,     0,    29,     3,   254,     0,    30,     2,   252,     0,    30,     2,   243, 
    0,    32,     3,   217,     0,    32,     3,   196,     0,    32,     3,   166,     0,    32,     3,   127,     0,    34,     3,    98,     0,    35,     4,    74,     0,    35,     4,    57, 
    0,    33,     6,    39,     0,    33,     7,    26,     0,    33,     7,    17,     0,    34,     7,     7,     0,    36,     7,     1,     0,    38,    10,     0,     0,    35,     2,   254, 
    0,    35,     0,   249,     0,    35,     0,   240,     0,    35,     0,   224,     0,    35,     0,   194,     0,    36,     0,   167,     0,    35,     0,   137,     0,    35,     0,   108, 
    0,    36,     0,    87,     0,    37,     0,    69,     0,    37,     0,    55,     0,    37,     1,    42,     0,    37,     1,    30,     0,    38,     1,    22,     0,    38,     1,    12, 
    0,    38,     1,     3,     0,    42,     5,     0,     0,    43,     0,   254,     0,    42,     0,   247,     0,    42,     0,   239,     0,    42,     0,   228,     0,    43,     0,   211, 
    0,    43,     0,   181,     0,    42,     0,   148,     0,    42,     0,   117,     0,    43,     0,    92,     0,    43,     0,    71,     0,    43,     0,    57,     0,    43,     0,    46, 
    0,    43,     0,    37,     0,    45,     0,    31,     0,    47,     0,    21,     0,    49,     0,    10,     0,    50,     0,     0,     0,     9,   207,   250,     0,     7,   213,   250, 
    4,     0,   227,   247,     4,     0,   230,   227,     3,     0,   234,   205,     4,     0,   237,   172,     4,     0,   242,   123,     4,     0,   247,    74,     4,     0,   250,    41, 
    6,     0,   252,    20,     6,     0,   253,     8,     6,     0,   254,     0,     4,     6,   253,     0,     3,     9,   253,     0,     0,    22,   235,     0,     0,    31,   213,     0, 
    0,    40,   194,     0,     0,     9,   200,   250,     0,     6,   207,   250,     2,     0,   221,   249,     1,     0,   225,   228,     0,     0,   225,   195,     0,     1,   224,   144, 
    0,     1,   227,   100,     0,     1,   231,    62,     0,     3,   233,    32,     0,     6,   230,    17,     0,     8,   228,     7,     0,    10,   223,     2,     0,    14,   216,     1, 
    0,    18,   208,     1,     0,    25,   197,     0,     0,    33,   184,     0,     0,    37,   184,     0,     0,    10,   189,   250,     0,     7,   195,   250,     0,     3,   210,   247, 
    0,     1,   214,   223,     0,     0,   212,   190,     0,     0,   207,   138,     0,     0,   211,    93,     0,     1,   214,    60,     0,     2,   216,    31,     0,     4,   215,    13, 
    0,     6,   212,     3,     0,    11,   205,     0,     0,    16,   196,     0,     0,    21,   187,     0,     0,    28,   173,     0,     0,    33,   164,     0,     0,    36,   171,     0, 
    0,    10,   164,   251,     0,     8,   169,   251,     0,     5,   186,   250,     0,     3,   192,   241,     0,     2,   191,   210,     0,     1,   191,   166,     0,     1,   199,    96, 
    0,     1,   200,    61,     0,     2,   202,    32,     0,     3,   203,    13,     0,     6,   200,     2,     0,    13,   188,     0,     0,    18,   175,     0,     0,    23,   162,     0, 
    0,    28,   151,     0,     0,    33,   142,     0,     0,    34,   155,     0,     0,    12,   135,   252,     0,    10,   138,   252,     0,     7,   149,   251,     0,     4,   155,   244, 
    0,     3,   154,   202,     0,     2,   158,   159,     0,     1,   179,    95,     0,     2,   182,    63,     0,     3,   182,    36,     0,     3,   185,    16,     0,     5,   183,     3, 
    0,    11,   168,     0,     0,    17,   152,     0,     0,    22,   139,     0,     0,    27,   129,     0,     0,    33,   121,     0,     0,    34,   136,     0,     0,    13,   106,   252, 
    0,    12,   106,   252,     0,    10,   112,   252,     0,     7,   120,   241,     0,     5,   120,   200,     0,     4,   123,   156,     0,     5,   125,   111,     0,     6,   130,    82, 
    0,     6,   139,    47,     0,     6,   145,    25,     0,     6,   148,    10,     0,     9,   144,     1,     0,    16,   131,     0,     0,    21,   119,     0,     0,    27,   108,     0, 
    0,    32,   101,     0,     0,    33,   116,     0,     0,    13,    82,   253,     0,    12,    82,   253,     0,    10,    86,   251,     0,     9,    90,   234,     0,     8,    92,   197, 
    0,     5,    94,   158,     0,     6,    92,   105,     0,     8,    98,    83,     0,     8,   107,    54,     0,     8,   113,    32,     0,     8,   116,    16,     0,     9,   117,     4, 
    0,    14,   110,     0,     0,    20,   101,     0,     0,    27,    91,     0,     0,    32,    85,     0,     0,    32,    97,     0,     0,    14,    63,   253,     0,    12,    63,   253, 
    0,    10,    64,   253,     0,    11,    65,   224,     0,    10,    68,   192,     0,    10,    71,   149,     0,    10,    73,   107,     0,     9,    76,    83,     0,     9,    82,    64, 
    0,     8,    89,    44,     0,     9,    93,    22,     0,     9,    95,     7,     0,    13,    93,     1,     0,    19,    85,     0,     0,    26,    76,     0,     0,    31,    70,     0, 
    0,    31,    81,     0,     0,    14,    49,   253,     0,    12,    49,   253,     0,    11,    50,   246,     0,    12,    52,   215,     0,    14,    55,   186,     0,    11,    56,   145, 
    0,    12,    58,   109,     0,    12,    61,    81,     0,    12,    62,    61,     0,    10,    69,    47,     0,    10,    74,    26,     0,     9,    76,    11,     0,    12,    77,     1, 
    0,    18,    70,     0,     0,    26,    62,     0,     0,    30,    58,     0,     0,    30,    65,     0,     0,    14,    36,   253,     0,    13,    37,   253,     0,    13,    38,   244, 
    0,    14,    41,   214,     0,    15,    43,   186,     0,    13,    43,   144,     0,    14,    45,   109,     0,    14,    48,    81,     0,    14,    50,    62,     0,    14,    52,    47, 
    0,    13,    55,    34,     0,    12,    58,    22,     0,    13,    60,     6,     0,    19,    57,     1,     0,    25,    51,     0,     0,    29,    48,     0,     0,    30,    53,     0, 
    0,    13,    26,   254,     0,    14,    25,   254,     0,    14,    26,   250,     0,    15,    29,   218,     0,    14,    32,   186,     0,    13,    33,   166,     0,    14,    33,   109, 
    0,    15,    35,    82,     0,    14,    40,    63,     0,    16,    39,    46,     0,    19,    39,    35,     0,    17,    42,    26,     0,    16,    44,    13,     0,    20,    45,     5, 
    0,    25,    41,     0,     0,    29,    38,     0,     0,    29,    42,     0,     0,    13,    19,   254,     0,    14,    18,   254,     0,    15,    18,   253,     0,    17,    21,   235, 
    0,    15,    23,   200,     0,    14,    24,   170,     0,    13,    24,   129,     0,    15,    26,    92,     0,    16,    26,    65,     0,    17,    28,    48,     0,    20,    31,    37, 
    0,    20,    32,    28,     0,    18,    33,    19,     0,    19,    34,    10,     0,    25,    32,     1,     0,    28,    29,     0,     0,    29,    30,     0,     0,    13,    13,   254, 
    0,    14,    12,   254,     0,    15,    12,   254,     0,    17,    13,   247,     0,    19,    14,   217,     0,    17,    15,   189,     0,    15,    15,   154,     0,    14,    18,   112, 
    0,    15,    19,    79,     0,    17,    20,    56,     0,    19,    21,    39,     0,    20,    22,    27,     0,    19,    23,    20,     0,    21,    23,    10,     0,    25,    22,     1, 
    0,    27,    20,     0,     0,    28,    20,     0,     0,    12,     9,   254,     0,    15,     8,   254,     0,    16,     7,   254,     0,    17,     7,   251,     0,    20,     8,   228, 
    0,    19,     9,   201,     0,    17,     9,   170,     0,    13,    10,   130,     0,    15,    11,    94,     0,    16,    11,    68,     0,    18,    12,    46,     0,    19,    14,    31, 
    0,    20,    14,    21,     0,    20,    14,    17,     0,    26,    14,     2,     0,    27,    13,     0,     0,    26,    12,     0,     0,    18,     5,   254,     0,    19,     4,   254, 
    0,    20,     3,   254,     0,    20,     3,   249,     0,    22,     4,   229,     0,    22,     4,   204,     0,    22,     4,   176,     0,    21,     5,   136,     0,    22,     5,   102, 
    0,    22,     5,    77,     0,    24,     6,    58,     0,    24,     7,    39,     0,    23,     8,    25,     0,    24,     8,    17,     0,    25,     8,     6,     0,    27,     8,     1, 
    0,    27,     9,     0,     0,    24,     2,   254,     0,    25,     1,   252,     0,    24,     0,   246,     0,    25,     0,   236,     0,    25,     0,   219,     0,    25,     0,   191, 
    0,    25,     0,   158,     0,    26,     0,   125,     0,    26,     1,    98,     0,    27,     1,    77,     0,    28,     1,    60,     0,    29,     1,    46,     0,    27,     2,    31, 
    0,    29,     2,    21,     0,    29,     2,    11,     0,    29,     2,     2,     0,    31,     5,     0,     0,    30,     0,   254,     0,    30,     0,   248,     0,    30,     0,   241, 
    0,    30,     0,   233,     0,    30,     0,   219,     0,    30,     0,   187,     0,    31,     0,   153,     0,    31,     0,   122,     0,    31,     0,    96,     0,    32,     0,    75, 
    0,    32,     0,    60,     0,    32,     0,    48,     0,    32,     0,    37,     0,    33,     0,    29,     0,    35,     0,    21,     0,    36,     0,    11,     0,    37,     0,     0, 
    0,     6,   210,   250,     0,     5,   213,   250,     2,     0,   224,   248,     2,     0,   230,   231,     1,     0,   233,   211,     2,     0,   236,   184,     2,     0,   240,   144, 
    2,     0,   245,    96,     2,     0,   249,    59,     3,     0,   251,    33,     4,     0,   253,    18,     4,     0,   254,     8,     4,     0,   254,     0,     3,     4,   254,     0, 
    2,     6,   253,     0,     0,    18,   234,     0,     0,    28,   212,     0,     0,     6,   200,   250,     0,     3,   206,   250,     0,     1,   215,   244,     0,     0,   215,   221, 
    0,     0,   215,   195,     0,     0,   213,   148,     0,     0,   218,   109,     0,     0,   223,    76,     0,     1,   227,    46,     0,     1,   230,    25,     0,     3,   229,    13, 
    0,     5,   227,     4,     0,     7,   222,     1,     0,    10,   216,     0,     0,    14,   211,     0,     0,    21,   202,     0,     0,    25,   201,     0,     0,     7,   186,   251, 
    0,     4,   192,   250,     0,     0,   200,   237,     0,     0,   199,   207,     0,     0,   198,   183,     0,     0,   199,   135,     0,     0,   203,    99,     0,     0,   207,    70, 
    0,     0,   210,    43,     0,     0,   213,    21,     0,     2,   213,     9,     0,     5,   210,     1,     0,    10,   203,     0,     0,    14,   196,     0,     0,    17,   189,     0, 
    0,    22,   182,     0,     0,    24,   190,     0,     0,     7,   163,   251,     0,     4,   165,   251,     0,     1,   177,   241,     0,     0,   177,   206,     0,     0,   177,   170, 
    0,     0,   183,   130,     0,     0,   191,    92,     0,     0,   192,    66,     0,     0,   194,    44,     0,     0,   198,    23,     0,     1,   199,     8,     0,     4,   195,     1, 
    0,     9,   186,     0,     0,    13,   177,     0,     0,    17,   167,     0,     0,    22,   159,     0,     0,    24,   175,     0,     0,     7,   136,   252,     0,     5,   138,   252, 
    0,     2,   147,   247,     0,     1,   149,   214,     0,     0,   149,   166,     0,     0,   154,   131,     0,     0,   170,    93,     0,     0,   173,    66,     0,     0,   176,    45, 
    0,     0,   178,    25,     0,     0,   182,    10,     0,     3,   178,     1,     0,     8,   164,     0,     0,    12,   152,     0,     0,    16,   142,     0,     0,    22,   134,     0, 
    0,    23,   155,     0,     0,     8,   108,   252,     0,     7,   109,   252,     0,     4,   116,   249,     0,     3,   119,   220,     0,     2,   121,   180,     0,     0,   120,   145, 
    0,     1,   121,   109,     0,     1,   127,    85,     0,     1,   137,    54,     0,     1,   143,    31,     0,     1,   149,    15,     0,     1,   150,     3,     0,     7,   139,     0, 
    0,    12,   128,     0,     0,    16,   119,     0,     0,    22,   112,     0,     0,    23,   132,     0,     0,     8,    84,   253,     0,     7,    85,   253,     0,     5,    89,   250, 
    0,     5,    91,   223,     0,     3,    94,   189,     0,     1,    95,   153,     0,     1,    92,   106,     0,     2,    98,    85,     0,     2,   106,    59,     0,     2,   113,    38, 
    0,     2,   118,    21,     0,     2,   121,     8,     0,     5,   117,     1,     0,    11,   107,     0,     0,    16,    99,     0,     0,    22,    93,     0,     0,    22,   110,     0, 
    0,     9,    64,   253,     0,     7,    64,   253,     0,     5,    65,   248,     0,     5,    66,   222,     0,     5,    69,   191,     0,     4,    71,   151,     0,     3,    73,   107, 
    0,     3,    77,    84,     0,     3,    82,    65,     0,     2,    89,    49,     0,     3,    95,    26,     0,     3,    98,    12,     0,     4,    98,     1,     0,    10,    90,     0, 
    0,    16,    82,     0,     0,    22,    77,     0,     0,    22,    91,     0,     0,     9,    50,   253,     0,     7,    50,   253,     0,     5,    51,   243,     0,     5,    52,   213, 
    0,     6,    55,   184,     0,     5,    57,   144,     0,     5,    58,   108,     0,     5,    61,    83,     0,     6,    62,    63,     0,     4,    69,    51,     0,     3,    77,    30, 
    0,     3,    79,    16,     0,     3,    80,     3,     0,     9,    75,     0,     0,    15,    68,     0,     0,    21,    63,     0,     0,    21,    74,     0,     0,     9,    38,   253, 
    0,     7,    38,   253,     0,     7,    39,   245,     0,     8,    41,   210,     0,     8,    43,   180,     0,     7,    44,   140,     0,     7,    46,   109,     0,     7,    49,    84, 
    0,     8,    51,    63,     0,     7,    54,    48,     0,     5,    58,    36,     0,     4,    62,    25,     0,     4,    65,     8,     0,     8,    62,     0,     0,    15,    56,     0, 
    0,    21,    52,     0,     0,    21,    60,     0,     0,     9,    27,   254,     0,     9,    27,   254,     0,     9,    27,   250,     0,     8,    31,   213,     0,     8,    33,   170, 
    0,     8,    33,   138,     0,     8,    36,   107,     0,     9,    37,    83,     0,     7,    41,    64,     0,     9,    40,    47,     0,    10,    41,    36,     0,     8,    46,    26, 
    0,     7,    50,    14,     0,     8,    51,     2,     0,    15,    46,     0,     0,    21,    42,     0,     0,    21,    49,     0,     0,     9,    20,   254,     0,    10,    19,   254, 
    0,    10,    20,   251,     0,    11,    23,   224,     0,     9,    25,   187,     0,     8,    26,   160,     0,     8,    26,   124,     0,     9,    28,    89,     0,     9,    30,    64, 
    0,    10,    30,    47,     0,    13,    33,    36,     0,    14,    33,    27,     0,    12,    36,    20,     0,    10,    37,    10,     0,    14,    37,     1,     0,    20,    33,     0, 
    0,    20,    38,     0,     0,     9,    15,   254,     0,    10,    13,   254,     0,    10,    13,   253,     0,    14,    15,   241,     0,    12,    16,   213,     0,    11,    17,   179, 
    0,     8,    17,   146,     0,     8,    20,   102,     0,    11,    21,    65,     0,    12,    22,    48,     0,    13,    23,    37,     0,    15,    25,    26,     0,    16,    25,    19, 
    0,    14,    26,    13,     0,    16,    27,     4,     0,    19,    25,     0,     0,    19,    27,     0,     0,     8,    10,   254,     0,    10,     8,   254,     0,    10,     8,   254, 
    0,    11,     8,   248,     0,    14,    10,   223,     0,    12,    10,   192,     0,     9,    10,   157,     0,     6,    13,   116,     0,     8,    14,    84,     0,    10,    15,    62, 
    0,    12,    15,    44,     0,    14,    17,    30,     0,    15,    17,    20,     0,    13,    18,    15,     0,    16,    18,     5,     0,    18,    16,     0,     0,    19,    17,     0, 
    0,     8,     6,   255,     0,    10,     4,   255,     0,    11,     4,   254,     0,    11,     3,   250,     0,    14,     5,   230,     0,    12,     5,   205,     0,    11,     5,   176, 
    0,    10,     6,   134,     0,    11,     6,   100,     0,    11,     6,    75,     0,    13,     7,    56,     0,    14,     8,    37,     0,    14,     9,    23,     0,    14,     9,    16, 
    0,    14,    10,    12,     0,    18,     9,     0,     0,    17,     8,     0,     0,    14,     3,   255,     0,    15,     1,   254,     0,    15,     1,   251,     0,    15,     0,   245, 
    0,    15,     1,   231,     0,    15,     1,   209,     0,    15,     1,   180,     0,    15,     1,   141,     0,    16,     2,   107,     0,    16,     2,    83,     0,    17,     2,    63, 
    0,    18,     2,    47,     0,    18,     3,    31,     0,    18,     3,    21,     0,    21,     2,    11,     0,    20,     3,     0,     0,    20,     5,     0,     0,    20,     0,   255, 
    0,    20,     0,   249,     0,    20,     0,   243,     0,    20,     0,   236,     0,    20,     0,   227,     0,    20,     0,   205,     0,    21,     0,   169,     0,    21,     0,   136, 
    0,    21,     0,   105,     0,    22,     0,    81,     0,    22,     0,    62,     0,    23,     0,    49,     0,    23,     0,    38,     0,    23,     0,    28,     0,    24,     0,    21, 
    0,    25,     0,    11,     0,    25,     0,     0,     0,     3,   213,   250,     0,     2,   215,   250,     1,     0,   221,   247,     1,     0,   225,   231,     0,     0,   228,   213, 
    0,     0,   232,   191,     1,     0,   237,   160,     0,     0,   241,   117,     1,     0,   246,    79,     1,     0,   249,    49,     2,     0,   252,    29,     2,     0,   253,    17, 
    2,     0,   254,     9,     2,     0,   254,     2,     2,     1,   254,     0,     1,     3,   254,     0,     0,    15,   234,     0,     0,     3,   201,   250,     0,     1,   206,   247, 
    0,     0,   207,   235,     0,     0,   207,   213,     0,     0,   207,   192,     0,     0,   206,   156,     0,     0,   211,   119,     0,     0,   217,    90,     0,     0,   222,    63, 
    0,     0,   227,    37,     0,     1,   229,    22,     0,     1,   230,    12,     0,     2,   229,     4,     0,     5,   224,     1,     0,     7,   220,     1,     0,    10,   216,     0, 
    0,    12,   217,     0,     0,     4,   184,   251,     0,     1,   189,   246,     0,     0,   188,   220,     0,     0,   186,   195,     0,     0,   185,   174,     0,     0,   188,   139, 
    0,     0,   197,   104,     0,     0,   201,    77,     0,     0,   204,    57,     0,     0,   208,    34,     0,     0,   211,    19,     0,     0,   212,     9,     0,     2,   211,     2, 
    0,     5,   206,     1,     0,     8,   202,     0,     0,    10,   199,     0,     0,    12,   207,     0,     0,     3,   161,   251,     0,     1,   163,   248,     0,     0,   163,   223, 
    0,     0,   161,   185,     0,     0,   161,   152,     0,     0,   167,   131,     0,     0,   180,   100,     0,     0,   184,    75,     0,     0,   188,    55,     0,     0,   191,    34, 
    0,     0,   195,    19,     0,     0,   197,     8,     0,     2,   195,     1,     0,     5,   189,     0,     0,     8,   183,     0,     0,    11,   179,     0,     0,    12,   195,     0, 
    0,     3,   136,   252,     0,     2,   138,   249,     0,     0,   139,   230,     0,     0,   136,   191,     0,     0,   137,   142,     0,     0,   139,   118,     0,     1,   145,    98, 
    0,     1,   151,    76,     0,     0,   164,    56,     0,     0,   168,    36,     0,     0,   173,    21,     0,     0,   177,     9,     0,     1,   175,     2,     0,     5,   165,     0, 
    0,     8,   156,     0,     0,    11,   152,     0,     0,    11,   178,     0,     0,     4,   110,   252,     0,     3,   111,   251,     0,     1,   116,   240,     0,     0,   115,   204, 
    0,     0,   116,   159,     0,     0,   114,   128,     0,     0,   113,   106,     0,     0,   118,    89,     0,     0,   128,    61,     0,     0,   134,    41,     0,     0,   140,    26, 
    0,     0,   145,    13,     0,     1,   146,     3,     0,     5,   139,     0,     0,     8,   131,     0,     0,    12,   127,     0,     0,    11,   154,     0,     0,     4,    86,   253, 
    0,     3,    87,   252,     0,     1,    91,   246,     0,     1,    91,   216,     0,     0,    93,   178,     0,     0,    93,   139,     0,     0,    92,   101,     0,     0,    96,    83, 
    0,     0,   103,    61,     0,     0,   107,    45,     0,     0,   113,    29,     0,     0,   117,    17,     0,     1,   119,     6,     0,     4,   114,     1,     0,     8,   108,     0, 
    0,    12,   105,     0,     0,    11,   128,     0,     0,     4,    65,   253,     0,     3,    65,   253,     0,     1,    66,   245,     0,     1,    68,   221,     0,     1,    71,   190, 
    0,     0,    73,   147,     0,     0,    75,   107,     0,     0,    77,    82,     0,     0,    80,    65,     0,     0,    86,    53,     0,     0,    93,    33,     0,     0,    96,    20, 
    0,     0,    98,     8,     0,     3,    95,     1,     0,     8,    89,     0,     0,    12,    86,     0,     0,    11,   105,     0,     0,     5,    51,   254,     0,     3,    51,   252, 
    0,     1,    53,   241,     0,     1,    54,   217,     0,     1,    57,   190,     0,     1,    59,   151,     0,     1,    61,   114,     0,     0,    62,    84,     0,     0,    62,    64, 
    0,     0,    68,    51,     0,     0,    76,    34,     0,     0,    78,    23,     0,     0,    80,    11,     0,     2,    79,     1,     0,     7,    73,     0,     0,    12,    71,     0, 
    0,    11,    85,     0,     0,     5,    39,   254,     0,     3,    39,   253,     0,     2,    40,   243,     0,     2,    43,   215,     0,     2,    45,   188,     0,     1,    46,   150, 
    0,     1,    48,   114,     0,     1,    50,    88,     0,     2,    51,    65,     0,     0,    55,    51,     0,     1,    59,    38,     0,     0,    62,    28,     0,     0,    65,    14, 
    0,     1,    66,     3,     0,     7,    61,     0,     0,    12,    58,     0,     0,    11,    69,     0,     0,     4,    28,   254,     0,     5,    28,   254,     0,     4,    29,   250, 
    0,     3,    32,   219,     0,     3,    35,   185,     0,     2,    36,   144,     0,     3,    38,   106,     0,     3,    39,    85,     0,     1,    41,    65,     0,     3,    42,    49, 
    0,     3,    44,    35,     0,     1,    50,    28,     0,     1,    53,    16,     0,     1,    54,     5,     0,     6,    50,     1,     0,    12,    47,     0,     0,    11,    56,     0, 
    0,     5,    21,   254,     0,     5,    21,   254,     0,     5,    21,   252,     0,     4,    24,   228,     0,     4,    26,   196,     0,     3,    28,   158,     0,     3,    29,   121, 
    0,     3,    30,    91,     0,     3,    30,    65,     0,     1,    32,    49,     0,     6,    33,    36,     0,     4,    36,    28,     0,     3,    40,    19,     0,     2,    42,    11, 
    0,     5,    40,     1,     0,    11,    38,     0,     0,    11,    44,     0,     0,     5,    15,   254,     0,     5,    14,   254,     0,     5,    14,   253,     0,     8,    16,   239, 
    0,     7,    18,   211,     0,     6,    19,   172,     0,     2,    19,   136,     0,     2,    22,    97,     0,     4,    23,    67,     0,     3,    24,    51,     0,     6,    25,    37, 
    0,     7,    27,    27,     0,    10,    27,    18,     0,     7,    30,    13,     0,     6,    30,     4,     0,    10,    30,     0,     0,    10,    34,     0,     0,     4,    10,   255, 
    0,     5,     9,   254,     0,     5,     9,   253,     0,     7,    10,   243,     0,     7,    11,   220,     0,     6,    12,   190,     0,     3,    12,   145,     0,     1,    15,   105, 
    0,     2,    16,    77,     0,     4,    17,    56,     0,     5,    18,    40,     0,     7,    19,    31,     0,     9,    19,    20,     0,     8,    21,    14,     0,     5,    22,     6, 
    0,     7,    22,     1,     0,    10,    24,     0,     0,     4,     6,   255,     0,     5,     4,   254,     0,     5,     4,   253,     0,     5,     4,   247,     0,     8,     6,   227, 
    0,     6,     6,   201,     0,     5,     7,   160,     0,     4,     7,   121,     0,     4,     8,    89,     0,     3,    10,    67,     0,     5,    11,    49,     0,     6,    11,    35, 
    0,     8,    12,    23,     0,     8,    13,    14,     0,     6,    15,     4,     0,     8,    14,     0,     0,     9,    14,     0,     0,     4,     3,   255,     0,     6,     1,   254, 
    0,     6,     1,   253,     0,     6,     1,   250,     0,     6,     1,   235,     0,     6,     2,   211,     0,     6,     2,   182,     0,     6,     2,   138,     0,     5,     2,   103, 
    0,     3,     3,    78,     0,     4,     3,    58,     0,     6,     4,    42,     0,     7,     4,    27,     0,     8,     5,    18,     0,    10,     4,    10,     0,     7,     5,     6, 
    0,     8,     4,     0,     0,    10,     0,   255,     0,    10,     0,   250,     0,    10,     0,   246,     0,    10,     0,   241,     0,    10,     0,   235,     0,    10,     0,   219, 
    0,    10,     0,   191,     0,    10,     0,   154,     0,    10,     0,   116,     0,    10,     0,    88,     0,    11,     0,    66,     0,    12,     0,    50,     0,    13,     0,    37, 
    0,    12,     0,    27,     0,    12,     0,    18,     0,    12,     0,    10,     0,    13,     0,     0,     0,     0,   216,   250,     0,     0,   216,   247,     0,     0,   217,   239, 
    0,     0,   218,   227,     0,     0,   221,   211,     0,     0,   224,   191,     0,     0,   228,   165,     0,     0,   233,   134,     0,     0,   239,   100,     0,     0,   244,    68, 
    0,     0,   248,    44,     0,     0,   250,    28,     0,     0,   252,    18,     0,     0,   254,    10,     0,     0,   254,     5,     0,     0,   255,     2,     0,     0,   255,     0, 
    0,     0,   203,   251,     0,     0,   203,   227,     0,     0,   203,   218,     0,     0,   203,   204,     0,     0,   205,   188,     0,     0,   207,   164,     0,     0,   210,   138, 
    0,     0,   217,   113,     0,     0,   223,    89,     0,     0,   228,    61,     0,     0,   233,    38,     0,     0,   236,    26,     0,     0,   238,    17,     0,     0,   239,    10, 
    0,     0,   240,     5,     0,     0,   240,     2,     0,     0,   240,     0,     0,     0,   185,   251,     0,     0,   187,   230,     0,     0,   186,   202,     0,     0,   186,   187, 
    0,     0,   187,   165,     0,     0,   194,   138,     0,     0,   198,   117,     0,     0,   203,    98,     0,     0,   207,    78,     0,     0,   212,    55,     0,     0,   217,    35, 
    0,     0,   220,    24,     0,     0,   222,    16,     0,     0,   223,     9,     0,     0,   224,     5,     0,     0,   224,     3,     0,     0,   225,     0,     0,     0,   161,   252, 
    0,     0,   162,   233,     0,     0,   163,   207,     0,     0,   165,   171,     0,     0,   167,   148,     0,     0,   176,   125,     0,     0,   187,   113,     0,     0,   190,    95, 
    0,     0,   194,    72,     0,     0,   197,    51,     0,     0,   202,    33,     0,     0,   206,    22,     0,     0,   208,    14,     0,     0,   209,     8,     0,     0,   210,     4, 
    0,     0,   210,     2,     0,     0,   211,     0,     0,     0,   136,   252,     0,     0,   138,   236,     0,     0,   139,   211,     0,     0,   139,   178,     0,     0,   144,   135, 
    0,     0,   145,   111,     0,     0,   164,   109,     0,     0,   172,    98,     0,     0,   175,    77,     0,     0,   179,    53,     0,     0,   184,    35,     0,     0,   189,    22, 
    0,     0,   193,    13,     0,     0,   194,     7,     0,     0,   195,     3,     0,     0,   196,     1,     0,     0,   196,     0,     0,     0,   111,   253,     0,     0,   114,   239, 
    0,     0,   115,   217,     0,     0,   117,   188,     0,     0,   120,   147,     0,     0,   124,   105,     0,     0,   128,    95,     0,     0,   131,    85,     0,     0,   136,    72, 
    0,     0,   143,    55,     0,     0,   154,    40,     0,     0,   163,    26,     0,     0,   170,    15,     0,     0,   174,     7,     0,     0,   176,     3,     0,     0,   177,     1, 
    0,     0,   177,     0,     0,     0,    87,   253,     0,     0,    90,   243,     0,     0,    92,   225,     0,     0,    95,   198,     0,     0,    99,   163,     0,     0,   101,   118, 
    0,     0,   104,    86,     0,     0,   106,    78,     0,     0,   109,    69,     0,     0,   115,    57,     0,     0,   123,    43,     0,     0,   130,    30,     0,     0,   137,    19, 
    0,     0,   142,     9,     0,     0,   145,     4,     0,     0,   147,     2,     0,     0,   150,     0,     0,     0,    67,   254,     0,     0,    68,   248,     0,     0,    71,   233, 
    0,     0,    74,   208,     0,     0,    78,   177,     0,     0,    82,   134,     0,     0,    85,    98,     0,     0,    87,    75,     0,     0,    90,    67,     0,     0,    94,    58, 
    0,     0,    99,    45,     0,     0,   104,    33,     0,     0,   109,    22,     0,     0,   114,    12,     0,     0,   118,     5,     0,     0,   120,     2,     0,     0,   123,     0, 
    0,     0,    52,   254,     0,     0,    53,   250,     0,     0,    56,   237,     0,     0,    58,   215,     0,     0,    61,   188,     0,     0,    64,   147,     0,     0,    67,   110, 
    0,     0,    70,    84,     0,     0,    72,    63,     0,     0,    76,    56,     0,     0,    80,    46,     0,     0,    85,    34,     0,     0,    89,    25,     0,     0,    93,    15, 
    0,     0,    96,     7,     0,     0,    98,     2,     0,     0,   100,     0,     0,     0,    40,   254,     0,     0,    40,   251,     0,     0,    42,   241,     0,     0,    45,   219, 
    0,     0,    49,   193,     0,     0,    52,   156,     0,     0,    54,   118,     0,     0,    56,    88,     0,     0,    58,    66,     0,     0,    62,    50,     0,     0,    64,    44, 
    0,     0,    67,    36,     0,     0,    71,    25,     0,     0,    74,    16,     0,     0,    77,     8,     0,     0,    79,     3,     0,     0,    81,     0,     0,     0,    30,   254, 
    0,     0,    30,   254,     0,     0,    31,   248,     0,     0,    34,   224,     0,     0,    38,   195,     0,     0,    41,   152,     0,     0,    41,   103,     0,     0,    42,    83, 
    0,     0,    46,    68,     0,     0,    46,    49,     0,     0,    52,    40,     0,     0,    54,    35,     0,     0,    57,    26,     0,     0,    60,    18,     0,     0,    62,    10, 
    0,     0,    64,     3,     0,     0,    66,     0,     0,     0,    22,   255,     0,     0,    22,   252,     0,     0,    23,   250,     0,     0,    24,   238,     0,     0,    28,   205, 
    0,     0,    31,   158,     0,     0,    33,   115,     0,     0,    34,    88,     0,     0,    36,    67,     0,     0,    37,    51,     0,     0,    37,    38,     0,     0,    42,    32, 
    0,     0,    45,    27,     0,     0,    47,    21,     0,     0,    49,    11,     0,     0,    51,     4,     0,     0,    53,     0,     0,     0,    16,   255,     0,     0,    15,   250, 
    0,     0,    16,   246,     0,     0,    17,   238,     0,     0,    19,   213,     0,     0,    22,   177,     0,     0,    24,   123,     0,     0,    26,    91,     0,     0,    27,    67, 
    0,     0,    29,    51,     0,     0,    29,    41,     0,     0,    30,    33,     0,     0,    33,    25,     0,     0,    36,    20,     0,     0,    38,    11,     0,     0,    39,     5, 
    0,     0,    41,     0,     0,     0,    10,   255,     0,     0,    10,   250,     0,     0,    10,   245,     0,     0,    11,   237,     0,     0,    12,   216,     0,     0,    14,   182, 
    0,     0,    16,   122,     0,     0,    18,    86,     0,     0,    19,    67,     0,     0,    20,    50,     0,     0,    21,    41,     0,     0,    22,    35,     0,     0,    23,    27, 
    0,     0,    26,    20,     0,     0,    28,    13,     0,     0,    29,     8,     0,     0,    30,     0,     0,     0,     6,   255,     0,     0,     6,   250,     0,     0,     6,   246, 
    0,     0,     6,   241,     0,     0,     7,   225,     0,     0,     8,   198,     0,     0,     9,   153,     0,     0,    11,   101,     0,     0,    12,    73,     0,     0,    13,    52, 
    0,     0,    14,    39,     0,     0,    14,    33,     0,     0,    15,    29,     0,     0,    16,    23,     0,     0,    18,    14,     0,     0,    19,     8,     0,     0,    20,     0, 
    0,     0,     2,   255,     0,     0,     2,   251,     0,     0,     2,   247,     0,     0,     2,   243,     0,     0,     3,   235,     0,     0,     4,   211,     0,     0,     4,   174, 
    0,     0,     5,   114,     0,     0,     6,    81,     0,     0,     7,    55,     0,     0,     8,    42,     0,     0,     7,    34,     0,     0,     8,    26,     0,     0,     8,    21, 
    0,     0,     8,    16,     0,     0,     9,     7,     0,     0,    10,     0,     0,     0,     0,   255,     0,     0,     0,   255,     0,     0,     0,   255,     0,     0,     0,   255, 
    0,     0,     0,   248,     0,     0,     0,   225,     0,     0,     0,   191,     0,     0,     0,   151,     0,     0,     0,   114,     0,     0,     0,    87,     0,     0,     0,    66, 
    0,     0,     0,    49,     0,     0,     0,    35,     0,     0,     0,    23,     0,     0,     0,    14,     0,     0,     0,     7,     0,     0,     0,     0
};

// Photo Best (Vail)
unsigned char ucMapDJ4100_KCMY_Photo_BestV_12x12x1[] =
{
  200,   110,    60,    64,   177,   141,    74,    53,   155,   171,    87,    41,   133,   199,    99,    31,   112,   227,   111,    21,   102,   232,   109,    21,    83,   244,   112,    19, 
   64,   247,   114,    21,    45,   247,   114,    24,    27,   247,   115,    25,    17,   247,   112,    21,    12,   248,   107,    15,     8,   248,   104,    11,     6,   248,   102,     8, 
    3,   248,   100,     5,     1,   248,    99,     2,     0,   248,    98,     0,   178,   136,    53,   100,   176,   144,    53,    56,   152,   175,    96,    39,   135,   197,   102,    31, 
  113,   226,   115,    21,   102,   231,   114,    21,    84,   242,   114,    19,    65,   247,   118,    20,    47,   247,   117,    23,    29,   247,   117,    24,    18,   247,   114,    22, 
   13,   247,   110,    16,     9,   248,   106,    11,     5,   248,   103,     7,     2,   247,   101,     3,     1,   245,   100,     1,     0,   243,   100,     0,   155,   162,    47,   135, 
  153,   168,    46,   119,   152,   177,    46,    58,   127,   210,    74,    33,   102,   233,   103,    22,    83,   240,   118,    19,    69,   246,   120,    19,    54,   246,   120,    21, 
   37,   247,   120,    23,    22,   247,   119,    23,    15,   247,   113,    17,    10,   247,   109,    12,     6,   247,   105,     8,     3,   246,   103,     3,     1,   244,   102,     1, 
    0,   240,   102,     0,     0,   237,   101,     0,   118,   186,    40,   197,   118,   202,    37,   181,   122,   205,    37,   120,   103,   238,    33,    51,    90,   243,    67,    29, 
   73,   238,    97,    30,    56,   241,   112,    28,    37,   243,   118,    26,    21,   245,   120,    23,    13,   246,   114,    15,     7,   246,   109,     9,     4,   245,   106,     5, 
    2,   242,   105,     3,     1,   239,   105,     1,     0,   236,   104,     0,     0,   233,   103,     0,     0,   229,   101,     0,    92,   197,    38,   230,    93,   211,    35,   216, 
   96,   211,    37,   168,    92,   224,    37,   110,    82,   231,    43,    58,    68,   231,    68,    46,    49,   233,    93,    44,    31,   235,   105,    38,    17,   237,   109,    31, 
   11,   237,   105,    19,     4,   236,   106,    14,     1,   235,   106,    10,     0,   232,   105,     7,     0,   230,   104,     3,     0,   226,   102,     1,     0,   222,   100,     0, 
    0,   218,    99,     0,    72,   203,    39,   229,    70,   213,    37,   223,    71,   211,    42,   191,    70,   211,    45,   152,    64,   216,    49,   108,    55,   219,    61,    73, 
   39,   225,    78,    62,    24,   225,    92,    54,    14,   227,    97,    41,     9,   226,    97,    28,     4,   224,    99,    22,     3,   222,    99,    16,     0,   220,   100,    13, 
    0,   218,    99,     9,     0,   214,    98,     5,     0,   211,    96,     3,     0,   208,    94,     0,    49,   204,    42,   229,    47,   210,    41,   226,    44,   212,    47,   207, 
   44,   208,    52,   177,    43,   207,    55,   144,    38,   211,    60,   109,    24,   215,    76,    84,    13,   218,    84,    70,     9,   219,    86,    54,     6,   218,    86,    36, 
    2,   215,    89,    27,     0,   212,    92,    24,     0,   209,    93,    19,     0,   207,    93,    14,     0,   204,    91,     9,     0,   202,    89,     4,     0,   200,    87,     0, 
   24,   202,    46,   230,    22,   207,    45,   227,    19,   207,    50,   214,    17,   204,    57,   190,    19,   199,    61,   161,    18,   200,    65,   135,    12,   205,    69,   105, 
    1,   211,    82,    87,     0,   211,    79,    69,     0,   211,    77,    50,     0,   211,    77,    34,     0,   209,    79,    23,     0,   204,    83,    19,     0,   199,    84,    15, 
    0,   195,    84,    10,     0,   193,    82,     5,     0,   190,    80,     0,     4,   201,    43,   231,     3,   205,    41,   229,     2,   206,    43,   217,     0,   201,    51,   195, 
    0,   197,    59,   175,     0,   195,    63,   155,     0,   198,    64,   128,     0,   203,    63,    96,     0,   208,    60,    64,     0,   207,    60,    49,     0,   207,    61,    36, 
    0,   207,    63,    25,     0,   204,    68,    18,     0,   198,    73,    14,     0,   191,    75,    10,     0,   186,    74,     5,     0,   181,    73,     0,     1,   202,    27,   234, 
    0,   205,    23,   232,     0,   203,    25,   219,     0,   198,    32,   197,     0,   195,    38,   177,     0,   194,    43,   157,     0,   195,    45,   135,     0,   198,    44,   108, 
    0,   201,    44,    79,     0,   207,    38,    44,     0,   206,    43,    35,     0,   205,    49,    29,     0,   203,    53,    20,     0,   199,    57,    13,     0,   192,    62,     9, 
    0,   184,    64,     4,     0,   177,    65,     0,     0,   201,    18,   234,     0,   203,    15,   233,     0,   203,    14,   224,     0,   198,    19,   203,     0,   194,    24,   183, 
    0,   192,    29,   162,     0,   192,    32,   143,     0,   193,    32,   120,     0,   195,    32,    95,     0,   200,    29,    65,     0,   206,    24,    31,     0,   204,    32,    26, 
    0,   202,    38,    21,     0,   199,    42,    14,     0,   194,    46,     9,     0,   187,    51,     4,     0,   179,    54,     0,     0,   199,    14,   235,     0,   201,    12,   234, 
    0,   203,    10,   228,     0,   200,    12,   211,     0,   195,    16,   192,     0,   192,    20,   173,     0,   191,    23,   153,     0,   191,    24,   133,     0,   193,    23,   110, 
    0,   196,    22,    84,     0,   200,    19,    54,     0,   204,    17,    22,     0,   202,    24,    19,     0,   198,    29,    14,     0,   195,    32,     9,     0,   189,    36,     4, 
    0,   182,    41,     0,     0,   198,    11,   235,     0,   199,     9,   234,     0,   200,     7,   230,     0,   199,     8,   216,     0,   196,    11,   199,     0,   193,    13,   182, 
    0,   191,    16,   163,     0,   191,    19,   145,     0,   192,    18,   124,     0,   194,    16,   101,     0,   197,    14,    74,     0,   200,    13,    46,     0,   204,    12,    17, 
    0,   199,    18,    13,     0,   194,    21,     9,     0,   189,    24,     4,     0,   184,    27,     0,     0,   196,     8,   234,     0,   197,     6,   234,     0,   198,     5,   230, 
    0,   197,     6,   219,     0,   195,     7,   204,     0,   192,     9,   188,     0,   191,    11,   172,     0,   190,    13,   155,     0,   191,    14,   136,     0,   193,    13,   115, 
    0,   195,    11,    92,     0,   197,    10,    67,     0,   200,     9,    40,     0,   203,     8,    12,     0,   196,    12,     8,     0,   189,    14,     4,     0,   184,    16,     0, 
    0,   194,     5,   234,     0,   195,     4,   234,     0,   195,     3,   230,     0,   195,     4,   221,     0,   194,     5,   209,     0,   191,     6,   194,     0,   190,     7,   179, 
    0,   190,     9,   163,     0,   190,    10,   145,     0,   191,    10,   126,     0,   193,     8,   105,     0,   195,     7,    83,     0,   197,     6,    60,     0,   199,     5,    35, 
    0,   202,     5,     8,     0,   193,     8,     4,     0,   185,     9,     0,     0,   193,     3,   234,     0,   193,     2,   233,     0,   193,     1,   230,     0,   192,     2,   223, 
    0,   192,     2,   212,     0,   191,     3,   199,     0,   189,     3,   185,     0,   189,     4,   170,     0,   189,     5,   153,     0,   190,     5,   136,     0,   191,     5,   116, 
    0,   193,     4,    96,     0,   194,     3,    75,     0,   196,     3,    53,     0,   198,     2,    29,     0,   201,     2,     4,     0,   191,     4,     0,     0,   191,     0,   234, 
    0,   191,     0,   232,     0,   191,     0,   229,     0,   190,     0,   223,     0,   190,     0,   215,     0,   189,     0,   203,     0,   188,     0,   190,     0,   188,     0,   176, 
    0,   189,     0,   160,     0,   190,     0,   144,     0,   190,     0,   126,     0,   191,     0,   107,     0,   192,     0,    88,     0,   193,     0,    68,     0,   194,     0,    47, 
    0,   196,     0,    25,     0,   200,     0,     0,   182,    96,    89,    88,   165,   101,   121,    50,   143,   140,   144,    36,    95,   201,   190,    13,    48,   225,   196,     9, 
   35,   233,   189,    10,    52,   223,   164,    26,    39,   221,   151,    32,    22,   228,   146,    25,    13,   231,   137,    16,     6,   234,   131,    12,     3,   238,   126,     9, 
    3,   240,   118,     4,     2,   241,   113,     2,     1,   242,   109,     1,     0,   243,   106,     0,     0,   244,   103,     0,   172,   110,    60,   114,   177,   112,    61,    66, 
  144,   173,    91,    41,   110,   220,   123,    22,    90,   227,   137,    20,    72,   238,   136,    19,    61,   241,   126,    22,    45,   242,   124,    24,    28,   243,   124,    24, 
   17,   244,   119,    19,     8,   245,   112,    11,     4,   245,   107,     4,     1,   242,   106,     1,     1,   239,   105,     1,     0,   237,   105,     0,     0,   235,   105,     0, 
    0,   238,   100,     0,   143,   149,    50,   160,   152,   162,    47,   142,   147,   177,    45,    85,   120,   207,    79,    35,    96,   224,   105,    27,    73,   238,   115,    25, 
   57,   243,   119,    23,    42,   245,   119,    24,    27,   246,   119,    24,    16,   246,   114,    19,     8,   246,   108,    10,     3,   246,   104,     3,     1,   243,   104,     1, 
    0,   238,   104,     0,     0,   234,   105,     0,     0,   231,   105,     0,     0,   233,   102,     0,   114,   173,    43,   208,   114,   193,    39,   202,   112,   209,    36,   167, 
  117,   201,    41,    79,    96,   220,    60,    38,    72,   227,    98,    38,    51,   231,   115,    35,    34,   235,   120,    32,    21,   238,   120,    26,    12,   240,   113,    17, 
    4,   241,   109,    10,     1,   241,   105,     2,     0,   237,   105,     0,     0,   232,   105,     0,     0,   228,   105,     0,     0,   225,   104,     0,     0,   225,   102,     0, 
   92,   181,    42,   233,    91,   198,    38,   228,    88,   216,    35,   209,    96,   197,    43,   133,    89,   202,    48,    81,    72,   218,    65,    53,    48,   222,    95,    52, 
   30,   225,   107,    45,    17,   229,   110,    35,    10,   230,   106,    21,     1,   232,   106,    13,     0,   232,   104,     3,     0,   228,   103,     1,     0,   223,   103,     0, 
    0,   219,   102,     0,     0,   217,   101,     0,     0,   216,    99,     0,    70,   195,    42,   231,    68,   202,    40,   229,    64,   216,    38,   221,    66,   208,    46,   175, 
   62,   206,    52,   132,    58,   211,    58,    91,    42,   214,    78,    72,    24,   214,    95,    63,    15,   217,    99,    49,     9,   221,    97,    32,     3,   223,    96,    21, 
    0,   223,    96,    10,     0,   221,    95,     3,     0,   216,    95,     1,     0,   212,    95,     0,     0,   209,    95,     0,     0,   207,    94,     0,    46,   197,    44,   231, 
   45,   203,    43,   229,    42,   211,    42,   224,    39,   208,    51,   197,    39,   204,    56,   161,    38,   203,    61,   127,    29,   205,    72,    98,    14,   207,    86,    83, 
    8,   209,    90,    65,     5,   210,    89,    46,     3,   211,    88,    30,     0,   211,    88,    20,     0,   211,    87,    10,     0,   209,    86,     4,     0,   206,    87,     1, 
    0,   202,    87,     0,     0,   199,    88,     0,    22,   197,    48,   231,    20,   201,    47,   230,    18,   206,    47,   226,    14,   205,    54,   205,    12,   198,    62,   178, 
   14,   196,    66,   149,     8,   198,    74,   125,     5,   201,    78,   100,     2,   204,    80,    80,     0,   205,    79,    60,     0,   206,    76,    39,     0,   204,    78,    25, 
    0,   202,    79,    15,     0,   200,    79,     8,     0,   198,    79,     3,     0,   194,    79,     1,     0,   190,    81,     0,     4,   198,    42,   232,     4,   201,    41,   232, 
    3,   203,    39,   227,     0,   203,    45,   208,     0,   196,    54,   185,     0,   193,    60,   163,     0,   194,    64,   140,     0,   196,    65,   111,     0,   198,    64,    85, 
    0,   200,    62,    65,     0,   201,    61,    45,     0,   202,    62,    29,     0,   199,    65,    17,     0,   195,    68,    10,     0,   191,    70,     5,     0,   186,    71,     1, 
    0,   180,    73,     0,     0,   199,    25,   235,     0,   200,    25,   233,     0,   200,    25,   224,     0,   196,    30,   205,     0,   193,    37,   185,     0,   191,    42,   165, 
    0,   191,    46,   144,     0,   192,    47,   119,     0,   193,    49,    94,     0,   196,    47,    70,     0,   198,    46,    51,     0,   199,    48,    36,     0,   199,    49,    23, 
    0,   195,    53,    12,     0,   189,    58,     6,     0,   182,    61,     2,     0,   175,    64,     0,     0,   198,    17,   235,     0,   195,    13,   228,     0,   195,    14,   220, 
    0,   192,    18,   206,     0,   188,    23,   188,     0,   187,    27,   168,     0,   186,    31,   148,     0,   187,    33,   128,     0,   188,    34,   104,     0,   190,    34,    80, 
    0,   194,    31,    56,     0,   196,    32,    39,     0,   196,    35,    28,     0,   195,    37,    17,     0,   191,    41,     8,     0,   184,    47,     3,     0,   174,    53,     0, 
    0,   197,    13,   235,     0,   191,     7,   225,     0,   190,     7,   217,     0,   189,     9,   206,     0,   185,    12,   191,     0,   184,    15,   174,     0,   183,    19,   154, 
    0,   183,    21,   135,     0,   183,    23,   114,     0,   186,    22,    91,     0,   188,    21,    68,     0,   192,    20,    44,     0,   193,    23,    31,     0,   192,    25,    21, 
    0,   190,    28,    12,     0,   186,    32,     5,     0,   178,    39,     0,     0,   195,    10,   235,     0,   187,     3,   223,     0,   186,     2,   216,     0,   185,     3,   206, 
    0,   183,     6,   194,     0,   183,     7,   179,     0,   182,    10,   161,     0,   181,    13,   143,     0,   181,    14,   124,     0,   183,    14,   102,     0,   185,    13,    80, 
    0,   188,    12,    56,     0,   191,    12,    34,     0,   189,    15,    23,     0,   187,    17,    15,     0,   184,    20,     7,     0,   180,    26,     0,     0,   194,     7,   235, 
    0,   184,     1,   220,     0,   182,     1,   213,     0,   181,     1,   206,     0,   181,     2,   195,     0,   181,     3,   183,     0,   180,     4,   167,     0,   179,     6,   150, 
    0,   180,     8,   133,     0,   180,     8,   113,     0,   183,     7,    91,     0,   184,     6,    69,     0,   187,     6,    46,     0,   188,     6,    25,     0,   185,     9,    15, 
    0,   182,    10,     8,     0,   178,    14,     0,     0,   192,     5,   235,     0,   181,     1,   218,     0,   178,     0,   212,     0,   178,     0,   205,     0,   178,     0,   196, 
    0,   178,     1,   185,     0,   178,     1,   171,     0,   178,     2,   156,     0,   178,     4,   140,     0,   179,     4,   122,     0,   181,     4,   102,     0,   183,     3,    82, 
    0,   184,     2,    60,     0,   186,     2,    38,     0,   187,     3,    18,     0,   182,     5,     8,     0,   178,     7,     0,     0,   191,     2,   234,     0,   179,     0,   218, 
    0,   177,     0,   212,     0,   177,     0,   206,     0,   176,     0,   198,     0,   177,     0,   188,     0,   177,     0,   175,     0,   177,     0,   161,     0,   178,     1,   146, 
    0,   178,     1,   130,     0,   180,     1,   111,     0,   181,     1,    93,     0,   182,     0,    73,     0,   183,     0,    52,     0,   185,     0,    31,     0,   186,     1,    11, 
    0,   181,     5,     0,     0,   189,     0,   234,     0,   180,     0,   217,     0,   180,     0,   214,     0,   180,     0,   208,     0,   179,     0,   201,     0,   180,     0,   191, 
    0,   180,     0,   179,     0,   180,     0,   166,     0,   180,     0,   152,     0,   181,     0,   136,     0,   182,     0,   119,     0,   183,     0,   101,     0,   183,     0,    84, 
    0,   184,     0,    65,     0,   185,     0,    43,     0,   187,     0,    22,     0,   189,     0,     0,   165,    82,   118,   113,   155,    74,   140,    88,   136,    86,   173,    40, 
  111,   121,   191,    29,    83,   172,   190,    25,    61,   196,   183,    30,    48,   195,   172,    43,    25,   203,   164,    47,    13,   208,   156,    34,     4,   215,   150,    25, 
    4,   219,   141,    14,     0,   224,   137,    12,     0,   229,   131,     7,     1,   232,   123,     3,     1,   235,   117,     1,     0,   236,   113,     0,     0,   238,   109,     0, 
  161,    86,    94,   131,   155,    90,   103,   109,   138,   107,   133,    48,   106,   160,   164,    30,    81,   195,   163,    31,    55,   209,   161,    40,    36,   213,   155,    39, 
   23,   217,   150,    33,    13,   222,   143,    22,     4,   226,   137,    13,     0,   228,   131,     5,     0,   228,   125,     1,     0,   227,   120,     0,     0,   226,   116,     0, 
    0,   225,   113,     0,     0,   226,   110,     0,     0,   232,   107,     0,   146,   108,    60,   163,   146,   112,    60,   147,   144,   114,    62,    68,   114,   169,   101,    45, 
   89,   193,   114,    41,    64,   211,   124,    43,    44,   224,   128,    37,    29,   231,   127,    31,    18,   235,   122,    25,    10,   237,   115,    14,     2,   238,   112,     7, 
    1,   237,   108,     1,     0,   232,   107,     0,     0,   227,   106,     0,     0,   224,   106,     0,     0,   221,   105,     0,     0,   225,   102,     0,   114,   141,    52,   212, 
  114,   154,    49,   203,   115,   162,    49,   159,   116,   160,    54,    84,    98,   178,    77,    52,    67,   202,   108,    52,    45,   213,   121,    49,    30,   222,   122,    41, 
   18,   227,   120,    32,    11,   230,   114,    21,     3,   232,   110,    14,     1,   233,   106,     3,     0,   228,   105,     0,     0,   223,   105,     0,     0,   219,   104,     0, 
    0,   216,   104,     0,     0,   218,   102,     0,    90,   156,    49,   238,    90,   171,    45,   233,    88,   184,    45,   208,    93,   173,    51,   135,    92,   170,    59,    85, 
   72,   186,    82,    66,    44,   204,   106,    63,    26,   210,   115,    55,    15,   214,   117,    42,     9,   215,   113,    28,     1,   218,   111,    19,     0,   220,   107,     6, 
    0,   218,   104,     0,     0,   213,   104,     0,     0,   211,   103,     0,     0,   209,   102,     0,     0,   211,   100,     0,    68,   179,    47,   234,    66,   187,    45,   232, 
   62,   198,    45,   222,    62,   193,    55,   176,    63,   185,    64,   131,    61,   184,    70,    96,    39,   198,    89,    81,    22,   204,   101,    69,    13,   206,   104,    53, 
    7,   210,   102,    38,     0,   212,   102,    25,     0,   213,    99,    10,     0,   211,    97,     1,     0,   208,    97,     0,     0,   205,    97,     0,     0,   203,    96,     0, 
    0,   204,    95,     0,    44,   187,    48,   233,    42,   193,    46,   231,    40,   200,    46,   227,    35,   200,    57,   198,    35,   194,    64,   163,    35,   192,    69,   131, 
   28,   195,    77,   103,    14,   200,    90,    86,     8,   202,    92,    67,     4,   203,    93,    50,     2,   204,    91,    33,     0,   206,    89,    18,     0,   206,    86,     6, 
    0,   204,    86,     1,     0,   200,    87,     0,     0,   198,    88,     0,     0,   196,    88,     0,    20,   191,    51,   232,    18,   195,    50,   231,    16,   200,    48,   228, 
   13,   198,    55,   206,     9,   193,    66,   179,     8,   191,    72,   154,     3,   192,    81,   135,     0,   195,    85,   110,     0,   198,    83,    85,     0,   199,    80,    63, 
    0,   200,    79,    41,     0,   199,    79,    25,     0,   198,    78,    13,     0,   197,    77,     4,     0,   194,    78,     1,     0,   191,    79,     0,     0,   188,    81,     0, 
    5,   193,    43,   234,     4,   196,    41,   233,     3,   200,    40,   226,     0,   199,    46,   208,     0,   192,    54,   185,     0,   190,    61,   164,     0,   189,    65,   143, 
    0,   191,    67,   115,     0,   193,    65,    89,     0,   195,    65,    69,     0,   195,    64,    49,     0,   196,    64,    31,     0,   194,    66,    17,     0,   190,    68,     8, 
    0,   187,    69,     2,     0,   183,    71,     0,     0,   179,    74,     0,     0,   194,    26,   236,     0,   195,    26,   231,     0,   194,    28,   219,     0,   193,    33,   205, 
    0,   189,    39,   187,     0,   188,    44,   167,     0,   188,    47,   145,     0,   188,    49,   122,     0,   188,    52,    98,     0,   190,    51,    76,     0,   191,    49,    56, 
    0,   193,    49,    39,     0,   192,    50,    23,     0,   189,    53,    11,     0,   184,    57,     4,     0,   179,    60,     1,     0,   172,    64,     0,     0,   193,    16,   236, 
    0,   191,    14,   227,     0,   188,    18,   215,     0,   185,    22,   202,     0,   183,    25,   187,     0,   183,    29,   169,     0,   182,    33,   150,     0,   183,    35,   129, 
    0,   183,    37,   107,     0,   185,    37,    84,     0,   187,    35,    63,     0,   189,    35,    45,     0,   190,    35,    31,     0,   189,    37,    18,     0,   186,    41,     8, 
    0,   180,    46,     2,     0,   170,    52,     0,     0,   193,    12,   235,     0,   186,     7,   224,     0,   183,     8,   211,     0,   181,    10,   201,     0,   179,    13,   189, 
    0,   179,    16,   173,     0,   178,    19,   154,     0,   177,    22,   135,     0,   178,    24,   115,     0,   179,    25,    94,     0,   182,    24,    72,     0,   185,    23,    51, 
    0,   186,    23,    36,     0,   186,    25,    23,     0,   185,    27,    13,     0,   181,    31,     5,     0,   172,    39,     0,     0,   192,     9,   235,     0,   183,     2,   221, 
    0,   178,     2,   208,     0,   176,     3,   199,     0,   176,     4,   189,     0,   176,     6,   176,     0,   175,     8,   159,     0,   175,    11,   141,     0,   175,    13,   123, 
    0,   176,    14,   102,     0,   178,    14,    81,     0,   180,    13,    60,     0,   183,    12,    39,     0,   182,    15,    27,     0,   180,    16,    16,     0,   178,    18,     7, 
    0,   174,    25,     0,     0,   191,     7,   235,     0,   179,     1,   217,     0,   173,     0,   203,     0,   172,     0,   196,     0,   172,     0,   188,     0,   173,     1,   177, 
    0,   173,     2,   163,     0,   172,     4,   147,     0,   173,     5,   130,     0,   173,     6,   111,     0,   175,     6,    91,     0,   176,     6,    70,     0,   178,     6,    49, 
    0,   180,     5,    29,     0,   177,     8,    18,     0,   175,     9,     9,     0,   173,    14,     0,     0,   190,     4,   235,     0,   176,     0,   215,     0,   168,     0,   199, 
    0,   167,     0,   193,     0,   168,     0,   186,     0,   169,     0,   176,     0,   169,     0,   164,     0,   169,     0,   151,     0,   170,     1,   135,     0,   171,     2,   118, 
    0,   172,     2,    99,     0,   173,     1,    80,     0,   174,     1,    60,     0,   176,     1,    39,     0,   176,     1,    20,     0,   173,     3,    10,     0,   171,     7,     0, 
    0,   188,     2,   235,     0,   174,     0,   214,     0,   166,     0,   197,     0,   164,     0,   191,     0,   165,     0,   184,     0,   166,     0,   176,     0,   166,     0,   165, 
    0,   166,     0,   152,     0,   167,     0,   138,     0,   168,     0,   123,     0,   169,     0,   106,     0,   170,     0,    89,     0,   170,     0,    71,     0,   171,     0,    51, 
    0,   172,     0,    31,     0,   172,     1,    13,     0,   171,     5,     0,     0,   187,     0,   235,     0,   178,     0,   217,     0,   169,     0,   199,     0,   169,     0,   195, 
    0,   169,     0,   188,     0,   170,     0,   180,     0,   170,     0,   169,     0,   170,     0,   158,     0,   171,     0,   144,     0,   171,     0,   129,     0,   173,     0,   113, 
    0,   174,     0,    96,     0,   174,     0,    80,     0,   175,     0,    61,     0,   175,     0,    40,     0,   176,     0,    19,     0,   178,     0,     0,   136,    61,   156,   163, 
  130,    56,   173,   146,   122,    53,   193,    74,    96,    60,   228,    34,    83,   112,   204,    36,    64,   150,   184,    43,    43,   167,   179,    48,    23,   180,   171,    48, 
    8,   190,   166,    39,     1,   198,   160,    30,     0,   202,   152,    19,     0,   207,   145,    14,     0,   212,   138,    10,     0,   217,   132,     6,     0,   222,   127,     3, 
    0,   226,   121,     1,     0,   228,   117,     0,   136,    69,   127,   170,   134,    73,   133,   149,   128,    73,   149,    89,   102,    84,   190,    41,    78,   140,   179,    41, 
   51,   172,   171,    52,    28,   185,   167,    53,    12,   196,   164,    44,     3,   202,   157,    32,     0,   205,   150,    15,     0,   208,   141,     3,     0,   209,   134,     1, 
    0,   211,   128,     1,     0,   212,   124,     1,     0,   214,   120,     0,     0,   217,   117,     0,     0,   221,   113,     0,   132,    80,    87,   181,   131,    83,    92,   160, 
  124,    93,    99,   113,   108,   104,   131,    55,    80,   144,   146,    56,    48,   181,   153,    66,    22,   194,   155,    60,    12,   200,   151,    44,     5,   204,   144,    33, 
    0,   208,   139,    19,     0,   210,   131,     4,     0,   211,   125,     0,     0,   210,   121,     0,     0,   209,   117,     0,     0,   209,   114,     0,     0,   209,   112,     0, 
    0,   215,   109,     0,   103,    98,    63,   240,   111,    99,    65,   203,   115,   108,    66,   145,   114,   116,    68,    72,    86,   153,   101,    67,    57,   182,   121,    71, 
   33,   195,   128,    64,    20,   204,   130,    51,    13,   210,   125,    37,     5,   215,   120,    26,     0,   219,   114,    13,     0,   220,   109,     2,     0,   216,   107,     0, 
    0,   212,   106,     0,     0,   209,   105,     0,     0,   207,   104,     0,     0,   211,   101,     0,    87,   129,    57,   243,    87,   134,    57,   227,    89,   140,    59,   186, 
   89,   147,    63,   138,    87,   145,    71,    91,    64,   168,    97,    81,    35,   188,   116,    76,    19,   197,   123,    63,    13,   203,   119,    46,     5,   207,   116,    35, 
    0,   210,   112,    23,     0,   211,   106,     8,     0,   210,   104,     1,     0,   207,   102,     0,     0,   204,   102,     0,     0,   202,   101,     0,     0,   204,   100,     0, 
   66,   162,    52,   237,    64,   168,    51,   234,    62,   172,    54,   215,    61,   174,    64,   177,    60,   166,    76,   135,    57,   162,    84,   105,    36,   180,   101,    92, 
   19,   193,   109,    74,    12,   197,   109,    56,     5,   199,   108,    41,     1,   202,   105,    27,     0,   203,   102,    11,     0,   202,   100,     1,     0,   199,    99,     0, 
    0,   197,    98,     0,     0,   196,    98,     0,     0,   197,    97,     0,    42,   174,    53,   235,    40,   180,    52,   234,    38,   184,    52,   224,    34,   184,    63,   195, 
   29,   182,    75,   165,    31,   175,    83,   135,    25,   177,    89,   112,    12,   189,    95,    90,     7,   193,    97,    70,     4,   194,    96,    51,     0,   197,    94,    34, 
    0,   198,    91,    17,     0,   198,    89,     4,     0,   195,    89,     0,     0,   192,    90,     0,     0,   190,    90,     0,     0,   191,    90,     0,    18,   181,    55,   234, 
   16,   185,    54,   233,    15,   189,    53,   226,    13,   187,    59,   203,     5,   185,    73,   179,     6,   183,    77,   156,     9,   183,    78,   130,     3,   186,    85,   108, 
    0,   190,    86,    86,     0,   191,    84,    64,     0,   191,    82,    43,     0,   191,    80,    25,     0,   192,    79,    10,     0,   191,    78,     2,     0,   188,    80,     0, 
    0,   185,    81,     0,     0,   183,    82,     0,     5,   185,    45,   236,     5,   189,    42,   234,     3,   192,    44,   224,     0,   191,    50,   205,     0,   184,    58,   185, 
    0,   183,    64,   165,     0,   183,    67,   143,     0,   184,    69,   117,     0,   186,    69,    91,     0,   188,    68,    71,     0,   189,    66,    50,     0,   188,    67,    32, 
    0,   186,    67,    17,     0,   184,    68,     6,     0,   181,    70,     1,     0,   178,    72,     0,     0,   176,    74,     0,     0,   186,    27,   237,     0,   187,    28,   231, 
    0,   188,    33,   218,     0,   185,    37,   203,     0,   182,    42,   187,     0,   182,    47,   167,     0,   182,    50,   146,     0,   182,    52,   123,     0,   181,    55,    99, 
    0,   183,    54,    78,     0,   184,    53,    59,     0,   185,    53,    41,     0,   184,    53,    24,     0,   181,    55,    11,     0,   178,    58,     3,     0,   173,    60,     0, 
    0,   168,    64,     0,     0,   186,    16,   236,     0,   184,    16,   228,     0,   181,    21,   213,     0,   178,    26,   199,     0,   177,    29,   186,     0,   178,    32,   169, 
    0,   177,    35,   150,     0,   178,    37,   130,     0,   177,    40,   109,     0,   179,    41,    87,     0,   181,    39,    67,     0,   182,    38,    49,     0,   183,    38,    33, 
    0,   181,    40,    18,     0,   178,    42,     7,     0,   173,    46,     1,     0,   165,    52,     0,     0,   187,    12,   236,     0,   181,     8,   224,     0,   178,     9,   210, 
    0,   173,    13,   197,     0,   173,    15,   186,     0,   173,    18,   171,     0,   172,    21,   154,     0,   171,    24,   136,     0,   172,    26,   116,     0,   173,    27,    96, 
    0,   175,    27,    75,     0,   178,    26,    56,     0,   179,    25,    39,     0,   179,    25,    25,     0,   178,    27,    13,     0,   174,    30,     4,     0,   165,    39,     0, 
    0,   187,     9,   236,     0,   178,     3,   221,     0,   173,     3,   207,     0,   169,     4,   195,     0,   169,     5,   186,     0,   169,     6,   173,     0,   168,     9,   158, 
    0,   168,    11,   141,     0,   169,    13,   122,     0,   170,    14,   103,     0,   171,    15,    83,     0,   172,    14,    63,     0,   175,    13,    43,     0,   175,    14,    29, 
    0,   174,    15,    17,     0,   172,    17,     7,     0,   167,    25,     0,     0,   186,     6,   235,     0,   175,     1,   217,     0,   168,     0,   202,     0,   164,     0,   190, 
    0,   164,     0,   182,     0,   165,     1,   172,     0,   165,     1,   160,     0,   165,     3,   145,     0,   165,     4,   128,     0,   166,     5,   109,     0,   167,     5,    91, 
    0,   168,     5,    71,     0,   169,     5,    51,     0,   171,     4,    32,     0,   168,     6,    19,     0,   168,     7,     9,     0,   165,    14,     0,     0,   186,     3,   235, 
    0,   172,     0,   215,     0,   164,     0,   197,     0,   158,     0,   183,     0,   158,     0,   175,     0,   158,     0,   166,     0,   159,     0,   156,     0,   159,     0,   144, 
    0,   160,     0,   129,     0,   161,     0,   113,     0,   162,     1,    96,     0,   163,     0,    79,     0,   163,     0,    60,     0,   164,     0,    40,     0,   164,     1,    23, 
    0,   163,     2,    11,     0,   162,     7,     0,     0,   185,     1,   235,     0,   171,     0,   214,     0,   161,     0,   195,     0,   154,     0,   178,     0,   154,     0,   170, 
    0,   154,     0,   163,     0,   154,     0,   154,     0,   155,     0,   143,     0,   155,     0,   130,     0,   156,     0,   115,     0,   157,     0,   100,     0,   157,     0,    85, 
    0,   157,     0,    69,     0,   158,     0,    50,     0,   158,     0,    32,     0,   159,     1,    15,     0,   160,     5,     0,     0,   184,     0,   233,     0,   175,     0,   217, 
    0,   166,     0,   199,     0,   158,     0,   182,     0,   159,     0,   176,     0,   159,     0,   169,     0,   160,     0,   159,     0,   160,     0,   149,     0,   160,     0,   136, 
    0,   161,     0,   122,     0,   161,     0,   106,     0,   162,     0,    91,     0,   162,     0,    76,     0,   162,     0,    58,     0,   163,     0,    37,     0,   163,     0,    17, 
    0,   166,     0,     0,    99,    35,   205,   222,    97,    35,   211,   213,   102,    45,   202,   142,    90,    49,   216,    71,    76,    74,   213,    48,    58,   115,   197,    51, 
   39,   141,   188,    53,    22,   158,   178,    50,    10,   168,   173,    38,     2,   178,   167,    29,     0,   184,   159,    20,     0,   190,   152,    14,     0,   195,   146,    10, 
    0,   201,   141,     7,     0,   205,   135,     4,     0,   210,   131,     2,     0,   214,   126,     0,   104,    46,   172,   219,   103,    49,   174,   202,   103,    58,   173,   156, 
   94,    62,   188,    67,    75,   103,   185,    52,    50,   139,   179,    58,    29,   157,   174,    57,    14,   170,   171,    45,     1,   182,   166,    34,     0,   186,   157,    14, 
    0,   190,   149,     3,     0,   194,   141,     1,     0,   197,   136,     1,     0,   200,   131,     1,     0,   202,   126,     0,     0,   205,   123,     0,     0,   209,   121,     0, 
  108,    62,   128,   206,   108,    69,   125,   187,   108,    78,   124,   151,    98,    83,   142,    89,    77,   107,   156,    64,    49,   144,   163,    69,    24,   163,   164,    63, 
   11,   175,   162,    50,     0,   185,   156,    38,     0,   188,   149,    17,     0,   191,   142,     2,     0,   194,   135,     0,     0,   195,   130,     0,     0,   197,   125,     0, 
    0,   198,   121,     0,     0,   200,   118,     0,     0,   204,   117,     0,    96,    71,    86,   236,    99,    78,    88,   204,   101,    91,    91,   153,    93,   102,   104,   117, 
   80,   114,   120,    78,    47,   149,   144,    84,    18,   172,   149,    76,     6,   182,   148,    59,     2,   187,   143,    40,     0,   190,   137,    23,     0,   193,   131,     6, 
    0,   195,   125,     1,     0,   195,   120,     0,     0,   195,   116,     0,     0,   195,   113,     0,     0,   195,   111,     0,     0,   199,   109,     0,    80,    97,    69,   250, 
   82,   107,    69,   211,    84,   111,    73,   161,    82,   118,    78,   133,    76,   128,    87,    96,    45,   154,   118,   102,    21,   174,   126,    88,    13,   185,   126,    68, 
    7,   192,   123,    50,     0,   197,   119,    37,     0,   199,   113,    19,     0,   201,   108,     6,     0,   200,   105,     0,     0,   197,   103,     0,     0,   195,   102,     0, 
    0,   193,   101,     0,     0,   196,    98,     0,    63,   135,    62,   243,    62,   141,    61,   236,    62,   141,    68,   196,    58,   142,    77,   167,    50,   148,    89,   143, 
   42,   151,    99,   119,    24,   166,   111,   102,    13,   180,   116,    79,     9,   186,   114,    59,     3,   190,   111,    43,     0,   193,   107,    28,     0,   194,   103,    12, 
    0,   194,   100,     1,     0,   192,    98,     0,     0,   189,    98,     0,     0,   187,    97,     0,     0,   190,    96,     0,    39,   156,    60,   239,    37,   162,    59,   237, 
   36,   163,    62,   219,    32,   163,    71,   189,    25,   165,    83,   166,    21,   162,    93,   142,    16,   160,   100,   121,     8,   172,   104,    98,     6,   182,   102,    72, 
    2,   185,   101,    53,     0,   185,    99,    35,     0,   187,    96,    18,     0,   187,    93,     4,     0,   185,    92,     0,     0,   183,    92,     0,     0,   181,    92,     0, 
    0,   183,    92,     0,    16,   167,    60,   238,    16,   172,    57,   235,    16,   172,    58,   222,    13,   171,    66,   199,     6,   173,    76,   177,     2,   172,    84,   156, 
    1,   168,    91,   135,     0,   169,    94,   114,     0,   177,    91,    87,     0,   179,    89,    65,     0,   181,    86,    43,     0,   181,    84,    25,     0,   182,    82,     9, 
    0,   182,    81,     1,     0,   178,    82,     0,     0,   176,    83,     0,     0,   176,    84,     0,     4,   174,    48,   239,     4,   178,    47,   235,     2,   181,    49,   219, 
    1,   176,    55,   201,     0,   174,    62,   182,     0,   174,    67,   162,     0,   174,    71,   142,     0,   173,    73,   118,     0,   176,    74,    93,     0,   179,    72,    72, 
    0,   180,    70,    51,     0,   178,    71,    33,     0,   177,    70,    16,     0,   177,    70,     4,     0,   174,    71,     0,     0,   171,    73,     0,     0,   170,    74,     0, 
    0,   175,    30,   239,     0,   177,    32,   231,     0,   178,    37,   216,     0,   174,    43,   201,     0,   173,    46,   185,     0,   173,    50,   166,     0,   173,    53,   147, 
    0,   173,    56,   125,     0,   174,    58,   100,     0,   176,    57,    79,     0,   177,    55,    60,     0,   176,    56,    41,     0,   175,    56,    24,     0,   173,    57,    10, 
    0,   170,    59,     1,     0,   166,    61,     0,     0,   164,    64,     0,     0,   176,    17,   237,     0,   175,    18,   226,     0,   172,    24,   212,     0,   169,    30,   198, 
    0,   170,    31,   185,     0,   170,    34,   169,     0,   170,    37,   151,     0,   170,    40,   131,     0,   170,    42,   110,     0,   171,    43,    88,     0,   173,    41,    69, 
    0,   173,    40,    50,     0,   173,    41,    33,     0,   172,    41,    18,     0,   169,    43,     5,     0,   164,    47,     0,     0,   158,    53,     0,     0,   178,    11,   237, 
    0,   173,     9,   223,     0,   170,    12,   209,     0,   166,    16,   196,     0,   166,    18,   184,     0,   165,    20,   170,     0,   164,    23,   154,     0,   165,    25,   136, 
    0,   165,    27,   117,     0,   166,    28,    97,     0,   168,    28,    77,     0,   170,    28,    58,     0,   170,    27,    40,     0,   171,    26,    25,     0,   169,    28,    12, 
    0,   165,    31,     2,     0,   156,    40,     0,     0,   179,     8,   236,     0,   171,     4,   220,     0,   167,     4,   206,     0,   163,     6,   194,     0,   162,     7,   182, 
    0,   161,     8,   170,     0,   161,    11,   156,     0,   161,    12,   140,     0,   161,    14,   122,     0,   163,    15,   103,     0,   163,    16,    84,     0,   164,    15,    66, 
    0,   166,    15,    46,     0,   166,    14,    31,     0,   165,    15,    17,     0,   163,    17,     6,     0,   157,    26,     0,     0,   180,     5,   236,     0,   169,     1,   217, 
    0,   163,     1,   203,     0,   159,     0,   190,     0,   156,     1,   176,     0,   156,     1,   166,     0,   157,     1,   155,     0,   157,     2,   142,     0,   157,     4,   125, 
    0,   158,     4,   107,     0,   159,     5,    90,     0,   159,     5,    72,     0,   160,     5,    52,     0,   162,     4,    34,     0,   159,     6,    21,     0,   159,     7,     9, 
    0,   156,    15,     0,     0,   180,     3,   235,     0,   167,     0,   214,     0,   160,     0,   198,     0,   153,     0,   181,     0,   148,     0,   166,     0,   148,     0,   158, 
    0,   149,     0,   148,     0,   149,     0,   137,     0,   150,     0,   124,     0,   150,     0,   109,     0,   151,     0,    93,     0,   152,     0,    78,     0,   152,     0,    60, 
    0,   153,     0,    41,     0,   153,     0,    24,     0,   153,     1,    12,     0,   153,     7,     0,     0,   180,     1,   234,     0,   167,     0,   213,     0,   157,     0,   194, 
    0,   149,     0,   176,     0,   143,     0,   160,     0,   142,     0,   152,     0,   143,     0,   144,     0,   143,     0,   134,     0,   144,     0,   122,     0,   144,     0,   109, 
    0,   144,     0,    95,     0,   145,     0,    82,     0,   145,     0,    67,     0,   145,     0,    49,     0,   145,     0,    32,     0,   146,     0,    16,     0,   149,     5,     0, 
    0,   179,     0,   233,     0,   171,     0,   217,     0,   163,     0,   200,     0,   155,     0,   182,     0,   147,     0,   164,     0,   147,     0,   157,     0,   148,     0,   149, 
    0,   148,     0,   139,     0,   148,     0,   127,     0,   148,     0,   114,     0,   149,     0,   101,     0,   149,     0,    88,     0,   149,     0,    73,     0,   149,     0,    55, 
    0,   149,     0,    35,     0,   150,     0,    15,     0,   153,     0,     0,    85,    37,   202,   225,    81,    37,   208,   221,    78,    43,   208,   189,    70,    50,   212,   123, 
   63,    62,   212,    79,    45,    85,   207,    68,    31,   113,   196,    64,    18,   133,   186,    56,    10,   145,   179,    39,     1,   158,   172,    29,     0,   166,   165,    21, 
    0,   173,   160,    15,     0,   179,   153,    11,     0,   185,   148,     7,     0,   190,   143,     5,     0,   194,   138,     2,     0,   199,   134,     0,    87,    45,   175,   229, 
   84,    45,   184,   219,    80,    56,   185,   189,    75,    63,   187,   123,    67,    76,   189,    73,    45,   107,   188,    70,    27,   131,   182,    64,    15,   146,   177,    50, 
    2,   161,   171,    36,     0,   166,   165,    15,     0,   170,   156,     3,     0,   175,   148,     1,     0,   180,   142,     1,     0,   185,   137,     1,     0,   189,   134,     0, 
    0,   193,   131,     0,     0,   196,   130,     0,    89,    59,   140,   216,    86,    61,   145,   209,    89,    78,   136,   155,    78,    83,   152,   128,    68,    90,   162,    86, 
   46,   116,   170,    78,    24,   140,   171,    70,    12,   152,   167,    55,     2,   164,   162,    39,     0,   168,   157,    17,     0,   171,   149,     2,     0,   176,   141,     0, 
    0,   180,   135,     0,     0,   183,   131,     0,     0,   186,   127,     0,     0,   188,   124,     0,     0,   192,   124,     0,    84,    69,   113,   224,    82,    71,   120,   211, 
   82,    87,   117,   161,    75,    99,   121,   137,    65,   103,   138,   108,    47,   119,   150,    95,    20,   146,   157,    79,    10,   156,   155,    61,     1,   166,   152,    45, 
    0,   168,   147,    22,     0,   172,   140,     5,     0,   175,   134,     0,     0,   178,   129,     0,     0,   180,   124,     0,     0,   182,   121,     0,     0,   183,   118,     0, 
    0,   187,   117,     0,    74,    82,    86,   232,    73,    87,    90,   209,    70,   100,    96,   167,    65,   110,   103,   144,    51,   122,   118,   132,    40,   128,   128,   111, 
   14,   149,   140,    93,     6,   160,   139,    72,     0,   167,   136,    51,     0,   171,   132,    28,     0,   174,   127,    12,     0,   176,   122,     2,     0,   178,   118,     0, 
    0,   178,   114,     0,     0,   178,   111,     0,     0,   178,   109,     0,     0,   183,   107,     0,    52,   104,    76,   250,    54,   107,    78,   233,    51,   116,    85,   193, 
   44,   125,    96,   159,    37,   134,   103,   144,    26,   143,   110,   124,     9,   153,   120,   110,     6,   165,   120,    83,     3,   174,   117,    63,     0,   179,   113,    44, 
    0,   181,   108,    24,     0,   183,   104,     9,     0,   184,   101,     1,     0,   182,    98,     0,     0,   179,    97,     0,     0,   177,    96,     0,     0,   181,    93,     0, 
   31,   133,    72,   244,    31,   137,    70,   240,    31,   140,    74,   218,    26,   141,    85,   182,    20,   146,    92,   162,    13,   149,   100,   144,     7,   149,   106,   125, 
    3,   156,   108,   101,     1,   166,   108,    77,     2,   172,   104,    54,     0,   174,   101,    35,     0,   176,    98,    18,     0,   178,    94,     4,     0,   176,    93,     0, 
    0,   174,    91,     0,     0,   172,    91,     0,     0,   174,    90,     0,    13,   150,    65,   242,    13,   154,    63,   238,    15,   153,    64,   222,    13,   152,    71,   195, 
    7,   156,    80,   175,     0,   159,    88,   156,     0,   154,    94,   134,     0,   151,    97,   115,     0,   159,    96,    91,     0,   168,    92,    65,     0,   169,    89,    43, 
    0,   170,    87,    25,     0,   172,    85,     9,     0,   171,    84,     1,     0,   168,    84,     0,     0,   166,    83,     0,     0,   167,    84,     0,     2,   159,    53,   242, 
    2,   163,    52,   234,     0,   164,    54,   217,     0,   161,    62,   200,     0,   162,    66,   181,     0,   162,    70,   161,     0,   162,    74,   140,     0,   155,    79,   118, 
    0,   157,    80,    97,     0,   165,    76,    72,     0,   167,    75,    52,     0,   167,    74,    32,     0,   168,    73,    16,     0,   168,    72,     3,     0,   165,    73,     0, 
    0,   162,    74,     0,     0,   162,    74,     0,     0,   160,    34,   238,     0,   163,    35,   228,     0,   163,    41,   217,     0,   160,    47,   200,     0,   161,    50,   184, 
    0,   163,    53,   167,     0,   165,    57,   147,     0,   164,    59,   125,     0,   162,    61,   102,     0,   165,    60,    80,     0,   167,    58,    60,     0,   166,    58,    41, 
    0,   165,    59,    23,     0,   164,    59,     8,     0,   161,    61,     1,     0,   158,    63,     0,     0,   157,    65,     0,     0,   162,    20,   235,     0,   163,    20,   224, 
    0,   159,    27,   212,     0,   158,    33,   198,     0,   160,    35,   184,     0,   160,    37,   169,     0,   160,    40,   151,     0,   161,    42,   132,     0,   161,    44,   110, 
    0,   162,    45,    89,     0,   164,    44,    69,     0,   163,    43,    50,     0,   163,    43,    33,     0,   161,    44,    17,     0,   159,    45,     4,     0,   155,    49,     0, 
    0,   151,    54,     0,     0,   166,    12,   236,     0,   163,    10,   221,     0,   159,    15,   209,     0,   157,    19,   196,     0,   157,    21,   184,     0,   156,    22,   170, 
    0,   156,    25,   153,     0,   157,    26,   136,     0,   157,    28,   117,     0,   158,    30,    97,     0,   159,    30,    77,     0,   161,    29,    59,     0,   160,    29,    41, 
    0,   160,    28,    25,     0,   158,    30,    10,     0,   153,    34,     1,     0,   147,    42,     0,     0,   170,     7,   236,     0,   163,     4,   218,     0,   158,     6,   206, 
    0,   155,     8,   194,     0,   154,     9,   182,     0,   154,    10,   169,     0,   153,    11,   155,     0,   153,    13,   139,     0,   154,    15,   121,     0,   155,    16,   102, 
    0,   155,    16,    84,     0,   156,    16,    66,     0,   157,    16,    48,     0,   156,    16,    32,     0,   155,    16,    17,     0,   152,    19,     5,     0,   145,    29,     0, 
    0,   172,     5,   236,     0,   162,     1,   216,     0,   156,     1,   203,     0,   153,     1,   191,     0,   150,     1,   177,     0,   148,     1,   163,     0,   149,     1,   152, 
    0,   149,     3,   138,     0,   149,     4,   123,     0,   150,     5,   105,     0,   150,     5,    89,     0,   150,     6,    72,     0,   151,     6,    54,     0,   151,     6,    36, 
    0,   150,     7,    21,     0,   150,     7,     9,     0,   145,    16,     0,     0,   173,     3,   235,     0,   161,     0,   213,     0,   154,     0,   198,     0,   148,     0,   182, 
    0,   143,     0,   166,     0,   139,     0,   152,     0,   139,     0,   142,     0,   140,     0,   132,     0,   140,     0,   120,     0,   141,     0,   105,     0,   142,     0,    91, 
    0,   142,     1,    76,     0,   143,     0,    60,     0,   143,     0,    41,     0,   143,     1,    26,     0,   143,     1,    12,     0,   142,     8,     0,     0,   173,     1,   233, 
    0,   161,     0,   212,     0,   152,     0,   194,     0,   145,     0,   176,     0,   138,     0,   159,     0,   132,     0,   144,     0,   131,     0,   135,     0,   132,     0,   126, 
    0,   132,     0,   115,     0,   132,     0,   103,     0,   132,     0,    91,     0,   133,     0,    79,     0,   133,     0,    65,     0,   133,     0,    47,     0,   133,     0,    31, 
    0,   134,     0,    17,     0,   138,     5,     0,     0,   173,     0,   232,     0,   166,     0,   217,     0,   158,     0,   200,     0,   150,     0,   182,     0,   143,     0,   164, 
    0,   134,     0,   145,     0,   134,     0,   138,     0,   135,     0,   129,     0,   135,     0,   118,     0,   135,     0,   108,     0,   135,     0,    96,     0,   135,     0,    84, 
    0,   135,     0,    71,     0,   135,     0,    53,     0,   135,     0,    32,     0,   137,     0,    14,     0,   140,     0,     0,    67,    41,   198,   227,    62,    40,   206,   224, 
   54,    47,   209,   210,    50,    53,   208,   160,    43,    61,   211,   113,    31,    77,   208,    87,    16,    95,   202,    81,    11,   108,   192,    64,     8,   121,   184,    43, 
    1,   135,   177,    29,     0,   145,   171,    20,     0,   155,   166,    14,     0,   163,   161,    11,     0,   169,   155,     8,     0,   174,   149,     5,     0,   179,   145,     2, 
    0,   183,   141,     0,    69,    47,   177,   229,    65,    49,   181,   225,    58,    60,   181,   202,    49,    69,   187,   166,    45,    75,   191,   113,    32,    94,   187,    92, 
   18,   110,   187,    76,    11,   122,   182,    56,     2,   137,   174,    39,     0,   144,   170,    18,     0,   151,   163,     3,     0,   158,   155,     1,     0,   163,   148,     1, 
    0,   168,   142,     1,     0,   172,   139,     0,     0,   177,   137,     0,     0,   180,   136,     0,    70,    59,   157,   218,    66,    62,   157,   212,    60,    73,   158,   188, 
   47,    85,   167,   167,    44,    87,   173,   121,    32,   101,   174,    97,    17,   118,   176,    79,    11,   129,   172,    59,     4,   140,   166,    40,     0,   147,   163,    20, 
    0,   153,   156,     2,     0,   159,   147,     0,     0,   163,   140,     0,     0,   167,   135,     0,     0,   171,   132,     0,     0,   174,   130,     0,     0,   177,   131,     0, 
   65,    71,   133,   214,    62,    74,   135,   206,    58,    83,   140,   184,    52,    99,   140,   158,    42,   104,   150,   138,    34,   107,   158,   112,    16,   125,   163,    87, 
    9,   135,   160,    66,     0,   147,   155,    51,     0,   149,   152,    25,     0,   154,   147,     4,     0,   158,   139,     0,     0,   162,   132,     0,     0,   165,   128,     0, 
    0,   168,   125,     0,     0,   170,   122,     0,     0,   173,   123,     0,    60,    82,   113,   212,    59,    86,   115,   197,    53,    94,   120,   183,    46,   109,   124,   159, 
   36,   120,   129,   148,    27,   120,   138,   123,    12,   131,   146,    98,     6,   138,   146,    75,     2,   145,   142,    55,     0,   150,   140,    30,     0,   153,   135,    10, 
    0,   157,   129,     1,     0,   160,   124,     0,     0,   162,   120,     0,     0,   164,   116,     0,     0,   165,   114,     0,     0,   169,   114,     0,    41,    94,    93,   231, 
   39,   101,    97,   209,    34,   108,   104,   192,    29,   118,   111,   168,    24,   125,   115,   150,    12,   132,   122,   135,     6,   135,   128,   113,     3,   139,   129,    85, 
    0,   149,   125,    64,     0,   152,   122,    38,     0,   155,   119,    16,     0,   158,   116,     3,     0,   161,   111,     0,     0,   161,   108,     0,     0,   161,   105,     0, 
    0,   161,   103,     0,     0,   165,   102,     0,    20,   114,    83,   250,    22,   119,    81,   235,    20,   122,    87,   214,    16,   125,    96,   179,    14,   130,   101,   153, 
    7,   134,   105,   140,     0,   140,   110,   122,     1,   142,   110,   101,     0,   152,   108,    76,     0,   157,   104,    53,     0,   160,   101,    32,     0,   164,    98,    14, 
    0,   166,    94,     2,     0,   165,    92,     0,     0,   163,    90,     0,     0,   161,    89,     0,     0,   165,    85,     0,     6,   134,    73,   247,     8,   136,    72,   239, 
   10,   135,    72,   220,     7,   135,    79,   194,     3,   139,    88,   168,     2,   139,    91,   149,     0,   141,    94,   131,     0,   140,    97,   113,     0,   143,    97,    89, 
    0,   152,    94,    65,     0,   155,    91,    43,     0,   157,    89,    24,     0,   159,    86,     8,     0,   159,    84,     1,     0,   157,    83,     0,     0,   156,    82,     0, 
    0,   157,    81,     0,     0,   141,    57,   245,     0,   146,    58,   234,     1,   145,    60,   220,     0,   145,    66,   200,     0,   147,    71,   182,     0,   148,    74,   160, 
    0,   148,    76,   139,     0,   143,    82,   118,     0,   140,    84,    99,     0,   146,    82,    77,     0,   152,    78,    53,     0,   154,    77,    32,     0,   156,    75,    15, 
    0,   156,    74,     2,     0,   153,    74,     0,     0,   151,    74,     0,     0,   151,    74,     0,     0,   143,    38,   239,     0,   148,    40,   227,     0,   147,    44,   216, 
    0,   146,    50,   200,     0,   149,    54,   186,     0,   152,    57,   168,     0,   152,    60,   148,     0,   151,    62,   126,     0,   143,    67,   104,     0,   144,    67,    84, 
    0,   152,    63,    61,     0,   154,    62,    40,     0,   154,    62,    22,     0,   153,    62,     8,     0,   151,    63,     1,     0,   148,    64,     0,     0,   147,    65,     0, 
    0,   146,    24,   235,     0,   148,    25,   222,     0,   147,    30,   211,     0,   146,    35,   198,     0,   148,    38,   185,     0,   149,    40,   170,     0,   150,    43,   152, 
    0,   150,    44,   132,     0,   149,    46,   110,     0,   149,    49,    89,     0,   151,    48,    70,     0,   152,    46,    50,     0,   152,    47,    32,     0,   151,    48,    15, 
    0,   148,    48,     3,     0,   144,    51,     0,     0,   141,    55,     0,     0,   151,    15,   234,     0,   150,    14,   219,     0,   148,    18,   208,     0,   146,    22,   196, 
    0,   147,    24,   184,     0,   146,    26,   170,     0,   146,    26,   153,     0,   147,    28,   135,     0,   147,    30,   116,     0,   147,    31,    96,     0,   149,    32,    77, 
    0,   150,    32,    59,     0,   150,    31,    40,     0,   149,    32,    24,     0,   146,    33,     9,     0,   143,    36,     1,     0,   136,    43,     0,     0,   156,     9,   234, 
    0,   152,     6,   217,     0,   148,     9,   205,     0,   146,    10,   195,     0,   145,    12,   182,     0,   144,    12,   169,     0,   144,    13,   154,     0,   144,    15,   137, 
    0,   145,    16,   120,     0,   145,    17,   101,     0,   146,    18,    84,     0,   146,    18,    66,     0,   147,    18,    47,     0,   146,    18,    31,     0,   145,    19,    16, 
    0,   142,    21,     4,     0,   134,    31,     0,     0,   160,     5,   234,     0,   153,     2,   215,     0,   148,     3,   203,     0,   145,     2,   192,     0,   143,     2,   179, 
    0,   141,     2,   164,     0,   140,     3,   150,     0,   139,     4,   136,     0,   140,     6,   121,     0,   140,     6,   104,     0,   141,     7,    88,     0,   141,     7,    72, 
    0,   141,     7,    53,     0,   142,     7,    36,     0,   140,     8,    21,     0,   140,     8,     9,     0,   133,    18,     0,     0,   163,     3,   233,     0,   153,     0,   212, 
    0,   147,     0,   198,     0,   142,     0,   184,     0,   137,     0,   168,     0,   132,     0,   153,     0,   130,     0,   139,     0,   130,     0,   128,     0,   131,     0,   116, 
    0,   131,     0,   102,     0,   132,     1,    89,     0,   133,     1,    75,     0,   133,     1,    59,     0,   133,     1,    41,     0,   133,     1,    26,     0,   133,     1,    13, 
    0,   130,     9,     0,     0,   165,     1,   232,     0,   154,     0,   211,     0,   146,     0,   194,     0,   139,     0,   177,     0,   132,     0,   160,     0,   125,     0,   143, 
    0,   120,     0,   126,     0,   119,     0,   116,     0,   120,     0,   107,     0,   120,     0,    97,     0,   121,     0,    87,     0,   121,     0,    76,     0,   121,     0,    62, 
    0,   121,     0,    46,     0,   121,     0,    31,     0,   122,     0,    17,     0,   124,     5,     0,     0,   166,     0,   231,     0,   159,     0,   216,     0,   152,     0,   200, 
    0,   145,     0,   183,     0,   138,     0,   165,     0,   129,     0,   146,     0,   118,     0,   124,     0,   119,     0,   116,     0,   119,     0,   106,     0,   119,     0,    98, 
    0,   119,     0,    89,     0,   119,     0,    79,     0,   120,     0,    67,     0,   119,     0,    50,     0,   120,     0,    30,     0,   121,     0,    12,     0,   122,     0,     0, 
   45,    44,   196,   229,    40,    44,   202,   227,    33,    50,   205,   215,    27,    56,   204,   181,    24,    60,   207,   139,    12,    78,   204,   113,     0,    91,   199,    98, 
    0,    90,   198,    76,     1,    96,   189,    50,     0,   107,   182,    29,     0,   121,   177,    16,     0,   133,   172,    12,     0,   144,   167,     9,     0,   152,   162,     7, 
    0,   158,   157,     4,     0,   164,   153,     2,     0,   168,   148,     0,    48,    51,   179,   230,    45,    51,   182,   227,    37,    61,   184,   208,    26,    71,   187,   184, 
   25,    72,   191,   138,    15,    86,   191,   110,     2,   100,   188,    93,     0,   103,   185,    70,     1,   110,   179,    41,     0,   118,   174,    19,     0,   127,   168,     3, 
    0,   137,   161,     1,     0,   146,   155,     1,     0,   152,   149,     1,     0,   157,   145,     0,     0,   162,   142,     0,     0,   164,   142,     0,    46,    64,   158,   221, 
   42,    66,   160,   216,    34,    77,   162,   195,    23,    84,   171,   181,    21,    83,   178,   142,    16,    92,   180,   113,     3,   107,   179,    95,     4,   108,   177,    69, 
    3,   116,   172,    44,     0,   124,   167,    23,     0,   131,   162,     4,     0,   139,   154,     0,     0,   146,   146,     0,     0,   152,   141,     0,     0,   156,   136,     0, 
    0,   159,   134,     0,     0,   161,   135,     0,    39,    75,   143,   213,    36,    78,   145,   207,    31,    84,   147,   193,    22,    92,   152,   177,    16,    99,   159,   158, 
   15,   100,   164,   129,     4,   114,   166,   103,     1,   116,   164,    79,     0,   123,   160,    52,     0,   127,   157,    28,     0,   133,   153,     8,     0,   140,   145,     1, 
    0,   146,   138,     0,     0,   150,   132,     0,     0,   153,   127,     0,     0,   156,   125,     0,     0,   158,   127,     0,    30,    85,   129,   212,    30,    88,   130,   204, 
   28,    91,   133,   191,    20,    99,   137,   175,    16,   114,   137,   154,    11,   112,   145,   134,     3,   118,   150,   110,     1,   120,   151,    85,     1,   124,   147,    58, 
    0,   130,   144,    36,     0,   134,   141,    14,     0,   140,   135,     1,     0,   144,   128,     0,     0,   147,   122,     0,     0,   150,   119,     0,     0,   152,   116,     0, 
    0,   156,   117,     0,    22,    92,   112,   227,    19,    96,   115,   208,    19,    99,   119,   193,    18,   104,   124,   179,     9,   116,   125,   155,     0,   125,   129,   142, 
    0,   123,   132,   122,     0,   121,   136,    96,     0,   127,   132,    68,     0,   132,   130,    43,     0,   135,   127,    19,     0,   139,   122,     2,     0,   142,   117,     0, 
    0,   144,   112,     0,     0,   146,   109,     0,     0,   147,   107,     0,     0,   152,   106,     0,    10,   102,    93,   246,     9,   107,    99,   220,    11,   105,   101,   199, 
   10,   107,   104,   180,     6,   115,   109,   156,     0,   122,   112,   140,     0,   124,   114,   125,     0,   123,   117,   104,     0,   129,   115,    75,     0,   132,   111,    51, 
    0,   136,   109,    27,     0,   140,   107,     7,     0,   142,   103,     1,     0,   143,   100,     0,     0,   143,    97,     0,     0,   144,    95,     0,     0,   147,    93,     0, 
    0,   112,    79,   250,     0,   111,    83,   239,     1,   111,    87,   220,     5,   110,    86,   194,     1,   115,    93,   166,     0,   120,    95,   142,     0,   123,    96,   128, 
    0,   129,    97,   107,     0,   129,    98,    86,     0,   134,    94,    63,     0,   139,    91,    41,     0,   143,    89,    21,     0,   146,    86,     6,     0,   147,    84,     0, 
    0,   146,    82,     0,     0,   145,    80,     0,     0,   147,    76,     0,     0,   118,    59,   246,     0,   122,    61,   234,     0,   123,    65,   220,     0,   123,    69,   200, 
    0,   126,    74,   181,     0,   127,    79,   153,     0,   128,    81,   134,     0,   128,    83,   116,     0,   127,    85,    97,     0,   130,    83,    76,     0,   136,    80,    53, 
    0,   139,    78,    32,     0,   141,    77,    14,     0,   142,    76,     2,     0,   140,    75,     0,     0,   139,    73,     0,     0,   140,    72,     0,     0,   123,    42,   240, 
    0,   128,    44,   228,     0,   129,    49,   214,     0,   129,    54,   199,     0,   133,    57,   185,     0,   136,    61,   167,     0,   136,    63,   146,     0,   134,    65,   125, 
    0,   128,    69,   104,     0,   125,    72,    85,     0,   131,    69,    65,     0,   137,    66,    41,     0,   139,    65,    21,     0,   140,    65,     7,     0,   138,    64,     1, 
    0,   136,    64,     0,     0,   134,    64,     0,     0,   127,    29,   235,     0,   131,    30,   222,     0,   132,    35,   209,     0,   133,    38,   197,     0,   135,    41,   185, 
    0,   138,    44,   170,     0,   138,    46,   153,     0,   138,    47,   132,     0,   136,    50,   111,     0,   130,    55,    90,     0,   130,    55,    72,     0,   137,    51,    50, 
    0,   139,    51,    30,     0,   138,    52,    13,     0,   137,    52,     2,     0,   133,    53,     0,     0,   130,    55,     0,     0,   134,    18,   233,     0,   135,    18,   217, 
    0,   134,    22,   206,     0,   134,    25,   196,     0,   135,    27,   184,     0,   135,    29,   169,     0,   135,    30,   153,     0,   135,    31,   135,     0,   135,    32,   116, 
    0,   135,    34,    96,     0,   135,    36,    77,     0,   137,    35,    59,     0,   138,    34,    39,     0,   137,    35,    23,     0,   135,    36,     8,     0,   131,    38,     1, 
    0,   125,    44,     0,     0,   140,    10,   233,     0,   139,     9,   214,     0,   136,    11,   203,     0,   135,    13,   194,     0,   134,    14,   182,     0,   134,    16,   168, 
    0,   134,    16,   153,     0,   133,    17,   136,     0,   133,    18,   118,     0,   133,    19,   100,     0,   134,    20,    83,     0,   135,    21,    65,     0,   135,    21,    47, 
    0,   136,    21,    30,     0,   135,    21,    15,     0,   131,    23,     3,     0,   121,    32,     0,     0,   146,     6,   232,     0,   141,     3,   213,     0,   137,     4,   202, 
    0,   135,     4,   192,     0,   133,     4,   179,     0,   131,     5,   165,     0,   130,     5,   150,     0,   129,     6,   134,     0,   130,     7,   119,     0,   130,     8,   102, 
    0,   130,     8,    87,     0,   131,     9,    71,     0,   131,     9,    53,     0,   132,     9,    36,     0,   131,     9,    21,     0,   129,    10,     8,     0,   119,    20,     0, 
    0,   150,     3,   231,     0,   144,     1,   211,     0,   138,     0,   199,     0,   133,     0,   186,     0,   129,     0,   170,     0,   125,     0,   154,     0,   122,     0,   139, 
    0,   121,     0,   125,     0,   121,     1,   113,     0,   122,     1,   100,     0,   123,     1,    88,     0,   124,     1,    74,     0,   124,     1,    58,     0,   124,     1,    41, 
    0,   124,     1,    25,     0,   123,     1,    12,     0,   116,     9,     0,     0,   154,     1,   231,     0,   146,     0,   210,     0,   138,     0,   194,     0,   131,     0,   178, 
    0,   125,     0,   161,     0,   118,     0,   143,     0,   112,     0,   125,     0,   108,     0,   109,     0,   108,     0,   100,     0,   109,     0,    92,     0,   109,     0,    83, 
    0,   110,     0,    73,     0,   110,     0,    60,     0,   110,     0,    44,     0,   109,     0,    30,     0,   109,     0,    17,     0,   109,     4,     0,     0,   157,     0,   230, 
    0,   151,     0,   216,     0,   144,     0,   201,     0,   138,     0,   184,     0,   131,     0,   166,     0,   122,     0,   146,     0,   112,     0,   124,     0,   101,     0,   102, 
    0,   102,     0,    94,     0,   102,     0,    88,     0,   102,     0,    81,     0,   102,     0,    73,     0,   103,     0,    61,     0,   102,     0,    46,     0,   102,     0,    28, 
    0,   103,     0,    11,     0,   104,     0,     0,    21,    48,   196,   230,    18,    48,   200,   228,    11,    53,   202,   217,     6,    59,   201,   192,     2,    64,   201,   165, 
    0,    70,   199,   129,     0,    70,   198,    97,     0,    70,   198,    73,     0,    69,   196,    52,     0,    81,   188,    30,     0,    95,   183,    14,     0,   110,   179,     7, 
    0,   123,   173,     7,     0,   133,   168,     6,     0,   141,   164,     4,     0,   148,   160,     2,     0,   154,   155,     0,    26,    54,   181,   231,    24,    55,   183,   229, 
   18,    62,   182,   209,     3,    74,   186,   191,     0,    77,   190,   163,     0,    82,   189,   128,     0,    82,   188,    95,     0,    84,   186,    71,     0,    86,   183,    47, 
    0,    94,   178,    23,     0,   103,   173,     3,     0,   115,   165,     1,     0,   126,   159,     1,     0,   134,   155,     1,     0,   141,   151,     0,     0,   147,   148,     0, 
    0,   150,   149,     0,    26,    64,   164,   221,    24,    66,   165,   216,    19,    73,   166,   199,     7,    79,   172,   185,     4,    79,   180,   157,     2,    85,   181,   130, 
    0,    89,   179,    99,     0,    91,   178,    76,     0,    94,   175,    51,     0,    99,   171,    25,     0,   107,   166,     4,     0,   118,   158,     0,     0,   127,   152,     0, 
    0,   134,   147,     0,     0,   140,   142,     0,     0,   144,   139,     0,     0,   147,   141,     0,    22,    72,   150,   215,    20,    74,   150,   209,    17,    78,   153,   196, 
    6,    86,   160,   183,     0,    91,   164,   167,     0,    92,   167,   144,     0,    95,   168,   108,     0,    96,   167,    81,     0,    98,   165,    56,     0,   104,   162,    31, 
    0,   111,   157,     9,     0,   120,   151,     1,     0,   128,   144,     0,     0,   134,   138,     0,     0,   139,   133,     0,     0,   142,   130,     0,     0,   144,   133,     0, 
   17,    79,   136,   212,    16,    81,   136,   206,    13,    85,   138,   193,     5,    92,   144,   181,     1,    96,   146,   165,     0,    98,   150,   146,     0,    99,   153,   114, 
    0,   101,   154,    88,     0,   103,   152,    63,     0,   108,   150,    38,     0,   114,   146,    16,     0,   121,   141,     1,     0,   128,   134,     0,     0,   132,   128,     0, 
    0,   136,   122,     0,     0,   139,   119,     0,     0,   142,   120,     0,    11,    82,   121,   226,    12,    87,   124,   205,     9,    91,   127,   190,     5,    96,   129,   178, 
    0,   100,   132,   162,     0,   109,   131,   144,     0,   107,   134,   124,     0,   103,   138,   100,     0,   107,   138,    70,     0,   112,   136,    46,     0,   117,   133,    23, 
    0,   121,   129,     4,     0,   126,   123,     0,     0,   130,   116,     0,     0,   132,   111,     0,     0,   135,   109,     0,     0,   139,   109,     0,     1,    89,   103,   243, 
    1,    94,   109,   213,     2,    96,   110,   190,     2,    98,   113,   178,     0,   102,   116,   162,     0,   109,   115,   139,     0,   113,   114,   127,     0,   110,   119,   107, 
    0,   111,   121,    77,     0,   113,   120,    54,     0,   118,   118,    31,     0,   121,   115,     9,     0,   124,   109,     1,     0,   126,   104,     0,     0,   128,   101,     0, 
    0,   130,    98,     0,     0,   134,    97,     0,     0,    91,    80,   247,     3,    91,    84,   217,     0,    95,    91,   202,     0,    97,    95,   187,     0,   100,    98,   167, 
    0,   106,   100,   143,     0,   109,   100,   126,     0,   111,   102,   109,     0,   112,   104,    86,     0,   113,   102,    63,     0,   118,    98,    39,     0,   122,    96,    17, 
    0,   124,    94,     2,     0,   126,    91,     0,     0,   127,    88,     0,     0,   127,    85,     0,     0,   130,    83,     0,     0,    91,    61,   247,     0,    97,    65,   231, 
    0,   100,    69,   214,     0,   100,    73,   198,     0,   103,    76,   178,     0,   106,    81,   150,     0,   110,    83,   127,     0,   111,    84,   112,     0,   114,    85,    94, 
    0,   113,    84,    74,     0,   120,    81,    51,     0,   124,    79,    29,     0,   127,    77,    11,     0,   129,    75,     1,     0,   129,    73,     0,     0,   128,    71,     0, 
    0,   130,    67,     0,     0,    99,    45,   241,     0,   105,    48,   228,     0,   106,    53,   213,     0,   107,    57,   199,     0,   109,    60,   183,     0,   111,    64,   163, 
    0,   113,    68,   137,     0,   113,    69,   120,     0,   112,    71,   102,     0,   111,    73,    83,     0,   115,    70,    64,     0,   121,    68,    40,     0,   124,    67,    20, 
    0,   126,    66,     5,     0,   125,    65,     0,     0,   122,    64,     0,     0,   121,    62,     0,     0,   106,    32,   235,     0,   111,    34,   222,     0,   112,    39,   209, 
    0,   114,    42,   197,     0,   116,    44,   185,     0,   119,    48,   170,     0,   121,    50,   151,     0,   120,    51,   131,     0,   119,    53,   110,     0,   113,    57,    89, 
    0,   110,    59,    73,     0,   116,    57,    54,     0,   123,    54,    29,     0,   124,    54,    11,     0,   124,    53,     1,     0,   120,    54,     0,     0,   116,    54,     0, 
    0,   115,    21,   232,     0,   116,    22,   218,     0,   117,    25,   205,     0,   118,    28,   196,     0,   119,    30,   184,     0,   121,    32,   170,     0,   122,    34,   154, 
    0,   122,    35,   135,     0,   121,    36,   114,     0,   119,    38,    95,     0,   114,    43,    78,     0,   115,    43,    62,     0,   122,    39,    39,     0,   124,    39,    20, 
    0,   122,    40,     6,     0,   118,    41,     1,     0,   112,    43,     0,     0,   123,    13,   232,     0,   123,    11,   214,     0,   122,    13,   203,     0,   121,    15,   194, 
    0,   120,    17,   182,     0,   121,    18,   169,     0,   120,    19,   153,     0,   120,    20,   136,     0,   120,    21,   116,     0,   119,    23,    98,     0,   119,    24,    82, 
    0,   120,    25,    65,     0,   122,    24,    47,     0,   124,    24,    29,     0,   123,    24,    14,     0,   118,    26,     2,     0,   107,    33,     0,     0,   130,     7,   230, 
    0,   128,     4,   211,     0,   125,     5,   201,     0,   123,     6,   191,     0,   121,     6,   180,     0,   119,     7,   165,     0,   118,     7,   150,     0,   118,     8,   134, 
    0,   118,     8,   117,     0,   119,     9,   101,     0,   119,    10,    86,     0,   120,    10,    70,     0,   120,    11,    52,     0,   121,    11,    36,     0,   121,    11,    20, 
    0,   118,    12,     7,     0,   104,    21,     0,     0,   136,     4,   229,     0,   131,     1,   210,     0,   127,     1,   198,     0,   123,     0,   186,     0,   119,     0,   172, 
    0,   115,     1,   156,     0,   113,     1,   141,     0,   112,     1,   126,     0,   112,     1,   111,     0,   113,     1,    98,     0,   113,     1,    87,     0,   115,     1,    73, 
    0,   115,     1,    57,     0,   114,     2,    40,     0,   115,     1,    25,     0,   113,     2,    11,     0,   102,    10,     0,     0,   141,     2,   229,     0,   135,     0,   209, 
    0,   128,     0,   193,     0,   122,     0,   177,     0,   115,     0,   161,     0,   109,     0,   143,     0,   104,     0,   126,     0,   100,     0,   109,     0,    98,     0,    96, 
    0,    98,     0,    88,     0,    99,     0,    80,     0,   100,     0,    70,     0,   100,     0,    58,     0,   100,     0,    43,     0,    99,     0,    29,     0,    98,     0,    17, 
    0,    94,     4,     0,     0,   146,     0,   229,     0,   140,     0,   216,     0,   135,     0,   201,     0,   129,     0,   185,     0,   122,     0,   166,     0,   113,     0,   146, 
    0,   104,     0,   125,     0,    95,     0,   102,     0,    87,     0,    84,     0,    85,     0,    77,     0,    85,     0,    71,     0,    85,     0,    64,     0,    86,     0,    55, 
    0,    86,     0,    43,     0,    86,     0,    27,     0,    86,     0,    11,     0,    88,     0,     0,     5,    45,   197,   232,     4,    42,   201,   230,     1,    44,   203,   218, 
    0,    48,   199,   197,     0,    49,   197,   170,     0,    51,   197,   136,     0,    52,   198,   102,     0,    52,   198,    75,     0,    52,   196,    52,     0,    54,   196,    36, 
    0,    70,   191,    19,     0,    86,   186,     6,     0,   100,   180,     2,     0,   113,   174,     3,     0,   123,   169,     3,     0,   131,   165,     2,     0,   138,   161,     0, 
    8,    51,   184,   235,     6,    52,   184,   231,     0,    59,   186,   210,     0,    59,   183,   192,     0,    58,   188,   163,     0,    60,   188,   133,     0,    63,   188,    99, 
    0,    66,   187,    74,     0,    68,   184,    50,     0,    71,   182,    29,     0,    80,   177,     9,     0,    93,   170,     1,     0,   105,   164,     0,     0,   115,   159,     0, 
    0,   124,   156,     0,     0,   131,   153,     0,     0,   135,   154,     0,     8,    55,   174,   235,     7,    60,   169,   219,     2,    70,   166,   199,     0,    68,   172,   186, 
    0,    64,   180,   161,     0,    66,   181,   135,     0,    69,   180,   102,     0,    72,   179,    78,     0,    75,   176,    54,     0,    78,   174,    32,     0,    84,   170,    10, 
    0,    96,   162,     1,     0,   107,   155,     0,     0,   116,   151,     0,     0,   123,   147,     0,     0,   129,   145,     0,     0,   132,   147,     0,     5,    60,   161,   230, 
    6,    64,   153,   214,     0,    73,   157,   197,     0,    74,   159,   183,     0,    75,   164,   168,     0,    76,   167,   148,     0,    78,   168,   120,     0,    77,   168,    91, 
    0,    80,   167,    61,     0,    83,   165,    37,     0,    89,   162,    14,     0,    98,   155,     1,     0,   109,   148,     0,     0,   117,   142,     0,     0,   122,   138,     0, 
    0,   127,   135,     0,     0,   129,   138,     0,     4,    66,   144,   228,     3,    71,   142,   210,     0,    77,   144,   194,     0,    79,   145,   180,     0,    82,   148,   165, 
    0,    83,   151,   150,     0,    83,   153,   126,     0,    83,   154,    98,     0,    86,   155,    66,     0,    88,   154,    42,     0,    93,   151,    19,     0,   100,   146,     2, 
    0,   109,   139,     0,     0,   116,   133,     0,     0,   121,   128,     0,     0,   125,   124,     0,     0,   127,   126,     0,     0,    72,   129,   233,     0,    78,   131,   209, 
    1,    82,   132,   192,     0,    83,   132,   179,     0,    85,   135,   165,     0,    88,   136,   148,     0,    87,   137,   130,     0,    87,   140,   103,     0,    91,   141,    72, 
    0,    92,   140,    49,     0,    97,   138,    25,     0,   102,   135,     6,     0,   109,   129,     0,     0,   114,   122,     0,     0,   118,   116,     0,     0,   122,   112,     0, 
    0,   125,   113,     0,     0,    72,   107,   240,     0,    79,   112,   207,     0,    84,   114,   187,     0,    86,   117,   176,     0,    88,   119,   161,     0,    90,   121,   143, 
    0,    97,   117,   128,     0,    94,   121,   109,     0,    94,   125,    79,     0,    94,   126,    57,     0,    99,   124,    34,     0,   104,   121,    14,     0,   108,   116,     1, 
    0,   112,   110,     0,     0,   115,   104,     0,     0,   118,   100,     0,     0,   122,    99,     0,     0,    75,    85,   238,     0,    78,    92,   210,     0,    82,    96,   195, 
    0,    83,   101,   181,     0,    87,   103,   164,     0,    89,   104,   144,     0,    95,   103,   125,     0,    98,   103,   111,     0,    96,   107,    91,     0,    93,   110,    68, 
    0,    99,   107,    42,     0,   104,   105,    20,     0,   106,   101,     2,     0,   109,    96,     0,     0,   112,    91,     0,     0,   114,    88,     0,     0,   117,    86,     0, 
    0,    76,    65,   242,     0,    80,    69,   225,     0,    82,    73,   207,     0,    82,    80,   190,     0,    84,    84,   171,     0,    88,    86,   151,     0,    93,    87,   128, 
    0,    95,    88,   110,     0,    95,    89,    93,     0,    94,    91,    74,     0,   100,    87,    50,     0,   104,    85,    27,     0,   106,    83,     7,     0,   109,    81,     0, 
    0,   110,    78,     0,     0,   110,    76,     0,     0,   112,    72,     0,     0,    76,    48,   242,     0,    82,    51,   227,     0,    83,    56,   212,     0,    82,    62,   197, 
    0,    85,    65,   179,     0,    88,    69,   160,     0,    93,    71,   134,     0,    94,    73,   113,     0,    95,    72,    98,     0,    97,    71,    82,     0,    99,    71,    61, 
    0,   105,    68,    37,     0,   109,    67,    17,     0,   111,    65,     3,     0,   111,    63,     0,     0,   110,    62,     0,     0,   112,    58,     0,     0,    85,    35,   236, 
    0,    89,    37,   223,     0,    91,    41,   210,     0,    93,    44,   197,     0,    95,    47,   184,     0,    95,    51,   168,     0,    98,    54,   147,     0,    99,    56,   122, 
    0,    98,    57,   105,     0,    97,    58,    88,     0,    96,    60,    71,     0,   101,    58,    52,     0,   106,    56,    28,     0,   109,    55,    10,     0,   108,    54,     1, 
    0,   106,    54,     0,     0,   104,    52,     0,     0,    94,    24,   231,     0,    96,    26,   217,     0,    97,    28,   206,     0,   100,    30,   195,     0,   101,    32,   184, 
    0,   103,    35,   171,     0,   104,    37,   154,     0,   105,    38,   134,     0,   103,    40,   112,     0,    98,    44,    92,     0,    95,    48,    77,     0,    96,    48,    62, 
    0,   102,    44,    42,     0,   108,    42,    19,     0,   107,    42,     4,     0,   104,    42,     0,     0,   100,    43,     0,     0,   104,    15,   229,     0,   104,    15,   214, 
    0,   104,    16,   204,     0,   104,    17,   193,     0,   105,    19,   183,     0,   106,    21,   170,     0,   106,    22,   154,     0,   106,    24,   136,     0,   105,    25,   116, 
    0,   100,    29,    94,     0,    99,    31,    79,     0,   100,    32,    65,     0,   102,    31,    49,     0,   109,    27,    28,     0,   109,    27,    11,     0,   104,    29,     1, 
    0,    96,    33,     0,     0,   112,     8,   229,     0,   111,     6,   213,     0,   110,     7,   202,     0,   109,     7,   192,     0,   107,     8,   180,     0,   106,     9,   166, 
    0,   105,    10,   151,     0,   105,    11,   135,     0,   105,    11,   118,     0,   105,    11,    99,     0,   105,    13,    84,     0,   105,    14,    69,     0,   105,    14,    52, 
    0,   107,    14,    35,     0,   109,    13,    19,     0,   105,    15,     5,     0,    93,    22,     0,     0,   119,     4,   228,     0,   117,     2,   209,     0,   114,     1,   199, 
    0,   111,     1,   187,     0,   107,     1,   173,     0,   104,     1,   159,     0,   102,     1,   145,     0,   102,     1,   129,     0,   102,     1,   113,     0,   102,     1,    97, 
    0,   102,     2,    85,     0,   103,     2,    72,     0,   103,     3,    56,     0,   103,     3,    39,     0,   103,     3,    24,     0,   102,     4,    10,     0,    90,    12,     0, 
    0,   126,     2,   227,     0,   122,     0,   207,     0,   117,     0,   191,     0,   111,     0,   176,     0,   105,     0,   160,     0,    99,     0,   144,     0,    95,     0,   127, 
    0,    92,     0,   111,     0,    90,     0,    96,     0,    89,     0,    85,     0,    89,     0,    76,     0,    90,     0,    67,     0,    90,     0,    56,     0,    90,     0,    43, 
    0,    90,     0,    29,     0,    89,     1,    16,     0,    84,     5,     0,     0,   133,     0,   228,     0,   128,     0,   215,     0,   123,     0,   200,     0,   117,     0,   185, 
    0,   111,     0,   167,     0,   104,     0,   146,     0,    96,     0,   125,     0,    87,     0,   103,     0,    78,     0,    83,     0,    77,     0,    73,     0,    77,     0,    67, 
    0,    77,     0,    61,     0,    77,     0,    53,     0,    77,     0,    42,     0,    77,     0,    28,     0,    77,     0,    11,     0,    77,     0,     0,     2,    32,   197,   235, 
    1,    30,   200,   233,     1,    29,   201,   221,     0,    34,   198,   200,     0,    35,   196,   175,     0,    37,   196,   145,     0,    38,   196,   111,     0,    39,   199,    83, 
    0,    40,   200,    59,     0,    41,   199,    39,     0,    43,   200,    26,     0,    61,   193,    12,     0,    77,   187,     3,     0,    92,   180,     0,     0,   103,   174,     0, 
    0,   114,   170,     1,     0,   122,   166,     0,     1,    35,   190,   236,     2,    39,   185,   234,     0,    44,   182,   212,     0,    45,   182,   194,     0,    42,   186,   164, 
    0,    44,   187,   139,     0,    46,   186,   106,     0,    48,   187,    79,     0,    50,   185,    55,     0,    53,   184,    35,     0,    56,   182,    16,     0,    69,   176,     3, 
    0,    84,   169,     0,     0,    96,   163,     0,     0,   105,   160,     0,     0,   114,   157,     0,     0,   119,   159,     0,     1,    39,   182,   238,     1,    46,   173,   225, 
    0,    57,   165,   199,     0,    53,   170,   187,     0,    49,   178,   161,     0,    50,   179,   140,     0,    51,   178,   109,     0,    55,   179,    82,     0,    57,   176,    58, 
    0,    60,   175,    37,     0,    63,   173,    17,     0,    73,   168,     2,     0,    86,   160,     0,     0,    97,   154,     0,     0,   106,   150,     0,     0,   112,   149,     0, 
    0,   116,   152,     0,     1,    43,   168,   239,     0,    52,   160,   222,     0,    59,   153,   195,     0,    59,   158,   184,     0,    62,   162,   167,     0,    62,   164,   149, 
    0,    63,   165,   127,     0,    61,   167,    99,     0,    64,   167,    66,     0,    67,   166,    43,     0,    69,   165,    21,     0,    76,   159,     2,     0,    88,   151,     0, 
    0,    99,   145,     0,     0,   105,   142,     0,     0,   111,   140,     0,     0,   113,   143,     0,     0,    48,   151,   239,     0,    56,   145,   217,     0,    64,   143,   195, 
    0,    65,   145,   182,     0,    68,   149,   164,     0,    71,   150,   149,     0,    72,   150,   132,     0,    68,   154,   104,     0,    71,   156,    69,     0,    72,   155,    46, 
    0,    74,   154,    24,     0,    79,   150,     3,     0,    90,   142,     0,     0,    98,   136,     0,     0,   104,   132,     0,     0,   109,   129,     0,     0,   112,   132,     0, 
    0,    52,   132,   238,     0,    61,   131,   211,     0,    67,   131,   191,     0,    68,   133,   181,     0,    72,   138,   164,     0,    74,   138,   147,     0,    75,   138,   130, 
    0,    72,   141,   108,     0,    75,   143,    75,     0,    76,   143,    51,     0,    77,   142,    28,     0,    82,   139,     8,     0,    90,   133,     1,     0,    97,   126,     0, 
    0,   103,   121,     0,     0,   108,   117,     0,     0,   110,   119,     0,     0,    56,   111,   239,     0,    64,   115,   206,     0,    71,   118,   186,     0,    73,   119,   175, 
    0,    74,   121,   161,     0,    76,   123,   145,     0,    76,   122,   129,     0,    75,   125,   111,     0,    77,   128,    81,     0,    78,   129,    60,     0,    79,   128,    37, 
    0,    84,   126,    15,     0,    89,   121,     2,     0,    96,   115,     0,     0,   101,   109,     0,     0,   105,   104,     0,     0,   108,   104,     0,     0,    59,    90,   237, 
    0,    64,    97,   208,     0,    68,   100,   192,     0,    71,   104,   177,     0,    75,   105,   159,     0,    76,   106,   143,     0,    77,   106,   128,     0,    83,   104,   113, 
    0,    81,   108,    93,     0,    77,   112,    71,     0,    81,   111,    45,     0,    86,   109,    23,     0,    89,   106,     5,     0,    94,   101,     0,     0,    98,    95,     0, 
    0,   101,    91,     0,     0,   104,    88,     0,     0,    61,    71,   238,     0,    66,    75,   215,     0,    68,    80,   201,     0,    70,    86,   182,     0,    75,    88,   158, 
    0,    76,    89,   143,     0,    78,    89,   128,     0,    82,    89,   109,     0,    84,    89,    96,     0,    81,    93,    76,     0,    83,    93,    51,     0,    86,    92,    29, 
    0,    89,    90,     9,     0,    92,    86,     1,     0,    95,    81,     0,     0,    97,    78,     0,     0,    98,    75,     0,     0,    63,    52,   238,     0,    67,    57,   220, 
    0,    69,    61,   206,     0,    68,    68,   190,     0,    71,    72,   172,     0,    74,    74,   154,     0,    76,    75,   135,     0,    79,    75,   113,     0,    81,    75,    96, 
    0,    81,    75,    79,     0,    83,    75,    60,     0,    86,    74,    37,     0,    90,    70,    17,     0,    92,    70,     2,     0,    94,    68,     0,     0,    94,    65,     0, 
    0,    95,    63,     0,     0,    62,    37,   236,     0,    69,    41,   222,     0,    72,    45,   209,     0,    74,    47,   196,     0,    77,    50,   180,     0,    78,    54,   163, 
    0,    80,    56,   145,     0,    81,    58,   120,     0,    82,    60,    99,     0,    81,    60,    85,     0,    82,    58,    71,     0,    85,    58,    49,     0,    91,    56,    25, 
    0,    94,    55,     7,     0,    94,    53,     0,     0,    94,    51,     0,     0,    95,    48,     0,     0,    73,    26,   232,     0,    76,    28,   218,     0,    78,    31,   207, 
    0,    82,    32,   196,     0,    84,    35,   183,     0,    83,    39,   169,     0,    85,    40,   153,     0,    85,    42,   133,     0,    84,    45,   108,     0,    82,    48,    89, 
    0,    81,    48,    75,     0,    83,    48,    59,     0,    87,    46,    39,     0,    92,    43,    17,     0,    93,    43,     2,     0,    90,    43,     0,     0,    88,    42,     0, 
    0,    84,    17,   228,     0,    85,    18,   213,     0,    86,    19,   204,     0,    87,    20,   194,     0,    88,    22,   183,     0,    89,    24,   170,     0,    90,    25,   155, 
    0,    91,    27,   138,     0,    90,    29,   116,     0,    86,    32,    94,     0,    82,    35,    77,     0,    82,    36,    64,     0,    84,    35,    49,     0,    88,    32,    30, 
    0,    92,    30,     9,     0,    90,    31,     1,     0,    85,    33,     0,     0,    93,    10,   226,     0,    93,     9,   212,     0,    93,     9,   202,     0,    92,     9,   192, 
    0,    92,    10,   180,     0,    92,    12,   166,     0,    92,    13,   152,     0,    92,    14,   136,     0,    92,    14,   118,     0,    91,    15,    99,     0,    86,    19,    80, 
    0,    86,    20,    66,     0,    85,    21,    52,     0,    87,    20,    36,     0,    94,    16,    17,     0,    92,    17,     3,     0,    82,    23,     0,     0,   101,     5,   226, 
    0,   100,     3,   210,     0,    98,     2,   200,     0,    96,     1,   189,     0,    94,     2,   176,     0,    92,     2,   161,     0,    91,     3,   145,     0,    90,     3,   130, 
    0,    90,     3,   115,     0,    90,     3,    98,     0,    89,     4,    82,     0,    89,     5,    69,     0,    89,     6,    55,     0,    89,     6,    39,     0,    91,     5,    23, 
    0,    91,     5,     9,     0,    79,    13,     0,     0,   109,     2,   225,     0,   107,     0,   207,     0,   102,     0,   192,     0,    98,     0,   177,     0,    94,     0,   161, 
    0,    90,     0,   145,     0,    86,     0,   129,     0,    84,     0,   113,     0,    82,     0,    99,     0,    80,     0,    85,     0,    80,     0,    75,     0,    81,     0,    65, 
    0,    82,     0,    55,     0,    82,     0,    42,     0,    82,     0,    29,     0,    81,     1,    15,     0,    75,     5,     0,     0,   117,     0,   226,     0,   114,     0,   213, 
    0,   109,     0,   199,     0,   104,     0,   184,     0,    99,     0,   167,     0,    93,     0,   147,     0,    87,     0,   126,     0,    79,     0,   105,     0,    71,     0,    85, 
    0,    69,     0,    74,     0,    69,     0,    65,     0,    69,     0,    59,     0,    69,     0,    51,     0,    69,     0,    41,     0,    69,     0,    28,     0,    69,     0,    13, 
    0,    69,     0,     0,     0,    24,   197,   236,     0,    22,   200,   234,     0,    20,   202,   225,     0,    23,   199,   204,     0,    25,   197,   179,     0,    26,   196,   152, 
    0,    28,   196,   124,     0,    28,   200,    93,     0,    29,   202,    66,     0,    31,   202,    46,     0,    32,   203,    29,     0,    33,   203,    18,     0,    53,   195,     8, 
    0,    70,   188,     2,     0,    85,   181,     0,     0,    96,   175,     0,     0,   106,   171,     0,     0,    25,   191,   237,     0,    26,   184,   234,     0,    28,   182,   218, 
    0,    28,   182,   197,     0,    26,   186,   167,     0,    28,   186,   145,     0,    30,   187,   118,     0,    32,   188,    87,     0,    35,   187,    61,     0,    37,   185,    40, 
    0,    40,   185,    23,     0,    44,   182,     8,     0,    59,   175,     1,     0,    75,   169,     0,     0,    87,   164,     0,     0,    97,   162,     0,     0,   102,   163,     0, 
    0,    27,   182,   238,     0,    30,   173,   230,     0,    35,   168,   207,     0,    34,   171,   190,     0,    31,   176,   163,     0,    33,   177,   144,     0,    34,   178,   119, 
    0,    37,   178,    89,     0,    41,   177,    63,     0,    43,   175,    42,     0,    45,   175,    24,     0,    49,   172,     7,     0,    63,   165,     1,     0,    78,   159,     0, 
    0,    89,   154,     0,     0,    95,   152,     0,     0,    99,   156,     0,     0,    29,   170,   239,     0,    33,   161,   226,     0,    39,   157,   203,     0,    42,   157,   186, 
    0,    43,   159,   167,     0,    43,   161,   152,     0,    43,   164,   132,     0,    42,   167,   104,     0,    47,   167,    70,     0,    49,   165,    46,     0,    51,   165,    26, 
    0,    54,   163,     7,     0,    68,   155,     0,     0,    80,   149,     0,     0,    88,   145,     0,     0,    94,   142,     0,     0,    97,   147,     0,     0,    33,   153,   239, 
    0,    37,   148,   223,     0,    43,   146,   200,     0,    47,   146,   182,     0,    52,   147,   161,     0,    51,   149,   150,     0,    50,   152,   133,     0,    49,   155,   109, 
    0,    53,   157,    74,     0,    54,   155,    50,     0,    56,   155,    29,     0,    59,   153,     8,     0,    70,   146,     1,     0,    79,   139,     0,     0,    87,   135,     0, 
    0,    93,   132,     0,     0,    95,   137,     0,     0,    37,   135,   238,     0,    43,   133,   214,     0,    50,   132,   194,     0,    53,   134,   179,     0,    55,   136,   160, 
    0,    56,   138,   148,     0,    56,   139,   133,     0,    54,   142,   114,     0,    57,   145,    79,     0,    59,   144,    56,     0,    61,   143,    33,     0,    63,   142,    12, 
    0,    70,   137,     1,     0,    79,   129,     0,     0,    86,   124,     0,     0,    92,   120,     0,     0,    94,   124,     0,     0,    42,   116,   237,     0,    49,   116,   205, 
    0,    56,   118,   186,     0,    58,   121,   176,     0,    59,   123,   161,     0,    60,   125,   144,     0,    60,   123,   129,     0,    57,   127,   113,     0,    60,   131,    85, 
    0,    62,   131,    64,     0,    63,   130,    41,     0,    65,   129,    18,     0,    69,   125,     2,     0,    78,   118,     0,     0,    85,   111,     0,     0,    90,   107,     0, 
    0,    92,   109,     0,     0,    45,    95,   236,     0,    51,   100,   204,     0,    56,   103,   187,     0,    58,   105,   173,     0,    61,   106,   158,     0,    62,   107,   143, 
    0,    63,   108,   129,     0,    61,   109,   113,     0,    62,   112,    95,     0,    62,   114,    75,     0,    64,   114,    48,     0,    67,   113,    26,     0,    70,   111,     6, 
    0,    77,   105,     0,     0,    83,    98,     0,     0,    88,    93,     0,     0,    89,    92,     0,     0,    48,    77,   234,     0,    52,    84,   205,     0,    56,    86,   189, 
    0,    58,    89,   174,     0,    61,    90,   156,     0,    63,    91,   142,     0,    64,    91,   128,     0,    65,    92,   112,     0,    72,    90,    94,     0,    68,    94,    78, 
    0,    66,    96,    53,     0,    68,    96,    34,     0,    71,    94,    13,     0,    76,    90,     1,     0,    82,    85,     0,     0,    85,    80,     0,     0,    85,    77,     0, 
    0,    50,    59,   233,     0,    52,    67,   209,     0,    54,    70,   196,     0,    56,    73,   183,     0,    58,    76,   167,     0,    61,    78,   147,     0,    63,    77,   131, 
    0,    65,    78,   114,     0,    70,    77,    94,     0,    69,    76,    81,     0,    67,    79,    64,     0,    68,    79,    48,     0,    73,    76,    29,     0,    76,    75,     3, 
    0,    79,    71,     0,     0,    81,    67,     0,     0,    82,    65,     0,     0,    51,    42,   233,     0,    55,    46,   215,     0,    58,    49,   204,     0,    61,    51,   192, 
    0,    62,    55,   176,     0,    59,    61,   159,     0,    61,    63,   139,     0,    63,    64,   120,     0,    67,    64,    97,     0,    68,    63,    83,     0,    67,    63,    68, 
    0,    67,    63,    53,     0,    73,    60,    33,     0,    76,    58,     8,     0,    78,    57,     0,     0,    79,    55,     0,     0,    79,    53,     0,     0,    49,    29,   231, 
    0,    57,    32,   216,     0,    60,    34,   206,     0,    64,    35,   195,     0,    65,    37,   182,     0,    60,    43,   166,     0,    61,    45,   148,     0,    63,    47,   130, 
    0,    65,    49,   105,     0,    66,    49,    86,     0,    67,    48,    74,     0,    70,    46,    60,     0,    72,    46,    37,     0,    76,    44,    14,     0,    78,    42,     1, 
    0,    78,    41,     0,     0,    78,    38,     0,     0,    62,    19,   229,     0,    66,    21,   214,     0,    68,    21,   205,     0,    70,    22,   195,     0,    71,    24,   183, 
    0,    72,    26,   170,     0,    73,    28,   155,     0,    73,    30,   138,     0,    73,    31,   117,     0,    72,    34,    93,     0,    69,    36,    76,     0,    69,    36,    63, 
    0,    70,    35,    46,     0,    73,    34,    27,     0,    77,    32,     7,     0,    76,    32,     0,     0,    73,    32,     0,     0,    73,    11,   225,     0,    74,    12,   211, 
    0,    75,    12,   202,     0,    76,    12,   193,     0,    77,    13,   181,     0,    77,    14,   167,     0,    77,    15,   153,     0,    77,    17,   138,     0,    77,    17,   120, 
    0,    77,    18,    99,     0,    72,    22,    79,     0,    68,    24,    64,     0,    68,    25,    51,     0,    69,    24,    36,     0,    74,    22,    18,     0,    76,    20,     2, 
    0,    70,    24,     0,     0,    83,     6,   224,     0,    82,     5,   209,     0,    82,     4,   201,     0,    81,     4,   191,     0,    80,     4,   178,     0,    79,     5,   162, 
    0,    78,     5,   147,     0,    78,     6,   132,     0,    78,     6,   116,     0,    77,     6,    99,     0,    75,     7,    82,     0,    72,    10,    66,     0,    72,    12,    53, 
    0,    71,    12,    40,     0,    73,    11,    25,     0,    77,     8,     8,     0,    68,    14,     0,     0,    91,     2,   223,     0,    90,     1,   208,     0,    88,     0,   196, 
    0,    85,     0,   182,     0,    82,     0,   166,     0,    79,     0,   149,     0,    76,     0,   133,     0,    74,     0,   117,     0,    73,     0,   102,     0,    71,     0,    88, 
    0,    71,     1,    76,     0,    71,     1,    64,     0,    71,     1,    53,     0,    72,     1,    41,     0,    72,     1,    28,     0,    72,     1,    14,     0,    65,     5,     0, 
    0,   100,     0,   224,     0,    97,     0,   213,     0,    94,     0,   200,     0,    91,     0,   186,     0,    87,     0,   170,     0,    82,     0,   150,     0,    77,     0,   129, 
    0,    70,     0,   106,     0,    63,     0,    86,     0,    61,     0,    75,     0,    61,     0,    66,     0,    60,     0,    58,     0,    60,     0,    51,     0,    60,     0,    41, 
    0,    60,     0,    29,     0,    60,     0,    14,     0,    60,     0,     0,     0,    16,   196,   235,     0,    14,   199,   235,     0,    12,   202,   230,     0,    14,   199,   207, 
    0,    15,   197,   184,     0,    17,   196,   159,     0,    19,   197,   131,     0,    19,   199,   103,     0,    20,   202,    75,     0,    22,   203,    53,     0,    23,   205,    35, 
    0,    24,   205,    20,     0,    25,   205,    12,     0,    45,   196,     4,     0,    62,   188,     0,     0,    78,   182,     0,     0,    90,   176,     0,     0,    17,   190,   236, 
    0,    15,   185,   224,     0,    14,   184,   210,     0,    13,   185,   190,     0,    13,   186,   168,     0,    15,   186,   150,     0,    17,   188,   125,     0,    18,   189,    95, 
    0,    21,   189,    68,     0,    24,   187,    47,     0,    27,   187,    29,     0,    29,   185,    14,     0,    34,   183,     3,     0,    51,   176,     0,     0,    68,   170,     0, 
    0,    79,   166,     0,     0,    86,   168,     0,     0,    19,   182,   237,     0,    17,   176,   223,     0,    18,   173,   202,     0,    17,   174,   185,     0,    17,   176,   164, 
    0,    18,   176,   147,     0,    20,   178,   124,     0,    21,   180,    96,     0,    26,   178,    69,     0,    29,   176,    48,     0,    31,   176,    29,     0,    33,   174,    13, 
    0,    39,   172,     2,     0,    55,   164,     0,     0,    70,   158,     0,     0,    78,   156,     0,     0,    83,   160,     0,     0,    20,   170,   238,     0,    19,   164,   222, 
    0,    22,   161,   202,     0,    25,   158,   188,     0,    27,   158,   169,     0,    26,   161,   152,     0,    25,   165,   128,     0,    26,   169,   101,     0,    31,   167,    72, 
    0,    34,   166,    50,     0,    35,   166,    28,     0,    38,   164,    10,     0,    45,   160,     1,     0,    60,   153,     0,     0,    70,   148,     0,     0,    77,   146,     0, 
    0,    81,   151,     0,     0,    22,   154,   239,     0,    22,   151,   224,     0,    26,   149,   203,     0,    31,   148,   186,     0,    36,   146,   163,     0,    33,   148,   150, 
    0,    30,   154,   129,     0,    31,   156,   106,     0,    35,   156,    76,     0,    38,   155,    54,     0,    40,   154,    32,     0,    42,   154,    12,     0,    48,   150,     1, 
    0,    59,   143,     0,     0,    69,   138,     0,     0,    76,   135,     0,     0,    78,   140,     0,     0,    26,   137,   236,     0,    28,   134,   217,     0,    32,   134,   197, 
    0,    37,   136,   181,     0,    40,   135,   161,     0,    39,   136,   147,     0,    38,   138,   133,     0,    37,   141,   116,     0,    39,   145,    84,     0,    42,   144,    60, 
    0,    43,   142,    38,     0,    45,   142,    18,     0,    48,   140,     2,     0,    58,   133,     0,     0,    68,   127,     0,     0,    76,   123,     0,     0,    77,   128,     0, 
    0,    29,   119,   235,     0,    35,   118,   205,     0,    42,   119,   185,     0,    42,   120,   175,     0,    43,   123,   161,     0,    44,   124,   143,     0,    45,   122,   130, 
    0,    42,   127,   115,     0,    42,   131,    90,     0,    45,   131,    67,     0,    46,   130,    44,     0,    47,   129,    24,     0,    49,   128,     5,     0,    58,   122,     0, 
    0,    68,   114,     0,     0,    74,   110,     0,     0,    75,   113,     0,     0,    33,    98,   234,     0,    39,   103,   201,     0,    44,   103,   180,     0,    45,   105,   171, 
    0,    46,   107,   158,     0,    48,   107,   143,     0,    49,   109,   130,     0,    46,   110,   114,     0,    45,   113,    98,     0,    45,   115,    78,     0,    47,   115,    51, 
    0,    48,   114,    29,     0,    50,   114,     9,     0,    57,   109,     1,     0,    67,   101,     0,     0,    73,    95,     0,     0,    73,    96,     0,     0,    35,    81,   233, 
    0,    40,    87,   198,     0,    46,    88,   175,     0,    46,    90,   167,     0,    47,    92,   155,     0,    48,    92,   142,     0,    50,    93,   128,     0,    50,    94,   113, 
    0,    50,    94,    97,     0,    49,    97,    80,     0,    49,    98,    56,     0,    50,    98,    36,     0,    52,    98,    16,     0,    57,    95,     1,     0,    66,    88,     0, 
    0,    71,    83,     0,     0,    70,    81,     0,     0,    38,    64,   229,     0,    40,    72,   202,     0,    43,    75,   188,     0,    44,    76,   177,     0,    45,    78,   164, 
    0,    47,    79,   145,     0,    50,    80,   128,     0,    51,    80,   114,     0,    52,    80,    96,     0,    57,    77,    82,     0,    54,    80,    67,     0,    53,    81,    52, 
    0,    57,    80,    31,     0,    58,    80,     5,     0,    64,    75,     0,     0,    69,    70,     0,     0,    68,    68,     0,     0,    40,    47,   228,     0,    43,    52,   211, 
    0,    45,    54,   201,     0,    46,    57,   190,     0,    46,    60,   175,     0,    45,    65,   153,     0,    49,    67,   128,     0,    51,    67,   112,     0,    53,    67,    96, 
    0,    56,    64,    81,     0,    57,    63,    70,     0,    55,    65,    56,     0,    59,    63,    40,     0,    59,    63,    18,     0,    63,    61,     2,     0,    66,    57,     0, 
    0,    65,    56,     0,     0,    39,    32,   228,     0,    44,    36,   211,     0,    47,    37,   202,     0,    48,    38,   192,     0,    49,    42,   179,     0,    44,    49,   162, 
    0,    46,    51,   142,     0,    48,    52,   125,     0,    50,    52,   104,     0,    53,    52,    84,     0,    54,    50,    71,     0,    54,    50,    55,     0,    56,    50,    40, 
    0,    58,    48,    21,     0,    61,    46,     3,     0,    63,    44,     0,     0,    63,    43,     0,     0,    39,    22,   227,     0,    45,    24,   212,     0,    48,    24,   204, 
    0,    50,    24,   195,     0,    52,    26,   183,     0,    52,    28,   168,     0,    53,    30,   152,     0,    53,    32,   135,     0,    53,    34,   115,     0,    55,    35,    92, 
    0,    55,    35,    75,     0,    54,    35,    61,     0,    55,    34,    48,     0,    57,    34,    24,     0,    61,    33,     4,     0,    62,    31,     0,     0,    63,    29,     0, 
    0,    52,    13,   225,     0,    54,    14,   212,     0,    56,    13,   204,     0,    58,    13,   195,     0,    59,    14,   184,     0,    59,    16,   169,     0,    59,    17,   154, 
    0,    59,    19,   139,     0,    59,    20,   121,     0,    60,    21,   100,     0,    58,    23,    79,     0,    55,    25,    63,     0,    54,    25,    49,     0,    56,    25,    33, 
    0,    59,    23,    15,     0,    61,    22,     2,     0,    58,    22,     0,     0,    63,     7,   223,     0,    64,     6,   209,     0,    65,     5,   201,     0,    65,     5,   192, 
    0,    64,     6,   180,     0,    64,     7,   165,     0,    63,     7,   149,     0,    63,     8,   135,     0,    64,     8,   119,     0,    64,     8,   100,     0,    62,     9,    83, 
    0,    58,    13,    66,     0,    55,    15,    50,     0,    55,    15,    38,     0,    56,    14,    25,     0,    59,    12,     9,     0,    56,    14,     0,     0,    73,     3,   222, 
    0,    73,     1,   209,     0,    71,     1,   199,     0,    70,     0,   188,     0,    68,     0,   174,     0,    66,     1,   158,     0,    65,     1,   140,     0,    63,     1,   123, 
    0,    62,     1,   107,     0,    61,     1,    93,     0,    61,     1,    80,     0,    60,     1,    66,     0,    58,     4,    52,     0,    58,     4,    40,     0,    57,     4,    28, 
    0,    58,     4,    14,     0,    54,     6,     0,     0,    82,     0,   222,     0,    80,     0,   213,     0,    78,     0,   202,     0,    76,     0,   190,     0,    73,     0,   175, 
    0,    70,     0,   156,     0,    66,     0,   134,     0,    60,     0,   110,     0,    53,     0,    88,     0,    52,     0,    77,     0,    51,     0,    67,     0,    51,     0,    59, 
    0,    50,     0,    51,     0,    50,     0,    41,     0,    51,     0,    30,     0,    51,     0,    16,     0,    50,     0,     0,     0,    10,   194,   235,     0,     8,   196,   234, 
    0,     6,   200,   230,     0,     6,   198,   210,     0,     7,   196,   187,     0,     9,   196,   164,     0,    10,   197,   138,     0,    12,   199,   114,     0,    13,   201,    87, 
    0,    14,   203,    61,     0,    15,   205,    41,     0,    16,   206,    26,     0,    17,   207,    13,     0,    17,   207,     6,     0,    38,   198,     2,     0,    56,   189,     0, 
    0,    71,   182,     0,     0,    11,   189,   236,     0,     7,   184,   222,     0,     6,   183,   209,     0,     5,   184,   190,     0,     4,   185,   169,     0,     6,   185,   152, 
    0,     8,   186,   130,     0,     8,   190,   105,     0,    11,   190,    77,     0,    13,   189,    53,     0,    16,   188,    36,     0,    18,   188,    20,     0,    20,   187,     8, 
    0,    26,   184,     2,     0,    42,   177,     0,     0,    59,   172,     0,     0,    68,   174,     0,     0,    12,   181,   237,     0,     9,   175,   221,     0,     8,   172,   201, 
    0,     8,   173,   185,     0,     7,   174,   165,     0,     8,   175,   149,     0,    10,   176,   130,     0,     9,   182,   106,     0,    12,   181,    77,     0,    16,   178,    53, 
    0,    19,   177,    35,     0,    21,   176,    17,     0,    23,   175,     4,     0,    33,   170,     0,     0,    47,   164,     0,     0,    59,   161,     0,     0,    65,   166,     0, 
    0,    13,   169,   238,     0,    11,   164,   221,     0,    11,   161,   202,     0,    13,   159,   189,     0,    13,   159,   171,     0,    13,   161,   154,     0,    13,   165,   130, 
    0,    12,   170,   107,     0,    15,   169,    79,     0,    19,   167,    55,     0,    21,   166,    34,     0,    23,   166,    14,     0,    27,   163,     2,     0,    38,   158,     0, 
    0,    48,   153,     0,     0,    58,   150,     0,     0,    63,   156,     0,     0,    14,   155,   239,     0,    13,   152,   223,     0,    14,   150,   203,     0,    16,   147,   189, 
    0,    18,   147,   169,     0,    16,   149,   153,     0,    15,   154,   130,     0,    16,   156,   110,     0,    18,   156,    83,     0,    22,   155,    59,     0,    24,   154,    38, 
    0,    25,   154,    17,     0,    28,   153,     3,     0,    37,   147,     0,     0,    47,   142,     0,     0,    58,   139,     0,     0,    61,   145,     0,     0,    17,   138,   236, 
    0,    17,   135,   221,     0,    19,   135,   202,     0,    20,   135,   186,     0,    21,   137,   168,     0,    22,   138,   151,     0,    23,   138,   134,     0,    21,   140,   118, 
    0,    22,   144,    89,     0,    25,   144,    64,     0,    27,   142,    44,     0,    28,   142,    24,     0,    29,   141,     7,     0,    37,   136,     1,     0,    47,   130,     0, 
    0,    57,   126,     0,     0,    58,   132,     0,     0,    19,   121,   232,     0,    22,   119,   211,     0,    23,   120,   195,     0,    24,   122,   182,     0,    25,   124,   167, 
    0,    28,   125,   147,     0,    31,   122,   130,     0,    27,   126,   116,     0,    26,   131,    93,     0,    28,   131,    70,     0,    29,   130,    49,     0,    30,   129,    29, 
    0,    31,   129,    11,     0,    37,   126,     1,     0,    48,   118,     0,     0,    57,   112,     0,     0,    57,   117,     0,     0,    22,   101,   231,     0,    25,   104,   203, 
    0,    29,   106,   186,     0,    29,   107,   176,     0,    30,   109,   162,     0,    31,   110,   146,     0,    35,   111,   131,     0,    33,   110,   115,     0,    31,   113,    99, 
    0,    30,   115,    82,     0,    31,   116,    55,     0,    31,   115,    33,     0,    32,   115,    14,     0,    37,   113,     1,     0,    48,   105,     0,     0,    56,    98,     0, 
    0,    54,   100,     0,     0,    24,    84,   231,     0,    28,    89,   197,     0,    33,    90,   175,     0,    34,    91,   167,     0,    34,    93,   157,     0,    34,    94,   143, 
    0,    36,    95,   129,     0,    36,    95,   113,     0,    37,    95,    97,     0,    33,    98,    83,     0,    33,   100,    59,     0,    33,   100,    39,     0,    34,   100,    19, 
    0,    37,    99,     2,     0,    48,    92,     0,     0,    55,    86,     0,     0,    52,    85,     0,     0,    26,    68,   227,     0,    28,    74,   202,     0,    30,    77,   187, 
    0,    31,    79,   173,     0,    34,    79,   160,     0,    35,    81,   145,     0,    37,    82,   128,     0,    38,    82,   113,     0,    38,    81,    96,     0,    37,    82,    84, 
    0,    36,    83,    67,     0,    34,    85,    51,     0,    37,    85,    26,     0,    39,    84,     6,     0,    47,    79,     0,     0,    53,    73,     0,     0,    51,    73,     0, 
    0,    29,    52,   224,     0,    31,    56,   210,     0,    31,    59,   200,     0,    30,    64,   182,     0,    33,    66,   165,     0,    35,    66,   146,     0,    36,    68,   128, 
    0,    38,    69,   112,     0,    40,    69,    96,     0,    40,    68,    82,     0,    45,    65,    69,     0,    41,    68,    55,     0,    42,    68,    37,     0,    42,    67,    20, 
    0,    46,    65,     3,     0,    52,    61,     0,     0,    49,    60,     0,     0,    30,    37,   223,     0,    32,    40,   210,     0,    33,    41,   202,     0,    30,    46,   189, 
    0,    31,    50,   174,     0,    32,    52,   157,     0,    34,    54,   138,     0,    34,    56,   120,     0,    38,    55,    98,     0,    40,    56,    84,     0,    43,    53,    70, 
    0,    42,    53,    57,     0,    40,    54,    43,     0,    40,    54,    29,     0,    45,    51,     9,     0,    50,    47,     1,     0,    48,    47,     0,     0,    30,    23,   223, 
    0,    32,    26,   209,     0,    34,    26,   201,     0,    35,    27,   192,     0,    36,    29,   180,     0,    37,    32,   166,     0,    37,    35,   148,     0,    34,    40,   130, 
    0,    35,    41,   109,     0,    38,    41,    91,     0,    41,    39,    72,     0,    40,    39,    58,     0,    39,    39,    42,     0,    40,    39,    28,     0,    45,    35,    11, 
    0,    48,    34,     1,     0,    46,    33,     0,     0,    29,    15,   223,     0,    34,    16,   210,     0,    37,    15,   203,     0,    39,    15,   195,     0,    39,    16,   184, 
    0,    39,    18,   170,     0,    39,    20,   154,     0,    34,    24,   138,     0,    35,    25,   119,     0,    38,    24,   100,     0,    40,    24,    79,     0,    40,    25,    62, 
    0,    40,    25,    48,     0,    41,    24,    36,     0,    44,    23,    14,     0,    46,    23,     2,     0,    47,    20,     0,     0,    41,     8,   222,     0,    43,     8,   210, 
    0,    45,     6,   203,     0,    45,     6,   196,     0,    45,     7,   185,     0,    45,     8,   171,     0,    45,     9,   154,     0,    45,    10,   139,     0,    45,    10,   122, 
    0,    46,    11,   103,     0,    47,    11,    84,     0,    45,    13,    65,     0,    42,    15,    50,     0,    42,    16,    37,     0,    44,    15,    22,     0,    46,    14,     7, 
    0,    44,    14,     0,     0,    52,     3,   220,     0,    53,     2,   209,     0,    53,     1,   201,     0,    52,     1,   192,     0,    51,     1,   181,     0,    50,     1,   166, 
    0,    49,     1,   148,     0,    48,     1,   131,     0,    48,     1,   113,     0,    48,     1,    97,     0,    49,     1,    83,     0,    49,     2,    69,     0,    45,     5,    53, 
    0,    45,     5,    39,     0,    46,     5,    27,     0,    46,     5,    13,     0,    43,     6,     0,     0,    63,     0,   220,     0,    61,     0,   212,     0,    60,     0,   203, 
    0,    59,     0,   192,     0,    57,     0,   179,     0,    55,     0,   161,     0,    52,     0,   139,     0,    47,     0,   114,     0,    42,     0,    91,     0,    42,     0,    79, 
    0,    41,     0,    69,     0,    41,     0,    60,     0,    40,     0,    52,     0,    40,     0,    43,     0,    41,     0,    31,     0,    41,     0,    17,     0,    40,     0,     0, 
    0,     6,   192,   235,     0,     4,   194,   233,     0,     3,   195,   226,     0,     3,   195,   209,     0,     4,   194,   189,     0,     4,   195,   168,     0,     4,   197,   145, 
    0,     6,   198,   122,     0,     7,   200,    96,     0,     8,   202,    70,     0,     9,   204,    49,     0,    10,   206,    32,     0,    10,   207,    17,     0,    10,   209,     7, 
    0,    11,   209,     3,     0,    31,   199,     0,     0,    49,   190,     0,     0,     6,   187,   235,     0,     2,   181,   222,     0,     1,   181,   208,     0,     1,   181,   190, 
    0,     1,   183,   170,     0,     1,   184,   154,     0,     1,   185,   134,     0,     2,   190,   111,     0,     3,   190,    87,     0,     6,   190,    61,     0,     8,   189,    42, 
    0,     9,   189,    26,     0,    11,   189,    13,     0,    13,   188,     4,     0,    19,   185,     1,     0,    35,   180,     0,     0,    45,   182,     0,     0,     6,   180,   236, 
    0,     4,   173,   220,     0,     2,   170,   199,     0,     2,   171,   184,     0,     1,   173,   166,     0,     1,   174,   149,     0,     2,   175,   132,     0,     2,   181,   111, 
    0,     3,   182,    86,     0,     6,   180,    60,     0,     9,   178,    40,     0,    11,   177,    23,     0,    12,   177,     8,     0,    17,   174,     1,     0,    26,   170,     0, 
    0,    35,   168,     0,     0,    42,   173,     0,     0,     7,   169,   237,     0,     5,   163,   220,     0,     4,   161,   200,     0,     3,   160,   182,     0,     3,   161,   164, 
    0,     3,   163,   148,     0,     3,   164,   131,     0,     3,   168,   112,     0,     4,   171,    89,     0,     7,   169,    63,     0,     9,   167,    41,     0,    10,   166,    22, 
    0,    12,   166,     7,     0,    17,   163,     1,     0,    26,   158,     0,     0,    36,   156,     0,     0,    40,   162,     0,     0,     8,   155,   237,     0,     6,   152,   222, 
    0,     6,   151,   202,     0,     5,   151,   185,     0,     4,   151,   164,     0,     4,   152,   147,     0,     5,   154,   130,     0,     5,   155,   113,     0,     5,   158,    91, 
    0,     8,   156,    66,     0,    10,   154,    45,     0,    11,   154,    25,     0,    12,   154,     8,     0,    16,   152,     1,     0,    26,   146,     0,     0,    36,   144,     0, 
    0,    39,   150,     0,     0,     9,   139,   235,     0,     8,   138,   222,     0,     8,   138,   203,     0,     8,   139,   187,     0,     7,   139,   168,     0,     8,   138,   153, 
    0,     9,   137,   136,     0,     8,   140,   120,     0,     8,   143,    94,     0,    10,   143,    70,     0,    12,   142,    49,     0,    12,   142,    29,     0,    13,   142,    10, 
    0,    17,   140,     1,     0,    28,   134,     0,     0,    37,   130,     0,     0,    37,   137,     0,     0,    12,   121,   231,     0,    11,   121,   217,     0,    11,   123,   202, 
    0,    10,   125,   187,     0,    10,   127,   170,     0,    13,   126,   152,     0,    17,   122,   131,     0,    13,   125,   117,     0,    11,   130,    95,     0,    12,   130,    76, 
    0,    13,   130,    54,     0,    14,   130,    34,     0,    15,   130,    14,     0,    18,   128,     1,     0,    29,   121,     0,     0,    38,   116,     0,     0,    36,   122,     0, 
    0,    14,   103,   228,     0,    14,   105,   206,     0,    15,   106,   191,     0,    15,   108,   180,     0,    15,   111,   167,     0,    18,   113,   148,     0,    21,   111,   132, 
    0,    19,   110,   115,     0,    17,   113,   100,     0,    15,   115,    85,     0,    15,   116,    60,     0,    16,   116,    39,     0,    16,   117,    18,     0,    18,   115,     2, 
    0,    30,   108,     0,     0,    38,   102,     0,     0,    35,   105,     0,     0,    15,    86,   227,     0,    17,    90,   198,     0,    20,    92,   176,     0,    21,    93,   168, 
    0,    21,    94,   159,     0,    21,    95,   146,     0,    22,    96,   131,     0,    23,    97,   115,     0,    23,    95,    97,     0,    19,    99,    85,     0,    17,   101,    64, 
    0,    17,   102,    44,     0,    18,   102,    23,     0,    20,   101,     5,     0,    30,    95,     0,     0,    38,    89,     0,     0,    34,    88,     0,     0,    16,    71,   225, 
    0,    17,    76,   202,     0,    19,    79,   187,     0,    20,    81,   170,     0,    23,    81,   155,     0,    23,    82,   144,     0,    24,    82,   129,     0,    25,    83,   113, 
    0,    25,    83,    97,     0,    23,    83,    84,     0,    21,    85,    70,     0,    19,    87,    53,     0,    20,    88,    28,     0,    21,    87,     8,     0,    29,    82,     1, 
    0,    38,    76,     0,     0,    33,    76,     0,     0,    17,    56,   222,     0,    19,    59,   210,     0,    20,    61,   200,     0,    20,    67,   176,     0,    24,    68,   151, 
    0,    24,    69,   141,     0,    24,    70,   129,     0,    26,    71,   112,     0,    27,    71,    96,     0,    27,    70,    83,     0,    26,    69,    70,     0,    23,    72,    54, 
    0,    22,    73,    34,     0,    23,    73,    14,     0,    29,    69,     2,     0,    37,    64,     0,     0,    33,    65,     0,     0,    19,    41,   220,     0,    21,    43,   210, 
    0,    21,    45,   202,     0,    19,    51,   185,     0,    20,    54,   166,     0,    21,    56,   151,     0,    22,    57,   136,     0,    23,    58,   117,     0,    26,    57,    96, 
    0,    28,    58,    83,     0,    28,    57,    69,     0,    31,    54,    56,     0,    27,    56,    42,     0,    26,    57,    28,     0,    30,    55,    10,     0,    35,    51,     1, 
    0,    32,    52,     0,     0,    19,    28,   220,     0,    21,    29,   210,     0,    22,    30,   203,     0,    22,    32,   193,     0,    23,    34,   180,     0,    23,    38,   166, 
    0,    23,    40,   147,     0,    22,    43,   124,     0,    25,    44,    98,     0,    27,    43,    84,     0,    28,    44,    71,     0,    30,    41,    55,     0,    29,    41,    45, 
    0,    28,    42,    31,     0,    32,    40,    17,     0,    32,    39,     2,     0,    31,    39,     0,     0,    20,    17,   219,     0,    22,    17,   207,     0,    23,    17,   200, 
    0,    24,    18,   191,     0,    24,    20,   180,     0,    24,    22,   167,     0,    24,    24,   151,     0,    20,    29,   133,     0,    23,    30,   112,     0,    24,    30,    95, 
    0,    26,    29,    78,     0,    28,    28,    59,     0,    29,    27,    44,     0,    28,    28,    30,     0,    30,    27,    17,     0,    31,    26,     2,     0,    31,    25,     0, 
    0,    19,    10,   219,     0,    23,     9,   209,     0,    25,     8,   202,     0,    26,     8,   194,     0,    26,     8,   184,     0,    26,     9,   171,     0,    26,    11,   155, 
    0,    27,    12,   139,     0,    27,    12,   122,     0,    27,    13,   104,     0,    28,    13,    86,     0,    29,    14,    64,     0,    28,    15,    47,     0,    28,    15,    35, 
    0,    27,    15,    24,     0,    31,    14,     2,     0,    32,    13,     0,     0,    31,     4,   219,     0,    32,     3,   210,     0,    32,     2,   203,     0,    32,     1,   196, 
    0,    32,     1,   186,     0,    31,     2,   172,     0,    31,     2,   155,     0,    31,     3,   137,     0,    30,     3,   119,     0,    30,     4,   103,     0,    32,     4,    87, 
    0,    33,     4,    70,     0,    31,     6,    53,     0,    31,     6,    39,     0,    34,     6,    25,     0,    33,     6,     9,     0,    31,     7,     0,     0,    42,     0,   218, 
    0,    41,     0,   211,     0,    40,     0,   203,     0,    39,     0,   194,     0,    39,     0,   182,     0,    37,     0,   166,     0,    36,     0,   146,     0,    33,     0,   122, 
    0,    30,     0,    99,     0,    30,     0,    85,     0,    30,     0,    74,     0,    30,     0,    63,     0,    29,     0,    54,     0,    29,     0,    45,     0,    30,     0,    35, 
    0,    30,     0,    19,     0,    30,     0,     0,     0,     3,   190,   235,     0,     2,   191,   232,     0,     1,   192,   223,     0,     1,   191,   208,     0,     2,   191,   190, 
    0,     2,   193,   172,     0,     2,   194,   151,     0,     2,   196,   130,     0,     2,   198,   107,     0,     4,   200,    81,     0,     4,   203,    58,     0,     4,   205,    39, 
    0,     5,   207,    23,     0,     5,   208,    11,     0,     5,   210,     3,     0,     5,   210,     1,     0,    25,   199,     0,     0,     2,   185,   235,     0,     0,   179,   219, 
    0,     0,   178,   206,     0,     0,   178,   190,     0,     0,   180,   173,     0,     0,   181,   156,     0,     0,   183,   140,     0,     0,   187,   118,     0,     0,   189,    96, 
    0,     1,   190,    71,     0,     2,   190,    50,     0,     3,   191,    33,     0,     4,   191,    18,     0,     5,   192,     8,     0,     7,   191,     2,     0,    14,   188,     1, 
    0,    20,   190,     0,     0,     2,   178,   235,     0,     1,   172,   218,     0,     0,   167,   196,     0,     0,   168,   182,     0,     0,   169,   165,     0,     0,   171,   151, 
    0,     0,   172,   135,     0,     0,   177,   115,     0,     0,   180,    95,     0,     1,   180,    72,     0,     1,   180,    50,     0,     3,   179,    33,     0,     3,   179,    18, 
    0,     4,   179,     7,     0,     7,   178,     2,     0,    14,   174,     1,     0,    17,   180,     0,     0,     3,   168,   235,     0,     1,   163,   219,     0,     0,   160,   197, 
    0,     0,   159,   177,     0,     0,   159,   161,     0,     0,   161,   147,     0,     0,   162,   131,     0,     0,   165,   115,     0,     0,   169,    97,     0,     1,   169,    74, 
    0,     1,   168,    51,     0,     1,   168,    32,     0,     2,   167,    17,     0,     3,   167,     6,     0,     7,   165,     2,     0,    16,   161,     1,     0,    15,   170,     0, 
    0,     3,   155,   234,     0,     2,   153,   220,     0,     1,   151,   200,     0,     0,   150,   181,     0,     0,   150,   160,     0,     0,   150,   145,     0,     0,   152,   130, 
    0,     0,   153,   115,     0,     0,   156,    97,     0,     1,   157,    76,     0,     1,   156,    54,     0,     1,   155,    33,     0,     1,   155,    16,     0,     2,   155,     4, 
    0,     8,   152,     2,     0,    17,   148,     1,     0,    13,   157,     0,     0,     4,   140,   232,     0,     3,   139,   220,     0,     2,   139,   202,     0,     1,   139,   186, 
    0,     0,   139,   165,     0,     1,   137,   151,     0,     1,   138,   136,     0,     1,   139,   121,     0,     1,   142,    98,     0,     1,   142,    79,     0,     1,   142,    58, 
    0,     1,   142,    37,     0,     1,   143,    16,     0,     3,   144,     3,     0,    10,   139,     1,     0,    19,   135,     1,     0,    13,   144,     0,     0,     5,   123,   229, 
    0,     4,   123,   218,     0,     3,   125,   203,     0,     2,   126,   188,     0,     1,   127,   170,     0,     2,   126,   153,     0,     2,   126,   134,     0,     1,   126,   118, 
    0,     1,   128,    97,     0,     1,   129,    82,     0,     1,   129,    62,     0,     1,   130,    41,     0,     2,   130,    20,     0,     4,   131,     3,     0,    12,   125,     1, 
    0,    21,   120,     1,     0,    13,   128,     0,     0,     6,   105,   227,     0,     5,   106,   210,     0,     5,   107,   197,     0,     5,   110,   185,     0,     4,   112,   170, 
    0,     4,   113,   153,     0,     5,   114,   135,     0,     4,   112,   117,     0,     4,   112,   100,     0,     3,   113,    88,     0,     2,   115,    66,     0,     2,   116,    46, 
    0,     3,   115,    24,     0,     5,   116,     6,     0,    13,   110,     1,     0,    21,   104,     1,     0,    14,   110,     0,     0,     7,    88,   225,     0,     7,    91,   204, 
    0,     7,    93,   190,     0,     7,    95,   178,     0,     7,    97,   166,     0,     7,    98,   152,     0,     7,    99,   135,     0,     8,    99,   117,     0,    10,    95,    97, 
    0,     6,    99,    85,     0,     4,   101,    67,     0,     4,   102,    50,     0,     4,   102,    29,     0,     6,   102,     9,     0,    14,    97,     2,     0,    22,    91,     1, 
    0,    15,    92,     0,     0,     8,    73,   224,     0,     7,    78,   206,     0,     8,    79,   194,     0,     8,    82,   179,     0,     8,    85,   164,     0,     9,    85,   150, 
    0,    10,    85,   134,     0,    11,    86,   116,     0,    13,    84,    97,     0,    10,    84,    84,     0,     8,    86,    71,     0,     6,    88,    57,     0,     6,    89,    34, 
    0,     7,    88,    13,     0,    13,    84,     2,     0,    21,    79,     1,     0,    15,    80,     0,     0,     8,    58,   221,     0,     9,    62,   211,     0,     9,    64,   201, 
    0,     8,    69,   182,     0,     9,    72,   162,     0,    11,    71,   145,     0,    12,    71,   129,     0,    14,    71,   112,     0,    15,    72,    97,     0,    15,    71,    82, 
    0,    14,    70,    70,     0,    10,    74,    56,     0,     8,    76,    36,     0,     8,    76,    17,     0,    12,    73,     3,     0,    21,    67,     1,     0,    16,    68,     0, 
    0,     9,    44,   219,     0,    11,    46,   211,     0,    11,    48,   202,     0,     8,    53,   187,     0,     8,    58,   169,     0,     9,    59,   151,     0,    11,    60,   135, 
    0,    11,    60,   117,     0,    16,    59,    97,     0,    16,    60,    83,     0,    16,    58,    70,     0,    13,    59,    56,     0,    12,    61,    41,     0,     9,    62,    27, 
    0,    12,    60,     6,     0,    20,    55,     1,     0,    16,    55,     0,     0,     9,    31,   218,     0,    11,    31,   210,     0,    12,    33,   203,     0,    11,    36,   193, 
    0,    12,    39,   181,     0,    12,    42,   164,     0,    12,    44,   145,     0,    11,    47,   121,     0,    15,    46,    98,     0,    16,    45,    83,     0,    18,    46,    71, 
    0,    18,    44,    55,     0,    20,    42,    41,     0,    16,    44,    30,     0,    16,    45,    14,     0,    17,    44,     2,     0,    15,    44,     0,     0,     9,    19,   217, 
    0,    11,    19,   209,     0,    12,    20,   202,     0,    11,    22,   194,     0,    11,    24,   183,     0,    12,    26,   169,     0,    12,    29,   151,     0,     9,    33,   130, 
    0,    12,    33,   107,     0,    13,    33,    88,     0,    16,    33,    73,     0,    17,    32,    58,     0,    20,    30,    42,     0,    16,    31,    30,     0,    13,    34,    18, 
    0,    13,    34,     4,     0,    15,    32,     0,     0,     9,    11,   217,     0,    12,    10,   206,     0,    12,    10,   197,     0,    12,    11,   189,     0,    12,    12,   178, 
    0,    12,    14,   166,     0,    12,    15,   151,     0,    12,    16,   137,     0,    13,    17,   119,     0,    11,    21,    99,     0,    13,    20,    81,     0,    14,    19,    63, 
    0,    15,    19,    44,     0,    16,    18,    31,     0,    14,    21,    13,     0,    13,    21,     2,     0,    15,    19,     0,     0,     9,     5,   217,     0,    13,     3,   208, 
    0,    13,     3,   200,     0,    13,     3,   192,     0,    13,     3,   183,     0,    13,     4,   170,     0,    13,     4,   156,     0,    14,     4,   141,     0,    13,     5,   124, 
    0,     9,     9,   106,     0,    11,     8,    88,     0,    13,     7,    71,     0,    14,     7,    50,     0,    14,     7,    37,     0,    17,     5,    25,     0,    13,     7,    12, 
    0,    16,     6,     0,     0,    21,     0,   217,     0,    20,     0,   211,     0,    18,     0,   204,     0,    18,     0,   197,     0,    17,     0,   187,     0,    17,     0,   174, 
    0,    16,     0,   158,     0,    15,     0,   139,     0,    14,     0,   117,     0,    15,     0,    98,     0,    16,     0,    84,     0,    16,     0,    70,     0,    16,     0,    55, 
    0,    16,     0,    44,     0,    17,     0,    33,     0,    15,     0,    17,     0,    15,     0,     0,     0,     0,   189,   235,     0,     0,   189,   229,     0,     0,   188,   219, 
    0,     0,   188,   206,     0,     0,   188,   190,     0,     0,   190,   174,     0,     0,   191,   157,     0,     0,   193,   138,     0,     0,   195,   116,     0,     0,   198,    92, 
    0,     0,   201,    68,     0,     0,   203,    48,     0,     0,   205,    31,     0,     0,   207,    17,     0,     0,   209,     7,     0,     0,   210,     1,     0,     0,   210,     0, 
    0,     0,   183,   234,     0,     0,   179,   211,     0,     0,   178,   201,     0,     0,   179,   190,     0,     0,   180,   178,     0,     0,   181,   164,     0,     0,   182,   150, 
    0,     0,   185,   131,     0,     0,   189,   112,     0,     0,   190,    88,     0,     0,   192,    65,     0,     0,   193,    48,     0,     0,   195,    34,     0,     0,   196,    21, 
    0,     0,   197,    14,     0,     0,   198,     9,     0,     0,   199,     0,     0,     0,   176,   233,     0,     0,   173,   212,     0,     0,   169,   191,     0,     0,   169,   180, 
    0,     0,   171,   167,     0,     0,   172,   156,     0,     0,   173,   143,     0,     0,   176,   127,     0,     0,   181,   108,     0,     0,   182,    86,     0,     0,   183,    64, 
    0,     0,   184,    49,     0,     0,   184,    36,     0,     0,   185,    25,     0,     0,   186,    19,     0,     0,   186,    14,     0,     0,   187,     0,     0,     0,   166,   232, 
    0,     0,   164,   213,     0,     0,   162,   193,     0,     0,   160,   173,     0,     0,   161,   160,     0,     0,   162,   149,     0,     0,   163,   138,     0,     0,   165,   123, 
    0,     0,   170,   106,     0,     0,   172,    87,     0,     0,   172,    67,     0,     0,   172,    50,     0,     0,   172,    36,     0,     0,   173,    26,     0,     0,   173,    20, 
    0,     0,   173,    15,     0,     0,   174,     0,     0,     0,   155,   231,     0,     0,   154,   213,     0,     0,   153,   195,     0,     0,   152,   177,     0,     0,   151,   156, 
    0,     0,   152,   144,     0,     0,   153,   132,     0,     0,   154,   119,     0,     0,   157,   106,     0,     0,   159,    90,     0,     0,   159,    71,     0,     0,   159,    52, 
    0,     0,   159,    35,     0,     0,   159,    25,     0,     0,   159,    19,     0,     0,   159,    15,     0,     0,   160,     0,     0,     0,   140,   229,     0,     0,   142,   214, 
    0,     0,   142,   198,     0,     0,   142,   182,     0,     0,   141,   162,     0,     0,   140,   140,     0,     0,   141,   128,     0,     0,   141,   117,     0,     0,   142,   105, 
    0,     0,   143,    92,     0,     0,   144,    75,     0,     0,   143,    56,     0,     0,   144,    37,     0,     0,   145,    24,     0,     0,   145,    17,     0,     0,   145,    14, 
    0,     0,   147,     0,     0,     0,   124,   227,     0,     0,   126,   215,     0,     0,   128,   201,     0,     0,   129,   186,     0,     0,   130,   167,     0,     0,   129,   147, 
    0,     0,   127,   125,     0,     0,   127,   113,     0,     0,   127,   102,     0,     0,   128,    92,     0,     0,   128,    77,     0,     0,   129,    60,     0,     0,   130,    41, 
    0,     0,   130,    25,     0,     0,   130,    16,     0,     0,   130,    12,     0,     0,   131,     0,     0,     0,   106,   225,     0,     0,   109,   215,     0,     0,   111,   202, 
    0,     0,   114,   189,     0,     0,   116,   170,     0,     0,   117,   152,     0,     0,   116,   130,     0,     0,   112,   111,     0,     0,   112,   100,     0,     0,   112,    90, 
    0,     0,   112,    77,     0,     0,   113,    61,     0,     0,   113,    44,     0,     0,   113,    27,     0,     0,   113,    15,     0,     0,   112,     9,     0,     0,   113,     0, 
    0,     0,    90,   223,     0,     0,    93,   213,     0,     0,    95,   202,     0,     0,    98,   190,     0,     0,   102,   172,     0,     0,   103,   155,     0,     0,   103,   135, 
    0,     0,   100,   115,     0,     0,    96,    94,     0,     0,    96,    85,     0,     0,    97,    74,     0,     0,    97,    61,     0,     0,    97,    46,     0,     0,    97,    29, 
    0,     0,    96,    16,     0,     0,    95,     8,     0,     0,    96,     0,     0,     0,    76,   222,     0,     0,    79,   212,     0,     0,    80,   202,     0,     0,    85,   189, 
    0,     0,    89,   170,     0,     0,    89,   152,     0,     0,    87,   131,     0,     0,    84,   112,     0,     0,    85,    94,     0,     0,    85,    81,     0,     0,    84,    72, 
    0,     0,    85,    62,     0,     0,    86,    46,     0,     0,    86,    31,     0,     0,    85,    17,     0,     0,    84,     8,     0,     0,    83,     0,     0,     0,    61,   220, 
    0,     0,    64,   211,     0,     0,    66,   202,     0,     0,    71,   190,     0,     0,    75,   170,     0,     0,    76,   147,     0,     0,    70,   118,     0,     0,    69,   103, 
    0,     0,    72,    94,     0,     0,    70,    78,     0,     0,    69,    65,     0,     0,    73,    59,     0,     0,    75,    46,     0,     0,    75,    32,     0,     0,    74,    18, 
    0,     0,    72,     8,     0,     0,    71,     0,     0,     0,    46,   219,     0,     0,    48,   211,     0,     0,    50,   202,     0,     0,    54,   192,     0,     0,    60,   175, 
    0,     0,    64,   152,     0,     0,    64,   132,     0,     0,    63,   110,     0,     0,    61,    93,     0,     0,    59,    78,     0,     0,    58,    65,     0,     0,    58,    55, 
    0,     0,    61,    46,     0,     0,    62,    35,     0,     0,    62,    19,     0,     0,    60,     8,     0,     0,    59,     0,     0,     0,    33,   217,     0,     0,    34,   211, 
    0,     0,    35,   204,     0,     0,    38,   195,     0,     0,    43,   181,     0,     0,    48,   162,     0,     0,    50,   141,     0,     0,    51,   117,     0,     0,    51,    96, 
    0,     0,    49,    79,     0,     0,    47,    66,     0,     0,    44,    51,     0,     0,    42,    40,     0,     0,    48,    33,     0,     0,    49,    20,     0,     0,    49,     9, 
    0,     0,    48,     0,     0,     0,    21,   217,     0,     0,    21,   211,     0,     0,    22,   205,     0,     0,    24,   196,     0,     0,    28,   185,     0,     0,    31,   170, 
    0,     0,    34,   149,     0,     0,    37,   125,     0,     0,    38,   103,     0,     0,    38,    85,     0,     0,    35,    67,     0,     0,    34,    54,     0,     0,    31,    40, 
    0,     0,    32,    31,     0,     0,    36,    24,     0,     0,    37,    14,     0,     0,    36,     0,     0,     0,    11,   216,     0,     0,    11,   211,     0,     0,    12,   204, 
    0,     0,    13,   195,     0,     0,    16,   185,     0,     0,    18,   171,     0,     0,    21,   155,     0,     0,    23,   137,     0,     0,    24,   115,     0,     0,    26,    90, 
    0,     0,    25,    74,     0,     0,    24,    58,     0,     0,    23,    43,     0,     0,    21,    32,     0,     0,    23,    25,     0,     0,    25,    15,     0,     0,    24,     0, 
    0,     0,     4,   216,     0,     0,     5,   205,     0,     0,     7,   194,     0,     0,     8,   184,     0,     0,     9,   174,     0,     0,    11,   160,     0,     0,    12,   148, 
    0,     0,    12,   136,     0,     0,    13,   116,     0,     0,    15,    90,     0,     0,    15,    76,     0,     0,    14,    64,     0,     0,    14,    50,     0,     0,    13,    37, 
    0,     0,    12,    23,     0,     0,    12,    13,     0,     0,    12,     0,     0,     0,     0,   216,     0,     0,     0,   209,     0,     0,     0,   203,     0,     0,     0,   196, 
    0,     0,     0,   186,     0,     0,     0,   174,     0,     0,     0,   160,     0,     0,     0,   146,     0,     0,     0,   130,     0,     0,     0,   112,     0,     0,     0,    93, 
    0,     0,     0,    75,     0,     0,     0,    58,     0,     0,     0,    43,     0,     0,     0,    29,     0,     0,     0,    15,     0,     0,     0,     0
};

// Photo Best (Archie)
unsigned char ucMapDJ4100_KCMY_Photo_BestA_12x12x1[] =
{
    0,   228,   219,   240,     0,   229,   215,   224,     0,   229,   211,   207,     0,   234,   204,   190,     0,   239,   194,   171,     0,   244,   186,   154,     0,   246,   177,   135, 
    0,   248,   165,   110,     0,   249,   153,    81,     0,   251,   141,    50,     0,   250,   131,    23,     0,   246,   126,     7,     0,   241,   126,     2,     0,   237,   128,     2, 
    0,   232,   129,     2,     0,   228,   130,     1,     0,   224,   130,     0,     0,   221,   200,   240,     0,   234,   197,   218,     0,   237,   201,   198,     0,   237,   194,   177, 
    0,   242,   188,   158,     0,   245,   182,   143,     0,   246,   173,   126,     0,   248,   163,   105,     0,   249,   152,    77,     0,   251,   141,    49,     0,   251,   130,    22, 
    0,   247,   124,     4,     0,   238,   126,     0,     0,   231,   128,     0,     0,   225,   130,     0,     0,   221,   131,     0,     0,   218,   130,     0,     0,   214,   180,   239, 
    0,   225,   178,   227,     0,   241,   175,   197,     0,   241,   178,   173,     0,   245,   173,   146,     0,   246,   169,   124,     0,   247,   163,   104,     0,   247,   155,    82, 
    0,   248,   146,    58,     0,   249,   137,    34,     0,   247,   129,    13,     0,   240,   127,     3,     0,   230,   130,     2,     0,   224,   131,     1,     0,   218,   131,     1, 
    0,   215,   130,     0,     0,   214,   128,     0,     0,   214,   157,   239,     0,   219,   155,   225,     0,   228,   156,   203,     0,   239,   155,   175,     0,   243,   154,   146, 
    0,   241,   152,   119,     0,   240,   149,    95,     0,   236,   146,    75,     0,   233,   143,    53,     0,   231,   139,    33,     0,   227,   136,    18,     0,   221,   134,    10, 
    0,   216,   133,     7,     0,   214,   131,     4,     0,   212,   129,     2,     0,   211,   127,     1,     0,   210,   124,     0,     0,   212,   132,   241,     0,   216,   129,   232, 
    0,   219,   133,   209,     0,   224,   136,   184,     0,   233,   133,   153,     0,   231,   134,   125,     0,   229,   135,    99,     0,   222,   136,    79,     0,   218,   136,    60, 
    0,   216,   134,    42,     0,   214,   132,    27,     0,   211,   130,    18,     0,   209,   128,    12,     0,   208,   126,     8,     0,   206,   124,     5,     0,   205,   121,     2, 
    0,   204,   118,     0,     0,   211,   108,   243,     0,   216,   104,   237,     0,   216,   108,   216,     0,   218,   115,   193,     0,   221,   116,   165,     0,   224,   115,   132, 
    0,   220,   119,   108,     0,   216,   121,    84,     0,   214,   122,    63,     0,   211,   122,    46,     0,   208,   122,    33,     0,   206,   120,    24,     0,   204,   119,    17, 
    0,   202,   118,    12,     0,   200,   116,     7,     0,   199,   113,     3,     0,   197,   111,     0,     0,   211,    85,   245,     0,   216,    80,   241,     0,   216,    84,   224, 
    0,   215,    91,   200,     0,   213,    99,   175,     0,   214,   101,   146,     0,   215,   100,   114,     0,   214,   102,    91,     0,   212,   103,    68,     0,   208,   106,    49, 
    0,   205,   108,    35,     0,   201,   109,    26,     0,   199,   110,    21,     0,   197,   109,    15,     0,   194,   107,    10,     0,   192,   104,     5,     0,   190,   102,     0, 
    0,   210,    62,   246,     0,   214,    57,   243,     0,   214,    62,   228,     0,   212,    70,   207,     0,   210,    78,   183,     0,   210,    82,   157,     0,   210,    84,   128, 
    0,   210,    85,    97,     0,   210,    84,    75,     0,   207,    86,    54,     0,   202,    91,    39,     0,   198,    95,    28,     0,   194,    98,    21,     0,   191,    99,    16, 
    0,   188,    97,    11,     0,   185,    95,     5,     0,   182,    92,     0,     0,   207,    39,   247,     0,   209,    37,   244,     0,   208,    42,   230,     0,   207,    51,   210, 
    0,   205,    58,   188,     0,   204,    65,   165,     0,   204,    68,   140,     0,   205,    68,   110,     0,   206,    67,    78,     0,   204,    68,    59,     0,   200,    73,    43, 
    0,   196,    79,    31,     0,   191,    84,    23,     0,   187,    86,    16,     0,   183,    86,    11,     0,   178,    85,     5,     0,   174,    82,     0,     0,   203,    21,   245, 
    0,   204,    21,   240,     0,   203,    25,   228,     0,   201,    33,   210,     0,   200,    38,   191,     0,   198,    46,   170,     0,   198,    51,   148,     0,   198,    53,   123, 
    0,   199,    52,    93,     0,   202,    49,    61,     0,   198,    55,    46,     0,   194,    62,    35,     0,   189,    68,    26,     0,   184,    73,    18,     0,   179,    75,    11, 
    0,   173,    74,     5,     0,   167,    72,     0,     0,   198,    12,   240,     0,   197,    12,   234,     0,   196,    15,   224,     0,   194,    22,   209,     0,   194,    26,   192, 
    0,   192,    31,   174,     0,   191,    36,   154,     0,   191,    39,   133,     0,   191,    40,   107,     0,   194,    39,    78,     0,   198,    37,    48,     0,   192,    45,    37, 
    0,   188,    52,    28,     0,   183,    58,    20,     0,   177,    61,    13,     0,   170,    63,     6,     0,   163,    63,     0,     0,   195,     9,   237,     0,   194,     9,   232, 
    0,   193,    11,   223,     0,   191,    16,   210,     0,   189,    18,   195,     0,   188,    21,   178,     0,   186,    25,   159,     0,   185,    28,   141,     0,   185,    31,   119, 
    0,   187,    32,    94,     0,   189,    30,    67,     0,   193,    29,    39,     0,   188,    37,    30,     0,   182,    42,    21,     0,   176,    47,    13,     0,   169,    50,     6, 
    0,   162,    53,     0,     0,   192,     7,   235,     0,   191,     7,   231,     0,   190,     9,   224,     0,   189,    12,   212,     0,   187,    14,   199,     0,   185,    15,   183, 
    0,   183,    18,   166,     0,   182,    20,   148,     0,   181,    23,   130,     0,   181,    25,   108,     0,   183,    24,    83,     0,   185,    23,    57,     0,   187,    23,    31, 
    0,   183,    29,    22,     0,   177,    33,    14,     0,   170,    37,     7,     0,   162,    40,     0,     0,   189,     5,   233,     0,   189,     5,   229,     0,   188,     6,   223, 
    0,   186,     8,   214,     0,   185,    10,   202,     0,   183,    11,   188,     0,   182,    12,   172,     0,   180,    14,   155,     0,   178,    16,   138,     0,   178,    18,   118, 
    0,   178,    18,    96,     0,   178,    17,    73,     0,   180,    17,    48,     0,   181,    17,    23,     0,   176,    21,    15,     0,   170,    24,     7,     0,   163,    27,     0, 
    0,   187,     3,   230,     0,   186,     4,   228,     0,   185,     4,   223,     0,   184,     5,   215,     0,   183,     7,   204,     0,   181,     7,   192,     0,   180,     8,   177, 
    0,   178,     9,   162,     0,   176,    10,   145,     0,   175,    11,   127,     0,   175,    12,   107,     0,   174,    11,    86,     0,   174,    11,    63,     0,   175,    11,    39, 
    0,   175,    11,    15,     0,   169,    13,     7,     0,   163,    15,     0,     0,   184,     2,   228,     0,   184,     2,   226,     0,   183,     2,   222,     0,   182,     2,   215, 
    0,   181,     4,   206,     0,   180,     4,   195,     0,   178,     4,   182,     0,   177,     4,   167,     0,   175,     5,   152,     0,   174,     5,   135,     0,   173,     6,   116, 
    0,   172,     6,    97,     0,   171,     5,    76,     0,   170,     5,    54,     0,   169,     5,    31,     0,   168,     5,     6,     0,   162,     6,     0,     0,   181,     0,   226, 
    0,   181,     0,   224,     0,   180,     0,   220,     0,   180,     0,   215,     0,   179,     0,   207,     0,   178,     0,   197,     0,   177,     0,   186,     0,   175,     0,   172, 
    0,   174,     0,   158,     0,   173,     0,   142,     0,   172,     0,   125,     0,   170,     0,   107,     0,   169,     0,    88,     0,   167,     0,    68,     0,   166,     0,    46, 
    0,   164,     0,    23,     0,   162,     0,     0,     0,   215,   215,   240,     0,   214,   226,   217,     0,   218,   218,   196,     0,   218,   217,   188,     0,   222,   209,   164, 
    0,   223,   199,   124,     0,   225,   187,    96,     0,   227,   176,    74,     0,   231,   167,    49,     0,   233,   158,    27,     0,   230,   149,    11,     0,   224,   145,     3, 
    0,   223,   142,     1,     0,   223,   140,     1,     0,   221,   137,     0,     0,   221,   135,     0,     0,   220,   134,     0,     0,   210,   198,   243,     0,   217,   205,   226, 
    0,   225,   198,   189,     0,   234,   186,   161,     0,   239,   180,   142,     0,   241,   174,   123,     0,   243,   166,   103,     0,   246,   156,    79,     0,   247,   145,    56, 
    0,   248,   135,    33,     0,   247,   126,    13,     0,   242,   121,     1,     0,   233,   125,     0,     0,   226,   127,     0,     0,   220,   128,     0,     0,   217,   129,     0, 
    0,   215,   130,     0,     0,   208,   179,   241,     0,   217,   174,   236,     0,   224,   178,   203,     0,   229,   176,   168,     0,   238,   171,   135,     0,   245,   163,   110, 
    0,   249,   154,    89,     0,   250,   145,    68,     0,   251,   136,    46,     0,   252,   126,    25,     0,   250,   119,     8,     0,   242,   119,     1,     0,   230,   124,     0, 
    0,   220,   126,     0,     0,   215,   127,     0,     0,   213,   126,     0,     0,   211,   128,     0,     0,   207,   155,   242,     0,   213,   151,   236,     0,   217,   153,   211, 
    0,   221,   160,   183,     0,   224,   157,   150,     0,   234,   150,   113,     0,   241,   143,    80,     0,   245,   135,    50,     0,   249,   126,    24,     0,   247,   119,     7, 
    0,   239,   121,     2,     0,   227,   124,     1,     0,   218,   126,     1,     0,   213,   126,     0,     0,   211,   124,     0,     0,   209,   124,     0,     0,   207,   125,     0, 
    0,   205,   132,   244,     0,   211,   127,   240,     0,   215,   126,   221,     0,   215,   136,   192,     0,   217,   139,   163,     0,   223,   136,   128,     0,   228,   133,    94, 
    0,   232,   127,    63,     0,   235,   120,    34,     0,   236,   113,    10,     0,   226,   118,     3,     0,   216,   122,     1,     0,   211,   122,     1,     0,   208,   120,     1, 
    0,   206,   119,     0,     0,   204,   118,     0,     0,   202,   119,     0,     0,   206,   108,   245,     0,   210,   104,   243,     0,   215,   101,   231,     0,   215,   109,   202, 
    0,   215,   115,   174,     0,   216,   118,   143,     0,   216,   118,   112,     0,   217,   117,    81,     0,   218,   115,    52,     0,   220,   111,    27,     0,   218,   109,     9, 
    0,   212,   111,     3,     0,   208,   111,     1,     0,   204,   111,     1,     0,   201,   111,     1,     0,   199,   110,     0,     0,   196,   111,     0,     0,   206,    86,   246, 
    0,   209,    83,   245,     0,   214,    80,   235,     0,   213,    86,   211,     0,   212,    94,   184,     0,   212,    98,   155,     0,   212,    99,   126,     0,   213,    99,    97, 
    0,   213,    98,    68,     0,   212,    98,    41,     0,   211,    98,    20,     0,   208,    98,     6,     0,   204,    99,     2,     0,   200,   100,     1,     0,   196,   101,     1, 
    0,   193,   101,     0,     0,   189,   103,     0,     0,   205,    64,   247,     0,   207,    61,   246,     0,   211,    58,   239,     0,   209,    67,   217,     0,   208,    74,   192, 
    0,   208,    79,   165,     0,   208,    81,   137,     0,   209,    81,   109,     0,   210,    81,    82,     0,   209,    80,    55,     0,   207,    83,    32,     0,   204,    85,    14, 
    0,   200,    86,     4,     0,   195,    89,     1,     0,   190,    90,     1,     0,   187,    91,     0,     0,   182,    93,     0,     0,   203,    41,   247,     0,   204,    39,   247, 
    0,   207,    36,   242,     0,   206,    44,   221,     0,   205,    52,   198,     0,   204,    60,   173,     0,   204,    63,   148,     0,   204,    64,   120,     0,   205,    64,    92, 
    0,   205,    64,    67,     0,   203,    65,    44,     0,   200,    69,    25,     0,   196,    74,    10,     0,   190,    77,     3,     0,   185,    79,     1,     0,   179,    80,     0, 
    0,   172,    82,     0,     0,   199,    21,   246,     0,   201,    20,   246,     0,   203,    18,   241,     0,   202,    25,   223,     0,   201,    32,   201,     0,   199,    39,   179, 
    0,   199,    44,   156,     0,   199,    47,   131,     0,   200,    47,   103,     0,   201,    46,    76,     0,   201,    48,    54,     0,   198,    52,    34,     0,   193,    57,    18, 
    0,   188,    63,     8,     0,   181,    68,     2,     0,   173,    70,     0,     0,   164,    71,     0,     0,   194,    12,   240,     0,   197,     5,   243,     0,   198,     6,   237, 
    0,   197,    11,   222,     0,   195,    19,   203,     0,   194,    24,   183,     0,   193,    28,   162,     0,   193,    32,   140,     0,   193,    34,   114,     0,   194,    33,    88, 
    0,   196,    31,    62,     0,   196,    35,    43,     0,   192,    40,    27,     0,   186,    47,    14,     0,   179,    53,     5,     0,   170,    58,     1,     0,   159,    63,     0, 
    0,   191,     9,   237,     0,   191,     2,   235,     0,   191,     1,   230,     0,   191,     3,   219,     0,   190,     8,   203,     0,   188,    12,   186,     0,   187,    16,   166, 
    0,   187,    19,   146,     0,   186,    22,   124,     0,   187,    23,    99,     0,   188,    22,    74,     0,   190,    21,    50,     0,   190,    26,    34,     0,   186,    31,    20, 
    0,   179,    37,     9,     0,   170,    44,     3,     0,   157,    51,     0,     0,   189,     7,   235,     0,   185,     1,   228,     0,   185,     1,   223,     0,   185,     1,   214, 
    0,   185,     2,   203,     0,   184,     5,   188,     0,   182,     7,   170,     0,   181,    10,   151,     0,   181,    12,   132,     0,   180,    14,   110,     0,   181,    14,    86, 
    0,   182,    14,    62,     0,   184,    14,    39,     0,   183,    19,    25,     0,   179,    23,    14,     0,   171,    29,     5,     0,   158,    38,     0,     0,   187,     5,   233, 
    0,   181,     1,   223,     0,   180,     1,   218,     0,   180,     1,   210,     0,   179,     1,   201,     0,   179,     1,   188,     0,   178,     2,   173,     0,   177,     4,   156, 
    0,   176,     5,   138,     0,   175,     7,   118,     0,   175,     8,    97,     0,   175,     7,    74,     0,   176,     7,    51,     0,   176,     8,    29,     0,   174,    12,    17, 
    0,   169,    16,     7,     0,   159,    25,     0,     0,   184,     3,   231,     0,   177,     1,   220,     0,   176,     0,   214,     0,   176,     0,   208,     0,   175,     1,   199, 
    0,   174,     1,   188,     0,   174,     1,   175,     0,   173,     1,   159,     0,   172,     1,   143,     0,   170,     2,   125,     0,   170,     3,   105,     0,   169,     3,    85, 
    0,   169,     3,    63,     0,   169,     3,    41,     0,   168,     3,    20,     0,   165,     7,     9,     0,   157,    14,     0,     0,   182,     2,   229,     0,   175,     0,   218, 
    0,   173,     0,   212,     0,   173,     0,   207,     0,   172,     0,   199,     0,   171,     0,   189,     0,   170,     0,   176,     0,   169,     0,   162,     0,   168,     0,   147, 
    0,   166,     1,   130,     0,   165,     1,   112,     0,   164,     1,    94,     0,   163,     1,    75,     0,   162,     1,    53,     0,   161,     1,    32,     0,   160,     1,    13, 
    0,   155,     5,     0,     0,   180,     0,   226,     0,   175,     0,   215,     0,   175,     0,   213,     0,   174,     0,   208,     0,   173,     0,   200,     0,   172,     0,   191, 
    0,   171,     0,   179,     0,   169,     0,   166,     0,   168,     0,   151,     0,   166,     0,   136,     0,   165,     0,   119,     0,   163,     0,   102,     0,   161,     0,    84, 
    0,   160,     0,    65,     0,   158,     0,    43,     0,   157,     0,    22,     0,   155,     0,     0,     0,   201,   212,   240,     0,   198,   225,   232,     0,   199,   233,   194, 
    0,   203,   226,   177,     0,   205,   218,   148,     0,   203,   211,   106,     0,   204,   200,    82,     0,   206,   188,    63,     0,   210,   178,    44,     0,   213,   169,    26, 
    0,   213,   159,    13,     0,   212,   153,     5,     0,   213,   149,     3,     0,   214,   146,     3,     0,   215,   143,     2,     0,   215,   140,     1,     0,   215,   138,     0, 
    0,   197,   194,   246,     0,   204,   219,   238,     0,   199,   218,   185,     0,   206,   207,   152,     0,   209,   198,   118,     0,   213,   187,    86,     0,   220,   177,    53, 
    0,   228,   168,    22,     0,   230,   158,    11,     0,   227,   150,     5,     0,   222,   145,     2,     0,   218,   141,     0,     0,   215,   139,     0,     0,   213,   136,     0, 
    0,   212,   134,     0,     0,   212,   133,     0,     0,   211,   134,     0,     0,   192,   176,   247,     0,   196,   177,   237,     0,   197,   181,   202,     0,   203,   176,   166, 
    0,   213,   170,   132,     0,   227,   163,    99,     0,   237,   151,    66,     0,   243,   141,    39,     0,   245,   131,    20,     0,   244,   123,     5,     0,   237,   123,     1, 
    0,   228,   126,     0,     0,   218,   128,     0,     0,   213,   127,     0,     0,   211,   126,     0,     0,   209,   125,     0,     0,   208,   127,     0,     0,   195,   154,   246, 
    0,   199,   152,   241,     0,   200,   156,   213,     0,   202,   162,   184,     0,   205,   160,   150,     0,   212,   156,   115,     0,   218,   149,    81,     0,   228,   140,    49, 
    0,   238,   129,    20,     0,   238,   122,     2,     0,   229,   124,     0,     0,   219,   125,     0,     0,   213,   125,     0,     0,   210,   123,     0,     0,   207,   122,     0, 
    0,   205,   122,     0,     0,   204,   124,     0,     0,   196,   133,   247,     0,   201,   129,   244,     0,   202,   131,   225,     0,   202,   138,   194,     0,   203,   144,   166, 
    0,   207,   142,   133,     0,   211,   138,    97,     0,   214,   134,    66,     0,   218,   129,    36,     0,   219,   124,    10,     0,   215,   123,     1,     0,   210,   123,     0, 
    0,   207,   121,     0,     0,   204,   120,     0,     0,   202,   118,     0,     0,   200,   118,     0,     0,   199,   120,     0,     0,   198,   110,   247,     0,   202,   107,   246, 
    0,   204,   106,   234,     0,   203,   113,   204,     0,   202,   121,   175,     0,   204,   123,   146,     0,   207,   121,   114,     0,   209,   120,    82,     0,   211,   118,    52, 
    0,   212,   114,    25,     0,   212,   111,     4,     0,   207,   111,     0,     0,   203,   112,     0,     0,   200,   111,     0,     0,   197,   111,     0,     0,   195,   110,     0, 
    0,   193,   112,     0,     0,   198,    88,   247,     0,   201,    85,   246,     0,   205,    84,   237,     0,   204,    90,   213,     0,   203,    96,   186,     0,   204,   100,   157, 
    0,   205,   101,   128,     0,   206,   101,    98,     0,   207,   100,    68,     0,   207,   100,    41,     0,   207,    99,    17,     0,   205,    97,     2,     0,   200,    99,     0, 
    0,   196,   100,     0,     0,   193,   101,     0,     0,   190,   101,     0,     0,   187,   103,     0,     0,   198,    66,   248,     0,   201,    64,   247,     0,   204,    61,   240, 
    0,   203,    69,   219,     0,   202,    75,   194,     0,   202,    79,   167,     0,   203,    81,   139,     0,   204,    82,   111,     0,   204,    82,    84,     0,   203,    82,    56, 
    0,   202,    84,    32,     0,   200,    84,    11,     0,   196,    85,     1,     0,   191,    88,     0,     0,   187,    90,     0,     0,   184,    91,     0,     0,   179,    93,     0, 
    0,   197,    44,   248,     0,   199,    40,   248,     0,   202,    38,   243,     0,   202,    45,   223,     0,   201,    53,   200,     0,   199,    60,   175,     0,   199,    64,   150, 
    0,   200,    65,   122,     0,   200,    65,    96,     0,   200,    65,    70,     0,   199,    66,    45,     0,   197,    68,    24,     0,   193,    72,     7,     0,   187,    75,     1, 
    0,   181,    78,     0,     0,   176,    79,     0,     0,   169,    82,     0,     0,   193,    24,   247,     0,   196,    21,   247,     0,   199,    20,   242,     0,   199,    26,   226, 
    0,   197,    34,   204,     0,   196,    39,   182,     0,   196,    45,   159,     0,   196,    47,   134,     0,   196,    48,   106,     0,   197,    48,    81,     0,   198,    47,    56, 
    0,   195,    51,    35,     0,   191,    55,    16,     0,   185,    61,     4,     0,   177,    66,     0,     0,   168,    69,     0,     0,   160,    70,     0,     0,   189,    13,   241, 
    0,   193,     5,   245,     0,   195,     7,   239,     0,   194,    11,   225,     0,   193,    20,   206,     0,   192,    24,   186,     0,   191,    28,   165,     0,   191,    32,   142, 
    0,   191,    34,   117,     0,   192,    34,    91,     0,   193,    32,    66,     0,   194,    33,    45,     0,   191,    37,    26,     0,   184,    44,    11,     0,   176,    50,     2, 
    0,   165,    56,     0,     0,   155,    61,     0,     0,   187,    10,   238,     0,   187,     1,   236,     0,   188,     0,   231,     0,   189,     2,   222,     0,   188,     7,   206, 
    0,   187,    11,   188,     0,   186,    15,   169,     0,   185,    18,   148,     0,   185,    20,   126,     0,   185,    21,   101,     0,   186,    21,    77,     0,   187,    20,    53, 
    0,   188,    23,    35,     0,   185,    28,    19,     0,   177,    34,     7,     0,   166,    41,     1,     0,   152,    50,     0,     0,   185,     7,   236,     0,   181,     1,   228, 
    0,   180,     0,   220,     0,   181,     0,   212,     0,   181,     1,   202,     0,   181,     2,   188,     0,   180,     5,   171,     0,   180,     7,   153,     0,   179,     9,   133, 
    0,   178,    11,   111,     0,   178,    11,    87,     0,   179,    11,    64,     0,   180,    11,    41,     0,   179,    15,    25,     0,   175,    19,    13,     0,   168,    25,     3, 
    0,   152,    37,     0,     0,   183,     5,   233,     0,   177,     0,   222,     0,   174,     0,   212,     0,   174,     0,   205,     0,   174,     0,   197,     0,   174,     0,   185, 
    0,   174,     0,   171,     0,   173,     1,   155,     0,   173,     2,   137,     0,   172,     3,   117,     0,   171,     4,    96,     0,   171,     4,    74,     0,   172,     4,    52, 
    0,   172,     4,    30,     0,   169,     8,    17,     0,   165,    12,     6,     0,   153,    24,     0,     0,   182,     3,   231,     0,   173,     0,   218,     0,   169,     0,   206, 
    0,   168,     0,   200,     0,   168,     0,   192,     0,   167,     0,   182,     0,   167,     0,   169,     0,   166,     0,   155,     0,   165,     0,   138,     0,   164,     0,   121, 
    0,   163,     0,   103,     0,   163,     0,    84,     0,   163,     0,    63,     0,   162,     0,    41,     0,   161,     1,    22,     0,   159,     4,     9,     0,   151,    13,     0, 
    0,   180,     2,   229,     0,   171,     0,   215,     0,   165,     0,   202,     0,   164,     0,   195,     0,   163,     0,   188,     0,   162,     0,   179,     0,   161,     0,   167, 
    0,   160,     0,   154,     0,   159,     0,   139,     0,   157,     0,   124,     0,   156,     0,   107,     0,   155,     0,    90,     0,   154,     0,    72,     0,   154,     0,    52, 
    0,   153,     0,    32,     0,   151,     1,    14,     0,   148,     5,     0,     0,   177,     0,   227,     0,   173,     0,   216,     0,   167,     0,   203,     0,   167,     0,   198, 
    0,   166,     0,   192,     0,   165,     0,   183,     0,   164,     0,   172,     0,   163,     0,   159,     0,   161,     0,   145,     0,   159,     0,   130,     0,   157,     0,   113, 
    0,   155,     0,    97,     0,   154,     0,    80,     0,   152,     0,    61,     0,   151,     0,    40,     0,   149,     0,    20,     0,   147,     0,     0,     0,   185,   211,   239, 
    0,   178,   224,   219,     0,   177,   239,   188,     0,   178,   240,   155,     0,   178,   229,   123,     0,   180,   219,    91,     0,   185,   207,    72,     0,   189,   196,    55, 
    0,   194,   185,    40,     0,   197,   176,    25,     0,   199,   167,    13,     0,   201,   160,     7,     0,   204,   155,     5,     0,   207,   151,     4,     0,   208,   147,     2, 
    0,   210,   144,     1,     0,   210,   141,     0,     0,   184,   193,   245,     0,   181,   207,   230,     0,   178,   216,   196,     0,   178,   222,   156,     0,   183,   212,   112, 
    0,   189,   202,    78,     0,   193,   194,    44,     0,   198,   184,    14,     0,   202,   173,     4,     0,   204,   164,     2,     0,   204,   156,     1,     0,   204,   150,     1, 
    0,   204,   145,     0,     0,   205,   141,     0,     0,   206,   139,     0,     0,   207,   137,     0,     0,   207,   137,     0,     0,   180,   177,   247,     0,   182,   183,   235, 
    0,   181,   184,   204,     0,   180,   191,   171,     0,   187,   187,   130,     0,   193,   181,    93,     0,   198,   172,    58,     0,   203,   164,    24,     0,   206,   153,     5, 
    0,   208,   145,     0,     0,   207,   142,     0,     0,   206,   140,     0,     0,   204,   137,     0,     0,   203,   134,     0,     0,   203,   132,     0,     0,   203,   130,     0, 
    0,   203,   132,     0,     0,   176,   158,   252,     0,   179,   159,   240,     0,   183,   163,   214,     0,   182,   162,   184,     0,   188,   160,   148,     0,   195,   156,   114, 
    0,   202,   150,    81,     0,   208,   144,    47,     0,   213,   136,    19,     0,   216,   130,     2,     0,   212,   128,     0,     0,   209,   127,     0,     0,   206,   125,     0, 
    0,   204,   123,     0,     0,   201,   121,     0,     0,   200,   120,     0,     0,   200,   122,     0,     0,   180,   135,   250,     0,   186,   134,   246,     0,   187,   139,   223, 
    0,   187,   142,   194,     0,   189,   146,   165,     0,   193,   145,   133,     0,   198,   141,    98,     0,   202,   136,    65,     0,   206,   132,    35,     0,   209,   126,    10, 
    0,   208,   123,     1,     0,   205,   121,     0,     0,   203,   119,     0,     0,   200,   118,     0,     0,   197,   116,     0,     0,   196,   116,     0,     0,   194,   119,     0, 
    0,   186,   112,   249,     0,   190,   110,   248,     0,   191,   112,   233,     0,   190,   120,   205,     0,   190,   125,   176,     0,   191,   129,   148,     0,   196,   128,   117, 
    0,   199,   124,    82,     0,   202,   121,    52,     0,   203,   118,    24,     0,   203,   114,     3,     0,   200,   114,     0,     0,   196,   113,     0,     0,   194,   112,     0, 
    0,   191,   111,     0,     0,   190,   111,     0,     0,   189,   113,     0,     0,   187,    91,   249,     0,   190,    88,   248,     0,   193,    88,   239,     0,   193,    95,   214, 
    0,   192,   100,   187,     0,   191,   106,   158,     0,   193,   108,   130,     0,   196,   106,    99,     0,   198,   105,    68,     0,   199,   104,    39,     0,   200,   101,    15, 
    0,   198,   100,     2,     0,   194,   101,     0,     0,   190,   102,     0,     0,   187,   102,     0,     0,   185,   102,     0,     0,   182,   105,     0,     0,   188,    70,   249, 
    0,   192,    66,   248,     0,   195,    65,   240,     0,   194,    72,   219,     0,   193,    77,   195,     0,   193,    82,   168,     0,   194,    85,   141,     0,   195,    86,   113, 
    0,   195,    86,    85,     0,   195,    87,    56,     0,   195,    87,    30,     0,   194,    85,     8,     0,   190,    87,     1,     0,   186,    89,     0,     0,   182,    90,     0, 
    0,   179,    91,     0,     0,   175,    94,     0,     0,   188,    48,   249,     0,   191,    44,   248,     0,   194,    43,   242,     0,   194,    50,   223,     0,   193,    57,   200, 
    0,   191,    62,   176,     0,   192,    66,   150,     0,   193,    68,   124,     0,   193,    68,    98,     0,   193,    68,    71,     0,   192,    69,    45,     0,   190,    71,    21, 
    0,   187,    73,     4,     0,   181,    75,     0,     0,   175,    78,     0,     0,   170,    79,     0,     0,   165,    82,     0,     0,   186,    27,   247,     0,   190,    23,   247, 
    0,   192,    24,   241,     0,   192,    31,   225,     0,   192,    38,   205,     0,   191,    42,   183,     0,   190,    47,   159,     0,   190,    50,   134,     0,   190,    51,   108, 
    0,   191,    50,    83,     0,   191,    49,    57,     0,   189,    53,    34,     0,   185,    56,    14,     0,   179,    61,     2,     0,   170,    66,     0,     0,   162,    68,     0, 
    0,   155,    70,     0,     0,   182,    15,   242,     0,   188,     8,   245,     0,   189,    10,   238,     0,   189,    14,   225,     0,   188,    22,   207,     0,   188,    25,   187, 
    0,   187,    30,   166,     0,   187,    33,   144,     0,   186,    35,   119,     0,   187,    35,    93,     0,   188,    34,    68,     0,   189,    34,    45,     0,   186,    38,    25, 
    0,   179,    43,     9,     0,   170,    49,     1,     0,   159,    56,     0,     0,   149,    61,     0,     0,   181,    11,   239,     0,   183,     1,   237,     0,   184,     1,   232, 
    0,   185,     3,   222,     0,   184,     9,   207,     0,   183,    12,   190,     0,   183,    15,   171,     0,   182,    18,   150,     0,   182,    20,   128,     0,   182,    21,   103, 
    0,   182,    21,    79,     0,   183,    20,    55,     0,   184,    23,    35,     0,   180,    26,    18,     0,   172,    32,     5,     0,   159,    40,     0,     0,   146,    49,     0, 
    0,   180,     8,   236,     0,   177,     1,   228,     0,   176,     0,   220,     0,   177,     0,   212,     0,   177,     1,   202,     0,   177,     2,   189,     0,   177,     5,   172, 
    0,   176,     7,   154,     0,   176,     8,   134,     0,   175,    10,   111,     0,   175,    10,    88,     0,   175,    10,    65,     0,   176,    10,    42,     0,   174,    13,    25, 
    0,   171,    17,    11,     0,   162,    23,     2,     0,   146,    36,     0,     0,   179,     6,   234,     0,   173,     0,   222,     0,   170,     0,   212,     0,   168,     0,   201, 
    0,   167,     0,   193,     0,   168,     0,   182,     0,   168,     0,   169,     0,   168,     1,   154,     0,   168,     1,   137,     0,   168,     1,   117,     0,   167,     2,    96, 
    0,   167,     2,    74,     0,   167,     2,    52,     0,   166,     2,    31,     0,   164,     5,    16,     0,   160,    10,     5,     0,   146,    23,     0,     0,   178,     4,   232, 
    0,   169,     0,   217,     0,   164,     0,   205,     0,   160,     0,   192,     0,   159,     0,   184,     0,   159,     0,   174,     0,   159,     0,   163,     0,   158,     0,   149, 
    0,   157,     0,   134,     0,   156,     0,   117,     0,   156,     0,   100,     0,   155,     0,    82,     0,   155,     0,    62,     0,   155,     0,    41,     0,   153,     0,    23, 
    0,   152,     3,     9,     0,   144,    12,     0,     0,   176,     2,   229,     0,   167,     0,   215,     0,   160,     0,   200,     0,   155,     0,   186,     0,   154,     0,   178, 
    0,   153,     0,   170,     0,   152,     0,   159,     0,   151,     0,   147,     0,   150,     0,   133,     0,   148,     0,   118,     0,   147,     0,   102,     0,   146,     0,    87, 
    0,   145,     0,    70,     0,   145,     0,    50,     0,   143,     0,    32,     0,   142,     1,    15,     0,   140,     5,     0,     0,   175,     0,   227,     0,   170,     0,   216, 
    0,   164,     0,   203,     0,   159,     0,   189,     0,   159,     0,   183,     0,   158,     0,   175,     0,   157,     0,   164,     0,   155,     0,   152,     0,   154,     0,   139, 
    0,   151,     0,   124,     0,   149,     0,   108,     0,   147,     0,    93,     0,   146,     0,    76,     0,   144,     0,    58,     0,   143,     0,    38,     0,   140,     0,    19, 
    0,   138,     0,     0,     0,   164,   213,   238,     0,   155,   229,   214,     0,   151,   244,   184,     0,   150,   252,   144,     0,   148,   242,   111,     0,   151,   230,    79, 
    0,   161,   215,    59,     0,   169,   202,    44,     0,   177,   191,    34,     0,   182,   182,    21,     0,   185,   174,    11,     0,   189,   167,     7,     0,   193,   161,     6, 
    0,   197,   157,     5,     0,   200,   153,     3,     0,   202,   149,     2,     0,   203,   145,     0,     0,   164,   195,   245,     0,   159,   203,   228,     0,   159,   213,   199, 
    0,   157,   226,   163,     0,   157,   222,   112,     0,   163,   212,    75,     0,   170,   202,    41,     0,   175,   192,    11,     0,   181,   180,     3,     0,   186,   171,     2, 
    0,   189,   163,     1,     0,   191,   156,     1,     0,   193,   151,     1,     0,   195,   147,     0,     0,   197,   143,     0,     0,   199,   141,     0,     0,   200,   141,     0, 
    0,   165,   180,   244,     0,   165,   182,   238,     0,   168,   185,   204,     0,   163,   192,   177,     0,   163,   195,   133,     0,   168,   192,    94,     0,   173,   187,    56, 
    0,   178,   180,    20,     0,   182,   170,     2,     0,   186,   162,     0,     0,   188,   156,     0,     0,   190,   150,     0,     0,   191,   144,     0,     0,   192,   140,     0, 
    0,   193,   137,     0,     0,   195,   135,     0,     0,   195,   136,     0,     0,   162,   162,   248,     0,   164,   163,   236,     0,   168,   167,   210,     0,   165,   166,   185, 
    0,   166,   172,   150,     0,   170,   170,   112,     0,   176,   165,    76,     0,   182,   160,    41,     0,   185,   153,    10,     0,   188,   146,     1,     0,   190,   141,     0, 
    0,   191,   136,     0,     0,   191,   132,     0,     0,   190,   129,     0,     0,   190,   126,     0,     0,   190,   125,     0,     0,   191,   127,     0,     0,   157,   139,   254, 
    0,   165,   138,   244,     0,   167,   144,   218,     0,   167,   145,   194,     0,   168,   147,   168,     0,   174,   146,   132,     0,   182,   141,    96,     0,   189,   136,    63, 
    0,   195,   132,    31,     0,   198,   125,     7,     0,   198,   121,     0,     0,   197,   119,     0,     0,   194,   118,     0,     0,   192,   116,     0,     0,   190,   115,     0, 
    0,   189,   114,     0,     0,   189,   116,     0,     0,   166,   116,   252,     0,   170,   114,   249,     0,   172,   119,   230,     0,   172,   126,   203,     0,   174,   129,   177, 
    0,   177,   133,   148,     0,   181,   132,   117,     0,   186,   127,    82,     0,   190,   125,    49,     0,   193,   120,    20,     0,   195,   115,     3,     0,   193,   114,     0, 
    0,   190,   112,     0,     0,   188,   111,     0,     0,   186,   110,     0,     0,   184,   109,     0,     0,   183,   112,     0,     0,   170,    95,   251,     0,   176,    91,   250, 
    0,   177,    93,   238,     0,   178,   102,   212,     0,   178,   106,   188,     0,   178,   111,   160,     0,   179,   115,   132,     0,   184,   114,   102,     0,   187,   111,    68, 
    0,   189,   108,    38,     0,   191,   104,    13,     0,   188,   103,     1,     0,   185,   104,     0,     0,   182,   104,     0,     0,   178,   103,     0,     0,   176,   102,     0, 
    0,   175,   105,     0,     0,   173,    74,   250,     0,   178,    70,   249,     0,   181,    71,   241,     0,   181,    78,   219,     0,   180,    83,   196,     0,   180,    86,   169, 
    0,   179,    91,   142,     0,   181,    94,   115,     0,   183,    91,    84,     0,   186,    91,    55,     0,   187,    90,    28,     0,   186,    88,     6,     0,   182,    89,     0, 
    0,   177,    91,     0,     0,   173,    91,     0,     0,   169,    91,     0,     0,   167,    94,     0,     0,   175,    52,   249,     0,   180,    48,   248,     0,   183,    49,   241, 
    0,   183,    56,   223,     0,   181,    63,   201,     0,   181,    65,   177,     0,   182,    69,   151,     0,   182,    72,   124,     0,   183,    72,    98,     0,   183,    72,    71, 
    0,   183,    73,    43,     0,   182,    74,    19,     0,   179,    74,     3,     0,   173,    76,     0,     0,   167,    78,     0,     0,   162,    79,     0,     0,   158,    83,     0, 
    0,   175,    32,   248,     0,   180,    27,   247,     0,   182,    30,   240,     0,   183,    37,   224,     0,   183,    43,   204,     0,   182,    45,   183,     0,   181,    50,   160, 
    0,   182,    53,   134,     0,   182,    55,   109,     0,   182,    54,    83,     0,   182,    55,    58,     0,   180,    56,    33,     0,   176,    58,    13,     0,   170,    62,     2, 
    0,   161,    66,     0,     0,   155,    67,     0,     0,   149,    70,     0,     0,   173,    18,   243,     0,   179,    12,   244,     0,   180,    15,   237,     0,   181,    19,   224, 
    0,   181,    25,   207,     0,   181,    29,   188,     0,   180,    33,   167,     0,   180,    36,   144,     0,   180,    38,   119,     0,   180,    38,    94,     0,   181,    37,    70, 
    0,   181,    38,    46,     0,   177,    40,    25,     0,   171,    44,     7,     0,   161,    50,     1,     0,   151,    55,     0,     0,   143,    59,     0,     0,   173,    12,   239, 
    0,   176,     3,   238,     0,   177,     3,   232,     0,   177,     6,   222,     0,   177,    11,   206,     0,   177,    14,   190,     0,   177,    18,   171,     0,   176,    20,   151, 
    0,   176,    22,   128,     0,   175,    23,   104,     0,   175,    22,    79,     0,   176,    22,    56,     0,   177,    24,    35,     0,   173,    27,    17,     0,   164,    31,     3, 
    0,   151,    40,     0,     0,   140,    48,     0,     0,   174,     9,   237,     0,   172,     1,   229,     0,   171,     0,   222,     0,   171,     0,   214,     0,   172,     1,   203, 
    0,   172,     3,   189,     0,   171,     6,   172,     0,   171,     8,   154,     0,   170,     9,   134,     0,   169,    10,   112,     0,   169,    11,    89,     0,   169,    10,    66, 
    0,   170,    10,    43,     0,   169,    12,    25,     0,   165,    16,    10,     0,   154,    23,     1,     0,   139,    35,     0,     0,   174,     6,   234,     0,   168,     1,   222, 
    0,   165,     0,   212,     0,   162,     0,   201,     0,   161,     0,   190,     0,   161,     0,   179,     0,   161,     0,   167,     0,   162,     1,   152,     0,   162,     1,   135, 
    0,   162,     1,   116,     0,   161,     1,    96,     0,   161,     1,    74,     0,   161,     1,    52,     0,   160,     1,    31,     0,   158,     4,    16,     0,   154,     9,     4, 
    0,   139,    22,     0,     0,   173,     4,   232,     0,   165,     0,   217,     0,   160,     0,   204,     0,   155,     0,   191,     0,   151,     0,   177,     0,   151,     0,   168, 
    0,   150,     0,   157,     0,   150,     0,   145,     0,   150,     0,   131,     0,   149,     0,   115,     0,   148,     0,    98,     0,   147,     0,    80,     0,   147,     0,    61, 
    0,   147,     0,    41,     0,   145,     0,    23,     0,   144,     2,    10,     0,   136,    12,     0,     0,   172,     2,   230,     0,   163,     0,   214,     0,   156,     0,   200, 
    0,   150,     0,   184,     0,   145,     0,   170,     0,   144,     0,   161,     0,   143,     0,   151,     0,   142,     0,   140,     0,   141,     0,   127,     0,   139,     0,   113, 
    0,   138,     0,    99,     0,   137,     0,    83,     0,   136,     0,    67,     0,   135,     0,    49,     0,   134,     0,    32,     0,   133,     1,    16,     0,   132,     5,     0, 
    0,   171,     0,   228,     0,   166,     0,   216,     0,   160,     0,   203,     0,   155,     0,   189,     0,   149,     0,   174,     0,   149,     0,   166,     0,   148,     0,   157, 
    0,   147,     0,   145,     0,   145,     0,   132,     0,   143,     0,   119,     0,   141,     0,   104,     0,   138,     0,    89,     0,   137,     0,    73,     0,   135,     0,    55, 
    0,   134,     0,    35,     0,   131,     0,    17,     0,   129,     0,     0,     0,   137,   213,   240,     0,   125,   230,   212,     0,   121,   243,   183,     0,   121,   251,   140, 
    0,   121,   245,   101,     0,   121,   239,    70,     0,   130,   224,    44,     0,   143,   210,    27,     0,   156,   198,    23,     0,   165,   189,    15,     0,   171,   180,     9, 
    0,   177,   173,     6,     0,   181,   168,     6,     0,   185,   163,     5,     0,   189,   158,     4,     0,   192,   155,     2,     0,   194,   151,     0,     0,   143,   193,   246, 
    0,   135,   202,   231,     0,   133,   214,   201,     0,   133,   224,   168,     0,   133,   224,   118,     0,   135,   218,    77,     0,   141,   210,    37,     0,   151,   199,     7, 
    0,   161,   187,     2,     0,   168,   177,     1,     0,   173,   169,     1,     0,   176,   162,     1,     0,   180,   156,     1,     0,   183,   152,     1,     0,   186,   149,     0, 
    0,   188,   146,     0,     0,   190,   146,     0,     0,   148,   179,   245,     0,   142,   183,   242,     0,   147,   188,   205,     0,   144,   193,   182,     0,   142,   199,   142, 
    0,   143,   197,   101,     0,   149,   194,    57,     0,   156,   188,    20,     0,   163,   178,     2,     0,   168,   169,     0,     0,   172,   161,     0,     0,   175,   155,     0, 
    0,   177,   149,     0,     0,   180,   145,     0,     0,   182,   142,     0,     0,   184,   139,     0,     0,   186,   140,     0,     0,   146,   160,   246,     0,   145,   164,   237, 
    0,   150,   170,   213,     0,   149,   170,   187,     0,   146,   177,   159,     0,   144,   179,   123,     0,   152,   175,    79,     0,   159,   171,    42,     0,   163,   165,     9, 
    0,   167,   158,     0,     0,   170,   151,     0,     0,   173,   146,     0,     0,   175,   141,     0,     0,   177,   137,     0,     0,   178,   133,     0,     0,   179,   131,     0, 
    0,   181,   133,     0,     0,   143,   141,   244,     0,   144,   141,   237,     0,   149,   147,   214,     0,   151,   150,   190,     0,   150,   154,   169,     0,   149,   157,   137, 
    0,   156,   152,    95,     0,   161,   150,    60,     0,   166,   146,    26,     0,   170,   140,     4,     0,   173,   135,     0,     0,   174,   131,     0,     0,   175,   127,     0, 
    0,   175,   124,     0,     0,   175,   121,     0,     0,   175,   119,     0,     0,   177,   122,     0,     0,   139,   120,   254,     0,   143,   120,   249,     0,   146,   125,   225, 
    0,   148,   130,   198,     0,   150,   132,   176,     0,   153,   132,   152,     0,   159,   130,   114,     0,   166,   126,    79,     0,   175,   124,    47,     0,   181,   118,    18, 
    0,   183,   113,     2,     0,   182,   111,     0,     0,   181,   109,     0,     0,   179,   108,     0,     0,   176,   106,     0,     0,   174,   106,     0,     0,   175,   107,     0, 
    0,   148,    98,   253,     0,   153,    96,   252,     0,   155,    99,   240,     0,   156,   108,   210,     0,   157,   112,   186,     0,   159,   114,   161,     0,   161,   117,   132, 
    0,   165,   115,   100,     0,   170,   113,    67,     0,   175,   111,    35,     0,   178,   108,     9,     0,   177,   105,     0,     0,   174,   103,     0,     0,   172,   102,     0, 
    0,   168,   100,     0,     0,   166,    99,     0,     0,   166,   102,     0,     0,   154,    78,   252,     0,   159,    75,   251,     0,   162,    76,   242,     0,   163,    83,   220, 
    0,   164,    89,   196,     0,   163,    91,   171,     0,   162,    94,   142,     0,   163,    99,   116,     0,   167,    97,    86,     0,   172,    96,    54,     0,   173,    94,    25, 
    0,   174,    91,     4,     0,   169,    91,     0,     0,   164,    91,     0,     0,   160,    91,     0,     0,   158,    90,     0,     0,   157,    93,     0,     0,   158,    57,   250, 
    0,   164,    53,   249,     0,   166,    55,   242,     0,   167,    62,   223,     0,   167,    68,   202,     0,   168,    70,   179,     0,   168,    72,   152,     0,   166,    77,   125, 
    0,   166,    76,    98,     0,   169,    75,    69,     0,   169,    77,    42,     0,   170,    76,    17,     0,   168,    75,     2,     0,   161,    77,     0,     0,   155,    78,     0, 
    0,   152,    79,     0,     0,   150,    81,     0,     0,   161,    37,   249,     0,   167,    33,   248,     0,   169,    36,   239,     0,   169,    43,   224,     0,   170,    48,   203, 
    0,   169,    51,   183,     0,   170,    54,   160,     0,   170,    57,   135,     0,   170,    58,   109,     0,   169,    57,    82,     0,   169,    59,    56,     0,   167,    60,    31, 
    0,   164,    61,    11,     0,   159,    64,     1,     0,   151,    65,     0,     0,   146,    66,     0,     0,   143,    69,     0,     0,   161,    21,   245,     0,   168,    16,   244, 
    0,   169,    20,   236,     0,   170,    25,   223,     0,   170,    31,   206,     0,   170,    33,   187,     0,   169,    36,   165,     0,   169,    39,   143,     0,   169,    41,   118, 
    0,   168,    41,    93,     0,   168,    41,    69,     0,   167,    43,    45,     0,   164,    43,    23,     0,   159,    46,     5,     0,   150,    51,     0,     0,   142,    55,     0, 
    0,   137,    58,     0,     0,   163,    14,   241,     0,   167,     6,   238,     0,   168,     7,   232,     0,   168,    10,   221,     0,   168,    15,   206,     0,   168,    18,   189, 
    0,   167,    21,   170,     0,   167,    23,   150,     0,   166,    25,   127,     0,   166,    25,   103,     0,   165,    25,    79,     0,   165,    25,    56,     0,   166,    27,    35, 
    0,   162,    29,    16,     0,   154,    33,     2,     0,   141,    40,     0,     0,   133,    46,     0,     0,   165,    10,   238,     0,   165,     1,   231,     0,   164,     1,   224, 
    0,   164,     1,   215,     0,   164,     3,   203,     0,   163,     4,   188,     0,   163,     7,   171,     0,   163,     9,   153,     0,   163,    10,   133,     0,   162,    11,   111, 
    0,   161,    11,    88,     0,   161,    11,    66,     0,   162,    11,    44,     0,   161,    13,    25,     0,   155,    16,     9,     0,   144,    23,     1,     0,   132,    34,     0, 
    0,   166,     7,   235,     0,   162,     1,   222,     0,   159,     0,   213,     0,   157,     0,   203,     0,   155,     0,   190,     0,   154,     0,   177,     0,   154,     0,   165, 
    0,   154,     1,   150,     0,   155,     1,   133,     0,   154,     1,   115,     0,   154,     1,    95,     0,   154,     1,    74,     0,   153,     1,    52,     0,   153,     1,    32, 
    0,   150,     4,    15,     0,   145,     8,     3,     0,   132,    22,     0,     0,   167,     4,   233,     0,   160,     0,   217,     0,   154,     0,   205,     0,   149,     0,   191, 
    0,   145,     0,   177,     0,   143,     0,   164,     0,   142,     0,   153,     0,   142,     0,   141,     0,   142,     0,   128,     0,   141,     0,   113,     0,   140,     0,    96, 
    0,   140,     0,    79,     0,   139,     0,    60,     0,   139,     0,    41,     0,   137,     0,    24,     0,   136,     2,    10,     0,   129,    11,     0,     0,   167,     2,   231, 
    0,   158,     0,   214,     0,   151,     0,   199,     0,   145,     0,   184,     0,   139,     0,   168,     0,   134,     0,   153,     0,   133,     0,   143,     0,   133,     0,   133, 
    0,   132,     0,   122,     0,   130,     0,   109,     0,   129,     0,    95,     0,   128,     0,    81,     0,   127,     0,    65,     0,   126,     0,    47,     0,   125,     0,    31, 
    0,   123,     1,    16,     0,   123,     5,     0,     0,   166,     0,   228,     0,   161,     0,   217,     0,   155,     0,   204,     0,   150,     0,   189,     0,   145,     0,   174, 
    0,   139,     0,   157,     0,   138,     0,   149,     0,   137,     0,   138,     0,   136,     0,   126,     0,   133,     0,   114,     0,   131,     0,   101,     0,   129,     0,    87, 
    0,   127,     0,    71,     0,   126,     0,    53,     0,   125,     0,    33,     0,   122,     0,    16,     0,   119,     0,     0,     0,   108,   214,   242,     0,    97,   232,   212, 
    0,    93,   243,   185,     0,    93,   248,   148,     0,    97,   246,   104,     0,    98,   238,    66,     0,    98,   233,    35,     0,   111,   218,    11,     0,   130,   204,    10, 
    0,   144,   195,     8,     0,   155,   187,     6,     0,   163,   180,     4,     0,   169,   175,     4,     0,   173,   169,     4,     0,   177,   164,     4,     0,   180,   160,     2, 
    0,   183,   156,     0,     0,   121,   193,   248,     0,   113,   203,   235,     0,   111,   211,   205,     0,   110,   218,   177,     0,   112,   220,   128,     0,   112,   218,    85, 
    0,   114,   214,    42,     0,   123,   205,     6,     0,   138,   193,     1,     0,   149,   183,     1,     0,   157,   174,     1,     0,   162,   167,     0,     0,   166,   161,     0, 
    0,   170,   157,     0,     0,   173,   153,     0,     0,   176,   151,     0,     0,   179,   151,     0,     0,   127,   177,   251,     0,   123,   183,   244,     0,   126,   190,   206, 
    0,   122,   194,   186,     0,   121,   198,   148,     0,   121,   200,   110,     0,   123,   197,    66,     0,   130,   193,    24,     0,   141,   185,     2,     0,   150,   175,     0, 
    0,   156,   167,     0,     0,   161,   159,     0,     0,   164,   153,     0,     0,   166,   149,     0,     0,   169,   145,     0,     0,   171,   143,     0,     0,   174,   145,     0, 
    0,   128,   158,   251,     0,   128,   158,   250,     0,   130,   169,   213,     0,   131,   173,   188,     0,   130,   177,   164,     0,   126,   183,   132,     0,   129,   180,    85, 
    0,   135,   176,    45,     0,   142,   172,    12,     0,   149,   165,     1,     0,   155,   157,     0,     0,   158,   150,     0,     0,   160,   144,     0,     0,   162,   140,     0, 
    0,   165,   136,     0,     0,   167,   134,     0,     0,   169,   136,     0,     0,   130,   145,   233,     0,   131,   144,   231,     0,   132,   149,   210,     0,   136,   151,   189, 
    0,   138,   156,   168,     0,   133,   161,   144,     0,   134,   161,   101,     0,   138,   158,    63,     0,   143,   155,    27,     0,   148,   151,     3,     0,   153,   144,     0, 
    0,   155,   139,     0,     0,   157,   134,     0,     0,   159,   130,     0,     0,   161,   126,     0,     0,   162,   124,     0,     0,   164,   127,     0,     0,   124,   125,   244, 
    0,   127,   124,   237,     0,   130,   128,   217,     0,   134,   132,   193,     0,   137,   135,   172,     0,   135,   138,   153,     0,   136,   140,   116,     0,   140,   137,    79, 
    0,   146,   135,    45,     0,   150,   131,    14,     0,   154,   127,     1,     0,   155,   123,     0,     0,   157,   119,     0,     0,   157,   115,     0,     0,   157,   113,     0, 
    0,   157,   111,     0,     0,   159,   114,     0,     0,   124,   102,   254,     0,   129,   101,   250,     0,   131,   104,   235,     0,   134,   111,   207,     0,   136,   115,   180, 
    0,   137,   117,   159,     0,   138,   113,   132,     0,   143,   113,    96,     0,   150,   112,    65,     0,   156,   109,    33,     0,   161,   106,     6,     0,   162,   103,     0, 
    0,   161,   101,     0,     0,   159,    99,     0,     0,   157,    97,     0,     0,   155,    96,     0,     0,   158,    96,     0,     0,   132,    81,   253,     0,   136,    79,   252, 
    0,   138,    81,   242,     0,   141,    88,   219,     0,   141,    94,   193,     0,   142,    97,   169,     0,   144,    95,   141,     0,   145,    97,   112,     0,   148,    97,    83, 
    0,   152,    97,    52,     0,   155,    95,    23,     0,   157,    90,     3,     0,   155,    90,     0,     0,   152,    90,     0,     0,   149,    89,     0,     0,   148,    88,     0, 
    0,   148,    90,     0,     0,   138,    61,   251,     0,   144,    58,   251,     0,   146,    60,   243,     0,   148,    68,   223,     0,   149,    74,   202,     0,   151,    76,   179, 
    0,   151,    75,   153,     0,   149,    80,   125,     0,   148,    81,    98,     0,   150,    81,    70,     0,   152,    80,    40,     0,   154,    77,    16,     0,   152,    76,     2, 
    0,   147,    77,     0,     0,   144,    76,     0,     0,   142,    77,     0,     0,   142,    80,     0,     0,   143,    41,   250,     0,   149,    38,   249,     0,   151,    41,   239, 
    0,   152,    48,   223,     0,   154,    54,   203,     0,   156,    57,   184,     0,   156,    59,   162,     0,   155,    61,   137,     0,   153,    64,   109,     0,   152,    64,    83, 
    0,   153,    63,    56,     0,   152,    62,    30,     0,   151,    63,     9,     0,   146,    64,     1,     0,   141,    63,     0,     0,   137,    63,     0,     0,   136,    65,     0, 
    0,   146,    24,   248,     0,   152,    21,   246,     0,   154,    25,   236,     0,   156,    31,   221,     0,   156,    36,   204,     0,   156,    39,   186,     0,   156,    42,   166, 
    0,   156,    43,   143,     0,   155,    45,   119,     0,   154,    45,    93,     0,   154,    45,    69,     0,   153,    46,    44,     0,   151,    46,    20,     0,   147,    49,     4, 
    0,   139,    52,     0,     0,   133,    53,     0,     0,   130,    55,     0,     0,   149,    15,   243,     0,   154,     9,   240,     0,   156,    11,   232,     0,   156,    16,   220, 
    0,   156,    20,   205,     0,   156,    22,   188,     0,   155,    24,   169,     0,   155,    26,   148,     0,   154,    28,   126,     0,   154,    28,   102,     0,   152,    28,    79, 
    0,   152,    29,    55,     0,   151,    31,    33,     0,   148,    31,    14,     0,   141,    35,     2,     0,   131,    39,     0,     0,   125,    45,     0,     0,   153,    10,   240, 
    0,   155,     2,   233,     0,   155,     2,   225,     0,   155,     4,   216,     0,   154,     7,   203,     0,   154,     8,   187,     0,   153,     9,   170,     0,   153,    11,   151, 
    0,   152,    12,   131,     0,   151,    13,   109,     0,   150,    13,    87,     0,   150,    14,    66,     0,   149,    14,    43,     0,   148,    17,    24,     0,   143,    19,     7, 
    0,   134,    24,     1,     0,   122,    34,     0,     0,   156,     7,   237,     0,   154,     1,   224,     0,   152,     0,   215,     0,   150,     0,   205,     0,   148,     1,   193, 
    0,   147,     1,   179,     0,   146,     1,   165,     0,   146,     1,   149,     0,   146,     1,   132,     0,   145,     2,   113,     0,   145,     2,    93,     0,   144,     3,    73, 
    0,   144,     3,    52,     0,   143,     3,    31,     0,   141,     6,    14,     0,   136,     9,     2,     0,   122,    22,     0,     0,   158,     5,   234,     0,   153,     0,   217, 
    0,   148,     0,   205,     0,   143,     0,   192,     0,   139,     0,   178,     0,   136,     0,   164,     0,   134,     0,   150,     0,   133,     0,   138,     0,   133,     0,   125, 
    0,   132,     0,   110,     0,   132,     0,    94,     0,   131,     0,    77,     0,   131,     0,    59,     0,   130,     0,    40,     0,   129,     0,    23,     0,   127,     3,     9, 
    0,   120,    12,     0,     0,   160,     2,   232,     0,   152,     0,   214,     0,   145,     0,   199,     0,   139,     0,   184,     0,   133,     0,   168,     0,   128,     0,   151, 
    0,   124,     0,   137,     0,   123,     0,   127,     0,   122,     0,   116,     0,   121,     0,   105,     0,   120,     0,    92,     0,   119,     0,    78,     0,   118,     0,    63, 
    0,   117,     0,    46,     0,   116,     0,    30,     0,   114,     1,    15,     0,   114,     5,     0,     0,   160,     0,   229,     0,   155,     0,   218,     0,   149,     0,   205, 
    0,   144,     0,   190,     0,   139,     0,   174,     0,   133,     0,   157,     0,   127,     0,   139,     0,   126,     0,   130,     0,   125,     0,   119,     0,   123,     0,   109, 
    0,   121,     0,    97,     0,   119,     0,    84,     0,   117,     0,    69,     0,   116,     0,    51,     0,   114,     0,    32,     0,   112,     0,    15,     0,   109,     0,     0, 
    0,    79,   219,   242,     0,    70,   235,   210,     0,    67,   244,   183,     0,    67,   248,   151,     0,    69,   245,   109,     0,    74,   242,    66,     0,    77,   234,    32, 
    0,    81,   227,     9,     0,   101,   212,     2,     0,   120,   201,     2,     0,   135,   194,     2,     0,   146,   187,     2,     0,   154,   182,     2,     0,   161,   176,     3, 
    0,   165,   171,     2,     0,   169,   166,     2,     0,   172,   162,     0,     0,    97,   194,   248,     0,    90,   202,   239,     0,    90,   207,   209,     0,    88,   215,   182, 
    0,    89,   219,   138,     0,    93,   216,   100,     0,    94,   214,    55,     0,    97,   210,    12,     0,   112,   198,     1,     0,   128,   187,     0,     0,   139,   179,     0, 
    0,   147,   173,     0,     0,   153,   167,     0,     0,   157,   162,     0,     0,   161,   158,     0,     0,   165,   155,     0,     0,   167,   156,     0,     0,   103,   179,   250, 
    0,    99,   181,   247,     0,   104,   189,   208,     0,   101,   194,   189,     0,   100,   199,   155,     0,   102,   200,   118,     0,   103,   199,    78,     0,   106,   195,    37, 
    0,   116,   189,     4,     0,   129,   179,     0,     0,   139,   171,     0,     0,   145,   164,     0,     0,   150,   158,     0,     0,   154,   153,     0,     0,   157,   149,     0, 
    0,   159,   147,     0,     0,   162,   149,     0,     0,   108,   158,   252,     0,   106,   160,   249,     0,   110,   171,   217,     0,   108,   175,   190,     0,   108,   178,   168, 
    0,   108,   182,   138,     0,   109,   184,    94,     0,   111,   181,    53,     0,   119,   177,    15,     0,   129,   169,     1,     0,   137,   161,     0,     0,   143,   154,     0, 
    0,   147,   149,     0,     0,   150,   144,     0,     0,   152,   139,     0,     0,   154,   137,     0,     0,   157,   140,     0,     0,   111,   149,   234,     0,   113,   148,   232, 
    0,   115,   151,   217,     0,   116,   154,   192,     0,   119,   157,   169,     0,   116,   161,   147,     0,   114,   167,   110,     0,   116,   164,    71,     0,   121,   160,    31, 
    0,   129,   155,     3,     0,   136,   148,     0,     0,   140,   142,     0,     0,   143,   137,     0,     0,   146,   133,     0,     0,   148,   128,     0,     0,   150,   126,     0, 
    0,   152,   129,     0,     0,   108,   128,   245,     0,   113,   128,   234,     0,   115,   133,   214,     0,   117,   135,   193,     0,   121,   135,   172,     0,   121,   140,   153, 
    0,   117,   145,   127,     0,   116,   146,    90,     0,   124,   143,    48,     0,   129,   138,    14,     0,   134,   133,     1,     0,   137,   128,     0,     0,   140,   124,     0, 
    0,   142,   120,     0,     0,   143,   116,     0,     0,   144,   114,     0,     0,   146,   117,     0,     0,   109,   105,   254,     0,   110,   108,   241,     0,   113,   113,   219, 
    0,   116,   117,   198,     0,   120,   118,   175,     0,   122,   118,   153,     0,   121,   120,   132,     0,   120,   123,   101,     0,   128,   123,    63,     0,   133,   120,    29, 
    0,   136,   115,     4,     0,   138,   112,     0,     0,   139,   108,     0,     0,   140,   105,     0,     0,   140,   102,     0,     0,   140,   100,     0,     0,   142,   102,     0, 
    0,   108,    85,   254,     0,   109,    87,   251,     0,   112,    90,   236,     0,   115,    96,   214,     0,   119,   100,   189,     0,   121,   101,   162,     0,   123,    99,   140, 
    0,   125,    96,   115,     0,   131,   100,    80,     0,   136,    98,    48,     0,   140,    94,    20,     0,   143,    90,     3,     0,   142,    89,     0,     0,   141,    87,     0, 
    0,   140,    85,     0,     0,   139,    83,     0,     0,   142,    82,     0,     0,   116,    66,   253,     0,   120,    63,   252,     0,   123,    65,   243,     0,   125,    73,   223, 
    0,   127,    79,   200,     0,   129,    81,   174,     0,   130,    81,   150,     0,   132,    82,   124,     0,   132,    84,    96,     0,   134,    84,    67,     0,   137,    81,    38, 
    0,   140,    77,    13,     0,   139,    75,     1,     0,   136,    76,     0,     0,   135,    74,     0,     0,   133,    73,     0,     0,   134,    75,     0,     0,   123,    46,   251, 
    0,   128,    43,   250,     0,   130,    46,   241,     0,   132,    53,   224,     0,   135,    59,   204,     0,   138,    62,   184,     0,   138,    64,   162,     0,   138,    65,   136, 
    0,   136,    67,   108,     0,   135,    69,    82,     0,   136,    68,    56,     0,   137,    65,    28,     0,   137,    62,     7,     0,   134,    61,     0,     0,   130,    60,     0, 
    0,   128,    60,     0,     0,   127,    64,     0,     0,   128,    28,   250,     0,   134,    26,   247,     0,   136,    30,   236,     0,   138,    36,   220,     0,   140,    40,   203, 
    0,   141,    44,   186,     0,   142,    47,   167,     0,   141,    48,   145,     0,   141,    49,   120,     0,   138,    51,    94,     0,   138,    52,    69,     0,   139,    50,    42, 
    0,   137,    48,    18,     0,   134,    49,     2,     0,   128,    51,     0,     0,   123,    53,     0,     0,   121,    54,     0,     0,   133,    17,   245,     0,   138,    13,   242, 
    0,   141,    15,   232,     0,   142,    21,   218,     0,   142,    24,   203,     0,   142,    27,   186,     0,   142,    29,   168,     0,   141,    30,   147,     0,   140,    31,   125, 
    0,   140,    32,   101,     0,   139,    32,    78,     0,   139,    33,    54,     0,   138,    34,    32,     0,   135,    34,    12,     0,   128,    36,     1,     0,   120,    40,     0, 
    0,   115,    45,     0,     0,   139,    11,   241,     0,   141,     4,   235,     0,   142,     5,   227,     0,   143,     8,   215,     0,   143,    11,   202,     0,   142,    12,   186, 
    0,   141,    13,   169,     0,   140,    14,   150,     0,   139,    16,   129,     0,   139,    16,   108,     0,   138,    17,    86,     0,   137,    17,    64,     0,   137,    18,    42, 
    0,   135,    21,    23,     0,   132,    20,     6,     0,   122,    26,     0,     0,   111,    34,     0,     0,   144,     8,   239,     0,   143,     1,   227,     0,   142,     0,   218, 
    0,   141,     1,   208,     0,   140,     1,   196,     0,   139,     1,   182,     0,   137,     2,   166,     0,   136,     2,   149,     0,   135,     3,   131,     0,   135,     4,   111, 
    0,   134,     5,    91,     0,   133,     5,    72,     0,   133,     6,    51,     0,   132,     6,    31,     0,   131,     8,    14,     0,   124,    11,     2,     0,   111,    23,     0, 
    0,   148,     5,   236,     0,   144,     0,   219,     0,   140,     0,   207,     0,   136,     0,   193,     0,   132,     0,   179,     0,   129,     0,   165,     0,   126,     0,   150, 
    0,   124,     0,   135,     0,   124,     0,   122,     0,   123,     0,   107,     0,   123,     0,    92,     0,   123,     0,    75,     0,   122,     0,    57,     0,   122,     0,    39, 
    0,   120,     0,    22,     0,   119,     3,     8,     0,   110,    12,     0,     0,   151,     2,   233,     0,   145,     0,   215,     0,   138,     0,   200,     0,   132,     0,   184, 
    0,   126,     0,   167,     0,   121,     0,   151,     0,   116,     0,   136,     0,   113,     0,   122,     0,   112,     0,   111,     0,   112,     0,   100,     0,   111,     0,    89, 
    0,   110,     0,    76,     0,   109,     0,    61,     0,   108,     0,    44,     0,   107,     0,    29,     0,   105,     1,    15,     0,   104,     5,     0,     0,   153,     0,   231, 
    0,   148,     0,   219,     0,   143,     0,   207,     0,   137,     0,   191,     0,   132,     0,   174,     0,   126,     0,   156,     0,   120,     0,   138,     0,   114,     0,   121, 
    0,   113,     0,   111,     0,   112,     0,   102,     0,   110,     0,    93,     0,   108,     0,    81,     0,   106,     0,    67,     0,   105,     0,    50,     0,   104,     0,    31, 
    0,   101,     0,    14,     0,    99,     0,     0,     0,    49,   227,   241,     0,    41,   239,   213,     0,    41,   245,   184,     0,    42,   247,   157,     0,    46,   244,   125, 
    0,    54,   240,    83,     0,    61,   236,    45,     0,    65,   230,    15,     0,    72,   224,     0,     0,    94,   210,     0,     0,   113,   200,     0,     0,   127,   193,     0, 
    0,   137,   187,     0,     0,   146,   182,     1,     0,   153,   177,     1,     0,   158,   172,     1,     0,   162,   167,     0,     0,    73,   197,   248,     0,    68,   202,   240, 
    0,    70,   204,   212,     0,    68,   211,   186,     0,    67,   219,   147,     0,    73,   214,   111,     0,    77,   214,    72,     0,    76,   213,    23,     0,    85,   204,     1, 
    0,   103,   192,     0,     0,   118,   183,     0,     0,   129,   176,     0,     0,   138,   171,     0,     0,   144,   167,     0,     0,   149,   163,     0,     0,   153,   160,     0, 
    0,   157,   161,     0,     0,    80,   180,   250,     0,    81,   183,   246,     0,    83,   192,   214,     0,    81,   194,   191,     0,    79,   200,   158,     0,    82,   201,   126, 
    0,    84,   201,    89,     0,    85,   198,    47,     0,    90,   195,     9,     0,   105,   184,     0,     0,   119,   174,     0,     0,   128,   166,     0,     0,   135,   160,     0, 
    0,   141,   157,     0,     0,   145,   154,     0,     0,   148,   151,     0,     0,   151,   154,     0,     0,    88,   160,   252,     0,    86,   161,   251,     0,    89,   172,   217, 
    0,    90,   180,   193,     0,    89,   181,   171,     0,    89,   184,   145,     0,    91,   186,   104,     0,    91,   185,    65,     0,    94,   181,    25,     0,   106,   174,     2, 
    0,   118,   164,     0,     0,   127,   156,     0,     0,   133,   150,     0,     0,   137,   146,     0,     0,   140,   142,     0,     0,   143,   140,     0,     0,   146,   144,     0, 
    0,    90,   148,   248,     0,    94,   147,   242,     0,    95,   151,   222,     0,    96,   157,   195,     0,    98,   159,   171,     0,    97,   163,   151,     0,    97,   168,   116, 
    0,    96,   169,    80,     0,    98,   166,    39,     0,   106,   161,     5,     0,   117,   152,     0,     0,   124,   144,     0,     0,   129,   138,     0,     0,   133,   133,     0, 
    0,   136,   130,     0,     0,   138,   128,     0,     0,   141,   132,     0,     0,    91,   131,   248,     0,    96,   134,   230,     0,    99,   138,   213,     0,   101,   138,   195, 
    0,   102,   140,   174,     0,   104,   140,   152,     0,   103,   144,   128,     0,    99,   148,    97,     0,   103,   148,    54,     0,   109,   144,    18,     0,   116,   138,     1, 
    0,   122,   131,     0,     0,   127,   125,     0,     0,   130,   121,     0,     0,   132,   117,     0,     0,   135,   115,     0,     0,   137,   118,     0,     0,    94,   107,   254, 
    0,    96,   113,   235,     0,   101,   118,   210,     0,   103,   121,   193,     0,   105,   124,   176,     0,   107,   120,   152,     0,   109,   123,   132,     0,   104,   127,   107, 
    0,   107,   129,    67,     0,   112,   127,    31,     0,   116,   123,     4,     0,   121,   117,     0,     0,   125,   112,     0,     0,   127,   108,     0,     0,   129,   104,     0, 
    0,   130,   102,     0,     0,   132,   104,     0,     0,    93,    88,   255,     0,    94,    93,   243,     0,    97,    98,   224,     0,   100,   102,   205,     0,   103,   104,   183, 
    0,   107,   103,   157,     0,   109,   102,   135,     0,   108,   106,   115,     0,   111,   108,    81,     0,   115,   109,    47,     0,   119,   104,    16,     0,   123,   100,     2, 
    0,   124,    96,     0,     0,   125,    92,     0,     0,   126,    89,     0,     0,   126,    87,     0,     0,   128,    88,     0,     0,    91,    70,   254,     0,    97,    68,   251, 
    0,   100,    72,   240,     0,   103,    78,   220,     0,   105,    82,   197,     0,   109,    84,   171,     0,   111,    84,   144,     0,   112,    85,   124,     0,   113,    86,   101, 
    0,   118,    87,    65,     0,   123,    82,    34,     0,   126,    77,     9,     0,   127,    74,     1,     0,   126,    72,     0,     0,   125,    70,     0,     0,   124,    69,     0, 
    0,   126,    67,     0,     0,   100,    51,   253,     0,   105,    48,   252,     0,   108,    50,   243,     0,   110,    58,   225,     0,   113,    64,   203,     0,   115,    67,   181, 
    0,   116,    68,   155,     0,   117,    69,   132,     0,   118,    70,   108,     0,   120,    71,    80,     0,   121,    70,    53,     0,   123,    65,    25,     0,   124,    60,     4, 
    0,   122,    61,     0,     0,   119,    61,     0,     0,   118,    61,     0,     0,   118,    62,     0,     0,   108,    32,   251,     0,   112,    31,   249,     0,   115,    34,   238, 
    0,   118,    40,   222,     0,   121,    45,   204,     0,   123,    48,   186,     0,   124,    51,   165,     0,   124,    52,   143,     0,   124,    53,   119,     0,   122,    54,    92, 
    0,   122,    57,    68,     0,   122,    54,    42,     0,   122,    50,    16,     0,   120,    50,     2,     0,   116,    51,     0,     0,   113,    51,     0,     0,   112,    53,     0, 
    0,   114,    18,   247,     0,   120,    16,   244,     0,   123,    19,   234,     0,   125,    25,   219,     0,   126,    29,   203,     0,   127,    32,   186,     0,   127,    33,   167, 
    0,   126,    34,   147,     0,   125,    35,   125,     0,   124,    36,   101,     0,   122,    38,    78,     0,   123,    40,    55,     0,   124,    37,    30,     0,   121,    36,     9, 
    0,   115,    38,     1,     0,   109,    41,     0,     0,   106,    45,     0,     0,   123,    12,   243,     0,   125,     6,   238,     0,   128,     7,   229,     0,   129,    12,   216, 
    0,   129,    14,   201,     0,   129,    16,   186,     0,   128,    17,   168,     0,   126,    19,   149,     0,   125,    20,   129,     0,   125,    20,   108,     0,   124,    21,    86, 
    0,   123,    21,    63,     0,   124,    22,    41,     0,   123,    23,    20,     0,   119,    22,     4,     0,   110,    28,     0,     0,   101,    34,     0,     0,   130,     8,   240, 
    0,   130,     1,   231,     0,   130,     1,   221,     0,   130,     2,   210,     0,   129,     3,   197,     0,   128,     3,   183,     0,   126,     4,   166,     0,   124,     5,   148, 
    0,   123,     5,   129,     0,   123,     6,   110,     0,   122,     7,    91,     0,   122,     8,    71,     0,   121,     8,    49,     0,   121,     8,    29,     0,   120,    11,    13, 
    0,   112,    13,     1,     0,   100,    24,     0,     0,   136,     5,   238,     0,   134,     0,   221,     0,   131,     0,   208,     0,   127,     0,   194,     0,   123,     0,   180, 
    0,   120,     0,   166,     0,   118,     0,   151,     0,   115,     0,   136,     0,   114,     0,   120,     0,   114,     0,   105,     0,   114,     1,    90,     0,   113,     1,    74, 
    0,   113,     1,    55,     0,   113,     1,    37,     0,   111,     1,    20,     0,   110,     4,     7,     0,    99,    13,     0,     0,   141,     3,   235,     0,   136,     0,   216, 
    0,   130,     0,   199,     0,   124,     0,   183,     0,   118,     0,   167,     0,   113,     0,   151,     0,   109,     0,   136,     0,   105,     0,   121,     0,   103,     0,   107, 
    0,   102,     0,    96,     0,   101,     0,    85,     0,   101,     0,    72,     0,   100,     0,    58,     0,    99,     0,    42,     0,    98,     0,    27,     0,    96,     1,    14, 
    0,    94,     5,     0,     0,   144,     0,   232,     0,   139,     0,   221,     0,   135,     0,   208,     0,   129,     0,   192,     0,   124,     0,   173,     0,   118,     0,   155, 
    0,   112,     0,   137,     0,   106,     0,   120,     0,   101,     0,   103,     0,    99,     0,    95,     0,    98,     0,    86,     0,    96,     0,    76,     0,    95,     0,    63, 
    0,    93,     0,    47,     0,    92,     0,    30,     0,    90,     0,    13,     0,    88,     0,     0,     0,    25,   228,   235,     0,    19,   238,   213,     0,    18,   244,   183, 
    0,    21,   246,   158,     0,    26,   243,   133,     0,    34,   241,    97,     0,    44,   240,    55,     0,    51,   235,    22,     0,    57,   230,     3,     0,    67,   222,     0, 
    0,    89,   210,     0,     0,   107,   200,     0,     0,   120,   193,     0,     0,   130,   187,     0,     0,   138,   182,     0,     0,   145,   177,     0,     0,   151,   173,     0, 
    0,    51,   200,   246,     0,    48,   202,   241,     0,    50,   203,   213,     0,    48,   211,   188,     0,    45,   220,   151,     0,    51,   216,   121,     0,    58,   212,    84, 
    0,    62,   211,    45,     0,    64,   208,     8,     0,    77,   198,     0,     0,    95,   188,     0,     0,   110,   180,     0,     0,   121,   174,     0,     0,   129,   169,     0, 
    0,   136,   166,     0,     0,   142,   165,     0,     0,   146,   166,     0,     0,    61,   182,   250,     0,    60,   182,   248,     0,    65,   189,   216,     0,    61,   192,   193, 
    0,    58,   200,   160,     0,    61,   201,   133,     0,    66,   200,    97,     0,    68,   198,    61,     0,    69,   196,    21,     0,    79,   189,     2,     0,    96,   178,     0, 
    0,   109,   169,     0,     0,   119,   163,     0,     0,   126,   158,     0,     0,   132,   155,     0,     0,   136,   154,     0,     0,   140,   157,     0,     0,    68,   163,   251, 
    0,    67,   165,   251,     0,    72,   175,   220,     0,    71,   181,   195,     0,    70,   182,   172,     0,    71,   184,   151,     0,    72,   185,   120,     0,    71,   187,    86, 
    0,    74,   184,    35,     0,    80,   179,     4,     0,    96,   168,     0,     0,   108,   159,     0,     0,   117,   152,     0,     0,   123,   147,     0,     0,   127,   143,     0, 
    0,   131,   141,     0,     0,   134,   147,     0,     0,    73,   145,   251,     0,    75,   143,   252,     0,    77,   157,   226,     0,    78,   163,   201,     0,    81,   163,   173, 
    0,    80,   166,   155,     0,    80,   167,   128,     0,    79,   170,    98,     0,    81,   168,    48,     0,    83,   165,    11,     0,    96,   157,     1,     0,   107,   148,     0, 
    0,   115,   141,     0,     0,   119,   135,     0,     0,   124,   131,     0,     0,   127,   129,     0,     0,   129,   134,     0,     0,    74,   130,   252,     0,    78,   137,   240, 
    0,    83,   138,   216,     0,    85,   141,   204,     0,    85,   146,   181,     0,    85,   144,   152,     0,    86,   147,   133,     0,    84,   149,   105,     0,    85,   151,    61, 
    0,    87,   149,    24,     0,    96,   143,     2,     0,   106,   136,     0,     0,   112,   129,     0,     0,   117,   124,     0,     0,   121,   119,     0,     0,   124,   117,     0, 
    0,   126,   120,     0,     0,    77,   109,   254,     0,    81,   117,   235,     0,    85,   124,   212,     0,    87,   126,   196,     0,    88,   126,   180,     0,    89,   128,   158, 
    0,    93,   126,   133,     0,    90,   129,   111,     0,    88,   133,    74,     0,    89,   132,    37,     0,    95,   128,     5,     0,   105,   122,     0,     0,   111,   116,     0, 
    0,   115,   111,     0,     0,   118,   107,     0,     0,   121,   104,     0,     0,   123,   106,     0,     0,    78,    89,   254,     0,    81,    96,   238,     0,    85,   102,   220, 
    0,    88,   106,   204,     0,    90,   108,   183,     0,    91,   110,   160,     0,    94,   108,   140,     0,    94,   109,   116,     0,    90,   113,    89,     0,    89,   116,    56, 
    0,    98,   111,    18,     0,   105,   107,     1,     0,   109,   102,     0,     0,   112,    98,     0,     0,   114,    94,     0,     0,   116,    91,     0,     0,   118,    91,     0, 
    0,    76,    72,   255,     0,    81,    73,   248,     0,    84,    77,   234,     0,    84,    86,   214,     0,    88,    90,   191,     0,    91,    91,   169,     0,    94,    90,   143, 
    0,    97,    91,   122,     0,    93,    93,    98,     0,    93,    95,    68,     0,   101,    91,    31,     0,   105,    88,     6,     0,   108,    84,     0,     0,   109,    81,     0, 
    0,   110,    77,     0,     0,   110,    75,     0,     0,   112,    74,     0,     0,    75,    56,   254,     0,    82,    53,   252,     0,    84,    56,   241,     0,    83,    65,   223, 
    0,    87,    70,   201,     0,    90,    71,   179,     0,    93,    71,   152,     0,    96,    73,   129,     0,    98,    74,   109,     0,    99,    74,    87,     0,   104,    71,    49, 
    0,   107,    66,    19,     0,   109,    64,     2,     0,   109,    62,     0,     0,   108,    61,     0,     0,   107,    59,     0,     0,   109,    57,     0,     0,    84,    38,   253, 
    0,    89,    36,   251,     0,    92,    38,   240,     0,    95,    44,   224,     0,    99,    49,   205,     0,   101,    53,   185,     0,   102,    54,   162,     0,   103,    56,   138, 
    0,   103,    57,   116,     0,   104,    59,    93,     0,   105,    61,    66,     0,   106,    55,    38,     0,   108,    51,    13,     0,   107,    49,     1,     0,   104,    51,     0, 
    0,   101,    51,     0,     0,   101,    52,     0,     0,    93,    22,   250,     0,    98,    20,   247,     0,   102,    23,   237,     0,   104,    29,   220,     0,   106,    33,   204, 
    0,   108,    36,   187,     0,   109,    37,   167,     0,   109,    38,   145,     0,   108,    40,   124,     0,   106,    42,   101,     0,   105,    43,    77,     0,   107,    46,    54, 
    0,   107,    41,    29,     0,   107,    38,     6,     0,   102,    40,     0,     0,    98,    41,     0,     0,    96,    43,     0,     0,   103,    12,   245,     0,   107,     8,   241, 
    0,   110,    10,   232,     0,   111,    16,   217,     0,   112,    18,   202,     0,   113,    20,   185,     0,   113,    21,   168,     0,   112,    22,   148,     0,   110,    23,   128, 
    0,   108,    26,   106,     0,   107,    26,    85,     0,   107,    27,    63,     0,   109,    28,    41,     0,   110,    26,    18,     0,   105,    26,     2,     0,    97,    30,     0, 
    0,    91,    34,     0,     0,   114,     8,   242,     0,   115,     2,   234,     0,   115,     2,   225,     0,   116,     5,   212,     0,   115,     6,   198,     0,   115,     6,   182, 
    0,   113,     8,   165,     0,   112,     8,   147,     0,   111,     9,   129,     0,   110,    10,   110,     0,   110,    10,    91,     0,   109,    10,    70,     0,   109,    11,    48, 
    0,   109,    11,    28,     0,   108,    13,    10,     0,    99,    16,     1,     0,    88,    25,     0,     0,   122,     5,   239,     0,   121,     1,   225,     0,   119,     0,   211, 
    0,   116,     0,   196,     0,   113,     0,   182,     0,   111,     0,   168,     0,   108,     1,   153,     0,   106,     1,   138,     0,   105,     1,   122,     0,   104,     1,   105, 
    0,   104,     1,    90,     0,   104,     1,    73,     0,   104,     1,    54,     0,   103,     1,    35,     0,   102,     1,    18,     0,   100,     4,     4,     0,    87,    14,     0, 
    0,   129,     3,   236,     0,   125,     0,   217,     0,   120,     0,   200,     0,   115,     0,   183,     0,   109,     0,   166,     0,   104,     0,   151,     0,   100,     0,   136, 
    0,    97,     0,   121,     0,    94,     0,   106,     0,    92,     0,    93,     0,    91,     0,    82,     0,    91,     0,    69,     0,    90,     0,    55,     0,    90,     0,    40, 
    0,    88,     0,    26,     0,    87,     1,    13,     0,    83,     6,     0,     0,   134,     0,   234,     0,   130,     0,   221,     0,   125,     0,   208,     0,   120,     0,   192, 
    0,   115,     0,   173,     0,   109,     0,   155,     0,   103,     0,   137,     0,    97,     0,   119,     0,    92,     0,   102,     0,    86,     0,    85,     0,    85,     0,    78, 
    0,    84,     0,    69,     0,    83,     0,    58,     0,    81,     0,    44,     0,    80,     0,    28,     0,    78,     0,    13,     0,    76,     0,     0,     0,    14,   224,   227, 
    0,     9,   231,   211,     0,     7,   239,   184,     0,     8,   242,   160,     0,    12,   243,   137,     0,    18,   243,   107,     0,    27,   243,    65,     0,    37,   240,    29, 
    0,    45,   235,     8,     0,    53,   227,     0,     0,    63,   222,     0,     0,    83,   210,     0,     0,   100,   200,     0,     0,   113,   193,     0,     0,   124,   187,     0, 
    0,   132,   182,     0,     0,   139,   178,     0,     0,    28,   202,   240,     0,    29,   202,   239,     0,    32,   202,   213,     0,    30,   210,   191,     0,    26,   220,   154, 
    0,    31,   217,   128,     0,    39,   214,    94,     0,    46,   212,    57,     0,    49,   209,    25,     0,    56,   204,     3,     0,    70,   194,     0,     0,    87,   185,     0, 
    0,   102,   178,     0,     0,   113,   173,     0,     0,   121,   169,     0,     0,   128,   167,     0,     0,   133,   169,     0,     0,    37,   186,   246,     0,    42,   183,   246, 
    0,    47,   186,   216,     0,    42,   192,   194,     0,    39,   202,   162,     0,    42,   202,   137,     0,    45,   200,   106,     0,    50,   198,    69,     0,    53,   196,    33, 
    0,    57,   193,     4,     0,    71,   183,     0,     0,    88,   173,     0,     0,   101,   166,     0,     0,   111,   161,     0,     0,   118,   158,     0,     0,   123,   156,     0, 
    0,   128,   160,     0,     0,    48,   167,   249,     0,    50,   166,   247,     0,    53,   171,   221,     0,    52,   178,   195,     0,    51,   180,   173,     0,    53,   182,   153, 
    0,    55,   183,   127,     0,    55,   185,    95,     0,    58,   184,    44,     0,    60,   182,     8,     0,    72,   172,     0,     0,    88,   162,     0,     0,   100,   155,     0, 
    0,   108,   150,     0,     0,   114,   146,     0,     0,   118,   144,     0,     0,   122,   149,     0,     0,    57,   146,   251,     0,    57,   147,   249,     0,    58,   156,   228, 
    0,    61,   164,   202,     0,    62,   164,   174,     0,    64,   166,   155,     0,    66,   166,   134,     0,    63,   169,   104,     0,    65,   169,    57,     0,    66,   167,    19, 
    0,    74,   161,     1,     0,    88,   151,     0,     0,    98,   143,     0,     0,   105,   138,     0,     0,   110,   134,     0,     0,   114,   132,     0,     0,   117,   137,     0, 
    0,    59,   130,   252,     0,    61,   132,   246,     0,    66,   142,   227,     0,    67,   148,   209,     0,    67,   151,   186,     0,    69,   149,   154,     0,    70,   150,   135, 
    0,    68,   152,   109,     0,    70,   154,    67,     0,    70,   152,    30,     0,    75,   148,     3,     0,    88,   139,     0,     0,    96,   131,     0,     0,   103,   126,     0, 
    0,   108,   122,     0,     0,   112,   119,     0,     0,   114,   124,     0,     0,    60,   113,   253,     0,    64,   118,   237,     0,    70,   127,   213,     0,    72,   129,   201, 
    0,    74,   130,   185,     0,    74,   135,   163,     0,    74,   131,   134,     0,    72,   133,   114,     0,    73,   136,    79,     0,    72,   137,    45,     0,    74,   134,    11, 
    0,    86,   125,     1,     0,    95,   119,     0,     0,   101,   113,     0,     0,   105,   109,     0,     0,   109,   106,     0,     0,   111,   110,     0,     0,    63,    92,   254, 
    0,    66,    98,   238,     0,    70,   105,   219,     0,    72,   112,   202,     0,    75,   115,   182,     0,    77,   115,   163,     0,    78,   116,   141,     0,    79,   111,   116, 
    0,    76,   114,    94,     0,    72,   120,    65,     0,    76,   116,    24,     0,    84,   111,     2,     0,    93,   105,     0,     0,    98,   100,     0,     0,   102,    95,     0, 
    0,   105,    92,     0,     0,   107,    94,     0,     0,    63,    74,   254,     0,    67,    76,   243,     0,    71,    82,   227,     0,    72,    90,   206,     0,    78,    91,   180, 
    0,    80,    94,   164,     0,    80,    93,   139,     0,    82,    95,   123,     0,    81,    94,    97,     0,    77,    99,    74,     0,    79,    97,    35,     0,    84,    93,     6, 
    0,    90,    89,     0,     0,    95,    84,     0,     0,    97,    80,     0,     0,    98,    76,     0,     0,   100,    76,     0,     0,    61,    58,   254,     0,    66,    59,   246, 
    0,    69,    63,   233,     0,    69,    71,   214,     0,    72,    74,   194,     0,    75,    76,   176,     0,    77,    77,   152,     0,    82,    78,   128,     0,    83,    78,   106, 
    0,    80,    82,    84,     0,    82,    80,    49,     0,    84,    75,    18,     0,    89,    72,     2,     0,    91,    68,     0,     0,    92,    65,     0,     0,    92,    63,     0, 
    0,    93,    62,     0,     0,    59,    43,   254,     0,    67,    41,   250,     0,    71,    43,   238,     0,    74,    49,   221,     0,    78,    52,   203,     0,    79,    55,   183, 
    0,    80,    57,   161,     0,    83,    59,   136,     0,    85,    61,   113,     0,    84,    62,    94,     0,    84,    63,    74,     0,    88,    56,    34,     0,    92,    53,     9, 
    0,    92,    51,     0,     0,    91,    50,     0,     0,    91,    49,     0,     0,    91,    46,     0,     0,    70,    26,   253,     0,    75,    24,   250,     0,    80,    26,   240, 
    0,    83,    33,   222,     0,    85,    37,   205,     0,    86,    40,   187,     0,    88,    41,   167,     0,    89,    42,   145,     0,    89,    45,   121,     0,    87,    47,   100, 
    0,    88,    46,    78,     0,    90,    47,    51,     0,    91,    42,    24,     0,    92,    40,     4,     0,    90,    40,     0,     0,    87,    40,     0,     0,    84,    40,     0, 
    0,    80,    13,   249,     0,    85,    12,   245,     0,    89,    14,   234,     0,    91,    20,   219,     0,    93,    23,   203,     0,    94,    25,   187,     0,    95,    25,   168, 
    0,    95,    26,   148,     0,    94,    27,   127,     0,    91,    30,   105,     0,    90,    30,    83,     0,    90,    30,    61,     0,    92,    32,    39,     0,    93,    29,    17, 
    0,    90,    29,     2,     0,    85,    31,     0,     0,    80,    33,     0,     0,    93,     8,   245,     0,    96,     3,   237,     0,    97,     4,   228,     0,    98,     8,   215, 
    0,    99,     9,   200,     0,    99,    10,   183,     0,    98,    11,   165,     0,    97,    12,   147,     0,    97,    12,   129,     0,    96,    13,   110,     0,    94,    15,    89, 
    0,    93,    15,    69,     0,    93,    16,    48,     0,    95,    17,    28,     0,    94,    16,     8,     0,    86,    19,     1,     0,    76,    25,     0,     0,   105,     5,   241, 
    0,   105,     1,   229,     0,   104,     0,   217,     0,   102,     1,   203,     0,   101,     1,   188,     0,   100,     1,   173,     0,    98,     1,   157,     0,    96,     1,   141, 
    0,    95,     1,   125,     0,    94,     1,   108,     0,    93,     2,    90,     0,    93,     2,    73,     0,    93,     3,    54,     0,    92,     3,    34,     0,    93,     3,    16, 
    0,    88,     6,     3,     0,    74,    15,     0,     0,   115,     2,   238,     0,   112,     0,   221,     0,   108,     0,   204,     0,   104,     0,   186,     0,    99,     0,   168, 
    0,    95,     0,   151,     0,    92,     0,   136,     0,    88,     0,   122,     0,    86,     0,   107,     0,    83,     0,    93,     0,    82,     0,    79,     0,    81,     0,    67, 
    0,    81,     0,    53,     0,    80,     0,    38,     0,    79,     0,    24,     0,    78,     1,    12,     0,    70,     6,     0,     0,   121,     0,   236,     0,   118,     0,   224, 
    0,   114,     0,   211,     0,   110,     0,   193,     0,   105,     0,   174,     0,    99,     0,   155,     0,    94,     0,   136,     0,    88,     0,   119,     0,    83,     0,   100, 
    0,    77,     0,    84,     0,    72,     0,    69,     0,    70,     0,    61,     0,    69,     0,    52,     0,    68,     0,    40,     0,    67,     0,    27,     0,    65,     0,    13, 
    0,    64,     0,     0,     0,     9,   222,   219,     0,     6,   228,   209,     0,     5,   233,   189,     0,     5,   238,   166,     0,     8,   240,   145,     0,    12,   241,   119, 
    0,    17,   242,    83,     0,    27,   241,    44,     0,    35,   238,    17,     0,    43,   233,     4,     0,    51,   226,     0,     0,    58,   221,     0,     0,    78,   210,     0, 
    0,    94,   200,     0,     0,   107,   193,     0,     0,   117,   187,     0,     0,   126,   181,     0,     0,    17,   200,   229,     0,    15,   202,   234,     0,    15,   204,   214, 
    0,    15,   210,   193,     0,    12,   218,   158,     0,    16,   218,   131,     0,    23,   215,   106,     0,    30,   212,    68,     0,    36,   211,    35,     0,    41,   208,     9, 
    0,    51,   200,     1,     0,    64,   192,     0,     0,    80,   183,     0,     0,    95,   177,     0,     0,   105,   173,     0,     0,   114,   171,     0,     0,   120,   173,     0, 
    0,    24,   185,   238,     0,    24,   184,   243,     0,    24,   190,   219,     0,    23,   196,   195,     0,    21,   203,   165,     0,    24,   203,   140,     0,    27,   201,   115, 
    0,    33,   200,    79,     0,    38,   198,    41,     0,    42,   195,    11,     0,    52,   188,     1,     0,    65,   179,     0,     0,    81,   170,     0,     0,    94,   164,     0, 
    0,   103,   161,     0,     0,   109,   159,     0,     0,   115,   164,     0,     0,    33,   168,   245,     0,    33,   167,   246,     0,    33,   173,   225,     0,    32,   180,   198, 
    0,    33,   182,   175,     0,    35,   184,   156,     0,    35,   185,   133,     0,    37,   185,   101,     0,    42,   184,    53,     0,    45,   182,    19,     0,    54,   176,     1, 
    0,    67,   166,     0,     0,    81,   158,     0,     0,    92,   152,     0,     0,    99,   148,     0,     0,   105,   147,     0,     0,   109,   153,     0,     0,    42,   148,   249, 
    0,    40,   149,   249,     0,    39,   156,   231,     0,    41,   165,   205,     0,    43,   165,   175,     0,    43,   166,   157,     0,    44,   169,   136,     0,    44,   171,   109, 
    0,    48,   171,    64,     0,    50,   170,    28,     0,    55,   164,     2,     0,    68,   154,     0,     0,    81,   145,     0,     0,    90,   139,     0,     0,    96,   135,     0, 
    0,   101,   133,     0,     0,   104,   140,     0,     0,    46,   131,   251,     0,    46,   131,   248,     0,    47,   136,   232,     0,    48,   149,   210,     0,    48,   155,   188, 
    0,    50,   152,   156,     0,    50,   153,   138,     0,    50,   156,   114,     0,    52,   155,    73,     0,    53,   155,    38,     0,    55,   152,     5,     0,    68,   143,     0, 
    0,    79,   133,     0,     0,    87,   127,     0,     0,    94,   122,     0,     0,    99,   120,     0,     0,   100,   126,     0,     0,    46,   115,   252,     0,    49,   119,   238, 
    0,    53,   128,   218,     0,    54,   133,   208,     0,    55,   137,   192,     0,    57,   140,   166,     0,    56,   135,   136,     0,    55,   138,   117,     0,    56,   138,    83, 
    0,    57,   140,    51,     0,    57,   138,    17,     0,    65,   131,     1,     0,    77,   121,     0,     0,    85,   114,     0,     0,    91,   109,     0,     0,    96,   107,     0, 
    0,    97,   111,     0,     0,    48,    97,   253,     0,    51,   103,   235,     0,    55,   114,   214,     0,    57,   116,   199,     0,    60,   118,   183,     0,    62,   117,   167, 
    0,    61,   119,   142,     0,    61,   116,   119,     0,    59,   117,    97,     0,    57,   120,    71,     0,    58,   121,    31,     0,    61,   117,     4,     0,    73,   108,     0, 
    0,    82,   101,     0,     0,    88,    95,     0,     0,    92,    92,     0,     0,    93,    95,     0,     0,    51,    77,   253,     0,    53,    83,   235,     0,    57,    90,   217, 
    0,    60,    93,   202,     0,    62,    95,   182,     0,    63,    98,   162,     0,    66,    98,   143,     0,    66,   100,   125,     0,    66,    97,    98,     0,    62,   100,    78, 
    0,    60,   103,    43,     0,    61,    99,    12,     0,    71,    92,     1,     0,    79,    86,     0,     0,    84,    81,     0,     0,    86,    78,     0,     0,    87,    78,     0, 
    0,    50,    61,   253,     0,    50,    68,   235,     0,    54,    73,   219,     0,    57,    76,   207,     0,    60,    78,   191,     0,    64,    79,   173,     0,    66,    81,   151, 
    0,    68,    82,   129,     0,    69,    82,   106,     0,    66,    83,    85,     0,    62,    87,    60,     0,    60,    84,    30,     0,    68,    78,     4,     0,    76,    72,     0, 
    0,    79,    68,     0,     0,    80,    65,     0,     0,    81,    64,     0,     0,    47,    45,   254,     0,    52,    46,   244,     0,    55,    49,   231,     0,    59,    54,   214, 
    0,    61,    57,   200,     0,    60,    63,   183,     0,    63,    65,   158,     0,    66,    66,   136,     0,    69,    67,   111,     0,    69,    67,    90,     0,    65,    68,    67, 
    0,    64,    66,    39,     0,    71,    61,    10,     0,    74,    57,     1,     0,    76,    55,     0,     0,    76,    52,     0,     0,    76,    51,     0,     0,    44,    31,   254, 
    0,    53,    29,   249,     0,    57,    32,   237,     0,    61,    37,   219,     0,    63,    39,   203,     0,    60,    43,   187,     0,    62,    47,   166,     0,    65,    48,   145, 
    0,    67,    49,   120,     0,    70,    51,    98,     0,    70,    50,    78,     0,    70,    48,    59,     0,    73,    43,    21,     0,    76,    41,     2,     0,    76,    39,     0, 
    0,    76,    38,     0,     0,    75,    37,     0,     0,    55,    16,   253,     0,    62,    15,   249,     0,    67,    17,   239,     0,    70,    22,   222,     0,    72,    25,   204, 
    0,    73,    27,   188,     0,    74,    29,   169,     0,    74,    30,   149,     0,    74,    31,   127,     0,    74,    33,   104,     0,    72,    33,    83,     0,    73,    32,    61, 
    0,    76,    33,    36,     0,    76,    31,    13,     0,    76,    30,     1,     0,    73,    30,     0,     0,    69,    31,     0,     0,    70,     9,   249,     0,    73,     5,   243, 
    0,    76,     7,   232,     0,    79,    11,   218,     0,    79,    13,   202,     0,    80,    14,   185,     0,    80,    15,   168,     0,    80,    16,   149,     0,    81,    16,   129, 
    0,    80,    17,   109,     0,    78,    19,    88,     0,    75,    19,    67,     0,    76,    19,    46,     0,    78,    21,    26,     0,    78,    19,     7,     0,    72,    21,     0, 
    0,    64,    24,     0,     0,    84,     5,   245,     0,    85,     1,   235,     0,    86,     1,   224,     0,    85,     2,   211,     0,    85,     3,   196,     0,    84,     3,   179, 
    0,    83,     4,   160,     0,    83,     4,   142,     0,    83,     4,   126,     0,    82,     4,   109,     0,    80,     5,    91,     0,    79,     6,    72,     0,    78,     7,    53, 
    0,    78,     7,    33,     0,    79,     7,    15,     0,    74,     9,     2,     0,    62,    16,     0,     0,    96,     2,   241,     0,    95,     0,   225,     0,    93,     0,   211, 
    0,    90,     0,   194,     0,    87,     0,   176,     0,    84,     0,   157,     0,    81,     0,   139,     0,    79,     0,   123,     0,    76,     0,   108,     0,    74,     0,    94, 
    0,    72,     0,    79,     0,    71,     0,    65,     0,    71,     1,    52,     0,    70,     1,    36,     0,    69,     0,    22,     0,    68,     2,    10,     0,    58,     7,     0, 
    0,   106,     0,   238,     0,   103,     0,   227,     0,   100,     0,   215,     0,    97,     0,   199,     0,    93,     0,   178,     0,    88,     0,   157,     0,    83,     0,   137, 
    0,    78,     0,   118,     0,    72,     0,    98,     0,    67,     0,    82,     0,    61,     0,    66,     0,    58,     0,    55,     0,    57,     0,    46,     0,    56,     0,    36, 
    0,    55,     0,    25,     0,    54,     0,    13,     0,    53,     0,     0,     0,     6,   221,   212,     0,     5,   224,   207,     0,     5,   228,   194,     0,     5,   232,   172, 
    0,     6,   235,   153,     0,     9,   236,   132,     0,    13,   238,   104,     0,    20,   239,    66,     0,    28,   238,    34,     0,    35,   235,    13,     0,    41,   231,     3, 
    0,    48,   225,     0,     0,    53,   221,     0,     0,    72,   210,     0,     0,    88,   200,     0,     0,   101,   193,     0,     0,   111,   186,     0,     0,    12,   199,   220, 
    0,     4,   206,   216,     0,     2,   210,   201,     0,     3,   213,   182,     0,     5,   215,   162,     0,     8,   215,   138,     0,    12,   214,   115,     0,    18,   213,    82, 
    0,    24,   212,    46,     0,    30,   210,    19,     0,    36,   205,     3,     0,    47,   198,     0,     0,    57,   190,     0,     0,    74,   183,     0,     0,    88,   178,     0, 
    0,    99,   175,     0,     0,   106,   177,     0,     0,    16,   183,   229,     0,     8,   190,   228,     0,     6,   198,   205,     0,     6,   201,   183,     0,     8,   202,   165, 
    0,    10,   203,   144,     0,    13,   203,   119,     0,    18,   201,    88,     0,    24,   199,    52,     0,    29,   197,    21,     0,    36,   192,     2,     0,    48,   184,     0, 
    0,    59,   176,     0,     0,    74,   168,     0,     0,    87,   163,     0,     0,    94,   162,     0,     0,   100,   167,     0,     0,    22,   167,   237,     0,    17,   171,   238, 
    0,    14,   179,   217,     0,    15,   182,   197,     0,    17,   182,   177,     0,    17,   186,   158,     0,    18,   189,   126,     0,    21,   188,    97,     0,    27,   185,    60, 
    0,    31,   185,    28,     0,    37,   180,     3,     0,    50,   171,     0,     0,    61,   162,     0,     0,    75,   155,     0,     0,    83,   151,     0,     0,    90,   149,     0, 
    0,    95,   156,     0,     0,    28,   150,   244,     0,    24,   152,   246,     0,    22,   158,   228,     0,    24,   163,   203,     0,    25,   163,   174,     0,    24,   169,   158, 
    0,    24,   174,   131,     0,    26,   173,   106,     0,    31,   171,    70,     0,    34,   171,    37,     0,    37,   168,     7,     0,    50,   158,     0,     0,    62,   149,     0, 
    0,    73,   142,     0,     0,    81,   137,     0,     0,    87,   135,     0,     0,    90,   143,     0,     0,    34,   131,   249,     0,    32,   131,   248,     0,    31,   137,   231, 
    0,    30,   146,   206,     0,    30,   153,   185,     0,    31,   152,   156,     0,    31,   155,   139,     0,    31,   156,   118,     0,    34,   156,    79,     0,    37,   156,    47, 
    0,    38,   156,    15,     0,    48,   147,     1,     0,    60,   138,     0,     0,    70,   129,     0,     0,    79,   123,     0,     0,    85,   121,     0,     0,    86,   128,     0, 
    0,    34,   116,   251,     0,    35,   119,   239,     0,    38,   124,   221,     0,    39,   129,   208,     0,    37,   138,   190,     0,    37,   142,   166,     0,    38,   137,   137, 
    0,    37,   139,   119,     0,    38,   140,    88,     0,    39,   140,    57,     0,    40,   141,    26,     0,    44,   136,     3,     0,    56,   127,     0,     0,    67,   117,     0, 
    0,    76,   109,     0,     0,    82,   106,     0,     0,    82,   112,     0,     0,    34,   100,   251,     0,    37,   106,   231,     0,    41,   113,   211,     0,    41,   117,   201, 
    0,    43,   119,   188,     0,    45,   122,   171,     0,    44,   124,   145,     0,    43,   120,   119,     0,    42,   121,   100,     0,    41,   122,    74,     0,    43,   125,    37, 
    0,    42,   122,     7,     0,    53,   113,     0,     0,    65,   102,     0,     0,    73,    95,     0,     0,    78,    91,     0,     0,    78,    95,     0,     0,    38,    80,   252, 
    0,    40,    89,   228,     0,    45,    94,   209,     0,    45,    98,   197,     0,    46,    99,   180,     0,    47,   102,   165,     0,    50,   100,   147,     0,    49,   103,   126, 
    0,    48,   100,   101,     0,    45,   102,    80,     0,    45,   105,    48,     0,    44,   104,    18,     0,    50,    97,     1,     0,    62,    89,     0,     0,    69,    83,     0, 
    0,    73,    78,     0,     0,    73,    79,     0,     0,    40,    62,   253,     0,    40,    71,   231,     0,    43,    76,   215,     0,    45,    78,   204,     0,    46,    81,   190, 
    0,    49,    83,   171,     0,    50,    85,   146,     0,    53,    86,   129,     0,    52,    86,   106,     0,    53,    83,    84,     0,    48,    85,    63,     0,    46,    89,    38, 
    0,    49,    83,     7,     0,    59,    76,     0,     0,    66,    70,     0,     0,    69,    66,     0,     0,    68,    66,     0,     0,    37,    47,   253,     0,    41,    52,   237, 
    0,    43,    55,   224,     0,    45,    59,   209,     0,    46,    62,   196,     0,    47,    66,   174,     0,    53,    68,   146,     0,    54,    69,   131,     0,    54,    70,   106, 
    0,    56,    69,    87,     0,    53,    67,    65,     0,    50,    71,    45,     0,    53,    67,    16,     0,    58,    62,     1,     0,    63,    58,     0,     0,    65,    54,     0, 
    0,    64,    54,     0,     0,    33,    33,   255,     0,    39,    35,   242,     0,    43,    37,   229,     0,    45,    41,   213,     0,    47,    43,   198,     0,    45,    50,   183, 
    0,    48,    52,   162,     0,    50,    53,   141,     0,    52,    54,   118,     0,    55,    54,    94,     0,    55,    52,    74,     0,    51,    54,    51,     0,    53,    52,    23, 
    0,    57,    48,     3,     0,    61,    44,     0,     0,    61,    42,     0,     0,    60,    41,     0,     0,    31,    21,   255,     0,    40,    19,   247,     0,    45,    21,   237, 
    0,    48,    25,   220,     0,    50,    27,   202,     0,    51,    30,   187,     0,    53,    32,   169,     0,    53,    34,   149,     0,    54,    35,   127,     0,    56,    36,   103, 
    0,    57,    35,    80,     0,    55,    35,    62,     0,    54,    35,    45,     0,    58,    32,    10,     0,    60,    30,     1,     0,    60,    29,     0,     0,    58,    28,     0, 
    0,    45,    11,   253,     0,    49,     8,   247,     0,    54,     9,   238,     0,    57,    13,   223,     0,    58,    15,   207,     0,    59,    16,   190,     0,    60,    18,   172, 
    0,    59,    20,   153,     0,    61,    21,   131,     0,    61,    21,   110,     0,    60,    22,    88,     0,    59,    22,    67,     0,    60,    21,    46,     0,    62,    22,    23, 
    0,    62,    21,     4,     0,    58,    22,     0,     0,    54,    23,     0,     0,    61,     5,   250,     0,    62,     1,   241,     0,    64,     1,   231,     0,    65,     4,   216, 
    0,    65,     5,   201,     0,    66,     6,   185,     0,    66,     7,   165,     0,    66,     7,   146,     0,    67,     7,   128,     0,    66,     8,   109,     0,    65,     8,    91, 
    0,    63,     9,    71,     0,    62,    10,    51,     0,    63,     9,    32,     0,    64,    11,    14,     0,    59,    12,     2,     0,    51,    16,     0,     0,    75,     2,   245, 
    0,    75,     0,   231,     0,    74,     0,   219,     0,    72,     0,   202,     0,    71,     0,   186,     0,    70,     0,   168,     0,    68,     1,   148,     0,    67,     1,   128, 
    0,    65,     1,   110,     0,    63,     1,    95,     0,    62,     1,    80,     0,    61,     1,    66,     0,    60,     1,    51,     0,    60,     1,    36,     0,    59,     1,    21, 
    0,    58,     3,     8,     0,    48,     7,     0,     0,    88,     0,   241,     0,    85,     0,   232,     0,    83,     0,   221,     0,    81,     0,   206,     0,    78,     0,   186, 
    0,    75,     0,   164,     0,    71,     0,   141,     0,    66,     0,   119,     0,    61,     0,    96,     0,    55,     0,    78,     0,    51,     0,    65,     0,    48,     0,    53, 
    0,    47,     0,    45,     0,    47,     0,    35,     0,    47,     0,    25,     0,    46,     0,    13,     0,    43,     0,     0,     0,     4,   219,   208,     0,     4,   221,   205, 
    0,     4,   223,   195,     0,     4,   227,   176,     0,     5,   230,   159,     0,     8,   231,   141,     0,    11,   233,   119,     0,    15,   235,    88,     0,    22,   235,    54, 
    0,    29,   234,    28,     0,    34,   232,    11,     0,    39,   228,     3,     0,    44,   224,     0,     0,    48,   221,     0,     0,    67,   210,     0,     0,    82,   200,     0, 
    0,    95,   192,     0,     0,     9,   199,   214,     0,     1,   204,   208,     0,     0,   207,   196,     0,     0,   209,   180,     0,     1,   211,   165,     0,     3,   212,   146, 
    0,     6,   213,   122,     0,     9,   213,    96,     0,    15,   213,    61,     0,    20,   211,    31,     0,    25,   209,    10,     0,    34,   203,     1,     0,    43,   197,     0, 
    0,    52,   191,     0,     0,    67,   184,     0,     0,    81,   180,     0,     0,    89,   182,     0,     0,    10,   183,   221,     0,     2,   190,   218,     0,     1,   196,   199, 
    0,     0,   199,   179,     0,     1,   200,   165,     0,     2,   201,   148,     0,     4,   202,   123,     0,     7,   202,    98,     0,    12,   201,    64,     0,    17,   199,    31, 
    0,    23,   196,     7,     0,    35,   189,     0,     0,    45,   181,     0,     0,    54,   175,     0,     0,    68,   168,     0,     0,    78,   165,     0,     0,    84,   172,     0, 
    0,    15,   167,   229,     0,     7,   171,   229,     0,     4,   180,   210,     0,     3,   183,   194,     0,     3,   184,   176,     0,     5,   186,   159,     0,     5,   190,   129, 
    0,     7,   190,   103,     0,    12,   188,    71,     0,    17,   186,    37,     0,    22,   184,     9,     0,    35,   175,     0,     0,    46,   167,     0,     0,    55,   160,     0, 
    0,    66,   155,     0,     0,    74,   151,     0,     0,    79,   159,     0,     0,    19,   151,   236,     0,    14,   153,   238,     0,    10,   160,   221,     0,     9,   164,   202, 
    0,     8,   167,   176,     0,     8,   171,   158,     0,     9,   175,   133,     0,    10,   175,   110,     0,    13,   172,    79,     0,    18,   171,    47,     0,    22,   171,    17, 
    0,    31,   163,     1,     0,    44,   154,     0,     0,    53,   147,     0,     0,    63,   141,     0,     0,    72,   137,     0,     0,    75,   146,     0,     0,    24,   132,   244, 
    0,    20,   132,   246,     0,    17,   138,   230,     0,    15,   146,   207,     0,    14,   151,   182,     0,    14,   153,   158,     0,    15,   154,   139,     0,    15,   155,   120, 
    0,    17,   155,    86,     0,    20,   155,    55,     0,    23,   156,    25,     0,    27,   151,     3,     0,    41,   143,     0,     0,    51,   135,     0,     0,    61,   127,     0, 
    0,    70,   122,     0,     0,    71,   131,     0,     0,    25,   116,   248,     0,    23,   117,   242,     0,    23,   121,   229,     0,    22,   129,   210,     0,    20,   135,   189, 
    0,    19,   141,   165,     0,    21,   137,   137,     0,    20,   139,   120,     0,    20,   140,    91,     0,    22,   140,    63,     0,    23,   141,    34,     0,    24,   140,     6, 
    0,    37,   132,     0,     0,    48,   123,     0,     0,    59,   112,     0,     0,    67,   106,     0,     0,    67,   115,     0,     0,    25,   102,   247,     0,    24,   106,   231, 
    0,    25,   111,   214,     0,    26,   113,   203,     0,    27,   117,   192,     0,    27,   122,   171,     0,    26,   124,   144,     0,    27,   122,   120,     0,    25,   123,   101, 
    0,    25,   124,    79,     0,    26,   124,    44,     0,    26,   126,    15,     0,    34,   118,     1,     0,    46,   107,     0,     0,    57,    97,     0,     0,    64,    91,     0, 
    0,    63,    95,     0,     0,    26,    85,   250,     0,    26,    92,   226,     0,    28,    97,   204,     0,    29,    99,   195,     0,    30,   101,   182,     0,    32,   102,   167, 
    0,    32,   103,   150,     0,    32,   106,   126,     0,    32,   102,   100,     0,    29,   104,    83,     0,    29,   105,    52,     0,    28,   109,    25,     0,    31,   102,     2, 
    0,    44,    92,     0,     0,    54,    85,     0,     0,    60,    79,     0,     0,    58,    80,     0,     0,    29,    65,   252,     0,    28,    73,   230,     0,    30,    78,   213, 
    0,    32,    82,   201,     0,    32,    85,   187,     0,    33,    86,   165,     0,    35,    87,   147,     0,    37,    87,   131,     0,    36,    88,   106,     0,    36,    87,    85, 
    0,    33,    88,    64,     0,    29,    91,    42,     0,    31,    89,     9,     0,    42,    80,     0,     0,    52,    72,     0,     0,    57,    67,     0,     0,    55,    67,     0, 
    0,    29,    49,   253,     0,    32,    53,   236,     0,    33,    57,   223,     0,    30,    64,   205,     0,    33,    67,   189,     0,    36,    69,   169,     0,    38,    69,   143, 
    0,    38,    72,   130,     0,    39,    71,   106,     0,    40,    72,    87,     0,    40,    69,    65,     0,    35,    72,    47,     0,    35,    73,    20,     0,    39,    68,     2, 
    0,    49,    60,     0,     0,    54,    56,     0,     0,    52,    56,     0,     0,    26,    36,   254,     0,    29,    39,   238,     0,    31,    43,   223,     0,    28,    49,   207, 
    0,    30,    52,   190,     0,    33,    54,   174,     0,    35,    55,   156,     0,    37,    55,   134,     0,    40,    56,   115,     0,    41,    57,    92,     0,    43,    54,    72, 
    0,    38,    55,    52,     0,    37,    58,    31,     0,    35,    56,     9,     0,    46,    48,     1,     0,    50,    44,     0,     0,    47,    44,     0,     0,    24,    24,   255, 
    0,    28,    24,   239,     0,    31,    27,   224,     0,    33,    31,   211,     0,    35,    33,   195,     0,    36,    36,   181,     0,    37,    37,   164,     0,    34,    41,   146, 
    0,    36,    42,   123,     0,    39,    41,    99,     0,    42,    39,    76,     0,    40,    39,    57,     0,    38,    42,    36,     0,    37,    41,    13,     0,    44,    36,     1, 
    0,    46,    33,     0,     0,    44,    33,     0,     0,    21,    14,   255,     0,    28,    12,   244,     0,    33,    13,   234,     0,    36,    15,   220,     0,    37,    18,   205, 
    0,    38,    20,   188,     0,    39,    22,   171,     0,    35,    26,   155,     0,    37,    27,   132,     0,    39,    26,   108,     0,    41,    26,    85,     0,    42,    24,    64, 
    0,    42,    24,    46,     0,    39,    25,    33,     0,    44,    21,     4,     0,    44,    21,     0,     0,    43,    21,     0,     0,    37,     7,   253,     0,    39,     3,   245, 
    0,    41,     3,   237,     0,    42,     5,   224,     0,    43,     7,   209,     0,    44,     8,   194,     0,    45,     9,   174,     0,    45,    11,   154,     0,    46,    11,   133, 
    0,    46,    12,   112,     0,    47,    12,    91,     0,    46,    12,    71,     0,    46,    12,    51,     0,    48,    12,    33,     0,    49,    14,    13,     0,    45,    13,     1, 
    0,    40,    15,     0,     0,    52,     3,   249,     0,    52,     0,   238,     0,    51,     0,   227,     0,    51,     0,   215,     0,    51,     1,   199,     0,    51,     1,   183, 
    0,    50,     1,   163,     0,    50,     1,   141,     0,    50,     1,   121,     0,    49,     1,   101,     0,    49,     1,    84,     0,    49,     1,    69,     0,    48,     2,    53, 
    0,    49,     1,    36,     0,    50,     2,    20,     0,    49,     4,     5,     0,    39,     8,     0,     0,    67,     0,   244,     0,    64,     0,   236,     0,    62,     0,   228, 
    0,    61,     0,   215,     0,    60,     0,   195,     0,    58,     0,   174,     0,    55,     0,   149,     0,    52,     0,   123,     0,    47,     0,    95,     0,    43,     0,    76, 
    0,    41,     0,    64,     0,    39,     0,    53,     0,    38,     0,    45,     0,    38,     0,    36,     0,    38,     0,    26,     0,    38,     0,    14,     0,    35,     0,     0, 
    0,     3,   216,   204,     0,     3,   217,   202,     0,     3,   219,   195,     0,     4,   222,   180,     0,     5,   224,   164,     0,     7,   226,   149,     0,    10,   227,   130, 
    0,    13,   229,   107,     0,    18,   231,    76,     0,    24,   231,    48,     0,    29,   231,    26,     0,    33,   229,    11,     0,    37,   226,     4,     0,    40,   222,     0, 
    0,    44,   220,     0,     0,    61,   209,     0,     0,    76,   200,     0,     0,     6,   199,   209,     0,     1,   201,   203,     0,     0,   203,   194,     0,     0,   206,   178, 
    0,     0,   207,   166,     0,     1,   209,   151,     0,     2,   211,   130,     0,     4,   211,   106,     0,     8,   212,    75,     0,    14,   212,    44,     0,    18,   211,    20, 
    0,    23,   208,     4,     0,    32,   202,     1,     0,    39,   197,     0,     0,    46,   192,     0,     0,    61,   187,     0,     0,    71,   189,     0,     0,     7,   183,   215, 
    0,     1,   188,   209,     0,     0,   192,   194,     0,     0,   195,   175,     0,     0,   197,   162,     0,     0,   198,   148,     0,     0,   199,   130,     0,     1,   200,   105, 
    0,     3,   201,    76,     0,     8,   200,    41,     0,    12,   199,    16,     0,    20,   194,     2,     0,    32,   187,     0,     0,    40,   180,     0,     0,    47,   175,     0, 
    0,    57,   172,     0,     0,    65,   178,     0,     0,    10,   168,   222,     0,     3,   172,   220,     0,     0,   178,   202,     0,     0,   182,   178,     0,     0,   184,   160, 
    0,     0,   186,   148,     0,     0,   187,   131,     0,     0,   188,   109,     0,     1,   188,    83,     0,     5,   187,    50,     0,     9,   186,    20,     0,    16,   181,     2, 
    0,    29,   173,     0,     0,    38,   166,     0,     0,    45,   161,     0,     0,    55,   157,     0,     0,    61,   166,     0,     0,    12,   152,   227,     0,     6,   155,   229, 
    0,     2,   161,   212,     0,     1,   166,   188,     0,     1,   170,   162,     0,     1,   172,   147,     0,     1,   173,   132,     0,     1,   174,   113,     0,     1,   173,    88, 
    0,     4,   172,    58,     0,     7,   171,    27,     0,    12,   168,     4,     0,    26,   159,     0,     0,    36,   153,     0,     0,    43,   147,     0,     0,    54,   143,     0, 
    0,    57,   152,     0,     0,    15,   134,   234,     0,    11,   135,   237,     0,     7,   141,   222,     0,     4,   149,   199,     0,     2,   154,   173,     0,     1,   154,   152, 
    0,     2,   154,   137,     0,     2,   155,   121,     0,     3,   156,    92,     0,     5,   155,    63,     0,     7,   155,    34,     0,    10,   154,     8,     0,    22,   146,     0, 
    0,    33,   139,     0,     0,    42,   133,     0,     0,    52,   127,     0,     0,    54,   137,     0,     0,    17,   117,   241,     0,    15,   116,   242,     0,    12,   121,   230, 
    0,     9,   130,   209,     0,     7,   136,   184,     0,     5,   137,   161,     0,     5,   136,   137,     0,     5,   138,   119,     0,     6,   139,    93,     0,     7,   139,    70, 
    0,     8,   138,    42,     0,    10,   139,    15,     0,    18,   133,     1,     0,    31,   125,     0,     0,    41,   116,     0,     0,    51,   109,     0,     0,    50,   119,     0, 
    0,    16,   104,   241,     0,    14,   105,   231,     0,    13,   109,   218,     0,    13,   112,   206,     0,    12,   116,   191,     0,    10,   121,   170,     0,    10,   126,   145, 
    0,    10,   122,   118,     0,    10,   122,   101,     0,    10,   123,    82,     0,    11,   123,    50,     0,    11,   124,    24,     0,    16,   120,     3,     0,    30,   109,     0, 
    0,    40,   100,     0,     0,    49,    93,     0,     0,    47,    98,     0,     0,    17,    89,   244,     0,    14,    94,   224,     0,    15,    97,   204,     0,    15,    98,   194, 
    0,    15,   100,   183,     0,    17,   102,   170,     0,    16,   104,   150,     0,    16,   106,   126,     0,    16,   104,   101,     0,    14,   106,    84,     0,    14,   106,    57, 
    0,    13,   107,    33,     0,    14,   107,     6,     0,    28,    95,     0,     0,    39,    87,     0,     0,    46,    80,     0,     0,    44,    81,     0,     0,    18,    69,   248, 
    0,    16,    76,   230,     0,    17,    81,   213,     0,    18,    85,   195,     0,    18,    86,   179,     0,    19,    88,   163,     0,    20,    88,   148,     0,    22,    88,   132, 
    0,    21,    89,   105,     0,    20,    90,    85,     0,    18,    90,    67,     0,    15,    92,    46,     0,    16,    94,    15,     0,    25,    83,     1,     0,    37,    75,     0, 
    0,    44,    69,     0,     0,    42,    69,     0,     0,    20,    51,   251,     0,    22,    53,   240,     0,    21,    59,   225,     0,    19,    67,   200,     0,    22,    70,   182, 
    0,    23,    72,   165,     0,    22,    74,   146,     0,    24,    74,   130,     0,    25,    74,   112,     0,    25,    74,    87,     0,    24,    73,    67,     0,    20,    75,    48, 
    0,    18,    78,    23,     0,    21,    73,     3,     0,    34,    64,     0,     0,    42,    58,     0,     0,    39,    58,     0,     0,    19,    38,   252,     0,    20,    41,   235, 
    0,    21,    46,   220,     0,    18,    52,   202,     0,    20,    55,   185,     0,    22,    57,   172,     0,    23,    58,   155,     0,    25,    58,   133,     0,    26,    59,   110, 
    0,    27,    59,    91,     0,    27,    58,    72,     0,    27,    57,    51,     0,    22,    60,    33,     0,    20,    62,    13,     0,    32,    52,     1,     0,    39,    47,     0, 
    0,    36,    47,     0,     0,    17,    27,   253,     0,    19,    29,   235,     0,    20,    33,   219,     0,    21,    36,   204,     0,    22,    38,   191,     0,    23,    41,   177, 
    0,    24,    43,   162,     0,    22,    45,   139,     0,    27,    44,   112,     0,    28,    43,    92,     0,    29,    44,    74,     0,    29,    42,    54,     0,    27,    43,    38, 
    0,    24,    46,    19,     0,    30,    40,     2,     0,    34,    36,     0,     0,    31,    36,     0,     0,    16,    16,   255,     0,    18,    18,   233,     0,    20,    21,   218, 
    0,    22,    23,   204,     0,    23,    25,   192,     0,    24,    26,   178,     0,    24,    28,   163,     0,    20,    31,   146,     0,    23,    31,   124,     0,    24,    31,   101, 
    0,    26,    30,    80,     0,    28,    28,    59,     0,    29,    28,    42,     0,    25,    32,    25,     0,    28,    29,     4,     0,    31,    25,     0,     0,    29,    25,     0, 
    0,    14,     9,   255,     0,    19,     7,   242,     0,    21,     7,   231,     0,    23,     8,   220,     0,    24,    11,   206,     0,    25,    12,   190,     0,    26,    13,   170, 
    0,    26,    14,   152,     0,    28,    14,   133,     0,    28,    15,   112,     0,    29,    15,    90,     0,    30,    14,    68,     0,    30,    15,    48,     0,    30,    16,    33, 
    0,    27,    17,    22,     0,    31,    14,     0,     0,    29,    13,     0,     0,    29,     3,   253,     0,    30,     1,   244,     0,    29,     0,   235,     0,    28,     1,   225, 
    0,    28,     2,   211,     0,    29,     2,   195,     0,    30,     2,   176,     0,    30,     3,   153,     0,    31,     3,   132,     0,    31,     4,   110,     0,    32,     4,    91, 
    0,    33,     3,    72,     0,    33,     4,    54,     0,    33,     4,    37,     0,    38,     3,    20,     0,    36,     4,     0,     0,    29,     8,     0,     0,    45,     0,   248, 
    0,    42,     0,   241,     0,    40,     0,   234,     0,    39,     0,   224,     0,    38,     0,   206,     0,    37,     0,   185,     0,    36,     0,   161,     0,    35,     0,   134, 
    0,    32,     0,   101,     0,    30,     0,    81,     0,    29,     0,    66,     0,    28,     0,    55,     0,    28,     0,    46,     0,    28,     0,    37,     0,    28,     0,    28, 
    0,    29,     0,    15,     0,    27,     0,     0,     0,     1,   213,   201,     0,     2,   214,   199,     0,     2,   215,   193,     0,     4,   217,   181,     0,     5,   219,   168, 
    0,     7,   220,   155,     0,     9,   222,   139,     0,    12,   223,   120,     0,    16,   225,    96,     0,    21,   227,    70,     0,    25,   228,    46,     0,    29,   228,    26, 
    0,    32,   226,    13,     0,    35,   224,     6,     0,    37,   222,     2,     0,    39,   220,     0,     0,    56,   209,     0,     0,     3,   198,   205,     0,     0,   200,   199, 
    0,     0,   201,   190,     0,     0,   203,   177,     0,     0,   205,   167,     0,     1,   207,   154,     0,     1,   208,   137,     0,     2,   210,   115,     0,     5,   211,    90, 
    0,    10,   211,    62,     0,    14,   211,    37,     0,    19,   210,    18,     0,    23,   208,     6,     0,    30,   203,     3,     0,    35,   199,     1,     0,    40,   196,     1, 
    0,    48,   197,     0,     0,     3,   183,   209,     0,     0,   186,   203,     0,     0,   189,   186,     0,     0,   192,   171,     0,     0,   194,   159,     0,     0,   195,   148, 
    0,     0,   196,   134,     0,     0,   197,   114,     0,     0,   199,    89,     0,     2,   200,    58,     0,     4,   201,    29,     0,     8,   200,     9,     0,    16,   194,     3, 
    0,    25,   188,     1,     0,    31,   184,     1,     0,    36,   181,     0,     0,    43,   187,     0,     0,     5,   168,   215,     0,     1,   172,   210,     0,     0,   176,   193, 
    0,     0,   179,   169,     0,     0,   181,   152,     0,     0,   183,   143,     0,     0,   183,   131,     0,     0,   184,   116,     0,     0,   185,    93,     0,     0,   186,    65, 
    0,     1,   186,    33,     0,     3,   186,    10,     0,    11,   181,     2,     0,    21,   174,     0,     0,    28,   168,     0,     0,    34,   166,     0,     0,    38,   174,     0, 
    0,     6,   153,   220,     0,     2,   156,   219,     0,     0,   161,   201,     0,     0,   165,   177,     0,     0,   167,   152,     0,     0,   168,   138,     0,     0,   169,   128, 
    0,     0,   169,   115,     0,     0,   169,    95,     0,     0,   169,    71,     0,     1,   170,    41,     0,     2,   170,    14,     0,    10,   165,     2,     0,    20,   158,     0, 
    0,    28,   153,     0,     0,    33,   150,     0,     0,    35,   160,     0,     0,     7,   135,   226,     0,     4,   138,   226,     0,     1,   144,   211,     0,     0,   149,   188, 
    0,     0,   152,   162,     0,     0,   151,   142,     0,     0,   150,   130,     0,     0,   151,   119,     0,     0,   152,    95,     0,     0,   152,    73,     0,     1,   152,    48, 
    0,     1,   152,    20,     0,     8,   149,     3,     0,    19,   142,     0,     0,    27,   137,     0,     0,    32,   134,     0,     0,    33,   143,     0,     0,     9,   117,   233, 
    0,     7,   118,   234,     0,     4,   124,   223,     0,     1,   131,   202,     0,     1,   136,   175,     0,     0,   136,   152,     0,     0,   134,   128,     0,     0,   135,   113, 
    0,     0,   136,    93,     0,     1,   135,    76,     0,     1,   135,    53,     0,     1,   136,    27,     0,     5,   135,     5,     0,    17,   127,     0,     0,    27,   120,     0, 
    0,    32,   115,     0,     0,    31,   124,     0,     0,     8,   104,   234,     0,     6,   106,   229,     0,     4,   109,   219,     0,     3,   113,   207,     0,     2,   117,   188, 
    0,     1,   120,   164,     0,     1,   123,   138,     0,     1,   120,   113,     0,     1,   120,    99,     0,     1,   120,    84,     0,     1,   120,    57,     0,     1,   120,    33, 
    0,     3,   120,     9,     0,    15,   111,     2,     0,    26,   102,     0,     0,    32,    96,     0,     0,    29,   102,     0,     0,     8,    91,   237,     0,     5,    95,   224, 
    0,     4,    97,   211,     0,     4,    99,   200,     0,     3,   101,   188,     0,     3,   103,   172,     0,     2,   106,   149,     0,     0,   109,   127,     0,     1,   104,   100, 
    0,     2,   105,    83,     0,     1,   106,    58,     0,     1,   105,    38,     0,     2,   105,    15,     0,    13,    98,     3,     0,    24,    89,     0,     0,    31,    82,     0, 
    0,    27,    84,     0,     0,     9,    74,   241,     0,     6,    79,   230,     0,     5,    84,   215,     0,     5,    86,   199,     0,     5,    88,   184,     0,     5,    90,   170, 
    0,     6,    90,   155,     0,     6,    91,   134,     0,     6,    91,   106,     0,     5,    91,    83,     0,     4,    91,    67,     0,     2,    92,    49,     0,     2,    92,    22, 
    0,     9,    88,     4,     0,    22,    78,     0,     0,    29,    71,     0,     0,    26,    72,     0,     0,    10,    54,   246,     0,    11,    56,   239,     0,    10,    61,   227, 
    0,     7,    70,   204,     0,     7,    74,   185,     0,     7,    76,   167,     0,     9,    75,   143,     0,    10,    76,   131,     0,    12,    75,   112,     0,    11,    77,    87, 
    0,    11,    75,    68,     0,     7,    78,    50,     0,     4,    79,    26,     0,     5,    79,     6,     0,    19,    68,     1,     0,    27,    61,     0,     0,    25,    61,     0, 
    0,    10,    39,   249,     0,    12,    41,   238,     0,    12,    46,   224,     0,     9,    54,   205,     0,     9,    57,   188,     0,     9,    60,   173,     0,    11,    61,   154, 
    0,    11,    63,   133,     0,    13,    62,   110,     0,    14,    61,    93,     0,    13,    61,    71,     0,    11,    62,    51,     0,     8,    63,    34,     0,     5,    65,    17, 
    0,    17,    58,     3,     0,    26,    50,     0,     0,    23,    49,     0,     0,     9,    29,   249,     0,    10,    34,   229,     0,    10,    38,   214,     0,    10,    40,   202, 
    0,    11,    41,   190,     0,    12,    43,   176,     0,    13,    45,   162,     0,    12,    47,   137,     0,    15,    46,   111,     0,    15,    47,    92,     0,    16,    47,    75, 
    0,    16,    46,    54,     0,    16,    45,    35,     0,    11,    49,    21,     0,    15,    46,     4,     0,    21,    40,     0,     0,    20,    39,     0,     0,     8,    18,   253, 
    0,    10,    24,   226,     0,    10,    28,   210,     0,    10,    29,   199,     0,    10,    30,   187,     0,    11,    31,   174,     0,    11,    32,   161,     0,     8,    35,   139, 
    0,    11,    34,   115,     0,    13,    34,    95,     0,    16,    32,    76,     0,    16,    32,    59,     0,    17,    32,    40,     0,    12,    35,    24,     0,    11,    37,     8, 
    0,    15,    32,     2,     0,    16,    29,     0,     0,     8,    10,   255,     0,    10,    16,   224,     0,    10,    18,   208,     0,    10,    18,   197,     0,    11,    19,   186, 
    0,    11,    19,   173,     0,    12,    19,   160,     0,    12,    19,   143,     0,    13,    20,   122,     0,    10,    22,   103,     0,    12,    21,    82,     0,    14,    20,    63, 
    0,    15,    20,    43,     0,    15,    20,    27,     0,    11,    23,     9,     0,    16,    21,     0,     0,    14,    19,     0,     0,     7,     4,   255,     0,    11,     4,   242, 
    0,    11,     4,   231,     0,    11,     4,   219,     0,    11,     5,   204,     0,    11,     5,   188,     0,    12,     5,   172,     0,    13,     6,   149,     0,    13,     7,   129, 
    0,    10,    10,   109,     0,    11,     9,    89,     0,    14,     8,    71,     0,    15,     8,    51,     0,    15,     8,    35,     0,    18,     6,    22,     0,    13,     8,    11, 
    0,    14,     7,     0,     0,    22,     0,   251,     0,    20,     0,   247,     0,    18,     0,   241,     0,    16,     0,   232,     0,    15,     0,   217,     0,    14,     0,   198, 
    0,    14,     0,   179,     0,    14,     0,   155,     0,    15,     0,   119,     0,    15,     0,    97,     0,    15,     0,    78,     0,    15,     0,    61,     0,    16,     0,    49, 
    0,    15,     0,    37,     0,    15,     0,    26,     0,    14,     0,    14,     0,    13,     0,     0,     0,     0,   211,   197,     0,     0,   210,   195,     0,     2,   211,   190, 
    0,     3,   212,   180,     0,     5,   213,   170,     0,     7,   214,   159,     0,     9,   215,   146,     0,    12,   217,   131,     0,    15,   218,   113,     0,    19,   221,    92, 
    0,    23,   222,    69,     0,    27,   223,    48,     0,    30,   223,    31,     0,    32,   222,    18,     0,    33,   221,     9,     0,    33,   221,     4,     0,    33,   220,     0, 
    0,     0,   196,   201,     0,     0,   202,   186,     0,     0,   203,   180,     0,     0,   204,   171,     0,     0,   206,   161,     0,     0,   207,   151,     0,     2,   209,   141, 
    0,     4,   209,   126,     0,     7,   210,   109,     0,    11,   211,    87,     0,    16,   211,    65,     0,    20,   211,    48,     0,    24,   211,    34,     0,    26,   210,    23, 
    0,    27,   208,    14,     0,    26,   207,     7,     0,    22,   205,     0,     0,     0,   182,   205,     0,     0,   188,   192,     0,     0,   194,   173,     0,     0,   195,   164, 
    0,     0,   197,   153,     0,     0,   198,   145,     0,     0,   199,   135,     0,     0,   199,   121,     0,     0,   200,   103,     0,     2,   203,    80,     0,     6,   203,    56, 
    0,    10,   203,    39,     0,    14,   202,    25,     0,    16,   201,    14,     0,    17,   199,     7,     0,    17,   198,     2,     0,    16,   195,     0,     0,     0,   169,   208, 
    0,     0,   174,   199,     0,     0,   179,   182,     0,     0,   183,   159,     0,     0,   185,   146,     0,     0,   186,   137,     0,     0,   187,   129,     0,     0,   187,   118, 
    0,     0,   188,   102,     0,     0,   190,    80,     0,     0,   191,    54,     0,     2,   192,    32,     0,     4,   192,    17,     0,     6,   191,     6,     0,     9,   188,     1, 
    0,    11,   185,     0,     0,    11,   184,     0,     0,     0,   154,   212,     0,     0,   159,   204,     0,     0,   164,   189,     0,     0,   168,   168,     0,     0,   171,   142, 
    0,     0,   172,   131,     0,     0,   172,   122,     0,     0,   173,   113,     0,     0,   173,   101,     0,     0,   173,    85,     0,     0,   174,    64,     0,     0,   176,    38, 
    0,     0,   176,    16,     0,     1,   175,     3,     0,     6,   171,     0,     0,     9,   169,     0,     0,     9,   167,     0,     0,     0,   137,   217,     0,     0,   142,   210, 
    0,     0,   148,   197,     0,     0,   152,   177,     0,     0,   154,   152,     0,     0,   155,   123,     0,     0,   155,   114,     0,     0,   155,   107,     0,     0,   155,    98, 
    0,     0,   155,    86,     0,     0,   155,    68,     0,     0,   156,    45,     0,     0,   157,    20,     0,     0,   156,     3,     0,     6,   152,     0,     0,     8,   150,     0, 
    0,     8,   149,     0,     0,     0,   120,   222,     0,     0,   124,   218,     0,     0,   130,   206,     0,     0,   135,   188,     0,     0,   138,   164,     0,     0,   139,   136, 
    0,     0,   137,   107,     0,     0,   137,   100,     0,     0,   136,    93,     0,     0,   136,    83,     0,     0,   135,    69,     0,     0,   136,    50,     0,     0,   136,    27, 
    0,     0,   136,     6,     0,     4,   133,     0,     0,     8,   131,     0,     0,     7,   129,     0,     0,     0,   105,   226,     0,     0,   108,   220,     0,     0,   113,   211, 
    0,     0,   117,   199,     0,     0,   121,   177,     0,     0,   124,   151,     0,     0,   122,   121,     0,     0,   119,    94,     0,     0,   119,    89,     0,     0,   118,    81, 
    0,     0,   117,    67,     0,     0,   117,    50,     0,     0,   116,    31,     0,     0,   116,    12,     0,     4,   114,     2,     0,     7,   110,     0,     0,     7,   108,     0, 
    0,     0,    92,   229,     0,     0,    96,   219,     0,     0,    99,   210,     0,     0,   101,   200,     0,     0,   104,   185,     0,     0,   108,   164,     0,     0,   108,   137, 
    0,     0,   105,   108,     0,     0,   101,    79,     0,     0,   101,    75,     0,     0,   100,    64,     0,     0,    99,    50,     0,     0,    98,    34,     0,     0,    97,    17, 
    0,     2,    96,     4,     0,     6,    91,     0,     0,     7,    90,     0,     0,     0,    78,   233,     0,     0,    82,   225,     0,     0,    85,   214,     0,     0,    88,   201, 
    0,     0,    90,   186,     0,     0,    93,   168,     0,     0,    93,   146,     0,     0,    92,   124,     0,     0,    89,    88,     0,     0,    89,    69,     0,     0,    88,    63, 
    0,     0,    88,    53,     0,     0,    87,    36,     0,     0,    86,    21,     0,     0,    84,     6,     0,     4,    80,     0,     0,     8,    76,     0,     0,     0,    59,   239, 
    0,     0,    60,   235,     0,     0,    66,   225,     0,     0,    73,   207,     0,     0,    77,   188,     0,     0,    79,   166,     0,     0,    72,   134,     0,     0,    73,   120, 
    0,     0,    75,    98,     0,     0,    75,    73,     0,     0,    77,    59,     0,     0,    76,    52,     0,     0,    76,    37,     0,     0,    75,    24,     0,     0,    73,     9, 
    0,     4,    70,     1,     0,     8,    65,     0,     0,     0,    41,   244,     0,     0,    43,   234,     0,     0,    48,   222,     0,     0,    54,   207,     0,     0,    60,   191, 
    0,     0,    65,   169,     0,     0,    64,   145,     0,     0,    63,   124,     0,     0,    60,    95,     0,     0,    59,    80,     0,     0,    62,    61,     0,     0,    64,    48, 
    0,     0,    63,    39,     0,     0,    62,    28,     0,     0,    61,    11,     0,     2,    60,     1,     0,     8,    54,     0,     0,     0,    28,   247,     0,     0,    33,   232, 
    0,     0,    37,   220,     0,     0,    40,   205,     0,     0,    43,   189,     0,     0,    46,   172,     0,     0,    49,   155,     0,     0,    50,   130,     0,     0,    48,    95, 
    0,     0,    46,    78,     0,     0,    46,    67,     0,     0,    46,    46,     0,     0,    49,    35,     0,     0,    50,    27,     0,     0,    49,    14,     0,     1,    48,     3, 
    0,     6,    43,     0,     0,     0,    19,   250,     0,     0,    31,   215,     0,     0,    34,   203,     0,     0,    35,   193,     0,     0,    35,   181,     0,     0,    35,   171, 
    0,     0,    35,   157,     0,     0,    37,   134,     0,     0,    36,   104,     0,     0,    34,    82,     0,     0,    34,    64,     0,     0,    33,    52,     0,     0,    33,    35, 
    0,     0,    37,    27,     0,     0,    37,    18,     0,     0,    36,     9,     0,     3,    33,     0,     0,     0,    11,   252,     0,     0,    23,   210,     0,     0,    26,   197, 
    0,     0,    26,   188,     0,     0,    26,   178,     0,     0,    25,   167,     0,     0,    24,   155,     0,     0,    25,   137,     0,     0,    24,   111,     0,     0,    25,    85, 
    0,     0,    24,    67,     0,     0,    22,    52,     0,     0,    22,    38,     0,     0,    22,    27,     0,     0,    25,    18,     0,     0,    25,    11,     0,     0,    24,     0, 
    0,     0,     4,   255,     0,     0,    16,   210,     0,     0,    19,   194,     0,     0,    18,   182,     0,     0,    17,   170,     0,     0,    15,   160,     0,     0,    14,   148, 
    0,     0,    13,   131,     0,     0,    13,   104,     0,     0,    14,    81,     0,     0,    14,    67,     0,     0,    13,    56,     0,     0,    13,    43,     0,     0,    13,    30, 
    0,     0,    12,    17,     0,     0,    13,     9,     0,     0,    12,     0,     0,     0,     0,   255,     0,     0,     0,   255,     0,     0,     0,   251,     0,     0,     0,   236, 
    0,     0,     0,   215,     0,     0,     0,   196,     0,     0,     0,   177,     0,     0,     0,   150,     0,     0,     0,   118,     0,     0,     0,    96,     0,     0,     0,    82, 
    0,     0,     0,    67,     0,     0,     0,    51,     0,     0,     0,    35,     0,     0,     0,    19,     0,     0,     0,    10,     0,     0,     0,     0
};

// Acapulco Best KCMY RGB
unsigned char ucMapDJ4100_KCMY_BestA_12x12x1[] =
{
    0,   226,   237,   232,     0,   229,   225,   208,     0,   231,   213,   185,     0,   233,   201,   161,     0,   235,   196,   136,     0,   239,   192,   116,     0,   244,   187,   103, 
    0,   246,   181,    89,     0,   247,   171,    73,     0,   249,   161,    56,     0,   250,   152,    38,     0,   251,   143,    20,     0,   251,   136,     6,     0,   250,   131,     0, 
    0,   251,   129,     0,     0,   252,   127,     0,     0,   252,   125,     0,     0,   219,   211,   234,     0,   230,   219,   224,     0,   232,   209,   189,     0,   232,   192,   159, 
    0,   235,   190,   128,     0,   242,   185,   103,     0,   245,   182,    91,     0,   247,   174,    77,     0,   248,   165,    63,     0,   249,   157,    47,     0,   250,   149,    30, 
    0,   251,   141,    14,     0,   250,   135,     2,     0,   249,   132,     0,     0,   248,   131,     0,     0,   248,   129,     0,     0,   247,   127,     0,     0,   212,   186,   237, 
    0,   220,   194,   234,     0,   234,   200,   216,     0,   232,   185,   171,     0,   232,   179,   134,     0,   237,   177,   104,     0,   242,   171,    82,     0,   247,   163,    62, 
    0,   248,   157,    47,     0,   249,   150,    32,     0,   249,   143,    18,     0,   248,   137,     6,     0,   245,   134,     0,     0,   244,   133,     0,     0,   243,   132,     0, 
    0,   242,   130,     0,     0,   242,   128,     0,     0,   209,   171,   239,     0,   213,   173,   235,     0,   218,   169,   216,     0,   226,   170,   186,     0,   228,   164,   147, 
    0,   230,   161,   114,     0,   234,   158,    88,     0,   239,   153,    63,     0,   240,   149,    44,     0,   239,   145,    30,     0,   239,   141,    17,     0,   239,   136,     7, 
    0,   236,   134,     1,     0,   233,   132,     0,     0,   233,   131,     0,     0,   233,   129,     0,     0,   232,   127,     0,     0,   206,   153,   241,     0,   210,   152,   238, 
    0,   214,   149,   220,     0,   218,   150,   191,     0,   221,   149,   161,     0,   225,   145,   128,     0,   226,   143,   100,     0,   229,   140,    74,     0,   229,   138,    55, 
    0,   226,   137,    42,     0,   225,   136,    29,     0,   224,   134,    18,     0,   223,   132,     9,     0,   222,   131,     5,     0,   221,   129,     3,     0,   220,   127,     1, 
    0,   220,   124,     0,     0,   206,   129,   243,     0,   210,   125,   240,     0,   212,   126,   224,     0,   211,   129,   195,     0,   212,   132,   168,     0,   215,   130,   138, 
    0,   218,   129,   112,     0,   221,   127,    85,     0,   220,   126,    64,     0,   217,   127,    50,     0,   215,   127,    39,     0,   214,   126,    28,     0,   214,   125,    17, 
    0,   213,   123,    11,     0,   212,   122,     7,     0,   211,   120,     3,     0,   210,   118,     0,     0,   207,   103,   245,     0,   210,   100,   243,     0,   211,   102,   228, 
    0,   207,   107,   199,     0,   208,   113,   175,     0,   210,   114,   150,     0,   212,   113,   119,     0,   214,   113,    96,     0,   215,   111,    73,     0,   213,   113,    55, 
    0,   211,   114,    42,     0,   209,   115,    32,     0,   208,   115,    22,     0,   207,   114,    15,     0,   206,   113,     9,     0,   205,   112,     4,     0,   204,   110,     0, 
    0,   207,    79,   246,     0,   209,    76,   244,     0,   210,    78,   233,     0,   206,    87,   206,     0,   205,    93,   183,     0,   206,    95,   160,     0,   208,    97,   132, 
    0,   209,    96,   101,     0,   212,    96,    81,     0,   212,    95,    61,     0,   210,    98,    45,     0,   207,   102,    34,     0,   204,   104,    24,     0,   202,   104,    17, 
    0,   200,   104,    11,     0,   199,   102,     5,     0,   197,   101,     0,     0,   206,    57,   247,     0,   208,    54,   246,     0,   210,    55,   238,     0,   205,    65,   213, 
    0,   203,    73,   189,     0,   204,    77,   168,     0,   205,    79,   144,     0,   206,    80,   115,     0,   206,    80,    86,     0,   208,    80,    68,     0,   209,    81,    50, 
    0,   206,    85,    37,     0,   203,    89,    26,     0,   199,    93,    18,     0,   196,    94,    12,     0,   193,    93,     6,     0,   191,    92,     0,     0,   203,    37,   247, 
    0,   206,    34,   247,     0,   208,    32,   243,     0,   206,    42,   222,     0,   201,    52,   195,     0,   201,    58,   174,     0,   201,    62,   153,     0,   202,    63,   128, 
    0,   202,    64,    99,     0,   202,    64,    71,     0,   204,    65,    55,     0,   205,    68,    41,     0,   203,    73,    29,     0,   199,    78,    20,     0,   194,    81,    12, 
    0,   190,    82,     6,     0,   187,    82,     0,     0,   200,    22,   247,     0,   202,    18,   246,     0,   203,    17,   241,     0,   203,    22,   226,     0,   201,    34,   202, 
    0,   199,    39,   181,     0,   198,    44,   161,     0,   198,    47,   139,     0,   199,    48,   113,     0,   199,    49,    85,     0,   199,    51,    59,     0,   201,    54,    45, 
    0,   201,    57,    33,     0,   199,    62,    23,     0,   194,    67,    14,     0,   189,    71,     7,     0,   185,    73,     0,     0,   198,    15,   247,     0,   199,    12,   246, 
    0,   200,    11,   239,     0,   199,    13,   226,     0,   197,    22,   205,     0,   196,    26,   186,     0,   195,    31,   167,     0,   195,    35,   148,     0,   195,    37,   126, 
    0,   197,    38,   101,     0,   198,    39,    75,     0,   197,    41,    48,     0,   198,    43,    36,     0,   197,    46,    25,     0,   194,    52,    15,     0,   189,    57,     7, 
    0,   185,    62,     0,     0,   196,    11,   247,     0,   197,     9,   246,     0,   198,     8,   240,     0,   197,    10,   228,     0,   195,    16,   209,     0,   193,    18,   191, 
    0,   193,    22,   174,     0,   193,    26,   156,     0,   192,    29,   138,     0,   193,    31,   115,     0,   195,    31,    91,     0,   196,    31,    66,     0,   196,    32,    38, 
    0,   195,    34,    27,     0,   193,    38,    17,     0,   189,    43,     8,     0,   185,    48,     0,     0,   195,     8,   247,     0,   196,     6,   246,     0,   196,     5,   241, 
    0,   195,     6,   230,     0,   194,     9,   214,     0,   192,    13,   197,     0,   191,    15,   180,     0,   191,    18,   164,     0,   190,    21,   147,     0,   191,    22,   127, 
    0,   192,    23,   105,     0,   193,    23,    81,     0,   194,    23,    55,     0,   194,    23,    27,     0,   191,    26,    17,     0,   188,    30,     8,     0,   185,    35,     0, 
    0,   193,     6,   247,     0,   194,     4,   246,     0,   194,     3,   241,     0,   193,     4,   231,     0,   193,     5,   218,     0,   191,     8,   202,     0,   190,     9,   186, 
    0,   190,    11,   170,     0,   189,    13,   154,     0,   189,    14,   137,     0,   189,    15,   116,     0,   190,    15,    94,     0,   191,    14,    71,     0,   192,    14,    45, 
    0,   192,    15,    17,     0,   188,    18,     8,     0,   185,    22,     0,     0,   192,     3,   246,     0,   192,     2,   245,     0,   192,     2,   241,     0,   192,     2,   232, 
    0,   191,     2,   221,     0,   190,     4,   206,     0,   189,     4,   192,     0,   189,     5,   177,     0,   188,     6,   162,     0,   188,     7,   145,     0,   188,     7,   126, 
    0,   188,     7,   106,     0,   189,     7,    84,     0,   189,     6,    61,     0,   190,     7,    35,     0,   190,     7,     8,     0,   185,    10,     0,     0,   190,     0,   246, 
    0,   190,     0,   244,     0,   190,     0,   239,     0,   189,     0,   232,     0,   189,     0,   222,     0,   188,     0,   209,     0,   188,     0,   196,     0,   187,     0,   183, 
    0,   187,     0,   168,     0,   187,     0,   152,     0,   187,     0,   135,     0,   187,     0,   116,     0,   187,     0,    96,     0,   187,     0,    75,     0,   187,     0,    51, 
    0,   187,     0,    27,     0,   187,     0,     0,     0,   209,   226,   235,     0,   198,   241,   212,     0,   215,   219,   180,     0,   212,   212,   156,     0,   212,   206,   125, 
    0,   218,   201,    99,     0,   225,   195,    78,     0,   228,   185,    58,     0,   231,   175,    44,     0,   233,   168,    34,     0,   235,   160,    22,     0,   238,   153,     9, 
    0,   238,   147,     2,     0,   241,   142,     0,     0,   244,   138,     0,     0,   245,   134,     0,     0,   247,   131,     0,     0,   209,   213,   238,     0,   214,   217,   231, 
    0,   216,   218,   200,     0,   220,   200,   158,     0,   226,   193,   122,     0,   235,   182,    93,     0,   241,   176,    70,     0,   244,   168,    55,     0,   245,   161,    42, 
    0,   247,   153,    29,     0,   248,   146,    17,     0,   248,   139,     5,     0,   246,   135,     0,     0,   243,   133,     0,     0,   242,   132,     0,     0,   242,   131,     0, 
    0,   240,   130,     0,     0,   201,   188,   241,     0,   205,   189,   239,     0,   216,   198,   228,     0,   217,   179,   170,     0,   222,   178,   133,     0,   230,   175,   102, 
    0,   238,   168,    74,     0,   244,   160,    51,     0,   248,   152,    33,     0,   250,   145,    19,     0,   250,   138,     7,     0,   248,   134,     1,     0,   243,   132,     0, 
    0,   239,   131,     0,     0,   237,   131,     0,     0,   236,   130,     0,     0,   235,   130,     0,     0,   202,   171,   241,     0,   206,   170,   240,     0,   212,   168,   226, 
    0,   213,   167,   188,     0,   216,   164,   151,     0,   221,   161,   117,     0,   227,   157,    86,     0,   233,   153,    58,     0,   238,   146,    35,     0,   243,   139,    15, 
    0,   244,   133,     3,     0,   240,   131,     0,     0,   235,   131,     0,     0,   231,   130,     0,     0,   228,   130,     0,     0,   227,   129,     0,     0,   227,   129,     0, 
    0,   202,   151,   243,     0,   206,   147,   241,     0,   211,   143,   231,     0,   210,   145,   196,     0,   211,   148,   166,     0,   215,   144,   132,     0,   217,   142,   101, 
    0,   223,   139,    74,     0,   228,   136,    49,     0,   232,   131,    27,     0,   234,   127,     8,     0,   230,   126,     2,     0,   225,   127,     1,     0,   221,   127,     0, 
    0,   218,   126,     0,     0,   217,   126,     0,     0,   217,   126,     0,     0,   203,   127,   245,     0,   206,   123,   244,     0,   211,   119,   237,     0,   209,   122,   204, 
    0,   208,   129,   175,     0,   211,   129,   146,     0,   213,   128,   117,     0,   216,   126,    88,     0,   217,   125,    64,     0,   221,   123,    43,     0,   224,   119,    23, 
    0,   223,   116,     7,     0,   219,   117,     2,     0,   215,   118,     1,     0,   212,   118,     1,     0,   211,   118,     0,     0,   210,   119,     0,     0,   203,   102,   246, 
    0,   206,   100,   245,     0,   210,    95,   241,     0,   209,   100,   215,     0,   207,   107,   185,     0,   208,   111,   158,     0,   210,   111,   129,     0,   212,   111,   102, 
    0,   214,   109,    76,     0,   214,   110,    54,     0,   214,   109,    36,     0,   214,   108,    19,     0,   213,   106,     7,     0,   211,   107,     2,     0,   208,   108,     1, 
    0,   206,   109,     0,     0,   203,   110,     0,     0,   204,    78,   246,     0,   205,    76,   246,     0,   209,    73,   243,     0,   207,    79,   222,     0,   204,    88,   192, 
    0,   205,    91,   168,     0,   207,    93,   142,     0,   209,    94,   113,     0,   211,    93,    88,     0,   212,    93,    65,     0,   210,    95,    45,     0,   209,    96,    27, 
    0,   208,    95,    13,     0,   206,    96,     4,     0,   203,    97,     1,     0,   200,    99,     0,     0,   197,   101,     0,     0,   203,    57,   247,     0,   204,    56,   247, 
    0,   207,    52,   245,     0,   207,    56,   228,     0,   202,    67,   199,     0,   202,    73,   176,     0,   204,    76,   152,     0,   204,    77,   125,     0,   206,    77,    98, 
    0,   207,    77,    75,     0,   208,    78,    55,     0,   207,    80,    36,     0,   205,    83,    20,     0,   203,    84,     8,     0,   199,    86,     2,     0,   195,    88,     1, 
    0,   190,    92,     0,     0,   200,    36,   248,     0,   201,    36,   248,     0,   204,    33,   246,     0,   205,    36,   235,     0,   201,    50,   206,     0,   200,    55,   183, 
    0,   200,    59,   160,     0,   200,    61,   136,     0,   201,    62,   108,     0,   202,    62,    84,     0,   203,    62,    64,     0,   204,    63,    45,     0,   203,    67,    28, 
    0,   200,    71,    14,     0,   196,    75,     6,     0,   191,    78,     1,     0,   185,    82,     0,     0,   197,    21,   247,     0,   198,    22,   247,     0,   200,    19,   246, 
    0,   202,    18,   237,     0,   200,    31,   212,     0,   198,    36,   190,     0,   197,    42,   168,     0,   197,    45,   146,     0,   197,    47,   121,     0,   198,    47,    95, 
    0,   199,    47,    72,     0,   200,    48,    53,     0,   200,    51,    35,     0,   198,    55,    21,     0,   195,    61,    10,     0,   190,    66,     3,     0,   183,    72,     0, 
    0,   195,    15,   247,     0,   195,    10,   247,     0,   197,     7,   245,     0,   198,     7,   236,     0,   196,    16,   215,     0,   195,    23,   194,     0,   194,    28,   174, 
    0,   194,    31,   154,     0,   194,    33,   132,     0,   195,    34,   107,     0,   196,    35,    83,     0,   196,    35,    61,     0,   197,    37,    42,     0,   196,    40,    27, 
    0,   193,    45,    14,     0,   189,    52,     5,     0,   181,    61,     0,     0,   194,    11,   247,     0,   193,     3,   246,     0,   193,     1,   242,     0,   194,     2,   233, 
    0,   193,     7,   214,     0,   192,    12,   196,     0,   191,    16,   178,     0,   190,    19,   160,     0,   190,    22,   140,     0,   191,    25,   119,     0,   192,    25,    95, 
    0,   193,    25,    72,     0,   193,    25,    48,     0,   193,    28,    31,     0,   191,    31,    18,     0,   188,    37,     7,     0,   181,    47,     0,     0,   193,     8,   247, 
    0,   189,     1,   241,     0,   189,     0,   237,     0,   190,     1,   229,     0,   190,     2,   215,     0,   189,     5,   199,     0,   188,     8,   182,     0,   187,    11,   165, 
    0,   187,    13,   147,     0,   187,    15,   128,     0,   188,    16,   106,     0,   189,    15,    83,     0,   190,    15,    59,     0,   191,    15,    36,     0,   189,    19,    21, 
    0,   186,    25,    10,     0,   182,    34,     0,     0,   192,     5,   247,     0,   187,     1,   238,     0,   186,     0,   233,     0,   187,     0,   226,     0,   187,     1,   215, 
    0,   187,     1,   202,     0,   186,     3,   186,     0,   185,     4,   170,     0,   185,     6,   153,     0,   185,     7,   136,     0,   185,     8,   116,     0,   186,     8,    94, 
    0,   186,     7,    72,     0,   187,     7,    47,     0,   188,     7,    24,     0,   185,    12,    11,     0,   180,    22,     0,     0,   190,     3,   246,     0,   185,     0,   237, 
    0,   184,     0,   232,     0,   185,     0,   225,     0,   185,     0,   216,     0,   184,     0,   203,     0,   184,     1,   189,     0,   184,     1,   174,     0,   183,     1,   159, 
    0,   183,     2,   142,     0,   183,     2,   124,     0,   183,     2,   104,     0,   184,     2,    83,     0,   184,     2,    60,     0,   185,     1,    37,     0,   184,     2,    14, 
    0,   179,     9,     0,     0,   189,     0,   246,     0,   186,     0,   235,     0,   186,     0,   232,     0,   186,     0,   226,     0,   186,     0,   217,     0,   186,     0,   205, 
    0,   184,     0,   192,     0,   184,     0,   178,     0,   183,     0,   164,     0,   183,     0,   148,     0,   183,     0,   131,     0,   183,     0,   112,     0,   182,     0,    93, 
    0,   182,     0,    72,     0,   182,     0,    48,     0,   182,     0,    25,     0,   181,     0,     0,     0,   192,   215,   238,     0,   175,   233,   228,     0,   169,   246,   192, 
    0,   193,   225,   156,     0,   197,   213,   122,     0,   201,   207,    95,     0,   206,   200,    73,     0,   209,   192,    53,     0,   212,   182,    40,     0,   214,   173,    32, 
    0,   217,   165,    25,     0,   219,   157,    15,     0,   223,   151,     7,     0,   229,   148,     3,     0,   233,   144,     0,     0,   238,   141,     0,     0,   240,   138,     0, 
    0,   192,   204,   242,     0,   196,   211,   239,     0,   194,   220,   200,     0,   201,   207,   157,     0,   204,   200,   119,     0,   208,   194,    89,     0,   213,   185,    64, 
    0,   217,   175,    43,     0,   224,   168,    21,     0,   228,   159,     7,     0,   230,   153,     4,     0,   230,   148,     2,     0,   229,   145,     1,     0,   229,   142,     0, 
    0,   231,   140,     0,     0,   232,   137,     0,     0,   234,   136,     0,     0,   192,   189,   244,     0,   197,   189,   243,     0,   198,   181,   210,     0,   201,   184,   168, 
    0,   205,   181,   134,     0,   211,   176,   103,     0,   219,   168,    77,     0,   226,   162,    53,     0,   233,   156,    29,     0,   239,   147,     9,     0,   239,   141,     1, 
    0,   237,   138,     0,     0,   233,   137,     0,     0,   230,   135,     0,     0,   227,   134,     0,     0,   226,   133,     0,     0,   227,   132,     0,     0,   195,   169,   244, 
    0,   197,   168,   240,     0,   199,   167,   219,     0,   199,   165,   185,     0,   203,   163,   150,     0,   207,   161,   118,     0,   212,   159,    90,     0,   218,   154,    64, 
    0,   224,   150,    41,     0,   230,   144,    18,     0,   233,   137,     2,     0,   230,   135,     0,     0,   226,   134,     0,     0,   223,   133,     0,     0,   220,   131,     0, 
    0,   218,   130,     0,     0,   219,   131,     0,     0,   196,   147,   245,     0,   199,   145,   243,     0,   201,   144,   230,     0,   198,   144,   192,     0,   200,   148,   165, 
    0,   203,   145,   133,     0,   207,   143,   103,     0,   210,   141,    77,     0,   214,   139,    53,     0,   217,   136,    31,     0,   221,   132,     9,     0,   219,   130,     1, 
    0,   217,   129,     0,     0,   215,   128,     0,     0,   213,   127,     0,     0,   213,   126,     0,     0,   213,   127,     0,     0,   198,   126,   246,     0,   201,   122,   245, 
    0,   204,   119,   238,     0,   200,   124,   203,     0,   200,   129,   175,     0,   202,   130,   148,     0,   206,   129,   118,     0,   208,   128,    90,     0,   210,   127,    66, 
    0,   212,   125,    43,     0,   214,   121,    22,     0,   215,   119,     5,     0,   213,   119,     0,     0,   211,   119,     0,     0,   209,   119,     0,     0,   208,   119,     0, 
    0,   207,   120,     0,     0,   199,   102,   247,     0,   201,    99,   246,     0,   205,    95,   243,     0,   203,   102,   216,     0,   201,   108,   185,     0,   202,   111,   159, 
    0,   204,   112,   131,     0,   206,   112,   103,     0,   207,   111,    77,     0,   208,   112,    55,     0,   209,   110,    35,     0,   210,   108,    15,     0,   210,   106,     3, 
    0,   208,   107,     0,     0,   205,   109,     0,     0,   203,   109,     0,     0,   201,   111,     0,     0,   199,    79,   247,     0,   201,    76,   247,     0,   204,    73,   245, 
    0,   203,    79,   224,     0,   200,    87,   193,     0,   201,    91,   169,     0,   202,    93,   143,     0,   204,    94,   116,     0,   206,    94,    90,     0,   206,    94,    67, 
    0,   206,    96,    45,     0,   206,    96,    25,     0,   205,    95,     9,     0,   204,    95,     1,     0,   201,    97,     0,     0,   198,    99,     0,     0,   195,   101,     0, 
    0,   198,    58,   248,     0,   200,    57,   248,     0,   203,    53,   246,     0,   203,    57,   230,     0,   199,    68,   201,     0,   199,    72,   178,     0,   200,    76,   154, 
    0,   201,    77,   128,     0,   202,    77,   101,     0,   203,    78,    78,     0,   204,    79,    57,     0,   203,    81,    37,     0,   202,    82,    18,     0,   200,    83,     5, 
    0,   196,    85,     0,     0,   193,    88,     0,     0,   189,    92,     0,     0,   196,    37,   248,     0,   197,    37,   248,     0,   200,    35,   247,     0,   202,    38,   235, 
    0,   198,    51,   207,     0,   196,    55,   185,     0,   197,    59,   163,     0,   197,    61,   139,     0,   198,    62,   112,     0,   199,    62,    87,     0,   200,    63,    66, 
    0,   201,    64,    47,     0,   200,    66,    27,     0,   197,    70,    12,     0,   194,    74,     3,     0,   189,    77,     0,     0,   183,    82,     0,     0,   193,    22,   247, 
    0,   194,    23,   247,     0,   197,    21,   247,     0,   199,    21,   238,     0,   197,    32,   214,     0,   195,    38,   192,     0,   194,    42,   171,     0,   194,    46,   149, 
    0,   195,    47,   124,     0,   196,    48,    98,     0,   196,    48,    76,     0,   197,    48,    55,     0,   197,    50,    36,     0,   195,    54,    20,     0,   192,    59,     7, 
    0,   187,    65,     1,     0,   179,    72,     0,     0,   192,    15,   247,     0,   192,    10,   247,     0,   194,     8,   245,     0,   196,     9,   237,     0,   194,    17,   218, 
    0,   193,    23,   197,     0,   192,    28,   176,     0,   191,    31,   156,     0,   192,    33,   134,     0,   192,    35,   110,     0,   193,    35,    86,     0,   193,    35,    64, 
    0,   193,    36,    44,     0,   193,    38,    27,     0,   190,    43,    13,     0,   186,    50,     3,     0,   178,    60,     0,     0,   191,    11,   247,     0,   189,     2,   245, 
    0,   190,     1,   240,     0,   191,     1,   232,     0,   190,     7,   216,     0,   189,    12,   198,     0,   189,    16,   180,     0,   188,    18,   161,     0,   188,    21,   142, 
    0,   188,    23,   120,     0,   189,    24,    96,     0,   189,    24,    74,     0,   190,    24,    51,     0,   190,    26,    33,     0,   188,    30,    18,     0,   185,    35,     6, 
    0,   177,    46,     0,     0,   190,     8,   247,     0,   186,     1,   241,     0,   185,     0,   232,     0,   186,     0,   224,     0,   187,     2,   213,     0,   186,     4,   198, 
    0,   185,     6,   182,     0,   184,     9,   165,     0,   184,    10,   147,     0,   184,    12,   128,     0,   185,    13,   106,     0,   186,    13,    83,     0,   186,    13,    61, 
    0,   187,    13,    38,     0,   186,    16,    22,     0,   183,    22,     9,     0,   177,    33,     0,     0,   189,     5,   247,     0,   184,     0,   237,     0,   182,     0,   226, 
    0,   182,     0,   219,     0,   183,     0,   210,     0,   183,     0,   198,     0,   182,     1,   184,     0,   182,     2,   168,     0,   181,     3,   152,     0,   181,     4,   134, 
    0,   181,     5,   115,     0,   182,     5,    93,     0,   182,     5,    71,     0,   183,     4,    48,     0,   183,     5,    26,     0,   181,    10,    11,     0,   176,    21,     0, 
    0,   188,     3,   247,     0,   182,     0,   235,     0,   179,     0,   223,     0,   179,     0,   216,     0,   180,     0,   208,     0,   179,     0,   197,     0,   178,     0,   184, 
    0,   178,     0,   170,     0,   177,     0,   155,     0,   177,     0,   138,     0,   177,     1,   121,     0,   178,     1,   102,     0,   178,     1,    81,     0,   178,     0,    59, 
    0,   178,     0,    37,     0,   177,     2,    15,     0,   174,     9,     0,     0,   187,     0,   247,     0,   184,     0,   235,     0,   182,     0,   223,     0,   182,     0,   219, 
    0,   182,     0,   211,     0,   182,     0,   200,     0,   181,     0,   187,     0,   180,     0,   173,     0,   179,     0,   159,     0,   178,     0,   143,     0,   177,     0,   127, 
    0,   177,     0,   109,     0,   176,     0,    90,     0,   176,     0,    69,     0,   176,     0,    46,     0,   176,     0,    23,     0,   175,     0,     0,     0,   185,   216,   237, 
    0,   180,   221,   227,     0,   176,   234,   199,     0,   172,   240,   159,     0,   179,   220,   120,     0,   184,   212,    92,     0,   190,   204,    70,     0,   194,   197,    49, 
    0,   198,   189,    36,     0,   201,   182,    27,     0,   205,   173,    20,     0,   208,   163,    12,     0,   211,   156,     6,     0,   215,   151,     4,     0,   219,   149,     4, 
    0,   224,   147,     2,     0,   229,   144,     0,     0,   186,   203,   242,     0,   185,   209,   234,     0,   182,   212,   202,     0,   183,   213,   162,     0,   186,   206,   120, 
    0,   190,   199,    89,     0,   196,   193,    62,     0,   200,   187,    39,     0,   204,   180,    18,     0,   208,   169,     4,     0,   211,   159,     2,     0,   212,   152,     1, 
    0,   213,   148,     0,     0,   214,   145,     0,     0,   216,   143,     0,     0,   220,   141,     0,     0,   223,   141,     0,     0,   186,   189,   245,     0,   186,   191,   238, 
    0,   183,   181,   204,     0,   185,   187,   169,     0,   188,   185,   133,     0,   193,   183,   101,     0,   198,   179,    74,     0,   202,   173,    50,     0,   206,   165,    29, 
    0,   210,   155,     7,     0,   212,   148,     0,     0,   213,   146,     0,     0,   213,   143,     0,     0,   213,   140,     0,     0,   214,   138,     0,     0,   214,   136,     0, 
    0,   216,   136,     0,     0,   183,   167,   249,     0,   185,   168,   233,     0,   185,   166,   210,     0,   189,   165,   193,     0,   190,   165,   148,     0,   194,   164,   116, 
    0,   199,   160,    90,     0,   204,   156,    65,     0,   209,   152,    42,     0,   212,   145,    20,     0,   216,   140,     3,     0,   215,   137,     0,     0,   214,   135,     0, 
    0,   213,   133,     0,     0,   212,   132,     0,     0,   211,   130,     0,     0,   214,   130,     0,     0,   186,   146,   249,     0,   188,   145,   242,     0,   188,   149,   222, 
    0,   187,   146,   192,     0,   189,   147,   163,     0,   193,   147,   133,     0,   197,   147,   103,     0,   200,   145,    77,     0,   205,   143,    53,     0,   208,   138,    32, 
    0,   211,   134,    11,     0,   212,   131,     1,     0,   210,   129,     0,     0,   209,   128,     0,     0,   208,   127,     0,     0,   207,   126,     0,     0,   208,   126,     0, 
    0,   189,   125,   249,     0,   192,   122,   247,     0,   193,   124,   234,     0,   190,   128,   201,     0,   189,   130,   174,     0,   191,   133,   148,     0,   195,   132,   119, 
    0,   198,   131,    91,     0,   201,   129,    67,     0,   204,   128,    43,     0,   206,   125,    20,     0,   208,   122,     3,     0,   206,   122,     0,     0,   204,   121,     0, 
    0,   203,   120,     0,     0,   203,   120,     0,     0,   203,   121,     0,     0,   191,   102,   248,     0,   194,    99,   248,     0,   197,    98,   243,     0,   194,   105,   214, 
    0,   192,   109,   184,     0,   192,   115,   158,     0,   193,   116,   132,     0,   198,   115,   104,     0,   199,   115,    79,     0,   200,   114,    56,     0,   203,   112,    34, 
    0,   205,   109,    13,     0,   204,   109,     1,     0,   201,   110,     0,     0,   199,   111,     0,     0,   198,   111,     0,     0,   198,   112,     0,     0,   192,    80,   248, 
    0,   195,    77,   248,     0,   198,    75,   245,     0,   196,    83,   222,     0,   193,    89,   193,     0,   193,    93,   168,     0,   194,    96,   144,     0,   196,    97,   116, 
    0,   198,    97,    91,     0,   199,    97,    67,     0,   199,    99,    45,     0,   200,    98,    24,     0,   201,    96,     7,     0,   199,    97,     0,     0,   196,    99,     0, 
    0,   194,   100,     0,     0,   192,   102,     0,     0,   192,    60,   249,     0,   194,    58,   248,     0,   197,    55,   246,     0,   196,    62,   227,     0,   193,    71,   201, 
    0,   193,    74,   178,     0,   194,    77,   155,     0,   195,    79,   129,     0,   196,    79,   102,     0,   197,    80,    79,     0,   197,    82,    57,     0,   197,    84,    36, 
    0,   197,    83,    16,     0,   195,    84,     2,     0,   192,    87,     0,     0,   189,    90,     0,     0,   186,    93,     0,     0,   190,    40,   248,     0,   192,    38,   248, 
    0,   195,    37,   247,     0,   196,    42,   233,     0,   193,    53,   207,     0,   191,    56,   185,     0,   192,    60,   164,     0,   193,    63,   140,     0,   193,    64,   114, 
    0,   194,    64,    89,     0,   195,    65,    68,     0,   195,    67,    47,     0,   194,    68,    26,     0,   192,    72,    10,     0,   189,    74,     1,     0,   184,    78,     0, 
    0,   180,    82,     0,     0,   188,    23,   248,     0,   190,    23,   247,     0,   193,    22,   247,     0,   194,    25,   237,     0,   192,    35,   213,     0,   191,    40,   193, 
    0,   190,    44,   171,     0,   191,    46,   150,     0,   191,    48,   125,     0,   192,    49,   100,     0,   192,    49,    77,     0,   192,    50,    56,     0,   192,    52,    36, 
    0,   191,    55,    18,     0,   188,    60,     5,     0,   182,    66,     0,     0,   175,    71,     0,     0,   187,    16,   247,     0,   188,    11,   247,     0,   190,     9,   246, 
    0,   191,    12,   236,     0,   190,    21,   216,     0,   189,    26,   196,     0,   188,    30,   177,     0,   188,    32,   157,     0,   188,    34,   135,     0,   188,    36,   112, 
    0,   189,    36,    88,     0,   189,    36,    66,     0,   189,    37,    45,     0,   189,    39,    27,     0,   186,    43,    11,     0,   181,    50,     1,     0,   173,    60,     0, 
    0,   187,    11,   247,     0,   186,     3,   246,     0,   186,     1,   240,     0,   187,     3,   231,     0,   186,     9,   215,     0,   186,    14,   198,     0,   185,    17,   181, 
    0,   185,    19,   162,     0,   184,    22,   143,     0,   185,    24,   121,     0,   185,    25,    98,     0,   185,    25,    76,     0,   186,    25,    53,     0,   185,    26,    34, 
    0,   184,    29,    17,     0,   181,    35,     5,     0,   172,    46,     0,     0,   186,     8,   247,     0,   183,     1,   241,     0,   182,     0,   232,     0,   182,     0,   222, 
    0,   182,     3,   211,     0,   182,     5,   198,     0,   182,     6,   182,     0,   181,     8,   166,     0,   181,    10,   148,     0,   181,    11,   128,     0,   181,    13,   107, 
    0,   182,    13,    84,     0,   182,    12,    62,     0,   182,    12,    40,     0,   181,    15,    22,     0,   179,    20,     8,     0,   172,    32,     0,     0,   186,     5,   247, 
    0,   181,     0,   236,     0,   178,     0,   225,     0,   177,     0,   213,     0,   177,     0,   205,     0,   177,     0,   194,     0,   177,     1,   181,     0,   177,     1,   166, 
    0,   176,     2,   150,     0,   176,     3,   133,     0,   176,     3,   113,     0,   177,     4,    93,     0,   177,     3,    71,     0,   178,     3,    48,     0,   178,     3,    26, 
    0,   176,     7,    11,     0,   171,    20,     0,     0,   185,     3,   247,     0,   180,     0,   235,     0,   176,     0,   221,     0,   173,     0,   208,     0,   173,     0,   200, 
    0,   173,     0,   191,     0,   173,     0,   179,     0,   172,     0,   165,     0,   171,     0,   150,     0,   170,     0,   134,     0,   170,     0,   117,     0,   170,     0,    99, 
    0,   170,     0,    79,     0,   170,     0,    58,     0,   170,     0,    37,     0,   170,     1,    17,     0,   168,     9,     0,     0,   184,     0,   247,     0,   182,     0,   235, 
    0,   179,     0,   224,     0,   177,     0,   211,     0,   177,     0,   204,     0,   177,     0,   195,     0,   176,     0,   183,     0,   175,     0,   169,     0,   173,     0,   155, 
    0,   172,     0,   140,     0,   171,     0,   123,     0,   171,     0,   106,     0,   170,     0,    87,     0,   169,     0,    67,     0,   169,     0,    44,     0,   169,     0,    22, 
    0,   168,     0,     0,     0,   171,   216,   237,     0,   167,   222,   227,     0,   164,   231,   203,     0,   162,   239,   166,     0,   158,   232,   122,     0,   164,   220,    91, 
    0,   171,   210,    67,     0,   176,   202,    47,     0,   182,   193,    35,     0,   187,   187,    25,     0,   192,   180,    16,     0,   196,   171,     8,     0,   200,   164,     4, 
    0,   204,   158,     4,     0,   208,   153,     3,     0,   211,   149,     2,     0,   215,   147,     0,     0,   173,   203,   240,     0,   171,   203,   223,     0,   170,   207,   199, 
    0,   169,   212,   168,     0,   167,   211,   125,     0,   171,   206,    90,     0,   177,   199,    61,     0,   182,   192,    39,     0,   187,   186,    16,     0,   193,   177,     3, 
    0,   197,   168,     1,     0,   200,   160,     1,     0,   203,   154,     0,     0,   205,   149,     0,     0,   207,   146,     0,     0,   210,   144,     0,     0,   211,   144,     0, 
    0,   178,   188,   233,     0,   177,   183,   219,     0,   172,   182,   194,     0,   171,   186,   173,     0,   171,   189,   138,     0,   174,   187,   104,     0,   180,   184,    76, 
    0,   185,   181,    50,     0,   189,   175,    25,     0,   194,   167,     3,     0,   197,   159,     0,     0,   200,   153,     0,     0,   202,   149,     0,     0,   203,   145,     0, 
    0,   204,   141,     0,     0,   206,   139,     0,     0,   208,   139,     0,     0,   174,   168,   240,     0,   174,   166,   220,     0,   172,   164,   200,     0,   171,   165,   182, 
    0,   173,   170,   151,     0,   177,   170,   116,     0,   181,   168,    88,     0,   187,   166,    63,     0,   190,   162,    38,     0,   194,   155,    14,     0,   198,   148,     1, 
    0,   199,   144,     0,     0,   201,   140,     0,     0,   201,   137,     0,     0,   202,   135,     0,     0,   202,   134,     0,     0,   204,   134,     0,     0,   171,   146,   252, 
    0,   174,   148,   233,     0,   173,   148,   206,     0,   172,   148,   188,     0,   177,   148,   171,     0,   179,   150,   132,     0,   184,   150,   102,     0,   189,   148,    77, 
    0,   194,   146,    52,     0,   198,   141,    27,     0,   201,   135,     7,     0,   202,   132,     0,     0,   202,   130,     0,     0,   201,   129,     0,     0,   201,   127,     0, 
    0,   200,   126,     0,     0,   202,   126,     0,     0,   175,   125,   251,     0,   178,   125,   245,     0,   177,   130,   218,     0,   176,   132,   195,     0,   176,   132,   173, 
    0,   179,   134,   147,     0,   183,   135,   118,     0,   187,   134,    91,     0,   190,   133,    67,     0,   194,   132,    42,     0,   197,   128,    18,     0,   199,   124,     2, 
    0,   199,   123,     0,     0,   197,   122,     0,     0,   196,   121,     0,     0,   196,   120,     0,     0,   197,   121,     0,     0,   178,   104,   250,     0,   183,   101,   249, 
    0,   183,   104,   236,     0,   182,   111,   207,     0,   180,   114,   182,     0,   179,   118,   157,     0,   181,   121,   132,     0,   185,   120,   107,     0,   188,   119,    80, 
    0,   191,   118,    56,     0,   194,   116,    32,     0,   196,   114,    10,     0,   195,   113,     1,     0,   194,   113,     0,     0,   192,   113,     0,     0,   191,   113,     0, 
    0,   192,   114,     0,     0,   181,    82,   250,     0,   185,    79,   249,     0,   187,    80,   243,     0,   185,    88,   217,     0,   183,    93,   191,     0,   182,    97,   167, 
    0,   182,   101,   144,     0,   184,   103,   117,     0,   188,   102,    92,     0,   189,   102,    68,     0,   190,   102,    45,     0,   193,   101,    22,     0,   194,    99,     4, 
    0,   192,   100,     0,     0,   189,   101,     0,     0,   187,   102,     0,     0,   187,   104,     0,     0,   182,    62,   250,     0,   186,    59,   249,     0,   188,    59,   245, 
    0,   187,    68,   224,     0,   185,    75,   200,     0,   184,    76,   177,     0,   185,    81,   155,     0,   185,    83,   130,     0,   187,    83,   103,     0,   189,    84,    79, 
    0,   189,    86,    57,     0,   189,    87,    34,     0,   190,    86,    13,     0,   189,    87,     2,     0,   186,    89,     0,     0,   183,    91,     0,     0,   182,    93,     0, 
    0,   182,    43,   249,     0,   185,    40,   248,     0,   187,    40,   246,     0,   187,    48,   230,     0,   186,    57,   205,     0,   185,    60,   185,     0,   185,    63,   164, 
    0,   186,    65,   141,     0,   186,    67,   115,     0,   187,    67,    90,     0,   188,    68,    68,     0,   188,    70,    46,     0,   187,    72,    25,     0,   186,    74,     8, 
    0,   183,    76,     1,     0,   179,    79,     0,     0,   176,    82,     0,     0,   180,    26,   248,     0,   184,    24,   248,     0,   186,    25,   246,     0,   186,    30,   233, 
    0,   185,    41,   210,     0,   185,    43,   192,     0,   184,    46,   171,     0,   185,    48,   150,     0,   185,    50,   126,     0,   185,    52,   101,     0,   185,    52,    78, 
    0,   186,    54,    57,     0,   186,    55,    36,     0,   185,    57,    17,     0,   182,    62,     3,     0,   176,    67,     0,     0,   170,    71,     0,     0,   180,    16,   248, 
    0,   182,    12,   247,     0,   184,    12,   245,     0,   184,    16,   233,     0,   183,    25,   213,     0,   183,    29,   195,     0,   182,    32,   176,     0,   182,    34,   157, 
    0,   182,    36,   136,     0,   183,    38,   113,     0,   183,    39,    89,     0,   183,    39,    68,     0,   183,    40,    46,     0,   183,    41,    26,     0,   180,    45,     9, 
    0,   175,    51,     1,     0,   167,    60,     0,     0,   181,    11,   247,     0,   181,     3,   246,     0,   181,     3,   240,     0,   182,     6,   230,     0,   181,    13,   212, 
    0,   180,    16,   196,     0,   180,    19,   180,     0,   180,    21,   162,     0,   179,    24,   143,     0,   180,    26,   122,     0,   180,    27,    99,     0,   180,    27,    77, 
    0,   180,    26,    55,     0,   180,    28,    35,     0,   179,    30,    16,     0,   175,    34,     3,     0,   166,    45,     0,     0,   182,     8,   247,     0,   179,     1,   241, 
    0,   178,     0,   233,     0,   177,     1,   222,     0,   177,     4,   208,     0,   176,     6,   196,     0,   177,     7,   181,     0,   176,     9,   165,     0,   176,    11,   147, 
    0,   176,    12,   128,     0,   176,    13,   107,     0,   176,    13,    85,     0,   176,    13,    63,     0,   177,    12,    40,     0,   176,    15,    22,     0,   174,    19,     7, 
    0,   166,    32,     0,     0,   182,     5,   247,     0,   177,     0,   236,     0,   175,     0,   226,     0,   173,     0,   213,     0,   171,     0,   200,     0,   171,     0,   190, 
    0,   172,     1,   178,     0,   171,     1,   165,     0,   171,     1,   149,     0,   171,     1,   132,     0,   171,     2,   113,     0,   171,     2,    92,     0,   171,     2,    70, 
    0,   172,     1,    47,     0,   172,     2,    27,     0,   170,     6,    11,     0,   164,    20,     0,     0,   182,     3,   247,     0,   176,     0,   234,     0,   172,     0,   221, 
    0,   169,     0,   206,     0,   166,     0,   193,     0,   165,     0,   184,     0,   166,     0,   173,     0,   165,     0,   160,     0,   164,     0,   147,     0,   163,     0,   132, 
    0,   162,     0,   115,     0,   162,     0,    97,     0,   162,     0,    78,     0,   162,     0,    57,     0,   163,     0,    37,     0,   162,     1,    17,     0,   161,     9,     0, 
    0,   181,     0,   247,     0,   178,     0,   236,     0,   176,     0,   225,     0,   174,     0,   211,     0,   170,     0,   197,     0,   170,     0,   189,     0,   170,     0,   178, 
    0,   169,     0,   165,     0,   167,     0,   151,     0,   165,     0,   136,     0,   164,     0,   121,     0,   163,     0,   104,     0,   162,     0,    85,     0,   162,     0,    65, 
    0,   162,     0,    42,     0,   161,     0,    21,     0,   160,     0,     0,     0,   149,   217,   237,     0,   143,   225,   228,     0,   142,   231,   207,     0,   141,   235,   171, 
    0,   140,   235,   128,     0,   138,   230,    90,     0,   146,   220,    62,     0,   155,   209,    42,     0,   164,   200,    30,     0,   171,   192,    22,     0,   178,   185,    16, 
    0,   183,   178,     8,     0,   189,   172,     4,     0,   194,   166,     3,     0,   198,   161,     2,     0,   201,   156,     2,     0,   204,   152,     0,     0,   151,   203,   241, 
    0,   150,   202,   221,     0,   153,   207,   199,     0,   153,   211,   173,     0,   152,   213,   136,     0,   150,   213,    94,     0,   156,   207,    61,     0,   162,   199,    37, 
    0,   169,   192,    14,     0,   175,   183,     3,     0,   181,   175,     1,     0,   187,   168,     1,     0,   190,   161,     0,     0,   193,   156,     0,     0,   197,   152,     0, 
    0,   200,   149,     0,     0,   202,   148,     0,     0,   155,   185,   242,     0,   155,   182,   219,     0,   159,   183,   193,     0,   158,   187,   177,     0,   156,   192,   147, 
    0,   156,   194,   110,     0,   161,   191,    77,     0,   166,   188,    49,     0,   171,   182,    23,     0,   177,   175,     3,     0,   182,   167,     0,     0,   187,   160,     0, 
    0,   190,   155,     0,     0,   192,   150,     0,     0,   195,   147,     0,     0,   197,   144,     0,     0,   199,   144,     0,     0,   157,   164,   227,     0,   157,   164,   216, 
    0,   158,   164,   199,     0,   159,   166,   180,     0,   158,   173,   157,     0,   159,   176,   122,     0,   163,   175,    91,     0,   169,   172,    65,     0,   173,   169,    38, 
    0,   177,   164,    13,     0,   182,   158,     1,     0,   186,   153,     0,     0,   188,   148,     0,     0,   190,   144,     0,     0,   192,   141,     0,     0,   193,   138,     0, 
    0,   195,   138,     0,     0,   159,   150,   239,     0,   161,   150,   224,     0,   160,   149,   200,     0,   160,   149,   182,     0,   159,   153,   163,     0,   161,   157,   135, 
    0,   165,   158,   102,     0,   170,   157,    76,     0,   175,   155,    50,     0,   178,   152,    23,     0,   182,   146,     3,     0,   185,   142,     0,     0,   187,   138,     0, 
    0,   188,   135,     0,     0,   189,   132,     0,     0,   190,   130,     0,     0,   192,   130,     0,     0,   156,   127,   253,     0,   161,   130,   237,     0,   161,   133,   209, 
    0,   160,   134,   188,     0,   160,   135,   171,     0,   163,   134,   154,     0,   167,   137,   118,     0,   172,   138,    90,     0,   177,   137,    66,     0,   182,   136,    40, 
    0,   186,   132,    14,     0,   188,   127,     2,     0,   188,   125,     0,     0,   188,   123,     0,     0,   188,   121,     0,     0,   188,   120,     0,     0,   190,   120,     0, 
    0,   162,   106,   252,     0,   165,   105,   249,     0,   166,   110,   232,     0,   165,   117,   201,     0,   164,   119,   179,     0,   165,   120,   157,     0,   168,   123,   132, 
    0,   171,   123,   106,     0,   176,   123,    81,     0,   180,   123,    55,     0,   183,   121,    29,     0,   185,   118,     8,     0,   185,   116,     1,     0,   184,   115,     0, 
    0,   184,   114,     0,     0,   183,   113,     0,     0,   185,   114,     0,     0,   166,    86,   251,     0,   171,    83,   250,     0,   172,    86,   241,     0,   171,    94,   213, 
    0,   170,    98,   189,     0,   169,   101,   166,     0,   169,   105,   143,     0,   169,   107,   118,     0,   174,   107,    95,     0,   178,   107,    70,     0,   180,   107,    44, 
    0,   183,   105,    20,     0,   184,   103,     3,     0,   182,   104,     0,     0,   180,   104,     0,     0,   179,   104,     0,     0,   180,   105,     0,     0,   169,    66,   250, 
    0,   173,    62,   249,     0,   175,    64,   242,     0,   175,    72,   221,     0,   173,    78,   198,     0,   173,    82,   176,     0,   173,    85,   154,     0,   172,    88,   130, 
    0,   173,    89,   105,     0,   178,    89,    81,     0,   179,    90,    57,     0,   180,    90,    33,     0,   181,    90,    11,     0,   180,    90,     1,     0,   178,    91,     0, 
    0,   176,    92,     0,     0,   176,    94,     0,     0,   170,    46,   249,     0,   174,    43,   249,     0,   176,    45,   242,     0,   177,    53,   226,     0,   175,    61,   203, 
    0,   175,    64,   184,     0,   175,    67,   163,     0,   176,    69,   142,     0,   176,    71,   116,     0,   177,    71,    91,     0,   178,    72,    69,     0,   178,    74,    45, 
    0,   178,    75,    23,     0,   178,    75,     5,     0,   175,    77,     0,     0,   172,    80,     0,     0,   170,    83,     0,     0,   170,    29,   249,     0,   175,    27,   248, 
    0,   176,    30,   242,     0,   176,    36,   228,     0,   176,    45,   207,     0,   175,    47,   190,     0,   175,    50,   171,     0,   176,    53,   150,     0,   176,    55,   127, 
    0,   176,    56,   102,     0,   177,    56,    79,     0,   177,    57,    57,     0,   177,    58,    35,     0,   176,    59,    14,     0,   174,    64,     2,     0,   168,    68,     0, 
    0,   165,    71,     0,     0,   172,    17,   248,     0,   175,    14,   247,     0,   176,    16,   242,     0,   176,    21,   230,     0,   175,    30,   210,     0,   174,    32,   194, 
    0,   174,    35,   175,     0,   175,    37,   156,     0,   175,    39,   136,     0,   176,    40,   113,     0,   176,    41,    90,     0,   176,    41,    68,     0,   176,    42,    45, 
    0,   175,    43,    25,     0,   173,    46,     7,     0,   167,    52,     1,     0,   161,    61,     0,     0,   174,    12,   248,     0,   175,     5,   245,     0,   175,     6,   238, 
    0,   174,    10,   227,     0,   173,    17,   210,     0,   173,    18,   195,     0,   173,    21,   179,     0,   173,    23,   161,     0,   173,    25,   142,     0,   173,    27,   121, 
    0,   173,    28,    99,     0,   173,    28,    77,     0,   173,    27,    55,     0,   173,    28,    34,     0,   172,    30,    15,     0,   168,    35,     2,     0,   158,    46,     0, 
    0,   175,     8,   247,     0,   174,     1,   241,     0,   173,     1,   233,     0,   172,     2,   222,     0,   170,     6,   208,     0,   170,     6,   194,     0,   170,     8,   180, 
    0,   170,    10,   164,     0,   169,    11,   146,     0,   169,    12,   127,     0,   169,    13,   107,     0,   169,    14,    85,     0,   170,    13,    63,     0,   170,    12,    41, 
    0,   169,    15,    22,     0,   167,    18,     6,     0,   158,    32,     0,     0,   176,     5,   247,     0,   172,     0,   236,     0,   170,     0,   225,     0,   168,     0,   213, 
    0,   165,     0,   200,     0,   164,     0,   188,     0,   165,     1,   177,     0,   165,     1,   163,     0,   165,     1,   148,     0,   164,     1,   131,     0,   164,     1,   112, 
    0,   164,     2,    91,     0,   165,     1,    70,     0,   165,     1,    47,     0,   165,     1,    27,     0,   164,     5,    11,     0,   157,    20,     0,     0,   177,     3,   247, 
    0,   172,     0,   233,     0,   168,     0,   220,     0,   164,     0,   206,     0,   160,     0,   192,     0,   158,     0,   178,     0,   158,     0,   168,     0,   157,     0,   157, 
    0,   157,     0,   144,     0,   155,     0,   129,     0,   155,     0,   113,     0,   155,     0,    96,     0,   154,     0,    77,     0,   155,     0,    56,     0,   155,     0,    37, 
    0,   154,     1,    18,     0,   154,     9,     0,     0,   177,     0,   247,     0,   174,     0,   236,     0,   171,     0,   225,     0,   169,     0,   211,     0,   166,     0,   197, 
    0,   162,     0,   182,     0,   163,     0,   172,     0,   162,     0,   161,     0,   160,     0,   148,     0,   158,     0,   134,     0,   156,     0,   119,     0,   155,     0,   103, 
    0,   154,     0,    85,     0,   154,     0,    64,     0,   154,     0,    41,     0,   153,     0,    20,     0,   152,     0,     0,     0,   125,   218,   239,     0,   120,   228,   228, 
    0,   120,   231,   206,     0,   121,   231,   176,     0,   123,   232,   135,     0,   121,   229,    95,     0,   118,   227,    62,     0,   129,   216,    38,     0,   140,   207,    19, 
    0,   152,   199,    14,     0,   162,   191,    11,     0,   170,   184,     8,     0,   176,   178,     5,     0,   182,   173,     3,     0,   187,   169,     2,     0,   191,   164,     1, 
    0,   194,   159,     0,     0,   132,   203,   237,     0,   131,   203,   219,     0,   133,   207,   199,     0,   134,   209,   178,     0,   135,   210,   145,     0,   134,   211,   105, 
    0,   133,   210,    68,     0,   139,   206,    36,     0,   148,   199,    10,     0,   157,   191,     2,     0,   165,   182,     1,     0,   172,   174,     1,     0,   177,   167,     0, 
    0,   182,   162,     0,     0,   185,   159,     0,     0,   189,   156,     0,     0,   191,   155,     0,     0,   138,   185,   235,     0,   138,   184,   217,     0,   142,   185,   194, 
    0,   141,   189,   178,     0,   140,   193,   154,     0,   140,   195,   119,     0,   140,   196,    84,     0,   145,   195,    49,     0,   152,   191,    21,     0,   159,   183,     2, 
    0,   167,   175,     0,     0,   172,   167,     0,     0,   177,   161,     0,     0,   180,   157,     0,     0,   183,   153,     0,     0,   186,   150,     0,     0,   189,   150,     0, 
    0,   143,   167,   227,     0,   144,   166,   220,     0,   143,   168,   199,     0,   146,   171,   178,     0,   145,   175,   159,     0,   144,   178,   129,     0,   144,   181,    96, 
    0,   149,   179,    67,     0,   155,   176,    40,     0,   161,   172,    12,     0,   167,   166,     1,     0,   172,   159,     0,     0,   175,   154,     0,     0,   178,   150,     0, 
    0,   181,   146,     0,     0,   183,   144,     0,     0,   186,   145,     0,     0,   145,   150,   219,     0,   147,   151,   208,     0,   146,   152,   197,     0,   148,   151,   180, 
    0,   148,   155,   160,     0,   146,   160,   140,     0,   146,   164,   108,     0,   152,   163,    79,     0,   157,   162,    52,     0,   161,   160,    23,     0,   166,   155,     2, 
    0,   170,   150,     0,     0,   173,   145,     0,     0,   176,   142,     0,     0,   178,   138,     0,     0,   180,   136,     0,     0,   182,   137,     0,     0,   143,   133,   232, 
    0,   147,   135,   220,     0,   147,   135,   204,     0,   148,   136,   185,     0,   148,   138,   167,     0,   147,   141,   151,     0,   149,   145,   120,     0,   154,   146,    91, 
    0,   158,   145,    66,     0,   163,   144,    36,     0,   166,   141,    10,     0,   170,   137,     1,     0,   172,   134,     0,     0,   174,   131,     0,     0,   175,   128,     0, 
    0,   176,   126,     0,     0,   179,   127,     0,     0,   141,   109,   253,     0,   147,   111,   242,     0,   148,   115,   224,     0,   148,   119,   197,     0,   148,   121,   174, 
    0,   148,   123,   157,     0,   152,   123,   139,     0,   155,   125,   105,     0,   161,   126,    79,     0,   166,   125,    52,     0,   170,   124,    25,     0,   173,   121,     4, 
    0,   174,   119,     0,     0,   174,   117,     0,     0,   174,   115,     0,     0,   175,   114,     0,     0,   178,   112,     0,     0,   148,    89,   252,     0,   151,    88,   250, 
    0,   154,    92,   238,     0,   154,   100,   210,     0,   153,   104,   186,     0,   153,   107,   166,     0,   153,   106,   144,     0,   155,   108,   119,     0,   160,   110,    94, 
    0,   164,   110,    68,     0,   168,   110,    41,     0,   171,   108,    16,     0,   171,   105,     2,     0,   171,   104,     0,     0,   171,   104,     0,     0,   171,   103,     0, 
    0,   172,   104,     0,     0,   152,    70,   251,     0,   156,    67,   250,     0,   159,    69,   242,     0,   160,    77,   222,     0,   159,    83,   197,     0,   159,    87,   176, 
    0,   158,    88,   154,     0,   158,    91,   131,     0,   157,    93,   106,     0,   162,    95,    83,     0,   166,    94,    56,     0,   168,    94,    31,     0,   170,    92,     9, 
    0,   170,    92,     1,     0,   168,    92,     0,     0,   167,    93,     0,     0,   168,    94,     0,     0,   155,    51,   250,     0,   160,    48,   249,     0,   162,    50,   242, 
    0,   163,    58,   225,     0,   163,    65,   203,     0,   163,    68,   184,     0,   162,    71,   163,     0,   162,    73,   142,     0,   161,    75,   118,     0,   162,    76,    93, 
    0,   166,    76,    69,     0,   167,    78,    44,     0,   168,    78,    20,     0,   169,    77,     3,     0,   166,    79,     0,     0,   164,    81,     0,     0,   164,    83,     0, 
    0,   157,    33,   249,     0,   163,    30,   248,     0,   164,    34,   241,     0,   165,    41,   227,     0,   164,    49,   207,     0,   164,    51,   190,     0,   164,    55,   170, 
    0,   163,    56,   150,     0,   164,    58,   127,     0,   165,    58,   102,     0,   166,    59,    79,     0,   166,    60,    55,     0,   166,    61,    33,     0,   166,    63,    12, 
    0,   164,    66,     1,     0,   160,    68,     0,     0,   158,    71,     0,     0,   160,    19,   249,     0,   164,    16,   248,     0,   166,    19,   241,     0,   166,    24,   229, 
    0,   165,    33,   209,     0,   164,    36,   193,     0,   164,    38,   175,     0,   164,    40,   156,     0,   165,    41,   136,     0,   166,    42,   112,     0,   166,    43,    89, 
    0,   166,    43,    67,     0,   167,    44,    43,     0,   166,    46,    22,     0,   164,    48,     5,     0,   158,    55,     0,     0,   153,    61,     0,     0,   163,    13,   248, 
    0,   166,     6,   245,     0,   166,     8,   238,     0,   166,    12,   227,     0,   165,    19,   210,     0,   164,    21,   195,     0,   163,    23,   178,     0,   163,    25,   160, 
    0,   164,    26,   141,     0,   164,    27,   120,     0,   164,    28,    98,     0,   164,    29,    76,     0,   165,    28,    54,     0,   165,    30,    32,     0,   164,    31,    13, 
    0,   159,    37,     1,     0,   150,    48,     0,     0,   167,     9,   248,     0,   166,     1,   242,     0,   165,     1,   234,     0,   165,     3,   223,     0,   163,     7,   208, 
    0,   162,     8,   194,     0,   162,     9,   179,     0,   162,    11,   163,     0,   162,    12,   146,     0,   161,    13,   127,     0,   161,    14,   106,     0,   161,    15,    84, 
    0,   162,    14,    63,     0,   162,    14,    41,     0,   162,    16,    21,     0,   160,    19,     5,     0,   149,    33,     0,     0,   169,     5,   248,     0,   166,     0,   235, 
    0,   164,     0,   225,     0,   161,     0,   214,     0,   159,     1,   201,     0,   158,     1,   189,     0,   157,     1,   175,     0,   158,     1,   162,     0,   158,     1,   147, 
    0,   157,     1,   130,     0,   157,     1,   111,     0,   157,     2,    91,     0,   157,     2,    70,     0,   158,     1,    47,     0,   158,     1,    27,     0,   157,     6,    10, 
    0,   149,    21,     0,     0,   171,     3,   247,     0,   166,     0,   232,     0,   162,     0,   219,     0,   158,     0,   206,     0,   155,     0,   192,     0,   152,     0,   178, 
    0,   150,     0,   164,     0,   149,     0,   154,     0,   149,     0,   141,     0,   148,     0,   127,     0,   147,     0,   112,     0,   147,     0,    95,     0,   147,     0,    76, 
    0,   147,     0,    56,     0,   147,     0,    36,     0,   146,     1,    18,     0,   145,    10,     0,     0,   172,     0,   247,     0,   169,     0,   236,     0,   166,     0,   224, 
    0,   163,     0,   211,     0,   160,     0,   197,     0,   157,     0,   181,     0,   153,     0,   166,     0,   153,     0,   156,     0,   152,     0,   144,     0,   150,     0,   132, 
    0,   148,     0,   118,     0,   146,     0,   103,     0,   145,     0,    85,     0,   145,     0,    64,     0,   145,     0,    41,     0,   145,     0,    19,     0,   142,     0,     0, 
    0,   104,   218,   241,     0,   100,   226,   227,     0,   102,   227,   203,     0,   103,   226,   178,     0,   107,   226,   145,     0,   106,   226,   103,     0,   103,   224,    69, 
    0,    99,   224,    38,     0,   112,   214,    13,     0,   128,   204,     7,     0,   143,   198,     5,     0,   154,   192,     5,     0,   162,   186,     4,     0,   169,   180,     3, 
    0,   175,   175,     3,     0,   179,   171,     1,     0,   183,   167,     0,     0,   113,   201,   233,     0,   113,   200,   217,     0,   114,   203,   197,     0,   115,   206,   178, 
    0,   116,   207,   152,     0,   118,   206,   116,     0,   116,   208,    81,     0,   115,   210,    43,     0,   123,   204,    13,     0,   136,   196,     1,     0,   148,   188,     0, 
    0,   157,   181,     1,     0,   164,   175,     0,     0,   169,   169,     0,     0,   174,   165,     0,     0,   178,   162,     0,     0,   180,   162,     0,     0,   124,   181,   222, 
    0,   122,   182,   214,     0,   124,   185,   194,     0,   122,   190,   178,     0,   121,   193,   159,     0,   123,   195,   127,     0,   123,   196,    94,     0,   123,   196,    60, 
    0,   129,   194,    27,     0,   139,   189,     3,     0,   149,   182,     0,     0,   157,   175,     0,     0,   163,   168,     0,     0,   168,   163,     0,     0,   172,   159,     0, 
    0,   175,   156,     0,     0,   177,   157,     0,     0,   128,   163,   232,     0,   127,   165,   221,     0,   126,   168,   198,     0,   126,   175,   179,     0,   127,   177,   161, 
    0,   128,   180,   135,     0,   127,   184,   103,     0,   128,   183,    73,     0,   134,   182,    42,     0,   142,   180,    11,     0,   150,   174,     1,     0,   157,   166,     0, 
    0,   162,   160,     0,     0,   166,   155,     0,     0,   169,   151,     0,     0,   172,   149,     0,     0,   174,   150,     0,     0,   130,   149,   218,     0,   131,   150,   212, 
    0,   132,   152,   201,     0,   131,   154,   182,     0,   134,   158,   159,     0,   132,   162,   144,     0,   130,   168,   114,     0,   131,   169,    83,     0,   137,   168,    54, 
    0,   143,   166,    24,     0,   150,   163,     3,     0,   156,   157,     0,     0,   160,   151,     0,     0,   163,   147,     0,     0,   166,   143,     0,     0,   169,   140,     0, 
    0,   171,   142,     0,     0,   129,   134,   227,     0,   134,   135,   216,     0,   134,   137,   200,     0,   133,   139,   184,     0,   136,   140,   168,     0,   135,   143,   150, 
    0,   133,   149,   126,     0,   135,   151,    96,     0,   140,   151,    68,     0,   145,   151,    37,     0,   149,   149,     9,     0,   154,   145,     0,     0,   158,   141,     0, 
    0,   161,   137,     0,     0,   163,   134,     0,     0,   165,   131,     0,     0,   168,   132,     0,     0,   128,   115,   244,     0,   131,   117,   227,     0,   133,   120,   205, 
    0,   134,   122,   188,     0,   136,   125,   170,     0,   136,   126,   154,     0,   134,   128,   136,     0,   137,   131,   107,     0,   142,   133,    79,     0,   146,   133,    50, 
    0,   150,   133,    22,     0,   154,   130,     3,     0,   156,   127,     0,     0,   159,   124,     0,     0,   160,   122,     0,     0,   162,   120,     0,     0,   165,   120,     0, 
    0,   125,    92,   253,     0,   131,    95,   242,     0,   134,   101,   222,     0,   135,   104,   202,     0,   135,   107,   180,     0,   136,   109,   159,     0,   136,   110,   143, 
    0,   139,   109,   127,     0,   144,   113,    94,     0,   149,   113,    66,     0,   153,   112,    37,     0,   157,   111,    13,     0,   159,   109,     1,     0,   160,   107,     0, 
    0,   161,   106,     0,     0,   161,   104,     0,     0,   165,   103,     0,     0,   133,    73,   252,     0,   137,    72,   250,     0,   139,    77,   238,     0,   141,    83,   219, 
    0,   142,    88,   196,     0,   142,    92,   173,     0,   142,    93,   154,     0,   142,    94,   133,     0,   144,    96,   107,     0,   148,    98,    81,     0,   152,    98,    54, 
    0,   156,    96,    27,     0,   158,    93,     5,     0,   158,    93,     0,     0,   157,    93,     0,     0,   157,    93,     0,     0,   159,    93,     0,     0,   138,    55,   251, 
    0,   142,    53,   250,     0,   145,    56,   241,     0,   147,    63,   225,     0,   148,    70,   203,     0,   148,    73,   183,     0,   148,    75,   163,     0,   147,    76,   143, 
    0,   146,    79,   118,     0,   146,    81,    94,     0,   150,    82,    70,     0,   154,    82,    42,     0,   156,    80,    18,     0,   157,    79,     2,     0,   155,    80,     0, 
    0,   154,    81,     0,     0,   155,    83,     0,     0,   142,    37,   250,     0,   146,    35,   249,     0,   149,    38,   240,     0,   151,    45,   226,     0,   151,    53,   207, 
    0,   151,    56,   189,     0,   150,    60,   170,     0,   149,    61,   150,     0,   149,    62,   127,     0,   149,    64,   103,     0,   150,    65,    79,     0,   153,    64,    55, 
    0,   155,    64,    30,     0,   155,    66,     9,     0,   153,    67,     1,     0,   151,    69,     0,     0,   150,    71,     0,     0,   145,    21,   249,     0,   151,    19,   248, 
    0,   153,    22,   240,     0,   153,    29,   226,     0,   153,    37,   208,     0,   153,    39,   193,     0,   152,    42,   175,     0,   152,    43,   156,     0,   152,    45,   135, 
    0,   152,    45,   112,     0,   153,    46,    88,     0,   154,    47,    66,     0,   154,    48,    42,     0,   154,    48,    20,     0,   153,    51,     3,     0,   148,    57,     0, 
    0,   145,    61,     0,     0,   150,    13,   249,     0,   154,     8,   245,     0,   155,    10,   238,     0,   155,    14,   227,     0,   154,    22,   210,     0,   153,    24,   194, 
    0,   153,    26,   177,     0,   152,    27,   160,     0,   152,    28,   141,     0,   153,    29,   120,     0,   154,    30,    98,     0,   154,    30,    75,     0,   155,    30,    52, 
    0,   155,    32,    30,     0,   153,    33,    11,     0,   148,    39,     1,     0,   140,    49,     0,     0,   156,     9,   248,     0,   157,     2,   242,     0,   157,     2,   235, 
    0,   156,     4,   223,     0,   154,     9,   208,     0,   153,    10,   194,     0,   153,    11,   179,     0,   152,    12,   163,     0,   152,    13,   146,     0,   152,    14,   126, 
    0,   152,    15,   105,     0,   152,    15,    84,     0,   153,    15,    62,     0,   154,    15,    40,     0,   154,    17,    19,     0,   150,    21,     3,     0,   138,    34,     0, 
    0,   160,     6,   248,     0,   158,     1,   236,     0,   156,     0,   226,     0,   154,     0,   214,     0,   152,     1,   202,     0,   151,     1,   190,     0,   150,     1,   176, 
    0,   149,     1,   162,     0,   150,     1,   147,     0,   149,     1,   130,     0,   149,     2,   111,     0,   149,     2,    91,     0,   149,     2,    70,     0,   150,     2,    47, 
    0,   150,     2,    27,     0,   149,     7,     9,     0,   138,    21,     0,     0,   163,     3,   248,     0,   159,     0,   232,     0,   156,     0,   219,     0,   152,     0,   205, 
    0,   148,     0,   192,     0,   145,     0,   179,     0,   143,     0,   165,     0,   141,     0,   151,     0,   140,     0,   139,     0,   139,     0,   125,     0,   138,     0,   110, 
    0,   137,     0,    93,     0,   137,     0,    75,     0,   137,     0,    55,     0,   137,     0,    36,     0,   136,     1,    18,     0,   134,    10,     0,     0,   165,     0,   248, 
    0,   162,     0,   236,     0,   159,     0,   224,     0,   156,     0,   211,     0,   153,     0,   197,     0,   150,     0,   182,     0,   147,     0,   166,     0,   142,     0,   152, 
    0,   142,     0,   142,     0,   141,     0,   130,     0,   138,     0,   116,     0,   136,     0,   101,     0,   134,     0,    84,     0,   134,     0,    64,     0,   134,     0,    41, 
    0,   133,     0,    18,     0,   131,     0,     0,     0,    81,   219,   243,     0,    74,   228,   233,     0,    76,   228,   204,     0,    80,   227,   181,     0,    85,   226,   155, 
    0,    87,   224,   115,     0,    87,   223,    78,     0,    84,   223,    44,     0,    82,   223,    16,     0,    99,   213,     3,     0,   119,   203,     2,     0,   135,   197,     1, 
    0,   146,   192,     1,     0,   155,   188,     2,     0,   162,   183,     2,     0,   167,   178,     1,     0,   172,   174,     0,     0,    91,   203,   235,     0,    92,   201,   221, 
    0,    95,   201,   197,     0,    96,   204,   179,     0,    96,   207,   158,     0,   100,   205,   125,     0,   101,   205,    91,     0,    97,   210,    53,     0,    97,   209,    20, 
    0,   111,   201,     2,     0,   127,   192,     0,     0,   139,   186,     0,     0,   148,   181,     0,     0,   156,   176,     0,     0,   162,   172,     0,     0,   167,   168,     0, 
    0,   170,   169,     0,     0,   103,   183,   223,     0,   102,   184,   217,     0,   106,   185,   195,     0,   103,   189,   179,     0,   102,   193,   162,     0,   105,   195,   133, 
    0,   106,   196,   100,     0,   106,   196,    70,     0,   106,   197,    36,     0,   115,   193,     7,     0,   129,   185,     0,     0,   140,   180,     0,     0,   148,   174,     0, 
    0,   155,   169,     0,     0,   160,   165,     0,     0,   164,   162,     0,     0,   167,   163,     0,     0,   108,   168,   231,     0,   108,   169,   222,     0,   109,   172,   200, 
    0,   108,   176,   179,     0,   109,   179,   163,     0,   110,   182,   140,     0,   111,   184,   108,     0,   110,   185,    79,     0,   112,   185,    49,     0,   119,   182,    19, 
    0,   130,   177,     2,     0,   141,   172,     0,     0,   148,   167,     0,     0,   153,   161,     0,     0,   157,   157,     0,     0,   161,   154,     0,     0,   163,   156,     0, 
    0,   113,   151,   226,     0,   114,   150,   221,     0,   114,   152,   205,     0,   113,   156,   184,     0,   114,   162,   162,     0,   115,   165,   147,     0,   115,   170,   119, 
    0,   114,   172,    89,     0,   116,   172,    59,     0,   122,   170,    29,     0,   131,   167,     3,     0,   140,   163,     0,     0,   146,   158,     0,     0,   151,   153,     0, 
    0,   155,   148,     0,     0,   158,   145,     0,     0,   161,   147,     0,     0,   112,   137,   231,     0,   116,   140,   217,     0,   117,   138,   199,     0,   118,   140,   185, 
    0,   117,   143,   169,     0,   120,   146,   149,     0,   119,   150,   130,     0,   118,   155,   101,     0,   119,   157,    72,     0,   124,   156,    40,     0,   131,   154,    11, 
    0,   138,   151,     1,     0,   144,   147,     0,     0,   148,   142,     0,     0,   152,   138,     0,     0,   155,   135,     0,     0,   158,   137,     0,     0,   113,   116,   242, 
    0,   118,   120,   220,     0,   122,   122,   196,     0,   122,   125,   184,     0,   120,   128,   169,     0,   122,   127,   153,     0,   122,   130,   135,     0,   120,   136,   112, 
    0,   122,   140,    83,     0,   126,   139,    53,     0,   131,   138,    23,     0,   136,   137,     3,     0,   141,   134,     0,     0,   145,   130,     0,     0,   148,   127,     0, 
    0,   151,   125,     0,     0,   155,   125,     0,     0,   113,    98,   245,     0,   117,   102,   227,     0,   119,   105,   208,     0,   119,   108,   192,     0,   120,   110,   175, 
    0,   122,   112,   157,     0,   122,   113,   141,     0,   121,   118,   124,     0,   124,   121,    94,     0,   128,   121,    65,     0,   133,   120,    36,     0,   137,   119,    10, 
    0,   141,   117,     1,     0,   144,   115,     0,     0,   146,   113,     0,     0,   148,   111,     0,     0,   152,   111,     0,     0,   109,    76,   253,     0,   116,    78,   245, 
    0,   119,    82,   232,     0,   121,    89,   210,     0,   121,    92,   190,     0,   122,    95,   168,     0,   122,    95,   148,     0,   123,    97,   132,     0,   127,    97,   114, 
    0,   131,   101,    79,     0,   135,   101,    50,     0,   141,    99,    23,     0,   144,    98,     3,     0,   146,    97,     0,     0,   146,    95,     0,     0,   147,    94,     0, 
    0,   151,    92,     0,     0,   117,    59,   252,     0,   121,    57,   251,     0,   124,    60,   241,     0,   126,    69,   221,     0,   128,    74,   201,     0,   129,    77,   182, 
    0,   129,    80,   160,     0,   129,    81,   141,     0,   130,    82,   119,     0,   132,    84,    92,     0,   135,    85,    67,     0,   139,    85,    39,     0,   143,    82,    14, 
    0,   144,    80,     2,     0,   144,    81,     0,     0,   143,    81,     0,     0,   145,    82,     0,     0,   123,    41,   251,     0,   127,    40,   250,     0,   130,    43,   241, 
    0,   132,    49,   225,     0,   135,    57,   207,     0,   135,    61,   189,     0,   135,    64,   170,     0,   134,    64,   150,     0,   134,    66,   128,     0,   134,    67,   103, 
    0,   134,    69,    79,     0,   137,    70,    55,     0,   141,    69,    28,     0,   143,    67,     6,     0,   142,    66,     0,     0,   140,    67,     0,     0,   140,    69,     0, 
    0,   127,    25,   250,     0,   132,    23,   248,     0,   135,    26,   240,     0,   137,    34,   225,     0,   139,    41,   208,     0,   139,    43,   193,     0,   138,    47,   174, 
    0,   137,    48,   156,     0,   136,    50,   136,     0,   136,    50,   112,     0,   136,    52,    88,     0,   137,    53,    66,     0,   140,    52,    41,     0,   142,    52,    17, 
    0,   141,    55,     2,     0,   137,    57,     0,     0,   135,    59,     0,     0,   133,    14,   250,     0,   138,    11,   246,     0,   141,    13,   238,     0,   142,    18,   226, 
    0,   142,    25,   208,     0,   141,    27,   193,     0,   140,    30,   177,     0,   139,    31,   160,     0,   139,    32,   141,     0,   140,    32,   120,     0,   140,    33,    98, 
    0,   141,    33,    75,     0,   142,    34,    51,     0,   143,    35,    28,     0,   141,    36,     9,     0,   136,    41,     1,     0,   130,    48,     0,     0,   142,     9,   249, 
    0,   144,     3,   243,     0,   145,     3,   235,     0,   145,     7,   223,     0,   143,    11,   207,     0,   143,    13,   193,     0,   142,    14,   178,     0,   141,    15,   162, 
    0,   141,    15,   145,     0,   141,    16,   126,     0,   141,    16,   105,     0,   142,    17,    83,     0,   142,    17,    61,     0,   143,    17,    38,     0,   143,    19,    17, 
    0,   139,    23,     2,     0,   127,    34,     0,     0,   149,     6,   249,     0,   148,     1,   237,     0,   147,     0,   227,     0,   145,     0,   216,     0,   144,     1,   204, 
    0,   142,     2,   192,     0,   141,     2,   177,     0,   140,     2,   162,     0,   140,     2,   146,     0,   139,     3,   129,     0,   139,     3,   110,     0,   139,     3,    90, 
    0,   138,     4,    69,     0,   139,     4,    47,     0,   140,     3,    26,     0,   138,     8,     8,     0,   127,    21,     0,     0,   153,     3,   248,     0,   151,     0,   232, 
    0,   148,     0,   219,     0,   144,     0,   206,     0,   140,     0,   192,     0,   137,     0,   179,     0,   134,     0,   165,     0,   131,     0,   150,     0,   129,     0,   136, 
    0,   128,     0,   122,     0,   127,     0,   107,     0,   127,     0,    91,     0,   126,     0,    73,     0,   126,     0,    54,     0,   126,     0,    35,     0,   125,     2,    17, 
    0,   122,    10,     0,     0,   157,     0,   248,     0,   154,     0,   237,     0,   151,     0,   225,     0,   149,     0,   211,     0,   145,     0,   197,     0,   142,     0,   182, 
    0,   139,     0,   166,     0,   134,     0,   151,     0,   129,     0,   136,     0,   127,     0,   126,     0,   125,     0,   112,     0,   123,     0,    98,     0,   122,     0,    82, 
    0,   121,     0,    63,     0,   120,     0,    41,     0,   119,     0,    18,     0,   118,     0,     0,     0,    58,   221,   244,     0,    54,   227,   237,     0,    54,   229,   207, 
    0,    58,   229,   183,     0,    62,   228,   160,     0,    66,   226,   126,     0,    70,   226,    87,     0,    69,   227,    49,     0,    68,   226,    20,     0,    71,   224,     3, 
    0,    92,   212,     0,     0,   113,   204,     0,     0,   128,   197,     0,     0,   139,   193,     0,     0,   147,   188,     0,     0,   154,   184,     0,     0,   161,   180,     0, 
    0,    67,   206,   244,     0,    69,   205,   232,     0,    75,   200,   200,     0,    76,   205,   182,     0,    75,   208,   162,     0,    80,   206,   136,     0,    84,   205,   100, 
    0,    84,   207,    69,     0,    82,   209,    35,     0,    84,   207,     5,     0,   102,   198,     0,     0,   118,   189,     0,     0,   131,   184,     0,     0,   141,   181,     0, 
    0,   148,   178,     0,     0,   154,   175,     0,     0,   158,   175,     0,     0,    76,   192,   244,     0,    77,   191,   235,     0,    86,   184,   197,     0,    84,   190,   181, 
    0,    83,   195,   165,     0,    86,   196,   141,     0,    89,   196,   107,     0,    90,   196,    78,     0,    89,   197,    48,     0,    91,   197,    17,     0,   104,   190,     1, 
    0,   120,   182,     0,     0,   131,   177,     0,     0,   140,   174,     0,     0,   147,   171,     0,     0,   152,   168,     0,     0,   156,   169,     0,     0,    84,   173,   248, 
    0,    86,   171,   229,     0,    89,   172,   202,     0,    90,   175,   183,     0,    91,   179,   165,     0,    93,   181,   146,     0,    95,   183,   116,     0,    95,   184,    85, 
    0,    94,   186,    58,     0,    96,   186,    28,     0,   107,   182,     3,     0,   120,   175,     0,     0,   131,   169,     0,     0,   139,   166,     0,     0,   145,   163,     0, 
    0,   149,   160,     0,     0,   153,   163,     0,     0,    90,   151,   248,     0,    92,   152,   233,     0,    95,   156,   208,     0,    95,   159,   187,     0,    97,   163,   163, 
    0,    99,   166,   150,     0,   100,   168,   125,     0,   100,   171,    94,     0,    99,   174,    67,     0,   100,   174,    36,     0,   108,   171,     6,     0,   121,   165,     0, 
    0,   130,   160,     0,     0,   137,   156,     0,     0,   142,   153,     0,     0,   146,   151,     0,     0,   149,   154,     0,     0,    92,   136,   245,     0,    96,   138,   223, 
    0,   100,   140,   205,     0,   101,   141,   193,     0,   100,   145,   172,     0,   101,   150,   152,     0,   104,   152,   135,     0,   104,   156,   106,     0,   102,   160,    78, 
    0,   103,   161,    46,     0,   110,   158,    13,     0,   120,   154,     1,     0,   128,   149,     0,     0,   134,   145,     0,     0,   139,   142,     0,     0,   143,   140,     0, 
    0,   147,   143,     0,     0,    95,   119,   246,     0,    99,   123,   222,     0,   104,   128,   200,     0,   103,   128,   187,     0,   105,   131,   176,     0,   103,   131,   158, 
    0,   107,   134,   137,     0,   107,   138,   117,     0,   105,   144,    88,     0,   106,   145,    57,     0,   111,   144,    25,     0,   118,   142,     3,     0,   125,   137,     0, 
    0,   131,   133,     0,     0,   135,   130,     0,     0,   139,   127,     0,     0,   144,   130,     0,     0,    97,   102,   243,     0,   102,   105,   223,     0,   105,   108,   207, 
    0,   106,   110,   192,     0,   106,   113,   177,     0,   107,   117,   162,     0,   108,   115,   144,     0,   108,   120,   126,     0,   107,   126,   100,     0,   109,   128,    69, 
    0,   113,   127,    37,     0,   118,   125,    10,     0,   124,   122,     1,     0,   129,   118,     0,     0,   133,   116,     0,     0,   136,   114,     0,     0,   141,   115,     0, 
    0,    96,    83,   247,     0,   101,    85,   236,     0,   103,    88,   221,     0,   105,    93,   199,     0,   105,    96,   181,     0,   106,    98,   164,     0,   108,    99,   146, 
    0,   109,   101,   129,     0,   108,   106,   108,     0,   111,   108,    80,     0,   115,   108,    50,     0,   120,   105,    21,     0,   124,   105,     2,     0,   128,   102,     0, 
    0,   131,   100,     0,     0,   133,    98,     0,     0,   137,    98,     0,     0,    93,    62,   254,     0,    99,    62,   247,     0,   103,    66,   235,     0,   106,    74,   212, 
    0,   108,    77,   193,     0,   108,    81,   175,     0,   109,    82,   155,     0,   110,    83,   135,     0,   111,    84,   117,     0,   112,    85,    97,     0,   117,    88,    65, 
    0,   123,    87,    35,     0,   128,    84,    10,     0,   130,    82,     1,     0,   131,    82,     0,     0,   132,    81,     0,     0,   135,    79,     0,     0,   102,    45,   252, 
    0,   106,    44,   250,     0,   109,    47,   241,     0,   112,    54,   225,     0,   114,    60,   206,     0,   115,    64,   188,     0,   116,    67,   169,     0,   116,    68,   148, 
    0,   116,    70,   127,     0,   117,    70,   103,     0,   118,    72,    77,     0,   121,    73,    52,     0,   126,    70,    24,     0,   130,    64,     4,     0,   129,    66,     0, 
    0,   128,    67,     0,     0,   129,    68,     0,     0,   108,    29,   251,     0,   112,    28,   249,     0,   115,    30,   241,     0,   118,    38,   226,     0,   120,    45,   209, 
    0,   121,    47,   194,     0,   121,    51,   175,     0,   121,    52,   156,     0,   120,    54,   136,     0,   119,    56,   111,     0,   120,    56,    88,     0,   121,    58,    65, 
    0,   124,    57,    40,     0,   128,    55,    15,     0,   127,    55,     1,     0,   124,    56,     0,     0,   124,    57,     0,     0,   113,    15,   251,     0,   118,    14,   246, 
    0,   121,    17,   239,     0,   123,    23,   224,     0,   125,    30,   208,     0,   125,    32,   193,     0,   125,    34,   177,     0,   124,    35,   160,     0,   123,    37,   142, 
    0,   121,    39,   119,     0,   122,    39,    97,     0,   123,    40,    75,     0,   124,    41,    52,     0,   127,    39,    27,     0,   128,    39,     6,     0,   123,    43,     0, 
    0,   119,    49,     0,     0,   123,     9,   250,     0,   125,     5,   244,     0,   127,     6,   235,     0,   129,    10,   223,     0,   128,    15,   206,     0,   127,    16,   191, 
    0,   126,    18,   176,     0,   126,    19,   160,     0,   126,    19,   144,     0,   125,    20,   125,     0,   126,    20,   105,     0,   127,    21,    83,     0,   127,    21,    61, 
    0,   129,    21,    37,     0,   129,    23,    15,     0,   125,    26,     2,     0,   115,    36,     0,     0,   133,     6,   249,     0,   134,     1,   239,     0,   134,     1,   229, 
    0,   133,     1,   217,     0,   131,     3,   203,     0,   129,     4,   190,     0,   128,     5,   175,     0,   127,     5,   160,     0,   126,     5,   144,     0,   125,     5,   127, 
    0,   125,     5,   109,     0,   125,     6,    89,     0,   125,     6,    68,     0,   126,     6,    46,     0,   127,     6,    25,     0,   125,     9,     7,     0,   114,    23,     0, 
    0,   141,     3,   249,     0,   140,     0,   233,     0,   137,     0,   220,     0,   134,     0,   206,     0,   130,     0,   192,     0,   127,     0,   178,     0,   123,     0,   164, 
    0,   121,     0,   149,     0,   118,     0,   134,     0,   116,     0,   119,     0,   115,     0,   104,     0,   115,     0,    89,     0,   115,     0,    72,     0,   114,     0,    53, 
    0,   114,     0,    34,     0,   113,     2,    16,     0,   110,    11,     0,     0,   147,     0,   248,     0,   144,     0,   238,     0,   142,     0,   226,     0,   139,     0,   213, 
    0,   136,     0,   197,     0,   132,     0,   181,     0,   128,     0,   165,     0,   123,     0,   148,     0,   118,     0,   133,     0,   112,     0,   118,     0,   110,     0,   107, 
    0,   109,     0,    94,     0,   108,     0,    79,     0,   107,     0,    61,     0,   106,     0,    41,     0,   105,     0,    18,     0,   104,     0,     0,     0,    41,   223,   245, 
    0,    37,   227,   239,     0,    35,   233,   214,     0,    39,   234,   188,     0,    44,   233,   165,     0,    48,   233,   134,     0,    52,   233,    94,     0,    55,   234,    54, 
    0,    59,   230,    29,     0,    60,   228,     7,     0,    65,   224,     0,     0,    87,   213,     0,     0,   107,   204,     0,     0,   121,   198,     0,     0,   133,   193,     0, 
    0,   142,   190,     0,     0,   149,   186,     0,     0,    48,   207,   247,     0,    50,   206,   236,     0,    57,   200,   204,     0,    56,   207,   186,     0,    55,   211,   164, 
    0,    60,   210,   142,     0,    65,   208,   110,     0,    69,   207,    78,     0,    70,   208,    49,     0,    67,   211,    13,     0,    75,   205,     0,     0,    94,   196,     0, 
    0,   110,   188,     0,     0,   123,   184,     0,     0,   133,   181,     0,     0,   141,   180,     0,     0,   146,   181,     0,     0,    56,   193,   248,     0,    58,   192,   239, 
    0,    67,   185,   201,     0,    66,   191,   185,     0,    64,   196,   167,     0,    67,   197,   146,     0,    71,   197,   117,     0,    74,   197,    85,     0,    74,   198,    58, 
    0,    74,   199,    27,     0,    78,   196,     4,     0,    95,   187,     0,     0,   111,   180,     0,     0,   123,   176,     0,     0,   132,   173,     0,     0,   139,   172,     0, 
    0,   144,   175,     0,     0,    65,   175,   250,     0,    66,   175,   241,     0,    73,   174,   205,     0,    72,   176,   186,     0,    73,   179,   167,     0,    76,   181,   149, 
    0,    78,   182,   124,     0,    80,   184,    93,     0,    79,   187,    65,     0,    79,   188,    35,     0,    81,   187,     7,     0,    97,   179,     1,     0,   112,   172,     0, 
    0,   122,   167,     0,     0,   129,   165,     0,     0,   136,   163,     0,     0,   140,   168,     0,     0,    73,   152,   251,     0,    73,   156,   243,     0,    78,   158,   210, 
    0,    78,   161,   190,     0,    80,   162,   167,     0,    83,   164,   151,     0,    86,   165,   132,     0,    85,   169,   102,     0,    84,   174,    74,     0,    83,   175,    44, 
    0,    86,   175,    12,     0,    99,   169,     1,     0,   112,   163,     0,     0,   120,   158,     0,     0,   127,   155,     0,     0,   133,   153,     0,     0,   136,   158,     0, 
    0,    76,   136,   251,     0,    79,   139,   234,     0,    83,   142,   213,     0,    82,   145,   196,     0,    82,   148,   175,     0,    84,   151,   152,     0,    87,   152,   136, 
    0,    88,   156,   111,     0,    87,   161,    83,     0,    87,   162,    53,     0,    89,   161,    20,     0,    99,   158,     2,     0,   110,   153,     0,     0,   118,   148,     0, 
    0,   124,   144,     0,     0,   130,   142,     0,     0,   133,   147,     0,     0,    77,   121,   250,     0,    82,   126,   226,     0,    86,   129,   204,     0,    87,   130,   192, 
    0,    87,   131,   180,     0,    87,   135,   160,     0,    88,   139,   140,     0,    89,   142,   120,     0,    89,   146,    93,     0,    89,   149,    64,     0,    90,   148,    32, 
    0,    97,   147,     4,     0,   107,   142,     0,     0,   115,   137,     0,     0,   122,   132,     0,     0,   127,   129,     0,     0,   131,   133,     0,     0,    81,   104,   247, 
    0,    85,   108,   227,     0,    87,   112,   210,     0,    89,   116,   194,     0,    89,   118,   177,     0,    90,   119,   163,     0,    89,   122,   146,     0,    93,   125,   124, 
    0,    93,   128,   103,     0,    91,   133,    74,     0,    92,   133,    41,     0,    97,   131,    11,     0,   106,   128,     1,     0,   113,   123,     0,     0,   119,   119,     0, 
    0,   124,   116,     0,     0,   128,   118,     0,     0,    82,    87,   246,     0,    86,    89,   232,     0,    88,    93,   217,     0,    90,    97,   197,     0,    93,    99,   177, 
    0,    92,   101,   164,     0,    92,   105,   147,     0,    94,   106,   130,     0,    96,   108,   108,     0,    94,   114,    83,     0,    93,   117,    53,     0,    99,   113,    22, 
    0,   105,   112,     2,     0,   112,   108,     0,     0,   117,   105,     0,     0,   120,   102,     0,     0,   125,   102,     0,     0,    79,    69,   248,     0,    84,    71,   238, 
    0,    87,    74,   225,     0,    90,    78,   205,     0,    91,    81,   187,     0,    91,    85,   173,     0,    91,    86,   155,     0,    94,    88,   135,     0,    94,    89,   114, 
    0,    92,    94,    92,     0,    96,    96,    65,     0,   102,    94,    34,     0,   107,    92,     9,     0,   112,    91,     1,     0,   115,    89,     0,     0,   117,    87,     0, 
    0,   121,    86,     0,     0,    76,    49,   254,     0,    83,    49,   247,     0,    87,    52,   237,     0,    90,    59,   220,     0,    92,    64,   203,     0,    94,    66,   186, 
    0,    94,    69,   167,     0,    95,    70,   146,     0,    96,    72,   122,     0,    96,    74,   103,     0,    95,    74,    84,     0,   103,    75,    49,     0,   110,    72,    20, 
    0,   113,    71,     2,     0,   115,    70,     0,     0,   115,    70,     0,     0,   118,    68,     0,     0,    85,    33,   253,     0,    90,    32,   250,     0,    94,    35,   241, 
    0,    97,    41,   227,     0,    99,    47,   209,     0,   101,    50,   193,     0,   102,    54,   175,     0,   102,    56,   156,     0,   102,    58,   133,     0,   101,    59,   110, 
    0,   102,    59,    88,     0,   104,    60,    63,     0,   109,    58,    37,     0,   113,    55,    12,     0,   113,    56,     1,     0,   111,    59,     0,     0,   111,    60,     0, 
    0,    93,    18,   251,     0,    98,    17,   249,     0,   101,    20,   241,     0,   104,    26,   227,     0,   106,    33,   210,     0,   107,    35,   195,     0,   108,    38,   178, 
    0,   108,    39,   161,     0,   108,    40,   142,     0,   106,    43,   119,     0,   105,    44,    96,     0,   107,    44,    74,     0,   108,    46,    50,     0,   111,    44,    26, 
    0,   113,    43,     4,     0,   109,    46,     0,     0,   106,    48,     0,     0,   103,    10,   250,     0,   105,     7,   245,     0,   108,     9,   236,     0,   110,    13,   224, 
    0,   110,    19,   207,     0,   110,    20,   192,     0,   111,    23,   177,     0,   111,    23,   161,     0,   111,    24,   145,     0,   110,    25,   126,     0,   109,    27,   104, 
    0,   109,    27,    83,     0,   110,    27,    61,     0,   112,    29,    37,     0,   114,    27,    14,     0,   111,    30,     1,     0,   102,    36,     0,     0,   114,     6,   250, 
    0,   114,     2,   242,     0,   114,     2,   232,     0,   114,     4,   218,     0,   113,     6,   203,     0,   113,     7,   188,     0,   112,     8,   173,     0,   112,     8,   158, 
    0,   111,     8,   142,     0,   110,     8,   126,     0,   110,     9,   108,     0,   110,     9,    89,     0,   111,     9,    68,     0,   111,     9,    45,     0,   113,    10,    23, 
    0,   112,    12,     5,     0,   100,    24,     0,     0,   124,     3,   249,     0,   123,     0,   236,     0,   121,     0,   223,     0,   119,     0,   209,     0,   116,     1,   193, 
    0,   114,     1,   179,     0,   111,     1,   164,     0,   109,     1,   149,     0,   106,     1,   134,     0,   104,     1,   118,     0,   102,     1,   103,     0,   103,     1,    88, 
    0,   103,     1,    71,     0,   103,     1,    52,     0,   102,     1,    33,     0,   102,     3,    14,     0,    97,    12,     0,     0,   133,     0,   249,     0,   130,     0,   239, 
    0,   128,     0,   228,     0,   126,     0,   214,     0,   123,     0,   198,     0,   119,     0,   181,     0,   115,     0,   164,     0,   110,     0,   147,     0,   105,     0,   130, 
    0,   100,     0,   114,     0,    95,     0,   100,     0,    94,     0,    89,     0,    93,     0,    75,     0,    92,     0,    58,     0,    92,     0,    39,     0,    91,     0,    18, 
    0,    90,     0,     0,     0,    32,   224,   245,     0,    30,   229,   243,     0,    23,   238,   229,     0,    22,   242,   196,     0,    29,   240,   168,     0,    34,   239,   139, 
    0,    39,   239,   104,     0,    44,   239,    61,     0,    48,   237,    32,     0,    50,   234,    11,     0,    54,   229,     2,     0,    60,   224,     0,     0,    82,   214,     0, 
    0,   101,   205,     0,     0,   115,   199,     0,     0,   126,   193,     0,     0,   136,   190,     0,     0,    34,   207,   247,     0,    34,   207,   238,     0,    39,   204,   211, 
    0,    38,   209,   191,     0,    38,   213,   168,     0,    42,   214,   145,     0,    46,   212,   119,     0,    53,   210,    86,     0,    56,   210,    58,     0,    56,   211,    30, 
    0,    57,   210,     5,     0,    68,   204,     0,     0,    86,   195,     0,     0,   103,   189,     0,     0,   116,   184,     0,     0,   126,   182,     0,     0,   132,   184,     0, 
    0,    40,   193,   248,     0,    39,   194,   242,     0,    45,   191,   209,     0,    46,   193,   188,     0,    46,   197,   169,     0,    49,   198,   148,     0,    52,   198,   125, 
    0,    56,   198,    94,     0,    59,   199,    65,     0,    60,   200,    37,     0,    59,   200,    10,     0,    69,   194,     1,     0,    87,   186,     0,     0,   103,   179,     0, 
    0,   115,   176,     0,     0,   123,   174,     0,     0,   129,   177,     0,     0,    48,   176,   249,     0,    47,   177,   245,     0,    49,   179,   219,     0,    51,   179,   192, 
    0,    54,   181,   170,     0,    56,   184,   153,     0,    58,   185,   131,     0,    61,   186,   101,     0,    63,   188,    71,     0,    63,   189,    42,     0,    63,   190,    12, 
    0,    72,   185,     1,     0,    90,   176,     0,     0,   104,   170,     0,     0,   113,   167,     0,     0,   120,   165,     0,     0,   126,   170,     0,     0,    58,   156,   251, 
    0,    55,   158,   248,     0,    55,   163,   226,     0,    58,   164,   196,     0,    61,   163,   168,     0,    63,   167,   153,     0,    64,   169,   134,     0,    66,   172,   109, 
    0,    68,   175,    80,     0,    68,   177,    51,     0,    68,   177,    18,     0,    76,   174,     1,     0,    91,   166,     0,     0,   102,   161,     0,     0,   111,   158,     0, 
    0,   118,   156,     0,     0,   122,   161,     0,     0,    63,   136,   252,     0,    62,   138,   245,     0,    64,   145,   222,     0,    64,   148,   200,     0,    65,   150,   177, 
    0,    67,   153,   154,     0,    69,   155,   139,     0,    69,   158,   117,     0,    71,   162,    90,     0,    72,   164,    62,     0,    72,   164,    28,     0,    76,   162,     3, 
    0,    89,   156,     0,     0,   100,   152,     0,     0,   108,   148,     0,     0,   115,   145,     0,     0,   119,   151,     0,     0,    62,   122,   251,     0,    66,   126,   232, 
    0,    70,   131,   209,     0,    72,   133,   198,     0,    71,   135,   184,     0,    71,   139,   162,     0,    71,   141,   138,     0,    71,   145,   121,     0,    73,   148,    96, 
    0,    74,   151,    69,     0,    73,   151,    38,     0,    75,   150,     7,     0,    87,   146,     0,     0,    98,   140,     0,     0,   106,   136,     0,     0,   113,   133,     0, 
    0,   116,   138,     0,     0,    64,   106,   248,     0,    68,   111,   228,     0,    71,   118,   207,     0,    73,   119,   194,     0,    74,   121,   181,     0,    75,   122,   168, 
    0,    75,   128,   146,     0,    73,   130,   124,     0,    75,   132,   103,     0,    76,   136,    78,     0,    74,   139,    48,     0,    75,   137,    17,     0,    85,   133,     1, 
    0,    96,   128,     0,     0,   104,   123,     0,     0,   111,   120,     0,     0,   114,   124,     0,     0,    67,    88,   247,     0,    73,    93,   230,     0,    75,    97,   212, 
    0,    76,   100,   197,     0,    77,   104,   181,     0,    76,   107,   166,     0,    77,   108,   150,     0,    77,   111,   132,     0,    79,   113,   106,     0,    78,   117,    87, 
    0,    75,   124,    58,     0,    77,   122,    27,     0,    84,   119,     3,     0,    94,   114,     0,     0,   102,   109,     0,     0,   108,   106,     0,     0,   111,   108,     0, 
    0,    66,    72,   246,     0,    72,    78,   229,     0,    74,    81,   215,     0,    75,    83,   202,     0,    76,    86,   188,     0,    79,    88,   173,     0,    78,    90,   155, 
    0,    79,    94,   137,     0,    80,    94,   117,     0,    79,    97,    94,     0,    78,   102,    69,     0,    80,   102,    41,     0,    86,   100,    14,     0,    93,    97,     1, 
    0,    99,    93,     0,     0,   104,    91,     0,     0,   107,    92,     0,     0,    63,    55,   249,     0,    68,    56,   238,     0,    71,    60,   227,     0,    74,    65,   212, 
    0,    75,    67,   199,     0,    77,    70,   181,     0,    78,    74,   161,     0,    78,    76,   142,     0,    80,    77,   120,     0,    79,    79,   100,     0,    78,    82,    77, 
    0,    82,    82,    52,     0,    88,    81,    23,     0,    93,    79,     2,     0,    97,    77,     0,     0,   100,    75,     0,     0,   103,    75,     0,     0,    59,    36,   254, 
    0,    67,    36,   247,     0,    71,    40,   237,     0,    75,    45,   223,     0,    77,    50,   207,     0,    79,    53,   190,     0,    80,    57,   172,     0,    81,    58,   153, 
    0,    81,    60,   130,     0,    81,    62,   107,     0,    81,    62,    88,     0,    80,    62,    71,     0,    89,    60,    34,     0,    95,    61,     7,     0,    97,    61,     0, 
    0,    98,    61,     0,     0,    99,    59,     0,     0,    69,    21,   253,     0,    75,    20,   250,     0,    79,    22,   243,     0,    82,    29,   228,     0,    84,    35,   211, 
    0,    85,    37,   196,     0,    85,    40,   180,     0,    86,    42,   161,     0,    87,    43,   142,     0,    87,    45,   118,     0,    86,    46,    96,     0,    88,    46,    75, 
    0,    90,    47,    48,     0,    94,    44,    22,     0,    96,    44,     3,     0,    95,    46,     0,     0,    93,    48,     0,     0,    82,    12,   252,     0,    84,     9,   248, 
    0,    87,    10,   241,     0,    90,    14,   229,     0,    90,    21,   211,     0,    91,    23,   196,     0,    91,    25,   180,     0,    92,    26,   163,     0,    93,    27,   146, 
    0,    93,    28,   126,     0,    91,    30,   104,     0,    91,    30,    82,     0,    92,    30,    60,     0,    93,    32,    35,     0,    96,    30,    13,     0,    94,    32,     1, 
    0,    88,    36,     0,     0,    93,     6,   251,     0,    94,     2,   244,     0,    94,     3,   235,     0,    95,     5,   222,     0,    95,     9,   207,     0,    95,     9,   192, 
    0,    96,    11,   176,     0,    96,    11,   160,     0,    96,    11,   144,     0,    95,    12,   127,     0,    95,    12,   109,     0,    93,    14,    88,     0,    94,    14,    68, 
    0,    95,    14,    45,     0,    96,    15,    22,     0,    97,    16,     3,     0,    85,    24,     0,     0,   105,     3,   250,     0,   104,     0,   238,     0,   102,     0,   227, 
    0,   101,     0,   214,     0,   100,     1,   200,     0,    99,     1,   184,     0,    98,     1,   168,     0,    96,     1,   151,     0,    94,     1,   135,     0,    93,     1,   120, 
    0,    91,     1,   104,     0,    90,     1,    87,     0,    91,     1,    71,     0,    91,     1,    51,     0,    91,     1,    31,     0,    90,     3,    12,     0,    81,    12,     0, 
    0,   115,     0,   250,     0,   112,     0,   241,     0,   110,     0,   231,     0,   109,     0,   217,     0,   107,     0,   201,     0,   104,     0,   184,     0,   101,     0,   165, 
    0,    97,     0,   146,     0,    92,     0,   129,     0,    88,     0,   112,     0,    83,     0,    97,     0,    78,     0,    82,     0,    77,     0,    71,     0,    77,     0,    56, 
    0,    77,     0,    37,     0,    76,     0,    18,     0,    75,     0,     0,     0,    26,   226,   245,     0,    26,   229,   244,     0,    20,   236,   236,     0,    14,   244,   202, 
    0,    17,   244,   172,     0,    21,   245,   145,     0,    25,   244,   112,     0,    30,   244,    69,     0,    37,   244,    34,     0,    42,   238,    14,     0,    47,   234,     5, 
    0,    51,   228,     0,     0,    56,   224,     0,     0,    77,   215,     0,     0,    95,   206,     0,     0,   109,   199,     0,     0,   120,   194,     0,     0,    26,   208,   247, 
    0,    23,   209,   238,     0,    26,   207,   214,     0,    25,   212,   194,     0,    24,   216,   172,     0,    27,   217,   149,     0,    31,   215,   124,     0,    37,   214,    95, 
    0,    43,   213,    64,     0,    46,   213,    41,     0,    46,   212,    14,     0,    50,   209,     1,     0,    61,   203,     0,     0,    79,   196,     0,     0,    95,   190,     0, 
    0,   108,   186,     0,     0,   117,   187,     0,     0,    27,   192,   248,     0,    24,   195,   243,     0,    27,   196,   212,     0,    29,   197,   189,     0,    31,   199,   172, 
    0,    33,   200,   152,     0,    36,   201,   130,     0,    40,   201,   103,     0,    44,   201,    72,     0,    47,   201,    44,     0,    47,   201,    18,     0,    51,   199,     2, 
    0,    62,   193,     0,     0,    80,   185,     0,     0,    96,   180,     0,     0,   106,   178,     0,     0,   113,   181,     0,     0,    33,   176,   249,     0,    31,   178,   247, 
    0,    30,   183,   226,     0,    33,   183,   193,     0,    36,   183,   170,     0,    38,   187,   154,     0,    39,   189,   133,     0,    42,   190,   108,     0,    46,   190,    77, 
    0,    48,   192,    48,     0,    49,   191,    19,     0,    54,   190,     1,     0,    66,   183,     0,     0,    83,   175,     0,     0,    94,   170,     0,     0,   104,   169,     0, 
    0,   110,   174,     0,     0,    42,   158,   250,     0,    39,   160,   249,     0,    37,   166,   234,     0,    39,   167,   200,     0,    42,   166,   170,     0,    42,   172,   155, 
    0,    43,   176,   138,     0,    45,   178,   116,     0,    49,   178,    86,     0,    51,   180,    57,     0,    52,   181,    26,     0,    55,   180,     2,     0,    68,   172,     0, 
    0,    81,   165,     0,     0,    92,   161,     0,     0,   101,   159,     0,     0,   106,   165,     0,     0,    49,   138,   251,     0,    46,   139,   248,     0,    45,   146,   232, 
    0,    46,   151,   205,     0,    46,   154,   180,     0,    46,   158,   155,     0,    47,   160,   140,     0,    49,   163,   121,     0,    51,   166,    95,     0,    53,   167,    68, 
    0,    53,   169,    37,     0,    54,   169,     6,     0,    66,   162,     0,     0,    79,   155,     0,     0,    90,   150,     0,     0,    99,   148,     0,     0,   102,   155,     0, 
    0,    49,   122,   251,     0,    50,   125,   239,     0,    54,   131,   218,     0,    54,   135,   204,     0,    52,   139,   186,     0,    52,   142,   164,     0,    52,   144,   140, 
    0,    52,   149,   124,     0,    52,   153,   102,     0,    54,   154,    75,     0,    55,   157,    45,     0,    54,   156,    14,     0,    63,   151,     1,     0,    77,   144,     0, 
    0,    89,   139,     0,     0,    97,   137,     0,     0,    99,   143,     0,     0,    49,   108,   250,     0,    52,   112,   230,     0,    57,   119,   208,     0,    57,   121,   198, 
    0,    57,   123,   186,     0,    57,   126,   172,     0,    56,   131,   148,     0,    54,   135,   125,     0,    56,   137,   106,     0,    57,   139,    81,     0,    56,   144,    53, 
    0,    55,   143,    23,     0,    60,   140,     2,     0,    76,   132,     0,     0,    87,   127,     0,     0,    95,   124,     0,     0,    98,   129,     0,     0,    52,    90,   250, 
    0,    57,    95,   228,     0,    60,   101,   205,     0,    59,   105,   196,     0,    59,   108,   183,     0,    60,   110,   169,     0,    61,   111,   155,     0,    60,   116,   132, 
    0,    59,   117,   108,     0,    59,   121,    88,     0,    57,   127,    64,     0,    56,   129,    32,     0,    59,   128,     5,     0,    74,   119,     0,     0,    85,   113,     0, 
    0,    92,   110,     0,     0,    96,   114,     0,     0,    53,    73,   247,     0,    59,    78,   230,     0,    61,    83,   214,     0,    61,    85,   203,     0,    61,    89,   191, 
    0,    62,    92,   175,     0,    62,    95,   154,     0,    64,    97,   137,     0,    63,    99,   118,     0,    62,   100,    92,     0,    63,   103,    73,     0,    61,   108,    46, 
    0,    62,   108,    18,     0,    73,   103,     1,     0,    83,    98,     0,     0,    89,    94,     0,     0,    92,    97,     0,     0,    51,    58,   246,     0,    54,    62,   233, 
    0,    56,    66,   222,     0,    58,    70,   210,     0,    59,    72,   197,     0,    62,    75,   178,     0,    66,    77,   155,     0,    65,    79,   139,     0,    65,    81,   121, 
    0,    66,    82,    99,     0,    65,    83,    79,     0,    64,    87,    56,     0,    65,    88,    29,     0,    72,    86,     3,     0,    80,    82,     0,     0,    86,    79,     0, 
    0,    88,    80,     0,     0,    47,    42,   250,     0,    53,    43,   238,     0,    56,    47,   228,     0,    58,    52,   215,     0,    59,    55,   202,     0,    61,    58,   184, 
    0,    63,    61,   166,     0,    64,    63,   148,     0,    64,    65,   129,     0,    65,    66,   105,     0,    64,    67,    85,     0,    62,    69,    63,     0,    66,    69,    36, 
    0,    73,    68,     9,     0,    79,    66,     1,     0,    82,    65,     0,     0,    83,    65,     0,     0,    44,    26,   254,     0,    53,    25,   247,     0,    57,    26,   239, 
    0,    59,    33,   225,     0,    61,    37,   209,     0,    62,    39,   195,     0,    63,    42,   180,     0,    65,    44,   162,     0,    66,    46,   142,     0,    66,    48,   117, 
    0,    66,    49,    94,     0,    66,    48,    75,     0,    65,    48,    57,     0,    74,    46,    19,     0,    79,    47,     2,     0,    80,    47,     0,     0,    80,    47,     0, 
    0,    58,    15,   253,     0,    61,    12,   249,     0,    65,    12,   242,     0,    68,    15,   231,     0,    68,    23,   212,     0,    68,    24,   198,     0,    69,    27,   183, 
    0,    70,    28,   166,     0,    71,    29,   147,     0,    72,    30,   126,     0,    72,    32,   103,     0,    71,    33,    82,     0,    73,    32,    59,     0,    75,    33,    33, 
    0,    79,    32,     9,     0,    78,    32,     1,     0,    75,    34,     0,     0,    72,     8,   252,     0,    73,     4,   246,     0,    74,     3,   240,     0,    75,     6,   228, 
    0,    75,    10,   212,     0,    75,    11,   198,     0,    76,    13,   181,     0,    76,    13,   165,     0,    77,    14,   147,     0,    78,    14,   129,     0,    78,    15,   110, 
    0,    76,    16,    88,     0,    76,    17,    67,     0,    77,    17,    44,     0,    78,    19,    20,     0,    79,    19,     2,     0,    70,    24,     0,     0,    84,     3,   251, 
    0,    84,     1,   241,     0,    83,     0,   231,     0,    82,     0,   220,     0,    81,     1,   207,     0,    81,     1,   193,     0,    81,     2,   176,     0,    80,     1,   158, 
    0,    80,     1,   140,     0,    79,     1,   124,     0,    79,     1,   108,     0,    78,     2,    90,     0,    77,     2,    71,     0,    77,     2,    51,     0,    78,     2,    29, 
    0,    77,     4,     9,     0,    67,    12,     0,     0,    96,     0,   251,     0,    93,     0,   242,     0,    92,     0,   232,     0,    91,     0,   220,     0,    89,     0,   205, 
    0,    88,     0,   188,     0,    85,     0,   169,     0,    82,     0,   148,     0,    78,     0,   128,     0,    74,     0,   111,     0,    70,     0,    95,     0,    66,     0,    79, 
    0,    63,     0,    67,     0,    62,     0,    54,     0,    62,     0,    37,     0,    62,     0,    18,     0,    61,     0,     0,     0,    20,   229,   245,     0,    21,   230,   245, 
    0,    18,   234,   239,     0,    10,   242,   207,     0,    12,   244,   177,     0,    16,   243,   153,     0,    20,   243,   125,     0,    25,   243,    91,     0,    30,   243,    52, 
    0,    36,   241,    25,     0,    41,   236,    12,     0,    45,   232,     5,     0,    48,   227,     0,     0,    52,   225,     0,     0,    72,   215,     0,     0,    89,   207,     0, 
    0,   103,   200,     0,     0,    20,   209,   246,     0,    15,   208,   235,     0,    19,   207,   212,     0,    18,   211,   194,     0,    14,   217,   177,     0,    16,   218,   156, 
    0,    18,   219,   130,     0,    23,   218,   104,     0,    29,   216,    72,     0,    35,   215,    47,     0,    39,   213,    28,     0,    40,   213,     7,     0,    45,   208,     0, 
    0,    54,   203,     0,     0,    72,   197,     0,     0,    88,   192,     0,     0,    98,   193,     0,     0,    20,   192,   247,     0,    14,   196,   242,     0,    16,   197,   210, 
    0,    17,   199,   188,     0,    18,   201,   173,     0,    19,   203,   156,     0,    22,   203,   134,     0,    26,   203,   112,     0,    30,   203,    82,     0,    35,   204,    53, 
    0,    37,   205,    28,     0,    38,   203,     4,     0,    47,   198,     0,     0,    57,   192,     0,     0,    74,   186,     0,     0,    86,   183,     0,     0,    94,   187,     0, 
    0,    23,   176,   248,     0,    19,   179,   246,     0,    16,   184,   226,     0,    17,   186,   193,     0,    18,   188,   171,     0,    20,   190,   157,     0,    22,   192,   137, 
    0,    26,   192,   116,     0,    30,   192,    88,     0,    34,   194,    58,     0,    36,   195,    28,     0,    38,   193,     4,     0,    49,   188,     0,     0,    60,   182,     0, 
    0,    73,   176,     0,     0,    84,   173,     0,     0,    91,   179,     0,     0,    29,   159,   249,     0,    25,   160,   248,     0,    22,   166,   233,     0,    21,   170,   200, 
    0,    21,   172,   172,     0,    21,   177,   156,     0,    23,   180,   140,     0,    26,   180,   120,     0,    29,   181,    94,     0,    33,   182,    65,     0,    35,   185,    35, 
    0,    36,   184,     7,     0,    46,   179,     0,     0,    58,   172,     0,     0,    71,   166,     0,     0,    83,   162,     0,     0,    88,   170,     0,     0,    35,   140,   250, 
    0,    32,   141,   249,     0,    28,   146,   236,     0,    27,   153,   207,     0,    25,   157,   181,     0,    24,   160,   156,     0,    27,   163,   140,     0,    29,   165,   123, 
    0,    30,   168,   101,     0,    33,   170,    73,     0,    35,   173,    45,     0,    35,   174,    15,     0,    43,   169,     1,     0,    55,   162,     0,     0,    70,   155,     0, 
    0,    81,   151,     0,     0,    85,   159,     0,     0,    37,   124,   251,     0,    36,   125,   245,     0,    35,   129,   232,     0,    33,   136,   212,     0,    31,   143,   191, 
    0,    31,   147,   169,     0,    32,   147,   139,     0,    32,   151,   125,     0,    32,   155,   106,     0,    34,   157,    79,     0,    35,   160,    52,     0,    35,   162,    22, 
    0,    40,   159,     2,     0,    53,   152,     0,     0,    69,   143,     0,     0,    80,   139,     0,     0,    82,   148,     0,     0,    36,   109,   251,     0,    37,   112,   235, 
    0,    38,   117,   216,     0,    39,   122,   206,     0,    39,   127,   195,     0,    37,   131,   175,     0,    37,   135,   150,     0,    36,   137,   126,     0,    37,   140,   108, 
    0,    37,   143,    86,     0,    36,   146,    60,     0,    35,   150,    29,     0,    37,   148,     4,     0,    52,   140,     0,     0,    68,   131,     0,     0,    79,   127,     0, 
    0,    80,   134,     0,     0,    37,    92,   250,     0,    40,    98,   228,     0,    42,   105,   205,     0,    42,   108,   198,     0,    42,   110,   184,     0,    43,   113,   173, 
    0,    43,   116,   159,     0,    41,   120,   134,     0,    41,   120,   108,     0,    40,   124,    92,     0,    39,   129,    68,     0,    37,   134,    39,     0,    37,   135,     9, 
    0,    50,   128,     1,     0,    66,   119,     0,     0,    77,   114,     0,     0,    78,   120,     0,     0,    40,    74,   249,     0,    43,    78,   234,     0,    44,    84,   216, 
    0,    45,    89,   204,     0,    44,    93,   191,     0,    44,    96,   171,     0,    45,    98,   157,     0,    47,    99,   139,     0,    44,   103,   119,     0,    43,   103,    94, 
    0,    44,   106,    74,     0,    42,   111,    49,     0,    40,   115,    19,     0,    49,   111,     2,     0,    64,   102,     0,     0,    74,    98,     0,     0,    75,   103,     0, 
    0,    41,    59,   248,     0,    43,    62,   236,     0,    44,    65,   225,     0,    45,    71,   209,     0,    47,    75,   194,     0,    49,    78,   177,     0,    49,    81,   158, 
    0,    48,    83,   141,     0,    49,    84,   124,     0,    47,    86,   101,     0,    49,    85,    78,     0,    47,    89,    58,     0,    43,    94,    32,     0,    47,    93,     5, 
    0,    62,    86,     0,     0,    70,    83,     0,     0,    71,    85,     0,     0,    38,    45,   248,     0,    41,    49,   233,     0,    42,    52,   223,     0,    43,    57,   209, 
    0,    44,    61,   196,     0,    46,    64,   180,     0,    48,    65,   165,     0,    50,    66,   146,     0,    51,    68,   129,     0,    50,    69,   107,     0,    50,    70,    86, 
    0,    48,    70,    65,     0,    48,    74,    41,     0,    50,    73,    15,     0,    59,    71,     1,     0,    67,    68,     0,     0,    67,    69,     0,     0,    35,    31,   252, 
    0,    39,    33,   236,     0,    42,    35,   226,     0,    44,    39,   214,     0,    45,    41,   200,     0,    45,    45,   188,     0,    46,    48,   174,     0,    48,    50,   156, 
    0,    49,    52,   135,     0,    50,    53,   114,     0,    50,    54,    91,     0,    49,    54,    71,     0,    47,    56,    46,     0,    52,    55,    21,     0,    59,    53,     2, 
    0,    63,    51,     0,     0,    63,    52,     0,     0,    32,    18,   254,     0,    39,    16,   246,     0,    43,    17,   238,     0,    45,    20,   227,     0,    46,    25,   210, 
    0,    46,    27,   196,     0,    47,    29,   182,     0,    49,    30,   164,     0,    49,    32,   144,     0,    50,    33,   124,     0,    51,    35,   100,     0,    52,    35,    78, 
    0,    51,    35,    59,     0,    48,    37,    42,     0,    59,    33,     6,     0,    61,    34,     0,     0,    61,    36,     0,     0,    47,    10,   253,     0,    49,     6,   248, 
    0,    51,     5,   241,     0,    52,     7,   231,     0,    52,    13,   214,     0,    51,    14,   199,     0,    52,    15,   184,     0,    53,    16,   167,     0,    54,    17,   149, 
    0,    55,    18,   130,     0,    56,    18,   109,     0,    56,    19,    87,     0,    56,    20,    66,     0,    58,    19,    43,     0,    60,    21,    17,     0,    61,    21,     2, 
    0,    56,    24,     0,     0,    62,     4,   252,     0,    62,     1,   245,     0,    61,     0,   236,     0,    60,     1,   227,     0,    60,     3,   214,     0,    60,     3,   199, 
    0,    60,     3,   183,     0,    60,     4,   164,     0,    60,     4,   146,     0,    61,     4,   128,     0,    62,     4,   109,     0,    61,     4,    91,     0,    60,     5,    71, 
    0,    61,     4,    50,     0,    63,     4,    28,     0,    62,     6,     6,     0,    53,    13,     0,     0,    75,     0,   252,     0,    73,     0,   243,     0,    72,     0,   235, 
    0,    71,     0,   224,     0,    70,     0,   210,     0,    69,     0,   194,     0,    67,     0,   174,     0,    65,     0,   152,     0,    62,     0,   129,     0,    59,     0,   110, 
    0,    56,     0,    93,     0,    53,     0,    77,     0,    50,     0,    64,     0,    49,     0,    52,     0,    49,     0,    38,     0,    50,     0,    20,     0,    48,     0,     0, 
    0,    14,   230,   245,     0,    14,   231,   245,     0,    12,   235,   239,     0,     8,   239,   208,     0,    10,   240,   181,     0,    14,   240,   159,     0,    17,   240,   137, 
    0,    21,   240,   109,     0,    26,   239,    73,     0,    32,   240,    41,     0,    36,   238,    22,     0,    40,   234,    12,     0,    43,   231,     5,     0,    45,   227,     0, 
    0,    48,   225,     0,     0,    67,   216,     0,     0,    84,   207,     0,     0,    13,   211,   246,     0,    10,   208,   231,     0,    12,   207,   211,     0,    12,   211,   194, 
    0,     8,   217,   180,     0,     9,   219,   161,     0,    11,   219,   137,     0,    15,   220,   111,     0,    20,   219,    84,     0,    28,   216,    57,     0,    33,   214,    39, 
    0,    36,   213,    24,     0,    37,   212,     6,     0,    41,   209,     0,     0,    49,   205,     0,     0,    66,   200,     0,     0,    78,   199,     0,     0,    13,   194,   247, 
    0,     7,   197,   240,     0,     7,   198,   209,     0,     8,   200,   187,     0,     9,   203,   173,     0,     9,   205,   158,     0,    11,   206,   139,     0,    13,   206,   116, 
    0,    17,   205,    91,     0,    23,   205,    62,     0,    27,   205,    38,     0,    29,   204,    17,     0,    35,   202,     3,     0,    42,   198,     0,     0,    51,   194,     0, 
    0,    63,   190,     0,     0,    73,   193,     0,     0,    15,   177,   248,     0,    10,   180,   245,     0,     6,   186,   221,     0,     5,   189,   189,     0,     5,   192,   168, 
    0,     6,   194,   157,     0,     8,   195,   140,     0,    11,   194,   120,     0,    14,   193,    97,     0,    18,   194,    69,     0,    21,   195,    40,     0,    23,   196,    15, 
    0,    30,   193,     2,     0,    40,   188,     0,     0,    49,   184,     0,     0,    61,   180,     0,     0,    70,   186,     0,     0,    18,   159,   249,     0,    15,   161,   247, 
    0,    10,   167,   230,     0,     8,   173,   198,     0,     5,   178,   170,     0,     5,   181,   155,     0,     6,   182,   141,     0,     9,   181,   123,     0,    12,   181,   102, 
    0,    15,   182,    76,     0,    18,   184,    47,     0,    20,   186,    19,     0,    25,   183,     2,     0,    37,   179,     0,     0,    46,   175,     0,     0,    60,   169,     0, 
    0,    67,   177,     0,     0,    22,   140,   250,     0,    20,   142,   249,     0,    15,   147,   237,     0,    12,   156,   207,     0,     9,   161,   179,     0,     7,   164,   154, 
    0,     8,   164,   139,     0,    10,   166,   124,     0,    12,   168,   106,     0,    14,   169,    80,     0,    16,   171,    54,     0,    17,   174,    27,     0,    20,   173,     3, 
    0,    33,   169,     0,     0,    45,   163,     0,     0,    59,   157,     0,     0,    64,   166,     0,     0,    25,   123,   251,     0,    24,   123,   249,     0,    20,   128,   241, 
    0,    17,   137,   216,     0,    13,   143,   190,     0,    11,   146,   163,     0,    11,   145,   138,     0,    12,   150,   124,     0,    13,   153,   107,     0,    14,   156,    85, 
    0,    15,   158,    61,     0,    15,   161,    33,     0,    17,   161,     6,     0,    32,   157,     0,     0,    45,   151,     0,     0,    59,   145,     0,     0,    62,   154,     0, 
    0,    24,   109,   251,     0,    23,   111,   239,     0,    22,   115,   225,     0,    21,   121,   211,     0,    20,   126,   195,     0,    17,   132,   174,     0,    17,   135,   152, 
    0,    14,   135,   124,     0,    16,   138,   108,     0,    16,   141,    89,     0,    16,   145,    67,     0,    16,   147,    40,     0,    16,   149,    11,     0,    30,   145,     1, 
    0,    45,   139,     0,     0,    59,   133,     0,     0,    61,   141,     0,     0,    24,    94,   251,     0,    24,    98,   231,     0,    24,   103,   205,     0,    24,   106,   197, 
    0,    25,   112,   189,     0,    26,   116,   179,     0,    24,   120,   160,     0,    22,   123,   135,     0,    22,   122,   110,     0,    21,   126,    92,     0,    19,   129,    73, 
    0,    18,   132,    48,     0,    17,   135,    18,     0,    27,   132,     1,     0,    44,   126,     0,     0,    58,   119,     0,     0,    59,   127,     0,     0,    25,    76,   251, 
    0,    27,    80,   236,     0,    27,    86,   216,     0,    27,    91,   199,     0,    27,    96,   187,     0,    28,    97,   170,     0,    28,   101,   160,     0,    29,   102,   144, 
    0,    26,   106,   120,     0,    23,   106,    93,     0,    24,   109,    76,     0,    23,   112,    53,     0,    20,   118,    26,     0,    25,   116,     3,     0,    42,   108,     0, 
    0,    56,   101,     0,     0,    57,   109,     0,     0,    27,    59,   251,     0,    29,    61,   241,     0,    29,    65,   229,     0,    31,    73,   206,     0,    34,    78,   187, 
    0,    32,    82,   176,     0,    31,    84,   159,     0,    31,    86,   143,     0,    33,    87,   128,     0,    30,    88,   101,     0,    29,    88,    79,     0,    28,    92,    59, 
    0,    23,    98,    36,     0,    24,    99,     7,     0,    40,    91,     0,     0,    53,    86,     0,     0,    54,    89,     0,     0,    26,    46,   250,     0,    29,    50,   234, 
    0,    29,    53,   222,     0,    30,    58,   207,     0,    31,    63,   193,     0,    32,    66,   181,     0,    32,    68,   166,     0,    34,    69,   146,     0,    34,    72,   128, 
    0,    34,    72,   108,     0,    32,    73,    85,     0,    32,    73,    64,     0,    31,    76,    43,     0,    30,    79,    17,     0,    38,    76,     1,     0,    50,    70,     0, 
    0,    49,    72,     0,     0,    24,    34,   251,     0,    27,    39,   230,     0,    28,    42,   218,     0,    29,    45,   206,     0,    29,    47,   195,     0,    29,    50,   184, 
    0,    30,    53,   171,     0,    33,    54,   152,     0,    37,    54,   128,     0,    38,    55,   111,     0,    35,    58,    90,     0,    36,    57,    70,     0,    32,    57,    51, 
    0,    33,    61,    24,     0,    36,    60,     2,     0,    47,    55,     0,     0,    45,    56,     0,     0,    22,    22,   254,     0,    25,    25,   232,     0,    27,    27,   219, 
    0,    29,    29,   207,     0,    29,    32,   197,     0,    30,    33,   186,     0,    31,    36,   174,     0,    32,    37,   158,     0,    34,    38,   139,     0,    34,    39,   121, 
    0,    35,    40,    99,     0,    35,    40,    76,     0,    34,    41,    55,     0,    31,    44,    31,     0,    36,    42,     6,     0,    44,    39,     0,     0,    43,    41,     0, 
    0,    21,    12,   255,     0,    27,    11,   243,     0,    29,    10,   234,     0,    30,    11,   224,     0,    30,    15,   210,     0,    30,    16,   196,     0,    31,    18,   181, 
    0,    32,    19,   166,     0,    33,    19,   149,     0,    34,    20,   131,     0,    35,    21,   110,     0,    35,    22,    86,     0,    36,    23,    63,     0,    36,    23,    45, 
    0,    32,    26,    29,     0,    42,    24,     0,     0,    41,    26,     0,     0,    37,     5,   253,     0,    38,     2,   248,     0,    37,     1,   241,     0,    36,     2,   231, 
    0,    36,     5,   217,     0,    36,     6,   201,     0,    36,     6,   185,     0,    37,     7,   167,     0,    37,     7,   149,     0,    38,     7,   130,     0,    39,     7,   111, 
    0,    40,     7,    91,     0,    40,     8,    70,     0,    41,     7,    50,     0,    48,     5,    28,     0,    47,     6,     0,     0,    39,    15,     0,     0,    52,     0,   253, 
    0,    50,     0,   247,     0,    48,     0,   240,     0,    47,     0,   231,     0,    46,     0,   219,     0,    45,     0,   203,     0,    44,     0,   184,     0,    43,     0,   161, 
    0,    42,     0,   135,     0,    41,     0,   114,     0,    40,     0,    96,     0,    38,     0,    77,     0,    36,     0,    63,     0,    35,     0,    51,     0,    35,     0,    37, 
    0,    37,     0,    23,     0,    35,     0,     0,     0,     7,   231,   244,     0,     7,   232,   244,     0,     6,   234,   237,     0,     7,   236,   208,     0,     9,   236,   185, 
    0,    12,   236,   166,     0,    16,   236,   146,     0,    19,   236,   122,     0,    23,   236,    95,     0,    28,   236,    65,     0,    33,   237,    39,     0,    36,   235,    22, 
    0,    39,   232,    13,     0,    41,   229,     5,     0,    42,   227,     1,     0,    44,   226,     0,     0,    62,   216,     0,     0,     7,   213,   246,     0,     5,   209,   226, 
    0,     7,   209,   209,     0,     7,   213,   194,     0,     4,   218,   180,     0,     5,   219,   165,     0,     8,   219,   146,     0,    11,   220,   121,     0,    16,   219,    97, 
    0,    22,   218,    71,     0,    29,   215,    50,     0,    33,   214,    37,     0,    36,   212,    23,     0,    36,   212,     7,     0,    38,   210,     2,     0,    44,   208,     1, 
    0,    54,   206,     0,     0,     7,   196,   246,     0,     2,   199,   235,     0,     1,   199,   202,     0,     1,   202,   183,     0,     2,   204,   170,     0,     2,   206,   159, 
    0,     3,   208,   143,     0,     5,   208,   122,     0,     8,   208,    98,     0,    13,   208,    73,     0,    19,   206,    50,     0,    23,   206,    32,     0,    25,   205,    16, 
    0,    28,   203,     4,     0,    34,   200,     2,     0,    40,   198,     2,     0,    47,   196,     0,     0,     7,   178,   247,     0,     4,   182,   241,     0,     1,   187,   209, 
    0,     0,   189,   180,     0,     0,   192,   163,     0,     1,   194,   154,     0,     1,   196,   141,     0,     1,   196,   124,     0,     2,   197,   102,     0,     4,   198,    76, 
    0,     9,   198,    49,     0,    12,   198,    26,     0,    14,   198,     8,     0,    22,   194,     2,     0,    30,   191,     1,     0,    37,   189,     1,     0,    44,   193,     0, 
    0,     8,   160,   248,     0,     6,   163,   245,     0,     3,   170,   221,     0,     1,   175,   191,     0,     0,   177,   164,     0,     0,   180,   149,     0,     0,   182,   139, 
    0,     1,   182,   126,     0,     1,   182,   107,     0,     2,   183,    84,     0,     4,   184,    58,     0,     6,   186,    31,     0,     8,   187,     8,     0,    17,   184,     2, 
    0,    27,   181,     0,     0,    35,   179,     0,     0,    41,   186,     0,     0,    10,   140,   249,     0,     9,   143,   247,     0,     5,   150,   231,     0,     2,   159,   201, 
    0,     1,   162,   172,     0,     0,   163,   147,     0,     1,   164,   135,     0,     1,   166,   125,     0,     1,   167,   109,     0,     1,   169,    89,     0,     2,   171,    65, 
    0,     2,   173,    38,     0,     4,   175,    11,     0,    14,   172,     2,     0,    25,   169,     0,     0,    34,   167,     0,     0,    38,   176,     0,     0,    13,   122,   250, 
    0,    13,   124,   249,     0,     9,   130,   239,     0,     4,   139,   211,     0,     2,   146,   184,     0,     1,   147,   157,     0,     1,   146,   133,     0,     1,   149,   121, 
    0,     1,   152,   108,     0,     1,   154,    91,     0,     1,   157,    70,     0,     1,   159,    45,     0,     2,   161,    17,     0,    12,   159,     3,     0,    25,   156,     0, 
    0,    35,   155,     0,     0,    36,   164,     0,     0,    13,   108,   251,     0,    12,   110,   242,     0,    10,   114,   233,     0,     7,   120,   216,     0,     5,   127,   194, 
    0,     3,   131,   169,     0,     2,   134,   144,     0,     1,   134,   120,     0,     2,   135,   107,     0,     1,   138,    92,     0,     1,   142,    74,     0,     1,   144,    51, 
    0,     2,   147,    24,     0,     9,   147,     4,     0,    24,   143,     1,     0,    35,   141,     0,     0,    36,   150,     0,     0,    12,    94,   251,     0,    11,    98,   236, 
    0,    10,   104,   216,     0,     9,   107,   205,     0,     8,   111,   194,     0,     7,   115,   178,     0,     5,   120,   158,     0,     0,   124,   135,     0,     2,   120,   109, 
    0,     3,   123,    92,     0,     2,   127,    76,     0,     2,   129,    55,     0,     2,   131,    30,     0,     6,   134,     5,     0,    23,   129,     1,     0,    35,   126,     0, 
    0,    35,   135,     0,     0,    12,    78,   251,     0,    12,    82,   240,     0,    11,    89,   221,     0,    11,    93,   204,     0,    10,    96,   191,     0,     9,   101,   178, 
    0,     9,   105,   168,     0,     9,   105,   144,     0,     6,   109,   122,     0,     4,   109,    94,     0,     6,   110,    77,     0,     6,   113,    57,     0,     3,   116,    36, 
    0,     5,   118,     9,     0,    21,   112,     2,     0,    34,   108,     0,     0,    34,   116,     0,     0,    14,    60,   252,     0,    15,    62,   244,     0,    14,    67,   231, 
    0,    14,    77,   209,     0,    13,    81,   191,     0,    12,    85,   178,     0,    13,    87,   162,     0,    15,    88,   147,     0,    15,    90,   132,     0,    11,    92,   103, 
    0,    10,    92,    77,     0,     9,    95,    61,     0,     5,    99,    41,     0,     5,   102,    15,     0,    19,    96,     2,     0,    33,    90,     0,     0,    33,    95,     0, 
    0,    15,    45,   252,     0,    16,    47,   241,     0,    16,    51,   229,     0,    16,    59,   210,     0,    15,    64,   195,     0,    16,    69,   182,     0,    16,    71,   168, 
    0,    16,    73,   149,     0,    17,    75,   130,     0,    18,    75,   113,     0,    14,    77,    85,     0,    11,    78,    64,     0,    12,    80,    44,     0,    10,    83,    20, 
    0,    17,    81,     3,     0,    30,    74,     0,     0,    29,    76,     0,     0,    12,    35,   251,     0,    13,    41,   229,     0,    14,    45,   215,     0,    14,    47,   204, 
    0,    14,    49,   194,     0,    15,    52,   184,     0,    16,    55,   172,     0,    19,    57,   153,     0,    22,    57,   132,     0,    20,    60,   113,     0,    20,    61,    92, 
    0,    17,    62,    70,     0,    17,    60,    45,     0,    14,    64,    27,     0,    13,    67,     5,     0,    26,    59,     1,     0,    25,    60,     0,     0,    12,    24,   253, 
    0,    13,    32,   222,     0,    13,    36,   208,     0,    13,    36,   198,     0,    13,    37,   190,     0,    14,    38,   180,     0,    15,    40,   169,     0,    17,    42,   155, 
    0,    18,    43,   138,     0,    21,    44,   120,     0,    22,    43,    98,     0,    20,    45,    77,     0,    19,    43,    53,     0,    16,    46,    31,     0,    15,    49,     9, 
    0,    25,    44,     2,     0,    23,    45,     0,     0,    11,    13,   255,     0,    13,    21,   221,     0,    13,    22,   207,     0,    13,    22,   198,     0,    13,    23,   190, 
    0,    14,    23,   180,     0,    14,    24,   170,     0,    15,    25,   158,     0,    16,    26,   144,     0,    17,    27,   127,     0,    18,    27,   104,     0,    19,    27,    82, 
    0,    20,    27,    58,     0,    20,    28,    39,     0,    20,    31,    13,     0,    27,    28,     0,     0,    23,    31,     0,     0,    10,     6,   255,     0,    15,     6,   240, 
    0,    14,     5,   231,     0,    14,     5,   220,     0,    15,     7,   207,     0,    15,     7,   194,     0,    15,     8,   180,     0,    15,     8,   165,     0,    16,     9,   148, 
    0,    17,     9,   130,     0,    18,     9,   110,     0,    19,    10,    89,     0,    19,    11,    66,     0,    21,    11,    46,     0,    24,    10,    28,     0,    18,    14,    16, 
    0,    21,    13,     0,     0,    26,     0,   254,     0,    24,     0,   249,     0,    22,     0,   244,     0,    20,     0,   233,     0,    19,     0,   219,     0,    18,     0,   204, 
    0,    17,     0,   187,     0,    17,     0,   169,     0,    19,     0,   148,     0,    20,     0,   130,     0,    21,     0,   111,     0,    21,     0,    88,     0,    20,     0,    68, 
    0,    20,     0,    52,     0,    21,     0,    38,     0,    18,     0,    19,     0,    17,     0,     0,     0,     0,   232,   245,     0,     0,   231,   238,     0,     3,   231,   225, 
    0,     6,   231,   205,     0,     9,   231,   187,     0,    12,   231,   171,     0,    15,   231,   154,     0,    18,   231,   134,     0,    22,   232,   112,     0,    26,   232,    88, 
    0,    30,   233,    62,     0,    34,   233,    40,     0,    36,   232,    26,     0,    38,   229,    15,     0,    39,   228,     8,     0,    39,   227,     3,     0,    40,   226,     0, 
    0,     0,   215,   245,     0,     0,   209,   203,     0,     5,   211,   196,     0,     5,   216,   186,     0,     5,   219,   173,     0,     7,   220,   163,     0,     9,   220,   150, 
    0,    12,   221,   132,     0,    17,   221,   113,     0,    21,   221,    91,     0,    27,   220,    69,     0,    32,   219,    52,     0,    35,   218,    42,     0,    37,   216,    32, 
    0,    36,   216,    19,     0,    34,   217,     9,     0,    27,   211,     0,     0,     0,   198,   246,     0,     0,   200,   211,     0,     0,   201,   183,     0,     0,   205,   174, 
    0,     0,   207,   163,     0,     2,   210,   154,     0,     4,   210,   143,     0,     6,   211,   129,     0,    10,   211,   112,     0,    14,   210,    91,     0,    20,   210,    71, 
    0,    26,   209,    56,     0,    29,   208,    45,     0,    32,   207,    35,     0,    31,   207,    24,     0,    28,   206,    14,     0,    16,   198,     0,     0,     0,   180,   247, 
    0,     0,   187,   224,     0,     0,   191,   197,     0,     0,   193,   170,     0,     0,   196,   158,     0,     0,   198,   148,     0,     0,   199,   138,     0,     0,   200,   126, 
    0,     2,   202,   110,     0,     3,   203,    88,     0,     8,   203,    67,     0,    14,   203,    50,     0,    17,   202,    36,     0,    20,   202,    25,     0,    20,   202,    14, 
    0,    18,   201,     8,     0,    11,   195,     0,     0,     0,   160,   248,     0,     0,   169,   232,     0,     0,   176,   207,     0,     0,   179,   182,     0,     0,   181,   154, 
    0,     0,   183,   143,     0,     0,   185,   135,     0,     0,   186,   125,     0,     0,   187,   112,     0,     0,   189,    96,     0,     1,   191,    75,     0,     4,   193,    51, 
    0,     6,   194,    30,     0,     7,   195,    15,     0,     8,   195,     5,     0,     9,   195,     1,     0,     8,   193,     0,     0,     0,   140,   249,     0,     0,   148,   238, 
    0,     0,   157,   214,     0,     0,   163,   191,     0,     0,   166,   166,     0,     0,   166,   137,     0,     0,   168,   129,     0,     0,   170,   122,     0,     0,   171,   113, 
    0,     0,   172,   101,     0,     0,   174,    84,     0,     0,   176,    62,     0,     1,   180,    37,     0,     1,   182,    17,     0,     1,   183,     4,     0,     2,   183,     0, 
    0,     3,   184,     0,     0,     0,   121,   250,     0,     0,   126,   246,     0,     0,   135,   229,     0,     0,   144,   201,     0,     0,   149,   175,     0,     0,   151,   149, 
    0,     0,   149,   120,     0,     0,   152,   115,     0,     0,   153,   109,     0,     0,   155,   100,     0,     0,   158,    86,     0,     0,   161,    68,     0,     0,   164,    45, 
    0,     0,   167,    22,     0,     0,   169,     6,     0,     0,   169,     0,     0,     0,   171,     0,     0,     0,   106,   250,     0,     0,   109,   249,     0,     0,   116,   238, 
    0,     0,   125,   211,     0,     0,   131,   186,     0,     0,   135,   161,     0,     0,   135,   133,     0,     0,   132,   105,     0,     0,   135,   102,     0,     0,   138,    96, 
    0,     0,   141,    85,     0,     0,   144,    70,     0,     0,   147,    51,     0,     0,   150,    28,     0,     0,   153,    10,     0,     0,   154,     1,     0,     0,   156,     0, 
    0,     0,    93,   251,     0,     0,    98,   241,     0,     0,   106,   222,     0,     0,   111,   207,     0,     0,   115,   192,     0,     0,   119,   172,     0,     0,   122,   149, 
    0,     0,   120,   120,     0,     0,   116,    92,     0,     0,   120,    89,     0,     0,   123,    82,     0,     0,   126,    70,     0,     0,   130,    54,     0,     0,   133,    34, 
    0,     0,   136,    15,     0,     0,   138,     2,     0,     0,   140,     0,     0,     0,    79,   251,     0,     0,    84,   242,     0,     0,    92,   222,     0,     0,    97,   206, 
    0,     0,   101,   192,     0,     0,   104,   175,     0,     0,   108,   158,     0,     0,   110,   138,     0,     0,   106,   105,     0,     0,   105,    83,     0,     0,   107,    78, 
    0,     0,   110,    68,     0,     0,   112,    53,     0,     0,   115,    36,     0,     0,   118,    18,     0,     0,   120,     3,     0,     3,   122,     0,     0,     0,    62,   252, 
    0,     0,    65,   242,     0,     0,    72,   228,     0,     0,    81,   210,     0,     0,    86,   193,     0,     0,    89,   174,     0,     0,    86,   151,     0,     0,    87,   136, 
    0,     0,    95,   127,     0,     0,    91,    92,     0,     0,    92,    73,     0,     0,    94,    66,     0,     0,    96,    53,     0,     0,    98,    38,     0,     0,   100,    20, 
    0,     0,   101,     5,     0,     4,   102,     0,     0,     0,    45,   253,     0,     0,    47,   240,     0,     0,    54,   227,     0,     0,    63,   210,     0,     0,    70,   195, 
    0,     0,    75,   178,     0,     0,    76,   161,     0,     0,    74,   138,     0,     0,    77,   125,     0,     0,    73,   102,     0,     0,    81,    83,     0,     0,    78,    62, 
    0,     0,    80,    52,     0,     0,    81,    39,     0,     0,    82,    22,     0,     0,    83,     7,     0,     3,    83,     0,     0,     0,    33,   254,     0,     0,    38,   237, 
    0,     0,    43,   224,     0,     0,    48,   209,     0,     0,    51,   194,     0,     0,    57,   181,     0,     0,    60,   167,     0,     0,    61,   146,     0,     0,    62,   125, 
    0,     0,    59,   103,     0,     0,    61,    90,     0,     0,    62,    66,     0,     0,    63,    50,     0,     0,    65,    38,     0,     0,    66,    24,     0,     0,    66,    10, 
    0,     0,    66,     0,     0,     0,    23,   254,     0,     0,    37,   215,     0,     0,    40,   202,     0,     0,    42,   193,     0,     0,    42,   184,     0,     0,    43,   176, 
    0,     0,    44,   167,     0,     0,    45,   151,     0,     0,    46,   133,     0,     0,    45,   111,     0,     0,    46,    91,     0,     0,    45,    71,     0,     0,    48,    55, 
    0,     0,    47,    37,     0,     0,    49,    26,     0,     0,    50,    13,     0,     0,    50,     0,     0,     0,    14,   254,     0,     0,    30,   204,     0,     0,    32,   192, 
    0,     0,    32,   185,     0,     0,    31,   177,     0,     0,    31,   169,     0,     0,    30,   159,     0,     0,    31,   146,     0,     0,    32,   133,     0,     0,    32,   120, 
    0,     0,    31,    94,     0,     0,    28,    73,     0,     0,    32,    60,     0,     0,    33,    44,     0,     0,    33,    27,     0,     0,    37,    16,     0,     0,    35,     0, 
    0,     0,     6,   255,     0,     0,    21,   201,     0,     0,    22,   190,     0,     0,    21,   182,     0,     0,    19,   174,     0,     0,    18,   166,     0,     0,    18,   157, 
    0,     0,    18,   146,     0,     0,    18,   132,     0,     0,    18,   120,     0,     0,    18,   102,     0,     0,    17,    85,     0,     0,    18,    67,     0,     0,    18,    48, 
    0,     0,    19,    30,     0,     0,    16,    13,     0,     0,    17,     0,     0,     0,     0,   255,     0,     0,     0,   255,     0,     0,     0,   248,     0,     0,     0,   231, 
    0,     0,     0,   214,     0,     0,     0,   199,     0,     0,     0,   186,     0,     0,     0,   169,     0,     0,     0,   150,     0,     0,     0,   133,     0,     0,     0,   117, 
    0,     0,     0,    97,     0,     0,     0,    76,     0,     0,     0,    55,     0,     0,     0,    33,     0,     0,     0,    17,     0,     0,     0,     0
};

// Scottie Best
unsigned char ucMapDJ4100_KCMY_BestS_12x12x1[] =
{
  223,    94,    45,    21,   203,   106,    59,    20,   184,   119,    73,    19,   153,   162,    96,    11,   122,   201,   120,     6,    96,   227,   135,     2,    86,   233,   139,     0, 
   71,   238,   144,     0,    48,   240,   149,     0,    31,   243,   151,     0,    23,   245,   153,     0,    19,   245,   153,     0,    16,   246,   155,     0,    11,   246,   155,     0, 
    8,   247,   155,     0,     3,   248,   157,     0,     0,   248,   159,     0,   189,   104,    34,    76,   197,   118,    36,    26,   159,   135,    75,    18,   130,   179,   104,    10, 
   99,   226,   136,     2,    92,   232,   143,     1,    82,   236,   142,     0,    68,   238,   145,     0,    47,   240,   149,     0,    27,   244,   152,     0,    17,   245,   154,     0, 
    9,   246,   154,     0,     7,   246,   155,     0,     4,   246,   156,     0,     2,   245,   158,     0,     0,   245,   158,     0,     0,   244,   159,     0,   152,   114,    21,   132, 
  142,   126,    40,    78,   171,   142,    28,    30,   130,   186,    75,     8,    97,   220,   110,     3,    88,   223,   129,     3,    74,   231,   141,     2,    56,   237,   146,     1, 
   36,   240,   151,     0,    21,   243,   153,     0,    13,   243,   155,     1,     8,   241,   155,     1,     5,   240,   156,     0,     3,   239,   156,     0,     1,   239,   157,     0, 
    0,   239,   157,     0,     0,   238,   157,     0,   134,   141,    15,   163,   134,   146,    28,   118,   133,   163,    21,    84,   143,   170,    17,     9,    95,   224,    75,     1, 
   86,   224,   105,     2,    73,   228,   126,     2,    54,   232,   137,     2,    36,   236,   144,     3,    21,   237,   150,     4,    14,   236,   153,     5,     9,   233,   154,     5, 
    6,   232,   155,     4,     3,   231,   156,     2,     1,   231,   155,     0,     0,   232,   155,     0,     0,   232,   154,     0,   102,   181,     4,   218,   109,   181,    16,   170, 
  106,   190,    12,   132,   104,   205,     6,    84,   104,   211,    11,     1,    86,   227,    69,     0,    74,   226,    99,     3,    57,   228,   119,     4,    40,   229,   132,     5, 
   26,   229,   141,     7,    18,   228,   145,     8,    12,   228,   148,     8,     8,   226,   150,     6,     5,   225,   151,     4,     2,   224,   151,     1,     0,   223,   151,     0, 
    0,   223,   150,     0,    86,   197,     0,   238,    91,   202,     7,   208,    92,   204,     6,   175,    92,   212,     3,   134,    90,   219,     0,    69,    86,   226,    12,     0, 
   77,   223,    61,     2,    60,   224,    92,     5,    43,   223,   112,     8,    29,   223,   126,     9,    22,   221,   135,    11,    15,   221,   140,    10,    10,   219,   142,     9, 
    6,   218,   143,     6,     3,   217,   145,     4,     1,   215,   145,     1,     0,   214,   144,     0,    76,   205,     0,   239,    78,   208,     4,   221,    79,   207,     5,   198, 
   80,   209,     4,   163,    80,   215,     3,   119,    80,   219,     2,    62,    77,   228,     9,     0,    64,   225,    54,     3,    47,   223,    86,     7,    30,   221,   107,     9, 
   21,   217,   122,    12,    17,   214,   131,    13,    11,   212,   135,    12,     8,   209,   136,     9,     4,   208,   137,     5,     1,   207,   137,     1,     0,   205,   138,     0, 
   63,   207,     0,   240,    64,   209,     3,   229,    66,   209,     4,   213,    70,   211,     4,   189,    71,   215,     3,   156,    71,   218,     2,   114,    70,   223,     1,    56, 
   66,   230,     6,     0,    52,   225,    47,     4,    36,   221,    80,     9,    21,   217,   102,    11,    15,   212,   116,    12,    10,   207,   125,    12,     8,   204,   127,    10, 
    5,   201,   129,     8,     2,   199,   129,     3,     0,   198,   127,     0,    51,   207,     1,   240,    52,   208,     3,   233,    54,   209,     5,   220,    56,   208,     6,   201, 
   59,   212,     4,   180,    60,   217,     2,   150,    61,   220,     2,   107,    59,   225,     1,    57,    53,   229,     3,     1,    39,   224,    43,     6,    24,   219,    75,     9, 
   14,   214,    95,     9,     9,   207,   107,     9,     8,   202,   115,     8,     5,   198,   119,     7,     2,   195,   119,     4,     0,   192,   118,     0,    40,   207,     2,   241, 
   41,   209,     3,   237,    42,   209,     5,   225,    44,   208,     6,   211,    45,   209,     6,   193,    45,   213,     5,   168,    47,   214,     6,   141,    45,   218,     4,   104, 
   42,   224,     3,    56,    37,   230,     4,     5,    26,   224,    36,     7,    17,   218,    67,     8,    10,   211,    87,     7,     7,   204,   100,     6,     4,   199,   106,     5, 
    2,   194,   109,     2,     0,   190,   110,     0,    27,   205,     4,   241,    27,   206,     5,   238,    28,   206,     7,   229,    30,   207,     9,   216,    30,   207,     8,   201, 
   30,   211,     8,   184,    31,   212,     8,   159,    31,   215,     7,   136,    29,   219,     6,   100,    26,   225,     4,    56,    24,   232,     4,     8,    17,   223,    33,     6, 
   12,   217,    60,     6,     8,   208,    80,     5,     4,   202,    93,     3,     2,   196,    99,     1,     0,   190,   102,     0,    17,   204,     6,   241,    17,   204,     7,   238, 
   18,   204,     8,   230,    20,   204,     9,   220,    20,   206,     9,   207,    21,   208,     9,   193,    22,   211,     9,   176,    22,   213,     8,   153,    21,   216,     6,   131, 
   18,   222,     4,    95,    17,   228,     2,    53,    17,   236,     3,     8,    14,   225,    30,     5,     9,   216,    55,     4,     5,   207,    75,     3,     2,   200,    86,     1, 
    0,   193,    93,     0,     8,   203,     8,   241,     9,   204,     9,   238,    10,   204,     9,   232,    12,   205,     9,   223,    13,   206,     9,   214,    13,   207,     9,   201, 
   14,   209,     8,   188,    14,   211,     7,   167,    14,   214,     6,   149,    14,   218,     4,   123,    14,   224,     2,    90,    14,   231,     1,    50,    13,   238,     3,     9, 
   10,   226,    28,     4,     6,   216,    52,     3,     2,   206,    70,     1,     0,   198,    80,     0,     2,   202,     9,   243,     3,   202,     9,   239,     5,   203,     9,   234, 
    8,   205,     9,   226,     9,   206,     9,   218,     9,   207,     7,   208,     9,   209,     7,   196,     9,   211,     5,   181,    10,   213,     5,   163,    10,   216,     4,   144, 
   10,   221,     2,   116,    10,   227,     1,    86,    10,   233,     1,    46,     9,   238,     2,     6,     8,   225,    28,     4,     3,   215,    50,     1,     0,   205,    68,     0, 
    0,   202,     7,   244,     0,   201,     7,   241,     0,   202,     8,   238,     3,   204,     8,   230,     6,   206,     9,   221,     7,   207,     7,   212,     7,   208,     5,   202, 
    7,   211,     4,   191,     7,   212,     4,   176,     8,   214,     3,   158,     8,   217,     2,   138,     8,   222,     1,   110,     7,   227,     1,    80,     7,   232,     1,    43, 
    7,   239,     4,     7,     4,   225,    26,     1,     0,   214,    49,     0,     0,   203,     3,   244,     0,   203,     3,   243,     0,   203,     3,   239,     0,   203,     3,   236, 
    2,   205,     4,   226,     3,   206,     4,   218,     3,   207,     2,   208,     3,   208,     2,   198,     3,   211,     2,   187,     3,   212,     1,   171,     3,   215,     1,   153, 
    3,   218,     1,   133,     3,   222,     0,   104,     3,   227,     0,    75,     3,   232,     0,    39,     2,   238,     0,     2,     0,   223,    26,     0,     0,   204,     0,   244, 
    0,   204,     0,   243,     0,   204,     0,   240,     0,   204,     0,   237,     0,   204,     0,   231,     0,   204,     0,   224,     0,   205,     0,   215,     0,   207,     0,   205, 
    0,   208,     0,   194,     0,   211,     0,   182,     0,   213,     0,   166,     0,   215,     0,   148,     0,   218,     0,   126,     0,   222,     0,   100,     0,   226,     0,    71, 
    0,   231,     0,    36,     0,   238,     0,     0,   190,    72,    75,    72,   194,    75,    84,    17,   172,    97,   104,    13,   129,   145,   148,     8,   102,   179,   165,     5, 
   91,   196,   161,     6,    75,   213,   165,     6,    55,   221,   168,     7,    33,   226,   171,     8,    15,   230,   173,     8,    11,   233,   172,     6,     9,   236,   168,     4, 
    6,   238,   166,     2,     3,   239,   164,     0,     1,   243,   164,     0,     0,   244,   163,     0,     0,   245,   162,     0,   190,    71,    34,    74,   151,    97,    54,    31, 
  139,   130,    82,    24,   121,   178,   107,    12,    97,   216,   139,     5,    82,   226,   147,     3,    69,   231,   150,     2,    52,   234,   152,     2,    36,   237,   154,     2, 
   20,   238,   156,     3,    10,   239,   158,     1,     4,   240,   158,     0,     1,   240,   159,     0,     0,   239,   159,     0,     0,   239,   158,     0,     0,   239,   158,     0, 
    0,   240,   158,     0,   151,    95,    21,   135,   170,   119,    27,   102,   146,   118,    44,    32,   126,   162,    84,    15,   100,   199,   115,     9,    82,   216,   134,     6, 
   67,   227,   142,     3,    51,   232,   147,     3,    36,   236,   150,     3,    21,   238,   152,     3,    10,   239,   154,     2,     2,   239,   156,     0,     0,   238,   157,     0, 
    0,   237,   156,     0,     0,   234,   156,     0,     0,   234,   156,     0,     0,   236,   156,     0,   135,   123,    15,   161,   136,   151,    17,   153,   126,   162,    23,   104, 
  136,   143,    33,    26,   110,   177,    78,    12,    84,   208,   113,     7,    68,   220,   131,     6,    51,   225,   141,     6,    35,   228,   147,     7,    20,   231,   151,     7, 
   10,   232,   154,     6,     3,   232,   155,     1,     0,   230,   155,     0,     0,   228,   155,     0,     0,   228,   154,     0,     0,   227,   154,     0,     0,   229,   154,     0, 
  104,   165,     5,   214,    98,   188,     4,   220,   108,   181,    16,   150,   116,   159,    26,    84,   121,   154,    29,    19,    92,   200,    74,     8,    75,   213,   102,     7, 
   58,   219,   122,     8,    40,   222,   134,     9,    25,   224,   143,     9,    13,   226,   148,     9,     5,   225,   151,     4,     1,   224,   151,     0,     0,   221,   151,     0, 
    0,   220,   151,     0,     0,   220,   151,     0,     0,   222,   151,     0,    87,   182,     0,   239,    88,   190,     1,   230,    92,   194,    10,   189,    94,   191,    12,   140, 
   95,   191,    13,    80,    99,   187,    17,    12,    80,   203,    60,     9,    62,   211,    93,     9,    45,   215,   113,    10,    29,   218,   129,    12,    17,   219,   138,    11, 
    9,   219,   141,     7,     3,   218,   143,     3,     0,   216,   145,     0,     0,   214,   145,     0,     0,   213,   145,     0,     0,   213,   145,     0,    76,   197,     0,   239, 
   76,   200,     2,   232,    80,   198,     9,   200,    82,   195,    11,   166,    82,   198,    10,   132,    82,   197,    12,    74,    86,   197,    13,    16,    68,   207,    53,     9, 
   52,   212,    86,    10,    33,   212,   109,    14,    20,   212,   123,    14,    11,   212,   132,    12,     6,   211,   135,     7,     2,   209,   136,     2,     0,   208,   137,     0, 
    0,   207,   137,     0,     0,   206,   138,     0,    63,   199,     1,   240,    63,   201,     2,   237,    65,   201,     7,   217,    69,   200,     9,   190,    72,   202,     9,   162, 
   72,   202,     9,   126,    73,   202,    10,    75,    74,   201,    12,    18,    59,   207,    47,    10,    41,   209,    80,    13,    24,   209,   102,    14,    13,   207,   116,    13, 
    8,   205,   123,     9,     4,   204,   126,     6,     1,   202,   127,     1,     0,   200,   127,     0,     0,   199,   129,     0,    51,   201,     2,   240,    51,   201,     3,   238, 
   53,   201,     6,   224,    56,   200,     9,   203,    58,   201,     9,   184,    61,   203,     9,   154,    62,   204,     9,   118,    61,   205,    10,    75,    62,   203,    13,    24, 
   46,   207,    43,    12,    28,   207,    75,    15,    16,   206,    94,    12,     9,   204,   105,     9,     5,   201,   112,     6,     2,   198,   116,     3,     0,   195,   118,     0, 
    0,   192,   118,     0,    40,   203,     3,   241,    41,   202,     4,   238,    42,   201,     6,   229,    44,   201,     9,   213,    45,   200,    10,   194,    46,   202,    10,   173, 
   48,   202,    11,   146,    48,   202,    12,   110,    47,   205,    13,    71,    46,   205,    15,    25,    34,   208,    41,    14,    21,   207,    68,    13,    11,   204,    86,     9, 
    6,   201,    97,     5,     2,   198,   104,     3,     0,   193,   107,     0,     0,   189,   109,     0,    27,   202,     5,   243,    28,   200,     6,   239,    29,   199,     8,   231, 
   30,   199,    10,   219,    31,   200,    12,   203,    32,   201,    12,   188,    33,   202,    12,   165,    36,   202,    13,   140,    35,   204,    13,   107,    34,   206,    13,    68, 
   33,   206,    16,    24,    25,   206,    37,    13,    16,   206,    61,     9,     9,   203,    77,     6,     3,   199,    89,     2,     0,   194,    95,     0,     0,   188,   100,     0, 
   16,   200,     8,   241,    17,   198,     9,   238,    18,   198,     9,   232,    20,   198,    11,   221,    22,   199,    13,   208,    22,   200,    14,   195,    23,   201,    13,   179, 
   24,   202,    12,   155,    23,   204,    11,   135,    23,   206,    11,   102,    23,   208,    10,    63,    25,   209,    14,    25,    17,   206,    34,    12,    10,   204,    54,     7, 
    5,   201,    71,     4,     1,   196,    82,     1,     0,   189,    90,     0,     7,   201,     9,   241,     9,   198,     9,   238,    10,   198,    10,   233,    12,   198,    12,   225, 
   14,   199,    13,   214,    15,   200,    15,   201,    14,   200,    12,   189,    15,   202,    10,   168,    16,   203,     9,   150,    16,   205,     9,   126,    16,   207,     8,    94, 
   17,   211,     8,    58,    17,   213,    14,    23,    12,   208,    32,    10,     7,   204,    50,     5,     2,   199,    66,     1,     0,   193,    78,     0,     2,   200,     9,   243, 
    3,   198,     9,   238,     5,   198,     9,   233,     8,   200,     9,   225,     9,   200,     9,   217,     9,   199,     9,   206,     9,   200,     9,   195,     9,   201,     8,   181, 
    9,   202,     7,   162,     9,   204,     6,   143,    10,   207,     6,   118,    11,   209,     5,    87,    11,   214,     6,    52,    13,   216,    12,    21,     9,   209,    29,     8, 
    3,   203,    46,     2,     0,   198,    66,     0,     0,   200,     7,   244,     0,   196,     7,   239,     0,   196,     7,   234,     3,   198,     8,   228,     5,   199,     9,   219, 
    6,   199,     8,   211,     6,   200,     7,   201,     5,   201,     6,   189,     6,   202,     5,   173,     6,   203,     4,   156,     7,   205,     4,   136,     7,   209,     3,   110, 
    7,   213,     3,    82,     7,   217,     4,    46,     9,   219,     9,    16,     4,   209,    27,     4,     0,   203,    50,     0,     0,   201,     3,   244,     0,   197,     2,   239, 
    0,   196,     2,   236,     0,   197,     3,   231,     2,   198,     3,   223,     2,   199,     4,   215,     3,   199,     2,   205,     3,   200,     2,   195,     3,   201,     2,   184, 
    3,   203,     2,   167,     3,   205,     1,   150,     3,   208,     1,   130,     3,   211,     1,   104,     3,   215,     0,    74,     3,   219,     1,    39,     6,   221,     8,    10, 
    0,   211,    31,     0,     0,   202,     0,   244,     0,   198,     0,   236,     0,   198,     0,   233,     0,   199,     0,   230,     0,   199,     0,   225,     0,   199,     0,   218, 
    0,   200,     0,   209,     0,   201,     0,   199,     0,   202,     0,   189,     0,   204,     0,   177,     0,   206,     0,   159,     0,   208,     0,   142,     0,   211,     0,   120, 
    0,   214,     0,    94,     0,   218,     0,    62,     0,   223,     0,    29,     0,   228,     0,     0,   156,    47,   102,   123,   151,    56,   114,    93,   164,    53,   123,    20, 
  118,   102,   173,     5,    97,   143,   182,     3,    84,   173,   177,     4,    70,   192,   176,     5,    50,   203,   178,     5,    28,   212,   180,     7,    14,   217,   180,     8, 
    9,   222,   179,     7,     7,   226,   177,     8,     5,   229,   175,     6,     2,   232,   172,     3,     1,   234,   168,     0,     0,   238,   167,     0,     0,   239,   165,     0, 
  156,    46,    75,   126,   144,    78,    82,    69,   138,    89,    98,    21,   114,   137,   136,    12,    93,   178,   154,     9,    78,   196,   161,     8,    62,   208,   165,     8, 
   44,   217,   168,     9,    26,   221,   172,     9,    13,   225,   173,     9,     4,   225,   172,     5,     0,   226,   170,     1,     0,   227,   167,     0,     0,   229,   164,     0, 
    0,   230,   163,     0,     0,   232,   161,     0,     0,   234,   161,     0,   155,    46,    23,   127,   171,    76,    28,   100,   132,    98,    57,    36,   120,   136,    91,    24, 
   96,   180,   123,    15,    82,   200,   136,    10,    65,   215,   144,     8,    48,   222,   149,     7,    34,   227,   151,     7,    20,   229,   155,     8,     9,   231,   157,     6, 
    1,   231,   158,     1,     0,   230,   157,     0,     0,   229,   157,     0,     0,   228,   156,     0,     0,   227,   155,     0,     0,   230,   155,     0,   137,    89,    16,   158, 
  138,   110,    18,   150,   132,   121,    40,    84,   126,   119,    48,    28,   104,   153,    89,    21,    84,   189,   114,    13,    67,   205,   133,    10,    51,   216,   141,     9, 
   36,   221,   145,     9,    23,   224,   151,    10,    11,   227,   153,     8,     3,   227,   154,     2,     0,   226,   154,     0,     0,   224,   153,     0,     0,   223,   153,     0, 
    0,   222,   153,     0,     0,   224,   153,     0,   108,   135,     7,   205,   102,   151,     6,   211,   116,   147,    26,   134,   112,   142,    36,    84,   110,   135,    43,    26, 
   90,   171,    79,    17,    73,   197,   107,    12,    57,   207,   126,    11,    40,   214,   137,    12,    24,   217,   146,    14,    11,   219,   151,    10,     3,   219,   152,     3, 
    0,   218,   151,     0,     0,   216,   151,     0,     0,   215,   151,     0,     0,   215,   151,     0,     0,   217,   151,     0,    88,   158,     0,   239,    88,   164,     1,   233, 
   93,   171,    14,   186,    94,   171,    22,   137,    94,   159,    27,    77,    99,   154,    32,    20,    78,   187,    69,    15,    62,   200,    98,    14,    45,   206,   118,    15, 
   29,   211,   132,    16,    15,   213,   141,    14,     5,   214,   143,     7,     0,   213,   145,     1,     0,   211,   145,     0,     0,   209,   145,     0,     0,   208,   145,     0, 
    0,   211,   145,     0,    76,   179,     1,   240,    76,   187,     2,   234,    80,   184,    11,   199,    84,   182,    17,   163,    82,   184,    17,   129,    82,   181,    20,    78, 
   87,   178,    22,    20,    67,   196,    60,    14,    51,   200,    92,    16,    33,   203,   113,    17,    19,   206,   126,    17,     9,   207,   133,    10,     3,   207,   135,     4, 
    0,   207,   137,     0,     0,   205,   137,     0,     0,   203,   137,     0,     0,   204,   138,     0,    64,   189,     2,   240,    63,   190,     3,   237,    65,   190,     8,   216, 
   69,   190,    14,   187,    71,   192,    14,   162,    73,   192,    14,   129,    72,   192,    16,    77,    73,   190,    18,    23,    58,   196,    53,    15,    40,   200,    86,    17, 
   24,   202,   105,    17,    13,   202,   116,    14,     6,   202,   123,     8,     1,   201,   126,     2,     0,   200,   126,     0,     0,   198,   127,     0,     0,   198,   129,     0, 
   51,   192,     4,   241,    51,   193,     5,   238,    52,   193,     8,   224,    56,   192,    12,   203,    58,   193,    14,   182,    61,   195,    13,   155,    62,   195,    14,   120, 
   61,   195,    16,    79,    62,   192,    19,    29,    47,   197,    49,    17,    29,   200,    79,    17,    16,   201,    95,    15,     8,   200,   106,     9,     3,   198,   112,     4, 
    0,   196,   115,     0,     0,   193,   116,     0,     0,   191,   118,     0,    40,   195,     4,   241,    41,   194,     5,   238,    42,   194,     8,   228,    44,   194,    11,   213, 
   45,   195,    14,   194,    46,   195,    14,   175,    47,   196,    15,   148,    49,   194,    17,   114,    48,   195,    17,    75,    49,   194,    20,    28,    36,   199,    45,    17, 
   21,   200,    70,    16,    11,   199,    86,    10,     5,   197,    96,     5,     1,   194,   102,     1,     0,   190,   106,     0,     0,   187,   107,     0,    27,   196,     6,   243, 
   28,   195,     7,   239,    29,   194,     9,   230,    30,   195,    11,   218,    31,   195,    14,   203,    32,   196,    16,   188,    33,   197,    16,   166,    36,   196,    17,   141, 
   36,   197,    17,   109,    36,   197,    17,    71,    36,   196,    22,    27,    26,   199,    41,    17,    16,   199,    61,    12,     9,   198,    77,     7,     2,   194,    87,     2, 
    0,   190,    93,     0,     0,   184,    98,     0,    16,   196,     9,   243,    17,   195,     9,   238,    19,   195,    11,   231,    21,   196,    13,   220,    22,   195,    15,   208, 
   23,   195,    17,   195,    24,   196,    17,   179,    24,   197,    15,   156,    25,   197,    15,   136,    25,   198,    15,   102,    25,   199,    15,    65,    26,   200,    19,    28, 
   18,   199,    36,    16,    11,   198,    54,     9,     5,   196,    70,     4,     0,   192,    79,     0,     0,   184,    88,     0,     7,   198,    10,   241,     9,   195,    11,   238, 
   10,   195,    12,   232,    12,   195,    13,   223,    13,   195,    16,   213,    15,   195,    17,   200,    15,   195,    15,   189,    16,   196,    14,   170,    17,   197,    13,   151, 
   16,   198,    12,   126,    17,   200,    11,    95,    18,   200,    11,    59,    18,   202,    17,    27,    13,   200,    33,    14,     6,   197,    49,     6,     1,   193,    64,     1, 
    0,   188,    76,     0,     2,   198,     9,   243,     4,   195,     9,   238,     6,   196,    10,   231,     8,   196,    11,   223,     8,   195,    12,   216,     9,   195,    13,   204, 
    9,   195,    12,   194,     9,   195,     9,   180,     9,   196,     9,   161,    10,   197,     9,   142,    10,   199,     8,   116,    11,   200,     8,    87,    12,   202,     9,    53, 
   11,   205,    15,    23,     8,   201,    29,     9,     2,   196,    45,     2,     0,   190,    64,     0,     0,   197,     7,   244,     0,   194,     7,   238,     1,   194,     7,   231, 
    4,   194,     8,   224,     5,   195,     9,   217,     5,   194,     8,   208,     5,   194,     7,   198,     4,   194,     6,   187,     5,   195,     5,   171,     5,   197,     5,   153, 
    6,   197,     4,   133,     7,   199,     4,   107,     7,   201,     4,    79,     8,   205,     6,    45,     8,   207,    12,    17,     3,   200,    26,     4,     0,   194,    48,     0, 
    0,   199,     3,   244,     0,   194,     2,   238,     0,   192,     2,   231,     0,   192,     2,   225,     0,   192,     2,   220,     1,   193,     3,   211,     2,   194,     3,   202, 
    1,   194,     2,   191,     1,   194,     2,   179,     2,   196,     1,   163,     2,   197,     1,   145,     2,   199,     1,   125,     2,   201,     1,   100,     3,   204,     1,    69, 
    3,   207,     2,    36,     4,   209,     8,     9,     0,   200,    31,     0,     0,   200,     0,   244,     0,   196,     0,   237,     0,   192,     0,   227,     0,   193,     0,   224, 
    0,   193,     0,   219,     0,   194,     0,   213,     0,   195,     0,   204,     0,   195,     0,   195,     0,   196,     0,   184,     0,   197,     0,   171,     0,   199,     0,   154, 
    0,   201,     0,   137,     0,   203,     0,   114,     0,   206,     0,    89,     0,   209,     0,    54,     0,   214,     0,    22,     0,   219,     0,     0,   139,    33,   139,   156, 
  131,    36,   151,   123,   131,    30,   165,    50,   105,    50,   201,     2,    93,   109,   195,     2,    80,   148,   188,     3,    66,   170,   186,     4,    47,   186,   187,     4, 
   27,   192,   188,     6,    14,   200,   187,     6,    10,   206,   184,     6,     8,   213,   182,     5,     6,   216,   180,     5,     3,   220,   177,     4,     1,   225,   175,     2, 
    0,   228,   172,     0,     0,   231,   170,     0,   142,    36,   102,   150,   137,    62,   104,   100,   133,    63,   110,    49,   116,    82,   142,    13,    90,   141,   166,     8, 
   75,   168,   172,     6,    58,   187,   177,     6,    40,   195,   179,     7,    22,   200,   181,     8,    11,   206,   181,     7,     2,   209,   180,     1,     0,   213,   177,     0, 
    0,   215,   173,     0,     0,   218,   170,     0,     0,   221,   167,     0,     0,   224,   165,     0,     0,   226,   165,     0,   141,    37,    62,   148,   136,    59,    75,   108, 
  127,    79,    86,    73,   118,    86,   100,    24,    92,   141,   140,    15,    76,   171,   152,    11,    60,   189,   159,    11,    42,   199,   165,    11,    26,   205,   168,    12, 
   14,   209,   171,    13,     5,   213,   171,     5,     0,   213,   167,     0,     0,   214,   165,     0,     0,   215,   163,     0,     0,   216,   162,     0,     0,   218,   159,     0, 
    0,   221,   159,     0,   140,    34,    17,   157,   140,    49,    24,   136,   127,    84,    49,    77,   110,   100,    61,    42,    98,   134,    95,    27,    82,   170,   120,    20, 
   66,   192,   135,    16,    50,   204,   142,    15,    36,   211,   149,    15,    21,   216,   153,    15,    10,   219,   155,    11,     3,   219,   155,     3,     0,   218,   154,     0, 
    0,   216,   153,     0,     0,   215,   152,     0,     0,   214,   152,     0,     0,   218,   151,     0,   118,    82,     9,   192,   113,    99,    18,   165,   112,   106,    32,   126, 
  107,   118,    44,    87,   105,   118,    54,    35,    87,   151,    88,    27,    70,   181,   113,    20,    55,   194,   132,    17,    39,   202,   141,    17,    25,   208,   146,    17, 
   12,   213,   150,    14,     3,   214,   151,     5,     0,   213,   151,     0,     0,   211,   150,     0,     0,   209,   149,     0,     0,   208,   149,     0,     0,   212,   150,     0, 
   93,   118,     1,   231,    93,   125,     3,   225,    96,   138,    17,   179,    95,   147,    29,   135,    93,   141,    39,    84,    96,   131,    46,    32,    77,   162,    80,    26, 
   59,   188,   105,    20,    43,   196,   123,    20,    27,   202,   135,    20,    13,   205,   142,    17,     4,   207,   144,     7,     0,   206,   145,     0,     0,   204,   145,     0, 
    0,   203,   144,     0,     0,   203,   143,     0,     0,   205,   144,     0,    78,   153,     2,   240,    77,   158,     2,   237,    82,   159,    12,   200,    84,   167,    21,   162, 
   82,   164,    26,   129,    82,   155,    33,    80,    86,   150,    37,    27,    65,   180,    72,    21,    49,   190,    99,    21,    33,   195,   116,    22,    19,   200,   127,    20, 
    8,   202,   134,    11,     2,   203,   135,     2,     0,   201,   136,     0,     0,   200,   136,     0,     0,   199,   136,     0,     0,   200,   137,     0,    65,   168,     4,   240, 
   65,   173,     5,   237,    67,   175,     9,   215,    69,   179,    17,   187,    71,   180,    20,   159,    72,   180,    21,   129,    71,   176,    25,    80,    73,   173,    27,    26, 
   56,   187,    63,    20,    38,   192,    91,    22,    24,   195,   107,    21,    12,   197,   118,    16,     4,   198,   123,     7,     0,   198,   126,     0,     0,   196,   126,     0, 
    0,   194,   126,     0,     0,   195,   127,     0,    52,   179,     5,   241,    52,   179,     6,   238,    53,   180,     9,   223,    56,   184,    14,   201,    59,   184,    18,   181, 
   60,   184,    19,   155,    61,   184,    20,   121,    60,   184,    22,    79,    62,   180,    26,    29,    45,   189,    57,    21,    28,   193,    82,    21,    16,   195,    98,    17, 
    7,   194,   107,     9,     2,   193,   112,     2,     0,   192,   114,     0,     0,   190,   116,     0,     0,   189,   118,     0,    40,   186,     6,   241,    41,   184,     7,   238, 
   42,   186,     9,   227,    44,   188,    13,   211,    45,   188,    17,   194,    45,   188,    18,   175,    46,   189,    19,   148,    48,   187,    21,   115,    48,   187,    22,    75, 
   49,   186,    26,    31,    35,   190,    50,    22,    21,   193,    74,    18,    10,   193,    87,    10,     4,   192,    97,     4,     0,   190,   102,     0,     0,   187,   105,     0, 
    0,   184,   107,     0,    28,   189,     8,   243,    29,   189,     9,   239,    30,   189,    10,   230,    31,   190,    13,   218,    32,   190,    16,   204,    33,   190,    18,   189, 
   33,   191,    18,   167,    35,   190,    19,   142,    36,   190,    20,   110,    36,   189,    21,    74,    36,   189,    26,    33,    26,   192,    45,    20,    15,   192,    63,    14, 
    8,   192,    78,     7,     1,   189,    87,     1,     0,   184,    93,     0,     0,   180,    97,     0,    16,   192,    10,   243,    17,   190,    11,   238,    19,   191,    12,   230, 
   21,   191,    14,   219,    22,   190,    17,   208,    23,   190,    19,   195,    24,   191,    19,   179,    24,   192,    18,   157,    25,   191,    18,   136,    26,   191,    18,   104, 
   26,   191,    19,    68,    27,   193,    24,    33,    18,   193,    38,    18,    10,   192,    56,     9,     4,   190,    70,     3,     0,   187,    78,     0,     0,   179,    86,     0, 
    6,   193,    12,   241,     9,   191,    13,   238,    10,   190,    14,   231,    12,   190,    16,   222,    14,   189,    17,   212,    15,   190,    18,   200,    15,   189,    17,   189, 
   16,   191,    16,   170,    16,   191,    15,   151,    17,   192,    15,   127,    17,   192,    15,    97,    19,   193,    15,    63,    20,   195,    22,    32,    13,   194,    35,    16, 
    6,   190,    49,     6,     0,   187,    62,     0,     0,   180,    75,     0,     3,   195,     9,   243,     2,   192,    12,   238,     5,   192,    13,   230,     8,   191,    15,   222, 
    8,   190,    15,   214,     9,   190,    14,   203,     9,   190,    13,   193,     9,   190,    11,   179,     9,   191,    10,   161,     9,   191,    10,   141,    10,   192,     9,   118, 
   12,   192,     9,    88,    12,   195,    10,    55,    11,   197,    17,    26,     6,   194,    28,    10,     2,   189,    43,     2,     0,   182,    62,     0,     0,   194,     8,   244, 
    0,   191,     8,   238,     2,   191,     9,   230,     4,   191,     9,   221,     4,   190,     9,   214,     5,   189,     8,   205,     4,   189,     7,   196,     4,   189,     6,   184, 
    4,   189,     6,   168,     5,   190,     6,   151,     6,   190,     5,   132,     6,   191,     5,   106,     7,   193,     5,    78,     7,   196,     7,    45,     5,   198,    11,    19, 
    3,   191,    25,     4,     0,   186,    46,     0,     0,   196,     3,   244,     0,   191,     3,   238,     0,   189,     2,   230,     0,   189,     2,   221,     0,   188,     2,   215, 
    1,   188,     2,   206,     1,   188,     2,   198,     1,   188,     1,   188,     1,   188,     1,   175,     1,   189,     1,   158,     1,   190,     1,   141,     1,   191,     1,   120, 
    1,   192,     0,    96,     2,   195,     1,    66,     2,   197,     2,    34,     2,   199,     7,    11,     0,   191,    29,     0,     0,   197,     0,   245,     0,   194,     0,   237, 
    0,   190,     0,   228,     0,   187,     0,   217,     0,   188,     0,   213,     0,   188,     0,   206,     0,   189,     0,   199,     0,   189,     0,   190,     0,   189,     0,   179, 
    0,   189,     0,   165,     0,   191,     0,   149,     0,   193,     0,   132,     0,   194,     0,   109,     0,   197,     0,    84,     0,   200,     0,    48,     0,   203,     0,    17, 
    0,   207,     0,     0,   102,     9,   190,   214,   105,    21,   182,   154,   104,    17,   191,    92,   100,    16,   202,     5,    88,    56,   213,     1,    79,   107,   198,     3, 
   65,   141,   194,     3,    47,   159,   192,     4,    28,   173,   191,     6,    15,   184,   190,     5,    10,   191,   189,     5,     9,   199,   187,     5,     6,   203,   184,     4, 
    4,   208,   182,     3,     2,   212,   180,     1,     0,   216,   178,     0,     0,   220,   175,     0,   112,    18,   148,   193,   126,    51,   120,   123,   120,    53,   127,    89, 
  119,    49,   139,    27,    91,    98,   173,     9,    75,   137,   181,     6,    60,   159,   184,     6,    41,   173,   184,     7,    23,   184,   186,     8,    11,   190,   186,     6, 
    2,   195,   184,     1,     0,   199,   181,     0,     0,   203,   178,     0,     0,   206,   175,     0,     0,   209,   172,     0,     0,   213,   170,     0,     0,   216,   170,     0, 
  120,    44,    96,   142,   115,    52,    93,   129,   115,    69,   100,    93,   112,    64,   113,    49,    92,    95,   146,    16,    76,   140,   159,    11,    60,   162,   167,    10, 
   41,   177,   173,    10,    25,   186,   177,    11,    12,   191,   179,     9,     3,   196,   178,     2,     0,   199,   175,     0,     0,   201,   171,     0,     0,   204,   168,     0, 
    0,   206,   165,     0,     0,   208,   164,     0,     0,   212,   164,     0,   116,    35,    65,   163,   114,    51,    67,   136,   110,    70,    77,   102,   109,    82,    84,    71, 
   98,    93,   102,    27,    79,   133,   135,    20,    63,   161,   148,    17,    45,   177,   156,    17,    29,   187,   162,    17,    16,   193,   166,    14,     5,   198,   167,     8, 
    0,   200,   165,     1,     0,   201,   162,     0,     0,   202,   159,     0,     0,   202,   157,     0,     0,   203,   155,     0,     0,   207,   156,     0,   115,    26,     9,   198, 
  114,    58,    26,   148,   110,    80,    45,   104,   104,    92,    56,    79,    95,   102,    65,    50,    84,   130,    93,    36,    68,   162,   116,    28,    53,   181,   133,    25, 
   36,   192,   141,    25,    23,   200,   146,    24,     9,   204,   151,    16,     2,   205,   150,     5,     0,   204,   150,     0,     0,   203,   148,     0,     0,   202,   146,     0, 
    0,   201,   146,     0,     0,   205,   145,     0,    98,    78,     5,   222,    98,    84,     9,   207,   100,   104,    27,   152,    94,   112,    38,   123,    92,   118,    50,    86, 
   92,   116,    58,    44,    75,   145,    88,    36,    57,   170,   110,    29,    40,   184,   127,    28,    27,   192,   136,    26,    14,   198,   141,    20,     4,   201,   143,     9, 
    0,   201,   143,     0,     0,   199,   142,     0,     0,   198,   141,     0,     0,   197,   141,     0,     0,   200,   142,     0,    80,   108,     1,   241,    80,   118,     3,   238, 
   82,   139,    14,   200,    82,   142,    25,   161,    82,   146,    34,   131,    80,   138,    45,    87,    84,   129,    52,    42,    65,   155,    80,    34,    46,   176,   104,    29, 
   30,   187,   119,    28,    17,   192,   129,    24,     7,   196,   135,    12,     0,   196,   136,     2,     0,   195,   136,     0,     0,   193,   135,     0,     0,   192,   135,     0, 
    0,   195,   136,     0,    68,   144,     4,   241,    68,   148,     6,   237,    69,   154,    12,   214,    70,   161,    19,   186,    71,   162,    26,   157,    71,   159,    31,   126, 
   71,   149,    40,    82,    75,   146,    44,    37,    54,   170,    72,    29,    36,   182,    95,    27,    22,   188,   109,    25,    10,   191,   119,    17,     3,   192,   125,     6, 
    0,   192,   126,     0,     0,   190,   126,     0,     0,   189,   126,     0,     0,   190,   127,     0,    53,   162,     7,   241,    53,   163,     8,   237,    55,   166,    11,   222, 
   57,   171,    17,   199,    58,   170,    22,   178,    59,   171,    26,   153,    59,   168,    28,   121,    59,   165,    32,    80,    62,   163,    36,    34,    44,   179,    64,    27, 
   26,   186,    86,    26,    15,   188,   100,    20,     7,   188,   108,     9,     1,   189,   112,     1,     0,   188,   114,     0,     0,   186,   115,     0,     0,   186,   116,     0, 
   41,   175,     9,   241,    41,   173,     9,   238,    43,   175,    12,   227,    45,   177,    16,   209,    45,   177,    19,   193,    46,   178,    24,   173,    46,   178,    26,   148, 
   47,   176,    26,   118,    47,   176,    28,    77,    49,   173,    32,    36,    33,   182,    56,    26,    19,   186,    77,    21,     9,   186,    90,    12,     3,   187,    98,     4, 
    0,   184,   102,     0,     0,   181,   105,     0,     0,   180,   106,     0,    29,   182,    10,   243,    30,   181,    11,   239,    31,   181,    12,   230,    32,   184,    15,   218, 
   33,   184,    17,   203,    33,   184,    21,   189,    34,   184,    24,   167,    35,   184,    25,   143,    36,   181,    25,   110,    36,   181,    26,    76,    36,   180,    31,    38, 
   25,   184,    48,    23,    13,   184,    66,    15,     6,   184,    79,     6,     0,   184,    88,     0,     0,   178,    93,     0,     0,   175,    95,     0,    17,   187,    12,   243, 
   18,   184,    13,   238,    20,   186,    14,   230,    22,   186,    16,   220,    23,   186,    18,   207,    24,   186,    21,   194,    25,   186,    24,   179,    25,   186,    22,   158, 
   26,   184,    22,   137,    26,   184,    22,   105,    26,   184,    23,    71,    27,   186,    28,    36,    17,   186,    42,    20,     9,   184,    57,     9,     2,   184,    70,     3, 
    0,   178,    78,     0,     0,   172,    84,     0,     6,   189,    15,   243,     9,   187,    15,   238,    11,   187,    16,   231,    13,   186,    17,   221,    14,   186,    17,   211, 
   15,   184,    18,   199,    16,   184,    21,   188,    16,   184,    20,   168,    17,   186,    18,   151,    17,   184,    18,   127,    17,   184,    18,    98,    19,   186,    18,    65, 
   20,   189,    25,    35,    12,   188,    36,    17,     5,   182,    50,     6,     0,   179,    62,     0,     0,   171,    72,     0,     1,   190,    13,   243,     2,   189,    16,   238, 
    4,   188,    17,   230,     7,   187,    17,   222,     8,   186,    15,   212,     9,   184,    14,   202,     8,   184,    15,   192,     9,   184,    13,   179,     9,   186,    13,   161, 
    9,   184,    12,   141,    10,   184,    11,   116,    11,   184,    11,    88,    12,   187,    13,    57,    11,   190,    19,    30,     6,   187,    29,    12,     1,   180,    43,     2, 
    0,   172,    60,     0,     0,   191,     9,   244,     0,   189,     9,   238,     2,   188,     9,   230,     4,   187,     9,   221,     4,   184,     9,   212,     3,   182,     7,   204, 
    3,   184,     8,   195,     3,   184,     7,   184,     4,   184,     7,   168,     4,   184,     6,   151,     5,   184,     6,   131,     6,   184,     5,   105,     6,   186,     6,    77, 
    6,   189,     8,    45,     4,   190,    11,    20,     1,   184,    24,     5,     0,   175,    45,     0,     0,   192,     4,   244,     0,   189,     4,   238,     0,   187,     3,   230, 
    0,   184,     2,   221,     1,   182,     2,   211,     0,   180,     1,   203,     0,   180,     1,   194,     0,   181,     2,   186,     0,   181,     1,   172,     0,   181,     1,   156, 
    1,   181,     1,   140,     1,   182,     1,   119,     1,   184,     1,    94,     1,   186,     1,    64,     1,   189,     1,    32,     1,   189,     6,    11,     0,   179,    28,     0, 
    0,   193,     0,   245,     0,   190,     0,   238,     0,   188,     0,   228,     0,   184,     0,   218,     0,   178,     0,   205,     0,   179,     0,   199,     0,   179,     0,   192, 
    0,   179,     0,   184,     0,   180,     0,   172,     0,   180,     0,   158,     0,   181,     0,   144,     0,   182,     0,   126,     0,   184,     0,   104,     0,   187,     0,    79, 
    0,   189,     0,    44,     0,   191,     0,    14,     0,   194,     0,     0,    93,     9,   198,   216,    94,    13,   196,   182,    93,    12,   201,   139,    90,     9,   209,    68, 
   89,    15,   212,     3,    77,    52,   211,     3,    65,    97,   202,     4,    48,   132,   197,     5,    29,   150,   194,     6,    15,   164,   194,     5,    11,   176,   192,     4, 
    9,   184,   190,     4,     7,   190,   189,     3,     4,   196,   187,     3,     2,   201,   184,     1,     1,   204,   181,     0,     0,   208,   180,     0,    95,    10,   168,   215, 
  106,    32,   152,   164,   105,    38,   151,   129,   100,    34,   163,    78,    94,    46,   171,    10,    78,    89,   184,     8,    62,   123,   186,     8,    45,   146,   187,     8, 
   26,   159,   188,     9,    12,   172,   189,     6,     3,   181,   188,     1,     0,   188,   186,     0,     0,   191,   182,     0,     0,   195,   179,     0,     0,   198,   177,     0, 
    0,   202,   175,     0,     0,   205,   175,     0,   105,    24,   119,   184,   108,    36,   121,   156,   107,    56,   119,   118,   100,    52,   133,    86,    97,    52,   144,    17, 
   79,    92,   162,    13,    63,   129,   171,    11,    45,   149,   176,    11,    27,   162,   179,    12,    14,   175,   181,     9,     4,   182,   182,     3,     0,   188,   179,     0, 
    0,   190,   176,     0,     0,   193,   172,     0,     0,   196,   168,     0,     0,   199,   167,     0,     0,   202,   168,     0,   102,    22,    92,   192,   100,    34,    94,   168, 
  100,    53,   102,   131,   100,    70,   100,    95,    93,    66,   114,    54,    82,    80,   137,    22,    64,   126,   152,    18,    47,   151,   159,    17,    30,   163,   165,    17, 
   16,   175,   171,    13,     6,   182,   173,     6,     0,   187,   171,     0,     0,   189,   167,     0,     0,   191,   164,     0,     0,   193,   161,     0,     0,   194,   159,     0, 
    0,   198,   161,     0,    98,    18,    48,   204,   100,    38,    62,   167,    99,    58,    71,   133,    94,    76,    78,   100,    92,    86,    86,    76,    86,    90,    98,    37, 
   66,   130,   127,    28,    50,   151,   142,    25,    33,   165,   150,    24,    18,   177,   156,    20,     8,   182,   159,    10,     0,   188,   159,     1,     0,   189,   156,     0, 
    0,   189,   153,     0,     0,   189,   151,     0,     0,   190,   149,     0,     0,   194,   150,     0,    92,    20,     1,   238,    97,    33,    16,   196,   102,    68,    40,   135, 
   94,    84,    55,   102,    88,    93,    62,    79,    80,   105,    69,    59,    70,   127,    93,    45,    52,   154,   114,    37,    37,   171,   129,    36,    25,   184,   136,    32, 
   11,   190,   142,    23,     3,   193,   143,     9,     0,   193,   141,     0,     0,   192,   140,     0,     0,   191,   139,     0,     0,   190,   138,     0,     0,   193,   137,     0, 
   82,    74,     3,   243,    82,    80,     6,   233,    86,    97,    18,   194,    82,   107,    35,   151,    78,   113,    45,   123,    77,   116,    55,    90,    79,   115,    63,    54, 
   61,   141,    87,    46,    42,   163,   107,    39,    26,   176,   122,    35,    15,   184,   131,    27,     6,   189,   135,    15,     1,   189,   135,     2,     0,   189,   134,     0, 
    0,   188,   133,     0,     0,   187,   132,     0,     0,   189,   133,     0,    70,   121,     6,   241,    70,   126,     8,   234,    72,   133,    14,   213,    73,   141,    23,   182, 
   71,   141,    31,   154,    70,   140,    41,   125,    68,   134,    52,    89,    70,   127,    59,    53,    53,   150,    80,    42,    33,   170,   100,    36,    18,   179,   113,    29, 
    8,   184,   121,    20,     2,   186,   126,     7,     0,   184,   126,     0,     0,   182,   126,     0,     0,   181,   125,     0,     0,   184,   126,     0,    55,   147,     9,   241, 
   55,   150,    10,   234,    56,   151,    14,   219,    58,   154,    19,   198,    59,   155,    25,   177,    58,   153,    32,   153,    59,   152,    39,   121,    57,   144,    46,    84, 
   60,   143,    50,    46,    40,   164,    72,    36,    24,   176,    92,    31,    13,   179,   102,    23,     5,   181,   110,    11,     0,   182,   113,     1,     0,   180,   114,     0, 
    0,   178,   114,     0,     0,   179,   115,     0,    42,   158,    11,   241,    42,   159,    12,   237,    44,   159,    15,   226,    45,   161,    18,   208,    46,   164,    22,   192, 
   46,   163,    27,   172,    47,   163,    34,   147,    46,   162,    36,   118,    45,   159,    36,    80,    47,   159,    41,    41,    29,   170,    63,    32,    17,   177,    80,    24, 
    7,   179,    93,    16,     2,   178,    99,     3,     0,   177,   102,     0,     0,   173,   104,     0,     0,   175,   106,     0,    30,   170,    12,   243,    31,   168,    14,   237, 
   32,   168,    16,   227,    33,   171,    17,   216,    34,   172,    20,   202,    34,   172,    25,   187,    35,   171,    30,   165,    34,   171,    31,   143,    35,   170,    31,   112, 
   35,   168,    32,    78,    36,   170,    37,    43,    22,   175,    54,    26,    11,   176,    70,    16,     3,   177,    82,     8,     0,   175,    88,     0,     0,   168,    92,     0, 
    0,   167,    94,     0,    17,   178,    15,   243,    19,   177,    15,   238,    20,   177,    17,   231,    22,   177,    18,   221,    23,   178,    20,   208,    23,   177,    24,   194, 
   25,   176,    27,   178,    26,   177,    27,   158,    25,   176,    26,   138,    25,   175,    26,   106,    26,   173,    27,    74,    26,   177,    34,    40,    14,   178,    45,    21, 
    5,   177,    62,    12,     1,   173,    71,     1,     0,   167,    78,     0,     0,   164,    82,     0,     7,   182,    17,   243,     9,   180,    17,   238,    11,   180,    18,   231, 
   13,   180,    19,   221,    14,   179,    21,   209,    14,   177,    22,   198,    16,   177,    24,   186,    16,   178,    24,   168,    16,   177,    22,   151,    17,   177,    21,   129, 
   17,   176,    20,    98,    19,   177,    21,    66,    19,   181,    28,    37,     9,   179,    38,    18,     2,   173,    51,     6,     0,   167,    61,     0,     0,   162,    69,     0, 
    0,   184,    17,   243,     2,   182,    17,   238,     5,   181,    17,   231,     7,   180,    17,   222,     7,   178,    16,   213,     7,   176,    14,   202,     8,   177,    15,   191, 
    8,   177,    16,   178,     9,   177,    15,   161,     9,   176,    15,   141,    10,   176,    14,   116,    11,   176,    13,    88,    12,   178,    15,    58,    10,   182,    21,    33, 
    3,   178,    31,    14,     0,   170,    42,     1,     0,   161,    56,     0,     0,   187,    11,   244,     0,   184,    11,   238,     2,   182,    11,   230,     4,   181,    10,   221, 
    3,   179,     9,   213,     2,   176,     7,   203,     2,   176,     8,   193,     3,   176,     8,   182,     3,   176,     8,   167,     4,   175,     8,   149,     5,   173,     7,   130, 
    6,   173,     7,   104,     7,   175,     7,    76,     6,   178,    10,    46,     3,   181,    13,    23,     1,   173,    23,     6,     0,   162,    42,     0,     0,   189,     5,   244, 
    0,   184,     4,   238,     0,   181,     3,   230,     0,   179,     2,   221,     0,   177,     2,   211,     0,   172,     1,   200,     0,   172,     1,   191,     0,   172,     1,   182, 
    0,   172,     1,   168,     0,   171,     1,   153,     1,   172,     1,   138,     1,   172,     1,   116,     1,   172,     1,    93,     1,   175,     2,    63,     1,   177,     2,    31, 
    1,   177,     6,    10,     0,   165,    26,     0,     0,   189,     0,   244,     0,   187,     0,   238,     0,   182,     0,   228,     0,   178,     0,   218,     0,   173,     0,   205, 
    0,   167,     0,   193,     0,   167,     0,   187,     0,   168,     0,   178,     0,   168,     0,   166,     0,   168,     0,   153,     0,   168,     0,   141,     0,   170,     0,   125, 
    0,   170,     0,   102,     0,   173,     0,    76,     0,   176,     0,    40,     0,   178,     0,    11,     0,   179,     0,     0,    80,     9,   201,   216,    80,     9,   203,   197, 
   82,     9,   204,   166,    79,     7,   213,   116,    79,     9,   215,    48,    77,    18,   213,     4,    63,    48,   213,     3,    48,    94,   204,     5,    31,   125,   199,     6, 
   17,   144,   197,     5,    10,   158,   196,     3,     9,   167,   194,     3,     7,   177,   192,     2,     5,   184,   189,     2,     3,   189,   188,     1,     1,   193,   186,     0, 
    0,   197,   184,     0,    86,    12,   179,   214,    88,    23,   172,   189,    89,    28,   170,   157,    86,    25,   180,   122,    86,    26,   184,    45,    80,    49,   187,     9, 
   62,    86,   193,     8,    45,   116,   191,     8,    27,   140,   191,     9,    15,   153,   191,     7,     5,   164,   190,     2,     0,   173,   189,     0,     0,   179,   186,     0, 
    0,   184,   182,     0,     0,   188,   180,     0,     0,   191,   179,     0,     0,   194,   179,     0,    92,    19,   141,   197,    93,    31,   147,   173,    90,    40,   145,   151, 
   87,    39,   152,   125,    84,    37,   161,    60,    82,    51,   162,    15,    63,    90,   178,    12,    47,   121,   180,    12,    29,   142,   182,    12,    17,   155,   184,     9, 
    6,   166,   184,     4,     0,   173,   182,     0,     0,   178,   179,     0,     0,   182,   176,     0,     0,   186,   173,     0,     0,   189,   171,     0,     0,   192,   172,     0, 
   92,    21,   112,   195,    93,    30,   118,   179,    89,    40,   126,   156,    87,    55,   126,   127,    84,    56,   131,    91,    82,    52,   141,    43,    67,    89,   155,    19, 
   51,   123,   162,    17,    33,   143,   167,    17,    17,   156,   172,    14,     7,   165,   176,     7,     0,   173,   176,     0,     0,   177,   171,     0,     0,   180,   167,     0, 
    0,   184,   164,     0,     0,   186,   162,     0,     0,   189,   164,     0,    88,    24,    84,   197,    90,    34,    92,   179,    89,    41,   100,   161,    86,    62,    99,   125, 
   84,    77,    95,    95,    80,    75,   108,    62,    69,    93,   131,    29,    52,   126,   144,    25,    34,   144,   152,    24,    19,   157,   159,    19,     8,   165,   163,    10, 
    1,   171,   165,     1,     0,   175,   161,     0,     0,   177,   158,     0,     0,   179,   155,     0,     0,   181,   152,     0,     0,   184,   154,     0,    87,    20,    47,   213, 
   88,    31,    54,   192,    89,    45,    67,   165,    86,    67,    75,   130,    80,    82,    80,   100,    76,    91,    87,    80,    72,    97,    98,    45,    52,   125,   123,    36, 
   36,   146,   136,    33,    20,   158,   144,    27,     9,   167,   150,    17,     2,   172,   151,     4,     0,   175,   149,     0,     0,   176,   146,     0,     0,   176,   143,     0, 
    0,   177,   141,     0,     0,   181,   142,     0,    80,    36,     6,   243,    82,    50,    14,   221,    84,    64,    26,   189,    82,    80,    45,   143,    75,    93,    60,   104, 
   75,    93,    62,    82,    70,   108,    73,    66,    57,   123,    93,    55,    38,   149,   112,    46,    23,   164,   126,    40,    11,   175,   132,    31,     3,   180,   135,    17, 
    0,   181,   134,     2,     0,   180,   132,     0,     0,   178,   130,     0,     0,   178,   129,     0,     0,   180,   126,     0,    72,    80,     8,   243,    73,    87,    11,   232, 
   74,    99,    18,   208,    73,   106,    29,   179,    68,   109,    43,   146,    67,   110,    50,   115,    64,   114,    60,    91,    64,   115,    69,    65,    47,   137,    87,    56, 
   28,   156,   105,    45,    14,   167,   118,    36,     5,   175,   123,    24,     1,   177,   125,     7,     0,   176,   125,     0,     0,   175,   123,     0,     0,   173,   121,     0, 
    0,   175,   122,     0,    59,   118,    10,   241,    59,   123,    13,   232,    59,   129,    17,   218,    59,   135,    24,   196,    58,   134,    31,   176,    57,   135,    38,   150, 
   57,   136,    46,   121,    53,   132,    59,    93,    55,   126,    64,    64,    39,   145,    80,    50,    19,   162,    97,    38,     9,   168,   106,    26,     1,   175,   113,    15, 
    0,   172,   113,     0,     0,   170,   113,     0,     0,   167,   113,     0,     0,   168,   113,     0,    45,   141,    13,   243,    45,   143,    15,   233,    45,   146,    18,   222, 
   46,   148,    22,   206,    46,   148,    26,   190,    46,   148,    32,   171,    46,   149,    38,   146,    45,   149,    45,   119,    44,   141,    51,    87,    46,   142,    55,    55, 
   26,   157,    72,    40,    14,   165,    86,    28,     5,   170,    96,    18,     0,   170,   102,     6,     0,   167,   102,     0,     0,   164,   102,     0,     0,   164,   104,     0, 
   31,   155,    16,   243,    32,   156,    17,   236,    33,   156,    19,   226,    34,   158,    22,   214,    34,   157,    25,   200,    34,   157,    29,   186,    34,   157,    35,   162, 
   33,   159,    38,   144,    33,   157,    38,   113,    33,   155,    40,    80,    36,   157,    45,    47,    20,   163,    60,    31,     9,   166,    75,    17,     0,   170,    87,    12, 
    0,   165,    89,     0,     0,   159,    91,     0,     0,   159,    93,     0,    18,   166,    17,   243,    20,   166,    18,   238,    21,   166,    19,   230,    23,   166,    21,   220, 
   23,   165,    24,   208,    23,   164,    27,   194,    25,   165,    31,   176,    25,   165,    35,   156,    23,   164,    32,   137,    23,   164,    31,   107,    24,   162,    31,    75, 
   24,   166,    38,    44,    12,   166,    48,    23,     0,   170,    67,    17,     0,   164,    73,     2,     0,   158,    77,     0,     0,   155,    80,     0,     8,   173,    19,   243, 
    9,   172,    20,   238,    12,   171,    20,   231,    13,   171,    22,   221,    14,   170,    25,   209,    14,   167,    24,   198,    15,   167,    25,   184,    16,   168,    28,   168, 
   15,   167,    26,   151,    15,   166,    25,   129,    16,   166,    23,    98,    17,   166,    24,    68,    15,   172,    31,    40,     6,   168,    40,    19,     0,   164,    53,     8, 
    0,   157,    60,     0,     0,   152,    66,     0,     3,   178,    17,   243,     3,   175,    17,   238,     4,   173,    18,   231,     6,   171,    18,   222,     7,   170,    17,   213, 
    7,   167,    16,   201,     8,   168,    17,   189,     7,   168,    19,   178,     8,   167,    19,   161,     8,   166,    18,   141,     9,   165,    17,   115,    11,   164,    16,    88, 
   11,   167,    17,    59,     9,   172,    24,    35,     0,   168,    33,    17,     0,   159,    41,     1,     0,   151,    52,     0,     0,   180,    14,   244,     0,   177,    12,   238, 
    2,   176,    11,   230,     3,   173,    10,   222,     3,   171,     9,   213,     2,   166,     8,   202,     3,   166,     8,   191,     2,   167,    10,   181,     3,   166,    10,   166, 
    3,   164,    10,   148,     4,   164,    10,   130,     3,   165,    11,   106,     2,   166,    12,    80,     2,   170,    13,    51,     1,   171,    16,    26,     0,   163,    23,     8, 
    0,   151,    37,     0,     0,   182,     7,   244,     0,   178,     5,   238,     0,   176,     3,   230,     0,   172,     2,   221,     0,   170,     2,   212,     0,   165,     1,   200, 
    0,   163,     1,   189,     0,   163,     2,   179,     0,   163,     2,   166,     0,   162,     2,   151,     1,   161,     2,   136,     1,   161,     1,   113,     1,   161,     1,    91, 
    1,   163,     2,    62,     0,   165,     4,    33,     0,   165,     7,    12,     0,   151,    22,     0,     0,   184,     0,   243,     0,   180,     0,   237,     0,   177,     0,   228, 
    0,   172,     0,   218,     0,   167,     0,   206,     0,   162,     0,   193,     0,   157,     0,   178,     0,   157,     0,   170,     0,   157,     0,   159,     0,   157,     0,   149, 
    0,   157,     0,   137,     0,   156,     0,   120,     0,   156,     0,   100,     0,   158,     0,    75,     0,   159,     0,    39,     0,   161,     0,    10,     0,   161,     0,     0, 
   69,     9,   204,   218,    69,     9,   205,   203,    70,     9,   206,   184,    67,     6,   214,   150,    65,     7,   217,    95,    64,     9,   217,    38,    60,    20,   217,     5, 
   47,    45,   215,     5,    33,    87,   206,     6,    19,   115,   202,     6,    12,   139,   200,     4,     8,   151,   198,     2,     6,   161,   195,     2,     4,   170,   193,     1, 
    2,   177,   191,     1,     1,   182,   189,     0,     0,   188,   187,     0,    75,    10,   184,   219,    76,    17,   181,   204,    76,    23,   181,   180,    74,    21,   187,   152, 
   72,    20,   193,    94,    70,    23,   194,    33,    62,    45,   194,     9,    48,    77,   196,     9,    31,   107,   194,     9,    17,   132,   194,     7,     7,   147,   193,     3, 
    0,   156,   191,     0,     0,   163,   188,     0,     0,   170,   186,     0,     0,   176,   184,     0,     0,   180,   181,     0,     0,   184,   182,     0,    80,    19,   152,   201, 
   82,    26,   153,   189,    80,    33,   155,   170,    75,    32,   165,   151,    72,    29,   176,   104,    70,    32,   177,    47,    65,    50,   178,    14,    51,    84,   184,    13, 
   33,   113,   186,    12,    18,   136,   188,     9,     8,   148,   187,     4,     0,   157,   186,     0,     0,   163,   181,     0,     0,   168,   179,     0,     0,   173,   177,     0, 
    0,   178,   175,     0,     0,   181,   177,     0,    79,    21,   135,   202,    80,    27,   136,   189,    80,    35,   139,   170,    76,    42,   143,   152,    74,    45,   148,   126, 
   70,    43,   154,    82,    71,    51,   153,    21,    54,    86,   165,    18,    36,   114,   172,    17,    20,   137,   176,    14,     9,   149,   177,     9,     1,   157,   178,     1, 
    0,   163,   175,     0,     0,   167,   170,     0,     0,   171,   167,     0,     0,   175,   165,     0,     0,   178,   168,     0,    79,    22,   107,   205,    80,    28,   109,   191, 
   79,    36,   118,   175,    76,    47,   123,   151,    76,    65,   114,   119,    72,    64,   125,    92,    71,    63,   132,    36,    55,    89,   147,    26,    38,   118,   154,    24, 
   23,   138,   159,    20,    10,   149,   164,    12,     2,   156,   167,     2,     0,   161,   164,     0,     0,   164,   159,     0,     0,   167,   157,     0,     0,   170,   155,     0, 
    0,   175,   157,     0,    79,    20,    79,   215,    80,    28,    86,   198,    79,    39,    93,   179,    76,    50,    97,   155,    74,    68,    98,   122,    70,    80,    99,   100, 
   65,    77,   109,    69,    59,    84,   123,    38,    39,   119,   139,    33,    23,   139,   147,    27,    10,   148,   152,    17,     2,   155,   155,     4,     0,   159,   153,     0, 
    0,   161,   150,     0,     0,   163,   147,     0,     0,   165,   145,     0,     0,   170,   146,     0,    77,    15,    30,   234,    78,    26,    45,   212,    80,    39,    60,   188, 
   77,    53,    72,   161,    69,    75,    79,   130,    66,    84,    80,   102,    62,    94,    90,    86,    61,    93,    96,    54,    38,   122,   119,    44,    22,   141,   133,    36, 
   10,   150,   139,    26,     2,   157,   142,    12,     0,   159,   141,     0,     0,   159,   138,     0,     0,   161,   135,     0,     0,   161,   132,     0,     0,   165,   132,     0, 
   71,    45,    13,   243,    72,    43,    22,   224,    72,    52,    32,   200,    71,    70,    45,   168,    62,    87,    63,   135,    66,    86,    62,   104,    62,    94,    68,    89, 
   59,   110,    75,    72,    43,   121,    93,    63,    24,   143,   110,    52,     9,   158,   121,    41,     2,   164,   125,    25,     0,   165,   125,     8,     0,   165,   121,     0, 
    0,   164,   119,     0,     0,   162,   116,     0,     0,   164,   113,     0,    60,    90,    14,   243,    60,    95,    17,   230,    60,    97,    23,   216,    59,   104,    31,   195, 
   56,   106,    40,   173,    55,   109,    48,   139,    53,   110,    54,   112,    50,   113,    65,    93,    49,   115,    73,    74,    31,   135,    89,    65,    14,   151,   104,    48, 
    4,   159,   112,    35,     0,   163,   115,    17,     0,   161,   113,     1,     0,   159,   110,     0,     0,   158,   109,     0,     0,   158,   108,     0,    46,   118,    17,   243, 
   46,   122,    19,   231,    46,   123,    23,   220,    46,   126,    28,   204,    46,   130,    33,   189,    45,   131,    38,   167,    45,   132,    45,   142,    44,   134,    53,   118, 
   38,   130,    63,    95,    40,   126,    68,    72,    23,   141,    80,    57,    11,   154,    92,    36,     2,   159,   100,    22,     0,   159,   102,     6,     0,   157,   102,     0, 
    0,   155,   100,     0,     0,   154,   100,     0,    32,   139,    20,   243,    32,   140,    22,   233,    33,   140,    25,   224,    34,   141,    27,   212,    35,   142,    30,   199, 
   35,   143,    34,   184,    35,   145,    38,   159,    33,   147,    44,   142,    30,   146,    48,   116,    28,   139,    53,    89,    30,   141,    58,    61,    17,   151,    69,    41, 
    2,   159,    84,    31,     0,   159,    88,    12,     0,   155,    89,     0,     0,   152,    90,     0,     0,   151,    90,     0,    17,   151,    23,   243,    19,   152,    24,   237, 
   21,   151,    25,   228,    22,   152,    26,   217,    23,   152,    29,   205,    23,   152,    32,   192,    24,   153,    34,   175,    23,   153,    37,   156,    20,   154,    38,   138, 
   19,   151,    38,   109,    22,   150,    39,    79,    21,   153,    45,    50,     9,   156,    58,    33,     0,   158,    69,    17,     0,   155,    73,     1,     0,   150,    76,     0, 
    0,   146,    78,     0,     6,   161,    25,   244,     9,   161,    25,   237,    11,   161,    26,   229,    13,   159,    26,   220,    14,   159,    26,   209,    14,   158,    26,   198, 
   15,   158,    27,   184,    15,   157,    30,   167,    12,   158,    32,   152,    12,   156,    30,   130,    14,   154,    28,    99,    16,   154,    30,    70,    12,   159,    36,    45, 
    2,   159,    45,    25,     0,   155,    53,     7,     0,   148,    59,     0,     0,   142,    64,     0,     0,   167,    23,   244,     1,   165,    21,   238,     3,   163,    21,   231, 
    7,   162,    20,   222,     7,   159,    19,   213,     7,   159,    17,   201,     8,   159,    19,   189,     8,   158,    22,   176,     6,   158,    24,   161,     7,   157,    23,   141, 
    8,   155,    22,   116,     8,   156,    21,    91,     7,   158,    25,    65,     4,   162,    29,    40,     0,   158,    34,    17,     0,   149,    40,     1,     0,   141,    48,     0, 
    0,   171,    16,   244,     0,   168,    13,   238,     2,   166,    12,   230,     3,   164,    11,   222,     3,   162,    10,   213,     2,   159,     9,   203,     2,   159,    10,   192, 
    1,   159,    12,   181,     1,   158,    14,   166,     0,   158,    14,   150,     1,   158,    14,   133,     0,   157,    14,   108,     0,   158,    14,    82,     0,   159,    15,    52, 
    0,   161,    17,    26,     0,   152,    21,     6,     0,   139,    34,     0,     0,   175,     8,   244,     0,   171,     5,   238,     0,   167,     4,   230,     0,   164,     3,   222, 
    1,   162,     3,   212,     0,   159,     2,   201,     0,   157,     2,   189,     0,   155,     2,   176,     0,   153,     2,   161,     0,   153,     3,   149,     0,   152,     4,   134, 
    0,   152,     3,   113,     0,   152,     3,    92,     0,   153,     3,    64,     0,   153,     4,    33,     0,   153,     6,    11,     0,   138,    19,     0,     0,   177,     0,   243, 
    0,   173,     0,   237,     0,   170,     0,   228,     0,   165,     0,   218,     0,   161,     0,   207,     0,   157,     0,   194,     0,   151,     0,   180,     0,   144,     0,   159, 
    0,   144,     0,   150,     0,   143,     0,   141,     0,   143,     0,   130,     0,   142,     0,   114,     0,   141,     0,    96,     0,   143,     0,    74,     0,   144,     0,    39, 
    0,   144,     0,    10,     0,   143,     0,     0,    57,     8,   207,   221,    57,     8,   207,   211,    57,     8,   208,   194,    55,     7,   213,   171,    53,     6,   217,   135, 
   50,     8,   219,    80,    49,     9,   220,    34,    45,    18,   217,     6,    32,    40,   217,     7,    20,    79,   207,     6,    14,   108,   204,     4,     9,   131,   202,     2, 
    6,   145,   199,     1,     4,   154,   196,     1,     2,   162,   194,     0,     0,   170,   191,     0,     0,   176,   189,     0,    63,    10,   189,   221,    64,    16,   187,   208, 
   65,    20,   186,   191,    62,    18,   191,   171,    59,    16,   199,   133,    57,    18,   200,    78,    57,    23,   196,    30,    48,    41,   196,    11,    33,    72,   198,    11, 
   18,   102,   198,     8,     9,   123,   196,     3,     1,   140,   194,     0,     0,   149,   190,     0,     0,   155,   188,     0,     0,   162,   186,     0,     0,   167,   184,     0, 
    0,   172,   186,     0,    70,    17,   166,   209,    70,    21,   166,   200,    68,    28,   165,   184,    65,    28,   173,   167,    61,    25,   184,   137,    59,    26,   186,    91, 
   59,    30,   182,    39,    53,    46,   182,    16,    36,    78,   189,    14,    21,   106,   190,    10,     9,   127,   189,     6,     1,   141,   188,     0,     0,   149,   184,     0, 
    0,   155,   181,     0,     0,   161,   179,     0,     0,   165,   177,     0,     0,   168,   179,     0,    71,    17,   147,   211,    70,    23,   149,   199,    67,    30,   151,   186, 
   66,    36,   154,   167,    63,    37,   159,   148,    60,    36,   164,   113,    59,    39,   165,    58,    59,    48,   162,    22,    39,    80,   173,    18,    24,   108,   179,    15, 
   11,   130,   180,     9,     3,   141,   179,     2,     0,   150,   177,     0,     0,   154,   172,     0,     0,   158,   168,     0,     0,   162,   167,     0,     0,   165,   171,     0, 
   71,    21,   126,   208,    71,    26,   127,   199,    67,    33,   134,   186,    65,    41,   138,   166,    64,    49,   139,   148,    61,    51,   142,   121,    58,    51,   147,    71, 
   61,    57,   144,    29,    41,    86,   156,    25,    25,   112,   163,    21,    13,   131,   166,    13,     4,   141,   167,     4,     0,   149,   166,     0,     0,   152,   161,     0, 
    0,   155,   158,     0,     0,   158,   156,     0,     0,   162,   159,     0,    69,    19,   104,   220,    70,    28,   107,   201,    68,    37,   110,   186,    65,    45,   114,   166, 
   63,    54,   119,   148,    62,    69,   115,   120,    57,    69,   123,    93,    55,    66,   131,    57,    41,    91,   141,    34,    26,   115,   149,    28,    14,   131,   153,    19, 
    5,   141,   156,     7,     0,   147,   155,     0,     0,   150,   151,     0,     0,   152,   148,     0,     0,   155,   146,     0,     0,   159,   147,     0,    69,    17,    70,   233, 
   70,    30,    80,   206,    68,    43,    89,   184,    65,    51,    93,   166,    61,    60,    97,   151,    60,    75,    98,   118,    57,    84,    98,   102,    53,    82,   107,    75, 
   43,    96,   121,    45,    25,   116,   134,    36,    12,   131,   141,    26,     3,   141,   145,    13,     0,   145,   145,     0,     0,   148,   141,     0,     0,   149,   138,     0, 
    0,   151,   135,     0,     0,   154,   135,     0,    67,    20,    32,   239,    67,    28,    48,   222,    66,    41,    60,   200,    62,    54,    70,   181,    57,    68,    79,   156, 
   56,    76,    79,   127,    53,    86,    82,   104,    48,    98,    91,    89,    46,   100,    97,    62,    25,   118,   115,    49,    10,   136,   127,    36,     3,   143,   131,    20, 
    0,   146,   131,     3,     0,   147,   127,     0,     0,   148,   123,     0,     0,   149,   120,     0,     0,   151,   118,     0,    56,    52,    22,   244,    57,    62,    26,   228, 
   57,    68,    33,   214,    55,    77,    42,   194,    50,    84,    53,   170,    54,    86,    57,   134,    56,    87,    59,   102,    50,    97,    71,    92,    40,   110,    79,    80, 
   25,   120,    96,    71,     9,   141,   109,    56,     2,   149,   113,    37,     0,   151,   112,    13,     0,   151,   110,     0,     0,   151,   107,     0,     0,   150,   105,     0, 
    0,   150,   100,     0,    45,    89,    24,   243,    44,    94,    26,   233,    43,    97,    31,   223,    43,   100,    37,   207,    42,   104,    42,   191,    42,   106,    47,   166, 
   44,   106,    51,   132,    43,   109,    58,   109,    34,   113,    69,    98,    32,   115,    76,    82,    14,   132,    90,    71,     1,   147,   100,    51,     0,   150,   104,    26, 
    0,   149,   102,     3,     0,   147,   100,     0,     0,   145,    98,     0,     0,   144,    95,     0,    31,   114,    26,   243,    31,   119,    27,   236,    31,   120,    30,   226, 
   33,   122,    34,   214,    33,   125,    36,   199,    34,   126,    40,   184,    35,   129,    43,   158,    33,   130,    46,   138,    26,   133,    56,   120,    21,   127,    64,    97, 
   22,   126,    72,    77,     8,   139,    82,    63,     1,   146,    88,    36,     0,   149,    89,    11,     0,   146,    88,     0,     0,   142,    88,     0,     0,   140,    87,     0, 
   16,   136,    30,   244,    17,   138,    30,   237,    18,   138,    31,   229,    20,   139,    33,   218,    22,   140,    34,   205,    23,   141,    36,   191,    24,   141,    37,   173, 
   23,   141,    38,   155,    18,   142,    45,   140,    16,   140,    48,   113,    14,   135,    56,    90,    13,   138,    61,    67,     0,   148,    71,    47,     0,   149,    73,    19, 
    0,   145,    74,     1,     0,   141,    75,     0,     0,   136,    75,     0,     2,   149,    33,   244,     5,   150,    32,   238,     8,   150,    32,   230,     9,   149,    32,   221, 
   12,   148,    31,   209,    14,   147,    29,   197,    16,   147,    30,   182,    15,   145,    32,   164,    11,   146,    36,   151,     9,   146,    38,   131,     8,   145,    40,   105, 
    9,   144,    42,    79,     7,   148,    46,    52,     0,   149,    53,    31,     0,   145,    54,     6,     0,   139,    58,     0,     0,   132,    61,     0,     0,   155,    26,   244, 
    1,   154,    23,   238,     3,   153,    23,   231,     6,   152,    22,   223,     7,   151,    21,   213,     8,   149,    20,   200,     9,   149,    21,   188,     7,   149,    25,   176, 
    4,   149,    28,   161,     3,   149,    29,   144,     2,   149,    29,   123,     4,   148,    28,    95,     5,   147,    29,    67,     2,   150,    34,    41,     0,   146,    36,    15, 
    0,   139,    40,     0,     0,   127,    45,     0,     0,   159,    17,   244,     0,   159,    14,   238,     2,   157,    13,   230,     2,   155,    13,   223,     2,   154,    12,   215, 
    1,   152,    12,   204,     1,   151,    13,   193,     0,   151,    14,   181,     0,   149,    15,   165,     0,   149,    15,   149,     1,   148,    15,   131,     1,   147,    15,   106, 
    0,   149,    16,    82,     0,   150,    17,    53,     0,   151,    18,    26,     0,   141,    21,     4,     0,   125,    31,     0,     0,   165,     9,   244,     0,   162,     5,   238, 
    0,   159,     4,   230,     0,   157,     3,   222,     1,   154,     4,   212,     0,   151,     3,   201,     0,   150,     3,   190,     0,   147,     3,   177,     0,   145,     3,   159, 
    0,   144,     4,   146,     0,   143,     4,   131,     0,   142,     4,   110,     0,   142,     3,    89,     0,   144,     4,    62,     0,   143,     4,    32,     0,   142,     6,     9, 
    0,   120,    17,     0,     0,   167,     0,   243,     0,   165,     0,   238,     0,   162,     0,   229,     0,   158,     0,   219,     0,   154,     0,   207,     0,   150,     0,   194, 
    0,   144,     0,   180,     0,   138,     0,   159,     0,   132,     0,   141,     0,   130,     0,   131,     0,   127,     0,   120,     0,   126,     0,   107,     0,   126,     0,    92, 
    0,   127,     0,    70,     0,   127,     0,    39,     0,   126,     0,    11,     0,   125,     0,     0,    45,     8,   208,   222,    45,     8,   208,   213,    45,     8,   209,   200, 
   43,     7,   213,   184,    40,     6,   217,   155,    37,     7,   219,   113,    35,     9,   220,    71,    32,    11,   219,    33,    31,    17,   217,     9,    22,    33,   218,     6, 
   16,    73,   212,     4,    10,   102,   206,     3,     6,   125,   203,     1,     3,   139,   200,     1,     2,   149,   197,     0,     0,   156,   194,     0,     0,   163,   192,     0, 
   48,     9,   195,   226,    50,    13,   191,   218,    52,    18,   190,   200,    49,    17,   195,   184,    45,    14,   203,   153,    44,    16,   203,   114,    44,    18,   202,    70, 
   42,    22,   199,    33,    36,    38,   197,    13,    23,    63,   199,     9,    12,    91,   196,     6,     4,   113,   196,     1,     0,   131,   193,     0,     0,   141,   190,     0, 
    0,   149,   189,     0,     0,   155,   187,     0,     0,   159,   188,     0,    51,    12,   179,   224,    56,    17,   173,   213,    58,    25,   173,   194,    52,    25,   181,   182, 
   47,    21,   190,   154,    46,    22,   191,   125,    46,    25,   190,    79,    45,    29,   187,    42,    40,    44,   184,    17,    26,    70,   189,    14,    13,    96,   189,     8, 
    3,   118,   189,     1,     0,   133,   187,     0,     0,   142,   184,     0,     0,   149,   181,     0,     0,   153,   179,     0,     0,   157,   181,     0,    54,    14,   161,   224, 
   58,    19,   159,   212,    59,    26,   159,   193,    55,    32,   163,   181,    51,    33,   167,   163,    49,    34,   171,   141,    47,    34,   173,   105,    45,    35,   175,    70, 
   44,    49,   170,    23,    27,    76,   177,    17,    15,   100,   180,    10,     5,   120,   180,     3,     0,   134,   179,     0,     0,   142,   175,     0,     0,   147,   171,     0, 
    0,   151,   168,     0,     0,   153,   173,     0,    55,    17,   144,   223,    57,    23,   143,   209,    58,    29,   145,   194,    58,    36,   148,   179,    53,    44,   148,   159, 
   51,    45,   151,   143,    49,    45,   153,   112,    47,    45,   155,    76,    45,    59,   154,    29,    27,    82,   163,    23,    15,   104,   167,    14,     6,   122,   170,     5, 
    0,   134,   168,     0,     0,   141,   163,     0,     0,   144,   159,     0,     0,   148,   158,     0,     0,   151,   161,     0,    55,    18,   123,   228,    54,    27,   126,   211, 
   55,    35,   127,   194,    56,    40,   131,   178,    53,    47,   133,   159,    49,    57,   135,   143,    47,    58,   138,   125,    45,    57,   141,    86,    45,    66,   140,    38, 
   27,    87,   150,    29,    15,   106,   155,    18,     7,   123,   157,     8,     0,   133,   157,     0,     0,   139,   153,     0,     0,   141,   150,     0,     0,   145,   147,     0, 
    0,   148,   150,     0,    57,    19,    98,   233,    56,    31,   104,   211,    54,    40,   109,   192,    53,    46,   110,   177,    51,    53,   113,   159,    51,    60,   119,   144, 
   49,    75,   112,   118,    45,    74,   119,    93,    45,    76,   123,    51,    28,    91,   136,    38,    15,   107,   142,    25,     5,   123,   147,    16,     0,   131,   147,     1, 
    0,   136,   143,     0,     0,   139,   139,     0,     0,   141,   136,     0,     0,   145,   137,     0,    57,    22,    69,   238,    55,    33,    80,   219,    53,    42,    87,   201, 
   50,    50,    93,   186,    48,    59,    95,   164,    47,    66,    98,   147,    46,    77,    98,   120,    39,    87,   102,   105,    37,    84,   106,    79,    33,    90,   116,    52, 
   15,   110,   129,    36,     5,   126,   135,    23,     0,   131,   136,     5,     0,   134,   132,     0,     0,   137,   127,     0,     0,   139,   123,     0,     0,   141,   121,     0, 
   53,    30,    38,   240,    53,    40,    44,   223,    49,    47,    52,   213,    45,    56,    72,   196,    43,    67,    79,   177,    44,    71,    79,   152,    43,    76,    80,   123, 
   36,    87,    86,   106,    29,    97,    93,    95,    27,    98,    99,    71,    11,   116,   113,    51,     2,   130,   120,    35,     0,   133,   120,    11,     0,   134,   115,     0, 
    0,   135,   110,     0,     0,   136,   108,     0,     0,   136,   104,     0,    40,    63,    34,   244,    39,    72,    36,   233,    37,    75,    42,   224,    36,    73,    54,   206, 
   34,    82,    65,   182,    42,    76,    58,   157,    47,    77,    57,   126,    43,    88,    65,   104,    33,    98,    75,    97,    21,   110,    82,    91,     6,   121,    98,    77, 
    0,   133,   102,    51,     0,   137,   100,    23,     0,   138,    98,     2,     0,   138,    95,     0,     0,   136,    93,     0,     0,   137,    89,     0,    28,    93,    35,   244, 
   28,    99,    36,   236,    28,   100,    38,   226,    29,   102,    43,   215,    28,   102,    46,   200,    29,   102,    49,   184,    34,   102,    47,   155,    36,   105,    52,   125, 
   22,   110,    64,   115,    16,   114,    74,   104,    10,   116,    82,    91,     4,   126,    87,    70,     0,   135,    90,    37,     0,   137,    88,     9,     0,   135,    86,     0, 
    0,   132,    84,     0,     0,   130,    82,     0,    14,   116,    37,   244,    16,   121,    37,   237,    17,   122,    37,   229,    19,   123,    39,   219,    20,   123,    40,   206, 
   23,   122,    41,   192,    25,   122,    41,   173,    24,   123,    41,   152,    16,   126,    50,   139,     8,   123,    64,   121,     4,   121,    73,   104,     2,   125,    75,    86, 
    0,   130,    75,    55,     0,   135,    75,    21,     0,   134,    74,     1,     0,   129,    74,     0,     0,   126,    74,     0,     2,   134,    37,   244,     5,   136,    35,   238, 
    6,   135,    36,   231,     9,   135,    35,   222,    12,   134,    35,   211,    15,   133,    33,   197,    17,   134,    33,   181,    13,   134,    36,   166,     9,   134,    40,   151, 
    2,   131,    52,   134,     0,   131,    56,   113,     0,   130,    57,    90,     0,   133,    59,    66,     0,   136,    57,    32,     0,   134,    55,     4,     0,   126,    58,     0, 
    0,   120,    60,     0,     0,   142,    28,   244,     1,   142,    25,   238,     3,   142,    25,   231,     6,   141,    25,   222,     7,   140,    25,   212,     6,   139,    25,   201, 
    7,   139,    26,   188,     7,   138,    27,   173,     5,   137,    29,   157,     1,   138,    35,   143,     0,   138,    36,   123,     0,   137,    36,   100,     0,   137,    37,    73, 
    0,   139,    38,    43,     0,   135,    37,    15,     0,   126,    41,     0,     0,   116,    45,     0,     0,   149,    18,   245,     0,   149,    16,   238,     1,   148,    15,   232, 
    2,   145,    14,   224,     2,   143,    14,   215,     2,   141,    14,   203,     1,   140,    15,   191,     0,   140,    17,   181,     0,   140,    17,   164,     0,   138,    18,   147, 
    0,   138,    19,   129,     0,   137,    19,   107,     0,   137,    19,    82,     0,   137,    20,    51,     0,   138,    21,    26,     0,   129,    22,     2,     0,   114,    30,     0, 
    0,   154,     9,   245,     0,   153,     6,   238,     0,   151,     5,   231,     0,   149,     5,   223,     0,   146,     5,   214,     0,   142,     4,   202,     0,   140,     4,   190, 
    0,   138,     4,   177,     0,   136,     4,   159,     0,   134,     5,   144,     0,   133,     4,   129,     0,   132,     5,   109,     0,   132,     4,    88,     0,   133,     5,    61, 
    0,   132,     5,    31,     0,   132,     7,     8,     0,   110,    16,     0,     0,   158,     0,   241,     0,   157,     0,   238,     0,   154,     0,   229,     0,   151,     0,   220, 
    0,   147,     0,   208,     0,   141,     0,   195,     0,   136,     0,   180,     0,   130,     0,   159,     0,   121,     0,   141,     0,   119,     0,   126,     0,   118,     0,   115, 
    0,   115,     0,   104,     0,   114,     0,    89,     0,   115,     0,    70,     0,   114,     0,    41,     0,   113,     0,    13,     0,   110,     0,     0,    32,     8,   208,   221, 
   33,     8,   209,   214,    32,     8,   211,   203,    30,     6,   215,   189,    28,     5,   218,   168,    26,     6,   220,   139,    25,     6,   222,    98,    24,     8,   222,    62, 
   24,     9,   221,    29,    24,    14,   221,     9,    16,    27,   222,     5,    12,    67,   215,     3,     8,    96,   208,     2,     4,   116,   204,     1,     1,   133,   201,     0, 
    0,   143,   197,     0,     0,   151,   195,     0,    33,    10,   201,   225,    36,    12,   195,   221,    39,    17,   193,   206,    36,    16,   197,   192,    32,    13,   205,   165, 
   30,    15,   205,   141,    29,    15,   205,   102,    28,    17,   204,    67,    29,    21,   200,    35,    26,    33,   198,    15,    16,    51,   199,     9,     7,    84,   198,     3, 
    1,   104,   196,     0,     0,   122,   192,     0,     0,   135,   190,     0,     0,   142,   189,     0,     0,   148,   190,     0,    35,    12,   191,   227,    40,    15,   184,   220, 
   44,    24,   178,   200,    39,    24,   186,   192,    34,    20,   193,   166,    32,    21,   194,   145,    31,    22,   193,   110,    31,    24,   191,    77,    31,    27,   189,    44, 
   29,    40,   187,    19,    17,    59,   189,    11,     7,    87,   189,     4,     0,   107,   189,     0,     0,   123,   186,     0,     0,   135,   184,     0,     0,   141,   181,     0, 
    0,   145,   184,     0,    37,    13,   177,   230,    42,    17,   170,   220,    44,    26,   166,   200,    41,    30,   168,   189,    38,    32,   172,   176,    36,    33,   175,   155, 
   34,    32,   176,   133,    33,    31,   178,    99,    33,    36,   176,    47,    30,    49,   176,    22,    18,    69,   180,    14,     8,    93,   180,     5,     0,   110,   180,     0, 
    0,   125,   176,     0,     0,   133,   173,     0,     0,   139,   171,     0,     0,   142,   176,     0,    39,    17,   158,   231,    43,    21,   153,   219,    45,    28,   154,   200, 
   43,    35,   154,   187,    41,    41,   154,   171,    40,    45,   154,   153,    38,    45,   156,   135,    36,    41,   161,   102,    35,    44,   161,    52,    30,    59,   162,    27, 
   17,    77,   167,    17,     8,    98,   170,     6,     0,   113,   170,     0,     0,   123,   164,     0,     0,   131,   161,     0,     0,   137,   159,     0,     0,   140,   163,     0, 
   42,    18,   141,   233,    45,    25,   141,   218,    50,    30,   141,   200,    45,    38,   141,   186,    42,    45,   142,   170,    39,    52,   143,   154,    38,    53,   145,   139, 
   36,    49,   149,   107,    34,    51,   150,    62,    30,    65,   150,    34,    17,    82,   156,    20,     8,   100,   158,     8,     0,   112,   159,     0,     0,   121,   154,     0, 
    0,   127,   151,     0,     0,   133,   148,     0,     0,   137,   151,     0,    42,    22,   118,   236,    44,    30,   120,   217,    46,    36,   123,   199,    45,    42,   126,   187, 
   41,    48,   126,   171,    37,    55,   130,   155,    36,    63,   134,   142,    34,    61,   135,   114,    32,    61,   136,    75,    33,    72,   136,    45,    17,    84,   144,    27, 
    5,   102,   149,    16,     1,   110,   148,     1,     0,   119,   145,     0,     0,   126,   141,     0,     0,   130,   138,     0,     0,   134,   139,     0,    42,    27,    96,   237, 
   41,    35,   102,   220,    41,    41,   105,   205,    40,    47,   108,   190,    37,    55,   110,   172,    37,    59,   112,   156,    36,    65,   116,   141,    33,    80,   110,   119, 
   29,    75,   115,    95,    31,    75,   120,    65,    18,    90,   131,    37,     5,   105,   137,    24,     0,   113,   139,     9,     0,   118,   135,     0,     0,   123,   130,     0, 
    0,   126,   126,     0,     0,   129,   125,     0,    41,    33,    72,   238,    41,    39,    75,   228,    38,    45,    82,   216,    36,    54,    92,   197,    34,    61,    95,   175, 
   34,    63,    95,   156,    32,    68,    95,   139,    29,    80,    98,   119,    22,    90,   100,   108,    23,    86,   104,    80,    15,    95,   115,    51,     6,   107,   122,    34, 
    0,   114,   126,    14,     0,   116,   121,     0,     0,   121,   116,     0,     0,   123,   110,     0,     0,   123,   108,     0,    35,    44,    48,   241,    34,    51,    52,   230, 
   31,    58,    61,   221,    27,    64,    76,   206,    27,    67,    80,   189,    32,    65,    78,   168,    30,    68,    78,   149,    25,    82,    82,   126,    19,    92,    87,   110, 
   13,    99,    93,    97,     8,   104,   100,    76,     0,   112,   107,    50,     0,   116,   107,    23,     0,   118,   104,     1,     0,   119,   100,     0,     0,   119,    95,     0, 
    0,   120,    92,     0,    22,    74,    47,   244,    22,    79,    48,   236,    22,    82,    51,   226,    22,    86,    57,   213,    24,    84,    58,   197,    31,    76,    52,   176, 
   39,    74,    48,   147,    39,    84,    55,   120,    25,    93,    67,   106,    13,   100,    78,   104,     0,   109,    84,   100,     0,   110,    91,    72,     0,   119,    88,    34, 
    0,   121,    84,     4,     0,   121,    82,     0,     0,   120,    80,     0,     0,   120,    76,     0,    10,    99,    48,   244,    11,   102,    47,   238,    12,   104,    48,   230, 
   14,   104,    49,   220,    17,   102,    48,   207,    22,    97,    46,   190,    27,    96,    44,   166,    20,   102,    49,   152,     1,   107,    65,   143,     6,   102,    70,   116, 
    4,   105,    75,   102,     0,   110,    79,    86,     0,   114,    77,    54,     0,   119,    75,    17,     0,   119,    72,     0,     0,   115,    71,     0,     0,   113,    69,     0, 
    0,   115,    45,   244,     2,   119,    43,   238,     5,   119,    42,   231,     9,   118,    40,   223,    12,   115,    39,   212,    15,   114,    37,   197,    17,   114,    36,   181, 
   14,   115,    38,   166,     3,   119,    46,   157,     4,   114,    57,   130,     0,   110,    65,   110,     0,   110,    66,    92,     0,   110,    66,    70,     0,   114,    61,    36, 
    0,   118,    56,     4,     0,   113,    57,     0,     0,   109,    58,     0,     0,   126,    32,   245,     1,   126,    28,   238,     3,   126,    28,   230,     7,   126,    28,   221, 
    7,   125,    29,   212,     5,   125,    30,   203,     4,   126,    32,   192,     0,   126,    34,   182,     0,   126,    35,   163,     0,   123,    37,   144,     0,   116,    43,   119, 
    0,   114,    44,    97,     0,   114,    44,    75,     0,   118,    45,    46,     0,   119,    39,    13,     0,   113,    41,     0,     0,   106,    44,     0,     0,   134,    21,   245, 
    0,   136,    18,   238,     0,   135,    17,   232,     0,   133,    19,   225,     0,   132,    19,   217,     0,   130,    19,   205,     0,   129,    20,   192,     0,   127,    20,   179, 
    0,   127,    20,   162,     0,   125,    21,   145,     0,   122,    23,   126,     0,   121,    23,   104,     0,   121,    23,    80,     0,   121,    23,    51,     0,   123,    23,    24, 
    0,   115,    23,     1,     0,   104,    30,     0,     0,   142,    10,   245,     0,   141,     7,   239,     0,   140,     6,   232,     0,   137,     6,   224,     0,   135,     6,   214, 
    0,   131,     6,   202,     0,   129,     6,   189,     0,   126,     6,   176,     0,   125,     7,   158,     0,   122,     6,   142,     0,   121,     6,   126,     0,   120,     6,   107, 
    0,   120,     6,    87,     0,   120,     6,    60,     0,   120,     6,    30,     0,   119,     7,     6,     0,   102,    16,     0,     0,   147,     0,   241,     0,   146,     0,   239, 
    0,   144,     0,   231,     0,   141,     0,   221,     0,   137,     0,   209,     0,   132,     0,   196,     0,   126,     0,   180,     0,   118,     0,   159,     0,   110,     0,   141, 
    0,   108,     0,   126,     0,   107,     0,   110,     0,   105,     0,   102,     0,   104,     0,    87,     0,   104,     0,    69,     0,   104,     0,    43,     0,   102,     0,    16, 
    0,   100,     0,     0,    22,     8,   211,   221,    22,     8,   211,   215,    21,     8,   212,   205,    20,     6,   216,   194,    19,     5,   219,   180,    19,     4,   221,   155, 
   18,     4,   223,   125,    18,     5,   225,    87,    18,     5,   225,    54,    18,     8,   226,    26,    18,    12,   226,     7,    12,    24,   226,     4,     9,    62,   218,     2, 
    5,    91,   211,     1,     2,   110,   205,     0,     0,   126,   201,     0,     0,   138,   197,     0,    21,    10,   204,   225,    25,    12,   200,   224,    26,    15,   199,   213, 
   24,    14,   202,   198,    22,    12,   206,   176,    22,    12,   207,   154,    20,    11,   208,   126,    20,    12,   208,    89,    20,    14,   205,    60,    20,    18,   202,    35, 
   19,    27,   200,    17,    10,    43,   201,     8,     3,    73,   200,     1,     0,    97,   196,     0,     0,   112,   192,     0,     0,   126,   190,     0,     0,   135,   192,     0, 
   22,    12,   196,   228,    26,    14,   190,   225,    28,    19,   189,   211,    26,    21,   191,   198,    24,    18,   196,   176,    23,    17,   197,   157,    21,    17,   197,   134, 
   21,    18,   196,    99,    22,    20,   193,    69,    22,    25,   191,    40,    20,    37,   189,    21,    10,    50,   191,     9,     2,    76,   191,     1,     0,    99,   188,     0, 
    0,   114,   184,     0,     0,   125,   182,     0,     0,   132,   187,     0,    23,    15,   184,   231,    26,    17,   178,   226,    29,    23,   177,   212,    28,    27,   177,   198, 
   27,    30,   178,   184,    26,    29,   180,   166,    24,    27,   182,   149,    21,    24,   184,   120,    24,    26,   181,    72,    25,    34,   179,    39,    20,    47,   180,    20, 
   10,    61,   182,     9,     1,    84,   182,     0,     0,   102,   177,     0,     0,   113,   173,     0,     0,   122,   172,     0,     0,   129,   177,     0,    26,    18,   167,   232, 
   27,    21,   164,   225,    29,    26,   164,   211,    29,    32,   162,   196,    30,    39,   159,   179,    29,    42,   161,   164,    26,    38,   165,   149,    23,    33,   168,   125, 
   24,    33,   168,    75,    26,    41,   166,    42,    19,    56,   168,    22,     9,    70,   172,     9,     0,    89,   172,     0,     0,   102,   165,     0,     0,   112,   162,     0, 
    0,   120,   159,     0,     0,   125,   165,     0,    27,    22,   151,   233,    29,    26,   151,   222,    29,    32,   150,   206,    29,    36,   151,   193,    29,    42,   151,   180, 
   28,    48,   150,   163,    26,    48,   151,   150,    24,    41,   156,   130,    24,    40,   156,    82,    25,    46,   154,    48,    18,    60,   157,    26,     9,    75,   159,    11, 
    1,    90,   161,     1,     0,   102,   156,     0,     0,   110,   151,     0,     0,   116,   149,     0,     0,   121,   152,     0,    26,    26,   135,   236,    28,    33,   136,   218, 
   29,    39,   135,   200,    29,    43,   136,   191,    28,    46,   138,   179,    26,    50,   139,   163,    26,    56,   141,   151,    22,    49,   145,   135,    22,    47,   145,    93, 
   24,    52,   142,    60,    18,    65,   145,    34,     8,    78,   150,    17,     2,    89,   150,     3,     0,   100,   146,     0,     0,   108,   141,     0,     0,   115,   139,     0, 
    0,   118,   141,     0,    26,    32,   116,   237,    26,    38,   120,   220,    26,    44,   121,   205,    26,    47,   122,   192,    26,    51,   123,   180,    26,    54,   126,   165, 
   25,    57,   127,   151,    20,    63,   130,   138,    19,    60,   129,   110,    21,    59,   130,    82,    17,    72,   133,    46,     3,    86,   141,    31,     0,    93,   141,    10, 
    0,   100,   137,     0,     0,   107,   132,     0,     0,   113,   126,     0,     0,   114,   126,     0,    26,    38,    96,   238,    25,    44,   102,   223,    26,    47,   105,   211, 
   25,    52,   108,   196,    25,    54,   108,   181,    26,    55,   107,   165,    24,    59,   106,   148,    19,    67,   110,   135,    15,    79,   109,   119,    14,    75,   112,    96, 
   15,    79,   118,    62,     3,    89,   126,    43,     0,    95,   127,    18,     0,   100,   125,     0,     0,   106,   120,     0,     0,   110,   114,     0,     0,   109,   110,     0, 
   23,    46,    77,   240,    21,    51,    86,   229,    21,    55,    89,   219,    21,    57,    93,   206,    23,    57,    92,   189,    26,    56,    91,   166,    21,    61,    93,   152, 
   20,    70,    95,   137,    10,    82,    98,   122,     6,    88,   100,   109,     8,    86,   104,    84,     1,    91,   110,    68,     0,    99,   109,    41,     0,   100,   110,     4, 
    0,   104,   104,     0,     0,   106,    99,     0,     0,   105,    96,     0,    15,    60,    62,   243,    17,    64,    63,   233,    17,    67,    65,   221,    19,    69,    70,   207, 
   23,    65,    70,   193,    19,    60,    75,   184,     9,    67,    80,   175,     3,    75,    84,   158,     2,    84,    87,   135,     1,    93,    90,   115,     0,    94,    92,    97, 
    0,    94,    94,    79,     0,    99,    93,    46,     0,   100,    90,     7,     0,   102,    86,     0,     0,   104,    82,     0,     0,   102,    79,     0,     1,    84,    64,   244, 
    4,    88,    62,   237,     7,    87,    59,   228,    12,    84,    55,   217,    18,    76,    51,   200,    30,    61,    48,   175,    28,    65,    51,   159,    32,    72,    52,   140, 
   18,    82,    64,   125,     0,    91,    76,   119,     0,    94,    78,   104,     0,    96,    75,    88,     0,    97,    76,    52,     0,   102,    72,    13,     0,   104,    68,     0, 
    0,   104,    66,     0,     0,   102,    62,     0,     0,    97,    49,   244,     1,   100,    47,   238,     4,   100,    46,   232,     8,   100,    45,   222,    13,    96,    43,   207, 
   12,    91,    43,   197,     9,    93,    45,   187,     0,    95,    51,   179,     0,    98,    55,   155,     0,    99,    62,   131,     0,    96,    66,   107,     0,    95,    66,    90, 
    0,    95,    65,    66,     0,    98,    61,    32,     0,   102,    56,     4,     0,   100,    55,     0,     0,    98,    54,     0,     0,   106,    36,   245,     0,   108,    34,   239, 
    2,   109,    33,   232,     4,   109,    33,   224,     5,   107,    33,   215,     4,   104,    34,   205,     2,   105,    36,   195,     0,   106,    37,   184,     0,   106,    36,   164, 
    0,   107,    39,   143,     0,   100,    45,   116,     0,    94,    49,    93,     0,    93,    48,    72,     0,    94,    47,    47,     0,    99,    44,    17,     0,   100,    42,     1, 
    0,    94,    43,     0,     0,   114,    23,   245,     0,   116,    20,   239,     0,   116,    19,   233,     0,   115,    20,   226,     0,   113,    22,   217,     0,   110,    23,   205, 
    0,   110,    23,   192,     0,   110,    23,   179,     0,   110,    22,   162,     0,   109,    23,   145,     0,   106,    25,   125,     0,   100,    29,    99,     0,    99,    28,    76, 
    0,   100,    28,    52,     0,   102,    28,    26,     0,   102,    25,     1,     0,    93,    29,     0,     0,   125,    12,   245,     0,   126,     9,   239,     0,   125,     7,   233, 
    0,   122,     7,   225,     0,   120,     8,   215,     0,   116,     8,   202,     0,   114,     9,   189,     0,   110,     8,   175,     0,   109,     8,   157,     0,   108,     8,   141, 
    0,   107,     8,   125,     0,   106,     8,   104,     0,   104,     8,    84,     0,   104,     8,    59,     0,   105,     8,    29,     0,   104,     8,     5,     0,    91,    15,     0, 
    0,   132,     0,   240,     0,   132,     0,   239,     0,   130,     0,   234,     0,   126,     0,   225,     0,   123,     0,   213,     0,   119,     0,   198,     0,   112,     0,   181, 
    0,   105,     0,   159,     0,    99,     0,   141,     0,    97,     0,   126,     0,    96,     0,   110,     0,    95,     0,    99,     0,    94,     0,    86,     0,    94,     0,    68, 
    0,    93,     0,    44,     0,    92,     0,    18,     0,    90,     0,     0,    15,     7,   213,   223,    15,     7,   213,   218,    16,     6,   214,   209,    15,     5,   217,   200, 
   14,     3,   220,   189,    14,     2,   222,   167,    14,     2,   225,   144,    14,     2,   227,   110,    15,     2,   228,    78,    15,     3,   229,    47,    15,     6,   230,    22, 
   14,    12,   231,     5,     9,    20,   230,     2,     5,    56,   220,     1,     3,    84,   212,     0,     0,   104,   205,     0,     0,   119,   200,     0,    14,    10,   207,   225, 
   15,    11,   205,   221,    15,    11,   206,   211,    14,    11,   208,   196,    13,     9,   209,   182,    13,     9,   209,   165,    13,     8,   211,   145,    13,     8,   212,   112, 
   14,     9,   209,    82,    15,    11,   207,    56,    14,    16,   205,    35,    14,    25,   202,    19,     7,    34,   204,     7,     0,    62,   202,     0,     0,    87,   196,     0, 
    0,   104,   193,     0,     0,   114,   194,     0,    12,    12,   199,   228,    14,    14,   198,   224,    17,    17,   198,   213,    16,    17,   199,   197,    14,    14,   200,   184, 
   14,    14,   199,   167,    14,    12,   200,   149,    14,    12,   200,   119,    15,    14,   197,    87,    15,    16,   195,    61,    15,    20,   193,    36,    12,    29,   194,    17, 
    5,    41,   194,     6,     0,    68,   191,     0,     0,    91,   187,     0,     0,   104,   184,     0,     0,   110,   188,     0,    13,    16,   189,   231,    14,    17,   188,   226, 
   16,    20,   188,   215,    17,    25,   184,   204,    17,    26,   184,   191,    15,    23,   186,   177,    14,    18,   189,   154,    14,    17,   189,   127,    16,    18,   187,    90, 
   17,    21,   184,    60,    17,    30,   184,    34,    11,    39,   184,    15,     3,    51,   186,     3,     0,    75,   181,     0,     0,    92,   176,     0,     0,   102,   172,     0, 
    0,   108,   178,     0,    14,    19,   175,   233,    16,    21,   175,   227,    17,    25,   175,   216,    17,    30,   168,   202,    19,    38,   162,   184,    18,    35,   168,   175, 
   16,    26,   175,   154,    15,    24,   177,   133,    17,    24,   175,    93,    17,    26,   172,    62,    18,    37,   171,    36,    10,    46,   175,    16,     3,    59,   175,     2, 
    0,    77,   170,     0,     0,    92,   164,     0,     0,   102,   161,     0,     0,   106,   166,     0,    15,    24,   159,   234,    17,    27,   157,   225,    18,    31,   155,   213, 
   18,    35,   154,   199,    18,    37,   152,   186,    19,    41,   154,   171,    17,    38,   158,   159,    15,    33,   161,   142,    16,    30,   161,   100,    17,    31,   159,    68, 
   17,    41,   159,    42,    11,    51,   162,    21,     4,    63,   163,     5,     0,    77,   159,     0,     0,    91,   153,     0,     0,   100,   150,     0,     0,   104,   154,     0, 
   14,    29,   146,   236,    17,    34,   144,   221,    20,    39,   141,   205,    20,    41,   142,   196,    18,    42,   144,   186,    18,    43,   145,   171,    16,    46,   146,   159, 
   13,    40,   150,   145,    14,    36,   151,   110,    17,    37,   148,    77,    15,    45,   149,    48,     9,    55,   151,    27,     0,    68,   154,    11,     0,    77,   150,     0, 
    0,    91,   142,     0,     0,   100,   140,     0,     0,   100,   142,     0,    13,    36,   132,   237,    15,    40,   133,   219,    17,    43,   131,   204,    18,    43,   132,   196, 
   18,    44,   132,   186,    17,    44,   133,   172,    16,    47,   134,   157,    12,    51,   137,   146,    12,    47,   138,   126,    14,    45,   137,    95,    13,    50,   137,    60, 
    7,    60,   141,    36,     0,    70,   143,    17,     0,    78,   139,     0,     0,    91,   133,     0,     0,    99,   127,     0,     0,    98,   129,     0,    11,    43,   115,   238, 
   13,    45,   118,   219,    16,    47,   115,   202,    17,    45,   116,   195,    17,    45,   118,   187,    18,    47,   118,   173,    17,    51,   120,   158,    12,    59,   122,   144, 
    7,    62,   122,   131,     7,    59,   125,   109,     8,    60,   126,    76,     2,    68,   130,    52,     0,    74,   130,    25,     0,    78,   126,     1,     0,    90,   121,     0, 
    0,    96,   115,     0,     0,    94,   113,     0,     9,    50,    99,   240,     9,    53,   104,   225,    13,    50,   102,   213,    15,    48,   102,   202,    17,    47,   102,   190, 
   17,    48,   102,   172,    10,    57,   104,   159,     7,    63,   108,   148,     1,    69,   110,   136,     0,    76,   107,   119,     0,    75,   110,    98,     0,    75,   112,    79, 
    0,    79,   110,    46,     0,    80,   110,     7,     0,    88,   106,     0,     0,    93,   102,     0,     0,    91,    99,     0,     3,    63,    86,   243,     6,    64,    84,   233, 
    9,    62,    84,   224,    13,    56,    84,   213,    17,    51,    84,   195,    13,    53,    88,   180,     7,    60,    92,   163,     9,    67,    91,   144,     4,    73,    95,   133, 
    0,    82,    95,   116,     0,    84,    93,   100,     0,    80,    95,    86,     0,    84,    94,    59,     0,    84,    93,    25,     0,    87,    90,     2,     0,    90,    86,     0, 
    0,    87,    84,     0,     0,    69,    70,   244,     5,    68,    66,   233,    10,    65,    62,   222,    17,    59,    60,   208,    15,    56,    63,   200,     0,    60,    77,   202, 
    0,    63,    78,   186,     0,    66,    79,   165,     0,    72,    80,   144,     0,    78,    80,   120,     0,    80,    80,   100,     0,    77,    80,    88,     0,    80,    79,    61, 
    0,    84,    76,    27,     0,    86,    72,     2,     0,    87,    68,     0,     0,    86,    67,     0,     0,    73,    51,   245,     0,    78,    51,   238,     4,    79,    49,   228, 
    5,    77,    49,   220,     0,    73,    50,   218,     2,    65,    46,   205,     5,    64,    44,   189,    12,    63,    43,   164,    10,    68,    47,   145,     3,    79,    59,   126, 
    0,    80,    64,   104,     0,    78,    64,    88,     0,    79,    61,    74,     0,    82,    60,    32,     0,    86,    54,     3,     0,    86,    52,     0,     0,    86,    48,     0, 
    0,    86,    36,   245,     0,    88,    36,   238,     0,    90,    36,   233,     0,    90,    38,   226,     0,    88,    38,   217,     0,    84,    38,   206,     0,    84,    39,   194, 
    0,    82,    40,   180,     0,    82,    40,   161,     0,    87,    43,   141,     0,    84,    46,   113,     0,    78,    47,    89,     0,    79,    47,    71,     0,    80,    45,    45, 
    0,    82,    43,    14,     0,    84,    40,     0,     0,    80,    40,     0,     0,    95,    25,   246,     0,    96,    21,   239,     0,    96,    21,   233,     0,    96,    22,   226, 
    0,    95,    23,   217,     0,    93,    24,   205,     0,    93,    25,   193,     0,    93,    25,   180,     0,    94,    26,   163,     0,    93,    26,   145,     0,    91,    26,   125, 
    0,    84,    29,    96,     0,    80,    31,    73,     0,    80,    31,    51,     0,    82,    30,    27,     0,    84,    26,     2,     0,    78,    28,     0,     0,   104,    13,   245, 
    0,   105,     9,   239,     0,   104,     9,   234,     0,   104,     8,   226,     0,   102,     9,   216,     0,    99,     9,   203,     0,    98,     9,   190,     0,    96,     9,   176, 
    0,    95,     9,   158,     0,    94,     9,   142,     0,    93,     9,   126,     0,    92,     9,   104,     0,    86,    13,    79,     0,    84,    13,    56,     0,    86,    14,    32, 
    0,    86,    13,     8,     0,    77,    14,     0,     0,   110,     0,   239,     0,   110,     0,   239,     0,   110,     0,   236,     0,   108,     0,   226,     0,   106,     0,   215, 
    0,   102,     0,   200,     0,    98,     0,   184,     0,    93,     0,   161,     0,    86,     0,   141,     0,    84,     0,   126,     0,    84,     0,   110,     0,    84,     0,    99, 
    0,    82,     0,    84,     0,    82,     0,    67,     0,    80,     0,    45,     0,    79,     0,    21,     0,    77,     0,     0,    11,     5,   215,   222,    12,     5,   215,   218, 
   11,     3,   217,   212,    11,     2,   219,   203,    10,     1,   222,   192,    10,     1,   223,   177,     9,     0,   225,   155,    10,     0,   227,   131,    11,     1,   228,    99, 
   11,     2,   229,    70,    11,     3,   231,    42,    12,     5,   232,    18,    11,     9,   233,     4,     7,    17,   232,     3,     4,    47,   221,     1,     1,    76,   212,     0, 
    0,    97,   205,     0,     9,     9,   209,   225,    10,    11,   206,   220,    10,     9,   207,   213,     9,     8,   209,   199,     9,     7,   209,   189,     9,     7,   209,   175, 
    9,     6,   212,   155,     9,     5,   212,   133,     9,     5,   212,   100,     9,     6,   211,    75,     9,     8,   208,    51,     9,    11,   207,    33,     9,    17,   205,    18, 
    5,    26,   205,     6,     0,    50,   202,     0,     0,    78,   198,     0,     0,    93,   198,     0,     9,    11,   202,   228,     9,    12,   200,   223,     9,    12,   200,   214, 
    9,    11,   201,   200,     9,     9,   201,   189,     8,     8,   200,   175,     8,     8,   201,   157,     8,     8,   200,   137,     9,     9,   200,   104,     9,     9,   198,    79, 
    9,    11,   197,    53,     9,    15,   196,    29,     7,    21,   196,    12,     1,    32,   195,     1,     0,    58,   191,     0,     0,    77,   189,     0,     0,    89,   191,     0, 
    7,    15,   192,   231,     8,    17,   190,   225,     9,    17,   190,   217,    10,    20,   189,   207,     9,    18,   188,   195,     8,    14,   189,   184,     8,    11,   190,   161, 
    9,    10,   190,   141,     9,    10,   190,   109,    10,    12,   189,    80,    10,    16,   188,    50,     9,    21,   188,    25,     4,    28,   188,     9,     0,    42,   186,     0, 
    0,    62,   181,     0,     0,    78,   177,     0,     0,    87,   181,     0,     7,    18,   181,   234,     7,    19,   179,   229,     9,    21,   179,   219,     9,    23,   177,   208, 
    9,    22,   176,   196,     9,    19,   178,   184,     8,    17,   180,   163,     9,    16,   179,   144,     9,    15,   179,   113,    11,    15,   177,    82,    11,    19,   176,    53, 
    9,    26,   178,    29,     4,    33,   178,    10,     0,    45,   175,     0,     0,    63,   168,     0,     0,    79,   164,     0,     0,    86,   168,     0,     6,    25,   166,   236, 
    7,    27,   163,   227,     9,    27,   162,   218,     9,    26,   162,   207,     9,    25,   163,   195,     9,    27,   163,   184,     9,    26,   163,   168,     9,    22,   165,   151, 
    9,    19,   166,   119,     9,    19,   164,    86,    10,    23,   163,    60,     9,    30,   164,    36,     4,    37,   166,    16,     0,    46,   163,     1,     0,    65,   157,     0, 
    0,    80,   152,     0,     0,    84,   156,     0,     6,    28,   153,   237,     8,    29,   151,   225,     9,    31,   150,   214,    10,    29,   150,   204,     9,    27,   151,   194, 
    9,    32,   149,   178,     9,    36,   149,   163,     7,    30,   152,   151,     8,    24,   154,   126,     9,    23,   152,    92,     9,    28,   151,    66,     7,    36,   153,    43, 
    3,    41,   155,    20,     0,    48,   153,     2,     0,    67,   146,     0,     0,    80,   141,     0,     0,    82,   143,     0,     3,    36,   141,   238,     8,    34,   139,   222, 
    9,    34,   137,   209,    10,    33,   138,   201,    11,    34,   139,   191,    10,    36,   140,   179,     9,    40,   141,   164,     6,    41,   141,   151,     5,    37,   142,   138, 
    5,    36,   143,   114,     4,    38,   142,    80,     4,    41,   143,    51,     0,    46,   146,    28,     0,    50,   143,     3,     0,    68,   135,     0,     0,    80,   127,     0, 
    0,    79,   130,     0,     1,    41,   129,   238,     9,    36,   126,   219,    11,    36,   123,   202,    10,    35,   125,   196,    12,    36,   123,   186,    10,    38,   125,   173, 
    9,    42,   126,   161,     4,    47,   129,   151,     2,    49,   127,   137,     4,    44,   130,   118,     3,    45,   131,    89,     0,    48,   133,    65,     0,    50,   133,    34, 
    0,    52,   131,     5,     0,    68,   122,     0,     0,    78,   115,     0,     0,    75,   113,     0,     1,    45,   112,   239,     7,    39,   110,   224,     9,    38,   109,   211, 
    8,    39,   112,   202,     9,    41,   113,   193,     7,    44,   114,   184,     8,    47,   114,   167,     4,    52,   116,   151,     0,    56,   114,   138,     0,    52,   114,   123, 
    0,    52,   115,   102,     0,    50,   116,    80,     0,    54,   118,    43,     0,    55,   114,    10,     0,    67,   107,     0,     0,    76,   102,     0,     0,    73,   100,     0, 
    0,    50,    96,   241,     4,    48,    93,   232,     7,    45,    93,   223,     6,    43,    98,   211,     5,    45,   100,   198,     2,    49,   100,   184,     0,    54,   102,   168, 
    0,    58,   102,   153,     0,    61,   102,   139,     0,    58,   100,   121,     0,    65,    96,   100,     0,    59,    98,    84,     0,    61,   100,    58,     0,    61,    97,    30, 
    0,    68,    93,     3,     0,    75,    89,     0,     0,    71,    88,     0,     0,    54,    79,   244,     0,    53,    75,   238,     0,    51,    77,   231,     2,    45,    82,   219, 
    0,    45,    84,   209,     0,    47,    86,   194,     0,    52,    86,   177,     0,    54,    86,   157,     0,    60,    86,   140,     0,    60,    86,   123,     0,    64,    80,    99, 
    0,    62,    80,    84,     0,    60,    82,    68,     0,    61,    82,    45,     0,    66,    78,     9,     0,    72,    73,     0,     0,    68,    73,     0,     0,    54,    57,   245, 
    4,    52,    51,   234,     8,    50,    47,   225,     8,    45,    47,   219,     4,    45,    50,   213,     0,    50,    59,   202,     0,    53,    62,   189,     0,    49,    68,   171, 
    0,    53,    68,   149,     0,    57,    68,   130,     0,    61,    67,   102,     0,    61,    65,    82,     0,    59,    65,    68,     0,    60,    64,    43,     0,    67,    59,     9, 
    0,    70,    55,     0,     0,    67,    53,     0,     0,    56,    37,   246,     0,    62,    36,   238,     0,    62,    36,   233,     0,    59,    35,   226,     0,    55,    33,   218, 
    0,    52,    34,   206,     6,    51,    35,   188,    17,    48,    39,   161,     9,    50,    44,   151,     1,    57,    47,   140,     0,    61,    49,   113,     0,    60,    47,    86, 
    0,    61,    46,    69,     0,    63,    45,    58,     0,    66,    41,    10,     0,    67,    38,     0,     0,    66,    35,     0,     0,    72,    25,   246,     0,    74,    22,   238, 
    0,    74,    22,   233,     0,    73,    22,   226,     0,    71,    23,   217,     0,    69,    23,   206,     0,    68,    24,   194,     0,    68,    26,   182,     0,    70,    26,   164, 
    0,    72,    26,   146,     0,    71,    27,   125,     0,    66,    28,    94,     0,    62,    31,    71,     0,    65,    31,    52,     0,    67,    29,    25,     0,    66,    26,     1, 
    0,    62,    26,     0,     0,    84,    14,   245,     0,    86,    10,   239,     0,    86,     9,   234,     0,    84,     9,   227,     0,    82,     9,   217,     0,    80,    10,   205, 
    0,    79,    10,   193,     0,    77,    10,   179,     0,    77,    11,   161,     0,    75,    11,   144,     0,    75,    10,   126,     0,    74,    10,   104,     0,    69,    14,    78, 
    0,    68,    13,    54,     0,    72,    13,    30,     0,    71,    13,     6,     0,    60,    14,     0,     0,    91,     0,   238,     0,    92,     0,   238,     0,    91,     0,   236, 
    0,    90,     0,   227,     0,    87,     0,   216,     0,    84,     0,   202,     0,    80,     0,   188,     0,    76,     0,   167,     0,    71,     0,   145,     0,    70,     0,   130, 
    0,    69,     0,   112,     0,    69,     0,    99,     0,    68,     0,    84,     0,    66,     0,    67,     0,    66,     0,    45,     0,    65,     0,    23,     0,    61,     0,     0, 
    8,     3,   218,   224,     8,     3,   218,   219,     8,     2,   220,   213,     7,     1,   222,   204,     7,     0,   224,   195,     6,     0,   224,   184,     6,     0,   226,   164, 
    7,     0,   227,   145,     7,     0,   229,   116,     7,     1,   230,    87,     8,     1,   231,    62,     8,     2,   232,    37,     8,     4,   234,    17,     9,     9,   233,     6, 
    5,    13,   233,     3,     2,    40,   222,     0,     0,    70,   214,     0,     6,     5,   213,   228,     6,     8,   209,   221,     6,     6,   209,   213,     5,     4,   213,   202, 
    4,     3,   213,   192,     4,     3,   213,   180,     4,     3,   213,   163,     4,     2,   213,   145,     5,     2,   213,   116,     6,     3,   213,    90,     6,     4,   212,    68, 
    6,     6,   211,    46,     5,     8,   209,    30,     5,    10,   208,    17,     3,    17,   207,     5,     0,    41,   204,     0,     0,    63,   205,     0,     3,    10,   204,   230, 
    5,    10,   201,   224,     5,     9,   201,   213,     5,     6,   202,   202,     4,     5,   202,   192,     4,     4,   201,   180,     4,     4,   201,   164,     4,     4,   201,   147, 
    4,     4,   201,   122,     5,     4,   200,    94,     5,     5,   199,    71,     5,     7,   198,    45,     4,     9,   198,    26,     3,    14,   198,     9,     1,    25,   195,     1, 
    0,    41,   194,     0,     0,    56,   196,     0,     3,     9,   195,   233,     4,    10,   193,   226,     5,    12,   192,   216,     5,    10,   192,   204,     3,     7,   192,   193, 
    3,     5,   191,   181,     3,     5,   191,   165,     3,     4,   190,   149,     4,     4,   191,   126,     5,     5,   190,    97,     5,     7,   190,    70,     5,     9,   189,    45, 
    4,    11,   189,    23,     2,    16,   189,     9,     0,    30,   186,     0,     0,    45,   182,     0,     0,    54,   188,     0,     1,    16,   184,   236,     4,    16,   184,   228, 
    5,    14,   182,   219,     4,    11,   184,   207,     3,     9,   184,   194,     3,     8,   182,   184,     3,     8,   181,   167,     3,     8,   181,   151,     4,     7,   181,   130, 
    5,     7,   181,   100,     6,     9,   180,    73,     5,    10,   179,    46,     3,    13,   180,    25,     2,    17,   178,     9,     0,    33,   173,     0,     0,    48,   170,     0, 
    0,    54,   176,     0,     2,    18,   172,   237,     3,    17,   171,   230,     4,    16,   170,   221,     4,    13,   171,   211,     3,    11,   172,   198,     3,    13,   170,   189, 
    3,    14,   167,   175,     3,    11,   168,   159,     4,     9,   170,   134,     6,     9,   170,   104,     5,     9,   167,    76,     3,    14,   167,    52,     2,    17,   168,    30, 
    0,    21,   167,    10,     0,    36,   161,     0,     0,    51,   156,     0,     0,    54,   162,     0,     1,    22,   159,   238,     2,    19,   157,   230,     4,    17,   157,   221, 
    4,    15,   157,   211,     3,    13,   158,   199,     3,    17,   156,   188,     2,    23,   152,   170,     2,    17,   156,   158,     2,    14,   158,   138,     2,    14,   159,   113, 
    0,    17,   159,    87,     0,    18,   158,    60,     1,    20,   157,    33,     0,    25,   156,    11,     0,    39,   150,     0,     0,    55,   143,     0,     0,    55,   148,     0, 
    1,    25,   147,   238,     4,    21,   144,   226,     5,    20,   142,   215,     4,    19,   143,   207,     3,    19,   144,   197,     3,    21,   142,   184,     3,    25,   141,   167, 
    2,    25,   143,   155,     1,    22,   145,   142,     1,    19,   146,   126,     1,    19,   146,    91,     0,    21,   146,    65,     0,    25,   147,    37,     0,    27,   145,    12, 
    0,    41,   139,     0,     0,    56,   131,     0,     0,    54,   133,     0,     1,    28,   134,   238,     3,    26,   132,   222,     2,    26,   129,   206,     2,    28,   130,   201, 
    3,    30,   131,   193,     3,    32,   132,   182,     1,    34,   134,   170,     0,    36,   132,   153,     0,    36,   131,   140,     0,    29,   134,   126,     0,    26,   135,   100, 
    0,    27,   134,    75,     0,    28,   134,    43,     0,    30,   133,    15,     0,    41,   126,     0,     0,    55,   116,     0,     0,    51,   115,     0,     0,    31,   118,   239, 
    2,    27,   118,   225,     3,    28,   118,   213,     2,    28,   118,   201,     2,    32,   118,   191,     1,    36,   119,   181,     0,    37,   120,   168,     0,    40,   121,   153, 
    0,    40,   118,   139,     0,    36,   116,   123,     0,    33,   119,   106,     0,    30,   119,    86,     0,    30,   119,    49,     0,    33,   118,    18,     0,    41,   110,     1, 
    0,    54,   104,     0,     0,    50,   102,     0,     0,    35,   102,   240,     1,    34,   100,   232,     1,    33,   102,   225,     0,    30,   104,   209,     0,    34,   104,   193, 
    0,    37,   106,   184,     0,    38,   105,   170,     0,    40,   106,   155,     0,    41,   108,   141,     0,    41,   100,   121,     0,    40,   100,   104,     0,    36,   102,    84, 
    0,    33,   102,    55,     0,    36,   104,    26,     0,    41,    98,     2,     0,    53,    91,     0,     0,    48,    91,     0,     0,    36,    84,   243,     0,    37,    84,   237, 
    0,    36,    84,   230,     0,    31,    90,   215,     0,    31,    91,   201,     0,    33,    91,   190,     0,    35,    90,   176,     0,    36,    91,   156,     0,    39,    88,   139, 
    0,    42,    87,   122,     0,    42,    86,   102,     0,    45,    80,    82,     0,    40,    84,    65,     0,    39,    86,    45,     0,    43,    82,    13,     0,    52,    77,     0, 
    0,    47,    77,     0,     0,    38,    67,   244,     0,    38,    64,   238,     0,    36,    63,   232,     0,    35,    64,   223,     0,    34,    66,   212,     0,    36,    70,   200, 
    0,    36,    72,   187,     0,    35,    75,   164,     0,    37,    74,   140,     0,    40,    71,   122,     0,    42,    70,   102,     0,    46,    64,    77,     0,    46,    63,    62, 
    0,    44,    67,    49,     0,    45,    65,    20,     0,    49,    61,     1,     0,    45,    61,     0,     0,    37,    45,   245,     5,    37,    38,   233,     5,    34,    36,   228, 
    7,    32,    35,   220,     3,    29,    36,   214,     0,    30,    40,   205,     0,    35,    47,   191,     0,    30,    53,   175,     0,    35,    55,   153,     0,    36,    53,   136, 
    0,    38,    52,   110,     0,    43,    49,    84,     0,    45,    48,    64,     0,    44,    49,    53,     0,    47,    47,    23,     0,    46,    42,     1,     0,    45,    40,     0, 
    0,    39,    26,   247,     0,    43,    21,   239,     0,    41,    19,   234,     0,    38,    17,   227,     0,    35,    17,   219,     0,    32,    17,   207,     1,    34,    19,   195, 
    2,    36,    22,   180,     0,    40,    26,   164,     0,    44,    28,   145,     0,    45,    29,   125,     0,    45,    30,    93,     0,    45,    31,    68,     0,    47,    33,    54, 
    0,    44,    30,    41,     0,    46,    24,     0,     0,    45,    22,     0,     0,    56,    14,   246,     0,    58,    11,   239,     0,    57,     9,   234,     0,    55,     9,   227, 
    0,    53,     9,   218,     0,    51,    10,   207,     0,    51,    10,   196,     0,    50,    11,   184,     0,    51,    12,   165,     0,    49,    13,   148,     0,    49,    12,   129, 
    0,    49,    12,   104,     0,    45,    14,    76,     0,    47,    15,    56,     0,    52,    11,    32,     0,    49,    13,     0,     0,    40,    15,     0,     0,    66,     0,   238, 
    0,    65,     0,   236,     0,    63,     0,   232,     0,    62,     0,   226,     0,    60,     0,   217,     0,    58,     0,   206,     0,    57,     0,   193,     0,    54,     0,   177, 
    0,    50,     0,   154,     0,    49,     0,   138,     0,    49,     0,   119,     0,    48,     0,   100,     0,    48,     0,    84,     0,    46,     0,    65,     0,    45,     0,    45, 
    0,    45,     0,    25,     0,    44,     0,     0,     3,     0,   222,   230,     3,     0,   222,   225,     3,     0,   222,   218,     3,     0,   224,   208,     3,     0,   225,   200, 
    3,     0,   225,   189,     2,     0,   227,   175,     3,     0,   228,   157,     3,     0,   229,   136,     3,     0,   230,   106,     3,     0,   232,    80,     3,     0,   233,    56, 
    3,     0,   234,    34,     3,     1,   236,    17,     4,     3,   236,     6,     2,     4,   236,     0,     0,    34,   224,     0,     2,     0,   217,   233,     2,     0,   213,   225, 
    2,     0,   213,   217,     1,     0,   215,   205,     1,     0,   215,   196,     0,     0,   215,   186,     0,     0,   215,   171,     0,     0,   215,   154,     1,     0,   215,   134, 
    1,     0,   215,   106,     2,     0,   215,    82,     2,     1,   215,    61,     2,     2,   214,    43,     2,     3,   213,    28,     2,     5,   212,    17,     1,    11,   212,     3, 
    0,    25,   214,     0,     0,     2,   207,   234,     1,     3,   204,   227,     1,     2,   203,   216,     0,     0,   204,   204,     0,     0,   204,   195,     0,     0,   203,   184, 
    0,     0,   203,   171,     0,     0,   203,   154,     0,     0,   202,   137,     0,     0,   202,   110,     1,     1,   201,    89,     1,     1,   201,    68,     1,     1,   201,    47, 
    1,     2,   200,    30,     2,     5,   199,    18,     1,    13,   198,     4,     0,    17,   203,     0,     0,     4,   197,   236,     1,     4,   195,   229,     1,     3,   194,   218, 
    0,     1,   193,   204,     0,     1,   193,   194,     0,     0,   192,   184,     0,     0,   191,   171,     0,     0,   191,   155,     0,     0,   191,   140,     0,     0,   192,   114, 
    0,     0,   192,    89,     1,     1,   192,    66,     1,     1,   191,    45,     0,     2,   190,    27,     1,     6,   189,    14,     1,    17,   187,     3,     0,    17,   194,     0, 
    0,     8,   187,   236,     1,     8,   186,   230,     1,     6,   186,   219,     1,     2,   184,   206,     0,     1,   184,   194,     0,     0,   184,   184,     0,     0,   182,   171, 
    0,     0,   182,   155,     0,     0,   182,   140,     0,     0,   184,   115,     0,     0,   184,    91,     0,     1,   182,    65,     1,     2,   181,    42,     0,     3,   180,    24, 
    1,     7,   179,    10,     0,    22,   175,     3,     0,    17,   182,     0,     0,    10,   176,   237,     1,     9,   175,   231,     1,     7,   175,   221,     1,     4,   175,   209, 
    0,     2,   173,   197,     0,     3,   171,   189,     0,     2,   170,   176,     0,     1,   170,   162,     0,     0,   171,   141,     0,     0,   172,   119,     0,     1,   172,    94, 
    0,     1,   171,    68,     0,     3,   170,    41,     0,     3,   167,    20,     0,     9,   166,     7,     0,    26,   159,     3,     0,    18,   167,     0,     0,    11,   162,   238, 
    1,     9,   162,   231,     2,     9,   161,   222,     1,     6,   162,   211,     0,     3,   162,   200,     0,     4,   159,   189,     0,     5,   158,   176,     0,     2,   159,   161, 
    0,     1,   159,   141,     0,     1,   159,   125,     0,     1,   159,    99,     0,     2,   159,    73,     0,     5,   158,    44,     0,     6,   156,    19,     0,    13,   153,     4, 
    0,    30,   148,     2,     0,    21,   152,     0,     0,    14,   151,   238,     0,    11,   151,   230,     0,    10,   150,   222,     0,     8,   150,   212,     0,     7,   149,   201, 
    0,     7,   149,   189,     0,     8,   148,   176,     0,     8,   147,   159,     0,     7,   147,   145,     0,     5,   148,   133,     0,     5,   148,   104,     0,     5,   147,    77, 
    0,     6,   146,    47,     0,     8,   145,    20,     0,    16,   142,     4,     0,    31,   136,     1,     0,    24,   138,     0,     0,    16,   139,   238,     0,    13,   138,   227, 
    0,    11,   137,   218,     0,     9,   137,   209,     0,     9,   137,   199,     0,    10,   137,   189,     0,    10,   137,   175,     0,    10,   134,   156,     0,    16,   132,   140, 
    0,     9,   135,   127,     0,     7,   137,   104,     0,     7,   134,    80,     0,     8,   134,    51,     0,     9,   133,    23,     0,    17,   131,     4,     0,    31,   121,     1, 
    0,    25,   121,     0,     0,    17,   123,   239,     0,    15,   125,   230,     0,    13,   125,   220,     0,    11,   125,   209,     0,    12,   123,   198,     0,    14,   123,   187, 
    0,    17,   123,   171,     0,    18,   125,   155,     0,    18,   119,   139,     0,    16,   119,   122,     0,    13,   121,   108,     0,    10,   120,    91,     0,     9,   119,    57, 
    0,    11,   119,    26,     0,    17,   116,     5,     0,    30,   107,     1,     0,    25,   107,     0,     0,    18,   106,   240,     0,    17,   105,   234,     0,    16,   106,   226, 
    0,    12,   108,   212,     0,    14,   108,   197,     0,    17,   107,   184,     0,    21,   107,   166,     0,    23,   107,   153,     0,    18,   105,   140,     0,    22,   104,   120, 
    0,    22,   102,   104,     0,    16,   105,    89,     0,    12,   104,    60,     0,    12,   105,    31,     0,    17,   104,     6,     0,    30,    95,     0,     0,    25,    95,     0, 
    0,    19,    90,   241,     0,    20,    89,   236,     0,    18,    90,   228,     0,    13,    93,   215,     0,    13,    93,   202,     0,    15,    93,   189,     0,    17,    93,   176, 
    0,    20,    93,   157,     0,    19,    90,   140,     0,    22,    91,   123,     0,    24,    89,   102,     0,    20,    89,    84,     0,    17,    89,    65,     0,    13,    90,    42, 
    0,    18,    91,    10,     0,    29,    82,     0,     0,    25,    82,     0,     0,    20,    74,   243,     0,    21,    71,   237,     0,    20,    71,   230,     0,    18,    73,   222, 
    0,    17,    75,   211,     0,    17,    76,   199,     0,    17,    76,   186,     0,    17,    78,   162,     0,    18,    75,   140,     0,    22,    75,   123,     0,    24,    75,   104, 
    0,    26,    72,    82,     0,    29,    68,    56,     0,    23,    71,    45,     0,    25,    75,    23,     0,    26,    68,     2,     0,    24,    67,     0,     0,    21,    53,   244, 
    0,    21,    49,   238,     0,    19,    49,   232,     0,    18,    49,   225,     0,    17,    50,   215,     0,    17,    52,   203,     0,    17,    55,   190,     0,    15,    60,   170, 
    0,    16,    60,   149,     0,    17,    60,   131,     0,    20,    58,   106,     0,    24,    56,    86,     0,    32,    49,    60,     0,    26,    51,    45,     0,    24,    56,    28, 
    0,    22,    54,     5,     0,    23,    47,     0,     0,    20,    32,   245,     2,    20,    26,   238,     2,    19,    25,   231,     1,    17,    25,   225,     0,    14,    26,   218, 
    0,    12,    26,   207,     0,    13,    26,   195,     0,    16,    30,   179,     0,    19,    34,   157,     0,    15,    37,   140,     0,    17,    36,   116,     0,    20,    36,    93, 
    0,    24,    34,    64,     0,    27,    34,    43,     0,    23,    37,    22,     0,    23,    32,     0,     0,    23,    28,     0,     0,    21,    15,   244,     0,    24,    11,   238, 
    0,    23,     9,   231,     0,    22,     9,   224,     1,    19,     9,   215,     1,    18,     9,   204,     1,    18,     9,   193,     0,    19,     9,   181,     0,    22,    13,   164, 
    0,    17,    17,   148,     0,    18,    17,   129,     0,    22,    17,   105,     0,    24,    17,    76,     0,    27,    17,    52,     0,    26,    14,    23,     0,    20,    14,    19, 
    0,    22,    11,     0,     0,    34,     0,   236,     0,    32,     0,   234,     0,    30,     0,   230,     0,    28,     0,   225,     0,    26,     0,   217,     0,    25,     0,   206, 
    0,    25,     0,   195,     0,    25,     0,   184,     0,    25,     0,   165,     0,    25,     0,   148,     0,    25,     0,   129,     0,    26,     0,   108,     0,    26,     0,    87, 
    0,    25,     0,    63,     0,    24,     0,    40,     0,    22,     0,    23,     0,    21,     0,     0,     0,     0,   224,   233,     0,     0,   224,   229,     0,     0,   225,   224, 
    0,     0,   226,   215,     0,     0,   225,   205,     0,     0,   226,   195,     0,     0,   227,   184,     0,     0,   227,   168,     0,     0,   228,   151,     0,     0,   229,   127, 
    0,     0,   231,   100,     0,     0,   232,    76,     0,     0,   233,    54,     0,     0,   236,    34,     0,     0,   236,    17,     0,     0,   237,     7,     0,     0,   238,     0, 
    0,     0,   217,   233,     0,     0,   216,   224,     0,     0,   217,   218,     0,     0,   217,   208,     0,     0,   217,   200,     0,     0,   216,   192,     0,     0,   217,   181, 
    0,     0,   217,   167,     0,     0,   217,   151,     0,     0,   218,   129,     0,     0,   219,   104,     0,     0,   220,    84,     0,     0,   220,    66,     0,     0,   220,    50, 
    0,     0,   220,    37,     0,     0,   221,    26,     0,     0,   221,     0,     0,     0,   207,   233,     0,     0,   207,   225,     0,     0,   206,   213,     0,     0,   206,   204, 
    0,     0,   206,   196,     0,     0,   205,   189,     0,     0,   205,   180,     0,     0,   205,   165,     0,     0,   205,   151,     0,     0,   205,   131,     0,     0,   206,   108, 
    0,     0,   206,    91,     0,     0,   206,    75,     0,     0,   206,    62,     0,     0,   205,    50,     0,     0,   205,    38,     0,     0,   206,     0,     0,     0,   197,   233, 
    0,     0,   199,   227,     0,     0,   197,   216,     0,     0,   195,   201,     0,     0,   194,   193,     0,     0,   194,   187,     0,     0,   193,   177,     0,     0,   193,   164, 
    0,     0,   193,   150,     0,     0,   194,   132,     0,     0,   195,   109,     0,     0,   195,    92,     0,     0,   195,    75,     0,     0,   195,    60,     0,     0,   195,    48, 
    0,     0,   195,    36,     0,     0,   194,     0,     0,     0,   188,   233,     0,     0,   189,   229,     0,     0,   189,   219,     0,     0,   187,   204,     0,     0,   184,   191, 
    0,     0,   184,   182,     0,     0,   184,   173,     0,     0,   184,   161,     0,     0,   184,   148,     0,     0,   184,   133,     0,     0,   186,   112,     0,     0,   186,    91, 
    0,     0,   186,    71,     0,     0,   186,    54,     0,     0,   186,    43,     0,     0,   184,    33,     0,     0,   182,     0,     0,     0,   176,   233,     0,     0,   178,   230, 
    0,     0,   178,   221,     0,     0,   177,   207,     0,     0,   175,   194,     0,     0,   173,   181,     0,     0,   173,   171,     0,     0,   172,   159,     0,     0,   172,   148, 
    0,     0,   172,   135,     0,     0,   173,   114,     0,     0,   175,    93,     0,     0,   173,    70,     0,     0,   172,    50,     0,     0,   172,    38,     0,     0,   171,    28, 
    0,     0,   167,     0,     0,     0,   163,   233,     0,     0,   166,   231,     0,     0,   166,   222,     0,     0,   165,   209,     0,     0,   164,   197,     0,     0,   163,   184, 
    0,     0,   162,   170,     0,     0,   162,   158,     0,     0,   161,   149,     0,     0,   159,   137,     0,     0,   159,   118,     0,     0,   161,    97,     0,     0,   159,    72, 
    0,     0,   158,    47,     0,     0,   157,    33,     0,     0,   156,    22,     0,     0,   153,     0,     0,     0,   151,   233,     0,     0,   153,   232,     0,     0,   154,   224, 
    0,     0,   154,   212,     0,     0,   153,   199,     0,     0,   153,   189,     0,     0,   153,   175,     0,     0,   151,   157,     0,     0,   151,   149,     0,     0,   149,   137, 
    0,     0,   147,   118,     0,     0,   147,    96,     0,     0,   145,    74,     0,     0,   144,    47,     0,     0,   143,    29,     0,     0,   141,    17,     0,     0,   140,     0, 
    0,     0,   140,   233,     0,     0,   140,   230,     0,     0,   141,   224,     0,     0,   142,   215,     0,     0,   142,   201,     0,     0,   141,   189,     0,     0,   141,   176, 
    0,     0,   141,   159,     0,     0,   139,   141,     0,     0,   138,   132,     0,     0,   136,   115,     0,     0,   133,    96,     0,     0,   130,    74,     0,     0,   129,    49, 
    0,     0,   127,    29,     0,     0,   126,    14,     0,     0,   125,     0,     0,     0,   125,   233,     0,     0,   125,   229,     0,     0,   126,   225,     0,     0,   129,   216, 
    0,     0,   130,   202,     0,     0,   127,   189,     0,     0,   123,   168,     0,     0,   121,   151,     0,     0,   122,   137,     0,     0,   127,   126,     0,     0,   123,   112, 
    0,     0,   122,    99,     0,     0,   118,    75,     0,     0,   115,    51,     0,     0,   114,    30,     0,     0,   113,    13,     0,     0,   110,     0,     0,     0,   106,   233, 
    0,     0,   106,   228,     0,     0,   108,   224,     0,     0,   110,   216,     0,     0,   112,   202,     0,     0,   109,   184,     0,     0,   100,   151,     0,     0,   100,   141, 
    0,     0,   108,   137,     0,     0,   104,   114,     0,     0,   100,    96,     0,     0,   106,    93,     0,     0,   104,    74,     0,     0,   102,    51,     0,     0,   102,    29, 
    0,     0,   100,    12,     0,     0,   100,     0,     0,     0,    90,   233,     0,     0,    90,   229,     0,     0,    92,   224,     0,     0,    93,   216,     0,     0,    97,   205, 
    0,     0,    97,   189,     0,     0,    95,   170,     0,     0,    94,   151,     0,     0,    93,   134,     0,     0,    93,   120,     0,     0,    87,    95,     0,     0,    89,    82, 
    0,     0,    91,    74,     0,     0,    90,    55,     0,     0,    89,    30,     0,     0,    88,    12,     0,     0,    87,     0,     0,     0,    73,   233,     0,     0,    73,   230, 
    0,     0,    74,   225,     0,     0,    76,   218,     0,     0,    80,   208,     0,     0,    80,   195,     0,     0,    82,   180,     0,     0,    82,   158,     0,     0,    80,   138, 
    0,     0,    78,   119,     0,     0,    75,    99,     0,     0,    69,    75,     0,     0,    69,    61,     0,     0,    75,    50,     0,     0,    75,    29,     0,     0,    75,    13, 
    0,     0,    74,     0,     0,     0,    53,   233,     0,     0,    54,   231,     0,     0,    55,   227,     0,     0,    58,   222,     0,     0,    60,   214,     0,     0,    62,   201, 
    0,     0,    62,   187,     0,     0,    64,   164,     0,     0,    63,   144,     0,     0,    64,   126,     0,     0,    57,    98,     0,     0,    57,    80,     0,     0,    50,    55, 
    0,     0,    54,    43,     0,     0,    57,    31,     0,     0,    57,    18,     0,     0,    56,     0,     0,     0,    34,   233,     0,     0,    34,   232,     0,     0,    35,   228, 
    0,     0,    36,   223,     0,     0,    37,   215,     0,     0,    39,   204,     0,     0,    39,   191,     0,     0,    40,   173,     0,     0,    41,   153,     0,     0,    44,   129, 
    0,     0,    43,   107,     0,     0,    39,    86,     0,     0,    36,    61,     0,     0,    31,    38,     0,     0,    35,    24,     0,     0,    38,    17,     0,     0,    37,     0, 
    0,     0,    16,   233,     0,     0,    16,   232,     0,     0,    16,   229,     0,     0,    17,   224,     0,     0,    18,   216,     0,     0,    19,   204,     0,     0,    19,   191, 
    0,     0,    18,   175,     0,     0,    19,   154,     0,     0,    21,   129,     0,     0,    20,   109,     0,     0,    19,    93,     0,     0,    19,    75,     0,     0,    18,    49, 
    0,     0,    18,    23,     0,     0,    17,    11,     0,     0,    18,     0,     0,     0,     0,   234,     0,     0,     0,   230,     0,     0,     0,   226,     0,     0,     0,   221, 
    0,     0,     0,   213,     0,     0,     0,   202,     0,     0,     0,   192,     0,     0,     0,   179,     0,     0,     0,   163,     0,     0,     0,   147,     0,     0,     0,   130, 
    0,     0,     0,   106,     0,     0,     0,    84,     0,     0,     0,    56,     0,     0,     0,    29,     0,     0,     0,    14,     0,     0,     0,     0
};

APDK_END_NAMESPACE

#endif

