/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jhotdraw.application.DrawApplication;
import org.jhotdraw.contrib.Desktop;
import org.jhotdraw.contrib.DesktopEventService;
import org.jhotdraw.contrib.DesktopListener;
import org.jhotdraw.framework.DrawingView;

public class JPanelDesktop
extends JPanel
implements Desktop {
    private DesktopEventService myDesktopEventService;
    private DrawApplication myDrawApplication;

    public JPanelDesktop(DrawApplication drawApplication) {
        this.setDrawApplication(drawApplication);
        this.setDesktopEventService(this.createDesktopEventService());
        this.setAlignmentX(0.0f);
        this.setLayout(new BorderLayout());
    }

    protected Component createContents(DrawingView drawingView) {
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)drawingView));
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setAlignmentX(0.0f);
        String string = drawingView.drawing().getTitle() == null ? this.getDrawApplication().getApplicationName() + " - " + this.getDrawApplication().getDefaultDrawingTitle() : this.getDrawApplication().getApplicationName() + " - " + drawingView.drawing().getTitle();
        jScrollPane.setName(string);
        return jScrollPane;
    }

    public DrawingView getActiveDrawingView() {
        return this.getDesktopEventService().getActiveDrawingView();
    }

    public void addToDesktop(DrawingView drawingView, int n) {
        this.getDesktopEventService().addComponent(this.createContents(drawingView));
        this.getContainer().validate();
    }

    public void removeFromDesktop(DrawingView drawingView, int n) {
        this.getDesktopEventService().removeComponent(drawingView);
        this.getContainer().validate();
    }

    public void removeAllFromDesktop(int n) {
        this.getDesktopEventService().removeAllComponents();
        this.getContainer().validate();
    }

    public DrawingView[] getAllFromDesktop(int n) {
        return this.getDesktopEventService().getDrawingViews(this.getComponents());
    }

    public void addDesktopListener(DesktopListener desktopListener) {
        this.getDesktopEventService().addDesktopListener(desktopListener);
    }

    public void removeDesktopListener(DesktopListener desktopListener) {
        this.getDesktopEventService().removeDesktopListener(desktopListener);
    }

    private Container getContainer() {
        return this;
    }

    protected DesktopEventService getDesktopEventService() {
        return this.myDesktopEventService;
    }

    private void setDesktopEventService(DesktopEventService desktopEventService) {
        this.myDesktopEventService = desktopEventService;
    }

    protected DesktopEventService createDesktopEventService() {
        return new DesktopEventService(this, this.getContainer());
    }

    private void setDrawApplication(DrawApplication drawApplication) {
        this.myDrawApplication = drawApplication;
    }

    protected DrawApplication getDrawApplication() {
        return this.myDrawApplication;
    }

    public void updateTitle(String string) {
        this.setName(string);
    }
}

