ADD_DEFINITIONS(-DBUILDING_WITH_CMAKE=1)
ADD_DEFINITIONS(-DHAVE_CONFIG_H=1)

IF (WTF_OS_UNIX)
    ADD_DEFINITIONS(-DXP_UNIX)
    #TODO: check for X11 target
    ADD_DEFINITIONS(-DMOZ_X11) 
ENDIF (WTF_OS_UNIX)

# CODE_GENERATOR_PREPROCESSOR_WITH_LINEMARKERS only matters with GCC >= 4.7.0.  Since this
# version, -P does not output empty lines, which currently breaks make_names.pl in
# WebCore. Investigating whether make_names.pl should be changed instead is left as an exercise to
# the reader.
IF (MSVC)
    # FIXME: Some codegenerators don't support paths with spaces. So use the executable name only.
    GET_FILENAME_COMPONENT(CODE_GENERATOR_PREPROCESSOR_EXECUTABLE ${CMAKE_CXX_COMPILER} NAME)
    SET(CODE_GENERATOR_PREPROCESSOR "${CODE_GENERATOR_PREPROCESSOR_EXECUTABLE} /nologo /EP")
    SET(CODE_GENERATOR_PREPROCESSOR_WITH_LINEMARKERS "${CODE_GENERATOR_PREPROCESSOR}")
ELSEIF (CMAKE_SYSTEM_NAME MATCHES QNX)
    SET(CODE_GENERATOR_PREPROCESSOR "${CMAKE_CXX_COMPILER} -E -Wp,-P -x c++")
    SET(CODE_GENERATOR_PREPROCESSOR_WITH_LINEMARKERS "${CODE_GENERATOR_PREPROCESSOR}")
ELSE ()
    SET(CODE_GENERATOR_PREPROCESSOR "${CMAKE_CXX_COMPILER} -E -P -x c++")
    SET(CODE_GENERATOR_PREPROCESSOR_WITH_LINEMARKERS "${CMAKE_CXX_COMPILER} -E -x c++")
ENDIF ()

SET_PROPERTY(GLOBAL PROPERTY USE_FOLDERS ON)

STRING(TOLOWER ${CMAKE_HOST_SYSTEM_PROCESSOR} LOWERCASE_CMAKE_HOST_SYSTEM_PROCESSOR)
IF ("${CMAKE_CXX_COMPILER_ID}" STREQUAL "GNU" AND "${LOWERCASE_CMAKE_HOST_SYSTEM_PROCESSOR}" MATCHES "(i[3-6]86|x86)" AND "${CMAKE_BUILD_TYPE}" STREQUAL "Debug")
    # To avoid out of memory when building with debug option in 32bit system.
    # See https://bugs.webkit.org/show_bug.cgi?id=77327
    SET(CMAKE_SHARED_LINKER_FLAGS "-Wl,--no-keep-memory ${CMAKE_SHARED_LINKER_FLAGS}")
ENDIF ()

SET(LIB_SUFFIX "" CACHE STRING "Define suffix of directory name (32/64)")

SET(LIB_INSTALL_DIR "lib${LIB_SUFFIX}" CACHE PATH "Where to install libraries (lib${LIB_SUFFIX})")
SET(EXEC_INSTALL_DIR "bin" CACHE PATH "Where to install executables")
