/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.InstanceProfileDelRequest;
import com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.GetInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.Role;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMInstanceProfileDelDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMInstanceProfileDelDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof InstanceProfileDelRequest) {
            InstanceProfileDelRequest delRequest = (InstanceProfileDelRequest)request;
            LOG.debug((Object)("Deleting Instance Profile: " + delRequest));
            boolean noop = delRequest.isNoop();
            if (delRequest.getInstanceProfileName() == null) {
                Utils.exit(1, "no Instance Profile name has been passed in.", null);
            }
            if (delRequest.isRecursive()) {
                GetInstanceProfileRequest iipGetAttributesRequest = new GetInstanceProfileRequest();
                iipGetAttributesRequest.setInstanceProfileName(delRequest.getInstanceProfileName());
                GetInstanceProfileResult iipGetResult = this.getClient().getInstanceProfile(iipGetAttributesRequest);
                if (iipGetResult.getInstanceProfile().getRoles() != null && !iipGetResult.getInstanceProfile().getRoles().isEmpty()) {
                    if (noop) {
                        LOG.info((Object)"roles");
                        for (Role role : iipGetResult.getInstanceProfile().getRoles()) {
                            LOG.info((Object)("\t" + role.getArn()));
                        }
                    } else {
                        LOG.debug((Object)"Removing roles from instance profiles");
                        RemoveRoleFromInstanceProfileRequest roleRemoveRequest = new RemoveRoleFromInstanceProfileRequest();
                        roleRemoveRequest.setInstanceProfileName(delRequest.getInstanceProfileName());
                        for (Role role : iipGetResult.getInstanceProfile().getRoles()) {
                            roleRemoveRequest.setRoleName(role.getRoleName());
                            LOG.debug((Object)("Removing role " + role.getRoleName()));
                            this.getClient().removeRoleFromInstanceProfile(roleRemoveRequest);
                        }
                    }
                }
            }
            if (!noop) {
                DeleteInstanceProfileRequest iipDeleteRequest = new DeleteInstanceProfileRequest();
                iipDeleteRequest.setInstanceProfileName(delRequest.getInstanceProfileName());
                this.getClient().deleteInstanceProfile(iipDeleteRequest);
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

