/*###############################################################################
# Linux Management Providers (LMP), Base_Server provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_COMPUTERSYSTEMACCESS_H_
#define OPENDRIM_COMPUTERSYSTEMACCESS_H_

#include "Base_Server_Common.h"

#include "OpenDRIM_ComputerSystem.h"

int Base_Server_OpenDRIM_ComputerSystem_load(const CMPIBroker* broker, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_unload(string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ComputerSystem>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Base_Server_OpenDRIM_ComputerSystem_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ComputerSystem& instance, const char** properties, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystem& newInstance, const OpenDRIM_ComputerSystem& oldInstance, const char** properties, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystem& instance, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystem& instance, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystem& instance, unsigned int& returnValue, const OpenDRIM_ComputerSystem_RequestStateChange_In& in, OpenDRIM_ComputerSystem_RequestStateChange_Out& out, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystem& instance, unsigned int& returnValue, const OpenDRIM_ComputerSystem_SetPowerState_In& in, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_getDedicated(const OpenDRIM_ComputerSystem& instance, vector<unsigned short>& Dedicated, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_setDedicated(const OpenDRIM_ComputerSystem& instance, const vector<unsigned short>& Dedicated, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_getOtherDedicatedDescriptions(const OpenDRIM_ComputerSystem& instance, vector<string>& OtherDedicatedDescriptions, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_setOtherDedicatedDescriptions(const OpenDRIM_ComputerSystem& instance, const vector<string>& OtherDedicatedDescriptions, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_getOtherIdentifyingInfo(const OpenDRIM_ComputerSystem& instance, vector<string>& OtherIdentifyingInfo, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_setOtherIdentifyingInfo(const OpenDRIM_ComputerSystem& instance, const vector<string>& OtherIdentifyingInfo, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystem_populate(OpenDRIM_ComputerSystem& instance, string& errorMessage);

#endif /*OPENDRIM_COMPUTERSYSTEMACCESS_H_*/
