/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_BootLogicalIdentityAccess.h"

int Boot_OpenDRIM_BootLogicalIdentity_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Boot_CIM_ManagedElement_load(broker, errorMessage));
	CF_assert(Boot_CIM_ManagedElement_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootLogicalIdentity_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Boot_CIM_ManagedElement_unload(errorMessage));
	CF_assert(Boot_CIM_ManagedElement_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootLogicalIdentity_isAssociated(const Instance& SystemElement, const Instance& SameElement, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootLogicalIdentity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BootLogicalIdentity>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(Boot_OpenDRIM_BootLogicalIdentity_enumerateSystemElements(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(Boot_OpenDRIM_BootLogicalIdentity_enumerateSystemElements(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		Boot_OpenDRIM_BootLogicalIdentity_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			SystemElement_classnames[0], SameElement_classnames[0],
			SystemElement_role.c_str(), SameElement_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(Boot_OpenDRIM_BootLogicalIdentity_referenceSystemElementToSameElement(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootLogicalIdentity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BootLogicalIdentity& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath SystemElement_objectpath;
	instance.getSystemElement(SystemElement_objectpath);
	Instance SystemElement_instance;
	CF_assert(Boot_OpenDRIM_BootLogicalIdentity_getSystemElement(broker, ctx, SystemElement_objectpath, SystemElement_instance, NULL, errorMessage));
	
	Objectpath SameElement_objectpath;
	instance.getSameElement(SameElement_objectpath);
	Instance SameElement_instance;
	CF_assert(Boot_OpenDRIM_BootLogicalIdentity_getSameElement(broker, ctx, SameElement_objectpath, SameElement_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(Boot_OpenDRIM_BootLogicalIdentity_isAssociated(SystemElement_instance, SameElement_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootLogicalIdentity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootLogicalIdentity& newInstance, const OpenDRIM_BootLogicalIdentity& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootLogicalIdentity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootLogicalIdentity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootLogicalIdentity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootLogicalIdentity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootLogicalIdentity_associatorSystemElementToSameElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SystemElement_instance, const char** properties, vector<Instance>& SameElement_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> SameElement_instances;
	if (discriminant=="a")
		CF_assert(Boot_OpenDRIM_BootLogicalIdentity_enumerateSameElements(broker, ctx, SameElement_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Boot_OpenDRIM_BootLogicalIdentity_enumerateSameElements(broker, ctx, SameElement_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Boot_OpenDRIM_BootLogicalIdentity_enumerateSameElements(broker, ctx, SameElement_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<SameElement_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Boot_OpenDRIM_BootLogicalIdentity_isAssociated(SystemElement_instance, SameElement_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			SameElement_associatedInstances.push_back(SameElement_instances[i]);
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootLogicalIdentity_associatorSameElementToSystemElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SameElement_instance, const char** properties, vector<Instance>& SystemElement_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> SystemElement_instances;
	if (discriminant=="a")
		CF_assert(Boot_OpenDRIM_BootLogicalIdentity_enumerateSystemElements(broker, ctx, SystemElement_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Boot_OpenDRIM_BootLogicalIdentity_enumerateSystemElements(broker, ctx, SystemElement_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Boot_OpenDRIM_BootLogicalIdentity_enumerateSystemElements(broker, ctx, SystemElement_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<SystemElement_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Boot_OpenDRIM_BootLogicalIdentity_isAssociated(SystemElement_instances[i], SameElement_instance, isAssociated, errorMessage));
		if (isAssociated)
			SystemElement_associatedInstances.push_back(SystemElement_instances[i]);
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootLogicalIdentity_referenceSystemElementToSameElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SystemElement_instance, const vector<Instance>& SameElement_instances, vector<OpenDRIM_BootLogicalIdentity>& OpenDRIM_BootLogicalIdentity_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < SameElement_instances.size(); i++) {
		OpenDRIM_BootLogicalIdentity instance;
		instance.setSystemElement(((Instance) SystemElement_instance).getObjectpath());
		instance.setSameElement(((Instance) SameElement_instances[i]).getObjectpath());
		
		OpenDRIM_BootLogicalIdentity_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootLogicalIdentity_referenceSameElementToSystemElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SameElement_instance, const vector<Instance>& SystemElement_instances, vector<OpenDRIM_BootLogicalIdentity>& OpenDRIM_BootLogicalIdentity_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < SystemElement_instances.size(); i++) {
		OpenDRIM_BootLogicalIdentity instance;
		instance.setSystemElement(((Instance) SystemElement_instances[i]).getObjectpath());
		instance.setSameElement(((Instance) SameElement_instance).getObjectpath());
		
		OpenDRIM_BootLogicalIdentity_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootLogicalIdentity_populate(OpenDRIM_BootLogicalIdentity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

