/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#include "OpenDRIM_AccountManagementServiceAccess.h"
#include "OpenDRIM_AccountAccess.h"
#include "cmpiOpenDRIM_Account.h"

string SystemName;
const string Name="shadow-utils";
const string CreationClassName="OpenDRIM_AccountManagementService";
const string SystemCreationClassName="OpenDRIM_ComputerSystem";

int Simple_Identity_Management_OpenDRIM_AccountManagementService_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(SystemName, errorMessage));
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_AccountManagementService_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_AccountManagementService_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_AccountManagementService>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	// Only one instance
	// The key properties are based on the system name
	OpenDRIM_AccountManagementService instance;
	instance.setCreationClassName(CreationClassName);
	instance.setSystemCreationClassName(SystemCreationClassName);
	instance.setSystemName(SystemName);
	instance.setName(Name);
	
	if(discriminant=="ei")
		CF_assert(Simple_Identity_Management_OpenDRIM_AccountManagementService_populate(instance,errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_AccountManagementService_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_AccountManagementService& instance, const char** properties, string& errorMessage) {
	_E_;
	// Only one instance
	// The key properties are based on the system name
	if (instance.CreationClassName!=CreationClassName ||
			instance.SystemCreationClassName!=SystemCreationClassName ||
			instance.SystemName!=SystemName ||
			instance.Name!=Name)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	
	CF_assert(Simple_Identity_Management_OpenDRIM_AccountManagementService_populate(instance,errorMessage));
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_AccountManagementService_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& newInstance, const OpenDRIM_AccountManagementService& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_AccountManagementService_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_AccountManagementService_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_AccountManagementService_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, unsigned int& returnValue, const OpenDRIM_AccountManagementService_RequestStateChange_In& in, OpenDRIM_AccountManagementService_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_AccountManagementService_StartService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_AccountManagementService_StopService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_AccountManagementService_ChangeAffectedElementsAssignedSequence(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, unsigned int& returnValue, const OpenDRIM_AccountManagementService_ChangeAffectedElementsAssignedSequence_In& in, OpenDRIM_AccountManagementService_ChangeAffectedElementsAssignedSequence_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_AccountManagementService_CreateAccount(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementService& instance, unsigned int& returnValue, const OpenDRIM_AccountManagementService_CreateAccount_In& in, OpenDRIM_AccountManagementService_CreateAccount_Out& out, string& errorMessage) {
	_E_;
	// AccountTemplate must be null
	string AccountTemplate;
	if (in.getAccountTemplate(AccountTemplate)!=NOT_FOUND) {
		returnValue=32768;
		return OK;
	}
	// System must exist and point the the OpenDRIM_ComputerSystem unique instance
	Objectpath System;
	if (in.getSystem(System)==NOT_FOUND) {
		// let's do nothing...
		//returnValue=32769;
		//return OK;
	} else {
		string creationClassName, name;
		if (System.getKey("CreationClassName",creationClassName)!=OK) {
			errorMessage="Wrong value (null): System.CreationClassName";
			return FAILED;
		}
		if (System.getKey("Name",name)!=OK) {
			errorMessage="Wrong value (null): System.Name";
			return FAILED;
		}
		if ((!CF_strCmpNoCase(creationClassName, "OpenDRIM_ComputerSystem") && !CF_strCmpNoCase(creationClassName, "CIM_ComputerSystem")) || !CF_strCmpNoCase(name, SystemName)) {
			returnValue=32769;
			return OK;
		}
	}
	// The account objectpath must be valid.
	// We check the different keys.
	Objectpath Account;
	if (in.getAccount(Account)==NOT_FOUND) {
		returnValue=32770;
		return OK;
	}
	string systemCreationClassName, systemName, creationClassName, name;
	if (Account.getKey("SystemCreationClassName", systemCreationClassName)!=OK) {
		errorMessage="Wrong value (null): Account.SystemCreationClassName";
		return FAILED;
	}
	if (Account.getKey("SystemName", systemName)!=OK) {
		errorMessage="Wrong value (null): Account.SystemName";
		return FAILED;
	}
	if (Account.getKey("Name", name)!=OK) {
		errorMessage="Wrong value (null): Account.Name";
		return FAILED;
	}
	if (Account.getKey("CreationClassName", creationClassName)!=OK) {
		errorMessage="Wrong value (null): Account.CreationClassName";
		return FAILED;
	}
	if (!CF_strCmpNoCase(systemName, SystemName) || !CF_strCmpNoCase(creationClassName, "OpenDRIM_Account") || (!CF_strCmpNoCase(systemCreationClassName, "OpenDRIM_ComputerSystem") && !CF_strCmpNoCase(systemCreationClassName, "CIM_ComputerSystem"))) {
		returnValue=32770;
		return OK;
	}
	OpenDRIM_Account account_instance;
	Simple_Identity_Management_OpenDRIM_Account_toCPP(broker, Account.getHdl(), account_instance);
	// Check if the account already exists
	int errorCode=Simple_Identity_Management_OpenDRIM_Account_getInstance(broker, ctx, account_instance, NULL, errorMessage);
	if (errorCode==OK) {
		returnValue=32771;
		return OK;
	}
	string stdOut, stdErr;
	// If everything is ok we created the account using useradd
	errorCode=CF_runCommand("/usr/sbin/useradd "+name, stdOut, stdErr, errorMessage);
	if (errorCode!=OK) {
		returnValue=2;
		return OK;
	}
	returnValue=0;
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_AccountManagementService_populate(OpenDRIM_AccountManagementService& instance, string& errorMessage) {
	_E_;
	instance.setRequestedState(12);
	instance.setEnabledState(2);
	instance.setElementName("shadow tool suite");
	_L_;
	return OK;
}

