/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.SqlException;

public class BlobLocatorOutputStream
extends OutputStream {
    private final Connection connection;
    private final Blob blob;
    private long currentPos;

    public BlobLocatorOutputStream(Connection connection, Blob blob, long l) throws SqlException {
        if (l - 1L > blob.sqlLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.connection = connection;
        this.blob = blob;
        this.currentPos = l;
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.writeBytes(byArray);
    }

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray2 = byArray;
        if (n > 0 || n2 < byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        this.writeBytes(byArray2);
    }

    private void writeBytes(byte[] byArray) throws IOException {
        try {
            this.blob.setBytesX(this.currentPos, byArray, 0, byArray.length);
            this.currentPos += (long)byArray.length;
        }
        catch (SqlException sqlException) {
            IOException iOException = new IOException();
            iOException.initCause(sqlException);
            throw iOException;
        }
    }
}

