//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>.



// funzione iniziale che automaticamente aggiorna il display al primo avvio
void acetoneiso::initial_get_database()
{
		QDir Home = QDir::home();
		QFile file(Home.path() + "/.acetoneiso/acetoneiso.conf");
		file.open(QIODevice::ReadOnly);//lo apro in sola lettura
		QByteArray utf = (leggiRigo( 4, &file ));
		QString strd = QString::fromUtf8(utf);
		strd.remove(0,5);
		strd.chop(1);
		
		listWidget->clear();

		//a questo punto mi ritrovo a linea 5 che corrisponde al settaggio database ricorsione
		QTextStream in(&file);
		QString str1 = in.readLine();
		QDirIterator *it;
		
		
		if (str1.contains("yesrecursive", Qt::CaseInsensitive)) {
		   it = new QDirIterator(strd, QDir::Files, QDirIterator::Subdirectories);
		}
		else {
		   it = new QDirIterator(strd, QDir::Files, QDirIterator::NoIteratorFlags);
		}
		
		
		int position = 1;
		while (it->hasNext() ) {		  
		QString scan_file = it->next();

		QFileInfo getinfo(scan_file);
		QString ext = getinfo.suffix(); 
		  
		if ( (ext.compare("iso",Qt::CaseInsensitive) == 0) | (ext.compare("nrg",Qt::CaseInsensitive) == 0) |   (ext.compare("bin",Qt::CaseInsensitive) == 0) | (ext.compare("img",Qt::CaseInsensitive) == 0) | (ext.compare("mdf",Qt::CaseInsensitive) == 0) )
		  {
		    //qDebug() << strd;
		    scan_file = scan_file.replace(strd + "/", "");
		    //qDebug() << scan_file;
		    listWidget->insertItem(position, scan_file );
		    position = position + 1 ;
		    
		  }
		  
		}
		
		file.close();
			
database_label();		
}

// funzione che monta l'immagine dal database con doppio click
void acetoneiso::mdatabase(QListWidgetItem *item)
{
QDir Home = QDir::home();
QFile file(Home.path() + "/.acetoneiso/acetoneiso.conf");
file.open(QIODevice::ReadOnly);//lo apro in sola lettura
QByteArray utf = (leggiRigo( 4, &file ));
QString strd = QString::fromUtf8(utf);
strd.remove(0,5);
strd.chop(1);
//controllo che se strd finisce con / allora si deve togliere.
if( strd.endsWith( "/" ) ) {
   strd.chop(1);
   }
QString isodamontare = (strd + "/"+ (item->text()));//da ora ho in isodamontare il file con tutto il suo percorso.


//controllo che esiste il file
QFile image_exists(isodamontare);
if (!image_exists.exists()) {
  QMessageBox::critical(this, "AcetoneISO",tr("The image ") + isodamontare  + tr(" doesn't exist.\nI'll remove it from database display."));
  int riga = listWidget->currentRow() ;
  listWidget->takeItem( riga  );
  file.close();
  return;
}

immagine_con_percorso = isodamontare; 
global_functions_mount(immagine_con_percorso);

file.close();
}



//funzione che cancella le immagini dal database. la rimozione non è visiva ma fisica.
void acetoneiso::remove_fromDatabase()
{
if ( !listWidget->currentItem() == 0 )
	{
QDir Home = QDir::home();
QFile file(Home.path() + "/.acetoneiso/acetoneiso.conf");
file.open(QIODevice::ReadOnly);//lo apro in sola lettura
QByteArray utf = (leggiRigo( 4, &file ));
QString strd = QString::fromUtf8(utf);
strd.remove(0,5);
strd.chop(1);
//controllo che se strd finisce con / allora si deve togliere.
if( strd.endsWith( "/" ) ) {
   strd.chop(1);
   }
	QDir datfolder( strd );//dichiaro la directory del database

	QString oggetto(strd + "/" + listWidget->currentItem()->text() );//immagine selezionata 
	
	QFile immagine_corrente( oggetto );

QMessageBox msgBox;
msgBox.setText(tr("You are about to delete ") + oggetto + (" ") + tr("\nAre You sure?"));
QPushButton *connectButton = msgBox.addButton(tr("Yes"), QMessageBox::ActionRole);
QPushButton *connectButton2 = msgBox.addButton(tr("No way!"), QMessageBox::ActionRole);
//msgBox.setStandardButtons(QMessageBox::("ISO File") | QMessageBox::("CD/DVD"));
msgBox.exec();
 if (msgBox.clickedButton() == connectButton) {
	int riga = listWidget->currentRow() ;
	listWidget->takeItem( riga  );

	immagine_corrente.remove();
	}
 else if (msgBox.clickedButton() == connectButton2) {

}

	}
else
QMessageBox::warning(this, "AcetoneISO::Warning",tr( "select an image to delete" ));
}



//monta dal context menu
void acetoneiso::menuMount()
{
QDir Home = QDir::home();
QFile file(Home.path() + "/.acetoneiso/acetoneiso.conf");
file.open(QIODevice::ReadOnly);//lo apro in sola lettura
QByteArray utf = (leggiRigo( 4, &file ));
QString strd = QString::fromUtf8(utf);
strd.remove(0,5);
strd.chop(1);
//controllo che se strd finisce con / allora si deve togliere.
if( strd.endsWith( "/" ) ) {
   strd.chop(1);
   }
QString isodamontare = (strd + "/" + fileDaMontare );

QFile image_exists(isodamontare);
if (!image_exists.exists()) {
  QMessageBox::critical(this, "AcetoneISO",tr("The image ") + isodamontare  + tr(" doesn't exist.\nI'll remove it from database display."));
  int riga = listWidget->currentRow() ;
  listWidget->takeItem( riga  );
  file.close();
  return;
}
immagine_con_percorso = isodamontare; 
global_functions_mount(immagine_con_percorso);
file.close();
}


//gestisce context menu del database
void acetoneiso::userListMenuRequested(const QPoint & pos)
{
QIcon mount_icon( ":/images/cdwriter_mount.png" );
QIcon delete_icon( ":/images/edit-delete.png" );
QIcon extract_icon( ":/images/extract.png" );

QMenu *userListMenu;
userListMenu = new QMenu();
QAction *mountAction = userListMenu->addAction( mount_icon,   tr("mount") );
QAction *deleteAction = userListMenu->addAction( delete_icon,  tr("delete") );
QAction *extractAction = userListMenu->addAction( extract_icon, tr("extract") );

    QPoint globalPos = listWidget->mapToGlobal(pos);    // Map the global position to the userlist
    QModelIndex t = listWidget->indexAt(pos);
    connect( mountAction,    SIGNAL( triggered() ), this, SLOT( menuMount() ) ); 
    connect( deleteAction,   SIGNAL( triggered() ), this, SLOT( remove_fromDatabase() ) );
    connect( extractAction,  SIGNAL( triggered() ), this, SLOT( contextExtract() ) );

    if( t.row() >= 0 ) { //previene un segfault se clicco col destro sullo spazio vuoto
       listWidget->item(t.row())->setSelected(true);         // even a right click will select the item
       fileDaMontare.clear();
       fileDaMontare = listWidget->item(t.row())->text();  //nome del file attuale
       
       mountAction->setText(tr("mount ") + fileDaMontare  );
       deleteAction->setText(tr("delete ") + fileDaMontare  );
       extractAction->setText(tr("extract ") + fileDaMontare  );
       
       userListMenu->exec(globalPos);     
       }
}


//gestisce search del database
void acetoneiso::search()
{
if( !lineEdit->text().isEmpty() ) {  //se la lineEdit non è vuota
   int elements = listWidget->count(); //numero totale di elementi nella lista
   int position = 0; 
//Nel ciclo while pongo come nascosti tutti gli elementi della lista
   while( position < elements ) {
      listWidget->item( position )->setHidden(true);
      position = position +1;
      }
   QList<QListWidgetItem *> found(listWidget->findItems( lineEdit->text(), Qt::MatchContains )); //cerca gli elementi che contengono la stringa nel lineEdit
   QListWidgetItem*  item;
//in questo ciclo pongo come visibili solo gli elementi che contengono nel proprio nome la stringa che cerco.
   foreach (item, found ) {
        item->setHidden(false);
	}
   }
else {
   initial_get_database();
   }
}

//crea la label nella ui per il database
void acetoneiso::database_label() {
QDir Homed = QDir::home();
QFile filed(Homed.path() + "/.acetoneiso/acetoneiso.conf");
filed.open(QIODevice::ReadOnly | QIODevice::Text);
QByteArray listb = filed.readAll();

QString list = QString::fromUtf8(listb);
//qDebug() << list ;


QStringList database_list = list.split("\n");
database_list = database_list[3].split("=",QString::SkipEmptyParts);
//qDebug() << database_list[1];

//label_database->setText(database_list[1]); may cause segfault if conf file doesn't have at least "DB =" string
//patch Jochen Fähnlein jochen.faehnlein@rk-bad-windsheim.de
QString text;
if(database_list.count() > 0) {
text = database_list[1];
label_database->setText(text); 
}

if(list.contains("yesrecursive", Qt::CaseInsensitive)) {
label_4->setText(tr("Database set to:  (flag recursive:ON)"));  
  }
 else {
label_4->setText(tr("Database set to:  (flag recursive:OFF)"));   
 }

filed.close();
}





