"""Constants for Airthings BLE parser"""

from uuid import UUID

MFCT_ID = 820

UPDATE_TIMEOUT = 15

# Use full UUID since we do not use UUID from bluetooth library
CHAR_UUID_MANUFACTURER_NAME = UUID("00002a29-0000-1000-8000-00805f9b34fb")
CHAR_UUID_SERIAL_NUMBER_STRING = UUID("00002a25-0000-1000-8000-00805f9b34fb")
CHAR_UUID_MODEL_NUMBER_STRING = UUID("00002a24-0000-1000-8000-00805f9b34fb")
CHAR_UUID_DEVICE_NAME = UUID("00002a00-0000-1000-8000-00805f9b34fb")
CHAR_UUID_FIRMWARE_REV = UUID("00002a26-0000-1000-8000-00805f9b34fb")
CHAR_UUID_HARDWARE_REV = UUID("00002a27-0000-1000-8000-00805f9b34fb")

CHAR_UUID_DATETIME = UUID("00002a08-0000-1000-8000-00805f9b34fb")
CHAR_UUID_TEMPERATURE = UUID("00002a6e-0000-1000-8000-00805f9b34fb")
CHAR_UUID_HUMIDITY = UUID("00002a6f-0000-1000-8000-00805f9b34fb")
CHAR_UUID_RADON_1DAYAVG = UUID("b42e01aa-ade7-11e4-89d3-123b93f75cba")
CHAR_UUID_RADON_LONG_TERM_AVG = UUID("b42e0a4c-ade7-11e4-89d3-123b93f75cba")
CHAR_UUID_ILLUMINANCE_ACCELEROMETER = UUID("b42e1348-ade7-11e4-89d3-123b93f75cba")
CHAR_UUID_WAVE_PLUS_DATA = UUID("b42e2a68-ade7-11e4-89d3-123b93f75cba")
CHAR_UUID_WAVE_2_DATA = UUID("b42e4dcc-ade7-11e4-89d3-123b93f75cba")
CHAR_UUID_WAVEMINI_DATA = UUID("b42e3b98-ade7-11e4-89d3-123b93f75cba")

COMMAND_UUID_WAVE_2 = UUID("b42e50d8-ade7-11e4-89d3-123b93f75cba")
COMMAND_UUID_WAVE_PLUS = UUID("b42e2d06-ade7-11e4-89d3-123b93f75cba")
COMMAND_UUID_WAVE_MINI = UUID("b42e3ef4-ade7-11e4-89d3-123b93f75cba")

# Atom
COMMAND_UUID_ATOM_NOTIFY = UUID("b42ebc9e-ade7-11e4-89d3-123b93f75cba")
COMMAND_UUID_ATOM = UUID("b42eb73a-ade7-11e4-89d3-123b93f75cba")

BQ_TO_PCI_MULTIPLIER = 0.027

CO2_MAX = 65534
VOC_MAX = 65534
PERCENTAGE_MAX = 100
PRESSURE_MAX = 1310
RADON_MAX = 16383
TEMPERATURE_MAX = 100

DEFAULT_MAX_UPDATE_ATTEMPTS = 1

ATOM_BAT = "BAT"
ATOM_LUX = "LUX"
ATOM_TEMPERATURE = "TMP"
ATOM_HUMIDITY = "HUM"
ATOM_VOC = "VOC"
ATOM_CO2 = "CO2"
ATOM_NOISE = "NOI"
ATOM_PRESSURE = "PRS"
ATOM_RADON_1DAY_AVG = "R24"
ATOM_RADON_WEEK_AVG = "R7D"
ATOM_RADON_MONTH_AVG = "R30D"
ATOM_RADON_YEAR_AVG = "R1Y"


ACCELEROMETER = "accelerometer"
BATTERY = "battery"
CO2 = "co2"
CONNECTIVITY_MODE = "connectivity_mode"
DATE_TIME = "date_time"
NOISE = "noise"
HUMIDITY = "humidity"
ILLUMINANCE = "illuminance"
LUX = "lux"
PRESSURE = "pressure"
TEMPERATURE = "temperature"
RADON_LONGTERM_AVG = "radon_longterm_avg"
RADON_LONGTERM_LEVEL = "radon_longterm_level"
RADON_1DAY_AVG = "radon_1day_avg"
RADON_1DAY_LEVEL = "radon_1day_level"
RADON_WEEK_AVG = "radon_week_avg"
RADON_WEEK_LEVEL = "radon_week_level"
RADON_MONTH_AVG = "radon_month_avg"
RADON_MONTH_LEVEL = "radon_month_level"
RADON_YEAR_AVG = "radon_year_avg"
RADON_YEAR_LEVEL = "radon_year_level"
VOC = "voc"
