/*
 * Argus Client Software.  Tools to read, analyze and manage Argus data.
 * Copyright (c) 2000-2003 QoSient, LLC
 * All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


#ifndef RaTop_h
#define RaTop_h

#include <stdlib.h>

#include <errno.h>
#include <stdio.h>
#include <string.h>

#include <netinet/in.h>

#include <ctype.h>
#include <argus-namedb.h>

#include <argus_filter.h>
 
int RaCheckTimeout(struct ArgusRecordStore *obj, struct ArgusRecord *);
void RaProcessQueue(struct RaQueueStruct *, unsigned char state);

void error_end(int rno);
void end(int signo);
void stop(int signo);
void window_size(int signo);
void do_key(char c);

/* configurable field display support */

int pflags[30];
int sflags[10];
int Numfields;

#define MAXLINES 2048

#if !defined(MAXNAMELEN)
#define MAXNAMELEN 1024
#endif

/* this is what procps top does by default, so let's do this, if nothing is
 * specified
 */
#ifndef DEFAULT_SHOW
/*                       0         1         2         3 */
/*                       0123456789012345678901234567890 */
#define DEFAULT_SHOW    "AbcDgHIjklMnoTP|qrsuzyV{EFWX"
#endif
char Fields[256] = "";

struct termios RaOrigTty;

#endif
