# FindDNET search and find the libdnet library path
#
# The following variables are set:
# CMAKE_C_FLAGS - flags to add to the C compiler for build arpon
# CMAKE_INCLUDE - include path Cflag
# CMAKE_LIBS    - library path Cflag
#
# Copyright 2010 <Giuseppe Marco Randazzo> zeld@freaknet.org
#
# Redistribution AND use is allowed according to the terms of the New
# BSD license.

find_path(LIBDNET_INCLUDE_DIR ${libdnet_h}  ${CMAKE_INCLUDE_PATH})

find_path(LIBDNET_LIB_DIR ${libdnet} ${CMAKE_LIBRARY_PATH})

find_library(LIBDNET_LIBRARY NAMES ${libdnet} PATH ${CMAKE_LIBRARY_PATH})

if(LIBDNET_INCLUDE_DIR AND LIBDNET_LIB_DIR AND LIBDNET_LIBRARY )
  message(STATUS "Found Libdnet.")

  if(NOT ${INCLUDE_DIR} MATCHES ${LIBDNET_INCLUDE_DIR})
    include_directories(${LIBDNET_INCLUDE_DIR})
    set(INCLUDE_DIR "${INCLUDE_DIR} ${LIBDNET_INCLUDE_DIR}")
  endif(NOT ${INCLUDE_DIR} MATCHES ${LIBDNET_INCLUDE_DIR})

  if(NOT ${LIB_DIR} MATCHES ${LIBDNET_LIB_DIR})
    link_directories(${LIBDNET_LIB_DIR})
    set(LIB_DIR "${LIB_DIR} ${LIBDNET_LIB_DIR}")
  endif(NOT ${LIB_DIR} MATCHES ${LIBDNET_LIB_DIR})

else(NOT LIBDNET_INCLUDE_DIR OR NOT LIBDNET_LIB_DIR OR NOT LIBDNET_LIBRARY)
  message(FATAL_ERROR "Could not find libdnet! Please Visit: http://libdnet.sourceforge.net/ or see in the arpon 'INSTALL' file.")
endif(LIBDNET_INCLUDE_DIR AND LIBDNET_LIB_DIR AND LIBDNET_LIBRARY)
