/*
 *  log.c
 *
 *  Copyright 2009 Arnaud Soyez <weboide@codealpha.net>
 *
 *  This file is part of AudioPreview.
 *
 *  AudioPreview is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  AudioPreview is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with AudioPreview.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <glib.h>

#include "ap_config.h"
#include "log.h"


void log_handler (const gchar *log_domain,
                        GLogLevelFlags log_level,
                        const gchar *message,
                        gpointer user_data)
{
  
  if((log_level & G_LOG_LEVEL_MESSAGE))
  {
    if(!ap_config.quiet)
      g_print("%s", message); /* There is no new line.
                               * (must be handled when calling g_message) */
    return;
  }
  
  if((log_level & G_LOG_LEVEL_INFO))
  {
    if(!ap_config.quiet && ap_config.verbose)
      g_print("%s", message);
    return;
  }
    
  if((log_level & G_LOG_LEVEL_DEBUG))
  {
    if(ap_config.debug)
      g_print(_("** DEBUG: %s\n"), message);
    return;
  }
    
  if((log_level & G_LOG_LEVEL_WARNING))
  {
    g_printerr(_("** WARNING: %s\n"), message);
    return;
  }
  
}
