{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetLayout: TAbstractLayoutNode;
    procedure SetLayout(const Value: TAbstractLayoutNode);
    function GetViewport: TAbstractViewportNode;
    procedure SetViewport(const Value: TAbstractViewportNode);
  public
    property Layout: TAbstractLayoutNode read GetLayout write SetLayout;
    property Viewport: TAbstractViewportNode read GetViewport write SetViewport;

{$endif read_interface}

{$ifdef read_implementation}

{ TLayoutGroupNode ----------------------------------------------- }

function TLayoutGroupNode.GetLayout: TAbstractLayoutNode;
begin
  if FdLayout.Value is TAbstractLayoutNode then
    Result := TAbstractLayoutNode(FdLayout.Value)
  else
    Result := nil;
end;

procedure TLayoutGroupNode.SetLayout(const Value: TAbstractLayoutNode);
begin
  FdLayout.Send(Value);
end;

function TLayoutGroupNode.GetViewport: TAbstractViewportNode;
begin
  if FdViewport.Value is TAbstractViewportNode then
    Result := TAbstractViewportNode(FdViewport.Value)
  else
    Result := nil;
end;

procedure TLayoutGroupNode.SetViewport(const Value: TAbstractViewportNode);
begin
  FdViewport.Send(Value);
end;

{$endif read_implementation}
