-- examples/change-setting.lua
--
-- Demonstration of changing a setting in Clod
--
-- Copyright 2012 Daniel Silverstone <dsilvers@digital-scurf.org>
--

clod = require "clod"

local input_config = [[
project.name "jeff"
project.head "refs/heads/jeff"

other.thing "here"
]]

conf, err = clod.parse(input_config)
if not conf then
   error(err)
end

-- Change name (should not move)
conf.settings.project.name = "Clod"
-- Change head (should not move)
conf.settings.project.head = "refs/heads/master"
-- Add description (should appear after head)
conf.settings.project.description = "Demonstration of settings"
-- Remove other.thing (will also elide trailing blank line)
conf.settings.other.thing = nil
-- And add a new setting which will add a blank line.
-- Note, that we cannot use conf.settings.person.name here because
-- the '.person.' will return nil as there is no such prefix.
conf.settings["person.name"] = "Lars"
-- Although now we can do this:
conf.settings.person.age = 42

io.stdout:write(conf:serialise())

