#include "tcpdispatcher"

void TcpDispatcher::execute() {
    Threadlist::clientfd(clientfd());
    Threadlist::clientip(clientip());

    if (!check_dos() ||
	!check_acl())
	return;
    
    msg ((Mstr("Dispatch request for client fd ") + clientfd()) + "\n");

    // Try to determine the back end.
    try {
	Threadlist::desc("Dispatching");
	dispatch();
    } catch (Error const &e) {
	Mutex::lock(&cerr);
	cerr << e.what() << "\n";
	Mutex::unlock(&cerr);
	socketclose(clientfd());
	socketclose(backendfd());
	return;
    }

    // Verify that the target is within the allowed set.
    if (targetbackend() < 0 || targetbackend() >= (int)balancer.nbackends()) {
	cerr << "WARNING: target back end " << targetbackend()
	     << " out of range\n";
	socketclose(clientfd());
	socketclose(backendfd());
	return;
    }

    // Dispatch!
    msg ((Mstr("Dispatching client fd ") + clientfd()) +
	 (Mstr(" to ") + balancer.backend(targetbackend()).description()) +
	 (Mstr(", fd ") + backendfd()) + "\n");


    Threadlist::desc("Serving");
    Threadlist::backend(targetbackend());
    Threadlist::backendfd(backendfd());
    
    balancer.backend(targetbackend()).startconnection();
    if (config.onstart().length()) {
	ostringstream o;
	o << config.onstart() << ' ' << clientipstr() << ' '
	  << balancer.backend(targetbackend()).description()
	  << ' ' << balancer.backend(targetbackend()).connections();
	msg (Mstr("Running onstart script: ") + o.str() + "\n");
	sysrun(o.str());
    }

    bool failed = false;
    try {
	handle();
    } catch (Error const &e) {
	Mutex::lock(&cerr);
	cerr << e.what() << "\n";
	Mutex::unlock(&cerr);
	failed = true;
	if (config.onfail().length()) {
	    ostringstream o;
	    o << config.onfail() << ' ' << clientipstr() << ' '
	      << balancer.backend(targetbackend()).description() << ' '
	      << balancer.backend(targetbackend()).connections();
	    msg(Mstr("Running onfail script: ") + o.str() + "\n");
	    sysrun(o.str());
	}
    }

    socketclose (clientfd());
    socketclose (backendfd());

    balancer.backend(targetbackend()).endconnection();
    if (!failed && config.onend().length()) {
	ostringstream o;
	o << config.onend() << ' ' << clientipstr() << ' '
	  << balancer.backend(targetbackend()).description() << ' '
	  << balancer.backend(targetbackend()).connections();
	msg (Mstr("Running onend script: ") + o.str() + "\n");
	sysrun(o.str());
    }

    msg ((Mstr("Done dispatching to back end fd ") + backendfd()) +
	 (Mstr(" at ") + balancer.backend(targetbackend()).description()) +
	 "\n");
}
