/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.CMIScore;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.samplerte.client.APIAdapterApplet;
import org.adl.util.debug.DebugIndicator;

public class CMICore
extends CMICategory
implements Serializable {
    public Element credit;
    public Element entry;
    public Element exit;
    public Element lesson_location;
    public Element lesson_mode;
    public Element lesson_status;
    public CMIScore score;
    public Element session_time;
    public Element student_id = new Element("", "checkIdentifier", "NULL", false, true, true);
    public Element student_name = new Element("", "checkString255", "NULL", false, true, true);
    public Element total_time;
    static int CMICORE_MIN_NUM_TOKENS = 3;

    public CMICore() {
        super(true);
        this.lesson_location = new Element("", "checkString255", "NULL", true, true, true);
        this.credit = new Element("", "checkVocabulary", "Credit", false, true, true);
        this.lesson_status = new Element("", "checkVocabulary", "Status", true, true, true);
        this.entry = new Element("", "checkVocabulary", "Entry", false, true, true);
        this.total_time = new Element("", "checkTimespan", "NULL", false, true, true);
        this.lesson_mode = new Element("", "checkVocabulary", "Mode", false, true, true);
        this.exit = new Element("", "checkVocabulary", "Exit", true, false, true);
        this.session_time = new Element("", "checkTimespan", "NULL", true, false, true);
        this.score = new CMIScore();
    }

    public Element getCredit() {
        return this.credit;
    }

    public Element getEntry() {
        return this.entry;
    }

    public Element getExit() {
        return this.exit;
    }

    public Element getLessonLocation() {
        return this.lesson_location;
    }

    public Element getLessonMode() {
        return this.lesson_mode;
    }

    public Element getLessonStatus() {
        return this.lesson_status;
    }

    public CMIScore getScore() {
        return this.score;
    }

    public Element getSessionTime() {
        return this.session_time;
    }

    public Element getStudentId() {
        return this.student_id;
    }

    public Element getStudentName() {
        return this.student_name;
    }

    public Element getTotalTime() {
        return this.total_time;
    }

    public void setCredit(String inCredit) {
        this.credit.setValue(inCredit);
    }

    public void setEntry(String inEntry) {
        this.entry.setValue(inEntry);
    }

    public void setExit(String inExit) {
        this.exit.setValue(inExit);
    }

    public void setLessonLocation(String inLessonLocation) {
        this.lesson_location.setValue(inLessonLocation);
    }

    public void setLessonMode(String inLessonMode) {
        this.lesson_mode.setValue(inLessonMode);
    }

    public void setLessonStatus(String inLessonStatus) {
        this.lesson_status.setValue(inLessonStatus);
    }

    public void setScore(CMIScore inScore) {
        this.score.getRaw().setValue(inScore.getRaw().getValue());
        this.score.getMin().setValue(inScore.getMin().getValue());
        this.score.getMax().setValue(inScore.getMax().getValue());
    }

    public void setSessionTime(String inSessionTime) {
        this.session_time.setValue(inSessionTime);
    }

    public void setStudentId(String inStudentID) {
        this.student_id.setValue(inStudentID);
    }

    public void setStudentName(String inStudentName) {
        this.student_name.setValue(inStudentName);
    }

    public void setTotalTime(String inTotalTime) {
        this.total_time.setValue(inTotalTime);
    }

    public String performGet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        String result = new String("");
        if (this.isValidCoreRequest(theRequest)) {
            String token = theRequest.getNextToken();
            result = theRequest.hasMoreTokensToProcess() ? this.processSubcategory(theRequest, token, dmErrorMgr) : (theRequest.isAChildrenRequest() ? this.getChildren() : this.determineElementValue(this, token, dmErrorMgr));
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Request being processed: " + theRequest.getRequest() + "\nis not a valid request for the CMI Core\n" + "Data Model Category");
            }
            dmErrorMgr.recNotImplementedError(theRequest);
        }
        theRequest.done();
        return result;
    }

    public String getChildren() {
        String children = "student_id,student_name,lesson_location,credit,lesson_status,entry,score,total_time,lesson_mode,exit,session_time";
        return children;
    }

    public void performSet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("Within cmicore PERFORMSET with request: " + theRequest);
        }
        if (this.isValidCoreRequest(theRequest)) {
            String token = theRequest.getNextToken();
            if (theRequest.hasMoreTokensToProcess()) {
                String result = this.processSubcategory(theRequest, token, dmErrorMgr);
            } else {
                String value = theRequest.getValue();
                if (theRequest.isAKeywordRequest()) {
                    dmErrorMgr.recKeyWordError(token);
                } else if (token.equals("lesson_status")) {
                    if (value.equals("not attempted") && !APIAdapterApplet.areweloading) {
                        System.out.println("I WILL NOT ALLOW RE-SETTING not attempted!!!");
                        dmErrorMgr.SetCurrentErrorCode("405");
                    } else {
                        this.doSet(this, token, value, dmErrorMgr);
                    }
                } else {
                    this.doSet(this, token, value, dmErrorMgr);
                }
            }
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Request being processed: " + theRequest.getRequest() + "\nis not a valid request for the CMI Core\n" + "Data Model Category");
            }
            dmErrorMgr.recNotImplementedError(theRequest);
        }
        theRequest.done();
    }

    private String processSubcategory(CMIRequest theRequest, String theElement, DMErrorManager dmErrorMgr) {
        String result = new String("");
        try {
            Field tmpField = this.getClass().getField(theElement);
            if (theRequest.isForASetRequest()) {
                if (theRequest.isAKeywordRequest()) {
                    dmErrorMgr.recKeyWordError(theRequest.getElement());
                } else {
                    this.score.performSet(theRequest, dmErrorMgr);
                }
            } else if (theElement.equals("score")) {
                result = this.score.performGet(theRequest, dmErrorMgr);
            } else {
                dmErrorMgr.recGetKeyWordError(theRequest.getElement());
            }
        }
        catch (NoSuchFieldException nsfe) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + theElement + "is not a valid sub category of the CMI Core\n" + "Data Model Category");
            }
            dmErrorMgr.SetCurrentErrorCode("401");
        }
        catch (SecurityException se) {
            if (DebugIndicator.ON) {
                System.out.println(se);
                System.out.println("Access to the information is denied");
            }
            dmErrorMgr.SetCurrentErrorCode("101");
        }
        return result;
    }

    private boolean isValidCoreRequest(CMIRequest theRequest) {
        boolean rtrnFlag = false;
        if (theRequest.getTotalNumTokens() >= CMICORE_MIN_NUM_TOKENS) {
            rtrnFlag = true;
        }
        return rtrnFlag;
    }

    public void showData() {
        if (DebugIndicator.ON) {
            System.out.println("CMI Core Object:");
            System.out.println("\tstudent_id: " + this.getStudentId().getValue());
            System.out.println("\tstudent_name: " + this.getStudentName().getValue());
            System.out.println("\tlesson_location: " + this.getLessonLocation().getValue());
            System.out.println("\tcredit: " + this.getCredit().getValue());
            System.out.println("\tslesson_status: " + this.getLessonStatus().getValue());
            System.out.println("\tentry: " + this.getEntry().getValue());
            System.out.println("\texit: " + this.getExit().getValue());
            System.out.println("\tscore.raw: " + this.getScore().getRaw().getValue());
            System.out.println("\tscore.min: " + this.getScore().getMin().getValue());
            System.out.println("\tscore.max: " + this.getScore().getMax().getValue());
            System.out.println("\tsession_time: " + this.getSessionTime().getValue());
            System.out.println("\ttotal_time: " + this.getTotalTime().getValue());
            System.out.println("\tlesson_mode: " + this.getLessonMode().getValue());
        }
    }
}

