## RS1022: Do not use types from Workspaces assembly in an analyzer

Diagnostic analyzer types should not use types from Workspaces assemblies. Workspaces assemblies are only available when the analyzer executes in Visual Studio IDE live analysis, but are not available during command line build. Referencing types from Workspaces assemblies will lead to runtime exception during analyzer execution in command line build.

|Item|Value|
|-|-|
|Category|MicrosoftCodeAnalysisCorrectness|
|Enabled|True|
|Severity|Warning|
|CodeFix|False|
---

> **Warning**
>
> The analysis performed by RS1022 is slow and relies on implementation details of the JIT compiler for correctness.
> Authors of compiler extensions are encouraged to use the stricter (and faster) analyzer RS1038 instead of this rule.
>
> RS1038 is enabled by default. To enable RS1022 instead, the following configuration may be added to **.globalconfig**:
>
> ```ini
> roslyn_correctness.assembly_reference_validation = relaxed
> ```
