#include "sid3.h"

#include <math.h>

#define SAFETY_HEADER if(sid3 == NULL) return;

enum State { ATTACK, DECAY, SUSTAIN, RELEASE }; //for envelope

#ifndef M_PI
#  define M_PI    3.14159265358979323846
#endif

#define envspd_factor_a_sr 10
#define envspd_factor_dr 15

#define envspd_a(rate) ((uint64_t)0xff0000 / ((rate == 0 ? 1 : (rate * envspd_factor_a_sr)) * (rate == 0 ? 1 : (rate * envspd_factor_a_sr * ((float)sid3->clock_rate / 1000000.0)))))
#define envspd_dr(rate) ((uint64_t)0xff0000 / ((rate == 0 ? 1 : (rate * envspd_factor_dr)) * (rate == 0 ? 1 : (rate * envspd_factor_dr * ((float)sid3->clock_rate / 1000000.0)))))
#define envspd_sr(rate) (rate == 0 ? 0 : ((uint64_t)0xff0000 / ((256 - rate) * (256 - rate) * envspd_factor_a_sr * envspd_factor_a_sr * ((float)sid3->clock_rate / 1000000.0))))

//these 4 ones are util only
double square(double x) {
  return fmod(x, (2 * M_PI)) >= M_PI ? -1 : 1;
}
double triangle(double x) {
  return asin(sin(x)) / (M_PI / 2);
}
double saw(double x) {
  return atan(tan(x / 2)) / (M_PI / 2);
}
double rectSquare(double x) {
  return square(x) > 0 ? square(x) : 0;
}
//===========================

double sinus(double x) { //taken from waveEdit.cpp of Furnace tracker
  return sin(x);
}
double rectSin(double x) {
  return sin(x) > 0 ? sin(x) : 0;
}
double absSin(double x) {
  return fabs(sin(x));
}

double quartSin(double x) {
  return absSin(x) * rectSquare(2 * x);
}
double squiSin(double x) {
  return sin(x) >= 0 ? sin(2 * x) : 0;
}
double squiAbsSin(double x) {
  return fabs(squiSin(x));
}

double rectSaw(double x) {
  return saw(x) > 0 ? saw(x) : 0;
}
double absSaw(double x) {
  return saw(x) < 0 ? saw(x) + 1 : saw(x);
}


double cubSaw(double x) {
  return pow(saw(x), 3);
}
double rectCubSaw(double x) {
  return pow(rectSaw(x), 3);
}
double absCubSaw(double x) {
  return pow(absSaw(x), 3);
}

double cubSine(double x) {
  return pow(sin(x), 3);
}
double rectCubSin(double x) {
  return pow(rectSin(x), 3);
}
double absCubSin(double x) {
  return pow(absSin(x), 3);
}
double quartCubSin(double x) {
  return pow(quartSin(x), 3);
}
double squishCubSin(double x) {
  return pow(squiSin(x), 3);
}
double squishAbsCubSin(double x) {
  return pow(squiAbsSin(x), 3);
}

double rectTri(double x) {
  return triangle(x) > 0 ? triangle(x) : 0;
}
double absTri(double x) {
  return fabs(triangle(x));
}
double quartTri(double x) {
  return absTri(x) * rectSquare(2 * x);
}
double squiTri(double x) {
  return sin(x) >= 0 ? triangle(2 * x) : 0;
}
double absSquiTri(double x) {
  return fabs(squiTri(x));
}

double cubTriangle(double x) {
  return pow(triangle(x), 3);
}
double cubRectTri(double x) {
  return pow(rectTri(x), 3);
}
double cubAbsTri(double x) {
  return pow(absTri(x), 3);
}
double cubQuartTri(double x) {
  return pow(quartTri(x), 3);
}
double cubSquiTri(double x) {
  return pow(squiTri(x), 3);
}
double absCubSquiTri(double x) {
  return fabs(cubSquiTri(x));
}

typedef double (*WaveFunc) (double a);

WaveFunc waveFuncsSID3[]={
  sinus,
  rectSin,
  absSin,
  quartSin,
  squiSin,
  squiAbsSin,
  
  rectSaw,
  absSaw,
  
  cubSaw,
  rectCubSaw,
  absCubSaw,
  
  cubSine,
  rectCubSin,
  absCubSin,
  quartCubSin,
  squishCubSin,
  squishAbsCubSin,

  rectTri,
  absTri,
  quartTri,
  squiTri,
  absSquiTri,

  cubTriangle,
  cubRectTri,
  cubAbsTri,
  cubQuartTri,
  cubSquiTri,
  absCubSquiTri
};

uint8_t wave8580__ST[] =
{
/* 0x000: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x008: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x010: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x018: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x020: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x028: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x030: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x038: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x040: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x048: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x050: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x058: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x060: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x068: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x070: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x078: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0x080: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x088: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x090: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x098: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0f8: */  0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07,
/* 0x100: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x108: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x110: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x118: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x120: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x128: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x130: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x138: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x140: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x148: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x150: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x158: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x160: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x168: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x170: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x178: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0x180: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x188: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x190: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x198: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1f8: */  0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x0f, 0x0f, 0x0f,
/* 0x200: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x208: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x210: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x218: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x220: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x228: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x230: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x238: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x240: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x248: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x250: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x258: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x260: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x268: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x270: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x278: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0x280: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x288: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x290: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x298: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2f8: */  0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07,
/* 0x300: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x308: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x310: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x318: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x320: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x328: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x330: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x338: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x340: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x348: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x350: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x358: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x360: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x368: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x370: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x378: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0x380: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x388: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x390: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x398: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0x3c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3f0: */  0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c,
/* 0x3f8: */  0x1e, 0x1e, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
/* 0x400: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x408: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x410: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x418: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x420: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x428: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x430: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x438: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x440: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x448: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x450: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x458: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x460: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x468: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x470: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x478: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0x480: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x488: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x490: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x498: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4f8: */  0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07,
/* 0x500: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x508: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x510: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x518: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x520: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x528: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x530: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x538: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x540: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x548: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x550: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x558: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x560: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x568: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x570: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x578: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0x580: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x588: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x590: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x598: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5f8: */  0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x0f, 0x0f, 0x1f,
/* 0x600: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x608: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x610: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x618: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x620: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x628: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x630: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x638: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x640: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x648: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x650: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x658: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x660: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x668: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x670: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x678: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0x680: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x688: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x690: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x698: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6f8: */  0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07,
/* 0x700: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x708: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x710: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x718: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x720: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x728: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x730: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x738: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x740: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x748: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x750: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x758: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x760: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x768: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x770: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x778: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0x780: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x788: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x790: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x798: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0x7c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7e0: */  0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
/* 0x7e8: */  0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
/* 0x7f0: */  0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3e,
/* 0x7f8: */  0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
/* 0x800: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x808: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x810: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x818: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x820: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x828: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x830: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x838: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x840: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x848: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x850: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x858: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x860: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x868: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x870: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x878: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0x880: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x888: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x890: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x898: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8f8: */  0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07,
/* 0x900: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x908: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x910: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x918: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x920: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x928: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x930: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x938: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x940: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x948: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x950: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x958: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x960: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x968: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x970: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x978: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0x980: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x988: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x990: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x998: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9f8: */  0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x0f, 0x0f, 0x0f,
/* 0xa00: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0xa80: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xaa0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xaa8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xab0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xab8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xac0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xac8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xad0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xad8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xae0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xae8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xaf0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xaf8: */  0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07,
/* 0xb00: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0xb80: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xba0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xba8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbb0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbb8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0xbc0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbc8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbd0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbd8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbe0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbe8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbf0: */  0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c,
/* 0xbf8: */  0x1e, 0x1e, 0x1f, 0x1f, 0x1f, 0x1f, 0x3f, 0x3f,
/* 0xc00: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0xc80: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xca0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xca8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcb0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcb8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcc0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcc8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcd0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcd8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xce0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xce8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcf0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcf8: */  0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07,
/* 0xd00: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
/* 0xd80: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xda0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xda8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdb0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdb8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0xdc0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdc8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdd0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdd8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xde0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xde8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdf0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdf8: */  0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x0f, 0x1f, 0x1f,
/* 0xe00: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe78: */  0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x83, 0x83,
/* 0xe80: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xe88: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xe90: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xe98: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xea0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xea8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xeb0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xeb8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xec0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xec8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xed0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xed8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xee0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xee8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xef0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xef8: */  0x80, 0x80, 0x80, 0x80, 0x87, 0x87, 0x87, 0x8f,
/* 0xf00: */  0xc0, 0xe0, 0xe0, 0xc0, 0xc0, 0xe0, 0xe0, 0xe0,
/* 0xf08: */  0xe0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf10: */  0xc0, 0xe0, 0xe0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf18: */  0xe0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf20: */  0xc0, 0xe0, 0xe0, 0xc0, 0xc0, 0xe0, 0xe0, 0xe0,
/* 0xf28: */  0xe0, 0xe0, 0xe0, 0xc0, 0xe0, 0xc0, 0xe0, 0xe0,
/* 0xf30: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf38: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf40: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf48: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf50: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf58: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf60: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf68: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf70: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf78: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe3, 0xe3,
/* 0xf80: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xf88: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xf90: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xf98: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xfa0: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xfa8: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xfb0: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xfb8: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf1,
/* 0xfc0: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
/* 0xfc8: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
/* 0xfd0: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
/* 0xfd8: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
/* 0xfe0: */  0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
/* 0xfe8: */  0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
/* 0xff0: */  0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
/* 0xff8: */  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

uint8_t wave8580_P_T[] =
{
/* 0x000: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x008: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x010: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x018: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x020: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x028: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x030: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x038: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x040: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x048: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x050: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x058: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x060: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x068: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x070: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x078: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x080: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x088: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x090: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x098: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
/* 0x100: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x108: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x110: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x118: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x120: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x128: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x130: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x138: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x140: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x148: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x150: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x158: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x160: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x168: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x170: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x178: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x180: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x188: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x190: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x198: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1f8: */  0x00, 0x00, 0x00, 0x1c, 0x00, 0x3c, 0x3f, 0x3f,
/* 0x200: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x208: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x210: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x218: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x220: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x228: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x230: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x238: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x240: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x248: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x250: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x258: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x260: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x268: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x270: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x278: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x280: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x288: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x290: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x298: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x5e, 0x5f,
/* 0x300: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x308: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x310: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x318: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x320: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x328: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x330: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x338: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x340: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x348: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x350: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x358: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x360: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x368: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x370: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
/* 0x378: */  0x00, 0x00, 0x00, 0x40, 0x40, 0x60, 0x60, 0x6f,
/* 0x380: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x388: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x390: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x398: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
/* 0x3a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40,
/* 0x3b0: */  0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x60,
/* 0x3b8: */  0x40, 0x40, 0x60, 0x60, 0x60, 0x60, 0x70, 0x77,
/* 0x3c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40,
/* 0x3c8: */  0x40, 0x40, 0x40, 0x40, 0x40, 0x60, 0x60, 0x60,
/* 0x3d0: */  0x40, 0x40, 0x40, 0x60, 0x60, 0x60, 0x60, 0x70,
/* 0x3d8: */  0x60, 0x60, 0x60, 0x70, 0x70, 0x70, 0x78, 0x7b,
/* 0x3e0: */  0x60, 0x60, 0x60, 0x70, 0x60, 0x70, 0x70, 0x70,
/* 0x3e8: */  0x70, 0x70, 0x70, 0x78, 0x78, 0x78, 0x78, 0x7c,
/* 0x3f0: */  0x78, 0x78, 0x78, 0x7c, 0x78, 0x7c, 0x7c, 0x7e,
/* 0x3f8: */  0x7c, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
/* 0x400: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x408: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x410: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x418: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x420: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x428: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x430: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x438: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x440: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x448: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x450: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x458: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x460: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x468: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x470: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x478: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0x480: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x488: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x490: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x498: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
/* 0x4c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0x4d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0x4d8: */  0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x4e0: */  0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x4e8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x4f0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x4f8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x8e, 0x9f,
/* 0x500: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x508: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x510: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x518: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0x520: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x528: */  0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x80, 0x80,
/* 0x530: */  0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x538: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x540: */  0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x80, 0x80,
/* 0x548: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x550: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x558: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x560: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x568: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x570: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x578: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xaf,
/* 0x580: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x588: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x590: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x598: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x5a0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x5a8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x5b0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x5b8: */  0x80, 0x80, 0x80, 0xa0, 0xa0, 0xa0, 0xa0, 0xb7,
/* 0x5c0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x5c8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xa0,
/* 0x5d0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xa0, 0xa0,
/* 0x5d8: */  0xa0, 0xa0, 0xa0, 0xb0, 0xa0, 0xb0, 0xb0, 0xbb,
/* 0x5e0: */  0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xb0, 0xb0,
/* 0x5e8: */  0xa0, 0xb0, 0xb0, 0xb8, 0xb0, 0xb8, 0xb8, 0xbc,
/* 0x5f0: */  0xb0, 0xb8, 0xb8, 0xb8, 0xb8, 0xbc, 0xbc, 0xbe,
/* 0x5f8: */  0xbc, 0xbc, 0xbe, 0xbf, 0xbe, 0xbf, 0xbf, 0xbf,
/* 0x600: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x608: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x610: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x618: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x620: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x628: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x630: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x638: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0,
/* 0x640: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x648: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x650: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0,
/* 0x658: */  0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x660: */  0x80, 0x80, 0x80, 0xc0, 0x80, 0xc0, 0xc0, 0xc0,
/* 0x668: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x670: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x678: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xcf,
/* 0x680: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0,
/* 0x688: */  0xc0, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x690: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x698: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x6a0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x6a8: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x6b0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x6b8: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xd7,
/* 0x6c0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x6c8: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x6d0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x6d8: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xd0, 0xd0, 0xd9,
/* 0x6e0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xd0,
/* 0x6e8: */  0xc0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd8, 0xd8, 0xdc,
/* 0x6f0: */  0xd0, 0xd0, 0xd8, 0xd8, 0xd8, 0xdc, 0xdc, 0xde,
/* 0x6f8: */  0xdc, 0xdc, 0xde, 0xdf, 0xde, 0xdf, 0xdf, 0xdf,
/* 0x700: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x708: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x710: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x718: */  0xc0, 0xc0, 0xc0, 0xe0, 0xc0, 0xe0, 0xe0, 0xe0,
/* 0x720: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe0,
/* 0x728: */  0xc0, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x730: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x738: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe7,
/* 0x740: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x748: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x750: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x758: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe8,
/* 0x760: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x768: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe8, 0xec,
/* 0x770: */  0xe0, 0xe0, 0xe0, 0xe8, 0xe8, 0xe8, 0xec, 0xee,
/* 0x778: */  0xec, 0xec, 0xec, 0xee, 0xee, 0xef, 0xef, 0xef,
/* 0x780: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x788: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0, 0xf0, 0xf0,
/* 0x790: */  0xe0, 0xe0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0x798: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0x7a0: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0x7a8: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf4,
/* 0x7b0: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf4,
/* 0x7b8: */  0xf0, 0xf4, 0xf4, 0xf6, 0xf6, 0xf7, 0xf7, 0xf7,
/* 0x7c0: */  0xf0, 0xf0, 0xf0, 0xf8, 0xf0, 0xf8, 0xf8, 0xf8,
/* 0x7c8: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
/* 0x7d0: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
/* 0x7d8: */  0xf8, 0xf8, 0xf8, 0xfa, 0xfa, 0xfb, 0xfb, 0xfb,
/* 0x7e0: */  0xf8, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
/* 0x7e8: */  0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfd, 0xfd, 0xfd,
/* 0x7f0: */  0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
/* 0x7f8: */  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
/* 0x800: */  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
/* 0x808: */  0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfc,
/* 0x810: */  0xfd, 0xfd, 0xfd, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
/* 0x818: */  0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xf8,
/* 0x820: */  0xfb, 0xfb, 0xfb, 0xfa, 0xfa, 0xf8, 0xf8, 0xf8,
/* 0x828: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
/* 0x830: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
/* 0x838: */  0xf8, 0xf8, 0xf8, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0x840: */  0xf7, 0xf7, 0xf7, 0xf6, 0xf6, 0xf4, 0xf4, 0xf0,
/* 0x848: */  0xf4, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0x850: */  0xf4, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0x858: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0x860: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0x868: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xe0, 0xe0,
/* 0x870: */  0xf0, 0xf0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x878: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x880: */  0xef, 0xef, 0xef, 0xee, 0xee, 0xec, 0xec, 0xe8,
/* 0x888: */  0xee, 0xec, 0xe8, 0xe8, 0xe8, 0xe0, 0xe0, 0xe0,
/* 0x890: */  0xec, 0xe8, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x898: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x8a0: */  0xe8, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x8a8: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x8b0: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x8b8: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x8c0: */  0xe7, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x8c8: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0x8d0: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xc0, 0xc0,
/* 0x8d8: */  0xe0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x8e0: */  0xe0, 0xe0, 0xe0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x8e8: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x8f0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x8f8: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x900: */  0xdf, 0xdf, 0xdf, 0xde, 0xdf, 0xde, 0xdc, 0xdc,
/* 0x908: */  0xde, 0xdc, 0xdc, 0xd8, 0xd8, 0xd8, 0xd0, 0xd0,
/* 0x910: */  0xdc, 0xd8, 0xd8, 0xd0, 0xd0, 0xd0, 0xd0, 0xc0,
/* 0x918: */  0xd0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x920: */  0xd9, 0xd0, 0xd0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x928: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x930: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x938: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x940: */  0xd7, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x948: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x950: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x958: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x960: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x968: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x970: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80,
/* 0x978: */  0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x980: */  0xcf, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x988: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x990: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0x998: */  0xc0, 0xc0, 0xc0, 0x80, 0xc0, 0x80, 0x80, 0x80,
/* 0x9a0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x80,
/* 0x9a8: */  0xc0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x9b0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x9b8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x9c0: */  0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x9c8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x9d0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x9d8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x9e0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x9e8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x9f0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0x9f8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa00: */  0xbf, 0xbf, 0xbf, 0xbe, 0xbf, 0xbe, 0xbc, 0xbc,
/* 0xa08: */  0xbe, 0xbc, 0xbc, 0xb8, 0xb8, 0xb8, 0xb8, 0xb0,
/* 0xa10: */  0xbc, 0xb8, 0xb8, 0xb0, 0xb8, 0xb0, 0xb0, 0xb0,
/* 0xa18: */  0xb0, 0xb0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0,
/* 0xa20: */  0xbb, 0xb0, 0xb0, 0xa0, 0xb0, 0xa0, 0xa0, 0xa0,
/* 0xa28: */  0xa0, 0xa0, 0xa0, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa30: */  0xa0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa38: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa40: */  0xb7, 0xb0, 0xa0, 0xa0, 0xa0, 0x80, 0x80, 0x80,
/* 0xa48: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa50: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa58: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa60: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa68: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa70: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa78: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa80: */  0xaf, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa88: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa90: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xa98: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xaa0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xaa8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xab0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xab8: */  0x80, 0x80, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00,
/* 0xac0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xac8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,
/* 0xad0: */  0x80, 0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
/* 0xad8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xae0: */  0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xae8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xaf0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xaf8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb00: */  0x9f, 0x9e, 0x88, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb08: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb10: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb18: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,
/* 0xb20: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,
/* 0xb28: */  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb30: */  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb40: */  0x80, 0x80, 0x80, 0x00, 0x80, 0x00, 0x00, 0x00,
/* 0xb48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb80: */  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xba0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xba8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbb0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbb8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbc0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbc8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbd0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbd8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbe0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbe8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbf0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbf8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc00: */  0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7c,
/* 0xc08: */  0x7e, 0x7c, 0x7c, 0x78, 0x7c, 0x78, 0x78, 0x78,
/* 0xc10: */  0x7c, 0x78, 0x78, 0x78, 0x78, 0x70, 0x70, 0x70,
/* 0xc18: */  0x78, 0x70, 0x70, 0x60, 0x70, 0x60, 0x60, 0x60,
/* 0xc20: */  0x7b, 0x78, 0x70, 0x70, 0x70, 0x60, 0x60, 0x60,
/* 0xc28: */  0x70, 0x60, 0x60, 0x60, 0x60, 0x40, 0x40, 0x40,
/* 0xc30: */  0x60, 0x60, 0x60, 0x40, 0x40, 0x40, 0x40, 0x40,
/* 0xc38: */  0x40, 0x40, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00,
/* 0xc40: */  0x77, 0x70, 0x60, 0x60, 0x60, 0x60, 0x40, 0x40,
/* 0xc48: */  0x60, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00,
/* 0xc50: */  0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc60: */  0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc80: */  0x6f, 0x64, 0x60, 0x40, 0x40, 0x00, 0x00, 0x00,
/* 0xc88: */  0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xca0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xca8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcb0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcb8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcc0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcc8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcd0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcd8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xce0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xce8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcf0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcf8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd00: */  0x5f, 0x5e, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd80: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xda0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xda8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdb0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdb8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdc0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdc8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdd0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdd8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xde0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xde8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdf0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdf8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe00: */  0x3f, 0x3f, 0x3e, 0x00, 0x1c, 0x00, 0x00, 0x00,
/* 0xe08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe80: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xea0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xea8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xeb0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xeb8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xec0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xec8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xed0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xed8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xee0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xee8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xef0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xef8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf00: */  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf80: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xf98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xfa0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xfa8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xfb0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xfb8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xfc0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xfc8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xfd0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xfd8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xfe0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xfe8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xff0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xff8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

uint8_t wave8580_PS_[] =
{
/* 0x000: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x008: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x010: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x018: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x020: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x028: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x030: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x038: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x040: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x048: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x050: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x058: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x060: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x068: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x070: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x078: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
/* 0x080: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x088: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x090: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x098: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0x0c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f,
/* 0x100: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x108: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x110: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x118: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x120: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x128: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x130: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x138: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x140: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x148: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x150: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x158: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x160: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x168: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x170: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x178: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
/* 0x180: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x188: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x190: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x198: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
/* 0x1c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0x1e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x1f,
/* 0x200: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x208: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x210: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x218: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x220: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x228: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x230: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x238: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x240: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x248: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x250: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x258: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x260: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x268: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x270: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x278: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
/* 0x280: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x288: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x290: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x298: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
/* 0x2c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0x2e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0f,
/* 0x300: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x308: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x310: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x318: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x320: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x328: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x330: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x338: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0x340: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x348: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x350: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x358: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x360: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x368: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x370: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x378: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
/* 0x380: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x388: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x390: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x398: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b,
/* 0x3c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d,
/* 0x3e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e,
/* 0x3f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f,
/* 0x3f8: */  0x00, 0x0c, 0x1c, 0x3f, 0x1e, 0x3f, 0x3f, 0x3f,
/* 0x400: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x408: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x410: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x418: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x420: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x428: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x430: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x438: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x440: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x448: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x450: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x458: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x460: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x468: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x470: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x478: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
/* 0x480: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x488: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x490: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x498: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0x4c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f,
/* 0x500: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x508: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x510: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x518: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x520: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x528: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x530: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x538: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0x540: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x548: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x550: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x558: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x560: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x568: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x570: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x578: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
/* 0x580: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x588: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x590: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x598: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b,
/* 0x5c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a,
/* 0x5e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e,
/* 0x5f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f,
/* 0x5f8: */  0x00, 0x00, 0x00, 0x5f, 0x0c, 0x5f, 0x5f, 0x5f,
/* 0x600: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x608: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x610: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x618: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x620: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x628: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x630: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x638: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0x640: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x648: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x650: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x658: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x660: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x668: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x670: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x678: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47,
/* 0x680: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x688: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x690: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x698: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43,
/* 0x6c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65,
/* 0x6e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6e,
/* 0x6f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f,
/* 0x6f8: */  0x00, 0x40, 0x40, 0x6f, 0x40, 0x6f, 0x6f, 0x6f,
/* 0x700: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x708: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x710: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x718: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x720: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x728: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x730: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x738: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63,
/* 0x740: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x748: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x750: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x758: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x61,
/* 0x760: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
/* 0x768: */  0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0x40, 0x70,
/* 0x770: */  0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x70,
/* 0x778: */  0x40, 0x60, 0x60, 0x77, 0x60, 0x77, 0x77, 0x77,
/* 0x780: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x788: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
/* 0x790: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x60,
/* 0x798: */  0x00, 0x40, 0x40, 0x60, 0x40, 0x60, 0x60, 0x79,
/* 0x7a0: */  0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x60,
/* 0x7a8: */  0x40, 0x40, 0x40, 0x60, 0x60, 0x60, 0x60, 0x78,
/* 0x7b0: */  0x40, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x78,
/* 0x7b8: */  0x60, 0x70, 0x70, 0x78, 0x70, 0x79, 0x7b, 0x7b,
/* 0x7c0: */  0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70,
/* 0x7c8: */  0x60, 0x60, 0x60, 0x70, 0x60, 0x70, 0x70, 0x7c,
/* 0x7d0: */  0x60, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x7c,
/* 0x7d8: */  0x70, 0x78, 0x78, 0x7c, 0x78, 0x7c, 0x7c, 0x7d,
/* 0x7e0: */  0x70, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x7c,
/* 0x7e8: */  0x78, 0x7c, 0x7c, 0x7e, 0x7c, 0x7e, 0x7e, 0x7e,
/* 0x7f0: */  0x7c, 0x7c, 0x7c, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f,
/* 0x7f8: */  0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0xff,
/* 0x800: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x808: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x810: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x818: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x820: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x828: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x830: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x838: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x840: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x848: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x850: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x858: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x860: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x868: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x870: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x878: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
/* 0x880: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x888: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x890: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x898: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0x8c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8f,
/* 0x900: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x908: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x910: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x918: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x920: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x928: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x930: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x938: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0x940: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x948: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x950: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x958: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x960: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x968: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x970: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x978: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x87,
/* 0x980: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x988: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x990: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x998: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83,
/* 0x9c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x8d,
/* 0x9e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0x9e8: */  0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x80, 0x8e,
/* 0x9f0: */  0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x8f,
/* 0x9f8: */  0x80, 0x80, 0x80, 0x9f, 0x80, 0x9f, 0x9f, 0x9f,
/* 0xa00: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
/* 0xa40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0xa70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0xa78: */  0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x80, 0x87,
/* 0xa80: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0xaa0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xaa8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0xab0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0xab8: */  0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x83,
/* 0xac0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xac8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0xad0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
/* 0xad8: */  0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
/* 0xae0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xae8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x84,
/* 0xaf0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x87,
/* 0xaf8: */  0x80, 0x80, 0x80, 0x87, 0x80, 0x8f, 0xaf, 0xaf,
/* 0xb00: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0xb10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0xb18: */  0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb20: */  0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x80, 0x80,
/* 0xb28: */  0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb30: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb38: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x83,
/* 0xb40: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb48: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb50: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb58: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
/* 0xb60: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb68: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xa0,
/* 0xb70: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xa0,
/* 0xb78: */  0x80, 0x80, 0x80, 0xa0, 0x80, 0xa3, 0xb7, 0xb7,
/* 0xb80: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb88: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb90: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xb98: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xb1,
/* 0xba0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xba8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xb0,
/* 0xbb0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xb0,
/* 0xbb8: */  0x80, 0xa0, 0xa0, 0xb0, 0xa0, 0xb8, 0xb9, 0xbb,
/* 0xbc0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xa0,
/* 0xbc8: */  0x80, 0x80, 0x80, 0xa0, 0x80, 0xa0, 0xa0, 0xb8,
/* 0xbd0: */  0x80, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xb8,
/* 0xbd8: */  0xa0, 0xb0, 0xb0, 0xb8, 0xb0, 0xbc, 0xbc, 0xbd,
/* 0xbe0: */  0xa0, 0xb0, 0xb0, 0xb0, 0xb0, 0xb8, 0xb8, 0xbc,
/* 0xbe8: */  0xb0, 0xb8, 0xb8, 0xbc, 0xb8, 0xbc, 0xbe, 0xbe,
/* 0xbf0: */  0xb8, 0xbc, 0xbc, 0xbe, 0xbc, 0xbe, 0xbe, 0xbf,
/* 0xbf8: */  0xbe, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf,
/* 0xc00: */  0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80,
/* 0xc08: */  0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80,
/* 0xc10: */  0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc18: */  0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc20: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc28: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc30: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc38: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
/* 0xc40: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc48: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc50: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc58: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc60: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc68: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc70: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc78: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc7,
/* 0xc80: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc88: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc90: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xc98: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xca0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xca8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xcb0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xcb8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc3,
/* 0xcc0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xcc8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0,
/* 0xcd0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0,
/* 0xcd8: */  0x80, 0x80, 0x80, 0xc0, 0x80, 0xc0, 0xc0, 0xc1,
/* 0xce0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0,
/* 0xce8: */  0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xcf0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc7,
/* 0xcf8: */  0xc0, 0xc0, 0xc0, 0xc7, 0xc0, 0xcf, 0xcf, 0xcf,
/* 0xd00: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xd08: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xd10: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xd18: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0,
/* 0xd20: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xd28: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0,
/* 0xd30: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0,
/* 0xd38: */  0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc3,
/* 0xd40: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0,
/* 0xd48: */  0x80, 0x80, 0x80, 0xc0, 0x80, 0xc0, 0xc0, 0xc0,
/* 0xd50: */  0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xd58: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc1,
/* 0xd60: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xd68: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xd70: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xd78: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc1, 0xc7, 0xd7,
/* 0xd80: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xd88: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xd90: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xd98: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xda0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xda8: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xd0,
/* 0xdb0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xd0,
/* 0xdb8: */  0xc0, 0xc0, 0xc0, 0xd0, 0xc0, 0xd0, 0xd8, 0xdb,
/* 0xdc0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xdc8: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xd8,
/* 0xdd0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xd8,
/* 0xdd8: */  0xc0, 0xc0, 0xc0, 0xd8, 0xd0, 0xd8, 0xd8, 0xdd,
/* 0xde0: */  0xc0, 0xc0, 0xc0, 0xd0, 0xc0, 0xd0, 0xd0, 0xdc,
/* 0xde8: */  0xd0, 0xd8, 0xd8, 0xdc, 0xd8, 0xdc, 0xdc, 0xde,
/* 0xdf0: */  0xd8, 0xdc, 0xdc, 0xde, 0xdc, 0xde, 0xde, 0xdf,
/* 0xdf8: */  0xde, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf,
/* 0xe00: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xe08: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xe10: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xe18: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xe20: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xe28: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xe30: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xe38: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe3,
/* 0xe40: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xe48: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xe50: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe0,
/* 0xe58: */  0xc0, 0xc0, 0xc0, 0xe0, 0xc0, 0xe0, 0xe0, 0xe1,
/* 0xe60: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe0,
/* 0xe68: */  0xc0, 0xc0, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xe70: */  0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xe78: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe3, 0xe7,
/* 0xe80: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe0,
/* 0xe88: */  0xc0, 0xc0, 0xc0, 0xe0, 0xc0, 0xe0, 0xe0, 0xe0,
/* 0xe90: */  0xc0, 0xc0, 0xc0, 0xe0, 0xc0, 0xe0, 0xe0, 0xe0,
/* 0xe98: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xea0: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xea8: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xeb0: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xeb8: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xeb,
/* 0xec0: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xec8: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xed0: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xed8: */  0xe0, 0xe0, 0xe0, 0xe8, 0xe0, 0xe8, 0xe8, 0xed,
/* 0xee0: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xec,
/* 0xee8: */  0xe0, 0xe0, 0xe0, 0xec, 0xe8, 0xec, 0xec, 0xee,
/* 0xef0: */  0xe8, 0xe8, 0xe8, 0xec, 0xec, 0xee, 0xee, 0xef,
/* 0xef8: */  0xec, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef,
/* 0xf00: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf08: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf10: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf18: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0,
/* 0xf20: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0,
/* 0xf28: */  0xe0, 0xe0, 0xe0, 0xf0, 0xe0, 0xf0, 0xf0, 0xf0,
/* 0xf30: */  0xe0, 0xe0, 0xe0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xf38: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf3,
/* 0xf40: */  0xe0, 0xe0, 0xe0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xf48: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xf50: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xf58: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf5,
/* 0xf60: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xf68: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf4, 0xf4, 0xf6,
/* 0xf70: */  0xf0, 0xf0, 0xf0, 0xf4, 0xf0, 0xf4, 0xf6, 0xf7,
/* 0xf78: */  0xf4, 0xf6, 0xf6, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7,
/* 0xf80: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf8,
/* 0xf88: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf8, 0xf8, 0xf8,
/* 0xf90: */  0xf0, 0xf0, 0xf0, 0xf8, 0xf0, 0xf8, 0xf8, 0xf8,
/* 0xf98: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf9,
/* 0xfa0: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
/* 0xfa8: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xfa,
/* 0xfb0: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xfb,
/* 0xfb8: */  0xf8, 0xfa, 0xfa, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb,
/* 0xfc0: */  0xf8, 0xf8, 0xf8, 0xfc, 0xf8, 0xfc, 0xfc, 0xfc,
/* 0xfc8: */  0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
/* 0xfd0: */  0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfd,
/* 0xfd8: */  0xfc, 0xfc, 0xfc, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd,
/* 0xfe0: */  0xfc, 0xfc, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
/* 0xfe8: */  0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
/* 0xff0: */  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
/* 0xff8: */  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

uint8_t wave8580_PST[] =
{
/* 0x000: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x008: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x010: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x018: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x020: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x028: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x030: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x038: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x040: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x048: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x050: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x058: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x060: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x068: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x070: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x078: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x080: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x088: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x090: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x098: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x0f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x100: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x108: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x110: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x118: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x120: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x128: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x130: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x138: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x140: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x148: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x150: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x158: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x160: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x168: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x170: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x178: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x180: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x188: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x190: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x198: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x1f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x200: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x208: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x210: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x218: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x220: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x228: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x230: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x238: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x240: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x248: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x250: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x258: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x260: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x268: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x270: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x278: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x280: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x288: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x290: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x298: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x2f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x300: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x308: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x310: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x318: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x320: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x328: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x330: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x338: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x340: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x348: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x350: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x358: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x360: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x368: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x370: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x378: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x380: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x388: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x390: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x398: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x3f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,
/* 0x400: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x408: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x410: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x418: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x420: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x428: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x430: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x438: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x440: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x448: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x450: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x458: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x460: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x468: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x470: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x478: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x480: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x488: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x490: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x498: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x4f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x500: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x508: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x510: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x518: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x520: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x528: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x530: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x538: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x540: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x548: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x550: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x558: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x560: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x568: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x570: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x578: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x580: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x588: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x590: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x598: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x5f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x600: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x608: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x610: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x618: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x620: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x628: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x630: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x638: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x640: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x648: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x650: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x658: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x660: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x668: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x670: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x678: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x680: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x688: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x690: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x698: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x6f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x700: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x708: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x710: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x718: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x720: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x728: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x730: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x738: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x740: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x748: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x750: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x758: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x760: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x768: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x770: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x778: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x780: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x788: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x790: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x798: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x7e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x70,
/* 0x7f0: */  0x60, 0x20, 0x70, 0x70, 0x70, 0x70, 0x70, 0x78,
/* 0x7f8: */  0x78, 0x78, 0x7c, 0x7c, 0x7e, 0x7e, 0x7f, 0x7f,
/* 0x800: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x808: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x810: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x818: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x820: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x828: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x830: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x838: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x840: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x848: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x850: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x858: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x860: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x868: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x870: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x878: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x880: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x888: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x890: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x898: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x8f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x900: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x908: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x910: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x918: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x920: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x928: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x930: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x938: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x940: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x948: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x950: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x958: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x960: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x968: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x970: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x978: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x980: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x988: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x990: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x998: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9a0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9a8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9b0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9b8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9c0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9c8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9d0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9d8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9e0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9e8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9f0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0x9f8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa00: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa80: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xa98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xaa0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xaa8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xab0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xab8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xac0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xac8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xad0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xad8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xae0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xae8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xaf0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xaf8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb00: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb80: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xb98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xba0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xba8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbb0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbb8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbc0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbc8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbd0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbd8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbe0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbe8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbf0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xbf8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1e, 0x3f,
/* 0xc00: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc80: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xc98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xca0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xca8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcb0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcb8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcc0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcc8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcd0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcd8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xce0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xce8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcf0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xcf8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd00: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd68: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd70: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd78: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd80: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd88: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd90: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xd98: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xda0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xda8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdb0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdb8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdc0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdc8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdd0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdd8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xde0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xde8: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xdf0: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
/* 0xdf8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x8c, 0x9f,
/* 0xe00: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe08: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe10: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe18: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe20: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe28: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe30: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe38: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
/* 0xe40: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe48: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe50: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* 0xe58: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
/* 0xe60: */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
/* 0xe68: */  0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xe70: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xe78: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xe80: */  0x00, 0x00, 0x80, 0x00, 0x00, 0x80, 0x80, 0x80,
/* 0xe88: */  0x80, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xe90: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xe98: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xea0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xea8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xeb0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xeb8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xec0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xec8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xed0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xed8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xee0: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
/* 0xee8: */  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0,
/* 0xef0: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xef8: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xcf,
/* 0xf00: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf08: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf10: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf18: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf20: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf28: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf30: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf38: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf40: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf48: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf50: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf58: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf60: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
/* 0xf68: */  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe0,
/* 0xf70: */  0xc0, 0xc0, 0xc0, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf78: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe3,
/* 0xf80: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf88: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf90: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xf98: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xfa0: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xfa8: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
/* 0xfb0: */  0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0, 0xf0,
/* 0xfb8: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xfc0: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xfc8: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xfd0: */  0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
/* 0xfd8: */  0xf0, 0xf0, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
/* 0xfe0: */  0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
/* 0xfe8: */  0xf8, 0xf8, 0xf8, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
/* 0xff0: */  0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfe, 0xfe, 0xfe,
/* 0xff8: */  0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

uint16_t sid3_pulse(uint32_t acc, uint16_t pw) // 0-FFFF pulse width range
{
    return (((acc >> ((SID3_ACC_BITS - 16))) >= ((pw == 0xffff ? pw + 1 : pw)) ? (0xffff) : 0));
}

uint16_t sid3_saw(uint32_t acc) 
{
    return (acc >> (SID3_ACC_BITS - 16)) & (0xffff);
}

uint16_t sid3_triangle(uint32_t acc) 
{
    return (((acc > (1 << (SID3_ACC_BITS - 1))) ? ~acc : acc) >> (SID3_ACC_BITS - 17));
}

void sid3_clock_lfsr(sid3_channel* ch)
{
    uint32_t feedback = ch->lfsr & 1;
    ch->lfsr >>= 1;

    if (feedback) 
    {
        ch->lfsr ^= ch->lfsr_taps;
    }
}

uint16_t sid3_noise(uint32_t lfsr, bool one_bit) 
{
    return one_bit ? ((lfsr & 1) ? 0xffff : 0) : 
    
    ((((lfsr & 1) << 7) |
    ((lfsr & 4) << 4) |
    ((lfsr & 0x40) >> 1) |
    ((lfsr & 0x200) >> 5) |
    ((lfsr & 0x800) >> 8) |
    ((lfsr & 0x8000) >> 13) |
    ((lfsr & 0x40000) >> 17) |
    ((lfsr & 0x100000) >> 20)) << 8); //bits like in SID
}

uint16_t sid3_special_wave(SID3* sid3, uint32_t acc, uint8_t wave) 
{
    return sid3->special_waves[wave][acc >> (SID3_ACC_BITS - 14)];
}

#define fill_gap(i, how_far) \
if(i > (how_far - 1)) \
{ \
    if(sid3->exponential_output_to_envelope_counter[(i) - (how_far)] != 0) \
    { \
        sid3->exponential_output_to_envelope_counter[(i)] = sid3->exponential_output_to_envelope_counter[i - (how_far)]; \
        goto next; \
    } \
}

SID3* sid3_create()
{
    SID3* sid3 = (SID3*)malloc(sizeof(SID3));

    memset(sid3, 0, sizeof(SID3));

    for(int32_t i = 0; i < SID3_NUM_UNIQUE_SPECIAL_WAVES; i++)
    {
        for(int32_t j = 0; j < SID3_SPECIAL_WAVE_LENGTH; j++)
        {
            sid3->special_waves[i][j] = (uint16_t)(waveFuncsSID3[i]((double)j * 2.0 * M_PI / (double)SID3_SPECIAL_WAVE_LENGTH) * (double)0x7fff + (double)0x7fff);

            int32_t clipped = ((int32_t)sid3->special_waves[i][j] - 0x7fff) * 2;
            if (clipped < -0x7fff) clipped = -0x7fff;
            if (clipped > 0x7fff) clipped = 0x7fff;
            sid3->special_waves[i + SID3_NUM_UNIQUE_SPECIAL_WAVES][j] = clipped + 0x7fff;
        }
    }

    for (int32_t j = 0; j < SID3_SPECIAL_WAVE_LENGTH; j++)
    {
        int32_t clipped = (int32_t)(triangle((double)j * 2.0 * M_PI / (double)SID3_SPECIAL_WAVE_LENGTH) * (double)0x7fff) * 2;

        if (clipped < -0x7fff) clipped = -0x7fff;
        if (clipped > 0x7fff) clipped = 0x7fff;
        sid3->special_waves[SID3_NUM_UNIQUE_SPECIAL_WAVES * 2][j] = clipped + 0x7fff;

        clipped = (int32_t)(saw((double)j * 2.0 * M_PI / (double)SID3_SPECIAL_WAVE_LENGTH) * (double)0x7fff) * 2;

        if (clipped < -0x7fff) clipped = -0x7fff;
        if (clipped > 0x7fff) clipped = 0x7fff;
        sid3->special_waves[SID3_NUM_UNIQUE_SPECIAL_WAVES * 2 + 1][j] = clipped + 0x7fff;
    }

    double min_val = exp(-2.0);
    double max_val = exp(2.0);

    double scale_factor = (double)0xffff / (max_val - min_val);

    for(uint32_t i = 0; i < SID3_EXPONENTIAL_LUT_LENGTH; i++)
    {
        sid3->env_counter_to_exponential_output[i] = (exp(-2.0 + (double)i * 4.0 / (double)SID3_EXPONENTIAL_LUT_LENGTH) - min_val) * scale_factor;
    }

    sid3->env_counter_to_exponential_output[0] = 0; //just in case

    for(uint32_t i = 0; i < SID3_EXPONENTIAL_LUT_LENGTH; i++)
    {
        sid3->exponential_output_to_envelope_counter[(uint64_t)sid3->env_counter_to_exponential_output[i] * (uint64_t)SID3_EXPONENTIAL_LUT_LENGTH / (uint64_t)0xffff] = i << 8;
    }
    for(uint32_t i = 0; i < SID3_EXPONENTIAL_LUT_LENGTH; i++) //fill the gaps...
    {
        if(sid3->exponential_output_to_envelope_counter[i] > 0xff0000)
        {
            sid3->exponential_output_to_envelope_counter[i] = 0xff0000;
        }

        if(sid3->exponential_output_to_envelope_counter[i] == 0)
        {
            fill_gap(i, 1)
            fill_gap(i, 2)
            fill_gap(i, 3)
            fill_gap(i, 4)
            fill_gap(i, 5)
            fill_gap(i, 6)
        }

        next:;
    }

    return sid3;
}

void sid3_reset(SID3* sid3)
{
    SAFETY_HEADER

    for(int32_t i = 0; i < SID3_NUM_CHANNELS - 1; i++)
    {
        memset(&sid3->chan[i], 0, sizeof(sid3_channel));
        sid3->chan[i].adsr.hold_zero = true;
        sid3->chan[i].lfsr = 0x3fffffff;
        sid3->chan[i].lfsr_taps = 1 | (1 << 23) | (1 << 25) | (1 << 29); //https://docs.amd.com/v/u/en-US/xapp052 for 30 bits: 30, 6, 4, 1; but inverted since our LFSR is moving in different direction

        for(int j = 0; j < SID3_NUM_FILTERS; j++)
        {
            sid3->chan[i].filt.filt[j].Vlp = 0;
            sid3->chan[i].filt.filt[j].Vbp = 0;
            sid3->chan[i].filt.filt[j].Vhp = 0;
        }
    }

    memset(&sid3->wave_chan, 0, sizeof(sid3_wavetable_chan));
    sid3->wave_chan.adsr.hold_zero = true;

    for(int j = 0; j < SID3_NUM_FILTERS; j++)
    {
        sid3->wave_chan.filt.filt[j].Vlp = 0;
        sid3->wave_chan.filt.filt[j].Vbp = 0;
        sid3->wave_chan.filt.filt[j].Vhp = 0;
    }
}

void sid3_gate_bit(SID3* sid3, uint8_t gate, sid3_channel_adsr* adsr)
{
    // The rate counter is never reset, thus there will be a delay before the
    // envelope counter starts counting up (attack) or down (release).

    // Gate bit on: Start attack, decay, sustain.
    if (gate) 
    {
        if(adsr->state != ATTACK)
        {
            adsr->envelope_counter = (uint32_t)sid3->env_counter_to_exponential_output[adsr->envelope_counter >> 8] << 8;
        }

        adsr->state = ATTACK;
        adsr->envelope_speed = envspd_a(adsr->a); //todo: make it properly
        //adsr->envelope_counter = 0;

        // Switching to attack state unlocks the zero freeze.
        adsr->hold_zero = false;
    }
    // Gate bit off: Start release.
    else
    {
        if(adsr->state == ATTACK && !adsr->hold_zero)
        {
            adsr->envelope_counter = sid3->exponential_output_to_envelope_counter[adsr->envelope_counter >> 8];
        }

        adsr->state = RELEASE;
        adsr->envelope_speed = envspd_dr(adsr->r); //todo: make it properly
    }

    if(adsr->envelope_counter > 0xff0000) adsr->envelope_counter = 0xff0000;
}

void sid3_adsr_clock(SID3* sid3, sid3_channel_adsr* adsr)
{
    // Check whether the envelope counter is frozen at zero.
    if (adsr->hold_zero) 
    {
        return;
    }

    switch (adsr->state) 
    {
        case ATTACK:
        {
            adsr->envelope_counter += adsr->envelope_speed;

            if (adsr->envelope_counter >= 0xff0000) 
            {
                adsr->state = DECAY;
                adsr->envelope_speed = envspd_dr(adsr->d);
            }

            return; //do not do exponential approximation of attack
        }
        break;
        case DECAY:
        {
            adsr->envelope_counter -= adsr->envelope_speed;

            if(adsr->envelope_counter > 0xff0000) adsr->envelope_counter = 0xff0000;

            if(adsr->envelope_counter <= ((uint32_t)adsr->s << 16))
            {
                adsr->state = SUSTAIN;
                adsr->envelope_counter = (uint32_t)adsr->s << 16;
                adsr->envelope_speed = envspd_sr(adsr->sr);
            }

            if(adsr->envelope_counter <= adsr->envelope_speed || adsr->envelope_counter > 0xfff0000)
            {
                adsr->envelope_counter = 0;
                adsr->hold_zero = true;
            }
        }
        break;
        case SUSTAIN:
        case RELEASE:
        {
            adsr->envelope_counter -= adsr->envelope_speed;

            if(adsr->envelope_counter > 0xff0000) adsr->envelope_counter = 0xff0000;

            if(adsr->envelope_counter <= adsr->envelope_speed)
            {
                adsr->envelope_counter = 0;
                adsr->hold_zero = true;
            }
        }
        break;
    }
}

int32_t sid3_adsr_output(SID3* sid3, sid3_channel_adsr* adsr, int32_t input)
{
    if(adsr->hold_zero) return 0;

    if(adsr->state == ATTACK)
    {
        return (int32_t)((int64_t)input * (int64_t)adsr->envelope_counter / (int64_t)0xff0000 * (int64_t)adsr->vol / (int64_t)SID3_MAX_VOL);
    }
    else
    {
        return (int32_t)((int64_t)input * (int64_t)sid3->env_counter_to_exponential_output[adsr->envelope_counter >> 8] / (int64_t)0xffff * (int64_t)adsr->vol / (int64_t)SID3_MAX_VOL);
    }
}

void sid3_set_filter_settings(SID3* sid3, sid3_filter* filt)
{
    const double pi = 3.1415926535897932385;

    // Multiply with 1.048576 to facilitate division by 1 000 000 by right-
    // shifting 20 times (2 ^ 20 = 1048576).
    filt->w0 = (2.0*pi*(float)filt->cutoff) / ((double)sid3->clock_rate / 2.0) / 5.0; // "/ 5.0" bc we have 16 bit cutoff instead of 12-bit

    // Limit f0 to 16kHz to keep 1 cycle filter stable.
    const float w0_max_1 = (2.0*pi*20000.0) / ((double)sid3->clock_rate / 2.0);
    filt->w0_ceil_1 = filt->w0 <= w0_max_1 ? filt->w0 : w0_max_1;

    filt->_1024_div_Q = (1.0/(0.707 + 4.0*(float)filt->resonance/(float)0x0ff));

    filt->distortion_multiplier = (double)filt->distortion_level / 16.0;
    filt->tanh_distortion_multiplier = tanh(filt->distortion_multiplier);
}

int32_t sid3_get_waveform(SID3* sid3, sid3_channel* ch)
{
    if(ch->waveform == 0) return 0;

    int32_t wave = 0;

    switch(ch->mix_mode)
    {
        case SID3_MIX_8580:
        {
            switch(ch->waveform)
            {
                case SID3_WAVE_TRIANGLE:
                {
                    wave = sid3_triangle(ch->accumulator);
                    break;
                }
                case SID3_WAVE_SAW:
                {
                    wave = sid3_saw(ch->accumulator);
                    break;
                }
                case SID3_WAVE_SAW | SID3_WAVE_TRIANGLE:
                {
                    wave = wave8580__ST[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8;
                    break;
                }
                case SID3_WAVE_PULSE:
                {
                    wave = sid3_pulse(ch->accumulator, ch->pw);
                    break;
                }
                case SID3_WAVE_PULSE | SID3_WAVE_TRIANGLE:
                {
                    wave = (wave8580_P_T[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_pulse(ch->accumulator, ch->pw);
                    break;
                }
                case SID3_WAVE_PULSE | SID3_WAVE_SAW:
                {
                    wave = (wave8580_PS_[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_pulse(ch->accumulator, ch->pw);
                    break;
                }
                case SID3_WAVE_PULSE | SID3_WAVE_SAW | SID3_WAVE_TRIANGLE:
                {
                    wave = (wave8580_PST[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_pulse(ch->accumulator, ch->pw);
                    break;
                }
                case SID3_WAVE_NOISE:
                {
                    wave = sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
                    break;
                }
                case SID3_WAVE_NOISE | SID3_WAVE_TRIANGLE:
                {
                    wave = sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE) & sid3_triangle(ch->accumulator);
                    break;
                }
                case SID3_WAVE_NOISE | SID3_WAVE_SAW:
                {
                    wave = sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE) & sid3_saw(ch->accumulator);
                    break;
                }
                case SID3_WAVE_NOISE | SID3_WAVE_SAW | SID3_WAVE_TRIANGLE:
                {
                    wave = (wave8580__ST[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
                    break;
                }
                case SID3_WAVE_NOISE | SID3_WAVE_PULSE:
                {
                    wave = sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE) & sid3_pulse(ch->accumulator, ch->pw);
                    break;
                }
                case SID3_WAVE_NOISE | SID3_WAVE_PULSE | SID3_WAVE_TRIANGLE:
                {
                    wave = (wave8580_P_T[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
                    break;
                }
                case SID3_WAVE_NOISE | SID3_WAVE_PULSE | SID3_WAVE_SAW:
                {
                    wave = (wave8580_PS_[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
                    break;
                }
                case SID3_WAVE_NOISE | SID3_WAVE_PULSE | SID3_WAVE_SAW | SID3_WAVE_TRIANGLE:
                {
                    wave = (wave8580_PST[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
                    break;
                }
                case SID3_WAVE_SPECIAL:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_TRIANGLE:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & sid3_triangle(ch->accumulator);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_SAW:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & sid3_saw(ch->accumulator);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_SAW | SID3_WAVE_TRIANGLE:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & wave8580__ST[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8;
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_PULSE:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & sid3_pulse(ch->accumulator, ch->pw);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_PULSE | SID3_WAVE_TRIANGLE:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & (wave8580_P_T[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_pulse(ch->accumulator, ch->pw);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_PULSE | SID3_WAVE_SAW:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & (wave8580_PS_[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_pulse(ch->accumulator, ch->pw);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_PULSE | SID3_WAVE_SAW | SID3_WAVE_TRIANGLE:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & (wave8580_PST[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_pulse(ch->accumulator, ch->pw);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_NOISE:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_NOISE | SID3_WAVE_TRIANGLE:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE) & sid3_triangle(ch->accumulator);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_NOISE | SID3_WAVE_SAW:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE) & sid3_saw(ch->accumulator);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_NOISE | SID3_WAVE_SAW | SID3_WAVE_TRIANGLE:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & (wave8580__ST[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_NOISE | SID3_WAVE_PULSE:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE) & sid3_pulse(ch->accumulator, ch->pw);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_NOISE | SID3_WAVE_PULSE | SID3_WAVE_TRIANGLE:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & (wave8580_P_T[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_NOISE | SID3_WAVE_PULSE | SID3_WAVE_SAW:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & (wave8580_PS_[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
                    break;
                }
                case SID3_WAVE_SPECIAL | SID3_WAVE_NOISE | SID3_WAVE_PULSE | SID3_WAVE_SAW | SID3_WAVE_TRIANGLE:
                {
                    wave = sid3_special_wave(sid3, ch->accumulator, ch->special_wave) & (wave8580_PST[ch->accumulator >> (SID3_ACC_BITS - 12)] << 8) & sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
                    break;
                }
                default: break;
            }

            wave -= 0x8000;
            break;
        }
        case SID3_MIX_AND:
        {
            wave = 0xffff;

            if(ch->waveform & SID3_WAVE_TRIANGLE)
            {
                wave &= sid3_triangle(ch->accumulator);
            }
            if(ch->waveform & SID3_WAVE_SAW)
            {
                wave &= sid3_saw(ch->accumulator);
            }
            if(ch->waveform & SID3_WAVE_PULSE)
            {
                wave &= sid3_pulse(ch->accumulator, ch->pw);
            }
            if(ch->waveform & SID3_WAVE_NOISE)
            {
                wave &= sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
            }
            if(ch->waveform & SID3_WAVE_SPECIAL)
            {
                wave &= sid3_special_wave(sid3, ch->accumulator, ch->special_wave);
            }

            wave -= 0x8000;
            break;
        }
        case SID3_MIX_OR:
        {
            uint16_t wave_16 = 0;

            if(ch->waveform & SID3_WAVE_TRIANGLE)
            {
                wave_16 |= sid3_triangle(ch->accumulator);
            }
            if(ch->waveform & SID3_WAVE_SAW)
            {
                wave_16 |= sid3_saw(ch->accumulator);
            }
            if(ch->waveform & SID3_WAVE_PULSE)
            {
                wave_16 |= sid3_pulse(ch->accumulator, ch->pw);
            }
            if(ch->waveform & SID3_WAVE_NOISE)
            {
                wave_16 |= sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
            }
            if(ch->waveform & SID3_WAVE_SPECIAL)
            {
                wave_16 |= sid3_special_wave(sid3, ch->accumulator, ch->special_wave);
            }

            wave = wave_16 - 0x8000;
            break;
        }
        case SID3_MIX_XOR:
        {
            uint16_t wave_16 = 0;

            if(ch->waveform & SID3_WAVE_TRIANGLE)
            {
                wave_16 ^= sid3_triangle(ch->accumulator);
            }
            if(ch->waveform & SID3_WAVE_SAW)
            {
                wave_16 ^= sid3_saw(ch->accumulator);
            }
            if(ch->waveform & SID3_WAVE_PULSE)
            {
                wave_16 ^= sid3_pulse(ch->accumulator, ch->pw);
            }
            if(ch->waveform & SID3_WAVE_NOISE)
            {
                wave_16 ^= sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE);
            }
            if(ch->waveform & SID3_WAVE_SPECIAL)
            {
                wave_16 ^= sid3_special_wave(sid3, ch->accumulator, ch->special_wave);
            }

            wave = wave_16 - 0x8000;
            break;
        }
        case SID3_MIX_SUM:
        {
            if(ch->waveform & SID3_WAVE_TRIANGLE)
            {
                wave += (int32_t)sid3_triangle(ch->accumulator) - 0x8000;
            }
            if(ch->waveform & SID3_WAVE_SAW)
            {
                wave += (int32_t)sid3_saw(ch->accumulator) - 0x8000;
            }
            if(ch->waveform & SID3_WAVE_PULSE)
            {
                wave += (int32_t)sid3_pulse(ch->accumulator, ch->pw) - 0x8000;
            }
            if(ch->waveform & SID3_WAVE_NOISE)
            {
                wave += (int32_t)sid3_noise(ch->lfsr, ch->flags & SID3_CHAN_1_BIT_NOISE) - 0x8000;
            }
            if(ch->waveform & SID3_WAVE_SPECIAL)
            {
                wave += (int32_t)sid3_special_wave(sid3, ch->accumulator, ch->special_wave) - 0x8000;
            }
            break;
        }
        default: break;
    }

    return wave;
}

int32_t sid3_process_filters_block(sid3_channel* ch)
{
    int32_t output = 0;

    ch->clock_filter++;

    if(ch->clock_filter & 1)
    {
        for(uint8_t i = 0; i < SID3_NUM_FILTERS; i++)
        {
            if(ch->filt.filt[i].mode & SID3_FILTER_OUTPUT)
            {
                output += ch->filt.filt[i].output;
            }
        }

        return output;
    }

    for(uint8_t i = 0; i < SID3_NUM_FILTERS; i++)
    {
        ch->filt.filt[i].input = 0;
    }

    for(uint8_t i = 0; i < SID3_NUM_FILTERS; i++)
    {
        if(ch->filt.filt[i].mode & SID3_FILTER_CHANNEL_INPUT)
        {
            ch->filt.filt[i].input += ch->output_before_filter;
        }

        for(uint8_t j = 0; j < SID3_NUM_FILTERS; j++)
        {
            if(ch->filt.connection_matrix[i] & (1 << j))
            {
                ch->filt.filt[i].input += ch->filt.filt[j].output;
            }
        }
    }

    for(uint8_t i = 0; i < SID3_NUM_FILTERS; i++)
    {
        if(ch->filt.filt[i].mode & SID3_FILTER_ENABLE)
        {
            float Vi = ch->filt.filt[i].input;

            float dVbp = (ch->filt.filt[i].w0_ceil_1 * ch->filt.filt[i].Vhp);
            float dVlp = (ch->filt.filt[i].w0_ceil_1 * ch->filt.filt[i].Vbp);
            ch->filt.filt[i].Vbp += dVbp;
            ch->filt.filt[i].Vlp += dVlp;
            ch->filt.filt[i].Vhp = Vi - ch->filt.filt[i].Vlp - (ch->filt.filt[i].Vbp * ch->filt.filt[i]._1024_div_Q);

            float Vo;

            switch(ch->filt.filt[i].mode & SID3_FILTER_MODES_MASK)
            {
                case 0x0:
                default:
                    Vo = 0;
                    break;
                case SID3_FILTER_LP:
                    Vo = ch->filt.filt[i].Vlp;
                    break;
                case SID3_FILTER_HP:
                    Vo = ch->filt.filt[i].Vhp;
                    break;
                case SID3_FILTER_LP | SID3_FILTER_HP:
                    Vo = ch->filt.filt[i].Vlp + ch->filt.filt[i].Vhp;
                    break;
                case SID3_FILTER_BP:
                    Vo = ch->filt.filt[i].Vbp;
                    break;
                case SID3_FILTER_BP | SID3_FILTER_LP:
                    Vo = ch->filt.filt[i].Vlp + ch->filt.filt[i].Vbp;
                    break;
                case SID3_FILTER_BP | SID3_FILTER_HP:
                    Vo = ch->filt.filt[i].Vhp + ch->filt.filt[i].Vbp;
                    break;
                case SID3_FILTER_BP | SID3_FILTER_HP | SID3_FILTER_LP:
                    Vo = ch->filt.filt[i].Vlp + ch->filt.filt[i].Vbp + ch->filt.filt[i].Vhp;
                    break;
            }

            if(ch->filt.filt[i].distortion_level > 0)
            {
                if(Vo > 0.0)
                {
                    Vo = (tanh((Vo / 39767.0) * ch->filt.filt[i].distortion_multiplier) / ch->filt.filt[i].tanh_distortion_multiplier) * 39767.0;
                }
                else
                {
                    double ahh = (Vo / 39767.0) * ch->filt.filt[i].distortion_multiplier;
                    Vo = ((exp(ahh) - 1.0) / ch->filt.filt[i].tanh_distortion_multiplier) * 39767.0;
                }
            }

            ch->filt.filt[i].output = Vo * ch->filt.filt[i].output_volume / 0xff;
        }
        else
        {
            ch->filt.filt[i].output = 0;
        }

        if(ch->filt.filt[i].mode & SID3_FILTER_OUTPUT)
        {
            output += ch->filt.filt[i].output;
        }
    }

    return output;
}

int32_t sid3_process_wave_channel_filters_block(sid3_wavetable_chan* ch)
{
    int32_t output = 0;

    ch->clock_filter++;

    if(ch->clock_filter & 1)
    {
        for(uint8_t i = 0; i < SID3_NUM_FILTERS; i++)
        {
            if(ch->filt.filt[i].mode & SID3_FILTER_OUTPUT)
            {
                output += ch->filt.filt[i].output;
            }
        }

        return output;
    }

    for(uint8_t i = 0; i < SID3_NUM_FILTERS; i++)
    {
        ch->filt.filt[i].input = 0;
    }

    for(uint8_t i = 0; i < SID3_NUM_FILTERS; i++)
    {
        if(ch->filt.filt[i].mode & SID3_FILTER_CHANNEL_INPUT)
        {
            ch->filt.filt[i].input += ch->output_before_filter;
        }

        for(uint8_t j = 0; j < SID3_NUM_FILTERS; j++)
        {
            if(ch->filt.connection_matrix[i] & (1 << j))
            {
                ch->filt.filt[i].input += ch->filt.filt[j].output;
            }
        }
    }

    for(uint8_t i = 0; i < SID3_NUM_FILTERS; i++)
    {
        if(ch->filt.filt[i].mode & SID3_FILTER_ENABLE)
        {
            float Vi = ch->filt.filt[i].input;

            float dVbp = (ch->filt.filt[i].w0_ceil_1 * ch->filt.filt[i].Vhp);
            float dVlp = (ch->filt.filt[i].w0_ceil_1 * ch->filt.filt[i].Vbp);
            ch->filt.filt[i].Vbp += dVbp;
            ch->filt.filt[i].Vlp += dVlp;
            ch->filt.filt[i].Vhp = Vi - ch->filt.filt[i].Vlp - (ch->filt.filt[i].Vbp * ch->filt.filt[i]._1024_div_Q);

            float Vo;

            switch(ch->filt.filt[i].mode & SID3_FILTER_MODES_MASK)
            {
                case 0x0:
                default:
                    Vo = 0;
                    break;
                case SID3_FILTER_LP:
                    Vo = ch->filt.filt[i].Vlp;
                    break;
                case SID3_FILTER_HP:
                    Vo = ch->filt.filt[i].Vhp;
                    break;
                case SID3_FILTER_LP | SID3_FILTER_HP:
                    Vo = ch->filt.filt[i].Vlp + ch->filt.filt[i].Vhp;
                    break;
                case SID3_FILTER_BP:
                    Vo = ch->filt.filt[i].Vbp;
                    break;
                case SID3_FILTER_BP | SID3_FILTER_LP:
                    Vo = ch->filt.filt[i].Vlp + ch->filt.filt[i].Vbp;
                    break;
                case SID3_FILTER_BP | SID3_FILTER_HP:
                    Vo = ch->filt.filt[i].Vhp + ch->filt.filt[i].Vbp;
                    break;
                case SID3_FILTER_BP | SID3_FILTER_HP | SID3_FILTER_LP:
                    Vo = ch->filt.filt[i].Vlp + ch->filt.filt[i].Vbp + ch->filt.filt[i].Vhp;
                    break;
            }

            if(ch->filt.filt[i].distortion_level > 0)
            {
                if(Vo > 0.0)
                {
                    Vo = (tanh((Vo / 39767.0) * ch->filt.filt[i].distortion_multiplier) / ch->filt.filt[i].tanh_distortion_multiplier) * 39767.0;
                }
                else
                {
                    double ahh = (Vo / 39767.0) * ch->filt.filt[i].distortion_multiplier;
                    Vo = ((exp(ahh) - 1.0) / ch->filt.filt[i].tanh_distortion_multiplier) * 39767.0;
                }
            }

            ch->filt.filt[i].output = Vo * ch->filt.filt[i].output_volume / 0xff;
        }
        else
        {
            ch->filt.filt[i].output = 0;
        }

        if(ch->filt.filt[i].mode & SID3_FILTER_OUTPUT)
        {
            output += ch->filt.filt[i].output;
        }
    }

    return output;
}

void sid3_clock(SID3* sid3)
{
    //SAFETY_HEADER

    sid3->output_l = sid3->output_r = 0;

    for(int32_t i = 0; i < SID3_NUM_CHANNELS - 1; i++)
    {
        sid3_channel* ch = &sid3->chan[i];
        
        uint32_t prev_acc = ch->accumulator;
        uint32_t prev_noise_acc = ch->noise_accumulator;

        ch->accumulator += ch->frequency;
        ch->noise_accumulator += ch->noise_frequency;

        ch->sync_bit = 0;

        if(ch->accumulator & (1 << SID3_ACC_BITS))
        {
            ch->sync_bit = 1;
        }

        if(ch->flags & SID3_CHAN_ENABLE_HARD_SYNC)
        {
            if(ch->hard_sync_src == SID3_NUM_CHANNELS - 1) //wave chan
            {
                if(sid3->wave_chan.sync_bit)
                {
                    ch->accumulator = 0;
                    ch->noise_accumulator = 0;
                    ch->lfsr = 0x3fffffff;
                }
            }
            else
            {
                if(sid3->chan[ch->hard_sync_src].sync_bit)
                {
                    ch->accumulator = 0;
                    ch->noise_accumulator = 0;
                    ch->lfsr = 0x3fffffff;
                }
            }
        }

        int32_t waveform = 0;

        if(!ch->adsr.hold_zero)
        {
            uint32_t acc_state = ch->accumulator;
            uint32_t noise_acc_state = ch->noise_accumulator;

            if(ch->flags & SID3_CHAN_ENABLE_PHASE_MOD)
            {
                ch->accumulator += ch->phase_mod_source == (SID3_NUM_CHANNELS - 1) ? ((uint64_t)sid3->wave_channel_output << 18) : ((uint64_t)sid3->channel_output[ch->phase_mod_source] << 18);
                ch->noise_accumulator += ch->phase_mod_source == (SID3_NUM_CHANNELS - 1) ? ((uint64_t)sid3->wave_channel_output << 18) : ((uint64_t)sid3->channel_output[ch->phase_mod_source] << 18);
            }

            if(ch->feedback)
            {
                ch->accumulator += (ch->prev_output + ch->prev_output2) * ch->feedback;
            }

            ch->accumulator &= SID3_ACC_MASK;
            ch->noise_accumulator &= SID3_ACC_MASK;

            if((prev_noise_acc & ((uint32_t)1 << (SID3_ACC_BITS - 6))) != (ch->noise_accumulator & ((uint32_t)1 << (SID3_ACC_BITS - 6))))
            {
                sid3_clock_lfsr(ch);
            }

            waveform = sid3_get_waveform(sid3, ch);

            ch->accumulator = acc_state & SID3_ACC_MASK;
            ch->noise_accumulator = noise_acc_state & SID3_ACC_MASK;

            sid3->channel_signals_before_ADSR[i] = waveform;

            if(ch->flags & SID3_CHAN_ENABLE_RING_MOD)
            {
                uint8_t ring_mod_src = ch->ring_mod_src == SID3_NUM_CHANNELS ? i : ch->ring_mod_src; //SID3_NUM_CHANNELS = self-mod

                waveform = waveform * (ch->ring_mod_src == (SID3_NUM_CHANNELS - 1) ? sid3->wave_channel_signal_before_ADSR : sid3->channel_signals_before_ADSR[ring_mod_src]) / (int32_t)0xffff; //ring modulation is just multiplication of two signals!
            }
        }
        else
        {
            ch->accumulator &= SID3_ACC_MASK;
            ch->noise_accumulator &= SID3_ACC_MASK;
        }

        sid3_adsr_clock(sid3, &ch->adsr);

        int32_t output = 0;
        
        if(!ch->adsr.hold_zero)
        {
            ch->output_before_filter = sid3_adsr_output(sid3, &ch->adsr, waveform);

            if((ch->filt.filt[0].mode & SID3_FILTER_ENABLE) || (ch->filt.filt[1].mode & SID3_FILTER_ENABLE) ||
                (ch->filt.filt[2].mode & SID3_FILTER_ENABLE) || (ch->filt.filt[3].mode & SID3_FILTER_ENABLE))
            {
                output = sid3_process_filters_block(ch);
            }
            else
            {
                output = ch->output_before_filter;
            }
            
            if(ch->feedback)
            {
                ch->prev_output2 = ch->prev_output;
                ch->prev_output = output + 0xffff;
            }

            if(!sid3->muted[i])
            {
                sid3->output_l += output * ch->panning_left / 0x8f0 * ((ch->phase_inv & SID3_INV_SIGNAL_LEFT) ? -1 : 1);
                sid3->output_r += output * ch->panning_right / 0x8f0 * ((ch->phase_inv & SID3_INV_SIGNAL_RIGHT) ? -1 : 1);
            }
        }
        else
        {
            ch->output_before_filter = 0;

            for(int j = 0; j < SID3_NUM_FILTERS; j++)
            {
                if(ch->filt.filt[j].mode & SID3_FILTER_ENABLE)
                {
                    if(ch->filt.filt[j].output > 0)
                    {
                        ch->filt.filt[j].output--;
                    }
                    if(ch->filt.filt[j].output < 0)
                    {
                        ch->filt.filt[j].output++;
                    }
                }
            }
        }

        sid3->channel_output[i] = output;
    }

    //wavetable/streamed PCM sample channel:

    sid3_wavetable_chan* ch = &sid3->wave_chan;
        
    uint32_t prev_acc = ch->accumulator;

    ch->accumulator += ch->frequency;

    ch->sync_bit = 0;

    if(ch->accumulator & (1 << SID3_ACC_BITS))
    {
        ch->sync_bit = 1;
    }

    if(ch->flags & SID3_CHAN_ENABLE_HARD_SYNC)
    {
        if(ch->hard_sync_src == SID3_NUM_CHANNELS - 1) //wave chan
        {
            if(sid3->wave_chan.sync_bit)
            {
                ch->accumulator = 0;
            }
        }
        else
        {
            if(sid3->chan[ch->hard_sync_src].sync_bit)
            {
                ch->accumulator = 0;
            }
        }
    }

    int32_t waveform = 0;

    if(!ch->adsr.hold_zero)
    {
        uint32_t acc_state = ch->accumulator;

        if(ch->flags & SID3_CHAN_ENABLE_PHASE_MOD)
        {
            ch->accumulator += ch->phase_mod_source == (SID3_NUM_CHANNELS - 1) ? ((uint64_t)sid3->wave_channel_output << 18) : ((uint64_t)sid3->channel_output[ch->phase_mod_source] << 18);
        }

        ch->accumulator &= SID3_ACC_MASK;

        if(ch->mode)
        {
            waveform = (int32_t)ch->streamed_sample - 0x7fff;
        }
        else
        {
            waveform = ((int32_t)ch->wavetable[(ch->accumulator & SID3_ACC_MASK) >> (SID3_ACC_BITS - 8)] << 8) - 0x7fff;
        }

        ch->accumulator = acc_state & SID3_ACC_MASK;

        sid3->wave_channel_signal_before_ADSR = waveform;

        if(ch->flags & SID3_CHAN_ENABLE_RING_MOD)
        {
            uint8_t ring_mod_src = ch->ring_mod_src == SID3_NUM_CHANNELS ? 0xff : ch->ring_mod_src; //SID3_NUM_CHANNELS = self-mod

            waveform = waveform * (ch->ring_mod_src == 0xff ? sid3->wave_channel_signal_before_ADSR : sid3->channel_signals_before_ADSR[ring_mod_src]) / (int32_t)0xffff; //ring modulation is just multiplication of two signals!
        }
    }
    else
    {
        ch->accumulator &= SID3_ACC_MASK;
    }

    sid3_adsr_clock(sid3, &ch->adsr);

    int32_t output = 0;

    if(!ch->adsr.hold_zero)
    {
        ch->output_before_filter = sid3_adsr_output(sid3, &ch->adsr, waveform);
        
        if((ch->filt.filt[0].mode & SID3_FILTER_ENABLE) || (ch->filt.filt[1].mode & SID3_FILTER_ENABLE) ||
            (ch->filt.filt[2].mode & SID3_FILTER_ENABLE) || (ch->filt.filt[3].mode & SID3_FILTER_ENABLE))
        {
            output = sid3_process_wave_channel_filters_block(ch);
        }
        else
        {
            output = ch->output_before_filter;
        }

        if(!sid3->muted[SID3_NUM_CHANNELS - 1])
        {
            sid3->output_l += output * ch->panning_left / 0x8f0 * ((ch->phase_inv & SID3_INV_SIGNAL_LEFT) ? -1 : 1);
            sid3->output_r += output * ch->panning_right / 0x8f0 * ((ch->phase_inv & SID3_INV_SIGNAL_RIGHT) ? -1 : 1);
        }
    }
    else
    {
        ch->output_before_filter = 0;

        for(int j = 0; j < SID3_NUM_FILTERS; j++)
        {
            if(ch->filt.filt[j].mode & SID3_FILTER_ENABLE)
            {
                if(ch->filt.filt[j].output > 0)
                {
                    ch->filt.filt[j].output--;
                }
                if(ch->filt.filt[j].output < 0)
                {
                    ch->filt.filt[j].output++;
                }
            }
        }
    }

    sid3->wave_channel_output = output;
}

void sid3_write(SID3* sid3, uint16_t address, uint8_t data)
{
    SAFETY_HEADER

    uint8_t channel = address / SID3_REGISTERS_PER_CHANNEL;

    if(channel >= SID3_NUM_CHANNELS) return;

    switch(address % SID3_REGISTERS_PER_CHANNEL) //NB: only works if registers for each channel are the same and their addresses
    //are x + y*n, where x is address of channel 0 register, y is number of current channel and n is how many registers you have 
    //for each channel
    {
        case SID3_REGISTER_FLAGS:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                uint8_t prev_flags = sid3->chan[channel].flags;
                sid3->chan[channel].flags = data;

                if((prev_flags & SID3_CHAN_ENABLE_GATE) != (sid3->chan[channel].flags & SID3_CHAN_ENABLE_GATE))
                {
                    sid3_gate_bit(sid3, sid3->chan[channel].flags & SID3_CHAN_ENABLE_GATE, &sid3->chan[channel].adsr);
                }

                if(sid3->chan[channel].flags & SID3_CHAN_ENV_RESET)
                {
                    sid3->chan[channel].adsr.envelope_counter = 0;
                    sid3->chan[channel].adsr.state = ATTACK;
                    sid3->chan[channel].adsr.envelope_speed = envspd_a(sid3->chan[channel].adsr.a);
                    sid3->chan[channel].adsr.hold_zero = false;
                }

                if(sid3->chan[channel].flags & SID3_CHAN_PHASE_RESET)
                {
                    sid3->chan[channel].accumulator = 0;
                }

                if(sid3->chan[channel].flags & SID3_CHAN_NOISE_PHASE_RESET)
                {
                    sid3->chan[channel].noise_accumulator = 0;
                    sid3->chan[channel].lfsr = 0x3fffffff;
                }

                sid3->chan[channel].flags &= ~(SID3_CHAN_ENV_RESET | SID3_CHAN_NOISE_PHASE_RESET | SID3_CHAN_PHASE_RESET);
            }
            else
            {
                uint8_t prev_flags = sid3->wave_chan.flags;
                sid3->wave_chan.flags = data;

                if((prev_flags & SID3_CHAN_ENABLE_GATE) != (sid3->wave_chan.flags & SID3_CHAN_ENABLE_GATE))
                {
                    sid3_gate_bit(sid3, sid3->wave_chan.flags & SID3_CHAN_ENABLE_GATE, &sid3->wave_chan.adsr);
                }

                if(sid3->wave_chan.flags & SID3_CHAN_ENV_RESET)
                {
                    sid3->wave_chan.adsr.envelope_counter = 0;
                    sid3->wave_chan.adsr.state = ATTACK;
                    sid3->wave_chan.adsr.envelope_speed = envspd_a(sid3->wave_chan.adsr.a);
                    sid3->wave_chan.adsr.hold_zero = false;
                }

                if(sid3->wave_chan.flags & SID3_CHAN_PHASE_RESET)
                {
                    sid3->wave_chan.accumulator = 0;
                }

                sid3->wave_chan.flags &= ~(SID3_CHAN_ENV_RESET | SID3_CHAN_NOISE_PHASE_RESET | SID3_CHAN_PHASE_RESET);
            }
            break;
        }
        case SID3_REGISTER_ADSR_A:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].adsr.a = data;

                if(sid3->chan[channel].adsr.state == ATTACK) sid3->chan[channel].adsr.envelope_speed = envspd_a(sid3->chan[channel].adsr.a);
            }
            else
            {
                sid3->wave_chan.adsr.a = data;

                if(sid3->wave_chan.adsr.state == ATTACK) sid3->wave_chan.adsr.envelope_speed = envspd_a(sid3->wave_chan.adsr.a);
            }
            break;
        }
        case SID3_REGISTER_ADSR_D:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].adsr.d = data;

                if(sid3->chan[channel].adsr.state == DECAY) sid3->chan[channel].adsr.envelope_speed = envspd_dr(sid3->chan[channel].adsr.d);
            }
            else
            {
                sid3->wave_chan.adsr.d = data;

                if(sid3->wave_chan.adsr.state == DECAY) sid3->wave_chan.adsr.envelope_speed = envspd_dr(sid3->wave_chan.adsr.d);
            }
            break;
        }
        case SID3_REGISTER_ADSR_S:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].adsr.s = data;

                if(sid3->chan[channel].adsr.state == SUSTAIN) sid3->chan[channel].adsr.envelope_counter = sid3->chan[channel].adsr.s << 16;
            }
            else
            {
                sid3->wave_chan.adsr.s = data;

                if(sid3->wave_chan.adsr.state == SUSTAIN) sid3->wave_chan.adsr.envelope_counter = sid3->wave_chan.adsr.s << 16;
            }
            break;
        }
        case SID3_REGISTER_ADSR_SR:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].adsr.sr = data;

                if(sid3->chan[channel].adsr.state == SUSTAIN) sid3->chan[channel].adsr.envelope_speed = envspd_sr(sid3->chan[channel].adsr.sr);
            }
            else
            {
                sid3->wave_chan.adsr.sr = data;

                if(sid3->wave_chan.adsr.state == SUSTAIN) sid3->wave_chan.adsr.envelope_speed = envspd_sr(sid3->wave_chan.adsr.sr);
            }
            break;
        }
        case SID3_REGISTER_ADSR_R:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].adsr.r = data;

                if(sid3->chan[channel].adsr.state == RELEASE) sid3->chan[channel].adsr.envelope_speed = envspd_dr(sid3->chan[channel].adsr.r);
            }
            else
            {
                sid3->wave_chan.adsr.r = data;

                if(sid3->wave_chan.adsr.state == RELEASE) sid3->wave_chan.adsr.envelope_speed = envspd_dr(sid3->wave_chan.adsr.r);
            }
            break;
        }
        case SID3_REGISTER_WAVEFORM:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].waveform = data;
            }
            else
            {
                sid3->wave_chan.mode = data;
            }
            break;
        }
        case SID3_REGISTER_PW_HIGH:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].pw &= 0x00ff;
                sid3->chan[channel].pw |= data << 8;
            }
            else
            {
                sid3->wave_chan.wave_address = data;
            }
            break;
        }
        case SID3_REGISTER_PW_LOW:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].pw &= 0xff00;
                sid3->chan[channel].pw |= data;
            }
            else
            {
                sid3->wave_chan.wavetable[sid3->wave_chan.wave_address] = data;
            }
            break;
        }
        case SID3_REGISTER_SPECIAL_WAVE:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].special_wave = data;
            }
            break;
        }
        case SID3_REGISTER_FREQ_HIGH:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].frequency &= 0x00ffff;
                sid3->chan[channel].frequency |= data << 16;
            }
            else
            {
                sid3->wave_chan.frequency &= 0x00ffff;
                sid3->wave_chan.frequency |= data << 16;
            }
            break;
        }
        case SID3_REGISTER_FREQ_MID:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].frequency &= 0xff00ff;
                sid3->chan[channel].frequency |= data << 8;
            }
            else
            {
                sid3->wave_chan.frequency &= 0xff00ff;
                sid3->wave_chan.frequency |= data << 8;
            }
            break;
        }
        case SID3_REGISTER_FREQ_LOW:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].frequency &= 0xffff00;
                sid3->chan[channel].frequency |= data;
            }
            else
            {
                sid3->wave_chan.frequency &= 0xffff00;
                sid3->wave_chan.frequency |= data;
            }
            break;
        }
        case SID3_REGISTER_ADSR_VOL:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].adsr.vol = data;
            }
            else
            {
                sid3->wave_chan.adsr.vol = data;
            }
            break;
        }
        case SID3_REGISTER_MIXMODE:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].mix_mode = data;
            }
            break;
        }
        case SID3_REGISTER_RING_MOD_SRC:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].ring_mod_src = data;
            }
            else
            {
                sid3->wave_chan.ring_mod_src = data;
            }
            break;
        }
        case SID3_REGISTER_SYNC_SRC:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].hard_sync_src = data;
            }
            else
            {
                sid3->wave_chan.hard_sync_src = data;
            }
            break;
        }
        case SID3_REGISTER_FILT_MODE:
        case SID3_REGISTER_FILT_MODE + 1 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_MODE + 2 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_MODE + 3 * SID3_REGISTERS_PER_FILTER:
        {
            uint8_t filter = ((address % SID3_REGISTERS_PER_CHANNEL) - SID3_REGISTER_FILT_MODE) / SID3_REGISTERS_PER_FILTER;

            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].filt.filt[filter].mode = data;
            }
            else
            {
                sid3->wave_chan.filt.filt[filter].mode = data;
            }
            break;
        }
        case SID3_REGISTER_FILT_CUTOFF_HIGH:
        case SID3_REGISTER_FILT_CUTOFF_HIGH + 1 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_CUTOFF_HIGH + 2 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_CUTOFF_HIGH + 3 * SID3_REGISTERS_PER_FILTER:
        {
            uint8_t filter = ((address % SID3_REGISTERS_PER_CHANNEL) - SID3_REGISTER_FILT_MODE) / SID3_REGISTERS_PER_FILTER;

            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].filt.filt[filter].cutoff &= 0x00ff;
                sid3->chan[channel].filt.filt[filter].cutoff |= data << 8;
                sid3_set_filter_settings(sid3, &sid3->chan[channel].filt.filt[filter]);
            }
            else
            {
                sid3->wave_chan.filt.filt[filter].cutoff &= 0x00ff;
                sid3->wave_chan.filt.filt[filter].cutoff |= data << 8;
                sid3_set_filter_settings(sid3, &sid3->wave_chan.filt.filt[filter]);
            }
            break;
        }
        case SID3_REGISTER_FILT_CUTOFF_LOW:
        case SID3_REGISTER_FILT_CUTOFF_LOW + 1 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_CUTOFF_LOW + 2 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_CUTOFF_LOW + 3 * SID3_REGISTERS_PER_FILTER:
        {
            uint8_t filter = ((address % SID3_REGISTERS_PER_CHANNEL) - SID3_REGISTER_FILT_MODE) / SID3_REGISTERS_PER_FILTER;

            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].filt.filt[filter].cutoff &= 0xff00;
                sid3->chan[channel].filt.filt[filter].cutoff |= data;
                sid3_set_filter_settings(sid3, &sid3->chan[channel].filt.filt[filter]);
            }
            else
            {
                sid3->wave_chan.filt.filt[filter].cutoff &= 0xff00;
                sid3->wave_chan.filt.filt[filter].cutoff |= data;
                sid3_set_filter_settings(sid3, &sid3->wave_chan.filt.filt[filter]);
            }
            break;
        }
        case SID3_REGISTER_FILT_RESONANCE:
        case SID3_REGISTER_FILT_RESONANCE + 1 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_RESONANCE + 2 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_RESONANCE + 3 * SID3_REGISTERS_PER_FILTER:
        {
            uint8_t filter = ((address % SID3_REGISTERS_PER_CHANNEL) - SID3_REGISTER_FILT_MODE) / SID3_REGISTERS_PER_FILTER;

            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].filt.filt[filter].resonance = data;
                sid3_set_filter_settings(sid3, &sid3->chan[channel].filt.filt[filter]);
            }
            else
            {
                sid3->wave_chan.filt.filt[filter].resonance = data;
                sid3_set_filter_settings(sid3, &sid3->wave_chan.filt.filt[filter]);
            }
            break;
        }
        case SID3_REGISTER_FILT_DISTORTION:
        case SID3_REGISTER_FILT_DISTORTION + 1 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_DISTORTION + 2 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_DISTORTION + 3 * SID3_REGISTERS_PER_FILTER:
        {
            uint8_t filter = ((address % SID3_REGISTERS_PER_CHANNEL) - SID3_REGISTER_FILT_MODE) / SID3_REGISTERS_PER_FILTER;

            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].filt.filt[filter].distortion_level = data;
                sid3_set_filter_settings(sid3, &sid3->chan[channel].filt.filt[filter]);
            }
            else
            {
                sid3->wave_chan.filt.filt[filter].distortion_level = data;
                sid3_set_filter_settings(sid3, &sid3->wave_chan.filt.filt[filter]);
            }
            break;
        }
        case SID3_REGISTER_FILT_CONNECTION:
        case SID3_REGISTER_FILT_CONNECTION + 1 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_CONNECTION + 2 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_CONNECTION + 3 * SID3_REGISTERS_PER_FILTER:
        {
            uint8_t filter = ((address % SID3_REGISTERS_PER_CHANNEL) - SID3_REGISTER_FILT_MODE) / SID3_REGISTERS_PER_FILTER;

            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].filt.connection_matrix[filter] = data;
            }
            else
            {
                sid3->wave_chan.filt.connection_matrix[filter] = data;
            }
            break;
        }
        case SID3_REGISTER_FILT_OUTPUT_VOLUME:
        case SID3_REGISTER_FILT_OUTPUT_VOLUME + 1 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_OUTPUT_VOLUME + 2 * SID3_REGISTERS_PER_FILTER:
        case SID3_REGISTER_FILT_OUTPUT_VOLUME + 3 * SID3_REGISTERS_PER_FILTER:
        {
            uint8_t filter = ((address % SID3_REGISTERS_PER_CHANNEL) - SID3_REGISTER_FILT_MODE) / SID3_REGISTERS_PER_FILTER;

            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].filt.filt[filter].output_volume = data;
            }
            else
            {
                sid3->wave_chan.filt.filt[filter].output_volume = data;
            }
            break;
        }
        case SID3_REGISTER_PHASE_MOD_SRC:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].phase_mod_source = data;
            }
            else
            {
                sid3->wave_chan.phase_mod_source = data;
            }
            break;
        }
        case SID3_REGISTER_PAN_LEFT:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].panning_left = data;
            }
            else
            {
                sid3->wave_chan.panning_left = data;
            }
            break;
        }
        case SID3_REGISTER_PAN_RIGHT:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].panning_right = data;
            }
            else
            {
                sid3->wave_chan.panning_right = data;
            }
            break;
        }
        case SID3_REGISTER_NOISE_FREQ_HIGH:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].noise_frequency &= 0x00ffff;
                sid3->chan[channel].noise_frequency |= data << 16;
            }
            break;
        }
        case SID3_REGISTER_NOISE_FREQ_MID:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].noise_frequency &= 0xff00ff;
                sid3->chan[channel].noise_frequency |= data << 8;
            }
            break;
        }
        case SID3_REGISTER_NOISE_FREQ_LOW:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].noise_frequency &= 0xffff00;
                sid3->chan[channel].noise_frequency |= data;
            }
            break;
        }
        case SID3_REGISTER_NOISE_LFSR_HIGHEST:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].lfsr_taps &= 0x00ffffff;
                sid3->chan[channel].lfsr_taps |= (uint32_t)data << 24;

                sid3->chan[channel].lfsr_taps &= 0x3fffffff; //30 bits limit
            }
            break;
        }
        case SID3_REGISTER_NOISE_LFSR_HIGH:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].lfsr_taps &= 0xff00ffff;
                sid3->chan[channel].lfsr_taps |= data << 16;

                sid3->chan[channel].lfsr_taps &= 0x3fffffff;
            }
            break;
        }
        case SID3_REGISTER_NOISE_LFSR_MID:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].lfsr_taps &= 0xffff00ff;
                sid3->chan[channel].lfsr_taps |= data << 8;

                sid3->chan[channel].lfsr_taps &= 0x3fffffff;
            }
            break;
        }
        case SID3_REGISTER_NOISE_LFSR_LOW:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].lfsr_taps &= 0xffffff00;
                sid3->chan[channel].lfsr_taps |= data;

                sid3->chan[channel].lfsr_taps &= 0x3fffffff;
            }
            break;
        }
        case SID3_REGISTER_STREAMED_SAMPLE_HIGH:
        {
            if(channel == SID3_NUM_CHANNELS - 1)
            {
                sid3->wave_chan.streamed_sample &= 0x00ff;
                sid3->wave_chan.streamed_sample |= data << 8;
            }
            break;
        }
        case SID3_REGISTER_STREAMED_SAMPLE_LOW:
        {
            if(channel == SID3_NUM_CHANNELS - 1)
            {
                sid3->wave_chan.streamed_sample &= 0xff00;
                sid3->wave_chan.streamed_sample |= data;
            }
            break;
        }
        case SID3_REGISTER_PHASE_INVERSION:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].phase_inv = data;
            }
            else
            {
                sid3->wave_chan.phase_inv = data;
            }
            break;
        }
        case SID3_REGISTER_FEEDBACK:
        {
            if(channel != SID3_NUM_CHANNELS - 1)
            {
                sid3->chan[channel].feedback = (uint32_t)data * (uint32_t)data;
            }
            break;
        }
        default: break;
    }
}

void sid3_set_is_muted(SID3* sid3, uint8_t ch, bool mute)
{
    SAFETY_HEADER

    sid3->muted[ch] = mute;
}

void sid3_set_clock_rate(SID3* sid3, uint32_t clock)
{
    sid3->clock_rate = clock;
}

void sid3_free(SID3* sid3)
{
    SAFETY_HEADER

    free(sid3);
}