/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ICALCULATOR_H
#define ICALCULATOR_H


#include "icalculatorbase.h"


namespace iCalculatorKit
{
	template<class T> class DataVariable;
	template<class T, int type> class var;
	template<class T, int type> class ptr;
};


template<class T>
class iCalculator : public iCalculatorBase
{

public:

	typedef T number_t;
	typedef iCalculatorKit::DataVariable<T> result_t;

	typedef iCalculatorKit::var<T,0> real_var;
	typedef iCalculatorKit::var<T,1> bool_var;
	typedef iCalculatorKit::ptr<T,0> real_ptr;
	typedef iCalculatorKit::ptr<T,1> bool_ptr;

	iCalculator();

	inline const result_t* GetResult() { return static_cast<result_t*>(this->Result()); }

	const T* GetResultData() const;
	int GetResultSize() const;

	void AddVariable(const result_t *var); // this ensures type correctness

protected:

	virtual iCalculatorKit::Variable* CreateLiteral(const iString &str) const;
	virtual iCalculatorKit::Function* CreateFunction(const iString &str, int loc) const;

#ifdef I_DEBUG
	virtual void PrintStack(int iptr, int narg, int jmax, iCalculatorKit::Variable** stack);
#endif
};

#endif  // ICALCULATOR_H
