/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class StandardDoclet1_3_HtmlWriter
extends PrintWriter {
    protected final String htmlFilename;
    public static final String fileseparator = "/";

    public StandardDoclet1_3_HtmlWriter(String filename, String docencoding) throws IOException, UnsupportedEncodingException {
        super(StandardDoclet1_3_HtmlWriter.genWriter(null, filename, docencoding));
        this.htmlFilename = filename;
    }

    public StandardDoclet1_3_HtmlWriter(String path, String filename, String docencoding) throws IOException, UnsupportedEncodingException {
        super(StandardDoclet1_3_HtmlWriter.genWriter(path, filename, docencoding));
        this.htmlFilename = filename;
    }

    public static Writer genWriter(String path, String filename, String docencoding) throws IOException, UnsupportedEncodingException {
        FileOutputStream fos;
        if (path != null) {
            File dir = new File(path);
            if (!dir.exists()) {
                dir.createNewFile();
            }
            fos = new FileOutputStream((path.length() > 0 ? path + File.separator : "") + filename);
        } else {
            fos = new FileOutputStream(filename);
        }
        if (docencoding == null) {
            OutputStreamWriter oswriter = new OutputStreamWriter(fos);
            docencoding = oswriter.getEncoding();
            return oswriter;
        }
        return new OutputStreamWriter((OutputStream)fos, docencoding);
    }

    public void html() {
        this.println("<HTML>");
    }

    public void htmlEnd() {
        this.println("</HTML>");
    }

    public void body() {
        this.println("<BODY>");
    }

    public void body(String bgcolor) {
        this.println("<BODY BGCOLOR=\"" + bgcolor + "\">");
    }

    public void bodyEnd() {
        this.println("</BODY>");
    }

    public void title() {
        this.println("<TITLE>");
    }

    public void titleEnd() {
        this.println("</TITLE>");
    }

    public void ul() {
        this.println("<UL>");
    }

    public void ulEnd() {
        this.println("</UL>");
    }

    public void li() {
        this.print("<LI>");
    }

    public void li(String type) {
        this.print("<LI TYPE=\"" + type + "\">");
    }

    public void h1() {
        this.println("<H1>");
    }

    public void h1End() {
        this.println("</H1>");
    }

    public void h1(String text) {
        this.h1();
        this.println(text);
        this.h1End();
    }

    public void h2() {
        this.println("<H2>");
    }

    public void h2(String text) {
        this.h2();
        this.println(text);
        this.h2End();
    }

    public void h2End() {
        this.println("</H2>");
    }

    public void h3() {
        this.println("<H3>");
    }

    public void h3(String text) {
        this.h3();
        this.println(text);
        this.h3End();
    }

    public void h3End() {
        this.println("</H3>");
    }

    public void h4() {
        this.println("<H4>");
    }

    public void h4End() {
        this.println("</H4>");
    }

    public void h4(String text) {
        this.h4();
        this.println(text);
        this.h4End();
    }

    public void h5() {
        this.println("<H5>");
    }

    public void h5End() {
        this.println("</H5>");
    }

    public void img(String imggif, String imgname, int width, int height) {
        this.println("<IMG SRC=\"images/" + imggif + ".gif\"" + " WIDTH=\"" + width + "\" HEIGHT=\"" + height + "\" ALT=\"" + imgname + "\">");
    }

    public void menu() {
        this.println("<MENU>");
    }

    public void menuEnd() {
        this.println("</MENU>");
    }

    public void pre() {
        this.println("<PRE>");
    }

    public void preEnd() {
        this.println("</PRE>");
    }

    public void hr() {
        this.println("<HR>");
    }

    public void hr(int size, int widthPercent) {
        this.println("<HR SIZE=\"" + size + "\" WIDTH=\"" + widthPercent + "%\">");
    }

    public void hr(int size, String noshade) {
        this.println("<HR SIZE=\"" + size + "\" NOSHADE>");
    }

    public String getBold() {
        return "<B>";
    }

    public String getBoldEnd() {
        return "</B>";
    }

    public void bold() {
        this.print("<B>");
    }

    public void boldEnd() {
        this.print("</B>");
    }

    public void bold(String text) {
        this.bold();
        this.print(text);
        this.boldEnd();
    }

    public void italics(String text) {
        this.print("<I>");
        this.print(text);
        this.println("</I>");
    }

    public String italicsText(String text) {
        return "<I>" + text + "</I>";
    }

    public String codeText(String text) {
        return "<CODE>" + text + "</CODE>";
    }

    public void space() {
        this.print("&nbsp;");
    }

    public void dl() {
        this.println("<DL>");
    }

    public void dlEnd() {
        this.println("</DL>");
    }

    public void dt() {
        this.print("<DT>");
    }

    public void dd() {
        this.print("<DD>");
    }

    public void ddEnd() {
        this.println("</DD>");
    }

    public void sup() {
        this.println("<SUP>");
    }

    public void supEnd() {
        this.println("</SUP>");
    }

    public void font(String size) {
        this.println("<FONT SIZE=\"" + size + "\">");
    }

    public void fontStyle(String stylename) {
        this.print("<FONT CLASS=\"" + stylename + "\">");
    }

    public void fontSizeStyle(String size, String stylename) {
        this.println("<FONT size=\"" + size + "\" CLASS=\"" + stylename + "\">");
    }

    public void fontEnd() {
        this.print("</FONT>");
    }

    public String getFontColor(String color) {
        return "<FONT COLOR=\"" + color + "\">";
    }

    public String getFontEnd() {
        return "</FONT>";
    }

    public void center() {
        this.println("<CENTER>");
    }

    public void centerEnd() {
        this.println("</CENTER>");
    }

    public void aName(String name) {
        this.print("<A NAME=\"" + name + "\">");
    }

    public void aEnd() {
        this.print("</A>");
    }

    public void italic() {
        this.print("<I>");
    }

    public void italicEnd() {
        this.print("</I>");
    }

    public void anchor(String name, String content) {
        this.aName(name);
        this.print(content);
        this.aEnd();
    }

    public void anchor(String name) {
        this.aName(name);
        this.print("<!-- -->");
        this.aEnd();
    }

    public void p() {
        this.println();
        this.println("<P>");
    }

    public void br() {
        this.println();
        this.println("<BR>");
    }

    public void address() {
        this.println("<ADDRESS>");
    }

    public void addressEnd() {
        this.println("</ADDRESS>");
    }

    public void head() {
        this.println("<HEAD>");
    }

    public void headEnd() {
        this.println("</HEAD>");
    }

    public void code() {
        this.print("<CODE>");
    }

    public void codeEnd() {
        this.print("</CODE>");
    }

    public void em() {
        this.println("<EM>");
    }

    public void emEnd() {
        this.println("</EM>");
    }

    public void table(int border, String width, int cellpadding, int cellspacing) {
        this.println("\n<TABLE BORDER=\"" + border + "\" WIDTH=\"" + width + "\" CELLPADDING=\"" + cellpadding + "\" CELLSPACING=\"" + cellspacing + "\">");
    }

    public void table(int border, int cellpadding, int cellspacing) {
        this.println("\n<TABLE BORDER=\"" + border + "\" CELLPADDING=\"" + cellpadding + "\" CELLSPACING=\"" + cellspacing + "\">");
    }

    public void table(int border, String width) {
        this.println("\n<TABLE BORDER=\"" + border + "\" WIDTH=\"" + width + "\">");
    }

    public void table() {
        this.table(0, "100%");
    }

    public void tableEnd() {
        this.println("</TABLE>");
    }

    public void tr() {
        this.println("<TR>");
    }

    public void trEnd() {
        this.println("</TR>");
    }

    public void td() {
        this.print("<TD>");
    }

    public void tdNowrap() {
        this.print("<TD NOWRAP>");
    }

    public void tdWidth(String width) {
        this.print("<TD WIDTH=\"" + width + "\">");
    }

    public void tdEnd() {
        this.println("</TD>");
    }

    public void link(String str) {
        this.println("<LINK " + str + ">");
    }

    public void commentStart() {
        this.print("<!-- ");
    }

    public void commentEnd() {
        this.println("-->");
    }

    public void trBgcolorStyle(String color, String stylename) {
        this.println("<TR BGCOLOR=\"" + color + "\" CLASS=\"" + stylename + "\">");
    }

    public void trBgcolor(String color) {
        this.println("<TR BGCOLOR=\"" + color + "\">");
    }

    public void trAlignVAlign(String align, String valign) {
        this.println("<TR ALIGN=\"" + align + "\" VALIGN=\"" + valign + "\">");
    }

    public void tdColspan(int i) {
        this.print("<TD COLSPAN=" + i + ">");
    }

    public void tdBgcolorStyle(String color, String stylename) {
        this.print("<TD BGCOLOR=\"" + color + "\" CLASS=\"" + stylename + "\">");
    }

    public void tdColspanBgcolorStyle(int i, String color, String stylename) {
        this.print("<TD COLSPAN=" + i + " BGCOLOR=\"" + color + "\" CLASS=\"" + stylename + "\">");
    }

    public void tdAlign(String align) {
        this.print("<TD ALIGN=\"" + align + "\">");
    }

    public void tdVAlignClass(String align, String stylename) {
        this.print("<TD VALIGN=\"" + align + "\" CLASS=\"" + stylename + "\">");
    }

    public void tdVAlign(String valign) {
        this.print("<TD VALIGN=\"" + valign + "\">");
    }

    public void tdAlignVAlign(String align, String valign) {
        this.print("<TD ALIGN=\"" + align + "\" VALIGN=\"" + valign + "\">");
    }

    public void tdAlignRowspan(String align, int rowspan) {
        this.print("<TD ALIGN=\"" + align + "\" ROWSPAN=" + rowspan + ">");
    }

    public void tdAlignVAlignRowspan(String align, String valign, int rowspan) {
        this.print("<TD ALIGN=\"" + align + "\" VALIGN=\"" + valign + "\" ROWSPAN=" + rowspan + ">");
    }

    public void blockquote() {
        this.println("<BLOCKQUOTE>");
    }

    public void blockquoteEnd() {
        this.println("</BLOCKQUOTE>");
    }

    public String getCode() {
        return "<CODE>";
    }

    public String getCodeEnd() {
        return "</CODE>";
    }

    public void noFrames() {
        this.println("<NOFRAMES>");
    }

    public void noFramesEnd() {
        this.println("</NOFRAMES>");
    }
}

