/**********************************************************************
 Copyright 2004 by Paul Giannaros <ceruleanblaze@gmail.com>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) version 3.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 ***************************************************************************/

#include <QtGui/QApplication>
#include <QtCore/QFile>
#include <QtXml/QXmlInputSource>
#include <QtXml/QXmlSimpleReader>
#include <QtCore/QMap>
#include <iostream>
#include "xhtml2ssml.h"
#include "xmlelement.h"

int main(int argc, char *argv[]) {
    QApplication a(argc, argv);
    QFile f("demonstration.html");
    QXmlInputSource input(&f);
    QXmlSimpleReader reader;
    XHTMLToSSMLParser *parser = new XHTMLToSSMLParser();
    reader.setContentHandler(parser);
    reader.parse(input);
    std::cout << parser->convertedText() << "\n";
    delete parser;
    return 0;
}

