/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.html2ecs;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.ecs.filter.CharacterFilter;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Html2Ecs
extends Hashtable {
    private static Document doc;
    private static DOMParser parser;
    private static InputStream input;

    public Html2Ecs() {
        super(4);
        this.put("A", "org.apache.ecs.html.A");
        this.put("ABBR", "org.apache.ecs.html.Abbr");
        this.put("ACRONYM", "org.apache.ecs.html.Acronym");
        this.put("ADDRESS", "org.apache.ecs.html.Address");
        this.put("APPLET", "org.apache.ecs.html.Applet");
        this.put("AREA", "org.apache.ecs.html.Area");
        this.put("B", "org.apache.ecs.B");
        this.put("BASE", "org.apache.ecs.html.Base");
        this.put("BASEFONT", "org.apache.ecs.html.BaseFont");
        this.put("BDO", "org.apache.ecs.html.Bdo");
        this.put("BIG", "org.apache.ecs.html.Big");
        this.put("BLINK", "org.apache.ecs.html.Blink");
        this.put("BLOCKQUOTE", "org.apache.ecs.html.BlockQuote");
        this.put("BODY", "org.apache.ecs.html.Body");
        this.put("BR", "org.apache.ecs.html.BR");
        this.put("BUTTON", "org.apache.ecs.html.Button");
        this.put("CAPTION", "org.apache.ecs.html.Caption");
        this.put("CENTER", "org.apache.ecs.html.Center");
        this.put("CITE", "org.apache.ecs.html.Cite");
        this.put("CODE", "org.apache.ecs.html.Code");
        this.put("COL", "org.apache.ecs.html.Col");
        this.put("COLGROUP", "org.apache.ecs.html.ColGroup");
        this.put("COMMENT", "org.apache.ecs.html.Comment");
        this.put("DD", "org.apache.ecs.html.DD");
        this.put("DEL", "org.apache.ecs.html.Del");
        this.put("DFN", "org.apache.ecs.html.Dfn");
        this.put("DIV", "org.apache.ecs.html.Div");
        this.put("DL", "org.apache.ecs.html.DL");
        this.put("EM", "org.apache.ecs.html.EM");
        this.put("FILEDSET", "org.apache.ecs.html.FieldSet");
        this.put("FONT", "org.apache.ecs.html.Font");
        this.put("FORM", "org.apache.ecs.html.Form");
        this.put("FRAME", "org.apache.ecs.html.Frame");
        this.put("FRAMESET", "org.apache.ecs.html.FrameSet");
        this.put("H1", "org.apache.ecs.html.H1");
        this.put("H2", "org.apache.ecs.html.H2");
        this.put("H3", "org.apache.ecs.html.H3");
        this.put("H4", "org.apache.ecs.html.H4");
        this.put("H5", "org.apache.ecs.html.H5");
        this.put("H6", "org.apache.ecs.html.H6");
        this.put("HEAD", "org.apache.ecs.html.Head");
        this.put("HR", "org.apache.ecs.html.HR");
        this.put("HTML", "org.apache.ecs.html.Html");
        this.put("I", "org.apache.ecs.html.I");
        this.put("IFRAME", "org.apache.ecs.html.IFrame");
        this.put("IMG", "org.apache.ecs.html.IMG");
        this.put("INPUT", "org.apache.ecs.html.Input");
        this.put("INS", "org.apache.ecs.html.Ins");
        this.put("KBD", "org.apache.ecs.html.Kbd");
        this.put("LABEL", "org.apache.ecs.html.Label");
        this.put("LEGEND", "org.apache.ecs.html.Legend");
        this.put("LI", "org.apache.ecs.html.LI");
        this.put("LINK", "org.apache.ecs.html.Link");
        this.put("MAP", "org.apache.ecs.html.Map");
        this.put("META", "org.apache.ecs.html.Meta");
        this.put("NOBR", "org.apache.ecs.html.NOBR");
        this.put("NOFRAMES", "org.apache.ecs.html.NoFrames");
        this.put("NOSCRIPT", "org.apache.ecs.html.NoScript");
        this.put("OBJECT", "org.apache.ecs.html.ObjectElement");
        this.put("OL", "org.apache.ecs.html.OL");
        this.put("OPTGROUP", "org.apache.ecs.html.OptGroup");
        this.put("OPTION", "org.apache.ecs.html.Option");
        this.put("P", "org.apache.ecs.html.P");
        this.put("PARAM", "org.apache.ecs.html.Param");
        this.put("PRE", "org.apache.ecs.html.PRE");
        this.put("Q", "org.apache.ecs.html.Q");
        this.put("S", "org.apache.ecs.html.S");
        this.put("SAMP", "org.apache.ecs.html.Samp");
        this.put("SCRIPT", "org.apache.ecs.html.Script");
        this.put("SELECT", "org.apache.ecs.html.Select");
        this.put("SMALL", "org.apache.ecs.html.Small");
        this.put("SPAN", "org.apache.ecs.html.Span");
        this.put("STRIKE", "org.apache.ecs.html.Strike");
        this.put("STRONG", "org.apache.ecs.html.Strong");
        this.put("STYLE", "org.apache.ecs.html.Style");
        this.put("SUB", "org.apache.ecs.html.Sub");
        this.put("SUP", "org.apache.ecs.html.Sup");
        this.put("TABLE", "org.apache.ecs.html.Table");
        this.put("TBODY", "org.apache.ecs.html.TBody");
        this.put("TD", "org.apache.ecs.html.TD");
        this.put("THEAD", "org.apache.ecs.html.THead");
        this.put("TITLE", "org.apache.ecs.html.Title");
        this.put("TR", "org.apache.ecs.html.TR");
        this.put("TT", "org.apache.ecs.html.TT");
        this.put("U", "org.apache.ecs.html.U");
        this.put("UL", "org.apache.ecs.html.UL");
        this.put("VAR", "org.apache.ecs.html.Var");
    }

    private void constructAttributes(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Class<?> clazz = null;
        try {
            clazz = Class.forName((String)this.get(node.getNodeName().toUpperCase()));
        }
        catch (Exception exception) {}
        if (namedNodeMap != null && clazz != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                Method[] methodArray = clazz.getMethods();
                int n2 = 0;
                while (n2 < methodArray.length) {
                    if (methodArray[n2].getName().toLowerCase().endsWith(attr.getName().toLowerCase())) {
                        System.out.print(".");
                        System.out.print(methodArray[n2].getName());
                        System.out.print("(\"");
                        System.out.print(attr.getValue());
                        System.out.print("\")");
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    private void constructElement(Node node) {
        if (this.get(node.getNodeName().toUpperCase()) != null) {
            System.out.print("new ");
            System.out.print(this.get(node.getNodeName().toUpperCase()));
            System.out.print("()");
        }
        this.constructAttributes(node);
        this.constructValue(node);
    }

    private void constructValue(Node node) {
        CharacterFilter characterFilter = new CharacterFilter();
        characterFilter.addAttribute("\"", "&#34;");
        if (node.getNodeName().equals("#text") && node.getNodeValue().length() > 1) {
            System.out.print(".addElement(\"");
            System.out.print(node.getNodeValue());
            System.out.print("\")");
        }
    }

    public static void main(String[] stringArray) {
        Html2Ecs html2Ecs = new Html2Ecs();
        try {
            input = new FileInputStream(stringArray[0]);
            parser = new DOMParser();
            parser.parse(new InputSource(input));
            doc = parser.getDocument();
        }
        catch (SAXException sAXException) {
            System.out.println(sAXException.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
        html2Ecs.process(doc);
    }

    private void process(Node node) {
        while (node != null) {
            this.constructElement(node);
            if (node.hasChildNodes() && !node.getNodeName().equals("#document") && this.get(node.getNodeName()) == null) {
                System.out.print(".addElement(");
                this.process(node.getFirstChild());
                System.out.println(")");
            } else {
                this.process(node.getFirstChild());
            }
            node = node.getNextSibling();
            System.out.print("\n");
        }
    }
}

