/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.artifact.ant.shaded.ReaderFactory;
import org.apache.maven.artifact.ant.shaded.xml.XmlStreamReader;
import org.apache.maven.artifact.ant.shaded.xml.Xpp3DomBuilder;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenXpp3Reader {
    private boolean addDefaultEntities = true;

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (parsed.contains(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        parsed.add(tagName);
        return true;
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, null);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage());
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage());
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, null);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, null);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, null);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, null);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, null);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private Activation parseActivation(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Activation activation = new Activation();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "activeByDefault", null, parsed)) {
                activation.setActiveByDefault(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "activeByDefault", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "jdk", null, parsed)) {
                activation.setJdk(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "os", null, parsed)) {
                activation.setOs(this.parseActivationOS("os", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "property", null, parsed)) {
                activation.setProperty(this.parseActivationProperty("property", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "file", null, parsed)) {
                activation.setFile(this.parseActivationFile("file", parser, strict));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return activation;
    }

    private ActivationFile parseActivationFile(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ActivationFile activationFile = new ActivationFile();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "missing", null, parsed)) {
                activationFile.setMissing(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "exists", null, parsed)) {
                activationFile.setExists(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return activationFile;
    }

    private ActivationOS parseActivationOS(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ActivationOS activationOS = new ActivationOS();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                activationOS.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "family", null, parsed)) {
                activationOS.setFamily(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "arch", null, parsed)) {
                activationOS.setArch(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                activationOS.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return activationOS;
    }

    private ActivationProperty parseActivationProperty(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ActivationProperty activationProperty = new ActivationProperty();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                activationProperty.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "value", null, parsed)) {
                activationProperty.setValue(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return activationProperty;
    }

    private Build parseBuild(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Build build = new Build();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "sourceDirectory", null, parsed)) {
                build.setSourceDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scriptSourceDirectory", null, parsed)) {
                build.setScriptSourceDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "testSourceDirectory", null, parsed)) {
                build.setTestSourceDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                build.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "testOutputDirectory", null, parsed)) {
                build.setTestOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "extensions", null, parsed)) {
                ArrayList<Extension> extensions = new ArrayList<Extension>();
                build.setExtensions(extensions);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("extension")) {
                        extensions.add(this.parseExtension("extension", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "defaultGoal", null, parsed)) {
                build.setDefaultGoal(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "resources", null, parsed)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                build.setResources(resources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("resource")) {
                        resources.add(this.parseResource("resource", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "testResources", null, parsed)) {
                ArrayList<Resource> testResources = new ArrayList<Resource>();
                build.setTestResources(testResources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("testResource")) {
                        testResources.add(this.parseResource("testResource", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directory", null, parsed)) {
                build.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "finalName", null, parsed)) {
                build.setFinalName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filters", null, parsed)) {
                ArrayList<String> filters = new ArrayList<String>();
                build.setFilters(filters);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("filter")) {
                        filters.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginManagement", null, parsed)) {
                build.setPluginManagement(this.parsePluginManagement("pluginManagement", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                build.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return build;
    }

    private BuildBase parseBuildBase(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        BuildBase buildBase = new BuildBase();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "defaultGoal", null, parsed)) {
                buildBase.setDefaultGoal(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "resources", null, parsed)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                buildBase.setResources(resources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("resource")) {
                        resources.add(this.parseResource("resource", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "testResources", null, parsed)) {
                ArrayList<Resource> testResources = new ArrayList<Resource>();
                buildBase.setTestResources(testResources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("testResource")) {
                        testResources.add(this.parseResource("testResource", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directory", null, parsed)) {
                buildBase.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "finalName", null, parsed)) {
                buildBase.setFinalName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filters", null, parsed)) {
                ArrayList<String> filters = new ArrayList<String>();
                buildBase.setFilters(filters);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("filter")) {
                        filters.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginManagement", null, parsed)) {
                buildBase.setPluginManagement(this.parsePluginManagement("pluginManagement", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                buildBase.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return buildBase;
    }

    private CiManagement parseCiManagement(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        CiManagement ciManagement = new CiManagement();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "system", null, parsed)) {
                ciManagement.setSystem(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                ciManagement.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "notifiers", null, parsed)) {
                ArrayList<Notifier> notifiers = new ArrayList<Notifier>();
                ciManagement.setNotifiers(notifiers);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("notifier")) {
                        notifiers.add(this.parseNotifier("notifier", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return ciManagement;
    }

    private ConfigurationContainer parseConfigurationContainer(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ConfigurationContainer configurationContainer = new ConfigurationContainer();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "inherited", null, parsed)) {
                configurationContainer.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                configurationContainer.setConfiguration(Xpp3DomBuilder.build(parser));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return configurationContainer;
    }

    private Contributor parseContributor(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Contributor contributor = new Contributor();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                contributor.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "email", null, parsed)) {
                contributor.setEmail(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                contributor.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "organization", "organisation", parsed)) {
                contributor.setOrganization(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "organizationUrl", "organisationUrl", parsed)) {
                contributor.setOrganizationUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "roles", null, parsed)) {
                ArrayList<String> roles = new ArrayList<String>();
                contributor.setRoles(roles);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("role")) {
                        roles.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "timezone", null, parsed)) {
                contributor.setTimezone(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    contributor.addProperty(key, value);
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return contributor;
    }

    private Dependency parseDependency(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Dependency dependency = new Dependency();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                dependency.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                dependency.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                dependency.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                dependency.setType(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "classifier", null, parsed)) {
                dependency.setClassifier(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scope", null, parsed)) {
                dependency.setScope(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "systemPath", null, parsed)) {
                dependency.setSystemPath(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "exclusions", null, parsed)) {
                ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
                dependency.setExclusions(exclusions);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclusion")) {
                        exclusions.add(this.parseExclusion("exclusion", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "optional", null, parsed)) {
                dependency.setOptional(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "optional", parser, "false"));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return dependency;
    }

    private DependencyManagement parseDependencyManagement(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        DependencyManagement dependencyManagement = new DependencyManagement();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                dependencyManagement.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return dependencyManagement;
    }

    private DeploymentRepository parseDeploymentRepository(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        DeploymentRepository deploymentRepository = new DeploymentRepository();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "uniqueVersion", null, parsed)) {
                deploymentRepository.setUniqueVersion(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "uniqueVersion", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                deploymentRepository.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                deploymentRepository.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                deploymentRepository.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "layout", null, parsed)) {
                deploymentRepository.setLayout(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return deploymentRepository;
    }

    private Developer parseDeveloper(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Developer developer = new Developer();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                developer.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                developer.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "email", null, parsed)) {
                developer.setEmail(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                developer.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "organization", "organisation", parsed)) {
                developer.setOrganization(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "organizationUrl", "organisationUrl", parsed)) {
                developer.setOrganizationUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "roles", null, parsed)) {
                ArrayList<String> roles = new ArrayList<String>();
                developer.setRoles(roles);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("role")) {
                        roles.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "timezone", null, parsed)) {
                developer.setTimezone(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    developer.addProperty(key, value);
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return developer;
    }

    private DistributionManagement parseDistributionManagement(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        DistributionManagement distributionManagement = new DistributionManagement();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "repository", null, parsed)) {
                distributionManagement.setRepository(this.parseDeploymentRepository("repository", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "snapshotRepository", null, parsed)) {
                distributionManagement.setSnapshotRepository(this.parseDeploymentRepository("snapshotRepository", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "site", null, parsed)) {
                distributionManagement.setSite(this.parseSite("site", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "downloadUrl", null, parsed)) {
                distributionManagement.setDownloadUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "relocation", null, parsed)) {
                distributionManagement.setRelocation(this.parseRelocation("relocation", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "status", null, parsed)) {
                distributionManagement.setStatus(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return distributionManagement;
    }

    private Exclusion parseExclusion(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Exclusion exclusion = new Exclusion();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                exclusion.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                exclusion.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return exclusion;
    }

    private Extension parseExtension(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Extension extension = new Extension();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                extension.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                extension.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                extension.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return extension;
    }

    private FileSet parseFileSet(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        FileSet fileSet = new FileSet();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "directory", null, parsed)) {
                fileSet.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                fileSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                fileSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return fileSet;
    }

    private IssueManagement parseIssueManagement(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        IssueManagement issueManagement = new IssueManagement();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "system", null, parsed)) {
                issueManagement.setSystem(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                issueManagement.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return issueManagement;
    }

    private License parseLicense(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        License license = new License();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                license.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                license.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "distribution", null, parsed)) {
                license.setDistribution(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "comments", null, parsed)) {
                license.setComments(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return license;
    }

    private MailingList parseMailingList(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        MailingList mailingList = new MailingList();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                mailingList.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "subscribe", null, parsed)) {
                mailingList.setSubscribe(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "unsubscribe", null, parsed)) {
                mailingList.setUnsubscribe(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "post", null, parsed)) {
                mailingList.setPost(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "archive", null, parsed)) {
                mailingList.setArchive(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "otherArchives", null, parsed)) {
                ArrayList<String> otherArchives = new ArrayList<String>();
                mailingList.setOtherArchives(otherArchives);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("otherArchive")) {
                        otherArchives.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return mailingList;
    }

    private Model parseModel(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Model model = new Model();
        HashSet parsed = new HashSet();
        int eventType = parser.getEventType();
        boolean foundRoot = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals(tagName)) {
                    foundRoot = true;
                } else {
                    if (strict && !foundRoot) {
                        throw new XmlPullParserException("Expected root element '" + tagName + "' but found '" + parser.getName() + "'", parser, null);
                    }
                    if (this.checkFieldWithDuplicate(parser, "modelVersion", null, parsed)) {
                        model.setModelVersion(this.getTrimmedValue(parser.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser, "parent", null, parsed)) {
                        model.setParent(this.parseParent("parent", parser, strict));
                    } else if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                        model.setGroupId(this.getTrimmedValue(parser.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                        model.setArtifactId(this.getTrimmedValue(parser.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                        model.setVersion(this.getTrimmedValue(parser.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser, "packaging", null, parsed)) {
                        model.setPackaging(this.getTrimmedValue(parser.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                        model.setName(this.getTrimmedValue(parser.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser, "description", null, parsed)) {
                        model.setDescription(this.getTrimmedValue(parser.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                        model.setUrl(this.getTrimmedValue(parser.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser, "inceptionYear", null, parsed)) {
                        model.setInceptionYear(this.getTrimmedValue(parser.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser, "organization", "organisation", parsed)) {
                        model.setOrganization(this.parseOrganization("organization", parser, strict));
                    } else if (this.checkFieldWithDuplicate(parser, "licenses", null, parsed)) {
                        ArrayList<License> licenses = new ArrayList<License>();
                        model.setLicenses(licenses);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("license")) {
                                licenses.add(this.parseLicense("license", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "mailingLists", null, parsed)) {
                        ArrayList<MailingList> mailingLists = new ArrayList<MailingList>();
                        model.setMailingLists(mailingLists);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("mailingList")) {
                                mailingLists.add(this.parseMailingList("mailingList", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "developers", null, parsed)) {
                        ArrayList<Developer> developers = new ArrayList<Developer>();
                        model.setDevelopers(developers);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("developer")) {
                                developers.add(this.parseDeveloper("developer", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "contributors", null, parsed)) {
                        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
                        model.setContributors(contributors);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("contributor")) {
                                contributors.add(this.parseContributor("contributor", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "issueManagement", null, parsed)) {
                        model.setIssueManagement(this.parseIssueManagement("issueManagement", parser, strict));
                    } else if (this.checkFieldWithDuplicate(parser, "scm", null, parsed)) {
                        model.setScm(this.parseScm("scm", parser, strict));
                    } else if (this.checkFieldWithDuplicate(parser, "ciManagement", null, parsed)) {
                        model.setCiManagement(this.parseCiManagement("ciManagement", parser, strict));
                    } else if (this.checkFieldWithDuplicate(parser, "prerequisites", null, parsed)) {
                        model.setPrerequisites(this.parsePrerequisites("prerequisites", parser, strict));
                    } else if (this.checkFieldWithDuplicate(parser, "build", null, parsed)) {
                        model.setBuild(this.parseBuild("build", parser, strict));
                    } else if (this.checkFieldWithDuplicate(parser, "profiles", null, parsed)) {
                        ArrayList<Profile> profiles = new ArrayList<Profile>();
                        model.setProfiles(profiles);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("profile")) {
                                profiles.add(this.parseProfile("profile", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "distributionManagement", null, parsed)) {
                        model.setDistributionManagement(this.parseDistributionManagement("distributionManagement", parser, strict));
                    } else if (this.checkFieldWithDuplicate(parser, "modules", null, parsed)) {
                        ArrayList<String> modules = new ArrayList<String>();
                        model.setModules(modules);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("module")) {
                                modules.add(this.getTrimmedValue(parser.nextText()));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "repositories", null, parsed)) {
                        ArrayList<Repository> repositories = new ArrayList<Repository>();
                        model.setRepositories(repositories);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("repository")) {
                                repositories.add(this.parseRepository("repository", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "pluginRepositories", null, parsed)) {
                        ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                        model.setPluginRepositories(pluginRepositories);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("pluginRepository")) {
                                pluginRepositories.add(this.parseRepository("pluginRepository", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "dependencies", null, parsed)) {
                        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                        model.setDependencies(dependencies);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals("dependency")) {
                                dependencies.add(this.parseDependency("dependency", parser, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                            }
                            while (parser.next() != 3) {
                            }
                        }
                    } else if (this.checkFieldWithDuplicate(parser, "reports", null, parsed)) {
                        model.setReports(Xpp3DomBuilder.build(parser));
                    } else if (this.checkFieldWithDuplicate(parser, "reporting", null, parsed)) {
                        model.setReporting(this.parseReporting("reporting", parser, strict));
                    } else if (this.checkFieldWithDuplicate(parser, "dependencyManagement", null, parsed)) {
                        model.setDependencyManagement(this.parseDependencyManagement("dependencyManagement", parser, strict));
                    } else if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                        while (parser.nextTag() == 2) {
                            String key = parser.getName();
                            String value = parser.nextText().trim();
                            model.addProperty(key, value);
                        }
                    } else if (strict) {
                        throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
                    }
                }
            }
            eventType = parser.next();
        }
        return model;
    }

    private ModelBase parseModelBase(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ModelBase modelBase = new ModelBase();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "distributionManagement", null, parsed)) {
                modelBase.setDistributionManagement(this.parseDistributionManagement("distributionManagement", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "modules", null, parsed)) {
                ArrayList<String> modules = new ArrayList<String>();
                modelBase.setModules(modules);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("module")) {
                        modules.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                modelBase.setRepositories(repositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("repository")) {
                        repositories.add(this.parseRepository("repository", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                modelBase.setPluginRepositories(pluginRepositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("pluginRepository")) {
                        pluginRepositories.add(this.parseRepository("pluginRepository", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                modelBase.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reports", null, parsed)) {
                modelBase.setReports(Xpp3DomBuilder.build(parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reporting", null, parsed)) {
                modelBase.setReporting(this.parseReporting("reporting", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencyManagement", null, parsed)) {
                modelBase.setDependencyManagement(this.parseDependencyManagement("dependencyManagement", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    modelBase.addProperty(key, value);
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return modelBase;
    }

    private Notifier parseNotifier(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Notifier notifier = new Notifier();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                notifier.setType(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "sendOnError", null, parsed)) {
                notifier.setSendOnError(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "sendOnError", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "sendOnFailure", null, parsed)) {
                notifier.setSendOnFailure(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "sendOnFailure", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "sendOnSuccess", null, parsed)) {
                notifier.setSendOnSuccess(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "sendOnSuccess", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "sendOnWarning", null, parsed)) {
                notifier.setSendOnWarning(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "sendOnWarning", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "address", null, parsed)) {
                notifier.setAddress(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    notifier.addConfiguration(key, value);
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return notifier;
    }

    private Organization parseOrganization(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Organization organization = new Organization();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                organization.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                organization.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return organization;
    }

    private Parent parseParent(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Parent parent = new Parent();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                parent.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                parent.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                parent.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "relativePath", null, parsed)) {
                parent.setRelativePath(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return parent;
    }

    private PatternSet parsePatternSet(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PatternSet patternSet = new PatternSet();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                patternSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                patternSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return patternSet;
    }

    private Plugin parsePlugin(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Plugin plugin = new Plugin();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                plugin.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                plugin.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                plugin.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "extensions", null, parsed)) {
                plugin.setExtensions(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "extensions", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "executions", null, parsed)) {
                ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
                plugin.setExecutions(executions);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("execution")) {
                        executions.add(this.parsePluginExecution("execution", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                plugin.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "goals", null, parsed)) {
                plugin.setGoals(Xpp3DomBuilder.build(parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "inherited", null, parsed)) {
                plugin.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                plugin.setConfiguration(Xpp3DomBuilder.build(parser));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return plugin;
    }

    private PluginConfiguration parsePluginConfiguration(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "pluginManagement", null, parsed)) {
                pluginConfiguration.setPluginManagement(this.parsePluginManagement("pluginManagement", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginConfiguration.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return pluginConfiguration;
    }

    private PluginContainer parsePluginContainer(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PluginContainer pluginContainer = new PluginContainer();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginContainer.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return pluginContainer;
    }

    private PluginExecution parsePluginExecution(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PluginExecution pluginExecution = new PluginExecution();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                pluginExecution.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "phase", null, parsed)) {
                pluginExecution.setPhase(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "goals", null, parsed)) {
                ArrayList<String> goals = new ArrayList<String>();
                pluginExecution.setGoals(goals);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("goal")) {
                        goals.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "inherited", null, parsed)) {
                pluginExecution.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                pluginExecution.setConfiguration(Xpp3DomBuilder.build(parser));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return pluginExecution;
    }

    private PluginManagement parsePluginManagement(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PluginManagement pluginManagement = new PluginManagement();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginManagement.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return pluginManagement;
    }

    private Prerequisites parsePrerequisites(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Prerequisites prerequisites = new Prerequisites();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "maven", null, parsed)) {
                prerequisites.setMaven(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return prerequisites;
    }

    private Profile parseProfile(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Profile profile = new Profile();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                profile.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "activation", null, parsed)) {
                profile.setActivation(this.parseActivation("activation", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "build", null, parsed)) {
                profile.setBuild(this.parseBuildBase("build", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "distributionManagement", null, parsed)) {
                profile.setDistributionManagement(this.parseDistributionManagement("distributionManagement", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "modules", null, parsed)) {
                ArrayList<String> modules = new ArrayList<String>();
                profile.setModules(modules);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("module")) {
                        modules.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                profile.setRepositories(repositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("repository")) {
                        repositories.add(this.parseRepository("repository", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                profile.setPluginRepositories(pluginRepositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("pluginRepository")) {
                        pluginRepositories.add(this.parseRepository("pluginRepository", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                profile.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reports", null, parsed)) {
                profile.setReports(Xpp3DomBuilder.build(parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reporting", null, parsed)) {
                profile.setReporting(this.parseReporting("reporting", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "dependencyManagement", null, parsed)) {
                profile.setDependencyManagement(this.parseDependencyManagement("dependencyManagement", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    profile.addProperty(key, value);
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return profile;
    }

    private Relocation parseRelocation(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Relocation relocation = new Relocation();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                relocation.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                relocation.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                relocation.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "message", null, parsed)) {
                relocation.setMessage(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return relocation;
    }

    private ReportPlugin parseReportPlugin(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ReportPlugin reportPlugin = new ReportPlugin();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                reportPlugin.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                reportPlugin.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                reportPlugin.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "inherited", null, parsed)) {
                reportPlugin.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                reportPlugin.setConfiguration(Xpp3DomBuilder.build(parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reportSets", null, parsed)) {
                ArrayList<ReportSet> reportSets = new ArrayList<ReportSet>();
                reportPlugin.setReportSets(reportSets);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("reportSet")) {
                        reportSets.add(this.parseReportSet("reportSet", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return reportPlugin;
    }

    private ReportSet parseReportSet(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        ReportSet reportSet = new ReportSet();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                reportSet.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                reportSet.setConfiguration(Xpp3DomBuilder.build(parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "inherited", null, parsed)) {
                reportSet.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "reports", null, parsed)) {
                ArrayList<String> reports = new ArrayList<String>();
                reportSet.setReports(reports);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("report")) {
                        reports.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return reportSet;
    }

    private Reporting parseReporting(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Reporting reporting = new Reporting();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "excludeDefaults", null, parsed)) {
                reporting.setExcludeDefaultsValue(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "outputDirectory", null, parsed)) {
                reporting.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "plugins", null, parsed)) {
                ArrayList<ReportPlugin> plugins = new ArrayList<ReportPlugin>();
                reporting.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parseReportPlugin("plugin", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return reporting;
    }

    private Repository parseRepository(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Repository repository = new Repository();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "releases", null, parsed)) {
                repository.setReleases(this.parseRepositoryPolicy("releases", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "snapshots", null, parsed)) {
                repository.setSnapshots(this.parseRepositoryPolicy("snapshots", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                repository.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                repository.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                repository.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "layout", null, parsed)) {
                repository.setLayout(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return repository;
    }

    private RepositoryBase parseRepositoryBase(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        RepositoryBase repositoryBase = new RepositoryBase();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                repositoryBase.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                repositoryBase.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                repositoryBase.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "layout", null, parsed)) {
                repositoryBase.setLayout(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return repositoryBase;
    }

    private RepositoryPolicy parseRepositoryPolicy(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "enabled", null, parsed)) {
                repositoryPolicy.setEnabled(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "enabled", parser, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "updatePolicy", null, parsed)) {
                repositoryPolicy.setUpdatePolicy(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "checksumPolicy", null, parsed)) {
                repositoryPolicy.setChecksumPolicy(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return repositoryPolicy;
    }

    private Resource parseResource(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Resource resource = new Resource();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "targetPath", null, parsed)) {
                resource.setTargetPath(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filtering", null, parsed)) {
                resource.setFiltering(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "filtering", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "mergeId", null, parsed)) {
                resource.setMergeId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "directory", null, parsed)) {
                resource.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                resource.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                resource.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return resource;
    }

    private Scm parseScm(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Scm scm = new Scm();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "connection", null, parsed)) {
                scm.setConnection(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "developerConnection", null, parsed)) {
                scm.setDeveloperConnection(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "tag", null, parsed)) {
                scm.setTag(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                scm.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return scm;
    }

    private Site parseSite(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Site site = new Site();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                site.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                site.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "url", null, parsed)) {
                site.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return site;
    }

    public Model read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        if (this.addDefaultEntities) {
            parser.defineEntityReplacementText("nbsp", "\u00a0");
            parser.defineEntityReplacementText("iexcl", "\u00a1");
            parser.defineEntityReplacementText("cent", "\u00a2");
            parser.defineEntityReplacementText("pound", "\u00a3");
            parser.defineEntityReplacementText("curren", "\u00a4");
            parser.defineEntityReplacementText("yen", "\u00a5");
            parser.defineEntityReplacementText("brvbar", "\u00a6");
            parser.defineEntityReplacementText("sect", "\u00a7");
            parser.defineEntityReplacementText("uml", "\u00a8");
            parser.defineEntityReplacementText("copy", "\u00a9");
            parser.defineEntityReplacementText("ordf", "\u00aa");
            parser.defineEntityReplacementText("laquo", "\u00ab");
            parser.defineEntityReplacementText("not", "\u00ac");
            parser.defineEntityReplacementText("shy", "\u00ad");
            parser.defineEntityReplacementText("reg", "\u00ae");
            parser.defineEntityReplacementText("macr", "\u00af");
            parser.defineEntityReplacementText("deg", "\u00b0");
            parser.defineEntityReplacementText("plusmn", "\u00b1");
            parser.defineEntityReplacementText("sup2", "\u00b2");
            parser.defineEntityReplacementText("sup3", "\u00b3");
            parser.defineEntityReplacementText("acute", "\u00b4");
            parser.defineEntityReplacementText("micro", "\u00b5");
            parser.defineEntityReplacementText("para", "\u00b6");
            parser.defineEntityReplacementText("middot", "\u00b7");
            parser.defineEntityReplacementText("cedil", "\u00b8");
            parser.defineEntityReplacementText("sup1", "\u00b9");
            parser.defineEntityReplacementText("ordm", "\u00ba");
            parser.defineEntityReplacementText("raquo", "\u00bb");
            parser.defineEntityReplacementText("frac14", "\u00bc");
            parser.defineEntityReplacementText("frac12", "\u00bd");
            parser.defineEntityReplacementText("frac34", "\u00be");
            parser.defineEntityReplacementText("iquest", "\u00bf");
            parser.defineEntityReplacementText("Agrave", "\u00c0");
            parser.defineEntityReplacementText("Aacute", "\u00c1");
            parser.defineEntityReplacementText("Acirc", "\u00c2");
            parser.defineEntityReplacementText("Atilde", "\u00c3");
            parser.defineEntityReplacementText("Auml", "\u00c4");
            parser.defineEntityReplacementText("Aring", "\u00c5");
            parser.defineEntityReplacementText("AElig", "\u00c6");
            parser.defineEntityReplacementText("Ccedil", "\u00c7");
            parser.defineEntityReplacementText("Egrave", "\u00c8");
            parser.defineEntityReplacementText("Eacute", "\u00c9");
            parser.defineEntityReplacementText("Ecirc", "\u00ca");
            parser.defineEntityReplacementText("Euml", "\u00cb");
            parser.defineEntityReplacementText("Igrave", "\u00cc");
            parser.defineEntityReplacementText("Iacute", "\u00cd");
            parser.defineEntityReplacementText("Icirc", "\u00ce");
            parser.defineEntityReplacementText("Iuml", "\u00cf");
            parser.defineEntityReplacementText("ETH", "\u00d0");
            parser.defineEntityReplacementText("Ntilde", "\u00d1");
            parser.defineEntityReplacementText("Ograve", "\u00d2");
            parser.defineEntityReplacementText("Oacute", "\u00d3");
            parser.defineEntityReplacementText("Ocirc", "\u00d4");
            parser.defineEntityReplacementText("Otilde", "\u00d5");
            parser.defineEntityReplacementText("Ouml", "\u00d6");
            parser.defineEntityReplacementText("times", "\u00d7");
            parser.defineEntityReplacementText("Oslash", "\u00d8");
            parser.defineEntityReplacementText("Ugrave", "\u00d9");
            parser.defineEntityReplacementText("Uacute", "\u00da");
            parser.defineEntityReplacementText("Ucirc", "\u00db");
            parser.defineEntityReplacementText("Uuml", "\u00dc");
            parser.defineEntityReplacementText("Yacute", "\u00dd");
            parser.defineEntityReplacementText("THORN", "\u00de");
            parser.defineEntityReplacementText("szlig", "\u00df");
            parser.defineEntityReplacementText("agrave", "\u00e0");
            parser.defineEntityReplacementText("aacute", "\u00e1");
            parser.defineEntityReplacementText("acirc", "\u00e2");
            parser.defineEntityReplacementText("atilde", "\u00e3");
            parser.defineEntityReplacementText("auml", "\u00e4");
            parser.defineEntityReplacementText("aring", "\u00e5");
            parser.defineEntityReplacementText("aelig", "\u00e6");
            parser.defineEntityReplacementText("ccedil", "\u00e7");
            parser.defineEntityReplacementText("egrave", "\u00e8");
            parser.defineEntityReplacementText("eacute", "\u00e9");
            parser.defineEntityReplacementText("ecirc", "\u00ea");
            parser.defineEntityReplacementText("euml", "\u00eb");
            parser.defineEntityReplacementText("igrave", "\u00ec");
            parser.defineEntityReplacementText("iacute", "\u00ed");
            parser.defineEntityReplacementText("icirc", "\u00ee");
            parser.defineEntityReplacementText("iuml", "\u00ef");
            parser.defineEntityReplacementText("eth", "\u00f0");
            parser.defineEntityReplacementText("ntilde", "\u00f1");
            parser.defineEntityReplacementText("ograve", "\u00f2");
            parser.defineEntityReplacementText("oacute", "\u00f3");
            parser.defineEntityReplacementText("ocirc", "\u00f4");
            parser.defineEntityReplacementText("otilde", "\u00f5");
            parser.defineEntityReplacementText("ouml", "\u00f6");
            parser.defineEntityReplacementText("divide", "\u00f7");
            parser.defineEntityReplacementText("oslash", "\u00f8");
            parser.defineEntityReplacementText("ugrave", "\u00f9");
            parser.defineEntityReplacementText("uacute", "\u00fa");
            parser.defineEntityReplacementText("ucirc", "\u00fb");
            parser.defineEntityReplacementText("uuml", "\u00fc");
            parser.defineEntityReplacementText("yacute", "\u00fd");
            parser.defineEntityReplacementText("thorn", "\u00fe");
            parser.defineEntityReplacementText("yuml", "\u00ff");
            parser.defineEntityReplacementText("OElig", "\u0152");
            parser.defineEntityReplacementText("oelig", "\u0153");
            parser.defineEntityReplacementText("Scaron", "\u0160");
            parser.defineEntityReplacementText("scaron", "\u0161");
            parser.defineEntityReplacementText("Yuml", "\u0178");
            parser.defineEntityReplacementText("circ", "\u02c6");
            parser.defineEntityReplacementText("tilde", "\u02dc");
            parser.defineEntityReplacementText("ensp", "\u2002");
            parser.defineEntityReplacementText("emsp", "\u2003");
            parser.defineEntityReplacementText("thinsp", "\u2009");
            parser.defineEntityReplacementText("zwnj", "\u200c");
            parser.defineEntityReplacementText("zwj", "\u200d");
            parser.defineEntityReplacementText("lrm", "\u200e");
            parser.defineEntityReplacementText("rlm", "\u200f");
            parser.defineEntityReplacementText("ndash", "\u2013");
            parser.defineEntityReplacementText("mdash", "\u2014");
            parser.defineEntityReplacementText("lsquo", "\u2018");
            parser.defineEntityReplacementText("rsquo", "\u2019");
            parser.defineEntityReplacementText("sbquo", "\u201a");
            parser.defineEntityReplacementText("ldquo", "\u201c");
            parser.defineEntityReplacementText("rdquo", "\u201d");
            parser.defineEntityReplacementText("bdquo", "\u201e");
            parser.defineEntityReplacementText("dagger", "\u2020");
            parser.defineEntityReplacementText("Dagger", "\u2021");
            parser.defineEntityReplacementText("permil", "\u2030");
            parser.defineEntityReplacementText("lsaquo", "\u2039");
            parser.defineEntityReplacementText("rsaquo", "\u203a");
            parser.defineEntityReplacementText("euro", "\u20ac");
            parser.defineEntityReplacementText("fnof", "\u0192");
            parser.defineEntityReplacementText("Alpha", "\u0391");
            parser.defineEntityReplacementText("Beta", "\u0392");
            parser.defineEntityReplacementText("Gamma", "\u0393");
            parser.defineEntityReplacementText("Delta", "\u0394");
            parser.defineEntityReplacementText("Epsilon", "\u0395");
            parser.defineEntityReplacementText("Zeta", "\u0396");
            parser.defineEntityReplacementText("Eta", "\u0397");
            parser.defineEntityReplacementText("Theta", "\u0398");
            parser.defineEntityReplacementText("Iota", "\u0399");
            parser.defineEntityReplacementText("Kappa", "\u039a");
            parser.defineEntityReplacementText("Lambda", "\u039b");
            parser.defineEntityReplacementText("Mu", "\u039c");
            parser.defineEntityReplacementText("Nu", "\u039d");
            parser.defineEntityReplacementText("Xi", "\u039e");
            parser.defineEntityReplacementText("Omicron", "\u039f");
            parser.defineEntityReplacementText("Pi", "\u03a0");
            parser.defineEntityReplacementText("Rho", "\u03a1");
            parser.defineEntityReplacementText("Sigma", "\u03a3");
            parser.defineEntityReplacementText("Tau", "\u03a4");
            parser.defineEntityReplacementText("Upsilon", "\u03a5");
            parser.defineEntityReplacementText("Phi", "\u03a6");
            parser.defineEntityReplacementText("Chi", "\u03a7");
            parser.defineEntityReplacementText("Psi", "\u03a8");
            parser.defineEntityReplacementText("Omega", "\u03a9");
            parser.defineEntityReplacementText("alpha", "\u03b1");
            parser.defineEntityReplacementText("beta", "\u03b2");
            parser.defineEntityReplacementText("gamma", "\u03b3");
            parser.defineEntityReplacementText("delta", "\u03b4");
            parser.defineEntityReplacementText("epsilon", "\u03b5");
            parser.defineEntityReplacementText("zeta", "\u03b6");
            parser.defineEntityReplacementText("eta", "\u03b7");
            parser.defineEntityReplacementText("theta", "\u03b8");
            parser.defineEntityReplacementText("iota", "\u03b9");
            parser.defineEntityReplacementText("kappa", "\u03ba");
            parser.defineEntityReplacementText("lambda", "\u03bb");
            parser.defineEntityReplacementText("mu", "\u03bc");
            parser.defineEntityReplacementText("nu", "\u03bd");
            parser.defineEntityReplacementText("xi", "\u03be");
            parser.defineEntityReplacementText("omicron", "\u03bf");
            parser.defineEntityReplacementText("pi", "\u03c0");
            parser.defineEntityReplacementText("rho", "\u03c1");
            parser.defineEntityReplacementText("sigmaf", "\u03c2");
            parser.defineEntityReplacementText("sigma", "\u03c3");
            parser.defineEntityReplacementText("tau", "\u03c4");
            parser.defineEntityReplacementText("upsilon", "\u03c5");
            parser.defineEntityReplacementText("phi", "\u03c6");
            parser.defineEntityReplacementText("chi", "\u03c7");
            parser.defineEntityReplacementText("psi", "\u03c8");
            parser.defineEntityReplacementText("omega", "\u03c9");
            parser.defineEntityReplacementText("thetasym", "\u03d1");
            parser.defineEntityReplacementText("upsih", "\u03d2");
            parser.defineEntityReplacementText("piv", "\u03d6");
            parser.defineEntityReplacementText("bull", "\u2022");
            parser.defineEntityReplacementText("hellip", "\u2026");
            parser.defineEntityReplacementText("prime", "\u2032");
            parser.defineEntityReplacementText("Prime", "\u2033");
            parser.defineEntityReplacementText("oline", "\u203e");
            parser.defineEntityReplacementText("frasl", "\u2044");
            parser.defineEntityReplacementText("weierp", "\u2118");
            parser.defineEntityReplacementText("image", "\u2111");
            parser.defineEntityReplacementText("real", "\u211c");
            parser.defineEntityReplacementText("trade", "\u2122");
            parser.defineEntityReplacementText("alefsym", "\u2135");
            parser.defineEntityReplacementText("larr", "\u2190");
            parser.defineEntityReplacementText("uarr", "\u2191");
            parser.defineEntityReplacementText("rarr", "\u2192");
            parser.defineEntityReplacementText("darr", "\u2193");
            parser.defineEntityReplacementText("harr", "\u2194");
            parser.defineEntityReplacementText("crarr", "\u21b5");
            parser.defineEntityReplacementText("lArr", "\u21d0");
            parser.defineEntityReplacementText("uArr", "\u21d1");
            parser.defineEntityReplacementText("rArr", "\u21d2");
            parser.defineEntityReplacementText("dArr", "\u21d3");
            parser.defineEntityReplacementText("hArr", "\u21d4");
            parser.defineEntityReplacementText("forall", "\u2200");
            parser.defineEntityReplacementText("part", "\u2202");
            parser.defineEntityReplacementText("exist", "\u2203");
            parser.defineEntityReplacementText("empty", "\u2205");
            parser.defineEntityReplacementText("nabla", "\u2207");
            parser.defineEntityReplacementText("isin", "\u2208");
            parser.defineEntityReplacementText("notin", "\u2209");
            parser.defineEntityReplacementText("ni", "\u220b");
            parser.defineEntityReplacementText("prod", "\u220f");
            parser.defineEntityReplacementText("sum", "\u2211");
            parser.defineEntityReplacementText("minus", "\u2212");
            parser.defineEntityReplacementText("lowast", "\u2217");
            parser.defineEntityReplacementText("radic", "\u221a");
            parser.defineEntityReplacementText("prop", "\u221d");
            parser.defineEntityReplacementText("infin", "\u221e");
            parser.defineEntityReplacementText("ang", "\u2220");
            parser.defineEntityReplacementText("and", "\u2227");
            parser.defineEntityReplacementText("or", "\u2228");
            parser.defineEntityReplacementText("cap", "\u2229");
            parser.defineEntityReplacementText("cup", "\u222a");
            parser.defineEntityReplacementText("int", "\u222b");
            parser.defineEntityReplacementText("there4", "\u2234");
            parser.defineEntityReplacementText("sim", "\u223c");
            parser.defineEntityReplacementText("cong", "\u2245");
            parser.defineEntityReplacementText("asymp", "\u2248");
            parser.defineEntityReplacementText("ne", "\u2260");
            parser.defineEntityReplacementText("equiv", "\u2261");
            parser.defineEntityReplacementText("le", "\u2264");
            parser.defineEntityReplacementText("ge", "\u2265");
            parser.defineEntityReplacementText("sub", "\u2282");
            parser.defineEntityReplacementText("sup", "\u2283");
            parser.defineEntityReplacementText("nsub", "\u2284");
            parser.defineEntityReplacementText("sube", "\u2286");
            parser.defineEntityReplacementText("supe", "\u2287");
            parser.defineEntityReplacementText("oplus", "\u2295");
            parser.defineEntityReplacementText("otimes", "\u2297");
            parser.defineEntityReplacementText("perp", "\u22a5");
            parser.defineEntityReplacementText("sdot", "\u22c5");
            parser.defineEntityReplacementText("lceil", "\u2308");
            parser.defineEntityReplacementText("rceil", "\u2309");
            parser.defineEntityReplacementText("lfloor", "\u230a");
            parser.defineEntityReplacementText("rfloor", "\u230b");
            parser.defineEntityReplacementText("lang", "\u2329");
            parser.defineEntityReplacementText("rang", "\u232a");
            parser.defineEntityReplacementText("loz", "\u25ca");
            parser.defineEntityReplacementText("spades", "\u2660");
            parser.defineEntityReplacementText("clubs", "\u2663");
            parser.defineEntityReplacementText("hearts", "\u2665");
            parser.defineEntityReplacementText("diams", "\u2666");
        }
        parser.next();
        return this.parseModel("project", parser, strict);
    }

    public Model read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public Model read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader(in);
        return this.read(reader, strict);
    }

    public Model read(InputStream in) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader(in);
        return this.read(reader);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

