/* config-impl-gconf.c generated by valac 0.10.4, the Vala compiler
 * generated from config-impl-gconf.vala, do not modify */

/*
 * GConf implementation of the configuration interface.
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libdesktop-agnostic/config.h>
#include <gconf/gconf-client.h>
#include <config-notify-delegate.c>
#include <gconf/gconf.h>
#include <float.h>
#include <math.h>


#define DESKTOP_AGNOSTIC_CONFIG_TYPE_GCONF_BACKEND (desktop_agnostic_config_gconf_backend_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_GCONF_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_GCONF_BACKEND, DesktopAgnosticConfigGConfBackend))
#define DESKTOP_AGNOSTIC_CONFIG_GCONF_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_GCONF_BACKEND, DesktopAgnosticConfigGConfBackendClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_GCONF_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_GCONF_BACKEND))
#define DESKTOP_AGNOSTIC_CONFIG_IS_GCONF_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_GCONF_BACKEND))
#define DESKTOP_AGNOSTIC_CONFIG_GCONF_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_GCONF_BACKEND, DesktopAgnosticConfigGConfBackendClass))

typedef struct _DesktopAgnosticConfigGConfBackend DesktopAgnosticConfigGConfBackend;
typedef struct _DesktopAgnosticConfigGConfBackendClass DesktopAgnosticConfigGConfBackendClass;
typedef struct _DesktopAgnosticConfigGConfBackendPrivate DesktopAgnosticConfigGConfBackendPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_slist_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_free (var), NULL)))
#define __g_slist_free_gconf_entry_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_gconf_entry_unref (var), NULL)))
#define _gconf_entry_unref0(var) ((var == NULL) ? NULL : (var = (gconf_entry_unref (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define _desktop_agnostic_config_notify_delegate_free0(var) ((var == NULL) ? NULL : (var = (desktop_agnostic_config_notify_delegate_free (var), NULL)))
#define _gconf_value_free0(var) ((var == NULL) ? NULL : (var = (gconf_value_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __g_slist_free_gconf_value_free0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_gconf_value_free (var), NULL)))

struct _DesktopAgnosticConfigGConfBackend {
	DesktopAgnosticConfigBackend parent_instance;
	DesktopAgnosticConfigGConfBackendPrivate * priv;
};

struct _DesktopAgnosticConfigGConfBackendClass {
	DesktopAgnosticConfigBackendClass parent_class;
};

struct _DesktopAgnosticConfigGConfBackendPrivate {
	char* schema_path;
	char* path;
	GConfClient* client;
	guint connection_id;
	GData* _notifiers;
};


static gpointer desktop_agnostic_config_gconf_backend_parent_class = NULL;

#define DESKTOP_AGNOSTIC_CONFIG_BACKEND_NAME "GConf"
GType desktop_agnostic_config_gconf_backend_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_CONFIG_GCONF_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_CONFIG_TYPE_GCONF_BACKEND, DesktopAgnosticConfigGConfBackendPrivate))
enum  {
	DESKTOP_AGNOSTIC_CONFIG_GCONF_BACKEND_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_CONFIG_GCONF_BACKEND_NAME
};
static void desktop_agnostic_config_gconf_backend_real_constructed (GObject* base);
static void _vala_GValue_free (GValue* self);
static void desktop_agnostic_config_gconf_backend_associate_schemas_in_dir (DesktopAgnosticConfigGConfBackend* self, const char* schema_dir, const char* pref_dir, GError** error);
static void desktop_agnostic_config_gconf_backend_notify_proxy (DesktopAgnosticConfigGConfBackend* self, GConfClient* client, guint cnxn_id, GConfEntry* entry);
static void _desktop_agnostic_config_gconf_backend_notify_proxy_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self);
static void _g_slist_free_g_free (GSList* self);
static void _g_slist_free_gconf_entry_unref (GSList* self);
static void desktop_agnostic_config_gconf_backend_parse_group_and_key (DesktopAgnosticConfigGConfBackend* self, const char* full_key, char** group, char** key);
static char* desktop_agnostic_config_gconf_backend_generate_key (DesktopAgnosticConfigGConfBackend* self, const char* group, const char* key);
static GConfValueType desktop_agnostic_config_gconf_backend_type_to_valuetype (DesktopAgnosticConfigGConfBackend* self, GType type);
static void desktop_agnostic_config_gconf_backend_gconfvalue_to_gvalue (DesktopAgnosticConfigGConfBackend* self, const char* group, const char* key, GConfValue* gc_val, GValue* result, GError** error);
static GValueArray* desktop_agnostic_config_gconf_backend_slist_to_valuearray (DesktopAgnosticConfigGConfBackend* self, GSList* list, GType type, GError** error);
static void _desktop_agnostic_config_gconf_backend_ensure_key_exists (DesktopAgnosticConfigGConfBackend* self, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gconf_backend_real_remove (DesktopAgnosticConfigBackend* base, GError** error);
static void desktop_agnostic_config_gconf_backend_real_notify_add (DesktopAgnosticConfigBackend* base, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
static void desktop_agnostic_config_gconf_backend_real_notify (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gconf_backend_real_notify_remove (DesktopAgnosticConfigBackend* base, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
static void desktop_agnostic_config_gconf_backend_real_reset (DesktopAgnosticConfigBackend* base, GError** error);
static void desktop_agnostic_config_gconf_backend_real_get_value (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GValue* result, GError** error);
static gboolean desktop_agnostic_config_gconf_backend_real_get_bool (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gconf_backend_real_set_bool (DesktopAgnosticConfigBackend* base, const char* group, const char* key, gboolean value, GError** error);
static float desktop_agnostic_config_gconf_backend_real_get_float (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gconf_backend_real_set_float (DesktopAgnosticConfigBackend* base, const char* group, const char* key, float value, GError** error);
static gint desktop_agnostic_config_gconf_backend_real_get_int (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gconf_backend_real_set_int (DesktopAgnosticConfigBackend* base, const char* group, const char* key, gint value, GError** error);
static char* desktop_agnostic_config_gconf_backend_real_get_string (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gconf_backend_real_set_string (DesktopAgnosticConfigBackend* base, const char* group, const char* key, const char* value, GError** error);
static GValueArray* desktop_agnostic_config_gconf_backend_real_get_list (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gconf_backend_real_set_list (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GValueArray* value, GError** error);
static void _g_slist_free_gconf_value_free (GSList* self);
DesktopAgnosticConfigGConfBackend* desktop_agnostic_config_gconf_backend_new (void);
DesktopAgnosticConfigGConfBackend* desktop_agnostic_config_gconf_backend_construct (GType object_type);
static GObject * desktop_agnostic_config_gconf_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void desktop_agnostic_config_gconf_backend_finalize (GObject* obj);
static void desktop_agnostic_config_gconf_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType register_plugin (void);
static GValue* _g_value_dup (GValue* self);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void _desktop_agnostic_config_gconf_backend_notify_proxy_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self) {
	desktop_agnostic_config_gconf_backend_notify_proxy (self, client, cnxn_id, entry);
}


static void desktop_agnostic_config_gconf_backend_real_constructed (GObject* base) {
	DesktopAgnosticConfigGConfBackend * self;
	char* _tmp0_;
	char* _tmp1_;
	char* opt_prefix;
	char* base_path;
	DesktopAgnosticConfigSchema* schema;
	GData* _tmp2_ = {0};
	char* _tmp3_;
	GValue* _tmp4_;
	GValue* _tmp5_;
	GValue* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	opt_prefix = (_tmp1_ = g_strconcat (_tmp0_ = desktop_agnostic_config_backend_get_name ((DesktopAgnosticConfigBackend*) self), ".", NULL), _g_free0 (_tmp0_), _tmp1_);
	base_path = NULL;
	schema = _g_object_ref0 (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self));
	self->priv->connection_id = (guint) 0;
	self->priv->_notifiers = (g_datalist_init (&_tmp2_), _tmp2_);
	_tmp5_ = (_tmp4_ = desktop_agnostic_config_schema_get_metadata_option (schema, _tmp3_ = g_strconcat (opt_prefix, "base_path", NULL), &_inner_error_), _g_free0 (_tmp3_), _tmp4_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (schema);
		_g_free0 (base_path);
		_g_free0 (opt_prefix);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	base_path = (_tmp7_ = g_strdup (g_value_get_string (_tmp6_ = _tmp5_)), _g_free0 (base_path), _tmp7_);
	__vala_GValue_free0 (_tmp6_);
	self->priv->schema_path = (_tmp8_ = g_strdup_printf ("/schemas%s/%s", base_path, desktop_agnostic_config_schema_get_app_name (schema)), _g_free0 (self->priv->schema_path), _tmp8_);
	if (desktop_agnostic_config_backend_get_instance_id ((DesktopAgnosticConfigBackend*) self) == NULL) {
		char* _tmp9_;
		self->priv->path = (_tmp9_ = g_strdup_printf ("%s/%s", base_path, desktop_agnostic_config_schema_get_app_name (schema)), _g_free0 (self->priv->path), _tmp9_);
	} else {
		char* _tmp10_;
		GValue* _tmp11_;
		GValue* _tmp12_;
		GValue* _tmp13_;
		char* _tmp14_;
		char* option;
		char* _tmp15_;
		char* _tmp16_;
		_tmp12_ = (_tmp11_ = desktop_agnostic_config_schema_get_metadata_option (schema, _tmp10_ = g_strconcat (opt_prefix, "base_instance_path", NULL), &_inner_error_), _g_free0 (_tmp10_), _tmp11_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (schema);
			_g_free0 (base_path);
			_g_free0 (opt_prefix);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		option = (_tmp14_ = g_strdup (g_value_get_string (_tmp13_ = _tmp12_)), __vala_GValue_free0 (_tmp13_), _tmp14_);
		self->priv->path = (_tmp16_ = g_strdup_printf ("%s/%s/%s", _tmp15_ = string_replace (option, "${base_path}", base_path), desktop_agnostic_config_schema_get_app_name (schema), desktop_agnostic_config_backend_get_instance_id ((DesktopAgnosticConfigBackend*) self)), _g_free0 (self->priv->path), _tmp16_);
		_g_free0 (_tmp15_);
		{
			desktop_agnostic_config_gconf_backend_associate_schemas_in_dir (self, self->priv->schema_path, self->priv->path, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("config-impl-gconf.vala:78: Error associating instance with schema: %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_free0 (option);
			_g_object_unref0 (schema);
			_g_free0 (base_path);
			_g_free0 (opt_prefix);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (option);
	}
	{
		guint _tmp17_;
		gconf_client_add_dir (self->priv->client, self->priv->path, GCONF_CLIENT_PRELOAD_RECURSIVE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp17_ = gconf_client_notify_add (self->priv->client, self->priv->path, _desktop_agnostic_config_gconf_backend_notify_proxy_gconf_client_notify_func, g_object_ref (self), g_object_unref, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		self->priv->connection_id = _tmp17_;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("config-impl-gconf.vala:91: Config (GConf) error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (schema);
		_g_free0 (base_path);
		_g_free0 (opt_prefix);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (schema);
	_g_free0 (base_path);
	_g_free0 (opt_prefix);
}


/**
     * Ported from #panel_applet_associate_schemas_in_dir ().
     */
static void _g_slist_free_g_free (GSList* self) {
	g_slist_foreach (self, (GFunc) g_free, NULL);
	g_slist_free (self);
}


static void _g_slist_free_gconf_entry_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) gconf_entry_unref, NULL);
	g_slist_free (self);
}


static void desktop_agnostic_config_gconf_backend_associate_schemas_in_dir (DesktopAgnosticConfigGConfBackend* self, const char* schema_dir, const char* pref_dir, GError** error) {
	GSList* entries;
	GSList* subdirs;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GSList* _tmp18_;
	GSList* _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema_dir != NULL);
	g_return_if_fail (pref_dir != NULL);
	entries = NULL;
	subdirs = NULL;
	_tmp0_ = gconf_client_all_entries (self->priv->client, schema_dir, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_slist_free_g_free0 (subdirs);
		__g_slist_free_gconf_entry_unref0 (entries);
		return;
	}
	entries = (_tmp1_ = _tmp0_, __g_slist_free_gconf_entry_unref0 (entries), _tmp1_);
	{
		GSList* entry_collection;
		GSList* entry_it;
		entry_collection = entries;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			GConfEntry* _tmp17_;
			GConfEntry* entry;
			entry = (_tmp17_ = (GConfEntry*) entry_it->data, (_tmp17_ == NULL) ? NULL : gconf_entry_ref (_tmp17_), _tmp17_);
			{
				char* schema_key;
				char* key;
				GConfEntry* pref_entry;
				char* pref_schema_key;
				char* cgroup;
				char* ckey;
				DesktopAgnosticConfigSchemaOption* option;
				char* _tmp2_;
				char* _tmp3_;
				char* _tmp4_;
				GConfEntry* _tmp5_;
				GConfEntry* _tmp6_;
				char* _tmp7_ = NULL;
				char* _tmp8_;
				char* _tmp9_ = NULL;
				char* _tmp10_;
				DesktopAgnosticConfigSchemaOption* _tmp11_;
				gboolean _tmp12_ = FALSE;
				schema_key = NULL;
				key = NULL;
				pref_entry = NULL;
				pref_schema_key = NULL;
				cgroup = NULL;
				ckey = NULL;
				option = NULL;
				schema_key = (_tmp2_ = g_strdup (gconf_entry_get_key (entry)), _g_free0 (schema_key), _tmp2_);
				key = (_tmp4_ = g_strdup_printf ("%s/%s", pref_dir, _tmp3_ = g_path_get_basename (schema_key)), _g_free0 (key), _tmp4_);
				_g_free0 (_tmp3_);
				_tmp5_ = gconf_client_get_entry (self->priv->client, key, NULL, TRUE, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (option);
					_g_free0 (ckey);
					_g_free0 (cgroup);
					_g_free0 (pref_schema_key);
					_gconf_entry_unref0 (pref_entry);
					_g_free0 (key);
					_g_free0 (schema_key);
					_gconf_entry_unref0 (entry);
					__g_slist_free_g_free0 (subdirs);
					__g_slist_free_gconf_entry_unref0 (entries);
					return;
				}
				pref_entry = (_tmp6_ = _tmp5_, _gconf_entry_unref0 (pref_entry), _tmp6_);
				(desktop_agnostic_config_gconf_backend_parse_group_and_key (self, key, &_tmp7_, &_tmp9_), cgroup = (_tmp8_ = _tmp7_, _g_free0 (cgroup), _tmp8_));
				ckey = (_tmp10_ = _tmp9_, _g_free0 (ckey), _tmp10_);
				option = (_tmp11_ = _g_object_ref0 (desktop_agnostic_config_schema_get_option (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self), cgroup, ckey)), _g_object_unref0 (option), _tmp11_);
				if (option == NULL) {
					_tmp12_ = TRUE;
				} else {
					_tmp12_ = !desktop_agnostic_config_schema_option_get_per_instance (option);
				}
				if (_tmp12_) {
					_g_object_unref0 (option);
					_g_free0 (ckey);
					_g_free0 (cgroup);
					_g_free0 (pref_schema_key);
					_gconf_entry_unref0 (pref_entry);
					_g_free0 (key);
					_g_free0 (schema_key);
					_gconf_entry_unref0 (entry);
					continue;
				}
				if (pref_entry == NULL) {
					char* _tmp13_;
					pref_schema_key = (_tmp13_ = NULL, _g_free0 (pref_schema_key), _tmp13_);
				} else {
					char* _tmp14_;
					pref_schema_key = (_tmp14_ = g_strdup (gconf_entry_get_schema_name (pref_entry)), _g_free0 (pref_schema_key), _tmp14_);
				}
				if (_vala_strcmp0 (schema_key, pref_schema_key) != 0) {
					gboolean _tmp15_ = FALSE;
					gboolean _tmp16_ = FALSE;
					gconf_engine_associate_schema (self->priv->client->engine, key, schema_key, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (option);
						_g_free0 (ckey);
						_g_free0 (cgroup);
						_g_free0 (pref_schema_key);
						_gconf_entry_unref0 (pref_entry);
						_g_free0 (key);
						_g_free0 (schema_key);
						_gconf_entry_unref0 (entry);
						__g_slist_free_g_free0 (subdirs);
						__g_slist_free_gconf_entry_unref0 (entries);
						return;
					}
					if (pref_entry == NULL) {
						_tmp16_ = TRUE;
					} else {
						_tmp16_ = gconf_entry_get_value (pref_entry) == NULL;
					}
					if (_tmp16_) {
						_tmp15_ = TRUE;
					} else {
						_tmp15_ = gconf_entry_get_is_default (pref_entry);
					}
					if (_tmp15_) {
						gconf_client_unset (self->priv->client, key, &_inner_error_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (option);
							_g_free0 (ckey);
							_g_free0 (cgroup);
							_g_free0 (pref_schema_key);
							_gconf_entry_unref0 (pref_entry);
							_g_free0 (key);
							_g_free0 (schema_key);
							_gconf_entry_unref0 (entry);
							__g_slist_free_g_free0 (subdirs);
							__g_slist_free_gconf_entry_unref0 (entries);
							return;
						}
					}
				}
				_g_object_unref0 (option);
				_g_free0 (ckey);
				_g_free0 (cgroup);
				_g_free0 (pref_schema_key);
				_gconf_entry_unref0 (pref_entry);
				_g_free0 (key);
				_g_free0 (schema_key);
				_gconf_entry_unref0 (entry);
			}
		}
	}
	_tmp18_ = gconf_client_all_dirs (self->priv->client, schema_dir, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_slist_free_g_free0 (subdirs);
		__g_slist_free_gconf_entry_unref0 (entries);
		return;
	}
	subdirs = (_tmp19_ = _tmp18_, __g_slist_free_g_free0 (subdirs), _tmp19_);
	{
		GSList* dir_collection;
		GSList* dir_it;
		dir_collection = subdirs;
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
			const char* dir;
			dir = (const char*) dir_it->data;
			{
				char* base_key;
				char* schema_subdir;
				char* pref_subdir;
				char* _tmp20_;
				char* _tmp21_;
				char* _tmp22_;
				base_key = NULL;
				schema_subdir = NULL;
				pref_subdir = NULL;
				base_key = (_tmp20_ = g_path_get_basename (dir), _g_free0 (base_key), _tmp20_);
				schema_subdir = (_tmp21_ = g_strdup_printf ("%s/%s", schema_dir, base_key), _g_free0 (schema_subdir), _tmp21_);
				pref_subdir = (_tmp22_ = g_strdup_printf ("%s/%s", pref_dir, base_key), _g_free0 (pref_subdir), _tmp22_);
				desktop_agnostic_config_gconf_backend_associate_schemas_in_dir (self, schema_subdir, pref_subdir, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (pref_subdir);
					_g_free0 (schema_subdir);
					_g_free0 (base_key);
					__g_slist_free_g_free0 (subdirs);
					__g_slist_free_gconf_entry_unref0 (entries);
					return;
				}
				_g_free0 (pref_subdir);
				_g_free0 (schema_subdir);
				_g_free0 (base_key);
			}
		}
	}
	__g_slist_free_g_free0 (subdirs);
	__g_slist_free_gconf_entry_unref0 (entries);
}


static char* desktop_agnostic_config_gconf_backend_generate_key (DesktopAgnosticConfigGConfBackend* self, const char* group, const char* key) {
	char* result = NULL;
	char* full_key;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	full_key = NULL;
	if (key == NULL) {
		if (_vala_strcmp0 (group, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT) == 0) {
			char* _tmp0_;
			full_key = (_tmp0_ = g_strdup (self->priv->path), _g_free0 (full_key), _tmp0_);
		} else {
			char* _tmp1_;
			full_key = (_tmp1_ = g_strdup_printf ("%s/%s", self->priv->path, group), _g_free0 (full_key), _tmp1_);
		}
	} else {
		if (_vala_strcmp0 (group, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT) == 0) {
			char* _tmp2_;
			full_key = (_tmp2_ = g_strdup_printf ("%s/%s", self->priv->path, key), _g_free0 (full_key), _tmp2_);
		} else {
			char* _tmp3_;
			full_key = (_tmp3_ = g_strdup_printf ("%s/%s/%s", self->priv->path, group, key), _g_free0 (full_key), _tmp3_);
		}
	}
	result = full_key;
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void desktop_agnostic_config_gconf_backend_parse_group_and_key (DesktopAgnosticConfigGConfBackend* self, const char* full_key, char** group, char** key) {
	const char* key_to_parse;
	const char* last_slash;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_key != NULL);
	if (group != NULL) {
		*group = NULL;
	}
	if (key != NULL) {
		*key = NULL;
	}
	key_to_parse = g_utf8_offset_to_pointer (full_key, string_get_length (self->priv->path) + 1);
	last_slash = g_utf8_strrchr (key_to_parse, (gssize) string_get_length (key_to_parse), (gunichar) '/');
	if (last_slash == NULL) {
		char* _tmp0_;
		char* _tmp1_;
		*group = (_tmp0_ = g_strdup (DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT), _g_free0 (*group), _tmp0_);
		*key = (_tmp1_ = g_strdup (key_to_parse), _g_free0 (*key), _tmp1_);
	} else {
		glong offset;
		char* _tmp2_;
		char* _tmp3_;
		offset = g_utf8_pointer_to_offset (key_to_parse, last_slash);
		*group = (_tmp2_ = string_substring (key_to_parse, (glong) 0, offset), _g_free0 (*group), _tmp2_);
		*key = (_tmp3_ = g_strdup (g_utf8_offset_to_pointer (key_to_parse, offset + 1)), _g_free0 (*key), _tmp3_);
	}
}


static GConfValueType desktop_agnostic_config_gconf_backend_type_to_valuetype (DesktopAgnosticConfigGConfBackend* self, GType type) {
	GConfValueType result = 0;
	GConfValueType vt = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (type == G_TYPE_BOOLEAN) {
		vt = GCONF_VALUE_BOOL;
	} else {
		if (type == G_TYPE_FLOAT) {
			vt = GCONF_VALUE_FLOAT;
		} else {
			if (type == G_TYPE_INT) {
				vt = GCONF_VALUE_INT;
			} else {
				if (type == G_TYPE_STRING) {
					vt = GCONF_VALUE_STRING;
				} else {
					if (type == G_TYPE_VALUE_ARRAY) {
						vt = GCONF_VALUE_LIST;
					} else {
						if (desktop_agnostic_config_schema_find_type (type) != NULL) {
							vt = GCONF_VALUE_STRING;
						} else {
							vt = GCONF_VALUE_INVALID;
						}
					}
				}
			}
		}
	}
	result = vt;
	return result;
}


static void desktop_agnostic_config_gconf_backend_gconfvalue_to_gvalue (DesktopAgnosticConfigGConfBackend* self, const char* group, const char* key, GConfValue* gc_val, GValue* result, GError** error) {
	DesktopAgnosticConfigSchemaOption* schema_option;
	GType type = 0UL;
	GValue value = {0};
	DesktopAgnosticConfigSchemaOption* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (gc_val != NULL);
	schema_option = NULL;
	schema_option = (_tmp0_ = _g_object_ref0 (desktop_agnostic_config_schema_get_option (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self), group, key)), _g_object_unref0 (schema_option), _tmp0_);
	if (schema_option == NULL) {
		_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND, "The config key '%s/%s' does not exist in the schema.", group, key);
		{
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				g_propagate_error (error, _inner_error_);
				G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
				_g_object_unref0 (schema_option);
				return;
			} else {
				G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
				_g_object_unref0 (schema_option);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	type = desktop_agnostic_config_schema_option_get_option_type (schema_option);
	if (type == G_TYPE_BOOLEAN) {
		GValue _tmp1_ = {0};
		GValue _tmp2_;
		value = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp1_, gconf_value_get_bool (gc_val)), _tmp1_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp2_);
	} else {
		if (type == G_TYPE_FLOAT) {
			GValue _tmp3_ = {0};
			GValue _tmp4_;
			value = (_tmp4_ = (g_value_init (&_tmp3_, G_TYPE_FLOAT), g_value_set_float (&_tmp3_, (float) gconf_value_get_float (gc_val)), _tmp3_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp4_);
		} else {
			if (type == G_TYPE_INT) {
				GValue _tmp5_ = {0};
				GValue _tmp6_;
				value = (_tmp6_ = (g_value_init (&_tmp5_, G_TYPE_INT), g_value_set_int (&_tmp5_, gconf_value_get_int (gc_val)), _tmp5_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp6_);
			} else {
				if (type == G_TYPE_STRING) {
					GValue _tmp7_ = {0};
					GValue _tmp8_;
					value = (_tmp8_ = (g_value_init (&_tmp7_, G_TYPE_STRING), g_value_set_string (&_tmp7_, gconf_value_get_string (gc_val)), _tmp7_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp8_);
				} else {
					if (type == G_TYPE_VALUE_ARRAY) {
						GType list_type = 0UL;
						GValueArray* array;
						GValue _tmp9_ = {0};
						GValue _tmp10_;
						GValueArray* _tmp11_;
						GValueArray* _tmp12_;
						GValueArray* _tmp13_;
						GValueArray* _tmp14_;
						array = NULL;
						value = (_tmp10_ = (g_value_init (&_tmp9_, type), _tmp9_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp10_);
						list_type = desktop_agnostic_config_schema_option_get_list_type (schema_option);
						_tmp11_ = desktop_agnostic_config_gconf_backend_slist_to_valuearray (self, gconf_value_get_list (gc_val), list_type, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_value_array_free0 (array);
								G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
								_g_object_unref0 (schema_option);
								return;
							} else {
								_g_value_array_free0 (array);
								G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
								_g_object_unref0 (schema_option);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						array = (_tmp12_ = _tmp11_, _g_value_array_free0 (array), _tmp12_);
						g_value_set_boxed (&value, _tmp14_ = (_tmp13_ = array, array = NULL, _tmp13_));
						_g_value_array_free0 (_tmp14_);
						_g_value_array_free0 (array);
					} else {
						DesktopAgnosticConfigSchemaType* st;
						st = _g_object_ref0 (desktop_agnostic_config_schema_find_type (type));
						if (st == NULL) {
							_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE, "Invalid config value type.");
							{
								if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (st);
									G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
									_g_object_unref0 (schema_option);
									return;
								} else {
									_g_object_unref0 (st);
									G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
									_g_object_unref0 (schema_option);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						} else {
							GValue _tmp15_ = {0};
							GValue _tmp16_;
							GValue _tmp17_;
							_tmp16_ = (desktop_agnostic_config_schema_type_deserialize (st, gconf_value_get_string (gc_val), &_tmp15_, &_inner_error_), _tmp15_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (st);
									G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
									_g_object_unref0 (schema_option);
									return;
								} else {
									_g_object_unref0 (st);
									G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
									_g_object_unref0 (schema_option);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							value = (_tmp17_ = _tmp16_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp17_);
						}
						_g_object_unref0 (st);
					}
				}
			}
		}
	}
	*result = value;
	_g_object_unref0 (schema_option);
	return;
}


static GValueArray* desktop_agnostic_config_gconf_backend_slist_to_valuearray (DesktopAgnosticConfigGConfBackend* self, GSList* list, GType type, GError** error) {
	GValueArray* result = NULL;
	GValueArray* arr;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	arr = g_value_array_new (g_slist_length (list));
	{
		GSList* gc_val_collection;
		GSList* gc_val_it;
		gc_val_collection = list;
		for (gc_val_it = gc_val_collection; gc_val_it != NULL; gc_val_it = gc_val_it->next) {
			GConfValue* gc_val;
			gc_val = (GConfValue*) gc_val_it->data;
			{
				GValue val = {0};
				if (type == G_TYPE_BOOLEAN) {
					GValue _tmp0_ = {0};
					GValue _tmp1_;
					val = (_tmp1_ = (g_value_init (&_tmp0_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp0_, gconf_value_get_bool (gc_val)), _tmp0_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp1_);
				} else {
					if (type == G_TYPE_FLOAT) {
						GValue _tmp2_ = {0};
						GValue _tmp3_;
						val = (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_FLOAT), g_value_set_float (&_tmp2_, (float) gconf_value_get_float (gc_val)), _tmp2_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp3_);
					} else {
						if (type == G_TYPE_INT) {
							GValue _tmp4_ = {0};
							GValue _tmp5_;
							val = (_tmp5_ = (g_value_init (&_tmp4_, G_TYPE_INT), g_value_set_int (&_tmp4_, gconf_value_get_int (gc_val)), _tmp4_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp5_);
						} else {
							if (type == G_TYPE_STRING) {
								GValue _tmp6_ = {0};
								GValue _tmp7_;
								val = (_tmp7_ = (g_value_init (&_tmp6_, G_TYPE_STRING), g_value_set_string (&_tmp6_, gconf_value_get_string (gc_val)), _tmp6_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp7_);
							} else {
								DesktopAgnosticConfigSchemaType* st;
								st = _g_object_ref0 (desktop_agnostic_config_schema_find_type (type));
								if (st == NULL) {
									_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE, "Invalid config value type: %s.", g_type_name (type));
									{
										if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_object_unref0 (st);
											G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
											_g_value_array_free0 (arr);
											return NULL;
										} else {
											_g_object_unref0 (st);
											G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
											_g_value_array_free0 (arr);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
								} else {
									GValue _tmp8_ = {0};
									GValue _tmp9_;
									GValue _tmp10_;
									_tmp9_ = (desktop_agnostic_config_schema_type_deserialize (st, gconf_value_get_string (gc_val), &_tmp8_, &_inner_error_), _tmp8_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_object_unref0 (st);
											G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
											_g_value_array_free0 (arr);
											return NULL;
										} else {
											_g_object_unref0 (st);
											G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
											_g_value_array_free0 (arr);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									val = (_tmp10_ = _tmp9_, G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp10_);
								}
								_g_object_unref0 (st);
							}
						}
					}
				}
				g_value_array_append (arr, &val);
				G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			}
		}
	}
	result = arr;
	return result;
}


static void desktop_agnostic_config_gconf_backend_notify_proxy (DesktopAgnosticConfigGConfBackend* self, GConfClient* client, guint cnxn_id, GConfEntry* entry) {
	char* full_key;
	char* group;
	char* key;
	GValue value = {0};
	char* _tmp0_ = NULL;
	char* _tmp1_;
	char* _tmp2_ = NULL;
	char* _tmp3_;
	GValue _tmp4_ = {0};
	GValue _tmp5_;
	GValue _tmp6_;
	GSList* notify_func_list;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	g_return_if_fail (entry != NULL);
	full_key = g_strdup (gconf_entry_get_key (entry));
	group = NULL;
	key = NULL;
	(desktop_agnostic_config_gconf_backend_parse_group_and_key (self, full_key, &_tmp0_, &_tmp2_), group = (_tmp1_ = _tmp0_, _g_free0 (group), _tmp1_));
	key = (_tmp3_ = _tmp2_, _g_free0 (key), _tmp3_);
	_tmp5_ = (desktop_agnostic_config_gconf_backend_gconfvalue_to_gvalue (self, group, key, gconf_entry_get_value (entry), &_tmp4_, &_inner_error_), _tmp4_);
	if (_inner_error_ != NULL) {
		G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
		_g_free0 (key);
		_g_free0 (group);
		_g_free0 (full_key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	value = (_tmp6_ = _tmp5_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp6_);
	notify_func_list = (GSList*) g_datalist_get_data (&self->priv->_notifiers, full_key);
	{
		GSList* notify_func_collection;
		GSList* notify_func_it;
		notify_func_collection = notify_func_list;
		for (notify_func_it = notify_func_collection; notify_func_it != NULL; notify_func_it = notify_func_it->next) {
			DesktopAgnosticConfigNotifyDelegate* notify_func;
			notify_func = (DesktopAgnosticConfigNotifyDelegate*) notify_func_it->data;
			{
				desktop_agnostic_config_notify_delegate_execute (notify_func, group, key, &value);
			}
		}
	}
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	_g_free0 (key);
	_g_free0 (group);
	_g_free0 (full_key);
}


static void _desktop_agnostic_config_gconf_backend_ensure_key_exists (DesktopAgnosticConfigGConfBackend* self, const char* group, const char* key, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	if (desktop_agnostic_config_schema_get_option (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self), group, key) == NULL) {
		_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND, "The config key '%s/%s' does not exist in the schema.", group, key);
		{
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static void desktop_agnostic_config_gconf_backend_real_remove (DesktopAgnosticConfigBackend* base, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	gconf_client_recursive_unset (self->priv->client, self->priv->path, 0, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void desktop_agnostic_config_gconf_backend_real_notify_add (DesktopAgnosticConfigBackend* base, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	DesktopAgnosticConfigNotifyDelegate* notify;
	char* full_key;
	GSList* callbacks;
	DesktopAgnosticConfigNotifyDelegate* _tmp0_;
	char* _tmp1_;
	DesktopAgnosticConfigNotifyDelegate* _tmp2_;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	notify = NULL;
	full_key = NULL;
	callbacks = NULL;
	notify = (_tmp0_ = desktop_agnostic_config_notify_delegate_new (callback, callback_target), _desktop_agnostic_config_notify_delegate_free0 (notify), _tmp0_);
	full_key = (_tmp1_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp1_);
	callbacks = (GSList*) g_datalist_get_data (&self->priv->_notifiers, full_key);
	callbacks = g_slist_append (callbacks, (_tmp2_ = notify, notify = NULL, _tmp2_));
	g_datalist_set_data (&self->priv->_notifiers, full_key, callbacks);
	_g_free0 (full_key);
	_desktop_agnostic_config_notify_delegate_free0 (notify);
}


static void desktop_agnostic_config_gconf_backend_real_notify (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	char* full_key;
	GSList* notifications;
	GValue value = {0};
	GValue _tmp0_ = {0};
	GValue _tmp1_;
	GValue _tmp2_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	full_key = desktop_agnostic_config_gconf_backend_generate_key (self, group, key);
	notifications = NULL;
	notifications = (GSList*) g_datalist_get_data (&self->priv->_notifiers, full_key);
	_tmp1_ = (desktop_agnostic_config_backend_get_value ((DesktopAgnosticConfigBackend*) self, group, key, &_tmp0_, &_inner_error_), _tmp0_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
		_g_free0 (full_key);
		return;
	}
	value = (_tmp2_ = _tmp1_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp2_);
	{
		GSList* notify_collection;
		GSList* notify_it;
		notify_collection = notifications;
		for (notify_it = notify_collection; notify_it != NULL; notify_it = notify_it->next) {
			DesktopAgnosticConfigNotifyDelegate* notify;
			notify = (DesktopAgnosticConfigNotifyDelegate*) notify_it->data;
			{
				desktop_agnostic_config_notify_delegate_execute (notify, group, key, &value);
			}
		}
	}
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	_g_free0 (full_key);
}


static void desktop_agnostic_config_gconf_backend_real_notify_remove (DesktopAgnosticConfigBackend* base, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	char* full_key;
	GSList* funcs;
	DesktopAgnosticConfigNotifyDelegate* ndata;
	GSList* node;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	full_key = desktop_agnostic_config_gconf_backend_generate_key (self, group, key);
	funcs = (GSList*) g_datalist_get_data (&self->priv->_notifiers, full_key);
	ndata = desktop_agnostic_config_notify_delegate_new (callback, callback_target);
	node = NULL;
	node = g_slist_find_custom (funcs, ndata, (GCompareFunc) desktop_agnostic_config_notify_delegate_compare);
	if (node != NULL) {
		DesktopAgnosticConfigNotifyDelegate* _tmp0_;
		node->data = (_tmp0_ = NULL, _desktop_agnostic_config_notify_delegate_free0 (node->data), _tmp0_);
		funcs = g_slist_delete_link (funcs, node);
		g_datalist_set_data (&self->priv->_notifiers, full_key, funcs);
	}
	_desktop_agnostic_config_notify_delegate_free0 (ndata);
	_g_free0 (full_key);
}


static void desktop_agnostic_config_gconf_backend_real_reset (DesktopAgnosticConfigBackend* base, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	DesktopAgnosticConfigSchema* schema;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	schema = _g_object_ref0 (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self));
	{
		GList* group_collection;
		GList* group_it;
		group_collection = desktop_agnostic_config_schema_get_groups (schema);
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
			const char* group;
			group = (const char*) group_it->data;
			{
				{
					GList* key_collection;
					GList* key_it;
					key_collection = desktop_agnostic_config_schema_get_keys (schema, group);
					for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
						const char* key;
						key = (const char*) key_it->data;
						{
							char* full_key;
							GConfValue* val;
							char* _tmp0_;
							GConfValue* _tmp1_;
							GConfValue* _tmp2_;
							full_key = NULL;
							val = NULL;
							full_key = (_tmp0_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp0_);
							_tmp1_ = gconf_client_get_default_from_schema (self->priv->client, full_key, &_inner_error_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_gconf_value_free0 (val);
								_g_free0 (full_key);
								_g_list_free0 (group_collection);
								_g_object_unref0 (schema);
								return;
							}
							val = (_tmp2_ = _tmp1_, _gconf_value_free0 (val), _tmp2_);
							gconf_client_set (self->priv->client, full_key, val, &_inner_error_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_gconf_value_free0 (val);
								_g_free0 (full_key);
								_g_list_free0 (group_collection);
								_g_object_unref0 (schema);
								return;
							}
							_gconf_value_free0 (val);
							_g_free0 (full_key);
						}
					}
				}
			}
		}
		_g_list_free0 (group_collection);
	}
	_g_object_unref0 (schema);
}


static void desktop_agnostic_config_gconf_backend_real_get_value (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GValue* result, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	char* full_key;
	GConfValue* gc_val;
	GConfEntry* entry;
	GValue val = {0};
	char* _tmp0_;
	GConfEntry* _tmp1_;
	GConfEntry* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	full_key = NULL;
	gc_val = NULL;
	entry = NULL;
	full_key = (_tmp0_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp0_);
	_tmp1_ = gconf_client_get_entry (self->priv->client, full_key, NULL, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		_gconf_entry_unref0 (entry);
		_g_free0 (full_key);
		return;
	}
	entry = (_tmp2_ = _tmp1_, _gconf_entry_unref0 (entry), _tmp2_);
	gc_val = gconf_entry_get_value (entry);
	if (gc_val == NULL) {
		_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND, "Could not find the key specified: %s.", full_key);
		{
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			_gconf_entry_unref0 (entry);
			_g_free0 (full_key);
			return;
		}
	} else {
		GValue _tmp3_ = {0};
		GValue _tmp4_;
		GValue _tmp5_;
		_tmp4_ = (desktop_agnostic_config_gconf_backend_gconfvalue_to_gvalue (self, group, key, gc_val, &_tmp3_, &_inner_error_), _tmp3_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			_gconf_entry_unref0 (entry);
			_g_free0 (full_key);
			return;
		}
		val = (_tmp5_ = _tmp4_, G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp5_);
	}
	*result = val;
	_gconf_entry_unref0 (entry);
	_g_free0 (full_key);
	return;
}


static gboolean desktop_agnostic_config_gconf_backend_real_get_bool (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	gboolean result = FALSE;
	char* full_key;
	char* _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	full_key = NULL;
	_desktop_agnostic_config_gconf_backend_ensure_key_exists (self, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return FALSE;
	}
	full_key = (_tmp0_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp0_);
	_tmp1_ = gconf_client_get_bool (self->priv->client, full_key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return FALSE;
	}
	result = _tmp1_;
	_g_free0 (full_key);
	return result;
}


static void desktop_agnostic_config_gconf_backend_real_set_bool (DesktopAgnosticConfigBackend* base, const char* group, const char* key, gboolean value, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	char* full_key;
	char* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	full_key = NULL;
	_desktop_agnostic_config_gconf_backend_ensure_key_exists (self, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return;
	}
	full_key = (_tmp0_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp0_);
	gconf_client_set_bool (self->priv->client, full_key, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return;
	}
	_g_free0 (full_key);
}


static float desktop_agnostic_config_gconf_backend_real_get_float (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	float result = 0.0F;
	char* full_key;
	char* _tmp0_;
	double _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_val_if_fail (group != NULL, 0.0F);
	g_return_val_if_fail (key != NULL, 0.0F);
	full_key = NULL;
	_desktop_agnostic_config_gconf_backend_ensure_key_exists (self, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return 0.0F;
	}
	full_key = (_tmp0_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp0_);
	_tmp1_ = gconf_client_get_float (self->priv->client, full_key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return 0.0F;
	}
	result = (float) _tmp1_;
	_g_free0 (full_key);
	return result;
}


static void desktop_agnostic_config_gconf_backend_real_set_float (DesktopAgnosticConfigBackend* base, const char* group, const char* key, float value, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	char* full_key;
	char* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	full_key = NULL;
	_desktop_agnostic_config_gconf_backend_ensure_key_exists (self, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return;
	}
	full_key = (_tmp0_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp0_);
	gconf_client_set_float (self->priv->client, full_key, (double) value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return;
	}
	_g_free0 (full_key);
}


static gint desktop_agnostic_config_gconf_backend_real_get_int (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	gint result = 0;
	char* full_key;
	char* _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_val_if_fail (group != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	full_key = NULL;
	_desktop_agnostic_config_gconf_backend_ensure_key_exists (self, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return 0;
	}
	full_key = (_tmp0_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp0_);
	_tmp1_ = gconf_client_get_int (self->priv->client, full_key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return 0;
	}
	result = _tmp1_;
	_g_free0 (full_key);
	return result;
}


static void desktop_agnostic_config_gconf_backend_real_set_int (DesktopAgnosticConfigBackend* base, const char* group, const char* key, gint value, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	char* full_key;
	char* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	full_key = NULL;
	_desktop_agnostic_config_gconf_backend_ensure_key_exists (self, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return;
	}
	full_key = (_tmp0_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp0_);
	gconf_client_set_int (self->priv->client, full_key, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return;
	}
	_g_free0 (full_key);
}


static char* desktop_agnostic_config_gconf_backend_real_get_string (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	char* result = NULL;
	char* full_key;
	char* _tmp0_;
	char* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	full_key = NULL;
	_desktop_agnostic_config_gconf_backend_ensure_key_exists (self, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return NULL;
	}
	full_key = (_tmp0_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp0_);
	_tmp1_ = gconf_client_get_string (self->priv->client, full_key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return NULL;
	}
	result = _tmp1_;
	_g_free0 (full_key);
	return result;
}


static void desktop_agnostic_config_gconf_backend_real_set_string (DesktopAgnosticConfigBackend* base, const char* group, const char* key, const char* value, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	char* full_key;
	char* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	full_key = NULL;
	_desktop_agnostic_config_gconf_backend_ensure_key_exists (self, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return;
	}
	full_key = (_tmp0_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp0_);
	gconf_client_set_string (self->priv->client, full_key, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return;
	}
	_g_free0 (full_key);
}


static GValueArray* desktop_agnostic_config_gconf_backend_real_get_list (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	GValueArray* result = NULL;
	char* full_key;
	GType list_type = 0UL;
	GConfValue* gc_val;
	char* _tmp0_;
	GConfValue* _tmp1_;
	GConfValue* _tmp2_;
	GValueArray* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	full_key = NULL;
	gc_val = NULL;
	_desktop_agnostic_config_gconf_backend_ensure_key_exists (self, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_gconf_value_free0 (gc_val);
		_g_free0 (full_key);
		return NULL;
	}
	full_key = (_tmp0_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp0_);
	list_type = desktop_agnostic_config_schema_option_get_list_type (desktop_agnostic_config_schema_get_option (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self), group, key));
	_tmp1_ = gconf_client_get (self->priv->client, full_key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_gconf_value_free0 (gc_val);
		_g_free0 (full_key);
		return NULL;
	}
	gc_val = (_tmp2_ = _tmp1_, _gconf_value_free0 (gc_val), _tmp2_);
	_tmp3_ = desktop_agnostic_config_gconf_backend_slist_to_valuearray (self, gconf_value_get_list (gc_val), list_type, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_gconf_value_free0 (gc_val);
		_g_free0 (full_key);
		return NULL;
	}
	result = _tmp3_;
	_gconf_value_free0 (gc_val);
	_g_free0 (full_key);
	return result;
}


static void _g_slist_free_gconf_value_free (GSList* self) {
	g_slist_foreach (self, (GFunc) gconf_value_free, NULL);
	g_slist_free (self);
}


static void desktop_agnostic_config_gconf_backend_real_set_list (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GValueArray* value, GError** error) {
	DesktopAgnosticConfigGConfBackend * self;
	char* full_key;
	GType type = 0UL;
	char* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	full_key = NULL;
	_desktop_agnostic_config_gconf_backend_ensure_key_exists (self, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return;
	}
	full_key = (_tmp0_ = desktop_agnostic_config_gconf_backend_generate_key (self, group, key), _g_free0 (full_key), _tmp0_);
	type = desktop_agnostic_config_schema_option_get_list_type (desktop_agnostic_config_schema_get_option (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self), group, key));
	if (type == G_TYPE_BOOLEAN) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = type == G_TYPE_FLOAT;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = type == G_TYPE_INT;
	}
	if (_tmp1_) {
		GSList* list;
		GConfValue* val;
		GConfValueType gc_type;
		GSList* _tmp3_;
		GConfValue* _tmp8_;
		list = NULL;
		val = NULL;
		gc_type = desktop_agnostic_config_gconf_backend_type_to_valuetype (self, type);
		list = (_tmp3_ = NULL, __g_slist_free_gconf_value_free0 (list), _tmp3_);
		{
			GValueArray* list_val_collection;
			guint list_val_index;
			list_val_collection = value;
			for (list_val_index = 0; list_val_index < list_val_collection->n_values; list_val_index = list_val_index + 1) {
				GValue list_val;
				list_val = *g_value_array_get_nth (list_val_collection, list_val_index);
				{
					GConfValue* gc_val;
					GConfValue* _tmp4_;
					GConfValue* _tmp7_;
					gc_val = NULL;
					gc_val = (_tmp4_ = gconf_value_new (gc_type), _gconf_value_free0 (gc_val), _tmp4_);
					if (type == G_TYPE_BOOLEAN) {
						gconf_value_set_bool (gc_val, g_value_get_boolean (&list_val));
					} else {
						if (type == G_TYPE_FLOAT) {
							float _tmp5_;
							_tmp5_ = desktop_agnostic_config_backend_get_float_from_value (&list_val, &_inner_error_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_gconf_value_free0 (gc_val);
								_gconf_value_free0 (val);
								__g_slist_free_gconf_value_free0 (list);
								_g_free0 (full_key);
								return;
							}
							gconf_value_set_float (gc_val, (double) _tmp5_);
						} else {
							if (type == G_TYPE_INT) {
								gint _tmp6_;
								_tmp6_ = desktop_agnostic_config_backend_get_int_from_value (&list_val, &_inner_error_);
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_gconf_value_free0 (gc_val);
									_gconf_value_free0 (val);
									__g_slist_free_gconf_value_free0 (list);
									_g_free0 (full_key);
									return;
								}
								gconf_value_set_int (gc_val, _tmp6_);
							} else {
								_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE, "Invalid config value type: %s.", g_type_name (type));
								{
									g_propagate_error (error, _inner_error_);
									_gconf_value_free0 (gc_val);
									_gconf_value_free0 (val);
									__g_slist_free_gconf_value_free0 (list);
									_g_free0 (full_key);
									return;
								}
							}
						}
					}
					list = g_slist_append (list, (_tmp7_ = gc_val, gc_val = NULL, _tmp7_));
					_gconf_value_free0 (gc_val);
				}
			}
		}
		val = (_tmp8_ = gconf_value_new (GCONF_VALUE_LIST), _gconf_value_free0 (val), _tmp8_);
		gconf_value_set_list_type (val, gc_type);
		gconf_value_set_list (val, list);
		gconf_client_set (self->priv->client, full_key, val, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_gconf_value_free0 (val);
			__g_slist_free_gconf_value_free0 (list);
			_g_free0 (full_key);
			return;
		}
		_gconf_value_free0 (val);
		__g_slist_free_gconf_value_free0 (list);
	} else {
		DesktopAgnosticConfigSchemaType* st;
		GSList* list;
		GSList* _tmp10_;
		st = NULL;
		list = NULL;
		if (type != G_TYPE_STRING) {
			DesktopAgnosticConfigSchemaType* _tmp9_;
			st = (_tmp9_ = _g_object_ref0 (desktop_agnostic_config_schema_find_type (type)), _g_object_unref0 (st), _tmp9_);
			if (st == NULL) {
				_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE, "Invalid config value type: %s.", g_type_name (type));
				{
					g_propagate_error (error, _inner_error_);
					__g_slist_free_g_free0 (list);
					_g_object_unref0 (st);
					_g_free0 (full_key);
					return;
				}
			}
		}
		list = (_tmp10_ = NULL, __g_slist_free_g_free0 (list), _tmp10_);
		{
			GValueArray* list_val_collection;
			guint list_val_index;
			list_val_collection = value;
			for (list_val_index = 0; list_val_index < list_val_collection->n_values; list_val_index = list_val_index + 1) {
				GValue list_val;
				list_val = *g_value_array_get_nth (list_val_collection, list_val_index);
				{
					if (st == NULL) {
						list = g_slist_append (list, g_strdup (g_value_get_string (&list_val)));
					} else {
						char* _tmp11_;
						_tmp11_ = desktop_agnostic_config_schema_type_serialize (st, &list_val, &_inner_error_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							__g_slist_free_g_free0 (list);
							_g_object_unref0 (st);
							_g_free0 (full_key);
							return;
						}
						list = g_slist_append (list, _tmp11_);
					}
				}
			}
		}
		gconf_client_set_list (self->priv->client, full_key, GCONF_VALUE_STRING, list, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			__g_slist_free_g_free0 (list);
			_g_object_unref0 (st);
			_g_free0 (full_key);
			return;
		}
		__g_slist_free_g_free0 (list);
		_g_object_unref0 (st);
	}
	_g_free0 (full_key);
}


DesktopAgnosticConfigGConfBackend* desktop_agnostic_config_gconf_backend_construct (GType object_type) {
	DesktopAgnosticConfigGConfBackend * self = NULL;
	self = (DesktopAgnosticConfigGConfBackend*) desktop_agnostic_config_backend_construct (object_type);
	return self;
}


DesktopAgnosticConfigGConfBackend* desktop_agnostic_config_gconf_backend_new (void) {
	return desktop_agnostic_config_gconf_backend_construct (DESKTOP_AGNOSTIC_CONFIG_TYPE_GCONF_BACKEND);
}


static char* desktop_agnostic_config_gconf_backend_real_get_name (DesktopAgnosticConfigBackend* base) {
	char* result;
	DesktopAgnosticConfigGConfBackend* self;
	self = (DesktopAgnosticConfigGConfBackend*) base;
	result = g_strdup (DESKTOP_AGNOSTIC_CONFIG_BACKEND_NAME);
	return result;
}


static GObject * desktop_agnostic_config_gconf_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DesktopAgnosticConfigGConfBackend * self;
	parent_class = G_OBJECT_CLASS (desktop_agnostic_config_gconf_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DESKTOP_AGNOSTIC_CONFIG_GCONF_BACKEND (obj);
	{
		self->priv->client = gconf_client_get_default ();
	}
	return obj;
}


static void desktop_agnostic_config_gconf_backend_class_init (DesktopAgnosticConfigGConfBackendClass * klass) {
	desktop_agnostic_config_gconf_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticConfigGConfBackendPrivate));
	G_OBJECT_CLASS (klass)->constructed = desktop_agnostic_config_gconf_backend_real_constructed;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->remove = desktop_agnostic_config_gconf_backend_real_remove;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->notify_add = desktop_agnostic_config_gconf_backend_real_notify_add;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->notify = desktop_agnostic_config_gconf_backend_real_notify;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->notify_remove = desktop_agnostic_config_gconf_backend_real_notify_remove;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->reset = desktop_agnostic_config_gconf_backend_real_reset;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_value = desktop_agnostic_config_gconf_backend_real_get_value;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_bool = desktop_agnostic_config_gconf_backend_real_get_bool;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_bool = desktop_agnostic_config_gconf_backend_real_set_bool;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_float = desktop_agnostic_config_gconf_backend_real_get_float;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_float = desktop_agnostic_config_gconf_backend_real_set_float;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_int = desktop_agnostic_config_gconf_backend_real_get_int;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_int = desktop_agnostic_config_gconf_backend_real_set_int;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_string = desktop_agnostic_config_gconf_backend_real_get_string;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_string = desktop_agnostic_config_gconf_backend_real_set_string;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_list = desktop_agnostic_config_gconf_backend_real_get_list;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_list = desktop_agnostic_config_gconf_backend_real_set_list;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_name = desktop_agnostic_config_gconf_backend_real_get_name;
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_config_gconf_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = desktop_agnostic_config_gconf_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_config_gconf_backend_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_GCONF_BACKEND_NAME, "name");
}


static void desktop_agnostic_config_gconf_backend_instance_init (DesktopAgnosticConfigGConfBackend * self) {
	self->priv = DESKTOP_AGNOSTIC_CONFIG_GCONF_BACKEND_GET_PRIVATE (self);
}


static void desktop_agnostic_config_gconf_backend_finalize (GObject* obj) {
	DesktopAgnosticConfigGConfBackend * self;
	GError * _inner_error_;
	self = DESKTOP_AGNOSTIC_CONFIG_GCONF_BACKEND (obj);
	_inner_error_ = NULL;
	{
		{
			gconf_client_notify_remove (self->priv->client, self->priv->connection_id);
			gconf_client_remove_dir (self->priv->client, self->priv->path, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("config-impl-gconf.vala:104: Config (GConf) error: %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally3:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_g_free0 (self->priv->schema_path);
	_g_free0 (self->priv->path);
	G_OBJECT_CLASS (desktop_agnostic_config_gconf_backend_parent_class)->finalize (obj);
}


GType desktop_agnostic_config_gconf_backend_get_type (void) {
	static volatile gsize desktop_agnostic_config_gconf_backend_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_config_gconf_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticConfigGConfBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_config_gconf_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticConfigGConfBackend), 0, (GInstanceInitFunc) desktop_agnostic_config_gconf_backend_instance_init, NULL };
		GType desktop_agnostic_config_gconf_backend_type_id;
		desktop_agnostic_config_gconf_backend_type_id = g_type_register_static (DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND, "DesktopAgnosticConfigGConfBackend", &g_define_type_info, 0);
		g_once_init_leave (&desktop_agnostic_config_gconf_backend_type_id__volatile, desktop_agnostic_config_gconf_backend_type_id);
	}
	return desktop_agnostic_config_gconf_backend_type_id__volatile;
}


static void desktop_agnostic_config_gconf_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticConfigGConfBackend * self;
	self = DESKTOP_AGNOSTIC_CONFIG_GCONF_BACKEND (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_CONFIG_GCONF_BACKEND_NAME:
		g_value_take_string (value, desktop_agnostic_config_backend_get_name ((DesktopAgnosticConfigBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


GType register_plugin (void) {
	GType result = 0UL;
	GValue val = {0};
	GHashTable* backend_metadata_keys;
	GValue _tmp0_ = {0};
	GValue _tmp1_;
	GValue _tmp2_ = {0};
	GValue _tmp3_;
	backend_metadata_keys = NULL;
	val = (_tmp1_ = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, "/apps"), _tmp0_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp1_);
	backend_metadata_keys = desktop_agnostic_config_backend_get_backend_metadata_keys ();
	g_hash_table_insert (backend_metadata_keys, g_strdup_printf ("%s.base_path", DESKTOP_AGNOSTIC_CONFIG_BACKEND_NAME), __g_value_dup0 (&val));
	val = (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, "${base_path}/instances"), _tmp2_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp3_);
	g_hash_table_insert (backend_metadata_keys, g_strdup_printf ("%s.base_instance_path", DESKTOP_AGNOSTIC_CONFIG_BACKEND_NAME), __g_value_dup0 (&val));
	result = DESKTOP_AGNOSTIC_CONFIG_TYPE_GCONF_BACKEND;
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	return result;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




