/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#ifndef CLEAVE_SPEC_DEF_DLG_HPP
#define CLEAVE_SPEC_DEF_DLG_HPP


/////////////////////// Local includes
#include "AbstractPolChemDefDependentDlg.hpp"
#include "ui_CleaveSpecDefDlg.h"
#include <libmass/PolChemDefEntity.hpp>


namespace msxps
{

	namespace massxpert
	{



class PolChemDef;
class PolChemDefWnd;


class CleaveSpecDefDlg : public AbstractPolChemDefDependentDlg
{
  Q_OBJECT

  public:
  CleaveSpecDefDlg(libmass::PolChemDefSPtr polChemDefSPtr,
                  PolChemDefWnd *polChemDefWnd,
                  const QString &settingsFilePath,
                  const QString &applicationName,
                  const QString &description);

  ~CleaveSpecDefDlg();

  bool initialize();

  void updateCleaveSpecIdentityDetails(libmass::CleaveSpec *);
  void updateCleaveRuleDetails(libmass::CleaveRule *);

  void clearAllDetails();

  public slots:

  // ACTIONS
  void addCleaveSpecPushButtonClicked();
  void removeCleaveSpecPushButtonClicked();
  void moveUpCleaveSpecPushButtonClicked();
  void moveDownCleaveSpecPushButtonClicked();

  void addCleaveRulePushButtonClicked();
  void removeCleaveRulePushButtonClicked();
  void moveUpCleaveRulePushButtonClicked();
  void moveDownCleaveRulePushButtonClicked();

  void applyCleaveSpecPushButtonClicked();
  void applyCleaveRulePushButtonClicked();

  bool validatePushButtonClicked();

  // VALIDATION
  bool validate();

  // WIDGETRY
  void cleaveSpecListWidgetItemSelectionChanged();
  void cleaveRuleListWidgetItemSelectionChanged();

  private:
  Ui::CleaveSpecDefDlg m_ui;

  QList<libmass::CleaveSpec *> *mp_list;

  void closeEvent(QCloseEvent *event);

  void writeSettings();
  void readSettings();

};

} // namespace massxpert

} // namespace msxps


#endif // CLEAVE_SPEC_DEF_DLG_HPP
