/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// .NAME:
//  XDevice
//
// .AUTHOR:
//  Gilberto Camara, Baudoin Raoult and Fernando Ii
//
// .SUMMARY:
//  Defines a class for creating devices associated
//  with X Window System (see the Device class for 
//  more information)
//
//
// .CLIENTS:
//  Presentable
//
//
// .RESPONSABILITIES:
//  Provide the creating of X-based widgets associated
//  with each presentable
//
//
// .COLLABORATORS:
//  PresentableWidget
//
//
// .BASE CLASS:
//  Device
//
// .DERIVED CLASSES:
//  (none)	
//
// .REFERENCES:
//
//
#ifndef XDevice_H
#define XDevice_H

#include "Device.h"

class XDevice: public Device {
public:

	// Contructors
	XDevice( const MvRequest& deviceRequest );

	// Destructor
	~XDevice(); // Change to virtual if base class

	// Visitor methods
	virtual void Visit ( SuperPage& );
	virtual void Visit ( Page& );
	virtual void Visit ( SubPage& );
#if 0
	virtual void Visit ( MagnifyPage& );
	virtual void Visit ( EditMapPage& );

        // Add translations
        void SetTranslations(Widget,const PresentableWidget*);
        static void ScrollProc(Widget w, XEvent *,String *, Cardinal *);
        static void MotionProc(Widget w, XEvent *,String *, Cardinal *);
        static void EnterProc(Widget w, XEvent *,String *, Cardinal *);
        static void LeaveProc(Widget w, XEvent *,String *, Cardinal *);
      
       // Event handlers for updating drawing area properly.
       static void SubPageMappedHandler(Widget w, XtPointer clientData, 
			      XEvent *event, Boolean *);

       static void RedrawCanvasHandler(Widget w, XtPointer clientData, 
				       XVisibilityEvent *event, Boolean *);
#endif

private:

	// No copy allowed
	XDevice(const XDevice&);
	XDevice& operator=(const XDevice&){return *this;}
};

#endif
