/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks;

import com.carrotsearch.junitbenchmarks.IResultsConsumer;
import com.carrotsearch.junitbenchmarks.Result;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;

public final class WriterConsumer
implements IResultsConsumer {
    private final Writer w;

    public WriterConsumer() {
        this(WriterConsumer.getDefaultWriter());
    }

    public WriterConsumer(Writer w) {
        this.w = w;
    }

    public void accept(Result result) throws IOException {
        this.w.write(String.format(Locale.ENGLISH, "%s: [measured %d out of %d rounds]\n round: %s, round.gc: %s, GC.calls: %d, GC.time: %.2f, time.total: %.2f, time.warmup: %.2f, time.bench: %.2f\n", result.getShortTestClassName() + "." + result.getTestMethodName(), result.benchmarkRounds, result.benchmarkRounds + result.warmupRounds, result.roundAverage.toString(), result.gcAverage.toString(), result.gcInfo.accumulatedInvocations(), (double)result.gcInfo.accumulatedTime() / 1000.0, (double)(result.warmupTime + result.benchmarkTime) * 0.001, (double)result.warmupTime * 0.001, (double)result.benchmarkTime * 0.001));
        this.w.flush();
    }

    private static Writer getDefaultWriter() {
        return new OutputStreamWriter(System.out){

            public void close() throws IOException {
            }
        };
    }
}

