/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

package org.netbeans.modules.git.ui.repository;

import java.awt.EventQueue;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

/**
 *
 * @author ondra
 */
public class RevisionPickerDialog extends javax.swing.JPanel {
    private final RevisionInfoPanel infoPanel;
    private final RepositoryBrowserPanel browserPanel;
    private int sliderPos;

    /** Creates new form RevisionPickerDialog */
    public RevisionPickerDialog (RevisionInfoPanel infoPanel, RepositoryBrowserPanel browserPanel) {
        this.infoPanel = infoPanel;
        this.browserPanel = browserPanel;
        initComponents();
        browserPanel.addAncestorListener(new AncestorListener() {

            @Override
            public void ancestorAdded (AncestorEvent event) {
                RevisionPickerDialog.this.browserPanel.removeAncestorListener(this);
                if (sliderPos > 0) {
                    EventQueue.invokeLater(new Runnable() {

                        @Override
                        public void run () {
                            jSplitPane1.setDividerLocation(sliderPos);
                        }

                    });
                }
            }

            @Override
            public void ancestorRemoved (AncestorEvent event) {
            }

            @Override
            public void ancestorMoved (AncestorEvent event) {
            }

        });
    }
    
    void setSliderPosition (int pos) {
        this.sliderPos = pos;
        jSplitPane1.setDividerLocation(pos);
    }
    
    int getSliderPosition () {
        return jSplitPane1.getDividerLocation();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jSplitPane1 = new javax.swing.JSplitPane();
        org.netbeans.modules.git.ui.repository.RevisionInfoPanel revisionInfoPanel1 = infoPanel;
        org.netbeans.modules.git.ui.repository.RepositoryBrowserPanel repositoryBrowserPanel1 = browserPanel;

        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPane1.setResizeWeight(0.9);
        jSplitPane1.setRightComponent(revisionInfoPanel1);
        jSplitPane1.setLeftComponent(repositoryBrowserPanel1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 631, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 427, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSplitPane jSplitPane1;
    // End of variables declaration//GEN-END:variables

}
