---
id: fast-element.controller
title: Controller class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-element](./fast-element.md) &gt; [Controller](./fast-element.controller.md)

## Controller class

Controls the lifecycle and rendering of a `FASTElement`<!-- -->.

<b>Signature:</b>

```typescript
export declare class Controller extends PropertyChangeNotifier 
```

## Remarks

The constructor for this class is marked as internal. Third-party code should not call the constructor directly or create subclasses that extend the `Controller` class.

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [definition](./fast-element.controller.definition.md) |  | [FASTElementDefinition](./fast-element.fastelementdefinition.md) | The element definition that instructs this controller in how to handle rendering and other platform integrations. |
|  [element](./fast-element.controller.element.md) |  | HTMLElement | The element being controlled by this controller. |
|  [isConnected](./fast-element.controller.isconnected.md) |  | boolean | Indicates whether or not the custom element has been connected to the document. |
|  [styles](./fast-element.controller.styles.md) |  | [ElementStyles](./fast-element.elementstyles.md) \| null | Gets/sets the primary styles used for the component. |
|  [template](./fast-element.controller.template.md) |  | [ElementViewTemplate](./fast-element.elementviewtemplate.md) \| null | Gets/sets the template used to render the component. |
|  [view](./fast-element.controller.view.md) |  | [ElementView](./fast-element.elementview.md) \| null | The view associated with the custom element. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [addBehaviors(behaviors)](./fast-element.controller.addbehaviors.md) |  | Adds behaviors to this element. |
|  [addStyles(styles)](./fast-element.controller.addstyles.md) |  | Adds styles to this element. Providing an HTMLStyleElement will attach the element instance to the shadowRoot. |
|  [emit(type, detail, options)](./fast-element.controller.emit.md) |  | Emits a custom HTML event. |
|  [forCustomElement(element)](./fast-element.controller.forcustomelement.md) | <code>static</code> | Locates or creates a controller for the specified element. |
|  [onAttributeChangedCallback(name, oldValue, newValue)](./fast-element.controller.onattributechangedcallback.md) |  | Runs the attribute changed callback for the associated element. |
|  [onConnectedCallback()](./fast-element.controller.onconnectedcallback.md) |  | Runs connected lifecycle behavior on the associated element. |
|  [onDisconnectedCallback()](./fast-element.controller.ondisconnectedcallback.md) |  | Runs disconnected lifecycle behavior on the associated element. |
|  [removeBehaviors(behaviors, force)](./fast-element.controller.removebehaviors.md) |  | Removes behaviors from this element. |
|  [removeStyles(styles)](./fast-element.controller.removestyles.md) |  | Removes styles from this element. Providing an HTMLStyleElement will detach the element instance from the shadowRoot. |
