/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToAcesiiEcpInput
extends AbstractBasisSetXmlToText {
    protected String mTitle = "";
    protected int mLMax = 1;

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        return this.readECP(data, elementList);
    }

    @Override
    protected void initialize(Element root, Vector elements) throws FormatException {
        this.mLMax = 0;
        List potentialsList = root.getChildren("potentials", BSEProperties.mBseNs);
        for (Element potentials : potentialsList) {
            String element = potentials.getAttributeValue("elementType");
            boolean doit = true;
            if (elements.size() > 0) {
                doit = elements.contains(element);
            }
            if (!doit) continue;
            List potentialList = potentials.getChildren("potential", BSEProperties.mBseNs);
            for (Element potential : potentialList) {
                String shell = potential.getAttributeValue("shell");
                int tmpmax = this.getShellValue(shell);
                if (tmpmax <= this.mLMax) continue;
                this.mLMax = tmpmax;
            }
        }
    }

    @Override
    protected void addHeaderECP(StringBuffer output, Element root) {
        this.mTitle = root.getChildText("title", BSEProperties.mDcNs);
        output.append("!\n!  Effective core Potentials \n");
        output.append("!  ------------------------- \n");
    }

    @Override
    protected void addFooterECP(StringBuffer output) {
        output.append("*\n");
    }

    @Override
    protected void addElementDescriptionECP(StringBuffer output, Element potentials, String element) {
        String nelec = potentials.getAttributeValue("numElectronsReplaced");
        output.append("*\n" + element.toUpperCase() + ":ECP-" + nelec + "\n");
        output.append("# ECP from " + this.mTitle + "       - " + nelec + " CORE ELECTRONS\n");
        output.append("*\n    NCORE = " + nelec + "     LMAX =" + this.mLMax + "\n");
    }

    @Override
    protected void readCmlMatrixECP(StringBuffer output, Matrix matrix, String element, String shell, String potentialType) throws FormatException {
        int rows = matrix.getNumRows();
        int columns = matrix.getNumColumns();
        output.append(potentialType.split(" ")[0] + "\n");
        try {
            for (int i = 0; i < rows; ++i) {
                String value = this.fixedFormatValue(matrix.getValue(i, columns - 1), 14, 7);
                output.append(value);
                value = this.formatInteger(matrix.getValue(i, 0), 5);
                output.append(value);
                for (int j = 1; j < columns - 1; ++j) {
                    value = this.fixedFormatValue(matrix.getValue(i, j), 14, 7);
                    output.append(value);
                }
                output.append("\n");
            }
        }
        catch (IndexOutOfBoundsException ie) {
            throw new FormatException(ie.getMessage());
        }
    }

    public static void main(String[] args) {
        BasisXmlToAcesiiEcpInput xlator = new BasisXmlToAcesiiEcpInput();
        try {
            String dir = "/msrc/tmp/karen/gaussian/";
            String bsname = "LANL2DZ-ECP.xml";
            bsname = "STUTTGART-MCDHF-RSC-ECP.xml";
            String outfile = "/tmp/" + bsname + ".acesiiecp";
            File file = new File(dir + bsname);
            FileInputStream fis = new FileInputStream(file);
            int numBytes = fis.available();
            byte[] b = new byte[numBytes];
            fis.read(b);
            String data = new String(b);
            Vector<String> elements = new Vector<String>();
            elements.add("Tl");
            String result = xlator.convert(data, elements, false);
            System.out.println(result);
            File ofile = new File(outfile);
            FileOutputStream fos = new FileOutputStream(ofile);
            fos.write(result.getBytes());
        }
        catch (Exception ex) {
            System.out.println("Exception" + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

