/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.chefproject.core.Edit;
import org.chefproject.core.MailArchiveChannel;
import org.chefproject.core.MailArchiveChannelEdit;
import org.chefproject.core.MailArchiveMessage;
import org.chefproject.core.MailArchiveMessageEdit;
import org.chefproject.core.MailArchiveMessageHeader;
import org.chefproject.core.MailArchiveMessageHeaderEdit;
import org.chefproject.core.Message;
import org.chefproject.core.MessageChannel;
import org.chefproject.core.MessageHeader;
import org.chefproject.core.MessageHeaderEdit;
import org.chefproject.core.Resource;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.component.BaseMessageService;
import org.chefproject.service.generic.GenericMailArchiveService;
import org.chefproject.util.Different;
import org.chefproject.util.ReferenceVector;
import org.chefproject.util.Time;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseMailArchiveService
extends BaseMessageService
implements GenericMailArchiveService {
    public Resource newContainer(String ref) {
        return new BaseMailArchiveChannelEdit(ref);
    }

    public Resource newContainer(Element element) {
        return new BaseMailArchiveChannelEdit(element);
    }

    public Resource newContainer(Resource other) {
        return new BaseMailArchiveChannelEdit((MessageChannel)other);
    }

    public Resource newResource(Resource container, String id, Object[] others) {
        return new BaseMailArchiveMessageEdit((MessageChannel)container, id);
    }

    public Resource newResource(Resource container, Element element) {
        return new BaseMailArchiveMessageEdit((MessageChannel)container, element);
    }

    public Resource newResource(Resource container, Resource other) {
        return new BaseMailArchiveMessageEdit((MessageChannel)container, (Message)other);
    }

    public Edit newContainerEdit(String ref) {
        BaseMailArchiveChannelEdit rv = new BaseMailArchiveChannelEdit(ref);
        rv.activate();
        return rv;
    }

    public Edit newContainerEdit(Element element) {
        BaseMailArchiveChannelEdit rv = new BaseMailArchiveChannelEdit(element);
        rv.activate();
        return rv;
    }

    public Edit newContainerEdit(Resource other) {
        BaseMailArchiveChannelEdit rv = new BaseMailArchiveChannelEdit((MessageChannel)other);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, String id, Object[] others) {
        BaseMailArchiveMessageEdit rv = new BaseMailArchiveMessageEdit((MessageChannel)container, id);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, Element element) {
        BaseMailArchiveMessageEdit rv = new BaseMailArchiveMessageEdit((MessageChannel)container, element);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, Resource other) {
        BaseMailArchiveMessageEdit rv = new BaseMailArchiveMessageEdit((MessageChannel)container, (Message)other);
        rv.activate();
        return rv;
    }

    public Object[] storageFields(Resource r) {
        Object[] rv = new Object[]{((MailArchiveMessage)r).getMailArchiveHeader().getDateSent()};
        return rv;
    }

    protected MessageHeaderEdit newMessageHeader(String id) {
        return new BaseMailArchiveMessageHeaderEdit(id);
    }

    protected MessageHeaderEdit newMessageHeader(Element el) {
        return new BaseMailArchiveMessageHeaderEdit(el);
    }

    protected MessageHeaderEdit newMessageHeader(MessageHeader other) {
        return new BaseMailArchiveMessageHeaderEdit(other);
    }

    protected String eventId(String secure) {
        return "mail." + secure;
    }

    protected String getReferenceRoot() {
        return "/mailarchive";
    }

    public MailArchiveChannel getMailArchiveChannel(String ref) throws IdUnusedException, PermissionException {
        return (MailArchiveChannel)this.getChannel(ref);
    }

    public MailArchiveChannelEdit addMailArchiveChannel(String ref) throws IdUsedException, IdInvalidException, PermissionException {
        return (MailArchiveChannelEdit)this.addChannel(ref);
    }

    public class BaseMailArchiveMessageHeaderEdit
    extends BaseMessageService.BaseMessageHeaderEdit
    implements MailArchiveMessageHeaderEdit {
        protected String m_subject = null;
        protected String m_fromAddress = null;
        protected Time m_dateSent = null;
        protected List m_mailHeaders = new Vector();

        public BaseMailArchiveMessageHeaderEdit(String id) {
            super((BaseMessageService)BaseMailArchiveService.this, id);
        }

        public BaseMailArchiveMessageHeaderEdit(Element el) {
            super((BaseMessageService)BaseMailArchiveService.this, el);
            this.m_subject = el.getAttribute("subject");
            this.m_fromAddress = el.getAttribute("mail-from");
            this.m_dateSent = new Time(el.getAttribute("mail-date"));
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("mail-header")) {
                    this.m_mailHeaders.add(element.getAttribute("value"));
                }
                ++i;
            }
        }

        public BaseMailArchiveMessageHeaderEdit(MessageHeader other) {
            super((BaseMessageService)BaseMailArchiveService.this, other);
            this.m_subject = ((MailArchiveMessageHeader)other).getSubject();
            this.m_fromAddress = ((MailArchiveMessageHeader)other).getFromAddress();
            this.m_dateSent = ((MailArchiveMessageHeader)other).getDateSent();
            this.m_mailHeaders.addAll(((MailArchiveMessageHeader)other).getMailHeaders());
        }

        public String getSubject() {
            return this.m_subject == null ? "" : this.m_subject;
        }

        public void setSubject(String subject) {
            if (Different.different(subject, this.m_subject)) {
                this.m_subject = subject;
            }
        }

        public String getFromAddress() {
            return this.m_fromAddress == null ? "" : this.m_fromAddress;
        }

        public void setFromAddress(String from) {
            if (Different.different(from, this.m_fromAddress)) {
                this.m_fromAddress = from;
            }
        }

        public Time getDateSent() {
            return this.m_dateSent == null ? this.getDate() : this.m_dateSent;
        }

        public void setDateSent(Time sent) {
            if (Different.different(sent, this.m_dateSent)) {
                this.m_dateSent = new Time(sent.getTime());
            }
        }

        public List getMailHeaders() {
            return this.m_mailHeaders;
        }

        public void setMailHeaders(List headers) {
            this.m_mailHeaders.clear();
            this.m_mailHeaders.addAll(headers);
        }

        public Element toXml(Document doc, Stack stack) {
            Element header = super.toXml(doc, stack);
            header.setAttribute("subject", this.getSubject());
            header.setAttribute("mail-from", this.getFromAddress());
            header.setAttribute("mail-date", this.getDateSent().toString());
            int i = 0;
            while (i < this.m_mailHeaders.size()) {
                Element mailHeader = doc.createElement("mail-header");
                header.appendChild(mailHeader);
                mailHeader.setAttribute("value", (String)this.m_mailHeaders.get(i));
                ++i;
            }
            return header;
        }
    }

    public class BaseMailArchiveMessageEdit
    extends BaseMessageService.BaseMessageEdit
    implements MailArchiveMessageEdit {
        public BaseMailArchiveMessageEdit(MessageChannel channel, String id) {
            super((BaseMessageService)BaseMailArchiveService.this, channel, id);
        }

        public BaseMailArchiveMessageEdit(MessageChannel channel, Message other) {
            super((BaseMessageService)BaseMailArchiveService.this, channel, other);
        }

        public BaseMailArchiveMessageEdit(MessageChannel channel, Element el) {
            super((BaseMessageService)BaseMailArchiveService.this, channel, el);
        }

        public MailArchiveMessageHeader getMailArchiveHeader() {
            return (MailArchiveMessageHeader)this.getHeader();
        }

        public MailArchiveMessageHeaderEdit getMailArchiveHeaderEdit() {
            return (MailArchiveMessageHeaderEdit)this.getHeader();
        }
    }

    public class BaseMailArchiveChannelEdit
    extends BaseMessageService.BaseMessageChannelEdit
    implements MailArchiveChannelEdit {
        public BaseMailArchiveChannelEdit(String ref) {
            super((BaseMessageService)BaseMailArchiveService.this, ref);
        }

        public BaseMailArchiveChannelEdit(MessageChannel other) {
            super((BaseMessageService)BaseMailArchiveService.this, other);
        }

        public BaseMailArchiveChannelEdit(Element el) {
            super((BaseMessageService)BaseMailArchiveService.this, el);
        }

        public MailArchiveMessage getMailArchiveMessage(String messageId) throws IdUnusedException, PermissionException {
            MailArchiveMessage msg = (MailArchiveMessage)this.getMessage(messageId);
            return msg;
        }

        public MailArchiveMessageEdit editMailArchiveMessage(String messageId) throws IdUnusedException, PermissionException, InUseException {
            return (MailArchiveMessageEdit)this.editMessage(messageId);
        }

        public MailArchiveMessageEdit addMailArchiveMessage() throws PermissionException {
            return (MailArchiveMessageEdit)this.addMessage();
        }

        public MailArchiveMessage addMailArchiveMessage(String subject, String fromAddress, Time dateSent, List mailHeaders, ReferenceVector attachments, String body) throws PermissionException {
            MailArchiveMessageEdit edit = (MailArchiveMessageEdit)this.addMessage();
            MailArchiveMessageHeaderEdit header = edit.getMailArchiveHeaderEdit();
            edit.setBody(body);
            header.replaceAttachments(attachments);
            header.setSubject(subject);
            header.setFromAddress(fromAddress);
            header.setDateSent(dateSent);
            header.setMailHeaders(mailHeaders);
            this.commitMessage(edit);
            return edit;
        }

        public boolean getEnabled() {
            boolean enabled = false;
            try {
                enabled = this.getProperties().getBooleanProperty("CHEF:channel-enabled");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return enabled;
        }

        public boolean getOpen() {
            boolean open = false;
            try {
                open = this.getProperties().getBooleanProperty("CHEF:mail-channel-open");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return open;
        }

        public void setEnabled(boolean setting) {
            if (setting) {
                this.getPropertiesEdit().addProperty("CHEF:channel-enabled", "true");
            } else {
                this.getPropertiesEdit().removeProperty("CHEF:channel-enabled");
            }
        }

        public void setOpen(boolean setting) {
            if (setting) {
                this.getPropertiesEdit().addProperty("CHEF:mail-channel-open", "true");
            } else {
                this.getPropertiesEdit().removeProperty("CHEF:mail-channel-open");
            }
        }
    }
}

