//=======================================================================
// pkg.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef PACO_PKG_H
#define PACO_PKG_H

#include "paco/basepkg.h"
#include "pkgset.h"

namespace Paco {

class Options;

class Pkg : public BasePkg
{
	public:

	Pkg(std::string const&);
	virtual ~Pkg();

	void unlog() const;
	void printInfo() const;
	bool update() const;
	long countShared(PkgSet& all);
	void printConfOpts(bool printPkgName) const;
	void remove(Options&);
	void upgradeLog() const;

	static std::string getBase(std::string const&);
	static std::string getVersion(std::string const&);

	class Lister
	{
		public:
	
		Lister(Options&, PkgSet&);
		~Lister();
		
		Pkg* operator()(Pkg*);

		private:
	
		Options&	mOpt;
		PkgSet& 	mSet;
		PkgSet 		mAllPkgs;
		int 		mSizeInstWidth;
		int 		mSizeMissWidth;
		int 		mFilesInstWidth;
		int 		mFilesMissWidth;
		int 		mFilesSharedWidth;

		void printFilesInst(long n) const;
		void printFilesMiss(long n) const;
		void printFilesShared(long n) const;
		void printDate(int time) const;
		int getSizeInstWidth();
		int getSizeMissWidth();
		int getFilesInstWidth();
		int getFilesMissWidth();
		template <typename T> void printSizeInst(T size) const;
		template <typename T> void printSizeMiss(T size) const;

	}; 	// class Pkg::Lister


	class FileLister
	{
		public:

		FileLister(Options&, PkgSet&);
		~FileLister();

		Pkg* operator()(Pkg*);

		private:

		Options& 		mOpt;
		PkgSet& 		mSet;
		int 			mSizeWidth;
		bool			mPrintTotal;
		float 			mTotalSize;
		PkgSet	 		mAllPkgs;
		unsigned 		mPkgCnt;
		unsigned long 	mFileCnt;

		void listFiles(Pkg*);
		void printFile(File*);
		void listSharedFiles(Pkg*);
		void listNonSharedFiles(Pkg*);
		int getSizeWidth();

	}; 	// class Pkg::FileLister

};		// class Pkg

}		// namespace Paco

#endif  // PACO_PKG_H
