--TEST--
Decimal128: [basx159] Numbers with E
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/basic.inc';

$canonicalBson = hex2bin('1800000013640049000000000000000000000000002E3000');
$canonicalExtJson = '{"d" : {"$numberDecimal" : "7.3E-8"}}';
$degenerateExtJson = '{"d" : {"$numberDecimal" : "0.73e-7"}}';

// Canonical BSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromBSON($canonicalBson)), "\n";

// Canonical BSON -> BSON object -> Canonical extJSON
echo json_canonicalize(MongoDB\BSON\Document::fromBSON($canonicalBson)->toCanonicalExtendedJSON()), "\n";

// Canonical extJSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromJSON($canonicalExtJson)), "\n";

// Degenerate extJSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromJSON($degenerateExtJson)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
1800000013640049000000000000000000000000002e3000
{"d":{"$numberDecimal":"7.3E-8"}}
1800000013640049000000000000000000000000002e3000
1800000013640049000000000000000000000000002e3000
===DONE===