/*
 * @BEGIN LICENSE
 *
 * Psi4: an open-source quantum chemistry software package
 *
 * Copyright (c) 2007-2017 The Psi4 Developers.
 *
 * The copyrights for code used from other parties are included in
 * the corresponding files.
 *
 * This file is part of Psi4.
 *
 * Psi4 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, version 3.
 *
 * Psi4 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along
 * with Psi4; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * @END LICENSE
 */

#include<map>

 /**
  * Provides the data needed to implement Davidson's DCD approach to symmetrizing integrals
  * E. R. Davidson, J. Chem. Phys., 62, 400 (1975)
  * Do not modify this file! It was autogenerated by the C++ program DCD.cplusplus in the source folder.
  * Two ordering schemes are used here.  Dense numbering is a point group specific scheme, which runs from
  * zero to the number of subgroups in the point group.   This is used for the arrays, to make them as compact as
  * possible.  Bitwise numbering represents point groups by considering each bit as a symmetry operation.  This
  * is not dense, but allows me to do group theory very conveniently, so it's used internally.
  * Andy Simmonett.
  */

class DCD{
private:

  /// The number of subgroups in the current point group, pg_.
  int nsub_;
  /// The dimensions of each subgroup.
  int *subgroup_dimensions_;
  /// The lookup array for the DCR list of operators for all possiblepairs of stabilizer subgroups.
  int ***dcr_;
  /// The lookup array for the intersection of all possible pairs of subgroups.
  int **gng_;
  /// The bit representation to dense numbering mapping.
  std::map<int, int> bits_to_subgroup_;
  /// The lists of operators in each possible subgroup.
  int *C1_operators_;
  int *C2_z_operators_;
  int *C2_y_operators_;
  int *C2_x_operators_;
  int *D2_operators_;
  int *Ci_operators_;
  int *Cs_xy_operators_;
  int *C2h_z_operators_;
  int *Cs_xz_operators_;
  int *C2h_y_operators_;
  int *C2v_x_operators_;
  int *Cs_yz_operators_;
  int *C2h_x_operators_;
  int *C2v_y_operators_;
  int *C2v_z_operators_;
  int *D2h_operators_;


public:

  /**
   * Builds a DCD object, to perform double coset decompositions
   * @param pg the point group of the molecule, in bitwise representation
   */
  DCD(int pg)
  {
    C1_operators_ = 0;
    C2_z_operators_ = 0;
    C2_y_operators_ = 0;
    C2_x_operators_ = 0;
    D2_operators_ = 0;
    Ci_operators_ = 0;
    Cs_xy_operators_ = 0;
    C2h_z_operators_ = 0;
    Cs_xz_operators_ = 0;
    C2h_y_operators_ = 0;
    C2v_x_operators_ = 0;
    Cs_yz_operators_ = 0;
    C2h_x_operators_ = 0;
    C2v_y_operators_ = 0;
    C2v_z_operators_ = 0;
    D2h_operators_ = 0;
    if(pg == 0) { // C1
        nsub_ = 1;
        subgroup_dimensions_ = new int[1];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        bits_to_subgroup_[0] = 0; // C1

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = C1_operators_; // C1, C1 = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
    }else if(pg == 1) { // C2_z
        nsub_ = 2;
        subgroup_dimensions_ = new int[2];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        C2_z_operators_ = new int[3];
        C2_z_operators_[0] = 2; // 2 element(s) in the list
        C2_z_operators_[1] = 0; //  E 
        C2_z_operators_[2] = 1; // C2z
        subgroup_dimensions_[1] = 2;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[1] = 1; // C2_z

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = C2_z_operators_; // C1, C1 = C2_z
        dcr_[0][1] = C1_operators_; // C1, C2_z = C1
        dcr_[1][0] = C1_operators_; // C2_z, C1 = C1
        dcr_[1][1] = C1_operators_; // C2_z, C2_z = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, C2_z = C1
        gng_[1][0] = 0; // C2_z, C1 = C1
        gng_[1][1] = 1; // C2_z, C2_z = C2_z
    }else if(pg == 2) { // C2_y
        nsub_ = 2;
        subgroup_dimensions_ = new int[2];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        C2_y_operators_ = new int[3];
        C2_y_operators_[0] = 2; // 2 element(s) in the list
        C2_y_operators_[1] = 0; //  E 
        C2_y_operators_[2] = 1; // C2y
        subgroup_dimensions_[1] = 2;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[2] = 1; // C2_y

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = C2_y_operators_; // C1, C1 = C2_y
        dcr_[0][1] = C1_operators_; // C1, C2_y = C1
        dcr_[1][0] = C1_operators_; // C2_y, C1 = C1
        dcr_[1][1] = C1_operators_; // C2_y, C2_y = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, C2_y = C1
        gng_[1][0] = 0; // C2_y, C1 = C1
        gng_[1][1] = 1; // C2_y, C2_y = C2_y
    }else if(pg == 4) { // C2_x
        nsub_ = 2;
        subgroup_dimensions_ = new int[2];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        C2_x_operators_ = new int[3];
        C2_x_operators_[0] = 2; // 2 element(s) in the list
        C2_x_operators_[1] = 0; //  E 
        C2_x_operators_[2] = 1; // C2x
        subgroup_dimensions_[1] = 2;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[4] = 1; // C2_x

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = C2_x_operators_; // C1, C1 = C2_x
        dcr_[0][1] = C1_operators_; // C1, C2_x = C1
        dcr_[1][0] = C1_operators_; // C2_x, C1 = C1
        dcr_[1][1] = C1_operators_; // C2_x, C2_x = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, C2_x = C1
        gng_[1][0] = 0; // C2_x, C1 = C1
        gng_[1][1] = 1; // C2_x, C2_x = C2_x
    }else if(pg == 7) { // D2
        nsub_ = 5;
        subgroup_dimensions_ = new int[5];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        C2_z_operators_ = new int[3];
        C2_z_operators_[0] = 2; // 2 element(s) in the list
        C2_z_operators_[1] = 0; //  E 
        C2_z_operators_[2] = 1; // C2z
        subgroup_dimensions_[1] = 2;

        C2_y_operators_ = new int[3];
        C2_y_operators_[0] = 2; // 2 element(s) in the list
        C2_y_operators_[1] = 0; //  E 
        C2_y_operators_[2] = 2; // C2y
        subgroup_dimensions_[2] = 2;

        C2_x_operators_ = new int[3];
        C2_x_operators_[0] = 2; // 2 element(s) in the list
        C2_x_operators_[1] = 0; //  E 
        C2_x_operators_[2] = 3; // C2x
        subgroup_dimensions_[3] = 2;

        D2_operators_ = new int[5];
        D2_operators_[0] = 4; // 4 element(s) in the list
        D2_operators_[1] = 0; //  E 
        D2_operators_[2] = 1; // C2z
        D2_operators_[3] = 2; // C2y
        D2_operators_[4] = 3; // C2x
        subgroup_dimensions_[4] = 4;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[1] = 1; // C2_z
        bits_to_subgroup_[2] = 2; // C2_y
        bits_to_subgroup_[4] = 3; // C2_x
        bits_to_subgroup_[7] = 4; // D2

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = D2_operators_; // C1, C1 = D2
        dcr_[0][1] = C2_y_operators_; // C1, C2_z = C2_y
        dcr_[0][2] = C2_z_operators_; // C1, C2_y = C2_z
        dcr_[0][3] = C2_z_operators_; // C1, C2_x = C2_z
        dcr_[0][4] = C1_operators_; // C1, D2 = C1
        dcr_[1][0] = C2_y_operators_; // C2_z, C1 = C2_y
        dcr_[1][1] = C2_y_operators_; // C2_z, C2_z = C2_y
        dcr_[1][2] = C1_operators_; // C2_z, C2_y = C1
        dcr_[1][3] = C1_operators_; // C2_z, C2_x = C1
        dcr_[1][4] = C1_operators_; // C2_z, D2 = C1
        dcr_[2][0] = C2_z_operators_; // C2_y, C1 = C2_z
        dcr_[2][1] = C1_operators_; // C2_y, C2_z = C1
        dcr_[2][2] = C2_z_operators_; // C2_y, C2_y = C2_z
        dcr_[2][3] = C1_operators_; // C2_y, C2_x = C1
        dcr_[2][4] = C1_operators_; // C2_y, D2 = C1
        dcr_[3][0] = C2_z_operators_; // C2_x, C1 = C2_z
        dcr_[3][1] = C1_operators_; // C2_x, C2_z = C1
        dcr_[3][2] = C1_operators_; // C2_x, C2_y = C1
        dcr_[3][3] = C2_z_operators_; // C2_x, C2_x = C2_z
        dcr_[3][4] = C1_operators_; // C2_x, D2 = C1
        dcr_[4][0] = C1_operators_; // D2, C1 = C1
        dcr_[4][1] = C1_operators_; // D2, C2_z = C1
        dcr_[4][2] = C1_operators_; // D2, C2_y = C1
        dcr_[4][3] = C1_operators_; // D2, C2_x = C1
        dcr_[4][4] = C1_operators_; // D2, D2 = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, C2_z = C1
        gng_[0][2] = 0; // C1, C2_y = C1
        gng_[0][3] = 0; // C1, C2_x = C1
        gng_[0][4] = 0; // C1, D2 = C1
        gng_[1][0] = 0; // C2_z, C1 = C1
        gng_[1][1] = 1; // C2_z, C2_z = C2_z
        gng_[1][2] = 0; // C2_z, C2_y = C1
        gng_[1][3] = 0; // C2_z, C2_x = C1
        gng_[1][4] = 1; // C2_z, D2 = C2_z
        gng_[2][0] = 0; // C2_y, C1 = C1
        gng_[2][1] = 0; // C2_y, C2_z = C1
        gng_[2][2] = 2; // C2_y, C2_y = C2_y
        gng_[2][3] = 0; // C2_y, C2_x = C1
        gng_[2][4] = 2; // C2_y, D2 = C2_y
        gng_[3][0] = 0; // C2_x, C1 = C1
        gng_[3][1] = 0; // C2_x, C2_z = C1
        gng_[3][2] = 0; // C2_x, C2_y = C1
        gng_[3][3] = 3; // C2_x, C2_x = C2_x
        gng_[3][4] = 3; // C2_x, D2 = C2_x
        gng_[4][0] = 0; // D2, C1 = C1
        gng_[4][1] = 1; // D2, C2_z = C2_z
        gng_[4][2] = 2; // D2, C2_y = C2_y
        gng_[4][3] = 3; // D2, C2_x = C2_x
        gng_[4][4] = 4; // D2, D2 = D2
    }else if(pg == 8) { // Ci
        nsub_ = 2;
        subgroup_dimensions_ = new int[2];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        Ci_operators_ = new int[3];
        Ci_operators_[0] = 2; // 2 element(s) in the list
        Ci_operators_[1] = 0; //  E 
        Ci_operators_[2] = 1; //  i 
        subgroup_dimensions_[1] = 2;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[8] = 1; // Ci

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = Ci_operators_; // C1, C1 = Ci
        dcr_[0][1] = C1_operators_; // C1, Ci = C1
        dcr_[1][0] = C1_operators_; // Ci, C1 = C1
        dcr_[1][1] = C1_operators_; // Ci, Ci = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, Ci = C1
        gng_[1][0] = 0; // Ci, C1 = C1
        gng_[1][1] = 1; // Ci, Ci = Ci
    }else if(pg == 16) { // Cs_xy
        nsub_ = 2;
        subgroup_dimensions_ = new int[2];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        Cs_xy_operators_ = new int[3];
        Cs_xy_operators_[0] = 2; // 2 element(s) in the list
        Cs_xy_operators_[1] = 0; //  E 
        Cs_xy_operators_[2] = 1; // Sxy
        subgroup_dimensions_[1] = 2;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[16] = 1; // Cs_xy

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = Cs_xy_operators_; // C1, C1 = Cs_xy
        dcr_[0][1] = C1_operators_; // C1, Cs_xy = C1
        dcr_[1][0] = C1_operators_; // Cs_xy, C1 = C1
        dcr_[1][1] = C1_operators_; // Cs_xy, Cs_xy = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, Cs_xy = C1
        gng_[1][0] = 0; // Cs_xy, C1 = C1
        gng_[1][1] = 1; // Cs_xy, Cs_xy = Cs_xy
    }else if(pg == 25) { // C2h_z
        nsub_ = 5;
        subgroup_dimensions_ = new int[5];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        C2_z_operators_ = new int[3];
        C2_z_operators_[0] = 2; // 2 element(s) in the list
        C2_z_operators_[1] = 0; //  E 
        C2_z_operators_[2] = 1; // C2z
        subgroup_dimensions_[1] = 2;

        Ci_operators_ = new int[3];
        Ci_operators_[0] = 2; // 2 element(s) in the list
        Ci_operators_[1] = 0; //  E 
        Ci_operators_[2] = 2; //  i 
        subgroup_dimensions_[2] = 2;

        Cs_xy_operators_ = new int[3];
        Cs_xy_operators_[0] = 2; // 2 element(s) in the list
        Cs_xy_operators_[1] = 0; //  E 
        Cs_xy_operators_[2] = 3; // Sxy
        subgroup_dimensions_[3] = 2;

        C2h_z_operators_ = new int[5];
        C2h_z_operators_[0] = 4; // 4 element(s) in the list
        C2h_z_operators_[1] = 0; //  E 
        C2h_z_operators_[2] = 1; // C2z
        C2h_z_operators_[3] = 2; //  i 
        C2h_z_operators_[4] = 3; // Sxy
        subgroup_dimensions_[4] = 4;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[1] = 1; // C2_z
        bits_to_subgroup_[8] = 2; // Ci
        bits_to_subgroup_[16] = 3; // Cs_xy
        bits_to_subgroup_[25] = 4; // C2h_z

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = C2h_z_operators_; // C1, C1 = C2h_z
        dcr_[0][1] = Ci_operators_; // C1, C2_z = Ci
        dcr_[0][2] = C2_z_operators_; // C1, Ci = C2_z
        dcr_[0][3] = C2_z_operators_; // C1, Cs_xy = C2_z
        dcr_[0][4] = C1_operators_; // C1, C2h_z = C1
        dcr_[1][0] = Ci_operators_; // C2_z, C1 = Ci
        dcr_[1][1] = Ci_operators_; // C2_z, C2_z = Ci
        dcr_[1][2] = C1_operators_; // C2_z, Ci = C1
        dcr_[1][3] = C1_operators_; // C2_z, Cs_xy = C1
        dcr_[1][4] = C1_operators_; // C2_z, C2h_z = C1
        dcr_[2][0] = C2_z_operators_; // Ci, C1 = C2_z
        dcr_[2][1] = C1_operators_; // Ci, C2_z = C1
        dcr_[2][2] = C2_z_operators_; // Ci, Ci = C2_z
        dcr_[2][3] = C1_operators_; // Ci, Cs_xy = C1
        dcr_[2][4] = C1_operators_; // Ci, C2h_z = C1
        dcr_[3][0] = C2_z_operators_; // Cs_xy, C1 = C2_z
        dcr_[3][1] = C1_operators_; // Cs_xy, C2_z = C1
        dcr_[3][2] = C1_operators_; // Cs_xy, Ci = C1
        dcr_[3][3] = C2_z_operators_; // Cs_xy, Cs_xy = C2_z
        dcr_[3][4] = C1_operators_; // Cs_xy, C2h_z = C1
        dcr_[4][0] = C1_operators_; // C2h_z, C1 = C1
        dcr_[4][1] = C1_operators_; // C2h_z, C2_z = C1
        dcr_[4][2] = C1_operators_; // C2h_z, Ci = C1
        dcr_[4][3] = C1_operators_; // C2h_z, Cs_xy = C1
        dcr_[4][4] = C1_operators_; // C2h_z, C2h_z = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, C2_z = C1
        gng_[0][2] = 0; // C1, Ci = C1
        gng_[0][3] = 0; // C1, Cs_xy = C1
        gng_[0][4] = 0; // C1, C2h_z = C1
        gng_[1][0] = 0; // C2_z, C1 = C1
        gng_[1][1] = 1; // C2_z, C2_z = C2_z
        gng_[1][2] = 0; // C2_z, Ci = C1
        gng_[1][3] = 0; // C2_z, Cs_xy = C1
        gng_[1][4] = 1; // C2_z, C2h_z = C2_z
        gng_[2][0] = 0; // Ci, C1 = C1
        gng_[2][1] = 0; // Ci, C2_z = C1
        gng_[2][2] = 2; // Ci, Ci = Ci
        gng_[2][3] = 0; // Ci, Cs_xy = C1
        gng_[2][4] = 2; // Ci, C2h_z = Ci
        gng_[3][0] = 0; // Cs_xy, C1 = C1
        gng_[3][1] = 0; // Cs_xy, C2_z = C1
        gng_[3][2] = 0; // Cs_xy, Ci = C1
        gng_[3][3] = 3; // Cs_xy, Cs_xy = Cs_xy
        gng_[3][4] = 3; // Cs_xy, C2h_z = Cs_xy
        gng_[4][0] = 0; // C2h_z, C1 = C1
        gng_[4][1] = 1; // C2h_z, C2_z = C2_z
        gng_[4][2] = 2; // C2h_z, Ci = Ci
        gng_[4][3] = 3; // C2h_z, Cs_xy = Cs_xy
        gng_[4][4] = 4; // C2h_z, C2h_z = C2h_z
    }else if(pg == 32) { // Cs_xz
        nsub_ = 2;
        subgroup_dimensions_ = new int[2];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        Cs_xz_operators_ = new int[3];
        Cs_xz_operators_[0] = 2; // 2 element(s) in the list
        Cs_xz_operators_[1] = 0; //  E 
        Cs_xz_operators_[2] = 1; // Sxz
        subgroup_dimensions_[1] = 2;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[32] = 1; // Cs_xz

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = Cs_xz_operators_; // C1, C1 = Cs_xz
        dcr_[0][1] = C1_operators_; // C1, Cs_xz = C1
        dcr_[1][0] = C1_operators_; // Cs_xz, C1 = C1
        dcr_[1][1] = C1_operators_; // Cs_xz, Cs_xz = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, Cs_xz = C1
        gng_[1][0] = 0; // Cs_xz, C1 = C1
        gng_[1][1] = 1; // Cs_xz, Cs_xz = Cs_xz
    }else if(pg == 42) { // C2h_y
        nsub_ = 5;
        subgroup_dimensions_ = new int[5];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        C2_y_operators_ = new int[3];
        C2_y_operators_[0] = 2; // 2 element(s) in the list
        C2_y_operators_[1] = 0; //  E 
        C2_y_operators_[2] = 1; // C2y
        subgroup_dimensions_[1] = 2;

        Ci_operators_ = new int[3];
        Ci_operators_[0] = 2; // 2 element(s) in the list
        Ci_operators_[1] = 0; //  E 
        Ci_operators_[2] = 2; //  i 
        subgroup_dimensions_[2] = 2;

        Cs_xz_operators_ = new int[3];
        Cs_xz_operators_[0] = 2; // 2 element(s) in the list
        Cs_xz_operators_[1] = 0; //  E 
        Cs_xz_operators_[2] = 3; // Sxz
        subgroup_dimensions_[3] = 2;

        C2h_y_operators_ = new int[5];
        C2h_y_operators_[0] = 4; // 4 element(s) in the list
        C2h_y_operators_[1] = 0; //  E 
        C2h_y_operators_[2] = 1; // C2y
        C2h_y_operators_[3] = 2; //  i 
        C2h_y_operators_[4] = 3; // Sxz
        subgroup_dimensions_[4] = 4;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[2] = 1; // C2_y
        bits_to_subgroup_[8] = 2; // Ci
        bits_to_subgroup_[32] = 3; // Cs_xz
        bits_to_subgroup_[42] = 4; // C2h_y

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = C2h_y_operators_; // C1, C1 = C2h_y
        dcr_[0][1] = Ci_operators_; // C1, C2_y = Ci
        dcr_[0][2] = C2_y_operators_; // C1, Ci = C2_y
        dcr_[0][3] = C2_y_operators_; // C1, Cs_xz = C2_y
        dcr_[0][4] = C1_operators_; // C1, C2h_y = C1
        dcr_[1][0] = Ci_operators_; // C2_y, C1 = Ci
        dcr_[1][1] = Ci_operators_; // C2_y, C2_y = Ci
        dcr_[1][2] = C1_operators_; // C2_y, Ci = C1
        dcr_[1][3] = C1_operators_; // C2_y, Cs_xz = C1
        dcr_[1][4] = C1_operators_; // C2_y, C2h_y = C1
        dcr_[2][0] = C2_y_operators_; // Ci, C1 = C2_y
        dcr_[2][1] = C1_operators_; // Ci, C2_y = C1
        dcr_[2][2] = C2_y_operators_; // Ci, Ci = C2_y
        dcr_[2][3] = C1_operators_; // Ci, Cs_xz = C1
        dcr_[2][4] = C1_operators_; // Ci, C2h_y = C1
        dcr_[3][0] = C2_y_operators_; // Cs_xz, C1 = C2_y
        dcr_[3][1] = C1_operators_; // Cs_xz, C2_y = C1
        dcr_[3][2] = C1_operators_; // Cs_xz, Ci = C1
        dcr_[3][3] = C2_y_operators_; // Cs_xz, Cs_xz = C2_y
        dcr_[3][4] = C1_operators_; // Cs_xz, C2h_y = C1
        dcr_[4][0] = C1_operators_; // C2h_y, C1 = C1
        dcr_[4][1] = C1_operators_; // C2h_y, C2_y = C1
        dcr_[4][2] = C1_operators_; // C2h_y, Ci = C1
        dcr_[4][3] = C1_operators_; // C2h_y, Cs_xz = C1
        dcr_[4][4] = C1_operators_; // C2h_y, C2h_y = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, C2_y = C1
        gng_[0][2] = 0; // C1, Ci = C1
        gng_[0][3] = 0; // C1, Cs_xz = C1
        gng_[0][4] = 0; // C1, C2h_y = C1
        gng_[1][0] = 0; // C2_y, C1 = C1
        gng_[1][1] = 1; // C2_y, C2_y = C2_y
        gng_[1][2] = 0; // C2_y, Ci = C1
        gng_[1][3] = 0; // C2_y, Cs_xz = C1
        gng_[1][4] = 1; // C2_y, C2h_y = C2_y
        gng_[2][0] = 0; // Ci, C1 = C1
        gng_[2][1] = 0; // Ci, C2_y = C1
        gng_[2][2] = 2; // Ci, Ci = Ci
        gng_[2][3] = 0; // Ci, Cs_xz = C1
        gng_[2][4] = 2; // Ci, C2h_y = Ci
        gng_[3][0] = 0; // Cs_xz, C1 = C1
        gng_[3][1] = 0; // Cs_xz, C2_y = C1
        gng_[3][2] = 0; // Cs_xz, Ci = C1
        gng_[3][3] = 3; // Cs_xz, Cs_xz = Cs_xz
        gng_[3][4] = 3; // Cs_xz, C2h_y = Cs_xz
        gng_[4][0] = 0; // C2h_y, C1 = C1
        gng_[4][1] = 1; // C2h_y, C2_y = C2_y
        gng_[4][2] = 2; // C2h_y, Ci = Ci
        gng_[4][3] = 3; // C2h_y, Cs_xz = Cs_xz
        gng_[4][4] = 4; // C2h_y, C2h_y = C2h_y
    }else if(pg == 52) { // C2v_x
        nsub_ = 5;
        subgroup_dimensions_ = new int[5];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        C2_x_operators_ = new int[3];
        C2_x_operators_[0] = 2; // 2 element(s) in the list
        C2_x_operators_[1] = 0; //  E 
        C2_x_operators_[2] = 1; // C2x
        subgroup_dimensions_[1] = 2;

        Cs_xy_operators_ = new int[3];
        Cs_xy_operators_[0] = 2; // 2 element(s) in the list
        Cs_xy_operators_[1] = 0; //  E 
        Cs_xy_operators_[2] = 2; // Sxy
        subgroup_dimensions_[2] = 2;

        Cs_xz_operators_ = new int[3];
        Cs_xz_operators_[0] = 2; // 2 element(s) in the list
        Cs_xz_operators_[1] = 0; //  E 
        Cs_xz_operators_[2] = 3; // Sxz
        subgroup_dimensions_[3] = 2;

        C2v_x_operators_ = new int[5];
        C2v_x_operators_[0] = 4; // 4 element(s) in the list
        C2v_x_operators_[1] = 0; //  E 
        C2v_x_operators_[2] = 1; // C2x
        C2v_x_operators_[3] = 2; // Sxy
        C2v_x_operators_[4] = 3; // Sxz
        subgroup_dimensions_[4] = 4;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[4] = 1; // C2_x
        bits_to_subgroup_[16] = 2; // Cs_xy
        bits_to_subgroup_[32] = 3; // Cs_xz
        bits_to_subgroup_[52] = 4; // C2v_x

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = C2v_x_operators_; // C1, C1 = C2v_x
        dcr_[0][1] = Cs_xy_operators_; // C1, C2_x = Cs_xy
        dcr_[0][2] = C2_x_operators_; // C1, Cs_xy = C2_x
        dcr_[0][3] = C2_x_operators_; // C1, Cs_xz = C2_x
        dcr_[0][4] = C1_operators_; // C1, C2v_x = C1
        dcr_[1][0] = Cs_xy_operators_; // C2_x, C1 = Cs_xy
        dcr_[1][1] = Cs_xy_operators_; // C2_x, C2_x = Cs_xy
        dcr_[1][2] = C1_operators_; // C2_x, Cs_xy = C1
        dcr_[1][3] = C1_operators_; // C2_x, Cs_xz = C1
        dcr_[1][4] = C1_operators_; // C2_x, C2v_x = C1
        dcr_[2][0] = C2_x_operators_; // Cs_xy, C1 = C2_x
        dcr_[2][1] = C1_operators_; // Cs_xy, C2_x = C1
        dcr_[2][2] = C2_x_operators_; // Cs_xy, Cs_xy = C2_x
        dcr_[2][3] = C1_operators_; // Cs_xy, Cs_xz = C1
        dcr_[2][4] = C1_operators_; // Cs_xy, C2v_x = C1
        dcr_[3][0] = C2_x_operators_; // Cs_xz, C1 = C2_x
        dcr_[3][1] = C1_operators_; // Cs_xz, C2_x = C1
        dcr_[3][2] = C1_operators_; // Cs_xz, Cs_xy = C1
        dcr_[3][3] = C2_x_operators_; // Cs_xz, Cs_xz = C2_x
        dcr_[3][4] = C1_operators_; // Cs_xz, C2v_x = C1
        dcr_[4][0] = C1_operators_; // C2v_x, C1 = C1
        dcr_[4][1] = C1_operators_; // C2v_x, C2_x = C1
        dcr_[4][2] = C1_operators_; // C2v_x, Cs_xy = C1
        dcr_[4][3] = C1_operators_; // C2v_x, Cs_xz = C1
        dcr_[4][4] = C1_operators_; // C2v_x, C2v_x = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, C2_x = C1
        gng_[0][2] = 0; // C1, Cs_xy = C1
        gng_[0][3] = 0; // C1, Cs_xz = C1
        gng_[0][4] = 0; // C1, C2v_x = C1
        gng_[1][0] = 0; // C2_x, C1 = C1
        gng_[1][1] = 1; // C2_x, C2_x = C2_x
        gng_[1][2] = 0; // C2_x, Cs_xy = C1
        gng_[1][3] = 0; // C2_x, Cs_xz = C1
        gng_[1][4] = 1; // C2_x, C2v_x = C2_x
        gng_[2][0] = 0; // Cs_xy, C1 = C1
        gng_[2][1] = 0; // Cs_xy, C2_x = C1
        gng_[2][2] = 2; // Cs_xy, Cs_xy = Cs_xy
        gng_[2][3] = 0; // Cs_xy, Cs_xz = C1
        gng_[2][4] = 2; // Cs_xy, C2v_x = Cs_xy
        gng_[3][0] = 0; // Cs_xz, C1 = C1
        gng_[3][1] = 0; // Cs_xz, C2_x = C1
        gng_[3][2] = 0; // Cs_xz, Cs_xy = C1
        gng_[3][3] = 3; // Cs_xz, Cs_xz = Cs_xz
        gng_[3][4] = 3; // Cs_xz, C2v_x = Cs_xz
        gng_[4][0] = 0; // C2v_x, C1 = C1
        gng_[4][1] = 1; // C2v_x, C2_x = C2_x
        gng_[4][2] = 2; // C2v_x, Cs_xy = Cs_xy
        gng_[4][3] = 3; // C2v_x, Cs_xz = Cs_xz
        gng_[4][4] = 4; // C2v_x, C2v_x = C2v_x
    }else if(pg == 64) { // Cs_yz
        nsub_ = 2;
        subgroup_dimensions_ = new int[2];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        Cs_yz_operators_ = new int[3];
        Cs_yz_operators_[0] = 2; // 2 element(s) in the list
        Cs_yz_operators_[1] = 0; //  E 
        Cs_yz_operators_[2] = 1; // Syz
        subgroup_dimensions_[1] = 2;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[64] = 1; // Cs_yz

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = Cs_yz_operators_; // C1, C1 = Cs_yz
        dcr_[0][1] = C1_operators_; // C1, Cs_yz = C1
        dcr_[1][0] = C1_operators_; // Cs_yz, C1 = C1
        dcr_[1][1] = C1_operators_; // Cs_yz, Cs_yz = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, Cs_yz = C1
        gng_[1][0] = 0; // Cs_yz, C1 = C1
        gng_[1][1] = 1; // Cs_yz, Cs_yz = Cs_yz
    }else if(pg == 76) { // C2h_x
        nsub_ = 5;
        subgroup_dimensions_ = new int[5];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        C2_x_operators_ = new int[3];
        C2_x_operators_[0] = 2; // 2 element(s) in the list
        C2_x_operators_[1] = 0; //  E 
        C2_x_operators_[2] = 1; // C2x
        subgroup_dimensions_[1] = 2;

        Ci_operators_ = new int[3];
        Ci_operators_[0] = 2; // 2 element(s) in the list
        Ci_operators_[1] = 0; //  E 
        Ci_operators_[2] = 2; //  i 
        subgroup_dimensions_[2] = 2;

        Cs_yz_operators_ = new int[3];
        Cs_yz_operators_[0] = 2; // 2 element(s) in the list
        Cs_yz_operators_[1] = 0; //  E 
        Cs_yz_operators_[2] = 3; // Syz
        subgroup_dimensions_[3] = 2;

        C2h_x_operators_ = new int[5];
        C2h_x_operators_[0] = 4; // 4 element(s) in the list
        C2h_x_operators_[1] = 0; //  E 
        C2h_x_operators_[2] = 1; // C2x
        C2h_x_operators_[3] = 2; //  i 
        C2h_x_operators_[4] = 3; // Syz
        subgroup_dimensions_[4] = 4;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[4] = 1; // C2_x
        bits_to_subgroup_[8] = 2; // Ci
        bits_to_subgroup_[64] = 3; // Cs_yz
        bits_to_subgroup_[76] = 4; // C2h_x

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = C2h_x_operators_; // C1, C1 = C2h_x
        dcr_[0][1] = Ci_operators_; // C1, C2_x = Ci
        dcr_[0][2] = C2_x_operators_; // C1, Ci = C2_x
        dcr_[0][3] = C2_x_operators_; // C1, Cs_yz = C2_x
        dcr_[0][4] = C1_operators_; // C1, C2h_x = C1
        dcr_[1][0] = Ci_operators_; // C2_x, C1 = Ci
        dcr_[1][1] = Ci_operators_; // C2_x, C2_x = Ci
        dcr_[1][2] = C1_operators_; // C2_x, Ci = C1
        dcr_[1][3] = C1_operators_; // C2_x, Cs_yz = C1
        dcr_[1][4] = C1_operators_; // C2_x, C2h_x = C1
        dcr_[2][0] = C2_x_operators_; // Ci, C1 = C2_x
        dcr_[2][1] = C1_operators_; // Ci, C2_x = C1
        dcr_[2][2] = C2_x_operators_; // Ci, Ci = C2_x
        dcr_[2][3] = C1_operators_; // Ci, Cs_yz = C1
        dcr_[2][4] = C1_operators_; // Ci, C2h_x = C1
        dcr_[3][0] = C2_x_operators_; // Cs_yz, C1 = C2_x
        dcr_[3][1] = C1_operators_; // Cs_yz, C2_x = C1
        dcr_[3][2] = C1_operators_; // Cs_yz, Ci = C1
        dcr_[3][3] = C2_x_operators_; // Cs_yz, Cs_yz = C2_x
        dcr_[3][4] = C1_operators_; // Cs_yz, C2h_x = C1
        dcr_[4][0] = C1_operators_; // C2h_x, C1 = C1
        dcr_[4][1] = C1_operators_; // C2h_x, C2_x = C1
        dcr_[4][2] = C1_operators_; // C2h_x, Ci = C1
        dcr_[4][3] = C1_operators_; // C2h_x, Cs_yz = C1
        dcr_[4][4] = C1_operators_; // C2h_x, C2h_x = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, C2_x = C1
        gng_[0][2] = 0; // C1, Ci = C1
        gng_[0][3] = 0; // C1, Cs_yz = C1
        gng_[0][4] = 0; // C1, C2h_x = C1
        gng_[1][0] = 0; // C2_x, C1 = C1
        gng_[1][1] = 1; // C2_x, C2_x = C2_x
        gng_[1][2] = 0; // C2_x, Ci = C1
        gng_[1][3] = 0; // C2_x, Cs_yz = C1
        gng_[1][4] = 1; // C2_x, C2h_x = C2_x
        gng_[2][0] = 0; // Ci, C1 = C1
        gng_[2][1] = 0; // Ci, C2_x = C1
        gng_[2][2] = 2; // Ci, Ci = Ci
        gng_[2][3] = 0; // Ci, Cs_yz = C1
        gng_[2][4] = 2; // Ci, C2h_x = Ci
        gng_[3][0] = 0; // Cs_yz, C1 = C1
        gng_[3][1] = 0; // Cs_yz, C2_x = C1
        gng_[3][2] = 0; // Cs_yz, Ci = C1
        gng_[3][3] = 3; // Cs_yz, Cs_yz = Cs_yz
        gng_[3][4] = 3; // Cs_yz, C2h_x = Cs_yz
        gng_[4][0] = 0; // C2h_x, C1 = C1
        gng_[4][1] = 1; // C2h_x, C2_x = C2_x
        gng_[4][2] = 2; // C2h_x, Ci = Ci
        gng_[4][3] = 3; // C2h_x, Cs_yz = Cs_yz
        gng_[4][4] = 4; // C2h_x, C2h_x = C2h_x
    }else if(pg == 82) { // C2v_y
        nsub_ = 5;
        subgroup_dimensions_ = new int[5];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        C2_y_operators_ = new int[3];
        C2_y_operators_[0] = 2; // 2 element(s) in the list
        C2_y_operators_[1] = 0; //  E 
        C2_y_operators_[2] = 1; // C2y
        subgroup_dimensions_[1] = 2;

        Cs_xy_operators_ = new int[3];
        Cs_xy_operators_[0] = 2; // 2 element(s) in the list
        Cs_xy_operators_[1] = 0; //  E 
        Cs_xy_operators_[2] = 2; // Sxy
        subgroup_dimensions_[2] = 2;

        Cs_yz_operators_ = new int[3];
        Cs_yz_operators_[0] = 2; // 2 element(s) in the list
        Cs_yz_operators_[1] = 0; //  E 
        Cs_yz_operators_[2] = 3; // Syz
        subgroup_dimensions_[3] = 2;

        C2v_y_operators_ = new int[5];
        C2v_y_operators_[0] = 4; // 4 element(s) in the list
        C2v_y_operators_[1] = 0; //  E 
        C2v_y_operators_[2] = 1; // C2y
        C2v_y_operators_[3] = 2; // Sxy
        C2v_y_operators_[4] = 3; // Syz
        subgroup_dimensions_[4] = 4;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[2] = 1; // C2_y
        bits_to_subgroup_[16] = 2; // Cs_xy
        bits_to_subgroup_[64] = 3; // Cs_yz
        bits_to_subgroup_[82] = 4; // C2v_y

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = C2v_y_operators_; // C1, C1 = C2v_y
        dcr_[0][1] = Cs_xy_operators_; // C1, C2_y = Cs_xy
        dcr_[0][2] = C2_y_operators_; // C1, Cs_xy = C2_y
        dcr_[0][3] = C2_y_operators_; // C1, Cs_yz = C2_y
        dcr_[0][4] = C1_operators_; // C1, C2v_y = C1
        dcr_[1][0] = Cs_xy_operators_; // C2_y, C1 = Cs_xy
        dcr_[1][1] = Cs_xy_operators_; // C2_y, C2_y = Cs_xy
        dcr_[1][2] = C1_operators_; // C2_y, Cs_xy = C1
        dcr_[1][3] = C1_operators_; // C2_y, Cs_yz = C1
        dcr_[1][4] = C1_operators_; // C2_y, C2v_y = C1
        dcr_[2][0] = C2_y_operators_; // Cs_xy, C1 = C2_y
        dcr_[2][1] = C1_operators_; // Cs_xy, C2_y = C1
        dcr_[2][2] = C2_y_operators_; // Cs_xy, Cs_xy = C2_y
        dcr_[2][3] = C1_operators_; // Cs_xy, Cs_yz = C1
        dcr_[2][4] = C1_operators_; // Cs_xy, C2v_y = C1
        dcr_[3][0] = C2_y_operators_; // Cs_yz, C1 = C2_y
        dcr_[3][1] = C1_operators_; // Cs_yz, C2_y = C1
        dcr_[3][2] = C1_operators_; // Cs_yz, Cs_xy = C1
        dcr_[3][3] = C2_y_operators_; // Cs_yz, Cs_yz = C2_y
        dcr_[3][4] = C1_operators_; // Cs_yz, C2v_y = C1
        dcr_[4][0] = C1_operators_; // C2v_y, C1 = C1
        dcr_[4][1] = C1_operators_; // C2v_y, C2_y = C1
        dcr_[4][2] = C1_operators_; // C2v_y, Cs_xy = C1
        dcr_[4][3] = C1_operators_; // C2v_y, Cs_yz = C1
        dcr_[4][4] = C1_operators_; // C2v_y, C2v_y = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, C2_y = C1
        gng_[0][2] = 0; // C1, Cs_xy = C1
        gng_[0][3] = 0; // C1, Cs_yz = C1
        gng_[0][4] = 0; // C1, C2v_y = C1
        gng_[1][0] = 0; // C2_y, C1 = C1
        gng_[1][1] = 1; // C2_y, C2_y = C2_y
        gng_[1][2] = 0; // C2_y, Cs_xy = C1
        gng_[1][3] = 0; // C2_y, Cs_yz = C1
        gng_[1][4] = 1; // C2_y, C2v_y = C2_y
        gng_[2][0] = 0; // Cs_xy, C1 = C1
        gng_[2][1] = 0; // Cs_xy, C2_y = C1
        gng_[2][2] = 2; // Cs_xy, Cs_xy = Cs_xy
        gng_[2][3] = 0; // Cs_xy, Cs_yz = C1
        gng_[2][4] = 2; // Cs_xy, C2v_y = Cs_xy
        gng_[3][0] = 0; // Cs_yz, C1 = C1
        gng_[3][1] = 0; // Cs_yz, C2_y = C1
        gng_[3][2] = 0; // Cs_yz, Cs_xy = C1
        gng_[3][3] = 3; // Cs_yz, Cs_yz = Cs_yz
        gng_[3][4] = 3; // Cs_yz, C2v_y = Cs_yz
        gng_[4][0] = 0; // C2v_y, C1 = C1
        gng_[4][1] = 1; // C2v_y, C2_y = C2_y
        gng_[4][2] = 2; // C2v_y, Cs_xy = Cs_xy
        gng_[4][3] = 3; // C2v_y, Cs_yz = Cs_yz
        gng_[4][4] = 4; // C2v_y, C2v_y = C2v_y
    }else if(pg == 97) { // C2v_z
        nsub_ = 5;
        subgroup_dimensions_ = new int[5];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        C2_z_operators_ = new int[3];
        C2_z_operators_[0] = 2; // 2 element(s) in the list
        C2_z_operators_[1] = 0; //  E 
        C2_z_operators_[2] = 1; // C2z
        subgroup_dimensions_[1] = 2;

        Cs_xz_operators_ = new int[3];
        Cs_xz_operators_[0] = 2; // 2 element(s) in the list
        Cs_xz_operators_[1] = 0; //  E 
        Cs_xz_operators_[2] = 2; // Sxz
        subgroup_dimensions_[2] = 2;

        Cs_yz_operators_ = new int[3];
        Cs_yz_operators_[0] = 2; // 2 element(s) in the list
        Cs_yz_operators_[1] = 0; //  E 
        Cs_yz_operators_[2] = 3; // Syz
        subgroup_dimensions_[3] = 2;

        C2v_z_operators_ = new int[5];
        C2v_z_operators_[0] = 4; // 4 element(s) in the list
        C2v_z_operators_[1] = 0; //  E 
        C2v_z_operators_[2] = 1; // C2z
        C2v_z_operators_[3] = 2; // Sxz
        C2v_z_operators_[4] = 3; // Syz
        subgroup_dimensions_[4] = 4;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[1] = 1; // C2_z
        bits_to_subgroup_[32] = 2; // Cs_xz
        bits_to_subgroup_[64] = 3; // Cs_yz
        bits_to_subgroup_[97] = 4; // C2v_z

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = C2v_z_operators_; // C1, C1 = C2v_z
        dcr_[0][1] = Cs_xz_operators_; // C1, C2_z = Cs_xz
        dcr_[0][2] = C2_z_operators_; // C1, Cs_xz = C2_z
        dcr_[0][3] = C2_z_operators_; // C1, Cs_yz = C2_z
        dcr_[0][4] = C1_operators_; // C1, C2v_z = C1
        dcr_[1][0] = Cs_xz_operators_; // C2_z, C1 = Cs_xz
        dcr_[1][1] = Cs_xz_operators_; // C2_z, C2_z = Cs_xz
        dcr_[1][2] = C1_operators_; // C2_z, Cs_xz = C1
        dcr_[1][3] = C1_operators_; // C2_z, Cs_yz = C1
        dcr_[1][4] = C1_operators_; // C2_z, C2v_z = C1
        dcr_[2][0] = C2_z_operators_; // Cs_xz, C1 = C2_z
        dcr_[2][1] = C1_operators_; // Cs_xz, C2_z = C1
        dcr_[2][2] = C2_z_operators_; // Cs_xz, Cs_xz = C2_z
        dcr_[2][3] = C1_operators_; // Cs_xz, Cs_yz = C1
        dcr_[2][4] = C1_operators_; // Cs_xz, C2v_z = C1
        dcr_[3][0] = C2_z_operators_; // Cs_yz, C1 = C2_z
        dcr_[3][1] = C1_operators_; // Cs_yz, C2_z = C1
        dcr_[3][2] = C1_operators_; // Cs_yz, Cs_xz = C1
        dcr_[3][3] = C2_z_operators_; // Cs_yz, Cs_yz = C2_z
        dcr_[3][4] = C1_operators_; // Cs_yz, C2v_z = C1
        dcr_[4][0] = C1_operators_; // C2v_z, C1 = C1
        dcr_[4][1] = C1_operators_; // C2v_z, C2_z = C1
        dcr_[4][2] = C1_operators_; // C2v_z, Cs_xz = C1
        dcr_[4][3] = C1_operators_; // C2v_z, Cs_yz = C1
        dcr_[4][4] = C1_operators_; // C2v_z, C2v_z = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, C2_z = C1
        gng_[0][2] = 0; // C1, Cs_xz = C1
        gng_[0][3] = 0; // C1, Cs_yz = C1
        gng_[0][4] = 0; // C1, C2v_z = C1
        gng_[1][0] = 0; // C2_z, C1 = C1
        gng_[1][1] = 1; // C2_z, C2_z = C2_z
        gng_[1][2] = 0; // C2_z, Cs_xz = C1
        gng_[1][3] = 0; // C2_z, Cs_yz = C1
        gng_[1][4] = 1; // C2_z, C2v_z = C2_z
        gng_[2][0] = 0; // Cs_xz, C1 = C1
        gng_[2][1] = 0; // Cs_xz, C2_z = C1
        gng_[2][2] = 2; // Cs_xz, Cs_xz = Cs_xz
        gng_[2][3] = 0; // Cs_xz, Cs_yz = C1
        gng_[2][4] = 2; // Cs_xz, C2v_z = Cs_xz
        gng_[3][0] = 0; // Cs_yz, C1 = C1
        gng_[3][1] = 0; // Cs_yz, C2_z = C1
        gng_[3][2] = 0; // Cs_yz, Cs_xz = C1
        gng_[3][3] = 3; // Cs_yz, Cs_yz = Cs_yz
        gng_[3][4] = 3; // Cs_yz, C2v_z = Cs_yz
        gng_[4][0] = 0; // C2v_z, C1 = C1
        gng_[4][1] = 1; // C2v_z, C2_z = C2_z
        gng_[4][2] = 2; // C2v_z, Cs_xz = Cs_xz
        gng_[4][3] = 3; // C2v_z, Cs_yz = Cs_yz
        gng_[4][4] = 4; // C2v_z, C2v_z = C2v_z
    }else if(pg == 127) { // D2h
        nsub_ = 16;
        subgroup_dimensions_ = new int[16];

        C1_operators_ = new int[2];
        C1_operators_[0] = 1; // 1 element(s) in the list
        C1_operators_[1] = 0; //  E 
        subgroup_dimensions_[0] = 1;

        C2_z_operators_ = new int[3];
        C2_z_operators_[0] = 2; // 2 element(s) in the list
        C2_z_operators_[1] = 0; //  E 
        C2_z_operators_[2] = 1; // C2z
        subgroup_dimensions_[1] = 2;

        C2_y_operators_ = new int[3];
        C2_y_operators_[0] = 2; // 2 element(s) in the list
        C2_y_operators_[1] = 0; //  E 
        C2_y_operators_[2] = 2; // C2y
        subgroup_dimensions_[2] = 2;

        C2_x_operators_ = new int[3];
        C2_x_operators_[0] = 2; // 2 element(s) in the list
        C2_x_operators_[1] = 0; //  E 
        C2_x_operators_[2] = 3; // C2x
        subgroup_dimensions_[3] = 2;

        D2_operators_ = new int[5];
        D2_operators_[0] = 4; // 4 element(s) in the list
        D2_operators_[1] = 0; //  E 
        D2_operators_[2] = 1; // C2z
        D2_operators_[3] = 2; // C2y
        D2_operators_[4] = 3; // C2x
        subgroup_dimensions_[4] = 4;

        Ci_operators_ = new int[3];
        Ci_operators_[0] = 2; // 2 element(s) in the list
        Ci_operators_[1] = 0; //  E 
        Ci_operators_[2] = 4; //  i 
        subgroup_dimensions_[5] = 2;

        Cs_xy_operators_ = new int[3];
        Cs_xy_operators_[0] = 2; // 2 element(s) in the list
        Cs_xy_operators_[1] = 0; //  E 
        Cs_xy_operators_[2] = 5; // Sxy
        subgroup_dimensions_[6] = 2;

        C2h_z_operators_ = new int[5];
        C2h_z_operators_[0] = 4; // 4 element(s) in the list
        C2h_z_operators_[1] = 0; //  E 
        C2h_z_operators_[2] = 1; // C2z
        C2h_z_operators_[3] = 4; //  i 
        C2h_z_operators_[4] = 5; // Sxy
        subgroup_dimensions_[7] = 4;

        Cs_xz_operators_ = new int[3];
        Cs_xz_operators_[0] = 2; // 2 element(s) in the list
        Cs_xz_operators_[1] = 0; //  E 
        Cs_xz_operators_[2] = 6; // Sxz
        subgroup_dimensions_[8] = 2;

        C2h_y_operators_ = new int[5];
        C2h_y_operators_[0] = 4; // 4 element(s) in the list
        C2h_y_operators_[1] = 0; //  E 
        C2h_y_operators_[2] = 2; // C2y
        C2h_y_operators_[3] = 4; //  i 
        C2h_y_operators_[4] = 6; // Sxz
        subgroup_dimensions_[9] = 4;

        C2v_x_operators_ = new int[5];
        C2v_x_operators_[0] = 4; // 4 element(s) in the list
        C2v_x_operators_[1] = 0; //  E 
        C2v_x_operators_[2] = 3; // C2x
        C2v_x_operators_[3] = 5; // Sxy
        C2v_x_operators_[4] = 6; // Sxz
        subgroup_dimensions_[10] = 4;

        Cs_yz_operators_ = new int[3];
        Cs_yz_operators_[0] = 2; // 2 element(s) in the list
        Cs_yz_operators_[1] = 0; //  E 
        Cs_yz_operators_[2] = 7; // Syz
        subgroup_dimensions_[11] = 2;

        C2h_x_operators_ = new int[5];
        C2h_x_operators_[0] = 4; // 4 element(s) in the list
        C2h_x_operators_[1] = 0; //  E 
        C2h_x_operators_[2] = 3; // C2x
        C2h_x_operators_[3] = 4; //  i 
        C2h_x_operators_[4] = 7; // Syz
        subgroup_dimensions_[12] = 4;

        C2v_y_operators_ = new int[5];
        C2v_y_operators_[0] = 4; // 4 element(s) in the list
        C2v_y_operators_[1] = 0; //  E 
        C2v_y_operators_[2] = 2; // C2y
        C2v_y_operators_[3] = 5; // Sxy
        C2v_y_operators_[4] = 7; // Syz
        subgroup_dimensions_[13] = 4;

        C2v_z_operators_ = new int[5];
        C2v_z_operators_[0] = 4; // 4 element(s) in the list
        C2v_z_operators_[1] = 0; //  E 
        C2v_z_operators_[2] = 1; // C2z
        C2v_z_operators_[3] = 6; // Sxz
        C2v_z_operators_[4] = 7; // Syz
        subgroup_dimensions_[14] = 4;

        D2h_operators_ = new int[9];
        D2h_operators_[0] = 8; // 8 element(s) in the list
        D2h_operators_[1] = 0; //  E 
        D2h_operators_[2] = 1; // C2z
        D2h_operators_[3] = 2; // C2y
        D2h_operators_[4] = 3; // C2x
        D2h_operators_[5] = 4; //  i 
        D2h_operators_[6] = 5; // Sxy
        D2h_operators_[7] = 6; // Sxz
        D2h_operators_[8] = 7; // Syz
        subgroup_dimensions_[15] = 8;

        bits_to_subgroup_[0] = 0; // C1
        bits_to_subgroup_[1] = 1; // C2_z
        bits_to_subgroup_[2] = 2; // C2_y
        bits_to_subgroup_[4] = 3; // C2_x
        bits_to_subgroup_[7] = 4; // D2
        bits_to_subgroup_[8] = 5; // Ci
        bits_to_subgroup_[16] = 6; // Cs_xy
        bits_to_subgroup_[25] = 7; // C2h_z
        bits_to_subgroup_[32] = 8; // Cs_xz
        bits_to_subgroup_[42] = 9; // C2h_y
        bits_to_subgroup_[52] = 10; // C2v_x
        bits_to_subgroup_[64] = 11; // Cs_yz
        bits_to_subgroup_[76] = 12; // C2h_x
        bits_to_subgroup_[82] = 13; // C2v_y
        bits_to_subgroup_[97] = 14; // C2v_z
        bits_to_subgroup_[127] = 15; // D2h

        dcr_ = new int**[nsub_]; for(int n = 0; n < nsub_; ++n) dcr_[n] = new int*[nsub_];
        dcr_[0][0] = D2h_operators_; // C1, C1 = D2h
        dcr_[0][1] = C2h_y_operators_; // C1, C2_z = C2h_y
        dcr_[0][2] = C2h_z_operators_; // C1, C2_y = C2h_z
        dcr_[0][3] = C2h_z_operators_; // C1, C2_x = C2h_z
        dcr_[0][4] = Ci_operators_; // C1, D2 = Ci
        dcr_[0][5] = D2_operators_; // C1, Ci = D2
        dcr_[0][6] = D2_operators_; // C1, Cs_xy = D2
        dcr_[0][7] = C2_y_operators_; // C1, C2h_z = C2_y
        dcr_[0][8] = D2_operators_; // C1, Cs_xz = D2
        dcr_[0][9] = C2_z_operators_; // C1, C2h_y = C2_z
        dcr_[0][10] = C2_z_operators_; // C1, C2v_x = C2_z
        dcr_[0][11] = D2_operators_; // C1, Cs_yz = D2
        dcr_[0][12] = C2_z_operators_; // C1, C2h_x = C2_z
        dcr_[0][13] = C2_z_operators_; // C1, C2v_y = C2_z
        dcr_[0][14] = C2_y_operators_; // C1, C2v_z = C2_y
        dcr_[0][15] = C1_operators_; // C1, D2h = C1
        dcr_[1][0] = C2h_y_operators_; // C2_z, C1 = C2h_y
        dcr_[1][1] = C2h_y_operators_; // C2_z, C2_z = C2h_y
        dcr_[1][2] = Ci_operators_; // C2_z, C2_y = Ci
        dcr_[1][3] = Ci_operators_; // C2_z, C2_x = Ci
        dcr_[1][4] = Ci_operators_; // C2_z, D2 = Ci
        dcr_[1][5] = C2_y_operators_; // C2_z, Ci = C2_y
        dcr_[1][6] = C2_y_operators_; // C2_z, Cs_xy = C2_y
        dcr_[1][7] = C2_y_operators_; // C2_z, C2h_z = C2_y
        dcr_[1][8] = C2_y_operators_; // C2_z, Cs_xz = C2_y
        dcr_[1][9] = C1_operators_; // C2_z, C2h_y = C1
        dcr_[1][10] = C1_operators_; // C2_z, C2v_x = C1
        dcr_[1][11] = C2_y_operators_; // C2_z, Cs_yz = C2_y
        dcr_[1][12] = C1_operators_; // C2_z, C2h_x = C1
        dcr_[1][13] = C1_operators_; // C2_z, C2v_y = C1
        dcr_[1][14] = C2_y_operators_; // C2_z, C2v_z = C2_y
        dcr_[1][15] = C1_operators_; // C2_z, D2h = C1
        dcr_[2][0] = C2h_z_operators_; // C2_y, C1 = C2h_z
        dcr_[2][1] = Ci_operators_; // C2_y, C2_z = Ci
        dcr_[2][2] = C2h_z_operators_; // C2_y, C2_y = C2h_z
        dcr_[2][3] = Ci_operators_; // C2_y, C2_x = Ci
        dcr_[2][4] = Ci_operators_; // C2_y, D2 = Ci
        dcr_[2][5] = C2_z_operators_; // C2_y, Ci = C2_z
        dcr_[2][6] = C2_z_operators_; // C2_y, Cs_xy = C2_z
        dcr_[2][7] = C1_operators_; // C2_y, C2h_z = C1
        dcr_[2][8] = C2_z_operators_; // C2_y, Cs_xz = C2_z
        dcr_[2][9] = C2_z_operators_; // C2_y, C2h_y = C2_z
        dcr_[2][10] = C1_operators_; // C2_y, C2v_x = C1
        dcr_[2][11] = C2_z_operators_; // C2_y, Cs_yz = C2_z
        dcr_[2][12] = C1_operators_; // C2_y, C2h_x = C1
        dcr_[2][13] = C2_z_operators_; // C2_y, C2v_y = C2_z
        dcr_[2][14] = C1_operators_; // C2_y, C2v_z = C1
        dcr_[2][15] = C1_operators_; // C2_y, D2h = C1
        dcr_[3][0] = C2h_z_operators_; // C2_x, C1 = C2h_z
        dcr_[3][1] = Ci_operators_; // C2_x, C2_z = Ci
        dcr_[3][2] = Ci_operators_; // C2_x, C2_y = Ci
        dcr_[3][3] = C2h_z_operators_; // C2_x, C2_x = C2h_z
        dcr_[3][4] = Ci_operators_; // C2_x, D2 = Ci
        dcr_[3][5] = C2_z_operators_; // C2_x, Ci = C2_z
        dcr_[3][6] = C2_z_operators_; // C2_x, Cs_xy = C2_z
        dcr_[3][7] = C1_operators_; // C2_x, C2h_z = C1
        dcr_[3][8] = C2_z_operators_; // C2_x, Cs_xz = C2_z
        dcr_[3][9] = C1_operators_; // C2_x, C2h_y = C1
        dcr_[3][10] = C2_z_operators_; // C2_x, C2v_x = C2_z
        dcr_[3][11] = C2_z_operators_; // C2_x, Cs_yz = C2_z
        dcr_[3][12] = C2_z_operators_; // C2_x, C2h_x = C2_z
        dcr_[3][13] = C1_operators_; // C2_x, C2v_y = C1
        dcr_[3][14] = C1_operators_; // C2_x, C2v_z = C1
        dcr_[3][15] = C1_operators_; // C2_x, D2h = C1
        dcr_[4][0] = Ci_operators_; // D2, C1 = Ci
        dcr_[4][1] = Ci_operators_; // D2, C2_z = Ci
        dcr_[4][2] = Ci_operators_; // D2, C2_y = Ci
        dcr_[4][3] = Ci_operators_; // D2, C2_x = Ci
        dcr_[4][4] = Ci_operators_; // D2, D2 = Ci
        dcr_[4][5] = C1_operators_; // D2, Ci = C1
        dcr_[4][6] = C1_operators_; // D2, Cs_xy = C1
        dcr_[4][7] = C1_operators_; // D2, C2h_z = C1
        dcr_[4][8] = C1_operators_; // D2, Cs_xz = C1
        dcr_[4][9] = C1_operators_; // D2, C2h_y = C1
        dcr_[4][10] = C1_operators_; // D2, C2v_x = C1
        dcr_[4][11] = C1_operators_; // D2, Cs_yz = C1
        dcr_[4][12] = C1_operators_; // D2, C2h_x = C1
        dcr_[4][13] = C1_operators_; // D2, C2v_y = C1
        dcr_[4][14] = C1_operators_; // D2, C2v_z = C1
        dcr_[4][15] = C1_operators_; // D2, D2h = C1
        dcr_[5][0] = D2_operators_; // Ci, C1 = D2
        dcr_[5][1] = C2_y_operators_; // Ci, C2_z = C2_y
        dcr_[5][2] = C2_z_operators_; // Ci, C2_y = C2_z
        dcr_[5][3] = C2_z_operators_; // Ci, C2_x = C2_z
        dcr_[5][4] = C1_operators_; // Ci, D2 = C1
        dcr_[5][5] = D2_operators_; // Ci, Ci = D2
        dcr_[5][6] = C2_y_operators_; // Ci, Cs_xy = C2_y
        dcr_[5][7] = C2_y_operators_; // Ci, C2h_z = C2_y
        dcr_[5][8] = C2_z_operators_; // Ci, Cs_xz = C2_z
        dcr_[5][9] = C2_z_operators_; // Ci, C2h_y = C2_z
        dcr_[5][10] = C1_operators_; // Ci, C2v_x = C1
        dcr_[5][11] = C2_z_operators_; // Ci, Cs_yz = C2_z
        dcr_[5][12] = C2_z_operators_; // Ci, C2h_x = C2_z
        dcr_[5][13] = C1_operators_; // Ci, C2v_y = C1
        dcr_[5][14] = C1_operators_; // Ci, C2v_z = C1
        dcr_[5][15] = C1_operators_; // Ci, D2h = C1
        dcr_[6][0] = D2_operators_; // Cs_xy, C1 = D2
        dcr_[6][1] = C2_y_operators_; // Cs_xy, C2_z = C2_y
        dcr_[6][2] = C2_z_operators_; // Cs_xy, C2_y = C2_z
        dcr_[6][3] = C2_z_operators_; // Cs_xy, C2_x = C2_z
        dcr_[6][4] = C1_operators_; // Cs_xy, D2 = C1
        dcr_[6][5] = C2_y_operators_; // Cs_xy, Ci = C2_y
        dcr_[6][6] = D2_operators_; // Cs_xy, Cs_xy = D2
        dcr_[6][7] = C2_y_operators_; // Cs_xy, C2h_z = C2_y
        dcr_[6][8] = C2_z_operators_; // Cs_xy, Cs_xz = C2_z
        dcr_[6][9] = C1_operators_; // Cs_xy, C2h_y = C1
        dcr_[6][10] = C2_z_operators_; // Cs_xy, C2v_x = C2_z
        dcr_[6][11] = C2_z_operators_; // Cs_xy, Cs_yz = C2_z
        dcr_[6][12] = C1_operators_; // Cs_xy, C2h_x = C1
        dcr_[6][13] = C2_z_operators_; // Cs_xy, C2v_y = C2_z
        dcr_[6][14] = C1_operators_; // Cs_xy, C2v_z = C1
        dcr_[6][15] = C1_operators_; // Cs_xy, D2h = C1
        dcr_[7][0] = C2_y_operators_; // C2h_z, C1 = C2_y
        dcr_[7][1] = C2_y_operators_; // C2h_z, C2_z = C2_y
        dcr_[7][2] = C1_operators_; // C2h_z, C2_y = C1
        dcr_[7][3] = C1_operators_; // C2h_z, C2_x = C1
        dcr_[7][4] = C1_operators_; // C2h_z, D2 = C1
        dcr_[7][5] = C2_y_operators_; // C2h_z, Ci = C2_y
        dcr_[7][6] = C2_y_operators_; // C2h_z, Cs_xy = C2_y
        dcr_[7][7] = C2_y_operators_; // C2h_z, C2h_z = C2_y
        dcr_[7][8] = C1_operators_; // C2h_z, Cs_xz = C1
        dcr_[7][9] = C1_operators_; // C2h_z, C2h_y = C1
        dcr_[7][10] = C1_operators_; // C2h_z, C2v_x = C1
        dcr_[7][11] = C1_operators_; // C2h_z, Cs_yz = C1
        dcr_[7][12] = C1_operators_; // C2h_z, C2h_x = C1
        dcr_[7][13] = C1_operators_; // C2h_z, C2v_y = C1
        dcr_[7][14] = C1_operators_; // C2h_z, C2v_z = C1
        dcr_[7][15] = C1_operators_; // C2h_z, D2h = C1
        dcr_[8][0] = D2_operators_; // Cs_xz, C1 = D2
        dcr_[8][1] = C2_y_operators_; // Cs_xz, C2_z = C2_y
        dcr_[8][2] = C2_z_operators_; // Cs_xz, C2_y = C2_z
        dcr_[8][3] = C2_z_operators_; // Cs_xz, C2_x = C2_z
        dcr_[8][4] = C1_operators_; // Cs_xz, D2 = C1
        dcr_[8][5] = C2_z_operators_; // Cs_xz, Ci = C2_z
        dcr_[8][6] = C2_z_operators_; // Cs_xz, Cs_xy = C2_z
        dcr_[8][7] = C1_operators_; // Cs_xz, C2h_z = C1
        dcr_[8][8] = D2_operators_; // Cs_xz, Cs_xz = D2
        dcr_[8][9] = C2_z_operators_; // Cs_xz, C2h_y = C2_z
        dcr_[8][10] = C2_z_operators_; // Cs_xz, C2v_x = C2_z
        dcr_[8][11] = C2_y_operators_; // Cs_xz, Cs_yz = C2_y
        dcr_[8][12] = C1_operators_; // Cs_xz, C2h_x = C1
        dcr_[8][13] = C1_operators_; // Cs_xz, C2v_y = C1
        dcr_[8][14] = C2_y_operators_; // Cs_xz, C2v_z = C2_y
        dcr_[8][15] = C1_operators_; // Cs_xz, D2h = C1
        dcr_[9][0] = C2_z_operators_; // C2h_y, C1 = C2_z
        dcr_[9][1] = C1_operators_; // C2h_y, C2_z = C1
        dcr_[9][2] = C2_z_operators_; // C2h_y, C2_y = C2_z
        dcr_[9][3] = C1_operators_; // C2h_y, C2_x = C1
        dcr_[9][4] = C1_operators_; // C2h_y, D2 = C1
        dcr_[9][5] = C2_z_operators_; // C2h_y, Ci = C2_z
        dcr_[9][6] = C1_operators_; // C2h_y, Cs_xy = C1
        dcr_[9][7] = C1_operators_; // C2h_y, C2h_z = C1
        dcr_[9][8] = C2_z_operators_; // C2h_y, Cs_xz = C2_z
        dcr_[9][9] = C2_z_operators_; // C2h_y, C2h_y = C2_z
        dcr_[9][10] = C1_operators_; // C2h_y, C2v_x = C1
        dcr_[9][11] = C1_operators_; // C2h_y, Cs_yz = C1
        dcr_[9][12] = C1_operators_; // C2h_y, C2h_x = C1
        dcr_[9][13] = C1_operators_; // C2h_y, C2v_y = C1
        dcr_[9][14] = C1_operators_; // C2h_y, C2v_z = C1
        dcr_[9][15] = C1_operators_; // C2h_y, D2h = C1
        dcr_[10][0] = C2_z_operators_; // C2v_x, C1 = C2_z
        dcr_[10][1] = C1_operators_; // C2v_x, C2_z = C1
        dcr_[10][2] = C1_operators_; // C2v_x, C2_y = C1
        dcr_[10][3] = C2_z_operators_; // C2v_x, C2_x = C2_z
        dcr_[10][4] = C1_operators_; // C2v_x, D2 = C1
        dcr_[10][5] = C1_operators_; // C2v_x, Ci = C1
        dcr_[10][6] = C2_z_operators_; // C2v_x, Cs_xy = C2_z
        dcr_[10][7] = C1_operators_; // C2v_x, C2h_z = C1
        dcr_[10][8] = C2_z_operators_; // C2v_x, Cs_xz = C2_z
        dcr_[10][9] = C1_operators_; // C2v_x, C2h_y = C1
        dcr_[10][10] = C2_z_operators_; // C2v_x, C2v_x = C2_z
        dcr_[10][11] = C1_operators_; // C2v_x, Cs_yz = C1
        dcr_[10][12] = C1_operators_; // C2v_x, C2h_x = C1
        dcr_[10][13] = C1_operators_; // C2v_x, C2v_y = C1
        dcr_[10][14] = C1_operators_; // C2v_x, C2v_z = C1
        dcr_[10][15] = C1_operators_; // C2v_x, D2h = C1
        dcr_[11][0] = D2_operators_; // Cs_yz, C1 = D2
        dcr_[11][1] = C2_y_operators_; // Cs_yz, C2_z = C2_y
        dcr_[11][2] = C2_z_operators_; // Cs_yz, C2_y = C2_z
        dcr_[11][3] = C2_z_operators_; // Cs_yz, C2_x = C2_z
        dcr_[11][4] = C1_operators_; // Cs_yz, D2 = C1
        dcr_[11][5] = C2_z_operators_; // Cs_yz, Ci = C2_z
        dcr_[11][6] = C2_z_operators_; // Cs_yz, Cs_xy = C2_z
        dcr_[11][7] = C1_operators_; // Cs_yz, C2h_z = C1
        dcr_[11][8] = C2_y_operators_; // Cs_yz, Cs_xz = C2_y
        dcr_[11][9] = C1_operators_; // Cs_yz, C2h_y = C1
        dcr_[11][10] = C1_operators_; // Cs_yz, C2v_x = C1
        dcr_[11][11] = D2_operators_; // Cs_yz, Cs_yz = D2
        dcr_[11][12] = C2_z_operators_; // Cs_yz, C2h_x = C2_z
        dcr_[11][13] = C2_z_operators_; // Cs_yz, C2v_y = C2_z
        dcr_[11][14] = C2_y_operators_; // Cs_yz, C2v_z = C2_y
        dcr_[11][15] = C1_operators_; // Cs_yz, D2h = C1
        dcr_[12][0] = C2_z_operators_; // C2h_x, C1 = C2_z
        dcr_[12][1] = C1_operators_; // C2h_x, C2_z = C1
        dcr_[12][2] = C1_operators_; // C2h_x, C2_y = C1
        dcr_[12][3] = C2_z_operators_; // C2h_x, C2_x = C2_z
        dcr_[12][4] = C1_operators_; // C2h_x, D2 = C1
        dcr_[12][5] = C2_z_operators_; // C2h_x, Ci = C2_z
        dcr_[12][6] = C1_operators_; // C2h_x, Cs_xy = C1
        dcr_[12][7] = C1_operators_; // C2h_x, C2h_z = C1
        dcr_[12][8] = C1_operators_; // C2h_x, Cs_xz = C1
        dcr_[12][9] = C1_operators_; // C2h_x, C2h_y = C1
        dcr_[12][10] = C1_operators_; // C2h_x, C2v_x = C1
        dcr_[12][11] = C2_z_operators_; // C2h_x, Cs_yz = C2_z
        dcr_[12][12] = C2_z_operators_; // C2h_x, C2h_x = C2_z
        dcr_[12][13] = C1_operators_; // C2h_x, C2v_y = C1
        dcr_[12][14] = C1_operators_; // C2h_x, C2v_z = C1
        dcr_[12][15] = C1_operators_; // C2h_x, D2h = C1
        dcr_[13][0] = C2_z_operators_; // C2v_y, C1 = C2_z
        dcr_[13][1] = C1_operators_; // C2v_y, C2_z = C1
        dcr_[13][2] = C2_z_operators_; // C2v_y, C2_y = C2_z
        dcr_[13][3] = C1_operators_; // C2v_y, C2_x = C1
        dcr_[13][4] = C1_operators_; // C2v_y, D2 = C1
        dcr_[13][5] = C1_operators_; // C2v_y, Ci = C1
        dcr_[13][6] = C2_z_operators_; // C2v_y, Cs_xy = C2_z
        dcr_[13][7] = C1_operators_; // C2v_y, C2h_z = C1
        dcr_[13][8] = C1_operators_; // C2v_y, Cs_xz = C1
        dcr_[13][9] = C1_operators_; // C2v_y, C2h_y = C1
        dcr_[13][10] = C1_operators_; // C2v_y, C2v_x = C1
        dcr_[13][11] = C2_z_operators_; // C2v_y, Cs_yz = C2_z
        dcr_[13][12] = C1_operators_; // C2v_y, C2h_x = C1
        dcr_[13][13] = C2_z_operators_; // C2v_y, C2v_y = C2_z
        dcr_[13][14] = C1_operators_; // C2v_y, C2v_z = C1
        dcr_[13][15] = C1_operators_; // C2v_y, D2h = C1
        dcr_[14][0] = C2_y_operators_; // C2v_z, C1 = C2_y
        dcr_[14][1] = C2_y_operators_; // C2v_z, C2_z = C2_y
        dcr_[14][2] = C1_operators_; // C2v_z, C2_y = C1
        dcr_[14][3] = C1_operators_; // C2v_z, C2_x = C1
        dcr_[14][4] = C1_operators_; // C2v_z, D2 = C1
        dcr_[14][5] = C1_operators_; // C2v_z, Ci = C1
        dcr_[14][6] = C1_operators_; // C2v_z, Cs_xy = C1
        dcr_[14][7] = C1_operators_; // C2v_z, C2h_z = C1
        dcr_[14][8] = C2_y_operators_; // C2v_z, Cs_xz = C2_y
        dcr_[14][9] = C1_operators_; // C2v_z, C2h_y = C1
        dcr_[14][10] = C1_operators_; // C2v_z, C2v_x = C1
        dcr_[14][11] = C2_y_operators_; // C2v_z, Cs_yz = C2_y
        dcr_[14][12] = C1_operators_; // C2v_z, C2h_x = C1
        dcr_[14][13] = C1_operators_; // C2v_z, C2v_y = C1
        dcr_[14][14] = C2_y_operators_; // C2v_z, C2v_z = C2_y
        dcr_[14][15] = C1_operators_; // C2v_z, D2h = C1
        dcr_[15][0] = C1_operators_; // D2h, C1 = C1
        dcr_[15][1] = C1_operators_; // D2h, C2_z = C1
        dcr_[15][2] = C1_operators_; // D2h, C2_y = C1
        dcr_[15][3] = C1_operators_; // D2h, C2_x = C1
        dcr_[15][4] = C1_operators_; // D2h, D2 = C1
        dcr_[15][5] = C1_operators_; // D2h, Ci = C1
        dcr_[15][6] = C1_operators_; // D2h, Cs_xy = C1
        dcr_[15][7] = C1_operators_; // D2h, C2h_z = C1
        dcr_[15][8] = C1_operators_; // D2h, Cs_xz = C1
        dcr_[15][9] = C1_operators_; // D2h, C2h_y = C1
        dcr_[15][10] = C1_operators_; // D2h, C2v_x = C1
        dcr_[15][11] = C1_operators_; // D2h, Cs_yz = C1
        dcr_[15][12] = C1_operators_; // D2h, C2h_x = C1
        dcr_[15][13] = C1_operators_; // D2h, C2v_y = C1
        dcr_[15][14] = C1_operators_; // D2h, C2v_z = C1
        dcr_[15][15] = C1_operators_; // D2h, D2h = C1

        gng_ = new int*[nsub_]; for(int n = 0; n < nsub_; ++n) gng_[n] = new int[nsub_];
        gng_[0][0] = 0; // C1, C1 = C1
        gng_[0][1] = 0; // C1, C2_z = C1
        gng_[0][2] = 0; // C1, C2_y = C1
        gng_[0][3] = 0; // C1, C2_x = C1
        gng_[0][4] = 0; // C1, D2 = C1
        gng_[0][5] = 0; // C1, Ci = C1
        gng_[0][6] = 0; // C1, Cs_xy = C1
        gng_[0][7] = 0; // C1, C2h_z = C1
        gng_[0][8] = 0; // C1, Cs_xz = C1
        gng_[0][9] = 0; // C1, C2h_y = C1
        gng_[0][10] = 0; // C1, C2v_x = C1
        gng_[0][11] = 0; // C1, Cs_yz = C1
        gng_[0][12] = 0; // C1, C2h_x = C1
        gng_[0][13] = 0; // C1, C2v_y = C1
        gng_[0][14] = 0; // C1, C2v_z = C1
        gng_[0][15] = 0; // C1, D2h = C1
        gng_[1][0] = 0; // C2_z, C1 = C1
        gng_[1][1] = 1; // C2_z, C2_z = C2_z
        gng_[1][2] = 0; // C2_z, C2_y = C1
        gng_[1][3] = 0; // C2_z, C2_x = C1
        gng_[1][4] = 1; // C2_z, D2 = C2_z
        gng_[1][5] = 0; // C2_z, Ci = C1
        gng_[1][6] = 0; // C2_z, Cs_xy = C1
        gng_[1][7] = 1; // C2_z, C2h_z = C2_z
        gng_[1][8] = 0; // C2_z, Cs_xz = C1
        gng_[1][9] = 0; // C2_z, C2h_y = C1
        gng_[1][10] = 0; // C2_z, C2v_x = C1
        gng_[1][11] = 0; // C2_z, Cs_yz = C1
        gng_[1][12] = 0; // C2_z, C2h_x = C1
        gng_[1][13] = 0; // C2_z, C2v_y = C1
        gng_[1][14] = 1; // C2_z, C2v_z = C2_z
        gng_[1][15] = 1; // C2_z, D2h = C2_z
        gng_[2][0] = 0; // C2_y, C1 = C1
        gng_[2][1] = 0; // C2_y, C2_z = C1
        gng_[2][2] = 2; // C2_y, C2_y = C2_y
        gng_[2][3] = 0; // C2_y, C2_x = C1
        gng_[2][4] = 2; // C2_y, D2 = C2_y
        gng_[2][5] = 0; // C2_y, Ci = C1
        gng_[2][6] = 0; // C2_y, Cs_xy = C1
        gng_[2][7] = 0; // C2_y, C2h_z = C1
        gng_[2][8] = 0; // C2_y, Cs_xz = C1
        gng_[2][9] = 2; // C2_y, C2h_y = C2_y
        gng_[2][10] = 0; // C2_y, C2v_x = C1
        gng_[2][11] = 0; // C2_y, Cs_yz = C1
        gng_[2][12] = 0; // C2_y, C2h_x = C1
        gng_[2][13] = 2; // C2_y, C2v_y = C2_y
        gng_[2][14] = 0; // C2_y, C2v_z = C1
        gng_[2][15] = 2; // C2_y, D2h = C2_y
        gng_[3][0] = 0; // C2_x, C1 = C1
        gng_[3][1] = 0; // C2_x, C2_z = C1
        gng_[3][2] = 0; // C2_x, C2_y = C1
        gng_[3][3] = 3; // C2_x, C2_x = C2_x
        gng_[3][4] = 3; // C2_x, D2 = C2_x
        gng_[3][5] = 0; // C2_x, Ci = C1
        gng_[3][6] = 0; // C2_x, Cs_xy = C1
        gng_[3][7] = 0; // C2_x, C2h_z = C1
        gng_[3][8] = 0; // C2_x, Cs_xz = C1
        gng_[3][9] = 0; // C2_x, C2h_y = C1
        gng_[3][10] = 3; // C2_x, C2v_x = C2_x
        gng_[3][11] = 0; // C2_x, Cs_yz = C1
        gng_[3][12] = 3; // C2_x, C2h_x = C2_x
        gng_[3][13] = 0; // C2_x, C2v_y = C1
        gng_[3][14] = 0; // C2_x, C2v_z = C1
        gng_[3][15] = 3; // C2_x, D2h = C2_x
        gng_[4][0] = 0; // D2, C1 = C1
        gng_[4][1] = 1; // D2, C2_z = C2_z
        gng_[4][2] = 2; // D2, C2_y = C2_y
        gng_[4][3] = 3; // D2, C2_x = C2_x
        gng_[4][4] = 4; // D2, D2 = D2
        gng_[4][5] = 0; // D2, Ci = C1
        gng_[4][6] = 0; // D2, Cs_xy = C1
        gng_[4][7] = 1; // D2, C2h_z = C2_z
        gng_[4][8] = 0; // D2, Cs_xz = C1
        gng_[4][9] = 2; // D2, C2h_y = C2_y
        gng_[4][10] = 3; // D2, C2v_x = C2_x
        gng_[4][11] = 0; // D2, Cs_yz = C1
        gng_[4][12] = 3; // D2, C2h_x = C2_x
        gng_[4][13] = 2; // D2, C2v_y = C2_y
        gng_[4][14] = 1; // D2, C2v_z = C2_z
        gng_[4][15] = 4; // D2, D2h = D2
        gng_[5][0] = 0; // Ci, C1 = C1
        gng_[5][1] = 0; // Ci, C2_z = C1
        gng_[5][2] = 0; // Ci, C2_y = C1
        gng_[5][3] = 0; // Ci, C2_x = C1
        gng_[5][4] = 0; // Ci, D2 = C1
        gng_[5][5] = 5; // Ci, Ci = Ci
        gng_[5][6] = 0; // Ci, Cs_xy = C1
        gng_[5][7] = 5; // Ci, C2h_z = Ci
        gng_[5][8] = 0; // Ci, Cs_xz = C1
        gng_[5][9] = 5; // Ci, C2h_y = Ci
        gng_[5][10] = 0; // Ci, C2v_x = C1
        gng_[5][11] = 0; // Ci, Cs_yz = C1
        gng_[5][12] = 5; // Ci, C2h_x = Ci
        gng_[5][13] = 0; // Ci, C2v_y = C1
        gng_[5][14] = 0; // Ci, C2v_z = C1
        gng_[5][15] = 5; // Ci, D2h = Ci
        gng_[6][0] = 0; // Cs_xy, C1 = C1
        gng_[6][1] = 0; // Cs_xy, C2_z = C1
        gng_[6][2] = 0; // Cs_xy, C2_y = C1
        gng_[6][3] = 0; // Cs_xy, C2_x = C1
        gng_[6][4] = 0; // Cs_xy, D2 = C1
        gng_[6][5] = 0; // Cs_xy, Ci = C1
        gng_[6][6] = 6; // Cs_xy, Cs_xy = Cs_xy
        gng_[6][7] = 6; // Cs_xy, C2h_z = Cs_xy
        gng_[6][8] = 0; // Cs_xy, Cs_xz = C1
        gng_[6][9] = 0; // Cs_xy, C2h_y = C1
        gng_[6][10] = 6; // Cs_xy, C2v_x = Cs_xy
        gng_[6][11] = 0; // Cs_xy, Cs_yz = C1
        gng_[6][12] = 0; // Cs_xy, C2h_x = C1
        gng_[6][13] = 6; // Cs_xy, C2v_y = Cs_xy
        gng_[6][14] = 0; // Cs_xy, C2v_z = C1
        gng_[6][15] = 6; // Cs_xy, D2h = Cs_xy
        gng_[7][0] = 0; // C2h_z, C1 = C1
        gng_[7][1] = 1; // C2h_z, C2_z = C2_z
        gng_[7][2] = 0; // C2h_z, C2_y = C1
        gng_[7][3] = 0; // C2h_z, C2_x = C1
        gng_[7][4] = 1; // C2h_z, D2 = C2_z
        gng_[7][5] = 5; // C2h_z, Ci = Ci
        gng_[7][6] = 6; // C2h_z, Cs_xy = Cs_xy
        gng_[7][7] = 7; // C2h_z, C2h_z = C2h_z
        gng_[7][8] = 0; // C2h_z, Cs_xz = C1
        gng_[7][9] = 5; // C2h_z, C2h_y = Ci
        gng_[7][10] = 6; // C2h_z, C2v_x = Cs_xy
        gng_[7][11] = 0; // C2h_z, Cs_yz = C1
        gng_[7][12] = 5; // C2h_z, C2h_x = Ci
        gng_[7][13] = 6; // C2h_z, C2v_y = Cs_xy
        gng_[7][14] = 1; // C2h_z, C2v_z = C2_z
        gng_[7][15] = 7; // C2h_z, D2h = C2h_z
        gng_[8][0] = 0; // Cs_xz, C1 = C1
        gng_[8][1] = 0; // Cs_xz, C2_z = C1
        gng_[8][2] = 0; // Cs_xz, C2_y = C1
        gng_[8][3] = 0; // Cs_xz, C2_x = C1
        gng_[8][4] = 0; // Cs_xz, D2 = C1
        gng_[8][5] = 0; // Cs_xz, Ci = C1
        gng_[8][6] = 0; // Cs_xz, Cs_xy = C1
        gng_[8][7] = 0; // Cs_xz, C2h_z = C1
        gng_[8][8] = 8; // Cs_xz, Cs_xz = Cs_xz
        gng_[8][9] = 8; // Cs_xz, C2h_y = Cs_xz
        gng_[8][10] = 8; // Cs_xz, C2v_x = Cs_xz
        gng_[8][11] = 0; // Cs_xz, Cs_yz = C1
        gng_[8][12] = 0; // Cs_xz, C2h_x = C1
        gng_[8][13] = 0; // Cs_xz, C2v_y = C1
        gng_[8][14] = 8; // Cs_xz, C2v_z = Cs_xz
        gng_[8][15] = 8; // Cs_xz, D2h = Cs_xz
        gng_[9][0] = 0; // C2h_y, C1 = C1
        gng_[9][1] = 0; // C2h_y, C2_z = C1
        gng_[9][2] = 2; // C2h_y, C2_y = C2_y
        gng_[9][3] = 0; // C2h_y, C2_x = C1
        gng_[9][4] = 2; // C2h_y, D2 = C2_y
        gng_[9][5] = 5; // C2h_y, Ci = Ci
        gng_[9][6] = 0; // C2h_y, Cs_xy = C1
        gng_[9][7] = 5; // C2h_y, C2h_z = Ci
        gng_[9][8] = 8; // C2h_y, Cs_xz = Cs_xz
        gng_[9][9] = 9; // C2h_y, C2h_y = C2h_y
        gng_[9][10] = 8; // C2h_y, C2v_x = Cs_xz
        gng_[9][11] = 0; // C2h_y, Cs_yz = C1
        gng_[9][12] = 5; // C2h_y, C2h_x = Ci
        gng_[9][13] = 2; // C2h_y, C2v_y = C2_y
        gng_[9][14] = 8; // C2h_y, C2v_z = Cs_xz
        gng_[9][15] = 9; // C2h_y, D2h = C2h_y
        gng_[10][0] = 0; // C2v_x, C1 = C1
        gng_[10][1] = 0; // C2v_x, C2_z = C1
        gng_[10][2] = 0; // C2v_x, C2_y = C1
        gng_[10][3] = 3; // C2v_x, C2_x = C2_x
        gng_[10][4] = 3; // C2v_x, D2 = C2_x
        gng_[10][5] = 0; // C2v_x, Ci = C1
        gng_[10][6] = 6; // C2v_x, Cs_xy = Cs_xy
        gng_[10][7] = 6; // C2v_x, C2h_z = Cs_xy
        gng_[10][8] = 8; // C2v_x, Cs_xz = Cs_xz
        gng_[10][9] = 8; // C2v_x, C2h_y = Cs_xz
        gng_[10][10] = 10; // C2v_x, C2v_x = C2v_x
        gng_[10][11] = 0; // C2v_x, Cs_yz = C1
        gng_[10][12] = 3; // C2v_x, C2h_x = C2_x
        gng_[10][13] = 6; // C2v_x, C2v_y = Cs_xy
        gng_[10][14] = 8; // C2v_x, C2v_z = Cs_xz
        gng_[10][15] = 10; // C2v_x, D2h = C2v_x
        gng_[11][0] = 0; // Cs_yz, C1 = C1
        gng_[11][1] = 0; // Cs_yz, C2_z = C1
        gng_[11][2] = 0; // Cs_yz, C2_y = C1
        gng_[11][3] = 0; // Cs_yz, C2_x = C1
        gng_[11][4] = 0; // Cs_yz, D2 = C1
        gng_[11][5] = 0; // Cs_yz, Ci = C1
        gng_[11][6] = 0; // Cs_yz, Cs_xy = C1
        gng_[11][7] = 0; // Cs_yz, C2h_z = C1
        gng_[11][8] = 0; // Cs_yz, Cs_xz = C1
        gng_[11][9] = 0; // Cs_yz, C2h_y = C1
        gng_[11][10] = 0; // Cs_yz, C2v_x = C1
        gng_[11][11] = 11; // Cs_yz, Cs_yz = Cs_yz
        gng_[11][12] = 11; // Cs_yz, C2h_x = Cs_yz
        gng_[11][13] = 11; // Cs_yz, C2v_y = Cs_yz
        gng_[11][14] = 11; // Cs_yz, C2v_z = Cs_yz
        gng_[11][15] = 11; // Cs_yz, D2h = Cs_yz
        gng_[12][0] = 0; // C2h_x, C1 = C1
        gng_[12][1] = 0; // C2h_x, C2_z = C1
        gng_[12][2] = 0; // C2h_x, C2_y = C1
        gng_[12][3] = 3; // C2h_x, C2_x = C2_x
        gng_[12][4] = 3; // C2h_x, D2 = C2_x
        gng_[12][5] = 5; // C2h_x, Ci = Ci
        gng_[12][6] = 0; // C2h_x, Cs_xy = C1
        gng_[12][7] = 5; // C2h_x, C2h_z = Ci
        gng_[12][8] = 0; // C2h_x, Cs_xz = C1
        gng_[12][9] = 5; // C2h_x, C2h_y = Ci
        gng_[12][10] = 3; // C2h_x, C2v_x = C2_x
        gng_[12][11] = 11; // C2h_x, Cs_yz = Cs_yz
        gng_[12][12] = 12; // C2h_x, C2h_x = C2h_x
        gng_[12][13] = 11; // C2h_x, C2v_y = Cs_yz
        gng_[12][14] = 11; // C2h_x, C2v_z = Cs_yz
        gng_[12][15] = 12; // C2h_x, D2h = C2h_x
        gng_[13][0] = 0; // C2v_y, C1 = C1
        gng_[13][1] = 0; // C2v_y, C2_z = C1
        gng_[13][2] = 2; // C2v_y, C2_y = C2_y
        gng_[13][3] = 0; // C2v_y, C2_x = C1
        gng_[13][4] = 2; // C2v_y, D2 = C2_y
        gng_[13][5] = 0; // C2v_y, Ci = C1
        gng_[13][6] = 6; // C2v_y, Cs_xy = Cs_xy
        gng_[13][7] = 6; // C2v_y, C2h_z = Cs_xy
        gng_[13][8] = 0; // C2v_y, Cs_xz = C1
        gng_[13][9] = 2; // C2v_y, C2h_y = C2_y
        gng_[13][10] = 6; // C2v_y, C2v_x = Cs_xy
        gng_[13][11] = 11; // C2v_y, Cs_yz = Cs_yz
        gng_[13][12] = 11; // C2v_y, C2h_x = Cs_yz
        gng_[13][13] = 13; // C2v_y, C2v_y = C2v_y
        gng_[13][14] = 11; // C2v_y, C2v_z = Cs_yz
        gng_[13][15] = 13; // C2v_y, D2h = C2v_y
        gng_[14][0] = 0; // C2v_z, C1 = C1
        gng_[14][1] = 1; // C2v_z, C2_z = C2_z
        gng_[14][2] = 0; // C2v_z, C2_y = C1
        gng_[14][3] = 0; // C2v_z, C2_x = C1
        gng_[14][4] = 1; // C2v_z, D2 = C2_z
        gng_[14][5] = 0; // C2v_z, Ci = C1
        gng_[14][6] = 0; // C2v_z, Cs_xy = C1
        gng_[14][7] = 1; // C2v_z, C2h_z = C2_z
        gng_[14][8] = 8; // C2v_z, Cs_xz = Cs_xz
        gng_[14][9] = 8; // C2v_z, C2h_y = Cs_xz
        gng_[14][10] = 8; // C2v_z, C2v_x = Cs_xz
        gng_[14][11] = 11; // C2v_z, Cs_yz = Cs_yz
        gng_[14][12] = 11; // C2v_z, C2h_x = Cs_yz
        gng_[14][13] = 11; // C2v_z, C2v_y = Cs_yz
        gng_[14][14] = 14; // C2v_z, C2v_z = C2v_z
        gng_[14][15] = 14; // C2v_z, D2h = C2v_z
        gng_[15][0] = 0; // D2h, C1 = C1
        gng_[15][1] = 1; // D2h, C2_z = C2_z
        gng_[15][2] = 2; // D2h, C2_y = C2_y
        gng_[15][3] = 3; // D2h, C2_x = C2_x
        gng_[15][4] = 4; // D2h, D2 = D2
        gng_[15][5] = 5; // D2h, Ci = Ci
        gng_[15][6] = 6; // D2h, Cs_xy = Cs_xy
        gng_[15][7] = 7; // D2h, C2h_z = C2h_z
        gng_[15][8] = 8; // D2h, Cs_xz = Cs_xz
        gng_[15][9] = 9; // D2h, C2h_y = C2h_y
        gng_[15][10] = 10; // D2h, C2v_x = C2v_x
        gng_[15][11] = 11; // D2h, Cs_yz = Cs_yz
        gng_[15][12] = 12; // D2h, C2h_x = C2h_x
        gng_[15][13] = 13; // D2h, C2v_y = C2v_y
        gng_[15][14] = 14; // D2h, C2v_z = C2v_z
        gng_[15][15] = 15; // D2h, D2h = D2h
    }
  }

  ~DCD()
  {
      if(C1_operators_ != 0) delete [] C1_operators_;
      if(C2_z_operators_ != 0) delete [] C2_z_operators_;
      if(C2_y_operators_ != 0) delete [] C2_y_operators_;
      if(C2_x_operators_ != 0) delete [] C2_x_operators_;
      if(D2_operators_ != 0) delete [] D2_operators_;
      if(Ci_operators_ != 0) delete [] Ci_operators_;
      if(Cs_xy_operators_ != 0) delete [] Cs_xy_operators_;
      if(C2h_z_operators_ != 0) delete [] C2h_z_operators_;
      if(Cs_xz_operators_ != 0) delete [] Cs_xz_operators_;
      if(C2h_y_operators_ != 0) delete [] C2h_y_operators_;
      if(C2v_x_operators_ != 0) delete [] C2v_x_operators_;
      if(Cs_yz_operators_ != 0) delete [] Cs_yz_operators_;
      if(C2h_x_operators_ != 0) delete [] C2h_x_operators_;
      if(C2v_y_operators_ != 0) delete [] C2v_y_operators_;
      if(C2v_z_operators_ != 0) delete [] C2v_z_operators_;
      if(D2h_operators_ != 0) delete [] D2h_operators_;

      for(int n = 0; n < nsub_; ++n) delete [] gng_[n];
      delete [] gng_;

      for(int n = 0; n < nsub_; ++n) delete [] dcr_[n];
      delete [] dcr_;
      delete [] subgroup_dimensions_;
  }

  /// Takes a densely numbered subgroup and returns its dimension
  int subgroup_dimensions(int group) { return subgroup_dimensions_[group]; }

  /// Takes a point group expressed as a bitset for each operator, and returns the corresponding dense
  /// numbering representation for this point group.
  int bits_to_dense_numbering(int group) { return bits_to_subgroup_[group]; }

  /// Returns the intersection (in dense subgroup numbering) of the two subgroups, group1 and group2,
  /// which are also in the dense ordering scheme.
  int intersection(int group1, int group2) const { return gng_[group1][group2]; }

  /// Returns the list of operators (numbered appropriately for the current point group) for the pair of stabilizer subgroups
  /// group1 and group2, which are densely numbered.  The first element is the size of the list, so iterate as follows:
  /// int* dcr = dcr(g1, g2);  int size = dcr[0];  for(int i = 1; i <= size; ++i) do something with dcr[i]...
  const int* dcr(int group1, int group2) const { return dcr_[group1][group2]; }

};