#!/usr/bin/perl

use strict;
use warnings;
use File::Path qw(remove_tree);
use File::Slurp;

my $DriverPath = "";
if ($#ARGV == 0) { $DriverPath = $ARGV[0] . "/"; }

#
# First, grab the license
#

my $LicenseFile = $DriverPath . "../../lib/python/source.template";
my $license = read_file($LicenseFile);

#
# Now, grab the physical constants
#
my $PhysconstFile = $DriverPath . "../../include/physconst.h";
my $PyPhysconstFile = $DriverPath . "../../lib/python/p4const/physconst.py";
open(PHYSCONST, "<$PhysconstFile") or die "I can't open $PhysconstFile\n";
open(TEXOUT, ">physconst.tex") or die "I can't write to physconst.tex\n";
open(PYOUT, ">$PyPhysconstFile") or die "I can't write to $PyPhysconstFile\n";
print PYOUT "$license";
print PYOUT "# Do not modify this file! It is auto-generated by the document_options_and_tests\n".
            "# script, from psi4topdir/include/physconst.h\n";
while(<PHYSCONST>){
    next unless /\s*#define\s+pc(\w+)\s+([-Ee0-9.]+)\s+\/\*-(.*)-\*\//;
    my $Var     = $1;
    my $Val     = $2;
    my $Comment = $3;
    printf PYOUT "psi%-25s = %-20s #%-40s\n", $Var, $Val, $Comment;
    $Var =~ s/_/\\_/g; # Make things TeX-friendly
    $Comment =~ s/_/\\_/g; # Make things TeX-friendly
    $Comment =~ s/@@/_/g;  # process @@ as math mode subscript in tex
    printf TEXOUT "psi%-25s & %-20s & %-40s\\\\\n", $Var, $Val, $Comment;
}
print "Auto-documenting constants file physconst.h\n";
close PHYSCONST;
close PYOUT;
close TEXOUT;

