# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class RoleAssignmentApprovalActorIdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The identity type : user/servicePrincipal
    """

    USER = "user"
    SERVICE_PRINCIPAL = "servicePrincipal"

class RoleAssignmentApprovalStepReviewResult(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The decision on the approval stage. This value is initially set to NotReviewed. Approvers can
    take action of Approve/Deny
    """

    APPROVE = "Approve"
    DENY = "Deny"
    NOT_REVIEWED = "NotReviewed"

class RoleAssignmentApprovalStepStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """This read-only field specifies the status of an approval.
    """

    NOT_STARTED = "NotStarted"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    EXPIRED = "Expired"
    INITIALIZING = "Initializing"
    ESCALATING = "Escalating"
    COMPLETING = "Completing"
    ESCALATED = "Escalated"
