/***************************************************************************
 *   Copyright (C) 2004 by Johan Maes                                      *
 *   on4qz@telenet.be                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ftp.h"
#include "qsstvglobal.h"
//#include <qmessagebox.h>
#include <qfiledialog.h>

#include <qapplication.h>
#include "configparams.h"
#include <QDebug>
#include "dispatcher.h"
#define FTPTIMEOUTTIME 12000

ftpInterface::ftpInterface(QString id)
{
  ftp=NULL;
  name=id;
  sourceFn=NULL;
  init();

}

ftpInterface::~ftpInterface()
{
  addToLog("FTP destroy in delete",LOGFTP);
  destroy();
  if(ftp) delete ftp;

}

void ftpInterface::init()
{
  if(ftp)
    {
      destroy();
      delete ftp;
    }
  ftp = new QFtp( 0);
  connect( ftp, SIGNAL(commandStarted(int)),SLOT(ftp_commandStarted(int)) );
  connect( ftp, SIGNAL(commandFinished(int,bool)),SLOT(ftp_commandFinished(int,bool)) );
  connect( ftp, SIGNAL(done(bool)),SLOT(ftp_done(bool)) );
  connect( ftp, SIGNAL(stateChanged(int)),SLOT(ftp_stateChanged(int)) );
  connect( ftp, SIGNAL(listInfo(const QUrlInfo &)),SLOT(ftp_listInfo(const QUrlInfo &)) );
  connect( ftp, SIGNAL(rawCommandReply(int, const QString &)),SLOT(ftp_rawCommandReply(int, const QString &)) );
  connect( ftp, SIGNAL(dataTransferProgress(qint64,qint64)),SLOT(slotProgress(qint64,qint64)) );
  //    connect( progress, SIGNAL(canceled()), SLOT(slotAbort()) );
}

void ftpInterface::destroy()
{
  addToLog("FTP show state in destroy",LOGFTP);
  ftp_stateChanged(ftp->state());
  if ( ftp->state() != QFtp::Unconnected )
    {

      addToLog("FTP destroy",LOGFTP);
      ftp->close();
    }
}

eftpError ftpInterface::doConnect()
{
  ftpDone=true;
  aborting=false;
  addToLog(QString("FTP doConnect"),LOGFTP);
  dumpState();
  if(isUnconnected())
    {
      addToLog(QString("FTP connect to host %1").arg(host),LOGFTP);
      ftpDone=false;
      connectToHost();
    }
  else
    {
      addToLog(QString("FTP already connected to host %1").arg(host),LOGFTP);
    }
  tim.setSingleShot(true);
  tim.start(FTPTIMEOUTTIME);
  while(!ftpDone)
    {
      if(aborting)
        {

          return FTPCANCELED;
        }
      qApp->processEvents();
      if(!tim.isActive())
        {
          slotAbort();
          addToLog("ftp Timeout",LOGALL);
          return FTPTIMEOUT;
        }
    }
  tim.stop();
  if(!ftpCommandSuccess)
    {
      addToLog("FTP not connected",LOGFTP);
      return FTPERROR;
    }
  addToLog(QString("FTP connected to %1").arg(host),LOGFTP);
  return FTPOK;
}


eftpError ftpInterface::uploadFile(QString fileName,QString targetFilename,bool reconnect)
{
  int id;
  eftpError result;
  addToLog("FTP uploadFile",LOGFTP);
  if ( fileName.isNull() )  return FTPNAMEERROR;
  if(reconnect)
    {
      result=doConnect();
      if(result!=FTPOK) return result;
    }
  sourceFn=new QFile(fileName);
  if ( !sourceFn->open( QIODevice::ReadOnly ) )
    {
      //		   QMessageBox::critical( 0, tr("Upload error"),
      //                tr("Can't open file '%1' for reading.").arg(fileName) );
      sourceFn=NULL;
      return FTPNAMEERROR;
    }
  QFileInfo fi( fileName );
  QFileInfo fin(targetFilename);
  addToLog(QString("FTP bytes: %1").arg(sourceFn->size()),LOGFTP);

  ftpDone=false;
  if(fin.fileName().isEmpty())
    {
      id=ftp->put( sourceFn, fi.fileName(),QFtp::Binary);
    }
  else
    {
      id=ftp->put( sourceFn, fin.fileName(),QFtp::Binary);
    }
  addToLog(QString("FTP put file id: %1").arg(id),LOGFTP);
  while(!ftpDone)
    {
      if(aborting) return FTPCANCELED;
      qApp->processEvents();
    }
  if(!ftpCommandSuccess) return FTPERROR;
  addToLog("FTP starting progress",LOGFTP);
  return FTPOK;
}


eftpError ftpInterface::downloadFile(QString sourceFileName,QString destinationFilename)
{
  eftpError result;
  addToLog("FTP downloadFile",LOGFTP);
  QFile *destFn;
  destFn=new QFile(destinationFilename);
  if(!destFn->open(QIODevice::WriteOnly))
    {
      addToLog(QString("FTP unable to open destinationFilename %1").arg(destinationFilename),LOGFTP);
      return FTPNAMEERROR;
    }


  if (sourceFileName.isNull() )  return FTPNAMEERROR;
  result=doConnect();
  if(result!=FTPOK) return result;
  ftpDone=false;
  ftp->get( sourceFileName, destFn,QFtp::Binary);
  addToLog(QString("FTP get sourcefile %1 destination %2").arg(sourceFileName).arg(destFn->fileName()),LOGFTP);
  while(!ftpDone)
    {
      if(aborting) return FTPCANCELED;
      qApp->processEvents();
    }
  if(!ftpCommandSuccess) return FTPERROR;
  addToLog(QString("FTP file: %1 bytes: %2").arg(destinationFilename).arg(QFile(destinationFilename).size()),LOGFTP);
  return FTPOK;
}


void ftpInterface::connectToHost()
{
  destroy();
  ftp->connectToHost(host,port);
  ftp->login( user, passwd );
  if(!directory.isEmpty()) changePath(directory);
  //    qDebug() << QString("connecting to host %1,%2,%3,%4").arg(host).arg(port).arg(user).arg(passwd);
}

// This slot is connected to the QComboBox::activated() signal of the
// remotePath.
void ftpInterface::changePath( const QString &newPath )
{
  ftp->cd( newPath );
}


/****************************************************************************
**
** Slots connected to signals of the QFtp class
**
*****************************************************************************/

void ftpInterface::ftp_commandStarted(int id)
{
  addToLog(QString("FTP commandStarted id:%1, %2").arg(id).arg(ftp->currentCommand()),LOGFTP);
  if ( ftp->currentCommand() == QFtp::List )
    {
    }
}

void ftpInterface::ftp_commandFinished(int id,bool err)
{
  QIODevice *p;

  slotProgress(0,0);

  addToLog(QString("FTP commandFinished id:%1, error:%2").arg(id).arg(err),LOGFTP);
  if(err)
    {
      addToLog(QString("FTP error:%1").arg(ftp->errorString()),LOGFTP);
      ftpCommandSuccess=false;
    }
  else
    {
      ftpCommandSuccess=true;
    }


  p=ftp->currentDevice();
  if(p)
    {
      delete ftp->currentDevice();
    }

}

void ftpInterface::ftp_done( bool error )
{

  if ( error )
    {

      //        QMessageBox::critical( 0, tr("FTP Error"), ftp->errorString() );

      // If we are connected, but not logged in, it is not meaningful to stay
      // connected to the server since the error is a really fatal one (login
      // failed).
      if(!isLoggedIn())
        {
          addToLog("FTP done:  error and not logged in-> disconnecting",LOGFTP);
          destroy();
          ftpDone=true;
          return;
        }
      addToLog("FTP done:  error",LOGFTP);
    }
  else
    {
      addToLog("FTP done:  no error",LOGFTP);
    }
  ftpDone=true;
}

bool ftpInterface::isLoggedIn()
{
  return ftp->state() == QFtp::LoggedIn;
}

bool ftpInterface::isUnconnected()
{
  return ftp->state() == QFtp::Unconnected;
}

void ftpInterface::ftp_stateChanged( int )
{
  dumpState();
}

void ftpInterface::dumpState()
{
  switch (ftp->state() )
    {
    case QFtp::Unconnected:
      addToLog(QString("FTPss Unconnected name:=%1 :host=%2").arg(name).arg(host),LOGFTP);
    break;
    case QFtp::HostLookup:
      addToLog(QString("FTPss Host lookup name:=%1 :host=%2").arg(name).arg(host),LOGFTP);
    break;
    case QFtp::Connecting:
      addToLog(QString("FTPss Connecting name:=%1 :host=%2").arg(name).arg(host),LOGFTP);
    break;
    case QFtp::Connected:
      addToLog(QString("FTPss Connected name:=%1 :host=%2").arg(name).arg(host),LOGFTP);
    break;
    case QFtp::LoggedIn:
      addToLog(QString("FTPss Logged In name:=%1 :host=%2").arg(name).arg(host),LOGFTP);
    break;
    case QFtp::Closing:
      addToLog(QString("FTPss Closing name:=%1 :host=%2").arg(name).arg(host),LOGFTP);
    break;
    default:
      addToLog(QString("FTPss uknown %1 name:=%2 host=%3").arg(ftp->state()).arg(name).arg(host),LOGFTP);
    break;
    }
}


void ftpInterface::ftp_listInfo( const QUrlInfo &)
{

}

void ftpInterface::ftp_rawCommandReply( int code, const QString &text )
{
  addToLog(QString("FTP Raw Command Reply: code=%1 , %2").arg(code).arg(text),LOGFTP);
}



void ftpInterface::slotAbort()
{
  aborting=true;
  ftp->abort();
}

void ftpInterface::slotProgress(qint64 bytes ,qint64 total)
{
  displayProgressFTPEvent *stmb;
  stmb=new displayProgressFTPEvent(bytes,total);
  QApplication::postEvent( dispatcherPtr, stmb );  // Qt will delete it when done

}

eftpError ftpInterface::uploadToRXServer(QString fn)
{
  int i;
  eftpError result;
  addToLog("FTP show state",LOGFTP);
  ftp_stateChanged(ftp->state());
  result=doConnect();

  if(result!=FTPOK) return result;
  if(ftpSaveFormat==FTPIM)
    {
      ftpDone=false;
      ftp->remove(QString("image%1").arg(ftpNumImages));
      while(!ftpDone)
        {
          qApp->processEvents();
        }

      for(i=0;i<ftpNumImages-1;i++)
        //        for(i=0;i<1;i++)
        {
          //          qDebug() << "ftp renaming" << i;
          ftpDone=false;
          ftp->rename(QString("image%1").arg(ftpNumImages-1-i),QString("image%1").arg(ftpNumImages-i));
          while(!ftpDone)
            {
              qApp->processEvents();
            }
          addToLog("FTP done:  in rename",LOGFTP);
        }
      ftpDone=false;
      return uploadFile(fn,"image1",false);
    }
  else
    {
      ftpDone=false;
      return uploadFile(fn,"",false);
    }
}


