# SPDX-License-Identifier: LGPL-2.1-only
#

from typing import Any, Callable, Dict, FrozenSet, Iterable, Iterator, List, NamedTuple, \
    NoReturn, Optional, Set, Tuple, Union

import enum
import ipaddress
import setools.exception
import weakref

AnyConstraint = Union["Constraint", "Validatetrans"]
AnyDefault = Union["Default", "DefaultRange"]
AnyRBACRule = Union["RoleAllow", "RoleTransition"]
AnyTERule = Union["AVRule", "AVRuleXperm", "TERule", "FileNameTERule"]
SELINUX_SIDNAMES: Any
TypeOrAttr = Union["Type", "TypeAttribute"]
XEN_SIDNAMES: Any

def lookup_boolean_name_sub(name: str) -> str: ...

class AVRule(BaseTERule):
    default: NoReturn = ...
    perms: Set[str] = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def derive_expanded(self, *args, **kwargs) -> AVRule: ...
    def expand(self, *args, **kwargs) -> Iterable[AVRule]: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class AVRuleXperm(BaseTERule):
    default: NoReturn = ...
    perms: IoctlSet = ...
    xperm_type: str = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def expand(self, *args, **kwargs) -> Iterable[AVRuleXperm]: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class BaseConstraint(PolicyObject):
    expression: ConstraintExpression = ...
    perms: FrozenSet[str] = ...
    ruletype: ConstraintRuletype = ...
    tclass: ObjClass = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class BaseMLSLevel(PolicyObject):
    sensitivity: Sensitivity = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def categories(self) -> Iterable[Category]: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class BaseTERule(PolicyRule):
    conditional: Conditional = ...
    conditional_block: bool = ...
    filename: str = ...
    ruletype: TERuletype = ...
    source: TypeOrAttr = ...
    tclass: ObjClass = ...
    target: TypeOrAttr = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def enabled(self, **kwargs) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class BaseType(PolicySymbol):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def aliases(self) -> Iterable[str]: ...
    def attributes(self) -> Iterable[BaseType]: ...
    def expand(self) -> Iterable[BaseType]: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Boolean(PolicySymbol):
    state: bool = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class BooleanHashtabIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Boolean: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Bounds(PolicyObject):
    child: Type = ...
    parent: Type = ...
    ruletype: BoundsRuletype = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class BoundsRuletype(PolicyEnum):
    typebounds: int = ...

class Category(PolicySymbol):
    _value: int = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def aliases(self, *args, **kwargs) -> Iterable[str]: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class CategoryEbitmapIterator(EbitmapIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Category: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class CategoryHashtabIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> Category: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Common(PolicySymbol):
    perms: FrozenSet[str] = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __contains__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class CommonHashtabIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Common: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Conditional(PolicyObject):
    booleans: FrozenSet[Boolean] = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def evaluate(self, **kwargs) -> bool: ...
    def expression(self) -> Iterable[Union[ConditionalOperator, str]]: ...
    def false_rules(self, *args, **kwargs) -> Iterable[AnyTERule]: ...
    def statement(self) -> str: ...
    def true_rules(self, *args, **kwargs) -> Iterable[AnyTERule]: ...
    def truth_table(self) -> List[TruthTableRow]: ...
    def __contains__(self, other) -> bool: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class ConditionalExprIterator(PolicyIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> Union[ConditionalOperator, Boolean]: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class ConditionalIterator(PolicyIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> Conditional: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class ConditionalOperator(PolicyObject):
    _cond_expr_val_to_details: Any = ...
    evaluate: Callable = ...
    precedence: int = ...
    unary: bool = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self, *args, **kwargs) -> NoReturn: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class ConditionalTERuleIterator(PolicyIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def ruletype_count(self, *args, **kwargs) -> Any: ...
    def __len__(self) -> int: ...
    def __next__(self) -> AnyTERule: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Constraint(BaseConstraint):
    perms: FrozenSet[str] = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class ConstraintExprIterator(PolicyIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> ConstraintExprNode: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class ConstraintExprNode(PolicyObject):
    _expr_op_to_text: Any = ...
    _expr_type_to_text: Any = ...
    _role_syms: Any = ...
    _sym_to_text: Any = ...
    _type_syms: Any = ...
    _user_syms: Any = ...
    names: Union[FrozenSet[TypeOrAttr], FrozenSet[Role], FrozenSet[User]] = ...
    symbol_type: int = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> NoReturn: ...
    def __contains__(self, other) -> bool: ...
    def __getitem__(self, index) -> Union[str, FrozenSet[TypeOrAttr], FrozenSet[Role], FrozenSet[User]]: ...
    def __iter__(self) -> Iterable[Union[str, FrozenSet[TypeOrAttr], FrozenSet[Role], FrozenSet[User]]]: ...
    def __len__(self) -> int: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class ConstraintExpression(PolicyObject):
    mls: bool = ...
    roles: FrozenSet[Role] = ...
    types: FrozenSet[Type] = ...
    users: FrozenSet[User] = ...
    __hash__: Any = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def infix(self, *args, **kwargs) -> Union[str, FrozenSet[TypeOrAttr], FrozenSet[Role], FrozenSet[User]]: ...
    def statement(self) -> NoReturn: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __getitem__(self, index) -> Union[str, FrozenSet[TypeOrAttr], FrozenSet[Role], FrozenSet[User]]: ...
    def __gt__(self, other) -> bool: ...
    def __iter__(self) -> Iterator[Union[FrozenSet[Role], FrozenSet[Type], FrozenSet[User], str]]: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class ConstraintIterator(PolicyIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> Constraint: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class ConstraintRuletype(PolicyEnum):
    constrain: int = ...
    mlsconstrain: int = ...
    mlsvalidatetrans: int = ...
    validatetrans: int = ...

class ConstraintUseError(setools.exception.SymbolUseError): ...

class Context(PolicyObject):
    range_: Range = ...
    role: Role = ...
    type_: Type = ...
    user: User = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Default(PolicyObject):
    default: DefaultValue = ...
    ruletype: DefaultRuletype = ...
    tclass: ObjClass = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class DefaultRange(Default):
    default_range: DefaultRangeValue = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class DefaultRangeValue(PolicyEnum):
    high: int = ...
    low: int = ...
    low_high: int = ...
    @classmethod
    def from_default_range(self, range: Optional[int]) -> Optional[DefaultRangeValue]: ...

class DefaultRuletype(PolicyEnum):
    default_range: int = ...
    default_role: int = ...
    default_type: int = ...
    default_user: int = ...

class DefaultValue(PolicyEnum):
    glblub: int = ...
    source: int = ...
    target: int = ...
    @classmethod
    def from_default_range(self, *args, **kwargs) -> Any: ...

class Devicetreecon(Ocontext):
    path: str = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class DevicetreeconIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Devicetreecon: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class EbitmapIterator(PolicyIterator):
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> PolicyObject: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FSUse(Ocontext):
    fs: str = ...
    ruletype: FSUseRuletype = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FSUseIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> FSUse: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FSUseRuletype(PolicyEnum):
    fs_use_task: int = ...
    fs_use_trans: int = ...
    fs_use_xattr: int = ...

class FileNameTERule(BaseTERule):
    default: Type = ...
    filename: str = ...
    perms: NoReturn = ...
    ruletype: TERuletype = ...
    source: TypeOrAttr = ...
    tclass: ObjClass = ...
    target: TypeOrAttr = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def expand(self, *args, **kwargs) -> Iterable[FileNameTERule]: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class FileNameTERuleIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> FileNameTERule: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class GenfsFiletype(int):
    _filetype_to_text: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Genfscon(Ocontext):
    _sclass_to_stat: Any = ...
    filetype: GenfsFiletype = ...
    fs: str = ...
    path: str = ...
    tclass: ObjClass = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class GenfsconIterator:
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __iter__(self) -> Iterable[Genfscon]: ...
    def __len__(self) -> int: ...
    def __next__(self) -> Genfscon: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class GenfsconOcontextIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Ocontext: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class HandleUnknown(PolicyEnum):
    allow: int = ...
    deny: int = ...
    reject: int = ...

class HashtabIterator(PolicyIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> Any: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Ibendportcon(Ocontext):
    name: str = ...
    port: int = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class IbendportconIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Ibendportcon: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Ibpkeycon(Ocontext):
    pkeys: IbpkeyconRange = ...
    subnet_prefix: ipaddress.IPv6Address = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class IbpkeyconIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Ibpkeycon: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class IbpkeyconRange(Tuple[int, int]):
    _asdict: Any = ...
    _field_defaults: Any = ...
    _fields: Any = ...
    _fields_defaults: Any = ...
    _replace: Any = ...
    high: int = ...
    low: int = ...
    __getnewargs__: Any = ...
    __slots__: Any = ...
    def __init__(self, *args, **kwargs) -> None: ...
    @classmethod
    def _make(self, *args, **kwargs) -> Any: ...

class InitialSID(Ocontext):
    name: str = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class InitialSIDIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> InitialSID: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class InvalidBoolean(setools.exception.InvalidSymbol): ...

class InvalidBoundsType(setools.exception.InvalidSymbol): ...

class InvalidCategory(setools.exception.InvalidSymbol): ...

class InvalidClass(setools.exception.InvalidSymbol): ...

class InvalidCommon(setools.exception.InvalidSymbol): ...

class InvalidConstraintType(setools.exception.InvalidSymbol): ...

class InvalidDefaultRange(setools.exception.InvalidSymbol): ...

class InvalidDefaultType(setools.exception.InvalidRuleType): ...

class InvalidDefaultValue(setools.exception.InvalidSymbol): ...

class InvalidFSUseType(setools.exception.InvalidRuleType): ...

class InvalidInitialSid(setools.exception.InvalidSymbol): ...

class InvalidLevel(setools.exception.InvalidSymbol): ...

class InvalidLevelDecl(setools.exception.InvalidSymbol): ...

class InvalidMLSRuleType(setools.exception.InvalidRuleType): ...

class InvalidPolicy(ValueError, setools.exception.PolicyrepException): ...

class InvalidRBACRuleType(setools.exception.InvalidRuleType): ...

class InvalidRange(setools.exception.InvalidSymbol): ...

class InvalidRole(setools.exception.InvalidSymbol): ...

class InvalidRuleType(setools.exception.InvalidSymbol): ...

class InvalidSensitivity(setools.exception.InvalidSymbol): ...

class InvalidTERuleType(setools.exception.InvalidRuleType): ...

class InvalidType(setools.exception.InvalidSymbol): ...

class InvalidUser(setools.exception.InvalidSymbol): ...

class IoctlSet(FrozenSet[int]):
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def ranges(self) -> int: ...
    def __format__(self, *args, **kwargs) -> str: ...
    def __reduce_cython__(self, *args, **kwargs) -> Any: ...
    def __setstate_cython__(self, *args, **kwargs) -> Any: ...

class Iomemcon(Ocontext):
    addr: IomemconRange = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class IomemconIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Iomemcon: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class IomemconRange(Tuple[int, int]):
    _asdict: Any = ...
    _field_defaults: Any = ...
    _fields: Any = ...
    _fields_defaults: Any = ...
    _replace: Any = ...
    high: int = ...
    low: int = ...
    __getnewargs__: Any = ...
    __slots__: Any = ...
    def __init__(self, *args, **kwargs) -> None: ...
    @classmethod
    def _make(self, *args, **kwargs) -> Any: ...

class Ioportcon(Ocontext):
    ports: IoportconRange = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class IoportconIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Ioportcon: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class IoportconRange(Tuple[int, int]):
    _asdict: Any = ...
    _field_defaults: Any = ...
    _fields: Any = ...
    _fields_defaults: Any = ...
    _replace: Any = ...
    high: int = ...
    low: int = ...
    __getnewargs__: Any = ...
    __slots__: Any = ...
    def __init__(self, *args, **kwargs) -> None: ...
    @classmethod
    def _make(self, *args, **kwargs) -> Any: ...

class Level(BaseMLSLevel):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> NoReturn: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __rxor__(self, other) -> bool: ...
    def __setstate__(self, state) -> Any: ...
    def __xor__(self, other) -> bool: ...

class LevelDecl(BaseMLSLevel):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class LevelDeclHashtabIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> LevelDecl: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class LowLevelPolicyError(ValueError, setools.exception.PolicyrepException): ...

class MLSDisabled(setools.exception.PolicyrepException): ...

class MLSRule(PolicyRule):
    default: Range = ...
    origin: MLSRule = ...
    ruletype: MLSRuletype = ...
    source: TypeOrAttr = ...
    tclass: ObjClass = ...
    target: TypeOrAttr = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def expand(self) -> Iterable[MLSRule]: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class MLSRuleIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> MLSRuletype: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class MLSRuletype(PolicyEnum):
    range_transition: int = ...

class Netifcon(Ocontext):
    netif: str = ...
    packet: Context = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class NetifconIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Netifcon: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class NoCommon(AttributeError, setools.exception.PolicyrepException): ...

class NoDefaults(setools.exception.InvalidSymbol): ...

class NoStatement(setools.exception.SymbolUseError): ...

class Nodecon(Ocontext):
    ip_version: NodeconIPVersion = ...
    network: Union[ipaddress.IPv4Network, ipaddress.IPv6Network] = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class NodeconIPVersion(PolicyEnum):
    ipv4: int = ...
    ipv6: int = ...

class NodeconIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Nodecon: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class ObjClass(PolicySymbol):
    common: Common = ...
    perms: FrozenSet[str] = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def constraints(self, *args, **kwargs) -> Iterable[Constraint]: ...
    def defaults(self, *args, **kwargs) -> Iterable[AnyDefault]: ...
    def statement(self) -> str: ...
    def validatetrans(self, *args, **kwargs) -> Iterable[Validatetrans]: ...
    def __contains__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class ObjClassHashtabIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> ObjClass: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Ocontext(PolicyObject):
    context: Context = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class OcontextIterator(PolicyIterator):
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> Ocontext: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Pcidevicecon(Ocontext):
    device: str = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class PcideviceconIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Pcidevicecon: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class PermissionVectorIterator(PolicyIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Pirqcon(Ocontext):
    irq: int = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class PirqconIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Pirqcon: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class PolicyCapability(PolicySymbol):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class PolicyCapabilityIterator(EbitmapIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> PolicyCapability: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class PolicyEnum(enum.Enum):
    @classmethod
    def lookup(self, value) -> Any: ...
    def __eq__(self, other) -> bool: ...
    def __format__(self, *args, **kwargs) -> Any: ...
    def __hash__(self) -> int: ...

class PolicyIterator:
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __iter__(self) -> Any: ...
    def __len__(self) -> int: ...
    def __next__(self) -> Any: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class PolicyObject:
    policy: SELinuxPolicy = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __copy__(self) -> PolicyObject: ...
    def __deepcopy__(self) -> PolicyObject: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class PolicyRule(PolicyObject):
    conditional: Conditional = ...
    conditional_block: bool = ...
    extended: bool = ...
    origin: PolicyRule = ...
    ruletype: Any = ...
    source: PolicySymbol = ...
    target: PolicySymbol = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def enabled(self, **kwargs) -> bool: ...
    def expand(self) -> Any: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class PolicySymbol(PolicyObject):
    name: str = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class PolicyTarget(PolicyEnum):
    selinux: int = ...
    xen: int = ...

class Portcon(Ocontext):
    ports: PortconRange = ...
    protocol: PortconProtocol = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class PortconIterator(OcontextIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Portcon: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class PortconProtocol(PolicyEnum):
    dccp: int = ...
    sctp: int = ...
    tcp: int = ...
    udp: int = ...

class PortconRange(Tuple[int, int]):
    _asdict: Any = ...
    _field_defaults: Any = ...
    _fields: Any = ...
    _fields_defaults: Any = ...
    _replace: Any = ...
    high: int = ...
    low: int = ...
    __getnewargs__: Any = ...
    __slots__: Any = ...
    def __init__(self, *args, **kwargs) -> None: ...
    @classmethod
    def _make(self, *args, **kwargs) -> Any: ...

class RBACRuletype(PolicyEnum):
    allow: int = ...
    role_transition: int = ...

class Range(PolicyObject):
    high: Level = ...
    low: Level = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __contains__(self, other) -> bool: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Role(PolicySymbol):
    dominated_roles: FrozenSet[Role] = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def expand(self) -> Iterable[Role]: ...
    def statement(self) -> str: ...
    def types(self) -> Iterable[Type]: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class RoleAllow(PolicyRule):
    default: NoReturn = ...
    ruletype: RBACRuletype = ...
    source: Role = ...
    tclass: NoReturn = ...
    target: Role = ...

    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def expand(self) -> Iterable[RoleAllow]: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class RoleAllowIterator(PolicyIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> RoleAllow: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class RoleEbitmapIterator(EbitmapIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Any: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class RoleHashtabIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Role: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class RoleTransition(PolicyRule):
    default: Role = ...
    ruletype: RBACRuletype = ...
    source: Role = ...
    tclass: ObjClass = ...
    target: TypeOrAttr = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def expand(self) -> Iterable[RoleTransition]: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class RoleTransitionIterator(PolicyIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> RoleTransition: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class RuleNotConditional(AttributeError, setools.exception.PolicyrepException): ...

class RuleUseError(setools.exception.SymbolUseError): ...

class SELinuxPolicy:
    allow_count: int = ...
    allowxperm_count: int = ...
    auditallow_count: int = ...
    auditallowxperm_count: int = ...
    boolean_count: int = ...
    category_count: int = ...
    class_count: int = ...
    common_count: int = ...
    conditional_count: int = ...
    constraint_count: int = ...
    default_count: int = ...
    devicetreecon_count: int = ...
    dontaudit_count: int = ...
    dontauditxperm_count: int = ...
    fs_use_count: int = ...
    genfscon_count: int = ...
    handle_unknown: HandleUnknown = ...
    ibendportcon_count: int = ...
    ibpkeycon_count: int = ...
    initialsids_count: int = ...
    iomemcon_count: int = ...
    ioportcon_count: int = ...
    level_count: int = ...
    mls: bool = ...
    mlsconstraint_count: int = ...
    mlsvalidatetrans_count: int = ...
    netifcon_count: int = ...
    neverallow_count: int = ...
    neverallowxperm_count: int = ...
    nodecon_count: int = ...
    path: str = ...
    pcidevicecon_count: int = ...
    permission_count: int = ...
    permissives_count: int = ...
    pirqcon_count: int = ...
    polcap_count: int = ...
    portcon_count: int = ...
    range_transition_count: int = ...
    role_allow_count: int = ...
    role_count: int = ...
    role_transition_count: int = ...
    target_platform: PolicyTarget = ...
    type_attribute_count: int = ...
    type_change_count: int = ...
    type_count: int = ...
    type_member_count: int = ...
    type_transition_count: int = ...
    typebounds_count: int = ...
    user_count: int = ...
    validatetrans_count: int = ...
    version: int = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, policyfile: Optional[str] = None) -> None: ...
    def bools(self) -> Iterable[Boolean]: ...
    def bounds(self) -> Iterable[Bounds]: ...
    def categories(self) -> Iterable[Category]: ...
    def classes(self) -> Iterable[ObjClass]: ...
    def commons(self) -> Iterable[Common]: ...
    def conditionals(self) -> Iterable[Conditional]: ...
    def constraints(regularandMLS) -> Iterable[AnyConstraint]: ...
    def defaults(self) -> Iterable[AnyDefault]: ...
    def devicetreecons(self) -> Iterable[Devicetreecon]: ...
    def fs_uses(self) -> Iterable[FSUse]: ...
    def genfscons(self) -> Iterable[Genfscon]: ...
    def ibendportcons(self) -> Iterable[Ibendportcon]: ...
    def ibpkeycons(self) -> Iterable[Ibpkeycon]: ...
    def initialsids(self) -> Iterable[InitialSID]: ...
    def iomemcons(self) -> Iterable[Iomemcon]: ...
    def ioportcons(self) -> Iterable[Ioportcon]: ...
    def levels(self) -> Iterable[Level]: ...
    def lookup_boolean(self, name: Union[Boolean, str]) -> Boolean: ...
    def lookup_category(self, name: Union[Category, str], deref: bool = True) -> Category: ...
    def lookup_class(self, name: Union[ObjClass, str]) -> ObjClass: ...
    def lookup_common(self, name: Union[Common, str]) -> Common: ...
    def lookup_initialsid(self, name: Union[InitialSID, str]) -> InitialSID: ...
    def lookup_level(self, name: Union[Level, str]) -> Level: ...
    def lookup_range(self, name: Union[Range, str]) -> Range: ...
    def lookup_role(self, name: Union[Role, str]) -> Role: ...
    def lookup_sensitivity(self, name: Union[Sensitivity, str]) -> Sensitivity: ...
    def lookup_type(self, name: Union[Type, str], deref: bool = True) -> Type: ...
    def lookup_type_or_attr(self, name: Union[TypeOrAttr, str], deref: bool = True) -> TypeOrAttr: ...
    def lookup_typeattr(self, name: Union[TypeAttribute, str]) -> TypeAttribute: ...
    def lookup_user(self, name: Union[User, str]) -> User: ...
    def mlsrules(self) -> Iterable[MLSRule]: ...
    def netifcons(self) -> Iterable[Netifcon]: ...
    def nodecons(self) -> Iterable[Nodecon]: ...
    def pcidevicecons(self) -> Iterable[Pcidevicecon]: ...
    def pirqcons(self) -> Iterable[Pirqcon]: ...
    def polcaps(self) -> Iterable[PolicyCapability]: ...
    def portcons(self) -> Iterable[Portcon]: ...
    def rbacrules(self) -> Iterable[AnyRBACRule]: ...
    def roles(self) -> Iterable[Role]: ...
    def sensitivities(self) -> Iterable[Sensitivity]: ...
    def terules(self) -> Iterable[AnyTERule]: ...
    def typeattributes(self) -> Iterable[TypeAttribute]: ...
    def types(self) -> Iterable[Type]: ...
    def users(self) -> Iterable[User]: ...
    def __copy__(self) -> SELinuxPolicy: ...
    def __deepcopy__(self) -> SELinuxPolicy: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Sensitivity(PolicySymbol):
    _value: int = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def aliases(self, *args, **kwargs) -> Any: ...
    def level_decl(self, *args, **kwargs) -> Any: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class SensitivityHashtabIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> Sensitivity: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class SymbolUseError(AttributeError, setools.exception.PolicyrepException): ...

class TERule(BaseTERule):
    default: Type = ...
    perms: NoReturn = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def expand(self) -> Iterable[TERule]: ...
    def statement(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class TERuleIterator(PolicyIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def ruletype_count(self, *args, **kwargs) -> Any: ...
    def __len__(self) -> int: ...
    def __next__(self) -> TERule: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class TERuleNoFilename(AttributeError, setools.exception.PolicyrepException): ...

class TERuletype(PolicyEnum):
    allow: int = ...
    allowxperm: int = ...
    auditallow: int = ...
    auditallowxperm: int = ...
    dontaudit: int = ...
    dontauditxperm: int = ...
    neverallow: int = ...
    neverallowxperm: int = ...
    type_change: int = ...
    type_member: int = ...
    type_transition: int = ...

class TruthTableRow(NamedTuple):
    values: Dict[str, bool]
    result: bool

class Type(BaseType):
    ispermissive: bool = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def aliases(self) -> Iterable[str]: ...
    def attributes(self) -> Iterable[TypeAttribute]: ...
    def expand(self) -> Iterable[Type]: ...
    def statement(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class TypeAttribute(BaseType):
    ispermissive: bool = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def aliases(self) -> Iterable[str]: ...
    def attributes(self) -> Iterable[TypeAttribute]: ...
    def expand(self) -> Iterable[Type]: ...
    def statement(self) -> str: ...
    def __contains__(self, other) -> bool: ...
    def __iter__(self) -> Iterable[TypeAttribute]: ...
    def __len__(self) -> int: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class TypeAttributeEbitmapIterator(EbitmapIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> TypeAttribute: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class TypeAttributeHashtabIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> TypeAttribute: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class TypeEbitmapIterator(EbitmapIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> Type: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class TypeHashtabIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> Type: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class TypeOrAttributeEbitmapIterator(EbitmapIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> TypeOrAttr: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class TypeboundsIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> Bounds: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class User(PolicySymbol):
    mls_level: Level = ...
    mls_range: Range = ...
    roles: FrozenSet[Role] = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class UserEbitmapIterator(EbitmapIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> User: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class UserHashtabIterator(HashtabIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def __next__(self) -> User: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class Validatetrans(BaseConstraint):
    perms: NoReturn = ...
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def statement(self) -> str: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class ValidatetransIterator(PolicyIterator):
    __pyx_vtable__: Any = ...
    @classmethod
    def __init__(self, *args, **kwargs) -> None: ...
    def reset(self) -> None: ...
    def __len__(self) -> int: ...
    def __next__(self) -> Validatetrans: ...
    def __reduce__(self) -> Any: ...
    def __setstate__(self, state) -> Any: ...

class WeakKeyDefaultDict(weakref.WeakKeyDictionary):
    _abc_impl: Any = ...
    __abstractmethods__: Any = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def __getitem__(self, index) -> Any: ...
    def __missing__(self, *args, **kwargs) -> Any: ...
