#	links.py

#	Search for link complements in the 5-tetrahedron census.

#	Note:  The pound sign (#) introduces comments.

from SnapPea import *

#	Examine each Triangulation in the 5-tetrahedron census.
for t in CuspedCensus():

	#	For each cusp, do a Dehn filling on the shortest
	#	curve, which, by SnapPea's convention, is the
	#	meridional filling (1,0).
	for i in range(t.get_num_cusps()):
		t.set_cusp(i, 1, 0)
		
	#	We now have a closed manifold.
	#	Look at its fundamental group, and if the
	#	number of generators is zero (meaning the
	#	group is trivial), print the name of
	#	the original Triangulation, which we have shown
	#	to be a link complement in a homotopy sphere.
	if t.fundamental_group().num_generators() == 0:
		print t.get_name()
