// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef SIMPLEX_IS_INCLUDED
#define SIMPLEX_IS_INCLUDED

#include "Ptv.h"
#include <vector>
#include <iterator>
#include <iostream>

/*
 * Note: at present the OrderedPtvSet class is more general than a OrderedPtvSet.
 * It is actually a point set. Still, we will only use it as a OrderedPtvSet.
 * It might be that we should use a different name and/or implement
 * a sub class or something which is strictly a OrderedPtvSet.
 */

using namespace std;

namespace SyFi
{

	class OrderedPtvSet
	{
		vector<Ptv> Ptvs;

		public:
			OrderedPtvSet();
			OrderedPtvSet(const Ptv& p0, const Ptv& p1);
			OrderedPtvSet(const Ptv& p0, const Ptv& p1, const Ptv& p2);
			OrderedPtvSet(const Ptv& p0, const Ptv& p1, const Ptv& p2, const Ptv& p3);
			virtual ~OrderedPtvSet();

			void append(const Ptv& p);
			unsigned int size() const;
			const Ptv& operator [] (unsigned int i) const;
			Ptv& operator [] (unsigned int i);
			OrderedPtvSet& operator = (const OrderedPtvSet& p);
			bool less(const OrderedPtvSet& s) const;
	};

	struct OrderedPtvSet_is_less : public std::binary_function<OrderedPtvSet, OrderedPtvSet, bool>
	{
		bool operator() (const OrderedPtvSet &lh, const OrderedPtvSet &rh) const { return lh.less(rh);  }
	};

	std::ostream & operator<< ( std::ostream& os, const OrderedPtvSet& p);

	// Note that this OrderedPtvSet_i might be implemented as a subclass ?
	class OrderedPtvSet_i
	{
		pair<OrderedPtvSet,vector<unsigned int> >  si;

		public:
			OrderedPtvSet_i();
			OrderedPtvSet_i(OrderedPtvSet& s, unsigned int i);
			OrderedPtvSet_i(OrderedPtvSet& s, unsigned int i0, unsigned int i1);
			virtual ~OrderedPtvSet_i();

			const OrderedPtvSet& get_OrderedPtvSet() const;
			unsigned int get_i(unsigned int n) const;
			unsigned int size() const;
			bool less(const OrderedPtvSet_i& si) const;
	};

	struct OrderedPtvSet_i_is_less : public std::binary_function<OrderedPtvSet_i, OrderedPtvSet_i, bool>
	{
		bool operator() (const OrderedPtvSet_i &lh, const OrderedPtvSet_i &rh) const { return lh.less(rh);  }
	};

	std::ostream & operator<< ( std::ostream& os, const OrderedPtvSet_i& si);

}								 // namespace SyFi
#endif
