package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTrafficMirrorFilterRuleAttribute invokes the vpc.UpdateTrafficMirrorFilterRuleAttribute API synchronously
func (client *Client) UpdateTrafficMirrorFilterRuleAttribute(request *UpdateTrafficMirrorFilterRuleAttributeRequest) (response *UpdateTrafficMirrorFilterRuleAttributeResponse, err error) {
	response = CreateUpdateTrafficMirrorFilterRuleAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTrafficMirrorFilterRuleAttributeWithChan invokes the vpc.UpdateTrafficMirrorFilterRuleAttribute API asynchronously
func (client *Client) UpdateTrafficMirrorFilterRuleAttributeWithChan(request *UpdateTrafficMirrorFilterRuleAttributeRequest) (<-chan *UpdateTrafficMirrorFilterRuleAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateTrafficMirrorFilterRuleAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTrafficMirrorFilterRuleAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTrafficMirrorFilterRuleAttributeWithCallback invokes the vpc.UpdateTrafficMirrorFilterRuleAttribute API asynchronously
func (client *Client) UpdateTrafficMirrorFilterRuleAttributeWithCallback(request *UpdateTrafficMirrorFilterRuleAttributeRequest, callback func(response *UpdateTrafficMirrorFilterRuleAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTrafficMirrorFilterRuleAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateTrafficMirrorFilterRuleAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTrafficMirrorFilterRuleAttributeRequest is the request struct for api UpdateTrafficMirrorFilterRuleAttribute
type UpdateTrafficMirrorFilterRuleAttributeRequest struct {
	*requests.RpcRequest
	SourcePortRange           string           `position:"Query" name:"SourcePortRange"`
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DestinationPortRange      string           `position:"Query" name:"DestinationPortRange"`
	ClientToken               string           `position:"Query" name:"ClientToken"`
	RuleAction                string           `position:"Query" name:"RuleAction"`
	Protocol                  string           `position:"Query" name:"Protocol"`
	SourceCidrBlock           string           `position:"Query" name:"SourceCidrBlock"`
	DryRun                    requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	DestinationCidrBlock      string           `position:"Query" name:"DestinationCidrBlock"`
	OwnerAccount              string           `position:"Query" name:"OwnerAccount"`
	Priority                  requests.Integer `position:"Query" name:"Priority"`
	OwnerId                   requests.Integer `position:"Query" name:"OwnerId"`
	TrafficMirrorFilterRuleId string           `position:"Query" name:"TrafficMirrorFilterRuleId"`
}

// UpdateTrafficMirrorFilterRuleAttributeResponse is the response struct for api UpdateTrafficMirrorFilterRuleAttribute
type UpdateTrafficMirrorFilterRuleAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTrafficMirrorFilterRuleAttributeRequest creates a request to invoke UpdateTrafficMirrorFilterRuleAttribute API
func CreateUpdateTrafficMirrorFilterRuleAttributeRequest() (request *UpdateTrafficMirrorFilterRuleAttributeRequest) {
	request = &UpdateTrafficMirrorFilterRuleAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "UpdateTrafficMirrorFilterRuleAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTrafficMirrorFilterRuleAttributeResponse creates a response to parse from UpdateTrafficMirrorFilterRuleAttribute response
func CreateUpdateTrafficMirrorFilterRuleAttributeResponse() (response *UpdateTrafficMirrorFilterRuleAttributeResponse) {
	response = &UpdateTrafficMirrorFilterRuleAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
