# (Damien Leroux, Inra, 2009)
# Once done this will define :
#
# GMP_FOUND - system has libgmp
# GMP_INCLUDE_DIR - the GMP include directory
# GMP_LIBRARIES - what to link against to use GMP

if(WIN32)

set(GMP_INCLUDE_DIR ${CMAKE_CURRENT_SOURCE_DIR}/lib/win32/gmp/include)
set(GMP_LIBRARY  ${CMAKE_CURRENT_SOURCE_DIR}/lib/win32/gmp/lib/)

#set(GMP_INCLUDE_DIR ${CMAKE_CURRENT_SOURCE_DIR}/gmp/gmp-4.3.2/include)
#set(GMP_LIBRARY  ${CMAKE_CURRENT_SOURCE_DIR}/gmp/gmp-4.3.2/lib/)

#FIND_PATH(GMP_INCLUDE_DIR gmp.h paths ${CMAKE_CURRENT_SOURCE_DIR}/win32/gmp/include/ ${CMAKE_CURRENT_SOURCE_DIR})
#FIND_LIBRARY(GMP_LIBRARY gmp paths ${CMAKE_CURRENT_SOURCE_DIR}/gmp/gmp-4.3.2/lib/ ${CMAKE_CURRENT_SOURCE_DIR}/win32/gmp/lib/ ${CMAKE_CURRENT_SOURCE_DIR} /cross)

IF (GMP_INCLUDE_DIR AND GMP_LIBRARY)
SET(GMP_FOUND TRUE)
LINK_DIRECTORIES( ${GMP_LIBRARY})
INCLUDE_DIRECTORIES(${GMP_INCLUDE_DIR}) 
ENDIF (GMP_INCLUDE_DIR AND GMP_LIBRARY)
ELSE()
FIND_PATH(GMP_INCLUDE_DIR gmp.h)
FIND_LIBRARY(GMP_LIBRARY gmp)

ENDIF()
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(GMP DEFAULT_MSG GMP_LIBRARY GMP_INCLUDE_DIR)

#INCLUDE(CheckLibraryExists)
#CHECK_LIBRARY_EXISTS(${GMP_LIBRARY} _gmpf_init "" HAVE_GMP)
  MESSAGE(STATUS "GMP LIB: ${GMP_LIBRARY}")
  MESSAGE(STATUS "GMP include: ${GMP_INCLUDE_DIR}")

IF (GMP_FOUND)
   IF (NOT GMP_FIND_QUIETLY)
      MESSAGE(STATUS "Found gmp: ${GMP_LIBRARY}")
   ENDIF (NOT GMP_FIND_QUIETLY)
ELSE (GMP_FOUND)
   IF (GMP_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find gmp lib")
   ENDIF (GMP_FIND_REQUIRED)
ENDIF (GMP_FOUND)

MARK_AS_ADVANCED(GMP_INCLUDE_DIR GMP_LIBRARIES GMP_FOUND)

