/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "vinoui.h"

VinoUi::VinoUi(QWidget *parent) : QWidget(parent)
{
    initUi();
}

void VinoUi::initUi()
{
    QVBoxLayout *vLyt = new QVBoxLayout(this);
    vLyt->setContentsMargins(0, 0, 0, 0);

    mVinoFrame = new SettingGroup;
    mVinoTitleLabel = new TitleLabel(this);
    mVinoTitleLabel->setText(tr("Remote Desktop"));

    mEnableWidget = new SwitchWidget(tr("Connect to your desktop remotely"),this);
    mEnableWidget->setObjectName("Connect to your desktop remotely");
    //~ contents_path /Vino/Allow others to connect to your desktop remotely using RDP
    mXrdpEnableWidget = new SwitchWidget(tr("Allow others to connect to your desktop remotely using RDP"), this);
    mXrdpEnableWidget->setObjectName("Allow others to connect to your desktop remotely using RDP");
    //~ contents_path /Vino/Allow others to connect to your desktop remotely using VNC
    mVinoEnableWidget = new SwitchWidget(tr("Allow others to connect to your desktop remotely using VNC"), this);
    mVinoEnableWidget->setObjectName("Allow others to connect to your desktop remotely using VNC");
    //~ contents_path /Vino/Allow connection to control screen
    mViewWidget = new SwitchWidget(tr("Allow connection to control screen"));
    //~ contents_path /Vino/You must confirm every visit for this machine
    mSecurityWidget = new SwitchWidget(tr("You must confirm every visit for this machine"));
    //~ contents_path /Vino/Require user to enter this password:
    mSecurityPwdWidget = new SwitchWidget(tr("Require user to enter this password: "));
#ifdef Nile
    mPwdinputLabel = new PasswordLabel(this);
    mSecurityPwdWidget->insertWidget(1, mPwdinputLabel);
#else
    mPwdstrLabel = new QLabel(this);
    mSecurityPwdWidget->insertWidget(1, mPwdstrLabel);
#endif
    mPwdstrLabel->setObjectName("vnc-pwdsettings");
    mPwdEditBtn = new QPushButton(tr("Edit"), this);

    mSecurityPwdWidget->insertWidget(3, mPwdEditBtn);

    mVinoFrame->addWidget(mVinoEnableWidget);
    mVinoFrame->addWidget(mViewWidget);
    mVinoFrame->addWidget(mSecurityWidget);
    mVinoFrame->addWidget(mSecurityPwdWidget);

    vLyt->addWidget(mVinoTitleLabel);
    vLyt->addWidget(mEnableWidget);
    vLyt->addWidget(mXrdpEnableWidget);
    vLyt->addWidget(mVinoFrame);
    vLyt->addStretch();
}

void VinoUi::setFrameVisible(bool visible)
{
    mVinoEnableWidget->setChecked(visible);
    mViewWidget->setVisible(visible);
    mSecurityWidget->setVisible(visible);
    mSecurityPwdWidget->setVisible(visible);
}
