/*
 * unity-npapi-plugin-entry-funcs.c
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>

#include "unity-npapi-plugin.h"
#include "unity-npapi-plugin-pp-funcs.h"


// TODO bind all this to project specific defines
// TODO review for better compliance : http://gplflash.sourceforge.net/gplflash2_blog/npapi.html, the format DOES matter (at least for chrome)
static const char * UNITY_NPAPI_MIME_DESCR 			= "application/x-unity-webapps-npapi:none:Unity WebApps NPAPI Plugin";
static const char * UNITY_NPAPI_PlUGIN_NAME 		= "Unity WebApps plugin";
static const char * UNITY_NPAPI_PLUGIN_DESCRIPTION  = "Unity WebApps plugin";
static const char * UNITY_NPAPI_PLUGIN_VERSION      = "0.1";



/**
 * Must exist on Linux / Unix systems (verify)
 * 
 */
const char * NP_GetMIMEDescription (void)
{
  return UNITY_NPAPI_MIME_DESCR;
}


/**
 * TODO: not sure if it is actually needed
 * 
 */
char * NP_GetPluginVersion (void)
{
  return UNITY_NPAPI_PLUGIN_VERSION;
}


/**
 * Must exist on Linux / Unix systems (verify)
 * 
 */
NPError NP_GetValue (void* reserved, NPPVariable variable, void* out)
{
  if (NULL == out) 
    {
      return NPERR_INVALID_PARAM;
    }

  // TODO check if other are supported
  switch (variable)
    {
    case NPPVpluginNameString:
      *((char **) out) = (char *)UNITY_NPAPI_PlUGIN_NAME;
      break;

    case NPPVpluginDescriptionString:
      *((char **) out) = (char *)UNITY_NPAPI_PLUGIN_DESCRIPTION;
      break;

    default:
      return NPERR_INVALID_PARAM;
    }

  return NPERR_NO_ERROR;
}


/**
 * Class initialize, on GNU/Linux is supposed to init both the NPN and NPP functions
 * pointer structs
 *
 */
NPError NP_Initialize (NPNetscapeFuncs  * pBrowserFuncs
		       , NPPluginFuncs * pPluginFuncs)
{
  if (NULL == pBrowserFuncs || NULL == pPluginFuncs)
    {
      return NPERR_INVALID_PARAM;
    }
	
  if (pBrowserFuncs->size < sizeof(NPNetscapeFuncs))
    {
      return NPERR_INVALID_FUNCTABLE_ERROR;
    }
 	
  return (0 == unity_npapi_initialize_plugin (pBrowserFuncs, pPluginFuncs))
    ? NPERR_NO_ERROR
    : NPERR_MODULE_LOAD_FAILED_ERROR;
}


NPError NP_Shutdown(void)
{
  unity_npapi_cleanup_plugin ();
	
  return NPERR_NO_ERROR;
}



