/* amd64-win64.pep.h
   created from amd64-win64.pep.bin, 21168 (0x52b0) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2013 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2013 Laszlo Molnar
   Copyright (C) 2000-2013 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ml1050@users.sourceforge.net>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_AMD64_WIN64_PEP_SIZE    21168
#define STUB_AMD64_WIN64_PEP_ADLER32 0x11b3b4f8
#define STUB_AMD64_WIN64_PEP_CRC32   0xa0ed3bbf

unsigned char stub_amd64_win64_pep[21168] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,176, 27,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 80,  0, 77,  0,
/* 0x0040 */  72,137, 76, 36,  8, 72,137, 84, 36, 16, 76,137, 68, 36, 24,128,
/* 0x0050 */ 250,  1, 15,133,  0,  0,  0,  0, 83, 86, 87, 85, 72,141, 53,  0,
/* 0x0060 */   0,  0,  0, 72,141,190,  0,  0,  0,  0,102,255,135,  0,  0,  0,
/* 0x0070 */   0,102,129,135,  0,  0,  0,  0,  0,128, 72,141,135,  0,  0,  0,
/* 0x0080 */   0,255, 48,199,  0,  0,  0,  0,128, 80, 87, 49,219, 49,201, 72,
/* 0x0090 */ 131,205,255,232, 80,  0,  0,  0,  1,219,116,  2,243,195,139, 30,
/* 0x00a0 */  72,131,238,252, 17,219,138, 22,243,195, 72,141,  4, 47,131,249,
/* 0x00b0 */   5,138, 16,118, 33, 72,131,253,252,119, 27,131,233,  4,139, 16,
/* 0x00c0 */  72,131,192,  4,131,233,  4,137, 23, 72,141,127,  4,115,239,131,
/* 0x00d0 */ 193,  4,138, 16,116, 16, 72,255,192,136, 23,131,233,  1,138, 16,
/* 0x00e0 */  72,141,127,  1,117,240,243,195,252, 65, 91,235,  8, 72,255,198,
/* 0x00f0 */ 136, 23, 72,255,199,138, 22,  1,219,117, 10,139, 30, 72,131,238,
/* 0x0100 */ 252, 17,219,138, 22,114,230,141, 65,  1, 65,255,211, 17,192,  1,
/* 0x0110 */ 219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22,115,235,131,
/* 0x0120 */ 232,  3,114, 23,193,224,  8, 15,182,210,  9,208, 72,255,198,131,
/* 0x0130 */ 240,255, 15,132,  0,  0,  0,  0, 72, 99,232,141, 65,  1, 65,255,
/* 0x0140 */ 211, 17,201, 65,255,211, 17,201,117, 24,137,193,131,192,  2, 65,
/* 0x0150 */ 255,211, 17,201,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,
/* 0x0160 */ 115,237, 72,129,253,  0,243,255,255, 17,193,232,  0,  0,  0,  0,
/* 0x0170 */ 235,131,235,  8, 72,255,198,136, 23, 72,255,199,138, 22,  1,219,
/* 0x0180 */ 117, 10,139, 30, 72,131,238,252, 17,219,138, 22,114,230,141, 65,
/* 0x0190 */   1,235,  7,255,200, 65,255,211, 17,192, 65,255,211, 17,192,  1,
/* 0x01a0 */ 219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22,115,228,131,
/* 0x01b0 */ 232,  3,114, 27,193,224,  8, 15,182,210,  9,208, 72,255,198,131,
/* 0x01c0 */ 240,255, 15,132,  0,  0,  0,  0,209,248, 72, 99,232,235,  3, 65,
/* 0x01d0 */ 255,211, 17,201, 65,255,211, 17,201,117, 24,255,193, 65,255,211,
/* 0x01e0 */  17,201,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,115,237,
/* 0x01f0 */ 131,193,  2, 72,129,253,  0,251,255,255,131,209,  1,232,  0,  0,
/* 0x0200 */   0,  0,233,117,255,255,255,235,  8, 72,255,198,136, 23, 72,255,
/* 0x0210 */ 199,138, 22,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138,
/* 0x0220 */  22,114,230,141, 65,  1,235,  7,255,200, 65,255,211, 17,192, 65,
/* 0x0230 */ 255,211, 17,192,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,
/* 0x0240 */ 138, 22,115,228,131,232,  3,114, 29,193,224,  8, 15,182,210,  9,
/* 0x0250 */ 208, 72,255,198,131,240,255, 15,132,  0,  0,  0,  0,209,248, 72,
/* 0x0260 */  99,232,114, 56,235, 14,  1,219,117,  8,139, 30, 72,131,238,252,
/* 0x0270 */  17,219,114, 40,255,193,  1,219,117,  8,139, 30, 72,131,238,252,
/* 0x0280 */  17,219,114, 24, 65,255,211, 17,201,  1,219,117,  8,139, 30, 72,
/* 0x0290 */ 131,238,252, 17,219,115,237,131,193,  2,235,  5, 65,255,211, 17,
/* 0x02a0 */ 201, 72,129,253,  0,251,255,255,131,209,  2,232,  0,  0,  0,  0,
/* 0x02b0 */ 233, 92,255,255,255,184,  0,  0,  0,128, 80, 72,137,225, 72,137,
/* 0x02c0 */ 250, 72,137,247,190,  0,  0,  0,128, 85, 72,137,229, 68,139,  9,
/* 0x02d0 */  73,137,208, 72,137,242, 72,141,119,  2, 86,138,  7,255,202,136,
/* 0x02e0 */ 193, 36,  7,192,233,  3, 72,199,195,  0,253,255,255, 72,211,227,
/* 0x02f0 */ 136,193, 72,141,156, 92,136,241,255,255, 72,131,227,192,106,  0,
/* 0x0300 */  72, 57,220,117,249, 83, 72,141,123,  8,138, 78,255,255,202,136,
/* 0x0310 */  71,  2,136,200,192,233,  4,136, 79,  1, 36, 15,136,  7, 72,141,
/* 0x0320 */  79,252, 80, 65, 87, 72,141, 71,  4, 69, 49,255, 65, 86, 65,190,
/* 0x0330 */   1,  0,  0,  0, 65, 85, 69, 49,237, 65, 84, 85, 83, 72,137, 76,
/* 0x0340 */  36,240, 72,137, 68, 36,216,184,  1,  0,  0,  0, 72,137,116, 36,
/* 0x0350 */ 248, 76,137, 68, 36,232,137,195, 68,137, 76, 36,228, 15,182, 79,
/* 0x0360 */   2,211,227,137,217, 72,139, 92, 36, 56,255,201,137, 76, 36,212,
/* 0x0370 */  15,182, 79,  1,211,224, 72,139, 76, 36,240,255,200,137, 68, 36,
/* 0x0380 */ 208, 15,182,  7,199,  1,  0,  0,  0,  0,199, 68, 36,200,  0,  0,
/* 0x0390 */   0,  0,199, 68, 36,196,  1,  0,  0,  0,199, 68, 36,192,  1,  0,
/* 0x03a0 */   0,  0,199, 68, 36,188,  1,  0,  0,  0,199,  3,  0,  0,  0,  0,
/* 0x03b0 */ 137, 68, 36,204, 15,182, 79,  1,  1,193,184,  0,  3,  0,  0,211,
/* 0x03c0 */ 224, 49,201,141,184, 54,  7,  0,  0, 65, 57,255,115, 19, 72,139,
/* 0x03d0 */  92, 36,216,137,200,255,193, 57,249,102,199,  4, 67,  0,  4,235,
/* 0x03e0 */ 235, 72,139,124, 36,248,137,208, 69, 49,210, 65,131,203,255, 49,
/* 0x03f0 */ 210, 73,137,252, 73,  1,196, 76, 57,231, 15,132,239,  8,  0,  0,
/* 0x0400 */  15,182,  7, 65,193,226,  8,255,194, 72,255,199, 65,  9,194,131,
/* 0x0410 */ 250,  4,126,227, 68, 59,124, 36,228, 15,131,218,  8,  0,  0,139,
/* 0x0420 */  68, 36,212, 72, 99, 92, 36,200, 72,139, 84, 36,216, 68, 33,248,
/* 0x0430 */ 137, 68, 36,184, 72, 99,108, 36,184, 72,137,216, 72,193,224,  4,
/* 0x0440 */  72,  1,232, 65,129,251,255,255,255,  0, 76,141, 12, 66,119, 26,
/* 0x0450 */  76, 57,231, 15,132,150,  8,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x0460 */  65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,
/* 0x0470 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,131,197,
/* 0x0480 */   1,  0,  0, 65,137,195,184,  0,  8,  0,  0, 72,139, 92, 36,216,
/* 0x0490 */  41,200, 15,182, 76, 36,204,190,  1,  0,  0,  0,193,248,  5,141,
/* 0x04a0 */   4,  2, 65, 15,182,213,102, 65,137,  1,139, 68, 36,208, 68, 33,
/* 0x04b0 */ 248,211,224,185,  8,  0,  0,  0, 43, 76, 36,204,211,250,  1,208,
/* 0x04c0 */ 105,192,  0,  3,  0,  0,131,124, 36,200,  6,137,192, 76,141,140,
/* 0x04d0 */  67,108, 14,  0,  0, 15,142,184,  0,  0,  0, 72,139, 84, 36,232,
/* 0x04e0 */  68,137,248, 68, 41,240, 15,182, 44,  2,  1,237, 72, 99,214,137,
/* 0x04f0 */ 235,129,227,  0,  1,  0,  0, 65,129,251,255,255,255,  0, 72, 99,
/* 0x0500 */ 195, 73,141,  4, 65, 76,141,  4, 80,119, 26, 76, 57,231, 15,132,
/* 0x0510 */ 219,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x0520 */ 255,199, 65,  9,194, 65, 15,183,144,  0,  2,  0,  0, 68,137,216,
/* 0x0530 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,137,
/* 0x0540 */ 195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,133,219,141,
/* 0x0550 */   4,  2,102, 65,137,128,  0,  2,  0,  0,116, 33,235, 45, 65, 41,
/* 0x0560 */ 195, 65, 41,194,137,208,102,193,232,  5,141,116, 54,  1,102, 41,
/* 0x0570 */ 194,133,219,102, 65,137,144,  0,  2,  0,  0,116, 14,129,254,255,
/* 0x0580 */   0,  0,  0, 15,142, 97,255,255,255,235,120,129,254,255,  0,  0,
/* 0x0590 */   0,127,112, 72, 99,198, 65,129,251,255,255,255,  0, 77,141,  4,
/* 0x05a0 */  65,119, 26, 76, 57,231, 15,132, 67,  7,  0,  0, 15,182,  7, 65,
/* 0x05b0 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,
/* 0x05c0 */  16, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x05d0 */ 115, 24, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,
/* 0x05e0 */   5,141,  4,  2,102, 65,137,  0,235,161, 65, 41,195, 65, 41,194,
/* 0x05f0 */ 137,208,102,193,232,  5,141,116, 54,  1,102, 41,194,102, 65,137,
/* 0x0600 */  16,235,136, 72,139, 76, 36,232, 68,137,248, 65,255,199, 65,137,
/* 0x0610 */ 245, 64,136, 52,  1,131,124, 36,200,  3,127, 13,199, 68, 36,200,
/* 0x0620 */   0,  0,  0,  0,233,166,  6,  0,  0,139, 84, 36,200,139, 68, 36,
/* 0x0630 */ 200,131,234,  3,131,232,  6,131,124, 36,200,  9, 15, 79,208,137,
/* 0x0640 */  84, 36,200,233,135,  6,  0,  0, 65, 41,195, 65, 41,194,137,208,
/* 0x0650 */ 102,193,232,  5,102, 41,194, 72,139, 68, 36,216, 65,129,251,255,
/* 0x0660 */ 255,255,  0,102, 65,137, 17, 72,141, 52, 88,119, 26, 76, 57,231,
/* 0x0670 */  15,132,121,  6,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x0680 */   8, 72,255,199, 65,  9,194, 15,183,150,128,  1,  0,  0, 68,137,
/* 0x0690 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 78, 65,
/* 0x06a0 */ 137,195,184,  0,  8,  0,  0, 76,139, 76, 36,216, 41,200,139, 76,
/* 0x06b0 */  36,196, 68,137,116, 36,196,193,248,  5,141,  4,  2,139, 84, 36,
/* 0x06c0 */ 192,137, 76, 36,192,102,137,134,128,  1,  0,  0, 49,192,131,124,
/* 0x06d0 */  36,200,  6,137, 84, 36,188, 15,159,192, 73,129,193,100,  6,  0,
/* 0x06e0 */   0,141,  4, 64,137, 68, 36,200,233, 84,  2,  0,  0, 65, 41,195,
/* 0x06f0 */  65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,
/* 0x0700 */ 255,255,  0,102,137,150,128,  1,  0,  0,119, 26, 76, 57,231, 15,
/* 0x0710 */ 132,218,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x0720 */  72,255,199, 65,  9,194, 15,183,150,152,  1,  0,  0, 68,137,216,
/* 0x0730 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,131,208,  0,
/* 0x0740 */   0,  0, 65,184,  0,  8,  0,  0, 65,137,195, 72,193,227,  5, 68,
/* 0x0750 */ 137,192, 41,200,193,248,  5,141,  4,  2,102,137,134,152,  1,  0,
/* 0x0760 */   0, 72,139, 68, 36,216, 72,  1,216, 65,129,251,255,255,255,  0,
/* 0x0770 */  72,141, 52,104,119, 26, 76, 57,231, 15,132,112,  5,  0,  0, 15,
/* 0x0780 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x0790 */  15,183,150,224,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202,
/* 0x07a0 */  15,175,193, 65, 57,194,115, 79, 65, 41,200, 65,137,195, 65,193,
/* 0x07b0 */ 248,  5, 69,133,255, 66,141,  4,  2,102,137,134,224,  1,  0,  0,
/* 0x07c0 */  15,132, 41,  5,  0,  0, 49,192,131,124, 36,200,  6, 72,139, 92,
/* 0x07d0 */  36,232, 15,159,192,141, 68,  0,  9,137, 68, 36,200, 68,137,248,
/* 0x07e0 */  68, 41,240, 68, 15,182, 44,  3, 68,137,248, 65,255,199, 68,136,
/* 0x07f0 */  44,  3,233,216,  4,  0,  0, 65, 41,195, 65, 41,194,137,208,102,
/* 0x0800 */ 193,232,  5,102, 41,194,102,137,150,224,  1,  0,  0,233, 17,  1,
/* 0x0810 */   0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,
/* 0x0820 */ 194, 65,129,251,255,255,255,  0,102,137,150,152,  1,  0,  0,119,
/* 0x0830 */  26, 76, 57,231, 15,132,181,  4,  0,  0, 15,182,  7, 65,193,226,
/* 0x0840 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,176,  1,
/* 0x0850 */   0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x0860 */ 194,115, 32, 65,137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,
/* 0x0870 */ 141,  4,  2,102,137,134,176,  1,  0,  0,139, 68, 36,196,233,152,
/* 0x0880 */   0,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,
/* 0x0890 */  41,194, 65,129,251,255,255,255,  0,102,137,150,176,  1,  0,  0,
/* 0x08a0 */ 119, 26, 76, 57,231, 15,132, 68,  4,  0,  0, 15,182,  7, 65,193,
/* 0x08b0 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,200,
/* 0x08c0 */   1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x08d0 */  57,194,115, 29, 65,137,195,184,  0,  8,  0,  0, 41,200,193,248,
/* 0x08e0 */   5,141,  4,  2,102,137,134,200,  1,  0,  0,139, 68, 36,192,235,
/* 0x08f0 */  34, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,
/* 0x0900 */ 139, 68, 36,188,102,137,150,200,  1,  0,  0,139, 84, 36,192,137,
/* 0x0910 */  84, 36,188,139, 76, 36,196,137, 76, 36,192, 68,137,116, 36,196,
/* 0x0920 */  65,137,198, 49,192,131,124, 36,200,  6, 76,139, 76, 36,216, 15,
/* 0x0930 */ 159,192, 73,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36,
/* 0x0940 */ 200, 65,129,251,255,255,255,  0,119, 26, 76, 57,231, 15,132,156,
/* 0x0950 */   3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x0960 */ 199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,183,
/* 0x0970 */ 202, 15,175,193, 65, 57,194,115, 39, 65,137,195,184,  0,  8,  0,
/* 0x0980 */   0, 69, 49,237, 41,200,193,248,  5,141,  4,  2,102, 65,137,  1,
/* 0x0990 */  72, 99, 68, 36,184, 72,193,224,  4, 77,141, 68,  1,  4,235,120,
/* 0x09a0 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,
/* 0x09b0 */ 129,251,255,255,255,  0,102, 65,137, 17,119, 26, 76, 57,231, 15,
/* 0x09c0 */ 132, 42,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x09d0 */  72,255,199, 65,  9,194, 65, 15,183, 81,  2, 68,137,216,193,232,
/* 0x09e0 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 52, 65,137,195,184,
/* 0x09f0 */   0,  8,  0,  0, 65,189,  8,  0,  0,  0, 41,200,193,248,  5,141,
/* 0x0a00 */   4,  2,102, 65,137, 65,  2, 72, 99, 68, 36,184, 72,193,224,  4,
/* 0x0a10 */  77,141,132,  1,  4,  1,  0,  0, 65,185,  3,  0,  0,  0,235, 39,
/* 0x0a20 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5, 77,141,129,  4,
/* 0x0a30 */   2,  0,  0, 65,189, 16,  0,  0,  0,102, 41,194,102, 65,137, 81,
/* 0x0a40 */   2, 65,185,  8,  0,  0,  0, 68,137,203,189,  1,  0,  0,  0, 72,
/* 0x0a50 */  99,197, 65,129,251,255,255,255,  0, 73,141, 52, 64,119, 26, 76,
/* 0x0a60 */  57,231, 15,132,135,  2,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x0a70 */ 193,227,  8, 72,255,199, 65,  9,194, 15,183, 14, 68,137,216,193,
/* 0x0a80 */ 232, 11, 15,183,209, 15,175,194, 65, 57,194,115, 23, 65,137,195,
/* 0x0a90 */ 184,  0,  8,  0,  0,  1,237, 41,208,193,248,  5,141,  4,  1,102,
/* 0x0aa0 */ 137,  6,235, 22, 65, 41,195, 65, 41,194,137,200,102,193,232,  5,
/* 0x0ab0 */ 141,108, 45,  1,102, 41,193,102,137, 14,255,203,117,145,184,  1,
/* 0x0ac0 */   0,  0,  0, 68,137,201,211,224, 41,197, 68,  1,237,131,124, 36,
/* 0x0ad0 */ 200,  3, 15,143,194,  1,  0,  0,131, 68, 36,200,  7,184,  3,  0,
/* 0x0ae0 */   0,  0,131,253,  4, 15, 76,197, 72,139, 92, 36,216, 65,184,  1,
/* 0x0af0 */   0,  0,  0, 72,152, 72,193,224,  7, 76,141,140,  3, 96,  3,  0,
/* 0x0b00 */   0,187,  6,  0,  0,  0, 73, 99,192, 65,129,251,255,255,255,  0,
/* 0x0b10 */  73,141, 52, 65,119, 26, 76, 57,231, 15,132,208,  1,  0,  0, 15,
/* 0x0b20 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x0b30 */  15,183, 22, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x0b40 */  57,194,115, 24, 65,137,195,184,  0,  8,  0,  0, 69,  1,192, 41,
/* 0x0b50 */ 200,193,248,  5,141,  4,  2,102,137,  6,235, 23, 65, 41,195, 65,
/* 0x0b60 */  41,194,137,208,102,193,232,  5, 71,141, 68,  0,  1,102, 41,194,
/* 0x0b70 */ 102,137, 22,255,203,117,143, 65,131,232, 64, 65,131,248,  3, 69,
/* 0x0b80 */ 137,198, 15,142, 13,  1,  0,  0, 65,131,230,  1, 68,137,192,209,
/* 0x0b90 */ 248, 65,131,206,  2, 65,131,248, 13,141,112,255,127, 35,137,241,
/* 0x0ba0 */  72,139, 92, 36,216, 73, 99,192, 65,211,230, 72,  1,192, 68,137,
/* 0x0bb0 */ 242, 72,141, 20, 83, 72, 41,194, 76,141,138, 94,  5,  0,  0,235,
/* 0x0bc0 */  81,141,112,251, 65,129,251,255,255,255,  0,119, 26, 76, 57,231,
/* 0x0bd0 */  15,132, 25,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x0be0 */   8, 72,255,199, 65,  9,194, 65,209,235, 69,  1,246, 69, 57,218,
/* 0x0bf0 */ 114,  7, 69, 41,218, 65,131,206,  1,255,206,117,199, 76,139, 76,
/* 0x0c00 */  36,216, 65,193,230,  4,190,  4,  0,  0,  0, 73,129,193, 68,  6,
/* 0x0c10 */   0,  0, 65,189,  1,  0,  0,  0,187,  1,  0,  0,  0, 72, 99,195,
/* 0x0c20 */  65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231,
/* 0x0c30 */  15,132,185,  0,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x0c40 */   8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,232,
/* 0x0c50 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,
/* 0x0c60 */   0,  8,  0,  0,  1,219, 41,200,193,248,  5,141,  4,  2,102, 65,
/* 0x0c70 */ 137,  0,235, 26, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x0c80 */ 141, 92, 27,  1, 69,  9,238,102, 41,194,102, 65,137, 16, 69,  1,
/* 0x0c90 */ 237,255,206,117,136, 65,255,198,116, 64,131,197,  2, 69, 57,254,
/* 0x0ca0 */ 119, 77, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 68, 15,182,
/* 0x0cb0 */  44,  2, 68,137,248, 65,255,199,255,205, 68,136, 44,  2, 15,149,
/* 0x0cc0 */ 194, 49,192, 68, 59,124, 36,228, 15,146,192,133,194,117,211, 68,
/* 0x0cd0 */  59,124, 36,228, 15,130, 69,247,255,255, 65,129,251,255,255,255,
/* 0x0ce0 */   0,119, 22, 76, 57,231,184,  1,  0,  0,  0,116, 35,235,  7,184,
/* 0x0cf0 */   1,  0,  0,  0,235, 26, 72,255,199,137,248, 43, 68, 36,248, 72,
/* 0x0d00 */ 139, 76, 36,240, 72,139, 92, 36, 56,137,  1, 68,137, 59, 49,192,
/* 0x0d10 */  91, 93, 65, 92, 65, 93, 65, 94, 65, 95, 65, 87, 72,141, 71,  4,
/* 0x0d20 */  69, 49,255, 65, 86, 65,190,  1,  0,  0,  0, 65, 85, 69, 49,237,
/* 0x0d30 */  65, 84, 85, 83, 72,137, 76, 36,240, 72,137, 68, 36,216,184,  1,
/* 0x0d40 */   0,  0,  0, 72,137,116, 36,248, 76,137, 68, 36,232,137,195, 68,
/* 0x0d50 */ 137, 76, 36,228, 15,182, 79,  2,211,227,137,217, 72,139, 92, 36,
/* 0x0d60 */  56,255,201,137, 76, 36,212, 15,182, 79,  1,211,224, 72,139, 76,
/* 0x0d70 */  36,240,255,200,137, 68, 36,208, 15,182,  7,199,  1,  0,  0,  0,
/* 0x0d80 */   0,199, 68, 36,200,  0,  0,  0,  0,199, 68, 36,196,  1,  0,  0,
/* 0x0d90 */   0,199, 68, 36,192,  1,  0,  0,  0,199, 68, 36,188,  1,  0,  0,
/* 0x0da0 */   0,199,  3,  0,  0,  0,  0,137, 68, 36,204, 15,182, 79,  1,  1,
/* 0x0db0 */ 193,184,  0,  3,  0,  0,211,224, 49,201,141,184, 54,  7,  0,  0,
/* 0x0dc0 */  65, 57,255,115, 19, 72,139, 92, 36,216,137,200,255,193, 57,249,
/* 0x0dd0 */ 102,199,  4, 67,  0,  4,235,235, 72,139,124, 36,248,137,208, 69,
/* 0x0de0 */  49,210, 65,131,203,255, 49,210, 73,137,252, 73,  1,196, 76, 57,
/* 0x0df0 */ 231, 15,132,239,  8,  0,  0, 15,182,  7, 65,193,226,  8,255,194,
/* 0x0e00 */  72,255,199, 65,  9,194,131,250,  4,126,227, 68, 59,124, 36,228,
/* 0x0e10 */  15,131,218,  8,  0,  0,139, 68, 36,212, 72, 99, 92, 36,200, 72,
/* 0x0e20 */ 139, 84, 36,216, 68, 33,248,137, 68, 36,184, 72, 99,108, 36,184,
/* 0x0e30 */  72,137,216, 72,193,224,  4, 72,  1,232, 65,129,251,255,255,255,
/* 0x0e40 */   0, 76,141, 12, 66,119, 26, 76, 57,231, 15,132,150,  8,  0,  0,
/* 0x0e50 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x0e60 */ 194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x0e70 */ 193, 65, 57,194, 15,131,197,  1,  0,  0, 65,137,195,184,  0,  8,
/* 0x0e80 */   0,  0, 72,139, 92, 36,216, 41,200, 15,182, 76, 36,204,190,  1,
/* 0x0e90 */   0,  0,  0,193,248,  5,141,  4,  2, 65, 15,182,213,102, 65,137,
/* 0x0ea0 */   1,139, 68, 36,208, 68, 33,248,211,224,185,  8,  0,  0,  0, 43,
/* 0x0eb0 */  76, 36,204,211,250,  1,208,105,192,  0,  3,  0,  0,131,124, 36,
/* 0x0ec0 */ 200,  6,137,192, 76,141,140, 67,108, 14,  0,  0, 15,142,184,  0,
/* 0x0ed0 */   0,  0, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 15,182, 44,
/* 0x0ee0 */   2,  1,237, 72, 99,214,137,235,129,227,  0,  1,  0,  0, 65,129,
/* 0x0ef0 */ 251,255,255,255,  0, 72, 99,195, 73,141,  4, 65, 76,141,  4, 80,
/* 0x0f00 */ 119, 26, 76, 57,231, 15,132,219,  7,  0,  0, 15,182,  7, 65,193,
/* 0x0f10 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,144,
/* 0x0f20 */   0,  2,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x0f30 */  65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,
/* 0x0f40 */ 200,193,248,  5,133,219,141,  4,  2,102, 65,137,128,  0,  2,  0,
/* 0x0f50 */   0,116, 33,235, 45, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x0f60 */   5,141,116, 54,  1,102, 41,194,133,219,102, 65,137,144,  0,  2,
/* 0x0f70 */   0,  0,116, 14,129,254,255,  0,  0,  0, 15,142, 97,255,255,255,
/* 0x0f80 */ 235,120,129,254,255,  0,  0,  0,127,112, 72, 99,198, 65,129,251,
/* 0x0f90 */ 255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,132, 67,
/* 0x0fa0 */   7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x0fb0 */ 199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,232, 11, 15,183,
/* 0x0fc0 */ 202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,
/* 0x0fd0 */   0,  1,246, 41,200,193,248,  5,141,  4,  2,102, 65,137,  0,235,
/* 0x0fe0 */ 161, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,116, 54,
/* 0x0ff0 */   1,102, 41,194,102, 65,137, 16,235,136, 72,139, 76, 36,232, 68,
/* 0x1000 */ 137,248, 65,255,199, 65,137,245, 64,136, 52,  1,131,124, 36,200,
/* 0x1010 */   3,127, 13,199, 68, 36,200,  0,  0,  0,  0,233,166,  6,  0,  0,
/* 0x1020 */ 139, 84, 36,200,139, 68, 36,200,131,234,  3,131,232,  6,131,124,
/* 0x1030 */  36,200,  9, 15, 79,208,137, 84, 36,200,233,135,  6,  0,  0, 65,
/* 0x1040 */  41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 72,139,
/* 0x1050 */  68, 36,216, 65,129,251,255,255,255,  0,102, 65,137, 17, 72,141,
/* 0x1060 */  52, 88,119, 26, 76, 57,231, 15,132,121,  6,  0,  0, 15,182,  7,
/* 0x1070 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,
/* 0x1080 */ 150,128,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x1090 */ 193, 65, 57,194,115, 78, 65,137,195,184,  0,  8,  0,  0, 76,139,
/* 0x10a0 */  76, 36,216, 41,200,139, 76, 36,196, 68,137,116, 36,196,193,248,
/* 0x10b0 */   5,141,  4,  2,139, 84, 36,192,137, 76, 36,192,102,137,134,128,
/* 0x10c0 */   1,  0,  0, 49,192,131,124, 36,200,  6,137, 84, 36,188, 15,159,
/* 0x10d0 */ 192, 73,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36,200,233,
/* 0x10e0 */  84,  2,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x10f0 */ 102, 41,194, 65,129,251,255,255,255,  0,102,137,150,128,  1,  0,
/* 0x1100 */   0,119, 26, 76, 57,231, 15,132,218,  5,  0,  0, 15,182,  7, 65,
/* 0x1110 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,
/* 0x1120 */ 152,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x1130 */  65, 57,194, 15,131,208,  0,  0,  0, 65,184,  0,  8,  0,  0, 65,
/* 0x1140 */ 137,195, 72,193,227,  5, 68,137,192, 41,200,193,248,  5,141,  4,
/* 0x1150 */   2,102,137,134,152,  1,  0,  0, 72,139, 68, 36,216, 72,  1,216,
/* 0x1160 */  65,129,251,255,255,255,  0, 72,141, 52,104,119, 26, 76, 57,231,
/* 0x1170 */  15,132,112,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x1180 */   8, 72,255,199, 65,  9,194, 15,183,150,224,  1,  0,  0, 68,137,
/* 0x1190 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 79, 65,
/* 0x11a0 */  41,200, 65,137,195, 65,193,248,  5, 69,133,255, 66,141,  4,  2,
/* 0x11b0 */ 102,137,134,224,  1,  0,  0, 15,132, 41,  5,  0,  0, 49,192,131,
/* 0x11c0 */ 124, 36,200,  6, 72,139, 92, 36,232, 15,159,192,141, 68,  0,  9,
/* 0x11d0 */ 137, 68, 36,200, 68,137,248, 68, 41,240, 68, 15,182, 44,  3, 68,
/* 0x11e0 */ 137,248, 65,255,199, 68,136, 44,  3,233,216,  4,  0,  0, 65, 41,
/* 0x11f0 */ 195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,102,137,150,
/* 0x1200 */ 224,  1,  0,  0,233, 17,  1,  0,  0, 65, 41,195, 65, 41,194,137,
/* 0x1210 */ 208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,
/* 0x1220 */ 137,150,152,  1,  0,  0,119, 26, 76, 57,231, 15,132,181,  4,  0,
/* 0x1230 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x1240 */   9,194, 15,183,150,176,  1,  0,  0, 68,137,216,193,232, 11, 15,
/* 0x1250 */ 183,202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,
/* 0x1260 */   0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,176,  1,  0,
/* 0x1270 */   0,139, 68, 36,196,233,152,  0,  0,  0, 65, 41,195, 65, 41,194,
/* 0x1280 */ 137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,
/* 0x1290 */ 102,137,150,176,  1,  0,  0,119, 26, 76, 57,231, 15,132, 68,  4,
/* 0x12a0 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x12b0 */  65,  9,194, 15,183,150,200,  1,  0,  0, 68,137,216,193,232, 11,
/* 0x12c0 */  15,183,202, 15,175,193, 65, 57,194,115, 29, 65,137,195,184,  0,
/* 0x12d0 */   8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,200,  1,
/* 0x12e0 */   0,  0,139, 68, 36,192,235, 34, 65, 41,195, 65, 41,194,137,208,
/* 0x12f0 */ 102,193,232,  5,102, 41,194,139, 68, 36,188,102,137,150,200,  1,
/* 0x1300 */   0,  0,139, 84, 36,192,137, 84, 36,188,139, 76, 36,196,137, 76,
/* 0x1310 */  36,192, 68,137,116, 36,196, 65,137,198, 49,192,131,124, 36,200,
/* 0x1320 */   6, 76,139, 76, 36,216, 15,159,192, 73,129,193,104, 10,  0,  0,
/* 0x1330 */ 141, 68, 64,  8,137, 68, 36,200, 65,129,251,255,255,255,  0,119,
/* 0x1340 */  26, 76, 57,231, 15,132,156,  3,  0,  0, 15,182,  7, 65,193,226,
/* 0x1350 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 17, 68,
/* 0x1360 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 39,
/* 0x1370 */  65,137,195,184,  0,  8,  0,  0, 69, 49,237, 41,200,193,248,  5,
/* 0x1380 */ 141,  4,  2,102, 65,137,  1, 72, 99, 68, 36,184, 72,193,224,  4,
/* 0x1390 */  77,141, 68,  1,  4,235,120, 65, 41,195, 65, 41,194,137,208,102,
/* 0x13a0 */ 193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102, 65,137,
/* 0x13b0 */  17,119, 26, 76, 57,231, 15,132, 42,  3,  0,  0, 15,182,  7, 65,
/* 0x13c0 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,
/* 0x13d0 */  81,  2, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x13e0 */ 194,115, 52, 65,137,195,184,  0,  8,  0,  0, 65,189,  8,  0,  0,
/* 0x13f0 */   0, 41,200,193,248,  5,141,  4,  2,102, 65,137, 65,  2, 72, 99,
/* 0x1400 */  68, 36,184, 72,193,224,  4, 77,141,132,  1,  4,  1,  0,  0, 65,
/* 0x1410 */ 185,  3,  0,  0,  0,235, 39, 65, 41,195, 65, 41,194,137,208,102,
/* 0x1420 */ 193,232,  5, 77,141,129,  4,  2,  0,  0, 65,189, 16,  0,  0,  0,
/* 0x1430 */ 102, 41,194,102, 65,137, 81,  2, 65,185,  8,  0,  0,  0, 68,137,
/* 0x1440 */ 203,189,  1,  0,  0,  0, 72, 99,197, 65,129,251,255,255,255,  0,
/* 0x1450 */  73,141, 52, 64,119, 26, 76, 57,231, 15,132,135,  2,  0,  0, 15,
/* 0x1460 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x1470 */  15,183, 14, 68,137,216,193,232, 11, 15,183,209, 15,175,194, 65,
/* 0x1480 */  57,194,115, 23, 65,137,195,184,  0,  8,  0,  0,  1,237, 41,208,
/* 0x1490 */ 193,248,  5,141,  4,  1,102,137,  6,235, 22, 65, 41,195, 65, 41,
/* 0x14a0 */ 194,137,200,102,193,232,  5,141,108, 45,  1,102, 41,193,102,137,
/* 0x14b0 */  14,255,203,117,145,184,  1,  0,  0,  0, 68,137,201,211,224, 41,
/* 0x14c0 */ 197, 68,  1,237,131,124, 36,200,  3, 15,143,194,  1,  0,  0,131,
/* 0x14d0 */  68, 36,200,  7,184,  3,  0,  0,  0,131,253,  4, 15, 76,197, 72,
/* 0x14e0 */ 139, 92, 36,216, 65,184,  1,  0,  0,  0, 72,152, 72,193,224,  7,
/* 0x14f0 */  76,141,140,  3, 96,  3,  0,  0,187,  6,  0,  0,  0, 73, 99,192,
/* 0x1500 */  65,129,251,255,255,255,  0, 73,141, 52, 65,119, 26, 76, 57,231,
/* 0x1510 */  15,132,208,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x1520 */   8, 72,255,199, 65,  9,194, 15,183, 22, 68,137,216,193,232, 11,
/* 0x1530 */  15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,
/* 0x1540 */   8,  0,  0, 69,  1,192, 41,200,193,248,  5,141,  4,  2,102,137,
/* 0x1550 */   6,235, 23, 65, 41,195, 65, 41,194,137,208,102,193,232,  5, 71,
/* 0x1560 */ 141, 68,  0,  1,102, 41,194,102,137, 22,255,203,117,143, 65,131,
/* 0x1570 */ 232, 64, 65,131,248,  3, 69,137,198, 15,142, 13,  1,  0,  0, 65,
/* 0x1580 */ 131,230,  1, 68,137,192,209,248, 65,131,206,  2, 65,131,248, 13,
/* 0x1590 */ 141,112,255,127, 35,137,241, 72,139, 92, 36,216, 73, 99,192, 65,
/* 0x15a0 */ 211,230, 72,  1,192, 68,137,242, 72,141, 20, 83, 72, 41,194, 76,
/* 0x15b0 */ 141,138, 94,  5,  0,  0,235, 81,141,112,251, 65,129,251,255,255,
/* 0x15c0 */ 255,  0,119, 26, 76, 57,231, 15,132, 25,  1,  0,  0, 15,182,  7,
/* 0x15d0 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,209,
/* 0x15e0 */ 235, 69,  1,246, 69, 57,218,114,  7, 69, 41,218, 65,131,206,  1,
/* 0x15f0 */ 255,206,117,199, 76,139, 76, 36,216, 65,193,230,  4,190,  4,  0,
/* 0x1600 */   0,  0, 73,129,193, 68,  6,  0,  0, 65,189,  1,  0,  0,  0,187,
/* 0x1610 */   1,  0,  0,  0, 72, 99,195, 65,129,251,255,255,255,  0, 77,141,
/* 0x1620 */   4, 65,119, 26, 76, 57,231, 15,132,185,  0,  0,  0, 15,182,  7,
/* 0x1630 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,
/* 0x1640 */ 183, 16, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x1650 */ 194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,219, 41,200,193,
/* 0x1660 */ 248,  5,141,  4,  2,102, 65,137,  0,235, 26, 65, 41,195, 65, 41,
/* 0x1670 */ 194,137,208,102,193,232,  5,141, 92, 27,  1, 69,  9,238,102, 41,
/* 0x1680 */ 194,102, 65,137, 16, 69,  1,237,255,206,117,136, 65,255,198,116,
/* 0x1690 */  64,131,197,  2, 69, 57,254,119, 77, 72,139, 84, 36,232, 68,137,
/* 0x16a0 */ 248, 68, 41,240, 68, 15,182, 44,  2, 68,137,248, 65,255,199,255,
/* 0x16b0 */ 205, 68,136, 44,  2, 15,149,194, 49,192, 68, 59,124, 36,228, 15,
/* 0x16c0 */ 146,192,133,194,117,211, 68, 59,124, 36,228, 15,130, 69,247,255,
/* 0x16d0 */ 255, 65,129,251,255,255,255,  0,119, 22, 76, 57,231,184,  1,  0,
/* 0x16e0 */   0,  0,116, 35,235,  7,184,  1,  0,  0,  0,235, 26, 72,255,199,
/* 0x16f0 */ 137,248, 43, 68, 36,248, 72,139, 76, 36,240, 72,139, 92, 36, 56,
/* 0x1700 */ 137,  1, 68,137, 59, 49,192, 91, 93, 65, 92, 65, 93, 65, 94, 65,
/* 0x1710 */  95, 72,139,117,248, 72,139,125, 16,139, 75,  4, 72,  1,206,139,
/* 0x1720 */  19, 72,  1,215,201,201, 88, 94, 95, 88,137,  7, 72,141,190,  0,
/* 0x1730 */   0,  0,  0, 72,137,247,185,  0,  0,  0,  0,178,  0, 72,137,251,
/* 0x1740 */ 235, 44,138,  7, 72,131,199,  1, 60,128,114, 10, 60,143,119,  6,
/* 0x1750 */ 128,127,254, 15,116,  6, 44,232, 60,  1,119, 35, 56, 23,117, 31,
/* 0x1760 */ 139,  7, 37,  0,255,255,255, 15,200, 41,248,  1,216,171, 72,131,
/* 0x1770 */ 233,  4,138,  7, 72,131,199,  1, 72,255,201,117,217,235,  5, 72,
/* 0x1780 */ 255,201,117,190, 72,131,236, 40, 72,141,190,  0,  0,  0,  0,139,
/* 0x1790 */   7,  9,192,116,255,139, 95,  4, 72,141,140, 48,  0,  0,  0,  0,
/* 0x17a0 */  72,  1,243, 72,131,199,  8,255,150,  0,  0,  0,  0, 72,149,138,
/* 0x17b0 */   7, 72,255,199,  8,192,116,215,121,255,122, 16,139,  7, 72,131,
/* 0x17c0 */ 199,  4, 72,139,132, 48,  0,  0,  0,  0,235,255, 72, 15,183, 23,
/* 0x17d0 */  72,131,199,  2,235,255, 72,137,249, 72,137,250,255,200,242,174,
/* 0x17e0 */  72,137,233,255,150,  0,  0,  0,  0, 72,  9,192,116,  9, 72,137,
/* 0x17f0 */   3, 72,131,195,  8,235,255, 72,131,196, 40, 93, 95, 94, 91, 49,
/* 0x1800 */ 192,195,255,166,  0,  0,  0,  0, 72,131,196, 40, 72,141,190,  0,
/* 0x1810 */   0,  0,  0, 72,131,199,  4, 72,141, 94,252, 49,192,138,  7, 72,
/* 0x1820 */ 255,199,  9,192,116,255, 60,239,119, 17, 72,  1,195, 72,139,  3,
/* 0x1830 */  72, 15,200, 72,  1,240, 72,137,  3,235,224, 36, 15,193,224, 16,
/* 0x1840 */ 102,139,  7, 72,131,199,  2,  9,192,117,255,139,  7, 72,131,199,
/* 0x1850 */   4,235,255, 72,135,247, 72,141,143,  0,  0,  0,  0,235,  4,102,
/* 0x1860 */   1, 12,  7,173,  9,192,117,247,193,233, 16,235,  4,102,  1, 12,
/* 0x1870 */   7,173,  9,192,117,247, 72,139,174,  0,  0,  0,  0, 72,141,190,
/* 0x1880 */   0,  0,  0,  0,187,  0,  0,  0,128, 80, 73,137,225, 65,184,  4,
/* 0x1890 */   0,  0,  0, 72,137,218, 72,137,249, 72,131,236, 32,255,213, 72,
/* 0x18a0 */ 141,135,  0,  0,  0,  0,128, 32,127,128, 96, 40,127, 76,141, 76,
/* 0x18b0 */  36, 32, 77,139,  1, 72,137,218, 72,137,249,255,213, 72,131,196,
/* 0x18c0 */  40,198,  5,  0,  0,  0,  0,252, 72,141,142,  0,  0,  0,  0,106,
/* 0x18d0 */   1, 90, 77, 49,192, 80,232,  0,  0,  0,  0, 88, 93, 95, 94, 91,
/* 0x18e0 */  72,141, 68, 36,128,106,  0, 72, 57,196,117,249, 72,131,236,128,
/* 0x18f0 */  76,139, 68, 36, 24, 72,139, 84, 36, 16, 72,139, 76, 36,  8,106,
/* 0x1900 */   1, 88,195,233,  0,  0,  0,  0,195, 86, 72,141, 53,  0,  0,  0,
/* 0x1910 */   0, 72,173, 72,133,192,116, 20, 81, 82, 65, 80, 72,131,236, 40,
/* 0x1920 */ 255,208, 72,131,196, 40, 65, 88, 90, 89,235,229, 94,195, 85, 80,
/* 0x1930 */  88, 33,161,216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1940 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,102,105,
/* 0x1950 */ 108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 54, 52, 45,
/* 0x1960 */ 120, 56, 54, 45, 54, 52, 10, 10, 83,101, 99,116,105,111,110,115,
/* 0x1970 */  58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32,
/* 0x1980 */  32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77,
/* 0x1990 */  65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x19a0 */  76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x19b0 */  32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110,
/* 0x19c0 */  32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 83, 84, 65, 82,
/* 0x19d0 */  84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x19e0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x19f0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a00 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 48,
/* 0x1a10 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1a20 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 80,
/* 0x1a30 */  69, 73, 83, 68, 76, 76, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1a40 */  48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a50 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1a70 */  48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1a80 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1a90 */  50, 32, 80, 69, 73, 83, 68, 76, 76, 49, 32, 32, 32, 32, 32, 32,
/* 0x1aa0 */  48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1ab0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1ac0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1ad0 */  48, 48, 48, 48, 52,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1ae0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x1af0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 80, 69, 77, 65,
/* 0x1b00 */  73, 78, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1b10 */  49, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b20 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b30 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 53, 56,
/* 0x1b40 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1b50 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1b60 */  89, 10, 32, 32, 52, 32, 80, 69, 73, 67, 79, 78, 83, 49, 32, 32,
/* 0x1b70 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48,
/* 0x1b80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1b90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ba0 */  32, 32, 48, 48, 48, 48, 48, 48, 54, 97, 32, 32, 50, 42, 42, 48,
/* 0x1bb0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x1bc0 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32,
/* 0x1bd0 */  80, 69, 73, 67, 79, 78, 83, 50, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x1be0 */  48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1bf0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1c00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1c10 */  48, 48, 55, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1c20 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x1c30 */  68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 80, 69, 84, 76, 83, 72,
/* 0x1c40 */  65, 75, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 48,
/* 0x1c50 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c60 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c70 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 97, 32, 32,
/* 0x1c80 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1c90 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1ca0 */  32, 32, 55, 32, 80, 69, 77, 65, 73, 78, 48, 50, 32, 32, 32, 32,
/* 0x1cb0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48,
/* 0x1cc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1cd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1ce0 */  48, 48, 48, 48, 48, 48, 56, 97, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1cf0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1d00 */  76, 89, 10, 32, 32, 56, 32, 80, 69, 77, 65, 73, 78, 48, 51, 32,
/* 0x1d10 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1d20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1d30 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d40 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 56, 98, 32, 32, 50, 42, 42,
/* 0x1d50 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x1d60 */  68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 78, 82, 86, 95, 72, 69,
/* 0x1d70 */  65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 54, 48,
/* 0x1d80 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d90 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1da0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56, 98, 32, 32,
/* 0x1db0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1dc0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 78, 82, 86,
/* 0x1dd0 */  50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1de0 */  48, 56, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1df0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e00 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101,
/* 0x1e10 */  98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1e20 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1e30 */  76, 89, 10, 32, 49, 49, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32,
/* 0x1e40 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 57, 53, 32, 32, 48,
/* 0x1e50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1e60 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e70 */  48, 32, 32, 48, 48, 48, 48, 48, 49, 55, 50, 32, 32, 50, 42, 42,
/* 0x1e80 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x1e90 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 50,
/* 0x1ea0 */  32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x1eb0 */  48, 48, 48, 48, 48, 97,101, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ec0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1ed0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1ee0 */  48, 48, 50, 48, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1ef0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x1f00 */  65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 76, 90, 77, 65, 95,
/* 0x1f10 */  72, 69, 65, 68, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,
/* 0x1f20 */  52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f30 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f40 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 98, 53, 32,
/* 0x1f50 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1f60 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1f70 */  10, 32, 49, 52, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32,
/* 0x1f80 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 53, 97, 32, 32, 48, 48, 48,
/* 0x1f90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1fa0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1fb0 */  32, 48, 48, 48, 48, 48, 50, 99, 57, 32, 32, 50, 42, 42, 48, 32,
/* 0x1fc0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x1fd0 */  78, 76, 89, 10, 32, 49, 53, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x1fe0 */  49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57,102, 55, 32, 32,
/* 0x1ff0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2000 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2010 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 50, 51, 32, 32, 50, 42,
/* 0x2020 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2030 */  65, 68, 79, 78, 76, 89, 10, 32, 49, 54, 32, 76, 90, 77, 65, 95,
/* 0x2040 */  68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57,102,
/* 0x2050 */  55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2060 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2070 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,100, 49, 97, 32,
/* 0x2080 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2090 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 55, 32, 76, 90,
/* 0x20a0 */  77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x20b0 */  48, 48, 49, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x20c0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x20d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55,
/* 0x20e0 */  49, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x20f0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 56,
/* 0x2100 */  32, 76, 90, 77, 65, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 48,
/* 0x2110 */  48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2120 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2130 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2140 */  48, 49, 55, 50, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2150 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2160 */  32, 49, 57, 32, 80, 69, 77, 65, 73, 78, 49, 48, 32, 32, 32, 32,
/* 0x2170 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48,
/* 0x2180 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2190 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x21a0 */  48, 48, 48, 48, 49, 55, 50, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x21b0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x21c0 */  76, 89, 10, 32, 50, 48, 32, 80, 69, 84, 76, 83, 72, 65, 75, 50,
/* 0x21d0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48,
/* 0x21e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x21f0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2200 */  48, 32, 32, 48, 48, 48, 48, 49, 55, 50, 56, 32, 32, 50, 42, 42,
/* 0x2210 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x2220 */  68, 79, 78, 76, 89, 10, 32, 50, 49, 32, 80, 69, 67, 84, 84, 80,
/* 0x2230 */  79, 83, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x2240 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2250 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2260 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 50, 99, 32, 32,
/* 0x2270 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2280 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2290 */  32, 50, 50, 32, 80, 69, 67, 84, 84, 78, 85, 76, 32, 32, 32, 32,
/* 0x22a0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48,
/* 0x22b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x22c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x22d0 */  48, 48, 48, 48, 49, 55, 51, 51, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x22e0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x22f0 */  76, 89, 10, 32, 50, 51, 32, 80, 69, 70, 73, 76, 84, 69, 82, 52,
/* 0x2300 */  57, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 52,101, 32, 32, 48,
/* 0x2310 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2320 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2330 */  48, 32, 32, 48, 48, 48, 48, 49, 55, 51, 54, 32, 32, 50, 42, 42,
/* 0x2340 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x2350 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 52,
/* 0x2360 */  32, 80, 69, 73, 77, 80, 79, 82, 84, 32, 32, 32, 32, 32, 32, 48,
/* 0x2370 */  48, 48, 48, 48, 48, 51, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2380 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2390 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x23a0 */  48, 49, 55, 56, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x23b0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x23c0 */  65, 68, 79, 78, 76, 89, 10, 32, 50, 53, 32, 80, 69, 73, 66, 89,
/* 0x23d0 */  79, 82, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x23e0 */  50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x23f0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2400 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 98, 56, 32,
/* 0x2410 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2420 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2430 */  10, 32, 50, 54, 32, 80, 69, 75, 51, 50, 79, 82, 68, 32, 32, 32,
/* 0x2440 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 50, 32, 32, 48, 48, 48,
/* 0x2450 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2460 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2470 */  32, 48, 48, 48, 48, 49, 55, 98, 97, 32, 32, 50, 42, 42, 48, 32,
/* 0x2480 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x2490 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 55, 32, 80,
/* 0x24a0 */  69, 73, 77, 79, 82, 68, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x24b0 */  48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24c0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x24d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x24e0 */  55, 99, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x24f0 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x2500 */  79, 78, 76, 89, 10, 32, 50, 56, 32, 80, 69, 73, 77, 80, 79, 82,
/* 0x2510 */  50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 49, 32,
/* 0x2520 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2530 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2540 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55,100, 54, 32, 32, 50,
/* 0x2550 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2560 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2570 */  50, 57, 32, 80, 69, 73, 69, 82, 68, 76, 76, 32, 32, 32, 32, 32,
/* 0x2580 */  32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48,
/* 0x2590 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x25a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x25b0 */  48, 48, 48, 49, 55,102, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x25c0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x25d0 */  89, 10, 32, 51, 48, 32, 80, 69, 73, 69, 82, 69, 88, 69, 32, 32,
/* 0x25e0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48,
/* 0x25f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2600 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2610 */  32, 32, 48, 48, 48, 48, 49, 56, 48, 50, 32, 32, 50, 42, 42, 48,
/* 0x2620 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x2630 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 49, 32,
/* 0x2640 */  80, 69, 73, 77, 68, 79, 78, 69, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2650 */  48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2660 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2670 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2680 */  49, 56, 48, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2690 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x26a0 */  51, 50, 32, 80, 69, 82, 69, 76, 79, 67, 49, 32, 32, 32, 32, 32,
/* 0x26b0 */  32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48,
/* 0x26c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x26d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x26e0 */  48, 48, 48, 49, 56, 48, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x26f0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x2700 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 51, 32, 80, 69, 82,
/* 0x2710 */  69, 76, 79, 67, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2720 */  48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2730 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2740 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 49,
/* 0x2750 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2760 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 52, 32,
/* 0x2770 */  80, 69, 82, 69, 76, 79, 67, 51, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2780 */  48, 48, 48, 48, 51, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2790 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x27a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x27b0 */  49, 56, 49, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x27c0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x27d0 */  68, 79, 78, 76, 89, 10, 32, 51, 53, 32, 82, 69, 76, 54, 52, 66,
/* 0x27e0 */  73, 71, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 97,
/* 0x27f0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2800 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2810 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 52, 55, 32, 32,
/* 0x2820 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2830 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2840 */  32, 51, 54, 32, 82, 69, 76, 79, 67, 54, 52, 74, 32, 32, 32, 32,
/* 0x2850 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,
/* 0x2860 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2870 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2880 */  48, 48, 48, 48, 49, 56, 53, 49, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2890 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x28a0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 55, 32, 80, 69,
/* 0x28b0 */  82, 76, 79, 72, 73, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x28c0 */  48, 48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x28d0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x28e0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,
/* 0x28f0 */  53, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2900 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2910 */  78, 76, 89, 10, 32, 51, 56, 32, 80, 69, 82, 69, 76, 76, 79, 48,
/* 0x2920 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32,
/* 0x2930 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2940 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2950 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 53,100, 32, 32, 50, 42,
/* 0x2960 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2970 */  65, 68, 79, 78, 76, 89, 10, 32, 51, 57, 32, 80, 69, 82, 69, 76,
/* 0x2980 */  72, 73, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2990 */ 101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x29a0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x29b0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 54, 56, 32,
/* 0x29c0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x29d0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 48, 32, 80, 69,
/* 0x29e0 */  68, 69, 80, 72, 65, 75, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x29f0 */  48, 48, 52, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a00 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a10 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,
/* 0x2a20 */  55, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2a30 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2a40 */  78, 76, 89, 10, 32, 52, 49, 32, 80, 69, 84, 76, 83, 67, 32, 32,
/* 0x2a50 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 98, 32, 32,
/* 0x2a60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a70 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a80 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 99, 49, 32, 32, 50, 42,
/* 0x2a90 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2aa0 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52,
/* 0x2ab0 */  50, 32, 80, 69, 77, 65, 73, 78, 50, 48, 32, 32, 32, 32, 32, 32,
/* 0x2ac0 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2ad0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2ae0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2af0 */  48, 48, 49, 56,100, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2b00 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2b10 */  10, 32, 52, 51, 32, 67, 76, 69, 65, 82, 83, 84, 65, 67, 75, 32,
/* 0x2b20 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 48, 32, 32, 48, 48, 48,
/* 0x2b30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2b40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2b50 */  32, 48, 48, 48, 48, 49, 56,101, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x2b60 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x2b70 */  78, 76, 89, 10, 32, 52, 52, 32, 80, 69, 77, 65, 73, 78, 50, 49,
/* 0x2b80 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2b90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ba0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2bb0 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 56,102, 48, 32, 32, 50, 42,
/* 0x2bc0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2bd0 */  65, 68, 79, 78, 76, 89, 10, 32, 52, 53, 32, 80, 69, 73, 83, 68,
/* 0x2be0 */  76, 76, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2bf0 */ 102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c00 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c10 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,102, 48, 32,
/* 0x2c20 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2c30 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 54, 32, 80, 69,
/* 0x2c40 */  82, 69, 84, 85, 82, 78, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2c50 */  48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c60 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c70 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,
/* 0x2c80 */ 102,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2c90 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 55,
/* 0x2ca0 */  32, 80, 69, 68, 79, 74, 85, 77, 80, 32, 32, 32, 32, 32, 32, 48,
/* 0x2cb0 */  48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2cc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2cd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2ce0 */  48, 49, 57, 48, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2cf0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x2d00 */  65, 68, 79, 78, 76, 89, 10, 32, 52, 56, 32, 80, 69, 84, 76, 83,
/* 0x2d10 */  67, 50, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50,
/* 0x2d20 */  54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d30 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d40 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 48, 56, 32,
/* 0x2d50 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2d60 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2d70 */  10, 32, 52, 57, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32,
/* 0x2d80 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 48, 32, 32, 48, 48, 48,
/* 0x2d90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2da0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2db0 */  32, 48, 48, 48, 48, 49, 57, 50,101, 32, 32, 50, 42, 42, 48, 32,
/* 0x2dc0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x2dd0 */  78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69,
/* 0x2de0 */  58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2df0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 72,
/* 0x2e00 */  69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e10 */  48, 48, 48, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48,
/* 0x2e20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x2e30 */  32, 32, 32, 32,100, 32, 32, 80, 69, 77, 65, 73, 78, 49, 48,  9,
/* 0x2e40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e50 */  32, 80, 69, 77, 65, 73, 78, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x2e60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2e70 */  32, 32, 32, 80, 69, 73, 77, 68, 79, 78, 69,  9, 48, 48, 48, 48,
/* 0x2e80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,105,109,112,
/* 0x2e90 */ 111,114,116,115, 95,100,111,110,101, 10, 48, 48, 48, 48, 48, 48,
/* 0x2ea0 */  48, 48, 48, 48, 48, 48, 48, 48, 50, 98, 32,108, 32, 32, 32, 32,
/* 0x2eb0 */  32, 32, 32, 80, 69, 73, 77, 80, 79, 82, 84,  9, 48, 48, 48, 48,
/* 0x2ec0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,110,101,120,
/* 0x2ed0 */ 116, 95,102,117,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ee0 */  48, 48, 48, 48, 48, 48, 97, 32,108, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ef0 */  80, 69, 73, 77, 79, 82, 68, 49,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 98,121,110, 97,109,101,
/* 0x2f10 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x2f20 */  56, 32,108, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 80, 79,
/* 0x2f30 */  82, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f40 */  48, 48, 48, 32,110,101,120,116, 95,105,109,112, 10, 48, 48, 48,
/* 0x2f50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 32,108, 32,
/* 0x2f60 */  32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 80, 79, 82, 50,  9, 48,
/* 0x2f70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2f80 */ 102,105,114,115,116, 95,105,109,112, 10, 48, 48, 48, 48, 48, 48,
/* 0x2f90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 32,108, 32, 32, 32, 32,
/* 0x2fa0 */  32, 32, 32, 82, 69, 76, 79, 67, 54, 52, 74,  9, 48, 48, 48, 48,
/* 0x2fb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,114,101,108,
/* 0x2fc0 */ 111, 99, 95,101,110,100,120, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2fd0 */  48, 48, 48, 48, 48, 48, 49, 51, 32,108, 32, 32, 32, 32, 32, 32,
/* 0x2fe0 */  32, 80, 69, 82, 69, 76, 79, 67, 51,  9, 48, 48, 48, 48, 48, 48,
/* 0x2ff0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,114,101,108,111, 99,
/* 0x3000 */  95, 97,100,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3010 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3020 */  84, 76, 83, 67, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3030 */  48, 48, 48, 48, 48, 48, 32, 80, 69, 84, 76, 83, 67, 50, 10, 48,
/* 0x3040 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3050 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 77, 65, 73, 78, 50, 49,
/* 0x3060 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3070 */  48, 32, 80, 69, 77, 65, 73, 78, 50, 49, 10, 48, 48, 48, 48, 48,
/* 0x3080 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3090 */  32,100, 32, 32, 83, 84, 65, 82, 84,  9, 48, 48, 48, 48, 48, 48,
/* 0x30a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 83, 84, 65, 82, 84,
/* 0x30b0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x30c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 83, 68, 76,
/* 0x30d0 */  76, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x30e0 */  48, 48, 48, 32, 80, 69, 73, 83, 68, 76, 76, 48, 10, 48, 48, 48,
/* 0x30f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3100 */  32, 32, 32,100, 32, 32, 80, 69, 73, 83, 68, 76, 76, 49,  9, 48,
/* 0x3110 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3120 */  80, 69, 73, 83, 68, 76, 76, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3130 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3140 */  32, 32, 80, 69, 77, 65, 73, 78, 48, 49,  9, 48, 48, 48, 48, 48,
/* 0x3150 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65,
/* 0x3160 */  73, 78, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3170 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3180 */  73, 67, 79, 78, 83, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3190 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 67, 79, 78, 83, 49,
/* 0x31a0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x31b0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 67, 79, 78,
/* 0x31c0 */  83, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x31d0 */  48, 48, 48, 32, 80, 69, 73, 67, 79, 78, 83, 50, 10, 48, 48, 48,
/* 0x31e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x31f0 */  32, 32, 32,100, 32, 32, 80, 69, 84, 76, 83, 72, 65, 75,  9, 48,
/* 0x3200 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3210 */  80, 69, 84, 76, 83, 72, 65, 75, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3220 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3230 */  32, 32, 80, 69, 77, 65, 73, 78, 48, 50,  9, 48, 48, 48, 48, 48,
/* 0x3240 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65,
/* 0x3250 */  73, 78, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3260 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3270 */  77, 65, 73, 78, 48, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3280 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65, 73, 78, 48, 51,
/* 0x3290 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x32a0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66,  9,
/* 0x32b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x32c0 */  32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x32d0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x32e0 */  78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x32f0 */  48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x3300 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3310 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69,  9, 48, 48, 48, 48,
/* 0x3320 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x3330 */  50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3340 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x3350 */  95, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3360 */  48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 72, 69, 65, 68,
/* 0x3370 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3380 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69,
/* 0x3390 */  76, 70, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x33a0 */  48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x33b0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x33c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x33d0 */  69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x33e0 */  48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x33f0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3400 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3410 */  69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3420 */  48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x3430 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3440 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3450 */  69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3460 */  48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x3470 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3480 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 84,
/* 0x3490 */  65, 73, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x34a0 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 84, 65, 73, 76, 10, 48,
/* 0x34b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x34c0 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 84, 76, 83, 72, 65, 75,
/* 0x34d0 */  50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x34e0 */  48, 48, 32, 80, 69, 84, 76, 83, 72, 65, 75, 50, 10, 48, 48, 48,
/* 0x34f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3500 */  32, 32, 32,100, 32, 32, 80, 69, 67, 84, 84, 80, 79, 83,  9, 48,
/* 0x3510 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3520 */  80, 69, 67, 84, 84, 80, 79, 83, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3530 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3540 */  32, 32, 80, 69, 67, 84, 84, 78, 85, 76,  9, 48, 48, 48, 48, 48,
/* 0x3550 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 67, 84,
/* 0x3560 */  84, 78, 85, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3570 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3580 */  70, 73, 76, 84, 69, 82, 52, 57,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x3590 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 70, 73, 76, 84,
/* 0x35a0 */  69, 82, 52, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x35b0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x35c0 */  73, 77, 80, 79, 82, 84,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x35d0 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 77, 80, 79, 82, 84,
/* 0x35e0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x35f0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 66, 89, 79,
/* 0x3600 */  82, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3610 */  48, 48, 48, 32, 80, 69, 73, 66, 89, 79, 82, 68, 10, 48, 48, 48,
/* 0x3620 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3630 */  32, 32, 32,100, 32, 32, 80, 69, 75, 51, 50, 79, 82, 68,  9, 48,
/* 0x3640 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3650 */  80, 69, 75, 51, 50, 79, 82, 68, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3660 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3670 */  32, 32, 80, 69, 73, 77, 79, 82, 68, 49,  9, 48, 48, 48, 48, 48,
/* 0x3680 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 77,
/* 0x3690 */  79, 82, 68, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x36a0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x36b0 */  73, 77, 80, 79, 82, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x36c0 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 77, 80, 79, 82, 50,
/* 0x36d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x36e0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 69, 82, 68,
/* 0x36f0 */  76, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3700 */  48, 48, 48, 32, 80, 69, 73, 69, 82, 68, 76, 76, 10, 48, 48, 48,
/* 0x3710 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3720 */  32, 32, 32,100, 32, 32, 80, 69, 73, 69, 82, 69, 88, 69,  9, 48,
/* 0x3730 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3740 */  80, 69, 73, 69, 82, 69, 88, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3750 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3760 */  32, 32, 80, 69, 73, 77, 68, 79, 78, 69,  9, 48, 48, 48, 48, 48,
/* 0x3770 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 77,
/* 0x3780 */  68, 79, 78, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3790 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x37a0 */  82, 69, 76, 79, 67, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x37b0 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82, 69, 76, 79, 67, 49,
/* 0x37c0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x37d0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69, 76, 79,
/* 0x37e0 */  67, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x37f0 */  48, 48, 48, 32, 80, 69, 82, 69, 76, 79, 67, 50, 10, 48, 48, 48,
/* 0x3800 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3810 */  32, 32, 32,100, 32, 32, 80, 69, 82, 69, 76, 79, 67, 51,  9, 48,
/* 0x3820 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3830 */  80, 69, 82, 69, 76, 79, 67, 51, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3840 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3850 */  32, 32, 82, 69, 76, 54, 52, 66, 73, 71,  9, 48, 48, 48, 48, 48,
/* 0x3860 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 69, 76, 54,
/* 0x3870 */  52, 66, 73, 71, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3880 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 82, 69,
/* 0x3890 */  76, 79, 67, 54, 52, 74,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x38a0 */  48, 48, 48, 48, 48, 48, 48, 32, 82, 69, 76, 79, 67, 54, 52, 74,
/* 0x38b0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x38c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 76, 79, 72,
/* 0x38d0 */  73, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x38e0 */  48, 48, 48, 32, 80, 69, 82, 76, 79, 72, 73, 48, 10, 48, 48, 48,
/* 0x38f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3900 */  32, 32, 32,100, 32, 32, 80, 69, 82, 69, 76, 76, 79, 48,  9, 48,
/* 0x3910 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3920 */  80, 69, 82, 69, 76, 76, 79, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3930 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3940 */  32, 32, 80, 69, 82, 69, 76, 72, 73, 48,  9, 48, 48, 48, 48, 48,
/* 0x3950 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82, 69,
/* 0x3960 */  76, 72, 73, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3970 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3980 */  68, 69, 80, 72, 65, 75,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3990 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 68, 69, 80, 72, 65, 75,
/* 0x39a0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x39b0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 84, 76, 83, 67,
/* 0x39c0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x39d0 */  48, 32, 80, 69, 84, 76, 83, 67, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x39e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x39f0 */  32, 32, 80, 69, 77, 65, 73, 78, 50, 48,  9, 48, 48, 48, 48, 48,
/* 0x3a00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65,
/* 0x3a10 */  73, 78, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a20 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76,
/* 0x3a30 */  69, 65, 82, 83, 84, 65, 67, 75,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 69, 65, 82, 83,
/* 0x3a50 */  84, 65, 67, 75, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a60 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3a70 */  73, 83, 68, 76, 76, 57,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a80 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 83, 68, 76, 76, 57,
/* 0x3a90 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3aa0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69, 84, 85,
/* 0x3ab0 */  82, 78,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ac0 */  48, 48, 48, 32, 80, 69, 82, 69, 84, 85, 82, 78, 10, 48, 48, 48,
/* 0x3ad0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3ae0 */  32, 32, 32,100, 32, 32, 80, 69, 68, 79, 74, 85, 77, 80,  9, 48,
/* 0x3af0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3b00 */  80, 69, 68, 79, 74, 85, 77, 80, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3b20 */  32, 32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48,
/* 0x3b30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 85, 80, 88, 49,
/* 0x3b40 */  72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b50 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x3b60 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b70 */  48, 48, 48, 48, 32,115,116, 97,114,116, 95,111,102, 95, 99,111,
/* 0x3b80 */ 109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x3ba0 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3bb0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,115,116, 97,114,116, 95,111,
/* 0x3bc0 */ 102, 95,117,110, 99,111,109,112,114,101,115,115,101,100, 10, 48,
/* 0x3bd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3be0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x3bf0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,105,
/* 0x3c00 */  99,111,110, 95,111,102,102,115,101,116, 10, 48, 48, 48, 48, 48,
/* 0x3c10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x3c20 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x3c30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,105, 99,111,110, 95,
/* 0x3c40 */ 100,101,108,116, 97, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c50 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x3c60 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c70 */  48, 48, 48, 48, 48, 32,116,108,115, 95, 97,100,100,114,101,115,
/* 0x3c80 */ 115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c90 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x3ca0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3cb0 */  48, 32,116,108,115, 95,118, 97,108,117,101, 10, 48, 48, 48, 48,
/* 0x3cc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x3cd0 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x3ce0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97,
/* 0x3cf0 */  95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d00 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3d10 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d20 */  48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95, 99, 95,108,101,
/* 0x3d30 */ 110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d40 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x3d50 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d60 */  48, 32,102,105,108,116,101,114, 95, 98,117,102,102,101,114, 95,
/* 0x3d70 */ 115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d80 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x3d90 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3da0 */  48, 48, 48, 48, 48, 32,102,105,108,116,101,114, 95,108,101,110,
/* 0x3db0 */ 103,116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3dc0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x3dd0 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3de0 */  48, 48, 48, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48,
/* 0x3df0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3e00 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x3e10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,
/* 0x3e20 */ 111,109,112,114,101,115,115,101,100, 95,105,109,112,111,114,116,
/* 0x3e30 */ 115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e40 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x3e50 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e60 */  48, 32,115,116, 97,114,116, 95,111,102, 95,105,109,112,111,114,
/* 0x3e70 */ 116,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e80 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x3e90 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ea0 */  48, 48, 32, 76,111, 97,100, 76,105, 98,114, 97,114,121, 65, 10,
/* 0x3eb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ec0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,
/* 0x3ed0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3ee0 */ 107,101,114,110,101,108, 51, 50, 95,111,114,100,105,110, 97,108,
/* 0x3ef0 */ 115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f00 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x3f10 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f20 */  48, 32, 71,101,116, 80,114,111, 99, 65,100,100,114,101,115,115,
/* 0x3f30 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f40 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x3f50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f60 */  32, 69,120,105,116, 80,114,111, 99,101,115,115, 10, 48, 48, 48,
/* 0x3f70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x3f80 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x3f90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,116, 97,
/* 0x3fa0 */ 114,116, 95,111,102, 95,114,101,108,111, 99,115, 10, 48, 48, 48,
/* 0x3fb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x3fc0 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x3fd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,114,101,108,
/* 0x3fe0 */ 111, 99, 95,100,101,108,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ff0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4000 */  32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4010 */  48, 48, 48, 48, 48, 48, 48, 32, 86,105,114,116,117, 97,108, 80,
/* 0x4020 */ 114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4030 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4040 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4050 */  48, 48, 48, 48, 48, 48, 32,118,112, 95, 98, 97,115,101, 10, 48,
/* 0x4060 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4070 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x4080 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,118,
/* 0x4090 */ 112, 95,115,105,122,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40a0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x40b0 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40c0 */  48, 48, 48, 48, 48, 48, 32,115,119,114,105, 10, 48, 48, 48, 48,
/* 0x40d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x40e0 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x40f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,116,108,115, 95,
/* 0x4100 */ 109,111,100,117,108,101, 95, 98, 97,115,101, 10, 48, 48, 48, 48,
/* 0x4110 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x4120 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x4130 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,111,114,105,103,
/* 0x4140 */ 105,110, 97,108, 95,101,110,116,114,121, 10, 48, 48, 48, 48, 48,
/* 0x4150 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x4160 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x4170 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,116,108,115, 95, 99,
/* 0x4180 */  97,108,108, 98, 97, 99,107,115, 95,112,116,114, 10, 10, 82, 69,
/* 0x4190 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x41a0 */  32, 70, 79, 82, 32, 91, 80, 69, 73, 83, 68, 76, 76, 49, 93, 58,
/* 0x41b0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x41c0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x41d0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x41e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 88, 56, 54,
/* 0x41f0 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 80, 69, 77,
/* 0x4200 */  65, 73, 78, 50, 49, 45, 48,120, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4210 */  48, 48, 48, 48, 48, 48, 48, 52, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4220 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4230 */  32, 91, 80, 69, 77, 65, 73, 78, 48, 49, 93, 58, 10, 79, 70, 70,
/* 0x4240 */  83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89,
/* 0x4250 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4260 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4270 */  48, 48, 48, 48, 48, 55, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4280 */  80, 67, 51, 50, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,
/* 0x4290 */ 102, 95, 99,111,109,112,114,101,115,115,101,100, 45, 48,120, 48,
/* 0x42a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10,
/* 0x42b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x42c0 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32,
/* 0x42d0 */  32, 32, 32,115,116, 97,114,116, 95,111,102, 95,117,110, 99,111,
/* 0x42e0 */ 109,112,114,101,115,115,101,100, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x42f0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4300 */  32, 91, 80, 69, 73, 67, 79, 78, 83, 49, 93, 58, 10, 79, 70, 70,
/* 0x4310 */  83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89,
/* 0x4320 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4330 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4340 */  48, 48, 48, 48, 48, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4350 */  51, 50, 83, 32, 32, 32, 32, 32, 32,105, 99,111,110, 95,111,102,
/* 0x4360 */ 102,115,101,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4370 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69,
/* 0x4380 */  73, 67, 79, 78, 83, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4390 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x43a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x43b0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x43c0 */  48, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32,
/* 0x43d0 */  32, 32, 32, 32, 32,105, 99,111,110, 95,111,102,102,115,101,116,
/* 0x43e0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x43f0 */  55, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 49, 54, 32, 32, 32,
/* 0x4400 */  32, 32, 32, 32,105, 99,111,110, 95,100,101,108,116, 97, 43, 48,
/* 0x4410 */ 120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 48, 48,
/* 0x4420 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4430 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 84, 76, 83,
/* 0x4440 */  72, 65, 75, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x4450 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x4460 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x4470 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x4480 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32, 32,
/* 0x4490 */  32, 32,116,108,115, 95, 97,100,100,114,101,115,115, 10, 48, 48,
/* 0x44a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 32, 82,
/* 0x44b0 */  95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x44c0 */  32,116,108,115, 95,118, 97,108,117,101, 43, 48,120, 48, 48, 48,
/* 0x44d0 */  48, 48, 48, 48, 48, 56, 48, 48, 48, 48, 48, 48, 48, 10, 10, 82,
/* 0x44e0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x44f0 */  83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79,
/* 0x4500 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4510 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4520 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4530 */  48, 48, 48, 48, 48, 48, 56, 49, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4540 */  52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 78, 82, 86, 95, 72,
/* 0x4550 */  69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4560 */  48, 48, 48, 48, 49, 98, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4570 */  48, 48, 48, 48, 48, 52, 57, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x4580 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 80, 69, 77, 65, 73, 78,
/* 0x4590 */  49, 48, 45, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x45a0 */  48, 48, 48, 48, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x45b0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x45c0 */  82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x45d0 */  32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x45e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x45f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 99,
/* 0x4600 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32,
/* 0x4610 */  32, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 43, 48,120, 48, 48,
/* 0x4620 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 98, 10, 48,
/* 0x4630 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 50, 32,
/* 0x4640 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x4650 */  32, 32, 80, 69, 77, 65, 73, 78, 49, 48, 45, 48,120, 48, 48, 48,
/* 0x4660 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 10, 82,
/* 0x4670 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x4680 */  83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79,
/* 0x4690 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x46a0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x46b0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x46c0 */  48, 48, 48, 48, 48, 48, 97, 53, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x46d0 */  52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 78, 82, 86, 95, 72,
/* 0x46e0 */  69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x46f0 */  48, 48, 48, 48, 49, 98, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4700 */  48, 48, 48, 48, 48, 53, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x4710 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 80, 69, 77, 65, 73, 78,
/* 0x4720 */  49, 48, 45, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4730 */  48, 48, 48, 48, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4740 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,
/* 0x4750 */  90, 77, 65, 95, 72, 69, 65, 68, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4760 */  84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69,
/* 0x4770 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4780 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4790 */  48, 48, 48, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50,
/* 0x47a0 */  32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,117, 95,108,101,
/* 0x47b0 */ 110, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 56, 48, 48, 48,
/* 0x47c0 */  48, 48, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x47d0 */  48, 48, 48, 49, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51,
/* 0x47e0 */  50, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,108,
/* 0x47f0 */ 101,110, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 56, 48, 48,
/* 0x4800 */  48, 48, 48, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4810 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80,
/* 0x4820 */  69, 67, 84, 84, 80, 79, 83, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4830 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4840 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4850 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4860 */  48, 48, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83,
/* 0x4870 */  32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 98,117,102,
/* 0x4880 */ 102,101,114, 95,115,116, 97,114,116, 10, 10, 82, 69, 76, 79, 67,
/* 0x4890 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x48a0 */  82, 32, 91, 80, 69, 70, 73, 76, 84, 69, 82, 52, 57, 93, 58, 10,
/* 0x48b0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x48c0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x48d0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x48e0 */  48, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 88, 56, 54, 95,
/* 0x48f0 */  54, 52, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,
/* 0x4900 */ 101,114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48,
/* 0x4910 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 88, 56, 54,
/* 0x4920 */  95, 54, 52, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,
/* 0x4930 */ 116,101,114, 95, 99,116,111, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4940 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4950 */  91, 80, 69, 73, 77, 80, 79, 82, 84, 93, 58, 10, 79, 70, 70, 83,
/* 0x4960 */  69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80,
/* 0x4970 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x4980 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4990 */  48, 48, 48, 48, 55, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51,
/* 0x49a0 */  50, 83, 32, 32, 32, 32, 32, 32, 99,111,109,112,114,101,115,115,
/* 0x49b0 */ 101,100, 95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48,
/* 0x49c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 88, 56,
/* 0x49d0 */  54, 95, 54, 52, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,105,109,
/* 0x49e0 */ 112,111,114,116,115, 95,100,111,110,101, 10, 48, 48, 48, 48, 48,
/* 0x49f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 56, 32, 82, 95, 88, 56,
/* 0x4a00 */  54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,115,116,
/* 0x4a10 */  97,114,116, 95,111,102, 95,105,109,112,111,114,116,115, 10, 48,
/* 0x4a20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 53, 32,
/* 0x4a30 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32, 32,
/* 0x4a40 */  32, 32, 76,111, 97,100, 76,105, 98,114, 97,114,121, 65, 10, 10,
/* 0x4a50 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4a60 */  68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 66, 89, 79, 82, 68,
/* 0x4a70 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32,
/* 0x4a80 */  32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4a90 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4aa0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 88,
/* 0x4ab0 */  56, 54, 95, 54, 52, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 98,
/* 0x4ac0 */ 121,110, 97,109,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4ad0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80,
/* 0x4ae0 */  69, 75, 51, 50, 79, 82, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4af0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4b00 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4b10 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b20 */  48, 48, 99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83,
/* 0x4b30 */  32, 32, 32, 32, 32, 32,107,101,114,110,101,108, 51, 50, 95,111,
/* 0x4b40 */ 114,100,105,110, 97,108,115, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b50 */  48, 48, 48, 48, 48, 48, 49, 49, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4b60 */  52, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,110,101,120,116, 95,
/* 0x4b70 */ 105,109,112, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4b80 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73,
/* 0x4b90 */  77, 79, 82, 68, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4ba0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4bb0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4bc0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4bd0 */  57, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 56, 32, 32,
/* 0x4be0 */  32, 32, 32, 32,102,105,114,115,116, 95,105,109,112, 10, 10, 82,
/* 0x4bf0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x4c00 */  83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 77, 80, 79, 82, 50, 93,
/* 0x4c10 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4c20 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4c30 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4c40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 88, 56,
/* 0x4c50 */  54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32, 71,101,
/* 0x4c60 */ 116, 80,114,111, 99, 65,100,100,114,101,115,115, 10, 48, 48, 48,
/* 0x4c70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 48, 32, 82, 95,
/* 0x4c80 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x4c90 */ 110,101,120,116, 95,102,117,110, 99, 10, 10, 82, 69, 76, 79, 67,
/* 0x4ca0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x4cb0 */  82, 32, 91, 80, 69, 73, 69, 82, 69, 88, 69, 93, 58, 10, 79, 70,
/* 0x4cc0 */  70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84,
/* 0x4cd0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ce0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4cf0 */  48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x4d00 */  95, 51, 50, 83, 32, 32, 32, 32, 32, 32, 69,120,105,116, 80,114,
/* 0x4d10 */ 111, 99,101,115,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4d20 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80,
/* 0x4d30 */  69, 82, 69, 76, 79, 67, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4d40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4d50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4d60 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d70 */  48, 48, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83,
/* 0x4d80 */  32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95,114,
/* 0x4d90 */ 101,108,111, 99,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4da0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80,
/* 0x4db0 */  69, 82, 69, 76, 79, 67, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4dc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4dd0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4de0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4df0 */  48, 48,101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 56,
/* 0x4e00 */  32, 32, 32, 32, 32, 32,114,101,108,111, 99, 95,101,110,100,120,
/* 0x4e10 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4e20 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 82, 69, 76, 54, 52, 66,
/* 0x4e30 */  73, 71, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x4e40 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4e50 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4e60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x4e70 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x4e80 */  32,114,101,108,111, 99, 95, 97,100,100, 10, 10, 82, 69, 76, 79,
/* 0x4e90 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x4ea0 */  79, 82, 32, 91, 82, 69, 76, 79, 67, 54, 52, 74, 93, 58, 10, 79,
/* 0x4eb0 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ec0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ed0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ee0 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4ef0 */  52, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,114,101,108,111, 99,
/* 0x4f00 */  95, 97,100,100, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4f10 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69,
/* 0x4f20 */  82, 76, 79, 72, 73, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4f30 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x4f40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x4f50 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f60 */  48, 54, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32,
/* 0x4f70 */  32, 32, 32, 32, 32,114,101,108,111, 99, 95,100,101,108,116, 10,
/* 0x4f80 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x4f90 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 68, 69, 80, 72, 65,
/* 0x4fa0 */  75, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32,
/* 0x4fb0 */  32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4fc0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4fd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95,
/* 0x4fe0 */  88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,
/* 0x4ff0 */  86,105,114,116,117, 97,108, 80,114,111,116,101, 99,116, 10, 48,
/* 0x5000 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 32,
/* 0x5010 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32, 32,
/* 0x5020 */  32, 32,118,112, 95, 98, 97,115,101, 10, 48, 48, 48, 48, 48, 48,
/* 0x5030 */  48, 48, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 88, 56, 54,
/* 0x5040 */  95, 54, 52, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,118,112, 95,
/* 0x5050 */ 115,105,122,101, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 56,
/* 0x5060 */  48, 48, 48, 48, 48, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5070 */  48, 48, 48, 48, 48, 48, 50, 99, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x5080 */  52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,115,119,114,105, 10,
/* 0x5090 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x50a0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 84, 76, 83, 67, 93,
/* 0x50b0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x50c0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x50d0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x50e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 88, 56,
/* 0x50f0 */  54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 80, 69,
/* 0x5100 */  84, 76, 83, 67, 50, 45, 48,120, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5110 */  48, 48, 48, 48, 48, 48, 48, 53, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5120 */  48, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 88, 56, 54, 95,
/* 0x5130 */  54, 52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,116,108,115, 95,
/* 0x5140 */ 109,111,100,117,108,101, 95, 98, 97,115,101, 10, 48, 48, 48, 48,
/* 0x5150 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 54, 32, 82, 95, 88,
/* 0x5160 */  56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 80,
/* 0x5170 */  69, 84, 76, 83, 67, 50, 45, 48,120, 48, 48, 48, 48, 48, 48, 48,
/* 0x5180 */  48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 10, 82, 69, 76, 79, 67,
/* 0x5190 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x51a0 */  82, 32, 91, 80, 69, 68, 79, 74, 85, 77, 80, 93, 58, 10, 79, 70,
/* 0x51b0 */  70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84,
/* 0x51c0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x51d0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x51e0 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x51f0 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32,111,114,105,103,105,110,
/* 0x5200 */  97,108, 95,101,110,116,114,121, 45, 48,120, 48, 48, 48, 48, 48,
/* 0x5210 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 10, 82, 69, 76,
/* 0x5220 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5230 */  70, 79, 82, 32, 91, 80, 69, 84, 76, 83, 67, 50, 93, 58, 10, 79,
/* 0x5240 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5250 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5260 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5270 */  48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x5280 */  52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,116,108,115, 95, 99,
/* 0x5290 */  97,108,108, 98, 97, 99,107,115, 95,112,116,114, 45, 48,120, 48,
/* 0x52a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10
};
